/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.HeadTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class LocaTable
implements Table {
    private DirectoryEntry _de;
    private int[] _offsets = null;
    private short _factor = 0;

    protected LocaTable(DirectoryEntry directoryEntry, DataInput dataInput, HeadTable headTable, MaxpTable maxpTable) throws IOException {
        boolean bl;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._offsets = new int[maxpTable.getNumGlyphs() + 1];
        boolean bl2 = bl = headTable.getIndexToLocFormat() == 0;
        if (bl) {
            this._factor = (short)2;
            for (int i = 0; i <= maxpTable.getNumGlyphs(); ++i) {
                this._offsets[i] = dataInput.readUnsignedShort();
            }
        } else {
            this._factor = 1;
            for (int i = 0; i <= maxpTable.getNumGlyphs(); ++i) {
                this._offsets[i] = dataInput.readInt();
            }
        }
    }

    public int getOffset(int n) {
        if (this._offsets == null) {
            return 0;
        }
        return this._offsets[n] * this._factor;
    }

    @Override
    public int getType() {
        return 1819239265;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'loca' Table - Index To Location Table\n--------------------------------------\n").append("Size = ").append(this._de.getLength()).append(" bytes, ").append(this._offsets.length).append(" entries\n");
        for (int i = 0; i < this._offsets.length; ++i) {
            stringBuffer.append("        Idx ").append(i).append(" -> glyfOff 0x").append(this.getOffset(i)).append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

