(ns ^:no-doc unReasoner.preprocessing
 (:require [clojure.java.io :as io][clojure.string :as s]
           [unReasoner.model :as mdl]
           [ontology.normalize :as norm][ontology.core :as ont]
           [util.core :as msc]))

(defn addIndividualToYesSet 
 [set individual] 
 (if (not set) 
  [#{individual} #{}] 
  (let [[y n] set] [(conj y individual) n])))

(defn addIndividualToNoSet 
 [set individual]
 (if (not set) 
  [#{} #{individual}] 
  (let [[y n] set] [y (conj n individual)])))

(defn process
 ([ontology](reduce process [(update ontology :axioms #{}) mdl/init] (ont/getAxiomsNoAnnotations ontology)))
 ([ontology model axiom][(ont/addAxiom ontology axiom) (mdl/updateModel model axiom)])
 ([[ontology model] axiom]
  (case (:innerType axiom)
   
   ;regular class axiom
   :classImplication (process ontology model axiom)

   ;syntactically equivalent to regular class axiom
   :roleDomain (process ontology model (norm/toSyntacticEquivalent axiom))
   :roleRange (process ontology model (norm/toSyntacticEquivalent axiom))
   :functionalRole (process ontology model (norm/toSyntacticEquivalent axiom))
   :functionalInverseRole (process ontology model (norm/toSyntacticEquivalent axiom))
   :reflexiveRole (process ontology model (norm/toSyntacticEquivalent axiom))
   :irreflexiveRole (process ontology model (norm/toSyntacticEquivalent axiom))
   :dataRoleDomain (process ontology model (norm/toSyntacticEquivalent axiom))
   :dataRoleRange (process ontology model (norm/toSyntacticEquivalent axiom))
   :functionalDataRole (process ontology model (norm/toSyntacticEquivalent axiom))

   ;syntactically equivalent to sets of class axioms
   :=classes (loop [parts (ont/toSyntacticEquivalent axiom) 
                    om [ontology model]]
             (if (empty? parts) 
              om 
              (recur (rest parts) (process om (first parts)))))
   :disjClasses (loop [parts (ont/toSyntacticEquivalent axiom) 
                       om [ontology model]]
                (if (empty? parts) 
                 om 
                 (recur (rest parts) (process om (first parts)))))
   :disjOr (loop [parts (ont/toSyntacticEquivalent axiom) 
                  om [ontology model]]
           (if (empty? parts) 
            om 
            (recur (rest parts) (process om (first parts)))))

   ;TODO role axioms
   :roleImplication (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :=roles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq set
   :disjRoles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :inverseRoles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq set
   :symmetricRole (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq
   :transitiveRole (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq
   :asymmetricRole (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   
   ;TODO data role axioms
   :dataRoleImplication (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :=dataRoles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))) ;has syneq set
   :disjDataRoles (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   
   ;facts
   :classFact (let [norm (norm/getCSNF (:class axiom))]
               (if (= (:innerType norm) :and)
                (loop [classes (:classes norm)
                       om [ontology model]]
                 (if (empty? classes)
                  om
                  (recur (rest classes) (process om (assoc axiom :class (first classes))))))
                (if (= (:innerType norm) :not)
                 [(ont/addAxiom ontology axiom) (update-in model [:facts norm] addIndividualToNoSet (:individual axiom))]
                 [(ont/addAxiom ontology axiom) (update-in model [:facts norm] addIndividualToYesSet (:individual axiom))])))
   :roleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:role axiom)] addIndividualToYesSet [(:fromIndividual axiom) (:toIndividual axiom)])]
   :notRoleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:role axiom)] addIndividualToNoSet [(:fromIndividual axiom) (:toIndividual axiom)])]
   :dataRoleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:dataRole axiom)] addIndividualToYesSet [(:fromIndividual axiom) (:toLiteral axiom)])]
   :notDataRoleFact  [(ont/addAxiom ontology axiom) (update-in model [:facts (:dataRole axiom)] addIndividualToNoSet [(:fromIndividual axiom) (:toLiteral axiom)])]
   :=individuals [(ont/addAxiom ontology axiom) (update-in model [:facts :=] addIndividualToYesSet (:individuals axiom))]
   :!=individuals [(ont/addAxiom ontology axiom) (update-in model [:facts :=] addIndividualToNoSet (:individuals axiom))]

   ;TODO weird guys
   :declaration (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :newDataType (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :hasKey (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :annotationAxiom (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :dgRule (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :dlSafeRule (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom})))
   :dgAxiom (throw (Exception. (str  {:type ::undefinedBehaviorForAxiom :axiom axiom}))))))
