(ns ^:no-doc unReasoner.model
 (:require [clojure.java.io :as io]
           [unReasoner.boolean :as bool]
           [ontology.core :as ont][ontology.normalize :as norm]
           [util.core :as msc]))

(def ^:no-doc init
  (hash-map
   ;:classNames #{}
   ;:roleNames #{}
   ;:dataRoleNames #{}
   :classAxiomsUnfolded {}
   :classAxiomsGeneral {} 
   :roleDefinitions {}
   ;:classHierarchy {ont/Top ont/Bot} 
   ;:roleHierarchy {ont/TopRole ont/BotRole}
   :facts {}
   ;:cyclic false
   ;:satisfiable true
   ; TODO
  ))

(defn- updateNames
 [model names]
 model)

(defn- updateClassDefinitions
 [model axiom]
 model)

(defn- primitiveDefinition
 [model axiom]
 (if (= (:innerType axiom) :classImplication)
  false
  false))

(defn- unfold
 "(i) Initialise a set G = {¬D, C}, representing the axiom in the form T ⊑ ¬⊓{¬D, C} (i.e. T ⊑ D ⊔ ¬C).

  (ii) If for some A ∈ G there is a primitive definition axiom (A ⊑ C) ∈ T u , then absorb the general axiom into the primitive definition axiom so that it becomes
        
        A ⊑ ⊓{C, ¬⊓(G \\ {A})},

  and exit.

  (iii) If for some A ∈ G there is an axiom (A ≡ D) ∈ Tu , then substitute A ∈ G with D

       G → {D} ∪ G \\ {A},

  and return to step (ii).

  (iv) If for some ¬A ∈ G there is an axiom (A ≡ D) ∈ Tu , then substitute ¬A ∈ G with ¬D

       G → {¬D} ∪ G \\ {¬A},

  and return to step (ii).

  (v) If there is some C ∈ G such that C is of the form ⊓S, then use associativity to simplify G
      
      G → S ∪ G \\ {⊓S},

  and return to step (ii).

  (vi) If there is some C ∈ G such that C is of the form ¬uS, then for every D ∈ S try to absorb (recursively)
     
     {¬D} ∪ G \\ {¬⊓S},

  and exit.

  (vii) Otherwise, the axiom could not be absorbed, so add ¬⊓G to Tg'

      Tg' → Tg' ∪ ¬⊓G,

  and exit."
 [model axiom]
 (loop [csnfAxiom (norm/getCSNF axiom)
        classSet (disj (ont/getClasses csnfAxiom) csnfAxiom (:class csnfAxiom))
        Tg (:classAxiomsGeneral model)
        Tu (:classAxiomsUnfolded model)]
  (prn classSet))
 model)

(comment 

)

(defn- updateClassHierarchy
 [model]
 model)

(defn- updateRoleHierarchy
 [model]
 model)

(defn updateModel
 [model axiom](prn axiom)
 (let [model (updateNames model (ont/getNames axiom))
       model (updateClassDefinitions model axiom)
       model (if-let [addDef (primitiveDefinition model axiom)] addDef (unfold model axiom))
       model (updateClassHierarchy model)
       model (updateRoleHierarchy model)]
  model))