(ns ^:no-doc unReasoner.preprocessing
 (:require [clojure.java.io :as io][clojure.string :as str]
           [unReasoner.model :as mdl]
           [ontology.normalize :as norm][ontology.core :as ont]
           [util.core :as msc]))


(defn preProcess 
 [[ontology model] axiom]
 (if (not (:cyclic model))
  (let [ontology (ont/addAxiom ontology axiom)
        namesBefore (ont/getPredicateNames (case (:innerType axiom)  :classImplication (:antecedent axiom) :=classes (first (:classes axiom))))
        normal (norm/getCSNF 
                (case (:innerType axiom)              
                 :classImplication (:consequent axiom)
                 :=classes (if (= 1 (rest (:classes axiom)))
                            (first (rest (:classes axiom)))
                            (throw (Exception. (str  {:type ::undefinedBehavior :axiom axiom}))))
                ))       
        namesAfter (ont/getNames normal)
        uniqueNames (apply disj namesAfter namesBefore)
        acyclic (if (= uniqueNames namesAfter)
                 (= (apply disj uniqueNames (keys (:classDefinitions model))) uniqueNames)
                 (throw (Exception. (str  {:type ::undefinedBehavior :axiom axiom}))))
        _ (if (seq? normal)
           (msc/strToFile "norm.txt" (str "Original " axiom "\nCSNF     " (str/join "\n         " normal) "\n"))
           (msc/strToFile "norm.txt" (str "Original " axiom "\nCSNF     "  normal "\n")))]
  (cond 
   (= 1 (count namesBefore))
    [ontology (mdl/updateModel model (apply conj namesBefore namesAfter) (first namesBefore) namesAfter #(if % (ont/and % normal) normal))]
   :else [ontology model]
   ))
  [ontology model]))

(defn process
 ([axioms](reduce process [ont/emptyOntologyFile mdl/init] axioms))
 ([[ontology model] axiom]
  (case (:innerType axiom)
   :classImplication (preProcess [ontology model] axiom)
   :=classes (preProcess [ontology model] axiom)
   :classFact [(ont/addAxiom ontology axiom) 
               (update-in model [:facts (:class axiom)] 
               (fn [in new] (if (not in) [#{new} #{}] (let [[y n] in] [(conj y new) n])))

               (:individual axiom))]
   )))
