(ns ^:no-doc unReasoner.model
 (:require [clojure.java.io :as io][clojure.string :as str][clojure.walk :as walk]
           [unReasoner.boolean :as bool]
           [ontology.core :as ont]
           [util.core :as msc]))

(def ^:no-doc init
  {:classNames #{}
   :roleNames #{}
   :dataRoleNames #{}
   :classDefinitions {}
   :roleDefinitions {}
   :classHierarchy {ont/Top ont/Bot} 
   :roleHierarchy {ont/TopRole ont/BotRole}
   :facts {}
   :cyclic false
   :satisfiable true
   ; TODO
  })

(defn- updateNames
 [model names]
  (let [classes (into #{} (filter #(= (:innerType %) :className) names)) 
        roles (into #{} (filter #(= (:innerType %) :roleName) names)) 
        dataRoles (into #{} (filter #(= (:innerType %) :dataRoleName) names))]
  (update (update (update model :classNames #(apply conj % classes)) :roleNames #(apply conj % roles)) :dataRoleNames #(apply conj % dataRoles))))

(defn- updateClassDefinitions
 ([model key val fun]
  (loop [defs (:classDefinitions model)
         model model]
   (cond
    (some true? (map (partial contains? val) (keys defs))) ; TODO fix resolvable 
     (update-in (update model :cyclic (constantly true)) [:classDefinitions key] fun)
    (or (empty? defs)(= (first (first defs)) key))
     (update-in model [:classDefinitions key] fun)
    :else
     (recur (rest defs) model))))
 ([model key val fun & args]
  (loop [defs (:classDefinitions model)]
  (cond
   (or (empty? defs)(= (first (first defs)) key))
    (update-in model [:classDefinitions key] fun args)
   :else
    (recur (rest defs))))))

(defn- unfold
 [model c]
 (println "unfold" model)
 (if (:cyclic model)
  model
 (loop [dfs (:classDefinitions model)
        ks (into () (disj (into #{} (keys dfs)) c))]
  (if (empty? ks)
   (update model :classDefinitions (constantly dfs))
   (recur (update dfs (first ks) (constantly

   (walk/prewalk (fn [v] (if (dfs v) (dfs v) v))  (get dfs (first ks)))

  )) (rest ks)))))
 )

(defn- updateClassHierarchy
 [model]
 (cond
  (:cyclic model) model
  (and (empty? (:classDefinitions model)) (= 1 (count (:classHierarchy model)))) model
  :else model))

(defn- updateRoleHierarchy
 [model]
 (cond
  (:cyclic model) model
  (and (empty? (:roleDefinitions model)) (= 1 (count (:roleHierarchy model)))) model
  :else model))

(defn updateModel
 ([model names class df fun]
  (if (:cyclic model)
   model
   (-> model
      (updateNames names)
      (updateClassDefinitions class df fun) ; TODO true cycle escape
      (update :satisfiable (constantly (bool/satExpressions (:classDefinitions model))))
      (unfold class)
      updateClassHierarchy
      updateRoleHierarchy
      )))
 ([model names class df fun & args]
  (if (:cyclic model)
   model
   (-> model
      (updateNames names)
      (updateClassDefinitions class df fun args)
      (update :satisfiable (constantly (bool/satExpressions (:classDefinitions model))))
      (unfold class)
      updateClassHierarchy
      updateRoleHierarchy
      ))))