// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args10640 = [];
var len__7484__auto___10646 = arguments.length;
var i__7485__auto___10647 = (0);
while(true){
if((i__7485__auto___10647 < len__7484__auto___10646)){
args10640.push((arguments[i__7485__auto___10647]));

var G__10648 = (i__7485__auto___10647 + (1));
i__7485__auto___10647 = G__10648;
continue;
} else {
}
break;
}

var G__10642 = args10640.length;
switch (G__10642) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10640.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async10643 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10643 = (function (f,blockable,meta10644){
this.f = f;
this.blockable = blockable;
this.meta10644 = meta10644;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10643.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10645,meta10644__$1){
var self__ = this;
var _10645__$1 = this;
return (new cljs.core.async.t_cljs$core$async10643(self__.f,self__.blockable,meta10644__$1));
});

cljs.core.async.t_cljs$core$async10643.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10645){
var self__ = this;
var _10645__$1 = this;
return self__.meta10644;
});

cljs.core.async.t_cljs$core$async10643.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async10643.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async10643.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async10643.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async10643.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta10644","meta10644",1394932119,null)], null);
});

cljs.core.async.t_cljs$core$async10643.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10643.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10643";

cljs.core.async.t_cljs$core$async10643.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async10643");
});

cljs.core.async.__GT_t_cljs$core$async10643 = (function cljs$core$async$__GT_t_cljs$core$async10643(f__$1,blockable__$1,meta10644){
return (new cljs.core.async.t_cljs$core$async10643(f__$1,blockable__$1,meta10644));
});

}

return (new cljs.core.async.t_cljs$core$async10643(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args10652 = [];
var len__7484__auto___10655 = arguments.length;
var i__7485__auto___10656 = (0);
while(true){
if((i__7485__auto___10656 < len__7484__auto___10655)){
args10652.push((arguments[i__7485__auto___10656]));

var G__10657 = (i__7485__auto___10656 + (1));
i__7485__auto___10656 = G__10657;
continue;
} else {
}
break;
}

var G__10654 = args10652.length;
switch (G__10654) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10652.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args10659 = [];
var len__7484__auto___10662 = arguments.length;
var i__7485__auto___10663 = (0);
while(true){
if((i__7485__auto___10663 < len__7484__auto___10662)){
args10659.push((arguments[i__7485__auto___10663]));

var G__10664 = (i__7485__auto___10663 + (1));
i__7485__auto___10663 = G__10664;
continue;
} else {
}
break;
}

var G__10661 = args10659.length;
switch (G__10661) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10659.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args10666 = [];
var len__7484__auto___10669 = arguments.length;
var i__7485__auto___10670 = (0);
while(true){
if((i__7485__auto___10670 < len__7484__auto___10669)){
args10666.push((arguments[i__7485__auto___10670]));

var G__10671 = (i__7485__auto___10670 + (1));
i__7485__auto___10670 = G__10671;
continue;
} else {
}
break;
}

var G__10668 = args10666.length;
switch (G__10668) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10666.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_10673 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_10673);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_10673,ret){
return (function (){
return fn1.call(null,val_10673);
});})(val_10673,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args10674 = [];
var len__7484__auto___10677 = arguments.length;
var i__7485__auto___10678 = (0);
while(true){
if((i__7485__auto___10678 < len__7484__auto___10677)){
args10674.push((arguments[i__7485__auto___10678]));

var G__10679 = (i__7485__auto___10678 + (1));
i__7485__auto___10678 = G__10679;
continue;
} else {
}
break;
}

var G__10676 = args10674.length;
switch (G__10676) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10674.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___10681 = n;
var x_10682 = (0);
while(true){
if((x_10682 < n__7324__auto___10681)){
(a[x_10682] = (0));

var G__10683 = (x_10682 + (1));
x_10682 = G__10683;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__10684 = (i + (1));
i = G__10684;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async10688 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10688 = (function (alt_flag,flag,meta10689){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta10689 = meta10689;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10688.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_10690,meta10689__$1){
var self__ = this;
var _10690__$1 = this;
return (new cljs.core.async.t_cljs$core$async10688(self__.alt_flag,self__.flag,meta10689__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async10688.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_10690){
var self__ = this;
var _10690__$1 = this;
return self__.meta10689;
});})(flag))
;

cljs.core.async.t_cljs$core$async10688.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async10688.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async10688.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async10688.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async10688.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta10689","meta10689",-1550181451,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async10688.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10688.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10688";

cljs.core.async.t_cljs$core$async10688.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async10688");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async10688 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async10688(alt_flag__$1,flag__$1,meta10689){
return (new cljs.core.async.t_cljs$core$async10688(alt_flag__$1,flag__$1,meta10689));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async10688(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async10694 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10694 = (function (alt_handler,flag,cb,meta10695){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta10695 = meta10695;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10694.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10696,meta10695__$1){
var self__ = this;
var _10696__$1 = this;
return (new cljs.core.async.t_cljs$core$async10694(self__.alt_handler,self__.flag,self__.cb,meta10695__$1));
});

cljs.core.async.t_cljs$core$async10694.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10696){
var self__ = this;
var _10696__$1 = this;
return self__.meta10695;
});

cljs.core.async.t_cljs$core$async10694.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async10694.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async10694.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async10694.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async10694.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta10695","meta10695",1382430134,null)], null);
});

cljs.core.async.t_cljs$core$async10694.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10694.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10694";

cljs.core.async.t_cljs$core$async10694.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async10694");
});

cljs.core.async.__GT_t_cljs$core$async10694 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async10694(alt_handler__$1,flag__$1,cb__$1,meta10695){
return (new cljs.core.async.t_cljs$core$async10694(alt_handler__$1,flag__$1,cb__$1,meta10695));
});

}

return (new cljs.core.async.t_cljs$core$async10694(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10697_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10697_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10698_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10698_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__10699 = (i + (1));
i = G__10699;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___10705 = arguments.length;
var i__7485__auto___10706 = (0);
while(true){
if((i__7485__auto___10706 < len__7484__auto___10705)){
args__7491__auto__.push((arguments[i__7485__auto___10706]));

var G__10707 = (i__7485__auto___10706 + (1));
i__7485__auto___10706 = G__10707;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__10702){
var map__10703 = p__10702;
var map__10703__$1 = ((((!((map__10703 == null)))?((((map__10703.cljs$lang$protocol_mask$partition0$ & (64))) || (map__10703.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10703):map__10703);
var opts = map__10703__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq10700){
var G__10701 = cljs.core.first.call(null,seq10700);
var seq10700__$1 = cljs.core.next.call(null,seq10700);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10701,seq10700__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args10708 = [];
var len__7484__auto___10758 = arguments.length;
var i__7485__auto___10759 = (0);
while(true){
if((i__7485__auto___10759 < len__7484__auto___10758)){
args10708.push((arguments[i__7485__auto___10759]));

var G__10760 = (i__7485__auto___10759 + (1));
i__7485__auto___10759 = G__10760;
continue;
} else {
}
break;
}

var G__10710 = args10708.length;
switch (G__10710) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10708.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__10595__auto___10762 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___10762){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___10762){
return (function (state_10734){
var state_val_10735 = (state_10734[(1)]);
if((state_val_10735 === (7))){
var inst_10730 = (state_10734[(2)]);
var state_10734__$1 = state_10734;
var statearr_10736_10763 = state_10734__$1;
(statearr_10736_10763[(2)] = inst_10730);

(statearr_10736_10763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (1))){
var state_10734__$1 = state_10734;
var statearr_10737_10764 = state_10734__$1;
(statearr_10737_10764[(2)] = null);

(statearr_10737_10764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (4))){
var inst_10713 = (state_10734[(7)]);
var inst_10713__$1 = (state_10734[(2)]);
var inst_10714 = (inst_10713__$1 == null);
var state_10734__$1 = (function (){var statearr_10738 = state_10734;
(statearr_10738[(7)] = inst_10713__$1);

return statearr_10738;
})();
if(cljs.core.truth_(inst_10714)){
var statearr_10739_10765 = state_10734__$1;
(statearr_10739_10765[(1)] = (5));

} else {
var statearr_10740_10766 = state_10734__$1;
(statearr_10740_10766[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (13))){
var state_10734__$1 = state_10734;
var statearr_10741_10767 = state_10734__$1;
(statearr_10741_10767[(2)] = null);

(statearr_10741_10767[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (6))){
var inst_10713 = (state_10734[(7)]);
var state_10734__$1 = state_10734;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10734__$1,(11),to,inst_10713);
} else {
if((state_val_10735 === (3))){
var inst_10732 = (state_10734[(2)]);
var state_10734__$1 = state_10734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10734__$1,inst_10732);
} else {
if((state_val_10735 === (12))){
var state_10734__$1 = state_10734;
var statearr_10742_10768 = state_10734__$1;
(statearr_10742_10768[(2)] = null);

(statearr_10742_10768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (2))){
var state_10734__$1 = state_10734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10734__$1,(4),from);
} else {
if((state_val_10735 === (11))){
var inst_10723 = (state_10734[(2)]);
var state_10734__$1 = state_10734;
if(cljs.core.truth_(inst_10723)){
var statearr_10743_10769 = state_10734__$1;
(statearr_10743_10769[(1)] = (12));

} else {
var statearr_10744_10770 = state_10734__$1;
(statearr_10744_10770[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (9))){
var state_10734__$1 = state_10734;
var statearr_10745_10771 = state_10734__$1;
(statearr_10745_10771[(2)] = null);

(statearr_10745_10771[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (5))){
var state_10734__$1 = state_10734;
if(cljs.core.truth_(close_QMARK_)){
var statearr_10746_10772 = state_10734__$1;
(statearr_10746_10772[(1)] = (8));

} else {
var statearr_10747_10773 = state_10734__$1;
(statearr_10747_10773[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (14))){
var inst_10728 = (state_10734[(2)]);
var state_10734__$1 = state_10734;
var statearr_10748_10774 = state_10734__$1;
(statearr_10748_10774[(2)] = inst_10728);

(statearr_10748_10774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (10))){
var inst_10720 = (state_10734[(2)]);
var state_10734__$1 = state_10734;
var statearr_10749_10775 = state_10734__$1;
(statearr_10749_10775[(2)] = inst_10720);

(statearr_10749_10775[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10735 === (8))){
var inst_10717 = cljs.core.async.close_BANG_.call(null,to);
var state_10734__$1 = state_10734;
var statearr_10750_10776 = state_10734__$1;
(statearr_10750_10776[(2)] = inst_10717);

(statearr_10750_10776[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___10762))
;
return ((function (switch__10483__auto__,c__10595__auto___10762){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_10754 = [null,null,null,null,null,null,null,null];
(statearr_10754[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_10754[(1)] = (1));

return statearr_10754;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_10734){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_10734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e10755){if((e10755 instanceof Object)){
var ex__10487__auto__ = e10755;
var statearr_10756_10777 = state_10734;
(statearr_10756_10777[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10734);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10755;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10778 = state_10734;
state_10734 = G__10778;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_10734){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_10734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___10762))
})();
var state__10597__auto__ = (function (){var statearr_10757 = f__10596__auto__.call(null);
(statearr_10757[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___10762);

return statearr_10757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___10762))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__10966){
var vec__10967 = p__10966;
var v = cljs.core.nth.call(null,vec__10967,(0),null);
var p = cljs.core.nth.call(null,vec__10967,(1),null);
var job = vec__10967;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__10595__auto___11153 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___11153,res,vec__10967,v,p,job,jobs,results){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___11153,res,vec__10967,v,p,job,jobs,results){
return (function (state_10974){
var state_val_10975 = (state_10974[(1)]);
if((state_val_10975 === (1))){
var state_10974__$1 = state_10974;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10974__$1,(2),res,v);
} else {
if((state_val_10975 === (2))){
var inst_10971 = (state_10974[(2)]);
var inst_10972 = cljs.core.async.close_BANG_.call(null,res);
var state_10974__$1 = (function (){var statearr_10976 = state_10974;
(statearr_10976[(7)] = inst_10971);

return statearr_10976;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10974__$1,inst_10972);
} else {
return null;
}
}
});})(c__10595__auto___11153,res,vec__10967,v,p,job,jobs,results))
;
return ((function (switch__10483__auto__,c__10595__auto___11153,res,vec__10967,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_10980 = [null,null,null,null,null,null,null,null];
(statearr_10980[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_10980[(1)] = (1));

return statearr_10980;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_10974){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_10974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e10981){if((e10981 instanceof Object)){
var ex__10487__auto__ = e10981;
var statearr_10982_11154 = state_10974;
(statearr_10982_11154[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10974);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10981;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11155 = state_10974;
state_10974 = G__11155;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_10974){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_10974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___11153,res,vec__10967,v,p,job,jobs,results))
})();
var state__10597__auto__ = (function (){var statearr_10983 = f__10596__auto__.call(null);
(statearr_10983[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___11153);

return statearr_10983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___11153,res,vec__10967,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__10984){
var vec__10985 = p__10984;
var v = cljs.core.nth.call(null,vec__10985,(0),null);
var p = cljs.core.nth.call(null,vec__10985,(1),null);
var job = vec__10985;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___11156 = n;
var __11157 = (0);
while(true){
if((__11157 < n__7324__auto___11156)){
var G__10988_11158 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__10988_11158) {
case "compute":
var c__10595__auto___11160 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11157,c__10595__auto___11160,G__10988_11158,n__7324__auto___11156,jobs,results,process,async){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (__11157,c__10595__auto___11160,G__10988_11158,n__7324__auto___11156,jobs,results,process,async){
return (function (state_11001){
var state_val_11002 = (state_11001[(1)]);
if((state_val_11002 === (1))){
var state_11001__$1 = state_11001;
var statearr_11003_11161 = state_11001__$1;
(statearr_11003_11161[(2)] = null);

(statearr_11003_11161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11002 === (2))){
var state_11001__$1 = state_11001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11001__$1,(4),jobs);
} else {
if((state_val_11002 === (3))){
var inst_10999 = (state_11001[(2)]);
var state_11001__$1 = state_11001;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11001__$1,inst_10999);
} else {
if((state_val_11002 === (4))){
var inst_10991 = (state_11001[(2)]);
var inst_10992 = process.call(null,inst_10991);
var state_11001__$1 = state_11001;
if(cljs.core.truth_(inst_10992)){
var statearr_11004_11162 = state_11001__$1;
(statearr_11004_11162[(1)] = (5));

} else {
var statearr_11005_11163 = state_11001__$1;
(statearr_11005_11163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11002 === (5))){
var state_11001__$1 = state_11001;
var statearr_11006_11164 = state_11001__$1;
(statearr_11006_11164[(2)] = null);

(statearr_11006_11164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11002 === (6))){
var state_11001__$1 = state_11001;
var statearr_11007_11165 = state_11001__$1;
(statearr_11007_11165[(2)] = null);

(statearr_11007_11165[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11002 === (7))){
var inst_10997 = (state_11001[(2)]);
var state_11001__$1 = state_11001;
var statearr_11008_11166 = state_11001__$1;
(statearr_11008_11166[(2)] = inst_10997);

(statearr_11008_11166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11157,c__10595__auto___11160,G__10988_11158,n__7324__auto___11156,jobs,results,process,async))
;
return ((function (__11157,switch__10483__auto__,c__10595__auto___11160,G__10988_11158,n__7324__auto___11156,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_11012 = [null,null,null,null,null,null,null];
(statearr_11012[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_11012[(1)] = (1));

return statearr_11012;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_11001){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_11001);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e11013){if((e11013 instanceof Object)){
var ex__10487__auto__ = e11013;
var statearr_11014_11167 = state_11001;
(statearr_11014_11167[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11001);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11168 = state_11001;
state_11001 = G__11168;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_11001){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_11001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(__11157,switch__10483__auto__,c__10595__auto___11160,G__10988_11158,n__7324__auto___11156,jobs,results,process,async))
})();
var state__10597__auto__ = (function (){var statearr_11015 = f__10596__auto__.call(null);
(statearr_11015[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___11160);

return statearr_11015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(__11157,c__10595__auto___11160,G__10988_11158,n__7324__auto___11156,jobs,results,process,async))
);


break;
case "async":
var c__10595__auto___11169 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11157,c__10595__auto___11169,G__10988_11158,n__7324__auto___11156,jobs,results,process,async){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (__11157,c__10595__auto___11169,G__10988_11158,n__7324__auto___11156,jobs,results,process,async){
return (function (state_11028){
var state_val_11029 = (state_11028[(1)]);
if((state_val_11029 === (1))){
var state_11028__$1 = state_11028;
var statearr_11030_11170 = state_11028__$1;
(statearr_11030_11170[(2)] = null);

(statearr_11030_11170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11029 === (2))){
var state_11028__$1 = state_11028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11028__$1,(4),jobs);
} else {
if((state_val_11029 === (3))){
var inst_11026 = (state_11028[(2)]);
var state_11028__$1 = state_11028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11028__$1,inst_11026);
} else {
if((state_val_11029 === (4))){
var inst_11018 = (state_11028[(2)]);
var inst_11019 = async.call(null,inst_11018);
var state_11028__$1 = state_11028;
if(cljs.core.truth_(inst_11019)){
var statearr_11031_11171 = state_11028__$1;
(statearr_11031_11171[(1)] = (5));

} else {
var statearr_11032_11172 = state_11028__$1;
(statearr_11032_11172[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11029 === (5))){
var state_11028__$1 = state_11028;
var statearr_11033_11173 = state_11028__$1;
(statearr_11033_11173[(2)] = null);

(statearr_11033_11173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11029 === (6))){
var state_11028__$1 = state_11028;
var statearr_11034_11174 = state_11028__$1;
(statearr_11034_11174[(2)] = null);

(statearr_11034_11174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11029 === (7))){
var inst_11024 = (state_11028[(2)]);
var state_11028__$1 = state_11028;
var statearr_11035_11175 = state_11028__$1;
(statearr_11035_11175[(2)] = inst_11024);

(statearr_11035_11175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11157,c__10595__auto___11169,G__10988_11158,n__7324__auto___11156,jobs,results,process,async))
;
return ((function (__11157,switch__10483__auto__,c__10595__auto___11169,G__10988_11158,n__7324__auto___11156,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_11039 = [null,null,null,null,null,null,null];
(statearr_11039[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_11039[(1)] = (1));

return statearr_11039;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_11028){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_11028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e11040){if((e11040 instanceof Object)){
var ex__10487__auto__ = e11040;
var statearr_11041_11176 = state_11028;
(statearr_11041_11176[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11028);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11040;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11177 = state_11028;
state_11028 = G__11177;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_11028){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_11028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(__11157,switch__10483__auto__,c__10595__auto___11169,G__10988_11158,n__7324__auto___11156,jobs,results,process,async))
})();
var state__10597__auto__ = (function (){var statearr_11042 = f__10596__auto__.call(null);
(statearr_11042[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___11169);

return statearr_11042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(__11157,c__10595__auto___11169,G__10988_11158,n__7324__auto___11156,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11178 = (__11157 + (1));
__11157 = G__11178;
continue;
} else {
}
break;
}

var c__10595__auto___11179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___11179,jobs,results,process,async){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___11179,jobs,results,process,async){
return (function (state_11064){
var state_val_11065 = (state_11064[(1)]);
if((state_val_11065 === (1))){
var state_11064__$1 = state_11064;
var statearr_11066_11180 = state_11064__$1;
(statearr_11066_11180[(2)] = null);

(statearr_11066_11180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11065 === (2))){
var state_11064__$1 = state_11064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11064__$1,(4),from);
} else {
if((state_val_11065 === (3))){
var inst_11062 = (state_11064[(2)]);
var state_11064__$1 = state_11064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11064__$1,inst_11062);
} else {
if((state_val_11065 === (4))){
var inst_11045 = (state_11064[(7)]);
var inst_11045__$1 = (state_11064[(2)]);
var inst_11046 = (inst_11045__$1 == null);
var state_11064__$1 = (function (){var statearr_11067 = state_11064;
(statearr_11067[(7)] = inst_11045__$1);

return statearr_11067;
})();
if(cljs.core.truth_(inst_11046)){
var statearr_11068_11181 = state_11064__$1;
(statearr_11068_11181[(1)] = (5));

} else {
var statearr_11069_11182 = state_11064__$1;
(statearr_11069_11182[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11065 === (5))){
var inst_11048 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11064__$1 = state_11064;
var statearr_11070_11183 = state_11064__$1;
(statearr_11070_11183[(2)] = inst_11048);

(statearr_11070_11183[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11065 === (6))){
var inst_11045 = (state_11064[(7)]);
var inst_11050 = (state_11064[(8)]);
var inst_11050__$1 = cljs.core.async.chan.call(null,(1));
var inst_11051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11052 = [inst_11045,inst_11050__$1];
var inst_11053 = (new cljs.core.PersistentVector(null,2,(5),inst_11051,inst_11052,null));
var state_11064__$1 = (function (){var statearr_11071 = state_11064;
(statearr_11071[(8)] = inst_11050__$1);

return statearr_11071;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11064__$1,(8),jobs,inst_11053);
} else {
if((state_val_11065 === (7))){
var inst_11060 = (state_11064[(2)]);
var state_11064__$1 = state_11064;
var statearr_11072_11184 = state_11064__$1;
(statearr_11072_11184[(2)] = inst_11060);

(statearr_11072_11184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11065 === (8))){
var inst_11050 = (state_11064[(8)]);
var inst_11055 = (state_11064[(2)]);
var state_11064__$1 = (function (){var statearr_11073 = state_11064;
(statearr_11073[(9)] = inst_11055);

return statearr_11073;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11064__$1,(9),results,inst_11050);
} else {
if((state_val_11065 === (9))){
var inst_11057 = (state_11064[(2)]);
var state_11064__$1 = (function (){var statearr_11074 = state_11064;
(statearr_11074[(10)] = inst_11057);

return statearr_11074;
})();
var statearr_11075_11185 = state_11064__$1;
(statearr_11075_11185[(2)] = null);

(statearr_11075_11185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___11179,jobs,results,process,async))
;
return ((function (switch__10483__auto__,c__10595__auto___11179,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_11079 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11079[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_11079[(1)] = (1));

return statearr_11079;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_11064){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_11064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e11080){if((e11080 instanceof Object)){
var ex__10487__auto__ = e11080;
var statearr_11081_11186 = state_11064;
(statearr_11081_11186[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11064);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11080;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11187 = state_11064;
state_11064 = G__11187;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_11064){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_11064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___11179,jobs,results,process,async))
})();
var state__10597__auto__ = (function (){var statearr_11082 = f__10596__auto__.call(null);
(statearr_11082[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___11179);

return statearr_11082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___11179,jobs,results,process,async))
);


var c__10595__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto__,jobs,results,process,async){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto__,jobs,results,process,async){
return (function (state_11120){
var state_val_11121 = (state_11120[(1)]);
if((state_val_11121 === (7))){
var inst_11116 = (state_11120[(2)]);
var state_11120__$1 = state_11120;
var statearr_11122_11188 = state_11120__$1;
(statearr_11122_11188[(2)] = inst_11116);

(statearr_11122_11188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (20))){
var state_11120__$1 = state_11120;
var statearr_11123_11189 = state_11120__$1;
(statearr_11123_11189[(2)] = null);

(statearr_11123_11189[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (1))){
var state_11120__$1 = state_11120;
var statearr_11124_11190 = state_11120__$1;
(statearr_11124_11190[(2)] = null);

(statearr_11124_11190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (4))){
var inst_11085 = (state_11120[(7)]);
var inst_11085__$1 = (state_11120[(2)]);
var inst_11086 = (inst_11085__$1 == null);
var state_11120__$1 = (function (){var statearr_11125 = state_11120;
(statearr_11125[(7)] = inst_11085__$1);

return statearr_11125;
})();
if(cljs.core.truth_(inst_11086)){
var statearr_11126_11191 = state_11120__$1;
(statearr_11126_11191[(1)] = (5));

} else {
var statearr_11127_11192 = state_11120__$1;
(statearr_11127_11192[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (15))){
var inst_11098 = (state_11120[(8)]);
var state_11120__$1 = state_11120;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11120__$1,(18),to,inst_11098);
} else {
if((state_val_11121 === (21))){
var inst_11111 = (state_11120[(2)]);
var state_11120__$1 = state_11120;
var statearr_11128_11193 = state_11120__$1;
(statearr_11128_11193[(2)] = inst_11111);

(statearr_11128_11193[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (13))){
var inst_11113 = (state_11120[(2)]);
var state_11120__$1 = (function (){var statearr_11129 = state_11120;
(statearr_11129[(9)] = inst_11113);

return statearr_11129;
})();
var statearr_11130_11194 = state_11120__$1;
(statearr_11130_11194[(2)] = null);

(statearr_11130_11194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (6))){
var inst_11085 = (state_11120[(7)]);
var state_11120__$1 = state_11120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11120__$1,(11),inst_11085);
} else {
if((state_val_11121 === (17))){
var inst_11106 = (state_11120[(2)]);
var state_11120__$1 = state_11120;
if(cljs.core.truth_(inst_11106)){
var statearr_11131_11195 = state_11120__$1;
(statearr_11131_11195[(1)] = (19));

} else {
var statearr_11132_11196 = state_11120__$1;
(statearr_11132_11196[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (3))){
var inst_11118 = (state_11120[(2)]);
var state_11120__$1 = state_11120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11120__$1,inst_11118);
} else {
if((state_val_11121 === (12))){
var inst_11095 = (state_11120[(10)]);
var state_11120__$1 = state_11120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11120__$1,(14),inst_11095);
} else {
if((state_val_11121 === (2))){
var state_11120__$1 = state_11120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11120__$1,(4),results);
} else {
if((state_val_11121 === (19))){
var state_11120__$1 = state_11120;
var statearr_11133_11197 = state_11120__$1;
(statearr_11133_11197[(2)] = null);

(statearr_11133_11197[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (11))){
var inst_11095 = (state_11120[(2)]);
var state_11120__$1 = (function (){var statearr_11134 = state_11120;
(statearr_11134[(10)] = inst_11095);

return statearr_11134;
})();
var statearr_11135_11198 = state_11120__$1;
(statearr_11135_11198[(2)] = null);

(statearr_11135_11198[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (9))){
var state_11120__$1 = state_11120;
var statearr_11136_11199 = state_11120__$1;
(statearr_11136_11199[(2)] = null);

(statearr_11136_11199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (5))){
var state_11120__$1 = state_11120;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11137_11200 = state_11120__$1;
(statearr_11137_11200[(1)] = (8));

} else {
var statearr_11138_11201 = state_11120__$1;
(statearr_11138_11201[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (14))){
var inst_11100 = (state_11120[(11)]);
var inst_11098 = (state_11120[(8)]);
var inst_11098__$1 = (state_11120[(2)]);
var inst_11099 = (inst_11098__$1 == null);
var inst_11100__$1 = cljs.core.not.call(null,inst_11099);
var state_11120__$1 = (function (){var statearr_11139 = state_11120;
(statearr_11139[(11)] = inst_11100__$1);

(statearr_11139[(8)] = inst_11098__$1);

return statearr_11139;
})();
if(inst_11100__$1){
var statearr_11140_11202 = state_11120__$1;
(statearr_11140_11202[(1)] = (15));

} else {
var statearr_11141_11203 = state_11120__$1;
(statearr_11141_11203[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (16))){
var inst_11100 = (state_11120[(11)]);
var state_11120__$1 = state_11120;
var statearr_11142_11204 = state_11120__$1;
(statearr_11142_11204[(2)] = inst_11100);

(statearr_11142_11204[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (10))){
var inst_11092 = (state_11120[(2)]);
var state_11120__$1 = state_11120;
var statearr_11143_11205 = state_11120__$1;
(statearr_11143_11205[(2)] = inst_11092);

(statearr_11143_11205[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (18))){
var inst_11103 = (state_11120[(2)]);
var state_11120__$1 = state_11120;
var statearr_11144_11206 = state_11120__$1;
(statearr_11144_11206[(2)] = inst_11103);

(statearr_11144_11206[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11121 === (8))){
var inst_11089 = cljs.core.async.close_BANG_.call(null,to);
var state_11120__$1 = state_11120;
var statearr_11145_11207 = state_11120__$1;
(statearr_11145_11207[(2)] = inst_11089);

(statearr_11145_11207[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto__,jobs,results,process,async))
;
return ((function (switch__10483__auto__,c__10595__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_11149 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11149[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__);

(statearr_11149[(1)] = (1));

return statearr_11149;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1 = (function (state_11120){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_11120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e11150){if((e11150 instanceof Object)){
var ex__10487__auto__ = e11150;
var statearr_11151_11208 = state_11120;
(statearr_11151_11208[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11150;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11209 = state_11120;
state_11120 = G__11209;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__ = function(state_11120){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1.call(this,state_11120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto__,jobs,results,process,async))
})();
var state__10597__auto__ = (function (){var statearr_11152 = f__10596__auto__.call(null);
(statearr_11152[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto__);

return statearr_11152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto__,jobs,results,process,async))
);

return c__10595__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11210 = [];
var len__7484__auto___11213 = arguments.length;
var i__7485__auto___11214 = (0);
while(true){
if((i__7485__auto___11214 < len__7484__auto___11213)){
args11210.push((arguments[i__7485__auto___11214]));

var G__11215 = (i__7485__auto___11214 + (1));
i__7485__auto___11214 = G__11215;
continue;
} else {
}
break;
}

var G__11212 = args11210.length;
switch (G__11212) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11210.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11217 = [];
var len__7484__auto___11220 = arguments.length;
var i__7485__auto___11221 = (0);
while(true){
if((i__7485__auto___11221 < len__7484__auto___11220)){
args11217.push((arguments[i__7485__auto___11221]));

var G__11222 = (i__7485__auto___11221 + (1));
i__7485__auto___11221 = G__11222;
continue;
} else {
}
break;
}

var G__11219 = args11217.length;
switch (G__11219) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11217.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11224 = [];
var len__7484__auto___11277 = arguments.length;
var i__7485__auto___11278 = (0);
while(true){
if((i__7485__auto___11278 < len__7484__auto___11277)){
args11224.push((arguments[i__7485__auto___11278]));

var G__11279 = (i__7485__auto___11278 + (1));
i__7485__auto___11278 = G__11279;
continue;
} else {
}
break;
}

var G__11226 = args11224.length;
switch (G__11226) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11224.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__10595__auto___11281 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___11281,tc,fc){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___11281,tc,fc){
return (function (state_11252){
var state_val_11253 = (state_11252[(1)]);
if((state_val_11253 === (7))){
var inst_11248 = (state_11252[(2)]);
var state_11252__$1 = state_11252;
var statearr_11254_11282 = state_11252__$1;
(statearr_11254_11282[(2)] = inst_11248);

(statearr_11254_11282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (1))){
var state_11252__$1 = state_11252;
var statearr_11255_11283 = state_11252__$1;
(statearr_11255_11283[(2)] = null);

(statearr_11255_11283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (4))){
var inst_11229 = (state_11252[(7)]);
var inst_11229__$1 = (state_11252[(2)]);
var inst_11230 = (inst_11229__$1 == null);
var state_11252__$1 = (function (){var statearr_11256 = state_11252;
(statearr_11256[(7)] = inst_11229__$1);

return statearr_11256;
})();
if(cljs.core.truth_(inst_11230)){
var statearr_11257_11284 = state_11252__$1;
(statearr_11257_11284[(1)] = (5));

} else {
var statearr_11258_11285 = state_11252__$1;
(statearr_11258_11285[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (13))){
var state_11252__$1 = state_11252;
var statearr_11259_11286 = state_11252__$1;
(statearr_11259_11286[(2)] = null);

(statearr_11259_11286[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (6))){
var inst_11229 = (state_11252[(7)]);
var inst_11235 = p.call(null,inst_11229);
var state_11252__$1 = state_11252;
if(cljs.core.truth_(inst_11235)){
var statearr_11260_11287 = state_11252__$1;
(statearr_11260_11287[(1)] = (9));

} else {
var statearr_11261_11288 = state_11252__$1;
(statearr_11261_11288[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (3))){
var inst_11250 = (state_11252[(2)]);
var state_11252__$1 = state_11252;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11252__$1,inst_11250);
} else {
if((state_val_11253 === (12))){
var state_11252__$1 = state_11252;
var statearr_11262_11289 = state_11252__$1;
(statearr_11262_11289[(2)] = null);

(statearr_11262_11289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (2))){
var state_11252__$1 = state_11252;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11252__$1,(4),ch);
} else {
if((state_val_11253 === (11))){
var inst_11229 = (state_11252[(7)]);
var inst_11239 = (state_11252[(2)]);
var state_11252__$1 = state_11252;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11252__$1,(8),inst_11239,inst_11229);
} else {
if((state_val_11253 === (9))){
var state_11252__$1 = state_11252;
var statearr_11263_11290 = state_11252__$1;
(statearr_11263_11290[(2)] = tc);

(statearr_11263_11290[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (5))){
var inst_11232 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11233 = cljs.core.async.close_BANG_.call(null,fc);
var state_11252__$1 = (function (){var statearr_11264 = state_11252;
(statearr_11264[(8)] = inst_11232);

return statearr_11264;
})();
var statearr_11265_11291 = state_11252__$1;
(statearr_11265_11291[(2)] = inst_11233);

(statearr_11265_11291[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (14))){
var inst_11246 = (state_11252[(2)]);
var state_11252__$1 = state_11252;
var statearr_11266_11292 = state_11252__$1;
(statearr_11266_11292[(2)] = inst_11246);

(statearr_11266_11292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (10))){
var state_11252__$1 = state_11252;
var statearr_11267_11293 = state_11252__$1;
(statearr_11267_11293[(2)] = fc);

(statearr_11267_11293[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11253 === (8))){
var inst_11241 = (state_11252[(2)]);
var state_11252__$1 = state_11252;
if(cljs.core.truth_(inst_11241)){
var statearr_11268_11294 = state_11252__$1;
(statearr_11268_11294[(1)] = (12));

} else {
var statearr_11269_11295 = state_11252__$1;
(statearr_11269_11295[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___11281,tc,fc))
;
return ((function (switch__10483__auto__,c__10595__auto___11281,tc,fc){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_11273 = [null,null,null,null,null,null,null,null,null];
(statearr_11273[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_11273[(1)] = (1));

return statearr_11273;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_11252){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_11252);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e11274){if((e11274 instanceof Object)){
var ex__10487__auto__ = e11274;
var statearr_11275_11296 = state_11252;
(statearr_11275_11296[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11252);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11274;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11297 = state_11252;
state_11252 = G__11297;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_11252){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_11252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___11281,tc,fc))
})();
var state__10597__auto__ = (function (){var statearr_11276 = f__10596__auto__.call(null);
(statearr_11276[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___11281);

return statearr_11276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___11281,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__10595__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto__){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto__){
return (function (state_11361){
var state_val_11362 = (state_11361[(1)]);
if((state_val_11362 === (7))){
var inst_11357 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
var statearr_11363_11384 = state_11361__$1;
(statearr_11363_11384[(2)] = inst_11357);

(statearr_11363_11384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (1))){
var inst_11341 = init;
var state_11361__$1 = (function (){var statearr_11364 = state_11361;
(statearr_11364[(7)] = inst_11341);

return statearr_11364;
})();
var statearr_11365_11385 = state_11361__$1;
(statearr_11365_11385[(2)] = null);

(statearr_11365_11385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (4))){
var inst_11344 = (state_11361[(8)]);
var inst_11344__$1 = (state_11361[(2)]);
var inst_11345 = (inst_11344__$1 == null);
var state_11361__$1 = (function (){var statearr_11366 = state_11361;
(statearr_11366[(8)] = inst_11344__$1);

return statearr_11366;
})();
if(cljs.core.truth_(inst_11345)){
var statearr_11367_11386 = state_11361__$1;
(statearr_11367_11386[(1)] = (5));

} else {
var statearr_11368_11387 = state_11361__$1;
(statearr_11368_11387[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (6))){
var inst_11344 = (state_11361[(8)]);
var inst_11348 = (state_11361[(9)]);
var inst_11341 = (state_11361[(7)]);
var inst_11348__$1 = f.call(null,inst_11341,inst_11344);
var inst_11349 = cljs.core.reduced_QMARK_.call(null,inst_11348__$1);
var state_11361__$1 = (function (){var statearr_11369 = state_11361;
(statearr_11369[(9)] = inst_11348__$1);

return statearr_11369;
})();
if(inst_11349){
var statearr_11370_11388 = state_11361__$1;
(statearr_11370_11388[(1)] = (8));

} else {
var statearr_11371_11389 = state_11361__$1;
(statearr_11371_11389[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (3))){
var inst_11359 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11361__$1,inst_11359);
} else {
if((state_val_11362 === (2))){
var state_11361__$1 = state_11361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11361__$1,(4),ch);
} else {
if((state_val_11362 === (9))){
var inst_11348 = (state_11361[(9)]);
var inst_11341 = inst_11348;
var state_11361__$1 = (function (){var statearr_11372 = state_11361;
(statearr_11372[(7)] = inst_11341);

return statearr_11372;
})();
var statearr_11373_11390 = state_11361__$1;
(statearr_11373_11390[(2)] = null);

(statearr_11373_11390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (5))){
var inst_11341 = (state_11361[(7)]);
var state_11361__$1 = state_11361;
var statearr_11374_11391 = state_11361__$1;
(statearr_11374_11391[(2)] = inst_11341);

(statearr_11374_11391[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (10))){
var inst_11355 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
var statearr_11375_11392 = state_11361__$1;
(statearr_11375_11392[(2)] = inst_11355);

(statearr_11375_11392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (8))){
var inst_11348 = (state_11361[(9)]);
var inst_11351 = cljs.core.deref.call(null,inst_11348);
var state_11361__$1 = state_11361;
var statearr_11376_11393 = state_11361__$1;
(statearr_11376_11393[(2)] = inst_11351);

(statearr_11376_11393[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto__))
;
return ((function (switch__10483__auto__,c__10595__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10484__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10484__auto____0 = (function (){
var statearr_11380 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11380[(0)] = cljs$core$async$reduce_$_state_machine__10484__auto__);

(statearr_11380[(1)] = (1));

return statearr_11380;
});
var cljs$core$async$reduce_$_state_machine__10484__auto____1 = (function (state_11361){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_11361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e11381){if((e11381 instanceof Object)){
var ex__10487__auto__ = e11381;
var statearr_11382_11394 = state_11361;
(statearr_11382_11394[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11395 = state_11361;
state_11361 = G__11395;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10484__auto__ = function(state_11361){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10484__auto____1.call(this,state_11361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10484__auto____0;
cljs$core$async$reduce_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10484__auto____1;
return cljs$core$async$reduce_$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto__))
})();
var state__10597__auto__ = (function (){var statearr_11383 = f__10596__auto__.call(null);
(statearr_11383[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto__);

return statearr_11383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto__))
);

return c__10595__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11396 = [];
var len__7484__auto___11448 = arguments.length;
var i__7485__auto___11449 = (0);
while(true){
if((i__7485__auto___11449 < len__7484__auto___11448)){
args11396.push((arguments[i__7485__auto___11449]));

var G__11450 = (i__7485__auto___11449 + (1));
i__7485__auto___11449 = G__11450;
continue;
} else {
}
break;
}

var G__11398 = args11396.length;
switch (G__11398) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11396.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__10595__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto__){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto__){
return (function (state_11423){
var state_val_11424 = (state_11423[(1)]);
if((state_val_11424 === (7))){
var inst_11405 = (state_11423[(2)]);
var state_11423__$1 = state_11423;
var statearr_11425_11452 = state_11423__$1;
(statearr_11425_11452[(2)] = inst_11405);

(statearr_11425_11452[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (1))){
var inst_11399 = cljs.core.seq.call(null,coll);
var inst_11400 = inst_11399;
var state_11423__$1 = (function (){var statearr_11426 = state_11423;
(statearr_11426[(7)] = inst_11400);

return statearr_11426;
})();
var statearr_11427_11453 = state_11423__$1;
(statearr_11427_11453[(2)] = null);

(statearr_11427_11453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (4))){
var inst_11400 = (state_11423[(7)]);
var inst_11403 = cljs.core.first.call(null,inst_11400);
var state_11423__$1 = state_11423;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11423__$1,(7),ch,inst_11403);
} else {
if((state_val_11424 === (13))){
var inst_11417 = (state_11423[(2)]);
var state_11423__$1 = state_11423;
var statearr_11428_11454 = state_11423__$1;
(statearr_11428_11454[(2)] = inst_11417);

(statearr_11428_11454[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (6))){
var inst_11408 = (state_11423[(2)]);
var state_11423__$1 = state_11423;
if(cljs.core.truth_(inst_11408)){
var statearr_11429_11455 = state_11423__$1;
(statearr_11429_11455[(1)] = (8));

} else {
var statearr_11430_11456 = state_11423__$1;
(statearr_11430_11456[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (3))){
var inst_11421 = (state_11423[(2)]);
var state_11423__$1 = state_11423;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11423__$1,inst_11421);
} else {
if((state_val_11424 === (12))){
var state_11423__$1 = state_11423;
var statearr_11431_11457 = state_11423__$1;
(statearr_11431_11457[(2)] = null);

(statearr_11431_11457[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (2))){
var inst_11400 = (state_11423[(7)]);
var state_11423__$1 = state_11423;
if(cljs.core.truth_(inst_11400)){
var statearr_11432_11458 = state_11423__$1;
(statearr_11432_11458[(1)] = (4));

} else {
var statearr_11433_11459 = state_11423__$1;
(statearr_11433_11459[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (11))){
var inst_11414 = cljs.core.async.close_BANG_.call(null,ch);
var state_11423__$1 = state_11423;
var statearr_11434_11460 = state_11423__$1;
(statearr_11434_11460[(2)] = inst_11414);

(statearr_11434_11460[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (9))){
var state_11423__$1 = state_11423;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11435_11461 = state_11423__$1;
(statearr_11435_11461[(1)] = (11));

} else {
var statearr_11436_11462 = state_11423__$1;
(statearr_11436_11462[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (5))){
var inst_11400 = (state_11423[(7)]);
var state_11423__$1 = state_11423;
var statearr_11437_11463 = state_11423__$1;
(statearr_11437_11463[(2)] = inst_11400);

(statearr_11437_11463[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (10))){
var inst_11419 = (state_11423[(2)]);
var state_11423__$1 = state_11423;
var statearr_11438_11464 = state_11423__$1;
(statearr_11438_11464[(2)] = inst_11419);

(statearr_11438_11464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11424 === (8))){
var inst_11400 = (state_11423[(7)]);
var inst_11410 = cljs.core.next.call(null,inst_11400);
var inst_11400__$1 = inst_11410;
var state_11423__$1 = (function (){var statearr_11439 = state_11423;
(statearr_11439[(7)] = inst_11400__$1);

return statearr_11439;
})();
var statearr_11440_11465 = state_11423__$1;
(statearr_11440_11465[(2)] = null);

(statearr_11440_11465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto__))
;
return ((function (switch__10483__auto__,c__10595__auto__){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_11444 = [null,null,null,null,null,null,null,null];
(statearr_11444[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_11444[(1)] = (1));

return statearr_11444;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_11423){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_11423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e11445){if((e11445 instanceof Object)){
var ex__10487__auto__ = e11445;
var statearr_11446_11466 = state_11423;
(statearr_11446_11466[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11423);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11445;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11467 = state_11423;
state_11423 = G__11467;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_11423){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_11423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto__))
})();
var state__10597__auto__ = (function (){var statearr_11447 = f__10596__auto__.call(null);
(statearr_11447[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto__);

return statearr_11447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto__))
);

return c__10595__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async11693 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11693 = (function (mult,ch,cs,meta11694){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta11694 = meta11694;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11693.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_11695,meta11694__$1){
var self__ = this;
var _11695__$1 = this;
return (new cljs.core.async.t_cljs$core$async11693(self__.mult,self__.ch,self__.cs,meta11694__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async11693.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_11695){
var self__ = this;
var _11695__$1 = this;
return self__.meta11694;
});})(cs))
;

cljs.core.async.t_cljs$core$async11693.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async11693.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async11693.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async11693.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11693.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11693.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11693.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11694","meta11694",-1634243863,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async11693.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11693.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11693";

cljs.core.async.t_cljs$core$async11693.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async11693");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async11693 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async11693(mult__$1,ch__$1,cs__$1,meta11694){
return (new cljs.core.async.t_cljs$core$async11693(mult__$1,ch__$1,cs__$1,meta11694));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async11693(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__10595__auto___11918 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___11918,cs,m,dchan,dctr,done){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___11918,cs,m,dchan,dctr,done){
return (function (state_11830){
var state_val_11831 = (state_11830[(1)]);
if((state_val_11831 === (7))){
var inst_11826 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11832_11919 = state_11830__$1;
(statearr_11832_11919[(2)] = inst_11826);

(statearr_11832_11919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (20))){
var inst_11729 = (state_11830[(7)]);
var inst_11741 = cljs.core.first.call(null,inst_11729);
var inst_11742 = cljs.core.nth.call(null,inst_11741,(0),null);
var inst_11743 = cljs.core.nth.call(null,inst_11741,(1),null);
var state_11830__$1 = (function (){var statearr_11833 = state_11830;
(statearr_11833[(8)] = inst_11742);

return statearr_11833;
})();
if(cljs.core.truth_(inst_11743)){
var statearr_11834_11920 = state_11830__$1;
(statearr_11834_11920[(1)] = (22));

} else {
var statearr_11835_11921 = state_11830__$1;
(statearr_11835_11921[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (27))){
var inst_11698 = (state_11830[(9)]);
var inst_11773 = (state_11830[(10)]);
var inst_11778 = (state_11830[(11)]);
var inst_11771 = (state_11830[(12)]);
var inst_11778__$1 = cljs.core._nth.call(null,inst_11771,inst_11773);
var inst_11779 = cljs.core.async.put_BANG_.call(null,inst_11778__$1,inst_11698,done);
var state_11830__$1 = (function (){var statearr_11836 = state_11830;
(statearr_11836[(11)] = inst_11778__$1);

return statearr_11836;
})();
if(cljs.core.truth_(inst_11779)){
var statearr_11837_11922 = state_11830__$1;
(statearr_11837_11922[(1)] = (30));

} else {
var statearr_11838_11923 = state_11830__$1;
(statearr_11838_11923[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (1))){
var state_11830__$1 = state_11830;
var statearr_11839_11924 = state_11830__$1;
(statearr_11839_11924[(2)] = null);

(statearr_11839_11924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (24))){
var inst_11729 = (state_11830[(7)]);
var inst_11748 = (state_11830[(2)]);
var inst_11749 = cljs.core.next.call(null,inst_11729);
var inst_11707 = inst_11749;
var inst_11708 = null;
var inst_11709 = (0);
var inst_11710 = (0);
var state_11830__$1 = (function (){var statearr_11840 = state_11830;
(statearr_11840[(13)] = inst_11710);

(statearr_11840[(14)] = inst_11709);

(statearr_11840[(15)] = inst_11748);

(statearr_11840[(16)] = inst_11708);

(statearr_11840[(17)] = inst_11707);

return statearr_11840;
})();
var statearr_11841_11925 = state_11830__$1;
(statearr_11841_11925[(2)] = null);

(statearr_11841_11925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (39))){
var state_11830__$1 = state_11830;
var statearr_11845_11926 = state_11830__$1;
(statearr_11845_11926[(2)] = null);

(statearr_11845_11926[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (4))){
var inst_11698 = (state_11830[(9)]);
var inst_11698__$1 = (state_11830[(2)]);
var inst_11699 = (inst_11698__$1 == null);
var state_11830__$1 = (function (){var statearr_11846 = state_11830;
(statearr_11846[(9)] = inst_11698__$1);

return statearr_11846;
})();
if(cljs.core.truth_(inst_11699)){
var statearr_11847_11927 = state_11830__$1;
(statearr_11847_11927[(1)] = (5));

} else {
var statearr_11848_11928 = state_11830__$1;
(statearr_11848_11928[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (15))){
var inst_11710 = (state_11830[(13)]);
var inst_11709 = (state_11830[(14)]);
var inst_11708 = (state_11830[(16)]);
var inst_11707 = (state_11830[(17)]);
var inst_11725 = (state_11830[(2)]);
var inst_11726 = (inst_11710 + (1));
var tmp11842 = inst_11709;
var tmp11843 = inst_11708;
var tmp11844 = inst_11707;
var inst_11707__$1 = tmp11844;
var inst_11708__$1 = tmp11843;
var inst_11709__$1 = tmp11842;
var inst_11710__$1 = inst_11726;
var state_11830__$1 = (function (){var statearr_11849 = state_11830;
(statearr_11849[(13)] = inst_11710__$1);

(statearr_11849[(18)] = inst_11725);

(statearr_11849[(14)] = inst_11709__$1);

(statearr_11849[(16)] = inst_11708__$1);

(statearr_11849[(17)] = inst_11707__$1);

return statearr_11849;
})();
var statearr_11850_11929 = state_11830__$1;
(statearr_11850_11929[(2)] = null);

(statearr_11850_11929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (21))){
var inst_11752 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11854_11930 = state_11830__$1;
(statearr_11854_11930[(2)] = inst_11752);

(statearr_11854_11930[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (31))){
var inst_11778 = (state_11830[(11)]);
var inst_11782 = done.call(null,null);
var inst_11783 = cljs.core.async.untap_STAR_.call(null,m,inst_11778);
var state_11830__$1 = (function (){var statearr_11855 = state_11830;
(statearr_11855[(19)] = inst_11782);

return statearr_11855;
})();
var statearr_11856_11931 = state_11830__$1;
(statearr_11856_11931[(2)] = inst_11783);

(statearr_11856_11931[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (32))){
var inst_11770 = (state_11830[(20)]);
var inst_11773 = (state_11830[(10)]);
var inst_11772 = (state_11830[(21)]);
var inst_11771 = (state_11830[(12)]);
var inst_11785 = (state_11830[(2)]);
var inst_11786 = (inst_11773 + (1));
var tmp11851 = inst_11770;
var tmp11852 = inst_11772;
var tmp11853 = inst_11771;
var inst_11770__$1 = tmp11851;
var inst_11771__$1 = tmp11853;
var inst_11772__$1 = tmp11852;
var inst_11773__$1 = inst_11786;
var state_11830__$1 = (function (){var statearr_11857 = state_11830;
(statearr_11857[(20)] = inst_11770__$1);

(statearr_11857[(22)] = inst_11785);

(statearr_11857[(10)] = inst_11773__$1);

(statearr_11857[(21)] = inst_11772__$1);

(statearr_11857[(12)] = inst_11771__$1);

return statearr_11857;
})();
var statearr_11858_11932 = state_11830__$1;
(statearr_11858_11932[(2)] = null);

(statearr_11858_11932[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (40))){
var inst_11798 = (state_11830[(23)]);
var inst_11802 = done.call(null,null);
var inst_11803 = cljs.core.async.untap_STAR_.call(null,m,inst_11798);
var state_11830__$1 = (function (){var statearr_11859 = state_11830;
(statearr_11859[(24)] = inst_11802);

return statearr_11859;
})();
var statearr_11860_11933 = state_11830__$1;
(statearr_11860_11933[(2)] = inst_11803);

(statearr_11860_11933[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (33))){
var inst_11789 = (state_11830[(25)]);
var inst_11791 = cljs.core.chunked_seq_QMARK_.call(null,inst_11789);
var state_11830__$1 = state_11830;
if(inst_11791){
var statearr_11861_11934 = state_11830__$1;
(statearr_11861_11934[(1)] = (36));

} else {
var statearr_11862_11935 = state_11830__$1;
(statearr_11862_11935[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (13))){
var inst_11719 = (state_11830[(26)]);
var inst_11722 = cljs.core.async.close_BANG_.call(null,inst_11719);
var state_11830__$1 = state_11830;
var statearr_11863_11936 = state_11830__$1;
(statearr_11863_11936[(2)] = inst_11722);

(statearr_11863_11936[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (22))){
var inst_11742 = (state_11830[(8)]);
var inst_11745 = cljs.core.async.close_BANG_.call(null,inst_11742);
var state_11830__$1 = state_11830;
var statearr_11864_11937 = state_11830__$1;
(statearr_11864_11937[(2)] = inst_11745);

(statearr_11864_11937[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (36))){
var inst_11789 = (state_11830[(25)]);
var inst_11793 = cljs.core.chunk_first.call(null,inst_11789);
var inst_11794 = cljs.core.chunk_rest.call(null,inst_11789);
var inst_11795 = cljs.core.count.call(null,inst_11793);
var inst_11770 = inst_11794;
var inst_11771 = inst_11793;
var inst_11772 = inst_11795;
var inst_11773 = (0);
var state_11830__$1 = (function (){var statearr_11865 = state_11830;
(statearr_11865[(20)] = inst_11770);

(statearr_11865[(10)] = inst_11773);

(statearr_11865[(21)] = inst_11772);

(statearr_11865[(12)] = inst_11771);

return statearr_11865;
})();
var statearr_11866_11938 = state_11830__$1;
(statearr_11866_11938[(2)] = null);

(statearr_11866_11938[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (41))){
var inst_11789 = (state_11830[(25)]);
var inst_11805 = (state_11830[(2)]);
var inst_11806 = cljs.core.next.call(null,inst_11789);
var inst_11770 = inst_11806;
var inst_11771 = null;
var inst_11772 = (0);
var inst_11773 = (0);
var state_11830__$1 = (function (){var statearr_11867 = state_11830;
(statearr_11867[(20)] = inst_11770);

(statearr_11867[(10)] = inst_11773);

(statearr_11867[(21)] = inst_11772);

(statearr_11867[(27)] = inst_11805);

(statearr_11867[(12)] = inst_11771);

return statearr_11867;
})();
var statearr_11868_11939 = state_11830__$1;
(statearr_11868_11939[(2)] = null);

(statearr_11868_11939[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (43))){
var state_11830__$1 = state_11830;
var statearr_11869_11940 = state_11830__$1;
(statearr_11869_11940[(2)] = null);

(statearr_11869_11940[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (29))){
var inst_11814 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11870_11941 = state_11830__$1;
(statearr_11870_11941[(2)] = inst_11814);

(statearr_11870_11941[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (44))){
var inst_11823 = (state_11830[(2)]);
var state_11830__$1 = (function (){var statearr_11871 = state_11830;
(statearr_11871[(28)] = inst_11823);

return statearr_11871;
})();
var statearr_11872_11942 = state_11830__$1;
(statearr_11872_11942[(2)] = null);

(statearr_11872_11942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (6))){
var inst_11762 = (state_11830[(29)]);
var inst_11761 = cljs.core.deref.call(null,cs);
var inst_11762__$1 = cljs.core.keys.call(null,inst_11761);
var inst_11763 = cljs.core.count.call(null,inst_11762__$1);
var inst_11764 = cljs.core.reset_BANG_.call(null,dctr,inst_11763);
var inst_11769 = cljs.core.seq.call(null,inst_11762__$1);
var inst_11770 = inst_11769;
var inst_11771 = null;
var inst_11772 = (0);
var inst_11773 = (0);
var state_11830__$1 = (function (){var statearr_11873 = state_11830;
(statearr_11873[(29)] = inst_11762__$1);

(statearr_11873[(20)] = inst_11770);

(statearr_11873[(10)] = inst_11773);

(statearr_11873[(21)] = inst_11772);

(statearr_11873[(30)] = inst_11764);

(statearr_11873[(12)] = inst_11771);

return statearr_11873;
})();
var statearr_11874_11943 = state_11830__$1;
(statearr_11874_11943[(2)] = null);

(statearr_11874_11943[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (28))){
var inst_11770 = (state_11830[(20)]);
var inst_11789 = (state_11830[(25)]);
var inst_11789__$1 = cljs.core.seq.call(null,inst_11770);
var state_11830__$1 = (function (){var statearr_11875 = state_11830;
(statearr_11875[(25)] = inst_11789__$1);

return statearr_11875;
})();
if(inst_11789__$1){
var statearr_11876_11944 = state_11830__$1;
(statearr_11876_11944[(1)] = (33));

} else {
var statearr_11877_11945 = state_11830__$1;
(statearr_11877_11945[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (25))){
var inst_11773 = (state_11830[(10)]);
var inst_11772 = (state_11830[(21)]);
var inst_11775 = (inst_11773 < inst_11772);
var inst_11776 = inst_11775;
var state_11830__$1 = state_11830;
if(cljs.core.truth_(inst_11776)){
var statearr_11878_11946 = state_11830__$1;
(statearr_11878_11946[(1)] = (27));

} else {
var statearr_11879_11947 = state_11830__$1;
(statearr_11879_11947[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (34))){
var state_11830__$1 = state_11830;
var statearr_11880_11948 = state_11830__$1;
(statearr_11880_11948[(2)] = null);

(statearr_11880_11948[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (17))){
var state_11830__$1 = state_11830;
var statearr_11881_11949 = state_11830__$1;
(statearr_11881_11949[(2)] = null);

(statearr_11881_11949[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (3))){
var inst_11828 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11830__$1,inst_11828);
} else {
if((state_val_11831 === (12))){
var inst_11757 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11882_11950 = state_11830__$1;
(statearr_11882_11950[(2)] = inst_11757);

(statearr_11882_11950[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (2))){
var state_11830__$1 = state_11830;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11830__$1,(4),ch);
} else {
if((state_val_11831 === (23))){
var state_11830__$1 = state_11830;
var statearr_11883_11951 = state_11830__$1;
(statearr_11883_11951[(2)] = null);

(statearr_11883_11951[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (35))){
var inst_11812 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11884_11952 = state_11830__$1;
(statearr_11884_11952[(2)] = inst_11812);

(statearr_11884_11952[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (19))){
var inst_11729 = (state_11830[(7)]);
var inst_11733 = cljs.core.chunk_first.call(null,inst_11729);
var inst_11734 = cljs.core.chunk_rest.call(null,inst_11729);
var inst_11735 = cljs.core.count.call(null,inst_11733);
var inst_11707 = inst_11734;
var inst_11708 = inst_11733;
var inst_11709 = inst_11735;
var inst_11710 = (0);
var state_11830__$1 = (function (){var statearr_11885 = state_11830;
(statearr_11885[(13)] = inst_11710);

(statearr_11885[(14)] = inst_11709);

(statearr_11885[(16)] = inst_11708);

(statearr_11885[(17)] = inst_11707);

return statearr_11885;
})();
var statearr_11886_11953 = state_11830__$1;
(statearr_11886_11953[(2)] = null);

(statearr_11886_11953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (11))){
var inst_11729 = (state_11830[(7)]);
var inst_11707 = (state_11830[(17)]);
var inst_11729__$1 = cljs.core.seq.call(null,inst_11707);
var state_11830__$1 = (function (){var statearr_11887 = state_11830;
(statearr_11887[(7)] = inst_11729__$1);

return statearr_11887;
})();
if(inst_11729__$1){
var statearr_11888_11954 = state_11830__$1;
(statearr_11888_11954[(1)] = (16));

} else {
var statearr_11889_11955 = state_11830__$1;
(statearr_11889_11955[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (9))){
var inst_11759 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11890_11956 = state_11830__$1;
(statearr_11890_11956[(2)] = inst_11759);

(statearr_11890_11956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (5))){
var inst_11705 = cljs.core.deref.call(null,cs);
var inst_11706 = cljs.core.seq.call(null,inst_11705);
var inst_11707 = inst_11706;
var inst_11708 = null;
var inst_11709 = (0);
var inst_11710 = (0);
var state_11830__$1 = (function (){var statearr_11891 = state_11830;
(statearr_11891[(13)] = inst_11710);

(statearr_11891[(14)] = inst_11709);

(statearr_11891[(16)] = inst_11708);

(statearr_11891[(17)] = inst_11707);

return statearr_11891;
})();
var statearr_11892_11957 = state_11830__$1;
(statearr_11892_11957[(2)] = null);

(statearr_11892_11957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (14))){
var state_11830__$1 = state_11830;
var statearr_11893_11958 = state_11830__$1;
(statearr_11893_11958[(2)] = null);

(statearr_11893_11958[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (45))){
var inst_11820 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11894_11959 = state_11830__$1;
(statearr_11894_11959[(2)] = inst_11820);

(statearr_11894_11959[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (26))){
var inst_11762 = (state_11830[(29)]);
var inst_11816 = (state_11830[(2)]);
var inst_11817 = cljs.core.seq.call(null,inst_11762);
var state_11830__$1 = (function (){var statearr_11895 = state_11830;
(statearr_11895[(31)] = inst_11816);

return statearr_11895;
})();
if(inst_11817){
var statearr_11896_11960 = state_11830__$1;
(statearr_11896_11960[(1)] = (42));

} else {
var statearr_11897_11961 = state_11830__$1;
(statearr_11897_11961[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (16))){
var inst_11729 = (state_11830[(7)]);
var inst_11731 = cljs.core.chunked_seq_QMARK_.call(null,inst_11729);
var state_11830__$1 = state_11830;
if(inst_11731){
var statearr_11898_11962 = state_11830__$1;
(statearr_11898_11962[(1)] = (19));

} else {
var statearr_11899_11963 = state_11830__$1;
(statearr_11899_11963[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (38))){
var inst_11809 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11900_11964 = state_11830__$1;
(statearr_11900_11964[(2)] = inst_11809);

(statearr_11900_11964[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (30))){
var state_11830__$1 = state_11830;
var statearr_11901_11965 = state_11830__$1;
(statearr_11901_11965[(2)] = null);

(statearr_11901_11965[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (10))){
var inst_11710 = (state_11830[(13)]);
var inst_11708 = (state_11830[(16)]);
var inst_11718 = cljs.core._nth.call(null,inst_11708,inst_11710);
var inst_11719 = cljs.core.nth.call(null,inst_11718,(0),null);
var inst_11720 = cljs.core.nth.call(null,inst_11718,(1),null);
var state_11830__$1 = (function (){var statearr_11902 = state_11830;
(statearr_11902[(26)] = inst_11719);

return statearr_11902;
})();
if(cljs.core.truth_(inst_11720)){
var statearr_11903_11966 = state_11830__$1;
(statearr_11903_11966[(1)] = (13));

} else {
var statearr_11904_11967 = state_11830__$1;
(statearr_11904_11967[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (18))){
var inst_11755 = (state_11830[(2)]);
var state_11830__$1 = state_11830;
var statearr_11905_11968 = state_11830__$1;
(statearr_11905_11968[(2)] = inst_11755);

(statearr_11905_11968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (42))){
var state_11830__$1 = state_11830;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11830__$1,(45),dchan);
} else {
if((state_val_11831 === (37))){
var inst_11698 = (state_11830[(9)]);
var inst_11789 = (state_11830[(25)]);
var inst_11798 = (state_11830[(23)]);
var inst_11798__$1 = cljs.core.first.call(null,inst_11789);
var inst_11799 = cljs.core.async.put_BANG_.call(null,inst_11798__$1,inst_11698,done);
var state_11830__$1 = (function (){var statearr_11906 = state_11830;
(statearr_11906[(23)] = inst_11798__$1);

return statearr_11906;
})();
if(cljs.core.truth_(inst_11799)){
var statearr_11907_11969 = state_11830__$1;
(statearr_11907_11969[(1)] = (39));

} else {
var statearr_11908_11970 = state_11830__$1;
(statearr_11908_11970[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11831 === (8))){
var inst_11710 = (state_11830[(13)]);
var inst_11709 = (state_11830[(14)]);
var inst_11712 = (inst_11710 < inst_11709);
var inst_11713 = inst_11712;
var state_11830__$1 = state_11830;
if(cljs.core.truth_(inst_11713)){
var statearr_11909_11971 = state_11830__$1;
(statearr_11909_11971[(1)] = (10));

} else {
var statearr_11910_11972 = state_11830__$1;
(statearr_11910_11972[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___11918,cs,m,dchan,dctr,done))
;
return ((function (switch__10483__auto__,c__10595__auto___11918,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10484__auto__ = null;
var cljs$core$async$mult_$_state_machine__10484__auto____0 = (function (){
var statearr_11914 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11914[(0)] = cljs$core$async$mult_$_state_machine__10484__auto__);

(statearr_11914[(1)] = (1));

return statearr_11914;
});
var cljs$core$async$mult_$_state_machine__10484__auto____1 = (function (state_11830){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_11830);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e11915){if((e11915 instanceof Object)){
var ex__10487__auto__ = e11915;
var statearr_11916_11973 = state_11830;
(statearr_11916_11973[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11830);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11915;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11974 = state_11830;
state_11830 = G__11974;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10484__auto__ = function(state_11830){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10484__auto____1.call(this,state_11830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10484__auto____0;
cljs$core$async$mult_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10484__auto____1;
return cljs$core$async$mult_$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___11918,cs,m,dchan,dctr,done))
})();
var state__10597__auto__ = (function (){var statearr_11917 = f__10596__auto__.call(null);
(statearr_11917[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___11918);

return statearr_11917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___11918,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args11975 = [];
var len__7484__auto___11978 = arguments.length;
var i__7485__auto___11979 = (0);
while(true){
if((i__7485__auto___11979 < len__7484__auto___11978)){
args11975.push((arguments[i__7485__auto___11979]));

var G__11980 = (i__7485__auto___11979 + (1));
i__7485__auto___11979 = G__11980;
continue;
} else {
}
break;
}

var G__11977 = args11975.length;
switch (G__11977) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11975.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___11992 = arguments.length;
var i__7485__auto___11993 = (0);
while(true){
if((i__7485__auto___11993 < len__7484__auto___11992)){
args__7491__auto__.push((arguments[i__7485__auto___11993]));

var G__11994 = (i__7485__auto___11993 + (1));
i__7485__auto___11993 = G__11994;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__11986){
var map__11987 = p__11986;
var map__11987__$1 = ((((!((map__11987 == null)))?((((map__11987.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11987.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11987):map__11987);
var opts = map__11987__$1;
var statearr_11989_11995 = state;
(statearr_11989_11995[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__11987,map__11987__$1,opts){
return (function (val){
var statearr_11990_11996 = state;
(statearr_11990_11996[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__11987,map__11987__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_11991_11997 = state;
(statearr_11991_11997[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq11982){
var G__11983 = cljs.core.first.call(null,seq11982);
var seq11982__$1 = cljs.core.next.call(null,seq11982);
var G__11984 = cljs.core.first.call(null,seq11982__$1);
var seq11982__$2 = cljs.core.next.call(null,seq11982__$1);
var G__11985 = cljs.core.first.call(null,seq11982__$2);
var seq11982__$3 = cljs.core.next.call(null,seq11982__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11983,G__11984,G__11985,seq11982__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12163 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12163 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12164){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12164 = meta12164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12165,meta12164__$1){
var self__ = this;
var _12165__$1 = this;
return (new cljs.core.async.t_cljs$core$async12163(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12164__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12165){
var self__ = this;
var _12165__$1 = this;
return self__.meta12164;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12164","meta12164",1069289599,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12163.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12163.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12163";

cljs.core.async.t_cljs$core$async12163.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12163");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12163 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12163(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12164){
return (new cljs.core.async.t_cljs$core$async12163(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12164));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12163(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10595__auto___12328 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___12328,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___12328,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12265){
var state_val_12266 = (state_12265[(1)]);
if((state_val_12266 === (7))){
var inst_12181 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
var statearr_12267_12329 = state_12265__$1;
(statearr_12267_12329[(2)] = inst_12181);

(statearr_12267_12329[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (20))){
var inst_12193 = (state_12265[(7)]);
var state_12265__$1 = state_12265;
var statearr_12268_12330 = state_12265__$1;
(statearr_12268_12330[(2)] = inst_12193);

(statearr_12268_12330[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (27))){
var state_12265__$1 = state_12265;
var statearr_12269_12331 = state_12265__$1;
(statearr_12269_12331[(2)] = null);

(statearr_12269_12331[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (1))){
var inst_12169 = (state_12265[(8)]);
var inst_12169__$1 = calc_state.call(null);
var inst_12171 = (inst_12169__$1 == null);
var inst_12172 = cljs.core.not.call(null,inst_12171);
var state_12265__$1 = (function (){var statearr_12270 = state_12265;
(statearr_12270[(8)] = inst_12169__$1);

return statearr_12270;
})();
if(inst_12172){
var statearr_12271_12332 = state_12265__$1;
(statearr_12271_12332[(1)] = (2));

} else {
var statearr_12272_12333 = state_12265__$1;
(statearr_12272_12333[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (24))){
var inst_12216 = (state_12265[(9)]);
var inst_12239 = (state_12265[(10)]);
var inst_12225 = (state_12265[(11)]);
var inst_12239__$1 = inst_12216.call(null,inst_12225);
var state_12265__$1 = (function (){var statearr_12273 = state_12265;
(statearr_12273[(10)] = inst_12239__$1);

return statearr_12273;
})();
if(cljs.core.truth_(inst_12239__$1)){
var statearr_12274_12334 = state_12265__$1;
(statearr_12274_12334[(1)] = (29));

} else {
var statearr_12275_12335 = state_12265__$1;
(statearr_12275_12335[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (4))){
var inst_12184 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
if(cljs.core.truth_(inst_12184)){
var statearr_12276_12336 = state_12265__$1;
(statearr_12276_12336[(1)] = (8));

} else {
var statearr_12277_12337 = state_12265__$1;
(statearr_12277_12337[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (15))){
var inst_12210 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
if(cljs.core.truth_(inst_12210)){
var statearr_12278_12338 = state_12265__$1;
(statearr_12278_12338[(1)] = (19));

} else {
var statearr_12279_12339 = state_12265__$1;
(statearr_12279_12339[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (21))){
var inst_12215 = (state_12265[(12)]);
var inst_12215__$1 = (state_12265[(2)]);
var inst_12216 = cljs.core.get.call(null,inst_12215__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12217 = cljs.core.get.call(null,inst_12215__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12218 = cljs.core.get.call(null,inst_12215__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12265__$1 = (function (){var statearr_12280 = state_12265;
(statearr_12280[(9)] = inst_12216);

(statearr_12280[(13)] = inst_12217);

(statearr_12280[(12)] = inst_12215__$1);

return statearr_12280;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12265__$1,(22),inst_12218);
} else {
if((state_val_12266 === (31))){
var inst_12247 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
if(cljs.core.truth_(inst_12247)){
var statearr_12281_12340 = state_12265__$1;
(statearr_12281_12340[(1)] = (32));

} else {
var statearr_12282_12341 = state_12265__$1;
(statearr_12282_12341[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (32))){
var inst_12224 = (state_12265[(14)]);
var state_12265__$1 = state_12265;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12265__$1,(35),out,inst_12224);
} else {
if((state_val_12266 === (33))){
var inst_12215 = (state_12265[(12)]);
var inst_12193 = inst_12215;
var state_12265__$1 = (function (){var statearr_12283 = state_12265;
(statearr_12283[(7)] = inst_12193);

return statearr_12283;
})();
var statearr_12284_12342 = state_12265__$1;
(statearr_12284_12342[(2)] = null);

(statearr_12284_12342[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (13))){
var inst_12193 = (state_12265[(7)]);
var inst_12200 = inst_12193.cljs$lang$protocol_mask$partition0$;
var inst_12201 = (inst_12200 & (64));
var inst_12202 = inst_12193.cljs$core$ISeq$;
var inst_12203 = (inst_12201) || (inst_12202);
var state_12265__$1 = state_12265;
if(cljs.core.truth_(inst_12203)){
var statearr_12285_12343 = state_12265__$1;
(statearr_12285_12343[(1)] = (16));

} else {
var statearr_12286_12344 = state_12265__$1;
(statearr_12286_12344[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (22))){
var inst_12224 = (state_12265[(14)]);
var inst_12225 = (state_12265[(11)]);
var inst_12223 = (state_12265[(2)]);
var inst_12224__$1 = cljs.core.nth.call(null,inst_12223,(0),null);
var inst_12225__$1 = cljs.core.nth.call(null,inst_12223,(1),null);
var inst_12226 = (inst_12224__$1 == null);
var inst_12227 = cljs.core._EQ_.call(null,inst_12225__$1,change);
var inst_12228 = (inst_12226) || (inst_12227);
var state_12265__$1 = (function (){var statearr_12287 = state_12265;
(statearr_12287[(14)] = inst_12224__$1);

(statearr_12287[(11)] = inst_12225__$1);

return statearr_12287;
})();
if(cljs.core.truth_(inst_12228)){
var statearr_12288_12345 = state_12265__$1;
(statearr_12288_12345[(1)] = (23));

} else {
var statearr_12289_12346 = state_12265__$1;
(statearr_12289_12346[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (36))){
var inst_12215 = (state_12265[(12)]);
var inst_12193 = inst_12215;
var state_12265__$1 = (function (){var statearr_12290 = state_12265;
(statearr_12290[(7)] = inst_12193);

return statearr_12290;
})();
var statearr_12291_12347 = state_12265__$1;
(statearr_12291_12347[(2)] = null);

(statearr_12291_12347[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (29))){
var inst_12239 = (state_12265[(10)]);
var state_12265__$1 = state_12265;
var statearr_12292_12348 = state_12265__$1;
(statearr_12292_12348[(2)] = inst_12239);

(statearr_12292_12348[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (6))){
var state_12265__$1 = state_12265;
var statearr_12293_12349 = state_12265__$1;
(statearr_12293_12349[(2)] = false);

(statearr_12293_12349[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (28))){
var inst_12235 = (state_12265[(2)]);
var inst_12236 = calc_state.call(null);
var inst_12193 = inst_12236;
var state_12265__$1 = (function (){var statearr_12294 = state_12265;
(statearr_12294[(7)] = inst_12193);

(statearr_12294[(15)] = inst_12235);

return statearr_12294;
})();
var statearr_12295_12350 = state_12265__$1;
(statearr_12295_12350[(2)] = null);

(statearr_12295_12350[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (25))){
var inst_12261 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
var statearr_12296_12351 = state_12265__$1;
(statearr_12296_12351[(2)] = inst_12261);

(statearr_12296_12351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (34))){
var inst_12259 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
var statearr_12297_12352 = state_12265__$1;
(statearr_12297_12352[(2)] = inst_12259);

(statearr_12297_12352[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (17))){
var state_12265__$1 = state_12265;
var statearr_12298_12353 = state_12265__$1;
(statearr_12298_12353[(2)] = false);

(statearr_12298_12353[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (3))){
var state_12265__$1 = state_12265;
var statearr_12299_12354 = state_12265__$1;
(statearr_12299_12354[(2)] = false);

(statearr_12299_12354[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (12))){
var inst_12263 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12265__$1,inst_12263);
} else {
if((state_val_12266 === (2))){
var inst_12169 = (state_12265[(8)]);
var inst_12174 = inst_12169.cljs$lang$protocol_mask$partition0$;
var inst_12175 = (inst_12174 & (64));
var inst_12176 = inst_12169.cljs$core$ISeq$;
var inst_12177 = (inst_12175) || (inst_12176);
var state_12265__$1 = state_12265;
if(cljs.core.truth_(inst_12177)){
var statearr_12300_12355 = state_12265__$1;
(statearr_12300_12355[(1)] = (5));

} else {
var statearr_12301_12356 = state_12265__$1;
(statearr_12301_12356[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (23))){
var inst_12224 = (state_12265[(14)]);
var inst_12230 = (inst_12224 == null);
var state_12265__$1 = state_12265;
if(cljs.core.truth_(inst_12230)){
var statearr_12302_12357 = state_12265__$1;
(statearr_12302_12357[(1)] = (26));

} else {
var statearr_12303_12358 = state_12265__$1;
(statearr_12303_12358[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (35))){
var inst_12250 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
if(cljs.core.truth_(inst_12250)){
var statearr_12304_12359 = state_12265__$1;
(statearr_12304_12359[(1)] = (36));

} else {
var statearr_12305_12360 = state_12265__$1;
(statearr_12305_12360[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (19))){
var inst_12193 = (state_12265[(7)]);
var inst_12212 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12193);
var state_12265__$1 = state_12265;
var statearr_12306_12361 = state_12265__$1;
(statearr_12306_12361[(2)] = inst_12212);

(statearr_12306_12361[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (11))){
var inst_12193 = (state_12265[(7)]);
var inst_12197 = (inst_12193 == null);
var inst_12198 = cljs.core.not.call(null,inst_12197);
var state_12265__$1 = state_12265;
if(inst_12198){
var statearr_12307_12362 = state_12265__$1;
(statearr_12307_12362[(1)] = (13));

} else {
var statearr_12308_12363 = state_12265__$1;
(statearr_12308_12363[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (9))){
var inst_12169 = (state_12265[(8)]);
var state_12265__$1 = state_12265;
var statearr_12309_12364 = state_12265__$1;
(statearr_12309_12364[(2)] = inst_12169);

(statearr_12309_12364[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (5))){
var state_12265__$1 = state_12265;
var statearr_12310_12365 = state_12265__$1;
(statearr_12310_12365[(2)] = true);

(statearr_12310_12365[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (14))){
var state_12265__$1 = state_12265;
var statearr_12311_12366 = state_12265__$1;
(statearr_12311_12366[(2)] = false);

(statearr_12311_12366[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (26))){
var inst_12225 = (state_12265[(11)]);
var inst_12232 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12225);
var state_12265__$1 = state_12265;
var statearr_12312_12367 = state_12265__$1;
(statearr_12312_12367[(2)] = inst_12232);

(statearr_12312_12367[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (16))){
var state_12265__$1 = state_12265;
var statearr_12313_12368 = state_12265__$1;
(statearr_12313_12368[(2)] = true);

(statearr_12313_12368[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (38))){
var inst_12255 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
var statearr_12314_12369 = state_12265__$1;
(statearr_12314_12369[(2)] = inst_12255);

(statearr_12314_12369[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (30))){
var inst_12216 = (state_12265[(9)]);
var inst_12217 = (state_12265[(13)]);
var inst_12225 = (state_12265[(11)]);
var inst_12242 = cljs.core.empty_QMARK_.call(null,inst_12216);
var inst_12243 = inst_12217.call(null,inst_12225);
var inst_12244 = cljs.core.not.call(null,inst_12243);
var inst_12245 = (inst_12242) && (inst_12244);
var state_12265__$1 = state_12265;
var statearr_12315_12370 = state_12265__$1;
(statearr_12315_12370[(2)] = inst_12245);

(statearr_12315_12370[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (10))){
var inst_12169 = (state_12265[(8)]);
var inst_12189 = (state_12265[(2)]);
var inst_12190 = cljs.core.get.call(null,inst_12189,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12191 = cljs.core.get.call(null,inst_12189,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12192 = cljs.core.get.call(null,inst_12189,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12193 = inst_12169;
var state_12265__$1 = (function (){var statearr_12316 = state_12265;
(statearr_12316[(16)] = inst_12192);

(statearr_12316[(17)] = inst_12190);

(statearr_12316[(18)] = inst_12191);

(statearr_12316[(7)] = inst_12193);

return statearr_12316;
})();
var statearr_12317_12371 = state_12265__$1;
(statearr_12317_12371[(2)] = null);

(statearr_12317_12371[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (18))){
var inst_12207 = (state_12265[(2)]);
var state_12265__$1 = state_12265;
var statearr_12318_12372 = state_12265__$1;
(statearr_12318_12372[(2)] = inst_12207);

(statearr_12318_12372[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (37))){
var state_12265__$1 = state_12265;
var statearr_12319_12373 = state_12265__$1;
(statearr_12319_12373[(2)] = null);

(statearr_12319_12373[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12266 === (8))){
var inst_12169 = (state_12265[(8)]);
var inst_12186 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12169);
var state_12265__$1 = state_12265;
var statearr_12320_12374 = state_12265__$1;
(statearr_12320_12374[(2)] = inst_12186);

(statearr_12320_12374[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___12328,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10483__auto__,c__10595__auto___12328,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10484__auto__ = null;
var cljs$core$async$mix_$_state_machine__10484__auto____0 = (function (){
var statearr_12324 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12324[(0)] = cljs$core$async$mix_$_state_machine__10484__auto__);

(statearr_12324[(1)] = (1));

return statearr_12324;
});
var cljs$core$async$mix_$_state_machine__10484__auto____1 = (function (state_12265){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_12265);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e12325){if((e12325 instanceof Object)){
var ex__10487__auto__ = e12325;
var statearr_12326_12375 = state_12265;
(statearr_12326_12375[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12265);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12325;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12376 = state_12265;
state_12265 = G__12376;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10484__auto__ = function(state_12265){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10484__auto____1.call(this,state_12265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10484__auto____0;
cljs$core$async$mix_$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10484__auto____1;
return cljs$core$async$mix_$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___12328,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__10597__auto__ = (function (){var statearr_12327 = f__10596__auto__.call(null);
(statearr_12327[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___12328);

return statearr_12327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___12328,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12377 = [];
var len__7484__auto___12380 = arguments.length;
var i__7485__auto___12381 = (0);
while(true){
if((i__7485__auto___12381 < len__7484__auto___12380)){
args12377.push((arguments[i__7485__auto___12381]));

var G__12382 = (i__7485__auto___12381 + (1));
i__7485__auto___12381 = G__12382;
continue;
} else {
}
break;
}

var G__12379 = args12377.length;
switch (G__12379) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12377.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12385 = [];
var len__7484__auto___12510 = arguments.length;
var i__7485__auto___12511 = (0);
while(true){
if((i__7485__auto___12511 < len__7484__auto___12510)){
args12385.push((arguments[i__7485__auto___12511]));

var G__12512 = (i__7485__auto___12511 + (1));
i__7485__auto___12511 = G__12512;
continue;
} else {
}
break;
}

var G__12387 = args12385.length;
switch (G__12387) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12385.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__12384_SHARP_){
if(cljs.core.truth_(p1__12384_SHARP_.call(null,topic))){
return p1__12384_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12384_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12388 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12388 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12389){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12389 = meta12389;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12390,meta12389__$1){
var self__ = this;
var _12390__$1 = this;
return (new cljs.core.async.t_cljs$core$async12388(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12389__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12390){
var self__ = this;
var _12390__$1 = this;
return self__.meta12389;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12388.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12388.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12389","meta12389",-1505098084,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12388.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12388.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12388";

cljs.core.async.t_cljs$core$async12388.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12388");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12388 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12388(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12389){
return (new cljs.core.async.t_cljs$core$async12388(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12389));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12388(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10595__auto___12514 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___12514,mults,ensure_mult,p){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___12514,mults,ensure_mult,p){
return (function (state_12462){
var state_val_12463 = (state_12462[(1)]);
if((state_val_12463 === (7))){
var inst_12458 = (state_12462[(2)]);
var state_12462__$1 = state_12462;
var statearr_12464_12515 = state_12462__$1;
(statearr_12464_12515[(2)] = inst_12458);

(statearr_12464_12515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (20))){
var state_12462__$1 = state_12462;
var statearr_12465_12516 = state_12462__$1;
(statearr_12465_12516[(2)] = null);

(statearr_12465_12516[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (1))){
var state_12462__$1 = state_12462;
var statearr_12466_12517 = state_12462__$1;
(statearr_12466_12517[(2)] = null);

(statearr_12466_12517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (24))){
var inst_12441 = (state_12462[(7)]);
var inst_12450 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12441);
var state_12462__$1 = state_12462;
var statearr_12467_12518 = state_12462__$1;
(statearr_12467_12518[(2)] = inst_12450);

(statearr_12467_12518[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (4))){
var inst_12393 = (state_12462[(8)]);
var inst_12393__$1 = (state_12462[(2)]);
var inst_12394 = (inst_12393__$1 == null);
var state_12462__$1 = (function (){var statearr_12468 = state_12462;
(statearr_12468[(8)] = inst_12393__$1);

return statearr_12468;
})();
if(cljs.core.truth_(inst_12394)){
var statearr_12469_12519 = state_12462__$1;
(statearr_12469_12519[(1)] = (5));

} else {
var statearr_12470_12520 = state_12462__$1;
(statearr_12470_12520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (15))){
var inst_12435 = (state_12462[(2)]);
var state_12462__$1 = state_12462;
var statearr_12471_12521 = state_12462__$1;
(statearr_12471_12521[(2)] = inst_12435);

(statearr_12471_12521[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (21))){
var inst_12455 = (state_12462[(2)]);
var state_12462__$1 = (function (){var statearr_12472 = state_12462;
(statearr_12472[(9)] = inst_12455);

return statearr_12472;
})();
var statearr_12473_12522 = state_12462__$1;
(statearr_12473_12522[(2)] = null);

(statearr_12473_12522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (13))){
var inst_12417 = (state_12462[(10)]);
var inst_12419 = cljs.core.chunked_seq_QMARK_.call(null,inst_12417);
var state_12462__$1 = state_12462;
if(inst_12419){
var statearr_12474_12523 = state_12462__$1;
(statearr_12474_12523[(1)] = (16));

} else {
var statearr_12475_12524 = state_12462__$1;
(statearr_12475_12524[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (22))){
var inst_12447 = (state_12462[(2)]);
var state_12462__$1 = state_12462;
if(cljs.core.truth_(inst_12447)){
var statearr_12476_12525 = state_12462__$1;
(statearr_12476_12525[(1)] = (23));

} else {
var statearr_12477_12526 = state_12462__$1;
(statearr_12477_12526[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (6))){
var inst_12443 = (state_12462[(11)]);
var inst_12441 = (state_12462[(7)]);
var inst_12393 = (state_12462[(8)]);
var inst_12441__$1 = topic_fn.call(null,inst_12393);
var inst_12442 = cljs.core.deref.call(null,mults);
var inst_12443__$1 = cljs.core.get.call(null,inst_12442,inst_12441__$1);
var state_12462__$1 = (function (){var statearr_12478 = state_12462;
(statearr_12478[(11)] = inst_12443__$1);

(statearr_12478[(7)] = inst_12441__$1);

return statearr_12478;
})();
if(cljs.core.truth_(inst_12443__$1)){
var statearr_12479_12527 = state_12462__$1;
(statearr_12479_12527[(1)] = (19));

} else {
var statearr_12480_12528 = state_12462__$1;
(statearr_12480_12528[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (25))){
var inst_12452 = (state_12462[(2)]);
var state_12462__$1 = state_12462;
var statearr_12481_12529 = state_12462__$1;
(statearr_12481_12529[(2)] = inst_12452);

(statearr_12481_12529[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (17))){
var inst_12417 = (state_12462[(10)]);
var inst_12426 = cljs.core.first.call(null,inst_12417);
var inst_12427 = cljs.core.async.muxch_STAR_.call(null,inst_12426);
var inst_12428 = cljs.core.async.close_BANG_.call(null,inst_12427);
var inst_12429 = cljs.core.next.call(null,inst_12417);
var inst_12403 = inst_12429;
var inst_12404 = null;
var inst_12405 = (0);
var inst_12406 = (0);
var state_12462__$1 = (function (){var statearr_12482 = state_12462;
(statearr_12482[(12)] = inst_12404);

(statearr_12482[(13)] = inst_12406);

(statearr_12482[(14)] = inst_12403);

(statearr_12482[(15)] = inst_12405);

(statearr_12482[(16)] = inst_12428);

return statearr_12482;
})();
var statearr_12483_12530 = state_12462__$1;
(statearr_12483_12530[(2)] = null);

(statearr_12483_12530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (3))){
var inst_12460 = (state_12462[(2)]);
var state_12462__$1 = state_12462;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12462__$1,inst_12460);
} else {
if((state_val_12463 === (12))){
var inst_12437 = (state_12462[(2)]);
var state_12462__$1 = state_12462;
var statearr_12484_12531 = state_12462__$1;
(statearr_12484_12531[(2)] = inst_12437);

(statearr_12484_12531[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (2))){
var state_12462__$1 = state_12462;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12462__$1,(4),ch);
} else {
if((state_val_12463 === (23))){
var state_12462__$1 = state_12462;
var statearr_12485_12532 = state_12462__$1;
(statearr_12485_12532[(2)] = null);

(statearr_12485_12532[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (19))){
var inst_12443 = (state_12462[(11)]);
var inst_12393 = (state_12462[(8)]);
var inst_12445 = cljs.core.async.muxch_STAR_.call(null,inst_12443);
var state_12462__$1 = state_12462;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12462__$1,(22),inst_12445,inst_12393);
} else {
if((state_val_12463 === (11))){
var inst_12417 = (state_12462[(10)]);
var inst_12403 = (state_12462[(14)]);
var inst_12417__$1 = cljs.core.seq.call(null,inst_12403);
var state_12462__$1 = (function (){var statearr_12486 = state_12462;
(statearr_12486[(10)] = inst_12417__$1);

return statearr_12486;
})();
if(inst_12417__$1){
var statearr_12487_12533 = state_12462__$1;
(statearr_12487_12533[(1)] = (13));

} else {
var statearr_12488_12534 = state_12462__$1;
(statearr_12488_12534[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (9))){
var inst_12439 = (state_12462[(2)]);
var state_12462__$1 = state_12462;
var statearr_12489_12535 = state_12462__$1;
(statearr_12489_12535[(2)] = inst_12439);

(statearr_12489_12535[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (5))){
var inst_12400 = cljs.core.deref.call(null,mults);
var inst_12401 = cljs.core.vals.call(null,inst_12400);
var inst_12402 = cljs.core.seq.call(null,inst_12401);
var inst_12403 = inst_12402;
var inst_12404 = null;
var inst_12405 = (0);
var inst_12406 = (0);
var state_12462__$1 = (function (){var statearr_12490 = state_12462;
(statearr_12490[(12)] = inst_12404);

(statearr_12490[(13)] = inst_12406);

(statearr_12490[(14)] = inst_12403);

(statearr_12490[(15)] = inst_12405);

return statearr_12490;
})();
var statearr_12491_12536 = state_12462__$1;
(statearr_12491_12536[(2)] = null);

(statearr_12491_12536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (14))){
var state_12462__$1 = state_12462;
var statearr_12495_12537 = state_12462__$1;
(statearr_12495_12537[(2)] = null);

(statearr_12495_12537[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (16))){
var inst_12417 = (state_12462[(10)]);
var inst_12421 = cljs.core.chunk_first.call(null,inst_12417);
var inst_12422 = cljs.core.chunk_rest.call(null,inst_12417);
var inst_12423 = cljs.core.count.call(null,inst_12421);
var inst_12403 = inst_12422;
var inst_12404 = inst_12421;
var inst_12405 = inst_12423;
var inst_12406 = (0);
var state_12462__$1 = (function (){var statearr_12496 = state_12462;
(statearr_12496[(12)] = inst_12404);

(statearr_12496[(13)] = inst_12406);

(statearr_12496[(14)] = inst_12403);

(statearr_12496[(15)] = inst_12405);

return statearr_12496;
})();
var statearr_12497_12538 = state_12462__$1;
(statearr_12497_12538[(2)] = null);

(statearr_12497_12538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (10))){
var inst_12404 = (state_12462[(12)]);
var inst_12406 = (state_12462[(13)]);
var inst_12403 = (state_12462[(14)]);
var inst_12405 = (state_12462[(15)]);
var inst_12411 = cljs.core._nth.call(null,inst_12404,inst_12406);
var inst_12412 = cljs.core.async.muxch_STAR_.call(null,inst_12411);
var inst_12413 = cljs.core.async.close_BANG_.call(null,inst_12412);
var inst_12414 = (inst_12406 + (1));
var tmp12492 = inst_12404;
var tmp12493 = inst_12403;
var tmp12494 = inst_12405;
var inst_12403__$1 = tmp12493;
var inst_12404__$1 = tmp12492;
var inst_12405__$1 = tmp12494;
var inst_12406__$1 = inst_12414;
var state_12462__$1 = (function (){var statearr_12498 = state_12462;
(statearr_12498[(12)] = inst_12404__$1);

(statearr_12498[(17)] = inst_12413);

(statearr_12498[(13)] = inst_12406__$1);

(statearr_12498[(14)] = inst_12403__$1);

(statearr_12498[(15)] = inst_12405__$1);

return statearr_12498;
})();
var statearr_12499_12539 = state_12462__$1;
(statearr_12499_12539[(2)] = null);

(statearr_12499_12539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (18))){
var inst_12432 = (state_12462[(2)]);
var state_12462__$1 = state_12462;
var statearr_12500_12540 = state_12462__$1;
(statearr_12500_12540[(2)] = inst_12432);

(statearr_12500_12540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12463 === (8))){
var inst_12406 = (state_12462[(13)]);
var inst_12405 = (state_12462[(15)]);
var inst_12408 = (inst_12406 < inst_12405);
var inst_12409 = inst_12408;
var state_12462__$1 = state_12462;
if(cljs.core.truth_(inst_12409)){
var statearr_12501_12541 = state_12462__$1;
(statearr_12501_12541[(1)] = (10));

} else {
var statearr_12502_12542 = state_12462__$1;
(statearr_12502_12542[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___12514,mults,ensure_mult,p))
;
return ((function (switch__10483__auto__,c__10595__auto___12514,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_12506 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12506[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_12506[(1)] = (1));

return statearr_12506;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_12462){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_12462);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e12507){if((e12507 instanceof Object)){
var ex__10487__auto__ = e12507;
var statearr_12508_12543 = state_12462;
(statearr_12508_12543[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12462);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12507;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12544 = state_12462;
state_12462 = G__12544;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_12462){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_12462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___12514,mults,ensure_mult,p))
})();
var state__10597__auto__ = (function (){var statearr_12509 = f__10596__auto__.call(null);
(statearr_12509[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___12514);

return statearr_12509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___12514,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args12545 = [];
var len__7484__auto___12548 = arguments.length;
var i__7485__auto___12549 = (0);
while(true){
if((i__7485__auto___12549 < len__7484__auto___12548)){
args12545.push((arguments[i__7485__auto___12549]));

var G__12550 = (i__7485__auto___12549 + (1));
i__7485__auto___12549 = G__12550;
continue;
} else {
}
break;
}

var G__12547 = args12545.length;
switch (G__12547) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12545.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args12552 = [];
var len__7484__auto___12555 = arguments.length;
var i__7485__auto___12556 = (0);
while(true){
if((i__7485__auto___12556 < len__7484__auto___12555)){
args12552.push((arguments[i__7485__auto___12556]));

var G__12557 = (i__7485__auto___12556 + (1));
i__7485__auto___12556 = G__12557;
continue;
} else {
}
break;
}

var G__12554 = args12552.length;
switch (G__12554) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12552.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args12559 = [];
var len__7484__auto___12630 = arguments.length;
var i__7485__auto___12631 = (0);
while(true){
if((i__7485__auto___12631 < len__7484__auto___12630)){
args12559.push((arguments[i__7485__auto___12631]));

var G__12632 = (i__7485__auto___12631 + (1));
i__7485__auto___12631 = G__12632;
continue;
} else {
}
break;
}

var G__12561 = args12559.length;
switch (G__12561) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12559.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__10595__auto___12634 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___12634,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___12634,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_12600){
var state_val_12601 = (state_12600[(1)]);
if((state_val_12601 === (7))){
var state_12600__$1 = state_12600;
var statearr_12602_12635 = state_12600__$1;
(statearr_12602_12635[(2)] = null);

(statearr_12602_12635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (1))){
var state_12600__$1 = state_12600;
var statearr_12603_12636 = state_12600__$1;
(statearr_12603_12636[(2)] = null);

(statearr_12603_12636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (4))){
var inst_12564 = (state_12600[(7)]);
var inst_12566 = (inst_12564 < cnt);
var state_12600__$1 = state_12600;
if(cljs.core.truth_(inst_12566)){
var statearr_12604_12637 = state_12600__$1;
(statearr_12604_12637[(1)] = (6));

} else {
var statearr_12605_12638 = state_12600__$1;
(statearr_12605_12638[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (15))){
var inst_12596 = (state_12600[(2)]);
var state_12600__$1 = state_12600;
var statearr_12606_12639 = state_12600__$1;
(statearr_12606_12639[(2)] = inst_12596);

(statearr_12606_12639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (13))){
var inst_12589 = cljs.core.async.close_BANG_.call(null,out);
var state_12600__$1 = state_12600;
var statearr_12607_12640 = state_12600__$1;
(statearr_12607_12640[(2)] = inst_12589);

(statearr_12607_12640[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (6))){
var state_12600__$1 = state_12600;
var statearr_12608_12641 = state_12600__$1;
(statearr_12608_12641[(2)] = null);

(statearr_12608_12641[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (3))){
var inst_12598 = (state_12600[(2)]);
var state_12600__$1 = state_12600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12600__$1,inst_12598);
} else {
if((state_val_12601 === (12))){
var inst_12586 = (state_12600[(8)]);
var inst_12586__$1 = (state_12600[(2)]);
var inst_12587 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12586__$1);
var state_12600__$1 = (function (){var statearr_12609 = state_12600;
(statearr_12609[(8)] = inst_12586__$1);

return statearr_12609;
})();
if(cljs.core.truth_(inst_12587)){
var statearr_12610_12642 = state_12600__$1;
(statearr_12610_12642[(1)] = (13));

} else {
var statearr_12611_12643 = state_12600__$1;
(statearr_12611_12643[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (2))){
var inst_12563 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12564 = (0);
var state_12600__$1 = (function (){var statearr_12612 = state_12600;
(statearr_12612[(9)] = inst_12563);

(statearr_12612[(7)] = inst_12564);

return statearr_12612;
})();
var statearr_12613_12644 = state_12600__$1;
(statearr_12613_12644[(2)] = null);

(statearr_12613_12644[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (11))){
var inst_12564 = (state_12600[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_12600,(10),Object,null,(9));
var inst_12573 = chs__$1.call(null,inst_12564);
var inst_12574 = done.call(null,inst_12564);
var inst_12575 = cljs.core.async.take_BANG_.call(null,inst_12573,inst_12574);
var state_12600__$1 = state_12600;
var statearr_12614_12645 = state_12600__$1;
(statearr_12614_12645[(2)] = inst_12575);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12600__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (9))){
var inst_12564 = (state_12600[(7)]);
var inst_12577 = (state_12600[(2)]);
var inst_12578 = (inst_12564 + (1));
var inst_12564__$1 = inst_12578;
var state_12600__$1 = (function (){var statearr_12615 = state_12600;
(statearr_12615[(7)] = inst_12564__$1);

(statearr_12615[(10)] = inst_12577);

return statearr_12615;
})();
var statearr_12616_12646 = state_12600__$1;
(statearr_12616_12646[(2)] = null);

(statearr_12616_12646[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (5))){
var inst_12584 = (state_12600[(2)]);
var state_12600__$1 = (function (){var statearr_12617 = state_12600;
(statearr_12617[(11)] = inst_12584);

return statearr_12617;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12600__$1,(12),dchan);
} else {
if((state_val_12601 === (14))){
var inst_12586 = (state_12600[(8)]);
var inst_12591 = cljs.core.apply.call(null,f,inst_12586);
var state_12600__$1 = state_12600;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12600__$1,(16),out,inst_12591);
} else {
if((state_val_12601 === (16))){
var inst_12593 = (state_12600[(2)]);
var state_12600__$1 = (function (){var statearr_12618 = state_12600;
(statearr_12618[(12)] = inst_12593);

return statearr_12618;
})();
var statearr_12619_12647 = state_12600__$1;
(statearr_12619_12647[(2)] = null);

(statearr_12619_12647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (10))){
var inst_12568 = (state_12600[(2)]);
var inst_12569 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12600__$1 = (function (){var statearr_12620 = state_12600;
(statearr_12620[(13)] = inst_12568);

return statearr_12620;
})();
var statearr_12621_12648 = state_12600__$1;
(statearr_12621_12648[(2)] = inst_12569);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12600__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12601 === (8))){
var inst_12582 = (state_12600[(2)]);
var state_12600__$1 = state_12600;
var statearr_12622_12649 = state_12600__$1;
(statearr_12622_12649[(2)] = inst_12582);

(statearr_12622_12649[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___12634,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10483__auto__,c__10595__auto___12634,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_12626 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12626[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_12626[(1)] = (1));

return statearr_12626;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_12600){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_12600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e12627){if((e12627 instanceof Object)){
var ex__10487__auto__ = e12627;
var statearr_12628_12650 = state_12600;
(statearr_12628_12650[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12600);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12651 = state_12600;
state_12600 = G__12651;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_12600){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_12600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___12634,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__10597__auto__ = (function (){var statearr_12629 = f__10596__auto__.call(null);
(statearr_12629[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___12634);

return statearr_12629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___12634,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args12653 = [];
var len__7484__auto___12711 = arguments.length;
var i__7485__auto___12712 = (0);
while(true){
if((i__7485__auto___12712 < len__7484__auto___12711)){
args12653.push((arguments[i__7485__auto___12712]));

var G__12713 = (i__7485__auto___12712 + (1));
i__7485__auto___12712 = G__12713;
continue;
} else {
}
break;
}

var G__12655 = args12653.length;
switch (G__12655) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12653.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___12715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___12715,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___12715,out){
return (function (state_12687){
var state_val_12688 = (state_12687[(1)]);
if((state_val_12688 === (7))){
var inst_12667 = (state_12687[(7)]);
var inst_12666 = (state_12687[(8)]);
var inst_12666__$1 = (state_12687[(2)]);
var inst_12667__$1 = cljs.core.nth.call(null,inst_12666__$1,(0),null);
var inst_12668 = cljs.core.nth.call(null,inst_12666__$1,(1),null);
var inst_12669 = (inst_12667__$1 == null);
var state_12687__$1 = (function (){var statearr_12689 = state_12687;
(statearr_12689[(7)] = inst_12667__$1);

(statearr_12689[(8)] = inst_12666__$1);

(statearr_12689[(9)] = inst_12668);

return statearr_12689;
})();
if(cljs.core.truth_(inst_12669)){
var statearr_12690_12716 = state_12687__$1;
(statearr_12690_12716[(1)] = (8));

} else {
var statearr_12691_12717 = state_12687__$1;
(statearr_12691_12717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (1))){
var inst_12656 = cljs.core.vec.call(null,chs);
var inst_12657 = inst_12656;
var state_12687__$1 = (function (){var statearr_12692 = state_12687;
(statearr_12692[(10)] = inst_12657);

return statearr_12692;
})();
var statearr_12693_12718 = state_12687__$1;
(statearr_12693_12718[(2)] = null);

(statearr_12693_12718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (4))){
var inst_12657 = (state_12687[(10)]);
var state_12687__$1 = state_12687;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12687__$1,(7),inst_12657);
} else {
if((state_val_12688 === (6))){
var inst_12683 = (state_12687[(2)]);
var state_12687__$1 = state_12687;
var statearr_12694_12719 = state_12687__$1;
(statearr_12694_12719[(2)] = inst_12683);

(statearr_12694_12719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (3))){
var inst_12685 = (state_12687[(2)]);
var state_12687__$1 = state_12687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12687__$1,inst_12685);
} else {
if((state_val_12688 === (2))){
var inst_12657 = (state_12687[(10)]);
var inst_12659 = cljs.core.count.call(null,inst_12657);
var inst_12660 = (inst_12659 > (0));
var state_12687__$1 = state_12687;
if(cljs.core.truth_(inst_12660)){
var statearr_12696_12720 = state_12687__$1;
(statearr_12696_12720[(1)] = (4));

} else {
var statearr_12697_12721 = state_12687__$1;
(statearr_12697_12721[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (11))){
var inst_12657 = (state_12687[(10)]);
var inst_12676 = (state_12687[(2)]);
var tmp12695 = inst_12657;
var inst_12657__$1 = tmp12695;
var state_12687__$1 = (function (){var statearr_12698 = state_12687;
(statearr_12698[(10)] = inst_12657__$1);

(statearr_12698[(11)] = inst_12676);

return statearr_12698;
})();
var statearr_12699_12722 = state_12687__$1;
(statearr_12699_12722[(2)] = null);

(statearr_12699_12722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (9))){
var inst_12667 = (state_12687[(7)]);
var state_12687__$1 = state_12687;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12687__$1,(11),out,inst_12667);
} else {
if((state_val_12688 === (5))){
var inst_12681 = cljs.core.async.close_BANG_.call(null,out);
var state_12687__$1 = state_12687;
var statearr_12700_12723 = state_12687__$1;
(statearr_12700_12723[(2)] = inst_12681);

(statearr_12700_12723[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (10))){
var inst_12679 = (state_12687[(2)]);
var state_12687__$1 = state_12687;
var statearr_12701_12724 = state_12687__$1;
(statearr_12701_12724[(2)] = inst_12679);

(statearr_12701_12724[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12688 === (8))){
var inst_12657 = (state_12687[(10)]);
var inst_12667 = (state_12687[(7)]);
var inst_12666 = (state_12687[(8)]);
var inst_12668 = (state_12687[(9)]);
var inst_12671 = (function (){var cs = inst_12657;
var vec__12662 = inst_12666;
var v = inst_12667;
var c = inst_12668;
return ((function (cs,vec__12662,v,c,inst_12657,inst_12667,inst_12666,inst_12668,state_val_12688,c__10595__auto___12715,out){
return (function (p1__12652_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12652_SHARP_);
});
;})(cs,vec__12662,v,c,inst_12657,inst_12667,inst_12666,inst_12668,state_val_12688,c__10595__auto___12715,out))
})();
var inst_12672 = cljs.core.filterv.call(null,inst_12671,inst_12657);
var inst_12657__$1 = inst_12672;
var state_12687__$1 = (function (){var statearr_12702 = state_12687;
(statearr_12702[(10)] = inst_12657__$1);

return statearr_12702;
})();
var statearr_12703_12725 = state_12687__$1;
(statearr_12703_12725[(2)] = null);

(statearr_12703_12725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___12715,out))
;
return ((function (switch__10483__auto__,c__10595__auto___12715,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_12707 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12707[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_12707[(1)] = (1));

return statearr_12707;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_12687){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_12687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e12708){if((e12708 instanceof Object)){
var ex__10487__auto__ = e12708;
var statearr_12709_12726 = state_12687;
(statearr_12709_12726[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12687);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12727 = state_12687;
state_12687 = G__12727;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_12687){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_12687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___12715,out))
})();
var state__10597__auto__ = (function (){var statearr_12710 = f__10596__auto__.call(null);
(statearr_12710[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___12715);

return statearr_12710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___12715,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args12728 = [];
var len__7484__auto___12777 = arguments.length;
var i__7485__auto___12778 = (0);
while(true){
if((i__7485__auto___12778 < len__7484__auto___12777)){
args12728.push((arguments[i__7485__auto___12778]));

var G__12779 = (i__7485__auto___12778 + (1));
i__7485__auto___12778 = G__12779;
continue;
} else {
}
break;
}

var G__12730 = args12728.length;
switch (G__12730) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12728.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___12781 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___12781,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___12781,out){
return (function (state_12754){
var state_val_12755 = (state_12754[(1)]);
if((state_val_12755 === (7))){
var inst_12736 = (state_12754[(7)]);
var inst_12736__$1 = (state_12754[(2)]);
var inst_12737 = (inst_12736__$1 == null);
var inst_12738 = cljs.core.not.call(null,inst_12737);
var state_12754__$1 = (function (){var statearr_12756 = state_12754;
(statearr_12756[(7)] = inst_12736__$1);

return statearr_12756;
})();
if(inst_12738){
var statearr_12757_12782 = state_12754__$1;
(statearr_12757_12782[(1)] = (8));

} else {
var statearr_12758_12783 = state_12754__$1;
(statearr_12758_12783[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12755 === (1))){
var inst_12731 = (0);
var state_12754__$1 = (function (){var statearr_12759 = state_12754;
(statearr_12759[(8)] = inst_12731);

return statearr_12759;
})();
var statearr_12760_12784 = state_12754__$1;
(statearr_12760_12784[(2)] = null);

(statearr_12760_12784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12755 === (4))){
var state_12754__$1 = state_12754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12754__$1,(7),ch);
} else {
if((state_val_12755 === (6))){
var inst_12749 = (state_12754[(2)]);
var state_12754__$1 = state_12754;
var statearr_12761_12785 = state_12754__$1;
(statearr_12761_12785[(2)] = inst_12749);

(statearr_12761_12785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12755 === (3))){
var inst_12751 = (state_12754[(2)]);
var inst_12752 = cljs.core.async.close_BANG_.call(null,out);
var state_12754__$1 = (function (){var statearr_12762 = state_12754;
(statearr_12762[(9)] = inst_12751);

return statearr_12762;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12754__$1,inst_12752);
} else {
if((state_val_12755 === (2))){
var inst_12731 = (state_12754[(8)]);
var inst_12733 = (inst_12731 < n);
var state_12754__$1 = state_12754;
if(cljs.core.truth_(inst_12733)){
var statearr_12763_12786 = state_12754__$1;
(statearr_12763_12786[(1)] = (4));

} else {
var statearr_12764_12787 = state_12754__$1;
(statearr_12764_12787[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12755 === (11))){
var inst_12731 = (state_12754[(8)]);
var inst_12741 = (state_12754[(2)]);
var inst_12742 = (inst_12731 + (1));
var inst_12731__$1 = inst_12742;
var state_12754__$1 = (function (){var statearr_12765 = state_12754;
(statearr_12765[(10)] = inst_12741);

(statearr_12765[(8)] = inst_12731__$1);

return statearr_12765;
})();
var statearr_12766_12788 = state_12754__$1;
(statearr_12766_12788[(2)] = null);

(statearr_12766_12788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12755 === (9))){
var state_12754__$1 = state_12754;
var statearr_12767_12789 = state_12754__$1;
(statearr_12767_12789[(2)] = null);

(statearr_12767_12789[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12755 === (5))){
var state_12754__$1 = state_12754;
var statearr_12768_12790 = state_12754__$1;
(statearr_12768_12790[(2)] = null);

(statearr_12768_12790[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12755 === (10))){
var inst_12746 = (state_12754[(2)]);
var state_12754__$1 = state_12754;
var statearr_12769_12791 = state_12754__$1;
(statearr_12769_12791[(2)] = inst_12746);

(statearr_12769_12791[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12755 === (8))){
var inst_12736 = (state_12754[(7)]);
var state_12754__$1 = state_12754;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12754__$1,(11),out,inst_12736);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___12781,out))
;
return ((function (switch__10483__auto__,c__10595__auto___12781,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_12773 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12773[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_12773[(1)] = (1));

return statearr_12773;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_12754){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_12754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e12774){if((e12774 instanceof Object)){
var ex__10487__auto__ = e12774;
var statearr_12775_12792 = state_12754;
(statearr_12775_12792[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12754);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12774;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12793 = state_12754;
state_12754 = G__12793;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_12754){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_12754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___12781,out))
})();
var state__10597__auto__ = (function (){var statearr_12776 = f__10596__auto__.call(null);
(statearr_12776[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___12781);

return statearr_12776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___12781,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async12801 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12801 = (function (map_LT_,f,ch,meta12802){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta12802 = meta12802;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12803,meta12802__$1){
var self__ = this;
var _12803__$1 = this;
return (new cljs.core.async.t_cljs$core$async12801(self__.map_LT_,self__.f,self__.ch,meta12802__$1));
});

cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12803){
var self__ = this;
var _12803__$1 = this;
return self__.meta12802;
});

cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async12804 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12804 = (function (map_LT_,f,ch,meta12802,_,fn1,meta12805){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta12802 = meta12802;
this._ = _;
this.fn1 = fn1;
this.meta12805 = meta12805;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12804.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_12806,meta12805__$1){
var self__ = this;
var _12806__$1 = this;
return (new cljs.core.async.t_cljs$core$async12804(self__.map_LT_,self__.f,self__.ch,self__.meta12802,self__._,self__.fn1,meta12805__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async12804.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_12806){
var self__ = this;
var _12806__$1 = this;
return self__.meta12805;
});})(___$1))
;

cljs.core.async.t_cljs$core$async12804.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12804.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async12804.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async12804.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__12794_SHARP_){
return f1.call(null,(((p1__12794_SHARP_ == null))?null:self__.f.call(null,p1__12794_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async12804.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12802","meta12802",-1127778773,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12801","cljs.core.async/t_cljs$core$async12801",1220355904,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12805","meta12805",-1672835781,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async12804.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12804.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12804";

cljs.core.async.t_cljs$core$async12804.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12804");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async12804 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12804(map_LT___$1,f__$1,ch__$1,meta12802__$1,___$2,fn1__$1,meta12805){
return (new cljs.core.async.t_cljs$core$async12804(map_LT___$1,f__$1,ch__$1,meta12802__$1,___$2,fn1__$1,meta12805));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async12804(self__.map_LT_,self__.f,self__.ch,self__.meta12802,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async12801.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async12801.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12802","meta12802",-1127778773,null)], null);
});

cljs.core.async.t_cljs$core$async12801.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12801.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12801";

cljs.core.async.t_cljs$core$async12801.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12801");
});

cljs.core.async.__GT_t_cljs$core$async12801 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12801(map_LT___$1,f__$1,ch__$1,meta12802){
return (new cljs.core.async.t_cljs$core$async12801(map_LT___$1,f__$1,ch__$1,meta12802));
});

}

return (new cljs.core.async.t_cljs$core$async12801(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async12810 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12810 = (function (map_GT_,f,ch,meta12811){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta12811 = meta12811;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12810.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12812,meta12811__$1){
var self__ = this;
var _12812__$1 = this;
return (new cljs.core.async.t_cljs$core$async12810(self__.map_GT_,self__.f,self__.ch,meta12811__$1));
});

cljs.core.async.t_cljs$core$async12810.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12812){
var self__ = this;
var _12812__$1 = this;
return self__.meta12811;
});

cljs.core.async.t_cljs$core$async12810.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async12810.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12810.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async12810.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async12810.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async12810.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async12810.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12811","meta12811",1410623254,null)], null);
});

cljs.core.async.t_cljs$core$async12810.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12810.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12810";

cljs.core.async.t_cljs$core$async12810.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12810");
});

cljs.core.async.__GT_t_cljs$core$async12810 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12810(map_GT___$1,f__$1,ch__$1,meta12811){
return (new cljs.core.async.t_cljs$core$async12810(map_GT___$1,f__$1,ch__$1,meta12811));
});

}

return (new cljs.core.async.t_cljs$core$async12810(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async12816 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12816 = (function (filter_GT_,p,ch,meta12817){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta12817 = meta12817;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12818,meta12817__$1){
var self__ = this;
var _12818__$1 = this;
return (new cljs.core.async.t_cljs$core$async12816(self__.filter_GT_,self__.p,self__.ch,meta12817__$1));
});

cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12818){
var self__ = this;
var _12818__$1 = this;
return self__.meta12817;
});

cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async12816.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async12816.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12817","meta12817",1253344164,null)], null);
});

cljs.core.async.t_cljs$core$async12816.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12816.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12816";

cljs.core.async.t_cljs$core$async12816.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12816");
});

cljs.core.async.__GT_t_cljs$core$async12816 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12816(filter_GT___$1,p__$1,ch__$1,meta12817){
return (new cljs.core.async.t_cljs$core$async12816(filter_GT___$1,p__$1,ch__$1,meta12817));
});

}

return (new cljs.core.async.t_cljs$core$async12816(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args12819 = [];
var len__7484__auto___12863 = arguments.length;
var i__7485__auto___12864 = (0);
while(true){
if((i__7485__auto___12864 < len__7484__auto___12863)){
args12819.push((arguments[i__7485__auto___12864]));

var G__12865 = (i__7485__auto___12864 + (1));
i__7485__auto___12864 = G__12865;
continue;
} else {
}
break;
}

var G__12821 = args12819.length;
switch (G__12821) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12819.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___12867 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___12867,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___12867,out){
return (function (state_12842){
var state_val_12843 = (state_12842[(1)]);
if((state_val_12843 === (7))){
var inst_12838 = (state_12842[(2)]);
var state_12842__$1 = state_12842;
var statearr_12844_12868 = state_12842__$1;
(statearr_12844_12868[(2)] = inst_12838);

(statearr_12844_12868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12843 === (1))){
var state_12842__$1 = state_12842;
var statearr_12845_12869 = state_12842__$1;
(statearr_12845_12869[(2)] = null);

(statearr_12845_12869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12843 === (4))){
var inst_12824 = (state_12842[(7)]);
var inst_12824__$1 = (state_12842[(2)]);
var inst_12825 = (inst_12824__$1 == null);
var state_12842__$1 = (function (){var statearr_12846 = state_12842;
(statearr_12846[(7)] = inst_12824__$1);

return statearr_12846;
})();
if(cljs.core.truth_(inst_12825)){
var statearr_12847_12870 = state_12842__$1;
(statearr_12847_12870[(1)] = (5));

} else {
var statearr_12848_12871 = state_12842__$1;
(statearr_12848_12871[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12843 === (6))){
var inst_12824 = (state_12842[(7)]);
var inst_12829 = p.call(null,inst_12824);
var state_12842__$1 = state_12842;
if(cljs.core.truth_(inst_12829)){
var statearr_12849_12872 = state_12842__$1;
(statearr_12849_12872[(1)] = (8));

} else {
var statearr_12850_12873 = state_12842__$1;
(statearr_12850_12873[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12843 === (3))){
var inst_12840 = (state_12842[(2)]);
var state_12842__$1 = state_12842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12842__$1,inst_12840);
} else {
if((state_val_12843 === (2))){
var state_12842__$1 = state_12842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12842__$1,(4),ch);
} else {
if((state_val_12843 === (11))){
var inst_12832 = (state_12842[(2)]);
var state_12842__$1 = state_12842;
var statearr_12851_12874 = state_12842__$1;
(statearr_12851_12874[(2)] = inst_12832);

(statearr_12851_12874[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12843 === (9))){
var state_12842__$1 = state_12842;
var statearr_12852_12875 = state_12842__$1;
(statearr_12852_12875[(2)] = null);

(statearr_12852_12875[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12843 === (5))){
var inst_12827 = cljs.core.async.close_BANG_.call(null,out);
var state_12842__$1 = state_12842;
var statearr_12853_12876 = state_12842__$1;
(statearr_12853_12876[(2)] = inst_12827);

(statearr_12853_12876[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12843 === (10))){
var inst_12835 = (state_12842[(2)]);
var state_12842__$1 = (function (){var statearr_12854 = state_12842;
(statearr_12854[(8)] = inst_12835);

return statearr_12854;
})();
var statearr_12855_12877 = state_12842__$1;
(statearr_12855_12877[(2)] = null);

(statearr_12855_12877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12843 === (8))){
var inst_12824 = (state_12842[(7)]);
var state_12842__$1 = state_12842;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12842__$1,(11),out,inst_12824);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___12867,out))
;
return ((function (switch__10483__auto__,c__10595__auto___12867,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_12859 = [null,null,null,null,null,null,null,null,null];
(statearr_12859[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_12859[(1)] = (1));

return statearr_12859;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_12842){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_12842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e12860){if((e12860 instanceof Object)){
var ex__10487__auto__ = e12860;
var statearr_12861_12878 = state_12842;
(statearr_12861_12878[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12879 = state_12842;
state_12842 = G__12879;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_12842){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_12842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___12867,out))
})();
var state__10597__auto__ = (function (){var statearr_12862 = f__10596__auto__.call(null);
(statearr_12862[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___12867);

return statearr_12862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___12867,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args12880 = [];
var len__7484__auto___12883 = arguments.length;
var i__7485__auto___12884 = (0);
while(true){
if((i__7485__auto___12884 < len__7484__auto___12883)){
args12880.push((arguments[i__7485__auto___12884]));

var G__12885 = (i__7485__auto___12884 + (1));
i__7485__auto___12884 = G__12885;
continue;
} else {
}
break;
}

var G__12882 = args12880.length;
switch (G__12882) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12880.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__10595__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto__){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto__){
return (function (state_13052){
var state_val_13053 = (state_13052[(1)]);
if((state_val_13053 === (7))){
var inst_13048 = (state_13052[(2)]);
var state_13052__$1 = state_13052;
var statearr_13054_13095 = state_13052__$1;
(statearr_13054_13095[(2)] = inst_13048);

(statearr_13054_13095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (20))){
var inst_13018 = (state_13052[(7)]);
var inst_13029 = (state_13052[(2)]);
var inst_13030 = cljs.core.next.call(null,inst_13018);
var inst_13004 = inst_13030;
var inst_13005 = null;
var inst_13006 = (0);
var inst_13007 = (0);
var state_13052__$1 = (function (){var statearr_13055 = state_13052;
(statearr_13055[(8)] = inst_13007);

(statearr_13055[(9)] = inst_13005);

(statearr_13055[(10)] = inst_13004);

(statearr_13055[(11)] = inst_13029);

(statearr_13055[(12)] = inst_13006);

return statearr_13055;
})();
var statearr_13056_13096 = state_13052__$1;
(statearr_13056_13096[(2)] = null);

(statearr_13056_13096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (1))){
var state_13052__$1 = state_13052;
var statearr_13057_13097 = state_13052__$1;
(statearr_13057_13097[(2)] = null);

(statearr_13057_13097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (4))){
var inst_12993 = (state_13052[(13)]);
var inst_12993__$1 = (state_13052[(2)]);
var inst_12994 = (inst_12993__$1 == null);
var state_13052__$1 = (function (){var statearr_13058 = state_13052;
(statearr_13058[(13)] = inst_12993__$1);

return statearr_13058;
})();
if(cljs.core.truth_(inst_12994)){
var statearr_13059_13098 = state_13052__$1;
(statearr_13059_13098[(1)] = (5));

} else {
var statearr_13060_13099 = state_13052__$1;
(statearr_13060_13099[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (15))){
var state_13052__$1 = state_13052;
var statearr_13064_13100 = state_13052__$1;
(statearr_13064_13100[(2)] = null);

(statearr_13064_13100[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (21))){
var state_13052__$1 = state_13052;
var statearr_13065_13101 = state_13052__$1;
(statearr_13065_13101[(2)] = null);

(statearr_13065_13101[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (13))){
var inst_13007 = (state_13052[(8)]);
var inst_13005 = (state_13052[(9)]);
var inst_13004 = (state_13052[(10)]);
var inst_13006 = (state_13052[(12)]);
var inst_13014 = (state_13052[(2)]);
var inst_13015 = (inst_13007 + (1));
var tmp13061 = inst_13005;
var tmp13062 = inst_13004;
var tmp13063 = inst_13006;
var inst_13004__$1 = tmp13062;
var inst_13005__$1 = tmp13061;
var inst_13006__$1 = tmp13063;
var inst_13007__$1 = inst_13015;
var state_13052__$1 = (function (){var statearr_13066 = state_13052;
(statearr_13066[(8)] = inst_13007__$1);

(statearr_13066[(9)] = inst_13005__$1);

(statearr_13066[(10)] = inst_13004__$1);

(statearr_13066[(12)] = inst_13006__$1);

(statearr_13066[(14)] = inst_13014);

return statearr_13066;
})();
var statearr_13067_13102 = state_13052__$1;
(statearr_13067_13102[(2)] = null);

(statearr_13067_13102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (22))){
var state_13052__$1 = state_13052;
var statearr_13068_13103 = state_13052__$1;
(statearr_13068_13103[(2)] = null);

(statearr_13068_13103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (6))){
var inst_12993 = (state_13052[(13)]);
var inst_13002 = f.call(null,inst_12993);
var inst_13003 = cljs.core.seq.call(null,inst_13002);
var inst_13004 = inst_13003;
var inst_13005 = null;
var inst_13006 = (0);
var inst_13007 = (0);
var state_13052__$1 = (function (){var statearr_13069 = state_13052;
(statearr_13069[(8)] = inst_13007);

(statearr_13069[(9)] = inst_13005);

(statearr_13069[(10)] = inst_13004);

(statearr_13069[(12)] = inst_13006);

return statearr_13069;
})();
var statearr_13070_13104 = state_13052__$1;
(statearr_13070_13104[(2)] = null);

(statearr_13070_13104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (17))){
var inst_13018 = (state_13052[(7)]);
var inst_13022 = cljs.core.chunk_first.call(null,inst_13018);
var inst_13023 = cljs.core.chunk_rest.call(null,inst_13018);
var inst_13024 = cljs.core.count.call(null,inst_13022);
var inst_13004 = inst_13023;
var inst_13005 = inst_13022;
var inst_13006 = inst_13024;
var inst_13007 = (0);
var state_13052__$1 = (function (){var statearr_13071 = state_13052;
(statearr_13071[(8)] = inst_13007);

(statearr_13071[(9)] = inst_13005);

(statearr_13071[(10)] = inst_13004);

(statearr_13071[(12)] = inst_13006);

return statearr_13071;
})();
var statearr_13072_13105 = state_13052__$1;
(statearr_13072_13105[(2)] = null);

(statearr_13072_13105[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (3))){
var inst_13050 = (state_13052[(2)]);
var state_13052__$1 = state_13052;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13052__$1,inst_13050);
} else {
if((state_val_13053 === (12))){
var inst_13038 = (state_13052[(2)]);
var state_13052__$1 = state_13052;
var statearr_13073_13106 = state_13052__$1;
(statearr_13073_13106[(2)] = inst_13038);

(statearr_13073_13106[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (2))){
var state_13052__$1 = state_13052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13052__$1,(4),in$);
} else {
if((state_val_13053 === (23))){
var inst_13046 = (state_13052[(2)]);
var state_13052__$1 = state_13052;
var statearr_13074_13107 = state_13052__$1;
(statearr_13074_13107[(2)] = inst_13046);

(statearr_13074_13107[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (19))){
var inst_13033 = (state_13052[(2)]);
var state_13052__$1 = state_13052;
var statearr_13075_13108 = state_13052__$1;
(statearr_13075_13108[(2)] = inst_13033);

(statearr_13075_13108[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (11))){
var inst_13004 = (state_13052[(10)]);
var inst_13018 = (state_13052[(7)]);
var inst_13018__$1 = cljs.core.seq.call(null,inst_13004);
var state_13052__$1 = (function (){var statearr_13076 = state_13052;
(statearr_13076[(7)] = inst_13018__$1);

return statearr_13076;
})();
if(inst_13018__$1){
var statearr_13077_13109 = state_13052__$1;
(statearr_13077_13109[(1)] = (14));

} else {
var statearr_13078_13110 = state_13052__$1;
(statearr_13078_13110[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (9))){
var inst_13040 = (state_13052[(2)]);
var inst_13041 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13052__$1 = (function (){var statearr_13079 = state_13052;
(statearr_13079[(15)] = inst_13040);

return statearr_13079;
})();
if(cljs.core.truth_(inst_13041)){
var statearr_13080_13111 = state_13052__$1;
(statearr_13080_13111[(1)] = (21));

} else {
var statearr_13081_13112 = state_13052__$1;
(statearr_13081_13112[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (5))){
var inst_12996 = cljs.core.async.close_BANG_.call(null,out);
var state_13052__$1 = state_13052;
var statearr_13082_13113 = state_13052__$1;
(statearr_13082_13113[(2)] = inst_12996);

(statearr_13082_13113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (14))){
var inst_13018 = (state_13052[(7)]);
var inst_13020 = cljs.core.chunked_seq_QMARK_.call(null,inst_13018);
var state_13052__$1 = state_13052;
if(inst_13020){
var statearr_13083_13114 = state_13052__$1;
(statearr_13083_13114[(1)] = (17));

} else {
var statearr_13084_13115 = state_13052__$1;
(statearr_13084_13115[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (16))){
var inst_13036 = (state_13052[(2)]);
var state_13052__$1 = state_13052;
var statearr_13085_13116 = state_13052__$1;
(statearr_13085_13116[(2)] = inst_13036);

(statearr_13085_13116[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13053 === (10))){
var inst_13007 = (state_13052[(8)]);
var inst_13005 = (state_13052[(9)]);
var inst_13012 = cljs.core._nth.call(null,inst_13005,inst_13007);
var state_13052__$1 = state_13052;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13052__$1,(13),out,inst_13012);
} else {
if((state_val_13053 === (18))){
var inst_13018 = (state_13052[(7)]);
var inst_13027 = cljs.core.first.call(null,inst_13018);
var state_13052__$1 = state_13052;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13052__$1,(20),out,inst_13027);
} else {
if((state_val_13053 === (8))){
var inst_13007 = (state_13052[(8)]);
var inst_13006 = (state_13052[(12)]);
var inst_13009 = (inst_13007 < inst_13006);
var inst_13010 = inst_13009;
var state_13052__$1 = state_13052;
if(cljs.core.truth_(inst_13010)){
var statearr_13086_13117 = state_13052__$1;
(statearr_13086_13117[(1)] = (10));

} else {
var statearr_13087_13118 = state_13052__$1;
(statearr_13087_13118[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto__))
;
return ((function (switch__10483__auto__,c__10595__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____0 = (function (){
var statearr_13091 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13091[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__);

(statearr_13091[(1)] = (1));

return statearr_13091;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____1 = (function (state_13052){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_13052);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e13092){if((e13092 instanceof Object)){
var ex__10487__auto__ = e13092;
var statearr_13093_13119 = state_13052;
(statearr_13093_13119[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13052);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13092;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13120 = state_13052;
state_13052 = G__13120;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__ = function(state_13052){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____1.call(this,state_13052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10484__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto__))
})();
var state__10597__auto__ = (function (){var statearr_13094 = f__10596__auto__.call(null);
(statearr_13094[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto__);

return statearr_13094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto__))
);

return c__10595__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13121 = [];
var len__7484__auto___13124 = arguments.length;
var i__7485__auto___13125 = (0);
while(true){
if((i__7485__auto___13125 < len__7484__auto___13124)){
args13121.push((arguments[i__7485__auto___13125]));

var G__13126 = (i__7485__auto___13125 + (1));
i__7485__auto___13125 = G__13126;
continue;
} else {
}
break;
}

var G__13123 = args13121.length;
switch (G__13123) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13121.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13128 = [];
var len__7484__auto___13131 = arguments.length;
var i__7485__auto___13132 = (0);
while(true){
if((i__7485__auto___13132 < len__7484__auto___13131)){
args13128.push((arguments[i__7485__auto___13132]));

var G__13133 = (i__7485__auto___13132 + (1));
i__7485__auto___13132 = G__13133;
continue;
} else {
}
break;
}

var G__13130 = args13128.length;
switch (G__13130) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13128.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13135 = [];
var len__7484__auto___13186 = arguments.length;
var i__7485__auto___13187 = (0);
while(true){
if((i__7485__auto___13187 < len__7484__auto___13186)){
args13135.push((arguments[i__7485__auto___13187]));

var G__13188 = (i__7485__auto___13187 + (1));
i__7485__auto___13187 = G__13188;
continue;
} else {
}
break;
}

var G__13137 = args13135.length;
switch (G__13137) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13135.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___13190 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___13190,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___13190,out){
return (function (state_13161){
var state_val_13162 = (state_13161[(1)]);
if((state_val_13162 === (7))){
var inst_13156 = (state_13161[(2)]);
var state_13161__$1 = state_13161;
var statearr_13163_13191 = state_13161__$1;
(statearr_13163_13191[(2)] = inst_13156);

(statearr_13163_13191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13162 === (1))){
var inst_13138 = null;
var state_13161__$1 = (function (){var statearr_13164 = state_13161;
(statearr_13164[(7)] = inst_13138);

return statearr_13164;
})();
var statearr_13165_13192 = state_13161__$1;
(statearr_13165_13192[(2)] = null);

(statearr_13165_13192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13162 === (4))){
var inst_13141 = (state_13161[(8)]);
var inst_13141__$1 = (state_13161[(2)]);
var inst_13142 = (inst_13141__$1 == null);
var inst_13143 = cljs.core.not.call(null,inst_13142);
var state_13161__$1 = (function (){var statearr_13166 = state_13161;
(statearr_13166[(8)] = inst_13141__$1);

return statearr_13166;
})();
if(inst_13143){
var statearr_13167_13193 = state_13161__$1;
(statearr_13167_13193[(1)] = (5));

} else {
var statearr_13168_13194 = state_13161__$1;
(statearr_13168_13194[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13162 === (6))){
var state_13161__$1 = state_13161;
var statearr_13169_13195 = state_13161__$1;
(statearr_13169_13195[(2)] = null);

(statearr_13169_13195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13162 === (3))){
var inst_13158 = (state_13161[(2)]);
var inst_13159 = cljs.core.async.close_BANG_.call(null,out);
var state_13161__$1 = (function (){var statearr_13170 = state_13161;
(statearr_13170[(9)] = inst_13158);

return statearr_13170;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13161__$1,inst_13159);
} else {
if((state_val_13162 === (2))){
var state_13161__$1 = state_13161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13161__$1,(4),ch);
} else {
if((state_val_13162 === (11))){
var inst_13141 = (state_13161[(8)]);
var inst_13150 = (state_13161[(2)]);
var inst_13138 = inst_13141;
var state_13161__$1 = (function (){var statearr_13171 = state_13161;
(statearr_13171[(7)] = inst_13138);

(statearr_13171[(10)] = inst_13150);

return statearr_13171;
})();
var statearr_13172_13196 = state_13161__$1;
(statearr_13172_13196[(2)] = null);

(statearr_13172_13196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13162 === (9))){
var inst_13141 = (state_13161[(8)]);
var state_13161__$1 = state_13161;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13161__$1,(11),out,inst_13141);
} else {
if((state_val_13162 === (5))){
var inst_13138 = (state_13161[(7)]);
var inst_13141 = (state_13161[(8)]);
var inst_13145 = cljs.core._EQ_.call(null,inst_13141,inst_13138);
var state_13161__$1 = state_13161;
if(inst_13145){
var statearr_13174_13197 = state_13161__$1;
(statearr_13174_13197[(1)] = (8));

} else {
var statearr_13175_13198 = state_13161__$1;
(statearr_13175_13198[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13162 === (10))){
var inst_13153 = (state_13161[(2)]);
var state_13161__$1 = state_13161;
var statearr_13176_13199 = state_13161__$1;
(statearr_13176_13199[(2)] = inst_13153);

(statearr_13176_13199[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13162 === (8))){
var inst_13138 = (state_13161[(7)]);
var tmp13173 = inst_13138;
var inst_13138__$1 = tmp13173;
var state_13161__$1 = (function (){var statearr_13177 = state_13161;
(statearr_13177[(7)] = inst_13138__$1);

return statearr_13177;
})();
var statearr_13178_13200 = state_13161__$1;
(statearr_13178_13200[(2)] = null);

(statearr_13178_13200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___13190,out))
;
return ((function (switch__10483__auto__,c__10595__auto___13190,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_13182 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13182[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_13182[(1)] = (1));

return statearr_13182;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_13161){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_13161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e13183){if((e13183 instanceof Object)){
var ex__10487__auto__ = e13183;
var statearr_13184_13201 = state_13161;
(statearr_13184_13201[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13161);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13183;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13202 = state_13161;
state_13161 = G__13202;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_13161){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_13161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___13190,out))
})();
var state__10597__auto__ = (function (){var statearr_13185 = f__10596__auto__.call(null);
(statearr_13185[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___13190);

return statearr_13185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___13190,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13203 = [];
var len__7484__auto___13273 = arguments.length;
var i__7485__auto___13274 = (0);
while(true){
if((i__7485__auto___13274 < len__7484__auto___13273)){
args13203.push((arguments[i__7485__auto___13274]));

var G__13275 = (i__7485__auto___13274 + (1));
i__7485__auto___13274 = G__13275;
continue;
} else {
}
break;
}

var G__13205 = args13203.length;
switch (G__13205) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13203.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___13277 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___13277,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___13277,out){
return (function (state_13243){
var state_val_13244 = (state_13243[(1)]);
if((state_val_13244 === (7))){
var inst_13239 = (state_13243[(2)]);
var state_13243__$1 = state_13243;
var statearr_13245_13278 = state_13243__$1;
(statearr_13245_13278[(2)] = inst_13239);

(statearr_13245_13278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (1))){
var inst_13206 = (new Array(n));
var inst_13207 = inst_13206;
var inst_13208 = (0);
var state_13243__$1 = (function (){var statearr_13246 = state_13243;
(statearr_13246[(7)] = inst_13208);

(statearr_13246[(8)] = inst_13207);

return statearr_13246;
})();
var statearr_13247_13279 = state_13243__$1;
(statearr_13247_13279[(2)] = null);

(statearr_13247_13279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (4))){
var inst_13211 = (state_13243[(9)]);
var inst_13211__$1 = (state_13243[(2)]);
var inst_13212 = (inst_13211__$1 == null);
var inst_13213 = cljs.core.not.call(null,inst_13212);
var state_13243__$1 = (function (){var statearr_13248 = state_13243;
(statearr_13248[(9)] = inst_13211__$1);

return statearr_13248;
})();
if(inst_13213){
var statearr_13249_13280 = state_13243__$1;
(statearr_13249_13280[(1)] = (5));

} else {
var statearr_13250_13281 = state_13243__$1;
(statearr_13250_13281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (15))){
var inst_13233 = (state_13243[(2)]);
var state_13243__$1 = state_13243;
var statearr_13251_13282 = state_13243__$1;
(statearr_13251_13282[(2)] = inst_13233);

(statearr_13251_13282[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (13))){
var state_13243__$1 = state_13243;
var statearr_13252_13283 = state_13243__$1;
(statearr_13252_13283[(2)] = null);

(statearr_13252_13283[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (6))){
var inst_13208 = (state_13243[(7)]);
var inst_13229 = (inst_13208 > (0));
var state_13243__$1 = state_13243;
if(cljs.core.truth_(inst_13229)){
var statearr_13253_13284 = state_13243__$1;
(statearr_13253_13284[(1)] = (12));

} else {
var statearr_13254_13285 = state_13243__$1;
(statearr_13254_13285[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (3))){
var inst_13241 = (state_13243[(2)]);
var state_13243__$1 = state_13243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13243__$1,inst_13241);
} else {
if((state_val_13244 === (12))){
var inst_13207 = (state_13243[(8)]);
var inst_13231 = cljs.core.vec.call(null,inst_13207);
var state_13243__$1 = state_13243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13243__$1,(15),out,inst_13231);
} else {
if((state_val_13244 === (2))){
var state_13243__$1 = state_13243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13243__$1,(4),ch);
} else {
if((state_val_13244 === (11))){
var inst_13223 = (state_13243[(2)]);
var inst_13224 = (new Array(n));
var inst_13207 = inst_13224;
var inst_13208 = (0);
var state_13243__$1 = (function (){var statearr_13255 = state_13243;
(statearr_13255[(7)] = inst_13208);

(statearr_13255[(10)] = inst_13223);

(statearr_13255[(8)] = inst_13207);

return statearr_13255;
})();
var statearr_13256_13286 = state_13243__$1;
(statearr_13256_13286[(2)] = null);

(statearr_13256_13286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (9))){
var inst_13207 = (state_13243[(8)]);
var inst_13221 = cljs.core.vec.call(null,inst_13207);
var state_13243__$1 = state_13243;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13243__$1,(11),out,inst_13221);
} else {
if((state_val_13244 === (5))){
var inst_13216 = (state_13243[(11)]);
var inst_13208 = (state_13243[(7)]);
var inst_13207 = (state_13243[(8)]);
var inst_13211 = (state_13243[(9)]);
var inst_13215 = (inst_13207[inst_13208] = inst_13211);
var inst_13216__$1 = (inst_13208 + (1));
var inst_13217 = (inst_13216__$1 < n);
var state_13243__$1 = (function (){var statearr_13257 = state_13243;
(statearr_13257[(11)] = inst_13216__$1);

(statearr_13257[(12)] = inst_13215);

return statearr_13257;
})();
if(cljs.core.truth_(inst_13217)){
var statearr_13258_13287 = state_13243__$1;
(statearr_13258_13287[(1)] = (8));

} else {
var statearr_13259_13288 = state_13243__$1;
(statearr_13259_13288[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (14))){
var inst_13236 = (state_13243[(2)]);
var inst_13237 = cljs.core.async.close_BANG_.call(null,out);
var state_13243__$1 = (function (){var statearr_13261 = state_13243;
(statearr_13261[(13)] = inst_13236);

return statearr_13261;
})();
var statearr_13262_13289 = state_13243__$1;
(statearr_13262_13289[(2)] = inst_13237);

(statearr_13262_13289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (10))){
var inst_13227 = (state_13243[(2)]);
var state_13243__$1 = state_13243;
var statearr_13263_13290 = state_13243__$1;
(statearr_13263_13290[(2)] = inst_13227);

(statearr_13263_13290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13244 === (8))){
var inst_13216 = (state_13243[(11)]);
var inst_13207 = (state_13243[(8)]);
var tmp13260 = inst_13207;
var inst_13207__$1 = tmp13260;
var inst_13208 = inst_13216;
var state_13243__$1 = (function (){var statearr_13264 = state_13243;
(statearr_13264[(7)] = inst_13208);

(statearr_13264[(8)] = inst_13207__$1);

return statearr_13264;
})();
var statearr_13265_13291 = state_13243__$1;
(statearr_13265_13291[(2)] = null);

(statearr_13265_13291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___13277,out))
;
return ((function (switch__10483__auto__,c__10595__auto___13277,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_13269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13269[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_13269[(1)] = (1));

return statearr_13269;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_13243){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_13243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e13270){if((e13270 instanceof Object)){
var ex__10487__auto__ = e13270;
var statearr_13271_13292 = state_13243;
(statearr_13271_13292[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13293 = state_13243;
state_13243 = G__13293;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_13243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_13243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___13277,out))
})();
var state__10597__auto__ = (function (){var statearr_13272 = f__10596__auto__.call(null);
(statearr_13272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___13277);

return statearr_13272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___13277,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13294 = [];
var len__7484__auto___13368 = arguments.length;
var i__7485__auto___13369 = (0);
while(true){
if((i__7485__auto___13369 < len__7484__auto___13368)){
args13294.push((arguments[i__7485__auto___13369]));

var G__13370 = (i__7485__auto___13369 + (1));
i__7485__auto___13369 = G__13370;
continue;
} else {
}
break;
}

var G__13296 = args13294.length;
switch (G__13296) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13294.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10595__auto___13372 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10595__auto___13372,out){
return (function (){
var f__10596__auto__ = (function (){var switch__10483__auto__ = ((function (c__10595__auto___13372,out){
return (function (state_13338){
var state_val_13339 = (state_13338[(1)]);
if((state_val_13339 === (7))){
var inst_13334 = (state_13338[(2)]);
var state_13338__$1 = state_13338;
var statearr_13340_13373 = state_13338__$1;
(statearr_13340_13373[(2)] = inst_13334);

(statearr_13340_13373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (1))){
var inst_13297 = [];
var inst_13298 = inst_13297;
var inst_13299 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13338__$1 = (function (){var statearr_13341 = state_13338;
(statearr_13341[(7)] = inst_13298);

(statearr_13341[(8)] = inst_13299);

return statearr_13341;
})();
var statearr_13342_13374 = state_13338__$1;
(statearr_13342_13374[(2)] = null);

(statearr_13342_13374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (4))){
var inst_13302 = (state_13338[(9)]);
var inst_13302__$1 = (state_13338[(2)]);
var inst_13303 = (inst_13302__$1 == null);
var inst_13304 = cljs.core.not.call(null,inst_13303);
var state_13338__$1 = (function (){var statearr_13343 = state_13338;
(statearr_13343[(9)] = inst_13302__$1);

return statearr_13343;
})();
if(inst_13304){
var statearr_13344_13375 = state_13338__$1;
(statearr_13344_13375[(1)] = (5));

} else {
var statearr_13345_13376 = state_13338__$1;
(statearr_13345_13376[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (15))){
var inst_13328 = (state_13338[(2)]);
var state_13338__$1 = state_13338;
var statearr_13346_13377 = state_13338__$1;
(statearr_13346_13377[(2)] = inst_13328);

(statearr_13346_13377[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (13))){
var state_13338__$1 = state_13338;
var statearr_13347_13378 = state_13338__$1;
(statearr_13347_13378[(2)] = null);

(statearr_13347_13378[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (6))){
var inst_13298 = (state_13338[(7)]);
var inst_13323 = inst_13298.length;
var inst_13324 = (inst_13323 > (0));
var state_13338__$1 = state_13338;
if(cljs.core.truth_(inst_13324)){
var statearr_13348_13379 = state_13338__$1;
(statearr_13348_13379[(1)] = (12));

} else {
var statearr_13349_13380 = state_13338__$1;
(statearr_13349_13380[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (3))){
var inst_13336 = (state_13338[(2)]);
var state_13338__$1 = state_13338;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13338__$1,inst_13336);
} else {
if((state_val_13339 === (12))){
var inst_13298 = (state_13338[(7)]);
var inst_13326 = cljs.core.vec.call(null,inst_13298);
var state_13338__$1 = state_13338;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13338__$1,(15),out,inst_13326);
} else {
if((state_val_13339 === (2))){
var state_13338__$1 = state_13338;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13338__$1,(4),ch);
} else {
if((state_val_13339 === (11))){
var inst_13302 = (state_13338[(9)]);
var inst_13306 = (state_13338[(10)]);
var inst_13316 = (state_13338[(2)]);
var inst_13317 = [];
var inst_13318 = inst_13317.push(inst_13302);
var inst_13298 = inst_13317;
var inst_13299 = inst_13306;
var state_13338__$1 = (function (){var statearr_13350 = state_13338;
(statearr_13350[(11)] = inst_13318);

(statearr_13350[(7)] = inst_13298);

(statearr_13350[(8)] = inst_13299);

(statearr_13350[(12)] = inst_13316);

return statearr_13350;
})();
var statearr_13351_13381 = state_13338__$1;
(statearr_13351_13381[(2)] = null);

(statearr_13351_13381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (9))){
var inst_13298 = (state_13338[(7)]);
var inst_13314 = cljs.core.vec.call(null,inst_13298);
var state_13338__$1 = state_13338;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13338__$1,(11),out,inst_13314);
} else {
if((state_val_13339 === (5))){
var inst_13302 = (state_13338[(9)]);
var inst_13306 = (state_13338[(10)]);
var inst_13299 = (state_13338[(8)]);
var inst_13306__$1 = f.call(null,inst_13302);
var inst_13307 = cljs.core._EQ_.call(null,inst_13306__$1,inst_13299);
var inst_13308 = cljs.core.keyword_identical_QMARK_.call(null,inst_13299,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13309 = (inst_13307) || (inst_13308);
var state_13338__$1 = (function (){var statearr_13352 = state_13338;
(statearr_13352[(10)] = inst_13306__$1);

return statearr_13352;
})();
if(cljs.core.truth_(inst_13309)){
var statearr_13353_13382 = state_13338__$1;
(statearr_13353_13382[(1)] = (8));

} else {
var statearr_13354_13383 = state_13338__$1;
(statearr_13354_13383[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (14))){
var inst_13331 = (state_13338[(2)]);
var inst_13332 = cljs.core.async.close_BANG_.call(null,out);
var state_13338__$1 = (function (){var statearr_13356 = state_13338;
(statearr_13356[(13)] = inst_13331);

return statearr_13356;
})();
var statearr_13357_13384 = state_13338__$1;
(statearr_13357_13384[(2)] = inst_13332);

(statearr_13357_13384[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (10))){
var inst_13321 = (state_13338[(2)]);
var state_13338__$1 = state_13338;
var statearr_13358_13385 = state_13338__$1;
(statearr_13358_13385[(2)] = inst_13321);

(statearr_13358_13385[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13339 === (8))){
var inst_13302 = (state_13338[(9)]);
var inst_13306 = (state_13338[(10)]);
var inst_13298 = (state_13338[(7)]);
var inst_13311 = inst_13298.push(inst_13302);
var tmp13355 = inst_13298;
var inst_13298__$1 = tmp13355;
var inst_13299 = inst_13306;
var state_13338__$1 = (function (){var statearr_13359 = state_13338;
(statearr_13359[(14)] = inst_13311);

(statearr_13359[(7)] = inst_13298__$1);

(statearr_13359[(8)] = inst_13299);

return statearr_13359;
})();
var statearr_13360_13386 = state_13338__$1;
(statearr_13360_13386[(2)] = null);

(statearr_13360_13386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10595__auto___13372,out))
;
return ((function (switch__10483__auto__,c__10595__auto___13372,out){
return (function() {
var cljs$core$async$state_machine__10484__auto__ = null;
var cljs$core$async$state_machine__10484__auto____0 = (function (){
var statearr_13364 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13364[(0)] = cljs$core$async$state_machine__10484__auto__);

(statearr_13364[(1)] = (1));

return statearr_13364;
});
var cljs$core$async$state_machine__10484__auto____1 = (function (state_13338){
while(true){
var ret_value__10485__auto__ = (function (){try{while(true){
var result__10486__auto__ = switch__10483__auto__.call(null,state_13338);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10486__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10486__auto__;
}
break;
}
}catch (e13365){if((e13365 instanceof Object)){
var ex__10487__auto__ = e13365;
var statearr_13366_13387 = state_13338;
(statearr_13366_13387[(5)] = ex__10487__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13338);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13365;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10485__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13388 = state_13338;
state_13338 = G__13388;
continue;
} else {
return ret_value__10485__auto__;
}
break;
}
});
cljs$core$async$state_machine__10484__auto__ = function(state_13338){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10484__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10484__auto____1.call(this,state_13338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10484__auto____0;
cljs$core$async$state_machine__10484__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10484__auto____1;
return cljs$core$async$state_machine__10484__auto__;
})()
;})(switch__10483__auto__,c__10595__auto___13372,out))
})();
var state__10597__auto__ = (function (){var statearr_13367 = f__10596__auto__.call(null);
(statearr_13367[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10595__auto___13372);

return statearr_13367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10597__auto__);
});})(c__10595__auto___13372,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1476624434854