// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args19016 = [];
var len__5726__auto___19022 = arguments.length;
var i__5727__auto___19023 = (0);
while(true){
if((i__5727__auto___19023 < len__5726__auto___19022)){
args19016.push((arguments[i__5727__auto___19023]));

var G__19024 = (i__5727__auto___19023 + (1));
i__5727__auto___19023 = G__19024;
continue;
} else {
}
break;
}

var G__19018 = args19016.length;
switch (G__19018) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19016.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async19019 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19019 = (function (f,blockable,meta19020){
this.f = f;
this.blockable = blockable;
this.meta19020 = meta19020;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19019.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19021,meta19020__$1){
var self__ = this;
var _19021__$1 = this;
return (new cljs.core.async.t_cljs$core$async19019(self__.f,self__.blockable,meta19020__$1));
});

cljs.core.async.t_cljs$core$async19019.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19021){
var self__ = this;
var _19021__$1 = this;
return self__.meta19020;
});

cljs.core.async.t_cljs$core$async19019.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19019.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19019.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async19019.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async19019.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta19020","meta19020",-1445476065,null)], null);
});

cljs.core.async.t_cljs$core$async19019.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19019.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19019";

cljs.core.async.t_cljs$core$async19019.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19019");
});

cljs.core.async.__GT_t_cljs$core$async19019 = (function cljs$core$async$__GT_t_cljs$core$async19019(f__$1,blockable__$1,meta19020){
return (new cljs.core.async.t_cljs$core$async19019(f__$1,blockable__$1,meta19020));
});

}

return (new cljs.core.async.t_cljs$core$async19019(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args19028 = [];
var len__5726__auto___19031 = arguments.length;
var i__5727__auto___19032 = (0);
while(true){
if((i__5727__auto___19032 < len__5726__auto___19031)){
args19028.push((arguments[i__5727__auto___19032]));

var G__19033 = (i__5727__auto___19032 + (1));
i__5727__auto___19032 = G__19033;
continue;
} else {
}
break;
}

var G__19030 = args19028.length;
switch (G__19030) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19028.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args19035 = [];
var len__5726__auto___19038 = arguments.length;
var i__5727__auto___19039 = (0);
while(true){
if((i__5727__auto___19039 < len__5726__auto___19038)){
args19035.push((arguments[i__5727__auto___19039]));

var G__19040 = (i__5727__auto___19039 + (1));
i__5727__auto___19039 = G__19040;
continue;
} else {
}
break;
}

var G__19037 = args19035.length;
switch (G__19037) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19035.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args19042 = [];
var len__5726__auto___19045 = arguments.length;
var i__5727__auto___19046 = (0);
while(true){
if((i__5727__auto___19046 < len__5726__auto___19045)){
args19042.push((arguments[i__5727__auto___19046]));

var G__19047 = (i__5727__auto___19046 + (1));
i__5727__auto___19046 = G__19047;
continue;
} else {
}
break;
}

var G__19044 = args19042.length;
switch (G__19044) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19042.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_19049 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_19049);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_19049,ret){
return (function (){
return fn1.call(null,val_19049);
});})(val_19049,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args19050 = [];
var len__5726__auto___19053 = arguments.length;
var i__5727__auto___19054 = (0);
while(true){
if((i__5727__auto___19054 < len__5726__auto___19053)){
args19050.push((arguments[i__5727__auto___19054]));

var G__19055 = (i__5727__auto___19054 + (1));
i__5727__auto___19054 = G__19055;
continue;
} else {
}
break;
}

var G__19052 = args19050.length;
switch (G__19052) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19050.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___19057 = n;
var x_19058 = (0);
while(true){
if((x_19058 < n__5571__auto___19057)){
(a[x_19058] = (0));

var G__19059 = (x_19058 + (1));
x_19058 = G__19059;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__19060 = (i + (1));
i = G__19060;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async19064 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19064 = (function (alt_flag,flag,meta19065){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta19065 = meta19065;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19064.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_19066,meta19065__$1){
var self__ = this;
var _19066__$1 = this;
return (new cljs.core.async.t_cljs$core$async19064(self__.alt_flag,self__.flag,meta19065__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async19064.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_19066){
var self__ = this;
var _19066__$1 = this;
return self__.meta19065;
});})(flag))
;

cljs.core.async.t_cljs$core$async19064.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19064.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async19064.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19064.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19064.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19065","meta19065",-1057848586,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async19064.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19064.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19064";

cljs.core.async.t_cljs$core$async19064.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19064");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async19064 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19064(alt_flag__$1,flag__$1,meta19065){
return (new cljs.core.async.t_cljs$core$async19064(alt_flag__$1,flag__$1,meta19065));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async19064(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async19070 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19070 = (function (alt_handler,flag,cb,meta19071){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta19071 = meta19071;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19070.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19072,meta19071__$1){
var self__ = this;
var _19072__$1 = this;
return (new cljs.core.async.t_cljs$core$async19070(self__.alt_handler,self__.flag,self__.cb,meta19071__$1));
});

cljs.core.async.t_cljs$core$async19070.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19072){
var self__ = this;
var _19072__$1 = this;
return self__.meta19071;
});

cljs.core.async.t_cljs$core$async19070.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19070.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async19070.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19070.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async19070.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19071","meta19071",1477855806,null)], null);
});

cljs.core.async.t_cljs$core$async19070.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19070.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19070";

cljs.core.async.t_cljs$core$async19070.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19070");
});

cljs.core.async.__GT_t_cljs$core$async19070 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19070(alt_handler__$1,flag__$1,cb__$1,meta19071){
return (new cljs.core.async.t_cljs$core$async19070(alt_handler__$1,flag__$1,cb__$1,meta19071));
});

}

return (new cljs.core.async.t_cljs$core$async19070(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19073_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19073_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19074_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19074_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19075 = (i + (1));
i = G__19075;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___19081 = arguments.length;
var i__5727__auto___19082 = (0);
while(true){
if((i__5727__auto___19082 < len__5726__auto___19081)){
args__5733__auto__.push((arguments[i__5727__auto___19082]));

var G__19083 = (i__5727__auto___19082 + (1));
i__5727__auto___19082 = G__19083;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19078){
var map__19079 = p__19078;
var map__19079__$1 = ((((!((map__19079 == null)))?((((map__19079.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19079.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19079):map__19079);
var opts = map__19079__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19076){
var G__19077 = cljs.core.first.call(null,seq19076);
var seq19076__$1 = cljs.core.next.call(null,seq19076);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19077,seq19076__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args19084 = [];
var len__5726__auto___19134 = arguments.length;
var i__5727__auto___19135 = (0);
while(true){
if((i__5727__auto___19135 < len__5726__auto___19134)){
args19084.push((arguments[i__5727__auto___19135]));

var G__19136 = (i__5727__auto___19135 + (1));
i__5727__auto___19135 = G__19136;
continue;
} else {
}
break;
}

var G__19086 = args19084.length;
switch (G__19086) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19084.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11089__auto___19138 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___19138){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___19138){
return (function (state_19110){
var state_val_19111 = (state_19110[(1)]);
if((state_val_19111 === (7))){
var inst_19106 = (state_19110[(2)]);
var state_19110__$1 = state_19110;
var statearr_19112_19139 = state_19110__$1;
(statearr_19112_19139[(2)] = inst_19106);

(statearr_19112_19139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (1))){
var state_19110__$1 = state_19110;
var statearr_19113_19140 = state_19110__$1;
(statearr_19113_19140[(2)] = null);

(statearr_19113_19140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (4))){
var inst_19089 = (state_19110[(7)]);
var inst_19089__$1 = (state_19110[(2)]);
var inst_19090 = (inst_19089__$1 == null);
var state_19110__$1 = (function (){var statearr_19114 = state_19110;
(statearr_19114[(7)] = inst_19089__$1);

return statearr_19114;
})();
if(cljs.core.truth_(inst_19090)){
var statearr_19115_19141 = state_19110__$1;
(statearr_19115_19141[(1)] = (5));

} else {
var statearr_19116_19142 = state_19110__$1;
(statearr_19116_19142[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (13))){
var state_19110__$1 = state_19110;
var statearr_19117_19143 = state_19110__$1;
(statearr_19117_19143[(2)] = null);

(statearr_19117_19143[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (6))){
var inst_19089 = (state_19110[(7)]);
var state_19110__$1 = state_19110;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19110__$1,(11),to,inst_19089);
} else {
if((state_val_19111 === (3))){
var inst_19108 = (state_19110[(2)]);
var state_19110__$1 = state_19110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19110__$1,inst_19108);
} else {
if((state_val_19111 === (12))){
var state_19110__$1 = state_19110;
var statearr_19118_19144 = state_19110__$1;
(statearr_19118_19144[(2)] = null);

(statearr_19118_19144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (2))){
var state_19110__$1 = state_19110;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19110__$1,(4),from);
} else {
if((state_val_19111 === (11))){
var inst_19099 = (state_19110[(2)]);
var state_19110__$1 = state_19110;
if(cljs.core.truth_(inst_19099)){
var statearr_19119_19145 = state_19110__$1;
(statearr_19119_19145[(1)] = (12));

} else {
var statearr_19120_19146 = state_19110__$1;
(statearr_19120_19146[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (9))){
var state_19110__$1 = state_19110;
var statearr_19121_19147 = state_19110__$1;
(statearr_19121_19147[(2)] = null);

(statearr_19121_19147[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (5))){
var state_19110__$1 = state_19110;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19122_19148 = state_19110__$1;
(statearr_19122_19148[(1)] = (8));

} else {
var statearr_19123_19149 = state_19110__$1;
(statearr_19123_19149[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (14))){
var inst_19104 = (state_19110[(2)]);
var state_19110__$1 = state_19110;
var statearr_19124_19150 = state_19110__$1;
(statearr_19124_19150[(2)] = inst_19104);

(statearr_19124_19150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (10))){
var inst_19096 = (state_19110[(2)]);
var state_19110__$1 = state_19110;
var statearr_19125_19151 = state_19110__$1;
(statearr_19125_19151[(2)] = inst_19096);

(statearr_19125_19151[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19111 === (8))){
var inst_19093 = cljs.core.async.close_BANG_.call(null,to);
var state_19110__$1 = state_19110;
var statearr_19126_19152 = state_19110__$1;
(statearr_19126_19152[(2)] = inst_19093);

(statearr_19126_19152[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___19138))
;
return ((function (switch__10977__auto__,c__11089__auto___19138){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_19130 = [null,null,null,null,null,null,null,null];
(statearr_19130[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_19130[(1)] = (1));

return statearr_19130;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_19110){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19131){if((e19131 instanceof Object)){
var ex__10981__auto__ = e19131;
var statearr_19132_19153 = state_19110;
(statearr_19132_19153[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19110);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19131;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19154 = state_19110;
state_19110 = G__19154;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_19110){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_19110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___19138))
})();
var state__11091__auto__ = (function (){var statearr_19133 = f__11090__auto__.call(null);
(statearr_19133[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___19138);

return statearr_19133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___19138))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19338){
var vec__19339 = p__19338;
var v = cljs.core.nth.call(null,vec__19339,(0),null);
var p = cljs.core.nth.call(null,vec__19339,(1),null);
var job = vec__19339;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11089__auto___19521 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___19521,res,vec__19339,v,p,job,jobs,results){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___19521,res,vec__19339,v,p,job,jobs,results){
return (function (state_19344){
var state_val_19345 = (state_19344[(1)]);
if((state_val_19345 === (1))){
var state_19344__$1 = state_19344;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19344__$1,(2),res,v);
} else {
if((state_val_19345 === (2))){
var inst_19341 = (state_19344[(2)]);
var inst_19342 = cljs.core.async.close_BANG_.call(null,res);
var state_19344__$1 = (function (){var statearr_19346 = state_19344;
(statearr_19346[(7)] = inst_19341);

return statearr_19346;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19344__$1,inst_19342);
} else {
return null;
}
}
});})(c__11089__auto___19521,res,vec__19339,v,p,job,jobs,results))
;
return ((function (switch__10977__auto__,c__11089__auto___19521,res,vec__19339,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_19350 = [null,null,null,null,null,null,null,null];
(statearr_19350[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_19350[(1)] = (1));

return statearr_19350;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_19344){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19351){if((e19351 instanceof Object)){
var ex__10981__auto__ = e19351;
var statearr_19352_19522 = state_19344;
(statearr_19352_19522[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19344);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19351;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19523 = state_19344;
state_19344 = G__19523;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_19344){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_19344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___19521,res,vec__19339,v,p,job,jobs,results))
})();
var state__11091__auto__ = (function (){var statearr_19353 = f__11090__auto__.call(null);
(statearr_19353[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___19521);

return statearr_19353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___19521,res,vec__19339,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19354){
var vec__19355 = p__19354;
var v = cljs.core.nth.call(null,vec__19355,(0),null);
var p = cljs.core.nth.call(null,vec__19355,(1),null);
var job = vec__19355;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___19524 = n;
var __19525 = (0);
while(true){
if((__19525 < n__5571__auto___19524)){
var G__19356_19526 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19356_19526) {
case "compute":
var c__11089__auto___19528 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19525,c__11089__auto___19528,G__19356_19526,n__5571__auto___19524,jobs,results,process,async){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (__19525,c__11089__auto___19528,G__19356_19526,n__5571__auto___19524,jobs,results,process,async){
return (function (state_19369){
var state_val_19370 = (state_19369[(1)]);
if((state_val_19370 === (1))){
var state_19369__$1 = state_19369;
var statearr_19371_19529 = state_19369__$1;
(statearr_19371_19529[(2)] = null);

(statearr_19371_19529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (2))){
var state_19369__$1 = state_19369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19369__$1,(4),jobs);
} else {
if((state_val_19370 === (3))){
var inst_19367 = (state_19369[(2)]);
var state_19369__$1 = state_19369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19369__$1,inst_19367);
} else {
if((state_val_19370 === (4))){
var inst_19359 = (state_19369[(2)]);
var inst_19360 = process.call(null,inst_19359);
var state_19369__$1 = state_19369;
if(cljs.core.truth_(inst_19360)){
var statearr_19372_19530 = state_19369__$1;
(statearr_19372_19530[(1)] = (5));

} else {
var statearr_19373_19531 = state_19369__$1;
(statearr_19373_19531[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (5))){
var state_19369__$1 = state_19369;
var statearr_19374_19532 = state_19369__$1;
(statearr_19374_19532[(2)] = null);

(statearr_19374_19532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (6))){
var state_19369__$1 = state_19369;
var statearr_19375_19533 = state_19369__$1;
(statearr_19375_19533[(2)] = null);

(statearr_19375_19533[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (7))){
var inst_19365 = (state_19369[(2)]);
var state_19369__$1 = state_19369;
var statearr_19376_19534 = state_19369__$1;
(statearr_19376_19534[(2)] = inst_19365);

(statearr_19376_19534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19525,c__11089__auto___19528,G__19356_19526,n__5571__auto___19524,jobs,results,process,async))
;
return ((function (__19525,switch__10977__auto__,c__11089__auto___19528,G__19356_19526,n__5571__auto___19524,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_19380 = [null,null,null,null,null,null,null];
(statearr_19380[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_19380[(1)] = (1));

return statearr_19380;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_19369){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19381){if((e19381 instanceof Object)){
var ex__10981__auto__ = e19381;
var statearr_19382_19535 = state_19369;
(statearr_19382_19535[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19369);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19536 = state_19369;
state_19369 = G__19536;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_19369){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_19369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(__19525,switch__10977__auto__,c__11089__auto___19528,G__19356_19526,n__5571__auto___19524,jobs,results,process,async))
})();
var state__11091__auto__ = (function (){var statearr_19383 = f__11090__auto__.call(null);
(statearr_19383[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___19528);

return statearr_19383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(__19525,c__11089__auto___19528,G__19356_19526,n__5571__auto___19524,jobs,results,process,async))
);


break;
case "async":
var c__11089__auto___19537 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19525,c__11089__auto___19537,G__19356_19526,n__5571__auto___19524,jobs,results,process,async){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (__19525,c__11089__auto___19537,G__19356_19526,n__5571__auto___19524,jobs,results,process,async){
return (function (state_19396){
var state_val_19397 = (state_19396[(1)]);
if((state_val_19397 === (1))){
var state_19396__$1 = state_19396;
var statearr_19398_19538 = state_19396__$1;
(statearr_19398_19538[(2)] = null);

(statearr_19398_19538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (2))){
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19396__$1,(4),jobs);
} else {
if((state_val_19397 === (3))){
var inst_19394 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19396__$1,inst_19394);
} else {
if((state_val_19397 === (4))){
var inst_19386 = (state_19396[(2)]);
var inst_19387 = async.call(null,inst_19386);
var state_19396__$1 = state_19396;
if(cljs.core.truth_(inst_19387)){
var statearr_19399_19539 = state_19396__$1;
(statearr_19399_19539[(1)] = (5));

} else {
var statearr_19400_19540 = state_19396__$1;
(statearr_19400_19540[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (5))){
var state_19396__$1 = state_19396;
var statearr_19401_19541 = state_19396__$1;
(statearr_19401_19541[(2)] = null);

(statearr_19401_19541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (6))){
var state_19396__$1 = state_19396;
var statearr_19402_19542 = state_19396__$1;
(statearr_19402_19542[(2)] = null);

(statearr_19402_19542[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (7))){
var inst_19392 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19403_19543 = state_19396__$1;
(statearr_19403_19543[(2)] = inst_19392);

(statearr_19403_19543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19525,c__11089__auto___19537,G__19356_19526,n__5571__auto___19524,jobs,results,process,async))
;
return ((function (__19525,switch__10977__auto__,c__11089__auto___19537,G__19356_19526,n__5571__auto___19524,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_19407 = [null,null,null,null,null,null,null];
(statearr_19407[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_19407[(1)] = (1));

return statearr_19407;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_19396){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19408){if((e19408 instanceof Object)){
var ex__10981__auto__ = e19408;
var statearr_19409_19544 = state_19396;
(statearr_19409_19544[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19408;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19545 = state_19396;
state_19396 = G__19545;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_19396){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_19396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(__19525,switch__10977__auto__,c__11089__auto___19537,G__19356_19526,n__5571__auto___19524,jobs,results,process,async))
})();
var state__11091__auto__ = (function (){var statearr_19410 = f__11090__auto__.call(null);
(statearr_19410[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___19537);

return statearr_19410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(__19525,c__11089__auto___19537,G__19356_19526,n__5571__auto___19524,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19546 = (__19525 + (1));
__19525 = G__19546;
continue;
} else {
}
break;
}

var c__11089__auto___19547 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___19547,jobs,results,process,async){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___19547,jobs,results,process,async){
return (function (state_19432){
var state_val_19433 = (state_19432[(1)]);
if((state_val_19433 === (1))){
var state_19432__$1 = state_19432;
var statearr_19434_19548 = state_19432__$1;
(statearr_19434_19548[(2)] = null);

(statearr_19434_19548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19433 === (2))){
var state_19432__$1 = state_19432;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19432__$1,(4),from);
} else {
if((state_val_19433 === (3))){
var inst_19430 = (state_19432[(2)]);
var state_19432__$1 = state_19432;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19432__$1,inst_19430);
} else {
if((state_val_19433 === (4))){
var inst_19413 = (state_19432[(7)]);
var inst_19413__$1 = (state_19432[(2)]);
var inst_19414 = (inst_19413__$1 == null);
var state_19432__$1 = (function (){var statearr_19435 = state_19432;
(statearr_19435[(7)] = inst_19413__$1);

return statearr_19435;
})();
if(cljs.core.truth_(inst_19414)){
var statearr_19436_19549 = state_19432__$1;
(statearr_19436_19549[(1)] = (5));

} else {
var statearr_19437_19550 = state_19432__$1;
(statearr_19437_19550[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19433 === (5))){
var inst_19416 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19432__$1 = state_19432;
var statearr_19438_19551 = state_19432__$1;
(statearr_19438_19551[(2)] = inst_19416);

(statearr_19438_19551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19433 === (6))){
var inst_19418 = (state_19432[(8)]);
var inst_19413 = (state_19432[(7)]);
var inst_19418__$1 = cljs.core.async.chan.call(null,(1));
var inst_19419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19420 = [inst_19413,inst_19418__$1];
var inst_19421 = (new cljs.core.PersistentVector(null,2,(5),inst_19419,inst_19420,null));
var state_19432__$1 = (function (){var statearr_19439 = state_19432;
(statearr_19439[(8)] = inst_19418__$1);

return statearr_19439;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19432__$1,(8),jobs,inst_19421);
} else {
if((state_val_19433 === (7))){
var inst_19428 = (state_19432[(2)]);
var state_19432__$1 = state_19432;
var statearr_19440_19552 = state_19432__$1;
(statearr_19440_19552[(2)] = inst_19428);

(statearr_19440_19552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19433 === (8))){
var inst_19418 = (state_19432[(8)]);
var inst_19423 = (state_19432[(2)]);
var state_19432__$1 = (function (){var statearr_19441 = state_19432;
(statearr_19441[(9)] = inst_19423);

return statearr_19441;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19432__$1,(9),results,inst_19418);
} else {
if((state_val_19433 === (9))){
var inst_19425 = (state_19432[(2)]);
var state_19432__$1 = (function (){var statearr_19442 = state_19432;
(statearr_19442[(10)] = inst_19425);

return statearr_19442;
})();
var statearr_19443_19553 = state_19432__$1;
(statearr_19443_19553[(2)] = null);

(statearr_19443_19553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___19547,jobs,results,process,async))
;
return ((function (switch__10977__auto__,c__11089__auto___19547,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_19447 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19447[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_19447[(1)] = (1));

return statearr_19447;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_19432){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19432);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19448){if((e19448 instanceof Object)){
var ex__10981__auto__ = e19448;
var statearr_19449_19554 = state_19432;
(statearr_19449_19554[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19432);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19448;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19555 = state_19432;
state_19432 = G__19555;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_19432){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_19432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___19547,jobs,results,process,async))
})();
var state__11091__auto__ = (function (){var statearr_19450 = f__11090__auto__.call(null);
(statearr_19450[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___19547);

return statearr_19450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___19547,jobs,results,process,async))
);


var c__11089__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto__,jobs,results,process,async){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto__,jobs,results,process,async){
return (function (state_19488){
var state_val_19489 = (state_19488[(1)]);
if((state_val_19489 === (7))){
var inst_19484 = (state_19488[(2)]);
var state_19488__$1 = state_19488;
var statearr_19490_19556 = state_19488__$1;
(statearr_19490_19556[(2)] = inst_19484);

(statearr_19490_19556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (20))){
var state_19488__$1 = state_19488;
var statearr_19491_19557 = state_19488__$1;
(statearr_19491_19557[(2)] = null);

(statearr_19491_19557[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (1))){
var state_19488__$1 = state_19488;
var statearr_19492_19558 = state_19488__$1;
(statearr_19492_19558[(2)] = null);

(statearr_19492_19558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (4))){
var inst_19453 = (state_19488[(7)]);
var inst_19453__$1 = (state_19488[(2)]);
var inst_19454 = (inst_19453__$1 == null);
var state_19488__$1 = (function (){var statearr_19493 = state_19488;
(statearr_19493[(7)] = inst_19453__$1);

return statearr_19493;
})();
if(cljs.core.truth_(inst_19454)){
var statearr_19494_19559 = state_19488__$1;
(statearr_19494_19559[(1)] = (5));

} else {
var statearr_19495_19560 = state_19488__$1;
(statearr_19495_19560[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (15))){
var inst_19466 = (state_19488[(8)]);
var state_19488__$1 = state_19488;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19488__$1,(18),to,inst_19466);
} else {
if((state_val_19489 === (21))){
var inst_19479 = (state_19488[(2)]);
var state_19488__$1 = state_19488;
var statearr_19496_19561 = state_19488__$1;
(statearr_19496_19561[(2)] = inst_19479);

(statearr_19496_19561[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (13))){
var inst_19481 = (state_19488[(2)]);
var state_19488__$1 = (function (){var statearr_19497 = state_19488;
(statearr_19497[(9)] = inst_19481);

return statearr_19497;
})();
var statearr_19498_19562 = state_19488__$1;
(statearr_19498_19562[(2)] = null);

(statearr_19498_19562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (6))){
var inst_19453 = (state_19488[(7)]);
var state_19488__$1 = state_19488;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19488__$1,(11),inst_19453);
} else {
if((state_val_19489 === (17))){
var inst_19474 = (state_19488[(2)]);
var state_19488__$1 = state_19488;
if(cljs.core.truth_(inst_19474)){
var statearr_19499_19563 = state_19488__$1;
(statearr_19499_19563[(1)] = (19));

} else {
var statearr_19500_19564 = state_19488__$1;
(statearr_19500_19564[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (3))){
var inst_19486 = (state_19488[(2)]);
var state_19488__$1 = state_19488;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19488__$1,inst_19486);
} else {
if((state_val_19489 === (12))){
var inst_19463 = (state_19488[(10)]);
var state_19488__$1 = state_19488;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19488__$1,(14),inst_19463);
} else {
if((state_val_19489 === (2))){
var state_19488__$1 = state_19488;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19488__$1,(4),results);
} else {
if((state_val_19489 === (19))){
var state_19488__$1 = state_19488;
var statearr_19501_19565 = state_19488__$1;
(statearr_19501_19565[(2)] = null);

(statearr_19501_19565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (11))){
var inst_19463 = (state_19488[(2)]);
var state_19488__$1 = (function (){var statearr_19502 = state_19488;
(statearr_19502[(10)] = inst_19463);

return statearr_19502;
})();
var statearr_19503_19566 = state_19488__$1;
(statearr_19503_19566[(2)] = null);

(statearr_19503_19566[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (9))){
var state_19488__$1 = state_19488;
var statearr_19504_19567 = state_19488__$1;
(statearr_19504_19567[(2)] = null);

(statearr_19504_19567[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (5))){
var state_19488__$1 = state_19488;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19505_19568 = state_19488__$1;
(statearr_19505_19568[(1)] = (8));

} else {
var statearr_19506_19569 = state_19488__$1;
(statearr_19506_19569[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (14))){
var inst_19466 = (state_19488[(8)]);
var inst_19468 = (state_19488[(11)]);
var inst_19466__$1 = (state_19488[(2)]);
var inst_19467 = (inst_19466__$1 == null);
var inst_19468__$1 = cljs.core.not.call(null,inst_19467);
var state_19488__$1 = (function (){var statearr_19507 = state_19488;
(statearr_19507[(8)] = inst_19466__$1);

(statearr_19507[(11)] = inst_19468__$1);

return statearr_19507;
})();
if(inst_19468__$1){
var statearr_19508_19570 = state_19488__$1;
(statearr_19508_19570[(1)] = (15));

} else {
var statearr_19509_19571 = state_19488__$1;
(statearr_19509_19571[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (16))){
var inst_19468 = (state_19488[(11)]);
var state_19488__$1 = state_19488;
var statearr_19510_19572 = state_19488__$1;
(statearr_19510_19572[(2)] = inst_19468);

(statearr_19510_19572[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (10))){
var inst_19460 = (state_19488[(2)]);
var state_19488__$1 = state_19488;
var statearr_19511_19573 = state_19488__$1;
(statearr_19511_19573[(2)] = inst_19460);

(statearr_19511_19573[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (18))){
var inst_19471 = (state_19488[(2)]);
var state_19488__$1 = state_19488;
var statearr_19512_19574 = state_19488__$1;
(statearr_19512_19574[(2)] = inst_19471);

(statearr_19512_19574[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19489 === (8))){
var inst_19457 = cljs.core.async.close_BANG_.call(null,to);
var state_19488__$1 = state_19488;
var statearr_19513_19575 = state_19488__$1;
(statearr_19513_19575[(2)] = inst_19457);

(statearr_19513_19575[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto__,jobs,results,process,async))
;
return ((function (switch__10977__auto__,c__11089__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_19517 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19517[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__);

(statearr_19517[(1)] = (1));

return statearr_19517;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1 = (function (state_19488){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19488);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19518){if((e19518 instanceof Object)){
var ex__10981__auto__ = e19518;
var statearr_19519_19576 = state_19488;
(statearr_19519_19576[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19488);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19518;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19577 = state_19488;
state_19488 = G__19577;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__ = function(state_19488){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1.call(this,state_19488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto__,jobs,results,process,async))
})();
var state__11091__auto__ = (function (){var statearr_19520 = f__11090__auto__.call(null);
(statearr_19520[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto__);

return statearr_19520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto__,jobs,results,process,async))
);

return c__11089__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19578 = [];
var len__5726__auto___19581 = arguments.length;
var i__5727__auto___19582 = (0);
while(true){
if((i__5727__auto___19582 < len__5726__auto___19581)){
args19578.push((arguments[i__5727__auto___19582]));

var G__19583 = (i__5727__auto___19582 + (1));
i__5727__auto___19582 = G__19583;
continue;
} else {
}
break;
}

var G__19580 = args19578.length;
switch (G__19580) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19578.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19585 = [];
var len__5726__auto___19588 = arguments.length;
var i__5727__auto___19589 = (0);
while(true){
if((i__5727__auto___19589 < len__5726__auto___19588)){
args19585.push((arguments[i__5727__auto___19589]));

var G__19590 = (i__5727__auto___19589 + (1));
i__5727__auto___19589 = G__19590;
continue;
} else {
}
break;
}

var G__19587 = args19585.length;
switch (G__19587) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19585.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19592 = [];
var len__5726__auto___19645 = arguments.length;
var i__5727__auto___19646 = (0);
while(true){
if((i__5727__auto___19646 < len__5726__auto___19645)){
args19592.push((arguments[i__5727__auto___19646]));

var G__19647 = (i__5727__auto___19646 + (1));
i__5727__auto___19646 = G__19647;
continue;
} else {
}
break;
}

var G__19594 = args19592.length;
switch (G__19594) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19592.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11089__auto___19649 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___19649,tc,fc){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___19649,tc,fc){
return (function (state_19620){
var state_val_19621 = (state_19620[(1)]);
if((state_val_19621 === (7))){
var inst_19616 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
var statearr_19622_19650 = state_19620__$1;
(statearr_19622_19650[(2)] = inst_19616);

(statearr_19622_19650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (1))){
var state_19620__$1 = state_19620;
var statearr_19623_19651 = state_19620__$1;
(statearr_19623_19651[(2)] = null);

(statearr_19623_19651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (4))){
var inst_19597 = (state_19620[(7)]);
var inst_19597__$1 = (state_19620[(2)]);
var inst_19598 = (inst_19597__$1 == null);
var state_19620__$1 = (function (){var statearr_19624 = state_19620;
(statearr_19624[(7)] = inst_19597__$1);

return statearr_19624;
})();
if(cljs.core.truth_(inst_19598)){
var statearr_19625_19652 = state_19620__$1;
(statearr_19625_19652[(1)] = (5));

} else {
var statearr_19626_19653 = state_19620__$1;
(statearr_19626_19653[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (13))){
var state_19620__$1 = state_19620;
var statearr_19627_19654 = state_19620__$1;
(statearr_19627_19654[(2)] = null);

(statearr_19627_19654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (6))){
var inst_19597 = (state_19620[(7)]);
var inst_19603 = p.call(null,inst_19597);
var state_19620__$1 = state_19620;
if(cljs.core.truth_(inst_19603)){
var statearr_19628_19655 = state_19620__$1;
(statearr_19628_19655[(1)] = (9));

} else {
var statearr_19629_19656 = state_19620__$1;
(statearr_19629_19656[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (3))){
var inst_19618 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19620__$1,inst_19618);
} else {
if((state_val_19621 === (12))){
var state_19620__$1 = state_19620;
var statearr_19630_19657 = state_19620__$1;
(statearr_19630_19657[(2)] = null);

(statearr_19630_19657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (2))){
var state_19620__$1 = state_19620;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19620__$1,(4),ch);
} else {
if((state_val_19621 === (11))){
var inst_19597 = (state_19620[(7)]);
var inst_19607 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19620__$1,(8),inst_19607,inst_19597);
} else {
if((state_val_19621 === (9))){
var state_19620__$1 = state_19620;
var statearr_19631_19658 = state_19620__$1;
(statearr_19631_19658[(2)] = tc);

(statearr_19631_19658[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (5))){
var inst_19600 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19601 = cljs.core.async.close_BANG_.call(null,fc);
var state_19620__$1 = (function (){var statearr_19632 = state_19620;
(statearr_19632[(8)] = inst_19600);

return statearr_19632;
})();
var statearr_19633_19659 = state_19620__$1;
(statearr_19633_19659[(2)] = inst_19601);

(statearr_19633_19659[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (14))){
var inst_19614 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
var statearr_19634_19660 = state_19620__$1;
(statearr_19634_19660[(2)] = inst_19614);

(statearr_19634_19660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (10))){
var state_19620__$1 = state_19620;
var statearr_19635_19661 = state_19620__$1;
(statearr_19635_19661[(2)] = fc);

(statearr_19635_19661[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19621 === (8))){
var inst_19609 = (state_19620[(2)]);
var state_19620__$1 = state_19620;
if(cljs.core.truth_(inst_19609)){
var statearr_19636_19662 = state_19620__$1;
(statearr_19636_19662[(1)] = (12));

} else {
var statearr_19637_19663 = state_19620__$1;
(statearr_19637_19663[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___19649,tc,fc))
;
return ((function (switch__10977__auto__,c__11089__auto___19649,tc,fc){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_19641 = [null,null,null,null,null,null,null,null,null];
(statearr_19641[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_19641[(1)] = (1));

return statearr_19641;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_19620){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19642){if((e19642 instanceof Object)){
var ex__10981__auto__ = e19642;
var statearr_19643_19664 = state_19620;
(statearr_19643_19664[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19620);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19642;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19665 = state_19620;
state_19620 = G__19665;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_19620){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_19620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___19649,tc,fc))
})();
var state__11091__auto__ = (function (){var statearr_19644 = f__11090__auto__.call(null);
(statearr_19644[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___19649);

return statearr_19644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___19649,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11089__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto__){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto__){
return (function (state_19729){
var state_val_19730 = (state_19729[(1)]);
if((state_val_19730 === (7))){
var inst_19725 = (state_19729[(2)]);
var state_19729__$1 = state_19729;
var statearr_19731_19752 = state_19729__$1;
(statearr_19731_19752[(2)] = inst_19725);

(statearr_19731_19752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (1))){
var inst_19709 = init;
var state_19729__$1 = (function (){var statearr_19732 = state_19729;
(statearr_19732[(7)] = inst_19709);

return statearr_19732;
})();
var statearr_19733_19753 = state_19729__$1;
(statearr_19733_19753[(2)] = null);

(statearr_19733_19753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (4))){
var inst_19712 = (state_19729[(8)]);
var inst_19712__$1 = (state_19729[(2)]);
var inst_19713 = (inst_19712__$1 == null);
var state_19729__$1 = (function (){var statearr_19734 = state_19729;
(statearr_19734[(8)] = inst_19712__$1);

return statearr_19734;
})();
if(cljs.core.truth_(inst_19713)){
var statearr_19735_19754 = state_19729__$1;
(statearr_19735_19754[(1)] = (5));

} else {
var statearr_19736_19755 = state_19729__$1;
(statearr_19736_19755[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (6))){
var inst_19712 = (state_19729[(8)]);
var inst_19709 = (state_19729[(7)]);
var inst_19716 = (state_19729[(9)]);
var inst_19716__$1 = f.call(null,inst_19709,inst_19712);
var inst_19717 = cljs.core.reduced_QMARK_.call(null,inst_19716__$1);
var state_19729__$1 = (function (){var statearr_19737 = state_19729;
(statearr_19737[(9)] = inst_19716__$1);

return statearr_19737;
})();
if(inst_19717){
var statearr_19738_19756 = state_19729__$1;
(statearr_19738_19756[(1)] = (8));

} else {
var statearr_19739_19757 = state_19729__$1;
(statearr_19739_19757[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (3))){
var inst_19727 = (state_19729[(2)]);
var state_19729__$1 = state_19729;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19729__$1,inst_19727);
} else {
if((state_val_19730 === (2))){
var state_19729__$1 = state_19729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19729__$1,(4),ch);
} else {
if((state_val_19730 === (9))){
var inst_19716 = (state_19729[(9)]);
var inst_19709 = inst_19716;
var state_19729__$1 = (function (){var statearr_19740 = state_19729;
(statearr_19740[(7)] = inst_19709);

return statearr_19740;
})();
var statearr_19741_19758 = state_19729__$1;
(statearr_19741_19758[(2)] = null);

(statearr_19741_19758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (5))){
var inst_19709 = (state_19729[(7)]);
var state_19729__$1 = state_19729;
var statearr_19742_19759 = state_19729__$1;
(statearr_19742_19759[(2)] = inst_19709);

(statearr_19742_19759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (10))){
var inst_19723 = (state_19729[(2)]);
var state_19729__$1 = state_19729;
var statearr_19743_19760 = state_19729__$1;
(statearr_19743_19760[(2)] = inst_19723);

(statearr_19743_19760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19730 === (8))){
var inst_19716 = (state_19729[(9)]);
var inst_19719 = cljs.core.deref.call(null,inst_19716);
var state_19729__$1 = state_19729;
var statearr_19744_19761 = state_19729__$1;
(statearr_19744_19761[(2)] = inst_19719);

(statearr_19744_19761[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto__))
;
return ((function (switch__10977__auto__,c__11089__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10978__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10978__auto____0 = (function (){
var statearr_19748 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19748[(0)] = cljs$core$async$reduce_$_state_machine__10978__auto__);

(statearr_19748[(1)] = (1));

return statearr_19748;
});
var cljs$core$async$reduce_$_state_machine__10978__auto____1 = (function (state_19729){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19729);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19749){if((e19749 instanceof Object)){
var ex__10981__auto__ = e19749;
var statearr_19750_19762 = state_19729;
(statearr_19750_19762[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19729);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19749;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19763 = state_19729;
state_19729 = G__19763;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10978__auto__ = function(state_19729){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10978__auto____1.call(this,state_19729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10978__auto____0;
cljs$core$async$reduce_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10978__auto____1;
return cljs$core$async$reduce_$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto__))
})();
var state__11091__auto__ = (function (){var statearr_19751 = f__11090__auto__.call(null);
(statearr_19751[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto__);

return statearr_19751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto__))
);

return c__11089__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19764 = [];
var len__5726__auto___19816 = arguments.length;
var i__5727__auto___19817 = (0);
while(true){
if((i__5727__auto___19817 < len__5726__auto___19816)){
args19764.push((arguments[i__5727__auto___19817]));

var G__19818 = (i__5727__auto___19817 + (1));
i__5727__auto___19817 = G__19818;
continue;
} else {
}
break;
}

var G__19766 = args19764.length;
switch (G__19766) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19764.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11089__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto__){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto__){
return (function (state_19791){
var state_val_19792 = (state_19791[(1)]);
if((state_val_19792 === (7))){
var inst_19773 = (state_19791[(2)]);
var state_19791__$1 = state_19791;
var statearr_19793_19820 = state_19791__$1;
(statearr_19793_19820[(2)] = inst_19773);

(statearr_19793_19820[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (1))){
var inst_19767 = cljs.core.seq.call(null,coll);
var inst_19768 = inst_19767;
var state_19791__$1 = (function (){var statearr_19794 = state_19791;
(statearr_19794[(7)] = inst_19768);

return statearr_19794;
})();
var statearr_19795_19821 = state_19791__$1;
(statearr_19795_19821[(2)] = null);

(statearr_19795_19821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (4))){
var inst_19768 = (state_19791[(7)]);
var inst_19771 = cljs.core.first.call(null,inst_19768);
var state_19791__$1 = state_19791;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19791__$1,(7),ch,inst_19771);
} else {
if((state_val_19792 === (13))){
var inst_19785 = (state_19791[(2)]);
var state_19791__$1 = state_19791;
var statearr_19796_19822 = state_19791__$1;
(statearr_19796_19822[(2)] = inst_19785);

(statearr_19796_19822[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (6))){
var inst_19776 = (state_19791[(2)]);
var state_19791__$1 = state_19791;
if(cljs.core.truth_(inst_19776)){
var statearr_19797_19823 = state_19791__$1;
(statearr_19797_19823[(1)] = (8));

} else {
var statearr_19798_19824 = state_19791__$1;
(statearr_19798_19824[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (3))){
var inst_19789 = (state_19791[(2)]);
var state_19791__$1 = state_19791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19791__$1,inst_19789);
} else {
if((state_val_19792 === (12))){
var state_19791__$1 = state_19791;
var statearr_19799_19825 = state_19791__$1;
(statearr_19799_19825[(2)] = null);

(statearr_19799_19825[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (2))){
var inst_19768 = (state_19791[(7)]);
var state_19791__$1 = state_19791;
if(cljs.core.truth_(inst_19768)){
var statearr_19800_19826 = state_19791__$1;
(statearr_19800_19826[(1)] = (4));

} else {
var statearr_19801_19827 = state_19791__$1;
(statearr_19801_19827[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (11))){
var inst_19782 = cljs.core.async.close_BANG_.call(null,ch);
var state_19791__$1 = state_19791;
var statearr_19802_19828 = state_19791__$1;
(statearr_19802_19828[(2)] = inst_19782);

(statearr_19802_19828[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (9))){
var state_19791__$1 = state_19791;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19803_19829 = state_19791__$1;
(statearr_19803_19829[(1)] = (11));

} else {
var statearr_19804_19830 = state_19791__$1;
(statearr_19804_19830[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (5))){
var inst_19768 = (state_19791[(7)]);
var state_19791__$1 = state_19791;
var statearr_19805_19831 = state_19791__$1;
(statearr_19805_19831[(2)] = inst_19768);

(statearr_19805_19831[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (10))){
var inst_19787 = (state_19791[(2)]);
var state_19791__$1 = state_19791;
var statearr_19806_19832 = state_19791__$1;
(statearr_19806_19832[(2)] = inst_19787);

(statearr_19806_19832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19792 === (8))){
var inst_19768 = (state_19791[(7)]);
var inst_19778 = cljs.core.next.call(null,inst_19768);
var inst_19768__$1 = inst_19778;
var state_19791__$1 = (function (){var statearr_19807 = state_19791;
(statearr_19807[(7)] = inst_19768__$1);

return statearr_19807;
})();
var statearr_19808_19833 = state_19791__$1;
(statearr_19808_19833[(2)] = null);

(statearr_19808_19833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto__))
;
return ((function (switch__10977__auto__,c__11089__auto__){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_19812 = [null,null,null,null,null,null,null,null];
(statearr_19812[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_19812[(1)] = (1));

return statearr_19812;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_19791){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_19791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e19813){if((e19813 instanceof Object)){
var ex__10981__auto__ = e19813;
var statearr_19814_19834 = state_19791;
(statearr_19814_19834[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19791);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19813;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19835 = state_19791;
state_19791 = G__19835;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_19791){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_19791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto__))
})();
var state__11091__auto__ = (function (){var statearr_19815 = f__11090__auto__.call(null);
(statearr_19815[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto__);

return statearr_19815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto__))
);

return c__11089__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20057 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20057 = (function (mult,ch,cs,meta20058){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta20058 = meta20058;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20057.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_20059,meta20058__$1){
var self__ = this;
var _20059__$1 = this;
return (new cljs.core.async.t_cljs$core$async20057(self__.mult,self__.ch,self__.cs,meta20058__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async20057.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_20059){
var self__ = this;
var _20059__$1 = this;
return self__.meta20058;
});})(cs))
;

cljs.core.async.t_cljs$core$async20057.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20057.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async20057.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async20057.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20057.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20057.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20057.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20058","meta20058",-1303014986,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async20057.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20057.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20057";

cljs.core.async.t_cljs$core$async20057.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20057");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async20057 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async20057(mult__$1,ch__$1,cs__$1,meta20058){
return (new cljs.core.async.t_cljs$core$async20057(mult__$1,ch__$1,cs__$1,meta20058));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async20057(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11089__auto___20278 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___20278,cs,m,dchan,dctr,done){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___20278,cs,m,dchan,dctr,done){
return (function (state_20190){
var state_val_20191 = (state_20190[(1)]);
if((state_val_20191 === (7))){
var inst_20186 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20192_20279 = state_20190__$1;
(statearr_20192_20279[(2)] = inst_20186);

(statearr_20192_20279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (20))){
var inst_20091 = (state_20190[(7)]);
var inst_20101 = cljs.core.first.call(null,inst_20091);
var inst_20102 = cljs.core.nth.call(null,inst_20101,(0),null);
var inst_20103 = cljs.core.nth.call(null,inst_20101,(1),null);
var state_20190__$1 = (function (){var statearr_20193 = state_20190;
(statearr_20193[(8)] = inst_20102);

return statearr_20193;
})();
if(cljs.core.truth_(inst_20103)){
var statearr_20194_20280 = state_20190__$1;
(statearr_20194_20280[(1)] = (22));

} else {
var statearr_20195_20281 = state_20190__$1;
(statearr_20195_20281[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (27))){
var inst_20133 = (state_20190[(9)]);
var inst_20138 = (state_20190[(10)]);
var inst_20062 = (state_20190[(11)]);
var inst_20131 = (state_20190[(12)]);
var inst_20138__$1 = cljs.core._nth.call(null,inst_20131,inst_20133);
var inst_20139 = cljs.core.async.put_BANG_.call(null,inst_20138__$1,inst_20062,done);
var state_20190__$1 = (function (){var statearr_20196 = state_20190;
(statearr_20196[(10)] = inst_20138__$1);

return statearr_20196;
})();
if(cljs.core.truth_(inst_20139)){
var statearr_20197_20282 = state_20190__$1;
(statearr_20197_20282[(1)] = (30));

} else {
var statearr_20198_20283 = state_20190__$1;
(statearr_20198_20283[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (1))){
var state_20190__$1 = state_20190;
var statearr_20199_20284 = state_20190__$1;
(statearr_20199_20284[(2)] = null);

(statearr_20199_20284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (24))){
var inst_20091 = (state_20190[(7)]);
var inst_20108 = (state_20190[(2)]);
var inst_20109 = cljs.core.next.call(null,inst_20091);
var inst_20071 = inst_20109;
var inst_20072 = null;
var inst_20073 = (0);
var inst_20074 = (0);
var state_20190__$1 = (function (){var statearr_20200 = state_20190;
(statearr_20200[(13)] = inst_20072);

(statearr_20200[(14)] = inst_20073);

(statearr_20200[(15)] = inst_20071);

(statearr_20200[(16)] = inst_20108);

(statearr_20200[(17)] = inst_20074);

return statearr_20200;
})();
var statearr_20201_20285 = state_20190__$1;
(statearr_20201_20285[(2)] = null);

(statearr_20201_20285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (39))){
var state_20190__$1 = state_20190;
var statearr_20205_20286 = state_20190__$1;
(statearr_20205_20286[(2)] = null);

(statearr_20205_20286[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (4))){
var inst_20062 = (state_20190[(11)]);
var inst_20062__$1 = (state_20190[(2)]);
var inst_20063 = (inst_20062__$1 == null);
var state_20190__$1 = (function (){var statearr_20206 = state_20190;
(statearr_20206[(11)] = inst_20062__$1);

return statearr_20206;
})();
if(cljs.core.truth_(inst_20063)){
var statearr_20207_20287 = state_20190__$1;
(statearr_20207_20287[(1)] = (5));

} else {
var statearr_20208_20288 = state_20190__$1;
(statearr_20208_20288[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (15))){
var inst_20072 = (state_20190[(13)]);
var inst_20073 = (state_20190[(14)]);
var inst_20071 = (state_20190[(15)]);
var inst_20074 = (state_20190[(17)]);
var inst_20087 = (state_20190[(2)]);
var inst_20088 = (inst_20074 + (1));
var tmp20202 = inst_20072;
var tmp20203 = inst_20073;
var tmp20204 = inst_20071;
var inst_20071__$1 = tmp20204;
var inst_20072__$1 = tmp20202;
var inst_20073__$1 = tmp20203;
var inst_20074__$1 = inst_20088;
var state_20190__$1 = (function (){var statearr_20209 = state_20190;
(statearr_20209[(13)] = inst_20072__$1);

(statearr_20209[(14)] = inst_20073__$1);

(statearr_20209[(15)] = inst_20071__$1);

(statearr_20209[(17)] = inst_20074__$1);

(statearr_20209[(18)] = inst_20087);

return statearr_20209;
})();
var statearr_20210_20289 = state_20190__$1;
(statearr_20210_20289[(2)] = null);

(statearr_20210_20289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (21))){
var inst_20112 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20214_20290 = state_20190__$1;
(statearr_20214_20290[(2)] = inst_20112);

(statearr_20214_20290[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (31))){
var inst_20138 = (state_20190[(10)]);
var inst_20142 = done.call(null,null);
var inst_20143 = cljs.core.async.untap_STAR_.call(null,m,inst_20138);
var state_20190__$1 = (function (){var statearr_20215 = state_20190;
(statearr_20215[(19)] = inst_20142);

return statearr_20215;
})();
var statearr_20216_20291 = state_20190__$1;
(statearr_20216_20291[(2)] = inst_20143);

(statearr_20216_20291[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (32))){
var inst_20133 = (state_20190[(9)]);
var inst_20132 = (state_20190[(20)]);
var inst_20130 = (state_20190[(21)]);
var inst_20131 = (state_20190[(12)]);
var inst_20145 = (state_20190[(2)]);
var inst_20146 = (inst_20133 + (1));
var tmp20211 = inst_20132;
var tmp20212 = inst_20130;
var tmp20213 = inst_20131;
var inst_20130__$1 = tmp20212;
var inst_20131__$1 = tmp20213;
var inst_20132__$1 = tmp20211;
var inst_20133__$1 = inst_20146;
var state_20190__$1 = (function (){var statearr_20217 = state_20190;
(statearr_20217[(9)] = inst_20133__$1);

(statearr_20217[(20)] = inst_20132__$1);

(statearr_20217[(21)] = inst_20130__$1);

(statearr_20217[(22)] = inst_20145);

(statearr_20217[(12)] = inst_20131__$1);

return statearr_20217;
})();
var statearr_20218_20292 = state_20190__$1;
(statearr_20218_20292[(2)] = null);

(statearr_20218_20292[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (40))){
var inst_20158 = (state_20190[(23)]);
var inst_20162 = done.call(null,null);
var inst_20163 = cljs.core.async.untap_STAR_.call(null,m,inst_20158);
var state_20190__$1 = (function (){var statearr_20219 = state_20190;
(statearr_20219[(24)] = inst_20162);

return statearr_20219;
})();
var statearr_20220_20293 = state_20190__$1;
(statearr_20220_20293[(2)] = inst_20163);

(statearr_20220_20293[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (33))){
var inst_20149 = (state_20190[(25)]);
var inst_20151 = cljs.core.chunked_seq_QMARK_.call(null,inst_20149);
var state_20190__$1 = state_20190;
if(inst_20151){
var statearr_20221_20294 = state_20190__$1;
(statearr_20221_20294[(1)] = (36));

} else {
var statearr_20222_20295 = state_20190__$1;
(statearr_20222_20295[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (13))){
var inst_20081 = (state_20190[(26)]);
var inst_20084 = cljs.core.async.close_BANG_.call(null,inst_20081);
var state_20190__$1 = state_20190;
var statearr_20223_20296 = state_20190__$1;
(statearr_20223_20296[(2)] = inst_20084);

(statearr_20223_20296[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (22))){
var inst_20102 = (state_20190[(8)]);
var inst_20105 = cljs.core.async.close_BANG_.call(null,inst_20102);
var state_20190__$1 = state_20190;
var statearr_20224_20297 = state_20190__$1;
(statearr_20224_20297[(2)] = inst_20105);

(statearr_20224_20297[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (36))){
var inst_20149 = (state_20190[(25)]);
var inst_20153 = cljs.core.chunk_first.call(null,inst_20149);
var inst_20154 = cljs.core.chunk_rest.call(null,inst_20149);
var inst_20155 = cljs.core.count.call(null,inst_20153);
var inst_20130 = inst_20154;
var inst_20131 = inst_20153;
var inst_20132 = inst_20155;
var inst_20133 = (0);
var state_20190__$1 = (function (){var statearr_20225 = state_20190;
(statearr_20225[(9)] = inst_20133);

(statearr_20225[(20)] = inst_20132);

(statearr_20225[(21)] = inst_20130);

(statearr_20225[(12)] = inst_20131);

return statearr_20225;
})();
var statearr_20226_20298 = state_20190__$1;
(statearr_20226_20298[(2)] = null);

(statearr_20226_20298[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (41))){
var inst_20149 = (state_20190[(25)]);
var inst_20165 = (state_20190[(2)]);
var inst_20166 = cljs.core.next.call(null,inst_20149);
var inst_20130 = inst_20166;
var inst_20131 = null;
var inst_20132 = (0);
var inst_20133 = (0);
var state_20190__$1 = (function (){var statearr_20227 = state_20190;
(statearr_20227[(9)] = inst_20133);

(statearr_20227[(20)] = inst_20132);

(statearr_20227[(21)] = inst_20130);

(statearr_20227[(12)] = inst_20131);

(statearr_20227[(27)] = inst_20165);

return statearr_20227;
})();
var statearr_20228_20299 = state_20190__$1;
(statearr_20228_20299[(2)] = null);

(statearr_20228_20299[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (43))){
var state_20190__$1 = state_20190;
var statearr_20229_20300 = state_20190__$1;
(statearr_20229_20300[(2)] = null);

(statearr_20229_20300[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (29))){
var inst_20174 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20230_20301 = state_20190__$1;
(statearr_20230_20301[(2)] = inst_20174);

(statearr_20230_20301[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (44))){
var inst_20183 = (state_20190[(2)]);
var state_20190__$1 = (function (){var statearr_20231 = state_20190;
(statearr_20231[(28)] = inst_20183);

return statearr_20231;
})();
var statearr_20232_20302 = state_20190__$1;
(statearr_20232_20302[(2)] = null);

(statearr_20232_20302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (6))){
var inst_20122 = (state_20190[(29)]);
var inst_20121 = cljs.core.deref.call(null,cs);
var inst_20122__$1 = cljs.core.keys.call(null,inst_20121);
var inst_20123 = cljs.core.count.call(null,inst_20122__$1);
var inst_20124 = cljs.core.reset_BANG_.call(null,dctr,inst_20123);
var inst_20129 = cljs.core.seq.call(null,inst_20122__$1);
var inst_20130 = inst_20129;
var inst_20131 = null;
var inst_20132 = (0);
var inst_20133 = (0);
var state_20190__$1 = (function (){var statearr_20233 = state_20190;
(statearr_20233[(9)] = inst_20133);

(statearr_20233[(29)] = inst_20122__$1);

(statearr_20233[(20)] = inst_20132);

(statearr_20233[(21)] = inst_20130);

(statearr_20233[(12)] = inst_20131);

(statearr_20233[(30)] = inst_20124);

return statearr_20233;
})();
var statearr_20234_20303 = state_20190__$1;
(statearr_20234_20303[(2)] = null);

(statearr_20234_20303[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (28))){
var inst_20149 = (state_20190[(25)]);
var inst_20130 = (state_20190[(21)]);
var inst_20149__$1 = cljs.core.seq.call(null,inst_20130);
var state_20190__$1 = (function (){var statearr_20235 = state_20190;
(statearr_20235[(25)] = inst_20149__$1);

return statearr_20235;
})();
if(inst_20149__$1){
var statearr_20236_20304 = state_20190__$1;
(statearr_20236_20304[(1)] = (33));

} else {
var statearr_20237_20305 = state_20190__$1;
(statearr_20237_20305[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (25))){
var inst_20133 = (state_20190[(9)]);
var inst_20132 = (state_20190[(20)]);
var inst_20135 = (inst_20133 < inst_20132);
var inst_20136 = inst_20135;
var state_20190__$1 = state_20190;
if(cljs.core.truth_(inst_20136)){
var statearr_20238_20306 = state_20190__$1;
(statearr_20238_20306[(1)] = (27));

} else {
var statearr_20239_20307 = state_20190__$1;
(statearr_20239_20307[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (34))){
var state_20190__$1 = state_20190;
var statearr_20240_20308 = state_20190__$1;
(statearr_20240_20308[(2)] = null);

(statearr_20240_20308[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (17))){
var state_20190__$1 = state_20190;
var statearr_20241_20309 = state_20190__$1;
(statearr_20241_20309[(2)] = null);

(statearr_20241_20309[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (3))){
var inst_20188 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20190__$1,inst_20188);
} else {
if((state_val_20191 === (12))){
var inst_20117 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20242_20310 = state_20190__$1;
(statearr_20242_20310[(2)] = inst_20117);

(statearr_20242_20310[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (2))){
var state_20190__$1 = state_20190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20190__$1,(4),ch);
} else {
if((state_val_20191 === (23))){
var state_20190__$1 = state_20190;
var statearr_20243_20311 = state_20190__$1;
(statearr_20243_20311[(2)] = null);

(statearr_20243_20311[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (35))){
var inst_20172 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20244_20312 = state_20190__$1;
(statearr_20244_20312[(2)] = inst_20172);

(statearr_20244_20312[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (19))){
var inst_20091 = (state_20190[(7)]);
var inst_20095 = cljs.core.chunk_first.call(null,inst_20091);
var inst_20096 = cljs.core.chunk_rest.call(null,inst_20091);
var inst_20097 = cljs.core.count.call(null,inst_20095);
var inst_20071 = inst_20096;
var inst_20072 = inst_20095;
var inst_20073 = inst_20097;
var inst_20074 = (0);
var state_20190__$1 = (function (){var statearr_20245 = state_20190;
(statearr_20245[(13)] = inst_20072);

(statearr_20245[(14)] = inst_20073);

(statearr_20245[(15)] = inst_20071);

(statearr_20245[(17)] = inst_20074);

return statearr_20245;
})();
var statearr_20246_20313 = state_20190__$1;
(statearr_20246_20313[(2)] = null);

(statearr_20246_20313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (11))){
var inst_20071 = (state_20190[(15)]);
var inst_20091 = (state_20190[(7)]);
var inst_20091__$1 = cljs.core.seq.call(null,inst_20071);
var state_20190__$1 = (function (){var statearr_20247 = state_20190;
(statearr_20247[(7)] = inst_20091__$1);

return statearr_20247;
})();
if(inst_20091__$1){
var statearr_20248_20314 = state_20190__$1;
(statearr_20248_20314[(1)] = (16));

} else {
var statearr_20249_20315 = state_20190__$1;
(statearr_20249_20315[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (9))){
var inst_20119 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20250_20316 = state_20190__$1;
(statearr_20250_20316[(2)] = inst_20119);

(statearr_20250_20316[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (5))){
var inst_20069 = cljs.core.deref.call(null,cs);
var inst_20070 = cljs.core.seq.call(null,inst_20069);
var inst_20071 = inst_20070;
var inst_20072 = null;
var inst_20073 = (0);
var inst_20074 = (0);
var state_20190__$1 = (function (){var statearr_20251 = state_20190;
(statearr_20251[(13)] = inst_20072);

(statearr_20251[(14)] = inst_20073);

(statearr_20251[(15)] = inst_20071);

(statearr_20251[(17)] = inst_20074);

return statearr_20251;
})();
var statearr_20252_20317 = state_20190__$1;
(statearr_20252_20317[(2)] = null);

(statearr_20252_20317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (14))){
var state_20190__$1 = state_20190;
var statearr_20253_20318 = state_20190__$1;
(statearr_20253_20318[(2)] = null);

(statearr_20253_20318[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (45))){
var inst_20180 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20254_20319 = state_20190__$1;
(statearr_20254_20319[(2)] = inst_20180);

(statearr_20254_20319[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (26))){
var inst_20122 = (state_20190[(29)]);
var inst_20176 = (state_20190[(2)]);
var inst_20177 = cljs.core.seq.call(null,inst_20122);
var state_20190__$1 = (function (){var statearr_20255 = state_20190;
(statearr_20255[(31)] = inst_20176);

return statearr_20255;
})();
if(inst_20177){
var statearr_20256_20320 = state_20190__$1;
(statearr_20256_20320[(1)] = (42));

} else {
var statearr_20257_20321 = state_20190__$1;
(statearr_20257_20321[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (16))){
var inst_20091 = (state_20190[(7)]);
var inst_20093 = cljs.core.chunked_seq_QMARK_.call(null,inst_20091);
var state_20190__$1 = state_20190;
if(inst_20093){
var statearr_20258_20322 = state_20190__$1;
(statearr_20258_20322[(1)] = (19));

} else {
var statearr_20259_20323 = state_20190__$1;
(statearr_20259_20323[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (38))){
var inst_20169 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20260_20324 = state_20190__$1;
(statearr_20260_20324[(2)] = inst_20169);

(statearr_20260_20324[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (30))){
var state_20190__$1 = state_20190;
var statearr_20261_20325 = state_20190__$1;
(statearr_20261_20325[(2)] = null);

(statearr_20261_20325[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (10))){
var inst_20072 = (state_20190[(13)]);
var inst_20074 = (state_20190[(17)]);
var inst_20080 = cljs.core._nth.call(null,inst_20072,inst_20074);
var inst_20081 = cljs.core.nth.call(null,inst_20080,(0),null);
var inst_20082 = cljs.core.nth.call(null,inst_20080,(1),null);
var state_20190__$1 = (function (){var statearr_20262 = state_20190;
(statearr_20262[(26)] = inst_20081);

return statearr_20262;
})();
if(cljs.core.truth_(inst_20082)){
var statearr_20263_20326 = state_20190__$1;
(statearr_20263_20326[(1)] = (13));

} else {
var statearr_20264_20327 = state_20190__$1;
(statearr_20264_20327[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (18))){
var inst_20115 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20265_20328 = state_20190__$1;
(statearr_20265_20328[(2)] = inst_20115);

(statearr_20265_20328[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (42))){
var state_20190__$1 = state_20190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20190__$1,(45),dchan);
} else {
if((state_val_20191 === (37))){
var inst_20158 = (state_20190[(23)]);
var inst_20149 = (state_20190[(25)]);
var inst_20062 = (state_20190[(11)]);
var inst_20158__$1 = cljs.core.first.call(null,inst_20149);
var inst_20159 = cljs.core.async.put_BANG_.call(null,inst_20158__$1,inst_20062,done);
var state_20190__$1 = (function (){var statearr_20266 = state_20190;
(statearr_20266[(23)] = inst_20158__$1);

return statearr_20266;
})();
if(cljs.core.truth_(inst_20159)){
var statearr_20267_20329 = state_20190__$1;
(statearr_20267_20329[(1)] = (39));

} else {
var statearr_20268_20330 = state_20190__$1;
(statearr_20268_20330[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (8))){
var inst_20073 = (state_20190[(14)]);
var inst_20074 = (state_20190[(17)]);
var inst_20076 = (inst_20074 < inst_20073);
var inst_20077 = inst_20076;
var state_20190__$1 = state_20190;
if(cljs.core.truth_(inst_20077)){
var statearr_20269_20331 = state_20190__$1;
(statearr_20269_20331[(1)] = (10));

} else {
var statearr_20270_20332 = state_20190__$1;
(statearr_20270_20332[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___20278,cs,m,dchan,dctr,done))
;
return ((function (switch__10977__auto__,c__11089__auto___20278,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10978__auto__ = null;
var cljs$core$async$mult_$_state_machine__10978__auto____0 = (function (){
var statearr_20274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20274[(0)] = cljs$core$async$mult_$_state_machine__10978__auto__);

(statearr_20274[(1)] = (1));

return statearr_20274;
});
var cljs$core$async$mult_$_state_machine__10978__auto____1 = (function (state_20190){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_20190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e20275){if((e20275 instanceof Object)){
var ex__10981__auto__ = e20275;
var statearr_20276_20333 = state_20190;
(statearr_20276_20333[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20190);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20334 = state_20190;
state_20190 = G__20334;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10978__auto__ = function(state_20190){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10978__auto____1.call(this,state_20190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10978__auto____0;
cljs$core$async$mult_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10978__auto____1;
return cljs$core$async$mult_$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___20278,cs,m,dchan,dctr,done))
})();
var state__11091__auto__ = (function (){var statearr_20277 = f__11090__auto__.call(null);
(statearr_20277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___20278);

return statearr_20277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___20278,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20335 = [];
var len__5726__auto___20338 = arguments.length;
var i__5727__auto___20339 = (0);
while(true){
if((i__5727__auto___20339 < len__5726__auto___20338)){
args20335.push((arguments[i__5727__auto___20339]));

var G__20340 = (i__5727__auto___20339 + (1));
i__5727__auto___20339 = G__20340;
continue;
} else {
}
break;
}

var G__20337 = args20335.length;
switch (G__20337) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20335.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20352 = arguments.length;
var i__5727__auto___20353 = (0);
while(true){
if((i__5727__auto___20353 < len__5726__auto___20352)){
args__5733__auto__.push((arguments[i__5727__auto___20353]));

var G__20354 = (i__5727__auto___20353 + (1));
i__5727__auto___20353 = G__20354;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20346){
var map__20347 = p__20346;
var map__20347__$1 = ((((!((map__20347 == null)))?((((map__20347.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20347.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20347):map__20347);
var opts = map__20347__$1;
var statearr_20349_20355 = state;
(statearr_20349_20355[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20347,map__20347__$1,opts){
return (function (val){
var statearr_20350_20356 = state;
(statearr_20350_20356[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20347,map__20347__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20351_20357 = state;
(statearr_20351_20357[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20342){
var G__20343 = cljs.core.first.call(null,seq20342);
var seq20342__$1 = cljs.core.next.call(null,seq20342);
var G__20344 = cljs.core.first.call(null,seq20342__$1);
var seq20342__$2 = cljs.core.next.call(null,seq20342__$1);
var G__20345 = cljs.core.first.call(null,seq20342__$2);
var seq20342__$3 = cljs.core.next.call(null,seq20342__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20343,G__20344,G__20345,seq20342__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20521 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20521 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20522){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20522 = meta20522;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20523,meta20522__$1){
var self__ = this;
var _20523__$1 = this;
return (new cljs.core.async.t_cljs$core$async20521(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20522__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20523){
var self__ = this;
var _20523__$1 = this;
return self__.meta20522;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20522","meta20522",1718142911,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20521.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20521.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20521";

cljs.core.async.t_cljs$core$async20521.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20521");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20521 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20521(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20522){
return (new cljs.core.async.t_cljs$core$async20521(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20522));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20521(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11089__auto___20684 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___20684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___20684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20621){
var state_val_20622 = (state_20621[(1)]);
if((state_val_20622 === (7))){
var inst_20539 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
var statearr_20623_20685 = state_20621__$1;
(statearr_20623_20685[(2)] = inst_20539);

(statearr_20623_20685[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (20))){
var inst_20551 = (state_20621[(7)]);
var state_20621__$1 = state_20621;
var statearr_20624_20686 = state_20621__$1;
(statearr_20624_20686[(2)] = inst_20551);

(statearr_20624_20686[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (27))){
var state_20621__$1 = state_20621;
var statearr_20625_20687 = state_20621__$1;
(statearr_20625_20687[(2)] = null);

(statearr_20625_20687[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (1))){
var inst_20527 = (state_20621[(8)]);
var inst_20527__$1 = calc_state.call(null);
var inst_20529 = (inst_20527__$1 == null);
var inst_20530 = cljs.core.not.call(null,inst_20529);
var state_20621__$1 = (function (){var statearr_20626 = state_20621;
(statearr_20626[(8)] = inst_20527__$1);

return statearr_20626;
})();
if(inst_20530){
var statearr_20627_20688 = state_20621__$1;
(statearr_20627_20688[(1)] = (2));

} else {
var statearr_20628_20689 = state_20621__$1;
(statearr_20628_20689[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (24))){
var inst_20574 = (state_20621[(9)]);
var inst_20595 = (state_20621[(10)]);
var inst_20581 = (state_20621[(11)]);
var inst_20595__$1 = inst_20574.call(null,inst_20581);
var state_20621__$1 = (function (){var statearr_20629 = state_20621;
(statearr_20629[(10)] = inst_20595__$1);

return statearr_20629;
})();
if(cljs.core.truth_(inst_20595__$1)){
var statearr_20630_20690 = state_20621__$1;
(statearr_20630_20690[(1)] = (29));

} else {
var statearr_20631_20691 = state_20621__$1;
(statearr_20631_20691[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (4))){
var inst_20542 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
if(cljs.core.truth_(inst_20542)){
var statearr_20632_20692 = state_20621__$1;
(statearr_20632_20692[(1)] = (8));

} else {
var statearr_20633_20693 = state_20621__$1;
(statearr_20633_20693[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (15))){
var inst_20568 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
if(cljs.core.truth_(inst_20568)){
var statearr_20634_20694 = state_20621__$1;
(statearr_20634_20694[(1)] = (19));

} else {
var statearr_20635_20695 = state_20621__$1;
(statearr_20635_20695[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (21))){
var inst_20573 = (state_20621[(12)]);
var inst_20573__$1 = (state_20621[(2)]);
var inst_20574 = cljs.core.get.call(null,inst_20573__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20575 = cljs.core.get.call(null,inst_20573__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20576 = cljs.core.get.call(null,inst_20573__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20621__$1 = (function (){var statearr_20636 = state_20621;
(statearr_20636[(9)] = inst_20574);

(statearr_20636[(12)] = inst_20573__$1);

(statearr_20636[(13)] = inst_20575);

return statearr_20636;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20621__$1,(22),inst_20576);
} else {
if((state_val_20622 === (31))){
var inst_20603 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
if(cljs.core.truth_(inst_20603)){
var statearr_20637_20696 = state_20621__$1;
(statearr_20637_20696[(1)] = (32));

} else {
var statearr_20638_20697 = state_20621__$1;
(statearr_20638_20697[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (32))){
var inst_20580 = (state_20621[(14)]);
var state_20621__$1 = state_20621;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20621__$1,(35),out,inst_20580);
} else {
if((state_val_20622 === (33))){
var inst_20573 = (state_20621[(12)]);
var inst_20551 = inst_20573;
var state_20621__$1 = (function (){var statearr_20639 = state_20621;
(statearr_20639[(7)] = inst_20551);

return statearr_20639;
})();
var statearr_20640_20698 = state_20621__$1;
(statearr_20640_20698[(2)] = null);

(statearr_20640_20698[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (13))){
var inst_20551 = (state_20621[(7)]);
var inst_20558 = inst_20551.cljs$lang$protocol_mask$partition0$;
var inst_20559 = (inst_20558 & (64));
var inst_20560 = inst_20551.cljs$core$ISeq$;
var inst_20561 = (inst_20559) || (inst_20560);
var state_20621__$1 = state_20621;
if(cljs.core.truth_(inst_20561)){
var statearr_20641_20699 = state_20621__$1;
(statearr_20641_20699[(1)] = (16));

} else {
var statearr_20642_20700 = state_20621__$1;
(statearr_20642_20700[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (22))){
var inst_20580 = (state_20621[(14)]);
var inst_20581 = (state_20621[(11)]);
var inst_20579 = (state_20621[(2)]);
var inst_20580__$1 = cljs.core.nth.call(null,inst_20579,(0),null);
var inst_20581__$1 = cljs.core.nth.call(null,inst_20579,(1),null);
var inst_20582 = (inst_20580__$1 == null);
var inst_20583 = cljs.core._EQ_.call(null,inst_20581__$1,change);
var inst_20584 = (inst_20582) || (inst_20583);
var state_20621__$1 = (function (){var statearr_20643 = state_20621;
(statearr_20643[(14)] = inst_20580__$1);

(statearr_20643[(11)] = inst_20581__$1);

return statearr_20643;
})();
if(cljs.core.truth_(inst_20584)){
var statearr_20644_20701 = state_20621__$1;
(statearr_20644_20701[(1)] = (23));

} else {
var statearr_20645_20702 = state_20621__$1;
(statearr_20645_20702[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (36))){
var inst_20573 = (state_20621[(12)]);
var inst_20551 = inst_20573;
var state_20621__$1 = (function (){var statearr_20646 = state_20621;
(statearr_20646[(7)] = inst_20551);

return statearr_20646;
})();
var statearr_20647_20703 = state_20621__$1;
(statearr_20647_20703[(2)] = null);

(statearr_20647_20703[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (29))){
var inst_20595 = (state_20621[(10)]);
var state_20621__$1 = state_20621;
var statearr_20648_20704 = state_20621__$1;
(statearr_20648_20704[(2)] = inst_20595);

(statearr_20648_20704[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (6))){
var state_20621__$1 = state_20621;
var statearr_20649_20705 = state_20621__$1;
(statearr_20649_20705[(2)] = false);

(statearr_20649_20705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (28))){
var inst_20591 = (state_20621[(2)]);
var inst_20592 = calc_state.call(null);
var inst_20551 = inst_20592;
var state_20621__$1 = (function (){var statearr_20650 = state_20621;
(statearr_20650[(15)] = inst_20591);

(statearr_20650[(7)] = inst_20551);

return statearr_20650;
})();
var statearr_20651_20706 = state_20621__$1;
(statearr_20651_20706[(2)] = null);

(statearr_20651_20706[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (25))){
var inst_20617 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
var statearr_20652_20707 = state_20621__$1;
(statearr_20652_20707[(2)] = inst_20617);

(statearr_20652_20707[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (34))){
var inst_20615 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
var statearr_20653_20708 = state_20621__$1;
(statearr_20653_20708[(2)] = inst_20615);

(statearr_20653_20708[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (17))){
var state_20621__$1 = state_20621;
var statearr_20654_20709 = state_20621__$1;
(statearr_20654_20709[(2)] = false);

(statearr_20654_20709[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (3))){
var state_20621__$1 = state_20621;
var statearr_20655_20710 = state_20621__$1;
(statearr_20655_20710[(2)] = false);

(statearr_20655_20710[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (12))){
var inst_20619 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20621__$1,inst_20619);
} else {
if((state_val_20622 === (2))){
var inst_20527 = (state_20621[(8)]);
var inst_20532 = inst_20527.cljs$lang$protocol_mask$partition0$;
var inst_20533 = (inst_20532 & (64));
var inst_20534 = inst_20527.cljs$core$ISeq$;
var inst_20535 = (inst_20533) || (inst_20534);
var state_20621__$1 = state_20621;
if(cljs.core.truth_(inst_20535)){
var statearr_20656_20711 = state_20621__$1;
(statearr_20656_20711[(1)] = (5));

} else {
var statearr_20657_20712 = state_20621__$1;
(statearr_20657_20712[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (23))){
var inst_20580 = (state_20621[(14)]);
var inst_20586 = (inst_20580 == null);
var state_20621__$1 = state_20621;
if(cljs.core.truth_(inst_20586)){
var statearr_20658_20713 = state_20621__$1;
(statearr_20658_20713[(1)] = (26));

} else {
var statearr_20659_20714 = state_20621__$1;
(statearr_20659_20714[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (35))){
var inst_20606 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
if(cljs.core.truth_(inst_20606)){
var statearr_20660_20715 = state_20621__$1;
(statearr_20660_20715[(1)] = (36));

} else {
var statearr_20661_20716 = state_20621__$1;
(statearr_20661_20716[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (19))){
var inst_20551 = (state_20621[(7)]);
var inst_20570 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20551);
var state_20621__$1 = state_20621;
var statearr_20662_20717 = state_20621__$1;
(statearr_20662_20717[(2)] = inst_20570);

(statearr_20662_20717[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (11))){
var inst_20551 = (state_20621[(7)]);
var inst_20555 = (inst_20551 == null);
var inst_20556 = cljs.core.not.call(null,inst_20555);
var state_20621__$1 = state_20621;
if(inst_20556){
var statearr_20663_20718 = state_20621__$1;
(statearr_20663_20718[(1)] = (13));

} else {
var statearr_20664_20719 = state_20621__$1;
(statearr_20664_20719[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (9))){
var inst_20527 = (state_20621[(8)]);
var state_20621__$1 = state_20621;
var statearr_20665_20720 = state_20621__$1;
(statearr_20665_20720[(2)] = inst_20527);

(statearr_20665_20720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (5))){
var state_20621__$1 = state_20621;
var statearr_20666_20721 = state_20621__$1;
(statearr_20666_20721[(2)] = true);

(statearr_20666_20721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (14))){
var state_20621__$1 = state_20621;
var statearr_20667_20722 = state_20621__$1;
(statearr_20667_20722[(2)] = false);

(statearr_20667_20722[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (26))){
var inst_20581 = (state_20621[(11)]);
var inst_20588 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20581);
var state_20621__$1 = state_20621;
var statearr_20668_20723 = state_20621__$1;
(statearr_20668_20723[(2)] = inst_20588);

(statearr_20668_20723[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (16))){
var state_20621__$1 = state_20621;
var statearr_20669_20724 = state_20621__$1;
(statearr_20669_20724[(2)] = true);

(statearr_20669_20724[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (38))){
var inst_20611 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
var statearr_20670_20725 = state_20621__$1;
(statearr_20670_20725[(2)] = inst_20611);

(statearr_20670_20725[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (30))){
var inst_20574 = (state_20621[(9)]);
var inst_20575 = (state_20621[(13)]);
var inst_20581 = (state_20621[(11)]);
var inst_20598 = cljs.core.empty_QMARK_.call(null,inst_20574);
var inst_20599 = inst_20575.call(null,inst_20581);
var inst_20600 = cljs.core.not.call(null,inst_20599);
var inst_20601 = (inst_20598) && (inst_20600);
var state_20621__$1 = state_20621;
var statearr_20671_20726 = state_20621__$1;
(statearr_20671_20726[(2)] = inst_20601);

(statearr_20671_20726[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (10))){
var inst_20527 = (state_20621[(8)]);
var inst_20547 = (state_20621[(2)]);
var inst_20548 = cljs.core.get.call(null,inst_20547,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20549 = cljs.core.get.call(null,inst_20547,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20550 = cljs.core.get.call(null,inst_20547,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20551 = inst_20527;
var state_20621__$1 = (function (){var statearr_20672 = state_20621;
(statearr_20672[(16)] = inst_20548);

(statearr_20672[(17)] = inst_20550);

(statearr_20672[(7)] = inst_20551);

(statearr_20672[(18)] = inst_20549);

return statearr_20672;
})();
var statearr_20673_20727 = state_20621__$1;
(statearr_20673_20727[(2)] = null);

(statearr_20673_20727[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (18))){
var inst_20565 = (state_20621[(2)]);
var state_20621__$1 = state_20621;
var statearr_20674_20728 = state_20621__$1;
(statearr_20674_20728[(2)] = inst_20565);

(statearr_20674_20728[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (37))){
var state_20621__$1 = state_20621;
var statearr_20675_20729 = state_20621__$1;
(statearr_20675_20729[(2)] = null);

(statearr_20675_20729[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20622 === (8))){
var inst_20527 = (state_20621[(8)]);
var inst_20544 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20527);
var state_20621__$1 = state_20621;
var statearr_20676_20730 = state_20621__$1;
(statearr_20676_20730[(2)] = inst_20544);

(statearr_20676_20730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___20684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10977__auto__,c__11089__auto___20684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10978__auto__ = null;
var cljs$core$async$mix_$_state_machine__10978__auto____0 = (function (){
var statearr_20680 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20680[(0)] = cljs$core$async$mix_$_state_machine__10978__auto__);

(statearr_20680[(1)] = (1));

return statearr_20680;
});
var cljs$core$async$mix_$_state_machine__10978__auto____1 = (function (state_20621){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_20621);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e20681){if((e20681 instanceof Object)){
var ex__10981__auto__ = e20681;
var statearr_20682_20731 = state_20621;
(statearr_20682_20731[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20621);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20681;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20732 = state_20621;
state_20621 = G__20732;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10978__auto__ = function(state_20621){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10978__auto____1.call(this,state_20621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10978__auto____0;
cljs$core$async$mix_$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10978__auto____1;
return cljs$core$async$mix_$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___20684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11091__auto__ = (function (){var statearr_20683 = f__11090__auto__.call(null);
(statearr_20683[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___20684);

return statearr_20683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___20684,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20733 = [];
var len__5726__auto___20736 = arguments.length;
var i__5727__auto___20737 = (0);
while(true){
if((i__5727__auto___20737 < len__5726__auto___20736)){
args20733.push((arguments[i__5727__auto___20737]));

var G__20738 = (i__5727__auto___20737 + (1));
i__5727__auto___20737 = G__20738;
continue;
} else {
}
break;
}

var G__20735 = args20733.length;
switch (G__20735) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20733.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20741 = [];
var len__5726__auto___20866 = arguments.length;
var i__5727__auto___20867 = (0);
while(true){
if((i__5727__auto___20867 < len__5726__auto___20866)){
args20741.push((arguments[i__5727__auto___20867]));

var G__20868 = (i__5727__auto___20867 + (1));
i__5727__auto___20867 = G__20868;
continue;
} else {
}
break;
}

var G__20743 = args20741.length;
switch (G__20743) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20741.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__20740_SHARP_){
if(cljs.core.truth_(p1__20740_SHARP_.call(null,topic))){
return p1__20740_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20740_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20744 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20744 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20745){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20745 = meta20745;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20746,meta20745__$1){
var self__ = this;
var _20746__$1 = this;
return (new cljs.core.async.t_cljs$core$async20744(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20745__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20746){
var self__ = this;
var _20746__$1 = this;
return self__.meta20745;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20744.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20744.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20745","meta20745",562413500,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20744.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20744.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20744";

cljs.core.async.t_cljs$core$async20744.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20744");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20744 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20744(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20745){
return (new cljs.core.async.t_cljs$core$async20744(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20745));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20744(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11089__auto___20870 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___20870,mults,ensure_mult,p){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___20870,mults,ensure_mult,p){
return (function (state_20818){
var state_val_20819 = (state_20818[(1)]);
if((state_val_20819 === (7))){
var inst_20814 = (state_20818[(2)]);
var state_20818__$1 = state_20818;
var statearr_20820_20871 = state_20818__$1;
(statearr_20820_20871[(2)] = inst_20814);

(statearr_20820_20871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (20))){
var state_20818__$1 = state_20818;
var statearr_20821_20872 = state_20818__$1;
(statearr_20821_20872[(2)] = null);

(statearr_20821_20872[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (1))){
var state_20818__$1 = state_20818;
var statearr_20822_20873 = state_20818__$1;
(statearr_20822_20873[(2)] = null);

(statearr_20822_20873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (24))){
var inst_20797 = (state_20818[(7)]);
var inst_20806 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20797);
var state_20818__$1 = state_20818;
var statearr_20823_20874 = state_20818__$1;
(statearr_20823_20874[(2)] = inst_20806);

(statearr_20823_20874[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (4))){
var inst_20749 = (state_20818[(8)]);
var inst_20749__$1 = (state_20818[(2)]);
var inst_20750 = (inst_20749__$1 == null);
var state_20818__$1 = (function (){var statearr_20824 = state_20818;
(statearr_20824[(8)] = inst_20749__$1);

return statearr_20824;
})();
if(cljs.core.truth_(inst_20750)){
var statearr_20825_20875 = state_20818__$1;
(statearr_20825_20875[(1)] = (5));

} else {
var statearr_20826_20876 = state_20818__$1;
(statearr_20826_20876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (15))){
var inst_20791 = (state_20818[(2)]);
var state_20818__$1 = state_20818;
var statearr_20827_20877 = state_20818__$1;
(statearr_20827_20877[(2)] = inst_20791);

(statearr_20827_20877[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (21))){
var inst_20811 = (state_20818[(2)]);
var state_20818__$1 = (function (){var statearr_20828 = state_20818;
(statearr_20828[(9)] = inst_20811);

return statearr_20828;
})();
var statearr_20829_20878 = state_20818__$1;
(statearr_20829_20878[(2)] = null);

(statearr_20829_20878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (13))){
var inst_20773 = (state_20818[(10)]);
var inst_20775 = cljs.core.chunked_seq_QMARK_.call(null,inst_20773);
var state_20818__$1 = state_20818;
if(inst_20775){
var statearr_20830_20879 = state_20818__$1;
(statearr_20830_20879[(1)] = (16));

} else {
var statearr_20831_20880 = state_20818__$1;
(statearr_20831_20880[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (22))){
var inst_20803 = (state_20818[(2)]);
var state_20818__$1 = state_20818;
if(cljs.core.truth_(inst_20803)){
var statearr_20832_20881 = state_20818__$1;
(statearr_20832_20881[(1)] = (23));

} else {
var statearr_20833_20882 = state_20818__$1;
(statearr_20833_20882[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (6))){
var inst_20749 = (state_20818[(8)]);
var inst_20799 = (state_20818[(11)]);
var inst_20797 = (state_20818[(7)]);
var inst_20797__$1 = topic_fn.call(null,inst_20749);
var inst_20798 = cljs.core.deref.call(null,mults);
var inst_20799__$1 = cljs.core.get.call(null,inst_20798,inst_20797__$1);
var state_20818__$1 = (function (){var statearr_20834 = state_20818;
(statearr_20834[(11)] = inst_20799__$1);

(statearr_20834[(7)] = inst_20797__$1);

return statearr_20834;
})();
if(cljs.core.truth_(inst_20799__$1)){
var statearr_20835_20883 = state_20818__$1;
(statearr_20835_20883[(1)] = (19));

} else {
var statearr_20836_20884 = state_20818__$1;
(statearr_20836_20884[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (25))){
var inst_20808 = (state_20818[(2)]);
var state_20818__$1 = state_20818;
var statearr_20837_20885 = state_20818__$1;
(statearr_20837_20885[(2)] = inst_20808);

(statearr_20837_20885[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (17))){
var inst_20773 = (state_20818[(10)]);
var inst_20782 = cljs.core.first.call(null,inst_20773);
var inst_20783 = cljs.core.async.muxch_STAR_.call(null,inst_20782);
var inst_20784 = cljs.core.async.close_BANG_.call(null,inst_20783);
var inst_20785 = cljs.core.next.call(null,inst_20773);
var inst_20759 = inst_20785;
var inst_20760 = null;
var inst_20761 = (0);
var inst_20762 = (0);
var state_20818__$1 = (function (){var statearr_20838 = state_20818;
(statearr_20838[(12)] = inst_20762);

(statearr_20838[(13)] = inst_20759);

(statearr_20838[(14)] = inst_20784);

(statearr_20838[(15)] = inst_20761);

(statearr_20838[(16)] = inst_20760);

return statearr_20838;
})();
var statearr_20839_20886 = state_20818__$1;
(statearr_20839_20886[(2)] = null);

(statearr_20839_20886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (3))){
var inst_20816 = (state_20818[(2)]);
var state_20818__$1 = state_20818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20818__$1,inst_20816);
} else {
if((state_val_20819 === (12))){
var inst_20793 = (state_20818[(2)]);
var state_20818__$1 = state_20818;
var statearr_20840_20887 = state_20818__$1;
(statearr_20840_20887[(2)] = inst_20793);

(statearr_20840_20887[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (2))){
var state_20818__$1 = state_20818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20818__$1,(4),ch);
} else {
if((state_val_20819 === (23))){
var state_20818__$1 = state_20818;
var statearr_20841_20888 = state_20818__$1;
(statearr_20841_20888[(2)] = null);

(statearr_20841_20888[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (19))){
var inst_20749 = (state_20818[(8)]);
var inst_20799 = (state_20818[(11)]);
var inst_20801 = cljs.core.async.muxch_STAR_.call(null,inst_20799);
var state_20818__$1 = state_20818;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20818__$1,(22),inst_20801,inst_20749);
} else {
if((state_val_20819 === (11))){
var inst_20773 = (state_20818[(10)]);
var inst_20759 = (state_20818[(13)]);
var inst_20773__$1 = cljs.core.seq.call(null,inst_20759);
var state_20818__$1 = (function (){var statearr_20842 = state_20818;
(statearr_20842[(10)] = inst_20773__$1);

return statearr_20842;
})();
if(inst_20773__$1){
var statearr_20843_20889 = state_20818__$1;
(statearr_20843_20889[(1)] = (13));

} else {
var statearr_20844_20890 = state_20818__$1;
(statearr_20844_20890[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (9))){
var inst_20795 = (state_20818[(2)]);
var state_20818__$1 = state_20818;
var statearr_20845_20891 = state_20818__$1;
(statearr_20845_20891[(2)] = inst_20795);

(statearr_20845_20891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (5))){
var inst_20756 = cljs.core.deref.call(null,mults);
var inst_20757 = cljs.core.vals.call(null,inst_20756);
var inst_20758 = cljs.core.seq.call(null,inst_20757);
var inst_20759 = inst_20758;
var inst_20760 = null;
var inst_20761 = (0);
var inst_20762 = (0);
var state_20818__$1 = (function (){var statearr_20846 = state_20818;
(statearr_20846[(12)] = inst_20762);

(statearr_20846[(13)] = inst_20759);

(statearr_20846[(15)] = inst_20761);

(statearr_20846[(16)] = inst_20760);

return statearr_20846;
})();
var statearr_20847_20892 = state_20818__$1;
(statearr_20847_20892[(2)] = null);

(statearr_20847_20892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (14))){
var state_20818__$1 = state_20818;
var statearr_20851_20893 = state_20818__$1;
(statearr_20851_20893[(2)] = null);

(statearr_20851_20893[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (16))){
var inst_20773 = (state_20818[(10)]);
var inst_20777 = cljs.core.chunk_first.call(null,inst_20773);
var inst_20778 = cljs.core.chunk_rest.call(null,inst_20773);
var inst_20779 = cljs.core.count.call(null,inst_20777);
var inst_20759 = inst_20778;
var inst_20760 = inst_20777;
var inst_20761 = inst_20779;
var inst_20762 = (0);
var state_20818__$1 = (function (){var statearr_20852 = state_20818;
(statearr_20852[(12)] = inst_20762);

(statearr_20852[(13)] = inst_20759);

(statearr_20852[(15)] = inst_20761);

(statearr_20852[(16)] = inst_20760);

return statearr_20852;
})();
var statearr_20853_20894 = state_20818__$1;
(statearr_20853_20894[(2)] = null);

(statearr_20853_20894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (10))){
var inst_20762 = (state_20818[(12)]);
var inst_20759 = (state_20818[(13)]);
var inst_20761 = (state_20818[(15)]);
var inst_20760 = (state_20818[(16)]);
var inst_20767 = cljs.core._nth.call(null,inst_20760,inst_20762);
var inst_20768 = cljs.core.async.muxch_STAR_.call(null,inst_20767);
var inst_20769 = cljs.core.async.close_BANG_.call(null,inst_20768);
var inst_20770 = (inst_20762 + (1));
var tmp20848 = inst_20759;
var tmp20849 = inst_20761;
var tmp20850 = inst_20760;
var inst_20759__$1 = tmp20848;
var inst_20760__$1 = tmp20850;
var inst_20761__$1 = tmp20849;
var inst_20762__$1 = inst_20770;
var state_20818__$1 = (function (){var statearr_20854 = state_20818;
(statearr_20854[(12)] = inst_20762__$1);

(statearr_20854[(13)] = inst_20759__$1);

(statearr_20854[(15)] = inst_20761__$1);

(statearr_20854[(16)] = inst_20760__$1);

(statearr_20854[(17)] = inst_20769);

return statearr_20854;
})();
var statearr_20855_20895 = state_20818__$1;
(statearr_20855_20895[(2)] = null);

(statearr_20855_20895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (18))){
var inst_20788 = (state_20818[(2)]);
var state_20818__$1 = state_20818;
var statearr_20856_20896 = state_20818__$1;
(statearr_20856_20896[(2)] = inst_20788);

(statearr_20856_20896[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20819 === (8))){
var inst_20762 = (state_20818[(12)]);
var inst_20761 = (state_20818[(15)]);
var inst_20764 = (inst_20762 < inst_20761);
var inst_20765 = inst_20764;
var state_20818__$1 = state_20818;
if(cljs.core.truth_(inst_20765)){
var statearr_20857_20897 = state_20818__$1;
(statearr_20857_20897[(1)] = (10));

} else {
var statearr_20858_20898 = state_20818__$1;
(statearr_20858_20898[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___20870,mults,ensure_mult,p))
;
return ((function (switch__10977__auto__,c__11089__auto___20870,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_20862 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20862[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_20862[(1)] = (1));

return statearr_20862;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_20818){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_20818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e20863){if((e20863 instanceof Object)){
var ex__10981__auto__ = e20863;
var statearr_20864_20899 = state_20818;
(statearr_20864_20899[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20818);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20863;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20900 = state_20818;
state_20818 = G__20900;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_20818){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_20818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___20870,mults,ensure_mult,p))
})();
var state__11091__auto__ = (function (){var statearr_20865 = f__11090__auto__.call(null);
(statearr_20865[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___20870);

return statearr_20865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___20870,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20901 = [];
var len__5726__auto___20904 = arguments.length;
var i__5727__auto___20905 = (0);
while(true){
if((i__5727__auto___20905 < len__5726__auto___20904)){
args20901.push((arguments[i__5727__auto___20905]));

var G__20906 = (i__5727__auto___20905 + (1));
i__5727__auto___20905 = G__20906;
continue;
} else {
}
break;
}

var G__20903 = args20901.length;
switch (G__20903) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20901.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20908 = [];
var len__5726__auto___20911 = arguments.length;
var i__5727__auto___20912 = (0);
while(true){
if((i__5727__auto___20912 < len__5726__auto___20911)){
args20908.push((arguments[i__5727__auto___20912]));

var G__20913 = (i__5727__auto___20912 + (1));
i__5727__auto___20912 = G__20913;
continue;
} else {
}
break;
}

var G__20910 = args20908.length;
switch (G__20910) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20908.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20915 = [];
var len__5726__auto___20986 = arguments.length;
var i__5727__auto___20987 = (0);
while(true){
if((i__5727__auto___20987 < len__5726__auto___20986)){
args20915.push((arguments[i__5727__auto___20987]));

var G__20988 = (i__5727__auto___20987 + (1));
i__5727__auto___20987 = G__20988;
continue;
} else {
}
break;
}

var G__20917 = args20915.length;
switch (G__20917) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20915.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11089__auto___20990 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___20990,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___20990,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20956){
var state_val_20957 = (state_20956[(1)]);
if((state_val_20957 === (7))){
var state_20956__$1 = state_20956;
var statearr_20958_20991 = state_20956__$1;
(statearr_20958_20991[(2)] = null);

(statearr_20958_20991[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (1))){
var state_20956__$1 = state_20956;
var statearr_20959_20992 = state_20956__$1;
(statearr_20959_20992[(2)] = null);

(statearr_20959_20992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (4))){
var inst_20920 = (state_20956[(7)]);
var inst_20922 = (inst_20920 < cnt);
var state_20956__$1 = state_20956;
if(cljs.core.truth_(inst_20922)){
var statearr_20960_20993 = state_20956__$1;
(statearr_20960_20993[(1)] = (6));

} else {
var statearr_20961_20994 = state_20956__$1;
(statearr_20961_20994[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (15))){
var inst_20952 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
var statearr_20962_20995 = state_20956__$1;
(statearr_20962_20995[(2)] = inst_20952);

(statearr_20962_20995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (13))){
var inst_20945 = cljs.core.async.close_BANG_.call(null,out);
var state_20956__$1 = state_20956;
var statearr_20963_20996 = state_20956__$1;
(statearr_20963_20996[(2)] = inst_20945);

(statearr_20963_20996[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (6))){
var state_20956__$1 = state_20956;
var statearr_20964_20997 = state_20956__$1;
(statearr_20964_20997[(2)] = null);

(statearr_20964_20997[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (3))){
var inst_20954 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20956__$1,inst_20954);
} else {
if((state_val_20957 === (12))){
var inst_20942 = (state_20956[(8)]);
var inst_20942__$1 = (state_20956[(2)]);
var inst_20943 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20942__$1);
var state_20956__$1 = (function (){var statearr_20965 = state_20956;
(statearr_20965[(8)] = inst_20942__$1);

return statearr_20965;
})();
if(cljs.core.truth_(inst_20943)){
var statearr_20966_20998 = state_20956__$1;
(statearr_20966_20998[(1)] = (13));

} else {
var statearr_20967_20999 = state_20956__$1;
(statearr_20967_20999[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (2))){
var inst_20919 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20920 = (0);
var state_20956__$1 = (function (){var statearr_20968 = state_20956;
(statearr_20968[(7)] = inst_20920);

(statearr_20968[(9)] = inst_20919);

return statearr_20968;
})();
var statearr_20969_21000 = state_20956__$1;
(statearr_20969_21000[(2)] = null);

(statearr_20969_21000[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (11))){
var inst_20920 = (state_20956[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20956,(10),Object,null,(9));
var inst_20929 = chs__$1.call(null,inst_20920);
var inst_20930 = done.call(null,inst_20920);
var inst_20931 = cljs.core.async.take_BANG_.call(null,inst_20929,inst_20930);
var state_20956__$1 = state_20956;
var statearr_20970_21001 = state_20956__$1;
(statearr_20970_21001[(2)] = inst_20931);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20956__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (9))){
var inst_20920 = (state_20956[(7)]);
var inst_20933 = (state_20956[(2)]);
var inst_20934 = (inst_20920 + (1));
var inst_20920__$1 = inst_20934;
var state_20956__$1 = (function (){var statearr_20971 = state_20956;
(statearr_20971[(7)] = inst_20920__$1);

(statearr_20971[(10)] = inst_20933);

return statearr_20971;
})();
var statearr_20972_21002 = state_20956__$1;
(statearr_20972_21002[(2)] = null);

(statearr_20972_21002[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (5))){
var inst_20940 = (state_20956[(2)]);
var state_20956__$1 = (function (){var statearr_20973 = state_20956;
(statearr_20973[(11)] = inst_20940);

return statearr_20973;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20956__$1,(12),dchan);
} else {
if((state_val_20957 === (14))){
var inst_20942 = (state_20956[(8)]);
var inst_20947 = cljs.core.apply.call(null,f,inst_20942);
var state_20956__$1 = state_20956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20956__$1,(16),out,inst_20947);
} else {
if((state_val_20957 === (16))){
var inst_20949 = (state_20956[(2)]);
var state_20956__$1 = (function (){var statearr_20974 = state_20956;
(statearr_20974[(12)] = inst_20949);

return statearr_20974;
})();
var statearr_20975_21003 = state_20956__$1;
(statearr_20975_21003[(2)] = null);

(statearr_20975_21003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (10))){
var inst_20924 = (state_20956[(2)]);
var inst_20925 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20956__$1 = (function (){var statearr_20976 = state_20956;
(statearr_20976[(13)] = inst_20924);

return statearr_20976;
})();
var statearr_20977_21004 = state_20956__$1;
(statearr_20977_21004[(2)] = inst_20925);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20956__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20957 === (8))){
var inst_20938 = (state_20956[(2)]);
var state_20956__$1 = state_20956;
var statearr_20978_21005 = state_20956__$1;
(statearr_20978_21005[(2)] = inst_20938);

(statearr_20978_21005[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___20990,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10977__auto__,c__11089__auto___20990,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_20982 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20982[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_20982[(1)] = (1));

return statearr_20982;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_20956){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_20956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e20983){if((e20983 instanceof Object)){
var ex__10981__auto__ = e20983;
var statearr_20984_21006 = state_20956;
(statearr_20984_21006[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21007 = state_20956;
state_20956 = G__21007;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_20956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_20956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___20990,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11091__auto__ = (function (){var statearr_20985 = f__11090__auto__.call(null);
(statearr_20985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___20990);

return statearr_20985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___20990,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args21009 = [];
var len__5726__auto___21065 = arguments.length;
var i__5727__auto___21066 = (0);
while(true){
if((i__5727__auto___21066 < len__5726__auto___21065)){
args21009.push((arguments[i__5727__auto___21066]));

var G__21067 = (i__5727__auto___21066 + (1));
i__5727__auto___21066 = G__21067;
continue;
} else {
}
break;
}

var G__21011 = args21009.length;
switch (G__21011) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21009.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___21069 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___21069,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___21069,out){
return (function (state_21041){
var state_val_21042 = (state_21041[(1)]);
if((state_val_21042 === (7))){
var inst_21021 = (state_21041[(7)]);
var inst_21020 = (state_21041[(8)]);
var inst_21020__$1 = (state_21041[(2)]);
var inst_21021__$1 = cljs.core.nth.call(null,inst_21020__$1,(0),null);
var inst_21022 = cljs.core.nth.call(null,inst_21020__$1,(1),null);
var inst_21023 = (inst_21021__$1 == null);
var state_21041__$1 = (function (){var statearr_21043 = state_21041;
(statearr_21043[(7)] = inst_21021__$1);

(statearr_21043[(8)] = inst_21020__$1);

(statearr_21043[(9)] = inst_21022);

return statearr_21043;
})();
if(cljs.core.truth_(inst_21023)){
var statearr_21044_21070 = state_21041__$1;
(statearr_21044_21070[(1)] = (8));

} else {
var statearr_21045_21071 = state_21041__$1;
(statearr_21045_21071[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (1))){
var inst_21012 = cljs.core.vec.call(null,chs);
var inst_21013 = inst_21012;
var state_21041__$1 = (function (){var statearr_21046 = state_21041;
(statearr_21046[(10)] = inst_21013);

return statearr_21046;
})();
var statearr_21047_21072 = state_21041__$1;
(statearr_21047_21072[(2)] = null);

(statearr_21047_21072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (4))){
var inst_21013 = (state_21041[(10)]);
var state_21041__$1 = state_21041;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21041__$1,(7),inst_21013);
} else {
if((state_val_21042 === (6))){
var inst_21037 = (state_21041[(2)]);
var state_21041__$1 = state_21041;
var statearr_21048_21073 = state_21041__$1;
(statearr_21048_21073[(2)] = inst_21037);

(statearr_21048_21073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (3))){
var inst_21039 = (state_21041[(2)]);
var state_21041__$1 = state_21041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21041__$1,inst_21039);
} else {
if((state_val_21042 === (2))){
var inst_21013 = (state_21041[(10)]);
var inst_21015 = cljs.core.count.call(null,inst_21013);
var inst_21016 = (inst_21015 > (0));
var state_21041__$1 = state_21041;
if(cljs.core.truth_(inst_21016)){
var statearr_21050_21074 = state_21041__$1;
(statearr_21050_21074[(1)] = (4));

} else {
var statearr_21051_21075 = state_21041__$1;
(statearr_21051_21075[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (11))){
var inst_21013 = (state_21041[(10)]);
var inst_21030 = (state_21041[(2)]);
var tmp21049 = inst_21013;
var inst_21013__$1 = tmp21049;
var state_21041__$1 = (function (){var statearr_21052 = state_21041;
(statearr_21052[(11)] = inst_21030);

(statearr_21052[(10)] = inst_21013__$1);

return statearr_21052;
})();
var statearr_21053_21076 = state_21041__$1;
(statearr_21053_21076[(2)] = null);

(statearr_21053_21076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (9))){
var inst_21021 = (state_21041[(7)]);
var state_21041__$1 = state_21041;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21041__$1,(11),out,inst_21021);
} else {
if((state_val_21042 === (5))){
var inst_21035 = cljs.core.async.close_BANG_.call(null,out);
var state_21041__$1 = state_21041;
var statearr_21054_21077 = state_21041__$1;
(statearr_21054_21077[(2)] = inst_21035);

(statearr_21054_21077[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (10))){
var inst_21033 = (state_21041[(2)]);
var state_21041__$1 = state_21041;
var statearr_21055_21078 = state_21041__$1;
(statearr_21055_21078[(2)] = inst_21033);

(statearr_21055_21078[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21042 === (8))){
var inst_21021 = (state_21041[(7)]);
var inst_21020 = (state_21041[(8)]);
var inst_21022 = (state_21041[(9)]);
var inst_21013 = (state_21041[(10)]);
var inst_21025 = (function (){var cs = inst_21013;
var vec__21018 = inst_21020;
var v = inst_21021;
var c = inst_21022;
return ((function (cs,vec__21018,v,c,inst_21021,inst_21020,inst_21022,inst_21013,state_val_21042,c__11089__auto___21069,out){
return (function (p1__21008_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__21008_SHARP_);
});
;})(cs,vec__21018,v,c,inst_21021,inst_21020,inst_21022,inst_21013,state_val_21042,c__11089__auto___21069,out))
})();
var inst_21026 = cljs.core.filterv.call(null,inst_21025,inst_21013);
var inst_21013__$1 = inst_21026;
var state_21041__$1 = (function (){var statearr_21056 = state_21041;
(statearr_21056[(10)] = inst_21013__$1);

return statearr_21056;
})();
var statearr_21057_21079 = state_21041__$1;
(statearr_21057_21079[(2)] = null);

(statearr_21057_21079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___21069,out))
;
return ((function (switch__10977__auto__,c__11089__auto___21069,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_21061 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21061[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_21061[(1)] = (1));

return statearr_21061;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_21041){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_21041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e21062){if((e21062 instanceof Object)){
var ex__10981__auto__ = e21062;
var statearr_21063_21080 = state_21041;
(statearr_21063_21080[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21041);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21062;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21081 = state_21041;
state_21041 = G__21081;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_21041){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_21041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___21069,out))
})();
var state__11091__auto__ = (function (){var statearr_21064 = f__11090__auto__.call(null);
(statearr_21064[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___21069);

return statearr_21064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___21069,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args21082 = [];
var len__5726__auto___21131 = arguments.length;
var i__5727__auto___21132 = (0);
while(true){
if((i__5727__auto___21132 < len__5726__auto___21131)){
args21082.push((arguments[i__5727__auto___21132]));

var G__21133 = (i__5727__auto___21132 + (1));
i__5727__auto___21132 = G__21133;
continue;
} else {
}
break;
}

var G__21084 = args21082.length;
switch (G__21084) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21082.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___21135 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___21135,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___21135,out){
return (function (state_21108){
var state_val_21109 = (state_21108[(1)]);
if((state_val_21109 === (7))){
var inst_21090 = (state_21108[(7)]);
var inst_21090__$1 = (state_21108[(2)]);
var inst_21091 = (inst_21090__$1 == null);
var inst_21092 = cljs.core.not.call(null,inst_21091);
var state_21108__$1 = (function (){var statearr_21110 = state_21108;
(statearr_21110[(7)] = inst_21090__$1);

return statearr_21110;
})();
if(inst_21092){
var statearr_21111_21136 = state_21108__$1;
(statearr_21111_21136[(1)] = (8));

} else {
var statearr_21112_21137 = state_21108__$1;
(statearr_21112_21137[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21109 === (1))){
var inst_21085 = (0);
var state_21108__$1 = (function (){var statearr_21113 = state_21108;
(statearr_21113[(8)] = inst_21085);

return statearr_21113;
})();
var statearr_21114_21138 = state_21108__$1;
(statearr_21114_21138[(2)] = null);

(statearr_21114_21138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21109 === (4))){
var state_21108__$1 = state_21108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21108__$1,(7),ch);
} else {
if((state_val_21109 === (6))){
var inst_21103 = (state_21108[(2)]);
var state_21108__$1 = state_21108;
var statearr_21115_21139 = state_21108__$1;
(statearr_21115_21139[(2)] = inst_21103);

(statearr_21115_21139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21109 === (3))){
var inst_21105 = (state_21108[(2)]);
var inst_21106 = cljs.core.async.close_BANG_.call(null,out);
var state_21108__$1 = (function (){var statearr_21116 = state_21108;
(statearr_21116[(9)] = inst_21105);

return statearr_21116;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21108__$1,inst_21106);
} else {
if((state_val_21109 === (2))){
var inst_21085 = (state_21108[(8)]);
var inst_21087 = (inst_21085 < n);
var state_21108__$1 = state_21108;
if(cljs.core.truth_(inst_21087)){
var statearr_21117_21140 = state_21108__$1;
(statearr_21117_21140[(1)] = (4));

} else {
var statearr_21118_21141 = state_21108__$1;
(statearr_21118_21141[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21109 === (11))){
var inst_21085 = (state_21108[(8)]);
var inst_21095 = (state_21108[(2)]);
var inst_21096 = (inst_21085 + (1));
var inst_21085__$1 = inst_21096;
var state_21108__$1 = (function (){var statearr_21119 = state_21108;
(statearr_21119[(8)] = inst_21085__$1);

(statearr_21119[(10)] = inst_21095);

return statearr_21119;
})();
var statearr_21120_21142 = state_21108__$1;
(statearr_21120_21142[(2)] = null);

(statearr_21120_21142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21109 === (9))){
var state_21108__$1 = state_21108;
var statearr_21121_21143 = state_21108__$1;
(statearr_21121_21143[(2)] = null);

(statearr_21121_21143[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21109 === (5))){
var state_21108__$1 = state_21108;
var statearr_21122_21144 = state_21108__$1;
(statearr_21122_21144[(2)] = null);

(statearr_21122_21144[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21109 === (10))){
var inst_21100 = (state_21108[(2)]);
var state_21108__$1 = state_21108;
var statearr_21123_21145 = state_21108__$1;
(statearr_21123_21145[(2)] = inst_21100);

(statearr_21123_21145[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21109 === (8))){
var inst_21090 = (state_21108[(7)]);
var state_21108__$1 = state_21108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21108__$1,(11),out,inst_21090);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___21135,out))
;
return ((function (switch__10977__auto__,c__11089__auto___21135,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_21127 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21127[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_21127[(1)] = (1));

return statearr_21127;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_21108){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_21108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e21128){if((e21128 instanceof Object)){
var ex__10981__auto__ = e21128;
var statearr_21129_21146 = state_21108;
(statearr_21129_21146[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21108);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21128;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21147 = state_21108;
state_21108 = G__21147;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_21108){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_21108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___21135,out))
})();
var state__11091__auto__ = (function (){var statearr_21130 = f__11090__auto__.call(null);
(statearr_21130[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___21135);

return statearr_21130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___21135,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21155 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21155 = (function (map_LT_,f,ch,meta21156){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21156 = meta21156;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21157,meta21156__$1){
var self__ = this;
var _21157__$1 = this;
return (new cljs.core.async.t_cljs$core$async21155(self__.map_LT_,self__.f,self__.ch,meta21156__$1));
});

cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21157){
var self__ = this;
var _21157__$1 = this;
return self__.meta21156;
});

cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21158 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21158 = (function (map_LT_,f,ch,meta21156,_,fn1,meta21159){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21156 = meta21156;
this._ = _;
this.fn1 = fn1;
this.meta21159 = meta21159;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21158.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21160,meta21159__$1){
var self__ = this;
var _21160__$1 = this;
return (new cljs.core.async.t_cljs$core$async21158(self__.map_LT_,self__.f,self__.ch,self__.meta21156,self__._,self__.fn1,meta21159__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21158.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21160){
var self__ = this;
var _21160__$1 = this;
return self__.meta21159;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21158.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21158.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21158.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21158.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21148_SHARP_){
return f1.call(null,(((p1__21148_SHARP_ == null))?null:self__.f.call(null,p1__21148_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21158.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21156","meta21156",1900674276,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21155","cljs.core.async/t_cljs$core$async21155",792699987,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21159","meta21159",343196357,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21158.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21158.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21158";

cljs.core.async.t_cljs$core$async21158.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21158");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21158 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21158(map_LT___$1,f__$1,ch__$1,meta21156__$1,___$2,fn1__$1,meta21159){
return (new cljs.core.async.t_cljs$core$async21158(map_LT___$1,f__$1,ch__$1,meta21156__$1,___$2,fn1__$1,meta21159));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21158(self__.map_LT_,self__.f,self__.ch,self__.meta21156,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21155.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21155.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21156","meta21156",1900674276,null)], null);
});

cljs.core.async.t_cljs$core$async21155.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21155.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21155";

cljs.core.async.t_cljs$core$async21155.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21155");
});

cljs.core.async.__GT_t_cljs$core$async21155 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21155(map_LT___$1,f__$1,ch__$1,meta21156){
return (new cljs.core.async.t_cljs$core$async21155(map_LT___$1,f__$1,ch__$1,meta21156));
});

}

return (new cljs.core.async.t_cljs$core$async21155(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21164 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21164 = (function (map_GT_,f,ch,meta21165){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21165 = meta21165;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21164.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21166,meta21165__$1){
var self__ = this;
var _21166__$1 = this;
return (new cljs.core.async.t_cljs$core$async21164(self__.map_GT_,self__.f,self__.ch,meta21165__$1));
});

cljs.core.async.t_cljs$core$async21164.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21166){
var self__ = this;
var _21166__$1 = this;
return self__.meta21165;
});

cljs.core.async.t_cljs$core$async21164.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21164.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21164.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21164.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21164.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21164.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21164.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21165","meta21165",809373433,null)], null);
});

cljs.core.async.t_cljs$core$async21164.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21164.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21164";

cljs.core.async.t_cljs$core$async21164.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21164");
});

cljs.core.async.__GT_t_cljs$core$async21164 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21164(map_GT___$1,f__$1,ch__$1,meta21165){
return (new cljs.core.async.t_cljs$core$async21164(map_GT___$1,f__$1,ch__$1,meta21165));
});

}

return (new cljs.core.async.t_cljs$core$async21164(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21170 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21170 = (function (filter_GT_,p,ch,meta21171){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21171 = meta21171;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21172,meta21171__$1){
var self__ = this;
var _21172__$1 = this;
return (new cljs.core.async.t_cljs$core$async21170(self__.filter_GT_,self__.p,self__.ch,meta21171__$1));
});

cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21172){
var self__ = this;
var _21172__$1 = this;
return self__.meta21171;
});

cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21170.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21170.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21171","meta21171",117233913,null)], null);
});

cljs.core.async.t_cljs$core$async21170.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21170.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21170";

cljs.core.async.t_cljs$core$async21170.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21170");
});

cljs.core.async.__GT_t_cljs$core$async21170 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21170(filter_GT___$1,p__$1,ch__$1,meta21171){
return (new cljs.core.async.t_cljs$core$async21170(filter_GT___$1,p__$1,ch__$1,meta21171));
});

}

return (new cljs.core.async.t_cljs$core$async21170(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21173 = [];
var len__5726__auto___21217 = arguments.length;
var i__5727__auto___21218 = (0);
while(true){
if((i__5727__auto___21218 < len__5726__auto___21217)){
args21173.push((arguments[i__5727__auto___21218]));

var G__21219 = (i__5727__auto___21218 + (1));
i__5727__auto___21218 = G__21219;
continue;
} else {
}
break;
}

var G__21175 = args21173.length;
switch (G__21175) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21173.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___21221 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___21221,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___21221,out){
return (function (state_21196){
var state_val_21197 = (state_21196[(1)]);
if((state_val_21197 === (7))){
var inst_21192 = (state_21196[(2)]);
var state_21196__$1 = state_21196;
var statearr_21198_21222 = state_21196__$1;
(statearr_21198_21222[(2)] = inst_21192);

(statearr_21198_21222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (1))){
var state_21196__$1 = state_21196;
var statearr_21199_21223 = state_21196__$1;
(statearr_21199_21223[(2)] = null);

(statearr_21199_21223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (4))){
var inst_21178 = (state_21196[(7)]);
var inst_21178__$1 = (state_21196[(2)]);
var inst_21179 = (inst_21178__$1 == null);
var state_21196__$1 = (function (){var statearr_21200 = state_21196;
(statearr_21200[(7)] = inst_21178__$1);

return statearr_21200;
})();
if(cljs.core.truth_(inst_21179)){
var statearr_21201_21224 = state_21196__$1;
(statearr_21201_21224[(1)] = (5));

} else {
var statearr_21202_21225 = state_21196__$1;
(statearr_21202_21225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (6))){
var inst_21178 = (state_21196[(7)]);
var inst_21183 = p.call(null,inst_21178);
var state_21196__$1 = state_21196;
if(cljs.core.truth_(inst_21183)){
var statearr_21203_21226 = state_21196__$1;
(statearr_21203_21226[(1)] = (8));

} else {
var statearr_21204_21227 = state_21196__$1;
(statearr_21204_21227[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (3))){
var inst_21194 = (state_21196[(2)]);
var state_21196__$1 = state_21196;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21196__$1,inst_21194);
} else {
if((state_val_21197 === (2))){
var state_21196__$1 = state_21196;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21196__$1,(4),ch);
} else {
if((state_val_21197 === (11))){
var inst_21186 = (state_21196[(2)]);
var state_21196__$1 = state_21196;
var statearr_21205_21228 = state_21196__$1;
(statearr_21205_21228[(2)] = inst_21186);

(statearr_21205_21228[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (9))){
var state_21196__$1 = state_21196;
var statearr_21206_21229 = state_21196__$1;
(statearr_21206_21229[(2)] = null);

(statearr_21206_21229[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (5))){
var inst_21181 = cljs.core.async.close_BANG_.call(null,out);
var state_21196__$1 = state_21196;
var statearr_21207_21230 = state_21196__$1;
(statearr_21207_21230[(2)] = inst_21181);

(statearr_21207_21230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (10))){
var inst_21189 = (state_21196[(2)]);
var state_21196__$1 = (function (){var statearr_21208 = state_21196;
(statearr_21208[(8)] = inst_21189);

return statearr_21208;
})();
var statearr_21209_21231 = state_21196__$1;
(statearr_21209_21231[(2)] = null);

(statearr_21209_21231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21197 === (8))){
var inst_21178 = (state_21196[(7)]);
var state_21196__$1 = state_21196;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21196__$1,(11),out,inst_21178);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___21221,out))
;
return ((function (switch__10977__auto__,c__11089__auto___21221,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_21213 = [null,null,null,null,null,null,null,null,null];
(statearr_21213[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_21213[(1)] = (1));

return statearr_21213;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_21196){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_21196);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e21214){if((e21214 instanceof Object)){
var ex__10981__auto__ = e21214;
var statearr_21215_21232 = state_21196;
(statearr_21215_21232[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21196);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21214;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21233 = state_21196;
state_21196 = G__21233;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_21196){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_21196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___21221,out))
})();
var state__11091__auto__ = (function (){var statearr_21216 = f__11090__auto__.call(null);
(statearr_21216[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___21221);

return statearr_21216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___21221,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21234 = [];
var len__5726__auto___21237 = arguments.length;
var i__5727__auto___21238 = (0);
while(true){
if((i__5727__auto___21238 < len__5726__auto___21237)){
args21234.push((arguments[i__5727__auto___21238]));

var G__21239 = (i__5727__auto___21238 + (1));
i__5727__auto___21238 = G__21239;
continue;
} else {
}
break;
}

var G__21236 = args21234.length;
switch (G__21236) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21234.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11089__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto__){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto__){
return (function (state_21406){
var state_val_21407 = (state_21406[(1)]);
if((state_val_21407 === (7))){
var inst_21402 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
var statearr_21408_21449 = state_21406__$1;
(statearr_21408_21449[(2)] = inst_21402);

(statearr_21408_21449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (20))){
var inst_21372 = (state_21406[(7)]);
var inst_21383 = (state_21406[(2)]);
var inst_21384 = cljs.core.next.call(null,inst_21372);
var inst_21358 = inst_21384;
var inst_21359 = null;
var inst_21360 = (0);
var inst_21361 = (0);
var state_21406__$1 = (function (){var statearr_21409 = state_21406;
(statearr_21409[(8)] = inst_21359);

(statearr_21409[(9)] = inst_21358);

(statearr_21409[(10)] = inst_21360);

(statearr_21409[(11)] = inst_21361);

(statearr_21409[(12)] = inst_21383);

return statearr_21409;
})();
var statearr_21410_21450 = state_21406__$1;
(statearr_21410_21450[(2)] = null);

(statearr_21410_21450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (1))){
var state_21406__$1 = state_21406;
var statearr_21411_21451 = state_21406__$1;
(statearr_21411_21451[(2)] = null);

(statearr_21411_21451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (4))){
var inst_21347 = (state_21406[(13)]);
var inst_21347__$1 = (state_21406[(2)]);
var inst_21348 = (inst_21347__$1 == null);
var state_21406__$1 = (function (){var statearr_21412 = state_21406;
(statearr_21412[(13)] = inst_21347__$1);

return statearr_21412;
})();
if(cljs.core.truth_(inst_21348)){
var statearr_21413_21452 = state_21406__$1;
(statearr_21413_21452[(1)] = (5));

} else {
var statearr_21414_21453 = state_21406__$1;
(statearr_21414_21453[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (15))){
var state_21406__$1 = state_21406;
var statearr_21418_21454 = state_21406__$1;
(statearr_21418_21454[(2)] = null);

(statearr_21418_21454[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (21))){
var state_21406__$1 = state_21406;
var statearr_21419_21455 = state_21406__$1;
(statearr_21419_21455[(2)] = null);

(statearr_21419_21455[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (13))){
var inst_21359 = (state_21406[(8)]);
var inst_21358 = (state_21406[(9)]);
var inst_21360 = (state_21406[(10)]);
var inst_21361 = (state_21406[(11)]);
var inst_21368 = (state_21406[(2)]);
var inst_21369 = (inst_21361 + (1));
var tmp21415 = inst_21359;
var tmp21416 = inst_21358;
var tmp21417 = inst_21360;
var inst_21358__$1 = tmp21416;
var inst_21359__$1 = tmp21415;
var inst_21360__$1 = tmp21417;
var inst_21361__$1 = inst_21369;
var state_21406__$1 = (function (){var statearr_21420 = state_21406;
(statearr_21420[(8)] = inst_21359__$1);

(statearr_21420[(9)] = inst_21358__$1);

(statearr_21420[(10)] = inst_21360__$1);

(statearr_21420[(14)] = inst_21368);

(statearr_21420[(11)] = inst_21361__$1);

return statearr_21420;
})();
var statearr_21421_21456 = state_21406__$1;
(statearr_21421_21456[(2)] = null);

(statearr_21421_21456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (22))){
var state_21406__$1 = state_21406;
var statearr_21422_21457 = state_21406__$1;
(statearr_21422_21457[(2)] = null);

(statearr_21422_21457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (6))){
var inst_21347 = (state_21406[(13)]);
var inst_21356 = f.call(null,inst_21347);
var inst_21357 = cljs.core.seq.call(null,inst_21356);
var inst_21358 = inst_21357;
var inst_21359 = null;
var inst_21360 = (0);
var inst_21361 = (0);
var state_21406__$1 = (function (){var statearr_21423 = state_21406;
(statearr_21423[(8)] = inst_21359);

(statearr_21423[(9)] = inst_21358);

(statearr_21423[(10)] = inst_21360);

(statearr_21423[(11)] = inst_21361);

return statearr_21423;
})();
var statearr_21424_21458 = state_21406__$1;
(statearr_21424_21458[(2)] = null);

(statearr_21424_21458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (17))){
var inst_21372 = (state_21406[(7)]);
var inst_21376 = cljs.core.chunk_first.call(null,inst_21372);
var inst_21377 = cljs.core.chunk_rest.call(null,inst_21372);
var inst_21378 = cljs.core.count.call(null,inst_21376);
var inst_21358 = inst_21377;
var inst_21359 = inst_21376;
var inst_21360 = inst_21378;
var inst_21361 = (0);
var state_21406__$1 = (function (){var statearr_21425 = state_21406;
(statearr_21425[(8)] = inst_21359);

(statearr_21425[(9)] = inst_21358);

(statearr_21425[(10)] = inst_21360);

(statearr_21425[(11)] = inst_21361);

return statearr_21425;
})();
var statearr_21426_21459 = state_21406__$1;
(statearr_21426_21459[(2)] = null);

(statearr_21426_21459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (3))){
var inst_21404 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21406__$1,inst_21404);
} else {
if((state_val_21407 === (12))){
var inst_21392 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
var statearr_21427_21460 = state_21406__$1;
(statearr_21427_21460[(2)] = inst_21392);

(statearr_21427_21460[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (2))){
var state_21406__$1 = state_21406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21406__$1,(4),in$);
} else {
if((state_val_21407 === (23))){
var inst_21400 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
var statearr_21428_21461 = state_21406__$1;
(statearr_21428_21461[(2)] = inst_21400);

(statearr_21428_21461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (19))){
var inst_21387 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
var statearr_21429_21462 = state_21406__$1;
(statearr_21429_21462[(2)] = inst_21387);

(statearr_21429_21462[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (11))){
var inst_21372 = (state_21406[(7)]);
var inst_21358 = (state_21406[(9)]);
var inst_21372__$1 = cljs.core.seq.call(null,inst_21358);
var state_21406__$1 = (function (){var statearr_21430 = state_21406;
(statearr_21430[(7)] = inst_21372__$1);

return statearr_21430;
})();
if(inst_21372__$1){
var statearr_21431_21463 = state_21406__$1;
(statearr_21431_21463[(1)] = (14));

} else {
var statearr_21432_21464 = state_21406__$1;
(statearr_21432_21464[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (9))){
var inst_21394 = (state_21406[(2)]);
var inst_21395 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21406__$1 = (function (){var statearr_21433 = state_21406;
(statearr_21433[(15)] = inst_21394);

return statearr_21433;
})();
if(cljs.core.truth_(inst_21395)){
var statearr_21434_21465 = state_21406__$1;
(statearr_21434_21465[(1)] = (21));

} else {
var statearr_21435_21466 = state_21406__$1;
(statearr_21435_21466[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (5))){
var inst_21350 = cljs.core.async.close_BANG_.call(null,out);
var state_21406__$1 = state_21406;
var statearr_21436_21467 = state_21406__$1;
(statearr_21436_21467[(2)] = inst_21350);

(statearr_21436_21467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (14))){
var inst_21372 = (state_21406[(7)]);
var inst_21374 = cljs.core.chunked_seq_QMARK_.call(null,inst_21372);
var state_21406__$1 = state_21406;
if(inst_21374){
var statearr_21437_21468 = state_21406__$1;
(statearr_21437_21468[(1)] = (17));

} else {
var statearr_21438_21469 = state_21406__$1;
(statearr_21438_21469[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (16))){
var inst_21390 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
var statearr_21439_21470 = state_21406__$1;
(statearr_21439_21470[(2)] = inst_21390);

(statearr_21439_21470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (10))){
var inst_21359 = (state_21406[(8)]);
var inst_21361 = (state_21406[(11)]);
var inst_21366 = cljs.core._nth.call(null,inst_21359,inst_21361);
var state_21406__$1 = state_21406;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21406__$1,(13),out,inst_21366);
} else {
if((state_val_21407 === (18))){
var inst_21372 = (state_21406[(7)]);
var inst_21381 = cljs.core.first.call(null,inst_21372);
var state_21406__$1 = state_21406;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21406__$1,(20),out,inst_21381);
} else {
if((state_val_21407 === (8))){
var inst_21360 = (state_21406[(10)]);
var inst_21361 = (state_21406[(11)]);
var inst_21363 = (inst_21361 < inst_21360);
var inst_21364 = inst_21363;
var state_21406__$1 = state_21406;
if(cljs.core.truth_(inst_21364)){
var statearr_21440_21471 = state_21406__$1;
(statearr_21440_21471[(1)] = (10));

} else {
var statearr_21441_21472 = state_21406__$1;
(statearr_21441_21472[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto__))
;
return ((function (switch__10977__auto__,c__11089__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____0 = (function (){
var statearr_21445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21445[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__);

(statearr_21445[(1)] = (1));

return statearr_21445;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____1 = (function (state_21406){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_21406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e21446){if((e21446 instanceof Object)){
var ex__10981__auto__ = e21446;
var statearr_21447_21473 = state_21406;
(statearr_21447_21473[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21406);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21474 = state_21406;
state_21406 = G__21474;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__ = function(state_21406){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____1.call(this,state_21406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10978__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto__))
})();
var state__11091__auto__ = (function (){var statearr_21448 = f__11090__auto__.call(null);
(statearr_21448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto__);

return statearr_21448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto__))
);

return c__11089__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21475 = [];
var len__5726__auto___21478 = arguments.length;
var i__5727__auto___21479 = (0);
while(true){
if((i__5727__auto___21479 < len__5726__auto___21478)){
args21475.push((arguments[i__5727__auto___21479]));

var G__21480 = (i__5727__auto___21479 + (1));
i__5727__auto___21479 = G__21480;
continue;
} else {
}
break;
}

var G__21477 = args21475.length;
switch (G__21477) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21475.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21482 = [];
var len__5726__auto___21485 = arguments.length;
var i__5727__auto___21486 = (0);
while(true){
if((i__5727__auto___21486 < len__5726__auto___21485)){
args21482.push((arguments[i__5727__auto___21486]));

var G__21487 = (i__5727__auto___21486 + (1));
i__5727__auto___21486 = G__21487;
continue;
} else {
}
break;
}

var G__21484 = args21482.length;
switch (G__21484) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21482.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21489 = [];
var len__5726__auto___21540 = arguments.length;
var i__5727__auto___21541 = (0);
while(true){
if((i__5727__auto___21541 < len__5726__auto___21540)){
args21489.push((arguments[i__5727__auto___21541]));

var G__21542 = (i__5727__auto___21541 + (1));
i__5727__auto___21541 = G__21542;
continue;
} else {
}
break;
}

var G__21491 = args21489.length;
switch (G__21491) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21489.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___21544 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___21544,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___21544,out){
return (function (state_21515){
var state_val_21516 = (state_21515[(1)]);
if((state_val_21516 === (7))){
var inst_21510 = (state_21515[(2)]);
var state_21515__$1 = state_21515;
var statearr_21517_21545 = state_21515__$1;
(statearr_21517_21545[(2)] = inst_21510);

(statearr_21517_21545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21516 === (1))){
var inst_21492 = null;
var state_21515__$1 = (function (){var statearr_21518 = state_21515;
(statearr_21518[(7)] = inst_21492);

return statearr_21518;
})();
var statearr_21519_21546 = state_21515__$1;
(statearr_21519_21546[(2)] = null);

(statearr_21519_21546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21516 === (4))){
var inst_21495 = (state_21515[(8)]);
var inst_21495__$1 = (state_21515[(2)]);
var inst_21496 = (inst_21495__$1 == null);
var inst_21497 = cljs.core.not.call(null,inst_21496);
var state_21515__$1 = (function (){var statearr_21520 = state_21515;
(statearr_21520[(8)] = inst_21495__$1);

return statearr_21520;
})();
if(inst_21497){
var statearr_21521_21547 = state_21515__$1;
(statearr_21521_21547[(1)] = (5));

} else {
var statearr_21522_21548 = state_21515__$1;
(statearr_21522_21548[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21516 === (6))){
var state_21515__$1 = state_21515;
var statearr_21523_21549 = state_21515__$1;
(statearr_21523_21549[(2)] = null);

(statearr_21523_21549[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21516 === (3))){
var inst_21512 = (state_21515[(2)]);
var inst_21513 = cljs.core.async.close_BANG_.call(null,out);
var state_21515__$1 = (function (){var statearr_21524 = state_21515;
(statearr_21524[(9)] = inst_21512);

return statearr_21524;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21515__$1,inst_21513);
} else {
if((state_val_21516 === (2))){
var state_21515__$1 = state_21515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21515__$1,(4),ch);
} else {
if((state_val_21516 === (11))){
var inst_21495 = (state_21515[(8)]);
var inst_21504 = (state_21515[(2)]);
var inst_21492 = inst_21495;
var state_21515__$1 = (function (){var statearr_21525 = state_21515;
(statearr_21525[(10)] = inst_21504);

(statearr_21525[(7)] = inst_21492);

return statearr_21525;
})();
var statearr_21526_21550 = state_21515__$1;
(statearr_21526_21550[(2)] = null);

(statearr_21526_21550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21516 === (9))){
var inst_21495 = (state_21515[(8)]);
var state_21515__$1 = state_21515;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21515__$1,(11),out,inst_21495);
} else {
if((state_val_21516 === (5))){
var inst_21495 = (state_21515[(8)]);
var inst_21492 = (state_21515[(7)]);
var inst_21499 = cljs.core._EQ_.call(null,inst_21495,inst_21492);
var state_21515__$1 = state_21515;
if(inst_21499){
var statearr_21528_21551 = state_21515__$1;
(statearr_21528_21551[(1)] = (8));

} else {
var statearr_21529_21552 = state_21515__$1;
(statearr_21529_21552[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21516 === (10))){
var inst_21507 = (state_21515[(2)]);
var state_21515__$1 = state_21515;
var statearr_21530_21553 = state_21515__$1;
(statearr_21530_21553[(2)] = inst_21507);

(statearr_21530_21553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21516 === (8))){
var inst_21492 = (state_21515[(7)]);
var tmp21527 = inst_21492;
var inst_21492__$1 = tmp21527;
var state_21515__$1 = (function (){var statearr_21531 = state_21515;
(statearr_21531[(7)] = inst_21492__$1);

return statearr_21531;
})();
var statearr_21532_21554 = state_21515__$1;
(statearr_21532_21554[(2)] = null);

(statearr_21532_21554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___21544,out))
;
return ((function (switch__10977__auto__,c__11089__auto___21544,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_21536 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21536[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_21536[(1)] = (1));

return statearr_21536;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_21515){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_21515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e21537){if((e21537 instanceof Object)){
var ex__10981__auto__ = e21537;
var statearr_21538_21555 = state_21515;
(statearr_21538_21555[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21515);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21556 = state_21515;
state_21515 = G__21556;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_21515){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_21515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___21544,out))
})();
var state__11091__auto__ = (function (){var statearr_21539 = f__11090__auto__.call(null);
(statearr_21539[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___21544);

return statearr_21539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___21544,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21557 = [];
var len__5726__auto___21627 = arguments.length;
var i__5727__auto___21628 = (0);
while(true){
if((i__5727__auto___21628 < len__5726__auto___21627)){
args21557.push((arguments[i__5727__auto___21628]));

var G__21629 = (i__5727__auto___21628 + (1));
i__5727__auto___21628 = G__21629;
continue;
} else {
}
break;
}

var G__21559 = args21557.length;
switch (G__21559) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21557.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___21631 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___21631,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___21631,out){
return (function (state_21597){
var state_val_21598 = (state_21597[(1)]);
if((state_val_21598 === (7))){
var inst_21593 = (state_21597[(2)]);
var state_21597__$1 = state_21597;
var statearr_21599_21632 = state_21597__$1;
(statearr_21599_21632[(2)] = inst_21593);

(statearr_21599_21632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (1))){
var inst_21560 = (new Array(n));
var inst_21561 = inst_21560;
var inst_21562 = (0);
var state_21597__$1 = (function (){var statearr_21600 = state_21597;
(statearr_21600[(7)] = inst_21562);

(statearr_21600[(8)] = inst_21561);

return statearr_21600;
})();
var statearr_21601_21633 = state_21597__$1;
(statearr_21601_21633[(2)] = null);

(statearr_21601_21633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (4))){
var inst_21565 = (state_21597[(9)]);
var inst_21565__$1 = (state_21597[(2)]);
var inst_21566 = (inst_21565__$1 == null);
var inst_21567 = cljs.core.not.call(null,inst_21566);
var state_21597__$1 = (function (){var statearr_21602 = state_21597;
(statearr_21602[(9)] = inst_21565__$1);

return statearr_21602;
})();
if(inst_21567){
var statearr_21603_21634 = state_21597__$1;
(statearr_21603_21634[(1)] = (5));

} else {
var statearr_21604_21635 = state_21597__$1;
(statearr_21604_21635[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (15))){
var inst_21587 = (state_21597[(2)]);
var state_21597__$1 = state_21597;
var statearr_21605_21636 = state_21597__$1;
(statearr_21605_21636[(2)] = inst_21587);

(statearr_21605_21636[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (13))){
var state_21597__$1 = state_21597;
var statearr_21606_21637 = state_21597__$1;
(statearr_21606_21637[(2)] = null);

(statearr_21606_21637[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (6))){
var inst_21562 = (state_21597[(7)]);
var inst_21583 = (inst_21562 > (0));
var state_21597__$1 = state_21597;
if(cljs.core.truth_(inst_21583)){
var statearr_21607_21638 = state_21597__$1;
(statearr_21607_21638[(1)] = (12));

} else {
var statearr_21608_21639 = state_21597__$1;
(statearr_21608_21639[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (3))){
var inst_21595 = (state_21597[(2)]);
var state_21597__$1 = state_21597;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21597__$1,inst_21595);
} else {
if((state_val_21598 === (12))){
var inst_21561 = (state_21597[(8)]);
var inst_21585 = cljs.core.vec.call(null,inst_21561);
var state_21597__$1 = state_21597;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21597__$1,(15),out,inst_21585);
} else {
if((state_val_21598 === (2))){
var state_21597__$1 = state_21597;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21597__$1,(4),ch);
} else {
if((state_val_21598 === (11))){
var inst_21577 = (state_21597[(2)]);
var inst_21578 = (new Array(n));
var inst_21561 = inst_21578;
var inst_21562 = (0);
var state_21597__$1 = (function (){var statearr_21609 = state_21597;
(statearr_21609[(7)] = inst_21562);

(statearr_21609[(8)] = inst_21561);

(statearr_21609[(10)] = inst_21577);

return statearr_21609;
})();
var statearr_21610_21640 = state_21597__$1;
(statearr_21610_21640[(2)] = null);

(statearr_21610_21640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (9))){
var inst_21561 = (state_21597[(8)]);
var inst_21575 = cljs.core.vec.call(null,inst_21561);
var state_21597__$1 = state_21597;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21597__$1,(11),out,inst_21575);
} else {
if((state_val_21598 === (5))){
var inst_21562 = (state_21597[(7)]);
var inst_21565 = (state_21597[(9)]);
var inst_21561 = (state_21597[(8)]);
var inst_21570 = (state_21597[(11)]);
var inst_21569 = (inst_21561[inst_21562] = inst_21565);
var inst_21570__$1 = (inst_21562 + (1));
var inst_21571 = (inst_21570__$1 < n);
var state_21597__$1 = (function (){var statearr_21611 = state_21597;
(statearr_21611[(12)] = inst_21569);

(statearr_21611[(11)] = inst_21570__$1);

return statearr_21611;
})();
if(cljs.core.truth_(inst_21571)){
var statearr_21612_21641 = state_21597__$1;
(statearr_21612_21641[(1)] = (8));

} else {
var statearr_21613_21642 = state_21597__$1;
(statearr_21613_21642[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (14))){
var inst_21590 = (state_21597[(2)]);
var inst_21591 = cljs.core.async.close_BANG_.call(null,out);
var state_21597__$1 = (function (){var statearr_21615 = state_21597;
(statearr_21615[(13)] = inst_21590);

return statearr_21615;
})();
var statearr_21616_21643 = state_21597__$1;
(statearr_21616_21643[(2)] = inst_21591);

(statearr_21616_21643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (10))){
var inst_21581 = (state_21597[(2)]);
var state_21597__$1 = state_21597;
var statearr_21617_21644 = state_21597__$1;
(statearr_21617_21644[(2)] = inst_21581);

(statearr_21617_21644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21598 === (8))){
var inst_21561 = (state_21597[(8)]);
var inst_21570 = (state_21597[(11)]);
var tmp21614 = inst_21561;
var inst_21561__$1 = tmp21614;
var inst_21562 = inst_21570;
var state_21597__$1 = (function (){var statearr_21618 = state_21597;
(statearr_21618[(7)] = inst_21562);

(statearr_21618[(8)] = inst_21561__$1);

return statearr_21618;
})();
var statearr_21619_21645 = state_21597__$1;
(statearr_21619_21645[(2)] = null);

(statearr_21619_21645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___21631,out))
;
return ((function (switch__10977__auto__,c__11089__auto___21631,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_21623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21623[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_21623[(1)] = (1));

return statearr_21623;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_21597){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_21597);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e21624){if((e21624 instanceof Object)){
var ex__10981__auto__ = e21624;
var statearr_21625_21646 = state_21597;
(statearr_21625_21646[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21597);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21624;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21647 = state_21597;
state_21597 = G__21647;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_21597){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_21597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___21631,out))
})();
var state__11091__auto__ = (function (){var statearr_21626 = f__11090__auto__.call(null);
(statearr_21626[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___21631);

return statearr_21626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___21631,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21648 = [];
var len__5726__auto___21722 = arguments.length;
var i__5727__auto___21723 = (0);
while(true){
if((i__5727__auto___21723 < len__5726__auto___21722)){
args21648.push((arguments[i__5727__auto___21723]));

var G__21724 = (i__5727__auto___21723 + (1));
i__5727__auto___21723 = G__21724;
continue;
} else {
}
break;
}

var G__21650 = args21648.length;
switch (G__21650) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21648.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11089__auto___21726 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11089__auto___21726,out){
return (function (){
var f__11090__auto__ = (function (){var switch__10977__auto__ = ((function (c__11089__auto___21726,out){
return (function (state_21692){
var state_val_21693 = (state_21692[(1)]);
if((state_val_21693 === (7))){
var inst_21688 = (state_21692[(2)]);
var state_21692__$1 = state_21692;
var statearr_21694_21727 = state_21692__$1;
(statearr_21694_21727[(2)] = inst_21688);

(statearr_21694_21727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (1))){
var inst_21651 = [];
var inst_21652 = inst_21651;
var inst_21653 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21692__$1 = (function (){var statearr_21695 = state_21692;
(statearr_21695[(7)] = inst_21652);

(statearr_21695[(8)] = inst_21653);

return statearr_21695;
})();
var statearr_21696_21728 = state_21692__$1;
(statearr_21696_21728[(2)] = null);

(statearr_21696_21728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (4))){
var inst_21656 = (state_21692[(9)]);
var inst_21656__$1 = (state_21692[(2)]);
var inst_21657 = (inst_21656__$1 == null);
var inst_21658 = cljs.core.not.call(null,inst_21657);
var state_21692__$1 = (function (){var statearr_21697 = state_21692;
(statearr_21697[(9)] = inst_21656__$1);

return statearr_21697;
})();
if(inst_21658){
var statearr_21698_21729 = state_21692__$1;
(statearr_21698_21729[(1)] = (5));

} else {
var statearr_21699_21730 = state_21692__$1;
(statearr_21699_21730[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (15))){
var inst_21682 = (state_21692[(2)]);
var state_21692__$1 = state_21692;
var statearr_21700_21731 = state_21692__$1;
(statearr_21700_21731[(2)] = inst_21682);

(statearr_21700_21731[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (13))){
var state_21692__$1 = state_21692;
var statearr_21701_21732 = state_21692__$1;
(statearr_21701_21732[(2)] = null);

(statearr_21701_21732[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (6))){
var inst_21652 = (state_21692[(7)]);
var inst_21677 = inst_21652.length;
var inst_21678 = (inst_21677 > (0));
var state_21692__$1 = state_21692;
if(cljs.core.truth_(inst_21678)){
var statearr_21702_21733 = state_21692__$1;
(statearr_21702_21733[(1)] = (12));

} else {
var statearr_21703_21734 = state_21692__$1;
(statearr_21703_21734[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (3))){
var inst_21690 = (state_21692[(2)]);
var state_21692__$1 = state_21692;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21692__$1,inst_21690);
} else {
if((state_val_21693 === (12))){
var inst_21652 = (state_21692[(7)]);
var inst_21680 = cljs.core.vec.call(null,inst_21652);
var state_21692__$1 = state_21692;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21692__$1,(15),out,inst_21680);
} else {
if((state_val_21693 === (2))){
var state_21692__$1 = state_21692;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21692__$1,(4),ch);
} else {
if((state_val_21693 === (11))){
var inst_21656 = (state_21692[(9)]);
var inst_21660 = (state_21692[(10)]);
var inst_21670 = (state_21692[(2)]);
var inst_21671 = [];
var inst_21672 = inst_21671.push(inst_21656);
var inst_21652 = inst_21671;
var inst_21653 = inst_21660;
var state_21692__$1 = (function (){var statearr_21704 = state_21692;
(statearr_21704[(11)] = inst_21670);

(statearr_21704[(12)] = inst_21672);

(statearr_21704[(7)] = inst_21652);

(statearr_21704[(8)] = inst_21653);

return statearr_21704;
})();
var statearr_21705_21735 = state_21692__$1;
(statearr_21705_21735[(2)] = null);

(statearr_21705_21735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (9))){
var inst_21652 = (state_21692[(7)]);
var inst_21668 = cljs.core.vec.call(null,inst_21652);
var state_21692__$1 = state_21692;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21692__$1,(11),out,inst_21668);
} else {
if((state_val_21693 === (5))){
var inst_21656 = (state_21692[(9)]);
var inst_21660 = (state_21692[(10)]);
var inst_21653 = (state_21692[(8)]);
var inst_21660__$1 = f.call(null,inst_21656);
var inst_21661 = cljs.core._EQ_.call(null,inst_21660__$1,inst_21653);
var inst_21662 = cljs.core.keyword_identical_QMARK_.call(null,inst_21653,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21663 = (inst_21661) || (inst_21662);
var state_21692__$1 = (function (){var statearr_21706 = state_21692;
(statearr_21706[(10)] = inst_21660__$1);

return statearr_21706;
})();
if(cljs.core.truth_(inst_21663)){
var statearr_21707_21736 = state_21692__$1;
(statearr_21707_21736[(1)] = (8));

} else {
var statearr_21708_21737 = state_21692__$1;
(statearr_21708_21737[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (14))){
var inst_21685 = (state_21692[(2)]);
var inst_21686 = cljs.core.async.close_BANG_.call(null,out);
var state_21692__$1 = (function (){var statearr_21710 = state_21692;
(statearr_21710[(13)] = inst_21685);

return statearr_21710;
})();
var statearr_21711_21738 = state_21692__$1;
(statearr_21711_21738[(2)] = inst_21686);

(statearr_21711_21738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (10))){
var inst_21675 = (state_21692[(2)]);
var state_21692__$1 = state_21692;
var statearr_21712_21739 = state_21692__$1;
(statearr_21712_21739[(2)] = inst_21675);

(statearr_21712_21739[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21693 === (8))){
var inst_21656 = (state_21692[(9)]);
var inst_21660 = (state_21692[(10)]);
var inst_21652 = (state_21692[(7)]);
var inst_21665 = inst_21652.push(inst_21656);
var tmp21709 = inst_21652;
var inst_21652__$1 = tmp21709;
var inst_21653 = inst_21660;
var state_21692__$1 = (function (){var statearr_21713 = state_21692;
(statearr_21713[(14)] = inst_21665);

(statearr_21713[(7)] = inst_21652__$1);

(statearr_21713[(8)] = inst_21653);

return statearr_21713;
})();
var statearr_21714_21740 = state_21692__$1;
(statearr_21714_21740[(2)] = null);

(statearr_21714_21740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11089__auto___21726,out))
;
return ((function (switch__10977__auto__,c__11089__auto___21726,out){
return (function() {
var cljs$core$async$state_machine__10978__auto__ = null;
var cljs$core$async$state_machine__10978__auto____0 = (function (){
var statearr_21718 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21718[(0)] = cljs$core$async$state_machine__10978__auto__);

(statearr_21718[(1)] = (1));

return statearr_21718;
});
var cljs$core$async$state_machine__10978__auto____1 = (function (state_21692){
while(true){
var ret_value__10979__auto__ = (function (){try{while(true){
var result__10980__auto__ = switch__10977__auto__.call(null,state_21692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10980__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10980__auto__;
}
break;
}
}catch (e21719){if((e21719 instanceof Object)){
var ex__10981__auto__ = e21719;
var statearr_21720_21741 = state_21692;
(statearr_21720_21741[(5)] = ex__10981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21692);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21719;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10979__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21742 = state_21692;
state_21692 = G__21742;
continue;
} else {
return ret_value__10979__auto__;
}
break;
}
});
cljs$core$async$state_machine__10978__auto__ = function(state_21692){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10978__auto____1.call(this,state_21692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10978__auto____0;
cljs$core$async$state_machine__10978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10978__auto____1;
return cljs$core$async$state_machine__10978__auto__;
})()
;})(switch__10977__auto__,c__11089__auto___21726,out))
})();
var state__11091__auto__ = (function (){var statearr_21721 = f__11090__auto__.call(null);
(statearr_21721[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11089__auto___21726);

return statearr_21721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11091__auto__);
});})(c__11089__auto___21726,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1465894211277