// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__6352__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__6351 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__6351,(0),null);
var body = cljs.core.nthnext.call(null,vec__6351,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__6352 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__6353__i = 0, G__6353__a = new Array(arguments.length -  0);
while (G__6353__i < G__6353__a.length) {G__6353__a[G__6353__i] = arguments[G__6353__i + 0]; ++G__6353__i;}
  args = new cljs.core.IndexedSeq(G__6353__a,0);
} 
return G__6352__delegate.call(this,args);};
G__6352.cljs$lang$maxFixedArity = 0;
G__6352.cljs$lang$applyTo = (function (arglist__6354){
var args = cljs.core.seq(arglist__6354);
return G__6352__delegate(args);
});
G__6352.cljs$core$IFn$_invoke$arity$variadic = G__6352__delegate;
return G__6352;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__6359(s__6360){
return (new cljs.core.LazySeq(null,(function (){
var s__6360__$1 = s__6360;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__6360__$1);
if(temp__4425__auto__){
var s__6360__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__6360__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__6360__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__6362 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__6361 = (0);
while(true){
if((i__6361 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__6361);
cljs.core.chunk_append.call(null,b__6362,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__6363 = (i__6361 + (1));
i__6361 = G__6363;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6362),sablono$core$update_arglists_$_iter__6359.call(null,cljs.core.chunk_rest.call(null,s__6360__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6362),null);
}
} else {
var args = cljs.core.first.call(null,s__6360__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__6359.call(null,cljs.core.rest.call(null,s__6360__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___6369 = arguments.length;
var i__5727__auto___6370 = (0);
while(true){
if((i__5727__auto___6370 < len__5726__auto___6369)){
args__5733__auto__.push((arguments[i__5727__auto___6370]));

var G__6371 = (i__5727__auto___6370 + (1));
i__5727__auto___6370 = G__6371;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__6365(s__6366){
return (new cljs.core.LazySeq(null,(function (){
var s__6366__$1 = s__6366;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__6366__$1);
if(temp__4425__auto__){
var s__6366__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__6366__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__6366__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__6368 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__6367 = (0);
while(true){
if((i__6367 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__6367);
cljs.core.chunk_append.call(null,b__6368,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__6372 = (i__6367 + (1));
i__6367 = G__6372;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6368),sablono$core$iter__6365.call(null,cljs.core.chunk_rest.call(null,s__6366__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6368),null);
}
} else {
var style = cljs.core.first.call(null,s__6366__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__6365.call(null,cljs.core.rest.call(null,s__6366__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq6364){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq6364));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to6373 = (function sablono$core$link_to6373(var_args){
var args__5733__auto__ = [];
var len__5726__auto___6376 = arguments.length;
var i__5727__auto___6377 = (0);
while(true){
if((i__5727__auto___6377 < len__5726__auto___6376)){
args__5733__auto__.push((arguments[i__5727__auto___6377]));

var G__6378 = (i__5727__auto___6377 + (1));
i__5727__auto___6377 = G__6378;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to6373.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to6373.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to6373.cljs$lang$maxFixedArity = (1);

sablono.core.link_to6373.cljs$lang$applyTo = (function (seq6374){
var G__6375 = cljs.core.first.call(null,seq6374);
var seq6374__$1 = cljs.core.next.call(null,seq6374);
return sablono.core.link_to6373.cljs$core$IFn$_invoke$arity$variadic(G__6375,seq6374__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to6373);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to6379 = (function sablono$core$mail_to6379(var_args){
var args__5733__auto__ = [];
var len__5726__auto___6384 = arguments.length;
var i__5727__auto___6385 = (0);
while(true){
if((i__5727__auto___6385 < len__5726__auto___6384)){
args__5733__auto__.push((arguments[i__5727__auto___6385]));

var G__6386 = (i__5727__auto___6385 + (1));
i__5727__auto___6385 = G__6386;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to6379.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to6379.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__6382){
var vec__6383 = p__6382;
var content = cljs.core.nth.call(null,vec__6383,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to6379.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to6379.cljs$lang$applyTo = (function (seq6380){
var G__6381 = cljs.core.first.call(null,seq6380);
var seq6380__$1 = cljs.core.next.call(null,seq6380);
return sablono.core.mail_to6379.cljs$core$IFn$_invoke$arity$variadic(G__6381,seq6380__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to6379);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list6387 = (function sablono$core$unordered_list6387(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list6387_$_iter__6392(s__6393){
return (new cljs.core.LazySeq(null,(function (){
var s__6393__$1 = s__6393;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__6393__$1);
if(temp__4425__auto__){
var s__6393__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__6393__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__6393__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__6395 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__6394 = (0);
while(true){
if((i__6394 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__6394);
cljs.core.chunk_append.call(null,b__6395,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__6396 = (i__6394 + (1));
i__6394 = G__6396;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6395),sablono$core$unordered_list6387_$_iter__6392.call(null,cljs.core.chunk_rest.call(null,s__6393__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6395),null);
}
} else {
var x = cljs.core.first.call(null,s__6393__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list6387_$_iter__6392.call(null,cljs.core.rest.call(null,s__6393__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list6387);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list6397 = (function sablono$core$ordered_list6397(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list6397_$_iter__6402(s__6403){
return (new cljs.core.LazySeq(null,(function (){
var s__6403__$1 = s__6403;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__6403__$1);
if(temp__4425__auto__){
var s__6403__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__6403__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__6403__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__6405 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__6404 = (0);
while(true){
if((i__6404 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__6404);
cljs.core.chunk_append.call(null,b__6405,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__6406 = (i__6404 + (1));
i__6404 = G__6406;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6405),sablono$core$ordered_list6397_$_iter__6402.call(null,cljs.core.chunk_rest.call(null,s__6403__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6405),null);
}
} else {
var x = cljs.core.first.call(null,s__6403__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list6397_$_iter__6402.call(null,cljs.core.rest.call(null,s__6403__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list6397);
/**
 * Create an image element.
 */
sablono.core.image6407 = (function sablono$core$image6407(var_args){
var args6408 = [];
var len__5726__auto___6411 = arguments.length;
var i__5727__auto___6412 = (0);
while(true){
if((i__5727__auto___6412 < len__5726__auto___6411)){
args6408.push((arguments[i__5727__auto___6412]));

var G__6413 = (i__5727__auto___6412 + (1));
i__5727__auto___6412 = G__6413;
continue;
} else {
}
break;
}

var G__6410 = args6408.length;
switch (G__6410) {
case 1:
return sablono.core.image6407.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image6407.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6408.length)].join('')));

}
});

sablono.core.image6407.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image6407.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image6407.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image6407);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__6415_SHARP_,p2__6416_SHARP_){
return [cljs.core.str(p1__6415_SHARP_),cljs.core.str("["),cljs.core.str(p2__6416_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__6417_SHARP_,p2__6418_SHARP_){
return [cljs.core.str(p1__6417_SHARP_),cljs.core.str("-"),cljs.core.str(p2__6418_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field6419 = (function sablono$core$color_field6419(var_args){
var args6420 = [];
var len__5726__auto___6487 = arguments.length;
var i__5727__auto___6488 = (0);
while(true){
if((i__5727__auto___6488 < len__5726__auto___6487)){
args6420.push((arguments[i__5727__auto___6488]));

var G__6489 = (i__5727__auto___6488 + (1));
i__5727__auto___6488 = G__6489;
continue;
} else {
}
break;
}

var G__6422 = args6420.length;
switch (G__6422) {
case 1:
return sablono.core.color_field6419.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field6419.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6420.length)].join('')));

}
});

sablono.core.color_field6419.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.color_field6419.call(null,name__6340__auto__,null);
});

sablono.core.color_field6419.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.color_field6419.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field6419);

/**
 * Creates a date input field.
 */
sablono.core.date_field6423 = (function sablono$core$date_field6423(var_args){
var args6424 = [];
var len__5726__auto___6491 = arguments.length;
var i__5727__auto___6492 = (0);
while(true){
if((i__5727__auto___6492 < len__5726__auto___6491)){
args6424.push((arguments[i__5727__auto___6492]));

var G__6493 = (i__5727__auto___6492 + (1));
i__5727__auto___6492 = G__6493;
continue;
} else {
}
break;
}

var G__6426 = args6424.length;
switch (G__6426) {
case 1:
return sablono.core.date_field6423.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field6423.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6424.length)].join('')));

}
});

sablono.core.date_field6423.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.date_field6423.call(null,name__6340__auto__,null);
});

sablono.core.date_field6423.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.date_field6423.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field6423);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field6427 = (function sablono$core$datetime_field6427(var_args){
var args6428 = [];
var len__5726__auto___6495 = arguments.length;
var i__5727__auto___6496 = (0);
while(true){
if((i__5727__auto___6496 < len__5726__auto___6495)){
args6428.push((arguments[i__5727__auto___6496]));

var G__6497 = (i__5727__auto___6496 + (1));
i__5727__auto___6496 = G__6497;
continue;
} else {
}
break;
}

var G__6430 = args6428.length;
switch (G__6430) {
case 1:
return sablono.core.datetime_field6427.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field6427.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6428.length)].join('')));

}
});

sablono.core.datetime_field6427.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_field6427.call(null,name__6340__auto__,null);
});

sablono.core.datetime_field6427.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_field6427.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field6427);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field6431 = (function sablono$core$datetime_local_field6431(var_args){
var args6432 = [];
var len__5726__auto___6499 = arguments.length;
var i__5727__auto___6500 = (0);
while(true){
if((i__5727__auto___6500 < len__5726__auto___6499)){
args6432.push((arguments[i__5727__auto___6500]));

var G__6501 = (i__5727__auto___6500 + (1));
i__5727__auto___6500 = G__6501;
continue;
} else {
}
break;
}

var G__6434 = args6432.length;
switch (G__6434) {
case 1:
return sablono.core.datetime_local_field6431.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field6431.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6432.length)].join('')));

}
});

sablono.core.datetime_local_field6431.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_local_field6431.call(null,name__6340__auto__,null);
});

sablono.core.datetime_local_field6431.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_local_field6431.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field6431);

/**
 * Creates a email input field.
 */
sablono.core.email_field6435 = (function sablono$core$email_field6435(var_args){
var args6436 = [];
var len__5726__auto___6503 = arguments.length;
var i__5727__auto___6504 = (0);
while(true){
if((i__5727__auto___6504 < len__5726__auto___6503)){
args6436.push((arguments[i__5727__auto___6504]));

var G__6505 = (i__5727__auto___6504 + (1));
i__5727__auto___6504 = G__6505;
continue;
} else {
}
break;
}

var G__6438 = args6436.length;
switch (G__6438) {
case 1:
return sablono.core.email_field6435.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field6435.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6436.length)].join('')));

}
});

sablono.core.email_field6435.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.email_field6435.call(null,name__6340__auto__,null);
});

sablono.core.email_field6435.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.email_field6435.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field6435);

/**
 * Creates a file input field.
 */
sablono.core.file_field6439 = (function sablono$core$file_field6439(var_args){
var args6440 = [];
var len__5726__auto___6507 = arguments.length;
var i__5727__auto___6508 = (0);
while(true){
if((i__5727__auto___6508 < len__5726__auto___6507)){
args6440.push((arguments[i__5727__auto___6508]));

var G__6509 = (i__5727__auto___6508 + (1));
i__5727__auto___6508 = G__6509;
continue;
} else {
}
break;
}

var G__6442 = args6440.length;
switch (G__6442) {
case 1:
return sablono.core.file_field6439.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field6439.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6440.length)].join('')));

}
});

sablono.core.file_field6439.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.file_field6439.call(null,name__6340__auto__,null);
});

sablono.core.file_field6439.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.file_field6439.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field6439);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field6443 = (function sablono$core$hidden_field6443(var_args){
var args6444 = [];
var len__5726__auto___6511 = arguments.length;
var i__5727__auto___6512 = (0);
while(true){
if((i__5727__auto___6512 < len__5726__auto___6511)){
args6444.push((arguments[i__5727__auto___6512]));

var G__6513 = (i__5727__auto___6512 + (1));
i__5727__auto___6512 = G__6513;
continue;
} else {
}
break;
}

var G__6446 = args6444.length;
switch (G__6446) {
case 1:
return sablono.core.hidden_field6443.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field6443.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6444.length)].join('')));

}
});

sablono.core.hidden_field6443.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.hidden_field6443.call(null,name__6340__auto__,null);
});

sablono.core.hidden_field6443.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.hidden_field6443.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field6443);

/**
 * Creates a month input field.
 */
sablono.core.month_field6447 = (function sablono$core$month_field6447(var_args){
var args6448 = [];
var len__5726__auto___6515 = arguments.length;
var i__5727__auto___6516 = (0);
while(true){
if((i__5727__auto___6516 < len__5726__auto___6515)){
args6448.push((arguments[i__5727__auto___6516]));

var G__6517 = (i__5727__auto___6516 + (1));
i__5727__auto___6516 = G__6517;
continue;
} else {
}
break;
}

var G__6450 = args6448.length;
switch (G__6450) {
case 1:
return sablono.core.month_field6447.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field6447.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6448.length)].join('')));

}
});

sablono.core.month_field6447.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.month_field6447.call(null,name__6340__auto__,null);
});

sablono.core.month_field6447.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.month_field6447.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field6447);

/**
 * Creates a number input field.
 */
sablono.core.number_field6451 = (function sablono$core$number_field6451(var_args){
var args6452 = [];
var len__5726__auto___6519 = arguments.length;
var i__5727__auto___6520 = (0);
while(true){
if((i__5727__auto___6520 < len__5726__auto___6519)){
args6452.push((arguments[i__5727__auto___6520]));

var G__6521 = (i__5727__auto___6520 + (1));
i__5727__auto___6520 = G__6521;
continue;
} else {
}
break;
}

var G__6454 = args6452.length;
switch (G__6454) {
case 1:
return sablono.core.number_field6451.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field6451.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6452.length)].join('')));

}
});

sablono.core.number_field6451.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.number_field6451.call(null,name__6340__auto__,null);
});

sablono.core.number_field6451.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.number_field6451.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field6451);

/**
 * Creates a password input field.
 */
sablono.core.password_field6455 = (function sablono$core$password_field6455(var_args){
var args6456 = [];
var len__5726__auto___6523 = arguments.length;
var i__5727__auto___6524 = (0);
while(true){
if((i__5727__auto___6524 < len__5726__auto___6523)){
args6456.push((arguments[i__5727__auto___6524]));

var G__6525 = (i__5727__auto___6524 + (1));
i__5727__auto___6524 = G__6525;
continue;
} else {
}
break;
}

var G__6458 = args6456.length;
switch (G__6458) {
case 1:
return sablono.core.password_field6455.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field6455.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6456.length)].join('')));

}
});

sablono.core.password_field6455.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.password_field6455.call(null,name__6340__auto__,null);
});

sablono.core.password_field6455.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.password_field6455.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field6455);

/**
 * Creates a range input field.
 */
sablono.core.range_field6459 = (function sablono$core$range_field6459(var_args){
var args6460 = [];
var len__5726__auto___6527 = arguments.length;
var i__5727__auto___6528 = (0);
while(true){
if((i__5727__auto___6528 < len__5726__auto___6527)){
args6460.push((arguments[i__5727__auto___6528]));

var G__6529 = (i__5727__auto___6528 + (1));
i__5727__auto___6528 = G__6529;
continue;
} else {
}
break;
}

var G__6462 = args6460.length;
switch (G__6462) {
case 1:
return sablono.core.range_field6459.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field6459.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6460.length)].join('')));

}
});

sablono.core.range_field6459.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.range_field6459.call(null,name__6340__auto__,null);
});

sablono.core.range_field6459.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.range_field6459.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field6459);

/**
 * Creates a search input field.
 */
sablono.core.search_field6463 = (function sablono$core$search_field6463(var_args){
var args6464 = [];
var len__5726__auto___6531 = arguments.length;
var i__5727__auto___6532 = (0);
while(true){
if((i__5727__auto___6532 < len__5726__auto___6531)){
args6464.push((arguments[i__5727__auto___6532]));

var G__6533 = (i__5727__auto___6532 + (1));
i__5727__auto___6532 = G__6533;
continue;
} else {
}
break;
}

var G__6466 = args6464.length;
switch (G__6466) {
case 1:
return sablono.core.search_field6463.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field6463.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6464.length)].join('')));

}
});

sablono.core.search_field6463.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.search_field6463.call(null,name__6340__auto__,null);
});

sablono.core.search_field6463.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.search_field6463.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field6463);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field6467 = (function sablono$core$tel_field6467(var_args){
var args6468 = [];
var len__5726__auto___6535 = arguments.length;
var i__5727__auto___6536 = (0);
while(true){
if((i__5727__auto___6536 < len__5726__auto___6535)){
args6468.push((arguments[i__5727__auto___6536]));

var G__6537 = (i__5727__auto___6536 + (1));
i__5727__auto___6536 = G__6537;
continue;
} else {
}
break;
}

var G__6470 = args6468.length;
switch (G__6470) {
case 1:
return sablono.core.tel_field6467.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field6467.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6468.length)].join('')));

}
});

sablono.core.tel_field6467.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.tel_field6467.call(null,name__6340__auto__,null);
});

sablono.core.tel_field6467.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.tel_field6467.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field6467);

/**
 * Creates a text input field.
 */
sablono.core.text_field6471 = (function sablono$core$text_field6471(var_args){
var args6472 = [];
var len__5726__auto___6539 = arguments.length;
var i__5727__auto___6540 = (0);
while(true){
if((i__5727__auto___6540 < len__5726__auto___6539)){
args6472.push((arguments[i__5727__auto___6540]));

var G__6541 = (i__5727__auto___6540 + (1));
i__5727__auto___6540 = G__6541;
continue;
} else {
}
break;
}

var G__6474 = args6472.length;
switch (G__6474) {
case 1:
return sablono.core.text_field6471.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field6471.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6472.length)].join('')));

}
});

sablono.core.text_field6471.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.text_field6471.call(null,name__6340__auto__,null);
});

sablono.core.text_field6471.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.text_field6471.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field6471);

/**
 * Creates a time input field.
 */
sablono.core.time_field6475 = (function sablono$core$time_field6475(var_args){
var args6476 = [];
var len__5726__auto___6543 = arguments.length;
var i__5727__auto___6544 = (0);
while(true){
if((i__5727__auto___6544 < len__5726__auto___6543)){
args6476.push((arguments[i__5727__auto___6544]));

var G__6545 = (i__5727__auto___6544 + (1));
i__5727__auto___6544 = G__6545;
continue;
} else {
}
break;
}

var G__6478 = args6476.length;
switch (G__6478) {
case 1:
return sablono.core.time_field6475.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field6475.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6476.length)].join('')));

}
});

sablono.core.time_field6475.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.time_field6475.call(null,name__6340__auto__,null);
});

sablono.core.time_field6475.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.time_field6475.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field6475);

/**
 * Creates a url input field.
 */
sablono.core.url_field6479 = (function sablono$core$url_field6479(var_args){
var args6480 = [];
var len__5726__auto___6547 = arguments.length;
var i__5727__auto___6548 = (0);
while(true){
if((i__5727__auto___6548 < len__5726__auto___6547)){
args6480.push((arguments[i__5727__auto___6548]));

var G__6549 = (i__5727__auto___6548 + (1));
i__5727__auto___6548 = G__6549;
continue;
} else {
}
break;
}

var G__6482 = args6480.length;
switch (G__6482) {
case 1:
return sablono.core.url_field6479.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field6479.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6480.length)].join('')));

}
});

sablono.core.url_field6479.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.url_field6479.call(null,name__6340__auto__,null);
});

sablono.core.url_field6479.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.url_field6479.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field6479);

/**
 * Creates a week input field.
 */
sablono.core.week_field6483 = (function sablono$core$week_field6483(var_args){
var args6484 = [];
var len__5726__auto___6551 = arguments.length;
var i__5727__auto___6552 = (0);
while(true){
if((i__5727__auto___6552 < len__5726__auto___6551)){
args6484.push((arguments[i__5727__auto___6552]));

var G__6553 = (i__5727__auto___6552 + (1));
i__5727__auto___6552 = G__6553;
continue;
} else {
}
break;
}

var G__6486 = args6484.length;
switch (G__6486) {
case 1:
return sablono.core.week_field6483.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field6483.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6484.length)].join('')));

}
});

sablono.core.week_field6483.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.week_field6483.call(null,name__6340__auto__,null);
});

sablono.core.week_field6483.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.week_field6483.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field6483);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box6555 = (function sablono$core$check_box6555(var_args){
var args6556 = [];
var len__5726__auto___6559 = arguments.length;
var i__5727__auto___6560 = (0);
while(true){
if((i__5727__auto___6560 < len__5726__auto___6559)){
args6556.push((arguments[i__5727__auto___6560]));

var G__6561 = (i__5727__auto___6560 + (1));
i__5727__auto___6560 = G__6561;
continue;
} else {
}
break;
}

var G__6558 = args6556.length;
switch (G__6558) {
case 1:
return sablono.core.check_box6555.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box6555.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box6555.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6556.length)].join('')));

}
});

sablono.core.check_box6555.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box6555.call(null,name,null);
});

sablono.core.check_box6555.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box6555.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box6555.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box6555.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box6555);
/**
 * Creates a radio button.
 */
sablono.core.radio_button6563 = (function sablono$core$radio_button6563(var_args){
var args6564 = [];
var len__5726__auto___6567 = arguments.length;
var i__5727__auto___6568 = (0);
while(true){
if((i__5727__auto___6568 < len__5726__auto___6567)){
args6564.push((arguments[i__5727__auto___6568]));

var G__6569 = (i__5727__auto___6568 + (1));
i__5727__auto___6568 = G__6569;
continue;
} else {
}
break;
}

var G__6566 = args6564.length;
switch (G__6566) {
case 1:
return sablono.core.radio_button6563.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button6563.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button6563.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6564.length)].join('')));

}
});

sablono.core.radio_button6563.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button6563.call(null,group,null);
});

sablono.core.radio_button6563.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button6563.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button6563.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button6563.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button6563);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options6571 = (function sablono$core$select_options6571(coll){
var iter__5440__auto__ = (function sablono$core$select_options6571_$_iter__6580(s__6581){
return (new cljs.core.LazySeq(null,(function (){
var s__6581__$1 = s__6581;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__6581__$1);
if(temp__4425__auto__){
var s__6581__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__6581__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__6581__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__6583 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__6582 = (0);
while(true){
if((i__6582 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__6582);
cljs.core.chunk_append.call(null,b__6583,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__6586 = x;
var text = cljs.core.nth.call(null,vec__6586,(0),null);
var val = cljs.core.nth.call(null,vec__6586,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__6586,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options6571.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__6588 = (i__6582 + (1));
i__6582 = G__6588;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6583),sablono$core$select_options6571_$_iter__6580.call(null,cljs.core.chunk_rest.call(null,s__6581__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__6583),null);
}
} else {
var x = cljs.core.first.call(null,s__6581__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__6587 = x;
var text = cljs.core.nth.call(null,vec__6587,(0),null);
var val = cljs.core.nth.call(null,vec__6587,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__6587,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options6571.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options6571_$_iter__6580.call(null,cljs.core.rest.call(null,s__6581__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options6571);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down6589 = (function sablono$core$drop_down6589(var_args){
var args6590 = [];
var len__5726__auto___6593 = arguments.length;
var i__5727__auto___6594 = (0);
while(true){
if((i__5727__auto___6594 < len__5726__auto___6593)){
args6590.push((arguments[i__5727__auto___6594]));

var G__6595 = (i__5727__auto___6594 + (1));
i__5727__auto___6594 = G__6595;
continue;
} else {
}
break;
}

var G__6592 = args6590.length;
switch (G__6592) {
case 2:
return sablono.core.drop_down6589.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down6589.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6590.length)].join('')));

}
});

sablono.core.drop_down6589.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down6589.call(null,name,options,null);
});

sablono.core.drop_down6589.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down6589.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down6589);
/**
 * Creates a text area element.
 */
sablono.core.text_area6597 = (function sablono$core$text_area6597(var_args){
var args6598 = [];
var len__5726__auto___6601 = arguments.length;
var i__5727__auto___6602 = (0);
while(true){
if((i__5727__auto___6602 < len__5726__auto___6601)){
args6598.push((arguments[i__5727__auto___6602]));

var G__6603 = (i__5727__auto___6602 + (1));
i__5727__auto___6602 = G__6603;
continue;
} else {
}
break;
}

var G__6600 = args6598.length;
switch (G__6600) {
case 1:
return sablono.core.text_area6597.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area6597.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args6598.length)].join('')));

}
});

sablono.core.text_area6597.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area6597.call(null,name,null);
});

sablono.core.text_area6597.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area6597.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area6597);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label6605 = (function sablono$core$label6605(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label6605);
/**
 * Creates a submit button.
 */
sablono.core.submit_button6606 = (function sablono$core$submit_button6606(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button6606);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button6607 = (function sablono$core$reset_button6607(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button6607);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to6608 = (function sablono$core$form_to6608(var_args){
var args__5733__auto__ = [];
var len__5726__auto___6613 = arguments.length;
var i__5727__auto___6614 = (0);
while(true){
if((i__5727__auto___6614 < len__5726__auto___6613)){
args__5733__auto__.push((arguments[i__5727__auto___6614]));

var G__6615 = (i__5727__auto___6614 + (1));
i__5727__auto___6614 = G__6615;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to6608.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to6608.cljs$core$IFn$_invoke$arity$variadic = (function (p__6611,body){
var vec__6612 = p__6611;
var method = cljs.core.nth.call(null,vec__6612,(0),null);
var action = cljs.core.nth.call(null,vec__6612,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to6608.cljs$lang$maxFixedArity = (1);

sablono.core.form_to6608.cljs$lang$applyTo = (function (seq6609){
var G__6610 = cljs.core.first.call(null,seq6609);
var seq6609__$1 = cljs.core.next.call(null,seq6609);
return sablono.core.form_to6608.cljs$core$IFn$_invoke$arity$variadic(G__6610,seq6609__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to6608);

//# sourceMappingURL=core.js.map?rel=1465389024586