// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__16263__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__16262 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__16262,(0),null);
var body = cljs.core.nthnext.call(null,vec__16262,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__16263 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16264__i = 0, G__16264__a = new Array(arguments.length -  0);
while (G__16264__i < G__16264__a.length) {G__16264__a[G__16264__i] = arguments[G__16264__i + 0]; ++G__16264__i;}
  args = new cljs.core.IndexedSeq(G__16264__a,0);
} 
return G__16263__delegate.call(this,args);};
G__16263.cljs$lang$maxFixedArity = 0;
G__16263.cljs$lang$applyTo = (function (arglist__16265){
var args = cljs.core.seq(arglist__16265);
return G__16263__delegate(args);
});
G__16263.cljs$core$IFn$_invoke$arity$variadic = G__16263__delegate;
return G__16263;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__16270(s__16271){
return (new cljs.core.LazySeq(null,(function (){
var s__16271__$1 = s__16271;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16271__$1);
if(temp__4425__auto__){
var s__16271__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16271__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16271__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16273 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16272 = (0);
while(true){
if((i__16272 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__16272);
cljs.core.chunk_append.call(null,b__16273,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__16274 = (i__16272 + (1));
i__16272 = G__16274;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16273),sablono$core$update_arglists_$_iter__16270.call(null,cljs.core.chunk_rest.call(null,s__16271__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16273),null);
}
} else {
var args = cljs.core.first.call(null,s__16271__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__16270.call(null,cljs.core.rest.call(null,s__16271__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16280 = arguments.length;
var i__5727__auto___16281 = (0);
while(true){
if((i__5727__auto___16281 < len__5726__auto___16280)){
args__5733__auto__.push((arguments[i__5727__auto___16281]));

var G__16282 = (i__5727__auto___16281 + (1));
i__5727__auto___16281 = G__16282;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__16276(s__16277){
return (new cljs.core.LazySeq(null,(function (){
var s__16277__$1 = s__16277;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16277__$1);
if(temp__4425__auto__){
var s__16277__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16277__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16277__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16279 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16278 = (0);
while(true){
if((i__16278 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__16278);
cljs.core.chunk_append.call(null,b__16279,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__16283 = (i__16278 + (1));
i__16278 = G__16283;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16279),sablono$core$iter__16276.call(null,cljs.core.chunk_rest.call(null,s__16277__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16279),null);
}
} else {
var style = cljs.core.first.call(null,s__16277__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__16276.call(null,cljs.core.rest.call(null,s__16277__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq16275){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16275));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to16284 = (function sablono$core$link_to16284(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16287 = arguments.length;
var i__5727__auto___16288 = (0);
while(true){
if((i__5727__auto___16288 < len__5726__auto___16287)){
args__5733__auto__.push((arguments[i__5727__auto___16288]));

var G__16289 = (i__5727__auto___16288 + (1));
i__5727__auto___16288 = G__16289;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to16284.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to16284.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to16284.cljs$lang$maxFixedArity = (1);

sablono.core.link_to16284.cljs$lang$applyTo = (function (seq16285){
var G__16286 = cljs.core.first.call(null,seq16285);
var seq16285__$1 = cljs.core.next.call(null,seq16285);
return sablono.core.link_to16284.cljs$core$IFn$_invoke$arity$variadic(G__16286,seq16285__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to16284);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to16290 = (function sablono$core$mail_to16290(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16295 = arguments.length;
var i__5727__auto___16296 = (0);
while(true){
if((i__5727__auto___16296 < len__5726__auto___16295)){
args__5733__auto__.push((arguments[i__5727__auto___16296]));

var G__16297 = (i__5727__auto___16296 + (1));
i__5727__auto___16296 = G__16297;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to16290.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to16290.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__16293){
var vec__16294 = p__16293;
var content = cljs.core.nth.call(null,vec__16294,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to16290.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to16290.cljs$lang$applyTo = (function (seq16291){
var G__16292 = cljs.core.first.call(null,seq16291);
var seq16291__$1 = cljs.core.next.call(null,seq16291);
return sablono.core.mail_to16290.cljs$core$IFn$_invoke$arity$variadic(G__16292,seq16291__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to16290);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list16298 = (function sablono$core$unordered_list16298(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list16298_$_iter__16303(s__16304){
return (new cljs.core.LazySeq(null,(function (){
var s__16304__$1 = s__16304;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16304__$1);
if(temp__4425__auto__){
var s__16304__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16304__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16304__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16306 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16305 = (0);
while(true){
if((i__16305 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16305);
cljs.core.chunk_append.call(null,b__16306,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16307 = (i__16305 + (1));
i__16305 = G__16307;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16306),sablono$core$unordered_list16298_$_iter__16303.call(null,cljs.core.chunk_rest.call(null,s__16304__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16306),null);
}
} else {
var x = cljs.core.first.call(null,s__16304__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list16298_$_iter__16303.call(null,cljs.core.rest.call(null,s__16304__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list16298);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list16308 = (function sablono$core$ordered_list16308(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list16308_$_iter__16313(s__16314){
return (new cljs.core.LazySeq(null,(function (){
var s__16314__$1 = s__16314;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16314__$1);
if(temp__4425__auto__){
var s__16314__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16314__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16314__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16316 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16315 = (0);
while(true){
if((i__16315 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16315);
cljs.core.chunk_append.call(null,b__16316,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16317 = (i__16315 + (1));
i__16315 = G__16317;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16316),sablono$core$ordered_list16308_$_iter__16313.call(null,cljs.core.chunk_rest.call(null,s__16314__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16316),null);
}
} else {
var x = cljs.core.first.call(null,s__16314__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list16308_$_iter__16313.call(null,cljs.core.rest.call(null,s__16314__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list16308);
/**
 * Create an image element.
 */
sablono.core.image16318 = (function sablono$core$image16318(var_args){
var args16319 = [];
var len__5726__auto___16322 = arguments.length;
var i__5727__auto___16323 = (0);
while(true){
if((i__5727__auto___16323 < len__5726__auto___16322)){
args16319.push((arguments[i__5727__auto___16323]));

var G__16324 = (i__5727__auto___16323 + (1));
i__5727__auto___16323 = G__16324;
continue;
} else {
}
break;
}

var G__16321 = args16319.length;
switch (G__16321) {
case 1:
return sablono.core.image16318.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image16318.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16319.length)].join('')));

}
});

sablono.core.image16318.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image16318.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image16318.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image16318);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__16326_SHARP_,p2__16327_SHARP_){
return [cljs.core.str(p1__16326_SHARP_),cljs.core.str("["),cljs.core.str(p2__16327_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__16328_SHARP_,p2__16329_SHARP_){
return [cljs.core.str(p1__16328_SHARP_),cljs.core.str("-"),cljs.core.str(p2__16329_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field16330 = (function sablono$core$color_field16330(var_args){
var args16331 = [];
var len__5726__auto___16398 = arguments.length;
var i__5727__auto___16399 = (0);
while(true){
if((i__5727__auto___16399 < len__5726__auto___16398)){
args16331.push((arguments[i__5727__auto___16399]));

var G__16400 = (i__5727__auto___16399 + (1));
i__5727__auto___16399 = G__16400;
continue;
} else {
}
break;
}

var G__16333 = args16331.length;
switch (G__16333) {
case 1:
return sablono.core.color_field16330.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field16330.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16331.length)].join('')));

}
});

sablono.core.color_field16330.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.color_field16330.call(null,name__6340__auto__,null);
});

sablono.core.color_field16330.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.color_field16330.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field16330);

/**
 * Creates a date input field.
 */
sablono.core.date_field16334 = (function sablono$core$date_field16334(var_args){
var args16335 = [];
var len__5726__auto___16402 = arguments.length;
var i__5727__auto___16403 = (0);
while(true){
if((i__5727__auto___16403 < len__5726__auto___16402)){
args16335.push((arguments[i__5727__auto___16403]));

var G__16404 = (i__5727__auto___16403 + (1));
i__5727__auto___16403 = G__16404;
continue;
} else {
}
break;
}

var G__16337 = args16335.length;
switch (G__16337) {
case 1:
return sablono.core.date_field16334.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field16334.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16335.length)].join('')));

}
});

sablono.core.date_field16334.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.date_field16334.call(null,name__6340__auto__,null);
});

sablono.core.date_field16334.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.date_field16334.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field16334);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field16338 = (function sablono$core$datetime_field16338(var_args){
var args16339 = [];
var len__5726__auto___16406 = arguments.length;
var i__5727__auto___16407 = (0);
while(true){
if((i__5727__auto___16407 < len__5726__auto___16406)){
args16339.push((arguments[i__5727__auto___16407]));

var G__16408 = (i__5727__auto___16407 + (1));
i__5727__auto___16407 = G__16408;
continue;
} else {
}
break;
}

var G__16341 = args16339.length;
switch (G__16341) {
case 1:
return sablono.core.datetime_field16338.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field16338.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16339.length)].join('')));

}
});

sablono.core.datetime_field16338.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_field16338.call(null,name__6340__auto__,null);
});

sablono.core.datetime_field16338.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_field16338.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field16338);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field16342 = (function sablono$core$datetime_local_field16342(var_args){
var args16343 = [];
var len__5726__auto___16410 = arguments.length;
var i__5727__auto___16411 = (0);
while(true){
if((i__5727__auto___16411 < len__5726__auto___16410)){
args16343.push((arguments[i__5727__auto___16411]));

var G__16412 = (i__5727__auto___16411 + (1));
i__5727__auto___16411 = G__16412;
continue;
} else {
}
break;
}

var G__16345 = args16343.length;
switch (G__16345) {
case 1:
return sablono.core.datetime_local_field16342.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field16342.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16343.length)].join('')));

}
});

sablono.core.datetime_local_field16342.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_local_field16342.call(null,name__6340__auto__,null);
});

sablono.core.datetime_local_field16342.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_local_field16342.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field16342);

/**
 * Creates a email input field.
 */
sablono.core.email_field16346 = (function sablono$core$email_field16346(var_args){
var args16347 = [];
var len__5726__auto___16414 = arguments.length;
var i__5727__auto___16415 = (0);
while(true){
if((i__5727__auto___16415 < len__5726__auto___16414)){
args16347.push((arguments[i__5727__auto___16415]));

var G__16416 = (i__5727__auto___16415 + (1));
i__5727__auto___16415 = G__16416;
continue;
} else {
}
break;
}

var G__16349 = args16347.length;
switch (G__16349) {
case 1:
return sablono.core.email_field16346.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field16346.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16347.length)].join('')));

}
});

sablono.core.email_field16346.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.email_field16346.call(null,name__6340__auto__,null);
});

sablono.core.email_field16346.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.email_field16346.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field16346);

/**
 * Creates a file input field.
 */
sablono.core.file_field16350 = (function sablono$core$file_field16350(var_args){
var args16351 = [];
var len__5726__auto___16418 = arguments.length;
var i__5727__auto___16419 = (0);
while(true){
if((i__5727__auto___16419 < len__5726__auto___16418)){
args16351.push((arguments[i__5727__auto___16419]));

var G__16420 = (i__5727__auto___16419 + (1));
i__5727__auto___16419 = G__16420;
continue;
} else {
}
break;
}

var G__16353 = args16351.length;
switch (G__16353) {
case 1:
return sablono.core.file_field16350.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field16350.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16351.length)].join('')));

}
});

sablono.core.file_field16350.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.file_field16350.call(null,name__6340__auto__,null);
});

sablono.core.file_field16350.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.file_field16350.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field16350);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field16354 = (function sablono$core$hidden_field16354(var_args){
var args16355 = [];
var len__5726__auto___16422 = arguments.length;
var i__5727__auto___16423 = (0);
while(true){
if((i__5727__auto___16423 < len__5726__auto___16422)){
args16355.push((arguments[i__5727__auto___16423]));

var G__16424 = (i__5727__auto___16423 + (1));
i__5727__auto___16423 = G__16424;
continue;
} else {
}
break;
}

var G__16357 = args16355.length;
switch (G__16357) {
case 1:
return sablono.core.hidden_field16354.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field16354.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16355.length)].join('')));

}
});

sablono.core.hidden_field16354.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.hidden_field16354.call(null,name__6340__auto__,null);
});

sablono.core.hidden_field16354.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.hidden_field16354.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field16354);

/**
 * Creates a month input field.
 */
sablono.core.month_field16358 = (function sablono$core$month_field16358(var_args){
var args16359 = [];
var len__5726__auto___16426 = arguments.length;
var i__5727__auto___16427 = (0);
while(true){
if((i__5727__auto___16427 < len__5726__auto___16426)){
args16359.push((arguments[i__5727__auto___16427]));

var G__16428 = (i__5727__auto___16427 + (1));
i__5727__auto___16427 = G__16428;
continue;
} else {
}
break;
}

var G__16361 = args16359.length;
switch (G__16361) {
case 1:
return sablono.core.month_field16358.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field16358.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16359.length)].join('')));

}
});

sablono.core.month_field16358.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.month_field16358.call(null,name__6340__auto__,null);
});

sablono.core.month_field16358.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.month_field16358.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field16358);

/**
 * Creates a number input field.
 */
sablono.core.number_field16362 = (function sablono$core$number_field16362(var_args){
var args16363 = [];
var len__5726__auto___16430 = arguments.length;
var i__5727__auto___16431 = (0);
while(true){
if((i__5727__auto___16431 < len__5726__auto___16430)){
args16363.push((arguments[i__5727__auto___16431]));

var G__16432 = (i__5727__auto___16431 + (1));
i__5727__auto___16431 = G__16432;
continue;
} else {
}
break;
}

var G__16365 = args16363.length;
switch (G__16365) {
case 1:
return sablono.core.number_field16362.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field16362.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16363.length)].join('')));

}
});

sablono.core.number_field16362.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.number_field16362.call(null,name__6340__auto__,null);
});

sablono.core.number_field16362.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.number_field16362.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field16362);

/**
 * Creates a password input field.
 */
sablono.core.password_field16366 = (function sablono$core$password_field16366(var_args){
var args16367 = [];
var len__5726__auto___16434 = arguments.length;
var i__5727__auto___16435 = (0);
while(true){
if((i__5727__auto___16435 < len__5726__auto___16434)){
args16367.push((arguments[i__5727__auto___16435]));

var G__16436 = (i__5727__auto___16435 + (1));
i__5727__auto___16435 = G__16436;
continue;
} else {
}
break;
}

var G__16369 = args16367.length;
switch (G__16369) {
case 1:
return sablono.core.password_field16366.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field16366.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16367.length)].join('')));

}
});

sablono.core.password_field16366.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.password_field16366.call(null,name__6340__auto__,null);
});

sablono.core.password_field16366.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.password_field16366.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field16366);

/**
 * Creates a range input field.
 */
sablono.core.range_field16370 = (function sablono$core$range_field16370(var_args){
var args16371 = [];
var len__5726__auto___16438 = arguments.length;
var i__5727__auto___16439 = (0);
while(true){
if((i__5727__auto___16439 < len__5726__auto___16438)){
args16371.push((arguments[i__5727__auto___16439]));

var G__16440 = (i__5727__auto___16439 + (1));
i__5727__auto___16439 = G__16440;
continue;
} else {
}
break;
}

var G__16373 = args16371.length;
switch (G__16373) {
case 1:
return sablono.core.range_field16370.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field16370.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16371.length)].join('')));

}
});

sablono.core.range_field16370.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.range_field16370.call(null,name__6340__auto__,null);
});

sablono.core.range_field16370.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.range_field16370.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field16370);

/**
 * Creates a search input field.
 */
sablono.core.search_field16374 = (function sablono$core$search_field16374(var_args){
var args16375 = [];
var len__5726__auto___16442 = arguments.length;
var i__5727__auto___16443 = (0);
while(true){
if((i__5727__auto___16443 < len__5726__auto___16442)){
args16375.push((arguments[i__5727__auto___16443]));

var G__16444 = (i__5727__auto___16443 + (1));
i__5727__auto___16443 = G__16444;
continue;
} else {
}
break;
}

var G__16377 = args16375.length;
switch (G__16377) {
case 1:
return sablono.core.search_field16374.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field16374.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16375.length)].join('')));

}
});

sablono.core.search_field16374.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.search_field16374.call(null,name__6340__auto__,null);
});

sablono.core.search_field16374.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.search_field16374.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field16374);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field16378 = (function sablono$core$tel_field16378(var_args){
var args16379 = [];
var len__5726__auto___16446 = arguments.length;
var i__5727__auto___16447 = (0);
while(true){
if((i__5727__auto___16447 < len__5726__auto___16446)){
args16379.push((arguments[i__5727__auto___16447]));

var G__16448 = (i__5727__auto___16447 + (1));
i__5727__auto___16447 = G__16448;
continue;
} else {
}
break;
}

var G__16381 = args16379.length;
switch (G__16381) {
case 1:
return sablono.core.tel_field16378.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field16378.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16379.length)].join('')));

}
});

sablono.core.tel_field16378.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.tel_field16378.call(null,name__6340__auto__,null);
});

sablono.core.tel_field16378.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.tel_field16378.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field16378);

/**
 * Creates a text input field.
 */
sablono.core.text_field16382 = (function sablono$core$text_field16382(var_args){
var args16383 = [];
var len__5726__auto___16450 = arguments.length;
var i__5727__auto___16451 = (0);
while(true){
if((i__5727__auto___16451 < len__5726__auto___16450)){
args16383.push((arguments[i__5727__auto___16451]));

var G__16452 = (i__5727__auto___16451 + (1));
i__5727__auto___16451 = G__16452;
continue;
} else {
}
break;
}

var G__16385 = args16383.length;
switch (G__16385) {
case 1:
return sablono.core.text_field16382.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field16382.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16383.length)].join('')));

}
});

sablono.core.text_field16382.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.text_field16382.call(null,name__6340__auto__,null);
});

sablono.core.text_field16382.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.text_field16382.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field16382);

/**
 * Creates a time input field.
 */
sablono.core.time_field16386 = (function sablono$core$time_field16386(var_args){
var args16387 = [];
var len__5726__auto___16454 = arguments.length;
var i__5727__auto___16455 = (0);
while(true){
if((i__5727__auto___16455 < len__5726__auto___16454)){
args16387.push((arguments[i__5727__auto___16455]));

var G__16456 = (i__5727__auto___16455 + (1));
i__5727__auto___16455 = G__16456;
continue;
} else {
}
break;
}

var G__16389 = args16387.length;
switch (G__16389) {
case 1:
return sablono.core.time_field16386.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field16386.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16387.length)].join('')));

}
});

sablono.core.time_field16386.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.time_field16386.call(null,name__6340__auto__,null);
});

sablono.core.time_field16386.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.time_field16386.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field16386);

/**
 * Creates a url input field.
 */
sablono.core.url_field16390 = (function sablono$core$url_field16390(var_args){
var args16391 = [];
var len__5726__auto___16458 = arguments.length;
var i__5727__auto___16459 = (0);
while(true){
if((i__5727__auto___16459 < len__5726__auto___16458)){
args16391.push((arguments[i__5727__auto___16459]));

var G__16460 = (i__5727__auto___16459 + (1));
i__5727__auto___16459 = G__16460;
continue;
} else {
}
break;
}

var G__16393 = args16391.length;
switch (G__16393) {
case 1:
return sablono.core.url_field16390.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field16390.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16391.length)].join('')));

}
});

sablono.core.url_field16390.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.url_field16390.call(null,name__6340__auto__,null);
});

sablono.core.url_field16390.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.url_field16390.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field16390);

/**
 * Creates a week input field.
 */
sablono.core.week_field16394 = (function sablono$core$week_field16394(var_args){
var args16395 = [];
var len__5726__auto___16462 = arguments.length;
var i__5727__auto___16463 = (0);
while(true){
if((i__5727__auto___16463 < len__5726__auto___16462)){
args16395.push((arguments[i__5727__auto___16463]));

var G__16464 = (i__5727__auto___16463 + (1));
i__5727__auto___16463 = G__16464;
continue;
} else {
}
break;
}

var G__16397 = args16395.length;
switch (G__16397) {
case 1:
return sablono.core.week_field16394.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field16394.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16395.length)].join('')));

}
});

sablono.core.week_field16394.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.week_field16394.call(null,name__6340__auto__,null);
});

sablono.core.week_field16394.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.week_field16394.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field16394);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box16466 = (function sablono$core$check_box16466(var_args){
var args16467 = [];
var len__5726__auto___16470 = arguments.length;
var i__5727__auto___16471 = (0);
while(true){
if((i__5727__auto___16471 < len__5726__auto___16470)){
args16467.push((arguments[i__5727__auto___16471]));

var G__16472 = (i__5727__auto___16471 + (1));
i__5727__auto___16471 = G__16472;
continue;
} else {
}
break;
}

var G__16469 = args16467.length;
switch (G__16469) {
case 1:
return sablono.core.check_box16466.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box16466.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box16466.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16467.length)].join('')));

}
});

sablono.core.check_box16466.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box16466.call(null,name,null);
});

sablono.core.check_box16466.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box16466.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box16466.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box16466.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box16466);
/**
 * Creates a radio button.
 */
sablono.core.radio_button16474 = (function sablono$core$radio_button16474(var_args){
var args16475 = [];
var len__5726__auto___16478 = arguments.length;
var i__5727__auto___16479 = (0);
while(true){
if((i__5727__auto___16479 < len__5726__auto___16478)){
args16475.push((arguments[i__5727__auto___16479]));

var G__16480 = (i__5727__auto___16479 + (1));
i__5727__auto___16479 = G__16480;
continue;
} else {
}
break;
}

var G__16477 = args16475.length;
switch (G__16477) {
case 1:
return sablono.core.radio_button16474.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button16474.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button16474.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16475.length)].join('')));

}
});

sablono.core.radio_button16474.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button16474.call(null,group,null);
});

sablono.core.radio_button16474.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button16474.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button16474.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button16474.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button16474);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options16482 = (function sablono$core$select_options16482(coll){
var iter__5440__auto__ = (function sablono$core$select_options16482_$_iter__16491(s__16492){
return (new cljs.core.LazySeq(null,(function (){
var s__16492__$1 = s__16492;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16492__$1);
if(temp__4425__auto__){
var s__16492__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16492__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16492__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16494 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16493 = (0);
while(true){
if((i__16493 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16493);
cljs.core.chunk_append.call(null,b__16494,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16497 = x;
var text = cljs.core.nth.call(null,vec__16497,(0),null);
var val = cljs.core.nth.call(null,vec__16497,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16497,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16482.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__16499 = (i__16493 + (1));
i__16493 = G__16499;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16494),sablono$core$select_options16482_$_iter__16491.call(null,cljs.core.chunk_rest.call(null,s__16492__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16494),null);
}
} else {
var x = cljs.core.first.call(null,s__16492__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16498 = x;
var text = cljs.core.nth.call(null,vec__16498,(0),null);
var val = cljs.core.nth.call(null,vec__16498,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16498,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16482.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options16482_$_iter__16491.call(null,cljs.core.rest.call(null,s__16492__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options16482);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down16500 = (function sablono$core$drop_down16500(var_args){
var args16501 = [];
var len__5726__auto___16504 = arguments.length;
var i__5727__auto___16505 = (0);
while(true){
if((i__5727__auto___16505 < len__5726__auto___16504)){
args16501.push((arguments[i__5727__auto___16505]));

var G__16506 = (i__5727__auto___16505 + (1));
i__5727__auto___16505 = G__16506;
continue;
} else {
}
break;
}

var G__16503 = args16501.length;
switch (G__16503) {
case 2:
return sablono.core.drop_down16500.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down16500.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16501.length)].join('')));

}
});

sablono.core.drop_down16500.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down16500.call(null,name,options,null);
});

sablono.core.drop_down16500.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down16500.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down16500);
/**
 * Creates a text area element.
 */
sablono.core.text_area16508 = (function sablono$core$text_area16508(var_args){
var args16509 = [];
var len__5726__auto___16512 = arguments.length;
var i__5727__auto___16513 = (0);
while(true){
if((i__5727__auto___16513 < len__5726__auto___16512)){
args16509.push((arguments[i__5727__auto___16513]));

var G__16514 = (i__5727__auto___16513 + (1));
i__5727__auto___16513 = G__16514;
continue;
} else {
}
break;
}

var G__16511 = args16509.length;
switch (G__16511) {
case 1:
return sablono.core.text_area16508.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area16508.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16509.length)].join('')));

}
});

sablono.core.text_area16508.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area16508.call(null,name,null);
});

sablono.core.text_area16508.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area16508.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area16508);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label16516 = (function sablono$core$label16516(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label16516);
/**
 * Creates a submit button.
 */
sablono.core.submit_button16517 = (function sablono$core$submit_button16517(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button16517);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button16518 = (function sablono$core$reset_button16518(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button16518);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to16519 = (function sablono$core$form_to16519(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16524 = arguments.length;
var i__5727__auto___16525 = (0);
while(true){
if((i__5727__auto___16525 < len__5726__auto___16524)){
args__5733__auto__.push((arguments[i__5727__auto___16525]));

var G__16526 = (i__5727__auto___16525 + (1));
i__5727__auto___16525 = G__16526;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to16519.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to16519.cljs$core$IFn$_invoke$arity$variadic = (function (p__16522,body){
var vec__16523 = p__16522;
var method = cljs.core.nth.call(null,vec__16523,(0),null);
var action = cljs.core.nth.call(null,vec__16523,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to16519.cljs$lang$maxFixedArity = (1);

sablono.core.form_to16519.cljs$lang$applyTo = (function (seq16520){
var G__16521 = cljs.core.first.call(null,seq16520);
var seq16520__$1 = cljs.core.next.call(null,seq16520);
return sablono.core.form_to16519.cljs$core$IFn$_invoke$arity$variadic(G__16521,seq16520__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to16519);

//# sourceMappingURL=core.js.map?rel=1465203439633