// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args19006 = [];
var len__5726__auto___19012 = arguments.length;
var i__5727__auto___19013 = (0);
while(true){
if((i__5727__auto___19013 < len__5726__auto___19012)){
args19006.push((arguments[i__5727__auto___19013]));

var G__19014 = (i__5727__auto___19013 + (1));
i__5727__auto___19013 = G__19014;
continue;
} else {
}
break;
}

var G__19008 = args19006.length;
switch (G__19008) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19006.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async19009 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19009 = (function (f,blockable,meta19010){
this.f = f;
this.blockable = blockable;
this.meta19010 = meta19010;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19009.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19011,meta19010__$1){
var self__ = this;
var _19011__$1 = this;
return (new cljs.core.async.t_cljs$core$async19009(self__.f,self__.blockable,meta19010__$1));
});

cljs.core.async.t_cljs$core$async19009.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19011){
var self__ = this;
var _19011__$1 = this;
return self__.meta19010;
});

cljs.core.async.t_cljs$core$async19009.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19009.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19009.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async19009.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async19009.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta19010","meta19010",-868181501,null)], null);
});

cljs.core.async.t_cljs$core$async19009.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19009.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19009";

cljs.core.async.t_cljs$core$async19009.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19009");
});

cljs.core.async.__GT_t_cljs$core$async19009 = (function cljs$core$async$__GT_t_cljs$core$async19009(f__$1,blockable__$1,meta19010){
return (new cljs.core.async.t_cljs$core$async19009(f__$1,blockable__$1,meta19010));
});

}

return (new cljs.core.async.t_cljs$core$async19009(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args19018 = [];
var len__5726__auto___19021 = arguments.length;
var i__5727__auto___19022 = (0);
while(true){
if((i__5727__auto___19022 < len__5726__auto___19021)){
args19018.push((arguments[i__5727__auto___19022]));

var G__19023 = (i__5727__auto___19022 + (1));
i__5727__auto___19022 = G__19023;
continue;
} else {
}
break;
}

var G__19020 = args19018.length;
switch (G__19020) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19018.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args19025 = [];
var len__5726__auto___19028 = arguments.length;
var i__5727__auto___19029 = (0);
while(true){
if((i__5727__auto___19029 < len__5726__auto___19028)){
args19025.push((arguments[i__5727__auto___19029]));

var G__19030 = (i__5727__auto___19029 + (1));
i__5727__auto___19029 = G__19030;
continue;
} else {
}
break;
}

var G__19027 = args19025.length;
switch (G__19027) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19025.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args19032 = [];
var len__5726__auto___19035 = arguments.length;
var i__5727__auto___19036 = (0);
while(true){
if((i__5727__auto___19036 < len__5726__auto___19035)){
args19032.push((arguments[i__5727__auto___19036]));

var G__19037 = (i__5727__auto___19036 + (1));
i__5727__auto___19036 = G__19037;
continue;
} else {
}
break;
}

var G__19034 = args19032.length;
switch (G__19034) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19032.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_19039 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_19039);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_19039,ret){
return (function (){
return fn1.call(null,val_19039);
});})(val_19039,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args19040 = [];
var len__5726__auto___19043 = arguments.length;
var i__5727__auto___19044 = (0);
while(true){
if((i__5727__auto___19044 < len__5726__auto___19043)){
args19040.push((arguments[i__5727__auto___19044]));

var G__19045 = (i__5727__auto___19044 + (1));
i__5727__auto___19044 = G__19045;
continue;
} else {
}
break;
}

var G__19042 = args19040.length;
switch (G__19042) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19040.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___19047 = n;
var x_19048 = (0);
while(true){
if((x_19048 < n__5571__auto___19047)){
(a[x_19048] = (0));

var G__19049 = (x_19048 + (1));
x_19048 = G__19049;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__19050 = (i + (1));
i = G__19050;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async19054 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19054 = (function (alt_flag,flag,meta19055){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta19055 = meta19055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_19056,meta19055__$1){
var self__ = this;
var _19056__$1 = this;
return (new cljs.core.async.t_cljs$core$async19054(self__.alt_flag,self__.flag,meta19055__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_19056){
var self__ = this;
var _19056__$1 = this;
return self__.meta19055;
});})(flag))
;

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19054.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19055","meta19055",1439081721,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async19054.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19054.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19054";

cljs.core.async.t_cljs$core$async19054.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19054");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async19054 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19054(alt_flag__$1,flag__$1,meta19055){
return (new cljs.core.async.t_cljs$core$async19054(alt_flag__$1,flag__$1,meta19055));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async19054(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async19060 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19060 = (function (alt_handler,flag,cb,meta19061){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta19061 = meta19061;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19060.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19062,meta19061__$1){
var self__ = this;
var _19062__$1 = this;
return (new cljs.core.async.t_cljs$core$async19060(self__.alt_handler,self__.flag,self__.cb,meta19061__$1));
});

cljs.core.async.t_cljs$core$async19060.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19062){
var self__ = this;
var _19062__$1 = this;
return self__.meta19061;
});

cljs.core.async.t_cljs$core$async19060.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19060.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async19060.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19060.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async19060.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19061","meta19061",-760862821,null)], null);
});

cljs.core.async.t_cljs$core$async19060.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19060.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19060";

cljs.core.async.t_cljs$core$async19060.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19060");
});

cljs.core.async.__GT_t_cljs$core$async19060 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19060(alt_handler__$1,flag__$1,cb__$1,meta19061){
return (new cljs.core.async.t_cljs$core$async19060(alt_handler__$1,flag__$1,cb__$1,meta19061));
});

}

return (new cljs.core.async.t_cljs$core$async19060(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19063_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19063_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19064_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19064_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19065 = (i + (1));
i = G__19065;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___19071 = arguments.length;
var i__5727__auto___19072 = (0);
while(true){
if((i__5727__auto___19072 < len__5726__auto___19071)){
args__5733__auto__.push((arguments[i__5727__auto___19072]));

var G__19073 = (i__5727__auto___19072 + (1));
i__5727__auto___19072 = G__19073;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19068){
var map__19069 = p__19068;
var map__19069__$1 = ((((!((map__19069 == null)))?((((map__19069.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19069.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19069):map__19069);
var opts = map__19069__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19066){
var G__19067 = cljs.core.first.call(null,seq19066);
var seq19066__$1 = cljs.core.next.call(null,seq19066);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19067,seq19066__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args19074 = [];
var len__5726__auto___19124 = arguments.length;
var i__5727__auto___19125 = (0);
while(true){
if((i__5727__auto___19125 < len__5726__auto___19124)){
args19074.push((arguments[i__5727__auto___19125]));

var G__19126 = (i__5727__auto___19125 + (1));
i__5727__auto___19125 = G__19126;
continue;
} else {
}
break;
}

var G__19076 = args19074.length;
switch (G__19076) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19074.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11084__auto___19128 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___19128){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___19128){
return (function (state_19100){
var state_val_19101 = (state_19100[(1)]);
if((state_val_19101 === (7))){
var inst_19096 = (state_19100[(2)]);
var state_19100__$1 = state_19100;
var statearr_19102_19129 = state_19100__$1;
(statearr_19102_19129[(2)] = inst_19096);

(statearr_19102_19129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (1))){
var state_19100__$1 = state_19100;
var statearr_19103_19130 = state_19100__$1;
(statearr_19103_19130[(2)] = null);

(statearr_19103_19130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (4))){
var inst_19079 = (state_19100[(7)]);
var inst_19079__$1 = (state_19100[(2)]);
var inst_19080 = (inst_19079__$1 == null);
var state_19100__$1 = (function (){var statearr_19104 = state_19100;
(statearr_19104[(7)] = inst_19079__$1);

return statearr_19104;
})();
if(cljs.core.truth_(inst_19080)){
var statearr_19105_19131 = state_19100__$1;
(statearr_19105_19131[(1)] = (5));

} else {
var statearr_19106_19132 = state_19100__$1;
(statearr_19106_19132[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (13))){
var state_19100__$1 = state_19100;
var statearr_19107_19133 = state_19100__$1;
(statearr_19107_19133[(2)] = null);

(statearr_19107_19133[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (6))){
var inst_19079 = (state_19100[(7)]);
var state_19100__$1 = state_19100;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19100__$1,(11),to,inst_19079);
} else {
if((state_val_19101 === (3))){
var inst_19098 = (state_19100[(2)]);
var state_19100__$1 = state_19100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19100__$1,inst_19098);
} else {
if((state_val_19101 === (12))){
var state_19100__$1 = state_19100;
var statearr_19108_19134 = state_19100__$1;
(statearr_19108_19134[(2)] = null);

(statearr_19108_19134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (2))){
var state_19100__$1 = state_19100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19100__$1,(4),from);
} else {
if((state_val_19101 === (11))){
var inst_19089 = (state_19100[(2)]);
var state_19100__$1 = state_19100;
if(cljs.core.truth_(inst_19089)){
var statearr_19109_19135 = state_19100__$1;
(statearr_19109_19135[(1)] = (12));

} else {
var statearr_19110_19136 = state_19100__$1;
(statearr_19110_19136[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (9))){
var state_19100__$1 = state_19100;
var statearr_19111_19137 = state_19100__$1;
(statearr_19111_19137[(2)] = null);

(statearr_19111_19137[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (5))){
var state_19100__$1 = state_19100;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19112_19138 = state_19100__$1;
(statearr_19112_19138[(1)] = (8));

} else {
var statearr_19113_19139 = state_19100__$1;
(statearr_19113_19139[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (14))){
var inst_19094 = (state_19100[(2)]);
var state_19100__$1 = state_19100;
var statearr_19114_19140 = state_19100__$1;
(statearr_19114_19140[(2)] = inst_19094);

(statearr_19114_19140[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (10))){
var inst_19086 = (state_19100[(2)]);
var state_19100__$1 = state_19100;
var statearr_19115_19141 = state_19100__$1;
(statearr_19115_19141[(2)] = inst_19086);

(statearr_19115_19141[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19101 === (8))){
var inst_19083 = cljs.core.async.close_BANG_.call(null,to);
var state_19100__$1 = state_19100;
var statearr_19116_19142 = state_19100__$1;
(statearr_19116_19142[(2)] = inst_19083);

(statearr_19116_19142[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___19128))
;
return ((function (switch__10972__auto__,c__11084__auto___19128){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_19120 = [null,null,null,null,null,null,null,null];
(statearr_19120[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_19120[(1)] = (1));

return statearr_19120;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_19100){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19121){if((e19121 instanceof Object)){
var ex__10976__auto__ = e19121;
var statearr_19122_19143 = state_19100;
(statearr_19122_19143[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19100);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19121;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19144 = state_19100;
state_19100 = G__19144;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_19100){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_19100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___19128))
})();
var state__11086__auto__ = (function (){var statearr_19123 = f__11085__auto__.call(null);
(statearr_19123[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___19128);

return statearr_19123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___19128))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19328){
var vec__19329 = p__19328;
var v = cljs.core.nth.call(null,vec__19329,(0),null);
var p = cljs.core.nth.call(null,vec__19329,(1),null);
var job = vec__19329;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11084__auto___19511 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___19511,res,vec__19329,v,p,job,jobs,results){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___19511,res,vec__19329,v,p,job,jobs,results){
return (function (state_19334){
var state_val_19335 = (state_19334[(1)]);
if((state_val_19335 === (1))){
var state_19334__$1 = state_19334;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19334__$1,(2),res,v);
} else {
if((state_val_19335 === (2))){
var inst_19331 = (state_19334[(2)]);
var inst_19332 = cljs.core.async.close_BANG_.call(null,res);
var state_19334__$1 = (function (){var statearr_19336 = state_19334;
(statearr_19336[(7)] = inst_19331);

return statearr_19336;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19334__$1,inst_19332);
} else {
return null;
}
}
});})(c__11084__auto___19511,res,vec__19329,v,p,job,jobs,results))
;
return ((function (switch__10972__auto__,c__11084__auto___19511,res,vec__19329,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_19340 = [null,null,null,null,null,null,null,null];
(statearr_19340[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_19340[(1)] = (1));

return statearr_19340;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_19334){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19341){if((e19341 instanceof Object)){
var ex__10976__auto__ = e19341;
var statearr_19342_19512 = state_19334;
(statearr_19342_19512[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19334);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19341;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19513 = state_19334;
state_19334 = G__19513;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_19334){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_19334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___19511,res,vec__19329,v,p,job,jobs,results))
})();
var state__11086__auto__ = (function (){var statearr_19343 = f__11085__auto__.call(null);
(statearr_19343[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___19511);

return statearr_19343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___19511,res,vec__19329,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19344){
var vec__19345 = p__19344;
var v = cljs.core.nth.call(null,vec__19345,(0),null);
var p = cljs.core.nth.call(null,vec__19345,(1),null);
var job = vec__19345;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___19514 = n;
var __19515 = (0);
while(true){
if((__19515 < n__5571__auto___19514)){
var G__19346_19516 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19346_19516) {
case "compute":
var c__11084__auto___19518 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19515,c__11084__auto___19518,G__19346_19516,n__5571__auto___19514,jobs,results,process,async){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (__19515,c__11084__auto___19518,G__19346_19516,n__5571__auto___19514,jobs,results,process,async){
return (function (state_19359){
var state_val_19360 = (state_19359[(1)]);
if((state_val_19360 === (1))){
var state_19359__$1 = state_19359;
var statearr_19361_19519 = state_19359__$1;
(statearr_19361_19519[(2)] = null);

(statearr_19361_19519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19360 === (2))){
var state_19359__$1 = state_19359;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19359__$1,(4),jobs);
} else {
if((state_val_19360 === (3))){
var inst_19357 = (state_19359[(2)]);
var state_19359__$1 = state_19359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19359__$1,inst_19357);
} else {
if((state_val_19360 === (4))){
var inst_19349 = (state_19359[(2)]);
var inst_19350 = process.call(null,inst_19349);
var state_19359__$1 = state_19359;
if(cljs.core.truth_(inst_19350)){
var statearr_19362_19520 = state_19359__$1;
(statearr_19362_19520[(1)] = (5));

} else {
var statearr_19363_19521 = state_19359__$1;
(statearr_19363_19521[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19360 === (5))){
var state_19359__$1 = state_19359;
var statearr_19364_19522 = state_19359__$1;
(statearr_19364_19522[(2)] = null);

(statearr_19364_19522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19360 === (6))){
var state_19359__$1 = state_19359;
var statearr_19365_19523 = state_19359__$1;
(statearr_19365_19523[(2)] = null);

(statearr_19365_19523[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19360 === (7))){
var inst_19355 = (state_19359[(2)]);
var state_19359__$1 = state_19359;
var statearr_19366_19524 = state_19359__$1;
(statearr_19366_19524[(2)] = inst_19355);

(statearr_19366_19524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19515,c__11084__auto___19518,G__19346_19516,n__5571__auto___19514,jobs,results,process,async))
;
return ((function (__19515,switch__10972__auto__,c__11084__auto___19518,G__19346_19516,n__5571__auto___19514,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_19370 = [null,null,null,null,null,null,null];
(statearr_19370[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_19370[(1)] = (1));

return statearr_19370;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_19359){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19371){if((e19371 instanceof Object)){
var ex__10976__auto__ = e19371;
var statearr_19372_19525 = state_19359;
(statearr_19372_19525[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19359);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19371;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19526 = state_19359;
state_19359 = G__19526;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_19359){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_19359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(__19515,switch__10972__auto__,c__11084__auto___19518,G__19346_19516,n__5571__auto___19514,jobs,results,process,async))
})();
var state__11086__auto__ = (function (){var statearr_19373 = f__11085__auto__.call(null);
(statearr_19373[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___19518);

return statearr_19373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(__19515,c__11084__auto___19518,G__19346_19516,n__5571__auto___19514,jobs,results,process,async))
);


break;
case "async":
var c__11084__auto___19527 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19515,c__11084__auto___19527,G__19346_19516,n__5571__auto___19514,jobs,results,process,async){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (__19515,c__11084__auto___19527,G__19346_19516,n__5571__auto___19514,jobs,results,process,async){
return (function (state_19386){
var state_val_19387 = (state_19386[(1)]);
if((state_val_19387 === (1))){
var state_19386__$1 = state_19386;
var statearr_19388_19528 = state_19386__$1;
(statearr_19388_19528[(2)] = null);

(statearr_19388_19528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (2))){
var state_19386__$1 = state_19386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19386__$1,(4),jobs);
} else {
if((state_val_19387 === (3))){
var inst_19384 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19386__$1,inst_19384);
} else {
if((state_val_19387 === (4))){
var inst_19376 = (state_19386[(2)]);
var inst_19377 = async.call(null,inst_19376);
var state_19386__$1 = state_19386;
if(cljs.core.truth_(inst_19377)){
var statearr_19389_19529 = state_19386__$1;
(statearr_19389_19529[(1)] = (5));

} else {
var statearr_19390_19530 = state_19386__$1;
(statearr_19390_19530[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (5))){
var state_19386__$1 = state_19386;
var statearr_19391_19531 = state_19386__$1;
(statearr_19391_19531[(2)] = null);

(statearr_19391_19531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (6))){
var state_19386__$1 = state_19386;
var statearr_19392_19532 = state_19386__$1;
(statearr_19392_19532[(2)] = null);

(statearr_19392_19532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19387 === (7))){
var inst_19382 = (state_19386[(2)]);
var state_19386__$1 = state_19386;
var statearr_19393_19533 = state_19386__$1;
(statearr_19393_19533[(2)] = inst_19382);

(statearr_19393_19533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19515,c__11084__auto___19527,G__19346_19516,n__5571__auto___19514,jobs,results,process,async))
;
return ((function (__19515,switch__10972__auto__,c__11084__auto___19527,G__19346_19516,n__5571__auto___19514,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_19397 = [null,null,null,null,null,null,null];
(statearr_19397[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_19397[(1)] = (1));

return statearr_19397;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_19386){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19398){if((e19398 instanceof Object)){
var ex__10976__auto__ = e19398;
var statearr_19399_19534 = state_19386;
(statearr_19399_19534[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19386);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19398;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19535 = state_19386;
state_19386 = G__19535;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_19386){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_19386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(__19515,switch__10972__auto__,c__11084__auto___19527,G__19346_19516,n__5571__auto___19514,jobs,results,process,async))
})();
var state__11086__auto__ = (function (){var statearr_19400 = f__11085__auto__.call(null);
(statearr_19400[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___19527);

return statearr_19400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(__19515,c__11084__auto___19527,G__19346_19516,n__5571__auto___19514,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19536 = (__19515 + (1));
__19515 = G__19536;
continue;
} else {
}
break;
}

var c__11084__auto___19537 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___19537,jobs,results,process,async){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___19537,jobs,results,process,async){
return (function (state_19422){
var state_val_19423 = (state_19422[(1)]);
if((state_val_19423 === (1))){
var state_19422__$1 = state_19422;
var statearr_19424_19538 = state_19422__$1;
(statearr_19424_19538[(2)] = null);

(statearr_19424_19538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19423 === (2))){
var state_19422__$1 = state_19422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19422__$1,(4),from);
} else {
if((state_val_19423 === (3))){
var inst_19420 = (state_19422[(2)]);
var state_19422__$1 = state_19422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19422__$1,inst_19420);
} else {
if((state_val_19423 === (4))){
var inst_19403 = (state_19422[(7)]);
var inst_19403__$1 = (state_19422[(2)]);
var inst_19404 = (inst_19403__$1 == null);
var state_19422__$1 = (function (){var statearr_19425 = state_19422;
(statearr_19425[(7)] = inst_19403__$1);

return statearr_19425;
})();
if(cljs.core.truth_(inst_19404)){
var statearr_19426_19539 = state_19422__$1;
(statearr_19426_19539[(1)] = (5));

} else {
var statearr_19427_19540 = state_19422__$1;
(statearr_19427_19540[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19423 === (5))){
var inst_19406 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19422__$1 = state_19422;
var statearr_19428_19541 = state_19422__$1;
(statearr_19428_19541[(2)] = inst_19406);

(statearr_19428_19541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19423 === (6))){
var inst_19403 = (state_19422[(7)]);
var inst_19408 = (state_19422[(8)]);
var inst_19408__$1 = cljs.core.async.chan.call(null,(1));
var inst_19409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19410 = [inst_19403,inst_19408__$1];
var inst_19411 = (new cljs.core.PersistentVector(null,2,(5),inst_19409,inst_19410,null));
var state_19422__$1 = (function (){var statearr_19429 = state_19422;
(statearr_19429[(8)] = inst_19408__$1);

return statearr_19429;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19422__$1,(8),jobs,inst_19411);
} else {
if((state_val_19423 === (7))){
var inst_19418 = (state_19422[(2)]);
var state_19422__$1 = state_19422;
var statearr_19430_19542 = state_19422__$1;
(statearr_19430_19542[(2)] = inst_19418);

(statearr_19430_19542[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19423 === (8))){
var inst_19408 = (state_19422[(8)]);
var inst_19413 = (state_19422[(2)]);
var state_19422__$1 = (function (){var statearr_19431 = state_19422;
(statearr_19431[(9)] = inst_19413);

return statearr_19431;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19422__$1,(9),results,inst_19408);
} else {
if((state_val_19423 === (9))){
var inst_19415 = (state_19422[(2)]);
var state_19422__$1 = (function (){var statearr_19432 = state_19422;
(statearr_19432[(10)] = inst_19415);

return statearr_19432;
})();
var statearr_19433_19543 = state_19422__$1;
(statearr_19433_19543[(2)] = null);

(statearr_19433_19543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___19537,jobs,results,process,async))
;
return ((function (switch__10972__auto__,c__11084__auto___19537,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_19437 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19437[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_19437[(1)] = (1));

return statearr_19437;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_19422){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19438){if((e19438 instanceof Object)){
var ex__10976__auto__ = e19438;
var statearr_19439_19544 = state_19422;
(statearr_19439_19544[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19422);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19438;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19545 = state_19422;
state_19422 = G__19545;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_19422){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_19422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___19537,jobs,results,process,async))
})();
var state__11086__auto__ = (function (){var statearr_19440 = f__11085__auto__.call(null);
(statearr_19440[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___19537);

return statearr_19440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___19537,jobs,results,process,async))
);


var c__11084__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto__,jobs,results,process,async){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto__,jobs,results,process,async){
return (function (state_19478){
var state_val_19479 = (state_19478[(1)]);
if((state_val_19479 === (7))){
var inst_19474 = (state_19478[(2)]);
var state_19478__$1 = state_19478;
var statearr_19480_19546 = state_19478__$1;
(statearr_19480_19546[(2)] = inst_19474);

(statearr_19480_19546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (20))){
var state_19478__$1 = state_19478;
var statearr_19481_19547 = state_19478__$1;
(statearr_19481_19547[(2)] = null);

(statearr_19481_19547[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (1))){
var state_19478__$1 = state_19478;
var statearr_19482_19548 = state_19478__$1;
(statearr_19482_19548[(2)] = null);

(statearr_19482_19548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (4))){
var inst_19443 = (state_19478[(7)]);
var inst_19443__$1 = (state_19478[(2)]);
var inst_19444 = (inst_19443__$1 == null);
var state_19478__$1 = (function (){var statearr_19483 = state_19478;
(statearr_19483[(7)] = inst_19443__$1);

return statearr_19483;
})();
if(cljs.core.truth_(inst_19444)){
var statearr_19484_19549 = state_19478__$1;
(statearr_19484_19549[(1)] = (5));

} else {
var statearr_19485_19550 = state_19478__$1;
(statearr_19485_19550[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (15))){
var inst_19456 = (state_19478[(8)]);
var state_19478__$1 = state_19478;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19478__$1,(18),to,inst_19456);
} else {
if((state_val_19479 === (21))){
var inst_19469 = (state_19478[(2)]);
var state_19478__$1 = state_19478;
var statearr_19486_19551 = state_19478__$1;
(statearr_19486_19551[(2)] = inst_19469);

(statearr_19486_19551[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (13))){
var inst_19471 = (state_19478[(2)]);
var state_19478__$1 = (function (){var statearr_19487 = state_19478;
(statearr_19487[(9)] = inst_19471);

return statearr_19487;
})();
var statearr_19488_19552 = state_19478__$1;
(statearr_19488_19552[(2)] = null);

(statearr_19488_19552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (6))){
var inst_19443 = (state_19478[(7)]);
var state_19478__$1 = state_19478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19478__$1,(11),inst_19443);
} else {
if((state_val_19479 === (17))){
var inst_19464 = (state_19478[(2)]);
var state_19478__$1 = state_19478;
if(cljs.core.truth_(inst_19464)){
var statearr_19489_19553 = state_19478__$1;
(statearr_19489_19553[(1)] = (19));

} else {
var statearr_19490_19554 = state_19478__$1;
(statearr_19490_19554[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (3))){
var inst_19476 = (state_19478[(2)]);
var state_19478__$1 = state_19478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19478__$1,inst_19476);
} else {
if((state_val_19479 === (12))){
var inst_19453 = (state_19478[(10)]);
var state_19478__$1 = state_19478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19478__$1,(14),inst_19453);
} else {
if((state_val_19479 === (2))){
var state_19478__$1 = state_19478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19478__$1,(4),results);
} else {
if((state_val_19479 === (19))){
var state_19478__$1 = state_19478;
var statearr_19491_19555 = state_19478__$1;
(statearr_19491_19555[(2)] = null);

(statearr_19491_19555[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (11))){
var inst_19453 = (state_19478[(2)]);
var state_19478__$1 = (function (){var statearr_19492 = state_19478;
(statearr_19492[(10)] = inst_19453);

return statearr_19492;
})();
var statearr_19493_19556 = state_19478__$1;
(statearr_19493_19556[(2)] = null);

(statearr_19493_19556[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (9))){
var state_19478__$1 = state_19478;
var statearr_19494_19557 = state_19478__$1;
(statearr_19494_19557[(2)] = null);

(statearr_19494_19557[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (5))){
var state_19478__$1 = state_19478;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19495_19558 = state_19478__$1;
(statearr_19495_19558[(1)] = (8));

} else {
var statearr_19496_19559 = state_19478__$1;
(statearr_19496_19559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (14))){
var inst_19456 = (state_19478[(8)]);
var inst_19458 = (state_19478[(11)]);
var inst_19456__$1 = (state_19478[(2)]);
var inst_19457 = (inst_19456__$1 == null);
var inst_19458__$1 = cljs.core.not.call(null,inst_19457);
var state_19478__$1 = (function (){var statearr_19497 = state_19478;
(statearr_19497[(8)] = inst_19456__$1);

(statearr_19497[(11)] = inst_19458__$1);

return statearr_19497;
})();
if(inst_19458__$1){
var statearr_19498_19560 = state_19478__$1;
(statearr_19498_19560[(1)] = (15));

} else {
var statearr_19499_19561 = state_19478__$1;
(statearr_19499_19561[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (16))){
var inst_19458 = (state_19478[(11)]);
var state_19478__$1 = state_19478;
var statearr_19500_19562 = state_19478__$1;
(statearr_19500_19562[(2)] = inst_19458);

(statearr_19500_19562[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (10))){
var inst_19450 = (state_19478[(2)]);
var state_19478__$1 = state_19478;
var statearr_19501_19563 = state_19478__$1;
(statearr_19501_19563[(2)] = inst_19450);

(statearr_19501_19563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (18))){
var inst_19461 = (state_19478[(2)]);
var state_19478__$1 = state_19478;
var statearr_19502_19564 = state_19478__$1;
(statearr_19502_19564[(2)] = inst_19461);

(statearr_19502_19564[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19479 === (8))){
var inst_19447 = cljs.core.async.close_BANG_.call(null,to);
var state_19478__$1 = state_19478;
var statearr_19503_19565 = state_19478__$1;
(statearr_19503_19565[(2)] = inst_19447);

(statearr_19503_19565[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto__,jobs,results,process,async))
;
return ((function (switch__10972__auto__,c__11084__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_19507 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19507[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_19507[(1)] = (1));

return statearr_19507;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_19478){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19508){if((e19508 instanceof Object)){
var ex__10976__auto__ = e19508;
var statearr_19509_19566 = state_19478;
(statearr_19509_19566[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19478);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19567 = state_19478;
state_19478 = G__19567;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_19478){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_19478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto__,jobs,results,process,async))
})();
var state__11086__auto__ = (function (){var statearr_19510 = f__11085__auto__.call(null);
(statearr_19510[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto__);

return statearr_19510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto__,jobs,results,process,async))
);

return c__11084__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19568 = [];
var len__5726__auto___19571 = arguments.length;
var i__5727__auto___19572 = (0);
while(true){
if((i__5727__auto___19572 < len__5726__auto___19571)){
args19568.push((arguments[i__5727__auto___19572]));

var G__19573 = (i__5727__auto___19572 + (1));
i__5727__auto___19572 = G__19573;
continue;
} else {
}
break;
}

var G__19570 = args19568.length;
switch (G__19570) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19568.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19575 = [];
var len__5726__auto___19578 = arguments.length;
var i__5727__auto___19579 = (0);
while(true){
if((i__5727__auto___19579 < len__5726__auto___19578)){
args19575.push((arguments[i__5727__auto___19579]));

var G__19580 = (i__5727__auto___19579 + (1));
i__5727__auto___19579 = G__19580;
continue;
} else {
}
break;
}

var G__19577 = args19575.length;
switch (G__19577) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19575.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19582 = [];
var len__5726__auto___19635 = arguments.length;
var i__5727__auto___19636 = (0);
while(true){
if((i__5727__auto___19636 < len__5726__auto___19635)){
args19582.push((arguments[i__5727__auto___19636]));

var G__19637 = (i__5727__auto___19636 + (1));
i__5727__auto___19636 = G__19637;
continue;
} else {
}
break;
}

var G__19584 = args19582.length;
switch (G__19584) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19582.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11084__auto___19639 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___19639,tc,fc){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___19639,tc,fc){
return (function (state_19610){
var state_val_19611 = (state_19610[(1)]);
if((state_val_19611 === (7))){
var inst_19606 = (state_19610[(2)]);
var state_19610__$1 = state_19610;
var statearr_19612_19640 = state_19610__$1;
(statearr_19612_19640[(2)] = inst_19606);

(statearr_19612_19640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (1))){
var state_19610__$1 = state_19610;
var statearr_19613_19641 = state_19610__$1;
(statearr_19613_19641[(2)] = null);

(statearr_19613_19641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (4))){
var inst_19587 = (state_19610[(7)]);
var inst_19587__$1 = (state_19610[(2)]);
var inst_19588 = (inst_19587__$1 == null);
var state_19610__$1 = (function (){var statearr_19614 = state_19610;
(statearr_19614[(7)] = inst_19587__$1);

return statearr_19614;
})();
if(cljs.core.truth_(inst_19588)){
var statearr_19615_19642 = state_19610__$1;
(statearr_19615_19642[(1)] = (5));

} else {
var statearr_19616_19643 = state_19610__$1;
(statearr_19616_19643[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (13))){
var state_19610__$1 = state_19610;
var statearr_19617_19644 = state_19610__$1;
(statearr_19617_19644[(2)] = null);

(statearr_19617_19644[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (6))){
var inst_19587 = (state_19610[(7)]);
var inst_19593 = p.call(null,inst_19587);
var state_19610__$1 = state_19610;
if(cljs.core.truth_(inst_19593)){
var statearr_19618_19645 = state_19610__$1;
(statearr_19618_19645[(1)] = (9));

} else {
var statearr_19619_19646 = state_19610__$1;
(statearr_19619_19646[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (3))){
var inst_19608 = (state_19610[(2)]);
var state_19610__$1 = state_19610;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19610__$1,inst_19608);
} else {
if((state_val_19611 === (12))){
var state_19610__$1 = state_19610;
var statearr_19620_19647 = state_19610__$1;
(statearr_19620_19647[(2)] = null);

(statearr_19620_19647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (2))){
var state_19610__$1 = state_19610;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19610__$1,(4),ch);
} else {
if((state_val_19611 === (11))){
var inst_19587 = (state_19610[(7)]);
var inst_19597 = (state_19610[(2)]);
var state_19610__$1 = state_19610;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19610__$1,(8),inst_19597,inst_19587);
} else {
if((state_val_19611 === (9))){
var state_19610__$1 = state_19610;
var statearr_19621_19648 = state_19610__$1;
(statearr_19621_19648[(2)] = tc);

(statearr_19621_19648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (5))){
var inst_19590 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19591 = cljs.core.async.close_BANG_.call(null,fc);
var state_19610__$1 = (function (){var statearr_19622 = state_19610;
(statearr_19622[(8)] = inst_19590);

return statearr_19622;
})();
var statearr_19623_19649 = state_19610__$1;
(statearr_19623_19649[(2)] = inst_19591);

(statearr_19623_19649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (14))){
var inst_19604 = (state_19610[(2)]);
var state_19610__$1 = state_19610;
var statearr_19624_19650 = state_19610__$1;
(statearr_19624_19650[(2)] = inst_19604);

(statearr_19624_19650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (10))){
var state_19610__$1 = state_19610;
var statearr_19625_19651 = state_19610__$1;
(statearr_19625_19651[(2)] = fc);

(statearr_19625_19651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19611 === (8))){
var inst_19599 = (state_19610[(2)]);
var state_19610__$1 = state_19610;
if(cljs.core.truth_(inst_19599)){
var statearr_19626_19652 = state_19610__$1;
(statearr_19626_19652[(1)] = (12));

} else {
var statearr_19627_19653 = state_19610__$1;
(statearr_19627_19653[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___19639,tc,fc))
;
return ((function (switch__10972__auto__,c__11084__auto___19639,tc,fc){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_19631 = [null,null,null,null,null,null,null,null,null];
(statearr_19631[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_19631[(1)] = (1));

return statearr_19631;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_19610){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19610);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19632){if((e19632 instanceof Object)){
var ex__10976__auto__ = e19632;
var statearr_19633_19654 = state_19610;
(statearr_19633_19654[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19610);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19632;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19655 = state_19610;
state_19610 = G__19655;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_19610){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_19610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___19639,tc,fc))
})();
var state__11086__auto__ = (function (){var statearr_19634 = f__11085__auto__.call(null);
(statearr_19634[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___19639);

return statearr_19634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___19639,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11084__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto__){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto__){
return (function (state_19719){
var state_val_19720 = (state_19719[(1)]);
if((state_val_19720 === (7))){
var inst_19715 = (state_19719[(2)]);
var state_19719__$1 = state_19719;
var statearr_19721_19742 = state_19719__$1;
(statearr_19721_19742[(2)] = inst_19715);

(statearr_19721_19742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (1))){
var inst_19699 = init;
var state_19719__$1 = (function (){var statearr_19722 = state_19719;
(statearr_19722[(7)] = inst_19699);

return statearr_19722;
})();
var statearr_19723_19743 = state_19719__$1;
(statearr_19723_19743[(2)] = null);

(statearr_19723_19743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (4))){
var inst_19702 = (state_19719[(8)]);
var inst_19702__$1 = (state_19719[(2)]);
var inst_19703 = (inst_19702__$1 == null);
var state_19719__$1 = (function (){var statearr_19724 = state_19719;
(statearr_19724[(8)] = inst_19702__$1);

return statearr_19724;
})();
if(cljs.core.truth_(inst_19703)){
var statearr_19725_19744 = state_19719__$1;
(statearr_19725_19744[(1)] = (5));

} else {
var statearr_19726_19745 = state_19719__$1;
(statearr_19726_19745[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (6))){
var inst_19702 = (state_19719[(8)]);
var inst_19706 = (state_19719[(9)]);
var inst_19699 = (state_19719[(7)]);
var inst_19706__$1 = f.call(null,inst_19699,inst_19702);
var inst_19707 = cljs.core.reduced_QMARK_.call(null,inst_19706__$1);
var state_19719__$1 = (function (){var statearr_19727 = state_19719;
(statearr_19727[(9)] = inst_19706__$1);

return statearr_19727;
})();
if(inst_19707){
var statearr_19728_19746 = state_19719__$1;
(statearr_19728_19746[(1)] = (8));

} else {
var statearr_19729_19747 = state_19719__$1;
(statearr_19729_19747[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (3))){
var inst_19717 = (state_19719[(2)]);
var state_19719__$1 = state_19719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19719__$1,inst_19717);
} else {
if((state_val_19720 === (2))){
var state_19719__$1 = state_19719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19719__$1,(4),ch);
} else {
if((state_val_19720 === (9))){
var inst_19706 = (state_19719[(9)]);
var inst_19699 = inst_19706;
var state_19719__$1 = (function (){var statearr_19730 = state_19719;
(statearr_19730[(7)] = inst_19699);

return statearr_19730;
})();
var statearr_19731_19748 = state_19719__$1;
(statearr_19731_19748[(2)] = null);

(statearr_19731_19748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (5))){
var inst_19699 = (state_19719[(7)]);
var state_19719__$1 = state_19719;
var statearr_19732_19749 = state_19719__$1;
(statearr_19732_19749[(2)] = inst_19699);

(statearr_19732_19749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (10))){
var inst_19713 = (state_19719[(2)]);
var state_19719__$1 = state_19719;
var statearr_19733_19750 = state_19719__$1;
(statearr_19733_19750[(2)] = inst_19713);

(statearr_19733_19750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (8))){
var inst_19706 = (state_19719[(9)]);
var inst_19709 = cljs.core.deref.call(null,inst_19706);
var state_19719__$1 = state_19719;
var statearr_19734_19751 = state_19719__$1;
(statearr_19734_19751[(2)] = inst_19709);

(statearr_19734_19751[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto__))
;
return ((function (switch__10972__auto__,c__11084__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10973__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10973__auto____0 = (function (){
var statearr_19738 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19738[(0)] = cljs$core$async$reduce_$_state_machine__10973__auto__);

(statearr_19738[(1)] = (1));

return statearr_19738;
});
var cljs$core$async$reduce_$_state_machine__10973__auto____1 = (function (state_19719){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19739){if((e19739 instanceof Object)){
var ex__10976__auto__ = e19739;
var statearr_19740_19752 = state_19719;
(statearr_19740_19752[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19719);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19739;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19753 = state_19719;
state_19719 = G__19753;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10973__auto__ = function(state_19719){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10973__auto____1.call(this,state_19719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10973__auto____0;
cljs$core$async$reduce_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10973__auto____1;
return cljs$core$async$reduce_$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto__))
})();
var state__11086__auto__ = (function (){var statearr_19741 = f__11085__auto__.call(null);
(statearr_19741[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto__);

return statearr_19741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto__))
);

return c__11084__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19754 = [];
var len__5726__auto___19806 = arguments.length;
var i__5727__auto___19807 = (0);
while(true){
if((i__5727__auto___19807 < len__5726__auto___19806)){
args19754.push((arguments[i__5727__auto___19807]));

var G__19808 = (i__5727__auto___19807 + (1));
i__5727__auto___19807 = G__19808;
continue;
} else {
}
break;
}

var G__19756 = args19754.length;
switch (G__19756) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19754.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11084__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto__){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto__){
return (function (state_19781){
var state_val_19782 = (state_19781[(1)]);
if((state_val_19782 === (7))){
var inst_19763 = (state_19781[(2)]);
var state_19781__$1 = state_19781;
var statearr_19783_19810 = state_19781__$1;
(statearr_19783_19810[(2)] = inst_19763);

(statearr_19783_19810[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (1))){
var inst_19757 = cljs.core.seq.call(null,coll);
var inst_19758 = inst_19757;
var state_19781__$1 = (function (){var statearr_19784 = state_19781;
(statearr_19784[(7)] = inst_19758);

return statearr_19784;
})();
var statearr_19785_19811 = state_19781__$1;
(statearr_19785_19811[(2)] = null);

(statearr_19785_19811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (4))){
var inst_19758 = (state_19781[(7)]);
var inst_19761 = cljs.core.first.call(null,inst_19758);
var state_19781__$1 = state_19781;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19781__$1,(7),ch,inst_19761);
} else {
if((state_val_19782 === (13))){
var inst_19775 = (state_19781[(2)]);
var state_19781__$1 = state_19781;
var statearr_19786_19812 = state_19781__$1;
(statearr_19786_19812[(2)] = inst_19775);

(statearr_19786_19812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (6))){
var inst_19766 = (state_19781[(2)]);
var state_19781__$1 = state_19781;
if(cljs.core.truth_(inst_19766)){
var statearr_19787_19813 = state_19781__$1;
(statearr_19787_19813[(1)] = (8));

} else {
var statearr_19788_19814 = state_19781__$1;
(statearr_19788_19814[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (3))){
var inst_19779 = (state_19781[(2)]);
var state_19781__$1 = state_19781;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19781__$1,inst_19779);
} else {
if((state_val_19782 === (12))){
var state_19781__$1 = state_19781;
var statearr_19789_19815 = state_19781__$1;
(statearr_19789_19815[(2)] = null);

(statearr_19789_19815[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (2))){
var inst_19758 = (state_19781[(7)]);
var state_19781__$1 = state_19781;
if(cljs.core.truth_(inst_19758)){
var statearr_19790_19816 = state_19781__$1;
(statearr_19790_19816[(1)] = (4));

} else {
var statearr_19791_19817 = state_19781__$1;
(statearr_19791_19817[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (11))){
var inst_19772 = cljs.core.async.close_BANG_.call(null,ch);
var state_19781__$1 = state_19781;
var statearr_19792_19818 = state_19781__$1;
(statearr_19792_19818[(2)] = inst_19772);

(statearr_19792_19818[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (9))){
var state_19781__$1 = state_19781;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19793_19819 = state_19781__$1;
(statearr_19793_19819[(1)] = (11));

} else {
var statearr_19794_19820 = state_19781__$1;
(statearr_19794_19820[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (5))){
var inst_19758 = (state_19781[(7)]);
var state_19781__$1 = state_19781;
var statearr_19795_19821 = state_19781__$1;
(statearr_19795_19821[(2)] = inst_19758);

(statearr_19795_19821[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (10))){
var inst_19777 = (state_19781[(2)]);
var state_19781__$1 = state_19781;
var statearr_19796_19822 = state_19781__$1;
(statearr_19796_19822[(2)] = inst_19777);

(statearr_19796_19822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19782 === (8))){
var inst_19758 = (state_19781[(7)]);
var inst_19768 = cljs.core.next.call(null,inst_19758);
var inst_19758__$1 = inst_19768;
var state_19781__$1 = (function (){var statearr_19797 = state_19781;
(statearr_19797[(7)] = inst_19758__$1);

return statearr_19797;
})();
var statearr_19798_19823 = state_19781__$1;
(statearr_19798_19823[(2)] = null);

(statearr_19798_19823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto__))
;
return ((function (switch__10972__auto__,c__11084__auto__){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_19802 = [null,null,null,null,null,null,null,null];
(statearr_19802[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_19802[(1)] = (1));

return statearr_19802;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_19781){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_19781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e19803){if((e19803 instanceof Object)){
var ex__10976__auto__ = e19803;
var statearr_19804_19824 = state_19781;
(statearr_19804_19824[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19781);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19803;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19825 = state_19781;
state_19781 = G__19825;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_19781){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_19781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto__))
})();
var state__11086__auto__ = (function (){var statearr_19805 = f__11085__auto__.call(null);
(statearr_19805[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto__);

return statearr_19805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto__))
);

return c__11084__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20047 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20047 = (function (mult,ch,cs,meta20048){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta20048 = meta20048;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20047.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_20049,meta20048__$1){
var self__ = this;
var _20049__$1 = this;
return (new cljs.core.async.t_cljs$core$async20047(self__.mult,self__.ch,self__.cs,meta20048__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async20047.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_20049){
var self__ = this;
var _20049__$1 = this;
return self__.meta20048;
});})(cs))
;

cljs.core.async.t_cljs$core$async20047.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20047.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async20047.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async20047.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20047.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20047.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20047.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20048","meta20048",-1477265031,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async20047.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20047.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20047";

cljs.core.async.t_cljs$core$async20047.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20047");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async20047 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async20047(mult__$1,ch__$1,cs__$1,meta20048){
return (new cljs.core.async.t_cljs$core$async20047(mult__$1,ch__$1,cs__$1,meta20048));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async20047(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11084__auto___20268 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___20268,cs,m,dchan,dctr,done){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___20268,cs,m,dchan,dctr,done){
return (function (state_20180){
var state_val_20181 = (state_20180[(1)]);
if((state_val_20181 === (7))){
var inst_20176 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20182_20269 = state_20180__$1;
(statearr_20182_20269[(2)] = inst_20176);

(statearr_20182_20269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (20))){
var inst_20081 = (state_20180[(7)]);
var inst_20091 = cljs.core.first.call(null,inst_20081);
var inst_20092 = cljs.core.nth.call(null,inst_20091,(0),null);
var inst_20093 = cljs.core.nth.call(null,inst_20091,(1),null);
var state_20180__$1 = (function (){var statearr_20183 = state_20180;
(statearr_20183[(8)] = inst_20092);

return statearr_20183;
})();
if(cljs.core.truth_(inst_20093)){
var statearr_20184_20270 = state_20180__$1;
(statearr_20184_20270[(1)] = (22));

} else {
var statearr_20185_20271 = state_20180__$1;
(statearr_20185_20271[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (27))){
var inst_20128 = (state_20180[(9)]);
var inst_20121 = (state_20180[(10)]);
var inst_20052 = (state_20180[(11)]);
var inst_20123 = (state_20180[(12)]);
var inst_20128__$1 = cljs.core._nth.call(null,inst_20121,inst_20123);
var inst_20129 = cljs.core.async.put_BANG_.call(null,inst_20128__$1,inst_20052,done);
var state_20180__$1 = (function (){var statearr_20186 = state_20180;
(statearr_20186[(9)] = inst_20128__$1);

return statearr_20186;
})();
if(cljs.core.truth_(inst_20129)){
var statearr_20187_20272 = state_20180__$1;
(statearr_20187_20272[(1)] = (30));

} else {
var statearr_20188_20273 = state_20180__$1;
(statearr_20188_20273[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (1))){
var state_20180__$1 = state_20180;
var statearr_20189_20274 = state_20180__$1;
(statearr_20189_20274[(2)] = null);

(statearr_20189_20274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (24))){
var inst_20081 = (state_20180[(7)]);
var inst_20098 = (state_20180[(2)]);
var inst_20099 = cljs.core.next.call(null,inst_20081);
var inst_20061 = inst_20099;
var inst_20062 = null;
var inst_20063 = (0);
var inst_20064 = (0);
var state_20180__$1 = (function (){var statearr_20190 = state_20180;
(statearr_20190[(13)] = inst_20063);

(statearr_20190[(14)] = inst_20062);

(statearr_20190[(15)] = inst_20098);

(statearr_20190[(16)] = inst_20061);

(statearr_20190[(17)] = inst_20064);

return statearr_20190;
})();
var statearr_20191_20275 = state_20180__$1;
(statearr_20191_20275[(2)] = null);

(statearr_20191_20275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (39))){
var state_20180__$1 = state_20180;
var statearr_20195_20276 = state_20180__$1;
(statearr_20195_20276[(2)] = null);

(statearr_20195_20276[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (4))){
var inst_20052 = (state_20180[(11)]);
var inst_20052__$1 = (state_20180[(2)]);
var inst_20053 = (inst_20052__$1 == null);
var state_20180__$1 = (function (){var statearr_20196 = state_20180;
(statearr_20196[(11)] = inst_20052__$1);

return statearr_20196;
})();
if(cljs.core.truth_(inst_20053)){
var statearr_20197_20277 = state_20180__$1;
(statearr_20197_20277[(1)] = (5));

} else {
var statearr_20198_20278 = state_20180__$1;
(statearr_20198_20278[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (15))){
var inst_20063 = (state_20180[(13)]);
var inst_20062 = (state_20180[(14)]);
var inst_20061 = (state_20180[(16)]);
var inst_20064 = (state_20180[(17)]);
var inst_20077 = (state_20180[(2)]);
var inst_20078 = (inst_20064 + (1));
var tmp20192 = inst_20063;
var tmp20193 = inst_20062;
var tmp20194 = inst_20061;
var inst_20061__$1 = tmp20194;
var inst_20062__$1 = tmp20193;
var inst_20063__$1 = tmp20192;
var inst_20064__$1 = inst_20078;
var state_20180__$1 = (function (){var statearr_20199 = state_20180;
(statearr_20199[(13)] = inst_20063__$1);

(statearr_20199[(18)] = inst_20077);

(statearr_20199[(14)] = inst_20062__$1);

(statearr_20199[(16)] = inst_20061__$1);

(statearr_20199[(17)] = inst_20064__$1);

return statearr_20199;
})();
var statearr_20200_20279 = state_20180__$1;
(statearr_20200_20279[(2)] = null);

(statearr_20200_20279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (21))){
var inst_20102 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20204_20280 = state_20180__$1;
(statearr_20204_20280[(2)] = inst_20102);

(statearr_20204_20280[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (31))){
var inst_20128 = (state_20180[(9)]);
var inst_20132 = done.call(null,null);
var inst_20133 = cljs.core.async.untap_STAR_.call(null,m,inst_20128);
var state_20180__$1 = (function (){var statearr_20205 = state_20180;
(statearr_20205[(19)] = inst_20132);

return statearr_20205;
})();
var statearr_20206_20281 = state_20180__$1;
(statearr_20206_20281[(2)] = inst_20133);

(statearr_20206_20281[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (32))){
var inst_20122 = (state_20180[(20)]);
var inst_20121 = (state_20180[(10)]);
var inst_20120 = (state_20180[(21)]);
var inst_20123 = (state_20180[(12)]);
var inst_20135 = (state_20180[(2)]);
var inst_20136 = (inst_20123 + (1));
var tmp20201 = inst_20122;
var tmp20202 = inst_20121;
var tmp20203 = inst_20120;
var inst_20120__$1 = tmp20203;
var inst_20121__$1 = tmp20202;
var inst_20122__$1 = tmp20201;
var inst_20123__$1 = inst_20136;
var state_20180__$1 = (function (){var statearr_20207 = state_20180;
(statearr_20207[(20)] = inst_20122__$1);

(statearr_20207[(22)] = inst_20135);

(statearr_20207[(10)] = inst_20121__$1);

(statearr_20207[(21)] = inst_20120__$1);

(statearr_20207[(12)] = inst_20123__$1);

return statearr_20207;
})();
var statearr_20208_20282 = state_20180__$1;
(statearr_20208_20282[(2)] = null);

(statearr_20208_20282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (40))){
var inst_20148 = (state_20180[(23)]);
var inst_20152 = done.call(null,null);
var inst_20153 = cljs.core.async.untap_STAR_.call(null,m,inst_20148);
var state_20180__$1 = (function (){var statearr_20209 = state_20180;
(statearr_20209[(24)] = inst_20152);

return statearr_20209;
})();
var statearr_20210_20283 = state_20180__$1;
(statearr_20210_20283[(2)] = inst_20153);

(statearr_20210_20283[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (33))){
var inst_20139 = (state_20180[(25)]);
var inst_20141 = cljs.core.chunked_seq_QMARK_.call(null,inst_20139);
var state_20180__$1 = state_20180;
if(inst_20141){
var statearr_20211_20284 = state_20180__$1;
(statearr_20211_20284[(1)] = (36));

} else {
var statearr_20212_20285 = state_20180__$1;
(statearr_20212_20285[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (13))){
var inst_20071 = (state_20180[(26)]);
var inst_20074 = cljs.core.async.close_BANG_.call(null,inst_20071);
var state_20180__$1 = state_20180;
var statearr_20213_20286 = state_20180__$1;
(statearr_20213_20286[(2)] = inst_20074);

(statearr_20213_20286[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (22))){
var inst_20092 = (state_20180[(8)]);
var inst_20095 = cljs.core.async.close_BANG_.call(null,inst_20092);
var state_20180__$1 = state_20180;
var statearr_20214_20287 = state_20180__$1;
(statearr_20214_20287[(2)] = inst_20095);

(statearr_20214_20287[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (36))){
var inst_20139 = (state_20180[(25)]);
var inst_20143 = cljs.core.chunk_first.call(null,inst_20139);
var inst_20144 = cljs.core.chunk_rest.call(null,inst_20139);
var inst_20145 = cljs.core.count.call(null,inst_20143);
var inst_20120 = inst_20144;
var inst_20121 = inst_20143;
var inst_20122 = inst_20145;
var inst_20123 = (0);
var state_20180__$1 = (function (){var statearr_20215 = state_20180;
(statearr_20215[(20)] = inst_20122);

(statearr_20215[(10)] = inst_20121);

(statearr_20215[(21)] = inst_20120);

(statearr_20215[(12)] = inst_20123);

return statearr_20215;
})();
var statearr_20216_20288 = state_20180__$1;
(statearr_20216_20288[(2)] = null);

(statearr_20216_20288[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (41))){
var inst_20139 = (state_20180[(25)]);
var inst_20155 = (state_20180[(2)]);
var inst_20156 = cljs.core.next.call(null,inst_20139);
var inst_20120 = inst_20156;
var inst_20121 = null;
var inst_20122 = (0);
var inst_20123 = (0);
var state_20180__$1 = (function (){var statearr_20217 = state_20180;
(statearr_20217[(20)] = inst_20122);

(statearr_20217[(27)] = inst_20155);

(statearr_20217[(10)] = inst_20121);

(statearr_20217[(21)] = inst_20120);

(statearr_20217[(12)] = inst_20123);

return statearr_20217;
})();
var statearr_20218_20289 = state_20180__$1;
(statearr_20218_20289[(2)] = null);

(statearr_20218_20289[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (43))){
var state_20180__$1 = state_20180;
var statearr_20219_20290 = state_20180__$1;
(statearr_20219_20290[(2)] = null);

(statearr_20219_20290[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (29))){
var inst_20164 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20220_20291 = state_20180__$1;
(statearr_20220_20291[(2)] = inst_20164);

(statearr_20220_20291[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (44))){
var inst_20173 = (state_20180[(2)]);
var state_20180__$1 = (function (){var statearr_20221 = state_20180;
(statearr_20221[(28)] = inst_20173);

return statearr_20221;
})();
var statearr_20222_20292 = state_20180__$1;
(statearr_20222_20292[(2)] = null);

(statearr_20222_20292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (6))){
var inst_20112 = (state_20180[(29)]);
var inst_20111 = cljs.core.deref.call(null,cs);
var inst_20112__$1 = cljs.core.keys.call(null,inst_20111);
var inst_20113 = cljs.core.count.call(null,inst_20112__$1);
var inst_20114 = cljs.core.reset_BANG_.call(null,dctr,inst_20113);
var inst_20119 = cljs.core.seq.call(null,inst_20112__$1);
var inst_20120 = inst_20119;
var inst_20121 = null;
var inst_20122 = (0);
var inst_20123 = (0);
var state_20180__$1 = (function (){var statearr_20223 = state_20180;
(statearr_20223[(29)] = inst_20112__$1);

(statearr_20223[(20)] = inst_20122);

(statearr_20223[(10)] = inst_20121);

(statearr_20223[(30)] = inst_20114);

(statearr_20223[(21)] = inst_20120);

(statearr_20223[(12)] = inst_20123);

return statearr_20223;
})();
var statearr_20224_20293 = state_20180__$1;
(statearr_20224_20293[(2)] = null);

(statearr_20224_20293[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (28))){
var inst_20139 = (state_20180[(25)]);
var inst_20120 = (state_20180[(21)]);
var inst_20139__$1 = cljs.core.seq.call(null,inst_20120);
var state_20180__$1 = (function (){var statearr_20225 = state_20180;
(statearr_20225[(25)] = inst_20139__$1);

return statearr_20225;
})();
if(inst_20139__$1){
var statearr_20226_20294 = state_20180__$1;
(statearr_20226_20294[(1)] = (33));

} else {
var statearr_20227_20295 = state_20180__$1;
(statearr_20227_20295[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (25))){
var inst_20122 = (state_20180[(20)]);
var inst_20123 = (state_20180[(12)]);
var inst_20125 = (inst_20123 < inst_20122);
var inst_20126 = inst_20125;
var state_20180__$1 = state_20180;
if(cljs.core.truth_(inst_20126)){
var statearr_20228_20296 = state_20180__$1;
(statearr_20228_20296[(1)] = (27));

} else {
var statearr_20229_20297 = state_20180__$1;
(statearr_20229_20297[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (34))){
var state_20180__$1 = state_20180;
var statearr_20230_20298 = state_20180__$1;
(statearr_20230_20298[(2)] = null);

(statearr_20230_20298[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (17))){
var state_20180__$1 = state_20180;
var statearr_20231_20299 = state_20180__$1;
(statearr_20231_20299[(2)] = null);

(statearr_20231_20299[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (3))){
var inst_20178 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20180__$1,inst_20178);
} else {
if((state_val_20181 === (12))){
var inst_20107 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20232_20300 = state_20180__$1;
(statearr_20232_20300[(2)] = inst_20107);

(statearr_20232_20300[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (2))){
var state_20180__$1 = state_20180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20180__$1,(4),ch);
} else {
if((state_val_20181 === (23))){
var state_20180__$1 = state_20180;
var statearr_20233_20301 = state_20180__$1;
(statearr_20233_20301[(2)] = null);

(statearr_20233_20301[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (35))){
var inst_20162 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20234_20302 = state_20180__$1;
(statearr_20234_20302[(2)] = inst_20162);

(statearr_20234_20302[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (19))){
var inst_20081 = (state_20180[(7)]);
var inst_20085 = cljs.core.chunk_first.call(null,inst_20081);
var inst_20086 = cljs.core.chunk_rest.call(null,inst_20081);
var inst_20087 = cljs.core.count.call(null,inst_20085);
var inst_20061 = inst_20086;
var inst_20062 = inst_20085;
var inst_20063 = inst_20087;
var inst_20064 = (0);
var state_20180__$1 = (function (){var statearr_20235 = state_20180;
(statearr_20235[(13)] = inst_20063);

(statearr_20235[(14)] = inst_20062);

(statearr_20235[(16)] = inst_20061);

(statearr_20235[(17)] = inst_20064);

return statearr_20235;
})();
var statearr_20236_20303 = state_20180__$1;
(statearr_20236_20303[(2)] = null);

(statearr_20236_20303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (11))){
var inst_20061 = (state_20180[(16)]);
var inst_20081 = (state_20180[(7)]);
var inst_20081__$1 = cljs.core.seq.call(null,inst_20061);
var state_20180__$1 = (function (){var statearr_20237 = state_20180;
(statearr_20237[(7)] = inst_20081__$1);

return statearr_20237;
})();
if(inst_20081__$1){
var statearr_20238_20304 = state_20180__$1;
(statearr_20238_20304[(1)] = (16));

} else {
var statearr_20239_20305 = state_20180__$1;
(statearr_20239_20305[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (9))){
var inst_20109 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20240_20306 = state_20180__$1;
(statearr_20240_20306[(2)] = inst_20109);

(statearr_20240_20306[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (5))){
var inst_20059 = cljs.core.deref.call(null,cs);
var inst_20060 = cljs.core.seq.call(null,inst_20059);
var inst_20061 = inst_20060;
var inst_20062 = null;
var inst_20063 = (0);
var inst_20064 = (0);
var state_20180__$1 = (function (){var statearr_20241 = state_20180;
(statearr_20241[(13)] = inst_20063);

(statearr_20241[(14)] = inst_20062);

(statearr_20241[(16)] = inst_20061);

(statearr_20241[(17)] = inst_20064);

return statearr_20241;
})();
var statearr_20242_20307 = state_20180__$1;
(statearr_20242_20307[(2)] = null);

(statearr_20242_20307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (14))){
var state_20180__$1 = state_20180;
var statearr_20243_20308 = state_20180__$1;
(statearr_20243_20308[(2)] = null);

(statearr_20243_20308[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (45))){
var inst_20170 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20244_20309 = state_20180__$1;
(statearr_20244_20309[(2)] = inst_20170);

(statearr_20244_20309[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (26))){
var inst_20112 = (state_20180[(29)]);
var inst_20166 = (state_20180[(2)]);
var inst_20167 = cljs.core.seq.call(null,inst_20112);
var state_20180__$1 = (function (){var statearr_20245 = state_20180;
(statearr_20245[(31)] = inst_20166);

return statearr_20245;
})();
if(inst_20167){
var statearr_20246_20310 = state_20180__$1;
(statearr_20246_20310[(1)] = (42));

} else {
var statearr_20247_20311 = state_20180__$1;
(statearr_20247_20311[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (16))){
var inst_20081 = (state_20180[(7)]);
var inst_20083 = cljs.core.chunked_seq_QMARK_.call(null,inst_20081);
var state_20180__$1 = state_20180;
if(inst_20083){
var statearr_20248_20312 = state_20180__$1;
(statearr_20248_20312[(1)] = (19));

} else {
var statearr_20249_20313 = state_20180__$1;
(statearr_20249_20313[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (38))){
var inst_20159 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20250_20314 = state_20180__$1;
(statearr_20250_20314[(2)] = inst_20159);

(statearr_20250_20314[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (30))){
var state_20180__$1 = state_20180;
var statearr_20251_20315 = state_20180__$1;
(statearr_20251_20315[(2)] = null);

(statearr_20251_20315[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (10))){
var inst_20062 = (state_20180[(14)]);
var inst_20064 = (state_20180[(17)]);
var inst_20070 = cljs.core._nth.call(null,inst_20062,inst_20064);
var inst_20071 = cljs.core.nth.call(null,inst_20070,(0),null);
var inst_20072 = cljs.core.nth.call(null,inst_20070,(1),null);
var state_20180__$1 = (function (){var statearr_20252 = state_20180;
(statearr_20252[(26)] = inst_20071);

return statearr_20252;
})();
if(cljs.core.truth_(inst_20072)){
var statearr_20253_20316 = state_20180__$1;
(statearr_20253_20316[(1)] = (13));

} else {
var statearr_20254_20317 = state_20180__$1;
(statearr_20254_20317[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (18))){
var inst_20105 = (state_20180[(2)]);
var state_20180__$1 = state_20180;
var statearr_20255_20318 = state_20180__$1;
(statearr_20255_20318[(2)] = inst_20105);

(statearr_20255_20318[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (42))){
var state_20180__$1 = state_20180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20180__$1,(45),dchan);
} else {
if((state_val_20181 === (37))){
var inst_20148 = (state_20180[(23)]);
var inst_20139 = (state_20180[(25)]);
var inst_20052 = (state_20180[(11)]);
var inst_20148__$1 = cljs.core.first.call(null,inst_20139);
var inst_20149 = cljs.core.async.put_BANG_.call(null,inst_20148__$1,inst_20052,done);
var state_20180__$1 = (function (){var statearr_20256 = state_20180;
(statearr_20256[(23)] = inst_20148__$1);

return statearr_20256;
})();
if(cljs.core.truth_(inst_20149)){
var statearr_20257_20319 = state_20180__$1;
(statearr_20257_20319[(1)] = (39));

} else {
var statearr_20258_20320 = state_20180__$1;
(statearr_20258_20320[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20181 === (8))){
var inst_20063 = (state_20180[(13)]);
var inst_20064 = (state_20180[(17)]);
var inst_20066 = (inst_20064 < inst_20063);
var inst_20067 = inst_20066;
var state_20180__$1 = state_20180;
if(cljs.core.truth_(inst_20067)){
var statearr_20259_20321 = state_20180__$1;
(statearr_20259_20321[(1)] = (10));

} else {
var statearr_20260_20322 = state_20180__$1;
(statearr_20260_20322[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___20268,cs,m,dchan,dctr,done))
;
return ((function (switch__10972__auto__,c__11084__auto___20268,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10973__auto__ = null;
var cljs$core$async$mult_$_state_machine__10973__auto____0 = (function (){
var statearr_20264 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20264[(0)] = cljs$core$async$mult_$_state_machine__10973__auto__);

(statearr_20264[(1)] = (1));

return statearr_20264;
});
var cljs$core$async$mult_$_state_machine__10973__auto____1 = (function (state_20180){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_20180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e20265){if((e20265 instanceof Object)){
var ex__10976__auto__ = e20265;
var statearr_20266_20323 = state_20180;
(statearr_20266_20323[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20180);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20265;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20324 = state_20180;
state_20180 = G__20324;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10973__auto__ = function(state_20180){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10973__auto____1.call(this,state_20180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10973__auto____0;
cljs$core$async$mult_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10973__auto____1;
return cljs$core$async$mult_$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___20268,cs,m,dchan,dctr,done))
})();
var state__11086__auto__ = (function (){var statearr_20267 = f__11085__auto__.call(null);
(statearr_20267[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___20268);

return statearr_20267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___20268,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20325 = [];
var len__5726__auto___20328 = arguments.length;
var i__5727__auto___20329 = (0);
while(true){
if((i__5727__auto___20329 < len__5726__auto___20328)){
args20325.push((arguments[i__5727__auto___20329]));

var G__20330 = (i__5727__auto___20329 + (1));
i__5727__auto___20329 = G__20330;
continue;
} else {
}
break;
}

var G__20327 = args20325.length;
switch (G__20327) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20325.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20342 = arguments.length;
var i__5727__auto___20343 = (0);
while(true){
if((i__5727__auto___20343 < len__5726__auto___20342)){
args__5733__auto__.push((arguments[i__5727__auto___20343]));

var G__20344 = (i__5727__auto___20343 + (1));
i__5727__auto___20343 = G__20344;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20336){
var map__20337 = p__20336;
var map__20337__$1 = ((((!((map__20337 == null)))?((((map__20337.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20337.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20337):map__20337);
var opts = map__20337__$1;
var statearr_20339_20345 = state;
(statearr_20339_20345[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20337,map__20337__$1,opts){
return (function (val){
var statearr_20340_20346 = state;
(statearr_20340_20346[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20337,map__20337__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20341_20347 = state;
(statearr_20341_20347[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20332){
var G__20333 = cljs.core.first.call(null,seq20332);
var seq20332__$1 = cljs.core.next.call(null,seq20332);
var G__20334 = cljs.core.first.call(null,seq20332__$1);
var seq20332__$2 = cljs.core.next.call(null,seq20332__$1);
var G__20335 = cljs.core.first.call(null,seq20332__$2);
var seq20332__$3 = cljs.core.next.call(null,seq20332__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20333,G__20334,G__20335,seq20332__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20511 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20511 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20512){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20512 = meta20512;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20513,meta20512__$1){
var self__ = this;
var _20513__$1 = this;
return (new cljs.core.async.t_cljs$core$async20511(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20512__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20513){
var self__ = this;
var _20513__$1 = this;
return self__.meta20512;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20512","meta20512",1169053211,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20511.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20511.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20511";

cljs.core.async.t_cljs$core$async20511.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20511");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20511 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20511(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20512){
return (new cljs.core.async.t_cljs$core$async20511(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20512));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20511(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11084__auto___20674 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___20674,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___20674,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20611){
var state_val_20612 = (state_20611[(1)]);
if((state_val_20612 === (7))){
var inst_20529 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
var statearr_20613_20675 = state_20611__$1;
(statearr_20613_20675[(2)] = inst_20529);

(statearr_20613_20675[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (20))){
var inst_20541 = (state_20611[(7)]);
var state_20611__$1 = state_20611;
var statearr_20614_20676 = state_20611__$1;
(statearr_20614_20676[(2)] = inst_20541);

(statearr_20614_20676[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (27))){
var state_20611__$1 = state_20611;
var statearr_20615_20677 = state_20611__$1;
(statearr_20615_20677[(2)] = null);

(statearr_20615_20677[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (1))){
var inst_20517 = (state_20611[(8)]);
var inst_20517__$1 = calc_state.call(null);
var inst_20519 = (inst_20517__$1 == null);
var inst_20520 = cljs.core.not.call(null,inst_20519);
var state_20611__$1 = (function (){var statearr_20616 = state_20611;
(statearr_20616[(8)] = inst_20517__$1);

return statearr_20616;
})();
if(inst_20520){
var statearr_20617_20678 = state_20611__$1;
(statearr_20617_20678[(1)] = (2));

} else {
var statearr_20618_20679 = state_20611__$1;
(statearr_20618_20679[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (24))){
var inst_20564 = (state_20611[(9)]);
var inst_20571 = (state_20611[(10)]);
var inst_20585 = (state_20611[(11)]);
var inst_20585__$1 = inst_20564.call(null,inst_20571);
var state_20611__$1 = (function (){var statearr_20619 = state_20611;
(statearr_20619[(11)] = inst_20585__$1);

return statearr_20619;
})();
if(cljs.core.truth_(inst_20585__$1)){
var statearr_20620_20680 = state_20611__$1;
(statearr_20620_20680[(1)] = (29));

} else {
var statearr_20621_20681 = state_20611__$1;
(statearr_20621_20681[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (4))){
var inst_20532 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
if(cljs.core.truth_(inst_20532)){
var statearr_20622_20682 = state_20611__$1;
(statearr_20622_20682[(1)] = (8));

} else {
var statearr_20623_20683 = state_20611__$1;
(statearr_20623_20683[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (15))){
var inst_20558 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
if(cljs.core.truth_(inst_20558)){
var statearr_20624_20684 = state_20611__$1;
(statearr_20624_20684[(1)] = (19));

} else {
var statearr_20625_20685 = state_20611__$1;
(statearr_20625_20685[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (21))){
var inst_20563 = (state_20611[(12)]);
var inst_20563__$1 = (state_20611[(2)]);
var inst_20564 = cljs.core.get.call(null,inst_20563__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20565 = cljs.core.get.call(null,inst_20563__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20566 = cljs.core.get.call(null,inst_20563__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20611__$1 = (function (){var statearr_20626 = state_20611;
(statearr_20626[(9)] = inst_20564);

(statearr_20626[(13)] = inst_20565);

(statearr_20626[(12)] = inst_20563__$1);

return statearr_20626;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20611__$1,(22),inst_20566);
} else {
if((state_val_20612 === (31))){
var inst_20593 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
if(cljs.core.truth_(inst_20593)){
var statearr_20627_20686 = state_20611__$1;
(statearr_20627_20686[(1)] = (32));

} else {
var statearr_20628_20687 = state_20611__$1;
(statearr_20628_20687[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (32))){
var inst_20570 = (state_20611[(14)]);
var state_20611__$1 = state_20611;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20611__$1,(35),out,inst_20570);
} else {
if((state_val_20612 === (33))){
var inst_20563 = (state_20611[(12)]);
var inst_20541 = inst_20563;
var state_20611__$1 = (function (){var statearr_20629 = state_20611;
(statearr_20629[(7)] = inst_20541);

return statearr_20629;
})();
var statearr_20630_20688 = state_20611__$1;
(statearr_20630_20688[(2)] = null);

(statearr_20630_20688[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (13))){
var inst_20541 = (state_20611[(7)]);
var inst_20548 = inst_20541.cljs$lang$protocol_mask$partition0$;
var inst_20549 = (inst_20548 & (64));
var inst_20550 = inst_20541.cljs$core$ISeq$;
var inst_20551 = (inst_20549) || (inst_20550);
var state_20611__$1 = state_20611;
if(cljs.core.truth_(inst_20551)){
var statearr_20631_20689 = state_20611__$1;
(statearr_20631_20689[(1)] = (16));

} else {
var statearr_20632_20690 = state_20611__$1;
(statearr_20632_20690[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (22))){
var inst_20570 = (state_20611[(14)]);
var inst_20571 = (state_20611[(10)]);
var inst_20569 = (state_20611[(2)]);
var inst_20570__$1 = cljs.core.nth.call(null,inst_20569,(0),null);
var inst_20571__$1 = cljs.core.nth.call(null,inst_20569,(1),null);
var inst_20572 = (inst_20570__$1 == null);
var inst_20573 = cljs.core._EQ_.call(null,inst_20571__$1,change);
var inst_20574 = (inst_20572) || (inst_20573);
var state_20611__$1 = (function (){var statearr_20633 = state_20611;
(statearr_20633[(14)] = inst_20570__$1);

(statearr_20633[(10)] = inst_20571__$1);

return statearr_20633;
})();
if(cljs.core.truth_(inst_20574)){
var statearr_20634_20691 = state_20611__$1;
(statearr_20634_20691[(1)] = (23));

} else {
var statearr_20635_20692 = state_20611__$1;
(statearr_20635_20692[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (36))){
var inst_20563 = (state_20611[(12)]);
var inst_20541 = inst_20563;
var state_20611__$1 = (function (){var statearr_20636 = state_20611;
(statearr_20636[(7)] = inst_20541);

return statearr_20636;
})();
var statearr_20637_20693 = state_20611__$1;
(statearr_20637_20693[(2)] = null);

(statearr_20637_20693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (29))){
var inst_20585 = (state_20611[(11)]);
var state_20611__$1 = state_20611;
var statearr_20638_20694 = state_20611__$1;
(statearr_20638_20694[(2)] = inst_20585);

(statearr_20638_20694[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (6))){
var state_20611__$1 = state_20611;
var statearr_20639_20695 = state_20611__$1;
(statearr_20639_20695[(2)] = false);

(statearr_20639_20695[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (28))){
var inst_20581 = (state_20611[(2)]);
var inst_20582 = calc_state.call(null);
var inst_20541 = inst_20582;
var state_20611__$1 = (function (){var statearr_20640 = state_20611;
(statearr_20640[(7)] = inst_20541);

(statearr_20640[(15)] = inst_20581);

return statearr_20640;
})();
var statearr_20641_20696 = state_20611__$1;
(statearr_20641_20696[(2)] = null);

(statearr_20641_20696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (25))){
var inst_20607 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
var statearr_20642_20697 = state_20611__$1;
(statearr_20642_20697[(2)] = inst_20607);

(statearr_20642_20697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (34))){
var inst_20605 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
var statearr_20643_20698 = state_20611__$1;
(statearr_20643_20698[(2)] = inst_20605);

(statearr_20643_20698[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (17))){
var state_20611__$1 = state_20611;
var statearr_20644_20699 = state_20611__$1;
(statearr_20644_20699[(2)] = false);

(statearr_20644_20699[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (3))){
var state_20611__$1 = state_20611;
var statearr_20645_20700 = state_20611__$1;
(statearr_20645_20700[(2)] = false);

(statearr_20645_20700[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (12))){
var inst_20609 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20611__$1,inst_20609);
} else {
if((state_val_20612 === (2))){
var inst_20517 = (state_20611[(8)]);
var inst_20522 = inst_20517.cljs$lang$protocol_mask$partition0$;
var inst_20523 = (inst_20522 & (64));
var inst_20524 = inst_20517.cljs$core$ISeq$;
var inst_20525 = (inst_20523) || (inst_20524);
var state_20611__$1 = state_20611;
if(cljs.core.truth_(inst_20525)){
var statearr_20646_20701 = state_20611__$1;
(statearr_20646_20701[(1)] = (5));

} else {
var statearr_20647_20702 = state_20611__$1;
(statearr_20647_20702[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (23))){
var inst_20570 = (state_20611[(14)]);
var inst_20576 = (inst_20570 == null);
var state_20611__$1 = state_20611;
if(cljs.core.truth_(inst_20576)){
var statearr_20648_20703 = state_20611__$1;
(statearr_20648_20703[(1)] = (26));

} else {
var statearr_20649_20704 = state_20611__$1;
(statearr_20649_20704[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (35))){
var inst_20596 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
if(cljs.core.truth_(inst_20596)){
var statearr_20650_20705 = state_20611__$1;
(statearr_20650_20705[(1)] = (36));

} else {
var statearr_20651_20706 = state_20611__$1;
(statearr_20651_20706[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (19))){
var inst_20541 = (state_20611[(7)]);
var inst_20560 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20541);
var state_20611__$1 = state_20611;
var statearr_20652_20707 = state_20611__$1;
(statearr_20652_20707[(2)] = inst_20560);

(statearr_20652_20707[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (11))){
var inst_20541 = (state_20611[(7)]);
var inst_20545 = (inst_20541 == null);
var inst_20546 = cljs.core.not.call(null,inst_20545);
var state_20611__$1 = state_20611;
if(inst_20546){
var statearr_20653_20708 = state_20611__$1;
(statearr_20653_20708[(1)] = (13));

} else {
var statearr_20654_20709 = state_20611__$1;
(statearr_20654_20709[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (9))){
var inst_20517 = (state_20611[(8)]);
var state_20611__$1 = state_20611;
var statearr_20655_20710 = state_20611__$1;
(statearr_20655_20710[(2)] = inst_20517);

(statearr_20655_20710[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (5))){
var state_20611__$1 = state_20611;
var statearr_20656_20711 = state_20611__$1;
(statearr_20656_20711[(2)] = true);

(statearr_20656_20711[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (14))){
var state_20611__$1 = state_20611;
var statearr_20657_20712 = state_20611__$1;
(statearr_20657_20712[(2)] = false);

(statearr_20657_20712[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (26))){
var inst_20571 = (state_20611[(10)]);
var inst_20578 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20571);
var state_20611__$1 = state_20611;
var statearr_20658_20713 = state_20611__$1;
(statearr_20658_20713[(2)] = inst_20578);

(statearr_20658_20713[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (16))){
var state_20611__$1 = state_20611;
var statearr_20659_20714 = state_20611__$1;
(statearr_20659_20714[(2)] = true);

(statearr_20659_20714[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (38))){
var inst_20601 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
var statearr_20660_20715 = state_20611__$1;
(statearr_20660_20715[(2)] = inst_20601);

(statearr_20660_20715[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (30))){
var inst_20564 = (state_20611[(9)]);
var inst_20565 = (state_20611[(13)]);
var inst_20571 = (state_20611[(10)]);
var inst_20588 = cljs.core.empty_QMARK_.call(null,inst_20564);
var inst_20589 = inst_20565.call(null,inst_20571);
var inst_20590 = cljs.core.not.call(null,inst_20589);
var inst_20591 = (inst_20588) && (inst_20590);
var state_20611__$1 = state_20611;
var statearr_20661_20716 = state_20611__$1;
(statearr_20661_20716[(2)] = inst_20591);

(statearr_20661_20716[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (10))){
var inst_20517 = (state_20611[(8)]);
var inst_20537 = (state_20611[(2)]);
var inst_20538 = cljs.core.get.call(null,inst_20537,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20539 = cljs.core.get.call(null,inst_20537,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20540 = cljs.core.get.call(null,inst_20537,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20541 = inst_20517;
var state_20611__$1 = (function (){var statearr_20662 = state_20611;
(statearr_20662[(16)] = inst_20538);

(statearr_20662[(17)] = inst_20539);

(statearr_20662[(18)] = inst_20540);

(statearr_20662[(7)] = inst_20541);

return statearr_20662;
})();
var statearr_20663_20717 = state_20611__$1;
(statearr_20663_20717[(2)] = null);

(statearr_20663_20717[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (18))){
var inst_20555 = (state_20611[(2)]);
var state_20611__$1 = state_20611;
var statearr_20664_20718 = state_20611__$1;
(statearr_20664_20718[(2)] = inst_20555);

(statearr_20664_20718[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (37))){
var state_20611__$1 = state_20611;
var statearr_20665_20719 = state_20611__$1;
(statearr_20665_20719[(2)] = null);

(statearr_20665_20719[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20612 === (8))){
var inst_20517 = (state_20611[(8)]);
var inst_20534 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20517);
var state_20611__$1 = state_20611;
var statearr_20666_20720 = state_20611__$1;
(statearr_20666_20720[(2)] = inst_20534);

(statearr_20666_20720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___20674,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10972__auto__,c__11084__auto___20674,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10973__auto__ = null;
var cljs$core$async$mix_$_state_machine__10973__auto____0 = (function (){
var statearr_20670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20670[(0)] = cljs$core$async$mix_$_state_machine__10973__auto__);

(statearr_20670[(1)] = (1));

return statearr_20670;
});
var cljs$core$async$mix_$_state_machine__10973__auto____1 = (function (state_20611){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_20611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e20671){if((e20671 instanceof Object)){
var ex__10976__auto__ = e20671;
var statearr_20672_20721 = state_20611;
(statearr_20672_20721[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20611);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20671;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20722 = state_20611;
state_20611 = G__20722;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10973__auto__ = function(state_20611){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10973__auto____1.call(this,state_20611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10973__auto____0;
cljs$core$async$mix_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10973__auto____1;
return cljs$core$async$mix_$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___20674,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11086__auto__ = (function (){var statearr_20673 = f__11085__auto__.call(null);
(statearr_20673[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___20674);

return statearr_20673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___20674,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20723 = [];
var len__5726__auto___20726 = arguments.length;
var i__5727__auto___20727 = (0);
while(true){
if((i__5727__auto___20727 < len__5726__auto___20726)){
args20723.push((arguments[i__5727__auto___20727]));

var G__20728 = (i__5727__auto___20727 + (1));
i__5727__auto___20727 = G__20728;
continue;
} else {
}
break;
}

var G__20725 = args20723.length;
switch (G__20725) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20723.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20731 = [];
var len__5726__auto___20856 = arguments.length;
var i__5727__auto___20857 = (0);
while(true){
if((i__5727__auto___20857 < len__5726__auto___20856)){
args20731.push((arguments[i__5727__auto___20857]));

var G__20858 = (i__5727__auto___20857 + (1));
i__5727__auto___20857 = G__20858;
continue;
} else {
}
break;
}

var G__20733 = args20731.length;
switch (G__20733) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20731.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__20730_SHARP_){
if(cljs.core.truth_(p1__20730_SHARP_.call(null,topic))){
return p1__20730_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20730_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20734 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20734 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20735){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20735 = meta20735;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20736,meta20735__$1){
var self__ = this;
var _20736__$1 = this;
return (new cljs.core.async.t_cljs$core$async20734(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20735__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20736){
var self__ = this;
var _20736__$1 = this;
return self__.meta20735;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20734.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20734.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20735","meta20735",2093060505,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20734.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20734.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20734";

cljs.core.async.t_cljs$core$async20734.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20734");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20734 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20734(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20735){
return (new cljs.core.async.t_cljs$core$async20734(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20735));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20734(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11084__auto___20860 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___20860,mults,ensure_mult,p){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___20860,mults,ensure_mult,p){
return (function (state_20808){
var state_val_20809 = (state_20808[(1)]);
if((state_val_20809 === (7))){
var inst_20804 = (state_20808[(2)]);
var state_20808__$1 = state_20808;
var statearr_20810_20861 = state_20808__$1;
(statearr_20810_20861[(2)] = inst_20804);

(statearr_20810_20861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (20))){
var state_20808__$1 = state_20808;
var statearr_20811_20862 = state_20808__$1;
(statearr_20811_20862[(2)] = null);

(statearr_20811_20862[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (1))){
var state_20808__$1 = state_20808;
var statearr_20812_20863 = state_20808__$1;
(statearr_20812_20863[(2)] = null);

(statearr_20812_20863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (24))){
var inst_20787 = (state_20808[(7)]);
var inst_20796 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20787);
var state_20808__$1 = state_20808;
var statearr_20813_20864 = state_20808__$1;
(statearr_20813_20864[(2)] = inst_20796);

(statearr_20813_20864[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (4))){
var inst_20739 = (state_20808[(8)]);
var inst_20739__$1 = (state_20808[(2)]);
var inst_20740 = (inst_20739__$1 == null);
var state_20808__$1 = (function (){var statearr_20814 = state_20808;
(statearr_20814[(8)] = inst_20739__$1);

return statearr_20814;
})();
if(cljs.core.truth_(inst_20740)){
var statearr_20815_20865 = state_20808__$1;
(statearr_20815_20865[(1)] = (5));

} else {
var statearr_20816_20866 = state_20808__$1;
(statearr_20816_20866[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (15))){
var inst_20781 = (state_20808[(2)]);
var state_20808__$1 = state_20808;
var statearr_20817_20867 = state_20808__$1;
(statearr_20817_20867[(2)] = inst_20781);

(statearr_20817_20867[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (21))){
var inst_20801 = (state_20808[(2)]);
var state_20808__$1 = (function (){var statearr_20818 = state_20808;
(statearr_20818[(9)] = inst_20801);

return statearr_20818;
})();
var statearr_20819_20868 = state_20808__$1;
(statearr_20819_20868[(2)] = null);

(statearr_20819_20868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (13))){
var inst_20763 = (state_20808[(10)]);
var inst_20765 = cljs.core.chunked_seq_QMARK_.call(null,inst_20763);
var state_20808__$1 = state_20808;
if(inst_20765){
var statearr_20820_20869 = state_20808__$1;
(statearr_20820_20869[(1)] = (16));

} else {
var statearr_20821_20870 = state_20808__$1;
(statearr_20821_20870[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (22))){
var inst_20793 = (state_20808[(2)]);
var state_20808__$1 = state_20808;
if(cljs.core.truth_(inst_20793)){
var statearr_20822_20871 = state_20808__$1;
(statearr_20822_20871[(1)] = (23));

} else {
var statearr_20823_20872 = state_20808__$1;
(statearr_20823_20872[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (6))){
var inst_20787 = (state_20808[(7)]);
var inst_20739 = (state_20808[(8)]);
var inst_20789 = (state_20808[(11)]);
var inst_20787__$1 = topic_fn.call(null,inst_20739);
var inst_20788 = cljs.core.deref.call(null,mults);
var inst_20789__$1 = cljs.core.get.call(null,inst_20788,inst_20787__$1);
var state_20808__$1 = (function (){var statearr_20824 = state_20808;
(statearr_20824[(7)] = inst_20787__$1);

(statearr_20824[(11)] = inst_20789__$1);

return statearr_20824;
})();
if(cljs.core.truth_(inst_20789__$1)){
var statearr_20825_20873 = state_20808__$1;
(statearr_20825_20873[(1)] = (19));

} else {
var statearr_20826_20874 = state_20808__$1;
(statearr_20826_20874[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (25))){
var inst_20798 = (state_20808[(2)]);
var state_20808__$1 = state_20808;
var statearr_20827_20875 = state_20808__$1;
(statearr_20827_20875[(2)] = inst_20798);

(statearr_20827_20875[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (17))){
var inst_20763 = (state_20808[(10)]);
var inst_20772 = cljs.core.first.call(null,inst_20763);
var inst_20773 = cljs.core.async.muxch_STAR_.call(null,inst_20772);
var inst_20774 = cljs.core.async.close_BANG_.call(null,inst_20773);
var inst_20775 = cljs.core.next.call(null,inst_20763);
var inst_20749 = inst_20775;
var inst_20750 = null;
var inst_20751 = (0);
var inst_20752 = (0);
var state_20808__$1 = (function (){var statearr_20828 = state_20808;
(statearr_20828[(12)] = inst_20774);

(statearr_20828[(13)] = inst_20752);

(statearr_20828[(14)] = inst_20751);

(statearr_20828[(15)] = inst_20749);

(statearr_20828[(16)] = inst_20750);

return statearr_20828;
})();
var statearr_20829_20876 = state_20808__$1;
(statearr_20829_20876[(2)] = null);

(statearr_20829_20876[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (3))){
var inst_20806 = (state_20808[(2)]);
var state_20808__$1 = state_20808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20808__$1,inst_20806);
} else {
if((state_val_20809 === (12))){
var inst_20783 = (state_20808[(2)]);
var state_20808__$1 = state_20808;
var statearr_20830_20877 = state_20808__$1;
(statearr_20830_20877[(2)] = inst_20783);

(statearr_20830_20877[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (2))){
var state_20808__$1 = state_20808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20808__$1,(4),ch);
} else {
if((state_val_20809 === (23))){
var state_20808__$1 = state_20808;
var statearr_20831_20878 = state_20808__$1;
(statearr_20831_20878[(2)] = null);

(statearr_20831_20878[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (19))){
var inst_20739 = (state_20808[(8)]);
var inst_20789 = (state_20808[(11)]);
var inst_20791 = cljs.core.async.muxch_STAR_.call(null,inst_20789);
var state_20808__$1 = state_20808;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20808__$1,(22),inst_20791,inst_20739);
} else {
if((state_val_20809 === (11))){
var inst_20749 = (state_20808[(15)]);
var inst_20763 = (state_20808[(10)]);
var inst_20763__$1 = cljs.core.seq.call(null,inst_20749);
var state_20808__$1 = (function (){var statearr_20832 = state_20808;
(statearr_20832[(10)] = inst_20763__$1);

return statearr_20832;
})();
if(inst_20763__$1){
var statearr_20833_20879 = state_20808__$1;
(statearr_20833_20879[(1)] = (13));

} else {
var statearr_20834_20880 = state_20808__$1;
(statearr_20834_20880[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (9))){
var inst_20785 = (state_20808[(2)]);
var state_20808__$1 = state_20808;
var statearr_20835_20881 = state_20808__$1;
(statearr_20835_20881[(2)] = inst_20785);

(statearr_20835_20881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (5))){
var inst_20746 = cljs.core.deref.call(null,mults);
var inst_20747 = cljs.core.vals.call(null,inst_20746);
var inst_20748 = cljs.core.seq.call(null,inst_20747);
var inst_20749 = inst_20748;
var inst_20750 = null;
var inst_20751 = (0);
var inst_20752 = (0);
var state_20808__$1 = (function (){var statearr_20836 = state_20808;
(statearr_20836[(13)] = inst_20752);

(statearr_20836[(14)] = inst_20751);

(statearr_20836[(15)] = inst_20749);

(statearr_20836[(16)] = inst_20750);

return statearr_20836;
})();
var statearr_20837_20882 = state_20808__$1;
(statearr_20837_20882[(2)] = null);

(statearr_20837_20882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (14))){
var state_20808__$1 = state_20808;
var statearr_20841_20883 = state_20808__$1;
(statearr_20841_20883[(2)] = null);

(statearr_20841_20883[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (16))){
var inst_20763 = (state_20808[(10)]);
var inst_20767 = cljs.core.chunk_first.call(null,inst_20763);
var inst_20768 = cljs.core.chunk_rest.call(null,inst_20763);
var inst_20769 = cljs.core.count.call(null,inst_20767);
var inst_20749 = inst_20768;
var inst_20750 = inst_20767;
var inst_20751 = inst_20769;
var inst_20752 = (0);
var state_20808__$1 = (function (){var statearr_20842 = state_20808;
(statearr_20842[(13)] = inst_20752);

(statearr_20842[(14)] = inst_20751);

(statearr_20842[(15)] = inst_20749);

(statearr_20842[(16)] = inst_20750);

return statearr_20842;
})();
var statearr_20843_20884 = state_20808__$1;
(statearr_20843_20884[(2)] = null);

(statearr_20843_20884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (10))){
var inst_20752 = (state_20808[(13)]);
var inst_20751 = (state_20808[(14)]);
var inst_20749 = (state_20808[(15)]);
var inst_20750 = (state_20808[(16)]);
var inst_20757 = cljs.core._nth.call(null,inst_20750,inst_20752);
var inst_20758 = cljs.core.async.muxch_STAR_.call(null,inst_20757);
var inst_20759 = cljs.core.async.close_BANG_.call(null,inst_20758);
var inst_20760 = (inst_20752 + (1));
var tmp20838 = inst_20751;
var tmp20839 = inst_20749;
var tmp20840 = inst_20750;
var inst_20749__$1 = tmp20839;
var inst_20750__$1 = tmp20840;
var inst_20751__$1 = tmp20838;
var inst_20752__$1 = inst_20760;
var state_20808__$1 = (function (){var statearr_20844 = state_20808;
(statearr_20844[(17)] = inst_20759);

(statearr_20844[(13)] = inst_20752__$1);

(statearr_20844[(14)] = inst_20751__$1);

(statearr_20844[(15)] = inst_20749__$1);

(statearr_20844[(16)] = inst_20750__$1);

return statearr_20844;
})();
var statearr_20845_20885 = state_20808__$1;
(statearr_20845_20885[(2)] = null);

(statearr_20845_20885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (18))){
var inst_20778 = (state_20808[(2)]);
var state_20808__$1 = state_20808;
var statearr_20846_20886 = state_20808__$1;
(statearr_20846_20886[(2)] = inst_20778);

(statearr_20846_20886[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20809 === (8))){
var inst_20752 = (state_20808[(13)]);
var inst_20751 = (state_20808[(14)]);
var inst_20754 = (inst_20752 < inst_20751);
var inst_20755 = inst_20754;
var state_20808__$1 = state_20808;
if(cljs.core.truth_(inst_20755)){
var statearr_20847_20887 = state_20808__$1;
(statearr_20847_20887[(1)] = (10));

} else {
var statearr_20848_20888 = state_20808__$1;
(statearr_20848_20888[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___20860,mults,ensure_mult,p))
;
return ((function (switch__10972__auto__,c__11084__auto___20860,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_20852 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20852[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_20852[(1)] = (1));

return statearr_20852;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_20808){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_20808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e20853){if((e20853 instanceof Object)){
var ex__10976__auto__ = e20853;
var statearr_20854_20889 = state_20808;
(statearr_20854_20889[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20808);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20853;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20890 = state_20808;
state_20808 = G__20890;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_20808){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_20808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___20860,mults,ensure_mult,p))
})();
var state__11086__auto__ = (function (){var statearr_20855 = f__11085__auto__.call(null);
(statearr_20855[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___20860);

return statearr_20855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___20860,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20891 = [];
var len__5726__auto___20894 = arguments.length;
var i__5727__auto___20895 = (0);
while(true){
if((i__5727__auto___20895 < len__5726__auto___20894)){
args20891.push((arguments[i__5727__auto___20895]));

var G__20896 = (i__5727__auto___20895 + (1));
i__5727__auto___20895 = G__20896;
continue;
} else {
}
break;
}

var G__20893 = args20891.length;
switch (G__20893) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20891.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20898 = [];
var len__5726__auto___20901 = arguments.length;
var i__5727__auto___20902 = (0);
while(true){
if((i__5727__auto___20902 < len__5726__auto___20901)){
args20898.push((arguments[i__5727__auto___20902]));

var G__20903 = (i__5727__auto___20902 + (1));
i__5727__auto___20902 = G__20903;
continue;
} else {
}
break;
}

var G__20900 = args20898.length;
switch (G__20900) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20898.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20905 = [];
var len__5726__auto___20976 = arguments.length;
var i__5727__auto___20977 = (0);
while(true){
if((i__5727__auto___20977 < len__5726__auto___20976)){
args20905.push((arguments[i__5727__auto___20977]));

var G__20978 = (i__5727__auto___20977 + (1));
i__5727__auto___20977 = G__20978;
continue;
} else {
}
break;
}

var G__20907 = args20905.length;
switch (G__20907) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20905.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11084__auto___20980 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___20980,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___20980,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20946){
var state_val_20947 = (state_20946[(1)]);
if((state_val_20947 === (7))){
var state_20946__$1 = state_20946;
var statearr_20948_20981 = state_20946__$1;
(statearr_20948_20981[(2)] = null);

(statearr_20948_20981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (1))){
var state_20946__$1 = state_20946;
var statearr_20949_20982 = state_20946__$1;
(statearr_20949_20982[(2)] = null);

(statearr_20949_20982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (4))){
var inst_20910 = (state_20946[(7)]);
var inst_20912 = (inst_20910 < cnt);
var state_20946__$1 = state_20946;
if(cljs.core.truth_(inst_20912)){
var statearr_20950_20983 = state_20946__$1;
(statearr_20950_20983[(1)] = (6));

} else {
var statearr_20951_20984 = state_20946__$1;
(statearr_20951_20984[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (15))){
var inst_20942 = (state_20946[(2)]);
var state_20946__$1 = state_20946;
var statearr_20952_20985 = state_20946__$1;
(statearr_20952_20985[(2)] = inst_20942);

(statearr_20952_20985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (13))){
var inst_20935 = cljs.core.async.close_BANG_.call(null,out);
var state_20946__$1 = state_20946;
var statearr_20953_20986 = state_20946__$1;
(statearr_20953_20986[(2)] = inst_20935);

(statearr_20953_20986[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (6))){
var state_20946__$1 = state_20946;
var statearr_20954_20987 = state_20946__$1;
(statearr_20954_20987[(2)] = null);

(statearr_20954_20987[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (3))){
var inst_20944 = (state_20946[(2)]);
var state_20946__$1 = state_20946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20946__$1,inst_20944);
} else {
if((state_val_20947 === (12))){
var inst_20932 = (state_20946[(8)]);
var inst_20932__$1 = (state_20946[(2)]);
var inst_20933 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20932__$1);
var state_20946__$1 = (function (){var statearr_20955 = state_20946;
(statearr_20955[(8)] = inst_20932__$1);

return statearr_20955;
})();
if(cljs.core.truth_(inst_20933)){
var statearr_20956_20988 = state_20946__$1;
(statearr_20956_20988[(1)] = (13));

} else {
var statearr_20957_20989 = state_20946__$1;
(statearr_20957_20989[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (2))){
var inst_20909 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20910 = (0);
var state_20946__$1 = (function (){var statearr_20958 = state_20946;
(statearr_20958[(7)] = inst_20910);

(statearr_20958[(9)] = inst_20909);

return statearr_20958;
})();
var statearr_20959_20990 = state_20946__$1;
(statearr_20959_20990[(2)] = null);

(statearr_20959_20990[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (11))){
var inst_20910 = (state_20946[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20946,(10),Object,null,(9));
var inst_20919 = chs__$1.call(null,inst_20910);
var inst_20920 = done.call(null,inst_20910);
var inst_20921 = cljs.core.async.take_BANG_.call(null,inst_20919,inst_20920);
var state_20946__$1 = state_20946;
var statearr_20960_20991 = state_20946__$1;
(statearr_20960_20991[(2)] = inst_20921);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20946__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (9))){
var inst_20910 = (state_20946[(7)]);
var inst_20923 = (state_20946[(2)]);
var inst_20924 = (inst_20910 + (1));
var inst_20910__$1 = inst_20924;
var state_20946__$1 = (function (){var statearr_20961 = state_20946;
(statearr_20961[(7)] = inst_20910__$1);

(statearr_20961[(10)] = inst_20923);

return statearr_20961;
})();
var statearr_20962_20992 = state_20946__$1;
(statearr_20962_20992[(2)] = null);

(statearr_20962_20992[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (5))){
var inst_20930 = (state_20946[(2)]);
var state_20946__$1 = (function (){var statearr_20963 = state_20946;
(statearr_20963[(11)] = inst_20930);

return statearr_20963;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20946__$1,(12),dchan);
} else {
if((state_val_20947 === (14))){
var inst_20932 = (state_20946[(8)]);
var inst_20937 = cljs.core.apply.call(null,f,inst_20932);
var state_20946__$1 = state_20946;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20946__$1,(16),out,inst_20937);
} else {
if((state_val_20947 === (16))){
var inst_20939 = (state_20946[(2)]);
var state_20946__$1 = (function (){var statearr_20964 = state_20946;
(statearr_20964[(12)] = inst_20939);

return statearr_20964;
})();
var statearr_20965_20993 = state_20946__$1;
(statearr_20965_20993[(2)] = null);

(statearr_20965_20993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (10))){
var inst_20914 = (state_20946[(2)]);
var inst_20915 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20946__$1 = (function (){var statearr_20966 = state_20946;
(statearr_20966[(13)] = inst_20914);

return statearr_20966;
})();
var statearr_20967_20994 = state_20946__$1;
(statearr_20967_20994[(2)] = inst_20915);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20946__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20947 === (8))){
var inst_20928 = (state_20946[(2)]);
var state_20946__$1 = state_20946;
var statearr_20968_20995 = state_20946__$1;
(statearr_20968_20995[(2)] = inst_20928);

(statearr_20968_20995[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___20980,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10972__auto__,c__11084__auto___20980,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_20972 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20972[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_20972[(1)] = (1));

return statearr_20972;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_20946){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_20946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e20973){if((e20973 instanceof Object)){
var ex__10976__auto__ = e20973;
var statearr_20974_20996 = state_20946;
(statearr_20974_20996[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20946);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20973;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20997 = state_20946;
state_20946 = G__20997;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_20946){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_20946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___20980,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11086__auto__ = (function (){var statearr_20975 = f__11085__auto__.call(null);
(statearr_20975[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___20980);

return statearr_20975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___20980,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20999 = [];
var len__5726__auto___21055 = arguments.length;
var i__5727__auto___21056 = (0);
while(true){
if((i__5727__auto___21056 < len__5726__auto___21055)){
args20999.push((arguments[i__5727__auto___21056]));

var G__21057 = (i__5727__auto___21056 + (1));
i__5727__auto___21056 = G__21057;
continue;
} else {
}
break;
}

var G__21001 = args20999.length;
switch (G__21001) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20999.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___21059 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___21059,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___21059,out){
return (function (state_21031){
var state_val_21032 = (state_21031[(1)]);
if((state_val_21032 === (7))){
var inst_21011 = (state_21031[(7)]);
var inst_21010 = (state_21031[(8)]);
var inst_21010__$1 = (state_21031[(2)]);
var inst_21011__$1 = cljs.core.nth.call(null,inst_21010__$1,(0),null);
var inst_21012 = cljs.core.nth.call(null,inst_21010__$1,(1),null);
var inst_21013 = (inst_21011__$1 == null);
var state_21031__$1 = (function (){var statearr_21033 = state_21031;
(statearr_21033[(7)] = inst_21011__$1);

(statearr_21033[(9)] = inst_21012);

(statearr_21033[(8)] = inst_21010__$1);

return statearr_21033;
})();
if(cljs.core.truth_(inst_21013)){
var statearr_21034_21060 = state_21031__$1;
(statearr_21034_21060[(1)] = (8));

} else {
var statearr_21035_21061 = state_21031__$1;
(statearr_21035_21061[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (1))){
var inst_21002 = cljs.core.vec.call(null,chs);
var inst_21003 = inst_21002;
var state_21031__$1 = (function (){var statearr_21036 = state_21031;
(statearr_21036[(10)] = inst_21003);

return statearr_21036;
})();
var statearr_21037_21062 = state_21031__$1;
(statearr_21037_21062[(2)] = null);

(statearr_21037_21062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (4))){
var inst_21003 = (state_21031[(10)]);
var state_21031__$1 = state_21031;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21031__$1,(7),inst_21003);
} else {
if((state_val_21032 === (6))){
var inst_21027 = (state_21031[(2)]);
var state_21031__$1 = state_21031;
var statearr_21038_21063 = state_21031__$1;
(statearr_21038_21063[(2)] = inst_21027);

(statearr_21038_21063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (3))){
var inst_21029 = (state_21031[(2)]);
var state_21031__$1 = state_21031;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21031__$1,inst_21029);
} else {
if((state_val_21032 === (2))){
var inst_21003 = (state_21031[(10)]);
var inst_21005 = cljs.core.count.call(null,inst_21003);
var inst_21006 = (inst_21005 > (0));
var state_21031__$1 = state_21031;
if(cljs.core.truth_(inst_21006)){
var statearr_21040_21064 = state_21031__$1;
(statearr_21040_21064[(1)] = (4));

} else {
var statearr_21041_21065 = state_21031__$1;
(statearr_21041_21065[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (11))){
var inst_21003 = (state_21031[(10)]);
var inst_21020 = (state_21031[(2)]);
var tmp21039 = inst_21003;
var inst_21003__$1 = tmp21039;
var state_21031__$1 = (function (){var statearr_21042 = state_21031;
(statearr_21042[(10)] = inst_21003__$1);

(statearr_21042[(11)] = inst_21020);

return statearr_21042;
})();
var statearr_21043_21066 = state_21031__$1;
(statearr_21043_21066[(2)] = null);

(statearr_21043_21066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (9))){
var inst_21011 = (state_21031[(7)]);
var state_21031__$1 = state_21031;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21031__$1,(11),out,inst_21011);
} else {
if((state_val_21032 === (5))){
var inst_21025 = cljs.core.async.close_BANG_.call(null,out);
var state_21031__$1 = state_21031;
var statearr_21044_21067 = state_21031__$1;
(statearr_21044_21067[(2)] = inst_21025);

(statearr_21044_21067[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (10))){
var inst_21023 = (state_21031[(2)]);
var state_21031__$1 = state_21031;
var statearr_21045_21068 = state_21031__$1;
(statearr_21045_21068[(2)] = inst_21023);

(statearr_21045_21068[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21032 === (8))){
var inst_21003 = (state_21031[(10)]);
var inst_21011 = (state_21031[(7)]);
var inst_21012 = (state_21031[(9)]);
var inst_21010 = (state_21031[(8)]);
var inst_21015 = (function (){var cs = inst_21003;
var vec__21008 = inst_21010;
var v = inst_21011;
var c = inst_21012;
return ((function (cs,vec__21008,v,c,inst_21003,inst_21011,inst_21012,inst_21010,state_val_21032,c__11084__auto___21059,out){
return (function (p1__20998_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20998_SHARP_);
});
;})(cs,vec__21008,v,c,inst_21003,inst_21011,inst_21012,inst_21010,state_val_21032,c__11084__auto___21059,out))
})();
var inst_21016 = cljs.core.filterv.call(null,inst_21015,inst_21003);
var inst_21003__$1 = inst_21016;
var state_21031__$1 = (function (){var statearr_21046 = state_21031;
(statearr_21046[(10)] = inst_21003__$1);

return statearr_21046;
})();
var statearr_21047_21069 = state_21031__$1;
(statearr_21047_21069[(2)] = null);

(statearr_21047_21069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___21059,out))
;
return ((function (switch__10972__auto__,c__11084__auto___21059,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_21051 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21051[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_21051[(1)] = (1));

return statearr_21051;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_21031){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_21031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e21052){if((e21052 instanceof Object)){
var ex__10976__auto__ = e21052;
var statearr_21053_21070 = state_21031;
(statearr_21053_21070[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21031);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21052;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21071 = state_21031;
state_21031 = G__21071;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_21031){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_21031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___21059,out))
})();
var state__11086__auto__ = (function (){var statearr_21054 = f__11085__auto__.call(null);
(statearr_21054[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___21059);

return statearr_21054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___21059,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args21072 = [];
var len__5726__auto___21121 = arguments.length;
var i__5727__auto___21122 = (0);
while(true){
if((i__5727__auto___21122 < len__5726__auto___21121)){
args21072.push((arguments[i__5727__auto___21122]));

var G__21123 = (i__5727__auto___21122 + (1));
i__5727__auto___21122 = G__21123;
continue;
} else {
}
break;
}

var G__21074 = args21072.length;
switch (G__21074) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21072.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___21125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___21125,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___21125,out){
return (function (state_21098){
var state_val_21099 = (state_21098[(1)]);
if((state_val_21099 === (7))){
var inst_21080 = (state_21098[(7)]);
var inst_21080__$1 = (state_21098[(2)]);
var inst_21081 = (inst_21080__$1 == null);
var inst_21082 = cljs.core.not.call(null,inst_21081);
var state_21098__$1 = (function (){var statearr_21100 = state_21098;
(statearr_21100[(7)] = inst_21080__$1);

return statearr_21100;
})();
if(inst_21082){
var statearr_21101_21126 = state_21098__$1;
(statearr_21101_21126[(1)] = (8));

} else {
var statearr_21102_21127 = state_21098__$1;
(statearr_21102_21127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (1))){
var inst_21075 = (0);
var state_21098__$1 = (function (){var statearr_21103 = state_21098;
(statearr_21103[(8)] = inst_21075);

return statearr_21103;
})();
var statearr_21104_21128 = state_21098__$1;
(statearr_21104_21128[(2)] = null);

(statearr_21104_21128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (4))){
var state_21098__$1 = state_21098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21098__$1,(7),ch);
} else {
if((state_val_21099 === (6))){
var inst_21093 = (state_21098[(2)]);
var state_21098__$1 = state_21098;
var statearr_21105_21129 = state_21098__$1;
(statearr_21105_21129[(2)] = inst_21093);

(statearr_21105_21129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (3))){
var inst_21095 = (state_21098[(2)]);
var inst_21096 = cljs.core.async.close_BANG_.call(null,out);
var state_21098__$1 = (function (){var statearr_21106 = state_21098;
(statearr_21106[(9)] = inst_21095);

return statearr_21106;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21098__$1,inst_21096);
} else {
if((state_val_21099 === (2))){
var inst_21075 = (state_21098[(8)]);
var inst_21077 = (inst_21075 < n);
var state_21098__$1 = state_21098;
if(cljs.core.truth_(inst_21077)){
var statearr_21107_21130 = state_21098__$1;
(statearr_21107_21130[(1)] = (4));

} else {
var statearr_21108_21131 = state_21098__$1;
(statearr_21108_21131[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (11))){
var inst_21075 = (state_21098[(8)]);
var inst_21085 = (state_21098[(2)]);
var inst_21086 = (inst_21075 + (1));
var inst_21075__$1 = inst_21086;
var state_21098__$1 = (function (){var statearr_21109 = state_21098;
(statearr_21109[(10)] = inst_21085);

(statearr_21109[(8)] = inst_21075__$1);

return statearr_21109;
})();
var statearr_21110_21132 = state_21098__$1;
(statearr_21110_21132[(2)] = null);

(statearr_21110_21132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (9))){
var state_21098__$1 = state_21098;
var statearr_21111_21133 = state_21098__$1;
(statearr_21111_21133[(2)] = null);

(statearr_21111_21133[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (5))){
var state_21098__$1 = state_21098;
var statearr_21112_21134 = state_21098__$1;
(statearr_21112_21134[(2)] = null);

(statearr_21112_21134[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (10))){
var inst_21090 = (state_21098[(2)]);
var state_21098__$1 = state_21098;
var statearr_21113_21135 = state_21098__$1;
(statearr_21113_21135[(2)] = inst_21090);

(statearr_21113_21135[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21099 === (8))){
var inst_21080 = (state_21098[(7)]);
var state_21098__$1 = state_21098;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21098__$1,(11),out,inst_21080);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___21125,out))
;
return ((function (switch__10972__auto__,c__11084__auto___21125,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_21117 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21117[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_21117[(1)] = (1));

return statearr_21117;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_21098){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_21098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e21118){if((e21118 instanceof Object)){
var ex__10976__auto__ = e21118;
var statearr_21119_21136 = state_21098;
(statearr_21119_21136[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21118;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21137 = state_21098;
state_21098 = G__21137;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_21098){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_21098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___21125,out))
})();
var state__11086__auto__ = (function (){var statearr_21120 = f__11085__auto__.call(null);
(statearr_21120[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___21125);

return statearr_21120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___21125,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21145 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21145 = (function (map_LT_,f,ch,meta21146){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21146 = meta21146;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21147,meta21146__$1){
var self__ = this;
var _21147__$1 = this;
return (new cljs.core.async.t_cljs$core$async21145(self__.map_LT_,self__.f,self__.ch,meta21146__$1));
});

cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21147){
var self__ = this;
var _21147__$1 = this;
return self__.meta21146;
});

cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21148 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21148 = (function (map_LT_,f,ch,meta21146,_,fn1,meta21149){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21146 = meta21146;
this._ = _;
this.fn1 = fn1;
this.meta21149 = meta21149;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21150,meta21149__$1){
var self__ = this;
var _21150__$1 = this;
return (new cljs.core.async.t_cljs$core$async21148(self__.map_LT_,self__.f,self__.ch,self__.meta21146,self__._,self__.fn1,meta21149__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21150){
var self__ = this;
var _21150__$1 = this;
return self__.meta21149;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21138_SHARP_){
return f1.call(null,(((p1__21138_SHARP_ == null))?null:self__.f.call(null,p1__21138_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21148.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21146","meta21146",226074111,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21145","cljs.core.async/t_cljs$core$async21145",-247979114,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21149","meta21149",542309324,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21148.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21148.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21148";

cljs.core.async.t_cljs$core$async21148.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21148");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21148 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21148(map_LT___$1,f__$1,ch__$1,meta21146__$1,___$2,fn1__$1,meta21149){
return (new cljs.core.async.t_cljs$core$async21148(map_LT___$1,f__$1,ch__$1,meta21146__$1,___$2,fn1__$1,meta21149));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21148(self__.map_LT_,self__.f,self__.ch,self__.meta21146,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21145.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21145.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21146","meta21146",226074111,null)], null);
});

cljs.core.async.t_cljs$core$async21145.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21145.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21145";

cljs.core.async.t_cljs$core$async21145.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21145");
});

cljs.core.async.__GT_t_cljs$core$async21145 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21145(map_LT___$1,f__$1,ch__$1,meta21146){
return (new cljs.core.async.t_cljs$core$async21145(map_LT___$1,f__$1,ch__$1,meta21146));
});

}

return (new cljs.core.async.t_cljs$core$async21145(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21154 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21154 = (function (map_GT_,f,ch,meta21155){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21155 = meta21155;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21156,meta21155__$1){
var self__ = this;
var _21156__$1 = this;
return (new cljs.core.async.t_cljs$core$async21154(self__.map_GT_,self__.f,self__.ch,meta21155__$1));
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21156){
var self__ = this;
var _21156__$1 = this;
return self__.meta21155;
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21154.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21155","meta21155",-1897017005,null)], null);
});

cljs.core.async.t_cljs$core$async21154.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21154.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21154";

cljs.core.async.t_cljs$core$async21154.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21154");
});

cljs.core.async.__GT_t_cljs$core$async21154 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21154(map_GT___$1,f__$1,ch__$1,meta21155){
return (new cljs.core.async.t_cljs$core$async21154(map_GT___$1,f__$1,ch__$1,meta21155));
});

}

return (new cljs.core.async.t_cljs$core$async21154(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21160 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21160 = (function (filter_GT_,p,ch,meta21161){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21161 = meta21161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21162,meta21161__$1){
var self__ = this;
var _21162__$1 = this;
return (new cljs.core.async.t_cljs$core$async21160(self__.filter_GT_,self__.p,self__.ch,meta21161__$1));
});

cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21162){
var self__ = this;
var _21162__$1 = this;
return self__.meta21161;
});

cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21160.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21160.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21161","meta21161",-1321912609,null)], null);
});

cljs.core.async.t_cljs$core$async21160.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21160.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21160";

cljs.core.async.t_cljs$core$async21160.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21160");
});

cljs.core.async.__GT_t_cljs$core$async21160 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21160(filter_GT___$1,p__$1,ch__$1,meta21161){
return (new cljs.core.async.t_cljs$core$async21160(filter_GT___$1,p__$1,ch__$1,meta21161));
});

}

return (new cljs.core.async.t_cljs$core$async21160(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21163 = [];
var len__5726__auto___21207 = arguments.length;
var i__5727__auto___21208 = (0);
while(true){
if((i__5727__auto___21208 < len__5726__auto___21207)){
args21163.push((arguments[i__5727__auto___21208]));

var G__21209 = (i__5727__auto___21208 + (1));
i__5727__auto___21208 = G__21209;
continue;
} else {
}
break;
}

var G__21165 = args21163.length;
switch (G__21165) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21163.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___21211 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___21211,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___21211,out){
return (function (state_21186){
var state_val_21187 = (state_21186[(1)]);
if((state_val_21187 === (7))){
var inst_21182 = (state_21186[(2)]);
var state_21186__$1 = state_21186;
var statearr_21188_21212 = state_21186__$1;
(statearr_21188_21212[(2)] = inst_21182);

(statearr_21188_21212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21187 === (1))){
var state_21186__$1 = state_21186;
var statearr_21189_21213 = state_21186__$1;
(statearr_21189_21213[(2)] = null);

(statearr_21189_21213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21187 === (4))){
var inst_21168 = (state_21186[(7)]);
var inst_21168__$1 = (state_21186[(2)]);
var inst_21169 = (inst_21168__$1 == null);
var state_21186__$1 = (function (){var statearr_21190 = state_21186;
(statearr_21190[(7)] = inst_21168__$1);

return statearr_21190;
})();
if(cljs.core.truth_(inst_21169)){
var statearr_21191_21214 = state_21186__$1;
(statearr_21191_21214[(1)] = (5));

} else {
var statearr_21192_21215 = state_21186__$1;
(statearr_21192_21215[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21187 === (6))){
var inst_21168 = (state_21186[(7)]);
var inst_21173 = p.call(null,inst_21168);
var state_21186__$1 = state_21186;
if(cljs.core.truth_(inst_21173)){
var statearr_21193_21216 = state_21186__$1;
(statearr_21193_21216[(1)] = (8));

} else {
var statearr_21194_21217 = state_21186__$1;
(statearr_21194_21217[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21187 === (3))){
var inst_21184 = (state_21186[(2)]);
var state_21186__$1 = state_21186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21186__$1,inst_21184);
} else {
if((state_val_21187 === (2))){
var state_21186__$1 = state_21186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21186__$1,(4),ch);
} else {
if((state_val_21187 === (11))){
var inst_21176 = (state_21186[(2)]);
var state_21186__$1 = state_21186;
var statearr_21195_21218 = state_21186__$1;
(statearr_21195_21218[(2)] = inst_21176);

(statearr_21195_21218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21187 === (9))){
var state_21186__$1 = state_21186;
var statearr_21196_21219 = state_21186__$1;
(statearr_21196_21219[(2)] = null);

(statearr_21196_21219[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21187 === (5))){
var inst_21171 = cljs.core.async.close_BANG_.call(null,out);
var state_21186__$1 = state_21186;
var statearr_21197_21220 = state_21186__$1;
(statearr_21197_21220[(2)] = inst_21171);

(statearr_21197_21220[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21187 === (10))){
var inst_21179 = (state_21186[(2)]);
var state_21186__$1 = (function (){var statearr_21198 = state_21186;
(statearr_21198[(8)] = inst_21179);

return statearr_21198;
})();
var statearr_21199_21221 = state_21186__$1;
(statearr_21199_21221[(2)] = null);

(statearr_21199_21221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21187 === (8))){
var inst_21168 = (state_21186[(7)]);
var state_21186__$1 = state_21186;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21186__$1,(11),out,inst_21168);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___21211,out))
;
return ((function (switch__10972__auto__,c__11084__auto___21211,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_21203 = [null,null,null,null,null,null,null,null,null];
(statearr_21203[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_21203[(1)] = (1));

return statearr_21203;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_21186){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_21186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e21204){if((e21204 instanceof Object)){
var ex__10976__auto__ = e21204;
var statearr_21205_21222 = state_21186;
(statearr_21205_21222[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21186);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21204;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21223 = state_21186;
state_21186 = G__21223;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_21186){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_21186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___21211,out))
})();
var state__11086__auto__ = (function (){var statearr_21206 = f__11085__auto__.call(null);
(statearr_21206[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___21211);

return statearr_21206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___21211,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21224 = [];
var len__5726__auto___21227 = arguments.length;
var i__5727__auto___21228 = (0);
while(true){
if((i__5727__auto___21228 < len__5726__auto___21227)){
args21224.push((arguments[i__5727__auto___21228]));

var G__21229 = (i__5727__auto___21228 + (1));
i__5727__auto___21228 = G__21229;
continue;
} else {
}
break;
}

var G__21226 = args21224.length;
switch (G__21226) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21224.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11084__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto__){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto__){
return (function (state_21396){
var state_val_21397 = (state_21396[(1)]);
if((state_val_21397 === (7))){
var inst_21392 = (state_21396[(2)]);
var state_21396__$1 = state_21396;
var statearr_21398_21439 = state_21396__$1;
(statearr_21398_21439[(2)] = inst_21392);

(statearr_21398_21439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (20))){
var inst_21362 = (state_21396[(7)]);
var inst_21373 = (state_21396[(2)]);
var inst_21374 = cljs.core.next.call(null,inst_21362);
var inst_21348 = inst_21374;
var inst_21349 = null;
var inst_21350 = (0);
var inst_21351 = (0);
var state_21396__$1 = (function (){var statearr_21399 = state_21396;
(statearr_21399[(8)] = inst_21349);

(statearr_21399[(9)] = inst_21351);

(statearr_21399[(10)] = inst_21348);

(statearr_21399[(11)] = inst_21350);

(statearr_21399[(12)] = inst_21373);

return statearr_21399;
})();
var statearr_21400_21440 = state_21396__$1;
(statearr_21400_21440[(2)] = null);

(statearr_21400_21440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (1))){
var state_21396__$1 = state_21396;
var statearr_21401_21441 = state_21396__$1;
(statearr_21401_21441[(2)] = null);

(statearr_21401_21441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (4))){
var inst_21337 = (state_21396[(13)]);
var inst_21337__$1 = (state_21396[(2)]);
var inst_21338 = (inst_21337__$1 == null);
var state_21396__$1 = (function (){var statearr_21402 = state_21396;
(statearr_21402[(13)] = inst_21337__$1);

return statearr_21402;
})();
if(cljs.core.truth_(inst_21338)){
var statearr_21403_21442 = state_21396__$1;
(statearr_21403_21442[(1)] = (5));

} else {
var statearr_21404_21443 = state_21396__$1;
(statearr_21404_21443[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (15))){
var state_21396__$1 = state_21396;
var statearr_21408_21444 = state_21396__$1;
(statearr_21408_21444[(2)] = null);

(statearr_21408_21444[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (21))){
var state_21396__$1 = state_21396;
var statearr_21409_21445 = state_21396__$1;
(statearr_21409_21445[(2)] = null);

(statearr_21409_21445[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (13))){
var inst_21349 = (state_21396[(8)]);
var inst_21351 = (state_21396[(9)]);
var inst_21348 = (state_21396[(10)]);
var inst_21350 = (state_21396[(11)]);
var inst_21358 = (state_21396[(2)]);
var inst_21359 = (inst_21351 + (1));
var tmp21405 = inst_21349;
var tmp21406 = inst_21348;
var tmp21407 = inst_21350;
var inst_21348__$1 = tmp21406;
var inst_21349__$1 = tmp21405;
var inst_21350__$1 = tmp21407;
var inst_21351__$1 = inst_21359;
var state_21396__$1 = (function (){var statearr_21410 = state_21396;
(statearr_21410[(8)] = inst_21349__$1);

(statearr_21410[(9)] = inst_21351__$1);

(statearr_21410[(10)] = inst_21348__$1);

(statearr_21410[(11)] = inst_21350__$1);

(statearr_21410[(14)] = inst_21358);

return statearr_21410;
})();
var statearr_21411_21446 = state_21396__$1;
(statearr_21411_21446[(2)] = null);

(statearr_21411_21446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (22))){
var state_21396__$1 = state_21396;
var statearr_21412_21447 = state_21396__$1;
(statearr_21412_21447[(2)] = null);

(statearr_21412_21447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (6))){
var inst_21337 = (state_21396[(13)]);
var inst_21346 = f.call(null,inst_21337);
var inst_21347 = cljs.core.seq.call(null,inst_21346);
var inst_21348 = inst_21347;
var inst_21349 = null;
var inst_21350 = (0);
var inst_21351 = (0);
var state_21396__$1 = (function (){var statearr_21413 = state_21396;
(statearr_21413[(8)] = inst_21349);

(statearr_21413[(9)] = inst_21351);

(statearr_21413[(10)] = inst_21348);

(statearr_21413[(11)] = inst_21350);

return statearr_21413;
})();
var statearr_21414_21448 = state_21396__$1;
(statearr_21414_21448[(2)] = null);

(statearr_21414_21448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (17))){
var inst_21362 = (state_21396[(7)]);
var inst_21366 = cljs.core.chunk_first.call(null,inst_21362);
var inst_21367 = cljs.core.chunk_rest.call(null,inst_21362);
var inst_21368 = cljs.core.count.call(null,inst_21366);
var inst_21348 = inst_21367;
var inst_21349 = inst_21366;
var inst_21350 = inst_21368;
var inst_21351 = (0);
var state_21396__$1 = (function (){var statearr_21415 = state_21396;
(statearr_21415[(8)] = inst_21349);

(statearr_21415[(9)] = inst_21351);

(statearr_21415[(10)] = inst_21348);

(statearr_21415[(11)] = inst_21350);

return statearr_21415;
})();
var statearr_21416_21449 = state_21396__$1;
(statearr_21416_21449[(2)] = null);

(statearr_21416_21449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (3))){
var inst_21394 = (state_21396[(2)]);
var state_21396__$1 = state_21396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21396__$1,inst_21394);
} else {
if((state_val_21397 === (12))){
var inst_21382 = (state_21396[(2)]);
var state_21396__$1 = state_21396;
var statearr_21417_21450 = state_21396__$1;
(statearr_21417_21450[(2)] = inst_21382);

(statearr_21417_21450[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (2))){
var state_21396__$1 = state_21396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21396__$1,(4),in$);
} else {
if((state_val_21397 === (23))){
var inst_21390 = (state_21396[(2)]);
var state_21396__$1 = state_21396;
var statearr_21418_21451 = state_21396__$1;
(statearr_21418_21451[(2)] = inst_21390);

(statearr_21418_21451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (19))){
var inst_21377 = (state_21396[(2)]);
var state_21396__$1 = state_21396;
var statearr_21419_21452 = state_21396__$1;
(statearr_21419_21452[(2)] = inst_21377);

(statearr_21419_21452[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (11))){
var inst_21348 = (state_21396[(10)]);
var inst_21362 = (state_21396[(7)]);
var inst_21362__$1 = cljs.core.seq.call(null,inst_21348);
var state_21396__$1 = (function (){var statearr_21420 = state_21396;
(statearr_21420[(7)] = inst_21362__$1);

return statearr_21420;
})();
if(inst_21362__$1){
var statearr_21421_21453 = state_21396__$1;
(statearr_21421_21453[(1)] = (14));

} else {
var statearr_21422_21454 = state_21396__$1;
(statearr_21422_21454[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (9))){
var inst_21384 = (state_21396[(2)]);
var inst_21385 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21396__$1 = (function (){var statearr_21423 = state_21396;
(statearr_21423[(15)] = inst_21384);

return statearr_21423;
})();
if(cljs.core.truth_(inst_21385)){
var statearr_21424_21455 = state_21396__$1;
(statearr_21424_21455[(1)] = (21));

} else {
var statearr_21425_21456 = state_21396__$1;
(statearr_21425_21456[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (5))){
var inst_21340 = cljs.core.async.close_BANG_.call(null,out);
var state_21396__$1 = state_21396;
var statearr_21426_21457 = state_21396__$1;
(statearr_21426_21457[(2)] = inst_21340);

(statearr_21426_21457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (14))){
var inst_21362 = (state_21396[(7)]);
var inst_21364 = cljs.core.chunked_seq_QMARK_.call(null,inst_21362);
var state_21396__$1 = state_21396;
if(inst_21364){
var statearr_21427_21458 = state_21396__$1;
(statearr_21427_21458[(1)] = (17));

} else {
var statearr_21428_21459 = state_21396__$1;
(statearr_21428_21459[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (16))){
var inst_21380 = (state_21396[(2)]);
var state_21396__$1 = state_21396;
var statearr_21429_21460 = state_21396__$1;
(statearr_21429_21460[(2)] = inst_21380);

(statearr_21429_21460[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21397 === (10))){
var inst_21349 = (state_21396[(8)]);
var inst_21351 = (state_21396[(9)]);
var inst_21356 = cljs.core._nth.call(null,inst_21349,inst_21351);
var state_21396__$1 = state_21396;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21396__$1,(13),out,inst_21356);
} else {
if((state_val_21397 === (18))){
var inst_21362 = (state_21396[(7)]);
var inst_21371 = cljs.core.first.call(null,inst_21362);
var state_21396__$1 = state_21396;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21396__$1,(20),out,inst_21371);
} else {
if((state_val_21397 === (8))){
var inst_21351 = (state_21396[(9)]);
var inst_21350 = (state_21396[(11)]);
var inst_21353 = (inst_21351 < inst_21350);
var inst_21354 = inst_21353;
var state_21396__$1 = state_21396;
if(cljs.core.truth_(inst_21354)){
var statearr_21430_21461 = state_21396__$1;
(statearr_21430_21461[(1)] = (10));

} else {
var statearr_21431_21462 = state_21396__$1;
(statearr_21431_21462[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto__))
;
return ((function (switch__10972__auto__,c__11084__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_21435 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21435[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__);

(statearr_21435[(1)] = (1));

return statearr_21435;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____1 = (function (state_21396){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_21396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e21436){if((e21436 instanceof Object)){
var ex__10976__auto__ = e21436;
var statearr_21437_21463 = state_21396;
(statearr_21437_21463[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21436;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21464 = state_21396;
state_21396 = G__21464;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__ = function(state_21396){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____1.call(this,state_21396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto__))
})();
var state__11086__auto__ = (function (){var statearr_21438 = f__11085__auto__.call(null);
(statearr_21438[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto__);

return statearr_21438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto__))
);

return c__11084__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21465 = [];
var len__5726__auto___21468 = arguments.length;
var i__5727__auto___21469 = (0);
while(true){
if((i__5727__auto___21469 < len__5726__auto___21468)){
args21465.push((arguments[i__5727__auto___21469]));

var G__21470 = (i__5727__auto___21469 + (1));
i__5727__auto___21469 = G__21470;
continue;
} else {
}
break;
}

var G__21467 = args21465.length;
switch (G__21467) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21465.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21472 = [];
var len__5726__auto___21475 = arguments.length;
var i__5727__auto___21476 = (0);
while(true){
if((i__5727__auto___21476 < len__5726__auto___21475)){
args21472.push((arguments[i__5727__auto___21476]));

var G__21477 = (i__5727__auto___21476 + (1));
i__5727__auto___21476 = G__21477;
continue;
} else {
}
break;
}

var G__21474 = args21472.length;
switch (G__21474) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21472.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21479 = [];
var len__5726__auto___21530 = arguments.length;
var i__5727__auto___21531 = (0);
while(true){
if((i__5727__auto___21531 < len__5726__auto___21530)){
args21479.push((arguments[i__5727__auto___21531]));

var G__21532 = (i__5727__auto___21531 + (1));
i__5727__auto___21531 = G__21532;
continue;
} else {
}
break;
}

var G__21481 = args21479.length;
switch (G__21481) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21479.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___21534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___21534,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___21534,out){
return (function (state_21505){
var state_val_21506 = (state_21505[(1)]);
if((state_val_21506 === (7))){
var inst_21500 = (state_21505[(2)]);
var state_21505__$1 = state_21505;
var statearr_21507_21535 = state_21505__$1;
(statearr_21507_21535[(2)] = inst_21500);

(statearr_21507_21535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (1))){
var inst_21482 = null;
var state_21505__$1 = (function (){var statearr_21508 = state_21505;
(statearr_21508[(7)] = inst_21482);

return statearr_21508;
})();
var statearr_21509_21536 = state_21505__$1;
(statearr_21509_21536[(2)] = null);

(statearr_21509_21536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (4))){
var inst_21485 = (state_21505[(8)]);
var inst_21485__$1 = (state_21505[(2)]);
var inst_21486 = (inst_21485__$1 == null);
var inst_21487 = cljs.core.not.call(null,inst_21486);
var state_21505__$1 = (function (){var statearr_21510 = state_21505;
(statearr_21510[(8)] = inst_21485__$1);

return statearr_21510;
})();
if(inst_21487){
var statearr_21511_21537 = state_21505__$1;
(statearr_21511_21537[(1)] = (5));

} else {
var statearr_21512_21538 = state_21505__$1;
(statearr_21512_21538[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (6))){
var state_21505__$1 = state_21505;
var statearr_21513_21539 = state_21505__$1;
(statearr_21513_21539[(2)] = null);

(statearr_21513_21539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (3))){
var inst_21502 = (state_21505[(2)]);
var inst_21503 = cljs.core.async.close_BANG_.call(null,out);
var state_21505__$1 = (function (){var statearr_21514 = state_21505;
(statearr_21514[(9)] = inst_21502);

return statearr_21514;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21505__$1,inst_21503);
} else {
if((state_val_21506 === (2))){
var state_21505__$1 = state_21505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21505__$1,(4),ch);
} else {
if((state_val_21506 === (11))){
var inst_21485 = (state_21505[(8)]);
var inst_21494 = (state_21505[(2)]);
var inst_21482 = inst_21485;
var state_21505__$1 = (function (){var statearr_21515 = state_21505;
(statearr_21515[(10)] = inst_21494);

(statearr_21515[(7)] = inst_21482);

return statearr_21515;
})();
var statearr_21516_21540 = state_21505__$1;
(statearr_21516_21540[(2)] = null);

(statearr_21516_21540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (9))){
var inst_21485 = (state_21505[(8)]);
var state_21505__$1 = state_21505;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21505__$1,(11),out,inst_21485);
} else {
if((state_val_21506 === (5))){
var inst_21485 = (state_21505[(8)]);
var inst_21482 = (state_21505[(7)]);
var inst_21489 = cljs.core._EQ_.call(null,inst_21485,inst_21482);
var state_21505__$1 = state_21505;
if(inst_21489){
var statearr_21518_21541 = state_21505__$1;
(statearr_21518_21541[(1)] = (8));

} else {
var statearr_21519_21542 = state_21505__$1;
(statearr_21519_21542[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (10))){
var inst_21497 = (state_21505[(2)]);
var state_21505__$1 = state_21505;
var statearr_21520_21543 = state_21505__$1;
(statearr_21520_21543[(2)] = inst_21497);

(statearr_21520_21543[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21506 === (8))){
var inst_21482 = (state_21505[(7)]);
var tmp21517 = inst_21482;
var inst_21482__$1 = tmp21517;
var state_21505__$1 = (function (){var statearr_21521 = state_21505;
(statearr_21521[(7)] = inst_21482__$1);

return statearr_21521;
})();
var statearr_21522_21544 = state_21505__$1;
(statearr_21522_21544[(2)] = null);

(statearr_21522_21544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___21534,out))
;
return ((function (switch__10972__auto__,c__11084__auto___21534,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_21526 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21526[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_21526[(1)] = (1));

return statearr_21526;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_21505){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_21505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e21527){if((e21527 instanceof Object)){
var ex__10976__auto__ = e21527;
var statearr_21528_21545 = state_21505;
(statearr_21528_21545[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21505);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21527;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21546 = state_21505;
state_21505 = G__21546;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_21505){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_21505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___21534,out))
})();
var state__11086__auto__ = (function (){var statearr_21529 = f__11085__auto__.call(null);
(statearr_21529[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___21534);

return statearr_21529;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___21534,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21547 = [];
var len__5726__auto___21617 = arguments.length;
var i__5727__auto___21618 = (0);
while(true){
if((i__5727__auto___21618 < len__5726__auto___21617)){
args21547.push((arguments[i__5727__auto___21618]));

var G__21619 = (i__5727__auto___21618 + (1));
i__5727__auto___21618 = G__21619;
continue;
} else {
}
break;
}

var G__21549 = args21547.length;
switch (G__21549) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21547.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___21621 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___21621,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___21621,out){
return (function (state_21587){
var state_val_21588 = (state_21587[(1)]);
if((state_val_21588 === (7))){
var inst_21583 = (state_21587[(2)]);
var state_21587__$1 = state_21587;
var statearr_21589_21622 = state_21587__$1;
(statearr_21589_21622[(2)] = inst_21583);

(statearr_21589_21622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (1))){
var inst_21550 = (new Array(n));
var inst_21551 = inst_21550;
var inst_21552 = (0);
var state_21587__$1 = (function (){var statearr_21590 = state_21587;
(statearr_21590[(7)] = inst_21552);

(statearr_21590[(8)] = inst_21551);

return statearr_21590;
})();
var statearr_21591_21623 = state_21587__$1;
(statearr_21591_21623[(2)] = null);

(statearr_21591_21623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (4))){
var inst_21555 = (state_21587[(9)]);
var inst_21555__$1 = (state_21587[(2)]);
var inst_21556 = (inst_21555__$1 == null);
var inst_21557 = cljs.core.not.call(null,inst_21556);
var state_21587__$1 = (function (){var statearr_21592 = state_21587;
(statearr_21592[(9)] = inst_21555__$1);

return statearr_21592;
})();
if(inst_21557){
var statearr_21593_21624 = state_21587__$1;
(statearr_21593_21624[(1)] = (5));

} else {
var statearr_21594_21625 = state_21587__$1;
(statearr_21594_21625[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (15))){
var inst_21577 = (state_21587[(2)]);
var state_21587__$1 = state_21587;
var statearr_21595_21626 = state_21587__$1;
(statearr_21595_21626[(2)] = inst_21577);

(statearr_21595_21626[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (13))){
var state_21587__$1 = state_21587;
var statearr_21596_21627 = state_21587__$1;
(statearr_21596_21627[(2)] = null);

(statearr_21596_21627[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (6))){
var inst_21552 = (state_21587[(7)]);
var inst_21573 = (inst_21552 > (0));
var state_21587__$1 = state_21587;
if(cljs.core.truth_(inst_21573)){
var statearr_21597_21628 = state_21587__$1;
(statearr_21597_21628[(1)] = (12));

} else {
var statearr_21598_21629 = state_21587__$1;
(statearr_21598_21629[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (3))){
var inst_21585 = (state_21587[(2)]);
var state_21587__$1 = state_21587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21587__$1,inst_21585);
} else {
if((state_val_21588 === (12))){
var inst_21551 = (state_21587[(8)]);
var inst_21575 = cljs.core.vec.call(null,inst_21551);
var state_21587__$1 = state_21587;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21587__$1,(15),out,inst_21575);
} else {
if((state_val_21588 === (2))){
var state_21587__$1 = state_21587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21587__$1,(4),ch);
} else {
if((state_val_21588 === (11))){
var inst_21567 = (state_21587[(2)]);
var inst_21568 = (new Array(n));
var inst_21551 = inst_21568;
var inst_21552 = (0);
var state_21587__$1 = (function (){var statearr_21599 = state_21587;
(statearr_21599[(7)] = inst_21552);

(statearr_21599[(8)] = inst_21551);

(statearr_21599[(10)] = inst_21567);

return statearr_21599;
})();
var statearr_21600_21630 = state_21587__$1;
(statearr_21600_21630[(2)] = null);

(statearr_21600_21630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (9))){
var inst_21551 = (state_21587[(8)]);
var inst_21565 = cljs.core.vec.call(null,inst_21551);
var state_21587__$1 = state_21587;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21587__$1,(11),out,inst_21565);
} else {
if((state_val_21588 === (5))){
var inst_21560 = (state_21587[(11)]);
var inst_21552 = (state_21587[(7)]);
var inst_21555 = (state_21587[(9)]);
var inst_21551 = (state_21587[(8)]);
var inst_21559 = (inst_21551[inst_21552] = inst_21555);
var inst_21560__$1 = (inst_21552 + (1));
var inst_21561 = (inst_21560__$1 < n);
var state_21587__$1 = (function (){var statearr_21601 = state_21587;
(statearr_21601[(12)] = inst_21559);

(statearr_21601[(11)] = inst_21560__$1);

return statearr_21601;
})();
if(cljs.core.truth_(inst_21561)){
var statearr_21602_21631 = state_21587__$1;
(statearr_21602_21631[(1)] = (8));

} else {
var statearr_21603_21632 = state_21587__$1;
(statearr_21603_21632[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (14))){
var inst_21580 = (state_21587[(2)]);
var inst_21581 = cljs.core.async.close_BANG_.call(null,out);
var state_21587__$1 = (function (){var statearr_21605 = state_21587;
(statearr_21605[(13)] = inst_21580);

return statearr_21605;
})();
var statearr_21606_21633 = state_21587__$1;
(statearr_21606_21633[(2)] = inst_21581);

(statearr_21606_21633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (10))){
var inst_21571 = (state_21587[(2)]);
var state_21587__$1 = state_21587;
var statearr_21607_21634 = state_21587__$1;
(statearr_21607_21634[(2)] = inst_21571);

(statearr_21607_21634[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21588 === (8))){
var inst_21560 = (state_21587[(11)]);
var inst_21551 = (state_21587[(8)]);
var tmp21604 = inst_21551;
var inst_21551__$1 = tmp21604;
var inst_21552 = inst_21560;
var state_21587__$1 = (function (){var statearr_21608 = state_21587;
(statearr_21608[(7)] = inst_21552);

(statearr_21608[(8)] = inst_21551__$1);

return statearr_21608;
})();
var statearr_21609_21635 = state_21587__$1;
(statearr_21609_21635[(2)] = null);

(statearr_21609_21635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___21621,out))
;
return ((function (switch__10972__auto__,c__11084__auto___21621,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_21613 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21613[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_21613[(1)] = (1));

return statearr_21613;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_21587){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_21587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e21614){if((e21614 instanceof Object)){
var ex__10976__auto__ = e21614;
var statearr_21615_21636 = state_21587;
(statearr_21615_21636[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21587);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21614;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21637 = state_21587;
state_21587 = G__21637;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_21587){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_21587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___21621,out))
})();
var state__11086__auto__ = (function (){var statearr_21616 = f__11085__auto__.call(null);
(statearr_21616[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___21621);

return statearr_21616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___21621,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21638 = [];
var len__5726__auto___21712 = arguments.length;
var i__5727__auto___21713 = (0);
while(true){
if((i__5727__auto___21713 < len__5726__auto___21712)){
args21638.push((arguments[i__5727__auto___21713]));

var G__21714 = (i__5727__auto___21713 + (1));
i__5727__auto___21713 = G__21714;
continue;
} else {
}
break;
}

var G__21640 = args21638.length;
switch (G__21640) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21638.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___21716 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___21716,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___21716,out){
return (function (state_21682){
var state_val_21683 = (state_21682[(1)]);
if((state_val_21683 === (7))){
var inst_21678 = (state_21682[(2)]);
var state_21682__$1 = state_21682;
var statearr_21684_21717 = state_21682__$1;
(statearr_21684_21717[(2)] = inst_21678);

(statearr_21684_21717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (1))){
var inst_21641 = [];
var inst_21642 = inst_21641;
var inst_21643 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21682__$1 = (function (){var statearr_21685 = state_21682;
(statearr_21685[(7)] = inst_21643);

(statearr_21685[(8)] = inst_21642);

return statearr_21685;
})();
var statearr_21686_21718 = state_21682__$1;
(statearr_21686_21718[(2)] = null);

(statearr_21686_21718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (4))){
var inst_21646 = (state_21682[(9)]);
var inst_21646__$1 = (state_21682[(2)]);
var inst_21647 = (inst_21646__$1 == null);
var inst_21648 = cljs.core.not.call(null,inst_21647);
var state_21682__$1 = (function (){var statearr_21687 = state_21682;
(statearr_21687[(9)] = inst_21646__$1);

return statearr_21687;
})();
if(inst_21648){
var statearr_21688_21719 = state_21682__$1;
(statearr_21688_21719[(1)] = (5));

} else {
var statearr_21689_21720 = state_21682__$1;
(statearr_21689_21720[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (15))){
var inst_21672 = (state_21682[(2)]);
var state_21682__$1 = state_21682;
var statearr_21690_21721 = state_21682__$1;
(statearr_21690_21721[(2)] = inst_21672);

(statearr_21690_21721[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (13))){
var state_21682__$1 = state_21682;
var statearr_21691_21722 = state_21682__$1;
(statearr_21691_21722[(2)] = null);

(statearr_21691_21722[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (6))){
var inst_21642 = (state_21682[(8)]);
var inst_21667 = inst_21642.length;
var inst_21668 = (inst_21667 > (0));
var state_21682__$1 = state_21682;
if(cljs.core.truth_(inst_21668)){
var statearr_21692_21723 = state_21682__$1;
(statearr_21692_21723[(1)] = (12));

} else {
var statearr_21693_21724 = state_21682__$1;
(statearr_21693_21724[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (3))){
var inst_21680 = (state_21682[(2)]);
var state_21682__$1 = state_21682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21682__$1,inst_21680);
} else {
if((state_val_21683 === (12))){
var inst_21642 = (state_21682[(8)]);
var inst_21670 = cljs.core.vec.call(null,inst_21642);
var state_21682__$1 = state_21682;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21682__$1,(15),out,inst_21670);
} else {
if((state_val_21683 === (2))){
var state_21682__$1 = state_21682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21682__$1,(4),ch);
} else {
if((state_val_21683 === (11))){
var inst_21646 = (state_21682[(9)]);
var inst_21650 = (state_21682[(10)]);
var inst_21660 = (state_21682[(2)]);
var inst_21661 = [];
var inst_21662 = inst_21661.push(inst_21646);
var inst_21642 = inst_21661;
var inst_21643 = inst_21650;
var state_21682__$1 = (function (){var statearr_21694 = state_21682;
(statearr_21694[(7)] = inst_21643);

(statearr_21694[(8)] = inst_21642);

(statearr_21694[(11)] = inst_21660);

(statearr_21694[(12)] = inst_21662);

return statearr_21694;
})();
var statearr_21695_21725 = state_21682__$1;
(statearr_21695_21725[(2)] = null);

(statearr_21695_21725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (9))){
var inst_21642 = (state_21682[(8)]);
var inst_21658 = cljs.core.vec.call(null,inst_21642);
var state_21682__$1 = state_21682;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21682__$1,(11),out,inst_21658);
} else {
if((state_val_21683 === (5))){
var inst_21643 = (state_21682[(7)]);
var inst_21646 = (state_21682[(9)]);
var inst_21650 = (state_21682[(10)]);
var inst_21650__$1 = f.call(null,inst_21646);
var inst_21651 = cljs.core._EQ_.call(null,inst_21650__$1,inst_21643);
var inst_21652 = cljs.core.keyword_identical_QMARK_.call(null,inst_21643,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21653 = (inst_21651) || (inst_21652);
var state_21682__$1 = (function (){var statearr_21696 = state_21682;
(statearr_21696[(10)] = inst_21650__$1);

return statearr_21696;
})();
if(cljs.core.truth_(inst_21653)){
var statearr_21697_21726 = state_21682__$1;
(statearr_21697_21726[(1)] = (8));

} else {
var statearr_21698_21727 = state_21682__$1;
(statearr_21698_21727[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (14))){
var inst_21675 = (state_21682[(2)]);
var inst_21676 = cljs.core.async.close_BANG_.call(null,out);
var state_21682__$1 = (function (){var statearr_21700 = state_21682;
(statearr_21700[(13)] = inst_21675);

return statearr_21700;
})();
var statearr_21701_21728 = state_21682__$1;
(statearr_21701_21728[(2)] = inst_21676);

(statearr_21701_21728[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (10))){
var inst_21665 = (state_21682[(2)]);
var state_21682__$1 = state_21682;
var statearr_21702_21729 = state_21682__$1;
(statearr_21702_21729[(2)] = inst_21665);

(statearr_21702_21729[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21683 === (8))){
var inst_21642 = (state_21682[(8)]);
var inst_21646 = (state_21682[(9)]);
var inst_21650 = (state_21682[(10)]);
var inst_21655 = inst_21642.push(inst_21646);
var tmp21699 = inst_21642;
var inst_21642__$1 = tmp21699;
var inst_21643 = inst_21650;
var state_21682__$1 = (function (){var statearr_21703 = state_21682;
(statearr_21703[(7)] = inst_21643);

(statearr_21703[(8)] = inst_21642__$1);

(statearr_21703[(14)] = inst_21655);

return statearr_21703;
})();
var statearr_21704_21730 = state_21682__$1;
(statearr_21704_21730[(2)] = null);

(statearr_21704_21730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___21716,out))
;
return ((function (switch__10972__auto__,c__11084__auto___21716,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_21708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21708[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_21708[(1)] = (1));

return statearr_21708;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_21682){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_21682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e21709){if((e21709 instanceof Object)){
var ex__10976__auto__ = e21709;
var statearr_21710_21731 = state_21682;
(statearr_21710_21731[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21682);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21709;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21732 = state_21682;
state_21682 = G__21732;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_21682){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_21682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___21716,out))
})();
var state__11086__auto__ = (function (){var statearr_21711 = f__11085__auto__.call(null);
(statearr_21711[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___21716);

return statearr_21711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___21716,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1465203443981