// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11129 = [];
var len__5726__auto___11135 = arguments.length;
var i__5727__auto___11136 = (0);
while(true){
if((i__5727__auto___11136 < len__5726__auto___11135)){
args11129.push((arguments[i__5727__auto___11136]));

var G__11137 = (i__5727__auto___11136 + (1));
i__5727__auto___11136 = G__11137;
continue;
} else {
}
break;
}

var G__11131 = args11129.length;
switch (G__11131) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11129.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11132 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11132 = (function (f,blockable,meta11133){
this.f = f;
this.blockable = blockable;
this.meta11133 = meta11133;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11132.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11134,meta11133__$1){
var self__ = this;
var _11134__$1 = this;
return (new cljs.core.async.t_cljs$core$async11132(self__.f,self__.blockable,meta11133__$1));
});

cljs.core.async.t_cljs$core$async11132.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11134){
var self__ = this;
var _11134__$1 = this;
return self__.meta11133;
});

cljs.core.async.t_cljs$core$async11132.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11132.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11132.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11132.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11132.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11133","meta11133",-837350292,null)], null);
});

cljs.core.async.t_cljs$core$async11132.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11132.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11132";

cljs.core.async.t_cljs$core$async11132.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11132");
});

cljs.core.async.__GT_t_cljs$core$async11132 = (function cljs$core$async$__GT_t_cljs$core$async11132(f__$1,blockable__$1,meta11133){
return (new cljs.core.async.t_cljs$core$async11132(f__$1,blockable__$1,meta11133));
});

}

return (new cljs.core.async.t_cljs$core$async11132(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11141 = [];
var len__5726__auto___11144 = arguments.length;
var i__5727__auto___11145 = (0);
while(true){
if((i__5727__auto___11145 < len__5726__auto___11144)){
args11141.push((arguments[i__5727__auto___11145]));

var G__11146 = (i__5727__auto___11145 + (1));
i__5727__auto___11145 = G__11146;
continue;
} else {
}
break;
}

var G__11143 = args11141.length;
switch (G__11143) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11141.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11148 = [];
var len__5726__auto___11151 = arguments.length;
var i__5727__auto___11152 = (0);
while(true){
if((i__5727__auto___11152 < len__5726__auto___11151)){
args11148.push((arguments[i__5727__auto___11152]));

var G__11153 = (i__5727__auto___11152 + (1));
i__5727__auto___11152 = G__11153;
continue;
} else {
}
break;
}

var G__11150 = args11148.length;
switch (G__11150) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11148.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11155 = [];
var len__5726__auto___11158 = arguments.length;
var i__5727__auto___11159 = (0);
while(true){
if((i__5727__auto___11159 < len__5726__auto___11158)){
args11155.push((arguments[i__5727__auto___11159]));

var G__11160 = (i__5727__auto___11159 + (1));
i__5727__auto___11159 = G__11160;
continue;
} else {
}
break;
}

var G__11157 = args11155.length;
switch (G__11157) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11155.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11162 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11162);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11162,ret){
return (function (){
return fn1.call(null,val_11162);
});})(val_11162,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11163 = [];
var len__5726__auto___11166 = arguments.length;
var i__5727__auto___11167 = (0);
while(true){
if((i__5727__auto___11167 < len__5726__auto___11166)){
args11163.push((arguments[i__5727__auto___11167]));

var G__11168 = (i__5727__auto___11167 + (1));
i__5727__auto___11167 = G__11168;
continue;
} else {
}
break;
}

var G__11165 = args11163.length;
switch (G__11165) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11163.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___11170 = n;
var x_11171 = (0);
while(true){
if((x_11171 < n__5571__auto___11170)){
(a[x_11171] = (0));

var G__11172 = (x_11171 + (1));
x_11171 = G__11172;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11173 = (i + (1));
i = G__11173;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11177 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11177 = (function (alt_flag,flag,meta11178){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11178 = meta11178;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11177.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11179,meta11178__$1){
var self__ = this;
var _11179__$1 = this;
return (new cljs.core.async.t_cljs$core$async11177(self__.alt_flag,self__.flag,meta11178__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11177.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11179){
var self__ = this;
var _11179__$1 = this;
return self__.meta11178;
});})(flag))
;

cljs.core.async.t_cljs$core$async11177.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11177.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11177.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11177.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11177.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11178","meta11178",507739297,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11177.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11177.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11177";

cljs.core.async.t_cljs$core$async11177.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11177");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11177 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11177(alt_flag__$1,flag__$1,meta11178){
return (new cljs.core.async.t_cljs$core$async11177(alt_flag__$1,flag__$1,meta11178));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11177(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11183 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11183 = (function (alt_handler,flag,cb,meta11184){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11184 = meta11184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11185,meta11184__$1){
var self__ = this;
var _11185__$1 = this;
return (new cljs.core.async.t_cljs$core$async11183(self__.alt_handler,self__.flag,self__.cb,meta11184__$1));
});

cljs.core.async.t_cljs$core$async11183.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11185){
var self__ = this;
var _11185__$1 = this;
return self__.meta11184;
});

cljs.core.async.t_cljs$core$async11183.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11183.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11183.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11183.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11183.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11184","meta11184",1068883471,null)], null);
});

cljs.core.async.t_cljs$core$async11183.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11183";

cljs.core.async.t_cljs$core$async11183.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11183");
});

cljs.core.async.__GT_t_cljs$core$async11183 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11183(alt_handler__$1,flag__$1,cb__$1,meta11184){
return (new cljs.core.async.t_cljs$core$async11183(alt_handler__$1,flag__$1,cb__$1,meta11184));
});

}

return (new cljs.core.async.t_cljs$core$async11183(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11186_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11186_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11187_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11187_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11188 = (i + (1));
i = G__11188;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11194 = arguments.length;
var i__5727__auto___11195 = (0);
while(true){
if((i__5727__auto___11195 < len__5726__auto___11194)){
args__5733__auto__.push((arguments[i__5727__auto___11195]));

var G__11196 = (i__5727__auto___11195 + (1));
i__5727__auto___11195 = G__11196;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11191){
var map__11192 = p__11191;
var map__11192__$1 = ((((!((map__11192 == null)))?((((map__11192.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11192.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11192):map__11192);
var opts = map__11192__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11189){
var G__11190 = cljs.core.first.call(null,seq11189);
var seq11189__$1 = cljs.core.next.call(null,seq11189);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11190,seq11189__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11197 = [];
var len__5726__auto___11247 = arguments.length;
var i__5727__auto___11248 = (0);
while(true){
if((i__5727__auto___11248 < len__5726__auto___11247)){
args11197.push((arguments[i__5727__auto___11248]));

var G__11249 = (i__5727__auto___11248 + (1));
i__5727__auto___11248 = G__11249;
continue;
} else {
}
break;
}

var G__11199 = args11197.length;
switch (G__11199) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11197.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11084__auto___11251 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___11251){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___11251){
return (function (state_11223){
var state_val_11224 = (state_11223[(1)]);
if((state_val_11224 === (7))){
var inst_11219 = (state_11223[(2)]);
var state_11223__$1 = state_11223;
var statearr_11225_11252 = state_11223__$1;
(statearr_11225_11252[(2)] = inst_11219);

(statearr_11225_11252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (1))){
var state_11223__$1 = state_11223;
var statearr_11226_11253 = state_11223__$1;
(statearr_11226_11253[(2)] = null);

(statearr_11226_11253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (4))){
var inst_11202 = (state_11223[(7)]);
var inst_11202__$1 = (state_11223[(2)]);
var inst_11203 = (inst_11202__$1 == null);
var state_11223__$1 = (function (){var statearr_11227 = state_11223;
(statearr_11227[(7)] = inst_11202__$1);

return statearr_11227;
})();
if(cljs.core.truth_(inst_11203)){
var statearr_11228_11254 = state_11223__$1;
(statearr_11228_11254[(1)] = (5));

} else {
var statearr_11229_11255 = state_11223__$1;
(statearr_11229_11255[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (13))){
var state_11223__$1 = state_11223;
var statearr_11230_11256 = state_11223__$1;
(statearr_11230_11256[(2)] = null);

(statearr_11230_11256[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (6))){
var inst_11202 = (state_11223[(7)]);
var state_11223__$1 = state_11223;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11223__$1,(11),to,inst_11202);
} else {
if((state_val_11224 === (3))){
var inst_11221 = (state_11223[(2)]);
var state_11223__$1 = state_11223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11223__$1,inst_11221);
} else {
if((state_val_11224 === (12))){
var state_11223__$1 = state_11223;
var statearr_11231_11257 = state_11223__$1;
(statearr_11231_11257[(2)] = null);

(statearr_11231_11257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (2))){
var state_11223__$1 = state_11223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11223__$1,(4),from);
} else {
if((state_val_11224 === (11))){
var inst_11212 = (state_11223[(2)]);
var state_11223__$1 = state_11223;
if(cljs.core.truth_(inst_11212)){
var statearr_11232_11258 = state_11223__$1;
(statearr_11232_11258[(1)] = (12));

} else {
var statearr_11233_11259 = state_11223__$1;
(statearr_11233_11259[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (9))){
var state_11223__$1 = state_11223;
var statearr_11234_11260 = state_11223__$1;
(statearr_11234_11260[(2)] = null);

(statearr_11234_11260[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (5))){
var state_11223__$1 = state_11223;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11235_11261 = state_11223__$1;
(statearr_11235_11261[(1)] = (8));

} else {
var statearr_11236_11262 = state_11223__$1;
(statearr_11236_11262[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (14))){
var inst_11217 = (state_11223[(2)]);
var state_11223__$1 = state_11223;
var statearr_11237_11263 = state_11223__$1;
(statearr_11237_11263[(2)] = inst_11217);

(statearr_11237_11263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (10))){
var inst_11209 = (state_11223[(2)]);
var state_11223__$1 = state_11223;
var statearr_11238_11264 = state_11223__$1;
(statearr_11238_11264[(2)] = inst_11209);

(statearr_11238_11264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11224 === (8))){
var inst_11206 = cljs.core.async.close_BANG_.call(null,to);
var state_11223__$1 = state_11223;
var statearr_11239_11265 = state_11223__$1;
(statearr_11239_11265[(2)] = inst_11206);

(statearr_11239_11265[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___11251))
;
return ((function (switch__10972__auto__,c__11084__auto___11251){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_11243 = [null,null,null,null,null,null,null,null];
(statearr_11243[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_11243[(1)] = (1));

return statearr_11243;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_11223){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11244){if((e11244 instanceof Object)){
var ex__10976__auto__ = e11244;
var statearr_11245_11266 = state_11223;
(statearr_11245_11266[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11244;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11267 = state_11223;
state_11223 = G__11267;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_11223){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_11223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___11251))
})();
var state__11086__auto__ = (function (){var statearr_11246 = f__11085__auto__.call(null);
(statearr_11246[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___11251);

return statearr_11246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___11251))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11451){
var vec__11452 = p__11451;
var v = cljs.core.nth.call(null,vec__11452,(0),null);
var p = cljs.core.nth.call(null,vec__11452,(1),null);
var job = vec__11452;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11084__auto___11634 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___11634,res,vec__11452,v,p,job,jobs,results){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___11634,res,vec__11452,v,p,job,jobs,results){
return (function (state_11457){
var state_val_11458 = (state_11457[(1)]);
if((state_val_11458 === (1))){
var state_11457__$1 = state_11457;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11457__$1,(2),res,v);
} else {
if((state_val_11458 === (2))){
var inst_11454 = (state_11457[(2)]);
var inst_11455 = cljs.core.async.close_BANG_.call(null,res);
var state_11457__$1 = (function (){var statearr_11459 = state_11457;
(statearr_11459[(7)] = inst_11454);

return statearr_11459;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11457__$1,inst_11455);
} else {
return null;
}
}
});})(c__11084__auto___11634,res,vec__11452,v,p,job,jobs,results))
;
return ((function (switch__10972__auto__,c__11084__auto___11634,res,vec__11452,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_11463 = [null,null,null,null,null,null,null,null];
(statearr_11463[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_11463[(1)] = (1));

return statearr_11463;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_11457){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11457);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11464){if((e11464 instanceof Object)){
var ex__10976__auto__ = e11464;
var statearr_11465_11635 = state_11457;
(statearr_11465_11635[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11457);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11464;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11636 = state_11457;
state_11457 = G__11636;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_11457){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_11457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___11634,res,vec__11452,v,p,job,jobs,results))
})();
var state__11086__auto__ = (function (){var statearr_11466 = f__11085__auto__.call(null);
(statearr_11466[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___11634);

return statearr_11466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___11634,res,vec__11452,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11467){
var vec__11468 = p__11467;
var v = cljs.core.nth.call(null,vec__11468,(0),null);
var p = cljs.core.nth.call(null,vec__11468,(1),null);
var job = vec__11468;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___11637 = n;
var __11638 = (0);
while(true){
if((__11638 < n__5571__auto___11637)){
var G__11469_11639 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11469_11639) {
case "compute":
var c__11084__auto___11641 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11638,c__11084__auto___11641,G__11469_11639,n__5571__auto___11637,jobs,results,process,async){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (__11638,c__11084__auto___11641,G__11469_11639,n__5571__auto___11637,jobs,results,process,async){
return (function (state_11482){
var state_val_11483 = (state_11482[(1)]);
if((state_val_11483 === (1))){
var state_11482__$1 = state_11482;
var statearr_11484_11642 = state_11482__$1;
(statearr_11484_11642[(2)] = null);

(statearr_11484_11642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11483 === (2))){
var state_11482__$1 = state_11482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11482__$1,(4),jobs);
} else {
if((state_val_11483 === (3))){
var inst_11480 = (state_11482[(2)]);
var state_11482__$1 = state_11482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11482__$1,inst_11480);
} else {
if((state_val_11483 === (4))){
var inst_11472 = (state_11482[(2)]);
var inst_11473 = process.call(null,inst_11472);
var state_11482__$1 = state_11482;
if(cljs.core.truth_(inst_11473)){
var statearr_11485_11643 = state_11482__$1;
(statearr_11485_11643[(1)] = (5));

} else {
var statearr_11486_11644 = state_11482__$1;
(statearr_11486_11644[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11483 === (5))){
var state_11482__$1 = state_11482;
var statearr_11487_11645 = state_11482__$1;
(statearr_11487_11645[(2)] = null);

(statearr_11487_11645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11483 === (6))){
var state_11482__$1 = state_11482;
var statearr_11488_11646 = state_11482__$1;
(statearr_11488_11646[(2)] = null);

(statearr_11488_11646[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11483 === (7))){
var inst_11478 = (state_11482[(2)]);
var state_11482__$1 = state_11482;
var statearr_11489_11647 = state_11482__$1;
(statearr_11489_11647[(2)] = inst_11478);

(statearr_11489_11647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11638,c__11084__auto___11641,G__11469_11639,n__5571__auto___11637,jobs,results,process,async))
;
return ((function (__11638,switch__10972__auto__,c__11084__auto___11641,G__11469_11639,n__5571__auto___11637,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_11493 = [null,null,null,null,null,null,null];
(statearr_11493[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_11493[(1)] = (1));

return statearr_11493;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_11482){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11494){if((e11494 instanceof Object)){
var ex__10976__auto__ = e11494;
var statearr_11495_11648 = state_11482;
(statearr_11495_11648[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11494;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11649 = state_11482;
state_11482 = G__11649;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_11482){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_11482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(__11638,switch__10972__auto__,c__11084__auto___11641,G__11469_11639,n__5571__auto___11637,jobs,results,process,async))
})();
var state__11086__auto__ = (function (){var statearr_11496 = f__11085__auto__.call(null);
(statearr_11496[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___11641);

return statearr_11496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(__11638,c__11084__auto___11641,G__11469_11639,n__5571__auto___11637,jobs,results,process,async))
);


break;
case "async":
var c__11084__auto___11650 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11638,c__11084__auto___11650,G__11469_11639,n__5571__auto___11637,jobs,results,process,async){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (__11638,c__11084__auto___11650,G__11469_11639,n__5571__auto___11637,jobs,results,process,async){
return (function (state_11509){
var state_val_11510 = (state_11509[(1)]);
if((state_val_11510 === (1))){
var state_11509__$1 = state_11509;
var statearr_11511_11651 = state_11509__$1;
(statearr_11511_11651[(2)] = null);

(statearr_11511_11651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11510 === (2))){
var state_11509__$1 = state_11509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11509__$1,(4),jobs);
} else {
if((state_val_11510 === (3))){
var inst_11507 = (state_11509[(2)]);
var state_11509__$1 = state_11509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11509__$1,inst_11507);
} else {
if((state_val_11510 === (4))){
var inst_11499 = (state_11509[(2)]);
var inst_11500 = async.call(null,inst_11499);
var state_11509__$1 = state_11509;
if(cljs.core.truth_(inst_11500)){
var statearr_11512_11652 = state_11509__$1;
(statearr_11512_11652[(1)] = (5));

} else {
var statearr_11513_11653 = state_11509__$1;
(statearr_11513_11653[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11510 === (5))){
var state_11509__$1 = state_11509;
var statearr_11514_11654 = state_11509__$1;
(statearr_11514_11654[(2)] = null);

(statearr_11514_11654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11510 === (6))){
var state_11509__$1 = state_11509;
var statearr_11515_11655 = state_11509__$1;
(statearr_11515_11655[(2)] = null);

(statearr_11515_11655[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11510 === (7))){
var inst_11505 = (state_11509[(2)]);
var state_11509__$1 = state_11509;
var statearr_11516_11656 = state_11509__$1;
(statearr_11516_11656[(2)] = inst_11505);

(statearr_11516_11656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11638,c__11084__auto___11650,G__11469_11639,n__5571__auto___11637,jobs,results,process,async))
;
return ((function (__11638,switch__10972__auto__,c__11084__auto___11650,G__11469_11639,n__5571__auto___11637,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_11520 = [null,null,null,null,null,null,null];
(statearr_11520[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_11520[(1)] = (1));

return statearr_11520;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_11509){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11521){if((e11521 instanceof Object)){
var ex__10976__auto__ = e11521;
var statearr_11522_11657 = state_11509;
(statearr_11522_11657[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11509);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11521;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11658 = state_11509;
state_11509 = G__11658;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_11509){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_11509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(__11638,switch__10972__auto__,c__11084__auto___11650,G__11469_11639,n__5571__auto___11637,jobs,results,process,async))
})();
var state__11086__auto__ = (function (){var statearr_11523 = f__11085__auto__.call(null);
(statearr_11523[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___11650);

return statearr_11523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(__11638,c__11084__auto___11650,G__11469_11639,n__5571__auto___11637,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11659 = (__11638 + (1));
__11638 = G__11659;
continue;
} else {
}
break;
}

var c__11084__auto___11660 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___11660,jobs,results,process,async){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___11660,jobs,results,process,async){
return (function (state_11545){
var state_val_11546 = (state_11545[(1)]);
if((state_val_11546 === (1))){
var state_11545__$1 = state_11545;
var statearr_11547_11661 = state_11545__$1;
(statearr_11547_11661[(2)] = null);

(statearr_11547_11661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (2))){
var state_11545__$1 = state_11545;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11545__$1,(4),from);
} else {
if((state_val_11546 === (3))){
var inst_11543 = (state_11545[(2)]);
var state_11545__$1 = state_11545;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11545__$1,inst_11543);
} else {
if((state_val_11546 === (4))){
var inst_11526 = (state_11545[(7)]);
var inst_11526__$1 = (state_11545[(2)]);
var inst_11527 = (inst_11526__$1 == null);
var state_11545__$1 = (function (){var statearr_11548 = state_11545;
(statearr_11548[(7)] = inst_11526__$1);

return statearr_11548;
})();
if(cljs.core.truth_(inst_11527)){
var statearr_11549_11662 = state_11545__$1;
(statearr_11549_11662[(1)] = (5));

} else {
var statearr_11550_11663 = state_11545__$1;
(statearr_11550_11663[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (5))){
var inst_11529 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11545__$1 = state_11545;
var statearr_11551_11664 = state_11545__$1;
(statearr_11551_11664[(2)] = inst_11529);

(statearr_11551_11664[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (6))){
var inst_11531 = (state_11545[(8)]);
var inst_11526 = (state_11545[(7)]);
var inst_11531__$1 = cljs.core.async.chan.call(null,(1));
var inst_11532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11533 = [inst_11526,inst_11531__$1];
var inst_11534 = (new cljs.core.PersistentVector(null,2,(5),inst_11532,inst_11533,null));
var state_11545__$1 = (function (){var statearr_11552 = state_11545;
(statearr_11552[(8)] = inst_11531__$1);

return statearr_11552;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11545__$1,(8),jobs,inst_11534);
} else {
if((state_val_11546 === (7))){
var inst_11541 = (state_11545[(2)]);
var state_11545__$1 = state_11545;
var statearr_11553_11665 = state_11545__$1;
(statearr_11553_11665[(2)] = inst_11541);

(statearr_11553_11665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11546 === (8))){
var inst_11531 = (state_11545[(8)]);
var inst_11536 = (state_11545[(2)]);
var state_11545__$1 = (function (){var statearr_11554 = state_11545;
(statearr_11554[(9)] = inst_11536);

return statearr_11554;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11545__$1,(9),results,inst_11531);
} else {
if((state_val_11546 === (9))){
var inst_11538 = (state_11545[(2)]);
var state_11545__$1 = (function (){var statearr_11555 = state_11545;
(statearr_11555[(10)] = inst_11538);

return statearr_11555;
})();
var statearr_11556_11666 = state_11545__$1;
(statearr_11556_11666[(2)] = null);

(statearr_11556_11666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___11660,jobs,results,process,async))
;
return ((function (switch__10972__auto__,c__11084__auto___11660,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_11560 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11560[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_11560[(1)] = (1));

return statearr_11560;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_11545){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11545);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11561){if((e11561 instanceof Object)){
var ex__10976__auto__ = e11561;
var statearr_11562_11667 = state_11545;
(statearr_11562_11667[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11545);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11561;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11668 = state_11545;
state_11545 = G__11668;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_11545){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_11545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___11660,jobs,results,process,async))
})();
var state__11086__auto__ = (function (){var statearr_11563 = f__11085__auto__.call(null);
(statearr_11563[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___11660);

return statearr_11563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___11660,jobs,results,process,async))
);


var c__11084__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto__,jobs,results,process,async){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto__,jobs,results,process,async){
return (function (state_11601){
var state_val_11602 = (state_11601[(1)]);
if((state_val_11602 === (7))){
var inst_11597 = (state_11601[(2)]);
var state_11601__$1 = state_11601;
var statearr_11603_11669 = state_11601__$1;
(statearr_11603_11669[(2)] = inst_11597);

(statearr_11603_11669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (20))){
var state_11601__$1 = state_11601;
var statearr_11604_11670 = state_11601__$1;
(statearr_11604_11670[(2)] = null);

(statearr_11604_11670[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (1))){
var state_11601__$1 = state_11601;
var statearr_11605_11671 = state_11601__$1;
(statearr_11605_11671[(2)] = null);

(statearr_11605_11671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (4))){
var inst_11566 = (state_11601[(7)]);
var inst_11566__$1 = (state_11601[(2)]);
var inst_11567 = (inst_11566__$1 == null);
var state_11601__$1 = (function (){var statearr_11606 = state_11601;
(statearr_11606[(7)] = inst_11566__$1);

return statearr_11606;
})();
if(cljs.core.truth_(inst_11567)){
var statearr_11607_11672 = state_11601__$1;
(statearr_11607_11672[(1)] = (5));

} else {
var statearr_11608_11673 = state_11601__$1;
(statearr_11608_11673[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (15))){
var inst_11579 = (state_11601[(8)]);
var state_11601__$1 = state_11601;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11601__$1,(18),to,inst_11579);
} else {
if((state_val_11602 === (21))){
var inst_11592 = (state_11601[(2)]);
var state_11601__$1 = state_11601;
var statearr_11609_11674 = state_11601__$1;
(statearr_11609_11674[(2)] = inst_11592);

(statearr_11609_11674[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (13))){
var inst_11594 = (state_11601[(2)]);
var state_11601__$1 = (function (){var statearr_11610 = state_11601;
(statearr_11610[(9)] = inst_11594);

return statearr_11610;
})();
var statearr_11611_11675 = state_11601__$1;
(statearr_11611_11675[(2)] = null);

(statearr_11611_11675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (6))){
var inst_11566 = (state_11601[(7)]);
var state_11601__$1 = state_11601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11601__$1,(11),inst_11566);
} else {
if((state_val_11602 === (17))){
var inst_11587 = (state_11601[(2)]);
var state_11601__$1 = state_11601;
if(cljs.core.truth_(inst_11587)){
var statearr_11612_11676 = state_11601__$1;
(statearr_11612_11676[(1)] = (19));

} else {
var statearr_11613_11677 = state_11601__$1;
(statearr_11613_11677[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (3))){
var inst_11599 = (state_11601[(2)]);
var state_11601__$1 = state_11601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11601__$1,inst_11599);
} else {
if((state_val_11602 === (12))){
var inst_11576 = (state_11601[(10)]);
var state_11601__$1 = state_11601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11601__$1,(14),inst_11576);
} else {
if((state_val_11602 === (2))){
var state_11601__$1 = state_11601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11601__$1,(4),results);
} else {
if((state_val_11602 === (19))){
var state_11601__$1 = state_11601;
var statearr_11614_11678 = state_11601__$1;
(statearr_11614_11678[(2)] = null);

(statearr_11614_11678[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (11))){
var inst_11576 = (state_11601[(2)]);
var state_11601__$1 = (function (){var statearr_11615 = state_11601;
(statearr_11615[(10)] = inst_11576);

return statearr_11615;
})();
var statearr_11616_11679 = state_11601__$1;
(statearr_11616_11679[(2)] = null);

(statearr_11616_11679[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (9))){
var state_11601__$1 = state_11601;
var statearr_11617_11680 = state_11601__$1;
(statearr_11617_11680[(2)] = null);

(statearr_11617_11680[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (5))){
var state_11601__$1 = state_11601;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11618_11681 = state_11601__$1;
(statearr_11618_11681[(1)] = (8));

} else {
var statearr_11619_11682 = state_11601__$1;
(statearr_11619_11682[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (14))){
var inst_11579 = (state_11601[(8)]);
var inst_11581 = (state_11601[(11)]);
var inst_11579__$1 = (state_11601[(2)]);
var inst_11580 = (inst_11579__$1 == null);
var inst_11581__$1 = cljs.core.not.call(null,inst_11580);
var state_11601__$1 = (function (){var statearr_11620 = state_11601;
(statearr_11620[(8)] = inst_11579__$1);

(statearr_11620[(11)] = inst_11581__$1);

return statearr_11620;
})();
if(inst_11581__$1){
var statearr_11621_11683 = state_11601__$1;
(statearr_11621_11683[(1)] = (15));

} else {
var statearr_11622_11684 = state_11601__$1;
(statearr_11622_11684[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (16))){
var inst_11581 = (state_11601[(11)]);
var state_11601__$1 = state_11601;
var statearr_11623_11685 = state_11601__$1;
(statearr_11623_11685[(2)] = inst_11581);

(statearr_11623_11685[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (10))){
var inst_11573 = (state_11601[(2)]);
var state_11601__$1 = state_11601;
var statearr_11624_11686 = state_11601__$1;
(statearr_11624_11686[(2)] = inst_11573);

(statearr_11624_11686[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (18))){
var inst_11584 = (state_11601[(2)]);
var state_11601__$1 = state_11601;
var statearr_11625_11687 = state_11601__$1;
(statearr_11625_11687[(2)] = inst_11584);

(statearr_11625_11687[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11602 === (8))){
var inst_11570 = cljs.core.async.close_BANG_.call(null,to);
var state_11601__$1 = state_11601;
var statearr_11626_11688 = state_11601__$1;
(statearr_11626_11688[(2)] = inst_11570);

(statearr_11626_11688[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto__,jobs,results,process,async))
;
return ((function (switch__10972__auto__,c__11084__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_11630 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11630[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__);

(statearr_11630[(1)] = (1));

return statearr_11630;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1 = (function (state_11601){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11631){if((e11631 instanceof Object)){
var ex__10976__auto__ = e11631;
var statearr_11632_11689 = state_11601;
(statearr_11632_11689[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11631;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11690 = state_11601;
state_11601 = G__11690;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__ = function(state_11601){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1.call(this,state_11601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto__,jobs,results,process,async))
})();
var state__11086__auto__ = (function (){var statearr_11633 = f__11085__auto__.call(null);
(statearr_11633[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto__);

return statearr_11633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto__,jobs,results,process,async))
);

return c__11084__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11691 = [];
var len__5726__auto___11694 = arguments.length;
var i__5727__auto___11695 = (0);
while(true){
if((i__5727__auto___11695 < len__5726__auto___11694)){
args11691.push((arguments[i__5727__auto___11695]));

var G__11696 = (i__5727__auto___11695 + (1));
i__5727__auto___11695 = G__11696;
continue;
} else {
}
break;
}

var G__11693 = args11691.length;
switch (G__11693) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11691.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11698 = [];
var len__5726__auto___11701 = arguments.length;
var i__5727__auto___11702 = (0);
while(true){
if((i__5727__auto___11702 < len__5726__auto___11701)){
args11698.push((arguments[i__5727__auto___11702]));

var G__11703 = (i__5727__auto___11702 + (1));
i__5727__auto___11702 = G__11703;
continue;
} else {
}
break;
}

var G__11700 = args11698.length;
switch (G__11700) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11698.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11705 = [];
var len__5726__auto___11758 = arguments.length;
var i__5727__auto___11759 = (0);
while(true){
if((i__5727__auto___11759 < len__5726__auto___11758)){
args11705.push((arguments[i__5727__auto___11759]));

var G__11760 = (i__5727__auto___11759 + (1));
i__5727__auto___11759 = G__11760;
continue;
} else {
}
break;
}

var G__11707 = args11705.length;
switch (G__11707) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11705.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11084__auto___11762 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___11762,tc,fc){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___11762,tc,fc){
return (function (state_11733){
var state_val_11734 = (state_11733[(1)]);
if((state_val_11734 === (7))){
var inst_11729 = (state_11733[(2)]);
var state_11733__$1 = state_11733;
var statearr_11735_11763 = state_11733__$1;
(statearr_11735_11763[(2)] = inst_11729);

(statearr_11735_11763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (1))){
var state_11733__$1 = state_11733;
var statearr_11736_11764 = state_11733__$1;
(statearr_11736_11764[(2)] = null);

(statearr_11736_11764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (4))){
var inst_11710 = (state_11733[(7)]);
var inst_11710__$1 = (state_11733[(2)]);
var inst_11711 = (inst_11710__$1 == null);
var state_11733__$1 = (function (){var statearr_11737 = state_11733;
(statearr_11737[(7)] = inst_11710__$1);

return statearr_11737;
})();
if(cljs.core.truth_(inst_11711)){
var statearr_11738_11765 = state_11733__$1;
(statearr_11738_11765[(1)] = (5));

} else {
var statearr_11739_11766 = state_11733__$1;
(statearr_11739_11766[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (13))){
var state_11733__$1 = state_11733;
var statearr_11740_11767 = state_11733__$1;
(statearr_11740_11767[(2)] = null);

(statearr_11740_11767[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (6))){
var inst_11710 = (state_11733[(7)]);
var inst_11716 = p.call(null,inst_11710);
var state_11733__$1 = state_11733;
if(cljs.core.truth_(inst_11716)){
var statearr_11741_11768 = state_11733__$1;
(statearr_11741_11768[(1)] = (9));

} else {
var statearr_11742_11769 = state_11733__$1;
(statearr_11742_11769[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (3))){
var inst_11731 = (state_11733[(2)]);
var state_11733__$1 = state_11733;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11733__$1,inst_11731);
} else {
if((state_val_11734 === (12))){
var state_11733__$1 = state_11733;
var statearr_11743_11770 = state_11733__$1;
(statearr_11743_11770[(2)] = null);

(statearr_11743_11770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (2))){
var state_11733__$1 = state_11733;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11733__$1,(4),ch);
} else {
if((state_val_11734 === (11))){
var inst_11710 = (state_11733[(7)]);
var inst_11720 = (state_11733[(2)]);
var state_11733__$1 = state_11733;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11733__$1,(8),inst_11720,inst_11710);
} else {
if((state_val_11734 === (9))){
var state_11733__$1 = state_11733;
var statearr_11744_11771 = state_11733__$1;
(statearr_11744_11771[(2)] = tc);

(statearr_11744_11771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (5))){
var inst_11713 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11714 = cljs.core.async.close_BANG_.call(null,fc);
var state_11733__$1 = (function (){var statearr_11745 = state_11733;
(statearr_11745[(8)] = inst_11713);

return statearr_11745;
})();
var statearr_11746_11772 = state_11733__$1;
(statearr_11746_11772[(2)] = inst_11714);

(statearr_11746_11772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (14))){
var inst_11727 = (state_11733[(2)]);
var state_11733__$1 = state_11733;
var statearr_11747_11773 = state_11733__$1;
(statearr_11747_11773[(2)] = inst_11727);

(statearr_11747_11773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (10))){
var state_11733__$1 = state_11733;
var statearr_11748_11774 = state_11733__$1;
(statearr_11748_11774[(2)] = fc);

(statearr_11748_11774[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11734 === (8))){
var inst_11722 = (state_11733[(2)]);
var state_11733__$1 = state_11733;
if(cljs.core.truth_(inst_11722)){
var statearr_11749_11775 = state_11733__$1;
(statearr_11749_11775[(1)] = (12));

} else {
var statearr_11750_11776 = state_11733__$1;
(statearr_11750_11776[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___11762,tc,fc))
;
return ((function (switch__10972__auto__,c__11084__auto___11762,tc,fc){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_11754 = [null,null,null,null,null,null,null,null,null];
(statearr_11754[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_11754[(1)] = (1));

return statearr_11754;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_11733){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11733);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11755){if((e11755 instanceof Object)){
var ex__10976__auto__ = e11755;
var statearr_11756_11777 = state_11733;
(statearr_11756_11777[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11733);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11755;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11778 = state_11733;
state_11733 = G__11778;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_11733){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_11733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___11762,tc,fc))
})();
var state__11086__auto__ = (function (){var statearr_11757 = f__11085__auto__.call(null);
(statearr_11757[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___11762);

return statearr_11757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___11762,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11084__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto__){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto__){
return (function (state_11842){
var state_val_11843 = (state_11842[(1)]);
if((state_val_11843 === (7))){
var inst_11838 = (state_11842[(2)]);
var state_11842__$1 = state_11842;
var statearr_11844_11865 = state_11842__$1;
(statearr_11844_11865[(2)] = inst_11838);

(statearr_11844_11865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11843 === (1))){
var inst_11822 = init;
var state_11842__$1 = (function (){var statearr_11845 = state_11842;
(statearr_11845[(7)] = inst_11822);

return statearr_11845;
})();
var statearr_11846_11866 = state_11842__$1;
(statearr_11846_11866[(2)] = null);

(statearr_11846_11866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11843 === (4))){
var inst_11825 = (state_11842[(8)]);
var inst_11825__$1 = (state_11842[(2)]);
var inst_11826 = (inst_11825__$1 == null);
var state_11842__$1 = (function (){var statearr_11847 = state_11842;
(statearr_11847[(8)] = inst_11825__$1);

return statearr_11847;
})();
if(cljs.core.truth_(inst_11826)){
var statearr_11848_11867 = state_11842__$1;
(statearr_11848_11867[(1)] = (5));

} else {
var statearr_11849_11868 = state_11842__$1;
(statearr_11849_11868[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11843 === (6))){
var inst_11825 = (state_11842[(8)]);
var inst_11822 = (state_11842[(7)]);
var inst_11829 = (state_11842[(9)]);
var inst_11829__$1 = f.call(null,inst_11822,inst_11825);
var inst_11830 = cljs.core.reduced_QMARK_.call(null,inst_11829__$1);
var state_11842__$1 = (function (){var statearr_11850 = state_11842;
(statearr_11850[(9)] = inst_11829__$1);

return statearr_11850;
})();
if(inst_11830){
var statearr_11851_11869 = state_11842__$1;
(statearr_11851_11869[(1)] = (8));

} else {
var statearr_11852_11870 = state_11842__$1;
(statearr_11852_11870[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11843 === (3))){
var inst_11840 = (state_11842[(2)]);
var state_11842__$1 = state_11842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11842__$1,inst_11840);
} else {
if((state_val_11843 === (2))){
var state_11842__$1 = state_11842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11842__$1,(4),ch);
} else {
if((state_val_11843 === (9))){
var inst_11829 = (state_11842[(9)]);
var inst_11822 = inst_11829;
var state_11842__$1 = (function (){var statearr_11853 = state_11842;
(statearr_11853[(7)] = inst_11822);

return statearr_11853;
})();
var statearr_11854_11871 = state_11842__$1;
(statearr_11854_11871[(2)] = null);

(statearr_11854_11871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11843 === (5))){
var inst_11822 = (state_11842[(7)]);
var state_11842__$1 = state_11842;
var statearr_11855_11872 = state_11842__$1;
(statearr_11855_11872[(2)] = inst_11822);

(statearr_11855_11872[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11843 === (10))){
var inst_11836 = (state_11842[(2)]);
var state_11842__$1 = state_11842;
var statearr_11856_11873 = state_11842__$1;
(statearr_11856_11873[(2)] = inst_11836);

(statearr_11856_11873[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11843 === (8))){
var inst_11829 = (state_11842[(9)]);
var inst_11832 = cljs.core.deref.call(null,inst_11829);
var state_11842__$1 = state_11842;
var statearr_11857_11874 = state_11842__$1;
(statearr_11857_11874[(2)] = inst_11832);

(statearr_11857_11874[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto__))
;
return ((function (switch__10972__auto__,c__11084__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10973__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10973__auto____0 = (function (){
var statearr_11861 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11861[(0)] = cljs$core$async$reduce_$_state_machine__10973__auto__);

(statearr_11861[(1)] = (1));

return statearr_11861;
});
var cljs$core$async$reduce_$_state_machine__10973__auto____1 = (function (state_11842){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11862){if((e11862 instanceof Object)){
var ex__10976__auto__ = e11862;
var statearr_11863_11875 = state_11842;
(statearr_11863_11875[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11876 = state_11842;
state_11842 = G__11876;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10973__auto__ = function(state_11842){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10973__auto____1.call(this,state_11842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10973__auto____0;
cljs$core$async$reduce_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10973__auto____1;
return cljs$core$async$reduce_$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto__))
})();
var state__11086__auto__ = (function (){var statearr_11864 = f__11085__auto__.call(null);
(statearr_11864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto__);

return statearr_11864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto__))
);

return c__11084__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11877 = [];
var len__5726__auto___11929 = arguments.length;
var i__5727__auto___11930 = (0);
while(true){
if((i__5727__auto___11930 < len__5726__auto___11929)){
args11877.push((arguments[i__5727__auto___11930]));

var G__11931 = (i__5727__auto___11930 + (1));
i__5727__auto___11930 = G__11931;
continue;
} else {
}
break;
}

var G__11879 = args11877.length;
switch (G__11879) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11877.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11084__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto__){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto__){
return (function (state_11904){
var state_val_11905 = (state_11904[(1)]);
if((state_val_11905 === (7))){
var inst_11886 = (state_11904[(2)]);
var state_11904__$1 = state_11904;
var statearr_11906_11933 = state_11904__$1;
(statearr_11906_11933[(2)] = inst_11886);

(statearr_11906_11933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (1))){
var inst_11880 = cljs.core.seq.call(null,coll);
var inst_11881 = inst_11880;
var state_11904__$1 = (function (){var statearr_11907 = state_11904;
(statearr_11907[(7)] = inst_11881);

return statearr_11907;
})();
var statearr_11908_11934 = state_11904__$1;
(statearr_11908_11934[(2)] = null);

(statearr_11908_11934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (4))){
var inst_11881 = (state_11904[(7)]);
var inst_11884 = cljs.core.first.call(null,inst_11881);
var state_11904__$1 = state_11904;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11904__$1,(7),ch,inst_11884);
} else {
if((state_val_11905 === (13))){
var inst_11898 = (state_11904[(2)]);
var state_11904__$1 = state_11904;
var statearr_11909_11935 = state_11904__$1;
(statearr_11909_11935[(2)] = inst_11898);

(statearr_11909_11935[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (6))){
var inst_11889 = (state_11904[(2)]);
var state_11904__$1 = state_11904;
if(cljs.core.truth_(inst_11889)){
var statearr_11910_11936 = state_11904__$1;
(statearr_11910_11936[(1)] = (8));

} else {
var statearr_11911_11937 = state_11904__$1;
(statearr_11911_11937[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (3))){
var inst_11902 = (state_11904[(2)]);
var state_11904__$1 = state_11904;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11904__$1,inst_11902);
} else {
if((state_val_11905 === (12))){
var state_11904__$1 = state_11904;
var statearr_11912_11938 = state_11904__$1;
(statearr_11912_11938[(2)] = null);

(statearr_11912_11938[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (2))){
var inst_11881 = (state_11904[(7)]);
var state_11904__$1 = state_11904;
if(cljs.core.truth_(inst_11881)){
var statearr_11913_11939 = state_11904__$1;
(statearr_11913_11939[(1)] = (4));

} else {
var statearr_11914_11940 = state_11904__$1;
(statearr_11914_11940[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (11))){
var inst_11895 = cljs.core.async.close_BANG_.call(null,ch);
var state_11904__$1 = state_11904;
var statearr_11915_11941 = state_11904__$1;
(statearr_11915_11941[(2)] = inst_11895);

(statearr_11915_11941[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (9))){
var state_11904__$1 = state_11904;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11916_11942 = state_11904__$1;
(statearr_11916_11942[(1)] = (11));

} else {
var statearr_11917_11943 = state_11904__$1;
(statearr_11917_11943[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (5))){
var inst_11881 = (state_11904[(7)]);
var state_11904__$1 = state_11904;
var statearr_11918_11944 = state_11904__$1;
(statearr_11918_11944[(2)] = inst_11881);

(statearr_11918_11944[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (10))){
var inst_11900 = (state_11904[(2)]);
var state_11904__$1 = state_11904;
var statearr_11919_11945 = state_11904__$1;
(statearr_11919_11945[(2)] = inst_11900);

(statearr_11919_11945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11905 === (8))){
var inst_11881 = (state_11904[(7)]);
var inst_11891 = cljs.core.next.call(null,inst_11881);
var inst_11881__$1 = inst_11891;
var state_11904__$1 = (function (){var statearr_11920 = state_11904;
(statearr_11920[(7)] = inst_11881__$1);

return statearr_11920;
})();
var statearr_11921_11946 = state_11904__$1;
(statearr_11921_11946[(2)] = null);

(statearr_11921_11946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto__))
;
return ((function (switch__10972__auto__,c__11084__auto__){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_11925 = [null,null,null,null,null,null,null,null];
(statearr_11925[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_11925[(1)] = (1));

return statearr_11925;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_11904){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_11904);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e11926){if((e11926 instanceof Object)){
var ex__10976__auto__ = e11926;
var statearr_11927_11947 = state_11904;
(statearr_11927_11947[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11904);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11926;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11948 = state_11904;
state_11904 = G__11948;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_11904){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_11904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto__))
})();
var state__11086__auto__ = (function (){var statearr_11928 = f__11085__auto__.call(null);
(statearr_11928[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto__);

return statearr_11928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto__))
);

return c__11084__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12170 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12170 = (function (mult,ch,cs,meta12171){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12171 = meta12171;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12170.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12172,meta12171__$1){
var self__ = this;
var _12172__$1 = this;
return (new cljs.core.async.t_cljs$core$async12170(self__.mult,self__.ch,self__.cs,meta12171__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12170.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12172){
var self__ = this;
var _12172__$1 = this;
return self__.meta12171;
});})(cs))
;

cljs.core.async.t_cljs$core$async12170.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12170.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12170.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12170.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12170.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12170.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12170.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12171","meta12171",-1326294612,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12170.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12170.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12170";

cljs.core.async.t_cljs$core$async12170.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12170");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12170 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12170(mult__$1,ch__$1,cs__$1,meta12171){
return (new cljs.core.async.t_cljs$core$async12170(mult__$1,ch__$1,cs__$1,meta12171));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12170(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11084__auto___12391 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___12391,cs,m,dchan,dctr,done){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___12391,cs,m,dchan,dctr,done){
return (function (state_12303){
var state_val_12304 = (state_12303[(1)]);
if((state_val_12304 === (7))){
var inst_12299 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12305_12392 = state_12303__$1;
(statearr_12305_12392[(2)] = inst_12299);

(statearr_12305_12392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (20))){
var inst_12204 = (state_12303[(7)]);
var inst_12214 = cljs.core.first.call(null,inst_12204);
var inst_12215 = cljs.core.nth.call(null,inst_12214,(0),null);
var inst_12216 = cljs.core.nth.call(null,inst_12214,(1),null);
var state_12303__$1 = (function (){var statearr_12306 = state_12303;
(statearr_12306[(8)] = inst_12215);

return statearr_12306;
})();
if(cljs.core.truth_(inst_12216)){
var statearr_12307_12393 = state_12303__$1;
(statearr_12307_12393[(1)] = (22));

} else {
var statearr_12308_12394 = state_12303__$1;
(statearr_12308_12394[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (27))){
var inst_12251 = (state_12303[(9)]);
var inst_12246 = (state_12303[(10)]);
var inst_12175 = (state_12303[(11)]);
var inst_12244 = (state_12303[(12)]);
var inst_12251__$1 = cljs.core._nth.call(null,inst_12244,inst_12246);
var inst_12252 = cljs.core.async.put_BANG_.call(null,inst_12251__$1,inst_12175,done);
var state_12303__$1 = (function (){var statearr_12309 = state_12303;
(statearr_12309[(9)] = inst_12251__$1);

return statearr_12309;
})();
if(cljs.core.truth_(inst_12252)){
var statearr_12310_12395 = state_12303__$1;
(statearr_12310_12395[(1)] = (30));

} else {
var statearr_12311_12396 = state_12303__$1;
(statearr_12311_12396[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (1))){
var state_12303__$1 = state_12303;
var statearr_12312_12397 = state_12303__$1;
(statearr_12312_12397[(2)] = null);

(statearr_12312_12397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (24))){
var inst_12204 = (state_12303[(7)]);
var inst_12221 = (state_12303[(2)]);
var inst_12222 = cljs.core.next.call(null,inst_12204);
var inst_12184 = inst_12222;
var inst_12185 = null;
var inst_12186 = (0);
var inst_12187 = (0);
var state_12303__$1 = (function (){var statearr_12313 = state_12303;
(statearr_12313[(13)] = inst_12186);

(statearr_12313[(14)] = inst_12187);

(statearr_12313[(15)] = inst_12185);

(statearr_12313[(16)] = inst_12221);

(statearr_12313[(17)] = inst_12184);

return statearr_12313;
})();
var statearr_12314_12398 = state_12303__$1;
(statearr_12314_12398[(2)] = null);

(statearr_12314_12398[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (39))){
var state_12303__$1 = state_12303;
var statearr_12318_12399 = state_12303__$1;
(statearr_12318_12399[(2)] = null);

(statearr_12318_12399[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (4))){
var inst_12175 = (state_12303[(11)]);
var inst_12175__$1 = (state_12303[(2)]);
var inst_12176 = (inst_12175__$1 == null);
var state_12303__$1 = (function (){var statearr_12319 = state_12303;
(statearr_12319[(11)] = inst_12175__$1);

return statearr_12319;
})();
if(cljs.core.truth_(inst_12176)){
var statearr_12320_12400 = state_12303__$1;
(statearr_12320_12400[(1)] = (5));

} else {
var statearr_12321_12401 = state_12303__$1;
(statearr_12321_12401[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (15))){
var inst_12186 = (state_12303[(13)]);
var inst_12187 = (state_12303[(14)]);
var inst_12185 = (state_12303[(15)]);
var inst_12184 = (state_12303[(17)]);
var inst_12200 = (state_12303[(2)]);
var inst_12201 = (inst_12187 + (1));
var tmp12315 = inst_12186;
var tmp12316 = inst_12185;
var tmp12317 = inst_12184;
var inst_12184__$1 = tmp12317;
var inst_12185__$1 = tmp12316;
var inst_12186__$1 = tmp12315;
var inst_12187__$1 = inst_12201;
var state_12303__$1 = (function (){var statearr_12322 = state_12303;
(statearr_12322[(13)] = inst_12186__$1);

(statearr_12322[(14)] = inst_12187__$1);

(statearr_12322[(15)] = inst_12185__$1);

(statearr_12322[(18)] = inst_12200);

(statearr_12322[(17)] = inst_12184__$1);

return statearr_12322;
})();
var statearr_12323_12402 = state_12303__$1;
(statearr_12323_12402[(2)] = null);

(statearr_12323_12402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (21))){
var inst_12225 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12327_12403 = state_12303__$1;
(statearr_12327_12403[(2)] = inst_12225);

(statearr_12327_12403[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (31))){
var inst_12251 = (state_12303[(9)]);
var inst_12255 = done.call(null,null);
var inst_12256 = cljs.core.async.untap_STAR_.call(null,m,inst_12251);
var state_12303__$1 = (function (){var statearr_12328 = state_12303;
(statearr_12328[(19)] = inst_12255);

return statearr_12328;
})();
var statearr_12329_12404 = state_12303__$1;
(statearr_12329_12404[(2)] = inst_12256);

(statearr_12329_12404[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (32))){
var inst_12246 = (state_12303[(10)]);
var inst_12243 = (state_12303[(20)]);
var inst_12245 = (state_12303[(21)]);
var inst_12244 = (state_12303[(12)]);
var inst_12258 = (state_12303[(2)]);
var inst_12259 = (inst_12246 + (1));
var tmp12324 = inst_12243;
var tmp12325 = inst_12245;
var tmp12326 = inst_12244;
var inst_12243__$1 = tmp12324;
var inst_12244__$1 = tmp12326;
var inst_12245__$1 = tmp12325;
var inst_12246__$1 = inst_12259;
var state_12303__$1 = (function (){var statearr_12330 = state_12303;
(statearr_12330[(10)] = inst_12246__$1);

(statearr_12330[(22)] = inst_12258);

(statearr_12330[(20)] = inst_12243__$1);

(statearr_12330[(21)] = inst_12245__$1);

(statearr_12330[(12)] = inst_12244__$1);

return statearr_12330;
})();
var statearr_12331_12405 = state_12303__$1;
(statearr_12331_12405[(2)] = null);

(statearr_12331_12405[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (40))){
var inst_12271 = (state_12303[(23)]);
var inst_12275 = done.call(null,null);
var inst_12276 = cljs.core.async.untap_STAR_.call(null,m,inst_12271);
var state_12303__$1 = (function (){var statearr_12332 = state_12303;
(statearr_12332[(24)] = inst_12275);

return statearr_12332;
})();
var statearr_12333_12406 = state_12303__$1;
(statearr_12333_12406[(2)] = inst_12276);

(statearr_12333_12406[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (33))){
var inst_12262 = (state_12303[(25)]);
var inst_12264 = cljs.core.chunked_seq_QMARK_.call(null,inst_12262);
var state_12303__$1 = state_12303;
if(inst_12264){
var statearr_12334_12407 = state_12303__$1;
(statearr_12334_12407[(1)] = (36));

} else {
var statearr_12335_12408 = state_12303__$1;
(statearr_12335_12408[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (13))){
var inst_12194 = (state_12303[(26)]);
var inst_12197 = cljs.core.async.close_BANG_.call(null,inst_12194);
var state_12303__$1 = state_12303;
var statearr_12336_12409 = state_12303__$1;
(statearr_12336_12409[(2)] = inst_12197);

(statearr_12336_12409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (22))){
var inst_12215 = (state_12303[(8)]);
var inst_12218 = cljs.core.async.close_BANG_.call(null,inst_12215);
var state_12303__$1 = state_12303;
var statearr_12337_12410 = state_12303__$1;
(statearr_12337_12410[(2)] = inst_12218);

(statearr_12337_12410[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (36))){
var inst_12262 = (state_12303[(25)]);
var inst_12266 = cljs.core.chunk_first.call(null,inst_12262);
var inst_12267 = cljs.core.chunk_rest.call(null,inst_12262);
var inst_12268 = cljs.core.count.call(null,inst_12266);
var inst_12243 = inst_12267;
var inst_12244 = inst_12266;
var inst_12245 = inst_12268;
var inst_12246 = (0);
var state_12303__$1 = (function (){var statearr_12338 = state_12303;
(statearr_12338[(10)] = inst_12246);

(statearr_12338[(20)] = inst_12243);

(statearr_12338[(21)] = inst_12245);

(statearr_12338[(12)] = inst_12244);

return statearr_12338;
})();
var statearr_12339_12411 = state_12303__$1;
(statearr_12339_12411[(2)] = null);

(statearr_12339_12411[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (41))){
var inst_12262 = (state_12303[(25)]);
var inst_12278 = (state_12303[(2)]);
var inst_12279 = cljs.core.next.call(null,inst_12262);
var inst_12243 = inst_12279;
var inst_12244 = null;
var inst_12245 = (0);
var inst_12246 = (0);
var state_12303__$1 = (function (){var statearr_12340 = state_12303;
(statearr_12340[(27)] = inst_12278);

(statearr_12340[(10)] = inst_12246);

(statearr_12340[(20)] = inst_12243);

(statearr_12340[(21)] = inst_12245);

(statearr_12340[(12)] = inst_12244);

return statearr_12340;
})();
var statearr_12341_12412 = state_12303__$1;
(statearr_12341_12412[(2)] = null);

(statearr_12341_12412[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (43))){
var state_12303__$1 = state_12303;
var statearr_12342_12413 = state_12303__$1;
(statearr_12342_12413[(2)] = null);

(statearr_12342_12413[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (29))){
var inst_12287 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12343_12414 = state_12303__$1;
(statearr_12343_12414[(2)] = inst_12287);

(statearr_12343_12414[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (44))){
var inst_12296 = (state_12303[(2)]);
var state_12303__$1 = (function (){var statearr_12344 = state_12303;
(statearr_12344[(28)] = inst_12296);

return statearr_12344;
})();
var statearr_12345_12415 = state_12303__$1;
(statearr_12345_12415[(2)] = null);

(statearr_12345_12415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (6))){
var inst_12235 = (state_12303[(29)]);
var inst_12234 = cljs.core.deref.call(null,cs);
var inst_12235__$1 = cljs.core.keys.call(null,inst_12234);
var inst_12236 = cljs.core.count.call(null,inst_12235__$1);
var inst_12237 = cljs.core.reset_BANG_.call(null,dctr,inst_12236);
var inst_12242 = cljs.core.seq.call(null,inst_12235__$1);
var inst_12243 = inst_12242;
var inst_12244 = null;
var inst_12245 = (0);
var inst_12246 = (0);
var state_12303__$1 = (function (){var statearr_12346 = state_12303;
(statearr_12346[(10)] = inst_12246);

(statearr_12346[(20)] = inst_12243);

(statearr_12346[(21)] = inst_12245);

(statearr_12346[(29)] = inst_12235__$1);

(statearr_12346[(30)] = inst_12237);

(statearr_12346[(12)] = inst_12244);

return statearr_12346;
})();
var statearr_12347_12416 = state_12303__$1;
(statearr_12347_12416[(2)] = null);

(statearr_12347_12416[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (28))){
var inst_12262 = (state_12303[(25)]);
var inst_12243 = (state_12303[(20)]);
var inst_12262__$1 = cljs.core.seq.call(null,inst_12243);
var state_12303__$1 = (function (){var statearr_12348 = state_12303;
(statearr_12348[(25)] = inst_12262__$1);

return statearr_12348;
})();
if(inst_12262__$1){
var statearr_12349_12417 = state_12303__$1;
(statearr_12349_12417[(1)] = (33));

} else {
var statearr_12350_12418 = state_12303__$1;
(statearr_12350_12418[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (25))){
var inst_12246 = (state_12303[(10)]);
var inst_12245 = (state_12303[(21)]);
var inst_12248 = (inst_12246 < inst_12245);
var inst_12249 = inst_12248;
var state_12303__$1 = state_12303;
if(cljs.core.truth_(inst_12249)){
var statearr_12351_12419 = state_12303__$1;
(statearr_12351_12419[(1)] = (27));

} else {
var statearr_12352_12420 = state_12303__$1;
(statearr_12352_12420[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (34))){
var state_12303__$1 = state_12303;
var statearr_12353_12421 = state_12303__$1;
(statearr_12353_12421[(2)] = null);

(statearr_12353_12421[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (17))){
var state_12303__$1 = state_12303;
var statearr_12354_12422 = state_12303__$1;
(statearr_12354_12422[(2)] = null);

(statearr_12354_12422[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (3))){
var inst_12301 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12303__$1,inst_12301);
} else {
if((state_val_12304 === (12))){
var inst_12230 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12355_12423 = state_12303__$1;
(statearr_12355_12423[(2)] = inst_12230);

(statearr_12355_12423[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (2))){
var state_12303__$1 = state_12303;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12303__$1,(4),ch);
} else {
if((state_val_12304 === (23))){
var state_12303__$1 = state_12303;
var statearr_12356_12424 = state_12303__$1;
(statearr_12356_12424[(2)] = null);

(statearr_12356_12424[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (35))){
var inst_12285 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12357_12425 = state_12303__$1;
(statearr_12357_12425[(2)] = inst_12285);

(statearr_12357_12425[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (19))){
var inst_12204 = (state_12303[(7)]);
var inst_12208 = cljs.core.chunk_first.call(null,inst_12204);
var inst_12209 = cljs.core.chunk_rest.call(null,inst_12204);
var inst_12210 = cljs.core.count.call(null,inst_12208);
var inst_12184 = inst_12209;
var inst_12185 = inst_12208;
var inst_12186 = inst_12210;
var inst_12187 = (0);
var state_12303__$1 = (function (){var statearr_12358 = state_12303;
(statearr_12358[(13)] = inst_12186);

(statearr_12358[(14)] = inst_12187);

(statearr_12358[(15)] = inst_12185);

(statearr_12358[(17)] = inst_12184);

return statearr_12358;
})();
var statearr_12359_12426 = state_12303__$1;
(statearr_12359_12426[(2)] = null);

(statearr_12359_12426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (11))){
var inst_12204 = (state_12303[(7)]);
var inst_12184 = (state_12303[(17)]);
var inst_12204__$1 = cljs.core.seq.call(null,inst_12184);
var state_12303__$1 = (function (){var statearr_12360 = state_12303;
(statearr_12360[(7)] = inst_12204__$1);

return statearr_12360;
})();
if(inst_12204__$1){
var statearr_12361_12427 = state_12303__$1;
(statearr_12361_12427[(1)] = (16));

} else {
var statearr_12362_12428 = state_12303__$1;
(statearr_12362_12428[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (9))){
var inst_12232 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12363_12429 = state_12303__$1;
(statearr_12363_12429[(2)] = inst_12232);

(statearr_12363_12429[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (5))){
var inst_12182 = cljs.core.deref.call(null,cs);
var inst_12183 = cljs.core.seq.call(null,inst_12182);
var inst_12184 = inst_12183;
var inst_12185 = null;
var inst_12186 = (0);
var inst_12187 = (0);
var state_12303__$1 = (function (){var statearr_12364 = state_12303;
(statearr_12364[(13)] = inst_12186);

(statearr_12364[(14)] = inst_12187);

(statearr_12364[(15)] = inst_12185);

(statearr_12364[(17)] = inst_12184);

return statearr_12364;
})();
var statearr_12365_12430 = state_12303__$1;
(statearr_12365_12430[(2)] = null);

(statearr_12365_12430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (14))){
var state_12303__$1 = state_12303;
var statearr_12366_12431 = state_12303__$1;
(statearr_12366_12431[(2)] = null);

(statearr_12366_12431[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (45))){
var inst_12293 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12367_12432 = state_12303__$1;
(statearr_12367_12432[(2)] = inst_12293);

(statearr_12367_12432[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (26))){
var inst_12235 = (state_12303[(29)]);
var inst_12289 = (state_12303[(2)]);
var inst_12290 = cljs.core.seq.call(null,inst_12235);
var state_12303__$1 = (function (){var statearr_12368 = state_12303;
(statearr_12368[(31)] = inst_12289);

return statearr_12368;
})();
if(inst_12290){
var statearr_12369_12433 = state_12303__$1;
(statearr_12369_12433[(1)] = (42));

} else {
var statearr_12370_12434 = state_12303__$1;
(statearr_12370_12434[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (16))){
var inst_12204 = (state_12303[(7)]);
var inst_12206 = cljs.core.chunked_seq_QMARK_.call(null,inst_12204);
var state_12303__$1 = state_12303;
if(inst_12206){
var statearr_12371_12435 = state_12303__$1;
(statearr_12371_12435[(1)] = (19));

} else {
var statearr_12372_12436 = state_12303__$1;
(statearr_12372_12436[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (38))){
var inst_12282 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12373_12437 = state_12303__$1;
(statearr_12373_12437[(2)] = inst_12282);

(statearr_12373_12437[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (30))){
var state_12303__$1 = state_12303;
var statearr_12374_12438 = state_12303__$1;
(statearr_12374_12438[(2)] = null);

(statearr_12374_12438[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (10))){
var inst_12187 = (state_12303[(14)]);
var inst_12185 = (state_12303[(15)]);
var inst_12193 = cljs.core._nth.call(null,inst_12185,inst_12187);
var inst_12194 = cljs.core.nth.call(null,inst_12193,(0),null);
var inst_12195 = cljs.core.nth.call(null,inst_12193,(1),null);
var state_12303__$1 = (function (){var statearr_12375 = state_12303;
(statearr_12375[(26)] = inst_12194);

return statearr_12375;
})();
if(cljs.core.truth_(inst_12195)){
var statearr_12376_12439 = state_12303__$1;
(statearr_12376_12439[(1)] = (13));

} else {
var statearr_12377_12440 = state_12303__$1;
(statearr_12377_12440[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (18))){
var inst_12228 = (state_12303[(2)]);
var state_12303__$1 = state_12303;
var statearr_12378_12441 = state_12303__$1;
(statearr_12378_12441[(2)] = inst_12228);

(statearr_12378_12441[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (42))){
var state_12303__$1 = state_12303;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12303__$1,(45),dchan);
} else {
if((state_val_12304 === (37))){
var inst_12262 = (state_12303[(25)]);
var inst_12271 = (state_12303[(23)]);
var inst_12175 = (state_12303[(11)]);
var inst_12271__$1 = cljs.core.first.call(null,inst_12262);
var inst_12272 = cljs.core.async.put_BANG_.call(null,inst_12271__$1,inst_12175,done);
var state_12303__$1 = (function (){var statearr_12379 = state_12303;
(statearr_12379[(23)] = inst_12271__$1);

return statearr_12379;
})();
if(cljs.core.truth_(inst_12272)){
var statearr_12380_12442 = state_12303__$1;
(statearr_12380_12442[(1)] = (39));

} else {
var statearr_12381_12443 = state_12303__$1;
(statearr_12381_12443[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12304 === (8))){
var inst_12186 = (state_12303[(13)]);
var inst_12187 = (state_12303[(14)]);
var inst_12189 = (inst_12187 < inst_12186);
var inst_12190 = inst_12189;
var state_12303__$1 = state_12303;
if(cljs.core.truth_(inst_12190)){
var statearr_12382_12444 = state_12303__$1;
(statearr_12382_12444[(1)] = (10));

} else {
var statearr_12383_12445 = state_12303__$1;
(statearr_12383_12445[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___12391,cs,m,dchan,dctr,done))
;
return ((function (switch__10972__auto__,c__11084__auto___12391,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10973__auto__ = null;
var cljs$core$async$mult_$_state_machine__10973__auto____0 = (function (){
var statearr_12387 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12387[(0)] = cljs$core$async$mult_$_state_machine__10973__auto__);

(statearr_12387[(1)] = (1));

return statearr_12387;
});
var cljs$core$async$mult_$_state_machine__10973__auto____1 = (function (state_12303){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_12303);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e12388){if((e12388 instanceof Object)){
var ex__10976__auto__ = e12388;
var statearr_12389_12446 = state_12303;
(statearr_12389_12446[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12303);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12388;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12447 = state_12303;
state_12303 = G__12447;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10973__auto__ = function(state_12303){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10973__auto____1.call(this,state_12303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10973__auto____0;
cljs$core$async$mult_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10973__auto____1;
return cljs$core$async$mult_$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___12391,cs,m,dchan,dctr,done))
})();
var state__11086__auto__ = (function (){var statearr_12390 = f__11085__auto__.call(null);
(statearr_12390[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___12391);

return statearr_12390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___12391,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args12448 = [];
var len__5726__auto___12451 = arguments.length;
var i__5727__auto___12452 = (0);
while(true){
if((i__5727__auto___12452 < len__5726__auto___12451)){
args12448.push((arguments[i__5727__auto___12452]));

var G__12453 = (i__5727__auto___12452 + (1));
i__5727__auto___12452 = G__12453;
continue;
} else {
}
break;
}

var G__12450 = args12448.length;
switch (G__12450) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12448.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___12465 = arguments.length;
var i__5727__auto___12466 = (0);
while(true){
if((i__5727__auto___12466 < len__5726__auto___12465)){
args__5733__auto__.push((arguments[i__5727__auto___12466]));

var G__12467 = (i__5727__auto___12466 + (1));
i__5727__auto___12466 = G__12467;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12459){
var map__12460 = p__12459;
var map__12460__$1 = ((((!((map__12460 == null)))?((((map__12460.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12460.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12460):map__12460);
var opts = map__12460__$1;
var statearr_12462_12468 = state;
(statearr_12462_12468[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__12460,map__12460__$1,opts){
return (function (val){
var statearr_12463_12469 = state;
(statearr_12463_12469[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12460,map__12460__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_12464_12470 = state;
(statearr_12464_12470[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12455){
var G__12456 = cljs.core.first.call(null,seq12455);
var seq12455__$1 = cljs.core.next.call(null,seq12455);
var G__12457 = cljs.core.first.call(null,seq12455__$1);
var seq12455__$2 = cljs.core.next.call(null,seq12455__$1);
var G__12458 = cljs.core.first.call(null,seq12455__$2);
var seq12455__$3 = cljs.core.next.call(null,seq12455__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12456,G__12457,G__12458,seq12455__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12634 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12634 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12635){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12635 = meta12635;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12636,meta12635__$1){
var self__ = this;
var _12636__$1 = this;
return (new cljs.core.async.t_cljs$core$async12634(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12635__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12636){
var self__ = this;
var _12636__$1 = this;
return self__.meta12635;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12635","meta12635",-659399111,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12634.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12634.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12634";

cljs.core.async.t_cljs$core$async12634.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12634");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12634 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12634(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12635){
return (new cljs.core.async.t_cljs$core$async12634(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12635));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12634(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11084__auto___12797 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___12797,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___12797,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12734){
var state_val_12735 = (state_12734[(1)]);
if((state_val_12735 === (7))){
var inst_12652 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12736_12798 = state_12734__$1;
(statearr_12736_12798[(2)] = inst_12652);

(statearr_12736_12798[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (20))){
var inst_12664 = (state_12734[(7)]);
var state_12734__$1 = state_12734;
var statearr_12737_12799 = state_12734__$1;
(statearr_12737_12799[(2)] = inst_12664);

(statearr_12737_12799[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (27))){
var state_12734__$1 = state_12734;
var statearr_12738_12800 = state_12734__$1;
(statearr_12738_12800[(2)] = null);

(statearr_12738_12800[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (1))){
var inst_12640 = (state_12734[(8)]);
var inst_12640__$1 = calc_state.call(null);
var inst_12642 = (inst_12640__$1 == null);
var inst_12643 = cljs.core.not.call(null,inst_12642);
var state_12734__$1 = (function (){var statearr_12739 = state_12734;
(statearr_12739[(8)] = inst_12640__$1);

return statearr_12739;
})();
if(inst_12643){
var statearr_12740_12801 = state_12734__$1;
(statearr_12740_12801[(1)] = (2));

} else {
var statearr_12741_12802 = state_12734__$1;
(statearr_12741_12802[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (24))){
var inst_12694 = (state_12734[(9)]);
var inst_12687 = (state_12734[(10)]);
var inst_12708 = (state_12734[(11)]);
var inst_12708__$1 = inst_12687.call(null,inst_12694);
var state_12734__$1 = (function (){var statearr_12742 = state_12734;
(statearr_12742[(11)] = inst_12708__$1);

return statearr_12742;
})();
if(cljs.core.truth_(inst_12708__$1)){
var statearr_12743_12803 = state_12734__$1;
(statearr_12743_12803[(1)] = (29));

} else {
var statearr_12744_12804 = state_12734__$1;
(statearr_12744_12804[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (4))){
var inst_12655 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12655)){
var statearr_12745_12805 = state_12734__$1;
(statearr_12745_12805[(1)] = (8));

} else {
var statearr_12746_12806 = state_12734__$1;
(statearr_12746_12806[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (15))){
var inst_12681 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12681)){
var statearr_12747_12807 = state_12734__$1;
(statearr_12747_12807[(1)] = (19));

} else {
var statearr_12748_12808 = state_12734__$1;
(statearr_12748_12808[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (21))){
var inst_12686 = (state_12734[(12)]);
var inst_12686__$1 = (state_12734[(2)]);
var inst_12687 = cljs.core.get.call(null,inst_12686__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12688 = cljs.core.get.call(null,inst_12686__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12689 = cljs.core.get.call(null,inst_12686__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12734__$1 = (function (){var statearr_12749 = state_12734;
(statearr_12749[(13)] = inst_12688);

(statearr_12749[(10)] = inst_12687);

(statearr_12749[(12)] = inst_12686__$1);

return statearr_12749;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12734__$1,(22),inst_12689);
} else {
if((state_val_12735 === (31))){
var inst_12716 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12716)){
var statearr_12750_12809 = state_12734__$1;
(statearr_12750_12809[(1)] = (32));

} else {
var statearr_12751_12810 = state_12734__$1;
(statearr_12751_12810[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (32))){
var inst_12693 = (state_12734[(14)]);
var state_12734__$1 = state_12734;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12734__$1,(35),out,inst_12693);
} else {
if((state_val_12735 === (33))){
var inst_12686 = (state_12734[(12)]);
var inst_12664 = inst_12686;
var state_12734__$1 = (function (){var statearr_12752 = state_12734;
(statearr_12752[(7)] = inst_12664);

return statearr_12752;
})();
var statearr_12753_12811 = state_12734__$1;
(statearr_12753_12811[(2)] = null);

(statearr_12753_12811[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (13))){
var inst_12664 = (state_12734[(7)]);
var inst_12671 = inst_12664.cljs$lang$protocol_mask$partition0$;
var inst_12672 = (inst_12671 & (64));
var inst_12673 = inst_12664.cljs$core$ISeq$;
var inst_12674 = (inst_12672) || (inst_12673);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12674)){
var statearr_12754_12812 = state_12734__$1;
(statearr_12754_12812[(1)] = (16));

} else {
var statearr_12755_12813 = state_12734__$1;
(statearr_12755_12813[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (22))){
var inst_12693 = (state_12734[(14)]);
var inst_12694 = (state_12734[(9)]);
var inst_12692 = (state_12734[(2)]);
var inst_12693__$1 = cljs.core.nth.call(null,inst_12692,(0),null);
var inst_12694__$1 = cljs.core.nth.call(null,inst_12692,(1),null);
var inst_12695 = (inst_12693__$1 == null);
var inst_12696 = cljs.core._EQ_.call(null,inst_12694__$1,change);
var inst_12697 = (inst_12695) || (inst_12696);
var state_12734__$1 = (function (){var statearr_12756 = state_12734;
(statearr_12756[(14)] = inst_12693__$1);

(statearr_12756[(9)] = inst_12694__$1);

return statearr_12756;
})();
if(cljs.core.truth_(inst_12697)){
var statearr_12757_12814 = state_12734__$1;
(statearr_12757_12814[(1)] = (23));

} else {
var statearr_12758_12815 = state_12734__$1;
(statearr_12758_12815[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (36))){
var inst_12686 = (state_12734[(12)]);
var inst_12664 = inst_12686;
var state_12734__$1 = (function (){var statearr_12759 = state_12734;
(statearr_12759[(7)] = inst_12664);

return statearr_12759;
})();
var statearr_12760_12816 = state_12734__$1;
(statearr_12760_12816[(2)] = null);

(statearr_12760_12816[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (29))){
var inst_12708 = (state_12734[(11)]);
var state_12734__$1 = state_12734;
var statearr_12761_12817 = state_12734__$1;
(statearr_12761_12817[(2)] = inst_12708);

(statearr_12761_12817[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (6))){
var state_12734__$1 = state_12734;
var statearr_12762_12818 = state_12734__$1;
(statearr_12762_12818[(2)] = false);

(statearr_12762_12818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (28))){
var inst_12704 = (state_12734[(2)]);
var inst_12705 = calc_state.call(null);
var inst_12664 = inst_12705;
var state_12734__$1 = (function (){var statearr_12763 = state_12734;
(statearr_12763[(15)] = inst_12704);

(statearr_12763[(7)] = inst_12664);

return statearr_12763;
})();
var statearr_12764_12819 = state_12734__$1;
(statearr_12764_12819[(2)] = null);

(statearr_12764_12819[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (25))){
var inst_12730 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12765_12820 = state_12734__$1;
(statearr_12765_12820[(2)] = inst_12730);

(statearr_12765_12820[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (34))){
var inst_12728 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12766_12821 = state_12734__$1;
(statearr_12766_12821[(2)] = inst_12728);

(statearr_12766_12821[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (17))){
var state_12734__$1 = state_12734;
var statearr_12767_12822 = state_12734__$1;
(statearr_12767_12822[(2)] = false);

(statearr_12767_12822[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (3))){
var state_12734__$1 = state_12734;
var statearr_12768_12823 = state_12734__$1;
(statearr_12768_12823[(2)] = false);

(statearr_12768_12823[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (12))){
var inst_12732 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12734__$1,inst_12732);
} else {
if((state_val_12735 === (2))){
var inst_12640 = (state_12734[(8)]);
var inst_12645 = inst_12640.cljs$lang$protocol_mask$partition0$;
var inst_12646 = (inst_12645 & (64));
var inst_12647 = inst_12640.cljs$core$ISeq$;
var inst_12648 = (inst_12646) || (inst_12647);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12648)){
var statearr_12769_12824 = state_12734__$1;
(statearr_12769_12824[(1)] = (5));

} else {
var statearr_12770_12825 = state_12734__$1;
(statearr_12770_12825[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (23))){
var inst_12693 = (state_12734[(14)]);
var inst_12699 = (inst_12693 == null);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12699)){
var statearr_12771_12826 = state_12734__$1;
(statearr_12771_12826[(1)] = (26));

} else {
var statearr_12772_12827 = state_12734__$1;
(statearr_12772_12827[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (35))){
var inst_12719 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12719)){
var statearr_12773_12828 = state_12734__$1;
(statearr_12773_12828[(1)] = (36));

} else {
var statearr_12774_12829 = state_12734__$1;
(statearr_12774_12829[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (19))){
var inst_12664 = (state_12734[(7)]);
var inst_12683 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12664);
var state_12734__$1 = state_12734;
var statearr_12775_12830 = state_12734__$1;
(statearr_12775_12830[(2)] = inst_12683);

(statearr_12775_12830[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (11))){
var inst_12664 = (state_12734[(7)]);
var inst_12668 = (inst_12664 == null);
var inst_12669 = cljs.core.not.call(null,inst_12668);
var state_12734__$1 = state_12734;
if(inst_12669){
var statearr_12776_12831 = state_12734__$1;
(statearr_12776_12831[(1)] = (13));

} else {
var statearr_12777_12832 = state_12734__$1;
(statearr_12777_12832[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (9))){
var inst_12640 = (state_12734[(8)]);
var state_12734__$1 = state_12734;
var statearr_12778_12833 = state_12734__$1;
(statearr_12778_12833[(2)] = inst_12640);

(statearr_12778_12833[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (5))){
var state_12734__$1 = state_12734;
var statearr_12779_12834 = state_12734__$1;
(statearr_12779_12834[(2)] = true);

(statearr_12779_12834[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (14))){
var state_12734__$1 = state_12734;
var statearr_12780_12835 = state_12734__$1;
(statearr_12780_12835[(2)] = false);

(statearr_12780_12835[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (26))){
var inst_12694 = (state_12734[(9)]);
var inst_12701 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12694);
var state_12734__$1 = state_12734;
var statearr_12781_12836 = state_12734__$1;
(statearr_12781_12836[(2)] = inst_12701);

(statearr_12781_12836[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (16))){
var state_12734__$1 = state_12734;
var statearr_12782_12837 = state_12734__$1;
(statearr_12782_12837[(2)] = true);

(statearr_12782_12837[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (38))){
var inst_12724 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12783_12838 = state_12734__$1;
(statearr_12783_12838[(2)] = inst_12724);

(statearr_12783_12838[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (30))){
var inst_12688 = (state_12734[(13)]);
var inst_12694 = (state_12734[(9)]);
var inst_12687 = (state_12734[(10)]);
var inst_12711 = cljs.core.empty_QMARK_.call(null,inst_12687);
var inst_12712 = inst_12688.call(null,inst_12694);
var inst_12713 = cljs.core.not.call(null,inst_12712);
var inst_12714 = (inst_12711) && (inst_12713);
var state_12734__$1 = state_12734;
var statearr_12784_12839 = state_12734__$1;
(statearr_12784_12839[(2)] = inst_12714);

(statearr_12784_12839[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (10))){
var inst_12640 = (state_12734[(8)]);
var inst_12660 = (state_12734[(2)]);
var inst_12661 = cljs.core.get.call(null,inst_12660,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12662 = cljs.core.get.call(null,inst_12660,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12663 = cljs.core.get.call(null,inst_12660,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12664 = inst_12640;
var state_12734__$1 = (function (){var statearr_12785 = state_12734;
(statearr_12785[(16)] = inst_12663);

(statearr_12785[(17)] = inst_12661);

(statearr_12785[(7)] = inst_12664);

(statearr_12785[(18)] = inst_12662);

return statearr_12785;
})();
var statearr_12786_12840 = state_12734__$1;
(statearr_12786_12840[(2)] = null);

(statearr_12786_12840[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (18))){
var inst_12678 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12787_12841 = state_12734__$1;
(statearr_12787_12841[(2)] = inst_12678);

(statearr_12787_12841[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (37))){
var state_12734__$1 = state_12734;
var statearr_12788_12842 = state_12734__$1;
(statearr_12788_12842[(2)] = null);

(statearr_12788_12842[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (8))){
var inst_12640 = (state_12734[(8)]);
var inst_12657 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12640);
var state_12734__$1 = state_12734;
var statearr_12789_12843 = state_12734__$1;
(statearr_12789_12843[(2)] = inst_12657);

(statearr_12789_12843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___12797,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10972__auto__,c__11084__auto___12797,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10973__auto__ = null;
var cljs$core$async$mix_$_state_machine__10973__auto____0 = (function (){
var statearr_12793 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12793[(0)] = cljs$core$async$mix_$_state_machine__10973__auto__);

(statearr_12793[(1)] = (1));

return statearr_12793;
});
var cljs$core$async$mix_$_state_machine__10973__auto____1 = (function (state_12734){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_12734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e12794){if((e12794 instanceof Object)){
var ex__10976__auto__ = e12794;
var statearr_12795_12844 = state_12734;
(statearr_12795_12844[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12734);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12845 = state_12734;
state_12734 = G__12845;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10973__auto__ = function(state_12734){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10973__auto____1.call(this,state_12734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10973__auto____0;
cljs$core$async$mix_$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10973__auto____1;
return cljs$core$async$mix_$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___12797,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11086__auto__ = (function (){var statearr_12796 = f__11085__auto__.call(null);
(statearr_12796[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___12797);

return statearr_12796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___12797,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12846 = [];
var len__5726__auto___12849 = arguments.length;
var i__5727__auto___12850 = (0);
while(true){
if((i__5727__auto___12850 < len__5726__auto___12849)){
args12846.push((arguments[i__5727__auto___12850]));

var G__12851 = (i__5727__auto___12850 + (1));
i__5727__auto___12850 = G__12851;
continue;
} else {
}
break;
}

var G__12848 = args12846.length;
switch (G__12848) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12846.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12854 = [];
var len__5726__auto___12979 = arguments.length;
var i__5727__auto___12980 = (0);
while(true){
if((i__5727__auto___12980 < len__5726__auto___12979)){
args12854.push((arguments[i__5727__auto___12980]));

var G__12981 = (i__5727__auto___12980 + (1));
i__5727__auto___12980 = G__12981;
continue;
} else {
}
break;
}

var G__12856 = args12854.length;
switch (G__12856) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12854.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__12853_SHARP_){
if(cljs.core.truth_(p1__12853_SHARP_.call(null,topic))){
return p1__12853_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12853_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12857 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12857 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12858){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12858 = meta12858;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12859,meta12858__$1){
var self__ = this;
var _12859__$1 = this;
return (new cljs.core.async.t_cljs$core$async12857(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12858__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12859){
var self__ = this;
var _12859__$1 = this;
return self__.meta12858;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12857.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12857.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12858","meta12858",1895227439,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12857.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12857.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12857";

cljs.core.async.t_cljs$core$async12857.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12857");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12857 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12857(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12858){
return (new cljs.core.async.t_cljs$core$async12857(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12858));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12857(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11084__auto___12983 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___12983,mults,ensure_mult,p){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___12983,mults,ensure_mult,p){
return (function (state_12931){
var state_val_12932 = (state_12931[(1)]);
if((state_val_12932 === (7))){
var inst_12927 = (state_12931[(2)]);
var state_12931__$1 = state_12931;
var statearr_12933_12984 = state_12931__$1;
(statearr_12933_12984[(2)] = inst_12927);

(statearr_12933_12984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (20))){
var state_12931__$1 = state_12931;
var statearr_12934_12985 = state_12931__$1;
(statearr_12934_12985[(2)] = null);

(statearr_12934_12985[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (1))){
var state_12931__$1 = state_12931;
var statearr_12935_12986 = state_12931__$1;
(statearr_12935_12986[(2)] = null);

(statearr_12935_12986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (24))){
var inst_12910 = (state_12931[(7)]);
var inst_12919 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12910);
var state_12931__$1 = state_12931;
var statearr_12936_12987 = state_12931__$1;
(statearr_12936_12987[(2)] = inst_12919);

(statearr_12936_12987[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (4))){
var inst_12862 = (state_12931[(8)]);
var inst_12862__$1 = (state_12931[(2)]);
var inst_12863 = (inst_12862__$1 == null);
var state_12931__$1 = (function (){var statearr_12937 = state_12931;
(statearr_12937[(8)] = inst_12862__$1);

return statearr_12937;
})();
if(cljs.core.truth_(inst_12863)){
var statearr_12938_12988 = state_12931__$1;
(statearr_12938_12988[(1)] = (5));

} else {
var statearr_12939_12989 = state_12931__$1;
(statearr_12939_12989[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (15))){
var inst_12904 = (state_12931[(2)]);
var state_12931__$1 = state_12931;
var statearr_12940_12990 = state_12931__$1;
(statearr_12940_12990[(2)] = inst_12904);

(statearr_12940_12990[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (21))){
var inst_12924 = (state_12931[(2)]);
var state_12931__$1 = (function (){var statearr_12941 = state_12931;
(statearr_12941[(9)] = inst_12924);

return statearr_12941;
})();
var statearr_12942_12991 = state_12931__$1;
(statearr_12942_12991[(2)] = null);

(statearr_12942_12991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (13))){
var inst_12886 = (state_12931[(10)]);
var inst_12888 = cljs.core.chunked_seq_QMARK_.call(null,inst_12886);
var state_12931__$1 = state_12931;
if(inst_12888){
var statearr_12943_12992 = state_12931__$1;
(statearr_12943_12992[(1)] = (16));

} else {
var statearr_12944_12993 = state_12931__$1;
(statearr_12944_12993[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (22))){
var inst_12916 = (state_12931[(2)]);
var state_12931__$1 = state_12931;
if(cljs.core.truth_(inst_12916)){
var statearr_12945_12994 = state_12931__$1;
(statearr_12945_12994[(1)] = (23));

} else {
var statearr_12946_12995 = state_12931__$1;
(statearr_12946_12995[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (6))){
var inst_12910 = (state_12931[(7)]);
var inst_12862 = (state_12931[(8)]);
var inst_12912 = (state_12931[(11)]);
var inst_12910__$1 = topic_fn.call(null,inst_12862);
var inst_12911 = cljs.core.deref.call(null,mults);
var inst_12912__$1 = cljs.core.get.call(null,inst_12911,inst_12910__$1);
var state_12931__$1 = (function (){var statearr_12947 = state_12931;
(statearr_12947[(7)] = inst_12910__$1);

(statearr_12947[(11)] = inst_12912__$1);

return statearr_12947;
})();
if(cljs.core.truth_(inst_12912__$1)){
var statearr_12948_12996 = state_12931__$1;
(statearr_12948_12996[(1)] = (19));

} else {
var statearr_12949_12997 = state_12931__$1;
(statearr_12949_12997[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (25))){
var inst_12921 = (state_12931[(2)]);
var state_12931__$1 = state_12931;
var statearr_12950_12998 = state_12931__$1;
(statearr_12950_12998[(2)] = inst_12921);

(statearr_12950_12998[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (17))){
var inst_12886 = (state_12931[(10)]);
var inst_12895 = cljs.core.first.call(null,inst_12886);
var inst_12896 = cljs.core.async.muxch_STAR_.call(null,inst_12895);
var inst_12897 = cljs.core.async.close_BANG_.call(null,inst_12896);
var inst_12898 = cljs.core.next.call(null,inst_12886);
var inst_12872 = inst_12898;
var inst_12873 = null;
var inst_12874 = (0);
var inst_12875 = (0);
var state_12931__$1 = (function (){var statearr_12951 = state_12931;
(statearr_12951[(12)] = inst_12897);

(statearr_12951[(13)] = inst_12874);

(statearr_12951[(14)] = inst_12873);

(statearr_12951[(15)] = inst_12872);

(statearr_12951[(16)] = inst_12875);

return statearr_12951;
})();
var statearr_12952_12999 = state_12931__$1;
(statearr_12952_12999[(2)] = null);

(statearr_12952_12999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (3))){
var inst_12929 = (state_12931[(2)]);
var state_12931__$1 = state_12931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12931__$1,inst_12929);
} else {
if((state_val_12932 === (12))){
var inst_12906 = (state_12931[(2)]);
var state_12931__$1 = state_12931;
var statearr_12953_13000 = state_12931__$1;
(statearr_12953_13000[(2)] = inst_12906);

(statearr_12953_13000[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (2))){
var state_12931__$1 = state_12931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12931__$1,(4),ch);
} else {
if((state_val_12932 === (23))){
var state_12931__$1 = state_12931;
var statearr_12954_13001 = state_12931__$1;
(statearr_12954_13001[(2)] = null);

(statearr_12954_13001[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (19))){
var inst_12862 = (state_12931[(8)]);
var inst_12912 = (state_12931[(11)]);
var inst_12914 = cljs.core.async.muxch_STAR_.call(null,inst_12912);
var state_12931__$1 = state_12931;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12931__$1,(22),inst_12914,inst_12862);
} else {
if((state_val_12932 === (11))){
var inst_12872 = (state_12931[(15)]);
var inst_12886 = (state_12931[(10)]);
var inst_12886__$1 = cljs.core.seq.call(null,inst_12872);
var state_12931__$1 = (function (){var statearr_12955 = state_12931;
(statearr_12955[(10)] = inst_12886__$1);

return statearr_12955;
})();
if(inst_12886__$1){
var statearr_12956_13002 = state_12931__$1;
(statearr_12956_13002[(1)] = (13));

} else {
var statearr_12957_13003 = state_12931__$1;
(statearr_12957_13003[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (9))){
var inst_12908 = (state_12931[(2)]);
var state_12931__$1 = state_12931;
var statearr_12958_13004 = state_12931__$1;
(statearr_12958_13004[(2)] = inst_12908);

(statearr_12958_13004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (5))){
var inst_12869 = cljs.core.deref.call(null,mults);
var inst_12870 = cljs.core.vals.call(null,inst_12869);
var inst_12871 = cljs.core.seq.call(null,inst_12870);
var inst_12872 = inst_12871;
var inst_12873 = null;
var inst_12874 = (0);
var inst_12875 = (0);
var state_12931__$1 = (function (){var statearr_12959 = state_12931;
(statearr_12959[(13)] = inst_12874);

(statearr_12959[(14)] = inst_12873);

(statearr_12959[(15)] = inst_12872);

(statearr_12959[(16)] = inst_12875);

return statearr_12959;
})();
var statearr_12960_13005 = state_12931__$1;
(statearr_12960_13005[(2)] = null);

(statearr_12960_13005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (14))){
var state_12931__$1 = state_12931;
var statearr_12964_13006 = state_12931__$1;
(statearr_12964_13006[(2)] = null);

(statearr_12964_13006[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (16))){
var inst_12886 = (state_12931[(10)]);
var inst_12890 = cljs.core.chunk_first.call(null,inst_12886);
var inst_12891 = cljs.core.chunk_rest.call(null,inst_12886);
var inst_12892 = cljs.core.count.call(null,inst_12890);
var inst_12872 = inst_12891;
var inst_12873 = inst_12890;
var inst_12874 = inst_12892;
var inst_12875 = (0);
var state_12931__$1 = (function (){var statearr_12965 = state_12931;
(statearr_12965[(13)] = inst_12874);

(statearr_12965[(14)] = inst_12873);

(statearr_12965[(15)] = inst_12872);

(statearr_12965[(16)] = inst_12875);

return statearr_12965;
})();
var statearr_12966_13007 = state_12931__$1;
(statearr_12966_13007[(2)] = null);

(statearr_12966_13007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (10))){
var inst_12874 = (state_12931[(13)]);
var inst_12873 = (state_12931[(14)]);
var inst_12872 = (state_12931[(15)]);
var inst_12875 = (state_12931[(16)]);
var inst_12880 = cljs.core._nth.call(null,inst_12873,inst_12875);
var inst_12881 = cljs.core.async.muxch_STAR_.call(null,inst_12880);
var inst_12882 = cljs.core.async.close_BANG_.call(null,inst_12881);
var inst_12883 = (inst_12875 + (1));
var tmp12961 = inst_12874;
var tmp12962 = inst_12873;
var tmp12963 = inst_12872;
var inst_12872__$1 = tmp12963;
var inst_12873__$1 = tmp12962;
var inst_12874__$1 = tmp12961;
var inst_12875__$1 = inst_12883;
var state_12931__$1 = (function (){var statearr_12967 = state_12931;
(statearr_12967[(17)] = inst_12882);

(statearr_12967[(13)] = inst_12874__$1);

(statearr_12967[(14)] = inst_12873__$1);

(statearr_12967[(15)] = inst_12872__$1);

(statearr_12967[(16)] = inst_12875__$1);

return statearr_12967;
})();
var statearr_12968_13008 = state_12931__$1;
(statearr_12968_13008[(2)] = null);

(statearr_12968_13008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (18))){
var inst_12901 = (state_12931[(2)]);
var state_12931__$1 = state_12931;
var statearr_12969_13009 = state_12931__$1;
(statearr_12969_13009[(2)] = inst_12901);

(statearr_12969_13009[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12932 === (8))){
var inst_12874 = (state_12931[(13)]);
var inst_12875 = (state_12931[(16)]);
var inst_12877 = (inst_12875 < inst_12874);
var inst_12878 = inst_12877;
var state_12931__$1 = state_12931;
if(cljs.core.truth_(inst_12878)){
var statearr_12970_13010 = state_12931__$1;
(statearr_12970_13010[(1)] = (10));

} else {
var statearr_12971_13011 = state_12931__$1;
(statearr_12971_13011[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___12983,mults,ensure_mult,p))
;
return ((function (switch__10972__auto__,c__11084__auto___12983,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_12975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12975[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_12975[(1)] = (1));

return statearr_12975;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_12931){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_12931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e12976){if((e12976 instanceof Object)){
var ex__10976__auto__ = e12976;
var statearr_12977_13012 = state_12931;
(statearr_12977_13012[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12976;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13013 = state_12931;
state_12931 = G__13013;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_12931){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_12931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___12983,mults,ensure_mult,p))
})();
var state__11086__auto__ = (function (){var statearr_12978 = f__11085__auto__.call(null);
(statearr_12978[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___12983);

return statearr_12978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___12983,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args13014 = [];
var len__5726__auto___13017 = arguments.length;
var i__5727__auto___13018 = (0);
while(true){
if((i__5727__auto___13018 < len__5726__auto___13017)){
args13014.push((arguments[i__5727__auto___13018]));

var G__13019 = (i__5727__auto___13018 + (1));
i__5727__auto___13018 = G__13019;
continue;
} else {
}
break;
}

var G__13016 = args13014.length;
switch (G__13016) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13014.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args13021 = [];
var len__5726__auto___13024 = arguments.length;
var i__5727__auto___13025 = (0);
while(true){
if((i__5727__auto___13025 < len__5726__auto___13024)){
args13021.push((arguments[i__5727__auto___13025]));

var G__13026 = (i__5727__auto___13025 + (1));
i__5727__auto___13025 = G__13026;
continue;
} else {
}
break;
}

var G__13023 = args13021.length;
switch (G__13023) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13021.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13028 = [];
var len__5726__auto___13099 = arguments.length;
var i__5727__auto___13100 = (0);
while(true){
if((i__5727__auto___13100 < len__5726__auto___13099)){
args13028.push((arguments[i__5727__auto___13100]));

var G__13101 = (i__5727__auto___13100 + (1));
i__5727__auto___13100 = G__13101;
continue;
} else {
}
break;
}

var G__13030 = args13028.length;
switch (G__13030) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13028.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11084__auto___13103 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___13103,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___13103,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13069){
var state_val_13070 = (state_13069[(1)]);
if((state_val_13070 === (7))){
var state_13069__$1 = state_13069;
var statearr_13071_13104 = state_13069__$1;
(statearr_13071_13104[(2)] = null);

(statearr_13071_13104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (1))){
var state_13069__$1 = state_13069;
var statearr_13072_13105 = state_13069__$1;
(statearr_13072_13105[(2)] = null);

(statearr_13072_13105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (4))){
var inst_13033 = (state_13069[(7)]);
var inst_13035 = (inst_13033 < cnt);
var state_13069__$1 = state_13069;
if(cljs.core.truth_(inst_13035)){
var statearr_13073_13106 = state_13069__$1;
(statearr_13073_13106[(1)] = (6));

} else {
var statearr_13074_13107 = state_13069__$1;
(statearr_13074_13107[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (15))){
var inst_13065 = (state_13069[(2)]);
var state_13069__$1 = state_13069;
var statearr_13075_13108 = state_13069__$1;
(statearr_13075_13108[(2)] = inst_13065);

(statearr_13075_13108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (13))){
var inst_13058 = cljs.core.async.close_BANG_.call(null,out);
var state_13069__$1 = state_13069;
var statearr_13076_13109 = state_13069__$1;
(statearr_13076_13109[(2)] = inst_13058);

(statearr_13076_13109[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (6))){
var state_13069__$1 = state_13069;
var statearr_13077_13110 = state_13069__$1;
(statearr_13077_13110[(2)] = null);

(statearr_13077_13110[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (3))){
var inst_13067 = (state_13069[(2)]);
var state_13069__$1 = state_13069;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13069__$1,inst_13067);
} else {
if((state_val_13070 === (12))){
var inst_13055 = (state_13069[(8)]);
var inst_13055__$1 = (state_13069[(2)]);
var inst_13056 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13055__$1);
var state_13069__$1 = (function (){var statearr_13078 = state_13069;
(statearr_13078[(8)] = inst_13055__$1);

return statearr_13078;
})();
if(cljs.core.truth_(inst_13056)){
var statearr_13079_13111 = state_13069__$1;
(statearr_13079_13111[(1)] = (13));

} else {
var statearr_13080_13112 = state_13069__$1;
(statearr_13080_13112[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (2))){
var inst_13032 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13033 = (0);
var state_13069__$1 = (function (){var statearr_13081 = state_13069;
(statearr_13081[(7)] = inst_13033);

(statearr_13081[(9)] = inst_13032);

return statearr_13081;
})();
var statearr_13082_13113 = state_13069__$1;
(statearr_13082_13113[(2)] = null);

(statearr_13082_13113[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (11))){
var inst_13033 = (state_13069[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13069,(10),Object,null,(9));
var inst_13042 = chs__$1.call(null,inst_13033);
var inst_13043 = done.call(null,inst_13033);
var inst_13044 = cljs.core.async.take_BANG_.call(null,inst_13042,inst_13043);
var state_13069__$1 = state_13069;
var statearr_13083_13114 = state_13069__$1;
(statearr_13083_13114[(2)] = inst_13044);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13069__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (9))){
var inst_13033 = (state_13069[(7)]);
var inst_13046 = (state_13069[(2)]);
var inst_13047 = (inst_13033 + (1));
var inst_13033__$1 = inst_13047;
var state_13069__$1 = (function (){var statearr_13084 = state_13069;
(statearr_13084[(7)] = inst_13033__$1);

(statearr_13084[(10)] = inst_13046);

return statearr_13084;
})();
var statearr_13085_13115 = state_13069__$1;
(statearr_13085_13115[(2)] = null);

(statearr_13085_13115[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (5))){
var inst_13053 = (state_13069[(2)]);
var state_13069__$1 = (function (){var statearr_13086 = state_13069;
(statearr_13086[(11)] = inst_13053);

return statearr_13086;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13069__$1,(12),dchan);
} else {
if((state_val_13070 === (14))){
var inst_13055 = (state_13069[(8)]);
var inst_13060 = cljs.core.apply.call(null,f,inst_13055);
var state_13069__$1 = state_13069;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13069__$1,(16),out,inst_13060);
} else {
if((state_val_13070 === (16))){
var inst_13062 = (state_13069[(2)]);
var state_13069__$1 = (function (){var statearr_13087 = state_13069;
(statearr_13087[(12)] = inst_13062);

return statearr_13087;
})();
var statearr_13088_13116 = state_13069__$1;
(statearr_13088_13116[(2)] = null);

(statearr_13088_13116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (10))){
var inst_13037 = (state_13069[(2)]);
var inst_13038 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13069__$1 = (function (){var statearr_13089 = state_13069;
(statearr_13089[(13)] = inst_13037);

return statearr_13089;
})();
var statearr_13090_13117 = state_13069__$1;
(statearr_13090_13117[(2)] = inst_13038);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13069__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13070 === (8))){
var inst_13051 = (state_13069[(2)]);
var state_13069__$1 = state_13069;
var statearr_13091_13118 = state_13069__$1;
(statearr_13091_13118[(2)] = inst_13051);

(statearr_13091_13118[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___13103,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10972__auto__,c__11084__auto___13103,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_13095 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13095[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_13095[(1)] = (1));

return statearr_13095;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_13069){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_13069);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e13096){if((e13096 instanceof Object)){
var ex__10976__auto__ = e13096;
var statearr_13097_13119 = state_13069;
(statearr_13097_13119[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13069);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13096;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13120 = state_13069;
state_13069 = G__13120;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_13069){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_13069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___13103,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11086__auto__ = (function (){var statearr_13098 = f__11085__auto__.call(null);
(statearr_13098[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___13103);

return statearr_13098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___13103,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13122 = [];
var len__5726__auto___13178 = arguments.length;
var i__5727__auto___13179 = (0);
while(true){
if((i__5727__auto___13179 < len__5726__auto___13178)){
args13122.push((arguments[i__5727__auto___13179]));

var G__13180 = (i__5727__auto___13179 + (1));
i__5727__auto___13179 = G__13180;
continue;
} else {
}
break;
}

var G__13124 = args13122.length;
switch (G__13124) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13122.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___13182 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___13182,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___13182,out){
return (function (state_13154){
var state_val_13155 = (state_13154[(1)]);
if((state_val_13155 === (7))){
var inst_13133 = (state_13154[(7)]);
var inst_13134 = (state_13154[(8)]);
var inst_13133__$1 = (state_13154[(2)]);
var inst_13134__$1 = cljs.core.nth.call(null,inst_13133__$1,(0),null);
var inst_13135 = cljs.core.nth.call(null,inst_13133__$1,(1),null);
var inst_13136 = (inst_13134__$1 == null);
var state_13154__$1 = (function (){var statearr_13156 = state_13154;
(statearr_13156[(9)] = inst_13135);

(statearr_13156[(7)] = inst_13133__$1);

(statearr_13156[(8)] = inst_13134__$1);

return statearr_13156;
})();
if(cljs.core.truth_(inst_13136)){
var statearr_13157_13183 = state_13154__$1;
(statearr_13157_13183[(1)] = (8));

} else {
var statearr_13158_13184 = state_13154__$1;
(statearr_13158_13184[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13155 === (1))){
var inst_13125 = cljs.core.vec.call(null,chs);
var inst_13126 = inst_13125;
var state_13154__$1 = (function (){var statearr_13159 = state_13154;
(statearr_13159[(10)] = inst_13126);

return statearr_13159;
})();
var statearr_13160_13185 = state_13154__$1;
(statearr_13160_13185[(2)] = null);

(statearr_13160_13185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13155 === (4))){
var inst_13126 = (state_13154[(10)]);
var state_13154__$1 = state_13154;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13154__$1,(7),inst_13126);
} else {
if((state_val_13155 === (6))){
var inst_13150 = (state_13154[(2)]);
var state_13154__$1 = state_13154;
var statearr_13161_13186 = state_13154__$1;
(statearr_13161_13186[(2)] = inst_13150);

(statearr_13161_13186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13155 === (3))){
var inst_13152 = (state_13154[(2)]);
var state_13154__$1 = state_13154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13154__$1,inst_13152);
} else {
if((state_val_13155 === (2))){
var inst_13126 = (state_13154[(10)]);
var inst_13128 = cljs.core.count.call(null,inst_13126);
var inst_13129 = (inst_13128 > (0));
var state_13154__$1 = state_13154;
if(cljs.core.truth_(inst_13129)){
var statearr_13163_13187 = state_13154__$1;
(statearr_13163_13187[(1)] = (4));

} else {
var statearr_13164_13188 = state_13154__$1;
(statearr_13164_13188[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13155 === (11))){
var inst_13126 = (state_13154[(10)]);
var inst_13143 = (state_13154[(2)]);
var tmp13162 = inst_13126;
var inst_13126__$1 = tmp13162;
var state_13154__$1 = (function (){var statearr_13165 = state_13154;
(statearr_13165[(10)] = inst_13126__$1);

(statearr_13165[(11)] = inst_13143);

return statearr_13165;
})();
var statearr_13166_13189 = state_13154__$1;
(statearr_13166_13189[(2)] = null);

(statearr_13166_13189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13155 === (9))){
var inst_13134 = (state_13154[(8)]);
var state_13154__$1 = state_13154;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13154__$1,(11),out,inst_13134);
} else {
if((state_val_13155 === (5))){
var inst_13148 = cljs.core.async.close_BANG_.call(null,out);
var state_13154__$1 = state_13154;
var statearr_13167_13190 = state_13154__$1;
(statearr_13167_13190[(2)] = inst_13148);

(statearr_13167_13190[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13155 === (10))){
var inst_13146 = (state_13154[(2)]);
var state_13154__$1 = state_13154;
var statearr_13168_13191 = state_13154__$1;
(statearr_13168_13191[(2)] = inst_13146);

(statearr_13168_13191[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13155 === (8))){
var inst_13135 = (state_13154[(9)]);
var inst_13126 = (state_13154[(10)]);
var inst_13133 = (state_13154[(7)]);
var inst_13134 = (state_13154[(8)]);
var inst_13138 = (function (){var cs = inst_13126;
var vec__13131 = inst_13133;
var v = inst_13134;
var c = inst_13135;
return ((function (cs,vec__13131,v,c,inst_13135,inst_13126,inst_13133,inst_13134,state_val_13155,c__11084__auto___13182,out){
return (function (p1__13121_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13121_SHARP_);
});
;})(cs,vec__13131,v,c,inst_13135,inst_13126,inst_13133,inst_13134,state_val_13155,c__11084__auto___13182,out))
})();
var inst_13139 = cljs.core.filterv.call(null,inst_13138,inst_13126);
var inst_13126__$1 = inst_13139;
var state_13154__$1 = (function (){var statearr_13169 = state_13154;
(statearr_13169[(10)] = inst_13126__$1);

return statearr_13169;
})();
var statearr_13170_13192 = state_13154__$1;
(statearr_13170_13192[(2)] = null);

(statearr_13170_13192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___13182,out))
;
return ((function (switch__10972__auto__,c__11084__auto___13182,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_13174 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13174[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_13174[(1)] = (1));

return statearr_13174;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_13154){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_13154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e13175){if((e13175 instanceof Object)){
var ex__10976__auto__ = e13175;
var statearr_13176_13193 = state_13154;
(statearr_13176_13193[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13175;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13194 = state_13154;
state_13154 = G__13194;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_13154){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_13154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___13182,out))
})();
var state__11086__auto__ = (function (){var statearr_13177 = f__11085__auto__.call(null);
(statearr_13177[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___13182);

return statearr_13177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___13182,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13195 = [];
var len__5726__auto___13244 = arguments.length;
var i__5727__auto___13245 = (0);
while(true){
if((i__5727__auto___13245 < len__5726__auto___13244)){
args13195.push((arguments[i__5727__auto___13245]));

var G__13246 = (i__5727__auto___13245 + (1));
i__5727__auto___13245 = G__13246;
continue;
} else {
}
break;
}

var G__13197 = args13195.length;
switch (G__13197) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13195.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___13248 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___13248,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___13248,out){
return (function (state_13221){
var state_val_13222 = (state_13221[(1)]);
if((state_val_13222 === (7))){
var inst_13203 = (state_13221[(7)]);
var inst_13203__$1 = (state_13221[(2)]);
var inst_13204 = (inst_13203__$1 == null);
var inst_13205 = cljs.core.not.call(null,inst_13204);
var state_13221__$1 = (function (){var statearr_13223 = state_13221;
(statearr_13223[(7)] = inst_13203__$1);

return statearr_13223;
})();
if(inst_13205){
var statearr_13224_13249 = state_13221__$1;
(statearr_13224_13249[(1)] = (8));

} else {
var statearr_13225_13250 = state_13221__$1;
(statearr_13225_13250[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (1))){
var inst_13198 = (0);
var state_13221__$1 = (function (){var statearr_13226 = state_13221;
(statearr_13226[(8)] = inst_13198);

return statearr_13226;
})();
var statearr_13227_13251 = state_13221__$1;
(statearr_13227_13251[(2)] = null);

(statearr_13227_13251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (4))){
var state_13221__$1 = state_13221;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13221__$1,(7),ch);
} else {
if((state_val_13222 === (6))){
var inst_13216 = (state_13221[(2)]);
var state_13221__$1 = state_13221;
var statearr_13228_13252 = state_13221__$1;
(statearr_13228_13252[(2)] = inst_13216);

(statearr_13228_13252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (3))){
var inst_13218 = (state_13221[(2)]);
var inst_13219 = cljs.core.async.close_BANG_.call(null,out);
var state_13221__$1 = (function (){var statearr_13229 = state_13221;
(statearr_13229[(9)] = inst_13218);

return statearr_13229;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13221__$1,inst_13219);
} else {
if((state_val_13222 === (2))){
var inst_13198 = (state_13221[(8)]);
var inst_13200 = (inst_13198 < n);
var state_13221__$1 = state_13221;
if(cljs.core.truth_(inst_13200)){
var statearr_13230_13253 = state_13221__$1;
(statearr_13230_13253[(1)] = (4));

} else {
var statearr_13231_13254 = state_13221__$1;
(statearr_13231_13254[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (11))){
var inst_13198 = (state_13221[(8)]);
var inst_13208 = (state_13221[(2)]);
var inst_13209 = (inst_13198 + (1));
var inst_13198__$1 = inst_13209;
var state_13221__$1 = (function (){var statearr_13232 = state_13221;
(statearr_13232[(10)] = inst_13208);

(statearr_13232[(8)] = inst_13198__$1);

return statearr_13232;
})();
var statearr_13233_13255 = state_13221__$1;
(statearr_13233_13255[(2)] = null);

(statearr_13233_13255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (9))){
var state_13221__$1 = state_13221;
var statearr_13234_13256 = state_13221__$1;
(statearr_13234_13256[(2)] = null);

(statearr_13234_13256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (5))){
var state_13221__$1 = state_13221;
var statearr_13235_13257 = state_13221__$1;
(statearr_13235_13257[(2)] = null);

(statearr_13235_13257[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (10))){
var inst_13213 = (state_13221[(2)]);
var state_13221__$1 = state_13221;
var statearr_13236_13258 = state_13221__$1;
(statearr_13236_13258[(2)] = inst_13213);

(statearr_13236_13258[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13222 === (8))){
var inst_13203 = (state_13221[(7)]);
var state_13221__$1 = state_13221;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13221__$1,(11),out,inst_13203);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___13248,out))
;
return ((function (switch__10972__auto__,c__11084__auto___13248,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_13240 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13240[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_13240[(1)] = (1));

return statearr_13240;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_13221){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_13221);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e13241){if((e13241 instanceof Object)){
var ex__10976__auto__ = e13241;
var statearr_13242_13259 = state_13221;
(statearr_13242_13259[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13221);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13241;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13260 = state_13221;
state_13221 = G__13260;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_13221){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_13221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___13248,out))
})();
var state__11086__auto__ = (function (){var statearr_13243 = f__11085__auto__.call(null);
(statearr_13243[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___13248);

return statearr_13243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___13248,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13268 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13268 = (function (map_LT_,f,ch,meta13269){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13269 = meta13269;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13270,meta13269__$1){
var self__ = this;
var _13270__$1 = this;
return (new cljs.core.async.t_cljs$core$async13268(self__.map_LT_,self__.f,self__.ch,meta13269__$1));
});

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13270){
var self__ = this;
var _13270__$1 = this;
return self__.meta13269;
});

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async13271 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13271 = (function (map_LT_,f,ch,meta13269,_,fn1,meta13272){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13269 = meta13269;
this._ = _;
this.fn1 = fn1;
this.meta13272 = meta13272;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13271.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13273,meta13272__$1){
var self__ = this;
var _13273__$1 = this;
return (new cljs.core.async.t_cljs$core$async13271(self__.map_LT_,self__.f,self__.ch,self__.meta13269,self__._,self__.fn1,meta13272__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async13271.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13273){
var self__ = this;
var _13273__$1 = this;
return self__.meta13272;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13271.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13271.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13271.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13271.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__13261_SHARP_){
return f1.call(null,(((p1__13261_SHARP_ == null))?null:self__.f.call(null,p1__13261_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async13271.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13269","meta13269",-1178697360,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13268","cljs.core.async/t_cljs$core$async13268",764502123,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13272","meta13272",-909263456,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13271.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13271.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13271";

cljs.core.async.t_cljs$core$async13271.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13271");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async13271 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13271(map_LT___$1,f__$1,ch__$1,meta13269__$1,___$2,fn1__$1,meta13272){
return (new cljs.core.async.t_cljs$core$async13271(map_LT___$1,f__$1,ch__$1,meta13269__$1,___$2,fn1__$1,meta13272));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async13271(self__.map_LT_,self__.f,self__.ch,self__.meta13269,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async13268.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13269","meta13269",-1178697360,null)], null);
});

cljs.core.async.t_cljs$core$async13268.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13268.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13268";

cljs.core.async.t_cljs$core$async13268.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13268");
});

cljs.core.async.__GT_t_cljs$core$async13268 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13268(map_LT___$1,f__$1,ch__$1,meta13269){
return (new cljs.core.async.t_cljs$core$async13268(map_LT___$1,f__$1,ch__$1,meta13269));
});

}

return (new cljs.core.async.t_cljs$core$async13268(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13277 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13277 = (function (map_GT_,f,ch,meta13278){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta13278 = meta13278;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13277.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13279,meta13278__$1){
var self__ = this;
var _13279__$1 = this;
return (new cljs.core.async.t_cljs$core$async13277(self__.map_GT_,self__.f,self__.ch,meta13278__$1));
});

cljs.core.async.t_cljs$core$async13277.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13279){
var self__ = this;
var _13279__$1 = this;
return self__.meta13278;
});

cljs.core.async.t_cljs$core$async13277.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13277.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13277.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13277.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13277.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13277.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async13277.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13278","meta13278",638350960,null)], null);
});

cljs.core.async.t_cljs$core$async13277.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13277.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13277";

cljs.core.async.t_cljs$core$async13277.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13277");
});

cljs.core.async.__GT_t_cljs$core$async13277 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13277(map_GT___$1,f__$1,ch__$1,meta13278){
return (new cljs.core.async.t_cljs$core$async13277(map_GT___$1,f__$1,ch__$1,meta13278));
});

}

return (new cljs.core.async.t_cljs$core$async13277(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async13283 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13283 = (function (filter_GT_,p,ch,meta13284){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13284 = meta13284;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13285,meta13284__$1){
var self__ = this;
var _13285__$1 = this;
return (new cljs.core.async.t_cljs$core$async13283(self__.filter_GT_,self__.p,self__.ch,meta13284__$1));
});

cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13285){
var self__ = this;
var _13285__$1 = this;
return self__.meta13284;
});

cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13283.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async13283.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13284","meta13284",1510191412,null)], null);
});

cljs.core.async.t_cljs$core$async13283.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13283.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13283";

cljs.core.async.t_cljs$core$async13283.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13283");
});

cljs.core.async.__GT_t_cljs$core$async13283 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13283(filter_GT___$1,p__$1,ch__$1,meta13284){
return (new cljs.core.async.t_cljs$core$async13283(filter_GT___$1,p__$1,ch__$1,meta13284));
});

}

return (new cljs.core.async.t_cljs$core$async13283(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args13286 = [];
var len__5726__auto___13330 = arguments.length;
var i__5727__auto___13331 = (0);
while(true){
if((i__5727__auto___13331 < len__5726__auto___13330)){
args13286.push((arguments[i__5727__auto___13331]));

var G__13332 = (i__5727__auto___13331 + (1));
i__5727__auto___13331 = G__13332;
continue;
} else {
}
break;
}

var G__13288 = args13286.length;
switch (G__13288) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13286.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___13334 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___13334,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___13334,out){
return (function (state_13309){
var state_val_13310 = (state_13309[(1)]);
if((state_val_13310 === (7))){
var inst_13305 = (state_13309[(2)]);
var state_13309__$1 = state_13309;
var statearr_13311_13335 = state_13309__$1;
(statearr_13311_13335[(2)] = inst_13305);

(statearr_13311_13335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13310 === (1))){
var state_13309__$1 = state_13309;
var statearr_13312_13336 = state_13309__$1;
(statearr_13312_13336[(2)] = null);

(statearr_13312_13336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13310 === (4))){
var inst_13291 = (state_13309[(7)]);
var inst_13291__$1 = (state_13309[(2)]);
var inst_13292 = (inst_13291__$1 == null);
var state_13309__$1 = (function (){var statearr_13313 = state_13309;
(statearr_13313[(7)] = inst_13291__$1);

return statearr_13313;
})();
if(cljs.core.truth_(inst_13292)){
var statearr_13314_13337 = state_13309__$1;
(statearr_13314_13337[(1)] = (5));

} else {
var statearr_13315_13338 = state_13309__$1;
(statearr_13315_13338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13310 === (6))){
var inst_13291 = (state_13309[(7)]);
var inst_13296 = p.call(null,inst_13291);
var state_13309__$1 = state_13309;
if(cljs.core.truth_(inst_13296)){
var statearr_13316_13339 = state_13309__$1;
(statearr_13316_13339[(1)] = (8));

} else {
var statearr_13317_13340 = state_13309__$1;
(statearr_13317_13340[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13310 === (3))){
var inst_13307 = (state_13309[(2)]);
var state_13309__$1 = state_13309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13309__$1,inst_13307);
} else {
if((state_val_13310 === (2))){
var state_13309__$1 = state_13309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13309__$1,(4),ch);
} else {
if((state_val_13310 === (11))){
var inst_13299 = (state_13309[(2)]);
var state_13309__$1 = state_13309;
var statearr_13318_13341 = state_13309__$1;
(statearr_13318_13341[(2)] = inst_13299);

(statearr_13318_13341[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13310 === (9))){
var state_13309__$1 = state_13309;
var statearr_13319_13342 = state_13309__$1;
(statearr_13319_13342[(2)] = null);

(statearr_13319_13342[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13310 === (5))){
var inst_13294 = cljs.core.async.close_BANG_.call(null,out);
var state_13309__$1 = state_13309;
var statearr_13320_13343 = state_13309__$1;
(statearr_13320_13343[(2)] = inst_13294);

(statearr_13320_13343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13310 === (10))){
var inst_13302 = (state_13309[(2)]);
var state_13309__$1 = (function (){var statearr_13321 = state_13309;
(statearr_13321[(8)] = inst_13302);

return statearr_13321;
})();
var statearr_13322_13344 = state_13309__$1;
(statearr_13322_13344[(2)] = null);

(statearr_13322_13344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13310 === (8))){
var inst_13291 = (state_13309[(7)]);
var state_13309__$1 = state_13309;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13309__$1,(11),out,inst_13291);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___13334,out))
;
return ((function (switch__10972__auto__,c__11084__auto___13334,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_13326 = [null,null,null,null,null,null,null,null,null];
(statearr_13326[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_13326[(1)] = (1));

return statearr_13326;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_13309){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_13309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e13327){if((e13327 instanceof Object)){
var ex__10976__auto__ = e13327;
var statearr_13328_13345 = state_13309;
(statearr_13328_13345[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13309);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13327;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13346 = state_13309;
state_13309 = G__13346;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_13309){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_13309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___13334,out))
})();
var state__11086__auto__ = (function (){var statearr_13329 = f__11085__auto__.call(null);
(statearr_13329[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___13334);

return statearr_13329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___13334,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args13347 = [];
var len__5726__auto___13350 = arguments.length;
var i__5727__auto___13351 = (0);
while(true){
if((i__5727__auto___13351 < len__5726__auto___13350)){
args13347.push((arguments[i__5727__auto___13351]));

var G__13352 = (i__5727__auto___13351 + (1));
i__5727__auto___13351 = G__13352;
continue;
} else {
}
break;
}

var G__13349 = args13347.length;
switch (G__13349) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13347.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11084__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto__){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto__){
return (function (state_13519){
var state_val_13520 = (state_13519[(1)]);
if((state_val_13520 === (7))){
var inst_13515 = (state_13519[(2)]);
var state_13519__$1 = state_13519;
var statearr_13521_13562 = state_13519__$1;
(statearr_13521_13562[(2)] = inst_13515);

(statearr_13521_13562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (20))){
var inst_13485 = (state_13519[(7)]);
var inst_13496 = (state_13519[(2)]);
var inst_13497 = cljs.core.next.call(null,inst_13485);
var inst_13471 = inst_13497;
var inst_13472 = null;
var inst_13473 = (0);
var inst_13474 = (0);
var state_13519__$1 = (function (){var statearr_13522 = state_13519;
(statearr_13522[(8)] = inst_13471);

(statearr_13522[(9)] = inst_13474);

(statearr_13522[(10)] = inst_13472);

(statearr_13522[(11)] = inst_13473);

(statearr_13522[(12)] = inst_13496);

return statearr_13522;
})();
var statearr_13523_13563 = state_13519__$1;
(statearr_13523_13563[(2)] = null);

(statearr_13523_13563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (1))){
var state_13519__$1 = state_13519;
var statearr_13524_13564 = state_13519__$1;
(statearr_13524_13564[(2)] = null);

(statearr_13524_13564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (4))){
var inst_13460 = (state_13519[(13)]);
var inst_13460__$1 = (state_13519[(2)]);
var inst_13461 = (inst_13460__$1 == null);
var state_13519__$1 = (function (){var statearr_13525 = state_13519;
(statearr_13525[(13)] = inst_13460__$1);

return statearr_13525;
})();
if(cljs.core.truth_(inst_13461)){
var statearr_13526_13565 = state_13519__$1;
(statearr_13526_13565[(1)] = (5));

} else {
var statearr_13527_13566 = state_13519__$1;
(statearr_13527_13566[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (15))){
var state_13519__$1 = state_13519;
var statearr_13531_13567 = state_13519__$1;
(statearr_13531_13567[(2)] = null);

(statearr_13531_13567[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (21))){
var state_13519__$1 = state_13519;
var statearr_13532_13568 = state_13519__$1;
(statearr_13532_13568[(2)] = null);

(statearr_13532_13568[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (13))){
var inst_13471 = (state_13519[(8)]);
var inst_13474 = (state_13519[(9)]);
var inst_13472 = (state_13519[(10)]);
var inst_13473 = (state_13519[(11)]);
var inst_13481 = (state_13519[(2)]);
var inst_13482 = (inst_13474 + (1));
var tmp13528 = inst_13471;
var tmp13529 = inst_13472;
var tmp13530 = inst_13473;
var inst_13471__$1 = tmp13528;
var inst_13472__$1 = tmp13529;
var inst_13473__$1 = tmp13530;
var inst_13474__$1 = inst_13482;
var state_13519__$1 = (function (){var statearr_13533 = state_13519;
(statearr_13533[(8)] = inst_13471__$1);

(statearr_13533[(9)] = inst_13474__$1);

(statearr_13533[(10)] = inst_13472__$1);

(statearr_13533[(14)] = inst_13481);

(statearr_13533[(11)] = inst_13473__$1);

return statearr_13533;
})();
var statearr_13534_13569 = state_13519__$1;
(statearr_13534_13569[(2)] = null);

(statearr_13534_13569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (22))){
var state_13519__$1 = state_13519;
var statearr_13535_13570 = state_13519__$1;
(statearr_13535_13570[(2)] = null);

(statearr_13535_13570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (6))){
var inst_13460 = (state_13519[(13)]);
var inst_13469 = f.call(null,inst_13460);
var inst_13470 = cljs.core.seq.call(null,inst_13469);
var inst_13471 = inst_13470;
var inst_13472 = null;
var inst_13473 = (0);
var inst_13474 = (0);
var state_13519__$1 = (function (){var statearr_13536 = state_13519;
(statearr_13536[(8)] = inst_13471);

(statearr_13536[(9)] = inst_13474);

(statearr_13536[(10)] = inst_13472);

(statearr_13536[(11)] = inst_13473);

return statearr_13536;
})();
var statearr_13537_13571 = state_13519__$1;
(statearr_13537_13571[(2)] = null);

(statearr_13537_13571[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (17))){
var inst_13485 = (state_13519[(7)]);
var inst_13489 = cljs.core.chunk_first.call(null,inst_13485);
var inst_13490 = cljs.core.chunk_rest.call(null,inst_13485);
var inst_13491 = cljs.core.count.call(null,inst_13489);
var inst_13471 = inst_13490;
var inst_13472 = inst_13489;
var inst_13473 = inst_13491;
var inst_13474 = (0);
var state_13519__$1 = (function (){var statearr_13538 = state_13519;
(statearr_13538[(8)] = inst_13471);

(statearr_13538[(9)] = inst_13474);

(statearr_13538[(10)] = inst_13472);

(statearr_13538[(11)] = inst_13473);

return statearr_13538;
})();
var statearr_13539_13572 = state_13519__$1;
(statearr_13539_13572[(2)] = null);

(statearr_13539_13572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (3))){
var inst_13517 = (state_13519[(2)]);
var state_13519__$1 = state_13519;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13519__$1,inst_13517);
} else {
if((state_val_13520 === (12))){
var inst_13505 = (state_13519[(2)]);
var state_13519__$1 = state_13519;
var statearr_13540_13573 = state_13519__$1;
(statearr_13540_13573[(2)] = inst_13505);

(statearr_13540_13573[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (2))){
var state_13519__$1 = state_13519;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13519__$1,(4),in$);
} else {
if((state_val_13520 === (23))){
var inst_13513 = (state_13519[(2)]);
var state_13519__$1 = state_13519;
var statearr_13541_13574 = state_13519__$1;
(statearr_13541_13574[(2)] = inst_13513);

(statearr_13541_13574[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (19))){
var inst_13500 = (state_13519[(2)]);
var state_13519__$1 = state_13519;
var statearr_13542_13575 = state_13519__$1;
(statearr_13542_13575[(2)] = inst_13500);

(statearr_13542_13575[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (11))){
var inst_13471 = (state_13519[(8)]);
var inst_13485 = (state_13519[(7)]);
var inst_13485__$1 = cljs.core.seq.call(null,inst_13471);
var state_13519__$1 = (function (){var statearr_13543 = state_13519;
(statearr_13543[(7)] = inst_13485__$1);

return statearr_13543;
})();
if(inst_13485__$1){
var statearr_13544_13576 = state_13519__$1;
(statearr_13544_13576[(1)] = (14));

} else {
var statearr_13545_13577 = state_13519__$1;
(statearr_13545_13577[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (9))){
var inst_13507 = (state_13519[(2)]);
var inst_13508 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13519__$1 = (function (){var statearr_13546 = state_13519;
(statearr_13546[(15)] = inst_13507);

return statearr_13546;
})();
if(cljs.core.truth_(inst_13508)){
var statearr_13547_13578 = state_13519__$1;
(statearr_13547_13578[(1)] = (21));

} else {
var statearr_13548_13579 = state_13519__$1;
(statearr_13548_13579[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (5))){
var inst_13463 = cljs.core.async.close_BANG_.call(null,out);
var state_13519__$1 = state_13519;
var statearr_13549_13580 = state_13519__$1;
(statearr_13549_13580[(2)] = inst_13463);

(statearr_13549_13580[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (14))){
var inst_13485 = (state_13519[(7)]);
var inst_13487 = cljs.core.chunked_seq_QMARK_.call(null,inst_13485);
var state_13519__$1 = state_13519;
if(inst_13487){
var statearr_13550_13581 = state_13519__$1;
(statearr_13550_13581[(1)] = (17));

} else {
var statearr_13551_13582 = state_13519__$1;
(statearr_13551_13582[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (16))){
var inst_13503 = (state_13519[(2)]);
var state_13519__$1 = state_13519;
var statearr_13552_13583 = state_13519__$1;
(statearr_13552_13583[(2)] = inst_13503);

(statearr_13552_13583[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13520 === (10))){
var inst_13474 = (state_13519[(9)]);
var inst_13472 = (state_13519[(10)]);
var inst_13479 = cljs.core._nth.call(null,inst_13472,inst_13474);
var state_13519__$1 = state_13519;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13519__$1,(13),out,inst_13479);
} else {
if((state_val_13520 === (18))){
var inst_13485 = (state_13519[(7)]);
var inst_13494 = cljs.core.first.call(null,inst_13485);
var state_13519__$1 = state_13519;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13519__$1,(20),out,inst_13494);
} else {
if((state_val_13520 === (8))){
var inst_13474 = (state_13519[(9)]);
var inst_13473 = (state_13519[(11)]);
var inst_13476 = (inst_13474 < inst_13473);
var inst_13477 = inst_13476;
var state_13519__$1 = state_13519;
if(cljs.core.truth_(inst_13477)){
var statearr_13553_13584 = state_13519__$1;
(statearr_13553_13584[(1)] = (10));

} else {
var statearr_13554_13585 = state_13519__$1;
(statearr_13554_13585[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto__))
;
return ((function (switch__10972__auto__,c__11084__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____0 = (function (){
var statearr_13558 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13558[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__);

(statearr_13558[(1)] = (1));

return statearr_13558;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____1 = (function (state_13519){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_13519);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e13559){if((e13559 instanceof Object)){
var ex__10976__auto__ = e13559;
var statearr_13560_13586 = state_13519;
(statearr_13560_13586[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13519);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13559;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13587 = state_13519;
state_13519 = G__13587;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__ = function(state_13519){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____1.call(this,state_13519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10973__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto__))
})();
var state__11086__auto__ = (function (){var statearr_13561 = f__11085__auto__.call(null);
(statearr_13561[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto__);

return statearr_13561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto__))
);

return c__11084__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13588 = [];
var len__5726__auto___13591 = arguments.length;
var i__5727__auto___13592 = (0);
while(true){
if((i__5727__auto___13592 < len__5726__auto___13591)){
args13588.push((arguments[i__5727__auto___13592]));

var G__13593 = (i__5727__auto___13592 + (1));
i__5727__auto___13592 = G__13593;
continue;
} else {
}
break;
}

var G__13590 = args13588.length;
switch (G__13590) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13588.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13595 = [];
var len__5726__auto___13598 = arguments.length;
var i__5727__auto___13599 = (0);
while(true){
if((i__5727__auto___13599 < len__5726__auto___13598)){
args13595.push((arguments[i__5727__auto___13599]));

var G__13600 = (i__5727__auto___13599 + (1));
i__5727__auto___13599 = G__13600;
continue;
} else {
}
break;
}

var G__13597 = args13595.length;
switch (G__13597) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13595.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13602 = [];
var len__5726__auto___13653 = arguments.length;
var i__5727__auto___13654 = (0);
while(true){
if((i__5727__auto___13654 < len__5726__auto___13653)){
args13602.push((arguments[i__5727__auto___13654]));

var G__13655 = (i__5727__auto___13654 + (1));
i__5727__auto___13654 = G__13655;
continue;
} else {
}
break;
}

var G__13604 = args13602.length;
switch (G__13604) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13602.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___13657 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___13657,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___13657,out){
return (function (state_13628){
var state_val_13629 = (state_13628[(1)]);
if((state_val_13629 === (7))){
var inst_13623 = (state_13628[(2)]);
var state_13628__$1 = state_13628;
var statearr_13630_13658 = state_13628__$1;
(statearr_13630_13658[(2)] = inst_13623);

(statearr_13630_13658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13629 === (1))){
var inst_13605 = null;
var state_13628__$1 = (function (){var statearr_13631 = state_13628;
(statearr_13631[(7)] = inst_13605);

return statearr_13631;
})();
var statearr_13632_13659 = state_13628__$1;
(statearr_13632_13659[(2)] = null);

(statearr_13632_13659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13629 === (4))){
var inst_13608 = (state_13628[(8)]);
var inst_13608__$1 = (state_13628[(2)]);
var inst_13609 = (inst_13608__$1 == null);
var inst_13610 = cljs.core.not.call(null,inst_13609);
var state_13628__$1 = (function (){var statearr_13633 = state_13628;
(statearr_13633[(8)] = inst_13608__$1);

return statearr_13633;
})();
if(inst_13610){
var statearr_13634_13660 = state_13628__$1;
(statearr_13634_13660[(1)] = (5));

} else {
var statearr_13635_13661 = state_13628__$1;
(statearr_13635_13661[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13629 === (6))){
var state_13628__$1 = state_13628;
var statearr_13636_13662 = state_13628__$1;
(statearr_13636_13662[(2)] = null);

(statearr_13636_13662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13629 === (3))){
var inst_13625 = (state_13628[(2)]);
var inst_13626 = cljs.core.async.close_BANG_.call(null,out);
var state_13628__$1 = (function (){var statearr_13637 = state_13628;
(statearr_13637[(9)] = inst_13625);

return statearr_13637;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13628__$1,inst_13626);
} else {
if((state_val_13629 === (2))){
var state_13628__$1 = state_13628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13628__$1,(4),ch);
} else {
if((state_val_13629 === (11))){
var inst_13608 = (state_13628[(8)]);
var inst_13617 = (state_13628[(2)]);
var inst_13605 = inst_13608;
var state_13628__$1 = (function (){var statearr_13638 = state_13628;
(statearr_13638[(10)] = inst_13617);

(statearr_13638[(7)] = inst_13605);

return statearr_13638;
})();
var statearr_13639_13663 = state_13628__$1;
(statearr_13639_13663[(2)] = null);

(statearr_13639_13663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13629 === (9))){
var inst_13608 = (state_13628[(8)]);
var state_13628__$1 = state_13628;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13628__$1,(11),out,inst_13608);
} else {
if((state_val_13629 === (5))){
var inst_13605 = (state_13628[(7)]);
var inst_13608 = (state_13628[(8)]);
var inst_13612 = cljs.core._EQ_.call(null,inst_13608,inst_13605);
var state_13628__$1 = state_13628;
if(inst_13612){
var statearr_13641_13664 = state_13628__$1;
(statearr_13641_13664[(1)] = (8));

} else {
var statearr_13642_13665 = state_13628__$1;
(statearr_13642_13665[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13629 === (10))){
var inst_13620 = (state_13628[(2)]);
var state_13628__$1 = state_13628;
var statearr_13643_13666 = state_13628__$1;
(statearr_13643_13666[(2)] = inst_13620);

(statearr_13643_13666[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13629 === (8))){
var inst_13605 = (state_13628[(7)]);
var tmp13640 = inst_13605;
var inst_13605__$1 = tmp13640;
var state_13628__$1 = (function (){var statearr_13644 = state_13628;
(statearr_13644[(7)] = inst_13605__$1);

return statearr_13644;
})();
var statearr_13645_13667 = state_13628__$1;
(statearr_13645_13667[(2)] = null);

(statearr_13645_13667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___13657,out))
;
return ((function (switch__10972__auto__,c__11084__auto___13657,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_13649 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13649[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_13649[(1)] = (1));

return statearr_13649;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_13628){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_13628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e13650){if((e13650 instanceof Object)){
var ex__10976__auto__ = e13650;
var statearr_13651_13668 = state_13628;
(statearr_13651_13668[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13628);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13650;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13669 = state_13628;
state_13628 = G__13669;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_13628){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_13628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___13657,out))
})();
var state__11086__auto__ = (function (){var statearr_13652 = f__11085__auto__.call(null);
(statearr_13652[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___13657);

return statearr_13652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___13657,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13670 = [];
var len__5726__auto___13740 = arguments.length;
var i__5727__auto___13741 = (0);
while(true){
if((i__5727__auto___13741 < len__5726__auto___13740)){
args13670.push((arguments[i__5727__auto___13741]));

var G__13742 = (i__5727__auto___13741 + (1));
i__5727__auto___13741 = G__13742;
continue;
} else {
}
break;
}

var G__13672 = args13670.length;
switch (G__13672) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13670.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___13744 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___13744,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___13744,out){
return (function (state_13710){
var state_val_13711 = (state_13710[(1)]);
if((state_val_13711 === (7))){
var inst_13706 = (state_13710[(2)]);
var state_13710__$1 = state_13710;
var statearr_13712_13745 = state_13710__$1;
(statearr_13712_13745[(2)] = inst_13706);

(statearr_13712_13745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (1))){
var inst_13673 = (new Array(n));
var inst_13674 = inst_13673;
var inst_13675 = (0);
var state_13710__$1 = (function (){var statearr_13713 = state_13710;
(statearr_13713[(7)] = inst_13674);

(statearr_13713[(8)] = inst_13675);

return statearr_13713;
})();
var statearr_13714_13746 = state_13710__$1;
(statearr_13714_13746[(2)] = null);

(statearr_13714_13746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (4))){
var inst_13678 = (state_13710[(9)]);
var inst_13678__$1 = (state_13710[(2)]);
var inst_13679 = (inst_13678__$1 == null);
var inst_13680 = cljs.core.not.call(null,inst_13679);
var state_13710__$1 = (function (){var statearr_13715 = state_13710;
(statearr_13715[(9)] = inst_13678__$1);

return statearr_13715;
})();
if(inst_13680){
var statearr_13716_13747 = state_13710__$1;
(statearr_13716_13747[(1)] = (5));

} else {
var statearr_13717_13748 = state_13710__$1;
(statearr_13717_13748[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (15))){
var inst_13700 = (state_13710[(2)]);
var state_13710__$1 = state_13710;
var statearr_13718_13749 = state_13710__$1;
(statearr_13718_13749[(2)] = inst_13700);

(statearr_13718_13749[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (13))){
var state_13710__$1 = state_13710;
var statearr_13719_13750 = state_13710__$1;
(statearr_13719_13750[(2)] = null);

(statearr_13719_13750[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (6))){
var inst_13675 = (state_13710[(8)]);
var inst_13696 = (inst_13675 > (0));
var state_13710__$1 = state_13710;
if(cljs.core.truth_(inst_13696)){
var statearr_13720_13751 = state_13710__$1;
(statearr_13720_13751[(1)] = (12));

} else {
var statearr_13721_13752 = state_13710__$1;
(statearr_13721_13752[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (3))){
var inst_13708 = (state_13710[(2)]);
var state_13710__$1 = state_13710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13710__$1,inst_13708);
} else {
if((state_val_13711 === (12))){
var inst_13674 = (state_13710[(7)]);
var inst_13698 = cljs.core.vec.call(null,inst_13674);
var state_13710__$1 = state_13710;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13710__$1,(15),out,inst_13698);
} else {
if((state_val_13711 === (2))){
var state_13710__$1 = state_13710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13710__$1,(4),ch);
} else {
if((state_val_13711 === (11))){
var inst_13690 = (state_13710[(2)]);
var inst_13691 = (new Array(n));
var inst_13674 = inst_13691;
var inst_13675 = (0);
var state_13710__$1 = (function (){var statearr_13722 = state_13710;
(statearr_13722[(7)] = inst_13674);

(statearr_13722[(10)] = inst_13690);

(statearr_13722[(8)] = inst_13675);

return statearr_13722;
})();
var statearr_13723_13753 = state_13710__$1;
(statearr_13723_13753[(2)] = null);

(statearr_13723_13753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (9))){
var inst_13674 = (state_13710[(7)]);
var inst_13688 = cljs.core.vec.call(null,inst_13674);
var state_13710__$1 = state_13710;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13710__$1,(11),out,inst_13688);
} else {
if((state_val_13711 === (5))){
var inst_13674 = (state_13710[(7)]);
var inst_13678 = (state_13710[(9)]);
var inst_13683 = (state_13710[(11)]);
var inst_13675 = (state_13710[(8)]);
var inst_13682 = (inst_13674[inst_13675] = inst_13678);
var inst_13683__$1 = (inst_13675 + (1));
var inst_13684 = (inst_13683__$1 < n);
var state_13710__$1 = (function (){var statearr_13724 = state_13710;
(statearr_13724[(11)] = inst_13683__$1);

(statearr_13724[(12)] = inst_13682);

return statearr_13724;
})();
if(cljs.core.truth_(inst_13684)){
var statearr_13725_13754 = state_13710__$1;
(statearr_13725_13754[(1)] = (8));

} else {
var statearr_13726_13755 = state_13710__$1;
(statearr_13726_13755[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (14))){
var inst_13703 = (state_13710[(2)]);
var inst_13704 = cljs.core.async.close_BANG_.call(null,out);
var state_13710__$1 = (function (){var statearr_13728 = state_13710;
(statearr_13728[(13)] = inst_13703);

return statearr_13728;
})();
var statearr_13729_13756 = state_13710__$1;
(statearr_13729_13756[(2)] = inst_13704);

(statearr_13729_13756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (10))){
var inst_13694 = (state_13710[(2)]);
var state_13710__$1 = state_13710;
var statearr_13730_13757 = state_13710__$1;
(statearr_13730_13757[(2)] = inst_13694);

(statearr_13730_13757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13711 === (8))){
var inst_13674 = (state_13710[(7)]);
var inst_13683 = (state_13710[(11)]);
var tmp13727 = inst_13674;
var inst_13674__$1 = tmp13727;
var inst_13675 = inst_13683;
var state_13710__$1 = (function (){var statearr_13731 = state_13710;
(statearr_13731[(7)] = inst_13674__$1);

(statearr_13731[(8)] = inst_13675);

return statearr_13731;
})();
var statearr_13732_13758 = state_13710__$1;
(statearr_13732_13758[(2)] = null);

(statearr_13732_13758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___13744,out))
;
return ((function (switch__10972__auto__,c__11084__auto___13744,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_13736 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13736[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_13736[(1)] = (1));

return statearr_13736;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_13710){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_13710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e13737){if((e13737 instanceof Object)){
var ex__10976__auto__ = e13737;
var statearr_13738_13759 = state_13710;
(statearr_13738_13759[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13710);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13760 = state_13710;
state_13710 = G__13760;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_13710){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_13710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___13744,out))
})();
var state__11086__auto__ = (function (){var statearr_13739 = f__11085__auto__.call(null);
(statearr_13739[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___13744);

return statearr_13739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___13744,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13761 = [];
var len__5726__auto___13835 = arguments.length;
var i__5727__auto___13836 = (0);
while(true){
if((i__5727__auto___13836 < len__5726__auto___13835)){
args13761.push((arguments[i__5727__auto___13836]));

var G__13837 = (i__5727__auto___13836 + (1));
i__5727__auto___13836 = G__13837;
continue;
} else {
}
break;
}

var G__13763 = args13761.length;
switch (G__13763) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13761.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11084__auto___13839 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11084__auto___13839,out){
return (function (){
var f__11085__auto__ = (function (){var switch__10972__auto__ = ((function (c__11084__auto___13839,out){
return (function (state_13805){
var state_val_13806 = (state_13805[(1)]);
if((state_val_13806 === (7))){
var inst_13801 = (state_13805[(2)]);
var state_13805__$1 = state_13805;
var statearr_13807_13840 = state_13805__$1;
(statearr_13807_13840[(2)] = inst_13801);

(statearr_13807_13840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (1))){
var inst_13764 = [];
var inst_13765 = inst_13764;
var inst_13766 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13805__$1 = (function (){var statearr_13808 = state_13805;
(statearr_13808[(7)] = inst_13765);

(statearr_13808[(8)] = inst_13766);

return statearr_13808;
})();
var statearr_13809_13841 = state_13805__$1;
(statearr_13809_13841[(2)] = null);

(statearr_13809_13841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (4))){
var inst_13769 = (state_13805[(9)]);
var inst_13769__$1 = (state_13805[(2)]);
var inst_13770 = (inst_13769__$1 == null);
var inst_13771 = cljs.core.not.call(null,inst_13770);
var state_13805__$1 = (function (){var statearr_13810 = state_13805;
(statearr_13810[(9)] = inst_13769__$1);

return statearr_13810;
})();
if(inst_13771){
var statearr_13811_13842 = state_13805__$1;
(statearr_13811_13842[(1)] = (5));

} else {
var statearr_13812_13843 = state_13805__$1;
(statearr_13812_13843[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (15))){
var inst_13795 = (state_13805[(2)]);
var state_13805__$1 = state_13805;
var statearr_13813_13844 = state_13805__$1;
(statearr_13813_13844[(2)] = inst_13795);

(statearr_13813_13844[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (13))){
var state_13805__$1 = state_13805;
var statearr_13814_13845 = state_13805__$1;
(statearr_13814_13845[(2)] = null);

(statearr_13814_13845[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (6))){
var inst_13765 = (state_13805[(7)]);
var inst_13790 = inst_13765.length;
var inst_13791 = (inst_13790 > (0));
var state_13805__$1 = state_13805;
if(cljs.core.truth_(inst_13791)){
var statearr_13815_13846 = state_13805__$1;
(statearr_13815_13846[(1)] = (12));

} else {
var statearr_13816_13847 = state_13805__$1;
(statearr_13816_13847[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (3))){
var inst_13803 = (state_13805[(2)]);
var state_13805__$1 = state_13805;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13805__$1,inst_13803);
} else {
if((state_val_13806 === (12))){
var inst_13765 = (state_13805[(7)]);
var inst_13793 = cljs.core.vec.call(null,inst_13765);
var state_13805__$1 = state_13805;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13805__$1,(15),out,inst_13793);
} else {
if((state_val_13806 === (2))){
var state_13805__$1 = state_13805;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13805__$1,(4),ch);
} else {
if((state_val_13806 === (11))){
var inst_13773 = (state_13805[(10)]);
var inst_13769 = (state_13805[(9)]);
var inst_13783 = (state_13805[(2)]);
var inst_13784 = [];
var inst_13785 = inst_13784.push(inst_13769);
var inst_13765 = inst_13784;
var inst_13766 = inst_13773;
var state_13805__$1 = (function (){var statearr_13817 = state_13805;
(statearr_13817[(7)] = inst_13765);

(statearr_13817[(11)] = inst_13785);

(statearr_13817[(12)] = inst_13783);

(statearr_13817[(8)] = inst_13766);

return statearr_13817;
})();
var statearr_13818_13848 = state_13805__$1;
(statearr_13818_13848[(2)] = null);

(statearr_13818_13848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (9))){
var inst_13765 = (state_13805[(7)]);
var inst_13781 = cljs.core.vec.call(null,inst_13765);
var state_13805__$1 = state_13805;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13805__$1,(11),out,inst_13781);
} else {
if((state_val_13806 === (5))){
var inst_13773 = (state_13805[(10)]);
var inst_13769 = (state_13805[(9)]);
var inst_13766 = (state_13805[(8)]);
var inst_13773__$1 = f.call(null,inst_13769);
var inst_13774 = cljs.core._EQ_.call(null,inst_13773__$1,inst_13766);
var inst_13775 = cljs.core.keyword_identical_QMARK_.call(null,inst_13766,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13776 = (inst_13774) || (inst_13775);
var state_13805__$1 = (function (){var statearr_13819 = state_13805;
(statearr_13819[(10)] = inst_13773__$1);

return statearr_13819;
})();
if(cljs.core.truth_(inst_13776)){
var statearr_13820_13849 = state_13805__$1;
(statearr_13820_13849[(1)] = (8));

} else {
var statearr_13821_13850 = state_13805__$1;
(statearr_13821_13850[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (14))){
var inst_13798 = (state_13805[(2)]);
var inst_13799 = cljs.core.async.close_BANG_.call(null,out);
var state_13805__$1 = (function (){var statearr_13823 = state_13805;
(statearr_13823[(13)] = inst_13798);

return statearr_13823;
})();
var statearr_13824_13851 = state_13805__$1;
(statearr_13824_13851[(2)] = inst_13799);

(statearr_13824_13851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (10))){
var inst_13788 = (state_13805[(2)]);
var state_13805__$1 = state_13805;
var statearr_13825_13852 = state_13805__$1;
(statearr_13825_13852[(2)] = inst_13788);

(statearr_13825_13852[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13806 === (8))){
var inst_13773 = (state_13805[(10)]);
var inst_13765 = (state_13805[(7)]);
var inst_13769 = (state_13805[(9)]);
var inst_13778 = inst_13765.push(inst_13769);
var tmp13822 = inst_13765;
var inst_13765__$1 = tmp13822;
var inst_13766 = inst_13773;
var state_13805__$1 = (function (){var statearr_13826 = state_13805;
(statearr_13826[(7)] = inst_13765__$1);

(statearr_13826[(14)] = inst_13778);

(statearr_13826[(8)] = inst_13766);

return statearr_13826;
})();
var statearr_13827_13853 = state_13805__$1;
(statearr_13827_13853[(2)] = null);

(statearr_13827_13853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11084__auto___13839,out))
;
return ((function (switch__10972__auto__,c__11084__auto___13839,out){
return (function() {
var cljs$core$async$state_machine__10973__auto__ = null;
var cljs$core$async$state_machine__10973__auto____0 = (function (){
var statearr_13831 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13831[(0)] = cljs$core$async$state_machine__10973__auto__);

(statearr_13831[(1)] = (1));

return statearr_13831;
});
var cljs$core$async$state_machine__10973__auto____1 = (function (state_13805){
while(true){
var ret_value__10974__auto__ = (function (){try{while(true){
var result__10975__auto__ = switch__10972__auto__.call(null,state_13805);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10975__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10975__auto__;
}
break;
}
}catch (e13832){if((e13832 instanceof Object)){
var ex__10976__auto__ = e13832;
var statearr_13833_13854 = state_13805;
(statearr_13833_13854[(5)] = ex__10976__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13805);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13832;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10974__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13855 = state_13805;
state_13805 = G__13855;
continue;
} else {
return ret_value__10974__auto__;
}
break;
}
});
cljs$core$async$state_machine__10973__auto__ = function(state_13805){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10973__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10973__auto____1.call(this,state_13805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10973__auto____0;
cljs$core$async$state_machine__10973__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10973__auto____1;
return cljs$core$async$state_machine__10973__auto__;
})()
;})(switch__10972__auto__,c__11084__auto___13839,out))
})();
var state__11086__auto__ = (function (){var statearr_13834 = f__11085__auto__.call(null);
(statearr_13834[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11084__auto___13839);

return statearr_13834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11086__auto__);
});})(c__11084__auto___13839,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1465203436429