// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__20169__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__20168 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__20168,(0),null);
var body = cljs.core.nthnext.call(null,vec__20168,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__20169 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__20170__i = 0, G__20170__a = new Array(arguments.length -  0);
while (G__20170__i < G__20170__a.length) {G__20170__a[G__20170__i] = arguments[G__20170__i + 0]; ++G__20170__i;}
  args = new cljs.core.IndexedSeq(G__20170__a,0);
} 
return G__20169__delegate.call(this,args);};
G__20169.cljs$lang$maxFixedArity = 0;
G__20169.cljs$lang$applyTo = (function (arglist__20171){
var args = cljs.core.seq(arglist__20171);
return G__20169__delegate(args);
});
G__20169.cljs$core$IFn$_invoke$arity$variadic = G__20169__delegate;
return G__20169;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__20176(s__20177){
return (new cljs.core.LazySeq(null,(function (){
var s__20177__$1 = s__20177;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20177__$1);
if(temp__4425__auto__){
var s__20177__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20177__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20177__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20179 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20178 = (0);
while(true){
if((i__20178 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__20178);
cljs.core.chunk_append.call(null,b__20179,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__20180 = (i__20178 + (1));
i__20178 = G__20180;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20179),sablono$core$update_arglists_$_iter__20176.call(null,cljs.core.chunk_rest.call(null,s__20177__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20179),null);
}
} else {
var args = cljs.core.first.call(null,s__20177__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__20176.call(null,cljs.core.rest.call(null,s__20177__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20186 = arguments.length;
var i__5727__auto___20187 = (0);
while(true){
if((i__5727__auto___20187 < len__5726__auto___20186)){
args__5733__auto__.push((arguments[i__5727__auto___20187]));

var G__20188 = (i__5727__auto___20187 + (1));
i__5727__auto___20187 = G__20188;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__20182(s__20183){
return (new cljs.core.LazySeq(null,(function (){
var s__20183__$1 = s__20183;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20183__$1);
if(temp__4425__auto__){
var s__20183__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20183__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20183__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20185 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20184 = (0);
while(true){
if((i__20184 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__20184);
cljs.core.chunk_append.call(null,b__20185,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__20189 = (i__20184 + (1));
i__20184 = G__20189;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20185),sablono$core$iter__20182.call(null,cljs.core.chunk_rest.call(null,s__20183__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20185),null);
}
} else {
var style = cljs.core.first.call(null,s__20183__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__20182.call(null,cljs.core.rest.call(null,s__20183__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq20181){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20181));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to20190 = (function sablono$core$link_to20190(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20193 = arguments.length;
var i__5727__auto___20194 = (0);
while(true){
if((i__5727__auto___20194 < len__5726__auto___20193)){
args__5733__auto__.push((arguments[i__5727__auto___20194]));

var G__20195 = (i__5727__auto___20194 + (1));
i__5727__auto___20194 = G__20195;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to20190.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to20190.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to20190.cljs$lang$maxFixedArity = (1);

sablono.core.link_to20190.cljs$lang$applyTo = (function (seq20191){
var G__20192 = cljs.core.first.call(null,seq20191);
var seq20191__$1 = cljs.core.next.call(null,seq20191);
return sablono.core.link_to20190.cljs$core$IFn$_invoke$arity$variadic(G__20192,seq20191__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to20190);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to20196 = (function sablono$core$mail_to20196(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20201 = arguments.length;
var i__5727__auto___20202 = (0);
while(true){
if((i__5727__auto___20202 < len__5726__auto___20201)){
args__5733__auto__.push((arguments[i__5727__auto___20202]));

var G__20203 = (i__5727__auto___20202 + (1));
i__5727__auto___20202 = G__20203;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to20196.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to20196.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__20199){
var vec__20200 = p__20199;
var content = cljs.core.nth.call(null,vec__20200,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to20196.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to20196.cljs$lang$applyTo = (function (seq20197){
var G__20198 = cljs.core.first.call(null,seq20197);
var seq20197__$1 = cljs.core.next.call(null,seq20197);
return sablono.core.mail_to20196.cljs$core$IFn$_invoke$arity$variadic(G__20198,seq20197__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to20196);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list20204 = (function sablono$core$unordered_list20204(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list20204_$_iter__20209(s__20210){
return (new cljs.core.LazySeq(null,(function (){
var s__20210__$1 = s__20210;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20210__$1);
if(temp__4425__auto__){
var s__20210__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20210__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20210__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20212 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20211 = (0);
while(true){
if((i__20211 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20211);
cljs.core.chunk_append.call(null,b__20212,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20213 = (i__20211 + (1));
i__20211 = G__20213;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20212),sablono$core$unordered_list20204_$_iter__20209.call(null,cljs.core.chunk_rest.call(null,s__20210__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20212),null);
}
} else {
var x = cljs.core.first.call(null,s__20210__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list20204_$_iter__20209.call(null,cljs.core.rest.call(null,s__20210__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list20204);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list20214 = (function sablono$core$ordered_list20214(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list20214_$_iter__20219(s__20220){
return (new cljs.core.LazySeq(null,(function (){
var s__20220__$1 = s__20220;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20220__$1);
if(temp__4425__auto__){
var s__20220__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20220__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20220__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20222 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20221 = (0);
while(true){
if((i__20221 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20221);
cljs.core.chunk_append.call(null,b__20222,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20223 = (i__20221 + (1));
i__20221 = G__20223;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20222),sablono$core$ordered_list20214_$_iter__20219.call(null,cljs.core.chunk_rest.call(null,s__20220__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20222),null);
}
} else {
var x = cljs.core.first.call(null,s__20220__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list20214_$_iter__20219.call(null,cljs.core.rest.call(null,s__20220__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list20214);
/**
 * Create an image element.
 */
sablono.core.image20224 = (function sablono$core$image20224(var_args){
var args20225 = [];
var len__5726__auto___20228 = arguments.length;
var i__5727__auto___20229 = (0);
while(true){
if((i__5727__auto___20229 < len__5726__auto___20228)){
args20225.push((arguments[i__5727__auto___20229]));

var G__20230 = (i__5727__auto___20229 + (1));
i__5727__auto___20229 = G__20230;
continue;
} else {
}
break;
}

var G__20227 = args20225.length;
switch (G__20227) {
case 1:
return sablono.core.image20224.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image20224.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20225.length)].join('')));

}
});

sablono.core.image20224.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image20224.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image20224.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image20224);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__20232_SHARP_,p2__20233_SHARP_){
return [cljs.core.str(p1__20232_SHARP_),cljs.core.str("["),cljs.core.str(p2__20233_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__20234_SHARP_,p2__20235_SHARP_){
return [cljs.core.str(p1__20234_SHARP_),cljs.core.str("-"),cljs.core.str(p2__20235_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field20236 = (function sablono$core$color_field20236(var_args){
var args20237 = [];
var len__5726__auto___20304 = arguments.length;
var i__5727__auto___20305 = (0);
while(true){
if((i__5727__auto___20305 < len__5726__auto___20304)){
args20237.push((arguments[i__5727__auto___20305]));

var G__20306 = (i__5727__auto___20305 + (1));
i__5727__auto___20305 = G__20306;
continue;
} else {
}
break;
}

var G__20239 = args20237.length;
switch (G__20239) {
case 1:
return sablono.core.color_field20236.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field20236.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20237.length)].join('')));

}
});

sablono.core.color_field20236.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.color_field20236.call(null,name__11649__auto__,null);
});

sablono.core.color_field20236.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.color_field20236.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field20236);

/**
 * Creates a date input field.
 */
sablono.core.date_field20240 = (function sablono$core$date_field20240(var_args){
var args20241 = [];
var len__5726__auto___20308 = arguments.length;
var i__5727__auto___20309 = (0);
while(true){
if((i__5727__auto___20309 < len__5726__auto___20308)){
args20241.push((arguments[i__5727__auto___20309]));

var G__20310 = (i__5727__auto___20309 + (1));
i__5727__auto___20309 = G__20310;
continue;
} else {
}
break;
}

var G__20243 = args20241.length;
switch (G__20243) {
case 1:
return sablono.core.date_field20240.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field20240.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20241.length)].join('')));

}
});

sablono.core.date_field20240.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.date_field20240.call(null,name__11649__auto__,null);
});

sablono.core.date_field20240.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.date_field20240.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field20240);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field20244 = (function sablono$core$datetime_field20244(var_args){
var args20245 = [];
var len__5726__auto___20312 = arguments.length;
var i__5727__auto___20313 = (0);
while(true){
if((i__5727__auto___20313 < len__5726__auto___20312)){
args20245.push((arguments[i__5727__auto___20313]));

var G__20314 = (i__5727__auto___20313 + (1));
i__5727__auto___20313 = G__20314;
continue;
} else {
}
break;
}

var G__20247 = args20245.length;
switch (G__20247) {
case 1:
return sablono.core.datetime_field20244.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field20244.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20245.length)].join('')));

}
});

sablono.core.datetime_field20244.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_field20244.call(null,name__11649__auto__,null);
});

sablono.core.datetime_field20244.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_field20244.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field20244);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field20248 = (function sablono$core$datetime_local_field20248(var_args){
var args20249 = [];
var len__5726__auto___20316 = arguments.length;
var i__5727__auto___20317 = (0);
while(true){
if((i__5727__auto___20317 < len__5726__auto___20316)){
args20249.push((arguments[i__5727__auto___20317]));

var G__20318 = (i__5727__auto___20317 + (1));
i__5727__auto___20317 = G__20318;
continue;
} else {
}
break;
}

var G__20251 = args20249.length;
switch (G__20251) {
case 1:
return sablono.core.datetime_local_field20248.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field20248.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20249.length)].join('')));

}
});

sablono.core.datetime_local_field20248.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_local_field20248.call(null,name__11649__auto__,null);
});

sablono.core.datetime_local_field20248.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_local_field20248.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field20248);

/**
 * Creates a email input field.
 */
sablono.core.email_field20252 = (function sablono$core$email_field20252(var_args){
var args20253 = [];
var len__5726__auto___20320 = arguments.length;
var i__5727__auto___20321 = (0);
while(true){
if((i__5727__auto___20321 < len__5726__auto___20320)){
args20253.push((arguments[i__5727__auto___20321]));

var G__20322 = (i__5727__auto___20321 + (1));
i__5727__auto___20321 = G__20322;
continue;
} else {
}
break;
}

var G__20255 = args20253.length;
switch (G__20255) {
case 1:
return sablono.core.email_field20252.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field20252.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20253.length)].join('')));

}
});

sablono.core.email_field20252.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.email_field20252.call(null,name__11649__auto__,null);
});

sablono.core.email_field20252.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.email_field20252.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field20252);

/**
 * Creates a file input field.
 */
sablono.core.file_field20256 = (function sablono$core$file_field20256(var_args){
var args20257 = [];
var len__5726__auto___20324 = arguments.length;
var i__5727__auto___20325 = (0);
while(true){
if((i__5727__auto___20325 < len__5726__auto___20324)){
args20257.push((arguments[i__5727__auto___20325]));

var G__20326 = (i__5727__auto___20325 + (1));
i__5727__auto___20325 = G__20326;
continue;
} else {
}
break;
}

var G__20259 = args20257.length;
switch (G__20259) {
case 1:
return sablono.core.file_field20256.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field20256.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20257.length)].join('')));

}
});

sablono.core.file_field20256.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.file_field20256.call(null,name__11649__auto__,null);
});

sablono.core.file_field20256.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.file_field20256.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field20256);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field20260 = (function sablono$core$hidden_field20260(var_args){
var args20261 = [];
var len__5726__auto___20328 = arguments.length;
var i__5727__auto___20329 = (0);
while(true){
if((i__5727__auto___20329 < len__5726__auto___20328)){
args20261.push((arguments[i__5727__auto___20329]));

var G__20330 = (i__5727__auto___20329 + (1));
i__5727__auto___20329 = G__20330;
continue;
} else {
}
break;
}

var G__20263 = args20261.length;
switch (G__20263) {
case 1:
return sablono.core.hidden_field20260.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field20260.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20261.length)].join('')));

}
});

sablono.core.hidden_field20260.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.hidden_field20260.call(null,name__11649__auto__,null);
});

sablono.core.hidden_field20260.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.hidden_field20260.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field20260);

/**
 * Creates a month input field.
 */
sablono.core.month_field20264 = (function sablono$core$month_field20264(var_args){
var args20265 = [];
var len__5726__auto___20332 = arguments.length;
var i__5727__auto___20333 = (0);
while(true){
if((i__5727__auto___20333 < len__5726__auto___20332)){
args20265.push((arguments[i__5727__auto___20333]));

var G__20334 = (i__5727__auto___20333 + (1));
i__5727__auto___20333 = G__20334;
continue;
} else {
}
break;
}

var G__20267 = args20265.length;
switch (G__20267) {
case 1:
return sablono.core.month_field20264.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field20264.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20265.length)].join('')));

}
});

sablono.core.month_field20264.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.month_field20264.call(null,name__11649__auto__,null);
});

sablono.core.month_field20264.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.month_field20264.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field20264);

/**
 * Creates a number input field.
 */
sablono.core.number_field20268 = (function sablono$core$number_field20268(var_args){
var args20269 = [];
var len__5726__auto___20336 = arguments.length;
var i__5727__auto___20337 = (0);
while(true){
if((i__5727__auto___20337 < len__5726__auto___20336)){
args20269.push((arguments[i__5727__auto___20337]));

var G__20338 = (i__5727__auto___20337 + (1));
i__5727__auto___20337 = G__20338;
continue;
} else {
}
break;
}

var G__20271 = args20269.length;
switch (G__20271) {
case 1:
return sablono.core.number_field20268.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field20268.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20269.length)].join('')));

}
});

sablono.core.number_field20268.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.number_field20268.call(null,name__11649__auto__,null);
});

sablono.core.number_field20268.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.number_field20268.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field20268);

/**
 * Creates a password input field.
 */
sablono.core.password_field20272 = (function sablono$core$password_field20272(var_args){
var args20273 = [];
var len__5726__auto___20340 = arguments.length;
var i__5727__auto___20341 = (0);
while(true){
if((i__5727__auto___20341 < len__5726__auto___20340)){
args20273.push((arguments[i__5727__auto___20341]));

var G__20342 = (i__5727__auto___20341 + (1));
i__5727__auto___20341 = G__20342;
continue;
} else {
}
break;
}

var G__20275 = args20273.length;
switch (G__20275) {
case 1:
return sablono.core.password_field20272.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field20272.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20273.length)].join('')));

}
});

sablono.core.password_field20272.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.password_field20272.call(null,name__11649__auto__,null);
});

sablono.core.password_field20272.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.password_field20272.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field20272);

/**
 * Creates a range input field.
 */
sablono.core.range_field20276 = (function sablono$core$range_field20276(var_args){
var args20277 = [];
var len__5726__auto___20344 = arguments.length;
var i__5727__auto___20345 = (0);
while(true){
if((i__5727__auto___20345 < len__5726__auto___20344)){
args20277.push((arguments[i__5727__auto___20345]));

var G__20346 = (i__5727__auto___20345 + (1));
i__5727__auto___20345 = G__20346;
continue;
} else {
}
break;
}

var G__20279 = args20277.length;
switch (G__20279) {
case 1:
return sablono.core.range_field20276.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field20276.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20277.length)].join('')));

}
});

sablono.core.range_field20276.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.range_field20276.call(null,name__11649__auto__,null);
});

sablono.core.range_field20276.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.range_field20276.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field20276);

/**
 * Creates a search input field.
 */
sablono.core.search_field20280 = (function sablono$core$search_field20280(var_args){
var args20281 = [];
var len__5726__auto___20348 = arguments.length;
var i__5727__auto___20349 = (0);
while(true){
if((i__5727__auto___20349 < len__5726__auto___20348)){
args20281.push((arguments[i__5727__auto___20349]));

var G__20350 = (i__5727__auto___20349 + (1));
i__5727__auto___20349 = G__20350;
continue;
} else {
}
break;
}

var G__20283 = args20281.length;
switch (G__20283) {
case 1:
return sablono.core.search_field20280.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field20280.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20281.length)].join('')));

}
});

sablono.core.search_field20280.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.search_field20280.call(null,name__11649__auto__,null);
});

sablono.core.search_field20280.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.search_field20280.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field20280);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field20284 = (function sablono$core$tel_field20284(var_args){
var args20285 = [];
var len__5726__auto___20352 = arguments.length;
var i__5727__auto___20353 = (0);
while(true){
if((i__5727__auto___20353 < len__5726__auto___20352)){
args20285.push((arguments[i__5727__auto___20353]));

var G__20354 = (i__5727__auto___20353 + (1));
i__5727__auto___20353 = G__20354;
continue;
} else {
}
break;
}

var G__20287 = args20285.length;
switch (G__20287) {
case 1:
return sablono.core.tel_field20284.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field20284.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20285.length)].join('')));

}
});

sablono.core.tel_field20284.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.tel_field20284.call(null,name__11649__auto__,null);
});

sablono.core.tel_field20284.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.tel_field20284.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field20284);

/**
 * Creates a text input field.
 */
sablono.core.text_field20288 = (function sablono$core$text_field20288(var_args){
var args20289 = [];
var len__5726__auto___20356 = arguments.length;
var i__5727__auto___20357 = (0);
while(true){
if((i__5727__auto___20357 < len__5726__auto___20356)){
args20289.push((arguments[i__5727__auto___20357]));

var G__20358 = (i__5727__auto___20357 + (1));
i__5727__auto___20357 = G__20358;
continue;
} else {
}
break;
}

var G__20291 = args20289.length;
switch (G__20291) {
case 1:
return sablono.core.text_field20288.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field20288.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20289.length)].join('')));

}
});

sablono.core.text_field20288.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.text_field20288.call(null,name__11649__auto__,null);
});

sablono.core.text_field20288.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.text_field20288.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field20288);

/**
 * Creates a time input field.
 */
sablono.core.time_field20292 = (function sablono$core$time_field20292(var_args){
var args20293 = [];
var len__5726__auto___20360 = arguments.length;
var i__5727__auto___20361 = (0);
while(true){
if((i__5727__auto___20361 < len__5726__auto___20360)){
args20293.push((arguments[i__5727__auto___20361]));

var G__20362 = (i__5727__auto___20361 + (1));
i__5727__auto___20361 = G__20362;
continue;
} else {
}
break;
}

var G__20295 = args20293.length;
switch (G__20295) {
case 1:
return sablono.core.time_field20292.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field20292.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20293.length)].join('')));

}
});

sablono.core.time_field20292.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.time_field20292.call(null,name__11649__auto__,null);
});

sablono.core.time_field20292.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.time_field20292.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field20292);

/**
 * Creates a url input field.
 */
sablono.core.url_field20296 = (function sablono$core$url_field20296(var_args){
var args20297 = [];
var len__5726__auto___20364 = arguments.length;
var i__5727__auto___20365 = (0);
while(true){
if((i__5727__auto___20365 < len__5726__auto___20364)){
args20297.push((arguments[i__5727__auto___20365]));

var G__20366 = (i__5727__auto___20365 + (1));
i__5727__auto___20365 = G__20366;
continue;
} else {
}
break;
}

var G__20299 = args20297.length;
switch (G__20299) {
case 1:
return sablono.core.url_field20296.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field20296.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20297.length)].join('')));

}
});

sablono.core.url_field20296.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.url_field20296.call(null,name__11649__auto__,null);
});

sablono.core.url_field20296.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.url_field20296.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field20296);

/**
 * Creates a week input field.
 */
sablono.core.week_field20300 = (function sablono$core$week_field20300(var_args){
var args20301 = [];
var len__5726__auto___20368 = arguments.length;
var i__5727__auto___20369 = (0);
while(true){
if((i__5727__auto___20369 < len__5726__auto___20368)){
args20301.push((arguments[i__5727__auto___20369]));

var G__20370 = (i__5727__auto___20369 + (1));
i__5727__auto___20369 = G__20370;
continue;
} else {
}
break;
}

var G__20303 = args20301.length;
switch (G__20303) {
case 1:
return sablono.core.week_field20300.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field20300.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20301.length)].join('')));

}
});

sablono.core.week_field20300.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.week_field20300.call(null,name__11649__auto__,null);
});

sablono.core.week_field20300.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.week_field20300.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field20300);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box20372 = (function sablono$core$check_box20372(var_args){
var args20373 = [];
var len__5726__auto___20376 = arguments.length;
var i__5727__auto___20377 = (0);
while(true){
if((i__5727__auto___20377 < len__5726__auto___20376)){
args20373.push((arguments[i__5727__auto___20377]));

var G__20378 = (i__5727__auto___20377 + (1));
i__5727__auto___20377 = G__20378;
continue;
} else {
}
break;
}

var G__20375 = args20373.length;
switch (G__20375) {
case 1:
return sablono.core.check_box20372.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box20372.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box20372.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20373.length)].join('')));

}
});

sablono.core.check_box20372.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box20372.call(null,name,null);
});

sablono.core.check_box20372.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box20372.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box20372.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20372.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box20372);
/**
 * Creates a radio button.
 */
sablono.core.radio_button20380 = (function sablono$core$radio_button20380(var_args){
var args20381 = [];
var len__5726__auto___20384 = arguments.length;
var i__5727__auto___20385 = (0);
while(true){
if((i__5727__auto___20385 < len__5726__auto___20384)){
args20381.push((arguments[i__5727__auto___20385]));

var G__20386 = (i__5727__auto___20385 + (1));
i__5727__auto___20385 = G__20386;
continue;
} else {
}
break;
}

var G__20383 = args20381.length;
switch (G__20383) {
case 1:
return sablono.core.radio_button20380.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button20380.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button20380.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20381.length)].join('')));

}
});

sablono.core.radio_button20380.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button20380.call(null,group,null);
});

sablono.core.radio_button20380.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button20380.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button20380.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20380.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button20380);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options20388 = (function sablono$core$select_options20388(coll){
var iter__5440__auto__ = (function sablono$core$select_options20388_$_iter__20397(s__20398){
return (new cljs.core.LazySeq(null,(function (){
var s__20398__$1 = s__20398;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20398__$1);
if(temp__4425__auto__){
var s__20398__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20398__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20398__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20400 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20399 = (0);
while(true){
if((i__20399 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20399);
cljs.core.chunk_append.call(null,b__20400,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20403 = x;
var text = cljs.core.nth.call(null,vec__20403,(0),null);
var val = cljs.core.nth.call(null,vec__20403,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20403,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20388.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__20405 = (i__20399 + (1));
i__20399 = G__20405;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20400),sablono$core$select_options20388_$_iter__20397.call(null,cljs.core.chunk_rest.call(null,s__20398__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20400),null);
}
} else {
var x = cljs.core.first.call(null,s__20398__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20404 = x;
var text = cljs.core.nth.call(null,vec__20404,(0),null);
var val = cljs.core.nth.call(null,vec__20404,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20404,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20388.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options20388_$_iter__20397.call(null,cljs.core.rest.call(null,s__20398__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options20388);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down20406 = (function sablono$core$drop_down20406(var_args){
var args20407 = [];
var len__5726__auto___20410 = arguments.length;
var i__5727__auto___20411 = (0);
while(true){
if((i__5727__auto___20411 < len__5726__auto___20410)){
args20407.push((arguments[i__5727__auto___20411]));

var G__20412 = (i__5727__auto___20411 + (1));
i__5727__auto___20411 = G__20412;
continue;
} else {
}
break;
}

var G__20409 = args20407.length;
switch (G__20409) {
case 2:
return sablono.core.drop_down20406.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down20406.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20407.length)].join('')));

}
});

sablono.core.drop_down20406.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down20406.call(null,name,options,null);
});

sablono.core.drop_down20406.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down20406.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down20406);
/**
 * Creates a text area element.
 */
sablono.core.text_area20414 = (function sablono$core$text_area20414(var_args){
var args20415 = [];
var len__5726__auto___20418 = arguments.length;
var i__5727__auto___20419 = (0);
while(true){
if((i__5727__auto___20419 < len__5726__auto___20418)){
args20415.push((arguments[i__5727__auto___20419]));

var G__20420 = (i__5727__auto___20419 + (1));
i__5727__auto___20419 = G__20420;
continue;
} else {
}
break;
}

var G__20417 = args20415.length;
switch (G__20417) {
case 1:
return sablono.core.text_area20414.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area20414.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20415.length)].join('')));

}
});

sablono.core.text_area20414.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area20414.call(null,name,null);
});

sablono.core.text_area20414.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area20414.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area20414);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20422 = (function sablono$core$label20422(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20422);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20423 = (function sablono$core$submit_button20423(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20423);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20424 = (function sablono$core$reset_button20424(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20424);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20425 = (function sablono$core$form_to20425(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20430 = arguments.length;
var i__5727__auto___20431 = (0);
while(true){
if((i__5727__auto___20431 < len__5726__auto___20430)){
args__5733__auto__.push((arguments[i__5727__auto___20431]));

var G__20432 = (i__5727__auto___20431 + (1));
i__5727__auto___20431 = G__20432;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to20425.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to20425.cljs$core$IFn$_invoke$arity$variadic = (function (p__20428,body){
var vec__20429 = p__20428;
var method = cljs.core.nth.call(null,vec__20429,(0),null);
var action = cljs.core.nth.call(null,vec__20429,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to20425.cljs$lang$maxFixedArity = (1);

sablono.core.form_to20425.cljs$lang$applyTo = (function (seq20426){
var G__20427 = cljs.core.first.call(null,seq20426);
var seq20426__$1 = cljs.core.next.call(null,seq20426);
return sablono.core.form_to20425.cljs$core$IFn$_invoke$arity$variadic(G__20427,seq20426__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20425);

//# sourceMappingURL=core.js.map?rel=1459838501688