// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__16260__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__16259 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__16259,(0),null);
var body = cljs.core.nthnext.call(null,vec__16259,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__16260 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16261__i = 0, G__16261__a = new Array(arguments.length -  0);
while (G__16261__i < G__16261__a.length) {G__16261__a[G__16261__i] = arguments[G__16261__i + 0]; ++G__16261__i;}
  args = new cljs.core.IndexedSeq(G__16261__a,0);
} 
return G__16260__delegate.call(this,args);};
G__16260.cljs$lang$maxFixedArity = 0;
G__16260.cljs$lang$applyTo = (function (arglist__16262){
var args = cljs.core.seq(arglist__16262);
return G__16260__delegate(args);
});
G__16260.cljs$core$IFn$_invoke$arity$variadic = G__16260__delegate;
return G__16260;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__16267(s__16268){
return (new cljs.core.LazySeq(null,(function (){
var s__16268__$1 = s__16268;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16268__$1);
if(temp__4425__auto__){
var s__16268__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16268__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16268__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16270 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16269 = (0);
while(true){
if((i__16269 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__16269);
cljs.core.chunk_append.call(null,b__16270,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__16271 = (i__16269 + (1));
i__16269 = G__16271;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16270),sablono$core$update_arglists_$_iter__16267.call(null,cljs.core.chunk_rest.call(null,s__16268__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16270),null);
}
} else {
var args = cljs.core.first.call(null,s__16268__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__16267.call(null,cljs.core.rest.call(null,s__16268__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16277 = arguments.length;
var i__5727__auto___16278 = (0);
while(true){
if((i__5727__auto___16278 < len__5726__auto___16277)){
args__5733__auto__.push((arguments[i__5727__auto___16278]));

var G__16279 = (i__5727__auto___16278 + (1));
i__5727__auto___16278 = G__16279;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__16273(s__16274){
return (new cljs.core.LazySeq(null,(function (){
var s__16274__$1 = s__16274;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16274__$1);
if(temp__4425__auto__){
var s__16274__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16274__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16274__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16276 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16275 = (0);
while(true){
if((i__16275 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__16275);
cljs.core.chunk_append.call(null,b__16276,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__16280 = (i__16275 + (1));
i__16275 = G__16280;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16276),sablono$core$iter__16273.call(null,cljs.core.chunk_rest.call(null,s__16274__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16276),null);
}
} else {
var style = cljs.core.first.call(null,s__16274__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__16273.call(null,cljs.core.rest.call(null,s__16274__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq16272){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16272));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to16281 = (function sablono$core$link_to16281(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16284 = arguments.length;
var i__5727__auto___16285 = (0);
while(true){
if((i__5727__auto___16285 < len__5726__auto___16284)){
args__5733__auto__.push((arguments[i__5727__auto___16285]));

var G__16286 = (i__5727__auto___16285 + (1));
i__5727__auto___16285 = G__16286;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to16281.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to16281.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to16281.cljs$lang$maxFixedArity = (1);

sablono.core.link_to16281.cljs$lang$applyTo = (function (seq16282){
var G__16283 = cljs.core.first.call(null,seq16282);
var seq16282__$1 = cljs.core.next.call(null,seq16282);
return sablono.core.link_to16281.cljs$core$IFn$_invoke$arity$variadic(G__16283,seq16282__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to16281);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to16287 = (function sablono$core$mail_to16287(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16292 = arguments.length;
var i__5727__auto___16293 = (0);
while(true){
if((i__5727__auto___16293 < len__5726__auto___16292)){
args__5733__auto__.push((arguments[i__5727__auto___16293]));

var G__16294 = (i__5727__auto___16293 + (1));
i__5727__auto___16293 = G__16294;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to16287.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to16287.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__16290){
var vec__16291 = p__16290;
var content = cljs.core.nth.call(null,vec__16291,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to16287.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to16287.cljs$lang$applyTo = (function (seq16288){
var G__16289 = cljs.core.first.call(null,seq16288);
var seq16288__$1 = cljs.core.next.call(null,seq16288);
return sablono.core.mail_to16287.cljs$core$IFn$_invoke$arity$variadic(G__16289,seq16288__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to16287);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list16295 = (function sablono$core$unordered_list16295(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list16295_$_iter__16300(s__16301){
return (new cljs.core.LazySeq(null,(function (){
var s__16301__$1 = s__16301;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16301__$1);
if(temp__4425__auto__){
var s__16301__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16301__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16301__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16303 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16302 = (0);
while(true){
if((i__16302 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16302);
cljs.core.chunk_append.call(null,b__16303,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16304 = (i__16302 + (1));
i__16302 = G__16304;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16303),sablono$core$unordered_list16295_$_iter__16300.call(null,cljs.core.chunk_rest.call(null,s__16301__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16303),null);
}
} else {
var x = cljs.core.first.call(null,s__16301__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list16295_$_iter__16300.call(null,cljs.core.rest.call(null,s__16301__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list16295);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list16305 = (function sablono$core$ordered_list16305(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list16305_$_iter__16310(s__16311){
return (new cljs.core.LazySeq(null,(function (){
var s__16311__$1 = s__16311;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16311__$1);
if(temp__4425__auto__){
var s__16311__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16311__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16311__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16313 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16312 = (0);
while(true){
if((i__16312 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16312);
cljs.core.chunk_append.call(null,b__16313,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__16314 = (i__16312 + (1));
i__16312 = G__16314;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16313),sablono$core$ordered_list16305_$_iter__16310.call(null,cljs.core.chunk_rest.call(null,s__16311__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16313),null);
}
} else {
var x = cljs.core.first.call(null,s__16311__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list16305_$_iter__16310.call(null,cljs.core.rest.call(null,s__16311__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list16305);
/**
 * Create an image element.
 */
sablono.core.image16315 = (function sablono$core$image16315(var_args){
var args16316 = [];
var len__5726__auto___16319 = arguments.length;
var i__5727__auto___16320 = (0);
while(true){
if((i__5727__auto___16320 < len__5726__auto___16319)){
args16316.push((arguments[i__5727__auto___16320]));

var G__16321 = (i__5727__auto___16320 + (1));
i__5727__auto___16320 = G__16321;
continue;
} else {
}
break;
}

var G__16318 = args16316.length;
switch (G__16318) {
case 1:
return sablono.core.image16315.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image16315.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16316.length)].join('')));

}
});

sablono.core.image16315.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image16315.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image16315.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image16315);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__16323_SHARP_,p2__16324_SHARP_){
return [cljs.core.str(p1__16323_SHARP_),cljs.core.str("["),cljs.core.str(p2__16324_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__16325_SHARP_,p2__16326_SHARP_){
return [cljs.core.str(p1__16325_SHARP_),cljs.core.str("-"),cljs.core.str(p2__16326_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field16327 = (function sablono$core$color_field16327(var_args){
var args16328 = [];
var len__5726__auto___16395 = arguments.length;
var i__5727__auto___16396 = (0);
while(true){
if((i__5727__auto___16396 < len__5726__auto___16395)){
args16328.push((arguments[i__5727__auto___16396]));

var G__16397 = (i__5727__auto___16396 + (1));
i__5727__auto___16396 = G__16397;
continue;
} else {
}
break;
}

var G__16330 = args16328.length;
switch (G__16330) {
case 1:
return sablono.core.color_field16327.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field16327.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16328.length)].join('')));

}
});

sablono.core.color_field16327.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.color_field16327.call(null,name__6340__auto__,null);
});

sablono.core.color_field16327.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.color_field16327.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field16327);

/**
 * Creates a date input field.
 */
sablono.core.date_field16331 = (function sablono$core$date_field16331(var_args){
var args16332 = [];
var len__5726__auto___16399 = arguments.length;
var i__5727__auto___16400 = (0);
while(true){
if((i__5727__auto___16400 < len__5726__auto___16399)){
args16332.push((arguments[i__5727__auto___16400]));

var G__16401 = (i__5727__auto___16400 + (1));
i__5727__auto___16400 = G__16401;
continue;
} else {
}
break;
}

var G__16334 = args16332.length;
switch (G__16334) {
case 1:
return sablono.core.date_field16331.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field16331.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16332.length)].join('')));

}
});

sablono.core.date_field16331.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.date_field16331.call(null,name__6340__auto__,null);
});

sablono.core.date_field16331.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.date_field16331.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field16331);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field16335 = (function sablono$core$datetime_field16335(var_args){
var args16336 = [];
var len__5726__auto___16403 = arguments.length;
var i__5727__auto___16404 = (0);
while(true){
if((i__5727__auto___16404 < len__5726__auto___16403)){
args16336.push((arguments[i__5727__auto___16404]));

var G__16405 = (i__5727__auto___16404 + (1));
i__5727__auto___16404 = G__16405;
continue;
} else {
}
break;
}

var G__16338 = args16336.length;
switch (G__16338) {
case 1:
return sablono.core.datetime_field16335.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field16335.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16336.length)].join('')));

}
});

sablono.core.datetime_field16335.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_field16335.call(null,name__6340__auto__,null);
});

sablono.core.datetime_field16335.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_field16335.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field16335);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field16339 = (function sablono$core$datetime_local_field16339(var_args){
var args16340 = [];
var len__5726__auto___16407 = arguments.length;
var i__5727__auto___16408 = (0);
while(true){
if((i__5727__auto___16408 < len__5726__auto___16407)){
args16340.push((arguments[i__5727__auto___16408]));

var G__16409 = (i__5727__auto___16408 + (1));
i__5727__auto___16408 = G__16409;
continue;
} else {
}
break;
}

var G__16342 = args16340.length;
switch (G__16342) {
case 1:
return sablono.core.datetime_local_field16339.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field16339.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16340.length)].join('')));

}
});

sablono.core.datetime_local_field16339.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.datetime_local_field16339.call(null,name__6340__auto__,null);
});

sablono.core.datetime_local_field16339.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.datetime_local_field16339.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field16339);

/**
 * Creates a email input field.
 */
sablono.core.email_field16343 = (function sablono$core$email_field16343(var_args){
var args16344 = [];
var len__5726__auto___16411 = arguments.length;
var i__5727__auto___16412 = (0);
while(true){
if((i__5727__auto___16412 < len__5726__auto___16411)){
args16344.push((arguments[i__5727__auto___16412]));

var G__16413 = (i__5727__auto___16412 + (1));
i__5727__auto___16412 = G__16413;
continue;
} else {
}
break;
}

var G__16346 = args16344.length;
switch (G__16346) {
case 1:
return sablono.core.email_field16343.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field16343.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16344.length)].join('')));

}
});

sablono.core.email_field16343.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.email_field16343.call(null,name__6340__auto__,null);
});

sablono.core.email_field16343.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.email_field16343.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field16343);

/**
 * Creates a file input field.
 */
sablono.core.file_field16347 = (function sablono$core$file_field16347(var_args){
var args16348 = [];
var len__5726__auto___16415 = arguments.length;
var i__5727__auto___16416 = (0);
while(true){
if((i__5727__auto___16416 < len__5726__auto___16415)){
args16348.push((arguments[i__5727__auto___16416]));

var G__16417 = (i__5727__auto___16416 + (1));
i__5727__auto___16416 = G__16417;
continue;
} else {
}
break;
}

var G__16350 = args16348.length;
switch (G__16350) {
case 1:
return sablono.core.file_field16347.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field16347.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16348.length)].join('')));

}
});

sablono.core.file_field16347.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.file_field16347.call(null,name__6340__auto__,null);
});

sablono.core.file_field16347.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.file_field16347.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field16347);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field16351 = (function sablono$core$hidden_field16351(var_args){
var args16352 = [];
var len__5726__auto___16419 = arguments.length;
var i__5727__auto___16420 = (0);
while(true){
if((i__5727__auto___16420 < len__5726__auto___16419)){
args16352.push((arguments[i__5727__auto___16420]));

var G__16421 = (i__5727__auto___16420 + (1));
i__5727__auto___16420 = G__16421;
continue;
} else {
}
break;
}

var G__16354 = args16352.length;
switch (G__16354) {
case 1:
return sablono.core.hidden_field16351.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field16351.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16352.length)].join('')));

}
});

sablono.core.hidden_field16351.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.hidden_field16351.call(null,name__6340__auto__,null);
});

sablono.core.hidden_field16351.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.hidden_field16351.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field16351);

/**
 * Creates a month input field.
 */
sablono.core.month_field16355 = (function sablono$core$month_field16355(var_args){
var args16356 = [];
var len__5726__auto___16423 = arguments.length;
var i__5727__auto___16424 = (0);
while(true){
if((i__5727__auto___16424 < len__5726__auto___16423)){
args16356.push((arguments[i__5727__auto___16424]));

var G__16425 = (i__5727__auto___16424 + (1));
i__5727__auto___16424 = G__16425;
continue;
} else {
}
break;
}

var G__16358 = args16356.length;
switch (G__16358) {
case 1:
return sablono.core.month_field16355.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field16355.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16356.length)].join('')));

}
});

sablono.core.month_field16355.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.month_field16355.call(null,name__6340__auto__,null);
});

sablono.core.month_field16355.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.month_field16355.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field16355);

/**
 * Creates a number input field.
 */
sablono.core.number_field16359 = (function sablono$core$number_field16359(var_args){
var args16360 = [];
var len__5726__auto___16427 = arguments.length;
var i__5727__auto___16428 = (0);
while(true){
if((i__5727__auto___16428 < len__5726__auto___16427)){
args16360.push((arguments[i__5727__auto___16428]));

var G__16429 = (i__5727__auto___16428 + (1));
i__5727__auto___16428 = G__16429;
continue;
} else {
}
break;
}

var G__16362 = args16360.length;
switch (G__16362) {
case 1:
return sablono.core.number_field16359.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field16359.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16360.length)].join('')));

}
});

sablono.core.number_field16359.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.number_field16359.call(null,name__6340__auto__,null);
});

sablono.core.number_field16359.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.number_field16359.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field16359);

/**
 * Creates a password input field.
 */
sablono.core.password_field16363 = (function sablono$core$password_field16363(var_args){
var args16364 = [];
var len__5726__auto___16431 = arguments.length;
var i__5727__auto___16432 = (0);
while(true){
if((i__5727__auto___16432 < len__5726__auto___16431)){
args16364.push((arguments[i__5727__auto___16432]));

var G__16433 = (i__5727__auto___16432 + (1));
i__5727__auto___16432 = G__16433;
continue;
} else {
}
break;
}

var G__16366 = args16364.length;
switch (G__16366) {
case 1:
return sablono.core.password_field16363.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field16363.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16364.length)].join('')));

}
});

sablono.core.password_field16363.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.password_field16363.call(null,name__6340__auto__,null);
});

sablono.core.password_field16363.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.password_field16363.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field16363);

/**
 * Creates a range input field.
 */
sablono.core.range_field16367 = (function sablono$core$range_field16367(var_args){
var args16368 = [];
var len__5726__auto___16435 = arguments.length;
var i__5727__auto___16436 = (0);
while(true){
if((i__5727__auto___16436 < len__5726__auto___16435)){
args16368.push((arguments[i__5727__auto___16436]));

var G__16437 = (i__5727__auto___16436 + (1));
i__5727__auto___16436 = G__16437;
continue;
} else {
}
break;
}

var G__16370 = args16368.length;
switch (G__16370) {
case 1:
return sablono.core.range_field16367.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field16367.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16368.length)].join('')));

}
});

sablono.core.range_field16367.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.range_field16367.call(null,name__6340__auto__,null);
});

sablono.core.range_field16367.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.range_field16367.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field16367);

/**
 * Creates a search input field.
 */
sablono.core.search_field16371 = (function sablono$core$search_field16371(var_args){
var args16372 = [];
var len__5726__auto___16439 = arguments.length;
var i__5727__auto___16440 = (0);
while(true){
if((i__5727__auto___16440 < len__5726__auto___16439)){
args16372.push((arguments[i__5727__auto___16440]));

var G__16441 = (i__5727__auto___16440 + (1));
i__5727__auto___16440 = G__16441;
continue;
} else {
}
break;
}

var G__16374 = args16372.length;
switch (G__16374) {
case 1:
return sablono.core.search_field16371.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field16371.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16372.length)].join('')));

}
});

sablono.core.search_field16371.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.search_field16371.call(null,name__6340__auto__,null);
});

sablono.core.search_field16371.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.search_field16371.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field16371);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field16375 = (function sablono$core$tel_field16375(var_args){
var args16376 = [];
var len__5726__auto___16443 = arguments.length;
var i__5727__auto___16444 = (0);
while(true){
if((i__5727__auto___16444 < len__5726__auto___16443)){
args16376.push((arguments[i__5727__auto___16444]));

var G__16445 = (i__5727__auto___16444 + (1));
i__5727__auto___16444 = G__16445;
continue;
} else {
}
break;
}

var G__16378 = args16376.length;
switch (G__16378) {
case 1:
return sablono.core.tel_field16375.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field16375.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16376.length)].join('')));

}
});

sablono.core.tel_field16375.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.tel_field16375.call(null,name__6340__auto__,null);
});

sablono.core.tel_field16375.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.tel_field16375.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field16375);

/**
 * Creates a text input field.
 */
sablono.core.text_field16379 = (function sablono$core$text_field16379(var_args){
var args16380 = [];
var len__5726__auto___16447 = arguments.length;
var i__5727__auto___16448 = (0);
while(true){
if((i__5727__auto___16448 < len__5726__auto___16447)){
args16380.push((arguments[i__5727__auto___16448]));

var G__16449 = (i__5727__auto___16448 + (1));
i__5727__auto___16448 = G__16449;
continue;
} else {
}
break;
}

var G__16382 = args16380.length;
switch (G__16382) {
case 1:
return sablono.core.text_field16379.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field16379.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16380.length)].join('')));

}
});

sablono.core.text_field16379.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.text_field16379.call(null,name__6340__auto__,null);
});

sablono.core.text_field16379.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.text_field16379.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field16379);

/**
 * Creates a time input field.
 */
sablono.core.time_field16383 = (function sablono$core$time_field16383(var_args){
var args16384 = [];
var len__5726__auto___16451 = arguments.length;
var i__5727__auto___16452 = (0);
while(true){
if((i__5727__auto___16452 < len__5726__auto___16451)){
args16384.push((arguments[i__5727__auto___16452]));

var G__16453 = (i__5727__auto___16452 + (1));
i__5727__auto___16452 = G__16453;
continue;
} else {
}
break;
}

var G__16386 = args16384.length;
switch (G__16386) {
case 1:
return sablono.core.time_field16383.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field16383.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16384.length)].join('')));

}
});

sablono.core.time_field16383.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.time_field16383.call(null,name__6340__auto__,null);
});

sablono.core.time_field16383.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.time_field16383.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field16383);

/**
 * Creates a url input field.
 */
sablono.core.url_field16387 = (function sablono$core$url_field16387(var_args){
var args16388 = [];
var len__5726__auto___16455 = arguments.length;
var i__5727__auto___16456 = (0);
while(true){
if((i__5727__auto___16456 < len__5726__auto___16455)){
args16388.push((arguments[i__5727__auto___16456]));

var G__16457 = (i__5727__auto___16456 + (1));
i__5727__auto___16456 = G__16457;
continue;
} else {
}
break;
}

var G__16390 = args16388.length;
switch (G__16390) {
case 1:
return sablono.core.url_field16387.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field16387.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16388.length)].join('')));

}
});

sablono.core.url_field16387.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.url_field16387.call(null,name__6340__auto__,null);
});

sablono.core.url_field16387.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.url_field16387.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field16387);

/**
 * Creates a week input field.
 */
sablono.core.week_field16391 = (function sablono$core$week_field16391(var_args){
var args16392 = [];
var len__5726__auto___16459 = arguments.length;
var i__5727__auto___16460 = (0);
while(true){
if((i__5727__auto___16460 < len__5726__auto___16459)){
args16392.push((arguments[i__5727__auto___16460]));

var G__16461 = (i__5727__auto___16460 + (1));
i__5727__auto___16460 = G__16461;
continue;
} else {
}
break;
}

var G__16394 = args16392.length;
switch (G__16394) {
case 1:
return sablono.core.week_field16391.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field16391.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16392.length)].join('')));

}
});

sablono.core.week_field16391.cljs$core$IFn$_invoke$arity$1 = (function (name__6340__auto__){
return sablono.core.week_field16391.call(null,name__6340__auto__,null);
});

sablono.core.week_field16391.cljs$core$IFn$_invoke$arity$2 = (function (name__6340__auto__,value__6341__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__6340__auto__,value__6341__auto__);
});

sablono.core.week_field16391.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field16391);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box16463 = (function sablono$core$check_box16463(var_args){
var args16464 = [];
var len__5726__auto___16467 = arguments.length;
var i__5727__auto___16468 = (0);
while(true){
if((i__5727__auto___16468 < len__5726__auto___16467)){
args16464.push((arguments[i__5727__auto___16468]));

var G__16469 = (i__5727__auto___16468 + (1));
i__5727__auto___16468 = G__16469;
continue;
} else {
}
break;
}

var G__16466 = args16464.length;
switch (G__16466) {
case 1:
return sablono.core.check_box16463.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box16463.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box16463.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16464.length)].join('')));

}
});

sablono.core.check_box16463.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box16463.call(null,name,null);
});

sablono.core.check_box16463.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box16463.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box16463.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box16463.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box16463);
/**
 * Creates a radio button.
 */
sablono.core.radio_button16471 = (function sablono$core$radio_button16471(var_args){
var args16472 = [];
var len__5726__auto___16475 = arguments.length;
var i__5727__auto___16476 = (0);
while(true){
if((i__5727__auto___16476 < len__5726__auto___16475)){
args16472.push((arguments[i__5727__auto___16476]));

var G__16477 = (i__5727__auto___16476 + (1));
i__5727__auto___16476 = G__16477;
continue;
} else {
}
break;
}

var G__16474 = args16472.length;
switch (G__16474) {
case 1:
return sablono.core.radio_button16471.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button16471.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button16471.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16472.length)].join('')));

}
});

sablono.core.radio_button16471.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button16471.call(null,group,null);
});

sablono.core.radio_button16471.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button16471.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button16471.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button16471.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button16471);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options16479 = (function sablono$core$select_options16479(coll){
var iter__5440__auto__ = (function sablono$core$select_options16479_$_iter__16488(s__16489){
return (new cljs.core.LazySeq(null,(function (){
var s__16489__$1 = s__16489;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__16489__$1);
if(temp__4425__auto__){
var s__16489__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16489__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__16489__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__16491 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__16490 = (0);
while(true){
if((i__16490 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__16490);
cljs.core.chunk_append.call(null,b__16491,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16494 = x;
var text = cljs.core.nth.call(null,vec__16494,(0),null);
var val = cljs.core.nth.call(null,vec__16494,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16494,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16479.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__16496 = (i__16490 + (1));
i__16490 = G__16496;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16491),sablono$core$select_options16479_$_iter__16488.call(null,cljs.core.chunk_rest.call(null,s__16489__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16491),null);
}
} else {
var x = cljs.core.first.call(null,s__16489__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16495 = x;
var text = cljs.core.nth.call(null,vec__16495,(0),null);
var val = cljs.core.nth.call(null,vec__16495,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__16495,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options16479.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options16479_$_iter__16488.call(null,cljs.core.rest.call(null,s__16489__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options16479);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down16497 = (function sablono$core$drop_down16497(var_args){
var args16498 = [];
var len__5726__auto___16501 = arguments.length;
var i__5727__auto___16502 = (0);
while(true){
if((i__5727__auto___16502 < len__5726__auto___16501)){
args16498.push((arguments[i__5727__auto___16502]));

var G__16503 = (i__5727__auto___16502 + (1));
i__5727__auto___16502 = G__16503;
continue;
} else {
}
break;
}

var G__16500 = args16498.length;
switch (G__16500) {
case 2:
return sablono.core.drop_down16497.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down16497.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16498.length)].join('')));

}
});

sablono.core.drop_down16497.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down16497.call(null,name,options,null);
});

sablono.core.drop_down16497.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down16497.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down16497);
/**
 * Creates a text area element.
 */
sablono.core.text_area16505 = (function sablono$core$text_area16505(var_args){
var args16506 = [];
var len__5726__auto___16509 = arguments.length;
var i__5727__auto___16510 = (0);
while(true){
if((i__5727__auto___16510 < len__5726__auto___16509)){
args16506.push((arguments[i__5727__auto___16510]));

var G__16511 = (i__5727__auto___16510 + (1));
i__5727__auto___16510 = G__16511;
continue;
} else {
}
break;
}

var G__16508 = args16506.length;
switch (G__16508) {
case 1:
return sablono.core.text_area16505.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area16505.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16506.length)].join('')));

}
});

sablono.core.text_area16505.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area16505.call(null,name,null);
});

sablono.core.text_area16505.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area16505.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area16505);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label16513 = (function sablono$core$label16513(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label16513);
/**
 * Creates a submit button.
 */
sablono.core.submit_button16514 = (function sablono$core$submit_button16514(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button16514);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button16515 = (function sablono$core$reset_button16515(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button16515);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to16516 = (function sablono$core$form_to16516(var_args){
var args__5733__auto__ = [];
var len__5726__auto___16521 = arguments.length;
var i__5727__auto___16522 = (0);
while(true){
if((i__5727__auto___16522 < len__5726__auto___16521)){
args__5733__auto__.push((arguments[i__5727__auto___16522]));

var G__16523 = (i__5727__auto___16522 + (1));
i__5727__auto___16522 = G__16523;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to16516.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to16516.cljs$core$IFn$_invoke$arity$variadic = (function (p__16519,body){
var vec__16520 = p__16519;
var method = cljs.core.nth.call(null,vec__16520,(0),null);
var action = cljs.core.nth.call(null,vec__16520,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to16516.cljs$lang$maxFixedArity = (1);

sablono.core.form_to16516.cljs$lang$applyTo = (function (seq16517){
var G__16518 = cljs.core.first.call(null,seq16517);
var seq16517__$1 = cljs.core.next.call(null,seq16517);
return sablono.core.form_to16516.cljs$core$IFn$_invoke$arity$variadic(G__16518,seq16517__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to16516);

//# sourceMappingURL=core.js.map?rel=1463994341776