// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args19000 = [];
var len__5726__auto___19006 = arguments.length;
var i__5727__auto___19007 = (0);
while(true){
if((i__5727__auto___19007 < len__5726__auto___19006)){
args19000.push((arguments[i__5727__auto___19007]));

var G__19008 = (i__5727__auto___19007 + (1));
i__5727__auto___19007 = G__19008;
continue;
} else {
}
break;
}

var G__19002 = args19000.length;
switch (G__19002) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19000.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async19003 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19003 = (function (f,blockable,meta19004){
this.f = f;
this.blockable = blockable;
this.meta19004 = meta19004;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19003.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19005,meta19004__$1){
var self__ = this;
var _19005__$1 = this;
return (new cljs.core.async.t_cljs$core$async19003(self__.f,self__.blockable,meta19004__$1));
});

cljs.core.async.t_cljs$core$async19003.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19005){
var self__ = this;
var _19005__$1 = this;
return self__.meta19004;
});

cljs.core.async.t_cljs$core$async19003.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19003.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19003.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async19003.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async19003.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta19004","meta19004",176486575,null)], null);
});

cljs.core.async.t_cljs$core$async19003.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19003.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19003";

cljs.core.async.t_cljs$core$async19003.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19003");
});

cljs.core.async.__GT_t_cljs$core$async19003 = (function cljs$core$async$__GT_t_cljs$core$async19003(f__$1,blockable__$1,meta19004){
return (new cljs.core.async.t_cljs$core$async19003(f__$1,blockable__$1,meta19004));
});

}

return (new cljs.core.async.t_cljs$core$async19003(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args19012 = [];
var len__5726__auto___19015 = arguments.length;
var i__5727__auto___19016 = (0);
while(true){
if((i__5727__auto___19016 < len__5726__auto___19015)){
args19012.push((arguments[i__5727__auto___19016]));

var G__19017 = (i__5727__auto___19016 + (1));
i__5727__auto___19016 = G__19017;
continue;
} else {
}
break;
}

var G__19014 = args19012.length;
switch (G__19014) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19012.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args19019 = [];
var len__5726__auto___19022 = arguments.length;
var i__5727__auto___19023 = (0);
while(true){
if((i__5727__auto___19023 < len__5726__auto___19022)){
args19019.push((arguments[i__5727__auto___19023]));

var G__19024 = (i__5727__auto___19023 + (1));
i__5727__auto___19023 = G__19024;
continue;
} else {
}
break;
}

var G__19021 = args19019.length;
switch (G__19021) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19019.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args19026 = [];
var len__5726__auto___19029 = arguments.length;
var i__5727__auto___19030 = (0);
while(true){
if((i__5727__auto___19030 < len__5726__auto___19029)){
args19026.push((arguments[i__5727__auto___19030]));

var G__19031 = (i__5727__auto___19030 + (1));
i__5727__auto___19030 = G__19031;
continue;
} else {
}
break;
}

var G__19028 = args19026.length;
switch (G__19028) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19026.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_19033 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_19033);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_19033,ret){
return (function (){
return fn1.call(null,val_19033);
});})(val_19033,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args19034 = [];
var len__5726__auto___19037 = arguments.length;
var i__5727__auto___19038 = (0);
while(true){
if((i__5727__auto___19038 < len__5726__auto___19037)){
args19034.push((arguments[i__5727__auto___19038]));

var G__19039 = (i__5727__auto___19038 + (1));
i__5727__auto___19038 = G__19039;
continue;
} else {
}
break;
}

var G__19036 = args19034.length;
switch (G__19036) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19034.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___19041 = n;
var x_19042 = (0);
while(true){
if((x_19042 < n__5571__auto___19041)){
(a[x_19042] = (0));

var G__19043 = (x_19042 + (1));
x_19042 = G__19043;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__19044 = (i + (1));
i = G__19044;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async19048 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19048 = (function (alt_flag,flag,meta19049){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta19049 = meta19049;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_19050,meta19049__$1){
var self__ = this;
var _19050__$1 = this;
return (new cljs.core.async.t_cljs$core$async19048(self__.alt_flag,self__.flag,meta19049__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async19048.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_19050){
var self__ = this;
var _19050__$1 = this;
return self__.meta19049;
});})(flag))
;

cljs.core.async.t_cljs$core$async19048.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19048.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async19048.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19048.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19048.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19049","meta19049",-1321599807,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async19048.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19048.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19048";

cljs.core.async.t_cljs$core$async19048.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19048");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async19048 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19048(alt_flag__$1,flag__$1,meta19049){
return (new cljs.core.async.t_cljs$core$async19048(alt_flag__$1,flag__$1,meta19049));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async19048(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async19054 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19054 = (function (alt_handler,flag,cb,meta19055){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta19055 = meta19055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19056,meta19055__$1){
var self__ = this;
var _19056__$1 = this;
return (new cljs.core.async.t_cljs$core$async19054(self__.alt_handler,self__.flag,self__.cb,meta19055__$1));
});

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19056){
var self__ = this;
var _19056__$1 = this;
return self__.meta19055;
});

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19054.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async19054.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19055","meta19055",1439081721,null)], null);
});

cljs.core.async.t_cljs$core$async19054.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19054.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19054";

cljs.core.async.t_cljs$core$async19054.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19054");
});

cljs.core.async.__GT_t_cljs$core$async19054 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19054(alt_handler__$1,flag__$1,cb__$1,meta19055){
return (new cljs.core.async.t_cljs$core$async19054(alt_handler__$1,flag__$1,cb__$1,meta19055));
});

}

return (new cljs.core.async.t_cljs$core$async19054(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19057_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19057_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19058_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19058_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19059 = (i + (1));
i = G__19059;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___19065 = arguments.length;
var i__5727__auto___19066 = (0);
while(true){
if((i__5727__auto___19066 < len__5726__auto___19065)){
args__5733__auto__.push((arguments[i__5727__auto___19066]));

var G__19067 = (i__5727__auto___19066 + (1));
i__5727__auto___19066 = G__19067;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19062){
var map__19063 = p__19062;
var map__19063__$1 = ((((!((map__19063 == null)))?((((map__19063.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19063.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19063):map__19063);
var opts = map__19063__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19060){
var G__19061 = cljs.core.first.call(null,seq19060);
var seq19060__$1 = cljs.core.next.call(null,seq19060);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19061,seq19060__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args19068 = [];
var len__5726__auto___19118 = arguments.length;
var i__5727__auto___19119 = (0);
while(true){
if((i__5727__auto___19119 < len__5726__auto___19118)){
args19068.push((arguments[i__5727__auto___19119]));

var G__19120 = (i__5727__auto___19119 + (1));
i__5727__auto___19119 = G__19120;
continue;
} else {
}
break;
}

var G__19070 = args19068.length;
switch (G__19070) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19068.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11081__auto___19122 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___19122){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___19122){
return (function (state_19094){
var state_val_19095 = (state_19094[(1)]);
if((state_val_19095 === (7))){
var inst_19090 = (state_19094[(2)]);
var state_19094__$1 = state_19094;
var statearr_19096_19123 = state_19094__$1;
(statearr_19096_19123[(2)] = inst_19090);

(statearr_19096_19123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (1))){
var state_19094__$1 = state_19094;
var statearr_19097_19124 = state_19094__$1;
(statearr_19097_19124[(2)] = null);

(statearr_19097_19124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (4))){
var inst_19073 = (state_19094[(7)]);
var inst_19073__$1 = (state_19094[(2)]);
var inst_19074 = (inst_19073__$1 == null);
var state_19094__$1 = (function (){var statearr_19098 = state_19094;
(statearr_19098[(7)] = inst_19073__$1);

return statearr_19098;
})();
if(cljs.core.truth_(inst_19074)){
var statearr_19099_19125 = state_19094__$1;
(statearr_19099_19125[(1)] = (5));

} else {
var statearr_19100_19126 = state_19094__$1;
(statearr_19100_19126[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (13))){
var state_19094__$1 = state_19094;
var statearr_19101_19127 = state_19094__$1;
(statearr_19101_19127[(2)] = null);

(statearr_19101_19127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (6))){
var inst_19073 = (state_19094[(7)]);
var state_19094__$1 = state_19094;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19094__$1,(11),to,inst_19073);
} else {
if((state_val_19095 === (3))){
var inst_19092 = (state_19094[(2)]);
var state_19094__$1 = state_19094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19094__$1,inst_19092);
} else {
if((state_val_19095 === (12))){
var state_19094__$1 = state_19094;
var statearr_19102_19128 = state_19094__$1;
(statearr_19102_19128[(2)] = null);

(statearr_19102_19128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (2))){
var state_19094__$1 = state_19094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19094__$1,(4),from);
} else {
if((state_val_19095 === (11))){
var inst_19083 = (state_19094[(2)]);
var state_19094__$1 = state_19094;
if(cljs.core.truth_(inst_19083)){
var statearr_19103_19129 = state_19094__$1;
(statearr_19103_19129[(1)] = (12));

} else {
var statearr_19104_19130 = state_19094__$1;
(statearr_19104_19130[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (9))){
var state_19094__$1 = state_19094;
var statearr_19105_19131 = state_19094__$1;
(statearr_19105_19131[(2)] = null);

(statearr_19105_19131[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (5))){
var state_19094__$1 = state_19094;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19106_19132 = state_19094__$1;
(statearr_19106_19132[(1)] = (8));

} else {
var statearr_19107_19133 = state_19094__$1;
(statearr_19107_19133[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (14))){
var inst_19088 = (state_19094[(2)]);
var state_19094__$1 = state_19094;
var statearr_19108_19134 = state_19094__$1;
(statearr_19108_19134[(2)] = inst_19088);

(statearr_19108_19134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (10))){
var inst_19080 = (state_19094[(2)]);
var state_19094__$1 = state_19094;
var statearr_19109_19135 = state_19094__$1;
(statearr_19109_19135[(2)] = inst_19080);

(statearr_19109_19135[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19095 === (8))){
var inst_19077 = cljs.core.async.close_BANG_.call(null,to);
var state_19094__$1 = state_19094;
var statearr_19110_19136 = state_19094__$1;
(statearr_19110_19136[(2)] = inst_19077);

(statearr_19110_19136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___19122))
;
return ((function (switch__10969__auto__,c__11081__auto___19122){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_19114 = [null,null,null,null,null,null,null,null];
(statearr_19114[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_19114[(1)] = (1));

return statearr_19114;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_19094){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19115){if((e19115 instanceof Object)){
var ex__10973__auto__ = e19115;
var statearr_19116_19137 = state_19094;
(statearr_19116_19137[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19094);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19115;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19138 = state_19094;
state_19094 = G__19138;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_19094){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_19094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___19122))
})();
var state__11083__auto__ = (function (){var statearr_19117 = f__11082__auto__.call(null);
(statearr_19117[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___19122);

return statearr_19117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___19122))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19322){
var vec__19323 = p__19322;
var v = cljs.core.nth.call(null,vec__19323,(0),null);
var p = cljs.core.nth.call(null,vec__19323,(1),null);
var job = vec__19323;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11081__auto___19505 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___19505,res,vec__19323,v,p,job,jobs,results){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___19505,res,vec__19323,v,p,job,jobs,results){
return (function (state_19328){
var state_val_19329 = (state_19328[(1)]);
if((state_val_19329 === (1))){
var state_19328__$1 = state_19328;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19328__$1,(2),res,v);
} else {
if((state_val_19329 === (2))){
var inst_19325 = (state_19328[(2)]);
var inst_19326 = cljs.core.async.close_BANG_.call(null,res);
var state_19328__$1 = (function (){var statearr_19330 = state_19328;
(statearr_19330[(7)] = inst_19325);

return statearr_19330;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19328__$1,inst_19326);
} else {
return null;
}
}
});})(c__11081__auto___19505,res,vec__19323,v,p,job,jobs,results))
;
return ((function (switch__10969__auto__,c__11081__auto___19505,res,vec__19323,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_19334 = [null,null,null,null,null,null,null,null];
(statearr_19334[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_19334[(1)] = (1));

return statearr_19334;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_19328){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19335){if((e19335 instanceof Object)){
var ex__10973__auto__ = e19335;
var statearr_19336_19506 = state_19328;
(statearr_19336_19506[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19328);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19335;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19507 = state_19328;
state_19328 = G__19507;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_19328){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_19328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___19505,res,vec__19323,v,p,job,jobs,results))
})();
var state__11083__auto__ = (function (){var statearr_19337 = f__11082__auto__.call(null);
(statearr_19337[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___19505);

return statearr_19337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___19505,res,vec__19323,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19338){
var vec__19339 = p__19338;
var v = cljs.core.nth.call(null,vec__19339,(0),null);
var p = cljs.core.nth.call(null,vec__19339,(1),null);
var job = vec__19339;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___19508 = n;
var __19509 = (0);
while(true){
if((__19509 < n__5571__auto___19508)){
var G__19340_19510 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19340_19510) {
case "compute":
var c__11081__auto___19512 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19509,c__11081__auto___19512,G__19340_19510,n__5571__auto___19508,jobs,results,process,async){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (__19509,c__11081__auto___19512,G__19340_19510,n__5571__auto___19508,jobs,results,process,async){
return (function (state_19353){
var state_val_19354 = (state_19353[(1)]);
if((state_val_19354 === (1))){
var state_19353__$1 = state_19353;
var statearr_19355_19513 = state_19353__$1;
(statearr_19355_19513[(2)] = null);

(statearr_19355_19513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (2))){
var state_19353__$1 = state_19353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19353__$1,(4),jobs);
} else {
if((state_val_19354 === (3))){
var inst_19351 = (state_19353[(2)]);
var state_19353__$1 = state_19353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19353__$1,inst_19351);
} else {
if((state_val_19354 === (4))){
var inst_19343 = (state_19353[(2)]);
var inst_19344 = process.call(null,inst_19343);
var state_19353__$1 = state_19353;
if(cljs.core.truth_(inst_19344)){
var statearr_19356_19514 = state_19353__$1;
(statearr_19356_19514[(1)] = (5));

} else {
var statearr_19357_19515 = state_19353__$1;
(statearr_19357_19515[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (5))){
var state_19353__$1 = state_19353;
var statearr_19358_19516 = state_19353__$1;
(statearr_19358_19516[(2)] = null);

(statearr_19358_19516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (6))){
var state_19353__$1 = state_19353;
var statearr_19359_19517 = state_19353__$1;
(statearr_19359_19517[(2)] = null);

(statearr_19359_19517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19354 === (7))){
var inst_19349 = (state_19353[(2)]);
var state_19353__$1 = state_19353;
var statearr_19360_19518 = state_19353__$1;
(statearr_19360_19518[(2)] = inst_19349);

(statearr_19360_19518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19509,c__11081__auto___19512,G__19340_19510,n__5571__auto___19508,jobs,results,process,async))
;
return ((function (__19509,switch__10969__auto__,c__11081__auto___19512,G__19340_19510,n__5571__auto___19508,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_19364 = [null,null,null,null,null,null,null];
(statearr_19364[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_19364[(1)] = (1));

return statearr_19364;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_19353){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19365){if((e19365 instanceof Object)){
var ex__10973__auto__ = e19365;
var statearr_19366_19519 = state_19353;
(statearr_19366_19519[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19365;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19520 = state_19353;
state_19353 = G__19520;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_19353){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_19353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(__19509,switch__10969__auto__,c__11081__auto___19512,G__19340_19510,n__5571__auto___19508,jobs,results,process,async))
})();
var state__11083__auto__ = (function (){var statearr_19367 = f__11082__auto__.call(null);
(statearr_19367[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___19512);

return statearr_19367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(__19509,c__11081__auto___19512,G__19340_19510,n__5571__auto___19508,jobs,results,process,async))
);


break;
case "async":
var c__11081__auto___19521 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19509,c__11081__auto___19521,G__19340_19510,n__5571__auto___19508,jobs,results,process,async){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (__19509,c__11081__auto___19521,G__19340_19510,n__5571__auto___19508,jobs,results,process,async){
return (function (state_19380){
var state_val_19381 = (state_19380[(1)]);
if((state_val_19381 === (1))){
var state_19380__$1 = state_19380;
var statearr_19382_19522 = state_19380__$1;
(statearr_19382_19522[(2)] = null);

(statearr_19382_19522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19381 === (2))){
var state_19380__$1 = state_19380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19380__$1,(4),jobs);
} else {
if((state_val_19381 === (3))){
var inst_19378 = (state_19380[(2)]);
var state_19380__$1 = state_19380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19380__$1,inst_19378);
} else {
if((state_val_19381 === (4))){
var inst_19370 = (state_19380[(2)]);
var inst_19371 = async.call(null,inst_19370);
var state_19380__$1 = state_19380;
if(cljs.core.truth_(inst_19371)){
var statearr_19383_19523 = state_19380__$1;
(statearr_19383_19523[(1)] = (5));

} else {
var statearr_19384_19524 = state_19380__$1;
(statearr_19384_19524[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19381 === (5))){
var state_19380__$1 = state_19380;
var statearr_19385_19525 = state_19380__$1;
(statearr_19385_19525[(2)] = null);

(statearr_19385_19525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19381 === (6))){
var state_19380__$1 = state_19380;
var statearr_19386_19526 = state_19380__$1;
(statearr_19386_19526[(2)] = null);

(statearr_19386_19526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19381 === (7))){
var inst_19376 = (state_19380[(2)]);
var state_19380__$1 = state_19380;
var statearr_19387_19527 = state_19380__$1;
(statearr_19387_19527[(2)] = inst_19376);

(statearr_19387_19527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19509,c__11081__auto___19521,G__19340_19510,n__5571__auto___19508,jobs,results,process,async))
;
return ((function (__19509,switch__10969__auto__,c__11081__auto___19521,G__19340_19510,n__5571__auto___19508,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_19391 = [null,null,null,null,null,null,null];
(statearr_19391[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_19391[(1)] = (1));

return statearr_19391;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_19380){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19392){if((e19392 instanceof Object)){
var ex__10973__auto__ = e19392;
var statearr_19393_19528 = state_19380;
(statearr_19393_19528[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19380);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19392;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19529 = state_19380;
state_19380 = G__19529;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_19380){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_19380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(__19509,switch__10969__auto__,c__11081__auto___19521,G__19340_19510,n__5571__auto___19508,jobs,results,process,async))
})();
var state__11083__auto__ = (function (){var statearr_19394 = f__11082__auto__.call(null);
(statearr_19394[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___19521);

return statearr_19394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(__19509,c__11081__auto___19521,G__19340_19510,n__5571__auto___19508,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19530 = (__19509 + (1));
__19509 = G__19530;
continue;
} else {
}
break;
}

var c__11081__auto___19531 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___19531,jobs,results,process,async){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___19531,jobs,results,process,async){
return (function (state_19416){
var state_val_19417 = (state_19416[(1)]);
if((state_val_19417 === (1))){
var state_19416__$1 = state_19416;
var statearr_19418_19532 = state_19416__$1;
(statearr_19418_19532[(2)] = null);

(statearr_19418_19532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19417 === (2))){
var state_19416__$1 = state_19416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19416__$1,(4),from);
} else {
if((state_val_19417 === (3))){
var inst_19414 = (state_19416[(2)]);
var state_19416__$1 = state_19416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19416__$1,inst_19414);
} else {
if((state_val_19417 === (4))){
var inst_19397 = (state_19416[(7)]);
var inst_19397__$1 = (state_19416[(2)]);
var inst_19398 = (inst_19397__$1 == null);
var state_19416__$1 = (function (){var statearr_19419 = state_19416;
(statearr_19419[(7)] = inst_19397__$1);

return statearr_19419;
})();
if(cljs.core.truth_(inst_19398)){
var statearr_19420_19533 = state_19416__$1;
(statearr_19420_19533[(1)] = (5));

} else {
var statearr_19421_19534 = state_19416__$1;
(statearr_19421_19534[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19417 === (5))){
var inst_19400 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19416__$1 = state_19416;
var statearr_19422_19535 = state_19416__$1;
(statearr_19422_19535[(2)] = inst_19400);

(statearr_19422_19535[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19417 === (6))){
var inst_19402 = (state_19416[(8)]);
var inst_19397 = (state_19416[(7)]);
var inst_19402__$1 = cljs.core.async.chan.call(null,(1));
var inst_19403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19404 = [inst_19397,inst_19402__$1];
var inst_19405 = (new cljs.core.PersistentVector(null,2,(5),inst_19403,inst_19404,null));
var state_19416__$1 = (function (){var statearr_19423 = state_19416;
(statearr_19423[(8)] = inst_19402__$1);

return statearr_19423;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19416__$1,(8),jobs,inst_19405);
} else {
if((state_val_19417 === (7))){
var inst_19412 = (state_19416[(2)]);
var state_19416__$1 = state_19416;
var statearr_19424_19536 = state_19416__$1;
(statearr_19424_19536[(2)] = inst_19412);

(statearr_19424_19536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19417 === (8))){
var inst_19402 = (state_19416[(8)]);
var inst_19407 = (state_19416[(2)]);
var state_19416__$1 = (function (){var statearr_19425 = state_19416;
(statearr_19425[(9)] = inst_19407);

return statearr_19425;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19416__$1,(9),results,inst_19402);
} else {
if((state_val_19417 === (9))){
var inst_19409 = (state_19416[(2)]);
var state_19416__$1 = (function (){var statearr_19426 = state_19416;
(statearr_19426[(10)] = inst_19409);

return statearr_19426;
})();
var statearr_19427_19537 = state_19416__$1;
(statearr_19427_19537[(2)] = null);

(statearr_19427_19537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___19531,jobs,results,process,async))
;
return ((function (switch__10969__auto__,c__11081__auto___19531,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_19431 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19431[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_19431[(1)] = (1));

return statearr_19431;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_19416){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19432){if((e19432 instanceof Object)){
var ex__10973__auto__ = e19432;
var statearr_19433_19538 = state_19416;
(statearr_19433_19538[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19416);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19432;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19539 = state_19416;
state_19416 = G__19539;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_19416){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_19416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___19531,jobs,results,process,async))
})();
var state__11083__auto__ = (function (){var statearr_19434 = f__11082__auto__.call(null);
(statearr_19434[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___19531);

return statearr_19434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___19531,jobs,results,process,async))
);


var c__11081__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto__,jobs,results,process,async){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto__,jobs,results,process,async){
return (function (state_19472){
var state_val_19473 = (state_19472[(1)]);
if((state_val_19473 === (7))){
var inst_19468 = (state_19472[(2)]);
var state_19472__$1 = state_19472;
var statearr_19474_19540 = state_19472__$1;
(statearr_19474_19540[(2)] = inst_19468);

(statearr_19474_19540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (20))){
var state_19472__$1 = state_19472;
var statearr_19475_19541 = state_19472__$1;
(statearr_19475_19541[(2)] = null);

(statearr_19475_19541[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (1))){
var state_19472__$1 = state_19472;
var statearr_19476_19542 = state_19472__$1;
(statearr_19476_19542[(2)] = null);

(statearr_19476_19542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (4))){
var inst_19437 = (state_19472[(7)]);
var inst_19437__$1 = (state_19472[(2)]);
var inst_19438 = (inst_19437__$1 == null);
var state_19472__$1 = (function (){var statearr_19477 = state_19472;
(statearr_19477[(7)] = inst_19437__$1);

return statearr_19477;
})();
if(cljs.core.truth_(inst_19438)){
var statearr_19478_19543 = state_19472__$1;
(statearr_19478_19543[(1)] = (5));

} else {
var statearr_19479_19544 = state_19472__$1;
(statearr_19479_19544[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (15))){
var inst_19450 = (state_19472[(8)]);
var state_19472__$1 = state_19472;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19472__$1,(18),to,inst_19450);
} else {
if((state_val_19473 === (21))){
var inst_19463 = (state_19472[(2)]);
var state_19472__$1 = state_19472;
var statearr_19480_19545 = state_19472__$1;
(statearr_19480_19545[(2)] = inst_19463);

(statearr_19480_19545[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (13))){
var inst_19465 = (state_19472[(2)]);
var state_19472__$1 = (function (){var statearr_19481 = state_19472;
(statearr_19481[(9)] = inst_19465);

return statearr_19481;
})();
var statearr_19482_19546 = state_19472__$1;
(statearr_19482_19546[(2)] = null);

(statearr_19482_19546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (6))){
var inst_19437 = (state_19472[(7)]);
var state_19472__$1 = state_19472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19472__$1,(11),inst_19437);
} else {
if((state_val_19473 === (17))){
var inst_19458 = (state_19472[(2)]);
var state_19472__$1 = state_19472;
if(cljs.core.truth_(inst_19458)){
var statearr_19483_19547 = state_19472__$1;
(statearr_19483_19547[(1)] = (19));

} else {
var statearr_19484_19548 = state_19472__$1;
(statearr_19484_19548[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (3))){
var inst_19470 = (state_19472[(2)]);
var state_19472__$1 = state_19472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19472__$1,inst_19470);
} else {
if((state_val_19473 === (12))){
var inst_19447 = (state_19472[(10)]);
var state_19472__$1 = state_19472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19472__$1,(14),inst_19447);
} else {
if((state_val_19473 === (2))){
var state_19472__$1 = state_19472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19472__$1,(4),results);
} else {
if((state_val_19473 === (19))){
var state_19472__$1 = state_19472;
var statearr_19485_19549 = state_19472__$1;
(statearr_19485_19549[(2)] = null);

(statearr_19485_19549[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (11))){
var inst_19447 = (state_19472[(2)]);
var state_19472__$1 = (function (){var statearr_19486 = state_19472;
(statearr_19486[(10)] = inst_19447);

return statearr_19486;
})();
var statearr_19487_19550 = state_19472__$1;
(statearr_19487_19550[(2)] = null);

(statearr_19487_19550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (9))){
var state_19472__$1 = state_19472;
var statearr_19488_19551 = state_19472__$1;
(statearr_19488_19551[(2)] = null);

(statearr_19488_19551[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (5))){
var state_19472__$1 = state_19472;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19489_19552 = state_19472__$1;
(statearr_19489_19552[(1)] = (8));

} else {
var statearr_19490_19553 = state_19472__$1;
(statearr_19490_19553[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (14))){
var inst_19452 = (state_19472[(11)]);
var inst_19450 = (state_19472[(8)]);
var inst_19450__$1 = (state_19472[(2)]);
var inst_19451 = (inst_19450__$1 == null);
var inst_19452__$1 = cljs.core.not.call(null,inst_19451);
var state_19472__$1 = (function (){var statearr_19491 = state_19472;
(statearr_19491[(11)] = inst_19452__$1);

(statearr_19491[(8)] = inst_19450__$1);

return statearr_19491;
})();
if(inst_19452__$1){
var statearr_19492_19554 = state_19472__$1;
(statearr_19492_19554[(1)] = (15));

} else {
var statearr_19493_19555 = state_19472__$1;
(statearr_19493_19555[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (16))){
var inst_19452 = (state_19472[(11)]);
var state_19472__$1 = state_19472;
var statearr_19494_19556 = state_19472__$1;
(statearr_19494_19556[(2)] = inst_19452);

(statearr_19494_19556[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (10))){
var inst_19444 = (state_19472[(2)]);
var state_19472__$1 = state_19472;
var statearr_19495_19557 = state_19472__$1;
(statearr_19495_19557[(2)] = inst_19444);

(statearr_19495_19557[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (18))){
var inst_19455 = (state_19472[(2)]);
var state_19472__$1 = state_19472;
var statearr_19496_19558 = state_19472__$1;
(statearr_19496_19558[(2)] = inst_19455);

(statearr_19496_19558[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19473 === (8))){
var inst_19441 = cljs.core.async.close_BANG_.call(null,to);
var state_19472__$1 = state_19472;
var statearr_19497_19559 = state_19472__$1;
(statearr_19497_19559[(2)] = inst_19441);

(statearr_19497_19559[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto__,jobs,results,process,async))
;
return ((function (switch__10969__auto__,c__11081__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_19501 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19501[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_19501[(1)] = (1));

return statearr_19501;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_19472){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19502){if((e19502 instanceof Object)){
var ex__10973__auto__ = e19502;
var statearr_19503_19560 = state_19472;
(statearr_19503_19560[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19472);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19561 = state_19472;
state_19472 = G__19561;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_19472){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_19472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto__,jobs,results,process,async))
})();
var state__11083__auto__ = (function (){var statearr_19504 = f__11082__auto__.call(null);
(statearr_19504[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto__);

return statearr_19504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto__,jobs,results,process,async))
);

return c__11081__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19562 = [];
var len__5726__auto___19565 = arguments.length;
var i__5727__auto___19566 = (0);
while(true){
if((i__5727__auto___19566 < len__5726__auto___19565)){
args19562.push((arguments[i__5727__auto___19566]));

var G__19567 = (i__5727__auto___19566 + (1));
i__5727__auto___19566 = G__19567;
continue;
} else {
}
break;
}

var G__19564 = args19562.length;
switch (G__19564) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19562.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19569 = [];
var len__5726__auto___19572 = arguments.length;
var i__5727__auto___19573 = (0);
while(true){
if((i__5727__auto___19573 < len__5726__auto___19572)){
args19569.push((arguments[i__5727__auto___19573]));

var G__19574 = (i__5727__auto___19573 + (1));
i__5727__auto___19573 = G__19574;
continue;
} else {
}
break;
}

var G__19571 = args19569.length;
switch (G__19571) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19569.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19576 = [];
var len__5726__auto___19629 = arguments.length;
var i__5727__auto___19630 = (0);
while(true){
if((i__5727__auto___19630 < len__5726__auto___19629)){
args19576.push((arguments[i__5727__auto___19630]));

var G__19631 = (i__5727__auto___19630 + (1));
i__5727__auto___19630 = G__19631;
continue;
} else {
}
break;
}

var G__19578 = args19576.length;
switch (G__19578) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19576.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11081__auto___19633 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___19633,tc,fc){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___19633,tc,fc){
return (function (state_19604){
var state_val_19605 = (state_19604[(1)]);
if((state_val_19605 === (7))){
var inst_19600 = (state_19604[(2)]);
var state_19604__$1 = state_19604;
var statearr_19606_19634 = state_19604__$1;
(statearr_19606_19634[(2)] = inst_19600);

(statearr_19606_19634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (1))){
var state_19604__$1 = state_19604;
var statearr_19607_19635 = state_19604__$1;
(statearr_19607_19635[(2)] = null);

(statearr_19607_19635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (4))){
var inst_19581 = (state_19604[(7)]);
var inst_19581__$1 = (state_19604[(2)]);
var inst_19582 = (inst_19581__$1 == null);
var state_19604__$1 = (function (){var statearr_19608 = state_19604;
(statearr_19608[(7)] = inst_19581__$1);

return statearr_19608;
})();
if(cljs.core.truth_(inst_19582)){
var statearr_19609_19636 = state_19604__$1;
(statearr_19609_19636[(1)] = (5));

} else {
var statearr_19610_19637 = state_19604__$1;
(statearr_19610_19637[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (13))){
var state_19604__$1 = state_19604;
var statearr_19611_19638 = state_19604__$1;
(statearr_19611_19638[(2)] = null);

(statearr_19611_19638[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (6))){
var inst_19581 = (state_19604[(7)]);
var inst_19587 = p.call(null,inst_19581);
var state_19604__$1 = state_19604;
if(cljs.core.truth_(inst_19587)){
var statearr_19612_19639 = state_19604__$1;
(statearr_19612_19639[(1)] = (9));

} else {
var statearr_19613_19640 = state_19604__$1;
(statearr_19613_19640[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (3))){
var inst_19602 = (state_19604[(2)]);
var state_19604__$1 = state_19604;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19604__$1,inst_19602);
} else {
if((state_val_19605 === (12))){
var state_19604__$1 = state_19604;
var statearr_19614_19641 = state_19604__$1;
(statearr_19614_19641[(2)] = null);

(statearr_19614_19641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (2))){
var state_19604__$1 = state_19604;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19604__$1,(4),ch);
} else {
if((state_val_19605 === (11))){
var inst_19581 = (state_19604[(7)]);
var inst_19591 = (state_19604[(2)]);
var state_19604__$1 = state_19604;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19604__$1,(8),inst_19591,inst_19581);
} else {
if((state_val_19605 === (9))){
var state_19604__$1 = state_19604;
var statearr_19615_19642 = state_19604__$1;
(statearr_19615_19642[(2)] = tc);

(statearr_19615_19642[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (5))){
var inst_19584 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19585 = cljs.core.async.close_BANG_.call(null,fc);
var state_19604__$1 = (function (){var statearr_19616 = state_19604;
(statearr_19616[(8)] = inst_19584);

return statearr_19616;
})();
var statearr_19617_19643 = state_19604__$1;
(statearr_19617_19643[(2)] = inst_19585);

(statearr_19617_19643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (14))){
var inst_19598 = (state_19604[(2)]);
var state_19604__$1 = state_19604;
var statearr_19618_19644 = state_19604__$1;
(statearr_19618_19644[(2)] = inst_19598);

(statearr_19618_19644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (10))){
var state_19604__$1 = state_19604;
var statearr_19619_19645 = state_19604__$1;
(statearr_19619_19645[(2)] = fc);

(statearr_19619_19645[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19605 === (8))){
var inst_19593 = (state_19604[(2)]);
var state_19604__$1 = state_19604;
if(cljs.core.truth_(inst_19593)){
var statearr_19620_19646 = state_19604__$1;
(statearr_19620_19646[(1)] = (12));

} else {
var statearr_19621_19647 = state_19604__$1;
(statearr_19621_19647[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___19633,tc,fc))
;
return ((function (switch__10969__auto__,c__11081__auto___19633,tc,fc){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_19625 = [null,null,null,null,null,null,null,null,null];
(statearr_19625[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_19625[(1)] = (1));

return statearr_19625;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_19604){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19604);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19626){if((e19626 instanceof Object)){
var ex__10973__auto__ = e19626;
var statearr_19627_19648 = state_19604;
(statearr_19627_19648[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19604);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19626;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19649 = state_19604;
state_19604 = G__19649;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_19604){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_19604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___19633,tc,fc))
})();
var state__11083__auto__ = (function (){var statearr_19628 = f__11082__auto__.call(null);
(statearr_19628[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___19633);

return statearr_19628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___19633,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11081__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto__){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto__){
return (function (state_19713){
var state_val_19714 = (state_19713[(1)]);
if((state_val_19714 === (7))){
var inst_19709 = (state_19713[(2)]);
var state_19713__$1 = state_19713;
var statearr_19715_19736 = state_19713__$1;
(statearr_19715_19736[(2)] = inst_19709);

(statearr_19715_19736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19714 === (1))){
var inst_19693 = init;
var state_19713__$1 = (function (){var statearr_19716 = state_19713;
(statearr_19716[(7)] = inst_19693);

return statearr_19716;
})();
var statearr_19717_19737 = state_19713__$1;
(statearr_19717_19737[(2)] = null);

(statearr_19717_19737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19714 === (4))){
var inst_19696 = (state_19713[(8)]);
var inst_19696__$1 = (state_19713[(2)]);
var inst_19697 = (inst_19696__$1 == null);
var state_19713__$1 = (function (){var statearr_19718 = state_19713;
(statearr_19718[(8)] = inst_19696__$1);

return statearr_19718;
})();
if(cljs.core.truth_(inst_19697)){
var statearr_19719_19738 = state_19713__$1;
(statearr_19719_19738[(1)] = (5));

} else {
var statearr_19720_19739 = state_19713__$1;
(statearr_19720_19739[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19714 === (6))){
var inst_19700 = (state_19713[(9)]);
var inst_19693 = (state_19713[(7)]);
var inst_19696 = (state_19713[(8)]);
var inst_19700__$1 = f.call(null,inst_19693,inst_19696);
var inst_19701 = cljs.core.reduced_QMARK_.call(null,inst_19700__$1);
var state_19713__$1 = (function (){var statearr_19721 = state_19713;
(statearr_19721[(9)] = inst_19700__$1);

return statearr_19721;
})();
if(inst_19701){
var statearr_19722_19740 = state_19713__$1;
(statearr_19722_19740[(1)] = (8));

} else {
var statearr_19723_19741 = state_19713__$1;
(statearr_19723_19741[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19714 === (3))){
var inst_19711 = (state_19713[(2)]);
var state_19713__$1 = state_19713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19713__$1,inst_19711);
} else {
if((state_val_19714 === (2))){
var state_19713__$1 = state_19713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19713__$1,(4),ch);
} else {
if((state_val_19714 === (9))){
var inst_19700 = (state_19713[(9)]);
var inst_19693 = inst_19700;
var state_19713__$1 = (function (){var statearr_19724 = state_19713;
(statearr_19724[(7)] = inst_19693);

return statearr_19724;
})();
var statearr_19725_19742 = state_19713__$1;
(statearr_19725_19742[(2)] = null);

(statearr_19725_19742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19714 === (5))){
var inst_19693 = (state_19713[(7)]);
var state_19713__$1 = state_19713;
var statearr_19726_19743 = state_19713__$1;
(statearr_19726_19743[(2)] = inst_19693);

(statearr_19726_19743[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19714 === (10))){
var inst_19707 = (state_19713[(2)]);
var state_19713__$1 = state_19713;
var statearr_19727_19744 = state_19713__$1;
(statearr_19727_19744[(2)] = inst_19707);

(statearr_19727_19744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19714 === (8))){
var inst_19700 = (state_19713[(9)]);
var inst_19703 = cljs.core.deref.call(null,inst_19700);
var state_19713__$1 = state_19713;
var statearr_19728_19745 = state_19713__$1;
(statearr_19728_19745[(2)] = inst_19703);

(statearr_19728_19745[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto__))
;
return ((function (switch__10969__auto__,c__11081__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10970__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10970__auto____0 = (function (){
var statearr_19732 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19732[(0)] = cljs$core$async$reduce_$_state_machine__10970__auto__);

(statearr_19732[(1)] = (1));

return statearr_19732;
});
var cljs$core$async$reduce_$_state_machine__10970__auto____1 = (function (state_19713){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19733){if((e19733 instanceof Object)){
var ex__10973__auto__ = e19733;
var statearr_19734_19746 = state_19713;
(statearr_19734_19746[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19713);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19733;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19747 = state_19713;
state_19713 = G__19747;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10970__auto__ = function(state_19713){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10970__auto____1.call(this,state_19713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10970__auto____0;
cljs$core$async$reduce_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10970__auto____1;
return cljs$core$async$reduce_$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto__))
})();
var state__11083__auto__ = (function (){var statearr_19735 = f__11082__auto__.call(null);
(statearr_19735[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto__);

return statearr_19735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto__))
);

return c__11081__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19748 = [];
var len__5726__auto___19800 = arguments.length;
var i__5727__auto___19801 = (0);
while(true){
if((i__5727__auto___19801 < len__5726__auto___19800)){
args19748.push((arguments[i__5727__auto___19801]));

var G__19802 = (i__5727__auto___19801 + (1));
i__5727__auto___19801 = G__19802;
continue;
} else {
}
break;
}

var G__19750 = args19748.length;
switch (G__19750) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19748.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11081__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto__){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto__){
return (function (state_19775){
var state_val_19776 = (state_19775[(1)]);
if((state_val_19776 === (7))){
var inst_19757 = (state_19775[(2)]);
var state_19775__$1 = state_19775;
var statearr_19777_19804 = state_19775__$1;
(statearr_19777_19804[(2)] = inst_19757);

(statearr_19777_19804[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (1))){
var inst_19751 = cljs.core.seq.call(null,coll);
var inst_19752 = inst_19751;
var state_19775__$1 = (function (){var statearr_19778 = state_19775;
(statearr_19778[(7)] = inst_19752);

return statearr_19778;
})();
var statearr_19779_19805 = state_19775__$1;
(statearr_19779_19805[(2)] = null);

(statearr_19779_19805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (4))){
var inst_19752 = (state_19775[(7)]);
var inst_19755 = cljs.core.first.call(null,inst_19752);
var state_19775__$1 = state_19775;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19775__$1,(7),ch,inst_19755);
} else {
if((state_val_19776 === (13))){
var inst_19769 = (state_19775[(2)]);
var state_19775__$1 = state_19775;
var statearr_19780_19806 = state_19775__$1;
(statearr_19780_19806[(2)] = inst_19769);

(statearr_19780_19806[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (6))){
var inst_19760 = (state_19775[(2)]);
var state_19775__$1 = state_19775;
if(cljs.core.truth_(inst_19760)){
var statearr_19781_19807 = state_19775__$1;
(statearr_19781_19807[(1)] = (8));

} else {
var statearr_19782_19808 = state_19775__$1;
(statearr_19782_19808[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (3))){
var inst_19773 = (state_19775[(2)]);
var state_19775__$1 = state_19775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19775__$1,inst_19773);
} else {
if((state_val_19776 === (12))){
var state_19775__$1 = state_19775;
var statearr_19783_19809 = state_19775__$1;
(statearr_19783_19809[(2)] = null);

(statearr_19783_19809[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (2))){
var inst_19752 = (state_19775[(7)]);
var state_19775__$1 = state_19775;
if(cljs.core.truth_(inst_19752)){
var statearr_19784_19810 = state_19775__$1;
(statearr_19784_19810[(1)] = (4));

} else {
var statearr_19785_19811 = state_19775__$1;
(statearr_19785_19811[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (11))){
var inst_19766 = cljs.core.async.close_BANG_.call(null,ch);
var state_19775__$1 = state_19775;
var statearr_19786_19812 = state_19775__$1;
(statearr_19786_19812[(2)] = inst_19766);

(statearr_19786_19812[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (9))){
var state_19775__$1 = state_19775;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19787_19813 = state_19775__$1;
(statearr_19787_19813[(1)] = (11));

} else {
var statearr_19788_19814 = state_19775__$1;
(statearr_19788_19814[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (5))){
var inst_19752 = (state_19775[(7)]);
var state_19775__$1 = state_19775;
var statearr_19789_19815 = state_19775__$1;
(statearr_19789_19815[(2)] = inst_19752);

(statearr_19789_19815[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (10))){
var inst_19771 = (state_19775[(2)]);
var state_19775__$1 = state_19775;
var statearr_19790_19816 = state_19775__$1;
(statearr_19790_19816[(2)] = inst_19771);

(statearr_19790_19816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19776 === (8))){
var inst_19752 = (state_19775[(7)]);
var inst_19762 = cljs.core.next.call(null,inst_19752);
var inst_19752__$1 = inst_19762;
var state_19775__$1 = (function (){var statearr_19791 = state_19775;
(statearr_19791[(7)] = inst_19752__$1);

return statearr_19791;
})();
var statearr_19792_19817 = state_19775__$1;
(statearr_19792_19817[(2)] = null);

(statearr_19792_19817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto__))
;
return ((function (switch__10969__auto__,c__11081__auto__){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_19796 = [null,null,null,null,null,null,null,null];
(statearr_19796[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_19796[(1)] = (1));

return statearr_19796;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_19775){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_19775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e19797){if((e19797 instanceof Object)){
var ex__10973__auto__ = e19797;
var statearr_19798_19818 = state_19775;
(statearr_19798_19818[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19775);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19797;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19819 = state_19775;
state_19775 = G__19819;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_19775){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_19775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto__))
})();
var state__11083__auto__ = (function (){var statearr_19799 = f__11082__auto__.call(null);
(statearr_19799[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto__);

return statearr_19799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto__))
);

return c__11081__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20041 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20041 = (function (mult,ch,cs,meta20042){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta20042 = meta20042;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20041.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_20043,meta20042__$1){
var self__ = this;
var _20043__$1 = this;
return (new cljs.core.async.t_cljs$core$async20041(self__.mult,self__.ch,self__.cs,meta20042__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async20041.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_20043){
var self__ = this;
var _20043__$1 = this;
return self__.meta20042;
});})(cs))
;

cljs.core.async.t_cljs$core$async20041.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20041.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async20041.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async20041.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20041.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20041.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20041.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20042","meta20042",2029954921,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async20041.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20041.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20041";

cljs.core.async.t_cljs$core$async20041.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20041");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async20041 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async20041(mult__$1,ch__$1,cs__$1,meta20042){
return (new cljs.core.async.t_cljs$core$async20041(mult__$1,ch__$1,cs__$1,meta20042));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async20041(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11081__auto___20262 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___20262,cs,m,dchan,dctr,done){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___20262,cs,m,dchan,dctr,done){
return (function (state_20174){
var state_val_20175 = (state_20174[(1)]);
if((state_val_20175 === (7))){
var inst_20170 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20176_20263 = state_20174__$1;
(statearr_20176_20263[(2)] = inst_20170);

(statearr_20176_20263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (20))){
var inst_20075 = (state_20174[(7)]);
var inst_20085 = cljs.core.first.call(null,inst_20075);
var inst_20086 = cljs.core.nth.call(null,inst_20085,(0),null);
var inst_20087 = cljs.core.nth.call(null,inst_20085,(1),null);
var state_20174__$1 = (function (){var statearr_20177 = state_20174;
(statearr_20177[(8)] = inst_20086);

return statearr_20177;
})();
if(cljs.core.truth_(inst_20087)){
var statearr_20178_20264 = state_20174__$1;
(statearr_20178_20264[(1)] = (22));

} else {
var statearr_20179_20265 = state_20174__$1;
(statearr_20179_20265[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (27))){
var inst_20122 = (state_20174[(9)]);
var inst_20115 = (state_20174[(10)]);
var inst_20046 = (state_20174[(11)]);
var inst_20117 = (state_20174[(12)]);
var inst_20122__$1 = cljs.core._nth.call(null,inst_20115,inst_20117);
var inst_20123 = cljs.core.async.put_BANG_.call(null,inst_20122__$1,inst_20046,done);
var state_20174__$1 = (function (){var statearr_20180 = state_20174;
(statearr_20180[(9)] = inst_20122__$1);

return statearr_20180;
})();
if(cljs.core.truth_(inst_20123)){
var statearr_20181_20266 = state_20174__$1;
(statearr_20181_20266[(1)] = (30));

} else {
var statearr_20182_20267 = state_20174__$1;
(statearr_20182_20267[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (1))){
var state_20174__$1 = state_20174;
var statearr_20183_20268 = state_20174__$1;
(statearr_20183_20268[(2)] = null);

(statearr_20183_20268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (24))){
var inst_20075 = (state_20174[(7)]);
var inst_20092 = (state_20174[(2)]);
var inst_20093 = cljs.core.next.call(null,inst_20075);
var inst_20055 = inst_20093;
var inst_20056 = null;
var inst_20057 = (0);
var inst_20058 = (0);
var state_20174__$1 = (function (){var statearr_20184 = state_20174;
(statearr_20184[(13)] = inst_20092);

(statearr_20184[(14)] = inst_20058);

(statearr_20184[(15)] = inst_20057);

(statearr_20184[(16)] = inst_20056);

(statearr_20184[(17)] = inst_20055);

return statearr_20184;
})();
var statearr_20185_20269 = state_20174__$1;
(statearr_20185_20269[(2)] = null);

(statearr_20185_20269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (39))){
var state_20174__$1 = state_20174;
var statearr_20189_20270 = state_20174__$1;
(statearr_20189_20270[(2)] = null);

(statearr_20189_20270[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (4))){
var inst_20046 = (state_20174[(11)]);
var inst_20046__$1 = (state_20174[(2)]);
var inst_20047 = (inst_20046__$1 == null);
var state_20174__$1 = (function (){var statearr_20190 = state_20174;
(statearr_20190[(11)] = inst_20046__$1);

return statearr_20190;
})();
if(cljs.core.truth_(inst_20047)){
var statearr_20191_20271 = state_20174__$1;
(statearr_20191_20271[(1)] = (5));

} else {
var statearr_20192_20272 = state_20174__$1;
(statearr_20192_20272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (15))){
var inst_20058 = (state_20174[(14)]);
var inst_20057 = (state_20174[(15)]);
var inst_20056 = (state_20174[(16)]);
var inst_20055 = (state_20174[(17)]);
var inst_20071 = (state_20174[(2)]);
var inst_20072 = (inst_20058 + (1));
var tmp20186 = inst_20057;
var tmp20187 = inst_20056;
var tmp20188 = inst_20055;
var inst_20055__$1 = tmp20188;
var inst_20056__$1 = tmp20187;
var inst_20057__$1 = tmp20186;
var inst_20058__$1 = inst_20072;
var state_20174__$1 = (function (){var statearr_20193 = state_20174;
(statearr_20193[(14)] = inst_20058__$1);

(statearr_20193[(18)] = inst_20071);

(statearr_20193[(15)] = inst_20057__$1);

(statearr_20193[(16)] = inst_20056__$1);

(statearr_20193[(17)] = inst_20055__$1);

return statearr_20193;
})();
var statearr_20194_20273 = state_20174__$1;
(statearr_20194_20273[(2)] = null);

(statearr_20194_20273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (21))){
var inst_20096 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20198_20274 = state_20174__$1;
(statearr_20198_20274[(2)] = inst_20096);

(statearr_20198_20274[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (31))){
var inst_20122 = (state_20174[(9)]);
var inst_20126 = done.call(null,null);
var inst_20127 = cljs.core.async.untap_STAR_.call(null,m,inst_20122);
var state_20174__$1 = (function (){var statearr_20199 = state_20174;
(statearr_20199[(19)] = inst_20126);

return statearr_20199;
})();
var statearr_20200_20275 = state_20174__$1;
(statearr_20200_20275[(2)] = inst_20127);

(statearr_20200_20275[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (32))){
var inst_20115 = (state_20174[(10)]);
var inst_20114 = (state_20174[(20)]);
var inst_20116 = (state_20174[(21)]);
var inst_20117 = (state_20174[(12)]);
var inst_20129 = (state_20174[(2)]);
var inst_20130 = (inst_20117 + (1));
var tmp20195 = inst_20115;
var tmp20196 = inst_20114;
var tmp20197 = inst_20116;
var inst_20114__$1 = tmp20196;
var inst_20115__$1 = tmp20195;
var inst_20116__$1 = tmp20197;
var inst_20117__$1 = inst_20130;
var state_20174__$1 = (function (){var statearr_20201 = state_20174;
(statearr_20201[(10)] = inst_20115__$1);

(statearr_20201[(22)] = inst_20129);

(statearr_20201[(20)] = inst_20114__$1);

(statearr_20201[(21)] = inst_20116__$1);

(statearr_20201[(12)] = inst_20117__$1);

return statearr_20201;
})();
var statearr_20202_20276 = state_20174__$1;
(statearr_20202_20276[(2)] = null);

(statearr_20202_20276[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (40))){
var inst_20142 = (state_20174[(23)]);
var inst_20146 = done.call(null,null);
var inst_20147 = cljs.core.async.untap_STAR_.call(null,m,inst_20142);
var state_20174__$1 = (function (){var statearr_20203 = state_20174;
(statearr_20203[(24)] = inst_20146);

return statearr_20203;
})();
var statearr_20204_20277 = state_20174__$1;
(statearr_20204_20277[(2)] = inst_20147);

(statearr_20204_20277[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (33))){
var inst_20133 = (state_20174[(25)]);
var inst_20135 = cljs.core.chunked_seq_QMARK_.call(null,inst_20133);
var state_20174__$1 = state_20174;
if(inst_20135){
var statearr_20205_20278 = state_20174__$1;
(statearr_20205_20278[(1)] = (36));

} else {
var statearr_20206_20279 = state_20174__$1;
(statearr_20206_20279[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (13))){
var inst_20065 = (state_20174[(26)]);
var inst_20068 = cljs.core.async.close_BANG_.call(null,inst_20065);
var state_20174__$1 = state_20174;
var statearr_20207_20280 = state_20174__$1;
(statearr_20207_20280[(2)] = inst_20068);

(statearr_20207_20280[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (22))){
var inst_20086 = (state_20174[(8)]);
var inst_20089 = cljs.core.async.close_BANG_.call(null,inst_20086);
var state_20174__$1 = state_20174;
var statearr_20208_20281 = state_20174__$1;
(statearr_20208_20281[(2)] = inst_20089);

(statearr_20208_20281[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (36))){
var inst_20133 = (state_20174[(25)]);
var inst_20137 = cljs.core.chunk_first.call(null,inst_20133);
var inst_20138 = cljs.core.chunk_rest.call(null,inst_20133);
var inst_20139 = cljs.core.count.call(null,inst_20137);
var inst_20114 = inst_20138;
var inst_20115 = inst_20137;
var inst_20116 = inst_20139;
var inst_20117 = (0);
var state_20174__$1 = (function (){var statearr_20209 = state_20174;
(statearr_20209[(10)] = inst_20115);

(statearr_20209[(20)] = inst_20114);

(statearr_20209[(21)] = inst_20116);

(statearr_20209[(12)] = inst_20117);

return statearr_20209;
})();
var statearr_20210_20282 = state_20174__$1;
(statearr_20210_20282[(2)] = null);

(statearr_20210_20282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (41))){
var inst_20133 = (state_20174[(25)]);
var inst_20149 = (state_20174[(2)]);
var inst_20150 = cljs.core.next.call(null,inst_20133);
var inst_20114 = inst_20150;
var inst_20115 = null;
var inst_20116 = (0);
var inst_20117 = (0);
var state_20174__$1 = (function (){var statearr_20211 = state_20174;
(statearr_20211[(10)] = inst_20115);

(statearr_20211[(27)] = inst_20149);

(statearr_20211[(20)] = inst_20114);

(statearr_20211[(21)] = inst_20116);

(statearr_20211[(12)] = inst_20117);

return statearr_20211;
})();
var statearr_20212_20283 = state_20174__$1;
(statearr_20212_20283[(2)] = null);

(statearr_20212_20283[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (43))){
var state_20174__$1 = state_20174;
var statearr_20213_20284 = state_20174__$1;
(statearr_20213_20284[(2)] = null);

(statearr_20213_20284[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (29))){
var inst_20158 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20214_20285 = state_20174__$1;
(statearr_20214_20285[(2)] = inst_20158);

(statearr_20214_20285[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (44))){
var inst_20167 = (state_20174[(2)]);
var state_20174__$1 = (function (){var statearr_20215 = state_20174;
(statearr_20215[(28)] = inst_20167);

return statearr_20215;
})();
var statearr_20216_20286 = state_20174__$1;
(statearr_20216_20286[(2)] = null);

(statearr_20216_20286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (6))){
var inst_20106 = (state_20174[(29)]);
var inst_20105 = cljs.core.deref.call(null,cs);
var inst_20106__$1 = cljs.core.keys.call(null,inst_20105);
var inst_20107 = cljs.core.count.call(null,inst_20106__$1);
var inst_20108 = cljs.core.reset_BANG_.call(null,dctr,inst_20107);
var inst_20113 = cljs.core.seq.call(null,inst_20106__$1);
var inst_20114 = inst_20113;
var inst_20115 = null;
var inst_20116 = (0);
var inst_20117 = (0);
var state_20174__$1 = (function (){var statearr_20217 = state_20174;
(statearr_20217[(10)] = inst_20115);

(statearr_20217[(30)] = inst_20108);

(statearr_20217[(29)] = inst_20106__$1);

(statearr_20217[(20)] = inst_20114);

(statearr_20217[(21)] = inst_20116);

(statearr_20217[(12)] = inst_20117);

return statearr_20217;
})();
var statearr_20218_20287 = state_20174__$1;
(statearr_20218_20287[(2)] = null);

(statearr_20218_20287[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (28))){
var inst_20133 = (state_20174[(25)]);
var inst_20114 = (state_20174[(20)]);
var inst_20133__$1 = cljs.core.seq.call(null,inst_20114);
var state_20174__$1 = (function (){var statearr_20219 = state_20174;
(statearr_20219[(25)] = inst_20133__$1);

return statearr_20219;
})();
if(inst_20133__$1){
var statearr_20220_20288 = state_20174__$1;
(statearr_20220_20288[(1)] = (33));

} else {
var statearr_20221_20289 = state_20174__$1;
(statearr_20221_20289[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (25))){
var inst_20116 = (state_20174[(21)]);
var inst_20117 = (state_20174[(12)]);
var inst_20119 = (inst_20117 < inst_20116);
var inst_20120 = inst_20119;
var state_20174__$1 = state_20174;
if(cljs.core.truth_(inst_20120)){
var statearr_20222_20290 = state_20174__$1;
(statearr_20222_20290[(1)] = (27));

} else {
var statearr_20223_20291 = state_20174__$1;
(statearr_20223_20291[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (34))){
var state_20174__$1 = state_20174;
var statearr_20224_20292 = state_20174__$1;
(statearr_20224_20292[(2)] = null);

(statearr_20224_20292[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (17))){
var state_20174__$1 = state_20174;
var statearr_20225_20293 = state_20174__$1;
(statearr_20225_20293[(2)] = null);

(statearr_20225_20293[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (3))){
var inst_20172 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20174__$1,inst_20172);
} else {
if((state_val_20175 === (12))){
var inst_20101 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20226_20294 = state_20174__$1;
(statearr_20226_20294[(2)] = inst_20101);

(statearr_20226_20294[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (2))){
var state_20174__$1 = state_20174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20174__$1,(4),ch);
} else {
if((state_val_20175 === (23))){
var state_20174__$1 = state_20174;
var statearr_20227_20295 = state_20174__$1;
(statearr_20227_20295[(2)] = null);

(statearr_20227_20295[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (35))){
var inst_20156 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20228_20296 = state_20174__$1;
(statearr_20228_20296[(2)] = inst_20156);

(statearr_20228_20296[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (19))){
var inst_20075 = (state_20174[(7)]);
var inst_20079 = cljs.core.chunk_first.call(null,inst_20075);
var inst_20080 = cljs.core.chunk_rest.call(null,inst_20075);
var inst_20081 = cljs.core.count.call(null,inst_20079);
var inst_20055 = inst_20080;
var inst_20056 = inst_20079;
var inst_20057 = inst_20081;
var inst_20058 = (0);
var state_20174__$1 = (function (){var statearr_20229 = state_20174;
(statearr_20229[(14)] = inst_20058);

(statearr_20229[(15)] = inst_20057);

(statearr_20229[(16)] = inst_20056);

(statearr_20229[(17)] = inst_20055);

return statearr_20229;
})();
var statearr_20230_20297 = state_20174__$1;
(statearr_20230_20297[(2)] = null);

(statearr_20230_20297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (11))){
var inst_20055 = (state_20174[(17)]);
var inst_20075 = (state_20174[(7)]);
var inst_20075__$1 = cljs.core.seq.call(null,inst_20055);
var state_20174__$1 = (function (){var statearr_20231 = state_20174;
(statearr_20231[(7)] = inst_20075__$1);

return statearr_20231;
})();
if(inst_20075__$1){
var statearr_20232_20298 = state_20174__$1;
(statearr_20232_20298[(1)] = (16));

} else {
var statearr_20233_20299 = state_20174__$1;
(statearr_20233_20299[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (9))){
var inst_20103 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20234_20300 = state_20174__$1;
(statearr_20234_20300[(2)] = inst_20103);

(statearr_20234_20300[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (5))){
var inst_20053 = cljs.core.deref.call(null,cs);
var inst_20054 = cljs.core.seq.call(null,inst_20053);
var inst_20055 = inst_20054;
var inst_20056 = null;
var inst_20057 = (0);
var inst_20058 = (0);
var state_20174__$1 = (function (){var statearr_20235 = state_20174;
(statearr_20235[(14)] = inst_20058);

(statearr_20235[(15)] = inst_20057);

(statearr_20235[(16)] = inst_20056);

(statearr_20235[(17)] = inst_20055);

return statearr_20235;
})();
var statearr_20236_20301 = state_20174__$1;
(statearr_20236_20301[(2)] = null);

(statearr_20236_20301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (14))){
var state_20174__$1 = state_20174;
var statearr_20237_20302 = state_20174__$1;
(statearr_20237_20302[(2)] = null);

(statearr_20237_20302[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (45))){
var inst_20164 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20238_20303 = state_20174__$1;
(statearr_20238_20303[(2)] = inst_20164);

(statearr_20238_20303[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (26))){
var inst_20106 = (state_20174[(29)]);
var inst_20160 = (state_20174[(2)]);
var inst_20161 = cljs.core.seq.call(null,inst_20106);
var state_20174__$1 = (function (){var statearr_20239 = state_20174;
(statearr_20239[(31)] = inst_20160);

return statearr_20239;
})();
if(inst_20161){
var statearr_20240_20304 = state_20174__$1;
(statearr_20240_20304[(1)] = (42));

} else {
var statearr_20241_20305 = state_20174__$1;
(statearr_20241_20305[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (16))){
var inst_20075 = (state_20174[(7)]);
var inst_20077 = cljs.core.chunked_seq_QMARK_.call(null,inst_20075);
var state_20174__$1 = state_20174;
if(inst_20077){
var statearr_20242_20306 = state_20174__$1;
(statearr_20242_20306[(1)] = (19));

} else {
var statearr_20243_20307 = state_20174__$1;
(statearr_20243_20307[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (38))){
var inst_20153 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20244_20308 = state_20174__$1;
(statearr_20244_20308[(2)] = inst_20153);

(statearr_20244_20308[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (30))){
var state_20174__$1 = state_20174;
var statearr_20245_20309 = state_20174__$1;
(statearr_20245_20309[(2)] = null);

(statearr_20245_20309[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (10))){
var inst_20058 = (state_20174[(14)]);
var inst_20056 = (state_20174[(16)]);
var inst_20064 = cljs.core._nth.call(null,inst_20056,inst_20058);
var inst_20065 = cljs.core.nth.call(null,inst_20064,(0),null);
var inst_20066 = cljs.core.nth.call(null,inst_20064,(1),null);
var state_20174__$1 = (function (){var statearr_20246 = state_20174;
(statearr_20246[(26)] = inst_20065);

return statearr_20246;
})();
if(cljs.core.truth_(inst_20066)){
var statearr_20247_20310 = state_20174__$1;
(statearr_20247_20310[(1)] = (13));

} else {
var statearr_20248_20311 = state_20174__$1;
(statearr_20248_20311[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (18))){
var inst_20099 = (state_20174[(2)]);
var state_20174__$1 = state_20174;
var statearr_20249_20312 = state_20174__$1;
(statearr_20249_20312[(2)] = inst_20099);

(statearr_20249_20312[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (42))){
var state_20174__$1 = state_20174;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20174__$1,(45),dchan);
} else {
if((state_val_20175 === (37))){
var inst_20133 = (state_20174[(25)]);
var inst_20046 = (state_20174[(11)]);
var inst_20142 = (state_20174[(23)]);
var inst_20142__$1 = cljs.core.first.call(null,inst_20133);
var inst_20143 = cljs.core.async.put_BANG_.call(null,inst_20142__$1,inst_20046,done);
var state_20174__$1 = (function (){var statearr_20250 = state_20174;
(statearr_20250[(23)] = inst_20142__$1);

return statearr_20250;
})();
if(cljs.core.truth_(inst_20143)){
var statearr_20251_20313 = state_20174__$1;
(statearr_20251_20313[(1)] = (39));

} else {
var statearr_20252_20314 = state_20174__$1;
(statearr_20252_20314[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20175 === (8))){
var inst_20058 = (state_20174[(14)]);
var inst_20057 = (state_20174[(15)]);
var inst_20060 = (inst_20058 < inst_20057);
var inst_20061 = inst_20060;
var state_20174__$1 = state_20174;
if(cljs.core.truth_(inst_20061)){
var statearr_20253_20315 = state_20174__$1;
(statearr_20253_20315[(1)] = (10));

} else {
var statearr_20254_20316 = state_20174__$1;
(statearr_20254_20316[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___20262,cs,m,dchan,dctr,done))
;
return ((function (switch__10969__auto__,c__11081__auto___20262,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10970__auto__ = null;
var cljs$core$async$mult_$_state_machine__10970__auto____0 = (function (){
var statearr_20258 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20258[(0)] = cljs$core$async$mult_$_state_machine__10970__auto__);

(statearr_20258[(1)] = (1));

return statearr_20258;
});
var cljs$core$async$mult_$_state_machine__10970__auto____1 = (function (state_20174){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_20174);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e20259){if((e20259 instanceof Object)){
var ex__10973__auto__ = e20259;
var statearr_20260_20317 = state_20174;
(statearr_20260_20317[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20174);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20259;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20318 = state_20174;
state_20174 = G__20318;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10970__auto__ = function(state_20174){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10970__auto____1.call(this,state_20174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10970__auto____0;
cljs$core$async$mult_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10970__auto____1;
return cljs$core$async$mult_$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___20262,cs,m,dchan,dctr,done))
})();
var state__11083__auto__ = (function (){var statearr_20261 = f__11082__auto__.call(null);
(statearr_20261[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___20262);

return statearr_20261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___20262,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20319 = [];
var len__5726__auto___20322 = arguments.length;
var i__5727__auto___20323 = (0);
while(true){
if((i__5727__auto___20323 < len__5726__auto___20322)){
args20319.push((arguments[i__5727__auto___20323]));

var G__20324 = (i__5727__auto___20323 + (1));
i__5727__auto___20323 = G__20324;
continue;
} else {
}
break;
}

var G__20321 = args20319.length;
switch (G__20321) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20319.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20336 = arguments.length;
var i__5727__auto___20337 = (0);
while(true){
if((i__5727__auto___20337 < len__5726__auto___20336)){
args__5733__auto__.push((arguments[i__5727__auto___20337]));

var G__20338 = (i__5727__auto___20337 + (1));
i__5727__auto___20337 = G__20338;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20330){
var map__20331 = p__20330;
var map__20331__$1 = ((((!((map__20331 == null)))?((((map__20331.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20331.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20331):map__20331);
var opts = map__20331__$1;
var statearr_20333_20339 = state;
(statearr_20333_20339[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20331,map__20331__$1,opts){
return (function (val){
var statearr_20334_20340 = state;
(statearr_20334_20340[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20331,map__20331__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20335_20341 = state;
(statearr_20335_20341[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20326){
var G__20327 = cljs.core.first.call(null,seq20326);
var seq20326__$1 = cljs.core.next.call(null,seq20326);
var G__20328 = cljs.core.first.call(null,seq20326__$1);
var seq20326__$2 = cljs.core.next.call(null,seq20326__$1);
var G__20329 = cljs.core.first.call(null,seq20326__$2);
var seq20326__$3 = cljs.core.next.call(null,seq20326__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20327,G__20328,G__20329,seq20326__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20505 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20505 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20506){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20506 = meta20506;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20507,meta20506__$1){
var self__ = this;
var _20507__$1 = this;
return (new cljs.core.async.t_cljs$core$async20505(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20506__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20507){
var self__ = this;
var _20507__$1 = this;
return self__.meta20506;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20506","meta20506",2013816262,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20505.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20505.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20505";

cljs.core.async.t_cljs$core$async20505.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20505");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20505 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20505(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20506){
return (new cljs.core.async.t_cljs$core$async20505(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20506));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20505(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11081__auto___20668 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___20668,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___20668,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20605){
var state_val_20606 = (state_20605[(1)]);
if((state_val_20606 === (7))){
var inst_20523 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
var statearr_20607_20669 = state_20605__$1;
(statearr_20607_20669[(2)] = inst_20523);

(statearr_20607_20669[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (20))){
var inst_20535 = (state_20605[(7)]);
var state_20605__$1 = state_20605;
var statearr_20608_20670 = state_20605__$1;
(statearr_20608_20670[(2)] = inst_20535);

(statearr_20608_20670[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (27))){
var state_20605__$1 = state_20605;
var statearr_20609_20671 = state_20605__$1;
(statearr_20609_20671[(2)] = null);

(statearr_20609_20671[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (1))){
var inst_20511 = (state_20605[(8)]);
var inst_20511__$1 = calc_state.call(null);
var inst_20513 = (inst_20511__$1 == null);
var inst_20514 = cljs.core.not.call(null,inst_20513);
var state_20605__$1 = (function (){var statearr_20610 = state_20605;
(statearr_20610[(8)] = inst_20511__$1);

return statearr_20610;
})();
if(inst_20514){
var statearr_20611_20672 = state_20605__$1;
(statearr_20611_20672[(1)] = (2));

} else {
var statearr_20612_20673 = state_20605__$1;
(statearr_20612_20673[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (24))){
var inst_20565 = (state_20605[(9)]);
var inst_20558 = (state_20605[(10)]);
var inst_20579 = (state_20605[(11)]);
var inst_20579__$1 = inst_20558.call(null,inst_20565);
var state_20605__$1 = (function (){var statearr_20613 = state_20605;
(statearr_20613[(11)] = inst_20579__$1);

return statearr_20613;
})();
if(cljs.core.truth_(inst_20579__$1)){
var statearr_20614_20674 = state_20605__$1;
(statearr_20614_20674[(1)] = (29));

} else {
var statearr_20615_20675 = state_20605__$1;
(statearr_20615_20675[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (4))){
var inst_20526 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
if(cljs.core.truth_(inst_20526)){
var statearr_20616_20676 = state_20605__$1;
(statearr_20616_20676[(1)] = (8));

} else {
var statearr_20617_20677 = state_20605__$1;
(statearr_20617_20677[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (15))){
var inst_20552 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
if(cljs.core.truth_(inst_20552)){
var statearr_20618_20678 = state_20605__$1;
(statearr_20618_20678[(1)] = (19));

} else {
var statearr_20619_20679 = state_20605__$1;
(statearr_20619_20679[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (21))){
var inst_20557 = (state_20605[(12)]);
var inst_20557__$1 = (state_20605[(2)]);
var inst_20558 = cljs.core.get.call(null,inst_20557__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20559 = cljs.core.get.call(null,inst_20557__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20560 = cljs.core.get.call(null,inst_20557__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20605__$1 = (function (){var statearr_20620 = state_20605;
(statearr_20620[(10)] = inst_20558);

(statearr_20620[(13)] = inst_20559);

(statearr_20620[(12)] = inst_20557__$1);

return statearr_20620;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20605__$1,(22),inst_20560);
} else {
if((state_val_20606 === (31))){
var inst_20587 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
if(cljs.core.truth_(inst_20587)){
var statearr_20621_20680 = state_20605__$1;
(statearr_20621_20680[(1)] = (32));

} else {
var statearr_20622_20681 = state_20605__$1;
(statearr_20622_20681[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (32))){
var inst_20564 = (state_20605[(14)]);
var state_20605__$1 = state_20605;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20605__$1,(35),out,inst_20564);
} else {
if((state_val_20606 === (33))){
var inst_20557 = (state_20605[(12)]);
var inst_20535 = inst_20557;
var state_20605__$1 = (function (){var statearr_20623 = state_20605;
(statearr_20623[(7)] = inst_20535);

return statearr_20623;
})();
var statearr_20624_20682 = state_20605__$1;
(statearr_20624_20682[(2)] = null);

(statearr_20624_20682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (13))){
var inst_20535 = (state_20605[(7)]);
var inst_20542 = inst_20535.cljs$lang$protocol_mask$partition0$;
var inst_20543 = (inst_20542 & (64));
var inst_20544 = inst_20535.cljs$core$ISeq$;
var inst_20545 = (inst_20543) || (inst_20544);
var state_20605__$1 = state_20605;
if(cljs.core.truth_(inst_20545)){
var statearr_20625_20683 = state_20605__$1;
(statearr_20625_20683[(1)] = (16));

} else {
var statearr_20626_20684 = state_20605__$1;
(statearr_20626_20684[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (22))){
var inst_20564 = (state_20605[(14)]);
var inst_20565 = (state_20605[(9)]);
var inst_20563 = (state_20605[(2)]);
var inst_20564__$1 = cljs.core.nth.call(null,inst_20563,(0),null);
var inst_20565__$1 = cljs.core.nth.call(null,inst_20563,(1),null);
var inst_20566 = (inst_20564__$1 == null);
var inst_20567 = cljs.core._EQ_.call(null,inst_20565__$1,change);
var inst_20568 = (inst_20566) || (inst_20567);
var state_20605__$1 = (function (){var statearr_20627 = state_20605;
(statearr_20627[(14)] = inst_20564__$1);

(statearr_20627[(9)] = inst_20565__$1);

return statearr_20627;
})();
if(cljs.core.truth_(inst_20568)){
var statearr_20628_20685 = state_20605__$1;
(statearr_20628_20685[(1)] = (23));

} else {
var statearr_20629_20686 = state_20605__$1;
(statearr_20629_20686[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (36))){
var inst_20557 = (state_20605[(12)]);
var inst_20535 = inst_20557;
var state_20605__$1 = (function (){var statearr_20630 = state_20605;
(statearr_20630[(7)] = inst_20535);

return statearr_20630;
})();
var statearr_20631_20687 = state_20605__$1;
(statearr_20631_20687[(2)] = null);

(statearr_20631_20687[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (29))){
var inst_20579 = (state_20605[(11)]);
var state_20605__$1 = state_20605;
var statearr_20632_20688 = state_20605__$1;
(statearr_20632_20688[(2)] = inst_20579);

(statearr_20632_20688[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (6))){
var state_20605__$1 = state_20605;
var statearr_20633_20689 = state_20605__$1;
(statearr_20633_20689[(2)] = false);

(statearr_20633_20689[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (28))){
var inst_20575 = (state_20605[(2)]);
var inst_20576 = calc_state.call(null);
var inst_20535 = inst_20576;
var state_20605__$1 = (function (){var statearr_20634 = state_20605;
(statearr_20634[(15)] = inst_20575);

(statearr_20634[(7)] = inst_20535);

return statearr_20634;
})();
var statearr_20635_20690 = state_20605__$1;
(statearr_20635_20690[(2)] = null);

(statearr_20635_20690[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (25))){
var inst_20601 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
var statearr_20636_20691 = state_20605__$1;
(statearr_20636_20691[(2)] = inst_20601);

(statearr_20636_20691[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (34))){
var inst_20599 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
var statearr_20637_20692 = state_20605__$1;
(statearr_20637_20692[(2)] = inst_20599);

(statearr_20637_20692[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (17))){
var state_20605__$1 = state_20605;
var statearr_20638_20693 = state_20605__$1;
(statearr_20638_20693[(2)] = false);

(statearr_20638_20693[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (3))){
var state_20605__$1 = state_20605;
var statearr_20639_20694 = state_20605__$1;
(statearr_20639_20694[(2)] = false);

(statearr_20639_20694[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (12))){
var inst_20603 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20605__$1,inst_20603);
} else {
if((state_val_20606 === (2))){
var inst_20511 = (state_20605[(8)]);
var inst_20516 = inst_20511.cljs$lang$protocol_mask$partition0$;
var inst_20517 = (inst_20516 & (64));
var inst_20518 = inst_20511.cljs$core$ISeq$;
var inst_20519 = (inst_20517) || (inst_20518);
var state_20605__$1 = state_20605;
if(cljs.core.truth_(inst_20519)){
var statearr_20640_20695 = state_20605__$1;
(statearr_20640_20695[(1)] = (5));

} else {
var statearr_20641_20696 = state_20605__$1;
(statearr_20641_20696[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (23))){
var inst_20564 = (state_20605[(14)]);
var inst_20570 = (inst_20564 == null);
var state_20605__$1 = state_20605;
if(cljs.core.truth_(inst_20570)){
var statearr_20642_20697 = state_20605__$1;
(statearr_20642_20697[(1)] = (26));

} else {
var statearr_20643_20698 = state_20605__$1;
(statearr_20643_20698[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (35))){
var inst_20590 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
if(cljs.core.truth_(inst_20590)){
var statearr_20644_20699 = state_20605__$1;
(statearr_20644_20699[(1)] = (36));

} else {
var statearr_20645_20700 = state_20605__$1;
(statearr_20645_20700[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (19))){
var inst_20535 = (state_20605[(7)]);
var inst_20554 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20535);
var state_20605__$1 = state_20605;
var statearr_20646_20701 = state_20605__$1;
(statearr_20646_20701[(2)] = inst_20554);

(statearr_20646_20701[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (11))){
var inst_20535 = (state_20605[(7)]);
var inst_20539 = (inst_20535 == null);
var inst_20540 = cljs.core.not.call(null,inst_20539);
var state_20605__$1 = state_20605;
if(inst_20540){
var statearr_20647_20702 = state_20605__$1;
(statearr_20647_20702[(1)] = (13));

} else {
var statearr_20648_20703 = state_20605__$1;
(statearr_20648_20703[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (9))){
var inst_20511 = (state_20605[(8)]);
var state_20605__$1 = state_20605;
var statearr_20649_20704 = state_20605__$1;
(statearr_20649_20704[(2)] = inst_20511);

(statearr_20649_20704[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (5))){
var state_20605__$1 = state_20605;
var statearr_20650_20705 = state_20605__$1;
(statearr_20650_20705[(2)] = true);

(statearr_20650_20705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (14))){
var state_20605__$1 = state_20605;
var statearr_20651_20706 = state_20605__$1;
(statearr_20651_20706[(2)] = false);

(statearr_20651_20706[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (26))){
var inst_20565 = (state_20605[(9)]);
var inst_20572 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20565);
var state_20605__$1 = state_20605;
var statearr_20652_20707 = state_20605__$1;
(statearr_20652_20707[(2)] = inst_20572);

(statearr_20652_20707[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (16))){
var state_20605__$1 = state_20605;
var statearr_20653_20708 = state_20605__$1;
(statearr_20653_20708[(2)] = true);

(statearr_20653_20708[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (38))){
var inst_20595 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
var statearr_20654_20709 = state_20605__$1;
(statearr_20654_20709[(2)] = inst_20595);

(statearr_20654_20709[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (30))){
var inst_20565 = (state_20605[(9)]);
var inst_20558 = (state_20605[(10)]);
var inst_20559 = (state_20605[(13)]);
var inst_20582 = cljs.core.empty_QMARK_.call(null,inst_20558);
var inst_20583 = inst_20559.call(null,inst_20565);
var inst_20584 = cljs.core.not.call(null,inst_20583);
var inst_20585 = (inst_20582) && (inst_20584);
var state_20605__$1 = state_20605;
var statearr_20655_20710 = state_20605__$1;
(statearr_20655_20710[(2)] = inst_20585);

(statearr_20655_20710[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (10))){
var inst_20511 = (state_20605[(8)]);
var inst_20531 = (state_20605[(2)]);
var inst_20532 = cljs.core.get.call(null,inst_20531,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20533 = cljs.core.get.call(null,inst_20531,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20534 = cljs.core.get.call(null,inst_20531,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20535 = inst_20511;
var state_20605__$1 = (function (){var statearr_20656 = state_20605;
(statearr_20656[(16)] = inst_20534);

(statearr_20656[(17)] = inst_20533);

(statearr_20656[(18)] = inst_20532);

(statearr_20656[(7)] = inst_20535);

return statearr_20656;
})();
var statearr_20657_20711 = state_20605__$1;
(statearr_20657_20711[(2)] = null);

(statearr_20657_20711[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (18))){
var inst_20549 = (state_20605[(2)]);
var state_20605__$1 = state_20605;
var statearr_20658_20712 = state_20605__$1;
(statearr_20658_20712[(2)] = inst_20549);

(statearr_20658_20712[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (37))){
var state_20605__$1 = state_20605;
var statearr_20659_20713 = state_20605__$1;
(statearr_20659_20713[(2)] = null);

(statearr_20659_20713[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20606 === (8))){
var inst_20511 = (state_20605[(8)]);
var inst_20528 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20511);
var state_20605__$1 = state_20605;
var statearr_20660_20714 = state_20605__$1;
(statearr_20660_20714[(2)] = inst_20528);

(statearr_20660_20714[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___20668,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10969__auto__,c__11081__auto___20668,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10970__auto__ = null;
var cljs$core$async$mix_$_state_machine__10970__auto____0 = (function (){
var statearr_20664 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20664[(0)] = cljs$core$async$mix_$_state_machine__10970__auto__);

(statearr_20664[(1)] = (1));

return statearr_20664;
});
var cljs$core$async$mix_$_state_machine__10970__auto____1 = (function (state_20605){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_20605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e20665){if((e20665 instanceof Object)){
var ex__10973__auto__ = e20665;
var statearr_20666_20715 = state_20605;
(statearr_20666_20715[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20605);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20665;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20716 = state_20605;
state_20605 = G__20716;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10970__auto__ = function(state_20605){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10970__auto____1.call(this,state_20605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10970__auto____0;
cljs$core$async$mix_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10970__auto____1;
return cljs$core$async$mix_$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___20668,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11083__auto__ = (function (){var statearr_20667 = f__11082__auto__.call(null);
(statearr_20667[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___20668);

return statearr_20667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___20668,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20717 = [];
var len__5726__auto___20720 = arguments.length;
var i__5727__auto___20721 = (0);
while(true){
if((i__5727__auto___20721 < len__5726__auto___20720)){
args20717.push((arguments[i__5727__auto___20721]));

var G__20722 = (i__5727__auto___20721 + (1));
i__5727__auto___20721 = G__20722;
continue;
} else {
}
break;
}

var G__20719 = args20717.length;
switch (G__20719) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20717.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20725 = [];
var len__5726__auto___20850 = arguments.length;
var i__5727__auto___20851 = (0);
while(true){
if((i__5727__auto___20851 < len__5726__auto___20850)){
args20725.push((arguments[i__5727__auto___20851]));

var G__20852 = (i__5727__auto___20851 + (1));
i__5727__auto___20851 = G__20852;
continue;
} else {
}
break;
}

var G__20727 = args20725.length;
switch (G__20727) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20725.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__20724_SHARP_){
if(cljs.core.truth_(p1__20724_SHARP_.call(null,topic))){
return p1__20724_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20724_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20728 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20728 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20729){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20729 = meta20729;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20730,meta20729__$1){
var self__ = this;
var _20730__$1 = this;
return (new cljs.core.async.t_cljs$core$async20728(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20729__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20730){
var self__ = this;
var _20730__$1 = this;
return self__.meta20729;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20728.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20728.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20729","meta20729",-1070632828,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20728.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20728.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20728";

cljs.core.async.t_cljs$core$async20728.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20728");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20728 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20728(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20729){
return (new cljs.core.async.t_cljs$core$async20728(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20729));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20728(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11081__auto___20854 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___20854,mults,ensure_mult,p){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___20854,mults,ensure_mult,p){
return (function (state_20802){
var state_val_20803 = (state_20802[(1)]);
if((state_val_20803 === (7))){
var inst_20798 = (state_20802[(2)]);
var state_20802__$1 = state_20802;
var statearr_20804_20855 = state_20802__$1;
(statearr_20804_20855[(2)] = inst_20798);

(statearr_20804_20855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (20))){
var state_20802__$1 = state_20802;
var statearr_20805_20856 = state_20802__$1;
(statearr_20805_20856[(2)] = null);

(statearr_20805_20856[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (1))){
var state_20802__$1 = state_20802;
var statearr_20806_20857 = state_20802__$1;
(statearr_20806_20857[(2)] = null);

(statearr_20806_20857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (24))){
var inst_20781 = (state_20802[(7)]);
var inst_20790 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20781);
var state_20802__$1 = state_20802;
var statearr_20807_20858 = state_20802__$1;
(statearr_20807_20858[(2)] = inst_20790);

(statearr_20807_20858[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (4))){
var inst_20733 = (state_20802[(8)]);
var inst_20733__$1 = (state_20802[(2)]);
var inst_20734 = (inst_20733__$1 == null);
var state_20802__$1 = (function (){var statearr_20808 = state_20802;
(statearr_20808[(8)] = inst_20733__$1);

return statearr_20808;
})();
if(cljs.core.truth_(inst_20734)){
var statearr_20809_20859 = state_20802__$1;
(statearr_20809_20859[(1)] = (5));

} else {
var statearr_20810_20860 = state_20802__$1;
(statearr_20810_20860[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (15))){
var inst_20775 = (state_20802[(2)]);
var state_20802__$1 = state_20802;
var statearr_20811_20861 = state_20802__$1;
(statearr_20811_20861[(2)] = inst_20775);

(statearr_20811_20861[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (21))){
var inst_20795 = (state_20802[(2)]);
var state_20802__$1 = (function (){var statearr_20812 = state_20802;
(statearr_20812[(9)] = inst_20795);

return statearr_20812;
})();
var statearr_20813_20862 = state_20802__$1;
(statearr_20813_20862[(2)] = null);

(statearr_20813_20862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (13))){
var inst_20757 = (state_20802[(10)]);
var inst_20759 = cljs.core.chunked_seq_QMARK_.call(null,inst_20757);
var state_20802__$1 = state_20802;
if(inst_20759){
var statearr_20814_20863 = state_20802__$1;
(statearr_20814_20863[(1)] = (16));

} else {
var statearr_20815_20864 = state_20802__$1;
(statearr_20815_20864[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (22))){
var inst_20787 = (state_20802[(2)]);
var state_20802__$1 = state_20802;
if(cljs.core.truth_(inst_20787)){
var statearr_20816_20865 = state_20802__$1;
(statearr_20816_20865[(1)] = (23));

} else {
var statearr_20817_20866 = state_20802__$1;
(statearr_20817_20866[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (6))){
var inst_20781 = (state_20802[(7)]);
var inst_20783 = (state_20802[(11)]);
var inst_20733 = (state_20802[(8)]);
var inst_20781__$1 = topic_fn.call(null,inst_20733);
var inst_20782 = cljs.core.deref.call(null,mults);
var inst_20783__$1 = cljs.core.get.call(null,inst_20782,inst_20781__$1);
var state_20802__$1 = (function (){var statearr_20818 = state_20802;
(statearr_20818[(7)] = inst_20781__$1);

(statearr_20818[(11)] = inst_20783__$1);

return statearr_20818;
})();
if(cljs.core.truth_(inst_20783__$1)){
var statearr_20819_20867 = state_20802__$1;
(statearr_20819_20867[(1)] = (19));

} else {
var statearr_20820_20868 = state_20802__$1;
(statearr_20820_20868[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (25))){
var inst_20792 = (state_20802[(2)]);
var state_20802__$1 = state_20802;
var statearr_20821_20869 = state_20802__$1;
(statearr_20821_20869[(2)] = inst_20792);

(statearr_20821_20869[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (17))){
var inst_20757 = (state_20802[(10)]);
var inst_20766 = cljs.core.first.call(null,inst_20757);
var inst_20767 = cljs.core.async.muxch_STAR_.call(null,inst_20766);
var inst_20768 = cljs.core.async.close_BANG_.call(null,inst_20767);
var inst_20769 = cljs.core.next.call(null,inst_20757);
var inst_20743 = inst_20769;
var inst_20744 = null;
var inst_20745 = (0);
var inst_20746 = (0);
var state_20802__$1 = (function (){var statearr_20822 = state_20802;
(statearr_20822[(12)] = inst_20745);

(statearr_20822[(13)] = inst_20746);

(statearr_20822[(14)] = inst_20768);

(statearr_20822[(15)] = inst_20744);

(statearr_20822[(16)] = inst_20743);

return statearr_20822;
})();
var statearr_20823_20870 = state_20802__$1;
(statearr_20823_20870[(2)] = null);

(statearr_20823_20870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (3))){
var inst_20800 = (state_20802[(2)]);
var state_20802__$1 = state_20802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20802__$1,inst_20800);
} else {
if((state_val_20803 === (12))){
var inst_20777 = (state_20802[(2)]);
var state_20802__$1 = state_20802;
var statearr_20824_20871 = state_20802__$1;
(statearr_20824_20871[(2)] = inst_20777);

(statearr_20824_20871[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (2))){
var state_20802__$1 = state_20802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20802__$1,(4),ch);
} else {
if((state_val_20803 === (23))){
var state_20802__$1 = state_20802;
var statearr_20825_20872 = state_20802__$1;
(statearr_20825_20872[(2)] = null);

(statearr_20825_20872[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (19))){
var inst_20783 = (state_20802[(11)]);
var inst_20733 = (state_20802[(8)]);
var inst_20785 = cljs.core.async.muxch_STAR_.call(null,inst_20783);
var state_20802__$1 = state_20802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20802__$1,(22),inst_20785,inst_20733);
} else {
if((state_val_20803 === (11))){
var inst_20757 = (state_20802[(10)]);
var inst_20743 = (state_20802[(16)]);
var inst_20757__$1 = cljs.core.seq.call(null,inst_20743);
var state_20802__$1 = (function (){var statearr_20826 = state_20802;
(statearr_20826[(10)] = inst_20757__$1);

return statearr_20826;
})();
if(inst_20757__$1){
var statearr_20827_20873 = state_20802__$1;
(statearr_20827_20873[(1)] = (13));

} else {
var statearr_20828_20874 = state_20802__$1;
(statearr_20828_20874[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (9))){
var inst_20779 = (state_20802[(2)]);
var state_20802__$1 = state_20802;
var statearr_20829_20875 = state_20802__$1;
(statearr_20829_20875[(2)] = inst_20779);

(statearr_20829_20875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (5))){
var inst_20740 = cljs.core.deref.call(null,mults);
var inst_20741 = cljs.core.vals.call(null,inst_20740);
var inst_20742 = cljs.core.seq.call(null,inst_20741);
var inst_20743 = inst_20742;
var inst_20744 = null;
var inst_20745 = (0);
var inst_20746 = (0);
var state_20802__$1 = (function (){var statearr_20830 = state_20802;
(statearr_20830[(12)] = inst_20745);

(statearr_20830[(13)] = inst_20746);

(statearr_20830[(15)] = inst_20744);

(statearr_20830[(16)] = inst_20743);

return statearr_20830;
})();
var statearr_20831_20876 = state_20802__$1;
(statearr_20831_20876[(2)] = null);

(statearr_20831_20876[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (14))){
var state_20802__$1 = state_20802;
var statearr_20835_20877 = state_20802__$1;
(statearr_20835_20877[(2)] = null);

(statearr_20835_20877[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (16))){
var inst_20757 = (state_20802[(10)]);
var inst_20761 = cljs.core.chunk_first.call(null,inst_20757);
var inst_20762 = cljs.core.chunk_rest.call(null,inst_20757);
var inst_20763 = cljs.core.count.call(null,inst_20761);
var inst_20743 = inst_20762;
var inst_20744 = inst_20761;
var inst_20745 = inst_20763;
var inst_20746 = (0);
var state_20802__$1 = (function (){var statearr_20836 = state_20802;
(statearr_20836[(12)] = inst_20745);

(statearr_20836[(13)] = inst_20746);

(statearr_20836[(15)] = inst_20744);

(statearr_20836[(16)] = inst_20743);

return statearr_20836;
})();
var statearr_20837_20878 = state_20802__$1;
(statearr_20837_20878[(2)] = null);

(statearr_20837_20878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (10))){
var inst_20745 = (state_20802[(12)]);
var inst_20746 = (state_20802[(13)]);
var inst_20744 = (state_20802[(15)]);
var inst_20743 = (state_20802[(16)]);
var inst_20751 = cljs.core._nth.call(null,inst_20744,inst_20746);
var inst_20752 = cljs.core.async.muxch_STAR_.call(null,inst_20751);
var inst_20753 = cljs.core.async.close_BANG_.call(null,inst_20752);
var inst_20754 = (inst_20746 + (1));
var tmp20832 = inst_20745;
var tmp20833 = inst_20744;
var tmp20834 = inst_20743;
var inst_20743__$1 = tmp20834;
var inst_20744__$1 = tmp20833;
var inst_20745__$1 = tmp20832;
var inst_20746__$1 = inst_20754;
var state_20802__$1 = (function (){var statearr_20838 = state_20802;
(statearr_20838[(17)] = inst_20753);

(statearr_20838[(12)] = inst_20745__$1);

(statearr_20838[(13)] = inst_20746__$1);

(statearr_20838[(15)] = inst_20744__$1);

(statearr_20838[(16)] = inst_20743__$1);

return statearr_20838;
})();
var statearr_20839_20879 = state_20802__$1;
(statearr_20839_20879[(2)] = null);

(statearr_20839_20879[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (18))){
var inst_20772 = (state_20802[(2)]);
var state_20802__$1 = state_20802;
var statearr_20840_20880 = state_20802__$1;
(statearr_20840_20880[(2)] = inst_20772);

(statearr_20840_20880[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20803 === (8))){
var inst_20745 = (state_20802[(12)]);
var inst_20746 = (state_20802[(13)]);
var inst_20748 = (inst_20746 < inst_20745);
var inst_20749 = inst_20748;
var state_20802__$1 = state_20802;
if(cljs.core.truth_(inst_20749)){
var statearr_20841_20881 = state_20802__$1;
(statearr_20841_20881[(1)] = (10));

} else {
var statearr_20842_20882 = state_20802__$1;
(statearr_20842_20882[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___20854,mults,ensure_mult,p))
;
return ((function (switch__10969__auto__,c__11081__auto___20854,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_20846 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20846[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_20846[(1)] = (1));

return statearr_20846;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_20802){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_20802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e20847){if((e20847 instanceof Object)){
var ex__10973__auto__ = e20847;
var statearr_20848_20883 = state_20802;
(statearr_20848_20883[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20847;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20884 = state_20802;
state_20802 = G__20884;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_20802){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_20802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___20854,mults,ensure_mult,p))
})();
var state__11083__auto__ = (function (){var statearr_20849 = f__11082__auto__.call(null);
(statearr_20849[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___20854);

return statearr_20849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___20854,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20885 = [];
var len__5726__auto___20888 = arguments.length;
var i__5727__auto___20889 = (0);
while(true){
if((i__5727__auto___20889 < len__5726__auto___20888)){
args20885.push((arguments[i__5727__auto___20889]));

var G__20890 = (i__5727__auto___20889 + (1));
i__5727__auto___20889 = G__20890;
continue;
} else {
}
break;
}

var G__20887 = args20885.length;
switch (G__20887) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20885.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20892 = [];
var len__5726__auto___20895 = arguments.length;
var i__5727__auto___20896 = (0);
while(true){
if((i__5727__auto___20896 < len__5726__auto___20895)){
args20892.push((arguments[i__5727__auto___20896]));

var G__20897 = (i__5727__auto___20896 + (1));
i__5727__auto___20896 = G__20897;
continue;
} else {
}
break;
}

var G__20894 = args20892.length;
switch (G__20894) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20892.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20899 = [];
var len__5726__auto___20970 = arguments.length;
var i__5727__auto___20971 = (0);
while(true){
if((i__5727__auto___20971 < len__5726__auto___20970)){
args20899.push((arguments[i__5727__auto___20971]));

var G__20972 = (i__5727__auto___20971 + (1));
i__5727__auto___20971 = G__20972;
continue;
} else {
}
break;
}

var G__20901 = args20899.length;
switch (G__20901) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20899.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11081__auto___20974 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___20974,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___20974,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20940){
var state_val_20941 = (state_20940[(1)]);
if((state_val_20941 === (7))){
var state_20940__$1 = state_20940;
var statearr_20942_20975 = state_20940__$1;
(statearr_20942_20975[(2)] = null);

(statearr_20942_20975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (1))){
var state_20940__$1 = state_20940;
var statearr_20943_20976 = state_20940__$1;
(statearr_20943_20976[(2)] = null);

(statearr_20943_20976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (4))){
var inst_20904 = (state_20940[(7)]);
var inst_20906 = (inst_20904 < cnt);
var state_20940__$1 = state_20940;
if(cljs.core.truth_(inst_20906)){
var statearr_20944_20977 = state_20940__$1;
(statearr_20944_20977[(1)] = (6));

} else {
var statearr_20945_20978 = state_20940__$1;
(statearr_20945_20978[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (15))){
var inst_20936 = (state_20940[(2)]);
var state_20940__$1 = state_20940;
var statearr_20946_20979 = state_20940__$1;
(statearr_20946_20979[(2)] = inst_20936);

(statearr_20946_20979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (13))){
var inst_20929 = cljs.core.async.close_BANG_.call(null,out);
var state_20940__$1 = state_20940;
var statearr_20947_20980 = state_20940__$1;
(statearr_20947_20980[(2)] = inst_20929);

(statearr_20947_20980[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (6))){
var state_20940__$1 = state_20940;
var statearr_20948_20981 = state_20940__$1;
(statearr_20948_20981[(2)] = null);

(statearr_20948_20981[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (3))){
var inst_20938 = (state_20940[(2)]);
var state_20940__$1 = state_20940;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20940__$1,inst_20938);
} else {
if((state_val_20941 === (12))){
var inst_20926 = (state_20940[(8)]);
var inst_20926__$1 = (state_20940[(2)]);
var inst_20927 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20926__$1);
var state_20940__$1 = (function (){var statearr_20949 = state_20940;
(statearr_20949[(8)] = inst_20926__$1);

return statearr_20949;
})();
if(cljs.core.truth_(inst_20927)){
var statearr_20950_20982 = state_20940__$1;
(statearr_20950_20982[(1)] = (13));

} else {
var statearr_20951_20983 = state_20940__$1;
(statearr_20951_20983[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (2))){
var inst_20903 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20904 = (0);
var state_20940__$1 = (function (){var statearr_20952 = state_20940;
(statearr_20952[(9)] = inst_20903);

(statearr_20952[(7)] = inst_20904);

return statearr_20952;
})();
var statearr_20953_20984 = state_20940__$1;
(statearr_20953_20984[(2)] = null);

(statearr_20953_20984[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (11))){
var inst_20904 = (state_20940[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20940,(10),Object,null,(9));
var inst_20913 = chs__$1.call(null,inst_20904);
var inst_20914 = done.call(null,inst_20904);
var inst_20915 = cljs.core.async.take_BANG_.call(null,inst_20913,inst_20914);
var state_20940__$1 = state_20940;
var statearr_20954_20985 = state_20940__$1;
(statearr_20954_20985[(2)] = inst_20915);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20940__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (9))){
var inst_20904 = (state_20940[(7)]);
var inst_20917 = (state_20940[(2)]);
var inst_20918 = (inst_20904 + (1));
var inst_20904__$1 = inst_20918;
var state_20940__$1 = (function (){var statearr_20955 = state_20940;
(statearr_20955[(7)] = inst_20904__$1);

(statearr_20955[(10)] = inst_20917);

return statearr_20955;
})();
var statearr_20956_20986 = state_20940__$1;
(statearr_20956_20986[(2)] = null);

(statearr_20956_20986[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (5))){
var inst_20924 = (state_20940[(2)]);
var state_20940__$1 = (function (){var statearr_20957 = state_20940;
(statearr_20957[(11)] = inst_20924);

return statearr_20957;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20940__$1,(12),dchan);
} else {
if((state_val_20941 === (14))){
var inst_20926 = (state_20940[(8)]);
var inst_20931 = cljs.core.apply.call(null,f,inst_20926);
var state_20940__$1 = state_20940;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20940__$1,(16),out,inst_20931);
} else {
if((state_val_20941 === (16))){
var inst_20933 = (state_20940[(2)]);
var state_20940__$1 = (function (){var statearr_20958 = state_20940;
(statearr_20958[(12)] = inst_20933);

return statearr_20958;
})();
var statearr_20959_20987 = state_20940__$1;
(statearr_20959_20987[(2)] = null);

(statearr_20959_20987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (10))){
var inst_20908 = (state_20940[(2)]);
var inst_20909 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20940__$1 = (function (){var statearr_20960 = state_20940;
(statearr_20960[(13)] = inst_20908);

return statearr_20960;
})();
var statearr_20961_20988 = state_20940__$1;
(statearr_20961_20988[(2)] = inst_20909);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20940__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20941 === (8))){
var inst_20922 = (state_20940[(2)]);
var state_20940__$1 = state_20940;
var statearr_20962_20989 = state_20940__$1;
(statearr_20962_20989[(2)] = inst_20922);

(statearr_20962_20989[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___20974,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10969__auto__,c__11081__auto___20974,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_20966 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20966[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_20966[(1)] = (1));

return statearr_20966;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_20940){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_20940);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e20967){if((e20967 instanceof Object)){
var ex__10973__auto__ = e20967;
var statearr_20968_20990 = state_20940;
(statearr_20968_20990[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20940);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20967;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20991 = state_20940;
state_20940 = G__20991;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_20940){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_20940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___20974,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11083__auto__ = (function (){var statearr_20969 = f__11082__auto__.call(null);
(statearr_20969[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___20974);

return statearr_20969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___20974,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20993 = [];
var len__5726__auto___21049 = arguments.length;
var i__5727__auto___21050 = (0);
while(true){
if((i__5727__auto___21050 < len__5726__auto___21049)){
args20993.push((arguments[i__5727__auto___21050]));

var G__21051 = (i__5727__auto___21050 + (1));
i__5727__auto___21050 = G__21051;
continue;
} else {
}
break;
}

var G__20995 = args20993.length;
switch (G__20995) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20993.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___21053 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___21053,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___21053,out){
return (function (state_21025){
var state_val_21026 = (state_21025[(1)]);
if((state_val_21026 === (7))){
var inst_21004 = (state_21025[(7)]);
var inst_21005 = (state_21025[(8)]);
var inst_21004__$1 = (state_21025[(2)]);
var inst_21005__$1 = cljs.core.nth.call(null,inst_21004__$1,(0),null);
var inst_21006 = cljs.core.nth.call(null,inst_21004__$1,(1),null);
var inst_21007 = (inst_21005__$1 == null);
var state_21025__$1 = (function (){var statearr_21027 = state_21025;
(statearr_21027[(7)] = inst_21004__$1);

(statearr_21027[(8)] = inst_21005__$1);

(statearr_21027[(9)] = inst_21006);

return statearr_21027;
})();
if(cljs.core.truth_(inst_21007)){
var statearr_21028_21054 = state_21025__$1;
(statearr_21028_21054[(1)] = (8));

} else {
var statearr_21029_21055 = state_21025__$1;
(statearr_21029_21055[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21026 === (1))){
var inst_20996 = cljs.core.vec.call(null,chs);
var inst_20997 = inst_20996;
var state_21025__$1 = (function (){var statearr_21030 = state_21025;
(statearr_21030[(10)] = inst_20997);

return statearr_21030;
})();
var statearr_21031_21056 = state_21025__$1;
(statearr_21031_21056[(2)] = null);

(statearr_21031_21056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21026 === (4))){
var inst_20997 = (state_21025[(10)]);
var state_21025__$1 = state_21025;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21025__$1,(7),inst_20997);
} else {
if((state_val_21026 === (6))){
var inst_21021 = (state_21025[(2)]);
var state_21025__$1 = state_21025;
var statearr_21032_21057 = state_21025__$1;
(statearr_21032_21057[(2)] = inst_21021);

(statearr_21032_21057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21026 === (3))){
var inst_21023 = (state_21025[(2)]);
var state_21025__$1 = state_21025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21025__$1,inst_21023);
} else {
if((state_val_21026 === (2))){
var inst_20997 = (state_21025[(10)]);
var inst_20999 = cljs.core.count.call(null,inst_20997);
var inst_21000 = (inst_20999 > (0));
var state_21025__$1 = state_21025;
if(cljs.core.truth_(inst_21000)){
var statearr_21034_21058 = state_21025__$1;
(statearr_21034_21058[(1)] = (4));

} else {
var statearr_21035_21059 = state_21025__$1;
(statearr_21035_21059[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21026 === (11))){
var inst_20997 = (state_21025[(10)]);
var inst_21014 = (state_21025[(2)]);
var tmp21033 = inst_20997;
var inst_20997__$1 = tmp21033;
var state_21025__$1 = (function (){var statearr_21036 = state_21025;
(statearr_21036[(10)] = inst_20997__$1);

(statearr_21036[(11)] = inst_21014);

return statearr_21036;
})();
var statearr_21037_21060 = state_21025__$1;
(statearr_21037_21060[(2)] = null);

(statearr_21037_21060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21026 === (9))){
var inst_21005 = (state_21025[(8)]);
var state_21025__$1 = state_21025;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21025__$1,(11),out,inst_21005);
} else {
if((state_val_21026 === (5))){
var inst_21019 = cljs.core.async.close_BANG_.call(null,out);
var state_21025__$1 = state_21025;
var statearr_21038_21061 = state_21025__$1;
(statearr_21038_21061[(2)] = inst_21019);

(statearr_21038_21061[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21026 === (10))){
var inst_21017 = (state_21025[(2)]);
var state_21025__$1 = state_21025;
var statearr_21039_21062 = state_21025__$1;
(statearr_21039_21062[(2)] = inst_21017);

(statearr_21039_21062[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21026 === (8))){
var inst_21004 = (state_21025[(7)]);
var inst_21005 = (state_21025[(8)]);
var inst_21006 = (state_21025[(9)]);
var inst_20997 = (state_21025[(10)]);
var inst_21009 = (function (){var cs = inst_20997;
var vec__21002 = inst_21004;
var v = inst_21005;
var c = inst_21006;
return ((function (cs,vec__21002,v,c,inst_21004,inst_21005,inst_21006,inst_20997,state_val_21026,c__11081__auto___21053,out){
return (function (p1__20992_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20992_SHARP_);
});
;})(cs,vec__21002,v,c,inst_21004,inst_21005,inst_21006,inst_20997,state_val_21026,c__11081__auto___21053,out))
})();
var inst_21010 = cljs.core.filterv.call(null,inst_21009,inst_20997);
var inst_20997__$1 = inst_21010;
var state_21025__$1 = (function (){var statearr_21040 = state_21025;
(statearr_21040[(10)] = inst_20997__$1);

return statearr_21040;
})();
var statearr_21041_21063 = state_21025__$1;
(statearr_21041_21063[(2)] = null);

(statearr_21041_21063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___21053,out))
;
return ((function (switch__10969__auto__,c__11081__auto___21053,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_21045 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21045[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_21045[(1)] = (1));

return statearr_21045;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_21025){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_21025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e21046){if((e21046 instanceof Object)){
var ex__10973__auto__ = e21046;
var statearr_21047_21064 = state_21025;
(statearr_21047_21064[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21025);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21046;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21065 = state_21025;
state_21025 = G__21065;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_21025){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_21025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___21053,out))
})();
var state__11083__auto__ = (function (){var statearr_21048 = f__11082__auto__.call(null);
(statearr_21048[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___21053);

return statearr_21048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___21053,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args21066 = [];
var len__5726__auto___21115 = arguments.length;
var i__5727__auto___21116 = (0);
while(true){
if((i__5727__auto___21116 < len__5726__auto___21115)){
args21066.push((arguments[i__5727__auto___21116]));

var G__21117 = (i__5727__auto___21116 + (1));
i__5727__auto___21116 = G__21117;
continue;
} else {
}
break;
}

var G__21068 = args21066.length;
switch (G__21068) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21066.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___21119 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___21119,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___21119,out){
return (function (state_21092){
var state_val_21093 = (state_21092[(1)]);
if((state_val_21093 === (7))){
var inst_21074 = (state_21092[(7)]);
var inst_21074__$1 = (state_21092[(2)]);
var inst_21075 = (inst_21074__$1 == null);
var inst_21076 = cljs.core.not.call(null,inst_21075);
var state_21092__$1 = (function (){var statearr_21094 = state_21092;
(statearr_21094[(7)] = inst_21074__$1);

return statearr_21094;
})();
if(inst_21076){
var statearr_21095_21120 = state_21092__$1;
(statearr_21095_21120[(1)] = (8));

} else {
var statearr_21096_21121 = state_21092__$1;
(statearr_21096_21121[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21093 === (1))){
var inst_21069 = (0);
var state_21092__$1 = (function (){var statearr_21097 = state_21092;
(statearr_21097[(8)] = inst_21069);

return statearr_21097;
})();
var statearr_21098_21122 = state_21092__$1;
(statearr_21098_21122[(2)] = null);

(statearr_21098_21122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21093 === (4))){
var state_21092__$1 = state_21092;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21092__$1,(7),ch);
} else {
if((state_val_21093 === (6))){
var inst_21087 = (state_21092[(2)]);
var state_21092__$1 = state_21092;
var statearr_21099_21123 = state_21092__$1;
(statearr_21099_21123[(2)] = inst_21087);

(statearr_21099_21123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21093 === (3))){
var inst_21089 = (state_21092[(2)]);
var inst_21090 = cljs.core.async.close_BANG_.call(null,out);
var state_21092__$1 = (function (){var statearr_21100 = state_21092;
(statearr_21100[(9)] = inst_21089);

return statearr_21100;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21092__$1,inst_21090);
} else {
if((state_val_21093 === (2))){
var inst_21069 = (state_21092[(8)]);
var inst_21071 = (inst_21069 < n);
var state_21092__$1 = state_21092;
if(cljs.core.truth_(inst_21071)){
var statearr_21101_21124 = state_21092__$1;
(statearr_21101_21124[(1)] = (4));

} else {
var statearr_21102_21125 = state_21092__$1;
(statearr_21102_21125[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21093 === (11))){
var inst_21069 = (state_21092[(8)]);
var inst_21079 = (state_21092[(2)]);
var inst_21080 = (inst_21069 + (1));
var inst_21069__$1 = inst_21080;
var state_21092__$1 = (function (){var statearr_21103 = state_21092;
(statearr_21103[(10)] = inst_21079);

(statearr_21103[(8)] = inst_21069__$1);

return statearr_21103;
})();
var statearr_21104_21126 = state_21092__$1;
(statearr_21104_21126[(2)] = null);

(statearr_21104_21126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21093 === (9))){
var state_21092__$1 = state_21092;
var statearr_21105_21127 = state_21092__$1;
(statearr_21105_21127[(2)] = null);

(statearr_21105_21127[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21093 === (5))){
var state_21092__$1 = state_21092;
var statearr_21106_21128 = state_21092__$1;
(statearr_21106_21128[(2)] = null);

(statearr_21106_21128[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21093 === (10))){
var inst_21084 = (state_21092[(2)]);
var state_21092__$1 = state_21092;
var statearr_21107_21129 = state_21092__$1;
(statearr_21107_21129[(2)] = inst_21084);

(statearr_21107_21129[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21093 === (8))){
var inst_21074 = (state_21092[(7)]);
var state_21092__$1 = state_21092;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21092__$1,(11),out,inst_21074);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___21119,out))
;
return ((function (switch__10969__auto__,c__11081__auto___21119,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_21111 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21111[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_21111[(1)] = (1));

return statearr_21111;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_21092){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_21092);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e21112){if((e21112 instanceof Object)){
var ex__10973__auto__ = e21112;
var statearr_21113_21130 = state_21092;
(statearr_21113_21130[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21092);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21131 = state_21092;
state_21092 = G__21131;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_21092){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_21092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___21119,out))
})();
var state__11083__auto__ = (function (){var statearr_21114 = f__11082__auto__.call(null);
(statearr_21114[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___21119);

return statearr_21114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___21119,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21139 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21139 = (function (map_LT_,f,ch,meta21140){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21140 = meta21140;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21141,meta21140__$1){
var self__ = this;
var _21141__$1 = this;
return (new cljs.core.async.t_cljs$core$async21139(self__.map_LT_,self__.f,self__.ch,meta21140__$1));
});

cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21141){
var self__ = this;
var _21141__$1 = this;
return self__.meta21140;
});

cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21142 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21142 = (function (map_LT_,f,ch,meta21140,_,fn1,meta21143){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21140 = meta21140;
this._ = _;
this.fn1 = fn1;
this.meta21143 = meta21143;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21142.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21144,meta21143__$1){
var self__ = this;
var _21144__$1 = this;
return (new cljs.core.async.t_cljs$core$async21142(self__.map_LT_,self__.f,self__.ch,self__.meta21140,self__._,self__.fn1,meta21143__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21142.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21144){
var self__ = this;
var _21144__$1 = this;
return self__.meta21143;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21142.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21142.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21142.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21142.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21132_SHARP_){
return f1.call(null,(((p1__21132_SHARP_ == null))?null:self__.f.call(null,p1__21132_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21142.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21140","meta21140",144115189,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21139","cljs.core.async/t_cljs$core$async21139",-827786677,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21143","meta21143",1202177394,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21142.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21142.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21142";

cljs.core.async.t_cljs$core$async21142.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21142");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21142 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21142(map_LT___$1,f__$1,ch__$1,meta21140__$1,___$2,fn1__$1,meta21143){
return (new cljs.core.async.t_cljs$core$async21142(map_LT___$1,f__$1,ch__$1,meta21140__$1,___$2,fn1__$1,meta21143));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21142(self__.map_LT_,self__.f,self__.ch,self__.meta21140,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21139.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21139.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21140","meta21140",144115189,null)], null);
});

cljs.core.async.t_cljs$core$async21139.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21139.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21139";

cljs.core.async.t_cljs$core$async21139.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21139");
});

cljs.core.async.__GT_t_cljs$core$async21139 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21139(map_LT___$1,f__$1,ch__$1,meta21140){
return (new cljs.core.async.t_cljs$core$async21139(map_LT___$1,f__$1,ch__$1,meta21140));
});

}

return (new cljs.core.async.t_cljs$core$async21139(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21148 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21148 = (function (map_GT_,f,ch,meta21149){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21149 = meta21149;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21150,meta21149__$1){
var self__ = this;
var _21150__$1 = this;
return (new cljs.core.async.t_cljs$core$async21148(self__.map_GT_,self__.f,self__.ch,meta21149__$1));
});

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21150){
var self__ = this;
var _21150__$1 = this;
return self__.meta21149;
});

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21148.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21148.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21149","meta21149",542309324,null)], null);
});

cljs.core.async.t_cljs$core$async21148.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21148.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21148";

cljs.core.async.t_cljs$core$async21148.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21148");
});

cljs.core.async.__GT_t_cljs$core$async21148 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21148(map_GT___$1,f__$1,ch__$1,meta21149){
return (new cljs.core.async.t_cljs$core$async21148(map_GT___$1,f__$1,ch__$1,meta21149));
});

}

return (new cljs.core.async.t_cljs$core$async21148(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21154 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21154 = (function (filter_GT_,p,ch,meta21155){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21155 = meta21155;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21156,meta21155__$1){
var self__ = this;
var _21156__$1 = this;
return (new cljs.core.async.t_cljs$core$async21154(self__.filter_GT_,self__.p,self__.ch,meta21155__$1));
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21156){
var self__ = this;
var _21156__$1 = this;
return self__.meta21155;
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21154.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21154.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21155","meta21155",-1897017005,null)], null);
});

cljs.core.async.t_cljs$core$async21154.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21154.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21154";

cljs.core.async.t_cljs$core$async21154.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21154");
});

cljs.core.async.__GT_t_cljs$core$async21154 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21154(filter_GT___$1,p__$1,ch__$1,meta21155){
return (new cljs.core.async.t_cljs$core$async21154(filter_GT___$1,p__$1,ch__$1,meta21155));
});

}

return (new cljs.core.async.t_cljs$core$async21154(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21157 = [];
var len__5726__auto___21201 = arguments.length;
var i__5727__auto___21202 = (0);
while(true){
if((i__5727__auto___21202 < len__5726__auto___21201)){
args21157.push((arguments[i__5727__auto___21202]));

var G__21203 = (i__5727__auto___21202 + (1));
i__5727__auto___21202 = G__21203;
continue;
} else {
}
break;
}

var G__21159 = args21157.length;
switch (G__21159) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21157.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___21205 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___21205,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___21205,out){
return (function (state_21180){
var state_val_21181 = (state_21180[(1)]);
if((state_val_21181 === (7))){
var inst_21176 = (state_21180[(2)]);
var state_21180__$1 = state_21180;
var statearr_21182_21206 = state_21180__$1;
(statearr_21182_21206[(2)] = inst_21176);

(statearr_21182_21206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21181 === (1))){
var state_21180__$1 = state_21180;
var statearr_21183_21207 = state_21180__$1;
(statearr_21183_21207[(2)] = null);

(statearr_21183_21207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21181 === (4))){
var inst_21162 = (state_21180[(7)]);
var inst_21162__$1 = (state_21180[(2)]);
var inst_21163 = (inst_21162__$1 == null);
var state_21180__$1 = (function (){var statearr_21184 = state_21180;
(statearr_21184[(7)] = inst_21162__$1);

return statearr_21184;
})();
if(cljs.core.truth_(inst_21163)){
var statearr_21185_21208 = state_21180__$1;
(statearr_21185_21208[(1)] = (5));

} else {
var statearr_21186_21209 = state_21180__$1;
(statearr_21186_21209[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21181 === (6))){
var inst_21162 = (state_21180[(7)]);
var inst_21167 = p.call(null,inst_21162);
var state_21180__$1 = state_21180;
if(cljs.core.truth_(inst_21167)){
var statearr_21187_21210 = state_21180__$1;
(statearr_21187_21210[(1)] = (8));

} else {
var statearr_21188_21211 = state_21180__$1;
(statearr_21188_21211[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21181 === (3))){
var inst_21178 = (state_21180[(2)]);
var state_21180__$1 = state_21180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21180__$1,inst_21178);
} else {
if((state_val_21181 === (2))){
var state_21180__$1 = state_21180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21180__$1,(4),ch);
} else {
if((state_val_21181 === (11))){
var inst_21170 = (state_21180[(2)]);
var state_21180__$1 = state_21180;
var statearr_21189_21212 = state_21180__$1;
(statearr_21189_21212[(2)] = inst_21170);

(statearr_21189_21212[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21181 === (9))){
var state_21180__$1 = state_21180;
var statearr_21190_21213 = state_21180__$1;
(statearr_21190_21213[(2)] = null);

(statearr_21190_21213[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21181 === (5))){
var inst_21165 = cljs.core.async.close_BANG_.call(null,out);
var state_21180__$1 = state_21180;
var statearr_21191_21214 = state_21180__$1;
(statearr_21191_21214[(2)] = inst_21165);

(statearr_21191_21214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21181 === (10))){
var inst_21173 = (state_21180[(2)]);
var state_21180__$1 = (function (){var statearr_21192 = state_21180;
(statearr_21192[(8)] = inst_21173);

return statearr_21192;
})();
var statearr_21193_21215 = state_21180__$1;
(statearr_21193_21215[(2)] = null);

(statearr_21193_21215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21181 === (8))){
var inst_21162 = (state_21180[(7)]);
var state_21180__$1 = state_21180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21180__$1,(11),out,inst_21162);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___21205,out))
;
return ((function (switch__10969__auto__,c__11081__auto___21205,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_21197 = [null,null,null,null,null,null,null,null,null];
(statearr_21197[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_21197[(1)] = (1));

return statearr_21197;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_21180){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_21180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e21198){if((e21198 instanceof Object)){
var ex__10973__auto__ = e21198;
var statearr_21199_21216 = state_21180;
(statearr_21199_21216[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21180);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21198;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21217 = state_21180;
state_21180 = G__21217;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_21180){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_21180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___21205,out))
})();
var state__11083__auto__ = (function (){var statearr_21200 = f__11082__auto__.call(null);
(statearr_21200[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___21205);

return statearr_21200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___21205,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21218 = [];
var len__5726__auto___21221 = arguments.length;
var i__5727__auto___21222 = (0);
while(true){
if((i__5727__auto___21222 < len__5726__auto___21221)){
args21218.push((arguments[i__5727__auto___21222]));

var G__21223 = (i__5727__auto___21222 + (1));
i__5727__auto___21222 = G__21223;
continue;
} else {
}
break;
}

var G__21220 = args21218.length;
switch (G__21220) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21218.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11081__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto__){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto__){
return (function (state_21390){
var state_val_21391 = (state_21390[(1)]);
if((state_val_21391 === (7))){
var inst_21386 = (state_21390[(2)]);
var state_21390__$1 = state_21390;
var statearr_21392_21433 = state_21390__$1;
(statearr_21392_21433[(2)] = inst_21386);

(statearr_21392_21433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (20))){
var inst_21356 = (state_21390[(7)]);
var inst_21367 = (state_21390[(2)]);
var inst_21368 = cljs.core.next.call(null,inst_21356);
var inst_21342 = inst_21368;
var inst_21343 = null;
var inst_21344 = (0);
var inst_21345 = (0);
var state_21390__$1 = (function (){var statearr_21393 = state_21390;
(statearr_21393[(8)] = inst_21343);

(statearr_21393[(9)] = inst_21345);

(statearr_21393[(10)] = inst_21367);

(statearr_21393[(11)] = inst_21342);

(statearr_21393[(12)] = inst_21344);

return statearr_21393;
})();
var statearr_21394_21434 = state_21390__$1;
(statearr_21394_21434[(2)] = null);

(statearr_21394_21434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (1))){
var state_21390__$1 = state_21390;
var statearr_21395_21435 = state_21390__$1;
(statearr_21395_21435[(2)] = null);

(statearr_21395_21435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (4))){
var inst_21331 = (state_21390[(13)]);
var inst_21331__$1 = (state_21390[(2)]);
var inst_21332 = (inst_21331__$1 == null);
var state_21390__$1 = (function (){var statearr_21396 = state_21390;
(statearr_21396[(13)] = inst_21331__$1);

return statearr_21396;
})();
if(cljs.core.truth_(inst_21332)){
var statearr_21397_21436 = state_21390__$1;
(statearr_21397_21436[(1)] = (5));

} else {
var statearr_21398_21437 = state_21390__$1;
(statearr_21398_21437[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (15))){
var state_21390__$1 = state_21390;
var statearr_21402_21438 = state_21390__$1;
(statearr_21402_21438[(2)] = null);

(statearr_21402_21438[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (21))){
var state_21390__$1 = state_21390;
var statearr_21403_21439 = state_21390__$1;
(statearr_21403_21439[(2)] = null);

(statearr_21403_21439[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (13))){
var inst_21343 = (state_21390[(8)]);
var inst_21345 = (state_21390[(9)]);
var inst_21342 = (state_21390[(11)]);
var inst_21344 = (state_21390[(12)]);
var inst_21352 = (state_21390[(2)]);
var inst_21353 = (inst_21345 + (1));
var tmp21399 = inst_21343;
var tmp21400 = inst_21342;
var tmp21401 = inst_21344;
var inst_21342__$1 = tmp21400;
var inst_21343__$1 = tmp21399;
var inst_21344__$1 = tmp21401;
var inst_21345__$1 = inst_21353;
var state_21390__$1 = (function (){var statearr_21404 = state_21390;
(statearr_21404[(8)] = inst_21343__$1);

(statearr_21404[(14)] = inst_21352);

(statearr_21404[(9)] = inst_21345__$1);

(statearr_21404[(11)] = inst_21342__$1);

(statearr_21404[(12)] = inst_21344__$1);

return statearr_21404;
})();
var statearr_21405_21440 = state_21390__$1;
(statearr_21405_21440[(2)] = null);

(statearr_21405_21440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (22))){
var state_21390__$1 = state_21390;
var statearr_21406_21441 = state_21390__$1;
(statearr_21406_21441[(2)] = null);

(statearr_21406_21441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (6))){
var inst_21331 = (state_21390[(13)]);
var inst_21340 = f.call(null,inst_21331);
var inst_21341 = cljs.core.seq.call(null,inst_21340);
var inst_21342 = inst_21341;
var inst_21343 = null;
var inst_21344 = (0);
var inst_21345 = (0);
var state_21390__$1 = (function (){var statearr_21407 = state_21390;
(statearr_21407[(8)] = inst_21343);

(statearr_21407[(9)] = inst_21345);

(statearr_21407[(11)] = inst_21342);

(statearr_21407[(12)] = inst_21344);

return statearr_21407;
})();
var statearr_21408_21442 = state_21390__$1;
(statearr_21408_21442[(2)] = null);

(statearr_21408_21442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (17))){
var inst_21356 = (state_21390[(7)]);
var inst_21360 = cljs.core.chunk_first.call(null,inst_21356);
var inst_21361 = cljs.core.chunk_rest.call(null,inst_21356);
var inst_21362 = cljs.core.count.call(null,inst_21360);
var inst_21342 = inst_21361;
var inst_21343 = inst_21360;
var inst_21344 = inst_21362;
var inst_21345 = (0);
var state_21390__$1 = (function (){var statearr_21409 = state_21390;
(statearr_21409[(8)] = inst_21343);

(statearr_21409[(9)] = inst_21345);

(statearr_21409[(11)] = inst_21342);

(statearr_21409[(12)] = inst_21344);

return statearr_21409;
})();
var statearr_21410_21443 = state_21390__$1;
(statearr_21410_21443[(2)] = null);

(statearr_21410_21443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (3))){
var inst_21388 = (state_21390[(2)]);
var state_21390__$1 = state_21390;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21390__$1,inst_21388);
} else {
if((state_val_21391 === (12))){
var inst_21376 = (state_21390[(2)]);
var state_21390__$1 = state_21390;
var statearr_21411_21444 = state_21390__$1;
(statearr_21411_21444[(2)] = inst_21376);

(statearr_21411_21444[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (2))){
var state_21390__$1 = state_21390;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21390__$1,(4),in$);
} else {
if((state_val_21391 === (23))){
var inst_21384 = (state_21390[(2)]);
var state_21390__$1 = state_21390;
var statearr_21412_21445 = state_21390__$1;
(statearr_21412_21445[(2)] = inst_21384);

(statearr_21412_21445[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (19))){
var inst_21371 = (state_21390[(2)]);
var state_21390__$1 = state_21390;
var statearr_21413_21446 = state_21390__$1;
(statearr_21413_21446[(2)] = inst_21371);

(statearr_21413_21446[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (11))){
var inst_21356 = (state_21390[(7)]);
var inst_21342 = (state_21390[(11)]);
var inst_21356__$1 = cljs.core.seq.call(null,inst_21342);
var state_21390__$1 = (function (){var statearr_21414 = state_21390;
(statearr_21414[(7)] = inst_21356__$1);

return statearr_21414;
})();
if(inst_21356__$1){
var statearr_21415_21447 = state_21390__$1;
(statearr_21415_21447[(1)] = (14));

} else {
var statearr_21416_21448 = state_21390__$1;
(statearr_21416_21448[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (9))){
var inst_21378 = (state_21390[(2)]);
var inst_21379 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21390__$1 = (function (){var statearr_21417 = state_21390;
(statearr_21417[(15)] = inst_21378);

return statearr_21417;
})();
if(cljs.core.truth_(inst_21379)){
var statearr_21418_21449 = state_21390__$1;
(statearr_21418_21449[(1)] = (21));

} else {
var statearr_21419_21450 = state_21390__$1;
(statearr_21419_21450[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (5))){
var inst_21334 = cljs.core.async.close_BANG_.call(null,out);
var state_21390__$1 = state_21390;
var statearr_21420_21451 = state_21390__$1;
(statearr_21420_21451[(2)] = inst_21334);

(statearr_21420_21451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (14))){
var inst_21356 = (state_21390[(7)]);
var inst_21358 = cljs.core.chunked_seq_QMARK_.call(null,inst_21356);
var state_21390__$1 = state_21390;
if(inst_21358){
var statearr_21421_21452 = state_21390__$1;
(statearr_21421_21452[(1)] = (17));

} else {
var statearr_21422_21453 = state_21390__$1;
(statearr_21422_21453[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (16))){
var inst_21374 = (state_21390[(2)]);
var state_21390__$1 = state_21390;
var statearr_21423_21454 = state_21390__$1;
(statearr_21423_21454[(2)] = inst_21374);

(statearr_21423_21454[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21391 === (10))){
var inst_21343 = (state_21390[(8)]);
var inst_21345 = (state_21390[(9)]);
var inst_21350 = cljs.core._nth.call(null,inst_21343,inst_21345);
var state_21390__$1 = state_21390;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21390__$1,(13),out,inst_21350);
} else {
if((state_val_21391 === (18))){
var inst_21356 = (state_21390[(7)]);
var inst_21365 = cljs.core.first.call(null,inst_21356);
var state_21390__$1 = state_21390;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21390__$1,(20),out,inst_21365);
} else {
if((state_val_21391 === (8))){
var inst_21345 = (state_21390[(9)]);
var inst_21344 = (state_21390[(12)]);
var inst_21347 = (inst_21345 < inst_21344);
var inst_21348 = inst_21347;
var state_21390__$1 = state_21390;
if(cljs.core.truth_(inst_21348)){
var statearr_21424_21455 = state_21390__$1;
(statearr_21424_21455[(1)] = (10));

} else {
var statearr_21425_21456 = state_21390__$1;
(statearr_21425_21456[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto__))
;
return ((function (switch__10969__auto__,c__11081__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_21429 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21429[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__);

(statearr_21429[(1)] = (1));

return statearr_21429;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____1 = (function (state_21390){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_21390);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e21430){if((e21430 instanceof Object)){
var ex__10973__auto__ = e21430;
var statearr_21431_21457 = state_21390;
(statearr_21431_21457[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21390);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21430;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21458 = state_21390;
state_21390 = G__21458;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__ = function(state_21390){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____1.call(this,state_21390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto__))
})();
var state__11083__auto__ = (function (){var statearr_21432 = f__11082__auto__.call(null);
(statearr_21432[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto__);

return statearr_21432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto__))
);

return c__11081__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21459 = [];
var len__5726__auto___21462 = arguments.length;
var i__5727__auto___21463 = (0);
while(true){
if((i__5727__auto___21463 < len__5726__auto___21462)){
args21459.push((arguments[i__5727__auto___21463]));

var G__21464 = (i__5727__auto___21463 + (1));
i__5727__auto___21463 = G__21464;
continue;
} else {
}
break;
}

var G__21461 = args21459.length;
switch (G__21461) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21459.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21466 = [];
var len__5726__auto___21469 = arguments.length;
var i__5727__auto___21470 = (0);
while(true){
if((i__5727__auto___21470 < len__5726__auto___21469)){
args21466.push((arguments[i__5727__auto___21470]));

var G__21471 = (i__5727__auto___21470 + (1));
i__5727__auto___21470 = G__21471;
continue;
} else {
}
break;
}

var G__21468 = args21466.length;
switch (G__21468) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21466.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21473 = [];
var len__5726__auto___21524 = arguments.length;
var i__5727__auto___21525 = (0);
while(true){
if((i__5727__auto___21525 < len__5726__auto___21524)){
args21473.push((arguments[i__5727__auto___21525]));

var G__21526 = (i__5727__auto___21525 + (1));
i__5727__auto___21525 = G__21526;
continue;
} else {
}
break;
}

var G__21475 = args21473.length;
switch (G__21475) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21473.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___21528 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___21528,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___21528,out){
return (function (state_21499){
var state_val_21500 = (state_21499[(1)]);
if((state_val_21500 === (7))){
var inst_21494 = (state_21499[(2)]);
var state_21499__$1 = state_21499;
var statearr_21501_21529 = state_21499__$1;
(statearr_21501_21529[(2)] = inst_21494);

(statearr_21501_21529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (1))){
var inst_21476 = null;
var state_21499__$1 = (function (){var statearr_21502 = state_21499;
(statearr_21502[(7)] = inst_21476);

return statearr_21502;
})();
var statearr_21503_21530 = state_21499__$1;
(statearr_21503_21530[(2)] = null);

(statearr_21503_21530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (4))){
var inst_21479 = (state_21499[(8)]);
var inst_21479__$1 = (state_21499[(2)]);
var inst_21480 = (inst_21479__$1 == null);
var inst_21481 = cljs.core.not.call(null,inst_21480);
var state_21499__$1 = (function (){var statearr_21504 = state_21499;
(statearr_21504[(8)] = inst_21479__$1);

return statearr_21504;
})();
if(inst_21481){
var statearr_21505_21531 = state_21499__$1;
(statearr_21505_21531[(1)] = (5));

} else {
var statearr_21506_21532 = state_21499__$1;
(statearr_21506_21532[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (6))){
var state_21499__$1 = state_21499;
var statearr_21507_21533 = state_21499__$1;
(statearr_21507_21533[(2)] = null);

(statearr_21507_21533[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (3))){
var inst_21496 = (state_21499[(2)]);
var inst_21497 = cljs.core.async.close_BANG_.call(null,out);
var state_21499__$1 = (function (){var statearr_21508 = state_21499;
(statearr_21508[(9)] = inst_21496);

return statearr_21508;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21499__$1,inst_21497);
} else {
if((state_val_21500 === (2))){
var state_21499__$1 = state_21499;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21499__$1,(4),ch);
} else {
if((state_val_21500 === (11))){
var inst_21479 = (state_21499[(8)]);
var inst_21488 = (state_21499[(2)]);
var inst_21476 = inst_21479;
var state_21499__$1 = (function (){var statearr_21509 = state_21499;
(statearr_21509[(7)] = inst_21476);

(statearr_21509[(10)] = inst_21488);

return statearr_21509;
})();
var statearr_21510_21534 = state_21499__$1;
(statearr_21510_21534[(2)] = null);

(statearr_21510_21534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (9))){
var inst_21479 = (state_21499[(8)]);
var state_21499__$1 = state_21499;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21499__$1,(11),out,inst_21479);
} else {
if((state_val_21500 === (5))){
var inst_21476 = (state_21499[(7)]);
var inst_21479 = (state_21499[(8)]);
var inst_21483 = cljs.core._EQ_.call(null,inst_21479,inst_21476);
var state_21499__$1 = state_21499;
if(inst_21483){
var statearr_21512_21535 = state_21499__$1;
(statearr_21512_21535[(1)] = (8));

} else {
var statearr_21513_21536 = state_21499__$1;
(statearr_21513_21536[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (10))){
var inst_21491 = (state_21499[(2)]);
var state_21499__$1 = state_21499;
var statearr_21514_21537 = state_21499__$1;
(statearr_21514_21537[(2)] = inst_21491);

(statearr_21514_21537[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (8))){
var inst_21476 = (state_21499[(7)]);
var tmp21511 = inst_21476;
var inst_21476__$1 = tmp21511;
var state_21499__$1 = (function (){var statearr_21515 = state_21499;
(statearr_21515[(7)] = inst_21476__$1);

return statearr_21515;
})();
var statearr_21516_21538 = state_21499__$1;
(statearr_21516_21538[(2)] = null);

(statearr_21516_21538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___21528,out))
;
return ((function (switch__10969__auto__,c__11081__auto___21528,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_21520 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21520[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_21520[(1)] = (1));

return statearr_21520;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_21499){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_21499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e21521){if((e21521 instanceof Object)){
var ex__10973__auto__ = e21521;
var statearr_21522_21539 = state_21499;
(statearr_21522_21539[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21499);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21521;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21540 = state_21499;
state_21499 = G__21540;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_21499){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_21499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___21528,out))
})();
var state__11083__auto__ = (function (){var statearr_21523 = f__11082__auto__.call(null);
(statearr_21523[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___21528);

return statearr_21523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___21528,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21541 = [];
var len__5726__auto___21611 = arguments.length;
var i__5727__auto___21612 = (0);
while(true){
if((i__5727__auto___21612 < len__5726__auto___21611)){
args21541.push((arguments[i__5727__auto___21612]));

var G__21613 = (i__5727__auto___21612 + (1));
i__5727__auto___21612 = G__21613;
continue;
} else {
}
break;
}

var G__21543 = args21541.length;
switch (G__21543) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21541.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___21615 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___21615,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___21615,out){
return (function (state_21581){
var state_val_21582 = (state_21581[(1)]);
if((state_val_21582 === (7))){
var inst_21577 = (state_21581[(2)]);
var state_21581__$1 = state_21581;
var statearr_21583_21616 = state_21581__$1;
(statearr_21583_21616[(2)] = inst_21577);

(statearr_21583_21616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (1))){
var inst_21544 = (new Array(n));
var inst_21545 = inst_21544;
var inst_21546 = (0);
var state_21581__$1 = (function (){var statearr_21584 = state_21581;
(statearr_21584[(7)] = inst_21546);

(statearr_21584[(8)] = inst_21545);

return statearr_21584;
})();
var statearr_21585_21617 = state_21581__$1;
(statearr_21585_21617[(2)] = null);

(statearr_21585_21617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (4))){
var inst_21549 = (state_21581[(9)]);
var inst_21549__$1 = (state_21581[(2)]);
var inst_21550 = (inst_21549__$1 == null);
var inst_21551 = cljs.core.not.call(null,inst_21550);
var state_21581__$1 = (function (){var statearr_21586 = state_21581;
(statearr_21586[(9)] = inst_21549__$1);

return statearr_21586;
})();
if(inst_21551){
var statearr_21587_21618 = state_21581__$1;
(statearr_21587_21618[(1)] = (5));

} else {
var statearr_21588_21619 = state_21581__$1;
(statearr_21588_21619[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (15))){
var inst_21571 = (state_21581[(2)]);
var state_21581__$1 = state_21581;
var statearr_21589_21620 = state_21581__$1;
(statearr_21589_21620[(2)] = inst_21571);

(statearr_21589_21620[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (13))){
var state_21581__$1 = state_21581;
var statearr_21590_21621 = state_21581__$1;
(statearr_21590_21621[(2)] = null);

(statearr_21590_21621[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (6))){
var inst_21546 = (state_21581[(7)]);
var inst_21567 = (inst_21546 > (0));
var state_21581__$1 = state_21581;
if(cljs.core.truth_(inst_21567)){
var statearr_21591_21622 = state_21581__$1;
(statearr_21591_21622[(1)] = (12));

} else {
var statearr_21592_21623 = state_21581__$1;
(statearr_21592_21623[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (3))){
var inst_21579 = (state_21581[(2)]);
var state_21581__$1 = state_21581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21581__$1,inst_21579);
} else {
if((state_val_21582 === (12))){
var inst_21545 = (state_21581[(8)]);
var inst_21569 = cljs.core.vec.call(null,inst_21545);
var state_21581__$1 = state_21581;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21581__$1,(15),out,inst_21569);
} else {
if((state_val_21582 === (2))){
var state_21581__$1 = state_21581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21581__$1,(4),ch);
} else {
if((state_val_21582 === (11))){
var inst_21561 = (state_21581[(2)]);
var inst_21562 = (new Array(n));
var inst_21545 = inst_21562;
var inst_21546 = (0);
var state_21581__$1 = (function (){var statearr_21593 = state_21581;
(statearr_21593[(7)] = inst_21546);

(statearr_21593[(8)] = inst_21545);

(statearr_21593[(10)] = inst_21561);

return statearr_21593;
})();
var statearr_21594_21624 = state_21581__$1;
(statearr_21594_21624[(2)] = null);

(statearr_21594_21624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (9))){
var inst_21545 = (state_21581[(8)]);
var inst_21559 = cljs.core.vec.call(null,inst_21545);
var state_21581__$1 = state_21581;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21581__$1,(11),out,inst_21559);
} else {
if((state_val_21582 === (5))){
var inst_21546 = (state_21581[(7)]);
var inst_21545 = (state_21581[(8)]);
var inst_21554 = (state_21581[(11)]);
var inst_21549 = (state_21581[(9)]);
var inst_21553 = (inst_21545[inst_21546] = inst_21549);
var inst_21554__$1 = (inst_21546 + (1));
var inst_21555 = (inst_21554__$1 < n);
var state_21581__$1 = (function (){var statearr_21595 = state_21581;
(statearr_21595[(12)] = inst_21553);

(statearr_21595[(11)] = inst_21554__$1);

return statearr_21595;
})();
if(cljs.core.truth_(inst_21555)){
var statearr_21596_21625 = state_21581__$1;
(statearr_21596_21625[(1)] = (8));

} else {
var statearr_21597_21626 = state_21581__$1;
(statearr_21597_21626[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (14))){
var inst_21574 = (state_21581[(2)]);
var inst_21575 = cljs.core.async.close_BANG_.call(null,out);
var state_21581__$1 = (function (){var statearr_21599 = state_21581;
(statearr_21599[(13)] = inst_21574);

return statearr_21599;
})();
var statearr_21600_21627 = state_21581__$1;
(statearr_21600_21627[(2)] = inst_21575);

(statearr_21600_21627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (10))){
var inst_21565 = (state_21581[(2)]);
var state_21581__$1 = state_21581;
var statearr_21601_21628 = state_21581__$1;
(statearr_21601_21628[(2)] = inst_21565);

(statearr_21601_21628[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21582 === (8))){
var inst_21545 = (state_21581[(8)]);
var inst_21554 = (state_21581[(11)]);
var tmp21598 = inst_21545;
var inst_21545__$1 = tmp21598;
var inst_21546 = inst_21554;
var state_21581__$1 = (function (){var statearr_21602 = state_21581;
(statearr_21602[(7)] = inst_21546);

(statearr_21602[(8)] = inst_21545__$1);

return statearr_21602;
})();
var statearr_21603_21629 = state_21581__$1;
(statearr_21603_21629[(2)] = null);

(statearr_21603_21629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___21615,out))
;
return ((function (switch__10969__auto__,c__11081__auto___21615,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_21607 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21607[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_21607[(1)] = (1));

return statearr_21607;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_21581){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_21581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e21608){if((e21608 instanceof Object)){
var ex__10973__auto__ = e21608;
var statearr_21609_21630 = state_21581;
(statearr_21609_21630[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21581);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21608;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21631 = state_21581;
state_21581 = G__21631;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_21581){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_21581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___21615,out))
})();
var state__11083__auto__ = (function (){var statearr_21610 = f__11082__auto__.call(null);
(statearr_21610[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___21615);

return statearr_21610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___21615,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21632 = [];
var len__5726__auto___21706 = arguments.length;
var i__5727__auto___21707 = (0);
while(true){
if((i__5727__auto___21707 < len__5726__auto___21706)){
args21632.push((arguments[i__5727__auto___21707]));

var G__21708 = (i__5727__auto___21707 + (1));
i__5727__auto___21707 = G__21708;
continue;
} else {
}
break;
}

var G__21634 = args21632.length;
switch (G__21634) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21632.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___21710 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___21710,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___21710,out){
return (function (state_21676){
var state_val_21677 = (state_21676[(1)]);
if((state_val_21677 === (7))){
var inst_21672 = (state_21676[(2)]);
var state_21676__$1 = state_21676;
var statearr_21678_21711 = state_21676__$1;
(statearr_21678_21711[(2)] = inst_21672);

(statearr_21678_21711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (1))){
var inst_21635 = [];
var inst_21636 = inst_21635;
var inst_21637 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21676__$1 = (function (){var statearr_21679 = state_21676;
(statearr_21679[(7)] = inst_21636);

(statearr_21679[(8)] = inst_21637);

return statearr_21679;
})();
var statearr_21680_21712 = state_21676__$1;
(statearr_21680_21712[(2)] = null);

(statearr_21680_21712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (4))){
var inst_21640 = (state_21676[(9)]);
var inst_21640__$1 = (state_21676[(2)]);
var inst_21641 = (inst_21640__$1 == null);
var inst_21642 = cljs.core.not.call(null,inst_21641);
var state_21676__$1 = (function (){var statearr_21681 = state_21676;
(statearr_21681[(9)] = inst_21640__$1);

return statearr_21681;
})();
if(inst_21642){
var statearr_21682_21713 = state_21676__$1;
(statearr_21682_21713[(1)] = (5));

} else {
var statearr_21683_21714 = state_21676__$1;
(statearr_21683_21714[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (15))){
var inst_21666 = (state_21676[(2)]);
var state_21676__$1 = state_21676;
var statearr_21684_21715 = state_21676__$1;
(statearr_21684_21715[(2)] = inst_21666);

(statearr_21684_21715[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (13))){
var state_21676__$1 = state_21676;
var statearr_21685_21716 = state_21676__$1;
(statearr_21685_21716[(2)] = null);

(statearr_21685_21716[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (6))){
var inst_21636 = (state_21676[(7)]);
var inst_21661 = inst_21636.length;
var inst_21662 = (inst_21661 > (0));
var state_21676__$1 = state_21676;
if(cljs.core.truth_(inst_21662)){
var statearr_21686_21717 = state_21676__$1;
(statearr_21686_21717[(1)] = (12));

} else {
var statearr_21687_21718 = state_21676__$1;
(statearr_21687_21718[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (3))){
var inst_21674 = (state_21676[(2)]);
var state_21676__$1 = state_21676;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21676__$1,inst_21674);
} else {
if((state_val_21677 === (12))){
var inst_21636 = (state_21676[(7)]);
var inst_21664 = cljs.core.vec.call(null,inst_21636);
var state_21676__$1 = state_21676;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21676__$1,(15),out,inst_21664);
} else {
if((state_val_21677 === (2))){
var state_21676__$1 = state_21676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21676__$1,(4),ch);
} else {
if((state_val_21677 === (11))){
var inst_21644 = (state_21676[(10)]);
var inst_21640 = (state_21676[(9)]);
var inst_21654 = (state_21676[(2)]);
var inst_21655 = [];
var inst_21656 = inst_21655.push(inst_21640);
var inst_21636 = inst_21655;
var inst_21637 = inst_21644;
var state_21676__$1 = (function (){var statearr_21688 = state_21676;
(statearr_21688[(7)] = inst_21636);

(statearr_21688[(11)] = inst_21654);

(statearr_21688[(12)] = inst_21656);

(statearr_21688[(8)] = inst_21637);

return statearr_21688;
})();
var statearr_21689_21719 = state_21676__$1;
(statearr_21689_21719[(2)] = null);

(statearr_21689_21719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (9))){
var inst_21636 = (state_21676[(7)]);
var inst_21652 = cljs.core.vec.call(null,inst_21636);
var state_21676__$1 = state_21676;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21676__$1,(11),out,inst_21652);
} else {
if((state_val_21677 === (5))){
var inst_21644 = (state_21676[(10)]);
var inst_21640 = (state_21676[(9)]);
var inst_21637 = (state_21676[(8)]);
var inst_21644__$1 = f.call(null,inst_21640);
var inst_21645 = cljs.core._EQ_.call(null,inst_21644__$1,inst_21637);
var inst_21646 = cljs.core.keyword_identical_QMARK_.call(null,inst_21637,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21647 = (inst_21645) || (inst_21646);
var state_21676__$1 = (function (){var statearr_21690 = state_21676;
(statearr_21690[(10)] = inst_21644__$1);

return statearr_21690;
})();
if(cljs.core.truth_(inst_21647)){
var statearr_21691_21720 = state_21676__$1;
(statearr_21691_21720[(1)] = (8));

} else {
var statearr_21692_21721 = state_21676__$1;
(statearr_21692_21721[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (14))){
var inst_21669 = (state_21676[(2)]);
var inst_21670 = cljs.core.async.close_BANG_.call(null,out);
var state_21676__$1 = (function (){var statearr_21694 = state_21676;
(statearr_21694[(13)] = inst_21669);

return statearr_21694;
})();
var statearr_21695_21722 = state_21676__$1;
(statearr_21695_21722[(2)] = inst_21670);

(statearr_21695_21722[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (10))){
var inst_21659 = (state_21676[(2)]);
var state_21676__$1 = state_21676;
var statearr_21696_21723 = state_21676__$1;
(statearr_21696_21723[(2)] = inst_21659);

(statearr_21696_21723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21677 === (8))){
var inst_21636 = (state_21676[(7)]);
var inst_21644 = (state_21676[(10)]);
var inst_21640 = (state_21676[(9)]);
var inst_21649 = inst_21636.push(inst_21640);
var tmp21693 = inst_21636;
var inst_21636__$1 = tmp21693;
var inst_21637 = inst_21644;
var state_21676__$1 = (function (){var statearr_21697 = state_21676;
(statearr_21697[(7)] = inst_21636__$1);

(statearr_21697[(14)] = inst_21649);

(statearr_21697[(8)] = inst_21637);

return statearr_21697;
})();
var statearr_21698_21724 = state_21676__$1;
(statearr_21698_21724[(2)] = null);

(statearr_21698_21724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___21710,out))
;
return ((function (switch__10969__auto__,c__11081__auto___21710,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_21702 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21702[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_21702[(1)] = (1));

return statearr_21702;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_21676){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_21676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e21703){if((e21703 instanceof Object)){
var ex__10973__auto__ = e21703;
var statearr_21704_21725 = state_21676;
(statearr_21704_21725[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21676);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21703;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21726 = state_21676;
state_21676 = G__21726;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_21676){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_21676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___21710,out))
})();
var state__11083__auto__ = (function (){var statearr_21705 = f__11082__auto__.call(null);
(statearr_21705[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___21710);

return statearr_21705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___21710,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1463994346672