// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11126 = [];
var len__5726__auto___11132 = arguments.length;
var i__5727__auto___11133 = (0);
while(true){
if((i__5727__auto___11133 < len__5726__auto___11132)){
args11126.push((arguments[i__5727__auto___11133]));

var G__11134 = (i__5727__auto___11133 + (1));
i__5727__auto___11133 = G__11134;
continue;
} else {
}
break;
}

var G__11128 = args11126.length;
switch (G__11128) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11126.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11129 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11129 = (function (f,blockable,meta11130){
this.f = f;
this.blockable = blockable;
this.meta11130 = meta11130;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11129.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11131,meta11130__$1){
var self__ = this;
var _11131__$1 = this;
return (new cljs.core.async.t_cljs$core$async11129(self__.f,self__.blockable,meta11130__$1));
});

cljs.core.async.t_cljs$core$async11129.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11131){
var self__ = this;
var _11131__$1 = this;
return self__.meta11130;
});

cljs.core.async.t_cljs$core$async11129.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11129.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11129.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11129.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11129.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11130","meta11130",192864608,null)], null);
});

cljs.core.async.t_cljs$core$async11129.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11129.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11129";

cljs.core.async.t_cljs$core$async11129.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11129");
});

cljs.core.async.__GT_t_cljs$core$async11129 = (function cljs$core$async$__GT_t_cljs$core$async11129(f__$1,blockable__$1,meta11130){
return (new cljs.core.async.t_cljs$core$async11129(f__$1,blockable__$1,meta11130));
});

}

return (new cljs.core.async.t_cljs$core$async11129(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11138 = [];
var len__5726__auto___11141 = arguments.length;
var i__5727__auto___11142 = (0);
while(true){
if((i__5727__auto___11142 < len__5726__auto___11141)){
args11138.push((arguments[i__5727__auto___11142]));

var G__11143 = (i__5727__auto___11142 + (1));
i__5727__auto___11142 = G__11143;
continue;
} else {
}
break;
}

var G__11140 = args11138.length;
switch (G__11140) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11138.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11145 = [];
var len__5726__auto___11148 = arguments.length;
var i__5727__auto___11149 = (0);
while(true){
if((i__5727__auto___11149 < len__5726__auto___11148)){
args11145.push((arguments[i__5727__auto___11149]));

var G__11150 = (i__5727__auto___11149 + (1));
i__5727__auto___11149 = G__11150;
continue;
} else {
}
break;
}

var G__11147 = args11145.length;
switch (G__11147) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11145.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11152 = [];
var len__5726__auto___11155 = arguments.length;
var i__5727__auto___11156 = (0);
while(true){
if((i__5727__auto___11156 < len__5726__auto___11155)){
args11152.push((arguments[i__5727__auto___11156]));

var G__11157 = (i__5727__auto___11156 + (1));
i__5727__auto___11156 = G__11157;
continue;
} else {
}
break;
}

var G__11154 = args11152.length;
switch (G__11154) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11152.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11159 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11159);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11159,ret){
return (function (){
return fn1.call(null,val_11159);
});})(val_11159,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11160 = [];
var len__5726__auto___11163 = arguments.length;
var i__5727__auto___11164 = (0);
while(true){
if((i__5727__auto___11164 < len__5726__auto___11163)){
args11160.push((arguments[i__5727__auto___11164]));

var G__11165 = (i__5727__auto___11164 + (1));
i__5727__auto___11164 = G__11165;
continue;
} else {
}
break;
}

var G__11162 = args11160.length;
switch (G__11162) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11160.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___11167 = n;
var x_11168 = (0);
while(true){
if((x_11168 < n__5571__auto___11167)){
(a[x_11168] = (0));

var G__11169 = (x_11168 + (1));
x_11168 = G__11169;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11170 = (i + (1));
i = G__11170;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11174 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11174 = (function (alt_flag,flag,meta11175){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11175 = meta11175;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11174.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11176,meta11175__$1){
var self__ = this;
var _11176__$1 = this;
return (new cljs.core.async.t_cljs$core$async11174(self__.alt_flag,self__.flag,meta11175__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11174.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11176){
var self__ = this;
var _11176__$1 = this;
return self__.meta11175;
});})(flag))
;

cljs.core.async.t_cljs$core$async11174.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11174.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11174.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11174.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11174.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11175","meta11175",-215670155,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11174.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11174.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11174";

cljs.core.async.t_cljs$core$async11174.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11174");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11174 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11174(alt_flag__$1,flag__$1,meta11175){
return (new cljs.core.async.t_cljs$core$async11174(alt_flag__$1,flag__$1,meta11175));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11174(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11180 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11180 = (function (alt_handler,flag,cb,meta11181){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11181 = meta11181;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11180.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11182,meta11181__$1){
var self__ = this;
var _11182__$1 = this;
return (new cljs.core.async.t_cljs$core$async11180(self__.alt_handler,self__.flag,self__.cb,meta11181__$1));
});

cljs.core.async.t_cljs$core$async11180.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11182){
var self__ = this;
var _11182__$1 = this;
return self__.meta11181;
});

cljs.core.async.t_cljs$core$async11180.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11180.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11180.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11180.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11180.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11181","meta11181",-205878470,null)], null);
});

cljs.core.async.t_cljs$core$async11180.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11180.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11180";

cljs.core.async.t_cljs$core$async11180.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11180");
});

cljs.core.async.__GT_t_cljs$core$async11180 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11180(alt_handler__$1,flag__$1,cb__$1,meta11181){
return (new cljs.core.async.t_cljs$core$async11180(alt_handler__$1,flag__$1,cb__$1,meta11181));
});

}

return (new cljs.core.async.t_cljs$core$async11180(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11183_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11183_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11184_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11184_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11185 = (i + (1));
i = G__11185;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11191 = arguments.length;
var i__5727__auto___11192 = (0);
while(true){
if((i__5727__auto___11192 < len__5726__auto___11191)){
args__5733__auto__.push((arguments[i__5727__auto___11192]));

var G__11193 = (i__5727__auto___11192 + (1));
i__5727__auto___11192 = G__11193;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11188){
var map__11189 = p__11188;
var map__11189__$1 = ((((!((map__11189 == null)))?((((map__11189.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11189.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11189):map__11189);
var opts = map__11189__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11186){
var G__11187 = cljs.core.first.call(null,seq11186);
var seq11186__$1 = cljs.core.next.call(null,seq11186);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11187,seq11186__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11194 = [];
var len__5726__auto___11244 = arguments.length;
var i__5727__auto___11245 = (0);
while(true){
if((i__5727__auto___11245 < len__5726__auto___11244)){
args11194.push((arguments[i__5727__auto___11245]));

var G__11246 = (i__5727__auto___11245 + (1));
i__5727__auto___11245 = G__11246;
continue;
} else {
}
break;
}

var G__11196 = args11194.length;
switch (G__11196) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11194.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11081__auto___11248 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___11248){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___11248){
return (function (state_11220){
var state_val_11221 = (state_11220[(1)]);
if((state_val_11221 === (7))){
var inst_11216 = (state_11220[(2)]);
var state_11220__$1 = state_11220;
var statearr_11222_11249 = state_11220__$1;
(statearr_11222_11249[(2)] = inst_11216);

(statearr_11222_11249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (1))){
var state_11220__$1 = state_11220;
var statearr_11223_11250 = state_11220__$1;
(statearr_11223_11250[(2)] = null);

(statearr_11223_11250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (4))){
var inst_11199 = (state_11220[(7)]);
var inst_11199__$1 = (state_11220[(2)]);
var inst_11200 = (inst_11199__$1 == null);
var state_11220__$1 = (function (){var statearr_11224 = state_11220;
(statearr_11224[(7)] = inst_11199__$1);

return statearr_11224;
})();
if(cljs.core.truth_(inst_11200)){
var statearr_11225_11251 = state_11220__$1;
(statearr_11225_11251[(1)] = (5));

} else {
var statearr_11226_11252 = state_11220__$1;
(statearr_11226_11252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (13))){
var state_11220__$1 = state_11220;
var statearr_11227_11253 = state_11220__$1;
(statearr_11227_11253[(2)] = null);

(statearr_11227_11253[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (6))){
var inst_11199 = (state_11220[(7)]);
var state_11220__$1 = state_11220;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11220__$1,(11),to,inst_11199);
} else {
if((state_val_11221 === (3))){
var inst_11218 = (state_11220[(2)]);
var state_11220__$1 = state_11220;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11220__$1,inst_11218);
} else {
if((state_val_11221 === (12))){
var state_11220__$1 = state_11220;
var statearr_11228_11254 = state_11220__$1;
(statearr_11228_11254[(2)] = null);

(statearr_11228_11254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (2))){
var state_11220__$1 = state_11220;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11220__$1,(4),from);
} else {
if((state_val_11221 === (11))){
var inst_11209 = (state_11220[(2)]);
var state_11220__$1 = state_11220;
if(cljs.core.truth_(inst_11209)){
var statearr_11229_11255 = state_11220__$1;
(statearr_11229_11255[(1)] = (12));

} else {
var statearr_11230_11256 = state_11220__$1;
(statearr_11230_11256[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (9))){
var state_11220__$1 = state_11220;
var statearr_11231_11257 = state_11220__$1;
(statearr_11231_11257[(2)] = null);

(statearr_11231_11257[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (5))){
var state_11220__$1 = state_11220;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11232_11258 = state_11220__$1;
(statearr_11232_11258[(1)] = (8));

} else {
var statearr_11233_11259 = state_11220__$1;
(statearr_11233_11259[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (14))){
var inst_11214 = (state_11220[(2)]);
var state_11220__$1 = state_11220;
var statearr_11234_11260 = state_11220__$1;
(statearr_11234_11260[(2)] = inst_11214);

(statearr_11234_11260[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (10))){
var inst_11206 = (state_11220[(2)]);
var state_11220__$1 = state_11220;
var statearr_11235_11261 = state_11220__$1;
(statearr_11235_11261[(2)] = inst_11206);

(statearr_11235_11261[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11221 === (8))){
var inst_11203 = cljs.core.async.close_BANG_.call(null,to);
var state_11220__$1 = state_11220;
var statearr_11236_11262 = state_11220__$1;
(statearr_11236_11262[(2)] = inst_11203);

(statearr_11236_11262[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___11248))
;
return ((function (switch__10969__auto__,c__11081__auto___11248){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_11240 = [null,null,null,null,null,null,null,null];
(statearr_11240[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_11240[(1)] = (1));

return statearr_11240;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_11220){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11220);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11241){if((e11241 instanceof Object)){
var ex__10973__auto__ = e11241;
var statearr_11242_11263 = state_11220;
(statearr_11242_11263[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11220);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11241;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11264 = state_11220;
state_11220 = G__11264;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_11220){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_11220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___11248))
})();
var state__11083__auto__ = (function (){var statearr_11243 = f__11082__auto__.call(null);
(statearr_11243[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___11248);

return statearr_11243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___11248))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11448){
var vec__11449 = p__11448;
var v = cljs.core.nth.call(null,vec__11449,(0),null);
var p = cljs.core.nth.call(null,vec__11449,(1),null);
var job = vec__11449;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11081__auto___11631 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___11631,res,vec__11449,v,p,job,jobs,results){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___11631,res,vec__11449,v,p,job,jobs,results){
return (function (state_11454){
var state_val_11455 = (state_11454[(1)]);
if((state_val_11455 === (1))){
var state_11454__$1 = state_11454;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11454__$1,(2),res,v);
} else {
if((state_val_11455 === (2))){
var inst_11451 = (state_11454[(2)]);
var inst_11452 = cljs.core.async.close_BANG_.call(null,res);
var state_11454__$1 = (function (){var statearr_11456 = state_11454;
(statearr_11456[(7)] = inst_11451);

return statearr_11456;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11454__$1,inst_11452);
} else {
return null;
}
}
});})(c__11081__auto___11631,res,vec__11449,v,p,job,jobs,results))
;
return ((function (switch__10969__auto__,c__11081__auto___11631,res,vec__11449,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_11460 = [null,null,null,null,null,null,null,null];
(statearr_11460[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_11460[(1)] = (1));

return statearr_11460;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_11454){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11454);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11461){if((e11461 instanceof Object)){
var ex__10973__auto__ = e11461;
var statearr_11462_11632 = state_11454;
(statearr_11462_11632[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11461;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11633 = state_11454;
state_11454 = G__11633;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_11454){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_11454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___11631,res,vec__11449,v,p,job,jobs,results))
})();
var state__11083__auto__ = (function (){var statearr_11463 = f__11082__auto__.call(null);
(statearr_11463[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___11631);

return statearr_11463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___11631,res,vec__11449,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11464){
var vec__11465 = p__11464;
var v = cljs.core.nth.call(null,vec__11465,(0),null);
var p = cljs.core.nth.call(null,vec__11465,(1),null);
var job = vec__11465;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___11634 = n;
var __11635 = (0);
while(true){
if((__11635 < n__5571__auto___11634)){
var G__11466_11636 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11466_11636) {
case "compute":
var c__11081__auto___11638 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11635,c__11081__auto___11638,G__11466_11636,n__5571__auto___11634,jobs,results,process,async){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (__11635,c__11081__auto___11638,G__11466_11636,n__5571__auto___11634,jobs,results,process,async){
return (function (state_11479){
var state_val_11480 = (state_11479[(1)]);
if((state_val_11480 === (1))){
var state_11479__$1 = state_11479;
var statearr_11481_11639 = state_11479__$1;
(statearr_11481_11639[(2)] = null);

(statearr_11481_11639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (2))){
var state_11479__$1 = state_11479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11479__$1,(4),jobs);
} else {
if((state_val_11480 === (3))){
var inst_11477 = (state_11479[(2)]);
var state_11479__$1 = state_11479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11479__$1,inst_11477);
} else {
if((state_val_11480 === (4))){
var inst_11469 = (state_11479[(2)]);
var inst_11470 = process.call(null,inst_11469);
var state_11479__$1 = state_11479;
if(cljs.core.truth_(inst_11470)){
var statearr_11482_11640 = state_11479__$1;
(statearr_11482_11640[(1)] = (5));

} else {
var statearr_11483_11641 = state_11479__$1;
(statearr_11483_11641[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (5))){
var state_11479__$1 = state_11479;
var statearr_11484_11642 = state_11479__$1;
(statearr_11484_11642[(2)] = null);

(statearr_11484_11642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (6))){
var state_11479__$1 = state_11479;
var statearr_11485_11643 = state_11479__$1;
(statearr_11485_11643[(2)] = null);

(statearr_11485_11643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11480 === (7))){
var inst_11475 = (state_11479[(2)]);
var state_11479__$1 = state_11479;
var statearr_11486_11644 = state_11479__$1;
(statearr_11486_11644[(2)] = inst_11475);

(statearr_11486_11644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11635,c__11081__auto___11638,G__11466_11636,n__5571__auto___11634,jobs,results,process,async))
;
return ((function (__11635,switch__10969__auto__,c__11081__auto___11638,G__11466_11636,n__5571__auto___11634,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_11490 = [null,null,null,null,null,null,null];
(statearr_11490[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_11490[(1)] = (1));

return statearr_11490;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_11479){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11491){if((e11491 instanceof Object)){
var ex__10973__auto__ = e11491;
var statearr_11492_11645 = state_11479;
(statearr_11492_11645[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11479);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11491;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11646 = state_11479;
state_11479 = G__11646;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_11479){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_11479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(__11635,switch__10969__auto__,c__11081__auto___11638,G__11466_11636,n__5571__auto___11634,jobs,results,process,async))
})();
var state__11083__auto__ = (function (){var statearr_11493 = f__11082__auto__.call(null);
(statearr_11493[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___11638);

return statearr_11493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(__11635,c__11081__auto___11638,G__11466_11636,n__5571__auto___11634,jobs,results,process,async))
);


break;
case "async":
var c__11081__auto___11647 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11635,c__11081__auto___11647,G__11466_11636,n__5571__auto___11634,jobs,results,process,async){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (__11635,c__11081__auto___11647,G__11466_11636,n__5571__auto___11634,jobs,results,process,async){
return (function (state_11506){
var state_val_11507 = (state_11506[(1)]);
if((state_val_11507 === (1))){
var state_11506__$1 = state_11506;
var statearr_11508_11648 = state_11506__$1;
(statearr_11508_11648[(2)] = null);

(statearr_11508_11648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11507 === (2))){
var state_11506__$1 = state_11506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11506__$1,(4),jobs);
} else {
if((state_val_11507 === (3))){
var inst_11504 = (state_11506[(2)]);
var state_11506__$1 = state_11506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11506__$1,inst_11504);
} else {
if((state_val_11507 === (4))){
var inst_11496 = (state_11506[(2)]);
var inst_11497 = async.call(null,inst_11496);
var state_11506__$1 = state_11506;
if(cljs.core.truth_(inst_11497)){
var statearr_11509_11649 = state_11506__$1;
(statearr_11509_11649[(1)] = (5));

} else {
var statearr_11510_11650 = state_11506__$1;
(statearr_11510_11650[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11507 === (5))){
var state_11506__$1 = state_11506;
var statearr_11511_11651 = state_11506__$1;
(statearr_11511_11651[(2)] = null);

(statearr_11511_11651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11507 === (6))){
var state_11506__$1 = state_11506;
var statearr_11512_11652 = state_11506__$1;
(statearr_11512_11652[(2)] = null);

(statearr_11512_11652[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11507 === (7))){
var inst_11502 = (state_11506[(2)]);
var state_11506__$1 = state_11506;
var statearr_11513_11653 = state_11506__$1;
(statearr_11513_11653[(2)] = inst_11502);

(statearr_11513_11653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11635,c__11081__auto___11647,G__11466_11636,n__5571__auto___11634,jobs,results,process,async))
;
return ((function (__11635,switch__10969__auto__,c__11081__auto___11647,G__11466_11636,n__5571__auto___11634,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_11517 = [null,null,null,null,null,null,null];
(statearr_11517[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_11517[(1)] = (1));

return statearr_11517;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_11506){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11518){if((e11518 instanceof Object)){
var ex__10973__auto__ = e11518;
var statearr_11519_11654 = state_11506;
(statearr_11519_11654[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11518;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11655 = state_11506;
state_11506 = G__11655;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_11506){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_11506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(__11635,switch__10969__auto__,c__11081__auto___11647,G__11466_11636,n__5571__auto___11634,jobs,results,process,async))
})();
var state__11083__auto__ = (function (){var statearr_11520 = f__11082__auto__.call(null);
(statearr_11520[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___11647);

return statearr_11520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(__11635,c__11081__auto___11647,G__11466_11636,n__5571__auto___11634,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11656 = (__11635 + (1));
__11635 = G__11656;
continue;
} else {
}
break;
}

var c__11081__auto___11657 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___11657,jobs,results,process,async){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___11657,jobs,results,process,async){
return (function (state_11542){
var state_val_11543 = (state_11542[(1)]);
if((state_val_11543 === (1))){
var state_11542__$1 = state_11542;
var statearr_11544_11658 = state_11542__$1;
(statearr_11544_11658[(2)] = null);

(statearr_11544_11658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11543 === (2))){
var state_11542__$1 = state_11542;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11542__$1,(4),from);
} else {
if((state_val_11543 === (3))){
var inst_11540 = (state_11542[(2)]);
var state_11542__$1 = state_11542;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11542__$1,inst_11540);
} else {
if((state_val_11543 === (4))){
var inst_11523 = (state_11542[(7)]);
var inst_11523__$1 = (state_11542[(2)]);
var inst_11524 = (inst_11523__$1 == null);
var state_11542__$1 = (function (){var statearr_11545 = state_11542;
(statearr_11545[(7)] = inst_11523__$1);

return statearr_11545;
})();
if(cljs.core.truth_(inst_11524)){
var statearr_11546_11659 = state_11542__$1;
(statearr_11546_11659[(1)] = (5));

} else {
var statearr_11547_11660 = state_11542__$1;
(statearr_11547_11660[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11543 === (5))){
var inst_11526 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11542__$1 = state_11542;
var statearr_11548_11661 = state_11542__$1;
(statearr_11548_11661[(2)] = inst_11526);

(statearr_11548_11661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11543 === (6))){
var inst_11523 = (state_11542[(7)]);
var inst_11528 = (state_11542[(8)]);
var inst_11528__$1 = cljs.core.async.chan.call(null,(1));
var inst_11529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11530 = [inst_11523,inst_11528__$1];
var inst_11531 = (new cljs.core.PersistentVector(null,2,(5),inst_11529,inst_11530,null));
var state_11542__$1 = (function (){var statearr_11549 = state_11542;
(statearr_11549[(8)] = inst_11528__$1);

return statearr_11549;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11542__$1,(8),jobs,inst_11531);
} else {
if((state_val_11543 === (7))){
var inst_11538 = (state_11542[(2)]);
var state_11542__$1 = state_11542;
var statearr_11550_11662 = state_11542__$1;
(statearr_11550_11662[(2)] = inst_11538);

(statearr_11550_11662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11543 === (8))){
var inst_11528 = (state_11542[(8)]);
var inst_11533 = (state_11542[(2)]);
var state_11542__$1 = (function (){var statearr_11551 = state_11542;
(statearr_11551[(9)] = inst_11533);

return statearr_11551;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11542__$1,(9),results,inst_11528);
} else {
if((state_val_11543 === (9))){
var inst_11535 = (state_11542[(2)]);
var state_11542__$1 = (function (){var statearr_11552 = state_11542;
(statearr_11552[(10)] = inst_11535);

return statearr_11552;
})();
var statearr_11553_11663 = state_11542__$1;
(statearr_11553_11663[(2)] = null);

(statearr_11553_11663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___11657,jobs,results,process,async))
;
return ((function (switch__10969__auto__,c__11081__auto___11657,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_11557 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11557[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_11557[(1)] = (1));

return statearr_11557;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_11542){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11542);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11558){if((e11558 instanceof Object)){
var ex__10973__auto__ = e11558;
var statearr_11559_11664 = state_11542;
(statearr_11559_11664[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11542);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11558;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11665 = state_11542;
state_11542 = G__11665;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_11542){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_11542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___11657,jobs,results,process,async))
})();
var state__11083__auto__ = (function (){var statearr_11560 = f__11082__auto__.call(null);
(statearr_11560[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___11657);

return statearr_11560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___11657,jobs,results,process,async))
);


var c__11081__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto__,jobs,results,process,async){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto__,jobs,results,process,async){
return (function (state_11598){
var state_val_11599 = (state_11598[(1)]);
if((state_val_11599 === (7))){
var inst_11594 = (state_11598[(2)]);
var state_11598__$1 = state_11598;
var statearr_11600_11666 = state_11598__$1;
(statearr_11600_11666[(2)] = inst_11594);

(statearr_11600_11666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (20))){
var state_11598__$1 = state_11598;
var statearr_11601_11667 = state_11598__$1;
(statearr_11601_11667[(2)] = null);

(statearr_11601_11667[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (1))){
var state_11598__$1 = state_11598;
var statearr_11602_11668 = state_11598__$1;
(statearr_11602_11668[(2)] = null);

(statearr_11602_11668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (4))){
var inst_11563 = (state_11598[(7)]);
var inst_11563__$1 = (state_11598[(2)]);
var inst_11564 = (inst_11563__$1 == null);
var state_11598__$1 = (function (){var statearr_11603 = state_11598;
(statearr_11603[(7)] = inst_11563__$1);

return statearr_11603;
})();
if(cljs.core.truth_(inst_11564)){
var statearr_11604_11669 = state_11598__$1;
(statearr_11604_11669[(1)] = (5));

} else {
var statearr_11605_11670 = state_11598__$1;
(statearr_11605_11670[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (15))){
var inst_11576 = (state_11598[(8)]);
var state_11598__$1 = state_11598;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11598__$1,(18),to,inst_11576);
} else {
if((state_val_11599 === (21))){
var inst_11589 = (state_11598[(2)]);
var state_11598__$1 = state_11598;
var statearr_11606_11671 = state_11598__$1;
(statearr_11606_11671[(2)] = inst_11589);

(statearr_11606_11671[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (13))){
var inst_11591 = (state_11598[(2)]);
var state_11598__$1 = (function (){var statearr_11607 = state_11598;
(statearr_11607[(9)] = inst_11591);

return statearr_11607;
})();
var statearr_11608_11672 = state_11598__$1;
(statearr_11608_11672[(2)] = null);

(statearr_11608_11672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (6))){
var inst_11563 = (state_11598[(7)]);
var state_11598__$1 = state_11598;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11598__$1,(11),inst_11563);
} else {
if((state_val_11599 === (17))){
var inst_11584 = (state_11598[(2)]);
var state_11598__$1 = state_11598;
if(cljs.core.truth_(inst_11584)){
var statearr_11609_11673 = state_11598__$1;
(statearr_11609_11673[(1)] = (19));

} else {
var statearr_11610_11674 = state_11598__$1;
(statearr_11610_11674[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (3))){
var inst_11596 = (state_11598[(2)]);
var state_11598__$1 = state_11598;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11598__$1,inst_11596);
} else {
if((state_val_11599 === (12))){
var inst_11573 = (state_11598[(10)]);
var state_11598__$1 = state_11598;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11598__$1,(14),inst_11573);
} else {
if((state_val_11599 === (2))){
var state_11598__$1 = state_11598;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11598__$1,(4),results);
} else {
if((state_val_11599 === (19))){
var state_11598__$1 = state_11598;
var statearr_11611_11675 = state_11598__$1;
(statearr_11611_11675[(2)] = null);

(statearr_11611_11675[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (11))){
var inst_11573 = (state_11598[(2)]);
var state_11598__$1 = (function (){var statearr_11612 = state_11598;
(statearr_11612[(10)] = inst_11573);

return statearr_11612;
})();
var statearr_11613_11676 = state_11598__$1;
(statearr_11613_11676[(2)] = null);

(statearr_11613_11676[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (9))){
var state_11598__$1 = state_11598;
var statearr_11614_11677 = state_11598__$1;
(statearr_11614_11677[(2)] = null);

(statearr_11614_11677[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (5))){
var state_11598__$1 = state_11598;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11615_11678 = state_11598__$1;
(statearr_11615_11678[(1)] = (8));

} else {
var statearr_11616_11679 = state_11598__$1;
(statearr_11616_11679[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (14))){
var inst_11578 = (state_11598[(11)]);
var inst_11576 = (state_11598[(8)]);
var inst_11576__$1 = (state_11598[(2)]);
var inst_11577 = (inst_11576__$1 == null);
var inst_11578__$1 = cljs.core.not.call(null,inst_11577);
var state_11598__$1 = (function (){var statearr_11617 = state_11598;
(statearr_11617[(11)] = inst_11578__$1);

(statearr_11617[(8)] = inst_11576__$1);

return statearr_11617;
})();
if(inst_11578__$1){
var statearr_11618_11680 = state_11598__$1;
(statearr_11618_11680[(1)] = (15));

} else {
var statearr_11619_11681 = state_11598__$1;
(statearr_11619_11681[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (16))){
var inst_11578 = (state_11598[(11)]);
var state_11598__$1 = state_11598;
var statearr_11620_11682 = state_11598__$1;
(statearr_11620_11682[(2)] = inst_11578);

(statearr_11620_11682[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (10))){
var inst_11570 = (state_11598[(2)]);
var state_11598__$1 = state_11598;
var statearr_11621_11683 = state_11598__$1;
(statearr_11621_11683[(2)] = inst_11570);

(statearr_11621_11683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (18))){
var inst_11581 = (state_11598[(2)]);
var state_11598__$1 = state_11598;
var statearr_11622_11684 = state_11598__$1;
(statearr_11622_11684[(2)] = inst_11581);

(statearr_11622_11684[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11599 === (8))){
var inst_11567 = cljs.core.async.close_BANG_.call(null,to);
var state_11598__$1 = state_11598;
var statearr_11623_11685 = state_11598__$1;
(statearr_11623_11685[(2)] = inst_11567);

(statearr_11623_11685[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto__,jobs,results,process,async))
;
return ((function (switch__10969__auto__,c__11081__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_11627 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11627[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__);

(statearr_11627[(1)] = (1));

return statearr_11627;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1 = (function (state_11598){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11598);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11628){if((e11628 instanceof Object)){
var ex__10973__auto__ = e11628;
var statearr_11629_11686 = state_11598;
(statearr_11629_11686[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11598);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11628;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11687 = state_11598;
state_11598 = G__11687;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__ = function(state_11598){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1.call(this,state_11598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto__,jobs,results,process,async))
})();
var state__11083__auto__ = (function (){var statearr_11630 = f__11082__auto__.call(null);
(statearr_11630[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto__);

return statearr_11630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto__,jobs,results,process,async))
);

return c__11081__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11688 = [];
var len__5726__auto___11691 = arguments.length;
var i__5727__auto___11692 = (0);
while(true){
if((i__5727__auto___11692 < len__5726__auto___11691)){
args11688.push((arguments[i__5727__auto___11692]));

var G__11693 = (i__5727__auto___11692 + (1));
i__5727__auto___11692 = G__11693;
continue;
} else {
}
break;
}

var G__11690 = args11688.length;
switch (G__11690) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11688.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11695 = [];
var len__5726__auto___11698 = arguments.length;
var i__5727__auto___11699 = (0);
while(true){
if((i__5727__auto___11699 < len__5726__auto___11698)){
args11695.push((arguments[i__5727__auto___11699]));

var G__11700 = (i__5727__auto___11699 + (1));
i__5727__auto___11699 = G__11700;
continue;
} else {
}
break;
}

var G__11697 = args11695.length;
switch (G__11697) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11695.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11702 = [];
var len__5726__auto___11755 = arguments.length;
var i__5727__auto___11756 = (0);
while(true){
if((i__5727__auto___11756 < len__5726__auto___11755)){
args11702.push((arguments[i__5727__auto___11756]));

var G__11757 = (i__5727__auto___11756 + (1));
i__5727__auto___11756 = G__11757;
continue;
} else {
}
break;
}

var G__11704 = args11702.length;
switch (G__11704) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11702.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11081__auto___11759 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___11759,tc,fc){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___11759,tc,fc){
return (function (state_11730){
var state_val_11731 = (state_11730[(1)]);
if((state_val_11731 === (7))){
var inst_11726 = (state_11730[(2)]);
var state_11730__$1 = state_11730;
var statearr_11732_11760 = state_11730__$1;
(statearr_11732_11760[(2)] = inst_11726);

(statearr_11732_11760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (1))){
var state_11730__$1 = state_11730;
var statearr_11733_11761 = state_11730__$1;
(statearr_11733_11761[(2)] = null);

(statearr_11733_11761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (4))){
var inst_11707 = (state_11730[(7)]);
var inst_11707__$1 = (state_11730[(2)]);
var inst_11708 = (inst_11707__$1 == null);
var state_11730__$1 = (function (){var statearr_11734 = state_11730;
(statearr_11734[(7)] = inst_11707__$1);

return statearr_11734;
})();
if(cljs.core.truth_(inst_11708)){
var statearr_11735_11762 = state_11730__$1;
(statearr_11735_11762[(1)] = (5));

} else {
var statearr_11736_11763 = state_11730__$1;
(statearr_11736_11763[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (13))){
var state_11730__$1 = state_11730;
var statearr_11737_11764 = state_11730__$1;
(statearr_11737_11764[(2)] = null);

(statearr_11737_11764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (6))){
var inst_11707 = (state_11730[(7)]);
var inst_11713 = p.call(null,inst_11707);
var state_11730__$1 = state_11730;
if(cljs.core.truth_(inst_11713)){
var statearr_11738_11765 = state_11730__$1;
(statearr_11738_11765[(1)] = (9));

} else {
var statearr_11739_11766 = state_11730__$1;
(statearr_11739_11766[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (3))){
var inst_11728 = (state_11730[(2)]);
var state_11730__$1 = state_11730;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11730__$1,inst_11728);
} else {
if((state_val_11731 === (12))){
var state_11730__$1 = state_11730;
var statearr_11740_11767 = state_11730__$1;
(statearr_11740_11767[(2)] = null);

(statearr_11740_11767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (2))){
var state_11730__$1 = state_11730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11730__$1,(4),ch);
} else {
if((state_val_11731 === (11))){
var inst_11707 = (state_11730[(7)]);
var inst_11717 = (state_11730[(2)]);
var state_11730__$1 = state_11730;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11730__$1,(8),inst_11717,inst_11707);
} else {
if((state_val_11731 === (9))){
var state_11730__$1 = state_11730;
var statearr_11741_11768 = state_11730__$1;
(statearr_11741_11768[(2)] = tc);

(statearr_11741_11768[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (5))){
var inst_11710 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11711 = cljs.core.async.close_BANG_.call(null,fc);
var state_11730__$1 = (function (){var statearr_11742 = state_11730;
(statearr_11742[(8)] = inst_11710);

return statearr_11742;
})();
var statearr_11743_11769 = state_11730__$1;
(statearr_11743_11769[(2)] = inst_11711);

(statearr_11743_11769[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (14))){
var inst_11724 = (state_11730[(2)]);
var state_11730__$1 = state_11730;
var statearr_11744_11770 = state_11730__$1;
(statearr_11744_11770[(2)] = inst_11724);

(statearr_11744_11770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (10))){
var state_11730__$1 = state_11730;
var statearr_11745_11771 = state_11730__$1;
(statearr_11745_11771[(2)] = fc);

(statearr_11745_11771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11731 === (8))){
var inst_11719 = (state_11730[(2)]);
var state_11730__$1 = state_11730;
if(cljs.core.truth_(inst_11719)){
var statearr_11746_11772 = state_11730__$1;
(statearr_11746_11772[(1)] = (12));

} else {
var statearr_11747_11773 = state_11730__$1;
(statearr_11747_11773[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___11759,tc,fc))
;
return ((function (switch__10969__auto__,c__11081__auto___11759,tc,fc){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_11751 = [null,null,null,null,null,null,null,null,null];
(statearr_11751[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_11751[(1)] = (1));

return statearr_11751;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_11730){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11730);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11752){if((e11752 instanceof Object)){
var ex__10973__auto__ = e11752;
var statearr_11753_11774 = state_11730;
(statearr_11753_11774[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11730);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11752;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11775 = state_11730;
state_11730 = G__11775;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_11730){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_11730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___11759,tc,fc))
})();
var state__11083__auto__ = (function (){var statearr_11754 = f__11082__auto__.call(null);
(statearr_11754[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___11759);

return statearr_11754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___11759,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11081__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto__){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto__){
return (function (state_11839){
var state_val_11840 = (state_11839[(1)]);
if((state_val_11840 === (7))){
var inst_11835 = (state_11839[(2)]);
var state_11839__$1 = state_11839;
var statearr_11841_11862 = state_11839__$1;
(statearr_11841_11862[(2)] = inst_11835);

(statearr_11841_11862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11840 === (1))){
var inst_11819 = init;
var state_11839__$1 = (function (){var statearr_11842 = state_11839;
(statearr_11842[(7)] = inst_11819);

return statearr_11842;
})();
var statearr_11843_11863 = state_11839__$1;
(statearr_11843_11863[(2)] = null);

(statearr_11843_11863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11840 === (4))){
var inst_11822 = (state_11839[(8)]);
var inst_11822__$1 = (state_11839[(2)]);
var inst_11823 = (inst_11822__$1 == null);
var state_11839__$1 = (function (){var statearr_11844 = state_11839;
(statearr_11844[(8)] = inst_11822__$1);

return statearr_11844;
})();
if(cljs.core.truth_(inst_11823)){
var statearr_11845_11864 = state_11839__$1;
(statearr_11845_11864[(1)] = (5));

} else {
var statearr_11846_11865 = state_11839__$1;
(statearr_11846_11865[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11840 === (6))){
var inst_11826 = (state_11839[(9)]);
var inst_11822 = (state_11839[(8)]);
var inst_11819 = (state_11839[(7)]);
var inst_11826__$1 = f.call(null,inst_11819,inst_11822);
var inst_11827 = cljs.core.reduced_QMARK_.call(null,inst_11826__$1);
var state_11839__$1 = (function (){var statearr_11847 = state_11839;
(statearr_11847[(9)] = inst_11826__$1);

return statearr_11847;
})();
if(inst_11827){
var statearr_11848_11866 = state_11839__$1;
(statearr_11848_11866[(1)] = (8));

} else {
var statearr_11849_11867 = state_11839__$1;
(statearr_11849_11867[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11840 === (3))){
var inst_11837 = (state_11839[(2)]);
var state_11839__$1 = state_11839;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11839__$1,inst_11837);
} else {
if((state_val_11840 === (2))){
var state_11839__$1 = state_11839;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11839__$1,(4),ch);
} else {
if((state_val_11840 === (9))){
var inst_11826 = (state_11839[(9)]);
var inst_11819 = inst_11826;
var state_11839__$1 = (function (){var statearr_11850 = state_11839;
(statearr_11850[(7)] = inst_11819);

return statearr_11850;
})();
var statearr_11851_11868 = state_11839__$1;
(statearr_11851_11868[(2)] = null);

(statearr_11851_11868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11840 === (5))){
var inst_11819 = (state_11839[(7)]);
var state_11839__$1 = state_11839;
var statearr_11852_11869 = state_11839__$1;
(statearr_11852_11869[(2)] = inst_11819);

(statearr_11852_11869[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11840 === (10))){
var inst_11833 = (state_11839[(2)]);
var state_11839__$1 = state_11839;
var statearr_11853_11870 = state_11839__$1;
(statearr_11853_11870[(2)] = inst_11833);

(statearr_11853_11870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11840 === (8))){
var inst_11826 = (state_11839[(9)]);
var inst_11829 = cljs.core.deref.call(null,inst_11826);
var state_11839__$1 = state_11839;
var statearr_11854_11871 = state_11839__$1;
(statearr_11854_11871[(2)] = inst_11829);

(statearr_11854_11871[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto__))
;
return ((function (switch__10969__auto__,c__11081__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10970__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10970__auto____0 = (function (){
var statearr_11858 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11858[(0)] = cljs$core$async$reduce_$_state_machine__10970__auto__);

(statearr_11858[(1)] = (1));

return statearr_11858;
});
var cljs$core$async$reduce_$_state_machine__10970__auto____1 = (function (state_11839){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11839);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11859){if((e11859 instanceof Object)){
var ex__10973__auto__ = e11859;
var statearr_11860_11872 = state_11839;
(statearr_11860_11872[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11839);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11859;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11873 = state_11839;
state_11839 = G__11873;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10970__auto__ = function(state_11839){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10970__auto____1.call(this,state_11839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10970__auto____0;
cljs$core$async$reduce_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10970__auto____1;
return cljs$core$async$reduce_$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto__))
})();
var state__11083__auto__ = (function (){var statearr_11861 = f__11082__auto__.call(null);
(statearr_11861[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto__);

return statearr_11861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto__))
);

return c__11081__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11874 = [];
var len__5726__auto___11926 = arguments.length;
var i__5727__auto___11927 = (0);
while(true){
if((i__5727__auto___11927 < len__5726__auto___11926)){
args11874.push((arguments[i__5727__auto___11927]));

var G__11928 = (i__5727__auto___11927 + (1));
i__5727__auto___11927 = G__11928;
continue;
} else {
}
break;
}

var G__11876 = args11874.length;
switch (G__11876) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11874.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11081__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto__){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto__){
return (function (state_11901){
var state_val_11902 = (state_11901[(1)]);
if((state_val_11902 === (7))){
var inst_11883 = (state_11901[(2)]);
var state_11901__$1 = state_11901;
var statearr_11903_11930 = state_11901__$1;
(statearr_11903_11930[(2)] = inst_11883);

(statearr_11903_11930[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (1))){
var inst_11877 = cljs.core.seq.call(null,coll);
var inst_11878 = inst_11877;
var state_11901__$1 = (function (){var statearr_11904 = state_11901;
(statearr_11904[(7)] = inst_11878);

return statearr_11904;
})();
var statearr_11905_11931 = state_11901__$1;
(statearr_11905_11931[(2)] = null);

(statearr_11905_11931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (4))){
var inst_11878 = (state_11901[(7)]);
var inst_11881 = cljs.core.first.call(null,inst_11878);
var state_11901__$1 = state_11901;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11901__$1,(7),ch,inst_11881);
} else {
if((state_val_11902 === (13))){
var inst_11895 = (state_11901[(2)]);
var state_11901__$1 = state_11901;
var statearr_11906_11932 = state_11901__$1;
(statearr_11906_11932[(2)] = inst_11895);

(statearr_11906_11932[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (6))){
var inst_11886 = (state_11901[(2)]);
var state_11901__$1 = state_11901;
if(cljs.core.truth_(inst_11886)){
var statearr_11907_11933 = state_11901__$1;
(statearr_11907_11933[(1)] = (8));

} else {
var statearr_11908_11934 = state_11901__$1;
(statearr_11908_11934[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (3))){
var inst_11899 = (state_11901[(2)]);
var state_11901__$1 = state_11901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11901__$1,inst_11899);
} else {
if((state_val_11902 === (12))){
var state_11901__$1 = state_11901;
var statearr_11909_11935 = state_11901__$1;
(statearr_11909_11935[(2)] = null);

(statearr_11909_11935[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (2))){
var inst_11878 = (state_11901[(7)]);
var state_11901__$1 = state_11901;
if(cljs.core.truth_(inst_11878)){
var statearr_11910_11936 = state_11901__$1;
(statearr_11910_11936[(1)] = (4));

} else {
var statearr_11911_11937 = state_11901__$1;
(statearr_11911_11937[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (11))){
var inst_11892 = cljs.core.async.close_BANG_.call(null,ch);
var state_11901__$1 = state_11901;
var statearr_11912_11938 = state_11901__$1;
(statearr_11912_11938[(2)] = inst_11892);

(statearr_11912_11938[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (9))){
var state_11901__$1 = state_11901;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11913_11939 = state_11901__$1;
(statearr_11913_11939[(1)] = (11));

} else {
var statearr_11914_11940 = state_11901__$1;
(statearr_11914_11940[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (5))){
var inst_11878 = (state_11901[(7)]);
var state_11901__$1 = state_11901;
var statearr_11915_11941 = state_11901__$1;
(statearr_11915_11941[(2)] = inst_11878);

(statearr_11915_11941[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (10))){
var inst_11897 = (state_11901[(2)]);
var state_11901__$1 = state_11901;
var statearr_11916_11942 = state_11901__$1;
(statearr_11916_11942[(2)] = inst_11897);

(statearr_11916_11942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11902 === (8))){
var inst_11878 = (state_11901[(7)]);
var inst_11888 = cljs.core.next.call(null,inst_11878);
var inst_11878__$1 = inst_11888;
var state_11901__$1 = (function (){var statearr_11917 = state_11901;
(statearr_11917[(7)] = inst_11878__$1);

return statearr_11917;
})();
var statearr_11918_11943 = state_11901__$1;
(statearr_11918_11943[(2)] = null);

(statearr_11918_11943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto__))
;
return ((function (switch__10969__auto__,c__11081__auto__){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_11922 = [null,null,null,null,null,null,null,null];
(statearr_11922[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_11922[(1)] = (1));

return statearr_11922;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_11901){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_11901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e11923){if((e11923 instanceof Object)){
var ex__10973__auto__ = e11923;
var statearr_11924_11944 = state_11901;
(statearr_11924_11944[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11901);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11923;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11945 = state_11901;
state_11901 = G__11945;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_11901){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_11901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto__))
})();
var state__11083__auto__ = (function (){var statearr_11925 = f__11082__auto__.call(null);
(statearr_11925[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto__);

return statearr_11925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto__))
);

return c__11081__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12167 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12167 = (function (mult,ch,cs,meta12168){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12168 = meta12168;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12167.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12169,meta12168__$1){
var self__ = this;
var _12169__$1 = this;
return (new cljs.core.async.t_cljs$core$async12167(self__.mult,self__.ch,self__.cs,meta12168__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12167.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12169){
var self__ = this;
var _12169__$1 = this;
return self__.meta12168;
});})(cs))
;

cljs.core.async.t_cljs$core$async12167.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12167.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12167.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12167.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12167.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12167.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12167.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12168","meta12168",1792519016,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12167.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12167.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12167";

cljs.core.async.t_cljs$core$async12167.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12167");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12167 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12167(mult__$1,ch__$1,cs__$1,meta12168){
return (new cljs.core.async.t_cljs$core$async12167(mult__$1,ch__$1,cs__$1,meta12168));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12167(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11081__auto___12388 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___12388,cs,m,dchan,dctr,done){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___12388,cs,m,dchan,dctr,done){
return (function (state_12300){
var state_val_12301 = (state_12300[(1)]);
if((state_val_12301 === (7))){
var inst_12296 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12302_12389 = state_12300__$1;
(statearr_12302_12389[(2)] = inst_12296);

(statearr_12302_12389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (20))){
var inst_12201 = (state_12300[(7)]);
var inst_12211 = cljs.core.first.call(null,inst_12201);
var inst_12212 = cljs.core.nth.call(null,inst_12211,(0),null);
var inst_12213 = cljs.core.nth.call(null,inst_12211,(1),null);
var state_12300__$1 = (function (){var statearr_12303 = state_12300;
(statearr_12303[(8)] = inst_12212);

return statearr_12303;
})();
if(cljs.core.truth_(inst_12213)){
var statearr_12304_12390 = state_12300__$1;
(statearr_12304_12390[(1)] = (22));

} else {
var statearr_12305_12391 = state_12300__$1;
(statearr_12305_12391[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (27))){
var inst_12248 = (state_12300[(9)]);
var inst_12172 = (state_12300[(10)]);
var inst_12241 = (state_12300[(11)]);
var inst_12243 = (state_12300[(12)]);
var inst_12248__$1 = cljs.core._nth.call(null,inst_12241,inst_12243);
var inst_12249 = cljs.core.async.put_BANG_.call(null,inst_12248__$1,inst_12172,done);
var state_12300__$1 = (function (){var statearr_12306 = state_12300;
(statearr_12306[(9)] = inst_12248__$1);

return statearr_12306;
})();
if(cljs.core.truth_(inst_12249)){
var statearr_12307_12392 = state_12300__$1;
(statearr_12307_12392[(1)] = (30));

} else {
var statearr_12308_12393 = state_12300__$1;
(statearr_12308_12393[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (1))){
var state_12300__$1 = state_12300;
var statearr_12309_12394 = state_12300__$1;
(statearr_12309_12394[(2)] = null);

(statearr_12309_12394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (24))){
var inst_12201 = (state_12300[(7)]);
var inst_12218 = (state_12300[(2)]);
var inst_12219 = cljs.core.next.call(null,inst_12201);
var inst_12181 = inst_12219;
var inst_12182 = null;
var inst_12183 = (0);
var inst_12184 = (0);
var state_12300__$1 = (function (){var statearr_12310 = state_12300;
(statearr_12310[(13)] = inst_12182);

(statearr_12310[(14)] = inst_12181);

(statearr_12310[(15)] = inst_12183);

(statearr_12310[(16)] = inst_12218);

(statearr_12310[(17)] = inst_12184);

return statearr_12310;
})();
var statearr_12311_12395 = state_12300__$1;
(statearr_12311_12395[(2)] = null);

(statearr_12311_12395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (39))){
var state_12300__$1 = state_12300;
var statearr_12315_12396 = state_12300__$1;
(statearr_12315_12396[(2)] = null);

(statearr_12315_12396[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (4))){
var inst_12172 = (state_12300[(10)]);
var inst_12172__$1 = (state_12300[(2)]);
var inst_12173 = (inst_12172__$1 == null);
var state_12300__$1 = (function (){var statearr_12316 = state_12300;
(statearr_12316[(10)] = inst_12172__$1);

return statearr_12316;
})();
if(cljs.core.truth_(inst_12173)){
var statearr_12317_12397 = state_12300__$1;
(statearr_12317_12397[(1)] = (5));

} else {
var statearr_12318_12398 = state_12300__$1;
(statearr_12318_12398[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (15))){
var inst_12182 = (state_12300[(13)]);
var inst_12181 = (state_12300[(14)]);
var inst_12183 = (state_12300[(15)]);
var inst_12184 = (state_12300[(17)]);
var inst_12197 = (state_12300[(2)]);
var inst_12198 = (inst_12184 + (1));
var tmp12312 = inst_12182;
var tmp12313 = inst_12181;
var tmp12314 = inst_12183;
var inst_12181__$1 = tmp12313;
var inst_12182__$1 = tmp12312;
var inst_12183__$1 = tmp12314;
var inst_12184__$1 = inst_12198;
var state_12300__$1 = (function (){var statearr_12319 = state_12300;
(statearr_12319[(13)] = inst_12182__$1);

(statearr_12319[(14)] = inst_12181__$1);

(statearr_12319[(15)] = inst_12183__$1);

(statearr_12319[(18)] = inst_12197);

(statearr_12319[(17)] = inst_12184__$1);

return statearr_12319;
})();
var statearr_12320_12399 = state_12300__$1;
(statearr_12320_12399[(2)] = null);

(statearr_12320_12399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (21))){
var inst_12222 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12324_12400 = state_12300__$1;
(statearr_12324_12400[(2)] = inst_12222);

(statearr_12324_12400[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (31))){
var inst_12248 = (state_12300[(9)]);
var inst_12252 = done.call(null,null);
var inst_12253 = cljs.core.async.untap_STAR_.call(null,m,inst_12248);
var state_12300__$1 = (function (){var statearr_12325 = state_12300;
(statearr_12325[(19)] = inst_12252);

return statearr_12325;
})();
var statearr_12326_12401 = state_12300__$1;
(statearr_12326_12401[(2)] = inst_12253);

(statearr_12326_12401[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (32))){
var inst_12240 = (state_12300[(20)]);
var inst_12242 = (state_12300[(21)]);
var inst_12241 = (state_12300[(11)]);
var inst_12243 = (state_12300[(12)]);
var inst_12255 = (state_12300[(2)]);
var inst_12256 = (inst_12243 + (1));
var tmp12321 = inst_12240;
var tmp12322 = inst_12242;
var tmp12323 = inst_12241;
var inst_12240__$1 = tmp12321;
var inst_12241__$1 = tmp12323;
var inst_12242__$1 = tmp12322;
var inst_12243__$1 = inst_12256;
var state_12300__$1 = (function (){var statearr_12327 = state_12300;
(statearr_12327[(20)] = inst_12240__$1);

(statearr_12327[(21)] = inst_12242__$1);

(statearr_12327[(22)] = inst_12255);

(statearr_12327[(11)] = inst_12241__$1);

(statearr_12327[(12)] = inst_12243__$1);

return statearr_12327;
})();
var statearr_12328_12402 = state_12300__$1;
(statearr_12328_12402[(2)] = null);

(statearr_12328_12402[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (40))){
var inst_12268 = (state_12300[(23)]);
var inst_12272 = done.call(null,null);
var inst_12273 = cljs.core.async.untap_STAR_.call(null,m,inst_12268);
var state_12300__$1 = (function (){var statearr_12329 = state_12300;
(statearr_12329[(24)] = inst_12272);

return statearr_12329;
})();
var statearr_12330_12403 = state_12300__$1;
(statearr_12330_12403[(2)] = inst_12273);

(statearr_12330_12403[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (33))){
var inst_12259 = (state_12300[(25)]);
var inst_12261 = cljs.core.chunked_seq_QMARK_.call(null,inst_12259);
var state_12300__$1 = state_12300;
if(inst_12261){
var statearr_12331_12404 = state_12300__$1;
(statearr_12331_12404[(1)] = (36));

} else {
var statearr_12332_12405 = state_12300__$1;
(statearr_12332_12405[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (13))){
var inst_12191 = (state_12300[(26)]);
var inst_12194 = cljs.core.async.close_BANG_.call(null,inst_12191);
var state_12300__$1 = state_12300;
var statearr_12333_12406 = state_12300__$1;
(statearr_12333_12406[(2)] = inst_12194);

(statearr_12333_12406[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (22))){
var inst_12212 = (state_12300[(8)]);
var inst_12215 = cljs.core.async.close_BANG_.call(null,inst_12212);
var state_12300__$1 = state_12300;
var statearr_12334_12407 = state_12300__$1;
(statearr_12334_12407[(2)] = inst_12215);

(statearr_12334_12407[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (36))){
var inst_12259 = (state_12300[(25)]);
var inst_12263 = cljs.core.chunk_first.call(null,inst_12259);
var inst_12264 = cljs.core.chunk_rest.call(null,inst_12259);
var inst_12265 = cljs.core.count.call(null,inst_12263);
var inst_12240 = inst_12264;
var inst_12241 = inst_12263;
var inst_12242 = inst_12265;
var inst_12243 = (0);
var state_12300__$1 = (function (){var statearr_12335 = state_12300;
(statearr_12335[(20)] = inst_12240);

(statearr_12335[(21)] = inst_12242);

(statearr_12335[(11)] = inst_12241);

(statearr_12335[(12)] = inst_12243);

return statearr_12335;
})();
var statearr_12336_12408 = state_12300__$1;
(statearr_12336_12408[(2)] = null);

(statearr_12336_12408[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (41))){
var inst_12259 = (state_12300[(25)]);
var inst_12275 = (state_12300[(2)]);
var inst_12276 = cljs.core.next.call(null,inst_12259);
var inst_12240 = inst_12276;
var inst_12241 = null;
var inst_12242 = (0);
var inst_12243 = (0);
var state_12300__$1 = (function (){var statearr_12337 = state_12300;
(statearr_12337[(20)] = inst_12240);

(statearr_12337[(21)] = inst_12242);

(statearr_12337[(11)] = inst_12241);

(statearr_12337[(12)] = inst_12243);

(statearr_12337[(27)] = inst_12275);

return statearr_12337;
})();
var statearr_12338_12409 = state_12300__$1;
(statearr_12338_12409[(2)] = null);

(statearr_12338_12409[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (43))){
var state_12300__$1 = state_12300;
var statearr_12339_12410 = state_12300__$1;
(statearr_12339_12410[(2)] = null);

(statearr_12339_12410[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (29))){
var inst_12284 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12340_12411 = state_12300__$1;
(statearr_12340_12411[(2)] = inst_12284);

(statearr_12340_12411[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (44))){
var inst_12293 = (state_12300[(2)]);
var state_12300__$1 = (function (){var statearr_12341 = state_12300;
(statearr_12341[(28)] = inst_12293);

return statearr_12341;
})();
var statearr_12342_12412 = state_12300__$1;
(statearr_12342_12412[(2)] = null);

(statearr_12342_12412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (6))){
var inst_12232 = (state_12300[(29)]);
var inst_12231 = cljs.core.deref.call(null,cs);
var inst_12232__$1 = cljs.core.keys.call(null,inst_12231);
var inst_12233 = cljs.core.count.call(null,inst_12232__$1);
var inst_12234 = cljs.core.reset_BANG_.call(null,dctr,inst_12233);
var inst_12239 = cljs.core.seq.call(null,inst_12232__$1);
var inst_12240 = inst_12239;
var inst_12241 = null;
var inst_12242 = (0);
var inst_12243 = (0);
var state_12300__$1 = (function (){var statearr_12343 = state_12300;
(statearr_12343[(20)] = inst_12240);

(statearr_12343[(21)] = inst_12242);

(statearr_12343[(11)] = inst_12241);

(statearr_12343[(12)] = inst_12243);

(statearr_12343[(29)] = inst_12232__$1);

(statearr_12343[(30)] = inst_12234);

return statearr_12343;
})();
var statearr_12344_12413 = state_12300__$1;
(statearr_12344_12413[(2)] = null);

(statearr_12344_12413[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (28))){
var inst_12259 = (state_12300[(25)]);
var inst_12240 = (state_12300[(20)]);
var inst_12259__$1 = cljs.core.seq.call(null,inst_12240);
var state_12300__$1 = (function (){var statearr_12345 = state_12300;
(statearr_12345[(25)] = inst_12259__$1);

return statearr_12345;
})();
if(inst_12259__$1){
var statearr_12346_12414 = state_12300__$1;
(statearr_12346_12414[(1)] = (33));

} else {
var statearr_12347_12415 = state_12300__$1;
(statearr_12347_12415[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (25))){
var inst_12242 = (state_12300[(21)]);
var inst_12243 = (state_12300[(12)]);
var inst_12245 = (inst_12243 < inst_12242);
var inst_12246 = inst_12245;
var state_12300__$1 = state_12300;
if(cljs.core.truth_(inst_12246)){
var statearr_12348_12416 = state_12300__$1;
(statearr_12348_12416[(1)] = (27));

} else {
var statearr_12349_12417 = state_12300__$1;
(statearr_12349_12417[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (34))){
var state_12300__$1 = state_12300;
var statearr_12350_12418 = state_12300__$1;
(statearr_12350_12418[(2)] = null);

(statearr_12350_12418[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (17))){
var state_12300__$1 = state_12300;
var statearr_12351_12419 = state_12300__$1;
(statearr_12351_12419[(2)] = null);

(statearr_12351_12419[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (3))){
var inst_12298 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12300__$1,inst_12298);
} else {
if((state_val_12301 === (12))){
var inst_12227 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12352_12420 = state_12300__$1;
(statearr_12352_12420[(2)] = inst_12227);

(statearr_12352_12420[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (2))){
var state_12300__$1 = state_12300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12300__$1,(4),ch);
} else {
if((state_val_12301 === (23))){
var state_12300__$1 = state_12300;
var statearr_12353_12421 = state_12300__$1;
(statearr_12353_12421[(2)] = null);

(statearr_12353_12421[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (35))){
var inst_12282 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12354_12422 = state_12300__$1;
(statearr_12354_12422[(2)] = inst_12282);

(statearr_12354_12422[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (19))){
var inst_12201 = (state_12300[(7)]);
var inst_12205 = cljs.core.chunk_first.call(null,inst_12201);
var inst_12206 = cljs.core.chunk_rest.call(null,inst_12201);
var inst_12207 = cljs.core.count.call(null,inst_12205);
var inst_12181 = inst_12206;
var inst_12182 = inst_12205;
var inst_12183 = inst_12207;
var inst_12184 = (0);
var state_12300__$1 = (function (){var statearr_12355 = state_12300;
(statearr_12355[(13)] = inst_12182);

(statearr_12355[(14)] = inst_12181);

(statearr_12355[(15)] = inst_12183);

(statearr_12355[(17)] = inst_12184);

return statearr_12355;
})();
var statearr_12356_12423 = state_12300__$1;
(statearr_12356_12423[(2)] = null);

(statearr_12356_12423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (11))){
var inst_12181 = (state_12300[(14)]);
var inst_12201 = (state_12300[(7)]);
var inst_12201__$1 = cljs.core.seq.call(null,inst_12181);
var state_12300__$1 = (function (){var statearr_12357 = state_12300;
(statearr_12357[(7)] = inst_12201__$1);

return statearr_12357;
})();
if(inst_12201__$1){
var statearr_12358_12424 = state_12300__$1;
(statearr_12358_12424[(1)] = (16));

} else {
var statearr_12359_12425 = state_12300__$1;
(statearr_12359_12425[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (9))){
var inst_12229 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12360_12426 = state_12300__$1;
(statearr_12360_12426[(2)] = inst_12229);

(statearr_12360_12426[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (5))){
var inst_12179 = cljs.core.deref.call(null,cs);
var inst_12180 = cljs.core.seq.call(null,inst_12179);
var inst_12181 = inst_12180;
var inst_12182 = null;
var inst_12183 = (0);
var inst_12184 = (0);
var state_12300__$1 = (function (){var statearr_12361 = state_12300;
(statearr_12361[(13)] = inst_12182);

(statearr_12361[(14)] = inst_12181);

(statearr_12361[(15)] = inst_12183);

(statearr_12361[(17)] = inst_12184);

return statearr_12361;
})();
var statearr_12362_12427 = state_12300__$1;
(statearr_12362_12427[(2)] = null);

(statearr_12362_12427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (14))){
var state_12300__$1 = state_12300;
var statearr_12363_12428 = state_12300__$1;
(statearr_12363_12428[(2)] = null);

(statearr_12363_12428[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (45))){
var inst_12290 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12364_12429 = state_12300__$1;
(statearr_12364_12429[(2)] = inst_12290);

(statearr_12364_12429[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (26))){
var inst_12232 = (state_12300[(29)]);
var inst_12286 = (state_12300[(2)]);
var inst_12287 = cljs.core.seq.call(null,inst_12232);
var state_12300__$1 = (function (){var statearr_12365 = state_12300;
(statearr_12365[(31)] = inst_12286);

return statearr_12365;
})();
if(inst_12287){
var statearr_12366_12430 = state_12300__$1;
(statearr_12366_12430[(1)] = (42));

} else {
var statearr_12367_12431 = state_12300__$1;
(statearr_12367_12431[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (16))){
var inst_12201 = (state_12300[(7)]);
var inst_12203 = cljs.core.chunked_seq_QMARK_.call(null,inst_12201);
var state_12300__$1 = state_12300;
if(inst_12203){
var statearr_12368_12432 = state_12300__$1;
(statearr_12368_12432[(1)] = (19));

} else {
var statearr_12369_12433 = state_12300__$1;
(statearr_12369_12433[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (38))){
var inst_12279 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12370_12434 = state_12300__$1;
(statearr_12370_12434[(2)] = inst_12279);

(statearr_12370_12434[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (30))){
var state_12300__$1 = state_12300;
var statearr_12371_12435 = state_12300__$1;
(statearr_12371_12435[(2)] = null);

(statearr_12371_12435[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (10))){
var inst_12182 = (state_12300[(13)]);
var inst_12184 = (state_12300[(17)]);
var inst_12190 = cljs.core._nth.call(null,inst_12182,inst_12184);
var inst_12191 = cljs.core.nth.call(null,inst_12190,(0),null);
var inst_12192 = cljs.core.nth.call(null,inst_12190,(1),null);
var state_12300__$1 = (function (){var statearr_12372 = state_12300;
(statearr_12372[(26)] = inst_12191);

return statearr_12372;
})();
if(cljs.core.truth_(inst_12192)){
var statearr_12373_12436 = state_12300__$1;
(statearr_12373_12436[(1)] = (13));

} else {
var statearr_12374_12437 = state_12300__$1;
(statearr_12374_12437[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (18))){
var inst_12225 = (state_12300[(2)]);
var state_12300__$1 = state_12300;
var statearr_12375_12438 = state_12300__$1;
(statearr_12375_12438[(2)] = inst_12225);

(statearr_12375_12438[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (42))){
var state_12300__$1 = state_12300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12300__$1,(45),dchan);
} else {
if((state_val_12301 === (37))){
var inst_12259 = (state_12300[(25)]);
var inst_12268 = (state_12300[(23)]);
var inst_12172 = (state_12300[(10)]);
var inst_12268__$1 = cljs.core.first.call(null,inst_12259);
var inst_12269 = cljs.core.async.put_BANG_.call(null,inst_12268__$1,inst_12172,done);
var state_12300__$1 = (function (){var statearr_12376 = state_12300;
(statearr_12376[(23)] = inst_12268__$1);

return statearr_12376;
})();
if(cljs.core.truth_(inst_12269)){
var statearr_12377_12439 = state_12300__$1;
(statearr_12377_12439[(1)] = (39));

} else {
var statearr_12378_12440 = state_12300__$1;
(statearr_12378_12440[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12301 === (8))){
var inst_12183 = (state_12300[(15)]);
var inst_12184 = (state_12300[(17)]);
var inst_12186 = (inst_12184 < inst_12183);
var inst_12187 = inst_12186;
var state_12300__$1 = state_12300;
if(cljs.core.truth_(inst_12187)){
var statearr_12379_12441 = state_12300__$1;
(statearr_12379_12441[(1)] = (10));

} else {
var statearr_12380_12442 = state_12300__$1;
(statearr_12380_12442[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___12388,cs,m,dchan,dctr,done))
;
return ((function (switch__10969__auto__,c__11081__auto___12388,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10970__auto__ = null;
var cljs$core$async$mult_$_state_machine__10970__auto____0 = (function (){
var statearr_12384 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12384[(0)] = cljs$core$async$mult_$_state_machine__10970__auto__);

(statearr_12384[(1)] = (1));

return statearr_12384;
});
var cljs$core$async$mult_$_state_machine__10970__auto____1 = (function (state_12300){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_12300);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e12385){if((e12385 instanceof Object)){
var ex__10973__auto__ = e12385;
var statearr_12386_12443 = state_12300;
(statearr_12386_12443[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12300);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12444 = state_12300;
state_12300 = G__12444;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10970__auto__ = function(state_12300){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10970__auto____1.call(this,state_12300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10970__auto____0;
cljs$core$async$mult_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10970__auto____1;
return cljs$core$async$mult_$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___12388,cs,m,dchan,dctr,done))
})();
var state__11083__auto__ = (function (){var statearr_12387 = f__11082__auto__.call(null);
(statearr_12387[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___12388);

return statearr_12387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___12388,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args12445 = [];
var len__5726__auto___12448 = arguments.length;
var i__5727__auto___12449 = (0);
while(true){
if((i__5727__auto___12449 < len__5726__auto___12448)){
args12445.push((arguments[i__5727__auto___12449]));

var G__12450 = (i__5727__auto___12449 + (1));
i__5727__auto___12449 = G__12450;
continue;
} else {
}
break;
}

var G__12447 = args12445.length;
switch (G__12447) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12445.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___12462 = arguments.length;
var i__5727__auto___12463 = (0);
while(true){
if((i__5727__auto___12463 < len__5726__auto___12462)){
args__5733__auto__.push((arguments[i__5727__auto___12463]));

var G__12464 = (i__5727__auto___12463 + (1));
i__5727__auto___12463 = G__12464;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12456){
var map__12457 = p__12456;
var map__12457__$1 = ((((!((map__12457 == null)))?((((map__12457.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12457.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12457):map__12457);
var opts = map__12457__$1;
var statearr_12459_12465 = state;
(statearr_12459_12465[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__12457,map__12457__$1,opts){
return (function (val){
var statearr_12460_12466 = state;
(statearr_12460_12466[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12457,map__12457__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_12461_12467 = state;
(statearr_12461_12467[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12452){
var G__12453 = cljs.core.first.call(null,seq12452);
var seq12452__$1 = cljs.core.next.call(null,seq12452);
var G__12454 = cljs.core.first.call(null,seq12452__$1);
var seq12452__$2 = cljs.core.next.call(null,seq12452__$1);
var G__12455 = cljs.core.first.call(null,seq12452__$2);
var seq12452__$3 = cljs.core.next.call(null,seq12452__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12453,G__12454,G__12455,seq12452__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12631 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12631 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12632){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12632 = meta12632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12633,meta12632__$1){
var self__ = this;
var _12633__$1 = this;
return (new cljs.core.async.t_cljs$core$async12631(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12632__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12633){
var self__ = this;
var _12633__$1 = this;
return self__.meta12632;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12632","meta12632",1874867183,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12631.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12631.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12631";

cljs.core.async.t_cljs$core$async12631.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12631");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12631 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12631(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12632){
return (new cljs.core.async.t_cljs$core$async12631(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12632));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12631(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11081__auto___12794 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___12794,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___12794,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12731){
var state_val_12732 = (state_12731[(1)]);
if((state_val_12732 === (7))){
var inst_12649 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
var statearr_12733_12795 = state_12731__$1;
(statearr_12733_12795[(2)] = inst_12649);

(statearr_12733_12795[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (20))){
var inst_12661 = (state_12731[(7)]);
var state_12731__$1 = state_12731;
var statearr_12734_12796 = state_12731__$1;
(statearr_12734_12796[(2)] = inst_12661);

(statearr_12734_12796[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (27))){
var state_12731__$1 = state_12731;
var statearr_12735_12797 = state_12731__$1;
(statearr_12735_12797[(2)] = null);

(statearr_12735_12797[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (1))){
var inst_12637 = (state_12731[(8)]);
var inst_12637__$1 = calc_state.call(null);
var inst_12639 = (inst_12637__$1 == null);
var inst_12640 = cljs.core.not.call(null,inst_12639);
var state_12731__$1 = (function (){var statearr_12736 = state_12731;
(statearr_12736[(8)] = inst_12637__$1);

return statearr_12736;
})();
if(inst_12640){
var statearr_12737_12798 = state_12731__$1;
(statearr_12737_12798[(1)] = (2));

} else {
var statearr_12738_12799 = state_12731__$1;
(statearr_12738_12799[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (24))){
var inst_12705 = (state_12731[(9)]);
var inst_12691 = (state_12731[(10)]);
var inst_12684 = (state_12731[(11)]);
var inst_12705__$1 = inst_12684.call(null,inst_12691);
var state_12731__$1 = (function (){var statearr_12739 = state_12731;
(statearr_12739[(9)] = inst_12705__$1);

return statearr_12739;
})();
if(cljs.core.truth_(inst_12705__$1)){
var statearr_12740_12800 = state_12731__$1;
(statearr_12740_12800[(1)] = (29));

} else {
var statearr_12741_12801 = state_12731__$1;
(statearr_12741_12801[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (4))){
var inst_12652 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
if(cljs.core.truth_(inst_12652)){
var statearr_12742_12802 = state_12731__$1;
(statearr_12742_12802[(1)] = (8));

} else {
var statearr_12743_12803 = state_12731__$1;
(statearr_12743_12803[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (15))){
var inst_12678 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
if(cljs.core.truth_(inst_12678)){
var statearr_12744_12804 = state_12731__$1;
(statearr_12744_12804[(1)] = (19));

} else {
var statearr_12745_12805 = state_12731__$1;
(statearr_12745_12805[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (21))){
var inst_12683 = (state_12731[(12)]);
var inst_12683__$1 = (state_12731[(2)]);
var inst_12684 = cljs.core.get.call(null,inst_12683__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12685 = cljs.core.get.call(null,inst_12683__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12686 = cljs.core.get.call(null,inst_12683__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12731__$1 = (function (){var statearr_12746 = state_12731;
(statearr_12746[(12)] = inst_12683__$1);

(statearr_12746[(13)] = inst_12685);

(statearr_12746[(11)] = inst_12684);

return statearr_12746;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12731__$1,(22),inst_12686);
} else {
if((state_val_12732 === (31))){
var inst_12713 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
if(cljs.core.truth_(inst_12713)){
var statearr_12747_12806 = state_12731__$1;
(statearr_12747_12806[(1)] = (32));

} else {
var statearr_12748_12807 = state_12731__$1;
(statearr_12748_12807[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (32))){
var inst_12690 = (state_12731[(14)]);
var state_12731__$1 = state_12731;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12731__$1,(35),out,inst_12690);
} else {
if((state_val_12732 === (33))){
var inst_12683 = (state_12731[(12)]);
var inst_12661 = inst_12683;
var state_12731__$1 = (function (){var statearr_12749 = state_12731;
(statearr_12749[(7)] = inst_12661);

return statearr_12749;
})();
var statearr_12750_12808 = state_12731__$1;
(statearr_12750_12808[(2)] = null);

(statearr_12750_12808[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (13))){
var inst_12661 = (state_12731[(7)]);
var inst_12668 = inst_12661.cljs$lang$protocol_mask$partition0$;
var inst_12669 = (inst_12668 & (64));
var inst_12670 = inst_12661.cljs$core$ISeq$;
var inst_12671 = (inst_12669) || (inst_12670);
var state_12731__$1 = state_12731;
if(cljs.core.truth_(inst_12671)){
var statearr_12751_12809 = state_12731__$1;
(statearr_12751_12809[(1)] = (16));

} else {
var statearr_12752_12810 = state_12731__$1;
(statearr_12752_12810[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (22))){
var inst_12691 = (state_12731[(10)]);
var inst_12690 = (state_12731[(14)]);
var inst_12689 = (state_12731[(2)]);
var inst_12690__$1 = cljs.core.nth.call(null,inst_12689,(0),null);
var inst_12691__$1 = cljs.core.nth.call(null,inst_12689,(1),null);
var inst_12692 = (inst_12690__$1 == null);
var inst_12693 = cljs.core._EQ_.call(null,inst_12691__$1,change);
var inst_12694 = (inst_12692) || (inst_12693);
var state_12731__$1 = (function (){var statearr_12753 = state_12731;
(statearr_12753[(10)] = inst_12691__$1);

(statearr_12753[(14)] = inst_12690__$1);

return statearr_12753;
})();
if(cljs.core.truth_(inst_12694)){
var statearr_12754_12811 = state_12731__$1;
(statearr_12754_12811[(1)] = (23));

} else {
var statearr_12755_12812 = state_12731__$1;
(statearr_12755_12812[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (36))){
var inst_12683 = (state_12731[(12)]);
var inst_12661 = inst_12683;
var state_12731__$1 = (function (){var statearr_12756 = state_12731;
(statearr_12756[(7)] = inst_12661);

return statearr_12756;
})();
var statearr_12757_12813 = state_12731__$1;
(statearr_12757_12813[(2)] = null);

(statearr_12757_12813[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (29))){
var inst_12705 = (state_12731[(9)]);
var state_12731__$1 = state_12731;
var statearr_12758_12814 = state_12731__$1;
(statearr_12758_12814[(2)] = inst_12705);

(statearr_12758_12814[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (6))){
var state_12731__$1 = state_12731;
var statearr_12759_12815 = state_12731__$1;
(statearr_12759_12815[(2)] = false);

(statearr_12759_12815[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (28))){
var inst_12701 = (state_12731[(2)]);
var inst_12702 = calc_state.call(null);
var inst_12661 = inst_12702;
var state_12731__$1 = (function (){var statearr_12760 = state_12731;
(statearr_12760[(7)] = inst_12661);

(statearr_12760[(15)] = inst_12701);

return statearr_12760;
})();
var statearr_12761_12816 = state_12731__$1;
(statearr_12761_12816[(2)] = null);

(statearr_12761_12816[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (25))){
var inst_12727 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
var statearr_12762_12817 = state_12731__$1;
(statearr_12762_12817[(2)] = inst_12727);

(statearr_12762_12817[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (34))){
var inst_12725 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
var statearr_12763_12818 = state_12731__$1;
(statearr_12763_12818[(2)] = inst_12725);

(statearr_12763_12818[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (17))){
var state_12731__$1 = state_12731;
var statearr_12764_12819 = state_12731__$1;
(statearr_12764_12819[(2)] = false);

(statearr_12764_12819[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (3))){
var state_12731__$1 = state_12731;
var statearr_12765_12820 = state_12731__$1;
(statearr_12765_12820[(2)] = false);

(statearr_12765_12820[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (12))){
var inst_12729 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12731__$1,inst_12729);
} else {
if((state_val_12732 === (2))){
var inst_12637 = (state_12731[(8)]);
var inst_12642 = inst_12637.cljs$lang$protocol_mask$partition0$;
var inst_12643 = (inst_12642 & (64));
var inst_12644 = inst_12637.cljs$core$ISeq$;
var inst_12645 = (inst_12643) || (inst_12644);
var state_12731__$1 = state_12731;
if(cljs.core.truth_(inst_12645)){
var statearr_12766_12821 = state_12731__$1;
(statearr_12766_12821[(1)] = (5));

} else {
var statearr_12767_12822 = state_12731__$1;
(statearr_12767_12822[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (23))){
var inst_12690 = (state_12731[(14)]);
var inst_12696 = (inst_12690 == null);
var state_12731__$1 = state_12731;
if(cljs.core.truth_(inst_12696)){
var statearr_12768_12823 = state_12731__$1;
(statearr_12768_12823[(1)] = (26));

} else {
var statearr_12769_12824 = state_12731__$1;
(statearr_12769_12824[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (35))){
var inst_12716 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
if(cljs.core.truth_(inst_12716)){
var statearr_12770_12825 = state_12731__$1;
(statearr_12770_12825[(1)] = (36));

} else {
var statearr_12771_12826 = state_12731__$1;
(statearr_12771_12826[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (19))){
var inst_12661 = (state_12731[(7)]);
var inst_12680 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12661);
var state_12731__$1 = state_12731;
var statearr_12772_12827 = state_12731__$1;
(statearr_12772_12827[(2)] = inst_12680);

(statearr_12772_12827[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (11))){
var inst_12661 = (state_12731[(7)]);
var inst_12665 = (inst_12661 == null);
var inst_12666 = cljs.core.not.call(null,inst_12665);
var state_12731__$1 = state_12731;
if(inst_12666){
var statearr_12773_12828 = state_12731__$1;
(statearr_12773_12828[(1)] = (13));

} else {
var statearr_12774_12829 = state_12731__$1;
(statearr_12774_12829[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (9))){
var inst_12637 = (state_12731[(8)]);
var state_12731__$1 = state_12731;
var statearr_12775_12830 = state_12731__$1;
(statearr_12775_12830[(2)] = inst_12637);

(statearr_12775_12830[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (5))){
var state_12731__$1 = state_12731;
var statearr_12776_12831 = state_12731__$1;
(statearr_12776_12831[(2)] = true);

(statearr_12776_12831[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (14))){
var state_12731__$1 = state_12731;
var statearr_12777_12832 = state_12731__$1;
(statearr_12777_12832[(2)] = false);

(statearr_12777_12832[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (26))){
var inst_12691 = (state_12731[(10)]);
var inst_12698 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12691);
var state_12731__$1 = state_12731;
var statearr_12778_12833 = state_12731__$1;
(statearr_12778_12833[(2)] = inst_12698);

(statearr_12778_12833[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (16))){
var state_12731__$1 = state_12731;
var statearr_12779_12834 = state_12731__$1;
(statearr_12779_12834[(2)] = true);

(statearr_12779_12834[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (38))){
var inst_12721 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
var statearr_12780_12835 = state_12731__$1;
(statearr_12780_12835[(2)] = inst_12721);

(statearr_12780_12835[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (30))){
var inst_12685 = (state_12731[(13)]);
var inst_12691 = (state_12731[(10)]);
var inst_12684 = (state_12731[(11)]);
var inst_12708 = cljs.core.empty_QMARK_.call(null,inst_12684);
var inst_12709 = inst_12685.call(null,inst_12691);
var inst_12710 = cljs.core.not.call(null,inst_12709);
var inst_12711 = (inst_12708) && (inst_12710);
var state_12731__$1 = state_12731;
var statearr_12781_12836 = state_12731__$1;
(statearr_12781_12836[(2)] = inst_12711);

(statearr_12781_12836[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (10))){
var inst_12637 = (state_12731[(8)]);
var inst_12657 = (state_12731[(2)]);
var inst_12658 = cljs.core.get.call(null,inst_12657,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12659 = cljs.core.get.call(null,inst_12657,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12660 = cljs.core.get.call(null,inst_12657,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12661 = inst_12637;
var state_12731__$1 = (function (){var statearr_12782 = state_12731;
(statearr_12782[(16)] = inst_12660);

(statearr_12782[(7)] = inst_12661);

(statearr_12782[(17)] = inst_12658);

(statearr_12782[(18)] = inst_12659);

return statearr_12782;
})();
var statearr_12783_12837 = state_12731__$1;
(statearr_12783_12837[(2)] = null);

(statearr_12783_12837[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (18))){
var inst_12675 = (state_12731[(2)]);
var state_12731__$1 = state_12731;
var statearr_12784_12838 = state_12731__$1;
(statearr_12784_12838[(2)] = inst_12675);

(statearr_12784_12838[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (37))){
var state_12731__$1 = state_12731;
var statearr_12785_12839 = state_12731__$1;
(statearr_12785_12839[(2)] = null);

(statearr_12785_12839[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12732 === (8))){
var inst_12637 = (state_12731[(8)]);
var inst_12654 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12637);
var state_12731__$1 = state_12731;
var statearr_12786_12840 = state_12731__$1;
(statearr_12786_12840[(2)] = inst_12654);

(statearr_12786_12840[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___12794,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10969__auto__,c__11081__auto___12794,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10970__auto__ = null;
var cljs$core$async$mix_$_state_machine__10970__auto____0 = (function (){
var statearr_12790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12790[(0)] = cljs$core$async$mix_$_state_machine__10970__auto__);

(statearr_12790[(1)] = (1));

return statearr_12790;
});
var cljs$core$async$mix_$_state_machine__10970__auto____1 = (function (state_12731){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_12731);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e12791){if((e12791 instanceof Object)){
var ex__10973__auto__ = e12791;
var statearr_12792_12841 = state_12731;
(statearr_12792_12841[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12731);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12791;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12842 = state_12731;
state_12731 = G__12842;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10970__auto__ = function(state_12731){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10970__auto____1.call(this,state_12731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10970__auto____0;
cljs$core$async$mix_$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10970__auto____1;
return cljs$core$async$mix_$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___12794,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11083__auto__ = (function (){var statearr_12793 = f__11082__auto__.call(null);
(statearr_12793[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___12794);

return statearr_12793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___12794,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12843 = [];
var len__5726__auto___12846 = arguments.length;
var i__5727__auto___12847 = (0);
while(true){
if((i__5727__auto___12847 < len__5726__auto___12846)){
args12843.push((arguments[i__5727__auto___12847]));

var G__12848 = (i__5727__auto___12847 + (1));
i__5727__auto___12847 = G__12848;
continue;
} else {
}
break;
}

var G__12845 = args12843.length;
switch (G__12845) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12843.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12851 = [];
var len__5726__auto___12976 = arguments.length;
var i__5727__auto___12977 = (0);
while(true){
if((i__5727__auto___12977 < len__5726__auto___12976)){
args12851.push((arguments[i__5727__auto___12977]));

var G__12978 = (i__5727__auto___12977 + (1));
i__5727__auto___12977 = G__12978;
continue;
} else {
}
break;
}

var G__12853 = args12851.length;
switch (G__12853) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12851.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__12850_SHARP_){
if(cljs.core.truth_(p1__12850_SHARP_.call(null,topic))){
return p1__12850_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12850_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12854 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12854 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12855){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12855 = meta12855;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12856,meta12855__$1){
var self__ = this;
var _12856__$1 = this;
return (new cljs.core.async.t_cljs$core$async12854(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12855__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12856){
var self__ = this;
var _12856__$1 = this;
return self__.meta12855;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12854.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12854.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12855","meta12855",-2112124831,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12854.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12854.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12854";

cljs.core.async.t_cljs$core$async12854.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12854");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12854 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12854(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12855){
return (new cljs.core.async.t_cljs$core$async12854(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12855));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12854(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11081__auto___12980 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___12980,mults,ensure_mult,p){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___12980,mults,ensure_mult,p){
return (function (state_12928){
var state_val_12929 = (state_12928[(1)]);
if((state_val_12929 === (7))){
var inst_12924 = (state_12928[(2)]);
var state_12928__$1 = state_12928;
var statearr_12930_12981 = state_12928__$1;
(statearr_12930_12981[(2)] = inst_12924);

(statearr_12930_12981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (20))){
var state_12928__$1 = state_12928;
var statearr_12931_12982 = state_12928__$1;
(statearr_12931_12982[(2)] = null);

(statearr_12931_12982[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (1))){
var state_12928__$1 = state_12928;
var statearr_12932_12983 = state_12928__$1;
(statearr_12932_12983[(2)] = null);

(statearr_12932_12983[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (24))){
var inst_12907 = (state_12928[(7)]);
var inst_12916 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12907);
var state_12928__$1 = state_12928;
var statearr_12933_12984 = state_12928__$1;
(statearr_12933_12984[(2)] = inst_12916);

(statearr_12933_12984[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (4))){
var inst_12859 = (state_12928[(8)]);
var inst_12859__$1 = (state_12928[(2)]);
var inst_12860 = (inst_12859__$1 == null);
var state_12928__$1 = (function (){var statearr_12934 = state_12928;
(statearr_12934[(8)] = inst_12859__$1);

return statearr_12934;
})();
if(cljs.core.truth_(inst_12860)){
var statearr_12935_12985 = state_12928__$1;
(statearr_12935_12985[(1)] = (5));

} else {
var statearr_12936_12986 = state_12928__$1;
(statearr_12936_12986[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (15))){
var inst_12901 = (state_12928[(2)]);
var state_12928__$1 = state_12928;
var statearr_12937_12987 = state_12928__$1;
(statearr_12937_12987[(2)] = inst_12901);

(statearr_12937_12987[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (21))){
var inst_12921 = (state_12928[(2)]);
var state_12928__$1 = (function (){var statearr_12938 = state_12928;
(statearr_12938[(9)] = inst_12921);

return statearr_12938;
})();
var statearr_12939_12988 = state_12928__$1;
(statearr_12939_12988[(2)] = null);

(statearr_12939_12988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (13))){
var inst_12883 = (state_12928[(10)]);
var inst_12885 = cljs.core.chunked_seq_QMARK_.call(null,inst_12883);
var state_12928__$1 = state_12928;
if(inst_12885){
var statearr_12940_12989 = state_12928__$1;
(statearr_12940_12989[(1)] = (16));

} else {
var statearr_12941_12990 = state_12928__$1;
(statearr_12941_12990[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (22))){
var inst_12913 = (state_12928[(2)]);
var state_12928__$1 = state_12928;
if(cljs.core.truth_(inst_12913)){
var statearr_12942_12991 = state_12928__$1;
(statearr_12942_12991[(1)] = (23));

} else {
var statearr_12943_12992 = state_12928__$1;
(statearr_12943_12992[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (6))){
var inst_12859 = (state_12928[(8)]);
var inst_12907 = (state_12928[(7)]);
var inst_12909 = (state_12928[(11)]);
var inst_12907__$1 = topic_fn.call(null,inst_12859);
var inst_12908 = cljs.core.deref.call(null,mults);
var inst_12909__$1 = cljs.core.get.call(null,inst_12908,inst_12907__$1);
var state_12928__$1 = (function (){var statearr_12944 = state_12928;
(statearr_12944[(7)] = inst_12907__$1);

(statearr_12944[(11)] = inst_12909__$1);

return statearr_12944;
})();
if(cljs.core.truth_(inst_12909__$1)){
var statearr_12945_12993 = state_12928__$1;
(statearr_12945_12993[(1)] = (19));

} else {
var statearr_12946_12994 = state_12928__$1;
(statearr_12946_12994[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (25))){
var inst_12918 = (state_12928[(2)]);
var state_12928__$1 = state_12928;
var statearr_12947_12995 = state_12928__$1;
(statearr_12947_12995[(2)] = inst_12918);

(statearr_12947_12995[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (17))){
var inst_12883 = (state_12928[(10)]);
var inst_12892 = cljs.core.first.call(null,inst_12883);
var inst_12893 = cljs.core.async.muxch_STAR_.call(null,inst_12892);
var inst_12894 = cljs.core.async.close_BANG_.call(null,inst_12893);
var inst_12895 = cljs.core.next.call(null,inst_12883);
var inst_12869 = inst_12895;
var inst_12870 = null;
var inst_12871 = (0);
var inst_12872 = (0);
var state_12928__$1 = (function (){var statearr_12948 = state_12928;
(statearr_12948[(12)] = inst_12870);

(statearr_12948[(13)] = inst_12871);

(statearr_12948[(14)] = inst_12869);

(statearr_12948[(15)] = inst_12872);

(statearr_12948[(16)] = inst_12894);

return statearr_12948;
})();
var statearr_12949_12996 = state_12928__$1;
(statearr_12949_12996[(2)] = null);

(statearr_12949_12996[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (3))){
var inst_12926 = (state_12928[(2)]);
var state_12928__$1 = state_12928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12928__$1,inst_12926);
} else {
if((state_val_12929 === (12))){
var inst_12903 = (state_12928[(2)]);
var state_12928__$1 = state_12928;
var statearr_12950_12997 = state_12928__$1;
(statearr_12950_12997[(2)] = inst_12903);

(statearr_12950_12997[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (2))){
var state_12928__$1 = state_12928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12928__$1,(4),ch);
} else {
if((state_val_12929 === (23))){
var state_12928__$1 = state_12928;
var statearr_12951_12998 = state_12928__$1;
(statearr_12951_12998[(2)] = null);

(statearr_12951_12998[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (19))){
var inst_12859 = (state_12928[(8)]);
var inst_12909 = (state_12928[(11)]);
var inst_12911 = cljs.core.async.muxch_STAR_.call(null,inst_12909);
var state_12928__$1 = state_12928;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12928__$1,(22),inst_12911,inst_12859);
} else {
if((state_val_12929 === (11))){
var inst_12883 = (state_12928[(10)]);
var inst_12869 = (state_12928[(14)]);
var inst_12883__$1 = cljs.core.seq.call(null,inst_12869);
var state_12928__$1 = (function (){var statearr_12952 = state_12928;
(statearr_12952[(10)] = inst_12883__$1);

return statearr_12952;
})();
if(inst_12883__$1){
var statearr_12953_12999 = state_12928__$1;
(statearr_12953_12999[(1)] = (13));

} else {
var statearr_12954_13000 = state_12928__$1;
(statearr_12954_13000[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (9))){
var inst_12905 = (state_12928[(2)]);
var state_12928__$1 = state_12928;
var statearr_12955_13001 = state_12928__$1;
(statearr_12955_13001[(2)] = inst_12905);

(statearr_12955_13001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (5))){
var inst_12866 = cljs.core.deref.call(null,mults);
var inst_12867 = cljs.core.vals.call(null,inst_12866);
var inst_12868 = cljs.core.seq.call(null,inst_12867);
var inst_12869 = inst_12868;
var inst_12870 = null;
var inst_12871 = (0);
var inst_12872 = (0);
var state_12928__$1 = (function (){var statearr_12956 = state_12928;
(statearr_12956[(12)] = inst_12870);

(statearr_12956[(13)] = inst_12871);

(statearr_12956[(14)] = inst_12869);

(statearr_12956[(15)] = inst_12872);

return statearr_12956;
})();
var statearr_12957_13002 = state_12928__$1;
(statearr_12957_13002[(2)] = null);

(statearr_12957_13002[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (14))){
var state_12928__$1 = state_12928;
var statearr_12961_13003 = state_12928__$1;
(statearr_12961_13003[(2)] = null);

(statearr_12961_13003[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (16))){
var inst_12883 = (state_12928[(10)]);
var inst_12887 = cljs.core.chunk_first.call(null,inst_12883);
var inst_12888 = cljs.core.chunk_rest.call(null,inst_12883);
var inst_12889 = cljs.core.count.call(null,inst_12887);
var inst_12869 = inst_12888;
var inst_12870 = inst_12887;
var inst_12871 = inst_12889;
var inst_12872 = (0);
var state_12928__$1 = (function (){var statearr_12962 = state_12928;
(statearr_12962[(12)] = inst_12870);

(statearr_12962[(13)] = inst_12871);

(statearr_12962[(14)] = inst_12869);

(statearr_12962[(15)] = inst_12872);

return statearr_12962;
})();
var statearr_12963_13004 = state_12928__$1;
(statearr_12963_13004[(2)] = null);

(statearr_12963_13004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (10))){
var inst_12870 = (state_12928[(12)]);
var inst_12871 = (state_12928[(13)]);
var inst_12869 = (state_12928[(14)]);
var inst_12872 = (state_12928[(15)]);
var inst_12877 = cljs.core._nth.call(null,inst_12870,inst_12872);
var inst_12878 = cljs.core.async.muxch_STAR_.call(null,inst_12877);
var inst_12879 = cljs.core.async.close_BANG_.call(null,inst_12878);
var inst_12880 = (inst_12872 + (1));
var tmp12958 = inst_12870;
var tmp12959 = inst_12871;
var tmp12960 = inst_12869;
var inst_12869__$1 = tmp12960;
var inst_12870__$1 = tmp12958;
var inst_12871__$1 = tmp12959;
var inst_12872__$1 = inst_12880;
var state_12928__$1 = (function (){var statearr_12964 = state_12928;
(statearr_12964[(17)] = inst_12879);

(statearr_12964[(12)] = inst_12870__$1);

(statearr_12964[(13)] = inst_12871__$1);

(statearr_12964[(14)] = inst_12869__$1);

(statearr_12964[(15)] = inst_12872__$1);

return statearr_12964;
})();
var statearr_12965_13005 = state_12928__$1;
(statearr_12965_13005[(2)] = null);

(statearr_12965_13005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (18))){
var inst_12898 = (state_12928[(2)]);
var state_12928__$1 = state_12928;
var statearr_12966_13006 = state_12928__$1;
(statearr_12966_13006[(2)] = inst_12898);

(statearr_12966_13006[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12929 === (8))){
var inst_12871 = (state_12928[(13)]);
var inst_12872 = (state_12928[(15)]);
var inst_12874 = (inst_12872 < inst_12871);
var inst_12875 = inst_12874;
var state_12928__$1 = state_12928;
if(cljs.core.truth_(inst_12875)){
var statearr_12967_13007 = state_12928__$1;
(statearr_12967_13007[(1)] = (10));

} else {
var statearr_12968_13008 = state_12928__$1;
(statearr_12968_13008[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___12980,mults,ensure_mult,p))
;
return ((function (switch__10969__auto__,c__11081__auto___12980,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_12972 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12972[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_12972[(1)] = (1));

return statearr_12972;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_12928){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_12928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e12973){if((e12973 instanceof Object)){
var ex__10973__auto__ = e12973;
var statearr_12974_13009 = state_12928;
(statearr_12974_13009[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12928);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12973;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13010 = state_12928;
state_12928 = G__13010;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_12928){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_12928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___12980,mults,ensure_mult,p))
})();
var state__11083__auto__ = (function (){var statearr_12975 = f__11082__auto__.call(null);
(statearr_12975[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___12980);

return statearr_12975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___12980,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args13011 = [];
var len__5726__auto___13014 = arguments.length;
var i__5727__auto___13015 = (0);
while(true){
if((i__5727__auto___13015 < len__5726__auto___13014)){
args13011.push((arguments[i__5727__auto___13015]));

var G__13016 = (i__5727__auto___13015 + (1));
i__5727__auto___13015 = G__13016;
continue;
} else {
}
break;
}

var G__13013 = args13011.length;
switch (G__13013) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13011.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args13018 = [];
var len__5726__auto___13021 = arguments.length;
var i__5727__auto___13022 = (0);
while(true){
if((i__5727__auto___13022 < len__5726__auto___13021)){
args13018.push((arguments[i__5727__auto___13022]));

var G__13023 = (i__5727__auto___13022 + (1));
i__5727__auto___13022 = G__13023;
continue;
} else {
}
break;
}

var G__13020 = args13018.length;
switch (G__13020) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13018.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13025 = [];
var len__5726__auto___13096 = arguments.length;
var i__5727__auto___13097 = (0);
while(true){
if((i__5727__auto___13097 < len__5726__auto___13096)){
args13025.push((arguments[i__5727__auto___13097]));

var G__13098 = (i__5727__auto___13097 + (1));
i__5727__auto___13097 = G__13098;
continue;
} else {
}
break;
}

var G__13027 = args13025.length;
switch (G__13027) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13025.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11081__auto___13100 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___13100,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___13100,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13066){
var state_val_13067 = (state_13066[(1)]);
if((state_val_13067 === (7))){
var state_13066__$1 = state_13066;
var statearr_13068_13101 = state_13066__$1;
(statearr_13068_13101[(2)] = null);

(statearr_13068_13101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (1))){
var state_13066__$1 = state_13066;
var statearr_13069_13102 = state_13066__$1;
(statearr_13069_13102[(2)] = null);

(statearr_13069_13102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (4))){
var inst_13030 = (state_13066[(7)]);
var inst_13032 = (inst_13030 < cnt);
var state_13066__$1 = state_13066;
if(cljs.core.truth_(inst_13032)){
var statearr_13070_13103 = state_13066__$1;
(statearr_13070_13103[(1)] = (6));

} else {
var statearr_13071_13104 = state_13066__$1;
(statearr_13071_13104[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (15))){
var inst_13062 = (state_13066[(2)]);
var state_13066__$1 = state_13066;
var statearr_13072_13105 = state_13066__$1;
(statearr_13072_13105[(2)] = inst_13062);

(statearr_13072_13105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (13))){
var inst_13055 = cljs.core.async.close_BANG_.call(null,out);
var state_13066__$1 = state_13066;
var statearr_13073_13106 = state_13066__$1;
(statearr_13073_13106[(2)] = inst_13055);

(statearr_13073_13106[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (6))){
var state_13066__$1 = state_13066;
var statearr_13074_13107 = state_13066__$1;
(statearr_13074_13107[(2)] = null);

(statearr_13074_13107[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (3))){
var inst_13064 = (state_13066[(2)]);
var state_13066__$1 = state_13066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13066__$1,inst_13064);
} else {
if((state_val_13067 === (12))){
var inst_13052 = (state_13066[(8)]);
var inst_13052__$1 = (state_13066[(2)]);
var inst_13053 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13052__$1);
var state_13066__$1 = (function (){var statearr_13075 = state_13066;
(statearr_13075[(8)] = inst_13052__$1);

return statearr_13075;
})();
if(cljs.core.truth_(inst_13053)){
var statearr_13076_13108 = state_13066__$1;
(statearr_13076_13108[(1)] = (13));

} else {
var statearr_13077_13109 = state_13066__$1;
(statearr_13077_13109[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (2))){
var inst_13029 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13030 = (0);
var state_13066__$1 = (function (){var statearr_13078 = state_13066;
(statearr_13078[(9)] = inst_13029);

(statearr_13078[(7)] = inst_13030);

return statearr_13078;
})();
var statearr_13079_13110 = state_13066__$1;
(statearr_13079_13110[(2)] = null);

(statearr_13079_13110[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (11))){
var inst_13030 = (state_13066[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13066,(10),Object,null,(9));
var inst_13039 = chs__$1.call(null,inst_13030);
var inst_13040 = done.call(null,inst_13030);
var inst_13041 = cljs.core.async.take_BANG_.call(null,inst_13039,inst_13040);
var state_13066__$1 = state_13066;
var statearr_13080_13111 = state_13066__$1;
(statearr_13080_13111[(2)] = inst_13041);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13066__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (9))){
var inst_13030 = (state_13066[(7)]);
var inst_13043 = (state_13066[(2)]);
var inst_13044 = (inst_13030 + (1));
var inst_13030__$1 = inst_13044;
var state_13066__$1 = (function (){var statearr_13081 = state_13066;
(statearr_13081[(10)] = inst_13043);

(statearr_13081[(7)] = inst_13030__$1);

return statearr_13081;
})();
var statearr_13082_13112 = state_13066__$1;
(statearr_13082_13112[(2)] = null);

(statearr_13082_13112[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (5))){
var inst_13050 = (state_13066[(2)]);
var state_13066__$1 = (function (){var statearr_13083 = state_13066;
(statearr_13083[(11)] = inst_13050);

return statearr_13083;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13066__$1,(12),dchan);
} else {
if((state_val_13067 === (14))){
var inst_13052 = (state_13066[(8)]);
var inst_13057 = cljs.core.apply.call(null,f,inst_13052);
var state_13066__$1 = state_13066;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13066__$1,(16),out,inst_13057);
} else {
if((state_val_13067 === (16))){
var inst_13059 = (state_13066[(2)]);
var state_13066__$1 = (function (){var statearr_13084 = state_13066;
(statearr_13084[(12)] = inst_13059);

return statearr_13084;
})();
var statearr_13085_13113 = state_13066__$1;
(statearr_13085_13113[(2)] = null);

(statearr_13085_13113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (10))){
var inst_13034 = (state_13066[(2)]);
var inst_13035 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13066__$1 = (function (){var statearr_13086 = state_13066;
(statearr_13086[(13)] = inst_13034);

return statearr_13086;
})();
var statearr_13087_13114 = state_13066__$1;
(statearr_13087_13114[(2)] = inst_13035);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13066__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13067 === (8))){
var inst_13048 = (state_13066[(2)]);
var state_13066__$1 = state_13066;
var statearr_13088_13115 = state_13066__$1;
(statearr_13088_13115[(2)] = inst_13048);

(statearr_13088_13115[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___13100,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10969__auto__,c__11081__auto___13100,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_13092 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13092[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_13092[(1)] = (1));

return statearr_13092;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_13066){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_13066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e13093){if((e13093 instanceof Object)){
var ex__10973__auto__ = e13093;
var statearr_13094_13116 = state_13066;
(statearr_13094_13116[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13066);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13093;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13117 = state_13066;
state_13066 = G__13117;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_13066){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_13066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___13100,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11083__auto__ = (function (){var statearr_13095 = f__11082__auto__.call(null);
(statearr_13095[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___13100);

return statearr_13095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___13100,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13119 = [];
var len__5726__auto___13175 = arguments.length;
var i__5727__auto___13176 = (0);
while(true){
if((i__5727__auto___13176 < len__5726__auto___13175)){
args13119.push((arguments[i__5727__auto___13176]));

var G__13177 = (i__5727__auto___13176 + (1));
i__5727__auto___13176 = G__13177;
continue;
} else {
}
break;
}

var G__13121 = args13119.length;
switch (G__13121) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13119.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___13179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___13179,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___13179,out){
return (function (state_13151){
var state_val_13152 = (state_13151[(1)]);
if((state_val_13152 === (7))){
var inst_13131 = (state_13151[(7)]);
var inst_13130 = (state_13151[(8)]);
var inst_13130__$1 = (state_13151[(2)]);
var inst_13131__$1 = cljs.core.nth.call(null,inst_13130__$1,(0),null);
var inst_13132 = cljs.core.nth.call(null,inst_13130__$1,(1),null);
var inst_13133 = (inst_13131__$1 == null);
var state_13151__$1 = (function (){var statearr_13153 = state_13151;
(statearr_13153[(7)] = inst_13131__$1);

(statearr_13153[(8)] = inst_13130__$1);

(statearr_13153[(9)] = inst_13132);

return statearr_13153;
})();
if(cljs.core.truth_(inst_13133)){
var statearr_13154_13180 = state_13151__$1;
(statearr_13154_13180[(1)] = (8));

} else {
var statearr_13155_13181 = state_13151__$1;
(statearr_13155_13181[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13152 === (1))){
var inst_13122 = cljs.core.vec.call(null,chs);
var inst_13123 = inst_13122;
var state_13151__$1 = (function (){var statearr_13156 = state_13151;
(statearr_13156[(10)] = inst_13123);

return statearr_13156;
})();
var statearr_13157_13182 = state_13151__$1;
(statearr_13157_13182[(2)] = null);

(statearr_13157_13182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13152 === (4))){
var inst_13123 = (state_13151[(10)]);
var state_13151__$1 = state_13151;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13151__$1,(7),inst_13123);
} else {
if((state_val_13152 === (6))){
var inst_13147 = (state_13151[(2)]);
var state_13151__$1 = state_13151;
var statearr_13158_13183 = state_13151__$1;
(statearr_13158_13183[(2)] = inst_13147);

(statearr_13158_13183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13152 === (3))){
var inst_13149 = (state_13151[(2)]);
var state_13151__$1 = state_13151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13151__$1,inst_13149);
} else {
if((state_val_13152 === (2))){
var inst_13123 = (state_13151[(10)]);
var inst_13125 = cljs.core.count.call(null,inst_13123);
var inst_13126 = (inst_13125 > (0));
var state_13151__$1 = state_13151;
if(cljs.core.truth_(inst_13126)){
var statearr_13160_13184 = state_13151__$1;
(statearr_13160_13184[(1)] = (4));

} else {
var statearr_13161_13185 = state_13151__$1;
(statearr_13161_13185[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13152 === (11))){
var inst_13123 = (state_13151[(10)]);
var inst_13140 = (state_13151[(2)]);
var tmp13159 = inst_13123;
var inst_13123__$1 = tmp13159;
var state_13151__$1 = (function (){var statearr_13162 = state_13151;
(statearr_13162[(10)] = inst_13123__$1);

(statearr_13162[(11)] = inst_13140);

return statearr_13162;
})();
var statearr_13163_13186 = state_13151__$1;
(statearr_13163_13186[(2)] = null);

(statearr_13163_13186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13152 === (9))){
var inst_13131 = (state_13151[(7)]);
var state_13151__$1 = state_13151;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13151__$1,(11),out,inst_13131);
} else {
if((state_val_13152 === (5))){
var inst_13145 = cljs.core.async.close_BANG_.call(null,out);
var state_13151__$1 = state_13151;
var statearr_13164_13187 = state_13151__$1;
(statearr_13164_13187[(2)] = inst_13145);

(statearr_13164_13187[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13152 === (10))){
var inst_13143 = (state_13151[(2)]);
var state_13151__$1 = state_13151;
var statearr_13165_13188 = state_13151__$1;
(statearr_13165_13188[(2)] = inst_13143);

(statearr_13165_13188[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13152 === (8))){
var inst_13131 = (state_13151[(7)]);
var inst_13123 = (state_13151[(10)]);
var inst_13130 = (state_13151[(8)]);
var inst_13132 = (state_13151[(9)]);
var inst_13135 = (function (){var cs = inst_13123;
var vec__13128 = inst_13130;
var v = inst_13131;
var c = inst_13132;
return ((function (cs,vec__13128,v,c,inst_13131,inst_13123,inst_13130,inst_13132,state_val_13152,c__11081__auto___13179,out){
return (function (p1__13118_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13118_SHARP_);
});
;})(cs,vec__13128,v,c,inst_13131,inst_13123,inst_13130,inst_13132,state_val_13152,c__11081__auto___13179,out))
})();
var inst_13136 = cljs.core.filterv.call(null,inst_13135,inst_13123);
var inst_13123__$1 = inst_13136;
var state_13151__$1 = (function (){var statearr_13166 = state_13151;
(statearr_13166[(10)] = inst_13123__$1);

return statearr_13166;
})();
var statearr_13167_13189 = state_13151__$1;
(statearr_13167_13189[(2)] = null);

(statearr_13167_13189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___13179,out))
;
return ((function (switch__10969__auto__,c__11081__auto___13179,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_13171 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13171[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_13171[(1)] = (1));

return statearr_13171;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_13151){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_13151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e13172){if((e13172 instanceof Object)){
var ex__10973__auto__ = e13172;
var statearr_13173_13190 = state_13151;
(statearr_13173_13190[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13151);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13172;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13191 = state_13151;
state_13151 = G__13191;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_13151){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_13151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___13179,out))
})();
var state__11083__auto__ = (function (){var statearr_13174 = f__11082__auto__.call(null);
(statearr_13174[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___13179);

return statearr_13174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___13179,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13192 = [];
var len__5726__auto___13241 = arguments.length;
var i__5727__auto___13242 = (0);
while(true){
if((i__5727__auto___13242 < len__5726__auto___13241)){
args13192.push((arguments[i__5727__auto___13242]));

var G__13243 = (i__5727__auto___13242 + (1));
i__5727__auto___13242 = G__13243;
continue;
} else {
}
break;
}

var G__13194 = args13192.length;
switch (G__13194) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13192.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___13245 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___13245,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___13245,out){
return (function (state_13218){
var state_val_13219 = (state_13218[(1)]);
if((state_val_13219 === (7))){
var inst_13200 = (state_13218[(7)]);
var inst_13200__$1 = (state_13218[(2)]);
var inst_13201 = (inst_13200__$1 == null);
var inst_13202 = cljs.core.not.call(null,inst_13201);
var state_13218__$1 = (function (){var statearr_13220 = state_13218;
(statearr_13220[(7)] = inst_13200__$1);

return statearr_13220;
})();
if(inst_13202){
var statearr_13221_13246 = state_13218__$1;
(statearr_13221_13246[(1)] = (8));

} else {
var statearr_13222_13247 = state_13218__$1;
(statearr_13222_13247[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13219 === (1))){
var inst_13195 = (0);
var state_13218__$1 = (function (){var statearr_13223 = state_13218;
(statearr_13223[(8)] = inst_13195);

return statearr_13223;
})();
var statearr_13224_13248 = state_13218__$1;
(statearr_13224_13248[(2)] = null);

(statearr_13224_13248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13219 === (4))){
var state_13218__$1 = state_13218;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13218__$1,(7),ch);
} else {
if((state_val_13219 === (6))){
var inst_13213 = (state_13218[(2)]);
var state_13218__$1 = state_13218;
var statearr_13225_13249 = state_13218__$1;
(statearr_13225_13249[(2)] = inst_13213);

(statearr_13225_13249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13219 === (3))){
var inst_13215 = (state_13218[(2)]);
var inst_13216 = cljs.core.async.close_BANG_.call(null,out);
var state_13218__$1 = (function (){var statearr_13226 = state_13218;
(statearr_13226[(9)] = inst_13215);

return statearr_13226;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13218__$1,inst_13216);
} else {
if((state_val_13219 === (2))){
var inst_13195 = (state_13218[(8)]);
var inst_13197 = (inst_13195 < n);
var state_13218__$1 = state_13218;
if(cljs.core.truth_(inst_13197)){
var statearr_13227_13250 = state_13218__$1;
(statearr_13227_13250[(1)] = (4));

} else {
var statearr_13228_13251 = state_13218__$1;
(statearr_13228_13251[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13219 === (11))){
var inst_13195 = (state_13218[(8)]);
var inst_13205 = (state_13218[(2)]);
var inst_13206 = (inst_13195 + (1));
var inst_13195__$1 = inst_13206;
var state_13218__$1 = (function (){var statearr_13229 = state_13218;
(statearr_13229[(10)] = inst_13205);

(statearr_13229[(8)] = inst_13195__$1);

return statearr_13229;
})();
var statearr_13230_13252 = state_13218__$1;
(statearr_13230_13252[(2)] = null);

(statearr_13230_13252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13219 === (9))){
var state_13218__$1 = state_13218;
var statearr_13231_13253 = state_13218__$1;
(statearr_13231_13253[(2)] = null);

(statearr_13231_13253[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13219 === (5))){
var state_13218__$1 = state_13218;
var statearr_13232_13254 = state_13218__$1;
(statearr_13232_13254[(2)] = null);

(statearr_13232_13254[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13219 === (10))){
var inst_13210 = (state_13218[(2)]);
var state_13218__$1 = state_13218;
var statearr_13233_13255 = state_13218__$1;
(statearr_13233_13255[(2)] = inst_13210);

(statearr_13233_13255[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13219 === (8))){
var inst_13200 = (state_13218[(7)]);
var state_13218__$1 = state_13218;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13218__$1,(11),out,inst_13200);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___13245,out))
;
return ((function (switch__10969__auto__,c__11081__auto___13245,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_13237 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13237[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_13237[(1)] = (1));

return statearr_13237;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_13218){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_13218);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e13238){if((e13238 instanceof Object)){
var ex__10973__auto__ = e13238;
var statearr_13239_13256 = state_13218;
(statearr_13239_13256[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13218);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13238;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13257 = state_13218;
state_13218 = G__13257;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_13218){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_13218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___13245,out))
})();
var state__11083__auto__ = (function (){var statearr_13240 = f__11082__auto__.call(null);
(statearr_13240[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___13245);

return statearr_13240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___13245,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13265 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13265 = (function (map_LT_,f,ch,meta13266){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13266 = meta13266;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13267,meta13266__$1){
var self__ = this;
var _13267__$1 = this;
return (new cljs.core.async.t_cljs$core$async13265(self__.map_LT_,self__.f,self__.ch,meta13266__$1));
});

cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13267){
var self__ = this;
var _13267__$1 = this;
return self__.meta13266;
});

cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async13268 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13268 = (function (map_LT_,f,ch,meta13266,_,fn1,meta13269){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13266 = meta13266;
this._ = _;
this.fn1 = fn1;
this.meta13269 = meta13269;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13270,meta13269__$1){
var self__ = this;
var _13270__$1 = this;
return (new cljs.core.async.t_cljs$core$async13268(self__.map_LT_,self__.f,self__.ch,self__.meta13266,self__._,self__.fn1,meta13269__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13270){
var self__ = this;
var _13270__$1 = this;
return self__.meta13269;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13268.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__13258_SHARP_){
return f1.call(null,(((p1__13258_SHARP_ == null))?null:self__.f.call(null,p1__13258_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async13268.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13266","meta13266",1143055964,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13265","cljs.core.async/t_cljs$core$async13265",953729529,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13269","meta13269",-1178697360,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13268.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13268.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13268";

cljs.core.async.t_cljs$core$async13268.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13268");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async13268 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13268(map_LT___$1,f__$1,ch__$1,meta13266__$1,___$2,fn1__$1,meta13269){
return (new cljs.core.async.t_cljs$core$async13268(map_LT___$1,f__$1,ch__$1,meta13266__$1,___$2,fn1__$1,meta13269));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async13268(self__.map_LT_,self__.f,self__.ch,self__.meta13266,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13265.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async13265.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13266","meta13266",1143055964,null)], null);
});

cljs.core.async.t_cljs$core$async13265.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13265.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13265";

cljs.core.async.t_cljs$core$async13265.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13265");
});

cljs.core.async.__GT_t_cljs$core$async13265 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13265(map_LT___$1,f__$1,ch__$1,meta13266){
return (new cljs.core.async.t_cljs$core$async13265(map_LT___$1,f__$1,ch__$1,meta13266));
});

}

return (new cljs.core.async.t_cljs$core$async13265(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13274 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13274 = (function (map_GT_,f,ch,meta13275){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta13275 = meta13275;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13274.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13276,meta13275__$1){
var self__ = this;
var _13276__$1 = this;
return (new cljs.core.async.t_cljs$core$async13274(self__.map_GT_,self__.f,self__.ch,meta13275__$1));
});

cljs.core.async.t_cljs$core$async13274.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13276){
var self__ = this;
var _13276__$1 = this;
return self__.meta13275;
});

cljs.core.async.t_cljs$core$async13274.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13274.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13274.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13274.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13274.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13274.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async13274.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13275","meta13275",901657426,null)], null);
});

cljs.core.async.t_cljs$core$async13274.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13274.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13274";

cljs.core.async.t_cljs$core$async13274.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13274");
});

cljs.core.async.__GT_t_cljs$core$async13274 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13274(map_GT___$1,f__$1,ch__$1,meta13275){
return (new cljs.core.async.t_cljs$core$async13274(map_GT___$1,f__$1,ch__$1,meta13275));
});

}

return (new cljs.core.async.t_cljs$core$async13274(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async13280 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13280 = (function (filter_GT_,p,ch,meta13281){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13281 = meta13281;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13282,meta13281__$1){
var self__ = this;
var _13282__$1 = this;
return (new cljs.core.async.t_cljs$core$async13280(self__.filter_GT_,self__.p,self__.ch,meta13281__$1));
});

cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13282){
var self__ = this;
var _13282__$1 = this;
return self__.meta13281;
});

cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13280.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async13280.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13281","meta13281",-1068602789,null)], null);
});

cljs.core.async.t_cljs$core$async13280.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13280.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13280";

cljs.core.async.t_cljs$core$async13280.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13280");
});

cljs.core.async.__GT_t_cljs$core$async13280 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13280(filter_GT___$1,p__$1,ch__$1,meta13281){
return (new cljs.core.async.t_cljs$core$async13280(filter_GT___$1,p__$1,ch__$1,meta13281));
});

}

return (new cljs.core.async.t_cljs$core$async13280(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args13283 = [];
var len__5726__auto___13327 = arguments.length;
var i__5727__auto___13328 = (0);
while(true){
if((i__5727__auto___13328 < len__5726__auto___13327)){
args13283.push((arguments[i__5727__auto___13328]));

var G__13329 = (i__5727__auto___13328 + (1));
i__5727__auto___13328 = G__13329;
continue;
} else {
}
break;
}

var G__13285 = args13283.length;
switch (G__13285) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13283.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___13331 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___13331,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___13331,out){
return (function (state_13306){
var state_val_13307 = (state_13306[(1)]);
if((state_val_13307 === (7))){
var inst_13302 = (state_13306[(2)]);
var state_13306__$1 = state_13306;
var statearr_13308_13332 = state_13306__$1;
(statearr_13308_13332[(2)] = inst_13302);

(statearr_13308_13332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13307 === (1))){
var state_13306__$1 = state_13306;
var statearr_13309_13333 = state_13306__$1;
(statearr_13309_13333[(2)] = null);

(statearr_13309_13333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13307 === (4))){
var inst_13288 = (state_13306[(7)]);
var inst_13288__$1 = (state_13306[(2)]);
var inst_13289 = (inst_13288__$1 == null);
var state_13306__$1 = (function (){var statearr_13310 = state_13306;
(statearr_13310[(7)] = inst_13288__$1);

return statearr_13310;
})();
if(cljs.core.truth_(inst_13289)){
var statearr_13311_13334 = state_13306__$1;
(statearr_13311_13334[(1)] = (5));

} else {
var statearr_13312_13335 = state_13306__$1;
(statearr_13312_13335[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13307 === (6))){
var inst_13288 = (state_13306[(7)]);
var inst_13293 = p.call(null,inst_13288);
var state_13306__$1 = state_13306;
if(cljs.core.truth_(inst_13293)){
var statearr_13313_13336 = state_13306__$1;
(statearr_13313_13336[(1)] = (8));

} else {
var statearr_13314_13337 = state_13306__$1;
(statearr_13314_13337[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13307 === (3))){
var inst_13304 = (state_13306[(2)]);
var state_13306__$1 = state_13306;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13306__$1,inst_13304);
} else {
if((state_val_13307 === (2))){
var state_13306__$1 = state_13306;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13306__$1,(4),ch);
} else {
if((state_val_13307 === (11))){
var inst_13296 = (state_13306[(2)]);
var state_13306__$1 = state_13306;
var statearr_13315_13338 = state_13306__$1;
(statearr_13315_13338[(2)] = inst_13296);

(statearr_13315_13338[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13307 === (9))){
var state_13306__$1 = state_13306;
var statearr_13316_13339 = state_13306__$1;
(statearr_13316_13339[(2)] = null);

(statearr_13316_13339[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13307 === (5))){
var inst_13291 = cljs.core.async.close_BANG_.call(null,out);
var state_13306__$1 = state_13306;
var statearr_13317_13340 = state_13306__$1;
(statearr_13317_13340[(2)] = inst_13291);

(statearr_13317_13340[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13307 === (10))){
var inst_13299 = (state_13306[(2)]);
var state_13306__$1 = (function (){var statearr_13318 = state_13306;
(statearr_13318[(8)] = inst_13299);

return statearr_13318;
})();
var statearr_13319_13341 = state_13306__$1;
(statearr_13319_13341[(2)] = null);

(statearr_13319_13341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13307 === (8))){
var inst_13288 = (state_13306[(7)]);
var state_13306__$1 = state_13306;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13306__$1,(11),out,inst_13288);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___13331,out))
;
return ((function (switch__10969__auto__,c__11081__auto___13331,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_13323 = [null,null,null,null,null,null,null,null,null];
(statearr_13323[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_13323[(1)] = (1));

return statearr_13323;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_13306){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_13306);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e13324){if((e13324 instanceof Object)){
var ex__10973__auto__ = e13324;
var statearr_13325_13342 = state_13306;
(statearr_13325_13342[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13306);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13324;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13343 = state_13306;
state_13306 = G__13343;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_13306){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_13306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___13331,out))
})();
var state__11083__auto__ = (function (){var statearr_13326 = f__11082__auto__.call(null);
(statearr_13326[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___13331);

return statearr_13326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___13331,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args13344 = [];
var len__5726__auto___13347 = arguments.length;
var i__5727__auto___13348 = (0);
while(true){
if((i__5727__auto___13348 < len__5726__auto___13347)){
args13344.push((arguments[i__5727__auto___13348]));

var G__13349 = (i__5727__auto___13348 + (1));
i__5727__auto___13348 = G__13349;
continue;
} else {
}
break;
}

var G__13346 = args13344.length;
switch (G__13346) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13344.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11081__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto__){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto__){
return (function (state_13516){
var state_val_13517 = (state_13516[(1)]);
if((state_val_13517 === (7))){
var inst_13512 = (state_13516[(2)]);
var state_13516__$1 = state_13516;
var statearr_13518_13559 = state_13516__$1;
(statearr_13518_13559[(2)] = inst_13512);

(statearr_13518_13559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (20))){
var inst_13482 = (state_13516[(7)]);
var inst_13493 = (state_13516[(2)]);
var inst_13494 = cljs.core.next.call(null,inst_13482);
var inst_13468 = inst_13494;
var inst_13469 = null;
var inst_13470 = (0);
var inst_13471 = (0);
var state_13516__$1 = (function (){var statearr_13519 = state_13516;
(statearr_13519[(8)] = inst_13469);

(statearr_13519[(9)] = inst_13471);

(statearr_13519[(10)] = inst_13493);

(statearr_13519[(11)] = inst_13468);

(statearr_13519[(12)] = inst_13470);

return statearr_13519;
})();
var statearr_13520_13560 = state_13516__$1;
(statearr_13520_13560[(2)] = null);

(statearr_13520_13560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (1))){
var state_13516__$1 = state_13516;
var statearr_13521_13561 = state_13516__$1;
(statearr_13521_13561[(2)] = null);

(statearr_13521_13561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (4))){
var inst_13457 = (state_13516[(13)]);
var inst_13457__$1 = (state_13516[(2)]);
var inst_13458 = (inst_13457__$1 == null);
var state_13516__$1 = (function (){var statearr_13522 = state_13516;
(statearr_13522[(13)] = inst_13457__$1);

return statearr_13522;
})();
if(cljs.core.truth_(inst_13458)){
var statearr_13523_13562 = state_13516__$1;
(statearr_13523_13562[(1)] = (5));

} else {
var statearr_13524_13563 = state_13516__$1;
(statearr_13524_13563[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (15))){
var state_13516__$1 = state_13516;
var statearr_13528_13564 = state_13516__$1;
(statearr_13528_13564[(2)] = null);

(statearr_13528_13564[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (21))){
var state_13516__$1 = state_13516;
var statearr_13529_13565 = state_13516__$1;
(statearr_13529_13565[(2)] = null);

(statearr_13529_13565[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (13))){
var inst_13469 = (state_13516[(8)]);
var inst_13471 = (state_13516[(9)]);
var inst_13468 = (state_13516[(11)]);
var inst_13470 = (state_13516[(12)]);
var inst_13478 = (state_13516[(2)]);
var inst_13479 = (inst_13471 + (1));
var tmp13525 = inst_13469;
var tmp13526 = inst_13468;
var tmp13527 = inst_13470;
var inst_13468__$1 = tmp13526;
var inst_13469__$1 = tmp13525;
var inst_13470__$1 = tmp13527;
var inst_13471__$1 = inst_13479;
var state_13516__$1 = (function (){var statearr_13530 = state_13516;
(statearr_13530[(8)] = inst_13469__$1);

(statearr_13530[(9)] = inst_13471__$1);

(statearr_13530[(11)] = inst_13468__$1);

(statearr_13530[(14)] = inst_13478);

(statearr_13530[(12)] = inst_13470__$1);

return statearr_13530;
})();
var statearr_13531_13566 = state_13516__$1;
(statearr_13531_13566[(2)] = null);

(statearr_13531_13566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (22))){
var state_13516__$1 = state_13516;
var statearr_13532_13567 = state_13516__$1;
(statearr_13532_13567[(2)] = null);

(statearr_13532_13567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (6))){
var inst_13457 = (state_13516[(13)]);
var inst_13466 = f.call(null,inst_13457);
var inst_13467 = cljs.core.seq.call(null,inst_13466);
var inst_13468 = inst_13467;
var inst_13469 = null;
var inst_13470 = (0);
var inst_13471 = (0);
var state_13516__$1 = (function (){var statearr_13533 = state_13516;
(statearr_13533[(8)] = inst_13469);

(statearr_13533[(9)] = inst_13471);

(statearr_13533[(11)] = inst_13468);

(statearr_13533[(12)] = inst_13470);

return statearr_13533;
})();
var statearr_13534_13568 = state_13516__$1;
(statearr_13534_13568[(2)] = null);

(statearr_13534_13568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (17))){
var inst_13482 = (state_13516[(7)]);
var inst_13486 = cljs.core.chunk_first.call(null,inst_13482);
var inst_13487 = cljs.core.chunk_rest.call(null,inst_13482);
var inst_13488 = cljs.core.count.call(null,inst_13486);
var inst_13468 = inst_13487;
var inst_13469 = inst_13486;
var inst_13470 = inst_13488;
var inst_13471 = (0);
var state_13516__$1 = (function (){var statearr_13535 = state_13516;
(statearr_13535[(8)] = inst_13469);

(statearr_13535[(9)] = inst_13471);

(statearr_13535[(11)] = inst_13468);

(statearr_13535[(12)] = inst_13470);

return statearr_13535;
})();
var statearr_13536_13569 = state_13516__$1;
(statearr_13536_13569[(2)] = null);

(statearr_13536_13569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (3))){
var inst_13514 = (state_13516[(2)]);
var state_13516__$1 = state_13516;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13516__$1,inst_13514);
} else {
if((state_val_13517 === (12))){
var inst_13502 = (state_13516[(2)]);
var state_13516__$1 = state_13516;
var statearr_13537_13570 = state_13516__$1;
(statearr_13537_13570[(2)] = inst_13502);

(statearr_13537_13570[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (2))){
var state_13516__$1 = state_13516;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13516__$1,(4),in$);
} else {
if((state_val_13517 === (23))){
var inst_13510 = (state_13516[(2)]);
var state_13516__$1 = state_13516;
var statearr_13538_13571 = state_13516__$1;
(statearr_13538_13571[(2)] = inst_13510);

(statearr_13538_13571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (19))){
var inst_13497 = (state_13516[(2)]);
var state_13516__$1 = state_13516;
var statearr_13539_13572 = state_13516__$1;
(statearr_13539_13572[(2)] = inst_13497);

(statearr_13539_13572[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (11))){
var inst_13482 = (state_13516[(7)]);
var inst_13468 = (state_13516[(11)]);
var inst_13482__$1 = cljs.core.seq.call(null,inst_13468);
var state_13516__$1 = (function (){var statearr_13540 = state_13516;
(statearr_13540[(7)] = inst_13482__$1);

return statearr_13540;
})();
if(inst_13482__$1){
var statearr_13541_13573 = state_13516__$1;
(statearr_13541_13573[(1)] = (14));

} else {
var statearr_13542_13574 = state_13516__$1;
(statearr_13542_13574[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (9))){
var inst_13504 = (state_13516[(2)]);
var inst_13505 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13516__$1 = (function (){var statearr_13543 = state_13516;
(statearr_13543[(15)] = inst_13504);

return statearr_13543;
})();
if(cljs.core.truth_(inst_13505)){
var statearr_13544_13575 = state_13516__$1;
(statearr_13544_13575[(1)] = (21));

} else {
var statearr_13545_13576 = state_13516__$1;
(statearr_13545_13576[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (5))){
var inst_13460 = cljs.core.async.close_BANG_.call(null,out);
var state_13516__$1 = state_13516;
var statearr_13546_13577 = state_13516__$1;
(statearr_13546_13577[(2)] = inst_13460);

(statearr_13546_13577[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (14))){
var inst_13482 = (state_13516[(7)]);
var inst_13484 = cljs.core.chunked_seq_QMARK_.call(null,inst_13482);
var state_13516__$1 = state_13516;
if(inst_13484){
var statearr_13547_13578 = state_13516__$1;
(statearr_13547_13578[(1)] = (17));

} else {
var statearr_13548_13579 = state_13516__$1;
(statearr_13548_13579[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (16))){
var inst_13500 = (state_13516[(2)]);
var state_13516__$1 = state_13516;
var statearr_13549_13580 = state_13516__$1;
(statearr_13549_13580[(2)] = inst_13500);

(statearr_13549_13580[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13517 === (10))){
var inst_13469 = (state_13516[(8)]);
var inst_13471 = (state_13516[(9)]);
var inst_13476 = cljs.core._nth.call(null,inst_13469,inst_13471);
var state_13516__$1 = state_13516;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13516__$1,(13),out,inst_13476);
} else {
if((state_val_13517 === (18))){
var inst_13482 = (state_13516[(7)]);
var inst_13491 = cljs.core.first.call(null,inst_13482);
var state_13516__$1 = state_13516;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13516__$1,(20),out,inst_13491);
} else {
if((state_val_13517 === (8))){
var inst_13471 = (state_13516[(9)]);
var inst_13470 = (state_13516[(12)]);
var inst_13473 = (inst_13471 < inst_13470);
var inst_13474 = inst_13473;
var state_13516__$1 = state_13516;
if(cljs.core.truth_(inst_13474)){
var statearr_13550_13581 = state_13516__$1;
(statearr_13550_13581[(1)] = (10));

} else {
var statearr_13551_13582 = state_13516__$1;
(statearr_13551_13582[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto__))
;
return ((function (switch__10969__auto__,c__11081__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____0 = (function (){
var statearr_13555 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13555[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__);

(statearr_13555[(1)] = (1));

return statearr_13555;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____1 = (function (state_13516){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_13516);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e13556){if((e13556 instanceof Object)){
var ex__10973__auto__ = e13556;
var statearr_13557_13583 = state_13516;
(statearr_13557_13583[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13516);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13556;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13584 = state_13516;
state_13516 = G__13584;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__ = function(state_13516){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____1.call(this,state_13516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10970__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto__))
})();
var state__11083__auto__ = (function (){var statearr_13558 = f__11082__auto__.call(null);
(statearr_13558[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto__);

return statearr_13558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto__))
);

return c__11081__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13585 = [];
var len__5726__auto___13588 = arguments.length;
var i__5727__auto___13589 = (0);
while(true){
if((i__5727__auto___13589 < len__5726__auto___13588)){
args13585.push((arguments[i__5727__auto___13589]));

var G__13590 = (i__5727__auto___13589 + (1));
i__5727__auto___13589 = G__13590;
continue;
} else {
}
break;
}

var G__13587 = args13585.length;
switch (G__13587) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13585.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13592 = [];
var len__5726__auto___13595 = arguments.length;
var i__5727__auto___13596 = (0);
while(true){
if((i__5727__auto___13596 < len__5726__auto___13595)){
args13592.push((arguments[i__5727__auto___13596]));

var G__13597 = (i__5727__auto___13596 + (1));
i__5727__auto___13596 = G__13597;
continue;
} else {
}
break;
}

var G__13594 = args13592.length;
switch (G__13594) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13592.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13599 = [];
var len__5726__auto___13650 = arguments.length;
var i__5727__auto___13651 = (0);
while(true){
if((i__5727__auto___13651 < len__5726__auto___13650)){
args13599.push((arguments[i__5727__auto___13651]));

var G__13652 = (i__5727__auto___13651 + (1));
i__5727__auto___13651 = G__13652;
continue;
} else {
}
break;
}

var G__13601 = args13599.length;
switch (G__13601) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13599.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___13654 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___13654,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___13654,out){
return (function (state_13625){
var state_val_13626 = (state_13625[(1)]);
if((state_val_13626 === (7))){
var inst_13620 = (state_13625[(2)]);
var state_13625__$1 = state_13625;
var statearr_13627_13655 = state_13625__$1;
(statearr_13627_13655[(2)] = inst_13620);

(statearr_13627_13655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13626 === (1))){
var inst_13602 = null;
var state_13625__$1 = (function (){var statearr_13628 = state_13625;
(statearr_13628[(7)] = inst_13602);

return statearr_13628;
})();
var statearr_13629_13656 = state_13625__$1;
(statearr_13629_13656[(2)] = null);

(statearr_13629_13656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13626 === (4))){
var inst_13605 = (state_13625[(8)]);
var inst_13605__$1 = (state_13625[(2)]);
var inst_13606 = (inst_13605__$1 == null);
var inst_13607 = cljs.core.not.call(null,inst_13606);
var state_13625__$1 = (function (){var statearr_13630 = state_13625;
(statearr_13630[(8)] = inst_13605__$1);

return statearr_13630;
})();
if(inst_13607){
var statearr_13631_13657 = state_13625__$1;
(statearr_13631_13657[(1)] = (5));

} else {
var statearr_13632_13658 = state_13625__$1;
(statearr_13632_13658[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13626 === (6))){
var state_13625__$1 = state_13625;
var statearr_13633_13659 = state_13625__$1;
(statearr_13633_13659[(2)] = null);

(statearr_13633_13659[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13626 === (3))){
var inst_13622 = (state_13625[(2)]);
var inst_13623 = cljs.core.async.close_BANG_.call(null,out);
var state_13625__$1 = (function (){var statearr_13634 = state_13625;
(statearr_13634[(9)] = inst_13622);

return statearr_13634;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13625__$1,inst_13623);
} else {
if((state_val_13626 === (2))){
var state_13625__$1 = state_13625;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13625__$1,(4),ch);
} else {
if((state_val_13626 === (11))){
var inst_13605 = (state_13625[(8)]);
var inst_13614 = (state_13625[(2)]);
var inst_13602 = inst_13605;
var state_13625__$1 = (function (){var statearr_13635 = state_13625;
(statearr_13635[(7)] = inst_13602);

(statearr_13635[(10)] = inst_13614);

return statearr_13635;
})();
var statearr_13636_13660 = state_13625__$1;
(statearr_13636_13660[(2)] = null);

(statearr_13636_13660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13626 === (9))){
var inst_13605 = (state_13625[(8)]);
var state_13625__$1 = state_13625;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13625__$1,(11),out,inst_13605);
} else {
if((state_val_13626 === (5))){
var inst_13602 = (state_13625[(7)]);
var inst_13605 = (state_13625[(8)]);
var inst_13609 = cljs.core._EQ_.call(null,inst_13605,inst_13602);
var state_13625__$1 = state_13625;
if(inst_13609){
var statearr_13638_13661 = state_13625__$1;
(statearr_13638_13661[(1)] = (8));

} else {
var statearr_13639_13662 = state_13625__$1;
(statearr_13639_13662[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13626 === (10))){
var inst_13617 = (state_13625[(2)]);
var state_13625__$1 = state_13625;
var statearr_13640_13663 = state_13625__$1;
(statearr_13640_13663[(2)] = inst_13617);

(statearr_13640_13663[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13626 === (8))){
var inst_13602 = (state_13625[(7)]);
var tmp13637 = inst_13602;
var inst_13602__$1 = tmp13637;
var state_13625__$1 = (function (){var statearr_13641 = state_13625;
(statearr_13641[(7)] = inst_13602__$1);

return statearr_13641;
})();
var statearr_13642_13664 = state_13625__$1;
(statearr_13642_13664[(2)] = null);

(statearr_13642_13664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___13654,out))
;
return ((function (switch__10969__auto__,c__11081__auto___13654,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_13646 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13646[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_13646[(1)] = (1));

return statearr_13646;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_13625){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_13625);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e13647){if((e13647 instanceof Object)){
var ex__10973__auto__ = e13647;
var statearr_13648_13665 = state_13625;
(statearr_13648_13665[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13625);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13647;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13666 = state_13625;
state_13625 = G__13666;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_13625){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_13625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___13654,out))
})();
var state__11083__auto__ = (function (){var statearr_13649 = f__11082__auto__.call(null);
(statearr_13649[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___13654);

return statearr_13649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___13654,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13667 = [];
var len__5726__auto___13737 = arguments.length;
var i__5727__auto___13738 = (0);
while(true){
if((i__5727__auto___13738 < len__5726__auto___13737)){
args13667.push((arguments[i__5727__auto___13738]));

var G__13739 = (i__5727__auto___13738 + (1));
i__5727__auto___13738 = G__13739;
continue;
} else {
}
break;
}

var G__13669 = args13667.length;
switch (G__13669) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13667.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___13741 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___13741,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___13741,out){
return (function (state_13707){
var state_val_13708 = (state_13707[(1)]);
if((state_val_13708 === (7))){
var inst_13703 = (state_13707[(2)]);
var state_13707__$1 = state_13707;
var statearr_13709_13742 = state_13707__$1;
(statearr_13709_13742[(2)] = inst_13703);

(statearr_13709_13742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (1))){
var inst_13670 = (new Array(n));
var inst_13671 = inst_13670;
var inst_13672 = (0);
var state_13707__$1 = (function (){var statearr_13710 = state_13707;
(statearr_13710[(7)] = inst_13671);

(statearr_13710[(8)] = inst_13672);

return statearr_13710;
})();
var statearr_13711_13743 = state_13707__$1;
(statearr_13711_13743[(2)] = null);

(statearr_13711_13743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (4))){
var inst_13675 = (state_13707[(9)]);
var inst_13675__$1 = (state_13707[(2)]);
var inst_13676 = (inst_13675__$1 == null);
var inst_13677 = cljs.core.not.call(null,inst_13676);
var state_13707__$1 = (function (){var statearr_13712 = state_13707;
(statearr_13712[(9)] = inst_13675__$1);

return statearr_13712;
})();
if(inst_13677){
var statearr_13713_13744 = state_13707__$1;
(statearr_13713_13744[(1)] = (5));

} else {
var statearr_13714_13745 = state_13707__$1;
(statearr_13714_13745[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (15))){
var inst_13697 = (state_13707[(2)]);
var state_13707__$1 = state_13707;
var statearr_13715_13746 = state_13707__$1;
(statearr_13715_13746[(2)] = inst_13697);

(statearr_13715_13746[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (13))){
var state_13707__$1 = state_13707;
var statearr_13716_13747 = state_13707__$1;
(statearr_13716_13747[(2)] = null);

(statearr_13716_13747[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (6))){
var inst_13672 = (state_13707[(8)]);
var inst_13693 = (inst_13672 > (0));
var state_13707__$1 = state_13707;
if(cljs.core.truth_(inst_13693)){
var statearr_13717_13748 = state_13707__$1;
(statearr_13717_13748[(1)] = (12));

} else {
var statearr_13718_13749 = state_13707__$1;
(statearr_13718_13749[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (3))){
var inst_13705 = (state_13707[(2)]);
var state_13707__$1 = state_13707;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13707__$1,inst_13705);
} else {
if((state_val_13708 === (12))){
var inst_13671 = (state_13707[(7)]);
var inst_13695 = cljs.core.vec.call(null,inst_13671);
var state_13707__$1 = state_13707;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13707__$1,(15),out,inst_13695);
} else {
if((state_val_13708 === (2))){
var state_13707__$1 = state_13707;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13707__$1,(4),ch);
} else {
if((state_val_13708 === (11))){
var inst_13687 = (state_13707[(2)]);
var inst_13688 = (new Array(n));
var inst_13671 = inst_13688;
var inst_13672 = (0);
var state_13707__$1 = (function (){var statearr_13719 = state_13707;
(statearr_13719[(7)] = inst_13671);

(statearr_13719[(8)] = inst_13672);

(statearr_13719[(10)] = inst_13687);

return statearr_13719;
})();
var statearr_13720_13750 = state_13707__$1;
(statearr_13720_13750[(2)] = null);

(statearr_13720_13750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (9))){
var inst_13671 = (state_13707[(7)]);
var inst_13685 = cljs.core.vec.call(null,inst_13671);
var state_13707__$1 = state_13707;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13707__$1,(11),out,inst_13685);
} else {
if((state_val_13708 === (5))){
var inst_13671 = (state_13707[(7)]);
var inst_13672 = (state_13707[(8)]);
var inst_13680 = (state_13707[(11)]);
var inst_13675 = (state_13707[(9)]);
var inst_13679 = (inst_13671[inst_13672] = inst_13675);
var inst_13680__$1 = (inst_13672 + (1));
var inst_13681 = (inst_13680__$1 < n);
var state_13707__$1 = (function (){var statearr_13721 = state_13707;
(statearr_13721[(12)] = inst_13679);

(statearr_13721[(11)] = inst_13680__$1);

return statearr_13721;
})();
if(cljs.core.truth_(inst_13681)){
var statearr_13722_13751 = state_13707__$1;
(statearr_13722_13751[(1)] = (8));

} else {
var statearr_13723_13752 = state_13707__$1;
(statearr_13723_13752[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (14))){
var inst_13700 = (state_13707[(2)]);
var inst_13701 = cljs.core.async.close_BANG_.call(null,out);
var state_13707__$1 = (function (){var statearr_13725 = state_13707;
(statearr_13725[(13)] = inst_13700);

return statearr_13725;
})();
var statearr_13726_13753 = state_13707__$1;
(statearr_13726_13753[(2)] = inst_13701);

(statearr_13726_13753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (10))){
var inst_13691 = (state_13707[(2)]);
var state_13707__$1 = state_13707;
var statearr_13727_13754 = state_13707__$1;
(statearr_13727_13754[(2)] = inst_13691);

(statearr_13727_13754[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13708 === (8))){
var inst_13671 = (state_13707[(7)]);
var inst_13680 = (state_13707[(11)]);
var tmp13724 = inst_13671;
var inst_13671__$1 = tmp13724;
var inst_13672 = inst_13680;
var state_13707__$1 = (function (){var statearr_13728 = state_13707;
(statearr_13728[(7)] = inst_13671__$1);

(statearr_13728[(8)] = inst_13672);

return statearr_13728;
})();
var statearr_13729_13755 = state_13707__$1;
(statearr_13729_13755[(2)] = null);

(statearr_13729_13755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___13741,out))
;
return ((function (switch__10969__auto__,c__11081__auto___13741,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_13733 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13733[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_13733[(1)] = (1));

return statearr_13733;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_13707){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_13707);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e13734){if((e13734 instanceof Object)){
var ex__10973__auto__ = e13734;
var statearr_13735_13756 = state_13707;
(statearr_13735_13756[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13707);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13757 = state_13707;
state_13707 = G__13757;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_13707){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_13707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___13741,out))
})();
var state__11083__auto__ = (function (){var statearr_13736 = f__11082__auto__.call(null);
(statearr_13736[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___13741);

return statearr_13736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___13741,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13758 = [];
var len__5726__auto___13832 = arguments.length;
var i__5727__auto___13833 = (0);
while(true){
if((i__5727__auto___13833 < len__5726__auto___13832)){
args13758.push((arguments[i__5727__auto___13833]));

var G__13834 = (i__5727__auto___13833 + (1));
i__5727__auto___13833 = G__13834;
continue;
} else {
}
break;
}

var G__13760 = args13758.length;
switch (G__13760) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13758.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11081__auto___13836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11081__auto___13836,out){
return (function (){
var f__11082__auto__ = (function (){var switch__10969__auto__ = ((function (c__11081__auto___13836,out){
return (function (state_13802){
var state_val_13803 = (state_13802[(1)]);
if((state_val_13803 === (7))){
var inst_13798 = (state_13802[(2)]);
var state_13802__$1 = state_13802;
var statearr_13804_13837 = state_13802__$1;
(statearr_13804_13837[(2)] = inst_13798);

(statearr_13804_13837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (1))){
var inst_13761 = [];
var inst_13762 = inst_13761;
var inst_13763 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13802__$1 = (function (){var statearr_13805 = state_13802;
(statearr_13805[(7)] = inst_13762);

(statearr_13805[(8)] = inst_13763);

return statearr_13805;
})();
var statearr_13806_13838 = state_13802__$1;
(statearr_13806_13838[(2)] = null);

(statearr_13806_13838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (4))){
var inst_13766 = (state_13802[(9)]);
var inst_13766__$1 = (state_13802[(2)]);
var inst_13767 = (inst_13766__$1 == null);
var inst_13768 = cljs.core.not.call(null,inst_13767);
var state_13802__$1 = (function (){var statearr_13807 = state_13802;
(statearr_13807[(9)] = inst_13766__$1);

return statearr_13807;
})();
if(inst_13768){
var statearr_13808_13839 = state_13802__$1;
(statearr_13808_13839[(1)] = (5));

} else {
var statearr_13809_13840 = state_13802__$1;
(statearr_13809_13840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (15))){
var inst_13792 = (state_13802[(2)]);
var state_13802__$1 = state_13802;
var statearr_13810_13841 = state_13802__$1;
(statearr_13810_13841[(2)] = inst_13792);

(statearr_13810_13841[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (13))){
var state_13802__$1 = state_13802;
var statearr_13811_13842 = state_13802__$1;
(statearr_13811_13842[(2)] = null);

(statearr_13811_13842[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (6))){
var inst_13762 = (state_13802[(7)]);
var inst_13787 = inst_13762.length;
var inst_13788 = (inst_13787 > (0));
var state_13802__$1 = state_13802;
if(cljs.core.truth_(inst_13788)){
var statearr_13812_13843 = state_13802__$1;
(statearr_13812_13843[(1)] = (12));

} else {
var statearr_13813_13844 = state_13802__$1;
(statearr_13813_13844[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (3))){
var inst_13800 = (state_13802[(2)]);
var state_13802__$1 = state_13802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13802__$1,inst_13800);
} else {
if((state_val_13803 === (12))){
var inst_13762 = (state_13802[(7)]);
var inst_13790 = cljs.core.vec.call(null,inst_13762);
var state_13802__$1 = state_13802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13802__$1,(15),out,inst_13790);
} else {
if((state_val_13803 === (2))){
var state_13802__$1 = state_13802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13802__$1,(4),ch);
} else {
if((state_val_13803 === (11))){
var inst_13766 = (state_13802[(9)]);
var inst_13770 = (state_13802[(10)]);
var inst_13780 = (state_13802[(2)]);
var inst_13781 = [];
var inst_13782 = inst_13781.push(inst_13766);
var inst_13762 = inst_13781;
var inst_13763 = inst_13770;
var state_13802__$1 = (function (){var statearr_13814 = state_13802;
(statearr_13814[(11)] = inst_13782);

(statearr_13814[(7)] = inst_13762);

(statearr_13814[(8)] = inst_13763);

(statearr_13814[(12)] = inst_13780);

return statearr_13814;
})();
var statearr_13815_13845 = state_13802__$1;
(statearr_13815_13845[(2)] = null);

(statearr_13815_13845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (9))){
var inst_13762 = (state_13802[(7)]);
var inst_13778 = cljs.core.vec.call(null,inst_13762);
var state_13802__$1 = state_13802;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13802__$1,(11),out,inst_13778);
} else {
if((state_val_13803 === (5))){
var inst_13763 = (state_13802[(8)]);
var inst_13766 = (state_13802[(9)]);
var inst_13770 = (state_13802[(10)]);
var inst_13770__$1 = f.call(null,inst_13766);
var inst_13771 = cljs.core._EQ_.call(null,inst_13770__$1,inst_13763);
var inst_13772 = cljs.core.keyword_identical_QMARK_.call(null,inst_13763,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13773 = (inst_13771) || (inst_13772);
var state_13802__$1 = (function (){var statearr_13816 = state_13802;
(statearr_13816[(10)] = inst_13770__$1);

return statearr_13816;
})();
if(cljs.core.truth_(inst_13773)){
var statearr_13817_13846 = state_13802__$1;
(statearr_13817_13846[(1)] = (8));

} else {
var statearr_13818_13847 = state_13802__$1;
(statearr_13818_13847[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (14))){
var inst_13795 = (state_13802[(2)]);
var inst_13796 = cljs.core.async.close_BANG_.call(null,out);
var state_13802__$1 = (function (){var statearr_13820 = state_13802;
(statearr_13820[(13)] = inst_13795);

return statearr_13820;
})();
var statearr_13821_13848 = state_13802__$1;
(statearr_13821_13848[(2)] = inst_13796);

(statearr_13821_13848[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (10))){
var inst_13785 = (state_13802[(2)]);
var state_13802__$1 = state_13802;
var statearr_13822_13849 = state_13802__$1;
(statearr_13822_13849[(2)] = inst_13785);

(statearr_13822_13849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13803 === (8))){
var inst_13762 = (state_13802[(7)]);
var inst_13766 = (state_13802[(9)]);
var inst_13770 = (state_13802[(10)]);
var inst_13775 = inst_13762.push(inst_13766);
var tmp13819 = inst_13762;
var inst_13762__$1 = tmp13819;
var inst_13763 = inst_13770;
var state_13802__$1 = (function (){var statearr_13823 = state_13802;
(statearr_13823[(14)] = inst_13775);

(statearr_13823[(7)] = inst_13762__$1);

(statearr_13823[(8)] = inst_13763);

return statearr_13823;
})();
var statearr_13824_13850 = state_13802__$1;
(statearr_13824_13850[(2)] = null);

(statearr_13824_13850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11081__auto___13836,out))
;
return ((function (switch__10969__auto__,c__11081__auto___13836,out){
return (function() {
var cljs$core$async$state_machine__10970__auto__ = null;
var cljs$core$async$state_machine__10970__auto____0 = (function (){
var statearr_13828 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13828[(0)] = cljs$core$async$state_machine__10970__auto__);

(statearr_13828[(1)] = (1));

return statearr_13828;
});
var cljs$core$async$state_machine__10970__auto____1 = (function (state_13802){
while(true){
var ret_value__10971__auto__ = (function (){try{while(true){
var result__10972__auto__ = switch__10969__auto__.call(null,state_13802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10972__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10972__auto__;
}
break;
}
}catch (e13829){if((e13829 instanceof Object)){
var ex__10973__auto__ = e13829;
var statearr_13830_13851 = state_13802;
(statearr_13830_13851[(5)] = ex__10973__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13829;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10971__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13852 = state_13802;
state_13802 = G__13852;
continue;
} else {
return ret_value__10971__auto__;
}
break;
}
});
cljs$core$async$state_machine__10970__auto__ = function(state_13802){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10970__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10970__auto____1.call(this,state_13802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10970__auto____0;
cljs$core$async$state_machine__10970__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10970__auto____1;
return cljs$core$async$state_machine__10970__auto__;
})()
;})(switch__10969__auto__,c__11081__auto___13836,out))
})();
var state__11083__auto__ = (function (){var statearr_13831 = f__11082__auto__.call(null);
(statearr_13831[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11081__auto___13836);

return statearr_13831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11083__auto__);
});})(c__11081__auto___13836,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1463994338205