// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11118 = [];
var len__5726__auto___11124 = arguments.length;
var i__5727__auto___11125 = (0);
while(true){
if((i__5727__auto___11125 < len__5726__auto___11124)){
args11118.push((arguments[i__5727__auto___11125]));

var G__11126 = (i__5727__auto___11125 + (1));
i__5727__auto___11125 = G__11126;
continue;
} else {
}
break;
}

var G__11120 = args11118.length;
switch (G__11120) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11118.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11121 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11121 = (function (f,blockable,meta11122){
this.f = f;
this.blockable = blockable;
this.meta11122 = meta11122;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11121.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11123,meta11122__$1){
var self__ = this;
var _11123__$1 = this;
return (new cljs.core.async.t_cljs$core$async11121(self__.f,self__.blockable,meta11122__$1));
});

cljs.core.async.t_cljs$core$async11121.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11123){
var self__ = this;
var _11123__$1 = this;
return self__.meta11122;
});

cljs.core.async.t_cljs$core$async11121.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11121.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11121.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11121.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11121.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11122","meta11122",-765423377,null)], null);
});

cljs.core.async.t_cljs$core$async11121.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11121.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11121";

cljs.core.async.t_cljs$core$async11121.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11121");
});

cljs.core.async.__GT_t_cljs$core$async11121 = (function cljs$core$async$__GT_t_cljs$core$async11121(f__$1,blockable__$1,meta11122){
return (new cljs.core.async.t_cljs$core$async11121(f__$1,blockable__$1,meta11122));
});

}

return (new cljs.core.async.t_cljs$core$async11121(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11130 = [];
var len__5726__auto___11133 = arguments.length;
var i__5727__auto___11134 = (0);
while(true){
if((i__5727__auto___11134 < len__5726__auto___11133)){
args11130.push((arguments[i__5727__auto___11134]));

var G__11135 = (i__5727__auto___11134 + (1));
i__5727__auto___11134 = G__11135;
continue;
} else {
}
break;
}

var G__11132 = args11130.length;
switch (G__11132) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11130.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11137 = [];
var len__5726__auto___11140 = arguments.length;
var i__5727__auto___11141 = (0);
while(true){
if((i__5727__auto___11141 < len__5726__auto___11140)){
args11137.push((arguments[i__5727__auto___11141]));

var G__11142 = (i__5727__auto___11141 + (1));
i__5727__auto___11141 = G__11142;
continue;
} else {
}
break;
}

var G__11139 = args11137.length;
switch (G__11139) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11137.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11144 = [];
var len__5726__auto___11147 = arguments.length;
var i__5727__auto___11148 = (0);
while(true){
if((i__5727__auto___11148 < len__5726__auto___11147)){
args11144.push((arguments[i__5727__auto___11148]));

var G__11149 = (i__5727__auto___11148 + (1));
i__5727__auto___11148 = G__11149;
continue;
} else {
}
break;
}

var G__11146 = args11144.length;
switch (G__11146) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11144.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11151 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11151);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11151,ret){
return (function (){
return fn1.call(null,val_11151);
});})(val_11151,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11152 = [];
var len__5726__auto___11155 = arguments.length;
var i__5727__auto___11156 = (0);
while(true){
if((i__5727__auto___11156 < len__5726__auto___11155)){
args11152.push((arguments[i__5727__auto___11156]));

var G__11157 = (i__5727__auto___11156 + (1));
i__5727__auto___11156 = G__11157;
continue;
} else {
}
break;
}

var G__11154 = args11152.length;
switch (G__11154) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11152.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___11159 = n;
var x_11160 = (0);
while(true){
if((x_11160 < n__5571__auto___11159)){
(a[x_11160] = (0));

var G__11161 = (x_11160 + (1));
x_11160 = G__11161;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11162 = (i + (1));
i = G__11162;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11166 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11166 = (function (alt_flag,flag,meta11167){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11167 = meta11167;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11166.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11168,meta11167__$1){
var self__ = this;
var _11168__$1 = this;
return (new cljs.core.async.t_cljs$core$async11166(self__.alt_flag,self__.flag,meta11167__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11166.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11168){
var self__ = this;
var _11168__$1 = this;
return self__.meta11167;
});})(flag))
;

cljs.core.async.t_cljs$core$async11166.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11166.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11166.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11166.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11166.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11167","meta11167",1472212360,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11166.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11166.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11166";

cljs.core.async.t_cljs$core$async11166.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11166");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11166 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11166(alt_flag__$1,flag__$1,meta11167){
return (new cljs.core.async.t_cljs$core$async11166(alt_flag__$1,flag__$1,meta11167));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11166(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11172 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11172 = (function (alt_handler,flag,cb,meta11173){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11173 = meta11173;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11172.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11174,meta11173__$1){
var self__ = this;
var _11174__$1 = this;
return (new cljs.core.async.t_cljs$core$async11172(self__.alt_handler,self__.flag,self__.cb,meta11173__$1));
});

cljs.core.async.t_cljs$core$async11172.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11174){
var self__ = this;
var _11174__$1 = this;
return self__.meta11173;
});

cljs.core.async.t_cljs$core$async11172.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11172.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11172.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11172.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11172.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11173","meta11173",-1414480978,null)], null);
});

cljs.core.async.t_cljs$core$async11172.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11172.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11172";

cljs.core.async.t_cljs$core$async11172.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11172");
});

cljs.core.async.__GT_t_cljs$core$async11172 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11172(alt_handler__$1,flag__$1,cb__$1,meta11173){
return (new cljs.core.async.t_cljs$core$async11172(alt_handler__$1,flag__$1,cb__$1,meta11173));
});

}

return (new cljs.core.async.t_cljs$core$async11172(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11175_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11175_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11176_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11176_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11177 = (i + (1));
i = G__11177;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11183 = arguments.length;
var i__5727__auto___11184 = (0);
while(true){
if((i__5727__auto___11184 < len__5726__auto___11183)){
args__5733__auto__.push((arguments[i__5727__auto___11184]));

var G__11185 = (i__5727__auto___11184 + (1));
i__5727__auto___11184 = G__11185;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11180){
var map__11181 = p__11180;
var map__11181__$1 = ((((!((map__11181 == null)))?((((map__11181.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11181.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11181):map__11181);
var opts = map__11181__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11178){
var G__11179 = cljs.core.first.call(null,seq11178);
var seq11178__$1 = cljs.core.next.call(null,seq11178);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11179,seq11178__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11186 = [];
var len__5726__auto___11236 = arguments.length;
var i__5727__auto___11237 = (0);
while(true){
if((i__5727__auto___11237 < len__5726__auto___11236)){
args11186.push((arguments[i__5727__auto___11237]));

var G__11238 = (i__5727__auto___11237 + (1));
i__5727__auto___11237 = G__11238;
continue;
} else {
}
break;
}

var G__11188 = args11186.length;
switch (G__11188) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11186.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11073__auto___11240 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___11240){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___11240){
return (function (state_11212){
var state_val_11213 = (state_11212[(1)]);
if((state_val_11213 === (7))){
var inst_11208 = (state_11212[(2)]);
var state_11212__$1 = state_11212;
var statearr_11214_11241 = state_11212__$1;
(statearr_11214_11241[(2)] = inst_11208);

(statearr_11214_11241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (1))){
var state_11212__$1 = state_11212;
var statearr_11215_11242 = state_11212__$1;
(statearr_11215_11242[(2)] = null);

(statearr_11215_11242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (4))){
var inst_11191 = (state_11212[(7)]);
var inst_11191__$1 = (state_11212[(2)]);
var inst_11192 = (inst_11191__$1 == null);
var state_11212__$1 = (function (){var statearr_11216 = state_11212;
(statearr_11216[(7)] = inst_11191__$1);

return statearr_11216;
})();
if(cljs.core.truth_(inst_11192)){
var statearr_11217_11243 = state_11212__$1;
(statearr_11217_11243[(1)] = (5));

} else {
var statearr_11218_11244 = state_11212__$1;
(statearr_11218_11244[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (13))){
var state_11212__$1 = state_11212;
var statearr_11219_11245 = state_11212__$1;
(statearr_11219_11245[(2)] = null);

(statearr_11219_11245[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (6))){
var inst_11191 = (state_11212[(7)]);
var state_11212__$1 = state_11212;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11212__$1,(11),to,inst_11191);
} else {
if((state_val_11213 === (3))){
var inst_11210 = (state_11212[(2)]);
var state_11212__$1 = state_11212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11212__$1,inst_11210);
} else {
if((state_val_11213 === (12))){
var state_11212__$1 = state_11212;
var statearr_11220_11246 = state_11212__$1;
(statearr_11220_11246[(2)] = null);

(statearr_11220_11246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (2))){
var state_11212__$1 = state_11212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11212__$1,(4),from);
} else {
if((state_val_11213 === (11))){
var inst_11201 = (state_11212[(2)]);
var state_11212__$1 = state_11212;
if(cljs.core.truth_(inst_11201)){
var statearr_11221_11247 = state_11212__$1;
(statearr_11221_11247[(1)] = (12));

} else {
var statearr_11222_11248 = state_11212__$1;
(statearr_11222_11248[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (9))){
var state_11212__$1 = state_11212;
var statearr_11223_11249 = state_11212__$1;
(statearr_11223_11249[(2)] = null);

(statearr_11223_11249[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (5))){
var state_11212__$1 = state_11212;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11224_11250 = state_11212__$1;
(statearr_11224_11250[(1)] = (8));

} else {
var statearr_11225_11251 = state_11212__$1;
(statearr_11225_11251[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (14))){
var inst_11206 = (state_11212[(2)]);
var state_11212__$1 = state_11212;
var statearr_11226_11252 = state_11212__$1;
(statearr_11226_11252[(2)] = inst_11206);

(statearr_11226_11252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (10))){
var inst_11198 = (state_11212[(2)]);
var state_11212__$1 = state_11212;
var statearr_11227_11253 = state_11212__$1;
(statearr_11227_11253[(2)] = inst_11198);

(statearr_11227_11253[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11213 === (8))){
var inst_11195 = cljs.core.async.close_BANG_.call(null,to);
var state_11212__$1 = state_11212;
var statearr_11228_11254 = state_11212__$1;
(statearr_11228_11254[(2)] = inst_11195);

(statearr_11228_11254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___11240))
;
return ((function (switch__10961__auto__,c__11073__auto___11240){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_11232 = [null,null,null,null,null,null,null,null];
(statearr_11232[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_11232[(1)] = (1));

return statearr_11232;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_11212){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11233){if((e11233 instanceof Object)){
var ex__10965__auto__ = e11233;
var statearr_11234_11255 = state_11212;
(statearr_11234_11255[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11212);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11233;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11256 = state_11212;
state_11212 = G__11256;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_11212){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_11212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___11240))
})();
var state__11075__auto__ = (function (){var statearr_11235 = f__11074__auto__.call(null);
(statearr_11235[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___11240);

return statearr_11235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___11240))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11440){
var vec__11441 = p__11440;
var v = cljs.core.nth.call(null,vec__11441,(0),null);
var p = cljs.core.nth.call(null,vec__11441,(1),null);
var job = vec__11441;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11073__auto___11623 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___11623,res,vec__11441,v,p,job,jobs,results){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___11623,res,vec__11441,v,p,job,jobs,results){
return (function (state_11446){
var state_val_11447 = (state_11446[(1)]);
if((state_val_11447 === (1))){
var state_11446__$1 = state_11446;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11446__$1,(2),res,v);
} else {
if((state_val_11447 === (2))){
var inst_11443 = (state_11446[(2)]);
var inst_11444 = cljs.core.async.close_BANG_.call(null,res);
var state_11446__$1 = (function (){var statearr_11448 = state_11446;
(statearr_11448[(7)] = inst_11443);

return statearr_11448;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11446__$1,inst_11444);
} else {
return null;
}
}
});})(c__11073__auto___11623,res,vec__11441,v,p,job,jobs,results))
;
return ((function (switch__10961__auto__,c__11073__auto___11623,res,vec__11441,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_11452 = [null,null,null,null,null,null,null,null];
(statearr_11452[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_11452[(1)] = (1));

return statearr_11452;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_11446){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11453){if((e11453 instanceof Object)){
var ex__10965__auto__ = e11453;
var statearr_11454_11624 = state_11446;
(statearr_11454_11624[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11446);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11453;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11625 = state_11446;
state_11446 = G__11625;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_11446){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_11446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___11623,res,vec__11441,v,p,job,jobs,results))
})();
var state__11075__auto__ = (function (){var statearr_11455 = f__11074__auto__.call(null);
(statearr_11455[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___11623);

return statearr_11455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___11623,res,vec__11441,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11456){
var vec__11457 = p__11456;
var v = cljs.core.nth.call(null,vec__11457,(0),null);
var p = cljs.core.nth.call(null,vec__11457,(1),null);
var job = vec__11457;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___11626 = n;
var __11627 = (0);
while(true){
if((__11627 < n__5571__auto___11626)){
var G__11458_11628 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11458_11628) {
case "compute":
var c__11073__auto___11630 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11627,c__11073__auto___11630,G__11458_11628,n__5571__auto___11626,jobs,results,process,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (__11627,c__11073__auto___11630,G__11458_11628,n__5571__auto___11626,jobs,results,process,async){
return (function (state_11471){
var state_val_11472 = (state_11471[(1)]);
if((state_val_11472 === (1))){
var state_11471__$1 = state_11471;
var statearr_11473_11631 = state_11471__$1;
(statearr_11473_11631[(2)] = null);

(statearr_11473_11631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11472 === (2))){
var state_11471__$1 = state_11471;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11471__$1,(4),jobs);
} else {
if((state_val_11472 === (3))){
var inst_11469 = (state_11471[(2)]);
var state_11471__$1 = state_11471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11471__$1,inst_11469);
} else {
if((state_val_11472 === (4))){
var inst_11461 = (state_11471[(2)]);
var inst_11462 = process.call(null,inst_11461);
var state_11471__$1 = state_11471;
if(cljs.core.truth_(inst_11462)){
var statearr_11474_11632 = state_11471__$1;
(statearr_11474_11632[(1)] = (5));

} else {
var statearr_11475_11633 = state_11471__$1;
(statearr_11475_11633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11472 === (5))){
var state_11471__$1 = state_11471;
var statearr_11476_11634 = state_11471__$1;
(statearr_11476_11634[(2)] = null);

(statearr_11476_11634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11472 === (6))){
var state_11471__$1 = state_11471;
var statearr_11477_11635 = state_11471__$1;
(statearr_11477_11635[(2)] = null);

(statearr_11477_11635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11472 === (7))){
var inst_11467 = (state_11471[(2)]);
var state_11471__$1 = state_11471;
var statearr_11478_11636 = state_11471__$1;
(statearr_11478_11636[(2)] = inst_11467);

(statearr_11478_11636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11627,c__11073__auto___11630,G__11458_11628,n__5571__auto___11626,jobs,results,process,async))
;
return ((function (__11627,switch__10961__auto__,c__11073__auto___11630,G__11458_11628,n__5571__auto___11626,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_11482 = [null,null,null,null,null,null,null];
(statearr_11482[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_11482[(1)] = (1));

return statearr_11482;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_11471){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11483){if((e11483 instanceof Object)){
var ex__10965__auto__ = e11483;
var statearr_11484_11637 = state_11471;
(statearr_11484_11637[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11471);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11483;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11638 = state_11471;
state_11471 = G__11638;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_11471){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_11471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(__11627,switch__10961__auto__,c__11073__auto___11630,G__11458_11628,n__5571__auto___11626,jobs,results,process,async))
})();
var state__11075__auto__ = (function (){var statearr_11485 = f__11074__auto__.call(null);
(statearr_11485[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___11630);

return statearr_11485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(__11627,c__11073__auto___11630,G__11458_11628,n__5571__auto___11626,jobs,results,process,async))
);


break;
case "async":
var c__11073__auto___11639 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11627,c__11073__auto___11639,G__11458_11628,n__5571__auto___11626,jobs,results,process,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (__11627,c__11073__auto___11639,G__11458_11628,n__5571__auto___11626,jobs,results,process,async){
return (function (state_11498){
var state_val_11499 = (state_11498[(1)]);
if((state_val_11499 === (1))){
var state_11498__$1 = state_11498;
var statearr_11500_11640 = state_11498__$1;
(statearr_11500_11640[(2)] = null);

(statearr_11500_11640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11499 === (2))){
var state_11498__$1 = state_11498;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11498__$1,(4),jobs);
} else {
if((state_val_11499 === (3))){
var inst_11496 = (state_11498[(2)]);
var state_11498__$1 = state_11498;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11498__$1,inst_11496);
} else {
if((state_val_11499 === (4))){
var inst_11488 = (state_11498[(2)]);
var inst_11489 = async.call(null,inst_11488);
var state_11498__$1 = state_11498;
if(cljs.core.truth_(inst_11489)){
var statearr_11501_11641 = state_11498__$1;
(statearr_11501_11641[(1)] = (5));

} else {
var statearr_11502_11642 = state_11498__$1;
(statearr_11502_11642[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11499 === (5))){
var state_11498__$1 = state_11498;
var statearr_11503_11643 = state_11498__$1;
(statearr_11503_11643[(2)] = null);

(statearr_11503_11643[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11499 === (6))){
var state_11498__$1 = state_11498;
var statearr_11504_11644 = state_11498__$1;
(statearr_11504_11644[(2)] = null);

(statearr_11504_11644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11499 === (7))){
var inst_11494 = (state_11498[(2)]);
var state_11498__$1 = state_11498;
var statearr_11505_11645 = state_11498__$1;
(statearr_11505_11645[(2)] = inst_11494);

(statearr_11505_11645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11627,c__11073__auto___11639,G__11458_11628,n__5571__auto___11626,jobs,results,process,async))
;
return ((function (__11627,switch__10961__auto__,c__11073__auto___11639,G__11458_11628,n__5571__auto___11626,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_11509 = [null,null,null,null,null,null,null];
(statearr_11509[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_11509[(1)] = (1));

return statearr_11509;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_11498){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11498);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11510){if((e11510 instanceof Object)){
var ex__10965__auto__ = e11510;
var statearr_11511_11646 = state_11498;
(statearr_11511_11646[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11498);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11510;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11647 = state_11498;
state_11498 = G__11647;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_11498){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_11498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(__11627,switch__10961__auto__,c__11073__auto___11639,G__11458_11628,n__5571__auto___11626,jobs,results,process,async))
})();
var state__11075__auto__ = (function (){var statearr_11512 = f__11074__auto__.call(null);
(statearr_11512[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___11639);

return statearr_11512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(__11627,c__11073__auto___11639,G__11458_11628,n__5571__auto___11626,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11648 = (__11627 + (1));
__11627 = G__11648;
continue;
} else {
}
break;
}

var c__11073__auto___11649 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___11649,jobs,results,process,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___11649,jobs,results,process,async){
return (function (state_11534){
var state_val_11535 = (state_11534[(1)]);
if((state_val_11535 === (1))){
var state_11534__$1 = state_11534;
var statearr_11536_11650 = state_11534__$1;
(statearr_11536_11650[(2)] = null);

(statearr_11536_11650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11535 === (2))){
var state_11534__$1 = state_11534;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11534__$1,(4),from);
} else {
if((state_val_11535 === (3))){
var inst_11532 = (state_11534[(2)]);
var state_11534__$1 = state_11534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11534__$1,inst_11532);
} else {
if((state_val_11535 === (4))){
var inst_11515 = (state_11534[(7)]);
var inst_11515__$1 = (state_11534[(2)]);
var inst_11516 = (inst_11515__$1 == null);
var state_11534__$1 = (function (){var statearr_11537 = state_11534;
(statearr_11537[(7)] = inst_11515__$1);

return statearr_11537;
})();
if(cljs.core.truth_(inst_11516)){
var statearr_11538_11651 = state_11534__$1;
(statearr_11538_11651[(1)] = (5));

} else {
var statearr_11539_11652 = state_11534__$1;
(statearr_11539_11652[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11535 === (5))){
var inst_11518 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11534__$1 = state_11534;
var statearr_11540_11653 = state_11534__$1;
(statearr_11540_11653[(2)] = inst_11518);

(statearr_11540_11653[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11535 === (6))){
var inst_11520 = (state_11534[(8)]);
var inst_11515 = (state_11534[(7)]);
var inst_11520__$1 = cljs.core.async.chan.call(null,(1));
var inst_11521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11522 = [inst_11515,inst_11520__$1];
var inst_11523 = (new cljs.core.PersistentVector(null,2,(5),inst_11521,inst_11522,null));
var state_11534__$1 = (function (){var statearr_11541 = state_11534;
(statearr_11541[(8)] = inst_11520__$1);

return statearr_11541;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11534__$1,(8),jobs,inst_11523);
} else {
if((state_val_11535 === (7))){
var inst_11530 = (state_11534[(2)]);
var state_11534__$1 = state_11534;
var statearr_11542_11654 = state_11534__$1;
(statearr_11542_11654[(2)] = inst_11530);

(statearr_11542_11654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11535 === (8))){
var inst_11520 = (state_11534[(8)]);
var inst_11525 = (state_11534[(2)]);
var state_11534__$1 = (function (){var statearr_11543 = state_11534;
(statearr_11543[(9)] = inst_11525);

return statearr_11543;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11534__$1,(9),results,inst_11520);
} else {
if((state_val_11535 === (9))){
var inst_11527 = (state_11534[(2)]);
var state_11534__$1 = (function (){var statearr_11544 = state_11534;
(statearr_11544[(10)] = inst_11527);

return statearr_11544;
})();
var statearr_11545_11655 = state_11534__$1;
(statearr_11545_11655[(2)] = null);

(statearr_11545_11655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___11649,jobs,results,process,async))
;
return ((function (switch__10961__auto__,c__11073__auto___11649,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_11549 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11549[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_11549[(1)] = (1));

return statearr_11549;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_11534){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11550){if((e11550 instanceof Object)){
var ex__10965__auto__ = e11550;
var statearr_11551_11656 = state_11534;
(statearr_11551_11656[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11534);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11550;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11657 = state_11534;
state_11534 = G__11657;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_11534){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_11534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___11649,jobs,results,process,async))
})();
var state__11075__auto__ = (function (){var statearr_11552 = f__11074__auto__.call(null);
(statearr_11552[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___11649);

return statearr_11552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___11649,jobs,results,process,async))
);


var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto__,jobs,results,process,async){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto__,jobs,results,process,async){
return (function (state_11590){
var state_val_11591 = (state_11590[(1)]);
if((state_val_11591 === (7))){
var inst_11586 = (state_11590[(2)]);
var state_11590__$1 = state_11590;
var statearr_11592_11658 = state_11590__$1;
(statearr_11592_11658[(2)] = inst_11586);

(statearr_11592_11658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (20))){
var state_11590__$1 = state_11590;
var statearr_11593_11659 = state_11590__$1;
(statearr_11593_11659[(2)] = null);

(statearr_11593_11659[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (1))){
var state_11590__$1 = state_11590;
var statearr_11594_11660 = state_11590__$1;
(statearr_11594_11660[(2)] = null);

(statearr_11594_11660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (4))){
var inst_11555 = (state_11590[(7)]);
var inst_11555__$1 = (state_11590[(2)]);
var inst_11556 = (inst_11555__$1 == null);
var state_11590__$1 = (function (){var statearr_11595 = state_11590;
(statearr_11595[(7)] = inst_11555__$1);

return statearr_11595;
})();
if(cljs.core.truth_(inst_11556)){
var statearr_11596_11661 = state_11590__$1;
(statearr_11596_11661[(1)] = (5));

} else {
var statearr_11597_11662 = state_11590__$1;
(statearr_11597_11662[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (15))){
var inst_11568 = (state_11590[(8)]);
var state_11590__$1 = state_11590;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11590__$1,(18),to,inst_11568);
} else {
if((state_val_11591 === (21))){
var inst_11581 = (state_11590[(2)]);
var state_11590__$1 = state_11590;
var statearr_11598_11663 = state_11590__$1;
(statearr_11598_11663[(2)] = inst_11581);

(statearr_11598_11663[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (13))){
var inst_11583 = (state_11590[(2)]);
var state_11590__$1 = (function (){var statearr_11599 = state_11590;
(statearr_11599[(9)] = inst_11583);

return statearr_11599;
})();
var statearr_11600_11664 = state_11590__$1;
(statearr_11600_11664[(2)] = null);

(statearr_11600_11664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (6))){
var inst_11555 = (state_11590[(7)]);
var state_11590__$1 = state_11590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11590__$1,(11),inst_11555);
} else {
if((state_val_11591 === (17))){
var inst_11576 = (state_11590[(2)]);
var state_11590__$1 = state_11590;
if(cljs.core.truth_(inst_11576)){
var statearr_11601_11665 = state_11590__$1;
(statearr_11601_11665[(1)] = (19));

} else {
var statearr_11602_11666 = state_11590__$1;
(statearr_11602_11666[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (3))){
var inst_11588 = (state_11590[(2)]);
var state_11590__$1 = state_11590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11590__$1,inst_11588);
} else {
if((state_val_11591 === (12))){
var inst_11565 = (state_11590[(10)]);
var state_11590__$1 = state_11590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11590__$1,(14),inst_11565);
} else {
if((state_val_11591 === (2))){
var state_11590__$1 = state_11590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11590__$1,(4),results);
} else {
if((state_val_11591 === (19))){
var state_11590__$1 = state_11590;
var statearr_11603_11667 = state_11590__$1;
(statearr_11603_11667[(2)] = null);

(statearr_11603_11667[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (11))){
var inst_11565 = (state_11590[(2)]);
var state_11590__$1 = (function (){var statearr_11604 = state_11590;
(statearr_11604[(10)] = inst_11565);

return statearr_11604;
})();
var statearr_11605_11668 = state_11590__$1;
(statearr_11605_11668[(2)] = null);

(statearr_11605_11668[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (9))){
var state_11590__$1 = state_11590;
var statearr_11606_11669 = state_11590__$1;
(statearr_11606_11669[(2)] = null);

(statearr_11606_11669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (5))){
var state_11590__$1 = state_11590;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11607_11670 = state_11590__$1;
(statearr_11607_11670[(1)] = (8));

} else {
var statearr_11608_11671 = state_11590__$1;
(statearr_11608_11671[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (14))){
var inst_11568 = (state_11590[(8)]);
var inst_11570 = (state_11590[(11)]);
var inst_11568__$1 = (state_11590[(2)]);
var inst_11569 = (inst_11568__$1 == null);
var inst_11570__$1 = cljs.core.not.call(null,inst_11569);
var state_11590__$1 = (function (){var statearr_11609 = state_11590;
(statearr_11609[(8)] = inst_11568__$1);

(statearr_11609[(11)] = inst_11570__$1);

return statearr_11609;
})();
if(inst_11570__$1){
var statearr_11610_11672 = state_11590__$1;
(statearr_11610_11672[(1)] = (15));

} else {
var statearr_11611_11673 = state_11590__$1;
(statearr_11611_11673[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (16))){
var inst_11570 = (state_11590[(11)]);
var state_11590__$1 = state_11590;
var statearr_11612_11674 = state_11590__$1;
(statearr_11612_11674[(2)] = inst_11570);

(statearr_11612_11674[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (10))){
var inst_11562 = (state_11590[(2)]);
var state_11590__$1 = state_11590;
var statearr_11613_11675 = state_11590__$1;
(statearr_11613_11675[(2)] = inst_11562);

(statearr_11613_11675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (18))){
var inst_11573 = (state_11590[(2)]);
var state_11590__$1 = state_11590;
var statearr_11614_11676 = state_11590__$1;
(statearr_11614_11676[(2)] = inst_11573);

(statearr_11614_11676[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11591 === (8))){
var inst_11559 = cljs.core.async.close_BANG_.call(null,to);
var state_11590__$1 = state_11590;
var statearr_11615_11677 = state_11590__$1;
(statearr_11615_11677[(2)] = inst_11559);

(statearr_11615_11677[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto__,jobs,results,process,async))
;
return ((function (switch__10961__auto__,c__11073__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_11619 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11619[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__);

(statearr_11619[(1)] = (1));

return statearr_11619;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1 = (function (state_11590){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11620){if((e11620 instanceof Object)){
var ex__10965__auto__ = e11620;
var statearr_11621_11678 = state_11590;
(statearr_11621_11678[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11590);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11620;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11679 = state_11590;
state_11590 = G__11679;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__ = function(state_11590){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1.call(this,state_11590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto__,jobs,results,process,async))
})();
var state__11075__auto__ = (function (){var statearr_11622 = f__11074__auto__.call(null);
(statearr_11622[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto__);

return statearr_11622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto__,jobs,results,process,async))
);

return c__11073__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11680 = [];
var len__5726__auto___11683 = arguments.length;
var i__5727__auto___11684 = (0);
while(true){
if((i__5727__auto___11684 < len__5726__auto___11683)){
args11680.push((arguments[i__5727__auto___11684]));

var G__11685 = (i__5727__auto___11684 + (1));
i__5727__auto___11684 = G__11685;
continue;
} else {
}
break;
}

var G__11682 = args11680.length;
switch (G__11682) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11680.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11687 = [];
var len__5726__auto___11690 = arguments.length;
var i__5727__auto___11691 = (0);
while(true){
if((i__5727__auto___11691 < len__5726__auto___11690)){
args11687.push((arguments[i__5727__auto___11691]));

var G__11692 = (i__5727__auto___11691 + (1));
i__5727__auto___11691 = G__11692;
continue;
} else {
}
break;
}

var G__11689 = args11687.length;
switch (G__11689) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11687.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11694 = [];
var len__5726__auto___11747 = arguments.length;
var i__5727__auto___11748 = (0);
while(true){
if((i__5727__auto___11748 < len__5726__auto___11747)){
args11694.push((arguments[i__5727__auto___11748]));

var G__11749 = (i__5727__auto___11748 + (1));
i__5727__auto___11748 = G__11749;
continue;
} else {
}
break;
}

var G__11696 = args11694.length;
switch (G__11696) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11694.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11073__auto___11751 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___11751,tc,fc){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___11751,tc,fc){
return (function (state_11722){
var state_val_11723 = (state_11722[(1)]);
if((state_val_11723 === (7))){
var inst_11718 = (state_11722[(2)]);
var state_11722__$1 = state_11722;
var statearr_11724_11752 = state_11722__$1;
(statearr_11724_11752[(2)] = inst_11718);

(statearr_11724_11752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (1))){
var state_11722__$1 = state_11722;
var statearr_11725_11753 = state_11722__$1;
(statearr_11725_11753[(2)] = null);

(statearr_11725_11753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (4))){
var inst_11699 = (state_11722[(7)]);
var inst_11699__$1 = (state_11722[(2)]);
var inst_11700 = (inst_11699__$1 == null);
var state_11722__$1 = (function (){var statearr_11726 = state_11722;
(statearr_11726[(7)] = inst_11699__$1);

return statearr_11726;
})();
if(cljs.core.truth_(inst_11700)){
var statearr_11727_11754 = state_11722__$1;
(statearr_11727_11754[(1)] = (5));

} else {
var statearr_11728_11755 = state_11722__$1;
(statearr_11728_11755[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (13))){
var state_11722__$1 = state_11722;
var statearr_11729_11756 = state_11722__$1;
(statearr_11729_11756[(2)] = null);

(statearr_11729_11756[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (6))){
var inst_11699 = (state_11722[(7)]);
var inst_11705 = p.call(null,inst_11699);
var state_11722__$1 = state_11722;
if(cljs.core.truth_(inst_11705)){
var statearr_11730_11757 = state_11722__$1;
(statearr_11730_11757[(1)] = (9));

} else {
var statearr_11731_11758 = state_11722__$1;
(statearr_11731_11758[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (3))){
var inst_11720 = (state_11722[(2)]);
var state_11722__$1 = state_11722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11722__$1,inst_11720);
} else {
if((state_val_11723 === (12))){
var state_11722__$1 = state_11722;
var statearr_11732_11759 = state_11722__$1;
(statearr_11732_11759[(2)] = null);

(statearr_11732_11759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (2))){
var state_11722__$1 = state_11722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11722__$1,(4),ch);
} else {
if((state_val_11723 === (11))){
var inst_11699 = (state_11722[(7)]);
var inst_11709 = (state_11722[(2)]);
var state_11722__$1 = state_11722;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11722__$1,(8),inst_11709,inst_11699);
} else {
if((state_val_11723 === (9))){
var state_11722__$1 = state_11722;
var statearr_11733_11760 = state_11722__$1;
(statearr_11733_11760[(2)] = tc);

(statearr_11733_11760[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (5))){
var inst_11702 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11703 = cljs.core.async.close_BANG_.call(null,fc);
var state_11722__$1 = (function (){var statearr_11734 = state_11722;
(statearr_11734[(8)] = inst_11702);

return statearr_11734;
})();
var statearr_11735_11761 = state_11722__$1;
(statearr_11735_11761[(2)] = inst_11703);

(statearr_11735_11761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (14))){
var inst_11716 = (state_11722[(2)]);
var state_11722__$1 = state_11722;
var statearr_11736_11762 = state_11722__$1;
(statearr_11736_11762[(2)] = inst_11716);

(statearr_11736_11762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (10))){
var state_11722__$1 = state_11722;
var statearr_11737_11763 = state_11722__$1;
(statearr_11737_11763[(2)] = fc);

(statearr_11737_11763[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11723 === (8))){
var inst_11711 = (state_11722[(2)]);
var state_11722__$1 = state_11722;
if(cljs.core.truth_(inst_11711)){
var statearr_11738_11764 = state_11722__$1;
(statearr_11738_11764[(1)] = (12));

} else {
var statearr_11739_11765 = state_11722__$1;
(statearr_11739_11765[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___11751,tc,fc))
;
return ((function (switch__10961__auto__,c__11073__auto___11751,tc,fc){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_11743 = [null,null,null,null,null,null,null,null,null];
(statearr_11743[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_11743[(1)] = (1));

return statearr_11743;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_11722){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11744){if((e11744 instanceof Object)){
var ex__10965__auto__ = e11744;
var statearr_11745_11766 = state_11722;
(statearr_11745_11766[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11722);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11744;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11767 = state_11722;
state_11722 = G__11767;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_11722){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_11722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___11751,tc,fc))
})();
var state__11075__auto__ = (function (){var statearr_11746 = f__11074__auto__.call(null);
(statearr_11746[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___11751);

return statearr_11746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___11751,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto__){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto__){
return (function (state_11831){
var state_val_11832 = (state_11831[(1)]);
if((state_val_11832 === (7))){
var inst_11827 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11833_11854 = state_11831__$1;
(statearr_11833_11854[(2)] = inst_11827);

(statearr_11833_11854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (1))){
var inst_11811 = init;
var state_11831__$1 = (function (){var statearr_11834 = state_11831;
(statearr_11834[(7)] = inst_11811);

return statearr_11834;
})();
var statearr_11835_11855 = state_11831__$1;
(statearr_11835_11855[(2)] = null);

(statearr_11835_11855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (4))){
var inst_11814 = (state_11831[(8)]);
var inst_11814__$1 = (state_11831[(2)]);
var inst_11815 = (inst_11814__$1 == null);
var state_11831__$1 = (function (){var statearr_11836 = state_11831;
(statearr_11836[(8)] = inst_11814__$1);

return statearr_11836;
})();
if(cljs.core.truth_(inst_11815)){
var statearr_11837_11856 = state_11831__$1;
(statearr_11837_11856[(1)] = (5));

} else {
var statearr_11838_11857 = state_11831__$1;
(statearr_11838_11857[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (6))){
var inst_11818 = (state_11831[(9)]);
var inst_11814 = (state_11831[(8)]);
var inst_11811 = (state_11831[(7)]);
var inst_11818__$1 = f.call(null,inst_11811,inst_11814);
var inst_11819 = cljs.core.reduced_QMARK_.call(null,inst_11818__$1);
var state_11831__$1 = (function (){var statearr_11839 = state_11831;
(statearr_11839[(9)] = inst_11818__$1);

return statearr_11839;
})();
if(inst_11819){
var statearr_11840_11858 = state_11831__$1;
(statearr_11840_11858[(1)] = (8));

} else {
var statearr_11841_11859 = state_11831__$1;
(statearr_11841_11859[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (3))){
var inst_11829 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11831__$1,inst_11829);
} else {
if((state_val_11832 === (2))){
var state_11831__$1 = state_11831;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11831__$1,(4),ch);
} else {
if((state_val_11832 === (9))){
var inst_11818 = (state_11831[(9)]);
var inst_11811 = inst_11818;
var state_11831__$1 = (function (){var statearr_11842 = state_11831;
(statearr_11842[(7)] = inst_11811);

return statearr_11842;
})();
var statearr_11843_11860 = state_11831__$1;
(statearr_11843_11860[(2)] = null);

(statearr_11843_11860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (5))){
var inst_11811 = (state_11831[(7)]);
var state_11831__$1 = state_11831;
var statearr_11844_11861 = state_11831__$1;
(statearr_11844_11861[(2)] = inst_11811);

(statearr_11844_11861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (10))){
var inst_11825 = (state_11831[(2)]);
var state_11831__$1 = state_11831;
var statearr_11845_11862 = state_11831__$1;
(statearr_11845_11862[(2)] = inst_11825);

(statearr_11845_11862[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11832 === (8))){
var inst_11818 = (state_11831[(9)]);
var inst_11821 = cljs.core.deref.call(null,inst_11818);
var state_11831__$1 = state_11831;
var statearr_11846_11863 = state_11831__$1;
(statearr_11846_11863[(2)] = inst_11821);

(statearr_11846_11863[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto__))
;
return ((function (switch__10961__auto__,c__11073__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10962__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10962__auto____0 = (function (){
var statearr_11850 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11850[(0)] = cljs$core$async$reduce_$_state_machine__10962__auto__);

(statearr_11850[(1)] = (1));

return statearr_11850;
});
var cljs$core$async$reduce_$_state_machine__10962__auto____1 = (function (state_11831){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11831);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11851){if((e11851 instanceof Object)){
var ex__10965__auto__ = e11851;
var statearr_11852_11864 = state_11831;
(statearr_11852_11864[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11831);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11851;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11865 = state_11831;
state_11831 = G__11865;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10962__auto__ = function(state_11831){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10962__auto____1.call(this,state_11831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10962__auto____0;
cljs$core$async$reduce_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10962__auto____1;
return cljs$core$async$reduce_$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto__))
})();
var state__11075__auto__ = (function (){var statearr_11853 = f__11074__auto__.call(null);
(statearr_11853[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto__);

return statearr_11853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto__))
);

return c__11073__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11866 = [];
var len__5726__auto___11918 = arguments.length;
var i__5727__auto___11919 = (0);
while(true){
if((i__5727__auto___11919 < len__5726__auto___11918)){
args11866.push((arguments[i__5727__auto___11919]));

var G__11920 = (i__5727__auto___11919 + (1));
i__5727__auto___11919 = G__11920;
continue;
} else {
}
break;
}

var G__11868 = args11866.length;
switch (G__11868) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11866.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto__){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto__){
return (function (state_11893){
var state_val_11894 = (state_11893[(1)]);
if((state_val_11894 === (7))){
var inst_11875 = (state_11893[(2)]);
var state_11893__$1 = state_11893;
var statearr_11895_11922 = state_11893__$1;
(statearr_11895_11922[(2)] = inst_11875);

(statearr_11895_11922[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (1))){
var inst_11869 = cljs.core.seq.call(null,coll);
var inst_11870 = inst_11869;
var state_11893__$1 = (function (){var statearr_11896 = state_11893;
(statearr_11896[(7)] = inst_11870);

return statearr_11896;
})();
var statearr_11897_11923 = state_11893__$1;
(statearr_11897_11923[(2)] = null);

(statearr_11897_11923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (4))){
var inst_11870 = (state_11893[(7)]);
var inst_11873 = cljs.core.first.call(null,inst_11870);
var state_11893__$1 = state_11893;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11893__$1,(7),ch,inst_11873);
} else {
if((state_val_11894 === (13))){
var inst_11887 = (state_11893[(2)]);
var state_11893__$1 = state_11893;
var statearr_11898_11924 = state_11893__$1;
(statearr_11898_11924[(2)] = inst_11887);

(statearr_11898_11924[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (6))){
var inst_11878 = (state_11893[(2)]);
var state_11893__$1 = state_11893;
if(cljs.core.truth_(inst_11878)){
var statearr_11899_11925 = state_11893__$1;
(statearr_11899_11925[(1)] = (8));

} else {
var statearr_11900_11926 = state_11893__$1;
(statearr_11900_11926[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (3))){
var inst_11891 = (state_11893[(2)]);
var state_11893__$1 = state_11893;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11893__$1,inst_11891);
} else {
if((state_val_11894 === (12))){
var state_11893__$1 = state_11893;
var statearr_11901_11927 = state_11893__$1;
(statearr_11901_11927[(2)] = null);

(statearr_11901_11927[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (2))){
var inst_11870 = (state_11893[(7)]);
var state_11893__$1 = state_11893;
if(cljs.core.truth_(inst_11870)){
var statearr_11902_11928 = state_11893__$1;
(statearr_11902_11928[(1)] = (4));

} else {
var statearr_11903_11929 = state_11893__$1;
(statearr_11903_11929[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (11))){
var inst_11884 = cljs.core.async.close_BANG_.call(null,ch);
var state_11893__$1 = state_11893;
var statearr_11904_11930 = state_11893__$1;
(statearr_11904_11930[(2)] = inst_11884);

(statearr_11904_11930[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (9))){
var state_11893__$1 = state_11893;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11905_11931 = state_11893__$1;
(statearr_11905_11931[(1)] = (11));

} else {
var statearr_11906_11932 = state_11893__$1;
(statearr_11906_11932[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (5))){
var inst_11870 = (state_11893[(7)]);
var state_11893__$1 = state_11893;
var statearr_11907_11933 = state_11893__$1;
(statearr_11907_11933[(2)] = inst_11870);

(statearr_11907_11933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (10))){
var inst_11889 = (state_11893[(2)]);
var state_11893__$1 = state_11893;
var statearr_11908_11934 = state_11893__$1;
(statearr_11908_11934[(2)] = inst_11889);

(statearr_11908_11934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11894 === (8))){
var inst_11870 = (state_11893[(7)]);
var inst_11880 = cljs.core.next.call(null,inst_11870);
var inst_11870__$1 = inst_11880;
var state_11893__$1 = (function (){var statearr_11909 = state_11893;
(statearr_11909[(7)] = inst_11870__$1);

return statearr_11909;
})();
var statearr_11910_11935 = state_11893__$1;
(statearr_11910_11935[(2)] = null);

(statearr_11910_11935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto__))
;
return ((function (switch__10961__auto__,c__11073__auto__){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_11914 = [null,null,null,null,null,null,null,null];
(statearr_11914[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_11914[(1)] = (1));

return statearr_11914;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_11893){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_11893);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e11915){if((e11915 instanceof Object)){
var ex__10965__auto__ = e11915;
var statearr_11916_11936 = state_11893;
(statearr_11916_11936[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11893);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11915;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11937 = state_11893;
state_11893 = G__11937;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_11893){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_11893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto__))
})();
var state__11075__auto__ = (function (){var statearr_11917 = f__11074__auto__.call(null);
(statearr_11917[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto__);

return statearr_11917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto__))
);

return c__11073__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12159 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12159 = (function (mult,ch,cs,meta12160){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12160 = meta12160;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12159.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12161,meta12160__$1){
var self__ = this;
var _12161__$1 = this;
return (new cljs.core.async.t_cljs$core$async12159(self__.mult,self__.ch,self__.cs,meta12160__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12159.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12161){
var self__ = this;
var _12161__$1 = this;
return self__.meta12160;
});})(cs))
;

cljs.core.async.t_cljs$core$async12159.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12159.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12159.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12159.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12159.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12159.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12159.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12160","meta12160",718611511,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12159.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12159.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12159";

cljs.core.async.t_cljs$core$async12159.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12159");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12159 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12159(mult__$1,ch__$1,cs__$1,meta12160){
return (new cljs.core.async.t_cljs$core$async12159(mult__$1,ch__$1,cs__$1,meta12160));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12159(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11073__auto___12380 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___12380,cs,m,dchan,dctr,done){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___12380,cs,m,dchan,dctr,done){
return (function (state_12292){
var state_val_12293 = (state_12292[(1)]);
if((state_val_12293 === (7))){
var inst_12288 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12294_12381 = state_12292__$1;
(statearr_12294_12381[(2)] = inst_12288);

(statearr_12294_12381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (20))){
var inst_12193 = (state_12292[(7)]);
var inst_12203 = cljs.core.first.call(null,inst_12193);
var inst_12204 = cljs.core.nth.call(null,inst_12203,(0),null);
var inst_12205 = cljs.core.nth.call(null,inst_12203,(1),null);
var state_12292__$1 = (function (){var statearr_12295 = state_12292;
(statearr_12295[(8)] = inst_12204);

return statearr_12295;
})();
if(cljs.core.truth_(inst_12205)){
var statearr_12296_12382 = state_12292__$1;
(statearr_12296_12382[(1)] = (22));

} else {
var statearr_12297_12383 = state_12292__$1;
(statearr_12297_12383[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (27))){
var inst_12240 = (state_12292[(9)]);
var inst_12233 = (state_12292[(10)]);
var inst_12164 = (state_12292[(11)]);
var inst_12235 = (state_12292[(12)]);
var inst_12240__$1 = cljs.core._nth.call(null,inst_12233,inst_12235);
var inst_12241 = cljs.core.async.put_BANG_.call(null,inst_12240__$1,inst_12164,done);
var state_12292__$1 = (function (){var statearr_12298 = state_12292;
(statearr_12298[(9)] = inst_12240__$1);

return statearr_12298;
})();
if(cljs.core.truth_(inst_12241)){
var statearr_12299_12384 = state_12292__$1;
(statearr_12299_12384[(1)] = (30));

} else {
var statearr_12300_12385 = state_12292__$1;
(statearr_12300_12385[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (1))){
var state_12292__$1 = state_12292;
var statearr_12301_12386 = state_12292__$1;
(statearr_12301_12386[(2)] = null);

(statearr_12301_12386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (24))){
var inst_12193 = (state_12292[(7)]);
var inst_12210 = (state_12292[(2)]);
var inst_12211 = cljs.core.next.call(null,inst_12193);
var inst_12173 = inst_12211;
var inst_12174 = null;
var inst_12175 = (0);
var inst_12176 = (0);
var state_12292__$1 = (function (){var statearr_12302 = state_12292;
(statearr_12302[(13)] = inst_12173);

(statearr_12302[(14)] = inst_12174);

(statearr_12302[(15)] = inst_12175);

(statearr_12302[(16)] = inst_12210);

(statearr_12302[(17)] = inst_12176);

return statearr_12302;
})();
var statearr_12303_12387 = state_12292__$1;
(statearr_12303_12387[(2)] = null);

(statearr_12303_12387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (39))){
var state_12292__$1 = state_12292;
var statearr_12307_12388 = state_12292__$1;
(statearr_12307_12388[(2)] = null);

(statearr_12307_12388[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (4))){
var inst_12164 = (state_12292[(11)]);
var inst_12164__$1 = (state_12292[(2)]);
var inst_12165 = (inst_12164__$1 == null);
var state_12292__$1 = (function (){var statearr_12308 = state_12292;
(statearr_12308[(11)] = inst_12164__$1);

return statearr_12308;
})();
if(cljs.core.truth_(inst_12165)){
var statearr_12309_12389 = state_12292__$1;
(statearr_12309_12389[(1)] = (5));

} else {
var statearr_12310_12390 = state_12292__$1;
(statearr_12310_12390[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (15))){
var inst_12173 = (state_12292[(13)]);
var inst_12174 = (state_12292[(14)]);
var inst_12175 = (state_12292[(15)]);
var inst_12176 = (state_12292[(17)]);
var inst_12189 = (state_12292[(2)]);
var inst_12190 = (inst_12176 + (1));
var tmp12304 = inst_12173;
var tmp12305 = inst_12174;
var tmp12306 = inst_12175;
var inst_12173__$1 = tmp12304;
var inst_12174__$1 = tmp12305;
var inst_12175__$1 = tmp12306;
var inst_12176__$1 = inst_12190;
var state_12292__$1 = (function (){var statearr_12311 = state_12292;
(statearr_12311[(13)] = inst_12173__$1);

(statearr_12311[(14)] = inst_12174__$1);

(statearr_12311[(15)] = inst_12175__$1);

(statearr_12311[(18)] = inst_12189);

(statearr_12311[(17)] = inst_12176__$1);

return statearr_12311;
})();
var statearr_12312_12391 = state_12292__$1;
(statearr_12312_12391[(2)] = null);

(statearr_12312_12391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (21))){
var inst_12214 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12316_12392 = state_12292__$1;
(statearr_12316_12392[(2)] = inst_12214);

(statearr_12316_12392[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (31))){
var inst_12240 = (state_12292[(9)]);
var inst_12244 = done.call(null,null);
var inst_12245 = cljs.core.async.untap_STAR_.call(null,m,inst_12240);
var state_12292__$1 = (function (){var statearr_12317 = state_12292;
(statearr_12317[(19)] = inst_12244);

return statearr_12317;
})();
var statearr_12318_12393 = state_12292__$1;
(statearr_12318_12393[(2)] = inst_12245);

(statearr_12318_12393[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (32))){
var inst_12233 = (state_12292[(10)]);
var inst_12235 = (state_12292[(12)]);
var inst_12232 = (state_12292[(20)]);
var inst_12234 = (state_12292[(21)]);
var inst_12247 = (state_12292[(2)]);
var inst_12248 = (inst_12235 + (1));
var tmp12313 = inst_12233;
var tmp12314 = inst_12232;
var tmp12315 = inst_12234;
var inst_12232__$1 = tmp12314;
var inst_12233__$1 = tmp12313;
var inst_12234__$1 = tmp12315;
var inst_12235__$1 = inst_12248;
var state_12292__$1 = (function (){var statearr_12319 = state_12292;
(statearr_12319[(22)] = inst_12247);

(statearr_12319[(10)] = inst_12233__$1);

(statearr_12319[(12)] = inst_12235__$1);

(statearr_12319[(20)] = inst_12232__$1);

(statearr_12319[(21)] = inst_12234__$1);

return statearr_12319;
})();
var statearr_12320_12394 = state_12292__$1;
(statearr_12320_12394[(2)] = null);

(statearr_12320_12394[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (40))){
var inst_12260 = (state_12292[(23)]);
var inst_12264 = done.call(null,null);
var inst_12265 = cljs.core.async.untap_STAR_.call(null,m,inst_12260);
var state_12292__$1 = (function (){var statearr_12321 = state_12292;
(statearr_12321[(24)] = inst_12264);

return statearr_12321;
})();
var statearr_12322_12395 = state_12292__$1;
(statearr_12322_12395[(2)] = inst_12265);

(statearr_12322_12395[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (33))){
var inst_12251 = (state_12292[(25)]);
var inst_12253 = cljs.core.chunked_seq_QMARK_.call(null,inst_12251);
var state_12292__$1 = state_12292;
if(inst_12253){
var statearr_12323_12396 = state_12292__$1;
(statearr_12323_12396[(1)] = (36));

} else {
var statearr_12324_12397 = state_12292__$1;
(statearr_12324_12397[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (13))){
var inst_12183 = (state_12292[(26)]);
var inst_12186 = cljs.core.async.close_BANG_.call(null,inst_12183);
var state_12292__$1 = state_12292;
var statearr_12325_12398 = state_12292__$1;
(statearr_12325_12398[(2)] = inst_12186);

(statearr_12325_12398[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (22))){
var inst_12204 = (state_12292[(8)]);
var inst_12207 = cljs.core.async.close_BANG_.call(null,inst_12204);
var state_12292__$1 = state_12292;
var statearr_12326_12399 = state_12292__$1;
(statearr_12326_12399[(2)] = inst_12207);

(statearr_12326_12399[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (36))){
var inst_12251 = (state_12292[(25)]);
var inst_12255 = cljs.core.chunk_first.call(null,inst_12251);
var inst_12256 = cljs.core.chunk_rest.call(null,inst_12251);
var inst_12257 = cljs.core.count.call(null,inst_12255);
var inst_12232 = inst_12256;
var inst_12233 = inst_12255;
var inst_12234 = inst_12257;
var inst_12235 = (0);
var state_12292__$1 = (function (){var statearr_12327 = state_12292;
(statearr_12327[(10)] = inst_12233);

(statearr_12327[(12)] = inst_12235);

(statearr_12327[(20)] = inst_12232);

(statearr_12327[(21)] = inst_12234);

return statearr_12327;
})();
var statearr_12328_12400 = state_12292__$1;
(statearr_12328_12400[(2)] = null);

(statearr_12328_12400[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (41))){
var inst_12251 = (state_12292[(25)]);
var inst_12267 = (state_12292[(2)]);
var inst_12268 = cljs.core.next.call(null,inst_12251);
var inst_12232 = inst_12268;
var inst_12233 = null;
var inst_12234 = (0);
var inst_12235 = (0);
var state_12292__$1 = (function (){var statearr_12329 = state_12292;
(statearr_12329[(10)] = inst_12233);

(statearr_12329[(27)] = inst_12267);

(statearr_12329[(12)] = inst_12235);

(statearr_12329[(20)] = inst_12232);

(statearr_12329[(21)] = inst_12234);

return statearr_12329;
})();
var statearr_12330_12401 = state_12292__$1;
(statearr_12330_12401[(2)] = null);

(statearr_12330_12401[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (43))){
var state_12292__$1 = state_12292;
var statearr_12331_12402 = state_12292__$1;
(statearr_12331_12402[(2)] = null);

(statearr_12331_12402[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (29))){
var inst_12276 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12332_12403 = state_12292__$1;
(statearr_12332_12403[(2)] = inst_12276);

(statearr_12332_12403[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (44))){
var inst_12285 = (state_12292[(2)]);
var state_12292__$1 = (function (){var statearr_12333 = state_12292;
(statearr_12333[(28)] = inst_12285);

return statearr_12333;
})();
var statearr_12334_12404 = state_12292__$1;
(statearr_12334_12404[(2)] = null);

(statearr_12334_12404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (6))){
var inst_12224 = (state_12292[(29)]);
var inst_12223 = cljs.core.deref.call(null,cs);
var inst_12224__$1 = cljs.core.keys.call(null,inst_12223);
var inst_12225 = cljs.core.count.call(null,inst_12224__$1);
var inst_12226 = cljs.core.reset_BANG_.call(null,dctr,inst_12225);
var inst_12231 = cljs.core.seq.call(null,inst_12224__$1);
var inst_12232 = inst_12231;
var inst_12233 = null;
var inst_12234 = (0);
var inst_12235 = (0);
var state_12292__$1 = (function (){var statearr_12335 = state_12292;
(statearr_12335[(10)] = inst_12233);

(statearr_12335[(30)] = inst_12226);

(statearr_12335[(29)] = inst_12224__$1);

(statearr_12335[(12)] = inst_12235);

(statearr_12335[(20)] = inst_12232);

(statearr_12335[(21)] = inst_12234);

return statearr_12335;
})();
var statearr_12336_12405 = state_12292__$1;
(statearr_12336_12405[(2)] = null);

(statearr_12336_12405[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (28))){
var inst_12251 = (state_12292[(25)]);
var inst_12232 = (state_12292[(20)]);
var inst_12251__$1 = cljs.core.seq.call(null,inst_12232);
var state_12292__$1 = (function (){var statearr_12337 = state_12292;
(statearr_12337[(25)] = inst_12251__$1);

return statearr_12337;
})();
if(inst_12251__$1){
var statearr_12338_12406 = state_12292__$1;
(statearr_12338_12406[(1)] = (33));

} else {
var statearr_12339_12407 = state_12292__$1;
(statearr_12339_12407[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (25))){
var inst_12235 = (state_12292[(12)]);
var inst_12234 = (state_12292[(21)]);
var inst_12237 = (inst_12235 < inst_12234);
var inst_12238 = inst_12237;
var state_12292__$1 = state_12292;
if(cljs.core.truth_(inst_12238)){
var statearr_12340_12408 = state_12292__$1;
(statearr_12340_12408[(1)] = (27));

} else {
var statearr_12341_12409 = state_12292__$1;
(statearr_12341_12409[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (34))){
var state_12292__$1 = state_12292;
var statearr_12342_12410 = state_12292__$1;
(statearr_12342_12410[(2)] = null);

(statearr_12342_12410[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (17))){
var state_12292__$1 = state_12292;
var statearr_12343_12411 = state_12292__$1;
(statearr_12343_12411[(2)] = null);

(statearr_12343_12411[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (3))){
var inst_12290 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12292__$1,inst_12290);
} else {
if((state_val_12293 === (12))){
var inst_12219 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12344_12412 = state_12292__$1;
(statearr_12344_12412[(2)] = inst_12219);

(statearr_12344_12412[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (2))){
var state_12292__$1 = state_12292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12292__$1,(4),ch);
} else {
if((state_val_12293 === (23))){
var state_12292__$1 = state_12292;
var statearr_12345_12413 = state_12292__$1;
(statearr_12345_12413[(2)] = null);

(statearr_12345_12413[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (35))){
var inst_12274 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12346_12414 = state_12292__$1;
(statearr_12346_12414[(2)] = inst_12274);

(statearr_12346_12414[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (19))){
var inst_12193 = (state_12292[(7)]);
var inst_12197 = cljs.core.chunk_first.call(null,inst_12193);
var inst_12198 = cljs.core.chunk_rest.call(null,inst_12193);
var inst_12199 = cljs.core.count.call(null,inst_12197);
var inst_12173 = inst_12198;
var inst_12174 = inst_12197;
var inst_12175 = inst_12199;
var inst_12176 = (0);
var state_12292__$1 = (function (){var statearr_12347 = state_12292;
(statearr_12347[(13)] = inst_12173);

(statearr_12347[(14)] = inst_12174);

(statearr_12347[(15)] = inst_12175);

(statearr_12347[(17)] = inst_12176);

return statearr_12347;
})();
var statearr_12348_12415 = state_12292__$1;
(statearr_12348_12415[(2)] = null);

(statearr_12348_12415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (11))){
var inst_12173 = (state_12292[(13)]);
var inst_12193 = (state_12292[(7)]);
var inst_12193__$1 = cljs.core.seq.call(null,inst_12173);
var state_12292__$1 = (function (){var statearr_12349 = state_12292;
(statearr_12349[(7)] = inst_12193__$1);

return statearr_12349;
})();
if(inst_12193__$1){
var statearr_12350_12416 = state_12292__$1;
(statearr_12350_12416[(1)] = (16));

} else {
var statearr_12351_12417 = state_12292__$1;
(statearr_12351_12417[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (9))){
var inst_12221 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12352_12418 = state_12292__$1;
(statearr_12352_12418[(2)] = inst_12221);

(statearr_12352_12418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (5))){
var inst_12171 = cljs.core.deref.call(null,cs);
var inst_12172 = cljs.core.seq.call(null,inst_12171);
var inst_12173 = inst_12172;
var inst_12174 = null;
var inst_12175 = (0);
var inst_12176 = (0);
var state_12292__$1 = (function (){var statearr_12353 = state_12292;
(statearr_12353[(13)] = inst_12173);

(statearr_12353[(14)] = inst_12174);

(statearr_12353[(15)] = inst_12175);

(statearr_12353[(17)] = inst_12176);

return statearr_12353;
})();
var statearr_12354_12419 = state_12292__$1;
(statearr_12354_12419[(2)] = null);

(statearr_12354_12419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (14))){
var state_12292__$1 = state_12292;
var statearr_12355_12420 = state_12292__$1;
(statearr_12355_12420[(2)] = null);

(statearr_12355_12420[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (45))){
var inst_12282 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12356_12421 = state_12292__$1;
(statearr_12356_12421[(2)] = inst_12282);

(statearr_12356_12421[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (26))){
var inst_12224 = (state_12292[(29)]);
var inst_12278 = (state_12292[(2)]);
var inst_12279 = cljs.core.seq.call(null,inst_12224);
var state_12292__$1 = (function (){var statearr_12357 = state_12292;
(statearr_12357[(31)] = inst_12278);

return statearr_12357;
})();
if(inst_12279){
var statearr_12358_12422 = state_12292__$1;
(statearr_12358_12422[(1)] = (42));

} else {
var statearr_12359_12423 = state_12292__$1;
(statearr_12359_12423[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (16))){
var inst_12193 = (state_12292[(7)]);
var inst_12195 = cljs.core.chunked_seq_QMARK_.call(null,inst_12193);
var state_12292__$1 = state_12292;
if(inst_12195){
var statearr_12360_12424 = state_12292__$1;
(statearr_12360_12424[(1)] = (19));

} else {
var statearr_12361_12425 = state_12292__$1;
(statearr_12361_12425[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (38))){
var inst_12271 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12362_12426 = state_12292__$1;
(statearr_12362_12426[(2)] = inst_12271);

(statearr_12362_12426[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (30))){
var state_12292__$1 = state_12292;
var statearr_12363_12427 = state_12292__$1;
(statearr_12363_12427[(2)] = null);

(statearr_12363_12427[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (10))){
var inst_12174 = (state_12292[(14)]);
var inst_12176 = (state_12292[(17)]);
var inst_12182 = cljs.core._nth.call(null,inst_12174,inst_12176);
var inst_12183 = cljs.core.nth.call(null,inst_12182,(0),null);
var inst_12184 = cljs.core.nth.call(null,inst_12182,(1),null);
var state_12292__$1 = (function (){var statearr_12364 = state_12292;
(statearr_12364[(26)] = inst_12183);

return statearr_12364;
})();
if(cljs.core.truth_(inst_12184)){
var statearr_12365_12428 = state_12292__$1;
(statearr_12365_12428[(1)] = (13));

} else {
var statearr_12366_12429 = state_12292__$1;
(statearr_12366_12429[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (18))){
var inst_12217 = (state_12292[(2)]);
var state_12292__$1 = state_12292;
var statearr_12367_12430 = state_12292__$1;
(statearr_12367_12430[(2)] = inst_12217);

(statearr_12367_12430[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (42))){
var state_12292__$1 = state_12292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12292__$1,(45),dchan);
} else {
if((state_val_12293 === (37))){
var inst_12251 = (state_12292[(25)]);
var inst_12164 = (state_12292[(11)]);
var inst_12260 = (state_12292[(23)]);
var inst_12260__$1 = cljs.core.first.call(null,inst_12251);
var inst_12261 = cljs.core.async.put_BANG_.call(null,inst_12260__$1,inst_12164,done);
var state_12292__$1 = (function (){var statearr_12368 = state_12292;
(statearr_12368[(23)] = inst_12260__$1);

return statearr_12368;
})();
if(cljs.core.truth_(inst_12261)){
var statearr_12369_12431 = state_12292__$1;
(statearr_12369_12431[(1)] = (39));

} else {
var statearr_12370_12432 = state_12292__$1;
(statearr_12370_12432[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12293 === (8))){
var inst_12175 = (state_12292[(15)]);
var inst_12176 = (state_12292[(17)]);
var inst_12178 = (inst_12176 < inst_12175);
var inst_12179 = inst_12178;
var state_12292__$1 = state_12292;
if(cljs.core.truth_(inst_12179)){
var statearr_12371_12433 = state_12292__$1;
(statearr_12371_12433[(1)] = (10));

} else {
var statearr_12372_12434 = state_12292__$1;
(statearr_12372_12434[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___12380,cs,m,dchan,dctr,done))
;
return ((function (switch__10961__auto__,c__11073__auto___12380,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10962__auto__ = null;
var cljs$core$async$mult_$_state_machine__10962__auto____0 = (function (){
var statearr_12376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12376[(0)] = cljs$core$async$mult_$_state_machine__10962__auto__);

(statearr_12376[(1)] = (1));

return statearr_12376;
});
var cljs$core$async$mult_$_state_machine__10962__auto____1 = (function (state_12292){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_12292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e12377){if((e12377 instanceof Object)){
var ex__10965__auto__ = e12377;
var statearr_12378_12435 = state_12292;
(statearr_12378_12435[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12292);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12377;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12436 = state_12292;
state_12292 = G__12436;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10962__auto__ = function(state_12292){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10962__auto____1.call(this,state_12292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10962__auto____0;
cljs$core$async$mult_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10962__auto____1;
return cljs$core$async$mult_$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___12380,cs,m,dchan,dctr,done))
})();
var state__11075__auto__ = (function (){var statearr_12379 = f__11074__auto__.call(null);
(statearr_12379[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___12380);

return statearr_12379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___12380,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args12437 = [];
var len__5726__auto___12440 = arguments.length;
var i__5727__auto___12441 = (0);
while(true){
if((i__5727__auto___12441 < len__5726__auto___12440)){
args12437.push((arguments[i__5727__auto___12441]));

var G__12442 = (i__5727__auto___12441 + (1));
i__5727__auto___12441 = G__12442;
continue;
} else {
}
break;
}

var G__12439 = args12437.length;
switch (G__12439) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12437.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___12454 = arguments.length;
var i__5727__auto___12455 = (0);
while(true){
if((i__5727__auto___12455 < len__5726__auto___12454)){
args__5733__auto__.push((arguments[i__5727__auto___12455]));

var G__12456 = (i__5727__auto___12455 + (1));
i__5727__auto___12455 = G__12456;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12448){
var map__12449 = p__12448;
var map__12449__$1 = ((((!((map__12449 == null)))?((((map__12449.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12449.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12449):map__12449);
var opts = map__12449__$1;
var statearr_12451_12457 = state;
(statearr_12451_12457[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__12449,map__12449__$1,opts){
return (function (val){
var statearr_12452_12458 = state;
(statearr_12452_12458[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12449,map__12449__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_12453_12459 = state;
(statearr_12453_12459[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12444){
var G__12445 = cljs.core.first.call(null,seq12444);
var seq12444__$1 = cljs.core.next.call(null,seq12444);
var G__12446 = cljs.core.first.call(null,seq12444__$1);
var seq12444__$2 = cljs.core.next.call(null,seq12444__$1);
var G__12447 = cljs.core.first.call(null,seq12444__$2);
var seq12444__$3 = cljs.core.next.call(null,seq12444__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12445,G__12446,G__12447,seq12444__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12623 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12623 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12624){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12624 = meta12624;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12625,meta12624__$1){
var self__ = this;
var _12625__$1 = this;
return (new cljs.core.async.t_cljs$core$async12623(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12624__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12625){
var self__ = this;
var _12625__$1 = this;
return self__.meta12624;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12624","meta12624",1487564665,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12623.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12623.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12623";

cljs.core.async.t_cljs$core$async12623.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12623");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12623 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12623(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12624){
return (new cljs.core.async.t_cljs$core$async12623(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12624));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12623(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11073__auto___12786 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___12786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___12786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12723){
var state_val_12724 = (state_12723[(1)]);
if((state_val_12724 === (7))){
var inst_12641 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
var statearr_12725_12787 = state_12723__$1;
(statearr_12725_12787[(2)] = inst_12641);

(statearr_12725_12787[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (20))){
var inst_12653 = (state_12723[(7)]);
var state_12723__$1 = state_12723;
var statearr_12726_12788 = state_12723__$1;
(statearr_12726_12788[(2)] = inst_12653);

(statearr_12726_12788[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (27))){
var state_12723__$1 = state_12723;
var statearr_12727_12789 = state_12723__$1;
(statearr_12727_12789[(2)] = null);

(statearr_12727_12789[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (1))){
var inst_12629 = (state_12723[(8)]);
var inst_12629__$1 = calc_state.call(null);
var inst_12631 = (inst_12629__$1 == null);
var inst_12632 = cljs.core.not.call(null,inst_12631);
var state_12723__$1 = (function (){var statearr_12728 = state_12723;
(statearr_12728[(8)] = inst_12629__$1);

return statearr_12728;
})();
if(inst_12632){
var statearr_12729_12790 = state_12723__$1;
(statearr_12729_12790[(1)] = (2));

} else {
var statearr_12730_12791 = state_12723__$1;
(statearr_12730_12791[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (24))){
var inst_12683 = (state_12723[(9)]);
var inst_12676 = (state_12723[(10)]);
var inst_12697 = (state_12723[(11)]);
var inst_12697__$1 = inst_12676.call(null,inst_12683);
var state_12723__$1 = (function (){var statearr_12731 = state_12723;
(statearr_12731[(11)] = inst_12697__$1);

return statearr_12731;
})();
if(cljs.core.truth_(inst_12697__$1)){
var statearr_12732_12792 = state_12723__$1;
(statearr_12732_12792[(1)] = (29));

} else {
var statearr_12733_12793 = state_12723__$1;
(statearr_12733_12793[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (4))){
var inst_12644 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
if(cljs.core.truth_(inst_12644)){
var statearr_12734_12794 = state_12723__$1;
(statearr_12734_12794[(1)] = (8));

} else {
var statearr_12735_12795 = state_12723__$1;
(statearr_12735_12795[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (15))){
var inst_12670 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
if(cljs.core.truth_(inst_12670)){
var statearr_12736_12796 = state_12723__$1;
(statearr_12736_12796[(1)] = (19));

} else {
var statearr_12737_12797 = state_12723__$1;
(statearr_12737_12797[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (21))){
var inst_12675 = (state_12723[(12)]);
var inst_12675__$1 = (state_12723[(2)]);
var inst_12676 = cljs.core.get.call(null,inst_12675__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12677 = cljs.core.get.call(null,inst_12675__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12678 = cljs.core.get.call(null,inst_12675__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12723__$1 = (function (){var statearr_12738 = state_12723;
(statearr_12738[(10)] = inst_12676);

(statearr_12738[(12)] = inst_12675__$1);

(statearr_12738[(13)] = inst_12677);

return statearr_12738;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12723__$1,(22),inst_12678);
} else {
if((state_val_12724 === (31))){
var inst_12705 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
if(cljs.core.truth_(inst_12705)){
var statearr_12739_12798 = state_12723__$1;
(statearr_12739_12798[(1)] = (32));

} else {
var statearr_12740_12799 = state_12723__$1;
(statearr_12740_12799[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (32))){
var inst_12682 = (state_12723[(14)]);
var state_12723__$1 = state_12723;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12723__$1,(35),out,inst_12682);
} else {
if((state_val_12724 === (33))){
var inst_12675 = (state_12723[(12)]);
var inst_12653 = inst_12675;
var state_12723__$1 = (function (){var statearr_12741 = state_12723;
(statearr_12741[(7)] = inst_12653);

return statearr_12741;
})();
var statearr_12742_12800 = state_12723__$1;
(statearr_12742_12800[(2)] = null);

(statearr_12742_12800[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (13))){
var inst_12653 = (state_12723[(7)]);
var inst_12660 = inst_12653.cljs$lang$protocol_mask$partition0$;
var inst_12661 = (inst_12660 & (64));
var inst_12662 = inst_12653.cljs$core$ISeq$;
var inst_12663 = (inst_12661) || (inst_12662);
var state_12723__$1 = state_12723;
if(cljs.core.truth_(inst_12663)){
var statearr_12743_12801 = state_12723__$1;
(statearr_12743_12801[(1)] = (16));

} else {
var statearr_12744_12802 = state_12723__$1;
(statearr_12744_12802[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (22))){
var inst_12683 = (state_12723[(9)]);
var inst_12682 = (state_12723[(14)]);
var inst_12681 = (state_12723[(2)]);
var inst_12682__$1 = cljs.core.nth.call(null,inst_12681,(0),null);
var inst_12683__$1 = cljs.core.nth.call(null,inst_12681,(1),null);
var inst_12684 = (inst_12682__$1 == null);
var inst_12685 = cljs.core._EQ_.call(null,inst_12683__$1,change);
var inst_12686 = (inst_12684) || (inst_12685);
var state_12723__$1 = (function (){var statearr_12745 = state_12723;
(statearr_12745[(9)] = inst_12683__$1);

(statearr_12745[(14)] = inst_12682__$1);

return statearr_12745;
})();
if(cljs.core.truth_(inst_12686)){
var statearr_12746_12803 = state_12723__$1;
(statearr_12746_12803[(1)] = (23));

} else {
var statearr_12747_12804 = state_12723__$1;
(statearr_12747_12804[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (36))){
var inst_12675 = (state_12723[(12)]);
var inst_12653 = inst_12675;
var state_12723__$1 = (function (){var statearr_12748 = state_12723;
(statearr_12748[(7)] = inst_12653);

return statearr_12748;
})();
var statearr_12749_12805 = state_12723__$1;
(statearr_12749_12805[(2)] = null);

(statearr_12749_12805[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (29))){
var inst_12697 = (state_12723[(11)]);
var state_12723__$1 = state_12723;
var statearr_12750_12806 = state_12723__$1;
(statearr_12750_12806[(2)] = inst_12697);

(statearr_12750_12806[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (6))){
var state_12723__$1 = state_12723;
var statearr_12751_12807 = state_12723__$1;
(statearr_12751_12807[(2)] = false);

(statearr_12751_12807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (28))){
var inst_12693 = (state_12723[(2)]);
var inst_12694 = calc_state.call(null);
var inst_12653 = inst_12694;
var state_12723__$1 = (function (){var statearr_12752 = state_12723;
(statearr_12752[(15)] = inst_12693);

(statearr_12752[(7)] = inst_12653);

return statearr_12752;
})();
var statearr_12753_12808 = state_12723__$1;
(statearr_12753_12808[(2)] = null);

(statearr_12753_12808[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (25))){
var inst_12719 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
var statearr_12754_12809 = state_12723__$1;
(statearr_12754_12809[(2)] = inst_12719);

(statearr_12754_12809[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (34))){
var inst_12717 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
var statearr_12755_12810 = state_12723__$1;
(statearr_12755_12810[(2)] = inst_12717);

(statearr_12755_12810[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (17))){
var state_12723__$1 = state_12723;
var statearr_12756_12811 = state_12723__$1;
(statearr_12756_12811[(2)] = false);

(statearr_12756_12811[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (3))){
var state_12723__$1 = state_12723;
var statearr_12757_12812 = state_12723__$1;
(statearr_12757_12812[(2)] = false);

(statearr_12757_12812[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (12))){
var inst_12721 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12723__$1,inst_12721);
} else {
if((state_val_12724 === (2))){
var inst_12629 = (state_12723[(8)]);
var inst_12634 = inst_12629.cljs$lang$protocol_mask$partition0$;
var inst_12635 = (inst_12634 & (64));
var inst_12636 = inst_12629.cljs$core$ISeq$;
var inst_12637 = (inst_12635) || (inst_12636);
var state_12723__$1 = state_12723;
if(cljs.core.truth_(inst_12637)){
var statearr_12758_12813 = state_12723__$1;
(statearr_12758_12813[(1)] = (5));

} else {
var statearr_12759_12814 = state_12723__$1;
(statearr_12759_12814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (23))){
var inst_12682 = (state_12723[(14)]);
var inst_12688 = (inst_12682 == null);
var state_12723__$1 = state_12723;
if(cljs.core.truth_(inst_12688)){
var statearr_12760_12815 = state_12723__$1;
(statearr_12760_12815[(1)] = (26));

} else {
var statearr_12761_12816 = state_12723__$1;
(statearr_12761_12816[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (35))){
var inst_12708 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
if(cljs.core.truth_(inst_12708)){
var statearr_12762_12817 = state_12723__$1;
(statearr_12762_12817[(1)] = (36));

} else {
var statearr_12763_12818 = state_12723__$1;
(statearr_12763_12818[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (19))){
var inst_12653 = (state_12723[(7)]);
var inst_12672 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12653);
var state_12723__$1 = state_12723;
var statearr_12764_12819 = state_12723__$1;
(statearr_12764_12819[(2)] = inst_12672);

(statearr_12764_12819[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (11))){
var inst_12653 = (state_12723[(7)]);
var inst_12657 = (inst_12653 == null);
var inst_12658 = cljs.core.not.call(null,inst_12657);
var state_12723__$1 = state_12723;
if(inst_12658){
var statearr_12765_12820 = state_12723__$1;
(statearr_12765_12820[(1)] = (13));

} else {
var statearr_12766_12821 = state_12723__$1;
(statearr_12766_12821[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (9))){
var inst_12629 = (state_12723[(8)]);
var state_12723__$1 = state_12723;
var statearr_12767_12822 = state_12723__$1;
(statearr_12767_12822[(2)] = inst_12629);

(statearr_12767_12822[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (5))){
var state_12723__$1 = state_12723;
var statearr_12768_12823 = state_12723__$1;
(statearr_12768_12823[(2)] = true);

(statearr_12768_12823[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (14))){
var state_12723__$1 = state_12723;
var statearr_12769_12824 = state_12723__$1;
(statearr_12769_12824[(2)] = false);

(statearr_12769_12824[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (26))){
var inst_12683 = (state_12723[(9)]);
var inst_12690 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12683);
var state_12723__$1 = state_12723;
var statearr_12770_12825 = state_12723__$1;
(statearr_12770_12825[(2)] = inst_12690);

(statearr_12770_12825[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (16))){
var state_12723__$1 = state_12723;
var statearr_12771_12826 = state_12723__$1;
(statearr_12771_12826[(2)] = true);

(statearr_12771_12826[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (38))){
var inst_12713 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
var statearr_12772_12827 = state_12723__$1;
(statearr_12772_12827[(2)] = inst_12713);

(statearr_12772_12827[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (30))){
var inst_12683 = (state_12723[(9)]);
var inst_12676 = (state_12723[(10)]);
var inst_12677 = (state_12723[(13)]);
var inst_12700 = cljs.core.empty_QMARK_.call(null,inst_12676);
var inst_12701 = inst_12677.call(null,inst_12683);
var inst_12702 = cljs.core.not.call(null,inst_12701);
var inst_12703 = (inst_12700) && (inst_12702);
var state_12723__$1 = state_12723;
var statearr_12773_12828 = state_12723__$1;
(statearr_12773_12828[(2)] = inst_12703);

(statearr_12773_12828[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (10))){
var inst_12629 = (state_12723[(8)]);
var inst_12649 = (state_12723[(2)]);
var inst_12650 = cljs.core.get.call(null,inst_12649,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12651 = cljs.core.get.call(null,inst_12649,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12652 = cljs.core.get.call(null,inst_12649,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12653 = inst_12629;
var state_12723__$1 = (function (){var statearr_12774 = state_12723;
(statearr_12774[(16)] = inst_12651);

(statearr_12774[(17)] = inst_12650);

(statearr_12774[(18)] = inst_12652);

(statearr_12774[(7)] = inst_12653);

return statearr_12774;
})();
var statearr_12775_12829 = state_12723__$1;
(statearr_12775_12829[(2)] = null);

(statearr_12775_12829[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (18))){
var inst_12667 = (state_12723[(2)]);
var state_12723__$1 = state_12723;
var statearr_12776_12830 = state_12723__$1;
(statearr_12776_12830[(2)] = inst_12667);

(statearr_12776_12830[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (37))){
var state_12723__$1 = state_12723;
var statearr_12777_12831 = state_12723__$1;
(statearr_12777_12831[(2)] = null);

(statearr_12777_12831[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12724 === (8))){
var inst_12629 = (state_12723[(8)]);
var inst_12646 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12629);
var state_12723__$1 = state_12723;
var statearr_12778_12832 = state_12723__$1;
(statearr_12778_12832[(2)] = inst_12646);

(statearr_12778_12832[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___12786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10961__auto__,c__11073__auto___12786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10962__auto__ = null;
var cljs$core$async$mix_$_state_machine__10962__auto____0 = (function (){
var statearr_12782 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12782[(0)] = cljs$core$async$mix_$_state_machine__10962__auto__);

(statearr_12782[(1)] = (1));

return statearr_12782;
});
var cljs$core$async$mix_$_state_machine__10962__auto____1 = (function (state_12723){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_12723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e12783){if((e12783 instanceof Object)){
var ex__10965__auto__ = e12783;
var statearr_12784_12833 = state_12723;
(statearr_12784_12833[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12723);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12783;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12834 = state_12723;
state_12723 = G__12834;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10962__auto__ = function(state_12723){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10962__auto____1.call(this,state_12723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10962__auto____0;
cljs$core$async$mix_$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10962__auto____1;
return cljs$core$async$mix_$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___12786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11075__auto__ = (function (){var statearr_12785 = f__11074__auto__.call(null);
(statearr_12785[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___12786);

return statearr_12785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___12786,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12835 = [];
var len__5726__auto___12838 = arguments.length;
var i__5727__auto___12839 = (0);
while(true){
if((i__5727__auto___12839 < len__5726__auto___12838)){
args12835.push((arguments[i__5727__auto___12839]));

var G__12840 = (i__5727__auto___12839 + (1));
i__5727__auto___12839 = G__12840;
continue;
} else {
}
break;
}

var G__12837 = args12835.length;
switch (G__12837) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12835.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12843 = [];
var len__5726__auto___12968 = arguments.length;
var i__5727__auto___12969 = (0);
while(true){
if((i__5727__auto___12969 < len__5726__auto___12968)){
args12843.push((arguments[i__5727__auto___12969]));

var G__12970 = (i__5727__auto___12969 + (1));
i__5727__auto___12969 = G__12970;
continue;
} else {
}
break;
}

var G__12845 = args12843.length;
switch (G__12845) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12843.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__12842_SHARP_){
if(cljs.core.truth_(p1__12842_SHARP_.call(null,topic))){
return p1__12842_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12842_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12846 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12846 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12847){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12847 = meta12847;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12848,meta12847__$1){
var self__ = this;
var _12848__$1 = this;
return (new cljs.core.async.t_cljs$core$async12846(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12847__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12848){
var self__ = this;
var _12848__$1 = this;
return self__.meta12847;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12846.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12846.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12847","meta12847",1069675829,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12846.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12846.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12846";

cljs.core.async.t_cljs$core$async12846.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12846");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12846 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12846(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12847){
return (new cljs.core.async.t_cljs$core$async12846(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12847));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12846(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11073__auto___12972 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___12972,mults,ensure_mult,p){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___12972,mults,ensure_mult,p){
return (function (state_12920){
var state_val_12921 = (state_12920[(1)]);
if((state_val_12921 === (7))){
var inst_12916 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
var statearr_12922_12973 = state_12920__$1;
(statearr_12922_12973[(2)] = inst_12916);

(statearr_12922_12973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (20))){
var state_12920__$1 = state_12920;
var statearr_12923_12974 = state_12920__$1;
(statearr_12923_12974[(2)] = null);

(statearr_12923_12974[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (1))){
var state_12920__$1 = state_12920;
var statearr_12924_12975 = state_12920__$1;
(statearr_12924_12975[(2)] = null);

(statearr_12924_12975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (24))){
var inst_12899 = (state_12920[(7)]);
var inst_12908 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12899);
var state_12920__$1 = state_12920;
var statearr_12925_12976 = state_12920__$1;
(statearr_12925_12976[(2)] = inst_12908);

(statearr_12925_12976[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (4))){
var inst_12851 = (state_12920[(8)]);
var inst_12851__$1 = (state_12920[(2)]);
var inst_12852 = (inst_12851__$1 == null);
var state_12920__$1 = (function (){var statearr_12926 = state_12920;
(statearr_12926[(8)] = inst_12851__$1);

return statearr_12926;
})();
if(cljs.core.truth_(inst_12852)){
var statearr_12927_12977 = state_12920__$1;
(statearr_12927_12977[(1)] = (5));

} else {
var statearr_12928_12978 = state_12920__$1;
(statearr_12928_12978[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (15))){
var inst_12893 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
var statearr_12929_12979 = state_12920__$1;
(statearr_12929_12979[(2)] = inst_12893);

(statearr_12929_12979[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (21))){
var inst_12913 = (state_12920[(2)]);
var state_12920__$1 = (function (){var statearr_12930 = state_12920;
(statearr_12930[(9)] = inst_12913);

return statearr_12930;
})();
var statearr_12931_12980 = state_12920__$1;
(statearr_12931_12980[(2)] = null);

(statearr_12931_12980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (13))){
var inst_12875 = (state_12920[(10)]);
var inst_12877 = cljs.core.chunked_seq_QMARK_.call(null,inst_12875);
var state_12920__$1 = state_12920;
if(inst_12877){
var statearr_12932_12981 = state_12920__$1;
(statearr_12932_12981[(1)] = (16));

} else {
var statearr_12933_12982 = state_12920__$1;
(statearr_12933_12982[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (22))){
var inst_12905 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
if(cljs.core.truth_(inst_12905)){
var statearr_12934_12983 = state_12920__$1;
(statearr_12934_12983[(1)] = (23));

} else {
var statearr_12935_12984 = state_12920__$1;
(statearr_12935_12984[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (6))){
var inst_12851 = (state_12920[(8)]);
var inst_12899 = (state_12920[(7)]);
var inst_12901 = (state_12920[(11)]);
var inst_12899__$1 = topic_fn.call(null,inst_12851);
var inst_12900 = cljs.core.deref.call(null,mults);
var inst_12901__$1 = cljs.core.get.call(null,inst_12900,inst_12899__$1);
var state_12920__$1 = (function (){var statearr_12936 = state_12920;
(statearr_12936[(7)] = inst_12899__$1);

(statearr_12936[(11)] = inst_12901__$1);

return statearr_12936;
})();
if(cljs.core.truth_(inst_12901__$1)){
var statearr_12937_12985 = state_12920__$1;
(statearr_12937_12985[(1)] = (19));

} else {
var statearr_12938_12986 = state_12920__$1;
(statearr_12938_12986[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (25))){
var inst_12910 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
var statearr_12939_12987 = state_12920__$1;
(statearr_12939_12987[(2)] = inst_12910);

(statearr_12939_12987[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (17))){
var inst_12875 = (state_12920[(10)]);
var inst_12884 = cljs.core.first.call(null,inst_12875);
var inst_12885 = cljs.core.async.muxch_STAR_.call(null,inst_12884);
var inst_12886 = cljs.core.async.close_BANG_.call(null,inst_12885);
var inst_12887 = cljs.core.next.call(null,inst_12875);
var inst_12861 = inst_12887;
var inst_12862 = null;
var inst_12863 = (0);
var inst_12864 = (0);
var state_12920__$1 = (function (){var statearr_12940 = state_12920;
(statearr_12940[(12)] = inst_12861);

(statearr_12940[(13)] = inst_12864);

(statearr_12940[(14)] = inst_12862);

(statearr_12940[(15)] = inst_12863);

(statearr_12940[(16)] = inst_12886);

return statearr_12940;
})();
var statearr_12941_12988 = state_12920__$1;
(statearr_12941_12988[(2)] = null);

(statearr_12941_12988[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (3))){
var inst_12918 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12920__$1,inst_12918);
} else {
if((state_val_12921 === (12))){
var inst_12895 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
var statearr_12942_12989 = state_12920__$1;
(statearr_12942_12989[(2)] = inst_12895);

(statearr_12942_12989[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (2))){
var state_12920__$1 = state_12920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12920__$1,(4),ch);
} else {
if((state_val_12921 === (23))){
var state_12920__$1 = state_12920;
var statearr_12943_12990 = state_12920__$1;
(statearr_12943_12990[(2)] = null);

(statearr_12943_12990[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (19))){
var inst_12851 = (state_12920[(8)]);
var inst_12901 = (state_12920[(11)]);
var inst_12903 = cljs.core.async.muxch_STAR_.call(null,inst_12901);
var state_12920__$1 = state_12920;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12920__$1,(22),inst_12903,inst_12851);
} else {
if((state_val_12921 === (11))){
var inst_12861 = (state_12920[(12)]);
var inst_12875 = (state_12920[(10)]);
var inst_12875__$1 = cljs.core.seq.call(null,inst_12861);
var state_12920__$1 = (function (){var statearr_12944 = state_12920;
(statearr_12944[(10)] = inst_12875__$1);

return statearr_12944;
})();
if(inst_12875__$1){
var statearr_12945_12991 = state_12920__$1;
(statearr_12945_12991[(1)] = (13));

} else {
var statearr_12946_12992 = state_12920__$1;
(statearr_12946_12992[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (9))){
var inst_12897 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
var statearr_12947_12993 = state_12920__$1;
(statearr_12947_12993[(2)] = inst_12897);

(statearr_12947_12993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (5))){
var inst_12858 = cljs.core.deref.call(null,mults);
var inst_12859 = cljs.core.vals.call(null,inst_12858);
var inst_12860 = cljs.core.seq.call(null,inst_12859);
var inst_12861 = inst_12860;
var inst_12862 = null;
var inst_12863 = (0);
var inst_12864 = (0);
var state_12920__$1 = (function (){var statearr_12948 = state_12920;
(statearr_12948[(12)] = inst_12861);

(statearr_12948[(13)] = inst_12864);

(statearr_12948[(14)] = inst_12862);

(statearr_12948[(15)] = inst_12863);

return statearr_12948;
})();
var statearr_12949_12994 = state_12920__$1;
(statearr_12949_12994[(2)] = null);

(statearr_12949_12994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (14))){
var state_12920__$1 = state_12920;
var statearr_12953_12995 = state_12920__$1;
(statearr_12953_12995[(2)] = null);

(statearr_12953_12995[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (16))){
var inst_12875 = (state_12920[(10)]);
var inst_12879 = cljs.core.chunk_first.call(null,inst_12875);
var inst_12880 = cljs.core.chunk_rest.call(null,inst_12875);
var inst_12881 = cljs.core.count.call(null,inst_12879);
var inst_12861 = inst_12880;
var inst_12862 = inst_12879;
var inst_12863 = inst_12881;
var inst_12864 = (0);
var state_12920__$1 = (function (){var statearr_12954 = state_12920;
(statearr_12954[(12)] = inst_12861);

(statearr_12954[(13)] = inst_12864);

(statearr_12954[(14)] = inst_12862);

(statearr_12954[(15)] = inst_12863);

return statearr_12954;
})();
var statearr_12955_12996 = state_12920__$1;
(statearr_12955_12996[(2)] = null);

(statearr_12955_12996[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (10))){
var inst_12861 = (state_12920[(12)]);
var inst_12864 = (state_12920[(13)]);
var inst_12862 = (state_12920[(14)]);
var inst_12863 = (state_12920[(15)]);
var inst_12869 = cljs.core._nth.call(null,inst_12862,inst_12864);
var inst_12870 = cljs.core.async.muxch_STAR_.call(null,inst_12869);
var inst_12871 = cljs.core.async.close_BANG_.call(null,inst_12870);
var inst_12872 = (inst_12864 + (1));
var tmp12950 = inst_12861;
var tmp12951 = inst_12862;
var tmp12952 = inst_12863;
var inst_12861__$1 = tmp12950;
var inst_12862__$1 = tmp12951;
var inst_12863__$1 = tmp12952;
var inst_12864__$1 = inst_12872;
var state_12920__$1 = (function (){var statearr_12956 = state_12920;
(statearr_12956[(12)] = inst_12861__$1);

(statearr_12956[(13)] = inst_12864__$1);

(statearr_12956[(14)] = inst_12862__$1);

(statearr_12956[(17)] = inst_12871);

(statearr_12956[(15)] = inst_12863__$1);

return statearr_12956;
})();
var statearr_12957_12997 = state_12920__$1;
(statearr_12957_12997[(2)] = null);

(statearr_12957_12997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (18))){
var inst_12890 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
var statearr_12958_12998 = state_12920__$1;
(statearr_12958_12998[(2)] = inst_12890);

(statearr_12958_12998[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (8))){
var inst_12864 = (state_12920[(13)]);
var inst_12863 = (state_12920[(15)]);
var inst_12866 = (inst_12864 < inst_12863);
var inst_12867 = inst_12866;
var state_12920__$1 = state_12920;
if(cljs.core.truth_(inst_12867)){
var statearr_12959_12999 = state_12920__$1;
(statearr_12959_12999[(1)] = (10));

} else {
var statearr_12960_13000 = state_12920__$1;
(statearr_12960_13000[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___12972,mults,ensure_mult,p))
;
return ((function (switch__10961__auto__,c__11073__auto___12972,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_12964 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12964[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_12964[(1)] = (1));

return statearr_12964;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_12920){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_12920);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e12965){if((e12965 instanceof Object)){
var ex__10965__auto__ = e12965;
var statearr_12966_13001 = state_12920;
(statearr_12966_13001[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12920);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12965;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13002 = state_12920;
state_12920 = G__13002;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_12920){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_12920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___12972,mults,ensure_mult,p))
})();
var state__11075__auto__ = (function (){var statearr_12967 = f__11074__auto__.call(null);
(statearr_12967[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___12972);

return statearr_12967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___12972,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args13003 = [];
var len__5726__auto___13006 = arguments.length;
var i__5727__auto___13007 = (0);
while(true){
if((i__5727__auto___13007 < len__5726__auto___13006)){
args13003.push((arguments[i__5727__auto___13007]));

var G__13008 = (i__5727__auto___13007 + (1));
i__5727__auto___13007 = G__13008;
continue;
} else {
}
break;
}

var G__13005 = args13003.length;
switch (G__13005) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13003.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args13010 = [];
var len__5726__auto___13013 = arguments.length;
var i__5727__auto___13014 = (0);
while(true){
if((i__5727__auto___13014 < len__5726__auto___13013)){
args13010.push((arguments[i__5727__auto___13014]));

var G__13015 = (i__5727__auto___13014 + (1));
i__5727__auto___13014 = G__13015;
continue;
} else {
}
break;
}

var G__13012 = args13010.length;
switch (G__13012) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13010.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13017 = [];
var len__5726__auto___13088 = arguments.length;
var i__5727__auto___13089 = (0);
while(true){
if((i__5727__auto___13089 < len__5726__auto___13088)){
args13017.push((arguments[i__5727__auto___13089]));

var G__13090 = (i__5727__auto___13089 + (1));
i__5727__auto___13089 = G__13090;
continue;
} else {
}
break;
}

var G__13019 = args13017.length;
switch (G__13019) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13017.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11073__auto___13092 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___13092,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___13092,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13058){
var state_val_13059 = (state_13058[(1)]);
if((state_val_13059 === (7))){
var state_13058__$1 = state_13058;
var statearr_13060_13093 = state_13058__$1;
(statearr_13060_13093[(2)] = null);

(statearr_13060_13093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (1))){
var state_13058__$1 = state_13058;
var statearr_13061_13094 = state_13058__$1;
(statearr_13061_13094[(2)] = null);

(statearr_13061_13094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (4))){
var inst_13022 = (state_13058[(7)]);
var inst_13024 = (inst_13022 < cnt);
var state_13058__$1 = state_13058;
if(cljs.core.truth_(inst_13024)){
var statearr_13062_13095 = state_13058__$1;
(statearr_13062_13095[(1)] = (6));

} else {
var statearr_13063_13096 = state_13058__$1;
(statearr_13063_13096[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (15))){
var inst_13054 = (state_13058[(2)]);
var state_13058__$1 = state_13058;
var statearr_13064_13097 = state_13058__$1;
(statearr_13064_13097[(2)] = inst_13054);

(statearr_13064_13097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (13))){
var inst_13047 = cljs.core.async.close_BANG_.call(null,out);
var state_13058__$1 = state_13058;
var statearr_13065_13098 = state_13058__$1;
(statearr_13065_13098[(2)] = inst_13047);

(statearr_13065_13098[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (6))){
var state_13058__$1 = state_13058;
var statearr_13066_13099 = state_13058__$1;
(statearr_13066_13099[(2)] = null);

(statearr_13066_13099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (3))){
var inst_13056 = (state_13058[(2)]);
var state_13058__$1 = state_13058;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13058__$1,inst_13056);
} else {
if((state_val_13059 === (12))){
var inst_13044 = (state_13058[(8)]);
var inst_13044__$1 = (state_13058[(2)]);
var inst_13045 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13044__$1);
var state_13058__$1 = (function (){var statearr_13067 = state_13058;
(statearr_13067[(8)] = inst_13044__$1);

return statearr_13067;
})();
if(cljs.core.truth_(inst_13045)){
var statearr_13068_13100 = state_13058__$1;
(statearr_13068_13100[(1)] = (13));

} else {
var statearr_13069_13101 = state_13058__$1;
(statearr_13069_13101[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (2))){
var inst_13021 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13022 = (0);
var state_13058__$1 = (function (){var statearr_13070 = state_13058;
(statearr_13070[(7)] = inst_13022);

(statearr_13070[(9)] = inst_13021);

return statearr_13070;
})();
var statearr_13071_13102 = state_13058__$1;
(statearr_13071_13102[(2)] = null);

(statearr_13071_13102[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (11))){
var inst_13022 = (state_13058[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13058,(10),Object,null,(9));
var inst_13031 = chs__$1.call(null,inst_13022);
var inst_13032 = done.call(null,inst_13022);
var inst_13033 = cljs.core.async.take_BANG_.call(null,inst_13031,inst_13032);
var state_13058__$1 = state_13058;
var statearr_13072_13103 = state_13058__$1;
(statearr_13072_13103[(2)] = inst_13033);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13058__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (9))){
var inst_13022 = (state_13058[(7)]);
var inst_13035 = (state_13058[(2)]);
var inst_13036 = (inst_13022 + (1));
var inst_13022__$1 = inst_13036;
var state_13058__$1 = (function (){var statearr_13073 = state_13058;
(statearr_13073[(7)] = inst_13022__$1);

(statearr_13073[(10)] = inst_13035);

return statearr_13073;
})();
var statearr_13074_13104 = state_13058__$1;
(statearr_13074_13104[(2)] = null);

(statearr_13074_13104[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (5))){
var inst_13042 = (state_13058[(2)]);
var state_13058__$1 = (function (){var statearr_13075 = state_13058;
(statearr_13075[(11)] = inst_13042);

return statearr_13075;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13058__$1,(12),dchan);
} else {
if((state_val_13059 === (14))){
var inst_13044 = (state_13058[(8)]);
var inst_13049 = cljs.core.apply.call(null,f,inst_13044);
var state_13058__$1 = state_13058;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13058__$1,(16),out,inst_13049);
} else {
if((state_val_13059 === (16))){
var inst_13051 = (state_13058[(2)]);
var state_13058__$1 = (function (){var statearr_13076 = state_13058;
(statearr_13076[(12)] = inst_13051);

return statearr_13076;
})();
var statearr_13077_13105 = state_13058__$1;
(statearr_13077_13105[(2)] = null);

(statearr_13077_13105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (10))){
var inst_13026 = (state_13058[(2)]);
var inst_13027 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13058__$1 = (function (){var statearr_13078 = state_13058;
(statearr_13078[(13)] = inst_13026);

return statearr_13078;
})();
var statearr_13079_13106 = state_13058__$1;
(statearr_13079_13106[(2)] = inst_13027);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13058__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13059 === (8))){
var inst_13040 = (state_13058[(2)]);
var state_13058__$1 = state_13058;
var statearr_13080_13107 = state_13058__$1;
(statearr_13080_13107[(2)] = inst_13040);

(statearr_13080_13107[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___13092,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10961__auto__,c__11073__auto___13092,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_13084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13084[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_13084[(1)] = (1));

return statearr_13084;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_13058){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_13058);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e13085){if((e13085 instanceof Object)){
var ex__10965__auto__ = e13085;
var statearr_13086_13108 = state_13058;
(statearr_13086_13108[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13058);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13085;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13109 = state_13058;
state_13058 = G__13109;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_13058){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_13058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___13092,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11075__auto__ = (function (){var statearr_13087 = f__11074__auto__.call(null);
(statearr_13087[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___13092);

return statearr_13087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___13092,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13111 = [];
var len__5726__auto___13167 = arguments.length;
var i__5727__auto___13168 = (0);
while(true){
if((i__5727__auto___13168 < len__5726__auto___13167)){
args13111.push((arguments[i__5727__auto___13168]));

var G__13169 = (i__5727__auto___13168 + (1));
i__5727__auto___13168 = G__13169;
continue;
} else {
}
break;
}

var G__13113 = args13111.length;
switch (G__13113) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13111.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___13171 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___13171,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___13171,out){
return (function (state_13143){
var state_val_13144 = (state_13143[(1)]);
if((state_val_13144 === (7))){
var inst_13123 = (state_13143[(7)]);
var inst_13122 = (state_13143[(8)]);
var inst_13122__$1 = (state_13143[(2)]);
var inst_13123__$1 = cljs.core.nth.call(null,inst_13122__$1,(0),null);
var inst_13124 = cljs.core.nth.call(null,inst_13122__$1,(1),null);
var inst_13125 = (inst_13123__$1 == null);
var state_13143__$1 = (function (){var statearr_13145 = state_13143;
(statearr_13145[(7)] = inst_13123__$1);

(statearr_13145[(8)] = inst_13122__$1);

(statearr_13145[(9)] = inst_13124);

return statearr_13145;
})();
if(cljs.core.truth_(inst_13125)){
var statearr_13146_13172 = state_13143__$1;
(statearr_13146_13172[(1)] = (8));

} else {
var statearr_13147_13173 = state_13143__$1;
(statearr_13147_13173[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13144 === (1))){
var inst_13114 = cljs.core.vec.call(null,chs);
var inst_13115 = inst_13114;
var state_13143__$1 = (function (){var statearr_13148 = state_13143;
(statearr_13148[(10)] = inst_13115);

return statearr_13148;
})();
var statearr_13149_13174 = state_13143__$1;
(statearr_13149_13174[(2)] = null);

(statearr_13149_13174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13144 === (4))){
var inst_13115 = (state_13143[(10)]);
var state_13143__$1 = state_13143;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13143__$1,(7),inst_13115);
} else {
if((state_val_13144 === (6))){
var inst_13139 = (state_13143[(2)]);
var state_13143__$1 = state_13143;
var statearr_13150_13175 = state_13143__$1;
(statearr_13150_13175[(2)] = inst_13139);

(statearr_13150_13175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13144 === (3))){
var inst_13141 = (state_13143[(2)]);
var state_13143__$1 = state_13143;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13143__$1,inst_13141);
} else {
if((state_val_13144 === (2))){
var inst_13115 = (state_13143[(10)]);
var inst_13117 = cljs.core.count.call(null,inst_13115);
var inst_13118 = (inst_13117 > (0));
var state_13143__$1 = state_13143;
if(cljs.core.truth_(inst_13118)){
var statearr_13152_13176 = state_13143__$1;
(statearr_13152_13176[(1)] = (4));

} else {
var statearr_13153_13177 = state_13143__$1;
(statearr_13153_13177[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13144 === (11))){
var inst_13115 = (state_13143[(10)]);
var inst_13132 = (state_13143[(2)]);
var tmp13151 = inst_13115;
var inst_13115__$1 = tmp13151;
var state_13143__$1 = (function (){var statearr_13154 = state_13143;
(statearr_13154[(10)] = inst_13115__$1);

(statearr_13154[(11)] = inst_13132);

return statearr_13154;
})();
var statearr_13155_13178 = state_13143__$1;
(statearr_13155_13178[(2)] = null);

(statearr_13155_13178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13144 === (9))){
var inst_13123 = (state_13143[(7)]);
var state_13143__$1 = state_13143;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13143__$1,(11),out,inst_13123);
} else {
if((state_val_13144 === (5))){
var inst_13137 = cljs.core.async.close_BANG_.call(null,out);
var state_13143__$1 = state_13143;
var statearr_13156_13179 = state_13143__$1;
(statearr_13156_13179[(2)] = inst_13137);

(statearr_13156_13179[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13144 === (10))){
var inst_13135 = (state_13143[(2)]);
var state_13143__$1 = state_13143;
var statearr_13157_13180 = state_13143__$1;
(statearr_13157_13180[(2)] = inst_13135);

(statearr_13157_13180[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13144 === (8))){
var inst_13115 = (state_13143[(10)]);
var inst_13123 = (state_13143[(7)]);
var inst_13122 = (state_13143[(8)]);
var inst_13124 = (state_13143[(9)]);
var inst_13127 = (function (){var cs = inst_13115;
var vec__13120 = inst_13122;
var v = inst_13123;
var c = inst_13124;
return ((function (cs,vec__13120,v,c,inst_13115,inst_13123,inst_13122,inst_13124,state_val_13144,c__11073__auto___13171,out){
return (function (p1__13110_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13110_SHARP_);
});
;})(cs,vec__13120,v,c,inst_13115,inst_13123,inst_13122,inst_13124,state_val_13144,c__11073__auto___13171,out))
})();
var inst_13128 = cljs.core.filterv.call(null,inst_13127,inst_13115);
var inst_13115__$1 = inst_13128;
var state_13143__$1 = (function (){var statearr_13158 = state_13143;
(statearr_13158[(10)] = inst_13115__$1);

return statearr_13158;
})();
var statearr_13159_13181 = state_13143__$1;
(statearr_13159_13181[(2)] = null);

(statearr_13159_13181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___13171,out))
;
return ((function (switch__10961__auto__,c__11073__auto___13171,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_13163 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13163[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_13163[(1)] = (1));

return statearr_13163;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_13143){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_13143);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e13164){if((e13164 instanceof Object)){
var ex__10965__auto__ = e13164;
var statearr_13165_13182 = state_13143;
(statearr_13165_13182[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13143);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13164;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13183 = state_13143;
state_13143 = G__13183;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_13143){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_13143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___13171,out))
})();
var state__11075__auto__ = (function (){var statearr_13166 = f__11074__auto__.call(null);
(statearr_13166[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___13171);

return statearr_13166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___13171,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13184 = [];
var len__5726__auto___13233 = arguments.length;
var i__5727__auto___13234 = (0);
while(true){
if((i__5727__auto___13234 < len__5726__auto___13233)){
args13184.push((arguments[i__5727__auto___13234]));

var G__13235 = (i__5727__auto___13234 + (1));
i__5727__auto___13234 = G__13235;
continue;
} else {
}
break;
}

var G__13186 = args13184.length;
switch (G__13186) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13184.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___13237 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___13237,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___13237,out){
return (function (state_13210){
var state_val_13211 = (state_13210[(1)]);
if((state_val_13211 === (7))){
var inst_13192 = (state_13210[(7)]);
var inst_13192__$1 = (state_13210[(2)]);
var inst_13193 = (inst_13192__$1 == null);
var inst_13194 = cljs.core.not.call(null,inst_13193);
var state_13210__$1 = (function (){var statearr_13212 = state_13210;
(statearr_13212[(7)] = inst_13192__$1);

return statearr_13212;
})();
if(inst_13194){
var statearr_13213_13238 = state_13210__$1;
(statearr_13213_13238[(1)] = (8));

} else {
var statearr_13214_13239 = state_13210__$1;
(statearr_13214_13239[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13211 === (1))){
var inst_13187 = (0);
var state_13210__$1 = (function (){var statearr_13215 = state_13210;
(statearr_13215[(8)] = inst_13187);

return statearr_13215;
})();
var statearr_13216_13240 = state_13210__$1;
(statearr_13216_13240[(2)] = null);

(statearr_13216_13240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13211 === (4))){
var state_13210__$1 = state_13210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13210__$1,(7),ch);
} else {
if((state_val_13211 === (6))){
var inst_13205 = (state_13210[(2)]);
var state_13210__$1 = state_13210;
var statearr_13217_13241 = state_13210__$1;
(statearr_13217_13241[(2)] = inst_13205);

(statearr_13217_13241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13211 === (3))){
var inst_13207 = (state_13210[(2)]);
var inst_13208 = cljs.core.async.close_BANG_.call(null,out);
var state_13210__$1 = (function (){var statearr_13218 = state_13210;
(statearr_13218[(9)] = inst_13207);

return statearr_13218;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13210__$1,inst_13208);
} else {
if((state_val_13211 === (2))){
var inst_13187 = (state_13210[(8)]);
var inst_13189 = (inst_13187 < n);
var state_13210__$1 = state_13210;
if(cljs.core.truth_(inst_13189)){
var statearr_13219_13242 = state_13210__$1;
(statearr_13219_13242[(1)] = (4));

} else {
var statearr_13220_13243 = state_13210__$1;
(statearr_13220_13243[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13211 === (11))){
var inst_13187 = (state_13210[(8)]);
var inst_13197 = (state_13210[(2)]);
var inst_13198 = (inst_13187 + (1));
var inst_13187__$1 = inst_13198;
var state_13210__$1 = (function (){var statearr_13221 = state_13210;
(statearr_13221[(8)] = inst_13187__$1);

(statearr_13221[(10)] = inst_13197);

return statearr_13221;
})();
var statearr_13222_13244 = state_13210__$1;
(statearr_13222_13244[(2)] = null);

(statearr_13222_13244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13211 === (9))){
var state_13210__$1 = state_13210;
var statearr_13223_13245 = state_13210__$1;
(statearr_13223_13245[(2)] = null);

(statearr_13223_13245[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13211 === (5))){
var state_13210__$1 = state_13210;
var statearr_13224_13246 = state_13210__$1;
(statearr_13224_13246[(2)] = null);

(statearr_13224_13246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13211 === (10))){
var inst_13202 = (state_13210[(2)]);
var state_13210__$1 = state_13210;
var statearr_13225_13247 = state_13210__$1;
(statearr_13225_13247[(2)] = inst_13202);

(statearr_13225_13247[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13211 === (8))){
var inst_13192 = (state_13210[(7)]);
var state_13210__$1 = state_13210;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13210__$1,(11),out,inst_13192);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___13237,out))
;
return ((function (switch__10961__auto__,c__11073__auto___13237,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_13229 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13229[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_13229[(1)] = (1));

return statearr_13229;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_13210){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_13210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e13230){if((e13230 instanceof Object)){
var ex__10965__auto__ = e13230;
var statearr_13231_13248 = state_13210;
(statearr_13231_13248[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13230;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13249 = state_13210;
state_13210 = G__13249;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_13210){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_13210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___13237,out))
})();
var state__11075__auto__ = (function (){var statearr_13232 = f__11074__auto__.call(null);
(statearr_13232[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___13237);

return statearr_13232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___13237,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13257 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13257 = (function (map_LT_,f,ch,meta13258){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13258 = meta13258;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13259,meta13258__$1){
var self__ = this;
var _13259__$1 = this;
return (new cljs.core.async.t_cljs$core$async13257(self__.map_LT_,self__.f,self__.ch,meta13258__$1));
});

cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13259){
var self__ = this;
var _13259__$1 = this;
return self__.meta13258;
});

cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async13260 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13260 = (function (map_LT_,f,ch,meta13258,_,fn1,meta13261){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13258 = meta13258;
this._ = _;
this.fn1 = fn1;
this.meta13261 = meta13261;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13262,meta13261__$1){
var self__ = this;
var _13262__$1 = this;
return (new cljs.core.async.t_cljs$core$async13260(self__.map_LT_,self__.f,self__.ch,self__.meta13258,self__._,self__.fn1,meta13261__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13262){
var self__ = this;
var _13262__$1 = this;
return self__.meta13261;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13260.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__13250_SHARP_){
return f1.call(null,(((p1__13250_SHARP_ == null))?null:self__.f.call(null,p1__13250_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async13260.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13258","meta13258",2110259552,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13257","cljs.core.async/t_cljs$core$async13257",1186338020,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13261","meta13261",-1189580685,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13260.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13260.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13260";

cljs.core.async.t_cljs$core$async13260.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13260");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async13260 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13260(map_LT___$1,f__$1,ch__$1,meta13258__$1,___$2,fn1__$1,meta13261){
return (new cljs.core.async.t_cljs$core$async13260(map_LT___$1,f__$1,ch__$1,meta13258__$1,___$2,fn1__$1,meta13261));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async13260(self__.map_LT_,self__.f,self__.ch,self__.meta13258,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13257.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async13257.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13258","meta13258",2110259552,null)], null);
});

cljs.core.async.t_cljs$core$async13257.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13257.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13257";

cljs.core.async.t_cljs$core$async13257.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13257");
});

cljs.core.async.__GT_t_cljs$core$async13257 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13257(map_LT___$1,f__$1,ch__$1,meta13258){
return (new cljs.core.async.t_cljs$core$async13257(map_LT___$1,f__$1,ch__$1,meta13258));
});

}

return (new cljs.core.async.t_cljs$core$async13257(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13266 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13266 = (function (map_GT_,f,ch,meta13267){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta13267 = meta13267;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13266.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13268,meta13267__$1){
var self__ = this;
var _13268__$1 = this;
return (new cljs.core.async.t_cljs$core$async13266(self__.map_GT_,self__.f,self__.ch,meta13267__$1));
});

cljs.core.async.t_cljs$core$async13266.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13268){
var self__ = this;
var _13268__$1 = this;
return self__.meta13267;
});

cljs.core.async.t_cljs$core$async13266.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13266.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13266.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13266.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13266.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13266.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async13266.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13267","meta13267",542222176,null)], null);
});

cljs.core.async.t_cljs$core$async13266.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13266.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13266";

cljs.core.async.t_cljs$core$async13266.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13266");
});

cljs.core.async.__GT_t_cljs$core$async13266 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13266(map_GT___$1,f__$1,ch__$1,meta13267){
return (new cljs.core.async.t_cljs$core$async13266(map_GT___$1,f__$1,ch__$1,meta13267));
});

}

return (new cljs.core.async.t_cljs$core$async13266(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async13272 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13272 = (function (filter_GT_,p,ch,meta13273){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13273 = meta13273;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13274,meta13273__$1){
var self__ = this;
var _13274__$1 = this;
return (new cljs.core.async.t_cljs$core$async13272(self__.filter_GT_,self__.p,self__.ch,meta13273__$1));
});

cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13274){
var self__ = this;
var _13274__$1 = this;
return self__.meta13273;
});

cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13272.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async13272.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13273","meta13273",914438591,null)], null);
});

cljs.core.async.t_cljs$core$async13272.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13272.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13272";

cljs.core.async.t_cljs$core$async13272.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13272");
});

cljs.core.async.__GT_t_cljs$core$async13272 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13272(filter_GT___$1,p__$1,ch__$1,meta13273){
return (new cljs.core.async.t_cljs$core$async13272(filter_GT___$1,p__$1,ch__$1,meta13273));
});

}

return (new cljs.core.async.t_cljs$core$async13272(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args13275 = [];
var len__5726__auto___13319 = arguments.length;
var i__5727__auto___13320 = (0);
while(true){
if((i__5727__auto___13320 < len__5726__auto___13319)){
args13275.push((arguments[i__5727__auto___13320]));

var G__13321 = (i__5727__auto___13320 + (1));
i__5727__auto___13320 = G__13321;
continue;
} else {
}
break;
}

var G__13277 = args13275.length;
switch (G__13277) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13275.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___13323 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___13323,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___13323,out){
return (function (state_13298){
var state_val_13299 = (state_13298[(1)]);
if((state_val_13299 === (7))){
var inst_13294 = (state_13298[(2)]);
var state_13298__$1 = state_13298;
var statearr_13300_13324 = state_13298__$1;
(statearr_13300_13324[(2)] = inst_13294);

(statearr_13300_13324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (1))){
var state_13298__$1 = state_13298;
var statearr_13301_13325 = state_13298__$1;
(statearr_13301_13325[(2)] = null);

(statearr_13301_13325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (4))){
var inst_13280 = (state_13298[(7)]);
var inst_13280__$1 = (state_13298[(2)]);
var inst_13281 = (inst_13280__$1 == null);
var state_13298__$1 = (function (){var statearr_13302 = state_13298;
(statearr_13302[(7)] = inst_13280__$1);

return statearr_13302;
})();
if(cljs.core.truth_(inst_13281)){
var statearr_13303_13326 = state_13298__$1;
(statearr_13303_13326[(1)] = (5));

} else {
var statearr_13304_13327 = state_13298__$1;
(statearr_13304_13327[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (6))){
var inst_13280 = (state_13298[(7)]);
var inst_13285 = p.call(null,inst_13280);
var state_13298__$1 = state_13298;
if(cljs.core.truth_(inst_13285)){
var statearr_13305_13328 = state_13298__$1;
(statearr_13305_13328[(1)] = (8));

} else {
var statearr_13306_13329 = state_13298__$1;
(statearr_13306_13329[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (3))){
var inst_13296 = (state_13298[(2)]);
var state_13298__$1 = state_13298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13298__$1,inst_13296);
} else {
if((state_val_13299 === (2))){
var state_13298__$1 = state_13298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13298__$1,(4),ch);
} else {
if((state_val_13299 === (11))){
var inst_13288 = (state_13298[(2)]);
var state_13298__$1 = state_13298;
var statearr_13307_13330 = state_13298__$1;
(statearr_13307_13330[(2)] = inst_13288);

(statearr_13307_13330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (9))){
var state_13298__$1 = state_13298;
var statearr_13308_13331 = state_13298__$1;
(statearr_13308_13331[(2)] = null);

(statearr_13308_13331[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (5))){
var inst_13283 = cljs.core.async.close_BANG_.call(null,out);
var state_13298__$1 = state_13298;
var statearr_13309_13332 = state_13298__$1;
(statearr_13309_13332[(2)] = inst_13283);

(statearr_13309_13332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (10))){
var inst_13291 = (state_13298[(2)]);
var state_13298__$1 = (function (){var statearr_13310 = state_13298;
(statearr_13310[(8)] = inst_13291);

return statearr_13310;
})();
var statearr_13311_13333 = state_13298__$1;
(statearr_13311_13333[(2)] = null);

(statearr_13311_13333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13299 === (8))){
var inst_13280 = (state_13298[(7)]);
var state_13298__$1 = state_13298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13298__$1,(11),out,inst_13280);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___13323,out))
;
return ((function (switch__10961__auto__,c__11073__auto___13323,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_13315 = [null,null,null,null,null,null,null,null,null];
(statearr_13315[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_13315[(1)] = (1));

return statearr_13315;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_13298){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_13298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e13316){if((e13316 instanceof Object)){
var ex__10965__auto__ = e13316;
var statearr_13317_13334 = state_13298;
(statearr_13317_13334[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13316;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13335 = state_13298;
state_13298 = G__13335;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_13298){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_13298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___13323,out))
})();
var state__11075__auto__ = (function (){var statearr_13318 = f__11074__auto__.call(null);
(statearr_13318[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___13323);

return statearr_13318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___13323,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args13336 = [];
var len__5726__auto___13339 = arguments.length;
var i__5727__auto___13340 = (0);
while(true){
if((i__5727__auto___13340 < len__5726__auto___13339)){
args13336.push((arguments[i__5727__auto___13340]));

var G__13341 = (i__5727__auto___13340 + (1));
i__5727__auto___13340 = G__13341;
continue;
} else {
}
break;
}

var G__13338 = args13336.length;
switch (G__13338) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13336.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11073__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto__){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto__){
return (function (state_13508){
var state_val_13509 = (state_13508[(1)]);
if((state_val_13509 === (7))){
var inst_13504 = (state_13508[(2)]);
var state_13508__$1 = state_13508;
var statearr_13510_13551 = state_13508__$1;
(statearr_13510_13551[(2)] = inst_13504);

(statearr_13510_13551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (20))){
var inst_13474 = (state_13508[(7)]);
var inst_13485 = (state_13508[(2)]);
var inst_13486 = cljs.core.next.call(null,inst_13474);
var inst_13460 = inst_13486;
var inst_13461 = null;
var inst_13462 = (0);
var inst_13463 = (0);
var state_13508__$1 = (function (){var statearr_13511 = state_13508;
(statearr_13511[(8)] = inst_13463);

(statearr_13511[(9)] = inst_13462);

(statearr_13511[(10)] = inst_13460);

(statearr_13511[(11)] = inst_13461);

(statearr_13511[(12)] = inst_13485);

return statearr_13511;
})();
var statearr_13512_13552 = state_13508__$1;
(statearr_13512_13552[(2)] = null);

(statearr_13512_13552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (1))){
var state_13508__$1 = state_13508;
var statearr_13513_13553 = state_13508__$1;
(statearr_13513_13553[(2)] = null);

(statearr_13513_13553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (4))){
var inst_13449 = (state_13508[(13)]);
var inst_13449__$1 = (state_13508[(2)]);
var inst_13450 = (inst_13449__$1 == null);
var state_13508__$1 = (function (){var statearr_13514 = state_13508;
(statearr_13514[(13)] = inst_13449__$1);

return statearr_13514;
})();
if(cljs.core.truth_(inst_13450)){
var statearr_13515_13554 = state_13508__$1;
(statearr_13515_13554[(1)] = (5));

} else {
var statearr_13516_13555 = state_13508__$1;
(statearr_13516_13555[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (15))){
var state_13508__$1 = state_13508;
var statearr_13520_13556 = state_13508__$1;
(statearr_13520_13556[(2)] = null);

(statearr_13520_13556[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (21))){
var state_13508__$1 = state_13508;
var statearr_13521_13557 = state_13508__$1;
(statearr_13521_13557[(2)] = null);

(statearr_13521_13557[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (13))){
var inst_13463 = (state_13508[(8)]);
var inst_13462 = (state_13508[(9)]);
var inst_13460 = (state_13508[(10)]);
var inst_13461 = (state_13508[(11)]);
var inst_13470 = (state_13508[(2)]);
var inst_13471 = (inst_13463 + (1));
var tmp13517 = inst_13462;
var tmp13518 = inst_13460;
var tmp13519 = inst_13461;
var inst_13460__$1 = tmp13518;
var inst_13461__$1 = tmp13519;
var inst_13462__$1 = tmp13517;
var inst_13463__$1 = inst_13471;
var state_13508__$1 = (function (){var statearr_13522 = state_13508;
(statearr_13522[(8)] = inst_13463__$1);

(statearr_13522[(9)] = inst_13462__$1);

(statearr_13522[(10)] = inst_13460__$1);

(statearr_13522[(11)] = inst_13461__$1);

(statearr_13522[(14)] = inst_13470);

return statearr_13522;
})();
var statearr_13523_13558 = state_13508__$1;
(statearr_13523_13558[(2)] = null);

(statearr_13523_13558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (22))){
var state_13508__$1 = state_13508;
var statearr_13524_13559 = state_13508__$1;
(statearr_13524_13559[(2)] = null);

(statearr_13524_13559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (6))){
var inst_13449 = (state_13508[(13)]);
var inst_13458 = f.call(null,inst_13449);
var inst_13459 = cljs.core.seq.call(null,inst_13458);
var inst_13460 = inst_13459;
var inst_13461 = null;
var inst_13462 = (0);
var inst_13463 = (0);
var state_13508__$1 = (function (){var statearr_13525 = state_13508;
(statearr_13525[(8)] = inst_13463);

(statearr_13525[(9)] = inst_13462);

(statearr_13525[(10)] = inst_13460);

(statearr_13525[(11)] = inst_13461);

return statearr_13525;
})();
var statearr_13526_13560 = state_13508__$1;
(statearr_13526_13560[(2)] = null);

(statearr_13526_13560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (17))){
var inst_13474 = (state_13508[(7)]);
var inst_13478 = cljs.core.chunk_first.call(null,inst_13474);
var inst_13479 = cljs.core.chunk_rest.call(null,inst_13474);
var inst_13480 = cljs.core.count.call(null,inst_13478);
var inst_13460 = inst_13479;
var inst_13461 = inst_13478;
var inst_13462 = inst_13480;
var inst_13463 = (0);
var state_13508__$1 = (function (){var statearr_13527 = state_13508;
(statearr_13527[(8)] = inst_13463);

(statearr_13527[(9)] = inst_13462);

(statearr_13527[(10)] = inst_13460);

(statearr_13527[(11)] = inst_13461);

return statearr_13527;
})();
var statearr_13528_13561 = state_13508__$1;
(statearr_13528_13561[(2)] = null);

(statearr_13528_13561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (3))){
var inst_13506 = (state_13508[(2)]);
var state_13508__$1 = state_13508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13508__$1,inst_13506);
} else {
if((state_val_13509 === (12))){
var inst_13494 = (state_13508[(2)]);
var state_13508__$1 = state_13508;
var statearr_13529_13562 = state_13508__$1;
(statearr_13529_13562[(2)] = inst_13494);

(statearr_13529_13562[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (2))){
var state_13508__$1 = state_13508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13508__$1,(4),in$);
} else {
if((state_val_13509 === (23))){
var inst_13502 = (state_13508[(2)]);
var state_13508__$1 = state_13508;
var statearr_13530_13563 = state_13508__$1;
(statearr_13530_13563[(2)] = inst_13502);

(statearr_13530_13563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (19))){
var inst_13489 = (state_13508[(2)]);
var state_13508__$1 = state_13508;
var statearr_13531_13564 = state_13508__$1;
(statearr_13531_13564[(2)] = inst_13489);

(statearr_13531_13564[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (11))){
var inst_13474 = (state_13508[(7)]);
var inst_13460 = (state_13508[(10)]);
var inst_13474__$1 = cljs.core.seq.call(null,inst_13460);
var state_13508__$1 = (function (){var statearr_13532 = state_13508;
(statearr_13532[(7)] = inst_13474__$1);

return statearr_13532;
})();
if(inst_13474__$1){
var statearr_13533_13565 = state_13508__$1;
(statearr_13533_13565[(1)] = (14));

} else {
var statearr_13534_13566 = state_13508__$1;
(statearr_13534_13566[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (9))){
var inst_13496 = (state_13508[(2)]);
var inst_13497 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13508__$1 = (function (){var statearr_13535 = state_13508;
(statearr_13535[(15)] = inst_13496);

return statearr_13535;
})();
if(cljs.core.truth_(inst_13497)){
var statearr_13536_13567 = state_13508__$1;
(statearr_13536_13567[(1)] = (21));

} else {
var statearr_13537_13568 = state_13508__$1;
(statearr_13537_13568[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (5))){
var inst_13452 = cljs.core.async.close_BANG_.call(null,out);
var state_13508__$1 = state_13508;
var statearr_13538_13569 = state_13508__$1;
(statearr_13538_13569[(2)] = inst_13452);

(statearr_13538_13569[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (14))){
var inst_13474 = (state_13508[(7)]);
var inst_13476 = cljs.core.chunked_seq_QMARK_.call(null,inst_13474);
var state_13508__$1 = state_13508;
if(inst_13476){
var statearr_13539_13570 = state_13508__$1;
(statearr_13539_13570[(1)] = (17));

} else {
var statearr_13540_13571 = state_13508__$1;
(statearr_13540_13571[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (16))){
var inst_13492 = (state_13508[(2)]);
var state_13508__$1 = state_13508;
var statearr_13541_13572 = state_13508__$1;
(statearr_13541_13572[(2)] = inst_13492);

(statearr_13541_13572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13509 === (10))){
var inst_13463 = (state_13508[(8)]);
var inst_13461 = (state_13508[(11)]);
var inst_13468 = cljs.core._nth.call(null,inst_13461,inst_13463);
var state_13508__$1 = state_13508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13508__$1,(13),out,inst_13468);
} else {
if((state_val_13509 === (18))){
var inst_13474 = (state_13508[(7)]);
var inst_13483 = cljs.core.first.call(null,inst_13474);
var state_13508__$1 = state_13508;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13508__$1,(20),out,inst_13483);
} else {
if((state_val_13509 === (8))){
var inst_13463 = (state_13508[(8)]);
var inst_13462 = (state_13508[(9)]);
var inst_13465 = (inst_13463 < inst_13462);
var inst_13466 = inst_13465;
var state_13508__$1 = state_13508;
if(cljs.core.truth_(inst_13466)){
var statearr_13542_13573 = state_13508__$1;
(statearr_13542_13573[(1)] = (10));

} else {
var statearr_13543_13574 = state_13508__$1;
(statearr_13543_13574[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto__))
;
return ((function (switch__10961__auto__,c__11073__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____0 = (function (){
var statearr_13547 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13547[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__);

(statearr_13547[(1)] = (1));

return statearr_13547;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____1 = (function (state_13508){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_13508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e13548){if((e13548 instanceof Object)){
var ex__10965__auto__ = e13548;
var statearr_13549_13575 = state_13508;
(statearr_13549_13575[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13508);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13548;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13576 = state_13508;
state_13508 = G__13576;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__ = function(state_13508){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____1.call(this,state_13508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10962__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto__))
})();
var state__11075__auto__ = (function (){var statearr_13550 = f__11074__auto__.call(null);
(statearr_13550[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto__);

return statearr_13550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto__))
);

return c__11073__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13577 = [];
var len__5726__auto___13580 = arguments.length;
var i__5727__auto___13581 = (0);
while(true){
if((i__5727__auto___13581 < len__5726__auto___13580)){
args13577.push((arguments[i__5727__auto___13581]));

var G__13582 = (i__5727__auto___13581 + (1));
i__5727__auto___13581 = G__13582;
continue;
} else {
}
break;
}

var G__13579 = args13577.length;
switch (G__13579) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13577.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13584 = [];
var len__5726__auto___13587 = arguments.length;
var i__5727__auto___13588 = (0);
while(true){
if((i__5727__auto___13588 < len__5726__auto___13587)){
args13584.push((arguments[i__5727__auto___13588]));

var G__13589 = (i__5727__auto___13588 + (1));
i__5727__auto___13588 = G__13589;
continue;
} else {
}
break;
}

var G__13586 = args13584.length;
switch (G__13586) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13584.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13591 = [];
var len__5726__auto___13642 = arguments.length;
var i__5727__auto___13643 = (0);
while(true){
if((i__5727__auto___13643 < len__5726__auto___13642)){
args13591.push((arguments[i__5727__auto___13643]));

var G__13644 = (i__5727__auto___13643 + (1));
i__5727__auto___13643 = G__13644;
continue;
} else {
}
break;
}

var G__13593 = args13591.length;
switch (G__13593) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13591.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___13646 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___13646,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___13646,out){
return (function (state_13617){
var state_val_13618 = (state_13617[(1)]);
if((state_val_13618 === (7))){
var inst_13612 = (state_13617[(2)]);
var state_13617__$1 = state_13617;
var statearr_13619_13647 = state_13617__$1;
(statearr_13619_13647[(2)] = inst_13612);

(statearr_13619_13647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13618 === (1))){
var inst_13594 = null;
var state_13617__$1 = (function (){var statearr_13620 = state_13617;
(statearr_13620[(7)] = inst_13594);

return statearr_13620;
})();
var statearr_13621_13648 = state_13617__$1;
(statearr_13621_13648[(2)] = null);

(statearr_13621_13648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13618 === (4))){
var inst_13597 = (state_13617[(8)]);
var inst_13597__$1 = (state_13617[(2)]);
var inst_13598 = (inst_13597__$1 == null);
var inst_13599 = cljs.core.not.call(null,inst_13598);
var state_13617__$1 = (function (){var statearr_13622 = state_13617;
(statearr_13622[(8)] = inst_13597__$1);

return statearr_13622;
})();
if(inst_13599){
var statearr_13623_13649 = state_13617__$1;
(statearr_13623_13649[(1)] = (5));

} else {
var statearr_13624_13650 = state_13617__$1;
(statearr_13624_13650[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13618 === (6))){
var state_13617__$1 = state_13617;
var statearr_13625_13651 = state_13617__$1;
(statearr_13625_13651[(2)] = null);

(statearr_13625_13651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13618 === (3))){
var inst_13614 = (state_13617[(2)]);
var inst_13615 = cljs.core.async.close_BANG_.call(null,out);
var state_13617__$1 = (function (){var statearr_13626 = state_13617;
(statearr_13626[(9)] = inst_13614);

return statearr_13626;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13617__$1,inst_13615);
} else {
if((state_val_13618 === (2))){
var state_13617__$1 = state_13617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13617__$1,(4),ch);
} else {
if((state_val_13618 === (11))){
var inst_13597 = (state_13617[(8)]);
var inst_13606 = (state_13617[(2)]);
var inst_13594 = inst_13597;
var state_13617__$1 = (function (){var statearr_13627 = state_13617;
(statearr_13627[(10)] = inst_13606);

(statearr_13627[(7)] = inst_13594);

return statearr_13627;
})();
var statearr_13628_13652 = state_13617__$1;
(statearr_13628_13652[(2)] = null);

(statearr_13628_13652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13618 === (9))){
var inst_13597 = (state_13617[(8)]);
var state_13617__$1 = state_13617;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13617__$1,(11),out,inst_13597);
} else {
if((state_val_13618 === (5))){
var inst_13597 = (state_13617[(8)]);
var inst_13594 = (state_13617[(7)]);
var inst_13601 = cljs.core._EQ_.call(null,inst_13597,inst_13594);
var state_13617__$1 = state_13617;
if(inst_13601){
var statearr_13630_13653 = state_13617__$1;
(statearr_13630_13653[(1)] = (8));

} else {
var statearr_13631_13654 = state_13617__$1;
(statearr_13631_13654[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13618 === (10))){
var inst_13609 = (state_13617[(2)]);
var state_13617__$1 = state_13617;
var statearr_13632_13655 = state_13617__$1;
(statearr_13632_13655[(2)] = inst_13609);

(statearr_13632_13655[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13618 === (8))){
var inst_13594 = (state_13617[(7)]);
var tmp13629 = inst_13594;
var inst_13594__$1 = tmp13629;
var state_13617__$1 = (function (){var statearr_13633 = state_13617;
(statearr_13633[(7)] = inst_13594__$1);

return statearr_13633;
})();
var statearr_13634_13656 = state_13617__$1;
(statearr_13634_13656[(2)] = null);

(statearr_13634_13656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___13646,out))
;
return ((function (switch__10961__auto__,c__11073__auto___13646,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_13638 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13638[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_13638[(1)] = (1));

return statearr_13638;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_13617){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_13617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e13639){if((e13639 instanceof Object)){
var ex__10965__auto__ = e13639;
var statearr_13640_13657 = state_13617;
(statearr_13640_13657[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13617);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13639;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13658 = state_13617;
state_13617 = G__13658;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_13617){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_13617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___13646,out))
})();
var state__11075__auto__ = (function (){var statearr_13641 = f__11074__auto__.call(null);
(statearr_13641[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___13646);

return statearr_13641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___13646,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13659 = [];
var len__5726__auto___13729 = arguments.length;
var i__5727__auto___13730 = (0);
while(true){
if((i__5727__auto___13730 < len__5726__auto___13729)){
args13659.push((arguments[i__5727__auto___13730]));

var G__13731 = (i__5727__auto___13730 + (1));
i__5727__auto___13730 = G__13731;
continue;
} else {
}
break;
}

var G__13661 = args13659.length;
switch (G__13661) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13659.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___13733 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___13733,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___13733,out){
return (function (state_13699){
var state_val_13700 = (state_13699[(1)]);
if((state_val_13700 === (7))){
var inst_13695 = (state_13699[(2)]);
var state_13699__$1 = state_13699;
var statearr_13701_13734 = state_13699__$1;
(statearr_13701_13734[(2)] = inst_13695);

(statearr_13701_13734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (1))){
var inst_13662 = (new Array(n));
var inst_13663 = inst_13662;
var inst_13664 = (0);
var state_13699__$1 = (function (){var statearr_13702 = state_13699;
(statearr_13702[(7)] = inst_13664);

(statearr_13702[(8)] = inst_13663);

return statearr_13702;
})();
var statearr_13703_13735 = state_13699__$1;
(statearr_13703_13735[(2)] = null);

(statearr_13703_13735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (4))){
var inst_13667 = (state_13699[(9)]);
var inst_13667__$1 = (state_13699[(2)]);
var inst_13668 = (inst_13667__$1 == null);
var inst_13669 = cljs.core.not.call(null,inst_13668);
var state_13699__$1 = (function (){var statearr_13704 = state_13699;
(statearr_13704[(9)] = inst_13667__$1);

return statearr_13704;
})();
if(inst_13669){
var statearr_13705_13736 = state_13699__$1;
(statearr_13705_13736[(1)] = (5));

} else {
var statearr_13706_13737 = state_13699__$1;
(statearr_13706_13737[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (15))){
var inst_13689 = (state_13699[(2)]);
var state_13699__$1 = state_13699;
var statearr_13707_13738 = state_13699__$1;
(statearr_13707_13738[(2)] = inst_13689);

(statearr_13707_13738[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (13))){
var state_13699__$1 = state_13699;
var statearr_13708_13739 = state_13699__$1;
(statearr_13708_13739[(2)] = null);

(statearr_13708_13739[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (6))){
var inst_13664 = (state_13699[(7)]);
var inst_13685 = (inst_13664 > (0));
var state_13699__$1 = state_13699;
if(cljs.core.truth_(inst_13685)){
var statearr_13709_13740 = state_13699__$1;
(statearr_13709_13740[(1)] = (12));

} else {
var statearr_13710_13741 = state_13699__$1;
(statearr_13710_13741[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (3))){
var inst_13697 = (state_13699[(2)]);
var state_13699__$1 = state_13699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13699__$1,inst_13697);
} else {
if((state_val_13700 === (12))){
var inst_13663 = (state_13699[(8)]);
var inst_13687 = cljs.core.vec.call(null,inst_13663);
var state_13699__$1 = state_13699;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13699__$1,(15),out,inst_13687);
} else {
if((state_val_13700 === (2))){
var state_13699__$1 = state_13699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13699__$1,(4),ch);
} else {
if((state_val_13700 === (11))){
var inst_13679 = (state_13699[(2)]);
var inst_13680 = (new Array(n));
var inst_13663 = inst_13680;
var inst_13664 = (0);
var state_13699__$1 = (function (){var statearr_13711 = state_13699;
(statearr_13711[(7)] = inst_13664);

(statearr_13711[(8)] = inst_13663);

(statearr_13711[(10)] = inst_13679);

return statearr_13711;
})();
var statearr_13712_13742 = state_13699__$1;
(statearr_13712_13742[(2)] = null);

(statearr_13712_13742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (9))){
var inst_13663 = (state_13699[(8)]);
var inst_13677 = cljs.core.vec.call(null,inst_13663);
var state_13699__$1 = state_13699;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13699__$1,(11),out,inst_13677);
} else {
if((state_val_13700 === (5))){
var inst_13672 = (state_13699[(11)]);
var inst_13667 = (state_13699[(9)]);
var inst_13664 = (state_13699[(7)]);
var inst_13663 = (state_13699[(8)]);
var inst_13671 = (inst_13663[inst_13664] = inst_13667);
var inst_13672__$1 = (inst_13664 + (1));
var inst_13673 = (inst_13672__$1 < n);
var state_13699__$1 = (function (){var statearr_13713 = state_13699;
(statearr_13713[(12)] = inst_13671);

(statearr_13713[(11)] = inst_13672__$1);

return statearr_13713;
})();
if(cljs.core.truth_(inst_13673)){
var statearr_13714_13743 = state_13699__$1;
(statearr_13714_13743[(1)] = (8));

} else {
var statearr_13715_13744 = state_13699__$1;
(statearr_13715_13744[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (14))){
var inst_13692 = (state_13699[(2)]);
var inst_13693 = cljs.core.async.close_BANG_.call(null,out);
var state_13699__$1 = (function (){var statearr_13717 = state_13699;
(statearr_13717[(13)] = inst_13692);

return statearr_13717;
})();
var statearr_13718_13745 = state_13699__$1;
(statearr_13718_13745[(2)] = inst_13693);

(statearr_13718_13745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (10))){
var inst_13683 = (state_13699[(2)]);
var state_13699__$1 = state_13699;
var statearr_13719_13746 = state_13699__$1;
(statearr_13719_13746[(2)] = inst_13683);

(statearr_13719_13746[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13700 === (8))){
var inst_13672 = (state_13699[(11)]);
var inst_13663 = (state_13699[(8)]);
var tmp13716 = inst_13663;
var inst_13663__$1 = tmp13716;
var inst_13664 = inst_13672;
var state_13699__$1 = (function (){var statearr_13720 = state_13699;
(statearr_13720[(7)] = inst_13664);

(statearr_13720[(8)] = inst_13663__$1);

return statearr_13720;
})();
var statearr_13721_13747 = state_13699__$1;
(statearr_13721_13747[(2)] = null);

(statearr_13721_13747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___13733,out))
;
return ((function (switch__10961__auto__,c__11073__auto___13733,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_13725 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13725[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_13725[(1)] = (1));

return statearr_13725;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_13699){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_13699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e13726){if((e13726 instanceof Object)){
var ex__10965__auto__ = e13726;
var statearr_13727_13748 = state_13699;
(statearr_13727_13748[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13699);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13726;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13749 = state_13699;
state_13699 = G__13749;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_13699){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_13699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___13733,out))
})();
var state__11075__auto__ = (function (){var statearr_13728 = f__11074__auto__.call(null);
(statearr_13728[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___13733);

return statearr_13728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___13733,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13750 = [];
var len__5726__auto___13824 = arguments.length;
var i__5727__auto___13825 = (0);
while(true){
if((i__5727__auto___13825 < len__5726__auto___13824)){
args13750.push((arguments[i__5727__auto___13825]));

var G__13826 = (i__5727__auto___13825 + (1));
i__5727__auto___13825 = G__13826;
continue;
} else {
}
break;
}

var G__13752 = args13750.length;
switch (G__13752) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13750.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11073__auto___13828 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11073__auto___13828,out){
return (function (){
var f__11074__auto__ = (function (){var switch__10961__auto__ = ((function (c__11073__auto___13828,out){
return (function (state_13794){
var state_val_13795 = (state_13794[(1)]);
if((state_val_13795 === (7))){
var inst_13790 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
var statearr_13796_13829 = state_13794__$1;
(statearr_13796_13829[(2)] = inst_13790);

(statearr_13796_13829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (1))){
var inst_13753 = [];
var inst_13754 = inst_13753;
var inst_13755 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13794__$1 = (function (){var statearr_13797 = state_13794;
(statearr_13797[(7)] = inst_13755);

(statearr_13797[(8)] = inst_13754);

return statearr_13797;
})();
var statearr_13798_13830 = state_13794__$1;
(statearr_13798_13830[(2)] = null);

(statearr_13798_13830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (4))){
var inst_13758 = (state_13794[(9)]);
var inst_13758__$1 = (state_13794[(2)]);
var inst_13759 = (inst_13758__$1 == null);
var inst_13760 = cljs.core.not.call(null,inst_13759);
var state_13794__$1 = (function (){var statearr_13799 = state_13794;
(statearr_13799[(9)] = inst_13758__$1);

return statearr_13799;
})();
if(inst_13760){
var statearr_13800_13831 = state_13794__$1;
(statearr_13800_13831[(1)] = (5));

} else {
var statearr_13801_13832 = state_13794__$1;
(statearr_13801_13832[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (15))){
var inst_13784 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
var statearr_13802_13833 = state_13794__$1;
(statearr_13802_13833[(2)] = inst_13784);

(statearr_13802_13833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (13))){
var state_13794__$1 = state_13794;
var statearr_13803_13834 = state_13794__$1;
(statearr_13803_13834[(2)] = null);

(statearr_13803_13834[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (6))){
var inst_13754 = (state_13794[(8)]);
var inst_13779 = inst_13754.length;
var inst_13780 = (inst_13779 > (0));
var state_13794__$1 = state_13794;
if(cljs.core.truth_(inst_13780)){
var statearr_13804_13835 = state_13794__$1;
(statearr_13804_13835[(1)] = (12));

} else {
var statearr_13805_13836 = state_13794__$1;
(statearr_13805_13836[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (3))){
var inst_13792 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13794__$1,inst_13792);
} else {
if((state_val_13795 === (12))){
var inst_13754 = (state_13794[(8)]);
var inst_13782 = cljs.core.vec.call(null,inst_13754);
var state_13794__$1 = state_13794;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13794__$1,(15),out,inst_13782);
} else {
if((state_val_13795 === (2))){
var state_13794__$1 = state_13794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13794__$1,(4),ch);
} else {
if((state_val_13795 === (11))){
var inst_13762 = (state_13794[(10)]);
var inst_13758 = (state_13794[(9)]);
var inst_13772 = (state_13794[(2)]);
var inst_13773 = [];
var inst_13774 = inst_13773.push(inst_13758);
var inst_13754 = inst_13773;
var inst_13755 = inst_13762;
var state_13794__$1 = (function (){var statearr_13806 = state_13794;
(statearr_13806[(11)] = inst_13772);

(statearr_13806[(12)] = inst_13774);

(statearr_13806[(7)] = inst_13755);

(statearr_13806[(8)] = inst_13754);

return statearr_13806;
})();
var statearr_13807_13837 = state_13794__$1;
(statearr_13807_13837[(2)] = null);

(statearr_13807_13837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (9))){
var inst_13754 = (state_13794[(8)]);
var inst_13770 = cljs.core.vec.call(null,inst_13754);
var state_13794__$1 = state_13794;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13794__$1,(11),out,inst_13770);
} else {
if((state_val_13795 === (5))){
var inst_13762 = (state_13794[(10)]);
var inst_13758 = (state_13794[(9)]);
var inst_13755 = (state_13794[(7)]);
var inst_13762__$1 = f.call(null,inst_13758);
var inst_13763 = cljs.core._EQ_.call(null,inst_13762__$1,inst_13755);
var inst_13764 = cljs.core.keyword_identical_QMARK_.call(null,inst_13755,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13765 = (inst_13763) || (inst_13764);
var state_13794__$1 = (function (){var statearr_13808 = state_13794;
(statearr_13808[(10)] = inst_13762__$1);

return statearr_13808;
})();
if(cljs.core.truth_(inst_13765)){
var statearr_13809_13838 = state_13794__$1;
(statearr_13809_13838[(1)] = (8));

} else {
var statearr_13810_13839 = state_13794__$1;
(statearr_13810_13839[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (14))){
var inst_13787 = (state_13794[(2)]);
var inst_13788 = cljs.core.async.close_BANG_.call(null,out);
var state_13794__$1 = (function (){var statearr_13812 = state_13794;
(statearr_13812[(13)] = inst_13787);

return statearr_13812;
})();
var statearr_13813_13840 = state_13794__$1;
(statearr_13813_13840[(2)] = inst_13788);

(statearr_13813_13840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (10))){
var inst_13777 = (state_13794[(2)]);
var state_13794__$1 = state_13794;
var statearr_13814_13841 = state_13794__$1;
(statearr_13814_13841[(2)] = inst_13777);

(statearr_13814_13841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13795 === (8))){
var inst_13762 = (state_13794[(10)]);
var inst_13758 = (state_13794[(9)]);
var inst_13754 = (state_13794[(8)]);
var inst_13767 = inst_13754.push(inst_13758);
var tmp13811 = inst_13754;
var inst_13754__$1 = tmp13811;
var inst_13755 = inst_13762;
var state_13794__$1 = (function (){var statearr_13815 = state_13794;
(statearr_13815[(14)] = inst_13767);

(statearr_13815[(7)] = inst_13755);

(statearr_13815[(8)] = inst_13754__$1);

return statearr_13815;
})();
var statearr_13816_13842 = state_13794__$1;
(statearr_13816_13842[(2)] = null);

(statearr_13816_13842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11073__auto___13828,out))
;
return ((function (switch__10961__auto__,c__11073__auto___13828,out){
return (function() {
var cljs$core$async$state_machine__10962__auto__ = null;
var cljs$core$async$state_machine__10962__auto____0 = (function (){
var statearr_13820 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13820[(0)] = cljs$core$async$state_machine__10962__auto__);

(statearr_13820[(1)] = (1));

return statearr_13820;
});
var cljs$core$async$state_machine__10962__auto____1 = (function (state_13794){
while(true){
var ret_value__10963__auto__ = (function (){try{while(true){
var result__10964__auto__ = switch__10961__auto__.call(null,state_13794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10964__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10964__auto__;
}
break;
}
}catch (e13821){if((e13821 instanceof Object)){
var ex__10965__auto__ = e13821;
var statearr_13822_13843 = state_13794;
(statearr_13822_13843[(5)] = ex__10965__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13794);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13821;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10963__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13844 = state_13794;
state_13794 = G__13844;
continue;
} else {
return ret_value__10963__auto__;
}
break;
}
});
cljs$core$async$state_machine__10962__auto__ = function(state_13794){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10962__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10962__auto____1.call(this,state_13794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10962__auto____0;
cljs$core$async$state_machine__10962__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10962__auto____1;
return cljs$core$async$state_machine__10962__auto__;
})()
;})(switch__10961__auto__,c__11073__auto___13828,out))
})();
var state__11075__auto__ = (function (){var statearr_13823 = f__11074__auto__.call(null);
(statearr_13823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11073__auto___13828);

return statearr_13823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11075__auto__);
});})(c__11073__auto___13828,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1461916636778