// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18980 = [];
var len__5726__auto___18986 = arguments.length;
var i__5727__auto___18987 = (0);
while(true){
if((i__5727__auto___18987 < len__5726__auto___18986)){
args18980.push((arguments[i__5727__auto___18987]));

var G__18988 = (i__5727__auto___18987 + (1));
i__5727__auto___18987 = G__18988;
continue;
} else {
}
break;
}

var G__18982 = args18980.length;
switch (G__18982) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18980.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18983 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18983 = (function (f,blockable,meta18984){
this.f = f;
this.blockable = blockable;
this.meta18984 = meta18984;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18983.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18985,meta18984__$1){
var self__ = this;
var _18985__$1 = this;
return (new cljs.core.async.t_cljs$core$async18983(self__.f,self__.blockable,meta18984__$1));
});

cljs.core.async.t_cljs$core$async18983.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18985){
var self__ = this;
var _18985__$1 = this;
return self__.meta18984;
});

cljs.core.async.t_cljs$core$async18983.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18983.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18983.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18983.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18983.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18984","meta18984",1504802346,null)], null);
});

cljs.core.async.t_cljs$core$async18983.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18983.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18983";

cljs.core.async.t_cljs$core$async18983.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18983");
});

cljs.core.async.__GT_t_cljs$core$async18983 = (function cljs$core$async$__GT_t_cljs$core$async18983(f__$1,blockable__$1,meta18984){
return (new cljs.core.async.t_cljs$core$async18983(f__$1,blockable__$1,meta18984));
});

}

return (new cljs.core.async.t_cljs$core$async18983(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args18992 = [];
var len__5726__auto___18995 = arguments.length;
var i__5727__auto___18996 = (0);
while(true){
if((i__5727__auto___18996 < len__5726__auto___18995)){
args18992.push((arguments[i__5727__auto___18996]));

var G__18997 = (i__5727__auto___18996 + (1));
i__5727__auto___18996 = G__18997;
continue;
} else {
}
break;
}

var G__18994 = args18992.length;
switch (G__18994) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18992.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args18999 = [];
var len__5726__auto___19002 = arguments.length;
var i__5727__auto___19003 = (0);
while(true){
if((i__5727__auto___19003 < len__5726__auto___19002)){
args18999.push((arguments[i__5727__auto___19003]));

var G__19004 = (i__5727__auto___19003 + (1));
i__5727__auto___19003 = G__19004;
continue;
} else {
}
break;
}

var G__19001 = args18999.length;
switch (G__19001) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18999.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args19006 = [];
var len__5726__auto___19009 = arguments.length;
var i__5727__auto___19010 = (0);
while(true){
if((i__5727__auto___19010 < len__5726__auto___19009)){
args19006.push((arguments[i__5727__auto___19010]));

var G__19011 = (i__5727__auto___19010 + (1));
i__5727__auto___19010 = G__19011;
continue;
} else {
}
break;
}

var G__19008 = args19006.length;
switch (G__19008) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19006.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_19013 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_19013);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_19013,ret){
return (function (){
return fn1.call(null,val_19013);
});})(val_19013,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args19014 = [];
var len__5726__auto___19017 = arguments.length;
var i__5727__auto___19018 = (0);
while(true){
if((i__5727__auto___19018 < len__5726__auto___19017)){
args19014.push((arguments[i__5727__auto___19018]));

var G__19019 = (i__5727__auto___19018 + (1));
i__5727__auto___19018 = G__19019;
continue;
} else {
}
break;
}

var G__19016 = args19014.length;
switch (G__19016) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19014.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___19021 = n;
var x_19022 = (0);
while(true){
if((x_19022 < n__5571__auto___19021)){
(a[x_19022] = (0));

var G__19023 = (x_19022 + (1));
x_19022 = G__19023;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__19024 = (i + (1));
i = G__19024;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async19028 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19028 = (function (alt_flag,flag,meta19029){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta19029 = meta19029;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19028.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_19030,meta19029__$1){
var self__ = this;
var _19030__$1 = this;
return (new cljs.core.async.t_cljs$core$async19028(self__.alt_flag,self__.flag,meta19029__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async19028.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_19030){
var self__ = this;
var _19030__$1 = this;
return self__.meta19029;
});})(flag))
;

cljs.core.async.t_cljs$core$async19028.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19028.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async19028.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19028.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19028.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19029","meta19029",-711223502,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async19028.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19028.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19028";

cljs.core.async.t_cljs$core$async19028.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19028");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async19028 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19028(alt_flag__$1,flag__$1,meta19029){
return (new cljs.core.async.t_cljs$core$async19028(alt_flag__$1,flag__$1,meta19029));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async19028(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async19034 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19034 = (function (alt_handler,flag,cb,meta19035){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta19035 = meta19035;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19036,meta19035__$1){
var self__ = this;
var _19036__$1 = this;
return (new cljs.core.async.t_cljs$core$async19034(self__.alt_handler,self__.flag,self__.cb,meta19035__$1));
});

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19036){
var self__ = this;
var _19036__$1 = this;
return self__.meta19035;
});

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async19034.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19035","meta19035",-1047137705,null)], null);
});

cljs.core.async.t_cljs$core$async19034.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19034.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19034";

cljs.core.async.t_cljs$core$async19034.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19034");
});

cljs.core.async.__GT_t_cljs$core$async19034 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19034(alt_handler__$1,flag__$1,cb__$1,meta19035){
return (new cljs.core.async.t_cljs$core$async19034(alt_handler__$1,flag__$1,cb__$1,meta19035));
});

}

return (new cljs.core.async.t_cljs$core$async19034(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19037_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19037_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19038_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19038_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19039 = (i + (1));
i = G__19039;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___19045 = arguments.length;
var i__5727__auto___19046 = (0);
while(true){
if((i__5727__auto___19046 < len__5726__auto___19045)){
args__5733__auto__.push((arguments[i__5727__auto___19046]));

var G__19047 = (i__5727__auto___19046 + (1));
i__5727__auto___19046 = G__19047;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19042){
var map__19043 = p__19042;
var map__19043__$1 = ((((!((map__19043 == null)))?((((map__19043.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19043.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19043):map__19043);
var opts = map__19043__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19040){
var G__19041 = cljs.core.first.call(null,seq19040);
var seq19040__$1 = cljs.core.next.call(null,seq19040);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19041,seq19040__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args19048 = [];
var len__5726__auto___19098 = arguments.length;
var i__5727__auto___19099 = (0);
while(true){
if((i__5727__auto___19099 < len__5726__auto___19098)){
args19048.push((arguments[i__5727__auto___19099]));

var G__19100 = (i__5727__auto___19099 + (1));
i__5727__auto___19099 = G__19100;
continue;
} else {
}
break;
}

var G__19050 = args19048.length;
switch (G__19050) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19048.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11071__auto___19102 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___19102){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___19102){
return (function (state_19074){
var state_val_19075 = (state_19074[(1)]);
if((state_val_19075 === (7))){
var inst_19070 = (state_19074[(2)]);
var state_19074__$1 = state_19074;
var statearr_19076_19103 = state_19074__$1;
(statearr_19076_19103[(2)] = inst_19070);

(statearr_19076_19103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (1))){
var state_19074__$1 = state_19074;
var statearr_19077_19104 = state_19074__$1;
(statearr_19077_19104[(2)] = null);

(statearr_19077_19104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (4))){
var inst_19053 = (state_19074[(7)]);
var inst_19053__$1 = (state_19074[(2)]);
var inst_19054 = (inst_19053__$1 == null);
var state_19074__$1 = (function (){var statearr_19078 = state_19074;
(statearr_19078[(7)] = inst_19053__$1);

return statearr_19078;
})();
if(cljs.core.truth_(inst_19054)){
var statearr_19079_19105 = state_19074__$1;
(statearr_19079_19105[(1)] = (5));

} else {
var statearr_19080_19106 = state_19074__$1;
(statearr_19080_19106[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (13))){
var state_19074__$1 = state_19074;
var statearr_19081_19107 = state_19074__$1;
(statearr_19081_19107[(2)] = null);

(statearr_19081_19107[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (6))){
var inst_19053 = (state_19074[(7)]);
var state_19074__$1 = state_19074;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19074__$1,(11),to,inst_19053);
} else {
if((state_val_19075 === (3))){
var inst_19072 = (state_19074[(2)]);
var state_19074__$1 = state_19074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19074__$1,inst_19072);
} else {
if((state_val_19075 === (12))){
var state_19074__$1 = state_19074;
var statearr_19082_19108 = state_19074__$1;
(statearr_19082_19108[(2)] = null);

(statearr_19082_19108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (2))){
var state_19074__$1 = state_19074;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19074__$1,(4),from);
} else {
if((state_val_19075 === (11))){
var inst_19063 = (state_19074[(2)]);
var state_19074__$1 = state_19074;
if(cljs.core.truth_(inst_19063)){
var statearr_19083_19109 = state_19074__$1;
(statearr_19083_19109[(1)] = (12));

} else {
var statearr_19084_19110 = state_19074__$1;
(statearr_19084_19110[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (9))){
var state_19074__$1 = state_19074;
var statearr_19085_19111 = state_19074__$1;
(statearr_19085_19111[(2)] = null);

(statearr_19085_19111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (5))){
var state_19074__$1 = state_19074;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19086_19112 = state_19074__$1;
(statearr_19086_19112[(1)] = (8));

} else {
var statearr_19087_19113 = state_19074__$1;
(statearr_19087_19113[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (14))){
var inst_19068 = (state_19074[(2)]);
var state_19074__$1 = state_19074;
var statearr_19088_19114 = state_19074__$1;
(statearr_19088_19114[(2)] = inst_19068);

(statearr_19088_19114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (10))){
var inst_19060 = (state_19074[(2)]);
var state_19074__$1 = state_19074;
var statearr_19089_19115 = state_19074__$1;
(statearr_19089_19115[(2)] = inst_19060);

(statearr_19089_19115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19075 === (8))){
var inst_19057 = cljs.core.async.close_BANG_.call(null,to);
var state_19074__$1 = state_19074;
var statearr_19090_19116 = state_19074__$1;
(statearr_19090_19116[(2)] = inst_19057);

(statearr_19090_19116[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___19102))
;
return ((function (switch__10959__auto__,c__11071__auto___19102){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_19094 = [null,null,null,null,null,null,null,null];
(statearr_19094[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_19094[(1)] = (1));

return statearr_19094;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_19074){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19095){if((e19095 instanceof Object)){
var ex__10963__auto__ = e19095;
var statearr_19096_19117 = state_19074;
(statearr_19096_19117[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19074);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19095;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19118 = state_19074;
state_19074 = G__19118;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_19074){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_19074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___19102))
})();
var state__11073__auto__ = (function (){var statearr_19097 = f__11072__auto__.call(null);
(statearr_19097[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___19102);

return statearr_19097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___19102))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19302){
var vec__19303 = p__19302;
var v = cljs.core.nth.call(null,vec__19303,(0),null);
var p = cljs.core.nth.call(null,vec__19303,(1),null);
var job = vec__19303;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11071__auto___19485 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___19485,res,vec__19303,v,p,job,jobs,results){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___19485,res,vec__19303,v,p,job,jobs,results){
return (function (state_19308){
var state_val_19309 = (state_19308[(1)]);
if((state_val_19309 === (1))){
var state_19308__$1 = state_19308;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19308__$1,(2),res,v);
} else {
if((state_val_19309 === (2))){
var inst_19305 = (state_19308[(2)]);
var inst_19306 = cljs.core.async.close_BANG_.call(null,res);
var state_19308__$1 = (function (){var statearr_19310 = state_19308;
(statearr_19310[(7)] = inst_19305);

return statearr_19310;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19308__$1,inst_19306);
} else {
return null;
}
}
});})(c__11071__auto___19485,res,vec__19303,v,p,job,jobs,results))
;
return ((function (switch__10959__auto__,c__11071__auto___19485,res,vec__19303,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_19314 = [null,null,null,null,null,null,null,null];
(statearr_19314[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_19314[(1)] = (1));

return statearr_19314;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_19308){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19308);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19315){if((e19315 instanceof Object)){
var ex__10963__auto__ = e19315;
var statearr_19316_19486 = state_19308;
(statearr_19316_19486[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19308);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19315;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19487 = state_19308;
state_19308 = G__19487;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_19308){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_19308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___19485,res,vec__19303,v,p,job,jobs,results))
})();
var state__11073__auto__ = (function (){var statearr_19317 = f__11072__auto__.call(null);
(statearr_19317[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___19485);

return statearr_19317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___19485,res,vec__19303,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19318){
var vec__19319 = p__19318;
var v = cljs.core.nth.call(null,vec__19319,(0),null);
var p = cljs.core.nth.call(null,vec__19319,(1),null);
var job = vec__19319;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___19488 = n;
var __19489 = (0);
while(true){
if((__19489 < n__5571__auto___19488)){
var G__19320_19490 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19320_19490) {
case "compute":
var c__11071__auto___19492 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19489,c__11071__auto___19492,G__19320_19490,n__5571__auto___19488,jobs,results,process,async){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (__19489,c__11071__auto___19492,G__19320_19490,n__5571__auto___19488,jobs,results,process,async){
return (function (state_19333){
var state_val_19334 = (state_19333[(1)]);
if((state_val_19334 === (1))){
var state_19333__$1 = state_19333;
var statearr_19335_19493 = state_19333__$1;
(statearr_19335_19493[(2)] = null);

(statearr_19335_19493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19334 === (2))){
var state_19333__$1 = state_19333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19333__$1,(4),jobs);
} else {
if((state_val_19334 === (3))){
var inst_19331 = (state_19333[(2)]);
var state_19333__$1 = state_19333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19333__$1,inst_19331);
} else {
if((state_val_19334 === (4))){
var inst_19323 = (state_19333[(2)]);
var inst_19324 = process.call(null,inst_19323);
var state_19333__$1 = state_19333;
if(cljs.core.truth_(inst_19324)){
var statearr_19336_19494 = state_19333__$1;
(statearr_19336_19494[(1)] = (5));

} else {
var statearr_19337_19495 = state_19333__$1;
(statearr_19337_19495[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19334 === (5))){
var state_19333__$1 = state_19333;
var statearr_19338_19496 = state_19333__$1;
(statearr_19338_19496[(2)] = null);

(statearr_19338_19496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19334 === (6))){
var state_19333__$1 = state_19333;
var statearr_19339_19497 = state_19333__$1;
(statearr_19339_19497[(2)] = null);

(statearr_19339_19497[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19334 === (7))){
var inst_19329 = (state_19333[(2)]);
var state_19333__$1 = state_19333;
var statearr_19340_19498 = state_19333__$1;
(statearr_19340_19498[(2)] = inst_19329);

(statearr_19340_19498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19489,c__11071__auto___19492,G__19320_19490,n__5571__auto___19488,jobs,results,process,async))
;
return ((function (__19489,switch__10959__auto__,c__11071__auto___19492,G__19320_19490,n__5571__auto___19488,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_19344 = [null,null,null,null,null,null,null];
(statearr_19344[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_19344[(1)] = (1));

return statearr_19344;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_19333){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19345){if((e19345 instanceof Object)){
var ex__10963__auto__ = e19345;
var statearr_19346_19499 = state_19333;
(statearr_19346_19499[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19333);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19345;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19500 = state_19333;
state_19333 = G__19500;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_19333){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_19333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(__19489,switch__10959__auto__,c__11071__auto___19492,G__19320_19490,n__5571__auto___19488,jobs,results,process,async))
})();
var state__11073__auto__ = (function (){var statearr_19347 = f__11072__auto__.call(null);
(statearr_19347[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___19492);

return statearr_19347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(__19489,c__11071__auto___19492,G__19320_19490,n__5571__auto___19488,jobs,results,process,async))
);


break;
case "async":
var c__11071__auto___19501 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19489,c__11071__auto___19501,G__19320_19490,n__5571__auto___19488,jobs,results,process,async){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (__19489,c__11071__auto___19501,G__19320_19490,n__5571__auto___19488,jobs,results,process,async){
return (function (state_19360){
var state_val_19361 = (state_19360[(1)]);
if((state_val_19361 === (1))){
var state_19360__$1 = state_19360;
var statearr_19362_19502 = state_19360__$1;
(statearr_19362_19502[(2)] = null);

(statearr_19362_19502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19361 === (2))){
var state_19360__$1 = state_19360;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19360__$1,(4),jobs);
} else {
if((state_val_19361 === (3))){
var inst_19358 = (state_19360[(2)]);
var state_19360__$1 = state_19360;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19360__$1,inst_19358);
} else {
if((state_val_19361 === (4))){
var inst_19350 = (state_19360[(2)]);
var inst_19351 = async.call(null,inst_19350);
var state_19360__$1 = state_19360;
if(cljs.core.truth_(inst_19351)){
var statearr_19363_19503 = state_19360__$1;
(statearr_19363_19503[(1)] = (5));

} else {
var statearr_19364_19504 = state_19360__$1;
(statearr_19364_19504[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19361 === (5))){
var state_19360__$1 = state_19360;
var statearr_19365_19505 = state_19360__$1;
(statearr_19365_19505[(2)] = null);

(statearr_19365_19505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19361 === (6))){
var state_19360__$1 = state_19360;
var statearr_19366_19506 = state_19360__$1;
(statearr_19366_19506[(2)] = null);

(statearr_19366_19506[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19361 === (7))){
var inst_19356 = (state_19360[(2)]);
var state_19360__$1 = state_19360;
var statearr_19367_19507 = state_19360__$1;
(statearr_19367_19507[(2)] = inst_19356);

(statearr_19367_19507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19489,c__11071__auto___19501,G__19320_19490,n__5571__auto___19488,jobs,results,process,async))
;
return ((function (__19489,switch__10959__auto__,c__11071__auto___19501,G__19320_19490,n__5571__auto___19488,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_19371 = [null,null,null,null,null,null,null];
(statearr_19371[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_19371[(1)] = (1));

return statearr_19371;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_19360){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19360);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19372){if((e19372 instanceof Object)){
var ex__10963__auto__ = e19372;
var statearr_19373_19508 = state_19360;
(statearr_19373_19508[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19360);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19372;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19509 = state_19360;
state_19360 = G__19509;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_19360){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_19360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(__19489,switch__10959__auto__,c__11071__auto___19501,G__19320_19490,n__5571__auto___19488,jobs,results,process,async))
})();
var state__11073__auto__ = (function (){var statearr_19374 = f__11072__auto__.call(null);
(statearr_19374[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___19501);

return statearr_19374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(__19489,c__11071__auto___19501,G__19320_19490,n__5571__auto___19488,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19510 = (__19489 + (1));
__19489 = G__19510;
continue;
} else {
}
break;
}

var c__11071__auto___19511 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___19511,jobs,results,process,async){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___19511,jobs,results,process,async){
return (function (state_19396){
var state_val_19397 = (state_19396[(1)]);
if((state_val_19397 === (1))){
var state_19396__$1 = state_19396;
var statearr_19398_19512 = state_19396__$1;
(statearr_19398_19512[(2)] = null);

(statearr_19398_19512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (2))){
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19396__$1,(4),from);
} else {
if((state_val_19397 === (3))){
var inst_19394 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19396__$1,inst_19394);
} else {
if((state_val_19397 === (4))){
var inst_19377 = (state_19396[(7)]);
var inst_19377__$1 = (state_19396[(2)]);
var inst_19378 = (inst_19377__$1 == null);
var state_19396__$1 = (function (){var statearr_19399 = state_19396;
(statearr_19399[(7)] = inst_19377__$1);

return statearr_19399;
})();
if(cljs.core.truth_(inst_19378)){
var statearr_19400_19513 = state_19396__$1;
(statearr_19400_19513[(1)] = (5));

} else {
var statearr_19401_19514 = state_19396__$1;
(statearr_19401_19514[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (5))){
var inst_19380 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19396__$1 = state_19396;
var statearr_19402_19515 = state_19396__$1;
(statearr_19402_19515[(2)] = inst_19380);

(statearr_19402_19515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (6))){
var inst_19377 = (state_19396[(7)]);
var inst_19382 = (state_19396[(8)]);
var inst_19382__$1 = cljs.core.async.chan.call(null,(1));
var inst_19383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19384 = [inst_19377,inst_19382__$1];
var inst_19385 = (new cljs.core.PersistentVector(null,2,(5),inst_19383,inst_19384,null));
var state_19396__$1 = (function (){var statearr_19403 = state_19396;
(statearr_19403[(8)] = inst_19382__$1);

return statearr_19403;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19396__$1,(8),jobs,inst_19385);
} else {
if((state_val_19397 === (7))){
var inst_19392 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19404_19516 = state_19396__$1;
(statearr_19404_19516[(2)] = inst_19392);

(statearr_19404_19516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (8))){
var inst_19382 = (state_19396[(8)]);
var inst_19387 = (state_19396[(2)]);
var state_19396__$1 = (function (){var statearr_19405 = state_19396;
(statearr_19405[(9)] = inst_19387);

return statearr_19405;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19396__$1,(9),results,inst_19382);
} else {
if((state_val_19397 === (9))){
var inst_19389 = (state_19396[(2)]);
var state_19396__$1 = (function (){var statearr_19406 = state_19396;
(statearr_19406[(10)] = inst_19389);

return statearr_19406;
})();
var statearr_19407_19517 = state_19396__$1;
(statearr_19407_19517[(2)] = null);

(statearr_19407_19517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___19511,jobs,results,process,async))
;
return ((function (switch__10959__auto__,c__11071__auto___19511,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_19411 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19411[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_19411[(1)] = (1));

return statearr_19411;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_19396){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19412){if((e19412 instanceof Object)){
var ex__10963__auto__ = e19412;
var statearr_19413_19518 = state_19396;
(statearr_19413_19518[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19412;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19519 = state_19396;
state_19396 = G__19519;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_19396){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_19396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___19511,jobs,results,process,async))
})();
var state__11073__auto__ = (function (){var statearr_19414 = f__11072__auto__.call(null);
(statearr_19414[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___19511);

return statearr_19414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___19511,jobs,results,process,async))
);


var c__11071__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto__,jobs,results,process,async){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto__,jobs,results,process,async){
return (function (state_19452){
var state_val_19453 = (state_19452[(1)]);
if((state_val_19453 === (7))){
var inst_19448 = (state_19452[(2)]);
var state_19452__$1 = state_19452;
var statearr_19454_19520 = state_19452__$1;
(statearr_19454_19520[(2)] = inst_19448);

(statearr_19454_19520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (20))){
var state_19452__$1 = state_19452;
var statearr_19455_19521 = state_19452__$1;
(statearr_19455_19521[(2)] = null);

(statearr_19455_19521[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (1))){
var state_19452__$1 = state_19452;
var statearr_19456_19522 = state_19452__$1;
(statearr_19456_19522[(2)] = null);

(statearr_19456_19522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (4))){
var inst_19417 = (state_19452[(7)]);
var inst_19417__$1 = (state_19452[(2)]);
var inst_19418 = (inst_19417__$1 == null);
var state_19452__$1 = (function (){var statearr_19457 = state_19452;
(statearr_19457[(7)] = inst_19417__$1);

return statearr_19457;
})();
if(cljs.core.truth_(inst_19418)){
var statearr_19458_19523 = state_19452__$1;
(statearr_19458_19523[(1)] = (5));

} else {
var statearr_19459_19524 = state_19452__$1;
(statearr_19459_19524[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (15))){
var inst_19430 = (state_19452[(8)]);
var state_19452__$1 = state_19452;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19452__$1,(18),to,inst_19430);
} else {
if((state_val_19453 === (21))){
var inst_19443 = (state_19452[(2)]);
var state_19452__$1 = state_19452;
var statearr_19460_19525 = state_19452__$1;
(statearr_19460_19525[(2)] = inst_19443);

(statearr_19460_19525[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (13))){
var inst_19445 = (state_19452[(2)]);
var state_19452__$1 = (function (){var statearr_19461 = state_19452;
(statearr_19461[(9)] = inst_19445);

return statearr_19461;
})();
var statearr_19462_19526 = state_19452__$1;
(statearr_19462_19526[(2)] = null);

(statearr_19462_19526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (6))){
var inst_19417 = (state_19452[(7)]);
var state_19452__$1 = state_19452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19452__$1,(11),inst_19417);
} else {
if((state_val_19453 === (17))){
var inst_19438 = (state_19452[(2)]);
var state_19452__$1 = state_19452;
if(cljs.core.truth_(inst_19438)){
var statearr_19463_19527 = state_19452__$1;
(statearr_19463_19527[(1)] = (19));

} else {
var statearr_19464_19528 = state_19452__$1;
(statearr_19464_19528[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (3))){
var inst_19450 = (state_19452[(2)]);
var state_19452__$1 = state_19452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19452__$1,inst_19450);
} else {
if((state_val_19453 === (12))){
var inst_19427 = (state_19452[(10)]);
var state_19452__$1 = state_19452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19452__$1,(14),inst_19427);
} else {
if((state_val_19453 === (2))){
var state_19452__$1 = state_19452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19452__$1,(4),results);
} else {
if((state_val_19453 === (19))){
var state_19452__$1 = state_19452;
var statearr_19465_19529 = state_19452__$1;
(statearr_19465_19529[(2)] = null);

(statearr_19465_19529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (11))){
var inst_19427 = (state_19452[(2)]);
var state_19452__$1 = (function (){var statearr_19466 = state_19452;
(statearr_19466[(10)] = inst_19427);

return statearr_19466;
})();
var statearr_19467_19530 = state_19452__$1;
(statearr_19467_19530[(2)] = null);

(statearr_19467_19530[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (9))){
var state_19452__$1 = state_19452;
var statearr_19468_19531 = state_19452__$1;
(statearr_19468_19531[(2)] = null);

(statearr_19468_19531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (5))){
var state_19452__$1 = state_19452;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19469_19532 = state_19452__$1;
(statearr_19469_19532[(1)] = (8));

} else {
var statearr_19470_19533 = state_19452__$1;
(statearr_19470_19533[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (14))){
var inst_19430 = (state_19452[(8)]);
var inst_19432 = (state_19452[(11)]);
var inst_19430__$1 = (state_19452[(2)]);
var inst_19431 = (inst_19430__$1 == null);
var inst_19432__$1 = cljs.core.not.call(null,inst_19431);
var state_19452__$1 = (function (){var statearr_19471 = state_19452;
(statearr_19471[(8)] = inst_19430__$1);

(statearr_19471[(11)] = inst_19432__$1);

return statearr_19471;
})();
if(inst_19432__$1){
var statearr_19472_19534 = state_19452__$1;
(statearr_19472_19534[(1)] = (15));

} else {
var statearr_19473_19535 = state_19452__$1;
(statearr_19473_19535[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (16))){
var inst_19432 = (state_19452[(11)]);
var state_19452__$1 = state_19452;
var statearr_19474_19536 = state_19452__$1;
(statearr_19474_19536[(2)] = inst_19432);

(statearr_19474_19536[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (10))){
var inst_19424 = (state_19452[(2)]);
var state_19452__$1 = state_19452;
var statearr_19475_19537 = state_19452__$1;
(statearr_19475_19537[(2)] = inst_19424);

(statearr_19475_19537[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (18))){
var inst_19435 = (state_19452[(2)]);
var state_19452__$1 = state_19452;
var statearr_19476_19538 = state_19452__$1;
(statearr_19476_19538[(2)] = inst_19435);

(statearr_19476_19538[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19453 === (8))){
var inst_19421 = cljs.core.async.close_BANG_.call(null,to);
var state_19452__$1 = state_19452;
var statearr_19477_19539 = state_19452__$1;
(statearr_19477_19539[(2)] = inst_19421);

(statearr_19477_19539[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto__,jobs,results,process,async))
;
return ((function (switch__10959__auto__,c__11071__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_19481 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19481[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_19481[(1)] = (1));

return statearr_19481;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_19452){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19482){if((e19482 instanceof Object)){
var ex__10963__auto__ = e19482;
var statearr_19483_19540 = state_19452;
(statearr_19483_19540[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19452);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19482;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19541 = state_19452;
state_19452 = G__19541;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_19452){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_19452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto__,jobs,results,process,async))
})();
var state__11073__auto__ = (function (){var statearr_19484 = f__11072__auto__.call(null);
(statearr_19484[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto__);

return statearr_19484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto__,jobs,results,process,async))
);

return c__11071__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19542 = [];
var len__5726__auto___19545 = arguments.length;
var i__5727__auto___19546 = (0);
while(true){
if((i__5727__auto___19546 < len__5726__auto___19545)){
args19542.push((arguments[i__5727__auto___19546]));

var G__19547 = (i__5727__auto___19546 + (1));
i__5727__auto___19546 = G__19547;
continue;
} else {
}
break;
}

var G__19544 = args19542.length;
switch (G__19544) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19542.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19549 = [];
var len__5726__auto___19552 = arguments.length;
var i__5727__auto___19553 = (0);
while(true){
if((i__5727__auto___19553 < len__5726__auto___19552)){
args19549.push((arguments[i__5727__auto___19553]));

var G__19554 = (i__5727__auto___19553 + (1));
i__5727__auto___19553 = G__19554;
continue;
} else {
}
break;
}

var G__19551 = args19549.length;
switch (G__19551) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19549.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19556 = [];
var len__5726__auto___19609 = arguments.length;
var i__5727__auto___19610 = (0);
while(true){
if((i__5727__auto___19610 < len__5726__auto___19609)){
args19556.push((arguments[i__5727__auto___19610]));

var G__19611 = (i__5727__auto___19610 + (1));
i__5727__auto___19610 = G__19611;
continue;
} else {
}
break;
}

var G__19558 = args19556.length;
switch (G__19558) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19556.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11071__auto___19613 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___19613,tc,fc){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___19613,tc,fc){
return (function (state_19584){
var state_val_19585 = (state_19584[(1)]);
if((state_val_19585 === (7))){
var inst_19580 = (state_19584[(2)]);
var state_19584__$1 = state_19584;
var statearr_19586_19614 = state_19584__$1;
(statearr_19586_19614[(2)] = inst_19580);

(statearr_19586_19614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (1))){
var state_19584__$1 = state_19584;
var statearr_19587_19615 = state_19584__$1;
(statearr_19587_19615[(2)] = null);

(statearr_19587_19615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (4))){
var inst_19561 = (state_19584[(7)]);
var inst_19561__$1 = (state_19584[(2)]);
var inst_19562 = (inst_19561__$1 == null);
var state_19584__$1 = (function (){var statearr_19588 = state_19584;
(statearr_19588[(7)] = inst_19561__$1);

return statearr_19588;
})();
if(cljs.core.truth_(inst_19562)){
var statearr_19589_19616 = state_19584__$1;
(statearr_19589_19616[(1)] = (5));

} else {
var statearr_19590_19617 = state_19584__$1;
(statearr_19590_19617[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (13))){
var state_19584__$1 = state_19584;
var statearr_19591_19618 = state_19584__$1;
(statearr_19591_19618[(2)] = null);

(statearr_19591_19618[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (6))){
var inst_19561 = (state_19584[(7)]);
var inst_19567 = p.call(null,inst_19561);
var state_19584__$1 = state_19584;
if(cljs.core.truth_(inst_19567)){
var statearr_19592_19619 = state_19584__$1;
(statearr_19592_19619[(1)] = (9));

} else {
var statearr_19593_19620 = state_19584__$1;
(statearr_19593_19620[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (3))){
var inst_19582 = (state_19584[(2)]);
var state_19584__$1 = state_19584;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19584__$1,inst_19582);
} else {
if((state_val_19585 === (12))){
var state_19584__$1 = state_19584;
var statearr_19594_19621 = state_19584__$1;
(statearr_19594_19621[(2)] = null);

(statearr_19594_19621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (2))){
var state_19584__$1 = state_19584;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19584__$1,(4),ch);
} else {
if((state_val_19585 === (11))){
var inst_19561 = (state_19584[(7)]);
var inst_19571 = (state_19584[(2)]);
var state_19584__$1 = state_19584;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19584__$1,(8),inst_19571,inst_19561);
} else {
if((state_val_19585 === (9))){
var state_19584__$1 = state_19584;
var statearr_19595_19622 = state_19584__$1;
(statearr_19595_19622[(2)] = tc);

(statearr_19595_19622[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (5))){
var inst_19564 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19565 = cljs.core.async.close_BANG_.call(null,fc);
var state_19584__$1 = (function (){var statearr_19596 = state_19584;
(statearr_19596[(8)] = inst_19564);

return statearr_19596;
})();
var statearr_19597_19623 = state_19584__$1;
(statearr_19597_19623[(2)] = inst_19565);

(statearr_19597_19623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (14))){
var inst_19578 = (state_19584[(2)]);
var state_19584__$1 = state_19584;
var statearr_19598_19624 = state_19584__$1;
(statearr_19598_19624[(2)] = inst_19578);

(statearr_19598_19624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (10))){
var state_19584__$1 = state_19584;
var statearr_19599_19625 = state_19584__$1;
(statearr_19599_19625[(2)] = fc);

(statearr_19599_19625[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19585 === (8))){
var inst_19573 = (state_19584[(2)]);
var state_19584__$1 = state_19584;
if(cljs.core.truth_(inst_19573)){
var statearr_19600_19626 = state_19584__$1;
(statearr_19600_19626[(1)] = (12));

} else {
var statearr_19601_19627 = state_19584__$1;
(statearr_19601_19627[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___19613,tc,fc))
;
return ((function (switch__10959__auto__,c__11071__auto___19613,tc,fc){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_19605 = [null,null,null,null,null,null,null,null,null];
(statearr_19605[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_19605[(1)] = (1));

return statearr_19605;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_19584){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19606){if((e19606 instanceof Object)){
var ex__10963__auto__ = e19606;
var statearr_19607_19628 = state_19584;
(statearr_19607_19628[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19584);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19606;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19629 = state_19584;
state_19584 = G__19629;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_19584){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_19584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___19613,tc,fc))
})();
var state__11073__auto__ = (function (){var statearr_19608 = f__11072__auto__.call(null);
(statearr_19608[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___19613);

return statearr_19608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___19613,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11071__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto__){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto__){
return (function (state_19693){
var state_val_19694 = (state_19693[(1)]);
if((state_val_19694 === (7))){
var inst_19689 = (state_19693[(2)]);
var state_19693__$1 = state_19693;
var statearr_19695_19716 = state_19693__$1;
(statearr_19695_19716[(2)] = inst_19689);

(statearr_19695_19716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19694 === (1))){
var inst_19673 = init;
var state_19693__$1 = (function (){var statearr_19696 = state_19693;
(statearr_19696[(7)] = inst_19673);

return statearr_19696;
})();
var statearr_19697_19717 = state_19693__$1;
(statearr_19697_19717[(2)] = null);

(statearr_19697_19717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19694 === (4))){
var inst_19676 = (state_19693[(8)]);
var inst_19676__$1 = (state_19693[(2)]);
var inst_19677 = (inst_19676__$1 == null);
var state_19693__$1 = (function (){var statearr_19698 = state_19693;
(statearr_19698[(8)] = inst_19676__$1);

return statearr_19698;
})();
if(cljs.core.truth_(inst_19677)){
var statearr_19699_19718 = state_19693__$1;
(statearr_19699_19718[(1)] = (5));

} else {
var statearr_19700_19719 = state_19693__$1;
(statearr_19700_19719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19694 === (6))){
var inst_19680 = (state_19693[(9)]);
var inst_19673 = (state_19693[(7)]);
var inst_19676 = (state_19693[(8)]);
var inst_19680__$1 = f.call(null,inst_19673,inst_19676);
var inst_19681 = cljs.core.reduced_QMARK_.call(null,inst_19680__$1);
var state_19693__$1 = (function (){var statearr_19701 = state_19693;
(statearr_19701[(9)] = inst_19680__$1);

return statearr_19701;
})();
if(inst_19681){
var statearr_19702_19720 = state_19693__$1;
(statearr_19702_19720[(1)] = (8));

} else {
var statearr_19703_19721 = state_19693__$1;
(statearr_19703_19721[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19694 === (3))){
var inst_19691 = (state_19693[(2)]);
var state_19693__$1 = state_19693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19693__$1,inst_19691);
} else {
if((state_val_19694 === (2))){
var state_19693__$1 = state_19693;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19693__$1,(4),ch);
} else {
if((state_val_19694 === (9))){
var inst_19680 = (state_19693[(9)]);
var inst_19673 = inst_19680;
var state_19693__$1 = (function (){var statearr_19704 = state_19693;
(statearr_19704[(7)] = inst_19673);

return statearr_19704;
})();
var statearr_19705_19722 = state_19693__$1;
(statearr_19705_19722[(2)] = null);

(statearr_19705_19722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19694 === (5))){
var inst_19673 = (state_19693[(7)]);
var state_19693__$1 = state_19693;
var statearr_19706_19723 = state_19693__$1;
(statearr_19706_19723[(2)] = inst_19673);

(statearr_19706_19723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19694 === (10))){
var inst_19687 = (state_19693[(2)]);
var state_19693__$1 = state_19693;
var statearr_19707_19724 = state_19693__$1;
(statearr_19707_19724[(2)] = inst_19687);

(statearr_19707_19724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19694 === (8))){
var inst_19680 = (state_19693[(9)]);
var inst_19683 = cljs.core.deref.call(null,inst_19680);
var state_19693__$1 = state_19693;
var statearr_19708_19725 = state_19693__$1;
(statearr_19708_19725[(2)] = inst_19683);

(statearr_19708_19725[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto__))
;
return ((function (switch__10959__auto__,c__11071__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10960__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10960__auto____0 = (function (){
var statearr_19712 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19712[(0)] = cljs$core$async$reduce_$_state_machine__10960__auto__);

(statearr_19712[(1)] = (1));

return statearr_19712;
});
var cljs$core$async$reduce_$_state_machine__10960__auto____1 = (function (state_19693){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19713){if((e19713 instanceof Object)){
var ex__10963__auto__ = e19713;
var statearr_19714_19726 = state_19693;
(statearr_19714_19726[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19693);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19727 = state_19693;
state_19693 = G__19727;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10960__auto__ = function(state_19693){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10960__auto____1.call(this,state_19693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10960__auto____0;
cljs$core$async$reduce_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10960__auto____1;
return cljs$core$async$reduce_$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto__))
})();
var state__11073__auto__ = (function (){var statearr_19715 = f__11072__auto__.call(null);
(statearr_19715[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto__);

return statearr_19715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto__))
);

return c__11071__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19728 = [];
var len__5726__auto___19780 = arguments.length;
var i__5727__auto___19781 = (0);
while(true){
if((i__5727__auto___19781 < len__5726__auto___19780)){
args19728.push((arguments[i__5727__auto___19781]));

var G__19782 = (i__5727__auto___19781 + (1));
i__5727__auto___19781 = G__19782;
continue;
} else {
}
break;
}

var G__19730 = args19728.length;
switch (G__19730) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19728.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11071__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto__){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto__){
return (function (state_19755){
var state_val_19756 = (state_19755[(1)]);
if((state_val_19756 === (7))){
var inst_19737 = (state_19755[(2)]);
var state_19755__$1 = state_19755;
var statearr_19757_19784 = state_19755__$1;
(statearr_19757_19784[(2)] = inst_19737);

(statearr_19757_19784[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (1))){
var inst_19731 = cljs.core.seq.call(null,coll);
var inst_19732 = inst_19731;
var state_19755__$1 = (function (){var statearr_19758 = state_19755;
(statearr_19758[(7)] = inst_19732);

return statearr_19758;
})();
var statearr_19759_19785 = state_19755__$1;
(statearr_19759_19785[(2)] = null);

(statearr_19759_19785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (4))){
var inst_19732 = (state_19755[(7)]);
var inst_19735 = cljs.core.first.call(null,inst_19732);
var state_19755__$1 = state_19755;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19755__$1,(7),ch,inst_19735);
} else {
if((state_val_19756 === (13))){
var inst_19749 = (state_19755[(2)]);
var state_19755__$1 = state_19755;
var statearr_19760_19786 = state_19755__$1;
(statearr_19760_19786[(2)] = inst_19749);

(statearr_19760_19786[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (6))){
var inst_19740 = (state_19755[(2)]);
var state_19755__$1 = state_19755;
if(cljs.core.truth_(inst_19740)){
var statearr_19761_19787 = state_19755__$1;
(statearr_19761_19787[(1)] = (8));

} else {
var statearr_19762_19788 = state_19755__$1;
(statearr_19762_19788[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (3))){
var inst_19753 = (state_19755[(2)]);
var state_19755__$1 = state_19755;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19755__$1,inst_19753);
} else {
if((state_val_19756 === (12))){
var state_19755__$1 = state_19755;
var statearr_19763_19789 = state_19755__$1;
(statearr_19763_19789[(2)] = null);

(statearr_19763_19789[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (2))){
var inst_19732 = (state_19755[(7)]);
var state_19755__$1 = state_19755;
if(cljs.core.truth_(inst_19732)){
var statearr_19764_19790 = state_19755__$1;
(statearr_19764_19790[(1)] = (4));

} else {
var statearr_19765_19791 = state_19755__$1;
(statearr_19765_19791[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (11))){
var inst_19746 = cljs.core.async.close_BANG_.call(null,ch);
var state_19755__$1 = state_19755;
var statearr_19766_19792 = state_19755__$1;
(statearr_19766_19792[(2)] = inst_19746);

(statearr_19766_19792[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (9))){
var state_19755__$1 = state_19755;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19767_19793 = state_19755__$1;
(statearr_19767_19793[(1)] = (11));

} else {
var statearr_19768_19794 = state_19755__$1;
(statearr_19768_19794[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (5))){
var inst_19732 = (state_19755[(7)]);
var state_19755__$1 = state_19755;
var statearr_19769_19795 = state_19755__$1;
(statearr_19769_19795[(2)] = inst_19732);

(statearr_19769_19795[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (10))){
var inst_19751 = (state_19755[(2)]);
var state_19755__$1 = state_19755;
var statearr_19770_19796 = state_19755__$1;
(statearr_19770_19796[(2)] = inst_19751);

(statearr_19770_19796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19756 === (8))){
var inst_19732 = (state_19755[(7)]);
var inst_19742 = cljs.core.next.call(null,inst_19732);
var inst_19732__$1 = inst_19742;
var state_19755__$1 = (function (){var statearr_19771 = state_19755;
(statearr_19771[(7)] = inst_19732__$1);

return statearr_19771;
})();
var statearr_19772_19797 = state_19755__$1;
(statearr_19772_19797[(2)] = null);

(statearr_19772_19797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto__))
;
return ((function (switch__10959__auto__,c__11071__auto__){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_19776 = [null,null,null,null,null,null,null,null];
(statearr_19776[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_19776[(1)] = (1));

return statearr_19776;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_19755){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_19755);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e19777){if((e19777 instanceof Object)){
var ex__10963__auto__ = e19777;
var statearr_19778_19798 = state_19755;
(statearr_19778_19798[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19755);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19777;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19799 = state_19755;
state_19755 = G__19799;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_19755){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_19755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto__))
})();
var state__11073__auto__ = (function (){var statearr_19779 = f__11072__auto__.call(null);
(statearr_19779[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto__);

return statearr_19779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto__))
);

return c__11071__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20021 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20021 = (function (mult,ch,cs,meta20022){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta20022 = meta20022;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20021.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_20023,meta20022__$1){
var self__ = this;
var _20023__$1 = this;
return (new cljs.core.async.t_cljs$core$async20021(self__.mult,self__.ch,self__.cs,meta20022__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async20021.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_20023){
var self__ = this;
var _20023__$1 = this;
return self__.meta20022;
});})(cs))
;

cljs.core.async.t_cljs$core$async20021.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20021.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async20021.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async20021.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20021.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20021.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20021.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20022","meta20022",-1552643698,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async20021.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20021.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20021";

cljs.core.async.t_cljs$core$async20021.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20021");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async20021 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async20021(mult__$1,ch__$1,cs__$1,meta20022){
return (new cljs.core.async.t_cljs$core$async20021(mult__$1,ch__$1,cs__$1,meta20022));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async20021(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11071__auto___20242 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___20242,cs,m,dchan,dctr,done){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___20242,cs,m,dchan,dctr,done){
return (function (state_20154){
var state_val_20155 = (state_20154[(1)]);
if((state_val_20155 === (7))){
var inst_20150 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20156_20243 = state_20154__$1;
(statearr_20156_20243[(2)] = inst_20150);

(statearr_20156_20243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (20))){
var inst_20055 = (state_20154[(7)]);
var inst_20065 = cljs.core.first.call(null,inst_20055);
var inst_20066 = cljs.core.nth.call(null,inst_20065,(0),null);
var inst_20067 = cljs.core.nth.call(null,inst_20065,(1),null);
var state_20154__$1 = (function (){var statearr_20157 = state_20154;
(statearr_20157[(8)] = inst_20066);

return statearr_20157;
})();
if(cljs.core.truth_(inst_20067)){
var statearr_20158_20244 = state_20154__$1;
(statearr_20158_20244[(1)] = (22));

} else {
var statearr_20159_20245 = state_20154__$1;
(statearr_20159_20245[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (27))){
var inst_20102 = (state_20154[(9)]);
var inst_20097 = (state_20154[(10)]);
var inst_20026 = (state_20154[(11)]);
var inst_20095 = (state_20154[(12)]);
var inst_20102__$1 = cljs.core._nth.call(null,inst_20095,inst_20097);
var inst_20103 = cljs.core.async.put_BANG_.call(null,inst_20102__$1,inst_20026,done);
var state_20154__$1 = (function (){var statearr_20160 = state_20154;
(statearr_20160[(9)] = inst_20102__$1);

return statearr_20160;
})();
if(cljs.core.truth_(inst_20103)){
var statearr_20161_20246 = state_20154__$1;
(statearr_20161_20246[(1)] = (30));

} else {
var statearr_20162_20247 = state_20154__$1;
(statearr_20162_20247[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (1))){
var state_20154__$1 = state_20154;
var statearr_20163_20248 = state_20154__$1;
(statearr_20163_20248[(2)] = null);

(statearr_20163_20248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (24))){
var inst_20055 = (state_20154[(7)]);
var inst_20072 = (state_20154[(2)]);
var inst_20073 = cljs.core.next.call(null,inst_20055);
var inst_20035 = inst_20073;
var inst_20036 = null;
var inst_20037 = (0);
var inst_20038 = (0);
var state_20154__$1 = (function (){var statearr_20164 = state_20154;
(statearr_20164[(13)] = inst_20072);

(statearr_20164[(14)] = inst_20037);

(statearr_20164[(15)] = inst_20036);

(statearr_20164[(16)] = inst_20035);

(statearr_20164[(17)] = inst_20038);

return statearr_20164;
})();
var statearr_20165_20249 = state_20154__$1;
(statearr_20165_20249[(2)] = null);

(statearr_20165_20249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (39))){
var state_20154__$1 = state_20154;
var statearr_20169_20250 = state_20154__$1;
(statearr_20169_20250[(2)] = null);

(statearr_20169_20250[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (4))){
var inst_20026 = (state_20154[(11)]);
var inst_20026__$1 = (state_20154[(2)]);
var inst_20027 = (inst_20026__$1 == null);
var state_20154__$1 = (function (){var statearr_20170 = state_20154;
(statearr_20170[(11)] = inst_20026__$1);

return statearr_20170;
})();
if(cljs.core.truth_(inst_20027)){
var statearr_20171_20251 = state_20154__$1;
(statearr_20171_20251[(1)] = (5));

} else {
var statearr_20172_20252 = state_20154__$1;
(statearr_20172_20252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (15))){
var inst_20037 = (state_20154[(14)]);
var inst_20036 = (state_20154[(15)]);
var inst_20035 = (state_20154[(16)]);
var inst_20038 = (state_20154[(17)]);
var inst_20051 = (state_20154[(2)]);
var inst_20052 = (inst_20038 + (1));
var tmp20166 = inst_20037;
var tmp20167 = inst_20036;
var tmp20168 = inst_20035;
var inst_20035__$1 = tmp20168;
var inst_20036__$1 = tmp20167;
var inst_20037__$1 = tmp20166;
var inst_20038__$1 = inst_20052;
var state_20154__$1 = (function (){var statearr_20173 = state_20154;
(statearr_20173[(14)] = inst_20037__$1);

(statearr_20173[(18)] = inst_20051);

(statearr_20173[(15)] = inst_20036__$1);

(statearr_20173[(16)] = inst_20035__$1);

(statearr_20173[(17)] = inst_20038__$1);

return statearr_20173;
})();
var statearr_20174_20253 = state_20154__$1;
(statearr_20174_20253[(2)] = null);

(statearr_20174_20253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (21))){
var inst_20076 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20178_20254 = state_20154__$1;
(statearr_20178_20254[(2)] = inst_20076);

(statearr_20178_20254[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (31))){
var inst_20102 = (state_20154[(9)]);
var inst_20106 = done.call(null,null);
var inst_20107 = cljs.core.async.untap_STAR_.call(null,m,inst_20102);
var state_20154__$1 = (function (){var statearr_20179 = state_20154;
(statearr_20179[(19)] = inst_20106);

return statearr_20179;
})();
var statearr_20180_20255 = state_20154__$1;
(statearr_20180_20255[(2)] = inst_20107);

(statearr_20180_20255[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (32))){
var inst_20097 = (state_20154[(10)]);
var inst_20096 = (state_20154[(20)]);
var inst_20094 = (state_20154[(21)]);
var inst_20095 = (state_20154[(12)]);
var inst_20109 = (state_20154[(2)]);
var inst_20110 = (inst_20097 + (1));
var tmp20175 = inst_20096;
var tmp20176 = inst_20094;
var tmp20177 = inst_20095;
var inst_20094__$1 = tmp20176;
var inst_20095__$1 = tmp20177;
var inst_20096__$1 = tmp20175;
var inst_20097__$1 = inst_20110;
var state_20154__$1 = (function (){var statearr_20181 = state_20154;
(statearr_20181[(10)] = inst_20097__$1);

(statearr_20181[(20)] = inst_20096__$1);

(statearr_20181[(22)] = inst_20109);

(statearr_20181[(21)] = inst_20094__$1);

(statearr_20181[(12)] = inst_20095__$1);

return statearr_20181;
})();
var statearr_20182_20256 = state_20154__$1;
(statearr_20182_20256[(2)] = null);

(statearr_20182_20256[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (40))){
var inst_20122 = (state_20154[(23)]);
var inst_20126 = done.call(null,null);
var inst_20127 = cljs.core.async.untap_STAR_.call(null,m,inst_20122);
var state_20154__$1 = (function (){var statearr_20183 = state_20154;
(statearr_20183[(24)] = inst_20126);

return statearr_20183;
})();
var statearr_20184_20257 = state_20154__$1;
(statearr_20184_20257[(2)] = inst_20127);

(statearr_20184_20257[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (33))){
var inst_20113 = (state_20154[(25)]);
var inst_20115 = cljs.core.chunked_seq_QMARK_.call(null,inst_20113);
var state_20154__$1 = state_20154;
if(inst_20115){
var statearr_20185_20258 = state_20154__$1;
(statearr_20185_20258[(1)] = (36));

} else {
var statearr_20186_20259 = state_20154__$1;
(statearr_20186_20259[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (13))){
var inst_20045 = (state_20154[(26)]);
var inst_20048 = cljs.core.async.close_BANG_.call(null,inst_20045);
var state_20154__$1 = state_20154;
var statearr_20187_20260 = state_20154__$1;
(statearr_20187_20260[(2)] = inst_20048);

(statearr_20187_20260[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (22))){
var inst_20066 = (state_20154[(8)]);
var inst_20069 = cljs.core.async.close_BANG_.call(null,inst_20066);
var state_20154__$1 = state_20154;
var statearr_20188_20261 = state_20154__$1;
(statearr_20188_20261[(2)] = inst_20069);

(statearr_20188_20261[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (36))){
var inst_20113 = (state_20154[(25)]);
var inst_20117 = cljs.core.chunk_first.call(null,inst_20113);
var inst_20118 = cljs.core.chunk_rest.call(null,inst_20113);
var inst_20119 = cljs.core.count.call(null,inst_20117);
var inst_20094 = inst_20118;
var inst_20095 = inst_20117;
var inst_20096 = inst_20119;
var inst_20097 = (0);
var state_20154__$1 = (function (){var statearr_20189 = state_20154;
(statearr_20189[(10)] = inst_20097);

(statearr_20189[(20)] = inst_20096);

(statearr_20189[(21)] = inst_20094);

(statearr_20189[(12)] = inst_20095);

return statearr_20189;
})();
var statearr_20190_20262 = state_20154__$1;
(statearr_20190_20262[(2)] = null);

(statearr_20190_20262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (41))){
var inst_20113 = (state_20154[(25)]);
var inst_20129 = (state_20154[(2)]);
var inst_20130 = cljs.core.next.call(null,inst_20113);
var inst_20094 = inst_20130;
var inst_20095 = null;
var inst_20096 = (0);
var inst_20097 = (0);
var state_20154__$1 = (function (){var statearr_20191 = state_20154;
(statearr_20191[(10)] = inst_20097);

(statearr_20191[(27)] = inst_20129);

(statearr_20191[(20)] = inst_20096);

(statearr_20191[(21)] = inst_20094);

(statearr_20191[(12)] = inst_20095);

return statearr_20191;
})();
var statearr_20192_20263 = state_20154__$1;
(statearr_20192_20263[(2)] = null);

(statearr_20192_20263[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (43))){
var state_20154__$1 = state_20154;
var statearr_20193_20264 = state_20154__$1;
(statearr_20193_20264[(2)] = null);

(statearr_20193_20264[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (29))){
var inst_20138 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20194_20265 = state_20154__$1;
(statearr_20194_20265[(2)] = inst_20138);

(statearr_20194_20265[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (44))){
var inst_20147 = (state_20154[(2)]);
var state_20154__$1 = (function (){var statearr_20195 = state_20154;
(statearr_20195[(28)] = inst_20147);

return statearr_20195;
})();
var statearr_20196_20266 = state_20154__$1;
(statearr_20196_20266[(2)] = null);

(statearr_20196_20266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (6))){
var inst_20086 = (state_20154[(29)]);
var inst_20085 = cljs.core.deref.call(null,cs);
var inst_20086__$1 = cljs.core.keys.call(null,inst_20085);
var inst_20087 = cljs.core.count.call(null,inst_20086__$1);
var inst_20088 = cljs.core.reset_BANG_.call(null,dctr,inst_20087);
var inst_20093 = cljs.core.seq.call(null,inst_20086__$1);
var inst_20094 = inst_20093;
var inst_20095 = null;
var inst_20096 = (0);
var inst_20097 = (0);
var state_20154__$1 = (function (){var statearr_20197 = state_20154;
(statearr_20197[(30)] = inst_20088);

(statearr_20197[(29)] = inst_20086__$1);

(statearr_20197[(10)] = inst_20097);

(statearr_20197[(20)] = inst_20096);

(statearr_20197[(21)] = inst_20094);

(statearr_20197[(12)] = inst_20095);

return statearr_20197;
})();
var statearr_20198_20267 = state_20154__$1;
(statearr_20198_20267[(2)] = null);

(statearr_20198_20267[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (28))){
var inst_20113 = (state_20154[(25)]);
var inst_20094 = (state_20154[(21)]);
var inst_20113__$1 = cljs.core.seq.call(null,inst_20094);
var state_20154__$1 = (function (){var statearr_20199 = state_20154;
(statearr_20199[(25)] = inst_20113__$1);

return statearr_20199;
})();
if(inst_20113__$1){
var statearr_20200_20268 = state_20154__$1;
(statearr_20200_20268[(1)] = (33));

} else {
var statearr_20201_20269 = state_20154__$1;
(statearr_20201_20269[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (25))){
var inst_20097 = (state_20154[(10)]);
var inst_20096 = (state_20154[(20)]);
var inst_20099 = (inst_20097 < inst_20096);
var inst_20100 = inst_20099;
var state_20154__$1 = state_20154;
if(cljs.core.truth_(inst_20100)){
var statearr_20202_20270 = state_20154__$1;
(statearr_20202_20270[(1)] = (27));

} else {
var statearr_20203_20271 = state_20154__$1;
(statearr_20203_20271[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (34))){
var state_20154__$1 = state_20154;
var statearr_20204_20272 = state_20154__$1;
(statearr_20204_20272[(2)] = null);

(statearr_20204_20272[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (17))){
var state_20154__$1 = state_20154;
var statearr_20205_20273 = state_20154__$1;
(statearr_20205_20273[(2)] = null);

(statearr_20205_20273[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (3))){
var inst_20152 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20154__$1,inst_20152);
} else {
if((state_val_20155 === (12))){
var inst_20081 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20206_20274 = state_20154__$1;
(statearr_20206_20274[(2)] = inst_20081);

(statearr_20206_20274[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (2))){
var state_20154__$1 = state_20154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20154__$1,(4),ch);
} else {
if((state_val_20155 === (23))){
var state_20154__$1 = state_20154;
var statearr_20207_20275 = state_20154__$1;
(statearr_20207_20275[(2)] = null);

(statearr_20207_20275[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (35))){
var inst_20136 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20208_20276 = state_20154__$1;
(statearr_20208_20276[(2)] = inst_20136);

(statearr_20208_20276[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (19))){
var inst_20055 = (state_20154[(7)]);
var inst_20059 = cljs.core.chunk_first.call(null,inst_20055);
var inst_20060 = cljs.core.chunk_rest.call(null,inst_20055);
var inst_20061 = cljs.core.count.call(null,inst_20059);
var inst_20035 = inst_20060;
var inst_20036 = inst_20059;
var inst_20037 = inst_20061;
var inst_20038 = (0);
var state_20154__$1 = (function (){var statearr_20209 = state_20154;
(statearr_20209[(14)] = inst_20037);

(statearr_20209[(15)] = inst_20036);

(statearr_20209[(16)] = inst_20035);

(statearr_20209[(17)] = inst_20038);

return statearr_20209;
})();
var statearr_20210_20277 = state_20154__$1;
(statearr_20210_20277[(2)] = null);

(statearr_20210_20277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (11))){
var inst_20035 = (state_20154[(16)]);
var inst_20055 = (state_20154[(7)]);
var inst_20055__$1 = cljs.core.seq.call(null,inst_20035);
var state_20154__$1 = (function (){var statearr_20211 = state_20154;
(statearr_20211[(7)] = inst_20055__$1);

return statearr_20211;
})();
if(inst_20055__$1){
var statearr_20212_20278 = state_20154__$1;
(statearr_20212_20278[(1)] = (16));

} else {
var statearr_20213_20279 = state_20154__$1;
(statearr_20213_20279[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (9))){
var inst_20083 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20214_20280 = state_20154__$1;
(statearr_20214_20280[(2)] = inst_20083);

(statearr_20214_20280[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (5))){
var inst_20033 = cljs.core.deref.call(null,cs);
var inst_20034 = cljs.core.seq.call(null,inst_20033);
var inst_20035 = inst_20034;
var inst_20036 = null;
var inst_20037 = (0);
var inst_20038 = (0);
var state_20154__$1 = (function (){var statearr_20215 = state_20154;
(statearr_20215[(14)] = inst_20037);

(statearr_20215[(15)] = inst_20036);

(statearr_20215[(16)] = inst_20035);

(statearr_20215[(17)] = inst_20038);

return statearr_20215;
})();
var statearr_20216_20281 = state_20154__$1;
(statearr_20216_20281[(2)] = null);

(statearr_20216_20281[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (14))){
var state_20154__$1 = state_20154;
var statearr_20217_20282 = state_20154__$1;
(statearr_20217_20282[(2)] = null);

(statearr_20217_20282[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (45))){
var inst_20144 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20218_20283 = state_20154__$1;
(statearr_20218_20283[(2)] = inst_20144);

(statearr_20218_20283[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (26))){
var inst_20086 = (state_20154[(29)]);
var inst_20140 = (state_20154[(2)]);
var inst_20141 = cljs.core.seq.call(null,inst_20086);
var state_20154__$1 = (function (){var statearr_20219 = state_20154;
(statearr_20219[(31)] = inst_20140);

return statearr_20219;
})();
if(inst_20141){
var statearr_20220_20284 = state_20154__$1;
(statearr_20220_20284[(1)] = (42));

} else {
var statearr_20221_20285 = state_20154__$1;
(statearr_20221_20285[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (16))){
var inst_20055 = (state_20154[(7)]);
var inst_20057 = cljs.core.chunked_seq_QMARK_.call(null,inst_20055);
var state_20154__$1 = state_20154;
if(inst_20057){
var statearr_20222_20286 = state_20154__$1;
(statearr_20222_20286[(1)] = (19));

} else {
var statearr_20223_20287 = state_20154__$1;
(statearr_20223_20287[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (38))){
var inst_20133 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20224_20288 = state_20154__$1;
(statearr_20224_20288[(2)] = inst_20133);

(statearr_20224_20288[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (30))){
var state_20154__$1 = state_20154;
var statearr_20225_20289 = state_20154__$1;
(statearr_20225_20289[(2)] = null);

(statearr_20225_20289[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (10))){
var inst_20036 = (state_20154[(15)]);
var inst_20038 = (state_20154[(17)]);
var inst_20044 = cljs.core._nth.call(null,inst_20036,inst_20038);
var inst_20045 = cljs.core.nth.call(null,inst_20044,(0),null);
var inst_20046 = cljs.core.nth.call(null,inst_20044,(1),null);
var state_20154__$1 = (function (){var statearr_20226 = state_20154;
(statearr_20226[(26)] = inst_20045);

return statearr_20226;
})();
if(cljs.core.truth_(inst_20046)){
var statearr_20227_20290 = state_20154__$1;
(statearr_20227_20290[(1)] = (13));

} else {
var statearr_20228_20291 = state_20154__$1;
(statearr_20228_20291[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (18))){
var inst_20079 = (state_20154[(2)]);
var state_20154__$1 = state_20154;
var statearr_20229_20292 = state_20154__$1;
(statearr_20229_20292[(2)] = inst_20079);

(statearr_20229_20292[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (42))){
var state_20154__$1 = state_20154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20154__$1,(45),dchan);
} else {
if((state_val_20155 === (37))){
var inst_20122 = (state_20154[(23)]);
var inst_20113 = (state_20154[(25)]);
var inst_20026 = (state_20154[(11)]);
var inst_20122__$1 = cljs.core.first.call(null,inst_20113);
var inst_20123 = cljs.core.async.put_BANG_.call(null,inst_20122__$1,inst_20026,done);
var state_20154__$1 = (function (){var statearr_20230 = state_20154;
(statearr_20230[(23)] = inst_20122__$1);

return statearr_20230;
})();
if(cljs.core.truth_(inst_20123)){
var statearr_20231_20293 = state_20154__$1;
(statearr_20231_20293[(1)] = (39));

} else {
var statearr_20232_20294 = state_20154__$1;
(statearr_20232_20294[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20155 === (8))){
var inst_20037 = (state_20154[(14)]);
var inst_20038 = (state_20154[(17)]);
var inst_20040 = (inst_20038 < inst_20037);
var inst_20041 = inst_20040;
var state_20154__$1 = state_20154;
if(cljs.core.truth_(inst_20041)){
var statearr_20233_20295 = state_20154__$1;
(statearr_20233_20295[(1)] = (10));

} else {
var statearr_20234_20296 = state_20154__$1;
(statearr_20234_20296[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___20242,cs,m,dchan,dctr,done))
;
return ((function (switch__10959__auto__,c__11071__auto___20242,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10960__auto__ = null;
var cljs$core$async$mult_$_state_machine__10960__auto____0 = (function (){
var statearr_20238 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20238[(0)] = cljs$core$async$mult_$_state_machine__10960__auto__);

(statearr_20238[(1)] = (1));

return statearr_20238;
});
var cljs$core$async$mult_$_state_machine__10960__auto____1 = (function (state_20154){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_20154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e20239){if((e20239 instanceof Object)){
var ex__10963__auto__ = e20239;
var statearr_20240_20297 = state_20154;
(statearr_20240_20297[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20239;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20298 = state_20154;
state_20154 = G__20298;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10960__auto__ = function(state_20154){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10960__auto____1.call(this,state_20154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10960__auto____0;
cljs$core$async$mult_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10960__auto____1;
return cljs$core$async$mult_$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___20242,cs,m,dchan,dctr,done))
})();
var state__11073__auto__ = (function (){var statearr_20241 = f__11072__auto__.call(null);
(statearr_20241[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___20242);

return statearr_20241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___20242,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20299 = [];
var len__5726__auto___20302 = arguments.length;
var i__5727__auto___20303 = (0);
while(true){
if((i__5727__auto___20303 < len__5726__auto___20302)){
args20299.push((arguments[i__5727__auto___20303]));

var G__20304 = (i__5727__auto___20303 + (1));
i__5727__auto___20303 = G__20304;
continue;
} else {
}
break;
}

var G__20301 = args20299.length;
switch (G__20301) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20299.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20316 = arguments.length;
var i__5727__auto___20317 = (0);
while(true){
if((i__5727__auto___20317 < len__5726__auto___20316)){
args__5733__auto__.push((arguments[i__5727__auto___20317]));

var G__20318 = (i__5727__auto___20317 + (1));
i__5727__auto___20317 = G__20318;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20310){
var map__20311 = p__20310;
var map__20311__$1 = ((((!((map__20311 == null)))?((((map__20311.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20311.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20311):map__20311);
var opts = map__20311__$1;
var statearr_20313_20319 = state;
(statearr_20313_20319[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20311,map__20311__$1,opts){
return (function (val){
var statearr_20314_20320 = state;
(statearr_20314_20320[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20311,map__20311__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20315_20321 = state;
(statearr_20315_20321[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20306){
var G__20307 = cljs.core.first.call(null,seq20306);
var seq20306__$1 = cljs.core.next.call(null,seq20306);
var G__20308 = cljs.core.first.call(null,seq20306__$1);
var seq20306__$2 = cljs.core.next.call(null,seq20306__$1);
var G__20309 = cljs.core.first.call(null,seq20306__$2);
var seq20306__$3 = cljs.core.next.call(null,seq20306__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20307,G__20308,G__20309,seq20306__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20485 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20485 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20486){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20486 = meta20486;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20487,meta20486__$1){
var self__ = this;
var _20487__$1 = this;
return (new cljs.core.async.t_cljs$core$async20485(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20486__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20487){
var self__ = this;
var _20487__$1 = this;
return self__.meta20486;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20486","meta20486",72964154,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20485.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20485.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20485";

cljs.core.async.t_cljs$core$async20485.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20485");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20485 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20485(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20486){
return (new cljs.core.async.t_cljs$core$async20485(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20486));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20485(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11071__auto___20648 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___20648,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___20648,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20585){
var state_val_20586 = (state_20585[(1)]);
if((state_val_20586 === (7))){
var inst_20503 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
var statearr_20587_20649 = state_20585__$1;
(statearr_20587_20649[(2)] = inst_20503);

(statearr_20587_20649[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (20))){
var inst_20515 = (state_20585[(7)]);
var state_20585__$1 = state_20585;
var statearr_20588_20650 = state_20585__$1;
(statearr_20588_20650[(2)] = inst_20515);

(statearr_20588_20650[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (27))){
var state_20585__$1 = state_20585;
var statearr_20589_20651 = state_20585__$1;
(statearr_20589_20651[(2)] = null);

(statearr_20589_20651[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (1))){
var inst_20491 = (state_20585[(8)]);
var inst_20491__$1 = calc_state.call(null);
var inst_20493 = (inst_20491__$1 == null);
var inst_20494 = cljs.core.not.call(null,inst_20493);
var state_20585__$1 = (function (){var statearr_20590 = state_20585;
(statearr_20590[(8)] = inst_20491__$1);

return statearr_20590;
})();
if(inst_20494){
var statearr_20591_20652 = state_20585__$1;
(statearr_20591_20652[(1)] = (2));

} else {
var statearr_20592_20653 = state_20585__$1;
(statearr_20592_20653[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (24))){
var inst_20545 = (state_20585[(9)]);
var inst_20538 = (state_20585[(10)]);
var inst_20559 = (state_20585[(11)]);
var inst_20559__$1 = inst_20538.call(null,inst_20545);
var state_20585__$1 = (function (){var statearr_20593 = state_20585;
(statearr_20593[(11)] = inst_20559__$1);

return statearr_20593;
})();
if(cljs.core.truth_(inst_20559__$1)){
var statearr_20594_20654 = state_20585__$1;
(statearr_20594_20654[(1)] = (29));

} else {
var statearr_20595_20655 = state_20585__$1;
(statearr_20595_20655[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (4))){
var inst_20506 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
if(cljs.core.truth_(inst_20506)){
var statearr_20596_20656 = state_20585__$1;
(statearr_20596_20656[(1)] = (8));

} else {
var statearr_20597_20657 = state_20585__$1;
(statearr_20597_20657[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (15))){
var inst_20532 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
if(cljs.core.truth_(inst_20532)){
var statearr_20598_20658 = state_20585__$1;
(statearr_20598_20658[(1)] = (19));

} else {
var statearr_20599_20659 = state_20585__$1;
(statearr_20599_20659[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (21))){
var inst_20537 = (state_20585[(12)]);
var inst_20537__$1 = (state_20585[(2)]);
var inst_20538 = cljs.core.get.call(null,inst_20537__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20539 = cljs.core.get.call(null,inst_20537__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20540 = cljs.core.get.call(null,inst_20537__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20585__$1 = (function (){var statearr_20600 = state_20585;
(statearr_20600[(12)] = inst_20537__$1);

(statearr_20600[(10)] = inst_20538);

(statearr_20600[(13)] = inst_20539);

return statearr_20600;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20585__$1,(22),inst_20540);
} else {
if((state_val_20586 === (31))){
var inst_20567 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
if(cljs.core.truth_(inst_20567)){
var statearr_20601_20660 = state_20585__$1;
(statearr_20601_20660[(1)] = (32));

} else {
var statearr_20602_20661 = state_20585__$1;
(statearr_20602_20661[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (32))){
var inst_20544 = (state_20585[(14)]);
var state_20585__$1 = state_20585;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20585__$1,(35),out,inst_20544);
} else {
if((state_val_20586 === (33))){
var inst_20537 = (state_20585[(12)]);
var inst_20515 = inst_20537;
var state_20585__$1 = (function (){var statearr_20603 = state_20585;
(statearr_20603[(7)] = inst_20515);

return statearr_20603;
})();
var statearr_20604_20662 = state_20585__$1;
(statearr_20604_20662[(2)] = null);

(statearr_20604_20662[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (13))){
var inst_20515 = (state_20585[(7)]);
var inst_20522 = inst_20515.cljs$lang$protocol_mask$partition0$;
var inst_20523 = (inst_20522 & (64));
var inst_20524 = inst_20515.cljs$core$ISeq$;
var inst_20525 = (inst_20523) || (inst_20524);
var state_20585__$1 = state_20585;
if(cljs.core.truth_(inst_20525)){
var statearr_20605_20663 = state_20585__$1;
(statearr_20605_20663[(1)] = (16));

} else {
var statearr_20606_20664 = state_20585__$1;
(statearr_20606_20664[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (22))){
var inst_20545 = (state_20585[(9)]);
var inst_20544 = (state_20585[(14)]);
var inst_20543 = (state_20585[(2)]);
var inst_20544__$1 = cljs.core.nth.call(null,inst_20543,(0),null);
var inst_20545__$1 = cljs.core.nth.call(null,inst_20543,(1),null);
var inst_20546 = (inst_20544__$1 == null);
var inst_20547 = cljs.core._EQ_.call(null,inst_20545__$1,change);
var inst_20548 = (inst_20546) || (inst_20547);
var state_20585__$1 = (function (){var statearr_20607 = state_20585;
(statearr_20607[(9)] = inst_20545__$1);

(statearr_20607[(14)] = inst_20544__$1);

return statearr_20607;
})();
if(cljs.core.truth_(inst_20548)){
var statearr_20608_20665 = state_20585__$1;
(statearr_20608_20665[(1)] = (23));

} else {
var statearr_20609_20666 = state_20585__$1;
(statearr_20609_20666[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (36))){
var inst_20537 = (state_20585[(12)]);
var inst_20515 = inst_20537;
var state_20585__$1 = (function (){var statearr_20610 = state_20585;
(statearr_20610[(7)] = inst_20515);

return statearr_20610;
})();
var statearr_20611_20667 = state_20585__$1;
(statearr_20611_20667[(2)] = null);

(statearr_20611_20667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (29))){
var inst_20559 = (state_20585[(11)]);
var state_20585__$1 = state_20585;
var statearr_20612_20668 = state_20585__$1;
(statearr_20612_20668[(2)] = inst_20559);

(statearr_20612_20668[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (6))){
var state_20585__$1 = state_20585;
var statearr_20613_20669 = state_20585__$1;
(statearr_20613_20669[(2)] = false);

(statearr_20613_20669[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (28))){
var inst_20555 = (state_20585[(2)]);
var inst_20556 = calc_state.call(null);
var inst_20515 = inst_20556;
var state_20585__$1 = (function (){var statearr_20614 = state_20585;
(statearr_20614[(7)] = inst_20515);

(statearr_20614[(15)] = inst_20555);

return statearr_20614;
})();
var statearr_20615_20670 = state_20585__$1;
(statearr_20615_20670[(2)] = null);

(statearr_20615_20670[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (25))){
var inst_20581 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
var statearr_20616_20671 = state_20585__$1;
(statearr_20616_20671[(2)] = inst_20581);

(statearr_20616_20671[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (34))){
var inst_20579 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
var statearr_20617_20672 = state_20585__$1;
(statearr_20617_20672[(2)] = inst_20579);

(statearr_20617_20672[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (17))){
var state_20585__$1 = state_20585;
var statearr_20618_20673 = state_20585__$1;
(statearr_20618_20673[(2)] = false);

(statearr_20618_20673[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (3))){
var state_20585__$1 = state_20585;
var statearr_20619_20674 = state_20585__$1;
(statearr_20619_20674[(2)] = false);

(statearr_20619_20674[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (12))){
var inst_20583 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20585__$1,inst_20583);
} else {
if((state_val_20586 === (2))){
var inst_20491 = (state_20585[(8)]);
var inst_20496 = inst_20491.cljs$lang$protocol_mask$partition0$;
var inst_20497 = (inst_20496 & (64));
var inst_20498 = inst_20491.cljs$core$ISeq$;
var inst_20499 = (inst_20497) || (inst_20498);
var state_20585__$1 = state_20585;
if(cljs.core.truth_(inst_20499)){
var statearr_20620_20675 = state_20585__$1;
(statearr_20620_20675[(1)] = (5));

} else {
var statearr_20621_20676 = state_20585__$1;
(statearr_20621_20676[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (23))){
var inst_20544 = (state_20585[(14)]);
var inst_20550 = (inst_20544 == null);
var state_20585__$1 = state_20585;
if(cljs.core.truth_(inst_20550)){
var statearr_20622_20677 = state_20585__$1;
(statearr_20622_20677[(1)] = (26));

} else {
var statearr_20623_20678 = state_20585__$1;
(statearr_20623_20678[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (35))){
var inst_20570 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
if(cljs.core.truth_(inst_20570)){
var statearr_20624_20679 = state_20585__$1;
(statearr_20624_20679[(1)] = (36));

} else {
var statearr_20625_20680 = state_20585__$1;
(statearr_20625_20680[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (19))){
var inst_20515 = (state_20585[(7)]);
var inst_20534 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20515);
var state_20585__$1 = state_20585;
var statearr_20626_20681 = state_20585__$1;
(statearr_20626_20681[(2)] = inst_20534);

(statearr_20626_20681[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (11))){
var inst_20515 = (state_20585[(7)]);
var inst_20519 = (inst_20515 == null);
var inst_20520 = cljs.core.not.call(null,inst_20519);
var state_20585__$1 = state_20585;
if(inst_20520){
var statearr_20627_20682 = state_20585__$1;
(statearr_20627_20682[(1)] = (13));

} else {
var statearr_20628_20683 = state_20585__$1;
(statearr_20628_20683[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (9))){
var inst_20491 = (state_20585[(8)]);
var state_20585__$1 = state_20585;
var statearr_20629_20684 = state_20585__$1;
(statearr_20629_20684[(2)] = inst_20491);

(statearr_20629_20684[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (5))){
var state_20585__$1 = state_20585;
var statearr_20630_20685 = state_20585__$1;
(statearr_20630_20685[(2)] = true);

(statearr_20630_20685[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (14))){
var state_20585__$1 = state_20585;
var statearr_20631_20686 = state_20585__$1;
(statearr_20631_20686[(2)] = false);

(statearr_20631_20686[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (26))){
var inst_20545 = (state_20585[(9)]);
var inst_20552 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20545);
var state_20585__$1 = state_20585;
var statearr_20632_20687 = state_20585__$1;
(statearr_20632_20687[(2)] = inst_20552);

(statearr_20632_20687[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (16))){
var state_20585__$1 = state_20585;
var statearr_20633_20688 = state_20585__$1;
(statearr_20633_20688[(2)] = true);

(statearr_20633_20688[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (38))){
var inst_20575 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
var statearr_20634_20689 = state_20585__$1;
(statearr_20634_20689[(2)] = inst_20575);

(statearr_20634_20689[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (30))){
var inst_20545 = (state_20585[(9)]);
var inst_20538 = (state_20585[(10)]);
var inst_20539 = (state_20585[(13)]);
var inst_20562 = cljs.core.empty_QMARK_.call(null,inst_20538);
var inst_20563 = inst_20539.call(null,inst_20545);
var inst_20564 = cljs.core.not.call(null,inst_20563);
var inst_20565 = (inst_20562) && (inst_20564);
var state_20585__$1 = state_20585;
var statearr_20635_20690 = state_20585__$1;
(statearr_20635_20690[(2)] = inst_20565);

(statearr_20635_20690[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (10))){
var inst_20491 = (state_20585[(8)]);
var inst_20511 = (state_20585[(2)]);
var inst_20512 = cljs.core.get.call(null,inst_20511,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20513 = cljs.core.get.call(null,inst_20511,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20514 = cljs.core.get.call(null,inst_20511,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20515 = inst_20491;
var state_20585__$1 = (function (){var statearr_20636 = state_20585;
(statearr_20636[(16)] = inst_20514);

(statearr_20636[(17)] = inst_20513);

(statearr_20636[(7)] = inst_20515);

(statearr_20636[(18)] = inst_20512);

return statearr_20636;
})();
var statearr_20637_20691 = state_20585__$1;
(statearr_20637_20691[(2)] = null);

(statearr_20637_20691[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (18))){
var inst_20529 = (state_20585[(2)]);
var state_20585__$1 = state_20585;
var statearr_20638_20692 = state_20585__$1;
(statearr_20638_20692[(2)] = inst_20529);

(statearr_20638_20692[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (37))){
var state_20585__$1 = state_20585;
var statearr_20639_20693 = state_20585__$1;
(statearr_20639_20693[(2)] = null);

(statearr_20639_20693[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20586 === (8))){
var inst_20491 = (state_20585[(8)]);
var inst_20508 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20491);
var state_20585__$1 = state_20585;
var statearr_20640_20694 = state_20585__$1;
(statearr_20640_20694[(2)] = inst_20508);

(statearr_20640_20694[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___20648,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10959__auto__,c__11071__auto___20648,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10960__auto__ = null;
var cljs$core$async$mix_$_state_machine__10960__auto____0 = (function (){
var statearr_20644 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20644[(0)] = cljs$core$async$mix_$_state_machine__10960__auto__);

(statearr_20644[(1)] = (1));

return statearr_20644;
});
var cljs$core$async$mix_$_state_machine__10960__auto____1 = (function (state_20585){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_20585);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e20645){if((e20645 instanceof Object)){
var ex__10963__auto__ = e20645;
var statearr_20646_20695 = state_20585;
(statearr_20646_20695[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20585);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20645;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20696 = state_20585;
state_20585 = G__20696;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10960__auto__ = function(state_20585){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10960__auto____1.call(this,state_20585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10960__auto____0;
cljs$core$async$mix_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10960__auto____1;
return cljs$core$async$mix_$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___20648,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11073__auto__ = (function (){var statearr_20647 = f__11072__auto__.call(null);
(statearr_20647[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___20648);

return statearr_20647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___20648,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20697 = [];
var len__5726__auto___20700 = arguments.length;
var i__5727__auto___20701 = (0);
while(true){
if((i__5727__auto___20701 < len__5726__auto___20700)){
args20697.push((arguments[i__5727__auto___20701]));

var G__20702 = (i__5727__auto___20701 + (1));
i__5727__auto___20701 = G__20702;
continue;
} else {
}
break;
}

var G__20699 = args20697.length;
switch (G__20699) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20697.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20705 = [];
var len__5726__auto___20830 = arguments.length;
var i__5727__auto___20831 = (0);
while(true){
if((i__5727__auto___20831 < len__5726__auto___20830)){
args20705.push((arguments[i__5727__auto___20831]));

var G__20832 = (i__5727__auto___20831 + (1));
i__5727__auto___20831 = G__20832;
continue;
} else {
}
break;
}

var G__20707 = args20705.length;
switch (G__20707) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20705.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__20704_SHARP_){
if(cljs.core.truth_(p1__20704_SHARP_.call(null,topic))){
return p1__20704_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20704_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20708 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20708 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20709){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20709 = meta20709;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20710,meta20709__$1){
var self__ = this;
var _20710__$1 = this;
return (new cljs.core.async.t_cljs$core$async20708(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20709__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20710){
var self__ = this;
var _20710__$1 = this;
return self__.meta20709;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20708.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20708.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20709","meta20709",285062825,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20708.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20708.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20708";

cljs.core.async.t_cljs$core$async20708.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20708");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20708 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20708(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20709){
return (new cljs.core.async.t_cljs$core$async20708(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20709));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20708(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11071__auto___20834 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___20834,mults,ensure_mult,p){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___20834,mults,ensure_mult,p){
return (function (state_20782){
var state_val_20783 = (state_20782[(1)]);
if((state_val_20783 === (7))){
var inst_20778 = (state_20782[(2)]);
var state_20782__$1 = state_20782;
var statearr_20784_20835 = state_20782__$1;
(statearr_20784_20835[(2)] = inst_20778);

(statearr_20784_20835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (20))){
var state_20782__$1 = state_20782;
var statearr_20785_20836 = state_20782__$1;
(statearr_20785_20836[(2)] = null);

(statearr_20785_20836[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (1))){
var state_20782__$1 = state_20782;
var statearr_20786_20837 = state_20782__$1;
(statearr_20786_20837[(2)] = null);

(statearr_20786_20837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (24))){
var inst_20761 = (state_20782[(7)]);
var inst_20770 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20761);
var state_20782__$1 = state_20782;
var statearr_20787_20838 = state_20782__$1;
(statearr_20787_20838[(2)] = inst_20770);

(statearr_20787_20838[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (4))){
var inst_20713 = (state_20782[(8)]);
var inst_20713__$1 = (state_20782[(2)]);
var inst_20714 = (inst_20713__$1 == null);
var state_20782__$1 = (function (){var statearr_20788 = state_20782;
(statearr_20788[(8)] = inst_20713__$1);

return statearr_20788;
})();
if(cljs.core.truth_(inst_20714)){
var statearr_20789_20839 = state_20782__$1;
(statearr_20789_20839[(1)] = (5));

} else {
var statearr_20790_20840 = state_20782__$1;
(statearr_20790_20840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (15))){
var inst_20755 = (state_20782[(2)]);
var state_20782__$1 = state_20782;
var statearr_20791_20841 = state_20782__$1;
(statearr_20791_20841[(2)] = inst_20755);

(statearr_20791_20841[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (21))){
var inst_20775 = (state_20782[(2)]);
var state_20782__$1 = (function (){var statearr_20792 = state_20782;
(statearr_20792[(9)] = inst_20775);

return statearr_20792;
})();
var statearr_20793_20842 = state_20782__$1;
(statearr_20793_20842[(2)] = null);

(statearr_20793_20842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (13))){
var inst_20737 = (state_20782[(10)]);
var inst_20739 = cljs.core.chunked_seq_QMARK_.call(null,inst_20737);
var state_20782__$1 = state_20782;
if(inst_20739){
var statearr_20794_20843 = state_20782__$1;
(statearr_20794_20843[(1)] = (16));

} else {
var statearr_20795_20844 = state_20782__$1;
(statearr_20795_20844[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (22))){
var inst_20767 = (state_20782[(2)]);
var state_20782__$1 = state_20782;
if(cljs.core.truth_(inst_20767)){
var statearr_20796_20845 = state_20782__$1;
(statearr_20796_20845[(1)] = (23));

} else {
var statearr_20797_20846 = state_20782__$1;
(statearr_20797_20846[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (6))){
var inst_20713 = (state_20782[(8)]);
var inst_20763 = (state_20782[(11)]);
var inst_20761 = (state_20782[(7)]);
var inst_20761__$1 = topic_fn.call(null,inst_20713);
var inst_20762 = cljs.core.deref.call(null,mults);
var inst_20763__$1 = cljs.core.get.call(null,inst_20762,inst_20761__$1);
var state_20782__$1 = (function (){var statearr_20798 = state_20782;
(statearr_20798[(11)] = inst_20763__$1);

(statearr_20798[(7)] = inst_20761__$1);

return statearr_20798;
})();
if(cljs.core.truth_(inst_20763__$1)){
var statearr_20799_20847 = state_20782__$1;
(statearr_20799_20847[(1)] = (19));

} else {
var statearr_20800_20848 = state_20782__$1;
(statearr_20800_20848[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (25))){
var inst_20772 = (state_20782[(2)]);
var state_20782__$1 = state_20782;
var statearr_20801_20849 = state_20782__$1;
(statearr_20801_20849[(2)] = inst_20772);

(statearr_20801_20849[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (17))){
var inst_20737 = (state_20782[(10)]);
var inst_20746 = cljs.core.first.call(null,inst_20737);
var inst_20747 = cljs.core.async.muxch_STAR_.call(null,inst_20746);
var inst_20748 = cljs.core.async.close_BANG_.call(null,inst_20747);
var inst_20749 = cljs.core.next.call(null,inst_20737);
var inst_20723 = inst_20749;
var inst_20724 = null;
var inst_20725 = (0);
var inst_20726 = (0);
var state_20782__$1 = (function (){var statearr_20802 = state_20782;
(statearr_20802[(12)] = inst_20726);

(statearr_20802[(13)] = inst_20748);

(statearr_20802[(14)] = inst_20723);

(statearr_20802[(15)] = inst_20724);

(statearr_20802[(16)] = inst_20725);

return statearr_20802;
})();
var statearr_20803_20850 = state_20782__$1;
(statearr_20803_20850[(2)] = null);

(statearr_20803_20850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (3))){
var inst_20780 = (state_20782[(2)]);
var state_20782__$1 = state_20782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20782__$1,inst_20780);
} else {
if((state_val_20783 === (12))){
var inst_20757 = (state_20782[(2)]);
var state_20782__$1 = state_20782;
var statearr_20804_20851 = state_20782__$1;
(statearr_20804_20851[(2)] = inst_20757);

(statearr_20804_20851[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (2))){
var state_20782__$1 = state_20782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20782__$1,(4),ch);
} else {
if((state_val_20783 === (23))){
var state_20782__$1 = state_20782;
var statearr_20805_20852 = state_20782__$1;
(statearr_20805_20852[(2)] = null);

(statearr_20805_20852[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (19))){
var inst_20713 = (state_20782[(8)]);
var inst_20763 = (state_20782[(11)]);
var inst_20765 = cljs.core.async.muxch_STAR_.call(null,inst_20763);
var state_20782__$1 = state_20782;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20782__$1,(22),inst_20765,inst_20713);
} else {
if((state_val_20783 === (11))){
var inst_20723 = (state_20782[(14)]);
var inst_20737 = (state_20782[(10)]);
var inst_20737__$1 = cljs.core.seq.call(null,inst_20723);
var state_20782__$1 = (function (){var statearr_20806 = state_20782;
(statearr_20806[(10)] = inst_20737__$1);

return statearr_20806;
})();
if(inst_20737__$1){
var statearr_20807_20853 = state_20782__$1;
(statearr_20807_20853[(1)] = (13));

} else {
var statearr_20808_20854 = state_20782__$1;
(statearr_20808_20854[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (9))){
var inst_20759 = (state_20782[(2)]);
var state_20782__$1 = state_20782;
var statearr_20809_20855 = state_20782__$1;
(statearr_20809_20855[(2)] = inst_20759);

(statearr_20809_20855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (5))){
var inst_20720 = cljs.core.deref.call(null,mults);
var inst_20721 = cljs.core.vals.call(null,inst_20720);
var inst_20722 = cljs.core.seq.call(null,inst_20721);
var inst_20723 = inst_20722;
var inst_20724 = null;
var inst_20725 = (0);
var inst_20726 = (0);
var state_20782__$1 = (function (){var statearr_20810 = state_20782;
(statearr_20810[(12)] = inst_20726);

(statearr_20810[(14)] = inst_20723);

(statearr_20810[(15)] = inst_20724);

(statearr_20810[(16)] = inst_20725);

return statearr_20810;
})();
var statearr_20811_20856 = state_20782__$1;
(statearr_20811_20856[(2)] = null);

(statearr_20811_20856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (14))){
var state_20782__$1 = state_20782;
var statearr_20815_20857 = state_20782__$1;
(statearr_20815_20857[(2)] = null);

(statearr_20815_20857[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (16))){
var inst_20737 = (state_20782[(10)]);
var inst_20741 = cljs.core.chunk_first.call(null,inst_20737);
var inst_20742 = cljs.core.chunk_rest.call(null,inst_20737);
var inst_20743 = cljs.core.count.call(null,inst_20741);
var inst_20723 = inst_20742;
var inst_20724 = inst_20741;
var inst_20725 = inst_20743;
var inst_20726 = (0);
var state_20782__$1 = (function (){var statearr_20816 = state_20782;
(statearr_20816[(12)] = inst_20726);

(statearr_20816[(14)] = inst_20723);

(statearr_20816[(15)] = inst_20724);

(statearr_20816[(16)] = inst_20725);

return statearr_20816;
})();
var statearr_20817_20858 = state_20782__$1;
(statearr_20817_20858[(2)] = null);

(statearr_20817_20858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (10))){
var inst_20726 = (state_20782[(12)]);
var inst_20723 = (state_20782[(14)]);
var inst_20724 = (state_20782[(15)]);
var inst_20725 = (state_20782[(16)]);
var inst_20731 = cljs.core._nth.call(null,inst_20724,inst_20726);
var inst_20732 = cljs.core.async.muxch_STAR_.call(null,inst_20731);
var inst_20733 = cljs.core.async.close_BANG_.call(null,inst_20732);
var inst_20734 = (inst_20726 + (1));
var tmp20812 = inst_20723;
var tmp20813 = inst_20724;
var tmp20814 = inst_20725;
var inst_20723__$1 = tmp20812;
var inst_20724__$1 = tmp20813;
var inst_20725__$1 = tmp20814;
var inst_20726__$1 = inst_20734;
var state_20782__$1 = (function (){var statearr_20818 = state_20782;
(statearr_20818[(12)] = inst_20726__$1);

(statearr_20818[(14)] = inst_20723__$1);

(statearr_20818[(15)] = inst_20724__$1);

(statearr_20818[(17)] = inst_20733);

(statearr_20818[(16)] = inst_20725__$1);

return statearr_20818;
})();
var statearr_20819_20859 = state_20782__$1;
(statearr_20819_20859[(2)] = null);

(statearr_20819_20859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (18))){
var inst_20752 = (state_20782[(2)]);
var state_20782__$1 = state_20782;
var statearr_20820_20860 = state_20782__$1;
(statearr_20820_20860[(2)] = inst_20752);

(statearr_20820_20860[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20783 === (8))){
var inst_20726 = (state_20782[(12)]);
var inst_20725 = (state_20782[(16)]);
var inst_20728 = (inst_20726 < inst_20725);
var inst_20729 = inst_20728;
var state_20782__$1 = state_20782;
if(cljs.core.truth_(inst_20729)){
var statearr_20821_20861 = state_20782__$1;
(statearr_20821_20861[(1)] = (10));

} else {
var statearr_20822_20862 = state_20782__$1;
(statearr_20822_20862[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___20834,mults,ensure_mult,p))
;
return ((function (switch__10959__auto__,c__11071__auto___20834,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_20826 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20826[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_20826[(1)] = (1));

return statearr_20826;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_20782){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_20782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e20827){if((e20827 instanceof Object)){
var ex__10963__auto__ = e20827;
var statearr_20828_20863 = state_20782;
(statearr_20828_20863[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20782);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20827;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20864 = state_20782;
state_20782 = G__20864;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_20782){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_20782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___20834,mults,ensure_mult,p))
})();
var state__11073__auto__ = (function (){var statearr_20829 = f__11072__auto__.call(null);
(statearr_20829[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___20834);

return statearr_20829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___20834,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20865 = [];
var len__5726__auto___20868 = arguments.length;
var i__5727__auto___20869 = (0);
while(true){
if((i__5727__auto___20869 < len__5726__auto___20868)){
args20865.push((arguments[i__5727__auto___20869]));

var G__20870 = (i__5727__auto___20869 + (1));
i__5727__auto___20869 = G__20870;
continue;
} else {
}
break;
}

var G__20867 = args20865.length;
switch (G__20867) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20865.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20872 = [];
var len__5726__auto___20875 = arguments.length;
var i__5727__auto___20876 = (0);
while(true){
if((i__5727__auto___20876 < len__5726__auto___20875)){
args20872.push((arguments[i__5727__auto___20876]));

var G__20877 = (i__5727__auto___20876 + (1));
i__5727__auto___20876 = G__20877;
continue;
} else {
}
break;
}

var G__20874 = args20872.length;
switch (G__20874) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20872.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20879 = [];
var len__5726__auto___20950 = arguments.length;
var i__5727__auto___20951 = (0);
while(true){
if((i__5727__auto___20951 < len__5726__auto___20950)){
args20879.push((arguments[i__5727__auto___20951]));

var G__20952 = (i__5727__auto___20951 + (1));
i__5727__auto___20951 = G__20952;
continue;
} else {
}
break;
}

var G__20881 = args20879.length;
switch (G__20881) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20879.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11071__auto___20954 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___20954,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___20954,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20920){
var state_val_20921 = (state_20920[(1)]);
if((state_val_20921 === (7))){
var state_20920__$1 = state_20920;
var statearr_20922_20955 = state_20920__$1;
(statearr_20922_20955[(2)] = null);

(statearr_20922_20955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (1))){
var state_20920__$1 = state_20920;
var statearr_20923_20956 = state_20920__$1;
(statearr_20923_20956[(2)] = null);

(statearr_20923_20956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (4))){
var inst_20884 = (state_20920[(7)]);
var inst_20886 = (inst_20884 < cnt);
var state_20920__$1 = state_20920;
if(cljs.core.truth_(inst_20886)){
var statearr_20924_20957 = state_20920__$1;
(statearr_20924_20957[(1)] = (6));

} else {
var statearr_20925_20958 = state_20920__$1;
(statearr_20925_20958[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (15))){
var inst_20916 = (state_20920[(2)]);
var state_20920__$1 = state_20920;
var statearr_20926_20959 = state_20920__$1;
(statearr_20926_20959[(2)] = inst_20916);

(statearr_20926_20959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (13))){
var inst_20909 = cljs.core.async.close_BANG_.call(null,out);
var state_20920__$1 = state_20920;
var statearr_20927_20960 = state_20920__$1;
(statearr_20927_20960[(2)] = inst_20909);

(statearr_20927_20960[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (6))){
var state_20920__$1 = state_20920;
var statearr_20928_20961 = state_20920__$1;
(statearr_20928_20961[(2)] = null);

(statearr_20928_20961[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (3))){
var inst_20918 = (state_20920[(2)]);
var state_20920__$1 = state_20920;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20920__$1,inst_20918);
} else {
if((state_val_20921 === (12))){
var inst_20906 = (state_20920[(8)]);
var inst_20906__$1 = (state_20920[(2)]);
var inst_20907 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20906__$1);
var state_20920__$1 = (function (){var statearr_20929 = state_20920;
(statearr_20929[(8)] = inst_20906__$1);

return statearr_20929;
})();
if(cljs.core.truth_(inst_20907)){
var statearr_20930_20962 = state_20920__$1;
(statearr_20930_20962[(1)] = (13));

} else {
var statearr_20931_20963 = state_20920__$1;
(statearr_20931_20963[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (2))){
var inst_20883 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20884 = (0);
var state_20920__$1 = (function (){var statearr_20932 = state_20920;
(statearr_20932[(9)] = inst_20883);

(statearr_20932[(7)] = inst_20884);

return statearr_20932;
})();
var statearr_20933_20964 = state_20920__$1;
(statearr_20933_20964[(2)] = null);

(statearr_20933_20964[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (11))){
var inst_20884 = (state_20920[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20920,(10),Object,null,(9));
var inst_20893 = chs__$1.call(null,inst_20884);
var inst_20894 = done.call(null,inst_20884);
var inst_20895 = cljs.core.async.take_BANG_.call(null,inst_20893,inst_20894);
var state_20920__$1 = state_20920;
var statearr_20934_20965 = state_20920__$1;
(statearr_20934_20965[(2)] = inst_20895);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20920__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (9))){
var inst_20884 = (state_20920[(7)]);
var inst_20897 = (state_20920[(2)]);
var inst_20898 = (inst_20884 + (1));
var inst_20884__$1 = inst_20898;
var state_20920__$1 = (function (){var statearr_20935 = state_20920;
(statearr_20935[(10)] = inst_20897);

(statearr_20935[(7)] = inst_20884__$1);

return statearr_20935;
})();
var statearr_20936_20966 = state_20920__$1;
(statearr_20936_20966[(2)] = null);

(statearr_20936_20966[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (5))){
var inst_20904 = (state_20920[(2)]);
var state_20920__$1 = (function (){var statearr_20937 = state_20920;
(statearr_20937[(11)] = inst_20904);

return statearr_20937;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20920__$1,(12),dchan);
} else {
if((state_val_20921 === (14))){
var inst_20906 = (state_20920[(8)]);
var inst_20911 = cljs.core.apply.call(null,f,inst_20906);
var state_20920__$1 = state_20920;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20920__$1,(16),out,inst_20911);
} else {
if((state_val_20921 === (16))){
var inst_20913 = (state_20920[(2)]);
var state_20920__$1 = (function (){var statearr_20938 = state_20920;
(statearr_20938[(12)] = inst_20913);

return statearr_20938;
})();
var statearr_20939_20967 = state_20920__$1;
(statearr_20939_20967[(2)] = null);

(statearr_20939_20967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (10))){
var inst_20888 = (state_20920[(2)]);
var inst_20889 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20920__$1 = (function (){var statearr_20940 = state_20920;
(statearr_20940[(13)] = inst_20888);

return statearr_20940;
})();
var statearr_20941_20968 = state_20920__$1;
(statearr_20941_20968[(2)] = inst_20889);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20920__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20921 === (8))){
var inst_20902 = (state_20920[(2)]);
var state_20920__$1 = state_20920;
var statearr_20942_20969 = state_20920__$1;
(statearr_20942_20969[(2)] = inst_20902);

(statearr_20942_20969[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___20954,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10959__auto__,c__11071__auto___20954,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_20946 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20946[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_20946[(1)] = (1));

return statearr_20946;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_20920){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_20920);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e20947){if((e20947 instanceof Object)){
var ex__10963__auto__ = e20947;
var statearr_20948_20970 = state_20920;
(statearr_20948_20970[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20920);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20947;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20971 = state_20920;
state_20920 = G__20971;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_20920){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_20920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___20954,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11073__auto__ = (function (){var statearr_20949 = f__11072__auto__.call(null);
(statearr_20949[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___20954);

return statearr_20949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___20954,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20973 = [];
var len__5726__auto___21029 = arguments.length;
var i__5727__auto___21030 = (0);
while(true){
if((i__5727__auto___21030 < len__5726__auto___21029)){
args20973.push((arguments[i__5727__auto___21030]));

var G__21031 = (i__5727__auto___21030 + (1));
i__5727__auto___21030 = G__21031;
continue;
} else {
}
break;
}

var G__20975 = args20973.length;
switch (G__20975) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20973.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___21033 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___21033,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___21033,out){
return (function (state_21005){
var state_val_21006 = (state_21005[(1)]);
if((state_val_21006 === (7))){
var inst_20984 = (state_21005[(7)]);
var inst_20985 = (state_21005[(8)]);
var inst_20984__$1 = (state_21005[(2)]);
var inst_20985__$1 = cljs.core.nth.call(null,inst_20984__$1,(0),null);
var inst_20986 = cljs.core.nth.call(null,inst_20984__$1,(1),null);
var inst_20987 = (inst_20985__$1 == null);
var state_21005__$1 = (function (){var statearr_21007 = state_21005;
(statearr_21007[(7)] = inst_20984__$1);

(statearr_21007[(9)] = inst_20986);

(statearr_21007[(8)] = inst_20985__$1);

return statearr_21007;
})();
if(cljs.core.truth_(inst_20987)){
var statearr_21008_21034 = state_21005__$1;
(statearr_21008_21034[(1)] = (8));

} else {
var statearr_21009_21035 = state_21005__$1;
(statearr_21009_21035[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21006 === (1))){
var inst_20976 = cljs.core.vec.call(null,chs);
var inst_20977 = inst_20976;
var state_21005__$1 = (function (){var statearr_21010 = state_21005;
(statearr_21010[(10)] = inst_20977);

return statearr_21010;
})();
var statearr_21011_21036 = state_21005__$1;
(statearr_21011_21036[(2)] = null);

(statearr_21011_21036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21006 === (4))){
var inst_20977 = (state_21005[(10)]);
var state_21005__$1 = state_21005;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21005__$1,(7),inst_20977);
} else {
if((state_val_21006 === (6))){
var inst_21001 = (state_21005[(2)]);
var state_21005__$1 = state_21005;
var statearr_21012_21037 = state_21005__$1;
(statearr_21012_21037[(2)] = inst_21001);

(statearr_21012_21037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21006 === (3))){
var inst_21003 = (state_21005[(2)]);
var state_21005__$1 = state_21005;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21005__$1,inst_21003);
} else {
if((state_val_21006 === (2))){
var inst_20977 = (state_21005[(10)]);
var inst_20979 = cljs.core.count.call(null,inst_20977);
var inst_20980 = (inst_20979 > (0));
var state_21005__$1 = state_21005;
if(cljs.core.truth_(inst_20980)){
var statearr_21014_21038 = state_21005__$1;
(statearr_21014_21038[(1)] = (4));

} else {
var statearr_21015_21039 = state_21005__$1;
(statearr_21015_21039[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21006 === (11))){
var inst_20977 = (state_21005[(10)]);
var inst_20994 = (state_21005[(2)]);
var tmp21013 = inst_20977;
var inst_20977__$1 = tmp21013;
var state_21005__$1 = (function (){var statearr_21016 = state_21005;
(statearr_21016[(11)] = inst_20994);

(statearr_21016[(10)] = inst_20977__$1);

return statearr_21016;
})();
var statearr_21017_21040 = state_21005__$1;
(statearr_21017_21040[(2)] = null);

(statearr_21017_21040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21006 === (9))){
var inst_20985 = (state_21005[(8)]);
var state_21005__$1 = state_21005;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21005__$1,(11),out,inst_20985);
} else {
if((state_val_21006 === (5))){
var inst_20999 = cljs.core.async.close_BANG_.call(null,out);
var state_21005__$1 = state_21005;
var statearr_21018_21041 = state_21005__$1;
(statearr_21018_21041[(2)] = inst_20999);

(statearr_21018_21041[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21006 === (10))){
var inst_20997 = (state_21005[(2)]);
var state_21005__$1 = state_21005;
var statearr_21019_21042 = state_21005__$1;
(statearr_21019_21042[(2)] = inst_20997);

(statearr_21019_21042[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21006 === (8))){
var inst_20984 = (state_21005[(7)]);
var inst_20986 = (state_21005[(9)]);
var inst_20985 = (state_21005[(8)]);
var inst_20977 = (state_21005[(10)]);
var inst_20989 = (function (){var cs = inst_20977;
var vec__20982 = inst_20984;
var v = inst_20985;
var c = inst_20986;
return ((function (cs,vec__20982,v,c,inst_20984,inst_20986,inst_20985,inst_20977,state_val_21006,c__11071__auto___21033,out){
return (function (p1__20972_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20972_SHARP_);
});
;})(cs,vec__20982,v,c,inst_20984,inst_20986,inst_20985,inst_20977,state_val_21006,c__11071__auto___21033,out))
})();
var inst_20990 = cljs.core.filterv.call(null,inst_20989,inst_20977);
var inst_20977__$1 = inst_20990;
var state_21005__$1 = (function (){var statearr_21020 = state_21005;
(statearr_21020[(10)] = inst_20977__$1);

return statearr_21020;
})();
var statearr_21021_21043 = state_21005__$1;
(statearr_21021_21043[(2)] = null);

(statearr_21021_21043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___21033,out))
;
return ((function (switch__10959__auto__,c__11071__auto___21033,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_21025 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21025[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_21025[(1)] = (1));

return statearr_21025;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_21005){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_21005);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e21026){if((e21026 instanceof Object)){
var ex__10963__auto__ = e21026;
var statearr_21027_21044 = state_21005;
(statearr_21027_21044[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21005);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21026;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21045 = state_21005;
state_21005 = G__21045;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_21005){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_21005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___21033,out))
})();
var state__11073__auto__ = (function (){var statearr_21028 = f__11072__auto__.call(null);
(statearr_21028[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___21033);

return statearr_21028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___21033,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args21046 = [];
var len__5726__auto___21095 = arguments.length;
var i__5727__auto___21096 = (0);
while(true){
if((i__5727__auto___21096 < len__5726__auto___21095)){
args21046.push((arguments[i__5727__auto___21096]));

var G__21097 = (i__5727__auto___21096 + (1));
i__5727__auto___21096 = G__21097;
continue;
} else {
}
break;
}

var G__21048 = args21046.length;
switch (G__21048) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21046.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___21099 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___21099,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___21099,out){
return (function (state_21072){
var state_val_21073 = (state_21072[(1)]);
if((state_val_21073 === (7))){
var inst_21054 = (state_21072[(7)]);
var inst_21054__$1 = (state_21072[(2)]);
var inst_21055 = (inst_21054__$1 == null);
var inst_21056 = cljs.core.not.call(null,inst_21055);
var state_21072__$1 = (function (){var statearr_21074 = state_21072;
(statearr_21074[(7)] = inst_21054__$1);

return statearr_21074;
})();
if(inst_21056){
var statearr_21075_21100 = state_21072__$1;
(statearr_21075_21100[(1)] = (8));

} else {
var statearr_21076_21101 = state_21072__$1;
(statearr_21076_21101[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (1))){
var inst_21049 = (0);
var state_21072__$1 = (function (){var statearr_21077 = state_21072;
(statearr_21077[(8)] = inst_21049);

return statearr_21077;
})();
var statearr_21078_21102 = state_21072__$1;
(statearr_21078_21102[(2)] = null);

(statearr_21078_21102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (4))){
var state_21072__$1 = state_21072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21072__$1,(7),ch);
} else {
if((state_val_21073 === (6))){
var inst_21067 = (state_21072[(2)]);
var state_21072__$1 = state_21072;
var statearr_21079_21103 = state_21072__$1;
(statearr_21079_21103[(2)] = inst_21067);

(statearr_21079_21103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (3))){
var inst_21069 = (state_21072[(2)]);
var inst_21070 = cljs.core.async.close_BANG_.call(null,out);
var state_21072__$1 = (function (){var statearr_21080 = state_21072;
(statearr_21080[(9)] = inst_21069);

return statearr_21080;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21072__$1,inst_21070);
} else {
if((state_val_21073 === (2))){
var inst_21049 = (state_21072[(8)]);
var inst_21051 = (inst_21049 < n);
var state_21072__$1 = state_21072;
if(cljs.core.truth_(inst_21051)){
var statearr_21081_21104 = state_21072__$1;
(statearr_21081_21104[(1)] = (4));

} else {
var statearr_21082_21105 = state_21072__$1;
(statearr_21082_21105[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (11))){
var inst_21049 = (state_21072[(8)]);
var inst_21059 = (state_21072[(2)]);
var inst_21060 = (inst_21049 + (1));
var inst_21049__$1 = inst_21060;
var state_21072__$1 = (function (){var statearr_21083 = state_21072;
(statearr_21083[(8)] = inst_21049__$1);

(statearr_21083[(10)] = inst_21059);

return statearr_21083;
})();
var statearr_21084_21106 = state_21072__$1;
(statearr_21084_21106[(2)] = null);

(statearr_21084_21106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (9))){
var state_21072__$1 = state_21072;
var statearr_21085_21107 = state_21072__$1;
(statearr_21085_21107[(2)] = null);

(statearr_21085_21107[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (5))){
var state_21072__$1 = state_21072;
var statearr_21086_21108 = state_21072__$1;
(statearr_21086_21108[(2)] = null);

(statearr_21086_21108[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (10))){
var inst_21064 = (state_21072[(2)]);
var state_21072__$1 = state_21072;
var statearr_21087_21109 = state_21072__$1;
(statearr_21087_21109[(2)] = inst_21064);

(statearr_21087_21109[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21073 === (8))){
var inst_21054 = (state_21072[(7)]);
var state_21072__$1 = state_21072;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21072__$1,(11),out,inst_21054);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___21099,out))
;
return ((function (switch__10959__auto__,c__11071__auto___21099,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_21091 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21091[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_21091[(1)] = (1));

return statearr_21091;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_21072){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_21072);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e21092){if((e21092 instanceof Object)){
var ex__10963__auto__ = e21092;
var statearr_21093_21110 = state_21072;
(statearr_21093_21110[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21072);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21092;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21111 = state_21072;
state_21072 = G__21111;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_21072){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_21072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___21099,out))
})();
var state__11073__auto__ = (function (){var statearr_21094 = f__11072__auto__.call(null);
(statearr_21094[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___21099);

return statearr_21094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___21099,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21119 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21119 = (function (map_LT_,f,ch,meta21120){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21120 = meta21120;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21121,meta21120__$1){
var self__ = this;
var _21121__$1 = this;
return (new cljs.core.async.t_cljs$core$async21119(self__.map_LT_,self__.f,self__.ch,meta21120__$1));
});

cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21121){
var self__ = this;
var _21121__$1 = this;
return self__.meta21120;
});

cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21122 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21122 = (function (map_LT_,f,ch,meta21120,_,fn1,meta21123){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21120 = meta21120;
this._ = _;
this.fn1 = fn1;
this.meta21123 = meta21123;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21122.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21124,meta21123__$1){
var self__ = this;
var _21124__$1 = this;
return (new cljs.core.async.t_cljs$core$async21122(self__.map_LT_,self__.f,self__.ch,self__.meta21120,self__._,self__.fn1,meta21123__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21122.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21124){
var self__ = this;
var _21124__$1 = this;
return self__.meta21123;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21122.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21122.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21122.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21122.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21112_SHARP_){
return f1.call(null,(((p1__21112_SHARP_ == null))?null:self__.f.call(null,p1__21112_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21122.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21120","meta21120",1203345282,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21119","cljs.core.async/t_cljs$core$async21119",-2082919569,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21123","meta21123",-403585273,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21122.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21122.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21122";

cljs.core.async.t_cljs$core$async21122.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21122");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21122 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21122(map_LT___$1,f__$1,ch__$1,meta21120__$1,___$2,fn1__$1,meta21123){
return (new cljs.core.async.t_cljs$core$async21122(map_LT___$1,f__$1,ch__$1,meta21120__$1,___$2,fn1__$1,meta21123));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21122(self__.map_LT_,self__.f,self__.ch,self__.meta21120,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21119.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21119.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21120","meta21120",1203345282,null)], null);
});

cljs.core.async.t_cljs$core$async21119.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21119.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21119";

cljs.core.async.t_cljs$core$async21119.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21119");
});

cljs.core.async.__GT_t_cljs$core$async21119 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21119(map_LT___$1,f__$1,ch__$1,meta21120){
return (new cljs.core.async.t_cljs$core$async21119(map_LT___$1,f__$1,ch__$1,meta21120));
});

}

return (new cljs.core.async.t_cljs$core$async21119(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21128 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21128 = (function (map_GT_,f,ch,meta21129){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21129 = meta21129;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21128.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21130,meta21129__$1){
var self__ = this;
var _21130__$1 = this;
return (new cljs.core.async.t_cljs$core$async21128(self__.map_GT_,self__.f,self__.ch,meta21129__$1));
});

cljs.core.async.t_cljs$core$async21128.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21130){
var self__ = this;
var _21130__$1 = this;
return self__.meta21129;
});

cljs.core.async.t_cljs$core$async21128.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21128.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21128.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21128.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21128.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21128.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21128.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21129","meta21129",1410665108,null)], null);
});

cljs.core.async.t_cljs$core$async21128.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21128.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21128";

cljs.core.async.t_cljs$core$async21128.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21128");
});

cljs.core.async.__GT_t_cljs$core$async21128 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21128(map_GT___$1,f__$1,ch__$1,meta21129){
return (new cljs.core.async.t_cljs$core$async21128(map_GT___$1,f__$1,ch__$1,meta21129));
});

}

return (new cljs.core.async.t_cljs$core$async21128(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21134 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21134 = (function (filter_GT_,p,ch,meta21135){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21135 = meta21135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21136,meta21135__$1){
var self__ = this;
var _21136__$1 = this;
return (new cljs.core.async.t_cljs$core$async21134(self__.filter_GT_,self__.p,self__.ch,meta21135__$1));
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21136){
var self__ = this;
var _21136__$1 = this;
return self__.meta21135;
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21134.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21135","meta21135",-32798175,null)], null);
});

cljs.core.async.t_cljs$core$async21134.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21134.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21134";

cljs.core.async.t_cljs$core$async21134.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21134");
});

cljs.core.async.__GT_t_cljs$core$async21134 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21134(filter_GT___$1,p__$1,ch__$1,meta21135){
return (new cljs.core.async.t_cljs$core$async21134(filter_GT___$1,p__$1,ch__$1,meta21135));
});

}

return (new cljs.core.async.t_cljs$core$async21134(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21137 = [];
var len__5726__auto___21181 = arguments.length;
var i__5727__auto___21182 = (0);
while(true){
if((i__5727__auto___21182 < len__5726__auto___21181)){
args21137.push((arguments[i__5727__auto___21182]));

var G__21183 = (i__5727__auto___21182 + (1));
i__5727__auto___21182 = G__21183;
continue;
} else {
}
break;
}

var G__21139 = args21137.length;
switch (G__21139) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21137.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___21185 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___21185,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___21185,out){
return (function (state_21160){
var state_val_21161 = (state_21160[(1)]);
if((state_val_21161 === (7))){
var inst_21156 = (state_21160[(2)]);
var state_21160__$1 = state_21160;
var statearr_21162_21186 = state_21160__$1;
(statearr_21162_21186[(2)] = inst_21156);

(statearr_21162_21186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21161 === (1))){
var state_21160__$1 = state_21160;
var statearr_21163_21187 = state_21160__$1;
(statearr_21163_21187[(2)] = null);

(statearr_21163_21187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21161 === (4))){
var inst_21142 = (state_21160[(7)]);
var inst_21142__$1 = (state_21160[(2)]);
var inst_21143 = (inst_21142__$1 == null);
var state_21160__$1 = (function (){var statearr_21164 = state_21160;
(statearr_21164[(7)] = inst_21142__$1);

return statearr_21164;
})();
if(cljs.core.truth_(inst_21143)){
var statearr_21165_21188 = state_21160__$1;
(statearr_21165_21188[(1)] = (5));

} else {
var statearr_21166_21189 = state_21160__$1;
(statearr_21166_21189[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21161 === (6))){
var inst_21142 = (state_21160[(7)]);
var inst_21147 = p.call(null,inst_21142);
var state_21160__$1 = state_21160;
if(cljs.core.truth_(inst_21147)){
var statearr_21167_21190 = state_21160__$1;
(statearr_21167_21190[(1)] = (8));

} else {
var statearr_21168_21191 = state_21160__$1;
(statearr_21168_21191[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21161 === (3))){
var inst_21158 = (state_21160[(2)]);
var state_21160__$1 = state_21160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21160__$1,inst_21158);
} else {
if((state_val_21161 === (2))){
var state_21160__$1 = state_21160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21160__$1,(4),ch);
} else {
if((state_val_21161 === (11))){
var inst_21150 = (state_21160[(2)]);
var state_21160__$1 = state_21160;
var statearr_21169_21192 = state_21160__$1;
(statearr_21169_21192[(2)] = inst_21150);

(statearr_21169_21192[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21161 === (9))){
var state_21160__$1 = state_21160;
var statearr_21170_21193 = state_21160__$1;
(statearr_21170_21193[(2)] = null);

(statearr_21170_21193[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21161 === (5))){
var inst_21145 = cljs.core.async.close_BANG_.call(null,out);
var state_21160__$1 = state_21160;
var statearr_21171_21194 = state_21160__$1;
(statearr_21171_21194[(2)] = inst_21145);

(statearr_21171_21194[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21161 === (10))){
var inst_21153 = (state_21160[(2)]);
var state_21160__$1 = (function (){var statearr_21172 = state_21160;
(statearr_21172[(8)] = inst_21153);

return statearr_21172;
})();
var statearr_21173_21195 = state_21160__$1;
(statearr_21173_21195[(2)] = null);

(statearr_21173_21195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21161 === (8))){
var inst_21142 = (state_21160[(7)]);
var state_21160__$1 = state_21160;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21160__$1,(11),out,inst_21142);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___21185,out))
;
return ((function (switch__10959__auto__,c__11071__auto___21185,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_21177 = [null,null,null,null,null,null,null,null,null];
(statearr_21177[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_21177[(1)] = (1));

return statearr_21177;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_21160){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_21160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e21178){if((e21178 instanceof Object)){
var ex__10963__auto__ = e21178;
var statearr_21179_21196 = state_21160;
(statearr_21179_21196[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21160);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21178;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21197 = state_21160;
state_21160 = G__21197;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_21160){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_21160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___21185,out))
})();
var state__11073__auto__ = (function (){var statearr_21180 = f__11072__auto__.call(null);
(statearr_21180[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___21185);

return statearr_21180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___21185,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21198 = [];
var len__5726__auto___21201 = arguments.length;
var i__5727__auto___21202 = (0);
while(true){
if((i__5727__auto___21202 < len__5726__auto___21201)){
args21198.push((arguments[i__5727__auto___21202]));

var G__21203 = (i__5727__auto___21202 + (1));
i__5727__auto___21202 = G__21203;
continue;
} else {
}
break;
}

var G__21200 = args21198.length;
switch (G__21200) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21198.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11071__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto__){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto__){
return (function (state_21370){
var state_val_21371 = (state_21370[(1)]);
if((state_val_21371 === (7))){
var inst_21366 = (state_21370[(2)]);
var state_21370__$1 = state_21370;
var statearr_21372_21413 = state_21370__$1;
(statearr_21372_21413[(2)] = inst_21366);

(statearr_21372_21413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (20))){
var inst_21336 = (state_21370[(7)]);
var inst_21347 = (state_21370[(2)]);
var inst_21348 = cljs.core.next.call(null,inst_21336);
var inst_21322 = inst_21348;
var inst_21323 = null;
var inst_21324 = (0);
var inst_21325 = (0);
var state_21370__$1 = (function (){var statearr_21373 = state_21370;
(statearr_21373[(8)] = inst_21322);

(statearr_21373[(9)] = inst_21323);

(statearr_21373[(10)] = inst_21325);

(statearr_21373[(11)] = inst_21324);

(statearr_21373[(12)] = inst_21347);

return statearr_21373;
})();
var statearr_21374_21414 = state_21370__$1;
(statearr_21374_21414[(2)] = null);

(statearr_21374_21414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (1))){
var state_21370__$1 = state_21370;
var statearr_21375_21415 = state_21370__$1;
(statearr_21375_21415[(2)] = null);

(statearr_21375_21415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (4))){
var inst_21311 = (state_21370[(13)]);
var inst_21311__$1 = (state_21370[(2)]);
var inst_21312 = (inst_21311__$1 == null);
var state_21370__$1 = (function (){var statearr_21376 = state_21370;
(statearr_21376[(13)] = inst_21311__$1);

return statearr_21376;
})();
if(cljs.core.truth_(inst_21312)){
var statearr_21377_21416 = state_21370__$1;
(statearr_21377_21416[(1)] = (5));

} else {
var statearr_21378_21417 = state_21370__$1;
(statearr_21378_21417[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (15))){
var state_21370__$1 = state_21370;
var statearr_21382_21418 = state_21370__$1;
(statearr_21382_21418[(2)] = null);

(statearr_21382_21418[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (21))){
var state_21370__$1 = state_21370;
var statearr_21383_21419 = state_21370__$1;
(statearr_21383_21419[(2)] = null);

(statearr_21383_21419[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (13))){
var inst_21322 = (state_21370[(8)]);
var inst_21323 = (state_21370[(9)]);
var inst_21325 = (state_21370[(10)]);
var inst_21324 = (state_21370[(11)]);
var inst_21332 = (state_21370[(2)]);
var inst_21333 = (inst_21325 + (1));
var tmp21379 = inst_21322;
var tmp21380 = inst_21323;
var tmp21381 = inst_21324;
var inst_21322__$1 = tmp21379;
var inst_21323__$1 = tmp21380;
var inst_21324__$1 = tmp21381;
var inst_21325__$1 = inst_21333;
var state_21370__$1 = (function (){var statearr_21384 = state_21370;
(statearr_21384[(8)] = inst_21322__$1);

(statearr_21384[(9)] = inst_21323__$1);

(statearr_21384[(10)] = inst_21325__$1);

(statearr_21384[(11)] = inst_21324__$1);

(statearr_21384[(14)] = inst_21332);

return statearr_21384;
})();
var statearr_21385_21420 = state_21370__$1;
(statearr_21385_21420[(2)] = null);

(statearr_21385_21420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (22))){
var state_21370__$1 = state_21370;
var statearr_21386_21421 = state_21370__$1;
(statearr_21386_21421[(2)] = null);

(statearr_21386_21421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (6))){
var inst_21311 = (state_21370[(13)]);
var inst_21320 = f.call(null,inst_21311);
var inst_21321 = cljs.core.seq.call(null,inst_21320);
var inst_21322 = inst_21321;
var inst_21323 = null;
var inst_21324 = (0);
var inst_21325 = (0);
var state_21370__$1 = (function (){var statearr_21387 = state_21370;
(statearr_21387[(8)] = inst_21322);

(statearr_21387[(9)] = inst_21323);

(statearr_21387[(10)] = inst_21325);

(statearr_21387[(11)] = inst_21324);

return statearr_21387;
})();
var statearr_21388_21422 = state_21370__$1;
(statearr_21388_21422[(2)] = null);

(statearr_21388_21422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (17))){
var inst_21336 = (state_21370[(7)]);
var inst_21340 = cljs.core.chunk_first.call(null,inst_21336);
var inst_21341 = cljs.core.chunk_rest.call(null,inst_21336);
var inst_21342 = cljs.core.count.call(null,inst_21340);
var inst_21322 = inst_21341;
var inst_21323 = inst_21340;
var inst_21324 = inst_21342;
var inst_21325 = (0);
var state_21370__$1 = (function (){var statearr_21389 = state_21370;
(statearr_21389[(8)] = inst_21322);

(statearr_21389[(9)] = inst_21323);

(statearr_21389[(10)] = inst_21325);

(statearr_21389[(11)] = inst_21324);

return statearr_21389;
})();
var statearr_21390_21423 = state_21370__$1;
(statearr_21390_21423[(2)] = null);

(statearr_21390_21423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (3))){
var inst_21368 = (state_21370[(2)]);
var state_21370__$1 = state_21370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21370__$1,inst_21368);
} else {
if((state_val_21371 === (12))){
var inst_21356 = (state_21370[(2)]);
var state_21370__$1 = state_21370;
var statearr_21391_21424 = state_21370__$1;
(statearr_21391_21424[(2)] = inst_21356);

(statearr_21391_21424[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (2))){
var state_21370__$1 = state_21370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21370__$1,(4),in$);
} else {
if((state_val_21371 === (23))){
var inst_21364 = (state_21370[(2)]);
var state_21370__$1 = state_21370;
var statearr_21392_21425 = state_21370__$1;
(statearr_21392_21425[(2)] = inst_21364);

(statearr_21392_21425[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (19))){
var inst_21351 = (state_21370[(2)]);
var state_21370__$1 = state_21370;
var statearr_21393_21426 = state_21370__$1;
(statearr_21393_21426[(2)] = inst_21351);

(statearr_21393_21426[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (11))){
var inst_21322 = (state_21370[(8)]);
var inst_21336 = (state_21370[(7)]);
var inst_21336__$1 = cljs.core.seq.call(null,inst_21322);
var state_21370__$1 = (function (){var statearr_21394 = state_21370;
(statearr_21394[(7)] = inst_21336__$1);

return statearr_21394;
})();
if(inst_21336__$1){
var statearr_21395_21427 = state_21370__$1;
(statearr_21395_21427[(1)] = (14));

} else {
var statearr_21396_21428 = state_21370__$1;
(statearr_21396_21428[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (9))){
var inst_21358 = (state_21370[(2)]);
var inst_21359 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21370__$1 = (function (){var statearr_21397 = state_21370;
(statearr_21397[(15)] = inst_21358);

return statearr_21397;
})();
if(cljs.core.truth_(inst_21359)){
var statearr_21398_21429 = state_21370__$1;
(statearr_21398_21429[(1)] = (21));

} else {
var statearr_21399_21430 = state_21370__$1;
(statearr_21399_21430[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (5))){
var inst_21314 = cljs.core.async.close_BANG_.call(null,out);
var state_21370__$1 = state_21370;
var statearr_21400_21431 = state_21370__$1;
(statearr_21400_21431[(2)] = inst_21314);

(statearr_21400_21431[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (14))){
var inst_21336 = (state_21370[(7)]);
var inst_21338 = cljs.core.chunked_seq_QMARK_.call(null,inst_21336);
var state_21370__$1 = state_21370;
if(inst_21338){
var statearr_21401_21432 = state_21370__$1;
(statearr_21401_21432[(1)] = (17));

} else {
var statearr_21402_21433 = state_21370__$1;
(statearr_21402_21433[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (16))){
var inst_21354 = (state_21370[(2)]);
var state_21370__$1 = state_21370;
var statearr_21403_21434 = state_21370__$1;
(statearr_21403_21434[(2)] = inst_21354);

(statearr_21403_21434[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21371 === (10))){
var inst_21323 = (state_21370[(9)]);
var inst_21325 = (state_21370[(10)]);
var inst_21330 = cljs.core._nth.call(null,inst_21323,inst_21325);
var state_21370__$1 = state_21370;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21370__$1,(13),out,inst_21330);
} else {
if((state_val_21371 === (18))){
var inst_21336 = (state_21370[(7)]);
var inst_21345 = cljs.core.first.call(null,inst_21336);
var state_21370__$1 = state_21370;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21370__$1,(20),out,inst_21345);
} else {
if((state_val_21371 === (8))){
var inst_21325 = (state_21370[(10)]);
var inst_21324 = (state_21370[(11)]);
var inst_21327 = (inst_21325 < inst_21324);
var inst_21328 = inst_21327;
var state_21370__$1 = state_21370;
if(cljs.core.truth_(inst_21328)){
var statearr_21404_21435 = state_21370__$1;
(statearr_21404_21435[(1)] = (10));

} else {
var statearr_21405_21436 = state_21370__$1;
(statearr_21405_21436[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto__))
;
return ((function (switch__10959__auto__,c__11071__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_21409 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21409[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__);

(statearr_21409[(1)] = (1));

return statearr_21409;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____1 = (function (state_21370){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_21370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e21410){if((e21410 instanceof Object)){
var ex__10963__auto__ = e21410;
var statearr_21411_21437 = state_21370;
(statearr_21411_21437[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21370);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21410;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21438 = state_21370;
state_21370 = G__21438;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__ = function(state_21370){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____1.call(this,state_21370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto__))
})();
var state__11073__auto__ = (function (){var statearr_21412 = f__11072__auto__.call(null);
(statearr_21412[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto__);

return statearr_21412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto__))
);

return c__11071__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21439 = [];
var len__5726__auto___21442 = arguments.length;
var i__5727__auto___21443 = (0);
while(true){
if((i__5727__auto___21443 < len__5726__auto___21442)){
args21439.push((arguments[i__5727__auto___21443]));

var G__21444 = (i__5727__auto___21443 + (1));
i__5727__auto___21443 = G__21444;
continue;
} else {
}
break;
}

var G__21441 = args21439.length;
switch (G__21441) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21439.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21446 = [];
var len__5726__auto___21449 = arguments.length;
var i__5727__auto___21450 = (0);
while(true){
if((i__5727__auto___21450 < len__5726__auto___21449)){
args21446.push((arguments[i__5727__auto___21450]));

var G__21451 = (i__5727__auto___21450 + (1));
i__5727__auto___21450 = G__21451;
continue;
} else {
}
break;
}

var G__21448 = args21446.length;
switch (G__21448) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21446.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21453 = [];
var len__5726__auto___21504 = arguments.length;
var i__5727__auto___21505 = (0);
while(true){
if((i__5727__auto___21505 < len__5726__auto___21504)){
args21453.push((arguments[i__5727__auto___21505]));

var G__21506 = (i__5727__auto___21505 + (1));
i__5727__auto___21505 = G__21506;
continue;
} else {
}
break;
}

var G__21455 = args21453.length;
switch (G__21455) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21453.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___21508 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___21508,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___21508,out){
return (function (state_21479){
var state_val_21480 = (state_21479[(1)]);
if((state_val_21480 === (7))){
var inst_21474 = (state_21479[(2)]);
var state_21479__$1 = state_21479;
var statearr_21481_21509 = state_21479__$1;
(statearr_21481_21509[(2)] = inst_21474);

(statearr_21481_21509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21480 === (1))){
var inst_21456 = null;
var state_21479__$1 = (function (){var statearr_21482 = state_21479;
(statearr_21482[(7)] = inst_21456);

return statearr_21482;
})();
var statearr_21483_21510 = state_21479__$1;
(statearr_21483_21510[(2)] = null);

(statearr_21483_21510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21480 === (4))){
var inst_21459 = (state_21479[(8)]);
var inst_21459__$1 = (state_21479[(2)]);
var inst_21460 = (inst_21459__$1 == null);
var inst_21461 = cljs.core.not.call(null,inst_21460);
var state_21479__$1 = (function (){var statearr_21484 = state_21479;
(statearr_21484[(8)] = inst_21459__$1);

return statearr_21484;
})();
if(inst_21461){
var statearr_21485_21511 = state_21479__$1;
(statearr_21485_21511[(1)] = (5));

} else {
var statearr_21486_21512 = state_21479__$1;
(statearr_21486_21512[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21480 === (6))){
var state_21479__$1 = state_21479;
var statearr_21487_21513 = state_21479__$1;
(statearr_21487_21513[(2)] = null);

(statearr_21487_21513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21480 === (3))){
var inst_21476 = (state_21479[(2)]);
var inst_21477 = cljs.core.async.close_BANG_.call(null,out);
var state_21479__$1 = (function (){var statearr_21488 = state_21479;
(statearr_21488[(9)] = inst_21476);

return statearr_21488;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21479__$1,inst_21477);
} else {
if((state_val_21480 === (2))){
var state_21479__$1 = state_21479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21479__$1,(4),ch);
} else {
if((state_val_21480 === (11))){
var inst_21459 = (state_21479[(8)]);
var inst_21468 = (state_21479[(2)]);
var inst_21456 = inst_21459;
var state_21479__$1 = (function (){var statearr_21489 = state_21479;
(statearr_21489[(7)] = inst_21456);

(statearr_21489[(10)] = inst_21468);

return statearr_21489;
})();
var statearr_21490_21514 = state_21479__$1;
(statearr_21490_21514[(2)] = null);

(statearr_21490_21514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21480 === (9))){
var inst_21459 = (state_21479[(8)]);
var state_21479__$1 = state_21479;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21479__$1,(11),out,inst_21459);
} else {
if((state_val_21480 === (5))){
var inst_21456 = (state_21479[(7)]);
var inst_21459 = (state_21479[(8)]);
var inst_21463 = cljs.core._EQ_.call(null,inst_21459,inst_21456);
var state_21479__$1 = state_21479;
if(inst_21463){
var statearr_21492_21515 = state_21479__$1;
(statearr_21492_21515[(1)] = (8));

} else {
var statearr_21493_21516 = state_21479__$1;
(statearr_21493_21516[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21480 === (10))){
var inst_21471 = (state_21479[(2)]);
var state_21479__$1 = state_21479;
var statearr_21494_21517 = state_21479__$1;
(statearr_21494_21517[(2)] = inst_21471);

(statearr_21494_21517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21480 === (8))){
var inst_21456 = (state_21479[(7)]);
var tmp21491 = inst_21456;
var inst_21456__$1 = tmp21491;
var state_21479__$1 = (function (){var statearr_21495 = state_21479;
(statearr_21495[(7)] = inst_21456__$1);

return statearr_21495;
})();
var statearr_21496_21518 = state_21479__$1;
(statearr_21496_21518[(2)] = null);

(statearr_21496_21518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___21508,out))
;
return ((function (switch__10959__auto__,c__11071__auto___21508,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_21500 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21500[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_21500[(1)] = (1));

return statearr_21500;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_21479){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_21479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e21501){if((e21501 instanceof Object)){
var ex__10963__auto__ = e21501;
var statearr_21502_21519 = state_21479;
(statearr_21502_21519[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21479);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21501;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21520 = state_21479;
state_21479 = G__21520;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_21479){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_21479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___21508,out))
})();
var state__11073__auto__ = (function (){var statearr_21503 = f__11072__auto__.call(null);
(statearr_21503[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___21508);

return statearr_21503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___21508,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21521 = [];
var len__5726__auto___21591 = arguments.length;
var i__5727__auto___21592 = (0);
while(true){
if((i__5727__auto___21592 < len__5726__auto___21591)){
args21521.push((arguments[i__5727__auto___21592]));

var G__21593 = (i__5727__auto___21592 + (1));
i__5727__auto___21592 = G__21593;
continue;
} else {
}
break;
}

var G__21523 = args21521.length;
switch (G__21523) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21521.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___21595 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___21595,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___21595,out){
return (function (state_21561){
var state_val_21562 = (state_21561[(1)]);
if((state_val_21562 === (7))){
var inst_21557 = (state_21561[(2)]);
var state_21561__$1 = state_21561;
var statearr_21563_21596 = state_21561__$1;
(statearr_21563_21596[(2)] = inst_21557);

(statearr_21563_21596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (1))){
var inst_21524 = (new Array(n));
var inst_21525 = inst_21524;
var inst_21526 = (0);
var state_21561__$1 = (function (){var statearr_21564 = state_21561;
(statearr_21564[(7)] = inst_21525);

(statearr_21564[(8)] = inst_21526);

return statearr_21564;
})();
var statearr_21565_21597 = state_21561__$1;
(statearr_21565_21597[(2)] = null);

(statearr_21565_21597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (4))){
var inst_21529 = (state_21561[(9)]);
var inst_21529__$1 = (state_21561[(2)]);
var inst_21530 = (inst_21529__$1 == null);
var inst_21531 = cljs.core.not.call(null,inst_21530);
var state_21561__$1 = (function (){var statearr_21566 = state_21561;
(statearr_21566[(9)] = inst_21529__$1);

return statearr_21566;
})();
if(inst_21531){
var statearr_21567_21598 = state_21561__$1;
(statearr_21567_21598[(1)] = (5));

} else {
var statearr_21568_21599 = state_21561__$1;
(statearr_21568_21599[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (15))){
var inst_21551 = (state_21561[(2)]);
var state_21561__$1 = state_21561;
var statearr_21569_21600 = state_21561__$1;
(statearr_21569_21600[(2)] = inst_21551);

(statearr_21569_21600[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (13))){
var state_21561__$1 = state_21561;
var statearr_21570_21601 = state_21561__$1;
(statearr_21570_21601[(2)] = null);

(statearr_21570_21601[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (6))){
var inst_21526 = (state_21561[(8)]);
var inst_21547 = (inst_21526 > (0));
var state_21561__$1 = state_21561;
if(cljs.core.truth_(inst_21547)){
var statearr_21571_21602 = state_21561__$1;
(statearr_21571_21602[(1)] = (12));

} else {
var statearr_21572_21603 = state_21561__$1;
(statearr_21572_21603[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (3))){
var inst_21559 = (state_21561[(2)]);
var state_21561__$1 = state_21561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21561__$1,inst_21559);
} else {
if((state_val_21562 === (12))){
var inst_21525 = (state_21561[(7)]);
var inst_21549 = cljs.core.vec.call(null,inst_21525);
var state_21561__$1 = state_21561;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21561__$1,(15),out,inst_21549);
} else {
if((state_val_21562 === (2))){
var state_21561__$1 = state_21561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21561__$1,(4),ch);
} else {
if((state_val_21562 === (11))){
var inst_21541 = (state_21561[(2)]);
var inst_21542 = (new Array(n));
var inst_21525 = inst_21542;
var inst_21526 = (0);
var state_21561__$1 = (function (){var statearr_21573 = state_21561;
(statearr_21573[(7)] = inst_21525);

(statearr_21573[(10)] = inst_21541);

(statearr_21573[(8)] = inst_21526);

return statearr_21573;
})();
var statearr_21574_21604 = state_21561__$1;
(statearr_21574_21604[(2)] = null);

(statearr_21574_21604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (9))){
var inst_21525 = (state_21561[(7)]);
var inst_21539 = cljs.core.vec.call(null,inst_21525);
var state_21561__$1 = state_21561;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21561__$1,(11),out,inst_21539);
} else {
if((state_val_21562 === (5))){
var inst_21529 = (state_21561[(9)]);
var inst_21525 = (state_21561[(7)]);
var inst_21534 = (state_21561[(11)]);
var inst_21526 = (state_21561[(8)]);
var inst_21533 = (inst_21525[inst_21526] = inst_21529);
var inst_21534__$1 = (inst_21526 + (1));
var inst_21535 = (inst_21534__$1 < n);
var state_21561__$1 = (function (){var statearr_21575 = state_21561;
(statearr_21575[(12)] = inst_21533);

(statearr_21575[(11)] = inst_21534__$1);

return statearr_21575;
})();
if(cljs.core.truth_(inst_21535)){
var statearr_21576_21605 = state_21561__$1;
(statearr_21576_21605[(1)] = (8));

} else {
var statearr_21577_21606 = state_21561__$1;
(statearr_21577_21606[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (14))){
var inst_21554 = (state_21561[(2)]);
var inst_21555 = cljs.core.async.close_BANG_.call(null,out);
var state_21561__$1 = (function (){var statearr_21579 = state_21561;
(statearr_21579[(13)] = inst_21554);

return statearr_21579;
})();
var statearr_21580_21607 = state_21561__$1;
(statearr_21580_21607[(2)] = inst_21555);

(statearr_21580_21607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (10))){
var inst_21545 = (state_21561[(2)]);
var state_21561__$1 = state_21561;
var statearr_21581_21608 = state_21561__$1;
(statearr_21581_21608[(2)] = inst_21545);

(statearr_21581_21608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21562 === (8))){
var inst_21525 = (state_21561[(7)]);
var inst_21534 = (state_21561[(11)]);
var tmp21578 = inst_21525;
var inst_21525__$1 = tmp21578;
var inst_21526 = inst_21534;
var state_21561__$1 = (function (){var statearr_21582 = state_21561;
(statearr_21582[(7)] = inst_21525__$1);

(statearr_21582[(8)] = inst_21526);

return statearr_21582;
})();
var statearr_21583_21609 = state_21561__$1;
(statearr_21583_21609[(2)] = null);

(statearr_21583_21609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___21595,out))
;
return ((function (switch__10959__auto__,c__11071__auto___21595,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_21587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21587[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_21587[(1)] = (1));

return statearr_21587;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_21561){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_21561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e21588){if((e21588 instanceof Object)){
var ex__10963__auto__ = e21588;
var statearr_21589_21610 = state_21561;
(statearr_21589_21610[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21561);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21611 = state_21561;
state_21561 = G__21611;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_21561){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_21561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___21595,out))
})();
var state__11073__auto__ = (function (){var statearr_21590 = f__11072__auto__.call(null);
(statearr_21590[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___21595);

return statearr_21590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___21595,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21612 = [];
var len__5726__auto___21686 = arguments.length;
var i__5727__auto___21687 = (0);
while(true){
if((i__5727__auto___21687 < len__5726__auto___21686)){
args21612.push((arguments[i__5727__auto___21687]));

var G__21688 = (i__5727__auto___21687 + (1));
i__5727__auto___21687 = G__21688;
continue;
} else {
}
break;
}

var G__21614 = args21612.length;
switch (G__21614) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21612.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___21690 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___21690,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___21690,out){
return (function (state_21656){
var state_val_21657 = (state_21656[(1)]);
if((state_val_21657 === (7))){
var inst_21652 = (state_21656[(2)]);
var state_21656__$1 = state_21656;
var statearr_21658_21691 = state_21656__$1;
(statearr_21658_21691[(2)] = inst_21652);

(statearr_21658_21691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (1))){
var inst_21615 = [];
var inst_21616 = inst_21615;
var inst_21617 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21656__$1 = (function (){var statearr_21659 = state_21656;
(statearr_21659[(7)] = inst_21616);

(statearr_21659[(8)] = inst_21617);

return statearr_21659;
})();
var statearr_21660_21692 = state_21656__$1;
(statearr_21660_21692[(2)] = null);

(statearr_21660_21692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (4))){
var inst_21620 = (state_21656[(9)]);
var inst_21620__$1 = (state_21656[(2)]);
var inst_21621 = (inst_21620__$1 == null);
var inst_21622 = cljs.core.not.call(null,inst_21621);
var state_21656__$1 = (function (){var statearr_21661 = state_21656;
(statearr_21661[(9)] = inst_21620__$1);

return statearr_21661;
})();
if(inst_21622){
var statearr_21662_21693 = state_21656__$1;
(statearr_21662_21693[(1)] = (5));

} else {
var statearr_21663_21694 = state_21656__$1;
(statearr_21663_21694[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (15))){
var inst_21646 = (state_21656[(2)]);
var state_21656__$1 = state_21656;
var statearr_21664_21695 = state_21656__$1;
(statearr_21664_21695[(2)] = inst_21646);

(statearr_21664_21695[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (13))){
var state_21656__$1 = state_21656;
var statearr_21665_21696 = state_21656__$1;
(statearr_21665_21696[(2)] = null);

(statearr_21665_21696[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (6))){
var inst_21616 = (state_21656[(7)]);
var inst_21641 = inst_21616.length;
var inst_21642 = (inst_21641 > (0));
var state_21656__$1 = state_21656;
if(cljs.core.truth_(inst_21642)){
var statearr_21666_21697 = state_21656__$1;
(statearr_21666_21697[(1)] = (12));

} else {
var statearr_21667_21698 = state_21656__$1;
(statearr_21667_21698[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (3))){
var inst_21654 = (state_21656[(2)]);
var state_21656__$1 = state_21656;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21656__$1,inst_21654);
} else {
if((state_val_21657 === (12))){
var inst_21616 = (state_21656[(7)]);
var inst_21644 = cljs.core.vec.call(null,inst_21616);
var state_21656__$1 = state_21656;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21656__$1,(15),out,inst_21644);
} else {
if((state_val_21657 === (2))){
var state_21656__$1 = state_21656;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21656__$1,(4),ch);
} else {
if((state_val_21657 === (11))){
var inst_21620 = (state_21656[(9)]);
var inst_21624 = (state_21656[(10)]);
var inst_21634 = (state_21656[(2)]);
var inst_21635 = [];
var inst_21636 = inst_21635.push(inst_21620);
var inst_21616 = inst_21635;
var inst_21617 = inst_21624;
var state_21656__$1 = (function (){var statearr_21668 = state_21656;
(statearr_21668[(11)] = inst_21636);

(statearr_21668[(7)] = inst_21616);

(statearr_21668[(8)] = inst_21617);

(statearr_21668[(12)] = inst_21634);

return statearr_21668;
})();
var statearr_21669_21699 = state_21656__$1;
(statearr_21669_21699[(2)] = null);

(statearr_21669_21699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (9))){
var inst_21616 = (state_21656[(7)]);
var inst_21632 = cljs.core.vec.call(null,inst_21616);
var state_21656__$1 = state_21656;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21656__$1,(11),out,inst_21632);
} else {
if((state_val_21657 === (5))){
var inst_21620 = (state_21656[(9)]);
var inst_21617 = (state_21656[(8)]);
var inst_21624 = (state_21656[(10)]);
var inst_21624__$1 = f.call(null,inst_21620);
var inst_21625 = cljs.core._EQ_.call(null,inst_21624__$1,inst_21617);
var inst_21626 = cljs.core.keyword_identical_QMARK_.call(null,inst_21617,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21627 = (inst_21625) || (inst_21626);
var state_21656__$1 = (function (){var statearr_21670 = state_21656;
(statearr_21670[(10)] = inst_21624__$1);

return statearr_21670;
})();
if(cljs.core.truth_(inst_21627)){
var statearr_21671_21700 = state_21656__$1;
(statearr_21671_21700[(1)] = (8));

} else {
var statearr_21672_21701 = state_21656__$1;
(statearr_21672_21701[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (14))){
var inst_21649 = (state_21656[(2)]);
var inst_21650 = cljs.core.async.close_BANG_.call(null,out);
var state_21656__$1 = (function (){var statearr_21674 = state_21656;
(statearr_21674[(13)] = inst_21649);

return statearr_21674;
})();
var statearr_21675_21702 = state_21656__$1;
(statearr_21675_21702[(2)] = inst_21650);

(statearr_21675_21702[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (10))){
var inst_21639 = (state_21656[(2)]);
var state_21656__$1 = state_21656;
var statearr_21676_21703 = state_21656__$1;
(statearr_21676_21703[(2)] = inst_21639);

(statearr_21676_21703[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21657 === (8))){
var inst_21620 = (state_21656[(9)]);
var inst_21616 = (state_21656[(7)]);
var inst_21624 = (state_21656[(10)]);
var inst_21629 = inst_21616.push(inst_21620);
var tmp21673 = inst_21616;
var inst_21616__$1 = tmp21673;
var inst_21617 = inst_21624;
var state_21656__$1 = (function (){var statearr_21677 = state_21656;
(statearr_21677[(14)] = inst_21629);

(statearr_21677[(7)] = inst_21616__$1);

(statearr_21677[(8)] = inst_21617);

return statearr_21677;
})();
var statearr_21678_21704 = state_21656__$1;
(statearr_21678_21704[(2)] = null);

(statearr_21678_21704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___21690,out))
;
return ((function (switch__10959__auto__,c__11071__auto___21690,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_21682 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21682[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_21682[(1)] = (1));

return statearr_21682;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_21656){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_21656);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e21683){if((e21683 instanceof Object)){
var ex__10963__auto__ = e21683;
var statearr_21684_21705 = state_21656;
(statearr_21684_21705[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21656);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21683;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21706 = state_21656;
state_21656 = G__21706;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_21656){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_21656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___21690,out))
})();
var state__11073__auto__ = (function (){var statearr_21685 = f__11072__auto__.call(null);
(statearr_21685[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___21690);

return statearr_21685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___21690,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1460640718950