// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11116 = [];
var len__5726__auto___11122 = arguments.length;
var i__5727__auto___11123 = (0);
while(true){
if((i__5727__auto___11123 < len__5726__auto___11122)){
args11116.push((arguments[i__5727__auto___11123]));

var G__11124 = (i__5727__auto___11123 + (1));
i__5727__auto___11123 = G__11124;
continue;
} else {
}
break;
}

var G__11118 = args11116.length;
switch (G__11118) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11116.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11119 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11119 = (function (f,blockable,meta11120){
this.f = f;
this.blockable = blockable;
this.meta11120 = meta11120;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11119.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11121,meta11120__$1){
var self__ = this;
var _11121__$1 = this;
return (new cljs.core.async.t_cljs$core$async11119(self__.f,self__.blockable,meta11120__$1));
});

cljs.core.async.t_cljs$core$async11119.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11121){
var self__ = this;
var _11121__$1 = this;
return self__.meta11120;
});

cljs.core.async.t_cljs$core$async11119.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11119.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11119.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11119.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11119.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11120","meta11120",1381655326,null)], null);
});

cljs.core.async.t_cljs$core$async11119.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11119.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11119";

cljs.core.async.t_cljs$core$async11119.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11119");
});

cljs.core.async.__GT_t_cljs$core$async11119 = (function cljs$core$async$__GT_t_cljs$core$async11119(f__$1,blockable__$1,meta11120){
return (new cljs.core.async.t_cljs$core$async11119(f__$1,blockable__$1,meta11120));
});

}

return (new cljs.core.async.t_cljs$core$async11119(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11128 = [];
var len__5726__auto___11131 = arguments.length;
var i__5727__auto___11132 = (0);
while(true){
if((i__5727__auto___11132 < len__5726__auto___11131)){
args11128.push((arguments[i__5727__auto___11132]));

var G__11133 = (i__5727__auto___11132 + (1));
i__5727__auto___11132 = G__11133;
continue;
} else {
}
break;
}

var G__11130 = args11128.length;
switch (G__11130) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11128.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11135 = [];
var len__5726__auto___11138 = arguments.length;
var i__5727__auto___11139 = (0);
while(true){
if((i__5727__auto___11139 < len__5726__auto___11138)){
args11135.push((arguments[i__5727__auto___11139]));

var G__11140 = (i__5727__auto___11139 + (1));
i__5727__auto___11139 = G__11140;
continue;
} else {
}
break;
}

var G__11137 = args11135.length;
switch (G__11137) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11135.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11142 = [];
var len__5726__auto___11145 = arguments.length;
var i__5727__auto___11146 = (0);
while(true){
if((i__5727__auto___11146 < len__5726__auto___11145)){
args11142.push((arguments[i__5727__auto___11146]));

var G__11147 = (i__5727__auto___11146 + (1));
i__5727__auto___11146 = G__11147;
continue;
} else {
}
break;
}

var G__11144 = args11142.length;
switch (G__11144) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11142.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11149 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11149);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11149,ret){
return (function (){
return fn1.call(null,val_11149);
});})(val_11149,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11150 = [];
var len__5726__auto___11153 = arguments.length;
var i__5727__auto___11154 = (0);
while(true){
if((i__5727__auto___11154 < len__5726__auto___11153)){
args11150.push((arguments[i__5727__auto___11154]));

var G__11155 = (i__5727__auto___11154 + (1));
i__5727__auto___11154 = G__11155;
continue;
} else {
}
break;
}

var G__11152 = args11150.length;
switch (G__11152) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11150.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___11157 = n;
var x_11158 = (0);
while(true){
if((x_11158 < n__5571__auto___11157)){
(a[x_11158] = (0));

var G__11159 = (x_11158 + (1));
x_11158 = G__11159;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11160 = (i + (1));
i = G__11160;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11164 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11164 = (function (alt_flag,flag,meta11165){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11165 = meta11165;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11164.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11166,meta11165__$1){
var self__ = this;
var _11166__$1 = this;
return (new cljs.core.async.t_cljs$core$async11164(self__.alt_flag,self__.flag,meta11165__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11164.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11166){
var self__ = this;
var _11166__$1 = this;
return self__.meta11165;
});})(flag))
;

cljs.core.async.t_cljs$core$async11164.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11164.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11164.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11164.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11164.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11165","meta11165",-1403417076,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11164.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11164.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11164";

cljs.core.async.t_cljs$core$async11164.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11164");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11164 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11164(alt_flag__$1,flag__$1,meta11165){
return (new cljs.core.async.t_cljs$core$async11164(alt_flag__$1,flag__$1,meta11165));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11164(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11170 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11170 = (function (alt_handler,flag,cb,meta11171){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11171 = meta11171;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11170.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11172,meta11171__$1){
var self__ = this;
var _11172__$1 = this;
return (new cljs.core.async.t_cljs$core$async11170(self__.alt_handler,self__.flag,self__.cb,meta11171__$1));
});

cljs.core.async.t_cljs$core$async11170.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11172){
var self__ = this;
var _11172__$1 = this;
return self__.meta11171;
});

cljs.core.async.t_cljs$core$async11170.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11170.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11170.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11170.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11170.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11171","meta11171",-1779890264,null)], null);
});

cljs.core.async.t_cljs$core$async11170.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11170.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11170";

cljs.core.async.t_cljs$core$async11170.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11170");
});

cljs.core.async.__GT_t_cljs$core$async11170 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11170(alt_handler__$1,flag__$1,cb__$1,meta11171){
return (new cljs.core.async.t_cljs$core$async11170(alt_handler__$1,flag__$1,cb__$1,meta11171));
});

}

return (new cljs.core.async.t_cljs$core$async11170(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11173_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11173_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11174_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11174_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11175 = (i + (1));
i = G__11175;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11181 = arguments.length;
var i__5727__auto___11182 = (0);
while(true){
if((i__5727__auto___11182 < len__5726__auto___11181)){
args__5733__auto__.push((arguments[i__5727__auto___11182]));

var G__11183 = (i__5727__auto___11182 + (1));
i__5727__auto___11182 = G__11183;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11178){
var map__11179 = p__11178;
var map__11179__$1 = ((((!((map__11179 == null)))?((((map__11179.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11179.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11179):map__11179);
var opts = map__11179__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11176){
var G__11177 = cljs.core.first.call(null,seq11176);
var seq11176__$1 = cljs.core.next.call(null,seq11176);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11177,seq11176__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11184 = [];
var len__5726__auto___11234 = arguments.length;
var i__5727__auto___11235 = (0);
while(true){
if((i__5727__auto___11235 < len__5726__auto___11234)){
args11184.push((arguments[i__5727__auto___11235]));

var G__11236 = (i__5727__auto___11235 + (1));
i__5727__auto___11235 = G__11236;
continue;
} else {
}
break;
}

var G__11186 = args11184.length;
switch (G__11186) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11184.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11071__auto___11238 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___11238){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___11238){
return (function (state_11210){
var state_val_11211 = (state_11210[(1)]);
if((state_val_11211 === (7))){
var inst_11206 = (state_11210[(2)]);
var state_11210__$1 = state_11210;
var statearr_11212_11239 = state_11210__$1;
(statearr_11212_11239[(2)] = inst_11206);

(statearr_11212_11239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (1))){
var state_11210__$1 = state_11210;
var statearr_11213_11240 = state_11210__$1;
(statearr_11213_11240[(2)] = null);

(statearr_11213_11240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (4))){
var inst_11189 = (state_11210[(7)]);
var inst_11189__$1 = (state_11210[(2)]);
var inst_11190 = (inst_11189__$1 == null);
var state_11210__$1 = (function (){var statearr_11214 = state_11210;
(statearr_11214[(7)] = inst_11189__$1);

return statearr_11214;
})();
if(cljs.core.truth_(inst_11190)){
var statearr_11215_11241 = state_11210__$1;
(statearr_11215_11241[(1)] = (5));

} else {
var statearr_11216_11242 = state_11210__$1;
(statearr_11216_11242[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (13))){
var state_11210__$1 = state_11210;
var statearr_11217_11243 = state_11210__$1;
(statearr_11217_11243[(2)] = null);

(statearr_11217_11243[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (6))){
var inst_11189 = (state_11210[(7)]);
var state_11210__$1 = state_11210;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11210__$1,(11),to,inst_11189);
} else {
if((state_val_11211 === (3))){
var inst_11208 = (state_11210[(2)]);
var state_11210__$1 = state_11210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11210__$1,inst_11208);
} else {
if((state_val_11211 === (12))){
var state_11210__$1 = state_11210;
var statearr_11218_11244 = state_11210__$1;
(statearr_11218_11244[(2)] = null);

(statearr_11218_11244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (2))){
var state_11210__$1 = state_11210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11210__$1,(4),from);
} else {
if((state_val_11211 === (11))){
var inst_11199 = (state_11210[(2)]);
var state_11210__$1 = state_11210;
if(cljs.core.truth_(inst_11199)){
var statearr_11219_11245 = state_11210__$1;
(statearr_11219_11245[(1)] = (12));

} else {
var statearr_11220_11246 = state_11210__$1;
(statearr_11220_11246[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (9))){
var state_11210__$1 = state_11210;
var statearr_11221_11247 = state_11210__$1;
(statearr_11221_11247[(2)] = null);

(statearr_11221_11247[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (5))){
var state_11210__$1 = state_11210;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11222_11248 = state_11210__$1;
(statearr_11222_11248[(1)] = (8));

} else {
var statearr_11223_11249 = state_11210__$1;
(statearr_11223_11249[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (14))){
var inst_11204 = (state_11210[(2)]);
var state_11210__$1 = state_11210;
var statearr_11224_11250 = state_11210__$1;
(statearr_11224_11250[(2)] = inst_11204);

(statearr_11224_11250[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (10))){
var inst_11196 = (state_11210[(2)]);
var state_11210__$1 = state_11210;
var statearr_11225_11251 = state_11210__$1;
(statearr_11225_11251[(2)] = inst_11196);

(statearr_11225_11251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11211 === (8))){
var inst_11193 = cljs.core.async.close_BANG_.call(null,to);
var state_11210__$1 = state_11210;
var statearr_11226_11252 = state_11210__$1;
(statearr_11226_11252[(2)] = inst_11193);

(statearr_11226_11252[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___11238))
;
return ((function (switch__10959__auto__,c__11071__auto___11238){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_11230 = [null,null,null,null,null,null,null,null];
(statearr_11230[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_11230[(1)] = (1));

return statearr_11230;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_11210){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11231){if((e11231 instanceof Object)){
var ex__10963__auto__ = e11231;
var statearr_11232_11253 = state_11210;
(statearr_11232_11253[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11231;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11254 = state_11210;
state_11210 = G__11254;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_11210){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_11210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___11238))
})();
var state__11073__auto__ = (function (){var statearr_11233 = f__11072__auto__.call(null);
(statearr_11233[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___11238);

return statearr_11233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___11238))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11438){
var vec__11439 = p__11438;
var v = cljs.core.nth.call(null,vec__11439,(0),null);
var p = cljs.core.nth.call(null,vec__11439,(1),null);
var job = vec__11439;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11071__auto___11621 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___11621,res,vec__11439,v,p,job,jobs,results){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___11621,res,vec__11439,v,p,job,jobs,results){
return (function (state_11444){
var state_val_11445 = (state_11444[(1)]);
if((state_val_11445 === (1))){
var state_11444__$1 = state_11444;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11444__$1,(2),res,v);
} else {
if((state_val_11445 === (2))){
var inst_11441 = (state_11444[(2)]);
var inst_11442 = cljs.core.async.close_BANG_.call(null,res);
var state_11444__$1 = (function (){var statearr_11446 = state_11444;
(statearr_11446[(7)] = inst_11441);

return statearr_11446;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11444__$1,inst_11442);
} else {
return null;
}
}
});})(c__11071__auto___11621,res,vec__11439,v,p,job,jobs,results))
;
return ((function (switch__10959__auto__,c__11071__auto___11621,res,vec__11439,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_11450 = [null,null,null,null,null,null,null,null];
(statearr_11450[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_11450[(1)] = (1));

return statearr_11450;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_11444){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11451){if((e11451 instanceof Object)){
var ex__10963__auto__ = e11451;
var statearr_11452_11622 = state_11444;
(statearr_11452_11622[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11444);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11451;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11623 = state_11444;
state_11444 = G__11623;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_11444){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_11444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___11621,res,vec__11439,v,p,job,jobs,results))
})();
var state__11073__auto__ = (function (){var statearr_11453 = f__11072__auto__.call(null);
(statearr_11453[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___11621);

return statearr_11453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___11621,res,vec__11439,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11454){
var vec__11455 = p__11454;
var v = cljs.core.nth.call(null,vec__11455,(0),null);
var p = cljs.core.nth.call(null,vec__11455,(1),null);
var job = vec__11455;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___11624 = n;
var __11625 = (0);
while(true){
if((__11625 < n__5571__auto___11624)){
var G__11456_11626 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11456_11626) {
case "compute":
var c__11071__auto___11628 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11625,c__11071__auto___11628,G__11456_11626,n__5571__auto___11624,jobs,results,process,async){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (__11625,c__11071__auto___11628,G__11456_11626,n__5571__auto___11624,jobs,results,process,async){
return (function (state_11469){
var state_val_11470 = (state_11469[(1)]);
if((state_val_11470 === (1))){
var state_11469__$1 = state_11469;
var statearr_11471_11629 = state_11469__$1;
(statearr_11471_11629[(2)] = null);

(statearr_11471_11629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11470 === (2))){
var state_11469__$1 = state_11469;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11469__$1,(4),jobs);
} else {
if((state_val_11470 === (3))){
var inst_11467 = (state_11469[(2)]);
var state_11469__$1 = state_11469;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11469__$1,inst_11467);
} else {
if((state_val_11470 === (4))){
var inst_11459 = (state_11469[(2)]);
var inst_11460 = process.call(null,inst_11459);
var state_11469__$1 = state_11469;
if(cljs.core.truth_(inst_11460)){
var statearr_11472_11630 = state_11469__$1;
(statearr_11472_11630[(1)] = (5));

} else {
var statearr_11473_11631 = state_11469__$1;
(statearr_11473_11631[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11470 === (5))){
var state_11469__$1 = state_11469;
var statearr_11474_11632 = state_11469__$1;
(statearr_11474_11632[(2)] = null);

(statearr_11474_11632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11470 === (6))){
var state_11469__$1 = state_11469;
var statearr_11475_11633 = state_11469__$1;
(statearr_11475_11633[(2)] = null);

(statearr_11475_11633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11470 === (7))){
var inst_11465 = (state_11469[(2)]);
var state_11469__$1 = state_11469;
var statearr_11476_11634 = state_11469__$1;
(statearr_11476_11634[(2)] = inst_11465);

(statearr_11476_11634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11625,c__11071__auto___11628,G__11456_11626,n__5571__auto___11624,jobs,results,process,async))
;
return ((function (__11625,switch__10959__auto__,c__11071__auto___11628,G__11456_11626,n__5571__auto___11624,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_11480 = [null,null,null,null,null,null,null];
(statearr_11480[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_11480[(1)] = (1));

return statearr_11480;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_11469){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11469);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11481){if((e11481 instanceof Object)){
var ex__10963__auto__ = e11481;
var statearr_11482_11635 = state_11469;
(statearr_11482_11635[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11469);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11481;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11636 = state_11469;
state_11469 = G__11636;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_11469){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_11469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(__11625,switch__10959__auto__,c__11071__auto___11628,G__11456_11626,n__5571__auto___11624,jobs,results,process,async))
})();
var state__11073__auto__ = (function (){var statearr_11483 = f__11072__auto__.call(null);
(statearr_11483[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___11628);

return statearr_11483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(__11625,c__11071__auto___11628,G__11456_11626,n__5571__auto___11624,jobs,results,process,async))
);


break;
case "async":
var c__11071__auto___11637 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11625,c__11071__auto___11637,G__11456_11626,n__5571__auto___11624,jobs,results,process,async){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (__11625,c__11071__auto___11637,G__11456_11626,n__5571__auto___11624,jobs,results,process,async){
return (function (state_11496){
var state_val_11497 = (state_11496[(1)]);
if((state_val_11497 === (1))){
var state_11496__$1 = state_11496;
var statearr_11498_11638 = state_11496__$1;
(statearr_11498_11638[(2)] = null);

(statearr_11498_11638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11497 === (2))){
var state_11496__$1 = state_11496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11496__$1,(4),jobs);
} else {
if((state_val_11497 === (3))){
var inst_11494 = (state_11496[(2)]);
var state_11496__$1 = state_11496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11496__$1,inst_11494);
} else {
if((state_val_11497 === (4))){
var inst_11486 = (state_11496[(2)]);
var inst_11487 = async.call(null,inst_11486);
var state_11496__$1 = state_11496;
if(cljs.core.truth_(inst_11487)){
var statearr_11499_11639 = state_11496__$1;
(statearr_11499_11639[(1)] = (5));

} else {
var statearr_11500_11640 = state_11496__$1;
(statearr_11500_11640[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11497 === (5))){
var state_11496__$1 = state_11496;
var statearr_11501_11641 = state_11496__$1;
(statearr_11501_11641[(2)] = null);

(statearr_11501_11641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11497 === (6))){
var state_11496__$1 = state_11496;
var statearr_11502_11642 = state_11496__$1;
(statearr_11502_11642[(2)] = null);

(statearr_11502_11642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11497 === (7))){
var inst_11492 = (state_11496[(2)]);
var state_11496__$1 = state_11496;
var statearr_11503_11643 = state_11496__$1;
(statearr_11503_11643[(2)] = inst_11492);

(statearr_11503_11643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11625,c__11071__auto___11637,G__11456_11626,n__5571__auto___11624,jobs,results,process,async))
;
return ((function (__11625,switch__10959__auto__,c__11071__auto___11637,G__11456_11626,n__5571__auto___11624,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_11507 = [null,null,null,null,null,null,null];
(statearr_11507[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_11507[(1)] = (1));

return statearr_11507;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_11496){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11508){if((e11508 instanceof Object)){
var ex__10963__auto__ = e11508;
var statearr_11509_11644 = state_11496;
(statearr_11509_11644[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11645 = state_11496;
state_11496 = G__11645;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_11496){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_11496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(__11625,switch__10959__auto__,c__11071__auto___11637,G__11456_11626,n__5571__auto___11624,jobs,results,process,async))
})();
var state__11073__auto__ = (function (){var statearr_11510 = f__11072__auto__.call(null);
(statearr_11510[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___11637);

return statearr_11510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(__11625,c__11071__auto___11637,G__11456_11626,n__5571__auto___11624,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11646 = (__11625 + (1));
__11625 = G__11646;
continue;
} else {
}
break;
}

var c__11071__auto___11647 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___11647,jobs,results,process,async){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___11647,jobs,results,process,async){
return (function (state_11532){
var state_val_11533 = (state_11532[(1)]);
if((state_val_11533 === (1))){
var state_11532__$1 = state_11532;
var statearr_11534_11648 = state_11532__$1;
(statearr_11534_11648[(2)] = null);

(statearr_11534_11648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11533 === (2))){
var state_11532__$1 = state_11532;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11532__$1,(4),from);
} else {
if((state_val_11533 === (3))){
var inst_11530 = (state_11532[(2)]);
var state_11532__$1 = state_11532;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11532__$1,inst_11530);
} else {
if((state_val_11533 === (4))){
var inst_11513 = (state_11532[(7)]);
var inst_11513__$1 = (state_11532[(2)]);
var inst_11514 = (inst_11513__$1 == null);
var state_11532__$1 = (function (){var statearr_11535 = state_11532;
(statearr_11535[(7)] = inst_11513__$1);

return statearr_11535;
})();
if(cljs.core.truth_(inst_11514)){
var statearr_11536_11649 = state_11532__$1;
(statearr_11536_11649[(1)] = (5));

} else {
var statearr_11537_11650 = state_11532__$1;
(statearr_11537_11650[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11533 === (5))){
var inst_11516 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11532__$1 = state_11532;
var statearr_11538_11651 = state_11532__$1;
(statearr_11538_11651[(2)] = inst_11516);

(statearr_11538_11651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11533 === (6))){
var inst_11518 = (state_11532[(8)]);
var inst_11513 = (state_11532[(7)]);
var inst_11518__$1 = cljs.core.async.chan.call(null,(1));
var inst_11519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11520 = [inst_11513,inst_11518__$1];
var inst_11521 = (new cljs.core.PersistentVector(null,2,(5),inst_11519,inst_11520,null));
var state_11532__$1 = (function (){var statearr_11539 = state_11532;
(statearr_11539[(8)] = inst_11518__$1);

return statearr_11539;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11532__$1,(8),jobs,inst_11521);
} else {
if((state_val_11533 === (7))){
var inst_11528 = (state_11532[(2)]);
var state_11532__$1 = state_11532;
var statearr_11540_11652 = state_11532__$1;
(statearr_11540_11652[(2)] = inst_11528);

(statearr_11540_11652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11533 === (8))){
var inst_11518 = (state_11532[(8)]);
var inst_11523 = (state_11532[(2)]);
var state_11532__$1 = (function (){var statearr_11541 = state_11532;
(statearr_11541[(9)] = inst_11523);

return statearr_11541;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11532__$1,(9),results,inst_11518);
} else {
if((state_val_11533 === (9))){
var inst_11525 = (state_11532[(2)]);
var state_11532__$1 = (function (){var statearr_11542 = state_11532;
(statearr_11542[(10)] = inst_11525);

return statearr_11542;
})();
var statearr_11543_11653 = state_11532__$1;
(statearr_11543_11653[(2)] = null);

(statearr_11543_11653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___11647,jobs,results,process,async))
;
return ((function (switch__10959__auto__,c__11071__auto___11647,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_11547 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11547[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_11547[(1)] = (1));

return statearr_11547;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_11532){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11532);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11548){if((e11548 instanceof Object)){
var ex__10963__auto__ = e11548;
var statearr_11549_11654 = state_11532;
(statearr_11549_11654[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11532);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11548;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11655 = state_11532;
state_11532 = G__11655;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_11532){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_11532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___11647,jobs,results,process,async))
})();
var state__11073__auto__ = (function (){var statearr_11550 = f__11072__auto__.call(null);
(statearr_11550[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___11647);

return statearr_11550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___11647,jobs,results,process,async))
);


var c__11071__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto__,jobs,results,process,async){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto__,jobs,results,process,async){
return (function (state_11588){
var state_val_11589 = (state_11588[(1)]);
if((state_val_11589 === (7))){
var inst_11584 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
var statearr_11590_11656 = state_11588__$1;
(statearr_11590_11656[(2)] = inst_11584);

(statearr_11590_11656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (20))){
var state_11588__$1 = state_11588;
var statearr_11591_11657 = state_11588__$1;
(statearr_11591_11657[(2)] = null);

(statearr_11591_11657[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (1))){
var state_11588__$1 = state_11588;
var statearr_11592_11658 = state_11588__$1;
(statearr_11592_11658[(2)] = null);

(statearr_11592_11658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (4))){
var inst_11553 = (state_11588[(7)]);
var inst_11553__$1 = (state_11588[(2)]);
var inst_11554 = (inst_11553__$1 == null);
var state_11588__$1 = (function (){var statearr_11593 = state_11588;
(statearr_11593[(7)] = inst_11553__$1);

return statearr_11593;
})();
if(cljs.core.truth_(inst_11554)){
var statearr_11594_11659 = state_11588__$1;
(statearr_11594_11659[(1)] = (5));

} else {
var statearr_11595_11660 = state_11588__$1;
(statearr_11595_11660[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (15))){
var inst_11566 = (state_11588[(8)]);
var state_11588__$1 = state_11588;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11588__$1,(18),to,inst_11566);
} else {
if((state_val_11589 === (21))){
var inst_11579 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
var statearr_11596_11661 = state_11588__$1;
(statearr_11596_11661[(2)] = inst_11579);

(statearr_11596_11661[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (13))){
var inst_11581 = (state_11588[(2)]);
var state_11588__$1 = (function (){var statearr_11597 = state_11588;
(statearr_11597[(9)] = inst_11581);

return statearr_11597;
})();
var statearr_11598_11662 = state_11588__$1;
(statearr_11598_11662[(2)] = null);

(statearr_11598_11662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (6))){
var inst_11553 = (state_11588[(7)]);
var state_11588__$1 = state_11588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11588__$1,(11),inst_11553);
} else {
if((state_val_11589 === (17))){
var inst_11574 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
if(cljs.core.truth_(inst_11574)){
var statearr_11599_11663 = state_11588__$1;
(statearr_11599_11663[(1)] = (19));

} else {
var statearr_11600_11664 = state_11588__$1;
(statearr_11600_11664[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (3))){
var inst_11586 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11588__$1,inst_11586);
} else {
if((state_val_11589 === (12))){
var inst_11563 = (state_11588[(10)]);
var state_11588__$1 = state_11588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11588__$1,(14),inst_11563);
} else {
if((state_val_11589 === (2))){
var state_11588__$1 = state_11588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11588__$1,(4),results);
} else {
if((state_val_11589 === (19))){
var state_11588__$1 = state_11588;
var statearr_11601_11665 = state_11588__$1;
(statearr_11601_11665[(2)] = null);

(statearr_11601_11665[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (11))){
var inst_11563 = (state_11588[(2)]);
var state_11588__$1 = (function (){var statearr_11602 = state_11588;
(statearr_11602[(10)] = inst_11563);

return statearr_11602;
})();
var statearr_11603_11666 = state_11588__$1;
(statearr_11603_11666[(2)] = null);

(statearr_11603_11666[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (9))){
var state_11588__$1 = state_11588;
var statearr_11604_11667 = state_11588__$1;
(statearr_11604_11667[(2)] = null);

(statearr_11604_11667[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (5))){
var state_11588__$1 = state_11588;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11605_11668 = state_11588__$1;
(statearr_11605_11668[(1)] = (8));

} else {
var statearr_11606_11669 = state_11588__$1;
(statearr_11606_11669[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (14))){
var inst_11568 = (state_11588[(11)]);
var inst_11566 = (state_11588[(8)]);
var inst_11566__$1 = (state_11588[(2)]);
var inst_11567 = (inst_11566__$1 == null);
var inst_11568__$1 = cljs.core.not.call(null,inst_11567);
var state_11588__$1 = (function (){var statearr_11607 = state_11588;
(statearr_11607[(11)] = inst_11568__$1);

(statearr_11607[(8)] = inst_11566__$1);

return statearr_11607;
})();
if(inst_11568__$1){
var statearr_11608_11670 = state_11588__$1;
(statearr_11608_11670[(1)] = (15));

} else {
var statearr_11609_11671 = state_11588__$1;
(statearr_11609_11671[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (16))){
var inst_11568 = (state_11588[(11)]);
var state_11588__$1 = state_11588;
var statearr_11610_11672 = state_11588__$1;
(statearr_11610_11672[(2)] = inst_11568);

(statearr_11610_11672[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (10))){
var inst_11560 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
var statearr_11611_11673 = state_11588__$1;
(statearr_11611_11673[(2)] = inst_11560);

(statearr_11611_11673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (18))){
var inst_11571 = (state_11588[(2)]);
var state_11588__$1 = state_11588;
var statearr_11612_11674 = state_11588__$1;
(statearr_11612_11674[(2)] = inst_11571);

(statearr_11612_11674[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11589 === (8))){
var inst_11557 = cljs.core.async.close_BANG_.call(null,to);
var state_11588__$1 = state_11588;
var statearr_11613_11675 = state_11588__$1;
(statearr_11613_11675[(2)] = inst_11557);

(statearr_11613_11675[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto__,jobs,results,process,async))
;
return ((function (switch__10959__auto__,c__11071__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_11617 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11617[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__);

(statearr_11617[(1)] = (1));

return statearr_11617;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1 = (function (state_11588){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11618){if((e11618 instanceof Object)){
var ex__10963__auto__ = e11618;
var statearr_11619_11676 = state_11588;
(statearr_11619_11676[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11588);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11618;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11677 = state_11588;
state_11588 = G__11677;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__ = function(state_11588){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1.call(this,state_11588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto__,jobs,results,process,async))
})();
var state__11073__auto__ = (function (){var statearr_11620 = f__11072__auto__.call(null);
(statearr_11620[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto__);

return statearr_11620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto__,jobs,results,process,async))
);

return c__11071__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11678 = [];
var len__5726__auto___11681 = arguments.length;
var i__5727__auto___11682 = (0);
while(true){
if((i__5727__auto___11682 < len__5726__auto___11681)){
args11678.push((arguments[i__5727__auto___11682]));

var G__11683 = (i__5727__auto___11682 + (1));
i__5727__auto___11682 = G__11683;
continue;
} else {
}
break;
}

var G__11680 = args11678.length;
switch (G__11680) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11678.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11685 = [];
var len__5726__auto___11688 = arguments.length;
var i__5727__auto___11689 = (0);
while(true){
if((i__5727__auto___11689 < len__5726__auto___11688)){
args11685.push((arguments[i__5727__auto___11689]));

var G__11690 = (i__5727__auto___11689 + (1));
i__5727__auto___11689 = G__11690;
continue;
} else {
}
break;
}

var G__11687 = args11685.length;
switch (G__11687) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11685.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11692 = [];
var len__5726__auto___11745 = arguments.length;
var i__5727__auto___11746 = (0);
while(true){
if((i__5727__auto___11746 < len__5726__auto___11745)){
args11692.push((arguments[i__5727__auto___11746]));

var G__11747 = (i__5727__auto___11746 + (1));
i__5727__auto___11746 = G__11747;
continue;
} else {
}
break;
}

var G__11694 = args11692.length;
switch (G__11694) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11692.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11071__auto___11749 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___11749,tc,fc){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___11749,tc,fc){
return (function (state_11720){
var state_val_11721 = (state_11720[(1)]);
if((state_val_11721 === (7))){
var inst_11716 = (state_11720[(2)]);
var state_11720__$1 = state_11720;
var statearr_11722_11750 = state_11720__$1;
(statearr_11722_11750[(2)] = inst_11716);

(statearr_11722_11750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (1))){
var state_11720__$1 = state_11720;
var statearr_11723_11751 = state_11720__$1;
(statearr_11723_11751[(2)] = null);

(statearr_11723_11751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (4))){
var inst_11697 = (state_11720[(7)]);
var inst_11697__$1 = (state_11720[(2)]);
var inst_11698 = (inst_11697__$1 == null);
var state_11720__$1 = (function (){var statearr_11724 = state_11720;
(statearr_11724[(7)] = inst_11697__$1);

return statearr_11724;
})();
if(cljs.core.truth_(inst_11698)){
var statearr_11725_11752 = state_11720__$1;
(statearr_11725_11752[(1)] = (5));

} else {
var statearr_11726_11753 = state_11720__$1;
(statearr_11726_11753[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (13))){
var state_11720__$1 = state_11720;
var statearr_11727_11754 = state_11720__$1;
(statearr_11727_11754[(2)] = null);

(statearr_11727_11754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (6))){
var inst_11697 = (state_11720[(7)]);
var inst_11703 = p.call(null,inst_11697);
var state_11720__$1 = state_11720;
if(cljs.core.truth_(inst_11703)){
var statearr_11728_11755 = state_11720__$1;
(statearr_11728_11755[(1)] = (9));

} else {
var statearr_11729_11756 = state_11720__$1;
(statearr_11729_11756[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (3))){
var inst_11718 = (state_11720[(2)]);
var state_11720__$1 = state_11720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11720__$1,inst_11718);
} else {
if((state_val_11721 === (12))){
var state_11720__$1 = state_11720;
var statearr_11730_11757 = state_11720__$1;
(statearr_11730_11757[(2)] = null);

(statearr_11730_11757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (2))){
var state_11720__$1 = state_11720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11720__$1,(4),ch);
} else {
if((state_val_11721 === (11))){
var inst_11697 = (state_11720[(7)]);
var inst_11707 = (state_11720[(2)]);
var state_11720__$1 = state_11720;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11720__$1,(8),inst_11707,inst_11697);
} else {
if((state_val_11721 === (9))){
var state_11720__$1 = state_11720;
var statearr_11731_11758 = state_11720__$1;
(statearr_11731_11758[(2)] = tc);

(statearr_11731_11758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (5))){
var inst_11700 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11701 = cljs.core.async.close_BANG_.call(null,fc);
var state_11720__$1 = (function (){var statearr_11732 = state_11720;
(statearr_11732[(8)] = inst_11700);

return statearr_11732;
})();
var statearr_11733_11759 = state_11720__$1;
(statearr_11733_11759[(2)] = inst_11701);

(statearr_11733_11759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (14))){
var inst_11714 = (state_11720[(2)]);
var state_11720__$1 = state_11720;
var statearr_11734_11760 = state_11720__$1;
(statearr_11734_11760[(2)] = inst_11714);

(statearr_11734_11760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (10))){
var state_11720__$1 = state_11720;
var statearr_11735_11761 = state_11720__$1;
(statearr_11735_11761[(2)] = fc);

(statearr_11735_11761[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11721 === (8))){
var inst_11709 = (state_11720[(2)]);
var state_11720__$1 = state_11720;
if(cljs.core.truth_(inst_11709)){
var statearr_11736_11762 = state_11720__$1;
(statearr_11736_11762[(1)] = (12));

} else {
var statearr_11737_11763 = state_11720__$1;
(statearr_11737_11763[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___11749,tc,fc))
;
return ((function (switch__10959__auto__,c__11071__auto___11749,tc,fc){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_11741 = [null,null,null,null,null,null,null,null,null];
(statearr_11741[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_11741[(1)] = (1));

return statearr_11741;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_11720){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11742){if((e11742 instanceof Object)){
var ex__10963__auto__ = e11742;
var statearr_11743_11764 = state_11720;
(statearr_11743_11764[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11720);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11742;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11765 = state_11720;
state_11720 = G__11765;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_11720){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_11720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___11749,tc,fc))
})();
var state__11073__auto__ = (function (){var statearr_11744 = f__11072__auto__.call(null);
(statearr_11744[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___11749);

return statearr_11744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___11749,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11071__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto__){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto__){
return (function (state_11829){
var state_val_11830 = (state_11829[(1)]);
if((state_val_11830 === (7))){
var inst_11825 = (state_11829[(2)]);
var state_11829__$1 = state_11829;
var statearr_11831_11852 = state_11829__$1;
(statearr_11831_11852[(2)] = inst_11825);

(statearr_11831_11852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11830 === (1))){
var inst_11809 = init;
var state_11829__$1 = (function (){var statearr_11832 = state_11829;
(statearr_11832[(7)] = inst_11809);

return statearr_11832;
})();
var statearr_11833_11853 = state_11829__$1;
(statearr_11833_11853[(2)] = null);

(statearr_11833_11853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11830 === (4))){
var inst_11812 = (state_11829[(8)]);
var inst_11812__$1 = (state_11829[(2)]);
var inst_11813 = (inst_11812__$1 == null);
var state_11829__$1 = (function (){var statearr_11834 = state_11829;
(statearr_11834[(8)] = inst_11812__$1);

return statearr_11834;
})();
if(cljs.core.truth_(inst_11813)){
var statearr_11835_11854 = state_11829__$1;
(statearr_11835_11854[(1)] = (5));

} else {
var statearr_11836_11855 = state_11829__$1;
(statearr_11836_11855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11830 === (6))){
var inst_11812 = (state_11829[(8)]);
var inst_11816 = (state_11829[(9)]);
var inst_11809 = (state_11829[(7)]);
var inst_11816__$1 = f.call(null,inst_11809,inst_11812);
var inst_11817 = cljs.core.reduced_QMARK_.call(null,inst_11816__$1);
var state_11829__$1 = (function (){var statearr_11837 = state_11829;
(statearr_11837[(9)] = inst_11816__$1);

return statearr_11837;
})();
if(inst_11817){
var statearr_11838_11856 = state_11829__$1;
(statearr_11838_11856[(1)] = (8));

} else {
var statearr_11839_11857 = state_11829__$1;
(statearr_11839_11857[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11830 === (3))){
var inst_11827 = (state_11829[(2)]);
var state_11829__$1 = state_11829;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11829__$1,inst_11827);
} else {
if((state_val_11830 === (2))){
var state_11829__$1 = state_11829;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11829__$1,(4),ch);
} else {
if((state_val_11830 === (9))){
var inst_11816 = (state_11829[(9)]);
var inst_11809 = inst_11816;
var state_11829__$1 = (function (){var statearr_11840 = state_11829;
(statearr_11840[(7)] = inst_11809);

return statearr_11840;
})();
var statearr_11841_11858 = state_11829__$1;
(statearr_11841_11858[(2)] = null);

(statearr_11841_11858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11830 === (5))){
var inst_11809 = (state_11829[(7)]);
var state_11829__$1 = state_11829;
var statearr_11842_11859 = state_11829__$1;
(statearr_11842_11859[(2)] = inst_11809);

(statearr_11842_11859[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11830 === (10))){
var inst_11823 = (state_11829[(2)]);
var state_11829__$1 = state_11829;
var statearr_11843_11860 = state_11829__$1;
(statearr_11843_11860[(2)] = inst_11823);

(statearr_11843_11860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11830 === (8))){
var inst_11816 = (state_11829[(9)]);
var inst_11819 = cljs.core.deref.call(null,inst_11816);
var state_11829__$1 = state_11829;
var statearr_11844_11861 = state_11829__$1;
(statearr_11844_11861[(2)] = inst_11819);

(statearr_11844_11861[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto__))
;
return ((function (switch__10959__auto__,c__11071__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10960__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10960__auto____0 = (function (){
var statearr_11848 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11848[(0)] = cljs$core$async$reduce_$_state_machine__10960__auto__);

(statearr_11848[(1)] = (1));

return statearr_11848;
});
var cljs$core$async$reduce_$_state_machine__10960__auto____1 = (function (state_11829){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11829);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11849){if((e11849 instanceof Object)){
var ex__10963__auto__ = e11849;
var statearr_11850_11862 = state_11829;
(statearr_11850_11862[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11829);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11849;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11863 = state_11829;
state_11829 = G__11863;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10960__auto__ = function(state_11829){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10960__auto____1.call(this,state_11829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10960__auto____0;
cljs$core$async$reduce_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10960__auto____1;
return cljs$core$async$reduce_$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto__))
})();
var state__11073__auto__ = (function (){var statearr_11851 = f__11072__auto__.call(null);
(statearr_11851[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto__);

return statearr_11851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto__))
);

return c__11071__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11864 = [];
var len__5726__auto___11916 = arguments.length;
var i__5727__auto___11917 = (0);
while(true){
if((i__5727__auto___11917 < len__5726__auto___11916)){
args11864.push((arguments[i__5727__auto___11917]));

var G__11918 = (i__5727__auto___11917 + (1));
i__5727__auto___11917 = G__11918;
continue;
} else {
}
break;
}

var G__11866 = args11864.length;
switch (G__11866) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11864.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11071__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto__){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto__){
return (function (state_11891){
var state_val_11892 = (state_11891[(1)]);
if((state_val_11892 === (7))){
var inst_11873 = (state_11891[(2)]);
var state_11891__$1 = state_11891;
var statearr_11893_11920 = state_11891__$1;
(statearr_11893_11920[(2)] = inst_11873);

(statearr_11893_11920[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (1))){
var inst_11867 = cljs.core.seq.call(null,coll);
var inst_11868 = inst_11867;
var state_11891__$1 = (function (){var statearr_11894 = state_11891;
(statearr_11894[(7)] = inst_11868);

return statearr_11894;
})();
var statearr_11895_11921 = state_11891__$1;
(statearr_11895_11921[(2)] = null);

(statearr_11895_11921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (4))){
var inst_11868 = (state_11891[(7)]);
var inst_11871 = cljs.core.first.call(null,inst_11868);
var state_11891__$1 = state_11891;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11891__$1,(7),ch,inst_11871);
} else {
if((state_val_11892 === (13))){
var inst_11885 = (state_11891[(2)]);
var state_11891__$1 = state_11891;
var statearr_11896_11922 = state_11891__$1;
(statearr_11896_11922[(2)] = inst_11885);

(statearr_11896_11922[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (6))){
var inst_11876 = (state_11891[(2)]);
var state_11891__$1 = state_11891;
if(cljs.core.truth_(inst_11876)){
var statearr_11897_11923 = state_11891__$1;
(statearr_11897_11923[(1)] = (8));

} else {
var statearr_11898_11924 = state_11891__$1;
(statearr_11898_11924[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (3))){
var inst_11889 = (state_11891[(2)]);
var state_11891__$1 = state_11891;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11891__$1,inst_11889);
} else {
if((state_val_11892 === (12))){
var state_11891__$1 = state_11891;
var statearr_11899_11925 = state_11891__$1;
(statearr_11899_11925[(2)] = null);

(statearr_11899_11925[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (2))){
var inst_11868 = (state_11891[(7)]);
var state_11891__$1 = state_11891;
if(cljs.core.truth_(inst_11868)){
var statearr_11900_11926 = state_11891__$1;
(statearr_11900_11926[(1)] = (4));

} else {
var statearr_11901_11927 = state_11891__$1;
(statearr_11901_11927[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (11))){
var inst_11882 = cljs.core.async.close_BANG_.call(null,ch);
var state_11891__$1 = state_11891;
var statearr_11902_11928 = state_11891__$1;
(statearr_11902_11928[(2)] = inst_11882);

(statearr_11902_11928[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (9))){
var state_11891__$1 = state_11891;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11903_11929 = state_11891__$1;
(statearr_11903_11929[(1)] = (11));

} else {
var statearr_11904_11930 = state_11891__$1;
(statearr_11904_11930[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (5))){
var inst_11868 = (state_11891[(7)]);
var state_11891__$1 = state_11891;
var statearr_11905_11931 = state_11891__$1;
(statearr_11905_11931[(2)] = inst_11868);

(statearr_11905_11931[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (10))){
var inst_11887 = (state_11891[(2)]);
var state_11891__$1 = state_11891;
var statearr_11906_11932 = state_11891__$1;
(statearr_11906_11932[(2)] = inst_11887);

(statearr_11906_11932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11892 === (8))){
var inst_11868 = (state_11891[(7)]);
var inst_11878 = cljs.core.next.call(null,inst_11868);
var inst_11868__$1 = inst_11878;
var state_11891__$1 = (function (){var statearr_11907 = state_11891;
(statearr_11907[(7)] = inst_11868__$1);

return statearr_11907;
})();
var statearr_11908_11933 = state_11891__$1;
(statearr_11908_11933[(2)] = null);

(statearr_11908_11933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto__))
;
return ((function (switch__10959__auto__,c__11071__auto__){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_11912 = [null,null,null,null,null,null,null,null];
(statearr_11912[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_11912[(1)] = (1));

return statearr_11912;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_11891){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_11891);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e11913){if((e11913 instanceof Object)){
var ex__10963__auto__ = e11913;
var statearr_11914_11934 = state_11891;
(statearr_11914_11934[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11891);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11913;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11935 = state_11891;
state_11891 = G__11935;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_11891){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_11891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto__))
})();
var state__11073__auto__ = (function (){var statearr_11915 = f__11072__auto__.call(null);
(statearr_11915[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto__);

return statearr_11915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto__))
);

return c__11071__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12157 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12157 = (function (mult,ch,cs,meta12158){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12158 = meta12158;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12157.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12159,meta12158__$1){
var self__ = this;
var _12159__$1 = this;
return (new cljs.core.async.t_cljs$core$async12157(self__.mult,self__.ch,self__.cs,meta12158__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12157.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12159){
var self__ = this;
var _12159__$1 = this;
return self__.meta12158;
});})(cs))
;

cljs.core.async.t_cljs$core$async12157.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12157.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12157.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12157.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12157.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12157.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12157.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12158","meta12158",529303869,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12157.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12157.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12157";

cljs.core.async.t_cljs$core$async12157.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12157");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12157 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12157(mult__$1,ch__$1,cs__$1,meta12158){
return (new cljs.core.async.t_cljs$core$async12157(mult__$1,ch__$1,cs__$1,meta12158));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12157(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11071__auto___12378 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___12378,cs,m,dchan,dctr,done){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___12378,cs,m,dchan,dctr,done){
return (function (state_12290){
var state_val_12291 = (state_12290[(1)]);
if((state_val_12291 === (7))){
var inst_12286 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12292_12379 = state_12290__$1;
(statearr_12292_12379[(2)] = inst_12286);

(statearr_12292_12379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (20))){
var inst_12191 = (state_12290[(7)]);
var inst_12201 = cljs.core.first.call(null,inst_12191);
var inst_12202 = cljs.core.nth.call(null,inst_12201,(0),null);
var inst_12203 = cljs.core.nth.call(null,inst_12201,(1),null);
var state_12290__$1 = (function (){var statearr_12293 = state_12290;
(statearr_12293[(8)] = inst_12202);

return statearr_12293;
})();
if(cljs.core.truth_(inst_12203)){
var statearr_12294_12380 = state_12290__$1;
(statearr_12294_12380[(1)] = (22));

} else {
var statearr_12295_12381 = state_12290__$1;
(statearr_12295_12381[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (27))){
var inst_12233 = (state_12290[(9)]);
var inst_12238 = (state_12290[(10)]);
var inst_12231 = (state_12290[(11)]);
var inst_12162 = (state_12290[(12)]);
var inst_12238__$1 = cljs.core._nth.call(null,inst_12231,inst_12233);
var inst_12239 = cljs.core.async.put_BANG_.call(null,inst_12238__$1,inst_12162,done);
var state_12290__$1 = (function (){var statearr_12296 = state_12290;
(statearr_12296[(10)] = inst_12238__$1);

return statearr_12296;
})();
if(cljs.core.truth_(inst_12239)){
var statearr_12297_12382 = state_12290__$1;
(statearr_12297_12382[(1)] = (30));

} else {
var statearr_12298_12383 = state_12290__$1;
(statearr_12298_12383[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (1))){
var state_12290__$1 = state_12290;
var statearr_12299_12384 = state_12290__$1;
(statearr_12299_12384[(2)] = null);

(statearr_12299_12384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (24))){
var inst_12191 = (state_12290[(7)]);
var inst_12208 = (state_12290[(2)]);
var inst_12209 = cljs.core.next.call(null,inst_12191);
var inst_12171 = inst_12209;
var inst_12172 = null;
var inst_12173 = (0);
var inst_12174 = (0);
var state_12290__$1 = (function (){var statearr_12300 = state_12290;
(statearr_12300[(13)] = inst_12173);

(statearr_12300[(14)] = inst_12208);

(statearr_12300[(15)] = inst_12174);

(statearr_12300[(16)] = inst_12172);

(statearr_12300[(17)] = inst_12171);

return statearr_12300;
})();
var statearr_12301_12385 = state_12290__$1;
(statearr_12301_12385[(2)] = null);

(statearr_12301_12385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (39))){
var state_12290__$1 = state_12290;
var statearr_12305_12386 = state_12290__$1;
(statearr_12305_12386[(2)] = null);

(statearr_12305_12386[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (4))){
var inst_12162 = (state_12290[(12)]);
var inst_12162__$1 = (state_12290[(2)]);
var inst_12163 = (inst_12162__$1 == null);
var state_12290__$1 = (function (){var statearr_12306 = state_12290;
(statearr_12306[(12)] = inst_12162__$1);

return statearr_12306;
})();
if(cljs.core.truth_(inst_12163)){
var statearr_12307_12387 = state_12290__$1;
(statearr_12307_12387[(1)] = (5));

} else {
var statearr_12308_12388 = state_12290__$1;
(statearr_12308_12388[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (15))){
var inst_12173 = (state_12290[(13)]);
var inst_12174 = (state_12290[(15)]);
var inst_12172 = (state_12290[(16)]);
var inst_12171 = (state_12290[(17)]);
var inst_12187 = (state_12290[(2)]);
var inst_12188 = (inst_12174 + (1));
var tmp12302 = inst_12173;
var tmp12303 = inst_12172;
var tmp12304 = inst_12171;
var inst_12171__$1 = tmp12304;
var inst_12172__$1 = tmp12303;
var inst_12173__$1 = tmp12302;
var inst_12174__$1 = inst_12188;
var state_12290__$1 = (function (){var statearr_12309 = state_12290;
(statearr_12309[(13)] = inst_12173__$1);

(statearr_12309[(18)] = inst_12187);

(statearr_12309[(15)] = inst_12174__$1);

(statearr_12309[(16)] = inst_12172__$1);

(statearr_12309[(17)] = inst_12171__$1);

return statearr_12309;
})();
var statearr_12310_12389 = state_12290__$1;
(statearr_12310_12389[(2)] = null);

(statearr_12310_12389[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (21))){
var inst_12212 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12314_12390 = state_12290__$1;
(statearr_12314_12390[(2)] = inst_12212);

(statearr_12314_12390[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (31))){
var inst_12238 = (state_12290[(10)]);
var inst_12242 = done.call(null,null);
var inst_12243 = cljs.core.async.untap_STAR_.call(null,m,inst_12238);
var state_12290__$1 = (function (){var statearr_12315 = state_12290;
(statearr_12315[(19)] = inst_12242);

return statearr_12315;
})();
var statearr_12316_12391 = state_12290__$1;
(statearr_12316_12391[(2)] = inst_12243);

(statearr_12316_12391[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (32))){
var inst_12233 = (state_12290[(9)]);
var inst_12232 = (state_12290[(20)]);
var inst_12230 = (state_12290[(21)]);
var inst_12231 = (state_12290[(11)]);
var inst_12245 = (state_12290[(2)]);
var inst_12246 = (inst_12233 + (1));
var tmp12311 = inst_12232;
var tmp12312 = inst_12230;
var tmp12313 = inst_12231;
var inst_12230__$1 = tmp12312;
var inst_12231__$1 = tmp12313;
var inst_12232__$1 = tmp12311;
var inst_12233__$1 = inst_12246;
var state_12290__$1 = (function (){var statearr_12317 = state_12290;
(statearr_12317[(9)] = inst_12233__$1);

(statearr_12317[(22)] = inst_12245);

(statearr_12317[(20)] = inst_12232__$1);

(statearr_12317[(21)] = inst_12230__$1);

(statearr_12317[(11)] = inst_12231__$1);

return statearr_12317;
})();
var statearr_12318_12392 = state_12290__$1;
(statearr_12318_12392[(2)] = null);

(statearr_12318_12392[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (40))){
var inst_12258 = (state_12290[(23)]);
var inst_12262 = done.call(null,null);
var inst_12263 = cljs.core.async.untap_STAR_.call(null,m,inst_12258);
var state_12290__$1 = (function (){var statearr_12319 = state_12290;
(statearr_12319[(24)] = inst_12262);

return statearr_12319;
})();
var statearr_12320_12393 = state_12290__$1;
(statearr_12320_12393[(2)] = inst_12263);

(statearr_12320_12393[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (33))){
var inst_12249 = (state_12290[(25)]);
var inst_12251 = cljs.core.chunked_seq_QMARK_.call(null,inst_12249);
var state_12290__$1 = state_12290;
if(inst_12251){
var statearr_12321_12394 = state_12290__$1;
(statearr_12321_12394[(1)] = (36));

} else {
var statearr_12322_12395 = state_12290__$1;
(statearr_12322_12395[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (13))){
var inst_12181 = (state_12290[(26)]);
var inst_12184 = cljs.core.async.close_BANG_.call(null,inst_12181);
var state_12290__$1 = state_12290;
var statearr_12323_12396 = state_12290__$1;
(statearr_12323_12396[(2)] = inst_12184);

(statearr_12323_12396[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (22))){
var inst_12202 = (state_12290[(8)]);
var inst_12205 = cljs.core.async.close_BANG_.call(null,inst_12202);
var state_12290__$1 = state_12290;
var statearr_12324_12397 = state_12290__$1;
(statearr_12324_12397[(2)] = inst_12205);

(statearr_12324_12397[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (36))){
var inst_12249 = (state_12290[(25)]);
var inst_12253 = cljs.core.chunk_first.call(null,inst_12249);
var inst_12254 = cljs.core.chunk_rest.call(null,inst_12249);
var inst_12255 = cljs.core.count.call(null,inst_12253);
var inst_12230 = inst_12254;
var inst_12231 = inst_12253;
var inst_12232 = inst_12255;
var inst_12233 = (0);
var state_12290__$1 = (function (){var statearr_12325 = state_12290;
(statearr_12325[(9)] = inst_12233);

(statearr_12325[(20)] = inst_12232);

(statearr_12325[(21)] = inst_12230);

(statearr_12325[(11)] = inst_12231);

return statearr_12325;
})();
var statearr_12326_12398 = state_12290__$1;
(statearr_12326_12398[(2)] = null);

(statearr_12326_12398[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (41))){
var inst_12249 = (state_12290[(25)]);
var inst_12265 = (state_12290[(2)]);
var inst_12266 = cljs.core.next.call(null,inst_12249);
var inst_12230 = inst_12266;
var inst_12231 = null;
var inst_12232 = (0);
var inst_12233 = (0);
var state_12290__$1 = (function (){var statearr_12327 = state_12290;
(statearr_12327[(9)] = inst_12233);

(statearr_12327[(27)] = inst_12265);

(statearr_12327[(20)] = inst_12232);

(statearr_12327[(21)] = inst_12230);

(statearr_12327[(11)] = inst_12231);

return statearr_12327;
})();
var statearr_12328_12399 = state_12290__$1;
(statearr_12328_12399[(2)] = null);

(statearr_12328_12399[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (43))){
var state_12290__$1 = state_12290;
var statearr_12329_12400 = state_12290__$1;
(statearr_12329_12400[(2)] = null);

(statearr_12329_12400[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (29))){
var inst_12274 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12330_12401 = state_12290__$1;
(statearr_12330_12401[(2)] = inst_12274);

(statearr_12330_12401[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (44))){
var inst_12283 = (state_12290[(2)]);
var state_12290__$1 = (function (){var statearr_12331 = state_12290;
(statearr_12331[(28)] = inst_12283);

return statearr_12331;
})();
var statearr_12332_12402 = state_12290__$1;
(statearr_12332_12402[(2)] = null);

(statearr_12332_12402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (6))){
var inst_12222 = (state_12290[(29)]);
var inst_12221 = cljs.core.deref.call(null,cs);
var inst_12222__$1 = cljs.core.keys.call(null,inst_12221);
var inst_12223 = cljs.core.count.call(null,inst_12222__$1);
var inst_12224 = cljs.core.reset_BANG_.call(null,dctr,inst_12223);
var inst_12229 = cljs.core.seq.call(null,inst_12222__$1);
var inst_12230 = inst_12229;
var inst_12231 = null;
var inst_12232 = (0);
var inst_12233 = (0);
var state_12290__$1 = (function (){var statearr_12333 = state_12290;
(statearr_12333[(29)] = inst_12222__$1);

(statearr_12333[(9)] = inst_12233);

(statearr_12333[(30)] = inst_12224);

(statearr_12333[(20)] = inst_12232);

(statearr_12333[(21)] = inst_12230);

(statearr_12333[(11)] = inst_12231);

return statearr_12333;
})();
var statearr_12334_12403 = state_12290__$1;
(statearr_12334_12403[(2)] = null);

(statearr_12334_12403[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (28))){
var inst_12249 = (state_12290[(25)]);
var inst_12230 = (state_12290[(21)]);
var inst_12249__$1 = cljs.core.seq.call(null,inst_12230);
var state_12290__$1 = (function (){var statearr_12335 = state_12290;
(statearr_12335[(25)] = inst_12249__$1);

return statearr_12335;
})();
if(inst_12249__$1){
var statearr_12336_12404 = state_12290__$1;
(statearr_12336_12404[(1)] = (33));

} else {
var statearr_12337_12405 = state_12290__$1;
(statearr_12337_12405[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (25))){
var inst_12233 = (state_12290[(9)]);
var inst_12232 = (state_12290[(20)]);
var inst_12235 = (inst_12233 < inst_12232);
var inst_12236 = inst_12235;
var state_12290__$1 = state_12290;
if(cljs.core.truth_(inst_12236)){
var statearr_12338_12406 = state_12290__$1;
(statearr_12338_12406[(1)] = (27));

} else {
var statearr_12339_12407 = state_12290__$1;
(statearr_12339_12407[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (34))){
var state_12290__$1 = state_12290;
var statearr_12340_12408 = state_12290__$1;
(statearr_12340_12408[(2)] = null);

(statearr_12340_12408[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (17))){
var state_12290__$1 = state_12290;
var statearr_12341_12409 = state_12290__$1;
(statearr_12341_12409[(2)] = null);

(statearr_12341_12409[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (3))){
var inst_12288 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12290__$1,inst_12288);
} else {
if((state_val_12291 === (12))){
var inst_12217 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12342_12410 = state_12290__$1;
(statearr_12342_12410[(2)] = inst_12217);

(statearr_12342_12410[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (2))){
var state_12290__$1 = state_12290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12290__$1,(4),ch);
} else {
if((state_val_12291 === (23))){
var state_12290__$1 = state_12290;
var statearr_12343_12411 = state_12290__$1;
(statearr_12343_12411[(2)] = null);

(statearr_12343_12411[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (35))){
var inst_12272 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12344_12412 = state_12290__$1;
(statearr_12344_12412[(2)] = inst_12272);

(statearr_12344_12412[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (19))){
var inst_12191 = (state_12290[(7)]);
var inst_12195 = cljs.core.chunk_first.call(null,inst_12191);
var inst_12196 = cljs.core.chunk_rest.call(null,inst_12191);
var inst_12197 = cljs.core.count.call(null,inst_12195);
var inst_12171 = inst_12196;
var inst_12172 = inst_12195;
var inst_12173 = inst_12197;
var inst_12174 = (0);
var state_12290__$1 = (function (){var statearr_12345 = state_12290;
(statearr_12345[(13)] = inst_12173);

(statearr_12345[(15)] = inst_12174);

(statearr_12345[(16)] = inst_12172);

(statearr_12345[(17)] = inst_12171);

return statearr_12345;
})();
var statearr_12346_12413 = state_12290__$1;
(statearr_12346_12413[(2)] = null);

(statearr_12346_12413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (11))){
var inst_12191 = (state_12290[(7)]);
var inst_12171 = (state_12290[(17)]);
var inst_12191__$1 = cljs.core.seq.call(null,inst_12171);
var state_12290__$1 = (function (){var statearr_12347 = state_12290;
(statearr_12347[(7)] = inst_12191__$1);

return statearr_12347;
})();
if(inst_12191__$1){
var statearr_12348_12414 = state_12290__$1;
(statearr_12348_12414[(1)] = (16));

} else {
var statearr_12349_12415 = state_12290__$1;
(statearr_12349_12415[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (9))){
var inst_12219 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12350_12416 = state_12290__$1;
(statearr_12350_12416[(2)] = inst_12219);

(statearr_12350_12416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (5))){
var inst_12169 = cljs.core.deref.call(null,cs);
var inst_12170 = cljs.core.seq.call(null,inst_12169);
var inst_12171 = inst_12170;
var inst_12172 = null;
var inst_12173 = (0);
var inst_12174 = (0);
var state_12290__$1 = (function (){var statearr_12351 = state_12290;
(statearr_12351[(13)] = inst_12173);

(statearr_12351[(15)] = inst_12174);

(statearr_12351[(16)] = inst_12172);

(statearr_12351[(17)] = inst_12171);

return statearr_12351;
})();
var statearr_12352_12417 = state_12290__$1;
(statearr_12352_12417[(2)] = null);

(statearr_12352_12417[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (14))){
var state_12290__$1 = state_12290;
var statearr_12353_12418 = state_12290__$1;
(statearr_12353_12418[(2)] = null);

(statearr_12353_12418[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (45))){
var inst_12280 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12354_12419 = state_12290__$1;
(statearr_12354_12419[(2)] = inst_12280);

(statearr_12354_12419[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (26))){
var inst_12222 = (state_12290[(29)]);
var inst_12276 = (state_12290[(2)]);
var inst_12277 = cljs.core.seq.call(null,inst_12222);
var state_12290__$1 = (function (){var statearr_12355 = state_12290;
(statearr_12355[(31)] = inst_12276);

return statearr_12355;
})();
if(inst_12277){
var statearr_12356_12420 = state_12290__$1;
(statearr_12356_12420[(1)] = (42));

} else {
var statearr_12357_12421 = state_12290__$1;
(statearr_12357_12421[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (16))){
var inst_12191 = (state_12290[(7)]);
var inst_12193 = cljs.core.chunked_seq_QMARK_.call(null,inst_12191);
var state_12290__$1 = state_12290;
if(inst_12193){
var statearr_12358_12422 = state_12290__$1;
(statearr_12358_12422[(1)] = (19));

} else {
var statearr_12359_12423 = state_12290__$1;
(statearr_12359_12423[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (38))){
var inst_12269 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12360_12424 = state_12290__$1;
(statearr_12360_12424[(2)] = inst_12269);

(statearr_12360_12424[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (30))){
var state_12290__$1 = state_12290;
var statearr_12361_12425 = state_12290__$1;
(statearr_12361_12425[(2)] = null);

(statearr_12361_12425[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (10))){
var inst_12174 = (state_12290[(15)]);
var inst_12172 = (state_12290[(16)]);
var inst_12180 = cljs.core._nth.call(null,inst_12172,inst_12174);
var inst_12181 = cljs.core.nth.call(null,inst_12180,(0),null);
var inst_12182 = cljs.core.nth.call(null,inst_12180,(1),null);
var state_12290__$1 = (function (){var statearr_12362 = state_12290;
(statearr_12362[(26)] = inst_12181);

return statearr_12362;
})();
if(cljs.core.truth_(inst_12182)){
var statearr_12363_12426 = state_12290__$1;
(statearr_12363_12426[(1)] = (13));

} else {
var statearr_12364_12427 = state_12290__$1;
(statearr_12364_12427[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (18))){
var inst_12215 = (state_12290[(2)]);
var state_12290__$1 = state_12290;
var statearr_12365_12428 = state_12290__$1;
(statearr_12365_12428[(2)] = inst_12215);

(statearr_12365_12428[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (42))){
var state_12290__$1 = state_12290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12290__$1,(45),dchan);
} else {
if((state_val_12291 === (37))){
var inst_12249 = (state_12290[(25)]);
var inst_12258 = (state_12290[(23)]);
var inst_12162 = (state_12290[(12)]);
var inst_12258__$1 = cljs.core.first.call(null,inst_12249);
var inst_12259 = cljs.core.async.put_BANG_.call(null,inst_12258__$1,inst_12162,done);
var state_12290__$1 = (function (){var statearr_12366 = state_12290;
(statearr_12366[(23)] = inst_12258__$1);

return statearr_12366;
})();
if(cljs.core.truth_(inst_12259)){
var statearr_12367_12429 = state_12290__$1;
(statearr_12367_12429[(1)] = (39));

} else {
var statearr_12368_12430 = state_12290__$1;
(statearr_12368_12430[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12291 === (8))){
var inst_12173 = (state_12290[(13)]);
var inst_12174 = (state_12290[(15)]);
var inst_12176 = (inst_12174 < inst_12173);
var inst_12177 = inst_12176;
var state_12290__$1 = state_12290;
if(cljs.core.truth_(inst_12177)){
var statearr_12369_12431 = state_12290__$1;
(statearr_12369_12431[(1)] = (10));

} else {
var statearr_12370_12432 = state_12290__$1;
(statearr_12370_12432[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___12378,cs,m,dchan,dctr,done))
;
return ((function (switch__10959__auto__,c__11071__auto___12378,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10960__auto__ = null;
var cljs$core$async$mult_$_state_machine__10960__auto____0 = (function (){
var statearr_12374 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12374[(0)] = cljs$core$async$mult_$_state_machine__10960__auto__);

(statearr_12374[(1)] = (1));

return statearr_12374;
});
var cljs$core$async$mult_$_state_machine__10960__auto____1 = (function (state_12290){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_12290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e12375){if((e12375 instanceof Object)){
var ex__10963__auto__ = e12375;
var statearr_12376_12433 = state_12290;
(statearr_12376_12433[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12290);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12375;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12434 = state_12290;
state_12290 = G__12434;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10960__auto__ = function(state_12290){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10960__auto____1.call(this,state_12290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10960__auto____0;
cljs$core$async$mult_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10960__auto____1;
return cljs$core$async$mult_$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___12378,cs,m,dchan,dctr,done))
})();
var state__11073__auto__ = (function (){var statearr_12377 = f__11072__auto__.call(null);
(statearr_12377[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___12378);

return statearr_12377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___12378,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args12435 = [];
var len__5726__auto___12438 = arguments.length;
var i__5727__auto___12439 = (0);
while(true){
if((i__5727__auto___12439 < len__5726__auto___12438)){
args12435.push((arguments[i__5727__auto___12439]));

var G__12440 = (i__5727__auto___12439 + (1));
i__5727__auto___12439 = G__12440;
continue;
} else {
}
break;
}

var G__12437 = args12435.length;
switch (G__12437) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12435.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___12452 = arguments.length;
var i__5727__auto___12453 = (0);
while(true){
if((i__5727__auto___12453 < len__5726__auto___12452)){
args__5733__auto__.push((arguments[i__5727__auto___12453]));

var G__12454 = (i__5727__auto___12453 + (1));
i__5727__auto___12453 = G__12454;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12446){
var map__12447 = p__12446;
var map__12447__$1 = ((((!((map__12447 == null)))?((((map__12447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12447):map__12447);
var opts = map__12447__$1;
var statearr_12449_12455 = state;
(statearr_12449_12455[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__12447,map__12447__$1,opts){
return (function (val){
var statearr_12450_12456 = state;
(statearr_12450_12456[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12447,map__12447__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_12451_12457 = state;
(statearr_12451_12457[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12442){
var G__12443 = cljs.core.first.call(null,seq12442);
var seq12442__$1 = cljs.core.next.call(null,seq12442);
var G__12444 = cljs.core.first.call(null,seq12442__$1);
var seq12442__$2 = cljs.core.next.call(null,seq12442__$1);
var G__12445 = cljs.core.first.call(null,seq12442__$2);
var seq12442__$3 = cljs.core.next.call(null,seq12442__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12443,G__12444,G__12445,seq12442__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12621 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12621 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12622){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12622 = meta12622;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12623,meta12622__$1){
var self__ = this;
var _12623__$1 = this;
return (new cljs.core.async.t_cljs$core$async12621(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12622__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12623){
var self__ = this;
var _12623__$1 = this;
return self__.meta12622;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12622","meta12622",126766427,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12621.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12621.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12621";

cljs.core.async.t_cljs$core$async12621.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12621");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12621 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12621(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12622){
return (new cljs.core.async.t_cljs$core$async12621(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12622));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12621(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11071__auto___12784 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___12784,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___12784,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12721){
var state_val_12722 = (state_12721[(1)]);
if((state_val_12722 === (7))){
var inst_12639 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
var statearr_12723_12785 = state_12721__$1;
(statearr_12723_12785[(2)] = inst_12639);

(statearr_12723_12785[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (20))){
var inst_12651 = (state_12721[(7)]);
var state_12721__$1 = state_12721;
var statearr_12724_12786 = state_12721__$1;
(statearr_12724_12786[(2)] = inst_12651);

(statearr_12724_12786[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (27))){
var state_12721__$1 = state_12721;
var statearr_12725_12787 = state_12721__$1;
(statearr_12725_12787[(2)] = null);

(statearr_12725_12787[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (1))){
var inst_12627 = (state_12721[(8)]);
var inst_12627__$1 = calc_state.call(null);
var inst_12629 = (inst_12627__$1 == null);
var inst_12630 = cljs.core.not.call(null,inst_12629);
var state_12721__$1 = (function (){var statearr_12726 = state_12721;
(statearr_12726[(8)] = inst_12627__$1);

return statearr_12726;
})();
if(inst_12630){
var statearr_12727_12788 = state_12721__$1;
(statearr_12727_12788[(1)] = (2));

} else {
var statearr_12728_12789 = state_12721__$1;
(statearr_12728_12789[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (24))){
var inst_12695 = (state_12721[(9)]);
var inst_12674 = (state_12721[(10)]);
var inst_12681 = (state_12721[(11)]);
var inst_12695__$1 = inst_12674.call(null,inst_12681);
var state_12721__$1 = (function (){var statearr_12729 = state_12721;
(statearr_12729[(9)] = inst_12695__$1);

return statearr_12729;
})();
if(cljs.core.truth_(inst_12695__$1)){
var statearr_12730_12790 = state_12721__$1;
(statearr_12730_12790[(1)] = (29));

} else {
var statearr_12731_12791 = state_12721__$1;
(statearr_12731_12791[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (4))){
var inst_12642 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
if(cljs.core.truth_(inst_12642)){
var statearr_12732_12792 = state_12721__$1;
(statearr_12732_12792[(1)] = (8));

} else {
var statearr_12733_12793 = state_12721__$1;
(statearr_12733_12793[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (15))){
var inst_12668 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
if(cljs.core.truth_(inst_12668)){
var statearr_12734_12794 = state_12721__$1;
(statearr_12734_12794[(1)] = (19));

} else {
var statearr_12735_12795 = state_12721__$1;
(statearr_12735_12795[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (21))){
var inst_12673 = (state_12721[(12)]);
var inst_12673__$1 = (state_12721[(2)]);
var inst_12674 = cljs.core.get.call(null,inst_12673__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12675 = cljs.core.get.call(null,inst_12673__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12676 = cljs.core.get.call(null,inst_12673__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12721__$1 = (function (){var statearr_12736 = state_12721;
(statearr_12736[(12)] = inst_12673__$1);

(statearr_12736[(10)] = inst_12674);

(statearr_12736[(13)] = inst_12675);

return statearr_12736;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12721__$1,(22),inst_12676);
} else {
if((state_val_12722 === (31))){
var inst_12703 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
if(cljs.core.truth_(inst_12703)){
var statearr_12737_12796 = state_12721__$1;
(statearr_12737_12796[(1)] = (32));

} else {
var statearr_12738_12797 = state_12721__$1;
(statearr_12738_12797[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (32))){
var inst_12680 = (state_12721[(14)]);
var state_12721__$1 = state_12721;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12721__$1,(35),out,inst_12680);
} else {
if((state_val_12722 === (33))){
var inst_12673 = (state_12721[(12)]);
var inst_12651 = inst_12673;
var state_12721__$1 = (function (){var statearr_12739 = state_12721;
(statearr_12739[(7)] = inst_12651);

return statearr_12739;
})();
var statearr_12740_12798 = state_12721__$1;
(statearr_12740_12798[(2)] = null);

(statearr_12740_12798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (13))){
var inst_12651 = (state_12721[(7)]);
var inst_12658 = inst_12651.cljs$lang$protocol_mask$partition0$;
var inst_12659 = (inst_12658 & (64));
var inst_12660 = inst_12651.cljs$core$ISeq$;
var inst_12661 = (inst_12659) || (inst_12660);
var state_12721__$1 = state_12721;
if(cljs.core.truth_(inst_12661)){
var statearr_12741_12799 = state_12721__$1;
(statearr_12741_12799[(1)] = (16));

} else {
var statearr_12742_12800 = state_12721__$1;
(statearr_12742_12800[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (22))){
var inst_12681 = (state_12721[(11)]);
var inst_12680 = (state_12721[(14)]);
var inst_12679 = (state_12721[(2)]);
var inst_12680__$1 = cljs.core.nth.call(null,inst_12679,(0),null);
var inst_12681__$1 = cljs.core.nth.call(null,inst_12679,(1),null);
var inst_12682 = (inst_12680__$1 == null);
var inst_12683 = cljs.core._EQ_.call(null,inst_12681__$1,change);
var inst_12684 = (inst_12682) || (inst_12683);
var state_12721__$1 = (function (){var statearr_12743 = state_12721;
(statearr_12743[(11)] = inst_12681__$1);

(statearr_12743[(14)] = inst_12680__$1);

return statearr_12743;
})();
if(cljs.core.truth_(inst_12684)){
var statearr_12744_12801 = state_12721__$1;
(statearr_12744_12801[(1)] = (23));

} else {
var statearr_12745_12802 = state_12721__$1;
(statearr_12745_12802[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (36))){
var inst_12673 = (state_12721[(12)]);
var inst_12651 = inst_12673;
var state_12721__$1 = (function (){var statearr_12746 = state_12721;
(statearr_12746[(7)] = inst_12651);

return statearr_12746;
})();
var statearr_12747_12803 = state_12721__$1;
(statearr_12747_12803[(2)] = null);

(statearr_12747_12803[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (29))){
var inst_12695 = (state_12721[(9)]);
var state_12721__$1 = state_12721;
var statearr_12748_12804 = state_12721__$1;
(statearr_12748_12804[(2)] = inst_12695);

(statearr_12748_12804[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (6))){
var state_12721__$1 = state_12721;
var statearr_12749_12805 = state_12721__$1;
(statearr_12749_12805[(2)] = false);

(statearr_12749_12805[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (28))){
var inst_12691 = (state_12721[(2)]);
var inst_12692 = calc_state.call(null);
var inst_12651 = inst_12692;
var state_12721__$1 = (function (){var statearr_12750 = state_12721;
(statearr_12750[(7)] = inst_12651);

(statearr_12750[(15)] = inst_12691);

return statearr_12750;
})();
var statearr_12751_12806 = state_12721__$1;
(statearr_12751_12806[(2)] = null);

(statearr_12751_12806[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (25))){
var inst_12717 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
var statearr_12752_12807 = state_12721__$1;
(statearr_12752_12807[(2)] = inst_12717);

(statearr_12752_12807[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (34))){
var inst_12715 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
var statearr_12753_12808 = state_12721__$1;
(statearr_12753_12808[(2)] = inst_12715);

(statearr_12753_12808[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (17))){
var state_12721__$1 = state_12721;
var statearr_12754_12809 = state_12721__$1;
(statearr_12754_12809[(2)] = false);

(statearr_12754_12809[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (3))){
var state_12721__$1 = state_12721;
var statearr_12755_12810 = state_12721__$1;
(statearr_12755_12810[(2)] = false);

(statearr_12755_12810[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (12))){
var inst_12719 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12721__$1,inst_12719);
} else {
if((state_val_12722 === (2))){
var inst_12627 = (state_12721[(8)]);
var inst_12632 = inst_12627.cljs$lang$protocol_mask$partition0$;
var inst_12633 = (inst_12632 & (64));
var inst_12634 = inst_12627.cljs$core$ISeq$;
var inst_12635 = (inst_12633) || (inst_12634);
var state_12721__$1 = state_12721;
if(cljs.core.truth_(inst_12635)){
var statearr_12756_12811 = state_12721__$1;
(statearr_12756_12811[(1)] = (5));

} else {
var statearr_12757_12812 = state_12721__$1;
(statearr_12757_12812[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (23))){
var inst_12680 = (state_12721[(14)]);
var inst_12686 = (inst_12680 == null);
var state_12721__$1 = state_12721;
if(cljs.core.truth_(inst_12686)){
var statearr_12758_12813 = state_12721__$1;
(statearr_12758_12813[(1)] = (26));

} else {
var statearr_12759_12814 = state_12721__$1;
(statearr_12759_12814[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (35))){
var inst_12706 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
if(cljs.core.truth_(inst_12706)){
var statearr_12760_12815 = state_12721__$1;
(statearr_12760_12815[(1)] = (36));

} else {
var statearr_12761_12816 = state_12721__$1;
(statearr_12761_12816[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (19))){
var inst_12651 = (state_12721[(7)]);
var inst_12670 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12651);
var state_12721__$1 = state_12721;
var statearr_12762_12817 = state_12721__$1;
(statearr_12762_12817[(2)] = inst_12670);

(statearr_12762_12817[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (11))){
var inst_12651 = (state_12721[(7)]);
var inst_12655 = (inst_12651 == null);
var inst_12656 = cljs.core.not.call(null,inst_12655);
var state_12721__$1 = state_12721;
if(inst_12656){
var statearr_12763_12818 = state_12721__$1;
(statearr_12763_12818[(1)] = (13));

} else {
var statearr_12764_12819 = state_12721__$1;
(statearr_12764_12819[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (9))){
var inst_12627 = (state_12721[(8)]);
var state_12721__$1 = state_12721;
var statearr_12765_12820 = state_12721__$1;
(statearr_12765_12820[(2)] = inst_12627);

(statearr_12765_12820[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (5))){
var state_12721__$1 = state_12721;
var statearr_12766_12821 = state_12721__$1;
(statearr_12766_12821[(2)] = true);

(statearr_12766_12821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (14))){
var state_12721__$1 = state_12721;
var statearr_12767_12822 = state_12721__$1;
(statearr_12767_12822[(2)] = false);

(statearr_12767_12822[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (26))){
var inst_12681 = (state_12721[(11)]);
var inst_12688 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12681);
var state_12721__$1 = state_12721;
var statearr_12768_12823 = state_12721__$1;
(statearr_12768_12823[(2)] = inst_12688);

(statearr_12768_12823[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (16))){
var state_12721__$1 = state_12721;
var statearr_12769_12824 = state_12721__$1;
(statearr_12769_12824[(2)] = true);

(statearr_12769_12824[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (38))){
var inst_12711 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
var statearr_12770_12825 = state_12721__$1;
(statearr_12770_12825[(2)] = inst_12711);

(statearr_12770_12825[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (30))){
var inst_12674 = (state_12721[(10)]);
var inst_12681 = (state_12721[(11)]);
var inst_12675 = (state_12721[(13)]);
var inst_12698 = cljs.core.empty_QMARK_.call(null,inst_12674);
var inst_12699 = inst_12675.call(null,inst_12681);
var inst_12700 = cljs.core.not.call(null,inst_12699);
var inst_12701 = (inst_12698) && (inst_12700);
var state_12721__$1 = state_12721;
var statearr_12771_12826 = state_12721__$1;
(statearr_12771_12826[(2)] = inst_12701);

(statearr_12771_12826[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (10))){
var inst_12627 = (state_12721[(8)]);
var inst_12647 = (state_12721[(2)]);
var inst_12648 = cljs.core.get.call(null,inst_12647,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12649 = cljs.core.get.call(null,inst_12647,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12650 = cljs.core.get.call(null,inst_12647,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12651 = inst_12627;
var state_12721__$1 = (function (){var statearr_12772 = state_12721;
(statearr_12772[(16)] = inst_12648);

(statearr_12772[(17)] = inst_12649);

(statearr_12772[(7)] = inst_12651);

(statearr_12772[(18)] = inst_12650);

return statearr_12772;
})();
var statearr_12773_12827 = state_12721__$1;
(statearr_12773_12827[(2)] = null);

(statearr_12773_12827[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (18))){
var inst_12665 = (state_12721[(2)]);
var state_12721__$1 = state_12721;
var statearr_12774_12828 = state_12721__$1;
(statearr_12774_12828[(2)] = inst_12665);

(statearr_12774_12828[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (37))){
var state_12721__$1 = state_12721;
var statearr_12775_12829 = state_12721__$1;
(statearr_12775_12829[(2)] = null);

(statearr_12775_12829[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12722 === (8))){
var inst_12627 = (state_12721[(8)]);
var inst_12644 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12627);
var state_12721__$1 = state_12721;
var statearr_12776_12830 = state_12721__$1;
(statearr_12776_12830[(2)] = inst_12644);

(statearr_12776_12830[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___12784,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10959__auto__,c__11071__auto___12784,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10960__auto__ = null;
var cljs$core$async$mix_$_state_machine__10960__auto____0 = (function (){
var statearr_12780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12780[(0)] = cljs$core$async$mix_$_state_machine__10960__auto__);

(statearr_12780[(1)] = (1));

return statearr_12780;
});
var cljs$core$async$mix_$_state_machine__10960__auto____1 = (function (state_12721){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_12721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e12781){if((e12781 instanceof Object)){
var ex__10963__auto__ = e12781;
var statearr_12782_12831 = state_12721;
(statearr_12782_12831[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12721);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12781;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12832 = state_12721;
state_12721 = G__12832;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10960__auto__ = function(state_12721){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10960__auto____1.call(this,state_12721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10960__auto____0;
cljs$core$async$mix_$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10960__auto____1;
return cljs$core$async$mix_$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___12784,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11073__auto__ = (function (){var statearr_12783 = f__11072__auto__.call(null);
(statearr_12783[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___12784);

return statearr_12783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___12784,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12833 = [];
var len__5726__auto___12836 = arguments.length;
var i__5727__auto___12837 = (0);
while(true){
if((i__5727__auto___12837 < len__5726__auto___12836)){
args12833.push((arguments[i__5727__auto___12837]));

var G__12838 = (i__5727__auto___12837 + (1));
i__5727__auto___12837 = G__12838;
continue;
} else {
}
break;
}

var G__12835 = args12833.length;
switch (G__12835) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12833.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12841 = [];
var len__5726__auto___12966 = arguments.length;
var i__5727__auto___12967 = (0);
while(true){
if((i__5727__auto___12967 < len__5726__auto___12966)){
args12841.push((arguments[i__5727__auto___12967]));

var G__12968 = (i__5727__auto___12967 + (1));
i__5727__auto___12967 = G__12968;
continue;
} else {
}
break;
}

var G__12843 = args12841.length;
switch (G__12843) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12841.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__12840_SHARP_){
if(cljs.core.truth_(p1__12840_SHARP_.call(null,topic))){
return p1__12840_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12840_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12844 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12844 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12845){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12845 = meta12845;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12846,meta12845__$1){
var self__ = this;
var _12846__$1 = this;
return (new cljs.core.async.t_cljs$core$async12844(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12845__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12846){
var self__ = this;
var _12846__$1 = this;
return self__.meta12845;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12844.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12844.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12845","meta12845",389787798,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12844.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12844.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12844";

cljs.core.async.t_cljs$core$async12844.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12844");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12844 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12844(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12845){
return (new cljs.core.async.t_cljs$core$async12844(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12845));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12844(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11071__auto___12970 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___12970,mults,ensure_mult,p){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___12970,mults,ensure_mult,p){
return (function (state_12918){
var state_val_12919 = (state_12918[(1)]);
if((state_val_12919 === (7))){
var inst_12914 = (state_12918[(2)]);
var state_12918__$1 = state_12918;
var statearr_12920_12971 = state_12918__$1;
(statearr_12920_12971[(2)] = inst_12914);

(statearr_12920_12971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (20))){
var state_12918__$1 = state_12918;
var statearr_12921_12972 = state_12918__$1;
(statearr_12921_12972[(2)] = null);

(statearr_12921_12972[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (1))){
var state_12918__$1 = state_12918;
var statearr_12922_12973 = state_12918__$1;
(statearr_12922_12973[(2)] = null);

(statearr_12922_12973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (24))){
var inst_12897 = (state_12918[(7)]);
var inst_12906 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12897);
var state_12918__$1 = state_12918;
var statearr_12923_12974 = state_12918__$1;
(statearr_12923_12974[(2)] = inst_12906);

(statearr_12923_12974[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (4))){
var inst_12849 = (state_12918[(8)]);
var inst_12849__$1 = (state_12918[(2)]);
var inst_12850 = (inst_12849__$1 == null);
var state_12918__$1 = (function (){var statearr_12924 = state_12918;
(statearr_12924[(8)] = inst_12849__$1);

return statearr_12924;
})();
if(cljs.core.truth_(inst_12850)){
var statearr_12925_12975 = state_12918__$1;
(statearr_12925_12975[(1)] = (5));

} else {
var statearr_12926_12976 = state_12918__$1;
(statearr_12926_12976[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (15))){
var inst_12891 = (state_12918[(2)]);
var state_12918__$1 = state_12918;
var statearr_12927_12977 = state_12918__$1;
(statearr_12927_12977[(2)] = inst_12891);

(statearr_12927_12977[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (21))){
var inst_12911 = (state_12918[(2)]);
var state_12918__$1 = (function (){var statearr_12928 = state_12918;
(statearr_12928[(9)] = inst_12911);

return statearr_12928;
})();
var statearr_12929_12978 = state_12918__$1;
(statearr_12929_12978[(2)] = null);

(statearr_12929_12978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (13))){
var inst_12873 = (state_12918[(10)]);
var inst_12875 = cljs.core.chunked_seq_QMARK_.call(null,inst_12873);
var state_12918__$1 = state_12918;
if(inst_12875){
var statearr_12930_12979 = state_12918__$1;
(statearr_12930_12979[(1)] = (16));

} else {
var statearr_12931_12980 = state_12918__$1;
(statearr_12931_12980[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (22))){
var inst_12903 = (state_12918[(2)]);
var state_12918__$1 = state_12918;
if(cljs.core.truth_(inst_12903)){
var statearr_12932_12981 = state_12918__$1;
(statearr_12932_12981[(1)] = (23));

} else {
var statearr_12933_12982 = state_12918__$1;
(statearr_12933_12982[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (6))){
var inst_12897 = (state_12918[(7)]);
var inst_12849 = (state_12918[(8)]);
var inst_12899 = (state_12918[(11)]);
var inst_12897__$1 = topic_fn.call(null,inst_12849);
var inst_12898 = cljs.core.deref.call(null,mults);
var inst_12899__$1 = cljs.core.get.call(null,inst_12898,inst_12897__$1);
var state_12918__$1 = (function (){var statearr_12934 = state_12918;
(statearr_12934[(7)] = inst_12897__$1);

(statearr_12934[(11)] = inst_12899__$1);

return statearr_12934;
})();
if(cljs.core.truth_(inst_12899__$1)){
var statearr_12935_12983 = state_12918__$1;
(statearr_12935_12983[(1)] = (19));

} else {
var statearr_12936_12984 = state_12918__$1;
(statearr_12936_12984[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (25))){
var inst_12908 = (state_12918[(2)]);
var state_12918__$1 = state_12918;
var statearr_12937_12985 = state_12918__$1;
(statearr_12937_12985[(2)] = inst_12908);

(statearr_12937_12985[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (17))){
var inst_12873 = (state_12918[(10)]);
var inst_12882 = cljs.core.first.call(null,inst_12873);
var inst_12883 = cljs.core.async.muxch_STAR_.call(null,inst_12882);
var inst_12884 = cljs.core.async.close_BANG_.call(null,inst_12883);
var inst_12885 = cljs.core.next.call(null,inst_12873);
var inst_12859 = inst_12885;
var inst_12860 = null;
var inst_12861 = (0);
var inst_12862 = (0);
var state_12918__$1 = (function (){var statearr_12938 = state_12918;
(statearr_12938[(12)] = inst_12861);

(statearr_12938[(13)] = inst_12862);

(statearr_12938[(14)] = inst_12859);

(statearr_12938[(15)] = inst_12884);

(statearr_12938[(16)] = inst_12860);

return statearr_12938;
})();
var statearr_12939_12986 = state_12918__$1;
(statearr_12939_12986[(2)] = null);

(statearr_12939_12986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (3))){
var inst_12916 = (state_12918[(2)]);
var state_12918__$1 = state_12918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12918__$1,inst_12916);
} else {
if((state_val_12919 === (12))){
var inst_12893 = (state_12918[(2)]);
var state_12918__$1 = state_12918;
var statearr_12940_12987 = state_12918__$1;
(statearr_12940_12987[(2)] = inst_12893);

(statearr_12940_12987[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (2))){
var state_12918__$1 = state_12918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12918__$1,(4),ch);
} else {
if((state_val_12919 === (23))){
var state_12918__$1 = state_12918;
var statearr_12941_12988 = state_12918__$1;
(statearr_12941_12988[(2)] = null);

(statearr_12941_12988[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (19))){
var inst_12849 = (state_12918[(8)]);
var inst_12899 = (state_12918[(11)]);
var inst_12901 = cljs.core.async.muxch_STAR_.call(null,inst_12899);
var state_12918__$1 = state_12918;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12918__$1,(22),inst_12901,inst_12849);
} else {
if((state_val_12919 === (11))){
var inst_12859 = (state_12918[(14)]);
var inst_12873 = (state_12918[(10)]);
var inst_12873__$1 = cljs.core.seq.call(null,inst_12859);
var state_12918__$1 = (function (){var statearr_12942 = state_12918;
(statearr_12942[(10)] = inst_12873__$1);

return statearr_12942;
})();
if(inst_12873__$1){
var statearr_12943_12989 = state_12918__$1;
(statearr_12943_12989[(1)] = (13));

} else {
var statearr_12944_12990 = state_12918__$1;
(statearr_12944_12990[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (9))){
var inst_12895 = (state_12918[(2)]);
var state_12918__$1 = state_12918;
var statearr_12945_12991 = state_12918__$1;
(statearr_12945_12991[(2)] = inst_12895);

(statearr_12945_12991[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (5))){
var inst_12856 = cljs.core.deref.call(null,mults);
var inst_12857 = cljs.core.vals.call(null,inst_12856);
var inst_12858 = cljs.core.seq.call(null,inst_12857);
var inst_12859 = inst_12858;
var inst_12860 = null;
var inst_12861 = (0);
var inst_12862 = (0);
var state_12918__$1 = (function (){var statearr_12946 = state_12918;
(statearr_12946[(12)] = inst_12861);

(statearr_12946[(13)] = inst_12862);

(statearr_12946[(14)] = inst_12859);

(statearr_12946[(16)] = inst_12860);

return statearr_12946;
})();
var statearr_12947_12992 = state_12918__$1;
(statearr_12947_12992[(2)] = null);

(statearr_12947_12992[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (14))){
var state_12918__$1 = state_12918;
var statearr_12951_12993 = state_12918__$1;
(statearr_12951_12993[(2)] = null);

(statearr_12951_12993[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (16))){
var inst_12873 = (state_12918[(10)]);
var inst_12877 = cljs.core.chunk_first.call(null,inst_12873);
var inst_12878 = cljs.core.chunk_rest.call(null,inst_12873);
var inst_12879 = cljs.core.count.call(null,inst_12877);
var inst_12859 = inst_12878;
var inst_12860 = inst_12877;
var inst_12861 = inst_12879;
var inst_12862 = (0);
var state_12918__$1 = (function (){var statearr_12952 = state_12918;
(statearr_12952[(12)] = inst_12861);

(statearr_12952[(13)] = inst_12862);

(statearr_12952[(14)] = inst_12859);

(statearr_12952[(16)] = inst_12860);

return statearr_12952;
})();
var statearr_12953_12994 = state_12918__$1;
(statearr_12953_12994[(2)] = null);

(statearr_12953_12994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (10))){
var inst_12861 = (state_12918[(12)]);
var inst_12862 = (state_12918[(13)]);
var inst_12859 = (state_12918[(14)]);
var inst_12860 = (state_12918[(16)]);
var inst_12867 = cljs.core._nth.call(null,inst_12860,inst_12862);
var inst_12868 = cljs.core.async.muxch_STAR_.call(null,inst_12867);
var inst_12869 = cljs.core.async.close_BANG_.call(null,inst_12868);
var inst_12870 = (inst_12862 + (1));
var tmp12948 = inst_12861;
var tmp12949 = inst_12859;
var tmp12950 = inst_12860;
var inst_12859__$1 = tmp12949;
var inst_12860__$1 = tmp12950;
var inst_12861__$1 = tmp12948;
var inst_12862__$1 = inst_12870;
var state_12918__$1 = (function (){var statearr_12954 = state_12918;
(statearr_12954[(12)] = inst_12861__$1);

(statearr_12954[(13)] = inst_12862__$1);

(statearr_12954[(14)] = inst_12859__$1);

(statearr_12954[(17)] = inst_12869);

(statearr_12954[(16)] = inst_12860__$1);

return statearr_12954;
})();
var statearr_12955_12995 = state_12918__$1;
(statearr_12955_12995[(2)] = null);

(statearr_12955_12995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (18))){
var inst_12888 = (state_12918[(2)]);
var state_12918__$1 = state_12918;
var statearr_12956_12996 = state_12918__$1;
(statearr_12956_12996[(2)] = inst_12888);

(statearr_12956_12996[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12919 === (8))){
var inst_12861 = (state_12918[(12)]);
var inst_12862 = (state_12918[(13)]);
var inst_12864 = (inst_12862 < inst_12861);
var inst_12865 = inst_12864;
var state_12918__$1 = state_12918;
if(cljs.core.truth_(inst_12865)){
var statearr_12957_12997 = state_12918__$1;
(statearr_12957_12997[(1)] = (10));

} else {
var statearr_12958_12998 = state_12918__$1;
(statearr_12958_12998[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___12970,mults,ensure_mult,p))
;
return ((function (switch__10959__auto__,c__11071__auto___12970,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_12962 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12962[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_12962[(1)] = (1));

return statearr_12962;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_12918){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_12918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e12963){if((e12963 instanceof Object)){
var ex__10963__auto__ = e12963;
var statearr_12964_12999 = state_12918;
(statearr_12964_12999[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12918);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12963;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13000 = state_12918;
state_12918 = G__13000;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_12918){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_12918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___12970,mults,ensure_mult,p))
})();
var state__11073__auto__ = (function (){var statearr_12965 = f__11072__auto__.call(null);
(statearr_12965[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___12970);

return statearr_12965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___12970,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args13001 = [];
var len__5726__auto___13004 = arguments.length;
var i__5727__auto___13005 = (0);
while(true){
if((i__5727__auto___13005 < len__5726__auto___13004)){
args13001.push((arguments[i__5727__auto___13005]));

var G__13006 = (i__5727__auto___13005 + (1));
i__5727__auto___13005 = G__13006;
continue;
} else {
}
break;
}

var G__13003 = args13001.length;
switch (G__13003) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13001.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args13008 = [];
var len__5726__auto___13011 = arguments.length;
var i__5727__auto___13012 = (0);
while(true){
if((i__5727__auto___13012 < len__5726__auto___13011)){
args13008.push((arguments[i__5727__auto___13012]));

var G__13013 = (i__5727__auto___13012 + (1));
i__5727__auto___13012 = G__13013;
continue;
} else {
}
break;
}

var G__13010 = args13008.length;
switch (G__13010) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13008.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13015 = [];
var len__5726__auto___13086 = arguments.length;
var i__5727__auto___13087 = (0);
while(true){
if((i__5727__auto___13087 < len__5726__auto___13086)){
args13015.push((arguments[i__5727__auto___13087]));

var G__13088 = (i__5727__auto___13087 + (1));
i__5727__auto___13087 = G__13088;
continue;
} else {
}
break;
}

var G__13017 = args13015.length;
switch (G__13017) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13015.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11071__auto___13090 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___13090,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___13090,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13056){
var state_val_13057 = (state_13056[(1)]);
if((state_val_13057 === (7))){
var state_13056__$1 = state_13056;
var statearr_13058_13091 = state_13056__$1;
(statearr_13058_13091[(2)] = null);

(statearr_13058_13091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (1))){
var state_13056__$1 = state_13056;
var statearr_13059_13092 = state_13056__$1;
(statearr_13059_13092[(2)] = null);

(statearr_13059_13092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (4))){
var inst_13020 = (state_13056[(7)]);
var inst_13022 = (inst_13020 < cnt);
var state_13056__$1 = state_13056;
if(cljs.core.truth_(inst_13022)){
var statearr_13060_13093 = state_13056__$1;
(statearr_13060_13093[(1)] = (6));

} else {
var statearr_13061_13094 = state_13056__$1;
(statearr_13061_13094[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (15))){
var inst_13052 = (state_13056[(2)]);
var state_13056__$1 = state_13056;
var statearr_13062_13095 = state_13056__$1;
(statearr_13062_13095[(2)] = inst_13052);

(statearr_13062_13095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (13))){
var inst_13045 = cljs.core.async.close_BANG_.call(null,out);
var state_13056__$1 = state_13056;
var statearr_13063_13096 = state_13056__$1;
(statearr_13063_13096[(2)] = inst_13045);

(statearr_13063_13096[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (6))){
var state_13056__$1 = state_13056;
var statearr_13064_13097 = state_13056__$1;
(statearr_13064_13097[(2)] = null);

(statearr_13064_13097[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (3))){
var inst_13054 = (state_13056[(2)]);
var state_13056__$1 = state_13056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13056__$1,inst_13054);
} else {
if((state_val_13057 === (12))){
var inst_13042 = (state_13056[(8)]);
var inst_13042__$1 = (state_13056[(2)]);
var inst_13043 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13042__$1);
var state_13056__$1 = (function (){var statearr_13065 = state_13056;
(statearr_13065[(8)] = inst_13042__$1);

return statearr_13065;
})();
if(cljs.core.truth_(inst_13043)){
var statearr_13066_13098 = state_13056__$1;
(statearr_13066_13098[(1)] = (13));

} else {
var statearr_13067_13099 = state_13056__$1;
(statearr_13067_13099[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (2))){
var inst_13019 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13020 = (0);
var state_13056__$1 = (function (){var statearr_13068 = state_13056;
(statearr_13068[(9)] = inst_13019);

(statearr_13068[(7)] = inst_13020);

return statearr_13068;
})();
var statearr_13069_13100 = state_13056__$1;
(statearr_13069_13100[(2)] = null);

(statearr_13069_13100[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (11))){
var inst_13020 = (state_13056[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13056,(10),Object,null,(9));
var inst_13029 = chs__$1.call(null,inst_13020);
var inst_13030 = done.call(null,inst_13020);
var inst_13031 = cljs.core.async.take_BANG_.call(null,inst_13029,inst_13030);
var state_13056__$1 = state_13056;
var statearr_13070_13101 = state_13056__$1;
(statearr_13070_13101[(2)] = inst_13031);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13056__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (9))){
var inst_13020 = (state_13056[(7)]);
var inst_13033 = (state_13056[(2)]);
var inst_13034 = (inst_13020 + (1));
var inst_13020__$1 = inst_13034;
var state_13056__$1 = (function (){var statearr_13071 = state_13056;
(statearr_13071[(7)] = inst_13020__$1);

(statearr_13071[(10)] = inst_13033);

return statearr_13071;
})();
var statearr_13072_13102 = state_13056__$1;
(statearr_13072_13102[(2)] = null);

(statearr_13072_13102[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (5))){
var inst_13040 = (state_13056[(2)]);
var state_13056__$1 = (function (){var statearr_13073 = state_13056;
(statearr_13073[(11)] = inst_13040);

return statearr_13073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13056__$1,(12),dchan);
} else {
if((state_val_13057 === (14))){
var inst_13042 = (state_13056[(8)]);
var inst_13047 = cljs.core.apply.call(null,f,inst_13042);
var state_13056__$1 = state_13056;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13056__$1,(16),out,inst_13047);
} else {
if((state_val_13057 === (16))){
var inst_13049 = (state_13056[(2)]);
var state_13056__$1 = (function (){var statearr_13074 = state_13056;
(statearr_13074[(12)] = inst_13049);

return statearr_13074;
})();
var statearr_13075_13103 = state_13056__$1;
(statearr_13075_13103[(2)] = null);

(statearr_13075_13103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (10))){
var inst_13024 = (state_13056[(2)]);
var inst_13025 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13056__$1 = (function (){var statearr_13076 = state_13056;
(statearr_13076[(13)] = inst_13024);

return statearr_13076;
})();
var statearr_13077_13104 = state_13056__$1;
(statearr_13077_13104[(2)] = inst_13025);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13056__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13057 === (8))){
var inst_13038 = (state_13056[(2)]);
var state_13056__$1 = state_13056;
var statearr_13078_13105 = state_13056__$1;
(statearr_13078_13105[(2)] = inst_13038);

(statearr_13078_13105[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___13090,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10959__auto__,c__11071__auto___13090,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_13082 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13082[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_13082[(1)] = (1));

return statearr_13082;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_13056){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_13056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e13083){if((e13083 instanceof Object)){
var ex__10963__auto__ = e13083;
var statearr_13084_13106 = state_13056;
(statearr_13084_13106[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13056);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13083;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13107 = state_13056;
state_13056 = G__13107;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_13056){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_13056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___13090,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11073__auto__ = (function (){var statearr_13085 = f__11072__auto__.call(null);
(statearr_13085[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___13090);

return statearr_13085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___13090,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13109 = [];
var len__5726__auto___13165 = arguments.length;
var i__5727__auto___13166 = (0);
while(true){
if((i__5727__auto___13166 < len__5726__auto___13165)){
args13109.push((arguments[i__5727__auto___13166]));

var G__13167 = (i__5727__auto___13166 + (1));
i__5727__auto___13166 = G__13167;
continue;
} else {
}
break;
}

var G__13111 = args13109.length;
switch (G__13111) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13109.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___13169 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___13169,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___13169,out){
return (function (state_13141){
var state_val_13142 = (state_13141[(1)]);
if((state_val_13142 === (7))){
var inst_13121 = (state_13141[(7)]);
var inst_13120 = (state_13141[(8)]);
var inst_13120__$1 = (state_13141[(2)]);
var inst_13121__$1 = cljs.core.nth.call(null,inst_13120__$1,(0),null);
var inst_13122 = cljs.core.nth.call(null,inst_13120__$1,(1),null);
var inst_13123 = (inst_13121__$1 == null);
var state_13141__$1 = (function (){var statearr_13143 = state_13141;
(statearr_13143[(7)] = inst_13121__$1);

(statearr_13143[(8)] = inst_13120__$1);

(statearr_13143[(9)] = inst_13122);

return statearr_13143;
})();
if(cljs.core.truth_(inst_13123)){
var statearr_13144_13170 = state_13141__$1;
(statearr_13144_13170[(1)] = (8));

} else {
var statearr_13145_13171 = state_13141__$1;
(statearr_13145_13171[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (1))){
var inst_13112 = cljs.core.vec.call(null,chs);
var inst_13113 = inst_13112;
var state_13141__$1 = (function (){var statearr_13146 = state_13141;
(statearr_13146[(10)] = inst_13113);

return statearr_13146;
})();
var statearr_13147_13172 = state_13141__$1;
(statearr_13147_13172[(2)] = null);

(statearr_13147_13172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (4))){
var inst_13113 = (state_13141[(10)]);
var state_13141__$1 = state_13141;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13141__$1,(7),inst_13113);
} else {
if((state_val_13142 === (6))){
var inst_13137 = (state_13141[(2)]);
var state_13141__$1 = state_13141;
var statearr_13148_13173 = state_13141__$1;
(statearr_13148_13173[(2)] = inst_13137);

(statearr_13148_13173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (3))){
var inst_13139 = (state_13141[(2)]);
var state_13141__$1 = state_13141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13141__$1,inst_13139);
} else {
if((state_val_13142 === (2))){
var inst_13113 = (state_13141[(10)]);
var inst_13115 = cljs.core.count.call(null,inst_13113);
var inst_13116 = (inst_13115 > (0));
var state_13141__$1 = state_13141;
if(cljs.core.truth_(inst_13116)){
var statearr_13150_13174 = state_13141__$1;
(statearr_13150_13174[(1)] = (4));

} else {
var statearr_13151_13175 = state_13141__$1;
(statearr_13151_13175[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (11))){
var inst_13113 = (state_13141[(10)]);
var inst_13130 = (state_13141[(2)]);
var tmp13149 = inst_13113;
var inst_13113__$1 = tmp13149;
var state_13141__$1 = (function (){var statearr_13152 = state_13141;
(statearr_13152[(10)] = inst_13113__$1);

(statearr_13152[(11)] = inst_13130);

return statearr_13152;
})();
var statearr_13153_13176 = state_13141__$1;
(statearr_13153_13176[(2)] = null);

(statearr_13153_13176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (9))){
var inst_13121 = (state_13141[(7)]);
var state_13141__$1 = state_13141;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13141__$1,(11),out,inst_13121);
} else {
if((state_val_13142 === (5))){
var inst_13135 = cljs.core.async.close_BANG_.call(null,out);
var state_13141__$1 = state_13141;
var statearr_13154_13177 = state_13141__$1;
(statearr_13154_13177[(2)] = inst_13135);

(statearr_13154_13177[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (10))){
var inst_13133 = (state_13141[(2)]);
var state_13141__$1 = state_13141;
var statearr_13155_13178 = state_13141__$1;
(statearr_13155_13178[(2)] = inst_13133);

(statearr_13155_13178[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13142 === (8))){
var inst_13113 = (state_13141[(10)]);
var inst_13121 = (state_13141[(7)]);
var inst_13120 = (state_13141[(8)]);
var inst_13122 = (state_13141[(9)]);
var inst_13125 = (function (){var cs = inst_13113;
var vec__13118 = inst_13120;
var v = inst_13121;
var c = inst_13122;
return ((function (cs,vec__13118,v,c,inst_13113,inst_13121,inst_13120,inst_13122,state_val_13142,c__11071__auto___13169,out){
return (function (p1__13108_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13108_SHARP_);
});
;})(cs,vec__13118,v,c,inst_13113,inst_13121,inst_13120,inst_13122,state_val_13142,c__11071__auto___13169,out))
})();
var inst_13126 = cljs.core.filterv.call(null,inst_13125,inst_13113);
var inst_13113__$1 = inst_13126;
var state_13141__$1 = (function (){var statearr_13156 = state_13141;
(statearr_13156[(10)] = inst_13113__$1);

return statearr_13156;
})();
var statearr_13157_13179 = state_13141__$1;
(statearr_13157_13179[(2)] = null);

(statearr_13157_13179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___13169,out))
;
return ((function (switch__10959__auto__,c__11071__auto___13169,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_13161 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13161[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_13161[(1)] = (1));

return statearr_13161;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_13141){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_13141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e13162){if((e13162 instanceof Object)){
var ex__10963__auto__ = e13162;
var statearr_13163_13180 = state_13141;
(statearr_13163_13180[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13141);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13162;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13181 = state_13141;
state_13141 = G__13181;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_13141){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_13141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___13169,out))
})();
var state__11073__auto__ = (function (){var statearr_13164 = f__11072__auto__.call(null);
(statearr_13164[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___13169);

return statearr_13164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___13169,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13182 = [];
var len__5726__auto___13231 = arguments.length;
var i__5727__auto___13232 = (0);
while(true){
if((i__5727__auto___13232 < len__5726__auto___13231)){
args13182.push((arguments[i__5727__auto___13232]));

var G__13233 = (i__5727__auto___13232 + (1));
i__5727__auto___13232 = G__13233;
continue;
} else {
}
break;
}

var G__13184 = args13182.length;
switch (G__13184) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13182.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___13235 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___13235,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___13235,out){
return (function (state_13208){
var state_val_13209 = (state_13208[(1)]);
if((state_val_13209 === (7))){
var inst_13190 = (state_13208[(7)]);
var inst_13190__$1 = (state_13208[(2)]);
var inst_13191 = (inst_13190__$1 == null);
var inst_13192 = cljs.core.not.call(null,inst_13191);
var state_13208__$1 = (function (){var statearr_13210 = state_13208;
(statearr_13210[(7)] = inst_13190__$1);

return statearr_13210;
})();
if(inst_13192){
var statearr_13211_13236 = state_13208__$1;
(statearr_13211_13236[(1)] = (8));

} else {
var statearr_13212_13237 = state_13208__$1;
(statearr_13212_13237[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13209 === (1))){
var inst_13185 = (0);
var state_13208__$1 = (function (){var statearr_13213 = state_13208;
(statearr_13213[(8)] = inst_13185);

return statearr_13213;
})();
var statearr_13214_13238 = state_13208__$1;
(statearr_13214_13238[(2)] = null);

(statearr_13214_13238[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13209 === (4))){
var state_13208__$1 = state_13208;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13208__$1,(7),ch);
} else {
if((state_val_13209 === (6))){
var inst_13203 = (state_13208[(2)]);
var state_13208__$1 = state_13208;
var statearr_13215_13239 = state_13208__$1;
(statearr_13215_13239[(2)] = inst_13203);

(statearr_13215_13239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13209 === (3))){
var inst_13205 = (state_13208[(2)]);
var inst_13206 = cljs.core.async.close_BANG_.call(null,out);
var state_13208__$1 = (function (){var statearr_13216 = state_13208;
(statearr_13216[(9)] = inst_13205);

return statearr_13216;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13208__$1,inst_13206);
} else {
if((state_val_13209 === (2))){
var inst_13185 = (state_13208[(8)]);
var inst_13187 = (inst_13185 < n);
var state_13208__$1 = state_13208;
if(cljs.core.truth_(inst_13187)){
var statearr_13217_13240 = state_13208__$1;
(statearr_13217_13240[(1)] = (4));

} else {
var statearr_13218_13241 = state_13208__$1;
(statearr_13218_13241[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13209 === (11))){
var inst_13185 = (state_13208[(8)]);
var inst_13195 = (state_13208[(2)]);
var inst_13196 = (inst_13185 + (1));
var inst_13185__$1 = inst_13196;
var state_13208__$1 = (function (){var statearr_13219 = state_13208;
(statearr_13219[(8)] = inst_13185__$1);

(statearr_13219[(10)] = inst_13195);

return statearr_13219;
})();
var statearr_13220_13242 = state_13208__$1;
(statearr_13220_13242[(2)] = null);

(statearr_13220_13242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13209 === (9))){
var state_13208__$1 = state_13208;
var statearr_13221_13243 = state_13208__$1;
(statearr_13221_13243[(2)] = null);

(statearr_13221_13243[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13209 === (5))){
var state_13208__$1 = state_13208;
var statearr_13222_13244 = state_13208__$1;
(statearr_13222_13244[(2)] = null);

(statearr_13222_13244[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13209 === (10))){
var inst_13200 = (state_13208[(2)]);
var state_13208__$1 = state_13208;
var statearr_13223_13245 = state_13208__$1;
(statearr_13223_13245[(2)] = inst_13200);

(statearr_13223_13245[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13209 === (8))){
var inst_13190 = (state_13208[(7)]);
var state_13208__$1 = state_13208;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13208__$1,(11),out,inst_13190);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___13235,out))
;
return ((function (switch__10959__auto__,c__11071__auto___13235,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_13227 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13227[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_13227[(1)] = (1));

return statearr_13227;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_13208){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_13208);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e13228){if((e13228 instanceof Object)){
var ex__10963__auto__ = e13228;
var statearr_13229_13246 = state_13208;
(statearr_13229_13246[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13208);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13228;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13247 = state_13208;
state_13208 = G__13247;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_13208){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_13208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___13235,out))
})();
var state__11073__auto__ = (function (){var statearr_13230 = f__11072__auto__.call(null);
(statearr_13230[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___13235);

return statearr_13230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___13235,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13255 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13255 = (function (map_LT_,f,ch,meta13256){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13256 = meta13256;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13257,meta13256__$1){
var self__ = this;
var _13257__$1 = this;
return (new cljs.core.async.t_cljs$core$async13255(self__.map_LT_,self__.f,self__.ch,meta13256__$1));
});

cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13257){
var self__ = this;
var _13257__$1 = this;
return self__.meta13256;
});

cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async13258 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13258 = (function (map_LT_,f,ch,meta13256,_,fn1,meta13259){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13256 = meta13256;
this._ = _;
this.fn1 = fn1;
this.meta13259 = meta13259;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13258.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13260,meta13259__$1){
var self__ = this;
var _13260__$1 = this;
return (new cljs.core.async.t_cljs$core$async13258(self__.map_LT_,self__.f,self__.ch,self__.meta13256,self__._,self__.fn1,meta13259__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async13258.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13260){
var self__ = this;
var _13260__$1 = this;
return self__.meta13259;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13258.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13258.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13258.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13258.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__13248_SHARP_){
return f1.call(null,(((p1__13248_SHARP_ == null))?null:self__.f.call(null,p1__13248_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async13258.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13256","meta13256",-1131643898,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13255","cljs.core.async/t_cljs$core$async13255",1908632648,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13259","meta13259",1984781603,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13258.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13258.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13258";

cljs.core.async.t_cljs$core$async13258.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13258");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async13258 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13258(map_LT___$1,f__$1,ch__$1,meta13256__$1,___$2,fn1__$1,meta13259){
return (new cljs.core.async.t_cljs$core$async13258(map_LT___$1,f__$1,ch__$1,meta13256__$1,___$2,fn1__$1,meta13259));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async13258(self__.map_LT_,self__.f,self__.ch,self__.meta13256,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13255.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async13255.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13256","meta13256",-1131643898,null)], null);
});

cljs.core.async.t_cljs$core$async13255.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13255.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13255";

cljs.core.async.t_cljs$core$async13255.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13255");
});

cljs.core.async.__GT_t_cljs$core$async13255 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13255(map_LT___$1,f__$1,ch__$1,meta13256){
return (new cljs.core.async.t_cljs$core$async13255(map_LT___$1,f__$1,ch__$1,meta13256));
});

}

return (new cljs.core.async.t_cljs$core$async13255(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13264 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13264 = (function (map_GT_,f,ch,meta13265){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta13265 = meta13265;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13266,meta13265__$1){
var self__ = this;
var _13266__$1 = this;
return (new cljs.core.async.t_cljs$core$async13264(self__.map_GT_,self__.f,self__.ch,meta13265__$1));
});

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13266){
var self__ = this;
var _13266__$1 = this;
return self__.meta13265;
});

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async13264.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13265","meta13265",1268174886,null)], null);
});

cljs.core.async.t_cljs$core$async13264.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13264.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13264";

cljs.core.async.t_cljs$core$async13264.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13264");
});

cljs.core.async.__GT_t_cljs$core$async13264 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13264(map_GT___$1,f__$1,ch__$1,meta13265){
return (new cljs.core.async.t_cljs$core$async13264(map_GT___$1,f__$1,ch__$1,meta13265));
});

}

return (new cljs.core.async.t_cljs$core$async13264(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async13270 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13270 = (function (filter_GT_,p,ch,meta13271){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13271 = meta13271;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13272,meta13271__$1){
var self__ = this;
var _13272__$1 = this;
return (new cljs.core.async.t_cljs$core$async13270(self__.filter_GT_,self__.p,self__.ch,meta13271__$1));
});

cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13272){
var self__ = this;
var _13272__$1 = this;
return self__.meta13271;
});

cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13270.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async13270.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13271","meta13271",1549167547,null)], null);
});

cljs.core.async.t_cljs$core$async13270.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13270.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13270";

cljs.core.async.t_cljs$core$async13270.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13270");
});

cljs.core.async.__GT_t_cljs$core$async13270 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13270(filter_GT___$1,p__$1,ch__$1,meta13271){
return (new cljs.core.async.t_cljs$core$async13270(filter_GT___$1,p__$1,ch__$1,meta13271));
});

}

return (new cljs.core.async.t_cljs$core$async13270(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args13273 = [];
var len__5726__auto___13317 = arguments.length;
var i__5727__auto___13318 = (0);
while(true){
if((i__5727__auto___13318 < len__5726__auto___13317)){
args13273.push((arguments[i__5727__auto___13318]));

var G__13319 = (i__5727__auto___13318 + (1));
i__5727__auto___13318 = G__13319;
continue;
} else {
}
break;
}

var G__13275 = args13273.length;
switch (G__13275) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13273.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___13321 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___13321,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___13321,out){
return (function (state_13296){
var state_val_13297 = (state_13296[(1)]);
if((state_val_13297 === (7))){
var inst_13292 = (state_13296[(2)]);
var state_13296__$1 = state_13296;
var statearr_13298_13322 = state_13296__$1;
(statearr_13298_13322[(2)] = inst_13292);

(statearr_13298_13322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (1))){
var state_13296__$1 = state_13296;
var statearr_13299_13323 = state_13296__$1;
(statearr_13299_13323[(2)] = null);

(statearr_13299_13323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (4))){
var inst_13278 = (state_13296[(7)]);
var inst_13278__$1 = (state_13296[(2)]);
var inst_13279 = (inst_13278__$1 == null);
var state_13296__$1 = (function (){var statearr_13300 = state_13296;
(statearr_13300[(7)] = inst_13278__$1);

return statearr_13300;
})();
if(cljs.core.truth_(inst_13279)){
var statearr_13301_13324 = state_13296__$1;
(statearr_13301_13324[(1)] = (5));

} else {
var statearr_13302_13325 = state_13296__$1;
(statearr_13302_13325[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (6))){
var inst_13278 = (state_13296[(7)]);
var inst_13283 = p.call(null,inst_13278);
var state_13296__$1 = state_13296;
if(cljs.core.truth_(inst_13283)){
var statearr_13303_13326 = state_13296__$1;
(statearr_13303_13326[(1)] = (8));

} else {
var statearr_13304_13327 = state_13296__$1;
(statearr_13304_13327[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (3))){
var inst_13294 = (state_13296[(2)]);
var state_13296__$1 = state_13296;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13296__$1,inst_13294);
} else {
if((state_val_13297 === (2))){
var state_13296__$1 = state_13296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13296__$1,(4),ch);
} else {
if((state_val_13297 === (11))){
var inst_13286 = (state_13296[(2)]);
var state_13296__$1 = state_13296;
var statearr_13305_13328 = state_13296__$1;
(statearr_13305_13328[(2)] = inst_13286);

(statearr_13305_13328[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (9))){
var state_13296__$1 = state_13296;
var statearr_13306_13329 = state_13296__$1;
(statearr_13306_13329[(2)] = null);

(statearr_13306_13329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (5))){
var inst_13281 = cljs.core.async.close_BANG_.call(null,out);
var state_13296__$1 = state_13296;
var statearr_13307_13330 = state_13296__$1;
(statearr_13307_13330[(2)] = inst_13281);

(statearr_13307_13330[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (10))){
var inst_13289 = (state_13296[(2)]);
var state_13296__$1 = (function (){var statearr_13308 = state_13296;
(statearr_13308[(8)] = inst_13289);

return statearr_13308;
})();
var statearr_13309_13331 = state_13296__$1;
(statearr_13309_13331[(2)] = null);

(statearr_13309_13331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (8))){
var inst_13278 = (state_13296[(7)]);
var state_13296__$1 = state_13296;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13296__$1,(11),out,inst_13278);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___13321,out))
;
return ((function (switch__10959__auto__,c__11071__auto___13321,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_13313 = [null,null,null,null,null,null,null,null,null];
(statearr_13313[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_13313[(1)] = (1));

return statearr_13313;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_13296){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_13296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e13314){if((e13314 instanceof Object)){
var ex__10963__auto__ = e13314;
var statearr_13315_13332 = state_13296;
(statearr_13315_13332[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13296);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13314;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13333 = state_13296;
state_13296 = G__13333;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_13296){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_13296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___13321,out))
})();
var state__11073__auto__ = (function (){var statearr_13316 = f__11072__auto__.call(null);
(statearr_13316[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___13321);

return statearr_13316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___13321,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args13334 = [];
var len__5726__auto___13337 = arguments.length;
var i__5727__auto___13338 = (0);
while(true){
if((i__5727__auto___13338 < len__5726__auto___13337)){
args13334.push((arguments[i__5727__auto___13338]));

var G__13339 = (i__5727__auto___13338 + (1));
i__5727__auto___13338 = G__13339;
continue;
} else {
}
break;
}

var G__13336 = args13334.length;
switch (G__13336) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13334.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11071__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto__){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto__){
return (function (state_13506){
var state_val_13507 = (state_13506[(1)]);
if((state_val_13507 === (7))){
var inst_13502 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13508_13549 = state_13506__$1;
(statearr_13508_13549[(2)] = inst_13502);

(statearr_13508_13549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (20))){
var inst_13472 = (state_13506[(7)]);
var inst_13483 = (state_13506[(2)]);
var inst_13484 = cljs.core.next.call(null,inst_13472);
var inst_13458 = inst_13484;
var inst_13459 = null;
var inst_13460 = (0);
var inst_13461 = (0);
var state_13506__$1 = (function (){var statearr_13509 = state_13506;
(statearr_13509[(8)] = inst_13483);

(statearr_13509[(9)] = inst_13460);

(statearr_13509[(10)] = inst_13461);

(statearr_13509[(11)] = inst_13458);

(statearr_13509[(12)] = inst_13459);

return statearr_13509;
})();
var statearr_13510_13550 = state_13506__$1;
(statearr_13510_13550[(2)] = null);

(statearr_13510_13550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (1))){
var state_13506__$1 = state_13506;
var statearr_13511_13551 = state_13506__$1;
(statearr_13511_13551[(2)] = null);

(statearr_13511_13551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (4))){
var inst_13447 = (state_13506[(13)]);
var inst_13447__$1 = (state_13506[(2)]);
var inst_13448 = (inst_13447__$1 == null);
var state_13506__$1 = (function (){var statearr_13512 = state_13506;
(statearr_13512[(13)] = inst_13447__$1);

return statearr_13512;
})();
if(cljs.core.truth_(inst_13448)){
var statearr_13513_13552 = state_13506__$1;
(statearr_13513_13552[(1)] = (5));

} else {
var statearr_13514_13553 = state_13506__$1;
(statearr_13514_13553[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (15))){
var state_13506__$1 = state_13506;
var statearr_13518_13554 = state_13506__$1;
(statearr_13518_13554[(2)] = null);

(statearr_13518_13554[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (21))){
var state_13506__$1 = state_13506;
var statearr_13519_13555 = state_13506__$1;
(statearr_13519_13555[(2)] = null);

(statearr_13519_13555[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (13))){
var inst_13460 = (state_13506[(9)]);
var inst_13461 = (state_13506[(10)]);
var inst_13458 = (state_13506[(11)]);
var inst_13459 = (state_13506[(12)]);
var inst_13468 = (state_13506[(2)]);
var inst_13469 = (inst_13461 + (1));
var tmp13515 = inst_13460;
var tmp13516 = inst_13458;
var tmp13517 = inst_13459;
var inst_13458__$1 = tmp13516;
var inst_13459__$1 = tmp13517;
var inst_13460__$1 = tmp13515;
var inst_13461__$1 = inst_13469;
var state_13506__$1 = (function (){var statearr_13520 = state_13506;
(statearr_13520[(9)] = inst_13460__$1);

(statearr_13520[(10)] = inst_13461__$1);

(statearr_13520[(11)] = inst_13458__$1);

(statearr_13520[(14)] = inst_13468);

(statearr_13520[(12)] = inst_13459__$1);

return statearr_13520;
})();
var statearr_13521_13556 = state_13506__$1;
(statearr_13521_13556[(2)] = null);

(statearr_13521_13556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (22))){
var state_13506__$1 = state_13506;
var statearr_13522_13557 = state_13506__$1;
(statearr_13522_13557[(2)] = null);

(statearr_13522_13557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (6))){
var inst_13447 = (state_13506[(13)]);
var inst_13456 = f.call(null,inst_13447);
var inst_13457 = cljs.core.seq.call(null,inst_13456);
var inst_13458 = inst_13457;
var inst_13459 = null;
var inst_13460 = (0);
var inst_13461 = (0);
var state_13506__$1 = (function (){var statearr_13523 = state_13506;
(statearr_13523[(9)] = inst_13460);

(statearr_13523[(10)] = inst_13461);

(statearr_13523[(11)] = inst_13458);

(statearr_13523[(12)] = inst_13459);

return statearr_13523;
})();
var statearr_13524_13558 = state_13506__$1;
(statearr_13524_13558[(2)] = null);

(statearr_13524_13558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (17))){
var inst_13472 = (state_13506[(7)]);
var inst_13476 = cljs.core.chunk_first.call(null,inst_13472);
var inst_13477 = cljs.core.chunk_rest.call(null,inst_13472);
var inst_13478 = cljs.core.count.call(null,inst_13476);
var inst_13458 = inst_13477;
var inst_13459 = inst_13476;
var inst_13460 = inst_13478;
var inst_13461 = (0);
var state_13506__$1 = (function (){var statearr_13525 = state_13506;
(statearr_13525[(9)] = inst_13460);

(statearr_13525[(10)] = inst_13461);

(statearr_13525[(11)] = inst_13458);

(statearr_13525[(12)] = inst_13459);

return statearr_13525;
})();
var statearr_13526_13559 = state_13506__$1;
(statearr_13526_13559[(2)] = null);

(statearr_13526_13559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (3))){
var inst_13504 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13506__$1,inst_13504);
} else {
if((state_val_13507 === (12))){
var inst_13492 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13527_13560 = state_13506__$1;
(statearr_13527_13560[(2)] = inst_13492);

(statearr_13527_13560[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (2))){
var state_13506__$1 = state_13506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13506__$1,(4),in$);
} else {
if((state_val_13507 === (23))){
var inst_13500 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13528_13561 = state_13506__$1;
(statearr_13528_13561[(2)] = inst_13500);

(statearr_13528_13561[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (19))){
var inst_13487 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13529_13562 = state_13506__$1;
(statearr_13529_13562[(2)] = inst_13487);

(statearr_13529_13562[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (11))){
var inst_13472 = (state_13506[(7)]);
var inst_13458 = (state_13506[(11)]);
var inst_13472__$1 = cljs.core.seq.call(null,inst_13458);
var state_13506__$1 = (function (){var statearr_13530 = state_13506;
(statearr_13530[(7)] = inst_13472__$1);

return statearr_13530;
})();
if(inst_13472__$1){
var statearr_13531_13563 = state_13506__$1;
(statearr_13531_13563[(1)] = (14));

} else {
var statearr_13532_13564 = state_13506__$1;
(statearr_13532_13564[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (9))){
var inst_13494 = (state_13506[(2)]);
var inst_13495 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13506__$1 = (function (){var statearr_13533 = state_13506;
(statearr_13533[(15)] = inst_13494);

return statearr_13533;
})();
if(cljs.core.truth_(inst_13495)){
var statearr_13534_13565 = state_13506__$1;
(statearr_13534_13565[(1)] = (21));

} else {
var statearr_13535_13566 = state_13506__$1;
(statearr_13535_13566[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (5))){
var inst_13450 = cljs.core.async.close_BANG_.call(null,out);
var state_13506__$1 = state_13506;
var statearr_13536_13567 = state_13506__$1;
(statearr_13536_13567[(2)] = inst_13450);

(statearr_13536_13567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (14))){
var inst_13472 = (state_13506[(7)]);
var inst_13474 = cljs.core.chunked_seq_QMARK_.call(null,inst_13472);
var state_13506__$1 = state_13506;
if(inst_13474){
var statearr_13537_13568 = state_13506__$1;
(statearr_13537_13568[(1)] = (17));

} else {
var statearr_13538_13569 = state_13506__$1;
(statearr_13538_13569[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (16))){
var inst_13490 = (state_13506[(2)]);
var state_13506__$1 = state_13506;
var statearr_13539_13570 = state_13506__$1;
(statearr_13539_13570[(2)] = inst_13490);

(statearr_13539_13570[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13507 === (10))){
var inst_13461 = (state_13506[(10)]);
var inst_13459 = (state_13506[(12)]);
var inst_13466 = cljs.core._nth.call(null,inst_13459,inst_13461);
var state_13506__$1 = state_13506;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13506__$1,(13),out,inst_13466);
} else {
if((state_val_13507 === (18))){
var inst_13472 = (state_13506[(7)]);
var inst_13481 = cljs.core.first.call(null,inst_13472);
var state_13506__$1 = state_13506;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13506__$1,(20),out,inst_13481);
} else {
if((state_val_13507 === (8))){
var inst_13460 = (state_13506[(9)]);
var inst_13461 = (state_13506[(10)]);
var inst_13463 = (inst_13461 < inst_13460);
var inst_13464 = inst_13463;
var state_13506__$1 = state_13506;
if(cljs.core.truth_(inst_13464)){
var statearr_13540_13571 = state_13506__$1;
(statearr_13540_13571[(1)] = (10));

} else {
var statearr_13541_13572 = state_13506__$1;
(statearr_13541_13572[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto__))
;
return ((function (switch__10959__auto__,c__11071__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____0 = (function (){
var statearr_13545 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13545[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__);

(statearr_13545[(1)] = (1));

return statearr_13545;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____1 = (function (state_13506){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_13506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e13546){if((e13546 instanceof Object)){
var ex__10963__auto__ = e13546;
var statearr_13547_13573 = state_13506;
(statearr_13547_13573[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13546;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13574 = state_13506;
state_13506 = G__13574;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__ = function(state_13506){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____1.call(this,state_13506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10960__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto__))
})();
var state__11073__auto__ = (function (){var statearr_13548 = f__11072__auto__.call(null);
(statearr_13548[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto__);

return statearr_13548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto__))
);

return c__11071__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13575 = [];
var len__5726__auto___13578 = arguments.length;
var i__5727__auto___13579 = (0);
while(true){
if((i__5727__auto___13579 < len__5726__auto___13578)){
args13575.push((arguments[i__5727__auto___13579]));

var G__13580 = (i__5727__auto___13579 + (1));
i__5727__auto___13579 = G__13580;
continue;
} else {
}
break;
}

var G__13577 = args13575.length;
switch (G__13577) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13575.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13582 = [];
var len__5726__auto___13585 = arguments.length;
var i__5727__auto___13586 = (0);
while(true){
if((i__5727__auto___13586 < len__5726__auto___13585)){
args13582.push((arguments[i__5727__auto___13586]));

var G__13587 = (i__5727__auto___13586 + (1));
i__5727__auto___13586 = G__13587;
continue;
} else {
}
break;
}

var G__13584 = args13582.length;
switch (G__13584) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13582.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13589 = [];
var len__5726__auto___13640 = arguments.length;
var i__5727__auto___13641 = (0);
while(true){
if((i__5727__auto___13641 < len__5726__auto___13640)){
args13589.push((arguments[i__5727__auto___13641]));

var G__13642 = (i__5727__auto___13641 + (1));
i__5727__auto___13641 = G__13642;
continue;
} else {
}
break;
}

var G__13591 = args13589.length;
switch (G__13591) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13589.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___13644 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___13644,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___13644,out){
return (function (state_13615){
var state_val_13616 = (state_13615[(1)]);
if((state_val_13616 === (7))){
var inst_13610 = (state_13615[(2)]);
var state_13615__$1 = state_13615;
var statearr_13617_13645 = state_13615__$1;
(statearr_13617_13645[(2)] = inst_13610);

(statearr_13617_13645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13616 === (1))){
var inst_13592 = null;
var state_13615__$1 = (function (){var statearr_13618 = state_13615;
(statearr_13618[(7)] = inst_13592);

return statearr_13618;
})();
var statearr_13619_13646 = state_13615__$1;
(statearr_13619_13646[(2)] = null);

(statearr_13619_13646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13616 === (4))){
var inst_13595 = (state_13615[(8)]);
var inst_13595__$1 = (state_13615[(2)]);
var inst_13596 = (inst_13595__$1 == null);
var inst_13597 = cljs.core.not.call(null,inst_13596);
var state_13615__$1 = (function (){var statearr_13620 = state_13615;
(statearr_13620[(8)] = inst_13595__$1);

return statearr_13620;
})();
if(inst_13597){
var statearr_13621_13647 = state_13615__$1;
(statearr_13621_13647[(1)] = (5));

} else {
var statearr_13622_13648 = state_13615__$1;
(statearr_13622_13648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13616 === (6))){
var state_13615__$1 = state_13615;
var statearr_13623_13649 = state_13615__$1;
(statearr_13623_13649[(2)] = null);

(statearr_13623_13649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13616 === (3))){
var inst_13612 = (state_13615[(2)]);
var inst_13613 = cljs.core.async.close_BANG_.call(null,out);
var state_13615__$1 = (function (){var statearr_13624 = state_13615;
(statearr_13624[(9)] = inst_13612);

return statearr_13624;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13615__$1,inst_13613);
} else {
if((state_val_13616 === (2))){
var state_13615__$1 = state_13615;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13615__$1,(4),ch);
} else {
if((state_val_13616 === (11))){
var inst_13595 = (state_13615[(8)]);
var inst_13604 = (state_13615[(2)]);
var inst_13592 = inst_13595;
var state_13615__$1 = (function (){var statearr_13625 = state_13615;
(statearr_13625[(10)] = inst_13604);

(statearr_13625[(7)] = inst_13592);

return statearr_13625;
})();
var statearr_13626_13650 = state_13615__$1;
(statearr_13626_13650[(2)] = null);

(statearr_13626_13650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13616 === (9))){
var inst_13595 = (state_13615[(8)]);
var state_13615__$1 = state_13615;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13615__$1,(11),out,inst_13595);
} else {
if((state_val_13616 === (5))){
var inst_13595 = (state_13615[(8)]);
var inst_13592 = (state_13615[(7)]);
var inst_13599 = cljs.core._EQ_.call(null,inst_13595,inst_13592);
var state_13615__$1 = state_13615;
if(inst_13599){
var statearr_13628_13651 = state_13615__$1;
(statearr_13628_13651[(1)] = (8));

} else {
var statearr_13629_13652 = state_13615__$1;
(statearr_13629_13652[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13616 === (10))){
var inst_13607 = (state_13615[(2)]);
var state_13615__$1 = state_13615;
var statearr_13630_13653 = state_13615__$1;
(statearr_13630_13653[(2)] = inst_13607);

(statearr_13630_13653[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13616 === (8))){
var inst_13592 = (state_13615[(7)]);
var tmp13627 = inst_13592;
var inst_13592__$1 = tmp13627;
var state_13615__$1 = (function (){var statearr_13631 = state_13615;
(statearr_13631[(7)] = inst_13592__$1);

return statearr_13631;
})();
var statearr_13632_13654 = state_13615__$1;
(statearr_13632_13654[(2)] = null);

(statearr_13632_13654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___13644,out))
;
return ((function (switch__10959__auto__,c__11071__auto___13644,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_13636 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13636[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_13636[(1)] = (1));

return statearr_13636;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_13615){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_13615);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e13637){if((e13637 instanceof Object)){
var ex__10963__auto__ = e13637;
var statearr_13638_13655 = state_13615;
(statearr_13638_13655[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13615);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13637;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13656 = state_13615;
state_13615 = G__13656;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_13615){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_13615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___13644,out))
})();
var state__11073__auto__ = (function (){var statearr_13639 = f__11072__auto__.call(null);
(statearr_13639[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___13644);

return statearr_13639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___13644,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13657 = [];
var len__5726__auto___13727 = arguments.length;
var i__5727__auto___13728 = (0);
while(true){
if((i__5727__auto___13728 < len__5726__auto___13727)){
args13657.push((arguments[i__5727__auto___13728]));

var G__13729 = (i__5727__auto___13728 + (1));
i__5727__auto___13728 = G__13729;
continue;
} else {
}
break;
}

var G__13659 = args13657.length;
switch (G__13659) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13657.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___13731 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___13731,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___13731,out){
return (function (state_13697){
var state_val_13698 = (state_13697[(1)]);
if((state_val_13698 === (7))){
var inst_13693 = (state_13697[(2)]);
var state_13697__$1 = state_13697;
var statearr_13699_13732 = state_13697__$1;
(statearr_13699_13732[(2)] = inst_13693);

(statearr_13699_13732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (1))){
var inst_13660 = (new Array(n));
var inst_13661 = inst_13660;
var inst_13662 = (0);
var state_13697__$1 = (function (){var statearr_13700 = state_13697;
(statearr_13700[(7)] = inst_13662);

(statearr_13700[(8)] = inst_13661);

return statearr_13700;
})();
var statearr_13701_13733 = state_13697__$1;
(statearr_13701_13733[(2)] = null);

(statearr_13701_13733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (4))){
var inst_13665 = (state_13697[(9)]);
var inst_13665__$1 = (state_13697[(2)]);
var inst_13666 = (inst_13665__$1 == null);
var inst_13667 = cljs.core.not.call(null,inst_13666);
var state_13697__$1 = (function (){var statearr_13702 = state_13697;
(statearr_13702[(9)] = inst_13665__$1);

return statearr_13702;
})();
if(inst_13667){
var statearr_13703_13734 = state_13697__$1;
(statearr_13703_13734[(1)] = (5));

} else {
var statearr_13704_13735 = state_13697__$1;
(statearr_13704_13735[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (15))){
var inst_13687 = (state_13697[(2)]);
var state_13697__$1 = state_13697;
var statearr_13705_13736 = state_13697__$1;
(statearr_13705_13736[(2)] = inst_13687);

(statearr_13705_13736[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (13))){
var state_13697__$1 = state_13697;
var statearr_13706_13737 = state_13697__$1;
(statearr_13706_13737[(2)] = null);

(statearr_13706_13737[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (6))){
var inst_13662 = (state_13697[(7)]);
var inst_13683 = (inst_13662 > (0));
var state_13697__$1 = state_13697;
if(cljs.core.truth_(inst_13683)){
var statearr_13707_13738 = state_13697__$1;
(statearr_13707_13738[(1)] = (12));

} else {
var statearr_13708_13739 = state_13697__$1;
(statearr_13708_13739[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (3))){
var inst_13695 = (state_13697[(2)]);
var state_13697__$1 = state_13697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13697__$1,inst_13695);
} else {
if((state_val_13698 === (12))){
var inst_13661 = (state_13697[(8)]);
var inst_13685 = cljs.core.vec.call(null,inst_13661);
var state_13697__$1 = state_13697;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13697__$1,(15),out,inst_13685);
} else {
if((state_val_13698 === (2))){
var state_13697__$1 = state_13697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13697__$1,(4),ch);
} else {
if((state_val_13698 === (11))){
var inst_13677 = (state_13697[(2)]);
var inst_13678 = (new Array(n));
var inst_13661 = inst_13678;
var inst_13662 = (0);
var state_13697__$1 = (function (){var statearr_13709 = state_13697;
(statearr_13709[(7)] = inst_13662);

(statearr_13709[(10)] = inst_13677);

(statearr_13709[(8)] = inst_13661);

return statearr_13709;
})();
var statearr_13710_13740 = state_13697__$1;
(statearr_13710_13740[(2)] = null);

(statearr_13710_13740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (9))){
var inst_13661 = (state_13697[(8)]);
var inst_13675 = cljs.core.vec.call(null,inst_13661);
var state_13697__$1 = state_13697;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13697__$1,(11),out,inst_13675);
} else {
if((state_val_13698 === (5))){
var inst_13662 = (state_13697[(7)]);
var inst_13665 = (state_13697[(9)]);
var inst_13670 = (state_13697[(11)]);
var inst_13661 = (state_13697[(8)]);
var inst_13669 = (inst_13661[inst_13662] = inst_13665);
var inst_13670__$1 = (inst_13662 + (1));
var inst_13671 = (inst_13670__$1 < n);
var state_13697__$1 = (function (){var statearr_13711 = state_13697;
(statearr_13711[(11)] = inst_13670__$1);

(statearr_13711[(12)] = inst_13669);

return statearr_13711;
})();
if(cljs.core.truth_(inst_13671)){
var statearr_13712_13741 = state_13697__$1;
(statearr_13712_13741[(1)] = (8));

} else {
var statearr_13713_13742 = state_13697__$1;
(statearr_13713_13742[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (14))){
var inst_13690 = (state_13697[(2)]);
var inst_13691 = cljs.core.async.close_BANG_.call(null,out);
var state_13697__$1 = (function (){var statearr_13715 = state_13697;
(statearr_13715[(13)] = inst_13690);

return statearr_13715;
})();
var statearr_13716_13743 = state_13697__$1;
(statearr_13716_13743[(2)] = inst_13691);

(statearr_13716_13743[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (10))){
var inst_13681 = (state_13697[(2)]);
var state_13697__$1 = state_13697;
var statearr_13717_13744 = state_13697__$1;
(statearr_13717_13744[(2)] = inst_13681);

(statearr_13717_13744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13698 === (8))){
var inst_13670 = (state_13697[(11)]);
var inst_13661 = (state_13697[(8)]);
var tmp13714 = inst_13661;
var inst_13661__$1 = tmp13714;
var inst_13662 = inst_13670;
var state_13697__$1 = (function (){var statearr_13718 = state_13697;
(statearr_13718[(7)] = inst_13662);

(statearr_13718[(8)] = inst_13661__$1);

return statearr_13718;
})();
var statearr_13719_13745 = state_13697__$1;
(statearr_13719_13745[(2)] = null);

(statearr_13719_13745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___13731,out))
;
return ((function (switch__10959__auto__,c__11071__auto___13731,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_13723 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13723[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_13723[(1)] = (1));

return statearr_13723;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_13697){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_13697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e13724){if((e13724 instanceof Object)){
var ex__10963__auto__ = e13724;
var statearr_13725_13746 = state_13697;
(statearr_13725_13746[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13697);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13724;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13747 = state_13697;
state_13697 = G__13747;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_13697){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_13697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___13731,out))
})();
var state__11073__auto__ = (function (){var statearr_13726 = f__11072__auto__.call(null);
(statearr_13726[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___13731);

return statearr_13726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___13731,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13748 = [];
var len__5726__auto___13822 = arguments.length;
var i__5727__auto___13823 = (0);
while(true){
if((i__5727__auto___13823 < len__5726__auto___13822)){
args13748.push((arguments[i__5727__auto___13823]));

var G__13824 = (i__5727__auto___13823 + (1));
i__5727__auto___13823 = G__13824;
continue;
} else {
}
break;
}

var G__13750 = args13748.length;
switch (G__13750) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13748.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11071__auto___13826 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11071__auto___13826,out){
return (function (){
var f__11072__auto__ = (function (){var switch__10959__auto__ = ((function (c__11071__auto___13826,out){
return (function (state_13792){
var state_val_13793 = (state_13792[(1)]);
if((state_val_13793 === (7))){
var inst_13788 = (state_13792[(2)]);
var state_13792__$1 = state_13792;
var statearr_13794_13827 = state_13792__$1;
(statearr_13794_13827[(2)] = inst_13788);

(statearr_13794_13827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (1))){
var inst_13751 = [];
var inst_13752 = inst_13751;
var inst_13753 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13792__$1 = (function (){var statearr_13795 = state_13792;
(statearr_13795[(7)] = inst_13753);

(statearr_13795[(8)] = inst_13752);

return statearr_13795;
})();
var statearr_13796_13828 = state_13792__$1;
(statearr_13796_13828[(2)] = null);

(statearr_13796_13828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (4))){
var inst_13756 = (state_13792[(9)]);
var inst_13756__$1 = (state_13792[(2)]);
var inst_13757 = (inst_13756__$1 == null);
var inst_13758 = cljs.core.not.call(null,inst_13757);
var state_13792__$1 = (function (){var statearr_13797 = state_13792;
(statearr_13797[(9)] = inst_13756__$1);

return statearr_13797;
})();
if(inst_13758){
var statearr_13798_13829 = state_13792__$1;
(statearr_13798_13829[(1)] = (5));

} else {
var statearr_13799_13830 = state_13792__$1;
(statearr_13799_13830[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (15))){
var inst_13782 = (state_13792[(2)]);
var state_13792__$1 = state_13792;
var statearr_13800_13831 = state_13792__$1;
(statearr_13800_13831[(2)] = inst_13782);

(statearr_13800_13831[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (13))){
var state_13792__$1 = state_13792;
var statearr_13801_13832 = state_13792__$1;
(statearr_13801_13832[(2)] = null);

(statearr_13801_13832[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (6))){
var inst_13752 = (state_13792[(8)]);
var inst_13777 = inst_13752.length;
var inst_13778 = (inst_13777 > (0));
var state_13792__$1 = state_13792;
if(cljs.core.truth_(inst_13778)){
var statearr_13802_13833 = state_13792__$1;
(statearr_13802_13833[(1)] = (12));

} else {
var statearr_13803_13834 = state_13792__$1;
(statearr_13803_13834[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (3))){
var inst_13790 = (state_13792[(2)]);
var state_13792__$1 = state_13792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13792__$1,inst_13790);
} else {
if((state_val_13793 === (12))){
var inst_13752 = (state_13792[(8)]);
var inst_13780 = cljs.core.vec.call(null,inst_13752);
var state_13792__$1 = state_13792;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13792__$1,(15),out,inst_13780);
} else {
if((state_val_13793 === (2))){
var state_13792__$1 = state_13792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13792__$1,(4),ch);
} else {
if((state_val_13793 === (11))){
var inst_13760 = (state_13792[(10)]);
var inst_13756 = (state_13792[(9)]);
var inst_13770 = (state_13792[(2)]);
var inst_13771 = [];
var inst_13772 = inst_13771.push(inst_13756);
var inst_13752 = inst_13771;
var inst_13753 = inst_13760;
var state_13792__$1 = (function (){var statearr_13804 = state_13792;
(statearr_13804[(11)] = inst_13772);

(statearr_13804[(7)] = inst_13753);

(statearr_13804[(8)] = inst_13752);

(statearr_13804[(12)] = inst_13770);

return statearr_13804;
})();
var statearr_13805_13835 = state_13792__$1;
(statearr_13805_13835[(2)] = null);

(statearr_13805_13835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (9))){
var inst_13752 = (state_13792[(8)]);
var inst_13768 = cljs.core.vec.call(null,inst_13752);
var state_13792__$1 = state_13792;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13792__$1,(11),out,inst_13768);
} else {
if((state_val_13793 === (5))){
var inst_13760 = (state_13792[(10)]);
var inst_13753 = (state_13792[(7)]);
var inst_13756 = (state_13792[(9)]);
var inst_13760__$1 = f.call(null,inst_13756);
var inst_13761 = cljs.core._EQ_.call(null,inst_13760__$1,inst_13753);
var inst_13762 = cljs.core.keyword_identical_QMARK_.call(null,inst_13753,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13763 = (inst_13761) || (inst_13762);
var state_13792__$1 = (function (){var statearr_13806 = state_13792;
(statearr_13806[(10)] = inst_13760__$1);

return statearr_13806;
})();
if(cljs.core.truth_(inst_13763)){
var statearr_13807_13836 = state_13792__$1;
(statearr_13807_13836[(1)] = (8));

} else {
var statearr_13808_13837 = state_13792__$1;
(statearr_13808_13837[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (14))){
var inst_13785 = (state_13792[(2)]);
var inst_13786 = cljs.core.async.close_BANG_.call(null,out);
var state_13792__$1 = (function (){var statearr_13810 = state_13792;
(statearr_13810[(13)] = inst_13785);

return statearr_13810;
})();
var statearr_13811_13838 = state_13792__$1;
(statearr_13811_13838[(2)] = inst_13786);

(statearr_13811_13838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (10))){
var inst_13775 = (state_13792[(2)]);
var state_13792__$1 = state_13792;
var statearr_13812_13839 = state_13792__$1;
(statearr_13812_13839[(2)] = inst_13775);

(statearr_13812_13839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13793 === (8))){
var inst_13760 = (state_13792[(10)]);
var inst_13752 = (state_13792[(8)]);
var inst_13756 = (state_13792[(9)]);
var inst_13765 = inst_13752.push(inst_13756);
var tmp13809 = inst_13752;
var inst_13752__$1 = tmp13809;
var inst_13753 = inst_13760;
var state_13792__$1 = (function (){var statearr_13813 = state_13792;
(statearr_13813[(14)] = inst_13765);

(statearr_13813[(7)] = inst_13753);

(statearr_13813[(8)] = inst_13752__$1);

return statearr_13813;
})();
var statearr_13814_13840 = state_13792__$1;
(statearr_13814_13840[(2)] = null);

(statearr_13814_13840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11071__auto___13826,out))
;
return ((function (switch__10959__auto__,c__11071__auto___13826,out){
return (function() {
var cljs$core$async$state_machine__10960__auto__ = null;
var cljs$core$async$state_machine__10960__auto____0 = (function (){
var statearr_13818 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13818[(0)] = cljs$core$async$state_machine__10960__auto__);

(statearr_13818[(1)] = (1));

return statearr_13818;
});
var cljs$core$async$state_machine__10960__auto____1 = (function (state_13792){
while(true){
var ret_value__10961__auto__ = (function (){try{while(true){
var result__10962__auto__ = switch__10959__auto__.call(null,state_13792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10962__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10962__auto__;
}
break;
}
}catch (e13819){if((e13819 instanceof Object)){
var ex__10963__auto__ = e13819;
var statearr_13820_13841 = state_13792;
(statearr_13820_13841[(5)] = ex__10963__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13792);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13819;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10961__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13842 = state_13792;
state_13792 = G__13842;
continue;
} else {
return ret_value__10961__auto__;
}
break;
}
});
cljs$core$async$state_machine__10960__auto__ = function(state_13792){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10960__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10960__auto____1.call(this,state_13792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10960__auto____0;
cljs$core$async$state_machine__10960__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10960__auto____1;
return cljs$core$async$state_machine__10960__auto__;
})()
;})(switch__10959__auto__,c__11071__auto___13826,out))
})();
var state__11073__auto__ = (function (){var statearr_13821 = f__11072__auto__.call(null);
(statearr_13821[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11071__auto___13826);

return statearr_13821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11073__auto__);
});})(c__11071__auto___13826,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1460640711266