// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18995 = [];
var len__5726__auto___19001 = arguments.length;
var i__5727__auto___19002 = (0);
while(true){
if((i__5727__auto___19002 < len__5726__auto___19001)){
args18995.push((arguments[i__5727__auto___19002]));

var G__19003 = (i__5727__auto___19002 + (1));
i__5727__auto___19002 = G__19003;
continue;
} else {
}
break;
}

var G__18997 = args18995.length;
switch (G__18997) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18995.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18998 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18998 = (function (f,blockable,meta18999){
this.f = f;
this.blockable = blockable;
this.meta18999 = meta18999;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18998.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19000,meta18999__$1){
var self__ = this;
var _19000__$1 = this;
return (new cljs.core.async.t_cljs$core$async18998(self__.f,self__.blockable,meta18999__$1));
});

cljs.core.async.t_cljs$core$async18998.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19000){
var self__ = this;
var _19000__$1 = this;
return self__.meta18999;
});

cljs.core.async.t_cljs$core$async18998.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18998.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18998.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18998.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18998.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18999","meta18999",-576700908,null)], null);
});

cljs.core.async.t_cljs$core$async18998.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18998.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18998";

cljs.core.async.t_cljs$core$async18998.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18998");
});

cljs.core.async.__GT_t_cljs$core$async18998 = (function cljs$core$async$__GT_t_cljs$core$async18998(f__$1,blockable__$1,meta18999){
return (new cljs.core.async.t_cljs$core$async18998(f__$1,blockable__$1,meta18999));
});

}

return (new cljs.core.async.t_cljs$core$async18998(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args19007 = [];
var len__5726__auto___19010 = arguments.length;
var i__5727__auto___19011 = (0);
while(true){
if((i__5727__auto___19011 < len__5726__auto___19010)){
args19007.push((arguments[i__5727__auto___19011]));

var G__19012 = (i__5727__auto___19011 + (1));
i__5727__auto___19011 = G__19012;
continue;
} else {
}
break;
}

var G__19009 = args19007.length;
switch (G__19009) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19007.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args19014 = [];
var len__5726__auto___19017 = arguments.length;
var i__5727__auto___19018 = (0);
while(true){
if((i__5727__auto___19018 < len__5726__auto___19017)){
args19014.push((arguments[i__5727__auto___19018]));

var G__19019 = (i__5727__auto___19018 + (1));
i__5727__auto___19018 = G__19019;
continue;
} else {
}
break;
}

var G__19016 = args19014.length;
switch (G__19016) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19014.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args19021 = [];
var len__5726__auto___19024 = arguments.length;
var i__5727__auto___19025 = (0);
while(true){
if((i__5727__auto___19025 < len__5726__auto___19024)){
args19021.push((arguments[i__5727__auto___19025]));

var G__19026 = (i__5727__auto___19025 + (1));
i__5727__auto___19025 = G__19026;
continue;
} else {
}
break;
}

var G__19023 = args19021.length;
switch (G__19023) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19021.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_19028 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_19028);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_19028,ret){
return (function (){
return fn1.call(null,val_19028);
});})(val_19028,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args19029 = [];
var len__5726__auto___19032 = arguments.length;
var i__5727__auto___19033 = (0);
while(true){
if((i__5727__auto___19033 < len__5726__auto___19032)){
args19029.push((arguments[i__5727__auto___19033]));

var G__19034 = (i__5727__auto___19033 + (1));
i__5727__auto___19033 = G__19034;
continue;
} else {
}
break;
}

var G__19031 = args19029.length;
switch (G__19031) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19029.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___19036 = n;
var x_19037 = (0);
while(true){
if((x_19037 < n__5571__auto___19036)){
(a[x_19037] = (0));

var G__19038 = (x_19037 + (1));
x_19037 = G__19038;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__19039 = (i + (1));
i = G__19039;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async19043 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19043 = (function (alt_flag,flag,meta19044){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta19044 = meta19044;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19043.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_19045,meta19044__$1){
var self__ = this;
var _19045__$1 = this;
return (new cljs.core.async.t_cljs$core$async19043(self__.alt_flag,self__.flag,meta19044__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async19043.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_19045){
var self__ = this;
var _19045__$1 = this;
return self__.meta19044;
});})(flag))
;

cljs.core.async.t_cljs$core$async19043.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19043.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async19043.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19043.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async19043.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta19044","meta19044",-2046982480,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async19043.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19043.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19043";

cljs.core.async.t_cljs$core$async19043.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19043");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async19043 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async19043(alt_flag__$1,flag__$1,meta19044){
return (new cljs.core.async.t_cljs$core$async19043(alt_flag__$1,flag__$1,meta19044));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async19043(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async19049 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19049 = (function (alt_handler,flag,cb,meta19050){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta19050 = meta19050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19051,meta19050__$1){
var self__ = this;
var _19051__$1 = this;
return (new cljs.core.async.t_cljs$core$async19049(self__.alt_handler,self__.flag,self__.cb,meta19050__$1));
});

cljs.core.async.t_cljs$core$async19049.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19051){
var self__ = this;
var _19051__$1 = this;
return self__.meta19050;
});

cljs.core.async.t_cljs$core$async19049.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19049.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async19049.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async19049.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async19049.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta19050","meta19050",-216624238,null)], null);
});

cljs.core.async.t_cljs$core$async19049.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19049.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19049";

cljs.core.async.t_cljs$core$async19049.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19049");
});

cljs.core.async.__GT_t_cljs$core$async19049 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async19049(alt_handler__$1,flag__$1,cb__$1,meta19050){
return (new cljs.core.async.t_cljs$core$async19049(alt_handler__$1,flag__$1,cb__$1,meta19050));
});

}

return (new cljs.core.async.t_cljs$core$async19049(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19052_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19052_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__19053_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19053_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__19054 = (i + (1));
i = G__19054;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___19060 = arguments.length;
var i__5727__auto___19061 = (0);
while(true){
if((i__5727__auto___19061 < len__5726__auto___19060)){
args__5733__auto__.push((arguments[i__5727__auto___19061]));

var G__19062 = (i__5727__auto___19061 + (1));
i__5727__auto___19061 = G__19062;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__19057){
var map__19058 = p__19057;
var map__19058__$1 = ((((!((map__19058 == null)))?((((map__19058.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19058.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19058):map__19058);
var opts = map__19058__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq19055){
var G__19056 = cljs.core.first.call(null,seq19055);
var seq19055__$1 = cljs.core.next.call(null,seq19055);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19056,seq19055__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args19063 = [];
var len__5726__auto___19113 = arguments.length;
var i__5727__auto___19114 = (0);
while(true){
if((i__5727__auto___19114 < len__5726__auto___19113)){
args19063.push((arguments[i__5727__auto___19114]));

var G__19115 = (i__5727__auto___19114 + (1));
i__5727__auto___19114 = G__19115;
continue;
} else {
}
break;
}

var G__19065 = args19063.length;
switch (G__19065) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19063.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11094__auto___19117 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___19117){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___19117){
return (function (state_19089){
var state_val_19090 = (state_19089[(1)]);
if((state_val_19090 === (7))){
var inst_19085 = (state_19089[(2)]);
var state_19089__$1 = state_19089;
var statearr_19091_19118 = state_19089__$1;
(statearr_19091_19118[(2)] = inst_19085);

(statearr_19091_19118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (1))){
var state_19089__$1 = state_19089;
var statearr_19092_19119 = state_19089__$1;
(statearr_19092_19119[(2)] = null);

(statearr_19092_19119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (4))){
var inst_19068 = (state_19089[(7)]);
var inst_19068__$1 = (state_19089[(2)]);
var inst_19069 = (inst_19068__$1 == null);
var state_19089__$1 = (function (){var statearr_19093 = state_19089;
(statearr_19093[(7)] = inst_19068__$1);

return statearr_19093;
})();
if(cljs.core.truth_(inst_19069)){
var statearr_19094_19120 = state_19089__$1;
(statearr_19094_19120[(1)] = (5));

} else {
var statearr_19095_19121 = state_19089__$1;
(statearr_19095_19121[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (13))){
var state_19089__$1 = state_19089;
var statearr_19096_19122 = state_19089__$1;
(statearr_19096_19122[(2)] = null);

(statearr_19096_19122[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (6))){
var inst_19068 = (state_19089[(7)]);
var state_19089__$1 = state_19089;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19089__$1,(11),to,inst_19068);
} else {
if((state_val_19090 === (3))){
var inst_19087 = (state_19089[(2)]);
var state_19089__$1 = state_19089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19089__$1,inst_19087);
} else {
if((state_val_19090 === (12))){
var state_19089__$1 = state_19089;
var statearr_19097_19123 = state_19089__$1;
(statearr_19097_19123[(2)] = null);

(statearr_19097_19123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (2))){
var state_19089__$1 = state_19089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19089__$1,(4),from);
} else {
if((state_val_19090 === (11))){
var inst_19078 = (state_19089[(2)]);
var state_19089__$1 = state_19089;
if(cljs.core.truth_(inst_19078)){
var statearr_19098_19124 = state_19089__$1;
(statearr_19098_19124[(1)] = (12));

} else {
var statearr_19099_19125 = state_19089__$1;
(statearr_19099_19125[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (9))){
var state_19089__$1 = state_19089;
var statearr_19100_19126 = state_19089__$1;
(statearr_19100_19126[(2)] = null);

(statearr_19100_19126[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (5))){
var state_19089__$1 = state_19089;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19101_19127 = state_19089__$1;
(statearr_19101_19127[(1)] = (8));

} else {
var statearr_19102_19128 = state_19089__$1;
(statearr_19102_19128[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (14))){
var inst_19083 = (state_19089[(2)]);
var state_19089__$1 = state_19089;
var statearr_19103_19129 = state_19089__$1;
(statearr_19103_19129[(2)] = inst_19083);

(statearr_19103_19129[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (10))){
var inst_19075 = (state_19089[(2)]);
var state_19089__$1 = state_19089;
var statearr_19104_19130 = state_19089__$1;
(statearr_19104_19130[(2)] = inst_19075);

(statearr_19104_19130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19090 === (8))){
var inst_19072 = cljs.core.async.close_BANG_.call(null,to);
var state_19089__$1 = state_19089;
var statearr_19105_19131 = state_19089__$1;
(statearr_19105_19131[(2)] = inst_19072);

(statearr_19105_19131[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___19117))
;
return ((function (switch__10982__auto__,c__11094__auto___19117){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_19109 = [null,null,null,null,null,null,null,null];
(statearr_19109[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_19109[(1)] = (1));

return statearr_19109;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_19089){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19110){if((e19110 instanceof Object)){
var ex__10986__auto__ = e19110;
var statearr_19111_19132 = state_19089;
(statearr_19111_19132[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19133 = state_19089;
state_19089 = G__19133;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_19089){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_19089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___19117))
})();
var state__11096__auto__ = (function (){var statearr_19112 = f__11095__auto__.call(null);
(statearr_19112[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___19117);

return statearr_19112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___19117))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19317){
var vec__19318 = p__19317;
var v = cljs.core.nth.call(null,vec__19318,(0),null);
var p = cljs.core.nth.call(null,vec__19318,(1),null);
var job = vec__19318;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11094__auto___19500 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___19500,res,vec__19318,v,p,job,jobs,results){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___19500,res,vec__19318,v,p,job,jobs,results){
return (function (state_19323){
var state_val_19324 = (state_19323[(1)]);
if((state_val_19324 === (1))){
var state_19323__$1 = state_19323;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19323__$1,(2),res,v);
} else {
if((state_val_19324 === (2))){
var inst_19320 = (state_19323[(2)]);
var inst_19321 = cljs.core.async.close_BANG_.call(null,res);
var state_19323__$1 = (function (){var statearr_19325 = state_19323;
(statearr_19325[(7)] = inst_19320);

return statearr_19325;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19323__$1,inst_19321);
} else {
return null;
}
}
});})(c__11094__auto___19500,res,vec__19318,v,p,job,jobs,results))
;
return ((function (switch__10982__auto__,c__11094__auto___19500,res,vec__19318,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_19329 = [null,null,null,null,null,null,null,null];
(statearr_19329[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_19329[(1)] = (1));

return statearr_19329;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_19323){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19330){if((e19330 instanceof Object)){
var ex__10986__auto__ = e19330;
var statearr_19331_19501 = state_19323;
(statearr_19331_19501[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19323);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19330;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19502 = state_19323;
state_19323 = G__19502;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_19323){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_19323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___19500,res,vec__19318,v,p,job,jobs,results))
})();
var state__11096__auto__ = (function (){var statearr_19332 = f__11095__auto__.call(null);
(statearr_19332[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___19500);

return statearr_19332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___19500,res,vec__19318,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19333){
var vec__19334 = p__19333;
var v = cljs.core.nth.call(null,vec__19334,(0),null);
var p = cljs.core.nth.call(null,vec__19334,(1),null);
var job = vec__19334;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___19503 = n;
var __19504 = (0);
while(true){
if((__19504 < n__5571__auto___19503)){
var G__19335_19505 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19335_19505) {
case "compute":
var c__11094__auto___19507 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19504,c__11094__auto___19507,G__19335_19505,n__5571__auto___19503,jobs,results,process,async){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (__19504,c__11094__auto___19507,G__19335_19505,n__5571__auto___19503,jobs,results,process,async){
return (function (state_19348){
var state_val_19349 = (state_19348[(1)]);
if((state_val_19349 === (1))){
var state_19348__$1 = state_19348;
var statearr_19350_19508 = state_19348__$1;
(statearr_19350_19508[(2)] = null);

(statearr_19350_19508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19349 === (2))){
var state_19348__$1 = state_19348;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19348__$1,(4),jobs);
} else {
if((state_val_19349 === (3))){
var inst_19346 = (state_19348[(2)]);
var state_19348__$1 = state_19348;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19348__$1,inst_19346);
} else {
if((state_val_19349 === (4))){
var inst_19338 = (state_19348[(2)]);
var inst_19339 = process.call(null,inst_19338);
var state_19348__$1 = state_19348;
if(cljs.core.truth_(inst_19339)){
var statearr_19351_19509 = state_19348__$1;
(statearr_19351_19509[(1)] = (5));

} else {
var statearr_19352_19510 = state_19348__$1;
(statearr_19352_19510[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19349 === (5))){
var state_19348__$1 = state_19348;
var statearr_19353_19511 = state_19348__$1;
(statearr_19353_19511[(2)] = null);

(statearr_19353_19511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19349 === (6))){
var state_19348__$1 = state_19348;
var statearr_19354_19512 = state_19348__$1;
(statearr_19354_19512[(2)] = null);

(statearr_19354_19512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19349 === (7))){
var inst_19344 = (state_19348[(2)]);
var state_19348__$1 = state_19348;
var statearr_19355_19513 = state_19348__$1;
(statearr_19355_19513[(2)] = inst_19344);

(statearr_19355_19513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19504,c__11094__auto___19507,G__19335_19505,n__5571__auto___19503,jobs,results,process,async))
;
return ((function (__19504,switch__10982__auto__,c__11094__auto___19507,G__19335_19505,n__5571__auto___19503,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_19359 = [null,null,null,null,null,null,null];
(statearr_19359[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_19359[(1)] = (1));

return statearr_19359;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_19348){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19348);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19360){if((e19360 instanceof Object)){
var ex__10986__auto__ = e19360;
var statearr_19361_19514 = state_19348;
(statearr_19361_19514[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19348);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19360;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19515 = state_19348;
state_19348 = G__19515;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_19348){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_19348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(__19504,switch__10982__auto__,c__11094__auto___19507,G__19335_19505,n__5571__auto___19503,jobs,results,process,async))
})();
var state__11096__auto__ = (function (){var statearr_19362 = f__11095__auto__.call(null);
(statearr_19362[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___19507);

return statearr_19362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(__19504,c__11094__auto___19507,G__19335_19505,n__5571__auto___19503,jobs,results,process,async))
);


break;
case "async":
var c__11094__auto___19516 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19504,c__11094__auto___19516,G__19335_19505,n__5571__auto___19503,jobs,results,process,async){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (__19504,c__11094__auto___19516,G__19335_19505,n__5571__auto___19503,jobs,results,process,async){
return (function (state_19375){
var state_val_19376 = (state_19375[(1)]);
if((state_val_19376 === (1))){
var state_19375__$1 = state_19375;
var statearr_19377_19517 = state_19375__$1;
(statearr_19377_19517[(2)] = null);

(statearr_19377_19517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19376 === (2))){
var state_19375__$1 = state_19375;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19375__$1,(4),jobs);
} else {
if((state_val_19376 === (3))){
var inst_19373 = (state_19375[(2)]);
var state_19375__$1 = state_19375;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19375__$1,inst_19373);
} else {
if((state_val_19376 === (4))){
var inst_19365 = (state_19375[(2)]);
var inst_19366 = async.call(null,inst_19365);
var state_19375__$1 = state_19375;
if(cljs.core.truth_(inst_19366)){
var statearr_19378_19518 = state_19375__$1;
(statearr_19378_19518[(1)] = (5));

} else {
var statearr_19379_19519 = state_19375__$1;
(statearr_19379_19519[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19376 === (5))){
var state_19375__$1 = state_19375;
var statearr_19380_19520 = state_19375__$1;
(statearr_19380_19520[(2)] = null);

(statearr_19380_19520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19376 === (6))){
var state_19375__$1 = state_19375;
var statearr_19381_19521 = state_19375__$1;
(statearr_19381_19521[(2)] = null);

(statearr_19381_19521[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19376 === (7))){
var inst_19371 = (state_19375[(2)]);
var state_19375__$1 = state_19375;
var statearr_19382_19522 = state_19375__$1;
(statearr_19382_19522[(2)] = inst_19371);

(statearr_19382_19522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19504,c__11094__auto___19516,G__19335_19505,n__5571__auto___19503,jobs,results,process,async))
;
return ((function (__19504,switch__10982__auto__,c__11094__auto___19516,G__19335_19505,n__5571__auto___19503,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_19386 = [null,null,null,null,null,null,null];
(statearr_19386[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_19386[(1)] = (1));

return statearr_19386;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_19375){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19375);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19387){if((e19387 instanceof Object)){
var ex__10986__auto__ = e19387;
var statearr_19388_19523 = state_19375;
(statearr_19388_19523[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19375);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19387;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19524 = state_19375;
state_19375 = G__19524;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_19375){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_19375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(__19504,switch__10982__auto__,c__11094__auto___19516,G__19335_19505,n__5571__auto___19503,jobs,results,process,async))
})();
var state__11096__auto__ = (function (){var statearr_19389 = f__11095__auto__.call(null);
(statearr_19389[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___19516);

return statearr_19389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(__19504,c__11094__auto___19516,G__19335_19505,n__5571__auto___19503,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19525 = (__19504 + (1));
__19504 = G__19525;
continue;
} else {
}
break;
}

var c__11094__auto___19526 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___19526,jobs,results,process,async){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___19526,jobs,results,process,async){
return (function (state_19411){
var state_val_19412 = (state_19411[(1)]);
if((state_val_19412 === (1))){
var state_19411__$1 = state_19411;
var statearr_19413_19527 = state_19411__$1;
(statearr_19413_19527[(2)] = null);

(statearr_19413_19527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (2))){
var state_19411__$1 = state_19411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19411__$1,(4),from);
} else {
if((state_val_19412 === (3))){
var inst_19409 = (state_19411[(2)]);
var state_19411__$1 = state_19411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19411__$1,inst_19409);
} else {
if((state_val_19412 === (4))){
var inst_19392 = (state_19411[(7)]);
var inst_19392__$1 = (state_19411[(2)]);
var inst_19393 = (inst_19392__$1 == null);
var state_19411__$1 = (function (){var statearr_19414 = state_19411;
(statearr_19414[(7)] = inst_19392__$1);

return statearr_19414;
})();
if(cljs.core.truth_(inst_19393)){
var statearr_19415_19528 = state_19411__$1;
(statearr_19415_19528[(1)] = (5));

} else {
var statearr_19416_19529 = state_19411__$1;
(statearr_19416_19529[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (5))){
var inst_19395 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19411__$1 = state_19411;
var statearr_19417_19530 = state_19411__$1;
(statearr_19417_19530[(2)] = inst_19395);

(statearr_19417_19530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (6))){
var inst_19392 = (state_19411[(7)]);
var inst_19397 = (state_19411[(8)]);
var inst_19397__$1 = cljs.core.async.chan.call(null,(1));
var inst_19398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19399 = [inst_19392,inst_19397__$1];
var inst_19400 = (new cljs.core.PersistentVector(null,2,(5),inst_19398,inst_19399,null));
var state_19411__$1 = (function (){var statearr_19418 = state_19411;
(statearr_19418[(8)] = inst_19397__$1);

return statearr_19418;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19411__$1,(8),jobs,inst_19400);
} else {
if((state_val_19412 === (7))){
var inst_19407 = (state_19411[(2)]);
var state_19411__$1 = state_19411;
var statearr_19419_19531 = state_19411__$1;
(statearr_19419_19531[(2)] = inst_19407);

(statearr_19419_19531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19412 === (8))){
var inst_19397 = (state_19411[(8)]);
var inst_19402 = (state_19411[(2)]);
var state_19411__$1 = (function (){var statearr_19420 = state_19411;
(statearr_19420[(9)] = inst_19402);

return statearr_19420;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19411__$1,(9),results,inst_19397);
} else {
if((state_val_19412 === (9))){
var inst_19404 = (state_19411[(2)]);
var state_19411__$1 = (function (){var statearr_19421 = state_19411;
(statearr_19421[(10)] = inst_19404);

return statearr_19421;
})();
var statearr_19422_19532 = state_19411__$1;
(statearr_19422_19532[(2)] = null);

(statearr_19422_19532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___19526,jobs,results,process,async))
;
return ((function (switch__10982__auto__,c__11094__auto___19526,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_19426 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19426[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_19426[(1)] = (1));

return statearr_19426;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_19411){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19427){if((e19427 instanceof Object)){
var ex__10986__auto__ = e19427;
var statearr_19428_19533 = state_19411;
(statearr_19428_19533[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19411);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19427;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19534 = state_19411;
state_19411 = G__19534;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_19411){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_19411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___19526,jobs,results,process,async))
})();
var state__11096__auto__ = (function (){var statearr_19429 = f__11095__auto__.call(null);
(statearr_19429[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___19526);

return statearr_19429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___19526,jobs,results,process,async))
);


var c__11094__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto__,jobs,results,process,async){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto__,jobs,results,process,async){
return (function (state_19467){
var state_val_19468 = (state_19467[(1)]);
if((state_val_19468 === (7))){
var inst_19463 = (state_19467[(2)]);
var state_19467__$1 = state_19467;
var statearr_19469_19535 = state_19467__$1;
(statearr_19469_19535[(2)] = inst_19463);

(statearr_19469_19535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (20))){
var state_19467__$1 = state_19467;
var statearr_19470_19536 = state_19467__$1;
(statearr_19470_19536[(2)] = null);

(statearr_19470_19536[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (1))){
var state_19467__$1 = state_19467;
var statearr_19471_19537 = state_19467__$1;
(statearr_19471_19537[(2)] = null);

(statearr_19471_19537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (4))){
var inst_19432 = (state_19467[(7)]);
var inst_19432__$1 = (state_19467[(2)]);
var inst_19433 = (inst_19432__$1 == null);
var state_19467__$1 = (function (){var statearr_19472 = state_19467;
(statearr_19472[(7)] = inst_19432__$1);

return statearr_19472;
})();
if(cljs.core.truth_(inst_19433)){
var statearr_19473_19538 = state_19467__$1;
(statearr_19473_19538[(1)] = (5));

} else {
var statearr_19474_19539 = state_19467__$1;
(statearr_19474_19539[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (15))){
var inst_19445 = (state_19467[(8)]);
var state_19467__$1 = state_19467;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19467__$1,(18),to,inst_19445);
} else {
if((state_val_19468 === (21))){
var inst_19458 = (state_19467[(2)]);
var state_19467__$1 = state_19467;
var statearr_19475_19540 = state_19467__$1;
(statearr_19475_19540[(2)] = inst_19458);

(statearr_19475_19540[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (13))){
var inst_19460 = (state_19467[(2)]);
var state_19467__$1 = (function (){var statearr_19476 = state_19467;
(statearr_19476[(9)] = inst_19460);

return statearr_19476;
})();
var statearr_19477_19541 = state_19467__$1;
(statearr_19477_19541[(2)] = null);

(statearr_19477_19541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (6))){
var inst_19432 = (state_19467[(7)]);
var state_19467__$1 = state_19467;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19467__$1,(11),inst_19432);
} else {
if((state_val_19468 === (17))){
var inst_19453 = (state_19467[(2)]);
var state_19467__$1 = state_19467;
if(cljs.core.truth_(inst_19453)){
var statearr_19478_19542 = state_19467__$1;
(statearr_19478_19542[(1)] = (19));

} else {
var statearr_19479_19543 = state_19467__$1;
(statearr_19479_19543[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (3))){
var inst_19465 = (state_19467[(2)]);
var state_19467__$1 = state_19467;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19467__$1,inst_19465);
} else {
if((state_val_19468 === (12))){
var inst_19442 = (state_19467[(10)]);
var state_19467__$1 = state_19467;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19467__$1,(14),inst_19442);
} else {
if((state_val_19468 === (2))){
var state_19467__$1 = state_19467;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19467__$1,(4),results);
} else {
if((state_val_19468 === (19))){
var state_19467__$1 = state_19467;
var statearr_19480_19544 = state_19467__$1;
(statearr_19480_19544[(2)] = null);

(statearr_19480_19544[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (11))){
var inst_19442 = (state_19467[(2)]);
var state_19467__$1 = (function (){var statearr_19481 = state_19467;
(statearr_19481[(10)] = inst_19442);

return statearr_19481;
})();
var statearr_19482_19545 = state_19467__$1;
(statearr_19482_19545[(2)] = null);

(statearr_19482_19545[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (9))){
var state_19467__$1 = state_19467;
var statearr_19483_19546 = state_19467__$1;
(statearr_19483_19546[(2)] = null);

(statearr_19483_19546[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (5))){
var state_19467__$1 = state_19467;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19484_19547 = state_19467__$1;
(statearr_19484_19547[(1)] = (8));

} else {
var statearr_19485_19548 = state_19467__$1;
(statearr_19485_19548[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (14))){
var inst_19447 = (state_19467[(11)]);
var inst_19445 = (state_19467[(8)]);
var inst_19445__$1 = (state_19467[(2)]);
var inst_19446 = (inst_19445__$1 == null);
var inst_19447__$1 = cljs.core.not.call(null,inst_19446);
var state_19467__$1 = (function (){var statearr_19486 = state_19467;
(statearr_19486[(11)] = inst_19447__$1);

(statearr_19486[(8)] = inst_19445__$1);

return statearr_19486;
})();
if(inst_19447__$1){
var statearr_19487_19549 = state_19467__$1;
(statearr_19487_19549[(1)] = (15));

} else {
var statearr_19488_19550 = state_19467__$1;
(statearr_19488_19550[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (16))){
var inst_19447 = (state_19467[(11)]);
var state_19467__$1 = state_19467;
var statearr_19489_19551 = state_19467__$1;
(statearr_19489_19551[(2)] = inst_19447);

(statearr_19489_19551[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (10))){
var inst_19439 = (state_19467[(2)]);
var state_19467__$1 = state_19467;
var statearr_19490_19552 = state_19467__$1;
(statearr_19490_19552[(2)] = inst_19439);

(statearr_19490_19552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (18))){
var inst_19450 = (state_19467[(2)]);
var state_19467__$1 = state_19467;
var statearr_19491_19553 = state_19467__$1;
(statearr_19491_19553[(2)] = inst_19450);

(statearr_19491_19553[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19468 === (8))){
var inst_19436 = cljs.core.async.close_BANG_.call(null,to);
var state_19467__$1 = state_19467;
var statearr_19492_19554 = state_19467__$1;
(statearr_19492_19554[(2)] = inst_19436);

(statearr_19492_19554[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto__,jobs,results,process,async))
;
return ((function (switch__10982__auto__,c__11094__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_19496 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19496[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__);

(statearr_19496[(1)] = (1));

return statearr_19496;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1 = (function (state_19467){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19467);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19497){if((e19497 instanceof Object)){
var ex__10986__auto__ = e19497;
var statearr_19498_19555 = state_19467;
(statearr_19498_19555[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19467);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19497;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19556 = state_19467;
state_19467 = G__19556;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__ = function(state_19467){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1.call(this,state_19467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto__,jobs,results,process,async))
})();
var state__11096__auto__ = (function (){var statearr_19499 = f__11095__auto__.call(null);
(statearr_19499[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto__);

return statearr_19499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto__,jobs,results,process,async))
);

return c__11094__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19557 = [];
var len__5726__auto___19560 = arguments.length;
var i__5727__auto___19561 = (0);
while(true){
if((i__5727__auto___19561 < len__5726__auto___19560)){
args19557.push((arguments[i__5727__auto___19561]));

var G__19562 = (i__5727__auto___19561 + (1));
i__5727__auto___19561 = G__19562;
continue;
} else {
}
break;
}

var G__19559 = args19557.length;
switch (G__19559) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19557.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19564 = [];
var len__5726__auto___19567 = arguments.length;
var i__5727__auto___19568 = (0);
while(true){
if((i__5727__auto___19568 < len__5726__auto___19567)){
args19564.push((arguments[i__5727__auto___19568]));

var G__19569 = (i__5727__auto___19568 + (1));
i__5727__auto___19568 = G__19569;
continue;
} else {
}
break;
}

var G__19566 = args19564.length;
switch (G__19566) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19564.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19571 = [];
var len__5726__auto___19624 = arguments.length;
var i__5727__auto___19625 = (0);
while(true){
if((i__5727__auto___19625 < len__5726__auto___19624)){
args19571.push((arguments[i__5727__auto___19625]));

var G__19626 = (i__5727__auto___19625 + (1));
i__5727__auto___19625 = G__19626;
continue;
} else {
}
break;
}

var G__19573 = args19571.length;
switch (G__19573) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19571.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11094__auto___19628 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___19628,tc,fc){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___19628,tc,fc){
return (function (state_19599){
var state_val_19600 = (state_19599[(1)]);
if((state_val_19600 === (7))){
var inst_19595 = (state_19599[(2)]);
var state_19599__$1 = state_19599;
var statearr_19601_19629 = state_19599__$1;
(statearr_19601_19629[(2)] = inst_19595);

(statearr_19601_19629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (1))){
var state_19599__$1 = state_19599;
var statearr_19602_19630 = state_19599__$1;
(statearr_19602_19630[(2)] = null);

(statearr_19602_19630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (4))){
var inst_19576 = (state_19599[(7)]);
var inst_19576__$1 = (state_19599[(2)]);
var inst_19577 = (inst_19576__$1 == null);
var state_19599__$1 = (function (){var statearr_19603 = state_19599;
(statearr_19603[(7)] = inst_19576__$1);

return statearr_19603;
})();
if(cljs.core.truth_(inst_19577)){
var statearr_19604_19631 = state_19599__$1;
(statearr_19604_19631[(1)] = (5));

} else {
var statearr_19605_19632 = state_19599__$1;
(statearr_19605_19632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (13))){
var state_19599__$1 = state_19599;
var statearr_19606_19633 = state_19599__$1;
(statearr_19606_19633[(2)] = null);

(statearr_19606_19633[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (6))){
var inst_19576 = (state_19599[(7)]);
var inst_19582 = p.call(null,inst_19576);
var state_19599__$1 = state_19599;
if(cljs.core.truth_(inst_19582)){
var statearr_19607_19634 = state_19599__$1;
(statearr_19607_19634[(1)] = (9));

} else {
var statearr_19608_19635 = state_19599__$1;
(statearr_19608_19635[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (3))){
var inst_19597 = (state_19599[(2)]);
var state_19599__$1 = state_19599;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19599__$1,inst_19597);
} else {
if((state_val_19600 === (12))){
var state_19599__$1 = state_19599;
var statearr_19609_19636 = state_19599__$1;
(statearr_19609_19636[(2)] = null);

(statearr_19609_19636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (2))){
var state_19599__$1 = state_19599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19599__$1,(4),ch);
} else {
if((state_val_19600 === (11))){
var inst_19576 = (state_19599[(7)]);
var inst_19586 = (state_19599[(2)]);
var state_19599__$1 = state_19599;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19599__$1,(8),inst_19586,inst_19576);
} else {
if((state_val_19600 === (9))){
var state_19599__$1 = state_19599;
var statearr_19610_19637 = state_19599__$1;
(statearr_19610_19637[(2)] = tc);

(statearr_19610_19637[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (5))){
var inst_19579 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19580 = cljs.core.async.close_BANG_.call(null,fc);
var state_19599__$1 = (function (){var statearr_19611 = state_19599;
(statearr_19611[(8)] = inst_19579);

return statearr_19611;
})();
var statearr_19612_19638 = state_19599__$1;
(statearr_19612_19638[(2)] = inst_19580);

(statearr_19612_19638[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (14))){
var inst_19593 = (state_19599[(2)]);
var state_19599__$1 = state_19599;
var statearr_19613_19639 = state_19599__$1;
(statearr_19613_19639[(2)] = inst_19593);

(statearr_19613_19639[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (10))){
var state_19599__$1 = state_19599;
var statearr_19614_19640 = state_19599__$1;
(statearr_19614_19640[(2)] = fc);

(statearr_19614_19640[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19600 === (8))){
var inst_19588 = (state_19599[(2)]);
var state_19599__$1 = state_19599;
if(cljs.core.truth_(inst_19588)){
var statearr_19615_19641 = state_19599__$1;
(statearr_19615_19641[(1)] = (12));

} else {
var statearr_19616_19642 = state_19599__$1;
(statearr_19616_19642[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___19628,tc,fc))
;
return ((function (switch__10982__auto__,c__11094__auto___19628,tc,fc){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_19620 = [null,null,null,null,null,null,null,null,null];
(statearr_19620[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_19620[(1)] = (1));

return statearr_19620;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_19599){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19621){if((e19621 instanceof Object)){
var ex__10986__auto__ = e19621;
var statearr_19622_19643 = state_19599;
(statearr_19622_19643[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19599);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19621;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19644 = state_19599;
state_19599 = G__19644;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_19599){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_19599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___19628,tc,fc))
})();
var state__11096__auto__ = (function (){var statearr_19623 = f__11095__auto__.call(null);
(statearr_19623[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___19628);

return statearr_19623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___19628,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11094__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto__){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto__){
return (function (state_19708){
var state_val_19709 = (state_19708[(1)]);
if((state_val_19709 === (7))){
var inst_19704 = (state_19708[(2)]);
var state_19708__$1 = state_19708;
var statearr_19710_19731 = state_19708__$1;
(statearr_19710_19731[(2)] = inst_19704);

(statearr_19710_19731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19709 === (1))){
var inst_19688 = init;
var state_19708__$1 = (function (){var statearr_19711 = state_19708;
(statearr_19711[(7)] = inst_19688);

return statearr_19711;
})();
var statearr_19712_19732 = state_19708__$1;
(statearr_19712_19732[(2)] = null);

(statearr_19712_19732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19709 === (4))){
var inst_19691 = (state_19708[(8)]);
var inst_19691__$1 = (state_19708[(2)]);
var inst_19692 = (inst_19691__$1 == null);
var state_19708__$1 = (function (){var statearr_19713 = state_19708;
(statearr_19713[(8)] = inst_19691__$1);

return statearr_19713;
})();
if(cljs.core.truth_(inst_19692)){
var statearr_19714_19733 = state_19708__$1;
(statearr_19714_19733[(1)] = (5));

} else {
var statearr_19715_19734 = state_19708__$1;
(statearr_19715_19734[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19709 === (6))){
var inst_19688 = (state_19708[(7)]);
var inst_19695 = (state_19708[(9)]);
var inst_19691 = (state_19708[(8)]);
var inst_19695__$1 = f.call(null,inst_19688,inst_19691);
var inst_19696 = cljs.core.reduced_QMARK_.call(null,inst_19695__$1);
var state_19708__$1 = (function (){var statearr_19716 = state_19708;
(statearr_19716[(9)] = inst_19695__$1);

return statearr_19716;
})();
if(inst_19696){
var statearr_19717_19735 = state_19708__$1;
(statearr_19717_19735[(1)] = (8));

} else {
var statearr_19718_19736 = state_19708__$1;
(statearr_19718_19736[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19709 === (3))){
var inst_19706 = (state_19708[(2)]);
var state_19708__$1 = state_19708;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19708__$1,inst_19706);
} else {
if((state_val_19709 === (2))){
var state_19708__$1 = state_19708;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19708__$1,(4),ch);
} else {
if((state_val_19709 === (9))){
var inst_19695 = (state_19708[(9)]);
var inst_19688 = inst_19695;
var state_19708__$1 = (function (){var statearr_19719 = state_19708;
(statearr_19719[(7)] = inst_19688);

return statearr_19719;
})();
var statearr_19720_19737 = state_19708__$1;
(statearr_19720_19737[(2)] = null);

(statearr_19720_19737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19709 === (5))){
var inst_19688 = (state_19708[(7)]);
var state_19708__$1 = state_19708;
var statearr_19721_19738 = state_19708__$1;
(statearr_19721_19738[(2)] = inst_19688);

(statearr_19721_19738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19709 === (10))){
var inst_19702 = (state_19708[(2)]);
var state_19708__$1 = state_19708;
var statearr_19722_19739 = state_19708__$1;
(statearr_19722_19739[(2)] = inst_19702);

(statearr_19722_19739[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19709 === (8))){
var inst_19695 = (state_19708[(9)]);
var inst_19698 = cljs.core.deref.call(null,inst_19695);
var state_19708__$1 = state_19708;
var statearr_19723_19740 = state_19708__$1;
(statearr_19723_19740[(2)] = inst_19698);

(statearr_19723_19740[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto__))
;
return ((function (switch__10982__auto__,c__11094__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10983__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10983__auto____0 = (function (){
var statearr_19727 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19727[(0)] = cljs$core$async$reduce_$_state_machine__10983__auto__);

(statearr_19727[(1)] = (1));

return statearr_19727;
});
var cljs$core$async$reduce_$_state_machine__10983__auto____1 = (function (state_19708){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19708);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19728){if((e19728 instanceof Object)){
var ex__10986__auto__ = e19728;
var statearr_19729_19741 = state_19708;
(statearr_19729_19741[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19708);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19728;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19742 = state_19708;
state_19708 = G__19742;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10983__auto__ = function(state_19708){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10983__auto____1.call(this,state_19708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10983__auto____0;
cljs$core$async$reduce_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10983__auto____1;
return cljs$core$async$reduce_$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto__))
})();
var state__11096__auto__ = (function (){var statearr_19730 = f__11095__auto__.call(null);
(statearr_19730[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto__);

return statearr_19730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto__))
);

return c__11094__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19743 = [];
var len__5726__auto___19795 = arguments.length;
var i__5727__auto___19796 = (0);
while(true){
if((i__5727__auto___19796 < len__5726__auto___19795)){
args19743.push((arguments[i__5727__auto___19796]));

var G__19797 = (i__5727__auto___19796 + (1));
i__5727__auto___19796 = G__19797;
continue;
} else {
}
break;
}

var G__19745 = args19743.length;
switch (G__19745) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19743.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11094__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto__){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto__){
return (function (state_19770){
var state_val_19771 = (state_19770[(1)]);
if((state_val_19771 === (7))){
var inst_19752 = (state_19770[(2)]);
var state_19770__$1 = state_19770;
var statearr_19772_19799 = state_19770__$1;
(statearr_19772_19799[(2)] = inst_19752);

(statearr_19772_19799[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (1))){
var inst_19746 = cljs.core.seq.call(null,coll);
var inst_19747 = inst_19746;
var state_19770__$1 = (function (){var statearr_19773 = state_19770;
(statearr_19773[(7)] = inst_19747);

return statearr_19773;
})();
var statearr_19774_19800 = state_19770__$1;
(statearr_19774_19800[(2)] = null);

(statearr_19774_19800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (4))){
var inst_19747 = (state_19770[(7)]);
var inst_19750 = cljs.core.first.call(null,inst_19747);
var state_19770__$1 = state_19770;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19770__$1,(7),ch,inst_19750);
} else {
if((state_val_19771 === (13))){
var inst_19764 = (state_19770[(2)]);
var state_19770__$1 = state_19770;
var statearr_19775_19801 = state_19770__$1;
(statearr_19775_19801[(2)] = inst_19764);

(statearr_19775_19801[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (6))){
var inst_19755 = (state_19770[(2)]);
var state_19770__$1 = state_19770;
if(cljs.core.truth_(inst_19755)){
var statearr_19776_19802 = state_19770__$1;
(statearr_19776_19802[(1)] = (8));

} else {
var statearr_19777_19803 = state_19770__$1;
(statearr_19777_19803[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (3))){
var inst_19768 = (state_19770[(2)]);
var state_19770__$1 = state_19770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19770__$1,inst_19768);
} else {
if((state_val_19771 === (12))){
var state_19770__$1 = state_19770;
var statearr_19778_19804 = state_19770__$1;
(statearr_19778_19804[(2)] = null);

(statearr_19778_19804[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (2))){
var inst_19747 = (state_19770[(7)]);
var state_19770__$1 = state_19770;
if(cljs.core.truth_(inst_19747)){
var statearr_19779_19805 = state_19770__$1;
(statearr_19779_19805[(1)] = (4));

} else {
var statearr_19780_19806 = state_19770__$1;
(statearr_19780_19806[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (11))){
var inst_19761 = cljs.core.async.close_BANG_.call(null,ch);
var state_19770__$1 = state_19770;
var statearr_19781_19807 = state_19770__$1;
(statearr_19781_19807[(2)] = inst_19761);

(statearr_19781_19807[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (9))){
var state_19770__$1 = state_19770;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19782_19808 = state_19770__$1;
(statearr_19782_19808[(1)] = (11));

} else {
var statearr_19783_19809 = state_19770__$1;
(statearr_19783_19809[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (5))){
var inst_19747 = (state_19770[(7)]);
var state_19770__$1 = state_19770;
var statearr_19784_19810 = state_19770__$1;
(statearr_19784_19810[(2)] = inst_19747);

(statearr_19784_19810[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (10))){
var inst_19766 = (state_19770[(2)]);
var state_19770__$1 = state_19770;
var statearr_19785_19811 = state_19770__$1;
(statearr_19785_19811[(2)] = inst_19766);

(statearr_19785_19811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19771 === (8))){
var inst_19747 = (state_19770[(7)]);
var inst_19757 = cljs.core.next.call(null,inst_19747);
var inst_19747__$1 = inst_19757;
var state_19770__$1 = (function (){var statearr_19786 = state_19770;
(statearr_19786[(7)] = inst_19747__$1);

return statearr_19786;
})();
var statearr_19787_19812 = state_19770__$1;
(statearr_19787_19812[(2)] = null);

(statearr_19787_19812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto__))
;
return ((function (switch__10982__auto__,c__11094__auto__){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_19791 = [null,null,null,null,null,null,null,null];
(statearr_19791[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_19791[(1)] = (1));

return statearr_19791;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_19770){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_19770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e19792){if((e19792 instanceof Object)){
var ex__10986__auto__ = e19792;
var statearr_19793_19813 = state_19770;
(statearr_19793_19813[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19792;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19814 = state_19770;
state_19770 = G__19814;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_19770){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_19770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto__))
})();
var state__11096__auto__ = (function (){var statearr_19794 = f__11095__auto__.call(null);
(statearr_19794[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto__);

return statearr_19794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto__))
);

return c__11094__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20036 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20036 = (function (mult,ch,cs,meta20037){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta20037 = meta20037;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20036.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_20038,meta20037__$1){
var self__ = this;
var _20038__$1 = this;
return (new cljs.core.async.t_cljs$core$async20036(self__.mult,self__.ch,self__.cs,meta20037__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async20036.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_20038){
var self__ = this;
var _20038__$1 = this;
return self__.meta20037;
});})(cs))
;

cljs.core.async.t_cljs$core$async20036.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20036.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async20036.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async20036.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20036.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20036.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async20036.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta20037","meta20037",-1101615670,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async20036.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20036.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20036";

cljs.core.async.t_cljs$core$async20036.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20036");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async20036 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async20036(mult__$1,ch__$1,cs__$1,meta20037){
return (new cljs.core.async.t_cljs$core$async20036(mult__$1,ch__$1,cs__$1,meta20037));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async20036(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11094__auto___20257 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___20257,cs,m,dchan,dctr,done){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___20257,cs,m,dchan,dctr,done){
return (function (state_20169){
var state_val_20170 = (state_20169[(1)]);
if((state_val_20170 === (7))){
var inst_20165 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20171_20258 = state_20169__$1;
(statearr_20171_20258[(2)] = inst_20165);

(statearr_20171_20258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (20))){
var inst_20070 = (state_20169[(7)]);
var inst_20080 = cljs.core.first.call(null,inst_20070);
var inst_20081 = cljs.core.nth.call(null,inst_20080,(0),null);
var inst_20082 = cljs.core.nth.call(null,inst_20080,(1),null);
var state_20169__$1 = (function (){var statearr_20172 = state_20169;
(statearr_20172[(8)] = inst_20081);

return statearr_20172;
})();
if(cljs.core.truth_(inst_20082)){
var statearr_20173_20259 = state_20169__$1;
(statearr_20173_20259[(1)] = (22));

} else {
var statearr_20174_20260 = state_20169__$1;
(statearr_20174_20260[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (27))){
var inst_20112 = (state_20169[(9)]);
var inst_20110 = (state_20169[(10)]);
var inst_20041 = (state_20169[(11)]);
var inst_20117 = (state_20169[(12)]);
var inst_20117__$1 = cljs.core._nth.call(null,inst_20110,inst_20112);
var inst_20118 = cljs.core.async.put_BANG_.call(null,inst_20117__$1,inst_20041,done);
var state_20169__$1 = (function (){var statearr_20175 = state_20169;
(statearr_20175[(12)] = inst_20117__$1);

return statearr_20175;
})();
if(cljs.core.truth_(inst_20118)){
var statearr_20176_20261 = state_20169__$1;
(statearr_20176_20261[(1)] = (30));

} else {
var statearr_20177_20262 = state_20169__$1;
(statearr_20177_20262[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (1))){
var state_20169__$1 = state_20169;
var statearr_20178_20263 = state_20169__$1;
(statearr_20178_20263[(2)] = null);

(statearr_20178_20263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (24))){
var inst_20070 = (state_20169[(7)]);
var inst_20087 = (state_20169[(2)]);
var inst_20088 = cljs.core.next.call(null,inst_20070);
var inst_20050 = inst_20088;
var inst_20051 = null;
var inst_20052 = (0);
var inst_20053 = (0);
var state_20169__$1 = (function (){var statearr_20179 = state_20169;
(statearr_20179[(13)] = inst_20051);

(statearr_20179[(14)] = inst_20053);

(statearr_20179[(15)] = inst_20087);

(statearr_20179[(16)] = inst_20052);

(statearr_20179[(17)] = inst_20050);

return statearr_20179;
})();
var statearr_20180_20264 = state_20169__$1;
(statearr_20180_20264[(2)] = null);

(statearr_20180_20264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (39))){
var state_20169__$1 = state_20169;
var statearr_20184_20265 = state_20169__$1;
(statearr_20184_20265[(2)] = null);

(statearr_20184_20265[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (4))){
var inst_20041 = (state_20169[(11)]);
var inst_20041__$1 = (state_20169[(2)]);
var inst_20042 = (inst_20041__$1 == null);
var state_20169__$1 = (function (){var statearr_20185 = state_20169;
(statearr_20185[(11)] = inst_20041__$1);

return statearr_20185;
})();
if(cljs.core.truth_(inst_20042)){
var statearr_20186_20266 = state_20169__$1;
(statearr_20186_20266[(1)] = (5));

} else {
var statearr_20187_20267 = state_20169__$1;
(statearr_20187_20267[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (15))){
var inst_20051 = (state_20169[(13)]);
var inst_20053 = (state_20169[(14)]);
var inst_20052 = (state_20169[(16)]);
var inst_20050 = (state_20169[(17)]);
var inst_20066 = (state_20169[(2)]);
var inst_20067 = (inst_20053 + (1));
var tmp20181 = inst_20051;
var tmp20182 = inst_20052;
var tmp20183 = inst_20050;
var inst_20050__$1 = tmp20183;
var inst_20051__$1 = tmp20181;
var inst_20052__$1 = tmp20182;
var inst_20053__$1 = inst_20067;
var state_20169__$1 = (function (){var statearr_20188 = state_20169;
(statearr_20188[(18)] = inst_20066);

(statearr_20188[(13)] = inst_20051__$1);

(statearr_20188[(14)] = inst_20053__$1);

(statearr_20188[(16)] = inst_20052__$1);

(statearr_20188[(17)] = inst_20050__$1);

return statearr_20188;
})();
var statearr_20189_20268 = state_20169__$1;
(statearr_20189_20268[(2)] = null);

(statearr_20189_20268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (21))){
var inst_20091 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20193_20269 = state_20169__$1;
(statearr_20193_20269[(2)] = inst_20091);

(statearr_20193_20269[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (31))){
var inst_20117 = (state_20169[(12)]);
var inst_20121 = done.call(null,null);
var inst_20122 = cljs.core.async.untap_STAR_.call(null,m,inst_20117);
var state_20169__$1 = (function (){var statearr_20194 = state_20169;
(statearr_20194[(19)] = inst_20121);

return statearr_20194;
})();
var statearr_20195_20270 = state_20169__$1;
(statearr_20195_20270[(2)] = inst_20122);

(statearr_20195_20270[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (32))){
var inst_20111 = (state_20169[(20)]);
var inst_20112 = (state_20169[(9)]);
var inst_20110 = (state_20169[(10)]);
var inst_20109 = (state_20169[(21)]);
var inst_20124 = (state_20169[(2)]);
var inst_20125 = (inst_20112 + (1));
var tmp20190 = inst_20111;
var tmp20191 = inst_20110;
var tmp20192 = inst_20109;
var inst_20109__$1 = tmp20192;
var inst_20110__$1 = tmp20191;
var inst_20111__$1 = tmp20190;
var inst_20112__$1 = inst_20125;
var state_20169__$1 = (function (){var statearr_20196 = state_20169;
(statearr_20196[(20)] = inst_20111__$1);

(statearr_20196[(9)] = inst_20112__$1);

(statearr_20196[(10)] = inst_20110__$1);

(statearr_20196[(21)] = inst_20109__$1);

(statearr_20196[(22)] = inst_20124);

return statearr_20196;
})();
var statearr_20197_20271 = state_20169__$1;
(statearr_20197_20271[(2)] = null);

(statearr_20197_20271[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (40))){
var inst_20137 = (state_20169[(23)]);
var inst_20141 = done.call(null,null);
var inst_20142 = cljs.core.async.untap_STAR_.call(null,m,inst_20137);
var state_20169__$1 = (function (){var statearr_20198 = state_20169;
(statearr_20198[(24)] = inst_20141);

return statearr_20198;
})();
var statearr_20199_20272 = state_20169__$1;
(statearr_20199_20272[(2)] = inst_20142);

(statearr_20199_20272[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (33))){
var inst_20128 = (state_20169[(25)]);
var inst_20130 = cljs.core.chunked_seq_QMARK_.call(null,inst_20128);
var state_20169__$1 = state_20169;
if(inst_20130){
var statearr_20200_20273 = state_20169__$1;
(statearr_20200_20273[(1)] = (36));

} else {
var statearr_20201_20274 = state_20169__$1;
(statearr_20201_20274[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (13))){
var inst_20060 = (state_20169[(26)]);
var inst_20063 = cljs.core.async.close_BANG_.call(null,inst_20060);
var state_20169__$1 = state_20169;
var statearr_20202_20275 = state_20169__$1;
(statearr_20202_20275[(2)] = inst_20063);

(statearr_20202_20275[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (22))){
var inst_20081 = (state_20169[(8)]);
var inst_20084 = cljs.core.async.close_BANG_.call(null,inst_20081);
var state_20169__$1 = state_20169;
var statearr_20203_20276 = state_20169__$1;
(statearr_20203_20276[(2)] = inst_20084);

(statearr_20203_20276[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (36))){
var inst_20128 = (state_20169[(25)]);
var inst_20132 = cljs.core.chunk_first.call(null,inst_20128);
var inst_20133 = cljs.core.chunk_rest.call(null,inst_20128);
var inst_20134 = cljs.core.count.call(null,inst_20132);
var inst_20109 = inst_20133;
var inst_20110 = inst_20132;
var inst_20111 = inst_20134;
var inst_20112 = (0);
var state_20169__$1 = (function (){var statearr_20204 = state_20169;
(statearr_20204[(20)] = inst_20111);

(statearr_20204[(9)] = inst_20112);

(statearr_20204[(10)] = inst_20110);

(statearr_20204[(21)] = inst_20109);

return statearr_20204;
})();
var statearr_20205_20277 = state_20169__$1;
(statearr_20205_20277[(2)] = null);

(statearr_20205_20277[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (41))){
var inst_20128 = (state_20169[(25)]);
var inst_20144 = (state_20169[(2)]);
var inst_20145 = cljs.core.next.call(null,inst_20128);
var inst_20109 = inst_20145;
var inst_20110 = null;
var inst_20111 = (0);
var inst_20112 = (0);
var state_20169__$1 = (function (){var statearr_20206 = state_20169;
(statearr_20206[(20)] = inst_20111);

(statearr_20206[(9)] = inst_20112);

(statearr_20206[(10)] = inst_20110);

(statearr_20206[(21)] = inst_20109);

(statearr_20206[(27)] = inst_20144);

return statearr_20206;
})();
var statearr_20207_20278 = state_20169__$1;
(statearr_20207_20278[(2)] = null);

(statearr_20207_20278[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (43))){
var state_20169__$1 = state_20169;
var statearr_20208_20279 = state_20169__$1;
(statearr_20208_20279[(2)] = null);

(statearr_20208_20279[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (29))){
var inst_20153 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20209_20280 = state_20169__$1;
(statearr_20209_20280[(2)] = inst_20153);

(statearr_20209_20280[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (44))){
var inst_20162 = (state_20169[(2)]);
var state_20169__$1 = (function (){var statearr_20210 = state_20169;
(statearr_20210[(28)] = inst_20162);

return statearr_20210;
})();
var statearr_20211_20281 = state_20169__$1;
(statearr_20211_20281[(2)] = null);

(statearr_20211_20281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (6))){
var inst_20101 = (state_20169[(29)]);
var inst_20100 = cljs.core.deref.call(null,cs);
var inst_20101__$1 = cljs.core.keys.call(null,inst_20100);
var inst_20102 = cljs.core.count.call(null,inst_20101__$1);
var inst_20103 = cljs.core.reset_BANG_.call(null,dctr,inst_20102);
var inst_20108 = cljs.core.seq.call(null,inst_20101__$1);
var inst_20109 = inst_20108;
var inst_20110 = null;
var inst_20111 = (0);
var inst_20112 = (0);
var state_20169__$1 = (function (){var statearr_20212 = state_20169;
(statearr_20212[(20)] = inst_20111);

(statearr_20212[(9)] = inst_20112);

(statearr_20212[(10)] = inst_20110);

(statearr_20212[(21)] = inst_20109);

(statearr_20212[(30)] = inst_20103);

(statearr_20212[(29)] = inst_20101__$1);

return statearr_20212;
})();
var statearr_20213_20282 = state_20169__$1;
(statearr_20213_20282[(2)] = null);

(statearr_20213_20282[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (28))){
var inst_20128 = (state_20169[(25)]);
var inst_20109 = (state_20169[(21)]);
var inst_20128__$1 = cljs.core.seq.call(null,inst_20109);
var state_20169__$1 = (function (){var statearr_20214 = state_20169;
(statearr_20214[(25)] = inst_20128__$1);

return statearr_20214;
})();
if(inst_20128__$1){
var statearr_20215_20283 = state_20169__$1;
(statearr_20215_20283[(1)] = (33));

} else {
var statearr_20216_20284 = state_20169__$1;
(statearr_20216_20284[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (25))){
var inst_20111 = (state_20169[(20)]);
var inst_20112 = (state_20169[(9)]);
var inst_20114 = (inst_20112 < inst_20111);
var inst_20115 = inst_20114;
var state_20169__$1 = state_20169;
if(cljs.core.truth_(inst_20115)){
var statearr_20217_20285 = state_20169__$1;
(statearr_20217_20285[(1)] = (27));

} else {
var statearr_20218_20286 = state_20169__$1;
(statearr_20218_20286[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (34))){
var state_20169__$1 = state_20169;
var statearr_20219_20287 = state_20169__$1;
(statearr_20219_20287[(2)] = null);

(statearr_20219_20287[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (17))){
var state_20169__$1 = state_20169;
var statearr_20220_20288 = state_20169__$1;
(statearr_20220_20288[(2)] = null);

(statearr_20220_20288[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (3))){
var inst_20167 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20169__$1,inst_20167);
} else {
if((state_val_20170 === (12))){
var inst_20096 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20221_20289 = state_20169__$1;
(statearr_20221_20289[(2)] = inst_20096);

(statearr_20221_20289[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (2))){
var state_20169__$1 = state_20169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20169__$1,(4),ch);
} else {
if((state_val_20170 === (23))){
var state_20169__$1 = state_20169;
var statearr_20222_20290 = state_20169__$1;
(statearr_20222_20290[(2)] = null);

(statearr_20222_20290[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (35))){
var inst_20151 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20223_20291 = state_20169__$1;
(statearr_20223_20291[(2)] = inst_20151);

(statearr_20223_20291[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (19))){
var inst_20070 = (state_20169[(7)]);
var inst_20074 = cljs.core.chunk_first.call(null,inst_20070);
var inst_20075 = cljs.core.chunk_rest.call(null,inst_20070);
var inst_20076 = cljs.core.count.call(null,inst_20074);
var inst_20050 = inst_20075;
var inst_20051 = inst_20074;
var inst_20052 = inst_20076;
var inst_20053 = (0);
var state_20169__$1 = (function (){var statearr_20224 = state_20169;
(statearr_20224[(13)] = inst_20051);

(statearr_20224[(14)] = inst_20053);

(statearr_20224[(16)] = inst_20052);

(statearr_20224[(17)] = inst_20050);

return statearr_20224;
})();
var statearr_20225_20292 = state_20169__$1;
(statearr_20225_20292[(2)] = null);

(statearr_20225_20292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (11))){
var inst_20070 = (state_20169[(7)]);
var inst_20050 = (state_20169[(17)]);
var inst_20070__$1 = cljs.core.seq.call(null,inst_20050);
var state_20169__$1 = (function (){var statearr_20226 = state_20169;
(statearr_20226[(7)] = inst_20070__$1);

return statearr_20226;
})();
if(inst_20070__$1){
var statearr_20227_20293 = state_20169__$1;
(statearr_20227_20293[(1)] = (16));

} else {
var statearr_20228_20294 = state_20169__$1;
(statearr_20228_20294[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (9))){
var inst_20098 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20229_20295 = state_20169__$1;
(statearr_20229_20295[(2)] = inst_20098);

(statearr_20229_20295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (5))){
var inst_20048 = cljs.core.deref.call(null,cs);
var inst_20049 = cljs.core.seq.call(null,inst_20048);
var inst_20050 = inst_20049;
var inst_20051 = null;
var inst_20052 = (0);
var inst_20053 = (0);
var state_20169__$1 = (function (){var statearr_20230 = state_20169;
(statearr_20230[(13)] = inst_20051);

(statearr_20230[(14)] = inst_20053);

(statearr_20230[(16)] = inst_20052);

(statearr_20230[(17)] = inst_20050);

return statearr_20230;
})();
var statearr_20231_20296 = state_20169__$1;
(statearr_20231_20296[(2)] = null);

(statearr_20231_20296[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (14))){
var state_20169__$1 = state_20169;
var statearr_20232_20297 = state_20169__$1;
(statearr_20232_20297[(2)] = null);

(statearr_20232_20297[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (45))){
var inst_20159 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20233_20298 = state_20169__$1;
(statearr_20233_20298[(2)] = inst_20159);

(statearr_20233_20298[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (26))){
var inst_20101 = (state_20169[(29)]);
var inst_20155 = (state_20169[(2)]);
var inst_20156 = cljs.core.seq.call(null,inst_20101);
var state_20169__$1 = (function (){var statearr_20234 = state_20169;
(statearr_20234[(31)] = inst_20155);

return statearr_20234;
})();
if(inst_20156){
var statearr_20235_20299 = state_20169__$1;
(statearr_20235_20299[(1)] = (42));

} else {
var statearr_20236_20300 = state_20169__$1;
(statearr_20236_20300[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (16))){
var inst_20070 = (state_20169[(7)]);
var inst_20072 = cljs.core.chunked_seq_QMARK_.call(null,inst_20070);
var state_20169__$1 = state_20169;
if(inst_20072){
var statearr_20237_20301 = state_20169__$1;
(statearr_20237_20301[(1)] = (19));

} else {
var statearr_20238_20302 = state_20169__$1;
(statearr_20238_20302[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (38))){
var inst_20148 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20239_20303 = state_20169__$1;
(statearr_20239_20303[(2)] = inst_20148);

(statearr_20239_20303[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (30))){
var state_20169__$1 = state_20169;
var statearr_20240_20304 = state_20169__$1;
(statearr_20240_20304[(2)] = null);

(statearr_20240_20304[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (10))){
var inst_20051 = (state_20169[(13)]);
var inst_20053 = (state_20169[(14)]);
var inst_20059 = cljs.core._nth.call(null,inst_20051,inst_20053);
var inst_20060 = cljs.core.nth.call(null,inst_20059,(0),null);
var inst_20061 = cljs.core.nth.call(null,inst_20059,(1),null);
var state_20169__$1 = (function (){var statearr_20241 = state_20169;
(statearr_20241[(26)] = inst_20060);

return statearr_20241;
})();
if(cljs.core.truth_(inst_20061)){
var statearr_20242_20305 = state_20169__$1;
(statearr_20242_20305[(1)] = (13));

} else {
var statearr_20243_20306 = state_20169__$1;
(statearr_20243_20306[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (18))){
var inst_20094 = (state_20169[(2)]);
var state_20169__$1 = state_20169;
var statearr_20244_20307 = state_20169__$1;
(statearr_20244_20307[(2)] = inst_20094);

(statearr_20244_20307[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (42))){
var state_20169__$1 = state_20169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20169__$1,(45),dchan);
} else {
if((state_val_20170 === (37))){
var inst_20128 = (state_20169[(25)]);
var inst_20137 = (state_20169[(23)]);
var inst_20041 = (state_20169[(11)]);
var inst_20137__$1 = cljs.core.first.call(null,inst_20128);
var inst_20138 = cljs.core.async.put_BANG_.call(null,inst_20137__$1,inst_20041,done);
var state_20169__$1 = (function (){var statearr_20245 = state_20169;
(statearr_20245[(23)] = inst_20137__$1);

return statearr_20245;
})();
if(cljs.core.truth_(inst_20138)){
var statearr_20246_20308 = state_20169__$1;
(statearr_20246_20308[(1)] = (39));

} else {
var statearr_20247_20309 = state_20169__$1;
(statearr_20247_20309[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20170 === (8))){
var inst_20053 = (state_20169[(14)]);
var inst_20052 = (state_20169[(16)]);
var inst_20055 = (inst_20053 < inst_20052);
var inst_20056 = inst_20055;
var state_20169__$1 = state_20169;
if(cljs.core.truth_(inst_20056)){
var statearr_20248_20310 = state_20169__$1;
(statearr_20248_20310[(1)] = (10));

} else {
var statearr_20249_20311 = state_20169__$1;
(statearr_20249_20311[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___20257,cs,m,dchan,dctr,done))
;
return ((function (switch__10982__auto__,c__11094__auto___20257,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10983__auto__ = null;
var cljs$core$async$mult_$_state_machine__10983__auto____0 = (function (){
var statearr_20253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20253[(0)] = cljs$core$async$mult_$_state_machine__10983__auto__);

(statearr_20253[(1)] = (1));

return statearr_20253;
});
var cljs$core$async$mult_$_state_machine__10983__auto____1 = (function (state_20169){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_20169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e20254){if((e20254 instanceof Object)){
var ex__10986__auto__ = e20254;
var statearr_20255_20312 = state_20169;
(statearr_20255_20312[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20169);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20254;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20313 = state_20169;
state_20169 = G__20313;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10983__auto__ = function(state_20169){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10983__auto____1.call(this,state_20169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10983__auto____0;
cljs$core$async$mult_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10983__auto____1;
return cljs$core$async$mult_$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___20257,cs,m,dchan,dctr,done))
})();
var state__11096__auto__ = (function (){var statearr_20256 = f__11095__auto__.call(null);
(statearr_20256[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___20257);

return statearr_20256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___20257,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20314 = [];
var len__5726__auto___20317 = arguments.length;
var i__5727__auto___20318 = (0);
while(true){
if((i__5727__auto___20318 < len__5726__auto___20317)){
args20314.push((arguments[i__5727__auto___20318]));

var G__20319 = (i__5727__auto___20318 + (1));
i__5727__auto___20318 = G__20319;
continue;
} else {
}
break;
}

var G__20316 = args20314.length;
switch (G__20316) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20314.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20331 = arguments.length;
var i__5727__auto___20332 = (0);
while(true){
if((i__5727__auto___20332 < len__5726__auto___20331)){
args__5733__auto__.push((arguments[i__5727__auto___20332]));

var G__20333 = (i__5727__auto___20332 + (1));
i__5727__auto___20332 = G__20333;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20325){
var map__20326 = p__20325;
var map__20326__$1 = ((((!((map__20326 == null)))?((((map__20326.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20326.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20326):map__20326);
var opts = map__20326__$1;
var statearr_20328_20334 = state;
(statearr_20328_20334[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20326,map__20326__$1,opts){
return (function (val){
var statearr_20329_20335 = state;
(statearr_20329_20335[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20326,map__20326__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20330_20336 = state;
(statearr_20330_20336[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20321){
var G__20322 = cljs.core.first.call(null,seq20321);
var seq20321__$1 = cljs.core.next.call(null,seq20321);
var G__20323 = cljs.core.first.call(null,seq20321__$1);
var seq20321__$2 = cljs.core.next.call(null,seq20321__$1);
var G__20324 = cljs.core.first.call(null,seq20321__$2);
var seq20321__$3 = cljs.core.next.call(null,seq20321__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20322,G__20323,G__20324,seq20321__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20500 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20500 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20501){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20501 = meta20501;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20502,meta20501__$1){
var self__ = this;
var _20502__$1 = this;
return (new cljs.core.async.t_cljs$core$async20500(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20501__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20502){
var self__ = this;
var _20502__$1 = this;
return self__.meta20501;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20501","meta20501",-965431599,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20500.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20500.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20500";

cljs.core.async.t_cljs$core$async20500.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20500");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20500 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20500(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20501){
return (new cljs.core.async.t_cljs$core$async20500(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20501));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20500(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11094__auto___20663 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___20663,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___20663,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20600){
var state_val_20601 = (state_20600[(1)]);
if((state_val_20601 === (7))){
var inst_20518 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
var statearr_20602_20664 = state_20600__$1;
(statearr_20602_20664[(2)] = inst_20518);

(statearr_20602_20664[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (20))){
var inst_20530 = (state_20600[(7)]);
var state_20600__$1 = state_20600;
var statearr_20603_20665 = state_20600__$1;
(statearr_20603_20665[(2)] = inst_20530);

(statearr_20603_20665[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (27))){
var state_20600__$1 = state_20600;
var statearr_20604_20666 = state_20600__$1;
(statearr_20604_20666[(2)] = null);

(statearr_20604_20666[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (1))){
var inst_20506 = (state_20600[(8)]);
var inst_20506__$1 = calc_state.call(null);
var inst_20508 = (inst_20506__$1 == null);
var inst_20509 = cljs.core.not.call(null,inst_20508);
var state_20600__$1 = (function (){var statearr_20605 = state_20600;
(statearr_20605[(8)] = inst_20506__$1);

return statearr_20605;
})();
if(inst_20509){
var statearr_20606_20667 = state_20600__$1;
(statearr_20606_20667[(1)] = (2));

} else {
var statearr_20607_20668 = state_20600__$1;
(statearr_20607_20668[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (24))){
var inst_20574 = (state_20600[(9)]);
var inst_20560 = (state_20600[(10)]);
var inst_20553 = (state_20600[(11)]);
var inst_20574__$1 = inst_20553.call(null,inst_20560);
var state_20600__$1 = (function (){var statearr_20608 = state_20600;
(statearr_20608[(9)] = inst_20574__$1);

return statearr_20608;
})();
if(cljs.core.truth_(inst_20574__$1)){
var statearr_20609_20669 = state_20600__$1;
(statearr_20609_20669[(1)] = (29));

} else {
var statearr_20610_20670 = state_20600__$1;
(statearr_20610_20670[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (4))){
var inst_20521 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
if(cljs.core.truth_(inst_20521)){
var statearr_20611_20671 = state_20600__$1;
(statearr_20611_20671[(1)] = (8));

} else {
var statearr_20612_20672 = state_20600__$1;
(statearr_20612_20672[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (15))){
var inst_20547 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
if(cljs.core.truth_(inst_20547)){
var statearr_20613_20673 = state_20600__$1;
(statearr_20613_20673[(1)] = (19));

} else {
var statearr_20614_20674 = state_20600__$1;
(statearr_20614_20674[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (21))){
var inst_20552 = (state_20600[(12)]);
var inst_20552__$1 = (state_20600[(2)]);
var inst_20553 = cljs.core.get.call(null,inst_20552__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20554 = cljs.core.get.call(null,inst_20552__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20555 = cljs.core.get.call(null,inst_20552__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20600__$1 = (function (){var statearr_20615 = state_20600;
(statearr_20615[(11)] = inst_20553);

(statearr_20615[(12)] = inst_20552__$1);

(statearr_20615[(13)] = inst_20554);

return statearr_20615;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20600__$1,(22),inst_20555);
} else {
if((state_val_20601 === (31))){
var inst_20582 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
if(cljs.core.truth_(inst_20582)){
var statearr_20616_20675 = state_20600__$1;
(statearr_20616_20675[(1)] = (32));

} else {
var statearr_20617_20676 = state_20600__$1;
(statearr_20617_20676[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (32))){
var inst_20559 = (state_20600[(14)]);
var state_20600__$1 = state_20600;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20600__$1,(35),out,inst_20559);
} else {
if((state_val_20601 === (33))){
var inst_20552 = (state_20600[(12)]);
var inst_20530 = inst_20552;
var state_20600__$1 = (function (){var statearr_20618 = state_20600;
(statearr_20618[(7)] = inst_20530);

return statearr_20618;
})();
var statearr_20619_20677 = state_20600__$1;
(statearr_20619_20677[(2)] = null);

(statearr_20619_20677[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (13))){
var inst_20530 = (state_20600[(7)]);
var inst_20537 = inst_20530.cljs$lang$protocol_mask$partition0$;
var inst_20538 = (inst_20537 & (64));
var inst_20539 = inst_20530.cljs$core$ISeq$;
var inst_20540 = (inst_20538) || (inst_20539);
var state_20600__$1 = state_20600;
if(cljs.core.truth_(inst_20540)){
var statearr_20620_20678 = state_20600__$1;
(statearr_20620_20678[(1)] = (16));

} else {
var statearr_20621_20679 = state_20600__$1;
(statearr_20621_20679[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (22))){
var inst_20560 = (state_20600[(10)]);
var inst_20559 = (state_20600[(14)]);
var inst_20558 = (state_20600[(2)]);
var inst_20559__$1 = cljs.core.nth.call(null,inst_20558,(0),null);
var inst_20560__$1 = cljs.core.nth.call(null,inst_20558,(1),null);
var inst_20561 = (inst_20559__$1 == null);
var inst_20562 = cljs.core._EQ_.call(null,inst_20560__$1,change);
var inst_20563 = (inst_20561) || (inst_20562);
var state_20600__$1 = (function (){var statearr_20622 = state_20600;
(statearr_20622[(10)] = inst_20560__$1);

(statearr_20622[(14)] = inst_20559__$1);

return statearr_20622;
})();
if(cljs.core.truth_(inst_20563)){
var statearr_20623_20680 = state_20600__$1;
(statearr_20623_20680[(1)] = (23));

} else {
var statearr_20624_20681 = state_20600__$1;
(statearr_20624_20681[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (36))){
var inst_20552 = (state_20600[(12)]);
var inst_20530 = inst_20552;
var state_20600__$1 = (function (){var statearr_20625 = state_20600;
(statearr_20625[(7)] = inst_20530);

return statearr_20625;
})();
var statearr_20626_20682 = state_20600__$1;
(statearr_20626_20682[(2)] = null);

(statearr_20626_20682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (29))){
var inst_20574 = (state_20600[(9)]);
var state_20600__$1 = state_20600;
var statearr_20627_20683 = state_20600__$1;
(statearr_20627_20683[(2)] = inst_20574);

(statearr_20627_20683[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (6))){
var state_20600__$1 = state_20600;
var statearr_20628_20684 = state_20600__$1;
(statearr_20628_20684[(2)] = false);

(statearr_20628_20684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (28))){
var inst_20570 = (state_20600[(2)]);
var inst_20571 = calc_state.call(null);
var inst_20530 = inst_20571;
var state_20600__$1 = (function (){var statearr_20629 = state_20600;
(statearr_20629[(7)] = inst_20530);

(statearr_20629[(15)] = inst_20570);

return statearr_20629;
})();
var statearr_20630_20685 = state_20600__$1;
(statearr_20630_20685[(2)] = null);

(statearr_20630_20685[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (25))){
var inst_20596 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
var statearr_20631_20686 = state_20600__$1;
(statearr_20631_20686[(2)] = inst_20596);

(statearr_20631_20686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (34))){
var inst_20594 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
var statearr_20632_20687 = state_20600__$1;
(statearr_20632_20687[(2)] = inst_20594);

(statearr_20632_20687[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (17))){
var state_20600__$1 = state_20600;
var statearr_20633_20688 = state_20600__$1;
(statearr_20633_20688[(2)] = false);

(statearr_20633_20688[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (3))){
var state_20600__$1 = state_20600;
var statearr_20634_20689 = state_20600__$1;
(statearr_20634_20689[(2)] = false);

(statearr_20634_20689[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (12))){
var inst_20598 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20600__$1,inst_20598);
} else {
if((state_val_20601 === (2))){
var inst_20506 = (state_20600[(8)]);
var inst_20511 = inst_20506.cljs$lang$protocol_mask$partition0$;
var inst_20512 = (inst_20511 & (64));
var inst_20513 = inst_20506.cljs$core$ISeq$;
var inst_20514 = (inst_20512) || (inst_20513);
var state_20600__$1 = state_20600;
if(cljs.core.truth_(inst_20514)){
var statearr_20635_20690 = state_20600__$1;
(statearr_20635_20690[(1)] = (5));

} else {
var statearr_20636_20691 = state_20600__$1;
(statearr_20636_20691[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (23))){
var inst_20559 = (state_20600[(14)]);
var inst_20565 = (inst_20559 == null);
var state_20600__$1 = state_20600;
if(cljs.core.truth_(inst_20565)){
var statearr_20637_20692 = state_20600__$1;
(statearr_20637_20692[(1)] = (26));

} else {
var statearr_20638_20693 = state_20600__$1;
(statearr_20638_20693[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (35))){
var inst_20585 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
if(cljs.core.truth_(inst_20585)){
var statearr_20639_20694 = state_20600__$1;
(statearr_20639_20694[(1)] = (36));

} else {
var statearr_20640_20695 = state_20600__$1;
(statearr_20640_20695[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (19))){
var inst_20530 = (state_20600[(7)]);
var inst_20549 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20530);
var state_20600__$1 = state_20600;
var statearr_20641_20696 = state_20600__$1;
(statearr_20641_20696[(2)] = inst_20549);

(statearr_20641_20696[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (11))){
var inst_20530 = (state_20600[(7)]);
var inst_20534 = (inst_20530 == null);
var inst_20535 = cljs.core.not.call(null,inst_20534);
var state_20600__$1 = state_20600;
if(inst_20535){
var statearr_20642_20697 = state_20600__$1;
(statearr_20642_20697[(1)] = (13));

} else {
var statearr_20643_20698 = state_20600__$1;
(statearr_20643_20698[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (9))){
var inst_20506 = (state_20600[(8)]);
var state_20600__$1 = state_20600;
var statearr_20644_20699 = state_20600__$1;
(statearr_20644_20699[(2)] = inst_20506);

(statearr_20644_20699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (5))){
var state_20600__$1 = state_20600;
var statearr_20645_20700 = state_20600__$1;
(statearr_20645_20700[(2)] = true);

(statearr_20645_20700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (14))){
var state_20600__$1 = state_20600;
var statearr_20646_20701 = state_20600__$1;
(statearr_20646_20701[(2)] = false);

(statearr_20646_20701[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (26))){
var inst_20560 = (state_20600[(10)]);
var inst_20567 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20560);
var state_20600__$1 = state_20600;
var statearr_20647_20702 = state_20600__$1;
(statearr_20647_20702[(2)] = inst_20567);

(statearr_20647_20702[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (16))){
var state_20600__$1 = state_20600;
var statearr_20648_20703 = state_20600__$1;
(statearr_20648_20703[(2)] = true);

(statearr_20648_20703[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (38))){
var inst_20590 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
var statearr_20649_20704 = state_20600__$1;
(statearr_20649_20704[(2)] = inst_20590);

(statearr_20649_20704[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (30))){
var inst_20560 = (state_20600[(10)]);
var inst_20553 = (state_20600[(11)]);
var inst_20554 = (state_20600[(13)]);
var inst_20577 = cljs.core.empty_QMARK_.call(null,inst_20553);
var inst_20578 = inst_20554.call(null,inst_20560);
var inst_20579 = cljs.core.not.call(null,inst_20578);
var inst_20580 = (inst_20577) && (inst_20579);
var state_20600__$1 = state_20600;
var statearr_20650_20705 = state_20600__$1;
(statearr_20650_20705[(2)] = inst_20580);

(statearr_20650_20705[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (10))){
var inst_20506 = (state_20600[(8)]);
var inst_20526 = (state_20600[(2)]);
var inst_20527 = cljs.core.get.call(null,inst_20526,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20528 = cljs.core.get.call(null,inst_20526,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20529 = cljs.core.get.call(null,inst_20526,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20530 = inst_20506;
var state_20600__$1 = (function (){var statearr_20651 = state_20600;
(statearr_20651[(16)] = inst_20528);

(statearr_20651[(17)] = inst_20529);

(statearr_20651[(7)] = inst_20530);

(statearr_20651[(18)] = inst_20527);

return statearr_20651;
})();
var statearr_20652_20706 = state_20600__$1;
(statearr_20652_20706[(2)] = null);

(statearr_20652_20706[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (18))){
var inst_20544 = (state_20600[(2)]);
var state_20600__$1 = state_20600;
var statearr_20653_20707 = state_20600__$1;
(statearr_20653_20707[(2)] = inst_20544);

(statearr_20653_20707[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (37))){
var state_20600__$1 = state_20600;
var statearr_20654_20708 = state_20600__$1;
(statearr_20654_20708[(2)] = null);

(statearr_20654_20708[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20601 === (8))){
var inst_20506 = (state_20600[(8)]);
var inst_20523 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20506);
var state_20600__$1 = state_20600;
var statearr_20655_20709 = state_20600__$1;
(statearr_20655_20709[(2)] = inst_20523);

(statearr_20655_20709[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___20663,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10982__auto__,c__11094__auto___20663,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10983__auto__ = null;
var cljs$core$async$mix_$_state_machine__10983__auto____0 = (function (){
var statearr_20659 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20659[(0)] = cljs$core$async$mix_$_state_machine__10983__auto__);

(statearr_20659[(1)] = (1));

return statearr_20659;
});
var cljs$core$async$mix_$_state_machine__10983__auto____1 = (function (state_20600){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_20600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e20660){if((e20660 instanceof Object)){
var ex__10986__auto__ = e20660;
var statearr_20661_20710 = state_20600;
(statearr_20661_20710[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20600);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20660;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20711 = state_20600;
state_20600 = G__20711;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10983__auto__ = function(state_20600){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10983__auto____1.call(this,state_20600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10983__auto____0;
cljs$core$async$mix_$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10983__auto____1;
return cljs$core$async$mix_$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___20663,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11096__auto__ = (function (){var statearr_20662 = f__11095__auto__.call(null);
(statearr_20662[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___20663);

return statearr_20662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___20663,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20712 = [];
var len__5726__auto___20715 = arguments.length;
var i__5727__auto___20716 = (0);
while(true){
if((i__5727__auto___20716 < len__5726__auto___20715)){
args20712.push((arguments[i__5727__auto___20716]));

var G__20717 = (i__5727__auto___20716 + (1));
i__5727__auto___20716 = G__20717;
continue;
} else {
}
break;
}

var G__20714 = args20712.length;
switch (G__20714) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20712.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20720 = [];
var len__5726__auto___20845 = arguments.length;
var i__5727__auto___20846 = (0);
while(true){
if((i__5727__auto___20846 < len__5726__auto___20845)){
args20720.push((arguments[i__5727__auto___20846]));

var G__20847 = (i__5727__auto___20846 + (1));
i__5727__auto___20846 = G__20847;
continue;
} else {
}
break;
}

var G__20722 = args20720.length;
switch (G__20722) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20720.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__20719_SHARP_){
if(cljs.core.truth_(p1__20719_SHARP_.call(null,topic))){
return p1__20719_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20719_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20723 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20723 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20724){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20724 = meta20724;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20725,meta20724__$1){
var self__ = this;
var _20725__$1 = this;
return (new cljs.core.async.t_cljs$core$async20723(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20724__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20725){
var self__ = this;
var _20725__$1 = this;
return self__.meta20724;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20723.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20723.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20724","meta20724",1902025047,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20723.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20723.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20723";

cljs.core.async.t_cljs$core$async20723.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20723");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20723 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20723(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20724){
return (new cljs.core.async.t_cljs$core$async20723(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20724));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20723(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11094__auto___20849 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___20849,mults,ensure_mult,p){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___20849,mults,ensure_mult,p){
return (function (state_20797){
var state_val_20798 = (state_20797[(1)]);
if((state_val_20798 === (7))){
var inst_20793 = (state_20797[(2)]);
var state_20797__$1 = state_20797;
var statearr_20799_20850 = state_20797__$1;
(statearr_20799_20850[(2)] = inst_20793);

(statearr_20799_20850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (20))){
var state_20797__$1 = state_20797;
var statearr_20800_20851 = state_20797__$1;
(statearr_20800_20851[(2)] = null);

(statearr_20800_20851[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (1))){
var state_20797__$1 = state_20797;
var statearr_20801_20852 = state_20797__$1;
(statearr_20801_20852[(2)] = null);

(statearr_20801_20852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (24))){
var inst_20776 = (state_20797[(7)]);
var inst_20785 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20776);
var state_20797__$1 = state_20797;
var statearr_20802_20853 = state_20797__$1;
(statearr_20802_20853[(2)] = inst_20785);

(statearr_20802_20853[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (4))){
var inst_20728 = (state_20797[(8)]);
var inst_20728__$1 = (state_20797[(2)]);
var inst_20729 = (inst_20728__$1 == null);
var state_20797__$1 = (function (){var statearr_20803 = state_20797;
(statearr_20803[(8)] = inst_20728__$1);

return statearr_20803;
})();
if(cljs.core.truth_(inst_20729)){
var statearr_20804_20854 = state_20797__$1;
(statearr_20804_20854[(1)] = (5));

} else {
var statearr_20805_20855 = state_20797__$1;
(statearr_20805_20855[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (15))){
var inst_20770 = (state_20797[(2)]);
var state_20797__$1 = state_20797;
var statearr_20806_20856 = state_20797__$1;
(statearr_20806_20856[(2)] = inst_20770);

(statearr_20806_20856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (21))){
var inst_20790 = (state_20797[(2)]);
var state_20797__$1 = (function (){var statearr_20807 = state_20797;
(statearr_20807[(9)] = inst_20790);

return statearr_20807;
})();
var statearr_20808_20857 = state_20797__$1;
(statearr_20808_20857[(2)] = null);

(statearr_20808_20857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (13))){
var inst_20752 = (state_20797[(10)]);
var inst_20754 = cljs.core.chunked_seq_QMARK_.call(null,inst_20752);
var state_20797__$1 = state_20797;
if(inst_20754){
var statearr_20809_20858 = state_20797__$1;
(statearr_20809_20858[(1)] = (16));

} else {
var statearr_20810_20859 = state_20797__$1;
(statearr_20810_20859[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (22))){
var inst_20782 = (state_20797[(2)]);
var state_20797__$1 = state_20797;
if(cljs.core.truth_(inst_20782)){
var statearr_20811_20860 = state_20797__$1;
(statearr_20811_20860[(1)] = (23));

} else {
var statearr_20812_20861 = state_20797__$1;
(statearr_20812_20861[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (6))){
var inst_20728 = (state_20797[(8)]);
var inst_20776 = (state_20797[(7)]);
var inst_20778 = (state_20797[(11)]);
var inst_20776__$1 = topic_fn.call(null,inst_20728);
var inst_20777 = cljs.core.deref.call(null,mults);
var inst_20778__$1 = cljs.core.get.call(null,inst_20777,inst_20776__$1);
var state_20797__$1 = (function (){var statearr_20813 = state_20797;
(statearr_20813[(7)] = inst_20776__$1);

(statearr_20813[(11)] = inst_20778__$1);

return statearr_20813;
})();
if(cljs.core.truth_(inst_20778__$1)){
var statearr_20814_20862 = state_20797__$1;
(statearr_20814_20862[(1)] = (19));

} else {
var statearr_20815_20863 = state_20797__$1;
(statearr_20815_20863[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (25))){
var inst_20787 = (state_20797[(2)]);
var state_20797__$1 = state_20797;
var statearr_20816_20864 = state_20797__$1;
(statearr_20816_20864[(2)] = inst_20787);

(statearr_20816_20864[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (17))){
var inst_20752 = (state_20797[(10)]);
var inst_20761 = cljs.core.first.call(null,inst_20752);
var inst_20762 = cljs.core.async.muxch_STAR_.call(null,inst_20761);
var inst_20763 = cljs.core.async.close_BANG_.call(null,inst_20762);
var inst_20764 = cljs.core.next.call(null,inst_20752);
var inst_20738 = inst_20764;
var inst_20739 = null;
var inst_20740 = (0);
var inst_20741 = (0);
var state_20797__$1 = (function (){var statearr_20817 = state_20797;
(statearr_20817[(12)] = inst_20740);

(statearr_20817[(13)] = inst_20739);

(statearr_20817[(14)] = inst_20738);

(statearr_20817[(15)] = inst_20741);

(statearr_20817[(16)] = inst_20763);

return statearr_20817;
})();
var statearr_20818_20865 = state_20797__$1;
(statearr_20818_20865[(2)] = null);

(statearr_20818_20865[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (3))){
var inst_20795 = (state_20797[(2)]);
var state_20797__$1 = state_20797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20797__$1,inst_20795);
} else {
if((state_val_20798 === (12))){
var inst_20772 = (state_20797[(2)]);
var state_20797__$1 = state_20797;
var statearr_20819_20866 = state_20797__$1;
(statearr_20819_20866[(2)] = inst_20772);

(statearr_20819_20866[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (2))){
var state_20797__$1 = state_20797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20797__$1,(4),ch);
} else {
if((state_val_20798 === (23))){
var state_20797__$1 = state_20797;
var statearr_20820_20867 = state_20797__$1;
(statearr_20820_20867[(2)] = null);

(statearr_20820_20867[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (19))){
var inst_20728 = (state_20797[(8)]);
var inst_20778 = (state_20797[(11)]);
var inst_20780 = cljs.core.async.muxch_STAR_.call(null,inst_20778);
var state_20797__$1 = state_20797;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20797__$1,(22),inst_20780,inst_20728);
} else {
if((state_val_20798 === (11))){
var inst_20752 = (state_20797[(10)]);
var inst_20738 = (state_20797[(14)]);
var inst_20752__$1 = cljs.core.seq.call(null,inst_20738);
var state_20797__$1 = (function (){var statearr_20821 = state_20797;
(statearr_20821[(10)] = inst_20752__$1);

return statearr_20821;
})();
if(inst_20752__$1){
var statearr_20822_20868 = state_20797__$1;
(statearr_20822_20868[(1)] = (13));

} else {
var statearr_20823_20869 = state_20797__$1;
(statearr_20823_20869[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (9))){
var inst_20774 = (state_20797[(2)]);
var state_20797__$1 = state_20797;
var statearr_20824_20870 = state_20797__$1;
(statearr_20824_20870[(2)] = inst_20774);

(statearr_20824_20870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (5))){
var inst_20735 = cljs.core.deref.call(null,mults);
var inst_20736 = cljs.core.vals.call(null,inst_20735);
var inst_20737 = cljs.core.seq.call(null,inst_20736);
var inst_20738 = inst_20737;
var inst_20739 = null;
var inst_20740 = (0);
var inst_20741 = (0);
var state_20797__$1 = (function (){var statearr_20825 = state_20797;
(statearr_20825[(12)] = inst_20740);

(statearr_20825[(13)] = inst_20739);

(statearr_20825[(14)] = inst_20738);

(statearr_20825[(15)] = inst_20741);

return statearr_20825;
})();
var statearr_20826_20871 = state_20797__$1;
(statearr_20826_20871[(2)] = null);

(statearr_20826_20871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (14))){
var state_20797__$1 = state_20797;
var statearr_20830_20872 = state_20797__$1;
(statearr_20830_20872[(2)] = null);

(statearr_20830_20872[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (16))){
var inst_20752 = (state_20797[(10)]);
var inst_20756 = cljs.core.chunk_first.call(null,inst_20752);
var inst_20757 = cljs.core.chunk_rest.call(null,inst_20752);
var inst_20758 = cljs.core.count.call(null,inst_20756);
var inst_20738 = inst_20757;
var inst_20739 = inst_20756;
var inst_20740 = inst_20758;
var inst_20741 = (0);
var state_20797__$1 = (function (){var statearr_20831 = state_20797;
(statearr_20831[(12)] = inst_20740);

(statearr_20831[(13)] = inst_20739);

(statearr_20831[(14)] = inst_20738);

(statearr_20831[(15)] = inst_20741);

return statearr_20831;
})();
var statearr_20832_20873 = state_20797__$1;
(statearr_20832_20873[(2)] = null);

(statearr_20832_20873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (10))){
var inst_20740 = (state_20797[(12)]);
var inst_20739 = (state_20797[(13)]);
var inst_20738 = (state_20797[(14)]);
var inst_20741 = (state_20797[(15)]);
var inst_20746 = cljs.core._nth.call(null,inst_20739,inst_20741);
var inst_20747 = cljs.core.async.muxch_STAR_.call(null,inst_20746);
var inst_20748 = cljs.core.async.close_BANG_.call(null,inst_20747);
var inst_20749 = (inst_20741 + (1));
var tmp20827 = inst_20740;
var tmp20828 = inst_20739;
var tmp20829 = inst_20738;
var inst_20738__$1 = tmp20829;
var inst_20739__$1 = tmp20828;
var inst_20740__$1 = tmp20827;
var inst_20741__$1 = inst_20749;
var state_20797__$1 = (function (){var statearr_20833 = state_20797;
(statearr_20833[(12)] = inst_20740__$1);

(statearr_20833[(13)] = inst_20739__$1);

(statearr_20833[(17)] = inst_20748);

(statearr_20833[(14)] = inst_20738__$1);

(statearr_20833[(15)] = inst_20741__$1);

return statearr_20833;
})();
var statearr_20834_20874 = state_20797__$1;
(statearr_20834_20874[(2)] = null);

(statearr_20834_20874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (18))){
var inst_20767 = (state_20797[(2)]);
var state_20797__$1 = state_20797;
var statearr_20835_20875 = state_20797__$1;
(statearr_20835_20875[(2)] = inst_20767);

(statearr_20835_20875[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20798 === (8))){
var inst_20740 = (state_20797[(12)]);
var inst_20741 = (state_20797[(15)]);
var inst_20743 = (inst_20741 < inst_20740);
var inst_20744 = inst_20743;
var state_20797__$1 = state_20797;
if(cljs.core.truth_(inst_20744)){
var statearr_20836_20876 = state_20797__$1;
(statearr_20836_20876[(1)] = (10));

} else {
var statearr_20837_20877 = state_20797__$1;
(statearr_20837_20877[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___20849,mults,ensure_mult,p))
;
return ((function (switch__10982__auto__,c__11094__auto___20849,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_20841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20841[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_20841[(1)] = (1));

return statearr_20841;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_20797){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_20797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e20842){if((e20842 instanceof Object)){
var ex__10986__auto__ = e20842;
var statearr_20843_20878 = state_20797;
(statearr_20843_20878[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20797);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20842;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20879 = state_20797;
state_20797 = G__20879;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_20797){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_20797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___20849,mults,ensure_mult,p))
})();
var state__11096__auto__ = (function (){var statearr_20844 = f__11095__auto__.call(null);
(statearr_20844[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___20849);

return statearr_20844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___20849,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20880 = [];
var len__5726__auto___20883 = arguments.length;
var i__5727__auto___20884 = (0);
while(true){
if((i__5727__auto___20884 < len__5726__auto___20883)){
args20880.push((arguments[i__5727__auto___20884]));

var G__20885 = (i__5727__auto___20884 + (1));
i__5727__auto___20884 = G__20885;
continue;
} else {
}
break;
}

var G__20882 = args20880.length;
switch (G__20882) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20880.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20887 = [];
var len__5726__auto___20890 = arguments.length;
var i__5727__auto___20891 = (0);
while(true){
if((i__5727__auto___20891 < len__5726__auto___20890)){
args20887.push((arguments[i__5727__auto___20891]));

var G__20892 = (i__5727__auto___20891 + (1));
i__5727__auto___20891 = G__20892;
continue;
} else {
}
break;
}

var G__20889 = args20887.length;
switch (G__20889) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20887.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20894 = [];
var len__5726__auto___20965 = arguments.length;
var i__5727__auto___20966 = (0);
while(true){
if((i__5727__auto___20966 < len__5726__auto___20965)){
args20894.push((arguments[i__5727__auto___20966]));

var G__20967 = (i__5727__auto___20966 + (1));
i__5727__auto___20966 = G__20967;
continue;
} else {
}
break;
}

var G__20896 = args20894.length;
switch (G__20896) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20894.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11094__auto___20969 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___20969,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___20969,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20935){
var state_val_20936 = (state_20935[(1)]);
if((state_val_20936 === (7))){
var state_20935__$1 = state_20935;
var statearr_20937_20970 = state_20935__$1;
(statearr_20937_20970[(2)] = null);

(statearr_20937_20970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (1))){
var state_20935__$1 = state_20935;
var statearr_20938_20971 = state_20935__$1;
(statearr_20938_20971[(2)] = null);

(statearr_20938_20971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (4))){
var inst_20899 = (state_20935[(7)]);
var inst_20901 = (inst_20899 < cnt);
var state_20935__$1 = state_20935;
if(cljs.core.truth_(inst_20901)){
var statearr_20939_20972 = state_20935__$1;
(statearr_20939_20972[(1)] = (6));

} else {
var statearr_20940_20973 = state_20935__$1;
(statearr_20940_20973[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (15))){
var inst_20931 = (state_20935[(2)]);
var state_20935__$1 = state_20935;
var statearr_20941_20974 = state_20935__$1;
(statearr_20941_20974[(2)] = inst_20931);

(statearr_20941_20974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (13))){
var inst_20924 = cljs.core.async.close_BANG_.call(null,out);
var state_20935__$1 = state_20935;
var statearr_20942_20975 = state_20935__$1;
(statearr_20942_20975[(2)] = inst_20924);

(statearr_20942_20975[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (6))){
var state_20935__$1 = state_20935;
var statearr_20943_20976 = state_20935__$1;
(statearr_20943_20976[(2)] = null);

(statearr_20943_20976[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (3))){
var inst_20933 = (state_20935[(2)]);
var state_20935__$1 = state_20935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20935__$1,inst_20933);
} else {
if((state_val_20936 === (12))){
var inst_20921 = (state_20935[(8)]);
var inst_20921__$1 = (state_20935[(2)]);
var inst_20922 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20921__$1);
var state_20935__$1 = (function (){var statearr_20944 = state_20935;
(statearr_20944[(8)] = inst_20921__$1);

return statearr_20944;
})();
if(cljs.core.truth_(inst_20922)){
var statearr_20945_20977 = state_20935__$1;
(statearr_20945_20977[(1)] = (13));

} else {
var statearr_20946_20978 = state_20935__$1;
(statearr_20946_20978[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (2))){
var inst_20898 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20899 = (0);
var state_20935__$1 = (function (){var statearr_20947 = state_20935;
(statearr_20947[(7)] = inst_20899);

(statearr_20947[(9)] = inst_20898);

return statearr_20947;
})();
var statearr_20948_20979 = state_20935__$1;
(statearr_20948_20979[(2)] = null);

(statearr_20948_20979[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (11))){
var inst_20899 = (state_20935[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20935,(10),Object,null,(9));
var inst_20908 = chs__$1.call(null,inst_20899);
var inst_20909 = done.call(null,inst_20899);
var inst_20910 = cljs.core.async.take_BANG_.call(null,inst_20908,inst_20909);
var state_20935__$1 = state_20935;
var statearr_20949_20980 = state_20935__$1;
(statearr_20949_20980[(2)] = inst_20910);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20935__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (9))){
var inst_20899 = (state_20935[(7)]);
var inst_20912 = (state_20935[(2)]);
var inst_20913 = (inst_20899 + (1));
var inst_20899__$1 = inst_20913;
var state_20935__$1 = (function (){var statearr_20950 = state_20935;
(statearr_20950[(7)] = inst_20899__$1);

(statearr_20950[(10)] = inst_20912);

return statearr_20950;
})();
var statearr_20951_20981 = state_20935__$1;
(statearr_20951_20981[(2)] = null);

(statearr_20951_20981[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (5))){
var inst_20919 = (state_20935[(2)]);
var state_20935__$1 = (function (){var statearr_20952 = state_20935;
(statearr_20952[(11)] = inst_20919);

return statearr_20952;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20935__$1,(12),dchan);
} else {
if((state_val_20936 === (14))){
var inst_20921 = (state_20935[(8)]);
var inst_20926 = cljs.core.apply.call(null,f,inst_20921);
var state_20935__$1 = state_20935;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20935__$1,(16),out,inst_20926);
} else {
if((state_val_20936 === (16))){
var inst_20928 = (state_20935[(2)]);
var state_20935__$1 = (function (){var statearr_20953 = state_20935;
(statearr_20953[(12)] = inst_20928);

return statearr_20953;
})();
var statearr_20954_20982 = state_20935__$1;
(statearr_20954_20982[(2)] = null);

(statearr_20954_20982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (10))){
var inst_20903 = (state_20935[(2)]);
var inst_20904 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20935__$1 = (function (){var statearr_20955 = state_20935;
(statearr_20955[(13)] = inst_20903);

return statearr_20955;
})();
var statearr_20956_20983 = state_20935__$1;
(statearr_20956_20983[(2)] = inst_20904);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20935__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20936 === (8))){
var inst_20917 = (state_20935[(2)]);
var state_20935__$1 = state_20935;
var statearr_20957_20984 = state_20935__$1;
(statearr_20957_20984[(2)] = inst_20917);

(statearr_20957_20984[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___20969,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10982__auto__,c__11094__auto___20969,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_20961 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20961[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_20961[(1)] = (1));

return statearr_20961;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_20935){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_20935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e20962){if((e20962 instanceof Object)){
var ex__10986__auto__ = e20962;
var statearr_20963_20985 = state_20935;
(statearr_20963_20985[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20935);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20962;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20986 = state_20935;
state_20935 = G__20986;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_20935){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_20935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___20969,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11096__auto__ = (function (){var statearr_20964 = f__11095__auto__.call(null);
(statearr_20964[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___20969);

return statearr_20964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___20969,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20988 = [];
var len__5726__auto___21044 = arguments.length;
var i__5727__auto___21045 = (0);
while(true){
if((i__5727__auto___21045 < len__5726__auto___21044)){
args20988.push((arguments[i__5727__auto___21045]));

var G__21046 = (i__5727__auto___21045 + (1));
i__5727__auto___21045 = G__21046;
continue;
} else {
}
break;
}

var G__20990 = args20988.length;
switch (G__20990) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20988.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___21048 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___21048,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___21048,out){
return (function (state_21020){
var state_val_21021 = (state_21020[(1)]);
if((state_val_21021 === (7))){
var inst_20999 = (state_21020[(7)]);
var inst_21000 = (state_21020[(8)]);
var inst_20999__$1 = (state_21020[(2)]);
var inst_21000__$1 = cljs.core.nth.call(null,inst_20999__$1,(0),null);
var inst_21001 = cljs.core.nth.call(null,inst_20999__$1,(1),null);
var inst_21002 = (inst_21000__$1 == null);
var state_21020__$1 = (function (){var statearr_21022 = state_21020;
(statearr_21022[(9)] = inst_21001);

(statearr_21022[(7)] = inst_20999__$1);

(statearr_21022[(8)] = inst_21000__$1);

return statearr_21022;
})();
if(cljs.core.truth_(inst_21002)){
var statearr_21023_21049 = state_21020__$1;
(statearr_21023_21049[(1)] = (8));

} else {
var statearr_21024_21050 = state_21020__$1;
(statearr_21024_21050[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (1))){
var inst_20991 = cljs.core.vec.call(null,chs);
var inst_20992 = inst_20991;
var state_21020__$1 = (function (){var statearr_21025 = state_21020;
(statearr_21025[(10)] = inst_20992);

return statearr_21025;
})();
var statearr_21026_21051 = state_21020__$1;
(statearr_21026_21051[(2)] = null);

(statearr_21026_21051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (4))){
var inst_20992 = (state_21020[(10)]);
var state_21020__$1 = state_21020;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21020__$1,(7),inst_20992);
} else {
if((state_val_21021 === (6))){
var inst_21016 = (state_21020[(2)]);
var state_21020__$1 = state_21020;
var statearr_21027_21052 = state_21020__$1;
(statearr_21027_21052[(2)] = inst_21016);

(statearr_21027_21052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (3))){
var inst_21018 = (state_21020[(2)]);
var state_21020__$1 = state_21020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21020__$1,inst_21018);
} else {
if((state_val_21021 === (2))){
var inst_20992 = (state_21020[(10)]);
var inst_20994 = cljs.core.count.call(null,inst_20992);
var inst_20995 = (inst_20994 > (0));
var state_21020__$1 = state_21020;
if(cljs.core.truth_(inst_20995)){
var statearr_21029_21053 = state_21020__$1;
(statearr_21029_21053[(1)] = (4));

} else {
var statearr_21030_21054 = state_21020__$1;
(statearr_21030_21054[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (11))){
var inst_20992 = (state_21020[(10)]);
var inst_21009 = (state_21020[(2)]);
var tmp21028 = inst_20992;
var inst_20992__$1 = tmp21028;
var state_21020__$1 = (function (){var statearr_21031 = state_21020;
(statearr_21031[(11)] = inst_21009);

(statearr_21031[(10)] = inst_20992__$1);

return statearr_21031;
})();
var statearr_21032_21055 = state_21020__$1;
(statearr_21032_21055[(2)] = null);

(statearr_21032_21055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (9))){
var inst_21000 = (state_21020[(8)]);
var state_21020__$1 = state_21020;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21020__$1,(11),out,inst_21000);
} else {
if((state_val_21021 === (5))){
var inst_21014 = cljs.core.async.close_BANG_.call(null,out);
var state_21020__$1 = state_21020;
var statearr_21033_21056 = state_21020__$1;
(statearr_21033_21056[(2)] = inst_21014);

(statearr_21033_21056[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (10))){
var inst_21012 = (state_21020[(2)]);
var state_21020__$1 = state_21020;
var statearr_21034_21057 = state_21020__$1;
(statearr_21034_21057[(2)] = inst_21012);

(statearr_21034_21057[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21021 === (8))){
var inst_21001 = (state_21020[(9)]);
var inst_20999 = (state_21020[(7)]);
var inst_20992 = (state_21020[(10)]);
var inst_21000 = (state_21020[(8)]);
var inst_21004 = (function (){var cs = inst_20992;
var vec__20997 = inst_20999;
var v = inst_21000;
var c = inst_21001;
return ((function (cs,vec__20997,v,c,inst_21001,inst_20999,inst_20992,inst_21000,state_val_21021,c__11094__auto___21048,out){
return (function (p1__20987_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20987_SHARP_);
});
;})(cs,vec__20997,v,c,inst_21001,inst_20999,inst_20992,inst_21000,state_val_21021,c__11094__auto___21048,out))
})();
var inst_21005 = cljs.core.filterv.call(null,inst_21004,inst_20992);
var inst_20992__$1 = inst_21005;
var state_21020__$1 = (function (){var statearr_21035 = state_21020;
(statearr_21035[(10)] = inst_20992__$1);

return statearr_21035;
})();
var statearr_21036_21058 = state_21020__$1;
(statearr_21036_21058[(2)] = null);

(statearr_21036_21058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___21048,out))
;
return ((function (switch__10982__auto__,c__11094__auto___21048,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_21040 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21040[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_21040[(1)] = (1));

return statearr_21040;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_21020){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_21020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e21041){if((e21041 instanceof Object)){
var ex__10986__auto__ = e21041;
var statearr_21042_21059 = state_21020;
(statearr_21042_21059[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21020);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21060 = state_21020;
state_21020 = G__21060;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_21020){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_21020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___21048,out))
})();
var state__11096__auto__ = (function (){var statearr_21043 = f__11095__auto__.call(null);
(statearr_21043[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___21048);

return statearr_21043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___21048,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args21061 = [];
var len__5726__auto___21110 = arguments.length;
var i__5727__auto___21111 = (0);
while(true){
if((i__5727__auto___21111 < len__5726__auto___21110)){
args21061.push((arguments[i__5727__auto___21111]));

var G__21112 = (i__5727__auto___21111 + (1));
i__5727__auto___21111 = G__21112;
continue;
} else {
}
break;
}

var G__21063 = args21061.length;
switch (G__21063) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21061.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___21114 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___21114,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___21114,out){
return (function (state_21087){
var state_val_21088 = (state_21087[(1)]);
if((state_val_21088 === (7))){
var inst_21069 = (state_21087[(7)]);
var inst_21069__$1 = (state_21087[(2)]);
var inst_21070 = (inst_21069__$1 == null);
var inst_21071 = cljs.core.not.call(null,inst_21070);
var state_21087__$1 = (function (){var statearr_21089 = state_21087;
(statearr_21089[(7)] = inst_21069__$1);

return statearr_21089;
})();
if(inst_21071){
var statearr_21090_21115 = state_21087__$1;
(statearr_21090_21115[(1)] = (8));

} else {
var statearr_21091_21116 = state_21087__$1;
(statearr_21091_21116[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21088 === (1))){
var inst_21064 = (0);
var state_21087__$1 = (function (){var statearr_21092 = state_21087;
(statearr_21092[(8)] = inst_21064);

return statearr_21092;
})();
var statearr_21093_21117 = state_21087__$1;
(statearr_21093_21117[(2)] = null);

(statearr_21093_21117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21088 === (4))){
var state_21087__$1 = state_21087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21087__$1,(7),ch);
} else {
if((state_val_21088 === (6))){
var inst_21082 = (state_21087[(2)]);
var state_21087__$1 = state_21087;
var statearr_21094_21118 = state_21087__$1;
(statearr_21094_21118[(2)] = inst_21082);

(statearr_21094_21118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21088 === (3))){
var inst_21084 = (state_21087[(2)]);
var inst_21085 = cljs.core.async.close_BANG_.call(null,out);
var state_21087__$1 = (function (){var statearr_21095 = state_21087;
(statearr_21095[(9)] = inst_21084);

return statearr_21095;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21087__$1,inst_21085);
} else {
if((state_val_21088 === (2))){
var inst_21064 = (state_21087[(8)]);
var inst_21066 = (inst_21064 < n);
var state_21087__$1 = state_21087;
if(cljs.core.truth_(inst_21066)){
var statearr_21096_21119 = state_21087__$1;
(statearr_21096_21119[(1)] = (4));

} else {
var statearr_21097_21120 = state_21087__$1;
(statearr_21097_21120[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21088 === (11))){
var inst_21064 = (state_21087[(8)]);
var inst_21074 = (state_21087[(2)]);
var inst_21075 = (inst_21064 + (1));
var inst_21064__$1 = inst_21075;
var state_21087__$1 = (function (){var statearr_21098 = state_21087;
(statearr_21098[(8)] = inst_21064__$1);

(statearr_21098[(10)] = inst_21074);

return statearr_21098;
})();
var statearr_21099_21121 = state_21087__$1;
(statearr_21099_21121[(2)] = null);

(statearr_21099_21121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21088 === (9))){
var state_21087__$1 = state_21087;
var statearr_21100_21122 = state_21087__$1;
(statearr_21100_21122[(2)] = null);

(statearr_21100_21122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21088 === (5))){
var state_21087__$1 = state_21087;
var statearr_21101_21123 = state_21087__$1;
(statearr_21101_21123[(2)] = null);

(statearr_21101_21123[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21088 === (10))){
var inst_21079 = (state_21087[(2)]);
var state_21087__$1 = state_21087;
var statearr_21102_21124 = state_21087__$1;
(statearr_21102_21124[(2)] = inst_21079);

(statearr_21102_21124[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21088 === (8))){
var inst_21069 = (state_21087[(7)]);
var state_21087__$1 = state_21087;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21087__$1,(11),out,inst_21069);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___21114,out))
;
return ((function (switch__10982__auto__,c__11094__auto___21114,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_21106 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21106[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_21106[(1)] = (1));

return statearr_21106;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_21087){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_21087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e21107){if((e21107 instanceof Object)){
var ex__10986__auto__ = e21107;
var statearr_21108_21125 = state_21087;
(statearr_21108_21125[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21087);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21107;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21126 = state_21087;
state_21087 = G__21126;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_21087){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_21087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___21114,out))
})();
var state__11096__auto__ = (function (){var statearr_21109 = f__11095__auto__.call(null);
(statearr_21109[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___21114);

return statearr_21109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___21114,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21134 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21134 = (function (map_LT_,f,ch,meta21135){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21135 = meta21135;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21136,meta21135__$1){
var self__ = this;
var _21136__$1 = this;
return (new cljs.core.async.t_cljs$core$async21134(self__.map_LT_,self__.f,self__.ch,meta21135__$1));
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21136){
var self__ = this;
var _21136__$1 = this;
return self__.meta21135;
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21137 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21137 = (function (map_LT_,f,ch,meta21135,_,fn1,meta21138){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21135 = meta21135;
this._ = _;
this.fn1 = fn1;
this.meta21138 = meta21138;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21137.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21139,meta21138__$1){
var self__ = this;
var _21139__$1 = this;
return (new cljs.core.async.t_cljs$core$async21137(self__.map_LT_,self__.f,self__.ch,self__.meta21135,self__._,self__.fn1,meta21138__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21137.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21139){
var self__ = this;
var _21139__$1 = this;
return self__.meta21138;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21137.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21137.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21137.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21137.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21127_SHARP_){
return f1.call(null,(((p1__21127_SHARP_ == null))?null:self__.f.call(null,p1__21127_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21137.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21135","meta21135",-32798175,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21134","cljs.core.async/t_cljs$core$async21134",-985314720,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21138","meta21138",-856621022,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21137.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21137.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21137";

cljs.core.async.t_cljs$core$async21137.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21137");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21137 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21137(map_LT___$1,f__$1,ch__$1,meta21135__$1,___$2,fn1__$1,meta21138){
return (new cljs.core.async.t_cljs$core$async21137(map_LT___$1,f__$1,ch__$1,meta21135__$1,___$2,fn1__$1,meta21138));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21137(self__.map_LT_,self__.f,self__.ch,self__.meta21135,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21134.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21134.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21135","meta21135",-32798175,null)], null);
});

cljs.core.async.t_cljs$core$async21134.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21134.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21134";

cljs.core.async.t_cljs$core$async21134.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21134");
});

cljs.core.async.__GT_t_cljs$core$async21134 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21134(map_LT___$1,f__$1,ch__$1,meta21135){
return (new cljs.core.async.t_cljs$core$async21134(map_LT___$1,f__$1,ch__$1,meta21135));
});

}

return (new cljs.core.async.t_cljs$core$async21134(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21143 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21143 = (function (map_GT_,f,ch,meta21144){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21144 = meta21144;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21143.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21145,meta21144__$1){
var self__ = this;
var _21145__$1 = this;
return (new cljs.core.async.t_cljs$core$async21143(self__.map_GT_,self__.f,self__.ch,meta21144__$1));
});

cljs.core.async.t_cljs$core$async21143.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21145){
var self__ = this;
var _21145__$1 = this;
return self__.meta21144;
});

cljs.core.async.t_cljs$core$async21143.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21143.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21143.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21143.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21143.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21143.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21143.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21144","meta21144",1504725821,null)], null);
});

cljs.core.async.t_cljs$core$async21143.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21143.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21143";

cljs.core.async.t_cljs$core$async21143.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21143");
});

cljs.core.async.__GT_t_cljs$core$async21143 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21143(map_GT___$1,f__$1,ch__$1,meta21144){
return (new cljs.core.async.t_cljs$core$async21143(map_GT___$1,f__$1,ch__$1,meta21144));
});

}

return (new cljs.core.async.t_cljs$core$async21143(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21149 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21149 = (function (filter_GT_,p,ch,meta21150){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21150 = meta21150;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21151,meta21150__$1){
var self__ = this;
var _21151__$1 = this;
return (new cljs.core.async.t_cljs$core$async21149(self__.filter_GT_,self__.p,self__.ch,meta21150__$1));
});

cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21151){
var self__ = this;
var _21151__$1 = this;
return self__.meta21150;
});

cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21149.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21149.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21150","meta21150",1483297866,null)], null);
});

cljs.core.async.t_cljs$core$async21149.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21149.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21149";

cljs.core.async.t_cljs$core$async21149.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21149");
});

cljs.core.async.__GT_t_cljs$core$async21149 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21149(filter_GT___$1,p__$1,ch__$1,meta21150){
return (new cljs.core.async.t_cljs$core$async21149(filter_GT___$1,p__$1,ch__$1,meta21150));
});

}

return (new cljs.core.async.t_cljs$core$async21149(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21152 = [];
var len__5726__auto___21196 = arguments.length;
var i__5727__auto___21197 = (0);
while(true){
if((i__5727__auto___21197 < len__5726__auto___21196)){
args21152.push((arguments[i__5727__auto___21197]));

var G__21198 = (i__5727__auto___21197 + (1));
i__5727__auto___21197 = G__21198;
continue;
} else {
}
break;
}

var G__21154 = args21152.length;
switch (G__21154) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21152.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___21200 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___21200,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___21200,out){
return (function (state_21175){
var state_val_21176 = (state_21175[(1)]);
if((state_val_21176 === (7))){
var inst_21171 = (state_21175[(2)]);
var state_21175__$1 = state_21175;
var statearr_21177_21201 = state_21175__$1;
(statearr_21177_21201[(2)] = inst_21171);

(statearr_21177_21201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21176 === (1))){
var state_21175__$1 = state_21175;
var statearr_21178_21202 = state_21175__$1;
(statearr_21178_21202[(2)] = null);

(statearr_21178_21202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21176 === (4))){
var inst_21157 = (state_21175[(7)]);
var inst_21157__$1 = (state_21175[(2)]);
var inst_21158 = (inst_21157__$1 == null);
var state_21175__$1 = (function (){var statearr_21179 = state_21175;
(statearr_21179[(7)] = inst_21157__$1);

return statearr_21179;
})();
if(cljs.core.truth_(inst_21158)){
var statearr_21180_21203 = state_21175__$1;
(statearr_21180_21203[(1)] = (5));

} else {
var statearr_21181_21204 = state_21175__$1;
(statearr_21181_21204[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21176 === (6))){
var inst_21157 = (state_21175[(7)]);
var inst_21162 = p.call(null,inst_21157);
var state_21175__$1 = state_21175;
if(cljs.core.truth_(inst_21162)){
var statearr_21182_21205 = state_21175__$1;
(statearr_21182_21205[(1)] = (8));

} else {
var statearr_21183_21206 = state_21175__$1;
(statearr_21183_21206[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21176 === (3))){
var inst_21173 = (state_21175[(2)]);
var state_21175__$1 = state_21175;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21175__$1,inst_21173);
} else {
if((state_val_21176 === (2))){
var state_21175__$1 = state_21175;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21175__$1,(4),ch);
} else {
if((state_val_21176 === (11))){
var inst_21165 = (state_21175[(2)]);
var state_21175__$1 = state_21175;
var statearr_21184_21207 = state_21175__$1;
(statearr_21184_21207[(2)] = inst_21165);

(statearr_21184_21207[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21176 === (9))){
var state_21175__$1 = state_21175;
var statearr_21185_21208 = state_21175__$1;
(statearr_21185_21208[(2)] = null);

(statearr_21185_21208[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21176 === (5))){
var inst_21160 = cljs.core.async.close_BANG_.call(null,out);
var state_21175__$1 = state_21175;
var statearr_21186_21209 = state_21175__$1;
(statearr_21186_21209[(2)] = inst_21160);

(statearr_21186_21209[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21176 === (10))){
var inst_21168 = (state_21175[(2)]);
var state_21175__$1 = (function (){var statearr_21187 = state_21175;
(statearr_21187[(8)] = inst_21168);

return statearr_21187;
})();
var statearr_21188_21210 = state_21175__$1;
(statearr_21188_21210[(2)] = null);

(statearr_21188_21210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21176 === (8))){
var inst_21157 = (state_21175[(7)]);
var state_21175__$1 = state_21175;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21175__$1,(11),out,inst_21157);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___21200,out))
;
return ((function (switch__10982__auto__,c__11094__auto___21200,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_21192 = [null,null,null,null,null,null,null,null,null];
(statearr_21192[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_21192[(1)] = (1));

return statearr_21192;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_21175){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_21175);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e21193){if((e21193 instanceof Object)){
var ex__10986__auto__ = e21193;
var statearr_21194_21211 = state_21175;
(statearr_21194_21211[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21175);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21193;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21212 = state_21175;
state_21175 = G__21212;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_21175){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_21175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___21200,out))
})();
var state__11096__auto__ = (function (){var statearr_21195 = f__11095__auto__.call(null);
(statearr_21195[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___21200);

return statearr_21195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___21200,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21213 = [];
var len__5726__auto___21216 = arguments.length;
var i__5727__auto___21217 = (0);
while(true){
if((i__5727__auto___21217 < len__5726__auto___21216)){
args21213.push((arguments[i__5727__auto___21217]));

var G__21218 = (i__5727__auto___21217 + (1));
i__5727__auto___21217 = G__21218;
continue;
} else {
}
break;
}

var G__21215 = args21213.length;
switch (G__21215) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21213.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11094__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto__){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto__){
return (function (state_21385){
var state_val_21386 = (state_21385[(1)]);
if((state_val_21386 === (7))){
var inst_21381 = (state_21385[(2)]);
var state_21385__$1 = state_21385;
var statearr_21387_21428 = state_21385__$1;
(statearr_21387_21428[(2)] = inst_21381);

(statearr_21387_21428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (20))){
var inst_21351 = (state_21385[(7)]);
var inst_21362 = (state_21385[(2)]);
var inst_21363 = cljs.core.next.call(null,inst_21351);
var inst_21337 = inst_21363;
var inst_21338 = null;
var inst_21339 = (0);
var inst_21340 = (0);
var state_21385__$1 = (function (){var statearr_21388 = state_21385;
(statearr_21388[(8)] = inst_21339);

(statearr_21388[(9)] = inst_21338);

(statearr_21388[(10)] = inst_21337);

(statearr_21388[(11)] = inst_21340);

(statearr_21388[(12)] = inst_21362);

return statearr_21388;
})();
var statearr_21389_21429 = state_21385__$1;
(statearr_21389_21429[(2)] = null);

(statearr_21389_21429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (1))){
var state_21385__$1 = state_21385;
var statearr_21390_21430 = state_21385__$1;
(statearr_21390_21430[(2)] = null);

(statearr_21390_21430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (4))){
var inst_21326 = (state_21385[(13)]);
var inst_21326__$1 = (state_21385[(2)]);
var inst_21327 = (inst_21326__$1 == null);
var state_21385__$1 = (function (){var statearr_21391 = state_21385;
(statearr_21391[(13)] = inst_21326__$1);

return statearr_21391;
})();
if(cljs.core.truth_(inst_21327)){
var statearr_21392_21431 = state_21385__$1;
(statearr_21392_21431[(1)] = (5));

} else {
var statearr_21393_21432 = state_21385__$1;
(statearr_21393_21432[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (15))){
var state_21385__$1 = state_21385;
var statearr_21397_21433 = state_21385__$1;
(statearr_21397_21433[(2)] = null);

(statearr_21397_21433[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (21))){
var state_21385__$1 = state_21385;
var statearr_21398_21434 = state_21385__$1;
(statearr_21398_21434[(2)] = null);

(statearr_21398_21434[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (13))){
var inst_21339 = (state_21385[(8)]);
var inst_21338 = (state_21385[(9)]);
var inst_21337 = (state_21385[(10)]);
var inst_21340 = (state_21385[(11)]);
var inst_21347 = (state_21385[(2)]);
var inst_21348 = (inst_21340 + (1));
var tmp21394 = inst_21339;
var tmp21395 = inst_21338;
var tmp21396 = inst_21337;
var inst_21337__$1 = tmp21396;
var inst_21338__$1 = tmp21395;
var inst_21339__$1 = tmp21394;
var inst_21340__$1 = inst_21348;
var state_21385__$1 = (function (){var statearr_21399 = state_21385;
(statearr_21399[(8)] = inst_21339__$1);

(statearr_21399[(9)] = inst_21338__$1);

(statearr_21399[(10)] = inst_21337__$1);

(statearr_21399[(11)] = inst_21340__$1);

(statearr_21399[(14)] = inst_21347);

return statearr_21399;
})();
var statearr_21400_21435 = state_21385__$1;
(statearr_21400_21435[(2)] = null);

(statearr_21400_21435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (22))){
var state_21385__$1 = state_21385;
var statearr_21401_21436 = state_21385__$1;
(statearr_21401_21436[(2)] = null);

(statearr_21401_21436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (6))){
var inst_21326 = (state_21385[(13)]);
var inst_21335 = f.call(null,inst_21326);
var inst_21336 = cljs.core.seq.call(null,inst_21335);
var inst_21337 = inst_21336;
var inst_21338 = null;
var inst_21339 = (0);
var inst_21340 = (0);
var state_21385__$1 = (function (){var statearr_21402 = state_21385;
(statearr_21402[(8)] = inst_21339);

(statearr_21402[(9)] = inst_21338);

(statearr_21402[(10)] = inst_21337);

(statearr_21402[(11)] = inst_21340);

return statearr_21402;
})();
var statearr_21403_21437 = state_21385__$1;
(statearr_21403_21437[(2)] = null);

(statearr_21403_21437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (17))){
var inst_21351 = (state_21385[(7)]);
var inst_21355 = cljs.core.chunk_first.call(null,inst_21351);
var inst_21356 = cljs.core.chunk_rest.call(null,inst_21351);
var inst_21357 = cljs.core.count.call(null,inst_21355);
var inst_21337 = inst_21356;
var inst_21338 = inst_21355;
var inst_21339 = inst_21357;
var inst_21340 = (0);
var state_21385__$1 = (function (){var statearr_21404 = state_21385;
(statearr_21404[(8)] = inst_21339);

(statearr_21404[(9)] = inst_21338);

(statearr_21404[(10)] = inst_21337);

(statearr_21404[(11)] = inst_21340);

return statearr_21404;
})();
var statearr_21405_21438 = state_21385__$1;
(statearr_21405_21438[(2)] = null);

(statearr_21405_21438[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (3))){
var inst_21383 = (state_21385[(2)]);
var state_21385__$1 = state_21385;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21385__$1,inst_21383);
} else {
if((state_val_21386 === (12))){
var inst_21371 = (state_21385[(2)]);
var state_21385__$1 = state_21385;
var statearr_21406_21439 = state_21385__$1;
(statearr_21406_21439[(2)] = inst_21371);

(statearr_21406_21439[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (2))){
var state_21385__$1 = state_21385;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21385__$1,(4),in$);
} else {
if((state_val_21386 === (23))){
var inst_21379 = (state_21385[(2)]);
var state_21385__$1 = state_21385;
var statearr_21407_21440 = state_21385__$1;
(statearr_21407_21440[(2)] = inst_21379);

(statearr_21407_21440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (19))){
var inst_21366 = (state_21385[(2)]);
var state_21385__$1 = state_21385;
var statearr_21408_21441 = state_21385__$1;
(statearr_21408_21441[(2)] = inst_21366);

(statearr_21408_21441[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (11))){
var inst_21351 = (state_21385[(7)]);
var inst_21337 = (state_21385[(10)]);
var inst_21351__$1 = cljs.core.seq.call(null,inst_21337);
var state_21385__$1 = (function (){var statearr_21409 = state_21385;
(statearr_21409[(7)] = inst_21351__$1);

return statearr_21409;
})();
if(inst_21351__$1){
var statearr_21410_21442 = state_21385__$1;
(statearr_21410_21442[(1)] = (14));

} else {
var statearr_21411_21443 = state_21385__$1;
(statearr_21411_21443[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (9))){
var inst_21373 = (state_21385[(2)]);
var inst_21374 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21385__$1 = (function (){var statearr_21412 = state_21385;
(statearr_21412[(15)] = inst_21373);

return statearr_21412;
})();
if(cljs.core.truth_(inst_21374)){
var statearr_21413_21444 = state_21385__$1;
(statearr_21413_21444[(1)] = (21));

} else {
var statearr_21414_21445 = state_21385__$1;
(statearr_21414_21445[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (5))){
var inst_21329 = cljs.core.async.close_BANG_.call(null,out);
var state_21385__$1 = state_21385;
var statearr_21415_21446 = state_21385__$1;
(statearr_21415_21446[(2)] = inst_21329);

(statearr_21415_21446[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (14))){
var inst_21351 = (state_21385[(7)]);
var inst_21353 = cljs.core.chunked_seq_QMARK_.call(null,inst_21351);
var state_21385__$1 = state_21385;
if(inst_21353){
var statearr_21416_21447 = state_21385__$1;
(statearr_21416_21447[(1)] = (17));

} else {
var statearr_21417_21448 = state_21385__$1;
(statearr_21417_21448[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (16))){
var inst_21369 = (state_21385[(2)]);
var state_21385__$1 = state_21385;
var statearr_21418_21449 = state_21385__$1;
(statearr_21418_21449[(2)] = inst_21369);

(statearr_21418_21449[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21386 === (10))){
var inst_21338 = (state_21385[(9)]);
var inst_21340 = (state_21385[(11)]);
var inst_21345 = cljs.core._nth.call(null,inst_21338,inst_21340);
var state_21385__$1 = state_21385;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21385__$1,(13),out,inst_21345);
} else {
if((state_val_21386 === (18))){
var inst_21351 = (state_21385[(7)]);
var inst_21360 = cljs.core.first.call(null,inst_21351);
var state_21385__$1 = state_21385;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21385__$1,(20),out,inst_21360);
} else {
if((state_val_21386 === (8))){
var inst_21339 = (state_21385[(8)]);
var inst_21340 = (state_21385[(11)]);
var inst_21342 = (inst_21340 < inst_21339);
var inst_21343 = inst_21342;
var state_21385__$1 = state_21385;
if(cljs.core.truth_(inst_21343)){
var statearr_21419_21450 = state_21385__$1;
(statearr_21419_21450[(1)] = (10));

} else {
var statearr_21420_21451 = state_21385__$1;
(statearr_21420_21451[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto__))
;
return ((function (switch__10982__auto__,c__11094__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____0 = (function (){
var statearr_21424 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21424[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__);

(statearr_21424[(1)] = (1));

return statearr_21424;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____1 = (function (state_21385){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_21385);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e21425){if((e21425 instanceof Object)){
var ex__10986__auto__ = e21425;
var statearr_21426_21452 = state_21385;
(statearr_21426_21452[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21385);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21425;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21453 = state_21385;
state_21385 = G__21453;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__ = function(state_21385){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____1.call(this,state_21385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10983__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto__))
})();
var state__11096__auto__ = (function (){var statearr_21427 = f__11095__auto__.call(null);
(statearr_21427[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto__);

return statearr_21427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto__))
);

return c__11094__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21454 = [];
var len__5726__auto___21457 = arguments.length;
var i__5727__auto___21458 = (0);
while(true){
if((i__5727__auto___21458 < len__5726__auto___21457)){
args21454.push((arguments[i__5727__auto___21458]));

var G__21459 = (i__5727__auto___21458 + (1));
i__5727__auto___21458 = G__21459;
continue;
} else {
}
break;
}

var G__21456 = args21454.length;
switch (G__21456) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21454.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21461 = [];
var len__5726__auto___21464 = arguments.length;
var i__5727__auto___21465 = (0);
while(true){
if((i__5727__auto___21465 < len__5726__auto___21464)){
args21461.push((arguments[i__5727__auto___21465]));

var G__21466 = (i__5727__auto___21465 + (1));
i__5727__auto___21465 = G__21466;
continue;
} else {
}
break;
}

var G__21463 = args21461.length;
switch (G__21463) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21461.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21468 = [];
var len__5726__auto___21519 = arguments.length;
var i__5727__auto___21520 = (0);
while(true){
if((i__5727__auto___21520 < len__5726__auto___21519)){
args21468.push((arguments[i__5727__auto___21520]));

var G__21521 = (i__5727__auto___21520 + (1));
i__5727__auto___21520 = G__21521;
continue;
} else {
}
break;
}

var G__21470 = args21468.length;
switch (G__21470) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21468.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___21523 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___21523,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___21523,out){
return (function (state_21494){
var state_val_21495 = (state_21494[(1)]);
if((state_val_21495 === (7))){
var inst_21489 = (state_21494[(2)]);
var state_21494__$1 = state_21494;
var statearr_21496_21524 = state_21494__$1;
(statearr_21496_21524[(2)] = inst_21489);

(statearr_21496_21524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21495 === (1))){
var inst_21471 = null;
var state_21494__$1 = (function (){var statearr_21497 = state_21494;
(statearr_21497[(7)] = inst_21471);

return statearr_21497;
})();
var statearr_21498_21525 = state_21494__$1;
(statearr_21498_21525[(2)] = null);

(statearr_21498_21525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21495 === (4))){
var inst_21474 = (state_21494[(8)]);
var inst_21474__$1 = (state_21494[(2)]);
var inst_21475 = (inst_21474__$1 == null);
var inst_21476 = cljs.core.not.call(null,inst_21475);
var state_21494__$1 = (function (){var statearr_21499 = state_21494;
(statearr_21499[(8)] = inst_21474__$1);

return statearr_21499;
})();
if(inst_21476){
var statearr_21500_21526 = state_21494__$1;
(statearr_21500_21526[(1)] = (5));

} else {
var statearr_21501_21527 = state_21494__$1;
(statearr_21501_21527[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21495 === (6))){
var state_21494__$1 = state_21494;
var statearr_21502_21528 = state_21494__$1;
(statearr_21502_21528[(2)] = null);

(statearr_21502_21528[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21495 === (3))){
var inst_21491 = (state_21494[(2)]);
var inst_21492 = cljs.core.async.close_BANG_.call(null,out);
var state_21494__$1 = (function (){var statearr_21503 = state_21494;
(statearr_21503[(9)] = inst_21491);

return statearr_21503;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21494__$1,inst_21492);
} else {
if((state_val_21495 === (2))){
var state_21494__$1 = state_21494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21494__$1,(4),ch);
} else {
if((state_val_21495 === (11))){
var inst_21474 = (state_21494[(8)]);
var inst_21483 = (state_21494[(2)]);
var inst_21471 = inst_21474;
var state_21494__$1 = (function (){var statearr_21504 = state_21494;
(statearr_21504[(7)] = inst_21471);

(statearr_21504[(10)] = inst_21483);

return statearr_21504;
})();
var statearr_21505_21529 = state_21494__$1;
(statearr_21505_21529[(2)] = null);

(statearr_21505_21529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21495 === (9))){
var inst_21474 = (state_21494[(8)]);
var state_21494__$1 = state_21494;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21494__$1,(11),out,inst_21474);
} else {
if((state_val_21495 === (5))){
var inst_21471 = (state_21494[(7)]);
var inst_21474 = (state_21494[(8)]);
var inst_21478 = cljs.core._EQ_.call(null,inst_21474,inst_21471);
var state_21494__$1 = state_21494;
if(inst_21478){
var statearr_21507_21530 = state_21494__$1;
(statearr_21507_21530[(1)] = (8));

} else {
var statearr_21508_21531 = state_21494__$1;
(statearr_21508_21531[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21495 === (10))){
var inst_21486 = (state_21494[(2)]);
var state_21494__$1 = state_21494;
var statearr_21509_21532 = state_21494__$1;
(statearr_21509_21532[(2)] = inst_21486);

(statearr_21509_21532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21495 === (8))){
var inst_21471 = (state_21494[(7)]);
var tmp21506 = inst_21471;
var inst_21471__$1 = tmp21506;
var state_21494__$1 = (function (){var statearr_21510 = state_21494;
(statearr_21510[(7)] = inst_21471__$1);

return statearr_21510;
})();
var statearr_21511_21533 = state_21494__$1;
(statearr_21511_21533[(2)] = null);

(statearr_21511_21533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___21523,out))
;
return ((function (switch__10982__auto__,c__11094__auto___21523,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_21515 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21515[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_21515[(1)] = (1));

return statearr_21515;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_21494){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_21494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e21516){if((e21516 instanceof Object)){
var ex__10986__auto__ = e21516;
var statearr_21517_21534 = state_21494;
(statearr_21517_21534[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21494);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21516;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21535 = state_21494;
state_21494 = G__21535;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_21494){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_21494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___21523,out))
})();
var state__11096__auto__ = (function (){var statearr_21518 = f__11095__auto__.call(null);
(statearr_21518[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___21523);

return statearr_21518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___21523,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21536 = [];
var len__5726__auto___21606 = arguments.length;
var i__5727__auto___21607 = (0);
while(true){
if((i__5727__auto___21607 < len__5726__auto___21606)){
args21536.push((arguments[i__5727__auto___21607]));

var G__21608 = (i__5727__auto___21607 + (1));
i__5727__auto___21607 = G__21608;
continue;
} else {
}
break;
}

var G__21538 = args21536.length;
switch (G__21538) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21536.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___21610 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___21610,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___21610,out){
return (function (state_21576){
var state_val_21577 = (state_21576[(1)]);
if((state_val_21577 === (7))){
var inst_21572 = (state_21576[(2)]);
var state_21576__$1 = state_21576;
var statearr_21578_21611 = state_21576__$1;
(statearr_21578_21611[(2)] = inst_21572);

(statearr_21578_21611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (1))){
var inst_21539 = (new Array(n));
var inst_21540 = inst_21539;
var inst_21541 = (0);
var state_21576__$1 = (function (){var statearr_21579 = state_21576;
(statearr_21579[(7)] = inst_21540);

(statearr_21579[(8)] = inst_21541);

return statearr_21579;
})();
var statearr_21580_21612 = state_21576__$1;
(statearr_21580_21612[(2)] = null);

(statearr_21580_21612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (4))){
var inst_21544 = (state_21576[(9)]);
var inst_21544__$1 = (state_21576[(2)]);
var inst_21545 = (inst_21544__$1 == null);
var inst_21546 = cljs.core.not.call(null,inst_21545);
var state_21576__$1 = (function (){var statearr_21581 = state_21576;
(statearr_21581[(9)] = inst_21544__$1);

return statearr_21581;
})();
if(inst_21546){
var statearr_21582_21613 = state_21576__$1;
(statearr_21582_21613[(1)] = (5));

} else {
var statearr_21583_21614 = state_21576__$1;
(statearr_21583_21614[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (15))){
var inst_21566 = (state_21576[(2)]);
var state_21576__$1 = state_21576;
var statearr_21584_21615 = state_21576__$1;
(statearr_21584_21615[(2)] = inst_21566);

(statearr_21584_21615[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (13))){
var state_21576__$1 = state_21576;
var statearr_21585_21616 = state_21576__$1;
(statearr_21585_21616[(2)] = null);

(statearr_21585_21616[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (6))){
var inst_21541 = (state_21576[(8)]);
var inst_21562 = (inst_21541 > (0));
var state_21576__$1 = state_21576;
if(cljs.core.truth_(inst_21562)){
var statearr_21586_21617 = state_21576__$1;
(statearr_21586_21617[(1)] = (12));

} else {
var statearr_21587_21618 = state_21576__$1;
(statearr_21587_21618[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (3))){
var inst_21574 = (state_21576[(2)]);
var state_21576__$1 = state_21576;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21576__$1,inst_21574);
} else {
if((state_val_21577 === (12))){
var inst_21540 = (state_21576[(7)]);
var inst_21564 = cljs.core.vec.call(null,inst_21540);
var state_21576__$1 = state_21576;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21576__$1,(15),out,inst_21564);
} else {
if((state_val_21577 === (2))){
var state_21576__$1 = state_21576;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21576__$1,(4),ch);
} else {
if((state_val_21577 === (11))){
var inst_21556 = (state_21576[(2)]);
var inst_21557 = (new Array(n));
var inst_21540 = inst_21557;
var inst_21541 = (0);
var state_21576__$1 = (function (){var statearr_21588 = state_21576;
(statearr_21588[(10)] = inst_21556);

(statearr_21588[(7)] = inst_21540);

(statearr_21588[(8)] = inst_21541);

return statearr_21588;
})();
var statearr_21589_21619 = state_21576__$1;
(statearr_21589_21619[(2)] = null);

(statearr_21589_21619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (9))){
var inst_21540 = (state_21576[(7)]);
var inst_21554 = cljs.core.vec.call(null,inst_21540);
var state_21576__$1 = state_21576;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21576__$1,(11),out,inst_21554);
} else {
if((state_val_21577 === (5))){
var inst_21540 = (state_21576[(7)]);
var inst_21541 = (state_21576[(8)]);
var inst_21544 = (state_21576[(9)]);
var inst_21549 = (state_21576[(11)]);
var inst_21548 = (inst_21540[inst_21541] = inst_21544);
var inst_21549__$1 = (inst_21541 + (1));
var inst_21550 = (inst_21549__$1 < n);
var state_21576__$1 = (function (){var statearr_21590 = state_21576;
(statearr_21590[(12)] = inst_21548);

(statearr_21590[(11)] = inst_21549__$1);

return statearr_21590;
})();
if(cljs.core.truth_(inst_21550)){
var statearr_21591_21620 = state_21576__$1;
(statearr_21591_21620[(1)] = (8));

} else {
var statearr_21592_21621 = state_21576__$1;
(statearr_21592_21621[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (14))){
var inst_21569 = (state_21576[(2)]);
var inst_21570 = cljs.core.async.close_BANG_.call(null,out);
var state_21576__$1 = (function (){var statearr_21594 = state_21576;
(statearr_21594[(13)] = inst_21569);

return statearr_21594;
})();
var statearr_21595_21622 = state_21576__$1;
(statearr_21595_21622[(2)] = inst_21570);

(statearr_21595_21622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (10))){
var inst_21560 = (state_21576[(2)]);
var state_21576__$1 = state_21576;
var statearr_21596_21623 = state_21576__$1;
(statearr_21596_21623[(2)] = inst_21560);

(statearr_21596_21623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21577 === (8))){
var inst_21540 = (state_21576[(7)]);
var inst_21549 = (state_21576[(11)]);
var tmp21593 = inst_21540;
var inst_21540__$1 = tmp21593;
var inst_21541 = inst_21549;
var state_21576__$1 = (function (){var statearr_21597 = state_21576;
(statearr_21597[(7)] = inst_21540__$1);

(statearr_21597[(8)] = inst_21541);

return statearr_21597;
})();
var statearr_21598_21624 = state_21576__$1;
(statearr_21598_21624[(2)] = null);

(statearr_21598_21624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___21610,out))
;
return ((function (switch__10982__auto__,c__11094__auto___21610,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_21602 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21602[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_21602[(1)] = (1));

return statearr_21602;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_21576){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_21576);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e21603){if((e21603 instanceof Object)){
var ex__10986__auto__ = e21603;
var statearr_21604_21625 = state_21576;
(statearr_21604_21625[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21576);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21603;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21626 = state_21576;
state_21576 = G__21626;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_21576){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_21576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___21610,out))
})();
var state__11096__auto__ = (function (){var statearr_21605 = f__11095__auto__.call(null);
(statearr_21605[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___21610);

return statearr_21605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___21610,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21627 = [];
var len__5726__auto___21701 = arguments.length;
var i__5727__auto___21702 = (0);
while(true){
if((i__5727__auto___21702 < len__5726__auto___21701)){
args21627.push((arguments[i__5727__auto___21702]));

var G__21703 = (i__5727__auto___21702 + (1));
i__5727__auto___21702 = G__21703;
continue;
} else {
}
break;
}

var G__21629 = args21627.length;
switch (G__21629) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21627.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11094__auto___21705 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11094__auto___21705,out){
return (function (){
var f__11095__auto__ = (function (){var switch__10982__auto__ = ((function (c__11094__auto___21705,out){
return (function (state_21671){
var state_val_21672 = (state_21671[(1)]);
if((state_val_21672 === (7))){
var inst_21667 = (state_21671[(2)]);
var state_21671__$1 = state_21671;
var statearr_21673_21706 = state_21671__$1;
(statearr_21673_21706[(2)] = inst_21667);

(statearr_21673_21706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (1))){
var inst_21630 = [];
var inst_21631 = inst_21630;
var inst_21632 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21671__$1 = (function (){var statearr_21674 = state_21671;
(statearr_21674[(7)] = inst_21631);

(statearr_21674[(8)] = inst_21632);

return statearr_21674;
})();
var statearr_21675_21707 = state_21671__$1;
(statearr_21675_21707[(2)] = null);

(statearr_21675_21707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (4))){
var inst_21635 = (state_21671[(9)]);
var inst_21635__$1 = (state_21671[(2)]);
var inst_21636 = (inst_21635__$1 == null);
var inst_21637 = cljs.core.not.call(null,inst_21636);
var state_21671__$1 = (function (){var statearr_21676 = state_21671;
(statearr_21676[(9)] = inst_21635__$1);

return statearr_21676;
})();
if(inst_21637){
var statearr_21677_21708 = state_21671__$1;
(statearr_21677_21708[(1)] = (5));

} else {
var statearr_21678_21709 = state_21671__$1;
(statearr_21678_21709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (15))){
var inst_21661 = (state_21671[(2)]);
var state_21671__$1 = state_21671;
var statearr_21679_21710 = state_21671__$1;
(statearr_21679_21710[(2)] = inst_21661);

(statearr_21679_21710[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (13))){
var state_21671__$1 = state_21671;
var statearr_21680_21711 = state_21671__$1;
(statearr_21680_21711[(2)] = null);

(statearr_21680_21711[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (6))){
var inst_21631 = (state_21671[(7)]);
var inst_21656 = inst_21631.length;
var inst_21657 = (inst_21656 > (0));
var state_21671__$1 = state_21671;
if(cljs.core.truth_(inst_21657)){
var statearr_21681_21712 = state_21671__$1;
(statearr_21681_21712[(1)] = (12));

} else {
var statearr_21682_21713 = state_21671__$1;
(statearr_21682_21713[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (3))){
var inst_21669 = (state_21671[(2)]);
var state_21671__$1 = state_21671;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21671__$1,inst_21669);
} else {
if((state_val_21672 === (12))){
var inst_21631 = (state_21671[(7)]);
var inst_21659 = cljs.core.vec.call(null,inst_21631);
var state_21671__$1 = state_21671;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21671__$1,(15),out,inst_21659);
} else {
if((state_val_21672 === (2))){
var state_21671__$1 = state_21671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21671__$1,(4),ch);
} else {
if((state_val_21672 === (11))){
var inst_21635 = (state_21671[(9)]);
var inst_21639 = (state_21671[(10)]);
var inst_21649 = (state_21671[(2)]);
var inst_21650 = [];
var inst_21651 = inst_21650.push(inst_21635);
var inst_21631 = inst_21650;
var inst_21632 = inst_21639;
var state_21671__$1 = (function (){var statearr_21683 = state_21671;
(statearr_21683[(7)] = inst_21631);

(statearr_21683[(8)] = inst_21632);

(statearr_21683[(11)] = inst_21649);

(statearr_21683[(12)] = inst_21651);

return statearr_21683;
})();
var statearr_21684_21714 = state_21671__$1;
(statearr_21684_21714[(2)] = null);

(statearr_21684_21714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (9))){
var inst_21631 = (state_21671[(7)]);
var inst_21647 = cljs.core.vec.call(null,inst_21631);
var state_21671__$1 = state_21671;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21671__$1,(11),out,inst_21647);
} else {
if((state_val_21672 === (5))){
var inst_21635 = (state_21671[(9)]);
var inst_21632 = (state_21671[(8)]);
var inst_21639 = (state_21671[(10)]);
var inst_21639__$1 = f.call(null,inst_21635);
var inst_21640 = cljs.core._EQ_.call(null,inst_21639__$1,inst_21632);
var inst_21641 = cljs.core.keyword_identical_QMARK_.call(null,inst_21632,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21642 = (inst_21640) || (inst_21641);
var state_21671__$1 = (function (){var statearr_21685 = state_21671;
(statearr_21685[(10)] = inst_21639__$1);

return statearr_21685;
})();
if(cljs.core.truth_(inst_21642)){
var statearr_21686_21715 = state_21671__$1;
(statearr_21686_21715[(1)] = (8));

} else {
var statearr_21687_21716 = state_21671__$1;
(statearr_21687_21716[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (14))){
var inst_21664 = (state_21671[(2)]);
var inst_21665 = cljs.core.async.close_BANG_.call(null,out);
var state_21671__$1 = (function (){var statearr_21689 = state_21671;
(statearr_21689[(13)] = inst_21664);

return statearr_21689;
})();
var statearr_21690_21717 = state_21671__$1;
(statearr_21690_21717[(2)] = inst_21665);

(statearr_21690_21717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (10))){
var inst_21654 = (state_21671[(2)]);
var state_21671__$1 = state_21671;
var statearr_21691_21718 = state_21671__$1;
(statearr_21691_21718[(2)] = inst_21654);

(statearr_21691_21718[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21672 === (8))){
var inst_21635 = (state_21671[(9)]);
var inst_21631 = (state_21671[(7)]);
var inst_21639 = (state_21671[(10)]);
var inst_21644 = inst_21631.push(inst_21635);
var tmp21688 = inst_21631;
var inst_21631__$1 = tmp21688;
var inst_21632 = inst_21639;
var state_21671__$1 = (function (){var statearr_21692 = state_21671;
(statearr_21692[(7)] = inst_21631__$1);

(statearr_21692[(14)] = inst_21644);

(statearr_21692[(8)] = inst_21632);

return statearr_21692;
})();
var statearr_21693_21719 = state_21671__$1;
(statearr_21693_21719[(2)] = null);

(statearr_21693_21719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11094__auto___21705,out))
;
return ((function (switch__10982__auto__,c__11094__auto___21705,out){
return (function() {
var cljs$core$async$state_machine__10983__auto__ = null;
var cljs$core$async$state_machine__10983__auto____0 = (function (){
var statearr_21697 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21697[(0)] = cljs$core$async$state_machine__10983__auto__);

(statearr_21697[(1)] = (1));

return statearr_21697;
});
var cljs$core$async$state_machine__10983__auto____1 = (function (state_21671){
while(true){
var ret_value__10984__auto__ = (function (){try{while(true){
var result__10985__auto__ = switch__10982__auto__.call(null,state_21671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10985__auto__;
}
break;
}
}catch (e21698){if((e21698 instanceof Object)){
var ex__10986__auto__ = e21698;
var statearr_21699_21720 = state_21671;
(statearr_21699_21720[(5)] = ex__10986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21671);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21698;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21721 = state_21671;
state_21671 = G__21721;
continue;
} else {
return ret_value__10984__auto__;
}
break;
}
});
cljs$core$async$state_machine__10983__auto__ = function(state_21671){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10983__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10983__auto____1.call(this,state_21671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10983__auto____0;
cljs$core$async$state_machine__10983__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10983__auto____1;
return cljs$core$async$state_machine__10983__auto__;
})()
;})(switch__10982__auto__,c__11094__auto___21705,out))
})();
var state__11096__auto__ = (function (){var statearr_21700 = f__11095__auto__.call(null);
(statearr_21700[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11094__auto___21705);

return statearr_21700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11096__auto__);
});})(c__11094__auto___21705,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1460120407916