// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__20174__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__20173 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__20173,(0),null);
var body = cljs.core.nthnext.call(null,vec__20173,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__20174 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__20175__i = 0, G__20175__a = new Array(arguments.length -  0);
while (G__20175__i < G__20175__a.length) {G__20175__a[G__20175__i] = arguments[G__20175__i + 0]; ++G__20175__i;}
  args = new cljs.core.IndexedSeq(G__20175__a,0);
} 
return G__20174__delegate.call(this,args);};
G__20174.cljs$lang$maxFixedArity = 0;
G__20174.cljs$lang$applyTo = (function (arglist__20176){
var args = cljs.core.seq(arglist__20176);
return G__20174__delegate(args);
});
G__20174.cljs$core$IFn$_invoke$arity$variadic = G__20174__delegate;
return G__20174;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__20181(s__20182){
return (new cljs.core.LazySeq(null,(function (){
var s__20182__$1 = s__20182;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20182__$1);
if(temp__4425__auto__){
var s__20182__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20182__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20182__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20184 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20183 = (0);
while(true){
if((i__20183 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__20183);
cljs.core.chunk_append.call(null,b__20184,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__20185 = (i__20183 + (1));
i__20183 = G__20185;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20184),sablono$core$update_arglists_$_iter__20181.call(null,cljs.core.chunk_rest.call(null,s__20182__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20184),null);
}
} else {
var args = cljs.core.first.call(null,s__20182__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__20181.call(null,cljs.core.rest.call(null,s__20182__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20191 = arguments.length;
var i__5727__auto___20192 = (0);
while(true){
if((i__5727__auto___20192 < len__5726__auto___20191)){
args__5733__auto__.push((arguments[i__5727__auto___20192]));

var G__20193 = (i__5727__auto___20192 + (1));
i__5727__auto___20192 = G__20193;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__20187(s__20188){
return (new cljs.core.LazySeq(null,(function (){
var s__20188__$1 = s__20188;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20188__$1);
if(temp__4425__auto__){
var s__20188__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20188__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20188__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20190 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20189 = (0);
while(true){
if((i__20189 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__20189);
cljs.core.chunk_append.call(null,b__20190,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__20194 = (i__20189 + (1));
i__20189 = G__20194;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20190),sablono$core$iter__20187.call(null,cljs.core.chunk_rest.call(null,s__20188__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20190),null);
}
} else {
var style = cljs.core.first.call(null,s__20188__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__20187.call(null,cljs.core.rest.call(null,s__20188__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq20186){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20186));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to20195 = (function sablono$core$link_to20195(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20198 = arguments.length;
var i__5727__auto___20199 = (0);
while(true){
if((i__5727__auto___20199 < len__5726__auto___20198)){
args__5733__auto__.push((arguments[i__5727__auto___20199]));

var G__20200 = (i__5727__auto___20199 + (1));
i__5727__auto___20199 = G__20200;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to20195.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to20195.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to20195.cljs$lang$maxFixedArity = (1);

sablono.core.link_to20195.cljs$lang$applyTo = (function (seq20196){
var G__20197 = cljs.core.first.call(null,seq20196);
var seq20196__$1 = cljs.core.next.call(null,seq20196);
return sablono.core.link_to20195.cljs$core$IFn$_invoke$arity$variadic(G__20197,seq20196__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to20195);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to20201 = (function sablono$core$mail_to20201(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20206 = arguments.length;
var i__5727__auto___20207 = (0);
while(true){
if((i__5727__auto___20207 < len__5726__auto___20206)){
args__5733__auto__.push((arguments[i__5727__auto___20207]));

var G__20208 = (i__5727__auto___20207 + (1));
i__5727__auto___20207 = G__20208;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to20201.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to20201.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__20204){
var vec__20205 = p__20204;
var content = cljs.core.nth.call(null,vec__20205,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to20201.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to20201.cljs$lang$applyTo = (function (seq20202){
var G__20203 = cljs.core.first.call(null,seq20202);
var seq20202__$1 = cljs.core.next.call(null,seq20202);
return sablono.core.mail_to20201.cljs$core$IFn$_invoke$arity$variadic(G__20203,seq20202__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to20201);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list20209 = (function sablono$core$unordered_list20209(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list20209_$_iter__20214(s__20215){
return (new cljs.core.LazySeq(null,(function (){
var s__20215__$1 = s__20215;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20215__$1);
if(temp__4425__auto__){
var s__20215__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20215__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20215__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20217 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20216 = (0);
while(true){
if((i__20216 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20216);
cljs.core.chunk_append.call(null,b__20217,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20218 = (i__20216 + (1));
i__20216 = G__20218;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20217),sablono$core$unordered_list20209_$_iter__20214.call(null,cljs.core.chunk_rest.call(null,s__20215__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20217),null);
}
} else {
var x = cljs.core.first.call(null,s__20215__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list20209_$_iter__20214.call(null,cljs.core.rest.call(null,s__20215__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list20209);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list20219 = (function sablono$core$ordered_list20219(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list20219_$_iter__20224(s__20225){
return (new cljs.core.LazySeq(null,(function (){
var s__20225__$1 = s__20225;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20225__$1);
if(temp__4425__auto__){
var s__20225__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20225__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20225__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20227 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20226 = (0);
while(true){
if((i__20226 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20226);
cljs.core.chunk_append.call(null,b__20227,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20228 = (i__20226 + (1));
i__20226 = G__20228;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20227),sablono$core$ordered_list20219_$_iter__20224.call(null,cljs.core.chunk_rest.call(null,s__20225__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20227),null);
}
} else {
var x = cljs.core.first.call(null,s__20225__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list20219_$_iter__20224.call(null,cljs.core.rest.call(null,s__20225__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list20219);
/**
 * Create an image element.
 */
sablono.core.image20229 = (function sablono$core$image20229(var_args){
var args20230 = [];
var len__5726__auto___20233 = arguments.length;
var i__5727__auto___20234 = (0);
while(true){
if((i__5727__auto___20234 < len__5726__auto___20233)){
args20230.push((arguments[i__5727__auto___20234]));

var G__20235 = (i__5727__auto___20234 + (1));
i__5727__auto___20234 = G__20235;
continue;
} else {
}
break;
}

var G__20232 = args20230.length;
switch (G__20232) {
case 1:
return sablono.core.image20229.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image20229.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20230.length)].join('')));

}
});

sablono.core.image20229.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image20229.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image20229.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image20229);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__20237_SHARP_,p2__20238_SHARP_){
return [cljs.core.str(p1__20237_SHARP_),cljs.core.str("["),cljs.core.str(p2__20238_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__20239_SHARP_,p2__20240_SHARP_){
return [cljs.core.str(p1__20239_SHARP_),cljs.core.str("-"),cljs.core.str(p2__20240_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field20241 = (function sablono$core$color_field20241(var_args){
var args20242 = [];
var len__5726__auto___20309 = arguments.length;
var i__5727__auto___20310 = (0);
while(true){
if((i__5727__auto___20310 < len__5726__auto___20309)){
args20242.push((arguments[i__5727__auto___20310]));

var G__20311 = (i__5727__auto___20310 + (1));
i__5727__auto___20310 = G__20311;
continue;
} else {
}
break;
}

var G__20244 = args20242.length;
switch (G__20244) {
case 1:
return sablono.core.color_field20241.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field20241.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20242.length)].join('')));

}
});

sablono.core.color_field20241.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.color_field20241.call(null,name__11649__auto__,null);
});

sablono.core.color_field20241.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.color_field20241.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field20241);

/**
 * Creates a date input field.
 */
sablono.core.date_field20245 = (function sablono$core$date_field20245(var_args){
var args20246 = [];
var len__5726__auto___20313 = arguments.length;
var i__5727__auto___20314 = (0);
while(true){
if((i__5727__auto___20314 < len__5726__auto___20313)){
args20246.push((arguments[i__5727__auto___20314]));

var G__20315 = (i__5727__auto___20314 + (1));
i__5727__auto___20314 = G__20315;
continue;
} else {
}
break;
}

var G__20248 = args20246.length;
switch (G__20248) {
case 1:
return sablono.core.date_field20245.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field20245.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20246.length)].join('')));

}
});

sablono.core.date_field20245.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.date_field20245.call(null,name__11649__auto__,null);
});

sablono.core.date_field20245.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.date_field20245.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field20245);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field20249 = (function sablono$core$datetime_field20249(var_args){
var args20250 = [];
var len__5726__auto___20317 = arguments.length;
var i__5727__auto___20318 = (0);
while(true){
if((i__5727__auto___20318 < len__5726__auto___20317)){
args20250.push((arguments[i__5727__auto___20318]));

var G__20319 = (i__5727__auto___20318 + (1));
i__5727__auto___20318 = G__20319;
continue;
} else {
}
break;
}

var G__20252 = args20250.length;
switch (G__20252) {
case 1:
return sablono.core.datetime_field20249.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field20249.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20250.length)].join('')));

}
});

sablono.core.datetime_field20249.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_field20249.call(null,name__11649__auto__,null);
});

sablono.core.datetime_field20249.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_field20249.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field20249);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field20253 = (function sablono$core$datetime_local_field20253(var_args){
var args20254 = [];
var len__5726__auto___20321 = arguments.length;
var i__5727__auto___20322 = (0);
while(true){
if((i__5727__auto___20322 < len__5726__auto___20321)){
args20254.push((arguments[i__5727__auto___20322]));

var G__20323 = (i__5727__auto___20322 + (1));
i__5727__auto___20322 = G__20323;
continue;
} else {
}
break;
}

var G__20256 = args20254.length;
switch (G__20256) {
case 1:
return sablono.core.datetime_local_field20253.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field20253.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20254.length)].join('')));

}
});

sablono.core.datetime_local_field20253.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_local_field20253.call(null,name__11649__auto__,null);
});

sablono.core.datetime_local_field20253.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_local_field20253.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field20253);

/**
 * Creates a email input field.
 */
sablono.core.email_field20257 = (function sablono$core$email_field20257(var_args){
var args20258 = [];
var len__5726__auto___20325 = arguments.length;
var i__5727__auto___20326 = (0);
while(true){
if((i__5727__auto___20326 < len__5726__auto___20325)){
args20258.push((arguments[i__5727__auto___20326]));

var G__20327 = (i__5727__auto___20326 + (1));
i__5727__auto___20326 = G__20327;
continue;
} else {
}
break;
}

var G__20260 = args20258.length;
switch (G__20260) {
case 1:
return sablono.core.email_field20257.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field20257.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20258.length)].join('')));

}
});

sablono.core.email_field20257.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.email_field20257.call(null,name__11649__auto__,null);
});

sablono.core.email_field20257.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.email_field20257.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field20257);

/**
 * Creates a file input field.
 */
sablono.core.file_field20261 = (function sablono$core$file_field20261(var_args){
var args20262 = [];
var len__5726__auto___20329 = arguments.length;
var i__5727__auto___20330 = (0);
while(true){
if((i__5727__auto___20330 < len__5726__auto___20329)){
args20262.push((arguments[i__5727__auto___20330]));

var G__20331 = (i__5727__auto___20330 + (1));
i__5727__auto___20330 = G__20331;
continue;
} else {
}
break;
}

var G__20264 = args20262.length;
switch (G__20264) {
case 1:
return sablono.core.file_field20261.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field20261.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20262.length)].join('')));

}
});

sablono.core.file_field20261.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.file_field20261.call(null,name__11649__auto__,null);
});

sablono.core.file_field20261.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.file_field20261.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field20261);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field20265 = (function sablono$core$hidden_field20265(var_args){
var args20266 = [];
var len__5726__auto___20333 = arguments.length;
var i__5727__auto___20334 = (0);
while(true){
if((i__5727__auto___20334 < len__5726__auto___20333)){
args20266.push((arguments[i__5727__auto___20334]));

var G__20335 = (i__5727__auto___20334 + (1));
i__5727__auto___20334 = G__20335;
continue;
} else {
}
break;
}

var G__20268 = args20266.length;
switch (G__20268) {
case 1:
return sablono.core.hidden_field20265.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field20265.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20266.length)].join('')));

}
});

sablono.core.hidden_field20265.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.hidden_field20265.call(null,name__11649__auto__,null);
});

sablono.core.hidden_field20265.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.hidden_field20265.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field20265);

/**
 * Creates a month input field.
 */
sablono.core.month_field20269 = (function sablono$core$month_field20269(var_args){
var args20270 = [];
var len__5726__auto___20337 = arguments.length;
var i__5727__auto___20338 = (0);
while(true){
if((i__5727__auto___20338 < len__5726__auto___20337)){
args20270.push((arguments[i__5727__auto___20338]));

var G__20339 = (i__5727__auto___20338 + (1));
i__5727__auto___20338 = G__20339;
continue;
} else {
}
break;
}

var G__20272 = args20270.length;
switch (G__20272) {
case 1:
return sablono.core.month_field20269.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field20269.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20270.length)].join('')));

}
});

sablono.core.month_field20269.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.month_field20269.call(null,name__11649__auto__,null);
});

sablono.core.month_field20269.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.month_field20269.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field20269);

/**
 * Creates a number input field.
 */
sablono.core.number_field20273 = (function sablono$core$number_field20273(var_args){
var args20274 = [];
var len__5726__auto___20341 = arguments.length;
var i__5727__auto___20342 = (0);
while(true){
if((i__5727__auto___20342 < len__5726__auto___20341)){
args20274.push((arguments[i__5727__auto___20342]));

var G__20343 = (i__5727__auto___20342 + (1));
i__5727__auto___20342 = G__20343;
continue;
} else {
}
break;
}

var G__20276 = args20274.length;
switch (G__20276) {
case 1:
return sablono.core.number_field20273.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field20273.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20274.length)].join('')));

}
});

sablono.core.number_field20273.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.number_field20273.call(null,name__11649__auto__,null);
});

sablono.core.number_field20273.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.number_field20273.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field20273);

/**
 * Creates a password input field.
 */
sablono.core.password_field20277 = (function sablono$core$password_field20277(var_args){
var args20278 = [];
var len__5726__auto___20345 = arguments.length;
var i__5727__auto___20346 = (0);
while(true){
if((i__5727__auto___20346 < len__5726__auto___20345)){
args20278.push((arguments[i__5727__auto___20346]));

var G__20347 = (i__5727__auto___20346 + (1));
i__5727__auto___20346 = G__20347;
continue;
} else {
}
break;
}

var G__20280 = args20278.length;
switch (G__20280) {
case 1:
return sablono.core.password_field20277.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field20277.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20278.length)].join('')));

}
});

sablono.core.password_field20277.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.password_field20277.call(null,name__11649__auto__,null);
});

sablono.core.password_field20277.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.password_field20277.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field20277);

/**
 * Creates a range input field.
 */
sablono.core.range_field20281 = (function sablono$core$range_field20281(var_args){
var args20282 = [];
var len__5726__auto___20349 = arguments.length;
var i__5727__auto___20350 = (0);
while(true){
if((i__5727__auto___20350 < len__5726__auto___20349)){
args20282.push((arguments[i__5727__auto___20350]));

var G__20351 = (i__5727__auto___20350 + (1));
i__5727__auto___20350 = G__20351;
continue;
} else {
}
break;
}

var G__20284 = args20282.length;
switch (G__20284) {
case 1:
return sablono.core.range_field20281.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field20281.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20282.length)].join('')));

}
});

sablono.core.range_field20281.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.range_field20281.call(null,name__11649__auto__,null);
});

sablono.core.range_field20281.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.range_field20281.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field20281);

/**
 * Creates a search input field.
 */
sablono.core.search_field20285 = (function sablono$core$search_field20285(var_args){
var args20286 = [];
var len__5726__auto___20353 = arguments.length;
var i__5727__auto___20354 = (0);
while(true){
if((i__5727__auto___20354 < len__5726__auto___20353)){
args20286.push((arguments[i__5727__auto___20354]));

var G__20355 = (i__5727__auto___20354 + (1));
i__5727__auto___20354 = G__20355;
continue;
} else {
}
break;
}

var G__20288 = args20286.length;
switch (G__20288) {
case 1:
return sablono.core.search_field20285.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field20285.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20286.length)].join('')));

}
});

sablono.core.search_field20285.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.search_field20285.call(null,name__11649__auto__,null);
});

sablono.core.search_field20285.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.search_field20285.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field20285);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field20289 = (function sablono$core$tel_field20289(var_args){
var args20290 = [];
var len__5726__auto___20357 = arguments.length;
var i__5727__auto___20358 = (0);
while(true){
if((i__5727__auto___20358 < len__5726__auto___20357)){
args20290.push((arguments[i__5727__auto___20358]));

var G__20359 = (i__5727__auto___20358 + (1));
i__5727__auto___20358 = G__20359;
continue;
} else {
}
break;
}

var G__20292 = args20290.length;
switch (G__20292) {
case 1:
return sablono.core.tel_field20289.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field20289.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20290.length)].join('')));

}
});

sablono.core.tel_field20289.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.tel_field20289.call(null,name__11649__auto__,null);
});

sablono.core.tel_field20289.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.tel_field20289.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field20289);

/**
 * Creates a text input field.
 */
sablono.core.text_field20293 = (function sablono$core$text_field20293(var_args){
var args20294 = [];
var len__5726__auto___20361 = arguments.length;
var i__5727__auto___20362 = (0);
while(true){
if((i__5727__auto___20362 < len__5726__auto___20361)){
args20294.push((arguments[i__5727__auto___20362]));

var G__20363 = (i__5727__auto___20362 + (1));
i__5727__auto___20362 = G__20363;
continue;
} else {
}
break;
}

var G__20296 = args20294.length;
switch (G__20296) {
case 1:
return sablono.core.text_field20293.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field20293.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20294.length)].join('')));

}
});

sablono.core.text_field20293.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.text_field20293.call(null,name__11649__auto__,null);
});

sablono.core.text_field20293.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.text_field20293.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field20293);

/**
 * Creates a time input field.
 */
sablono.core.time_field20297 = (function sablono$core$time_field20297(var_args){
var args20298 = [];
var len__5726__auto___20365 = arguments.length;
var i__5727__auto___20366 = (0);
while(true){
if((i__5727__auto___20366 < len__5726__auto___20365)){
args20298.push((arguments[i__5727__auto___20366]));

var G__20367 = (i__5727__auto___20366 + (1));
i__5727__auto___20366 = G__20367;
continue;
} else {
}
break;
}

var G__20300 = args20298.length;
switch (G__20300) {
case 1:
return sablono.core.time_field20297.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field20297.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20298.length)].join('')));

}
});

sablono.core.time_field20297.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.time_field20297.call(null,name__11649__auto__,null);
});

sablono.core.time_field20297.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.time_field20297.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field20297);

/**
 * Creates a url input field.
 */
sablono.core.url_field20301 = (function sablono$core$url_field20301(var_args){
var args20302 = [];
var len__5726__auto___20369 = arguments.length;
var i__5727__auto___20370 = (0);
while(true){
if((i__5727__auto___20370 < len__5726__auto___20369)){
args20302.push((arguments[i__5727__auto___20370]));

var G__20371 = (i__5727__auto___20370 + (1));
i__5727__auto___20370 = G__20371;
continue;
} else {
}
break;
}

var G__20304 = args20302.length;
switch (G__20304) {
case 1:
return sablono.core.url_field20301.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field20301.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20302.length)].join('')));

}
});

sablono.core.url_field20301.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.url_field20301.call(null,name__11649__auto__,null);
});

sablono.core.url_field20301.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.url_field20301.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field20301);

/**
 * Creates a week input field.
 */
sablono.core.week_field20305 = (function sablono$core$week_field20305(var_args){
var args20306 = [];
var len__5726__auto___20373 = arguments.length;
var i__5727__auto___20374 = (0);
while(true){
if((i__5727__auto___20374 < len__5726__auto___20373)){
args20306.push((arguments[i__5727__auto___20374]));

var G__20375 = (i__5727__auto___20374 + (1));
i__5727__auto___20374 = G__20375;
continue;
} else {
}
break;
}

var G__20308 = args20306.length;
switch (G__20308) {
case 1:
return sablono.core.week_field20305.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field20305.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20306.length)].join('')));

}
});

sablono.core.week_field20305.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.week_field20305.call(null,name__11649__auto__,null);
});

sablono.core.week_field20305.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.week_field20305.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field20305);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box20377 = (function sablono$core$check_box20377(var_args){
var args20378 = [];
var len__5726__auto___20381 = arguments.length;
var i__5727__auto___20382 = (0);
while(true){
if((i__5727__auto___20382 < len__5726__auto___20381)){
args20378.push((arguments[i__5727__auto___20382]));

var G__20383 = (i__5727__auto___20382 + (1));
i__5727__auto___20382 = G__20383;
continue;
} else {
}
break;
}

var G__20380 = args20378.length;
switch (G__20380) {
case 1:
return sablono.core.check_box20377.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box20377.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box20377.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20378.length)].join('')));

}
});

sablono.core.check_box20377.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box20377.call(null,name,null);
});

sablono.core.check_box20377.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box20377.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box20377.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20377.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box20377);
/**
 * Creates a radio button.
 */
sablono.core.radio_button20385 = (function sablono$core$radio_button20385(var_args){
var args20386 = [];
var len__5726__auto___20389 = arguments.length;
var i__5727__auto___20390 = (0);
while(true){
if((i__5727__auto___20390 < len__5726__auto___20389)){
args20386.push((arguments[i__5727__auto___20390]));

var G__20391 = (i__5727__auto___20390 + (1));
i__5727__auto___20390 = G__20391;
continue;
} else {
}
break;
}

var G__20388 = args20386.length;
switch (G__20388) {
case 1:
return sablono.core.radio_button20385.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button20385.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button20385.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20386.length)].join('')));

}
});

sablono.core.radio_button20385.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button20385.call(null,group,null);
});

sablono.core.radio_button20385.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button20385.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button20385.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20385.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button20385);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options20393 = (function sablono$core$select_options20393(coll){
var iter__5440__auto__ = (function sablono$core$select_options20393_$_iter__20402(s__20403){
return (new cljs.core.LazySeq(null,(function (){
var s__20403__$1 = s__20403;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20403__$1);
if(temp__4425__auto__){
var s__20403__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20403__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20403__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20405 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20404 = (0);
while(true){
if((i__20404 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20404);
cljs.core.chunk_append.call(null,b__20405,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20408 = x;
var text = cljs.core.nth.call(null,vec__20408,(0),null);
var val = cljs.core.nth.call(null,vec__20408,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20408,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20393.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__20410 = (i__20404 + (1));
i__20404 = G__20410;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20405),sablono$core$select_options20393_$_iter__20402.call(null,cljs.core.chunk_rest.call(null,s__20403__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20405),null);
}
} else {
var x = cljs.core.first.call(null,s__20403__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20409 = x;
var text = cljs.core.nth.call(null,vec__20409,(0),null);
var val = cljs.core.nth.call(null,vec__20409,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20409,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20393.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options20393_$_iter__20402.call(null,cljs.core.rest.call(null,s__20403__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options20393);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down20411 = (function sablono$core$drop_down20411(var_args){
var args20412 = [];
var len__5726__auto___20415 = arguments.length;
var i__5727__auto___20416 = (0);
while(true){
if((i__5727__auto___20416 < len__5726__auto___20415)){
args20412.push((arguments[i__5727__auto___20416]));

var G__20417 = (i__5727__auto___20416 + (1));
i__5727__auto___20416 = G__20417;
continue;
} else {
}
break;
}

var G__20414 = args20412.length;
switch (G__20414) {
case 2:
return sablono.core.drop_down20411.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down20411.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20412.length)].join('')));

}
});

sablono.core.drop_down20411.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down20411.call(null,name,options,null);
});

sablono.core.drop_down20411.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down20411.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down20411);
/**
 * Creates a text area element.
 */
sablono.core.text_area20419 = (function sablono$core$text_area20419(var_args){
var args20420 = [];
var len__5726__auto___20423 = arguments.length;
var i__5727__auto___20424 = (0);
while(true){
if((i__5727__auto___20424 < len__5726__auto___20423)){
args20420.push((arguments[i__5727__auto___20424]));

var G__20425 = (i__5727__auto___20424 + (1));
i__5727__auto___20424 = G__20425;
continue;
} else {
}
break;
}

var G__20422 = args20420.length;
switch (G__20422) {
case 1:
return sablono.core.text_area20419.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area20419.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20420.length)].join('')));

}
});

sablono.core.text_area20419.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area20419.call(null,name,null);
});

sablono.core.text_area20419.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area20419.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area20419);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20427 = (function sablono$core$label20427(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20427);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20428 = (function sablono$core$submit_button20428(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20428);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20429 = (function sablono$core$reset_button20429(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20429);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20430 = (function sablono$core$form_to20430(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20435 = arguments.length;
var i__5727__auto___20436 = (0);
while(true){
if((i__5727__auto___20436 < len__5726__auto___20435)){
args__5733__auto__.push((arguments[i__5727__auto___20436]));

var G__20437 = (i__5727__auto___20436 + (1));
i__5727__auto___20436 = G__20437;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to20430.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to20430.cljs$core$IFn$_invoke$arity$variadic = (function (p__20433,body){
var vec__20434 = p__20433;
var method = cljs.core.nth.call(null,vec__20434,(0),null);
var action = cljs.core.nth.call(null,vec__20434,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to20430.cljs$lang$maxFixedArity = (1);

sablono.core.form_to20430.cljs$lang$applyTo = (function (seq20431){
var G__20432 = cljs.core.first.call(null,seq20431);
var seq20431__$1 = cljs.core.next.call(null,seq20431);
return sablono.core.form_to20430.cljs$core$IFn$_invoke$arity$variadic(G__20432,seq20431__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20430);

//# sourceMappingURL=core.js.map?rel=1458821534268