// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17344 = [];
var len__5726__auto___17350 = arguments.length;
var i__5727__auto___17351 = (0);
while(true){
if((i__5727__auto___17351 < len__5726__auto___17350)){
args17344.push((arguments[i__5727__auto___17351]));

var G__17352 = (i__5727__auto___17351 + (1));
i__5727__auto___17351 = G__17352;
continue;
} else {
}
break;
}

var G__17346 = args17344.length;
switch (G__17346) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17344.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17347 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17347 = (function (f,blockable,meta17348){
this.f = f;
this.blockable = blockable;
this.meta17348 = meta17348;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17347.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17349,meta17348__$1){
var self__ = this;
var _17349__$1 = this;
return (new cljs.core.async.t_cljs$core$async17347(self__.f,self__.blockable,meta17348__$1));
});

cljs.core.async.t_cljs$core$async17347.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17349){
var self__ = this;
var _17349__$1 = this;
return self__.meta17348;
});

cljs.core.async.t_cljs$core$async17347.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17347.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17347.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17347.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17347.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17348","meta17348",-164585272,null)], null);
});

cljs.core.async.t_cljs$core$async17347.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17347.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17347";

cljs.core.async.t_cljs$core$async17347.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17347");
});

cljs.core.async.__GT_t_cljs$core$async17347 = (function cljs$core$async$__GT_t_cljs$core$async17347(f__$1,blockable__$1,meta17348){
return (new cljs.core.async.t_cljs$core$async17347(f__$1,blockable__$1,meta17348));
});

}

return (new cljs.core.async.t_cljs$core$async17347(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17356 = [];
var len__5726__auto___17359 = arguments.length;
var i__5727__auto___17360 = (0);
while(true){
if((i__5727__auto___17360 < len__5726__auto___17359)){
args17356.push((arguments[i__5727__auto___17360]));

var G__17361 = (i__5727__auto___17360 + (1));
i__5727__auto___17360 = G__17361;
continue;
} else {
}
break;
}

var G__17358 = args17356.length;
switch (G__17358) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17356.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17363 = [];
var len__5726__auto___17366 = arguments.length;
var i__5727__auto___17367 = (0);
while(true){
if((i__5727__auto___17367 < len__5726__auto___17366)){
args17363.push((arguments[i__5727__auto___17367]));

var G__17368 = (i__5727__auto___17367 + (1));
i__5727__auto___17367 = G__17368;
continue;
} else {
}
break;
}

var G__17365 = args17363.length;
switch (G__17365) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17363.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17370 = [];
var len__5726__auto___17373 = arguments.length;
var i__5727__auto___17374 = (0);
while(true){
if((i__5727__auto___17374 < len__5726__auto___17373)){
args17370.push((arguments[i__5727__auto___17374]));

var G__17375 = (i__5727__auto___17374 + (1));
i__5727__auto___17374 = G__17375;
continue;
} else {
}
break;
}

var G__17372 = args17370.length;
switch (G__17372) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17370.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17377 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17377);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17377,ret){
return (function (){
return fn1.call(null,val_17377);
});})(val_17377,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17378 = [];
var len__5726__auto___17381 = arguments.length;
var i__5727__auto___17382 = (0);
while(true){
if((i__5727__auto___17382 < len__5726__auto___17381)){
args17378.push((arguments[i__5727__auto___17382]));

var G__17383 = (i__5727__auto___17382 + (1));
i__5727__auto___17382 = G__17383;
continue;
} else {
}
break;
}

var G__17380 = args17378.length;
switch (G__17380) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17378.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17385 = n;
var x_17386 = (0);
while(true){
if((x_17386 < n__5571__auto___17385)){
(a[x_17386] = (0));

var G__17387 = (x_17386 + (1));
x_17386 = G__17387;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17388 = (i + (1));
i = G__17388;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17392 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17392 = (function (alt_flag,flag,meta17393){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17393 = meta17393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17394,meta17393__$1){
var self__ = this;
var _17394__$1 = this;
return (new cljs.core.async.t_cljs$core$async17392(self__.alt_flag,self__.flag,meta17393__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17394){
var self__ = this;
var _17394__$1 = this;
return self__.meta17393;
});})(flag))
;

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17392.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17392.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17393","meta17393",-1241391408,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17392.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17392.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17392";

cljs.core.async.t_cljs$core$async17392.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17392");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17392 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17392(alt_flag__$1,flag__$1,meta17393){
return (new cljs.core.async.t_cljs$core$async17392(alt_flag__$1,flag__$1,meta17393));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17392(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17398 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17398 = (function (alt_handler,flag,cb,meta17399){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17399 = meta17399;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17398.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17400,meta17399__$1){
var self__ = this;
var _17400__$1 = this;
return (new cljs.core.async.t_cljs$core$async17398(self__.alt_handler,self__.flag,self__.cb,meta17399__$1));
});

cljs.core.async.t_cljs$core$async17398.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17400){
var self__ = this;
var _17400__$1 = this;
return self__.meta17399;
});

cljs.core.async.t_cljs$core$async17398.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17398.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17398.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17398.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17398.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17399","meta17399",1102856562,null)], null);
});

cljs.core.async.t_cljs$core$async17398.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17398.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17398";

cljs.core.async.t_cljs$core$async17398.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17398");
});

cljs.core.async.__GT_t_cljs$core$async17398 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17398(alt_handler__$1,flag__$1,cb__$1,meta17399){
return (new cljs.core.async.t_cljs$core$async17398(alt_handler__$1,flag__$1,cb__$1,meta17399));
});

}

return (new cljs.core.async.t_cljs$core$async17398(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17401_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17401_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17402_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17402_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17403 = (i + (1));
i = G__17403;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17409 = arguments.length;
var i__5727__auto___17410 = (0);
while(true){
if((i__5727__auto___17410 < len__5726__auto___17409)){
args__5733__auto__.push((arguments[i__5727__auto___17410]));

var G__17411 = (i__5727__auto___17410 + (1));
i__5727__auto___17410 = G__17411;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17406){
var map__17407 = p__17406;
var map__17407__$1 = ((((!((map__17407 == null)))?((((map__17407.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17407.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17407):map__17407);
var opts = map__17407__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17404){
var G__17405 = cljs.core.first.call(null,seq17404);
var seq17404__$1 = cljs.core.next.call(null,seq17404);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17405,seq17404__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17412 = [];
var len__5726__auto___17462 = arguments.length;
var i__5727__auto___17463 = (0);
while(true){
if((i__5727__auto___17463 < len__5726__auto___17462)){
args17412.push((arguments[i__5727__auto___17463]));

var G__17464 = (i__5727__auto___17463 + (1));
i__5727__auto___17463 = G__17464;
continue;
} else {
}
break;
}

var G__17414 = args17412.length;
switch (G__17414) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17412.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17466 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17466){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17466){
return (function (state_17438){
var state_val_17439 = (state_17438[(1)]);
if((state_val_17439 === (7))){
var inst_17434 = (state_17438[(2)]);
var state_17438__$1 = state_17438;
var statearr_17440_17467 = state_17438__$1;
(statearr_17440_17467[(2)] = inst_17434);

(statearr_17440_17467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (1))){
var state_17438__$1 = state_17438;
var statearr_17441_17468 = state_17438__$1;
(statearr_17441_17468[(2)] = null);

(statearr_17441_17468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (4))){
var inst_17417 = (state_17438[(7)]);
var inst_17417__$1 = (state_17438[(2)]);
var inst_17418 = (inst_17417__$1 == null);
var state_17438__$1 = (function (){var statearr_17442 = state_17438;
(statearr_17442[(7)] = inst_17417__$1);

return statearr_17442;
})();
if(cljs.core.truth_(inst_17418)){
var statearr_17443_17469 = state_17438__$1;
(statearr_17443_17469[(1)] = (5));

} else {
var statearr_17444_17470 = state_17438__$1;
(statearr_17444_17470[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (13))){
var state_17438__$1 = state_17438;
var statearr_17445_17471 = state_17438__$1;
(statearr_17445_17471[(2)] = null);

(statearr_17445_17471[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (6))){
var inst_17417 = (state_17438[(7)]);
var state_17438__$1 = state_17438;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17438__$1,(11),to,inst_17417);
} else {
if((state_val_17439 === (3))){
var inst_17436 = (state_17438[(2)]);
var state_17438__$1 = state_17438;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17438__$1,inst_17436);
} else {
if((state_val_17439 === (12))){
var state_17438__$1 = state_17438;
var statearr_17446_17472 = state_17438__$1;
(statearr_17446_17472[(2)] = null);

(statearr_17446_17472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (2))){
var state_17438__$1 = state_17438;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17438__$1,(4),from);
} else {
if((state_val_17439 === (11))){
var inst_17427 = (state_17438[(2)]);
var state_17438__$1 = state_17438;
if(cljs.core.truth_(inst_17427)){
var statearr_17447_17473 = state_17438__$1;
(statearr_17447_17473[(1)] = (12));

} else {
var statearr_17448_17474 = state_17438__$1;
(statearr_17448_17474[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (9))){
var state_17438__$1 = state_17438;
var statearr_17449_17475 = state_17438__$1;
(statearr_17449_17475[(2)] = null);

(statearr_17449_17475[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (5))){
var state_17438__$1 = state_17438;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17450_17476 = state_17438__$1;
(statearr_17450_17476[(1)] = (8));

} else {
var statearr_17451_17477 = state_17438__$1;
(statearr_17451_17477[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (14))){
var inst_17432 = (state_17438[(2)]);
var state_17438__$1 = state_17438;
var statearr_17452_17478 = state_17438__$1;
(statearr_17452_17478[(2)] = inst_17432);

(statearr_17452_17478[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (10))){
var inst_17424 = (state_17438[(2)]);
var state_17438__$1 = state_17438;
var statearr_17453_17479 = state_17438__$1;
(statearr_17453_17479[(2)] = inst_17424);

(statearr_17453_17479[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17439 === (8))){
var inst_17421 = cljs.core.async.close_BANG_.call(null,to);
var state_17438__$1 = state_17438;
var statearr_17454_17480 = state_17438__$1;
(statearr_17454_17480[(2)] = inst_17421);

(statearr_17454_17480[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17466))
;
return ((function (switch__8250__auto__,c__8362__auto___17466){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17458 = [null,null,null,null,null,null,null,null];
(statearr_17458[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17458[(1)] = (1));

return statearr_17458;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17438){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17438);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17459){if((e17459 instanceof Object)){
var ex__8254__auto__ = e17459;
var statearr_17460_17481 = state_17438;
(statearr_17460_17481[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17438);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17459;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17482 = state_17438;
state_17438 = G__17482;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17438){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17466))
})();
var state__8364__auto__ = (function (){var statearr_17461 = f__8363__auto__.call(null);
(statearr_17461[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17466);

return statearr_17461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17466))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17666){
var vec__17667 = p__17666;
var v = cljs.core.nth.call(null,vec__17667,(0),null);
var p = cljs.core.nth.call(null,vec__17667,(1),null);
var job = vec__17667;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17849 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17849,res,vec__17667,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17849,res,vec__17667,v,p,job,jobs,results){
return (function (state_17672){
var state_val_17673 = (state_17672[(1)]);
if((state_val_17673 === (1))){
var state_17672__$1 = state_17672;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17672__$1,(2),res,v);
} else {
if((state_val_17673 === (2))){
var inst_17669 = (state_17672[(2)]);
var inst_17670 = cljs.core.async.close_BANG_.call(null,res);
var state_17672__$1 = (function (){var statearr_17674 = state_17672;
(statearr_17674[(7)] = inst_17669);

return statearr_17674;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17672__$1,inst_17670);
} else {
return null;
}
}
});})(c__8362__auto___17849,res,vec__17667,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17849,res,vec__17667,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17678 = [null,null,null,null,null,null,null,null];
(statearr_17678[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17678[(1)] = (1));

return statearr_17678;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17672){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17679){if((e17679 instanceof Object)){
var ex__8254__auto__ = e17679;
var statearr_17680_17850 = state_17672;
(statearr_17680_17850[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17672);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17679;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17851 = state_17672;
state_17672 = G__17851;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17672){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17849,res,vec__17667,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17681 = f__8363__auto__.call(null);
(statearr_17681[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17849);

return statearr_17681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17849,res,vec__17667,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17682){
var vec__17683 = p__17682;
var v = cljs.core.nth.call(null,vec__17683,(0),null);
var p = cljs.core.nth.call(null,vec__17683,(1),null);
var job = vec__17683;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17852 = n;
var __17853 = (0);
while(true){
if((__17853 < n__5571__auto___17852)){
var G__17684_17854 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17684_17854) {
case "compute":
var c__8362__auto___17856 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17853,c__8362__auto___17856,G__17684_17854,n__5571__auto___17852,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17853,c__8362__auto___17856,G__17684_17854,n__5571__auto___17852,jobs,results,process,async){
return (function (state_17697){
var state_val_17698 = (state_17697[(1)]);
if((state_val_17698 === (1))){
var state_17697__$1 = state_17697;
var statearr_17699_17857 = state_17697__$1;
(statearr_17699_17857[(2)] = null);

(statearr_17699_17857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (2))){
var state_17697__$1 = state_17697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17697__$1,(4),jobs);
} else {
if((state_val_17698 === (3))){
var inst_17695 = (state_17697[(2)]);
var state_17697__$1 = state_17697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17697__$1,inst_17695);
} else {
if((state_val_17698 === (4))){
var inst_17687 = (state_17697[(2)]);
var inst_17688 = process.call(null,inst_17687);
var state_17697__$1 = state_17697;
if(cljs.core.truth_(inst_17688)){
var statearr_17700_17858 = state_17697__$1;
(statearr_17700_17858[(1)] = (5));

} else {
var statearr_17701_17859 = state_17697__$1;
(statearr_17701_17859[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (5))){
var state_17697__$1 = state_17697;
var statearr_17702_17860 = state_17697__$1;
(statearr_17702_17860[(2)] = null);

(statearr_17702_17860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (6))){
var state_17697__$1 = state_17697;
var statearr_17703_17861 = state_17697__$1;
(statearr_17703_17861[(2)] = null);

(statearr_17703_17861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17698 === (7))){
var inst_17693 = (state_17697[(2)]);
var state_17697__$1 = state_17697;
var statearr_17704_17862 = state_17697__$1;
(statearr_17704_17862[(2)] = inst_17693);

(statearr_17704_17862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17853,c__8362__auto___17856,G__17684_17854,n__5571__auto___17852,jobs,results,process,async))
;
return ((function (__17853,switch__8250__auto__,c__8362__auto___17856,G__17684_17854,n__5571__auto___17852,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17708 = [null,null,null,null,null,null,null];
(statearr_17708[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17708[(1)] = (1));

return statearr_17708;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17697){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17709){if((e17709 instanceof Object)){
var ex__8254__auto__ = e17709;
var statearr_17710_17863 = state_17697;
(statearr_17710_17863[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17697);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17709;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17864 = state_17697;
state_17697 = G__17864;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17697){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17853,switch__8250__auto__,c__8362__auto___17856,G__17684_17854,n__5571__auto___17852,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17711 = f__8363__auto__.call(null);
(statearr_17711[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17856);

return statearr_17711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17853,c__8362__auto___17856,G__17684_17854,n__5571__auto___17852,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17865 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17853,c__8362__auto___17865,G__17684_17854,n__5571__auto___17852,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17853,c__8362__auto___17865,G__17684_17854,n__5571__auto___17852,jobs,results,process,async){
return (function (state_17724){
var state_val_17725 = (state_17724[(1)]);
if((state_val_17725 === (1))){
var state_17724__$1 = state_17724;
var statearr_17726_17866 = state_17724__$1;
(statearr_17726_17866[(2)] = null);

(statearr_17726_17866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (2))){
var state_17724__$1 = state_17724;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17724__$1,(4),jobs);
} else {
if((state_val_17725 === (3))){
var inst_17722 = (state_17724[(2)]);
var state_17724__$1 = state_17724;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17724__$1,inst_17722);
} else {
if((state_val_17725 === (4))){
var inst_17714 = (state_17724[(2)]);
var inst_17715 = async.call(null,inst_17714);
var state_17724__$1 = state_17724;
if(cljs.core.truth_(inst_17715)){
var statearr_17727_17867 = state_17724__$1;
(statearr_17727_17867[(1)] = (5));

} else {
var statearr_17728_17868 = state_17724__$1;
(statearr_17728_17868[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (5))){
var state_17724__$1 = state_17724;
var statearr_17729_17869 = state_17724__$1;
(statearr_17729_17869[(2)] = null);

(statearr_17729_17869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (6))){
var state_17724__$1 = state_17724;
var statearr_17730_17870 = state_17724__$1;
(statearr_17730_17870[(2)] = null);

(statearr_17730_17870[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17725 === (7))){
var inst_17720 = (state_17724[(2)]);
var state_17724__$1 = state_17724;
var statearr_17731_17871 = state_17724__$1;
(statearr_17731_17871[(2)] = inst_17720);

(statearr_17731_17871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17853,c__8362__auto___17865,G__17684_17854,n__5571__auto___17852,jobs,results,process,async))
;
return ((function (__17853,switch__8250__auto__,c__8362__auto___17865,G__17684_17854,n__5571__auto___17852,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17735 = [null,null,null,null,null,null,null];
(statearr_17735[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17735[(1)] = (1));

return statearr_17735;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17724){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17724);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17736){if((e17736 instanceof Object)){
var ex__8254__auto__ = e17736;
var statearr_17737_17872 = state_17724;
(statearr_17737_17872[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17724);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17736;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17873 = state_17724;
state_17724 = G__17873;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17724){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17853,switch__8250__auto__,c__8362__auto___17865,G__17684_17854,n__5571__auto___17852,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17738 = f__8363__auto__.call(null);
(statearr_17738[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17865);

return statearr_17738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17853,c__8362__auto___17865,G__17684_17854,n__5571__auto___17852,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17874 = (__17853 + (1));
__17853 = G__17874;
continue;
} else {
}
break;
}

var c__8362__auto___17875 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17875,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17875,jobs,results,process,async){
return (function (state_17760){
var state_val_17761 = (state_17760[(1)]);
if((state_val_17761 === (1))){
var state_17760__$1 = state_17760;
var statearr_17762_17876 = state_17760__$1;
(statearr_17762_17876[(2)] = null);

(statearr_17762_17876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (2))){
var state_17760__$1 = state_17760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17760__$1,(4),from);
} else {
if((state_val_17761 === (3))){
var inst_17758 = (state_17760[(2)]);
var state_17760__$1 = state_17760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17760__$1,inst_17758);
} else {
if((state_val_17761 === (4))){
var inst_17741 = (state_17760[(7)]);
var inst_17741__$1 = (state_17760[(2)]);
var inst_17742 = (inst_17741__$1 == null);
var state_17760__$1 = (function (){var statearr_17763 = state_17760;
(statearr_17763[(7)] = inst_17741__$1);

return statearr_17763;
})();
if(cljs.core.truth_(inst_17742)){
var statearr_17764_17877 = state_17760__$1;
(statearr_17764_17877[(1)] = (5));

} else {
var statearr_17765_17878 = state_17760__$1;
(statearr_17765_17878[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (5))){
var inst_17744 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17760__$1 = state_17760;
var statearr_17766_17879 = state_17760__$1;
(statearr_17766_17879[(2)] = inst_17744);

(statearr_17766_17879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (6))){
var inst_17746 = (state_17760[(8)]);
var inst_17741 = (state_17760[(7)]);
var inst_17746__$1 = cljs.core.async.chan.call(null,(1));
var inst_17747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17748 = [inst_17741,inst_17746__$1];
var inst_17749 = (new cljs.core.PersistentVector(null,2,(5),inst_17747,inst_17748,null));
var state_17760__$1 = (function (){var statearr_17767 = state_17760;
(statearr_17767[(8)] = inst_17746__$1);

return statearr_17767;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17760__$1,(8),jobs,inst_17749);
} else {
if((state_val_17761 === (7))){
var inst_17756 = (state_17760[(2)]);
var state_17760__$1 = state_17760;
var statearr_17768_17880 = state_17760__$1;
(statearr_17768_17880[(2)] = inst_17756);

(statearr_17768_17880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17761 === (8))){
var inst_17746 = (state_17760[(8)]);
var inst_17751 = (state_17760[(2)]);
var state_17760__$1 = (function (){var statearr_17769 = state_17760;
(statearr_17769[(9)] = inst_17751);

return statearr_17769;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17760__$1,(9),results,inst_17746);
} else {
if((state_val_17761 === (9))){
var inst_17753 = (state_17760[(2)]);
var state_17760__$1 = (function (){var statearr_17770 = state_17760;
(statearr_17770[(10)] = inst_17753);

return statearr_17770;
})();
var statearr_17771_17881 = state_17760__$1;
(statearr_17771_17881[(2)] = null);

(statearr_17771_17881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17875,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17875,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17775 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17775[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17775[(1)] = (1));

return statearr_17775;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17760){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17776){if((e17776 instanceof Object)){
var ex__8254__auto__ = e17776;
var statearr_17777_17882 = state_17760;
(statearr_17777_17882[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17776;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17883 = state_17760;
state_17760 = G__17883;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17760){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17875,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17778 = f__8363__auto__.call(null);
(statearr_17778[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17875);

return statearr_17778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17875,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17816){
var state_val_17817 = (state_17816[(1)]);
if((state_val_17817 === (7))){
var inst_17812 = (state_17816[(2)]);
var state_17816__$1 = state_17816;
var statearr_17818_17884 = state_17816__$1;
(statearr_17818_17884[(2)] = inst_17812);

(statearr_17818_17884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (20))){
var state_17816__$1 = state_17816;
var statearr_17819_17885 = state_17816__$1;
(statearr_17819_17885[(2)] = null);

(statearr_17819_17885[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (1))){
var state_17816__$1 = state_17816;
var statearr_17820_17886 = state_17816__$1;
(statearr_17820_17886[(2)] = null);

(statearr_17820_17886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (4))){
var inst_17781 = (state_17816[(7)]);
var inst_17781__$1 = (state_17816[(2)]);
var inst_17782 = (inst_17781__$1 == null);
var state_17816__$1 = (function (){var statearr_17821 = state_17816;
(statearr_17821[(7)] = inst_17781__$1);

return statearr_17821;
})();
if(cljs.core.truth_(inst_17782)){
var statearr_17822_17887 = state_17816__$1;
(statearr_17822_17887[(1)] = (5));

} else {
var statearr_17823_17888 = state_17816__$1;
(statearr_17823_17888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (15))){
var inst_17794 = (state_17816[(8)]);
var state_17816__$1 = state_17816;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17816__$1,(18),to,inst_17794);
} else {
if((state_val_17817 === (21))){
var inst_17807 = (state_17816[(2)]);
var state_17816__$1 = state_17816;
var statearr_17824_17889 = state_17816__$1;
(statearr_17824_17889[(2)] = inst_17807);

(statearr_17824_17889[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (13))){
var inst_17809 = (state_17816[(2)]);
var state_17816__$1 = (function (){var statearr_17825 = state_17816;
(statearr_17825[(9)] = inst_17809);

return statearr_17825;
})();
var statearr_17826_17890 = state_17816__$1;
(statearr_17826_17890[(2)] = null);

(statearr_17826_17890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (6))){
var inst_17781 = (state_17816[(7)]);
var state_17816__$1 = state_17816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17816__$1,(11),inst_17781);
} else {
if((state_val_17817 === (17))){
var inst_17802 = (state_17816[(2)]);
var state_17816__$1 = state_17816;
if(cljs.core.truth_(inst_17802)){
var statearr_17827_17891 = state_17816__$1;
(statearr_17827_17891[(1)] = (19));

} else {
var statearr_17828_17892 = state_17816__$1;
(statearr_17828_17892[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (3))){
var inst_17814 = (state_17816[(2)]);
var state_17816__$1 = state_17816;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17816__$1,inst_17814);
} else {
if((state_val_17817 === (12))){
var inst_17791 = (state_17816[(10)]);
var state_17816__$1 = state_17816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17816__$1,(14),inst_17791);
} else {
if((state_val_17817 === (2))){
var state_17816__$1 = state_17816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17816__$1,(4),results);
} else {
if((state_val_17817 === (19))){
var state_17816__$1 = state_17816;
var statearr_17829_17893 = state_17816__$1;
(statearr_17829_17893[(2)] = null);

(statearr_17829_17893[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (11))){
var inst_17791 = (state_17816[(2)]);
var state_17816__$1 = (function (){var statearr_17830 = state_17816;
(statearr_17830[(10)] = inst_17791);

return statearr_17830;
})();
var statearr_17831_17894 = state_17816__$1;
(statearr_17831_17894[(2)] = null);

(statearr_17831_17894[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (9))){
var state_17816__$1 = state_17816;
var statearr_17832_17895 = state_17816__$1;
(statearr_17832_17895[(2)] = null);

(statearr_17832_17895[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (5))){
var state_17816__$1 = state_17816;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17833_17896 = state_17816__$1;
(statearr_17833_17896[(1)] = (8));

} else {
var statearr_17834_17897 = state_17816__$1;
(statearr_17834_17897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (14))){
var inst_17794 = (state_17816[(8)]);
var inst_17796 = (state_17816[(11)]);
var inst_17794__$1 = (state_17816[(2)]);
var inst_17795 = (inst_17794__$1 == null);
var inst_17796__$1 = cljs.core.not.call(null,inst_17795);
var state_17816__$1 = (function (){var statearr_17835 = state_17816;
(statearr_17835[(8)] = inst_17794__$1);

(statearr_17835[(11)] = inst_17796__$1);

return statearr_17835;
})();
if(inst_17796__$1){
var statearr_17836_17898 = state_17816__$1;
(statearr_17836_17898[(1)] = (15));

} else {
var statearr_17837_17899 = state_17816__$1;
(statearr_17837_17899[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (16))){
var inst_17796 = (state_17816[(11)]);
var state_17816__$1 = state_17816;
var statearr_17838_17900 = state_17816__$1;
(statearr_17838_17900[(2)] = inst_17796);

(statearr_17838_17900[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (10))){
var inst_17788 = (state_17816[(2)]);
var state_17816__$1 = state_17816;
var statearr_17839_17901 = state_17816__$1;
(statearr_17839_17901[(2)] = inst_17788);

(statearr_17839_17901[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (18))){
var inst_17799 = (state_17816[(2)]);
var state_17816__$1 = state_17816;
var statearr_17840_17902 = state_17816__$1;
(statearr_17840_17902[(2)] = inst_17799);

(statearr_17840_17902[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17817 === (8))){
var inst_17785 = cljs.core.async.close_BANG_.call(null,to);
var state_17816__$1 = state_17816;
var statearr_17841_17903 = state_17816__$1;
(statearr_17841_17903[(2)] = inst_17785);

(statearr_17841_17903[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17845 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17845[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17845[(1)] = (1));

return statearr_17845;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17816){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17816);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17846){if((e17846 instanceof Object)){
var ex__8254__auto__ = e17846;
var statearr_17847_17904 = state_17816;
(statearr_17847_17904[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17816);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17846;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17905 = state_17816;
state_17816 = G__17905;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17816){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17848 = f__8363__auto__.call(null);
(statearr_17848[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17906 = [];
var len__5726__auto___17909 = arguments.length;
var i__5727__auto___17910 = (0);
while(true){
if((i__5727__auto___17910 < len__5726__auto___17909)){
args17906.push((arguments[i__5727__auto___17910]));

var G__17911 = (i__5727__auto___17910 + (1));
i__5727__auto___17910 = G__17911;
continue;
} else {
}
break;
}

var G__17908 = args17906.length;
switch (G__17908) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17906.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17913 = [];
var len__5726__auto___17916 = arguments.length;
var i__5727__auto___17917 = (0);
while(true){
if((i__5727__auto___17917 < len__5726__auto___17916)){
args17913.push((arguments[i__5727__auto___17917]));

var G__17918 = (i__5727__auto___17917 + (1));
i__5727__auto___17917 = G__17918;
continue;
} else {
}
break;
}

var G__17915 = args17913.length;
switch (G__17915) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17913.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17920 = [];
var len__5726__auto___17973 = arguments.length;
var i__5727__auto___17974 = (0);
while(true){
if((i__5727__auto___17974 < len__5726__auto___17973)){
args17920.push((arguments[i__5727__auto___17974]));

var G__17975 = (i__5727__auto___17974 + (1));
i__5727__auto___17974 = G__17975;
continue;
} else {
}
break;
}

var G__17922 = args17920.length;
switch (G__17922) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17920.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17977 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17977,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17977,tc,fc){
return (function (state_17948){
var state_val_17949 = (state_17948[(1)]);
if((state_val_17949 === (7))){
var inst_17944 = (state_17948[(2)]);
var state_17948__$1 = state_17948;
var statearr_17950_17978 = state_17948__$1;
(statearr_17950_17978[(2)] = inst_17944);

(statearr_17950_17978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (1))){
var state_17948__$1 = state_17948;
var statearr_17951_17979 = state_17948__$1;
(statearr_17951_17979[(2)] = null);

(statearr_17951_17979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (4))){
var inst_17925 = (state_17948[(7)]);
var inst_17925__$1 = (state_17948[(2)]);
var inst_17926 = (inst_17925__$1 == null);
var state_17948__$1 = (function (){var statearr_17952 = state_17948;
(statearr_17952[(7)] = inst_17925__$1);

return statearr_17952;
})();
if(cljs.core.truth_(inst_17926)){
var statearr_17953_17980 = state_17948__$1;
(statearr_17953_17980[(1)] = (5));

} else {
var statearr_17954_17981 = state_17948__$1;
(statearr_17954_17981[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (13))){
var state_17948__$1 = state_17948;
var statearr_17955_17982 = state_17948__$1;
(statearr_17955_17982[(2)] = null);

(statearr_17955_17982[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (6))){
var inst_17925 = (state_17948[(7)]);
var inst_17931 = p.call(null,inst_17925);
var state_17948__$1 = state_17948;
if(cljs.core.truth_(inst_17931)){
var statearr_17956_17983 = state_17948__$1;
(statearr_17956_17983[(1)] = (9));

} else {
var statearr_17957_17984 = state_17948__$1;
(statearr_17957_17984[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (3))){
var inst_17946 = (state_17948[(2)]);
var state_17948__$1 = state_17948;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17948__$1,inst_17946);
} else {
if((state_val_17949 === (12))){
var state_17948__$1 = state_17948;
var statearr_17958_17985 = state_17948__$1;
(statearr_17958_17985[(2)] = null);

(statearr_17958_17985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (2))){
var state_17948__$1 = state_17948;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17948__$1,(4),ch);
} else {
if((state_val_17949 === (11))){
var inst_17925 = (state_17948[(7)]);
var inst_17935 = (state_17948[(2)]);
var state_17948__$1 = state_17948;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17948__$1,(8),inst_17935,inst_17925);
} else {
if((state_val_17949 === (9))){
var state_17948__$1 = state_17948;
var statearr_17959_17986 = state_17948__$1;
(statearr_17959_17986[(2)] = tc);

(statearr_17959_17986[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (5))){
var inst_17928 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17929 = cljs.core.async.close_BANG_.call(null,fc);
var state_17948__$1 = (function (){var statearr_17960 = state_17948;
(statearr_17960[(8)] = inst_17928);

return statearr_17960;
})();
var statearr_17961_17987 = state_17948__$1;
(statearr_17961_17987[(2)] = inst_17929);

(statearr_17961_17987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (14))){
var inst_17942 = (state_17948[(2)]);
var state_17948__$1 = state_17948;
var statearr_17962_17988 = state_17948__$1;
(statearr_17962_17988[(2)] = inst_17942);

(statearr_17962_17988[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (10))){
var state_17948__$1 = state_17948;
var statearr_17963_17989 = state_17948__$1;
(statearr_17963_17989[(2)] = fc);

(statearr_17963_17989[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17949 === (8))){
var inst_17937 = (state_17948[(2)]);
var state_17948__$1 = state_17948;
if(cljs.core.truth_(inst_17937)){
var statearr_17964_17990 = state_17948__$1;
(statearr_17964_17990[(1)] = (12));

} else {
var statearr_17965_17991 = state_17948__$1;
(statearr_17965_17991[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17977,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17977,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17969 = [null,null,null,null,null,null,null,null,null];
(statearr_17969[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17969[(1)] = (1));

return statearr_17969;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17948){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17948);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17970){if((e17970 instanceof Object)){
var ex__8254__auto__ = e17970;
var statearr_17971_17992 = state_17948;
(statearr_17971_17992[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17948);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17970;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17993 = state_17948;
state_17948 = G__17993;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17948){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17977,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17972 = f__8363__auto__.call(null);
(statearr_17972[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17977);

return statearr_17972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17977,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18057){
var state_val_18058 = (state_18057[(1)]);
if((state_val_18058 === (7))){
var inst_18053 = (state_18057[(2)]);
var state_18057__$1 = state_18057;
var statearr_18059_18080 = state_18057__$1;
(statearr_18059_18080[(2)] = inst_18053);

(statearr_18059_18080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (1))){
var inst_18037 = init;
var state_18057__$1 = (function (){var statearr_18060 = state_18057;
(statearr_18060[(7)] = inst_18037);

return statearr_18060;
})();
var statearr_18061_18081 = state_18057__$1;
(statearr_18061_18081[(2)] = null);

(statearr_18061_18081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (4))){
var inst_18040 = (state_18057[(8)]);
var inst_18040__$1 = (state_18057[(2)]);
var inst_18041 = (inst_18040__$1 == null);
var state_18057__$1 = (function (){var statearr_18062 = state_18057;
(statearr_18062[(8)] = inst_18040__$1);

return statearr_18062;
})();
if(cljs.core.truth_(inst_18041)){
var statearr_18063_18082 = state_18057__$1;
(statearr_18063_18082[(1)] = (5));

} else {
var statearr_18064_18083 = state_18057__$1;
(statearr_18064_18083[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (6))){
var inst_18037 = (state_18057[(7)]);
var inst_18040 = (state_18057[(8)]);
var inst_18044 = (state_18057[(9)]);
var inst_18044__$1 = f.call(null,inst_18037,inst_18040);
var inst_18045 = cljs.core.reduced_QMARK_.call(null,inst_18044__$1);
var state_18057__$1 = (function (){var statearr_18065 = state_18057;
(statearr_18065[(9)] = inst_18044__$1);

return statearr_18065;
})();
if(inst_18045){
var statearr_18066_18084 = state_18057__$1;
(statearr_18066_18084[(1)] = (8));

} else {
var statearr_18067_18085 = state_18057__$1;
(statearr_18067_18085[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (3))){
var inst_18055 = (state_18057[(2)]);
var state_18057__$1 = state_18057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18057__$1,inst_18055);
} else {
if((state_val_18058 === (2))){
var state_18057__$1 = state_18057;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18057__$1,(4),ch);
} else {
if((state_val_18058 === (9))){
var inst_18044 = (state_18057[(9)]);
var inst_18037 = inst_18044;
var state_18057__$1 = (function (){var statearr_18068 = state_18057;
(statearr_18068[(7)] = inst_18037);

return statearr_18068;
})();
var statearr_18069_18086 = state_18057__$1;
(statearr_18069_18086[(2)] = null);

(statearr_18069_18086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (5))){
var inst_18037 = (state_18057[(7)]);
var state_18057__$1 = state_18057;
var statearr_18070_18087 = state_18057__$1;
(statearr_18070_18087[(2)] = inst_18037);

(statearr_18070_18087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (10))){
var inst_18051 = (state_18057[(2)]);
var state_18057__$1 = state_18057;
var statearr_18071_18088 = state_18057__$1;
(statearr_18071_18088[(2)] = inst_18051);

(statearr_18071_18088[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18058 === (8))){
var inst_18044 = (state_18057[(9)]);
var inst_18047 = cljs.core.deref.call(null,inst_18044);
var state_18057__$1 = state_18057;
var statearr_18072_18089 = state_18057__$1;
(statearr_18072_18089[(2)] = inst_18047);

(statearr_18072_18089[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18076 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18076[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18076[(1)] = (1));

return statearr_18076;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18057){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18077){if((e18077 instanceof Object)){
var ex__8254__auto__ = e18077;
var statearr_18078_18090 = state_18057;
(statearr_18078_18090[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18057);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18077;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18091 = state_18057;
state_18057 = G__18091;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18057){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18079 = f__8363__auto__.call(null);
(statearr_18079[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18092 = [];
var len__5726__auto___18144 = arguments.length;
var i__5727__auto___18145 = (0);
while(true){
if((i__5727__auto___18145 < len__5726__auto___18144)){
args18092.push((arguments[i__5727__auto___18145]));

var G__18146 = (i__5727__auto___18145 + (1));
i__5727__auto___18145 = G__18146;
continue;
} else {
}
break;
}

var G__18094 = args18092.length;
switch (G__18094) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18092.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18119){
var state_val_18120 = (state_18119[(1)]);
if((state_val_18120 === (7))){
var inst_18101 = (state_18119[(2)]);
var state_18119__$1 = state_18119;
var statearr_18121_18148 = state_18119__$1;
(statearr_18121_18148[(2)] = inst_18101);

(statearr_18121_18148[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (1))){
var inst_18095 = cljs.core.seq.call(null,coll);
var inst_18096 = inst_18095;
var state_18119__$1 = (function (){var statearr_18122 = state_18119;
(statearr_18122[(7)] = inst_18096);

return statearr_18122;
})();
var statearr_18123_18149 = state_18119__$1;
(statearr_18123_18149[(2)] = null);

(statearr_18123_18149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (4))){
var inst_18096 = (state_18119[(7)]);
var inst_18099 = cljs.core.first.call(null,inst_18096);
var state_18119__$1 = state_18119;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18119__$1,(7),ch,inst_18099);
} else {
if((state_val_18120 === (13))){
var inst_18113 = (state_18119[(2)]);
var state_18119__$1 = state_18119;
var statearr_18124_18150 = state_18119__$1;
(statearr_18124_18150[(2)] = inst_18113);

(statearr_18124_18150[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (6))){
var inst_18104 = (state_18119[(2)]);
var state_18119__$1 = state_18119;
if(cljs.core.truth_(inst_18104)){
var statearr_18125_18151 = state_18119__$1;
(statearr_18125_18151[(1)] = (8));

} else {
var statearr_18126_18152 = state_18119__$1;
(statearr_18126_18152[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (3))){
var inst_18117 = (state_18119[(2)]);
var state_18119__$1 = state_18119;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18119__$1,inst_18117);
} else {
if((state_val_18120 === (12))){
var state_18119__$1 = state_18119;
var statearr_18127_18153 = state_18119__$1;
(statearr_18127_18153[(2)] = null);

(statearr_18127_18153[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (2))){
var inst_18096 = (state_18119[(7)]);
var state_18119__$1 = state_18119;
if(cljs.core.truth_(inst_18096)){
var statearr_18128_18154 = state_18119__$1;
(statearr_18128_18154[(1)] = (4));

} else {
var statearr_18129_18155 = state_18119__$1;
(statearr_18129_18155[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (11))){
var inst_18110 = cljs.core.async.close_BANG_.call(null,ch);
var state_18119__$1 = state_18119;
var statearr_18130_18156 = state_18119__$1;
(statearr_18130_18156[(2)] = inst_18110);

(statearr_18130_18156[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (9))){
var state_18119__$1 = state_18119;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18131_18157 = state_18119__$1;
(statearr_18131_18157[(1)] = (11));

} else {
var statearr_18132_18158 = state_18119__$1;
(statearr_18132_18158[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (5))){
var inst_18096 = (state_18119[(7)]);
var state_18119__$1 = state_18119;
var statearr_18133_18159 = state_18119__$1;
(statearr_18133_18159[(2)] = inst_18096);

(statearr_18133_18159[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (10))){
var inst_18115 = (state_18119[(2)]);
var state_18119__$1 = state_18119;
var statearr_18134_18160 = state_18119__$1;
(statearr_18134_18160[(2)] = inst_18115);

(statearr_18134_18160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18120 === (8))){
var inst_18096 = (state_18119[(7)]);
var inst_18106 = cljs.core.next.call(null,inst_18096);
var inst_18096__$1 = inst_18106;
var state_18119__$1 = (function (){var statearr_18135 = state_18119;
(statearr_18135[(7)] = inst_18096__$1);

return statearr_18135;
})();
var statearr_18136_18161 = state_18119__$1;
(statearr_18136_18161[(2)] = null);

(statearr_18136_18161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18140 = [null,null,null,null,null,null,null,null];
(statearr_18140[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18140[(1)] = (1));

return statearr_18140;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18119){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18119);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18141){if((e18141 instanceof Object)){
var ex__8254__auto__ = e18141;
var statearr_18142_18162 = state_18119;
(statearr_18142_18162[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18119);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18141;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18163 = state_18119;
state_18119 = G__18163;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18119){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18143 = f__8363__auto__.call(null);
(statearr_18143[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18385 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18385 = (function (mult,ch,cs,meta18386){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18386 = meta18386;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18387,meta18386__$1){
var self__ = this;
var _18387__$1 = this;
return (new cljs.core.async.t_cljs$core$async18385(self__.mult,self__.ch,self__.cs,meta18386__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18387){
var self__ = this;
var _18387__$1 = this;
return self__.meta18386;
});})(cs))
;

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18385.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18386","meta18386",-654556936,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18385.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18385.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18385";

cljs.core.async.t_cljs$core$async18385.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18385");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18385 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18385(mult__$1,ch__$1,cs__$1,meta18386){
return (new cljs.core.async.t_cljs$core$async18385(mult__$1,ch__$1,cs__$1,meta18386));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18385(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18606 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18606,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18606,cs,m,dchan,dctr,done){
return (function (state_18518){
var state_val_18519 = (state_18518[(1)]);
if((state_val_18519 === (7))){
var inst_18514 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18520_18607 = state_18518__$1;
(statearr_18520_18607[(2)] = inst_18514);

(statearr_18520_18607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (20))){
var inst_18419 = (state_18518[(7)]);
var inst_18429 = cljs.core.first.call(null,inst_18419);
var inst_18430 = cljs.core.nth.call(null,inst_18429,(0),null);
var inst_18431 = cljs.core.nth.call(null,inst_18429,(1),null);
var state_18518__$1 = (function (){var statearr_18521 = state_18518;
(statearr_18521[(8)] = inst_18430);

return statearr_18521;
})();
if(cljs.core.truth_(inst_18431)){
var statearr_18522_18608 = state_18518__$1;
(statearr_18522_18608[(1)] = (22));

} else {
var statearr_18523_18609 = state_18518__$1;
(statearr_18523_18609[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (27))){
var inst_18461 = (state_18518[(9)]);
var inst_18459 = (state_18518[(10)]);
var inst_18390 = (state_18518[(11)]);
var inst_18466 = (state_18518[(12)]);
var inst_18466__$1 = cljs.core._nth.call(null,inst_18459,inst_18461);
var inst_18467 = cljs.core.async.put_BANG_.call(null,inst_18466__$1,inst_18390,done);
var state_18518__$1 = (function (){var statearr_18524 = state_18518;
(statearr_18524[(12)] = inst_18466__$1);

return statearr_18524;
})();
if(cljs.core.truth_(inst_18467)){
var statearr_18525_18610 = state_18518__$1;
(statearr_18525_18610[(1)] = (30));

} else {
var statearr_18526_18611 = state_18518__$1;
(statearr_18526_18611[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (1))){
var state_18518__$1 = state_18518;
var statearr_18527_18612 = state_18518__$1;
(statearr_18527_18612[(2)] = null);

(statearr_18527_18612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (24))){
var inst_18419 = (state_18518[(7)]);
var inst_18436 = (state_18518[(2)]);
var inst_18437 = cljs.core.next.call(null,inst_18419);
var inst_18399 = inst_18437;
var inst_18400 = null;
var inst_18401 = (0);
var inst_18402 = (0);
var state_18518__$1 = (function (){var statearr_18528 = state_18518;
(statearr_18528[(13)] = inst_18402);

(statearr_18528[(14)] = inst_18436);

(statearr_18528[(15)] = inst_18401);

(statearr_18528[(16)] = inst_18400);

(statearr_18528[(17)] = inst_18399);

return statearr_18528;
})();
var statearr_18529_18613 = state_18518__$1;
(statearr_18529_18613[(2)] = null);

(statearr_18529_18613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (39))){
var state_18518__$1 = state_18518;
var statearr_18533_18614 = state_18518__$1;
(statearr_18533_18614[(2)] = null);

(statearr_18533_18614[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (4))){
var inst_18390 = (state_18518[(11)]);
var inst_18390__$1 = (state_18518[(2)]);
var inst_18391 = (inst_18390__$1 == null);
var state_18518__$1 = (function (){var statearr_18534 = state_18518;
(statearr_18534[(11)] = inst_18390__$1);

return statearr_18534;
})();
if(cljs.core.truth_(inst_18391)){
var statearr_18535_18615 = state_18518__$1;
(statearr_18535_18615[(1)] = (5));

} else {
var statearr_18536_18616 = state_18518__$1;
(statearr_18536_18616[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (15))){
var inst_18402 = (state_18518[(13)]);
var inst_18401 = (state_18518[(15)]);
var inst_18400 = (state_18518[(16)]);
var inst_18399 = (state_18518[(17)]);
var inst_18415 = (state_18518[(2)]);
var inst_18416 = (inst_18402 + (1));
var tmp18530 = inst_18401;
var tmp18531 = inst_18400;
var tmp18532 = inst_18399;
var inst_18399__$1 = tmp18532;
var inst_18400__$1 = tmp18531;
var inst_18401__$1 = tmp18530;
var inst_18402__$1 = inst_18416;
var state_18518__$1 = (function (){var statearr_18537 = state_18518;
(statearr_18537[(13)] = inst_18402__$1);

(statearr_18537[(15)] = inst_18401__$1);

(statearr_18537[(16)] = inst_18400__$1);

(statearr_18537[(18)] = inst_18415);

(statearr_18537[(17)] = inst_18399__$1);

return statearr_18537;
})();
var statearr_18538_18617 = state_18518__$1;
(statearr_18538_18617[(2)] = null);

(statearr_18538_18617[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (21))){
var inst_18440 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18542_18618 = state_18518__$1;
(statearr_18542_18618[(2)] = inst_18440);

(statearr_18542_18618[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (31))){
var inst_18466 = (state_18518[(12)]);
var inst_18470 = done.call(null,null);
var inst_18471 = cljs.core.async.untap_STAR_.call(null,m,inst_18466);
var state_18518__$1 = (function (){var statearr_18543 = state_18518;
(statearr_18543[(19)] = inst_18470);

return statearr_18543;
})();
var statearr_18544_18619 = state_18518__$1;
(statearr_18544_18619[(2)] = inst_18471);

(statearr_18544_18619[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (32))){
var inst_18461 = (state_18518[(9)]);
var inst_18458 = (state_18518[(20)]);
var inst_18459 = (state_18518[(10)]);
var inst_18460 = (state_18518[(21)]);
var inst_18473 = (state_18518[(2)]);
var inst_18474 = (inst_18461 + (1));
var tmp18539 = inst_18458;
var tmp18540 = inst_18459;
var tmp18541 = inst_18460;
var inst_18458__$1 = tmp18539;
var inst_18459__$1 = tmp18540;
var inst_18460__$1 = tmp18541;
var inst_18461__$1 = inst_18474;
var state_18518__$1 = (function (){var statearr_18545 = state_18518;
(statearr_18545[(9)] = inst_18461__$1);

(statearr_18545[(22)] = inst_18473);

(statearr_18545[(20)] = inst_18458__$1);

(statearr_18545[(10)] = inst_18459__$1);

(statearr_18545[(21)] = inst_18460__$1);

return statearr_18545;
})();
var statearr_18546_18620 = state_18518__$1;
(statearr_18546_18620[(2)] = null);

(statearr_18546_18620[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (40))){
var inst_18486 = (state_18518[(23)]);
var inst_18490 = done.call(null,null);
var inst_18491 = cljs.core.async.untap_STAR_.call(null,m,inst_18486);
var state_18518__$1 = (function (){var statearr_18547 = state_18518;
(statearr_18547[(24)] = inst_18490);

return statearr_18547;
})();
var statearr_18548_18621 = state_18518__$1;
(statearr_18548_18621[(2)] = inst_18491);

(statearr_18548_18621[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (33))){
var inst_18477 = (state_18518[(25)]);
var inst_18479 = cljs.core.chunked_seq_QMARK_.call(null,inst_18477);
var state_18518__$1 = state_18518;
if(inst_18479){
var statearr_18549_18622 = state_18518__$1;
(statearr_18549_18622[(1)] = (36));

} else {
var statearr_18550_18623 = state_18518__$1;
(statearr_18550_18623[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (13))){
var inst_18409 = (state_18518[(26)]);
var inst_18412 = cljs.core.async.close_BANG_.call(null,inst_18409);
var state_18518__$1 = state_18518;
var statearr_18551_18624 = state_18518__$1;
(statearr_18551_18624[(2)] = inst_18412);

(statearr_18551_18624[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (22))){
var inst_18430 = (state_18518[(8)]);
var inst_18433 = cljs.core.async.close_BANG_.call(null,inst_18430);
var state_18518__$1 = state_18518;
var statearr_18552_18625 = state_18518__$1;
(statearr_18552_18625[(2)] = inst_18433);

(statearr_18552_18625[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (36))){
var inst_18477 = (state_18518[(25)]);
var inst_18481 = cljs.core.chunk_first.call(null,inst_18477);
var inst_18482 = cljs.core.chunk_rest.call(null,inst_18477);
var inst_18483 = cljs.core.count.call(null,inst_18481);
var inst_18458 = inst_18482;
var inst_18459 = inst_18481;
var inst_18460 = inst_18483;
var inst_18461 = (0);
var state_18518__$1 = (function (){var statearr_18553 = state_18518;
(statearr_18553[(9)] = inst_18461);

(statearr_18553[(20)] = inst_18458);

(statearr_18553[(10)] = inst_18459);

(statearr_18553[(21)] = inst_18460);

return statearr_18553;
})();
var statearr_18554_18626 = state_18518__$1;
(statearr_18554_18626[(2)] = null);

(statearr_18554_18626[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (41))){
var inst_18477 = (state_18518[(25)]);
var inst_18493 = (state_18518[(2)]);
var inst_18494 = cljs.core.next.call(null,inst_18477);
var inst_18458 = inst_18494;
var inst_18459 = null;
var inst_18460 = (0);
var inst_18461 = (0);
var state_18518__$1 = (function (){var statearr_18555 = state_18518;
(statearr_18555[(27)] = inst_18493);

(statearr_18555[(9)] = inst_18461);

(statearr_18555[(20)] = inst_18458);

(statearr_18555[(10)] = inst_18459);

(statearr_18555[(21)] = inst_18460);

return statearr_18555;
})();
var statearr_18556_18627 = state_18518__$1;
(statearr_18556_18627[(2)] = null);

(statearr_18556_18627[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (43))){
var state_18518__$1 = state_18518;
var statearr_18557_18628 = state_18518__$1;
(statearr_18557_18628[(2)] = null);

(statearr_18557_18628[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (29))){
var inst_18502 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18558_18629 = state_18518__$1;
(statearr_18558_18629[(2)] = inst_18502);

(statearr_18558_18629[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (44))){
var inst_18511 = (state_18518[(2)]);
var state_18518__$1 = (function (){var statearr_18559 = state_18518;
(statearr_18559[(28)] = inst_18511);

return statearr_18559;
})();
var statearr_18560_18630 = state_18518__$1;
(statearr_18560_18630[(2)] = null);

(statearr_18560_18630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (6))){
var inst_18450 = (state_18518[(29)]);
var inst_18449 = cljs.core.deref.call(null,cs);
var inst_18450__$1 = cljs.core.keys.call(null,inst_18449);
var inst_18451 = cljs.core.count.call(null,inst_18450__$1);
var inst_18452 = cljs.core.reset_BANG_.call(null,dctr,inst_18451);
var inst_18457 = cljs.core.seq.call(null,inst_18450__$1);
var inst_18458 = inst_18457;
var inst_18459 = null;
var inst_18460 = (0);
var inst_18461 = (0);
var state_18518__$1 = (function (){var statearr_18561 = state_18518;
(statearr_18561[(30)] = inst_18452);

(statearr_18561[(9)] = inst_18461);

(statearr_18561[(29)] = inst_18450__$1);

(statearr_18561[(20)] = inst_18458);

(statearr_18561[(10)] = inst_18459);

(statearr_18561[(21)] = inst_18460);

return statearr_18561;
})();
var statearr_18562_18631 = state_18518__$1;
(statearr_18562_18631[(2)] = null);

(statearr_18562_18631[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (28))){
var inst_18477 = (state_18518[(25)]);
var inst_18458 = (state_18518[(20)]);
var inst_18477__$1 = cljs.core.seq.call(null,inst_18458);
var state_18518__$1 = (function (){var statearr_18563 = state_18518;
(statearr_18563[(25)] = inst_18477__$1);

return statearr_18563;
})();
if(inst_18477__$1){
var statearr_18564_18632 = state_18518__$1;
(statearr_18564_18632[(1)] = (33));

} else {
var statearr_18565_18633 = state_18518__$1;
(statearr_18565_18633[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (25))){
var inst_18461 = (state_18518[(9)]);
var inst_18460 = (state_18518[(21)]);
var inst_18463 = (inst_18461 < inst_18460);
var inst_18464 = inst_18463;
var state_18518__$1 = state_18518;
if(cljs.core.truth_(inst_18464)){
var statearr_18566_18634 = state_18518__$1;
(statearr_18566_18634[(1)] = (27));

} else {
var statearr_18567_18635 = state_18518__$1;
(statearr_18567_18635[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (34))){
var state_18518__$1 = state_18518;
var statearr_18568_18636 = state_18518__$1;
(statearr_18568_18636[(2)] = null);

(statearr_18568_18636[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (17))){
var state_18518__$1 = state_18518;
var statearr_18569_18637 = state_18518__$1;
(statearr_18569_18637[(2)] = null);

(statearr_18569_18637[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (3))){
var inst_18516 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18518__$1,inst_18516);
} else {
if((state_val_18519 === (12))){
var inst_18445 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18570_18638 = state_18518__$1;
(statearr_18570_18638[(2)] = inst_18445);

(statearr_18570_18638[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (2))){
var state_18518__$1 = state_18518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18518__$1,(4),ch);
} else {
if((state_val_18519 === (23))){
var state_18518__$1 = state_18518;
var statearr_18571_18639 = state_18518__$1;
(statearr_18571_18639[(2)] = null);

(statearr_18571_18639[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (35))){
var inst_18500 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18572_18640 = state_18518__$1;
(statearr_18572_18640[(2)] = inst_18500);

(statearr_18572_18640[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (19))){
var inst_18419 = (state_18518[(7)]);
var inst_18423 = cljs.core.chunk_first.call(null,inst_18419);
var inst_18424 = cljs.core.chunk_rest.call(null,inst_18419);
var inst_18425 = cljs.core.count.call(null,inst_18423);
var inst_18399 = inst_18424;
var inst_18400 = inst_18423;
var inst_18401 = inst_18425;
var inst_18402 = (0);
var state_18518__$1 = (function (){var statearr_18573 = state_18518;
(statearr_18573[(13)] = inst_18402);

(statearr_18573[(15)] = inst_18401);

(statearr_18573[(16)] = inst_18400);

(statearr_18573[(17)] = inst_18399);

return statearr_18573;
})();
var statearr_18574_18641 = state_18518__$1;
(statearr_18574_18641[(2)] = null);

(statearr_18574_18641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (11))){
var inst_18419 = (state_18518[(7)]);
var inst_18399 = (state_18518[(17)]);
var inst_18419__$1 = cljs.core.seq.call(null,inst_18399);
var state_18518__$1 = (function (){var statearr_18575 = state_18518;
(statearr_18575[(7)] = inst_18419__$1);

return statearr_18575;
})();
if(inst_18419__$1){
var statearr_18576_18642 = state_18518__$1;
(statearr_18576_18642[(1)] = (16));

} else {
var statearr_18577_18643 = state_18518__$1;
(statearr_18577_18643[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (9))){
var inst_18447 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18578_18644 = state_18518__$1;
(statearr_18578_18644[(2)] = inst_18447);

(statearr_18578_18644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (5))){
var inst_18397 = cljs.core.deref.call(null,cs);
var inst_18398 = cljs.core.seq.call(null,inst_18397);
var inst_18399 = inst_18398;
var inst_18400 = null;
var inst_18401 = (0);
var inst_18402 = (0);
var state_18518__$1 = (function (){var statearr_18579 = state_18518;
(statearr_18579[(13)] = inst_18402);

(statearr_18579[(15)] = inst_18401);

(statearr_18579[(16)] = inst_18400);

(statearr_18579[(17)] = inst_18399);

return statearr_18579;
})();
var statearr_18580_18645 = state_18518__$1;
(statearr_18580_18645[(2)] = null);

(statearr_18580_18645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (14))){
var state_18518__$1 = state_18518;
var statearr_18581_18646 = state_18518__$1;
(statearr_18581_18646[(2)] = null);

(statearr_18581_18646[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (45))){
var inst_18508 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18582_18647 = state_18518__$1;
(statearr_18582_18647[(2)] = inst_18508);

(statearr_18582_18647[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (26))){
var inst_18450 = (state_18518[(29)]);
var inst_18504 = (state_18518[(2)]);
var inst_18505 = cljs.core.seq.call(null,inst_18450);
var state_18518__$1 = (function (){var statearr_18583 = state_18518;
(statearr_18583[(31)] = inst_18504);

return statearr_18583;
})();
if(inst_18505){
var statearr_18584_18648 = state_18518__$1;
(statearr_18584_18648[(1)] = (42));

} else {
var statearr_18585_18649 = state_18518__$1;
(statearr_18585_18649[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (16))){
var inst_18419 = (state_18518[(7)]);
var inst_18421 = cljs.core.chunked_seq_QMARK_.call(null,inst_18419);
var state_18518__$1 = state_18518;
if(inst_18421){
var statearr_18586_18650 = state_18518__$1;
(statearr_18586_18650[(1)] = (19));

} else {
var statearr_18587_18651 = state_18518__$1;
(statearr_18587_18651[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (38))){
var inst_18497 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18588_18652 = state_18518__$1;
(statearr_18588_18652[(2)] = inst_18497);

(statearr_18588_18652[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (30))){
var state_18518__$1 = state_18518;
var statearr_18589_18653 = state_18518__$1;
(statearr_18589_18653[(2)] = null);

(statearr_18589_18653[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (10))){
var inst_18402 = (state_18518[(13)]);
var inst_18400 = (state_18518[(16)]);
var inst_18408 = cljs.core._nth.call(null,inst_18400,inst_18402);
var inst_18409 = cljs.core.nth.call(null,inst_18408,(0),null);
var inst_18410 = cljs.core.nth.call(null,inst_18408,(1),null);
var state_18518__$1 = (function (){var statearr_18590 = state_18518;
(statearr_18590[(26)] = inst_18409);

return statearr_18590;
})();
if(cljs.core.truth_(inst_18410)){
var statearr_18591_18654 = state_18518__$1;
(statearr_18591_18654[(1)] = (13));

} else {
var statearr_18592_18655 = state_18518__$1;
(statearr_18592_18655[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (18))){
var inst_18443 = (state_18518[(2)]);
var state_18518__$1 = state_18518;
var statearr_18593_18656 = state_18518__$1;
(statearr_18593_18656[(2)] = inst_18443);

(statearr_18593_18656[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (42))){
var state_18518__$1 = state_18518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18518__$1,(45),dchan);
} else {
if((state_val_18519 === (37))){
var inst_18477 = (state_18518[(25)]);
var inst_18486 = (state_18518[(23)]);
var inst_18390 = (state_18518[(11)]);
var inst_18486__$1 = cljs.core.first.call(null,inst_18477);
var inst_18487 = cljs.core.async.put_BANG_.call(null,inst_18486__$1,inst_18390,done);
var state_18518__$1 = (function (){var statearr_18594 = state_18518;
(statearr_18594[(23)] = inst_18486__$1);

return statearr_18594;
})();
if(cljs.core.truth_(inst_18487)){
var statearr_18595_18657 = state_18518__$1;
(statearr_18595_18657[(1)] = (39));

} else {
var statearr_18596_18658 = state_18518__$1;
(statearr_18596_18658[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18519 === (8))){
var inst_18402 = (state_18518[(13)]);
var inst_18401 = (state_18518[(15)]);
var inst_18404 = (inst_18402 < inst_18401);
var inst_18405 = inst_18404;
var state_18518__$1 = state_18518;
if(cljs.core.truth_(inst_18405)){
var statearr_18597_18659 = state_18518__$1;
(statearr_18597_18659[(1)] = (10));

} else {
var statearr_18598_18660 = state_18518__$1;
(statearr_18598_18660[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18606,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18606,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18602 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18602[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18602[(1)] = (1));

return statearr_18602;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18518){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18603){if((e18603 instanceof Object)){
var ex__8254__auto__ = e18603;
var statearr_18604_18661 = state_18518;
(statearr_18604_18661[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18518);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18603;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18662 = state_18518;
state_18518 = G__18662;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18518){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18606,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18605 = f__8363__auto__.call(null);
(statearr_18605[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18606);

return statearr_18605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18606,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18663 = [];
var len__5726__auto___18666 = arguments.length;
var i__5727__auto___18667 = (0);
while(true){
if((i__5727__auto___18667 < len__5726__auto___18666)){
args18663.push((arguments[i__5727__auto___18667]));

var G__18668 = (i__5727__auto___18667 + (1));
i__5727__auto___18667 = G__18668;
continue;
} else {
}
break;
}

var G__18665 = args18663.length;
switch (G__18665) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18663.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18680 = arguments.length;
var i__5727__auto___18681 = (0);
while(true){
if((i__5727__auto___18681 < len__5726__auto___18680)){
args__5733__auto__.push((arguments[i__5727__auto___18681]));

var G__18682 = (i__5727__auto___18681 + (1));
i__5727__auto___18681 = G__18682;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18674){
var map__18675 = p__18674;
var map__18675__$1 = ((((!((map__18675 == null)))?((((map__18675.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18675.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18675):map__18675);
var opts = map__18675__$1;
var statearr_18677_18683 = state;
(statearr_18677_18683[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18675,map__18675__$1,opts){
return (function (val){
var statearr_18678_18684 = state;
(statearr_18678_18684[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18675,map__18675__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18679_18685 = state;
(statearr_18679_18685[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18670){
var G__18671 = cljs.core.first.call(null,seq18670);
var seq18670__$1 = cljs.core.next.call(null,seq18670);
var G__18672 = cljs.core.first.call(null,seq18670__$1);
var seq18670__$2 = cljs.core.next.call(null,seq18670__$1);
var G__18673 = cljs.core.first.call(null,seq18670__$2);
var seq18670__$3 = cljs.core.next.call(null,seq18670__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18671,G__18672,G__18673,seq18670__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18849 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18849 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18850){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18850 = meta18850;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18851,meta18850__$1){
var self__ = this;
var _18851__$1 = this;
return (new cljs.core.async.t_cljs$core$async18849(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18850__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18851){
var self__ = this;
var _18851__$1 = this;
return self__.meta18850;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18850","meta18850",949828228,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18849.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18849.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18849";

cljs.core.async.t_cljs$core$async18849.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18849");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18849 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18849(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18850){
return (new cljs.core.async.t_cljs$core$async18849(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18850));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18849(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19012 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19012,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19012,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18949){
var state_val_18950 = (state_18949[(1)]);
if((state_val_18950 === (7))){
var inst_18867 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
var statearr_18951_19013 = state_18949__$1;
(statearr_18951_19013[(2)] = inst_18867);

(statearr_18951_19013[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (20))){
var inst_18879 = (state_18949[(7)]);
var state_18949__$1 = state_18949;
var statearr_18952_19014 = state_18949__$1;
(statearr_18952_19014[(2)] = inst_18879);

(statearr_18952_19014[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (27))){
var state_18949__$1 = state_18949;
var statearr_18953_19015 = state_18949__$1;
(statearr_18953_19015[(2)] = null);

(statearr_18953_19015[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (1))){
var inst_18855 = (state_18949[(8)]);
var inst_18855__$1 = calc_state.call(null);
var inst_18857 = (inst_18855__$1 == null);
var inst_18858 = cljs.core.not.call(null,inst_18857);
var state_18949__$1 = (function (){var statearr_18954 = state_18949;
(statearr_18954[(8)] = inst_18855__$1);

return statearr_18954;
})();
if(inst_18858){
var statearr_18955_19016 = state_18949__$1;
(statearr_18955_19016[(1)] = (2));

} else {
var statearr_18956_19017 = state_18949__$1;
(statearr_18956_19017[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (24))){
var inst_18909 = (state_18949[(9)]);
var inst_18902 = (state_18949[(10)]);
var inst_18923 = (state_18949[(11)]);
var inst_18923__$1 = inst_18902.call(null,inst_18909);
var state_18949__$1 = (function (){var statearr_18957 = state_18949;
(statearr_18957[(11)] = inst_18923__$1);

return statearr_18957;
})();
if(cljs.core.truth_(inst_18923__$1)){
var statearr_18958_19018 = state_18949__$1;
(statearr_18958_19018[(1)] = (29));

} else {
var statearr_18959_19019 = state_18949__$1;
(statearr_18959_19019[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (4))){
var inst_18870 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
if(cljs.core.truth_(inst_18870)){
var statearr_18960_19020 = state_18949__$1;
(statearr_18960_19020[(1)] = (8));

} else {
var statearr_18961_19021 = state_18949__$1;
(statearr_18961_19021[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (15))){
var inst_18896 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
if(cljs.core.truth_(inst_18896)){
var statearr_18962_19022 = state_18949__$1;
(statearr_18962_19022[(1)] = (19));

} else {
var statearr_18963_19023 = state_18949__$1;
(statearr_18963_19023[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (21))){
var inst_18901 = (state_18949[(12)]);
var inst_18901__$1 = (state_18949[(2)]);
var inst_18902 = cljs.core.get.call(null,inst_18901__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18903 = cljs.core.get.call(null,inst_18901__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18904 = cljs.core.get.call(null,inst_18901__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18949__$1 = (function (){var statearr_18964 = state_18949;
(statearr_18964[(10)] = inst_18902);

(statearr_18964[(13)] = inst_18903);

(statearr_18964[(12)] = inst_18901__$1);

return statearr_18964;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18949__$1,(22),inst_18904);
} else {
if((state_val_18950 === (31))){
var inst_18931 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
if(cljs.core.truth_(inst_18931)){
var statearr_18965_19024 = state_18949__$1;
(statearr_18965_19024[(1)] = (32));

} else {
var statearr_18966_19025 = state_18949__$1;
(statearr_18966_19025[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (32))){
var inst_18908 = (state_18949[(14)]);
var state_18949__$1 = state_18949;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18949__$1,(35),out,inst_18908);
} else {
if((state_val_18950 === (33))){
var inst_18901 = (state_18949[(12)]);
var inst_18879 = inst_18901;
var state_18949__$1 = (function (){var statearr_18967 = state_18949;
(statearr_18967[(7)] = inst_18879);

return statearr_18967;
})();
var statearr_18968_19026 = state_18949__$1;
(statearr_18968_19026[(2)] = null);

(statearr_18968_19026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (13))){
var inst_18879 = (state_18949[(7)]);
var inst_18886 = inst_18879.cljs$lang$protocol_mask$partition0$;
var inst_18887 = (inst_18886 & (64));
var inst_18888 = inst_18879.cljs$core$ISeq$;
var inst_18889 = (inst_18887) || (inst_18888);
var state_18949__$1 = state_18949;
if(cljs.core.truth_(inst_18889)){
var statearr_18969_19027 = state_18949__$1;
(statearr_18969_19027[(1)] = (16));

} else {
var statearr_18970_19028 = state_18949__$1;
(statearr_18970_19028[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (22))){
var inst_18909 = (state_18949[(9)]);
var inst_18908 = (state_18949[(14)]);
var inst_18907 = (state_18949[(2)]);
var inst_18908__$1 = cljs.core.nth.call(null,inst_18907,(0),null);
var inst_18909__$1 = cljs.core.nth.call(null,inst_18907,(1),null);
var inst_18910 = (inst_18908__$1 == null);
var inst_18911 = cljs.core._EQ_.call(null,inst_18909__$1,change);
var inst_18912 = (inst_18910) || (inst_18911);
var state_18949__$1 = (function (){var statearr_18971 = state_18949;
(statearr_18971[(9)] = inst_18909__$1);

(statearr_18971[(14)] = inst_18908__$1);

return statearr_18971;
})();
if(cljs.core.truth_(inst_18912)){
var statearr_18972_19029 = state_18949__$1;
(statearr_18972_19029[(1)] = (23));

} else {
var statearr_18973_19030 = state_18949__$1;
(statearr_18973_19030[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (36))){
var inst_18901 = (state_18949[(12)]);
var inst_18879 = inst_18901;
var state_18949__$1 = (function (){var statearr_18974 = state_18949;
(statearr_18974[(7)] = inst_18879);

return statearr_18974;
})();
var statearr_18975_19031 = state_18949__$1;
(statearr_18975_19031[(2)] = null);

(statearr_18975_19031[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (29))){
var inst_18923 = (state_18949[(11)]);
var state_18949__$1 = state_18949;
var statearr_18976_19032 = state_18949__$1;
(statearr_18976_19032[(2)] = inst_18923);

(statearr_18976_19032[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (6))){
var state_18949__$1 = state_18949;
var statearr_18977_19033 = state_18949__$1;
(statearr_18977_19033[(2)] = false);

(statearr_18977_19033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (28))){
var inst_18919 = (state_18949[(2)]);
var inst_18920 = calc_state.call(null);
var inst_18879 = inst_18920;
var state_18949__$1 = (function (){var statearr_18978 = state_18949;
(statearr_18978[(7)] = inst_18879);

(statearr_18978[(15)] = inst_18919);

return statearr_18978;
})();
var statearr_18979_19034 = state_18949__$1;
(statearr_18979_19034[(2)] = null);

(statearr_18979_19034[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (25))){
var inst_18945 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
var statearr_18980_19035 = state_18949__$1;
(statearr_18980_19035[(2)] = inst_18945);

(statearr_18980_19035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (34))){
var inst_18943 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
var statearr_18981_19036 = state_18949__$1;
(statearr_18981_19036[(2)] = inst_18943);

(statearr_18981_19036[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (17))){
var state_18949__$1 = state_18949;
var statearr_18982_19037 = state_18949__$1;
(statearr_18982_19037[(2)] = false);

(statearr_18982_19037[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (3))){
var state_18949__$1 = state_18949;
var statearr_18983_19038 = state_18949__$1;
(statearr_18983_19038[(2)] = false);

(statearr_18983_19038[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (12))){
var inst_18947 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18949__$1,inst_18947);
} else {
if((state_val_18950 === (2))){
var inst_18855 = (state_18949[(8)]);
var inst_18860 = inst_18855.cljs$lang$protocol_mask$partition0$;
var inst_18861 = (inst_18860 & (64));
var inst_18862 = inst_18855.cljs$core$ISeq$;
var inst_18863 = (inst_18861) || (inst_18862);
var state_18949__$1 = state_18949;
if(cljs.core.truth_(inst_18863)){
var statearr_18984_19039 = state_18949__$1;
(statearr_18984_19039[(1)] = (5));

} else {
var statearr_18985_19040 = state_18949__$1;
(statearr_18985_19040[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (23))){
var inst_18908 = (state_18949[(14)]);
var inst_18914 = (inst_18908 == null);
var state_18949__$1 = state_18949;
if(cljs.core.truth_(inst_18914)){
var statearr_18986_19041 = state_18949__$1;
(statearr_18986_19041[(1)] = (26));

} else {
var statearr_18987_19042 = state_18949__$1;
(statearr_18987_19042[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (35))){
var inst_18934 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
if(cljs.core.truth_(inst_18934)){
var statearr_18988_19043 = state_18949__$1;
(statearr_18988_19043[(1)] = (36));

} else {
var statearr_18989_19044 = state_18949__$1;
(statearr_18989_19044[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (19))){
var inst_18879 = (state_18949[(7)]);
var inst_18898 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18879);
var state_18949__$1 = state_18949;
var statearr_18990_19045 = state_18949__$1;
(statearr_18990_19045[(2)] = inst_18898);

(statearr_18990_19045[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (11))){
var inst_18879 = (state_18949[(7)]);
var inst_18883 = (inst_18879 == null);
var inst_18884 = cljs.core.not.call(null,inst_18883);
var state_18949__$1 = state_18949;
if(inst_18884){
var statearr_18991_19046 = state_18949__$1;
(statearr_18991_19046[(1)] = (13));

} else {
var statearr_18992_19047 = state_18949__$1;
(statearr_18992_19047[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (9))){
var inst_18855 = (state_18949[(8)]);
var state_18949__$1 = state_18949;
var statearr_18993_19048 = state_18949__$1;
(statearr_18993_19048[(2)] = inst_18855);

(statearr_18993_19048[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (5))){
var state_18949__$1 = state_18949;
var statearr_18994_19049 = state_18949__$1;
(statearr_18994_19049[(2)] = true);

(statearr_18994_19049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (14))){
var state_18949__$1 = state_18949;
var statearr_18995_19050 = state_18949__$1;
(statearr_18995_19050[(2)] = false);

(statearr_18995_19050[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (26))){
var inst_18909 = (state_18949[(9)]);
var inst_18916 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18909);
var state_18949__$1 = state_18949;
var statearr_18996_19051 = state_18949__$1;
(statearr_18996_19051[(2)] = inst_18916);

(statearr_18996_19051[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (16))){
var state_18949__$1 = state_18949;
var statearr_18997_19052 = state_18949__$1;
(statearr_18997_19052[(2)] = true);

(statearr_18997_19052[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (38))){
var inst_18939 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
var statearr_18998_19053 = state_18949__$1;
(statearr_18998_19053[(2)] = inst_18939);

(statearr_18998_19053[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (30))){
var inst_18909 = (state_18949[(9)]);
var inst_18902 = (state_18949[(10)]);
var inst_18903 = (state_18949[(13)]);
var inst_18926 = cljs.core.empty_QMARK_.call(null,inst_18902);
var inst_18927 = inst_18903.call(null,inst_18909);
var inst_18928 = cljs.core.not.call(null,inst_18927);
var inst_18929 = (inst_18926) && (inst_18928);
var state_18949__$1 = state_18949;
var statearr_18999_19054 = state_18949__$1;
(statearr_18999_19054[(2)] = inst_18929);

(statearr_18999_19054[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (10))){
var inst_18855 = (state_18949[(8)]);
var inst_18875 = (state_18949[(2)]);
var inst_18876 = cljs.core.get.call(null,inst_18875,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18877 = cljs.core.get.call(null,inst_18875,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18878 = cljs.core.get.call(null,inst_18875,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18879 = inst_18855;
var state_18949__$1 = (function (){var statearr_19000 = state_18949;
(statearr_19000[(16)] = inst_18878);

(statearr_19000[(7)] = inst_18879);

(statearr_19000[(17)] = inst_18876);

(statearr_19000[(18)] = inst_18877);

return statearr_19000;
})();
var statearr_19001_19055 = state_18949__$1;
(statearr_19001_19055[(2)] = null);

(statearr_19001_19055[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (18))){
var inst_18893 = (state_18949[(2)]);
var state_18949__$1 = state_18949;
var statearr_19002_19056 = state_18949__$1;
(statearr_19002_19056[(2)] = inst_18893);

(statearr_19002_19056[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (37))){
var state_18949__$1 = state_18949;
var statearr_19003_19057 = state_18949__$1;
(statearr_19003_19057[(2)] = null);

(statearr_19003_19057[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18950 === (8))){
var inst_18855 = (state_18949[(8)]);
var inst_18872 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18855);
var state_18949__$1 = state_18949;
var statearr_19004_19058 = state_18949__$1;
(statearr_19004_19058[(2)] = inst_18872);

(statearr_19004_19058[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19012,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___19012,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_19008 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19008[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_19008[(1)] = (1));

return statearr_19008;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18949){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19009){if((e19009 instanceof Object)){
var ex__8254__auto__ = e19009;
var statearr_19010_19059 = state_18949;
(statearr_19010_19059[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18949);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19060 = state_18949;
state_18949 = G__19060;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18949){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19012,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_19011 = f__8363__auto__.call(null);
(statearr_19011[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19012);

return statearr_19011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19012,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19061 = [];
var len__5726__auto___19064 = arguments.length;
var i__5727__auto___19065 = (0);
while(true){
if((i__5727__auto___19065 < len__5726__auto___19064)){
args19061.push((arguments[i__5727__auto___19065]));

var G__19066 = (i__5727__auto___19065 + (1));
i__5727__auto___19065 = G__19066;
continue;
} else {
}
break;
}

var G__19063 = args19061.length;
switch (G__19063) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19061.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19069 = [];
var len__5726__auto___19194 = arguments.length;
var i__5727__auto___19195 = (0);
while(true){
if((i__5727__auto___19195 < len__5726__auto___19194)){
args19069.push((arguments[i__5727__auto___19195]));

var G__19196 = (i__5727__auto___19195 + (1));
i__5727__auto___19195 = G__19196;
continue;
} else {
}
break;
}

var G__19071 = args19069.length;
switch (G__19071) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19069.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19068_SHARP_){
if(cljs.core.truth_(p1__19068_SHARP_.call(null,topic))){
return p1__19068_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19068_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19072 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19072 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19073){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19073 = meta19073;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19074,meta19073__$1){
var self__ = this;
var _19074__$1 = this;
return (new cljs.core.async.t_cljs$core$async19072(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19073__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19074){
var self__ = this;
var _19074__$1 = this;
return self__.meta19073;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19072.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19072.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19073","meta19073",-414872996,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19072.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19072.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19072";

cljs.core.async.t_cljs$core$async19072.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19072");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19072 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19072(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19073){
return (new cljs.core.async.t_cljs$core$async19072(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19073));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19072(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19198 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19198,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19198,mults,ensure_mult,p){
return (function (state_19146){
var state_val_19147 = (state_19146[(1)]);
if((state_val_19147 === (7))){
var inst_19142 = (state_19146[(2)]);
var state_19146__$1 = state_19146;
var statearr_19148_19199 = state_19146__$1;
(statearr_19148_19199[(2)] = inst_19142);

(statearr_19148_19199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (20))){
var state_19146__$1 = state_19146;
var statearr_19149_19200 = state_19146__$1;
(statearr_19149_19200[(2)] = null);

(statearr_19149_19200[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (1))){
var state_19146__$1 = state_19146;
var statearr_19150_19201 = state_19146__$1;
(statearr_19150_19201[(2)] = null);

(statearr_19150_19201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (24))){
var inst_19125 = (state_19146[(7)]);
var inst_19134 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19125);
var state_19146__$1 = state_19146;
var statearr_19151_19202 = state_19146__$1;
(statearr_19151_19202[(2)] = inst_19134);

(statearr_19151_19202[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (4))){
var inst_19077 = (state_19146[(8)]);
var inst_19077__$1 = (state_19146[(2)]);
var inst_19078 = (inst_19077__$1 == null);
var state_19146__$1 = (function (){var statearr_19152 = state_19146;
(statearr_19152[(8)] = inst_19077__$1);

return statearr_19152;
})();
if(cljs.core.truth_(inst_19078)){
var statearr_19153_19203 = state_19146__$1;
(statearr_19153_19203[(1)] = (5));

} else {
var statearr_19154_19204 = state_19146__$1;
(statearr_19154_19204[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (15))){
var inst_19119 = (state_19146[(2)]);
var state_19146__$1 = state_19146;
var statearr_19155_19205 = state_19146__$1;
(statearr_19155_19205[(2)] = inst_19119);

(statearr_19155_19205[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (21))){
var inst_19139 = (state_19146[(2)]);
var state_19146__$1 = (function (){var statearr_19156 = state_19146;
(statearr_19156[(9)] = inst_19139);

return statearr_19156;
})();
var statearr_19157_19206 = state_19146__$1;
(statearr_19157_19206[(2)] = null);

(statearr_19157_19206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (13))){
var inst_19101 = (state_19146[(10)]);
var inst_19103 = cljs.core.chunked_seq_QMARK_.call(null,inst_19101);
var state_19146__$1 = state_19146;
if(inst_19103){
var statearr_19158_19207 = state_19146__$1;
(statearr_19158_19207[(1)] = (16));

} else {
var statearr_19159_19208 = state_19146__$1;
(statearr_19159_19208[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (22))){
var inst_19131 = (state_19146[(2)]);
var state_19146__$1 = state_19146;
if(cljs.core.truth_(inst_19131)){
var statearr_19160_19209 = state_19146__$1;
(statearr_19160_19209[(1)] = (23));

} else {
var statearr_19161_19210 = state_19146__$1;
(statearr_19161_19210[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (6))){
var inst_19077 = (state_19146[(8)]);
var inst_19127 = (state_19146[(11)]);
var inst_19125 = (state_19146[(7)]);
var inst_19125__$1 = topic_fn.call(null,inst_19077);
var inst_19126 = cljs.core.deref.call(null,mults);
var inst_19127__$1 = cljs.core.get.call(null,inst_19126,inst_19125__$1);
var state_19146__$1 = (function (){var statearr_19162 = state_19146;
(statearr_19162[(11)] = inst_19127__$1);

(statearr_19162[(7)] = inst_19125__$1);

return statearr_19162;
})();
if(cljs.core.truth_(inst_19127__$1)){
var statearr_19163_19211 = state_19146__$1;
(statearr_19163_19211[(1)] = (19));

} else {
var statearr_19164_19212 = state_19146__$1;
(statearr_19164_19212[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (25))){
var inst_19136 = (state_19146[(2)]);
var state_19146__$1 = state_19146;
var statearr_19165_19213 = state_19146__$1;
(statearr_19165_19213[(2)] = inst_19136);

(statearr_19165_19213[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (17))){
var inst_19101 = (state_19146[(10)]);
var inst_19110 = cljs.core.first.call(null,inst_19101);
var inst_19111 = cljs.core.async.muxch_STAR_.call(null,inst_19110);
var inst_19112 = cljs.core.async.close_BANG_.call(null,inst_19111);
var inst_19113 = cljs.core.next.call(null,inst_19101);
var inst_19087 = inst_19113;
var inst_19088 = null;
var inst_19089 = (0);
var inst_19090 = (0);
var state_19146__$1 = (function (){var statearr_19166 = state_19146;
(statearr_19166[(12)] = inst_19087);

(statearr_19166[(13)] = inst_19090);

(statearr_19166[(14)] = inst_19112);

(statearr_19166[(15)] = inst_19088);

(statearr_19166[(16)] = inst_19089);

return statearr_19166;
})();
var statearr_19167_19214 = state_19146__$1;
(statearr_19167_19214[(2)] = null);

(statearr_19167_19214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (3))){
var inst_19144 = (state_19146[(2)]);
var state_19146__$1 = state_19146;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19146__$1,inst_19144);
} else {
if((state_val_19147 === (12))){
var inst_19121 = (state_19146[(2)]);
var state_19146__$1 = state_19146;
var statearr_19168_19215 = state_19146__$1;
(statearr_19168_19215[(2)] = inst_19121);

(statearr_19168_19215[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (2))){
var state_19146__$1 = state_19146;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19146__$1,(4),ch);
} else {
if((state_val_19147 === (23))){
var state_19146__$1 = state_19146;
var statearr_19169_19216 = state_19146__$1;
(statearr_19169_19216[(2)] = null);

(statearr_19169_19216[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (19))){
var inst_19077 = (state_19146[(8)]);
var inst_19127 = (state_19146[(11)]);
var inst_19129 = cljs.core.async.muxch_STAR_.call(null,inst_19127);
var state_19146__$1 = state_19146;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19146__$1,(22),inst_19129,inst_19077);
} else {
if((state_val_19147 === (11))){
var inst_19087 = (state_19146[(12)]);
var inst_19101 = (state_19146[(10)]);
var inst_19101__$1 = cljs.core.seq.call(null,inst_19087);
var state_19146__$1 = (function (){var statearr_19170 = state_19146;
(statearr_19170[(10)] = inst_19101__$1);

return statearr_19170;
})();
if(inst_19101__$1){
var statearr_19171_19217 = state_19146__$1;
(statearr_19171_19217[(1)] = (13));

} else {
var statearr_19172_19218 = state_19146__$1;
(statearr_19172_19218[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (9))){
var inst_19123 = (state_19146[(2)]);
var state_19146__$1 = state_19146;
var statearr_19173_19219 = state_19146__$1;
(statearr_19173_19219[(2)] = inst_19123);

(statearr_19173_19219[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (5))){
var inst_19084 = cljs.core.deref.call(null,mults);
var inst_19085 = cljs.core.vals.call(null,inst_19084);
var inst_19086 = cljs.core.seq.call(null,inst_19085);
var inst_19087 = inst_19086;
var inst_19088 = null;
var inst_19089 = (0);
var inst_19090 = (0);
var state_19146__$1 = (function (){var statearr_19174 = state_19146;
(statearr_19174[(12)] = inst_19087);

(statearr_19174[(13)] = inst_19090);

(statearr_19174[(15)] = inst_19088);

(statearr_19174[(16)] = inst_19089);

return statearr_19174;
})();
var statearr_19175_19220 = state_19146__$1;
(statearr_19175_19220[(2)] = null);

(statearr_19175_19220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (14))){
var state_19146__$1 = state_19146;
var statearr_19179_19221 = state_19146__$1;
(statearr_19179_19221[(2)] = null);

(statearr_19179_19221[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (16))){
var inst_19101 = (state_19146[(10)]);
var inst_19105 = cljs.core.chunk_first.call(null,inst_19101);
var inst_19106 = cljs.core.chunk_rest.call(null,inst_19101);
var inst_19107 = cljs.core.count.call(null,inst_19105);
var inst_19087 = inst_19106;
var inst_19088 = inst_19105;
var inst_19089 = inst_19107;
var inst_19090 = (0);
var state_19146__$1 = (function (){var statearr_19180 = state_19146;
(statearr_19180[(12)] = inst_19087);

(statearr_19180[(13)] = inst_19090);

(statearr_19180[(15)] = inst_19088);

(statearr_19180[(16)] = inst_19089);

return statearr_19180;
})();
var statearr_19181_19222 = state_19146__$1;
(statearr_19181_19222[(2)] = null);

(statearr_19181_19222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (10))){
var inst_19087 = (state_19146[(12)]);
var inst_19090 = (state_19146[(13)]);
var inst_19088 = (state_19146[(15)]);
var inst_19089 = (state_19146[(16)]);
var inst_19095 = cljs.core._nth.call(null,inst_19088,inst_19090);
var inst_19096 = cljs.core.async.muxch_STAR_.call(null,inst_19095);
var inst_19097 = cljs.core.async.close_BANG_.call(null,inst_19096);
var inst_19098 = (inst_19090 + (1));
var tmp19176 = inst_19087;
var tmp19177 = inst_19088;
var tmp19178 = inst_19089;
var inst_19087__$1 = tmp19176;
var inst_19088__$1 = tmp19177;
var inst_19089__$1 = tmp19178;
var inst_19090__$1 = inst_19098;
var state_19146__$1 = (function (){var statearr_19182 = state_19146;
(statearr_19182[(17)] = inst_19097);

(statearr_19182[(12)] = inst_19087__$1);

(statearr_19182[(13)] = inst_19090__$1);

(statearr_19182[(15)] = inst_19088__$1);

(statearr_19182[(16)] = inst_19089__$1);

return statearr_19182;
})();
var statearr_19183_19223 = state_19146__$1;
(statearr_19183_19223[(2)] = null);

(statearr_19183_19223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (18))){
var inst_19116 = (state_19146[(2)]);
var state_19146__$1 = state_19146;
var statearr_19184_19224 = state_19146__$1;
(statearr_19184_19224[(2)] = inst_19116);

(statearr_19184_19224[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19147 === (8))){
var inst_19090 = (state_19146[(13)]);
var inst_19089 = (state_19146[(16)]);
var inst_19092 = (inst_19090 < inst_19089);
var inst_19093 = inst_19092;
var state_19146__$1 = state_19146;
if(cljs.core.truth_(inst_19093)){
var statearr_19185_19225 = state_19146__$1;
(statearr_19185_19225[(1)] = (10));

} else {
var statearr_19186_19226 = state_19146__$1;
(statearr_19186_19226[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19198,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19198,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19190 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19190[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19190[(1)] = (1));

return statearr_19190;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19146){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19146);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19191){if((e19191 instanceof Object)){
var ex__8254__auto__ = e19191;
var statearr_19192_19227 = state_19146;
(statearr_19192_19227[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19146);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19191;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19228 = state_19146;
state_19146 = G__19228;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19146){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19198,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19193 = f__8363__auto__.call(null);
(statearr_19193[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19198);

return statearr_19193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19198,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19229 = [];
var len__5726__auto___19232 = arguments.length;
var i__5727__auto___19233 = (0);
while(true){
if((i__5727__auto___19233 < len__5726__auto___19232)){
args19229.push((arguments[i__5727__auto___19233]));

var G__19234 = (i__5727__auto___19233 + (1));
i__5727__auto___19233 = G__19234;
continue;
} else {
}
break;
}

var G__19231 = args19229.length;
switch (G__19231) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19229.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19236 = [];
var len__5726__auto___19239 = arguments.length;
var i__5727__auto___19240 = (0);
while(true){
if((i__5727__auto___19240 < len__5726__auto___19239)){
args19236.push((arguments[i__5727__auto___19240]));

var G__19241 = (i__5727__auto___19240 + (1));
i__5727__auto___19240 = G__19241;
continue;
} else {
}
break;
}

var G__19238 = args19236.length;
switch (G__19238) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19236.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19243 = [];
var len__5726__auto___19314 = arguments.length;
var i__5727__auto___19315 = (0);
while(true){
if((i__5727__auto___19315 < len__5726__auto___19314)){
args19243.push((arguments[i__5727__auto___19315]));

var G__19316 = (i__5727__auto___19315 + (1));
i__5727__auto___19315 = G__19316;
continue;
} else {
}
break;
}

var G__19245 = args19243.length;
switch (G__19245) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19243.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19318 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19318,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19318,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19284){
var state_val_19285 = (state_19284[(1)]);
if((state_val_19285 === (7))){
var state_19284__$1 = state_19284;
var statearr_19286_19319 = state_19284__$1;
(statearr_19286_19319[(2)] = null);

(statearr_19286_19319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (1))){
var state_19284__$1 = state_19284;
var statearr_19287_19320 = state_19284__$1;
(statearr_19287_19320[(2)] = null);

(statearr_19287_19320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (4))){
var inst_19248 = (state_19284[(7)]);
var inst_19250 = (inst_19248 < cnt);
var state_19284__$1 = state_19284;
if(cljs.core.truth_(inst_19250)){
var statearr_19288_19321 = state_19284__$1;
(statearr_19288_19321[(1)] = (6));

} else {
var statearr_19289_19322 = state_19284__$1;
(statearr_19289_19322[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (15))){
var inst_19280 = (state_19284[(2)]);
var state_19284__$1 = state_19284;
var statearr_19290_19323 = state_19284__$1;
(statearr_19290_19323[(2)] = inst_19280);

(statearr_19290_19323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (13))){
var inst_19273 = cljs.core.async.close_BANG_.call(null,out);
var state_19284__$1 = state_19284;
var statearr_19291_19324 = state_19284__$1;
(statearr_19291_19324[(2)] = inst_19273);

(statearr_19291_19324[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (6))){
var state_19284__$1 = state_19284;
var statearr_19292_19325 = state_19284__$1;
(statearr_19292_19325[(2)] = null);

(statearr_19292_19325[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (3))){
var inst_19282 = (state_19284[(2)]);
var state_19284__$1 = state_19284;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19284__$1,inst_19282);
} else {
if((state_val_19285 === (12))){
var inst_19270 = (state_19284[(8)]);
var inst_19270__$1 = (state_19284[(2)]);
var inst_19271 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19270__$1);
var state_19284__$1 = (function (){var statearr_19293 = state_19284;
(statearr_19293[(8)] = inst_19270__$1);

return statearr_19293;
})();
if(cljs.core.truth_(inst_19271)){
var statearr_19294_19326 = state_19284__$1;
(statearr_19294_19326[(1)] = (13));

} else {
var statearr_19295_19327 = state_19284__$1;
(statearr_19295_19327[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (2))){
var inst_19247 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19248 = (0);
var state_19284__$1 = (function (){var statearr_19296 = state_19284;
(statearr_19296[(9)] = inst_19247);

(statearr_19296[(7)] = inst_19248);

return statearr_19296;
})();
var statearr_19297_19328 = state_19284__$1;
(statearr_19297_19328[(2)] = null);

(statearr_19297_19328[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (11))){
var inst_19248 = (state_19284[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19284,(10),Object,null,(9));
var inst_19257 = chs__$1.call(null,inst_19248);
var inst_19258 = done.call(null,inst_19248);
var inst_19259 = cljs.core.async.take_BANG_.call(null,inst_19257,inst_19258);
var state_19284__$1 = state_19284;
var statearr_19298_19329 = state_19284__$1;
(statearr_19298_19329[(2)] = inst_19259);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19284__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (9))){
var inst_19248 = (state_19284[(7)]);
var inst_19261 = (state_19284[(2)]);
var inst_19262 = (inst_19248 + (1));
var inst_19248__$1 = inst_19262;
var state_19284__$1 = (function (){var statearr_19299 = state_19284;
(statearr_19299[(10)] = inst_19261);

(statearr_19299[(7)] = inst_19248__$1);

return statearr_19299;
})();
var statearr_19300_19330 = state_19284__$1;
(statearr_19300_19330[(2)] = null);

(statearr_19300_19330[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (5))){
var inst_19268 = (state_19284[(2)]);
var state_19284__$1 = (function (){var statearr_19301 = state_19284;
(statearr_19301[(11)] = inst_19268);

return statearr_19301;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19284__$1,(12),dchan);
} else {
if((state_val_19285 === (14))){
var inst_19270 = (state_19284[(8)]);
var inst_19275 = cljs.core.apply.call(null,f,inst_19270);
var state_19284__$1 = state_19284;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19284__$1,(16),out,inst_19275);
} else {
if((state_val_19285 === (16))){
var inst_19277 = (state_19284[(2)]);
var state_19284__$1 = (function (){var statearr_19302 = state_19284;
(statearr_19302[(12)] = inst_19277);

return statearr_19302;
})();
var statearr_19303_19331 = state_19284__$1;
(statearr_19303_19331[(2)] = null);

(statearr_19303_19331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (10))){
var inst_19252 = (state_19284[(2)]);
var inst_19253 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19284__$1 = (function (){var statearr_19304 = state_19284;
(statearr_19304[(13)] = inst_19252);

return statearr_19304;
})();
var statearr_19305_19332 = state_19284__$1;
(statearr_19305_19332[(2)] = inst_19253);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19284__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19285 === (8))){
var inst_19266 = (state_19284[(2)]);
var state_19284__$1 = state_19284;
var statearr_19306_19333 = state_19284__$1;
(statearr_19306_19333[(2)] = inst_19266);

(statearr_19306_19333[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19318,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19318,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19310[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19310[(1)] = (1));

return statearr_19310;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19284){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19284);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19311){if((e19311 instanceof Object)){
var ex__8254__auto__ = e19311;
var statearr_19312_19334 = state_19284;
(statearr_19312_19334[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19284);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19311;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19335 = state_19284;
state_19284 = G__19335;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19284){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19318,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19313 = f__8363__auto__.call(null);
(statearr_19313[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19318);

return statearr_19313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19318,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19337 = [];
var len__5726__auto___19393 = arguments.length;
var i__5727__auto___19394 = (0);
while(true){
if((i__5727__auto___19394 < len__5726__auto___19393)){
args19337.push((arguments[i__5727__auto___19394]));

var G__19395 = (i__5727__auto___19394 + (1));
i__5727__auto___19394 = G__19395;
continue;
} else {
}
break;
}

var G__19339 = args19337.length;
switch (G__19339) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19337.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19397 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19397,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19397,out){
return (function (state_19369){
var state_val_19370 = (state_19369[(1)]);
if((state_val_19370 === (7))){
var inst_19348 = (state_19369[(7)]);
var inst_19349 = (state_19369[(8)]);
var inst_19348__$1 = (state_19369[(2)]);
var inst_19349__$1 = cljs.core.nth.call(null,inst_19348__$1,(0),null);
var inst_19350 = cljs.core.nth.call(null,inst_19348__$1,(1),null);
var inst_19351 = (inst_19349__$1 == null);
var state_19369__$1 = (function (){var statearr_19371 = state_19369;
(statearr_19371[(7)] = inst_19348__$1);

(statearr_19371[(9)] = inst_19350);

(statearr_19371[(8)] = inst_19349__$1);

return statearr_19371;
})();
if(cljs.core.truth_(inst_19351)){
var statearr_19372_19398 = state_19369__$1;
(statearr_19372_19398[(1)] = (8));

} else {
var statearr_19373_19399 = state_19369__$1;
(statearr_19373_19399[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (1))){
var inst_19340 = cljs.core.vec.call(null,chs);
var inst_19341 = inst_19340;
var state_19369__$1 = (function (){var statearr_19374 = state_19369;
(statearr_19374[(10)] = inst_19341);

return statearr_19374;
})();
var statearr_19375_19400 = state_19369__$1;
(statearr_19375_19400[(2)] = null);

(statearr_19375_19400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (4))){
var inst_19341 = (state_19369[(10)]);
var state_19369__$1 = state_19369;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19369__$1,(7),inst_19341);
} else {
if((state_val_19370 === (6))){
var inst_19365 = (state_19369[(2)]);
var state_19369__$1 = state_19369;
var statearr_19376_19401 = state_19369__$1;
(statearr_19376_19401[(2)] = inst_19365);

(statearr_19376_19401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (3))){
var inst_19367 = (state_19369[(2)]);
var state_19369__$1 = state_19369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19369__$1,inst_19367);
} else {
if((state_val_19370 === (2))){
var inst_19341 = (state_19369[(10)]);
var inst_19343 = cljs.core.count.call(null,inst_19341);
var inst_19344 = (inst_19343 > (0));
var state_19369__$1 = state_19369;
if(cljs.core.truth_(inst_19344)){
var statearr_19378_19402 = state_19369__$1;
(statearr_19378_19402[(1)] = (4));

} else {
var statearr_19379_19403 = state_19369__$1;
(statearr_19379_19403[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (11))){
var inst_19341 = (state_19369[(10)]);
var inst_19358 = (state_19369[(2)]);
var tmp19377 = inst_19341;
var inst_19341__$1 = tmp19377;
var state_19369__$1 = (function (){var statearr_19380 = state_19369;
(statearr_19380[(10)] = inst_19341__$1);

(statearr_19380[(11)] = inst_19358);

return statearr_19380;
})();
var statearr_19381_19404 = state_19369__$1;
(statearr_19381_19404[(2)] = null);

(statearr_19381_19404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (9))){
var inst_19349 = (state_19369[(8)]);
var state_19369__$1 = state_19369;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19369__$1,(11),out,inst_19349);
} else {
if((state_val_19370 === (5))){
var inst_19363 = cljs.core.async.close_BANG_.call(null,out);
var state_19369__$1 = state_19369;
var statearr_19382_19405 = state_19369__$1;
(statearr_19382_19405[(2)] = inst_19363);

(statearr_19382_19405[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (10))){
var inst_19361 = (state_19369[(2)]);
var state_19369__$1 = state_19369;
var statearr_19383_19406 = state_19369__$1;
(statearr_19383_19406[(2)] = inst_19361);

(statearr_19383_19406[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19370 === (8))){
var inst_19348 = (state_19369[(7)]);
var inst_19350 = (state_19369[(9)]);
var inst_19341 = (state_19369[(10)]);
var inst_19349 = (state_19369[(8)]);
var inst_19353 = (function (){var cs = inst_19341;
var vec__19346 = inst_19348;
var v = inst_19349;
var c = inst_19350;
return ((function (cs,vec__19346,v,c,inst_19348,inst_19350,inst_19341,inst_19349,state_val_19370,c__8362__auto___19397,out){
return (function (p1__19336_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19336_SHARP_);
});
;})(cs,vec__19346,v,c,inst_19348,inst_19350,inst_19341,inst_19349,state_val_19370,c__8362__auto___19397,out))
})();
var inst_19354 = cljs.core.filterv.call(null,inst_19353,inst_19341);
var inst_19341__$1 = inst_19354;
var state_19369__$1 = (function (){var statearr_19384 = state_19369;
(statearr_19384[(10)] = inst_19341__$1);

return statearr_19384;
})();
var statearr_19385_19407 = state_19369__$1;
(statearr_19385_19407[(2)] = null);

(statearr_19385_19407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19397,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19397,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19389 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19389[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19389[(1)] = (1));

return statearr_19389;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19369){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19390){if((e19390 instanceof Object)){
var ex__8254__auto__ = e19390;
var statearr_19391_19408 = state_19369;
(statearr_19391_19408[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19369);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19390;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19409 = state_19369;
state_19369 = G__19409;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19369){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19397,out))
})();
var state__8364__auto__ = (function (){var statearr_19392 = f__8363__auto__.call(null);
(statearr_19392[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19397);

return statearr_19392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19397,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19410 = [];
var len__5726__auto___19459 = arguments.length;
var i__5727__auto___19460 = (0);
while(true){
if((i__5727__auto___19460 < len__5726__auto___19459)){
args19410.push((arguments[i__5727__auto___19460]));

var G__19461 = (i__5727__auto___19460 + (1));
i__5727__auto___19460 = G__19461;
continue;
} else {
}
break;
}

var G__19412 = args19410.length;
switch (G__19412) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19410.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19463 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19463,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19463,out){
return (function (state_19436){
var state_val_19437 = (state_19436[(1)]);
if((state_val_19437 === (7))){
var inst_19418 = (state_19436[(7)]);
var inst_19418__$1 = (state_19436[(2)]);
var inst_19419 = (inst_19418__$1 == null);
var inst_19420 = cljs.core.not.call(null,inst_19419);
var state_19436__$1 = (function (){var statearr_19438 = state_19436;
(statearr_19438[(7)] = inst_19418__$1);

return statearr_19438;
})();
if(inst_19420){
var statearr_19439_19464 = state_19436__$1;
(statearr_19439_19464[(1)] = (8));

} else {
var statearr_19440_19465 = state_19436__$1;
(statearr_19440_19465[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19437 === (1))){
var inst_19413 = (0);
var state_19436__$1 = (function (){var statearr_19441 = state_19436;
(statearr_19441[(8)] = inst_19413);

return statearr_19441;
})();
var statearr_19442_19466 = state_19436__$1;
(statearr_19442_19466[(2)] = null);

(statearr_19442_19466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19437 === (4))){
var state_19436__$1 = state_19436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19436__$1,(7),ch);
} else {
if((state_val_19437 === (6))){
var inst_19431 = (state_19436[(2)]);
var state_19436__$1 = state_19436;
var statearr_19443_19467 = state_19436__$1;
(statearr_19443_19467[(2)] = inst_19431);

(statearr_19443_19467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19437 === (3))){
var inst_19433 = (state_19436[(2)]);
var inst_19434 = cljs.core.async.close_BANG_.call(null,out);
var state_19436__$1 = (function (){var statearr_19444 = state_19436;
(statearr_19444[(9)] = inst_19433);

return statearr_19444;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19436__$1,inst_19434);
} else {
if((state_val_19437 === (2))){
var inst_19413 = (state_19436[(8)]);
var inst_19415 = (inst_19413 < n);
var state_19436__$1 = state_19436;
if(cljs.core.truth_(inst_19415)){
var statearr_19445_19468 = state_19436__$1;
(statearr_19445_19468[(1)] = (4));

} else {
var statearr_19446_19469 = state_19436__$1;
(statearr_19446_19469[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19437 === (11))){
var inst_19413 = (state_19436[(8)]);
var inst_19423 = (state_19436[(2)]);
var inst_19424 = (inst_19413 + (1));
var inst_19413__$1 = inst_19424;
var state_19436__$1 = (function (){var statearr_19447 = state_19436;
(statearr_19447[(8)] = inst_19413__$1);

(statearr_19447[(10)] = inst_19423);

return statearr_19447;
})();
var statearr_19448_19470 = state_19436__$1;
(statearr_19448_19470[(2)] = null);

(statearr_19448_19470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19437 === (9))){
var state_19436__$1 = state_19436;
var statearr_19449_19471 = state_19436__$1;
(statearr_19449_19471[(2)] = null);

(statearr_19449_19471[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19437 === (5))){
var state_19436__$1 = state_19436;
var statearr_19450_19472 = state_19436__$1;
(statearr_19450_19472[(2)] = null);

(statearr_19450_19472[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19437 === (10))){
var inst_19428 = (state_19436[(2)]);
var state_19436__$1 = state_19436;
var statearr_19451_19473 = state_19436__$1;
(statearr_19451_19473[(2)] = inst_19428);

(statearr_19451_19473[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19437 === (8))){
var inst_19418 = (state_19436[(7)]);
var state_19436__$1 = state_19436;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19436__$1,(11),out,inst_19418);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19463,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19463,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19455 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19455[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19455[(1)] = (1));

return statearr_19455;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19436){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19456){if((e19456 instanceof Object)){
var ex__8254__auto__ = e19456;
var statearr_19457_19474 = state_19436;
(statearr_19457_19474[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19436);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19456;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19475 = state_19436;
state_19436 = G__19475;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19436){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19463,out))
})();
var state__8364__auto__ = (function (){var statearr_19458 = f__8363__auto__.call(null);
(statearr_19458[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19463);

return statearr_19458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19463,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19483 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19483 = (function (map_LT_,f,ch,meta19484){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19484 = meta19484;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19485,meta19484__$1){
var self__ = this;
var _19485__$1 = this;
return (new cljs.core.async.t_cljs$core$async19483(self__.map_LT_,self__.f,self__.ch,meta19484__$1));
});

cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19485){
var self__ = this;
var _19485__$1 = this;
return self__.meta19484;
});

cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19486 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19486 = (function (map_LT_,f,ch,meta19484,_,fn1,meta19487){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19484 = meta19484;
this._ = _;
this.fn1 = fn1;
this.meta19487 = meta19487;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19488,meta19487__$1){
var self__ = this;
var _19488__$1 = this;
return (new cljs.core.async.t_cljs$core$async19486(self__.map_LT_,self__.f,self__.ch,self__.meta19484,self__._,self__.fn1,meta19487__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19488){
var self__ = this;
var _19488__$1 = this;
return self__.meta19487;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19486.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19476_SHARP_){
return f1.call(null,(((p1__19476_SHARP_ == null))?null:self__.f.call(null,p1__19476_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19486.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19484","meta19484",1793565277,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19483","cljs.core.async/t_cljs$core$async19483",22333362,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19487","meta19487",-466486377,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19486.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19486.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19486";

cljs.core.async.t_cljs$core$async19486.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19486");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19486 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19486(map_LT___$1,f__$1,ch__$1,meta19484__$1,___$2,fn1__$1,meta19487){
return (new cljs.core.async.t_cljs$core$async19486(map_LT___$1,f__$1,ch__$1,meta19484__$1,___$2,fn1__$1,meta19487));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19486(self__.map_LT_,self__.f,self__.ch,self__.meta19484,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19483.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19483.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19484","meta19484",1793565277,null)], null);
});

cljs.core.async.t_cljs$core$async19483.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19483.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19483";

cljs.core.async.t_cljs$core$async19483.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19483");
});

cljs.core.async.__GT_t_cljs$core$async19483 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19483(map_LT___$1,f__$1,ch__$1,meta19484){
return (new cljs.core.async.t_cljs$core$async19483(map_LT___$1,f__$1,ch__$1,meta19484));
});

}

return (new cljs.core.async.t_cljs$core$async19483(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19492 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19492 = (function (map_GT_,f,ch,meta19493){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19493 = meta19493;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19494,meta19493__$1){
var self__ = this;
var _19494__$1 = this;
return (new cljs.core.async.t_cljs$core$async19492(self__.map_GT_,self__.f,self__.ch,meta19493__$1));
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19494){
var self__ = this;
var _19494__$1 = this;
return self__.meta19493;
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19492.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19492.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19493","meta19493",1346209505,null)], null);
});

cljs.core.async.t_cljs$core$async19492.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19492.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19492";

cljs.core.async.t_cljs$core$async19492.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19492");
});

cljs.core.async.__GT_t_cljs$core$async19492 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19492(map_GT___$1,f__$1,ch__$1,meta19493){
return (new cljs.core.async.t_cljs$core$async19492(map_GT___$1,f__$1,ch__$1,meta19493));
});

}

return (new cljs.core.async.t_cljs$core$async19492(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19498 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19498 = (function (filter_GT_,p,ch,meta19499){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19499 = meta19499;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19500,meta19499__$1){
var self__ = this;
var _19500__$1 = this;
return (new cljs.core.async.t_cljs$core$async19498(self__.filter_GT_,self__.p,self__.ch,meta19499__$1));
});

cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19500){
var self__ = this;
var _19500__$1 = this;
return self__.meta19499;
});

cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19498.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19498.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19499","meta19499",398714498,null)], null);
});

cljs.core.async.t_cljs$core$async19498.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19498.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19498";

cljs.core.async.t_cljs$core$async19498.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19498");
});

cljs.core.async.__GT_t_cljs$core$async19498 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19498(filter_GT___$1,p__$1,ch__$1,meta19499){
return (new cljs.core.async.t_cljs$core$async19498(filter_GT___$1,p__$1,ch__$1,meta19499));
});

}

return (new cljs.core.async.t_cljs$core$async19498(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19501 = [];
var len__5726__auto___19545 = arguments.length;
var i__5727__auto___19546 = (0);
while(true){
if((i__5727__auto___19546 < len__5726__auto___19545)){
args19501.push((arguments[i__5727__auto___19546]));

var G__19547 = (i__5727__auto___19546 + (1));
i__5727__auto___19546 = G__19547;
continue;
} else {
}
break;
}

var G__19503 = args19501.length;
switch (G__19503) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19501.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19549 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19549,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19549,out){
return (function (state_19524){
var state_val_19525 = (state_19524[(1)]);
if((state_val_19525 === (7))){
var inst_19520 = (state_19524[(2)]);
var state_19524__$1 = state_19524;
var statearr_19526_19550 = state_19524__$1;
(statearr_19526_19550[(2)] = inst_19520);

(statearr_19526_19550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (1))){
var state_19524__$1 = state_19524;
var statearr_19527_19551 = state_19524__$1;
(statearr_19527_19551[(2)] = null);

(statearr_19527_19551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (4))){
var inst_19506 = (state_19524[(7)]);
var inst_19506__$1 = (state_19524[(2)]);
var inst_19507 = (inst_19506__$1 == null);
var state_19524__$1 = (function (){var statearr_19528 = state_19524;
(statearr_19528[(7)] = inst_19506__$1);

return statearr_19528;
})();
if(cljs.core.truth_(inst_19507)){
var statearr_19529_19552 = state_19524__$1;
(statearr_19529_19552[(1)] = (5));

} else {
var statearr_19530_19553 = state_19524__$1;
(statearr_19530_19553[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (6))){
var inst_19506 = (state_19524[(7)]);
var inst_19511 = p.call(null,inst_19506);
var state_19524__$1 = state_19524;
if(cljs.core.truth_(inst_19511)){
var statearr_19531_19554 = state_19524__$1;
(statearr_19531_19554[(1)] = (8));

} else {
var statearr_19532_19555 = state_19524__$1;
(statearr_19532_19555[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (3))){
var inst_19522 = (state_19524[(2)]);
var state_19524__$1 = state_19524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19524__$1,inst_19522);
} else {
if((state_val_19525 === (2))){
var state_19524__$1 = state_19524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19524__$1,(4),ch);
} else {
if((state_val_19525 === (11))){
var inst_19514 = (state_19524[(2)]);
var state_19524__$1 = state_19524;
var statearr_19533_19556 = state_19524__$1;
(statearr_19533_19556[(2)] = inst_19514);

(statearr_19533_19556[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (9))){
var state_19524__$1 = state_19524;
var statearr_19534_19557 = state_19524__$1;
(statearr_19534_19557[(2)] = null);

(statearr_19534_19557[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (5))){
var inst_19509 = cljs.core.async.close_BANG_.call(null,out);
var state_19524__$1 = state_19524;
var statearr_19535_19558 = state_19524__$1;
(statearr_19535_19558[(2)] = inst_19509);

(statearr_19535_19558[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (10))){
var inst_19517 = (state_19524[(2)]);
var state_19524__$1 = (function (){var statearr_19536 = state_19524;
(statearr_19536[(8)] = inst_19517);

return statearr_19536;
})();
var statearr_19537_19559 = state_19524__$1;
(statearr_19537_19559[(2)] = null);

(statearr_19537_19559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19525 === (8))){
var inst_19506 = (state_19524[(7)]);
var state_19524__$1 = state_19524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19524__$1,(11),out,inst_19506);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19549,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19549,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19541 = [null,null,null,null,null,null,null,null,null];
(statearr_19541[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19541[(1)] = (1));

return statearr_19541;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19524){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19542){if((e19542 instanceof Object)){
var ex__8254__auto__ = e19542;
var statearr_19543_19560 = state_19524;
(statearr_19543_19560[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19542;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19561 = state_19524;
state_19524 = G__19561;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19549,out))
})();
var state__8364__auto__ = (function (){var statearr_19544 = f__8363__auto__.call(null);
(statearr_19544[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19549);

return statearr_19544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19549,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19562 = [];
var len__5726__auto___19565 = arguments.length;
var i__5727__auto___19566 = (0);
while(true){
if((i__5727__auto___19566 < len__5726__auto___19565)){
args19562.push((arguments[i__5727__auto___19566]));

var G__19567 = (i__5727__auto___19566 + (1));
i__5727__auto___19566 = G__19567;
continue;
} else {
}
break;
}

var G__19564 = args19562.length;
switch (G__19564) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19562.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19734){
var state_val_19735 = (state_19734[(1)]);
if((state_val_19735 === (7))){
var inst_19730 = (state_19734[(2)]);
var state_19734__$1 = state_19734;
var statearr_19736_19777 = state_19734__$1;
(statearr_19736_19777[(2)] = inst_19730);

(statearr_19736_19777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (20))){
var inst_19700 = (state_19734[(7)]);
var inst_19711 = (state_19734[(2)]);
var inst_19712 = cljs.core.next.call(null,inst_19700);
var inst_19686 = inst_19712;
var inst_19687 = null;
var inst_19688 = (0);
var inst_19689 = (0);
var state_19734__$1 = (function (){var statearr_19737 = state_19734;
(statearr_19737[(8)] = inst_19688);

(statearr_19737[(9)] = inst_19689);

(statearr_19737[(10)] = inst_19686);

(statearr_19737[(11)] = inst_19711);

(statearr_19737[(12)] = inst_19687);

return statearr_19737;
})();
var statearr_19738_19778 = state_19734__$1;
(statearr_19738_19778[(2)] = null);

(statearr_19738_19778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (1))){
var state_19734__$1 = state_19734;
var statearr_19739_19779 = state_19734__$1;
(statearr_19739_19779[(2)] = null);

(statearr_19739_19779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (4))){
var inst_19675 = (state_19734[(13)]);
var inst_19675__$1 = (state_19734[(2)]);
var inst_19676 = (inst_19675__$1 == null);
var state_19734__$1 = (function (){var statearr_19740 = state_19734;
(statearr_19740[(13)] = inst_19675__$1);

return statearr_19740;
})();
if(cljs.core.truth_(inst_19676)){
var statearr_19741_19780 = state_19734__$1;
(statearr_19741_19780[(1)] = (5));

} else {
var statearr_19742_19781 = state_19734__$1;
(statearr_19742_19781[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (15))){
var state_19734__$1 = state_19734;
var statearr_19746_19782 = state_19734__$1;
(statearr_19746_19782[(2)] = null);

(statearr_19746_19782[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (21))){
var state_19734__$1 = state_19734;
var statearr_19747_19783 = state_19734__$1;
(statearr_19747_19783[(2)] = null);

(statearr_19747_19783[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (13))){
var inst_19688 = (state_19734[(8)]);
var inst_19689 = (state_19734[(9)]);
var inst_19686 = (state_19734[(10)]);
var inst_19687 = (state_19734[(12)]);
var inst_19696 = (state_19734[(2)]);
var inst_19697 = (inst_19689 + (1));
var tmp19743 = inst_19688;
var tmp19744 = inst_19686;
var tmp19745 = inst_19687;
var inst_19686__$1 = tmp19744;
var inst_19687__$1 = tmp19745;
var inst_19688__$1 = tmp19743;
var inst_19689__$1 = inst_19697;
var state_19734__$1 = (function (){var statearr_19748 = state_19734;
(statearr_19748[(8)] = inst_19688__$1);

(statearr_19748[(9)] = inst_19689__$1);

(statearr_19748[(10)] = inst_19686__$1);

(statearr_19748[(12)] = inst_19687__$1);

(statearr_19748[(14)] = inst_19696);

return statearr_19748;
})();
var statearr_19749_19784 = state_19734__$1;
(statearr_19749_19784[(2)] = null);

(statearr_19749_19784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (22))){
var state_19734__$1 = state_19734;
var statearr_19750_19785 = state_19734__$1;
(statearr_19750_19785[(2)] = null);

(statearr_19750_19785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (6))){
var inst_19675 = (state_19734[(13)]);
var inst_19684 = f.call(null,inst_19675);
var inst_19685 = cljs.core.seq.call(null,inst_19684);
var inst_19686 = inst_19685;
var inst_19687 = null;
var inst_19688 = (0);
var inst_19689 = (0);
var state_19734__$1 = (function (){var statearr_19751 = state_19734;
(statearr_19751[(8)] = inst_19688);

(statearr_19751[(9)] = inst_19689);

(statearr_19751[(10)] = inst_19686);

(statearr_19751[(12)] = inst_19687);

return statearr_19751;
})();
var statearr_19752_19786 = state_19734__$1;
(statearr_19752_19786[(2)] = null);

(statearr_19752_19786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (17))){
var inst_19700 = (state_19734[(7)]);
var inst_19704 = cljs.core.chunk_first.call(null,inst_19700);
var inst_19705 = cljs.core.chunk_rest.call(null,inst_19700);
var inst_19706 = cljs.core.count.call(null,inst_19704);
var inst_19686 = inst_19705;
var inst_19687 = inst_19704;
var inst_19688 = inst_19706;
var inst_19689 = (0);
var state_19734__$1 = (function (){var statearr_19753 = state_19734;
(statearr_19753[(8)] = inst_19688);

(statearr_19753[(9)] = inst_19689);

(statearr_19753[(10)] = inst_19686);

(statearr_19753[(12)] = inst_19687);

return statearr_19753;
})();
var statearr_19754_19787 = state_19734__$1;
(statearr_19754_19787[(2)] = null);

(statearr_19754_19787[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (3))){
var inst_19732 = (state_19734[(2)]);
var state_19734__$1 = state_19734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19734__$1,inst_19732);
} else {
if((state_val_19735 === (12))){
var inst_19720 = (state_19734[(2)]);
var state_19734__$1 = state_19734;
var statearr_19755_19788 = state_19734__$1;
(statearr_19755_19788[(2)] = inst_19720);

(statearr_19755_19788[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (2))){
var state_19734__$1 = state_19734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19734__$1,(4),in$);
} else {
if((state_val_19735 === (23))){
var inst_19728 = (state_19734[(2)]);
var state_19734__$1 = state_19734;
var statearr_19756_19789 = state_19734__$1;
(statearr_19756_19789[(2)] = inst_19728);

(statearr_19756_19789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (19))){
var inst_19715 = (state_19734[(2)]);
var state_19734__$1 = state_19734;
var statearr_19757_19790 = state_19734__$1;
(statearr_19757_19790[(2)] = inst_19715);

(statearr_19757_19790[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (11))){
var inst_19700 = (state_19734[(7)]);
var inst_19686 = (state_19734[(10)]);
var inst_19700__$1 = cljs.core.seq.call(null,inst_19686);
var state_19734__$1 = (function (){var statearr_19758 = state_19734;
(statearr_19758[(7)] = inst_19700__$1);

return statearr_19758;
})();
if(inst_19700__$1){
var statearr_19759_19791 = state_19734__$1;
(statearr_19759_19791[(1)] = (14));

} else {
var statearr_19760_19792 = state_19734__$1;
(statearr_19760_19792[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (9))){
var inst_19722 = (state_19734[(2)]);
var inst_19723 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19734__$1 = (function (){var statearr_19761 = state_19734;
(statearr_19761[(15)] = inst_19722);

return statearr_19761;
})();
if(cljs.core.truth_(inst_19723)){
var statearr_19762_19793 = state_19734__$1;
(statearr_19762_19793[(1)] = (21));

} else {
var statearr_19763_19794 = state_19734__$1;
(statearr_19763_19794[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (5))){
var inst_19678 = cljs.core.async.close_BANG_.call(null,out);
var state_19734__$1 = state_19734;
var statearr_19764_19795 = state_19734__$1;
(statearr_19764_19795[(2)] = inst_19678);

(statearr_19764_19795[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (14))){
var inst_19700 = (state_19734[(7)]);
var inst_19702 = cljs.core.chunked_seq_QMARK_.call(null,inst_19700);
var state_19734__$1 = state_19734;
if(inst_19702){
var statearr_19765_19796 = state_19734__$1;
(statearr_19765_19796[(1)] = (17));

} else {
var statearr_19766_19797 = state_19734__$1;
(statearr_19766_19797[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (16))){
var inst_19718 = (state_19734[(2)]);
var state_19734__$1 = state_19734;
var statearr_19767_19798 = state_19734__$1;
(statearr_19767_19798[(2)] = inst_19718);

(statearr_19767_19798[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19735 === (10))){
var inst_19689 = (state_19734[(9)]);
var inst_19687 = (state_19734[(12)]);
var inst_19694 = cljs.core._nth.call(null,inst_19687,inst_19689);
var state_19734__$1 = state_19734;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19734__$1,(13),out,inst_19694);
} else {
if((state_val_19735 === (18))){
var inst_19700 = (state_19734[(7)]);
var inst_19709 = cljs.core.first.call(null,inst_19700);
var state_19734__$1 = state_19734;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19734__$1,(20),out,inst_19709);
} else {
if((state_val_19735 === (8))){
var inst_19688 = (state_19734[(8)]);
var inst_19689 = (state_19734[(9)]);
var inst_19691 = (inst_19689 < inst_19688);
var inst_19692 = inst_19691;
var state_19734__$1 = state_19734;
if(cljs.core.truth_(inst_19692)){
var statearr_19768_19799 = state_19734__$1;
(statearr_19768_19799[(1)] = (10));

} else {
var statearr_19769_19800 = state_19734__$1;
(statearr_19769_19800[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19773 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19773[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19773[(1)] = (1));

return statearr_19773;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19734){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19774){if((e19774 instanceof Object)){
var ex__8254__auto__ = e19774;
var statearr_19775_19801 = state_19734;
(statearr_19775_19801[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19734);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19774;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19802 = state_19734;
state_19734 = G__19802;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19734){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19776 = f__8363__auto__.call(null);
(statearr_19776[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19803 = [];
var len__5726__auto___19806 = arguments.length;
var i__5727__auto___19807 = (0);
while(true){
if((i__5727__auto___19807 < len__5726__auto___19806)){
args19803.push((arguments[i__5727__auto___19807]));

var G__19808 = (i__5727__auto___19807 + (1));
i__5727__auto___19807 = G__19808;
continue;
} else {
}
break;
}

var G__19805 = args19803.length;
switch (G__19805) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19803.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19810 = [];
var len__5726__auto___19813 = arguments.length;
var i__5727__auto___19814 = (0);
while(true){
if((i__5727__auto___19814 < len__5726__auto___19813)){
args19810.push((arguments[i__5727__auto___19814]));

var G__19815 = (i__5727__auto___19814 + (1));
i__5727__auto___19814 = G__19815;
continue;
} else {
}
break;
}

var G__19812 = args19810.length;
switch (G__19812) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19810.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19817 = [];
var len__5726__auto___19868 = arguments.length;
var i__5727__auto___19869 = (0);
while(true){
if((i__5727__auto___19869 < len__5726__auto___19868)){
args19817.push((arguments[i__5727__auto___19869]));

var G__19870 = (i__5727__auto___19869 + (1));
i__5727__auto___19869 = G__19870;
continue;
} else {
}
break;
}

var G__19819 = args19817.length;
switch (G__19819) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19817.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19872 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19872,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19872,out){
return (function (state_19843){
var state_val_19844 = (state_19843[(1)]);
if((state_val_19844 === (7))){
var inst_19838 = (state_19843[(2)]);
var state_19843__$1 = state_19843;
var statearr_19845_19873 = state_19843__$1;
(statearr_19845_19873[(2)] = inst_19838);

(statearr_19845_19873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19844 === (1))){
var inst_19820 = null;
var state_19843__$1 = (function (){var statearr_19846 = state_19843;
(statearr_19846[(7)] = inst_19820);

return statearr_19846;
})();
var statearr_19847_19874 = state_19843__$1;
(statearr_19847_19874[(2)] = null);

(statearr_19847_19874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19844 === (4))){
var inst_19823 = (state_19843[(8)]);
var inst_19823__$1 = (state_19843[(2)]);
var inst_19824 = (inst_19823__$1 == null);
var inst_19825 = cljs.core.not.call(null,inst_19824);
var state_19843__$1 = (function (){var statearr_19848 = state_19843;
(statearr_19848[(8)] = inst_19823__$1);

return statearr_19848;
})();
if(inst_19825){
var statearr_19849_19875 = state_19843__$1;
(statearr_19849_19875[(1)] = (5));

} else {
var statearr_19850_19876 = state_19843__$1;
(statearr_19850_19876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19844 === (6))){
var state_19843__$1 = state_19843;
var statearr_19851_19877 = state_19843__$1;
(statearr_19851_19877[(2)] = null);

(statearr_19851_19877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19844 === (3))){
var inst_19840 = (state_19843[(2)]);
var inst_19841 = cljs.core.async.close_BANG_.call(null,out);
var state_19843__$1 = (function (){var statearr_19852 = state_19843;
(statearr_19852[(9)] = inst_19840);

return statearr_19852;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19843__$1,inst_19841);
} else {
if((state_val_19844 === (2))){
var state_19843__$1 = state_19843;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19843__$1,(4),ch);
} else {
if((state_val_19844 === (11))){
var inst_19823 = (state_19843[(8)]);
var inst_19832 = (state_19843[(2)]);
var inst_19820 = inst_19823;
var state_19843__$1 = (function (){var statearr_19853 = state_19843;
(statearr_19853[(7)] = inst_19820);

(statearr_19853[(10)] = inst_19832);

return statearr_19853;
})();
var statearr_19854_19878 = state_19843__$1;
(statearr_19854_19878[(2)] = null);

(statearr_19854_19878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19844 === (9))){
var inst_19823 = (state_19843[(8)]);
var state_19843__$1 = state_19843;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19843__$1,(11),out,inst_19823);
} else {
if((state_val_19844 === (5))){
var inst_19820 = (state_19843[(7)]);
var inst_19823 = (state_19843[(8)]);
var inst_19827 = cljs.core._EQ_.call(null,inst_19823,inst_19820);
var state_19843__$1 = state_19843;
if(inst_19827){
var statearr_19856_19879 = state_19843__$1;
(statearr_19856_19879[(1)] = (8));

} else {
var statearr_19857_19880 = state_19843__$1;
(statearr_19857_19880[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19844 === (10))){
var inst_19835 = (state_19843[(2)]);
var state_19843__$1 = state_19843;
var statearr_19858_19881 = state_19843__$1;
(statearr_19858_19881[(2)] = inst_19835);

(statearr_19858_19881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19844 === (8))){
var inst_19820 = (state_19843[(7)]);
var tmp19855 = inst_19820;
var inst_19820__$1 = tmp19855;
var state_19843__$1 = (function (){var statearr_19859 = state_19843;
(statearr_19859[(7)] = inst_19820__$1);

return statearr_19859;
})();
var statearr_19860_19882 = state_19843__$1;
(statearr_19860_19882[(2)] = null);

(statearr_19860_19882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19872,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19872,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19864 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19864[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19864[(1)] = (1));

return statearr_19864;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19843){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19843);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19865){if((e19865 instanceof Object)){
var ex__8254__auto__ = e19865;
var statearr_19866_19883 = state_19843;
(statearr_19866_19883[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19843);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19865;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19884 = state_19843;
state_19843 = G__19884;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19843){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19872,out))
})();
var state__8364__auto__ = (function (){var statearr_19867 = f__8363__auto__.call(null);
(statearr_19867[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19872);

return statearr_19867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19872,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19885 = [];
var len__5726__auto___19955 = arguments.length;
var i__5727__auto___19956 = (0);
while(true){
if((i__5727__auto___19956 < len__5726__auto___19955)){
args19885.push((arguments[i__5727__auto___19956]));

var G__19957 = (i__5727__auto___19956 + (1));
i__5727__auto___19956 = G__19957;
continue;
} else {
}
break;
}

var G__19887 = args19885.length;
switch (G__19887) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19885.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19959 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19959,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19959,out){
return (function (state_19925){
var state_val_19926 = (state_19925[(1)]);
if((state_val_19926 === (7))){
var inst_19921 = (state_19925[(2)]);
var state_19925__$1 = state_19925;
var statearr_19927_19960 = state_19925__$1;
(statearr_19927_19960[(2)] = inst_19921);

(statearr_19927_19960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (1))){
var inst_19888 = (new Array(n));
var inst_19889 = inst_19888;
var inst_19890 = (0);
var state_19925__$1 = (function (){var statearr_19928 = state_19925;
(statearr_19928[(7)] = inst_19889);

(statearr_19928[(8)] = inst_19890);

return statearr_19928;
})();
var statearr_19929_19961 = state_19925__$1;
(statearr_19929_19961[(2)] = null);

(statearr_19929_19961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (4))){
var inst_19893 = (state_19925[(9)]);
var inst_19893__$1 = (state_19925[(2)]);
var inst_19894 = (inst_19893__$1 == null);
var inst_19895 = cljs.core.not.call(null,inst_19894);
var state_19925__$1 = (function (){var statearr_19930 = state_19925;
(statearr_19930[(9)] = inst_19893__$1);

return statearr_19930;
})();
if(inst_19895){
var statearr_19931_19962 = state_19925__$1;
(statearr_19931_19962[(1)] = (5));

} else {
var statearr_19932_19963 = state_19925__$1;
(statearr_19932_19963[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (15))){
var inst_19915 = (state_19925[(2)]);
var state_19925__$1 = state_19925;
var statearr_19933_19964 = state_19925__$1;
(statearr_19933_19964[(2)] = inst_19915);

(statearr_19933_19964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (13))){
var state_19925__$1 = state_19925;
var statearr_19934_19965 = state_19925__$1;
(statearr_19934_19965[(2)] = null);

(statearr_19934_19965[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (6))){
var inst_19890 = (state_19925[(8)]);
var inst_19911 = (inst_19890 > (0));
var state_19925__$1 = state_19925;
if(cljs.core.truth_(inst_19911)){
var statearr_19935_19966 = state_19925__$1;
(statearr_19935_19966[(1)] = (12));

} else {
var statearr_19936_19967 = state_19925__$1;
(statearr_19936_19967[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (3))){
var inst_19923 = (state_19925[(2)]);
var state_19925__$1 = state_19925;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19925__$1,inst_19923);
} else {
if((state_val_19926 === (12))){
var inst_19889 = (state_19925[(7)]);
var inst_19913 = cljs.core.vec.call(null,inst_19889);
var state_19925__$1 = state_19925;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19925__$1,(15),out,inst_19913);
} else {
if((state_val_19926 === (2))){
var state_19925__$1 = state_19925;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19925__$1,(4),ch);
} else {
if((state_val_19926 === (11))){
var inst_19905 = (state_19925[(2)]);
var inst_19906 = (new Array(n));
var inst_19889 = inst_19906;
var inst_19890 = (0);
var state_19925__$1 = (function (){var statearr_19937 = state_19925;
(statearr_19937[(7)] = inst_19889);

(statearr_19937[(10)] = inst_19905);

(statearr_19937[(8)] = inst_19890);

return statearr_19937;
})();
var statearr_19938_19968 = state_19925__$1;
(statearr_19938_19968[(2)] = null);

(statearr_19938_19968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (9))){
var inst_19889 = (state_19925[(7)]);
var inst_19903 = cljs.core.vec.call(null,inst_19889);
var state_19925__$1 = state_19925;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19925__$1,(11),out,inst_19903);
} else {
if((state_val_19926 === (5))){
var inst_19898 = (state_19925[(11)]);
var inst_19889 = (state_19925[(7)]);
var inst_19893 = (state_19925[(9)]);
var inst_19890 = (state_19925[(8)]);
var inst_19897 = (inst_19889[inst_19890] = inst_19893);
var inst_19898__$1 = (inst_19890 + (1));
var inst_19899 = (inst_19898__$1 < n);
var state_19925__$1 = (function (){var statearr_19939 = state_19925;
(statearr_19939[(12)] = inst_19897);

(statearr_19939[(11)] = inst_19898__$1);

return statearr_19939;
})();
if(cljs.core.truth_(inst_19899)){
var statearr_19940_19969 = state_19925__$1;
(statearr_19940_19969[(1)] = (8));

} else {
var statearr_19941_19970 = state_19925__$1;
(statearr_19941_19970[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (14))){
var inst_19918 = (state_19925[(2)]);
var inst_19919 = cljs.core.async.close_BANG_.call(null,out);
var state_19925__$1 = (function (){var statearr_19943 = state_19925;
(statearr_19943[(13)] = inst_19918);

return statearr_19943;
})();
var statearr_19944_19971 = state_19925__$1;
(statearr_19944_19971[(2)] = inst_19919);

(statearr_19944_19971[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (10))){
var inst_19909 = (state_19925[(2)]);
var state_19925__$1 = state_19925;
var statearr_19945_19972 = state_19925__$1;
(statearr_19945_19972[(2)] = inst_19909);

(statearr_19945_19972[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19926 === (8))){
var inst_19898 = (state_19925[(11)]);
var inst_19889 = (state_19925[(7)]);
var tmp19942 = inst_19889;
var inst_19889__$1 = tmp19942;
var inst_19890 = inst_19898;
var state_19925__$1 = (function (){var statearr_19946 = state_19925;
(statearr_19946[(7)] = inst_19889__$1);

(statearr_19946[(8)] = inst_19890);

return statearr_19946;
})();
var statearr_19947_19973 = state_19925__$1;
(statearr_19947_19973[(2)] = null);

(statearr_19947_19973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19959,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19959,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19951 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19951[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19951[(1)] = (1));

return statearr_19951;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19925){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19925);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19952){if((e19952 instanceof Object)){
var ex__8254__auto__ = e19952;
var statearr_19953_19974 = state_19925;
(statearr_19953_19974[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19925);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19952;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19975 = state_19925;
state_19925 = G__19975;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19925){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19959,out))
})();
var state__8364__auto__ = (function (){var statearr_19954 = f__8363__auto__.call(null);
(statearr_19954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19959);

return statearr_19954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19959,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19976 = [];
var len__5726__auto___20050 = arguments.length;
var i__5727__auto___20051 = (0);
while(true){
if((i__5727__auto___20051 < len__5726__auto___20050)){
args19976.push((arguments[i__5727__auto___20051]));

var G__20052 = (i__5727__auto___20051 + (1));
i__5727__auto___20051 = G__20052;
continue;
} else {
}
break;
}

var G__19978 = args19976.length;
switch (G__19978) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19976.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20054 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20054,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20054,out){
return (function (state_20020){
var state_val_20021 = (state_20020[(1)]);
if((state_val_20021 === (7))){
var inst_20016 = (state_20020[(2)]);
var state_20020__$1 = state_20020;
var statearr_20022_20055 = state_20020__$1;
(statearr_20022_20055[(2)] = inst_20016);

(statearr_20022_20055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (1))){
var inst_19979 = [];
var inst_19980 = inst_19979;
var inst_19981 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20020__$1 = (function (){var statearr_20023 = state_20020;
(statearr_20023[(7)] = inst_19980);

(statearr_20023[(8)] = inst_19981);

return statearr_20023;
})();
var statearr_20024_20056 = state_20020__$1;
(statearr_20024_20056[(2)] = null);

(statearr_20024_20056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (4))){
var inst_19984 = (state_20020[(9)]);
var inst_19984__$1 = (state_20020[(2)]);
var inst_19985 = (inst_19984__$1 == null);
var inst_19986 = cljs.core.not.call(null,inst_19985);
var state_20020__$1 = (function (){var statearr_20025 = state_20020;
(statearr_20025[(9)] = inst_19984__$1);

return statearr_20025;
})();
if(inst_19986){
var statearr_20026_20057 = state_20020__$1;
(statearr_20026_20057[(1)] = (5));

} else {
var statearr_20027_20058 = state_20020__$1;
(statearr_20027_20058[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (15))){
var inst_20010 = (state_20020[(2)]);
var state_20020__$1 = state_20020;
var statearr_20028_20059 = state_20020__$1;
(statearr_20028_20059[(2)] = inst_20010);

(statearr_20028_20059[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (13))){
var state_20020__$1 = state_20020;
var statearr_20029_20060 = state_20020__$1;
(statearr_20029_20060[(2)] = null);

(statearr_20029_20060[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (6))){
var inst_19980 = (state_20020[(7)]);
var inst_20005 = inst_19980.length;
var inst_20006 = (inst_20005 > (0));
var state_20020__$1 = state_20020;
if(cljs.core.truth_(inst_20006)){
var statearr_20030_20061 = state_20020__$1;
(statearr_20030_20061[(1)] = (12));

} else {
var statearr_20031_20062 = state_20020__$1;
(statearr_20031_20062[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (3))){
var inst_20018 = (state_20020[(2)]);
var state_20020__$1 = state_20020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20020__$1,inst_20018);
} else {
if((state_val_20021 === (12))){
var inst_19980 = (state_20020[(7)]);
var inst_20008 = cljs.core.vec.call(null,inst_19980);
var state_20020__$1 = state_20020;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20020__$1,(15),out,inst_20008);
} else {
if((state_val_20021 === (2))){
var state_20020__$1 = state_20020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20020__$1,(4),ch);
} else {
if((state_val_20021 === (11))){
var inst_19984 = (state_20020[(9)]);
var inst_19988 = (state_20020[(10)]);
var inst_19998 = (state_20020[(2)]);
var inst_19999 = [];
var inst_20000 = inst_19999.push(inst_19984);
var inst_19980 = inst_19999;
var inst_19981 = inst_19988;
var state_20020__$1 = (function (){var statearr_20032 = state_20020;
(statearr_20032[(11)] = inst_19998);

(statearr_20032[(12)] = inst_20000);

(statearr_20032[(7)] = inst_19980);

(statearr_20032[(8)] = inst_19981);

return statearr_20032;
})();
var statearr_20033_20063 = state_20020__$1;
(statearr_20033_20063[(2)] = null);

(statearr_20033_20063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (9))){
var inst_19980 = (state_20020[(7)]);
var inst_19996 = cljs.core.vec.call(null,inst_19980);
var state_20020__$1 = state_20020;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20020__$1,(11),out,inst_19996);
} else {
if((state_val_20021 === (5))){
var inst_19984 = (state_20020[(9)]);
var inst_19988 = (state_20020[(10)]);
var inst_19981 = (state_20020[(8)]);
var inst_19988__$1 = f.call(null,inst_19984);
var inst_19989 = cljs.core._EQ_.call(null,inst_19988__$1,inst_19981);
var inst_19990 = cljs.core.keyword_identical_QMARK_.call(null,inst_19981,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19991 = (inst_19989) || (inst_19990);
var state_20020__$1 = (function (){var statearr_20034 = state_20020;
(statearr_20034[(10)] = inst_19988__$1);

return statearr_20034;
})();
if(cljs.core.truth_(inst_19991)){
var statearr_20035_20064 = state_20020__$1;
(statearr_20035_20064[(1)] = (8));

} else {
var statearr_20036_20065 = state_20020__$1;
(statearr_20036_20065[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (14))){
var inst_20013 = (state_20020[(2)]);
var inst_20014 = cljs.core.async.close_BANG_.call(null,out);
var state_20020__$1 = (function (){var statearr_20038 = state_20020;
(statearr_20038[(13)] = inst_20013);

return statearr_20038;
})();
var statearr_20039_20066 = state_20020__$1;
(statearr_20039_20066[(2)] = inst_20014);

(statearr_20039_20066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (10))){
var inst_20003 = (state_20020[(2)]);
var state_20020__$1 = state_20020;
var statearr_20040_20067 = state_20020__$1;
(statearr_20040_20067[(2)] = inst_20003);

(statearr_20040_20067[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20021 === (8))){
var inst_19984 = (state_20020[(9)]);
var inst_19988 = (state_20020[(10)]);
var inst_19980 = (state_20020[(7)]);
var inst_19993 = inst_19980.push(inst_19984);
var tmp20037 = inst_19980;
var inst_19980__$1 = tmp20037;
var inst_19981 = inst_19988;
var state_20020__$1 = (function (){var statearr_20041 = state_20020;
(statearr_20041[(14)] = inst_19993);

(statearr_20041[(7)] = inst_19980__$1);

(statearr_20041[(8)] = inst_19981);

return statearr_20041;
})();
var statearr_20042_20068 = state_20020__$1;
(statearr_20042_20068[(2)] = null);

(statearr_20042_20068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20054,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20054,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_20046 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20046[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_20046[(1)] = (1));

return statearr_20046;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_20020){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_20020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e20047){if((e20047 instanceof Object)){
var ex__8254__auto__ = e20047;
var statearr_20048_20069 = state_20020;
(statearr_20048_20069[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20020);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20047;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20070 = state_20020;
state_20020 = G__20070;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_20020){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_20020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20054,out))
})();
var state__8364__auto__ = (function (){var statearr_20049 = f__8363__auto__.call(null);
(statearr_20049[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20054);

return statearr_20049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20054,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1458811283477