// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17322 = [];
var len__5726__auto___17328 = arguments.length;
var i__5727__auto___17329 = (0);
while(true){
if((i__5727__auto___17329 < len__5726__auto___17328)){
args17322.push((arguments[i__5727__auto___17329]));

var G__17330 = (i__5727__auto___17329 + (1));
i__5727__auto___17329 = G__17330;
continue;
} else {
}
break;
}

var G__17324 = args17322.length;
switch (G__17324) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17322.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17325 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17325 = (function (f,blockable,meta17326){
this.f = f;
this.blockable = blockable;
this.meta17326 = meta17326;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17327,meta17326__$1){
var self__ = this;
var _17327__$1 = this;
return (new cljs.core.async.t_cljs$core$async17325(self__.f,self__.blockable,meta17326__$1));
});

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17327){
var self__ = this;
var _17327__$1 = this;
return self__.meta17326;
});

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17325.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17326","meta17326",1278761139,null)], null);
});

cljs.core.async.t_cljs$core$async17325.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17325.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17325";

cljs.core.async.t_cljs$core$async17325.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17325");
});

cljs.core.async.__GT_t_cljs$core$async17325 = (function cljs$core$async$__GT_t_cljs$core$async17325(f__$1,blockable__$1,meta17326){
return (new cljs.core.async.t_cljs$core$async17325(f__$1,blockable__$1,meta17326));
});

}

return (new cljs.core.async.t_cljs$core$async17325(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17334 = [];
var len__5726__auto___17337 = arguments.length;
var i__5727__auto___17338 = (0);
while(true){
if((i__5727__auto___17338 < len__5726__auto___17337)){
args17334.push((arguments[i__5727__auto___17338]));

var G__17339 = (i__5727__auto___17338 + (1));
i__5727__auto___17338 = G__17339;
continue;
} else {
}
break;
}

var G__17336 = args17334.length;
switch (G__17336) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17334.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17341 = [];
var len__5726__auto___17344 = arguments.length;
var i__5727__auto___17345 = (0);
while(true){
if((i__5727__auto___17345 < len__5726__auto___17344)){
args17341.push((arguments[i__5727__auto___17345]));

var G__17346 = (i__5727__auto___17345 + (1));
i__5727__auto___17345 = G__17346;
continue;
} else {
}
break;
}

var G__17343 = args17341.length;
switch (G__17343) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17341.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17348 = [];
var len__5726__auto___17351 = arguments.length;
var i__5727__auto___17352 = (0);
while(true){
if((i__5727__auto___17352 < len__5726__auto___17351)){
args17348.push((arguments[i__5727__auto___17352]));

var G__17353 = (i__5727__auto___17352 + (1));
i__5727__auto___17352 = G__17353;
continue;
} else {
}
break;
}

var G__17350 = args17348.length;
switch (G__17350) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17348.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17355 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17355);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17355,ret){
return (function (){
return fn1.call(null,val_17355);
});})(val_17355,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17356 = [];
var len__5726__auto___17359 = arguments.length;
var i__5727__auto___17360 = (0);
while(true){
if((i__5727__auto___17360 < len__5726__auto___17359)){
args17356.push((arguments[i__5727__auto___17360]));

var G__17361 = (i__5727__auto___17360 + (1));
i__5727__auto___17360 = G__17361;
continue;
} else {
}
break;
}

var G__17358 = args17356.length;
switch (G__17358) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17356.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17363 = n;
var x_17364 = (0);
while(true){
if((x_17364 < n__5571__auto___17363)){
(a[x_17364] = (0));

var G__17365 = (x_17364 + (1));
x_17364 = G__17365;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17366 = (i + (1));
i = G__17366;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17370 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17370 = (function (alt_flag,flag,meta17371){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17371 = meta17371;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17370.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17372,meta17371__$1){
var self__ = this;
var _17372__$1 = this;
return (new cljs.core.async.t_cljs$core$async17370(self__.alt_flag,self__.flag,meta17371__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17370.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17372){
var self__ = this;
var _17372__$1 = this;
return self__.meta17371;
});})(flag))
;

cljs.core.async.t_cljs$core$async17370.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17370.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17370.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17370.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17370.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17371","meta17371",-1938820986,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17370.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17370.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17370";

cljs.core.async.t_cljs$core$async17370.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17370");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17370 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17370(alt_flag__$1,flag__$1,meta17371){
return (new cljs.core.async.t_cljs$core$async17370(alt_flag__$1,flag__$1,meta17371));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17370(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17376 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17376 = (function (alt_handler,flag,cb,meta17377){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17377 = meta17377;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17376.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17378,meta17377__$1){
var self__ = this;
var _17378__$1 = this;
return (new cljs.core.async.t_cljs$core$async17376(self__.alt_handler,self__.flag,self__.cb,meta17377__$1));
});

cljs.core.async.t_cljs$core$async17376.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17378){
var self__ = this;
var _17378__$1 = this;
return self__.meta17377;
});

cljs.core.async.t_cljs$core$async17376.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17376.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17376.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17376.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17376.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17377","meta17377",-2011930949,null)], null);
});

cljs.core.async.t_cljs$core$async17376.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17376.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17376";

cljs.core.async.t_cljs$core$async17376.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17376");
});

cljs.core.async.__GT_t_cljs$core$async17376 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17376(alt_handler__$1,flag__$1,cb__$1,meta17377){
return (new cljs.core.async.t_cljs$core$async17376(alt_handler__$1,flag__$1,cb__$1,meta17377));
});

}

return (new cljs.core.async.t_cljs$core$async17376(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17379_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17379_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17380_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17380_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17381 = (i + (1));
i = G__17381;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17387 = arguments.length;
var i__5727__auto___17388 = (0);
while(true){
if((i__5727__auto___17388 < len__5726__auto___17387)){
args__5733__auto__.push((arguments[i__5727__auto___17388]));

var G__17389 = (i__5727__auto___17388 + (1));
i__5727__auto___17388 = G__17389;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17384){
var map__17385 = p__17384;
var map__17385__$1 = ((((!((map__17385 == null)))?((((map__17385.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17385.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17385):map__17385);
var opts = map__17385__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17382){
var G__17383 = cljs.core.first.call(null,seq17382);
var seq17382__$1 = cljs.core.next.call(null,seq17382);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17383,seq17382__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17390 = [];
var len__5726__auto___17440 = arguments.length;
var i__5727__auto___17441 = (0);
while(true){
if((i__5727__auto___17441 < len__5726__auto___17440)){
args17390.push((arguments[i__5727__auto___17441]));

var G__17442 = (i__5727__auto___17441 + (1));
i__5727__auto___17441 = G__17442;
continue;
} else {
}
break;
}

var G__17392 = args17390.length;
switch (G__17392) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17390.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17444 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17444){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17444){
return (function (state_17416){
var state_val_17417 = (state_17416[(1)]);
if((state_val_17417 === (7))){
var inst_17412 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
var statearr_17418_17445 = state_17416__$1;
(statearr_17418_17445[(2)] = inst_17412);

(statearr_17418_17445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (1))){
var state_17416__$1 = state_17416;
var statearr_17419_17446 = state_17416__$1;
(statearr_17419_17446[(2)] = null);

(statearr_17419_17446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (4))){
var inst_17395 = (state_17416[(7)]);
var inst_17395__$1 = (state_17416[(2)]);
var inst_17396 = (inst_17395__$1 == null);
var state_17416__$1 = (function (){var statearr_17420 = state_17416;
(statearr_17420[(7)] = inst_17395__$1);

return statearr_17420;
})();
if(cljs.core.truth_(inst_17396)){
var statearr_17421_17447 = state_17416__$1;
(statearr_17421_17447[(1)] = (5));

} else {
var statearr_17422_17448 = state_17416__$1;
(statearr_17422_17448[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (13))){
var state_17416__$1 = state_17416;
var statearr_17423_17449 = state_17416__$1;
(statearr_17423_17449[(2)] = null);

(statearr_17423_17449[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (6))){
var inst_17395 = (state_17416[(7)]);
var state_17416__$1 = state_17416;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17416__$1,(11),to,inst_17395);
} else {
if((state_val_17417 === (3))){
var inst_17414 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17416__$1,inst_17414);
} else {
if((state_val_17417 === (12))){
var state_17416__$1 = state_17416;
var statearr_17424_17450 = state_17416__$1;
(statearr_17424_17450[(2)] = null);

(statearr_17424_17450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (2))){
var state_17416__$1 = state_17416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17416__$1,(4),from);
} else {
if((state_val_17417 === (11))){
var inst_17405 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
if(cljs.core.truth_(inst_17405)){
var statearr_17425_17451 = state_17416__$1;
(statearr_17425_17451[(1)] = (12));

} else {
var statearr_17426_17452 = state_17416__$1;
(statearr_17426_17452[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (9))){
var state_17416__$1 = state_17416;
var statearr_17427_17453 = state_17416__$1;
(statearr_17427_17453[(2)] = null);

(statearr_17427_17453[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (5))){
var state_17416__$1 = state_17416;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17428_17454 = state_17416__$1;
(statearr_17428_17454[(1)] = (8));

} else {
var statearr_17429_17455 = state_17416__$1;
(statearr_17429_17455[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (14))){
var inst_17410 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
var statearr_17430_17456 = state_17416__$1;
(statearr_17430_17456[(2)] = inst_17410);

(statearr_17430_17456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (10))){
var inst_17402 = (state_17416[(2)]);
var state_17416__$1 = state_17416;
var statearr_17431_17457 = state_17416__$1;
(statearr_17431_17457[(2)] = inst_17402);

(statearr_17431_17457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17417 === (8))){
var inst_17399 = cljs.core.async.close_BANG_.call(null,to);
var state_17416__$1 = state_17416;
var statearr_17432_17458 = state_17416__$1;
(statearr_17432_17458[(2)] = inst_17399);

(statearr_17432_17458[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17444))
;
return ((function (switch__8250__auto__,c__8362__auto___17444){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17436 = [null,null,null,null,null,null,null,null];
(statearr_17436[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17436[(1)] = (1));

return statearr_17436;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17416){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17437){if((e17437 instanceof Object)){
var ex__8254__auto__ = e17437;
var statearr_17438_17459 = state_17416;
(statearr_17438_17459[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17416);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17437;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17460 = state_17416;
state_17416 = G__17460;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17416){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17444))
})();
var state__8364__auto__ = (function (){var statearr_17439 = f__8363__auto__.call(null);
(statearr_17439[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17444);

return statearr_17439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17444))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17644){
var vec__17645 = p__17644;
var v = cljs.core.nth.call(null,vec__17645,(0),null);
var p = cljs.core.nth.call(null,vec__17645,(1),null);
var job = vec__17645;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17827 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17827,res,vec__17645,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17827,res,vec__17645,v,p,job,jobs,results){
return (function (state_17650){
var state_val_17651 = (state_17650[(1)]);
if((state_val_17651 === (1))){
var state_17650__$1 = state_17650;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17650__$1,(2),res,v);
} else {
if((state_val_17651 === (2))){
var inst_17647 = (state_17650[(2)]);
var inst_17648 = cljs.core.async.close_BANG_.call(null,res);
var state_17650__$1 = (function (){var statearr_17652 = state_17650;
(statearr_17652[(7)] = inst_17647);

return statearr_17652;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17650__$1,inst_17648);
} else {
return null;
}
}
});})(c__8362__auto___17827,res,vec__17645,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17827,res,vec__17645,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17656 = [null,null,null,null,null,null,null,null];
(statearr_17656[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17656[(1)] = (1));

return statearr_17656;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17650){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17650);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17657){if((e17657 instanceof Object)){
var ex__8254__auto__ = e17657;
var statearr_17658_17828 = state_17650;
(statearr_17658_17828[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17650);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17657;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17829 = state_17650;
state_17650 = G__17829;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17650){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17827,res,vec__17645,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17659 = f__8363__auto__.call(null);
(statearr_17659[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17827);

return statearr_17659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17827,res,vec__17645,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17660){
var vec__17661 = p__17660;
var v = cljs.core.nth.call(null,vec__17661,(0),null);
var p = cljs.core.nth.call(null,vec__17661,(1),null);
var job = vec__17661;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17830 = n;
var __17831 = (0);
while(true){
if((__17831 < n__5571__auto___17830)){
var G__17662_17832 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17662_17832) {
case "compute":
var c__8362__auto___17834 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17831,c__8362__auto___17834,G__17662_17832,n__5571__auto___17830,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17831,c__8362__auto___17834,G__17662_17832,n__5571__auto___17830,jobs,results,process,async){
return (function (state_17675){
var state_val_17676 = (state_17675[(1)]);
if((state_val_17676 === (1))){
var state_17675__$1 = state_17675;
var statearr_17677_17835 = state_17675__$1;
(statearr_17677_17835[(2)] = null);

(statearr_17677_17835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (2))){
var state_17675__$1 = state_17675;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17675__$1,(4),jobs);
} else {
if((state_val_17676 === (3))){
var inst_17673 = (state_17675[(2)]);
var state_17675__$1 = state_17675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17675__$1,inst_17673);
} else {
if((state_val_17676 === (4))){
var inst_17665 = (state_17675[(2)]);
var inst_17666 = process.call(null,inst_17665);
var state_17675__$1 = state_17675;
if(cljs.core.truth_(inst_17666)){
var statearr_17678_17836 = state_17675__$1;
(statearr_17678_17836[(1)] = (5));

} else {
var statearr_17679_17837 = state_17675__$1;
(statearr_17679_17837[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (5))){
var state_17675__$1 = state_17675;
var statearr_17680_17838 = state_17675__$1;
(statearr_17680_17838[(2)] = null);

(statearr_17680_17838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (6))){
var state_17675__$1 = state_17675;
var statearr_17681_17839 = state_17675__$1;
(statearr_17681_17839[(2)] = null);

(statearr_17681_17839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17676 === (7))){
var inst_17671 = (state_17675[(2)]);
var state_17675__$1 = state_17675;
var statearr_17682_17840 = state_17675__$1;
(statearr_17682_17840[(2)] = inst_17671);

(statearr_17682_17840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17831,c__8362__auto___17834,G__17662_17832,n__5571__auto___17830,jobs,results,process,async))
;
return ((function (__17831,switch__8250__auto__,c__8362__auto___17834,G__17662_17832,n__5571__auto___17830,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17686 = [null,null,null,null,null,null,null];
(statearr_17686[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17686[(1)] = (1));

return statearr_17686;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17675){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17687){if((e17687 instanceof Object)){
var ex__8254__auto__ = e17687;
var statearr_17688_17841 = state_17675;
(statearr_17688_17841[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17675);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17687;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17842 = state_17675;
state_17675 = G__17842;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17675){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17831,switch__8250__auto__,c__8362__auto___17834,G__17662_17832,n__5571__auto___17830,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17689 = f__8363__auto__.call(null);
(statearr_17689[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17834);

return statearr_17689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17831,c__8362__auto___17834,G__17662_17832,n__5571__auto___17830,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17843 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17831,c__8362__auto___17843,G__17662_17832,n__5571__auto___17830,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17831,c__8362__auto___17843,G__17662_17832,n__5571__auto___17830,jobs,results,process,async){
return (function (state_17702){
var state_val_17703 = (state_17702[(1)]);
if((state_val_17703 === (1))){
var state_17702__$1 = state_17702;
var statearr_17704_17844 = state_17702__$1;
(statearr_17704_17844[(2)] = null);

(statearr_17704_17844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17703 === (2))){
var state_17702__$1 = state_17702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17702__$1,(4),jobs);
} else {
if((state_val_17703 === (3))){
var inst_17700 = (state_17702[(2)]);
var state_17702__$1 = state_17702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17702__$1,inst_17700);
} else {
if((state_val_17703 === (4))){
var inst_17692 = (state_17702[(2)]);
var inst_17693 = async.call(null,inst_17692);
var state_17702__$1 = state_17702;
if(cljs.core.truth_(inst_17693)){
var statearr_17705_17845 = state_17702__$1;
(statearr_17705_17845[(1)] = (5));

} else {
var statearr_17706_17846 = state_17702__$1;
(statearr_17706_17846[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17703 === (5))){
var state_17702__$1 = state_17702;
var statearr_17707_17847 = state_17702__$1;
(statearr_17707_17847[(2)] = null);

(statearr_17707_17847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17703 === (6))){
var state_17702__$1 = state_17702;
var statearr_17708_17848 = state_17702__$1;
(statearr_17708_17848[(2)] = null);

(statearr_17708_17848[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17703 === (7))){
var inst_17698 = (state_17702[(2)]);
var state_17702__$1 = state_17702;
var statearr_17709_17849 = state_17702__$1;
(statearr_17709_17849[(2)] = inst_17698);

(statearr_17709_17849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17831,c__8362__auto___17843,G__17662_17832,n__5571__auto___17830,jobs,results,process,async))
;
return ((function (__17831,switch__8250__auto__,c__8362__auto___17843,G__17662_17832,n__5571__auto___17830,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17713 = [null,null,null,null,null,null,null];
(statearr_17713[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17713[(1)] = (1));

return statearr_17713;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17702){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17714){if((e17714 instanceof Object)){
var ex__8254__auto__ = e17714;
var statearr_17715_17850 = state_17702;
(statearr_17715_17850[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17702);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17714;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17851 = state_17702;
state_17702 = G__17851;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17702){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17831,switch__8250__auto__,c__8362__auto___17843,G__17662_17832,n__5571__auto___17830,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17716 = f__8363__auto__.call(null);
(statearr_17716[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17843);

return statearr_17716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17831,c__8362__auto___17843,G__17662_17832,n__5571__auto___17830,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17852 = (__17831 + (1));
__17831 = G__17852;
continue;
} else {
}
break;
}

var c__8362__auto___17853 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17853,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17853,jobs,results,process,async){
return (function (state_17738){
var state_val_17739 = (state_17738[(1)]);
if((state_val_17739 === (1))){
var state_17738__$1 = state_17738;
var statearr_17740_17854 = state_17738__$1;
(statearr_17740_17854[(2)] = null);

(statearr_17740_17854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17739 === (2))){
var state_17738__$1 = state_17738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17738__$1,(4),from);
} else {
if((state_val_17739 === (3))){
var inst_17736 = (state_17738[(2)]);
var state_17738__$1 = state_17738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17738__$1,inst_17736);
} else {
if((state_val_17739 === (4))){
var inst_17719 = (state_17738[(7)]);
var inst_17719__$1 = (state_17738[(2)]);
var inst_17720 = (inst_17719__$1 == null);
var state_17738__$1 = (function (){var statearr_17741 = state_17738;
(statearr_17741[(7)] = inst_17719__$1);

return statearr_17741;
})();
if(cljs.core.truth_(inst_17720)){
var statearr_17742_17855 = state_17738__$1;
(statearr_17742_17855[(1)] = (5));

} else {
var statearr_17743_17856 = state_17738__$1;
(statearr_17743_17856[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17739 === (5))){
var inst_17722 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17738__$1 = state_17738;
var statearr_17744_17857 = state_17738__$1;
(statearr_17744_17857[(2)] = inst_17722);

(statearr_17744_17857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17739 === (6))){
var inst_17724 = (state_17738[(8)]);
var inst_17719 = (state_17738[(7)]);
var inst_17724__$1 = cljs.core.async.chan.call(null,(1));
var inst_17725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17726 = [inst_17719,inst_17724__$1];
var inst_17727 = (new cljs.core.PersistentVector(null,2,(5),inst_17725,inst_17726,null));
var state_17738__$1 = (function (){var statearr_17745 = state_17738;
(statearr_17745[(8)] = inst_17724__$1);

return statearr_17745;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17738__$1,(8),jobs,inst_17727);
} else {
if((state_val_17739 === (7))){
var inst_17734 = (state_17738[(2)]);
var state_17738__$1 = state_17738;
var statearr_17746_17858 = state_17738__$1;
(statearr_17746_17858[(2)] = inst_17734);

(statearr_17746_17858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17739 === (8))){
var inst_17724 = (state_17738[(8)]);
var inst_17729 = (state_17738[(2)]);
var state_17738__$1 = (function (){var statearr_17747 = state_17738;
(statearr_17747[(9)] = inst_17729);

return statearr_17747;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17738__$1,(9),results,inst_17724);
} else {
if((state_val_17739 === (9))){
var inst_17731 = (state_17738[(2)]);
var state_17738__$1 = (function (){var statearr_17748 = state_17738;
(statearr_17748[(10)] = inst_17731);

return statearr_17748;
})();
var statearr_17749_17859 = state_17738__$1;
(statearr_17749_17859[(2)] = null);

(statearr_17749_17859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17853,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17853,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17753 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17753[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17753[(1)] = (1));

return statearr_17753;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17738){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17754){if((e17754 instanceof Object)){
var ex__8254__auto__ = e17754;
var statearr_17755_17860 = state_17738;
(statearr_17755_17860[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17738);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17754;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17861 = state_17738;
state_17738 = G__17861;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17738){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17853,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17756 = f__8363__auto__.call(null);
(statearr_17756[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17853);

return statearr_17756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17853,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17794){
var state_val_17795 = (state_17794[(1)]);
if((state_val_17795 === (7))){
var inst_17790 = (state_17794[(2)]);
var state_17794__$1 = state_17794;
var statearr_17796_17862 = state_17794__$1;
(statearr_17796_17862[(2)] = inst_17790);

(statearr_17796_17862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (20))){
var state_17794__$1 = state_17794;
var statearr_17797_17863 = state_17794__$1;
(statearr_17797_17863[(2)] = null);

(statearr_17797_17863[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (1))){
var state_17794__$1 = state_17794;
var statearr_17798_17864 = state_17794__$1;
(statearr_17798_17864[(2)] = null);

(statearr_17798_17864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (4))){
var inst_17759 = (state_17794[(7)]);
var inst_17759__$1 = (state_17794[(2)]);
var inst_17760 = (inst_17759__$1 == null);
var state_17794__$1 = (function (){var statearr_17799 = state_17794;
(statearr_17799[(7)] = inst_17759__$1);

return statearr_17799;
})();
if(cljs.core.truth_(inst_17760)){
var statearr_17800_17865 = state_17794__$1;
(statearr_17800_17865[(1)] = (5));

} else {
var statearr_17801_17866 = state_17794__$1;
(statearr_17801_17866[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (15))){
var inst_17772 = (state_17794[(8)]);
var state_17794__$1 = state_17794;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17794__$1,(18),to,inst_17772);
} else {
if((state_val_17795 === (21))){
var inst_17785 = (state_17794[(2)]);
var state_17794__$1 = state_17794;
var statearr_17802_17867 = state_17794__$1;
(statearr_17802_17867[(2)] = inst_17785);

(statearr_17802_17867[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (13))){
var inst_17787 = (state_17794[(2)]);
var state_17794__$1 = (function (){var statearr_17803 = state_17794;
(statearr_17803[(9)] = inst_17787);

return statearr_17803;
})();
var statearr_17804_17868 = state_17794__$1;
(statearr_17804_17868[(2)] = null);

(statearr_17804_17868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (6))){
var inst_17759 = (state_17794[(7)]);
var state_17794__$1 = state_17794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17794__$1,(11),inst_17759);
} else {
if((state_val_17795 === (17))){
var inst_17780 = (state_17794[(2)]);
var state_17794__$1 = state_17794;
if(cljs.core.truth_(inst_17780)){
var statearr_17805_17869 = state_17794__$1;
(statearr_17805_17869[(1)] = (19));

} else {
var statearr_17806_17870 = state_17794__$1;
(statearr_17806_17870[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (3))){
var inst_17792 = (state_17794[(2)]);
var state_17794__$1 = state_17794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17794__$1,inst_17792);
} else {
if((state_val_17795 === (12))){
var inst_17769 = (state_17794[(10)]);
var state_17794__$1 = state_17794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17794__$1,(14),inst_17769);
} else {
if((state_val_17795 === (2))){
var state_17794__$1 = state_17794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17794__$1,(4),results);
} else {
if((state_val_17795 === (19))){
var state_17794__$1 = state_17794;
var statearr_17807_17871 = state_17794__$1;
(statearr_17807_17871[(2)] = null);

(statearr_17807_17871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (11))){
var inst_17769 = (state_17794[(2)]);
var state_17794__$1 = (function (){var statearr_17808 = state_17794;
(statearr_17808[(10)] = inst_17769);

return statearr_17808;
})();
var statearr_17809_17872 = state_17794__$1;
(statearr_17809_17872[(2)] = null);

(statearr_17809_17872[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (9))){
var state_17794__$1 = state_17794;
var statearr_17810_17873 = state_17794__$1;
(statearr_17810_17873[(2)] = null);

(statearr_17810_17873[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (5))){
var state_17794__$1 = state_17794;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17811_17874 = state_17794__$1;
(statearr_17811_17874[(1)] = (8));

} else {
var statearr_17812_17875 = state_17794__$1;
(statearr_17812_17875[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (14))){
var inst_17772 = (state_17794[(8)]);
var inst_17774 = (state_17794[(11)]);
var inst_17772__$1 = (state_17794[(2)]);
var inst_17773 = (inst_17772__$1 == null);
var inst_17774__$1 = cljs.core.not.call(null,inst_17773);
var state_17794__$1 = (function (){var statearr_17813 = state_17794;
(statearr_17813[(8)] = inst_17772__$1);

(statearr_17813[(11)] = inst_17774__$1);

return statearr_17813;
})();
if(inst_17774__$1){
var statearr_17814_17876 = state_17794__$1;
(statearr_17814_17876[(1)] = (15));

} else {
var statearr_17815_17877 = state_17794__$1;
(statearr_17815_17877[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (16))){
var inst_17774 = (state_17794[(11)]);
var state_17794__$1 = state_17794;
var statearr_17816_17878 = state_17794__$1;
(statearr_17816_17878[(2)] = inst_17774);

(statearr_17816_17878[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (10))){
var inst_17766 = (state_17794[(2)]);
var state_17794__$1 = state_17794;
var statearr_17817_17879 = state_17794__$1;
(statearr_17817_17879[(2)] = inst_17766);

(statearr_17817_17879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (18))){
var inst_17777 = (state_17794[(2)]);
var state_17794__$1 = state_17794;
var statearr_17818_17880 = state_17794__$1;
(statearr_17818_17880[(2)] = inst_17777);

(statearr_17818_17880[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17795 === (8))){
var inst_17763 = cljs.core.async.close_BANG_.call(null,to);
var state_17794__$1 = state_17794;
var statearr_17819_17881 = state_17794__$1;
(statearr_17819_17881[(2)] = inst_17763);

(statearr_17819_17881[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17823 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17823[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17823[(1)] = (1));

return statearr_17823;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17794){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17824){if((e17824 instanceof Object)){
var ex__8254__auto__ = e17824;
var statearr_17825_17882 = state_17794;
(statearr_17825_17882[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17794);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17824;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17883 = state_17794;
state_17794 = G__17883;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17794){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17826 = f__8363__auto__.call(null);
(statearr_17826[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17884 = [];
var len__5726__auto___17887 = arguments.length;
var i__5727__auto___17888 = (0);
while(true){
if((i__5727__auto___17888 < len__5726__auto___17887)){
args17884.push((arguments[i__5727__auto___17888]));

var G__17889 = (i__5727__auto___17888 + (1));
i__5727__auto___17888 = G__17889;
continue;
} else {
}
break;
}

var G__17886 = args17884.length;
switch (G__17886) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17884.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17891 = [];
var len__5726__auto___17894 = arguments.length;
var i__5727__auto___17895 = (0);
while(true){
if((i__5727__auto___17895 < len__5726__auto___17894)){
args17891.push((arguments[i__5727__auto___17895]));

var G__17896 = (i__5727__auto___17895 + (1));
i__5727__auto___17895 = G__17896;
continue;
} else {
}
break;
}

var G__17893 = args17891.length;
switch (G__17893) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17891.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17898 = [];
var len__5726__auto___17951 = arguments.length;
var i__5727__auto___17952 = (0);
while(true){
if((i__5727__auto___17952 < len__5726__auto___17951)){
args17898.push((arguments[i__5727__auto___17952]));

var G__17953 = (i__5727__auto___17952 + (1));
i__5727__auto___17952 = G__17953;
continue;
} else {
}
break;
}

var G__17900 = args17898.length;
switch (G__17900) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17898.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17955 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17955,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17955,tc,fc){
return (function (state_17926){
var state_val_17927 = (state_17926[(1)]);
if((state_val_17927 === (7))){
var inst_17922 = (state_17926[(2)]);
var state_17926__$1 = state_17926;
var statearr_17928_17956 = state_17926__$1;
(statearr_17928_17956[(2)] = inst_17922);

(statearr_17928_17956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (1))){
var state_17926__$1 = state_17926;
var statearr_17929_17957 = state_17926__$1;
(statearr_17929_17957[(2)] = null);

(statearr_17929_17957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (4))){
var inst_17903 = (state_17926[(7)]);
var inst_17903__$1 = (state_17926[(2)]);
var inst_17904 = (inst_17903__$1 == null);
var state_17926__$1 = (function (){var statearr_17930 = state_17926;
(statearr_17930[(7)] = inst_17903__$1);

return statearr_17930;
})();
if(cljs.core.truth_(inst_17904)){
var statearr_17931_17958 = state_17926__$1;
(statearr_17931_17958[(1)] = (5));

} else {
var statearr_17932_17959 = state_17926__$1;
(statearr_17932_17959[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (13))){
var state_17926__$1 = state_17926;
var statearr_17933_17960 = state_17926__$1;
(statearr_17933_17960[(2)] = null);

(statearr_17933_17960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (6))){
var inst_17903 = (state_17926[(7)]);
var inst_17909 = p.call(null,inst_17903);
var state_17926__$1 = state_17926;
if(cljs.core.truth_(inst_17909)){
var statearr_17934_17961 = state_17926__$1;
(statearr_17934_17961[(1)] = (9));

} else {
var statearr_17935_17962 = state_17926__$1;
(statearr_17935_17962[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (3))){
var inst_17924 = (state_17926[(2)]);
var state_17926__$1 = state_17926;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17926__$1,inst_17924);
} else {
if((state_val_17927 === (12))){
var state_17926__$1 = state_17926;
var statearr_17936_17963 = state_17926__$1;
(statearr_17936_17963[(2)] = null);

(statearr_17936_17963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (2))){
var state_17926__$1 = state_17926;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17926__$1,(4),ch);
} else {
if((state_val_17927 === (11))){
var inst_17903 = (state_17926[(7)]);
var inst_17913 = (state_17926[(2)]);
var state_17926__$1 = state_17926;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17926__$1,(8),inst_17913,inst_17903);
} else {
if((state_val_17927 === (9))){
var state_17926__$1 = state_17926;
var statearr_17937_17964 = state_17926__$1;
(statearr_17937_17964[(2)] = tc);

(statearr_17937_17964[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (5))){
var inst_17906 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17907 = cljs.core.async.close_BANG_.call(null,fc);
var state_17926__$1 = (function (){var statearr_17938 = state_17926;
(statearr_17938[(8)] = inst_17906);

return statearr_17938;
})();
var statearr_17939_17965 = state_17926__$1;
(statearr_17939_17965[(2)] = inst_17907);

(statearr_17939_17965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (14))){
var inst_17920 = (state_17926[(2)]);
var state_17926__$1 = state_17926;
var statearr_17940_17966 = state_17926__$1;
(statearr_17940_17966[(2)] = inst_17920);

(statearr_17940_17966[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (10))){
var state_17926__$1 = state_17926;
var statearr_17941_17967 = state_17926__$1;
(statearr_17941_17967[(2)] = fc);

(statearr_17941_17967[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17927 === (8))){
var inst_17915 = (state_17926[(2)]);
var state_17926__$1 = state_17926;
if(cljs.core.truth_(inst_17915)){
var statearr_17942_17968 = state_17926__$1;
(statearr_17942_17968[(1)] = (12));

} else {
var statearr_17943_17969 = state_17926__$1;
(statearr_17943_17969[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17955,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17955,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17947 = [null,null,null,null,null,null,null,null,null];
(statearr_17947[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17947[(1)] = (1));

return statearr_17947;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17926){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17948){if((e17948 instanceof Object)){
var ex__8254__auto__ = e17948;
var statearr_17949_17970 = state_17926;
(statearr_17949_17970[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17926);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17948;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17971 = state_17926;
state_17926 = G__17971;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17926){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17955,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17950 = f__8363__auto__.call(null);
(statearr_17950[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17955);

return statearr_17950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17955,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18035){
var state_val_18036 = (state_18035[(1)]);
if((state_val_18036 === (7))){
var inst_18031 = (state_18035[(2)]);
var state_18035__$1 = state_18035;
var statearr_18037_18058 = state_18035__$1;
(statearr_18037_18058[(2)] = inst_18031);

(statearr_18037_18058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18036 === (1))){
var inst_18015 = init;
var state_18035__$1 = (function (){var statearr_18038 = state_18035;
(statearr_18038[(7)] = inst_18015);

return statearr_18038;
})();
var statearr_18039_18059 = state_18035__$1;
(statearr_18039_18059[(2)] = null);

(statearr_18039_18059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18036 === (4))){
var inst_18018 = (state_18035[(8)]);
var inst_18018__$1 = (state_18035[(2)]);
var inst_18019 = (inst_18018__$1 == null);
var state_18035__$1 = (function (){var statearr_18040 = state_18035;
(statearr_18040[(8)] = inst_18018__$1);

return statearr_18040;
})();
if(cljs.core.truth_(inst_18019)){
var statearr_18041_18060 = state_18035__$1;
(statearr_18041_18060[(1)] = (5));

} else {
var statearr_18042_18061 = state_18035__$1;
(statearr_18042_18061[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18036 === (6))){
var inst_18022 = (state_18035[(9)]);
var inst_18015 = (state_18035[(7)]);
var inst_18018 = (state_18035[(8)]);
var inst_18022__$1 = f.call(null,inst_18015,inst_18018);
var inst_18023 = cljs.core.reduced_QMARK_.call(null,inst_18022__$1);
var state_18035__$1 = (function (){var statearr_18043 = state_18035;
(statearr_18043[(9)] = inst_18022__$1);

return statearr_18043;
})();
if(inst_18023){
var statearr_18044_18062 = state_18035__$1;
(statearr_18044_18062[(1)] = (8));

} else {
var statearr_18045_18063 = state_18035__$1;
(statearr_18045_18063[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18036 === (3))){
var inst_18033 = (state_18035[(2)]);
var state_18035__$1 = state_18035;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18035__$1,inst_18033);
} else {
if((state_val_18036 === (2))){
var state_18035__$1 = state_18035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18035__$1,(4),ch);
} else {
if((state_val_18036 === (9))){
var inst_18022 = (state_18035[(9)]);
var inst_18015 = inst_18022;
var state_18035__$1 = (function (){var statearr_18046 = state_18035;
(statearr_18046[(7)] = inst_18015);

return statearr_18046;
})();
var statearr_18047_18064 = state_18035__$1;
(statearr_18047_18064[(2)] = null);

(statearr_18047_18064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18036 === (5))){
var inst_18015 = (state_18035[(7)]);
var state_18035__$1 = state_18035;
var statearr_18048_18065 = state_18035__$1;
(statearr_18048_18065[(2)] = inst_18015);

(statearr_18048_18065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18036 === (10))){
var inst_18029 = (state_18035[(2)]);
var state_18035__$1 = state_18035;
var statearr_18049_18066 = state_18035__$1;
(statearr_18049_18066[(2)] = inst_18029);

(statearr_18049_18066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18036 === (8))){
var inst_18022 = (state_18035[(9)]);
var inst_18025 = cljs.core.deref.call(null,inst_18022);
var state_18035__$1 = state_18035;
var statearr_18050_18067 = state_18035__$1;
(statearr_18050_18067[(2)] = inst_18025);

(statearr_18050_18067[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18054 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18054[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18054[(1)] = (1));

return statearr_18054;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18035){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18055){if((e18055 instanceof Object)){
var ex__8254__auto__ = e18055;
var statearr_18056_18068 = state_18035;
(statearr_18056_18068[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18035);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18055;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18069 = state_18035;
state_18035 = G__18069;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18035){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18057 = f__8363__auto__.call(null);
(statearr_18057[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18070 = [];
var len__5726__auto___18122 = arguments.length;
var i__5727__auto___18123 = (0);
while(true){
if((i__5727__auto___18123 < len__5726__auto___18122)){
args18070.push((arguments[i__5727__auto___18123]));

var G__18124 = (i__5727__auto___18123 + (1));
i__5727__auto___18123 = G__18124;
continue;
} else {
}
break;
}

var G__18072 = args18070.length;
switch (G__18072) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18070.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18097){
var state_val_18098 = (state_18097[(1)]);
if((state_val_18098 === (7))){
var inst_18079 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
var statearr_18099_18126 = state_18097__$1;
(statearr_18099_18126[(2)] = inst_18079);

(statearr_18099_18126[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (1))){
var inst_18073 = cljs.core.seq.call(null,coll);
var inst_18074 = inst_18073;
var state_18097__$1 = (function (){var statearr_18100 = state_18097;
(statearr_18100[(7)] = inst_18074);

return statearr_18100;
})();
var statearr_18101_18127 = state_18097__$1;
(statearr_18101_18127[(2)] = null);

(statearr_18101_18127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (4))){
var inst_18074 = (state_18097[(7)]);
var inst_18077 = cljs.core.first.call(null,inst_18074);
var state_18097__$1 = state_18097;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18097__$1,(7),ch,inst_18077);
} else {
if((state_val_18098 === (13))){
var inst_18091 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
var statearr_18102_18128 = state_18097__$1;
(statearr_18102_18128[(2)] = inst_18091);

(statearr_18102_18128[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (6))){
var inst_18082 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
if(cljs.core.truth_(inst_18082)){
var statearr_18103_18129 = state_18097__$1;
(statearr_18103_18129[(1)] = (8));

} else {
var statearr_18104_18130 = state_18097__$1;
(statearr_18104_18130[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (3))){
var inst_18095 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18097__$1,inst_18095);
} else {
if((state_val_18098 === (12))){
var state_18097__$1 = state_18097;
var statearr_18105_18131 = state_18097__$1;
(statearr_18105_18131[(2)] = null);

(statearr_18105_18131[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (2))){
var inst_18074 = (state_18097[(7)]);
var state_18097__$1 = state_18097;
if(cljs.core.truth_(inst_18074)){
var statearr_18106_18132 = state_18097__$1;
(statearr_18106_18132[(1)] = (4));

} else {
var statearr_18107_18133 = state_18097__$1;
(statearr_18107_18133[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (11))){
var inst_18088 = cljs.core.async.close_BANG_.call(null,ch);
var state_18097__$1 = state_18097;
var statearr_18108_18134 = state_18097__$1;
(statearr_18108_18134[(2)] = inst_18088);

(statearr_18108_18134[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (9))){
var state_18097__$1 = state_18097;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18109_18135 = state_18097__$1;
(statearr_18109_18135[(1)] = (11));

} else {
var statearr_18110_18136 = state_18097__$1;
(statearr_18110_18136[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (5))){
var inst_18074 = (state_18097[(7)]);
var state_18097__$1 = state_18097;
var statearr_18111_18137 = state_18097__$1;
(statearr_18111_18137[(2)] = inst_18074);

(statearr_18111_18137[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (10))){
var inst_18093 = (state_18097[(2)]);
var state_18097__$1 = state_18097;
var statearr_18112_18138 = state_18097__$1;
(statearr_18112_18138[(2)] = inst_18093);

(statearr_18112_18138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18098 === (8))){
var inst_18074 = (state_18097[(7)]);
var inst_18084 = cljs.core.next.call(null,inst_18074);
var inst_18074__$1 = inst_18084;
var state_18097__$1 = (function (){var statearr_18113 = state_18097;
(statearr_18113[(7)] = inst_18074__$1);

return statearr_18113;
})();
var statearr_18114_18139 = state_18097__$1;
(statearr_18114_18139[(2)] = null);

(statearr_18114_18139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18118 = [null,null,null,null,null,null,null,null];
(statearr_18118[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18118[(1)] = (1));

return statearr_18118;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18097){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18119){if((e18119 instanceof Object)){
var ex__8254__auto__ = e18119;
var statearr_18120_18140 = state_18097;
(statearr_18120_18140[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18097);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18119;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18141 = state_18097;
state_18097 = G__18141;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18097){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18121 = f__8363__auto__.call(null);
(statearr_18121[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18363 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18363 = (function (mult,ch,cs,meta18364){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18364 = meta18364;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18363.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18365,meta18364__$1){
var self__ = this;
var _18365__$1 = this;
return (new cljs.core.async.t_cljs$core$async18363(self__.mult,self__.ch,self__.cs,meta18364__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18363.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18365){
var self__ = this;
var _18365__$1 = this;
return self__.meta18364;
});})(cs))
;

cljs.core.async.t_cljs$core$async18363.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18363.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18363.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18363.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18363.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18363.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18363.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18364","meta18364",15958021,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18363.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18363.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18363";

cljs.core.async.t_cljs$core$async18363.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18363");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18363 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18363(mult__$1,ch__$1,cs__$1,meta18364){
return (new cljs.core.async.t_cljs$core$async18363(mult__$1,ch__$1,cs__$1,meta18364));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18363(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18584 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18584,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18584,cs,m,dchan,dctr,done){
return (function (state_18496){
var state_val_18497 = (state_18496[(1)]);
if((state_val_18497 === (7))){
var inst_18492 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18498_18585 = state_18496__$1;
(statearr_18498_18585[(2)] = inst_18492);

(statearr_18498_18585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (20))){
var inst_18397 = (state_18496[(7)]);
var inst_18407 = cljs.core.first.call(null,inst_18397);
var inst_18408 = cljs.core.nth.call(null,inst_18407,(0),null);
var inst_18409 = cljs.core.nth.call(null,inst_18407,(1),null);
var state_18496__$1 = (function (){var statearr_18499 = state_18496;
(statearr_18499[(8)] = inst_18408);

return statearr_18499;
})();
if(cljs.core.truth_(inst_18409)){
var statearr_18500_18586 = state_18496__$1;
(statearr_18500_18586[(1)] = (22));

} else {
var statearr_18501_18587 = state_18496__$1;
(statearr_18501_18587[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (27))){
var inst_18439 = (state_18496[(9)]);
var inst_18444 = (state_18496[(10)]);
var inst_18368 = (state_18496[(11)]);
var inst_18437 = (state_18496[(12)]);
var inst_18444__$1 = cljs.core._nth.call(null,inst_18437,inst_18439);
var inst_18445 = cljs.core.async.put_BANG_.call(null,inst_18444__$1,inst_18368,done);
var state_18496__$1 = (function (){var statearr_18502 = state_18496;
(statearr_18502[(10)] = inst_18444__$1);

return statearr_18502;
})();
if(cljs.core.truth_(inst_18445)){
var statearr_18503_18588 = state_18496__$1;
(statearr_18503_18588[(1)] = (30));

} else {
var statearr_18504_18589 = state_18496__$1;
(statearr_18504_18589[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (1))){
var state_18496__$1 = state_18496;
var statearr_18505_18590 = state_18496__$1;
(statearr_18505_18590[(2)] = null);

(statearr_18505_18590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (24))){
var inst_18397 = (state_18496[(7)]);
var inst_18414 = (state_18496[(2)]);
var inst_18415 = cljs.core.next.call(null,inst_18397);
var inst_18377 = inst_18415;
var inst_18378 = null;
var inst_18379 = (0);
var inst_18380 = (0);
var state_18496__$1 = (function (){var statearr_18506 = state_18496;
(statearr_18506[(13)] = inst_18380);

(statearr_18506[(14)] = inst_18377);

(statearr_18506[(15)] = inst_18414);

(statearr_18506[(16)] = inst_18379);

(statearr_18506[(17)] = inst_18378);

return statearr_18506;
})();
var statearr_18507_18591 = state_18496__$1;
(statearr_18507_18591[(2)] = null);

(statearr_18507_18591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (39))){
var state_18496__$1 = state_18496;
var statearr_18511_18592 = state_18496__$1;
(statearr_18511_18592[(2)] = null);

(statearr_18511_18592[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (4))){
var inst_18368 = (state_18496[(11)]);
var inst_18368__$1 = (state_18496[(2)]);
var inst_18369 = (inst_18368__$1 == null);
var state_18496__$1 = (function (){var statearr_18512 = state_18496;
(statearr_18512[(11)] = inst_18368__$1);

return statearr_18512;
})();
if(cljs.core.truth_(inst_18369)){
var statearr_18513_18593 = state_18496__$1;
(statearr_18513_18593[(1)] = (5));

} else {
var statearr_18514_18594 = state_18496__$1;
(statearr_18514_18594[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (15))){
var inst_18380 = (state_18496[(13)]);
var inst_18377 = (state_18496[(14)]);
var inst_18379 = (state_18496[(16)]);
var inst_18378 = (state_18496[(17)]);
var inst_18393 = (state_18496[(2)]);
var inst_18394 = (inst_18380 + (1));
var tmp18508 = inst_18377;
var tmp18509 = inst_18379;
var tmp18510 = inst_18378;
var inst_18377__$1 = tmp18508;
var inst_18378__$1 = tmp18510;
var inst_18379__$1 = tmp18509;
var inst_18380__$1 = inst_18394;
var state_18496__$1 = (function (){var statearr_18515 = state_18496;
(statearr_18515[(13)] = inst_18380__$1);

(statearr_18515[(18)] = inst_18393);

(statearr_18515[(14)] = inst_18377__$1);

(statearr_18515[(16)] = inst_18379__$1);

(statearr_18515[(17)] = inst_18378__$1);

return statearr_18515;
})();
var statearr_18516_18595 = state_18496__$1;
(statearr_18516_18595[(2)] = null);

(statearr_18516_18595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (21))){
var inst_18418 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18520_18596 = state_18496__$1;
(statearr_18520_18596[(2)] = inst_18418);

(statearr_18520_18596[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (31))){
var inst_18444 = (state_18496[(10)]);
var inst_18448 = done.call(null,null);
var inst_18449 = cljs.core.async.untap_STAR_.call(null,m,inst_18444);
var state_18496__$1 = (function (){var statearr_18521 = state_18496;
(statearr_18521[(19)] = inst_18448);

return statearr_18521;
})();
var statearr_18522_18597 = state_18496__$1;
(statearr_18522_18597[(2)] = inst_18449);

(statearr_18522_18597[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (32))){
var inst_18439 = (state_18496[(9)]);
var inst_18436 = (state_18496[(20)]);
var inst_18438 = (state_18496[(21)]);
var inst_18437 = (state_18496[(12)]);
var inst_18451 = (state_18496[(2)]);
var inst_18452 = (inst_18439 + (1));
var tmp18517 = inst_18436;
var tmp18518 = inst_18438;
var tmp18519 = inst_18437;
var inst_18436__$1 = tmp18517;
var inst_18437__$1 = tmp18519;
var inst_18438__$1 = tmp18518;
var inst_18439__$1 = inst_18452;
var state_18496__$1 = (function (){var statearr_18523 = state_18496;
(statearr_18523[(9)] = inst_18439__$1);

(statearr_18523[(20)] = inst_18436__$1);

(statearr_18523[(21)] = inst_18438__$1);

(statearr_18523[(22)] = inst_18451);

(statearr_18523[(12)] = inst_18437__$1);

return statearr_18523;
})();
var statearr_18524_18598 = state_18496__$1;
(statearr_18524_18598[(2)] = null);

(statearr_18524_18598[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (40))){
var inst_18464 = (state_18496[(23)]);
var inst_18468 = done.call(null,null);
var inst_18469 = cljs.core.async.untap_STAR_.call(null,m,inst_18464);
var state_18496__$1 = (function (){var statearr_18525 = state_18496;
(statearr_18525[(24)] = inst_18468);

return statearr_18525;
})();
var statearr_18526_18599 = state_18496__$1;
(statearr_18526_18599[(2)] = inst_18469);

(statearr_18526_18599[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (33))){
var inst_18455 = (state_18496[(25)]);
var inst_18457 = cljs.core.chunked_seq_QMARK_.call(null,inst_18455);
var state_18496__$1 = state_18496;
if(inst_18457){
var statearr_18527_18600 = state_18496__$1;
(statearr_18527_18600[(1)] = (36));

} else {
var statearr_18528_18601 = state_18496__$1;
(statearr_18528_18601[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (13))){
var inst_18387 = (state_18496[(26)]);
var inst_18390 = cljs.core.async.close_BANG_.call(null,inst_18387);
var state_18496__$1 = state_18496;
var statearr_18529_18602 = state_18496__$1;
(statearr_18529_18602[(2)] = inst_18390);

(statearr_18529_18602[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (22))){
var inst_18408 = (state_18496[(8)]);
var inst_18411 = cljs.core.async.close_BANG_.call(null,inst_18408);
var state_18496__$1 = state_18496;
var statearr_18530_18603 = state_18496__$1;
(statearr_18530_18603[(2)] = inst_18411);

(statearr_18530_18603[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (36))){
var inst_18455 = (state_18496[(25)]);
var inst_18459 = cljs.core.chunk_first.call(null,inst_18455);
var inst_18460 = cljs.core.chunk_rest.call(null,inst_18455);
var inst_18461 = cljs.core.count.call(null,inst_18459);
var inst_18436 = inst_18460;
var inst_18437 = inst_18459;
var inst_18438 = inst_18461;
var inst_18439 = (0);
var state_18496__$1 = (function (){var statearr_18531 = state_18496;
(statearr_18531[(9)] = inst_18439);

(statearr_18531[(20)] = inst_18436);

(statearr_18531[(21)] = inst_18438);

(statearr_18531[(12)] = inst_18437);

return statearr_18531;
})();
var statearr_18532_18604 = state_18496__$1;
(statearr_18532_18604[(2)] = null);

(statearr_18532_18604[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (41))){
var inst_18455 = (state_18496[(25)]);
var inst_18471 = (state_18496[(2)]);
var inst_18472 = cljs.core.next.call(null,inst_18455);
var inst_18436 = inst_18472;
var inst_18437 = null;
var inst_18438 = (0);
var inst_18439 = (0);
var state_18496__$1 = (function (){var statearr_18533 = state_18496;
(statearr_18533[(9)] = inst_18439);

(statearr_18533[(20)] = inst_18436);

(statearr_18533[(21)] = inst_18438);

(statearr_18533[(27)] = inst_18471);

(statearr_18533[(12)] = inst_18437);

return statearr_18533;
})();
var statearr_18534_18605 = state_18496__$1;
(statearr_18534_18605[(2)] = null);

(statearr_18534_18605[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (43))){
var state_18496__$1 = state_18496;
var statearr_18535_18606 = state_18496__$1;
(statearr_18535_18606[(2)] = null);

(statearr_18535_18606[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (29))){
var inst_18480 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18536_18607 = state_18496__$1;
(statearr_18536_18607[(2)] = inst_18480);

(statearr_18536_18607[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (44))){
var inst_18489 = (state_18496[(2)]);
var state_18496__$1 = (function (){var statearr_18537 = state_18496;
(statearr_18537[(28)] = inst_18489);

return statearr_18537;
})();
var statearr_18538_18608 = state_18496__$1;
(statearr_18538_18608[(2)] = null);

(statearr_18538_18608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (6))){
var inst_18428 = (state_18496[(29)]);
var inst_18427 = cljs.core.deref.call(null,cs);
var inst_18428__$1 = cljs.core.keys.call(null,inst_18427);
var inst_18429 = cljs.core.count.call(null,inst_18428__$1);
var inst_18430 = cljs.core.reset_BANG_.call(null,dctr,inst_18429);
var inst_18435 = cljs.core.seq.call(null,inst_18428__$1);
var inst_18436 = inst_18435;
var inst_18437 = null;
var inst_18438 = (0);
var inst_18439 = (0);
var state_18496__$1 = (function (){var statearr_18539 = state_18496;
(statearr_18539[(9)] = inst_18439);

(statearr_18539[(20)] = inst_18436);

(statearr_18539[(21)] = inst_18438);

(statearr_18539[(30)] = inst_18430);

(statearr_18539[(12)] = inst_18437);

(statearr_18539[(29)] = inst_18428__$1);

return statearr_18539;
})();
var statearr_18540_18609 = state_18496__$1;
(statearr_18540_18609[(2)] = null);

(statearr_18540_18609[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (28))){
var inst_18436 = (state_18496[(20)]);
var inst_18455 = (state_18496[(25)]);
var inst_18455__$1 = cljs.core.seq.call(null,inst_18436);
var state_18496__$1 = (function (){var statearr_18541 = state_18496;
(statearr_18541[(25)] = inst_18455__$1);

return statearr_18541;
})();
if(inst_18455__$1){
var statearr_18542_18610 = state_18496__$1;
(statearr_18542_18610[(1)] = (33));

} else {
var statearr_18543_18611 = state_18496__$1;
(statearr_18543_18611[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (25))){
var inst_18439 = (state_18496[(9)]);
var inst_18438 = (state_18496[(21)]);
var inst_18441 = (inst_18439 < inst_18438);
var inst_18442 = inst_18441;
var state_18496__$1 = state_18496;
if(cljs.core.truth_(inst_18442)){
var statearr_18544_18612 = state_18496__$1;
(statearr_18544_18612[(1)] = (27));

} else {
var statearr_18545_18613 = state_18496__$1;
(statearr_18545_18613[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (34))){
var state_18496__$1 = state_18496;
var statearr_18546_18614 = state_18496__$1;
(statearr_18546_18614[(2)] = null);

(statearr_18546_18614[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (17))){
var state_18496__$1 = state_18496;
var statearr_18547_18615 = state_18496__$1;
(statearr_18547_18615[(2)] = null);

(statearr_18547_18615[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (3))){
var inst_18494 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18496__$1,inst_18494);
} else {
if((state_val_18497 === (12))){
var inst_18423 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18548_18616 = state_18496__$1;
(statearr_18548_18616[(2)] = inst_18423);

(statearr_18548_18616[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (2))){
var state_18496__$1 = state_18496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18496__$1,(4),ch);
} else {
if((state_val_18497 === (23))){
var state_18496__$1 = state_18496;
var statearr_18549_18617 = state_18496__$1;
(statearr_18549_18617[(2)] = null);

(statearr_18549_18617[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (35))){
var inst_18478 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18550_18618 = state_18496__$1;
(statearr_18550_18618[(2)] = inst_18478);

(statearr_18550_18618[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (19))){
var inst_18397 = (state_18496[(7)]);
var inst_18401 = cljs.core.chunk_first.call(null,inst_18397);
var inst_18402 = cljs.core.chunk_rest.call(null,inst_18397);
var inst_18403 = cljs.core.count.call(null,inst_18401);
var inst_18377 = inst_18402;
var inst_18378 = inst_18401;
var inst_18379 = inst_18403;
var inst_18380 = (0);
var state_18496__$1 = (function (){var statearr_18551 = state_18496;
(statearr_18551[(13)] = inst_18380);

(statearr_18551[(14)] = inst_18377);

(statearr_18551[(16)] = inst_18379);

(statearr_18551[(17)] = inst_18378);

return statearr_18551;
})();
var statearr_18552_18619 = state_18496__$1;
(statearr_18552_18619[(2)] = null);

(statearr_18552_18619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (11))){
var inst_18377 = (state_18496[(14)]);
var inst_18397 = (state_18496[(7)]);
var inst_18397__$1 = cljs.core.seq.call(null,inst_18377);
var state_18496__$1 = (function (){var statearr_18553 = state_18496;
(statearr_18553[(7)] = inst_18397__$1);

return statearr_18553;
})();
if(inst_18397__$1){
var statearr_18554_18620 = state_18496__$1;
(statearr_18554_18620[(1)] = (16));

} else {
var statearr_18555_18621 = state_18496__$1;
(statearr_18555_18621[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (9))){
var inst_18425 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18556_18622 = state_18496__$1;
(statearr_18556_18622[(2)] = inst_18425);

(statearr_18556_18622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (5))){
var inst_18375 = cljs.core.deref.call(null,cs);
var inst_18376 = cljs.core.seq.call(null,inst_18375);
var inst_18377 = inst_18376;
var inst_18378 = null;
var inst_18379 = (0);
var inst_18380 = (0);
var state_18496__$1 = (function (){var statearr_18557 = state_18496;
(statearr_18557[(13)] = inst_18380);

(statearr_18557[(14)] = inst_18377);

(statearr_18557[(16)] = inst_18379);

(statearr_18557[(17)] = inst_18378);

return statearr_18557;
})();
var statearr_18558_18623 = state_18496__$1;
(statearr_18558_18623[(2)] = null);

(statearr_18558_18623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (14))){
var state_18496__$1 = state_18496;
var statearr_18559_18624 = state_18496__$1;
(statearr_18559_18624[(2)] = null);

(statearr_18559_18624[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (45))){
var inst_18486 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18560_18625 = state_18496__$1;
(statearr_18560_18625[(2)] = inst_18486);

(statearr_18560_18625[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (26))){
var inst_18428 = (state_18496[(29)]);
var inst_18482 = (state_18496[(2)]);
var inst_18483 = cljs.core.seq.call(null,inst_18428);
var state_18496__$1 = (function (){var statearr_18561 = state_18496;
(statearr_18561[(31)] = inst_18482);

return statearr_18561;
})();
if(inst_18483){
var statearr_18562_18626 = state_18496__$1;
(statearr_18562_18626[(1)] = (42));

} else {
var statearr_18563_18627 = state_18496__$1;
(statearr_18563_18627[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (16))){
var inst_18397 = (state_18496[(7)]);
var inst_18399 = cljs.core.chunked_seq_QMARK_.call(null,inst_18397);
var state_18496__$1 = state_18496;
if(inst_18399){
var statearr_18564_18628 = state_18496__$1;
(statearr_18564_18628[(1)] = (19));

} else {
var statearr_18565_18629 = state_18496__$1;
(statearr_18565_18629[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (38))){
var inst_18475 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18566_18630 = state_18496__$1;
(statearr_18566_18630[(2)] = inst_18475);

(statearr_18566_18630[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (30))){
var state_18496__$1 = state_18496;
var statearr_18567_18631 = state_18496__$1;
(statearr_18567_18631[(2)] = null);

(statearr_18567_18631[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (10))){
var inst_18380 = (state_18496[(13)]);
var inst_18378 = (state_18496[(17)]);
var inst_18386 = cljs.core._nth.call(null,inst_18378,inst_18380);
var inst_18387 = cljs.core.nth.call(null,inst_18386,(0),null);
var inst_18388 = cljs.core.nth.call(null,inst_18386,(1),null);
var state_18496__$1 = (function (){var statearr_18568 = state_18496;
(statearr_18568[(26)] = inst_18387);

return statearr_18568;
})();
if(cljs.core.truth_(inst_18388)){
var statearr_18569_18632 = state_18496__$1;
(statearr_18569_18632[(1)] = (13));

} else {
var statearr_18570_18633 = state_18496__$1;
(statearr_18570_18633[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (18))){
var inst_18421 = (state_18496[(2)]);
var state_18496__$1 = state_18496;
var statearr_18571_18634 = state_18496__$1;
(statearr_18571_18634[(2)] = inst_18421);

(statearr_18571_18634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (42))){
var state_18496__$1 = state_18496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18496__$1,(45),dchan);
} else {
if((state_val_18497 === (37))){
var inst_18368 = (state_18496[(11)]);
var inst_18464 = (state_18496[(23)]);
var inst_18455 = (state_18496[(25)]);
var inst_18464__$1 = cljs.core.first.call(null,inst_18455);
var inst_18465 = cljs.core.async.put_BANG_.call(null,inst_18464__$1,inst_18368,done);
var state_18496__$1 = (function (){var statearr_18572 = state_18496;
(statearr_18572[(23)] = inst_18464__$1);

return statearr_18572;
})();
if(cljs.core.truth_(inst_18465)){
var statearr_18573_18635 = state_18496__$1;
(statearr_18573_18635[(1)] = (39));

} else {
var statearr_18574_18636 = state_18496__$1;
(statearr_18574_18636[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18497 === (8))){
var inst_18380 = (state_18496[(13)]);
var inst_18379 = (state_18496[(16)]);
var inst_18382 = (inst_18380 < inst_18379);
var inst_18383 = inst_18382;
var state_18496__$1 = state_18496;
if(cljs.core.truth_(inst_18383)){
var statearr_18575_18637 = state_18496__$1;
(statearr_18575_18637[(1)] = (10));

} else {
var statearr_18576_18638 = state_18496__$1;
(statearr_18576_18638[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18584,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18584,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18580 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18580[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18580[(1)] = (1));

return statearr_18580;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18496){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18581){if((e18581 instanceof Object)){
var ex__8254__auto__ = e18581;
var statearr_18582_18639 = state_18496;
(statearr_18582_18639[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18581;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18640 = state_18496;
state_18496 = G__18640;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18496){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18584,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18583 = f__8363__auto__.call(null);
(statearr_18583[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18584);

return statearr_18583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18584,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18641 = [];
var len__5726__auto___18644 = arguments.length;
var i__5727__auto___18645 = (0);
while(true){
if((i__5727__auto___18645 < len__5726__auto___18644)){
args18641.push((arguments[i__5727__auto___18645]));

var G__18646 = (i__5727__auto___18645 + (1));
i__5727__auto___18645 = G__18646;
continue;
} else {
}
break;
}

var G__18643 = args18641.length;
switch (G__18643) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18641.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18658 = arguments.length;
var i__5727__auto___18659 = (0);
while(true){
if((i__5727__auto___18659 < len__5726__auto___18658)){
args__5733__auto__.push((arguments[i__5727__auto___18659]));

var G__18660 = (i__5727__auto___18659 + (1));
i__5727__auto___18659 = G__18660;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18652){
var map__18653 = p__18652;
var map__18653__$1 = ((((!((map__18653 == null)))?((((map__18653.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18653.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18653):map__18653);
var opts = map__18653__$1;
var statearr_18655_18661 = state;
(statearr_18655_18661[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18653,map__18653__$1,opts){
return (function (val){
var statearr_18656_18662 = state;
(statearr_18656_18662[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18653,map__18653__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18657_18663 = state;
(statearr_18657_18663[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18648){
var G__18649 = cljs.core.first.call(null,seq18648);
var seq18648__$1 = cljs.core.next.call(null,seq18648);
var G__18650 = cljs.core.first.call(null,seq18648__$1);
var seq18648__$2 = cljs.core.next.call(null,seq18648__$1);
var G__18651 = cljs.core.first.call(null,seq18648__$2);
var seq18648__$3 = cljs.core.next.call(null,seq18648__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18649,G__18650,G__18651,seq18648__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18827 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18827 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18828){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18828 = meta18828;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18829,meta18828__$1){
var self__ = this;
var _18829__$1 = this;
return (new cljs.core.async.t_cljs$core$async18827(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18828__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18829){
var self__ = this;
var _18829__$1 = this;
return self__.meta18828;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18828","meta18828",1331443742,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18827.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18827.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18827";

cljs.core.async.t_cljs$core$async18827.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18827");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18827 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18827(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18828){
return (new cljs.core.async.t_cljs$core$async18827(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18828));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18827(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___18990 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18990,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18990,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18927){
var state_val_18928 = (state_18927[(1)]);
if((state_val_18928 === (7))){
var inst_18845 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
var statearr_18929_18991 = state_18927__$1;
(statearr_18929_18991[(2)] = inst_18845);

(statearr_18929_18991[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (20))){
var inst_18857 = (state_18927[(7)]);
var state_18927__$1 = state_18927;
var statearr_18930_18992 = state_18927__$1;
(statearr_18930_18992[(2)] = inst_18857);

(statearr_18930_18992[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (27))){
var state_18927__$1 = state_18927;
var statearr_18931_18993 = state_18927__$1;
(statearr_18931_18993[(2)] = null);

(statearr_18931_18993[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (1))){
var inst_18833 = (state_18927[(8)]);
var inst_18833__$1 = calc_state.call(null);
var inst_18835 = (inst_18833__$1 == null);
var inst_18836 = cljs.core.not.call(null,inst_18835);
var state_18927__$1 = (function (){var statearr_18932 = state_18927;
(statearr_18932[(8)] = inst_18833__$1);

return statearr_18932;
})();
if(inst_18836){
var statearr_18933_18994 = state_18927__$1;
(statearr_18933_18994[(1)] = (2));

} else {
var statearr_18934_18995 = state_18927__$1;
(statearr_18934_18995[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (24))){
var inst_18901 = (state_18927[(9)]);
var inst_18880 = (state_18927[(10)]);
var inst_18887 = (state_18927[(11)]);
var inst_18901__$1 = inst_18880.call(null,inst_18887);
var state_18927__$1 = (function (){var statearr_18935 = state_18927;
(statearr_18935[(9)] = inst_18901__$1);

return statearr_18935;
})();
if(cljs.core.truth_(inst_18901__$1)){
var statearr_18936_18996 = state_18927__$1;
(statearr_18936_18996[(1)] = (29));

} else {
var statearr_18937_18997 = state_18927__$1;
(statearr_18937_18997[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (4))){
var inst_18848 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
if(cljs.core.truth_(inst_18848)){
var statearr_18938_18998 = state_18927__$1;
(statearr_18938_18998[(1)] = (8));

} else {
var statearr_18939_18999 = state_18927__$1;
(statearr_18939_18999[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (15))){
var inst_18874 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
if(cljs.core.truth_(inst_18874)){
var statearr_18940_19000 = state_18927__$1;
(statearr_18940_19000[(1)] = (19));

} else {
var statearr_18941_19001 = state_18927__$1;
(statearr_18941_19001[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (21))){
var inst_18879 = (state_18927[(12)]);
var inst_18879__$1 = (state_18927[(2)]);
var inst_18880 = cljs.core.get.call(null,inst_18879__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18881 = cljs.core.get.call(null,inst_18879__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18882 = cljs.core.get.call(null,inst_18879__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18927__$1 = (function (){var statearr_18942 = state_18927;
(statearr_18942[(12)] = inst_18879__$1);

(statearr_18942[(10)] = inst_18880);

(statearr_18942[(13)] = inst_18881);

return statearr_18942;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18927__$1,(22),inst_18882);
} else {
if((state_val_18928 === (31))){
var inst_18909 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
if(cljs.core.truth_(inst_18909)){
var statearr_18943_19002 = state_18927__$1;
(statearr_18943_19002[(1)] = (32));

} else {
var statearr_18944_19003 = state_18927__$1;
(statearr_18944_19003[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (32))){
var inst_18886 = (state_18927[(14)]);
var state_18927__$1 = state_18927;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18927__$1,(35),out,inst_18886);
} else {
if((state_val_18928 === (33))){
var inst_18879 = (state_18927[(12)]);
var inst_18857 = inst_18879;
var state_18927__$1 = (function (){var statearr_18945 = state_18927;
(statearr_18945[(7)] = inst_18857);

return statearr_18945;
})();
var statearr_18946_19004 = state_18927__$1;
(statearr_18946_19004[(2)] = null);

(statearr_18946_19004[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (13))){
var inst_18857 = (state_18927[(7)]);
var inst_18864 = inst_18857.cljs$lang$protocol_mask$partition0$;
var inst_18865 = (inst_18864 & (64));
var inst_18866 = inst_18857.cljs$core$ISeq$;
var inst_18867 = (inst_18865) || (inst_18866);
var state_18927__$1 = state_18927;
if(cljs.core.truth_(inst_18867)){
var statearr_18947_19005 = state_18927__$1;
(statearr_18947_19005[(1)] = (16));

} else {
var statearr_18948_19006 = state_18927__$1;
(statearr_18948_19006[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (22))){
var inst_18886 = (state_18927[(14)]);
var inst_18887 = (state_18927[(11)]);
var inst_18885 = (state_18927[(2)]);
var inst_18886__$1 = cljs.core.nth.call(null,inst_18885,(0),null);
var inst_18887__$1 = cljs.core.nth.call(null,inst_18885,(1),null);
var inst_18888 = (inst_18886__$1 == null);
var inst_18889 = cljs.core._EQ_.call(null,inst_18887__$1,change);
var inst_18890 = (inst_18888) || (inst_18889);
var state_18927__$1 = (function (){var statearr_18949 = state_18927;
(statearr_18949[(14)] = inst_18886__$1);

(statearr_18949[(11)] = inst_18887__$1);

return statearr_18949;
})();
if(cljs.core.truth_(inst_18890)){
var statearr_18950_19007 = state_18927__$1;
(statearr_18950_19007[(1)] = (23));

} else {
var statearr_18951_19008 = state_18927__$1;
(statearr_18951_19008[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (36))){
var inst_18879 = (state_18927[(12)]);
var inst_18857 = inst_18879;
var state_18927__$1 = (function (){var statearr_18952 = state_18927;
(statearr_18952[(7)] = inst_18857);

return statearr_18952;
})();
var statearr_18953_19009 = state_18927__$1;
(statearr_18953_19009[(2)] = null);

(statearr_18953_19009[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (29))){
var inst_18901 = (state_18927[(9)]);
var state_18927__$1 = state_18927;
var statearr_18954_19010 = state_18927__$1;
(statearr_18954_19010[(2)] = inst_18901);

(statearr_18954_19010[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (6))){
var state_18927__$1 = state_18927;
var statearr_18955_19011 = state_18927__$1;
(statearr_18955_19011[(2)] = false);

(statearr_18955_19011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (28))){
var inst_18897 = (state_18927[(2)]);
var inst_18898 = calc_state.call(null);
var inst_18857 = inst_18898;
var state_18927__$1 = (function (){var statearr_18956 = state_18927;
(statearr_18956[(7)] = inst_18857);

(statearr_18956[(15)] = inst_18897);

return statearr_18956;
})();
var statearr_18957_19012 = state_18927__$1;
(statearr_18957_19012[(2)] = null);

(statearr_18957_19012[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (25))){
var inst_18923 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
var statearr_18958_19013 = state_18927__$1;
(statearr_18958_19013[(2)] = inst_18923);

(statearr_18958_19013[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (34))){
var inst_18921 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
var statearr_18959_19014 = state_18927__$1;
(statearr_18959_19014[(2)] = inst_18921);

(statearr_18959_19014[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (17))){
var state_18927__$1 = state_18927;
var statearr_18960_19015 = state_18927__$1;
(statearr_18960_19015[(2)] = false);

(statearr_18960_19015[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (3))){
var state_18927__$1 = state_18927;
var statearr_18961_19016 = state_18927__$1;
(statearr_18961_19016[(2)] = false);

(statearr_18961_19016[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (12))){
var inst_18925 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18927__$1,inst_18925);
} else {
if((state_val_18928 === (2))){
var inst_18833 = (state_18927[(8)]);
var inst_18838 = inst_18833.cljs$lang$protocol_mask$partition0$;
var inst_18839 = (inst_18838 & (64));
var inst_18840 = inst_18833.cljs$core$ISeq$;
var inst_18841 = (inst_18839) || (inst_18840);
var state_18927__$1 = state_18927;
if(cljs.core.truth_(inst_18841)){
var statearr_18962_19017 = state_18927__$1;
(statearr_18962_19017[(1)] = (5));

} else {
var statearr_18963_19018 = state_18927__$1;
(statearr_18963_19018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (23))){
var inst_18886 = (state_18927[(14)]);
var inst_18892 = (inst_18886 == null);
var state_18927__$1 = state_18927;
if(cljs.core.truth_(inst_18892)){
var statearr_18964_19019 = state_18927__$1;
(statearr_18964_19019[(1)] = (26));

} else {
var statearr_18965_19020 = state_18927__$1;
(statearr_18965_19020[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (35))){
var inst_18912 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
if(cljs.core.truth_(inst_18912)){
var statearr_18966_19021 = state_18927__$1;
(statearr_18966_19021[(1)] = (36));

} else {
var statearr_18967_19022 = state_18927__$1;
(statearr_18967_19022[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (19))){
var inst_18857 = (state_18927[(7)]);
var inst_18876 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18857);
var state_18927__$1 = state_18927;
var statearr_18968_19023 = state_18927__$1;
(statearr_18968_19023[(2)] = inst_18876);

(statearr_18968_19023[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (11))){
var inst_18857 = (state_18927[(7)]);
var inst_18861 = (inst_18857 == null);
var inst_18862 = cljs.core.not.call(null,inst_18861);
var state_18927__$1 = state_18927;
if(inst_18862){
var statearr_18969_19024 = state_18927__$1;
(statearr_18969_19024[(1)] = (13));

} else {
var statearr_18970_19025 = state_18927__$1;
(statearr_18970_19025[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (9))){
var inst_18833 = (state_18927[(8)]);
var state_18927__$1 = state_18927;
var statearr_18971_19026 = state_18927__$1;
(statearr_18971_19026[(2)] = inst_18833);

(statearr_18971_19026[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (5))){
var state_18927__$1 = state_18927;
var statearr_18972_19027 = state_18927__$1;
(statearr_18972_19027[(2)] = true);

(statearr_18972_19027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (14))){
var state_18927__$1 = state_18927;
var statearr_18973_19028 = state_18927__$1;
(statearr_18973_19028[(2)] = false);

(statearr_18973_19028[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (26))){
var inst_18887 = (state_18927[(11)]);
var inst_18894 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18887);
var state_18927__$1 = state_18927;
var statearr_18974_19029 = state_18927__$1;
(statearr_18974_19029[(2)] = inst_18894);

(statearr_18974_19029[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (16))){
var state_18927__$1 = state_18927;
var statearr_18975_19030 = state_18927__$1;
(statearr_18975_19030[(2)] = true);

(statearr_18975_19030[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (38))){
var inst_18917 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
var statearr_18976_19031 = state_18927__$1;
(statearr_18976_19031[(2)] = inst_18917);

(statearr_18976_19031[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (30))){
var inst_18880 = (state_18927[(10)]);
var inst_18881 = (state_18927[(13)]);
var inst_18887 = (state_18927[(11)]);
var inst_18904 = cljs.core.empty_QMARK_.call(null,inst_18880);
var inst_18905 = inst_18881.call(null,inst_18887);
var inst_18906 = cljs.core.not.call(null,inst_18905);
var inst_18907 = (inst_18904) && (inst_18906);
var state_18927__$1 = state_18927;
var statearr_18977_19032 = state_18927__$1;
(statearr_18977_19032[(2)] = inst_18907);

(statearr_18977_19032[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (10))){
var inst_18833 = (state_18927[(8)]);
var inst_18853 = (state_18927[(2)]);
var inst_18854 = cljs.core.get.call(null,inst_18853,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18855 = cljs.core.get.call(null,inst_18853,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18856 = cljs.core.get.call(null,inst_18853,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18857 = inst_18833;
var state_18927__$1 = (function (){var statearr_18978 = state_18927;
(statearr_18978[(7)] = inst_18857);

(statearr_18978[(16)] = inst_18856);

(statearr_18978[(17)] = inst_18854);

(statearr_18978[(18)] = inst_18855);

return statearr_18978;
})();
var statearr_18979_19033 = state_18927__$1;
(statearr_18979_19033[(2)] = null);

(statearr_18979_19033[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (18))){
var inst_18871 = (state_18927[(2)]);
var state_18927__$1 = state_18927;
var statearr_18980_19034 = state_18927__$1;
(statearr_18980_19034[(2)] = inst_18871);

(statearr_18980_19034[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (37))){
var state_18927__$1 = state_18927;
var statearr_18981_19035 = state_18927__$1;
(statearr_18981_19035[(2)] = null);

(statearr_18981_19035[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18928 === (8))){
var inst_18833 = (state_18927[(8)]);
var inst_18850 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18833);
var state_18927__$1 = state_18927;
var statearr_18982_19036 = state_18927__$1;
(statearr_18982_19036[(2)] = inst_18850);

(statearr_18982_19036[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18990,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___18990,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_18986 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18986[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_18986[(1)] = (1));

return statearr_18986;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18927){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18987){if((e18987 instanceof Object)){
var ex__8254__auto__ = e18987;
var statearr_18988_19037 = state_18927;
(statearr_18988_19037[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18927);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18987;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19038 = state_18927;
state_18927 = G__19038;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18927){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18990,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_18989 = f__8363__auto__.call(null);
(statearr_18989[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18990);

return statearr_18989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18990,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19039 = [];
var len__5726__auto___19042 = arguments.length;
var i__5727__auto___19043 = (0);
while(true){
if((i__5727__auto___19043 < len__5726__auto___19042)){
args19039.push((arguments[i__5727__auto___19043]));

var G__19044 = (i__5727__auto___19043 + (1));
i__5727__auto___19043 = G__19044;
continue;
} else {
}
break;
}

var G__19041 = args19039.length;
switch (G__19041) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19039.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19047 = [];
var len__5726__auto___19172 = arguments.length;
var i__5727__auto___19173 = (0);
while(true){
if((i__5727__auto___19173 < len__5726__auto___19172)){
args19047.push((arguments[i__5727__auto___19173]));

var G__19174 = (i__5727__auto___19173 + (1));
i__5727__auto___19173 = G__19174;
continue;
} else {
}
break;
}

var G__19049 = args19047.length;
switch (G__19049) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19047.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19046_SHARP_){
if(cljs.core.truth_(p1__19046_SHARP_.call(null,topic))){
return p1__19046_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19046_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19050 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19050 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19051){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19051 = meta19051;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19052,meta19051__$1){
var self__ = this;
var _19052__$1 = this;
return (new cljs.core.async.t_cljs$core$async19050(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19051__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19052){
var self__ = this;
var _19052__$1 = this;
return self__.meta19051;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19050.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19050.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19051","meta19051",-806146433,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19050.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19050.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19050";

cljs.core.async.t_cljs$core$async19050.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19050");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19050 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19050(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19051){
return (new cljs.core.async.t_cljs$core$async19050(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19051));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19050(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19176 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19176,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19176,mults,ensure_mult,p){
return (function (state_19124){
var state_val_19125 = (state_19124[(1)]);
if((state_val_19125 === (7))){
var inst_19120 = (state_19124[(2)]);
var state_19124__$1 = state_19124;
var statearr_19126_19177 = state_19124__$1;
(statearr_19126_19177[(2)] = inst_19120);

(statearr_19126_19177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (20))){
var state_19124__$1 = state_19124;
var statearr_19127_19178 = state_19124__$1;
(statearr_19127_19178[(2)] = null);

(statearr_19127_19178[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (1))){
var state_19124__$1 = state_19124;
var statearr_19128_19179 = state_19124__$1;
(statearr_19128_19179[(2)] = null);

(statearr_19128_19179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (24))){
var inst_19103 = (state_19124[(7)]);
var inst_19112 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19103);
var state_19124__$1 = state_19124;
var statearr_19129_19180 = state_19124__$1;
(statearr_19129_19180[(2)] = inst_19112);

(statearr_19129_19180[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (4))){
var inst_19055 = (state_19124[(8)]);
var inst_19055__$1 = (state_19124[(2)]);
var inst_19056 = (inst_19055__$1 == null);
var state_19124__$1 = (function (){var statearr_19130 = state_19124;
(statearr_19130[(8)] = inst_19055__$1);

return statearr_19130;
})();
if(cljs.core.truth_(inst_19056)){
var statearr_19131_19181 = state_19124__$1;
(statearr_19131_19181[(1)] = (5));

} else {
var statearr_19132_19182 = state_19124__$1;
(statearr_19132_19182[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (15))){
var inst_19097 = (state_19124[(2)]);
var state_19124__$1 = state_19124;
var statearr_19133_19183 = state_19124__$1;
(statearr_19133_19183[(2)] = inst_19097);

(statearr_19133_19183[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (21))){
var inst_19117 = (state_19124[(2)]);
var state_19124__$1 = (function (){var statearr_19134 = state_19124;
(statearr_19134[(9)] = inst_19117);

return statearr_19134;
})();
var statearr_19135_19184 = state_19124__$1;
(statearr_19135_19184[(2)] = null);

(statearr_19135_19184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (13))){
var inst_19079 = (state_19124[(10)]);
var inst_19081 = cljs.core.chunked_seq_QMARK_.call(null,inst_19079);
var state_19124__$1 = state_19124;
if(inst_19081){
var statearr_19136_19185 = state_19124__$1;
(statearr_19136_19185[(1)] = (16));

} else {
var statearr_19137_19186 = state_19124__$1;
(statearr_19137_19186[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (22))){
var inst_19109 = (state_19124[(2)]);
var state_19124__$1 = state_19124;
if(cljs.core.truth_(inst_19109)){
var statearr_19138_19187 = state_19124__$1;
(statearr_19138_19187[(1)] = (23));

} else {
var statearr_19139_19188 = state_19124__$1;
(statearr_19139_19188[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (6))){
var inst_19103 = (state_19124[(7)]);
var inst_19105 = (state_19124[(11)]);
var inst_19055 = (state_19124[(8)]);
var inst_19103__$1 = topic_fn.call(null,inst_19055);
var inst_19104 = cljs.core.deref.call(null,mults);
var inst_19105__$1 = cljs.core.get.call(null,inst_19104,inst_19103__$1);
var state_19124__$1 = (function (){var statearr_19140 = state_19124;
(statearr_19140[(7)] = inst_19103__$1);

(statearr_19140[(11)] = inst_19105__$1);

return statearr_19140;
})();
if(cljs.core.truth_(inst_19105__$1)){
var statearr_19141_19189 = state_19124__$1;
(statearr_19141_19189[(1)] = (19));

} else {
var statearr_19142_19190 = state_19124__$1;
(statearr_19142_19190[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (25))){
var inst_19114 = (state_19124[(2)]);
var state_19124__$1 = state_19124;
var statearr_19143_19191 = state_19124__$1;
(statearr_19143_19191[(2)] = inst_19114);

(statearr_19143_19191[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (17))){
var inst_19079 = (state_19124[(10)]);
var inst_19088 = cljs.core.first.call(null,inst_19079);
var inst_19089 = cljs.core.async.muxch_STAR_.call(null,inst_19088);
var inst_19090 = cljs.core.async.close_BANG_.call(null,inst_19089);
var inst_19091 = cljs.core.next.call(null,inst_19079);
var inst_19065 = inst_19091;
var inst_19066 = null;
var inst_19067 = (0);
var inst_19068 = (0);
var state_19124__$1 = (function (){var statearr_19144 = state_19124;
(statearr_19144[(12)] = inst_19065);

(statearr_19144[(13)] = inst_19090);

(statearr_19144[(14)] = inst_19066);

(statearr_19144[(15)] = inst_19067);

(statearr_19144[(16)] = inst_19068);

return statearr_19144;
})();
var statearr_19145_19192 = state_19124__$1;
(statearr_19145_19192[(2)] = null);

(statearr_19145_19192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (3))){
var inst_19122 = (state_19124[(2)]);
var state_19124__$1 = state_19124;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19124__$1,inst_19122);
} else {
if((state_val_19125 === (12))){
var inst_19099 = (state_19124[(2)]);
var state_19124__$1 = state_19124;
var statearr_19146_19193 = state_19124__$1;
(statearr_19146_19193[(2)] = inst_19099);

(statearr_19146_19193[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (2))){
var state_19124__$1 = state_19124;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19124__$1,(4),ch);
} else {
if((state_val_19125 === (23))){
var state_19124__$1 = state_19124;
var statearr_19147_19194 = state_19124__$1;
(statearr_19147_19194[(2)] = null);

(statearr_19147_19194[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (19))){
var inst_19105 = (state_19124[(11)]);
var inst_19055 = (state_19124[(8)]);
var inst_19107 = cljs.core.async.muxch_STAR_.call(null,inst_19105);
var state_19124__$1 = state_19124;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19124__$1,(22),inst_19107,inst_19055);
} else {
if((state_val_19125 === (11))){
var inst_19065 = (state_19124[(12)]);
var inst_19079 = (state_19124[(10)]);
var inst_19079__$1 = cljs.core.seq.call(null,inst_19065);
var state_19124__$1 = (function (){var statearr_19148 = state_19124;
(statearr_19148[(10)] = inst_19079__$1);

return statearr_19148;
})();
if(inst_19079__$1){
var statearr_19149_19195 = state_19124__$1;
(statearr_19149_19195[(1)] = (13));

} else {
var statearr_19150_19196 = state_19124__$1;
(statearr_19150_19196[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (9))){
var inst_19101 = (state_19124[(2)]);
var state_19124__$1 = state_19124;
var statearr_19151_19197 = state_19124__$1;
(statearr_19151_19197[(2)] = inst_19101);

(statearr_19151_19197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (5))){
var inst_19062 = cljs.core.deref.call(null,mults);
var inst_19063 = cljs.core.vals.call(null,inst_19062);
var inst_19064 = cljs.core.seq.call(null,inst_19063);
var inst_19065 = inst_19064;
var inst_19066 = null;
var inst_19067 = (0);
var inst_19068 = (0);
var state_19124__$1 = (function (){var statearr_19152 = state_19124;
(statearr_19152[(12)] = inst_19065);

(statearr_19152[(14)] = inst_19066);

(statearr_19152[(15)] = inst_19067);

(statearr_19152[(16)] = inst_19068);

return statearr_19152;
})();
var statearr_19153_19198 = state_19124__$1;
(statearr_19153_19198[(2)] = null);

(statearr_19153_19198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (14))){
var state_19124__$1 = state_19124;
var statearr_19157_19199 = state_19124__$1;
(statearr_19157_19199[(2)] = null);

(statearr_19157_19199[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (16))){
var inst_19079 = (state_19124[(10)]);
var inst_19083 = cljs.core.chunk_first.call(null,inst_19079);
var inst_19084 = cljs.core.chunk_rest.call(null,inst_19079);
var inst_19085 = cljs.core.count.call(null,inst_19083);
var inst_19065 = inst_19084;
var inst_19066 = inst_19083;
var inst_19067 = inst_19085;
var inst_19068 = (0);
var state_19124__$1 = (function (){var statearr_19158 = state_19124;
(statearr_19158[(12)] = inst_19065);

(statearr_19158[(14)] = inst_19066);

(statearr_19158[(15)] = inst_19067);

(statearr_19158[(16)] = inst_19068);

return statearr_19158;
})();
var statearr_19159_19200 = state_19124__$1;
(statearr_19159_19200[(2)] = null);

(statearr_19159_19200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (10))){
var inst_19065 = (state_19124[(12)]);
var inst_19066 = (state_19124[(14)]);
var inst_19067 = (state_19124[(15)]);
var inst_19068 = (state_19124[(16)]);
var inst_19073 = cljs.core._nth.call(null,inst_19066,inst_19068);
var inst_19074 = cljs.core.async.muxch_STAR_.call(null,inst_19073);
var inst_19075 = cljs.core.async.close_BANG_.call(null,inst_19074);
var inst_19076 = (inst_19068 + (1));
var tmp19154 = inst_19065;
var tmp19155 = inst_19066;
var tmp19156 = inst_19067;
var inst_19065__$1 = tmp19154;
var inst_19066__$1 = tmp19155;
var inst_19067__$1 = tmp19156;
var inst_19068__$1 = inst_19076;
var state_19124__$1 = (function (){var statearr_19160 = state_19124;
(statearr_19160[(12)] = inst_19065__$1);

(statearr_19160[(17)] = inst_19075);

(statearr_19160[(14)] = inst_19066__$1);

(statearr_19160[(15)] = inst_19067__$1);

(statearr_19160[(16)] = inst_19068__$1);

return statearr_19160;
})();
var statearr_19161_19201 = state_19124__$1;
(statearr_19161_19201[(2)] = null);

(statearr_19161_19201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (18))){
var inst_19094 = (state_19124[(2)]);
var state_19124__$1 = state_19124;
var statearr_19162_19202 = state_19124__$1;
(statearr_19162_19202[(2)] = inst_19094);

(statearr_19162_19202[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19125 === (8))){
var inst_19067 = (state_19124[(15)]);
var inst_19068 = (state_19124[(16)]);
var inst_19070 = (inst_19068 < inst_19067);
var inst_19071 = inst_19070;
var state_19124__$1 = state_19124;
if(cljs.core.truth_(inst_19071)){
var statearr_19163_19203 = state_19124__$1;
(statearr_19163_19203[(1)] = (10));

} else {
var statearr_19164_19204 = state_19124__$1;
(statearr_19164_19204[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19176,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19176,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19168[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19168[(1)] = (1));

return statearr_19168;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19124){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19124);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19169){if((e19169 instanceof Object)){
var ex__8254__auto__ = e19169;
var statearr_19170_19205 = state_19124;
(statearr_19170_19205[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19124);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19169;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19206 = state_19124;
state_19124 = G__19206;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19124){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19176,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19171 = f__8363__auto__.call(null);
(statearr_19171[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19176);

return statearr_19171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19176,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19207 = [];
var len__5726__auto___19210 = arguments.length;
var i__5727__auto___19211 = (0);
while(true){
if((i__5727__auto___19211 < len__5726__auto___19210)){
args19207.push((arguments[i__5727__auto___19211]));

var G__19212 = (i__5727__auto___19211 + (1));
i__5727__auto___19211 = G__19212;
continue;
} else {
}
break;
}

var G__19209 = args19207.length;
switch (G__19209) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19207.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19214 = [];
var len__5726__auto___19217 = arguments.length;
var i__5727__auto___19218 = (0);
while(true){
if((i__5727__auto___19218 < len__5726__auto___19217)){
args19214.push((arguments[i__5727__auto___19218]));

var G__19219 = (i__5727__auto___19218 + (1));
i__5727__auto___19218 = G__19219;
continue;
} else {
}
break;
}

var G__19216 = args19214.length;
switch (G__19216) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19214.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19221 = [];
var len__5726__auto___19292 = arguments.length;
var i__5727__auto___19293 = (0);
while(true){
if((i__5727__auto___19293 < len__5726__auto___19292)){
args19221.push((arguments[i__5727__auto___19293]));

var G__19294 = (i__5727__auto___19293 + (1));
i__5727__auto___19293 = G__19294;
continue;
} else {
}
break;
}

var G__19223 = args19221.length;
switch (G__19223) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19221.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19296 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19296,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19296,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19262){
var state_val_19263 = (state_19262[(1)]);
if((state_val_19263 === (7))){
var state_19262__$1 = state_19262;
var statearr_19264_19297 = state_19262__$1;
(statearr_19264_19297[(2)] = null);

(statearr_19264_19297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (1))){
var state_19262__$1 = state_19262;
var statearr_19265_19298 = state_19262__$1;
(statearr_19265_19298[(2)] = null);

(statearr_19265_19298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (4))){
var inst_19226 = (state_19262[(7)]);
var inst_19228 = (inst_19226 < cnt);
var state_19262__$1 = state_19262;
if(cljs.core.truth_(inst_19228)){
var statearr_19266_19299 = state_19262__$1;
(statearr_19266_19299[(1)] = (6));

} else {
var statearr_19267_19300 = state_19262__$1;
(statearr_19267_19300[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (15))){
var inst_19258 = (state_19262[(2)]);
var state_19262__$1 = state_19262;
var statearr_19268_19301 = state_19262__$1;
(statearr_19268_19301[(2)] = inst_19258);

(statearr_19268_19301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (13))){
var inst_19251 = cljs.core.async.close_BANG_.call(null,out);
var state_19262__$1 = state_19262;
var statearr_19269_19302 = state_19262__$1;
(statearr_19269_19302[(2)] = inst_19251);

(statearr_19269_19302[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (6))){
var state_19262__$1 = state_19262;
var statearr_19270_19303 = state_19262__$1;
(statearr_19270_19303[(2)] = null);

(statearr_19270_19303[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (3))){
var inst_19260 = (state_19262[(2)]);
var state_19262__$1 = state_19262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19262__$1,inst_19260);
} else {
if((state_val_19263 === (12))){
var inst_19248 = (state_19262[(8)]);
var inst_19248__$1 = (state_19262[(2)]);
var inst_19249 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19248__$1);
var state_19262__$1 = (function (){var statearr_19271 = state_19262;
(statearr_19271[(8)] = inst_19248__$1);

return statearr_19271;
})();
if(cljs.core.truth_(inst_19249)){
var statearr_19272_19304 = state_19262__$1;
(statearr_19272_19304[(1)] = (13));

} else {
var statearr_19273_19305 = state_19262__$1;
(statearr_19273_19305[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (2))){
var inst_19225 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19226 = (0);
var state_19262__$1 = (function (){var statearr_19274 = state_19262;
(statearr_19274[(7)] = inst_19226);

(statearr_19274[(9)] = inst_19225);

return statearr_19274;
})();
var statearr_19275_19306 = state_19262__$1;
(statearr_19275_19306[(2)] = null);

(statearr_19275_19306[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (11))){
var inst_19226 = (state_19262[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19262,(10),Object,null,(9));
var inst_19235 = chs__$1.call(null,inst_19226);
var inst_19236 = done.call(null,inst_19226);
var inst_19237 = cljs.core.async.take_BANG_.call(null,inst_19235,inst_19236);
var state_19262__$1 = state_19262;
var statearr_19276_19307 = state_19262__$1;
(statearr_19276_19307[(2)] = inst_19237);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19262__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (9))){
var inst_19226 = (state_19262[(7)]);
var inst_19239 = (state_19262[(2)]);
var inst_19240 = (inst_19226 + (1));
var inst_19226__$1 = inst_19240;
var state_19262__$1 = (function (){var statearr_19277 = state_19262;
(statearr_19277[(7)] = inst_19226__$1);

(statearr_19277[(10)] = inst_19239);

return statearr_19277;
})();
var statearr_19278_19308 = state_19262__$1;
(statearr_19278_19308[(2)] = null);

(statearr_19278_19308[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (5))){
var inst_19246 = (state_19262[(2)]);
var state_19262__$1 = (function (){var statearr_19279 = state_19262;
(statearr_19279[(11)] = inst_19246);

return statearr_19279;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19262__$1,(12),dchan);
} else {
if((state_val_19263 === (14))){
var inst_19248 = (state_19262[(8)]);
var inst_19253 = cljs.core.apply.call(null,f,inst_19248);
var state_19262__$1 = state_19262;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19262__$1,(16),out,inst_19253);
} else {
if((state_val_19263 === (16))){
var inst_19255 = (state_19262[(2)]);
var state_19262__$1 = (function (){var statearr_19280 = state_19262;
(statearr_19280[(12)] = inst_19255);

return statearr_19280;
})();
var statearr_19281_19309 = state_19262__$1;
(statearr_19281_19309[(2)] = null);

(statearr_19281_19309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (10))){
var inst_19230 = (state_19262[(2)]);
var inst_19231 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19262__$1 = (function (){var statearr_19282 = state_19262;
(statearr_19282[(13)] = inst_19230);

return statearr_19282;
})();
var statearr_19283_19310 = state_19262__$1;
(statearr_19283_19310[(2)] = inst_19231);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19262__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (8))){
var inst_19244 = (state_19262[(2)]);
var state_19262__$1 = state_19262;
var statearr_19284_19311 = state_19262__$1;
(statearr_19284_19311[(2)] = inst_19244);

(statearr_19284_19311[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19296,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19296,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19288 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19288[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19288[(1)] = (1));

return statearr_19288;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19262){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19289){if((e19289 instanceof Object)){
var ex__8254__auto__ = e19289;
var statearr_19290_19312 = state_19262;
(statearr_19290_19312[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19262);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19289;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19313 = state_19262;
state_19262 = G__19313;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19262){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19296,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19291 = f__8363__auto__.call(null);
(statearr_19291[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19296);

return statearr_19291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19296,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19315 = [];
var len__5726__auto___19371 = arguments.length;
var i__5727__auto___19372 = (0);
while(true){
if((i__5727__auto___19372 < len__5726__auto___19371)){
args19315.push((arguments[i__5727__auto___19372]));

var G__19373 = (i__5727__auto___19372 + (1));
i__5727__auto___19372 = G__19373;
continue;
} else {
}
break;
}

var G__19317 = args19315.length;
switch (G__19317) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19315.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19375 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19375,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19375,out){
return (function (state_19347){
var state_val_19348 = (state_19347[(1)]);
if((state_val_19348 === (7))){
var inst_19326 = (state_19347[(7)]);
var inst_19327 = (state_19347[(8)]);
var inst_19326__$1 = (state_19347[(2)]);
var inst_19327__$1 = cljs.core.nth.call(null,inst_19326__$1,(0),null);
var inst_19328 = cljs.core.nth.call(null,inst_19326__$1,(1),null);
var inst_19329 = (inst_19327__$1 == null);
var state_19347__$1 = (function (){var statearr_19349 = state_19347;
(statearr_19349[(7)] = inst_19326__$1);

(statearr_19349[(9)] = inst_19328);

(statearr_19349[(8)] = inst_19327__$1);

return statearr_19349;
})();
if(cljs.core.truth_(inst_19329)){
var statearr_19350_19376 = state_19347__$1;
(statearr_19350_19376[(1)] = (8));

} else {
var statearr_19351_19377 = state_19347__$1;
(statearr_19351_19377[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19348 === (1))){
var inst_19318 = cljs.core.vec.call(null,chs);
var inst_19319 = inst_19318;
var state_19347__$1 = (function (){var statearr_19352 = state_19347;
(statearr_19352[(10)] = inst_19319);

return statearr_19352;
})();
var statearr_19353_19378 = state_19347__$1;
(statearr_19353_19378[(2)] = null);

(statearr_19353_19378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19348 === (4))){
var inst_19319 = (state_19347[(10)]);
var state_19347__$1 = state_19347;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19347__$1,(7),inst_19319);
} else {
if((state_val_19348 === (6))){
var inst_19343 = (state_19347[(2)]);
var state_19347__$1 = state_19347;
var statearr_19354_19379 = state_19347__$1;
(statearr_19354_19379[(2)] = inst_19343);

(statearr_19354_19379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19348 === (3))){
var inst_19345 = (state_19347[(2)]);
var state_19347__$1 = state_19347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19347__$1,inst_19345);
} else {
if((state_val_19348 === (2))){
var inst_19319 = (state_19347[(10)]);
var inst_19321 = cljs.core.count.call(null,inst_19319);
var inst_19322 = (inst_19321 > (0));
var state_19347__$1 = state_19347;
if(cljs.core.truth_(inst_19322)){
var statearr_19356_19380 = state_19347__$1;
(statearr_19356_19380[(1)] = (4));

} else {
var statearr_19357_19381 = state_19347__$1;
(statearr_19357_19381[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19348 === (11))){
var inst_19319 = (state_19347[(10)]);
var inst_19336 = (state_19347[(2)]);
var tmp19355 = inst_19319;
var inst_19319__$1 = tmp19355;
var state_19347__$1 = (function (){var statearr_19358 = state_19347;
(statearr_19358[(11)] = inst_19336);

(statearr_19358[(10)] = inst_19319__$1);

return statearr_19358;
})();
var statearr_19359_19382 = state_19347__$1;
(statearr_19359_19382[(2)] = null);

(statearr_19359_19382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19348 === (9))){
var inst_19327 = (state_19347[(8)]);
var state_19347__$1 = state_19347;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19347__$1,(11),out,inst_19327);
} else {
if((state_val_19348 === (5))){
var inst_19341 = cljs.core.async.close_BANG_.call(null,out);
var state_19347__$1 = state_19347;
var statearr_19360_19383 = state_19347__$1;
(statearr_19360_19383[(2)] = inst_19341);

(statearr_19360_19383[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19348 === (10))){
var inst_19339 = (state_19347[(2)]);
var state_19347__$1 = state_19347;
var statearr_19361_19384 = state_19347__$1;
(statearr_19361_19384[(2)] = inst_19339);

(statearr_19361_19384[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19348 === (8))){
var inst_19326 = (state_19347[(7)]);
var inst_19319 = (state_19347[(10)]);
var inst_19328 = (state_19347[(9)]);
var inst_19327 = (state_19347[(8)]);
var inst_19331 = (function (){var cs = inst_19319;
var vec__19324 = inst_19326;
var v = inst_19327;
var c = inst_19328;
return ((function (cs,vec__19324,v,c,inst_19326,inst_19319,inst_19328,inst_19327,state_val_19348,c__8362__auto___19375,out){
return (function (p1__19314_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19314_SHARP_);
});
;})(cs,vec__19324,v,c,inst_19326,inst_19319,inst_19328,inst_19327,state_val_19348,c__8362__auto___19375,out))
})();
var inst_19332 = cljs.core.filterv.call(null,inst_19331,inst_19319);
var inst_19319__$1 = inst_19332;
var state_19347__$1 = (function (){var statearr_19362 = state_19347;
(statearr_19362[(10)] = inst_19319__$1);

return statearr_19362;
})();
var statearr_19363_19385 = state_19347__$1;
(statearr_19363_19385[(2)] = null);

(statearr_19363_19385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19375,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19375,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19367 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19367[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19367[(1)] = (1));

return statearr_19367;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19347){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19368){if((e19368 instanceof Object)){
var ex__8254__auto__ = e19368;
var statearr_19369_19386 = state_19347;
(statearr_19369_19386[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19347);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19368;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19387 = state_19347;
state_19347 = G__19387;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19347){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19375,out))
})();
var state__8364__auto__ = (function (){var statearr_19370 = f__8363__auto__.call(null);
(statearr_19370[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19375);

return statearr_19370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19375,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19388 = [];
var len__5726__auto___19437 = arguments.length;
var i__5727__auto___19438 = (0);
while(true){
if((i__5727__auto___19438 < len__5726__auto___19437)){
args19388.push((arguments[i__5727__auto___19438]));

var G__19439 = (i__5727__auto___19438 + (1));
i__5727__auto___19438 = G__19439;
continue;
} else {
}
break;
}

var G__19390 = args19388.length;
switch (G__19390) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19388.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19441 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19441,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19441,out){
return (function (state_19414){
var state_val_19415 = (state_19414[(1)]);
if((state_val_19415 === (7))){
var inst_19396 = (state_19414[(7)]);
var inst_19396__$1 = (state_19414[(2)]);
var inst_19397 = (inst_19396__$1 == null);
var inst_19398 = cljs.core.not.call(null,inst_19397);
var state_19414__$1 = (function (){var statearr_19416 = state_19414;
(statearr_19416[(7)] = inst_19396__$1);

return statearr_19416;
})();
if(inst_19398){
var statearr_19417_19442 = state_19414__$1;
(statearr_19417_19442[(1)] = (8));

} else {
var statearr_19418_19443 = state_19414__$1;
(statearr_19418_19443[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19415 === (1))){
var inst_19391 = (0);
var state_19414__$1 = (function (){var statearr_19419 = state_19414;
(statearr_19419[(8)] = inst_19391);

return statearr_19419;
})();
var statearr_19420_19444 = state_19414__$1;
(statearr_19420_19444[(2)] = null);

(statearr_19420_19444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19415 === (4))){
var state_19414__$1 = state_19414;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19414__$1,(7),ch);
} else {
if((state_val_19415 === (6))){
var inst_19409 = (state_19414[(2)]);
var state_19414__$1 = state_19414;
var statearr_19421_19445 = state_19414__$1;
(statearr_19421_19445[(2)] = inst_19409);

(statearr_19421_19445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19415 === (3))){
var inst_19411 = (state_19414[(2)]);
var inst_19412 = cljs.core.async.close_BANG_.call(null,out);
var state_19414__$1 = (function (){var statearr_19422 = state_19414;
(statearr_19422[(9)] = inst_19411);

return statearr_19422;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19414__$1,inst_19412);
} else {
if((state_val_19415 === (2))){
var inst_19391 = (state_19414[(8)]);
var inst_19393 = (inst_19391 < n);
var state_19414__$1 = state_19414;
if(cljs.core.truth_(inst_19393)){
var statearr_19423_19446 = state_19414__$1;
(statearr_19423_19446[(1)] = (4));

} else {
var statearr_19424_19447 = state_19414__$1;
(statearr_19424_19447[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19415 === (11))){
var inst_19391 = (state_19414[(8)]);
var inst_19401 = (state_19414[(2)]);
var inst_19402 = (inst_19391 + (1));
var inst_19391__$1 = inst_19402;
var state_19414__$1 = (function (){var statearr_19425 = state_19414;
(statearr_19425[(8)] = inst_19391__$1);

(statearr_19425[(10)] = inst_19401);

return statearr_19425;
})();
var statearr_19426_19448 = state_19414__$1;
(statearr_19426_19448[(2)] = null);

(statearr_19426_19448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19415 === (9))){
var state_19414__$1 = state_19414;
var statearr_19427_19449 = state_19414__$1;
(statearr_19427_19449[(2)] = null);

(statearr_19427_19449[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19415 === (5))){
var state_19414__$1 = state_19414;
var statearr_19428_19450 = state_19414__$1;
(statearr_19428_19450[(2)] = null);

(statearr_19428_19450[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19415 === (10))){
var inst_19406 = (state_19414[(2)]);
var state_19414__$1 = state_19414;
var statearr_19429_19451 = state_19414__$1;
(statearr_19429_19451[(2)] = inst_19406);

(statearr_19429_19451[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19415 === (8))){
var inst_19396 = (state_19414[(7)]);
var state_19414__$1 = state_19414;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19414__$1,(11),out,inst_19396);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19441,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19441,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19433 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19433[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19433[(1)] = (1));

return statearr_19433;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19414){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19414);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19434){if((e19434 instanceof Object)){
var ex__8254__auto__ = e19434;
var statearr_19435_19452 = state_19414;
(statearr_19435_19452[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19414);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19453 = state_19414;
state_19414 = G__19453;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19414){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19441,out))
})();
var state__8364__auto__ = (function (){var statearr_19436 = f__8363__auto__.call(null);
(statearr_19436[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19441);

return statearr_19436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19441,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19461 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19461 = (function (map_LT_,f,ch,meta19462){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19462 = meta19462;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19463,meta19462__$1){
var self__ = this;
var _19463__$1 = this;
return (new cljs.core.async.t_cljs$core$async19461(self__.map_LT_,self__.f,self__.ch,meta19462__$1));
});

cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19463){
var self__ = this;
var _19463__$1 = this;
return self__.meta19462;
});

cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19464 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19464 = (function (map_LT_,f,ch,meta19462,_,fn1,meta19465){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19462 = meta19462;
this._ = _;
this.fn1 = fn1;
this.meta19465 = meta19465;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19464.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19466,meta19465__$1){
var self__ = this;
var _19466__$1 = this;
return (new cljs.core.async.t_cljs$core$async19464(self__.map_LT_,self__.f,self__.ch,self__.meta19462,self__._,self__.fn1,meta19465__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19464.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19466){
var self__ = this;
var _19466__$1 = this;
return self__.meta19465;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19464.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19464.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19464.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19464.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19454_SHARP_){
return f1.call(null,(((p1__19454_SHARP_ == null))?null:self__.f.call(null,p1__19454_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19464.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19462","meta19462",434916956,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19461","cljs.core.async/t_cljs$core$async19461",634679775,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19465","meta19465",537698019,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19464.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19464.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19464";

cljs.core.async.t_cljs$core$async19464.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19464");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19464 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19464(map_LT___$1,f__$1,ch__$1,meta19462__$1,___$2,fn1__$1,meta19465){
return (new cljs.core.async.t_cljs$core$async19464(map_LT___$1,f__$1,ch__$1,meta19462__$1,___$2,fn1__$1,meta19465));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19464(self__.map_LT_,self__.f,self__.ch,self__.meta19462,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19461.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19461.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19462","meta19462",434916956,null)], null);
});

cljs.core.async.t_cljs$core$async19461.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19461.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19461";

cljs.core.async.t_cljs$core$async19461.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19461");
});

cljs.core.async.__GT_t_cljs$core$async19461 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19461(map_LT___$1,f__$1,ch__$1,meta19462){
return (new cljs.core.async.t_cljs$core$async19461(map_LT___$1,f__$1,ch__$1,meta19462));
});

}

return (new cljs.core.async.t_cljs$core$async19461(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19470 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19470 = (function (map_GT_,f,ch,meta19471){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19471 = meta19471;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19470.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19472,meta19471__$1){
var self__ = this;
var _19472__$1 = this;
return (new cljs.core.async.t_cljs$core$async19470(self__.map_GT_,self__.f,self__.ch,meta19471__$1));
});

cljs.core.async.t_cljs$core$async19470.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19472){
var self__ = this;
var _19472__$1 = this;
return self__.meta19471;
});

cljs.core.async.t_cljs$core$async19470.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19470.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19470.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19470.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19470.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19470.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19470.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19471","meta19471",-1029932505,null)], null);
});

cljs.core.async.t_cljs$core$async19470.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19470.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19470";

cljs.core.async.t_cljs$core$async19470.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19470");
});

cljs.core.async.__GT_t_cljs$core$async19470 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19470(map_GT___$1,f__$1,ch__$1,meta19471){
return (new cljs.core.async.t_cljs$core$async19470(map_GT___$1,f__$1,ch__$1,meta19471));
});

}

return (new cljs.core.async.t_cljs$core$async19470(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19476 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19476 = (function (filter_GT_,p,ch,meta19477){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19477 = meta19477;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19478,meta19477__$1){
var self__ = this;
var _19478__$1 = this;
return (new cljs.core.async.t_cljs$core$async19476(self__.filter_GT_,self__.p,self__.ch,meta19477__$1));
});

cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19478){
var self__ = this;
var _19478__$1 = this;
return self__.meta19477;
});

cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19476.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19476.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19477","meta19477",593472553,null)], null);
});

cljs.core.async.t_cljs$core$async19476.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19476.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19476";

cljs.core.async.t_cljs$core$async19476.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19476");
});

cljs.core.async.__GT_t_cljs$core$async19476 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19476(filter_GT___$1,p__$1,ch__$1,meta19477){
return (new cljs.core.async.t_cljs$core$async19476(filter_GT___$1,p__$1,ch__$1,meta19477));
});

}

return (new cljs.core.async.t_cljs$core$async19476(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19479 = [];
var len__5726__auto___19523 = arguments.length;
var i__5727__auto___19524 = (0);
while(true){
if((i__5727__auto___19524 < len__5726__auto___19523)){
args19479.push((arguments[i__5727__auto___19524]));

var G__19525 = (i__5727__auto___19524 + (1));
i__5727__auto___19524 = G__19525;
continue;
} else {
}
break;
}

var G__19481 = args19479.length;
switch (G__19481) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19479.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19527 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19527,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19527,out){
return (function (state_19502){
var state_val_19503 = (state_19502[(1)]);
if((state_val_19503 === (7))){
var inst_19498 = (state_19502[(2)]);
var state_19502__$1 = state_19502;
var statearr_19504_19528 = state_19502__$1;
(statearr_19504_19528[(2)] = inst_19498);

(statearr_19504_19528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19503 === (1))){
var state_19502__$1 = state_19502;
var statearr_19505_19529 = state_19502__$1;
(statearr_19505_19529[(2)] = null);

(statearr_19505_19529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19503 === (4))){
var inst_19484 = (state_19502[(7)]);
var inst_19484__$1 = (state_19502[(2)]);
var inst_19485 = (inst_19484__$1 == null);
var state_19502__$1 = (function (){var statearr_19506 = state_19502;
(statearr_19506[(7)] = inst_19484__$1);

return statearr_19506;
})();
if(cljs.core.truth_(inst_19485)){
var statearr_19507_19530 = state_19502__$1;
(statearr_19507_19530[(1)] = (5));

} else {
var statearr_19508_19531 = state_19502__$1;
(statearr_19508_19531[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19503 === (6))){
var inst_19484 = (state_19502[(7)]);
var inst_19489 = p.call(null,inst_19484);
var state_19502__$1 = state_19502;
if(cljs.core.truth_(inst_19489)){
var statearr_19509_19532 = state_19502__$1;
(statearr_19509_19532[(1)] = (8));

} else {
var statearr_19510_19533 = state_19502__$1;
(statearr_19510_19533[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19503 === (3))){
var inst_19500 = (state_19502[(2)]);
var state_19502__$1 = state_19502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19502__$1,inst_19500);
} else {
if((state_val_19503 === (2))){
var state_19502__$1 = state_19502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19502__$1,(4),ch);
} else {
if((state_val_19503 === (11))){
var inst_19492 = (state_19502[(2)]);
var state_19502__$1 = state_19502;
var statearr_19511_19534 = state_19502__$1;
(statearr_19511_19534[(2)] = inst_19492);

(statearr_19511_19534[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19503 === (9))){
var state_19502__$1 = state_19502;
var statearr_19512_19535 = state_19502__$1;
(statearr_19512_19535[(2)] = null);

(statearr_19512_19535[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19503 === (5))){
var inst_19487 = cljs.core.async.close_BANG_.call(null,out);
var state_19502__$1 = state_19502;
var statearr_19513_19536 = state_19502__$1;
(statearr_19513_19536[(2)] = inst_19487);

(statearr_19513_19536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19503 === (10))){
var inst_19495 = (state_19502[(2)]);
var state_19502__$1 = (function (){var statearr_19514 = state_19502;
(statearr_19514[(8)] = inst_19495);

return statearr_19514;
})();
var statearr_19515_19537 = state_19502__$1;
(statearr_19515_19537[(2)] = null);

(statearr_19515_19537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19503 === (8))){
var inst_19484 = (state_19502[(7)]);
var state_19502__$1 = state_19502;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19502__$1,(11),out,inst_19484);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19527,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19527,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19519 = [null,null,null,null,null,null,null,null,null];
(statearr_19519[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19519[(1)] = (1));

return statearr_19519;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19502){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19520){if((e19520 instanceof Object)){
var ex__8254__auto__ = e19520;
var statearr_19521_19538 = state_19502;
(statearr_19521_19538[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19502);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19520;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19539 = state_19502;
state_19502 = G__19539;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19502){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19527,out))
})();
var state__8364__auto__ = (function (){var statearr_19522 = f__8363__auto__.call(null);
(statearr_19522[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19527);

return statearr_19522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19527,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19540 = [];
var len__5726__auto___19543 = arguments.length;
var i__5727__auto___19544 = (0);
while(true){
if((i__5727__auto___19544 < len__5726__auto___19543)){
args19540.push((arguments[i__5727__auto___19544]));

var G__19545 = (i__5727__auto___19544 + (1));
i__5727__auto___19544 = G__19545;
continue;
} else {
}
break;
}

var G__19542 = args19540.length;
switch (G__19542) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19540.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19712){
var state_val_19713 = (state_19712[(1)]);
if((state_val_19713 === (7))){
var inst_19708 = (state_19712[(2)]);
var state_19712__$1 = state_19712;
var statearr_19714_19755 = state_19712__$1;
(statearr_19714_19755[(2)] = inst_19708);

(statearr_19714_19755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (20))){
var inst_19678 = (state_19712[(7)]);
var inst_19689 = (state_19712[(2)]);
var inst_19690 = cljs.core.next.call(null,inst_19678);
var inst_19664 = inst_19690;
var inst_19665 = null;
var inst_19666 = (0);
var inst_19667 = (0);
var state_19712__$1 = (function (){var statearr_19715 = state_19712;
(statearr_19715[(8)] = inst_19667);

(statearr_19715[(9)] = inst_19689);

(statearr_19715[(10)] = inst_19666);

(statearr_19715[(11)] = inst_19665);

(statearr_19715[(12)] = inst_19664);

return statearr_19715;
})();
var statearr_19716_19756 = state_19712__$1;
(statearr_19716_19756[(2)] = null);

(statearr_19716_19756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (1))){
var state_19712__$1 = state_19712;
var statearr_19717_19757 = state_19712__$1;
(statearr_19717_19757[(2)] = null);

(statearr_19717_19757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (4))){
var inst_19653 = (state_19712[(13)]);
var inst_19653__$1 = (state_19712[(2)]);
var inst_19654 = (inst_19653__$1 == null);
var state_19712__$1 = (function (){var statearr_19718 = state_19712;
(statearr_19718[(13)] = inst_19653__$1);

return statearr_19718;
})();
if(cljs.core.truth_(inst_19654)){
var statearr_19719_19758 = state_19712__$1;
(statearr_19719_19758[(1)] = (5));

} else {
var statearr_19720_19759 = state_19712__$1;
(statearr_19720_19759[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (15))){
var state_19712__$1 = state_19712;
var statearr_19724_19760 = state_19712__$1;
(statearr_19724_19760[(2)] = null);

(statearr_19724_19760[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (21))){
var state_19712__$1 = state_19712;
var statearr_19725_19761 = state_19712__$1;
(statearr_19725_19761[(2)] = null);

(statearr_19725_19761[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (13))){
var inst_19667 = (state_19712[(8)]);
var inst_19666 = (state_19712[(10)]);
var inst_19665 = (state_19712[(11)]);
var inst_19664 = (state_19712[(12)]);
var inst_19674 = (state_19712[(2)]);
var inst_19675 = (inst_19667 + (1));
var tmp19721 = inst_19666;
var tmp19722 = inst_19665;
var tmp19723 = inst_19664;
var inst_19664__$1 = tmp19723;
var inst_19665__$1 = tmp19722;
var inst_19666__$1 = tmp19721;
var inst_19667__$1 = inst_19675;
var state_19712__$1 = (function (){var statearr_19726 = state_19712;
(statearr_19726[(8)] = inst_19667__$1);

(statearr_19726[(10)] = inst_19666__$1);

(statearr_19726[(11)] = inst_19665__$1);

(statearr_19726[(12)] = inst_19664__$1);

(statearr_19726[(14)] = inst_19674);

return statearr_19726;
})();
var statearr_19727_19762 = state_19712__$1;
(statearr_19727_19762[(2)] = null);

(statearr_19727_19762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (22))){
var state_19712__$1 = state_19712;
var statearr_19728_19763 = state_19712__$1;
(statearr_19728_19763[(2)] = null);

(statearr_19728_19763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (6))){
var inst_19653 = (state_19712[(13)]);
var inst_19662 = f.call(null,inst_19653);
var inst_19663 = cljs.core.seq.call(null,inst_19662);
var inst_19664 = inst_19663;
var inst_19665 = null;
var inst_19666 = (0);
var inst_19667 = (0);
var state_19712__$1 = (function (){var statearr_19729 = state_19712;
(statearr_19729[(8)] = inst_19667);

(statearr_19729[(10)] = inst_19666);

(statearr_19729[(11)] = inst_19665);

(statearr_19729[(12)] = inst_19664);

return statearr_19729;
})();
var statearr_19730_19764 = state_19712__$1;
(statearr_19730_19764[(2)] = null);

(statearr_19730_19764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (17))){
var inst_19678 = (state_19712[(7)]);
var inst_19682 = cljs.core.chunk_first.call(null,inst_19678);
var inst_19683 = cljs.core.chunk_rest.call(null,inst_19678);
var inst_19684 = cljs.core.count.call(null,inst_19682);
var inst_19664 = inst_19683;
var inst_19665 = inst_19682;
var inst_19666 = inst_19684;
var inst_19667 = (0);
var state_19712__$1 = (function (){var statearr_19731 = state_19712;
(statearr_19731[(8)] = inst_19667);

(statearr_19731[(10)] = inst_19666);

(statearr_19731[(11)] = inst_19665);

(statearr_19731[(12)] = inst_19664);

return statearr_19731;
})();
var statearr_19732_19765 = state_19712__$1;
(statearr_19732_19765[(2)] = null);

(statearr_19732_19765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (3))){
var inst_19710 = (state_19712[(2)]);
var state_19712__$1 = state_19712;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19712__$1,inst_19710);
} else {
if((state_val_19713 === (12))){
var inst_19698 = (state_19712[(2)]);
var state_19712__$1 = state_19712;
var statearr_19733_19766 = state_19712__$1;
(statearr_19733_19766[(2)] = inst_19698);

(statearr_19733_19766[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (2))){
var state_19712__$1 = state_19712;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19712__$1,(4),in$);
} else {
if((state_val_19713 === (23))){
var inst_19706 = (state_19712[(2)]);
var state_19712__$1 = state_19712;
var statearr_19734_19767 = state_19712__$1;
(statearr_19734_19767[(2)] = inst_19706);

(statearr_19734_19767[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (19))){
var inst_19693 = (state_19712[(2)]);
var state_19712__$1 = state_19712;
var statearr_19735_19768 = state_19712__$1;
(statearr_19735_19768[(2)] = inst_19693);

(statearr_19735_19768[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (11))){
var inst_19678 = (state_19712[(7)]);
var inst_19664 = (state_19712[(12)]);
var inst_19678__$1 = cljs.core.seq.call(null,inst_19664);
var state_19712__$1 = (function (){var statearr_19736 = state_19712;
(statearr_19736[(7)] = inst_19678__$1);

return statearr_19736;
})();
if(inst_19678__$1){
var statearr_19737_19769 = state_19712__$1;
(statearr_19737_19769[(1)] = (14));

} else {
var statearr_19738_19770 = state_19712__$1;
(statearr_19738_19770[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (9))){
var inst_19700 = (state_19712[(2)]);
var inst_19701 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19712__$1 = (function (){var statearr_19739 = state_19712;
(statearr_19739[(15)] = inst_19700);

return statearr_19739;
})();
if(cljs.core.truth_(inst_19701)){
var statearr_19740_19771 = state_19712__$1;
(statearr_19740_19771[(1)] = (21));

} else {
var statearr_19741_19772 = state_19712__$1;
(statearr_19741_19772[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (5))){
var inst_19656 = cljs.core.async.close_BANG_.call(null,out);
var state_19712__$1 = state_19712;
var statearr_19742_19773 = state_19712__$1;
(statearr_19742_19773[(2)] = inst_19656);

(statearr_19742_19773[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (14))){
var inst_19678 = (state_19712[(7)]);
var inst_19680 = cljs.core.chunked_seq_QMARK_.call(null,inst_19678);
var state_19712__$1 = state_19712;
if(inst_19680){
var statearr_19743_19774 = state_19712__$1;
(statearr_19743_19774[(1)] = (17));

} else {
var statearr_19744_19775 = state_19712__$1;
(statearr_19744_19775[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (16))){
var inst_19696 = (state_19712[(2)]);
var state_19712__$1 = state_19712;
var statearr_19745_19776 = state_19712__$1;
(statearr_19745_19776[(2)] = inst_19696);

(statearr_19745_19776[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19713 === (10))){
var inst_19667 = (state_19712[(8)]);
var inst_19665 = (state_19712[(11)]);
var inst_19672 = cljs.core._nth.call(null,inst_19665,inst_19667);
var state_19712__$1 = state_19712;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19712__$1,(13),out,inst_19672);
} else {
if((state_val_19713 === (18))){
var inst_19678 = (state_19712[(7)]);
var inst_19687 = cljs.core.first.call(null,inst_19678);
var state_19712__$1 = state_19712;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19712__$1,(20),out,inst_19687);
} else {
if((state_val_19713 === (8))){
var inst_19667 = (state_19712[(8)]);
var inst_19666 = (state_19712[(10)]);
var inst_19669 = (inst_19667 < inst_19666);
var inst_19670 = inst_19669;
var state_19712__$1 = state_19712;
if(cljs.core.truth_(inst_19670)){
var statearr_19746_19777 = state_19712__$1;
(statearr_19746_19777[(1)] = (10));

} else {
var statearr_19747_19778 = state_19712__$1;
(statearr_19747_19778[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19751[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19751[(1)] = (1));

return statearr_19751;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19712){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19712);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19752){if((e19752 instanceof Object)){
var ex__8254__auto__ = e19752;
var statearr_19753_19779 = state_19712;
(statearr_19753_19779[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19712);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19752;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19780 = state_19712;
state_19712 = G__19780;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19712){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19754 = f__8363__auto__.call(null);
(statearr_19754[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19781 = [];
var len__5726__auto___19784 = arguments.length;
var i__5727__auto___19785 = (0);
while(true){
if((i__5727__auto___19785 < len__5726__auto___19784)){
args19781.push((arguments[i__5727__auto___19785]));

var G__19786 = (i__5727__auto___19785 + (1));
i__5727__auto___19785 = G__19786;
continue;
} else {
}
break;
}

var G__19783 = args19781.length;
switch (G__19783) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19781.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19788 = [];
var len__5726__auto___19791 = arguments.length;
var i__5727__auto___19792 = (0);
while(true){
if((i__5727__auto___19792 < len__5726__auto___19791)){
args19788.push((arguments[i__5727__auto___19792]));

var G__19793 = (i__5727__auto___19792 + (1));
i__5727__auto___19792 = G__19793;
continue;
} else {
}
break;
}

var G__19790 = args19788.length;
switch (G__19790) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19788.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19795 = [];
var len__5726__auto___19846 = arguments.length;
var i__5727__auto___19847 = (0);
while(true){
if((i__5727__auto___19847 < len__5726__auto___19846)){
args19795.push((arguments[i__5727__auto___19847]));

var G__19848 = (i__5727__auto___19847 + (1));
i__5727__auto___19847 = G__19848;
continue;
} else {
}
break;
}

var G__19797 = args19795.length;
switch (G__19797) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19795.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19850,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19850,out){
return (function (state_19821){
var state_val_19822 = (state_19821[(1)]);
if((state_val_19822 === (7))){
var inst_19816 = (state_19821[(2)]);
var state_19821__$1 = state_19821;
var statearr_19823_19851 = state_19821__$1;
(statearr_19823_19851[(2)] = inst_19816);

(statearr_19823_19851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (1))){
var inst_19798 = null;
var state_19821__$1 = (function (){var statearr_19824 = state_19821;
(statearr_19824[(7)] = inst_19798);

return statearr_19824;
})();
var statearr_19825_19852 = state_19821__$1;
(statearr_19825_19852[(2)] = null);

(statearr_19825_19852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (4))){
var inst_19801 = (state_19821[(8)]);
var inst_19801__$1 = (state_19821[(2)]);
var inst_19802 = (inst_19801__$1 == null);
var inst_19803 = cljs.core.not.call(null,inst_19802);
var state_19821__$1 = (function (){var statearr_19826 = state_19821;
(statearr_19826[(8)] = inst_19801__$1);

return statearr_19826;
})();
if(inst_19803){
var statearr_19827_19853 = state_19821__$1;
(statearr_19827_19853[(1)] = (5));

} else {
var statearr_19828_19854 = state_19821__$1;
(statearr_19828_19854[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (6))){
var state_19821__$1 = state_19821;
var statearr_19829_19855 = state_19821__$1;
(statearr_19829_19855[(2)] = null);

(statearr_19829_19855[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (3))){
var inst_19818 = (state_19821[(2)]);
var inst_19819 = cljs.core.async.close_BANG_.call(null,out);
var state_19821__$1 = (function (){var statearr_19830 = state_19821;
(statearr_19830[(9)] = inst_19818);

return statearr_19830;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19821__$1,inst_19819);
} else {
if((state_val_19822 === (2))){
var state_19821__$1 = state_19821;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19821__$1,(4),ch);
} else {
if((state_val_19822 === (11))){
var inst_19801 = (state_19821[(8)]);
var inst_19810 = (state_19821[(2)]);
var inst_19798 = inst_19801;
var state_19821__$1 = (function (){var statearr_19831 = state_19821;
(statearr_19831[(10)] = inst_19810);

(statearr_19831[(7)] = inst_19798);

return statearr_19831;
})();
var statearr_19832_19856 = state_19821__$1;
(statearr_19832_19856[(2)] = null);

(statearr_19832_19856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (9))){
var inst_19801 = (state_19821[(8)]);
var state_19821__$1 = state_19821;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19821__$1,(11),out,inst_19801);
} else {
if((state_val_19822 === (5))){
var inst_19801 = (state_19821[(8)]);
var inst_19798 = (state_19821[(7)]);
var inst_19805 = cljs.core._EQ_.call(null,inst_19801,inst_19798);
var state_19821__$1 = state_19821;
if(inst_19805){
var statearr_19834_19857 = state_19821__$1;
(statearr_19834_19857[(1)] = (8));

} else {
var statearr_19835_19858 = state_19821__$1;
(statearr_19835_19858[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (10))){
var inst_19813 = (state_19821[(2)]);
var state_19821__$1 = state_19821;
var statearr_19836_19859 = state_19821__$1;
(statearr_19836_19859[(2)] = inst_19813);

(statearr_19836_19859[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19822 === (8))){
var inst_19798 = (state_19821[(7)]);
var tmp19833 = inst_19798;
var inst_19798__$1 = tmp19833;
var state_19821__$1 = (function (){var statearr_19837 = state_19821;
(statearr_19837[(7)] = inst_19798__$1);

return statearr_19837;
})();
var statearr_19838_19860 = state_19821__$1;
(statearr_19838_19860[(2)] = null);

(statearr_19838_19860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19850,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19850,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19842 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19842[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19842[(1)] = (1));

return statearr_19842;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19821){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19821);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19843){if((e19843 instanceof Object)){
var ex__8254__auto__ = e19843;
var statearr_19844_19861 = state_19821;
(statearr_19844_19861[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19821);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19843;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19862 = state_19821;
state_19821 = G__19862;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19821){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19850,out))
})();
var state__8364__auto__ = (function (){var statearr_19845 = f__8363__auto__.call(null);
(statearr_19845[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19850);

return statearr_19845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19850,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19863 = [];
var len__5726__auto___19933 = arguments.length;
var i__5727__auto___19934 = (0);
while(true){
if((i__5727__auto___19934 < len__5726__auto___19933)){
args19863.push((arguments[i__5727__auto___19934]));

var G__19935 = (i__5727__auto___19934 + (1));
i__5727__auto___19934 = G__19935;
continue;
} else {
}
break;
}

var G__19865 = args19863.length;
switch (G__19865) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19863.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19937 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19937,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19937,out){
return (function (state_19903){
var state_val_19904 = (state_19903[(1)]);
if((state_val_19904 === (7))){
var inst_19899 = (state_19903[(2)]);
var state_19903__$1 = state_19903;
var statearr_19905_19938 = state_19903__$1;
(statearr_19905_19938[(2)] = inst_19899);

(statearr_19905_19938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (1))){
var inst_19866 = (new Array(n));
var inst_19867 = inst_19866;
var inst_19868 = (0);
var state_19903__$1 = (function (){var statearr_19906 = state_19903;
(statearr_19906[(7)] = inst_19867);

(statearr_19906[(8)] = inst_19868);

return statearr_19906;
})();
var statearr_19907_19939 = state_19903__$1;
(statearr_19907_19939[(2)] = null);

(statearr_19907_19939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (4))){
var inst_19871 = (state_19903[(9)]);
var inst_19871__$1 = (state_19903[(2)]);
var inst_19872 = (inst_19871__$1 == null);
var inst_19873 = cljs.core.not.call(null,inst_19872);
var state_19903__$1 = (function (){var statearr_19908 = state_19903;
(statearr_19908[(9)] = inst_19871__$1);

return statearr_19908;
})();
if(inst_19873){
var statearr_19909_19940 = state_19903__$1;
(statearr_19909_19940[(1)] = (5));

} else {
var statearr_19910_19941 = state_19903__$1;
(statearr_19910_19941[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (15))){
var inst_19893 = (state_19903[(2)]);
var state_19903__$1 = state_19903;
var statearr_19911_19942 = state_19903__$1;
(statearr_19911_19942[(2)] = inst_19893);

(statearr_19911_19942[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (13))){
var state_19903__$1 = state_19903;
var statearr_19912_19943 = state_19903__$1;
(statearr_19912_19943[(2)] = null);

(statearr_19912_19943[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (6))){
var inst_19868 = (state_19903[(8)]);
var inst_19889 = (inst_19868 > (0));
var state_19903__$1 = state_19903;
if(cljs.core.truth_(inst_19889)){
var statearr_19913_19944 = state_19903__$1;
(statearr_19913_19944[(1)] = (12));

} else {
var statearr_19914_19945 = state_19903__$1;
(statearr_19914_19945[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (3))){
var inst_19901 = (state_19903[(2)]);
var state_19903__$1 = state_19903;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19903__$1,inst_19901);
} else {
if((state_val_19904 === (12))){
var inst_19867 = (state_19903[(7)]);
var inst_19891 = cljs.core.vec.call(null,inst_19867);
var state_19903__$1 = state_19903;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19903__$1,(15),out,inst_19891);
} else {
if((state_val_19904 === (2))){
var state_19903__$1 = state_19903;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19903__$1,(4),ch);
} else {
if((state_val_19904 === (11))){
var inst_19883 = (state_19903[(2)]);
var inst_19884 = (new Array(n));
var inst_19867 = inst_19884;
var inst_19868 = (0);
var state_19903__$1 = (function (){var statearr_19915 = state_19903;
(statearr_19915[(10)] = inst_19883);

(statearr_19915[(7)] = inst_19867);

(statearr_19915[(8)] = inst_19868);

return statearr_19915;
})();
var statearr_19916_19946 = state_19903__$1;
(statearr_19916_19946[(2)] = null);

(statearr_19916_19946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (9))){
var inst_19867 = (state_19903[(7)]);
var inst_19881 = cljs.core.vec.call(null,inst_19867);
var state_19903__$1 = state_19903;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19903__$1,(11),out,inst_19881);
} else {
if((state_val_19904 === (5))){
var inst_19867 = (state_19903[(7)]);
var inst_19876 = (state_19903[(11)]);
var inst_19871 = (state_19903[(9)]);
var inst_19868 = (state_19903[(8)]);
var inst_19875 = (inst_19867[inst_19868] = inst_19871);
var inst_19876__$1 = (inst_19868 + (1));
var inst_19877 = (inst_19876__$1 < n);
var state_19903__$1 = (function (){var statearr_19917 = state_19903;
(statearr_19917[(11)] = inst_19876__$1);

(statearr_19917[(12)] = inst_19875);

return statearr_19917;
})();
if(cljs.core.truth_(inst_19877)){
var statearr_19918_19947 = state_19903__$1;
(statearr_19918_19947[(1)] = (8));

} else {
var statearr_19919_19948 = state_19903__$1;
(statearr_19919_19948[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (14))){
var inst_19896 = (state_19903[(2)]);
var inst_19897 = cljs.core.async.close_BANG_.call(null,out);
var state_19903__$1 = (function (){var statearr_19921 = state_19903;
(statearr_19921[(13)] = inst_19896);

return statearr_19921;
})();
var statearr_19922_19949 = state_19903__$1;
(statearr_19922_19949[(2)] = inst_19897);

(statearr_19922_19949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (10))){
var inst_19887 = (state_19903[(2)]);
var state_19903__$1 = state_19903;
var statearr_19923_19950 = state_19903__$1;
(statearr_19923_19950[(2)] = inst_19887);

(statearr_19923_19950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19904 === (8))){
var inst_19867 = (state_19903[(7)]);
var inst_19876 = (state_19903[(11)]);
var tmp19920 = inst_19867;
var inst_19867__$1 = tmp19920;
var inst_19868 = inst_19876;
var state_19903__$1 = (function (){var statearr_19924 = state_19903;
(statearr_19924[(7)] = inst_19867__$1);

(statearr_19924[(8)] = inst_19868);

return statearr_19924;
})();
var statearr_19925_19951 = state_19903__$1;
(statearr_19925_19951[(2)] = null);

(statearr_19925_19951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19937,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19937,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19929 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19929[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19929[(1)] = (1));

return statearr_19929;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19903){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19930){if((e19930 instanceof Object)){
var ex__8254__auto__ = e19930;
var statearr_19931_19952 = state_19903;
(statearr_19931_19952[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19903);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19930;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19953 = state_19903;
state_19903 = G__19953;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19903){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19937,out))
})();
var state__8364__auto__ = (function (){var statearr_19932 = f__8363__auto__.call(null);
(statearr_19932[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19937);

return statearr_19932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19937,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19954 = [];
var len__5726__auto___20028 = arguments.length;
var i__5727__auto___20029 = (0);
while(true){
if((i__5727__auto___20029 < len__5726__auto___20028)){
args19954.push((arguments[i__5727__auto___20029]));

var G__20030 = (i__5727__auto___20029 + (1));
i__5727__auto___20029 = G__20030;
continue;
} else {
}
break;
}

var G__19956 = args19954.length;
switch (G__19956) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19954.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20032 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20032,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20032,out){
return (function (state_19998){
var state_val_19999 = (state_19998[(1)]);
if((state_val_19999 === (7))){
var inst_19994 = (state_19998[(2)]);
var state_19998__$1 = state_19998;
var statearr_20000_20033 = state_19998__$1;
(statearr_20000_20033[(2)] = inst_19994);

(statearr_20000_20033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (1))){
var inst_19957 = [];
var inst_19958 = inst_19957;
var inst_19959 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19998__$1 = (function (){var statearr_20001 = state_19998;
(statearr_20001[(7)] = inst_19958);

(statearr_20001[(8)] = inst_19959);

return statearr_20001;
})();
var statearr_20002_20034 = state_19998__$1;
(statearr_20002_20034[(2)] = null);

(statearr_20002_20034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (4))){
var inst_19962 = (state_19998[(9)]);
var inst_19962__$1 = (state_19998[(2)]);
var inst_19963 = (inst_19962__$1 == null);
var inst_19964 = cljs.core.not.call(null,inst_19963);
var state_19998__$1 = (function (){var statearr_20003 = state_19998;
(statearr_20003[(9)] = inst_19962__$1);

return statearr_20003;
})();
if(inst_19964){
var statearr_20004_20035 = state_19998__$1;
(statearr_20004_20035[(1)] = (5));

} else {
var statearr_20005_20036 = state_19998__$1;
(statearr_20005_20036[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (15))){
var inst_19988 = (state_19998[(2)]);
var state_19998__$1 = state_19998;
var statearr_20006_20037 = state_19998__$1;
(statearr_20006_20037[(2)] = inst_19988);

(statearr_20006_20037[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (13))){
var state_19998__$1 = state_19998;
var statearr_20007_20038 = state_19998__$1;
(statearr_20007_20038[(2)] = null);

(statearr_20007_20038[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (6))){
var inst_19958 = (state_19998[(7)]);
var inst_19983 = inst_19958.length;
var inst_19984 = (inst_19983 > (0));
var state_19998__$1 = state_19998;
if(cljs.core.truth_(inst_19984)){
var statearr_20008_20039 = state_19998__$1;
(statearr_20008_20039[(1)] = (12));

} else {
var statearr_20009_20040 = state_19998__$1;
(statearr_20009_20040[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (3))){
var inst_19996 = (state_19998[(2)]);
var state_19998__$1 = state_19998;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19998__$1,inst_19996);
} else {
if((state_val_19999 === (12))){
var inst_19958 = (state_19998[(7)]);
var inst_19986 = cljs.core.vec.call(null,inst_19958);
var state_19998__$1 = state_19998;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19998__$1,(15),out,inst_19986);
} else {
if((state_val_19999 === (2))){
var state_19998__$1 = state_19998;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19998__$1,(4),ch);
} else {
if((state_val_19999 === (11))){
var inst_19966 = (state_19998[(10)]);
var inst_19962 = (state_19998[(9)]);
var inst_19976 = (state_19998[(2)]);
var inst_19977 = [];
var inst_19978 = inst_19977.push(inst_19962);
var inst_19958 = inst_19977;
var inst_19959 = inst_19966;
var state_19998__$1 = (function (){var statearr_20010 = state_19998;
(statearr_20010[(11)] = inst_19978);

(statearr_20010[(7)] = inst_19958);

(statearr_20010[(12)] = inst_19976);

(statearr_20010[(8)] = inst_19959);

return statearr_20010;
})();
var statearr_20011_20041 = state_19998__$1;
(statearr_20011_20041[(2)] = null);

(statearr_20011_20041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (9))){
var inst_19958 = (state_19998[(7)]);
var inst_19974 = cljs.core.vec.call(null,inst_19958);
var state_19998__$1 = state_19998;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19998__$1,(11),out,inst_19974);
} else {
if((state_val_19999 === (5))){
var inst_19966 = (state_19998[(10)]);
var inst_19962 = (state_19998[(9)]);
var inst_19959 = (state_19998[(8)]);
var inst_19966__$1 = f.call(null,inst_19962);
var inst_19967 = cljs.core._EQ_.call(null,inst_19966__$1,inst_19959);
var inst_19968 = cljs.core.keyword_identical_QMARK_.call(null,inst_19959,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19969 = (inst_19967) || (inst_19968);
var state_19998__$1 = (function (){var statearr_20012 = state_19998;
(statearr_20012[(10)] = inst_19966__$1);

return statearr_20012;
})();
if(cljs.core.truth_(inst_19969)){
var statearr_20013_20042 = state_19998__$1;
(statearr_20013_20042[(1)] = (8));

} else {
var statearr_20014_20043 = state_19998__$1;
(statearr_20014_20043[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (14))){
var inst_19991 = (state_19998[(2)]);
var inst_19992 = cljs.core.async.close_BANG_.call(null,out);
var state_19998__$1 = (function (){var statearr_20016 = state_19998;
(statearr_20016[(13)] = inst_19991);

return statearr_20016;
})();
var statearr_20017_20044 = state_19998__$1;
(statearr_20017_20044[(2)] = inst_19992);

(statearr_20017_20044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (10))){
var inst_19981 = (state_19998[(2)]);
var state_19998__$1 = state_19998;
var statearr_20018_20045 = state_19998__$1;
(statearr_20018_20045[(2)] = inst_19981);

(statearr_20018_20045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19999 === (8))){
var inst_19966 = (state_19998[(10)]);
var inst_19958 = (state_19998[(7)]);
var inst_19962 = (state_19998[(9)]);
var inst_19971 = inst_19958.push(inst_19962);
var tmp20015 = inst_19958;
var inst_19958__$1 = tmp20015;
var inst_19959 = inst_19966;
var state_19998__$1 = (function (){var statearr_20019 = state_19998;
(statearr_20019[(14)] = inst_19971);

(statearr_20019[(7)] = inst_19958__$1);

(statearr_20019[(8)] = inst_19959);

return statearr_20019;
})();
var statearr_20020_20046 = state_19998__$1;
(statearr_20020_20046[(2)] = null);

(statearr_20020_20046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20032,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20032,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_20024 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20024[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_20024[(1)] = (1));

return statearr_20024;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19998){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19998);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e20025){if((e20025 instanceof Object)){
var ex__8254__auto__ = e20025;
var statearr_20026_20047 = state_19998;
(statearr_20026_20047[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19998);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20025;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20048 = state_19998;
state_19998 = G__20048;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19998){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20032,out))
})();
var state__8364__auto__ = (function (){var statearr_20027 = f__8363__auto__.call(null);
(statearr_20027[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20032);

return statearr_20027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20032,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1458805214998