// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17306 = [];
var len__5726__auto___17312 = arguments.length;
var i__5727__auto___17313 = (0);
while(true){
if((i__5727__auto___17313 < len__5726__auto___17312)){
args17306.push((arguments[i__5727__auto___17313]));

var G__17314 = (i__5727__auto___17313 + (1));
i__5727__auto___17313 = G__17314;
continue;
} else {
}
break;
}

var G__17308 = args17306.length;
switch (G__17308) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17306.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17309 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17309 = (function (f,blockable,meta17310){
this.f = f;
this.blockable = blockable;
this.meta17310 = meta17310;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17309.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17311,meta17310__$1){
var self__ = this;
var _17311__$1 = this;
return (new cljs.core.async.t_cljs$core$async17309(self__.f,self__.blockable,meta17310__$1));
});

cljs.core.async.t_cljs$core$async17309.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17311){
var self__ = this;
var _17311__$1 = this;
return self__.meta17310;
});

cljs.core.async.t_cljs$core$async17309.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17309.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17309.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17309.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17309.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17310","meta17310",540768681,null)], null);
});

cljs.core.async.t_cljs$core$async17309.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17309.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17309";

cljs.core.async.t_cljs$core$async17309.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17309");
});

cljs.core.async.__GT_t_cljs$core$async17309 = (function cljs$core$async$__GT_t_cljs$core$async17309(f__$1,blockable__$1,meta17310){
return (new cljs.core.async.t_cljs$core$async17309(f__$1,blockable__$1,meta17310));
});

}

return (new cljs.core.async.t_cljs$core$async17309(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17318 = [];
var len__5726__auto___17321 = arguments.length;
var i__5727__auto___17322 = (0);
while(true){
if((i__5727__auto___17322 < len__5726__auto___17321)){
args17318.push((arguments[i__5727__auto___17322]));

var G__17323 = (i__5727__auto___17322 + (1));
i__5727__auto___17322 = G__17323;
continue;
} else {
}
break;
}

var G__17320 = args17318.length;
switch (G__17320) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17318.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17325 = [];
var len__5726__auto___17328 = arguments.length;
var i__5727__auto___17329 = (0);
while(true){
if((i__5727__auto___17329 < len__5726__auto___17328)){
args17325.push((arguments[i__5727__auto___17329]));

var G__17330 = (i__5727__auto___17329 + (1));
i__5727__auto___17329 = G__17330;
continue;
} else {
}
break;
}

var G__17327 = args17325.length;
switch (G__17327) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17325.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17332 = [];
var len__5726__auto___17335 = arguments.length;
var i__5727__auto___17336 = (0);
while(true){
if((i__5727__auto___17336 < len__5726__auto___17335)){
args17332.push((arguments[i__5727__auto___17336]));

var G__17337 = (i__5727__auto___17336 + (1));
i__5727__auto___17336 = G__17337;
continue;
} else {
}
break;
}

var G__17334 = args17332.length;
switch (G__17334) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17332.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17339 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17339);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17339,ret){
return (function (){
return fn1.call(null,val_17339);
});})(val_17339,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17340 = [];
var len__5726__auto___17343 = arguments.length;
var i__5727__auto___17344 = (0);
while(true){
if((i__5727__auto___17344 < len__5726__auto___17343)){
args17340.push((arguments[i__5727__auto___17344]));

var G__17345 = (i__5727__auto___17344 + (1));
i__5727__auto___17344 = G__17345;
continue;
} else {
}
break;
}

var G__17342 = args17340.length;
switch (G__17342) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17340.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17347 = n;
var x_17348 = (0);
while(true){
if((x_17348 < n__5571__auto___17347)){
(a[x_17348] = (0));

var G__17349 = (x_17348 + (1));
x_17348 = G__17349;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17350 = (i + (1));
i = G__17350;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17354 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17354 = (function (alt_flag,flag,meta17355){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17355 = meta17355;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17354.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17356,meta17355__$1){
var self__ = this;
var _17356__$1 = this;
return (new cljs.core.async.t_cljs$core$async17354(self__.alt_flag,self__.flag,meta17355__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17354.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17356){
var self__ = this;
var _17356__$1 = this;
return self__.meta17355;
});})(flag))
;

cljs.core.async.t_cljs$core$async17354.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17354.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17354.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17354.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17354.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17355","meta17355",727493309,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17354.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17354.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17354";

cljs.core.async.t_cljs$core$async17354.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17354");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17354 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17354(alt_flag__$1,flag__$1,meta17355){
return (new cljs.core.async.t_cljs$core$async17354(alt_flag__$1,flag__$1,meta17355));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17354(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17360 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17360 = (function (alt_handler,flag,cb,meta17361){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17361 = meta17361;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17360.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17362,meta17361__$1){
var self__ = this;
var _17362__$1 = this;
return (new cljs.core.async.t_cljs$core$async17360(self__.alt_handler,self__.flag,self__.cb,meta17361__$1));
});

cljs.core.async.t_cljs$core$async17360.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17362){
var self__ = this;
var _17362__$1 = this;
return self__.meta17361;
});

cljs.core.async.t_cljs$core$async17360.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17360.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17360.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17360.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17360.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17361","meta17361",2132382723,null)], null);
});

cljs.core.async.t_cljs$core$async17360.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17360.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17360";

cljs.core.async.t_cljs$core$async17360.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17360");
});

cljs.core.async.__GT_t_cljs$core$async17360 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17360(alt_handler__$1,flag__$1,cb__$1,meta17361){
return (new cljs.core.async.t_cljs$core$async17360(alt_handler__$1,flag__$1,cb__$1,meta17361));
});

}

return (new cljs.core.async.t_cljs$core$async17360(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17363_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17363_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17364_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17364_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17365 = (i + (1));
i = G__17365;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17371 = arguments.length;
var i__5727__auto___17372 = (0);
while(true){
if((i__5727__auto___17372 < len__5726__auto___17371)){
args__5733__auto__.push((arguments[i__5727__auto___17372]));

var G__17373 = (i__5727__auto___17372 + (1));
i__5727__auto___17372 = G__17373;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17368){
var map__17369 = p__17368;
var map__17369__$1 = ((((!((map__17369 == null)))?((((map__17369.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17369.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17369):map__17369);
var opts = map__17369__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17366){
var G__17367 = cljs.core.first.call(null,seq17366);
var seq17366__$1 = cljs.core.next.call(null,seq17366);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17367,seq17366__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17374 = [];
var len__5726__auto___17424 = arguments.length;
var i__5727__auto___17425 = (0);
while(true){
if((i__5727__auto___17425 < len__5726__auto___17424)){
args17374.push((arguments[i__5727__auto___17425]));

var G__17426 = (i__5727__auto___17425 + (1));
i__5727__auto___17425 = G__17426;
continue;
} else {
}
break;
}

var G__17376 = args17374.length;
switch (G__17376) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17374.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17428 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17428){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17428){
return (function (state_17400){
var state_val_17401 = (state_17400[(1)]);
if((state_val_17401 === (7))){
var inst_17396 = (state_17400[(2)]);
var state_17400__$1 = state_17400;
var statearr_17402_17429 = state_17400__$1;
(statearr_17402_17429[(2)] = inst_17396);

(statearr_17402_17429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (1))){
var state_17400__$1 = state_17400;
var statearr_17403_17430 = state_17400__$1;
(statearr_17403_17430[(2)] = null);

(statearr_17403_17430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (4))){
var inst_17379 = (state_17400[(7)]);
var inst_17379__$1 = (state_17400[(2)]);
var inst_17380 = (inst_17379__$1 == null);
var state_17400__$1 = (function (){var statearr_17404 = state_17400;
(statearr_17404[(7)] = inst_17379__$1);

return statearr_17404;
})();
if(cljs.core.truth_(inst_17380)){
var statearr_17405_17431 = state_17400__$1;
(statearr_17405_17431[(1)] = (5));

} else {
var statearr_17406_17432 = state_17400__$1;
(statearr_17406_17432[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (13))){
var state_17400__$1 = state_17400;
var statearr_17407_17433 = state_17400__$1;
(statearr_17407_17433[(2)] = null);

(statearr_17407_17433[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (6))){
var inst_17379 = (state_17400[(7)]);
var state_17400__$1 = state_17400;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17400__$1,(11),to,inst_17379);
} else {
if((state_val_17401 === (3))){
var inst_17398 = (state_17400[(2)]);
var state_17400__$1 = state_17400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17400__$1,inst_17398);
} else {
if((state_val_17401 === (12))){
var state_17400__$1 = state_17400;
var statearr_17408_17434 = state_17400__$1;
(statearr_17408_17434[(2)] = null);

(statearr_17408_17434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (2))){
var state_17400__$1 = state_17400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17400__$1,(4),from);
} else {
if((state_val_17401 === (11))){
var inst_17389 = (state_17400[(2)]);
var state_17400__$1 = state_17400;
if(cljs.core.truth_(inst_17389)){
var statearr_17409_17435 = state_17400__$1;
(statearr_17409_17435[(1)] = (12));

} else {
var statearr_17410_17436 = state_17400__$1;
(statearr_17410_17436[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (9))){
var state_17400__$1 = state_17400;
var statearr_17411_17437 = state_17400__$1;
(statearr_17411_17437[(2)] = null);

(statearr_17411_17437[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (5))){
var state_17400__$1 = state_17400;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17412_17438 = state_17400__$1;
(statearr_17412_17438[(1)] = (8));

} else {
var statearr_17413_17439 = state_17400__$1;
(statearr_17413_17439[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (14))){
var inst_17394 = (state_17400[(2)]);
var state_17400__$1 = state_17400;
var statearr_17414_17440 = state_17400__$1;
(statearr_17414_17440[(2)] = inst_17394);

(statearr_17414_17440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (10))){
var inst_17386 = (state_17400[(2)]);
var state_17400__$1 = state_17400;
var statearr_17415_17441 = state_17400__$1;
(statearr_17415_17441[(2)] = inst_17386);

(statearr_17415_17441[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17401 === (8))){
var inst_17383 = cljs.core.async.close_BANG_.call(null,to);
var state_17400__$1 = state_17400;
var statearr_17416_17442 = state_17400__$1;
(statearr_17416_17442[(2)] = inst_17383);

(statearr_17416_17442[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17428))
;
return ((function (switch__8250__auto__,c__8362__auto___17428){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17420 = [null,null,null,null,null,null,null,null];
(statearr_17420[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17420[(1)] = (1));

return statearr_17420;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17400){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17421){if((e17421 instanceof Object)){
var ex__8254__auto__ = e17421;
var statearr_17422_17443 = state_17400;
(statearr_17422_17443[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17400);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17421;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17444 = state_17400;
state_17400 = G__17444;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17400){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17428))
})();
var state__8364__auto__ = (function (){var statearr_17423 = f__8363__auto__.call(null);
(statearr_17423[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17428);

return statearr_17423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17428))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17628){
var vec__17629 = p__17628;
var v = cljs.core.nth.call(null,vec__17629,(0),null);
var p = cljs.core.nth.call(null,vec__17629,(1),null);
var job = vec__17629;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17811 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17811,res,vec__17629,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17811,res,vec__17629,v,p,job,jobs,results){
return (function (state_17634){
var state_val_17635 = (state_17634[(1)]);
if((state_val_17635 === (1))){
var state_17634__$1 = state_17634;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17634__$1,(2),res,v);
} else {
if((state_val_17635 === (2))){
var inst_17631 = (state_17634[(2)]);
var inst_17632 = cljs.core.async.close_BANG_.call(null,res);
var state_17634__$1 = (function (){var statearr_17636 = state_17634;
(statearr_17636[(7)] = inst_17631);

return statearr_17636;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17634__$1,inst_17632);
} else {
return null;
}
}
});})(c__8362__auto___17811,res,vec__17629,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17811,res,vec__17629,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17640 = [null,null,null,null,null,null,null,null];
(statearr_17640[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17640[(1)] = (1));

return statearr_17640;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17634){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17634);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17641){if((e17641 instanceof Object)){
var ex__8254__auto__ = e17641;
var statearr_17642_17812 = state_17634;
(statearr_17642_17812[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17634);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17641;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17813 = state_17634;
state_17634 = G__17813;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17634){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17811,res,vec__17629,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17643 = f__8363__auto__.call(null);
(statearr_17643[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17811);

return statearr_17643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17811,res,vec__17629,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17644){
var vec__17645 = p__17644;
var v = cljs.core.nth.call(null,vec__17645,(0),null);
var p = cljs.core.nth.call(null,vec__17645,(1),null);
var job = vec__17645;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17814 = n;
var __17815 = (0);
while(true){
if((__17815 < n__5571__auto___17814)){
var G__17646_17816 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17646_17816) {
case "compute":
var c__8362__auto___17818 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17815,c__8362__auto___17818,G__17646_17816,n__5571__auto___17814,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17815,c__8362__auto___17818,G__17646_17816,n__5571__auto___17814,jobs,results,process,async){
return (function (state_17659){
var state_val_17660 = (state_17659[(1)]);
if((state_val_17660 === (1))){
var state_17659__$1 = state_17659;
var statearr_17661_17819 = state_17659__$1;
(statearr_17661_17819[(2)] = null);

(statearr_17661_17819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17660 === (2))){
var state_17659__$1 = state_17659;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17659__$1,(4),jobs);
} else {
if((state_val_17660 === (3))){
var inst_17657 = (state_17659[(2)]);
var state_17659__$1 = state_17659;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17659__$1,inst_17657);
} else {
if((state_val_17660 === (4))){
var inst_17649 = (state_17659[(2)]);
var inst_17650 = process.call(null,inst_17649);
var state_17659__$1 = state_17659;
if(cljs.core.truth_(inst_17650)){
var statearr_17662_17820 = state_17659__$1;
(statearr_17662_17820[(1)] = (5));

} else {
var statearr_17663_17821 = state_17659__$1;
(statearr_17663_17821[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17660 === (5))){
var state_17659__$1 = state_17659;
var statearr_17664_17822 = state_17659__$1;
(statearr_17664_17822[(2)] = null);

(statearr_17664_17822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17660 === (6))){
var state_17659__$1 = state_17659;
var statearr_17665_17823 = state_17659__$1;
(statearr_17665_17823[(2)] = null);

(statearr_17665_17823[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17660 === (7))){
var inst_17655 = (state_17659[(2)]);
var state_17659__$1 = state_17659;
var statearr_17666_17824 = state_17659__$1;
(statearr_17666_17824[(2)] = inst_17655);

(statearr_17666_17824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17815,c__8362__auto___17818,G__17646_17816,n__5571__auto___17814,jobs,results,process,async))
;
return ((function (__17815,switch__8250__auto__,c__8362__auto___17818,G__17646_17816,n__5571__auto___17814,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17670 = [null,null,null,null,null,null,null];
(statearr_17670[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17670[(1)] = (1));

return statearr_17670;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17659){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17659);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17671){if((e17671 instanceof Object)){
var ex__8254__auto__ = e17671;
var statearr_17672_17825 = state_17659;
(statearr_17672_17825[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17659);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17671;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17826 = state_17659;
state_17659 = G__17826;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17659){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17815,switch__8250__auto__,c__8362__auto___17818,G__17646_17816,n__5571__auto___17814,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17673 = f__8363__auto__.call(null);
(statearr_17673[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17818);

return statearr_17673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17815,c__8362__auto___17818,G__17646_17816,n__5571__auto___17814,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17827 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17815,c__8362__auto___17827,G__17646_17816,n__5571__auto___17814,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17815,c__8362__auto___17827,G__17646_17816,n__5571__auto___17814,jobs,results,process,async){
return (function (state_17686){
var state_val_17687 = (state_17686[(1)]);
if((state_val_17687 === (1))){
var state_17686__$1 = state_17686;
var statearr_17688_17828 = state_17686__$1;
(statearr_17688_17828[(2)] = null);

(statearr_17688_17828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (2))){
var state_17686__$1 = state_17686;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17686__$1,(4),jobs);
} else {
if((state_val_17687 === (3))){
var inst_17684 = (state_17686[(2)]);
var state_17686__$1 = state_17686;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17686__$1,inst_17684);
} else {
if((state_val_17687 === (4))){
var inst_17676 = (state_17686[(2)]);
var inst_17677 = async.call(null,inst_17676);
var state_17686__$1 = state_17686;
if(cljs.core.truth_(inst_17677)){
var statearr_17689_17829 = state_17686__$1;
(statearr_17689_17829[(1)] = (5));

} else {
var statearr_17690_17830 = state_17686__$1;
(statearr_17690_17830[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (5))){
var state_17686__$1 = state_17686;
var statearr_17691_17831 = state_17686__$1;
(statearr_17691_17831[(2)] = null);

(statearr_17691_17831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (6))){
var state_17686__$1 = state_17686;
var statearr_17692_17832 = state_17686__$1;
(statearr_17692_17832[(2)] = null);

(statearr_17692_17832[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (7))){
var inst_17682 = (state_17686[(2)]);
var state_17686__$1 = state_17686;
var statearr_17693_17833 = state_17686__$1;
(statearr_17693_17833[(2)] = inst_17682);

(statearr_17693_17833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17815,c__8362__auto___17827,G__17646_17816,n__5571__auto___17814,jobs,results,process,async))
;
return ((function (__17815,switch__8250__auto__,c__8362__auto___17827,G__17646_17816,n__5571__auto___17814,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17697 = [null,null,null,null,null,null,null];
(statearr_17697[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17697[(1)] = (1));

return statearr_17697;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17686){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17698){if((e17698 instanceof Object)){
var ex__8254__auto__ = e17698;
var statearr_17699_17834 = state_17686;
(statearr_17699_17834[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17686);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17698;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17835 = state_17686;
state_17686 = G__17835;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17686){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17815,switch__8250__auto__,c__8362__auto___17827,G__17646_17816,n__5571__auto___17814,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17700 = f__8363__auto__.call(null);
(statearr_17700[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17827);

return statearr_17700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17815,c__8362__auto___17827,G__17646_17816,n__5571__auto___17814,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17836 = (__17815 + (1));
__17815 = G__17836;
continue;
} else {
}
break;
}

var c__8362__auto___17837 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17837,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17837,jobs,results,process,async){
return (function (state_17722){
var state_val_17723 = (state_17722[(1)]);
if((state_val_17723 === (1))){
var state_17722__$1 = state_17722;
var statearr_17724_17838 = state_17722__$1;
(statearr_17724_17838[(2)] = null);

(statearr_17724_17838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (2))){
var state_17722__$1 = state_17722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17722__$1,(4),from);
} else {
if((state_val_17723 === (3))){
var inst_17720 = (state_17722[(2)]);
var state_17722__$1 = state_17722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17722__$1,inst_17720);
} else {
if((state_val_17723 === (4))){
var inst_17703 = (state_17722[(7)]);
var inst_17703__$1 = (state_17722[(2)]);
var inst_17704 = (inst_17703__$1 == null);
var state_17722__$1 = (function (){var statearr_17725 = state_17722;
(statearr_17725[(7)] = inst_17703__$1);

return statearr_17725;
})();
if(cljs.core.truth_(inst_17704)){
var statearr_17726_17839 = state_17722__$1;
(statearr_17726_17839[(1)] = (5));

} else {
var statearr_17727_17840 = state_17722__$1;
(statearr_17727_17840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (5))){
var inst_17706 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17722__$1 = state_17722;
var statearr_17728_17841 = state_17722__$1;
(statearr_17728_17841[(2)] = inst_17706);

(statearr_17728_17841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (6))){
var inst_17708 = (state_17722[(8)]);
var inst_17703 = (state_17722[(7)]);
var inst_17708__$1 = cljs.core.async.chan.call(null,(1));
var inst_17709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17710 = [inst_17703,inst_17708__$1];
var inst_17711 = (new cljs.core.PersistentVector(null,2,(5),inst_17709,inst_17710,null));
var state_17722__$1 = (function (){var statearr_17729 = state_17722;
(statearr_17729[(8)] = inst_17708__$1);

return statearr_17729;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17722__$1,(8),jobs,inst_17711);
} else {
if((state_val_17723 === (7))){
var inst_17718 = (state_17722[(2)]);
var state_17722__$1 = state_17722;
var statearr_17730_17842 = state_17722__$1;
(statearr_17730_17842[(2)] = inst_17718);

(statearr_17730_17842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17723 === (8))){
var inst_17708 = (state_17722[(8)]);
var inst_17713 = (state_17722[(2)]);
var state_17722__$1 = (function (){var statearr_17731 = state_17722;
(statearr_17731[(9)] = inst_17713);

return statearr_17731;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17722__$1,(9),results,inst_17708);
} else {
if((state_val_17723 === (9))){
var inst_17715 = (state_17722[(2)]);
var state_17722__$1 = (function (){var statearr_17732 = state_17722;
(statearr_17732[(10)] = inst_17715);

return statearr_17732;
})();
var statearr_17733_17843 = state_17722__$1;
(statearr_17733_17843[(2)] = null);

(statearr_17733_17843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17837,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17837,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17737 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17737[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17737[(1)] = (1));

return statearr_17737;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17722){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17738){if((e17738 instanceof Object)){
var ex__8254__auto__ = e17738;
var statearr_17739_17844 = state_17722;
(statearr_17739_17844[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17722);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17738;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17845 = state_17722;
state_17722 = G__17845;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17722){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17837,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17740 = f__8363__auto__.call(null);
(statearr_17740[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17837);

return statearr_17740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17837,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17778){
var state_val_17779 = (state_17778[(1)]);
if((state_val_17779 === (7))){
var inst_17774 = (state_17778[(2)]);
var state_17778__$1 = state_17778;
var statearr_17780_17846 = state_17778__$1;
(statearr_17780_17846[(2)] = inst_17774);

(statearr_17780_17846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (20))){
var state_17778__$1 = state_17778;
var statearr_17781_17847 = state_17778__$1;
(statearr_17781_17847[(2)] = null);

(statearr_17781_17847[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (1))){
var state_17778__$1 = state_17778;
var statearr_17782_17848 = state_17778__$1;
(statearr_17782_17848[(2)] = null);

(statearr_17782_17848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (4))){
var inst_17743 = (state_17778[(7)]);
var inst_17743__$1 = (state_17778[(2)]);
var inst_17744 = (inst_17743__$1 == null);
var state_17778__$1 = (function (){var statearr_17783 = state_17778;
(statearr_17783[(7)] = inst_17743__$1);

return statearr_17783;
})();
if(cljs.core.truth_(inst_17744)){
var statearr_17784_17849 = state_17778__$1;
(statearr_17784_17849[(1)] = (5));

} else {
var statearr_17785_17850 = state_17778__$1;
(statearr_17785_17850[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (15))){
var inst_17756 = (state_17778[(8)]);
var state_17778__$1 = state_17778;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17778__$1,(18),to,inst_17756);
} else {
if((state_val_17779 === (21))){
var inst_17769 = (state_17778[(2)]);
var state_17778__$1 = state_17778;
var statearr_17786_17851 = state_17778__$1;
(statearr_17786_17851[(2)] = inst_17769);

(statearr_17786_17851[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (13))){
var inst_17771 = (state_17778[(2)]);
var state_17778__$1 = (function (){var statearr_17787 = state_17778;
(statearr_17787[(9)] = inst_17771);

return statearr_17787;
})();
var statearr_17788_17852 = state_17778__$1;
(statearr_17788_17852[(2)] = null);

(statearr_17788_17852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (6))){
var inst_17743 = (state_17778[(7)]);
var state_17778__$1 = state_17778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17778__$1,(11),inst_17743);
} else {
if((state_val_17779 === (17))){
var inst_17764 = (state_17778[(2)]);
var state_17778__$1 = state_17778;
if(cljs.core.truth_(inst_17764)){
var statearr_17789_17853 = state_17778__$1;
(statearr_17789_17853[(1)] = (19));

} else {
var statearr_17790_17854 = state_17778__$1;
(statearr_17790_17854[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (3))){
var inst_17776 = (state_17778[(2)]);
var state_17778__$1 = state_17778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17778__$1,inst_17776);
} else {
if((state_val_17779 === (12))){
var inst_17753 = (state_17778[(10)]);
var state_17778__$1 = state_17778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17778__$1,(14),inst_17753);
} else {
if((state_val_17779 === (2))){
var state_17778__$1 = state_17778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17778__$1,(4),results);
} else {
if((state_val_17779 === (19))){
var state_17778__$1 = state_17778;
var statearr_17791_17855 = state_17778__$1;
(statearr_17791_17855[(2)] = null);

(statearr_17791_17855[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (11))){
var inst_17753 = (state_17778[(2)]);
var state_17778__$1 = (function (){var statearr_17792 = state_17778;
(statearr_17792[(10)] = inst_17753);

return statearr_17792;
})();
var statearr_17793_17856 = state_17778__$1;
(statearr_17793_17856[(2)] = null);

(statearr_17793_17856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (9))){
var state_17778__$1 = state_17778;
var statearr_17794_17857 = state_17778__$1;
(statearr_17794_17857[(2)] = null);

(statearr_17794_17857[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (5))){
var state_17778__$1 = state_17778;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17795_17858 = state_17778__$1;
(statearr_17795_17858[(1)] = (8));

} else {
var statearr_17796_17859 = state_17778__$1;
(statearr_17796_17859[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (14))){
var inst_17758 = (state_17778[(11)]);
var inst_17756 = (state_17778[(8)]);
var inst_17756__$1 = (state_17778[(2)]);
var inst_17757 = (inst_17756__$1 == null);
var inst_17758__$1 = cljs.core.not.call(null,inst_17757);
var state_17778__$1 = (function (){var statearr_17797 = state_17778;
(statearr_17797[(11)] = inst_17758__$1);

(statearr_17797[(8)] = inst_17756__$1);

return statearr_17797;
})();
if(inst_17758__$1){
var statearr_17798_17860 = state_17778__$1;
(statearr_17798_17860[(1)] = (15));

} else {
var statearr_17799_17861 = state_17778__$1;
(statearr_17799_17861[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (16))){
var inst_17758 = (state_17778[(11)]);
var state_17778__$1 = state_17778;
var statearr_17800_17862 = state_17778__$1;
(statearr_17800_17862[(2)] = inst_17758);

(statearr_17800_17862[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (10))){
var inst_17750 = (state_17778[(2)]);
var state_17778__$1 = state_17778;
var statearr_17801_17863 = state_17778__$1;
(statearr_17801_17863[(2)] = inst_17750);

(statearr_17801_17863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (18))){
var inst_17761 = (state_17778[(2)]);
var state_17778__$1 = state_17778;
var statearr_17802_17864 = state_17778__$1;
(statearr_17802_17864[(2)] = inst_17761);

(statearr_17802_17864[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17779 === (8))){
var inst_17747 = cljs.core.async.close_BANG_.call(null,to);
var state_17778__$1 = state_17778;
var statearr_17803_17865 = state_17778__$1;
(statearr_17803_17865[(2)] = inst_17747);

(statearr_17803_17865[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17807 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17807[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17807[(1)] = (1));

return statearr_17807;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17778){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17808){if((e17808 instanceof Object)){
var ex__8254__auto__ = e17808;
var statearr_17809_17866 = state_17778;
(statearr_17809_17866[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17808;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17867 = state_17778;
state_17778 = G__17867;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17778){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17810 = f__8363__auto__.call(null);
(statearr_17810[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17868 = [];
var len__5726__auto___17871 = arguments.length;
var i__5727__auto___17872 = (0);
while(true){
if((i__5727__auto___17872 < len__5726__auto___17871)){
args17868.push((arguments[i__5727__auto___17872]));

var G__17873 = (i__5727__auto___17872 + (1));
i__5727__auto___17872 = G__17873;
continue;
} else {
}
break;
}

var G__17870 = args17868.length;
switch (G__17870) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17868.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17875 = [];
var len__5726__auto___17878 = arguments.length;
var i__5727__auto___17879 = (0);
while(true){
if((i__5727__auto___17879 < len__5726__auto___17878)){
args17875.push((arguments[i__5727__auto___17879]));

var G__17880 = (i__5727__auto___17879 + (1));
i__5727__auto___17879 = G__17880;
continue;
} else {
}
break;
}

var G__17877 = args17875.length;
switch (G__17877) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17875.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17882 = [];
var len__5726__auto___17935 = arguments.length;
var i__5727__auto___17936 = (0);
while(true){
if((i__5727__auto___17936 < len__5726__auto___17935)){
args17882.push((arguments[i__5727__auto___17936]));

var G__17937 = (i__5727__auto___17936 + (1));
i__5727__auto___17936 = G__17937;
continue;
} else {
}
break;
}

var G__17884 = args17882.length;
switch (G__17884) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17882.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17939 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17939,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17939,tc,fc){
return (function (state_17910){
var state_val_17911 = (state_17910[(1)]);
if((state_val_17911 === (7))){
var inst_17906 = (state_17910[(2)]);
var state_17910__$1 = state_17910;
var statearr_17912_17940 = state_17910__$1;
(statearr_17912_17940[(2)] = inst_17906);

(statearr_17912_17940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (1))){
var state_17910__$1 = state_17910;
var statearr_17913_17941 = state_17910__$1;
(statearr_17913_17941[(2)] = null);

(statearr_17913_17941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (4))){
var inst_17887 = (state_17910[(7)]);
var inst_17887__$1 = (state_17910[(2)]);
var inst_17888 = (inst_17887__$1 == null);
var state_17910__$1 = (function (){var statearr_17914 = state_17910;
(statearr_17914[(7)] = inst_17887__$1);

return statearr_17914;
})();
if(cljs.core.truth_(inst_17888)){
var statearr_17915_17942 = state_17910__$1;
(statearr_17915_17942[(1)] = (5));

} else {
var statearr_17916_17943 = state_17910__$1;
(statearr_17916_17943[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (13))){
var state_17910__$1 = state_17910;
var statearr_17917_17944 = state_17910__$1;
(statearr_17917_17944[(2)] = null);

(statearr_17917_17944[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (6))){
var inst_17887 = (state_17910[(7)]);
var inst_17893 = p.call(null,inst_17887);
var state_17910__$1 = state_17910;
if(cljs.core.truth_(inst_17893)){
var statearr_17918_17945 = state_17910__$1;
(statearr_17918_17945[(1)] = (9));

} else {
var statearr_17919_17946 = state_17910__$1;
(statearr_17919_17946[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (3))){
var inst_17908 = (state_17910[(2)]);
var state_17910__$1 = state_17910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17910__$1,inst_17908);
} else {
if((state_val_17911 === (12))){
var state_17910__$1 = state_17910;
var statearr_17920_17947 = state_17910__$1;
(statearr_17920_17947[(2)] = null);

(statearr_17920_17947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (2))){
var state_17910__$1 = state_17910;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17910__$1,(4),ch);
} else {
if((state_val_17911 === (11))){
var inst_17887 = (state_17910[(7)]);
var inst_17897 = (state_17910[(2)]);
var state_17910__$1 = state_17910;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17910__$1,(8),inst_17897,inst_17887);
} else {
if((state_val_17911 === (9))){
var state_17910__$1 = state_17910;
var statearr_17921_17948 = state_17910__$1;
(statearr_17921_17948[(2)] = tc);

(statearr_17921_17948[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (5))){
var inst_17890 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17891 = cljs.core.async.close_BANG_.call(null,fc);
var state_17910__$1 = (function (){var statearr_17922 = state_17910;
(statearr_17922[(8)] = inst_17890);

return statearr_17922;
})();
var statearr_17923_17949 = state_17910__$1;
(statearr_17923_17949[(2)] = inst_17891);

(statearr_17923_17949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (14))){
var inst_17904 = (state_17910[(2)]);
var state_17910__$1 = state_17910;
var statearr_17924_17950 = state_17910__$1;
(statearr_17924_17950[(2)] = inst_17904);

(statearr_17924_17950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (10))){
var state_17910__$1 = state_17910;
var statearr_17925_17951 = state_17910__$1;
(statearr_17925_17951[(2)] = fc);

(statearr_17925_17951[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17911 === (8))){
var inst_17899 = (state_17910[(2)]);
var state_17910__$1 = state_17910;
if(cljs.core.truth_(inst_17899)){
var statearr_17926_17952 = state_17910__$1;
(statearr_17926_17952[(1)] = (12));

} else {
var statearr_17927_17953 = state_17910__$1;
(statearr_17927_17953[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17939,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17939,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17931 = [null,null,null,null,null,null,null,null,null];
(statearr_17931[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17931[(1)] = (1));

return statearr_17931;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17910){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17932){if((e17932 instanceof Object)){
var ex__8254__auto__ = e17932;
var statearr_17933_17954 = state_17910;
(statearr_17933_17954[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17910);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17932;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17955 = state_17910;
state_17910 = G__17955;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17910){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17939,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17934 = f__8363__auto__.call(null);
(statearr_17934[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17939);

return statearr_17934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17939,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18019){
var state_val_18020 = (state_18019[(1)]);
if((state_val_18020 === (7))){
var inst_18015 = (state_18019[(2)]);
var state_18019__$1 = state_18019;
var statearr_18021_18042 = state_18019__$1;
(statearr_18021_18042[(2)] = inst_18015);

(statearr_18021_18042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18020 === (1))){
var inst_17999 = init;
var state_18019__$1 = (function (){var statearr_18022 = state_18019;
(statearr_18022[(7)] = inst_17999);

return statearr_18022;
})();
var statearr_18023_18043 = state_18019__$1;
(statearr_18023_18043[(2)] = null);

(statearr_18023_18043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18020 === (4))){
var inst_18002 = (state_18019[(8)]);
var inst_18002__$1 = (state_18019[(2)]);
var inst_18003 = (inst_18002__$1 == null);
var state_18019__$1 = (function (){var statearr_18024 = state_18019;
(statearr_18024[(8)] = inst_18002__$1);

return statearr_18024;
})();
if(cljs.core.truth_(inst_18003)){
var statearr_18025_18044 = state_18019__$1;
(statearr_18025_18044[(1)] = (5));

} else {
var statearr_18026_18045 = state_18019__$1;
(statearr_18026_18045[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18020 === (6))){
var inst_17999 = (state_18019[(7)]);
var inst_18002 = (state_18019[(8)]);
var inst_18006 = (state_18019[(9)]);
var inst_18006__$1 = f.call(null,inst_17999,inst_18002);
var inst_18007 = cljs.core.reduced_QMARK_.call(null,inst_18006__$1);
var state_18019__$1 = (function (){var statearr_18027 = state_18019;
(statearr_18027[(9)] = inst_18006__$1);

return statearr_18027;
})();
if(inst_18007){
var statearr_18028_18046 = state_18019__$1;
(statearr_18028_18046[(1)] = (8));

} else {
var statearr_18029_18047 = state_18019__$1;
(statearr_18029_18047[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18020 === (3))){
var inst_18017 = (state_18019[(2)]);
var state_18019__$1 = state_18019;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18019__$1,inst_18017);
} else {
if((state_val_18020 === (2))){
var state_18019__$1 = state_18019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18019__$1,(4),ch);
} else {
if((state_val_18020 === (9))){
var inst_18006 = (state_18019[(9)]);
var inst_17999 = inst_18006;
var state_18019__$1 = (function (){var statearr_18030 = state_18019;
(statearr_18030[(7)] = inst_17999);

return statearr_18030;
})();
var statearr_18031_18048 = state_18019__$1;
(statearr_18031_18048[(2)] = null);

(statearr_18031_18048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18020 === (5))){
var inst_17999 = (state_18019[(7)]);
var state_18019__$1 = state_18019;
var statearr_18032_18049 = state_18019__$1;
(statearr_18032_18049[(2)] = inst_17999);

(statearr_18032_18049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18020 === (10))){
var inst_18013 = (state_18019[(2)]);
var state_18019__$1 = state_18019;
var statearr_18033_18050 = state_18019__$1;
(statearr_18033_18050[(2)] = inst_18013);

(statearr_18033_18050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18020 === (8))){
var inst_18006 = (state_18019[(9)]);
var inst_18009 = cljs.core.deref.call(null,inst_18006);
var state_18019__$1 = state_18019;
var statearr_18034_18051 = state_18019__$1;
(statearr_18034_18051[(2)] = inst_18009);

(statearr_18034_18051[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18038 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18038[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18038[(1)] = (1));

return statearr_18038;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18019){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18019);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18039){if((e18039 instanceof Object)){
var ex__8254__auto__ = e18039;
var statearr_18040_18052 = state_18019;
(statearr_18040_18052[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18019);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18053 = state_18019;
state_18019 = G__18053;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18019){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18041 = f__8363__auto__.call(null);
(statearr_18041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18054 = [];
var len__5726__auto___18106 = arguments.length;
var i__5727__auto___18107 = (0);
while(true){
if((i__5727__auto___18107 < len__5726__auto___18106)){
args18054.push((arguments[i__5727__auto___18107]));

var G__18108 = (i__5727__auto___18107 + (1));
i__5727__auto___18107 = G__18108;
continue;
} else {
}
break;
}

var G__18056 = args18054.length;
switch (G__18056) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18054.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18081){
var state_val_18082 = (state_18081[(1)]);
if((state_val_18082 === (7))){
var inst_18063 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18083_18110 = state_18081__$1;
(statearr_18083_18110[(2)] = inst_18063);

(statearr_18083_18110[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (1))){
var inst_18057 = cljs.core.seq.call(null,coll);
var inst_18058 = inst_18057;
var state_18081__$1 = (function (){var statearr_18084 = state_18081;
(statearr_18084[(7)] = inst_18058);

return statearr_18084;
})();
var statearr_18085_18111 = state_18081__$1;
(statearr_18085_18111[(2)] = null);

(statearr_18085_18111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (4))){
var inst_18058 = (state_18081[(7)]);
var inst_18061 = cljs.core.first.call(null,inst_18058);
var state_18081__$1 = state_18081;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18081__$1,(7),ch,inst_18061);
} else {
if((state_val_18082 === (13))){
var inst_18075 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18086_18112 = state_18081__$1;
(statearr_18086_18112[(2)] = inst_18075);

(statearr_18086_18112[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (6))){
var inst_18066 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
if(cljs.core.truth_(inst_18066)){
var statearr_18087_18113 = state_18081__$1;
(statearr_18087_18113[(1)] = (8));

} else {
var statearr_18088_18114 = state_18081__$1;
(statearr_18088_18114[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (3))){
var inst_18079 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18081__$1,inst_18079);
} else {
if((state_val_18082 === (12))){
var state_18081__$1 = state_18081;
var statearr_18089_18115 = state_18081__$1;
(statearr_18089_18115[(2)] = null);

(statearr_18089_18115[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (2))){
var inst_18058 = (state_18081[(7)]);
var state_18081__$1 = state_18081;
if(cljs.core.truth_(inst_18058)){
var statearr_18090_18116 = state_18081__$1;
(statearr_18090_18116[(1)] = (4));

} else {
var statearr_18091_18117 = state_18081__$1;
(statearr_18091_18117[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (11))){
var inst_18072 = cljs.core.async.close_BANG_.call(null,ch);
var state_18081__$1 = state_18081;
var statearr_18092_18118 = state_18081__$1;
(statearr_18092_18118[(2)] = inst_18072);

(statearr_18092_18118[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (9))){
var state_18081__$1 = state_18081;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18093_18119 = state_18081__$1;
(statearr_18093_18119[(1)] = (11));

} else {
var statearr_18094_18120 = state_18081__$1;
(statearr_18094_18120[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (5))){
var inst_18058 = (state_18081[(7)]);
var state_18081__$1 = state_18081;
var statearr_18095_18121 = state_18081__$1;
(statearr_18095_18121[(2)] = inst_18058);

(statearr_18095_18121[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (10))){
var inst_18077 = (state_18081[(2)]);
var state_18081__$1 = state_18081;
var statearr_18096_18122 = state_18081__$1;
(statearr_18096_18122[(2)] = inst_18077);

(statearr_18096_18122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18082 === (8))){
var inst_18058 = (state_18081[(7)]);
var inst_18068 = cljs.core.next.call(null,inst_18058);
var inst_18058__$1 = inst_18068;
var state_18081__$1 = (function (){var statearr_18097 = state_18081;
(statearr_18097[(7)] = inst_18058__$1);

return statearr_18097;
})();
var statearr_18098_18123 = state_18081__$1;
(statearr_18098_18123[(2)] = null);

(statearr_18098_18123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18102 = [null,null,null,null,null,null,null,null];
(statearr_18102[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18102[(1)] = (1));

return statearr_18102;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18081){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18081);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18103){if((e18103 instanceof Object)){
var ex__8254__auto__ = e18103;
var statearr_18104_18124 = state_18081;
(statearr_18104_18124[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18081);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18103;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18125 = state_18081;
state_18081 = G__18125;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18081){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18105 = f__8363__auto__.call(null);
(statearr_18105[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18347 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18347 = (function (mult,ch,cs,meta18348){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18348 = meta18348;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18347.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18349,meta18348__$1){
var self__ = this;
var _18349__$1 = this;
return (new cljs.core.async.t_cljs$core$async18347(self__.mult,self__.ch,self__.cs,meta18348__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18347.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18349){
var self__ = this;
var _18349__$1 = this;
return self__.meta18348;
});})(cs))
;

cljs.core.async.t_cljs$core$async18347.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18347.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18347.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18347.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18347.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18347.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18347.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18348","meta18348",-373417418,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18347.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18347.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18347";

cljs.core.async.t_cljs$core$async18347.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18347");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18347 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18347(mult__$1,ch__$1,cs__$1,meta18348){
return (new cljs.core.async.t_cljs$core$async18347(mult__$1,ch__$1,cs__$1,meta18348));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18347(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18568 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18568,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18568,cs,m,dchan,dctr,done){
return (function (state_18480){
var state_val_18481 = (state_18480[(1)]);
if((state_val_18481 === (7))){
var inst_18476 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18482_18569 = state_18480__$1;
(statearr_18482_18569[(2)] = inst_18476);

(statearr_18482_18569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (20))){
var inst_18381 = (state_18480[(7)]);
var inst_18391 = cljs.core.first.call(null,inst_18381);
var inst_18392 = cljs.core.nth.call(null,inst_18391,(0),null);
var inst_18393 = cljs.core.nth.call(null,inst_18391,(1),null);
var state_18480__$1 = (function (){var statearr_18483 = state_18480;
(statearr_18483[(8)] = inst_18392);

return statearr_18483;
})();
if(cljs.core.truth_(inst_18393)){
var statearr_18484_18570 = state_18480__$1;
(statearr_18484_18570[(1)] = (22));

} else {
var statearr_18485_18571 = state_18480__$1;
(statearr_18485_18571[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (27))){
var inst_18421 = (state_18480[(9)]);
var inst_18352 = (state_18480[(10)]);
var inst_18423 = (state_18480[(11)]);
var inst_18428 = (state_18480[(12)]);
var inst_18428__$1 = cljs.core._nth.call(null,inst_18421,inst_18423);
var inst_18429 = cljs.core.async.put_BANG_.call(null,inst_18428__$1,inst_18352,done);
var state_18480__$1 = (function (){var statearr_18486 = state_18480;
(statearr_18486[(12)] = inst_18428__$1);

return statearr_18486;
})();
if(cljs.core.truth_(inst_18429)){
var statearr_18487_18572 = state_18480__$1;
(statearr_18487_18572[(1)] = (30));

} else {
var statearr_18488_18573 = state_18480__$1;
(statearr_18488_18573[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (1))){
var state_18480__$1 = state_18480;
var statearr_18489_18574 = state_18480__$1;
(statearr_18489_18574[(2)] = null);

(statearr_18489_18574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (24))){
var inst_18381 = (state_18480[(7)]);
var inst_18398 = (state_18480[(2)]);
var inst_18399 = cljs.core.next.call(null,inst_18381);
var inst_18361 = inst_18399;
var inst_18362 = null;
var inst_18363 = (0);
var inst_18364 = (0);
var state_18480__$1 = (function (){var statearr_18490 = state_18480;
(statearr_18490[(13)] = inst_18364);

(statearr_18490[(14)] = inst_18361);

(statearr_18490[(15)] = inst_18363);

(statearr_18490[(16)] = inst_18398);

(statearr_18490[(17)] = inst_18362);

return statearr_18490;
})();
var statearr_18491_18575 = state_18480__$1;
(statearr_18491_18575[(2)] = null);

(statearr_18491_18575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (39))){
var state_18480__$1 = state_18480;
var statearr_18495_18576 = state_18480__$1;
(statearr_18495_18576[(2)] = null);

(statearr_18495_18576[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (4))){
var inst_18352 = (state_18480[(10)]);
var inst_18352__$1 = (state_18480[(2)]);
var inst_18353 = (inst_18352__$1 == null);
var state_18480__$1 = (function (){var statearr_18496 = state_18480;
(statearr_18496[(10)] = inst_18352__$1);

return statearr_18496;
})();
if(cljs.core.truth_(inst_18353)){
var statearr_18497_18577 = state_18480__$1;
(statearr_18497_18577[(1)] = (5));

} else {
var statearr_18498_18578 = state_18480__$1;
(statearr_18498_18578[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (15))){
var inst_18364 = (state_18480[(13)]);
var inst_18361 = (state_18480[(14)]);
var inst_18363 = (state_18480[(15)]);
var inst_18362 = (state_18480[(17)]);
var inst_18377 = (state_18480[(2)]);
var inst_18378 = (inst_18364 + (1));
var tmp18492 = inst_18361;
var tmp18493 = inst_18363;
var tmp18494 = inst_18362;
var inst_18361__$1 = tmp18492;
var inst_18362__$1 = tmp18494;
var inst_18363__$1 = tmp18493;
var inst_18364__$1 = inst_18378;
var state_18480__$1 = (function (){var statearr_18499 = state_18480;
(statearr_18499[(13)] = inst_18364__$1);

(statearr_18499[(14)] = inst_18361__$1);

(statearr_18499[(15)] = inst_18363__$1);

(statearr_18499[(18)] = inst_18377);

(statearr_18499[(17)] = inst_18362__$1);

return statearr_18499;
})();
var statearr_18500_18579 = state_18480__$1;
(statearr_18500_18579[(2)] = null);

(statearr_18500_18579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (21))){
var inst_18402 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18504_18580 = state_18480__$1;
(statearr_18504_18580[(2)] = inst_18402);

(statearr_18504_18580[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (31))){
var inst_18428 = (state_18480[(12)]);
var inst_18432 = done.call(null,null);
var inst_18433 = cljs.core.async.untap_STAR_.call(null,m,inst_18428);
var state_18480__$1 = (function (){var statearr_18505 = state_18480;
(statearr_18505[(19)] = inst_18432);

return statearr_18505;
})();
var statearr_18506_18581 = state_18480__$1;
(statearr_18506_18581[(2)] = inst_18433);

(statearr_18506_18581[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (32))){
var inst_18420 = (state_18480[(20)]);
var inst_18421 = (state_18480[(9)]);
var inst_18422 = (state_18480[(21)]);
var inst_18423 = (state_18480[(11)]);
var inst_18435 = (state_18480[(2)]);
var inst_18436 = (inst_18423 + (1));
var tmp18501 = inst_18420;
var tmp18502 = inst_18421;
var tmp18503 = inst_18422;
var inst_18420__$1 = tmp18501;
var inst_18421__$1 = tmp18502;
var inst_18422__$1 = tmp18503;
var inst_18423__$1 = inst_18436;
var state_18480__$1 = (function (){var statearr_18507 = state_18480;
(statearr_18507[(20)] = inst_18420__$1);

(statearr_18507[(9)] = inst_18421__$1);

(statearr_18507[(22)] = inst_18435);

(statearr_18507[(21)] = inst_18422__$1);

(statearr_18507[(11)] = inst_18423__$1);

return statearr_18507;
})();
var statearr_18508_18582 = state_18480__$1;
(statearr_18508_18582[(2)] = null);

(statearr_18508_18582[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (40))){
var inst_18448 = (state_18480[(23)]);
var inst_18452 = done.call(null,null);
var inst_18453 = cljs.core.async.untap_STAR_.call(null,m,inst_18448);
var state_18480__$1 = (function (){var statearr_18509 = state_18480;
(statearr_18509[(24)] = inst_18452);

return statearr_18509;
})();
var statearr_18510_18583 = state_18480__$1;
(statearr_18510_18583[(2)] = inst_18453);

(statearr_18510_18583[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (33))){
var inst_18439 = (state_18480[(25)]);
var inst_18441 = cljs.core.chunked_seq_QMARK_.call(null,inst_18439);
var state_18480__$1 = state_18480;
if(inst_18441){
var statearr_18511_18584 = state_18480__$1;
(statearr_18511_18584[(1)] = (36));

} else {
var statearr_18512_18585 = state_18480__$1;
(statearr_18512_18585[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (13))){
var inst_18371 = (state_18480[(26)]);
var inst_18374 = cljs.core.async.close_BANG_.call(null,inst_18371);
var state_18480__$1 = state_18480;
var statearr_18513_18586 = state_18480__$1;
(statearr_18513_18586[(2)] = inst_18374);

(statearr_18513_18586[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (22))){
var inst_18392 = (state_18480[(8)]);
var inst_18395 = cljs.core.async.close_BANG_.call(null,inst_18392);
var state_18480__$1 = state_18480;
var statearr_18514_18587 = state_18480__$1;
(statearr_18514_18587[(2)] = inst_18395);

(statearr_18514_18587[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (36))){
var inst_18439 = (state_18480[(25)]);
var inst_18443 = cljs.core.chunk_first.call(null,inst_18439);
var inst_18444 = cljs.core.chunk_rest.call(null,inst_18439);
var inst_18445 = cljs.core.count.call(null,inst_18443);
var inst_18420 = inst_18444;
var inst_18421 = inst_18443;
var inst_18422 = inst_18445;
var inst_18423 = (0);
var state_18480__$1 = (function (){var statearr_18515 = state_18480;
(statearr_18515[(20)] = inst_18420);

(statearr_18515[(9)] = inst_18421);

(statearr_18515[(21)] = inst_18422);

(statearr_18515[(11)] = inst_18423);

return statearr_18515;
})();
var statearr_18516_18588 = state_18480__$1;
(statearr_18516_18588[(2)] = null);

(statearr_18516_18588[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (41))){
var inst_18439 = (state_18480[(25)]);
var inst_18455 = (state_18480[(2)]);
var inst_18456 = cljs.core.next.call(null,inst_18439);
var inst_18420 = inst_18456;
var inst_18421 = null;
var inst_18422 = (0);
var inst_18423 = (0);
var state_18480__$1 = (function (){var statearr_18517 = state_18480;
(statearr_18517[(20)] = inst_18420);

(statearr_18517[(9)] = inst_18421);

(statearr_18517[(27)] = inst_18455);

(statearr_18517[(21)] = inst_18422);

(statearr_18517[(11)] = inst_18423);

return statearr_18517;
})();
var statearr_18518_18589 = state_18480__$1;
(statearr_18518_18589[(2)] = null);

(statearr_18518_18589[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (43))){
var state_18480__$1 = state_18480;
var statearr_18519_18590 = state_18480__$1;
(statearr_18519_18590[(2)] = null);

(statearr_18519_18590[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (29))){
var inst_18464 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18520_18591 = state_18480__$1;
(statearr_18520_18591[(2)] = inst_18464);

(statearr_18520_18591[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (44))){
var inst_18473 = (state_18480[(2)]);
var state_18480__$1 = (function (){var statearr_18521 = state_18480;
(statearr_18521[(28)] = inst_18473);

return statearr_18521;
})();
var statearr_18522_18592 = state_18480__$1;
(statearr_18522_18592[(2)] = null);

(statearr_18522_18592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (6))){
var inst_18412 = (state_18480[(29)]);
var inst_18411 = cljs.core.deref.call(null,cs);
var inst_18412__$1 = cljs.core.keys.call(null,inst_18411);
var inst_18413 = cljs.core.count.call(null,inst_18412__$1);
var inst_18414 = cljs.core.reset_BANG_.call(null,dctr,inst_18413);
var inst_18419 = cljs.core.seq.call(null,inst_18412__$1);
var inst_18420 = inst_18419;
var inst_18421 = null;
var inst_18422 = (0);
var inst_18423 = (0);
var state_18480__$1 = (function (){var statearr_18523 = state_18480;
(statearr_18523[(30)] = inst_18414);

(statearr_18523[(20)] = inst_18420);

(statearr_18523[(29)] = inst_18412__$1);

(statearr_18523[(9)] = inst_18421);

(statearr_18523[(21)] = inst_18422);

(statearr_18523[(11)] = inst_18423);

return statearr_18523;
})();
var statearr_18524_18593 = state_18480__$1;
(statearr_18524_18593[(2)] = null);

(statearr_18524_18593[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (28))){
var inst_18439 = (state_18480[(25)]);
var inst_18420 = (state_18480[(20)]);
var inst_18439__$1 = cljs.core.seq.call(null,inst_18420);
var state_18480__$1 = (function (){var statearr_18525 = state_18480;
(statearr_18525[(25)] = inst_18439__$1);

return statearr_18525;
})();
if(inst_18439__$1){
var statearr_18526_18594 = state_18480__$1;
(statearr_18526_18594[(1)] = (33));

} else {
var statearr_18527_18595 = state_18480__$1;
(statearr_18527_18595[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (25))){
var inst_18422 = (state_18480[(21)]);
var inst_18423 = (state_18480[(11)]);
var inst_18425 = (inst_18423 < inst_18422);
var inst_18426 = inst_18425;
var state_18480__$1 = state_18480;
if(cljs.core.truth_(inst_18426)){
var statearr_18528_18596 = state_18480__$1;
(statearr_18528_18596[(1)] = (27));

} else {
var statearr_18529_18597 = state_18480__$1;
(statearr_18529_18597[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (34))){
var state_18480__$1 = state_18480;
var statearr_18530_18598 = state_18480__$1;
(statearr_18530_18598[(2)] = null);

(statearr_18530_18598[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (17))){
var state_18480__$1 = state_18480;
var statearr_18531_18599 = state_18480__$1;
(statearr_18531_18599[(2)] = null);

(statearr_18531_18599[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (3))){
var inst_18478 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18480__$1,inst_18478);
} else {
if((state_val_18481 === (12))){
var inst_18407 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18532_18600 = state_18480__$1;
(statearr_18532_18600[(2)] = inst_18407);

(statearr_18532_18600[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (2))){
var state_18480__$1 = state_18480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18480__$1,(4),ch);
} else {
if((state_val_18481 === (23))){
var state_18480__$1 = state_18480;
var statearr_18533_18601 = state_18480__$1;
(statearr_18533_18601[(2)] = null);

(statearr_18533_18601[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (35))){
var inst_18462 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18534_18602 = state_18480__$1;
(statearr_18534_18602[(2)] = inst_18462);

(statearr_18534_18602[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (19))){
var inst_18381 = (state_18480[(7)]);
var inst_18385 = cljs.core.chunk_first.call(null,inst_18381);
var inst_18386 = cljs.core.chunk_rest.call(null,inst_18381);
var inst_18387 = cljs.core.count.call(null,inst_18385);
var inst_18361 = inst_18386;
var inst_18362 = inst_18385;
var inst_18363 = inst_18387;
var inst_18364 = (0);
var state_18480__$1 = (function (){var statearr_18535 = state_18480;
(statearr_18535[(13)] = inst_18364);

(statearr_18535[(14)] = inst_18361);

(statearr_18535[(15)] = inst_18363);

(statearr_18535[(17)] = inst_18362);

return statearr_18535;
})();
var statearr_18536_18603 = state_18480__$1;
(statearr_18536_18603[(2)] = null);

(statearr_18536_18603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (11))){
var inst_18361 = (state_18480[(14)]);
var inst_18381 = (state_18480[(7)]);
var inst_18381__$1 = cljs.core.seq.call(null,inst_18361);
var state_18480__$1 = (function (){var statearr_18537 = state_18480;
(statearr_18537[(7)] = inst_18381__$1);

return statearr_18537;
})();
if(inst_18381__$1){
var statearr_18538_18604 = state_18480__$1;
(statearr_18538_18604[(1)] = (16));

} else {
var statearr_18539_18605 = state_18480__$1;
(statearr_18539_18605[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (9))){
var inst_18409 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18540_18606 = state_18480__$1;
(statearr_18540_18606[(2)] = inst_18409);

(statearr_18540_18606[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (5))){
var inst_18359 = cljs.core.deref.call(null,cs);
var inst_18360 = cljs.core.seq.call(null,inst_18359);
var inst_18361 = inst_18360;
var inst_18362 = null;
var inst_18363 = (0);
var inst_18364 = (0);
var state_18480__$1 = (function (){var statearr_18541 = state_18480;
(statearr_18541[(13)] = inst_18364);

(statearr_18541[(14)] = inst_18361);

(statearr_18541[(15)] = inst_18363);

(statearr_18541[(17)] = inst_18362);

return statearr_18541;
})();
var statearr_18542_18607 = state_18480__$1;
(statearr_18542_18607[(2)] = null);

(statearr_18542_18607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (14))){
var state_18480__$1 = state_18480;
var statearr_18543_18608 = state_18480__$1;
(statearr_18543_18608[(2)] = null);

(statearr_18543_18608[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (45))){
var inst_18470 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18544_18609 = state_18480__$1;
(statearr_18544_18609[(2)] = inst_18470);

(statearr_18544_18609[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (26))){
var inst_18412 = (state_18480[(29)]);
var inst_18466 = (state_18480[(2)]);
var inst_18467 = cljs.core.seq.call(null,inst_18412);
var state_18480__$1 = (function (){var statearr_18545 = state_18480;
(statearr_18545[(31)] = inst_18466);

return statearr_18545;
})();
if(inst_18467){
var statearr_18546_18610 = state_18480__$1;
(statearr_18546_18610[(1)] = (42));

} else {
var statearr_18547_18611 = state_18480__$1;
(statearr_18547_18611[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (16))){
var inst_18381 = (state_18480[(7)]);
var inst_18383 = cljs.core.chunked_seq_QMARK_.call(null,inst_18381);
var state_18480__$1 = state_18480;
if(inst_18383){
var statearr_18548_18612 = state_18480__$1;
(statearr_18548_18612[(1)] = (19));

} else {
var statearr_18549_18613 = state_18480__$1;
(statearr_18549_18613[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (38))){
var inst_18459 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18550_18614 = state_18480__$1;
(statearr_18550_18614[(2)] = inst_18459);

(statearr_18550_18614[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (30))){
var state_18480__$1 = state_18480;
var statearr_18551_18615 = state_18480__$1;
(statearr_18551_18615[(2)] = null);

(statearr_18551_18615[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (10))){
var inst_18364 = (state_18480[(13)]);
var inst_18362 = (state_18480[(17)]);
var inst_18370 = cljs.core._nth.call(null,inst_18362,inst_18364);
var inst_18371 = cljs.core.nth.call(null,inst_18370,(0),null);
var inst_18372 = cljs.core.nth.call(null,inst_18370,(1),null);
var state_18480__$1 = (function (){var statearr_18552 = state_18480;
(statearr_18552[(26)] = inst_18371);

return statearr_18552;
})();
if(cljs.core.truth_(inst_18372)){
var statearr_18553_18616 = state_18480__$1;
(statearr_18553_18616[(1)] = (13));

} else {
var statearr_18554_18617 = state_18480__$1;
(statearr_18554_18617[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (18))){
var inst_18405 = (state_18480[(2)]);
var state_18480__$1 = state_18480;
var statearr_18555_18618 = state_18480__$1;
(statearr_18555_18618[(2)] = inst_18405);

(statearr_18555_18618[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (42))){
var state_18480__$1 = state_18480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18480__$1,(45),dchan);
} else {
if((state_val_18481 === (37))){
var inst_18439 = (state_18480[(25)]);
var inst_18448 = (state_18480[(23)]);
var inst_18352 = (state_18480[(10)]);
var inst_18448__$1 = cljs.core.first.call(null,inst_18439);
var inst_18449 = cljs.core.async.put_BANG_.call(null,inst_18448__$1,inst_18352,done);
var state_18480__$1 = (function (){var statearr_18556 = state_18480;
(statearr_18556[(23)] = inst_18448__$1);

return statearr_18556;
})();
if(cljs.core.truth_(inst_18449)){
var statearr_18557_18619 = state_18480__$1;
(statearr_18557_18619[(1)] = (39));

} else {
var statearr_18558_18620 = state_18480__$1;
(statearr_18558_18620[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18481 === (8))){
var inst_18364 = (state_18480[(13)]);
var inst_18363 = (state_18480[(15)]);
var inst_18366 = (inst_18364 < inst_18363);
var inst_18367 = inst_18366;
var state_18480__$1 = state_18480;
if(cljs.core.truth_(inst_18367)){
var statearr_18559_18621 = state_18480__$1;
(statearr_18559_18621[(1)] = (10));

} else {
var statearr_18560_18622 = state_18480__$1;
(statearr_18560_18622[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18568,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18568,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18564[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18564[(1)] = (1));

return statearr_18564;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18480){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18565){if((e18565 instanceof Object)){
var ex__8254__auto__ = e18565;
var statearr_18566_18623 = state_18480;
(statearr_18566_18623[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18480);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18565;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18624 = state_18480;
state_18480 = G__18624;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18480){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18568,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18567 = f__8363__auto__.call(null);
(statearr_18567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18568);

return statearr_18567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18568,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18625 = [];
var len__5726__auto___18628 = arguments.length;
var i__5727__auto___18629 = (0);
while(true){
if((i__5727__auto___18629 < len__5726__auto___18628)){
args18625.push((arguments[i__5727__auto___18629]));

var G__18630 = (i__5727__auto___18629 + (1));
i__5727__auto___18629 = G__18630;
continue;
} else {
}
break;
}

var G__18627 = args18625.length;
switch (G__18627) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18625.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18642 = arguments.length;
var i__5727__auto___18643 = (0);
while(true){
if((i__5727__auto___18643 < len__5726__auto___18642)){
args__5733__auto__.push((arguments[i__5727__auto___18643]));

var G__18644 = (i__5727__auto___18643 + (1));
i__5727__auto___18643 = G__18644;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18636){
var map__18637 = p__18636;
var map__18637__$1 = ((((!((map__18637 == null)))?((((map__18637.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18637.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18637):map__18637);
var opts = map__18637__$1;
var statearr_18639_18645 = state;
(statearr_18639_18645[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18637,map__18637__$1,opts){
return (function (val){
var statearr_18640_18646 = state;
(statearr_18640_18646[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18637,map__18637__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18641_18647 = state;
(statearr_18641_18647[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18632){
var G__18633 = cljs.core.first.call(null,seq18632);
var seq18632__$1 = cljs.core.next.call(null,seq18632);
var G__18634 = cljs.core.first.call(null,seq18632__$1);
var seq18632__$2 = cljs.core.next.call(null,seq18632__$1);
var G__18635 = cljs.core.first.call(null,seq18632__$2);
var seq18632__$3 = cljs.core.next.call(null,seq18632__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18633,G__18634,G__18635,seq18632__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18811 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18811 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18812){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18812 = meta18812;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18813,meta18812__$1){
var self__ = this;
var _18813__$1 = this;
return (new cljs.core.async.t_cljs$core$async18811(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18812__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18813){
var self__ = this;
var _18813__$1 = this;
return self__.meta18812;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18812","meta18812",-1400244011,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18811.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18811.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18811";

cljs.core.async.t_cljs$core$async18811.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18811");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18811 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18811(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18812){
return (new cljs.core.async.t_cljs$core$async18811(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18812));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18811(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___18974 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18974,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18974,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18911){
var state_val_18912 = (state_18911[(1)]);
if((state_val_18912 === (7))){
var inst_18829 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
var statearr_18913_18975 = state_18911__$1;
(statearr_18913_18975[(2)] = inst_18829);

(statearr_18913_18975[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (20))){
var inst_18841 = (state_18911[(7)]);
var state_18911__$1 = state_18911;
var statearr_18914_18976 = state_18911__$1;
(statearr_18914_18976[(2)] = inst_18841);

(statearr_18914_18976[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (27))){
var state_18911__$1 = state_18911;
var statearr_18915_18977 = state_18911__$1;
(statearr_18915_18977[(2)] = null);

(statearr_18915_18977[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (1))){
var inst_18817 = (state_18911[(8)]);
var inst_18817__$1 = calc_state.call(null);
var inst_18819 = (inst_18817__$1 == null);
var inst_18820 = cljs.core.not.call(null,inst_18819);
var state_18911__$1 = (function (){var statearr_18916 = state_18911;
(statearr_18916[(8)] = inst_18817__$1);

return statearr_18916;
})();
if(inst_18820){
var statearr_18917_18978 = state_18911__$1;
(statearr_18917_18978[(1)] = (2));

} else {
var statearr_18918_18979 = state_18911__$1;
(statearr_18918_18979[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (24))){
var inst_18864 = (state_18911[(9)]);
var inst_18885 = (state_18911[(10)]);
var inst_18871 = (state_18911[(11)]);
var inst_18885__$1 = inst_18864.call(null,inst_18871);
var state_18911__$1 = (function (){var statearr_18919 = state_18911;
(statearr_18919[(10)] = inst_18885__$1);

return statearr_18919;
})();
if(cljs.core.truth_(inst_18885__$1)){
var statearr_18920_18980 = state_18911__$1;
(statearr_18920_18980[(1)] = (29));

} else {
var statearr_18921_18981 = state_18911__$1;
(statearr_18921_18981[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (4))){
var inst_18832 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
if(cljs.core.truth_(inst_18832)){
var statearr_18922_18982 = state_18911__$1;
(statearr_18922_18982[(1)] = (8));

} else {
var statearr_18923_18983 = state_18911__$1;
(statearr_18923_18983[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (15))){
var inst_18858 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
if(cljs.core.truth_(inst_18858)){
var statearr_18924_18984 = state_18911__$1;
(statearr_18924_18984[(1)] = (19));

} else {
var statearr_18925_18985 = state_18911__$1;
(statearr_18925_18985[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (21))){
var inst_18863 = (state_18911[(12)]);
var inst_18863__$1 = (state_18911[(2)]);
var inst_18864 = cljs.core.get.call(null,inst_18863__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18865 = cljs.core.get.call(null,inst_18863__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18866 = cljs.core.get.call(null,inst_18863__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18911__$1 = (function (){var statearr_18926 = state_18911;
(statearr_18926[(9)] = inst_18864);

(statearr_18926[(13)] = inst_18865);

(statearr_18926[(12)] = inst_18863__$1);

return statearr_18926;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18911__$1,(22),inst_18866);
} else {
if((state_val_18912 === (31))){
var inst_18893 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
if(cljs.core.truth_(inst_18893)){
var statearr_18927_18986 = state_18911__$1;
(statearr_18927_18986[(1)] = (32));

} else {
var statearr_18928_18987 = state_18911__$1;
(statearr_18928_18987[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (32))){
var inst_18870 = (state_18911[(14)]);
var state_18911__$1 = state_18911;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18911__$1,(35),out,inst_18870);
} else {
if((state_val_18912 === (33))){
var inst_18863 = (state_18911[(12)]);
var inst_18841 = inst_18863;
var state_18911__$1 = (function (){var statearr_18929 = state_18911;
(statearr_18929[(7)] = inst_18841);

return statearr_18929;
})();
var statearr_18930_18988 = state_18911__$1;
(statearr_18930_18988[(2)] = null);

(statearr_18930_18988[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (13))){
var inst_18841 = (state_18911[(7)]);
var inst_18848 = inst_18841.cljs$lang$protocol_mask$partition0$;
var inst_18849 = (inst_18848 & (64));
var inst_18850 = inst_18841.cljs$core$ISeq$;
var inst_18851 = (inst_18849) || (inst_18850);
var state_18911__$1 = state_18911;
if(cljs.core.truth_(inst_18851)){
var statearr_18931_18989 = state_18911__$1;
(statearr_18931_18989[(1)] = (16));

} else {
var statearr_18932_18990 = state_18911__$1;
(statearr_18932_18990[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (22))){
var inst_18870 = (state_18911[(14)]);
var inst_18871 = (state_18911[(11)]);
var inst_18869 = (state_18911[(2)]);
var inst_18870__$1 = cljs.core.nth.call(null,inst_18869,(0),null);
var inst_18871__$1 = cljs.core.nth.call(null,inst_18869,(1),null);
var inst_18872 = (inst_18870__$1 == null);
var inst_18873 = cljs.core._EQ_.call(null,inst_18871__$1,change);
var inst_18874 = (inst_18872) || (inst_18873);
var state_18911__$1 = (function (){var statearr_18933 = state_18911;
(statearr_18933[(14)] = inst_18870__$1);

(statearr_18933[(11)] = inst_18871__$1);

return statearr_18933;
})();
if(cljs.core.truth_(inst_18874)){
var statearr_18934_18991 = state_18911__$1;
(statearr_18934_18991[(1)] = (23));

} else {
var statearr_18935_18992 = state_18911__$1;
(statearr_18935_18992[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (36))){
var inst_18863 = (state_18911[(12)]);
var inst_18841 = inst_18863;
var state_18911__$1 = (function (){var statearr_18936 = state_18911;
(statearr_18936[(7)] = inst_18841);

return statearr_18936;
})();
var statearr_18937_18993 = state_18911__$1;
(statearr_18937_18993[(2)] = null);

(statearr_18937_18993[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (29))){
var inst_18885 = (state_18911[(10)]);
var state_18911__$1 = state_18911;
var statearr_18938_18994 = state_18911__$1;
(statearr_18938_18994[(2)] = inst_18885);

(statearr_18938_18994[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (6))){
var state_18911__$1 = state_18911;
var statearr_18939_18995 = state_18911__$1;
(statearr_18939_18995[(2)] = false);

(statearr_18939_18995[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (28))){
var inst_18881 = (state_18911[(2)]);
var inst_18882 = calc_state.call(null);
var inst_18841 = inst_18882;
var state_18911__$1 = (function (){var statearr_18940 = state_18911;
(statearr_18940[(7)] = inst_18841);

(statearr_18940[(15)] = inst_18881);

return statearr_18940;
})();
var statearr_18941_18996 = state_18911__$1;
(statearr_18941_18996[(2)] = null);

(statearr_18941_18996[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (25))){
var inst_18907 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
var statearr_18942_18997 = state_18911__$1;
(statearr_18942_18997[(2)] = inst_18907);

(statearr_18942_18997[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (34))){
var inst_18905 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
var statearr_18943_18998 = state_18911__$1;
(statearr_18943_18998[(2)] = inst_18905);

(statearr_18943_18998[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (17))){
var state_18911__$1 = state_18911;
var statearr_18944_18999 = state_18911__$1;
(statearr_18944_18999[(2)] = false);

(statearr_18944_18999[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (3))){
var state_18911__$1 = state_18911;
var statearr_18945_19000 = state_18911__$1;
(statearr_18945_19000[(2)] = false);

(statearr_18945_19000[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (12))){
var inst_18909 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18911__$1,inst_18909);
} else {
if((state_val_18912 === (2))){
var inst_18817 = (state_18911[(8)]);
var inst_18822 = inst_18817.cljs$lang$protocol_mask$partition0$;
var inst_18823 = (inst_18822 & (64));
var inst_18824 = inst_18817.cljs$core$ISeq$;
var inst_18825 = (inst_18823) || (inst_18824);
var state_18911__$1 = state_18911;
if(cljs.core.truth_(inst_18825)){
var statearr_18946_19001 = state_18911__$1;
(statearr_18946_19001[(1)] = (5));

} else {
var statearr_18947_19002 = state_18911__$1;
(statearr_18947_19002[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (23))){
var inst_18870 = (state_18911[(14)]);
var inst_18876 = (inst_18870 == null);
var state_18911__$1 = state_18911;
if(cljs.core.truth_(inst_18876)){
var statearr_18948_19003 = state_18911__$1;
(statearr_18948_19003[(1)] = (26));

} else {
var statearr_18949_19004 = state_18911__$1;
(statearr_18949_19004[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (35))){
var inst_18896 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
if(cljs.core.truth_(inst_18896)){
var statearr_18950_19005 = state_18911__$1;
(statearr_18950_19005[(1)] = (36));

} else {
var statearr_18951_19006 = state_18911__$1;
(statearr_18951_19006[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (19))){
var inst_18841 = (state_18911[(7)]);
var inst_18860 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18841);
var state_18911__$1 = state_18911;
var statearr_18952_19007 = state_18911__$1;
(statearr_18952_19007[(2)] = inst_18860);

(statearr_18952_19007[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (11))){
var inst_18841 = (state_18911[(7)]);
var inst_18845 = (inst_18841 == null);
var inst_18846 = cljs.core.not.call(null,inst_18845);
var state_18911__$1 = state_18911;
if(inst_18846){
var statearr_18953_19008 = state_18911__$1;
(statearr_18953_19008[(1)] = (13));

} else {
var statearr_18954_19009 = state_18911__$1;
(statearr_18954_19009[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (9))){
var inst_18817 = (state_18911[(8)]);
var state_18911__$1 = state_18911;
var statearr_18955_19010 = state_18911__$1;
(statearr_18955_19010[(2)] = inst_18817);

(statearr_18955_19010[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (5))){
var state_18911__$1 = state_18911;
var statearr_18956_19011 = state_18911__$1;
(statearr_18956_19011[(2)] = true);

(statearr_18956_19011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (14))){
var state_18911__$1 = state_18911;
var statearr_18957_19012 = state_18911__$1;
(statearr_18957_19012[(2)] = false);

(statearr_18957_19012[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (26))){
var inst_18871 = (state_18911[(11)]);
var inst_18878 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18871);
var state_18911__$1 = state_18911;
var statearr_18958_19013 = state_18911__$1;
(statearr_18958_19013[(2)] = inst_18878);

(statearr_18958_19013[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (16))){
var state_18911__$1 = state_18911;
var statearr_18959_19014 = state_18911__$1;
(statearr_18959_19014[(2)] = true);

(statearr_18959_19014[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (38))){
var inst_18901 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
var statearr_18960_19015 = state_18911__$1;
(statearr_18960_19015[(2)] = inst_18901);

(statearr_18960_19015[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (30))){
var inst_18864 = (state_18911[(9)]);
var inst_18865 = (state_18911[(13)]);
var inst_18871 = (state_18911[(11)]);
var inst_18888 = cljs.core.empty_QMARK_.call(null,inst_18864);
var inst_18889 = inst_18865.call(null,inst_18871);
var inst_18890 = cljs.core.not.call(null,inst_18889);
var inst_18891 = (inst_18888) && (inst_18890);
var state_18911__$1 = state_18911;
var statearr_18961_19016 = state_18911__$1;
(statearr_18961_19016[(2)] = inst_18891);

(statearr_18961_19016[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (10))){
var inst_18817 = (state_18911[(8)]);
var inst_18837 = (state_18911[(2)]);
var inst_18838 = cljs.core.get.call(null,inst_18837,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18839 = cljs.core.get.call(null,inst_18837,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18840 = cljs.core.get.call(null,inst_18837,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18841 = inst_18817;
var state_18911__$1 = (function (){var statearr_18962 = state_18911;
(statearr_18962[(16)] = inst_18839);

(statearr_18962[(17)] = inst_18838);

(statearr_18962[(18)] = inst_18840);

(statearr_18962[(7)] = inst_18841);

return statearr_18962;
})();
var statearr_18963_19017 = state_18911__$1;
(statearr_18963_19017[(2)] = null);

(statearr_18963_19017[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (18))){
var inst_18855 = (state_18911[(2)]);
var state_18911__$1 = state_18911;
var statearr_18964_19018 = state_18911__$1;
(statearr_18964_19018[(2)] = inst_18855);

(statearr_18964_19018[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (37))){
var state_18911__$1 = state_18911;
var statearr_18965_19019 = state_18911__$1;
(statearr_18965_19019[(2)] = null);

(statearr_18965_19019[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18912 === (8))){
var inst_18817 = (state_18911[(8)]);
var inst_18834 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18817);
var state_18911__$1 = state_18911;
var statearr_18966_19020 = state_18911__$1;
(statearr_18966_19020[(2)] = inst_18834);

(statearr_18966_19020[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18974,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___18974,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_18970 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18970[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_18970[(1)] = (1));

return statearr_18970;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18911){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18971){if((e18971 instanceof Object)){
var ex__8254__auto__ = e18971;
var statearr_18972_19021 = state_18911;
(statearr_18972_19021[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18911);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18971;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19022 = state_18911;
state_18911 = G__19022;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18911){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18974,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_18973 = f__8363__auto__.call(null);
(statearr_18973[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18974);

return statearr_18973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18974,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19023 = [];
var len__5726__auto___19026 = arguments.length;
var i__5727__auto___19027 = (0);
while(true){
if((i__5727__auto___19027 < len__5726__auto___19026)){
args19023.push((arguments[i__5727__auto___19027]));

var G__19028 = (i__5727__auto___19027 + (1));
i__5727__auto___19027 = G__19028;
continue;
} else {
}
break;
}

var G__19025 = args19023.length;
switch (G__19025) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19023.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19031 = [];
var len__5726__auto___19156 = arguments.length;
var i__5727__auto___19157 = (0);
while(true){
if((i__5727__auto___19157 < len__5726__auto___19156)){
args19031.push((arguments[i__5727__auto___19157]));

var G__19158 = (i__5727__auto___19157 + (1));
i__5727__auto___19157 = G__19158;
continue;
} else {
}
break;
}

var G__19033 = args19031.length;
switch (G__19033) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19031.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19030_SHARP_){
if(cljs.core.truth_(p1__19030_SHARP_.call(null,topic))){
return p1__19030_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19030_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19034 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19034 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19035){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19035 = meta19035;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19036,meta19035__$1){
var self__ = this;
var _19036__$1 = this;
return (new cljs.core.async.t_cljs$core$async19034(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19035__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19036){
var self__ = this;
var _19036__$1 = this;
return self__.meta19035;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19034.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19034.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19035","meta19035",-1047137705,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19034.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19034.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19034";

cljs.core.async.t_cljs$core$async19034.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19034");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19034 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19034(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19035){
return (new cljs.core.async.t_cljs$core$async19034(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19035));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19034(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19160 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19160,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19160,mults,ensure_mult,p){
return (function (state_19108){
var state_val_19109 = (state_19108[(1)]);
if((state_val_19109 === (7))){
var inst_19104 = (state_19108[(2)]);
var state_19108__$1 = state_19108;
var statearr_19110_19161 = state_19108__$1;
(statearr_19110_19161[(2)] = inst_19104);

(statearr_19110_19161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (20))){
var state_19108__$1 = state_19108;
var statearr_19111_19162 = state_19108__$1;
(statearr_19111_19162[(2)] = null);

(statearr_19111_19162[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (1))){
var state_19108__$1 = state_19108;
var statearr_19112_19163 = state_19108__$1;
(statearr_19112_19163[(2)] = null);

(statearr_19112_19163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (24))){
var inst_19087 = (state_19108[(7)]);
var inst_19096 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19087);
var state_19108__$1 = state_19108;
var statearr_19113_19164 = state_19108__$1;
(statearr_19113_19164[(2)] = inst_19096);

(statearr_19113_19164[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (4))){
var inst_19039 = (state_19108[(8)]);
var inst_19039__$1 = (state_19108[(2)]);
var inst_19040 = (inst_19039__$1 == null);
var state_19108__$1 = (function (){var statearr_19114 = state_19108;
(statearr_19114[(8)] = inst_19039__$1);

return statearr_19114;
})();
if(cljs.core.truth_(inst_19040)){
var statearr_19115_19165 = state_19108__$1;
(statearr_19115_19165[(1)] = (5));

} else {
var statearr_19116_19166 = state_19108__$1;
(statearr_19116_19166[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (15))){
var inst_19081 = (state_19108[(2)]);
var state_19108__$1 = state_19108;
var statearr_19117_19167 = state_19108__$1;
(statearr_19117_19167[(2)] = inst_19081);

(statearr_19117_19167[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (21))){
var inst_19101 = (state_19108[(2)]);
var state_19108__$1 = (function (){var statearr_19118 = state_19108;
(statearr_19118[(9)] = inst_19101);

return statearr_19118;
})();
var statearr_19119_19168 = state_19108__$1;
(statearr_19119_19168[(2)] = null);

(statearr_19119_19168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (13))){
var inst_19063 = (state_19108[(10)]);
var inst_19065 = cljs.core.chunked_seq_QMARK_.call(null,inst_19063);
var state_19108__$1 = state_19108;
if(inst_19065){
var statearr_19120_19169 = state_19108__$1;
(statearr_19120_19169[(1)] = (16));

} else {
var statearr_19121_19170 = state_19108__$1;
(statearr_19121_19170[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (22))){
var inst_19093 = (state_19108[(2)]);
var state_19108__$1 = state_19108;
if(cljs.core.truth_(inst_19093)){
var statearr_19122_19171 = state_19108__$1;
(statearr_19122_19171[(1)] = (23));

} else {
var statearr_19123_19172 = state_19108__$1;
(statearr_19123_19172[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (6))){
var inst_19039 = (state_19108[(8)]);
var inst_19087 = (state_19108[(7)]);
var inst_19089 = (state_19108[(11)]);
var inst_19087__$1 = topic_fn.call(null,inst_19039);
var inst_19088 = cljs.core.deref.call(null,mults);
var inst_19089__$1 = cljs.core.get.call(null,inst_19088,inst_19087__$1);
var state_19108__$1 = (function (){var statearr_19124 = state_19108;
(statearr_19124[(7)] = inst_19087__$1);

(statearr_19124[(11)] = inst_19089__$1);

return statearr_19124;
})();
if(cljs.core.truth_(inst_19089__$1)){
var statearr_19125_19173 = state_19108__$1;
(statearr_19125_19173[(1)] = (19));

} else {
var statearr_19126_19174 = state_19108__$1;
(statearr_19126_19174[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (25))){
var inst_19098 = (state_19108[(2)]);
var state_19108__$1 = state_19108;
var statearr_19127_19175 = state_19108__$1;
(statearr_19127_19175[(2)] = inst_19098);

(statearr_19127_19175[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (17))){
var inst_19063 = (state_19108[(10)]);
var inst_19072 = cljs.core.first.call(null,inst_19063);
var inst_19073 = cljs.core.async.muxch_STAR_.call(null,inst_19072);
var inst_19074 = cljs.core.async.close_BANG_.call(null,inst_19073);
var inst_19075 = cljs.core.next.call(null,inst_19063);
var inst_19049 = inst_19075;
var inst_19050 = null;
var inst_19051 = (0);
var inst_19052 = (0);
var state_19108__$1 = (function (){var statearr_19128 = state_19108;
(statearr_19128[(12)] = inst_19052);

(statearr_19128[(13)] = inst_19050);

(statearr_19128[(14)] = inst_19051);

(statearr_19128[(15)] = inst_19074);

(statearr_19128[(16)] = inst_19049);

return statearr_19128;
})();
var statearr_19129_19176 = state_19108__$1;
(statearr_19129_19176[(2)] = null);

(statearr_19129_19176[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (3))){
var inst_19106 = (state_19108[(2)]);
var state_19108__$1 = state_19108;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19108__$1,inst_19106);
} else {
if((state_val_19109 === (12))){
var inst_19083 = (state_19108[(2)]);
var state_19108__$1 = state_19108;
var statearr_19130_19177 = state_19108__$1;
(statearr_19130_19177[(2)] = inst_19083);

(statearr_19130_19177[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (2))){
var state_19108__$1 = state_19108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19108__$1,(4),ch);
} else {
if((state_val_19109 === (23))){
var state_19108__$1 = state_19108;
var statearr_19131_19178 = state_19108__$1;
(statearr_19131_19178[(2)] = null);

(statearr_19131_19178[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (19))){
var inst_19039 = (state_19108[(8)]);
var inst_19089 = (state_19108[(11)]);
var inst_19091 = cljs.core.async.muxch_STAR_.call(null,inst_19089);
var state_19108__$1 = state_19108;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19108__$1,(22),inst_19091,inst_19039);
} else {
if((state_val_19109 === (11))){
var inst_19063 = (state_19108[(10)]);
var inst_19049 = (state_19108[(16)]);
var inst_19063__$1 = cljs.core.seq.call(null,inst_19049);
var state_19108__$1 = (function (){var statearr_19132 = state_19108;
(statearr_19132[(10)] = inst_19063__$1);

return statearr_19132;
})();
if(inst_19063__$1){
var statearr_19133_19179 = state_19108__$1;
(statearr_19133_19179[(1)] = (13));

} else {
var statearr_19134_19180 = state_19108__$1;
(statearr_19134_19180[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (9))){
var inst_19085 = (state_19108[(2)]);
var state_19108__$1 = state_19108;
var statearr_19135_19181 = state_19108__$1;
(statearr_19135_19181[(2)] = inst_19085);

(statearr_19135_19181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (5))){
var inst_19046 = cljs.core.deref.call(null,mults);
var inst_19047 = cljs.core.vals.call(null,inst_19046);
var inst_19048 = cljs.core.seq.call(null,inst_19047);
var inst_19049 = inst_19048;
var inst_19050 = null;
var inst_19051 = (0);
var inst_19052 = (0);
var state_19108__$1 = (function (){var statearr_19136 = state_19108;
(statearr_19136[(12)] = inst_19052);

(statearr_19136[(13)] = inst_19050);

(statearr_19136[(14)] = inst_19051);

(statearr_19136[(16)] = inst_19049);

return statearr_19136;
})();
var statearr_19137_19182 = state_19108__$1;
(statearr_19137_19182[(2)] = null);

(statearr_19137_19182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (14))){
var state_19108__$1 = state_19108;
var statearr_19141_19183 = state_19108__$1;
(statearr_19141_19183[(2)] = null);

(statearr_19141_19183[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (16))){
var inst_19063 = (state_19108[(10)]);
var inst_19067 = cljs.core.chunk_first.call(null,inst_19063);
var inst_19068 = cljs.core.chunk_rest.call(null,inst_19063);
var inst_19069 = cljs.core.count.call(null,inst_19067);
var inst_19049 = inst_19068;
var inst_19050 = inst_19067;
var inst_19051 = inst_19069;
var inst_19052 = (0);
var state_19108__$1 = (function (){var statearr_19142 = state_19108;
(statearr_19142[(12)] = inst_19052);

(statearr_19142[(13)] = inst_19050);

(statearr_19142[(14)] = inst_19051);

(statearr_19142[(16)] = inst_19049);

return statearr_19142;
})();
var statearr_19143_19184 = state_19108__$1;
(statearr_19143_19184[(2)] = null);

(statearr_19143_19184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (10))){
var inst_19052 = (state_19108[(12)]);
var inst_19050 = (state_19108[(13)]);
var inst_19051 = (state_19108[(14)]);
var inst_19049 = (state_19108[(16)]);
var inst_19057 = cljs.core._nth.call(null,inst_19050,inst_19052);
var inst_19058 = cljs.core.async.muxch_STAR_.call(null,inst_19057);
var inst_19059 = cljs.core.async.close_BANG_.call(null,inst_19058);
var inst_19060 = (inst_19052 + (1));
var tmp19138 = inst_19050;
var tmp19139 = inst_19051;
var tmp19140 = inst_19049;
var inst_19049__$1 = tmp19140;
var inst_19050__$1 = tmp19138;
var inst_19051__$1 = tmp19139;
var inst_19052__$1 = inst_19060;
var state_19108__$1 = (function (){var statearr_19144 = state_19108;
(statearr_19144[(12)] = inst_19052__$1);

(statearr_19144[(13)] = inst_19050__$1);

(statearr_19144[(14)] = inst_19051__$1);

(statearr_19144[(17)] = inst_19059);

(statearr_19144[(16)] = inst_19049__$1);

return statearr_19144;
})();
var statearr_19145_19185 = state_19108__$1;
(statearr_19145_19185[(2)] = null);

(statearr_19145_19185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (18))){
var inst_19078 = (state_19108[(2)]);
var state_19108__$1 = state_19108;
var statearr_19146_19186 = state_19108__$1;
(statearr_19146_19186[(2)] = inst_19078);

(statearr_19146_19186[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19109 === (8))){
var inst_19052 = (state_19108[(12)]);
var inst_19051 = (state_19108[(14)]);
var inst_19054 = (inst_19052 < inst_19051);
var inst_19055 = inst_19054;
var state_19108__$1 = state_19108;
if(cljs.core.truth_(inst_19055)){
var statearr_19147_19187 = state_19108__$1;
(statearr_19147_19187[(1)] = (10));

} else {
var statearr_19148_19188 = state_19108__$1;
(statearr_19148_19188[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19160,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19160,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19152 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19152[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19152[(1)] = (1));

return statearr_19152;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19108){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19153){if((e19153 instanceof Object)){
var ex__8254__auto__ = e19153;
var statearr_19154_19189 = state_19108;
(statearr_19154_19189[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19108);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19153;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19190 = state_19108;
state_19108 = G__19190;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19108){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19160,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19155 = f__8363__auto__.call(null);
(statearr_19155[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19160);

return statearr_19155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19160,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19191 = [];
var len__5726__auto___19194 = arguments.length;
var i__5727__auto___19195 = (0);
while(true){
if((i__5727__auto___19195 < len__5726__auto___19194)){
args19191.push((arguments[i__5727__auto___19195]));

var G__19196 = (i__5727__auto___19195 + (1));
i__5727__auto___19195 = G__19196;
continue;
} else {
}
break;
}

var G__19193 = args19191.length;
switch (G__19193) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19191.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19198 = [];
var len__5726__auto___19201 = arguments.length;
var i__5727__auto___19202 = (0);
while(true){
if((i__5727__auto___19202 < len__5726__auto___19201)){
args19198.push((arguments[i__5727__auto___19202]));

var G__19203 = (i__5727__auto___19202 + (1));
i__5727__auto___19202 = G__19203;
continue;
} else {
}
break;
}

var G__19200 = args19198.length;
switch (G__19200) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19198.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19205 = [];
var len__5726__auto___19276 = arguments.length;
var i__5727__auto___19277 = (0);
while(true){
if((i__5727__auto___19277 < len__5726__auto___19276)){
args19205.push((arguments[i__5727__auto___19277]));

var G__19278 = (i__5727__auto___19277 + (1));
i__5727__auto___19277 = G__19278;
continue;
} else {
}
break;
}

var G__19207 = args19205.length;
switch (G__19207) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19205.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19280 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19280,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19280,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19246){
var state_val_19247 = (state_19246[(1)]);
if((state_val_19247 === (7))){
var state_19246__$1 = state_19246;
var statearr_19248_19281 = state_19246__$1;
(statearr_19248_19281[(2)] = null);

(statearr_19248_19281[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (1))){
var state_19246__$1 = state_19246;
var statearr_19249_19282 = state_19246__$1;
(statearr_19249_19282[(2)] = null);

(statearr_19249_19282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (4))){
var inst_19210 = (state_19246[(7)]);
var inst_19212 = (inst_19210 < cnt);
var state_19246__$1 = state_19246;
if(cljs.core.truth_(inst_19212)){
var statearr_19250_19283 = state_19246__$1;
(statearr_19250_19283[(1)] = (6));

} else {
var statearr_19251_19284 = state_19246__$1;
(statearr_19251_19284[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (15))){
var inst_19242 = (state_19246[(2)]);
var state_19246__$1 = state_19246;
var statearr_19252_19285 = state_19246__$1;
(statearr_19252_19285[(2)] = inst_19242);

(statearr_19252_19285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (13))){
var inst_19235 = cljs.core.async.close_BANG_.call(null,out);
var state_19246__$1 = state_19246;
var statearr_19253_19286 = state_19246__$1;
(statearr_19253_19286[(2)] = inst_19235);

(statearr_19253_19286[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (6))){
var state_19246__$1 = state_19246;
var statearr_19254_19287 = state_19246__$1;
(statearr_19254_19287[(2)] = null);

(statearr_19254_19287[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (3))){
var inst_19244 = (state_19246[(2)]);
var state_19246__$1 = state_19246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19246__$1,inst_19244);
} else {
if((state_val_19247 === (12))){
var inst_19232 = (state_19246[(8)]);
var inst_19232__$1 = (state_19246[(2)]);
var inst_19233 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19232__$1);
var state_19246__$1 = (function (){var statearr_19255 = state_19246;
(statearr_19255[(8)] = inst_19232__$1);

return statearr_19255;
})();
if(cljs.core.truth_(inst_19233)){
var statearr_19256_19288 = state_19246__$1;
(statearr_19256_19288[(1)] = (13));

} else {
var statearr_19257_19289 = state_19246__$1;
(statearr_19257_19289[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (2))){
var inst_19209 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19210 = (0);
var state_19246__$1 = (function (){var statearr_19258 = state_19246;
(statearr_19258[(7)] = inst_19210);

(statearr_19258[(9)] = inst_19209);

return statearr_19258;
})();
var statearr_19259_19290 = state_19246__$1;
(statearr_19259_19290[(2)] = null);

(statearr_19259_19290[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (11))){
var inst_19210 = (state_19246[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19246,(10),Object,null,(9));
var inst_19219 = chs__$1.call(null,inst_19210);
var inst_19220 = done.call(null,inst_19210);
var inst_19221 = cljs.core.async.take_BANG_.call(null,inst_19219,inst_19220);
var state_19246__$1 = state_19246;
var statearr_19260_19291 = state_19246__$1;
(statearr_19260_19291[(2)] = inst_19221);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19246__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (9))){
var inst_19210 = (state_19246[(7)]);
var inst_19223 = (state_19246[(2)]);
var inst_19224 = (inst_19210 + (1));
var inst_19210__$1 = inst_19224;
var state_19246__$1 = (function (){var statearr_19261 = state_19246;
(statearr_19261[(10)] = inst_19223);

(statearr_19261[(7)] = inst_19210__$1);

return statearr_19261;
})();
var statearr_19262_19292 = state_19246__$1;
(statearr_19262_19292[(2)] = null);

(statearr_19262_19292[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (5))){
var inst_19230 = (state_19246[(2)]);
var state_19246__$1 = (function (){var statearr_19263 = state_19246;
(statearr_19263[(11)] = inst_19230);

return statearr_19263;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19246__$1,(12),dchan);
} else {
if((state_val_19247 === (14))){
var inst_19232 = (state_19246[(8)]);
var inst_19237 = cljs.core.apply.call(null,f,inst_19232);
var state_19246__$1 = state_19246;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19246__$1,(16),out,inst_19237);
} else {
if((state_val_19247 === (16))){
var inst_19239 = (state_19246[(2)]);
var state_19246__$1 = (function (){var statearr_19264 = state_19246;
(statearr_19264[(12)] = inst_19239);

return statearr_19264;
})();
var statearr_19265_19293 = state_19246__$1;
(statearr_19265_19293[(2)] = null);

(statearr_19265_19293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (10))){
var inst_19214 = (state_19246[(2)]);
var inst_19215 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19246__$1 = (function (){var statearr_19266 = state_19246;
(statearr_19266[(13)] = inst_19214);

return statearr_19266;
})();
var statearr_19267_19294 = state_19246__$1;
(statearr_19267_19294[(2)] = inst_19215);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19246__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19247 === (8))){
var inst_19228 = (state_19246[(2)]);
var state_19246__$1 = state_19246;
var statearr_19268_19295 = state_19246__$1;
(statearr_19268_19295[(2)] = inst_19228);

(statearr_19268_19295[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19280,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19280,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19272[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19272[(1)] = (1));

return statearr_19272;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19246){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19273){if((e19273 instanceof Object)){
var ex__8254__auto__ = e19273;
var statearr_19274_19296 = state_19246;
(statearr_19274_19296[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19246);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19273;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19297 = state_19246;
state_19246 = G__19297;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19246){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19280,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19275 = f__8363__auto__.call(null);
(statearr_19275[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19280);

return statearr_19275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19280,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19299 = [];
var len__5726__auto___19355 = arguments.length;
var i__5727__auto___19356 = (0);
while(true){
if((i__5727__auto___19356 < len__5726__auto___19355)){
args19299.push((arguments[i__5727__auto___19356]));

var G__19357 = (i__5727__auto___19356 + (1));
i__5727__auto___19356 = G__19357;
continue;
} else {
}
break;
}

var G__19301 = args19299.length;
switch (G__19301) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19299.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19359 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19359,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19359,out){
return (function (state_19331){
var state_val_19332 = (state_19331[(1)]);
if((state_val_19332 === (7))){
var inst_19310 = (state_19331[(7)]);
var inst_19311 = (state_19331[(8)]);
var inst_19310__$1 = (state_19331[(2)]);
var inst_19311__$1 = cljs.core.nth.call(null,inst_19310__$1,(0),null);
var inst_19312 = cljs.core.nth.call(null,inst_19310__$1,(1),null);
var inst_19313 = (inst_19311__$1 == null);
var state_19331__$1 = (function (){var statearr_19333 = state_19331;
(statearr_19333[(7)] = inst_19310__$1);

(statearr_19333[(8)] = inst_19311__$1);

(statearr_19333[(9)] = inst_19312);

return statearr_19333;
})();
if(cljs.core.truth_(inst_19313)){
var statearr_19334_19360 = state_19331__$1;
(statearr_19334_19360[(1)] = (8));

} else {
var statearr_19335_19361 = state_19331__$1;
(statearr_19335_19361[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19332 === (1))){
var inst_19302 = cljs.core.vec.call(null,chs);
var inst_19303 = inst_19302;
var state_19331__$1 = (function (){var statearr_19336 = state_19331;
(statearr_19336[(10)] = inst_19303);

return statearr_19336;
})();
var statearr_19337_19362 = state_19331__$1;
(statearr_19337_19362[(2)] = null);

(statearr_19337_19362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19332 === (4))){
var inst_19303 = (state_19331[(10)]);
var state_19331__$1 = state_19331;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19331__$1,(7),inst_19303);
} else {
if((state_val_19332 === (6))){
var inst_19327 = (state_19331[(2)]);
var state_19331__$1 = state_19331;
var statearr_19338_19363 = state_19331__$1;
(statearr_19338_19363[(2)] = inst_19327);

(statearr_19338_19363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19332 === (3))){
var inst_19329 = (state_19331[(2)]);
var state_19331__$1 = state_19331;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19331__$1,inst_19329);
} else {
if((state_val_19332 === (2))){
var inst_19303 = (state_19331[(10)]);
var inst_19305 = cljs.core.count.call(null,inst_19303);
var inst_19306 = (inst_19305 > (0));
var state_19331__$1 = state_19331;
if(cljs.core.truth_(inst_19306)){
var statearr_19340_19364 = state_19331__$1;
(statearr_19340_19364[(1)] = (4));

} else {
var statearr_19341_19365 = state_19331__$1;
(statearr_19341_19365[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19332 === (11))){
var inst_19303 = (state_19331[(10)]);
var inst_19320 = (state_19331[(2)]);
var tmp19339 = inst_19303;
var inst_19303__$1 = tmp19339;
var state_19331__$1 = (function (){var statearr_19342 = state_19331;
(statearr_19342[(10)] = inst_19303__$1);

(statearr_19342[(11)] = inst_19320);

return statearr_19342;
})();
var statearr_19343_19366 = state_19331__$1;
(statearr_19343_19366[(2)] = null);

(statearr_19343_19366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19332 === (9))){
var inst_19311 = (state_19331[(8)]);
var state_19331__$1 = state_19331;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19331__$1,(11),out,inst_19311);
} else {
if((state_val_19332 === (5))){
var inst_19325 = cljs.core.async.close_BANG_.call(null,out);
var state_19331__$1 = state_19331;
var statearr_19344_19367 = state_19331__$1;
(statearr_19344_19367[(2)] = inst_19325);

(statearr_19344_19367[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19332 === (10))){
var inst_19323 = (state_19331[(2)]);
var state_19331__$1 = state_19331;
var statearr_19345_19368 = state_19331__$1;
(statearr_19345_19368[(2)] = inst_19323);

(statearr_19345_19368[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19332 === (8))){
var inst_19310 = (state_19331[(7)]);
var inst_19311 = (state_19331[(8)]);
var inst_19303 = (state_19331[(10)]);
var inst_19312 = (state_19331[(9)]);
var inst_19315 = (function (){var cs = inst_19303;
var vec__19308 = inst_19310;
var v = inst_19311;
var c = inst_19312;
return ((function (cs,vec__19308,v,c,inst_19310,inst_19311,inst_19303,inst_19312,state_val_19332,c__8362__auto___19359,out){
return (function (p1__19298_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19298_SHARP_);
});
;})(cs,vec__19308,v,c,inst_19310,inst_19311,inst_19303,inst_19312,state_val_19332,c__8362__auto___19359,out))
})();
var inst_19316 = cljs.core.filterv.call(null,inst_19315,inst_19303);
var inst_19303__$1 = inst_19316;
var state_19331__$1 = (function (){var statearr_19346 = state_19331;
(statearr_19346[(10)] = inst_19303__$1);

return statearr_19346;
})();
var statearr_19347_19369 = state_19331__$1;
(statearr_19347_19369[(2)] = null);

(statearr_19347_19369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19359,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19359,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19351 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19351[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19351[(1)] = (1));

return statearr_19351;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19331){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19331);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19352){if((e19352 instanceof Object)){
var ex__8254__auto__ = e19352;
var statearr_19353_19370 = state_19331;
(statearr_19353_19370[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19331);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19352;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19371 = state_19331;
state_19331 = G__19371;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19331){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19359,out))
})();
var state__8364__auto__ = (function (){var statearr_19354 = f__8363__auto__.call(null);
(statearr_19354[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19359);

return statearr_19354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19359,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19372 = [];
var len__5726__auto___19421 = arguments.length;
var i__5727__auto___19422 = (0);
while(true){
if((i__5727__auto___19422 < len__5726__auto___19421)){
args19372.push((arguments[i__5727__auto___19422]));

var G__19423 = (i__5727__auto___19422 + (1));
i__5727__auto___19422 = G__19423;
continue;
} else {
}
break;
}

var G__19374 = args19372.length;
switch (G__19374) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19372.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19425 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19425,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19425,out){
return (function (state_19398){
var state_val_19399 = (state_19398[(1)]);
if((state_val_19399 === (7))){
var inst_19380 = (state_19398[(7)]);
var inst_19380__$1 = (state_19398[(2)]);
var inst_19381 = (inst_19380__$1 == null);
var inst_19382 = cljs.core.not.call(null,inst_19381);
var state_19398__$1 = (function (){var statearr_19400 = state_19398;
(statearr_19400[(7)] = inst_19380__$1);

return statearr_19400;
})();
if(inst_19382){
var statearr_19401_19426 = state_19398__$1;
(statearr_19401_19426[(1)] = (8));

} else {
var statearr_19402_19427 = state_19398__$1;
(statearr_19402_19427[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (1))){
var inst_19375 = (0);
var state_19398__$1 = (function (){var statearr_19403 = state_19398;
(statearr_19403[(8)] = inst_19375);

return statearr_19403;
})();
var statearr_19404_19428 = state_19398__$1;
(statearr_19404_19428[(2)] = null);

(statearr_19404_19428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (4))){
var state_19398__$1 = state_19398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19398__$1,(7),ch);
} else {
if((state_val_19399 === (6))){
var inst_19393 = (state_19398[(2)]);
var state_19398__$1 = state_19398;
var statearr_19405_19429 = state_19398__$1;
(statearr_19405_19429[(2)] = inst_19393);

(statearr_19405_19429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (3))){
var inst_19395 = (state_19398[(2)]);
var inst_19396 = cljs.core.async.close_BANG_.call(null,out);
var state_19398__$1 = (function (){var statearr_19406 = state_19398;
(statearr_19406[(9)] = inst_19395);

return statearr_19406;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19398__$1,inst_19396);
} else {
if((state_val_19399 === (2))){
var inst_19375 = (state_19398[(8)]);
var inst_19377 = (inst_19375 < n);
var state_19398__$1 = state_19398;
if(cljs.core.truth_(inst_19377)){
var statearr_19407_19430 = state_19398__$1;
(statearr_19407_19430[(1)] = (4));

} else {
var statearr_19408_19431 = state_19398__$1;
(statearr_19408_19431[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (11))){
var inst_19375 = (state_19398[(8)]);
var inst_19385 = (state_19398[(2)]);
var inst_19386 = (inst_19375 + (1));
var inst_19375__$1 = inst_19386;
var state_19398__$1 = (function (){var statearr_19409 = state_19398;
(statearr_19409[(8)] = inst_19375__$1);

(statearr_19409[(10)] = inst_19385);

return statearr_19409;
})();
var statearr_19410_19432 = state_19398__$1;
(statearr_19410_19432[(2)] = null);

(statearr_19410_19432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (9))){
var state_19398__$1 = state_19398;
var statearr_19411_19433 = state_19398__$1;
(statearr_19411_19433[(2)] = null);

(statearr_19411_19433[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (5))){
var state_19398__$1 = state_19398;
var statearr_19412_19434 = state_19398__$1;
(statearr_19412_19434[(2)] = null);

(statearr_19412_19434[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (10))){
var inst_19390 = (state_19398[(2)]);
var state_19398__$1 = state_19398;
var statearr_19413_19435 = state_19398__$1;
(statearr_19413_19435[(2)] = inst_19390);

(statearr_19413_19435[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19399 === (8))){
var inst_19380 = (state_19398[(7)]);
var state_19398__$1 = state_19398;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19398__$1,(11),out,inst_19380);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19425,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19425,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19417 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19417[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19417[(1)] = (1));

return statearr_19417;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19398){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19418){if((e19418 instanceof Object)){
var ex__8254__auto__ = e19418;
var statearr_19419_19436 = state_19398;
(statearr_19419_19436[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19398);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19418;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19437 = state_19398;
state_19398 = G__19437;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19398){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19425,out))
})();
var state__8364__auto__ = (function (){var statearr_19420 = f__8363__auto__.call(null);
(statearr_19420[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19425);

return statearr_19420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19425,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19445 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19445 = (function (map_LT_,f,ch,meta19446){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19446 = meta19446;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19447,meta19446__$1){
var self__ = this;
var _19447__$1 = this;
return (new cljs.core.async.t_cljs$core$async19445(self__.map_LT_,self__.f,self__.ch,meta19446__$1));
});

cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19447){
var self__ = this;
var _19447__$1 = this;
return self__.meta19446;
});

cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19448 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19448 = (function (map_LT_,f,ch,meta19446,_,fn1,meta19449){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19446 = meta19446;
this._ = _;
this.fn1 = fn1;
this.meta19449 = meta19449;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19448.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19450,meta19449__$1){
var self__ = this;
var _19450__$1 = this;
return (new cljs.core.async.t_cljs$core$async19448(self__.map_LT_,self__.f,self__.ch,self__.meta19446,self__._,self__.fn1,meta19449__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19448.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19450){
var self__ = this;
var _19450__$1 = this;
return self__.meta19449;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19448.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19448.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19448.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19448.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19438_SHARP_){
return f1.call(null,(((p1__19438_SHARP_ == null))?null:self__.f.call(null,p1__19438_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19448.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19446","meta19446",-1609743997,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19445","cljs.core.async/t_cljs$core$async19445",-97899332,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19449","meta19449",1524631280,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19448.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19448.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19448";

cljs.core.async.t_cljs$core$async19448.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19448");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19448 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19448(map_LT___$1,f__$1,ch__$1,meta19446__$1,___$2,fn1__$1,meta19449){
return (new cljs.core.async.t_cljs$core$async19448(map_LT___$1,f__$1,ch__$1,meta19446__$1,___$2,fn1__$1,meta19449));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19448(self__.map_LT_,self__.f,self__.ch,self__.meta19446,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19445.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19445.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19446","meta19446",-1609743997,null)], null);
});

cljs.core.async.t_cljs$core$async19445.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19445.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19445";

cljs.core.async.t_cljs$core$async19445.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19445");
});

cljs.core.async.__GT_t_cljs$core$async19445 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19445(map_LT___$1,f__$1,ch__$1,meta19446){
return (new cljs.core.async.t_cljs$core$async19445(map_LT___$1,f__$1,ch__$1,meta19446));
});

}

return (new cljs.core.async.t_cljs$core$async19445(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19454 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19454 = (function (map_GT_,f,ch,meta19455){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19455 = meta19455;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19454.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19456,meta19455__$1){
var self__ = this;
var _19456__$1 = this;
return (new cljs.core.async.t_cljs$core$async19454(self__.map_GT_,self__.f,self__.ch,meta19455__$1));
});

cljs.core.async.t_cljs$core$async19454.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19456){
var self__ = this;
var _19456__$1 = this;
return self__.meta19455;
});

cljs.core.async.t_cljs$core$async19454.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19454.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19454.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19454.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19454.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19454.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19454.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19455","meta19455",-1330761936,null)], null);
});

cljs.core.async.t_cljs$core$async19454.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19454.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19454";

cljs.core.async.t_cljs$core$async19454.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19454");
});

cljs.core.async.__GT_t_cljs$core$async19454 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19454(map_GT___$1,f__$1,ch__$1,meta19455){
return (new cljs.core.async.t_cljs$core$async19454(map_GT___$1,f__$1,ch__$1,meta19455));
});

}

return (new cljs.core.async.t_cljs$core$async19454(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19460 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19460 = (function (filter_GT_,p,ch,meta19461){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19461 = meta19461;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19462,meta19461__$1){
var self__ = this;
var _19462__$1 = this;
return (new cljs.core.async.t_cljs$core$async19460(self__.filter_GT_,self__.p,self__.ch,meta19461__$1));
});

cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19462){
var self__ = this;
var _19462__$1 = this;
return self__.meta19461;
});

cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19460.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19460.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19461","meta19461",1096473145,null)], null);
});

cljs.core.async.t_cljs$core$async19460.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19460.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19460";

cljs.core.async.t_cljs$core$async19460.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19460");
});

cljs.core.async.__GT_t_cljs$core$async19460 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19460(filter_GT___$1,p__$1,ch__$1,meta19461){
return (new cljs.core.async.t_cljs$core$async19460(filter_GT___$1,p__$1,ch__$1,meta19461));
});

}

return (new cljs.core.async.t_cljs$core$async19460(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19463 = [];
var len__5726__auto___19507 = arguments.length;
var i__5727__auto___19508 = (0);
while(true){
if((i__5727__auto___19508 < len__5726__auto___19507)){
args19463.push((arguments[i__5727__auto___19508]));

var G__19509 = (i__5727__auto___19508 + (1));
i__5727__auto___19508 = G__19509;
continue;
} else {
}
break;
}

var G__19465 = args19463.length;
switch (G__19465) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19463.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19511 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19511,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19511,out){
return (function (state_19486){
var state_val_19487 = (state_19486[(1)]);
if((state_val_19487 === (7))){
var inst_19482 = (state_19486[(2)]);
var state_19486__$1 = state_19486;
var statearr_19488_19512 = state_19486__$1;
(statearr_19488_19512[(2)] = inst_19482);

(statearr_19488_19512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (1))){
var state_19486__$1 = state_19486;
var statearr_19489_19513 = state_19486__$1;
(statearr_19489_19513[(2)] = null);

(statearr_19489_19513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (4))){
var inst_19468 = (state_19486[(7)]);
var inst_19468__$1 = (state_19486[(2)]);
var inst_19469 = (inst_19468__$1 == null);
var state_19486__$1 = (function (){var statearr_19490 = state_19486;
(statearr_19490[(7)] = inst_19468__$1);

return statearr_19490;
})();
if(cljs.core.truth_(inst_19469)){
var statearr_19491_19514 = state_19486__$1;
(statearr_19491_19514[(1)] = (5));

} else {
var statearr_19492_19515 = state_19486__$1;
(statearr_19492_19515[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (6))){
var inst_19468 = (state_19486[(7)]);
var inst_19473 = p.call(null,inst_19468);
var state_19486__$1 = state_19486;
if(cljs.core.truth_(inst_19473)){
var statearr_19493_19516 = state_19486__$1;
(statearr_19493_19516[(1)] = (8));

} else {
var statearr_19494_19517 = state_19486__$1;
(statearr_19494_19517[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (3))){
var inst_19484 = (state_19486[(2)]);
var state_19486__$1 = state_19486;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19486__$1,inst_19484);
} else {
if((state_val_19487 === (2))){
var state_19486__$1 = state_19486;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19486__$1,(4),ch);
} else {
if((state_val_19487 === (11))){
var inst_19476 = (state_19486[(2)]);
var state_19486__$1 = state_19486;
var statearr_19495_19518 = state_19486__$1;
(statearr_19495_19518[(2)] = inst_19476);

(statearr_19495_19518[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (9))){
var state_19486__$1 = state_19486;
var statearr_19496_19519 = state_19486__$1;
(statearr_19496_19519[(2)] = null);

(statearr_19496_19519[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (5))){
var inst_19471 = cljs.core.async.close_BANG_.call(null,out);
var state_19486__$1 = state_19486;
var statearr_19497_19520 = state_19486__$1;
(statearr_19497_19520[(2)] = inst_19471);

(statearr_19497_19520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (10))){
var inst_19479 = (state_19486[(2)]);
var state_19486__$1 = (function (){var statearr_19498 = state_19486;
(statearr_19498[(8)] = inst_19479);

return statearr_19498;
})();
var statearr_19499_19521 = state_19486__$1;
(statearr_19499_19521[(2)] = null);

(statearr_19499_19521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (8))){
var inst_19468 = (state_19486[(7)]);
var state_19486__$1 = state_19486;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19486__$1,(11),out,inst_19468);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19511,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19511,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19503 = [null,null,null,null,null,null,null,null,null];
(statearr_19503[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19503[(1)] = (1));

return statearr_19503;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19486){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19486);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19504){if((e19504 instanceof Object)){
var ex__8254__auto__ = e19504;
var statearr_19505_19522 = state_19486;
(statearr_19505_19522[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19486);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19504;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19523 = state_19486;
state_19486 = G__19523;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19486){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19511,out))
})();
var state__8364__auto__ = (function (){var statearr_19506 = f__8363__auto__.call(null);
(statearr_19506[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19511);

return statearr_19506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19511,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19524 = [];
var len__5726__auto___19527 = arguments.length;
var i__5727__auto___19528 = (0);
while(true){
if((i__5727__auto___19528 < len__5726__auto___19527)){
args19524.push((arguments[i__5727__auto___19528]));

var G__19529 = (i__5727__auto___19528 + (1));
i__5727__auto___19528 = G__19529;
continue;
} else {
}
break;
}

var G__19526 = args19524.length;
switch (G__19526) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19524.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19696){
var state_val_19697 = (state_19696[(1)]);
if((state_val_19697 === (7))){
var inst_19692 = (state_19696[(2)]);
var state_19696__$1 = state_19696;
var statearr_19698_19739 = state_19696__$1;
(statearr_19698_19739[(2)] = inst_19692);

(statearr_19698_19739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (20))){
var inst_19662 = (state_19696[(7)]);
var inst_19673 = (state_19696[(2)]);
var inst_19674 = cljs.core.next.call(null,inst_19662);
var inst_19648 = inst_19674;
var inst_19649 = null;
var inst_19650 = (0);
var inst_19651 = (0);
var state_19696__$1 = (function (){var statearr_19699 = state_19696;
(statearr_19699[(8)] = inst_19649);

(statearr_19699[(9)] = inst_19651);

(statearr_19699[(10)] = inst_19650);

(statearr_19699[(11)] = inst_19673);

(statearr_19699[(12)] = inst_19648);

return statearr_19699;
})();
var statearr_19700_19740 = state_19696__$1;
(statearr_19700_19740[(2)] = null);

(statearr_19700_19740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (1))){
var state_19696__$1 = state_19696;
var statearr_19701_19741 = state_19696__$1;
(statearr_19701_19741[(2)] = null);

(statearr_19701_19741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (4))){
var inst_19637 = (state_19696[(13)]);
var inst_19637__$1 = (state_19696[(2)]);
var inst_19638 = (inst_19637__$1 == null);
var state_19696__$1 = (function (){var statearr_19702 = state_19696;
(statearr_19702[(13)] = inst_19637__$1);

return statearr_19702;
})();
if(cljs.core.truth_(inst_19638)){
var statearr_19703_19742 = state_19696__$1;
(statearr_19703_19742[(1)] = (5));

} else {
var statearr_19704_19743 = state_19696__$1;
(statearr_19704_19743[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (15))){
var state_19696__$1 = state_19696;
var statearr_19708_19744 = state_19696__$1;
(statearr_19708_19744[(2)] = null);

(statearr_19708_19744[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (21))){
var state_19696__$1 = state_19696;
var statearr_19709_19745 = state_19696__$1;
(statearr_19709_19745[(2)] = null);

(statearr_19709_19745[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (13))){
var inst_19649 = (state_19696[(8)]);
var inst_19651 = (state_19696[(9)]);
var inst_19650 = (state_19696[(10)]);
var inst_19648 = (state_19696[(12)]);
var inst_19658 = (state_19696[(2)]);
var inst_19659 = (inst_19651 + (1));
var tmp19705 = inst_19649;
var tmp19706 = inst_19650;
var tmp19707 = inst_19648;
var inst_19648__$1 = tmp19707;
var inst_19649__$1 = tmp19705;
var inst_19650__$1 = tmp19706;
var inst_19651__$1 = inst_19659;
var state_19696__$1 = (function (){var statearr_19710 = state_19696;
(statearr_19710[(8)] = inst_19649__$1);

(statearr_19710[(9)] = inst_19651__$1);

(statearr_19710[(10)] = inst_19650__$1);

(statearr_19710[(14)] = inst_19658);

(statearr_19710[(12)] = inst_19648__$1);

return statearr_19710;
})();
var statearr_19711_19746 = state_19696__$1;
(statearr_19711_19746[(2)] = null);

(statearr_19711_19746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (22))){
var state_19696__$1 = state_19696;
var statearr_19712_19747 = state_19696__$1;
(statearr_19712_19747[(2)] = null);

(statearr_19712_19747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (6))){
var inst_19637 = (state_19696[(13)]);
var inst_19646 = f.call(null,inst_19637);
var inst_19647 = cljs.core.seq.call(null,inst_19646);
var inst_19648 = inst_19647;
var inst_19649 = null;
var inst_19650 = (0);
var inst_19651 = (0);
var state_19696__$1 = (function (){var statearr_19713 = state_19696;
(statearr_19713[(8)] = inst_19649);

(statearr_19713[(9)] = inst_19651);

(statearr_19713[(10)] = inst_19650);

(statearr_19713[(12)] = inst_19648);

return statearr_19713;
})();
var statearr_19714_19748 = state_19696__$1;
(statearr_19714_19748[(2)] = null);

(statearr_19714_19748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (17))){
var inst_19662 = (state_19696[(7)]);
var inst_19666 = cljs.core.chunk_first.call(null,inst_19662);
var inst_19667 = cljs.core.chunk_rest.call(null,inst_19662);
var inst_19668 = cljs.core.count.call(null,inst_19666);
var inst_19648 = inst_19667;
var inst_19649 = inst_19666;
var inst_19650 = inst_19668;
var inst_19651 = (0);
var state_19696__$1 = (function (){var statearr_19715 = state_19696;
(statearr_19715[(8)] = inst_19649);

(statearr_19715[(9)] = inst_19651);

(statearr_19715[(10)] = inst_19650);

(statearr_19715[(12)] = inst_19648);

return statearr_19715;
})();
var statearr_19716_19749 = state_19696__$1;
(statearr_19716_19749[(2)] = null);

(statearr_19716_19749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (3))){
var inst_19694 = (state_19696[(2)]);
var state_19696__$1 = state_19696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19696__$1,inst_19694);
} else {
if((state_val_19697 === (12))){
var inst_19682 = (state_19696[(2)]);
var state_19696__$1 = state_19696;
var statearr_19717_19750 = state_19696__$1;
(statearr_19717_19750[(2)] = inst_19682);

(statearr_19717_19750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (2))){
var state_19696__$1 = state_19696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19696__$1,(4),in$);
} else {
if((state_val_19697 === (23))){
var inst_19690 = (state_19696[(2)]);
var state_19696__$1 = state_19696;
var statearr_19718_19751 = state_19696__$1;
(statearr_19718_19751[(2)] = inst_19690);

(statearr_19718_19751[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (19))){
var inst_19677 = (state_19696[(2)]);
var state_19696__$1 = state_19696;
var statearr_19719_19752 = state_19696__$1;
(statearr_19719_19752[(2)] = inst_19677);

(statearr_19719_19752[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (11))){
var inst_19662 = (state_19696[(7)]);
var inst_19648 = (state_19696[(12)]);
var inst_19662__$1 = cljs.core.seq.call(null,inst_19648);
var state_19696__$1 = (function (){var statearr_19720 = state_19696;
(statearr_19720[(7)] = inst_19662__$1);

return statearr_19720;
})();
if(inst_19662__$1){
var statearr_19721_19753 = state_19696__$1;
(statearr_19721_19753[(1)] = (14));

} else {
var statearr_19722_19754 = state_19696__$1;
(statearr_19722_19754[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (9))){
var inst_19684 = (state_19696[(2)]);
var inst_19685 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19696__$1 = (function (){var statearr_19723 = state_19696;
(statearr_19723[(15)] = inst_19684);

return statearr_19723;
})();
if(cljs.core.truth_(inst_19685)){
var statearr_19724_19755 = state_19696__$1;
(statearr_19724_19755[(1)] = (21));

} else {
var statearr_19725_19756 = state_19696__$1;
(statearr_19725_19756[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (5))){
var inst_19640 = cljs.core.async.close_BANG_.call(null,out);
var state_19696__$1 = state_19696;
var statearr_19726_19757 = state_19696__$1;
(statearr_19726_19757[(2)] = inst_19640);

(statearr_19726_19757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (14))){
var inst_19662 = (state_19696[(7)]);
var inst_19664 = cljs.core.chunked_seq_QMARK_.call(null,inst_19662);
var state_19696__$1 = state_19696;
if(inst_19664){
var statearr_19727_19758 = state_19696__$1;
(statearr_19727_19758[(1)] = (17));

} else {
var statearr_19728_19759 = state_19696__$1;
(statearr_19728_19759[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (16))){
var inst_19680 = (state_19696[(2)]);
var state_19696__$1 = state_19696;
var statearr_19729_19760 = state_19696__$1;
(statearr_19729_19760[(2)] = inst_19680);

(statearr_19729_19760[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19697 === (10))){
var inst_19649 = (state_19696[(8)]);
var inst_19651 = (state_19696[(9)]);
var inst_19656 = cljs.core._nth.call(null,inst_19649,inst_19651);
var state_19696__$1 = state_19696;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19696__$1,(13),out,inst_19656);
} else {
if((state_val_19697 === (18))){
var inst_19662 = (state_19696[(7)]);
var inst_19671 = cljs.core.first.call(null,inst_19662);
var state_19696__$1 = state_19696;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19696__$1,(20),out,inst_19671);
} else {
if((state_val_19697 === (8))){
var inst_19651 = (state_19696[(9)]);
var inst_19650 = (state_19696[(10)]);
var inst_19653 = (inst_19651 < inst_19650);
var inst_19654 = inst_19653;
var state_19696__$1 = state_19696;
if(cljs.core.truth_(inst_19654)){
var statearr_19730_19761 = state_19696__$1;
(statearr_19730_19761[(1)] = (10));

} else {
var statearr_19731_19762 = state_19696__$1;
(statearr_19731_19762[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19735 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19735[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19735[(1)] = (1));

return statearr_19735;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19696){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19736){if((e19736 instanceof Object)){
var ex__8254__auto__ = e19736;
var statearr_19737_19763 = state_19696;
(statearr_19737_19763[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19696);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19736;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19764 = state_19696;
state_19696 = G__19764;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19696){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19738 = f__8363__auto__.call(null);
(statearr_19738[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19765 = [];
var len__5726__auto___19768 = arguments.length;
var i__5727__auto___19769 = (0);
while(true){
if((i__5727__auto___19769 < len__5726__auto___19768)){
args19765.push((arguments[i__5727__auto___19769]));

var G__19770 = (i__5727__auto___19769 + (1));
i__5727__auto___19769 = G__19770;
continue;
} else {
}
break;
}

var G__19767 = args19765.length;
switch (G__19767) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19765.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19772 = [];
var len__5726__auto___19775 = arguments.length;
var i__5727__auto___19776 = (0);
while(true){
if((i__5727__auto___19776 < len__5726__auto___19775)){
args19772.push((arguments[i__5727__auto___19776]));

var G__19777 = (i__5727__auto___19776 + (1));
i__5727__auto___19776 = G__19777;
continue;
} else {
}
break;
}

var G__19774 = args19772.length;
switch (G__19774) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19772.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19779 = [];
var len__5726__auto___19830 = arguments.length;
var i__5727__auto___19831 = (0);
while(true){
if((i__5727__auto___19831 < len__5726__auto___19830)){
args19779.push((arguments[i__5727__auto___19831]));

var G__19832 = (i__5727__auto___19831 + (1));
i__5727__auto___19831 = G__19832;
continue;
} else {
}
break;
}

var G__19781 = args19779.length;
switch (G__19781) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19779.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19834 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19834,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19834,out){
return (function (state_19805){
var state_val_19806 = (state_19805[(1)]);
if((state_val_19806 === (7))){
var inst_19800 = (state_19805[(2)]);
var state_19805__$1 = state_19805;
var statearr_19807_19835 = state_19805__$1;
(statearr_19807_19835[(2)] = inst_19800);

(statearr_19807_19835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19806 === (1))){
var inst_19782 = null;
var state_19805__$1 = (function (){var statearr_19808 = state_19805;
(statearr_19808[(7)] = inst_19782);

return statearr_19808;
})();
var statearr_19809_19836 = state_19805__$1;
(statearr_19809_19836[(2)] = null);

(statearr_19809_19836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19806 === (4))){
var inst_19785 = (state_19805[(8)]);
var inst_19785__$1 = (state_19805[(2)]);
var inst_19786 = (inst_19785__$1 == null);
var inst_19787 = cljs.core.not.call(null,inst_19786);
var state_19805__$1 = (function (){var statearr_19810 = state_19805;
(statearr_19810[(8)] = inst_19785__$1);

return statearr_19810;
})();
if(inst_19787){
var statearr_19811_19837 = state_19805__$1;
(statearr_19811_19837[(1)] = (5));

} else {
var statearr_19812_19838 = state_19805__$1;
(statearr_19812_19838[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19806 === (6))){
var state_19805__$1 = state_19805;
var statearr_19813_19839 = state_19805__$1;
(statearr_19813_19839[(2)] = null);

(statearr_19813_19839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19806 === (3))){
var inst_19802 = (state_19805[(2)]);
var inst_19803 = cljs.core.async.close_BANG_.call(null,out);
var state_19805__$1 = (function (){var statearr_19814 = state_19805;
(statearr_19814[(9)] = inst_19802);

return statearr_19814;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19805__$1,inst_19803);
} else {
if((state_val_19806 === (2))){
var state_19805__$1 = state_19805;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19805__$1,(4),ch);
} else {
if((state_val_19806 === (11))){
var inst_19785 = (state_19805[(8)]);
var inst_19794 = (state_19805[(2)]);
var inst_19782 = inst_19785;
var state_19805__$1 = (function (){var statearr_19815 = state_19805;
(statearr_19815[(10)] = inst_19794);

(statearr_19815[(7)] = inst_19782);

return statearr_19815;
})();
var statearr_19816_19840 = state_19805__$1;
(statearr_19816_19840[(2)] = null);

(statearr_19816_19840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19806 === (9))){
var inst_19785 = (state_19805[(8)]);
var state_19805__$1 = state_19805;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19805__$1,(11),out,inst_19785);
} else {
if((state_val_19806 === (5))){
var inst_19785 = (state_19805[(8)]);
var inst_19782 = (state_19805[(7)]);
var inst_19789 = cljs.core._EQ_.call(null,inst_19785,inst_19782);
var state_19805__$1 = state_19805;
if(inst_19789){
var statearr_19818_19841 = state_19805__$1;
(statearr_19818_19841[(1)] = (8));

} else {
var statearr_19819_19842 = state_19805__$1;
(statearr_19819_19842[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19806 === (10))){
var inst_19797 = (state_19805[(2)]);
var state_19805__$1 = state_19805;
var statearr_19820_19843 = state_19805__$1;
(statearr_19820_19843[(2)] = inst_19797);

(statearr_19820_19843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19806 === (8))){
var inst_19782 = (state_19805[(7)]);
var tmp19817 = inst_19782;
var inst_19782__$1 = tmp19817;
var state_19805__$1 = (function (){var statearr_19821 = state_19805;
(statearr_19821[(7)] = inst_19782__$1);

return statearr_19821;
})();
var statearr_19822_19844 = state_19805__$1;
(statearr_19822_19844[(2)] = null);

(statearr_19822_19844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19834,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19834,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19826 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19826[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19826[(1)] = (1));

return statearr_19826;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19805){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19805);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19827){if((e19827 instanceof Object)){
var ex__8254__auto__ = e19827;
var statearr_19828_19845 = state_19805;
(statearr_19828_19845[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19805);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19827;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19846 = state_19805;
state_19805 = G__19846;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19805){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19834,out))
})();
var state__8364__auto__ = (function (){var statearr_19829 = f__8363__auto__.call(null);
(statearr_19829[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19834);

return statearr_19829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19834,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19847 = [];
var len__5726__auto___19917 = arguments.length;
var i__5727__auto___19918 = (0);
while(true){
if((i__5727__auto___19918 < len__5726__auto___19917)){
args19847.push((arguments[i__5727__auto___19918]));

var G__19919 = (i__5727__auto___19918 + (1));
i__5727__auto___19918 = G__19919;
continue;
} else {
}
break;
}

var G__19849 = args19847.length;
switch (G__19849) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19847.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19921 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19921,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19921,out){
return (function (state_19887){
var state_val_19888 = (state_19887[(1)]);
if((state_val_19888 === (7))){
var inst_19883 = (state_19887[(2)]);
var state_19887__$1 = state_19887;
var statearr_19889_19922 = state_19887__$1;
(statearr_19889_19922[(2)] = inst_19883);

(statearr_19889_19922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (1))){
var inst_19850 = (new Array(n));
var inst_19851 = inst_19850;
var inst_19852 = (0);
var state_19887__$1 = (function (){var statearr_19890 = state_19887;
(statearr_19890[(7)] = inst_19852);

(statearr_19890[(8)] = inst_19851);

return statearr_19890;
})();
var statearr_19891_19923 = state_19887__$1;
(statearr_19891_19923[(2)] = null);

(statearr_19891_19923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (4))){
var inst_19855 = (state_19887[(9)]);
var inst_19855__$1 = (state_19887[(2)]);
var inst_19856 = (inst_19855__$1 == null);
var inst_19857 = cljs.core.not.call(null,inst_19856);
var state_19887__$1 = (function (){var statearr_19892 = state_19887;
(statearr_19892[(9)] = inst_19855__$1);

return statearr_19892;
})();
if(inst_19857){
var statearr_19893_19924 = state_19887__$1;
(statearr_19893_19924[(1)] = (5));

} else {
var statearr_19894_19925 = state_19887__$1;
(statearr_19894_19925[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (15))){
var inst_19877 = (state_19887[(2)]);
var state_19887__$1 = state_19887;
var statearr_19895_19926 = state_19887__$1;
(statearr_19895_19926[(2)] = inst_19877);

(statearr_19895_19926[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (13))){
var state_19887__$1 = state_19887;
var statearr_19896_19927 = state_19887__$1;
(statearr_19896_19927[(2)] = null);

(statearr_19896_19927[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (6))){
var inst_19852 = (state_19887[(7)]);
var inst_19873 = (inst_19852 > (0));
var state_19887__$1 = state_19887;
if(cljs.core.truth_(inst_19873)){
var statearr_19897_19928 = state_19887__$1;
(statearr_19897_19928[(1)] = (12));

} else {
var statearr_19898_19929 = state_19887__$1;
(statearr_19898_19929[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (3))){
var inst_19885 = (state_19887[(2)]);
var state_19887__$1 = state_19887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19887__$1,inst_19885);
} else {
if((state_val_19888 === (12))){
var inst_19851 = (state_19887[(8)]);
var inst_19875 = cljs.core.vec.call(null,inst_19851);
var state_19887__$1 = state_19887;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19887__$1,(15),out,inst_19875);
} else {
if((state_val_19888 === (2))){
var state_19887__$1 = state_19887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19887__$1,(4),ch);
} else {
if((state_val_19888 === (11))){
var inst_19867 = (state_19887[(2)]);
var inst_19868 = (new Array(n));
var inst_19851 = inst_19868;
var inst_19852 = (0);
var state_19887__$1 = (function (){var statearr_19899 = state_19887;
(statearr_19899[(10)] = inst_19867);

(statearr_19899[(7)] = inst_19852);

(statearr_19899[(8)] = inst_19851);

return statearr_19899;
})();
var statearr_19900_19930 = state_19887__$1;
(statearr_19900_19930[(2)] = null);

(statearr_19900_19930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (9))){
var inst_19851 = (state_19887[(8)]);
var inst_19865 = cljs.core.vec.call(null,inst_19851);
var state_19887__$1 = state_19887;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19887__$1,(11),out,inst_19865);
} else {
if((state_val_19888 === (5))){
var inst_19860 = (state_19887[(11)]);
var inst_19852 = (state_19887[(7)]);
var inst_19855 = (state_19887[(9)]);
var inst_19851 = (state_19887[(8)]);
var inst_19859 = (inst_19851[inst_19852] = inst_19855);
var inst_19860__$1 = (inst_19852 + (1));
var inst_19861 = (inst_19860__$1 < n);
var state_19887__$1 = (function (){var statearr_19901 = state_19887;
(statearr_19901[(11)] = inst_19860__$1);

(statearr_19901[(12)] = inst_19859);

return statearr_19901;
})();
if(cljs.core.truth_(inst_19861)){
var statearr_19902_19931 = state_19887__$1;
(statearr_19902_19931[(1)] = (8));

} else {
var statearr_19903_19932 = state_19887__$1;
(statearr_19903_19932[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (14))){
var inst_19880 = (state_19887[(2)]);
var inst_19881 = cljs.core.async.close_BANG_.call(null,out);
var state_19887__$1 = (function (){var statearr_19905 = state_19887;
(statearr_19905[(13)] = inst_19880);

return statearr_19905;
})();
var statearr_19906_19933 = state_19887__$1;
(statearr_19906_19933[(2)] = inst_19881);

(statearr_19906_19933[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (10))){
var inst_19871 = (state_19887[(2)]);
var state_19887__$1 = state_19887;
var statearr_19907_19934 = state_19887__$1;
(statearr_19907_19934[(2)] = inst_19871);

(statearr_19907_19934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19888 === (8))){
var inst_19860 = (state_19887[(11)]);
var inst_19851 = (state_19887[(8)]);
var tmp19904 = inst_19851;
var inst_19851__$1 = tmp19904;
var inst_19852 = inst_19860;
var state_19887__$1 = (function (){var statearr_19908 = state_19887;
(statearr_19908[(7)] = inst_19852);

(statearr_19908[(8)] = inst_19851__$1);

return statearr_19908;
})();
var statearr_19909_19935 = state_19887__$1;
(statearr_19909_19935[(2)] = null);

(statearr_19909_19935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19921,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19921,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19913 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19913[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19913[(1)] = (1));

return statearr_19913;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19887){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19914){if((e19914 instanceof Object)){
var ex__8254__auto__ = e19914;
var statearr_19915_19936 = state_19887;
(statearr_19915_19936[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19887);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19914;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19937 = state_19887;
state_19887 = G__19937;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19887){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19921,out))
})();
var state__8364__auto__ = (function (){var statearr_19916 = f__8363__auto__.call(null);
(statearr_19916[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19921);

return statearr_19916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19921,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19938 = [];
var len__5726__auto___20012 = arguments.length;
var i__5727__auto___20013 = (0);
while(true){
if((i__5727__auto___20013 < len__5726__auto___20012)){
args19938.push((arguments[i__5727__auto___20013]));

var G__20014 = (i__5727__auto___20013 + (1));
i__5727__auto___20013 = G__20014;
continue;
} else {
}
break;
}

var G__19940 = args19938.length;
switch (G__19940) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19938.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20016 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20016,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20016,out){
return (function (state_19982){
var state_val_19983 = (state_19982[(1)]);
if((state_val_19983 === (7))){
var inst_19978 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
var statearr_19984_20017 = state_19982__$1;
(statearr_19984_20017[(2)] = inst_19978);

(statearr_19984_20017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (1))){
var inst_19941 = [];
var inst_19942 = inst_19941;
var inst_19943 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19982__$1 = (function (){var statearr_19985 = state_19982;
(statearr_19985[(7)] = inst_19942);

(statearr_19985[(8)] = inst_19943);

return statearr_19985;
})();
var statearr_19986_20018 = state_19982__$1;
(statearr_19986_20018[(2)] = null);

(statearr_19986_20018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (4))){
var inst_19946 = (state_19982[(9)]);
var inst_19946__$1 = (state_19982[(2)]);
var inst_19947 = (inst_19946__$1 == null);
var inst_19948 = cljs.core.not.call(null,inst_19947);
var state_19982__$1 = (function (){var statearr_19987 = state_19982;
(statearr_19987[(9)] = inst_19946__$1);

return statearr_19987;
})();
if(inst_19948){
var statearr_19988_20019 = state_19982__$1;
(statearr_19988_20019[(1)] = (5));

} else {
var statearr_19989_20020 = state_19982__$1;
(statearr_19989_20020[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (15))){
var inst_19972 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
var statearr_19990_20021 = state_19982__$1;
(statearr_19990_20021[(2)] = inst_19972);

(statearr_19990_20021[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (13))){
var state_19982__$1 = state_19982;
var statearr_19991_20022 = state_19982__$1;
(statearr_19991_20022[(2)] = null);

(statearr_19991_20022[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (6))){
var inst_19942 = (state_19982[(7)]);
var inst_19967 = inst_19942.length;
var inst_19968 = (inst_19967 > (0));
var state_19982__$1 = state_19982;
if(cljs.core.truth_(inst_19968)){
var statearr_19992_20023 = state_19982__$1;
(statearr_19992_20023[(1)] = (12));

} else {
var statearr_19993_20024 = state_19982__$1;
(statearr_19993_20024[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (3))){
var inst_19980 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19982__$1,inst_19980);
} else {
if((state_val_19983 === (12))){
var inst_19942 = (state_19982[(7)]);
var inst_19970 = cljs.core.vec.call(null,inst_19942);
var state_19982__$1 = state_19982;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19982__$1,(15),out,inst_19970);
} else {
if((state_val_19983 === (2))){
var state_19982__$1 = state_19982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19982__$1,(4),ch);
} else {
if((state_val_19983 === (11))){
var inst_19946 = (state_19982[(9)]);
var inst_19950 = (state_19982[(10)]);
var inst_19960 = (state_19982[(2)]);
var inst_19961 = [];
var inst_19962 = inst_19961.push(inst_19946);
var inst_19942 = inst_19961;
var inst_19943 = inst_19950;
var state_19982__$1 = (function (){var statearr_19994 = state_19982;
(statearr_19994[(7)] = inst_19942);

(statearr_19994[(11)] = inst_19962);

(statearr_19994[(8)] = inst_19943);

(statearr_19994[(12)] = inst_19960);

return statearr_19994;
})();
var statearr_19995_20025 = state_19982__$1;
(statearr_19995_20025[(2)] = null);

(statearr_19995_20025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (9))){
var inst_19942 = (state_19982[(7)]);
var inst_19958 = cljs.core.vec.call(null,inst_19942);
var state_19982__$1 = state_19982;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19982__$1,(11),out,inst_19958);
} else {
if((state_val_19983 === (5))){
var inst_19946 = (state_19982[(9)]);
var inst_19943 = (state_19982[(8)]);
var inst_19950 = (state_19982[(10)]);
var inst_19950__$1 = f.call(null,inst_19946);
var inst_19951 = cljs.core._EQ_.call(null,inst_19950__$1,inst_19943);
var inst_19952 = cljs.core.keyword_identical_QMARK_.call(null,inst_19943,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19953 = (inst_19951) || (inst_19952);
var state_19982__$1 = (function (){var statearr_19996 = state_19982;
(statearr_19996[(10)] = inst_19950__$1);

return statearr_19996;
})();
if(cljs.core.truth_(inst_19953)){
var statearr_19997_20026 = state_19982__$1;
(statearr_19997_20026[(1)] = (8));

} else {
var statearr_19998_20027 = state_19982__$1;
(statearr_19998_20027[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (14))){
var inst_19975 = (state_19982[(2)]);
var inst_19976 = cljs.core.async.close_BANG_.call(null,out);
var state_19982__$1 = (function (){var statearr_20000 = state_19982;
(statearr_20000[(13)] = inst_19975);

return statearr_20000;
})();
var statearr_20001_20028 = state_19982__$1;
(statearr_20001_20028[(2)] = inst_19976);

(statearr_20001_20028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (10))){
var inst_19965 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
var statearr_20002_20029 = state_19982__$1;
(statearr_20002_20029[(2)] = inst_19965);

(statearr_20002_20029[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (8))){
var inst_19942 = (state_19982[(7)]);
var inst_19946 = (state_19982[(9)]);
var inst_19950 = (state_19982[(10)]);
var inst_19955 = inst_19942.push(inst_19946);
var tmp19999 = inst_19942;
var inst_19942__$1 = tmp19999;
var inst_19943 = inst_19950;
var state_19982__$1 = (function (){var statearr_20003 = state_19982;
(statearr_20003[(7)] = inst_19942__$1);

(statearr_20003[(8)] = inst_19943);

(statearr_20003[(14)] = inst_19955);

return statearr_20003;
})();
var statearr_20004_20030 = state_19982__$1;
(statearr_20004_20030[(2)] = null);

(statearr_20004_20030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20016,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20016,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_20008 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20008[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_20008[(1)] = (1));

return statearr_20008;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19982){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e20009){if((e20009 instanceof Object)){
var ex__8254__auto__ = e20009;
var statearr_20010_20031 = state_19982;
(statearr_20010_20031[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19982);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20032 = state_19982;
state_19982 = G__20032;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19982){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20016,out))
})();
var state__8364__auto__ = (function (){var statearr_20011 = f__8363__auto__.call(null);
(statearr_20011[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20016);

return statearr_20011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20016,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1457336524714