// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__20131__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__20130 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__20130,(0),null);
var body = cljs.core.nthnext.call(null,vec__20130,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__20131 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__20132__i = 0, G__20132__a = new Array(arguments.length -  0);
while (G__20132__i < G__20132__a.length) {G__20132__a[G__20132__i] = arguments[G__20132__i + 0]; ++G__20132__i;}
  args = new cljs.core.IndexedSeq(G__20132__a,0);
} 
return G__20131__delegate.call(this,args);};
G__20131.cljs$lang$maxFixedArity = 0;
G__20131.cljs$lang$applyTo = (function (arglist__20133){
var args = cljs.core.seq(arglist__20133);
return G__20131__delegate(args);
});
G__20131.cljs$core$IFn$_invoke$arity$variadic = G__20131__delegate;
return G__20131;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__20138(s__20139){
return (new cljs.core.LazySeq(null,(function (){
var s__20139__$1 = s__20139;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20139__$1);
if(temp__4425__auto__){
var s__20139__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20139__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20139__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20141 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20140 = (0);
while(true){
if((i__20140 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__20140);
cljs.core.chunk_append.call(null,b__20141,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__20142 = (i__20140 + (1));
i__20140 = G__20142;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20141),sablono$core$update_arglists_$_iter__20138.call(null,cljs.core.chunk_rest.call(null,s__20139__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20141),null);
}
} else {
var args = cljs.core.first.call(null,s__20139__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__20138.call(null,cljs.core.rest.call(null,s__20139__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20148 = arguments.length;
var i__5727__auto___20149 = (0);
while(true){
if((i__5727__auto___20149 < len__5726__auto___20148)){
args__5733__auto__.push((arguments[i__5727__auto___20149]));

var G__20150 = (i__5727__auto___20149 + (1));
i__5727__auto___20149 = G__20150;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__20144(s__20145){
return (new cljs.core.LazySeq(null,(function (){
var s__20145__$1 = s__20145;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20145__$1);
if(temp__4425__auto__){
var s__20145__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20145__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20145__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20147 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20146 = (0);
while(true){
if((i__20146 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__20146);
cljs.core.chunk_append.call(null,b__20147,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__20151 = (i__20146 + (1));
i__20146 = G__20151;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20147),sablono$core$iter__20144.call(null,cljs.core.chunk_rest.call(null,s__20145__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20147),null);
}
} else {
var style = cljs.core.first.call(null,s__20145__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__20144.call(null,cljs.core.rest.call(null,s__20145__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq20143){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20143));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to20152 = (function sablono$core$link_to20152(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20155 = arguments.length;
var i__5727__auto___20156 = (0);
while(true){
if((i__5727__auto___20156 < len__5726__auto___20155)){
args__5733__auto__.push((arguments[i__5727__auto___20156]));

var G__20157 = (i__5727__auto___20156 + (1));
i__5727__auto___20156 = G__20157;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to20152.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to20152.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to20152.cljs$lang$maxFixedArity = (1);

sablono.core.link_to20152.cljs$lang$applyTo = (function (seq20153){
var G__20154 = cljs.core.first.call(null,seq20153);
var seq20153__$1 = cljs.core.next.call(null,seq20153);
return sablono.core.link_to20152.cljs$core$IFn$_invoke$arity$variadic(G__20154,seq20153__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to20152);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to20158 = (function sablono$core$mail_to20158(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20163 = arguments.length;
var i__5727__auto___20164 = (0);
while(true){
if((i__5727__auto___20164 < len__5726__auto___20163)){
args__5733__auto__.push((arguments[i__5727__auto___20164]));

var G__20165 = (i__5727__auto___20164 + (1));
i__5727__auto___20164 = G__20165;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to20158.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to20158.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__20161){
var vec__20162 = p__20161;
var content = cljs.core.nth.call(null,vec__20162,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to20158.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to20158.cljs$lang$applyTo = (function (seq20159){
var G__20160 = cljs.core.first.call(null,seq20159);
var seq20159__$1 = cljs.core.next.call(null,seq20159);
return sablono.core.mail_to20158.cljs$core$IFn$_invoke$arity$variadic(G__20160,seq20159__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to20158);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list20166 = (function sablono$core$unordered_list20166(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list20166_$_iter__20171(s__20172){
return (new cljs.core.LazySeq(null,(function (){
var s__20172__$1 = s__20172;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20172__$1);
if(temp__4425__auto__){
var s__20172__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20172__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20172__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20174 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20173 = (0);
while(true){
if((i__20173 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20173);
cljs.core.chunk_append.call(null,b__20174,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20175 = (i__20173 + (1));
i__20173 = G__20175;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20174),sablono$core$unordered_list20166_$_iter__20171.call(null,cljs.core.chunk_rest.call(null,s__20172__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20174),null);
}
} else {
var x = cljs.core.first.call(null,s__20172__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list20166_$_iter__20171.call(null,cljs.core.rest.call(null,s__20172__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list20166);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list20176 = (function sablono$core$ordered_list20176(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list20176_$_iter__20181(s__20182){
return (new cljs.core.LazySeq(null,(function (){
var s__20182__$1 = s__20182;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20182__$1);
if(temp__4425__auto__){
var s__20182__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20182__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20182__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20184 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20183 = (0);
while(true){
if((i__20183 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20183);
cljs.core.chunk_append.call(null,b__20184,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20185 = (i__20183 + (1));
i__20183 = G__20185;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20184),sablono$core$ordered_list20176_$_iter__20181.call(null,cljs.core.chunk_rest.call(null,s__20182__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20184),null);
}
} else {
var x = cljs.core.first.call(null,s__20182__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list20176_$_iter__20181.call(null,cljs.core.rest.call(null,s__20182__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list20176);
/**
 * Create an image element.
 */
sablono.core.image20186 = (function sablono$core$image20186(var_args){
var args20187 = [];
var len__5726__auto___20190 = arguments.length;
var i__5727__auto___20191 = (0);
while(true){
if((i__5727__auto___20191 < len__5726__auto___20190)){
args20187.push((arguments[i__5727__auto___20191]));

var G__20192 = (i__5727__auto___20191 + (1));
i__5727__auto___20191 = G__20192;
continue;
} else {
}
break;
}

var G__20189 = args20187.length;
switch (G__20189) {
case 1:
return sablono.core.image20186.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image20186.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20187.length)].join('')));

}
});

sablono.core.image20186.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image20186.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image20186.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image20186);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__20194_SHARP_,p2__20195_SHARP_){
return [cljs.core.str(p1__20194_SHARP_),cljs.core.str("["),cljs.core.str(p2__20195_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__20196_SHARP_,p2__20197_SHARP_){
return [cljs.core.str(p1__20196_SHARP_),cljs.core.str("-"),cljs.core.str(p2__20197_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field20198 = (function sablono$core$color_field20198(var_args){
var args20199 = [];
var len__5726__auto___20266 = arguments.length;
var i__5727__auto___20267 = (0);
while(true){
if((i__5727__auto___20267 < len__5726__auto___20266)){
args20199.push((arguments[i__5727__auto___20267]));

var G__20268 = (i__5727__auto___20267 + (1));
i__5727__auto___20267 = G__20268;
continue;
} else {
}
break;
}

var G__20201 = args20199.length;
switch (G__20201) {
case 1:
return sablono.core.color_field20198.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field20198.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20199.length)].join('')));

}
});

sablono.core.color_field20198.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.color_field20198.call(null,name__11649__auto__,null);
});

sablono.core.color_field20198.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.color_field20198.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field20198);

/**
 * Creates a date input field.
 */
sablono.core.date_field20202 = (function sablono$core$date_field20202(var_args){
var args20203 = [];
var len__5726__auto___20270 = arguments.length;
var i__5727__auto___20271 = (0);
while(true){
if((i__5727__auto___20271 < len__5726__auto___20270)){
args20203.push((arguments[i__5727__auto___20271]));

var G__20272 = (i__5727__auto___20271 + (1));
i__5727__auto___20271 = G__20272;
continue;
} else {
}
break;
}

var G__20205 = args20203.length;
switch (G__20205) {
case 1:
return sablono.core.date_field20202.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field20202.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20203.length)].join('')));

}
});

sablono.core.date_field20202.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.date_field20202.call(null,name__11649__auto__,null);
});

sablono.core.date_field20202.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.date_field20202.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field20202);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field20206 = (function sablono$core$datetime_field20206(var_args){
var args20207 = [];
var len__5726__auto___20274 = arguments.length;
var i__5727__auto___20275 = (0);
while(true){
if((i__5727__auto___20275 < len__5726__auto___20274)){
args20207.push((arguments[i__5727__auto___20275]));

var G__20276 = (i__5727__auto___20275 + (1));
i__5727__auto___20275 = G__20276;
continue;
} else {
}
break;
}

var G__20209 = args20207.length;
switch (G__20209) {
case 1:
return sablono.core.datetime_field20206.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field20206.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20207.length)].join('')));

}
});

sablono.core.datetime_field20206.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_field20206.call(null,name__11649__auto__,null);
});

sablono.core.datetime_field20206.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_field20206.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field20206);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field20210 = (function sablono$core$datetime_local_field20210(var_args){
var args20211 = [];
var len__5726__auto___20278 = arguments.length;
var i__5727__auto___20279 = (0);
while(true){
if((i__5727__auto___20279 < len__5726__auto___20278)){
args20211.push((arguments[i__5727__auto___20279]));

var G__20280 = (i__5727__auto___20279 + (1));
i__5727__auto___20279 = G__20280;
continue;
} else {
}
break;
}

var G__20213 = args20211.length;
switch (G__20213) {
case 1:
return sablono.core.datetime_local_field20210.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field20210.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20211.length)].join('')));

}
});

sablono.core.datetime_local_field20210.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_local_field20210.call(null,name__11649__auto__,null);
});

sablono.core.datetime_local_field20210.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_local_field20210.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field20210);

/**
 * Creates a email input field.
 */
sablono.core.email_field20214 = (function sablono$core$email_field20214(var_args){
var args20215 = [];
var len__5726__auto___20282 = arguments.length;
var i__5727__auto___20283 = (0);
while(true){
if((i__5727__auto___20283 < len__5726__auto___20282)){
args20215.push((arguments[i__5727__auto___20283]));

var G__20284 = (i__5727__auto___20283 + (1));
i__5727__auto___20283 = G__20284;
continue;
} else {
}
break;
}

var G__20217 = args20215.length;
switch (G__20217) {
case 1:
return sablono.core.email_field20214.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field20214.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20215.length)].join('')));

}
});

sablono.core.email_field20214.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.email_field20214.call(null,name__11649__auto__,null);
});

sablono.core.email_field20214.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.email_field20214.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field20214);

/**
 * Creates a file input field.
 */
sablono.core.file_field20218 = (function sablono$core$file_field20218(var_args){
var args20219 = [];
var len__5726__auto___20286 = arguments.length;
var i__5727__auto___20287 = (0);
while(true){
if((i__5727__auto___20287 < len__5726__auto___20286)){
args20219.push((arguments[i__5727__auto___20287]));

var G__20288 = (i__5727__auto___20287 + (1));
i__5727__auto___20287 = G__20288;
continue;
} else {
}
break;
}

var G__20221 = args20219.length;
switch (G__20221) {
case 1:
return sablono.core.file_field20218.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field20218.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20219.length)].join('')));

}
});

sablono.core.file_field20218.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.file_field20218.call(null,name__11649__auto__,null);
});

sablono.core.file_field20218.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.file_field20218.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field20218);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field20222 = (function sablono$core$hidden_field20222(var_args){
var args20223 = [];
var len__5726__auto___20290 = arguments.length;
var i__5727__auto___20291 = (0);
while(true){
if((i__5727__auto___20291 < len__5726__auto___20290)){
args20223.push((arguments[i__5727__auto___20291]));

var G__20292 = (i__5727__auto___20291 + (1));
i__5727__auto___20291 = G__20292;
continue;
} else {
}
break;
}

var G__20225 = args20223.length;
switch (G__20225) {
case 1:
return sablono.core.hidden_field20222.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field20222.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20223.length)].join('')));

}
});

sablono.core.hidden_field20222.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.hidden_field20222.call(null,name__11649__auto__,null);
});

sablono.core.hidden_field20222.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.hidden_field20222.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field20222);

/**
 * Creates a month input field.
 */
sablono.core.month_field20226 = (function sablono$core$month_field20226(var_args){
var args20227 = [];
var len__5726__auto___20294 = arguments.length;
var i__5727__auto___20295 = (0);
while(true){
if((i__5727__auto___20295 < len__5726__auto___20294)){
args20227.push((arguments[i__5727__auto___20295]));

var G__20296 = (i__5727__auto___20295 + (1));
i__5727__auto___20295 = G__20296;
continue;
} else {
}
break;
}

var G__20229 = args20227.length;
switch (G__20229) {
case 1:
return sablono.core.month_field20226.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field20226.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20227.length)].join('')));

}
});

sablono.core.month_field20226.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.month_field20226.call(null,name__11649__auto__,null);
});

sablono.core.month_field20226.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.month_field20226.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field20226);

/**
 * Creates a number input field.
 */
sablono.core.number_field20230 = (function sablono$core$number_field20230(var_args){
var args20231 = [];
var len__5726__auto___20298 = arguments.length;
var i__5727__auto___20299 = (0);
while(true){
if((i__5727__auto___20299 < len__5726__auto___20298)){
args20231.push((arguments[i__5727__auto___20299]));

var G__20300 = (i__5727__auto___20299 + (1));
i__5727__auto___20299 = G__20300;
continue;
} else {
}
break;
}

var G__20233 = args20231.length;
switch (G__20233) {
case 1:
return sablono.core.number_field20230.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field20230.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20231.length)].join('')));

}
});

sablono.core.number_field20230.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.number_field20230.call(null,name__11649__auto__,null);
});

sablono.core.number_field20230.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.number_field20230.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field20230);

/**
 * Creates a password input field.
 */
sablono.core.password_field20234 = (function sablono$core$password_field20234(var_args){
var args20235 = [];
var len__5726__auto___20302 = arguments.length;
var i__5727__auto___20303 = (0);
while(true){
if((i__5727__auto___20303 < len__5726__auto___20302)){
args20235.push((arguments[i__5727__auto___20303]));

var G__20304 = (i__5727__auto___20303 + (1));
i__5727__auto___20303 = G__20304;
continue;
} else {
}
break;
}

var G__20237 = args20235.length;
switch (G__20237) {
case 1:
return sablono.core.password_field20234.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field20234.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20235.length)].join('')));

}
});

sablono.core.password_field20234.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.password_field20234.call(null,name__11649__auto__,null);
});

sablono.core.password_field20234.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.password_field20234.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field20234);

/**
 * Creates a range input field.
 */
sablono.core.range_field20238 = (function sablono$core$range_field20238(var_args){
var args20239 = [];
var len__5726__auto___20306 = arguments.length;
var i__5727__auto___20307 = (0);
while(true){
if((i__5727__auto___20307 < len__5726__auto___20306)){
args20239.push((arguments[i__5727__auto___20307]));

var G__20308 = (i__5727__auto___20307 + (1));
i__5727__auto___20307 = G__20308;
continue;
} else {
}
break;
}

var G__20241 = args20239.length;
switch (G__20241) {
case 1:
return sablono.core.range_field20238.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field20238.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20239.length)].join('')));

}
});

sablono.core.range_field20238.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.range_field20238.call(null,name__11649__auto__,null);
});

sablono.core.range_field20238.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.range_field20238.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field20238);

/**
 * Creates a search input field.
 */
sablono.core.search_field20242 = (function sablono$core$search_field20242(var_args){
var args20243 = [];
var len__5726__auto___20310 = arguments.length;
var i__5727__auto___20311 = (0);
while(true){
if((i__5727__auto___20311 < len__5726__auto___20310)){
args20243.push((arguments[i__5727__auto___20311]));

var G__20312 = (i__5727__auto___20311 + (1));
i__5727__auto___20311 = G__20312;
continue;
} else {
}
break;
}

var G__20245 = args20243.length;
switch (G__20245) {
case 1:
return sablono.core.search_field20242.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field20242.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20243.length)].join('')));

}
});

sablono.core.search_field20242.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.search_field20242.call(null,name__11649__auto__,null);
});

sablono.core.search_field20242.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.search_field20242.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field20242);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field20246 = (function sablono$core$tel_field20246(var_args){
var args20247 = [];
var len__5726__auto___20314 = arguments.length;
var i__5727__auto___20315 = (0);
while(true){
if((i__5727__auto___20315 < len__5726__auto___20314)){
args20247.push((arguments[i__5727__auto___20315]));

var G__20316 = (i__5727__auto___20315 + (1));
i__5727__auto___20315 = G__20316;
continue;
} else {
}
break;
}

var G__20249 = args20247.length;
switch (G__20249) {
case 1:
return sablono.core.tel_field20246.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field20246.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20247.length)].join('')));

}
});

sablono.core.tel_field20246.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.tel_field20246.call(null,name__11649__auto__,null);
});

sablono.core.tel_field20246.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.tel_field20246.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field20246);

/**
 * Creates a text input field.
 */
sablono.core.text_field20250 = (function sablono$core$text_field20250(var_args){
var args20251 = [];
var len__5726__auto___20318 = arguments.length;
var i__5727__auto___20319 = (0);
while(true){
if((i__5727__auto___20319 < len__5726__auto___20318)){
args20251.push((arguments[i__5727__auto___20319]));

var G__20320 = (i__5727__auto___20319 + (1));
i__5727__auto___20319 = G__20320;
continue;
} else {
}
break;
}

var G__20253 = args20251.length;
switch (G__20253) {
case 1:
return sablono.core.text_field20250.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field20250.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20251.length)].join('')));

}
});

sablono.core.text_field20250.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.text_field20250.call(null,name__11649__auto__,null);
});

sablono.core.text_field20250.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.text_field20250.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field20250);

/**
 * Creates a time input field.
 */
sablono.core.time_field20254 = (function sablono$core$time_field20254(var_args){
var args20255 = [];
var len__5726__auto___20322 = arguments.length;
var i__5727__auto___20323 = (0);
while(true){
if((i__5727__auto___20323 < len__5726__auto___20322)){
args20255.push((arguments[i__5727__auto___20323]));

var G__20324 = (i__5727__auto___20323 + (1));
i__5727__auto___20323 = G__20324;
continue;
} else {
}
break;
}

var G__20257 = args20255.length;
switch (G__20257) {
case 1:
return sablono.core.time_field20254.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field20254.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20255.length)].join('')));

}
});

sablono.core.time_field20254.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.time_field20254.call(null,name__11649__auto__,null);
});

sablono.core.time_field20254.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.time_field20254.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field20254);

/**
 * Creates a url input field.
 */
sablono.core.url_field20258 = (function sablono$core$url_field20258(var_args){
var args20259 = [];
var len__5726__auto___20326 = arguments.length;
var i__5727__auto___20327 = (0);
while(true){
if((i__5727__auto___20327 < len__5726__auto___20326)){
args20259.push((arguments[i__5727__auto___20327]));

var G__20328 = (i__5727__auto___20327 + (1));
i__5727__auto___20327 = G__20328;
continue;
} else {
}
break;
}

var G__20261 = args20259.length;
switch (G__20261) {
case 1:
return sablono.core.url_field20258.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field20258.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20259.length)].join('')));

}
});

sablono.core.url_field20258.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.url_field20258.call(null,name__11649__auto__,null);
});

sablono.core.url_field20258.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.url_field20258.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field20258);

/**
 * Creates a week input field.
 */
sablono.core.week_field20262 = (function sablono$core$week_field20262(var_args){
var args20263 = [];
var len__5726__auto___20330 = arguments.length;
var i__5727__auto___20331 = (0);
while(true){
if((i__5727__auto___20331 < len__5726__auto___20330)){
args20263.push((arguments[i__5727__auto___20331]));

var G__20332 = (i__5727__auto___20331 + (1));
i__5727__auto___20331 = G__20332;
continue;
} else {
}
break;
}

var G__20265 = args20263.length;
switch (G__20265) {
case 1:
return sablono.core.week_field20262.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field20262.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20263.length)].join('')));

}
});

sablono.core.week_field20262.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.week_field20262.call(null,name__11649__auto__,null);
});

sablono.core.week_field20262.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.week_field20262.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field20262);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box20334 = (function sablono$core$check_box20334(var_args){
var args20335 = [];
var len__5726__auto___20338 = arguments.length;
var i__5727__auto___20339 = (0);
while(true){
if((i__5727__auto___20339 < len__5726__auto___20338)){
args20335.push((arguments[i__5727__auto___20339]));

var G__20340 = (i__5727__auto___20339 + (1));
i__5727__auto___20339 = G__20340;
continue;
} else {
}
break;
}

var G__20337 = args20335.length;
switch (G__20337) {
case 1:
return sablono.core.check_box20334.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box20334.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box20334.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20335.length)].join('')));

}
});

sablono.core.check_box20334.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box20334.call(null,name,null);
});

sablono.core.check_box20334.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box20334.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box20334.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20334.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box20334);
/**
 * Creates a radio button.
 */
sablono.core.radio_button20342 = (function sablono$core$radio_button20342(var_args){
var args20343 = [];
var len__5726__auto___20346 = arguments.length;
var i__5727__auto___20347 = (0);
while(true){
if((i__5727__auto___20347 < len__5726__auto___20346)){
args20343.push((arguments[i__5727__auto___20347]));

var G__20348 = (i__5727__auto___20347 + (1));
i__5727__auto___20347 = G__20348;
continue;
} else {
}
break;
}

var G__20345 = args20343.length;
switch (G__20345) {
case 1:
return sablono.core.radio_button20342.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button20342.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button20342.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20343.length)].join('')));

}
});

sablono.core.radio_button20342.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button20342.call(null,group,null);
});

sablono.core.radio_button20342.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button20342.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button20342.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20342.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button20342);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options20350 = (function sablono$core$select_options20350(coll){
var iter__5440__auto__ = (function sablono$core$select_options20350_$_iter__20359(s__20360){
return (new cljs.core.LazySeq(null,(function (){
var s__20360__$1 = s__20360;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20360__$1);
if(temp__4425__auto__){
var s__20360__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20360__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20360__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20362 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20361 = (0);
while(true){
if((i__20361 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20361);
cljs.core.chunk_append.call(null,b__20362,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20365 = x;
var text = cljs.core.nth.call(null,vec__20365,(0),null);
var val = cljs.core.nth.call(null,vec__20365,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20365,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20350.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__20367 = (i__20361 + (1));
i__20361 = G__20367;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20362),sablono$core$select_options20350_$_iter__20359.call(null,cljs.core.chunk_rest.call(null,s__20360__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20362),null);
}
} else {
var x = cljs.core.first.call(null,s__20360__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20366 = x;
var text = cljs.core.nth.call(null,vec__20366,(0),null);
var val = cljs.core.nth.call(null,vec__20366,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20366,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20350.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options20350_$_iter__20359.call(null,cljs.core.rest.call(null,s__20360__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options20350);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down20368 = (function sablono$core$drop_down20368(var_args){
var args20369 = [];
var len__5726__auto___20372 = arguments.length;
var i__5727__auto___20373 = (0);
while(true){
if((i__5727__auto___20373 < len__5726__auto___20372)){
args20369.push((arguments[i__5727__auto___20373]));

var G__20374 = (i__5727__auto___20373 + (1));
i__5727__auto___20373 = G__20374;
continue;
} else {
}
break;
}

var G__20371 = args20369.length;
switch (G__20371) {
case 2:
return sablono.core.drop_down20368.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down20368.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20369.length)].join('')));

}
});

sablono.core.drop_down20368.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down20368.call(null,name,options,null);
});

sablono.core.drop_down20368.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down20368.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down20368);
/**
 * Creates a text area element.
 */
sablono.core.text_area20376 = (function sablono$core$text_area20376(var_args){
var args20377 = [];
var len__5726__auto___20380 = arguments.length;
var i__5727__auto___20381 = (0);
while(true){
if((i__5727__auto___20381 < len__5726__auto___20380)){
args20377.push((arguments[i__5727__auto___20381]));

var G__20382 = (i__5727__auto___20381 + (1));
i__5727__auto___20381 = G__20382;
continue;
} else {
}
break;
}

var G__20379 = args20377.length;
switch (G__20379) {
case 1:
return sablono.core.text_area20376.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area20376.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20377.length)].join('')));

}
});

sablono.core.text_area20376.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area20376.call(null,name,null);
});

sablono.core.text_area20376.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area20376.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area20376);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20384 = (function sablono$core$label20384(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20384);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20385 = (function sablono$core$submit_button20385(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20385);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20386 = (function sablono$core$reset_button20386(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20386);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20387 = (function sablono$core$form_to20387(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20392 = arguments.length;
var i__5727__auto___20393 = (0);
while(true){
if((i__5727__auto___20393 < len__5726__auto___20392)){
args__5733__auto__.push((arguments[i__5727__auto___20393]));

var G__20394 = (i__5727__auto___20393 + (1));
i__5727__auto___20393 = G__20394;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to20387.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to20387.cljs$core$IFn$_invoke$arity$variadic = (function (p__20390,body){
var vec__20391 = p__20390;
var method = cljs.core.nth.call(null,vec__20391,(0),null);
var action = cljs.core.nth.call(null,vec__20391,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to20387.cljs$lang$maxFixedArity = (1);

sablono.core.form_to20387.cljs$lang$applyTo = (function (seq20388){
var G__20389 = cljs.core.first.call(null,seq20388);
var seq20388__$1 = cljs.core.next.call(null,seq20388);
return sablono.core.form_to20387.cljs$core$IFn$_invoke$arity$variadic(G__20389,seq20388__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20387);

//# sourceMappingURL=core.js.map?rel=1455023830676