// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17305 = [];
var len__5726__auto___17311 = arguments.length;
var i__5727__auto___17312 = (0);
while(true){
if((i__5727__auto___17312 < len__5726__auto___17311)){
args17305.push((arguments[i__5727__auto___17312]));

var G__17313 = (i__5727__auto___17312 + (1));
i__5727__auto___17312 = G__17313;
continue;
} else {
}
break;
}

var G__17307 = args17305.length;
switch (G__17307) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17305.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17308 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17308 = (function (f,blockable,meta17309){
this.f = f;
this.blockable = blockable;
this.meta17309 = meta17309;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17308.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17310,meta17309__$1){
var self__ = this;
var _17310__$1 = this;
return (new cljs.core.async.t_cljs$core$async17308(self__.f,self__.blockable,meta17309__$1));
});

cljs.core.async.t_cljs$core$async17308.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17310){
var self__ = this;
var _17310__$1 = this;
return self__.meta17309;
});

cljs.core.async.t_cljs$core$async17308.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17308.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17308.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17308.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17308.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17309","meta17309",-1238678409,null)], null);
});

cljs.core.async.t_cljs$core$async17308.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17308.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17308";

cljs.core.async.t_cljs$core$async17308.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17308");
});

cljs.core.async.__GT_t_cljs$core$async17308 = (function cljs$core$async$__GT_t_cljs$core$async17308(f__$1,blockable__$1,meta17309){
return (new cljs.core.async.t_cljs$core$async17308(f__$1,blockable__$1,meta17309));
});

}

return (new cljs.core.async.t_cljs$core$async17308(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17317 = [];
var len__5726__auto___17320 = arguments.length;
var i__5727__auto___17321 = (0);
while(true){
if((i__5727__auto___17321 < len__5726__auto___17320)){
args17317.push((arguments[i__5727__auto___17321]));

var G__17322 = (i__5727__auto___17321 + (1));
i__5727__auto___17321 = G__17322;
continue;
} else {
}
break;
}

var G__17319 = args17317.length;
switch (G__17319) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17317.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17324 = [];
var len__5726__auto___17327 = arguments.length;
var i__5727__auto___17328 = (0);
while(true){
if((i__5727__auto___17328 < len__5726__auto___17327)){
args17324.push((arguments[i__5727__auto___17328]));

var G__17329 = (i__5727__auto___17328 + (1));
i__5727__auto___17328 = G__17329;
continue;
} else {
}
break;
}

var G__17326 = args17324.length;
switch (G__17326) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17324.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17331 = [];
var len__5726__auto___17334 = arguments.length;
var i__5727__auto___17335 = (0);
while(true){
if((i__5727__auto___17335 < len__5726__auto___17334)){
args17331.push((arguments[i__5727__auto___17335]));

var G__17336 = (i__5727__auto___17335 + (1));
i__5727__auto___17335 = G__17336;
continue;
} else {
}
break;
}

var G__17333 = args17331.length;
switch (G__17333) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17331.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17338 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17338);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17338,ret){
return (function (){
return fn1.call(null,val_17338);
});})(val_17338,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17339 = [];
var len__5726__auto___17342 = arguments.length;
var i__5727__auto___17343 = (0);
while(true){
if((i__5727__auto___17343 < len__5726__auto___17342)){
args17339.push((arguments[i__5727__auto___17343]));

var G__17344 = (i__5727__auto___17343 + (1));
i__5727__auto___17343 = G__17344;
continue;
} else {
}
break;
}

var G__17341 = args17339.length;
switch (G__17341) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17339.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17346 = n;
var x_17347 = (0);
while(true){
if((x_17347 < n__5571__auto___17346)){
(a[x_17347] = (0));

var G__17348 = (x_17347 + (1));
x_17347 = G__17348;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17349 = (i + (1));
i = G__17349;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17353 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17353 = (function (alt_flag,flag,meta17354){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17354 = meta17354;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17353.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17355,meta17354__$1){
var self__ = this;
var _17355__$1 = this;
return (new cljs.core.async.t_cljs$core$async17353(self__.alt_flag,self__.flag,meta17354__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17353.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17355){
var self__ = this;
var _17355__$1 = this;
return self__.meta17354;
});})(flag))
;

cljs.core.async.t_cljs$core$async17353.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17353.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17353.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17353.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17353.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17354","meta17354",1983925825,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17353.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17353.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17353";

cljs.core.async.t_cljs$core$async17353.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17353");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17353 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17353(alt_flag__$1,flag__$1,meta17354){
return (new cljs.core.async.t_cljs$core$async17353(alt_flag__$1,flag__$1,meta17354));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17353(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17359 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17359 = (function (alt_handler,flag,cb,meta17360){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17360 = meta17360;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17359.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17361,meta17360__$1){
var self__ = this;
var _17361__$1 = this;
return (new cljs.core.async.t_cljs$core$async17359(self__.alt_handler,self__.flag,self__.cb,meta17360__$1));
});

cljs.core.async.t_cljs$core$async17359.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17361){
var self__ = this;
var _17361__$1 = this;
return self__.meta17360;
});

cljs.core.async.t_cljs$core$async17359.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17359.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17359.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17359.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17359.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17360","meta17360",472013856,null)], null);
});

cljs.core.async.t_cljs$core$async17359.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17359.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17359";

cljs.core.async.t_cljs$core$async17359.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17359");
});

cljs.core.async.__GT_t_cljs$core$async17359 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17359(alt_handler__$1,flag__$1,cb__$1,meta17360){
return (new cljs.core.async.t_cljs$core$async17359(alt_handler__$1,flag__$1,cb__$1,meta17360));
});

}

return (new cljs.core.async.t_cljs$core$async17359(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17362_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17362_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17363_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17363_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17364 = (i + (1));
i = G__17364;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17370 = arguments.length;
var i__5727__auto___17371 = (0);
while(true){
if((i__5727__auto___17371 < len__5726__auto___17370)){
args__5733__auto__.push((arguments[i__5727__auto___17371]));

var G__17372 = (i__5727__auto___17371 + (1));
i__5727__auto___17371 = G__17372;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17367){
var map__17368 = p__17367;
var map__17368__$1 = ((((!((map__17368 == null)))?((((map__17368.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17368.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17368):map__17368);
var opts = map__17368__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17365){
var G__17366 = cljs.core.first.call(null,seq17365);
var seq17365__$1 = cljs.core.next.call(null,seq17365);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17366,seq17365__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17373 = [];
var len__5726__auto___17423 = arguments.length;
var i__5727__auto___17424 = (0);
while(true){
if((i__5727__auto___17424 < len__5726__auto___17423)){
args17373.push((arguments[i__5727__auto___17424]));

var G__17425 = (i__5727__auto___17424 + (1));
i__5727__auto___17424 = G__17425;
continue;
} else {
}
break;
}

var G__17375 = args17373.length;
switch (G__17375) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17373.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17427 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17427){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17427){
return (function (state_17399){
var state_val_17400 = (state_17399[(1)]);
if((state_val_17400 === (7))){
var inst_17395 = (state_17399[(2)]);
var state_17399__$1 = state_17399;
var statearr_17401_17428 = state_17399__$1;
(statearr_17401_17428[(2)] = inst_17395);

(statearr_17401_17428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (1))){
var state_17399__$1 = state_17399;
var statearr_17402_17429 = state_17399__$1;
(statearr_17402_17429[(2)] = null);

(statearr_17402_17429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (4))){
var inst_17378 = (state_17399[(7)]);
var inst_17378__$1 = (state_17399[(2)]);
var inst_17379 = (inst_17378__$1 == null);
var state_17399__$1 = (function (){var statearr_17403 = state_17399;
(statearr_17403[(7)] = inst_17378__$1);

return statearr_17403;
})();
if(cljs.core.truth_(inst_17379)){
var statearr_17404_17430 = state_17399__$1;
(statearr_17404_17430[(1)] = (5));

} else {
var statearr_17405_17431 = state_17399__$1;
(statearr_17405_17431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (13))){
var state_17399__$1 = state_17399;
var statearr_17406_17432 = state_17399__$1;
(statearr_17406_17432[(2)] = null);

(statearr_17406_17432[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (6))){
var inst_17378 = (state_17399[(7)]);
var state_17399__$1 = state_17399;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17399__$1,(11),to,inst_17378);
} else {
if((state_val_17400 === (3))){
var inst_17397 = (state_17399[(2)]);
var state_17399__$1 = state_17399;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17399__$1,inst_17397);
} else {
if((state_val_17400 === (12))){
var state_17399__$1 = state_17399;
var statearr_17407_17433 = state_17399__$1;
(statearr_17407_17433[(2)] = null);

(statearr_17407_17433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (2))){
var state_17399__$1 = state_17399;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17399__$1,(4),from);
} else {
if((state_val_17400 === (11))){
var inst_17388 = (state_17399[(2)]);
var state_17399__$1 = state_17399;
if(cljs.core.truth_(inst_17388)){
var statearr_17408_17434 = state_17399__$1;
(statearr_17408_17434[(1)] = (12));

} else {
var statearr_17409_17435 = state_17399__$1;
(statearr_17409_17435[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (9))){
var state_17399__$1 = state_17399;
var statearr_17410_17436 = state_17399__$1;
(statearr_17410_17436[(2)] = null);

(statearr_17410_17436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (5))){
var state_17399__$1 = state_17399;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17411_17437 = state_17399__$1;
(statearr_17411_17437[(1)] = (8));

} else {
var statearr_17412_17438 = state_17399__$1;
(statearr_17412_17438[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (14))){
var inst_17393 = (state_17399[(2)]);
var state_17399__$1 = state_17399;
var statearr_17413_17439 = state_17399__$1;
(statearr_17413_17439[(2)] = inst_17393);

(statearr_17413_17439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (10))){
var inst_17385 = (state_17399[(2)]);
var state_17399__$1 = state_17399;
var statearr_17414_17440 = state_17399__$1;
(statearr_17414_17440[(2)] = inst_17385);

(statearr_17414_17440[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17400 === (8))){
var inst_17382 = cljs.core.async.close_BANG_.call(null,to);
var state_17399__$1 = state_17399;
var statearr_17415_17441 = state_17399__$1;
(statearr_17415_17441[(2)] = inst_17382);

(statearr_17415_17441[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17427))
;
return ((function (switch__8250__auto__,c__8362__auto___17427){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17419 = [null,null,null,null,null,null,null,null];
(statearr_17419[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17419[(1)] = (1));

return statearr_17419;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17399){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17399);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17420){if((e17420 instanceof Object)){
var ex__8254__auto__ = e17420;
var statearr_17421_17442 = state_17399;
(statearr_17421_17442[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17399);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17420;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17443 = state_17399;
state_17399 = G__17443;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17399){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17427))
})();
var state__8364__auto__ = (function (){var statearr_17422 = f__8363__auto__.call(null);
(statearr_17422[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17427);

return statearr_17422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17427))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17627){
var vec__17628 = p__17627;
var v = cljs.core.nth.call(null,vec__17628,(0),null);
var p = cljs.core.nth.call(null,vec__17628,(1),null);
var job = vec__17628;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17810 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17810,res,vec__17628,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17810,res,vec__17628,v,p,job,jobs,results){
return (function (state_17633){
var state_val_17634 = (state_17633[(1)]);
if((state_val_17634 === (1))){
var state_17633__$1 = state_17633;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17633__$1,(2),res,v);
} else {
if((state_val_17634 === (2))){
var inst_17630 = (state_17633[(2)]);
var inst_17631 = cljs.core.async.close_BANG_.call(null,res);
var state_17633__$1 = (function (){var statearr_17635 = state_17633;
(statearr_17635[(7)] = inst_17630);

return statearr_17635;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17633__$1,inst_17631);
} else {
return null;
}
}
});})(c__8362__auto___17810,res,vec__17628,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17810,res,vec__17628,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17639 = [null,null,null,null,null,null,null,null];
(statearr_17639[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17639[(1)] = (1));

return statearr_17639;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17633){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17640){if((e17640 instanceof Object)){
var ex__8254__auto__ = e17640;
var statearr_17641_17811 = state_17633;
(statearr_17641_17811[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17633);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17640;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17812 = state_17633;
state_17633 = G__17812;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17633){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17810,res,vec__17628,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17642 = f__8363__auto__.call(null);
(statearr_17642[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17810);

return statearr_17642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17810,res,vec__17628,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17643){
var vec__17644 = p__17643;
var v = cljs.core.nth.call(null,vec__17644,(0),null);
var p = cljs.core.nth.call(null,vec__17644,(1),null);
var job = vec__17644;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17813 = n;
var __17814 = (0);
while(true){
if((__17814 < n__5571__auto___17813)){
var G__17645_17815 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17645_17815) {
case "compute":
var c__8362__auto___17817 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17814,c__8362__auto___17817,G__17645_17815,n__5571__auto___17813,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17814,c__8362__auto___17817,G__17645_17815,n__5571__auto___17813,jobs,results,process,async){
return (function (state_17658){
var state_val_17659 = (state_17658[(1)]);
if((state_val_17659 === (1))){
var state_17658__$1 = state_17658;
var statearr_17660_17818 = state_17658__$1;
(statearr_17660_17818[(2)] = null);

(statearr_17660_17818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17659 === (2))){
var state_17658__$1 = state_17658;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17658__$1,(4),jobs);
} else {
if((state_val_17659 === (3))){
var inst_17656 = (state_17658[(2)]);
var state_17658__$1 = state_17658;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17658__$1,inst_17656);
} else {
if((state_val_17659 === (4))){
var inst_17648 = (state_17658[(2)]);
var inst_17649 = process.call(null,inst_17648);
var state_17658__$1 = state_17658;
if(cljs.core.truth_(inst_17649)){
var statearr_17661_17819 = state_17658__$1;
(statearr_17661_17819[(1)] = (5));

} else {
var statearr_17662_17820 = state_17658__$1;
(statearr_17662_17820[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17659 === (5))){
var state_17658__$1 = state_17658;
var statearr_17663_17821 = state_17658__$1;
(statearr_17663_17821[(2)] = null);

(statearr_17663_17821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17659 === (6))){
var state_17658__$1 = state_17658;
var statearr_17664_17822 = state_17658__$1;
(statearr_17664_17822[(2)] = null);

(statearr_17664_17822[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17659 === (7))){
var inst_17654 = (state_17658[(2)]);
var state_17658__$1 = state_17658;
var statearr_17665_17823 = state_17658__$1;
(statearr_17665_17823[(2)] = inst_17654);

(statearr_17665_17823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17814,c__8362__auto___17817,G__17645_17815,n__5571__auto___17813,jobs,results,process,async))
;
return ((function (__17814,switch__8250__auto__,c__8362__auto___17817,G__17645_17815,n__5571__auto___17813,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17669 = [null,null,null,null,null,null,null];
(statearr_17669[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17669[(1)] = (1));

return statearr_17669;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17658){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17658);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17670){if((e17670 instanceof Object)){
var ex__8254__auto__ = e17670;
var statearr_17671_17824 = state_17658;
(statearr_17671_17824[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17658);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17670;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17825 = state_17658;
state_17658 = G__17825;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17658){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17814,switch__8250__auto__,c__8362__auto___17817,G__17645_17815,n__5571__auto___17813,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17672 = f__8363__auto__.call(null);
(statearr_17672[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17817);

return statearr_17672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17814,c__8362__auto___17817,G__17645_17815,n__5571__auto___17813,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17826 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17814,c__8362__auto___17826,G__17645_17815,n__5571__auto___17813,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17814,c__8362__auto___17826,G__17645_17815,n__5571__auto___17813,jobs,results,process,async){
return (function (state_17685){
var state_val_17686 = (state_17685[(1)]);
if((state_val_17686 === (1))){
var state_17685__$1 = state_17685;
var statearr_17687_17827 = state_17685__$1;
(statearr_17687_17827[(2)] = null);

(statearr_17687_17827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17686 === (2))){
var state_17685__$1 = state_17685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17685__$1,(4),jobs);
} else {
if((state_val_17686 === (3))){
var inst_17683 = (state_17685[(2)]);
var state_17685__$1 = state_17685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17685__$1,inst_17683);
} else {
if((state_val_17686 === (4))){
var inst_17675 = (state_17685[(2)]);
var inst_17676 = async.call(null,inst_17675);
var state_17685__$1 = state_17685;
if(cljs.core.truth_(inst_17676)){
var statearr_17688_17828 = state_17685__$1;
(statearr_17688_17828[(1)] = (5));

} else {
var statearr_17689_17829 = state_17685__$1;
(statearr_17689_17829[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17686 === (5))){
var state_17685__$1 = state_17685;
var statearr_17690_17830 = state_17685__$1;
(statearr_17690_17830[(2)] = null);

(statearr_17690_17830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17686 === (6))){
var state_17685__$1 = state_17685;
var statearr_17691_17831 = state_17685__$1;
(statearr_17691_17831[(2)] = null);

(statearr_17691_17831[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17686 === (7))){
var inst_17681 = (state_17685[(2)]);
var state_17685__$1 = state_17685;
var statearr_17692_17832 = state_17685__$1;
(statearr_17692_17832[(2)] = inst_17681);

(statearr_17692_17832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17814,c__8362__auto___17826,G__17645_17815,n__5571__auto___17813,jobs,results,process,async))
;
return ((function (__17814,switch__8250__auto__,c__8362__auto___17826,G__17645_17815,n__5571__auto___17813,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17696 = [null,null,null,null,null,null,null];
(statearr_17696[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17696[(1)] = (1));

return statearr_17696;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17685){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17697){if((e17697 instanceof Object)){
var ex__8254__auto__ = e17697;
var statearr_17698_17833 = state_17685;
(statearr_17698_17833[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17697;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17834 = state_17685;
state_17685 = G__17834;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17685){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17814,switch__8250__auto__,c__8362__auto___17826,G__17645_17815,n__5571__auto___17813,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17699 = f__8363__auto__.call(null);
(statearr_17699[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17826);

return statearr_17699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17814,c__8362__auto___17826,G__17645_17815,n__5571__auto___17813,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17835 = (__17814 + (1));
__17814 = G__17835;
continue;
} else {
}
break;
}

var c__8362__auto___17836 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17836,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17836,jobs,results,process,async){
return (function (state_17721){
var state_val_17722 = (state_17721[(1)]);
if((state_val_17722 === (1))){
var state_17721__$1 = state_17721;
var statearr_17723_17837 = state_17721__$1;
(statearr_17723_17837[(2)] = null);

(statearr_17723_17837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17722 === (2))){
var state_17721__$1 = state_17721;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17721__$1,(4),from);
} else {
if((state_val_17722 === (3))){
var inst_17719 = (state_17721[(2)]);
var state_17721__$1 = state_17721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17721__$1,inst_17719);
} else {
if((state_val_17722 === (4))){
var inst_17702 = (state_17721[(7)]);
var inst_17702__$1 = (state_17721[(2)]);
var inst_17703 = (inst_17702__$1 == null);
var state_17721__$1 = (function (){var statearr_17724 = state_17721;
(statearr_17724[(7)] = inst_17702__$1);

return statearr_17724;
})();
if(cljs.core.truth_(inst_17703)){
var statearr_17725_17838 = state_17721__$1;
(statearr_17725_17838[(1)] = (5));

} else {
var statearr_17726_17839 = state_17721__$1;
(statearr_17726_17839[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17722 === (5))){
var inst_17705 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17721__$1 = state_17721;
var statearr_17727_17840 = state_17721__$1;
(statearr_17727_17840[(2)] = inst_17705);

(statearr_17727_17840[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17722 === (6))){
var inst_17702 = (state_17721[(7)]);
var inst_17707 = (state_17721[(8)]);
var inst_17707__$1 = cljs.core.async.chan.call(null,(1));
var inst_17708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17709 = [inst_17702,inst_17707__$1];
var inst_17710 = (new cljs.core.PersistentVector(null,2,(5),inst_17708,inst_17709,null));
var state_17721__$1 = (function (){var statearr_17728 = state_17721;
(statearr_17728[(8)] = inst_17707__$1);

return statearr_17728;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17721__$1,(8),jobs,inst_17710);
} else {
if((state_val_17722 === (7))){
var inst_17717 = (state_17721[(2)]);
var state_17721__$1 = state_17721;
var statearr_17729_17841 = state_17721__$1;
(statearr_17729_17841[(2)] = inst_17717);

(statearr_17729_17841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17722 === (8))){
var inst_17707 = (state_17721[(8)]);
var inst_17712 = (state_17721[(2)]);
var state_17721__$1 = (function (){var statearr_17730 = state_17721;
(statearr_17730[(9)] = inst_17712);

return statearr_17730;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17721__$1,(9),results,inst_17707);
} else {
if((state_val_17722 === (9))){
var inst_17714 = (state_17721[(2)]);
var state_17721__$1 = (function (){var statearr_17731 = state_17721;
(statearr_17731[(10)] = inst_17714);

return statearr_17731;
})();
var statearr_17732_17842 = state_17721__$1;
(statearr_17732_17842[(2)] = null);

(statearr_17732_17842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17836,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17836,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17736 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17736[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17736[(1)] = (1));

return statearr_17736;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17721){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17737){if((e17737 instanceof Object)){
var ex__8254__auto__ = e17737;
var statearr_17738_17843 = state_17721;
(statearr_17738_17843[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17721);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17844 = state_17721;
state_17721 = G__17844;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17721){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17836,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17739 = f__8363__auto__.call(null);
(statearr_17739[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17836);

return statearr_17739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17836,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17777){
var state_val_17778 = (state_17777[(1)]);
if((state_val_17778 === (7))){
var inst_17773 = (state_17777[(2)]);
var state_17777__$1 = state_17777;
var statearr_17779_17845 = state_17777__$1;
(statearr_17779_17845[(2)] = inst_17773);

(statearr_17779_17845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (20))){
var state_17777__$1 = state_17777;
var statearr_17780_17846 = state_17777__$1;
(statearr_17780_17846[(2)] = null);

(statearr_17780_17846[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (1))){
var state_17777__$1 = state_17777;
var statearr_17781_17847 = state_17777__$1;
(statearr_17781_17847[(2)] = null);

(statearr_17781_17847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (4))){
var inst_17742 = (state_17777[(7)]);
var inst_17742__$1 = (state_17777[(2)]);
var inst_17743 = (inst_17742__$1 == null);
var state_17777__$1 = (function (){var statearr_17782 = state_17777;
(statearr_17782[(7)] = inst_17742__$1);

return statearr_17782;
})();
if(cljs.core.truth_(inst_17743)){
var statearr_17783_17848 = state_17777__$1;
(statearr_17783_17848[(1)] = (5));

} else {
var statearr_17784_17849 = state_17777__$1;
(statearr_17784_17849[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (15))){
var inst_17755 = (state_17777[(8)]);
var state_17777__$1 = state_17777;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17777__$1,(18),to,inst_17755);
} else {
if((state_val_17778 === (21))){
var inst_17768 = (state_17777[(2)]);
var state_17777__$1 = state_17777;
var statearr_17785_17850 = state_17777__$1;
(statearr_17785_17850[(2)] = inst_17768);

(statearr_17785_17850[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (13))){
var inst_17770 = (state_17777[(2)]);
var state_17777__$1 = (function (){var statearr_17786 = state_17777;
(statearr_17786[(9)] = inst_17770);

return statearr_17786;
})();
var statearr_17787_17851 = state_17777__$1;
(statearr_17787_17851[(2)] = null);

(statearr_17787_17851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (6))){
var inst_17742 = (state_17777[(7)]);
var state_17777__$1 = state_17777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17777__$1,(11),inst_17742);
} else {
if((state_val_17778 === (17))){
var inst_17763 = (state_17777[(2)]);
var state_17777__$1 = state_17777;
if(cljs.core.truth_(inst_17763)){
var statearr_17788_17852 = state_17777__$1;
(statearr_17788_17852[(1)] = (19));

} else {
var statearr_17789_17853 = state_17777__$1;
(statearr_17789_17853[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (3))){
var inst_17775 = (state_17777[(2)]);
var state_17777__$1 = state_17777;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17777__$1,inst_17775);
} else {
if((state_val_17778 === (12))){
var inst_17752 = (state_17777[(10)]);
var state_17777__$1 = state_17777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17777__$1,(14),inst_17752);
} else {
if((state_val_17778 === (2))){
var state_17777__$1 = state_17777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17777__$1,(4),results);
} else {
if((state_val_17778 === (19))){
var state_17777__$1 = state_17777;
var statearr_17790_17854 = state_17777__$1;
(statearr_17790_17854[(2)] = null);

(statearr_17790_17854[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (11))){
var inst_17752 = (state_17777[(2)]);
var state_17777__$1 = (function (){var statearr_17791 = state_17777;
(statearr_17791[(10)] = inst_17752);

return statearr_17791;
})();
var statearr_17792_17855 = state_17777__$1;
(statearr_17792_17855[(2)] = null);

(statearr_17792_17855[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (9))){
var state_17777__$1 = state_17777;
var statearr_17793_17856 = state_17777__$1;
(statearr_17793_17856[(2)] = null);

(statearr_17793_17856[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (5))){
var state_17777__$1 = state_17777;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17794_17857 = state_17777__$1;
(statearr_17794_17857[(1)] = (8));

} else {
var statearr_17795_17858 = state_17777__$1;
(statearr_17795_17858[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (14))){
var inst_17755 = (state_17777[(8)]);
var inst_17757 = (state_17777[(11)]);
var inst_17755__$1 = (state_17777[(2)]);
var inst_17756 = (inst_17755__$1 == null);
var inst_17757__$1 = cljs.core.not.call(null,inst_17756);
var state_17777__$1 = (function (){var statearr_17796 = state_17777;
(statearr_17796[(8)] = inst_17755__$1);

(statearr_17796[(11)] = inst_17757__$1);

return statearr_17796;
})();
if(inst_17757__$1){
var statearr_17797_17859 = state_17777__$1;
(statearr_17797_17859[(1)] = (15));

} else {
var statearr_17798_17860 = state_17777__$1;
(statearr_17798_17860[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (16))){
var inst_17757 = (state_17777[(11)]);
var state_17777__$1 = state_17777;
var statearr_17799_17861 = state_17777__$1;
(statearr_17799_17861[(2)] = inst_17757);

(statearr_17799_17861[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (10))){
var inst_17749 = (state_17777[(2)]);
var state_17777__$1 = state_17777;
var statearr_17800_17862 = state_17777__$1;
(statearr_17800_17862[(2)] = inst_17749);

(statearr_17800_17862[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (18))){
var inst_17760 = (state_17777[(2)]);
var state_17777__$1 = state_17777;
var statearr_17801_17863 = state_17777__$1;
(statearr_17801_17863[(2)] = inst_17760);

(statearr_17801_17863[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17778 === (8))){
var inst_17746 = cljs.core.async.close_BANG_.call(null,to);
var state_17777__$1 = state_17777;
var statearr_17802_17864 = state_17777__$1;
(statearr_17802_17864[(2)] = inst_17746);

(statearr_17802_17864[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17806 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17806[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17806[(1)] = (1));

return statearr_17806;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17777){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17777);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17807){if((e17807 instanceof Object)){
var ex__8254__auto__ = e17807;
var statearr_17808_17865 = state_17777;
(statearr_17808_17865[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17777);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17807;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17866 = state_17777;
state_17777 = G__17866;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17777){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17809 = f__8363__auto__.call(null);
(statearr_17809[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17867 = [];
var len__5726__auto___17870 = arguments.length;
var i__5727__auto___17871 = (0);
while(true){
if((i__5727__auto___17871 < len__5726__auto___17870)){
args17867.push((arguments[i__5727__auto___17871]));

var G__17872 = (i__5727__auto___17871 + (1));
i__5727__auto___17871 = G__17872;
continue;
} else {
}
break;
}

var G__17869 = args17867.length;
switch (G__17869) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17867.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17874 = [];
var len__5726__auto___17877 = arguments.length;
var i__5727__auto___17878 = (0);
while(true){
if((i__5727__auto___17878 < len__5726__auto___17877)){
args17874.push((arguments[i__5727__auto___17878]));

var G__17879 = (i__5727__auto___17878 + (1));
i__5727__auto___17878 = G__17879;
continue;
} else {
}
break;
}

var G__17876 = args17874.length;
switch (G__17876) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17874.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17881 = [];
var len__5726__auto___17934 = arguments.length;
var i__5727__auto___17935 = (0);
while(true){
if((i__5727__auto___17935 < len__5726__auto___17934)){
args17881.push((arguments[i__5727__auto___17935]));

var G__17936 = (i__5727__auto___17935 + (1));
i__5727__auto___17935 = G__17936;
continue;
} else {
}
break;
}

var G__17883 = args17881.length;
switch (G__17883) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17881.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17938 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17938,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17938,tc,fc){
return (function (state_17909){
var state_val_17910 = (state_17909[(1)]);
if((state_val_17910 === (7))){
var inst_17905 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
var statearr_17911_17939 = state_17909__$1;
(statearr_17911_17939[(2)] = inst_17905);

(statearr_17911_17939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (1))){
var state_17909__$1 = state_17909;
var statearr_17912_17940 = state_17909__$1;
(statearr_17912_17940[(2)] = null);

(statearr_17912_17940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (4))){
var inst_17886 = (state_17909[(7)]);
var inst_17886__$1 = (state_17909[(2)]);
var inst_17887 = (inst_17886__$1 == null);
var state_17909__$1 = (function (){var statearr_17913 = state_17909;
(statearr_17913[(7)] = inst_17886__$1);

return statearr_17913;
})();
if(cljs.core.truth_(inst_17887)){
var statearr_17914_17941 = state_17909__$1;
(statearr_17914_17941[(1)] = (5));

} else {
var statearr_17915_17942 = state_17909__$1;
(statearr_17915_17942[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (13))){
var state_17909__$1 = state_17909;
var statearr_17916_17943 = state_17909__$1;
(statearr_17916_17943[(2)] = null);

(statearr_17916_17943[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (6))){
var inst_17886 = (state_17909[(7)]);
var inst_17892 = p.call(null,inst_17886);
var state_17909__$1 = state_17909;
if(cljs.core.truth_(inst_17892)){
var statearr_17917_17944 = state_17909__$1;
(statearr_17917_17944[(1)] = (9));

} else {
var statearr_17918_17945 = state_17909__$1;
(statearr_17918_17945[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (3))){
var inst_17907 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17909__$1,inst_17907);
} else {
if((state_val_17910 === (12))){
var state_17909__$1 = state_17909;
var statearr_17919_17946 = state_17909__$1;
(statearr_17919_17946[(2)] = null);

(statearr_17919_17946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (2))){
var state_17909__$1 = state_17909;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17909__$1,(4),ch);
} else {
if((state_val_17910 === (11))){
var inst_17886 = (state_17909[(7)]);
var inst_17896 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17909__$1,(8),inst_17896,inst_17886);
} else {
if((state_val_17910 === (9))){
var state_17909__$1 = state_17909;
var statearr_17920_17947 = state_17909__$1;
(statearr_17920_17947[(2)] = tc);

(statearr_17920_17947[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (5))){
var inst_17889 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17890 = cljs.core.async.close_BANG_.call(null,fc);
var state_17909__$1 = (function (){var statearr_17921 = state_17909;
(statearr_17921[(8)] = inst_17889);

return statearr_17921;
})();
var statearr_17922_17948 = state_17909__$1;
(statearr_17922_17948[(2)] = inst_17890);

(statearr_17922_17948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (14))){
var inst_17903 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
var statearr_17923_17949 = state_17909__$1;
(statearr_17923_17949[(2)] = inst_17903);

(statearr_17923_17949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (10))){
var state_17909__$1 = state_17909;
var statearr_17924_17950 = state_17909__$1;
(statearr_17924_17950[(2)] = fc);

(statearr_17924_17950[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17910 === (8))){
var inst_17898 = (state_17909[(2)]);
var state_17909__$1 = state_17909;
if(cljs.core.truth_(inst_17898)){
var statearr_17925_17951 = state_17909__$1;
(statearr_17925_17951[(1)] = (12));

} else {
var statearr_17926_17952 = state_17909__$1;
(statearr_17926_17952[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17938,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17938,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17930 = [null,null,null,null,null,null,null,null,null];
(statearr_17930[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17930[(1)] = (1));

return statearr_17930;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17909){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17931){if((e17931 instanceof Object)){
var ex__8254__auto__ = e17931;
var statearr_17932_17953 = state_17909;
(statearr_17932_17953[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17931;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17954 = state_17909;
state_17909 = G__17954;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17938,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17933 = f__8363__auto__.call(null);
(statearr_17933[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17938);

return statearr_17933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17938,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18018){
var state_val_18019 = (state_18018[(1)]);
if((state_val_18019 === (7))){
var inst_18014 = (state_18018[(2)]);
var state_18018__$1 = state_18018;
var statearr_18020_18041 = state_18018__$1;
(statearr_18020_18041[(2)] = inst_18014);

(statearr_18020_18041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18019 === (1))){
var inst_17998 = init;
var state_18018__$1 = (function (){var statearr_18021 = state_18018;
(statearr_18021[(7)] = inst_17998);

return statearr_18021;
})();
var statearr_18022_18042 = state_18018__$1;
(statearr_18022_18042[(2)] = null);

(statearr_18022_18042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18019 === (4))){
var inst_18001 = (state_18018[(8)]);
var inst_18001__$1 = (state_18018[(2)]);
var inst_18002 = (inst_18001__$1 == null);
var state_18018__$1 = (function (){var statearr_18023 = state_18018;
(statearr_18023[(8)] = inst_18001__$1);

return statearr_18023;
})();
if(cljs.core.truth_(inst_18002)){
var statearr_18024_18043 = state_18018__$1;
(statearr_18024_18043[(1)] = (5));

} else {
var statearr_18025_18044 = state_18018__$1;
(statearr_18025_18044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18019 === (6))){
var inst_18005 = (state_18018[(9)]);
var inst_18001 = (state_18018[(8)]);
var inst_17998 = (state_18018[(7)]);
var inst_18005__$1 = f.call(null,inst_17998,inst_18001);
var inst_18006 = cljs.core.reduced_QMARK_.call(null,inst_18005__$1);
var state_18018__$1 = (function (){var statearr_18026 = state_18018;
(statearr_18026[(9)] = inst_18005__$1);

return statearr_18026;
})();
if(inst_18006){
var statearr_18027_18045 = state_18018__$1;
(statearr_18027_18045[(1)] = (8));

} else {
var statearr_18028_18046 = state_18018__$1;
(statearr_18028_18046[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18019 === (3))){
var inst_18016 = (state_18018[(2)]);
var state_18018__$1 = state_18018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18018__$1,inst_18016);
} else {
if((state_val_18019 === (2))){
var state_18018__$1 = state_18018;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18018__$1,(4),ch);
} else {
if((state_val_18019 === (9))){
var inst_18005 = (state_18018[(9)]);
var inst_17998 = inst_18005;
var state_18018__$1 = (function (){var statearr_18029 = state_18018;
(statearr_18029[(7)] = inst_17998);

return statearr_18029;
})();
var statearr_18030_18047 = state_18018__$1;
(statearr_18030_18047[(2)] = null);

(statearr_18030_18047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18019 === (5))){
var inst_17998 = (state_18018[(7)]);
var state_18018__$1 = state_18018;
var statearr_18031_18048 = state_18018__$1;
(statearr_18031_18048[(2)] = inst_17998);

(statearr_18031_18048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18019 === (10))){
var inst_18012 = (state_18018[(2)]);
var state_18018__$1 = state_18018;
var statearr_18032_18049 = state_18018__$1;
(statearr_18032_18049[(2)] = inst_18012);

(statearr_18032_18049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18019 === (8))){
var inst_18005 = (state_18018[(9)]);
var inst_18008 = cljs.core.deref.call(null,inst_18005);
var state_18018__$1 = state_18018;
var statearr_18033_18050 = state_18018__$1;
(statearr_18033_18050[(2)] = inst_18008);

(statearr_18033_18050[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18037 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18037[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18037[(1)] = (1));

return statearr_18037;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18018){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18038){if((e18038 instanceof Object)){
var ex__8254__auto__ = e18038;
var statearr_18039_18051 = state_18018;
(statearr_18039_18051[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18018);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18038;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18052 = state_18018;
state_18018 = G__18052;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18018){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18040 = f__8363__auto__.call(null);
(statearr_18040[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18053 = [];
var len__5726__auto___18105 = arguments.length;
var i__5727__auto___18106 = (0);
while(true){
if((i__5727__auto___18106 < len__5726__auto___18105)){
args18053.push((arguments[i__5727__auto___18106]));

var G__18107 = (i__5727__auto___18106 + (1));
i__5727__auto___18106 = G__18107;
continue;
} else {
}
break;
}

var G__18055 = args18053.length;
switch (G__18055) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18053.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18080){
var state_val_18081 = (state_18080[(1)]);
if((state_val_18081 === (7))){
var inst_18062 = (state_18080[(2)]);
var state_18080__$1 = state_18080;
var statearr_18082_18109 = state_18080__$1;
(statearr_18082_18109[(2)] = inst_18062);

(statearr_18082_18109[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (1))){
var inst_18056 = cljs.core.seq.call(null,coll);
var inst_18057 = inst_18056;
var state_18080__$1 = (function (){var statearr_18083 = state_18080;
(statearr_18083[(7)] = inst_18057);

return statearr_18083;
})();
var statearr_18084_18110 = state_18080__$1;
(statearr_18084_18110[(2)] = null);

(statearr_18084_18110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (4))){
var inst_18057 = (state_18080[(7)]);
var inst_18060 = cljs.core.first.call(null,inst_18057);
var state_18080__$1 = state_18080;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18080__$1,(7),ch,inst_18060);
} else {
if((state_val_18081 === (13))){
var inst_18074 = (state_18080[(2)]);
var state_18080__$1 = state_18080;
var statearr_18085_18111 = state_18080__$1;
(statearr_18085_18111[(2)] = inst_18074);

(statearr_18085_18111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (6))){
var inst_18065 = (state_18080[(2)]);
var state_18080__$1 = state_18080;
if(cljs.core.truth_(inst_18065)){
var statearr_18086_18112 = state_18080__$1;
(statearr_18086_18112[(1)] = (8));

} else {
var statearr_18087_18113 = state_18080__$1;
(statearr_18087_18113[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (3))){
var inst_18078 = (state_18080[(2)]);
var state_18080__$1 = state_18080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18080__$1,inst_18078);
} else {
if((state_val_18081 === (12))){
var state_18080__$1 = state_18080;
var statearr_18088_18114 = state_18080__$1;
(statearr_18088_18114[(2)] = null);

(statearr_18088_18114[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (2))){
var inst_18057 = (state_18080[(7)]);
var state_18080__$1 = state_18080;
if(cljs.core.truth_(inst_18057)){
var statearr_18089_18115 = state_18080__$1;
(statearr_18089_18115[(1)] = (4));

} else {
var statearr_18090_18116 = state_18080__$1;
(statearr_18090_18116[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (11))){
var inst_18071 = cljs.core.async.close_BANG_.call(null,ch);
var state_18080__$1 = state_18080;
var statearr_18091_18117 = state_18080__$1;
(statearr_18091_18117[(2)] = inst_18071);

(statearr_18091_18117[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (9))){
var state_18080__$1 = state_18080;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18092_18118 = state_18080__$1;
(statearr_18092_18118[(1)] = (11));

} else {
var statearr_18093_18119 = state_18080__$1;
(statearr_18093_18119[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (5))){
var inst_18057 = (state_18080[(7)]);
var state_18080__$1 = state_18080;
var statearr_18094_18120 = state_18080__$1;
(statearr_18094_18120[(2)] = inst_18057);

(statearr_18094_18120[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (10))){
var inst_18076 = (state_18080[(2)]);
var state_18080__$1 = state_18080;
var statearr_18095_18121 = state_18080__$1;
(statearr_18095_18121[(2)] = inst_18076);

(statearr_18095_18121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18081 === (8))){
var inst_18057 = (state_18080[(7)]);
var inst_18067 = cljs.core.next.call(null,inst_18057);
var inst_18057__$1 = inst_18067;
var state_18080__$1 = (function (){var statearr_18096 = state_18080;
(statearr_18096[(7)] = inst_18057__$1);

return statearr_18096;
})();
var statearr_18097_18122 = state_18080__$1;
(statearr_18097_18122[(2)] = null);

(statearr_18097_18122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18101 = [null,null,null,null,null,null,null,null];
(statearr_18101[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18101[(1)] = (1));

return statearr_18101;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18080){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18102){if((e18102 instanceof Object)){
var ex__8254__auto__ = e18102;
var statearr_18103_18123 = state_18080;
(statearr_18103_18123[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18102;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18124 = state_18080;
state_18080 = G__18124;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18080){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18104 = f__8363__auto__.call(null);
(statearr_18104[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18346 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18346 = (function (mult,ch,cs,meta18347){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18347 = meta18347;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18346.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18348,meta18347__$1){
var self__ = this;
var _18348__$1 = this;
return (new cljs.core.async.t_cljs$core$async18346(self__.mult,self__.ch,self__.cs,meta18347__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18346.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18348){
var self__ = this;
var _18348__$1 = this;
return self__.meta18347;
});})(cs))
;

cljs.core.async.t_cljs$core$async18346.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18346.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18346.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18346.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18346.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18346.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18346.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18347","meta18347",-675144860,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18346.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18346.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18346";

cljs.core.async.t_cljs$core$async18346.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18346");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18346 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18346(mult__$1,ch__$1,cs__$1,meta18347){
return (new cljs.core.async.t_cljs$core$async18346(mult__$1,ch__$1,cs__$1,meta18347));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18346(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18567 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18567,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18567,cs,m,dchan,dctr,done){
return (function (state_18479){
var state_val_18480 = (state_18479[(1)]);
if((state_val_18480 === (7))){
var inst_18475 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18481_18568 = state_18479__$1;
(statearr_18481_18568[(2)] = inst_18475);

(statearr_18481_18568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (20))){
var inst_18380 = (state_18479[(7)]);
var inst_18390 = cljs.core.first.call(null,inst_18380);
var inst_18391 = cljs.core.nth.call(null,inst_18390,(0),null);
var inst_18392 = cljs.core.nth.call(null,inst_18390,(1),null);
var state_18479__$1 = (function (){var statearr_18482 = state_18479;
(statearr_18482[(8)] = inst_18391);

return statearr_18482;
})();
if(cljs.core.truth_(inst_18392)){
var statearr_18483_18569 = state_18479__$1;
(statearr_18483_18569[(1)] = (22));

} else {
var statearr_18484_18570 = state_18479__$1;
(statearr_18484_18570[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (27))){
var inst_18420 = (state_18479[(9)]);
var inst_18351 = (state_18479[(10)]);
var inst_18427 = (state_18479[(11)]);
var inst_18422 = (state_18479[(12)]);
var inst_18427__$1 = cljs.core._nth.call(null,inst_18420,inst_18422);
var inst_18428 = cljs.core.async.put_BANG_.call(null,inst_18427__$1,inst_18351,done);
var state_18479__$1 = (function (){var statearr_18485 = state_18479;
(statearr_18485[(11)] = inst_18427__$1);

return statearr_18485;
})();
if(cljs.core.truth_(inst_18428)){
var statearr_18486_18571 = state_18479__$1;
(statearr_18486_18571[(1)] = (30));

} else {
var statearr_18487_18572 = state_18479__$1;
(statearr_18487_18572[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (1))){
var state_18479__$1 = state_18479;
var statearr_18488_18573 = state_18479__$1;
(statearr_18488_18573[(2)] = null);

(statearr_18488_18573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (24))){
var inst_18380 = (state_18479[(7)]);
var inst_18397 = (state_18479[(2)]);
var inst_18398 = cljs.core.next.call(null,inst_18380);
var inst_18360 = inst_18398;
var inst_18361 = null;
var inst_18362 = (0);
var inst_18363 = (0);
var state_18479__$1 = (function (){var statearr_18489 = state_18479;
(statearr_18489[(13)] = inst_18361);

(statearr_18489[(14)] = inst_18363);

(statearr_18489[(15)] = inst_18362);

(statearr_18489[(16)] = inst_18360);

(statearr_18489[(17)] = inst_18397);

return statearr_18489;
})();
var statearr_18490_18574 = state_18479__$1;
(statearr_18490_18574[(2)] = null);

(statearr_18490_18574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (39))){
var state_18479__$1 = state_18479;
var statearr_18494_18575 = state_18479__$1;
(statearr_18494_18575[(2)] = null);

(statearr_18494_18575[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (4))){
var inst_18351 = (state_18479[(10)]);
var inst_18351__$1 = (state_18479[(2)]);
var inst_18352 = (inst_18351__$1 == null);
var state_18479__$1 = (function (){var statearr_18495 = state_18479;
(statearr_18495[(10)] = inst_18351__$1);

return statearr_18495;
})();
if(cljs.core.truth_(inst_18352)){
var statearr_18496_18576 = state_18479__$1;
(statearr_18496_18576[(1)] = (5));

} else {
var statearr_18497_18577 = state_18479__$1;
(statearr_18497_18577[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (15))){
var inst_18361 = (state_18479[(13)]);
var inst_18363 = (state_18479[(14)]);
var inst_18362 = (state_18479[(15)]);
var inst_18360 = (state_18479[(16)]);
var inst_18376 = (state_18479[(2)]);
var inst_18377 = (inst_18363 + (1));
var tmp18491 = inst_18361;
var tmp18492 = inst_18362;
var tmp18493 = inst_18360;
var inst_18360__$1 = tmp18493;
var inst_18361__$1 = tmp18491;
var inst_18362__$1 = tmp18492;
var inst_18363__$1 = inst_18377;
var state_18479__$1 = (function (){var statearr_18498 = state_18479;
(statearr_18498[(13)] = inst_18361__$1);

(statearr_18498[(14)] = inst_18363__$1);

(statearr_18498[(18)] = inst_18376);

(statearr_18498[(15)] = inst_18362__$1);

(statearr_18498[(16)] = inst_18360__$1);

return statearr_18498;
})();
var statearr_18499_18578 = state_18479__$1;
(statearr_18499_18578[(2)] = null);

(statearr_18499_18578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (21))){
var inst_18401 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18503_18579 = state_18479__$1;
(statearr_18503_18579[(2)] = inst_18401);

(statearr_18503_18579[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (31))){
var inst_18427 = (state_18479[(11)]);
var inst_18431 = done.call(null,null);
var inst_18432 = cljs.core.async.untap_STAR_.call(null,m,inst_18427);
var state_18479__$1 = (function (){var statearr_18504 = state_18479;
(statearr_18504[(19)] = inst_18431);

return statearr_18504;
})();
var statearr_18505_18580 = state_18479__$1;
(statearr_18505_18580[(2)] = inst_18432);

(statearr_18505_18580[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (32))){
var inst_18420 = (state_18479[(9)]);
var inst_18419 = (state_18479[(20)]);
var inst_18421 = (state_18479[(21)]);
var inst_18422 = (state_18479[(12)]);
var inst_18434 = (state_18479[(2)]);
var inst_18435 = (inst_18422 + (1));
var tmp18500 = inst_18420;
var tmp18501 = inst_18419;
var tmp18502 = inst_18421;
var inst_18419__$1 = tmp18501;
var inst_18420__$1 = tmp18500;
var inst_18421__$1 = tmp18502;
var inst_18422__$1 = inst_18435;
var state_18479__$1 = (function (){var statearr_18506 = state_18479;
(statearr_18506[(22)] = inst_18434);

(statearr_18506[(9)] = inst_18420__$1);

(statearr_18506[(20)] = inst_18419__$1);

(statearr_18506[(21)] = inst_18421__$1);

(statearr_18506[(12)] = inst_18422__$1);

return statearr_18506;
})();
var statearr_18507_18581 = state_18479__$1;
(statearr_18507_18581[(2)] = null);

(statearr_18507_18581[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (40))){
var inst_18447 = (state_18479[(23)]);
var inst_18451 = done.call(null,null);
var inst_18452 = cljs.core.async.untap_STAR_.call(null,m,inst_18447);
var state_18479__$1 = (function (){var statearr_18508 = state_18479;
(statearr_18508[(24)] = inst_18451);

return statearr_18508;
})();
var statearr_18509_18582 = state_18479__$1;
(statearr_18509_18582[(2)] = inst_18452);

(statearr_18509_18582[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (33))){
var inst_18438 = (state_18479[(25)]);
var inst_18440 = cljs.core.chunked_seq_QMARK_.call(null,inst_18438);
var state_18479__$1 = state_18479;
if(inst_18440){
var statearr_18510_18583 = state_18479__$1;
(statearr_18510_18583[(1)] = (36));

} else {
var statearr_18511_18584 = state_18479__$1;
(statearr_18511_18584[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (13))){
var inst_18370 = (state_18479[(26)]);
var inst_18373 = cljs.core.async.close_BANG_.call(null,inst_18370);
var state_18479__$1 = state_18479;
var statearr_18512_18585 = state_18479__$1;
(statearr_18512_18585[(2)] = inst_18373);

(statearr_18512_18585[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (22))){
var inst_18391 = (state_18479[(8)]);
var inst_18394 = cljs.core.async.close_BANG_.call(null,inst_18391);
var state_18479__$1 = state_18479;
var statearr_18513_18586 = state_18479__$1;
(statearr_18513_18586[(2)] = inst_18394);

(statearr_18513_18586[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (36))){
var inst_18438 = (state_18479[(25)]);
var inst_18442 = cljs.core.chunk_first.call(null,inst_18438);
var inst_18443 = cljs.core.chunk_rest.call(null,inst_18438);
var inst_18444 = cljs.core.count.call(null,inst_18442);
var inst_18419 = inst_18443;
var inst_18420 = inst_18442;
var inst_18421 = inst_18444;
var inst_18422 = (0);
var state_18479__$1 = (function (){var statearr_18514 = state_18479;
(statearr_18514[(9)] = inst_18420);

(statearr_18514[(20)] = inst_18419);

(statearr_18514[(21)] = inst_18421);

(statearr_18514[(12)] = inst_18422);

return statearr_18514;
})();
var statearr_18515_18587 = state_18479__$1;
(statearr_18515_18587[(2)] = null);

(statearr_18515_18587[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (41))){
var inst_18438 = (state_18479[(25)]);
var inst_18454 = (state_18479[(2)]);
var inst_18455 = cljs.core.next.call(null,inst_18438);
var inst_18419 = inst_18455;
var inst_18420 = null;
var inst_18421 = (0);
var inst_18422 = (0);
var state_18479__$1 = (function (){var statearr_18516 = state_18479;
(statearr_18516[(9)] = inst_18420);

(statearr_18516[(20)] = inst_18419);

(statearr_18516[(21)] = inst_18421);

(statearr_18516[(12)] = inst_18422);

(statearr_18516[(27)] = inst_18454);

return statearr_18516;
})();
var statearr_18517_18588 = state_18479__$1;
(statearr_18517_18588[(2)] = null);

(statearr_18517_18588[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (43))){
var state_18479__$1 = state_18479;
var statearr_18518_18589 = state_18479__$1;
(statearr_18518_18589[(2)] = null);

(statearr_18518_18589[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (29))){
var inst_18463 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18519_18590 = state_18479__$1;
(statearr_18519_18590[(2)] = inst_18463);

(statearr_18519_18590[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (44))){
var inst_18472 = (state_18479[(2)]);
var state_18479__$1 = (function (){var statearr_18520 = state_18479;
(statearr_18520[(28)] = inst_18472);

return statearr_18520;
})();
var statearr_18521_18591 = state_18479__$1;
(statearr_18521_18591[(2)] = null);

(statearr_18521_18591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (6))){
var inst_18411 = (state_18479[(29)]);
var inst_18410 = cljs.core.deref.call(null,cs);
var inst_18411__$1 = cljs.core.keys.call(null,inst_18410);
var inst_18412 = cljs.core.count.call(null,inst_18411__$1);
var inst_18413 = cljs.core.reset_BANG_.call(null,dctr,inst_18412);
var inst_18418 = cljs.core.seq.call(null,inst_18411__$1);
var inst_18419 = inst_18418;
var inst_18420 = null;
var inst_18421 = (0);
var inst_18422 = (0);
var state_18479__$1 = (function (){var statearr_18522 = state_18479;
(statearr_18522[(29)] = inst_18411__$1);

(statearr_18522[(9)] = inst_18420);

(statearr_18522[(20)] = inst_18419);

(statearr_18522[(21)] = inst_18421);

(statearr_18522[(30)] = inst_18413);

(statearr_18522[(12)] = inst_18422);

return statearr_18522;
})();
var statearr_18523_18592 = state_18479__$1;
(statearr_18523_18592[(2)] = null);

(statearr_18523_18592[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (28))){
var inst_18438 = (state_18479[(25)]);
var inst_18419 = (state_18479[(20)]);
var inst_18438__$1 = cljs.core.seq.call(null,inst_18419);
var state_18479__$1 = (function (){var statearr_18524 = state_18479;
(statearr_18524[(25)] = inst_18438__$1);

return statearr_18524;
})();
if(inst_18438__$1){
var statearr_18525_18593 = state_18479__$1;
(statearr_18525_18593[(1)] = (33));

} else {
var statearr_18526_18594 = state_18479__$1;
(statearr_18526_18594[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (25))){
var inst_18421 = (state_18479[(21)]);
var inst_18422 = (state_18479[(12)]);
var inst_18424 = (inst_18422 < inst_18421);
var inst_18425 = inst_18424;
var state_18479__$1 = state_18479;
if(cljs.core.truth_(inst_18425)){
var statearr_18527_18595 = state_18479__$1;
(statearr_18527_18595[(1)] = (27));

} else {
var statearr_18528_18596 = state_18479__$1;
(statearr_18528_18596[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (34))){
var state_18479__$1 = state_18479;
var statearr_18529_18597 = state_18479__$1;
(statearr_18529_18597[(2)] = null);

(statearr_18529_18597[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (17))){
var state_18479__$1 = state_18479;
var statearr_18530_18598 = state_18479__$1;
(statearr_18530_18598[(2)] = null);

(statearr_18530_18598[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (3))){
var inst_18477 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18479__$1,inst_18477);
} else {
if((state_val_18480 === (12))){
var inst_18406 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18531_18599 = state_18479__$1;
(statearr_18531_18599[(2)] = inst_18406);

(statearr_18531_18599[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (2))){
var state_18479__$1 = state_18479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18479__$1,(4),ch);
} else {
if((state_val_18480 === (23))){
var state_18479__$1 = state_18479;
var statearr_18532_18600 = state_18479__$1;
(statearr_18532_18600[(2)] = null);

(statearr_18532_18600[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (35))){
var inst_18461 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18533_18601 = state_18479__$1;
(statearr_18533_18601[(2)] = inst_18461);

(statearr_18533_18601[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (19))){
var inst_18380 = (state_18479[(7)]);
var inst_18384 = cljs.core.chunk_first.call(null,inst_18380);
var inst_18385 = cljs.core.chunk_rest.call(null,inst_18380);
var inst_18386 = cljs.core.count.call(null,inst_18384);
var inst_18360 = inst_18385;
var inst_18361 = inst_18384;
var inst_18362 = inst_18386;
var inst_18363 = (0);
var state_18479__$1 = (function (){var statearr_18534 = state_18479;
(statearr_18534[(13)] = inst_18361);

(statearr_18534[(14)] = inst_18363);

(statearr_18534[(15)] = inst_18362);

(statearr_18534[(16)] = inst_18360);

return statearr_18534;
})();
var statearr_18535_18602 = state_18479__$1;
(statearr_18535_18602[(2)] = null);

(statearr_18535_18602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (11))){
var inst_18380 = (state_18479[(7)]);
var inst_18360 = (state_18479[(16)]);
var inst_18380__$1 = cljs.core.seq.call(null,inst_18360);
var state_18479__$1 = (function (){var statearr_18536 = state_18479;
(statearr_18536[(7)] = inst_18380__$1);

return statearr_18536;
})();
if(inst_18380__$1){
var statearr_18537_18603 = state_18479__$1;
(statearr_18537_18603[(1)] = (16));

} else {
var statearr_18538_18604 = state_18479__$1;
(statearr_18538_18604[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (9))){
var inst_18408 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18539_18605 = state_18479__$1;
(statearr_18539_18605[(2)] = inst_18408);

(statearr_18539_18605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (5))){
var inst_18358 = cljs.core.deref.call(null,cs);
var inst_18359 = cljs.core.seq.call(null,inst_18358);
var inst_18360 = inst_18359;
var inst_18361 = null;
var inst_18362 = (0);
var inst_18363 = (0);
var state_18479__$1 = (function (){var statearr_18540 = state_18479;
(statearr_18540[(13)] = inst_18361);

(statearr_18540[(14)] = inst_18363);

(statearr_18540[(15)] = inst_18362);

(statearr_18540[(16)] = inst_18360);

return statearr_18540;
})();
var statearr_18541_18606 = state_18479__$1;
(statearr_18541_18606[(2)] = null);

(statearr_18541_18606[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (14))){
var state_18479__$1 = state_18479;
var statearr_18542_18607 = state_18479__$1;
(statearr_18542_18607[(2)] = null);

(statearr_18542_18607[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (45))){
var inst_18469 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18543_18608 = state_18479__$1;
(statearr_18543_18608[(2)] = inst_18469);

(statearr_18543_18608[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (26))){
var inst_18411 = (state_18479[(29)]);
var inst_18465 = (state_18479[(2)]);
var inst_18466 = cljs.core.seq.call(null,inst_18411);
var state_18479__$1 = (function (){var statearr_18544 = state_18479;
(statearr_18544[(31)] = inst_18465);

return statearr_18544;
})();
if(inst_18466){
var statearr_18545_18609 = state_18479__$1;
(statearr_18545_18609[(1)] = (42));

} else {
var statearr_18546_18610 = state_18479__$1;
(statearr_18546_18610[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (16))){
var inst_18380 = (state_18479[(7)]);
var inst_18382 = cljs.core.chunked_seq_QMARK_.call(null,inst_18380);
var state_18479__$1 = state_18479;
if(inst_18382){
var statearr_18547_18611 = state_18479__$1;
(statearr_18547_18611[(1)] = (19));

} else {
var statearr_18548_18612 = state_18479__$1;
(statearr_18548_18612[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (38))){
var inst_18458 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18549_18613 = state_18479__$1;
(statearr_18549_18613[(2)] = inst_18458);

(statearr_18549_18613[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (30))){
var state_18479__$1 = state_18479;
var statearr_18550_18614 = state_18479__$1;
(statearr_18550_18614[(2)] = null);

(statearr_18550_18614[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (10))){
var inst_18361 = (state_18479[(13)]);
var inst_18363 = (state_18479[(14)]);
var inst_18369 = cljs.core._nth.call(null,inst_18361,inst_18363);
var inst_18370 = cljs.core.nth.call(null,inst_18369,(0),null);
var inst_18371 = cljs.core.nth.call(null,inst_18369,(1),null);
var state_18479__$1 = (function (){var statearr_18551 = state_18479;
(statearr_18551[(26)] = inst_18370);

return statearr_18551;
})();
if(cljs.core.truth_(inst_18371)){
var statearr_18552_18615 = state_18479__$1;
(statearr_18552_18615[(1)] = (13));

} else {
var statearr_18553_18616 = state_18479__$1;
(statearr_18553_18616[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (18))){
var inst_18404 = (state_18479[(2)]);
var state_18479__$1 = state_18479;
var statearr_18554_18617 = state_18479__$1;
(statearr_18554_18617[(2)] = inst_18404);

(statearr_18554_18617[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (42))){
var state_18479__$1 = state_18479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18479__$1,(45),dchan);
} else {
if((state_val_18480 === (37))){
var inst_18438 = (state_18479[(25)]);
var inst_18447 = (state_18479[(23)]);
var inst_18351 = (state_18479[(10)]);
var inst_18447__$1 = cljs.core.first.call(null,inst_18438);
var inst_18448 = cljs.core.async.put_BANG_.call(null,inst_18447__$1,inst_18351,done);
var state_18479__$1 = (function (){var statearr_18555 = state_18479;
(statearr_18555[(23)] = inst_18447__$1);

return statearr_18555;
})();
if(cljs.core.truth_(inst_18448)){
var statearr_18556_18618 = state_18479__$1;
(statearr_18556_18618[(1)] = (39));

} else {
var statearr_18557_18619 = state_18479__$1;
(statearr_18557_18619[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18480 === (8))){
var inst_18363 = (state_18479[(14)]);
var inst_18362 = (state_18479[(15)]);
var inst_18365 = (inst_18363 < inst_18362);
var inst_18366 = inst_18365;
var state_18479__$1 = state_18479;
if(cljs.core.truth_(inst_18366)){
var statearr_18558_18620 = state_18479__$1;
(statearr_18558_18620[(1)] = (10));

} else {
var statearr_18559_18621 = state_18479__$1;
(statearr_18559_18621[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18567,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18567,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18563 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18563[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18563[(1)] = (1));

return statearr_18563;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18479){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18564){if((e18564 instanceof Object)){
var ex__8254__auto__ = e18564;
var statearr_18565_18622 = state_18479;
(statearr_18565_18622[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18479);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18564;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18623 = state_18479;
state_18479 = G__18623;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18479){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18567,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18566 = f__8363__auto__.call(null);
(statearr_18566[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18567);

return statearr_18566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18567,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18624 = [];
var len__5726__auto___18627 = arguments.length;
var i__5727__auto___18628 = (0);
while(true){
if((i__5727__auto___18628 < len__5726__auto___18627)){
args18624.push((arguments[i__5727__auto___18628]));

var G__18629 = (i__5727__auto___18628 + (1));
i__5727__auto___18628 = G__18629;
continue;
} else {
}
break;
}

var G__18626 = args18624.length;
switch (G__18626) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18624.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18641 = arguments.length;
var i__5727__auto___18642 = (0);
while(true){
if((i__5727__auto___18642 < len__5726__auto___18641)){
args__5733__auto__.push((arguments[i__5727__auto___18642]));

var G__18643 = (i__5727__auto___18642 + (1));
i__5727__auto___18642 = G__18643;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18635){
var map__18636 = p__18635;
var map__18636__$1 = ((((!((map__18636 == null)))?((((map__18636.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18636.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18636):map__18636);
var opts = map__18636__$1;
var statearr_18638_18644 = state;
(statearr_18638_18644[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18636,map__18636__$1,opts){
return (function (val){
var statearr_18639_18645 = state;
(statearr_18639_18645[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18636,map__18636__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18640_18646 = state;
(statearr_18640_18646[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18631){
var G__18632 = cljs.core.first.call(null,seq18631);
var seq18631__$1 = cljs.core.next.call(null,seq18631);
var G__18633 = cljs.core.first.call(null,seq18631__$1);
var seq18631__$2 = cljs.core.next.call(null,seq18631__$1);
var G__18634 = cljs.core.first.call(null,seq18631__$2);
var seq18631__$3 = cljs.core.next.call(null,seq18631__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18632,G__18633,G__18634,seq18631__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18810 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18810 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18811){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18811 = meta18811;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18812,meta18811__$1){
var self__ = this;
var _18812__$1 = this;
return (new cljs.core.async.t_cljs$core$async18810(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18811__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18812){
var self__ = this;
var _18812__$1 = this;
return self__.meta18811;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18811","meta18811",1568642675,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18810.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18810.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18810";

cljs.core.async.t_cljs$core$async18810.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18810");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18810 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18810(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18811){
return (new cljs.core.async.t_cljs$core$async18810(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18811));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18810(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___18973 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18973,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18973,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18910){
var state_val_18911 = (state_18910[(1)]);
if((state_val_18911 === (7))){
var inst_18828 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
var statearr_18912_18974 = state_18910__$1;
(statearr_18912_18974[(2)] = inst_18828);

(statearr_18912_18974[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (20))){
var inst_18840 = (state_18910[(7)]);
var state_18910__$1 = state_18910;
var statearr_18913_18975 = state_18910__$1;
(statearr_18913_18975[(2)] = inst_18840);

(statearr_18913_18975[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (27))){
var state_18910__$1 = state_18910;
var statearr_18914_18976 = state_18910__$1;
(statearr_18914_18976[(2)] = null);

(statearr_18914_18976[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (1))){
var inst_18816 = (state_18910[(8)]);
var inst_18816__$1 = calc_state.call(null);
var inst_18818 = (inst_18816__$1 == null);
var inst_18819 = cljs.core.not.call(null,inst_18818);
var state_18910__$1 = (function (){var statearr_18915 = state_18910;
(statearr_18915[(8)] = inst_18816__$1);

return statearr_18915;
})();
if(inst_18819){
var statearr_18916_18977 = state_18910__$1;
(statearr_18916_18977[(1)] = (2));

} else {
var statearr_18917_18978 = state_18910__$1;
(statearr_18917_18978[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (24))){
var inst_18870 = (state_18910[(9)]);
var inst_18884 = (state_18910[(10)]);
var inst_18863 = (state_18910[(11)]);
var inst_18884__$1 = inst_18863.call(null,inst_18870);
var state_18910__$1 = (function (){var statearr_18918 = state_18910;
(statearr_18918[(10)] = inst_18884__$1);

return statearr_18918;
})();
if(cljs.core.truth_(inst_18884__$1)){
var statearr_18919_18979 = state_18910__$1;
(statearr_18919_18979[(1)] = (29));

} else {
var statearr_18920_18980 = state_18910__$1;
(statearr_18920_18980[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (4))){
var inst_18831 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
if(cljs.core.truth_(inst_18831)){
var statearr_18921_18981 = state_18910__$1;
(statearr_18921_18981[(1)] = (8));

} else {
var statearr_18922_18982 = state_18910__$1;
(statearr_18922_18982[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (15))){
var inst_18857 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
if(cljs.core.truth_(inst_18857)){
var statearr_18923_18983 = state_18910__$1;
(statearr_18923_18983[(1)] = (19));

} else {
var statearr_18924_18984 = state_18910__$1;
(statearr_18924_18984[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (21))){
var inst_18862 = (state_18910[(12)]);
var inst_18862__$1 = (state_18910[(2)]);
var inst_18863 = cljs.core.get.call(null,inst_18862__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18864 = cljs.core.get.call(null,inst_18862__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18865 = cljs.core.get.call(null,inst_18862__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18910__$1 = (function (){var statearr_18925 = state_18910;
(statearr_18925[(13)] = inst_18864);

(statearr_18925[(11)] = inst_18863);

(statearr_18925[(12)] = inst_18862__$1);

return statearr_18925;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18910__$1,(22),inst_18865);
} else {
if((state_val_18911 === (31))){
var inst_18892 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
if(cljs.core.truth_(inst_18892)){
var statearr_18926_18985 = state_18910__$1;
(statearr_18926_18985[(1)] = (32));

} else {
var statearr_18927_18986 = state_18910__$1;
(statearr_18927_18986[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (32))){
var inst_18869 = (state_18910[(14)]);
var state_18910__$1 = state_18910;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18910__$1,(35),out,inst_18869);
} else {
if((state_val_18911 === (33))){
var inst_18862 = (state_18910[(12)]);
var inst_18840 = inst_18862;
var state_18910__$1 = (function (){var statearr_18928 = state_18910;
(statearr_18928[(7)] = inst_18840);

return statearr_18928;
})();
var statearr_18929_18987 = state_18910__$1;
(statearr_18929_18987[(2)] = null);

(statearr_18929_18987[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (13))){
var inst_18840 = (state_18910[(7)]);
var inst_18847 = inst_18840.cljs$lang$protocol_mask$partition0$;
var inst_18848 = (inst_18847 & (64));
var inst_18849 = inst_18840.cljs$core$ISeq$;
var inst_18850 = (inst_18848) || (inst_18849);
var state_18910__$1 = state_18910;
if(cljs.core.truth_(inst_18850)){
var statearr_18930_18988 = state_18910__$1;
(statearr_18930_18988[(1)] = (16));

} else {
var statearr_18931_18989 = state_18910__$1;
(statearr_18931_18989[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (22))){
var inst_18870 = (state_18910[(9)]);
var inst_18869 = (state_18910[(14)]);
var inst_18868 = (state_18910[(2)]);
var inst_18869__$1 = cljs.core.nth.call(null,inst_18868,(0),null);
var inst_18870__$1 = cljs.core.nth.call(null,inst_18868,(1),null);
var inst_18871 = (inst_18869__$1 == null);
var inst_18872 = cljs.core._EQ_.call(null,inst_18870__$1,change);
var inst_18873 = (inst_18871) || (inst_18872);
var state_18910__$1 = (function (){var statearr_18932 = state_18910;
(statearr_18932[(9)] = inst_18870__$1);

(statearr_18932[(14)] = inst_18869__$1);

return statearr_18932;
})();
if(cljs.core.truth_(inst_18873)){
var statearr_18933_18990 = state_18910__$1;
(statearr_18933_18990[(1)] = (23));

} else {
var statearr_18934_18991 = state_18910__$1;
(statearr_18934_18991[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (36))){
var inst_18862 = (state_18910[(12)]);
var inst_18840 = inst_18862;
var state_18910__$1 = (function (){var statearr_18935 = state_18910;
(statearr_18935[(7)] = inst_18840);

return statearr_18935;
})();
var statearr_18936_18992 = state_18910__$1;
(statearr_18936_18992[(2)] = null);

(statearr_18936_18992[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (29))){
var inst_18884 = (state_18910[(10)]);
var state_18910__$1 = state_18910;
var statearr_18937_18993 = state_18910__$1;
(statearr_18937_18993[(2)] = inst_18884);

(statearr_18937_18993[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (6))){
var state_18910__$1 = state_18910;
var statearr_18938_18994 = state_18910__$1;
(statearr_18938_18994[(2)] = false);

(statearr_18938_18994[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (28))){
var inst_18880 = (state_18910[(2)]);
var inst_18881 = calc_state.call(null);
var inst_18840 = inst_18881;
var state_18910__$1 = (function (){var statearr_18939 = state_18910;
(statearr_18939[(7)] = inst_18840);

(statearr_18939[(15)] = inst_18880);

return statearr_18939;
})();
var statearr_18940_18995 = state_18910__$1;
(statearr_18940_18995[(2)] = null);

(statearr_18940_18995[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (25))){
var inst_18906 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
var statearr_18941_18996 = state_18910__$1;
(statearr_18941_18996[(2)] = inst_18906);

(statearr_18941_18996[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (34))){
var inst_18904 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
var statearr_18942_18997 = state_18910__$1;
(statearr_18942_18997[(2)] = inst_18904);

(statearr_18942_18997[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (17))){
var state_18910__$1 = state_18910;
var statearr_18943_18998 = state_18910__$1;
(statearr_18943_18998[(2)] = false);

(statearr_18943_18998[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (3))){
var state_18910__$1 = state_18910;
var statearr_18944_18999 = state_18910__$1;
(statearr_18944_18999[(2)] = false);

(statearr_18944_18999[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (12))){
var inst_18908 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18910__$1,inst_18908);
} else {
if((state_val_18911 === (2))){
var inst_18816 = (state_18910[(8)]);
var inst_18821 = inst_18816.cljs$lang$protocol_mask$partition0$;
var inst_18822 = (inst_18821 & (64));
var inst_18823 = inst_18816.cljs$core$ISeq$;
var inst_18824 = (inst_18822) || (inst_18823);
var state_18910__$1 = state_18910;
if(cljs.core.truth_(inst_18824)){
var statearr_18945_19000 = state_18910__$1;
(statearr_18945_19000[(1)] = (5));

} else {
var statearr_18946_19001 = state_18910__$1;
(statearr_18946_19001[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (23))){
var inst_18869 = (state_18910[(14)]);
var inst_18875 = (inst_18869 == null);
var state_18910__$1 = state_18910;
if(cljs.core.truth_(inst_18875)){
var statearr_18947_19002 = state_18910__$1;
(statearr_18947_19002[(1)] = (26));

} else {
var statearr_18948_19003 = state_18910__$1;
(statearr_18948_19003[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (35))){
var inst_18895 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
if(cljs.core.truth_(inst_18895)){
var statearr_18949_19004 = state_18910__$1;
(statearr_18949_19004[(1)] = (36));

} else {
var statearr_18950_19005 = state_18910__$1;
(statearr_18950_19005[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (19))){
var inst_18840 = (state_18910[(7)]);
var inst_18859 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18840);
var state_18910__$1 = state_18910;
var statearr_18951_19006 = state_18910__$1;
(statearr_18951_19006[(2)] = inst_18859);

(statearr_18951_19006[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (11))){
var inst_18840 = (state_18910[(7)]);
var inst_18844 = (inst_18840 == null);
var inst_18845 = cljs.core.not.call(null,inst_18844);
var state_18910__$1 = state_18910;
if(inst_18845){
var statearr_18952_19007 = state_18910__$1;
(statearr_18952_19007[(1)] = (13));

} else {
var statearr_18953_19008 = state_18910__$1;
(statearr_18953_19008[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (9))){
var inst_18816 = (state_18910[(8)]);
var state_18910__$1 = state_18910;
var statearr_18954_19009 = state_18910__$1;
(statearr_18954_19009[(2)] = inst_18816);

(statearr_18954_19009[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (5))){
var state_18910__$1 = state_18910;
var statearr_18955_19010 = state_18910__$1;
(statearr_18955_19010[(2)] = true);

(statearr_18955_19010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (14))){
var state_18910__$1 = state_18910;
var statearr_18956_19011 = state_18910__$1;
(statearr_18956_19011[(2)] = false);

(statearr_18956_19011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (26))){
var inst_18870 = (state_18910[(9)]);
var inst_18877 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18870);
var state_18910__$1 = state_18910;
var statearr_18957_19012 = state_18910__$1;
(statearr_18957_19012[(2)] = inst_18877);

(statearr_18957_19012[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (16))){
var state_18910__$1 = state_18910;
var statearr_18958_19013 = state_18910__$1;
(statearr_18958_19013[(2)] = true);

(statearr_18958_19013[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (38))){
var inst_18900 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
var statearr_18959_19014 = state_18910__$1;
(statearr_18959_19014[(2)] = inst_18900);

(statearr_18959_19014[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (30))){
var inst_18870 = (state_18910[(9)]);
var inst_18864 = (state_18910[(13)]);
var inst_18863 = (state_18910[(11)]);
var inst_18887 = cljs.core.empty_QMARK_.call(null,inst_18863);
var inst_18888 = inst_18864.call(null,inst_18870);
var inst_18889 = cljs.core.not.call(null,inst_18888);
var inst_18890 = (inst_18887) && (inst_18889);
var state_18910__$1 = state_18910;
var statearr_18960_19015 = state_18910__$1;
(statearr_18960_19015[(2)] = inst_18890);

(statearr_18960_19015[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (10))){
var inst_18816 = (state_18910[(8)]);
var inst_18836 = (state_18910[(2)]);
var inst_18837 = cljs.core.get.call(null,inst_18836,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18838 = cljs.core.get.call(null,inst_18836,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18839 = cljs.core.get.call(null,inst_18836,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18840 = inst_18816;
var state_18910__$1 = (function (){var statearr_18961 = state_18910;
(statearr_18961[(16)] = inst_18839);

(statearr_18961[(17)] = inst_18838);

(statearr_18961[(18)] = inst_18837);

(statearr_18961[(7)] = inst_18840);

return statearr_18961;
})();
var statearr_18962_19016 = state_18910__$1;
(statearr_18962_19016[(2)] = null);

(statearr_18962_19016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (18))){
var inst_18854 = (state_18910[(2)]);
var state_18910__$1 = state_18910;
var statearr_18963_19017 = state_18910__$1;
(statearr_18963_19017[(2)] = inst_18854);

(statearr_18963_19017[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (37))){
var state_18910__$1 = state_18910;
var statearr_18964_19018 = state_18910__$1;
(statearr_18964_19018[(2)] = null);

(statearr_18964_19018[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18911 === (8))){
var inst_18816 = (state_18910[(8)]);
var inst_18833 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18816);
var state_18910__$1 = state_18910;
var statearr_18965_19019 = state_18910__$1;
(statearr_18965_19019[(2)] = inst_18833);

(statearr_18965_19019[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18973,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___18973,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_18969 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18969[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_18969[(1)] = (1));

return statearr_18969;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18910){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18970){if((e18970 instanceof Object)){
var ex__8254__auto__ = e18970;
var statearr_18971_19020 = state_18910;
(statearr_18971_19020[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18910);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18970;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19021 = state_18910;
state_18910 = G__19021;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18910){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18973,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_18972 = f__8363__auto__.call(null);
(statearr_18972[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18973);

return statearr_18972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18973,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19022 = [];
var len__5726__auto___19025 = arguments.length;
var i__5727__auto___19026 = (0);
while(true){
if((i__5727__auto___19026 < len__5726__auto___19025)){
args19022.push((arguments[i__5727__auto___19026]));

var G__19027 = (i__5727__auto___19026 + (1));
i__5727__auto___19026 = G__19027;
continue;
} else {
}
break;
}

var G__19024 = args19022.length;
switch (G__19024) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19022.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19030 = [];
var len__5726__auto___19155 = arguments.length;
var i__5727__auto___19156 = (0);
while(true){
if((i__5727__auto___19156 < len__5726__auto___19155)){
args19030.push((arguments[i__5727__auto___19156]));

var G__19157 = (i__5727__auto___19156 + (1));
i__5727__auto___19156 = G__19157;
continue;
} else {
}
break;
}

var G__19032 = args19030.length;
switch (G__19032) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19030.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19029_SHARP_){
if(cljs.core.truth_(p1__19029_SHARP_.call(null,topic))){
return p1__19029_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19029_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19033 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19033 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19034){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19034 = meta19034;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19035,meta19034__$1){
var self__ = this;
var _19035__$1 = this;
return (new cljs.core.async.t_cljs$core$async19033(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19034__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19035){
var self__ = this;
var _19035__$1 = this;
return self__.meta19034;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19033.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19033.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19034","meta19034",28349621,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19033.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19033.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19033";

cljs.core.async.t_cljs$core$async19033.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19033");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19033 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19033(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19034){
return (new cljs.core.async.t_cljs$core$async19033(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19034));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19033(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19159 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19159,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19159,mults,ensure_mult,p){
return (function (state_19107){
var state_val_19108 = (state_19107[(1)]);
if((state_val_19108 === (7))){
var inst_19103 = (state_19107[(2)]);
var state_19107__$1 = state_19107;
var statearr_19109_19160 = state_19107__$1;
(statearr_19109_19160[(2)] = inst_19103);

(statearr_19109_19160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (20))){
var state_19107__$1 = state_19107;
var statearr_19110_19161 = state_19107__$1;
(statearr_19110_19161[(2)] = null);

(statearr_19110_19161[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (1))){
var state_19107__$1 = state_19107;
var statearr_19111_19162 = state_19107__$1;
(statearr_19111_19162[(2)] = null);

(statearr_19111_19162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (24))){
var inst_19086 = (state_19107[(7)]);
var inst_19095 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19086);
var state_19107__$1 = state_19107;
var statearr_19112_19163 = state_19107__$1;
(statearr_19112_19163[(2)] = inst_19095);

(statearr_19112_19163[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (4))){
var inst_19038 = (state_19107[(8)]);
var inst_19038__$1 = (state_19107[(2)]);
var inst_19039 = (inst_19038__$1 == null);
var state_19107__$1 = (function (){var statearr_19113 = state_19107;
(statearr_19113[(8)] = inst_19038__$1);

return statearr_19113;
})();
if(cljs.core.truth_(inst_19039)){
var statearr_19114_19164 = state_19107__$1;
(statearr_19114_19164[(1)] = (5));

} else {
var statearr_19115_19165 = state_19107__$1;
(statearr_19115_19165[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (15))){
var inst_19080 = (state_19107[(2)]);
var state_19107__$1 = state_19107;
var statearr_19116_19166 = state_19107__$1;
(statearr_19116_19166[(2)] = inst_19080);

(statearr_19116_19166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (21))){
var inst_19100 = (state_19107[(2)]);
var state_19107__$1 = (function (){var statearr_19117 = state_19107;
(statearr_19117[(9)] = inst_19100);

return statearr_19117;
})();
var statearr_19118_19167 = state_19107__$1;
(statearr_19118_19167[(2)] = null);

(statearr_19118_19167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (13))){
var inst_19062 = (state_19107[(10)]);
var inst_19064 = cljs.core.chunked_seq_QMARK_.call(null,inst_19062);
var state_19107__$1 = state_19107;
if(inst_19064){
var statearr_19119_19168 = state_19107__$1;
(statearr_19119_19168[(1)] = (16));

} else {
var statearr_19120_19169 = state_19107__$1;
(statearr_19120_19169[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (22))){
var inst_19092 = (state_19107[(2)]);
var state_19107__$1 = state_19107;
if(cljs.core.truth_(inst_19092)){
var statearr_19121_19170 = state_19107__$1;
(statearr_19121_19170[(1)] = (23));

} else {
var statearr_19122_19171 = state_19107__$1;
(statearr_19122_19171[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (6))){
var inst_19038 = (state_19107[(8)]);
var inst_19086 = (state_19107[(7)]);
var inst_19088 = (state_19107[(11)]);
var inst_19086__$1 = topic_fn.call(null,inst_19038);
var inst_19087 = cljs.core.deref.call(null,mults);
var inst_19088__$1 = cljs.core.get.call(null,inst_19087,inst_19086__$1);
var state_19107__$1 = (function (){var statearr_19123 = state_19107;
(statearr_19123[(7)] = inst_19086__$1);

(statearr_19123[(11)] = inst_19088__$1);

return statearr_19123;
})();
if(cljs.core.truth_(inst_19088__$1)){
var statearr_19124_19172 = state_19107__$1;
(statearr_19124_19172[(1)] = (19));

} else {
var statearr_19125_19173 = state_19107__$1;
(statearr_19125_19173[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (25))){
var inst_19097 = (state_19107[(2)]);
var state_19107__$1 = state_19107;
var statearr_19126_19174 = state_19107__$1;
(statearr_19126_19174[(2)] = inst_19097);

(statearr_19126_19174[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (17))){
var inst_19062 = (state_19107[(10)]);
var inst_19071 = cljs.core.first.call(null,inst_19062);
var inst_19072 = cljs.core.async.muxch_STAR_.call(null,inst_19071);
var inst_19073 = cljs.core.async.close_BANG_.call(null,inst_19072);
var inst_19074 = cljs.core.next.call(null,inst_19062);
var inst_19048 = inst_19074;
var inst_19049 = null;
var inst_19050 = (0);
var inst_19051 = (0);
var state_19107__$1 = (function (){var statearr_19127 = state_19107;
(statearr_19127[(12)] = inst_19050);

(statearr_19127[(13)] = inst_19051);

(statearr_19127[(14)] = inst_19073);

(statearr_19127[(15)] = inst_19048);

(statearr_19127[(16)] = inst_19049);

return statearr_19127;
})();
var statearr_19128_19175 = state_19107__$1;
(statearr_19128_19175[(2)] = null);

(statearr_19128_19175[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (3))){
var inst_19105 = (state_19107[(2)]);
var state_19107__$1 = state_19107;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19107__$1,inst_19105);
} else {
if((state_val_19108 === (12))){
var inst_19082 = (state_19107[(2)]);
var state_19107__$1 = state_19107;
var statearr_19129_19176 = state_19107__$1;
(statearr_19129_19176[(2)] = inst_19082);

(statearr_19129_19176[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (2))){
var state_19107__$1 = state_19107;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19107__$1,(4),ch);
} else {
if((state_val_19108 === (23))){
var state_19107__$1 = state_19107;
var statearr_19130_19177 = state_19107__$1;
(statearr_19130_19177[(2)] = null);

(statearr_19130_19177[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (19))){
var inst_19038 = (state_19107[(8)]);
var inst_19088 = (state_19107[(11)]);
var inst_19090 = cljs.core.async.muxch_STAR_.call(null,inst_19088);
var state_19107__$1 = state_19107;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19107__$1,(22),inst_19090,inst_19038);
} else {
if((state_val_19108 === (11))){
var inst_19062 = (state_19107[(10)]);
var inst_19048 = (state_19107[(15)]);
var inst_19062__$1 = cljs.core.seq.call(null,inst_19048);
var state_19107__$1 = (function (){var statearr_19131 = state_19107;
(statearr_19131[(10)] = inst_19062__$1);

return statearr_19131;
})();
if(inst_19062__$1){
var statearr_19132_19178 = state_19107__$1;
(statearr_19132_19178[(1)] = (13));

} else {
var statearr_19133_19179 = state_19107__$1;
(statearr_19133_19179[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (9))){
var inst_19084 = (state_19107[(2)]);
var state_19107__$1 = state_19107;
var statearr_19134_19180 = state_19107__$1;
(statearr_19134_19180[(2)] = inst_19084);

(statearr_19134_19180[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (5))){
var inst_19045 = cljs.core.deref.call(null,mults);
var inst_19046 = cljs.core.vals.call(null,inst_19045);
var inst_19047 = cljs.core.seq.call(null,inst_19046);
var inst_19048 = inst_19047;
var inst_19049 = null;
var inst_19050 = (0);
var inst_19051 = (0);
var state_19107__$1 = (function (){var statearr_19135 = state_19107;
(statearr_19135[(12)] = inst_19050);

(statearr_19135[(13)] = inst_19051);

(statearr_19135[(15)] = inst_19048);

(statearr_19135[(16)] = inst_19049);

return statearr_19135;
})();
var statearr_19136_19181 = state_19107__$1;
(statearr_19136_19181[(2)] = null);

(statearr_19136_19181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (14))){
var state_19107__$1 = state_19107;
var statearr_19140_19182 = state_19107__$1;
(statearr_19140_19182[(2)] = null);

(statearr_19140_19182[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (16))){
var inst_19062 = (state_19107[(10)]);
var inst_19066 = cljs.core.chunk_first.call(null,inst_19062);
var inst_19067 = cljs.core.chunk_rest.call(null,inst_19062);
var inst_19068 = cljs.core.count.call(null,inst_19066);
var inst_19048 = inst_19067;
var inst_19049 = inst_19066;
var inst_19050 = inst_19068;
var inst_19051 = (0);
var state_19107__$1 = (function (){var statearr_19141 = state_19107;
(statearr_19141[(12)] = inst_19050);

(statearr_19141[(13)] = inst_19051);

(statearr_19141[(15)] = inst_19048);

(statearr_19141[(16)] = inst_19049);

return statearr_19141;
})();
var statearr_19142_19183 = state_19107__$1;
(statearr_19142_19183[(2)] = null);

(statearr_19142_19183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (10))){
var inst_19050 = (state_19107[(12)]);
var inst_19051 = (state_19107[(13)]);
var inst_19048 = (state_19107[(15)]);
var inst_19049 = (state_19107[(16)]);
var inst_19056 = cljs.core._nth.call(null,inst_19049,inst_19051);
var inst_19057 = cljs.core.async.muxch_STAR_.call(null,inst_19056);
var inst_19058 = cljs.core.async.close_BANG_.call(null,inst_19057);
var inst_19059 = (inst_19051 + (1));
var tmp19137 = inst_19050;
var tmp19138 = inst_19048;
var tmp19139 = inst_19049;
var inst_19048__$1 = tmp19138;
var inst_19049__$1 = tmp19139;
var inst_19050__$1 = tmp19137;
var inst_19051__$1 = inst_19059;
var state_19107__$1 = (function (){var statearr_19143 = state_19107;
(statearr_19143[(12)] = inst_19050__$1);

(statearr_19143[(17)] = inst_19058);

(statearr_19143[(13)] = inst_19051__$1);

(statearr_19143[(15)] = inst_19048__$1);

(statearr_19143[(16)] = inst_19049__$1);

return statearr_19143;
})();
var statearr_19144_19184 = state_19107__$1;
(statearr_19144_19184[(2)] = null);

(statearr_19144_19184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (18))){
var inst_19077 = (state_19107[(2)]);
var state_19107__$1 = state_19107;
var statearr_19145_19185 = state_19107__$1;
(statearr_19145_19185[(2)] = inst_19077);

(statearr_19145_19185[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19108 === (8))){
var inst_19050 = (state_19107[(12)]);
var inst_19051 = (state_19107[(13)]);
var inst_19053 = (inst_19051 < inst_19050);
var inst_19054 = inst_19053;
var state_19107__$1 = state_19107;
if(cljs.core.truth_(inst_19054)){
var statearr_19146_19186 = state_19107__$1;
(statearr_19146_19186[(1)] = (10));

} else {
var statearr_19147_19187 = state_19107__$1;
(statearr_19147_19187[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19159,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19159,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19151 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19151[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19151[(1)] = (1));

return statearr_19151;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19107){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19107);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19152){if((e19152 instanceof Object)){
var ex__8254__auto__ = e19152;
var statearr_19153_19188 = state_19107;
(statearr_19153_19188[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19107);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19152;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19189 = state_19107;
state_19107 = G__19189;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19107){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19159,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19154 = f__8363__auto__.call(null);
(statearr_19154[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19159);

return statearr_19154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19159,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19190 = [];
var len__5726__auto___19193 = arguments.length;
var i__5727__auto___19194 = (0);
while(true){
if((i__5727__auto___19194 < len__5726__auto___19193)){
args19190.push((arguments[i__5727__auto___19194]));

var G__19195 = (i__5727__auto___19194 + (1));
i__5727__auto___19194 = G__19195;
continue;
} else {
}
break;
}

var G__19192 = args19190.length;
switch (G__19192) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19190.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19197 = [];
var len__5726__auto___19200 = arguments.length;
var i__5727__auto___19201 = (0);
while(true){
if((i__5727__auto___19201 < len__5726__auto___19200)){
args19197.push((arguments[i__5727__auto___19201]));

var G__19202 = (i__5727__auto___19201 + (1));
i__5727__auto___19201 = G__19202;
continue;
} else {
}
break;
}

var G__19199 = args19197.length;
switch (G__19199) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19197.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19204 = [];
var len__5726__auto___19275 = arguments.length;
var i__5727__auto___19276 = (0);
while(true){
if((i__5727__auto___19276 < len__5726__auto___19275)){
args19204.push((arguments[i__5727__auto___19276]));

var G__19277 = (i__5727__auto___19276 + (1));
i__5727__auto___19276 = G__19277;
continue;
} else {
}
break;
}

var G__19206 = args19204.length;
switch (G__19206) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19204.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19279 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19279,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19279,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19245){
var state_val_19246 = (state_19245[(1)]);
if((state_val_19246 === (7))){
var state_19245__$1 = state_19245;
var statearr_19247_19280 = state_19245__$1;
(statearr_19247_19280[(2)] = null);

(statearr_19247_19280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (1))){
var state_19245__$1 = state_19245;
var statearr_19248_19281 = state_19245__$1;
(statearr_19248_19281[(2)] = null);

(statearr_19248_19281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (4))){
var inst_19209 = (state_19245[(7)]);
var inst_19211 = (inst_19209 < cnt);
var state_19245__$1 = state_19245;
if(cljs.core.truth_(inst_19211)){
var statearr_19249_19282 = state_19245__$1;
(statearr_19249_19282[(1)] = (6));

} else {
var statearr_19250_19283 = state_19245__$1;
(statearr_19250_19283[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (15))){
var inst_19241 = (state_19245[(2)]);
var state_19245__$1 = state_19245;
var statearr_19251_19284 = state_19245__$1;
(statearr_19251_19284[(2)] = inst_19241);

(statearr_19251_19284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (13))){
var inst_19234 = cljs.core.async.close_BANG_.call(null,out);
var state_19245__$1 = state_19245;
var statearr_19252_19285 = state_19245__$1;
(statearr_19252_19285[(2)] = inst_19234);

(statearr_19252_19285[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (6))){
var state_19245__$1 = state_19245;
var statearr_19253_19286 = state_19245__$1;
(statearr_19253_19286[(2)] = null);

(statearr_19253_19286[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (3))){
var inst_19243 = (state_19245[(2)]);
var state_19245__$1 = state_19245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19245__$1,inst_19243);
} else {
if((state_val_19246 === (12))){
var inst_19231 = (state_19245[(8)]);
var inst_19231__$1 = (state_19245[(2)]);
var inst_19232 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19231__$1);
var state_19245__$1 = (function (){var statearr_19254 = state_19245;
(statearr_19254[(8)] = inst_19231__$1);

return statearr_19254;
})();
if(cljs.core.truth_(inst_19232)){
var statearr_19255_19287 = state_19245__$1;
(statearr_19255_19287[(1)] = (13));

} else {
var statearr_19256_19288 = state_19245__$1;
(statearr_19256_19288[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (2))){
var inst_19208 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19209 = (0);
var state_19245__$1 = (function (){var statearr_19257 = state_19245;
(statearr_19257[(7)] = inst_19209);

(statearr_19257[(9)] = inst_19208);

return statearr_19257;
})();
var statearr_19258_19289 = state_19245__$1;
(statearr_19258_19289[(2)] = null);

(statearr_19258_19289[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (11))){
var inst_19209 = (state_19245[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19245,(10),Object,null,(9));
var inst_19218 = chs__$1.call(null,inst_19209);
var inst_19219 = done.call(null,inst_19209);
var inst_19220 = cljs.core.async.take_BANG_.call(null,inst_19218,inst_19219);
var state_19245__$1 = state_19245;
var statearr_19259_19290 = state_19245__$1;
(statearr_19259_19290[(2)] = inst_19220);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19245__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (9))){
var inst_19209 = (state_19245[(7)]);
var inst_19222 = (state_19245[(2)]);
var inst_19223 = (inst_19209 + (1));
var inst_19209__$1 = inst_19223;
var state_19245__$1 = (function (){var statearr_19260 = state_19245;
(statearr_19260[(10)] = inst_19222);

(statearr_19260[(7)] = inst_19209__$1);

return statearr_19260;
})();
var statearr_19261_19291 = state_19245__$1;
(statearr_19261_19291[(2)] = null);

(statearr_19261_19291[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (5))){
var inst_19229 = (state_19245[(2)]);
var state_19245__$1 = (function (){var statearr_19262 = state_19245;
(statearr_19262[(11)] = inst_19229);

return statearr_19262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19245__$1,(12),dchan);
} else {
if((state_val_19246 === (14))){
var inst_19231 = (state_19245[(8)]);
var inst_19236 = cljs.core.apply.call(null,f,inst_19231);
var state_19245__$1 = state_19245;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19245__$1,(16),out,inst_19236);
} else {
if((state_val_19246 === (16))){
var inst_19238 = (state_19245[(2)]);
var state_19245__$1 = (function (){var statearr_19263 = state_19245;
(statearr_19263[(12)] = inst_19238);

return statearr_19263;
})();
var statearr_19264_19292 = state_19245__$1;
(statearr_19264_19292[(2)] = null);

(statearr_19264_19292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (10))){
var inst_19213 = (state_19245[(2)]);
var inst_19214 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19245__$1 = (function (){var statearr_19265 = state_19245;
(statearr_19265[(13)] = inst_19213);

return statearr_19265;
})();
var statearr_19266_19293 = state_19245__$1;
(statearr_19266_19293[(2)] = inst_19214);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19245__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19246 === (8))){
var inst_19227 = (state_19245[(2)]);
var state_19245__$1 = state_19245;
var statearr_19267_19294 = state_19245__$1;
(statearr_19267_19294[(2)] = inst_19227);

(statearr_19267_19294[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19279,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19279,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19271 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19271[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19271[(1)] = (1));

return statearr_19271;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19245){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19272){if((e19272 instanceof Object)){
var ex__8254__auto__ = e19272;
var statearr_19273_19295 = state_19245;
(statearr_19273_19295[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19245);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19272;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19296 = state_19245;
state_19245 = G__19296;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19245){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19279,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19274 = f__8363__auto__.call(null);
(statearr_19274[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19279);

return statearr_19274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19279,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19298 = [];
var len__5726__auto___19354 = arguments.length;
var i__5727__auto___19355 = (0);
while(true){
if((i__5727__auto___19355 < len__5726__auto___19354)){
args19298.push((arguments[i__5727__auto___19355]));

var G__19356 = (i__5727__auto___19355 + (1));
i__5727__auto___19355 = G__19356;
continue;
} else {
}
break;
}

var G__19300 = args19298.length;
switch (G__19300) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19298.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19358 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19358,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19358,out){
return (function (state_19330){
var state_val_19331 = (state_19330[(1)]);
if((state_val_19331 === (7))){
var inst_19310 = (state_19330[(7)]);
var inst_19309 = (state_19330[(8)]);
var inst_19309__$1 = (state_19330[(2)]);
var inst_19310__$1 = cljs.core.nth.call(null,inst_19309__$1,(0),null);
var inst_19311 = cljs.core.nth.call(null,inst_19309__$1,(1),null);
var inst_19312 = (inst_19310__$1 == null);
var state_19330__$1 = (function (){var statearr_19332 = state_19330;
(statearr_19332[(7)] = inst_19310__$1);

(statearr_19332[(9)] = inst_19311);

(statearr_19332[(8)] = inst_19309__$1);

return statearr_19332;
})();
if(cljs.core.truth_(inst_19312)){
var statearr_19333_19359 = state_19330__$1;
(statearr_19333_19359[(1)] = (8));

} else {
var statearr_19334_19360 = state_19330__$1;
(statearr_19334_19360[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (1))){
var inst_19301 = cljs.core.vec.call(null,chs);
var inst_19302 = inst_19301;
var state_19330__$1 = (function (){var statearr_19335 = state_19330;
(statearr_19335[(10)] = inst_19302);

return statearr_19335;
})();
var statearr_19336_19361 = state_19330__$1;
(statearr_19336_19361[(2)] = null);

(statearr_19336_19361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (4))){
var inst_19302 = (state_19330[(10)]);
var state_19330__$1 = state_19330;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19330__$1,(7),inst_19302);
} else {
if((state_val_19331 === (6))){
var inst_19326 = (state_19330[(2)]);
var state_19330__$1 = state_19330;
var statearr_19337_19362 = state_19330__$1;
(statearr_19337_19362[(2)] = inst_19326);

(statearr_19337_19362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (3))){
var inst_19328 = (state_19330[(2)]);
var state_19330__$1 = state_19330;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19330__$1,inst_19328);
} else {
if((state_val_19331 === (2))){
var inst_19302 = (state_19330[(10)]);
var inst_19304 = cljs.core.count.call(null,inst_19302);
var inst_19305 = (inst_19304 > (0));
var state_19330__$1 = state_19330;
if(cljs.core.truth_(inst_19305)){
var statearr_19339_19363 = state_19330__$1;
(statearr_19339_19363[(1)] = (4));

} else {
var statearr_19340_19364 = state_19330__$1;
(statearr_19340_19364[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (11))){
var inst_19302 = (state_19330[(10)]);
var inst_19319 = (state_19330[(2)]);
var tmp19338 = inst_19302;
var inst_19302__$1 = tmp19338;
var state_19330__$1 = (function (){var statearr_19341 = state_19330;
(statearr_19341[(10)] = inst_19302__$1);

(statearr_19341[(11)] = inst_19319);

return statearr_19341;
})();
var statearr_19342_19365 = state_19330__$1;
(statearr_19342_19365[(2)] = null);

(statearr_19342_19365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (9))){
var inst_19310 = (state_19330[(7)]);
var state_19330__$1 = state_19330;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19330__$1,(11),out,inst_19310);
} else {
if((state_val_19331 === (5))){
var inst_19324 = cljs.core.async.close_BANG_.call(null,out);
var state_19330__$1 = state_19330;
var statearr_19343_19366 = state_19330__$1;
(statearr_19343_19366[(2)] = inst_19324);

(statearr_19343_19366[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (10))){
var inst_19322 = (state_19330[(2)]);
var state_19330__$1 = state_19330;
var statearr_19344_19367 = state_19330__$1;
(statearr_19344_19367[(2)] = inst_19322);

(statearr_19344_19367[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (8))){
var inst_19310 = (state_19330[(7)]);
var inst_19311 = (state_19330[(9)]);
var inst_19302 = (state_19330[(10)]);
var inst_19309 = (state_19330[(8)]);
var inst_19314 = (function (){var cs = inst_19302;
var vec__19307 = inst_19309;
var v = inst_19310;
var c = inst_19311;
return ((function (cs,vec__19307,v,c,inst_19310,inst_19311,inst_19302,inst_19309,state_val_19331,c__8362__auto___19358,out){
return (function (p1__19297_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19297_SHARP_);
});
;})(cs,vec__19307,v,c,inst_19310,inst_19311,inst_19302,inst_19309,state_val_19331,c__8362__auto___19358,out))
})();
var inst_19315 = cljs.core.filterv.call(null,inst_19314,inst_19302);
var inst_19302__$1 = inst_19315;
var state_19330__$1 = (function (){var statearr_19345 = state_19330;
(statearr_19345[(10)] = inst_19302__$1);

return statearr_19345;
})();
var statearr_19346_19368 = state_19330__$1;
(statearr_19346_19368[(2)] = null);

(statearr_19346_19368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19358,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19358,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19350 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19350[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19350[(1)] = (1));

return statearr_19350;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19330){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19351){if((e19351 instanceof Object)){
var ex__8254__auto__ = e19351;
var statearr_19352_19369 = state_19330;
(statearr_19352_19369[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19330);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19351;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19370 = state_19330;
state_19330 = G__19370;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19330){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19358,out))
})();
var state__8364__auto__ = (function (){var statearr_19353 = f__8363__auto__.call(null);
(statearr_19353[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19358);

return statearr_19353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19358,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19371 = [];
var len__5726__auto___19420 = arguments.length;
var i__5727__auto___19421 = (0);
while(true){
if((i__5727__auto___19421 < len__5726__auto___19420)){
args19371.push((arguments[i__5727__auto___19421]));

var G__19422 = (i__5727__auto___19421 + (1));
i__5727__auto___19421 = G__19422;
continue;
} else {
}
break;
}

var G__19373 = args19371.length;
switch (G__19373) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19371.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19424 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19424,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19424,out){
return (function (state_19397){
var state_val_19398 = (state_19397[(1)]);
if((state_val_19398 === (7))){
var inst_19379 = (state_19397[(7)]);
var inst_19379__$1 = (state_19397[(2)]);
var inst_19380 = (inst_19379__$1 == null);
var inst_19381 = cljs.core.not.call(null,inst_19380);
var state_19397__$1 = (function (){var statearr_19399 = state_19397;
(statearr_19399[(7)] = inst_19379__$1);

return statearr_19399;
})();
if(inst_19381){
var statearr_19400_19425 = state_19397__$1;
(statearr_19400_19425[(1)] = (8));

} else {
var statearr_19401_19426 = state_19397__$1;
(statearr_19401_19426[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19398 === (1))){
var inst_19374 = (0);
var state_19397__$1 = (function (){var statearr_19402 = state_19397;
(statearr_19402[(8)] = inst_19374);

return statearr_19402;
})();
var statearr_19403_19427 = state_19397__$1;
(statearr_19403_19427[(2)] = null);

(statearr_19403_19427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19398 === (4))){
var state_19397__$1 = state_19397;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19397__$1,(7),ch);
} else {
if((state_val_19398 === (6))){
var inst_19392 = (state_19397[(2)]);
var state_19397__$1 = state_19397;
var statearr_19404_19428 = state_19397__$1;
(statearr_19404_19428[(2)] = inst_19392);

(statearr_19404_19428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19398 === (3))){
var inst_19394 = (state_19397[(2)]);
var inst_19395 = cljs.core.async.close_BANG_.call(null,out);
var state_19397__$1 = (function (){var statearr_19405 = state_19397;
(statearr_19405[(9)] = inst_19394);

return statearr_19405;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19397__$1,inst_19395);
} else {
if((state_val_19398 === (2))){
var inst_19374 = (state_19397[(8)]);
var inst_19376 = (inst_19374 < n);
var state_19397__$1 = state_19397;
if(cljs.core.truth_(inst_19376)){
var statearr_19406_19429 = state_19397__$1;
(statearr_19406_19429[(1)] = (4));

} else {
var statearr_19407_19430 = state_19397__$1;
(statearr_19407_19430[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19398 === (11))){
var inst_19374 = (state_19397[(8)]);
var inst_19384 = (state_19397[(2)]);
var inst_19385 = (inst_19374 + (1));
var inst_19374__$1 = inst_19385;
var state_19397__$1 = (function (){var statearr_19408 = state_19397;
(statearr_19408[(8)] = inst_19374__$1);

(statearr_19408[(10)] = inst_19384);

return statearr_19408;
})();
var statearr_19409_19431 = state_19397__$1;
(statearr_19409_19431[(2)] = null);

(statearr_19409_19431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19398 === (9))){
var state_19397__$1 = state_19397;
var statearr_19410_19432 = state_19397__$1;
(statearr_19410_19432[(2)] = null);

(statearr_19410_19432[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19398 === (5))){
var state_19397__$1 = state_19397;
var statearr_19411_19433 = state_19397__$1;
(statearr_19411_19433[(2)] = null);

(statearr_19411_19433[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19398 === (10))){
var inst_19389 = (state_19397[(2)]);
var state_19397__$1 = state_19397;
var statearr_19412_19434 = state_19397__$1;
(statearr_19412_19434[(2)] = inst_19389);

(statearr_19412_19434[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19398 === (8))){
var inst_19379 = (state_19397[(7)]);
var state_19397__$1 = state_19397;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19397__$1,(11),out,inst_19379);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19424,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19424,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19416 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19416[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19416[(1)] = (1));

return statearr_19416;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19397){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19397);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19417){if((e19417 instanceof Object)){
var ex__8254__auto__ = e19417;
var statearr_19418_19435 = state_19397;
(statearr_19418_19435[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19397);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19417;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19436 = state_19397;
state_19397 = G__19436;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19397){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19424,out))
})();
var state__8364__auto__ = (function (){var statearr_19419 = f__8363__auto__.call(null);
(statearr_19419[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19424);

return statearr_19419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19424,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19444 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19444 = (function (map_LT_,f,ch,meta19445){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19445 = meta19445;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19446,meta19445__$1){
var self__ = this;
var _19446__$1 = this;
return (new cljs.core.async.t_cljs$core$async19444(self__.map_LT_,self__.f,self__.ch,meta19445__$1));
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19446){
var self__ = this;
var _19446__$1 = this;
return self__.meta19445;
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19447 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19447 = (function (map_LT_,f,ch,meta19445,_,fn1,meta19448){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19445 = meta19445;
this._ = _;
this.fn1 = fn1;
this.meta19448 = meta19448;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19447.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19449,meta19448__$1){
var self__ = this;
var _19449__$1 = this;
return (new cljs.core.async.t_cljs$core$async19447(self__.map_LT_,self__.f,self__.ch,self__.meta19445,self__._,self__.fn1,meta19448__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19447.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19449){
var self__ = this;
var _19449__$1 = this;
return self__.meta19448;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19447.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19447.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19447.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19447.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19437_SHARP_){
return f1.call(null,(((p1__19437_SHARP_ == null))?null:self__.f.call(null,p1__19437_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19447.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19445","meta19445",-540903635,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19444","cljs.core.async/t_cljs$core$async19444",-318739856,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19448","meta19448",1509435437,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19447.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19447.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19447";

cljs.core.async.t_cljs$core$async19447.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19447");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19447 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19447(map_LT___$1,f__$1,ch__$1,meta19445__$1,___$2,fn1__$1,meta19448){
return (new cljs.core.async.t_cljs$core$async19447(map_LT___$1,f__$1,ch__$1,meta19445__$1,___$2,fn1__$1,meta19448));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19447(self__.map_LT_,self__.f,self__.ch,self__.meta19445,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19444.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19445","meta19445",-540903635,null)], null);
});

cljs.core.async.t_cljs$core$async19444.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19444.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19444";

cljs.core.async.t_cljs$core$async19444.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19444");
});

cljs.core.async.__GT_t_cljs$core$async19444 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19444(map_LT___$1,f__$1,ch__$1,meta19445){
return (new cljs.core.async.t_cljs$core$async19444(map_LT___$1,f__$1,ch__$1,meta19445));
});

}

return (new cljs.core.async.t_cljs$core$async19444(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19453 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19453 = (function (map_GT_,f,ch,meta19454){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19454 = meta19454;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19453.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19455,meta19454__$1){
var self__ = this;
var _19455__$1 = this;
return (new cljs.core.async.t_cljs$core$async19453(self__.map_GT_,self__.f,self__.ch,meta19454__$1));
});

cljs.core.async.t_cljs$core$async19453.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19455){
var self__ = this;
var _19455__$1 = this;
return self__.meta19454;
});

cljs.core.async.t_cljs$core$async19453.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19453.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19453.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19453.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19453.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19453.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19453.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19454","meta19454",2067835024,null)], null);
});

cljs.core.async.t_cljs$core$async19453.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19453.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19453";

cljs.core.async.t_cljs$core$async19453.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19453");
});

cljs.core.async.__GT_t_cljs$core$async19453 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19453(map_GT___$1,f__$1,ch__$1,meta19454){
return (new cljs.core.async.t_cljs$core$async19453(map_GT___$1,f__$1,ch__$1,meta19454));
});

}

return (new cljs.core.async.t_cljs$core$async19453(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19459 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19459 = (function (filter_GT_,p,ch,meta19460){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19460 = meta19460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19461,meta19460__$1){
var self__ = this;
var _19461__$1 = this;
return (new cljs.core.async.t_cljs$core$async19459(self__.filter_GT_,self__.p,self__.ch,meta19460__$1));
});

cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19461){
var self__ = this;
var _19461__$1 = this;
return self__.meta19460;
});

cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19459.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19459.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19460","meta19460",-23924434,null)], null);
});

cljs.core.async.t_cljs$core$async19459.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19459.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19459";

cljs.core.async.t_cljs$core$async19459.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19459");
});

cljs.core.async.__GT_t_cljs$core$async19459 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19459(filter_GT___$1,p__$1,ch__$1,meta19460){
return (new cljs.core.async.t_cljs$core$async19459(filter_GT___$1,p__$1,ch__$1,meta19460));
});

}

return (new cljs.core.async.t_cljs$core$async19459(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19462 = [];
var len__5726__auto___19506 = arguments.length;
var i__5727__auto___19507 = (0);
while(true){
if((i__5727__auto___19507 < len__5726__auto___19506)){
args19462.push((arguments[i__5727__auto___19507]));

var G__19508 = (i__5727__auto___19507 + (1));
i__5727__auto___19507 = G__19508;
continue;
} else {
}
break;
}

var G__19464 = args19462.length;
switch (G__19464) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19462.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19510 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19510,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19510,out){
return (function (state_19485){
var state_val_19486 = (state_19485[(1)]);
if((state_val_19486 === (7))){
var inst_19481 = (state_19485[(2)]);
var state_19485__$1 = state_19485;
var statearr_19487_19511 = state_19485__$1;
(statearr_19487_19511[(2)] = inst_19481);

(statearr_19487_19511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19486 === (1))){
var state_19485__$1 = state_19485;
var statearr_19488_19512 = state_19485__$1;
(statearr_19488_19512[(2)] = null);

(statearr_19488_19512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19486 === (4))){
var inst_19467 = (state_19485[(7)]);
var inst_19467__$1 = (state_19485[(2)]);
var inst_19468 = (inst_19467__$1 == null);
var state_19485__$1 = (function (){var statearr_19489 = state_19485;
(statearr_19489[(7)] = inst_19467__$1);

return statearr_19489;
})();
if(cljs.core.truth_(inst_19468)){
var statearr_19490_19513 = state_19485__$1;
(statearr_19490_19513[(1)] = (5));

} else {
var statearr_19491_19514 = state_19485__$1;
(statearr_19491_19514[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19486 === (6))){
var inst_19467 = (state_19485[(7)]);
var inst_19472 = p.call(null,inst_19467);
var state_19485__$1 = state_19485;
if(cljs.core.truth_(inst_19472)){
var statearr_19492_19515 = state_19485__$1;
(statearr_19492_19515[(1)] = (8));

} else {
var statearr_19493_19516 = state_19485__$1;
(statearr_19493_19516[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19486 === (3))){
var inst_19483 = (state_19485[(2)]);
var state_19485__$1 = state_19485;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19485__$1,inst_19483);
} else {
if((state_val_19486 === (2))){
var state_19485__$1 = state_19485;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19485__$1,(4),ch);
} else {
if((state_val_19486 === (11))){
var inst_19475 = (state_19485[(2)]);
var state_19485__$1 = state_19485;
var statearr_19494_19517 = state_19485__$1;
(statearr_19494_19517[(2)] = inst_19475);

(statearr_19494_19517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19486 === (9))){
var state_19485__$1 = state_19485;
var statearr_19495_19518 = state_19485__$1;
(statearr_19495_19518[(2)] = null);

(statearr_19495_19518[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19486 === (5))){
var inst_19470 = cljs.core.async.close_BANG_.call(null,out);
var state_19485__$1 = state_19485;
var statearr_19496_19519 = state_19485__$1;
(statearr_19496_19519[(2)] = inst_19470);

(statearr_19496_19519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19486 === (10))){
var inst_19478 = (state_19485[(2)]);
var state_19485__$1 = (function (){var statearr_19497 = state_19485;
(statearr_19497[(8)] = inst_19478);

return statearr_19497;
})();
var statearr_19498_19520 = state_19485__$1;
(statearr_19498_19520[(2)] = null);

(statearr_19498_19520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19486 === (8))){
var inst_19467 = (state_19485[(7)]);
var state_19485__$1 = state_19485;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19485__$1,(11),out,inst_19467);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19510,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19510,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19502 = [null,null,null,null,null,null,null,null,null];
(statearr_19502[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19502[(1)] = (1));

return statearr_19502;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19485){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19485);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19503){if((e19503 instanceof Object)){
var ex__8254__auto__ = e19503;
var statearr_19504_19521 = state_19485;
(statearr_19504_19521[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19485);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19503;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19522 = state_19485;
state_19485 = G__19522;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19485){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19510,out))
})();
var state__8364__auto__ = (function (){var statearr_19505 = f__8363__auto__.call(null);
(statearr_19505[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19510);

return statearr_19505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19510,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19523 = [];
var len__5726__auto___19526 = arguments.length;
var i__5727__auto___19527 = (0);
while(true){
if((i__5727__auto___19527 < len__5726__auto___19526)){
args19523.push((arguments[i__5727__auto___19527]));

var G__19528 = (i__5727__auto___19527 + (1));
i__5727__auto___19527 = G__19528;
continue;
} else {
}
break;
}

var G__19525 = args19523.length;
switch (G__19525) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19523.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19695){
var state_val_19696 = (state_19695[(1)]);
if((state_val_19696 === (7))){
var inst_19691 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
var statearr_19697_19738 = state_19695__$1;
(statearr_19697_19738[(2)] = inst_19691);

(statearr_19697_19738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (20))){
var inst_19661 = (state_19695[(7)]);
var inst_19672 = (state_19695[(2)]);
var inst_19673 = cljs.core.next.call(null,inst_19661);
var inst_19647 = inst_19673;
var inst_19648 = null;
var inst_19649 = (0);
var inst_19650 = (0);
var state_19695__$1 = (function (){var statearr_19698 = state_19695;
(statearr_19698[(8)] = inst_19649);

(statearr_19698[(9)] = inst_19650);

(statearr_19698[(10)] = inst_19672);

(statearr_19698[(11)] = inst_19648);

(statearr_19698[(12)] = inst_19647);

return statearr_19698;
})();
var statearr_19699_19739 = state_19695__$1;
(statearr_19699_19739[(2)] = null);

(statearr_19699_19739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (1))){
var state_19695__$1 = state_19695;
var statearr_19700_19740 = state_19695__$1;
(statearr_19700_19740[(2)] = null);

(statearr_19700_19740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (4))){
var inst_19636 = (state_19695[(13)]);
var inst_19636__$1 = (state_19695[(2)]);
var inst_19637 = (inst_19636__$1 == null);
var state_19695__$1 = (function (){var statearr_19701 = state_19695;
(statearr_19701[(13)] = inst_19636__$1);

return statearr_19701;
})();
if(cljs.core.truth_(inst_19637)){
var statearr_19702_19741 = state_19695__$1;
(statearr_19702_19741[(1)] = (5));

} else {
var statearr_19703_19742 = state_19695__$1;
(statearr_19703_19742[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (15))){
var state_19695__$1 = state_19695;
var statearr_19707_19743 = state_19695__$1;
(statearr_19707_19743[(2)] = null);

(statearr_19707_19743[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (21))){
var state_19695__$1 = state_19695;
var statearr_19708_19744 = state_19695__$1;
(statearr_19708_19744[(2)] = null);

(statearr_19708_19744[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (13))){
var inst_19649 = (state_19695[(8)]);
var inst_19650 = (state_19695[(9)]);
var inst_19648 = (state_19695[(11)]);
var inst_19647 = (state_19695[(12)]);
var inst_19657 = (state_19695[(2)]);
var inst_19658 = (inst_19650 + (1));
var tmp19704 = inst_19649;
var tmp19705 = inst_19648;
var tmp19706 = inst_19647;
var inst_19647__$1 = tmp19706;
var inst_19648__$1 = tmp19705;
var inst_19649__$1 = tmp19704;
var inst_19650__$1 = inst_19658;
var state_19695__$1 = (function (){var statearr_19709 = state_19695;
(statearr_19709[(8)] = inst_19649__$1);

(statearr_19709[(14)] = inst_19657);

(statearr_19709[(9)] = inst_19650__$1);

(statearr_19709[(11)] = inst_19648__$1);

(statearr_19709[(12)] = inst_19647__$1);

return statearr_19709;
})();
var statearr_19710_19745 = state_19695__$1;
(statearr_19710_19745[(2)] = null);

(statearr_19710_19745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (22))){
var state_19695__$1 = state_19695;
var statearr_19711_19746 = state_19695__$1;
(statearr_19711_19746[(2)] = null);

(statearr_19711_19746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (6))){
var inst_19636 = (state_19695[(13)]);
var inst_19645 = f.call(null,inst_19636);
var inst_19646 = cljs.core.seq.call(null,inst_19645);
var inst_19647 = inst_19646;
var inst_19648 = null;
var inst_19649 = (0);
var inst_19650 = (0);
var state_19695__$1 = (function (){var statearr_19712 = state_19695;
(statearr_19712[(8)] = inst_19649);

(statearr_19712[(9)] = inst_19650);

(statearr_19712[(11)] = inst_19648);

(statearr_19712[(12)] = inst_19647);

return statearr_19712;
})();
var statearr_19713_19747 = state_19695__$1;
(statearr_19713_19747[(2)] = null);

(statearr_19713_19747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (17))){
var inst_19661 = (state_19695[(7)]);
var inst_19665 = cljs.core.chunk_first.call(null,inst_19661);
var inst_19666 = cljs.core.chunk_rest.call(null,inst_19661);
var inst_19667 = cljs.core.count.call(null,inst_19665);
var inst_19647 = inst_19666;
var inst_19648 = inst_19665;
var inst_19649 = inst_19667;
var inst_19650 = (0);
var state_19695__$1 = (function (){var statearr_19714 = state_19695;
(statearr_19714[(8)] = inst_19649);

(statearr_19714[(9)] = inst_19650);

(statearr_19714[(11)] = inst_19648);

(statearr_19714[(12)] = inst_19647);

return statearr_19714;
})();
var statearr_19715_19748 = state_19695__$1;
(statearr_19715_19748[(2)] = null);

(statearr_19715_19748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (3))){
var inst_19693 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19695__$1,inst_19693);
} else {
if((state_val_19696 === (12))){
var inst_19681 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
var statearr_19716_19749 = state_19695__$1;
(statearr_19716_19749[(2)] = inst_19681);

(statearr_19716_19749[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (2))){
var state_19695__$1 = state_19695;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19695__$1,(4),in$);
} else {
if((state_val_19696 === (23))){
var inst_19689 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
var statearr_19717_19750 = state_19695__$1;
(statearr_19717_19750[(2)] = inst_19689);

(statearr_19717_19750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (19))){
var inst_19676 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
var statearr_19718_19751 = state_19695__$1;
(statearr_19718_19751[(2)] = inst_19676);

(statearr_19718_19751[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (11))){
var inst_19661 = (state_19695[(7)]);
var inst_19647 = (state_19695[(12)]);
var inst_19661__$1 = cljs.core.seq.call(null,inst_19647);
var state_19695__$1 = (function (){var statearr_19719 = state_19695;
(statearr_19719[(7)] = inst_19661__$1);

return statearr_19719;
})();
if(inst_19661__$1){
var statearr_19720_19752 = state_19695__$1;
(statearr_19720_19752[(1)] = (14));

} else {
var statearr_19721_19753 = state_19695__$1;
(statearr_19721_19753[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (9))){
var inst_19683 = (state_19695[(2)]);
var inst_19684 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19695__$1 = (function (){var statearr_19722 = state_19695;
(statearr_19722[(15)] = inst_19683);

return statearr_19722;
})();
if(cljs.core.truth_(inst_19684)){
var statearr_19723_19754 = state_19695__$1;
(statearr_19723_19754[(1)] = (21));

} else {
var statearr_19724_19755 = state_19695__$1;
(statearr_19724_19755[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (5))){
var inst_19639 = cljs.core.async.close_BANG_.call(null,out);
var state_19695__$1 = state_19695;
var statearr_19725_19756 = state_19695__$1;
(statearr_19725_19756[(2)] = inst_19639);

(statearr_19725_19756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (14))){
var inst_19661 = (state_19695[(7)]);
var inst_19663 = cljs.core.chunked_seq_QMARK_.call(null,inst_19661);
var state_19695__$1 = state_19695;
if(inst_19663){
var statearr_19726_19757 = state_19695__$1;
(statearr_19726_19757[(1)] = (17));

} else {
var statearr_19727_19758 = state_19695__$1;
(statearr_19727_19758[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (16))){
var inst_19679 = (state_19695[(2)]);
var state_19695__$1 = state_19695;
var statearr_19728_19759 = state_19695__$1;
(statearr_19728_19759[(2)] = inst_19679);

(statearr_19728_19759[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19696 === (10))){
var inst_19650 = (state_19695[(9)]);
var inst_19648 = (state_19695[(11)]);
var inst_19655 = cljs.core._nth.call(null,inst_19648,inst_19650);
var state_19695__$1 = state_19695;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19695__$1,(13),out,inst_19655);
} else {
if((state_val_19696 === (18))){
var inst_19661 = (state_19695[(7)]);
var inst_19670 = cljs.core.first.call(null,inst_19661);
var state_19695__$1 = state_19695;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19695__$1,(20),out,inst_19670);
} else {
if((state_val_19696 === (8))){
var inst_19649 = (state_19695[(8)]);
var inst_19650 = (state_19695[(9)]);
var inst_19652 = (inst_19650 < inst_19649);
var inst_19653 = inst_19652;
var state_19695__$1 = state_19695;
if(cljs.core.truth_(inst_19653)){
var statearr_19729_19760 = state_19695__$1;
(statearr_19729_19760[(1)] = (10));

} else {
var statearr_19730_19761 = state_19695__$1;
(statearr_19730_19761[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19734 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19734[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19734[(1)] = (1));

return statearr_19734;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19695){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19695);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19735){if((e19735 instanceof Object)){
var ex__8254__auto__ = e19735;
var statearr_19736_19762 = state_19695;
(statearr_19736_19762[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19695);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19735;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19763 = state_19695;
state_19695 = G__19763;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19695){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19737 = f__8363__auto__.call(null);
(statearr_19737[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19764 = [];
var len__5726__auto___19767 = arguments.length;
var i__5727__auto___19768 = (0);
while(true){
if((i__5727__auto___19768 < len__5726__auto___19767)){
args19764.push((arguments[i__5727__auto___19768]));

var G__19769 = (i__5727__auto___19768 + (1));
i__5727__auto___19768 = G__19769;
continue;
} else {
}
break;
}

var G__19766 = args19764.length;
switch (G__19766) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19764.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19771 = [];
var len__5726__auto___19774 = arguments.length;
var i__5727__auto___19775 = (0);
while(true){
if((i__5727__auto___19775 < len__5726__auto___19774)){
args19771.push((arguments[i__5727__auto___19775]));

var G__19776 = (i__5727__auto___19775 + (1));
i__5727__auto___19775 = G__19776;
continue;
} else {
}
break;
}

var G__19773 = args19771.length;
switch (G__19773) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19771.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19778 = [];
var len__5726__auto___19829 = arguments.length;
var i__5727__auto___19830 = (0);
while(true){
if((i__5727__auto___19830 < len__5726__auto___19829)){
args19778.push((arguments[i__5727__auto___19830]));

var G__19831 = (i__5727__auto___19830 + (1));
i__5727__auto___19830 = G__19831;
continue;
} else {
}
break;
}

var G__19780 = args19778.length;
switch (G__19780) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19778.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19833 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19833,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19833,out){
return (function (state_19804){
var state_val_19805 = (state_19804[(1)]);
if((state_val_19805 === (7))){
var inst_19799 = (state_19804[(2)]);
var state_19804__$1 = state_19804;
var statearr_19806_19834 = state_19804__$1;
(statearr_19806_19834[(2)] = inst_19799);

(statearr_19806_19834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19805 === (1))){
var inst_19781 = null;
var state_19804__$1 = (function (){var statearr_19807 = state_19804;
(statearr_19807[(7)] = inst_19781);

return statearr_19807;
})();
var statearr_19808_19835 = state_19804__$1;
(statearr_19808_19835[(2)] = null);

(statearr_19808_19835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19805 === (4))){
var inst_19784 = (state_19804[(8)]);
var inst_19784__$1 = (state_19804[(2)]);
var inst_19785 = (inst_19784__$1 == null);
var inst_19786 = cljs.core.not.call(null,inst_19785);
var state_19804__$1 = (function (){var statearr_19809 = state_19804;
(statearr_19809[(8)] = inst_19784__$1);

return statearr_19809;
})();
if(inst_19786){
var statearr_19810_19836 = state_19804__$1;
(statearr_19810_19836[(1)] = (5));

} else {
var statearr_19811_19837 = state_19804__$1;
(statearr_19811_19837[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19805 === (6))){
var state_19804__$1 = state_19804;
var statearr_19812_19838 = state_19804__$1;
(statearr_19812_19838[(2)] = null);

(statearr_19812_19838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19805 === (3))){
var inst_19801 = (state_19804[(2)]);
var inst_19802 = cljs.core.async.close_BANG_.call(null,out);
var state_19804__$1 = (function (){var statearr_19813 = state_19804;
(statearr_19813[(9)] = inst_19801);

return statearr_19813;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19804__$1,inst_19802);
} else {
if((state_val_19805 === (2))){
var state_19804__$1 = state_19804;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19804__$1,(4),ch);
} else {
if((state_val_19805 === (11))){
var inst_19784 = (state_19804[(8)]);
var inst_19793 = (state_19804[(2)]);
var inst_19781 = inst_19784;
var state_19804__$1 = (function (){var statearr_19814 = state_19804;
(statearr_19814[(10)] = inst_19793);

(statearr_19814[(7)] = inst_19781);

return statearr_19814;
})();
var statearr_19815_19839 = state_19804__$1;
(statearr_19815_19839[(2)] = null);

(statearr_19815_19839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19805 === (9))){
var inst_19784 = (state_19804[(8)]);
var state_19804__$1 = state_19804;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19804__$1,(11),out,inst_19784);
} else {
if((state_val_19805 === (5))){
var inst_19781 = (state_19804[(7)]);
var inst_19784 = (state_19804[(8)]);
var inst_19788 = cljs.core._EQ_.call(null,inst_19784,inst_19781);
var state_19804__$1 = state_19804;
if(inst_19788){
var statearr_19817_19840 = state_19804__$1;
(statearr_19817_19840[(1)] = (8));

} else {
var statearr_19818_19841 = state_19804__$1;
(statearr_19818_19841[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19805 === (10))){
var inst_19796 = (state_19804[(2)]);
var state_19804__$1 = state_19804;
var statearr_19819_19842 = state_19804__$1;
(statearr_19819_19842[(2)] = inst_19796);

(statearr_19819_19842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19805 === (8))){
var inst_19781 = (state_19804[(7)]);
var tmp19816 = inst_19781;
var inst_19781__$1 = tmp19816;
var state_19804__$1 = (function (){var statearr_19820 = state_19804;
(statearr_19820[(7)] = inst_19781__$1);

return statearr_19820;
})();
var statearr_19821_19843 = state_19804__$1;
(statearr_19821_19843[(2)] = null);

(statearr_19821_19843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19833,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19833,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19825 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19825[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19825[(1)] = (1));

return statearr_19825;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19804){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19804);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19826){if((e19826 instanceof Object)){
var ex__8254__auto__ = e19826;
var statearr_19827_19844 = state_19804;
(statearr_19827_19844[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19804);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19826;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19845 = state_19804;
state_19804 = G__19845;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19804){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19833,out))
})();
var state__8364__auto__ = (function (){var statearr_19828 = f__8363__auto__.call(null);
(statearr_19828[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19833);

return statearr_19828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19833,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19846 = [];
var len__5726__auto___19916 = arguments.length;
var i__5727__auto___19917 = (0);
while(true){
if((i__5727__auto___19917 < len__5726__auto___19916)){
args19846.push((arguments[i__5727__auto___19917]));

var G__19918 = (i__5727__auto___19917 + (1));
i__5727__auto___19917 = G__19918;
continue;
} else {
}
break;
}

var G__19848 = args19846.length;
switch (G__19848) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19846.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19920 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19920,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19920,out){
return (function (state_19886){
var state_val_19887 = (state_19886[(1)]);
if((state_val_19887 === (7))){
var inst_19882 = (state_19886[(2)]);
var state_19886__$1 = state_19886;
var statearr_19888_19921 = state_19886__$1;
(statearr_19888_19921[(2)] = inst_19882);

(statearr_19888_19921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (1))){
var inst_19849 = (new Array(n));
var inst_19850 = inst_19849;
var inst_19851 = (0);
var state_19886__$1 = (function (){var statearr_19889 = state_19886;
(statearr_19889[(7)] = inst_19850);

(statearr_19889[(8)] = inst_19851);

return statearr_19889;
})();
var statearr_19890_19922 = state_19886__$1;
(statearr_19890_19922[(2)] = null);

(statearr_19890_19922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (4))){
var inst_19854 = (state_19886[(9)]);
var inst_19854__$1 = (state_19886[(2)]);
var inst_19855 = (inst_19854__$1 == null);
var inst_19856 = cljs.core.not.call(null,inst_19855);
var state_19886__$1 = (function (){var statearr_19891 = state_19886;
(statearr_19891[(9)] = inst_19854__$1);

return statearr_19891;
})();
if(inst_19856){
var statearr_19892_19923 = state_19886__$1;
(statearr_19892_19923[(1)] = (5));

} else {
var statearr_19893_19924 = state_19886__$1;
(statearr_19893_19924[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (15))){
var inst_19876 = (state_19886[(2)]);
var state_19886__$1 = state_19886;
var statearr_19894_19925 = state_19886__$1;
(statearr_19894_19925[(2)] = inst_19876);

(statearr_19894_19925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (13))){
var state_19886__$1 = state_19886;
var statearr_19895_19926 = state_19886__$1;
(statearr_19895_19926[(2)] = null);

(statearr_19895_19926[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (6))){
var inst_19851 = (state_19886[(8)]);
var inst_19872 = (inst_19851 > (0));
var state_19886__$1 = state_19886;
if(cljs.core.truth_(inst_19872)){
var statearr_19896_19927 = state_19886__$1;
(statearr_19896_19927[(1)] = (12));

} else {
var statearr_19897_19928 = state_19886__$1;
(statearr_19897_19928[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (3))){
var inst_19884 = (state_19886[(2)]);
var state_19886__$1 = state_19886;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19886__$1,inst_19884);
} else {
if((state_val_19887 === (12))){
var inst_19850 = (state_19886[(7)]);
var inst_19874 = cljs.core.vec.call(null,inst_19850);
var state_19886__$1 = state_19886;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19886__$1,(15),out,inst_19874);
} else {
if((state_val_19887 === (2))){
var state_19886__$1 = state_19886;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19886__$1,(4),ch);
} else {
if((state_val_19887 === (11))){
var inst_19866 = (state_19886[(2)]);
var inst_19867 = (new Array(n));
var inst_19850 = inst_19867;
var inst_19851 = (0);
var state_19886__$1 = (function (){var statearr_19898 = state_19886;
(statearr_19898[(7)] = inst_19850);

(statearr_19898[(8)] = inst_19851);

(statearr_19898[(10)] = inst_19866);

return statearr_19898;
})();
var statearr_19899_19929 = state_19886__$1;
(statearr_19899_19929[(2)] = null);

(statearr_19899_19929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (9))){
var inst_19850 = (state_19886[(7)]);
var inst_19864 = cljs.core.vec.call(null,inst_19850);
var state_19886__$1 = state_19886;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19886__$1,(11),out,inst_19864);
} else {
if((state_val_19887 === (5))){
var inst_19850 = (state_19886[(7)]);
var inst_19859 = (state_19886[(11)]);
var inst_19854 = (state_19886[(9)]);
var inst_19851 = (state_19886[(8)]);
var inst_19858 = (inst_19850[inst_19851] = inst_19854);
var inst_19859__$1 = (inst_19851 + (1));
var inst_19860 = (inst_19859__$1 < n);
var state_19886__$1 = (function (){var statearr_19900 = state_19886;
(statearr_19900[(11)] = inst_19859__$1);

(statearr_19900[(12)] = inst_19858);

return statearr_19900;
})();
if(cljs.core.truth_(inst_19860)){
var statearr_19901_19930 = state_19886__$1;
(statearr_19901_19930[(1)] = (8));

} else {
var statearr_19902_19931 = state_19886__$1;
(statearr_19902_19931[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (14))){
var inst_19879 = (state_19886[(2)]);
var inst_19880 = cljs.core.async.close_BANG_.call(null,out);
var state_19886__$1 = (function (){var statearr_19904 = state_19886;
(statearr_19904[(13)] = inst_19879);

return statearr_19904;
})();
var statearr_19905_19932 = state_19886__$1;
(statearr_19905_19932[(2)] = inst_19880);

(statearr_19905_19932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (10))){
var inst_19870 = (state_19886[(2)]);
var state_19886__$1 = state_19886;
var statearr_19906_19933 = state_19886__$1;
(statearr_19906_19933[(2)] = inst_19870);

(statearr_19906_19933[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19887 === (8))){
var inst_19850 = (state_19886[(7)]);
var inst_19859 = (state_19886[(11)]);
var tmp19903 = inst_19850;
var inst_19850__$1 = tmp19903;
var inst_19851 = inst_19859;
var state_19886__$1 = (function (){var statearr_19907 = state_19886;
(statearr_19907[(7)] = inst_19850__$1);

(statearr_19907[(8)] = inst_19851);

return statearr_19907;
})();
var statearr_19908_19934 = state_19886__$1;
(statearr_19908_19934[(2)] = null);

(statearr_19908_19934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19920,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19920,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19912 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19912[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19912[(1)] = (1));

return statearr_19912;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19886){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19886);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19913){if((e19913 instanceof Object)){
var ex__8254__auto__ = e19913;
var statearr_19914_19935 = state_19886;
(statearr_19914_19935[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19886);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19913;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19936 = state_19886;
state_19886 = G__19936;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19886){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19920,out))
})();
var state__8364__auto__ = (function (){var statearr_19915 = f__8363__auto__.call(null);
(statearr_19915[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19920);

return statearr_19915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19920,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19937 = [];
var len__5726__auto___20011 = arguments.length;
var i__5727__auto___20012 = (0);
while(true){
if((i__5727__auto___20012 < len__5726__auto___20011)){
args19937.push((arguments[i__5727__auto___20012]));

var G__20013 = (i__5727__auto___20012 + (1));
i__5727__auto___20012 = G__20013;
continue;
} else {
}
break;
}

var G__19939 = args19937.length;
switch (G__19939) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19937.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20015 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20015,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20015,out){
return (function (state_19981){
var state_val_19982 = (state_19981[(1)]);
if((state_val_19982 === (7))){
var inst_19977 = (state_19981[(2)]);
var state_19981__$1 = state_19981;
var statearr_19983_20016 = state_19981__$1;
(statearr_19983_20016[(2)] = inst_19977);

(statearr_19983_20016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (1))){
var inst_19940 = [];
var inst_19941 = inst_19940;
var inst_19942 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19981__$1 = (function (){var statearr_19984 = state_19981;
(statearr_19984[(7)] = inst_19941);

(statearr_19984[(8)] = inst_19942);

return statearr_19984;
})();
var statearr_19985_20017 = state_19981__$1;
(statearr_19985_20017[(2)] = null);

(statearr_19985_20017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (4))){
var inst_19945 = (state_19981[(9)]);
var inst_19945__$1 = (state_19981[(2)]);
var inst_19946 = (inst_19945__$1 == null);
var inst_19947 = cljs.core.not.call(null,inst_19946);
var state_19981__$1 = (function (){var statearr_19986 = state_19981;
(statearr_19986[(9)] = inst_19945__$1);

return statearr_19986;
})();
if(inst_19947){
var statearr_19987_20018 = state_19981__$1;
(statearr_19987_20018[(1)] = (5));

} else {
var statearr_19988_20019 = state_19981__$1;
(statearr_19988_20019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (15))){
var inst_19971 = (state_19981[(2)]);
var state_19981__$1 = state_19981;
var statearr_19989_20020 = state_19981__$1;
(statearr_19989_20020[(2)] = inst_19971);

(statearr_19989_20020[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (13))){
var state_19981__$1 = state_19981;
var statearr_19990_20021 = state_19981__$1;
(statearr_19990_20021[(2)] = null);

(statearr_19990_20021[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (6))){
var inst_19941 = (state_19981[(7)]);
var inst_19966 = inst_19941.length;
var inst_19967 = (inst_19966 > (0));
var state_19981__$1 = state_19981;
if(cljs.core.truth_(inst_19967)){
var statearr_19991_20022 = state_19981__$1;
(statearr_19991_20022[(1)] = (12));

} else {
var statearr_19992_20023 = state_19981__$1;
(statearr_19992_20023[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (3))){
var inst_19979 = (state_19981[(2)]);
var state_19981__$1 = state_19981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19981__$1,inst_19979);
} else {
if((state_val_19982 === (12))){
var inst_19941 = (state_19981[(7)]);
var inst_19969 = cljs.core.vec.call(null,inst_19941);
var state_19981__$1 = state_19981;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19981__$1,(15),out,inst_19969);
} else {
if((state_val_19982 === (2))){
var state_19981__$1 = state_19981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19981__$1,(4),ch);
} else {
if((state_val_19982 === (11))){
var inst_19945 = (state_19981[(9)]);
var inst_19949 = (state_19981[(10)]);
var inst_19959 = (state_19981[(2)]);
var inst_19960 = [];
var inst_19961 = inst_19960.push(inst_19945);
var inst_19941 = inst_19960;
var inst_19942 = inst_19949;
var state_19981__$1 = (function (){var statearr_19993 = state_19981;
(statearr_19993[(7)] = inst_19941);

(statearr_19993[(8)] = inst_19942);

(statearr_19993[(11)] = inst_19961);

(statearr_19993[(12)] = inst_19959);

return statearr_19993;
})();
var statearr_19994_20024 = state_19981__$1;
(statearr_19994_20024[(2)] = null);

(statearr_19994_20024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (9))){
var inst_19941 = (state_19981[(7)]);
var inst_19957 = cljs.core.vec.call(null,inst_19941);
var state_19981__$1 = state_19981;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19981__$1,(11),out,inst_19957);
} else {
if((state_val_19982 === (5))){
var inst_19945 = (state_19981[(9)]);
var inst_19942 = (state_19981[(8)]);
var inst_19949 = (state_19981[(10)]);
var inst_19949__$1 = f.call(null,inst_19945);
var inst_19950 = cljs.core._EQ_.call(null,inst_19949__$1,inst_19942);
var inst_19951 = cljs.core.keyword_identical_QMARK_.call(null,inst_19942,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19952 = (inst_19950) || (inst_19951);
var state_19981__$1 = (function (){var statearr_19995 = state_19981;
(statearr_19995[(10)] = inst_19949__$1);

return statearr_19995;
})();
if(cljs.core.truth_(inst_19952)){
var statearr_19996_20025 = state_19981__$1;
(statearr_19996_20025[(1)] = (8));

} else {
var statearr_19997_20026 = state_19981__$1;
(statearr_19997_20026[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (14))){
var inst_19974 = (state_19981[(2)]);
var inst_19975 = cljs.core.async.close_BANG_.call(null,out);
var state_19981__$1 = (function (){var statearr_19999 = state_19981;
(statearr_19999[(13)] = inst_19974);

return statearr_19999;
})();
var statearr_20000_20027 = state_19981__$1;
(statearr_20000_20027[(2)] = inst_19975);

(statearr_20000_20027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (10))){
var inst_19964 = (state_19981[(2)]);
var state_19981__$1 = state_19981;
var statearr_20001_20028 = state_19981__$1;
(statearr_20001_20028[(2)] = inst_19964);

(statearr_20001_20028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19982 === (8))){
var inst_19941 = (state_19981[(7)]);
var inst_19945 = (state_19981[(9)]);
var inst_19949 = (state_19981[(10)]);
var inst_19954 = inst_19941.push(inst_19945);
var tmp19998 = inst_19941;
var inst_19941__$1 = tmp19998;
var inst_19942 = inst_19949;
var state_19981__$1 = (function (){var statearr_20002 = state_19981;
(statearr_20002[(7)] = inst_19941__$1);

(statearr_20002[(8)] = inst_19942);

(statearr_20002[(14)] = inst_19954);

return statearr_20002;
})();
var statearr_20003_20029 = state_19981__$1;
(statearr_20003_20029[(2)] = null);

(statearr_20003_20029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20015,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20015,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_20007 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20007[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_20007[(1)] = (1));

return statearr_20007;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19981){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e20008){if((e20008 instanceof Object)){
var ex__8254__auto__ = e20008;
var statearr_20009_20030 = state_19981;
(statearr_20009_20030[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19981);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20031 = state_19981;
state_19981 = G__20031;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19981){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20015,out))
})();
var state__8364__auto__ = (function (){var statearr_20010 = f__8363__auto__.call(null);
(statearr_20010[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20015);

return statearr_20010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20015,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1454932705132