"use strict";

module.exports = {
    description: "noExtraKeywords - Forbid unrecognized keywords to be defined in schemas",
    options: {
        noExtraKeywords: true
    },
    validateSchemaOnly: true,
    tests: [
        {
            schema: {},
            description: "should pass schema validation",
            valid: true
        },
        {
            schema: {
                "random_keyword": "string"
            },
            description: "should fail schema validation, because 'random_keyword' is not known keyword",
            valid: false
        },
        {
            schema: {
                "$schema": "http://json-schema.org/draft-04/schema#",
                "random_keyword": "string"
            },
            description: "should pass schema validation, because schema is validated by $schema, even though it has 'random_keyword'",
            valid: true
        },
        {
            schema: {
                "$schema": "http://json-schema.org/draft-04/schema#",
                "title": 1
            },
            description: "should fail schema validation, because schema is validated by $schema and number is not valid for title",
            valid: false,
            after: function (err, valid) {
                expect(valid).toBe(false);
                expect(err[0].code).toBe("PARENT_SCHEMA_VALIDATION_FAILED");
            }
        }
    ]
};
