// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args8492 = [];
var len__5726__auto___8498 = arguments.length;
var i__5727__auto___8499 = (0);
while(true){
if((i__5727__auto___8499 < len__5726__auto___8498)){
args8492.push((arguments[i__5727__auto___8499]));

var G__8500 = (i__5727__auto___8499 + (1));
i__5727__auto___8499 = G__8500;
continue;
} else {
}
break;
}

var G__8494 = args8492.length;
switch (G__8494) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8492.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async8495 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8495 = (function (f,blockable,meta8496){
this.f = f;
this.blockable = blockable;
this.meta8496 = meta8496;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async8495.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8497,meta8496__$1){
var self__ = this;
var _8497__$1 = this;
return (new cljs.core.async.t_cljs$core$async8495(self__.f,self__.blockable,meta8496__$1));
});

cljs.core.async.t_cljs$core$async8495.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8497){
var self__ = this;
var _8497__$1 = this;
return self__.meta8496;
});

cljs.core.async.t_cljs$core$async8495.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async8495.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8495.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async8495.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async8495.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta8496","meta8496",1676966594,null)], null);
});

cljs.core.async.t_cljs$core$async8495.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8495.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8495";

cljs.core.async.t_cljs$core$async8495.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async8495");
});

cljs.core.async.__GT_t_cljs$core$async8495 = (function cljs$core$async$__GT_t_cljs$core$async8495(f__$1,blockable__$1,meta8496){
return (new cljs.core.async.t_cljs$core$async8495(f__$1,blockable__$1,meta8496));
});

}

return (new cljs.core.async.t_cljs$core$async8495(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args8504 = [];
var len__5726__auto___8507 = arguments.length;
var i__5727__auto___8508 = (0);
while(true){
if((i__5727__auto___8508 < len__5726__auto___8507)){
args8504.push((arguments[i__5727__auto___8508]));

var G__8509 = (i__5727__auto___8508 + (1));
i__5727__auto___8508 = G__8509;
continue;
} else {
}
break;
}

var G__8506 = args8504.length;
switch (G__8506) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8504.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args8511 = [];
var len__5726__auto___8514 = arguments.length;
var i__5727__auto___8515 = (0);
while(true){
if((i__5727__auto___8515 < len__5726__auto___8514)){
args8511.push((arguments[i__5727__auto___8515]));

var G__8516 = (i__5727__auto___8515 + (1));
i__5727__auto___8515 = G__8516;
continue;
} else {
}
break;
}

var G__8513 = args8511.length;
switch (G__8513) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8511.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args8518 = [];
var len__5726__auto___8521 = arguments.length;
var i__5727__auto___8522 = (0);
while(true){
if((i__5727__auto___8522 < len__5726__auto___8521)){
args8518.push((arguments[i__5727__auto___8522]));

var G__8523 = (i__5727__auto___8522 + (1));
i__5727__auto___8522 = G__8523;
continue;
} else {
}
break;
}

var G__8520 = args8518.length;
switch (G__8520) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8518.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_8525 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_8525);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_8525,ret){
return (function (){
return fn1.call(null,val_8525);
});})(val_8525,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args8526 = [];
var len__5726__auto___8529 = arguments.length;
var i__5727__auto___8530 = (0);
while(true){
if((i__5727__auto___8530 < len__5726__auto___8529)){
args8526.push((arguments[i__5727__auto___8530]));

var G__8531 = (i__5727__auto___8530 + (1));
i__5727__auto___8530 = G__8531;
continue;
} else {
}
break;
}

var G__8528 = args8526.length;
switch (G__8528) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8526.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___8533 = n;
var x_8534 = (0);
while(true){
if((x_8534 < n__5571__auto___8533)){
(a[x_8534] = (0));

var G__8535 = (x_8534 + (1));
x_8534 = G__8535;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__8536 = (i + (1));
i = G__8536;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async8540 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8540 = (function (alt_flag,flag,meta8541){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta8541 = meta8541;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async8540.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_8542,meta8541__$1){
var self__ = this;
var _8542__$1 = this;
return (new cljs.core.async.t_cljs$core$async8540(self__.alt_flag,self__.flag,meta8541__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async8540.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_8542){
var self__ = this;
var _8542__$1 = this;
return self__.meta8541;
});})(flag))
;

cljs.core.async.t_cljs$core$async8540.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async8540.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async8540.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8540.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8540.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta8541","meta8541",-609268653,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async8540.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8540.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8540";

cljs.core.async.t_cljs$core$async8540.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async8540");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async8540 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async8540(alt_flag__$1,flag__$1,meta8541){
return (new cljs.core.async.t_cljs$core$async8540(alt_flag__$1,flag__$1,meta8541));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async8540(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async8546 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8546 = (function (alt_handler,flag,cb,meta8547){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta8547 = meta8547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async8546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8548,meta8547__$1){
var self__ = this;
var _8548__$1 = this;
return (new cljs.core.async.t_cljs$core$async8546(self__.alt_handler,self__.flag,self__.cb,meta8547__$1));
});

cljs.core.async.t_cljs$core$async8546.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8548){
var self__ = this;
var _8548__$1 = this;
return self__.meta8547;
});

cljs.core.async.t_cljs$core$async8546.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async8546.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async8546.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8546.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async8546.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta8547","meta8547",-1955577493,null)], null);
});

cljs.core.async.t_cljs$core$async8546.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8546.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8546";

cljs.core.async.t_cljs$core$async8546.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async8546");
});

cljs.core.async.__GT_t_cljs$core$async8546 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async8546(alt_handler__$1,flag__$1,cb__$1,meta8547){
return (new cljs.core.async.t_cljs$core$async8546(alt_handler__$1,flag__$1,cb__$1,meta8547));
});

}

return (new cljs.core.async.t_cljs$core$async8546(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8549_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8549_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8550_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8550_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__8551 = (i + (1));
i = G__8551;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___8557 = arguments.length;
var i__5727__auto___8558 = (0);
while(true){
if((i__5727__auto___8558 < len__5726__auto___8557)){
args__5733__auto__.push((arguments[i__5727__auto___8558]));

var G__8559 = (i__5727__auto___8558 + (1));
i__5727__auto___8558 = G__8559;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__8554){
var map__8555 = p__8554;
var map__8555__$1 = ((((!((map__8555 == null)))?((((map__8555.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8555.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8555):map__8555);
var opts = map__8555__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq8552){
var G__8553 = cljs.core.first.call(null,seq8552);
var seq8552__$1 = cljs.core.next.call(null,seq8552);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8553,seq8552__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args8560 = [];
var len__5726__auto___8610 = arguments.length;
var i__5727__auto___8611 = (0);
while(true){
if((i__5727__auto___8611 < len__5726__auto___8610)){
args8560.push((arguments[i__5727__auto___8611]));

var G__8612 = (i__5727__auto___8611 + (1));
i__5727__auto___8611 = G__8612;
continue;
} else {
}
break;
}

var G__8562 = args8560.length;
switch (G__8562) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8560.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8447__auto___8614 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___8614){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___8614){
return (function (state_8586){
var state_val_8587 = (state_8586[(1)]);
if((state_val_8587 === (7))){
var inst_8582 = (state_8586[(2)]);
var state_8586__$1 = state_8586;
var statearr_8588_8615 = state_8586__$1;
(statearr_8588_8615[(2)] = inst_8582);

(statearr_8588_8615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (1))){
var state_8586__$1 = state_8586;
var statearr_8589_8616 = state_8586__$1;
(statearr_8589_8616[(2)] = null);

(statearr_8589_8616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (4))){
var inst_8565 = (state_8586[(7)]);
var inst_8565__$1 = (state_8586[(2)]);
var inst_8566 = (inst_8565__$1 == null);
var state_8586__$1 = (function (){var statearr_8590 = state_8586;
(statearr_8590[(7)] = inst_8565__$1);

return statearr_8590;
})();
if(cljs.core.truth_(inst_8566)){
var statearr_8591_8617 = state_8586__$1;
(statearr_8591_8617[(1)] = (5));

} else {
var statearr_8592_8618 = state_8586__$1;
(statearr_8592_8618[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (13))){
var state_8586__$1 = state_8586;
var statearr_8593_8619 = state_8586__$1;
(statearr_8593_8619[(2)] = null);

(statearr_8593_8619[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (6))){
var inst_8565 = (state_8586[(7)]);
var state_8586__$1 = state_8586;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8586__$1,(11),to,inst_8565);
} else {
if((state_val_8587 === (3))){
var inst_8584 = (state_8586[(2)]);
var state_8586__$1 = state_8586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8586__$1,inst_8584);
} else {
if((state_val_8587 === (12))){
var state_8586__$1 = state_8586;
var statearr_8594_8620 = state_8586__$1;
(statearr_8594_8620[(2)] = null);

(statearr_8594_8620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (2))){
var state_8586__$1 = state_8586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8586__$1,(4),from);
} else {
if((state_val_8587 === (11))){
var inst_8575 = (state_8586[(2)]);
var state_8586__$1 = state_8586;
if(cljs.core.truth_(inst_8575)){
var statearr_8595_8621 = state_8586__$1;
(statearr_8595_8621[(1)] = (12));

} else {
var statearr_8596_8622 = state_8586__$1;
(statearr_8596_8622[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (9))){
var state_8586__$1 = state_8586;
var statearr_8597_8623 = state_8586__$1;
(statearr_8597_8623[(2)] = null);

(statearr_8597_8623[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (5))){
var state_8586__$1 = state_8586;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8598_8624 = state_8586__$1;
(statearr_8598_8624[(1)] = (8));

} else {
var statearr_8599_8625 = state_8586__$1;
(statearr_8599_8625[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (14))){
var inst_8580 = (state_8586[(2)]);
var state_8586__$1 = state_8586;
var statearr_8600_8626 = state_8586__$1;
(statearr_8600_8626[(2)] = inst_8580);

(statearr_8600_8626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (10))){
var inst_8572 = (state_8586[(2)]);
var state_8586__$1 = state_8586;
var statearr_8601_8627 = state_8586__$1;
(statearr_8601_8627[(2)] = inst_8572);

(statearr_8601_8627[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8587 === (8))){
var inst_8569 = cljs.core.async.close_BANG_.call(null,to);
var state_8586__$1 = state_8586;
var statearr_8602_8628 = state_8586__$1;
(statearr_8602_8628[(2)] = inst_8569);

(statearr_8602_8628[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___8614))
;
return ((function (switch__8335__auto__,c__8447__auto___8614){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_8606 = [null,null,null,null,null,null,null,null];
(statearr_8606[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_8606[(1)] = (1));

return statearr_8606;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_8586){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_8586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e8607){if((e8607 instanceof Object)){
var ex__8339__auto__ = e8607;
var statearr_8608_8629 = state_8586;
(statearr_8608_8629[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8607;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8630 = state_8586;
state_8586 = G__8630;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_8586){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_8586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___8614))
})();
var state__8449__auto__ = (function (){var statearr_8609 = f__8448__auto__.call(null);
(statearr_8609[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___8614);

return statearr_8609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___8614))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__8814){
var vec__8815 = p__8814;
var v = cljs.core.nth.call(null,vec__8815,(0),null);
var p = cljs.core.nth.call(null,vec__8815,(1),null);
var job = vec__8815;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8447__auto___8997 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___8997,res,vec__8815,v,p,job,jobs,results){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___8997,res,vec__8815,v,p,job,jobs,results){
return (function (state_8820){
var state_val_8821 = (state_8820[(1)]);
if((state_val_8821 === (1))){
var state_8820__$1 = state_8820;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8820__$1,(2),res,v);
} else {
if((state_val_8821 === (2))){
var inst_8817 = (state_8820[(2)]);
var inst_8818 = cljs.core.async.close_BANG_.call(null,res);
var state_8820__$1 = (function (){var statearr_8822 = state_8820;
(statearr_8822[(7)] = inst_8817);

return statearr_8822;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8820__$1,inst_8818);
} else {
return null;
}
}
});})(c__8447__auto___8997,res,vec__8815,v,p,job,jobs,results))
;
return ((function (switch__8335__auto__,c__8447__auto___8997,res,vec__8815,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_8826 = [null,null,null,null,null,null,null,null];
(statearr_8826[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_8826[(1)] = (1));

return statearr_8826;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_8820){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_8820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e8827){if((e8827 instanceof Object)){
var ex__8339__auto__ = e8827;
var statearr_8828_8998 = state_8820;
(statearr_8828_8998[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8820);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8827;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8999 = state_8820;
state_8820 = G__8999;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_8820){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_8820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___8997,res,vec__8815,v,p,job,jobs,results))
})();
var state__8449__auto__ = (function (){var statearr_8829 = f__8448__auto__.call(null);
(statearr_8829[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___8997);

return statearr_8829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___8997,res,vec__8815,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__8830){
var vec__8831 = p__8830;
var v = cljs.core.nth.call(null,vec__8831,(0),null);
var p = cljs.core.nth.call(null,vec__8831,(1),null);
var job = vec__8831;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___9000 = n;
var __9001 = (0);
while(true){
if((__9001 < n__5571__auto___9000)){
var G__8832_9002 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__8832_9002) {
case "compute":
var c__8447__auto___9004 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__9001,c__8447__auto___9004,G__8832_9002,n__5571__auto___9000,jobs,results,process,async){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (__9001,c__8447__auto___9004,G__8832_9002,n__5571__auto___9000,jobs,results,process,async){
return (function (state_8845){
var state_val_8846 = (state_8845[(1)]);
if((state_val_8846 === (1))){
var state_8845__$1 = state_8845;
var statearr_8847_9005 = state_8845__$1;
(statearr_8847_9005[(2)] = null);

(statearr_8847_9005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (2))){
var state_8845__$1 = state_8845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8845__$1,(4),jobs);
} else {
if((state_val_8846 === (3))){
var inst_8843 = (state_8845[(2)]);
var state_8845__$1 = state_8845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8845__$1,inst_8843);
} else {
if((state_val_8846 === (4))){
var inst_8835 = (state_8845[(2)]);
var inst_8836 = process.call(null,inst_8835);
var state_8845__$1 = state_8845;
if(cljs.core.truth_(inst_8836)){
var statearr_8848_9006 = state_8845__$1;
(statearr_8848_9006[(1)] = (5));

} else {
var statearr_8849_9007 = state_8845__$1;
(statearr_8849_9007[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (5))){
var state_8845__$1 = state_8845;
var statearr_8850_9008 = state_8845__$1;
(statearr_8850_9008[(2)] = null);

(statearr_8850_9008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (6))){
var state_8845__$1 = state_8845;
var statearr_8851_9009 = state_8845__$1;
(statearr_8851_9009[(2)] = null);

(statearr_8851_9009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (7))){
var inst_8841 = (state_8845[(2)]);
var state_8845__$1 = state_8845;
var statearr_8852_9010 = state_8845__$1;
(statearr_8852_9010[(2)] = inst_8841);

(statearr_8852_9010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__9001,c__8447__auto___9004,G__8832_9002,n__5571__auto___9000,jobs,results,process,async))
;
return ((function (__9001,switch__8335__auto__,c__8447__auto___9004,G__8832_9002,n__5571__auto___9000,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_8856 = [null,null,null,null,null,null,null];
(statearr_8856[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_8856[(1)] = (1));

return statearr_8856;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_8845){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_8845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e8857){if((e8857 instanceof Object)){
var ex__8339__auto__ = e8857;
var statearr_8858_9011 = state_8845;
(statearr_8858_9011[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8845);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8857;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9012 = state_8845;
state_8845 = G__9012;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_8845){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_8845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(__9001,switch__8335__auto__,c__8447__auto___9004,G__8832_9002,n__5571__auto___9000,jobs,results,process,async))
})();
var state__8449__auto__ = (function (){var statearr_8859 = f__8448__auto__.call(null);
(statearr_8859[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___9004);

return statearr_8859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(__9001,c__8447__auto___9004,G__8832_9002,n__5571__auto___9000,jobs,results,process,async))
);


break;
case "async":
var c__8447__auto___9013 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__9001,c__8447__auto___9013,G__8832_9002,n__5571__auto___9000,jobs,results,process,async){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (__9001,c__8447__auto___9013,G__8832_9002,n__5571__auto___9000,jobs,results,process,async){
return (function (state_8872){
var state_val_8873 = (state_8872[(1)]);
if((state_val_8873 === (1))){
var state_8872__$1 = state_8872;
var statearr_8874_9014 = state_8872__$1;
(statearr_8874_9014[(2)] = null);

(statearr_8874_9014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8873 === (2))){
var state_8872__$1 = state_8872;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8872__$1,(4),jobs);
} else {
if((state_val_8873 === (3))){
var inst_8870 = (state_8872[(2)]);
var state_8872__$1 = state_8872;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8872__$1,inst_8870);
} else {
if((state_val_8873 === (4))){
var inst_8862 = (state_8872[(2)]);
var inst_8863 = async.call(null,inst_8862);
var state_8872__$1 = state_8872;
if(cljs.core.truth_(inst_8863)){
var statearr_8875_9015 = state_8872__$1;
(statearr_8875_9015[(1)] = (5));

} else {
var statearr_8876_9016 = state_8872__$1;
(statearr_8876_9016[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8873 === (5))){
var state_8872__$1 = state_8872;
var statearr_8877_9017 = state_8872__$1;
(statearr_8877_9017[(2)] = null);

(statearr_8877_9017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8873 === (6))){
var state_8872__$1 = state_8872;
var statearr_8878_9018 = state_8872__$1;
(statearr_8878_9018[(2)] = null);

(statearr_8878_9018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8873 === (7))){
var inst_8868 = (state_8872[(2)]);
var state_8872__$1 = state_8872;
var statearr_8879_9019 = state_8872__$1;
(statearr_8879_9019[(2)] = inst_8868);

(statearr_8879_9019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__9001,c__8447__auto___9013,G__8832_9002,n__5571__auto___9000,jobs,results,process,async))
;
return ((function (__9001,switch__8335__auto__,c__8447__auto___9013,G__8832_9002,n__5571__auto___9000,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_8883 = [null,null,null,null,null,null,null];
(statearr_8883[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_8883[(1)] = (1));

return statearr_8883;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_8872){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_8872);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e8884){if((e8884 instanceof Object)){
var ex__8339__auto__ = e8884;
var statearr_8885_9020 = state_8872;
(statearr_8885_9020[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8872);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9021 = state_8872;
state_8872 = G__9021;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_8872){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_8872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(__9001,switch__8335__auto__,c__8447__auto___9013,G__8832_9002,n__5571__auto___9000,jobs,results,process,async))
})();
var state__8449__auto__ = (function (){var statearr_8886 = f__8448__auto__.call(null);
(statearr_8886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___9013);

return statearr_8886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(__9001,c__8447__auto___9013,G__8832_9002,n__5571__auto___9000,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__9022 = (__9001 + (1));
__9001 = G__9022;
continue;
} else {
}
break;
}

var c__8447__auto___9023 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___9023,jobs,results,process,async){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___9023,jobs,results,process,async){
return (function (state_8908){
var state_val_8909 = (state_8908[(1)]);
if((state_val_8909 === (1))){
var state_8908__$1 = state_8908;
var statearr_8910_9024 = state_8908__$1;
(statearr_8910_9024[(2)] = null);

(statearr_8910_9024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8909 === (2))){
var state_8908__$1 = state_8908;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8908__$1,(4),from);
} else {
if((state_val_8909 === (3))){
var inst_8906 = (state_8908[(2)]);
var state_8908__$1 = state_8908;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8908__$1,inst_8906);
} else {
if((state_val_8909 === (4))){
var inst_8889 = (state_8908[(7)]);
var inst_8889__$1 = (state_8908[(2)]);
var inst_8890 = (inst_8889__$1 == null);
var state_8908__$1 = (function (){var statearr_8911 = state_8908;
(statearr_8911[(7)] = inst_8889__$1);

return statearr_8911;
})();
if(cljs.core.truth_(inst_8890)){
var statearr_8912_9025 = state_8908__$1;
(statearr_8912_9025[(1)] = (5));

} else {
var statearr_8913_9026 = state_8908__$1;
(statearr_8913_9026[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8909 === (5))){
var inst_8892 = cljs.core.async.close_BANG_.call(null,jobs);
var state_8908__$1 = state_8908;
var statearr_8914_9027 = state_8908__$1;
(statearr_8914_9027[(2)] = inst_8892);

(statearr_8914_9027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8909 === (6))){
var inst_8889 = (state_8908[(7)]);
var inst_8894 = (state_8908[(8)]);
var inst_8894__$1 = cljs.core.async.chan.call(null,(1));
var inst_8895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_8896 = [inst_8889,inst_8894__$1];
var inst_8897 = (new cljs.core.PersistentVector(null,2,(5),inst_8895,inst_8896,null));
var state_8908__$1 = (function (){var statearr_8915 = state_8908;
(statearr_8915[(8)] = inst_8894__$1);

return statearr_8915;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8908__$1,(8),jobs,inst_8897);
} else {
if((state_val_8909 === (7))){
var inst_8904 = (state_8908[(2)]);
var state_8908__$1 = state_8908;
var statearr_8916_9028 = state_8908__$1;
(statearr_8916_9028[(2)] = inst_8904);

(statearr_8916_9028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8909 === (8))){
var inst_8894 = (state_8908[(8)]);
var inst_8899 = (state_8908[(2)]);
var state_8908__$1 = (function (){var statearr_8917 = state_8908;
(statearr_8917[(9)] = inst_8899);

return statearr_8917;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8908__$1,(9),results,inst_8894);
} else {
if((state_val_8909 === (9))){
var inst_8901 = (state_8908[(2)]);
var state_8908__$1 = (function (){var statearr_8918 = state_8908;
(statearr_8918[(10)] = inst_8901);

return statearr_8918;
})();
var statearr_8919_9029 = state_8908__$1;
(statearr_8919_9029[(2)] = null);

(statearr_8919_9029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___9023,jobs,results,process,async))
;
return ((function (switch__8335__auto__,c__8447__auto___9023,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_8923 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8923[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_8923[(1)] = (1));

return statearr_8923;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_8908){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_8908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e8924){if((e8924 instanceof Object)){
var ex__8339__auto__ = e8924;
var statearr_8925_9030 = state_8908;
(statearr_8925_9030[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8908);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8924;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9031 = state_8908;
state_8908 = G__9031;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_8908){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_8908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___9023,jobs,results,process,async))
})();
var state__8449__auto__ = (function (){var statearr_8926 = f__8448__auto__.call(null);
(statearr_8926[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___9023);

return statearr_8926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___9023,jobs,results,process,async))
);


var c__8447__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto__,jobs,results,process,async){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto__,jobs,results,process,async){
return (function (state_8964){
var state_val_8965 = (state_8964[(1)]);
if((state_val_8965 === (7))){
var inst_8960 = (state_8964[(2)]);
var state_8964__$1 = state_8964;
var statearr_8966_9032 = state_8964__$1;
(statearr_8966_9032[(2)] = inst_8960);

(statearr_8966_9032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (20))){
var state_8964__$1 = state_8964;
var statearr_8967_9033 = state_8964__$1;
(statearr_8967_9033[(2)] = null);

(statearr_8967_9033[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (1))){
var state_8964__$1 = state_8964;
var statearr_8968_9034 = state_8964__$1;
(statearr_8968_9034[(2)] = null);

(statearr_8968_9034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (4))){
var inst_8929 = (state_8964[(7)]);
var inst_8929__$1 = (state_8964[(2)]);
var inst_8930 = (inst_8929__$1 == null);
var state_8964__$1 = (function (){var statearr_8969 = state_8964;
(statearr_8969[(7)] = inst_8929__$1);

return statearr_8969;
})();
if(cljs.core.truth_(inst_8930)){
var statearr_8970_9035 = state_8964__$1;
(statearr_8970_9035[(1)] = (5));

} else {
var statearr_8971_9036 = state_8964__$1;
(statearr_8971_9036[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (15))){
var inst_8942 = (state_8964[(8)]);
var state_8964__$1 = state_8964;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8964__$1,(18),to,inst_8942);
} else {
if((state_val_8965 === (21))){
var inst_8955 = (state_8964[(2)]);
var state_8964__$1 = state_8964;
var statearr_8972_9037 = state_8964__$1;
(statearr_8972_9037[(2)] = inst_8955);

(statearr_8972_9037[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (13))){
var inst_8957 = (state_8964[(2)]);
var state_8964__$1 = (function (){var statearr_8973 = state_8964;
(statearr_8973[(9)] = inst_8957);

return statearr_8973;
})();
var statearr_8974_9038 = state_8964__$1;
(statearr_8974_9038[(2)] = null);

(statearr_8974_9038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (6))){
var inst_8929 = (state_8964[(7)]);
var state_8964__$1 = state_8964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8964__$1,(11),inst_8929);
} else {
if((state_val_8965 === (17))){
var inst_8950 = (state_8964[(2)]);
var state_8964__$1 = state_8964;
if(cljs.core.truth_(inst_8950)){
var statearr_8975_9039 = state_8964__$1;
(statearr_8975_9039[(1)] = (19));

} else {
var statearr_8976_9040 = state_8964__$1;
(statearr_8976_9040[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (3))){
var inst_8962 = (state_8964[(2)]);
var state_8964__$1 = state_8964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8964__$1,inst_8962);
} else {
if((state_val_8965 === (12))){
var inst_8939 = (state_8964[(10)]);
var state_8964__$1 = state_8964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8964__$1,(14),inst_8939);
} else {
if((state_val_8965 === (2))){
var state_8964__$1 = state_8964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8964__$1,(4),results);
} else {
if((state_val_8965 === (19))){
var state_8964__$1 = state_8964;
var statearr_8977_9041 = state_8964__$1;
(statearr_8977_9041[(2)] = null);

(statearr_8977_9041[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (11))){
var inst_8939 = (state_8964[(2)]);
var state_8964__$1 = (function (){var statearr_8978 = state_8964;
(statearr_8978[(10)] = inst_8939);

return statearr_8978;
})();
var statearr_8979_9042 = state_8964__$1;
(statearr_8979_9042[(2)] = null);

(statearr_8979_9042[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (9))){
var state_8964__$1 = state_8964;
var statearr_8980_9043 = state_8964__$1;
(statearr_8980_9043[(2)] = null);

(statearr_8980_9043[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (5))){
var state_8964__$1 = state_8964;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8981_9044 = state_8964__$1;
(statearr_8981_9044[(1)] = (8));

} else {
var statearr_8982_9045 = state_8964__$1;
(statearr_8982_9045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (14))){
var inst_8944 = (state_8964[(11)]);
var inst_8942 = (state_8964[(8)]);
var inst_8942__$1 = (state_8964[(2)]);
var inst_8943 = (inst_8942__$1 == null);
var inst_8944__$1 = cljs.core.not.call(null,inst_8943);
var state_8964__$1 = (function (){var statearr_8983 = state_8964;
(statearr_8983[(11)] = inst_8944__$1);

(statearr_8983[(8)] = inst_8942__$1);

return statearr_8983;
})();
if(inst_8944__$1){
var statearr_8984_9046 = state_8964__$1;
(statearr_8984_9046[(1)] = (15));

} else {
var statearr_8985_9047 = state_8964__$1;
(statearr_8985_9047[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (16))){
var inst_8944 = (state_8964[(11)]);
var state_8964__$1 = state_8964;
var statearr_8986_9048 = state_8964__$1;
(statearr_8986_9048[(2)] = inst_8944);

(statearr_8986_9048[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (10))){
var inst_8936 = (state_8964[(2)]);
var state_8964__$1 = state_8964;
var statearr_8987_9049 = state_8964__$1;
(statearr_8987_9049[(2)] = inst_8936);

(statearr_8987_9049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (18))){
var inst_8947 = (state_8964[(2)]);
var state_8964__$1 = state_8964;
var statearr_8988_9050 = state_8964__$1;
(statearr_8988_9050[(2)] = inst_8947);

(statearr_8988_9050[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8965 === (8))){
var inst_8933 = cljs.core.async.close_BANG_.call(null,to);
var state_8964__$1 = state_8964;
var statearr_8989_9051 = state_8964__$1;
(statearr_8989_9051[(2)] = inst_8933);

(statearr_8989_9051[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto__,jobs,results,process,async))
;
return ((function (switch__8335__auto__,c__8447__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_8993 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8993[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_8993[(1)] = (1));

return statearr_8993;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_8964){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_8964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e8994){if((e8994 instanceof Object)){
var ex__8339__auto__ = e8994;
var statearr_8995_9052 = state_8964;
(statearr_8995_9052[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8964);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8994;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9053 = state_8964;
state_8964 = G__9053;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_8964){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_8964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto__,jobs,results,process,async))
})();
var state__8449__auto__ = (function (){var statearr_8996 = f__8448__auto__.call(null);
(statearr_8996[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto__);

return statearr_8996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto__,jobs,results,process,async))
);

return c__8447__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args9054 = [];
var len__5726__auto___9057 = arguments.length;
var i__5727__auto___9058 = (0);
while(true){
if((i__5727__auto___9058 < len__5726__auto___9057)){
args9054.push((arguments[i__5727__auto___9058]));

var G__9059 = (i__5727__auto___9058 + (1));
i__5727__auto___9058 = G__9059;
continue;
} else {
}
break;
}

var G__9056 = args9054.length;
switch (G__9056) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9054.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args9061 = [];
var len__5726__auto___9064 = arguments.length;
var i__5727__auto___9065 = (0);
while(true){
if((i__5727__auto___9065 < len__5726__auto___9064)){
args9061.push((arguments[i__5727__auto___9065]));

var G__9066 = (i__5727__auto___9065 + (1));
i__5727__auto___9065 = G__9066;
continue;
} else {
}
break;
}

var G__9063 = args9061.length;
switch (G__9063) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9061.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args9068 = [];
var len__5726__auto___9121 = arguments.length;
var i__5727__auto___9122 = (0);
while(true){
if((i__5727__auto___9122 < len__5726__auto___9121)){
args9068.push((arguments[i__5727__auto___9122]));

var G__9123 = (i__5727__auto___9122 + (1));
i__5727__auto___9122 = G__9123;
continue;
} else {
}
break;
}

var G__9070 = args9068.length;
switch (G__9070) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9068.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8447__auto___9125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___9125,tc,fc){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___9125,tc,fc){
return (function (state_9096){
var state_val_9097 = (state_9096[(1)]);
if((state_val_9097 === (7))){
var inst_9092 = (state_9096[(2)]);
var state_9096__$1 = state_9096;
var statearr_9098_9126 = state_9096__$1;
(statearr_9098_9126[(2)] = inst_9092);

(statearr_9098_9126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (1))){
var state_9096__$1 = state_9096;
var statearr_9099_9127 = state_9096__$1;
(statearr_9099_9127[(2)] = null);

(statearr_9099_9127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (4))){
var inst_9073 = (state_9096[(7)]);
var inst_9073__$1 = (state_9096[(2)]);
var inst_9074 = (inst_9073__$1 == null);
var state_9096__$1 = (function (){var statearr_9100 = state_9096;
(statearr_9100[(7)] = inst_9073__$1);

return statearr_9100;
})();
if(cljs.core.truth_(inst_9074)){
var statearr_9101_9128 = state_9096__$1;
(statearr_9101_9128[(1)] = (5));

} else {
var statearr_9102_9129 = state_9096__$1;
(statearr_9102_9129[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (13))){
var state_9096__$1 = state_9096;
var statearr_9103_9130 = state_9096__$1;
(statearr_9103_9130[(2)] = null);

(statearr_9103_9130[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (6))){
var inst_9073 = (state_9096[(7)]);
var inst_9079 = p.call(null,inst_9073);
var state_9096__$1 = state_9096;
if(cljs.core.truth_(inst_9079)){
var statearr_9104_9131 = state_9096__$1;
(statearr_9104_9131[(1)] = (9));

} else {
var statearr_9105_9132 = state_9096__$1;
(statearr_9105_9132[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (3))){
var inst_9094 = (state_9096[(2)]);
var state_9096__$1 = state_9096;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9096__$1,inst_9094);
} else {
if((state_val_9097 === (12))){
var state_9096__$1 = state_9096;
var statearr_9106_9133 = state_9096__$1;
(statearr_9106_9133[(2)] = null);

(statearr_9106_9133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (2))){
var state_9096__$1 = state_9096;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9096__$1,(4),ch);
} else {
if((state_val_9097 === (11))){
var inst_9073 = (state_9096[(7)]);
var inst_9083 = (state_9096[(2)]);
var state_9096__$1 = state_9096;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9096__$1,(8),inst_9083,inst_9073);
} else {
if((state_val_9097 === (9))){
var state_9096__$1 = state_9096;
var statearr_9107_9134 = state_9096__$1;
(statearr_9107_9134[(2)] = tc);

(statearr_9107_9134[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (5))){
var inst_9076 = cljs.core.async.close_BANG_.call(null,tc);
var inst_9077 = cljs.core.async.close_BANG_.call(null,fc);
var state_9096__$1 = (function (){var statearr_9108 = state_9096;
(statearr_9108[(8)] = inst_9076);

return statearr_9108;
})();
var statearr_9109_9135 = state_9096__$1;
(statearr_9109_9135[(2)] = inst_9077);

(statearr_9109_9135[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (14))){
var inst_9090 = (state_9096[(2)]);
var state_9096__$1 = state_9096;
var statearr_9110_9136 = state_9096__$1;
(statearr_9110_9136[(2)] = inst_9090);

(statearr_9110_9136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (10))){
var state_9096__$1 = state_9096;
var statearr_9111_9137 = state_9096__$1;
(statearr_9111_9137[(2)] = fc);

(statearr_9111_9137[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9097 === (8))){
var inst_9085 = (state_9096[(2)]);
var state_9096__$1 = state_9096;
if(cljs.core.truth_(inst_9085)){
var statearr_9112_9138 = state_9096__$1;
(statearr_9112_9138[(1)] = (12));

} else {
var statearr_9113_9139 = state_9096__$1;
(statearr_9113_9139[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___9125,tc,fc))
;
return ((function (switch__8335__auto__,c__8447__auto___9125,tc,fc){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_9117 = [null,null,null,null,null,null,null,null,null];
(statearr_9117[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_9117[(1)] = (1));

return statearr_9117;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_9096){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_9096);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e9118){if((e9118 instanceof Object)){
var ex__8339__auto__ = e9118;
var statearr_9119_9140 = state_9096;
(statearr_9119_9140[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9096);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9118;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9141 = state_9096;
state_9096 = G__9141;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_9096){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_9096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___9125,tc,fc))
})();
var state__8449__auto__ = (function (){var statearr_9120 = f__8448__auto__.call(null);
(statearr_9120[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___9125);

return statearr_9120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___9125,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8447__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto__){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto__){
return (function (state_9205){
var state_val_9206 = (state_9205[(1)]);
if((state_val_9206 === (7))){
var inst_9201 = (state_9205[(2)]);
var state_9205__$1 = state_9205;
var statearr_9207_9228 = state_9205__$1;
(statearr_9207_9228[(2)] = inst_9201);

(statearr_9207_9228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9206 === (1))){
var inst_9185 = init;
var state_9205__$1 = (function (){var statearr_9208 = state_9205;
(statearr_9208[(7)] = inst_9185);

return statearr_9208;
})();
var statearr_9209_9229 = state_9205__$1;
(statearr_9209_9229[(2)] = null);

(statearr_9209_9229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9206 === (4))){
var inst_9188 = (state_9205[(8)]);
var inst_9188__$1 = (state_9205[(2)]);
var inst_9189 = (inst_9188__$1 == null);
var state_9205__$1 = (function (){var statearr_9210 = state_9205;
(statearr_9210[(8)] = inst_9188__$1);

return statearr_9210;
})();
if(cljs.core.truth_(inst_9189)){
var statearr_9211_9230 = state_9205__$1;
(statearr_9211_9230[(1)] = (5));

} else {
var statearr_9212_9231 = state_9205__$1;
(statearr_9212_9231[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9206 === (6))){
var inst_9192 = (state_9205[(9)]);
var inst_9185 = (state_9205[(7)]);
var inst_9188 = (state_9205[(8)]);
var inst_9192__$1 = f.call(null,inst_9185,inst_9188);
var inst_9193 = cljs.core.reduced_QMARK_.call(null,inst_9192__$1);
var state_9205__$1 = (function (){var statearr_9213 = state_9205;
(statearr_9213[(9)] = inst_9192__$1);

return statearr_9213;
})();
if(inst_9193){
var statearr_9214_9232 = state_9205__$1;
(statearr_9214_9232[(1)] = (8));

} else {
var statearr_9215_9233 = state_9205__$1;
(statearr_9215_9233[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9206 === (3))){
var inst_9203 = (state_9205[(2)]);
var state_9205__$1 = state_9205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9205__$1,inst_9203);
} else {
if((state_val_9206 === (2))){
var state_9205__$1 = state_9205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9205__$1,(4),ch);
} else {
if((state_val_9206 === (9))){
var inst_9192 = (state_9205[(9)]);
var inst_9185 = inst_9192;
var state_9205__$1 = (function (){var statearr_9216 = state_9205;
(statearr_9216[(7)] = inst_9185);

return statearr_9216;
})();
var statearr_9217_9234 = state_9205__$1;
(statearr_9217_9234[(2)] = null);

(statearr_9217_9234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9206 === (5))){
var inst_9185 = (state_9205[(7)]);
var state_9205__$1 = state_9205;
var statearr_9218_9235 = state_9205__$1;
(statearr_9218_9235[(2)] = inst_9185);

(statearr_9218_9235[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9206 === (10))){
var inst_9199 = (state_9205[(2)]);
var state_9205__$1 = state_9205;
var statearr_9219_9236 = state_9205__$1;
(statearr_9219_9236[(2)] = inst_9199);

(statearr_9219_9236[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9206 === (8))){
var inst_9192 = (state_9205[(9)]);
var inst_9195 = cljs.core.deref.call(null,inst_9192);
var state_9205__$1 = state_9205;
var statearr_9220_9237 = state_9205__$1;
(statearr_9220_9237[(2)] = inst_9195);

(statearr_9220_9237[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto__))
;
return ((function (switch__8335__auto__,c__8447__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8336__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8336__auto____0 = (function (){
var statearr_9224 = [null,null,null,null,null,null,null,null,null,null];
(statearr_9224[(0)] = cljs$core$async$reduce_$_state_machine__8336__auto__);

(statearr_9224[(1)] = (1));

return statearr_9224;
});
var cljs$core$async$reduce_$_state_machine__8336__auto____1 = (function (state_9205){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_9205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e9225){if((e9225 instanceof Object)){
var ex__8339__auto__ = e9225;
var statearr_9226_9238 = state_9205;
(statearr_9226_9238[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9205);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9225;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9239 = state_9205;
state_9205 = G__9239;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8336__auto__ = function(state_9205){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8336__auto____1.call(this,state_9205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8336__auto____0;
cljs$core$async$reduce_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8336__auto____1;
return cljs$core$async$reduce_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto__))
})();
var state__8449__auto__ = (function (){var statearr_9227 = f__8448__auto__.call(null);
(statearr_9227[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto__);

return statearr_9227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto__))
);

return c__8447__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args9240 = [];
var len__5726__auto___9292 = arguments.length;
var i__5727__auto___9293 = (0);
while(true){
if((i__5727__auto___9293 < len__5726__auto___9292)){
args9240.push((arguments[i__5727__auto___9293]));

var G__9294 = (i__5727__auto___9293 + (1));
i__5727__auto___9293 = G__9294;
continue;
} else {
}
break;
}

var G__9242 = args9240.length;
switch (G__9242) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9240.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8447__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto__){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto__){
return (function (state_9267){
var state_val_9268 = (state_9267[(1)]);
if((state_val_9268 === (7))){
var inst_9249 = (state_9267[(2)]);
var state_9267__$1 = state_9267;
var statearr_9269_9296 = state_9267__$1;
(statearr_9269_9296[(2)] = inst_9249);

(statearr_9269_9296[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (1))){
var inst_9243 = cljs.core.seq.call(null,coll);
var inst_9244 = inst_9243;
var state_9267__$1 = (function (){var statearr_9270 = state_9267;
(statearr_9270[(7)] = inst_9244);

return statearr_9270;
})();
var statearr_9271_9297 = state_9267__$1;
(statearr_9271_9297[(2)] = null);

(statearr_9271_9297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (4))){
var inst_9244 = (state_9267[(7)]);
var inst_9247 = cljs.core.first.call(null,inst_9244);
var state_9267__$1 = state_9267;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9267__$1,(7),ch,inst_9247);
} else {
if((state_val_9268 === (13))){
var inst_9261 = (state_9267[(2)]);
var state_9267__$1 = state_9267;
var statearr_9272_9298 = state_9267__$1;
(statearr_9272_9298[(2)] = inst_9261);

(statearr_9272_9298[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (6))){
var inst_9252 = (state_9267[(2)]);
var state_9267__$1 = state_9267;
if(cljs.core.truth_(inst_9252)){
var statearr_9273_9299 = state_9267__$1;
(statearr_9273_9299[(1)] = (8));

} else {
var statearr_9274_9300 = state_9267__$1;
(statearr_9274_9300[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (3))){
var inst_9265 = (state_9267[(2)]);
var state_9267__$1 = state_9267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9267__$1,inst_9265);
} else {
if((state_val_9268 === (12))){
var state_9267__$1 = state_9267;
var statearr_9275_9301 = state_9267__$1;
(statearr_9275_9301[(2)] = null);

(statearr_9275_9301[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (2))){
var inst_9244 = (state_9267[(7)]);
var state_9267__$1 = state_9267;
if(cljs.core.truth_(inst_9244)){
var statearr_9276_9302 = state_9267__$1;
(statearr_9276_9302[(1)] = (4));

} else {
var statearr_9277_9303 = state_9267__$1;
(statearr_9277_9303[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (11))){
var inst_9258 = cljs.core.async.close_BANG_.call(null,ch);
var state_9267__$1 = state_9267;
var statearr_9278_9304 = state_9267__$1;
(statearr_9278_9304[(2)] = inst_9258);

(statearr_9278_9304[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (9))){
var state_9267__$1 = state_9267;
if(cljs.core.truth_(close_QMARK_)){
var statearr_9279_9305 = state_9267__$1;
(statearr_9279_9305[(1)] = (11));

} else {
var statearr_9280_9306 = state_9267__$1;
(statearr_9280_9306[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (5))){
var inst_9244 = (state_9267[(7)]);
var state_9267__$1 = state_9267;
var statearr_9281_9307 = state_9267__$1;
(statearr_9281_9307[(2)] = inst_9244);

(statearr_9281_9307[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (10))){
var inst_9263 = (state_9267[(2)]);
var state_9267__$1 = state_9267;
var statearr_9282_9308 = state_9267__$1;
(statearr_9282_9308[(2)] = inst_9263);

(statearr_9282_9308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9268 === (8))){
var inst_9244 = (state_9267[(7)]);
var inst_9254 = cljs.core.next.call(null,inst_9244);
var inst_9244__$1 = inst_9254;
var state_9267__$1 = (function (){var statearr_9283 = state_9267;
(statearr_9283[(7)] = inst_9244__$1);

return statearr_9283;
})();
var statearr_9284_9309 = state_9267__$1;
(statearr_9284_9309[(2)] = null);

(statearr_9284_9309[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto__))
;
return ((function (switch__8335__auto__,c__8447__auto__){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_9288 = [null,null,null,null,null,null,null,null];
(statearr_9288[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_9288[(1)] = (1));

return statearr_9288;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_9267){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_9267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e9289){if((e9289 instanceof Object)){
var ex__8339__auto__ = e9289;
var statearr_9290_9310 = state_9267;
(statearr_9290_9310[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9267);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9289;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9311 = state_9267;
state_9267 = G__9311;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_9267){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_9267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto__))
})();
var state__8449__auto__ = (function (){var statearr_9291 = f__8448__auto__.call(null);
(statearr_9291[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto__);

return statearr_9291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto__))
);

return c__8447__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async9533 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9533 = (function (mult,ch,cs,meta9534){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta9534 = meta9534;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async9533.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_9535,meta9534__$1){
var self__ = this;
var _9535__$1 = this;
return (new cljs.core.async.t_cljs$core$async9533(self__.mult,self__.ch,self__.cs,meta9534__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async9533.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_9535){
var self__ = this;
var _9535__$1 = this;
return self__.meta9534;
});})(cs))
;

cljs.core.async.t_cljs$core$async9533.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async9533.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async9533.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async9533.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9533.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9533.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9533.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta9534","meta9534",-1012641190,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async9533.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9533.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9533";

cljs.core.async.t_cljs$core$async9533.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async9533");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async9533 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async9533(mult__$1,ch__$1,cs__$1,meta9534){
return (new cljs.core.async.t_cljs$core$async9533(mult__$1,ch__$1,cs__$1,meta9534));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async9533(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8447__auto___9754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___9754,cs,m,dchan,dctr,done){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___9754,cs,m,dchan,dctr,done){
return (function (state_9666){
var state_val_9667 = (state_9666[(1)]);
if((state_val_9667 === (7))){
var inst_9662 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9668_9755 = state_9666__$1;
(statearr_9668_9755[(2)] = inst_9662);

(statearr_9668_9755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (20))){
var inst_9567 = (state_9666[(7)]);
var inst_9577 = cljs.core.first.call(null,inst_9567);
var inst_9578 = cljs.core.nth.call(null,inst_9577,(0),null);
var inst_9579 = cljs.core.nth.call(null,inst_9577,(1),null);
var state_9666__$1 = (function (){var statearr_9669 = state_9666;
(statearr_9669[(8)] = inst_9578);

return statearr_9669;
})();
if(cljs.core.truth_(inst_9579)){
var statearr_9670_9756 = state_9666__$1;
(statearr_9670_9756[(1)] = (22));

} else {
var statearr_9671_9757 = state_9666__$1;
(statearr_9671_9757[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (27))){
var inst_9607 = (state_9666[(9)]);
var inst_9609 = (state_9666[(10)]);
var inst_9614 = (state_9666[(11)]);
var inst_9538 = (state_9666[(12)]);
var inst_9614__$1 = cljs.core._nth.call(null,inst_9607,inst_9609);
var inst_9615 = cljs.core.async.put_BANG_.call(null,inst_9614__$1,inst_9538,done);
var state_9666__$1 = (function (){var statearr_9672 = state_9666;
(statearr_9672[(11)] = inst_9614__$1);

return statearr_9672;
})();
if(cljs.core.truth_(inst_9615)){
var statearr_9673_9758 = state_9666__$1;
(statearr_9673_9758[(1)] = (30));

} else {
var statearr_9674_9759 = state_9666__$1;
(statearr_9674_9759[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (1))){
var state_9666__$1 = state_9666;
var statearr_9675_9760 = state_9666__$1;
(statearr_9675_9760[(2)] = null);

(statearr_9675_9760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (24))){
var inst_9567 = (state_9666[(7)]);
var inst_9584 = (state_9666[(2)]);
var inst_9585 = cljs.core.next.call(null,inst_9567);
var inst_9547 = inst_9585;
var inst_9548 = null;
var inst_9549 = (0);
var inst_9550 = (0);
var state_9666__$1 = (function (){var statearr_9676 = state_9666;
(statearr_9676[(13)] = inst_9547);

(statearr_9676[(14)] = inst_9549);

(statearr_9676[(15)] = inst_9550);

(statearr_9676[(16)] = inst_9548);

(statearr_9676[(17)] = inst_9584);

return statearr_9676;
})();
var statearr_9677_9761 = state_9666__$1;
(statearr_9677_9761[(2)] = null);

(statearr_9677_9761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (39))){
var state_9666__$1 = state_9666;
var statearr_9681_9762 = state_9666__$1;
(statearr_9681_9762[(2)] = null);

(statearr_9681_9762[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (4))){
var inst_9538 = (state_9666[(12)]);
var inst_9538__$1 = (state_9666[(2)]);
var inst_9539 = (inst_9538__$1 == null);
var state_9666__$1 = (function (){var statearr_9682 = state_9666;
(statearr_9682[(12)] = inst_9538__$1);

return statearr_9682;
})();
if(cljs.core.truth_(inst_9539)){
var statearr_9683_9763 = state_9666__$1;
(statearr_9683_9763[(1)] = (5));

} else {
var statearr_9684_9764 = state_9666__$1;
(statearr_9684_9764[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (15))){
var inst_9547 = (state_9666[(13)]);
var inst_9549 = (state_9666[(14)]);
var inst_9550 = (state_9666[(15)]);
var inst_9548 = (state_9666[(16)]);
var inst_9563 = (state_9666[(2)]);
var inst_9564 = (inst_9550 + (1));
var tmp9678 = inst_9547;
var tmp9679 = inst_9549;
var tmp9680 = inst_9548;
var inst_9547__$1 = tmp9678;
var inst_9548__$1 = tmp9680;
var inst_9549__$1 = tmp9679;
var inst_9550__$1 = inst_9564;
var state_9666__$1 = (function (){var statearr_9685 = state_9666;
(statearr_9685[(13)] = inst_9547__$1);

(statearr_9685[(14)] = inst_9549__$1);

(statearr_9685[(18)] = inst_9563);

(statearr_9685[(15)] = inst_9550__$1);

(statearr_9685[(16)] = inst_9548__$1);

return statearr_9685;
})();
var statearr_9686_9765 = state_9666__$1;
(statearr_9686_9765[(2)] = null);

(statearr_9686_9765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (21))){
var inst_9588 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9690_9766 = state_9666__$1;
(statearr_9690_9766[(2)] = inst_9588);

(statearr_9690_9766[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (31))){
var inst_9614 = (state_9666[(11)]);
var inst_9618 = done.call(null,null);
var inst_9619 = cljs.core.async.untap_STAR_.call(null,m,inst_9614);
var state_9666__$1 = (function (){var statearr_9691 = state_9666;
(statearr_9691[(19)] = inst_9618);

return statearr_9691;
})();
var statearr_9692_9767 = state_9666__$1;
(statearr_9692_9767[(2)] = inst_9619);

(statearr_9692_9767[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (32))){
var inst_9607 = (state_9666[(9)]);
var inst_9608 = (state_9666[(20)]);
var inst_9609 = (state_9666[(10)]);
var inst_9606 = (state_9666[(21)]);
var inst_9621 = (state_9666[(2)]);
var inst_9622 = (inst_9609 + (1));
var tmp9687 = inst_9607;
var tmp9688 = inst_9608;
var tmp9689 = inst_9606;
var inst_9606__$1 = tmp9689;
var inst_9607__$1 = tmp9687;
var inst_9608__$1 = tmp9688;
var inst_9609__$1 = inst_9622;
var state_9666__$1 = (function (){var statearr_9693 = state_9666;
(statearr_9693[(9)] = inst_9607__$1);

(statearr_9693[(22)] = inst_9621);

(statearr_9693[(20)] = inst_9608__$1);

(statearr_9693[(10)] = inst_9609__$1);

(statearr_9693[(21)] = inst_9606__$1);

return statearr_9693;
})();
var statearr_9694_9768 = state_9666__$1;
(statearr_9694_9768[(2)] = null);

(statearr_9694_9768[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (40))){
var inst_9634 = (state_9666[(23)]);
var inst_9638 = done.call(null,null);
var inst_9639 = cljs.core.async.untap_STAR_.call(null,m,inst_9634);
var state_9666__$1 = (function (){var statearr_9695 = state_9666;
(statearr_9695[(24)] = inst_9638);

return statearr_9695;
})();
var statearr_9696_9769 = state_9666__$1;
(statearr_9696_9769[(2)] = inst_9639);

(statearr_9696_9769[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (33))){
var inst_9625 = (state_9666[(25)]);
var inst_9627 = cljs.core.chunked_seq_QMARK_.call(null,inst_9625);
var state_9666__$1 = state_9666;
if(inst_9627){
var statearr_9697_9770 = state_9666__$1;
(statearr_9697_9770[(1)] = (36));

} else {
var statearr_9698_9771 = state_9666__$1;
(statearr_9698_9771[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (13))){
var inst_9557 = (state_9666[(26)]);
var inst_9560 = cljs.core.async.close_BANG_.call(null,inst_9557);
var state_9666__$1 = state_9666;
var statearr_9699_9772 = state_9666__$1;
(statearr_9699_9772[(2)] = inst_9560);

(statearr_9699_9772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (22))){
var inst_9578 = (state_9666[(8)]);
var inst_9581 = cljs.core.async.close_BANG_.call(null,inst_9578);
var state_9666__$1 = state_9666;
var statearr_9700_9773 = state_9666__$1;
(statearr_9700_9773[(2)] = inst_9581);

(statearr_9700_9773[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (36))){
var inst_9625 = (state_9666[(25)]);
var inst_9629 = cljs.core.chunk_first.call(null,inst_9625);
var inst_9630 = cljs.core.chunk_rest.call(null,inst_9625);
var inst_9631 = cljs.core.count.call(null,inst_9629);
var inst_9606 = inst_9630;
var inst_9607 = inst_9629;
var inst_9608 = inst_9631;
var inst_9609 = (0);
var state_9666__$1 = (function (){var statearr_9701 = state_9666;
(statearr_9701[(9)] = inst_9607);

(statearr_9701[(20)] = inst_9608);

(statearr_9701[(10)] = inst_9609);

(statearr_9701[(21)] = inst_9606);

return statearr_9701;
})();
var statearr_9702_9774 = state_9666__$1;
(statearr_9702_9774[(2)] = null);

(statearr_9702_9774[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (41))){
var inst_9625 = (state_9666[(25)]);
var inst_9641 = (state_9666[(2)]);
var inst_9642 = cljs.core.next.call(null,inst_9625);
var inst_9606 = inst_9642;
var inst_9607 = null;
var inst_9608 = (0);
var inst_9609 = (0);
var state_9666__$1 = (function (){var statearr_9703 = state_9666;
(statearr_9703[(9)] = inst_9607);

(statearr_9703[(27)] = inst_9641);

(statearr_9703[(20)] = inst_9608);

(statearr_9703[(10)] = inst_9609);

(statearr_9703[(21)] = inst_9606);

return statearr_9703;
})();
var statearr_9704_9775 = state_9666__$1;
(statearr_9704_9775[(2)] = null);

(statearr_9704_9775[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (43))){
var state_9666__$1 = state_9666;
var statearr_9705_9776 = state_9666__$1;
(statearr_9705_9776[(2)] = null);

(statearr_9705_9776[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (29))){
var inst_9650 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9706_9777 = state_9666__$1;
(statearr_9706_9777[(2)] = inst_9650);

(statearr_9706_9777[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (44))){
var inst_9659 = (state_9666[(2)]);
var state_9666__$1 = (function (){var statearr_9707 = state_9666;
(statearr_9707[(28)] = inst_9659);

return statearr_9707;
})();
var statearr_9708_9778 = state_9666__$1;
(statearr_9708_9778[(2)] = null);

(statearr_9708_9778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (6))){
var inst_9598 = (state_9666[(29)]);
var inst_9597 = cljs.core.deref.call(null,cs);
var inst_9598__$1 = cljs.core.keys.call(null,inst_9597);
var inst_9599 = cljs.core.count.call(null,inst_9598__$1);
var inst_9600 = cljs.core.reset_BANG_.call(null,dctr,inst_9599);
var inst_9605 = cljs.core.seq.call(null,inst_9598__$1);
var inst_9606 = inst_9605;
var inst_9607 = null;
var inst_9608 = (0);
var inst_9609 = (0);
var state_9666__$1 = (function (){var statearr_9709 = state_9666;
(statearr_9709[(9)] = inst_9607);

(statearr_9709[(20)] = inst_9608);

(statearr_9709[(30)] = inst_9600);

(statearr_9709[(10)] = inst_9609);

(statearr_9709[(29)] = inst_9598__$1);

(statearr_9709[(21)] = inst_9606);

return statearr_9709;
})();
var statearr_9710_9779 = state_9666__$1;
(statearr_9710_9779[(2)] = null);

(statearr_9710_9779[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (28))){
var inst_9625 = (state_9666[(25)]);
var inst_9606 = (state_9666[(21)]);
var inst_9625__$1 = cljs.core.seq.call(null,inst_9606);
var state_9666__$1 = (function (){var statearr_9711 = state_9666;
(statearr_9711[(25)] = inst_9625__$1);

return statearr_9711;
})();
if(inst_9625__$1){
var statearr_9712_9780 = state_9666__$1;
(statearr_9712_9780[(1)] = (33));

} else {
var statearr_9713_9781 = state_9666__$1;
(statearr_9713_9781[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (25))){
var inst_9608 = (state_9666[(20)]);
var inst_9609 = (state_9666[(10)]);
var inst_9611 = (inst_9609 < inst_9608);
var inst_9612 = inst_9611;
var state_9666__$1 = state_9666;
if(cljs.core.truth_(inst_9612)){
var statearr_9714_9782 = state_9666__$1;
(statearr_9714_9782[(1)] = (27));

} else {
var statearr_9715_9783 = state_9666__$1;
(statearr_9715_9783[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (34))){
var state_9666__$1 = state_9666;
var statearr_9716_9784 = state_9666__$1;
(statearr_9716_9784[(2)] = null);

(statearr_9716_9784[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (17))){
var state_9666__$1 = state_9666;
var statearr_9717_9785 = state_9666__$1;
(statearr_9717_9785[(2)] = null);

(statearr_9717_9785[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (3))){
var inst_9664 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9666__$1,inst_9664);
} else {
if((state_val_9667 === (12))){
var inst_9593 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9718_9786 = state_9666__$1;
(statearr_9718_9786[(2)] = inst_9593);

(statearr_9718_9786[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (2))){
var state_9666__$1 = state_9666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9666__$1,(4),ch);
} else {
if((state_val_9667 === (23))){
var state_9666__$1 = state_9666;
var statearr_9719_9787 = state_9666__$1;
(statearr_9719_9787[(2)] = null);

(statearr_9719_9787[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (35))){
var inst_9648 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9720_9788 = state_9666__$1;
(statearr_9720_9788[(2)] = inst_9648);

(statearr_9720_9788[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (19))){
var inst_9567 = (state_9666[(7)]);
var inst_9571 = cljs.core.chunk_first.call(null,inst_9567);
var inst_9572 = cljs.core.chunk_rest.call(null,inst_9567);
var inst_9573 = cljs.core.count.call(null,inst_9571);
var inst_9547 = inst_9572;
var inst_9548 = inst_9571;
var inst_9549 = inst_9573;
var inst_9550 = (0);
var state_9666__$1 = (function (){var statearr_9721 = state_9666;
(statearr_9721[(13)] = inst_9547);

(statearr_9721[(14)] = inst_9549);

(statearr_9721[(15)] = inst_9550);

(statearr_9721[(16)] = inst_9548);

return statearr_9721;
})();
var statearr_9722_9789 = state_9666__$1;
(statearr_9722_9789[(2)] = null);

(statearr_9722_9789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (11))){
var inst_9547 = (state_9666[(13)]);
var inst_9567 = (state_9666[(7)]);
var inst_9567__$1 = cljs.core.seq.call(null,inst_9547);
var state_9666__$1 = (function (){var statearr_9723 = state_9666;
(statearr_9723[(7)] = inst_9567__$1);

return statearr_9723;
})();
if(inst_9567__$1){
var statearr_9724_9790 = state_9666__$1;
(statearr_9724_9790[(1)] = (16));

} else {
var statearr_9725_9791 = state_9666__$1;
(statearr_9725_9791[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (9))){
var inst_9595 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9726_9792 = state_9666__$1;
(statearr_9726_9792[(2)] = inst_9595);

(statearr_9726_9792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (5))){
var inst_9545 = cljs.core.deref.call(null,cs);
var inst_9546 = cljs.core.seq.call(null,inst_9545);
var inst_9547 = inst_9546;
var inst_9548 = null;
var inst_9549 = (0);
var inst_9550 = (0);
var state_9666__$1 = (function (){var statearr_9727 = state_9666;
(statearr_9727[(13)] = inst_9547);

(statearr_9727[(14)] = inst_9549);

(statearr_9727[(15)] = inst_9550);

(statearr_9727[(16)] = inst_9548);

return statearr_9727;
})();
var statearr_9728_9793 = state_9666__$1;
(statearr_9728_9793[(2)] = null);

(statearr_9728_9793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (14))){
var state_9666__$1 = state_9666;
var statearr_9729_9794 = state_9666__$1;
(statearr_9729_9794[(2)] = null);

(statearr_9729_9794[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (45))){
var inst_9656 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9730_9795 = state_9666__$1;
(statearr_9730_9795[(2)] = inst_9656);

(statearr_9730_9795[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (26))){
var inst_9598 = (state_9666[(29)]);
var inst_9652 = (state_9666[(2)]);
var inst_9653 = cljs.core.seq.call(null,inst_9598);
var state_9666__$1 = (function (){var statearr_9731 = state_9666;
(statearr_9731[(31)] = inst_9652);

return statearr_9731;
})();
if(inst_9653){
var statearr_9732_9796 = state_9666__$1;
(statearr_9732_9796[(1)] = (42));

} else {
var statearr_9733_9797 = state_9666__$1;
(statearr_9733_9797[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (16))){
var inst_9567 = (state_9666[(7)]);
var inst_9569 = cljs.core.chunked_seq_QMARK_.call(null,inst_9567);
var state_9666__$1 = state_9666;
if(inst_9569){
var statearr_9734_9798 = state_9666__$1;
(statearr_9734_9798[(1)] = (19));

} else {
var statearr_9735_9799 = state_9666__$1;
(statearr_9735_9799[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (38))){
var inst_9645 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9736_9800 = state_9666__$1;
(statearr_9736_9800[(2)] = inst_9645);

(statearr_9736_9800[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (30))){
var state_9666__$1 = state_9666;
var statearr_9737_9801 = state_9666__$1;
(statearr_9737_9801[(2)] = null);

(statearr_9737_9801[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (10))){
var inst_9550 = (state_9666[(15)]);
var inst_9548 = (state_9666[(16)]);
var inst_9556 = cljs.core._nth.call(null,inst_9548,inst_9550);
var inst_9557 = cljs.core.nth.call(null,inst_9556,(0),null);
var inst_9558 = cljs.core.nth.call(null,inst_9556,(1),null);
var state_9666__$1 = (function (){var statearr_9738 = state_9666;
(statearr_9738[(26)] = inst_9557);

return statearr_9738;
})();
if(cljs.core.truth_(inst_9558)){
var statearr_9739_9802 = state_9666__$1;
(statearr_9739_9802[(1)] = (13));

} else {
var statearr_9740_9803 = state_9666__$1;
(statearr_9740_9803[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (18))){
var inst_9591 = (state_9666[(2)]);
var state_9666__$1 = state_9666;
var statearr_9741_9804 = state_9666__$1;
(statearr_9741_9804[(2)] = inst_9591);

(statearr_9741_9804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (42))){
var state_9666__$1 = state_9666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9666__$1,(45),dchan);
} else {
if((state_val_9667 === (37))){
var inst_9625 = (state_9666[(25)]);
var inst_9634 = (state_9666[(23)]);
var inst_9538 = (state_9666[(12)]);
var inst_9634__$1 = cljs.core.first.call(null,inst_9625);
var inst_9635 = cljs.core.async.put_BANG_.call(null,inst_9634__$1,inst_9538,done);
var state_9666__$1 = (function (){var statearr_9742 = state_9666;
(statearr_9742[(23)] = inst_9634__$1);

return statearr_9742;
})();
if(cljs.core.truth_(inst_9635)){
var statearr_9743_9805 = state_9666__$1;
(statearr_9743_9805[(1)] = (39));

} else {
var statearr_9744_9806 = state_9666__$1;
(statearr_9744_9806[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9667 === (8))){
var inst_9549 = (state_9666[(14)]);
var inst_9550 = (state_9666[(15)]);
var inst_9552 = (inst_9550 < inst_9549);
var inst_9553 = inst_9552;
var state_9666__$1 = state_9666;
if(cljs.core.truth_(inst_9553)){
var statearr_9745_9807 = state_9666__$1;
(statearr_9745_9807[(1)] = (10));

} else {
var statearr_9746_9808 = state_9666__$1;
(statearr_9746_9808[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___9754,cs,m,dchan,dctr,done))
;
return ((function (switch__8335__auto__,c__8447__auto___9754,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8336__auto__ = null;
var cljs$core$async$mult_$_state_machine__8336__auto____0 = (function (){
var statearr_9750 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9750[(0)] = cljs$core$async$mult_$_state_machine__8336__auto__);

(statearr_9750[(1)] = (1));

return statearr_9750;
});
var cljs$core$async$mult_$_state_machine__8336__auto____1 = (function (state_9666){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_9666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e9751){if((e9751 instanceof Object)){
var ex__8339__auto__ = e9751;
var statearr_9752_9809 = state_9666;
(statearr_9752_9809[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9666);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9751;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9810 = state_9666;
state_9666 = G__9810;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8336__auto__ = function(state_9666){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8336__auto____1.call(this,state_9666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8336__auto____0;
cljs$core$async$mult_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8336__auto____1;
return cljs$core$async$mult_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___9754,cs,m,dchan,dctr,done))
})();
var state__8449__auto__ = (function (){var statearr_9753 = f__8448__auto__.call(null);
(statearr_9753[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___9754);

return statearr_9753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___9754,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args9811 = [];
var len__5726__auto___9814 = arguments.length;
var i__5727__auto___9815 = (0);
while(true){
if((i__5727__auto___9815 < len__5726__auto___9814)){
args9811.push((arguments[i__5727__auto___9815]));

var G__9816 = (i__5727__auto___9815 + (1));
i__5727__auto___9815 = G__9816;
continue;
} else {
}
break;
}

var G__9813 = args9811.length;
switch (G__9813) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9811.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___9828 = arguments.length;
var i__5727__auto___9829 = (0);
while(true){
if((i__5727__auto___9829 < len__5726__auto___9828)){
args__5733__auto__.push((arguments[i__5727__auto___9829]));

var G__9830 = (i__5727__auto___9829 + (1));
i__5727__auto___9829 = G__9830;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__9822){
var map__9823 = p__9822;
var map__9823__$1 = ((((!((map__9823 == null)))?((((map__9823.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9823.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9823):map__9823);
var opts = map__9823__$1;
var statearr_9825_9831 = state;
(statearr_9825_9831[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__9823,map__9823__$1,opts){
return (function (val){
var statearr_9826_9832 = state;
(statearr_9826_9832[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__9823,map__9823__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_9827_9833 = state;
(statearr_9827_9833[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq9818){
var G__9819 = cljs.core.first.call(null,seq9818);
var seq9818__$1 = cljs.core.next.call(null,seq9818);
var G__9820 = cljs.core.first.call(null,seq9818__$1);
var seq9818__$2 = cljs.core.next.call(null,seq9818__$1);
var G__9821 = cljs.core.first.call(null,seq9818__$2);
var seq9818__$3 = cljs.core.next.call(null,seq9818__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9819,G__9820,G__9821,seq9818__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async9997 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9997 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta9998){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta9998 = meta9998;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_9999,meta9998__$1){
var self__ = this;
var _9999__$1 = this;
return (new cljs.core.async.t_cljs$core$async9997(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta9998__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_9999){
var self__ = this;
var _9999__$1 = this;
return self__.meta9998;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta9998","meta9998",926948179,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9997.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9997.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9997";

cljs.core.async.t_cljs$core$async9997.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async9997");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async9997 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async9997(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta9998){
return (new cljs.core.async.t_cljs$core$async9997(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta9998));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async9997(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8447__auto___10160 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___10160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___10160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_10097){
var state_val_10098 = (state_10097[(1)]);
if((state_val_10098 === (7))){
var inst_10015 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
var statearr_10099_10161 = state_10097__$1;
(statearr_10099_10161[(2)] = inst_10015);

(statearr_10099_10161[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (20))){
var inst_10027 = (state_10097[(7)]);
var state_10097__$1 = state_10097;
var statearr_10100_10162 = state_10097__$1;
(statearr_10100_10162[(2)] = inst_10027);

(statearr_10100_10162[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (27))){
var state_10097__$1 = state_10097;
var statearr_10101_10163 = state_10097__$1;
(statearr_10101_10163[(2)] = null);

(statearr_10101_10163[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (1))){
var inst_10003 = (state_10097[(8)]);
var inst_10003__$1 = calc_state.call(null);
var inst_10005 = (inst_10003__$1 == null);
var inst_10006 = cljs.core.not.call(null,inst_10005);
var state_10097__$1 = (function (){var statearr_10102 = state_10097;
(statearr_10102[(8)] = inst_10003__$1);

return statearr_10102;
})();
if(inst_10006){
var statearr_10103_10164 = state_10097__$1;
(statearr_10103_10164[(1)] = (2));

} else {
var statearr_10104_10165 = state_10097__$1;
(statearr_10104_10165[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (24))){
var inst_10071 = (state_10097[(9)]);
var inst_10057 = (state_10097[(10)]);
var inst_10050 = (state_10097[(11)]);
var inst_10071__$1 = inst_10050.call(null,inst_10057);
var state_10097__$1 = (function (){var statearr_10105 = state_10097;
(statearr_10105[(9)] = inst_10071__$1);

return statearr_10105;
})();
if(cljs.core.truth_(inst_10071__$1)){
var statearr_10106_10166 = state_10097__$1;
(statearr_10106_10166[(1)] = (29));

} else {
var statearr_10107_10167 = state_10097__$1;
(statearr_10107_10167[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (4))){
var inst_10018 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
if(cljs.core.truth_(inst_10018)){
var statearr_10108_10168 = state_10097__$1;
(statearr_10108_10168[(1)] = (8));

} else {
var statearr_10109_10169 = state_10097__$1;
(statearr_10109_10169[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (15))){
var inst_10044 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
if(cljs.core.truth_(inst_10044)){
var statearr_10110_10170 = state_10097__$1;
(statearr_10110_10170[(1)] = (19));

} else {
var statearr_10111_10171 = state_10097__$1;
(statearr_10111_10171[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (21))){
var inst_10049 = (state_10097[(12)]);
var inst_10049__$1 = (state_10097[(2)]);
var inst_10050 = cljs.core.get.call(null,inst_10049__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_10051 = cljs.core.get.call(null,inst_10049__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_10052 = cljs.core.get.call(null,inst_10049__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_10097__$1 = (function (){var statearr_10112 = state_10097;
(statearr_10112[(13)] = inst_10051);

(statearr_10112[(12)] = inst_10049__$1);

(statearr_10112[(11)] = inst_10050);

return statearr_10112;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_10097__$1,(22),inst_10052);
} else {
if((state_val_10098 === (31))){
var inst_10079 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
if(cljs.core.truth_(inst_10079)){
var statearr_10113_10172 = state_10097__$1;
(statearr_10113_10172[(1)] = (32));

} else {
var statearr_10114_10173 = state_10097__$1;
(statearr_10114_10173[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (32))){
var inst_10056 = (state_10097[(14)]);
var state_10097__$1 = state_10097;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10097__$1,(35),out,inst_10056);
} else {
if((state_val_10098 === (33))){
var inst_10049 = (state_10097[(12)]);
var inst_10027 = inst_10049;
var state_10097__$1 = (function (){var statearr_10115 = state_10097;
(statearr_10115[(7)] = inst_10027);

return statearr_10115;
})();
var statearr_10116_10174 = state_10097__$1;
(statearr_10116_10174[(2)] = null);

(statearr_10116_10174[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (13))){
var inst_10027 = (state_10097[(7)]);
var inst_10034 = inst_10027.cljs$lang$protocol_mask$partition0$;
var inst_10035 = (inst_10034 & (64));
var inst_10036 = inst_10027.cljs$core$ISeq$;
var inst_10037 = (inst_10035) || (inst_10036);
var state_10097__$1 = state_10097;
if(cljs.core.truth_(inst_10037)){
var statearr_10117_10175 = state_10097__$1;
(statearr_10117_10175[(1)] = (16));

} else {
var statearr_10118_10176 = state_10097__$1;
(statearr_10118_10176[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (22))){
var inst_10057 = (state_10097[(10)]);
var inst_10056 = (state_10097[(14)]);
var inst_10055 = (state_10097[(2)]);
var inst_10056__$1 = cljs.core.nth.call(null,inst_10055,(0),null);
var inst_10057__$1 = cljs.core.nth.call(null,inst_10055,(1),null);
var inst_10058 = (inst_10056__$1 == null);
var inst_10059 = cljs.core._EQ_.call(null,inst_10057__$1,change);
var inst_10060 = (inst_10058) || (inst_10059);
var state_10097__$1 = (function (){var statearr_10119 = state_10097;
(statearr_10119[(10)] = inst_10057__$1);

(statearr_10119[(14)] = inst_10056__$1);

return statearr_10119;
})();
if(cljs.core.truth_(inst_10060)){
var statearr_10120_10177 = state_10097__$1;
(statearr_10120_10177[(1)] = (23));

} else {
var statearr_10121_10178 = state_10097__$1;
(statearr_10121_10178[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (36))){
var inst_10049 = (state_10097[(12)]);
var inst_10027 = inst_10049;
var state_10097__$1 = (function (){var statearr_10122 = state_10097;
(statearr_10122[(7)] = inst_10027);

return statearr_10122;
})();
var statearr_10123_10179 = state_10097__$1;
(statearr_10123_10179[(2)] = null);

(statearr_10123_10179[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (29))){
var inst_10071 = (state_10097[(9)]);
var state_10097__$1 = state_10097;
var statearr_10124_10180 = state_10097__$1;
(statearr_10124_10180[(2)] = inst_10071);

(statearr_10124_10180[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (6))){
var state_10097__$1 = state_10097;
var statearr_10125_10181 = state_10097__$1;
(statearr_10125_10181[(2)] = false);

(statearr_10125_10181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (28))){
var inst_10067 = (state_10097[(2)]);
var inst_10068 = calc_state.call(null);
var inst_10027 = inst_10068;
var state_10097__$1 = (function (){var statearr_10126 = state_10097;
(statearr_10126[(7)] = inst_10027);

(statearr_10126[(15)] = inst_10067);

return statearr_10126;
})();
var statearr_10127_10182 = state_10097__$1;
(statearr_10127_10182[(2)] = null);

(statearr_10127_10182[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (25))){
var inst_10093 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
var statearr_10128_10183 = state_10097__$1;
(statearr_10128_10183[(2)] = inst_10093);

(statearr_10128_10183[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (34))){
var inst_10091 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
var statearr_10129_10184 = state_10097__$1;
(statearr_10129_10184[(2)] = inst_10091);

(statearr_10129_10184[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (17))){
var state_10097__$1 = state_10097;
var statearr_10130_10185 = state_10097__$1;
(statearr_10130_10185[(2)] = false);

(statearr_10130_10185[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (3))){
var state_10097__$1 = state_10097;
var statearr_10131_10186 = state_10097__$1;
(statearr_10131_10186[(2)] = false);

(statearr_10131_10186[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (12))){
var inst_10095 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10097__$1,inst_10095);
} else {
if((state_val_10098 === (2))){
var inst_10003 = (state_10097[(8)]);
var inst_10008 = inst_10003.cljs$lang$protocol_mask$partition0$;
var inst_10009 = (inst_10008 & (64));
var inst_10010 = inst_10003.cljs$core$ISeq$;
var inst_10011 = (inst_10009) || (inst_10010);
var state_10097__$1 = state_10097;
if(cljs.core.truth_(inst_10011)){
var statearr_10132_10187 = state_10097__$1;
(statearr_10132_10187[(1)] = (5));

} else {
var statearr_10133_10188 = state_10097__$1;
(statearr_10133_10188[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (23))){
var inst_10056 = (state_10097[(14)]);
var inst_10062 = (inst_10056 == null);
var state_10097__$1 = state_10097;
if(cljs.core.truth_(inst_10062)){
var statearr_10134_10189 = state_10097__$1;
(statearr_10134_10189[(1)] = (26));

} else {
var statearr_10135_10190 = state_10097__$1;
(statearr_10135_10190[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (35))){
var inst_10082 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
if(cljs.core.truth_(inst_10082)){
var statearr_10136_10191 = state_10097__$1;
(statearr_10136_10191[(1)] = (36));

} else {
var statearr_10137_10192 = state_10097__$1;
(statearr_10137_10192[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (19))){
var inst_10027 = (state_10097[(7)]);
var inst_10046 = cljs.core.apply.call(null,cljs.core.hash_map,inst_10027);
var state_10097__$1 = state_10097;
var statearr_10138_10193 = state_10097__$1;
(statearr_10138_10193[(2)] = inst_10046);

(statearr_10138_10193[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (11))){
var inst_10027 = (state_10097[(7)]);
var inst_10031 = (inst_10027 == null);
var inst_10032 = cljs.core.not.call(null,inst_10031);
var state_10097__$1 = state_10097;
if(inst_10032){
var statearr_10139_10194 = state_10097__$1;
(statearr_10139_10194[(1)] = (13));

} else {
var statearr_10140_10195 = state_10097__$1;
(statearr_10140_10195[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (9))){
var inst_10003 = (state_10097[(8)]);
var state_10097__$1 = state_10097;
var statearr_10141_10196 = state_10097__$1;
(statearr_10141_10196[(2)] = inst_10003);

(statearr_10141_10196[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (5))){
var state_10097__$1 = state_10097;
var statearr_10142_10197 = state_10097__$1;
(statearr_10142_10197[(2)] = true);

(statearr_10142_10197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (14))){
var state_10097__$1 = state_10097;
var statearr_10143_10198 = state_10097__$1;
(statearr_10143_10198[(2)] = false);

(statearr_10143_10198[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (26))){
var inst_10057 = (state_10097[(10)]);
var inst_10064 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_10057);
var state_10097__$1 = state_10097;
var statearr_10144_10199 = state_10097__$1;
(statearr_10144_10199[(2)] = inst_10064);

(statearr_10144_10199[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (16))){
var state_10097__$1 = state_10097;
var statearr_10145_10200 = state_10097__$1;
(statearr_10145_10200[(2)] = true);

(statearr_10145_10200[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (38))){
var inst_10087 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
var statearr_10146_10201 = state_10097__$1;
(statearr_10146_10201[(2)] = inst_10087);

(statearr_10146_10201[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (30))){
var inst_10057 = (state_10097[(10)]);
var inst_10051 = (state_10097[(13)]);
var inst_10050 = (state_10097[(11)]);
var inst_10074 = cljs.core.empty_QMARK_.call(null,inst_10050);
var inst_10075 = inst_10051.call(null,inst_10057);
var inst_10076 = cljs.core.not.call(null,inst_10075);
var inst_10077 = (inst_10074) && (inst_10076);
var state_10097__$1 = state_10097;
var statearr_10147_10202 = state_10097__$1;
(statearr_10147_10202[(2)] = inst_10077);

(statearr_10147_10202[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (10))){
var inst_10003 = (state_10097[(8)]);
var inst_10023 = (state_10097[(2)]);
var inst_10024 = cljs.core.get.call(null,inst_10023,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_10025 = cljs.core.get.call(null,inst_10023,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_10026 = cljs.core.get.call(null,inst_10023,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_10027 = inst_10003;
var state_10097__$1 = (function (){var statearr_10148 = state_10097;
(statearr_10148[(7)] = inst_10027);

(statearr_10148[(16)] = inst_10024);

(statearr_10148[(17)] = inst_10026);

(statearr_10148[(18)] = inst_10025);

return statearr_10148;
})();
var statearr_10149_10203 = state_10097__$1;
(statearr_10149_10203[(2)] = null);

(statearr_10149_10203[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (18))){
var inst_10041 = (state_10097[(2)]);
var state_10097__$1 = state_10097;
var statearr_10150_10204 = state_10097__$1;
(statearr_10150_10204[(2)] = inst_10041);

(statearr_10150_10204[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (37))){
var state_10097__$1 = state_10097;
var statearr_10151_10205 = state_10097__$1;
(statearr_10151_10205[(2)] = null);

(statearr_10151_10205[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10098 === (8))){
var inst_10003 = (state_10097[(8)]);
var inst_10020 = cljs.core.apply.call(null,cljs.core.hash_map,inst_10003);
var state_10097__$1 = state_10097;
var statearr_10152_10206 = state_10097__$1;
(statearr_10152_10206[(2)] = inst_10020);

(statearr_10152_10206[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___10160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8335__auto__,c__8447__auto___10160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8336__auto__ = null;
var cljs$core$async$mix_$_state_machine__8336__auto____0 = (function (){
var statearr_10156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10156[(0)] = cljs$core$async$mix_$_state_machine__8336__auto__);

(statearr_10156[(1)] = (1));

return statearr_10156;
});
var cljs$core$async$mix_$_state_machine__8336__auto____1 = (function (state_10097){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_10097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e10157){if((e10157 instanceof Object)){
var ex__8339__auto__ = e10157;
var statearr_10158_10207 = state_10097;
(statearr_10158_10207[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10097);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10157;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10208 = state_10097;
state_10097 = G__10208;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8336__auto__ = function(state_10097){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8336__auto____1.call(this,state_10097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8336__auto____0;
cljs$core$async$mix_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8336__auto____1;
return cljs$core$async$mix_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___10160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8449__auto__ = (function (){var statearr_10159 = f__8448__auto__.call(null);
(statearr_10159[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___10160);

return statearr_10159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___10160,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args10209 = [];
var len__5726__auto___10212 = arguments.length;
var i__5727__auto___10213 = (0);
while(true){
if((i__5727__auto___10213 < len__5726__auto___10212)){
args10209.push((arguments[i__5727__auto___10213]));

var G__10214 = (i__5727__auto___10213 + (1));
i__5727__auto___10213 = G__10214;
continue;
} else {
}
break;
}

var G__10211 = args10209.length;
switch (G__10211) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10209.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args10217 = [];
var len__5726__auto___10342 = arguments.length;
var i__5727__auto___10343 = (0);
while(true){
if((i__5727__auto___10343 < len__5726__auto___10342)){
args10217.push((arguments[i__5727__auto___10343]));

var G__10344 = (i__5727__auto___10343 + (1));
i__5727__auto___10343 = G__10344;
continue;
} else {
}
break;
}

var G__10219 = args10217.length;
switch (G__10219) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10217.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__10216_SHARP_){
if(cljs.core.truth_(p1__10216_SHARP_.call(null,topic))){
return p1__10216_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__10216_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async10220 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10220 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta10221){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta10221 = meta10221;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_10222,meta10221__$1){
var self__ = this;
var _10222__$1 = this;
return (new cljs.core.async.t_cljs$core$async10220(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta10221__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_10222){
var self__ = this;
var _10222__$1 = this;
return self__.meta10221;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10220.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10220.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta10221","meta10221",1434999426,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10220.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10220.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10220";

cljs.core.async.t_cljs$core$async10220.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10220");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async10220 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async10220(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta10221){
return (new cljs.core.async.t_cljs$core$async10220(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta10221));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async10220(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8447__auto___10346 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___10346,mults,ensure_mult,p){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___10346,mults,ensure_mult,p){
return (function (state_10294){
var state_val_10295 = (state_10294[(1)]);
if((state_val_10295 === (7))){
var inst_10290 = (state_10294[(2)]);
var state_10294__$1 = state_10294;
var statearr_10296_10347 = state_10294__$1;
(statearr_10296_10347[(2)] = inst_10290);

(statearr_10296_10347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (20))){
var state_10294__$1 = state_10294;
var statearr_10297_10348 = state_10294__$1;
(statearr_10297_10348[(2)] = null);

(statearr_10297_10348[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (1))){
var state_10294__$1 = state_10294;
var statearr_10298_10349 = state_10294__$1;
(statearr_10298_10349[(2)] = null);

(statearr_10298_10349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (24))){
var inst_10273 = (state_10294[(7)]);
var inst_10282 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_10273);
var state_10294__$1 = state_10294;
var statearr_10299_10350 = state_10294__$1;
(statearr_10299_10350[(2)] = inst_10282);

(statearr_10299_10350[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (4))){
var inst_10225 = (state_10294[(8)]);
var inst_10225__$1 = (state_10294[(2)]);
var inst_10226 = (inst_10225__$1 == null);
var state_10294__$1 = (function (){var statearr_10300 = state_10294;
(statearr_10300[(8)] = inst_10225__$1);

return statearr_10300;
})();
if(cljs.core.truth_(inst_10226)){
var statearr_10301_10351 = state_10294__$1;
(statearr_10301_10351[(1)] = (5));

} else {
var statearr_10302_10352 = state_10294__$1;
(statearr_10302_10352[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (15))){
var inst_10267 = (state_10294[(2)]);
var state_10294__$1 = state_10294;
var statearr_10303_10353 = state_10294__$1;
(statearr_10303_10353[(2)] = inst_10267);

(statearr_10303_10353[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (21))){
var inst_10287 = (state_10294[(2)]);
var state_10294__$1 = (function (){var statearr_10304 = state_10294;
(statearr_10304[(9)] = inst_10287);

return statearr_10304;
})();
var statearr_10305_10354 = state_10294__$1;
(statearr_10305_10354[(2)] = null);

(statearr_10305_10354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (13))){
var inst_10249 = (state_10294[(10)]);
var inst_10251 = cljs.core.chunked_seq_QMARK_.call(null,inst_10249);
var state_10294__$1 = state_10294;
if(inst_10251){
var statearr_10306_10355 = state_10294__$1;
(statearr_10306_10355[(1)] = (16));

} else {
var statearr_10307_10356 = state_10294__$1;
(statearr_10307_10356[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (22))){
var inst_10279 = (state_10294[(2)]);
var state_10294__$1 = state_10294;
if(cljs.core.truth_(inst_10279)){
var statearr_10308_10357 = state_10294__$1;
(statearr_10308_10357[(1)] = (23));

} else {
var statearr_10309_10358 = state_10294__$1;
(statearr_10309_10358[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (6))){
var inst_10225 = (state_10294[(8)]);
var inst_10273 = (state_10294[(7)]);
var inst_10275 = (state_10294[(11)]);
var inst_10273__$1 = topic_fn.call(null,inst_10225);
var inst_10274 = cljs.core.deref.call(null,mults);
var inst_10275__$1 = cljs.core.get.call(null,inst_10274,inst_10273__$1);
var state_10294__$1 = (function (){var statearr_10310 = state_10294;
(statearr_10310[(7)] = inst_10273__$1);

(statearr_10310[(11)] = inst_10275__$1);

return statearr_10310;
})();
if(cljs.core.truth_(inst_10275__$1)){
var statearr_10311_10359 = state_10294__$1;
(statearr_10311_10359[(1)] = (19));

} else {
var statearr_10312_10360 = state_10294__$1;
(statearr_10312_10360[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (25))){
var inst_10284 = (state_10294[(2)]);
var state_10294__$1 = state_10294;
var statearr_10313_10361 = state_10294__$1;
(statearr_10313_10361[(2)] = inst_10284);

(statearr_10313_10361[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (17))){
var inst_10249 = (state_10294[(10)]);
var inst_10258 = cljs.core.first.call(null,inst_10249);
var inst_10259 = cljs.core.async.muxch_STAR_.call(null,inst_10258);
var inst_10260 = cljs.core.async.close_BANG_.call(null,inst_10259);
var inst_10261 = cljs.core.next.call(null,inst_10249);
var inst_10235 = inst_10261;
var inst_10236 = null;
var inst_10237 = (0);
var inst_10238 = (0);
var state_10294__$1 = (function (){var statearr_10314 = state_10294;
(statearr_10314[(12)] = inst_10236);

(statearr_10314[(13)] = inst_10238);

(statearr_10314[(14)] = inst_10260);

(statearr_10314[(15)] = inst_10235);

(statearr_10314[(16)] = inst_10237);

return statearr_10314;
})();
var statearr_10315_10362 = state_10294__$1;
(statearr_10315_10362[(2)] = null);

(statearr_10315_10362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (3))){
var inst_10292 = (state_10294[(2)]);
var state_10294__$1 = state_10294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10294__$1,inst_10292);
} else {
if((state_val_10295 === (12))){
var inst_10269 = (state_10294[(2)]);
var state_10294__$1 = state_10294;
var statearr_10316_10363 = state_10294__$1;
(statearr_10316_10363[(2)] = inst_10269);

(statearr_10316_10363[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (2))){
var state_10294__$1 = state_10294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10294__$1,(4),ch);
} else {
if((state_val_10295 === (23))){
var state_10294__$1 = state_10294;
var statearr_10317_10364 = state_10294__$1;
(statearr_10317_10364[(2)] = null);

(statearr_10317_10364[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (19))){
var inst_10225 = (state_10294[(8)]);
var inst_10275 = (state_10294[(11)]);
var inst_10277 = cljs.core.async.muxch_STAR_.call(null,inst_10275);
var state_10294__$1 = state_10294;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10294__$1,(22),inst_10277,inst_10225);
} else {
if((state_val_10295 === (11))){
var inst_10249 = (state_10294[(10)]);
var inst_10235 = (state_10294[(15)]);
var inst_10249__$1 = cljs.core.seq.call(null,inst_10235);
var state_10294__$1 = (function (){var statearr_10318 = state_10294;
(statearr_10318[(10)] = inst_10249__$1);

return statearr_10318;
})();
if(inst_10249__$1){
var statearr_10319_10365 = state_10294__$1;
(statearr_10319_10365[(1)] = (13));

} else {
var statearr_10320_10366 = state_10294__$1;
(statearr_10320_10366[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (9))){
var inst_10271 = (state_10294[(2)]);
var state_10294__$1 = state_10294;
var statearr_10321_10367 = state_10294__$1;
(statearr_10321_10367[(2)] = inst_10271);

(statearr_10321_10367[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (5))){
var inst_10232 = cljs.core.deref.call(null,mults);
var inst_10233 = cljs.core.vals.call(null,inst_10232);
var inst_10234 = cljs.core.seq.call(null,inst_10233);
var inst_10235 = inst_10234;
var inst_10236 = null;
var inst_10237 = (0);
var inst_10238 = (0);
var state_10294__$1 = (function (){var statearr_10322 = state_10294;
(statearr_10322[(12)] = inst_10236);

(statearr_10322[(13)] = inst_10238);

(statearr_10322[(15)] = inst_10235);

(statearr_10322[(16)] = inst_10237);

return statearr_10322;
})();
var statearr_10323_10368 = state_10294__$1;
(statearr_10323_10368[(2)] = null);

(statearr_10323_10368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (14))){
var state_10294__$1 = state_10294;
var statearr_10327_10369 = state_10294__$1;
(statearr_10327_10369[(2)] = null);

(statearr_10327_10369[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (16))){
var inst_10249 = (state_10294[(10)]);
var inst_10253 = cljs.core.chunk_first.call(null,inst_10249);
var inst_10254 = cljs.core.chunk_rest.call(null,inst_10249);
var inst_10255 = cljs.core.count.call(null,inst_10253);
var inst_10235 = inst_10254;
var inst_10236 = inst_10253;
var inst_10237 = inst_10255;
var inst_10238 = (0);
var state_10294__$1 = (function (){var statearr_10328 = state_10294;
(statearr_10328[(12)] = inst_10236);

(statearr_10328[(13)] = inst_10238);

(statearr_10328[(15)] = inst_10235);

(statearr_10328[(16)] = inst_10237);

return statearr_10328;
})();
var statearr_10329_10370 = state_10294__$1;
(statearr_10329_10370[(2)] = null);

(statearr_10329_10370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (10))){
var inst_10236 = (state_10294[(12)]);
var inst_10238 = (state_10294[(13)]);
var inst_10235 = (state_10294[(15)]);
var inst_10237 = (state_10294[(16)]);
var inst_10243 = cljs.core._nth.call(null,inst_10236,inst_10238);
var inst_10244 = cljs.core.async.muxch_STAR_.call(null,inst_10243);
var inst_10245 = cljs.core.async.close_BANG_.call(null,inst_10244);
var inst_10246 = (inst_10238 + (1));
var tmp10324 = inst_10236;
var tmp10325 = inst_10235;
var tmp10326 = inst_10237;
var inst_10235__$1 = tmp10325;
var inst_10236__$1 = tmp10324;
var inst_10237__$1 = tmp10326;
var inst_10238__$1 = inst_10246;
var state_10294__$1 = (function (){var statearr_10330 = state_10294;
(statearr_10330[(12)] = inst_10236__$1);

(statearr_10330[(13)] = inst_10238__$1);

(statearr_10330[(17)] = inst_10245);

(statearr_10330[(15)] = inst_10235__$1);

(statearr_10330[(16)] = inst_10237__$1);

return statearr_10330;
})();
var statearr_10331_10371 = state_10294__$1;
(statearr_10331_10371[(2)] = null);

(statearr_10331_10371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (18))){
var inst_10264 = (state_10294[(2)]);
var state_10294__$1 = state_10294;
var statearr_10332_10372 = state_10294__$1;
(statearr_10332_10372[(2)] = inst_10264);

(statearr_10332_10372[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10295 === (8))){
var inst_10238 = (state_10294[(13)]);
var inst_10237 = (state_10294[(16)]);
var inst_10240 = (inst_10238 < inst_10237);
var inst_10241 = inst_10240;
var state_10294__$1 = state_10294;
if(cljs.core.truth_(inst_10241)){
var statearr_10333_10373 = state_10294__$1;
(statearr_10333_10373[(1)] = (10));

} else {
var statearr_10334_10374 = state_10294__$1;
(statearr_10334_10374[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___10346,mults,ensure_mult,p))
;
return ((function (switch__8335__auto__,c__8447__auto___10346,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_10338 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10338[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_10338[(1)] = (1));

return statearr_10338;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_10294){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_10294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e10339){if((e10339 instanceof Object)){
var ex__8339__auto__ = e10339;
var statearr_10340_10375 = state_10294;
(statearr_10340_10375[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10294);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10339;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10376 = state_10294;
state_10294 = G__10376;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_10294){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_10294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___10346,mults,ensure_mult,p))
})();
var state__8449__auto__ = (function (){var statearr_10341 = f__8448__auto__.call(null);
(statearr_10341[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___10346);

return statearr_10341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___10346,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args10377 = [];
var len__5726__auto___10380 = arguments.length;
var i__5727__auto___10381 = (0);
while(true){
if((i__5727__auto___10381 < len__5726__auto___10380)){
args10377.push((arguments[i__5727__auto___10381]));

var G__10382 = (i__5727__auto___10381 + (1));
i__5727__auto___10381 = G__10382;
continue;
} else {
}
break;
}

var G__10379 = args10377.length;
switch (G__10379) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10377.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args10384 = [];
var len__5726__auto___10387 = arguments.length;
var i__5727__auto___10388 = (0);
while(true){
if((i__5727__auto___10388 < len__5726__auto___10387)){
args10384.push((arguments[i__5727__auto___10388]));

var G__10389 = (i__5727__auto___10388 + (1));
i__5727__auto___10388 = G__10389;
continue;
} else {
}
break;
}

var G__10386 = args10384.length;
switch (G__10386) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10384.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args10391 = [];
var len__5726__auto___10462 = arguments.length;
var i__5727__auto___10463 = (0);
while(true){
if((i__5727__auto___10463 < len__5726__auto___10462)){
args10391.push((arguments[i__5727__auto___10463]));

var G__10464 = (i__5727__auto___10463 + (1));
i__5727__auto___10463 = G__10464;
continue;
} else {
}
break;
}

var G__10393 = args10391.length;
switch (G__10393) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10391.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8447__auto___10466 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___10466,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___10466,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_10432){
var state_val_10433 = (state_10432[(1)]);
if((state_val_10433 === (7))){
var state_10432__$1 = state_10432;
var statearr_10434_10467 = state_10432__$1;
(statearr_10434_10467[(2)] = null);

(statearr_10434_10467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (1))){
var state_10432__$1 = state_10432;
var statearr_10435_10468 = state_10432__$1;
(statearr_10435_10468[(2)] = null);

(statearr_10435_10468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (4))){
var inst_10396 = (state_10432[(7)]);
var inst_10398 = (inst_10396 < cnt);
var state_10432__$1 = state_10432;
if(cljs.core.truth_(inst_10398)){
var statearr_10436_10469 = state_10432__$1;
(statearr_10436_10469[(1)] = (6));

} else {
var statearr_10437_10470 = state_10432__$1;
(statearr_10437_10470[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (15))){
var inst_10428 = (state_10432[(2)]);
var state_10432__$1 = state_10432;
var statearr_10438_10471 = state_10432__$1;
(statearr_10438_10471[(2)] = inst_10428);

(statearr_10438_10471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (13))){
var inst_10421 = cljs.core.async.close_BANG_.call(null,out);
var state_10432__$1 = state_10432;
var statearr_10439_10472 = state_10432__$1;
(statearr_10439_10472[(2)] = inst_10421);

(statearr_10439_10472[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (6))){
var state_10432__$1 = state_10432;
var statearr_10440_10473 = state_10432__$1;
(statearr_10440_10473[(2)] = null);

(statearr_10440_10473[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (3))){
var inst_10430 = (state_10432[(2)]);
var state_10432__$1 = state_10432;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10432__$1,inst_10430);
} else {
if((state_val_10433 === (12))){
var inst_10418 = (state_10432[(8)]);
var inst_10418__$1 = (state_10432[(2)]);
var inst_10419 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_10418__$1);
var state_10432__$1 = (function (){var statearr_10441 = state_10432;
(statearr_10441[(8)] = inst_10418__$1);

return statearr_10441;
})();
if(cljs.core.truth_(inst_10419)){
var statearr_10442_10474 = state_10432__$1;
(statearr_10442_10474[(1)] = (13));

} else {
var statearr_10443_10475 = state_10432__$1;
(statearr_10443_10475[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (2))){
var inst_10395 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_10396 = (0);
var state_10432__$1 = (function (){var statearr_10444 = state_10432;
(statearr_10444[(9)] = inst_10395);

(statearr_10444[(7)] = inst_10396);

return statearr_10444;
})();
var statearr_10445_10476 = state_10432__$1;
(statearr_10445_10476[(2)] = null);

(statearr_10445_10476[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (11))){
var inst_10396 = (state_10432[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_10432,(10),Object,null,(9));
var inst_10405 = chs__$1.call(null,inst_10396);
var inst_10406 = done.call(null,inst_10396);
var inst_10407 = cljs.core.async.take_BANG_.call(null,inst_10405,inst_10406);
var state_10432__$1 = state_10432;
var statearr_10446_10477 = state_10432__$1;
(statearr_10446_10477[(2)] = inst_10407);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10432__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (9))){
var inst_10396 = (state_10432[(7)]);
var inst_10409 = (state_10432[(2)]);
var inst_10410 = (inst_10396 + (1));
var inst_10396__$1 = inst_10410;
var state_10432__$1 = (function (){var statearr_10447 = state_10432;
(statearr_10447[(7)] = inst_10396__$1);

(statearr_10447[(10)] = inst_10409);

return statearr_10447;
})();
var statearr_10448_10478 = state_10432__$1;
(statearr_10448_10478[(2)] = null);

(statearr_10448_10478[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (5))){
var inst_10416 = (state_10432[(2)]);
var state_10432__$1 = (function (){var statearr_10449 = state_10432;
(statearr_10449[(11)] = inst_10416);

return statearr_10449;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10432__$1,(12),dchan);
} else {
if((state_val_10433 === (14))){
var inst_10418 = (state_10432[(8)]);
var inst_10423 = cljs.core.apply.call(null,f,inst_10418);
var state_10432__$1 = state_10432;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10432__$1,(16),out,inst_10423);
} else {
if((state_val_10433 === (16))){
var inst_10425 = (state_10432[(2)]);
var state_10432__$1 = (function (){var statearr_10450 = state_10432;
(statearr_10450[(12)] = inst_10425);

return statearr_10450;
})();
var statearr_10451_10479 = state_10432__$1;
(statearr_10451_10479[(2)] = null);

(statearr_10451_10479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (10))){
var inst_10400 = (state_10432[(2)]);
var inst_10401 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_10432__$1 = (function (){var statearr_10452 = state_10432;
(statearr_10452[(13)] = inst_10400);

return statearr_10452;
})();
var statearr_10453_10480 = state_10432__$1;
(statearr_10453_10480[(2)] = inst_10401);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10432__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (8))){
var inst_10414 = (state_10432[(2)]);
var state_10432__$1 = state_10432;
var statearr_10454_10481 = state_10432__$1;
(statearr_10454_10481[(2)] = inst_10414);

(statearr_10454_10481[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___10466,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8335__auto__,c__8447__auto___10466,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_10458 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10458[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_10458[(1)] = (1));

return statearr_10458;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_10432){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_10432);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e10459){if((e10459 instanceof Object)){
var ex__8339__auto__ = e10459;
var statearr_10460_10482 = state_10432;
(statearr_10460_10482[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10432);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10459;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10483 = state_10432;
state_10432 = G__10483;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_10432){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_10432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___10466,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8449__auto__ = (function (){var statearr_10461 = f__8448__auto__.call(null);
(statearr_10461[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___10466);

return statearr_10461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___10466,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args10485 = [];
var len__5726__auto___10541 = arguments.length;
var i__5727__auto___10542 = (0);
while(true){
if((i__5727__auto___10542 < len__5726__auto___10541)){
args10485.push((arguments[i__5727__auto___10542]));

var G__10543 = (i__5727__auto___10542 + (1));
i__5727__auto___10542 = G__10543;
continue;
} else {
}
break;
}

var G__10487 = args10485.length;
switch (G__10487) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10485.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___10545 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___10545,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___10545,out){
return (function (state_10517){
var state_val_10518 = (state_10517[(1)]);
if((state_val_10518 === (7))){
var inst_10497 = (state_10517[(7)]);
var inst_10496 = (state_10517[(8)]);
var inst_10496__$1 = (state_10517[(2)]);
var inst_10497__$1 = cljs.core.nth.call(null,inst_10496__$1,(0),null);
var inst_10498 = cljs.core.nth.call(null,inst_10496__$1,(1),null);
var inst_10499 = (inst_10497__$1 == null);
var state_10517__$1 = (function (){var statearr_10519 = state_10517;
(statearr_10519[(7)] = inst_10497__$1);

(statearr_10519[(8)] = inst_10496__$1);

(statearr_10519[(9)] = inst_10498);

return statearr_10519;
})();
if(cljs.core.truth_(inst_10499)){
var statearr_10520_10546 = state_10517__$1;
(statearr_10520_10546[(1)] = (8));

} else {
var statearr_10521_10547 = state_10517__$1;
(statearr_10521_10547[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10518 === (1))){
var inst_10488 = cljs.core.vec.call(null,chs);
var inst_10489 = inst_10488;
var state_10517__$1 = (function (){var statearr_10522 = state_10517;
(statearr_10522[(10)] = inst_10489);

return statearr_10522;
})();
var statearr_10523_10548 = state_10517__$1;
(statearr_10523_10548[(2)] = null);

(statearr_10523_10548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10518 === (4))){
var inst_10489 = (state_10517[(10)]);
var state_10517__$1 = state_10517;
return cljs.core.async.ioc_alts_BANG_.call(null,state_10517__$1,(7),inst_10489);
} else {
if((state_val_10518 === (6))){
var inst_10513 = (state_10517[(2)]);
var state_10517__$1 = state_10517;
var statearr_10524_10549 = state_10517__$1;
(statearr_10524_10549[(2)] = inst_10513);

(statearr_10524_10549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10518 === (3))){
var inst_10515 = (state_10517[(2)]);
var state_10517__$1 = state_10517;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10517__$1,inst_10515);
} else {
if((state_val_10518 === (2))){
var inst_10489 = (state_10517[(10)]);
var inst_10491 = cljs.core.count.call(null,inst_10489);
var inst_10492 = (inst_10491 > (0));
var state_10517__$1 = state_10517;
if(cljs.core.truth_(inst_10492)){
var statearr_10526_10550 = state_10517__$1;
(statearr_10526_10550[(1)] = (4));

} else {
var statearr_10527_10551 = state_10517__$1;
(statearr_10527_10551[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10518 === (11))){
var inst_10489 = (state_10517[(10)]);
var inst_10506 = (state_10517[(2)]);
var tmp10525 = inst_10489;
var inst_10489__$1 = tmp10525;
var state_10517__$1 = (function (){var statearr_10528 = state_10517;
(statearr_10528[(11)] = inst_10506);

(statearr_10528[(10)] = inst_10489__$1);

return statearr_10528;
})();
var statearr_10529_10552 = state_10517__$1;
(statearr_10529_10552[(2)] = null);

(statearr_10529_10552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10518 === (9))){
var inst_10497 = (state_10517[(7)]);
var state_10517__$1 = state_10517;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10517__$1,(11),out,inst_10497);
} else {
if((state_val_10518 === (5))){
var inst_10511 = cljs.core.async.close_BANG_.call(null,out);
var state_10517__$1 = state_10517;
var statearr_10530_10553 = state_10517__$1;
(statearr_10530_10553[(2)] = inst_10511);

(statearr_10530_10553[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10518 === (10))){
var inst_10509 = (state_10517[(2)]);
var state_10517__$1 = state_10517;
var statearr_10531_10554 = state_10517__$1;
(statearr_10531_10554[(2)] = inst_10509);

(statearr_10531_10554[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10518 === (8))){
var inst_10497 = (state_10517[(7)]);
var inst_10496 = (state_10517[(8)]);
var inst_10489 = (state_10517[(10)]);
var inst_10498 = (state_10517[(9)]);
var inst_10501 = (function (){var cs = inst_10489;
var vec__10494 = inst_10496;
var v = inst_10497;
var c = inst_10498;
return ((function (cs,vec__10494,v,c,inst_10497,inst_10496,inst_10489,inst_10498,state_val_10518,c__8447__auto___10545,out){
return (function (p1__10484_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__10484_SHARP_);
});
;})(cs,vec__10494,v,c,inst_10497,inst_10496,inst_10489,inst_10498,state_val_10518,c__8447__auto___10545,out))
})();
var inst_10502 = cljs.core.filterv.call(null,inst_10501,inst_10489);
var inst_10489__$1 = inst_10502;
var state_10517__$1 = (function (){var statearr_10532 = state_10517;
(statearr_10532[(10)] = inst_10489__$1);

return statearr_10532;
})();
var statearr_10533_10555 = state_10517__$1;
(statearr_10533_10555[(2)] = null);

(statearr_10533_10555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___10545,out))
;
return ((function (switch__8335__auto__,c__8447__auto___10545,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_10537 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10537[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_10537[(1)] = (1));

return statearr_10537;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_10517){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_10517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e10538){if((e10538 instanceof Object)){
var ex__8339__auto__ = e10538;
var statearr_10539_10556 = state_10517;
(statearr_10539_10556[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10517);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10538;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10557 = state_10517;
state_10517 = G__10557;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_10517){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_10517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___10545,out))
})();
var state__8449__auto__ = (function (){var statearr_10540 = f__8448__auto__.call(null);
(statearr_10540[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___10545);

return statearr_10540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___10545,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args10558 = [];
var len__5726__auto___10607 = arguments.length;
var i__5727__auto___10608 = (0);
while(true){
if((i__5727__auto___10608 < len__5726__auto___10607)){
args10558.push((arguments[i__5727__auto___10608]));

var G__10609 = (i__5727__auto___10608 + (1));
i__5727__auto___10608 = G__10609;
continue;
} else {
}
break;
}

var G__10560 = args10558.length;
switch (G__10560) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10558.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___10611 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___10611,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___10611,out){
return (function (state_10584){
var state_val_10585 = (state_10584[(1)]);
if((state_val_10585 === (7))){
var inst_10566 = (state_10584[(7)]);
var inst_10566__$1 = (state_10584[(2)]);
var inst_10567 = (inst_10566__$1 == null);
var inst_10568 = cljs.core.not.call(null,inst_10567);
var state_10584__$1 = (function (){var statearr_10586 = state_10584;
(statearr_10586[(7)] = inst_10566__$1);

return statearr_10586;
})();
if(inst_10568){
var statearr_10587_10612 = state_10584__$1;
(statearr_10587_10612[(1)] = (8));

} else {
var statearr_10588_10613 = state_10584__$1;
(statearr_10588_10613[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10585 === (1))){
var inst_10561 = (0);
var state_10584__$1 = (function (){var statearr_10589 = state_10584;
(statearr_10589[(8)] = inst_10561);

return statearr_10589;
})();
var statearr_10590_10614 = state_10584__$1;
(statearr_10590_10614[(2)] = null);

(statearr_10590_10614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10585 === (4))){
var state_10584__$1 = state_10584;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10584__$1,(7),ch);
} else {
if((state_val_10585 === (6))){
var inst_10579 = (state_10584[(2)]);
var state_10584__$1 = state_10584;
var statearr_10591_10615 = state_10584__$1;
(statearr_10591_10615[(2)] = inst_10579);

(statearr_10591_10615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10585 === (3))){
var inst_10581 = (state_10584[(2)]);
var inst_10582 = cljs.core.async.close_BANG_.call(null,out);
var state_10584__$1 = (function (){var statearr_10592 = state_10584;
(statearr_10592[(9)] = inst_10581);

return statearr_10592;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10584__$1,inst_10582);
} else {
if((state_val_10585 === (2))){
var inst_10561 = (state_10584[(8)]);
var inst_10563 = (inst_10561 < n);
var state_10584__$1 = state_10584;
if(cljs.core.truth_(inst_10563)){
var statearr_10593_10616 = state_10584__$1;
(statearr_10593_10616[(1)] = (4));

} else {
var statearr_10594_10617 = state_10584__$1;
(statearr_10594_10617[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10585 === (11))){
var inst_10561 = (state_10584[(8)]);
var inst_10571 = (state_10584[(2)]);
var inst_10572 = (inst_10561 + (1));
var inst_10561__$1 = inst_10572;
var state_10584__$1 = (function (){var statearr_10595 = state_10584;
(statearr_10595[(10)] = inst_10571);

(statearr_10595[(8)] = inst_10561__$1);

return statearr_10595;
})();
var statearr_10596_10618 = state_10584__$1;
(statearr_10596_10618[(2)] = null);

(statearr_10596_10618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10585 === (9))){
var state_10584__$1 = state_10584;
var statearr_10597_10619 = state_10584__$1;
(statearr_10597_10619[(2)] = null);

(statearr_10597_10619[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10585 === (5))){
var state_10584__$1 = state_10584;
var statearr_10598_10620 = state_10584__$1;
(statearr_10598_10620[(2)] = null);

(statearr_10598_10620[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10585 === (10))){
var inst_10576 = (state_10584[(2)]);
var state_10584__$1 = state_10584;
var statearr_10599_10621 = state_10584__$1;
(statearr_10599_10621[(2)] = inst_10576);

(statearr_10599_10621[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10585 === (8))){
var inst_10566 = (state_10584[(7)]);
var state_10584__$1 = state_10584;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10584__$1,(11),out,inst_10566);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___10611,out))
;
return ((function (switch__8335__auto__,c__8447__auto___10611,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_10603 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10603[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_10603[(1)] = (1));

return statearr_10603;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_10584){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_10584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e10604){if((e10604 instanceof Object)){
var ex__8339__auto__ = e10604;
var statearr_10605_10622 = state_10584;
(statearr_10605_10622[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10584);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10604;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10623 = state_10584;
state_10584 = G__10623;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_10584){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_10584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___10611,out))
})();
var state__8449__auto__ = (function (){var statearr_10606 = f__8448__auto__.call(null);
(statearr_10606[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___10611);

return statearr_10606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___10611,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async10631 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10631 = (function (map_LT_,f,ch,meta10632){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta10632 = meta10632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10633,meta10632__$1){
var self__ = this;
var _10633__$1 = this;
return (new cljs.core.async.t_cljs$core$async10631(self__.map_LT_,self__.f,self__.ch,meta10632__$1));
});

cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10633){
var self__ = this;
var _10633__$1 = this;
return self__.meta10632;
});

cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async10634 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10634 = (function (map_LT_,f,ch,meta10632,_,fn1,meta10635){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta10632 = meta10632;
this._ = _;
this.fn1 = fn1;
this.meta10635 = meta10635;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10634.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_10636,meta10635__$1){
var self__ = this;
var _10636__$1 = this;
return (new cljs.core.async.t_cljs$core$async10634(self__.map_LT_,self__.f,self__.ch,self__.meta10632,self__._,self__.fn1,meta10635__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async10634.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_10636){
var self__ = this;
var _10636__$1 = this;
return self__.meta10635;
});})(___$1))
;

cljs.core.async.t_cljs$core$async10634.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async10634.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async10634.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async10634.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__10624_SHARP_){
return f1.call(null,(((p1__10624_SHARP_ == null))?null:self__.f.call(null,p1__10624_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async10634.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10632","meta10632",-1032309141,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async10631","cljs.core.async/t_cljs$core$async10631",1814526042,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta10635","meta10635",223711176,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async10634.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10634.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10634";

cljs.core.async.t_cljs$core$async10634.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10634");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async10634 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10634(map_LT___$1,f__$1,ch__$1,meta10632__$1,___$2,fn1__$1,meta10635){
return (new cljs.core.async.t_cljs$core$async10634(map_LT___$1,f__$1,ch__$1,meta10632__$1,___$2,fn1__$1,meta10635));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async10634(self__.map_LT_,self__.f,self__.ch,self__.meta10632,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async10631.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async10631.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10632","meta10632",-1032309141,null)], null);
});

cljs.core.async.t_cljs$core$async10631.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10631.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10631";

cljs.core.async.t_cljs$core$async10631.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10631");
});

cljs.core.async.__GT_t_cljs$core$async10631 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10631(map_LT___$1,f__$1,ch__$1,meta10632){
return (new cljs.core.async.t_cljs$core$async10631(map_LT___$1,f__$1,ch__$1,meta10632));
});

}

return (new cljs.core.async.t_cljs$core$async10631(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async10640 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10640 = (function (map_GT_,f,ch,meta10641){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta10641 = meta10641;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10640.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10642,meta10641__$1){
var self__ = this;
var _10642__$1 = this;
return (new cljs.core.async.t_cljs$core$async10640(self__.map_GT_,self__.f,self__.ch,meta10641__$1));
});

cljs.core.async.t_cljs$core$async10640.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10642){
var self__ = this;
var _10642__$1 = this;
return self__.meta10641;
});

cljs.core.async.t_cljs$core$async10640.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async10640.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10640.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async10640.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async10640.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async10640.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async10640.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10641","meta10641",-1898188333,null)], null);
});

cljs.core.async.t_cljs$core$async10640.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10640.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10640";

cljs.core.async.t_cljs$core$async10640.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10640");
});

cljs.core.async.__GT_t_cljs$core$async10640 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async10640(map_GT___$1,f__$1,ch__$1,meta10641){
return (new cljs.core.async.t_cljs$core$async10640(map_GT___$1,f__$1,ch__$1,meta10641));
});

}

return (new cljs.core.async.t_cljs$core$async10640(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async10646 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10646 = (function (filter_GT_,p,ch,meta10647){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta10647 = meta10647;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10648,meta10647__$1){
var self__ = this;
var _10648__$1 = this;
return (new cljs.core.async.t_cljs$core$async10646(self__.filter_GT_,self__.p,self__.ch,meta10647__$1));
});

cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10648){
var self__ = this;
var _10648__$1 = this;
return self__.meta10647;
});

cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async10646.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async10646.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10647","meta10647",-242993805,null)], null);
});

cljs.core.async.t_cljs$core$async10646.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10646.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10646";

cljs.core.async.t_cljs$core$async10646.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10646");
});

cljs.core.async.__GT_t_cljs$core$async10646 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async10646(filter_GT___$1,p__$1,ch__$1,meta10647){
return (new cljs.core.async.t_cljs$core$async10646(filter_GT___$1,p__$1,ch__$1,meta10647));
});

}

return (new cljs.core.async.t_cljs$core$async10646(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args10649 = [];
var len__5726__auto___10693 = arguments.length;
var i__5727__auto___10694 = (0);
while(true){
if((i__5727__auto___10694 < len__5726__auto___10693)){
args10649.push((arguments[i__5727__auto___10694]));

var G__10695 = (i__5727__auto___10694 + (1));
i__5727__auto___10694 = G__10695;
continue;
} else {
}
break;
}

var G__10651 = args10649.length;
switch (G__10651) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10649.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___10697 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___10697,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___10697,out){
return (function (state_10672){
var state_val_10673 = (state_10672[(1)]);
if((state_val_10673 === (7))){
var inst_10668 = (state_10672[(2)]);
var state_10672__$1 = state_10672;
var statearr_10674_10698 = state_10672__$1;
(statearr_10674_10698[(2)] = inst_10668);

(statearr_10674_10698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10673 === (1))){
var state_10672__$1 = state_10672;
var statearr_10675_10699 = state_10672__$1;
(statearr_10675_10699[(2)] = null);

(statearr_10675_10699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10673 === (4))){
var inst_10654 = (state_10672[(7)]);
var inst_10654__$1 = (state_10672[(2)]);
var inst_10655 = (inst_10654__$1 == null);
var state_10672__$1 = (function (){var statearr_10676 = state_10672;
(statearr_10676[(7)] = inst_10654__$1);

return statearr_10676;
})();
if(cljs.core.truth_(inst_10655)){
var statearr_10677_10700 = state_10672__$1;
(statearr_10677_10700[(1)] = (5));

} else {
var statearr_10678_10701 = state_10672__$1;
(statearr_10678_10701[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10673 === (6))){
var inst_10654 = (state_10672[(7)]);
var inst_10659 = p.call(null,inst_10654);
var state_10672__$1 = state_10672;
if(cljs.core.truth_(inst_10659)){
var statearr_10679_10702 = state_10672__$1;
(statearr_10679_10702[(1)] = (8));

} else {
var statearr_10680_10703 = state_10672__$1;
(statearr_10680_10703[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10673 === (3))){
var inst_10670 = (state_10672[(2)]);
var state_10672__$1 = state_10672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10672__$1,inst_10670);
} else {
if((state_val_10673 === (2))){
var state_10672__$1 = state_10672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10672__$1,(4),ch);
} else {
if((state_val_10673 === (11))){
var inst_10662 = (state_10672[(2)]);
var state_10672__$1 = state_10672;
var statearr_10681_10704 = state_10672__$1;
(statearr_10681_10704[(2)] = inst_10662);

(statearr_10681_10704[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10673 === (9))){
var state_10672__$1 = state_10672;
var statearr_10682_10705 = state_10672__$1;
(statearr_10682_10705[(2)] = null);

(statearr_10682_10705[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10673 === (5))){
var inst_10657 = cljs.core.async.close_BANG_.call(null,out);
var state_10672__$1 = state_10672;
var statearr_10683_10706 = state_10672__$1;
(statearr_10683_10706[(2)] = inst_10657);

(statearr_10683_10706[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10673 === (10))){
var inst_10665 = (state_10672[(2)]);
var state_10672__$1 = (function (){var statearr_10684 = state_10672;
(statearr_10684[(8)] = inst_10665);

return statearr_10684;
})();
var statearr_10685_10707 = state_10672__$1;
(statearr_10685_10707[(2)] = null);

(statearr_10685_10707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10673 === (8))){
var inst_10654 = (state_10672[(7)]);
var state_10672__$1 = state_10672;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10672__$1,(11),out,inst_10654);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___10697,out))
;
return ((function (switch__8335__auto__,c__8447__auto___10697,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_10689 = [null,null,null,null,null,null,null,null,null];
(statearr_10689[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_10689[(1)] = (1));

return statearr_10689;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_10672){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_10672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e10690){if((e10690 instanceof Object)){
var ex__8339__auto__ = e10690;
var statearr_10691_10708 = state_10672;
(statearr_10691_10708[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10672);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10690;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10709 = state_10672;
state_10672 = G__10709;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_10672){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_10672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___10697,out))
})();
var state__8449__auto__ = (function (){var statearr_10692 = f__8448__auto__.call(null);
(statearr_10692[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___10697);

return statearr_10692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___10697,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args10710 = [];
var len__5726__auto___10713 = arguments.length;
var i__5727__auto___10714 = (0);
while(true){
if((i__5727__auto___10714 < len__5726__auto___10713)){
args10710.push((arguments[i__5727__auto___10714]));

var G__10715 = (i__5727__auto___10714 + (1));
i__5727__auto___10714 = G__10715;
continue;
} else {
}
break;
}

var G__10712 = args10710.length;
switch (G__10712) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10710.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8447__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto__){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto__){
return (function (state_10882){
var state_val_10883 = (state_10882[(1)]);
if((state_val_10883 === (7))){
var inst_10878 = (state_10882[(2)]);
var state_10882__$1 = state_10882;
var statearr_10884_10925 = state_10882__$1;
(statearr_10884_10925[(2)] = inst_10878);

(statearr_10884_10925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (20))){
var inst_10848 = (state_10882[(7)]);
var inst_10859 = (state_10882[(2)]);
var inst_10860 = cljs.core.next.call(null,inst_10848);
var inst_10834 = inst_10860;
var inst_10835 = null;
var inst_10836 = (0);
var inst_10837 = (0);
var state_10882__$1 = (function (){var statearr_10885 = state_10882;
(statearr_10885[(8)] = inst_10835);

(statearr_10885[(9)] = inst_10834);

(statearr_10885[(10)] = inst_10859);

(statearr_10885[(11)] = inst_10836);

(statearr_10885[(12)] = inst_10837);

return statearr_10885;
})();
var statearr_10886_10926 = state_10882__$1;
(statearr_10886_10926[(2)] = null);

(statearr_10886_10926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (1))){
var state_10882__$1 = state_10882;
var statearr_10887_10927 = state_10882__$1;
(statearr_10887_10927[(2)] = null);

(statearr_10887_10927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (4))){
var inst_10823 = (state_10882[(13)]);
var inst_10823__$1 = (state_10882[(2)]);
var inst_10824 = (inst_10823__$1 == null);
var state_10882__$1 = (function (){var statearr_10888 = state_10882;
(statearr_10888[(13)] = inst_10823__$1);

return statearr_10888;
})();
if(cljs.core.truth_(inst_10824)){
var statearr_10889_10928 = state_10882__$1;
(statearr_10889_10928[(1)] = (5));

} else {
var statearr_10890_10929 = state_10882__$1;
(statearr_10890_10929[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (15))){
var state_10882__$1 = state_10882;
var statearr_10894_10930 = state_10882__$1;
(statearr_10894_10930[(2)] = null);

(statearr_10894_10930[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (21))){
var state_10882__$1 = state_10882;
var statearr_10895_10931 = state_10882__$1;
(statearr_10895_10931[(2)] = null);

(statearr_10895_10931[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (13))){
var inst_10835 = (state_10882[(8)]);
var inst_10834 = (state_10882[(9)]);
var inst_10836 = (state_10882[(11)]);
var inst_10837 = (state_10882[(12)]);
var inst_10844 = (state_10882[(2)]);
var inst_10845 = (inst_10837 + (1));
var tmp10891 = inst_10835;
var tmp10892 = inst_10834;
var tmp10893 = inst_10836;
var inst_10834__$1 = tmp10892;
var inst_10835__$1 = tmp10891;
var inst_10836__$1 = tmp10893;
var inst_10837__$1 = inst_10845;
var state_10882__$1 = (function (){var statearr_10896 = state_10882;
(statearr_10896[(8)] = inst_10835__$1);

(statearr_10896[(9)] = inst_10834__$1);

(statearr_10896[(14)] = inst_10844);

(statearr_10896[(11)] = inst_10836__$1);

(statearr_10896[(12)] = inst_10837__$1);

return statearr_10896;
})();
var statearr_10897_10932 = state_10882__$1;
(statearr_10897_10932[(2)] = null);

(statearr_10897_10932[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (22))){
var state_10882__$1 = state_10882;
var statearr_10898_10933 = state_10882__$1;
(statearr_10898_10933[(2)] = null);

(statearr_10898_10933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (6))){
var inst_10823 = (state_10882[(13)]);
var inst_10832 = f.call(null,inst_10823);
var inst_10833 = cljs.core.seq.call(null,inst_10832);
var inst_10834 = inst_10833;
var inst_10835 = null;
var inst_10836 = (0);
var inst_10837 = (0);
var state_10882__$1 = (function (){var statearr_10899 = state_10882;
(statearr_10899[(8)] = inst_10835);

(statearr_10899[(9)] = inst_10834);

(statearr_10899[(11)] = inst_10836);

(statearr_10899[(12)] = inst_10837);

return statearr_10899;
})();
var statearr_10900_10934 = state_10882__$1;
(statearr_10900_10934[(2)] = null);

(statearr_10900_10934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (17))){
var inst_10848 = (state_10882[(7)]);
var inst_10852 = cljs.core.chunk_first.call(null,inst_10848);
var inst_10853 = cljs.core.chunk_rest.call(null,inst_10848);
var inst_10854 = cljs.core.count.call(null,inst_10852);
var inst_10834 = inst_10853;
var inst_10835 = inst_10852;
var inst_10836 = inst_10854;
var inst_10837 = (0);
var state_10882__$1 = (function (){var statearr_10901 = state_10882;
(statearr_10901[(8)] = inst_10835);

(statearr_10901[(9)] = inst_10834);

(statearr_10901[(11)] = inst_10836);

(statearr_10901[(12)] = inst_10837);

return statearr_10901;
})();
var statearr_10902_10935 = state_10882__$1;
(statearr_10902_10935[(2)] = null);

(statearr_10902_10935[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (3))){
var inst_10880 = (state_10882[(2)]);
var state_10882__$1 = state_10882;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10882__$1,inst_10880);
} else {
if((state_val_10883 === (12))){
var inst_10868 = (state_10882[(2)]);
var state_10882__$1 = state_10882;
var statearr_10903_10936 = state_10882__$1;
(statearr_10903_10936[(2)] = inst_10868);

(statearr_10903_10936[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (2))){
var state_10882__$1 = state_10882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10882__$1,(4),in$);
} else {
if((state_val_10883 === (23))){
var inst_10876 = (state_10882[(2)]);
var state_10882__$1 = state_10882;
var statearr_10904_10937 = state_10882__$1;
(statearr_10904_10937[(2)] = inst_10876);

(statearr_10904_10937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (19))){
var inst_10863 = (state_10882[(2)]);
var state_10882__$1 = state_10882;
var statearr_10905_10938 = state_10882__$1;
(statearr_10905_10938[(2)] = inst_10863);

(statearr_10905_10938[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (11))){
var inst_10848 = (state_10882[(7)]);
var inst_10834 = (state_10882[(9)]);
var inst_10848__$1 = cljs.core.seq.call(null,inst_10834);
var state_10882__$1 = (function (){var statearr_10906 = state_10882;
(statearr_10906[(7)] = inst_10848__$1);

return statearr_10906;
})();
if(inst_10848__$1){
var statearr_10907_10939 = state_10882__$1;
(statearr_10907_10939[(1)] = (14));

} else {
var statearr_10908_10940 = state_10882__$1;
(statearr_10908_10940[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (9))){
var inst_10870 = (state_10882[(2)]);
var inst_10871 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_10882__$1 = (function (){var statearr_10909 = state_10882;
(statearr_10909[(15)] = inst_10870);

return statearr_10909;
})();
if(cljs.core.truth_(inst_10871)){
var statearr_10910_10941 = state_10882__$1;
(statearr_10910_10941[(1)] = (21));

} else {
var statearr_10911_10942 = state_10882__$1;
(statearr_10911_10942[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (5))){
var inst_10826 = cljs.core.async.close_BANG_.call(null,out);
var state_10882__$1 = state_10882;
var statearr_10912_10943 = state_10882__$1;
(statearr_10912_10943[(2)] = inst_10826);

(statearr_10912_10943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (14))){
var inst_10848 = (state_10882[(7)]);
var inst_10850 = cljs.core.chunked_seq_QMARK_.call(null,inst_10848);
var state_10882__$1 = state_10882;
if(inst_10850){
var statearr_10913_10944 = state_10882__$1;
(statearr_10913_10944[(1)] = (17));

} else {
var statearr_10914_10945 = state_10882__$1;
(statearr_10914_10945[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (16))){
var inst_10866 = (state_10882[(2)]);
var state_10882__$1 = state_10882;
var statearr_10915_10946 = state_10882__$1;
(statearr_10915_10946[(2)] = inst_10866);

(statearr_10915_10946[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10883 === (10))){
var inst_10835 = (state_10882[(8)]);
var inst_10837 = (state_10882[(12)]);
var inst_10842 = cljs.core._nth.call(null,inst_10835,inst_10837);
var state_10882__$1 = state_10882;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10882__$1,(13),out,inst_10842);
} else {
if((state_val_10883 === (18))){
var inst_10848 = (state_10882[(7)]);
var inst_10857 = cljs.core.first.call(null,inst_10848);
var state_10882__$1 = state_10882;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10882__$1,(20),out,inst_10857);
} else {
if((state_val_10883 === (8))){
var inst_10836 = (state_10882[(11)]);
var inst_10837 = (state_10882[(12)]);
var inst_10839 = (inst_10837 < inst_10836);
var inst_10840 = inst_10839;
var state_10882__$1 = state_10882;
if(cljs.core.truth_(inst_10840)){
var statearr_10916_10947 = state_10882__$1;
(statearr_10916_10947[(1)] = (10));

} else {
var statearr_10917_10948 = state_10882__$1;
(statearr_10917_10948[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto__))
;
return ((function (switch__8335__auto__,c__8447__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_10921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10921[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__);

(statearr_10921[(1)] = (1));

return statearr_10921;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1 = (function (state_10882){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_10882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e10922){if((e10922 instanceof Object)){
var ex__8339__auto__ = e10922;
var statearr_10923_10949 = state_10882;
(statearr_10923_10949[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10882);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10922;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10950 = state_10882;
state_10882 = G__10950;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__ = function(state_10882){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1.call(this,state_10882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto__))
})();
var state__8449__auto__ = (function (){var statearr_10924 = f__8448__auto__.call(null);
(statearr_10924[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto__);

return statearr_10924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto__))
);

return c__8447__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args10951 = [];
var len__5726__auto___10954 = arguments.length;
var i__5727__auto___10955 = (0);
while(true){
if((i__5727__auto___10955 < len__5726__auto___10954)){
args10951.push((arguments[i__5727__auto___10955]));

var G__10956 = (i__5727__auto___10955 + (1));
i__5727__auto___10955 = G__10956;
continue;
} else {
}
break;
}

var G__10953 = args10951.length;
switch (G__10953) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10951.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args10958 = [];
var len__5726__auto___10961 = arguments.length;
var i__5727__auto___10962 = (0);
while(true){
if((i__5727__auto___10962 < len__5726__auto___10961)){
args10958.push((arguments[i__5727__auto___10962]));

var G__10963 = (i__5727__auto___10962 + (1));
i__5727__auto___10962 = G__10963;
continue;
} else {
}
break;
}

var G__10960 = args10958.length;
switch (G__10960) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10958.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args10965 = [];
var len__5726__auto___11016 = arguments.length;
var i__5727__auto___11017 = (0);
while(true){
if((i__5727__auto___11017 < len__5726__auto___11016)){
args10965.push((arguments[i__5727__auto___11017]));

var G__11018 = (i__5727__auto___11017 + (1));
i__5727__auto___11017 = G__11018;
continue;
} else {
}
break;
}

var G__10967 = args10965.length;
switch (G__10967) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10965.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___11020 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___11020,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___11020,out){
return (function (state_10991){
var state_val_10992 = (state_10991[(1)]);
if((state_val_10992 === (7))){
var inst_10986 = (state_10991[(2)]);
var state_10991__$1 = state_10991;
var statearr_10993_11021 = state_10991__$1;
(statearr_10993_11021[(2)] = inst_10986);

(statearr_10993_11021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10992 === (1))){
var inst_10968 = null;
var state_10991__$1 = (function (){var statearr_10994 = state_10991;
(statearr_10994[(7)] = inst_10968);

return statearr_10994;
})();
var statearr_10995_11022 = state_10991__$1;
(statearr_10995_11022[(2)] = null);

(statearr_10995_11022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10992 === (4))){
var inst_10971 = (state_10991[(8)]);
var inst_10971__$1 = (state_10991[(2)]);
var inst_10972 = (inst_10971__$1 == null);
var inst_10973 = cljs.core.not.call(null,inst_10972);
var state_10991__$1 = (function (){var statearr_10996 = state_10991;
(statearr_10996[(8)] = inst_10971__$1);

return statearr_10996;
})();
if(inst_10973){
var statearr_10997_11023 = state_10991__$1;
(statearr_10997_11023[(1)] = (5));

} else {
var statearr_10998_11024 = state_10991__$1;
(statearr_10998_11024[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10992 === (6))){
var state_10991__$1 = state_10991;
var statearr_10999_11025 = state_10991__$1;
(statearr_10999_11025[(2)] = null);

(statearr_10999_11025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10992 === (3))){
var inst_10988 = (state_10991[(2)]);
var inst_10989 = cljs.core.async.close_BANG_.call(null,out);
var state_10991__$1 = (function (){var statearr_11000 = state_10991;
(statearr_11000[(9)] = inst_10988);

return statearr_11000;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10991__$1,inst_10989);
} else {
if((state_val_10992 === (2))){
var state_10991__$1 = state_10991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10991__$1,(4),ch);
} else {
if((state_val_10992 === (11))){
var inst_10971 = (state_10991[(8)]);
var inst_10980 = (state_10991[(2)]);
var inst_10968 = inst_10971;
var state_10991__$1 = (function (){var statearr_11001 = state_10991;
(statearr_11001[(10)] = inst_10980);

(statearr_11001[(7)] = inst_10968);

return statearr_11001;
})();
var statearr_11002_11026 = state_10991__$1;
(statearr_11002_11026[(2)] = null);

(statearr_11002_11026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10992 === (9))){
var inst_10971 = (state_10991[(8)]);
var state_10991__$1 = state_10991;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10991__$1,(11),out,inst_10971);
} else {
if((state_val_10992 === (5))){
var inst_10968 = (state_10991[(7)]);
var inst_10971 = (state_10991[(8)]);
var inst_10975 = cljs.core._EQ_.call(null,inst_10971,inst_10968);
var state_10991__$1 = state_10991;
if(inst_10975){
var statearr_11004_11027 = state_10991__$1;
(statearr_11004_11027[(1)] = (8));

} else {
var statearr_11005_11028 = state_10991__$1;
(statearr_11005_11028[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10992 === (10))){
var inst_10983 = (state_10991[(2)]);
var state_10991__$1 = state_10991;
var statearr_11006_11029 = state_10991__$1;
(statearr_11006_11029[(2)] = inst_10983);

(statearr_11006_11029[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10992 === (8))){
var inst_10968 = (state_10991[(7)]);
var tmp11003 = inst_10968;
var inst_10968__$1 = tmp11003;
var state_10991__$1 = (function (){var statearr_11007 = state_10991;
(statearr_11007[(7)] = inst_10968__$1);

return statearr_11007;
})();
var statearr_11008_11030 = state_10991__$1;
(statearr_11008_11030[(2)] = null);

(statearr_11008_11030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___11020,out))
;
return ((function (switch__8335__auto__,c__8447__auto___11020,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_11012 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11012[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_11012[(1)] = (1));

return statearr_11012;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_10991){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_10991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e11013){if((e11013 instanceof Object)){
var ex__8339__auto__ = e11013;
var statearr_11014_11031 = state_10991;
(statearr_11014_11031[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10991);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11032 = state_10991;
state_10991 = G__11032;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_10991){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_10991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___11020,out))
})();
var state__8449__auto__ = (function (){var statearr_11015 = f__8448__auto__.call(null);
(statearr_11015[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___11020);

return statearr_11015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___11020,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args11033 = [];
var len__5726__auto___11103 = arguments.length;
var i__5727__auto___11104 = (0);
while(true){
if((i__5727__auto___11104 < len__5726__auto___11103)){
args11033.push((arguments[i__5727__auto___11104]));

var G__11105 = (i__5727__auto___11104 + (1));
i__5727__auto___11104 = G__11105;
continue;
} else {
}
break;
}

var G__11035 = args11033.length;
switch (G__11035) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11033.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___11107 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___11107,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___11107,out){
return (function (state_11073){
var state_val_11074 = (state_11073[(1)]);
if((state_val_11074 === (7))){
var inst_11069 = (state_11073[(2)]);
var state_11073__$1 = state_11073;
var statearr_11075_11108 = state_11073__$1;
(statearr_11075_11108[(2)] = inst_11069);

(statearr_11075_11108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (1))){
var inst_11036 = (new Array(n));
var inst_11037 = inst_11036;
var inst_11038 = (0);
var state_11073__$1 = (function (){var statearr_11076 = state_11073;
(statearr_11076[(7)] = inst_11037);

(statearr_11076[(8)] = inst_11038);

return statearr_11076;
})();
var statearr_11077_11109 = state_11073__$1;
(statearr_11077_11109[(2)] = null);

(statearr_11077_11109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (4))){
var inst_11041 = (state_11073[(9)]);
var inst_11041__$1 = (state_11073[(2)]);
var inst_11042 = (inst_11041__$1 == null);
var inst_11043 = cljs.core.not.call(null,inst_11042);
var state_11073__$1 = (function (){var statearr_11078 = state_11073;
(statearr_11078[(9)] = inst_11041__$1);

return statearr_11078;
})();
if(inst_11043){
var statearr_11079_11110 = state_11073__$1;
(statearr_11079_11110[(1)] = (5));

} else {
var statearr_11080_11111 = state_11073__$1;
(statearr_11080_11111[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (15))){
var inst_11063 = (state_11073[(2)]);
var state_11073__$1 = state_11073;
var statearr_11081_11112 = state_11073__$1;
(statearr_11081_11112[(2)] = inst_11063);

(statearr_11081_11112[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (13))){
var state_11073__$1 = state_11073;
var statearr_11082_11113 = state_11073__$1;
(statearr_11082_11113[(2)] = null);

(statearr_11082_11113[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (6))){
var inst_11038 = (state_11073[(8)]);
var inst_11059 = (inst_11038 > (0));
var state_11073__$1 = state_11073;
if(cljs.core.truth_(inst_11059)){
var statearr_11083_11114 = state_11073__$1;
(statearr_11083_11114[(1)] = (12));

} else {
var statearr_11084_11115 = state_11073__$1;
(statearr_11084_11115[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (3))){
var inst_11071 = (state_11073[(2)]);
var state_11073__$1 = state_11073;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11073__$1,inst_11071);
} else {
if((state_val_11074 === (12))){
var inst_11037 = (state_11073[(7)]);
var inst_11061 = cljs.core.vec.call(null,inst_11037);
var state_11073__$1 = state_11073;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11073__$1,(15),out,inst_11061);
} else {
if((state_val_11074 === (2))){
var state_11073__$1 = state_11073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11073__$1,(4),ch);
} else {
if((state_val_11074 === (11))){
var inst_11053 = (state_11073[(2)]);
var inst_11054 = (new Array(n));
var inst_11037 = inst_11054;
var inst_11038 = (0);
var state_11073__$1 = (function (){var statearr_11085 = state_11073;
(statearr_11085[(10)] = inst_11053);

(statearr_11085[(7)] = inst_11037);

(statearr_11085[(8)] = inst_11038);

return statearr_11085;
})();
var statearr_11086_11116 = state_11073__$1;
(statearr_11086_11116[(2)] = null);

(statearr_11086_11116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (9))){
var inst_11037 = (state_11073[(7)]);
var inst_11051 = cljs.core.vec.call(null,inst_11037);
var state_11073__$1 = state_11073;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11073__$1,(11),out,inst_11051);
} else {
if((state_val_11074 === (5))){
var inst_11041 = (state_11073[(9)]);
var inst_11046 = (state_11073[(11)]);
var inst_11037 = (state_11073[(7)]);
var inst_11038 = (state_11073[(8)]);
var inst_11045 = (inst_11037[inst_11038] = inst_11041);
var inst_11046__$1 = (inst_11038 + (1));
var inst_11047 = (inst_11046__$1 < n);
var state_11073__$1 = (function (){var statearr_11087 = state_11073;
(statearr_11087[(12)] = inst_11045);

(statearr_11087[(11)] = inst_11046__$1);

return statearr_11087;
})();
if(cljs.core.truth_(inst_11047)){
var statearr_11088_11117 = state_11073__$1;
(statearr_11088_11117[(1)] = (8));

} else {
var statearr_11089_11118 = state_11073__$1;
(statearr_11089_11118[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (14))){
var inst_11066 = (state_11073[(2)]);
var inst_11067 = cljs.core.async.close_BANG_.call(null,out);
var state_11073__$1 = (function (){var statearr_11091 = state_11073;
(statearr_11091[(13)] = inst_11066);

return statearr_11091;
})();
var statearr_11092_11119 = state_11073__$1;
(statearr_11092_11119[(2)] = inst_11067);

(statearr_11092_11119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (10))){
var inst_11057 = (state_11073[(2)]);
var state_11073__$1 = state_11073;
var statearr_11093_11120 = state_11073__$1;
(statearr_11093_11120[(2)] = inst_11057);

(statearr_11093_11120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11074 === (8))){
var inst_11046 = (state_11073[(11)]);
var inst_11037 = (state_11073[(7)]);
var tmp11090 = inst_11037;
var inst_11037__$1 = tmp11090;
var inst_11038 = inst_11046;
var state_11073__$1 = (function (){var statearr_11094 = state_11073;
(statearr_11094[(7)] = inst_11037__$1);

(statearr_11094[(8)] = inst_11038);

return statearr_11094;
})();
var statearr_11095_11121 = state_11073__$1;
(statearr_11095_11121[(2)] = null);

(statearr_11095_11121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___11107,out))
;
return ((function (switch__8335__auto__,c__8447__auto___11107,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_11099 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11099[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_11099[(1)] = (1));

return statearr_11099;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_11073){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_11073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e11100){if((e11100 instanceof Object)){
var ex__8339__auto__ = e11100;
var statearr_11101_11122 = state_11073;
(statearr_11101_11122[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11073);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11100;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11123 = state_11073;
state_11073 = G__11123;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_11073){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_11073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___11107,out))
})();
var state__8449__auto__ = (function (){var statearr_11102 = f__8448__auto__.call(null);
(statearr_11102[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___11107);

return statearr_11102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___11107,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args11124 = [];
var len__5726__auto___11198 = arguments.length;
var i__5727__auto___11199 = (0);
while(true){
if((i__5727__auto___11199 < len__5726__auto___11198)){
args11124.push((arguments[i__5727__auto___11199]));

var G__11200 = (i__5727__auto___11199 + (1));
i__5727__auto___11199 = G__11200;
continue;
} else {
}
break;
}

var G__11126 = args11124.length;
switch (G__11126) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11124.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___11202 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___11202,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___11202,out){
return (function (state_11168){
var state_val_11169 = (state_11168[(1)]);
if((state_val_11169 === (7))){
var inst_11164 = (state_11168[(2)]);
var state_11168__$1 = state_11168;
var statearr_11170_11203 = state_11168__$1;
(statearr_11170_11203[(2)] = inst_11164);

(statearr_11170_11203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (1))){
var inst_11127 = [];
var inst_11128 = inst_11127;
var inst_11129 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_11168__$1 = (function (){var statearr_11171 = state_11168;
(statearr_11171[(7)] = inst_11129);

(statearr_11171[(8)] = inst_11128);

return statearr_11171;
})();
var statearr_11172_11204 = state_11168__$1;
(statearr_11172_11204[(2)] = null);

(statearr_11172_11204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (4))){
var inst_11132 = (state_11168[(9)]);
var inst_11132__$1 = (state_11168[(2)]);
var inst_11133 = (inst_11132__$1 == null);
var inst_11134 = cljs.core.not.call(null,inst_11133);
var state_11168__$1 = (function (){var statearr_11173 = state_11168;
(statearr_11173[(9)] = inst_11132__$1);

return statearr_11173;
})();
if(inst_11134){
var statearr_11174_11205 = state_11168__$1;
(statearr_11174_11205[(1)] = (5));

} else {
var statearr_11175_11206 = state_11168__$1;
(statearr_11175_11206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (15))){
var inst_11158 = (state_11168[(2)]);
var state_11168__$1 = state_11168;
var statearr_11176_11207 = state_11168__$1;
(statearr_11176_11207[(2)] = inst_11158);

(statearr_11176_11207[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (13))){
var state_11168__$1 = state_11168;
var statearr_11177_11208 = state_11168__$1;
(statearr_11177_11208[(2)] = null);

(statearr_11177_11208[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (6))){
var inst_11128 = (state_11168[(8)]);
var inst_11153 = inst_11128.length;
var inst_11154 = (inst_11153 > (0));
var state_11168__$1 = state_11168;
if(cljs.core.truth_(inst_11154)){
var statearr_11178_11209 = state_11168__$1;
(statearr_11178_11209[(1)] = (12));

} else {
var statearr_11179_11210 = state_11168__$1;
(statearr_11179_11210[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (3))){
var inst_11166 = (state_11168[(2)]);
var state_11168__$1 = state_11168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11168__$1,inst_11166);
} else {
if((state_val_11169 === (12))){
var inst_11128 = (state_11168[(8)]);
var inst_11156 = cljs.core.vec.call(null,inst_11128);
var state_11168__$1 = state_11168;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11168__$1,(15),out,inst_11156);
} else {
if((state_val_11169 === (2))){
var state_11168__$1 = state_11168;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11168__$1,(4),ch);
} else {
if((state_val_11169 === (11))){
var inst_11132 = (state_11168[(9)]);
var inst_11136 = (state_11168[(10)]);
var inst_11146 = (state_11168[(2)]);
var inst_11147 = [];
var inst_11148 = inst_11147.push(inst_11132);
var inst_11128 = inst_11147;
var inst_11129 = inst_11136;
var state_11168__$1 = (function (){var statearr_11180 = state_11168;
(statearr_11180[(11)] = inst_11146);

(statearr_11180[(7)] = inst_11129);

(statearr_11180[(12)] = inst_11148);

(statearr_11180[(8)] = inst_11128);

return statearr_11180;
})();
var statearr_11181_11211 = state_11168__$1;
(statearr_11181_11211[(2)] = null);

(statearr_11181_11211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (9))){
var inst_11128 = (state_11168[(8)]);
var inst_11144 = cljs.core.vec.call(null,inst_11128);
var state_11168__$1 = state_11168;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11168__$1,(11),out,inst_11144);
} else {
if((state_val_11169 === (5))){
var inst_11129 = (state_11168[(7)]);
var inst_11132 = (state_11168[(9)]);
var inst_11136 = (state_11168[(10)]);
var inst_11136__$1 = f.call(null,inst_11132);
var inst_11137 = cljs.core._EQ_.call(null,inst_11136__$1,inst_11129);
var inst_11138 = cljs.core.keyword_identical_QMARK_.call(null,inst_11129,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_11139 = (inst_11137) || (inst_11138);
var state_11168__$1 = (function (){var statearr_11182 = state_11168;
(statearr_11182[(10)] = inst_11136__$1);

return statearr_11182;
})();
if(cljs.core.truth_(inst_11139)){
var statearr_11183_11212 = state_11168__$1;
(statearr_11183_11212[(1)] = (8));

} else {
var statearr_11184_11213 = state_11168__$1;
(statearr_11184_11213[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (14))){
var inst_11161 = (state_11168[(2)]);
var inst_11162 = cljs.core.async.close_BANG_.call(null,out);
var state_11168__$1 = (function (){var statearr_11186 = state_11168;
(statearr_11186[(13)] = inst_11161);

return statearr_11186;
})();
var statearr_11187_11214 = state_11168__$1;
(statearr_11187_11214[(2)] = inst_11162);

(statearr_11187_11214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (10))){
var inst_11151 = (state_11168[(2)]);
var state_11168__$1 = state_11168;
var statearr_11188_11215 = state_11168__$1;
(statearr_11188_11215[(2)] = inst_11151);

(statearr_11188_11215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11169 === (8))){
var inst_11132 = (state_11168[(9)]);
var inst_11136 = (state_11168[(10)]);
var inst_11128 = (state_11168[(8)]);
var inst_11141 = inst_11128.push(inst_11132);
var tmp11185 = inst_11128;
var inst_11128__$1 = tmp11185;
var inst_11129 = inst_11136;
var state_11168__$1 = (function (){var statearr_11189 = state_11168;
(statearr_11189[(7)] = inst_11129);

(statearr_11189[(14)] = inst_11141);

(statearr_11189[(8)] = inst_11128__$1);

return statearr_11189;
})();
var statearr_11190_11216 = state_11168__$1;
(statearr_11190_11216[(2)] = null);

(statearr_11190_11216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___11202,out))
;
return ((function (switch__8335__auto__,c__8447__auto___11202,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_11194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11194[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_11194[(1)] = (1));

return statearr_11194;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_11168){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_11168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e11195){if((e11195 instanceof Object)){
var ex__8339__auto__ = e11195;
var statearr_11196_11217 = state_11168;
(statearr_11196_11217[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11168);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11195;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11218 = state_11168;
state_11168 = G__11218;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_11168){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_11168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___11202,out))
})();
var state__8449__auto__ = (function (){var statearr_11197 = f__8448__auto__.call(null);
(statearr_11197[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___11202);

return statearr_11197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___11202,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1454331996600