// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17390 = [];
var len__5726__auto___17396 = arguments.length;
var i__5727__auto___17397 = (0);
while(true){
if((i__5727__auto___17397 < len__5726__auto___17396)){
args17390.push((arguments[i__5727__auto___17397]));

var G__17398 = (i__5727__auto___17397 + (1));
i__5727__auto___17397 = G__17398;
continue;
} else {
}
break;
}

var G__17392 = args17390.length;
switch (G__17392) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17390.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17393 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17393 = (function (f,blockable,meta17394){
this.f = f;
this.blockable = blockable;
this.meta17394 = meta17394;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17393.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17395,meta17394__$1){
var self__ = this;
var _17395__$1 = this;
return (new cljs.core.async.t_cljs$core$async17393(self__.f,self__.blockable,meta17394__$1));
});

cljs.core.async.t_cljs$core$async17393.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17395){
var self__ = this;
var _17395__$1 = this;
return self__.meta17394;
});

cljs.core.async.t_cljs$core$async17393.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17393.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17393.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17393.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17393.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17394","meta17394",1013589617,null)], null);
});

cljs.core.async.t_cljs$core$async17393.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17393.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17393";

cljs.core.async.t_cljs$core$async17393.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17393");
});

cljs.core.async.__GT_t_cljs$core$async17393 = (function cljs$core$async$__GT_t_cljs$core$async17393(f__$1,blockable__$1,meta17394){
return (new cljs.core.async.t_cljs$core$async17393(f__$1,blockable__$1,meta17394));
});

}

return (new cljs.core.async.t_cljs$core$async17393(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17402 = [];
var len__5726__auto___17405 = arguments.length;
var i__5727__auto___17406 = (0);
while(true){
if((i__5727__auto___17406 < len__5726__auto___17405)){
args17402.push((arguments[i__5727__auto___17406]));

var G__17407 = (i__5727__auto___17406 + (1));
i__5727__auto___17406 = G__17407;
continue;
} else {
}
break;
}

var G__17404 = args17402.length;
switch (G__17404) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17402.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17409 = [];
var len__5726__auto___17412 = arguments.length;
var i__5727__auto___17413 = (0);
while(true){
if((i__5727__auto___17413 < len__5726__auto___17412)){
args17409.push((arguments[i__5727__auto___17413]));

var G__17414 = (i__5727__auto___17413 + (1));
i__5727__auto___17413 = G__17414;
continue;
} else {
}
break;
}

var G__17411 = args17409.length;
switch (G__17411) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17409.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17416 = [];
var len__5726__auto___17419 = arguments.length;
var i__5727__auto___17420 = (0);
while(true){
if((i__5727__auto___17420 < len__5726__auto___17419)){
args17416.push((arguments[i__5727__auto___17420]));

var G__17421 = (i__5727__auto___17420 + (1));
i__5727__auto___17420 = G__17421;
continue;
} else {
}
break;
}

var G__17418 = args17416.length;
switch (G__17418) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17416.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17423 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17423);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17423,ret){
return (function (){
return fn1.call(null,val_17423);
});})(val_17423,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17424 = [];
var len__5726__auto___17427 = arguments.length;
var i__5727__auto___17428 = (0);
while(true){
if((i__5727__auto___17428 < len__5726__auto___17427)){
args17424.push((arguments[i__5727__auto___17428]));

var G__17429 = (i__5727__auto___17428 + (1));
i__5727__auto___17428 = G__17429;
continue;
} else {
}
break;
}

var G__17426 = args17424.length;
switch (G__17426) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17424.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17431 = n;
var x_17432 = (0);
while(true){
if((x_17432 < n__5571__auto___17431)){
(a[x_17432] = (0));

var G__17433 = (x_17432 + (1));
x_17432 = G__17433;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17434 = (i + (1));
i = G__17434;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17438 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17438 = (function (alt_flag,flag,meta17439){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17439 = meta17439;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17438.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17440,meta17439__$1){
var self__ = this;
var _17440__$1 = this;
return (new cljs.core.async.t_cljs$core$async17438(self__.alt_flag,self__.flag,meta17439__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17438.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17440){
var self__ = this;
var _17440__$1 = this;
return self__.meta17439;
});})(flag))
;

cljs.core.async.t_cljs$core$async17438.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17438.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17438.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17438.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17438.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17439","meta17439",1018714599,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17438.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17438.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17438";

cljs.core.async.t_cljs$core$async17438.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17438");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17438 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17438(alt_flag__$1,flag__$1,meta17439){
return (new cljs.core.async.t_cljs$core$async17438(alt_flag__$1,flag__$1,meta17439));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17438(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17444 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17444 = (function (alt_handler,flag,cb,meta17445){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17445 = meta17445;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17444.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17446,meta17445__$1){
var self__ = this;
var _17446__$1 = this;
return (new cljs.core.async.t_cljs$core$async17444(self__.alt_handler,self__.flag,self__.cb,meta17445__$1));
});

cljs.core.async.t_cljs$core$async17444.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17446){
var self__ = this;
var _17446__$1 = this;
return self__.meta17445;
});

cljs.core.async.t_cljs$core$async17444.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17444.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17444.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17444.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17444.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17445","meta17445",1156305348,null)], null);
});

cljs.core.async.t_cljs$core$async17444.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17444.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17444";

cljs.core.async.t_cljs$core$async17444.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17444");
});

cljs.core.async.__GT_t_cljs$core$async17444 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17444(alt_handler__$1,flag__$1,cb__$1,meta17445){
return (new cljs.core.async.t_cljs$core$async17444(alt_handler__$1,flag__$1,cb__$1,meta17445));
});

}

return (new cljs.core.async.t_cljs$core$async17444(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17447_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17447_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17448_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17448_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17449 = (i + (1));
i = G__17449;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17455 = arguments.length;
var i__5727__auto___17456 = (0);
while(true){
if((i__5727__auto___17456 < len__5726__auto___17455)){
args__5733__auto__.push((arguments[i__5727__auto___17456]));

var G__17457 = (i__5727__auto___17456 + (1));
i__5727__auto___17456 = G__17457;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17452){
var map__17453 = p__17452;
var map__17453__$1 = ((((!((map__17453 == null)))?((((map__17453.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17453.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17453):map__17453);
var opts = map__17453__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17450){
var G__17451 = cljs.core.first.call(null,seq17450);
var seq17450__$1 = cljs.core.next.call(null,seq17450);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17451,seq17450__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17458 = [];
var len__5726__auto___17508 = arguments.length;
var i__5727__auto___17509 = (0);
while(true){
if((i__5727__auto___17509 < len__5726__auto___17508)){
args17458.push((arguments[i__5727__auto___17509]));

var G__17510 = (i__5727__auto___17509 + (1));
i__5727__auto___17509 = G__17510;
continue;
} else {
}
break;
}

var G__17460 = args17458.length;
switch (G__17460) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17458.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8447__auto___17512 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___17512){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___17512){
return (function (state_17484){
var state_val_17485 = (state_17484[(1)]);
if((state_val_17485 === (7))){
var inst_17480 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
var statearr_17486_17513 = state_17484__$1;
(statearr_17486_17513[(2)] = inst_17480);

(statearr_17486_17513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (1))){
var state_17484__$1 = state_17484;
var statearr_17487_17514 = state_17484__$1;
(statearr_17487_17514[(2)] = null);

(statearr_17487_17514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (4))){
var inst_17463 = (state_17484[(7)]);
var inst_17463__$1 = (state_17484[(2)]);
var inst_17464 = (inst_17463__$1 == null);
var state_17484__$1 = (function (){var statearr_17488 = state_17484;
(statearr_17488[(7)] = inst_17463__$1);

return statearr_17488;
})();
if(cljs.core.truth_(inst_17464)){
var statearr_17489_17515 = state_17484__$1;
(statearr_17489_17515[(1)] = (5));

} else {
var statearr_17490_17516 = state_17484__$1;
(statearr_17490_17516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (13))){
var state_17484__$1 = state_17484;
var statearr_17491_17517 = state_17484__$1;
(statearr_17491_17517[(2)] = null);

(statearr_17491_17517[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (6))){
var inst_17463 = (state_17484[(7)]);
var state_17484__$1 = state_17484;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17484__$1,(11),to,inst_17463);
} else {
if((state_val_17485 === (3))){
var inst_17482 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17484__$1,inst_17482);
} else {
if((state_val_17485 === (12))){
var state_17484__$1 = state_17484;
var statearr_17492_17518 = state_17484__$1;
(statearr_17492_17518[(2)] = null);

(statearr_17492_17518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (2))){
var state_17484__$1 = state_17484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17484__$1,(4),from);
} else {
if((state_val_17485 === (11))){
var inst_17473 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
if(cljs.core.truth_(inst_17473)){
var statearr_17493_17519 = state_17484__$1;
(statearr_17493_17519[(1)] = (12));

} else {
var statearr_17494_17520 = state_17484__$1;
(statearr_17494_17520[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (9))){
var state_17484__$1 = state_17484;
var statearr_17495_17521 = state_17484__$1;
(statearr_17495_17521[(2)] = null);

(statearr_17495_17521[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (5))){
var state_17484__$1 = state_17484;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17496_17522 = state_17484__$1;
(statearr_17496_17522[(1)] = (8));

} else {
var statearr_17497_17523 = state_17484__$1;
(statearr_17497_17523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (14))){
var inst_17478 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
var statearr_17498_17524 = state_17484__$1;
(statearr_17498_17524[(2)] = inst_17478);

(statearr_17498_17524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (10))){
var inst_17470 = (state_17484[(2)]);
var state_17484__$1 = state_17484;
var statearr_17499_17525 = state_17484__$1;
(statearr_17499_17525[(2)] = inst_17470);

(statearr_17499_17525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17485 === (8))){
var inst_17467 = cljs.core.async.close_BANG_.call(null,to);
var state_17484__$1 = state_17484;
var statearr_17500_17526 = state_17484__$1;
(statearr_17500_17526[(2)] = inst_17467);

(statearr_17500_17526[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___17512))
;
return ((function (switch__8335__auto__,c__8447__auto___17512){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_17504 = [null,null,null,null,null,null,null,null];
(statearr_17504[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_17504[(1)] = (1));

return statearr_17504;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_17484){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17505){if((e17505 instanceof Object)){
var ex__8339__auto__ = e17505;
var statearr_17506_17527 = state_17484;
(statearr_17506_17527[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17484);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17505;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17528 = state_17484;
state_17484 = G__17528;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_17484){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_17484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___17512))
})();
var state__8449__auto__ = (function (){var statearr_17507 = f__8448__auto__.call(null);
(statearr_17507[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___17512);

return statearr_17507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___17512))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17712){
var vec__17713 = p__17712;
var v = cljs.core.nth.call(null,vec__17713,(0),null);
var p = cljs.core.nth.call(null,vec__17713,(1),null);
var job = vec__17713;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8447__auto___17895 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___17895,res,vec__17713,v,p,job,jobs,results){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___17895,res,vec__17713,v,p,job,jobs,results){
return (function (state_17718){
var state_val_17719 = (state_17718[(1)]);
if((state_val_17719 === (1))){
var state_17718__$1 = state_17718;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17718__$1,(2),res,v);
} else {
if((state_val_17719 === (2))){
var inst_17715 = (state_17718[(2)]);
var inst_17716 = cljs.core.async.close_BANG_.call(null,res);
var state_17718__$1 = (function (){var statearr_17720 = state_17718;
(statearr_17720[(7)] = inst_17715);

return statearr_17720;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17718__$1,inst_17716);
} else {
return null;
}
}
});})(c__8447__auto___17895,res,vec__17713,v,p,job,jobs,results))
;
return ((function (switch__8335__auto__,c__8447__auto___17895,res,vec__17713,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17724 = [null,null,null,null,null,null,null,null];
(statearr_17724[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17724[(1)] = (1));

return statearr_17724;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17718){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17725){if((e17725 instanceof Object)){
var ex__8339__auto__ = e17725;
var statearr_17726_17896 = state_17718;
(statearr_17726_17896[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17718);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17725;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17897 = state_17718;
state_17718 = G__17897;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17718){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___17895,res,vec__17713,v,p,job,jobs,results))
})();
var state__8449__auto__ = (function (){var statearr_17727 = f__8448__auto__.call(null);
(statearr_17727[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___17895);

return statearr_17727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___17895,res,vec__17713,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17728){
var vec__17729 = p__17728;
var v = cljs.core.nth.call(null,vec__17729,(0),null);
var p = cljs.core.nth.call(null,vec__17729,(1),null);
var job = vec__17729;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17898 = n;
var __17899 = (0);
while(true){
if((__17899 < n__5571__auto___17898)){
var G__17730_17900 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17730_17900) {
case "compute":
var c__8447__auto___17902 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17899,c__8447__auto___17902,G__17730_17900,n__5571__auto___17898,jobs,results,process,async){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (__17899,c__8447__auto___17902,G__17730_17900,n__5571__auto___17898,jobs,results,process,async){
return (function (state_17743){
var state_val_17744 = (state_17743[(1)]);
if((state_val_17744 === (1))){
var state_17743__$1 = state_17743;
var statearr_17745_17903 = state_17743__$1;
(statearr_17745_17903[(2)] = null);

(statearr_17745_17903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (2))){
var state_17743__$1 = state_17743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17743__$1,(4),jobs);
} else {
if((state_val_17744 === (3))){
var inst_17741 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17743__$1,inst_17741);
} else {
if((state_val_17744 === (4))){
var inst_17733 = (state_17743[(2)]);
var inst_17734 = process.call(null,inst_17733);
var state_17743__$1 = state_17743;
if(cljs.core.truth_(inst_17734)){
var statearr_17746_17904 = state_17743__$1;
(statearr_17746_17904[(1)] = (5));

} else {
var statearr_17747_17905 = state_17743__$1;
(statearr_17747_17905[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (5))){
var state_17743__$1 = state_17743;
var statearr_17748_17906 = state_17743__$1;
(statearr_17748_17906[(2)] = null);

(statearr_17748_17906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (6))){
var state_17743__$1 = state_17743;
var statearr_17749_17907 = state_17743__$1;
(statearr_17749_17907[(2)] = null);

(statearr_17749_17907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (7))){
var inst_17739 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
var statearr_17750_17908 = state_17743__$1;
(statearr_17750_17908[(2)] = inst_17739);

(statearr_17750_17908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17899,c__8447__auto___17902,G__17730_17900,n__5571__auto___17898,jobs,results,process,async))
;
return ((function (__17899,switch__8335__auto__,c__8447__auto___17902,G__17730_17900,n__5571__auto___17898,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17754 = [null,null,null,null,null,null,null];
(statearr_17754[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17754[(1)] = (1));

return statearr_17754;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17743){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17743);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17755){if((e17755 instanceof Object)){
var ex__8339__auto__ = e17755;
var statearr_17756_17909 = state_17743;
(statearr_17756_17909[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17743);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17755;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17910 = state_17743;
state_17743 = G__17910;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17743){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(__17899,switch__8335__auto__,c__8447__auto___17902,G__17730_17900,n__5571__auto___17898,jobs,results,process,async))
})();
var state__8449__auto__ = (function (){var statearr_17757 = f__8448__auto__.call(null);
(statearr_17757[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___17902);

return statearr_17757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(__17899,c__8447__auto___17902,G__17730_17900,n__5571__auto___17898,jobs,results,process,async))
);


break;
case "async":
var c__8447__auto___17911 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17899,c__8447__auto___17911,G__17730_17900,n__5571__auto___17898,jobs,results,process,async){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (__17899,c__8447__auto___17911,G__17730_17900,n__5571__auto___17898,jobs,results,process,async){
return (function (state_17770){
var state_val_17771 = (state_17770[(1)]);
if((state_val_17771 === (1))){
var state_17770__$1 = state_17770;
var statearr_17772_17912 = state_17770__$1;
(statearr_17772_17912[(2)] = null);

(statearr_17772_17912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (2))){
var state_17770__$1 = state_17770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17770__$1,(4),jobs);
} else {
if((state_val_17771 === (3))){
var inst_17768 = (state_17770[(2)]);
var state_17770__$1 = state_17770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17770__$1,inst_17768);
} else {
if((state_val_17771 === (4))){
var inst_17760 = (state_17770[(2)]);
var inst_17761 = async.call(null,inst_17760);
var state_17770__$1 = state_17770;
if(cljs.core.truth_(inst_17761)){
var statearr_17773_17913 = state_17770__$1;
(statearr_17773_17913[(1)] = (5));

} else {
var statearr_17774_17914 = state_17770__$1;
(statearr_17774_17914[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (5))){
var state_17770__$1 = state_17770;
var statearr_17775_17915 = state_17770__$1;
(statearr_17775_17915[(2)] = null);

(statearr_17775_17915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (6))){
var state_17770__$1 = state_17770;
var statearr_17776_17916 = state_17770__$1;
(statearr_17776_17916[(2)] = null);

(statearr_17776_17916[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17771 === (7))){
var inst_17766 = (state_17770[(2)]);
var state_17770__$1 = state_17770;
var statearr_17777_17917 = state_17770__$1;
(statearr_17777_17917[(2)] = inst_17766);

(statearr_17777_17917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17899,c__8447__auto___17911,G__17730_17900,n__5571__auto___17898,jobs,results,process,async))
;
return ((function (__17899,switch__8335__auto__,c__8447__auto___17911,G__17730_17900,n__5571__auto___17898,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17781 = [null,null,null,null,null,null,null];
(statearr_17781[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17781[(1)] = (1));

return statearr_17781;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17770){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17782){if((e17782 instanceof Object)){
var ex__8339__auto__ = e17782;
var statearr_17783_17918 = state_17770;
(statearr_17783_17918[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17782;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17919 = state_17770;
state_17770 = G__17919;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17770){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(__17899,switch__8335__auto__,c__8447__auto___17911,G__17730_17900,n__5571__auto___17898,jobs,results,process,async))
})();
var state__8449__auto__ = (function (){var statearr_17784 = f__8448__auto__.call(null);
(statearr_17784[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___17911);

return statearr_17784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(__17899,c__8447__auto___17911,G__17730_17900,n__5571__auto___17898,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17920 = (__17899 + (1));
__17899 = G__17920;
continue;
} else {
}
break;
}

var c__8447__auto___17921 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___17921,jobs,results,process,async){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___17921,jobs,results,process,async){
return (function (state_17806){
var state_val_17807 = (state_17806[(1)]);
if((state_val_17807 === (1))){
var state_17806__$1 = state_17806;
var statearr_17808_17922 = state_17806__$1;
(statearr_17808_17922[(2)] = null);

(statearr_17808_17922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (2))){
var state_17806__$1 = state_17806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17806__$1,(4),from);
} else {
if((state_val_17807 === (3))){
var inst_17804 = (state_17806[(2)]);
var state_17806__$1 = state_17806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17806__$1,inst_17804);
} else {
if((state_val_17807 === (4))){
var inst_17787 = (state_17806[(7)]);
var inst_17787__$1 = (state_17806[(2)]);
var inst_17788 = (inst_17787__$1 == null);
var state_17806__$1 = (function (){var statearr_17809 = state_17806;
(statearr_17809[(7)] = inst_17787__$1);

return statearr_17809;
})();
if(cljs.core.truth_(inst_17788)){
var statearr_17810_17923 = state_17806__$1;
(statearr_17810_17923[(1)] = (5));

} else {
var statearr_17811_17924 = state_17806__$1;
(statearr_17811_17924[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (5))){
var inst_17790 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17806__$1 = state_17806;
var statearr_17812_17925 = state_17806__$1;
(statearr_17812_17925[(2)] = inst_17790);

(statearr_17812_17925[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (6))){
var inst_17787 = (state_17806[(7)]);
var inst_17792 = (state_17806[(8)]);
var inst_17792__$1 = cljs.core.async.chan.call(null,(1));
var inst_17793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17794 = [inst_17787,inst_17792__$1];
var inst_17795 = (new cljs.core.PersistentVector(null,2,(5),inst_17793,inst_17794,null));
var state_17806__$1 = (function (){var statearr_17813 = state_17806;
(statearr_17813[(8)] = inst_17792__$1);

return statearr_17813;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17806__$1,(8),jobs,inst_17795);
} else {
if((state_val_17807 === (7))){
var inst_17802 = (state_17806[(2)]);
var state_17806__$1 = state_17806;
var statearr_17814_17926 = state_17806__$1;
(statearr_17814_17926[(2)] = inst_17802);

(statearr_17814_17926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (8))){
var inst_17792 = (state_17806[(8)]);
var inst_17797 = (state_17806[(2)]);
var state_17806__$1 = (function (){var statearr_17815 = state_17806;
(statearr_17815[(9)] = inst_17797);

return statearr_17815;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17806__$1,(9),results,inst_17792);
} else {
if((state_val_17807 === (9))){
var inst_17799 = (state_17806[(2)]);
var state_17806__$1 = (function (){var statearr_17816 = state_17806;
(statearr_17816[(10)] = inst_17799);

return statearr_17816;
})();
var statearr_17817_17927 = state_17806__$1;
(statearr_17817_17927[(2)] = null);

(statearr_17817_17927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___17921,jobs,results,process,async))
;
return ((function (switch__8335__auto__,c__8447__auto___17921,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17821 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17821[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17821[(1)] = (1));

return statearr_17821;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17806){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17822){if((e17822 instanceof Object)){
var ex__8339__auto__ = e17822;
var statearr_17823_17928 = state_17806;
(statearr_17823_17928[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17806);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17929 = state_17806;
state_17806 = G__17929;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17806){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___17921,jobs,results,process,async))
})();
var state__8449__auto__ = (function (){var statearr_17824 = f__8448__auto__.call(null);
(statearr_17824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___17921);

return statearr_17824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___17921,jobs,results,process,async))
);


var c__8447__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto__,jobs,results,process,async){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto__,jobs,results,process,async){
return (function (state_17862){
var state_val_17863 = (state_17862[(1)]);
if((state_val_17863 === (7))){
var inst_17858 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
var statearr_17864_17930 = state_17862__$1;
(statearr_17864_17930[(2)] = inst_17858);

(statearr_17864_17930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (20))){
var state_17862__$1 = state_17862;
var statearr_17865_17931 = state_17862__$1;
(statearr_17865_17931[(2)] = null);

(statearr_17865_17931[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (1))){
var state_17862__$1 = state_17862;
var statearr_17866_17932 = state_17862__$1;
(statearr_17866_17932[(2)] = null);

(statearr_17866_17932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (4))){
var inst_17827 = (state_17862[(7)]);
var inst_17827__$1 = (state_17862[(2)]);
var inst_17828 = (inst_17827__$1 == null);
var state_17862__$1 = (function (){var statearr_17867 = state_17862;
(statearr_17867[(7)] = inst_17827__$1);

return statearr_17867;
})();
if(cljs.core.truth_(inst_17828)){
var statearr_17868_17933 = state_17862__$1;
(statearr_17868_17933[(1)] = (5));

} else {
var statearr_17869_17934 = state_17862__$1;
(statearr_17869_17934[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (15))){
var inst_17840 = (state_17862[(8)]);
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17862__$1,(18),to,inst_17840);
} else {
if((state_val_17863 === (21))){
var inst_17853 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
var statearr_17870_17935 = state_17862__$1;
(statearr_17870_17935[(2)] = inst_17853);

(statearr_17870_17935[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (13))){
var inst_17855 = (state_17862[(2)]);
var state_17862__$1 = (function (){var statearr_17871 = state_17862;
(statearr_17871[(9)] = inst_17855);

return statearr_17871;
})();
var statearr_17872_17936 = state_17862__$1;
(statearr_17872_17936[(2)] = null);

(statearr_17872_17936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (6))){
var inst_17827 = (state_17862[(7)]);
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17862__$1,(11),inst_17827);
} else {
if((state_val_17863 === (17))){
var inst_17848 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
if(cljs.core.truth_(inst_17848)){
var statearr_17873_17937 = state_17862__$1;
(statearr_17873_17937[(1)] = (19));

} else {
var statearr_17874_17938 = state_17862__$1;
(statearr_17874_17938[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (3))){
var inst_17860 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17862__$1,inst_17860);
} else {
if((state_val_17863 === (12))){
var inst_17837 = (state_17862[(10)]);
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17862__$1,(14),inst_17837);
} else {
if((state_val_17863 === (2))){
var state_17862__$1 = state_17862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17862__$1,(4),results);
} else {
if((state_val_17863 === (19))){
var state_17862__$1 = state_17862;
var statearr_17875_17939 = state_17862__$1;
(statearr_17875_17939[(2)] = null);

(statearr_17875_17939[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (11))){
var inst_17837 = (state_17862[(2)]);
var state_17862__$1 = (function (){var statearr_17876 = state_17862;
(statearr_17876[(10)] = inst_17837);

return statearr_17876;
})();
var statearr_17877_17940 = state_17862__$1;
(statearr_17877_17940[(2)] = null);

(statearr_17877_17940[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (9))){
var state_17862__$1 = state_17862;
var statearr_17878_17941 = state_17862__$1;
(statearr_17878_17941[(2)] = null);

(statearr_17878_17941[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (5))){
var state_17862__$1 = state_17862;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17879_17942 = state_17862__$1;
(statearr_17879_17942[(1)] = (8));

} else {
var statearr_17880_17943 = state_17862__$1;
(statearr_17880_17943[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (14))){
var inst_17842 = (state_17862[(11)]);
var inst_17840 = (state_17862[(8)]);
var inst_17840__$1 = (state_17862[(2)]);
var inst_17841 = (inst_17840__$1 == null);
var inst_17842__$1 = cljs.core.not.call(null,inst_17841);
var state_17862__$1 = (function (){var statearr_17881 = state_17862;
(statearr_17881[(11)] = inst_17842__$1);

(statearr_17881[(8)] = inst_17840__$1);

return statearr_17881;
})();
if(inst_17842__$1){
var statearr_17882_17944 = state_17862__$1;
(statearr_17882_17944[(1)] = (15));

} else {
var statearr_17883_17945 = state_17862__$1;
(statearr_17883_17945[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (16))){
var inst_17842 = (state_17862[(11)]);
var state_17862__$1 = state_17862;
var statearr_17884_17946 = state_17862__$1;
(statearr_17884_17946[(2)] = inst_17842);

(statearr_17884_17946[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (10))){
var inst_17834 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
var statearr_17885_17947 = state_17862__$1;
(statearr_17885_17947[(2)] = inst_17834);

(statearr_17885_17947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (18))){
var inst_17845 = (state_17862[(2)]);
var state_17862__$1 = state_17862;
var statearr_17886_17948 = state_17862__$1;
(statearr_17886_17948[(2)] = inst_17845);

(statearr_17886_17948[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17863 === (8))){
var inst_17831 = cljs.core.async.close_BANG_.call(null,to);
var state_17862__$1 = state_17862;
var statearr_17887_17949 = state_17862__$1;
(statearr_17887_17949[(2)] = inst_17831);

(statearr_17887_17949[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto__,jobs,results,process,async))
;
return ((function (switch__8335__auto__,c__8447__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_17891 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17891[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__);

(statearr_17891[(1)] = (1));

return statearr_17891;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1 = (function (state_17862){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e17892){if((e17892 instanceof Object)){
var ex__8339__auto__ = e17892;
var statearr_17893_17950 = state_17862;
(statearr_17893_17950[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17862);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17892;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17951 = state_17862;
state_17862 = G__17951;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__ = function(state_17862){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1.call(this,state_17862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto__,jobs,results,process,async))
})();
var state__8449__auto__ = (function (){var statearr_17894 = f__8448__auto__.call(null);
(statearr_17894[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto__);

return statearr_17894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto__,jobs,results,process,async))
);

return c__8447__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17952 = [];
var len__5726__auto___17955 = arguments.length;
var i__5727__auto___17956 = (0);
while(true){
if((i__5727__auto___17956 < len__5726__auto___17955)){
args17952.push((arguments[i__5727__auto___17956]));

var G__17957 = (i__5727__auto___17956 + (1));
i__5727__auto___17956 = G__17957;
continue;
} else {
}
break;
}

var G__17954 = args17952.length;
switch (G__17954) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17952.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17959 = [];
var len__5726__auto___17962 = arguments.length;
var i__5727__auto___17963 = (0);
while(true){
if((i__5727__auto___17963 < len__5726__auto___17962)){
args17959.push((arguments[i__5727__auto___17963]));

var G__17964 = (i__5727__auto___17963 + (1));
i__5727__auto___17963 = G__17964;
continue;
} else {
}
break;
}

var G__17961 = args17959.length;
switch (G__17961) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17959.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17966 = [];
var len__5726__auto___18019 = arguments.length;
var i__5727__auto___18020 = (0);
while(true){
if((i__5727__auto___18020 < len__5726__auto___18019)){
args17966.push((arguments[i__5727__auto___18020]));

var G__18021 = (i__5727__auto___18020 + (1));
i__5727__auto___18020 = G__18021;
continue;
} else {
}
break;
}

var G__17968 = args17966.length;
switch (G__17968) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17966.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8447__auto___18023 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___18023,tc,fc){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___18023,tc,fc){
return (function (state_17994){
var state_val_17995 = (state_17994[(1)]);
if((state_val_17995 === (7))){
var inst_17990 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
var statearr_17996_18024 = state_17994__$1;
(statearr_17996_18024[(2)] = inst_17990);

(statearr_17996_18024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (1))){
var state_17994__$1 = state_17994;
var statearr_17997_18025 = state_17994__$1;
(statearr_17997_18025[(2)] = null);

(statearr_17997_18025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (4))){
var inst_17971 = (state_17994[(7)]);
var inst_17971__$1 = (state_17994[(2)]);
var inst_17972 = (inst_17971__$1 == null);
var state_17994__$1 = (function (){var statearr_17998 = state_17994;
(statearr_17998[(7)] = inst_17971__$1);

return statearr_17998;
})();
if(cljs.core.truth_(inst_17972)){
var statearr_17999_18026 = state_17994__$1;
(statearr_17999_18026[(1)] = (5));

} else {
var statearr_18000_18027 = state_17994__$1;
(statearr_18000_18027[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (13))){
var state_17994__$1 = state_17994;
var statearr_18001_18028 = state_17994__$1;
(statearr_18001_18028[(2)] = null);

(statearr_18001_18028[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (6))){
var inst_17971 = (state_17994[(7)]);
var inst_17977 = p.call(null,inst_17971);
var state_17994__$1 = state_17994;
if(cljs.core.truth_(inst_17977)){
var statearr_18002_18029 = state_17994__$1;
(statearr_18002_18029[(1)] = (9));

} else {
var statearr_18003_18030 = state_17994__$1;
(statearr_18003_18030[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (3))){
var inst_17992 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17994__$1,inst_17992);
} else {
if((state_val_17995 === (12))){
var state_17994__$1 = state_17994;
var statearr_18004_18031 = state_17994__$1;
(statearr_18004_18031[(2)] = null);

(statearr_18004_18031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (2))){
var state_17994__$1 = state_17994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17994__$1,(4),ch);
} else {
if((state_val_17995 === (11))){
var inst_17971 = (state_17994[(7)]);
var inst_17981 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17994__$1,(8),inst_17981,inst_17971);
} else {
if((state_val_17995 === (9))){
var state_17994__$1 = state_17994;
var statearr_18005_18032 = state_17994__$1;
(statearr_18005_18032[(2)] = tc);

(statearr_18005_18032[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (5))){
var inst_17974 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17975 = cljs.core.async.close_BANG_.call(null,fc);
var state_17994__$1 = (function (){var statearr_18006 = state_17994;
(statearr_18006[(8)] = inst_17974);

return statearr_18006;
})();
var statearr_18007_18033 = state_17994__$1;
(statearr_18007_18033[(2)] = inst_17975);

(statearr_18007_18033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (14))){
var inst_17988 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
var statearr_18008_18034 = state_17994__$1;
(statearr_18008_18034[(2)] = inst_17988);

(statearr_18008_18034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (10))){
var state_17994__$1 = state_17994;
var statearr_18009_18035 = state_17994__$1;
(statearr_18009_18035[(2)] = fc);

(statearr_18009_18035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17995 === (8))){
var inst_17983 = (state_17994[(2)]);
var state_17994__$1 = state_17994;
if(cljs.core.truth_(inst_17983)){
var statearr_18010_18036 = state_17994__$1;
(statearr_18010_18036[(1)] = (12));

} else {
var statearr_18011_18037 = state_17994__$1;
(statearr_18011_18037[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___18023,tc,fc))
;
return ((function (switch__8335__auto__,c__8447__auto___18023,tc,fc){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_18015 = [null,null,null,null,null,null,null,null,null];
(statearr_18015[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_18015[(1)] = (1));

return statearr_18015;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_17994){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_17994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18016){if((e18016 instanceof Object)){
var ex__8339__auto__ = e18016;
var statearr_18017_18038 = state_17994;
(statearr_18017_18038[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17994);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18016;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18039 = state_17994;
state_17994 = G__18039;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_17994){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_17994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___18023,tc,fc))
})();
var state__8449__auto__ = (function (){var statearr_18018 = f__8448__auto__.call(null);
(statearr_18018[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___18023);

return statearr_18018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___18023,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8447__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto__){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto__){
return (function (state_18103){
var state_val_18104 = (state_18103[(1)]);
if((state_val_18104 === (7))){
var inst_18099 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
var statearr_18105_18126 = state_18103__$1;
(statearr_18105_18126[(2)] = inst_18099);

(statearr_18105_18126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (1))){
var inst_18083 = init;
var state_18103__$1 = (function (){var statearr_18106 = state_18103;
(statearr_18106[(7)] = inst_18083);

return statearr_18106;
})();
var statearr_18107_18127 = state_18103__$1;
(statearr_18107_18127[(2)] = null);

(statearr_18107_18127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (4))){
var inst_18086 = (state_18103[(8)]);
var inst_18086__$1 = (state_18103[(2)]);
var inst_18087 = (inst_18086__$1 == null);
var state_18103__$1 = (function (){var statearr_18108 = state_18103;
(statearr_18108[(8)] = inst_18086__$1);

return statearr_18108;
})();
if(cljs.core.truth_(inst_18087)){
var statearr_18109_18128 = state_18103__$1;
(statearr_18109_18128[(1)] = (5));

} else {
var statearr_18110_18129 = state_18103__$1;
(statearr_18110_18129[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (6))){
var inst_18090 = (state_18103[(9)]);
var inst_18083 = (state_18103[(7)]);
var inst_18086 = (state_18103[(8)]);
var inst_18090__$1 = f.call(null,inst_18083,inst_18086);
var inst_18091 = cljs.core.reduced_QMARK_.call(null,inst_18090__$1);
var state_18103__$1 = (function (){var statearr_18111 = state_18103;
(statearr_18111[(9)] = inst_18090__$1);

return statearr_18111;
})();
if(inst_18091){
var statearr_18112_18130 = state_18103__$1;
(statearr_18112_18130[(1)] = (8));

} else {
var statearr_18113_18131 = state_18103__$1;
(statearr_18113_18131[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (3))){
var inst_18101 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18103__$1,inst_18101);
} else {
if((state_val_18104 === (2))){
var state_18103__$1 = state_18103;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18103__$1,(4),ch);
} else {
if((state_val_18104 === (9))){
var inst_18090 = (state_18103[(9)]);
var inst_18083 = inst_18090;
var state_18103__$1 = (function (){var statearr_18114 = state_18103;
(statearr_18114[(7)] = inst_18083);

return statearr_18114;
})();
var statearr_18115_18132 = state_18103__$1;
(statearr_18115_18132[(2)] = null);

(statearr_18115_18132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (5))){
var inst_18083 = (state_18103[(7)]);
var state_18103__$1 = state_18103;
var statearr_18116_18133 = state_18103__$1;
(statearr_18116_18133[(2)] = inst_18083);

(statearr_18116_18133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (10))){
var inst_18097 = (state_18103[(2)]);
var state_18103__$1 = state_18103;
var statearr_18117_18134 = state_18103__$1;
(statearr_18117_18134[(2)] = inst_18097);

(statearr_18117_18134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18104 === (8))){
var inst_18090 = (state_18103[(9)]);
var inst_18093 = cljs.core.deref.call(null,inst_18090);
var state_18103__$1 = state_18103;
var statearr_18118_18135 = state_18103__$1;
(statearr_18118_18135[(2)] = inst_18093);

(statearr_18118_18135[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto__))
;
return ((function (switch__8335__auto__,c__8447__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8336__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8336__auto____0 = (function (){
var statearr_18122 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18122[(0)] = cljs$core$async$reduce_$_state_machine__8336__auto__);

(statearr_18122[(1)] = (1));

return statearr_18122;
});
var cljs$core$async$reduce_$_state_machine__8336__auto____1 = (function (state_18103){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_18103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18123){if((e18123 instanceof Object)){
var ex__8339__auto__ = e18123;
var statearr_18124_18136 = state_18103;
(statearr_18124_18136[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18103);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18123;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18137 = state_18103;
state_18103 = G__18137;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8336__auto__ = function(state_18103){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8336__auto____1.call(this,state_18103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8336__auto____0;
cljs$core$async$reduce_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8336__auto____1;
return cljs$core$async$reduce_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto__))
})();
var state__8449__auto__ = (function (){var statearr_18125 = f__8448__auto__.call(null);
(statearr_18125[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto__);

return statearr_18125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto__))
);

return c__8447__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18138 = [];
var len__5726__auto___18190 = arguments.length;
var i__5727__auto___18191 = (0);
while(true){
if((i__5727__auto___18191 < len__5726__auto___18190)){
args18138.push((arguments[i__5727__auto___18191]));

var G__18192 = (i__5727__auto___18191 + (1));
i__5727__auto___18191 = G__18192;
continue;
} else {
}
break;
}

var G__18140 = args18138.length;
switch (G__18140) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18138.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8447__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto__){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto__){
return (function (state_18165){
var state_val_18166 = (state_18165[(1)]);
if((state_val_18166 === (7))){
var inst_18147 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
var statearr_18167_18194 = state_18165__$1;
(statearr_18167_18194[(2)] = inst_18147);

(statearr_18167_18194[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (1))){
var inst_18141 = cljs.core.seq.call(null,coll);
var inst_18142 = inst_18141;
var state_18165__$1 = (function (){var statearr_18168 = state_18165;
(statearr_18168[(7)] = inst_18142);

return statearr_18168;
})();
var statearr_18169_18195 = state_18165__$1;
(statearr_18169_18195[(2)] = null);

(statearr_18169_18195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (4))){
var inst_18142 = (state_18165[(7)]);
var inst_18145 = cljs.core.first.call(null,inst_18142);
var state_18165__$1 = state_18165;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18165__$1,(7),ch,inst_18145);
} else {
if((state_val_18166 === (13))){
var inst_18159 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
var statearr_18170_18196 = state_18165__$1;
(statearr_18170_18196[(2)] = inst_18159);

(statearr_18170_18196[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (6))){
var inst_18150 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
if(cljs.core.truth_(inst_18150)){
var statearr_18171_18197 = state_18165__$1;
(statearr_18171_18197[(1)] = (8));

} else {
var statearr_18172_18198 = state_18165__$1;
(statearr_18172_18198[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (3))){
var inst_18163 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18165__$1,inst_18163);
} else {
if((state_val_18166 === (12))){
var state_18165__$1 = state_18165;
var statearr_18173_18199 = state_18165__$1;
(statearr_18173_18199[(2)] = null);

(statearr_18173_18199[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (2))){
var inst_18142 = (state_18165[(7)]);
var state_18165__$1 = state_18165;
if(cljs.core.truth_(inst_18142)){
var statearr_18174_18200 = state_18165__$1;
(statearr_18174_18200[(1)] = (4));

} else {
var statearr_18175_18201 = state_18165__$1;
(statearr_18175_18201[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (11))){
var inst_18156 = cljs.core.async.close_BANG_.call(null,ch);
var state_18165__$1 = state_18165;
var statearr_18176_18202 = state_18165__$1;
(statearr_18176_18202[(2)] = inst_18156);

(statearr_18176_18202[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (9))){
var state_18165__$1 = state_18165;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18177_18203 = state_18165__$1;
(statearr_18177_18203[(1)] = (11));

} else {
var statearr_18178_18204 = state_18165__$1;
(statearr_18178_18204[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (5))){
var inst_18142 = (state_18165[(7)]);
var state_18165__$1 = state_18165;
var statearr_18179_18205 = state_18165__$1;
(statearr_18179_18205[(2)] = inst_18142);

(statearr_18179_18205[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (10))){
var inst_18161 = (state_18165[(2)]);
var state_18165__$1 = state_18165;
var statearr_18180_18206 = state_18165__$1;
(statearr_18180_18206[(2)] = inst_18161);

(statearr_18180_18206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18166 === (8))){
var inst_18142 = (state_18165[(7)]);
var inst_18152 = cljs.core.next.call(null,inst_18142);
var inst_18142__$1 = inst_18152;
var state_18165__$1 = (function (){var statearr_18181 = state_18165;
(statearr_18181[(7)] = inst_18142__$1);

return statearr_18181;
})();
var statearr_18182_18207 = state_18165__$1;
(statearr_18182_18207[(2)] = null);

(statearr_18182_18207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto__))
;
return ((function (switch__8335__auto__,c__8447__auto__){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_18186 = [null,null,null,null,null,null,null,null];
(statearr_18186[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_18186[(1)] = (1));

return statearr_18186;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_18165){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_18165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18187){if((e18187 instanceof Object)){
var ex__8339__auto__ = e18187;
var statearr_18188_18208 = state_18165;
(statearr_18188_18208[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18165);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18187;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18209 = state_18165;
state_18165 = G__18209;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_18165){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_18165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto__))
})();
var state__8449__auto__ = (function (){var statearr_18189 = f__8448__auto__.call(null);
(statearr_18189[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto__);

return statearr_18189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto__))
);

return c__8447__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18431 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18431 = (function (mult,ch,cs,meta18432){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18432 = meta18432;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18433,meta18432__$1){
var self__ = this;
var _18433__$1 = this;
return (new cljs.core.async.t_cljs$core$async18431(self__.mult,self__.ch,self__.cs,meta18432__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18433){
var self__ = this;
var _18433__$1 = this;
return self__.meta18432;
});})(cs))
;

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18431.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18432","meta18432",-1780972233,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18431.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18431.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18431";

cljs.core.async.t_cljs$core$async18431.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18431");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18431 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18431(mult__$1,ch__$1,cs__$1,meta18432){
return (new cljs.core.async.t_cljs$core$async18431(mult__$1,ch__$1,cs__$1,meta18432));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18431(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8447__auto___18652 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___18652,cs,m,dchan,dctr,done){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___18652,cs,m,dchan,dctr,done){
return (function (state_18564){
var state_val_18565 = (state_18564[(1)]);
if((state_val_18565 === (7))){
var inst_18560 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18566_18653 = state_18564__$1;
(statearr_18566_18653[(2)] = inst_18560);

(statearr_18566_18653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (20))){
var inst_18465 = (state_18564[(7)]);
var inst_18475 = cljs.core.first.call(null,inst_18465);
var inst_18476 = cljs.core.nth.call(null,inst_18475,(0),null);
var inst_18477 = cljs.core.nth.call(null,inst_18475,(1),null);
var state_18564__$1 = (function (){var statearr_18567 = state_18564;
(statearr_18567[(8)] = inst_18476);

return statearr_18567;
})();
if(cljs.core.truth_(inst_18477)){
var statearr_18568_18654 = state_18564__$1;
(statearr_18568_18654[(1)] = (22));

} else {
var statearr_18569_18655 = state_18564__$1;
(statearr_18569_18655[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (27))){
var inst_18436 = (state_18564[(9)]);
var inst_18507 = (state_18564[(10)]);
var inst_18505 = (state_18564[(11)]);
var inst_18512 = (state_18564[(12)]);
var inst_18512__$1 = cljs.core._nth.call(null,inst_18505,inst_18507);
var inst_18513 = cljs.core.async.put_BANG_.call(null,inst_18512__$1,inst_18436,done);
var state_18564__$1 = (function (){var statearr_18570 = state_18564;
(statearr_18570[(12)] = inst_18512__$1);

return statearr_18570;
})();
if(cljs.core.truth_(inst_18513)){
var statearr_18571_18656 = state_18564__$1;
(statearr_18571_18656[(1)] = (30));

} else {
var statearr_18572_18657 = state_18564__$1;
(statearr_18572_18657[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (1))){
var state_18564__$1 = state_18564;
var statearr_18573_18658 = state_18564__$1;
(statearr_18573_18658[(2)] = null);

(statearr_18573_18658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (24))){
var inst_18465 = (state_18564[(7)]);
var inst_18482 = (state_18564[(2)]);
var inst_18483 = cljs.core.next.call(null,inst_18465);
var inst_18445 = inst_18483;
var inst_18446 = null;
var inst_18447 = (0);
var inst_18448 = (0);
var state_18564__$1 = (function (){var statearr_18574 = state_18564;
(statearr_18574[(13)] = inst_18446);

(statearr_18574[(14)] = inst_18445);

(statearr_18574[(15)] = inst_18447);

(statearr_18574[(16)] = inst_18482);

(statearr_18574[(17)] = inst_18448);

return statearr_18574;
})();
var statearr_18575_18659 = state_18564__$1;
(statearr_18575_18659[(2)] = null);

(statearr_18575_18659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (39))){
var state_18564__$1 = state_18564;
var statearr_18579_18660 = state_18564__$1;
(statearr_18579_18660[(2)] = null);

(statearr_18579_18660[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (4))){
var inst_18436 = (state_18564[(9)]);
var inst_18436__$1 = (state_18564[(2)]);
var inst_18437 = (inst_18436__$1 == null);
var state_18564__$1 = (function (){var statearr_18580 = state_18564;
(statearr_18580[(9)] = inst_18436__$1);

return statearr_18580;
})();
if(cljs.core.truth_(inst_18437)){
var statearr_18581_18661 = state_18564__$1;
(statearr_18581_18661[(1)] = (5));

} else {
var statearr_18582_18662 = state_18564__$1;
(statearr_18582_18662[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (15))){
var inst_18446 = (state_18564[(13)]);
var inst_18445 = (state_18564[(14)]);
var inst_18447 = (state_18564[(15)]);
var inst_18448 = (state_18564[(17)]);
var inst_18461 = (state_18564[(2)]);
var inst_18462 = (inst_18448 + (1));
var tmp18576 = inst_18446;
var tmp18577 = inst_18445;
var tmp18578 = inst_18447;
var inst_18445__$1 = tmp18577;
var inst_18446__$1 = tmp18576;
var inst_18447__$1 = tmp18578;
var inst_18448__$1 = inst_18462;
var state_18564__$1 = (function (){var statearr_18583 = state_18564;
(statearr_18583[(13)] = inst_18446__$1);

(statearr_18583[(18)] = inst_18461);

(statearr_18583[(14)] = inst_18445__$1);

(statearr_18583[(15)] = inst_18447__$1);

(statearr_18583[(17)] = inst_18448__$1);

return statearr_18583;
})();
var statearr_18584_18663 = state_18564__$1;
(statearr_18584_18663[(2)] = null);

(statearr_18584_18663[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (21))){
var inst_18486 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18588_18664 = state_18564__$1;
(statearr_18588_18664[(2)] = inst_18486);

(statearr_18588_18664[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (31))){
var inst_18512 = (state_18564[(12)]);
var inst_18516 = done.call(null,null);
var inst_18517 = cljs.core.async.untap_STAR_.call(null,m,inst_18512);
var state_18564__$1 = (function (){var statearr_18589 = state_18564;
(statearr_18589[(19)] = inst_18516);

return statearr_18589;
})();
var statearr_18590_18665 = state_18564__$1;
(statearr_18590_18665[(2)] = inst_18517);

(statearr_18590_18665[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (32))){
var inst_18506 = (state_18564[(20)]);
var inst_18507 = (state_18564[(10)]);
var inst_18505 = (state_18564[(11)]);
var inst_18504 = (state_18564[(21)]);
var inst_18519 = (state_18564[(2)]);
var inst_18520 = (inst_18507 + (1));
var tmp18585 = inst_18506;
var tmp18586 = inst_18505;
var tmp18587 = inst_18504;
var inst_18504__$1 = tmp18587;
var inst_18505__$1 = tmp18586;
var inst_18506__$1 = tmp18585;
var inst_18507__$1 = inst_18520;
var state_18564__$1 = (function (){var statearr_18591 = state_18564;
(statearr_18591[(20)] = inst_18506__$1);

(statearr_18591[(22)] = inst_18519);

(statearr_18591[(10)] = inst_18507__$1);

(statearr_18591[(11)] = inst_18505__$1);

(statearr_18591[(21)] = inst_18504__$1);

return statearr_18591;
})();
var statearr_18592_18666 = state_18564__$1;
(statearr_18592_18666[(2)] = null);

(statearr_18592_18666[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (40))){
var inst_18532 = (state_18564[(23)]);
var inst_18536 = done.call(null,null);
var inst_18537 = cljs.core.async.untap_STAR_.call(null,m,inst_18532);
var state_18564__$1 = (function (){var statearr_18593 = state_18564;
(statearr_18593[(24)] = inst_18536);

return statearr_18593;
})();
var statearr_18594_18667 = state_18564__$1;
(statearr_18594_18667[(2)] = inst_18537);

(statearr_18594_18667[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (33))){
var inst_18523 = (state_18564[(25)]);
var inst_18525 = cljs.core.chunked_seq_QMARK_.call(null,inst_18523);
var state_18564__$1 = state_18564;
if(inst_18525){
var statearr_18595_18668 = state_18564__$1;
(statearr_18595_18668[(1)] = (36));

} else {
var statearr_18596_18669 = state_18564__$1;
(statearr_18596_18669[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (13))){
var inst_18455 = (state_18564[(26)]);
var inst_18458 = cljs.core.async.close_BANG_.call(null,inst_18455);
var state_18564__$1 = state_18564;
var statearr_18597_18670 = state_18564__$1;
(statearr_18597_18670[(2)] = inst_18458);

(statearr_18597_18670[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (22))){
var inst_18476 = (state_18564[(8)]);
var inst_18479 = cljs.core.async.close_BANG_.call(null,inst_18476);
var state_18564__$1 = state_18564;
var statearr_18598_18671 = state_18564__$1;
(statearr_18598_18671[(2)] = inst_18479);

(statearr_18598_18671[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (36))){
var inst_18523 = (state_18564[(25)]);
var inst_18527 = cljs.core.chunk_first.call(null,inst_18523);
var inst_18528 = cljs.core.chunk_rest.call(null,inst_18523);
var inst_18529 = cljs.core.count.call(null,inst_18527);
var inst_18504 = inst_18528;
var inst_18505 = inst_18527;
var inst_18506 = inst_18529;
var inst_18507 = (0);
var state_18564__$1 = (function (){var statearr_18599 = state_18564;
(statearr_18599[(20)] = inst_18506);

(statearr_18599[(10)] = inst_18507);

(statearr_18599[(11)] = inst_18505);

(statearr_18599[(21)] = inst_18504);

return statearr_18599;
})();
var statearr_18600_18672 = state_18564__$1;
(statearr_18600_18672[(2)] = null);

(statearr_18600_18672[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (41))){
var inst_18523 = (state_18564[(25)]);
var inst_18539 = (state_18564[(2)]);
var inst_18540 = cljs.core.next.call(null,inst_18523);
var inst_18504 = inst_18540;
var inst_18505 = null;
var inst_18506 = (0);
var inst_18507 = (0);
var state_18564__$1 = (function (){var statearr_18601 = state_18564;
(statearr_18601[(20)] = inst_18506);

(statearr_18601[(27)] = inst_18539);

(statearr_18601[(10)] = inst_18507);

(statearr_18601[(11)] = inst_18505);

(statearr_18601[(21)] = inst_18504);

return statearr_18601;
})();
var statearr_18602_18673 = state_18564__$1;
(statearr_18602_18673[(2)] = null);

(statearr_18602_18673[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (43))){
var state_18564__$1 = state_18564;
var statearr_18603_18674 = state_18564__$1;
(statearr_18603_18674[(2)] = null);

(statearr_18603_18674[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (29))){
var inst_18548 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18604_18675 = state_18564__$1;
(statearr_18604_18675[(2)] = inst_18548);

(statearr_18604_18675[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (44))){
var inst_18557 = (state_18564[(2)]);
var state_18564__$1 = (function (){var statearr_18605 = state_18564;
(statearr_18605[(28)] = inst_18557);

return statearr_18605;
})();
var statearr_18606_18676 = state_18564__$1;
(statearr_18606_18676[(2)] = null);

(statearr_18606_18676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (6))){
var inst_18496 = (state_18564[(29)]);
var inst_18495 = cljs.core.deref.call(null,cs);
var inst_18496__$1 = cljs.core.keys.call(null,inst_18495);
var inst_18497 = cljs.core.count.call(null,inst_18496__$1);
var inst_18498 = cljs.core.reset_BANG_.call(null,dctr,inst_18497);
var inst_18503 = cljs.core.seq.call(null,inst_18496__$1);
var inst_18504 = inst_18503;
var inst_18505 = null;
var inst_18506 = (0);
var inst_18507 = (0);
var state_18564__$1 = (function (){var statearr_18607 = state_18564;
(statearr_18607[(20)] = inst_18506);

(statearr_18607[(30)] = inst_18498);

(statearr_18607[(10)] = inst_18507);

(statearr_18607[(11)] = inst_18505);

(statearr_18607[(21)] = inst_18504);

(statearr_18607[(29)] = inst_18496__$1);

return statearr_18607;
})();
var statearr_18608_18677 = state_18564__$1;
(statearr_18608_18677[(2)] = null);

(statearr_18608_18677[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (28))){
var inst_18523 = (state_18564[(25)]);
var inst_18504 = (state_18564[(21)]);
var inst_18523__$1 = cljs.core.seq.call(null,inst_18504);
var state_18564__$1 = (function (){var statearr_18609 = state_18564;
(statearr_18609[(25)] = inst_18523__$1);

return statearr_18609;
})();
if(inst_18523__$1){
var statearr_18610_18678 = state_18564__$1;
(statearr_18610_18678[(1)] = (33));

} else {
var statearr_18611_18679 = state_18564__$1;
(statearr_18611_18679[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (25))){
var inst_18506 = (state_18564[(20)]);
var inst_18507 = (state_18564[(10)]);
var inst_18509 = (inst_18507 < inst_18506);
var inst_18510 = inst_18509;
var state_18564__$1 = state_18564;
if(cljs.core.truth_(inst_18510)){
var statearr_18612_18680 = state_18564__$1;
(statearr_18612_18680[(1)] = (27));

} else {
var statearr_18613_18681 = state_18564__$1;
(statearr_18613_18681[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (34))){
var state_18564__$1 = state_18564;
var statearr_18614_18682 = state_18564__$1;
(statearr_18614_18682[(2)] = null);

(statearr_18614_18682[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (17))){
var state_18564__$1 = state_18564;
var statearr_18615_18683 = state_18564__$1;
(statearr_18615_18683[(2)] = null);

(statearr_18615_18683[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (3))){
var inst_18562 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18564__$1,inst_18562);
} else {
if((state_val_18565 === (12))){
var inst_18491 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18616_18684 = state_18564__$1;
(statearr_18616_18684[(2)] = inst_18491);

(statearr_18616_18684[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (2))){
var state_18564__$1 = state_18564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18564__$1,(4),ch);
} else {
if((state_val_18565 === (23))){
var state_18564__$1 = state_18564;
var statearr_18617_18685 = state_18564__$1;
(statearr_18617_18685[(2)] = null);

(statearr_18617_18685[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (35))){
var inst_18546 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18618_18686 = state_18564__$1;
(statearr_18618_18686[(2)] = inst_18546);

(statearr_18618_18686[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (19))){
var inst_18465 = (state_18564[(7)]);
var inst_18469 = cljs.core.chunk_first.call(null,inst_18465);
var inst_18470 = cljs.core.chunk_rest.call(null,inst_18465);
var inst_18471 = cljs.core.count.call(null,inst_18469);
var inst_18445 = inst_18470;
var inst_18446 = inst_18469;
var inst_18447 = inst_18471;
var inst_18448 = (0);
var state_18564__$1 = (function (){var statearr_18619 = state_18564;
(statearr_18619[(13)] = inst_18446);

(statearr_18619[(14)] = inst_18445);

(statearr_18619[(15)] = inst_18447);

(statearr_18619[(17)] = inst_18448);

return statearr_18619;
})();
var statearr_18620_18687 = state_18564__$1;
(statearr_18620_18687[(2)] = null);

(statearr_18620_18687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (11))){
var inst_18445 = (state_18564[(14)]);
var inst_18465 = (state_18564[(7)]);
var inst_18465__$1 = cljs.core.seq.call(null,inst_18445);
var state_18564__$1 = (function (){var statearr_18621 = state_18564;
(statearr_18621[(7)] = inst_18465__$1);

return statearr_18621;
})();
if(inst_18465__$1){
var statearr_18622_18688 = state_18564__$1;
(statearr_18622_18688[(1)] = (16));

} else {
var statearr_18623_18689 = state_18564__$1;
(statearr_18623_18689[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (9))){
var inst_18493 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18624_18690 = state_18564__$1;
(statearr_18624_18690[(2)] = inst_18493);

(statearr_18624_18690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (5))){
var inst_18443 = cljs.core.deref.call(null,cs);
var inst_18444 = cljs.core.seq.call(null,inst_18443);
var inst_18445 = inst_18444;
var inst_18446 = null;
var inst_18447 = (0);
var inst_18448 = (0);
var state_18564__$1 = (function (){var statearr_18625 = state_18564;
(statearr_18625[(13)] = inst_18446);

(statearr_18625[(14)] = inst_18445);

(statearr_18625[(15)] = inst_18447);

(statearr_18625[(17)] = inst_18448);

return statearr_18625;
})();
var statearr_18626_18691 = state_18564__$1;
(statearr_18626_18691[(2)] = null);

(statearr_18626_18691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (14))){
var state_18564__$1 = state_18564;
var statearr_18627_18692 = state_18564__$1;
(statearr_18627_18692[(2)] = null);

(statearr_18627_18692[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (45))){
var inst_18554 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18628_18693 = state_18564__$1;
(statearr_18628_18693[(2)] = inst_18554);

(statearr_18628_18693[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (26))){
var inst_18496 = (state_18564[(29)]);
var inst_18550 = (state_18564[(2)]);
var inst_18551 = cljs.core.seq.call(null,inst_18496);
var state_18564__$1 = (function (){var statearr_18629 = state_18564;
(statearr_18629[(31)] = inst_18550);

return statearr_18629;
})();
if(inst_18551){
var statearr_18630_18694 = state_18564__$1;
(statearr_18630_18694[(1)] = (42));

} else {
var statearr_18631_18695 = state_18564__$1;
(statearr_18631_18695[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (16))){
var inst_18465 = (state_18564[(7)]);
var inst_18467 = cljs.core.chunked_seq_QMARK_.call(null,inst_18465);
var state_18564__$1 = state_18564;
if(inst_18467){
var statearr_18632_18696 = state_18564__$1;
(statearr_18632_18696[(1)] = (19));

} else {
var statearr_18633_18697 = state_18564__$1;
(statearr_18633_18697[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (38))){
var inst_18543 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18634_18698 = state_18564__$1;
(statearr_18634_18698[(2)] = inst_18543);

(statearr_18634_18698[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (30))){
var state_18564__$1 = state_18564;
var statearr_18635_18699 = state_18564__$1;
(statearr_18635_18699[(2)] = null);

(statearr_18635_18699[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (10))){
var inst_18446 = (state_18564[(13)]);
var inst_18448 = (state_18564[(17)]);
var inst_18454 = cljs.core._nth.call(null,inst_18446,inst_18448);
var inst_18455 = cljs.core.nth.call(null,inst_18454,(0),null);
var inst_18456 = cljs.core.nth.call(null,inst_18454,(1),null);
var state_18564__$1 = (function (){var statearr_18636 = state_18564;
(statearr_18636[(26)] = inst_18455);

return statearr_18636;
})();
if(cljs.core.truth_(inst_18456)){
var statearr_18637_18700 = state_18564__$1;
(statearr_18637_18700[(1)] = (13));

} else {
var statearr_18638_18701 = state_18564__$1;
(statearr_18638_18701[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (18))){
var inst_18489 = (state_18564[(2)]);
var state_18564__$1 = state_18564;
var statearr_18639_18702 = state_18564__$1;
(statearr_18639_18702[(2)] = inst_18489);

(statearr_18639_18702[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (42))){
var state_18564__$1 = state_18564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18564__$1,(45),dchan);
} else {
if((state_val_18565 === (37))){
var inst_18436 = (state_18564[(9)]);
var inst_18523 = (state_18564[(25)]);
var inst_18532 = (state_18564[(23)]);
var inst_18532__$1 = cljs.core.first.call(null,inst_18523);
var inst_18533 = cljs.core.async.put_BANG_.call(null,inst_18532__$1,inst_18436,done);
var state_18564__$1 = (function (){var statearr_18640 = state_18564;
(statearr_18640[(23)] = inst_18532__$1);

return statearr_18640;
})();
if(cljs.core.truth_(inst_18533)){
var statearr_18641_18703 = state_18564__$1;
(statearr_18641_18703[(1)] = (39));

} else {
var statearr_18642_18704 = state_18564__$1;
(statearr_18642_18704[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18565 === (8))){
var inst_18447 = (state_18564[(15)]);
var inst_18448 = (state_18564[(17)]);
var inst_18450 = (inst_18448 < inst_18447);
var inst_18451 = inst_18450;
var state_18564__$1 = state_18564;
if(cljs.core.truth_(inst_18451)){
var statearr_18643_18705 = state_18564__$1;
(statearr_18643_18705[(1)] = (10));

} else {
var statearr_18644_18706 = state_18564__$1;
(statearr_18644_18706[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___18652,cs,m,dchan,dctr,done))
;
return ((function (switch__8335__auto__,c__8447__auto___18652,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8336__auto__ = null;
var cljs$core$async$mult_$_state_machine__8336__auto____0 = (function (){
var statearr_18648 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18648[(0)] = cljs$core$async$mult_$_state_machine__8336__auto__);

(statearr_18648[(1)] = (1));

return statearr_18648;
});
var cljs$core$async$mult_$_state_machine__8336__auto____1 = (function (state_18564){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_18564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e18649){if((e18649 instanceof Object)){
var ex__8339__auto__ = e18649;
var statearr_18650_18707 = state_18564;
(statearr_18650_18707[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18649;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18708 = state_18564;
state_18564 = G__18708;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8336__auto__ = function(state_18564){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8336__auto____1.call(this,state_18564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8336__auto____0;
cljs$core$async$mult_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8336__auto____1;
return cljs$core$async$mult_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___18652,cs,m,dchan,dctr,done))
})();
var state__8449__auto__ = (function (){var statearr_18651 = f__8448__auto__.call(null);
(statearr_18651[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___18652);

return statearr_18651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___18652,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18709 = [];
var len__5726__auto___18712 = arguments.length;
var i__5727__auto___18713 = (0);
while(true){
if((i__5727__auto___18713 < len__5726__auto___18712)){
args18709.push((arguments[i__5727__auto___18713]));

var G__18714 = (i__5727__auto___18713 + (1));
i__5727__auto___18713 = G__18714;
continue;
} else {
}
break;
}

var G__18711 = args18709.length;
switch (G__18711) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18709.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18726 = arguments.length;
var i__5727__auto___18727 = (0);
while(true){
if((i__5727__auto___18727 < len__5726__auto___18726)){
args__5733__auto__.push((arguments[i__5727__auto___18727]));

var G__18728 = (i__5727__auto___18727 + (1));
i__5727__auto___18727 = G__18728;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18720){
var map__18721 = p__18720;
var map__18721__$1 = ((((!((map__18721 == null)))?((((map__18721.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18721.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18721):map__18721);
var opts = map__18721__$1;
var statearr_18723_18729 = state;
(statearr_18723_18729[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18721,map__18721__$1,opts){
return (function (val){
var statearr_18724_18730 = state;
(statearr_18724_18730[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18721,map__18721__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18725_18731 = state;
(statearr_18725_18731[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18716){
var G__18717 = cljs.core.first.call(null,seq18716);
var seq18716__$1 = cljs.core.next.call(null,seq18716);
var G__18718 = cljs.core.first.call(null,seq18716__$1);
var seq18716__$2 = cljs.core.next.call(null,seq18716__$1);
var G__18719 = cljs.core.first.call(null,seq18716__$2);
var seq18716__$3 = cljs.core.next.call(null,seq18716__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18717,G__18718,G__18719,seq18716__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18895 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18895 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18896){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18896 = meta18896;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18897,meta18896__$1){
var self__ = this;
var _18897__$1 = this;
return (new cljs.core.async.t_cljs$core$async18895(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18896__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18897){
var self__ = this;
var _18897__$1 = this;
return self__.meta18896;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18896","meta18896",-576690687,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18895.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18895.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18895";

cljs.core.async.t_cljs$core$async18895.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18895");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18895 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18895(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18896){
return (new cljs.core.async.t_cljs$core$async18895(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18896));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18895(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8447__auto___19058 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___19058,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___19058,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18995){
var state_val_18996 = (state_18995[(1)]);
if((state_val_18996 === (7))){
var inst_18913 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
var statearr_18997_19059 = state_18995__$1;
(statearr_18997_19059[(2)] = inst_18913);

(statearr_18997_19059[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (20))){
var inst_18925 = (state_18995[(7)]);
var state_18995__$1 = state_18995;
var statearr_18998_19060 = state_18995__$1;
(statearr_18998_19060[(2)] = inst_18925);

(statearr_18998_19060[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (27))){
var state_18995__$1 = state_18995;
var statearr_18999_19061 = state_18995__$1;
(statearr_18999_19061[(2)] = null);

(statearr_18999_19061[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (1))){
var inst_18901 = (state_18995[(8)]);
var inst_18901__$1 = calc_state.call(null);
var inst_18903 = (inst_18901__$1 == null);
var inst_18904 = cljs.core.not.call(null,inst_18903);
var state_18995__$1 = (function (){var statearr_19000 = state_18995;
(statearr_19000[(8)] = inst_18901__$1);

return statearr_19000;
})();
if(inst_18904){
var statearr_19001_19062 = state_18995__$1;
(statearr_19001_19062[(1)] = (2));

} else {
var statearr_19002_19063 = state_18995__$1;
(statearr_19002_19063[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (24))){
var inst_18948 = (state_18995[(9)]);
var inst_18955 = (state_18995[(10)]);
var inst_18969 = (state_18995[(11)]);
var inst_18969__$1 = inst_18948.call(null,inst_18955);
var state_18995__$1 = (function (){var statearr_19003 = state_18995;
(statearr_19003[(11)] = inst_18969__$1);

return statearr_19003;
})();
if(cljs.core.truth_(inst_18969__$1)){
var statearr_19004_19064 = state_18995__$1;
(statearr_19004_19064[(1)] = (29));

} else {
var statearr_19005_19065 = state_18995__$1;
(statearr_19005_19065[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (4))){
var inst_18916 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
if(cljs.core.truth_(inst_18916)){
var statearr_19006_19066 = state_18995__$1;
(statearr_19006_19066[(1)] = (8));

} else {
var statearr_19007_19067 = state_18995__$1;
(statearr_19007_19067[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (15))){
var inst_18942 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
if(cljs.core.truth_(inst_18942)){
var statearr_19008_19068 = state_18995__$1;
(statearr_19008_19068[(1)] = (19));

} else {
var statearr_19009_19069 = state_18995__$1;
(statearr_19009_19069[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (21))){
var inst_18947 = (state_18995[(12)]);
var inst_18947__$1 = (state_18995[(2)]);
var inst_18948 = cljs.core.get.call(null,inst_18947__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18949 = cljs.core.get.call(null,inst_18947__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18950 = cljs.core.get.call(null,inst_18947__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18995__$1 = (function (){var statearr_19010 = state_18995;
(statearr_19010[(9)] = inst_18948);

(statearr_19010[(12)] = inst_18947__$1);

(statearr_19010[(13)] = inst_18949);

return statearr_19010;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18995__$1,(22),inst_18950);
} else {
if((state_val_18996 === (31))){
var inst_18977 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
if(cljs.core.truth_(inst_18977)){
var statearr_19011_19070 = state_18995__$1;
(statearr_19011_19070[(1)] = (32));

} else {
var statearr_19012_19071 = state_18995__$1;
(statearr_19012_19071[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (32))){
var inst_18954 = (state_18995[(14)]);
var state_18995__$1 = state_18995;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18995__$1,(35),out,inst_18954);
} else {
if((state_val_18996 === (33))){
var inst_18947 = (state_18995[(12)]);
var inst_18925 = inst_18947;
var state_18995__$1 = (function (){var statearr_19013 = state_18995;
(statearr_19013[(7)] = inst_18925);

return statearr_19013;
})();
var statearr_19014_19072 = state_18995__$1;
(statearr_19014_19072[(2)] = null);

(statearr_19014_19072[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (13))){
var inst_18925 = (state_18995[(7)]);
var inst_18932 = inst_18925.cljs$lang$protocol_mask$partition0$;
var inst_18933 = (inst_18932 & (64));
var inst_18934 = inst_18925.cljs$core$ISeq$;
var inst_18935 = (inst_18933) || (inst_18934);
var state_18995__$1 = state_18995;
if(cljs.core.truth_(inst_18935)){
var statearr_19015_19073 = state_18995__$1;
(statearr_19015_19073[(1)] = (16));

} else {
var statearr_19016_19074 = state_18995__$1;
(statearr_19016_19074[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (22))){
var inst_18955 = (state_18995[(10)]);
var inst_18954 = (state_18995[(14)]);
var inst_18953 = (state_18995[(2)]);
var inst_18954__$1 = cljs.core.nth.call(null,inst_18953,(0),null);
var inst_18955__$1 = cljs.core.nth.call(null,inst_18953,(1),null);
var inst_18956 = (inst_18954__$1 == null);
var inst_18957 = cljs.core._EQ_.call(null,inst_18955__$1,change);
var inst_18958 = (inst_18956) || (inst_18957);
var state_18995__$1 = (function (){var statearr_19017 = state_18995;
(statearr_19017[(10)] = inst_18955__$1);

(statearr_19017[(14)] = inst_18954__$1);

return statearr_19017;
})();
if(cljs.core.truth_(inst_18958)){
var statearr_19018_19075 = state_18995__$1;
(statearr_19018_19075[(1)] = (23));

} else {
var statearr_19019_19076 = state_18995__$1;
(statearr_19019_19076[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (36))){
var inst_18947 = (state_18995[(12)]);
var inst_18925 = inst_18947;
var state_18995__$1 = (function (){var statearr_19020 = state_18995;
(statearr_19020[(7)] = inst_18925);

return statearr_19020;
})();
var statearr_19021_19077 = state_18995__$1;
(statearr_19021_19077[(2)] = null);

(statearr_19021_19077[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (29))){
var inst_18969 = (state_18995[(11)]);
var state_18995__$1 = state_18995;
var statearr_19022_19078 = state_18995__$1;
(statearr_19022_19078[(2)] = inst_18969);

(statearr_19022_19078[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (6))){
var state_18995__$1 = state_18995;
var statearr_19023_19079 = state_18995__$1;
(statearr_19023_19079[(2)] = false);

(statearr_19023_19079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (28))){
var inst_18965 = (state_18995[(2)]);
var inst_18966 = calc_state.call(null);
var inst_18925 = inst_18966;
var state_18995__$1 = (function (){var statearr_19024 = state_18995;
(statearr_19024[(7)] = inst_18925);

(statearr_19024[(15)] = inst_18965);

return statearr_19024;
})();
var statearr_19025_19080 = state_18995__$1;
(statearr_19025_19080[(2)] = null);

(statearr_19025_19080[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (25))){
var inst_18991 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
var statearr_19026_19081 = state_18995__$1;
(statearr_19026_19081[(2)] = inst_18991);

(statearr_19026_19081[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (34))){
var inst_18989 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
var statearr_19027_19082 = state_18995__$1;
(statearr_19027_19082[(2)] = inst_18989);

(statearr_19027_19082[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (17))){
var state_18995__$1 = state_18995;
var statearr_19028_19083 = state_18995__$1;
(statearr_19028_19083[(2)] = false);

(statearr_19028_19083[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (3))){
var state_18995__$1 = state_18995;
var statearr_19029_19084 = state_18995__$1;
(statearr_19029_19084[(2)] = false);

(statearr_19029_19084[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (12))){
var inst_18993 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18995__$1,inst_18993);
} else {
if((state_val_18996 === (2))){
var inst_18901 = (state_18995[(8)]);
var inst_18906 = inst_18901.cljs$lang$protocol_mask$partition0$;
var inst_18907 = (inst_18906 & (64));
var inst_18908 = inst_18901.cljs$core$ISeq$;
var inst_18909 = (inst_18907) || (inst_18908);
var state_18995__$1 = state_18995;
if(cljs.core.truth_(inst_18909)){
var statearr_19030_19085 = state_18995__$1;
(statearr_19030_19085[(1)] = (5));

} else {
var statearr_19031_19086 = state_18995__$1;
(statearr_19031_19086[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (23))){
var inst_18954 = (state_18995[(14)]);
var inst_18960 = (inst_18954 == null);
var state_18995__$1 = state_18995;
if(cljs.core.truth_(inst_18960)){
var statearr_19032_19087 = state_18995__$1;
(statearr_19032_19087[(1)] = (26));

} else {
var statearr_19033_19088 = state_18995__$1;
(statearr_19033_19088[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (35))){
var inst_18980 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
if(cljs.core.truth_(inst_18980)){
var statearr_19034_19089 = state_18995__$1;
(statearr_19034_19089[(1)] = (36));

} else {
var statearr_19035_19090 = state_18995__$1;
(statearr_19035_19090[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (19))){
var inst_18925 = (state_18995[(7)]);
var inst_18944 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18925);
var state_18995__$1 = state_18995;
var statearr_19036_19091 = state_18995__$1;
(statearr_19036_19091[(2)] = inst_18944);

(statearr_19036_19091[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (11))){
var inst_18925 = (state_18995[(7)]);
var inst_18929 = (inst_18925 == null);
var inst_18930 = cljs.core.not.call(null,inst_18929);
var state_18995__$1 = state_18995;
if(inst_18930){
var statearr_19037_19092 = state_18995__$1;
(statearr_19037_19092[(1)] = (13));

} else {
var statearr_19038_19093 = state_18995__$1;
(statearr_19038_19093[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (9))){
var inst_18901 = (state_18995[(8)]);
var state_18995__$1 = state_18995;
var statearr_19039_19094 = state_18995__$1;
(statearr_19039_19094[(2)] = inst_18901);

(statearr_19039_19094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (5))){
var state_18995__$1 = state_18995;
var statearr_19040_19095 = state_18995__$1;
(statearr_19040_19095[(2)] = true);

(statearr_19040_19095[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (14))){
var state_18995__$1 = state_18995;
var statearr_19041_19096 = state_18995__$1;
(statearr_19041_19096[(2)] = false);

(statearr_19041_19096[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (26))){
var inst_18955 = (state_18995[(10)]);
var inst_18962 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18955);
var state_18995__$1 = state_18995;
var statearr_19042_19097 = state_18995__$1;
(statearr_19042_19097[(2)] = inst_18962);

(statearr_19042_19097[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (16))){
var state_18995__$1 = state_18995;
var statearr_19043_19098 = state_18995__$1;
(statearr_19043_19098[(2)] = true);

(statearr_19043_19098[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (38))){
var inst_18985 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
var statearr_19044_19099 = state_18995__$1;
(statearr_19044_19099[(2)] = inst_18985);

(statearr_19044_19099[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (30))){
var inst_18948 = (state_18995[(9)]);
var inst_18955 = (state_18995[(10)]);
var inst_18949 = (state_18995[(13)]);
var inst_18972 = cljs.core.empty_QMARK_.call(null,inst_18948);
var inst_18973 = inst_18949.call(null,inst_18955);
var inst_18974 = cljs.core.not.call(null,inst_18973);
var inst_18975 = (inst_18972) && (inst_18974);
var state_18995__$1 = state_18995;
var statearr_19045_19100 = state_18995__$1;
(statearr_19045_19100[(2)] = inst_18975);

(statearr_19045_19100[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (10))){
var inst_18901 = (state_18995[(8)]);
var inst_18921 = (state_18995[(2)]);
var inst_18922 = cljs.core.get.call(null,inst_18921,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18923 = cljs.core.get.call(null,inst_18921,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18924 = cljs.core.get.call(null,inst_18921,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18925 = inst_18901;
var state_18995__$1 = (function (){var statearr_19046 = state_18995;
(statearr_19046[(16)] = inst_18922);

(statearr_19046[(17)] = inst_18924);

(statearr_19046[(18)] = inst_18923);

(statearr_19046[(7)] = inst_18925);

return statearr_19046;
})();
var statearr_19047_19101 = state_18995__$1;
(statearr_19047_19101[(2)] = null);

(statearr_19047_19101[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (18))){
var inst_18939 = (state_18995[(2)]);
var state_18995__$1 = state_18995;
var statearr_19048_19102 = state_18995__$1;
(statearr_19048_19102[(2)] = inst_18939);

(statearr_19048_19102[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (37))){
var state_18995__$1 = state_18995;
var statearr_19049_19103 = state_18995__$1;
(statearr_19049_19103[(2)] = null);

(statearr_19049_19103[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18996 === (8))){
var inst_18901 = (state_18995[(8)]);
var inst_18918 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18901);
var state_18995__$1 = state_18995;
var statearr_19050_19104 = state_18995__$1;
(statearr_19050_19104[(2)] = inst_18918);

(statearr_19050_19104[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___19058,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8335__auto__,c__8447__auto___19058,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8336__auto__ = null;
var cljs$core$async$mix_$_state_machine__8336__auto____0 = (function (){
var statearr_19054 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19054[(0)] = cljs$core$async$mix_$_state_machine__8336__auto__);

(statearr_19054[(1)] = (1));

return statearr_19054;
});
var cljs$core$async$mix_$_state_machine__8336__auto____1 = (function (state_18995){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_18995);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19055){if((e19055 instanceof Object)){
var ex__8339__auto__ = e19055;
var statearr_19056_19105 = state_18995;
(statearr_19056_19105[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18995);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19055;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19106 = state_18995;
state_18995 = G__19106;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8336__auto__ = function(state_18995){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8336__auto____1.call(this,state_18995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8336__auto____0;
cljs$core$async$mix_$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8336__auto____1;
return cljs$core$async$mix_$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___19058,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8449__auto__ = (function (){var statearr_19057 = f__8448__auto__.call(null);
(statearr_19057[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___19058);

return statearr_19057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___19058,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19107 = [];
var len__5726__auto___19110 = arguments.length;
var i__5727__auto___19111 = (0);
while(true){
if((i__5727__auto___19111 < len__5726__auto___19110)){
args19107.push((arguments[i__5727__auto___19111]));

var G__19112 = (i__5727__auto___19111 + (1));
i__5727__auto___19111 = G__19112;
continue;
} else {
}
break;
}

var G__19109 = args19107.length;
switch (G__19109) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19107.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19115 = [];
var len__5726__auto___19240 = arguments.length;
var i__5727__auto___19241 = (0);
while(true){
if((i__5727__auto___19241 < len__5726__auto___19240)){
args19115.push((arguments[i__5727__auto___19241]));

var G__19242 = (i__5727__auto___19241 + (1));
i__5727__auto___19241 = G__19242;
continue;
} else {
}
break;
}

var G__19117 = args19115.length;
switch (G__19117) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19115.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19114_SHARP_){
if(cljs.core.truth_(p1__19114_SHARP_.call(null,topic))){
return p1__19114_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19114_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19118 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19118 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19119){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19119 = meta19119;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19120,meta19119__$1){
var self__ = this;
var _19120__$1 = this;
return (new cljs.core.async.t_cljs$core$async19118(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19119__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19120){
var self__ = this;
var _19120__$1 = this;
return self__.meta19119;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19118.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19118.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19119","meta19119",-2119293767,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19118.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19118.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19118";

cljs.core.async.t_cljs$core$async19118.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19118");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19118 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19118(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19119){
return (new cljs.core.async.t_cljs$core$async19118(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19119));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19118(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8447__auto___19244 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___19244,mults,ensure_mult,p){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___19244,mults,ensure_mult,p){
return (function (state_19192){
var state_val_19193 = (state_19192[(1)]);
if((state_val_19193 === (7))){
var inst_19188 = (state_19192[(2)]);
var state_19192__$1 = state_19192;
var statearr_19194_19245 = state_19192__$1;
(statearr_19194_19245[(2)] = inst_19188);

(statearr_19194_19245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (20))){
var state_19192__$1 = state_19192;
var statearr_19195_19246 = state_19192__$1;
(statearr_19195_19246[(2)] = null);

(statearr_19195_19246[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (1))){
var state_19192__$1 = state_19192;
var statearr_19196_19247 = state_19192__$1;
(statearr_19196_19247[(2)] = null);

(statearr_19196_19247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (24))){
var inst_19171 = (state_19192[(7)]);
var inst_19180 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19171);
var state_19192__$1 = state_19192;
var statearr_19197_19248 = state_19192__$1;
(statearr_19197_19248[(2)] = inst_19180);

(statearr_19197_19248[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (4))){
var inst_19123 = (state_19192[(8)]);
var inst_19123__$1 = (state_19192[(2)]);
var inst_19124 = (inst_19123__$1 == null);
var state_19192__$1 = (function (){var statearr_19198 = state_19192;
(statearr_19198[(8)] = inst_19123__$1);

return statearr_19198;
})();
if(cljs.core.truth_(inst_19124)){
var statearr_19199_19249 = state_19192__$1;
(statearr_19199_19249[(1)] = (5));

} else {
var statearr_19200_19250 = state_19192__$1;
(statearr_19200_19250[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (15))){
var inst_19165 = (state_19192[(2)]);
var state_19192__$1 = state_19192;
var statearr_19201_19251 = state_19192__$1;
(statearr_19201_19251[(2)] = inst_19165);

(statearr_19201_19251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (21))){
var inst_19185 = (state_19192[(2)]);
var state_19192__$1 = (function (){var statearr_19202 = state_19192;
(statearr_19202[(9)] = inst_19185);

return statearr_19202;
})();
var statearr_19203_19252 = state_19192__$1;
(statearr_19203_19252[(2)] = null);

(statearr_19203_19252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (13))){
var inst_19147 = (state_19192[(10)]);
var inst_19149 = cljs.core.chunked_seq_QMARK_.call(null,inst_19147);
var state_19192__$1 = state_19192;
if(inst_19149){
var statearr_19204_19253 = state_19192__$1;
(statearr_19204_19253[(1)] = (16));

} else {
var statearr_19205_19254 = state_19192__$1;
(statearr_19205_19254[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (22))){
var inst_19177 = (state_19192[(2)]);
var state_19192__$1 = state_19192;
if(cljs.core.truth_(inst_19177)){
var statearr_19206_19255 = state_19192__$1;
(statearr_19206_19255[(1)] = (23));

} else {
var statearr_19207_19256 = state_19192__$1;
(statearr_19207_19256[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (6))){
var inst_19173 = (state_19192[(11)]);
var inst_19171 = (state_19192[(7)]);
var inst_19123 = (state_19192[(8)]);
var inst_19171__$1 = topic_fn.call(null,inst_19123);
var inst_19172 = cljs.core.deref.call(null,mults);
var inst_19173__$1 = cljs.core.get.call(null,inst_19172,inst_19171__$1);
var state_19192__$1 = (function (){var statearr_19208 = state_19192;
(statearr_19208[(11)] = inst_19173__$1);

(statearr_19208[(7)] = inst_19171__$1);

return statearr_19208;
})();
if(cljs.core.truth_(inst_19173__$1)){
var statearr_19209_19257 = state_19192__$1;
(statearr_19209_19257[(1)] = (19));

} else {
var statearr_19210_19258 = state_19192__$1;
(statearr_19210_19258[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (25))){
var inst_19182 = (state_19192[(2)]);
var state_19192__$1 = state_19192;
var statearr_19211_19259 = state_19192__$1;
(statearr_19211_19259[(2)] = inst_19182);

(statearr_19211_19259[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (17))){
var inst_19147 = (state_19192[(10)]);
var inst_19156 = cljs.core.first.call(null,inst_19147);
var inst_19157 = cljs.core.async.muxch_STAR_.call(null,inst_19156);
var inst_19158 = cljs.core.async.close_BANG_.call(null,inst_19157);
var inst_19159 = cljs.core.next.call(null,inst_19147);
var inst_19133 = inst_19159;
var inst_19134 = null;
var inst_19135 = (0);
var inst_19136 = (0);
var state_19192__$1 = (function (){var statearr_19212 = state_19192;
(statearr_19212[(12)] = inst_19134);

(statearr_19212[(13)] = inst_19135);

(statearr_19212[(14)] = inst_19133);

(statearr_19212[(15)] = inst_19136);

(statearr_19212[(16)] = inst_19158);

return statearr_19212;
})();
var statearr_19213_19260 = state_19192__$1;
(statearr_19213_19260[(2)] = null);

(statearr_19213_19260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (3))){
var inst_19190 = (state_19192[(2)]);
var state_19192__$1 = state_19192;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19192__$1,inst_19190);
} else {
if((state_val_19193 === (12))){
var inst_19167 = (state_19192[(2)]);
var state_19192__$1 = state_19192;
var statearr_19214_19261 = state_19192__$1;
(statearr_19214_19261[(2)] = inst_19167);

(statearr_19214_19261[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (2))){
var state_19192__$1 = state_19192;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19192__$1,(4),ch);
} else {
if((state_val_19193 === (23))){
var state_19192__$1 = state_19192;
var statearr_19215_19262 = state_19192__$1;
(statearr_19215_19262[(2)] = null);

(statearr_19215_19262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (19))){
var inst_19173 = (state_19192[(11)]);
var inst_19123 = (state_19192[(8)]);
var inst_19175 = cljs.core.async.muxch_STAR_.call(null,inst_19173);
var state_19192__$1 = state_19192;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19192__$1,(22),inst_19175,inst_19123);
} else {
if((state_val_19193 === (11))){
var inst_19133 = (state_19192[(14)]);
var inst_19147 = (state_19192[(10)]);
var inst_19147__$1 = cljs.core.seq.call(null,inst_19133);
var state_19192__$1 = (function (){var statearr_19216 = state_19192;
(statearr_19216[(10)] = inst_19147__$1);

return statearr_19216;
})();
if(inst_19147__$1){
var statearr_19217_19263 = state_19192__$1;
(statearr_19217_19263[(1)] = (13));

} else {
var statearr_19218_19264 = state_19192__$1;
(statearr_19218_19264[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (9))){
var inst_19169 = (state_19192[(2)]);
var state_19192__$1 = state_19192;
var statearr_19219_19265 = state_19192__$1;
(statearr_19219_19265[(2)] = inst_19169);

(statearr_19219_19265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (5))){
var inst_19130 = cljs.core.deref.call(null,mults);
var inst_19131 = cljs.core.vals.call(null,inst_19130);
var inst_19132 = cljs.core.seq.call(null,inst_19131);
var inst_19133 = inst_19132;
var inst_19134 = null;
var inst_19135 = (0);
var inst_19136 = (0);
var state_19192__$1 = (function (){var statearr_19220 = state_19192;
(statearr_19220[(12)] = inst_19134);

(statearr_19220[(13)] = inst_19135);

(statearr_19220[(14)] = inst_19133);

(statearr_19220[(15)] = inst_19136);

return statearr_19220;
})();
var statearr_19221_19266 = state_19192__$1;
(statearr_19221_19266[(2)] = null);

(statearr_19221_19266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (14))){
var state_19192__$1 = state_19192;
var statearr_19225_19267 = state_19192__$1;
(statearr_19225_19267[(2)] = null);

(statearr_19225_19267[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (16))){
var inst_19147 = (state_19192[(10)]);
var inst_19151 = cljs.core.chunk_first.call(null,inst_19147);
var inst_19152 = cljs.core.chunk_rest.call(null,inst_19147);
var inst_19153 = cljs.core.count.call(null,inst_19151);
var inst_19133 = inst_19152;
var inst_19134 = inst_19151;
var inst_19135 = inst_19153;
var inst_19136 = (0);
var state_19192__$1 = (function (){var statearr_19226 = state_19192;
(statearr_19226[(12)] = inst_19134);

(statearr_19226[(13)] = inst_19135);

(statearr_19226[(14)] = inst_19133);

(statearr_19226[(15)] = inst_19136);

return statearr_19226;
})();
var statearr_19227_19268 = state_19192__$1;
(statearr_19227_19268[(2)] = null);

(statearr_19227_19268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (10))){
var inst_19134 = (state_19192[(12)]);
var inst_19135 = (state_19192[(13)]);
var inst_19133 = (state_19192[(14)]);
var inst_19136 = (state_19192[(15)]);
var inst_19141 = cljs.core._nth.call(null,inst_19134,inst_19136);
var inst_19142 = cljs.core.async.muxch_STAR_.call(null,inst_19141);
var inst_19143 = cljs.core.async.close_BANG_.call(null,inst_19142);
var inst_19144 = (inst_19136 + (1));
var tmp19222 = inst_19134;
var tmp19223 = inst_19135;
var tmp19224 = inst_19133;
var inst_19133__$1 = tmp19224;
var inst_19134__$1 = tmp19222;
var inst_19135__$1 = tmp19223;
var inst_19136__$1 = inst_19144;
var state_19192__$1 = (function (){var statearr_19228 = state_19192;
(statearr_19228[(17)] = inst_19143);

(statearr_19228[(12)] = inst_19134__$1);

(statearr_19228[(13)] = inst_19135__$1);

(statearr_19228[(14)] = inst_19133__$1);

(statearr_19228[(15)] = inst_19136__$1);

return statearr_19228;
})();
var statearr_19229_19269 = state_19192__$1;
(statearr_19229_19269[(2)] = null);

(statearr_19229_19269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (18))){
var inst_19162 = (state_19192[(2)]);
var state_19192__$1 = state_19192;
var statearr_19230_19270 = state_19192__$1;
(statearr_19230_19270[(2)] = inst_19162);

(statearr_19230_19270[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19193 === (8))){
var inst_19135 = (state_19192[(13)]);
var inst_19136 = (state_19192[(15)]);
var inst_19138 = (inst_19136 < inst_19135);
var inst_19139 = inst_19138;
var state_19192__$1 = state_19192;
if(cljs.core.truth_(inst_19139)){
var statearr_19231_19271 = state_19192__$1;
(statearr_19231_19271[(1)] = (10));

} else {
var statearr_19232_19272 = state_19192__$1;
(statearr_19232_19272[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___19244,mults,ensure_mult,p))
;
return ((function (switch__8335__auto__,c__8447__auto___19244,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19236 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19236[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19236[(1)] = (1));

return statearr_19236;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19192){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19192);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19237){if((e19237 instanceof Object)){
var ex__8339__auto__ = e19237;
var statearr_19238_19273 = state_19192;
(statearr_19238_19273[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19192);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19237;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19274 = state_19192;
state_19192 = G__19274;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19192){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___19244,mults,ensure_mult,p))
})();
var state__8449__auto__ = (function (){var statearr_19239 = f__8448__auto__.call(null);
(statearr_19239[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___19244);

return statearr_19239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___19244,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19275 = [];
var len__5726__auto___19278 = arguments.length;
var i__5727__auto___19279 = (0);
while(true){
if((i__5727__auto___19279 < len__5726__auto___19278)){
args19275.push((arguments[i__5727__auto___19279]));

var G__19280 = (i__5727__auto___19279 + (1));
i__5727__auto___19279 = G__19280;
continue;
} else {
}
break;
}

var G__19277 = args19275.length;
switch (G__19277) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19275.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19282 = [];
var len__5726__auto___19285 = arguments.length;
var i__5727__auto___19286 = (0);
while(true){
if((i__5727__auto___19286 < len__5726__auto___19285)){
args19282.push((arguments[i__5727__auto___19286]));

var G__19287 = (i__5727__auto___19286 + (1));
i__5727__auto___19286 = G__19287;
continue;
} else {
}
break;
}

var G__19284 = args19282.length;
switch (G__19284) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19282.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19289 = [];
var len__5726__auto___19360 = arguments.length;
var i__5727__auto___19361 = (0);
while(true){
if((i__5727__auto___19361 < len__5726__auto___19360)){
args19289.push((arguments[i__5727__auto___19361]));

var G__19362 = (i__5727__auto___19361 + (1));
i__5727__auto___19361 = G__19362;
continue;
} else {
}
break;
}

var G__19291 = args19289.length;
switch (G__19291) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19289.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8447__auto___19364 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___19364,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___19364,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19330){
var state_val_19331 = (state_19330[(1)]);
if((state_val_19331 === (7))){
var state_19330__$1 = state_19330;
var statearr_19332_19365 = state_19330__$1;
(statearr_19332_19365[(2)] = null);

(statearr_19332_19365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (1))){
var state_19330__$1 = state_19330;
var statearr_19333_19366 = state_19330__$1;
(statearr_19333_19366[(2)] = null);

(statearr_19333_19366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (4))){
var inst_19294 = (state_19330[(7)]);
var inst_19296 = (inst_19294 < cnt);
var state_19330__$1 = state_19330;
if(cljs.core.truth_(inst_19296)){
var statearr_19334_19367 = state_19330__$1;
(statearr_19334_19367[(1)] = (6));

} else {
var statearr_19335_19368 = state_19330__$1;
(statearr_19335_19368[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (15))){
var inst_19326 = (state_19330[(2)]);
var state_19330__$1 = state_19330;
var statearr_19336_19369 = state_19330__$1;
(statearr_19336_19369[(2)] = inst_19326);

(statearr_19336_19369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (13))){
var inst_19319 = cljs.core.async.close_BANG_.call(null,out);
var state_19330__$1 = state_19330;
var statearr_19337_19370 = state_19330__$1;
(statearr_19337_19370[(2)] = inst_19319);

(statearr_19337_19370[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (6))){
var state_19330__$1 = state_19330;
var statearr_19338_19371 = state_19330__$1;
(statearr_19338_19371[(2)] = null);

(statearr_19338_19371[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (3))){
var inst_19328 = (state_19330[(2)]);
var state_19330__$1 = state_19330;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19330__$1,inst_19328);
} else {
if((state_val_19331 === (12))){
var inst_19316 = (state_19330[(8)]);
var inst_19316__$1 = (state_19330[(2)]);
var inst_19317 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19316__$1);
var state_19330__$1 = (function (){var statearr_19339 = state_19330;
(statearr_19339[(8)] = inst_19316__$1);

return statearr_19339;
})();
if(cljs.core.truth_(inst_19317)){
var statearr_19340_19372 = state_19330__$1;
(statearr_19340_19372[(1)] = (13));

} else {
var statearr_19341_19373 = state_19330__$1;
(statearr_19341_19373[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (2))){
var inst_19293 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19294 = (0);
var state_19330__$1 = (function (){var statearr_19342 = state_19330;
(statearr_19342[(9)] = inst_19293);

(statearr_19342[(7)] = inst_19294);

return statearr_19342;
})();
var statearr_19343_19374 = state_19330__$1;
(statearr_19343_19374[(2)] = null);

(statearr_19343_19374[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (11))){
var inst_19294 = (state_19330[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19330,(10),Object,null,(9));
var inst_19303 = chs__$1.call(null,inst_19294);
var inst_19304 = done.call(null,inst_19294);
var inst_19305 = cljs.core.async.take_BANG_.call(null,inst_19303,inst_19304);
var state_19330__$1 = state_19330;
var statearr_19344_19375 = state_19330__$1;
(statearr_19344_19375[(2)] = inst_19305);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19330__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (9))){
var inst_19294 = (state_19330[(7)]);
var inst_19307 = (state_19330[(2)]);
var inst_19308 = (inst_19294 + (1));
var inst_19294__$1 = inst_19308;
var state_19330__$1 = (function (){var statearr_19345 = state_19330;
(statearr_19345[(10)] = inst_19307);

(statearr_19345[(7)] = inst_19294__$1);

return statearr_19345;
})();
var statearr_19346_19376 = state_19330__$1;
(statearr_19346_19376[(2)] = null);

(statearr_19346_19376[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (5))){
var inst_19314 = (state_19330[(2)]);
var state_19330__$1 = (function (){var statearr_19347 = state_19330;
(statearr_19347[(11)] = inst_19314);

return statearr_19347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19330__$1,(12),dchan);
} else {
if((state_val_19331 === (14))){
var inst_19316 = (state_19330[(8)]);
var inst_19321 = cljs.core.apply.call(null,f,inst_19316);
var state_19330__$1 = state_19330;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19330__$1,(16),out,inst_19321);
} else {
if((state_val_19331 === (16))){
var inst_19323 = (state_19330[(2)]);
var state_19330__$1 = (function (){var statearr_19348 = state_19330;
(statearr_19348[(12)] = inst_19323);

return statearr_19348;
})();
var statearr_19349_19377 = state_19330__$1;
(statearr_19349_19377[(2)] = null);

(statearr_19349_19377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (10))){
var inst_19298 = (state_19330[(2)]);
var inst_19299 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19330__$1 = (function (){var statearr_19350 = state_19330;
(statearr_19350[(13)] = inst_19298);

return statearr_19350;
})();
var statearr_19351_19378 = state_19330__$1;
(statearr_19351_19378[(2)] = inst_19299);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19330__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19331 === (8))){
var inst_19312 = (state_19330[(2)]);
var state_19330__$1 = state_19330;
var statearr_19352_19379 = state_19330__$1;
(statearr_19352_19379[(2)] = inst_19312);

(statearr_19352_19379[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___19364,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8335__auto__,c__8447__auto___19364,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19356 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19356[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19356[(1)] = (1));

return statearr_19356;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19330){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19357){if((e19357 instanceof Object)){
var ex__8339__auto__ = e19357;
var statearr_19358_19380 = state_19330;
(statearr_19358_19380[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19330);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19357;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19381 = state_19330;
state_19330 = G__19381;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19330){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___19364,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8449__auto__ = (function (){var statearr_19359 = f__8448__auto__.call(null);
(statearr_19359[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___19364);

return statearr_19359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___19364,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19383 = [];
var len__5726__auto___19439 = arguments.length;
var i__5727__auto___19440 = (0);
while(true){
if((i__5727__auto___19440 < len__5726__auto___19439)){
args19383.push((arguments[i__5727__auto___19440]));

var G__19441 = (i__5727__auto___19440 + (1));
i__5727__auto___19440 = G__19441;
continue;
} else {
}
break;
}

var G__19385 = args19383.length;
switch (G__19385) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19383.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___19443 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___19443,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___19443,out){
return (function (state_19415){
var state_val_19416 = (state_19415[(1)]);
if((state_val_19416 === (7))){
var inst_19395 = (state_19415[(7)]);
var inst_19394 = (state_19415[(8)]);
var inst_19394__$1 = (state_19415[(2)]);
var inst_19395__$1 = cljs.core.nth.call(null,inst_19394__$1,(0),null);
var inst_19396 = cljs.core.nth.call(null,inst_19394__$1,(1),null);
var inst_19397 = (inst_19395__$1 == null);
var state_19415__$1 = (function (){var statearr_19417 = state_19415;
(statearr_19417[(7)] = inst_19395__$1);

(statearr_19417[(8)] = inst_19394__$1);

(statearr_19417[(9)] = inst_19396);

return statearr_19417;
})();
if(cljs.core.truth_(inst_19397)){
var statearr_19418_19444 = state_19415__$1;
(statearr_19418_19444[(1)] = (8));

} else {
var statearr_19419_19445 = state_19415__$1;
(statearr_19419_19445[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (1))){
var inst_19386 = cljs.core.vec.call(null,chs);
var inst_19387 = inst_19386;
var state_19415__$1 = (function (){var statearr_19420 = state_19415;
(statearr_19420[(10)] = inst_19387);

return statearr_19420;
})();
var statearr_19421_19446 = state_19415__$1;
(statearr_19421_19446[(2)] = null);

(statearr_19421_19446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (4))){
var inst_19387 = (state_19415[(10)]);
var state_19415__$1 = state_19415;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19415__$1,(7),inst_19387);
} else {
if((state_val_19416 === (6))){
var inst_19411 = (state_19415[(2)]);
var state_19415__$1 = state_19415;
var statearr_19422_19447 = state_19415__$1;
(statearr_19422_19447[(2)] = inst_19411);

(statearr_19422_19447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (3))){
var inst_19413 = (state_19415[(2)]);
var state_19415__$1 = state_19415;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19415__$1,inst_19413);
} else {
if((state_val_19416 === (2))){
var inst_19387 = (state_19415[(10)]);
var inst_19389 = cljs.core.count.call(null,inst_19387);
var inst_19390 = (inst_19389 > (0));
var state_19415__$1 = state_19415;
if(cljs.core.truth_(inst_19390)){
var statearr_19424_19448 = state_19415__$1;
(statearr_19424_19448[(1)] = (4));

} else {
var statearr_19425_19449 = state_19415__$1;
(statearr_19425_19449[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (11))){
var inst_19387 = (state_19415[(10)]);
var inst_19404 = (state_19415[(2)]);
var tmp19423 = inst_19387;
var inst_19387__$1 = tmp19423;
var state_19415__$1 = (function (){var statearr_19426 = state_19415;
(statearr_19426[(10)] = inst_19387__$1);

(statearr_19426[(11)] = inst_19404);

return statearr_19426;
})();
var statearr_19427_19450 = state_19415__$1;
(statearr_19427_19450[(2)] = null);

(statearr_19427_19450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (9))){
var inst_19395 = (state_19415[(7)]);
var state_19415__$1 = state_19415;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19415__$1,(11),out,inst_19395);
} else {
if((state_val_19416 === (5))){
var inst_19409 = cljs.core.async.close_BANG_.call(null,out);
var state_19415__$1 = state_19415;
var statearr_19428_19451 = state_19415__$1;
(statearr_19428_19451[(2)] = inst_19409);

(statearr_19428_19451[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (10))){
var inst_19407 = (state_19415[(2)]);
var state_19415__$1 = state_19415;
var statearr_19429_19452 = state_19415__$1;
(statearr_19429_19452[(2)] = inst_19407);

(statearr_19429_19452[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19416 === (8))){
var inst_19387 = (state_19415[(10)]);
var inst_19395 = (state_19415[(7)]);
var inst_19394 = (state_19415[(8)]);
var inst_19396 = (state_19415[(9)]);
var inst_19399 = (function (){var cs = inst_19387;
var vec__19392 = inst_19394;
var v = inst_19395;
var c = inst_19396;
return ((function (cs,vec__19392,v,c,inst_19387,inst_19395,inst_19394,inst_19396,state_val_19416,c__8447__auto___19443,out){
return (function (p1__19382_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19382_SHARP_);
});
;})(cs,vec__19392,v,c,inst_19387,inst_19395,inst_19394,inst_19396,state_val_19416,c__8447__auto___19443,out))
})();
var inst_19400 = cljs.core.filterv.call(null,inst_19399,inst_19387);
var inst_19387__$1 = inst_19400;
var state_19415__$1 = (function (){var statearr_19430 = state_19415;
(statearr_19430[(10)] = inst_19387__$1);

return statearr_19430;
})();
var statearr_19431_19453 = state_19415__$1;
(statearr_19431_19453[(2)] = null);

(statearr_19431_19453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___19443,out))
;
return ((function (switch__8335__auto__,c__8447__auto___19443,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19435 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19435[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19435[(1)] = (1));

return statearr_19435;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19415){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19415);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19436){if((e19436 instanceof Object)){
var ex__8339__auto__ = e19436;
var statearr_19437_19454 = state_19415;
(statearr_19437_19454[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19415);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19436;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19455 = state_19415;
state_19415 = G__19455;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19415){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___19443,out))
})();
var state__8449__auto__ = (function (){var statearr_19438 = f__8448__auto__.call(null);
(statearr_19438[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___19443);

return statearr_19438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___19443,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19456 = [];
var len__5726__auto___19505 = arguments.length;
var i__5727__auto___19506 = (0);
while(true){
if((i__5727__auto___19506 < len__5726__auto___19505)){
args19456.push((arguments[i__5727__auto___19506]));

var G__19507 = (i__5727__auto___19506 + (1));
i__5727__auto___19506 = G__19507;
continue;
} else {
}
break;
}

var G__19458 = args19456.length;
switch (G__19458) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19456.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___19509 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___19509,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___19509,out){
return (function (state_19482){
var state_val_19483 = (state_19482[(1)]);
if((state_val_19483 === (7))){
var inst_19464 = (state_19482[(7)]);
var inst_19464__$1 = (state_19482[(2)]);
var inst_19465 = (inst_19464__$1 == null);
var inst_19466 = cljs.core.not.call(null,inst_19465);
var state_19482__$1 = (function (){var statearr_19484 = state_19482;
(statearr_19484[(7)] = inst_19464__$1);

return statearr_19484;
})();
if(inst_19466){
var statearr_19485_19510 = state_19482__$1;
(statearr_19485_19510[(1)] = (8));

} else {
var statearr_19486_19511 = state_19482__$1;
(statearr_19486_19511[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19483 === (1))){
var inst_19459 = (0);
var state_19482__$1 = (function (){var statearr_19487 = state_19482;
(statearr_19487[(8)] = inst_19459);

return statearr_19487;
})();
var statearr_19488_19512 = state_19482__$1;
(statearr_19488_19512[(2)] = null);

(statearr_19488_19512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19483 === (4))){
var state_19482__$1 = state_19482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19482__$1,(7),ch);
} else {
if((state_val_19483 === (6))){
var inst_19477 = (state_19482[(2)]);
var state_19482__$1 = state_19482;
var statearr_19489_19513 = state_19482__$1;
(statearr_19489_19513[(2)] = inst_19477);

(statearr_19489_19513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19483 === (3))){
var inst_19479 = (state_19482[(2)]);
var inst_19480 = cljs.core.async.close_BANG_.call(null,out);
var state_19482__$1 = (function (){var statearr_19490 = state_19482;
(statearr_19490[(9)] = inst_19479);

return statearr_19490;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19482__$1,inst_19480);
} else {
if((state_val_19483 === (2))){
var inst_19459 = (state_19482[(8)]);
var inst_19461 = (inst_19459 < n);
var state_19482__$1 = state_19482;
if(cljs.core.truth_(inst_19461)){
var statearr_19491_19514 = state_19482__$1;
(statearr_19491_19514[(1)] = (4));

} else {
var statearr_19492_19515 = state_19482__$1;
(statearr_19492_19515[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19483 === (11))){
var inst_19459 = (state_19482[(8)]);
var inst_19469 = (state_19482[(2)]);
var inst_19470 = (inst_19459 + (1));
var inst_19459__$1 = inst_19470;
var state_19482__$1 = (function (){var statearr_19493 = state_19482;
(statearr_19493[(8)] = inst_19459__$1);

(statearr_19493[(10)] = inst_19469);

return statearr_19493;
})();
var statearr_19494_19516 = state_19482__$1;
(statearr_19494_19516[(2)] = null);

(statearr_19494_19516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19483 === (9))){
var state_19482__$1 = state_19482;
var statearr_19495_19517 = state_19482__$1;
(statearr_19495_19517[(2)] = null);

(statearr_19495_19517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19483 === (5))){
var state_19482__$1 = state_19482;
var statearr_19496_19518 = state_19482__$1;
(statearr_19496_19518[(2)] = null);

(statearr_19496_19518[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19483 === (10))){
var inst_19474 = (state_19482[(2)]);
var state_19482__$1 = state_19482;
var statearr_19497_19519 = state_19482__$1;
(statearr_19497_19519[(2)] = inst_19474);

(statearr_19497_19519[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19483 === (8))){
var inst_19464 = (state_19482[(7)]);
var state_19482__$1 = state_19482;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19482__$1,(11),out,inst_19464);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___19509,out))
;
return ((function (switch__8335__auto__,c__8447__auto___19509,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19501 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19501[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19501[(1)] = (1));

return statearr_19501;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19482){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19502){if((e19502 instanceof Object)){
var ex__8339__auto__ = e19502;
var statearr_19503_19520 = state_19482;
(statearr_19503_19520[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19521 = state_19482;
state_19482 = G__19521;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19482){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___19509,out))
})();
var state__8449__auto__ = (function (){var statearr_19504 = f__8448__auto__.call(null);
(statearr_19504[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___19509);

return statearr_19504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___19509,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19529 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19529 = (function (map_LT_,f,ch,meta19530){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19530 = meta19530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19531,meta19530__$1){
var self__ = this;
var _19531__$1 = this;
return (new cljs.core.async.t_cljs$core$async19529(self__.map_LT_,self__.f,self__.ch,meta19530__$1));
});

cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19531){
var self__ = this;
var _19531__$1 = this;
return self__.meta19530;
});

cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19532 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19532 = (function (map_LT_,f,ch,meta19530,_,fn1,meta19533){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19530 = meta19530;
this._ = _;
this.fn1 = fn1;
this.meta19533 = meta19533;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19532.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19534,meta19533__$1){
var self__ = this;
var _19534__$1 = this;
return (new cljs.core.async.t_cljs$core$async19532(self__.map_LT_,self__.f,self__.ch,self__.meta19530,self__._,self__.fn1,meta19533__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19532.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19534){
var self__ = this;
var _19534__$1 = this;
return self__.meta19533;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19532.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19532.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19532.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19532.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19522_SHARP_){
return f1.call(null,(((p1__19522_SHARP_ == null))?null:self__.f.call(null,p1__19522_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19532.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19530","meta19530",-1644524842,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19529","cljs.core.async/t_cljs$core$async19529",1508598794,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19533","meta19533",-1801602470,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19532.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19532.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19532";

cljs.core.async.t_cljs$core$async19532.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19532");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19532 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19532(map_LT___$1,f__$1,ch__$1,meta19530__$1,___$2,fn1__$1,meta19533){
return (new cljs.core.async.t_cljs$core$async19532(map_LT___$1,f__$1,ch__$1,meta19530__$1,___$2,fn1__$1,meta19533));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19532(self__.map_LT_,self__.f,self__.ch,self__.meta19530,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19529.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19529.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19530","meta19530",-1644524842,null)], null);
});

cljs.core.async.t_cljs$core$async19529.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19529.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19529";

cljs.core.async.t_cljs$core$async19529.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19529");
});

cljs.core.async.__GT_t_cljs$core$async19529 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19529(map_LT___$1,f__$1,ch__$1,meta19530){
return (new cljs.core.async.t_cljs$core$async19529(map_LT___$1,f__$1,ch__$1,meta19530));
});

}

return (new cljs.core.async.t_cljs$core$async19529(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19538 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19538 = (function (map_GT_,f,ch,meta19539){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19539 = meta19539;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19538.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19540,meta19539__$1){
var self__ = this;
var _19540__$1 = this;
return (new cljs.core.async.t_cljs$core$async19538(self__.map_GT_,self__.f,self__.ch,meta19539__$1));
});

cljs.core.async.t_cljs$core$async19538.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19540){
var self__ = this;
var _19540__$1 = this;
return self__.meta19539;
});

cljs.core.async.t_cljs$core$async19538.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19538.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19538.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19538.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19538.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19538.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19538.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19539","meta19539",-698468915,null)], null);
});

cljs.core.async.t_cljs$core$async19538.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19538.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19538";

cljs.core.async.t_cljs$core$async19538.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19538");
});

cljs.core.async.__GT_t_cljs$core$async19538 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19538(map_GT___$1,f__$1,ch__$1,meta19539){
return (new cljs.core.async.t_cljs$core$async19538(map_GT___$1,f__$1,ch__$1,meta19539));
});

}

return (new cljs.core.async.t_cljs$core$async19538(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19544 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19544 = (function (filter_GT_,p,ch,meta19545){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19545 = meta19545;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19546,meta19545__$1){
var self__ = this;
var _19546__$1 = this;
return (new cljs.core.async.t_cljs$core$async19544(self__.filter_GT_,self__.p,self__.ch,meta19545__$1));
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19546){
var self__ = this;
var _19546__$1 = this;
return self__.meta19545;
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19544.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19544.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19545","meta19545",1569883502,null)], null);
});

cljs.core.async.t_cljs$core$async19544.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19544.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19544";

cljs.core.async.t_cljs$core$async19544.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19544");
});

cljs.core.async.__GT_t_cljs$core$async19544 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19544(filter_GT___$1,p__$1,ch__$1,meta19545){
return (new cljs.core.async.t_cljs$core$async19544(filter_GT___$1,p__$1,ch__$1,meta19545));
});

}

return (new cljs.core.async.t_cljs$core$async19544(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19547 = [];
var len__5726__auto___19591 = arguments.length;
var i__5727__auto___19592 = (0);
while(true){
if((i__5727__auto___19592 < len__5726__auto___19591)){
args19547.push((arguments[i__5727__auto___19592]));

var G__19593 = (i__5727__auto___19592 + (1));
i__5727__auto___19592 = G__19593;
continue;
} else {
}
break;
}

var G__19549 = args19547.length;
switch (G__19549) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19547.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___19595 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___19595,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___19595,out){
return (function (state_19570){
var state_val_19571 = (state_19570[(1)]);
if((state_val_19571 === (7))){
var inst_19566 = (state_19570[(2)]);
var state_19570__$1 = state_19570;
var statearr_19572_19596 = state_19570__$1;
(statearr_19572_19596[(2)] = inst_19566);

(statearr_19572_19596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19571 === (1))){
var state_19570__$1 = state_19570;
var statearr_19573_19597 = state_19570__$1;
(statearr_19573_19597[(2)] = null);

(statearr_19573_19597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19571 === (4))){
var inst_19552 = (state_19570[(7)]);
var inst_19552__$1 = (state_19570[(2)]);
var inst_19553 = (inst_19552__$1 == null);
var state_19570__$1 = (function (){var statearr_19574 = state_19570;
(statearr_19574[(7)] = inst_19552__$1);

return statearr_19574;
})();
if(cljs.core.truth_(inst_19553)){
var statearr_19575_19598 = state_19570__$1;
(statearr_19575_19598[(1)] = (5));

} else {
var statearr_19576_19599 = state_19570__$1;
(statearr_19576_19599[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19571 === (6))){
var inst_19552 = (state_19570[(7)]);
var inst_19557 = p.call(null,inst_19552);
var state_19570__$1 = state_19570;
if(cljs.core.truth_(inst_19557)){
var statearr_19577_19600 = state_19570__$1;
(statearr_19577_19600[(1)] = (8));

} else {
var statearr_19578_19601 = state_19570__$1;
(statearr_19578_19601[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19571 === (3))){
var inst_19568 = (state_19570[(2)]);
var state_19570__$1 = state_19570;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19570__$1,inst_19568);
} else {
if((state_val_19571 === (2))){
var state_19570__$1 = state_19570;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19570__$1,(4),ch);
} else {
if((state_val_19571 === (11))){
var inst_19560 = (state_19570[(2)]);
var state_19570__$1 = state_19570;
var statearr_19579_19602 = state_19570__$1;
(statearr_19579_19602[(2)] = inst_19560);

(statearr_19579_19602[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19571 === (9))){
var state_19570__$1 = state_19570;
var statearr_19580_19603 = state_19570__$1;
(statearr_19580_19603[(2)] = null);

(statearr_19580_19603[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19571 === (5))){
var inst_19555 = cljs.core.async.close_BANG_.call(null,out);
var state_19570__$1 = state_19570;
var statearr_19581_19604 = state_19570__$1;
(statearr_19581_19604[(2)] = inst_19555);

(statearr_19581_19604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19571 === (10))){
var inst_19563 = (state_19570[(2)]);
var state_19570__$1 = (function (){var statearr_19582 = state_19570;
(statearr_19582[(8)] = inst_19563);

return statearr_19582;
})();
var statearr_19583_19605 = state_19570__$1;
(statearr_19583_19605[(2)] = null);

(statearr_19583_19605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19571 === (8))){
var inst_19552 = (state_19570[(7)]);
var state_19570__$1 = state_19570;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19570__$1,(11),out,inst_19552);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___19595,out))
;
return ((function (switch__8335__auto__,c__8447__auto___19595,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19587 = [null,null,null,null,null,null,null,null,null];
(statearr_19587[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19587[(1)] = (1));

return statearr_19587;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19570){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19588){if((e19588 instanceof Object)){
var ex__8339__auto__ = e19588;
var statearr_19589_19606 = state_19570;
(statearr_19589_19606[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19570);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19607 = state_19570;
state_19570 = G__19607;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19570){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___19595,out))
})();
var state__8449__auto__ = (function (){var statearr_19590 = f__8448__auto__.call(null);
(statearr_19590[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___19595);

return statearr_19590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___19595,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19608 = [];
var len__5726__auto___19611 = arguments.length;
var i__5727__auto___19612 = (0);
while(true){
if((i__5727__auto___19612 < len__5726__auto___19611)){
args19608.push((arguments[i__5727__auto___19612]));

var G__19613 = (i__5727__auto___19612 + (1));
i__5727__auto___19612 = G__19613;
continue;
} else {
}
break;
}

var G__19610 = args19608.length;
switch (G__19610) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19608.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8447__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto__){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto__){
return (function (state_19780){
var state_val_19781 = (state_19780[(1)]);
if((state_val_19781 === (7))){
var inst_19776 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19782_19823 = state_19780__$1;
(statearr_19782_19823[(2)] = inst_19776);

(statearr_19782_19823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (20))){
var inst_19746 = (state_19780[(7)]);
var inst_19757 = (state_19780[(2)]);
var inst_19758 = cljs.core.next.call(null,inst_19746);
var inst_19732 = inst_19758;
var inst_19733 = null;
var inst_19734 = (0);
var inst_19735 = (0);
var state_19780__$1 = (function (){var statearr_19783 = state_19780;
(statearr_19783[(8)] = inst_19757);

(statearr_19783[(9)] = inst_19733);

(statearr_19783[(10)] = inst_19734);

(statearr_19783[(11)] = inst_19735);

(statearr_19783[(12)] = inst_19732);

return statearr_19783;
})();
var statearr_19784_19824 = state_19780__$1;
(statearr_19784_19824[(2)] = null);

(statearr_19784_19824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (1))){
var state_19780__$1 = state_19780;
var statearr_19785_19825 = state_19780__$1;
(statearr_19785_19825[(2)] = null);

(statearr_19785_19825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (4))){
var inst_19721 = (state_19780[(13)]);
var inst_19721__$1 = (state_19780[(2)]);
var inst_19722 = (inst_19721__$1 == null);
var state_19780__$1 = (function (){var statearr_19786 = state_19780;
(statearr_19786[(13)] = inst_19721__$1);

return statearr_19786;
})();
if(cljs.core.truth_(inst_19722)){
var statearr_19787_19826 = state_19780__$1;
(statearr_19787_19826[(1)] = (5));

} else {
var statearr_19788_19827 = state_19780__$1;
(statearr_19788_19827[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (15))){
var state_19780__$1 = state_19780;
var statearr_19792_19828 = state_19780__$1;
(statearr_19792_19828[(2)] = null);

(statearr_19792_19828[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (21))){
var state_19780__$1 = state_19780;
var statearr_19793_19829 = state_19780__$1;
(statearr_19793_19829[(2)] = null);

(statearr_19793_19829[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (13))){
var inst_19733 = (state_19780[(9)]);
var inst_19734 = (state_19780[(10)]);
var inst_19735 = (state_19780[(11)]);
var inst_19732 = (state_19780[(12)]);
var inst_19742 = (state_19780[(2)]);
var inst_19743 = (inst_19735 + (1));
var tmp19789 = inst_19733;
var tmp19790 = inst_19734;
var tmp19791 = inst_19732;
var inst_19732__$1 = tmp19791;
var inst_19733__$1 = tmp19789;
var inst_19734__$1 = tmp19790;
var inst_19735__$1 = inst_19743;
var state_19780__$1 = (function (){var statearr_19794 = state_19780;
(statearr_19794[(9)] = inst_19733__$1);

(statearr_19794[(10)] = inst_19734__$1);

(statearr_19794[(11)] = inst_19735__$1);

(statearr_19794[(12)] = inst_19732__$1);

(statearr_19794[(14)] = inst_19742);

return statearr_19794;
})();
var statearr_19795_19830 = state_19780__$1;
(statearr_19795_19830[(2)] = null);

(statearr_19795_19830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (22))){
var state_19780__$1 = state_19780;
var statearr_19796_19831 = state_19780__$1;
(statearr_19796_19831[(2)] = null);

(statearr_19796_19831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (6))){
var inst_19721 = (state_19780[(13)]);
var inst_19730 = f.call(null,inst_19721);
var inst_19731 = cljs.core.seq.call(null,inst_19730);
var inst_19732 = inst_19731;
var inst_19733 = null;
var inst_19734 = (0);
var inst_19735 = (0);
var state_19780__$1 = (function (){var statearr_19797 = state_19780;
(statearr_19797[(9)] = inst_19733);

(statearr_19797[(10)] = inst_19734);

(statearr_19797[(11)] = inst_19735);

(statearr_19797[(12)] = inst_19732);

return statearr_19797;
})();
var statearr_19798_19832 = state_19780__$1;
(statearr_19798_19832[(2)] = null);

(statearr_19798_19832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (17))){
var inst_19746 = (state_19780[(7)]);
var inst_19750 = cljs.core.chunk_first.call(null,inst_19746);
var inst_19751 = cljs.core.chunk_rest.call(null,inst_19746);
var inst_19752 = cljs.core.count.call(null,inst_19750);
var inst_19732 = inst_19751;
var inst_19733 = inst_19750;
var inst_19734 = inst_19752;
var inst_19735 = (0);
var state_19780__$1 = (function (){var statearr_19799 = state_19780;
(statearr_19799[(9)] = inst_19733);

(statearr_19799[(10)] = inst_19734);

(statearr_19799[(11)] = inst_19735);

(statearr_19799[(12)] = inst_19732);

return statearr_19799;
})();
var statearr_19800_19833 = state_19780__$1;
(statearr_19800_19833[(2)] = null);

(statearr_19800_19833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (3))){
var inst_19778 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19780__$1,inst_19778);
} else {
if((state_val_19781 === (12))){
var inst_19766 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19801_19834 = state_19780__$1;
(statearr_19801_19834[(2)] = inst_19766);

(statearr_19801_19834[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (2))){
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19780__$1,(4),in$);
} else {
if((state_val_19781 === (23))){
var inst_19774 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19802_19835 = state_19780__$1;
(statearr_19802_19835[(2)] = inst_19774);

(statearr_19802_19835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (19))){
var inst_19761 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19803_19836 = state_19780__$1;
(statearr_19803_19836[(2)] = inst_19761);

(statearr_19803_19836[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (11))){
var inst_19732 = (state_19780[(12)]);
var inst_19746 = (state_19780[(7)]);
var inst_19746__$1 = cljs.core.seq.call(null,inst_19732);
var state_19780__$1 = (function (){var statearr_19804 = state_19780;
(statearr_19804[(7)] = inst_19746__$1);

return statearr_19804;
})();
if(inst_19746__$1){
var statearr_19805_19837 = state_19780__$1;
(statearr_19805_19837[(1)] = (14));

} else {
var statearr_19806_19838 = state_19780__$1;
(statearr_19806_19838[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (9))){
var inst_19768 = (state_19780[(2)]);
var inst_19769 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19780__$1 = (function (){var statearr_19807 = state_19780;
(statearr_19807[(15)] = inst_19768);

return statearr_19807;
})();
if(cljs.core.truth_(inst_19769)){
var statearr_19808_19839 = state_19780__$1;
(statearr_19808_19839[(1)] = (21));

} else {
var statearr_19809_19840 = state_19780__$1;
(statearr_19809_19840[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (5))){
var inst_19724 = cljs.core.async.close_BANG_.call(null,out);
var state_19780__$1 = state_19780;
var statearr_19810_19841 = state_19780__$1;
(statearr_19810_19841[(2)] = inst_19724);

(statearr_19810_19841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (14))){
var inst_19746 = (state_19780[(7)]);
var inst_19748 = cljs.core.chunked_seq_QMARK_.call(null,inst_19746);
var state_19780__$1 = state_19780;
if(inst_19748){
var statearr_19811_19842 = state_19780__$1;
(statearr_19811_19842[(1)] = (17));

} else {
var statearr_19812_19843 = state_19780__$1;
(statearr_19812_19843[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (16))){
var inst_19764 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19813_19844 = state_19780__$1;
(statearr_19813_19844[(2)] = inst_19764);

(statearr_19813_19844[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (10))){
var inst_19733 = (state_19780[(9)]);
var inst_19735 = (state_19780[(11)]);
var inst_19740 = cljs.core._nth.call(null,inst_19733,inst_19735);
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19780__$1,(13),out,inst_19740);
} else {
if((state_val_19781 === (18))){
var inst_19746 = (state_19780[(7)]);
var inst_19755 = cljs.core.first.call(null,inst_19746);
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19780__$1,(20),out,inst_19755);
} else {
if((state_val_19781 === (8))){
var inst_19734 = (state_19780[(10)]);
var inst_19735 = (state_19780[(11)]);
var inst_19737 = (inst_19735 < inst_19734);
var inst_19738 = inst_19737;
var state_19780__$1 = state_19780;
if(cljs.core.truth_(inst_19738)){
var statearr_19814_19845 = state_19780__$1;
(statearr_19814_19845[(1)] = (10));

} else {
var statearr_19815_19846 = state_19780__$1;
(statearr_19815_19846[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto__))
;
return ((function (switch__8335__auto__,c__8447__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0 = (function (){
var statearr_19819 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19819[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__);

(statearr_19819[(1)] = (1));

return statearr_19819;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1 = (function (state_19780){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19820){if((e19820 instanceof Object)){
var ex__8339__auto__ = e19820;
var statearr_19821_19847 = state_19780;
(statearr_19821_19847[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19780);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19820;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19848 = state_19780;
state_19780 = G__19848;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__ = function(state_19780){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1.call(this,state_19780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8336__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto__))
})();
var state__8449__auto__ = (function (){var statearr_19822 = f__8448__auto__.call(null);
(statearr_19822[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto__);

return statearr_19822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto__))
);

return c__8447__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19849 = [];
var len__5726__auto___19852 = arguments.length;
var i__5727__auto___19853 = (0);
while(true){
if((i__5727__auto___19853 < len__5726__auto___19852)){
args19849.push((arguments[i__5727__auto___19853]));

var G__19854 = (i__5727__auto___19853 + (1));
i__5727__auto___19853 = G__19854;
continue;
} else {
}
break;
}

var G__19851 = args19849.length;
switch (G__19851) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19849.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19856 = [];
var len__5726__auto___19859 = arguments.length;
var i__5727__auto___19860 = (0);
while(true){
if((i__5727__auto___19860 < len__5726__auto___19859)){
args19856.push((arguments[i__5727__auto___19860]));

var G__19861 = (i__5727__auto___19860 + (1));
i__5727__auto___19860 = G__19861;
continue;
} else {
}
break;
}

var G__19858 = args19856.length;
switch (G__19858) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19856.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19863 = [];
var len__5726__auto___19914 = arguments.length;
var i__5727__auto___19915 = (0);
while(true){
if((i__5727__auto___19915 < len__5726__auto___19914)){
args19863.push((arguments[i__5727__auto___19915]));

var G__19916 = (i__5727__auto___19915 + (1));
i__5727__auto___19915 = G__19916;
continue;
} else {
}
break;
}

var G__19865 = args19863.length;
switch (G__19865) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19863.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___19918 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___19918,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___19918,out){
return (function (state_19889){
var state_val_19890 = (state_19889[(1)]);
if((state_val_19890 === (7))){
var inst_19884 = (state_19889[(2)]);
var state_19889__$1 = state_19889;
var statearr_19891_19919 = state_19889__$1;
(statearr_19891_19919[(2)] = inst_19884);

(statearr_19891_19919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19890 === (1))){
var inst_19866 = null;
var state_19889__$1 = (function (){var statearr_19892 = state_19889;
(statearr_19892[(7)] = inst_19866);

return statearr_19892;
})();
var statearr_19893_19920 = state_19889__$1;
(statearr_19893_19920[(2)] = null);

(statearr_19893_19920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19890 === (4))){
var inst_19869 = (state_19889[(8)]);
var inst_19869__$1 = (state_19889[(2)]);
var inst_19870 = (inst_19869__$1 == null);
var inst_19871 = cljs.core.not.call(null,inst_19870);
var state_19889__$1 = (function (){var statearr_19894 = state_19889;
(statearr_19894[(8)] = inst_19869__$1);

return statearr_19894;
})();
if(inst_19871){
var statearr_19895_19921 = state_19889__$1;
(statearr_19895_19921[(1)] = (5));

} else {
var statearr_19896_19922 = state_19889__$1;
(statearr_19896_19922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19890 === (6))){
var state_19889__$1 = state_19889;
var statearr_19897_19923 = state_19889__$1;
(statearr_19897_19923[(2)] = null);

(statearr_19897_19923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19890 === (3))){
var inst_19886 = (state_19889[(2)]);
var inst_19887 = cljs.core.async.close_BANG_.call(null,out);
var state_19889__$1 = (function (){var statearr_19898 = state_19889;
(statearr_19898[(9)] = inst_19886);

return statearr_19898;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19889__$1,inst_19887);
} else {
if((state_val_19890 === (2))){
var state_19889__$1 = state_19889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19889__$1,(4),ch);
} else {
if((state_val_19890 === (11))){
var inst_19869 = (state_19889[(8)]);
var inst_19878 = (state_19889[(2)]);
var inst_19866 = inst_19869;
var state_19889__$1 = (function (){var statearr_19899 = state_19889;
(statearr_19899[(10)] = inst_19878);

(statearr_19899[(7)] = inst_19866);

return statearr_19899;
})();
var statearr_19900_19924 = state_19889__$1;
(statearr_19900_19924[(2)] = null);

(statearr_19900_19924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19890 === (9))){
var inst_19869 = (state_19889[(8)]);
var state_19889__$1 = state_19889;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19889__$1,(11),out,inst_19869);
} else {
if((state_val_19890 === (5))){
var inst_19869 = (state_19889[(8)]);
var inst_19866 = (state_19889[(7)]);
var inst_19873 = cljs.core._EQ_.call(null,inst_19869,inst_19866);
var state_19889__$1 = state_19889;
if(inst_19873){
var statearr_19902_19925 = state_19889__$1;
(statearr_19902_19925[(1)] = (8));

} else {
var statearr_19903_19926 = state_19889__$1;
(statearr_19903_19926[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19890 === (10))){
var inst_19881 = (state_19889[(2)]);
var state_19889__$1 = state_19889;
var statearr_19904_19927 = state_19889__$1;
(statearr_19904_19927[(2)] = inst_19881);

(statearr_19904_19927[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19890 === (8))){
var inst_19866 = (state_19889[(7)]);
var tmp19901 = inst_19866;
var inst_19866__$1 = tmp19901;
var state_19889__$1 = (function (){var statearr_19905 = state_19889;
(statearr_19905[(7)] = inst_19866__$1);

return statearr_19905;
})();
var statearr_19906_19928 = state_19889__$1;
(statearr_19906_19928[(2)] = null);

(statearr_19906_19928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___19918,out))
;
return ((function (switch__8335__auto__,c__8447__auto___19918,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19910 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19910[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19910[(1)] = (1));

return statearr_19910;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19889){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19911){if((e19911 instanceof Object)){
var ex__8339__auto__ = e19911;
var statearr_19912_19929 = state_19889;
(statearr_19912_19929[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19889);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19911;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19930 = state_19889;
state_19889 = G__19930;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19889){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___19918,out))
})();
var state__8449__auto__ = (function (){var statearr_19913 = f__8448__auto__.call(null);
(statearr_19913[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___19918);

return statearr_19913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___19918,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19931 = [];
var len__5726__auto___20001 = arguments.length;
var i__5727__auto___20002 = (0);
while(true){
if((i__5727__auto___20002 < len__5726__auto___20001)){
args19931.push((arguments[i__5727__auto___20002]));

var G__20003 = (i__5727__auto___20002 + (1));
i__5727__auto___20002 = G__20003;
continue;
} else {
}
break;
}

var G__19933 = args19931.length;
switch (G__19933) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19931.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___20005 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___20005,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___20005,out){
return (function (state_19971){
var state_val_19972 = (state_19971[(1)]);
if((state_val_19972 === (7))){
var inst_19967 = (state_19971[(2)]);
var state_19971__$1 = state_19971;
var statearr_19973_20006 = state_19971__$1;
(statearr_19973_20006[(2)] = inst_19967);

(statearr_19973_20006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (1))){
var inst_19934 = (new Array(n));
var inst_19935 = inst_19934;
var inst_19936 = (0);
var state_19971__$1 = (function (){var statearr_19974 = state_19971;
(statearr_19974[(7)] = inst_19936);

(statearr_19974[(8)] = inst_19935);

return statearr_19974;
})();
var statearr_19975_20007 = state_19971__$1;
(statearr_19975_20007[(2)] = null);

(statearr_19975_20007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (4))){
var inst_19939 = (state_19971[(9)]);
var inst_19939__$1 = (state_19971[(2)]);
var inst_19940 = (inst_19939__$1 == null);
var inst_19941 = cljs.core.not.call(null,inst_19940);
var state_19971__$1 = (function (){var statearr_19976 = state_19971;
(statearr_19976[(9)] = inst_19939__$1);

return statearr_19976;
})();
if(inst_19941){
var statearr_19977_20008 = state_19971__$1;
(statearr_19977_20008[(1)] = (5));

} else {
var statearr_19978_20009 = state_19971__$1;
(statearr_19978_20009[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (15))){
var inst_19961 = (state_19971[(2)]);
var state_19971__$1 = state_19971;
var statearr_19979_20010 = state_19971__$1;
(statearr_19979_20010[(2)] = inst_19961);

(statearr_19979_20010[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (13))){
var state_19971__$1 = state_19971;
var statearr_19980_20011 = state_19971__$1;
(statearr_19980_20011[(2)] = null);

(statearr_19980_20011[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (6))){
var inst_19936 = (state_19971[(7)]);
var inst_19957 = (inst_19936 > (0));
var state_19971__$1 = state_19971;
if(cljs.core.truth_(inst_19957)){
var statearr_19981_20012 = state_19971__$1;
(statearr_19981_20012[(1)] = (12));

} else {
var statearr_19982_20013 = state_19971__$1;
(statearr_19982_20013[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (3))){
var inst_19969 = (state_19971[(2)]);
var state_19971__$1 = state_19971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19971__$1,inst_19969);
} else {
if((state_val_19972 === (12))){
var inst_19935 = (state_19971[(8)]);
var inst_19959 = cljs.core.vec.call(null,inst_19935);
var state_19971__$1 = state_19971;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19971__$1,(15),out,inst_19959);
} else {
if((state_val_19972 === (2))){
var state_19971__$1 = state_19971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19971__$1,(4),ch);
} else {
if((state_val_19972 === (11))){
var inst_19951 = (state_19971[(2)]);
var inst_19952 = (new Array(n));
var inst_19935 = inst_19952;
var inst_19936 = (0);
var state_19971__$1 = (function (){var statearr_19983 = state_19971;
(statearr_19983[(7)] = inst_19936);

(statearr_19983[(8)] = inst_19935);

(statearr_19983[(10)] = inst_19951);

return statearr_19983;
})();
var statearr_19984_20014 = state_19971__$1;
(statearr_19984_20014[(2)] = null);

(statearr_19984_20014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (9))){
var inst_19935 = (state_19971[(8)]);
var inst_19949 = cljs.core.vec.call(null,inst_19935);
var state_19971__$1 = state_19971;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19971__$1,(11),out,inst_19949);
} else {
if((state_val_19972 === (5))){
var inst_19936 = (state_19971[(7)]);
var inst_19935 = (state_19971[(8)]);
var inst_19944 = (state_19971[(11)]);
var inst_19939 = (state_19971[(9)]);
var inst_19943 = (inst_19935[inst_19936] = inst_19939);
var inst_19944__$1 = (inst_19936 + (1));
var inst_19945 = (inst_19944__$1 < n);
var state_19971__$1 = (function (){var statearr_19985 = state_19971;
(statearr_19985[(12)] = inst_19943);

(statearr_19985[(11)] = inst_19944__$1);

return statearr_19985;
})();
if(cljs.core.truth_(inst_19945)){
var statearr_19986_20015 = state_19971__$1;
(statearr_19986_20015[(1)] = (8));

} else {
var statearr_19987_20016 = state_19971__$1;
(statearr_19987_20016[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (14))){
var inst_19964 = (state_19971[(2)]);
var inst_19965 = cljs.core.async.close_BANG_.call(null,out);
var state_19971__$1 = (function (){var statearr_19989 = state_19971;
(statearr_19989[(13)] = inst_19964);

return statearr_19989;
})();
var statearr_19990_20017 = state_19971__$1;
(statearr_19990_20017[(2)] = inst_19965);

(statearr_19990_20017[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (10))){
var inst_19955 = (state_19971[(2)]);
var state_19971__$1 = state_19971;
var statearr_19991_20018 = state_19971__$1;
(statearr_19991_20018[(2)] = inst_19955);

(statearr_19991_20018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (8))){
var inst_19935 = (state_19971[(8)]);
var inst_19944 = (state_19971[(11)]);
var tmp19988 = inst_19935;
var inst_19935__$1 = tmp19988;
var inst_19936 = inst_19944;
var state_19971__$1 = (function (){var statearr_19992 = state_19971;
(statearr_19992[(7)] = inst_19936);

(statearr_19992[(8)] = inst_19935__$1);

return statearr_19992;
})();
var statearr_19993_20019 = state_19971__$1;
(statearr_19993_20019[(2)] = null);

(statearr_19993_20019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___20005,out))
;
return ((function (switch__8335__auto__,c__8447__auto___20005,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_19997 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19997[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_19997[(1)] = (1));

return statearr_19997;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_19971){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_19971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e19998){if((e19998 instanceof Object)){
var ex__8339__auto__ = e19998;
var statearr_19999_20020 = state_19971;
(statearr_19999_20020[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19971);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19998;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20021 = state_19971;
state_19971 = G__20021;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_19971){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_19971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___20005,out))
})();
var state__8449__auto__ = (function (){var statearr_20000 = f__8448__auto__.call(null);
(statearr_20000[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___20005);

return statearr_20000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___20005,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args20022 = [];
var len__5726__auto___20096 = arguments.length;
var i__5727__auto___20097 = (0);
while(true){
if((i__5727__auto___20097 < len__5726__auto___20096)){
args20022.push((arguments[i__5727__auto___20097]));

var G__20098 = (i__5727__auto___20097 + (1));
i__5727__auto___20097 = G__20098;
continue;
} else {
}
break;
}

var G__20024 = args20022.length;
switch (G__20024) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20022.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8447__auto___20100 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8447__auto___20100,out){
return (function (){
var f__8448__auto__ = (function (){var switch__8335__auto__ = ((function (c__8447__auto___20100,out){
return (function (state_20066){
var state_val_20067 = (state_20066[(1)]);
if((state_val_20067 === (7))){
var inst_20062 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20068_20101 = state_20066__$1;
(statearr_20068_20101[(2)] = inst_20062);

(statearr_20068_20101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (1))){
var inst_20025 = [];
var inst_20026 = inst_20025;
var inst_20027 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_20066__$1 = (function (){var statearr_20069 = state_20066;
(statearr_20069[(7)] = inst_20026);

(statearr_20069[(8)] = inst_20027);

return statearr_20069;
})();
var statearr_20070_20102 = state_20066__$1;
(statearr_20070_20102[(2)] = null);

(statearr_20070_20102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (4))){
var inst_20030 = (state_20066[(9)]);
var inst_20030__$1 = (state_20066[(2)]);
var inst_20031 = (inst_20030__$1 == null);
var inst_20032 = cljs.core.not.call(null,inst_20031);
var state_20066__$1 = (function (){var statearr_20071 = state_20066;
(statearr_20071[(9)] = inst_20030__$1);

return statearr_20071;
})();
if(inst_20032){
var statearr_20072_20103 = state_20066__$1;
(statearr_20072_20103[(1)] = (5));

} else {
var statearr_20073_20104 = state_20066__$1;
(statearr_20073_20104[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (15))){
var inst_20056 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20074_20105 = state_20066__$1;
(statearr_20074_20105[(2)] = inst_20056);

(statearr_20074_20105[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (13))){
var state_20066__$1 = state_20066;
var statearr_20075_20106 = state_20066__$1;
(statearr_20075_20106[(2)] = null);

(statearr_20075_20106[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (6))){
var inst_20026 = (state_20066[(7)]);
var inst_20051 = inst_20026.length;
var inst_20052 = (inst_20051 > (0));
var state_20066__$1 = state_20066;
if(cljs.core.truth_(inst_20052)){
var statearr_20076_20107 = state_20066__$1;
(statearr_20076_20107[(1)] = (12));

} else {
var statearr_20077_20108 = state_20066__$1;
(statearr_20077_20108[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (3))){
var inst_20064 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20066__$1,inst_20064);
} else {
if((state_val_20067 === (12))){
var inst_20026 = (state_20066[(7)]);
var inst_20054 = cljs.core.vec.call(null,inst_20026);
var state_20066__$1 = state_20066;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20066__$1,(15),out,inst_20054);
} else {
if((state_val_20067 === (2))){
var state_20066__$1 = state_20066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20066__$1,(4),ch);
} else {
if((state_val_20067 === (11))){
var inst_20030 = (state_20066[(9)]);
var inst_20034 = (state_20066[(10)]);
var inst_20044 = (state_20066[(2)]);
var inst_20045 = [];
var inst_20046 = inst_20045.push(inst_20030);
var inst_20026 = inst_20045;
var inst_20027 = inst_20034;
var state_20066__$1 = (function (){var statearr_20078 = state_20066;
(statearr_20078[(11)] = inst_20044);

(statearr_20078[(12)] = inst_20046);

(statearr_20078[(7)] = inst_20026);

(statearr_20078[(8)] = inst_20027);

return statearr_20078;
})();
var statearr_20079_20109 = state_20066__$1;
(statearr_20079_20109[(2)] = null);

(statearr_20079_20109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (9))){
var inst_20026 = (state_20066[(7)]);
var inst_20042 = cljs.core.vec.call(null,inst_20026);
var state_20066__$1 = state_20066;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20066__$1,(11),out,inst_20042);
} else {
if((state_val_20067 === (5))){
var inst_20030 = (state_20066[(9)]);
var inst_20034 = (state_20066[(10)]);
var inst_20027 = (state_20066[(8)]);
var inst_20034__$1 = f.call(null,inst_20030);
var inst_20035 = cljs.core._EQ_.call(null,inst_20034__$1,inst_20027);
var inst_20036 = cljs.core.keyword_identical_QMARK_.call(null,inst_20027,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_20037 = (inst_20035) || (inst_20036);
var state_20066__$1 = (function (){var statearr_20080 = state_20066;
(statearr_20080[(10)] = inst_20034__$1);

return statearr_20080;
})();
if(cljs.core.truth_(inst_20037)){
var statearr_20081_20110 = state_20066__$1;
(statearr_20081_20110[(1)] = (8));

} else {
var statearr_20082_20111 = state_20066__$1;
(statearr_20082_20111[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (14))){
var inst_20059 = (state_20066[(2)]);
var inst_20060 = cljs.core.async.close_BANG_.call(null,out);
var state_20066__$1 = (function (){var statearr_20084 = state_20066;
(statearr_20084[(13)] = inst_20059);

return statearr_20084;
})();
var statearr_20085_20112 = state_20066__$1;
(statearr_20085_20112[(2)] = inst_20060);

(statearr_20085_20112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (10))){
var inst_20049 = (state_20066[(2)]);
var state_20066__$1 = state_20066;
var statearr_20086_20113 = state_20066__$1;
(statearr_20086_20113[(2)] = inst_20049);

(statearr_20086_20113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20067 === (8))){
var inst_20030 = (state_20066[(9)]);
var inst_20026 = (state_20066[(7)]);
var inst_20034 = (state_20066[(10)]);
var inst_20039 = inst_20026.push(inst_20030);
var tmp20083 = inst_20026;
var inst_20026__$1 = tmp20083;
var inst_20027 = inst_20034;
var state_20066__$1 = (function (){var statearr_20087 = state_20066;
(statearr_20087[(14)] = inst_20039);

(statearr_20087[(7)] = inst_20026__$1);

(statearr_20087[(8)] = inst_20027);

return statearr_20087;
})();
var statearr_20088_20114 = state_20066__$1;
(statearr_20088_20114[(2)] = null);

(statearr_20088_20114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8447__auto___20100,out))
;
return ((function (switch__8335__auto__,c__8447__auto___20100,out){
return (function() {
var cljs$core$async$state_machine__8336__auto__ = null;
var cljs$core$async$state_machine__8336__auto____0 = (function (){
var statearr_20092 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20092[(0)] = cljs$core$async$state_machine__8336__auto__);

(statearr_20092[(1)] = (1));

return statearr_20092;
});
var cljs$core$async$state_machine__8336__auto____1 = (function (state_20066){
while(true){
var ret_value__8337__auto__ = (function (){try{while(true){
var result__8338__auto__ = switch__8335__auto__.call(null,state_20066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8338__auto__;
}
break;
}
}catch (e20093){if((e20093 instanceof Object)){
var ex__8339__auto__ = e20093;
var statearr_20094_20115 = state_20066;
(statearr_20094_20115[(5)] = ex__8339__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20066);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20093;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20116 = state_20066;
state_20066 = G__20116;
continue;
} else {
return ret_value__8337__auto__;
}
break;
}
});
cljs$core$async$state_machine__8336__auto__ = function(state_20066){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8336__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8336__auto____1.call(this,state_20066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8336__auto____0;
cljs$core$async$state_machine__8336__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8336__auto____1;
return cljs$core$async$state_machine__8336__auto__;
})()
;})(switch__8335__auto__,c__8447__auto___20100,out))
})();
var state__8449__auto__ = (function (){var statearr_20095 = f__8448__auto__.call(null);
(statearr_20095[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8447__auto___20100);

return statearr_20095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8449__auto__);
});})(c__8447__auto___20100,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1454087771818