"use strict";

module.exports = {
    description: "compile a schema array and validate against one of the schemas - README sample",
    tests: [
        {
            description: "should validate object successfully",
            schema: [
                {
                    id: "personDetails",
                    type: "object",
                    properties: {
                        firstName: {
                            type: "string"
                        },
                        lastName: {
                            type: "string"
                        }
                    },
                    required: ["firstName", "lastName"]
                },
                {
                    id: "addressDetails",
                    type: "object",
                    properties: {
                        street: {
                            type: "string"
                        },
                        city: {
                            type: "string"
                        }
                    },
                    required: ["street", "city"]
                },
                {
                    id: "personWithAddress",
                    allOf: [
                        {
                            $ref: "personDetails"
                        },
                        {
                            $ref: "addressDetails"
                        }
                    ]
                }
            ],
            schemaIndex: 2,
            data: {
                firstName: "Martin",
                lastName: "Zagora",
                street: "George St",
                city: "Sydney"
            },
            valid: true
        }
    ]
};
