"use strict";

module.exports = {
    description: "Issue #13 - compile multiple schemas tied together with an id",
    tests: [
        {
            description: "mainSchema should fail compilation on its own",
            schema: {
                id: "mainSchema",
                type: "object",
                properties: {
                    a: {"$ref": "schemaA"},
                    b: {"$ref": "schemaB"},
                    c: {"enum": ["C"]}
                }
            },
            validateSchemaOnly: true,
            valid: false
        },
        {
            description: "mainSchema should pass compilation if schemaA and schemaB were already compiled, order #1",
            schema: [
                {
                    id: "schemaA",
                    type: "integer"
                },
                {
                    id: "schemaB",
                    type: "string"
                },
                {
                    id: "mainSchema",
                    type: "object",
                    properties: {
                        a: {"$ref": "schemaA"},
                        b: {"$ref": "schemaB"},
                        c: {"enum": ["C"]}
                    }
                }
            ],
            validateSchemaOnly: true,
            valid: true
        },
        {
            description: "mainSchema should pass compilation if schemaA and schemaB were already compiled, order #2",
            schema: [
                {
                    id: "mainSchema",
                    type: "object",
                    properties: {
                        a: {"$ref": "schemaA"},
                        b: {"$ref": "schemaB"},
                        c: {"enum": ["C"]}
                    }
                },
                {
                    id: "schemaA",
                    type: "integer"
                },
                {
                    id: "schemaB",
                    type: "string"
                }
            ],
            validateSchemaOnly: true,
            valid: true
        },
        {
            description: "compilation should never end up in infinite loop #1",
            schema: [
                {
                    id: "mainSchema",
                    type: "object",
                    properties: {
                        a: {"$ref": "schemaA"},
                        b: {"$ref": "schemaB"},
                        c: {"enum": ["C"]}
                    }
                },
                {
                    id: "schemaB",
                    type: "string"
                }
            ],
            validateSchemaOnly: true,
            valid: false
        },
        {
            description: "compilation should never end up in infinite loop #2",
            schema: [
                {
                    id: "schemaB",
                    type: "string"
                },
                {
                    id: "mainSchema",
                    type: "object",
                    properties: {
                        a: {"$ref": "schemaA"},
                        b: {"$ref": "schemaB"},
                        c: {"enum": ["C"]}
                    }
                }
            ],
            validateSchemaOnly: true,
            valid: false
        },
        {
            description: "should validate object successfully",
            schema: [
                {
                    id: "schemaA",
                    type: "integer"
                },
                {
                    id: "schemaB",
                    type: "string"
                },
                {
                    id: "mainSchema",
                    type: "object",
                    properties: {
                        a: {"$ref": "schemaA"},
                        b: {"$ref": "schemaB"},
                        c: {"enum": ["C"]}
                    }
                }
            ],
            schemaIndex: 2,
            data: {
                a: 1,
                b: "str",
                c: "C"
            },
            valid: true
        },
        {
            description: "should fail validating object",
            schema: [
                {
                    id: "schemaA",
                    type: "integer"
                },
                {
                    id: "schemaB",
                    type: "string"
                },
                {
                    id: "mainSchema",
                    type: "object",
                    properties: {
                        a: {"$ref": "schemaA"},
                        b: {"$ref": "schemaB"},
                        c: {"enum": ["C"]}
                    }
                }
            ],
            schemaIndex: 2,
            data: {
                a: "str",
                b: 1,
                c: "C"
            },
            valid: false,
            after: function (err) {
                expect(err[0].code).toBe("INVALID_TYPE");
                expect(err[1].code).toBe("INVALID_TYPE");
            }
        }
    ]
};
