// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17304 = [];
var len__5726__auto___17310 = arguments.length;
var i__5727__auto___17311 = (0);
while(true){
if((i__5727__auto___17311 < len__5726__auto___17310)){
args17304.push((arguments[i__5727__auto___17311]));

var G__17312 = (i__5727__auto___17311 + (1));
i__5727__auto___17311 = G__17312;
continue;
} else {
}
break;
}

var G__17306 = args17304.length;
switch (G__17306) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17304.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17307 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17307 = (function (f,blockable,meta17308){
this.f = f;
this.blockable = blockable;
this.meta17308 = meta17308;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17307.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17309,meta17308__$1){
var self__ = this;
var _17309__$1 = this;
return (new cljs.core.async.t_cljs$core$async17307(self__.f,self__.blockable,meta17308__$1));
});

cljs.core.async.t_cljs$core$async17307.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17309){
var self__ = this;
var _17309__$1 = this;
return self__.meta17308;
});

cljs.core.async.t_cljs$core$async17307.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17307.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17307.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17307.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17307.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17308","meta17308",-462033187,null)], null);
});

cljs.core.async.t_cljs$core$async17307.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17307.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17307";

cljs.core.async.t_cljs$core$async17307.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17307");
});

cljs.core.async.__GT_t_cljs$core$async17307 = (function cljs$core$async$__GT_t_cljs$core$async17307(f__$1,blockable__$1,meta17308){
return (new cljs.core.async.t_cljs$core$async17307(f__$1,blockable__$1,meta17308));
});

}

return (new cljs.core.async.t_cljs$core$async17307(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17316 = [];
var len__5726__auto___17319 = arguments.length;
var i__5727__auto___17320 = (0);
while(true){
if((i__5727__auto___17320 < len__5726__auto___17319)){
args17316.push((arguments[i__5727__auto___17320]));

var G__17321 = (i__5727__auto___17320 + (1));
i__5727__auto___17320 = G__17321;
continue;
} else {
}
break;
}

var G__17318 = args17316.length;
switch (G__17318) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17316.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17323 = [];
var len__5726__auto___17326 = arguments.length;
var i__5727__auto___17327 = (0);
while(true){
if((i__5727__auto___17327 < len__5726__auto___17326)){
args17323.push((arguments[i__5727__auto___17327]));

var G__17328 = (i__5727__auto___17327 + (1));
i__5727__auto___17327 = G__17328;
continue;
} else {
}
break;
}

var G__17325 = args17323.length;
switch (G__17325) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17323.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17330 = [];
var len__5726__auto___17333 = arguments.length;
var i__5727__auto___17334 = (0);
while(true){
if((i__5727__auto___17334 < len__5726__auto___17333)){
args17330.push((arguments[i__5727__auto___17334]));

var G__17335 = (i__5727__auto___17334 + (1));
i__5727__auto___17334 = G__17335;
continue;
} else {
}
break;
}

var G__17332 = args17330.length;
switch (G__17332) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17330.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17337 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17337);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17337,ret){
return (function (){
return fn1.call(null,val_17337);
});})(val_17337,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17338 = [];
var len__5726__auto___17341 = arguments.length;
var i__5727__auto___17342 = (0);
while(true){
if((i__5727__auto___17342 < len__5726__auto___17341)){
args17338.push((arguments[i__5727__auto___17342]));

var G__17343 = (i__5727__auto___17342 + (1));
i__5727__auto___17342 = G__17343;
continue;
} else {
}
break;
}

var G__17340 = args17338.length;
switch (G__17340) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17338.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17345 = n;
var x_17346 = (0);
while(true){
if((x_17346 < n__5571__auto___17345)){
(a[x_17346] = (0));

var G__17347 = (x_17346 + (1));
x_17346 = G__17347;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17348 = (i + (1));
i = G__17348;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17352 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17352 = (function (alt_flag,flag,meta17353){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17353 = meta17353;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17352.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17354,meta17353__$1){
var self__ = this;
var _17354__$1 = this;
return (new cljs.core.async.t_cljs$core$async17352(self__.alt_flag,self__.flag,meta17353__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17352.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17354){
var self__ = this;
var _17354__$1 = this;
return self__.meta17353;
});})(flag))
;

cljs.core.async.t_cljs$core$async17352.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17352.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17352.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17352.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17352.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17353","meta17353",-1030978119,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17352.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17352.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17352";

cljs.core.async.t_cljs$core$async17352.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17352");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17352 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17352(alt_flag__$1,flag__$1,meta17353){
return (new cljs.core.async.t_cljs$core$async17352(alt_flag__$1,flag__$1,meta17353));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17352(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17358 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17358 = (function (alt_handler,flag,cb,meta17359){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17359 = meta17359;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17358.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17360,meta17359__$1){
var self__ = this;
var _17360__$1 = this;
return (new cljs.core.async.t_cljs$core$async17358(self__.alt_handler,self__.flag,self__.cb,meta17359__$1));
});

cljs.core.async.t_cljs$core$async17358.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17360){
var self__ = this;
var _17360__$1 = this;
return self__.meta17359;
});

cljs.core.async.t_cljs$core$async17358.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17358.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17358.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17358.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17358.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17359","meta17359",75911486,null)], null);
});

cljs.core.async.t_cljs$core$async17358.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17358.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17358";

cljs.core.async.t_cljs$core$async17358.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17358");
});

cljs.core.async.__GT_t_cljs$core$async17358 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17358(alt_handler__$1,flag__$1,cb__$1,meta17359){
return (new cljs.core.async.t_cljs$core$async17358(alt_handler__$1,flag__$1,cb__$1,meta17359));
});

}

return (new cljs.core.async.t_cljs$core$async17358(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17361_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17361_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17362_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17362_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17363 = (i + (1));
i = G__17363;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17369 = arguments.length;
var i__5727__auto___17370 = (0);
while(true){
if((i__5727__auto___17370 < len__5726__auto___17369)){
args__5733__auto__.push((arguments[i__5727__auto___17370]));

var G__17371 = (i__5727__auto___17370 + (1));
i__5727__auto___17370 = G__17371;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17366){
var map__17367 = p__17366;
var map__17367__$1 = ((((!((map__17367 == null)))?((((map__17367.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17367.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17367):map__17367);
var opts = map__17367__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17364){
var G__17365 = cljs.core.first.call(null,seq17364);
var seq17364__$1 = cljs.core.next.call(null,seq17364);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17365,seq17364__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17372 = [];
var len__5726__auto___17422 = arguments.length;
var i__5727__auto___17423 = (0);
while(true){
if((i__5727__auto___17423 < len__5726__auto___17422)){
args17372.push((arguments[i__5727__auto___17423]));

var G__17424 = (i__5727__auto___17423 + (1));
i__5727__auto___17423 = G__17424;
continue;
} else {
}
break;
}

var G__17374 = args17372.length;
switch (G__17374) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17372.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17426 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17426){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17426){
return (function (state_17398){
var state_val_17399 = (state_17398[(1)]);
if((state_val_17399 === (7))){
var inst_17394 = (state_17398[(2)]);
var state_17398__$1 = state_17398;
var statearr_17400_17427 = state_17398__$1;
(statearr_17400_17427[(2)] = inst_17394);

(statearr_17400_17427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (1))){
var state_17398__$1 = state_17398;
var statearr_17401_17428 = state_17398__$1;
(statearr_17401_17428[(2)] = null);

(statearr_17401_17428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (4))){
var inst_17377 = (state_17398[(7)]);
var inst_17377__$1 = (state_17398[(2)]);
var inst_17378 = (inst_17377__$1 == null);
var state_17398__$1 = (function (){var statearr_17402 = state_17398;
(statearr_17402[(7)] = inst_17377__$1);

return statearr_17402;
})();
if(cljs.core.truth_(inst_17378)){
var statearr_17403_17429 = state_17398__$1;
(statearr_17403_17429[(1)] = (5));

} else {
var statearr_17404_17430 = state_17398__$1;
(statearr_17404_17430[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (13))){
var state_17398__$1 = state_17398;
var statearr_17405_17431 = state_17398__$1;
(statearr_17405_17431[(2)] = null);

(statearr_17405_17431[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (6))){
var inst_17377 = (state_17398[(7)]);
var state_17398__$1 = state_17398;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17398__$1,(11),to,inst_17377);
} else {
if((state_val_17399 === (3))){
var inst_17396 = (state_17398[(2)]);
var state_17398__$1 = state_17398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17398__$1,inst_17396);
} else {
if((state_val_17399 === (12))){
var state_17398__$1 = state_17398;
var statearr_17406_17432 = state_17398__$1;
(statearr_17406_17432[(2)] = null);

(statearr_17406_17432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (2))){
var state_17398__$1 = state_17398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17398__$1,(4),from);
} else {
if((state_val_17399 === (11))){
var inst_17387 = (state_17398[(2)]);
var state_17398__$1 = state_17398;
if(cljs.core.truth_(inst_17387)){
var statearr_17407_17433 = state_17398__$1;
(statearr_17407_17433[(1)] = (12));

} else {
var statearr_17408_17434 = state_17398__$1;
(statearr_17408_17434[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (9))){
var state_17398__$1 = state_17398;
var statearr_17409_17435 = state_17398__$1;
(statearr_17409_17435[(2)] = null);

(statearr_17409_17435[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (5))){
var state_17398__$1 = state_17398;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17410_17436 = state_17398__$1;
(statearr_17410_17436[(1)] = (8));

} else {
var statearr_17411_17437 = state_17398__$1;
(statearr_17411_17437[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (14))){
var inst_17392 = (state_17398[(2)]);
var state_17398__$1 = state_17398;
var statearr_17412_17438 = state_17398__$1;
(statearr_17412_17438[(2)] = inst_17392);

(statearr_17412_17438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (10))){
var inst_17384 = (state_17398[(2)]);
var state_17398__$1 = state_17398;
var statearr_17413_17439 = state_17398__$1;
(statearr_17413_17439[(2)] = inst_17384);

(statearr_17413_17439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17399 === (8))){
var inst_17381 = cljs.core.async.close_BANG_.call(null,to);
var state_17398__$1 = state_17398;
var statearr_17414_17440 = state_17398__$1;
(statearr_17414_17440[(2)] = inst_17381);

(statearr_17414_17440[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17426))
;
return ((function (switch__8250__auto__,c__8362__auto___17426){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17418 = [null,null,null,null,null,null,null,null];
(statearr_17418[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17418[(1)] = (1));

return statearr_17418;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17398){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17419){if((e17419 instanceof Object)){
var ex__8254__auto__ = e17419;
var statearr_17420_17441 = state_17398;
(statearr_17420_17441[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17398);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17419;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17442 = state_17398;
state_17398 = G__17442;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17398){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17426))
})();
var state__8364__auto__ = (function (){var statearr_17421 = f__8363__auto__.call(null);
(statearr_17421[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17426);

return statearr_17421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17426))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17626){
var vec__17627 = p__17626;
var v = cljs.core.nth.call(null,vec__17627,(0),null);
var p = cljs.core.nth.call(null,vec__17627,(1),null);
var job = vec__17627;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17809 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17809,res,vec__17627,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17809,res,vec__17627,v,p,job,jobs,results){
return (function (state_17632){
var state_val_17633 = (state_17632[(1)]);
if((state_val_17633 === (1))){
var state_17632__$1 = state_17632;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17632__$1,(2),res,v);
} else {
if((state_val_17633 === (2))){
var inst_17629 = (state_17632[(2)]);
var inst_17630 = cljs.core.async.close_BANG_.call(null,res);
var state_17632__$1 = (function (){var statearr_17634 = state_17632;
(statearr_17634[(7)] = inst_17629);

return statearr_17634;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17632__$1,inst_17630);
} else {
return null;
}
}
});})(c__8362__auto___17809,res,vec__17627,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17809,res,vec__17627,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17638 = [null,null,null,null,null,null,null,null];
(statearr_17638[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17638[(1)] = (1));

return statearr_17638;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17632){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17632);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17639){if((e17639 instanceof Object)){
var ex__8254__auto__ = e17639;
var statearr_17640_17810 = state_17632;
(statearr_17640_17810[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17632);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17639;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17811 = state_17632;
state_17632 = G__17811;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17632){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17809,res,vec__17627,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17641 = f__8363__auto__.call(null);
(statearr_17641[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17809);

return statearr_17641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17809,res,vec__17627,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17642){
var vec__17643 = p__17642;
var v = cljs.core.nth.call(null,vec__17643,(0),null);
var p = cljs.core.nth.call(null,vec__17643,(1),null);
var job = vec__17643;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17812 = n;
var __17813 = (0);
while(true){
if((__17813 < n__5571__auto___17812)){
var G__17644_17814 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17644_17814) {
case "compute":
var c__8362__auto___17816 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17813,c__8362__auto___17816,G__17644_17814,n__5571__auto___17812,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17813,c__8362__auto___17816,G__17644_17814,n__5571__auto___17812,jobs,results,process,async){
return (function (state_17657){
var state_val_17658 = (state_17657[(1)]);
if((state_val_17658 === (1))){
var state_17657__$1 = state_17657;
var statearr_17659_17817 = state_17657__$1;
(statearr_17659_17817[(2)] = null);

(statearr_17659_17817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (2))){
var state_17657__$1 = state_17657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17657__$1,(4),jobs);
} else {
if((state_val_17658 === (3))){
var inst_17655 = (state_17657[(2)]);
var state_17657__$1 = state_17657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17657__$1,inst_17655);
} else {
if((state_val_17658 === (4))){
var inst_17647 = (state_17657[(2)]);
var inst_17648 = process.call(null,inst_17647);
var state_17657__$1 = state_17657;
if(cljs.core.truth_(inst_17648)){
var statearr_17660_17818 = state_17657__$1;
(statearr_17660_17818[(1)] = (5));

} else {
var statearr_17661_17819 = state_17657__$1;
(statearr_17661_17819[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (5))){
var state_17657__$1 = state_17657;
var statearr_17662_17820 = state_17657__$1;
(statearr_17662_17820[(2)] = null);

(statearr_17662_17820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (6))){
var state_17657__$1 = state_17657;
var statearr_17663_17821 = state_17657__$1;
(statearr_17663_17821[(2)] = null);

(statearr_17663_17821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17658 === (7))){
var inst_17653 = (state_17657[(2)]);
var state_17657__$1 = state_17657;
var statearr_17664_17822 = state_17657__$1;
(statearr_17664_17822[(2)] = inst_17653);

(statearr_17664_17822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17813,c__8362__auto___17816,G__17644_17814,n__5571__auto___17812,jobs,results,process,async))
;
return ((function (__17813,switch__8250__auto__,c__8362__auto___17816,G__17644_17814,n__5571__auto___17812,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17668 = [null,null,null,null,null,null,null];
(statearr_17668[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17668[(1)] = (1));

return statearr_17668;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17657){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17669){if((e17669 instanceof Object)){
var ex__8254__auto__ = e17669;
var statearr_17670_17823 = state_17657;
(statearr_17670_17823[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17657);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17669;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17824 = state_17657;
state_17657 = G__17824;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17657){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17813,switch__8250__auto__,c__8362__auto___17816,G__17644_17814,n__5571__auto___17812,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17671 = f__8363__auto__.call(null);
(statearr_17671[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17816);

return statearr_17671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17813,c__8362__auto___17816,G__17644_17814,n__5571__auto___17812,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17825 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17813,c__8362__auto___17825,G__17644_17814,n__5571__auto___17812,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17813,c__8362__auto___17825,G__17644_17814,n__5571__auto___17812,jobs,results,process,async){
return (function (state_17684){
var state_val_17685 = (state_17684[(1)]);
if((state_val_17685 === (1))){
var state_17684__$1 = state_17684;
var statearr_17686_17826 = state_17684__$1;
(statearr_17686_17826[(2)] = null);

(statearr_17686_17826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17685 === (2))){
var state_17684__$1 = state_17684;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17684__$1,(4),jobs);
} else {
if((state_val_17685 === (3))){
var inst_17682 = (state_17684[(2)]);
var state_17684__$1 = state_17684;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17684__$1,inst_17682);
} else {
if((state_val_17685 === (4))){
var inst_17674 = (state_17684[(2)]);
var inst_17675 = async.call(null,inst_17674);
var state_17684__$1 = state_17684;
if(cljs.core.truth_(inst_17675)){
var statearr_17687_17827 = state_17684__$1;
(statearr_17687_17827[(1)] = (5));

} else {
var statearr_17688_17828 = state_17684__$1;
(statearr_17688_17828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17685 === (5))){
var state_17684__$1 = state_17684;
var statearr_17689_17829 = state_17684__$1;
(statearr_17689_17829[(2)] = null);

(statearr_17689_17829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17685 === (6))){
var state_17684__$1 = state_17684;
var statearr_17690_17830 = state_17684__$1;
(statearr_17690_17830[(2)] = null);

(statearr_17690_17830[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17685 === (7))){
var inst_17680 = (state_17684[(2)]);
var state_17684__$1 = state_17684;
var statearr_17691_17831 = state_17684__$1;
(statearr_17691_17831[(2)] = inst_17680);

(statearr_17691_17831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17813,c__8362__auto___17825,G__17644_17814,n__5571__auto___17812,jobs,results,process,async))
;
return ((function (__17813,switch__8250__auto__,c__8362__auto___17825,G__17644_17814,n__5571__auto___17812,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17695 = [null,null,null,null,null,null,null];
(statearr_17695[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17695[(1)] = (1));

return statearr_17695;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17684){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17684);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17696){if((e17696 instanceof Object)){
var ex__8254__auto__ = e17696;
var statearr_17697_17832 = state_17684;
(statearr_17697_17832[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17684);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17696;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17833 = state_17684;
state_17684 = G__17833;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17684){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17813,switch__8250__auto__,c__8362__auto___17825,G__17644_17814,n__5571__auto___17812,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17698 = f__8363__auto__.call(null);
(statearr_17698[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17825);

return statearr_17698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17813,c__8362__auto___17825,G__17644_17814,n__5571__auto___17812,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17834 = (__17813 + (1));
__17813 = G__17834;
continue;
} else {
}
break;
}

var c__8362__auto___17835 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17835,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17835,jobs,results,process,async){
return (function (state_17720){
var state_val_17721 = (state_17720[(1)]);
if((state_val_17721 === (1))){
var state_17720__$1 = state_17720;
var statearr_17722_17836 = state_17720__$1;
(statearr_17722_17836[(2)] = null);

(statearr_17722_17836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (2))){
var state_17720__$1 = state_17720;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17720__$1,(4),from);
} else {
if((state_val_17721 === (3))){
var inst_17718 = (state_17720[(2)]);
var state_17720__$1 = state_17720;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17720__$1,inst_17718);
} else {
if((state_val_17721 === (4))){
var inst_17701 = (state_17720[(7)]);
var inst_17701__$1 = (state_17720[(2)]);
var inst_17702 = (inst_17701__$1 == null);
var state_17720__$1 = (function (){var statearr_17723 = state_17720;
(statearr_17723[(7)] = inst_17701__$1);

return statearr_17723;
})();
if(cljs.core.truth_(inst_17702)){
var statearr_17724_17837 = state_17720__$1;
(statearr_17724_17837[(1)] = (5));

} else {
var statearr_17725_17838 = state_17720__$1;
(statearr_17725_17838[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (5))){
var inst_17704 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17720__$1 = state_17720;
var statearr_17726_17839 = state_17720__$1;
(statearr_17726_17839[(2)] = inst_17704);

(statearr_17726_17839[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (6))){
var inst_17706 = (state_17720[(8)]);
var inst_17701 = (state_17720[(7)]);
var inst_17706__$1 = cljs.core.async.chan.call(null,(1));
var inst_17707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17708 = [inst_17701,inst_17706__$1];
var inst_17709 = (new cljs.core.PersistentVector(null,2,(5),inst_17707,inst_17708,null));
var state_17720__$1 = (function (){var statearr_17727 = state_17720;
(statearr_17727[(8)] = inst_17706__$1);

return statearr_17727;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17720__$1,(8),jobs,inst_17709);
} else {
if((state_val_17721 === (7))){
var inst_17716 = (state_17720[(2)]);
var state_17720__$1 = state_17720;
var statearr_17728_17840 = state_17720__$1;
(statearr_17728_17840[(2)] = inst_17716);

(statearr_17728_17840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (8))){
var inst_17706 = (state_17720[(8)]);
var inst_17711 = (state_17720[(2)]);
var state_17720__$1 = (function (){var statearr_17729 = state_17720;
(statearr_17729[(9)] = inst_17711);

return statearr_17729;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17720__$1,(9),results,inst_17706);
} else {
if((state_val_17721 === (9))){
var inst_17713 = (state_17720[(2)]);
var state_17720__$1 = (function (){var statearr_17730 = state_17720;
(statearr_17730[(10)] = inst_17713);

return statearr_17730;
})();
var statearr_17731_17841 = state_17720__$1;
(statearr_17731_17841[(2)] = null);

(statearr_17731_17841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17835,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17835,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17735 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17735[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17735[(1)] = (1));

return statearr_17735;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17720){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17720);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17736){if((e17736 instanceof Object)){
var ex__8254__auto__ = e17736;
var statearr_17737_17842 = state_17720;
(statearr_17737_17842[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17720);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17736;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17843 = state_17720;
state_17720 = G__17843;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17720){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17835,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17738 = f__8363__auto__.call(null);
(statearr_17738[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17835);

return statearr_17738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17835,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17776){
var state_val_17777 = (state_17776[(1)]);
if((state_val_17777 === (7))){
var inst_17772 = (state_17776[(2)]);
var state_17776__$1 = state_17776;
var statearr_17778_17844 = state_17776__$1;
(statearr_17778_17844[(2)] = inst_17772);

(statearr_17778_17844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (20))){
var state_17776__$1 = state_17776;
var statearr_17779_17845 = state_17776__$1;
(statearr_17779_17845[(2)] = null);

(statearr_17779_17845[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (1))){
var state_17776__$1 = state_17776;
var statearr_17780_17846 = state_17776__$1;
(statearr_17780_17846[(2)] = null);

(statearr_17780_17846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (4))){
var inst_17741 = (state_17776[(7)]);
var inst_17741__$1 = (state_17776[(2)]);
var inst_17742 = (inst_17741__$1 == null);
var state_17776__$1 = (function (){var statearr_17781 = state_17776;
(statearr_17781[(7)] = inst_17741__$1);

return statearr_17781;
})();
if(cljs.core.truth_(inst_17742)){
var statearr_17782_17847 = state_17776__$1;
(statearr_17782_17847[(1)] = (5));

} else {
var statearr_17783_17848 = state_17776__$1;
(statearr_17783_17848[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (15))){
var inst_17754 = (state_17776[(8)]);
var state_17776__$1 = state_17776;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17776__$1,(18),to,inst_17754);
} else {
if((state_val_17777 === (21))){
var inst_17767 = (state_17776[(2)]);
var state_17776__$1 = state_17776;
var statearr_17784_17849 = state_17776__$1;
(statearr_17784_17849[(2)] = inst_17767);

(statearr_17784_17849[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (13))){
var inst_17769 = (state_17776[(2)]);
var state_17776__$1 = (function (){var statearr_17785 = state_17776;
(statearr_17785[(9)] = inst_17769);

return statearr_17785;
})();
var statearr_17786_17850 = state_17776__$1;
(statearr_17786_17850[(2)] = null);

(statearr_17786_17850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (6))){
var inst_17741 = (state_17776[(7)]);
var state_17776__$1 = state_17776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17776__$1,(11),inst_17741);
} else {
if((state_val_17777 === (17))){
var inst_17762 = (state_17776[(2)]);
var state_17776__$1 = state_17776;
if(cljs.core.truth_(inst_17762)){
var statearr_17787_17851 = state_17776__$1;
(statearr_17787_17851[(1)] = (19));

} else {
var statearr_17788_17852 = state_17776__$1;
(statearr_17788_17852[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (3))){
var inst_17774 = (state_17776[(2)]);
var state_17776__$1 = state_17776;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17776__$1,inst_17774);
} else {
if((state_val_17777 === (12))){
var inst_17751 = (state_17776[(10)]);
var state_17776__$1 = state_17776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17776__$1,(14),inst_17751);
} else {
if((state_val_17777 === (2))){
var state_17776__$1 = state_17776;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17776__$1,(4),results);
} else {
if((state_val_17777 === (19))){
var state_17776__$1 = state_17776;
var statearr_17789_17853 = state_17776__$1;
(statearr_17789_17853[(2)] = null);

(statearr_17789_17853[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (11))){
var inst_17751 = (state_17776[(2)]);
var state_17776__$1 = (function (){var statearr_17790 = state_17776;
(statearr_17790[(10)] = inst_17751);

return statearr_17790;
})();
var statearr_17791_17854 = state_17776__$1;
(statearr_17791_17854[(2)] = null);

(statearr_17791_17854[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (9))){
var state_17776__$1 = state_17776;
var statearr_17792_17855 = state_17776__$1;
(statearr_17792_17855[(2)] = null);

(statearr_17792_17855[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (5))){
var state_17776__$1 = state_17776;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17793_17856 = state_17776__$1;
(statearr_17793_17856[(1)] = (8));

} else {
var statearr_17794_17857 = state_17776__$1;
(statearr_17794_17857[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (14))){
var inst_17754 = (state_17776[(8)]);
var inst_17756 = (state_17776[(11)]);
var inst_17754__$1 = (state_17776[(2)]);
var inst_17755 = (inst_17754__$1 == null);
var inst_17756__$1 = cljs.core.not.call(null,inst_17755);
var state_17776__$1 = (function (){var statearr_17795 = state_17776;
(statearr_17795[(8)] = inst_17754__$1);

(statearr_17795[(11)] = inst_17756__$1);

return statearr_17795;
})();
if(inst_17756__$1){
var statearr_17796_17858 = state_17776__$1;
(statearr_17796_17858[(1)] = (15));

} else {
var statearr_17797_17859 = state_17776__$1;
(statearr_17797_17859[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (16))){
var inst_17756 = (state_17776[(11)]);
var state_17776__$1 = state_17776;
var statearr_17798_17860 = state_17776__$1;
(statearr_17798_17860[(2)] = inst_17756);

(statearr_17798_17860[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (10))){
var inst_17748 = (state_17776[(2)]);
var state_17776__$1 = state_17776;
var statearr_17799_17861 = state_17776__$1;
(statearr_17799_17861[(2)] = inst_17748);

(statearr_17799_17861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (18))){
var inst_17759 = (state_17776[(2)]);
var state_17776__$1 = state_17776;
var statearr_17800_17862 = state_17776__$1;
(statearr_17800_17862[(2)] = inst_17759);

(statearr_17800_17862[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17777 === (8))){
var inst_17745 = cljs.core.async.close_BANG_.call(null,to);
var state_17776__$1 = state_17776;
var statearr_17801_17863 = state_17776__$1;
(statearr_17801_17863[(2)] = inst_17745);

(statearr_17801_17863[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17805 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17805[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17805[(1)] = (1));

return statearr_17805;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17776){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17776);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17806){if((e17806 instanceof Object)){
var ex__8254__auto__ = e17806;
var statearr_17807_17864 = state_17776;
(statearr_17807_17864[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17776);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17865 = state_17776;
state_17776 = G__17865;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17776){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17808 = f__8363__auto__.call(null);
(statearr_17808[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17866 = [];
var len__5726__auto___17869 = arguments.length;
var i__5727__auto___17870 = (0);
while(true){
if((i__5727__auto___17870 < len__5726__auto___17869)){
args17866.push((arguments[i__5727__auto___17870]));

var G__17871 = (i__5727__auto___17870 + (1));
i__5727__auto___17870 = G__17871;
continue;
} else {
}
break;
}

var G__17868 = args17866.length;
switch (G__17868) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17866.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17873 = [];
var len__5726__auto___17876 = arguments.length;
var i__5727__auto___17877 = (0);
while(true){
if((i__5727__auto___17877 < len__5726__auto___17876)){
args17873.push((arguments[i__5727__auto___17877]));

var G__17878 = (i__5727__auto___17877 + (1));
i__5727__auto___17877 = G__17878;
continue;
} else {
}
break;
}

var G__17875 = args17873.length;
switch (G__17875) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17873.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17880 = [];
var len__5726__auto___17933 = arguments.length;
var i__5727__auto___17934 = (0);
while(true){
if((i__5727__auto___17934 < len__5726__auto___17933)){
args17880.push((arguments[i__5727__auto___17934]));

var G__17935 = (i__5727__auto___17934 + (1));
i__5727__auto___17934 = G__17935;
continue;
} else {
}
break;
}

var G__17882 = args17880.length;
switch (G__17882) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17880.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17937 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17937,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17937,tc,fc){
return (function (state_17908){
var state_val_17909 = (state_17908[(1)]);
if((state_val_17909 === (7))){
var inst_17904 = (state_17908[(2)]);
var state_17908__$1 = state_17908;
var statearr_17910_17938 = state_17908__$1;
(statearr_17910_17938[(2)] = inst_17904);

(statearr_17910_17938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (1))){
var state_17908__$1 = state_17908;
var statearr_17911_17939 = state_17908__$1;
(statearr_17911_17939[(2)] = null);

(statearr_17911_17939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (4))){
var inst_17885 = (state_17908[(7)]);
var inst_17885__$1 = (state_17908[(2)]);
var inst_17886 = (inst_17885__$1 == null);
var state_17908__$1 = (function (){var statearr_17912 = state_17908;
(statearr_17912[(7)] = inst_17885__$1);

return statearr_17912;
})();
if(cljs.core.truth_(inst_17886)){
var statearr_17913_17940 = state_17908__$1;
(statearr_17913_17940[(1)] = (5));

} else {
var statearr_17914_17941 = state_17908__$1;
(statearr_17914_17941[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (13))){
var state_17908__$1 = state_17908;
var statearr_17915_17942 = state_17908__$1;
(statearr_17915_17942[(2)] = null);

(statearr_17915_17942[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (6))){
var inst_17885 = (state_17908[(7)]);
var inst_17891 = p.call(null,inst_17885);
var state_17908__$1 = state_17908;
if(cljs.core.truth_(inst_17891)){
var statearr_17916_17943 = state_17908__$1;
(statearr_17916_17943[(1)] = (9));

} else {
var statearr_17917_17944 = state_17908__$1;
(statearr_17917_17944[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (3))){
var inst_17906 = (state_17908[(2)]);
var state_17908__$1 = state_17908;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17908__$1,inst_17906);
} else {
if((state_val_17909 === (12))){
var state_17908__$1 = state_17908;
var statearr_17918_17945 = state_17908__$1;
(statearr_17918_17945[(2)] = null);

(statearr_17918_17945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (2))){
var state_17908__$1 = state_17908;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17908__$1,(4),ch);
} else {
if((state_val_17909 === (11))){
var inst_17885 = (state_17908[(7)]);
var inst_17895 = (state_17908[(2)]);
var state_17908__$1 = state_17908;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17908__$1,(8),inst_17895,inst_17885);
} else {
if((state_val_17909 === (9))){
var state_17908__$1 = state_17908;
var statearr_17919_17946 = state_17908__$1;
(statearr_17919_17946[(2)] = tc);

(statearr_17919_17946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (5))){
var inst_17888 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17889 = cljs.core.async.close_BANG_.call(null,fc);
var state_17908__$1 = (function (){var statearr_17920 = state_17908;
(statearr_17920[(8)] = inst_17888);

return statearr_17920;
})();
var statearr_17921_17947 = state_17908__$1;
(statearr_17921_17947[(2)] = inst_17889);

(statearr_17921_17947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (14))){
var inst_17902 = (state_17908[(2)]);
var state_17908__$1 = state_17908;
var statearr_17922_17948 = state_17908__$1;
(statearr_17922_17948[(2)] = inst_17902);

(statearr_17922_17948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (10))){
var state_17908__$1 = state_17908;
var statearr_17923_17949 = state_17908__$1;
(statearr_17923_17949[(2)] = fc);

(statearr_17923_17949[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17909 === (8))){
var inst_17897 = (state_17908[(2)]);
var state_17908__$1 = state_17908;
if(cljs.core.truth_(inst_17897)){
var statearr_17924_17950 = state_17908__$1;
(statearr_17924_17950[(1)] = (12));

} else {
var statearr_17925_17951 = state_17908__$1;
(statearr_17925_17951[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17937,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17937,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17929 = [null,null,null,null,null,null,null,null,null];
(statearr_17929[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17929[(1)] = (1));

return statearr_17929;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17908){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17930){if((e17930 instanceof Object)){
var ex__8254__auto__ = e17930;
var statearr_17931_17952 = state_17908;
(statearr_17931_17952[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17908);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17930;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17953 = state_17908;
state_17908 = G__17953;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17908){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17937,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17932 = f__8363__auto__.call(null);
(statearr_17932[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17937);

return statearr_17932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17937,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18017){
var state_val_18018 = (state_18017[(1)]);
if((state_val_18018 === (7))){
var inst_18013 = (state_18017[(2)]);
var state_18017__$1 = state_18017;
var statearr_18019_18040 = state_18017__$1;
(statearr_18019_18040[(2)] = inst_18013);

(statearr_18019_18040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18018 === (1))){
var inst_17997 = init;
var state_18017__$1 = (function (){var statearr_18020 = state_18017;
(statearr_18020[(7)] = inst_17997);

return statearr_18020;
})();
var statearr_18021_18041 = state_18017__$1;
(statearr_18021_18041[(2)] = null);

(statearr_18021_18041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18018 === (4))){
var inst_18000 = (state_18017[(8)]);
var inst_18000__$1 = (state_18017[(2)]);
var inst_18001 = (inst_18000__$1 == null);
var state_18017__$1 = (function (){var statearr_18022 = state_18017;
(statearr_18022[(8)] = inst_18000__$1);

return statearr_18022;
})();
if(cljs.core.truth_(inst_18001)){
var statearr_18023_18042 = state_18017__$1;
(statearr_18023_18042[(1)] = (5));

} else {
var statearr_18024_18043 = state_18017__$1;
(statearr_18024_18043[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18018 === (6))){
var inst_17997 = (state_18017[(7)]);
var inst_18000 = (state_18017[(8)]);
var inst_18004 = (state_18017[(9)]);
var inst_18004__$1 = f.call(null,inst_17997,inst_18000);
var inst_18005 = cljs.core.reduced_QMARK_.call(null,inst_18004__$1);
var state_18017__$1 = (function (){var statearr_18025 = state_18017;
(statearr_18025[(9)] = inst_18004__$1);

return statearr_18025;
})();
if(inst_18005){
var statearr_18026_18044 = state_18017__$1;
(statearr_18026_18044[(1)] = (8));

} else {
var statearr_18027_18045 = state_18017__$1;
(statearr_18027_18045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18018 === (3))){
var inst_18015 = (state_18017[(2)]);
var state_18017__$1 = state_18017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18017__$1,inst_18015);
} else {
if((state_val_18018 === (2))){
var state_18017__$1 = state_18017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18017__$1,(4),ch);
} else {
if((state_val_18018 === (9))){
var inst_18004 = (state_18017[(9)]);
var inst_17997 = inst_18004;
var state_18017__$1 = (function (){var statearr_18028 = state_18017;
(statearr_18028[(7)] = inst_17997);

return statearr_18028;
})();
var statearr_18029_18046 = state_18017__$1;
(statearr_18029_18046[(2)] = null);

(statearr_18029_18046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18018 === (5))){
var inst_17997 = (state_18017[(7)]);
var state_18017__$1 = state_18017;
var statearr_18030_18047 = state_18017__$1;
(statearr_18030_18047[(2)] = inst_17997);

(statearr_18030_18047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18018 === (10))){
var inst_18011 = (state_18017[(2)]);
var state_18017__$1 = state_18017;
var statearr_18031_18048 = state_18017__$1;
(statearr_18031_18048[(2)] = inst_18011);

(statearr_18031_18048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18018 === (8))){
var inst_18004 = (state_18017[(9)]);
var inst_18007 = cljs.core.deref.call(null,inst_18004);
var state_18017__$1 = state_18017;
var statearr_18032_18049 = state_18017__$1;
(statearr_18032_18049[(2)] = inst_18007);

(statearr_18032_18049[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18036 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18036[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18036[(1)] = (1));

return statearr_18036;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18017){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18037){if((e18037 instanceof Object)){
var ex__8254__auto__ = e18037;
var statearr_18038_18050 = state_18017;
(statearr_18038_18050[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18037;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18051 = state_18017;
state_18017 = G__18051;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18017){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18039 = f__8363__auto__.call(null);
(statearr_18039[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18052 = [];
var len__5726__auto___18104 = arguments.length;
var i__5727__auto___18105 = (0);
while(true){
if((i__5727__auto___18105 < len__5726__auto___18104)){
args18052.push((arguments[i__5727__auto___18105]));

var G__18106 = (i__5727__auto___18105 + (1));
i__5727__auto___18105 = G__18106;
continue;
} else {
}
break;
}

var G__18054 = args18052.length;
switch (G__18054) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18052.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18079){
var state_val_18080 = (state_18079[(1)]);
if((state_val_18080 === (7))){
var inst_18061 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
var statearr_18081_18108 = state_18079__$1;
(statearr_18081_18108[(2)] = inst_18061);

(statearr_18081_18108[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (1))){
var inst_18055 = cljs.core.seq.call(null,coll);
var inst_18056 = inst_18055;
var state_18079__$1 = (function (){var statearr_18082 = state_18079;
(statearr_18082[(7)] = inst_18056);

return statearr_18082;
})();
var statearr_18083_18109 = state_18079__$1;
(statearr_18083_18109[(2)] = null);

(statearr_18083_18109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (4))){
var inst_18056 = (state_18079[(7)]);
var inst_18059 = cljs.core.first.call(null,inst_18056);
var state_18079__$1 = state_18079;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18079__$1,(7),ch,inst_18059);
} else {
if((state_val_18080 === (13))){
var inst_18073 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
var statearr_18084_18110 = state_18079__$1;
(statearr_18084_18110[(2)] = inst_18073);

(statearr_18084_18110[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (6))){
var inst_18064 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
if(cljs.core.truth_(inst_18064)){
var statearr_18085_18111 = state_18079__$1;
(statearr_18085_18111[(1)] = (8));

} else {
var statearr_18086_18112 = state_18079__$1;
(statearr_18086_18112[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (3))){
var inst_18077 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18079__$1,inst_18077);
} else {
if((state_val_18080 === (12))){
var state_18079__$1 = state_18079;
var statearr_18087_18113 = state_18079__$1;
(statearr_18087_18113[(2)] = null);

(statearr_18087_18113[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (2))){
var inst_18056 = (state_18079[(7)]);
var state_18079__$1 = state_18079;
if(cljs.core.truth_(inst_18056)){
var statearr_18088_18114 = state_18079__$1;
(statearr_18088_18114[(1)] = (4));

} else {
var statearr_18089_18115 = state_18079__$1;
(statearr_18089_18115[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (11))){
var inst_18070 = cljs.core.async.close_BANG_.call(null,ch);
var state_18079__$1 = state_18079;
var statearr_18090_18116 = state_18079__$1;
(statearr_18090_18116[(2)] = inst_18070);

(statearr_18090_18116[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (9))){
var state_18079__$1 = state_18079;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18091_18117 = state_18079__$1;
(statearr_18091_18117[(1)] = (11));

} else {
var statearr_18092_18118 = state_18079__$1;
(statearr_18092_18118[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (5))){
var inst_18056 = (state_18079[(7)]);
var state_18079__$1 = state_18079;
var statearr_18093_18119 = state_18079__$1;
(statearr_18093_18119[(2)] = inst_18056);

(statearr_18093_18119[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (10))){
var inst_18075 = (state_18079[(2)]);
var state_18079__$1 = state_18079;
var statearr_18094_18120 = state_18079__$1;
(statearr_18094_18120[(2)] = inst_18075);

(statearr_18094_18120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18080 === (8))){
var inst_18056 = (state_18079[(7)]);
var inst_18066 = cljs.core.next.call(null,inst_18056);
var inst_18056__$1 = inst_18066;
var state_18079__$1 = (function (){var statearr_18095 = state_18079;
(statearr_18095[(7)] = inst_18056__$1);

return statearr_18095;
})();
var statearr_18096_18121 = state_18079__$1;
(statearr_18096_18121[(2)] = null);

(statearr_18096_18121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18100 = [null,null,null,null,null,null,null,null];
(statearr_18100[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18100[(1)] = (1));

return statearr_18100;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18079){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18101){if((e18101 instanceof Object)){
var ex__8254__auto__ = e18101;
var statearr_18102_18122 = state_18079;
(statearr_18102_18122[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18079);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18101;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18123 = state_18079;
state_18079 = G__18123;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18079){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18103 = f__8363__auto__.call(null);
(statearr_18103[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18345 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18345 = (function (mult,ch,cs,meta18346){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18346 = meta18346;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18345.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18347,meta18346__$1){
var self__ = this;
var _18347__$1 = this;
return (new cljs.core.async.t_cljs$core$async18345(self__.mult,self__.ch,self__.cs,meta18346__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18345.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18347){
var self__ = this;
var _18347__$1 = this;
return self__.meta18346;
});})(cs))
;

cljs.core.async.t_cljs$core$async18345.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18345.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18345.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18345.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18345.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18345.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18345.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18346","meta18346",-1843538467,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18345.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18345.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18345";

cljs.core.async.t_cljs$core$async18345.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18345");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18345 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18345(mult__$1,ch__$1,cs__$1,meta18346){
return (new cljs.core.async.t_cljs$core$async18345(mult__$1,ch__$1,cs__$1,meta18346));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18345(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18566 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18566,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18566,cs,m,dchan,dctr,done){
return (function (state_18478){
var state_val_18479 = (state_18478[(1)]);
if((state_val_18479 === (7))){
var inst_18474 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18480_18567 = state_18478__$1;
(statearr_18480_18567[(2)] = inst_18474);

(statearr_18480_18567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (20))){
var inst_18379 = (state_18478[(7)]);
var inst_18389 = cljs.core.first.call(null,inst_18379);
var inst_18390 = cljs.core.nth.call(null,inst_18389,(0),null);
var inst_18391 = cljs.core.nth.call(null,inst_18389,(1),null);
var state_18478__$1 = (function (){var statearr_18481 = state_18478;
(statearr_18481[(8)] = inst_18390);

return statearr_18481;
})();
if(cljs.core.truth_(inst_18391)){
var statearr_18482_18568 = state_18478__$1;
(statearr_18482_18568[(1)] = (22));

} else {
var statearr_18483_18569 = state_18478__$1;
(statearr_18483_18569[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (27))){
var inst_18426 = (state_18478[(9)]);
var inst_18350 = (state_18478[(10)]);
var inst_18419 = (state_18478[(11)]);
var inst_18421 = (state_18478[(12)]);
var inst_18426__$1 = cljs.core._nth.call(null,inst_18419,inst_18421);
var inst_18427 = cljs.core.async.put_BANG_.call(null,inst_18426__$1,inst_18350,done);
var state_18478__$1 = (function (){var statearr_18484 = state_18478;
(statearr_18484[(9)] = inst_18426__$1);

return statearr_18484;
})();
if(cljs.core.truth_(inst_18427)){
var statearr_18485_18570 = state_18478__$1;
(statearr_18485_18570[(1)] = (30));

} else {
var statearr_18486_18571 = state_18478__$1;
(statearr_18486_18571[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (1))){
var state_18478__$1 = state_18478;
var statearr_18487_18572 = state_18478__$1;
(statearr_18487_18572[(2)] = null);

(statearr_18487_18572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (24))){
var inst_18379 = (state_18478[(7)]);
var inst_18396 = (state_18478[(2)]);
var inst_18397 = cljs.core.next.call(null,inst_18379);
var inst_18359 = inst_18397;
var inst_18360 = null;
var inst_18361 = (0);
var inst_18362 = (0);
var state_18478__$1 = (function (){var statearr_18488 = state_18478;
(statearr_18488[(13)] = inst_18396);

(statearr_18488[(14)] = inst_18361);

(statearr_18488[(15)] = inst_18359);

(statearr_18488[(16)] = inst_18362);

(statearr_18488[(17)] = inst_18360);

return statearr_18488;
})();
var statearr_18489_18573 = state_18478__$1;
(statearr_18489_18573[(2)] = null);

(statearr_18489_18573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (39))){
var state_18478__$1 = state_18478;
var statearr_18493_18574 = state_18478__$1;
(statearr_18493_18574[(2)] = null);

(statearr_18493_18574[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (4))){
var inst_18350 = (state_18478[(10)]);
var inst_18350__$1 = (state_18478[(2)]);
var inst_18351 = (inst_18350__$1 == null);
var state_18478__$1 = (function (){var statearr_18494 = state_18478;
(statearr_18494[(10)] = inst_18350__$1);

return statearr_18494;
})();
if(cljs.core.truth_(inst_18351)){
var statearr_18495_18575 = state_18478__$1;
(statearr_18495_18575[(1)] = (5));

} else {
var statearr_18496_18576 = state_18478__$1;
(statearr_18496_18576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (15))){
var inst_18361 = (state_18478[(14)]);
var inst_18359 = (state_18478[(15)]);
var inst_18362 = (state_18478[(16)]);
var inst_18360 = (state_18478[(17)]);
var inst_18375 = (state_18478[(2)]);
var inst_18376 = (inst_18362 + (1));
var tmp18490 = inst_18361;
var tmp18491 = inst_18359;
var tmp18492 = inst_18360;
var inst_18359__$1 = tmp18491;
var inst_18360__$1 = tmp18492;
var inst_18361__$1 = tmp18490;
var inst_18362__$1 = inst_18376;
var state_18478__$1 = (function (){var statearr_18497 = state_18478;
(statearr_18497[(14)] = inst_18361__$1);

(statearr_18497[(15)] = inst_18359__$1);

(statearr_18497[(16)] = inst_18362__$1);

(statearr_18497[(17)] = inst_18360__$1);

(statearr_18497[(18)] = inst_18375);

return statearr_18497;
})();
var statearr_18498_18577 = state_18478__$1;
(statearr_18498_18577[(2)] = null);

(statearr_18498_18577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (21))){
var inst_18400 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18502_18578 = state_18478__$1;
(statearr_18502_18578[(2)] = inst_18400);

(statearr_18502_18578[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (31))){
var inst_18426 = (state_18478[(9)]);
var inst_18430 = done.call(null,null);
var inst_18431 = cljs.core.async.untap_STAR_.call(null,m,inst_18426);
var state_18478__$1 = (function (){var statearr_18503 = state_18478;
(statearr_18503[(19)] = inst_18430);

return statearr_18503;
})();
var statearr_18504_18579 = state_18478__$1;
(statearr_18504_18579[(2)] = inst_18431);

(statearr_18504_18579[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (32))){
var inst_18420 = (state_18478[(20)]);
var inst_18419 = (state_18478[(11)]);
var inst_18421 = (state_18478[(12)]);
var inst_18418 = (state_18478[(21)]);
var inst_18433 = (state_18478[(2)]);
var inst_18434 = (inst_18421 + (1));
var tmp18499 = inst_18420;
var tmp18500 = inst_18419;
var tmp18501 = inst_18418;
var inst_18418__$1 = tmp18501;
var inst_18419__$1 = tmp18500;
var inst_18420__$1 = tmp18499;
var inst_18421__$1 = inst_18434;
var state_18478__$1 = (function (){var statearr_18505 = state_18478;
(statearr_18505[(20)] = inst_18420__$1);

(statearr_18505[(22)] = inst_18433);

(statearr_18505[(11)] = inst_18419__$1);

(statearr_18505[(12)] = inst_18421__$1);

(statearr_18505[(21)] = inst_18418__$1);

return statearr_18505;
})();
var statearr_18506_18580 = state_18478__$1;
(statearr_18506_18580[(2)] = null);

(statearr_18506_18580[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (40))){
var inst_18446 = (state_18478[(23)]);
var inst_18450 = done.call(null,null);
var inst_18451 = cljs.core.async.untap_STAR_.call(null,m,inst_18446);
var state_18478__$1 = (function (){var statearr_18507 = state_18478;
(statearr_18507[(24)] = inst_18450);

return statearr_18507;
})();
var statearr_18508_18581 = state_18478__$1;
(statearr_18508_18581[(2)] = inst_18451);

(statearr_18508_18581[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (33))){
var inst_18437 = (state_18478[(25)]);
var inst_18439 = cljs.core.chunked_seq_QMARK_.call(null,inst_18437);
var state_18478__$1 = state_18478;
if(inst_18439){
var statearr_18509_18582 = state_18478__$1;
(statearr_18509_18582[(1)] = (36));

} else {
var statearr_18510_18583 = state_18478__$1;
(statearr_18510_18583[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (13))){
var inst_18369 = (state_18478[(26)]);
var inst_18372 = cljs.core.async.close_BANG_.call(null,inst_18369);
var state_18478__$1 = state_18478;
var statearr_18511_18584 = state_18478__$1;
(statearr_18511_18584[(2)] = inst_18372);

(statearr_18511_18584[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (22))){
var inst_18390 = (state_18478[(8)]);
var inst_18393 = cljs.core.async.close_BANG_.call(null,inst_18390);
var state_18478__$1 = state_18478;
var statearr_18512_18585 = state_18478__$1;
(statearr_18512_18585[(2)] = inst_18393);

(statearr_18512_18585[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (36))){
var inst_18437 = (state_18478[(25)]);
var inst_18441 = cljs.core.chunk_first.call(null,inst_18437);
var inst_18442 = cljs.core.chunk_rest.call(null,inst_18437);
var inst_18443 = cljs.core.count.call(null,inst_18441);
var inst_18418 = inst_18442;
var inst_18419 = inst_18441;
var inst_18420 = inst_18443;
var inst_18421 = (0);
var state_18478__$1 = (function (){var statearr_18513 = state_18478;
(statearr_18513[(20)] = inst_18420);

(statearr_18513[(11)] = inst_18419);

(statearr_18513[(12)] = inst_18421);

(statearr_18513[(21)] = inst_18418);

return statearr_18513;
})();
var statearr_18514_18586 = state_18478__$1;
(statearr_18514_18586[(2)] = null);

(statearr_18514_18586[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (41))){
var inst_18437 = (state_18478[(25)]);
var inst_18453 = (state_18478[(2)]);
var inst_18454 = cljs.core.next.call(null,inst_18437);
var inst_18418 = inst_18454;
var inst_18419 = null;
var inst_18420 = (0);
var inst_18421 = (0);
var state_18478__$1 = (function (){var statearr_18515 = state_18478;
(statearr_18515[(27)] = inst_18453);

(statearr_18515[(20)] = inst_18420);

(statearr_18515[(11)] = inst_18419);

(statearr_18515[(12)] = inst_18421);

(statearr_18515[(21)] = inst_18418);

return statearr_18515;
})();
var statearr_18516_18587 = state_18478__$1;
(statearr_18516_18587[(2)] = null);

(statearr_18516_18587[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (43))){
var state_18478__$1 = state_18478;
var statearr_18517_18588 = state_18478__$1;
(statearr_18517_18588[(2)] = null);

(statearr_18517_18588[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (29))){
var inst_18462 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18518_18589 = state_18478__$1;
(statearr_18518_18589[(2)] = inst_18462);

(statearr_18518_18589[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (44))){
var inst_18471 = (state_18478[(2)]);
var state_18478__$1 = (function (){var statearr_18519 = state_18478;
(statearr_18519[(28)] = inst_18471);

return statearr_18519;
})();
var statearr_18520_18590 = state_18478__$1;
(statearr_18520_18590[(2)] = null);

(statearr_18520_18590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (6))){
var inst_18410 = (state_18478[(29)]);
var inst_18409 = cljs.core.deref.call(null,cs);
var inst_18410__$1 = cljs.core.keys.call(null,inst_18409);
var inst_18411 = cljs.core.count.call(null,inst_18410__$1);
var inst_18412 = cljs.core.reset_BANG_.call(null,dctr,inst_18411);
var inst_18417 = cljs.core.seq.call(null,inst_18410__$1);
var inst_18418 = inst_18417;
var inst_18419 = null;
var inst_18420 = (0);
var inst_18421 = (0);
var state_18478__$1 = (function (){var statearr_18521 = state_18478;
(statearr_18521[(29)] = inst_18410__$1);

(statearr_18521[(20)] = inst_18420);

(statearr_18521[(30)] = inst_18412);

(statearr_18521[(11)] = inst_18419);

(statearr_18521[(12)] = inst_18421);

(statearr_18521[(21)] = inst_18418);

return statearr_18521;
})();
var statearr_18522_18591 = state_18478__$1;
(statearr_18522_18591[(2)] = null);

(statearr_18522_18591[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (28))){
var inst_18418 = (state_18478[(21)]);
var inst_18437 = (state_18478[(25)]);
var inst_18437__$1 = cljs.core.seq.call(null,inst_18418);
var state_18478__$1 = (function (){var statearr_18523 = state_18478;
(statearr_18523[(25)] = inst_18437__$1);

return statearr_18523;
})();
if(inst_18437__$1){
var statearr_18524_18592 = state_18478__$1;
(statearr_18524_18592[(1)] = (33));

} else {
var statearr_18525_18593 = state_18478__$1;
(statearr_18525_18593[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (25))){
var inst_18420 = (state_18478[(20)]);
var inst_18421 = (state_18478[(12)]);
var inst_18423 = (inst_18421 < inst_18420);
var inst_18424 = inst_18423;
var state_18478__$1 = state_18478;
if(cljs.core.truth_(inst_18424)){
var statearr_18526_18594 = state_18478__$1;
(statearr_18526_18594[(1)] = (27));

} else {
var statearr_18527_18595 = state_18478__$1;
(statearr_18527_18595[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (34))){
var state_18478__$1 = state_18478;
var statearr_18528_18596 = state_18478__$1;
(statearr_18528_18596[(2)] = null);

(statearr_18528_18596[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (17))){
var state_18478__$1 = state_18478;
var statearr_18529_18597 = state_18478__$1;
(statearr_18529_18597[(2)] = null);

(statearr_18529_18597[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (3))){
var inst_18476 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18478__$1,inst_18476);
} else {
if((state_val_18479 === (12))){
var inst_18405 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18530_18598 = state_18478__$1;
(statearr_18530_18598[(2)] = inst_18405);

(statearr_18530_18598[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (2))){
var state_18478__$1 = state_18478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18478__$1,(4),ch);
} else {
if((state_val_18479 === (23))){
var state_18478__$1 = state_18478;
var statearr_18531_18599 = state_18478__$1;
(statearr_18531_18599[(2)] = null);

(statearr_18531_18599[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (35))){
var inst_18460 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18532_18600 = state_18478__$1;
(statearr_18532_18600[(2)] = inst_18460);

(statearr_18532_18600[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (19))){
var inst_18379 = (state_18478[(7)]);
var inst_18383 = cljs.core.chunk_first.call(null,inst_18379);
var inst_18384 = cljs.core.chunk_rest.call(null,inst_18379);
var inst_18385 = cljs.core.count.call(null,inst_18383);
var inst_18359 = inst_18384;
var inst_18360 = inst_18383;
var inst_18361 = inst_18385;
var inst_18362 = (0);
var state_18478__$1 = (function (){var statearr_18533 = state_18478;
(statearr_18533[(14)] = inst_18361);

(statearr_18533[(15)] = inst_18359);

(statearr_18533[(16)] = inst_18362);

(statearr_18533[(17)] = inst_18360);

return statearr_18533;
})();
var statearr_18534_18601 = state_18478__$1;
(statearr_18534_18601[(2)] = null);

(statearr_18534_18601[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (11))){
var inst_18359 = (state_18478[(15)]);
var inst_18379 = (state_18478[(7)]);
var inst_18379__$1 = cljs.core.seq.call(null,inst_18359);
var state_18478__$1 = (function (){var statearr_18535 = state_18478;
(statearr_18535[(7)] = inst_18379__$1);

return statearr_18535;
})();
if(inst_18379__$1){
var statearr_18536_18602 = state_18478__$1;
(statearr_18536_18602[(1)] = (16));

} else {
var statearr_18537_18603 = state_18478__$1;
(statearr_18537_18603[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (9))){
var inst_18407 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18538_18604 = state_18478__$1;
(statearr_18538_18604[(2)] = inst_18407);

(statearr_18538_18604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (5))){
var inst_18357 = cljs.core.deref.call(null,cs);
var inst_18358 = cljs.core.seq.call(null,inst_18357);
var inst_18359 = inst_18358;
var inst_18360 = null;
var inst_18361 = (0);
var inst_18362 = (0);
var state_18478__$1 = (function (){var statearr_18539 = state_18478;
(statearr_18539[(14)] = inst_18361);

(statearr_18539[(15)] = inst_18359);

(statearr_18539[(16)] = inst_18362);

(statearr_18539[(17)] = inst_18360);

return statearr_18539;
})();
var statearr_18540_18605 = state_18478__$1;
(statearr_18540_18605[(2)] = null);

(statearr_18540_18605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (14))){
var state_18478__$1 = state_18478;
var statearr_18541_18606 = state_18478__$1;
(statearr_18541_18606[(2)] = null);

(statearr_18541_18606[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (45))){
var inst_18468 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18542_18607 = state_18478__$1;
(statearr_18542_18607[(2)] = inst_18468);

(statearr_18542_18607[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (26))){
var inst_18410 = (state_18478[(29)]);
var inst_18464 = (state_18478[(2)]);
var inst_18465 = cljs.core.seq.call(null,inst_18410);
var state_18478__$1 = (function (){var statearr_18543 = state_18478;
(statearr_18543[(31)] = inst_18464);

return statearr_18543;
})();
if(inst_18465){
var statearr_18544_18608 = state_18478__$1;
(statearr_18544_18608[(1)] = (42));

} else {
var statearr_18545_18609 = state_18478__$1;
(statearr_18545_18609[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (16))){
var inst_18379 = (state_18478[(7)]);
var inst_18381 = cljs.core.chunked_seq_QMARK_.call(null,inst_18379);
var state_18478__$1 = state_18478;
if(inst_18381){
var statearr_18546_18610 = state_18478__$1;
(statearr_18546_18610[(1)] = (19));

} else {
var statearr_18547_18611 = state_18478__$1;
(statearr_18547_18611[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (38))){
var inst_18457 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18548_18612 = state_18478__$1;
(statearr_18548_18612[(2)] = inst_18457);

(statearr_18548_18612[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (30))){
var state_18478__$1 = state_18478;
var statearr_18549_18613 = state_18478__$1;
(statearr_18549_18613[(2)] = null);

(statearr_18549_18613[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (10))){
var inst_18362 = (state_18478[(16)]);
var inst_18360 = (state_18478[(17)]);
var inst_18368 = cljs.core._nth.call(null,inst_18360,inst_18362);
var inst_18369 = cljs.core.nth.call(null,inst_18368,(0),null);
var inst_18370 = cljs.core.nth.call(null,inst_18368,(1),null);
var state_18478__$1 = (function (){var statearr_18550 = state_18478;
(statearr_18550[(26)] = inst_18369);

return statearr_18550;
})();
if(cljs.core.truth_(inst_18370)){
var statearr_18551_18614 = state_18478__$1;
(statearr_18551_18614[(1)] = (13));

} else {
var statearr_18552_18615 = state_18478__$1;
(statearr_18552_18615[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (18))){
var inst_18403 = (state_18478[(2)]);
var state_18478__$1 = state_18478;
var statearr_18553_18616 = state_18478__$1;
(statearr_18553_18616[(2)] = inst_18403);

(statearr_18553_18616[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (42))){
var state_18478__$1 = state_18478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18478__$1,(45),dchan);
} else {
if((state_val_18479 === (37))){
var inst_18446 = (state_18478[(23)]);
var inst_18350 = (state_18478[(10)]);
var inst_18437 = (state_18478[(25)]);
var inst_18446__$1 = cljs.core.first.call(null,inst_18437);
var inst_18447 = cljs.core.async.put_BANG_.call(null,inst_18446__$1,inst_18350,done);
var state_18478__$1 = (function (){var statearr_18554 = state_18478;
(statearr_18554[(23)] = inst_18446__$1);

return statearr_18554;
})();
if(cljs.core.truth_(inst_18447)){
var statearr_18555_18617 = state_18478__$1;
(statearr_18555_18617[(1)] = (39));

} else {
var statearr_18556_18618 = state_18478__$1;
(statearr_18556_18618[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18479 === (8))){
var inst_18361 = (state_18478[(14)]);
var inst_18362 = (state_18478[(16)]);
var inst_18364 = (inst_18362 < inst_18361);
var inst_18365 = inst_18364;
var state_18478__$1 = state_18478;
if(cljs.core.truth_(inst_18365)){
var statearr_18557_18619 = state_18478__$1;
(statearr_18557_18619[(1)] = (10));

} else {
var statearr_18558_18620 = state_18478__$1;
(statearr_18558_18620[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18566,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18566,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18562 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18562[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18562[(1)] = (1));

return statearr_18562;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18478){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18563){if((e18563 instanceof Object)){
var ex__8254__auto__ = e18563;
var statearr_18564_18621 = state_18478;
(statearr_18564_18621[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18478);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18563;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18622 = state_18478;
state_18478 = G__18622;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18478){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18566,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18565 = f__8363__auto__.call(null);
(statearr_18565[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18566);

return statearr_18565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18566,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18623 = [];
var len__5726__auto___18626 = arguments.length;
var i__5727__auto___18627 = (0);
while(true){
if((i__5727__auto___18627 < len__5726__auto___18626)){
args18623.push((arguments[i__5727__auto___18627]));

var G__18628 = (i__5727__auto___18627 + (1));
i__5727__auto___18627 = G__18628;
continue;
} else {
}
break;
}

var G__18625 = args18623.length;
switch (G__18625) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18623.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18640 = arguments.length;
var i__5727__auto___18641 = (0);
while(true){
if((i__5727__auto___18641 < len__5726__auto___18640)){
args__5733__auto__.push((arguments[i__5727__auto___18641]));

var G__18642 = (i__5727__auto___18641 + (1));
i__5727__auto___18641 = G__18642;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18634){
var map__18635 = p__18634;
var map__18635__$1 = ((((!((map__18635 == null)))?((((map__18635.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18635.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18635):map__18635);
var opts = map__18635__$1;
var statearr_18637_18643 = state;
(statearr_18637_18643[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18635,map__18635__$1,opts){
return (function (val){
var statearr_18638_18644 = state;
(statearr_18638_18644[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18635,map__18635__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18639_18645 = state;
(statearr_18639_18645[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18630){
var G__18631 = cljs.core.first.call(null,seq18630);
var seq18630__$1 = cljs.core.next.call(null,seq18630);
var G__18632 = cljs.core.first.call(null,seq18630__$1);
var seq18630__$2 = cljs.core.next.call(null,seq18630__$1);
var G__18633 = cljs.core.first.call(null,seq18630__$2);
var seq18630__$3 = cljs.core.next.call(null,seq18630__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18631,G__18632,G__18633,seq18630__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18809 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18809 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18810){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18810 = meta18810;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18811,meta18810__$1){
var self__ = this;
var _18811__$1 = this;
return (new cljs.core.async.t_cljs$core$async18809(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18810__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18811){
var self__ = this;
var _18811__$1 = this;
return self__.meta18810;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18810","meta18810",-1780512235,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18809.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18809.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18809";

cljs.core.async.t_cljs$core$async18809.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18809");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18809 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18809(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18810){
return (new cljs.core.async.t_cljs$core$async18809(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18810));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18809(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___18972 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18972,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18972,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18909){
var state_val_18910 = (state_18909[(1)]);
if((state_val_18910 === (7))){
var inst_18827 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
var statearr_18911_18973 = state_18909__$1;
(statearr_18911_18973[(2)] = inst_18827);

(statearr_18911_18973[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (20))){
var inst_18839 = (state_18909[(7)]);
var state_18909__$1 = state_18909;
var statearr_18912_18974 = state_18909__$1;
(statearr_18912_18974[(2)] = inst_18839);

(statearr_18912_18974[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (27))){
var state_18909__$1 = state_18909;
var statearr_18913_18975 = state_18909__$1;
(statearr_18913_18975[(2)] = null);

(statearr_18913_18975[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (1))){
var inst_18815 = (state_18909[(8)]);
var inst_18815__$1 = calc_state.call(null);
var inst_18817 = (inst_18815__$1 == null);
var inst_18818 = cljs.core.not.call(null,inst_18817);
var state_18909__$1 = (function (){var statearr_18914 = state_18909;
(statearr_18914[(8)] = inst_18815__$1);

return statearr_18914;
})();
if(inst_18818){
var statearr_18915_18976 = state_18909__$1;
(statearr_18915_18976[(1)] = (2));

} else {
var statearr_18916_18977 = state_18909__$1;
(statearr_18916_18977[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (24))){
var inst_18883 = (state_18909[(9)]);
var inst_18862 = (state_18909[(10)]);
var inst_18869 = (state_18909[(11)]);
var inst_18883__$1 = inst_18862.call(null,inst_18869);
var state_18909__$1 = (function (){var statearr_18917 = state_18909;
(statearr_18917[(9)] = inst_18883__$1);

return statearr_18917;
})();
if(cljs.core.truth_(inst_18883__$1)){
var statearr_18918_18978 = state_18909__$1;
(statearr_18918_18978[(1)] = (29));

} else {
var statearr_18919_18979 = state_18909__$1;
(statearr_18919_18979[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (4))){
var inst_18830 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
if(cljs.core.truth_(inst_18830)){
var statearr_18920_18980 = state_18909__$1;
(statearr_18920_18980[(1)] = (8));

} else {
var statearr_18921_18981 = state_18909__$1;
(statearr_18921_18981[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (15))){
var inst_18856 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
if(cljs.core.truth_(inst_18856)){
var statearr_18922_18982 = state_18909__$1;
(statearr_18922_18982[(1)] = (19));

} else {
var statearr_18923_18983 = state_18909__$1;
(statearr_18923_18983[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (21))){
var inst_18861 = (state_18909[(12)]);
var inst_18861__$1 = (state_18909[(2)]);
var inst_18862 = cljs.core.get.call(null,inst_18861__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18863 = cljs.core.get.call(null,inst_18861__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18864 = cljs.core.get.call(null,inst_18861__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18909__$1 = (function (){var statearr_18924 = state_18909;
(statearr_18924[(12)] = inst_18861__$1);

(statearr_18924[(13)] = inst_18863);

(statearr_18924[(10)] = inst_18862);

return statearr_18924;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18909__$1,(22),inst_18864);
} else {
if((state_val_18910 === (31))){
var inst_18891 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
if(cljs.core.truth_(inst_18891)){
var statearr_18925_18984 = state_18909__$1;
(statearr_18925_18984[(1)] = (32));

} else {
var statearr_18926_18985 = state_18909__$1;
(statearr_18926_18985[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (32))){
var inst_18868 = (state_18909[(14)]);
var state_18909__$1 = state_18909;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18909__$1,(35),out,inst_18868);
} else {
if((state_val_18910 === (33))){
var inst_18861 = (state_18909[(12)]);
var inst_18839 = inst_18861;
var state_18909__$1 = (function (){var statearr_18927 = state_18909;
(statearr_18927[(7)] = inst_18839);

return statearr_18927;
})();
var statearr_18928_18986 = state_18909__$1;
(statearr_18928_18986[(2)] = null);

(statearr_18928_18986[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (13))){
var inst_18839 = (state_18909[(7)]);
var inst_18846 = inst_18839.cljs$lang$protocol_mask$partition0$;
var inst_18847 = (inst_18846 & (64));
var inst_18848 = inst_18839.cljs$core$ISeq$;
var inst_18849 = (inst_18847) || (inst_18848);
var state_18909__$1 = state_18909;
if(cljs.core.truth_(inst_18849)){
var statearr_18929_18987 = state_18909__$1;
(statearr_18929_18987[(1)] = (16));

} else {
var statearr_18930_18988 = state_18909__$1;
(statearr_18930_18988[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (22))){
var inst_18868 = (state_18909[(14)]);
var inst_18869 = (state_18909[(11)]);
var inst_18867 = (state_18909[(2)]);
var inst_18868__$1 = cljs.core.nth.call(null,inst_18867,(0),null);
var inst_18869__$1 = cljs.core.nth.call(null,inst_18867,(1),null);
var inst_18870 = (inst_18868__$1 == null);
var inst_18871 = cljs.core._EQ_.call(null,inst_18869__$1,change);
var inst_18872 = (inst_18870) || (inst_18871);
var state_18909__$1 = (function (){var statearr_18931 = state_18909;
(statearr_18931[(14)] = inst_18868__$1);

(statearr_18931[(11)] = inst_18869__$1);

return statearr_18931;
})();
if(cljs.core.truth_(inst_18872)){
var statearr_18932_18989 = state_18909__$1;
(statearr_18932_18989[(1)] = (23));

} else {
var statearr_18933_18990 = state_18909__$1;
(statearr_18933_18990[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (36))){
var inst_18861 = (state_18909[(12)]);
var inst_18839 = inst_18861;
var state_18909__$1 = (function (){var statearr_18934 = state_18909;
(statearr_18934[(7)] = inst_18839);

return statearr_18934;
})();
var statearr_18935_18991 = state_18909__$1;
(statearr_18935_18991[(2)] = null);

(statearr_18935_18991[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (29))){
var inst_18883 = (state_18909[(9)]);
var state_18909__$1 = state_18909;
var statearr_18936_18992 = state_18909__$1;
(statearr_18936_18992[(2)] = inst_18883);

(statearr_18936_18992[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (6))){
var state_18909__$1 = state_18909;
var statearr_18937_18993 = state_18909__$1;
(statearr_18937_18993[(2)] = false);

(statearr_18937_18993[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (28))){
var inst_18879 = (state_18909[(2)]);
var inst_18880 = calc_state.call(null);
var inst_18839 = inst_18880;
var state_18909__$1 = (function (){var statearr_18938 = state_18909;
(statearr_18938[(7)] = inst_18839);

(statearr_18938[(15)] = inst_18879);

return statearr_18938;
})();
var statearr_18939_18994 = state_18909__$1;
(statearr_18939_18994[(2)] = null);

(statearr_18939_18994[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (25))){
var inst_18905 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
var statearr_18940_18995 = state_18909__$1;
(statearr_18940_18995[(2)] = inst_18905);

(statearr_18940_18995[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (34))){
var inst_18903 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
var statearr_18941_18996 = state_18909__$1;
(statearr_18941_18996[(2)] = inst_18903);

(statearr_18941_18996[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (17))){
var state_18909__$1 = state_18909;
var statearr_18942_18997 = state_18909__$1;
(statearr_18942_18997[(2)] = false);

(statearr_18942_18997[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (3))){
var state_18909__$1 = state_18909;
var statearr_18943_18998 = state_18909__$1;
(statearr_18943_18998[(2)] = false);

(statearr_18943_18998[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (12))){
var inst_18907 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18909__$1,inst_18907);
} else {
if((state_val_18910 === (2))){
var inst_18815 = (state_18909[(8)]);
var inst_18820 = inst_18815.cljs$lang$protocol_mask$partition0$;
var inst_18821 = (inst_18820 & (64));
var inst_18822 = inst_18815.cljs$core$ISeq$;
var inst_18823 = (inst_18821) || (inst_18822);
var state_18909__$1 = state_18909;
if(cljs.core.truth_(inst_18823)){
var statearr_18944_18999 = state_18909__$1;
(statearr_18944_18999[(1)] = (5));

} else {
var statearr_18945_19000 = state_18909__$1;
(statearr_18945_19000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (23))){
var inst_18868 = (state_18909[(14)]);
var inst_18874 = (inst_18868 == null);
var state_18909__$1 = state_18909;
if(cljs.core.truth_(inst_18874)){
var statearr_18946_19001 = state_18909__$1;
(statearr_18946_19001[(1)] = (26));

} else {
var statearr_18947_19002 = state_18909__$1;
(statearr_18947_19002[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (35))){
var inst_18894 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
if(cljs.core.truth_(inst_18894)){
var statearr_18948_19003 = state_18909__$1;
(statearr_18948_19003[(1)] = (36));

} else {
var statearr_18949_19004 = state_18909__$1;
(statearr_18949_19004[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (19))){
var inst_18839 = (state_18909[(7)]);
var inst_18858 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18839);
var state_18909__$1 = state_18909;
var statearr_18950_19005 = state_18909__$1;
(statearr_18950_19005[(2)] = inst_18858);

(statearr_18950_19005[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (11))){
var inst_18839 = (state_18909[(7)]);
var inst_18843 = (inst_18839 == null);
var inst_18844 = cljs.core.not.call(null,inst_18843);
var state_18909__$1 = state_18909;
if(inst_18844){
var statearr_18951_19006 = state_18909__$1;
(statearr_18951_19006[(1)] = (13));

} else {
var statearr_18952_19007 = state_18909__$1;
(statearr_18952_19007[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (9))){
var inst_18815 = (state_18909[(8)]);
var state_18909__$1 = state_18909;
var statearr_18953_19008 = state_18909__$1;
(statearr_18953_19008[(2)] = inst_18815);

(statearr_18953_19008[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (5))){
var state_18909__$1 = state_18909;
var statearr_18954_19009 = state_18909__$1;
(statearr_18954_19009[(2)] = true);

(statearr_18954_19009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (14))){
var state_18909__$1 = state_18909;
var statearr_18955_19010 = state_18909__$1;
(statearr_18955_19010[(2)] = false);

(statearr_18955_19010[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (26))){
var inst_18869 = (state_18909[(11)]);
var inst_18876 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18869);
var state_18909__$1 = state_18909;
var statearr_18956_19011 = state_18909__$1;
(statearr_18956_19011[(2)] = inst_18876);

(statearr_18956_19011[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (16))){
var state_18909__$1 = state_18909;
var statearr_18957_19012 = state_18909__$1;
(statearr_18957_19012[(2)] = true);

(statearr_18957_19012[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (38))){
var inst_18899 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
var statearr_18958_19013 = state_18909__$1;
(statearr_18958_19013[(2)] = inst_18899);

(statearr_18958_19013[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (30))){
var inst_18863 = (state_18909[(13)]);
var inst_18862 = (state_18909[(10)]);
var inst_18869 = (state_18909[(11)]);
var inst_18886 = cljs.core.empty_QMARK_.call(null,inst_18862);
var inst_18887 = inst_18863.call(null,inst_18869);
var inst_18888 = cljs.core.not.call(null,inst_18887);
var inst_18889 = (inst_18886) && (inst_18888);
var state_18909__$1 = state_18909;
var statearr_18959_19014 = state_18909__$1;
(statearr_18959_19014[(2)] = inst_18889);

(statearr_18959_19014[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (10))){
var inst_18815 = (state_18909[(8)]);
var inst_18835 = (state_18909[(2)]);
var inst_18836 = cljs.core.get.call(null,inst_18835,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18837 = cljs.core.get.call(null,inst_18835,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18838 = cljs.core.get.call(null,inst_18835,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18839 = inst_18815;
var state_18909__$1 = (function (){var statearr_18960 = state_18909;
(statearr_18960[(16)] = inst_18836);

(statearr_18960[(7)] = inst_18839);

(statearr_18960[(17)] = inst_18838);

(statearr_18960[(18)] = inst_18837);

return statearr_18960;
})();
var statearr_18961_19015 = state_18909__$1;
(statearr_18961_19015[(2)] = null);

(statearr_18961_19015[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (18))){
var inst_18853 = (state_18909[(2)]);
var state_18909__$1 = state_18909;
var statearr_18962_19016 = state_18909__$1;
(statearr_18962_19016[(2)] = inst_18853);

(statearr_18962_19016[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (37))){
var state_18909__$1 = state_18909;
var statearr_18963_19017 = state_18909__$1;
(statearr_18963_19017[(2)] = null);

(statearr_18963_19017[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18910 === (8))){
var inst_18815 = (state_18909[(8)]);
var inst_18832 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18815);
var state_18909__$1 = state_18909;
var statearr_18964_19018 = state_18909__$1;
(statearr_18964_19018[(2)] = inst_18832);

(statearr_18964_19018[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18972,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___18972,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_18968 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18968[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_18968[(1)] = (1));

return statearr_18968;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18909){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18969){if((e18969 instanceof Object)){
var ex__8254__auto__ = e18969;
var statearr_18970_19019 = state_18909;
(statearr_18970_19019[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18969;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19020 = state_18909;
state_18909 = G__19020;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18909){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18972,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_18971 = f__8363__auto__.call(null);
(statearr_18971[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18972);

return statearr_18971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18972,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19021 = [];
var len__5726__auto___19024 = arguments.length;
var i__5727__auto___19025 = (0);
while(true){
if((i__5727__auto___19025 < len__5726__auto___19024)){
args19021.push((arguments[i__5727__auto___19025]));

var G__19026 = (i__5727__auto___19025 + (1));
i__5727__auto___19025 = G__19026;
continue;
} else {
}
break;
}

var G__19023 = args19021.length;
switch (G__19023) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19021.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19029 = [];
var len__5726__auto___19154 = arguments.length;
var i__5727__auto___19155 = (0);
while(true){
if((i__5727__auto___19155 < len__5726__auto___19154)){
args19029.push((arguments[i__5727__auto___19155]));

var G__19156 = (i__5727__auto___19155 + (1));
i__5727__auto___19155 = G__19156;
continue;
} else {
}
break;
}

var G__19031 = args19029.length;
switch (G__19031) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19029.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19028_SHARP_){
if(cljs.core.truth_(p1__19028_SHARP_.call(null,topic))){
return p1__19028_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19028_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19032 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19032 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19033){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19033 = meta19033;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19034,meta19033__$1){
var self__ = this;
var _19034__$1 = this;
return (new cljs.core.async.t_cljs$core$async19032(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19033__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19034){
var self__ = this;
var _19034__$1 = this;
return self__.meta19033;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19032.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19032.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19033","meta19033",1422629552,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19032.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19032.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19032";

cljs.core.async.t_cljs$core$async19032.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19032");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19032 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19032(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19033){
return (new cljs.core.async.t_cljs$core$async19032(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19033));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19032(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19158 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19158,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19158,mults,ensure_mult,p){
return (function (state_19106){
var state_val_19107 = (state_19106[(1)]);
if((state_val_19107 === (7))){
var inst_19102 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
var statearr_19108_19159 = state_19106__$1;
(statearr_19108_19159[(2)] = inst_19102);

(statearr_19108_19159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (20))){
var state_19106__$1 = state_19106;
var statearr_19109_19160 = state_19106__$1;
(statearr_19109_19160[(2)] = null);

(statearr_19109_19160[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (1))){
var state_19106__$1 = state_19106;
var statearr_19110_19161 = state_19106__$1;
(statearr_19110_19161[(2)] = null);

(statearr_19110_19161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (24))){
var inst_19085 = (state_19106[(7)]);
var inst_19094 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19085);
var state_19106__$1 = state_19106;
var statearr_19111_19162 = state_19106__$1;
(statearr_19111_19162[(2)] = inst_19094);

(statearr_19111_19162[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (4))){
var inst_19037 = (state_19106[(8)]);
var inst_19037__$1 = (state_19106[(2)]);
var inst_19038 = (inst_19037__$1 == null);
var state_19106__$1 = (function (){var statearr_19112 = state_19106;
(statearr_19112[(8)] = inst_19037__$1);

return statearr_19112;
})();
if(cljs.core.truth_(inst_19038)){
var statearr_19113_19163 = state_19106__$1;
(statearr_19113_19163[(1)] = (5));

} else {
var statearr_19114_19164 = state_19106__$1;
(statearr_19114_19164[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (15))){
var inst_19079 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
var statearr_19115_19165 = state_19106__$1;
(statearr_19115_19165[(2)] = inst_19079);

(statearr_19115_19165[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (21))){
var inst_19099 = (state_19106[(2)]);
var state_19106__$1 = (function (){var statearr_19116 = state_19106;
(statearr_19116[(9)] = inst_19099);

return statearr_19116;
})();
var statearr_19117_19166 = state_19106__$1;
(statearr_19117_19166[(2)] = null);

(statearr_19117_19166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (13))){
var inst_19061 = (state_19106[(10)]);
var inst_19063 = cljs.core.chunked_seq_QMARK_.call(null,inst_19061);
var state_19106__$1 = state_19106;
if(inst_19063){
var statearr_19118_19167 = state_19106__$1;
(statearr_19118_19167[(1)] = (16));

} else {
var statearr_19119_19168 = state_19106__$1;
(statearr_19119_19168[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (22))){
var inst_19091 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
if(cljs.core.truth_(inst_19091)){
var statearr_19120_19169 = state_19106__$1;
(statearr_19120_19169[(1)] = (23));

} else {
var statearr_19121_19170 = state_19106__$1;
(statearr_19121_19170[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (6))){
var inst_19037 = (state_19106[(8)]);
var inst_19087 = (state_19106[(11)]);
var inst_19085 = (state_19106[(7)]);
var inst_19085__$1 = topic_fn.call(null,inst_19037);
var inst_19086 = cljs.core.deref.call(null,mults);
var inst_19087__$1 = cljs.core.get.call(null,inst_19086,inst_19085__$1);
var state_19106__$1 = (function (){var statearr_19122 = state_19106;
(statearr_19122[(11)] = inst_19087__$1);

(statearr_19122[(7)] = inst_19085__$1);

return statearr_19122;
})();
if(cljs.core.truth_(inst_19087__$1)){
var statearr_19123_19171 = state_19106__$1;
(statearr_19123_19171[(1)] = (19));

} else {
var statearr_19124_19172 = state_19106__$1;
(statearr_19124_19172[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (25))){
var inst_19096 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
var statearr_19125_19173 = state_19106__$1;
(statearr_19125_19173[(2)] = inst_19096);

(statearr_19125_19173[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (17))){
var inst_19061 = (state_19106[(10)]);
var inst_19070 = cljs.core.first.call(null,inst_19061);
var inst_19071 = cljs.core.async.muxch_STAR_.call(null,inst_19070);
var inst_19072 = cljs.core.async.close_BANG_.call(null,inst_19071);
var inst_19073 = cljs.core.next.call(null,inst_19061);
var inst_19047 = inst_19073;
var inst_19048 = null;
var inst_19049 = (0);
var inst_19050 = (0);
var state_19106__$1 = (function (){var statearr_19126 = state_19106;
(statearr_19126[(12)] = inst_19047);

(statearr_19126[(13)] = inst_19050);

(statearr_19126[(14)] = inst_19072);

(statearr_19126[(15)] = inst_19048);

(statearr_19126[(16)] = inst_19049);

return statearr_19126;
})();
var statearr_19127_19174 = state_19106__$1;
(statearr_19127_19174[(2)] = null);

(statearr_19127_19174[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (3))){
var inst_19104 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19106__$1,inst_19104);
} else {
if((state_val_19107 === (12))){
var inst_19081 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
var statearr_19128_19175 = state_19106__$1;
(statearr_19128_19175[(2)] = inst_19081);

(statearr_19128_19175[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (2))){
var state_19106__$1 = state_19106;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19106__$1,(4),ch);
} else {
if((state_val_19107 === (23))){
var state_19106__$1 = state_19106;
var statearr_19129_19176 = state_19106__$1;
(statearr_19129_19176[(2)] = null);

(statearr_19129_19176[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (19))){
var inst_19037 = (state_19106[(8)]);
var inst_19087 = (state_19106[(11)]);
var inst_19089 = cljs.core.async.muxch_STAR_.call(null,inst_19087);
var state_19106__$1 = state_19106;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19106__$1,(22),inst_19089,inst_19037);
} else {
if((state_val_19107 === (11))){
var inst_19047 = (state_19106[(12)]);
var inst_19061 = (state_19106[(10)]);
var inst_19061__$1 = cljs.core.seq.call(null,inst_19047);
var state_19106__$1 = (function (){var statearr_19130 = state_19106;
(statearr_19130[(10)] = inst_19061__$1);

return statearr_19130;
})();
if(inst_19061__$1){
var statearr_19131_19177 = state_19106__$1;
(statearr_19131_19177[(1)] = (13));

} else {
var statearr_19132_19178 = state_19106__$1;
(statearr_19132_19178[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (9))){
var inst_19083 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
var statearr_19133_19179 = state_19106__$1;
(statearr_19133_19179[(2)] = inst_19083);

(statearr_19133_19179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (5))){
var inst_19044 = cljs.core.deref.call(null,mults);
var inst_19045 = cljs.core.vals.call(null,inst_19044);
var inst_19046 = cljs.core.seq.call(null,inst_19045);
var inst_19047 = inst_19046;
var inst_19048 = null;
var inst_19049 = (0);
var inst_19050 = (0);
var state_19106__$1 = (function (){var statearr_19134 = state_19106;
(statearr_19134[(12)] = inst_19047);

(statearr_19134[(13)] = inst_19050);

(statearr_19134[(15)] = inst_19048);

(statearr_19134[(16)] = inst_19049);

return statearr_19134;
})();
var statearr_19135_19180 = state_19106__$1;
(statearr_19135_19180[(2)] = null);

(statearr_19135_19180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (14))){
var state_19106__$1 = state_19106;
var statearr_19139_19181 = state_19106__$1;
(statearr_19139_19181[(2)] = null);

(statearr_19139_19181[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (16))){
var inst_19061 = (state_19106[(10)]);
var inst_19065 = cljs.core.chunk_first.call(null,inst_19061);
var inst_19066 = cljs.core.chunk_rest.call(null,inst_19061);
var inst_19067 = cljs.core.count.call(null,inst_19065);
var inst_19047 = inst_19066;
var inst_19048 = inst_19065;
var inst_19049 = inst_19067;
var inst_19050 = (0);
var state_19106__$1 = (function (){var statearr_19140 = state_19106;
(statearr_19140[(12)] = inst_19047);

(statearr_19140[(13)] = inst_19050);

(statearr_19140[(15)] = inst_19048);

(statearr_19140[(16)] = inst_19049);

return statearr_19140;
})();
var statearr_19141_19182 = state_19106__$1;
(statearr_19141_19182[(2)] = null);

(statearr_19141_19182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (10))){
var inst_19047 = (state_19106[(12)]);
var inst_19050 = (state_19106[(13)]);
var inst_19048 = (state_19106[(15)]);
var inst_19049 = (state_19106[(16)]);
var inst_19055 = cljs.core._nth.call(null,inst_19048,inst_19050);
var inst_19056 = cljs.core.async.muxch_STAR_.call(null,inst_19055);
var inst_19057 = cljs.core.async.close_BANG_.call(null,inst_19056);
var inst_19058 = (inst_19050 + (1));
var tmp19136 = inst_19047;
var tmp19137 = inst_19048;
var tmp19138 = inst_19049;
var inst_19047__$1 = tmp19136;
var inst_19048__$1 = tmp19137;
var inst_19049__$1 = tmp19138;
var inst_19050__$1 = inst_19058;
var state_19106__$1 = (function (){var statearr_19142 = state_19106;
(statearr_19142[(12)] = inst_19047__$1);

(statearr_19142[(17)] = inst_19057);

(statearr_19142[(13)] = inst_19050__$1);

(statearr_19142[(15)] = inst_19048__$1);

(statearr_19142[(16)] = inst_19049__$1);

return statearr_19142;
})();
var statearr_19143_19183 = state_19106__$1;
(statearr_19143_19183[(2)] = null);

(statearr_19143_19183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (18))){
var inst_19076 = (state_19106[(2)]);
var state_19106__$1 = state_19106;
var statearr_19144_19184 = state_19106__$1;
(statearr_19144_19184[(2)] = inst_19076);

(statearr_19144_19184[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19107 === (8))){
var inst_19050 = (state_19106[(13)]);
var inst_19049 = (state_19106[(16)]);
var inst_19052 = (inst_19050 < inst_19049);
var inst_19053 = inst_19052;
var state_19106__$1 = state_19106;
if(cljs.core.truth_(inst_19053)){
var statearr_19145_19185 = state_19106__$1;
(statearr_19145_19185[(1)] = (10));

} else {
var statearr_19146_19186 = state_19106__$1;
(statearr_19146_19186[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19158,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19158,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19150 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19150[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19150[(1)] = (1));

return statearr_19150;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19106){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19151){if((e19151 instanceof Object)){
var ex__8254__auto__ = e19151;
var statearr_19152_19187 = state_19106;
(statearr_19152_19187[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19106);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19151;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19188 = state_19106;
state_19106 = G__19188;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19106){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19158,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19153 = f__8363__auto__.call(null);
(statearr_19153[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19158);

return statearr_19153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19158,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19189 = [];
var len__5726__auto___19192 = arguments.length;
var i__5727__auto___19193 = (0);
while(true){
if((i__5727__auto___19193 < len__5726__auto___19192)){
args19189.push((arguments[i__5727__auto___19193]));

var G__19194 = (i__5727__auto___19193 + (1));
i__5727__auto___19193 = G__19194;
continue;
} else {
}
break;
}

var G__19191 = args19189.length;
switch (G__19191) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19189.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19196 = [];
var len__5726__auto___19199 = arguments.length;
var i__5727__auto___19200 = (0);
while(true){
if((i__5727__auto___19200 < len__5726__auto___19199)){
args19196.push((arguments[i__5727__auto___19200]));

var G__19201 = (i__5727__auto___19200 + (1));
i__5727__auto___19200 = G__19201;
continue;
} else {
}
break;
}

var G__19198 = args19196.length;
switch (G__19198) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19196.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19203 = [];
var len__5726__auto___19274 = arguments.length;
var i__5727__auto___19275 = (0);
while(true){
if((i__5727__auto___19275 < len__5726__auto___19274)){
args19203.push((arguments[i__5727__auto___19275]));

var G__19276 = (i__5727__auto___19275 + (1));
i__5727__auto___19275 = G__19276;
continue;
} else {
}
break;
}

var G__19205 = args19203.length;
switch (G__19205) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19203.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19278 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19278,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19278,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19244){
var state_val_19245 = (state_19244[(1)]);
if((state_val_19245 === (7))){
var state_19244__$1 = state_19244;
var statearr_19246_19279 = state_19244__$1;
(statearr_19246_19279[(2)] = null);

(statearr_19246_19279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (1))){
var state_19244__$1 = state_19244;
var statearr_19247_19280 = state_19244__$1;
(statearr_19247_19280[(2)] = null);

(statearr_19247_19280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (4))){
var inst_19208 = (state_19244[(7)]);
var inst_19210 = (inst_19208 < cnt);
var state_19244__$1 = state_19244;
if(cljs.core.truth_(inst_19210)){
var statearr_19248_19281 = state_19244__$1;
(statearr_19248_19281[(1)] = (6));

} else {
var statearr_19249_19282 = state_19244__$1;
(statearr_19249_19282[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (15))){
var inst_19240 = (state_19244[(2)]);
var state_19244__$1 = state_19244;
var statearr_19250_19283 = state_19244__$1;
(statearr_19250_19283[(2)] = inst_19240);

(statearr_19250_19283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (13))){
var inst_19233 = cljs.core.async.close_BANG_.call(null,out);
var state_19244__$1 = state_19244;
var statearr_19251_19284 = state_19244__$1;
(statearr_19251_19284[(2)] = inst_19233);

(statearr_19251_19284[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (6))){
var state_19244__$1 = state_19244;
var statearr_19252_19285 = state_19244__$1;
(statearr_19252_19285[(2)] = null);

(statearr_19252_19285[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (3))){
var inst_19242 = (state_19244[(2)]);
var state_19244__$1 = state_19244;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19244__$1,inst_19242);
} else {
if((state_val_19245 === (12))){
var inst_19230 = (state_19244[(8)]);
var inst_19230__$1 = (state_19244[(2)]);
var inst_19231 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19230__$1);
var state_19244__$1 = (function (){var statearr_19253 = state_19244;
(statearr_19253[(8)] = inst_19230__$1);

return statearr_19253;
})();
if(cljs.core.truth_(inst_19231)){
var statearr_19254_19286 = state_19244__$1;
(statearr_19254_19286[(1)] = (13));

} else {
var statearr_19255_19287 = state_19244__$1;
(statearr_19255_19287[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (2))){
var inst_19207 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19208 = (0);
var state_19244__$1 = (function (){var statearr_19256 = state_19244;
(statearr_19256[(9)] = inst_19207);

(statearr_19256[(7)] = inst_19208);

return statearr_19256;
})();
var statearr_19257_19288 = state_19244__$1;
(statearr_19257_19288[(2)] = null);

(statearr_19257_19288[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (11))){
var inst_19208 = (state_19244[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19244,(10),Object,null,(9));
var inst_19217 = chs__$1.call(null,inst_19208);
var inst_19218 = done.call(null,inst_19208);
var inst_19219 = cljs.core.async.take_BANG_.call(null,inst_19217,inst_19218);
var state_19244__$1 = state_19244;
var statearr_19258_19289 = state_19244__$1;
(statearr_19258_19289[(2)] = inst_19219);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19244__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (9))){
var inst_19208 = (state_19244[(7)]);
var inst_19221 = (state_19244[(2)]);
var inst_19222 = (inst_19208 + (1));
var inst_19208__$1 = inst_19222;
var state_19244__$1 = (function (){var statearr_19259 = state_19244;
(statearr_19259[(10)] = inst_19221);

(statearr_19259[(7)] = inst_19208__$1);

return statearr_19259;
})();
var statearr_19260_19290 = state_19244__$1;
(statearr_19260_19290[(2)] = null);

(statearr_19260_19290[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (5))){
var inst_19228 = (state_19244[(2)]);
var state_19244__$1 = (function (){var statearr_19261 = state_19244;
(statearr_19261[(11)] = inst_19228);

return statearr_19261;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19244__$1,(12),dchan);
} else {
if((state_val_19245 === (14))){
var inst_19230 = (state_19244[(8)]);
var inst_19235 = cljs.core.apply.call(null,f,inst_19230);
var state_19244__$1 = state_19244;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19244__$1,(16),out,inst_19235);
} else {
if((state_val_19245 === (16))){
var inst_19237 = (state_19244[(2)]);
var state_19244__$1 = (function (){var statearr_19262 = state_19244;
(statearr_19262[(12)] = inst_19237);

return statearr_19262;
})();
var statearr_19263_19291 = state_19244__$1;
(statearr_19263_19291[(2)] = null);

(statearr_19263_19291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (10))){
var inst_19212 = (state_19244[(2)]);
var inst_19213 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19244__$1 = (function (){var statearr_19264 = state_19244;
(statearr_19264[(13)] = inst_19212);

return statearr_19264;
})();
var statearr_19265_19292 = state_19244__$1;
(statearr_19265_19292[(2)] = inst_19213);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19244__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19245 === (8))){
var inst_19226 = (state_19244[(2)]);
var state_19244__$1 = state_19244;
var statearr_19266_19293 = state_19244__$1;
(statearr_19266_19293[(2)] = inst_19226);

(statearr_19266_19293[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19278,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19278,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19270 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19270[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19270[(1)] = (1));

return statearr_19270;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19244){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19244);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19271){if((e19271 instanceof Object)){
var ex__8254__auto__ = e19271;
var statearr_19272_19294 = state_19244;
(statearr_19272_19294[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19244);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19271;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19295 = state_19244;
state_19244 = G__19295;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19244){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19278,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19273 = f__8363__auto__.call(null);
(statearr_19273[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19278);

return statearr_19273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19278,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19297 = [];
var len__5726__auto___19353 = arguments.length;
var i__5727__auto___19354 = (0);
while(true){
if((i__5727__auto___19354 < len__5726__auto___19353)){
args19297.push((arguments[i__5727__auto___19354]));

var G__19355 = (i__5727__auto___19354 + (1));
i__5727__auto___19354 = G__19355;
continue;
} else {
}
break;
}

var G__19299 = args19297.length;
switch (G__19299) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19297.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19357 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19357,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19357,out){
return (function (state_19329){
var state_val_19330 = (state_19329[(1)]);
if((state_val_19330 === (7))){
var inst_19308 = (state_19329[(7)]);
var inst_19309 = (state_19329[(8)]);
var inst_19308__$1 = (state_19329[(2)]);
var inst_19309__$1 = cljs.core.nth.call(null,inst_19308__$1,(0),null);
var inst_19310 = cljs.core.nth.call(null,inst_19308__$1,(1),null);
var inst_19311 = (inst_19309__$1 == null);
var state_19329__$1 = (function (){var statearr_19331 = state_19329;
(statearr_19331[(9)] = inst_19310);

(statearr_19331[(7)] = inst_19308__$1);

(statearr_19331[(8)] = inst_19309__$1);

return statearr_19331;
})();
if(cljs.core.truth_(inst_19311)){
var statearr_19332_19358 = state_19329__$1;
(statearr_19332_19358[(1)] = (8));

} else {
var statearr_19333_19359 = state_19329__$1;
(statearr_19333_19359[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (1))){
var inst_19300 = cljs.core.vec.call(null,chs);
var inst_19301 = inst_19300;
var state_19329__$1 = (function (){var statearr_19334 = state_19329;
(statearr_19334[(10)] = inst_19301);

return statearr_19334;
})();
var statearr_19335_19360 = state_19329__$1;
(statearr_19335_19360[(2)] = null);

(statearr_19335_19360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (4))){
var inst_19301 = (state_19329[(10)]);
var state_19329__$1 = state_19329;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19329__$1,(7),inst_19301);
} else {
if((state_val_19330 === (6))){
var inst_19325 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19336_19361 = state_19329__$1;
(statearr_19336_19361[(2)] = inst_19325);

(statearr_19336_19361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (3))){
var inst_19327 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19329__$1,inst_19327);
} else {
if((state_val_19330 === (2))){
var inst_19301 = (state_19329[(10)]);
var inst_19303 = cljs.core.count.call(null,inst_19301);
var inst_19304 = (inst_19303 > (0));
var state_19329__$1 = state_19329;
if(cljs.core.truth_(inst_19304)){
var statearr_19338_19362 = state_19329__$1;
(statearr_19338_19362[(1)] = (4));

} else {
var statearr_19339_19363 = state_19329__$1;
(statearr_19339_19363[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (11))){
var inst_19301 = (state_19329[(10)]);
var inst_19318 = (state_19329[(2)]);
var tmp19337 = inst_19301;
var inst_19301__$1 = tmp19337;
var state_19329__$1 = (function (){var statearr_19340 = state_19329;
(statearr_19340[(10)] = inst_19301__$1);

(statearr_19340[(11)] = inst_19318);

return statearr_19340;
})();
var statearr_19341_19364 = state_19329__$1;
(statearr_19341_19364[(2)] = null);

(statearr_19341_19364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (9))){
var inst_19309 = (state_19329[(8)]);
var state_19329__$1 = state_19329;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19329__$1,(11),out,inst_19309);
} else {
if((state_val_19330 === (5))){
var inst_19323 = cljs.core.async.close_BANG_.call(null,out);
var state_19329__$1 = state_19329;
var statearr_19342_19365 = state_19329__$1;
(statearr_19342_19365[(2)] = inst_19323);

(statearr_19342_19365[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (10))){
var inst_19321 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19343_19366 = state_19329__$1;
(statearr_19343_19366[(2)] = inst_19321);

(statearr_19343_19366[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (8))){
var inst_19301 = (state_19329[(10)]);
var inst_19310 = (state_19329[(9)]);
var inst_19308 = (state_19329[(7)]);
var inst_19309 = (state_19329[(8)]);
var inst_19313 = (function (){var cs = inst_19301;
var vec__19306 = inst_19308;
var v = inst_19309;
var c = inst_19310;
return ((function (cs,vec__19306,v,c,inst_19301,inst_19310,inst_19308,inst_19309,state_val_19330,c__8362__auto___19357,out){
return (function (p1__19296_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19296_SHARP_);
});
;})(cs,vec__19306,v,c,inst_19301,inst_19310,inst_19308,inst_19309,state_val_19330,c__8362__auto___19357,out))
})();
var inst_19314 = cljs.core.filterv.call(null,inst_19313,inst_19301);
var inst_19301__$1 = inst_19314;
var state_19329__$1 = (function (){var statearr_19344 = state_19329;
(statearr_19344[(10)] = inst_19301__$1);

return statearr_19344;
})();
var statearr_19345_19367 = state_19329__$1;
(statearr_19345_19367[(2)] = null);

(statearr_19345_19367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19357,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19357,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19349 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19349[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19349[(1)] = (1));

return statearr_19349;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19329){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19350){if((e19350 instanceof Object)){
var ex__8254__auto__ = e19350;
var statearr_19351_19368 = state_19329;
(statearr_19351_19368[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19329);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19350;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19369 = state_19329;
state_19329 = G__19369;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19329){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19357,out))
})();
var state__8364__auto__ = (function (){var statearr_19352 = f__8363__auto__.call(null);
(statearr_19352[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19357);

return statearr_19352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19357,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19370 = [];
var len__5726__auto___19419 = arguments.length;
var i__5727__auto___19420 = (0);
while(true){
if((i__5727__auto___19420 < len__5726__auto___19419)){
args19370.push((arguments[i__5727__auto___19420]));

var G__19421 = (i__5727__auto___19420 + (1));
i__5727__auto___19420 = G__19421;
continue;
} else {
}
break;
}

var G__19372 = args19370.length;
switch (G__19372) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19370.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19423 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19423,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19423,out){
return (function (state_19396){
var state_val_19397 = (state_19396[(1)]);
if((state_val_19397 === (7))){
var inst_19378 = (state_19396[(7)]);
var inst_19378__$1 = (state_19396[(2)]);
var inst_19379 = (inst_19378__$1 == null);
var inst_19380 = cljs.core.not.call(null,inst_19379);
var state_19396__$1 = (function (){var statearr_19398 = state_19396;
(statearr_19398[(7)] = inst_19378__$1);

return statearr_19398;
})();
if(inst_19380){
var statearr_19399_19424 = state_19396__$1;
(statearr_19399_19424[(1)] = (8));

} else {
var statearr_19400_19425 = state_19396__$1;
(statearr_19400_19425[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (1))){
var inst_19373 = (0);
var state_19396__$1 = (function (){var statearr_19401 = state_19396;
(statearr_19401[(8)] = inst_19373);

return statearr_19401;
})();
var statearr_19402_19426 = state_19396__$1;
(statearr_19402_19426[(2)] = null);

(statearr_19402_19426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (4))){
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19396__$1,(7),ch);
} else {
if((state_val_19397 === (6))){
var inst_19391 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19403_19427 = state_19396__$1;
(statearr_19403_19427[(2)] = inst_19391);

(statearr_19403_19427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (3))){
var inst_19393 = (state_19396[(2)]);
var inst_19394 = cljs.core.async.close_BANG_.call(null,out);
var state_19396__$1 = (function (){var statearr_19404 = state_19396;
(statearr_19404[(9)] = inst_19393);

return statearr_19404;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19396__$1,inst_19394);
} else {
if((state_val_19397 === (2))){
var inst_19373 = (state_19396[(8)]);
var inst_19375 = (inst_19373 < n);
var state_19396__$1 = state_19396;
if(cljs.core.truth_(inst_19375)){
var statearr_19405_19428 = state_19396__$1;
(statearr_19405_19428[(1)] = (4));

} else {
var statearr_19406_19429 = state_19396__$1;
(statearr_19406_19429[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (11))){
var inst_19373 = (state_19396[(8)]);
var inst_19383 = (state_19396[(2)]);
var inst_19384 = (inst_19373 + (1));
var inst_19373__$1 = inst_19384;
var state_19396__$1 = (function (){var statearr_19407 = state_19396;
(statearr_19407[(8)] = inst_19373__$1);

(statearr_19407[(10)] = inst_19383);

return statearr_19407;
})();
var statearr_19408_19430 = state_19396__$1;
(statearr_19408_19430[(2)] = null);

(statearr_19408_19430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (9))){
var state_19396__$1 = state_19396;
var statearr_19409_19431 = state_19396__$1;
(statearr_19409_19431[(2)] = null);

(statearr_19409_19431[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (5))){
var state_19396__$1 = state_19396;
var statearr_19410_19432 = state_19396__$1;
(statearr_19410_19432[(2)] = null);

(statearr_19410_19432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (10))){
var inst_19388 = (state_19396[(2)]);
var state_19396__$1 = state_19396;
var statearr_19411_19433 = state_19396__$1;
(statearr_19411_19433[(2)] = inst_19388);

(statearr_19411_19433[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19397 === (8))){
var inst_19378 = (state_19396[(7)]);
var state_19396__$1 = state_19396;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19396__$1,(11),out,inst_19378);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19423,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19423,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19415 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19415[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19415[(1)] = (1));

return statearr_19415;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19396){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19416){if((e19416 instanceof Object)){
var ex__8254__auto__ = e19416;
var statearr_19417_19434 = state_19396;
(statearr_19417_19434[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19416;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19435 = state_19396;
state_19396 = G__19435;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19423,out))
})();
var state__8364__auto__ = (function (){var statearr_19418 = f__8363__auto__.call(null);
(statearr_19418[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19423);

return statearr_19418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19423,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19443 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19443 = (function (map_LT_,f,ch,meta19444){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19444 = meta19444;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19445,meta19444__$1){
var self__ = this;
var _19445__$1 = this;
return (new cljs.core.async.t_cljs$core$async19443(self__.map_LT_,self__.f,self__.ch,meta19444__$1));
});

cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19445){
var self__ = this;
var _19445__$1 = this;
return self__.meta19444;
});

cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19446 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19446 = (function (map_LT_,f,ch,meta19444,_,fn1,meta19447){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19444 = meta19444;
this._ = _;
this.fn1 = fn1;
this.meta19447 = meta19447;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19446.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19448,meta19447__$1){
var self__ = this;
var _19448__$1 = this;
return (new cljs.core.async.t_cljs$core$async19446(self__.map_LT_,self__.f,self__.ch,self__.meta19444,self__._,self__.fn1,meta19447__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19446.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19448){
var self__ = this;
var _19448__$1 = this;
return self__.meta19447;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19446.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19446.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19446.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19446.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19436_SHARP_){
return f1.call(null,(((p1__19436_SHARP_ == null))?null:self__.f.call(null,p1__19436_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19446.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19444","meta19444",-1309612302,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19443","cljs.core.async/t_cljs$core$async19443",847700316,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19447","meta19447",-139340521,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19446.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19446.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19446";

cljs.core.async.t_cljs$core$async19446.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19446");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19446 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19446(map_LT___$1,f__$1,ch__$1,meta19444__$1,___$2,fn1__$1,meta19447){
return (new cljs.core.async.t_cljs$core$async19446(map_LT___$1,f__$1,ch__$1,meta19444__$1,___$2,fn1__$1,meta19447));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19446(self__.map_LT_,self__.f,self__.ch,self__.meta19444,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19443.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19443.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19444","meta19444",-1309612302,null)], null);
});

cljs.core.async.t_cljs$core$async19443.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19443.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19443";

cljs.core.async.t_cljs$core$async19443.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19443");
});

cljs.core.async.__GT_t_cljs$core$async19443 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19443(map_LT___$1,f__$1,ch__$1,meta19444){
return (new cljs.core.async.t_cljs$core$async19443(map_LT___$1,f__$1,ch__$1,meta19444));
});

}

return (new cljs.core.async.t_cljs$core$async19443(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19452 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19452 = (function (map_GT_,f,ch,meta19453){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19453 = meta19453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19454,meta19453__$1){
var self__ = this;
var _19454__$1 = this;
return (new cljs.core.async.t_cljs$core$async19452(self__.map_GT_,self__.f,self__.ch,meta19453__$1));
});

cljs.core.async.t_cljs$core$async19452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19454){
var self__ = this;
var _19454__$1 = this;
return self__.meta19453;
});

cljs.core.async.t_cljs$core$async19452.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19452.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19452.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19452.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19452.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19452.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19452.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19453","meta19453",1684043204,null)], null);
});

cljs.core.async.t_cljs$core$async19452.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19452.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19452";

cljs.core.async.t_cljs$core$async19452.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19452");
});

cljs.core.async.__GT_t_cljs$core$async19452 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19452(map_GT___$1,f__$1,ch__$1,meta19453){
return (new cljs.core.async.t_cljs$core$async19452(map_GT___$1,f__$1,ch__$1,meta19453));
});

}

return (new cljs.core.async.t_cljs$core$async19452(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19458 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19458 = (function (filter_GT_,p,ch,meta19459){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19459 = meta19459;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19460,meta19459__$1){
var self__ = this;
var _19460__$1 = this;
return (new cljs.core.async.t_cljs$core$async19458(self__.filter_GT_,self__.p,self__.ch,meta19459__$1));
});

cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19460){
var self__ = this;
var _19460__$1 = this;
return self__.meta19459;
});

cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19458.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19458.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19459","meta19459",-779937085,null)], null);
});

cljs.core.async.t_cljs$core$async19458.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19458.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19458";

cljs.core.async.t_cljs$core$async19458.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19458");
});

cljs.core.async.__GT_t_cljs$core$async19458 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19458(filter_GT___$1,p__$1,ch__$1,meta19459){
return (new cljs.core.async.t_cljs$core$async19458(filter_GT___$1,p__$1,ch__$1,meta19459));
});

}

return (new cljs.core.async.t_cljs$core$async19458(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19461 = [];
var len__5726__auto___19505 = arguments.length;
var i__5727__auto___19506 = (0);
while(true){
if((i__5727__auto___19506 < len__5726__auto___19505)){
args19461.push((arguments[i__5727__auto___19506]));

var G__19507 = (i__5727__auto___19506 + (1));
i__5727__auto___19506 = G__19507;
continue;
} else {
}
break;
}

var G__19463 = args19461.length;
switch (G__19463) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19461.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19509 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19509,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19509,out){
return (function (state_19484){
var state_val_19485 = (state_19484[(1)]);
if((state_val_19485 === (7))){
var inst_19480 = (state_19484[(2)]);
var state_19484__$1 = state_19484;
var statearr_19486_19510 = state_19484__$1;
(statearr_19486_19510[(2)] = inst_19480);

(statearr_19486_19510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19485 === (1))){
var state_19484__$1 = state_19484;
var statearr_19487_19511 = state_19484__$1;
(statearr_19487_19511[(2)] = null);

(statearr_19487_19511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19485 === (4))){
var inst_19466 = (state_19484[(7)]);
var inst_19466__$1 = (state_19484[(2)]);
var inst_19467 = (inst_19466__$1 == null);
var state_19484__$1 = (function (){var statearr_19488 = state_19484;
(statearr_19488[(7)] = inst_19466__$1);

return statearr_19488;
})();
if(cljs.core.truth_(inst_19467)){
var statearr_19489_19512 = state_19484__$1;
(statearr_19489_19512[(1)] = (5));

} else {
var statearr_19490_19513 = state_19484__$1;
(statearr_19490_19513[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19485 === (6))){
var inst_19466 = (state_19484[(7)]);
var inst_19471 = p.call(null,inst_19466);
var state_19484__$1 = state_19484;
if(cljs.core.truth_(inst_19471)){
var statearr_19491_19514 = state_19484__$1;
(statearr_19491_19514[(1)] = (8));

} else {
var statearr_19492_19515 = state_19484__$1;
(statearr_19492_19515[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19485 === (3))){
var inst_19482 = (state_19484[(2)]);
var state_19484__$1 = state_19484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19484__$1,inst_19482);
} else {
if((state_val_19485 === (2))){
var state_19484__$1 = state_19484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19484__$1,(4),ch);
} else {
if((state_val_19485 === (11))){
var inst_19474 = (state_19484[(2)]);
var state_19484__$1 = state_19484;
var statearr_19493_19516 = state_19484__$1;
(statearr_19493_19516[(2)] = inst_19474);

(statearr_19493_19516[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19485 === (9))){
var state_19484__$1 = state_19484;
var statearr_19494_19517 = state_19484__$1;
(statearr_19494_19517[(2)] = null);

(statearr_19494_19517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19485 === (5))){
var inst_19469 = cljs.core.async.close_BANG_.call(null,out);
var state_19484__$1 = state_19484;
var statearr_19495_19518 = state_19484__$1;
(statearr_19495_19518[(2)] = inst_19469);

(statearr_19495_19518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19485 === (10))){
var inst_19477 = (state_19484[(2)]);
var state_19484__$1 = (function (){var statearr_19496 = state_19484;
(statearr_19496[(8)] = inst_19477);

return statearr_19496;
})();
var statearr_19497_19519 = state_19484__$1;
(statearr_19497_19519[(2)] = null);

(statearr_19497_19519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19485 === (8))){
var inst_19466 = (state_19484[(7)]);
var state_19484__$1 = state_19484;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19484__$1,(11),out,inst_19466);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19509,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19509,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19501 = [null,null,null,null,null,null,null,null,null];
(statearr_19501[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19501[(1)] = (1));

return statearr_19501;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19484){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19502){if((e19502 instanceof Object)){
var ex__8254__auto__ = e19502;
var statearr_19503_19520 = state_19484;
(statearr_19503_19520[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19484);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19521 = state_19484;
state_19484 = G__19521;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19484){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19509,out))
})();
var state__8364__auto__ = (function (){var statearr_19504 = f__8363__auto__.call(null);
(statearr_19504[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19509);

return statearr_19504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19509,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19522 = [];
var len__5726__auto___19525 = arguments.length;
var i__5727__auto___19526 = (0);
while(true){
if((i__5727__auto___19526 < len__5726__auto___19525)){
args19522.push((arguments[i__5727__auto___19526]));

var G__19527 = (i__5727__auto___19526 + (1));
i__5727__auto___19526 = G__19527;
continue;
} else {
}
break;
}

var G__19524 = args19522.length;
switch (G__19524) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19522.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19694){
var state_val_19695 = (state_19694[(1)]);
if((state_val_19695 === (7))){
var inst_19690 = (state_19694[(2)]);
var state_19694__$1 = state_19694;
var statearr_19696_19737 = state_19694__$1;
(statearr_19696_19737[(2)] = inst_19690);

(statearr_19696_19737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (20))){
var inst_19660 = (state_19694[(7)]);
var inst_19671 = (state_19694[(2)]);
var inst_19672 = cljs.core.next.call(null,inst_19660);
var inst_19646 = inst_19672;
var inst_19647 = null;
var inst_19648 = (0);
var inst_19649 = (0);
var state_19694__$1 = (function (){var statearr_19697 = state_19694;
(statearr_19697[(8)] = inst_19649);

(statearr_19697[(9)] = inst_19646);

(statearr_19697[(10)] = inst_19671);

(statearr_19697[(11)] = inst_19648);

(statearr_19697[(12)] = inst_19647);

return statearr_19697;
})();
var statearr_19698_19738 = state_19694__$1;
(statearr_19698_19738[(2)] = null);

(statearr_19698_19738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (1))){
var state_19694__$1 = state_19694;
var statearr_19699_19739 = state_19694__$1;
(statearr_19699_19739[(2)] = null);

(statearr_19699_19739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (4))){
var inst_19635 = (state_19694[(13)]);
var inst_19635__$1 = (state_19694[(2)]);
var inst_19636 = (inst_19635__$1 == null);
var state_19694__$1 = (function (){var statearr_19700 = state_19694;
(statearr_19700[(13)] = inst_19635__$1);

return statearr_19700;
})();
if(cljs.core.truth_(inst_19636)){
var statearr_19701_19740 = state_19694__$1;
(statearr_19701_19740[(1)] = (5));

} else {
var statearr_19702_19741 = state_19694__$1;
(statearr_19702_19741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (15))){
var state_19694__$1 = state_19694;
var statearr_19706_19742 = state_19694__$1;
(statearr_19706_19742[(2)] = null);

(statearr_19706_19742[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (21))){
var state_19694__$1 = state_19694;
var statearr_19707_19743 = state_19694__$1;
(statearr_19707_19743[(2)] = null);

(statearr_19707_19743[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (13))){
var inst_19649 = (state_19694[(8)]);
var inst_19646 = (state_19694[(9)]);
var inst_19648 = (state_19694[(11)]);
var inst_19647 = (state_19694[(12)]);
var inst_19656 = (state_19694[(2)]);
var inst_19657 = (inst_19649 + (1));
var tmp19703 = inst_19646;
var tmp19704 = inst_19648;
var tmp19705 = inst_19647;
var inst_19646__$1 = tmp19703;
var inst_19647__$1 = tmp19705;
var inst_19648__$1 = tmp19704;
var inst_19649__$1 = inst_19657;
var state_19694__$1 = (function (){var statearr_19708 = state_19694;
(statearr_19708[(14)] = inst_19656);

(statearr_19708[(8)] = inst_19649__$1);

(statearr_19708[(9)] = inst_19646__$1);

(statearr_19708[(11)] = inst_19648__$1);

(statearr_19708[(12)] = inst_19647__$1);

return statearr_19708;
})();
var statearr_19709_19744 = state_19694__$1;
(statearr_19709_19744[(2)] = null);

(statearr_19709_19744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (22))){
var state_19694__$1 = state_19694;
var statearr_19710_19745 = state_19694__$1;
(statearr_19710_19745[(2)] = null);

(statearr_19710_19745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (6))){
var inst_19635 = (state_19694[(13)]);
var inst_19644 = f.call(null,inst_19635);
var inst_19645 = cljs.core.seq.call(null,inst_19644);
var inst_19646 = inst_19645;
var inst_19647 = null;
var inst_19648 = (0);
var inst_19649 = (0);
var state_19694__$1 = (function (){var statearr_19711 = state_19694;
(statearr_19711[(8)] = inst_19649);

(statearr_19711[(9)] = inst_19646);

(statearr_19711[(11)] = inst_19648);

(statearr_19711[(12)] = inst_19647);

return statearr_19711;
})();
var statearr_19712_19746 = state_19694__$1;
(statearr_19712_19746[(2)] = null);

(statearr_19712_19746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (17))){
var inst_19660 = (state_19694[(7)]);
var inst_19664 = cljs.core.chunk_first.call(null,inst_19660);
var inst_19665 = cljs.core.chunk_rest.call(null,inst_19660);
var inst_19666 = cljs.core.count.call(null,inst_19664);
var inst_19646 = inst_19665;
var inst_19647 = inst_19664;
var inst_19648 = inst_19666;
var inst_19649 = (0);
var state_19694__$1 = (function (){var statearr_19713 = state_19694;
(statearr_19713[(8)] = inst_19649);

(statearr_19713[(9)] = inst_19646);

(statearr_19713[(11)] = inst_19648);

(statearr_19713[(12)] = inst_19647);

return statearr_19713;
})();
var statearr_19714_19747 = state_19694__$1;
(statearr_19714_19747[(2)] = null);

(statearr_19714_19747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (3))){
var inst_19692 = (state_19694[(2)]);
var state_19694__$1 = state_19694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19694__$1,inst_19692);
} else {
if((state_val_19695 === (12))){
var inst_19680 = (state_19694[(2)]);
var state_19694__$1 = state_19694;
var statearr_19715_19748 = state_19694__$1;
(statearr_19715_19748[(2)] = inst_19680);

(statearr_19715_19748[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (2))){
var state_19694__$1 = state_19694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19694__$1,(4),in$);
} else {
if((state_val_19695 === (23))){
var inst_19688 = (state_19694[(2)]);
var state_19694__$1 = state_19694;
var statearr_19716_19749 = state_19694__$1;
(statearr_19716_19749[(2)] = inst_19688);

(statearr_19716_19749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (19))){
var inst_19675 = (state_19694[(2)]);
var state_19694__$1 = state_19694;
var statearr_19717_19750 = state_19694__$1;
(statearr_19717_19750[(2)] = inst_19675);

(statearr_19717_19750[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (11))){
var inst_19660 = (state_19694[(7)]);
var inst_19646 = (state_19694[(9)]);
var inst_19660__$1 = cljs.core.seq.call(null,inst_19646);
var state_19694__$1 = (function (){var statearr_19718 = state_19694;
(statearr_19718[(7)] = inst_19660__$1);

return statearr_19718;
})();
if(inst_19660__$1){
var statearr_19719_19751 = state_19694__$1;
(statearr_19719_19751[(1)] = (14));

} else {
var statearr_19720_19752 = state_19694__$1;
(statearr_19720_19752[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (9))){
var inst_19682 = (state_19694[(2)]);
var inst_19683 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19694__$1 = (function (){var statearr_19721 = state_19694;
(statearr_19721[(15)] = inst_19682);

return statearr_19721;
})();
if(cljs.core.truth_(inst_19683)){
var statearr_19722_19753 = state_19694__$1;
(statearr_19722_19753[(1)] = (21));

} else {
var statearr_19723_19754 = state_19694__$1;
(statearr_19723_19754[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (5))){
var inst_19638 = cljs.core.async.close_BANG_.call(null,out);
var state_19694__$1 = state_19694;
var statearr_19724_19755 = state_19694__$1;
(statearr_19724_19755[(2)] = inst_19638);

(statearr_19724_19755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (14))){
var inst_19660 = (state_19694[(7)]);
var inst_19662 = cljs.core.chunked_seq_QMARK_.call(null,inst_19660);
var state_19694__$1 = state_19694;
if(inst_19662){
var statearr_19725_19756 = state_19694__$1;
(statearr_19725_19756[(1)] = (17));

} else {
var statearr_19726_19757 = state_19694__$1;
(statearr_19726_19757[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (16))){
var inst_19678 = (state_19694[(2)]);
var state_19694__$1 = state_19694;
var statearr_19727_19758 = state_19694__$1;
(statearr_19727_19758[(2)] = inst_19678);

(statearr_19727_19758[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19695 === (10))){
var inst_19649 = (state_19694[(8)]);
var inst_19647 = (state_19694[(12)]);
var inst_19654 = cljs.core._nth.call(null,inst_19647,inst_19649);
var state_19694__$1 = state_19694;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19694__$1,(13),out,inst_19654);
} else {
if((state_val_19695 === (18))){
var inst_19660 = (state_19694[(7)]);
var inst_19669 = cljs.core.first.call(null,inst_19660);
var state_19694__$1 = state_19694;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19694__$1,(20),out,inst_19669);
} else {
if((state_val_19695 === (8))){
var inst_19649 = (state_19694[(8)]);
var inst_19648 = (state_19694[(11)]);
var inst_19651 = (inst_19649 < inst_19648);
var inst_19652 = inst_19651;
var state_19694__$1 = state_19694;
if(cljs.core.truth_(inst_19652)){
var statearr_19728_19759 = state_19694__$1;
(statearr_19728_19759[(1)] = (10));

} else {
var statearr_19729_19760 = state_19694__$1;
(statearr_19729_19760[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19733 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19733[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19733[(1)] = (1));

return statearr_19733;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19694){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19734){if((e19734 instanceof Object)){
var ex__8254__auto__ = e19734;
var statearr_19735_19761 = state_19694;
(statearr_19735_19761[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19694);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19762 = state_19694;
state_19694 = G__19762;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19694){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19736 = f__8363__auto__.call(null);
(statearr_19736[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19763 = [];
var len__5726__auto___19766 = arguments.length;
var i__5727__auto___19767 = (0);
while(true){
if((i__5727__auto___19767 < len__5726__auto___19766)){
args19763.push((arguments[i__5727__auto___19767]));

var G__19768 = (i__5727__auto___19767 + (1));
i__5727__auto___19767 = G__19768;
continue;
} else {
}
break;
}

var G__19765 = args19763.length;
switch (G__19765) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19763.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19770 = [];
var len__5726__auto___19773 = arguments.length;
var i__5727__auto___19774 = (0);
while(true){
if((i__5727__auto___19774 < len__5726__auto___19773)){
args19770.push((arguments[i__5727__auto___19774]));

var G__19775 = (i__5727__auto___19774 + (1));
i__5727__auto___19774 = G__19775;
continue;
} else {
}
break;
}

var G__19772 = args19770.length;
switch (G__19772) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19770.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19777 = [];
var len__5726__auto___19828 = arguments.length;
var i__5727__auto___19829 = (0);
while(true){
if((i__5727__auto___19829 < len__5726__auto___19828)){
args19777.push((arguments[i__5727__auto___19829]));

var G__19830 = (i__5727__auto___19829 + (1));
i__5727__auto___19829 = G__19830;
continue;
} else {
}
break;
}

var G__19779 = args19777.length;
switch (G__19779) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19777.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19832 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19832,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19832,out){
return (function (state_19803){
var state_val_19804 = (state_19803[(1)]);
if((state_val_19804 === (7))){
var inst_19798 = (state_19803[(2)]);
var state_19803__$1 = state_19803;
var statearr_19805_19833 = state_19803__$1;
(statearr_19805_19833[(2)] = inst_19798);

(statearr_19805_19833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19804 === (1))){
var inst_19780 = null;
var state_19803__$1 = (function (){var statearr_19806 = state_19803;
(statearr_19806[(7)] = inst_19780);

return statearr_19806;
})();
var statearr_19807_19834 = state_19803__$1;
(statearr_19807_19834[(2)] = null);

(statearr_19807_19834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19804 === (4))){
var inst_19783 = (state_19803[(8)]);
var inst_19783__$1 = (state_19803[(2)]);
var inst_19784 = (inst_19783__$1 == null);
var inst_19785 = cljs.core.not.call(null,inst_19784);
var state_19803__$1 = (function (){var statearr_19808 = state_19803;
(statearr_19808[(8)] = inst_19783__$1);

return statearr_19808;
})();
if(inst_19785){
var statearr_19809_19835 = state_19803__$1;
(statearr_19809_19835[(1)] = (5));

} else {
var statearr_19810_19836 = state_19803__$1;
(statearr_19810_19836[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19804 === (6))){
var state_19803__$1 = state_19803;
var statearr_19811_19837 = state_19803__$1;
(statearr_19811_19837[(2)] = null);

(statearr_19811_19837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19804 === (3))){
var inst_19800 = (state_19803[(2)]);
var inst_19801 = cljs.core.async.close_BANG_.call(null,out);
var state_19803__$1 = (function (){var statearr_19812 = state_19803;
(statearr_19812[(9)] = inst_19800);

return statearr_19812;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19803__$1,inst_19801);
} else {
if((state_val_19804 === (2))){
var state_19803__$1 = state_19803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19803__$1,(4),ch);
} else {
if((state_val_19804 === (11))){
var inst_19783 = (state_19803[(8)]);
var inst_19792 = (state_19803[(2)]);
var inst_19780 = inst_19783;
var state_19803__$1 = (function (){var statearr_19813 = state_19803;
(statearr_19813[(7)] = inst_19780);

(statearr_19813[(10)] = inst_19792);

return statearr_19813;
})();
var statearr_19814_19838 = state_19803__$1;
(statearr_19814_19838[(2)] = null);

(statearr_19814_19838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19804 === (9))){
var inst_19783 = (state_19803[(8)]);
var state_19803__$1 = state_19803;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19803__$1,(11),out,inst_19783);
} else {
if((state_val_19804 === (5))){
var inst_19780 = (state_19803[(7)]);
var inst_19783 = (state_19803[(8)]);
var inst_19787 = cljs.core._EQ_.call(null,inst_19783,inst_19780);
var state_19803__$1 = state_19803;
if(inst_19787){
var statearr_19816_19839 = state_19803__$1;
(statearr_19816_19839[(1)] = (8));

} else {
var statearr_19817_19840 = state_19803__$1;
(statearr_19817_19840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19804 === (10))){
var inst_19795 = (state_19803[(2)]);
var state_19803__$1 = state_19803;
var statearr_19818_19841 = state_19803__$1;
(statearr_19818_19841[(2)] = inst_19795);

(statearr_19818_19841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19804 === (8))){
var inst_19780 = (state_19803[(7)]);
var tmp19815 = inst_19780;
var inst_19780__$1 = tmp19815;
var state_19803__$1 = (function (){var statearr_19819 = state_19803;
(statearr_19819[(7)] = inst_19780__$1);

return statearr_19819;
})();
var statearr_19820_19842 = state_19803__$1;
(statearr_19820_19842[(2)] = null);

(statearr_19820_19842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19832,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19832,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19824 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19824[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19824[(1)] = (1));

return statearr_19824;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19803){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19825){if((e19825 instanceof Object)){
var ex__8254__auto__ = e19825;
var statearr_19826_19843 = state_19803;
(statearr_19826_19843[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19803);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19825;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19844 = state_19803;
state_19803 = G__19844;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19803){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19832,out))
})();
var state__8364__auto__ = (function (){var statearr_19827 = f__8363__auto__.call(null);
(statearr_19827[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19832);

return statearr_19827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19832,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19845 = [];
var len__5726__auto___19915 = arguments.length;
var i__5727__auto___19916 = (0);
while(true){
if((i__5727__auto___19916 < len__5726__auto___19915)){
args19845.push((arguments[i__5727__auto___19916]));

var G__19917 = (i__5727__auto___19916 + (1));
i__5727__auto___19916 = G__19917;
continue;
} else {
}
break;
}

var G__19847 = args19845.length;
switch (G__19847) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19845.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19919 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19919,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19919,out){
return (function (state_19885){
var state_val_19886 = (state_19885[(1)]);
if((state_val_19886 === (7))){
var inst_19881 = (state_19885[(2)]);
var state_19885__$1 = state_19885;
var statearr_19887_19920 = state_19885__$1;
(statearr_19887_19920[(2)] = inst_19881);

(statearr_19887_19920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (1))){
var inst_19848 = (new Array(n));
var inst_19849 = inst_19848;
var inst_19850 = (0);
var state_19885__$1 = (function (){var statearr_19888 = state_19885;
(statearr_19888[(7)] = inst_19850);

(statearr_19888[(8)] = inst_19849);

return statearr_19888;
})();
var statearr_19889_19921 = state_19885__$1;
(statearr_19889_19921[(2)] = null);

(statearr_19889_19921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (4))){
var inst_19853 = (state_19885[(9)]);
var inst_19853__$1 = (state_19885[(2)]);
var inst_19854 = (inst_19853__$1 == null);
var inst_19855 = cljs.core.not.call(null,inst_19854);
var state_19885__$1 = (function (){var statearr_19890 = state_19885;
(statearr_19890[(9)] = inst_19853__$1);

return statearr_19890;
})();
if(inst_19855){
var statearr_19891_19922 = state_19885__$1;
(statearr_19891_19922[(1)] = (5));

} else {
var statearr_19892_19923 = state_19885__$1;
(statearr_19892_19923[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (15))){
var inst_19875 = (state_19885[(2)]);
var state_19885__$1 = state_19885;
var statearr_19893_19924 = state_19885__$1;
(statearr_19893_19924[(2)] = inst_19875);

(statearr_19893_19924[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (13))){
var state_19885__$1 = state_19885;
var statearr_19894_19925 = state_19885__$1;
(statearr_19894_19925[(2)] = null);

(statearr_19894_19925[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (6))){
var inst_19850 = (state_19885[(7)]);
var inst_19871 = (inst_19850 > (0));
var state_19885__$1 = state_19885;
if(cljs.core.truth_(inst_19871)){
var statearr_19895_19926 = state_19885__$1;
(statearr_19895_19926[(1)] = (12));

} else {
var statearr_19896_19927 = state_19885__$1;
(statearr_19896_19927[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (3))){
var inst_19883 = (state_19885[(2)]);
var state_19885__$1 = state_19885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19885__$1,inst_19883);
} else {
if((state_val_19886 === (12))){
var inst_19849 = (state_19885[(8)]);
var inst_19873 = cljs.core.vec.call(null,inst_19849);
var state_19885__$1 = state_19885;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19885__$1,(15),out,inst_19873);
} else {
if((state_val_19886 === (2))){
var state_19885__$1 = state_19885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19885__$1,(4),ch);
} else {
if((state_val_19886 === (11))){
var inst_19865 = (state_19885[(2)]);
var inst_19866 = (new Array(n));
var inst_19849 = inst_19866;
var inst_19850 = (0);
var state_19885__$1 = (function (){var statearr_19897 = state_19885;
(statearr_19897[(7)] = inst_19850);

(statearr_19897[(8)] = inst_19849);

(statearr_19897[(10)] = inst_19865);

return statearr_19897;
})();
var statearr_19898_19928 = state_19885__$1;
(statearr_19898_19928[(2)] = null);

(statearr_19898_19928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (9))){
var inst_19849 = (state_19885[(8)]);
var inst_19863 = cljs.core.vec.call(null,inst_19849);
var state_19885__$1 = state_19885;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19885__$1,(11),out,inst_19863);
} else {
if((state_val_19886 === (5))){
var inst_19853 = (state_19885[(9)]);
var inst_19850 = (state_19885[(7)]);
var inst_19858 = (state_19885[(11)]);
var inst_19849 = (state_19885[(8)]);
var inst_19857 = (inst_19849[inst_19850] = inst_19853);
var inst_19858__$1 = (inst_19850 + (1));
var inst_19859 = (inst_19858__$1 < n);
var state_19885__$1 = (function (){var statearr_19899 = state_19885;
(statearr_19899[(12)] = inst_19857);

(statearr_19899[(11)] = inst_19858__$1);

return statearr_19899;
})();
if(cljs.core.truth_(inst_19859)){
var statearr_19900_19929 = state_19885__$1;
(statearr_19900_19929[(1)] = (8));

} else {
var statearr_19901_19930 = state_19885__$1;
(statearr_19901_19930[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (14))){
var inst_19878 = (state_19885[(2)]);
var inst_19879 = cljs.core.async.close_BANG_.call(null,out);
var state_19885__$1 = (function (){var statearr_19903 = state_19885;
(statearr_19903[(13)] = inst_19878);

return statearr_19903;
})();
var statearr_19904_19931 = state_19885__$1;
(statearr_19904_19931[(2)] = inst_19879);

(statearr_19904_19931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (10))){
var inst_19869 = (state_19885[(2)]);
var state_19885__$1 = state_19885;
var statearr_19905_19932 = state_19885__$1;
(statearr_19905_19932[(2)] = inst_19869);

(statearr_19905_19932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19886 === (8))){
var inst_19858 = (state_19885[(11)]);
var inst_19849 = (state_19885[(8)]);
var tmp19902 = inst_19849;
var inst_19849__$1 = tmp19902;
var inst_19850 = inst_19858;
var state_19885__$1 = (function (){var statearr_19906 = state_19885;
(statearr_19906[(7)] = inst_19850);

(statearr_19906[(8)] = inst_19849__$1);

return statearr_19906;
})();
var statearr_19907_19933 = state_19885__$1;
(statearr_19907_19933[(2)] = null);

(statearr_19907_19933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19919,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19919,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19911 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19911[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19911[(1)] = (1));

return statearr_19911;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19885){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19912){if((e19912 instanceof Object)){
var ex__8254__auto__ = e19912;
var statearr_19913_19934 = state_19885;
(statearr_19913_19934[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19885);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19935 = state_19885;
state_19885 = G__19935;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19885){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19919,out))
})();
var state__8364__auto__ = (function (){var statearr_19914 = f__8363__auto__.call(null);
(statearr_19914[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19919);

return statearr_19914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19919,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19936 = [];
var len__5726__auto___20010 = arguments.length;
var i__5727__auto___20011 = (0);
while(true){
if((i__5727__auto___20011 < len__5726__auto___20010)){
args19936.push((arguments[i__5727__auto___20011]));

var G__20012 = (i__5727__auto___20011 + (1));
i__5727__auto___20011 = G__20012;
continue;
} else {
}
break;
}

var G__19938 = args19936.length;
switch (G__19938) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19936.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20014 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20014,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20014,out){
return (function (state_19980){
var state_val_19981 = (state_19980[(1)]);
if((state_val_19981 === (7))){
var inst_19976 = (state_19980[(2)]);
var state_19980__$1 = state_19980;
var statearr_19982_20015 = state_19980__$1;
(statearr_19982_20015[(2)] = inst_19976);

(statearr_19982_20015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (1))){
var inst_19939 = [];
var inst_19940 = inst_19939;
var inst_19941 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19980__$1 = (function (){var statearr_19983 = state_19980;
(statearr_19983[(7)] = inst_19941);

(statearr_19983[(8)] = inst_19940);

return statearr_19983;
})();
var statearr_19984_20016 = state_19980__$1;
(statearr_19984_20016[(2)] = null);

(statearr_19984_20016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (4))){
var inst_19944 = (state_19980[(9)]);
var inst_19944__$1 = (state_19980[(2)]);
var inst_19945 = (inst_19944__$1 == null);
var inst_19946 = cljs.core.not.call(null,inst_19945);
var state_19980__$1 = (function (){var statearr_19985 = state_19980;
(statearr_19985[(9)] = inst_19944__$1);

return statearr_19985;
})();
if(inst_19946){
var statearr_19986_20017 = state_19980__$1;
(statearr_19986_20017[(1)] = (5));

} else {
var statearr_19987_20018 = state_19980__$1;
(statearr_19987_20018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (15))){
var inst_19970 = (state_19980[(2)]);
var state_19980__$1 = state_19980;
var statearr_19988_20019 = state_19980__$1;
(statearr_19988_20019[(2)] = inst_19970);

(statearr_19988_20019[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (13))){
var state_19980__$1 = state_19980;
var statearr_19989_20020 = state_19980__$1;
(statearr_19989_20020[(2)] = null);

(statearr_19989_20020[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (6))){
var inst_19940 = (state_19980[(8)]);
var inst_19965 = inst_19940.length;
var inst_19966 = (inst_19965 > (0));
var state_19980__$1 = state_19980;
if(cljs.core.truth_(inst_19966)){
var statearr_19990_20021 = state_19980__$1;
(statearr_19990_20021[(1)] = (12));

} else {
var statearr_19991_20022 = state_19980__$1;
(statearr_19991_20022[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (3))){
var inst_19978 = (state_19980[(2)]);
var state_19980__$1 = state_19980;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19980__$1,inst_19978);
} else {
if((state_val_19981 === (12))){
var inst_19940 = (state_19980[(8)]);
var inst_19968 = cljs.core.vec.call(null,inst_19940);
var state_19980__$1 = state_19980;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19980__$1,(15),out,inst_19968);
} else {
if((state_val_19981 === (2))){
var state_19980__$1 = state_19980;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19980__$1,(4),ch);
} else {
if((state_val_19981 === (11))){
var inst_19948 = (state_19980[(10)]);
var inst_19944 = (state_19980[(9)]);
var inst_19958 = (state_19980[(2)]);
var inst_19959 = [];
var inst_19960 = inst_19959.push(inst_19944);
var inst_19940 = inst_19959;
var inst_19941 = inst_19948;
var state_19980__$1 = (function (){var statearr_19992 = state_19980;
(statearr_19992[(7)] = inst_19941);

(statearr_19992[(8)] = inst_19940);

(statearr_19992[(11)] = inst_19958);

(statearr_19992[(12)] = inst_19960);

return statearr_19992;
})();
var statearr_19993_20023 = state_19980__$1;
(statearr_19993_20023[(2)] = null);

(statearr_19993_20023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (9))){
var inst_19940 = (state_19980[(8)]);
var inst_19956 = cljs.core.vec.call(null,inst_19940);
var state_19980__$1 = state_19980;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19980__$1,(11),out,inst_19956);
} else {
if((state_val_19981 === (5))){
var inst_19941 = (state_19980[(7)]);
var inst_19948 = (state_19980[(10)]);
var inst_19944 = (state_19980[(9)]);
var inst_19948__$1 = f.call(null,inst_19944);
var inst_19949 = cljs.core._EQ_.call(null,inst_19948__$1,inst_19941);
var inst_19950 = cljs.core.keyword_identical_QMARK_.call(null,inst_19941,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19951 = (inst_19949) || (inst_19950);
var state_19980__$1 = (function (){var statearr_19994 = state_19980;
(statearr_19994[(10)] = inst_19948__$1);

return statearr_19994;
})();
if(cljs.core.truth_(inst_19951)){
var statearr_19995_20024 = state_19980__$1;
(statearr_19995_20024[(1)] = (8));

} else {
var statearr_19996_20025 = state_19980__$1;
(statearr_19996_20025[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (14))){
var inst_19973 = (state_19980[(2)]);
var inst_19974 = cljs.core.async.close_BANG_.call(null,out);
var state_19980__$1 = (function (){var statearr_19998 = state_19980;
(statearr_19998[(13)] = inst_19973);

return statearr_19998;
})();
var statearr_19999_20026 = state_19980__$1;
(statearr_19999_20026[(2)] = inst_19974);

(statearr_19999_20026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (10))){
var inst_19963 = (state_19980[(2)]);
var state_19980__$1 = state_19980;
var statearr_20000_20027 = state_19980__$1;
(statearr_20000_20027[(2)] = inst_19963);

(statearr_20000_20027[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19981 === (8))){
var inst_19948 = (state_19980[(10)]);
var inst_19940 = (state_19980[(8)]);
var inst_19944 = (state_19980[(9)]);
var inst_19953 = inst_19940.push(inst_19944);
var tmp19997 = inst_19940;
var inst_19940__$1 = tmp19997;
var inst_19941 = inst_19948;
var state_19980__$1 = (function (){var statearr_20001 = state_19980;
(statearr_20001[(7)] = inst_19941);

(statearr_20001[(8)] = inst_19940__$1);

(statearr_20001[(14)] = inst_19953);

return statearr_20001;
})();
var statearr_20002_20028 = state_19980__$1;
(statearr_20002_20028[(2)] = null);

(statearr_20002_20028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20014,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20014,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_20006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20006[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_20006[(1)] = (1));

return statearr_20006;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19980){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e20007){if((e20007 instanceof Object)){
var ex__8254__auto__ = e20007;
var statearr_20008_20029 = state_19980;
(statearr_20008_20029[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19980);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20007;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20030 = state_19980;
state_19980 = G__20030;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19980){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20014,out))
})();
var state__8364__auto__ = (function (){var statearr_20009 = f__8363__auto__.call(null);
(statearr_20009[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20014);

return statearr_20009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20014,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1453979771793