// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args8407 = [];
var len__5726__auto___8413 = arguments.length;
var i__5727__auto___8414 = (0);
while(true){
if((i__5727__auto___8414 < len__5726__auto___8413)){
args8407.push((arguments[i__5727__auto___8414]));

var G__8415 = (i__5727__auto___8414 + (1));
i__5727__auto___8414 = G__8415;
continue;
} else {
}
break;
}

var G__8409 = args8407.length;
switch (G__8409) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8407.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async8410 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8410 = (function (f,blockable,meta8411){
this.f = f;
this.blockable = blockable;
this.meta8411 = meta8411;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async8410.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8412,meta8411__$1){
var self__ = this;
var _8412__$1 = this;
return (new cljs.core.async.t_cljs$core$async8410(self__.f,self__.blockable,meta8411__$1));
});

cljs.core.async.t_cljs$core$async8410.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8412){
var self__ = this;
var _8412__$1 = this;
return self__.meta8411;
});

cljs.core.async.t_cljs$core$async8410.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async8410.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8410.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async8410.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async8410.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta8411","meta8411",-831526968,null)], null);
});

cljs.core.async.t_cljs$core$async8410.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8410.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8410";

cljs.core.async.t_cljs$core$async8410.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async8410");
});

cljs.core.async.__GT_t_cljs$core$async8410 = (function cljs$core$async$__GT_t_cljs$core$async8410(f__$1,blockable__$1,meta8411){
return (new cljs.core.async.t_cljs$core$async8410(f__$1,blockable__$1,meta8411));
});

}

return (new cljs.core.async.t_cljs$core$async8410(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args8419 = [];
var len__5726__auto___8422 = arguments.length;
var i__5727__auto___8423 = (0);
while(true){
if((i__5727__auto___8423 < len__5726__auto___8422)){
args8419.push((arguments[i__5727__auto___8423]));

var G__8424 = (i__5727__auto___8423 + (1));
i__5727__auto___8423 = G__8424;
continue;
} else {
}
break;
}

var G__8421 = args8419.length;
switch (G__8421) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8419.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args8426 = [];
var len__5726__auto___8429 = arguments.length;
var i__5727__auto___8430 = (0);
while(true){
if((i__5727__auto___8430 < len__5726__auto___8429)){
args8426.push((arguments[i__5727__auto___8430]));

var G__8431 = (i__5727__auto___8430 + (1));
i__5727__auto___8430 = G__8431;
continue;
} else {
}
break;
}

var G__8428 = args8426.length;
switch (G__8428) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8426.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args8433 = [];
var len__5726__auto___8436 = arguments.length;
var i__5727__auto___8437 = (0);
while(true){
if((i__5727__auto___8437 < len__5726__auto___8436)){
args8433.push((arguments[i__5727__auto___8437]));

var G__8438 = (i__5727__auto___8437 + (1));
i__5727__auto___8437 = G__8438;
continue;
} else {
}
break;
}

var G__8435 = args8433.length;
switch (G__8435) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8433.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_8440 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_8440);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_8440,ret){
return (function (){
return fn1.call(null,val_8440);
});})(val_8440,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args8441 = [];
var len__5726__auto___8444 = arguments.length;
var i__5727__auto___8445 = (0);
while(true){
if((i__5727__auto___8445 < len__5726__auto___8444)){
args8441.push((arguments[i__5727__auto___8445]));

var G__8446 = (i__5727__auto___8445 + (1));
i__5727__auto___8445 = G__8446;
continue;
} else {
}
break;
}

var G__8443 = args8441.length;
switch (G__8443) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8441.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___8448 = n;
var x_8449 = (0);
while(true){
if((x_8449 < n__5571__auto___8448)){
(a[x_8449] = (0));

var G__8450 = (x_8449 + (1));
x_8449 = G__8450;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__8451 = (i + (1));
i = G__8451;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async8455 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8455 = (function (alt_flag,flag,meta8456){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta8456 = meta8456;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async8455.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_8457,meta8456__$1){
var self__ = this;
var _8457__$1 = this;
return (new cljs.core.async.t_cljs$core$async8455(self__.alt_flag,self__.flag,meta8456__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async8455.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_8457){
var self__ = this;
var _8457__$1 = this;
return self__.meta8456;
});})(flag))
;

cljs.core.async.t_cljs$core$async8455.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async8455.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async8455.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8455.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8455.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta8456","meta8456",868330526,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async8455.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8455.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8455";

cljs.core.async.t_cljs$core$async8455.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async8455");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async8455 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async8455(alt_flag__$1,flag__$1,meta8456){
return (new cljs.core.async.t_cljs$core$async8455(alt_flag__$1,flag__$1,meta8456));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async8455(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async8461 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8461 = (function (alt_handler,flag,cb,meta8462){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta8462 = meta8462;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async8461.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8463,meta8462__$1){
var self__ = this;
var _8463__$1 = this;
return (new cljs.core.async.t_cljs$core$async8461(self__.alt_handler,self__.flag,self__.cb,meta8462__$1));
});

cljs.core.async.t_cljs$core$async8461.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8463){
var self__ = this;
var _8463__$1 = this;
return self__.meta8462;
});

cljs.core.async.t_cljs$core$async8461.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async8461.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async8461.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8461.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async8461.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta8462","meta8462",799740951,null)], null);
});

cljs.core.async.t_cljs$core$async8461.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8461.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8461";

cljs.core.async.t_cljs$core$async8461.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async8461");
});

cljs.core.async.__GT_t_cljs$core$async8461 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async8461(alt_handler__$1,flag__$1,cb__$1,meta8462){
return (new cljs.core.async.t_cljs$core$async8461(alt_handler__$1,flag__$1,cb__$1,meta8462));
});

}

return (new cljs.core.async.t_cljs$core$async8461(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8464_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8464_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8465_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8465_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__8466 = (i + (1));
i = G__8466;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___8472 = arguments.length;
var i__5727__auto___8473 = (0);
while(true){
if((i__5727__auto___8473 < len__5726__auto___8472)){
args__5733__auto__.push((arguments[i__5727__auto___8473]));

var G__8474 = (i__5727__auto___8473 + (1));
i__5727__auto___8473 = G__8474;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__8469){
var map__8470 = p__8469;
var map__8470__$1 = ((((!((map__8470 == null)))?((((map__8470.cljs$lang$protocol_mask$partition0$ & (64))) || (map__8470.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8470):map__8470);
var opts = map__8470__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq8467){
var G__8468 = cljs.core.first.call(null,seq8467);
var seq8467__$1 = cljs.core.next.call(null,seq8467);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8468,seq8467__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args8475 = [];
var len__5726__auto___8525 = arguments.length;
var i__5727__auto___8526 = (0);
while(true){
if((i__5727__auto___8526 < len__5726__auto___8525)){
args8475.push((arguments[i__5727__auto___8526]));

var G__8527 = (i__5727__auto___8526 + (1));
i__5727__auto___8526 = G__8527;
continue;
} else {
}
break;
}

var G__8477 = args8475.length;
switch (G__8477) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8475.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___8529 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___8529){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___8529){
return (function (state_8501){
var state_val_8502 = (state_8501[(1)]);
if((state_val_8502 === (7))){
var inst_8497 = (state_8501[(2)]);
var state_8501__$1 = state_8501;
var statearr_8503_8530 = state_8501__$1;
(statearr_8503_8530[(2)] = inst_8497);

(statearr_8503_8530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (1))){
var state_8501__$1 = state_8501;
var statearr_8504_8531 = state_8501__$1;
(statearr_8504_8531[(2)] = null);

(statearr_8504_8531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (4))){
var inst_8480 = (state_8501[(7)]);
var inst_8480__$1 = (state_8501[(2)]);
var inst_8481 = (inst_8480__$1 == null);
var state_8501__$1 = (function (){var statearr_8505 = state_8501;
(statearr_8505[(7)] = inst_8480__$1);

return statearr_8505;
})();
if(cljs.core.truth_(inst_8481)){
var statearr_8506_8532 = state_8501__$1;
(statearr_8506_8532[(1)] = (5));

} else {
var statearr_8507_8533 = state_8501__$1;
(statearr_8507_8533[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (13))){
var state_8501__$1 = state_8501;
var statearr_8508_8534 = state_8501__$1;
(statearr_8508_8534[(2)] = null);

(statearr_8508_8534[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (6))){
var inst_8480 = (state_8501[(7)]);
var state_8501__$1 = state_8501;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8501__$1,(11),to,inst_8480);
} else {
if((state_val_8502 === (3))){
var inst_8499 = (state_8501[(2)]);
var state_8501__$1 = state_8501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8501__$1,inst_8499);
} else {
if((state_val_8502 === (12))){
var state_8501__$1 = state_8501;
var statearr_8509_8535 = state_8501__$1;
(statearr_8509_8535[(2)] = null);

(statearr_8509_8535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (2))){
var state_8501__$1 = state_8501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8501__$1,(4),from);
} else {
if((state_val_8502 === (11))){
var inst_8490 = (state_8501[(2)]);
var state_8501__$1 = state_8501;
if(cljs.core.truth_(inst_8490)){
var statearr_8510_8536 = state_8501__$1;
(statearr_8510_8536[(1)] = (12));

} else {
var statearr_8511_8537 = state_8501__$1;
(statearr_8511_8537[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (9))){
var state_8501__$1 = state_8501;
var statearr_8512_8538 = state_8501__$1;
(statearr_8512_8538[(2)] = null);

(statearr_8512_8538[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (5))){
var state_8501__$1 = state_8501;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8513_8539 = state_8501__$1;
(statearr_8513_8539[(1)] = (8));

} else {
var statearr_8514_8540 = state_8501__$1;
(statearr_8514_8540[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (14))){
var inst_8495 = (state_8501[(2)]);
var state_8501__$1 = state_8501;
var statearr_8515_8541 = state_8501__$1;
(statearr_8515_8541[(2)] = inst_8495);

(statearr_8515_8541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (10))){
var inst_8487 = (state_8501[(2)]);
var state_8501__$1 = state_8501;
var statearr_8516_8542 = state_8501__$1;
(statearr_8516_8542[(2)] = inst_8487);

(statearr_8516_8542[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8502 === (8))){
var inst_8484 = cljs.core.async.close_BANG_.call(null,to);
var state_8501__$1 = state_8501;
var statearr_8517_8543 = state_8501__$1;
(statearr_8517_8543[(2)] = inst_8484);

(statearr_8517_8543[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___8529))
;
return ((function (switch__8250__auto__,c__8362__auto___8529){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_8521 = [null,null,null,null,null,null,null,null];
(statearr_8521[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_8521[(1)] = (1));

return statearr_8521;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_8501){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_8501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e8522){if((e8522 instanceof Object)){
var ex__8254__auto__ = e8522;
var statearr_8523_8544 = state_8501;
(statearr_8523_8544[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8501);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8522;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8545 = state_8501;
state_8501 = G__8545;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_8501){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_8501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___8529))
})();
var state__8364__auto__ = (function (){var statearr_8524 = f__8363__auto__.call(null);
(statearr_8524[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___8529);

return statearr_8524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___8529))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__8729){
var vec__8730 = p__8729;
var v = cljs.core.nth.call(null,vec__8730,(0),null);
var p = cljs.core.nth.call(null,vec__8730,(1),null);
var job = vec__8730;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___8912 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___8912,res,vec__8730,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___8912,res,vec__8730,v,p,job,jobs,results){
return (function (state_8735){
var state_val_8736 = (state_8735[(1)]);
if((state_val_8736 === (1))){
var state_8735__$1 = state_8735;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8735__$1,(2),res,v);
} else {
if((state_val_8736 === (2))){
var inst_8732 = (state_8735[(2)]);
var inst_8733 = cljs.core.async.close_BANG_.call(null,res);
var state_8735__$1 = (function (){var statearr_8737 = state_8735;
(statearr_8737[(7)] = inst_8732);

return statearr_8737;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8735__$1,inst_8733);
} else {
return null;
}
}
});})(c__8362__auto___8912,res,vec__8730,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___8912,res,vec__8730,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_8741 = [null,null,null,null,null,null,null,null];
(statearr_8741[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_8741[(1)] = (1));

return statearr_8741;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_8735){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_8735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e8742){if((e8742 instanceof Object)){
var ex__8254__auto__ = e8742;
var statearr_8743_8913 = state_8735;
(statearr_8743_8913[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8742;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8914 = state_8735;
state_8735 = G__8914;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_8735){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_8735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___8912,res,vec__8730,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_8744 = f__8363__auto__.call(null);
(statearr_8744[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___8912);

return statearr_8744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___8912,res,vec__8730,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__8745){
var vec__8746 = p__8745;
var v = cljs.core.nth.call(null,vec__8746,(0),null);
var p = cljs.core.nth.call(null,vec__8746,(1),null);
var job = vec__8746;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___8915 = n;
var __8916 = (0);
while(true){
if((__8916 < n__5571__auto___8915)){
var G__8747_8917 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__8747_8917) {
case "compute":
var c__8362__auto___8919 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__8916,c__8362__auto___8919,G__8747_8917,n__5571__auto___8915,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__8916,c__8362__auto___8919,G__8747_8917,n__5571__auto___8915,jobs,results,process,async){
return (function (state_8760){
var state_val_8761 = (state_8760[(1)]);
if((state_val_8761 === (1))){
var state_8760__$1 = state_8760;
var statearr_8762_8920 = state_8760__$1;
(statearr_8762_8920[(2)] = null);

(statearr_8762_8920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8761 === (2))){
var state_8760__$1 = state_8760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8760__$1,(4),jobs);
} else {
if((state_val_8761 === (3))){
var inst_8758 = (state_8760[(2)]);
var state_8760__$1 = state_8760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8760__$1,inst_8758);
} else {
if((state_val_8761 === (4))){
var inst_8750 = (state_8760[(2)]);
var inst_8751 = process.call(null,inst_8750);
var state_8760__$1 = state_8760;
if(cljs.core.truth_(inst_8751)){
var statearr_8763_8921 = state_8760__$1;
(statearr_8763_8921[(1)] = (5));

} else {
var statearr_8764_8922 = state_8760__$1;
(statearr_8764_8922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8761 === (5))){
var state_8760__$1 = state_8760;
var statearr_8765_8923 = state_8760__$1;
(statearr_8765_8923[(2)] = null);

(statearr_8765_8923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8761 === (6))){
var state_8760__$1 = state_8760;
var statearr_8766_8924 = state_8760__$1;
(statearr_8766_8924[(2)] = null);

(statearr_8766_8924[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8761 === (7))){
var inst_8756 = (state_8760[(2)]);
var state_8760__$1 = state_8760;
var statearr_8767_8925 = state_8760__$1;
(statearr_8767_8925[(2)] = inst_8756);

(statearr_8767_8925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8916,c__8362__auto___8919,G__8747_8917,n__5571__auto___8915,jobs,results,process,async))
;
return ((function (__8916,switch__8250__auto__,c__8362__auto___8919,G__8747_8917,n__5571__auto___8915,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_8771 = [null,null,null,null,null,null,null];
(statearr_8771[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_8771[(1)] = (1));

return statearr_8771;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_8760){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_8760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e8772){if((e8772 instanceof Object)){
var ex__8254__auto__ = e8772;
var statearr_8773_8926 = state_8760;
(statearr_8773_8926[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8772;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8927 = state_8760;
state_8760 = G__8927;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_8760){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_8760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__8916,switch__8250__auto__,c__8362__auto___8919,G__8747_8917,n__5571__auto___8915,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_8774 = f__8363__auto__.call(null);
(statearr_8774[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___8919);

return statearr_8774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__8916,c__8362__auto___8919,G__8747_8917,n__5571__auto___8915,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___8928 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__8916,c__8362__auto___8928,G__8747_8917,n__5571__auto___8915,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__8916,c__8362__auto___8928,G__8747_8917,n__5571__auto___8915,jobs,results,process,async){
return (function (state_8787){
var state_val_8788 = (state_8787[(1)]);
if((state_val_8788 === (1))){
var state_8787__$1 = state_8787;
var statearr_8789_8929 = state_8787__$1;
(statearr_8789_8929[(2)] = null);

(statearr_8789_8929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8788 === (2))){
var state_8787__$1 = state_8787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8787__$1,(4),jobs);
} else {
if((state_val_8788 === (3))){
var inst_8785 = (state_8787[(2)]);
var state_8787__$1 = state_8787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8787__$1,inst_8785);
} else {
if((state_val_8788 === (4))){
var inst_8777 = (state_8787[(2)]);
var inst_8778 = async.call(null,inst_8777);
var state_8787__$1 = state_8787;
if(cljs.core.truth_(inst_8778)){
var statearr_8790_8930 = state_8787__$1;
(statearr_8790_8930[(1)] = (5));

} else {
var statearr_8791_8931 = state_8787__$1;
(statearr_8791_8931[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8788 === (5))){
var state_8787__$1 = state_8787;
var statearr_8792_8932 = state_8787__$1;
(statearr_8792_8932[(2)] = null);

(statearr_8792_8932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8788 === (6))){
var state_8787__$1 = state_8787;
var statearr_8793_8933 = state_8787__$1;
(statearr_8793_8933[(2)] = null);

(statearr_8793_8933[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8788 === (7))){
var inst_8783 = (state_8787[(2)]);
var state_8787__$1 = state_8787;
var statearr_8794_8934 = state_8787__$1;
(statearr_8794_8934[(2)] = inst_8783);

(statearr_8794_8934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8916,c__8362__auto___8928,G__8747_8917,n__5571__auto___8915,jobs,results,process,async))
;
return ((function (__8916,switch__8250__auto__,c__8362__auto___8928,G__8747_8917,n__5571__auto___8915,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_8798 = [null,null,null,null,null,null,null];
(statearr_8798[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_8798[(1)] = (1));

return statearr_8798;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_8787){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_8787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e8799){if((e8799 instanceof Object)){
var ex__8254__auto__ = e8799;
var statearr_8800_8935 = state_8787;
(statearr_8800_8935[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8787);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8799;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8936 = state_8787;
state_8787 = G__8936;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_8787){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_8787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__8916,switch__8250__auto__,c__8362__auto___8928,G__8747_8917,n__5571__auto___8915,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_8801 = f__8363__auto__.call(null);
(statearr_8801[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___8928);

return statearr_8801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__8916,c__8362__auto___8928,G__8747_8917,n__5571__auto___8915,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__8937 = (__8916 + (1));
__8916 = G__8937;
continue;
} else {
}
break;
}

var c__8362__auto___8938 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___8938,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___8938,jobs,results,process,async){
return (function (state_8823){
var state_val_8824 = (state_8823[(1)]);
if((state_val_8824 === (1))){
var state_8823__$1 = state_8823;
var statearr_8825_8939 = state_8823__$1;
(statearr_8825_8939[(2)] = null);

(statearr_8825_8939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8824 === (2))){
var state_8823__$1 = state_8823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8823__$1,(4),from);
} else {
if((state_val_8824 === (3))){
var inst_8821 = (state_8823[(2)]);
var state_8823__$1 = state_8823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8823__$1,inst_8821);
} else {
if((state_val_8824 === (4))){
var inst_8804 = (state_8823[(7)]);
var inst_8804__$1 = (state_8823[(2)]);
var inst_8805 = (inst_8804__$1 == null);
var state_8823__$1 = (function (){var statearr_8826 = state_8823;
(statearr_8826[(7)] = inst_8804__$1);

return statearr_8826;
})();
if(cljs.core.truth_(inst_8805)){
var statearr_8827_8940 = state_8823__$1;
(statearr_8827_8940[(1)] = (5));

} else {
var statearr_8828_8941 = state_8823__$1;
(statearr_8828_8941[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8824 === (5))){
var inst_8807 = cljs.core.async.close_BANG_.call(null,jobs);
var state_8823__$1 = state_8823;
var statearr_8829_8942 = state_8823__$1;
(statearr_8829_8942[(2)] = inst_8807);

(statearr_8829_8942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8824 === (6))){
var inst_8809 = (state_8823[(8)]);
var inst_8804 = (state_8823[(7)]);
var inst_8809__$1 = cljs.core.async.chan.call(null,(1));
var inst_8810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_8811 = [inst_8804,inst_8809__$1];
var inst_8812 = (new cljs.core.PersistentVector(null,2,(5),inst_8810,inst_8811,null));
var state_8823__$1 = (function (){var statearr_8830 = state_8823;
(statearr_8830[(8)] = inst_8809__$1);

return statearr_8830;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8823__$1,(8),jobs,inst_8812);
} else {
if((state_val_8824 === (7))){
var inst_8819 = (state_8823[(2)]);
var state_8823__$1 = state_8823;
var statearr_8831_8943 = state_8823__$1;
(statearr_8831_8943[(2)] = inst_8819);

(statearr_8831_8943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8824 === (8))){
var inst_8809 = (state_8823[(8)]);
var inst_8814 = (state_8823[(2)]);
var state_8823__$1 = (function (){var statearr_8832 = state_8823;
(statearr_8832[(9)] = inst_8814);

return statearr_8832;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8823__$1,(9),results,inst_8809);
} else {
if((state_val_8824 === (9))){
var inst_8816 = (state_8823[(2)]);
var state_8823__$1 = (function (){var statearr_8833 = state_8823;
(statearr_8833[(10)] = inst_8816);

return statearr_8833;
})();
var statearr_8834_8944 = state_8823__$1;
(statearr_8834_8944[(2)] = null);

(statearr_8834_8944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___8938,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___8938,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_8838 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8838[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_8838[(1)] = (1));

return statearr_8838;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_8823){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_8823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e8839){if((e8839 instanceof Object)){
var ex__8254__auto__ = e8839;
var statearr_8840_8945 = state_8823;
(statearr_8840_8945[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8823);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8839;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8946 = state_8823;
state_8823 = G__8946;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_8823){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_8823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___8938,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_8841 = f__8363__auto__.call(null);
(statearr_8841[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___8938);

return statearr_8841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___8938,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_8879){
var state_val_8880 = (state_8879[(1)]);
if((state_val_8880 === (7))){
var inst_8875 = (state_8879[(2)]);
var state_8879__$1 = state_8879;
var statearr_8881_8947 = state_8879__$1;
(statearr_8881_8947[(2)] = inst_8875);

(statearr_8881_8947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (20))){
var state_8879__$1 = state_8879;
var statearr_8882_8948 = state_8879__$1;
(statearr_8882_8948[(2)] = null);

(statearr_8882_8948[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (1))){
var state_8879__$1 = state_8879;
var statearr_8883_8949 = state_8879__$1;
(statearr_8883_8949[(2)] = null);

(statearr_8883_8949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (4))){
var inst_8844 = (state_8879[(7)]);
var inst_8844__$1 = (state_8879[(2)]);
var inst_8845 = (inst_8844__$1 == null);
var state_8879__$1 = (function (){var statearr_8884 = state_8879;
(statearr_8884[(7)] = inst_8844__$1);

return statearr_8884;
})();
if(cljs.core.truth_(inst_8845)){
var statearr_8885_8950 = state_8879__$1;
(statearr_8885_8950[(1)] = (5));

} else {
var statearr_8886_8951 = state_8879__$1;
(statearr_8886_8951[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (15))){
var inst_8857 = (state_8879[(8)]);
var state_8879__$1 = state_8879;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8879__$1,(18),to,inst_8857);
} else {
if((state_val_8880 === (21))){
var inst_8870 = (state_8879[(2)]);
var state_8879__$1 = state_8879;
var statearr_8887_8952 = state_8879__$1;
(statearr_8887_8952[(2)] = inst_8870);

(statearr_8887_8952[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (13))){
var inst_8872 = (state_8879[(2)]);
var state_8879__$1 = (function (){var statearr_8888 = state_8879;
(statearr_8888[(9)] = inst_8872);

return statearr_8888;
})();
var statearr_8889_8953 = state_8879__$1;
(statearr_8889_8953[(2)] = null);

(statearr_8889_8953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (6))){
var inst_8844 = (state_8879[(7)]);
var state_8879__$1 = state_8879;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8879__$1,(11),inst_8844);
} else {
if((state_val_8880 === (17))){
var inst_8865 = (state_8879[(2)]);
var state_8879__$1 = state_8879;
if(cljs.core.truth_(inst_8865)){
var statearr_8890_8954 = state_8879__$1;
(statearr_8890_8954[(1)] = (19));

} else {
var statearr_8891_8955 = state_8879__$1;
(statearr_8891_8955[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (3))){
var inst_8877 = (state_8879[(2)]);
var state_8879__$1 = state_8879;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8879__$1,inst_8877);
} else {
if((state_val_8880 === (12))){
var inst_8854 = (state_8879[(10)]);
var state_8879__$1 = state_8879;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8879__$1,(14),inst_8854);
} else {
if((state_val_8880 === (2))){
var state_8879__$1 = state_8879;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8879__$1,(4),results);
} else {
if((state_val_8880 === (19))){
var state_8879__$1 = state_8879;
var statearr_8892_8956 = state_8879__$1;
(statearr_8892_8956[(2)] = null);

(statearr_8892_8956[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (11))){
var inst_8854 = (state_8879[(2)]);
var state_8879__$1 = (function (){var statearr_8893 = state_8879;
(statearr_8893[(10)] = inst_8854);

return statearr_8893;
})();
var statearr_8894_8957 = state_8879__$1;
(statearr_8894_8957[(2)] = null);

(statearr_8894_8957[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (9))){
var state_8879__$1 = state_8879;
var statearr_8895_8958 = state_8879__$1;
(statearr_8895_8958[(2)] = null);

(statearr_8895_8958[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (5))){
var state_8879__$1 = state_8879;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8896_8959 = state_8879__$1;
(statearr_8896_8959[(1)] = (8));

} else {
var statearr_8897_8960 = state_8879__$1;
(statearr_8897_8960[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (14))){
var inst_8859 = (state_8879[(11)]);
var inst_8857 = (state_8879[(8)]);
var inst_8857__$1 = (state_8879[(2)]);
var inst_8858 = (inst_8857__$1 == null);
var inst_8859__$1 = cljs.core.not.call(null,inst_8858);
var state_8879__$1 = (function (){var statearr_8898 = state_8879;
(statearr_8898[(11)] = inst_8859__$1);

(statearr_8898[(8)] = inst_8857__$1);

return statearr_8898;
})();
if(inst_8859__$1){
var statearr_8899_8961 = state_8879__$1;
(statearr_8899_8961[(1)] = (15));

} else {
var statearr_8900_8962 = state_8879__$1;
(statearr_8900_8962[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (16))){
var inst_8859 = (state_8879[(11)]);
var state_8879__$1 = state_8879;
var statearr_8901_8963 = state_8879__$1;
(statearr_8901_8963[(2)] = inst_8859);

(statearr_8901_8963[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (10))){
var inst_8851 = (state_8879[(2)]);
var state_8879__$1 = state_8879;
var statearr_8902_8964 = state_8879__$1;
(statearr_8902_8964[(2)] = inst_8851);

(statearr_8902_8964[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (18))){
var inst_8862 = (state_8879[(2)]);
var state_8879__$1 = state_8879;
var statearr_8903_8965 = state_8879__$1;
(statearr_8903_8965[(2)] = inst_8862);

(statearr_8903_8965[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8880 === (8))){
var inst_8848 = cljs.core.async.close_BANG_.call(null,to);
var state_8879__$1 = state_8879;
var statearr_8904_8966 = state_8879__$1;
(statearr_8904_8966[(2)] = inst_8848);

(statearr_8904_8966[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_8908 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8908[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_8908[(1)] = (1));

return statearr_8908;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_8879){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_8879);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e8909){if((e8909 instanceof Object)){
var ex__8254__auto__ = e8909;
var statearr_8910_8967 = state_8879;
(statearr_8910_8967[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8879);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8909;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8968 = state_8879;
state_8879 = G__8968;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_8879){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_8879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_8911 = f__8363__auto__.call(null);
(statearr_8911[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_8911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args8969 = [];
var len__5726__auto___8972 = arguments.length;
var i__5727__auto___8973 = (0);
while(true){
if((i__5727__auto___8973 < len__5726__auto___8972)){
args8969.push((arguments[i__5727__auto___8973]));

var G__8974 = (i__5727__auto___8973 + (1));
i__5727__auto___8973 = G__8974;
continue;
} else {
}
break;
}

var G__8971 = args8969.length;
switch (G__8971) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8969.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args8976 = [];
var len__5726__auto___8979 = arguments.length;
var i__5727__auto___8980 = (0);
while(true){
if((i__5727__auto___8980 < len__5726__auto___8979)){
args8976.push((arguments[i__5727__auto___8980]));

var G__8981 = (i__5727__auto___8980 + (1));
i__5727__auto___8980 = G__8981;
continue;
} else {
}
break;
}

var G__8978 = args8976.length;
switch (G__8978) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8976.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args8983 = [];
var len__5726__auto___9036 = arguments.length;
var i__5727__auto___9037 = (0);
while(true){
if((i__5727__auto___9037 < len__5726__auto___9036)){
args8983.push((arguments[i__5727__auto___9037]));

var G__9038 = (i__5727__auto___9037 + (1));
i__5727__auto___9037 = G__9038;
continue;
} else {
}
break;
}

var G__8985 = args8983.length;
switch (G__8985) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args8983.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___9040 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___9040,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___9040,tc,fc){
return (function (state_9011){
var state_val_9012 = (state_9011[(1)]);
if((state_val_9012 === (7))){
var inst_9007 = (state_9011[(2)]);
var state_9011__$1 = state_9011;
var statearr_9013_9041 = state_9011__$1;
(statearr_9013_9041[(2)] = inst_9007);

(statearr_9013_9041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (1))){
var state_9011__$1 = state_9011;
var statearr_9014_9042 = state_9011__$1;
(statearr_9014_9042[(2)] = null);

(statearr_9014_9042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (4))){
var inst_8988 = (state_9011[(7)]);
var inst_8988__$1 = (state_9011[(2)]);
var inst_8989 = (inst_8988__$1 == null);
var state_9011__$1 = (function (){var statearr_9015 = state_9011;
(statearr_9015[(7)] = inst_8988__$1);

return statearr_9015;
})();
if(cljs.core.truth_(inst_8989)){
var statearr_9016_9043 = state_9011__$1;
(statearr_9016_9043[(1)] = (5));

} else {
var statearr_9017_9044 = state_9011__$1;
(statearr_9017_9044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (13))){
var state_9011__$1 = state_9011;
var statearr_9018_9045 = state_9011__$1;
(statearr_9018_9045[(2)] = null);

(statearr_9018_9045[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (6))){
var inst_8988 = (state_9011[(7)]);
var inst_8994 = p.call(null,inst_8988);
var state_9011__$1 = state_9011;
if(cljs.core.truth_(inst_8994)){
var statearr_9019_9046 = state_9011__$1;
(statearr_9019_9046[(1)] = (9));

} else {
var statearr_9020_9047 = state_9011__$1;
(statearr_9020_9047[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (3))){
var inst_9009 = (state_9011[(2)]);
var state_9011__$1 = state_9011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9011__$1,inst_9009);
} else {
if((state_val_9012 === (12))){
var state_9011__$1 = state_9011;
var statearr_9021_9048 = state_9011__$1;
(statearr_9021_9048[(2)] = null);

(statearr_9021_9048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (2))){
var state_9011__$1 = state_9011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9011__$1,(4),ch);
} else {
if((state_val_9012 === (11))){
var inst_8988 = (state_9011[(7)]);
var inst_8998 = (state_9011[(2)]);
var state_9011__$1 = state_9011;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9011__$1,(8),inst_8998,inst_8988);
} else {
if((state_val_9012 === (9))){
var state_9011__$1 = state_9011;
var statearr_9022_9049 = state_9011__$1;
(statearr_9022_9049[(2)] = tc);

(statearr_9022_9049[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (5))){
var inst_8991 = cljs.core.async.close_BANG_.call(null,tc);
var inst_8992 = cljs.core.async.close_BANG_.call(null,fc);
var state_9011__$1 = (function (){var statearr_9023 = state_9011;
(statearr_9023[(8)] = inst_8991);

return statearr_9023;
})();
var statearr_9024_9050 = state_9011__$1;
(statearr_9024_9050[(2)] = inst_8992);

(statearr_9024_9050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (14))){
var inst_9005 = (state_9011[(2)]);
var state_9011__$1 = state_9011;
var statearr_9025_9051 = state_9011__$1;
(statearr_9025_9051[(2)] = inst_9005);

(statearr_9025_9051[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (10))){
var state_9011__$1 = state_9011;
var statearr_9026_9052 = state_9011__$1;
(statearr_9026_9052[(2)] = fc);

(statearr_9026_9052[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9012 === (8))){
var inst_9000 = (state_9011[(2)]);
var state_9011__$1 = state_9011;
if(cljs.core.truth_(inst_9000)){
var statearr_9027_9053 = state_9011__$1;
(statearr_9027_9053[(1)] = (12));

} else {
var statearr_9028_9054 = state_9011__$1;
(statearr_9028_9054[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___9040,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___9040,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_9032 = [null,null,null,null,null,null,null,null,null];
(statearr_9032[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_9032[(1)] = (1));

return statearr_9032;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_9011){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_9011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e9033){if((e9033 instanceof Object)){
var ex__8254__auto__ = e9033;
var statearr_9034_9055 = state_9011;
(statearr_9034_9055[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9011);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9056 = state_9011;
state_9011 = G__9056;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_9011){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_9011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___9040,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_9035 = f__8363__auto__.call(null);
(statearr_9035[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___9040);

return statearr_9035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___9040,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_9120){
var state_val_9121 = (state_9120[(1)]);
if((state_val_9121 === (7))){
var inst_9116 = (state_9120[(2)]);
var state_9120__$1 = state_9120;
var statearr_9122_9143 = state_9120__$1;
(statearr_9122_9143[(2)] = inst_9116);

(statearr_9122_9143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9121 === (1))){
var inst_9100 = init;
var state_9120__$1 = (function (){var statearr_9123 = state_9120;
(statearr_9123[(7)] = inst_9100);

return statearr_9123;
})();
var statearr_9124_9144 = state_9120__$1;
(statearr_9124_9144[(2)] = null);

(statearr_9124_9144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9121 === (4))){
var inst_9103 = (state_9120[(8)]);
var inst_9103__$1 = (state_9120[(2)]);
var inst_9104 = (inst_9103__$1 == null);
var state_9120__$1 = (function (){var statearr_9125 = state_9120;
(statearr_9125[(8)] = inst_9103__$1);

return statearr_9125;
})();
if(cljs.core.truth_(inst_9104)){
var statearr_9126_9145 = state_9120__$1;
(statearr_9126_9145[(1)] = (5));

} else {
var statearr_9127_9146 = state_9120__$1;
(statearr_9127_9146[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9121 === (6))){
var inst_9100 = (state_9120[(7)]);
var inst_9107 = (state_9120[(9)]);
var inst_9103 = (state_9120[(8)]);
var inst_9107__$1 = f.call(null,inst_9100,inst_9103);
var inst_9108 = cljs.core.reduced_QMARK_.call(null,inst_9107__$1);
var state_9120__$1 = (function (){var statearr_9128 = state_9120;
(statearr_9128[(9)] = inst_9107__$1);

return statearr_9128;
})();
if(inst_9108){
var statearr_9129_9147 = state_9120__$1;
(statearr_9129_9147[(1)] = (8));

} else {
var statearr_9130_9148 = state_9120__$1;
(statearr_9130_9148[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9121 === (3))){
var inst_9118 = (state_9120[(2)]);
var state_9120__$1 = state_9120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9120__$1,inst_9118);
} else {
if((state_val_9121 === (2))){
var state_9120__$1 = state_9120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9120__$1,(4),ch);
} else {
if((state_val_9121 === (9))){
var inst_9107 = (state_9120[(9)]);
var inst_9100 = inst_9107;
var state_9120__$1 = (function (){var statearr_9131 = state_9120;
(statearr_9131[(7)] = inst_9100);

return statearr_9131;
})();
var statearr_9132_9149 = state_9120__$1;
(statearr_9132_9149[(2)] = null);

(statearr_9132_9149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9121 === (5))){
var inst_9100 = (state_9120[(7)]);
var state_9120__$1 = state_9120;
var statearr_9133_9150 = state_9120__$1;
(statearr_9133_9150[(2)] = inst_9100);

(statearr_9133_9150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9121 === (10))){
var inst_9114 = (state_9120[(2)]);
var state_9120__$1 = state_9120;
var statearr_9134_9151 = state_9120__$1;
(statearr_9134_9151[(2)] = inst_9114);

(statearr_9134_9151[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9121 === (8))){
var inst_9107 = (state_9120[(9)]);
var inst_9110 = cljs.core.deref.call(null,inst_9107);
var state_9120__$1 = state_9120;
var statearr_9135_9152 = state_9120__$1;
(statearr_9135_9152[(2)] = inst_9110);

(statearr_9135_9152[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_9139 = [null,null,null,null,null,null,null,null,null,null];
(statearr_9139[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_9139[(1)] = (1));

return statearr_9139;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_9120){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_9120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e9140){if((e9140 instanceof Object)){
var ex__8254__auto__ = e9140;
var statearr_9141_9153 = state_9120;
(statearr_9141_9153[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9140;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9154 = state_9120;
state_9120 = G__9154;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_9120){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_9120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_9142 = f__8363__auto__.call(null);
(statearr_9142[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_9142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args9155 = [];
var len__5726__auto___9207 = arguments.length;
var i__5727__auto___9208 = (0);
while(true){
if((i__5727__auto___9208 < len__5726__auto___9207)){
args9155.push((arguments[i__5727__auto___9208]));

var G__9209 = (i__5727__auto___9208 + (1));
i__5727__auto___9208 = G__9209;
continue;
} else {
}
break;
}

var G__9157 = args9155.length;
switch (G__9157) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9155.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_9182){
var state_val_9183 = (state_9182[(1)]);
if((state_val_9183 === (7))){
var inst_9164 = (state_9182[(2)]);
var state_9182__$1 = state_9182;
var statearr_9184_9211 = state_9182__$1;
(statearr_9184_9211[(2)] = inst_9164);

(statearr_9184_9211[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (1))){
var inst_9158 = cljs.core.seq.call(null,coll);
var inst_9159 = inst_9158;
var state_9182__$1 = (function (){var statearr_9185 = state_9182;
(statearr_9185[(7)] = inst_9159);

return statearr_9185;
})();
var statearr_9186_9212 = state_9182__$1;
(statearr_9186_9212[(2)] = null);

(statearr_9186_9212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (4))){
var inst_9159 = (state_9182[(7)]);
var inst_9162 = cljs.core.first.call(null,inst_9159);
var state_9182__$1 = state_9182;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9182__$1,(7),ch,inst_9162);
} else {
if((state_val_9183 === (13))){
var inst_9176 = (state_9182[(2)]);
var state_9182__$1 = state_9182;
var statearr_9187_9213 = state_9182__$1;
(statearr_9187_9213[(2)] = inst_9176);

(statearr_9187_9213[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (6))){
var inst_9167 = (state_9182[(2)]);
var state_9182__$1 = state_9182;
if(cljs.core.truth_(inst_9167)){
var statearr_9188_9214 = state_9182__$1;
(statearr_9188_9214[(1)] = (8));

} else {
var statearr_9189_9215 = state_9182__$1;
(statearr_9189_9215[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (3))){
var inst_9180 = (state_9182[(2)]);
var state_9182__$1 = state_9182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9182__$1,inst_9180);
} else {
if((state_val_9183 === (12))){
var state_9182__$1 = state_9182;
var statearr_9190_9216 = state_9182__$1;
(statearr_9190_9216[(2)] = null);

(statearr_9190_9216[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (2))){
var inst_9159 = (state_9182[(7)]);
var state_9182__$1 = state_9182;
if(cljs.core.truth_(inst_9159)){
var statearr_9191_9217 = state_9182__$1;
(statearr_9191_9217[(1)] = (4));

} else {
var statearr_9192_9218 = state_9182__$1;
(statearr_9192_9218[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (11))){
var inst_9173 = cljs.core.async.close_BANG_.call(null,ch);
var state_9182__$1 = state_9182;
var statearr_9193_9219 = state_9182__$1;
(statearr_9193_9219[(2)] = inst_9173);

(statearr_9193_9219[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (9))){
var state_9182__$1 = state_9182;
if(cljs.core.truth_(close_QMARK_)){
var statearr_9194_9220 = state_9182__$1;
(statearr_9194_9220[(1)] = (11));

} else {
var statearr_9195_9221 = state_9182__$1;
(statearr_9195_9221[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (5))){
var inst_9159 = (state_9182[(7)]);
var state_9182__$1 = state_9182;
var statearr_9196_9222 = state_9182__$1;
(statearr_9196_9222[(2)] = inst_9159);

(statearr_9196_9222[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (10))){
var inst_9178 = (state_9182[(2)]);
var state_9182__$1 = state_9182;
var statearr_9197_9223 = state_9182__$1;
(statearr_9197_9223[(2)] = inst_9178);

(statearr_9197_9223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9183 === (8))){
var inst_9159 = (state_9182[(7)]);
var inst_9169 = cljs.core.next.call(null,inst_9159);
var inst_9159__$1 = inst_9169;
var state_9182__$1 = (function (){var statearr_9198 = state_9182;
(statearr_9198[(7)] = inst_9159__$1);

return statearr_9198;
})();
var statearr_9199_9224 = state_9182__$1;
(statearr_9199_9224[(2)] = null);

(statearr_9199_9224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_9203 = [null,null,null,null,null,null,null,null];
(statearr_9203[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_9203[(1)] = (1));

return statearr_9203;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_9182){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_9182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e9204){if((e9204 instanceof Object)){
var ex__8254__auto__ = e9204;
var statearr_9205_9225 = state_9182;
(statearr_9205_9225[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9182);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9204;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9226 = state_9182;
state_9182 = G__9226;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_9182){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_9182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_9206 = f__8363__auto__.call(null);
(statearr_9206[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_9206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async9448 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9448 = (function (mult,ch,cs,meta9449){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta9449 = meta9449;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async9448.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_9450,meta9449__$1){
var self__ = this;
var _9450__$1 = this;
return (new cljs.core.async.t_cljs$core$async9448(self__.mult,self__.ch,self__.cs,meta9449__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async9448.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_9450){
var self__ = this;
var _9450__$1 = this;
return self__.meta9449;
});})(cs))
;

cljs.core.async.t_cljs$core$async9448.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async9448.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async9448.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async9448.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9448.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9448.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9448.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta9449","meta9449",-145929560,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async9448.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9448.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9448";

cljs.core.async.t_cljs$core$async9448.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async9448");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async9448 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async9448(mult__$1,ch__$1,cs__$1,meta9449){
return (new cljs.core.async.t_cljs$core$async9448(mult__$1,ch__$1,cs__$1,meta9449));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async9448(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___9669 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___9669,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___9669,cs,m,dchan,dctr,done){
return (function (state_9581){
var state_val_9582 = (state_9581[(1)]);
if((state_val_9582 === (7))){
var inst_9577 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9583_9670 = state_9581__$1;
(statearr_9583_9670[(2)] = inst_9577);

(statearr_9583_9670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (20))){
var inst_9482 = (state_9581[(7)]);
var inst_9492 = cljs.core.first.call(null,inst_9482);
var inst_9493 = cljs.core.nth.call(null,inst_9492,(0),null);
var inst_9494 = cljs.core.nth.call(null,inst_9492,(1),null);
var state_9581__$1 = (function (){var statearr_9584 = state_9581;
(statearr_9584[(8)] = inst_9493);

return statearr_9584;
})();
if(cljs.core.truth_(inst_9494)){
var statearr_9585_9671 = state_9581__$1;
(statearr_9585_9671[(1)] = (22));

} else {
var statearr_9586_9672 = state_9581__$1;
(statearr_9586_9672[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (27))){
var inst_9453 = (state_9581[(9)]);
var inst_9522 = (state_9581[(10)]);
var inst_9524 = (state_9581[(11)]);
var inst_9529 = (state_9581[(12)]);
var inst_9529__$1 = cljs.core._nth.call(null,inst_9522,inst_9524);
var inst_9530 = cljs.core.async.put_BANG_.call(null,inst_9529__$1,inst_9453,done);
var state_9581__$1 = (function (){var statearr_9587 = state_9581;
(statearr_9587[(12)] = inst_9529__$1);

return statearr_9587;
})();
if(cljs.core.truth_(inst_9530)){
var statearr_9588_9673 = state_9581__$1;
(statearr_9588_9673[(1)] = (30));

} else {
var statearr_9589_9674 = state_9581__$1;
(statearr_9589_9674[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (1))){
var state_9581__$1 = state_9581;
var statearr_9590_9675 = state_9581__$1;
(statearr_9590_9675[(2)] = null);

(statearr_9590_9675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (24))){
var inst_9482 = (state_9581[(7)]);
var inst_9499 = (state_9581[(2)]);
var inst_9500 = cljs.core.next.call(null,inst_9482);
var inst_9462 = inst_9500;
var inst_9463 = null;
var inst_9464 = (0);
var inst_9465 = (0);
var state_9581__$1 = (function (){var statearr_9591 = state_9581;
(statearr_9591[(13)] = inst_9499);

(statearr_9591[(14)] = inst_9463);

(statearr_9591[(15)] = inst_9464);

(statearr_9591[(16)] = inst_9462);

(statearr_9591[(17)] = inst_9465);

return statearr_9591;
})();
var statearr_9592_9676 = state_9581__$1;
(statearr_9592_9676[(2)] = null);

(statearr_9592_9676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (39))){
var state_9581__$1 = state_9581;
var statearr_9596_9677 = state_9581__$1;
(statearr_9596_9677[(2)] = null);

(statearr_9596_9677[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (4))){
var inst_9453 = (state_9581[(9)]);
var inst_9453__$1 = (state_9581[(2)]);
var inst_9454 = (inst_9453__$1 == null);
var state_9581__$1 = (function (){var statearr_9597 = state_9581;
(statearr_9597[(9)] = inst_9453__$1);

return statearr_9597;
})();
if(cljs.core.truth_(inst_9454)){
var statearr_9598_9678 = state_9581__$1;
(statearr_9598_9678[(1)] = (5));

} else {
var statearr_9599_9679 = state_9581__$1;
(statearr_9599_9679[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (15))){
var inst_9463 = (state_9581[(14)]);
var inst_9464 = (state_9581[(15)]);
var inst_9462 = (state_9581[(16)]);
var inst_9465 = (state_9581[(17)]);
var inst_9478 = (state_9581[(2)]);
var inst_9479 = (inst_9465 + (1));
var tmp9593 = inst_9463;
var tmp9594 = inst_9464;
var tmp9595 = inst_9462;
var inst_9462__$1 = tmp9595;
var inst_9463__$1 = tmp9593;
var inst_9464__$1 = tmp9594;
var inst_9465__$1 = inst_9479;
var state_9581__$1 = (function (){var statearr_9600 = state_9581;
(statearr_9600[(18)] = inst_9478);

(statearr_9600[(14)] = inst_9463__$1);

(statearr_9600[(15)] = inst_9464__$1);

(statearr_9600[(16)] = inst_9462__$1);

(statearr_9600[(17)] = inst_9465__$1);

return statearr_9600;
})();
var statearr_9601_9680 = state_9581__$1;
(statearr_9601_9680[(2)] = null);

(statearr_9601_9680[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (21))){
var inst_9503 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9605_9681 = state_9581__$1;
(statearr_9605_9681[(2)] = inst_9503);

(statearr_9605_9681[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (31))){
var inst_9529 = (state_9581[(12)]);
var inst_9533 = done.call(null,null);
var inst_9534 = cljs.core.async.untap_STAR_.call(null,m,inst_9529);
var state_9581__$1 = (function (){var statearr_9606 = state_9581;
(statearr_9606[(19)] = inst_9533);

return statearr_9606;
})();
var statearr_9607_9682 = state_9581__$1;
(statearr_9607_9682[(2)] = inst_9534);

(statearr_9607_9682[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (32))){
var inst_9523 = (state_9581[(20)]);
var inst_9522 = (state_9581[(10)]);
var inst_9524 = (state_9581[(11)]);
var inst_9521 = (state_9581[(21)]);
var inst_9536 = (state_9581[(2)]);
var inst_9537 = (inst_9524 + (1));
var tmp9602 = inst_9523;
var tmp9603 = inst_9522;
var tmp9604 = inst_9521;
var inst_9521__$1 = tmp9604;
var inst_9522__$1 = tmp9603;
var inst_9523__$1 = tmp9602;
var inst_9524__$1 = inst_9537;
var state_9581__$1 = (function (){var statearr_9608 = state_9581;
(statearr_9608[(20)] = inst_9523__$1);

(statearr_9608[(10)] = inst_9522__$1);

(statearr_9608[(22)] = inst_9536);

(statearr_9608[(11)] = inst_9524__$1);

(statearr_9608[(21)] = inst_9521__$1);

return statearr_9608;
})();
var statearr_9609_9683 = state_9581__$1;
(statearr_9609_9683[(2)] = null);

(statearr_9609_9683[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (40))){
var inst_9549 = (state_9581[(23)]);
var inst_9553 = done.call(null,null);
var inst_9554 = cljs.core.async.untap_STAR_.call(null,m,inst_9549);
var state_9581__$1 = (function (){var statearr_9610 = state_9581;
(statearr_9610[(24)] = inst_9553);

return statearr_9610;
})();
var statearr_9611_9684 = state_9581__$1;
(statearr_9611_9684[(2)] = inst_9554);

(statearr_9611_9684[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (33))){
var inst_9540 = (state_9581[(25)]);
var inst_9542 = cljs.core.chunked_seq_QMARK_.call(null,inst_9540);
var state_9581__$1 = state_9581;
if(inst_9542){
var statearr_9612_9685 = state_9581__$1;
(statearr_9612_9685[(1)] = (36));

} else {
var statearr_9613_9686 = state_9581__$1;
(statearr_9613_9686[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (13))){
var inst_9472 = (state_9581[(26)]);
var inst_9475 = cljs.core.async.close_BANG_.call(null,inst_9472);
var state_9581__$1 = state_9581;
var statearr_9614_9687 = state_9581__$1;
(statearr_9614_9687[(2)] = inst_9475);

(statearr_9614_9687[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (22))){
var inst_9493 = (state_9581[(8)]);
var inst_9496 = cljs.core.async.close_BANG_.call(null,inst_9493);
var state_9581__$1 = state_9581;
var statearr_9615_9688 = state_9581__$1;
(statearr_9615_9688[(2)] = inst_9496);

(statearr_9615_9688[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (36))){
var inst_9540 = (state_9581[(25)]);
var inst_9544 = cljs.core.chunk_first.call(null,inst_9540);
var inst_9545 = cljs.core.chunk_rest.call(null,inst_9540);
var inst_9546 = cljs.core.count.call(null,inst_9544);
var inst_9521 = inst_9545;
var inst_9522 = inst_9544;
var inst_9523 = inst_9546;
var inst_9524 = (0);
var state_9581__$1 = (function (){var statearr_9616 = state_9581;
(statearr_9616[(20)] = inst_9523);

(statearr_9616[(10)] = inst_9522);

(statearr_9616[(11)] = inst_9524);

(statearr_9616[(21)] = inst_9521);

return statearr_9616;
})();
var statearr_9617_9689 = state_9581__$1;
(statearr_9617_9689[(2)] = null);

(statearr_9617_9689[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (41))){
var inst_9540 = (state_9581[(25)]);
var inst_9556 = (state_9581[(2)]);
var inst_9557 = cljs.core.next.call(null,inst_9540);
var inst_9521 = inst_9557;
var inst_9522 = null;
var inst_9523 = (0);
var inst_9524 = (0);
var state_9581__$1 = (function (){var statearr_9618 = state_9581;
(statearr_9618[(20)] = inst_9523);

(statearr_9618[(10)] = inst_9522);

(statearr_9618[(11)] = inst_9524);

(statearr_9618[(27)] = inst_9556);

(statearr_9618[(21)] = inst_9521);

return statearr_9618;
})();
var statearr_9619_9690 = state_9581__$1;
(statearr_9619_9690[(2)] = null);

(statearr_9619_9690[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (43))){
var state_9581__$1 = state_9581;
var statearr_9620_9691 = state_9581__$1;
(statearr_9620_9691[(2)] = null);

(statearr_9620_9691[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (29))){
var inst_9565 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9621_9692 = state_9581__$1;
(statearr_9621_9692[(2)] = inst_9565);

(statearr_9621_9692[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (44))){
var inst_9574 = (state_9581[(2)]);
var state_9581__$1 = (function (){var statearr_9622 = state_9581;
(statearr_9622[(28)] = inst_9574);

return statearr_9622;
})();
var statearr_9623_9693 = state_9581__$1;
(statearr_9623_9693[(2)] = null);

(statearr_9623_9693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (6))){
var inst_9513 = (state_9581[(29)]);
var inst_9512 = cljs.core.deref.call(null,cs);
var inst_9513__$1 = cljs.core.keys.call(null,inst_9512);
var inst_9514 = cljs.core.count.call(null,inst_9513__$1);
var inst_9515 = cljs.core.reset_BANG_.call(null,dctr,inst_9514);
var inst_9520 = cljs.core.seq.call(null,inst_9513__$1);
var inst_9521 = inst_9520;
var inst_9522 = null;
var inst_9523 = (0);
var inst_9524 = (0);
var state_9581__$1 = (function (){var statearr_9624 = state_9581;
(statearr_9624[(30)] = inst_9515);

(statearr_9624[(29)] = inst_9513__$1);

(statearr_9624[(20)] = inst_9523);

(statearr_9624[(10)] = inst_9522);

(statearr_9624[(11)] = inst_9524);

(statearr_9624[(21)] = inst_9521);

return statearr_9624;
})();
var statearr_9625_9694 = state_9581__$1;
(statearr_9625_9694[(2)] = null);

(statearr_9625_9694[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (28))){
var inst_9540 = (state_9581[(25)]);
var inst_9521 = (state_9581[(21)]);
var inst_9540__$1 = cljs.core.seq.call(null,inst_9521);
var state_9581__$1 = (function (){var statearr_9626 = state_9581;
(statearr_9626[(25)] = inst_9540__$1);

return statearr_9626;
})();
if(inst_9540__$1){
var statearr_9627_9695 = state_9581__$1;
(statearr_9627_9695[(1)] = (33));

} else {
var statearr_9628_9696 = state_9581__$1;
(statearr_9628_9696[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (25))){
var inst_9523 = (state_9581[(20)]);
var inst_9524 = (state_9581[(11)]);
var inst_9526 = (inst_9524 < inst_9523);
var inst_9527 = inst_9526;
var state_9581__$1 = state_9581;
if(cljs.core.truth_(inst_9527)){
var statearr_9629_9697 = state_9581__$1;
(statearr_9629_9697[(1)] = (27));

} else {
var statearr_9630_9698 = state_9581__$1;
(statearr_9630_9698[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (34))){
var state_9581__$1 = state_9581;
var statearr_9631_9699 = state_9581__$1;
(statearr_9631_9699[(2)] = null);

(statearr_9631_9699[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (17))){
var state_9581__$1 = state_9581;
var statearr_9632_9700 = state_9581__$1;
(statearr_9632_9700[(2)] = null);

(statearr_9632_9700[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (3))){
var inst_9579 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9581__$1,inst_9579);
} else {
if((state_val_9582 === (12))){
var inst_9508 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9633_9701 = state_9581__$1;
(statearr_9633_9701[(2)] = inst_9508);

(statearr_9633_9701[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (2))){
var state_9581__$1 = state_9581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9581__$1,(4),ch);
} else {
if((state_val_9582 === (23))){
var state_9581__$1 = state_9581;
var statearr_9634_9702 = state_9581__$1;
(statearr_9634_9702[(2)] = null);

(statearr_9634_9702[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (35))){
var inst_9563 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9635_9703 = state_9581__$1;
(statearr_9635_9703[(2)] = inst_9563);

(statearr_9635_9703[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (19))){
var inst_9482 = (state_9581[(7)]);
var inst_9486 = cljs.core.chunk_first.call(null,inst_9482);
var inst_9487 = cljs.core.chunk_rest.call(null,inst_9482);
var inst_9488 = cljs.core.count.call(null,inst_9486);
var inst_9462 = inst_9487;
var inst_9463 = inst_9486;
var inst_9464 = inst_9488;
var inst_9465 = (0);
var state_9581__$1 = (function (){var statearr_9636 = state_9581;
(statearr_9636[(14)] = inst_9463);

(statearr_9636[(15)] = inst_9464);

(statearr_9636[(16)] = inst_9462);

(statearr_9636[(17)] = inst_9465);

return statearr_9636;
})();
var statearr_9637_9704 = state_9581__$1;
(statearr_9637_9704[(2)] = null);

(statearr_9637_9704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (11))){
var inst_9462 = (state_9581[(16)]);
var inst_9482 = (state_9581[(7)]);
var inst_9482__$1 = cljs.core.seq.call(null,inst_9462);
var state_9581__$1 = (function (){var statearr_9638 = state_9581;
(statearr_9638[(7)] = inst_9482__$1);

return statearr_9638;
})();
if(inst_9482__$1){
var statearr_9639_9705 = state_9581__$1;
(statearr_9639_9705[(1)] = (16));

} else {
var statearr_9640_9706 = state_9581__$1;
(statearr_9640_9706[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (9))){
var inst_9510 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9641_9707 = state_9581__$1;
(statearr_9641_9707[(2)] = inst_9510);

(statearr_9641_9707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (5))){
var inst_9460 = cljs.core.deref.call(null,cs);
var inst_9461 = cljs.core.seq.call(null,inst_9460);
var inst_9462 = inst_9461;
var inst_9463 = null;
var inst_9464 = (0);
var inst_9465 = (0);
var state_9581__$1 = (function (){var statearr_9642 = state_9581;
(statearr_9642[(14)] = inst_9463);

(statearr_9642[(15)] = inst_9464);

(statearr_9642[(16)] = inst_9462);

(statearr_9642[(17)] = inst_9465);

return statearr_9642;
})();
var statearr_9643_9708 = state_9581__$1;
(statearr_9643_9708[(2)] = null);

(statearr_9643_9708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (14))){
var state_9581__$1 = state_9581;
var statearr_9644_9709 = state_9581__$1;
(statearr_9644_9709[(2)] = null);

(statearr_9644_9709[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (45))){
var inst_9571 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9645_9710 = state_9581__$1;
(statearr_9645_9710[(2)] = inst_9571);

(statearr_9645_9710[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (26))){
var inst_9513 = (state_9581[(29)]);
var inst_9567 = (state_9581[(2)]);
var inst_9568 = cljs.core.seq.call(null,inst_9513);
var state_9581__$1 = (function (){var statearr_9646 = state_9581;
(statearr_9646[(31)] = inst_9567);

return statearr_9646;
})();
if(inst_9568){
var statearr_9647_9711 = state_9581__$1;
(statearr_9647_9711[(1)] = (42));

} else {
var statearr_9648_9712 = state_9581__$1;
(statearr_9648_9712[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (16))){
var inst_9482 = (state_9581[(7)]);
var inst_9484 = cljs.core.chunked_seq_QMARK_.call(null,inst_9482);
var state_9581__$1 = state_9581;
if(inst_9484){
var statearr_9649_9713 = state_9581__$1;
(statearr_9649_9713[(1)] = (19));

} else {
var statearr_9650_9714 = state_9581__$1;
(statearr_9650_9714[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (38))){
var inst_9560 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9651_9715 = state_9581__$1;
(statearr_9651_9715[(2)] = inst_9560);

(statearr_9651_9715[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (30))){
var state_9581__$1 = state_9581;
var statearr_9652_9716 = state_9581__$1;
(statearr_9652_9716[(2)] = null);

(statearr_9652_9716[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (10))){
var inst_9463 = (state_9581[(14)]);
var inst_9465 = (state_9581[(17)]);
var inst_9471 = cljs.core._nth.call(null,inst_9463,inst_9465);
var inst_9472 = cljs.core.nth.call(null,inst_9471,(0),null);
var inst_9473 = cljs.core.nth.call(null,inst_9471,(1),null);
var state_9581__$1 = (function (){var statearr_9653 = state_9581;
(statearr_9653[(26)] = inst_9472);

return statearr_9653;
})();
if(cljs.core.truth_(inst_9473)){
var statearr_9654_9717 = state_9581__$1;
(statearr_9654_9717[(1)] = (13));

} else {
var statearr_9655_9718 = state_9581__$1;
(statearr_9655_9718[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (18))){
var inst_9506 = (state_9581[(2)]);
var state_9581__$1 = state_9581;
var statearr_9656_9719 = state_9581__$1;
(statearr_9656_9719[(2)] = inst_9506);

(statearr_9656_9719[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (42))){
var state_9581__$1 = state_9581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9581__$1,(45),dchan);
} else {
if((state_val_9582 === (37))){
var inst_9549 = (state_9581[(23)]);
var inst_9540 = (state_9581[(25)]);
var inst_9453 = (state_9581[(9)]);
var inst_9549__$1 = cljs.core.first.call(null,inst_9540);
var inst_9550 = cljs.core.async.put_BANG_.call(null,inst_9549__$1,inst_9453,done);
var state_9581__$1 = (function (){var statearr_9657 = state_9581;
(statearr_9657[(23)] = inst_9549__$1);

return statearr_9657;
})();
if(cljs.core.truth_(inst_9550)){
var statearr_9658_9720 = state_9581__$1;
(statearr_9658_9720[(1)] = (39));

} else {
var statearr_9659_9721 = state_9581__$1;
(statearr_9659_9721[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9582 === (8))){
var inst_9464 = (state_9581[(15)]);
var inst_9465 = (state_9581[(17)]);
var inst_9467 = (inst_9465 < inst_9464);
var inst_9468 = inst_9467;
var state_9581__$1 = state_9581;
if(cljs.core.truth_(inst_9468)){
var statearr_9660_9722 = state_9581__$1;
(statearr_9660_9722[(1)] = (10));

} else {
var statearr_9661_9723 = state_9581__$1;
(statearr_9661_9723[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___9669,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___9669,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_9665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9665[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_9665[(1)] = (1));

return statearr_9665;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_9581){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_9581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e9666){if((e9666 instanceof Object)){
var ex__8254__auto__ = e9666;
var statearr_9667_9724 = state_9581;
(statearr_9667_9724[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9581);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9666;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9725 = state_9581;
state_9581 = G__9725;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_9581){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_9581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___9669,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_9668 = f__8363__auto__.call(null);
(statearr_9668[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___9669);

return statearr_9668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___9669,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args9726 = [];
var len__5726__auto___9729 = arguments.length;
var i__5727__auto___9730 = (0);
while(true){
if((i__5727__auto___9730 < len__5726__auto___9729)){
args9726.push((arguments[i__5727__auto___9730]));

var G__9731 = (i__5727__auto___9730 + (1));
i__5727__auto___9730 = G__9731;
continue;
} else {
}
break;
}

var G__9728 = args9726.length;
switch (G__9728) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args9726.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___9743 = arguments.length;
var i__5727__auto___9744 = (0);
while(true){
if((i__5727__auto___9744 < len__5726__auto___9743)){
args__5733__auto__.push((arguments[i__5727__auto___9744]));

var G__9745 = (i__5727__auto___9744 + (1));
i__5727__auto___9744 = G__9745;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__9737){
var map__9738 = p__9737;
var map__9738__$1 = ((((!((map__9738 == null)))?((((map__9738.cljs$lang$protocol_mask$partition0$ & (64))) || (map__9738.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9738):map__9738);
var opts = map__9738__$1;
var statearr_9740_9746 = state;
(statearr_9740_9746[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__9738,map__9738__$1,opts){
return (function (val){
var statearr_9741_9747 = state;
(statearr_9741_9747[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__9738,map__9738__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_9742_9748 = state;
(statearr_9742_9748[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq9733){
var G__9734 = cljs.core.first.call(null,seq9733);
var seq9733__$1 = cljs.core.next.call(null,seq9733);
var G__9735 = cljs.core.first.call(null,seq9733__$1);
var seq9733__$2 = cljs.core.next.call(null,seq9733__$1);
var G__9736 = cljs.core.first.call(null,seq9733__$2);
var seq9733__$3 = cljs.core.next.call(null,seq9733__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9734,G__9735,G__9736,seq9733__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async9912 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9912 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta9913){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta9913 = meta9913;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_9914,meta9913__$1){
var self__ = this;
var _9914__$1 = this;
return (new cljs.core.async.t_cljs$core$async9912(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta9913__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_9914){
var self__ = this;
var _9914__$1 = this;
return self__.meta9913;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta9913","meta9913",-1906028765,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9912.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9912.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9912";

cljs.core.async.t_cljs$core$async9912.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async9912");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async9912 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async9912(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta9913){
return (new cljs.core.async.t_cljs$core$async9912(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta9913));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async9912(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___10075 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___10075,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___10075,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_10012){
var state_val_10013 = (state_10012[(1)]);
if((state_val_10013 === (7))){
var inst_9930 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
var statearr_10014_10076 = state_10012__$1;
(statearr_10014_10076[(2)] = inst_9930);

(statearr_10014_10076[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (20))){
var inst_9942 = (state_10012[(7)]);
var state_10012__$1 = state_10012;
var statearr_10015_10077 = state_10012__$1;
(statearr_10015_10077[(2)] = inst_9942);

(statearr_10015_10077[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (27))){
var state_10012__$1 = state_10012;
var statearr_10016_10078 = state_10012__$1;
(statearr_10016_10078[(2)] = null);

(statearr_10016_10078[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (1))){
var inst_9918 = (state_10012[(8)]);
var inst_9918__$1 = calc_state.call(null);
var inst_9920 = (inst_9918__$1 == null);
var inst_9921 = cljs.core.not.call(null,inst_9920);
var state_10012__$1 = (function (){var statearr_10017 = state_10012;
(statearr_10017[(8)] = inst_9918__$1);

return statearr_10017;
})();
if(inst_9921){
var statearr_10018_10079 = state_10012__$1;
(statearr_10018_10079[(1)] = (2));

} else {
var statearr_10019_10080 = state_10012__$1;
(statearr_10019_10080[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (24))){
var inst_9972 = (state_10012[(9)]);
var inst_9986 = (state_10012[(10)]);
var inst_9965 = (state_10012[(11)]);
var inst_9986__$1 = inst_9965.call(null,inst_9972);
var state_10012__$1 = (function (){var statearr_10020 = state_10012;
(statearr_10020[(10)] = inst_9986__$1);

return statearr_10020;
})();
if(cljs.core.truth_(inst_9986__$1)){
var statearr_10021_10081 = state_10012__$1;
(statearr_10021_10081[(1)] = (29));

} else {
var statearr_10022_10082 = state_10012__$1;
(statearr_10022_10082[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (4))){
var inst_9933 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
if(cljs.core.truth_(inst_9933)){
var statearr_10023_10083 = state_10012__$1;
(statearr_10023_10083[(1)] = (8));

} else {
var statearr_10024_10084 = state_10012__$1;
(statearr_10024_10084[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (15))){
var inst_9959 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
if(cljs.core.truth_(inst_9959)){
var statearr_10025_10085 = state_10012__$1;
(statearr_10025_10085[(1)] = (19));

} else {
var statearr_10026_10086 = state_10012__$1;
(statearr_10026_10086[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (21))){
var inst_9964 = (state_10012[(12)]);
var inst_9964__$1 = (state_10012[(2)]);
var inst_9965 = cljs.core.get.call(null,inst_9964__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9966 = cljs.core.get.call(null,inst_9964__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9967 = cljs.core.get.call(null,inst_9964__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_10012__$1 = (function (){var statearr_10027 = state_10012;
(statearr_10027[(13)] = inst_9966);

(statearr_10027[(12)] = inst_9964__$1);

(statearr_10027[(11)] = inst_9965);

return statearr_10027;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_10012__$1,(22),inst_9967);
} else {
if((state_val_10013 === (31))){
var inst_9994 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
if(cljs.core.truth_(inst_9994)){
var statearr_10028_10087 = state_10012__$1;
(statearr_10028_10087[(1)] = (32));

} else {
var statearr_10029_10088 = state_10012__$1;
(statearr_10029_10088[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (32))){
var inst_9971 = (state_10012[(14)]);
var state_10012__$1 = state_10012;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10012__$1,(35),out,inst_9971);
} else {
if((state_val_10013 === (33))){
var inst_9964 = (state_10012[(12)]);
var inst_9942 = inst_9964;
var state_10012__$1 = (function (){var statearr_10030 = state_10012;
(statearr_10030[(7)] = inst_9942);

return statearr_10030;
})();
var statearr_10031_10089 = state_10012__$1;
(statearr_10031_10089[(2)] = null);

(statearr_10031_10089[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (13))){
var inst_9942 = (state_10012[(7)]);
var inst_9949 = inst_9942.cljs$lang$protocol_mask$partition0$;
var inst_9950 = (inst_9949 & (64));
var inst_9951 = inst_9942.cljs$core$ISeq$;
var inst_9952 = (inst_9950) || (inst_9951);
var state_10012__$1 = state_10012;
if(cljs.core.truth_(inst_9952)){
var statearr_10032_10090 = state_10012__$1;
(statearr_10032_10090[(1)] = (16));

} else {
var statearr_10033_10091 = state_10012__$1;
(statearr_10033_10091[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (22))){
var inst_9972 = (state_10012[(9)]);
var inst_9971 = (state_10012[(14)]);
var inst_9970 = (state_10012[(2)]);
var inst_9971__$1 = cljs.core.nth.call(null,inst_9970,(0),null);
var inst_9972__$1 = cljs.core.nth.call(null,inst_9970,(1),null);
var inst_9973 = (inst_9971__$1 == null);
var inst_9974 = cljs.core._EQ_.call(null,inst_9972__$1,change);
var inst_9975 = (inst_9973) || (inst_9974);
var state_10012__$1 = (function (){var statearr_10034 = state_10012;
(statearr_10034[(9)] = inst_9972__$1);

(statearr_10034[(14)] = inst_9971__$1);

return statearr_10034;
})();
if(cljs.core.truth_(inst_9975)){
var statearr_10035_10092 = state_10012__$1;
(statearr_10035_10092[(1)] = (23));

} else {
var statearr_10036_10093 = state_10012__$1;
(statearr_10036_10093[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (36))){
var inst_9964 = (state_10012[(12)]);
var inst_9942 = inst_9964;
var state_10012__$1 = (function (){var statearr_10037 = state_10012;
(statearr_10037[(7)] = inst_9942);

return statearr_10037;
})();
var statearr_10038_10094 = state_10012__$1;
(statearr_10038_10094[(2)] = null);

(statearr_10038_10094[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (29))){
var inst_9986 = (state_10012[(10)]);
var state_10012__$1 = state_10012;
var statearr_10039_10095 = state_10012__$1;
(statearr_10039_10095[(2)] = inst_9986);

(statearr_10039_10095[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (6))){
var state_10012__$1 = state_10012;
var statearr_10040_10096 = state_10012__$1;
(statearr_10040_10096[(2)] = false);

(statearr_10040_10096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (28))){
var inst_9982 = (state_10012[(2)]);
var inst_9983 = calc_state.call(null);
var inst_9942 = inst_9983;
var state_10012__$1 = (function (){var statearr_10041 = state_10012;
(statearr_10041[(7)] = inst_9942);

(statearr_10041[(15)] = inst_9982);

return statearr_10041;
})();
var statearr_10042_10097 = state_10012__$1;
(statearr_10042_10097[(2)] = null);

(statearr_10042_10097[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (25))){
var inst_10008 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
var statearr_10043_10098 = state_10012__$1;
(statearr_10043_10098[(2)] = inst_10008);

(statearr_10043_10098[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (34))){
var inst_10006 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
var statearr_10044_10099 = state_10012__$1;
(statearr_10044_10099[(2)] = inst_10006);

(statearr_10044_10099[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (17))){
var state_10012__$1 = state_10012;
var statearr_10045_10100 = state_10012__$1;
(statearr_10045_10100[(2)] = false);

(statearr_10045_10100[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (3))){
var state_10012__$1 = state_10012;
var statearr_10046_10101 = state_10012__$1;
(statearr_10046_10101[(2)] = false);

(statearr_10046_10101[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (12))){
var inst_10010 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10012__$1,inst_10010);
} else {
if((state_val_10013 === (2))){
var inst_9918 = (state_10012[(8)]);
var inst_9923 = inst_9918.cljs$lang$protocol_mask$partition0$;
var inst_9924 = (inst_9923 & (64));
var inst_9925 = inst_9918.cljs$core$ISeq$;
var inst_9926 = (inst_9924) || (inst_9925);
var state_10012__$1 = state_10012;
if(cljs.core.truth_(inst_9926)){
var statearr_10047_10102 = state_10012__$1;
(statearr_10047_10102[(1)] = (5));

} else {
var statearr_10048_10103 = state_10012__$1;
(statearr_10048_10103[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (23))){
var inst_9971 = (state_10012[(14)]);
var inst_9977 = (inst_9971 == null);
var state_10012__$1 = state_10012;
if(cljs.core.truth_(inst_9977)){
var statearr_10049_10104 = state_10012__$1;
(statearr_10049_10104[(1)] = (26));

} else {
var statearr_10050_10105 = state_10012__$1;
(statearr_10050_10105[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (35))){
var inst_9997 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
if(cljs.core.truth_(inst_9997)){
var statearr_10051_10106 = state_10012__$1;
(statearr_10051_10106[(1)] = (36));

} else {
var statearr_10052_10107 = state_10012__$1;
(statearr_10052_10107[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (19))){
var inst_9942 = (state_10012[(7)]);
var inst_9961 = cljs.core.apply.call(null,cljs.core.hash_map,inst_9942);
var state_10012__$1 = state_10012;
var statearr_10053_10108 = state_10012__$1;
(statearr_10053_10108[(2)] = inst_9961);

(statearr_10053_10108[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (11))){
var inst_9942 = (state_10012[(7)]);
var inst_9946 = (inst_9942 == null);
var inst_9947 = cljs.core.not.call(null,inst_9946);
var state_10012__$1 = state_10012;
if(inst_9947){
var statearr_10054_10109 = state_10012__$1;
(statearr_10054_10109[(1)] = (13));

} else {
var statearr_10055_10110 = state_10012__$1;
(statearr_10055_10110[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (9))){
var inst_9918 = (state_10012[(8)]);
var state_10012__$1 = state_10012;
var statearr_10056_10111 = state_10012__$1;
(statearr_10056_10111[(2)] = inst_9918);

(statearr_10056_10111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (5))){
var state_10012__$1 = state_10012;
var statearr_10057_10112 = state_10012__$1;
(statearr_10057_10112[(2)] = true);

(statearr_10057_10112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (14))){
var state_10012__$1 = state_10012;
var statearr_10058_10113 = state_10012__$1;
(statearr_10058_10113[(2)] = false);

(statearr_10058_10113[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (26))){
var inst_9972 = (state_10012[(9)]);
var inst_9979 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_9972);
var state_10012__$1 = state_10012;
var statearr_10059_10114 = state_10012__$1;
(statearr_10059_10114[(2)] = inst_9979);

(statearr_10059_10114[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (16))){
var state_10012__$1 = state_10012;
var statearr_10060_10115 = state_10012__$1;
(statearr_10060_10115[(2)] = true);

(statearr_10060_10115[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (38))){
var inst_10002 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
var statearr_10061_10116 = state_10012__$1;
(statearr_10061_10116[(2)] = inst_10002);

(statearr_10061_10116[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (30))){
var inst_9966 = (state_10012[(13)]);
var inst_9972 = (state_10012[(9)]);
var inst_9965 = (state_10012[(11)]);
var inst_9989 = cljs.core.empty_QMARK_.call(null,inst_9965);
var inst_9990 = inst_9966.call(null,inst_9972);
var inst_9991 = cljs.core.not.call(null,inst_9990);
var inst_9992 = (inst_9989) && (inst_9991);
var state_10012__$1 = state_10012;
var statearr_10062_10117 = state_10012__$1;
(statearr_10062_10117[(2)] = inst_9992);

(statearr_10062_10117[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (10))){
var inst_9918 = (state_10012[(8)]);
var inst_9938 = (state_10012[(2)]);
var inst_9939 = cljs.core.get.call(null,inst_9938,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9940 = cljs.core.get.call(null,inst_9938,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9941 = cljs.core.get.call(null,inst_9938,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_9942 = inst_9918;
var state_10012__$1 = (function (){var statearr_10063 = state_10012;
(statearr_10063[(7)] = inst_9942);

(statearr_10063[(16)] = inst_9941);

(statearr_10063[(17)] = inst_9939);

(statearr_10063[(18)] = inst_9940);

return statearr_10063;
})();
var statearr_10064_10118 = state_10012__$1;
(statearr_10064_10118[(2)] = null);

(statearr_10064_10118[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (18))){
var inst_9956 = (state_10012[(2)]);
var state_10012__$1 = state_10012;
var statearr_10065_10119 = state_10012__$1;
(statearr_10065_10119[(2)] = inst_9956);

(statearr_10065_10119[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (37))){
var state_10012__$1 = state_10012;
var statearr_10066_10120 = state_10012__$1;
(statearr_10066_10120[(2)] = null);

(statearr_10066_10120[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10013 === (8))){
var inst_9918 = (state_10012[(8)]);
var inst_9935 = cljs.core.apply.call(null,cljs.core.hash_map,inst_9918);
var state_10012__$1 = state_10012;
var statearr_10067_10121 = state_10012__$1;
(statearr_10067_10121[(2)] = inst_9935);

(statearr_10067_10121[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___10075,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___10075,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_10071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10071[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_10071[(1)] = (1));

return statearr_10071;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_10012){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e10072){if((e10072 instanceof Object)){
var ex__8254__auto__ = e10072;
var statearr_10073_10122 = state_10012;
(statearr_10073_10122[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10012);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10072;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10123 = state_10012;
state_10012 = G__10123;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_10012){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_10012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___10075,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_10074 = f__8363__auto__.call(null);
(statearr_10074[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___10075);

return statearr_10074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___10075,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args10124 = [];
var len__5726__auto___10127 = arguments.length;
var i__5727__auto___10128 = (0);
while(true){
if((i__5727__auto___10128 < len__5726__auto___10127)){
args10124.push((arguments[i__5727__auto___10128]));

var G__10129 = (i__5727__auto___10128 + (1));
i__5727__auto___10128 = G__10129;
continue;
} else {
}
break;
}

var G__10126 = args10124.length;
switch (G__10126) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10124.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args10132 = [];
var len__5726__auto___10257 = arguments.length;
var i__5727__auto___10258 = (0);
while(true){
if((i__5727__auto___10258 < len__5726__auto___10257)){
args10132.push((arguments[i__5727__auto___10258]));

var G__10259 = (i__5727__auto___10258 + (1));
i__5727__auto___10258 = G__10259;
continue;
} else {
}
break;
}

var G__10134 = args10132.length;
switch (G__10134) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10132.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__10131_SHARP_){
if(cljs.core.truth_(p1__10131_SHARP_.call(null,topic))){
return p1__10131_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__10131_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async10135 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10135 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta10136){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta10136 = meta10136;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_10137,meta10136__$1){
var self__ = this;
var _10137__$1 = this;
return (new cljs.core.async.t_cljs$core$async10135(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta10136__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_10137){
var self__ = this;
var _10137__$1 = this;
return self__.meta10136;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10135.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10135.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta10136","meta10136",-1551816245,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async10135.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10135.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10135";

cljs.core.async.t_cljs$core$async10135.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10135");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async10135 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async10135(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta10136){
return (new cljs.core.async.t_cljs$core$async10135(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta10136));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async10135(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___10261 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___10261,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___10261,mults,ensure_mult,p){
return (function (state_10209){
var state_val_10210 = (state_10209[(1)]);
if((state_val_10210 === (7))){
var inst_10205 = (state_10209[(2)]);
var state_10209__$1 = state_10209;
var statearr_10211_10262 = state_10209__$1;
(statearr_10211_10262[(2)] = inst_10205);

(statearr_10211_10262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (20))){
var state_10209__$1 = state_10209;
var statearr_10212_10263 = state_10209__$1;
(statearr_10212_10263[(2)] = null);

(statearr_10212_10263[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (1))){
var state_10209__$1 = state_10209;
var statearr_10213_10264 = state_10209__$1;
(statearr_10213_10264[(2)] = null);

(statearr_10213_10264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (24))){
var inst_10188 = (state_10209[(7)]);
var inst_10197 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_10188);
var state_10209__$1 = state_10209;
var statearr_10214_10265 = state_10209__$1;
(statearr_10214_10265[(2)] = inst_10197);

(statearr_10214_10265[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (4))){
var inst_10140 = (state_10209[(8)]);
var inst_10140__$1 = (state_10209[(2)]);
var inst_10141 = (inst_10140__$1 == null);
var state_10209__$1 = (function (){var statearr_10215 = state_10209;
(statearr_10215[(8)] = inst_10140__$1);

return statearr_10215;
})();
if(cljs.core.truth_(inst_10141)){
var statearr_10216_10266 = state_10209__$1;
(statearr_10216_10266[(1)] = (5));

} else {
var statearr_10217_10267 = state_10209__$1;
(statearr_10217_10267[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (15))){
var inst_10182 = (state_10209[(2)]);
var state_10209__$1 = state_10209;
var statearr_10218_10268 = state_10209__$1;
(statearr_10218_10268[(2)] = inst_10182);

(statearr_10218_10268[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (21))){
var inst_10202 = (state_10209[(2)]);
var state_10209__$1 = (function (){var statearr_10219 = state_10209;
(statearr_10219[(9)] = inst_10202);

return statearr_10219;
})();
var statearr_10220_10269 = state_10209__$1;
(statearr_10220_10269[(2)] = null);

(statearr_10220_10269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (13))){
var inst_10164 = (state_10209[(10)]);
var inst_10166 = cljs.core.chunked_seq_QMARK_.call(null,inst_10164);
var state_10209__$1 = state_10209;
if(inst_10166){
var statearr_10221_10270 = state_10209__$1;
(statearr_10221_10270[(1)] = (16));

} else {
var statearr_10222_10271 = state_10209__$1;
(statearr_10222_10271[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (22))){
var inst_10194 = (state_10209[(2)]);
var state_10209__$1 = state_10209;
if(cljs.core.truth_(inst_10194)){
var statearr_10223_10272 = state_10209__$1;
(statearr_10223_10272[(1)] = (23));

} else {
var statearr_10224_10273 = state_10209__$1;
(statearr_10224_10273[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (6))){
var inst_10140 = (state_10209[(8)]);
var inst_10190 = (state_10209[(11)]);
var inst_10188 = (state_10209[(7)]);
var inst_10188__$1 = topic_fn.call(null,inst_10140);
var inst_10189 = cljs.core.deref.call(null,mults);
var inst_10190__$1 = cljs.core.get.call(null,inst_10189,inst_10188__$1);
var state_10209__$1 = (function (){var statearr_10225 = state_10209;
(statearr_10225[(11)] = inst_10190__$1);

(statearr_10225[(7)] = inst_10188__$1);

return statearr_10225;
})();
if(cljs.core.truth_(inst_10190__$1)){
var statearr_10226_10274 = state_10209__$1;
(statearr_10226_10274[(1)] = (19));

} else {
var statearr_10227_10275 = state_10209__$1;
(statearr_10227_10275[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (25))){
var inst_10199 = (state_10209[(2)]);
var state_10209__$1 = state_10209;
var statearr_10228_10276 = state_10209__$1;
(statearr_10228_10276[(2)] = inst_10199);

(statearr_10228_10276[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (17))){
var inst_10164 = (state_10209[(10)]);
var inst_10173 = cljs.core.first.call(null,inst_10164);
var inst_10174 = cljs.core.async.muxch_STAR_.call(null,inst_10173);
var inst_10175 = cljs.core.async.close_BANG_.call(null,inst_10174);
var inst_10176 = cljs.core.next.call(null,inst_10164);
var inst_10150 = inst_10176;
var inst_10151 = null;
var inst_10152 = (0);
var inst_10153 = (0);
var state_10209__$1 = (function (){var statearr_10229 = state_10209;
(statearr_10229[(12)] = inst_10150);

(statearr_10229[(13)] = inst_10175);

(statearr_10229[(14)] = inst_10152);

(statearr_10229[(15)] = inst_10151);

(statearr_10229[(16)] = inst_10153);

return statearr_10229;
})();
var statearr_10230_10277 = state_10209__$1;
(statearr_10230_10277[(2)] = null);

(statearr_10230_10277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (3))){
var inst_10207 = (state_10209[(2)]);
var state_10209__$1 = state_10209;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10209__$1,inst_10207);
} else {
if((state_val_10210 === (12))){
var inst_10184 = (state_10209[(2)]);
var state_10209__$1 = state_10209;
var statearr_10231_10278 = state_10209__$1;
(statearr_10231_10278[(2)] = inst_10184);

(statearr_10231_10278[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (2))){
var state_10209__$1 = state_10209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10209__$1,(4),ch);
} else {
if((state_val_10210 === (23))){
var state_10209__$1 = state_10209;
var statearr_10232_10279 = state_10209__$1;
(statearr_10232_10279[(2)] = null);

(statearr_10232_10279[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (19))){
var inst_10140 = (state_10209[(8)]);
var inst_10190 = (state_10209[(11)]);
var inst_10192 = cljs.core.async.muxch_STAR_.call(null,inst_10190);
var state_10209__$1 = state_10209;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10209__$1,(22),inst_10192,inst_10140);
} else {
if((state_val_10210 === (11))){
var inst_10150 = (state_10209[(12)]);
var inst_10164 = (state_10209[(10)]);
var inst_10164__$1 = cljs.core.seq.call(null,inst_10150);
var state_10209__$1 = (function (){var statearr_10233 = state_10209;
(statearr_10233[(10)] = inst_10164__$1);

return statearr_10233;
})();
if(inst_10164__$1){
var statearr_10234_10280 = state_10209__$1;
(statearr_10234_10280[(1)] = (13));

} else {
var statearr_10235_10281 = state_10209__$1;
(statearr_10235_10281[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (9))){
var inst_10186 = (state_10209[(2)]);
var state_10209__$1 = state_10209;
var statearr_10236_10282 = state_10209__$1;
(statearr_10236_10282[(2)] = inst_10186);

(statearr_10236_10282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (5))){
var inst_10147 = cljs.core.deref.call(null,mults);
var inst_10148 = cljs.core.vals.call(null,inst_10147);
var inst_10149 = cljs.core.seq.call(null,inst_10148);
var inst_10150 = inst_10149;
var inst_10151 = null;
var inst_10152 = (0);
var inst_10153 = (0);
var state_10209__$1 = (function (){var statearr_10237 = state_10209;
(statearr_10237[(12)] = inst_10150);

(statearr_10237[(14)] = inst_10152);

(statearr_10237[(15)] = inst_10151);

(statearr_10237[(16)] = inst_10153);

return statearr_10237;
})();
var statearr_10238_10283 = state_10209__$1;
(statearr_10238_10283[(2)] = null);

(statearr_10238_10283[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (14))){
var state_10209__$1 = state_10209;
var statearr_10242_10284 = state_10209__$1;
(statearr_10242_10284[(2)] = null);

(statearr_10242_10284[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (16))){
var inst_10164 = (state_10209[(10)]);
var inst_10168 = cljs.core.chunk_first.call(null,inst_10164);
var inst_10169 = cljs.core.chunk_rest.call(null,inst_10164);
var inst_10170 = cljs.core.count.call(null,inst_10168);
var inst_10150 = inst_10169;
var inst_10151 = inst_10168;
var inst_10152 = inst_10170;
var inst_10153 = (0);
var state_10209__$1 = (function (){var statearr_10243 = state_10209;
(statearr_10243[(12)] = inst_10150);

(statearr_10243[(14)] = inst_10152);

(statearr_10243[(15)] = inst_10151);

(statearr_10243[(16)] = inst_10153);

return statearr_10243;
})();
var statearr_10244_10285 = state_10209__$1;
(statearr_10244_10285[(2)] = null);

(statearr_10244_10285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (10))){
var inst_10150 = (state_10209[(12)]);
var inst_10152 = (state_10209[(14)]);
var inst_10151 = (state_10209[(15)]);
var inst_10153 = (state_10209[(16)]);
var inst_10158 = cljs.core._nth.call(null,inst_10151,inst_10153);
var inst_10159 = cljs.core.async.muxch_STAR_.call(null,inst_10158);
var inst_10160 = cljs.core.async.close_BANG_.call(null,inst_10159);
var inst_10161 = (inst_10153 + (1));
var tmp10239 = inst_10150;
var tmp10240 = inst_10152;
var tmp10241 = inst_10151;
var inst_10150__$1 = tmp10239;
var inst_10151__$1 = tmp10241;
var inst_10152__$1 = tmp10240;
var inst_10153__$1 = inst_10161;
var state_10209__$1 = (function (){var statearr_10245 = state_10209;
(statearr_10245[(12)] = inst_10150__$1);

(statearr_10245[(14)] = inst_10152__$1);

(statearr_10245[(15)] = inst_10151__$1);

(statearr_10245[(16)] = inst_10153__$1);

(statearr_10245[(17)] = inst_10160);

return statearr_10245;
})();
var statearr_10246_10286 = state_10209__$1;
(statearr_10246_10286[(2)] = null);

(statearr_10246_10286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (18))){
var inst_10179 = (state_10209[(2)]);
var state_10209__$1 = state_10209;
var statearr_10247_10287 = state_10209__$1;
(statearr_10247_10287[(2)] = inst_10179);

(statearr_10247_10287[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10210 === (8))){
var inst_10152 = (state_10209[(14)]);
var inst_10153 = (state_10209[(16)]);
var inst_10155 = (inst_10153 < inst_10152);
var inst_10156 = inst_10155;
var state_10209__$1 = state_10209;
if(cljs.core.truth_(inst_10156)){
var statearr_10248_10288 = state_10209__$1;
(statearr_10248_10288[(1)] = (10));

} else {
var statearr_10249_10289 = state_10209__$1;
(statearr_10249_10289[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___10261,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___10261,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_10253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10253[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_10253[(1)] = (1));

return statearr_10253;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_10209){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e10254){if((e10254 instanceof Object)){
var ex__8254__auto__ = e10254;
var statearr_10255_10290 = state_10209;
(statearr_10255_10290[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10209);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10254;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10291 = state_10209;
state_10209 = G__10291;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_10209){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_10209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___10261,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_10256 = f__8363__auto__.call(null);
(statearr_10256[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___10261);

return statearr_10256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___10261,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args10292 = [];
var len__5726__auto___10295 = arguments.length;
var i__5727__auto___10296 = (0);
while(true){
if((i__5727__auto___10296 < len__5726__auto___10295)){
args10292.push((arguments[i__5727__auto___10296]));

var G__10297 = (i__5727__auto___10296 + (1));
i__5727__auto___10296 = G__10297;
continue;
} else {
}
break;
}

var G__10294 = args10292.length;
switch (G__10294) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10292.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args10299 = [];
var len__5726__auto___10302 = arguments.length;
var i__5727__auto___10303 = (0);
while(true){
if((i__5727__auto___10303 < len__5726__auto___10302)){
args10299.push((arguments[i__5727__auto___10303]));

var G__10304 = (i__5727__auto___10303 + (1));
i__5727__auto___10303 = G__10304;
continue;
} else {
}
break;
}

var G__10301 = args10299.length;
switch (G__10301) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10299.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args10306 = [];
var len__5726__auto___10377 = arguments.length;
var i__5727__auto___10378 = (0);
while(true){
if((i__5727__auto___10378 < len__5726__auto___10377)){
args10306.push((arguments[i__5727__auto___10378]));

var G__10379 = (i__5727__auto___10378 + (1));
i__5727__auto___10378 = G__10379;
continue;
} else {
}
break;
}

var G__10308 = args10306.length;
switch (G__10308) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10306.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___10381 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___10381,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___10381,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_10347){
var state_val_10348 = (state_10347[(1)]);
if((state_val_10348 === (7))){
var state_10347__$1 = state_10347;
var statearr_10349_10382 = state_10347__$1;
(statearr_10349_10382[(2)] = null);

(statearr_10349_10382[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (1))){
var state_10347__$1 = state_10347;
var statearr_10350_10383 = state_10347__$1;
(statearr_10350_10383[(2)] = null);

(statearr_10350_10383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (4))){
var inst_10311 = (state_10347[(7)]);
var inst_10313 = (inst_10311 < cnt);
var state_10347__$1 = state_10347;
if(cljs.core.truth_(inst_10313)){
var statearr_10351_10384 = state_10347__$1;
(statearr_10351_10384[(1)] = (6));

} else {
var statearr_10352_10385 = state_10347__$1;
(statearr_10352_10385[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (15))){
var inst_10343 = (state_10347[(2)]);
var state_10347__$1 = state_10347;
var statearr_10353_10386 = state_10347__$1;
(statearr_10353_10386[(2)] = inst_10343);

(statearr_10353_10386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (13))){
var inst_10336 = cljs.core.async.close_BANG_.call(null,out);
var state_10347__$1 = state_10347;
var statearr_10354_10387 = state_10347__$1;
(statearr_10354_10387[(2)] = inst_10336);

(statearr_10354_10387[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (6))){
var state_10347__$1 = state_10347;
var statearr_10355_10388 = state_10347__$1;
(statearr_10355_10388[(2)] = null);

(statearr_10355_10388[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (3))){
var inst_10345 = (state_10347[(2)]);
var state_10347__$1 = state_10347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10347__$1,inst_10345);
} else {
if((state_val_10348 === (12))){
var inst_10333 = (state_10347[(8)]);
var inst_10333__$1 = (state_10347[(2)]);
var inst_10334 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_10333__$1);
var state_10347__$1 = (function (){var statearr_10356 = state_10347;
(statearr_10356[(8)] = inst_10333__$1);

return statearr_10356;
})();
if(cljs.core.truth_(inst_10334)){
var statearr_10357_10389 = state_10347__$1;
(statearr_10357_10389[(1)] = (13));

} else {
var statearr_10358_10390 = state_10347__$1;
(statearr_10358_10390[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (2))){
var inst_10310 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_10311 = (0);
var state_10347__$1 = (function (){var statearr_10359 = state_10347;
(statearr_10359[(9)] = inst_10310);

(statearr_10359[(7)] = inst_10311);

return statearr_10359;
})();
var statearr_10360_10391 = state_10347__$1;
(statearr_10360_10391[(2)] = null);

(statearr_10360_10391[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (11))){
var inst_10311 = (state_10347[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_10347,(10),Object,null,(9));
var inst_10320 = chs__$1.call(null,inst_10311);
var inst_10321 = done.call(null,inst_10311);
var inst_10322 = cljs.core.async.take_BANG_.call(null,inst_10320,inst_10321);
var state_10347__$1 = state_10347;
var statearr_10361_10392 = state_10347__$1;
(statearr_10361_10392[(2)] = inst_10322);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10347__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (9))){
var inst_10311 = (state_10347[(7)]);
var inst_10324 = (state_10347[(2)]);
var inst_10325 = (inst_10311 + (1));
var inst_10311__$1 = inst_10325;
var state_10347__$1 = (function (){var statearr_10362 = state_10347;
(statearr_10362[(7)] = inst_10311__$1);

(statearr_10362[(10)] = inst_10324);

return statearr_10362;
})();
var statearr_10363_10393 = state_10347__$1;
(statearr_10363_10393[(2)] = null);

(statearr_10363_10393[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (5))){
var inst_10331 = (state_10347[(2)]);
var state_10347__$1 = (function (){var statearr_10364 = state_10347;
(statearr_10364[(11)] = inst_10331);

return statearr_10364;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10347__$1,(12),dchan);
} else {
if((state_val_10348 === (14))){
var inst_10333 = (state_10347[(8)]);
var inst_10338 = cljs.core.apply.call(null,f,inst_10333);
var state_10347__$1 = state_10347;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10347__$1,(16),out,inst_10338);
} else {
if((state_val_10348 === (16))){
var inst_10340 = (state_10347[(2)]);
var state_10347__$1 = (function (){var statearr_10365 = state_10347;
(statearr_10365[(12)] = inst_10340);

return statearr_10365;
})();
var statearr_10366_10394 = state_10347__$1;
(statearr_10366_10394[(2)] = null);

(statearr_10366_10394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (10))){
var inst_10315 = (state_10347[(2)]);
var inst_10316 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_10347__$1 = (function (){var statearr_10367 = state_10347;
(statearr_10367[(13)] = inst_10315);

return statearr_10367;
})();
var statearr_10368_10395 = state_10347__$1;
(statearr_10368_10395[(2)] = inst_10316);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10347__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10348 === (8))){
var inst_10329 = (state_10347[(2)]);
var state_10347__$1 = state_10347;
var statearr_10369_10396 = state_10347__$1;
(statearr_10369_10396[(2)] = inst_10329);

(statearr_10369_10396[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___10381,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___10381,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_10373 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10373[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_10373[(1)] = (1));

return statearr_10373;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_10347){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e10374){if((e10374 instanceof Object)){
var ex__8254__auto__ = e10374;
var statearr_10375_10397 = state_10347;
(statearr_10375_10397[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10347);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10374;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10398 = state_10347;
state_10347 = G__10398;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_10347){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_10347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___10381,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_10376 = f__8363__auto__.call(null);
(statearr_10376[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___10381);

return statearr_10376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___10381,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args10400 = [];
var len__5726__auto___10456 = arguments.length;
var i__5727__auto___10457 = (0);
while(true){
if((i__5727__auto___10457 < len__5726__auto___10456)){
args10400.push((arguments[i__5727__auto___10457]));

var G__10458 = (i__5727__auto___10457 + (1));
i__5727__auto___10457 = G__10458;
continue;
} else {
}
break;
}

var G__10402 = args10400.length;
switch (G__10402) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10400.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___10460 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___10460,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___10460,out){
return (function (state_10432){
var state_val_10433 = (state_10432[(1)]);
if((state_val_10433 === (7))){
var inst_10412 = (state_10432[(7)]);
var inst_10411 = (state_10432[(8)]);
var inst_10411__$1 = (state_10432[(2)]);
var inst_10412__$1 = cljs.core.nth.call(null,inst_10411__$1,(0),null);
var inst_10413 = cljs.core.nth.call(null,inst_10411__$1,(1),null);
var inst_10414 = (inst_10412__$1 == null);
var state_10432__$1 = (function (){var statearr_10434 = state_10432;
(statearr_10434[(7)] = inst_10412__$1);

(statearr_10434[(9)] = inst_10413);

(statearr_10434[(8)] = inst_10411__$1);

return statearr_10434;
})();
if(cljs.core.truth_(inst_10414)){
var statearr_10435_10461 = state_10432__$1;
(statearr_10435_10461[(1)] = (8));

} else {
var statearr_10436_10462 = state_10432__$1;
(statearr_10436_10462[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (1))){
var inst_10403 = cljs.core.vec.call(null,chs);
var inst_10404 = inst_10403;
var state_10432__$1 = (function (){var statearr_10437 = state_10432;
(statearr_10437[(10)] = inst_10404);

return statearr_10437;
})();
var statearr_10438_10463 = state_10432__$1;
(statearr_10438_10463[(2)] = null);

(statearr_10438_10463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (4))){
var inst_10404 = (state_10432[(10)]);
var state_10432__$1 = state_10432;
return cljs.core.async.ioc_alts_BANG_.call(null,state_10432__$1,(7),inst_10404);
} else {
if((state_val_10433 === (6))){
var inst_10428 = (state_10432[(2)]);
var state_10432__$1 = state_10432;
var statearr_10439_10464 = state_10432__$1;
(statearr_10439_10464[(2)] = inst_10428);

(statearr_10439_10464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (3))){
var inst_10430 = (state_10432[(2)]);
var state_10432__$1 = state_10432;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10432__$1,inst_10430);
} else {
if((state_val_10433 === (2))){
var inst_10404 = (state_10432[(10)]);
var inst_10406 = cljs.core.count.call(null,inst_10404);
var inst_10407 = (inst_10406 > (0));
var state_10432__$1 = state_10432;
if(cljs.core.truth_(inst_10407)){
var statearr_10441_10465 = state_10432__$1;
(statearr_10441_10465[(1)] = (4));

} else {
var statearr_10442_10466 = state_10432__$1;
(statearr_10442_10466[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (11))){
var inst_10404 = (state_10432[(10)]);
var inst_10421 = (state_10432[(2)]);
var tmp10440 = inst_10404;
var inst_10404__$1 = tmp10440;
var state_10432__$1 = (function (){var statearr_10443 = state_10432;
(statearr_10443[(10)] = inst_10404__$1);

(statearr_10443[(11)] = inst_10421);

return statearr_10443;
})();
var statearr_10444_10467 = state_10432__$1;
(statearr_10444_10467[(2)] = null);

(statearr_10444_10467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (9))){
var inst_10412 = (state_10432[(7)]);
var state_10432__$1 = state_10432;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10432__$1,(11),out,inst_10412);
} else {
if((state_val_10433 === (5))){
var inst_10426 = cljs.core.async.close_BANG_.call(null,out);
var state_10432__$1 = state_10432;
var statearr_10445_10468 = state_10432__$1;
(statearr_10445_10468[(2)] = inst_10426);

(statearr_10445_10468[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (10))){
var inst_10424 = (state_10432[(2)]);
var state_10432__$1 = state_10432;
var statearr_10446_10469 = state_10432__$1;
(statearr_10446_10469[(2)] = inst_10424);

(statearr_10446_10469[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10433 === (8))){
var inst_10404 = (state_10432[(10)]);
var inst_10412 = (state_10432[(7)]);
var inst_10413 = (state_10432[(9)]);
var inst_10411 = (state_10432[(8)]);
var inst_10416 = (function (){var cs = inst_10404;
var vec__10409 = inst_10411;
var v = inst_10412;
var c = inst_10413;
return ((function (cs,vec__10409,v,c,inst_10404,inst_10412,inst_10413,inst_10411,state_val_10433,c__8362__auto___10460,out){
return (function (p1__10399_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__10399_SHARP_);
});
;})(cs,vec__10409,v,c,inst_10404,inst_10412,inst_10413,inst_10411,state_val_10433,c__8362__auto___10460,out))
})();
var inst_10417 = cljs.core.filterv.call(null,inst_10416,inst_10404);
var inst_10404__$1 = inst_10417;
var state_10432__$1 = (function (){var statearr_10447 = state_10432;
(statearr_10447[(10)] = inst_10404__$1);

return statearr_10447;
})();
var statearr_10448_10470 = state_10432__$1;
(statearr_10448_10470[(2)] = null);

(statearr_10448_10470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___10460,out))
;
return ((function (switch__8250__auto__,c__8362__auto___10460,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_10452 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10452[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_10452[(1)] = (1));

return statearr_10452;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_10432){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10432);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e10453){if((e10453 instanceof Object)){
var ex__8254__auto__ = e10453;
var statearr_10454_10471 = state_10432;
(statearr_10454_10471[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10432);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10453;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10472 = state_10432;
state_10432 = G__10472;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_10432){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_10432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___10460,out))
})();
var state__8364__auto__ = (function (){var statearr_10455 = f__8363__auto__.call(null);
(statearr_10455[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___10460);

return statearr_10455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___10460,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args10473 = [];
var len__5726__auto___10522 = arguments.length;
var i__5727__auto___10523 = (0);
while(true){
if((i__5727__auto___10523 < len__5726__auto___10522)){
args10473.push((arguments[i__5727__auto___10523]));

var G__10524 = (i__5727__auto___10523 + (1));
i__5727__auto___10523 = G__10524;
continue;
} else {
}
break;
}

var G__10475 = args10473.length;
switch (G__10475) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10473.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___10526 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___10526,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___10526,out){
return (function (state_10499){
var state_val_10500 = (state_10499[(1)]);
if((state_val_10500 === (7))){
var inst_10481 = (state_10499[(7)]);
var inst_10481__$1 = (state_10499[(2)]);
var inst_10482 = (inst_10481__$1 == null);
var inst_10483 = cljs.core.not.call(null,inst_10482);
var state_10499__$1 = (function (){var statearr_10501 = state_10499;
(statearr_10501[(7)] = inst_10481__$1);

return statearr_10501;
})();
if(inst_10483){
var statearr_10502_10527 = state_10499__$1;
(statearr_10502_10527[(1)] = (8));

} else {
var statearr_10503_10528 = state_10499__$1;
(statearr_10503_10528[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10500 === (1))){
var inst_10476 = (0);
var state_10499__$1 = (function (){var statearr_10504 = state_10499;
(statearr_10504[(8)] = inst_10476);

return statearr_10504;
})();
var statearr_10505_10529 = state_10499__$1;
(statearr_10505_10529[(2)] = null);

(statearr_10505_10529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10500 === (4))){
var state_10499__$1 = state_10499;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10499__$1,(7),ch);
} else {
if((state_val_10500 === (6))){
var inst_10494 = (state_10499[(2)]);
var state_10499__$1 = state_10499;
var statearr_10506_10530 = state_10499__$1;
(statearr_10506_10530[(2)] = inst_10494);

(statearr_10506_10530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10500 === (3))){
var inst_10496 = (state_10499[(2)]);
var inst_10497 = cljs.core.async.close_BANG_.call(null,out);
var state_10499__$1 = (function (){var statearr_10507 = state_10499;
(statearr_10507[(9)] = inst_10496);

return statearr_10507;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10499__$1,inst_10497);
} else {
if((state_val_10500 === (2))){
var inst_10476 = (state_10499[(8)]);
var inst_10478 = (inst_10476 < n);
var state_10499__$1 = state_10499;
if(cljs.core.truth_(inst_10478)){
var statearr_10508_10531 = state_10499__$1;
(statearr_10508_10531[(1)] = (4));

} else {
var statearr_10509_10532 = state_10499__$1;
(statearr_10509_10532[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10500 === (11))){
var inst_10476 = (state_10499[(8)]);
var inst_10486 = (state_10499[(2)]);
var inst_10487 = (inst_10476 + (1));
var inst_10476__$1 = inst_10487;
var state_10499__$1 = (function (){var statearr_10510 = state_10499;
(statearr_10510[(8)] = inst_10476__$1);

(statearr_10510[(10)] = inst_10486);

return statearr_10510;
})();
var statearr_10511_10533 = state_10499__$1;
(statearr_10511_10533[(2)] = null);

(statearr_10511_10533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10500 === (9))){
var state_10499__$1 = state_10499;
var statearr_10512_10534 = state_10499__$1;
(statearr_10512_10534[(2)] = null);

(statearr_10512_10534[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10500 === (5))){
var state_10499__$1 = state_10499;
var statearr_10513_10535 = state_10499__$1;
(statearr_10513_10535[(2)] = null);

(statearr_10513_10535[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10500 === (10))){
var inst_10491 = (state_10499[(2)]);
var state_10499__$1 = state_10499;
var statearr_10514_10536 = state_10499__$1;
(statearr_10514_10536[(2)] = inst_10491);

(statearr_10514_10536[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10500 === (8))){
var inst_10481 = (state_10499[(7)]);
var state_10499__$1 = state_10499;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10499__$1,(11),out,inst_10481);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___10526,out))
;
return ((function (switch__8250__auto__,c__8362__auto___10526,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_10518 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10518[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_10518[(1)] = (1));

return statearr_10518;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_10499){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e10519){if((e10519 instanceof Object)){
var ex__8254__auto__ = e10519;
var statearr_10520_10537 = state_10499;
(statearr_10520_10537[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10499);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10519;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10538 = state_10499;
state_10499 = G__10538;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_10499){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_10499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___10526,out))
})();
var state__8364__auto__ = (function (){var statearr_10521 = f__8363__auto__.call(null);
(statearr_10521[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___10526);

return statearr_10521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___10526,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async10546 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10546 = (function (map_LT_,f,ch,meta10547){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta10547 = meta10547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10548,meta10547__$1){
var self__ = this;
var _10548__$1 = this;
return (new cljs.core.async.t_cljs$core$async10546(self__.map_LT_,self__.f,self__.ch,meta10547__$1));
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10548){
var self__ = this;
var _10548__$1 = this;
return self__.meta10547;
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async10549 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10549 = (function (map_LT_,f,ch,meta10547,_,fn1,meta10550){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta10547 = meta10547;
this._ = _;
this.fn1 = fn1;
this.meta10550 = meta10550;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10549.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_10551,meta10550__$1){
var self__ = this;
var _10551__$1 = this;
return (new cljs.core.async.t_cljs$core$async10549(self__.map_LT_,self__.f,self__.ch,self__.meta10547,self__._,self__.fn1,meta10550__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async10549.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_10551){
var self__ = this;
var _10551__$1 = this;
return self__.meta10550;
});})(___$1))
;

cljs.core.async.t_cljs$core$async10549.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async10549.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async10549.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async10549.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__10539_SHARP_){
return f1.call(null,(((p1__10539_SHARP_ == null))?null:self__.f.call(null,p1__10539_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async10549.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10547","meta10547",-331751593,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async10546","cljs.core.async/t_cljs$core$async10546",1508941957,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta10550","meta10550",516440859,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async10549.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10549.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10549";

cljs.core.async.t_cljs$core$async10549.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10549");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async10549 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10549(map_LT___$1,f__$1,ch__$1,meta10547__$1,___$2,fn1__$1,meta10550){
return (new cljs.core.async.t_cljs$core$async10549(map_LT___$1,f__$1,ch__$1,meta10547__$1,___$2,fn1__$1,meta10550));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async10549(self__.map_LT_,self__.f,self__.ch,self__.meta10547,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async10546.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10547","meta10547",-331751593,null)], null);
});

cljs.core.async.t_cljs$core$async10546.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10546.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10546";

cljs.core.async.t_cljs$core$async10546.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10546");
});

cljs.core.async.__GT_t_cljs$core$async10546 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10546(map_LT___$1,f__$1,ch__$1,meta10547){
return (new cljs.core.async.t_cljs$core$async10546(map_LT___$1,f__$1,ch__$1,meta10547));
});

}

return (new cljs.core.async.t_cljs$core$async10546(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async10555 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10555 = (function (map_GT_,f,ch,meta10556){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta10556 = meta10556;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10555.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10557,meta10556__$1){
var self__ = this;
var _10557__$1 = this;
return (new cljs.core.async.t_cljs$core$async10555(self__.map_GT_,self__.f,self__.ch,meta10556__$1));
});

cljs.core.async.t_cljs$core$async10555.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10557){
var self__ = this;
var _10557__$1 = this;
return self__.meta10556;
});

cljs.core.async.t_cljs$core$async10555.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async10555.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10555.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async10555.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async10555.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async10555.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async10555.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10556","meta10556",612532534,null)], null);
});

cljs.core.async.t_cljs$core$async10555.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10555.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10555";

cljs.core.async.t_cljs$core$async10555.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10555");
});

cljs.core.async.__GT_t_cljs$core$async10555 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async10555(map_GT___$1,f__$1,ch__$1,meta10556){
return (new cljs.core.async.t_cljs$core$async10555(map_GT___$1,f__$1,ch__$1,meta10556));
});

}

return (new cljs.core.async.t_cljs$core$async10555(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async10561 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10561 = (function (filter_GT_,p,ch,meta10562){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta10562 = meta10562;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10563,meta10562__$1){
var self__ = this;
var _10563__$1 = this;
return (new cljs.core.async.t_cljs$core$async10561(self__.filter_GT_,self__.p,self__.ch,meta10562__$1));
});

cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10563){
var self__ = this;
var _10563__$1 = this;
return self__.meta10562;
});

cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async10561.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async10561.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10562","meta10562",548751143,null)], null);
});

cljs.core.async.t_cljs$core$async10561.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10561.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10561";

cljs.core.async.t_cljs$core$async10561.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async10561");
});

cljs.core.async.__GT_t_cljs$core$async10561 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async10561(filter_GT___$1,p__$1,ch__$1,meta10562){
return (new cljs.core.async.t_cljs$core$async10561(filter_GT___$1,p__$1,ch__$1,meta10562));
});

}

return (new cljs.core.async.t_cljs$core$async10561(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args10564 = [];
var len__5726__auto___10608 = arguments.length;
var i__5727__auto___10609 = (0);
while(true){
if((i__5727__auto___10609 < len__5726__auto___10608)){
args10564.push((arguments[i__5727__auto___10609]));

var G__10610 = (i__5727__auto___10609 + (1));
i__5727__auto___10609 = G__10610;
continue;
} else {
}
break;
}

var G__10566 = args10564.length;
switch (G__10566) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10564.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___10612 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___10612,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___10612,out){
return (function (state_10587){
var state_val_10588 = (state_10587[(1)]);
if((state_val_10588 === (7))){
var inst_10583 = (state_10587[(2)]);
var state_10587__$1 = state_10587;
var statearr_10589_10613 = state_10587__$1;
(statearr_10589_10613[(2)] = inst_10583);

(statearr_10589_10613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10588 === (1))){
var state_10587__$1 = state_10587;
var statearr_10590_10614 = state_10587__$1;
(statearr_10590_10614[(2)] = null);

(statearr_10590_10614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10588 === (4))){
var inst_10569 = (state_10587[(7)]);
var inst_10569__$1 = (state_10587[(2)]);
var inst_10570 = (inst_10569__$1 == null);
var state_10587__$1 = (function (){var statearr_10591 = state_10587;
(statearr_10591[(7)] = inst_10569__$1);

return statearr_10591;
})();
if(cljs.core.truth_(inst_10570)){
var statearr_10592_10615 = state_10587__$1;
(statearr_10592_10615[(1)] = (5));

} else {
var statearr_10593_10616 = state_10587__$1;
(statearr_10593_10616[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10588 === (6))){
var inst_10569 = (state_10587[(7)]);
var inst_10574 = p.call(null,inst_10569);
var state_10587__$1 = state_10587;
if(cljs.core.truth_(inst_10574)){
var statearr_10594_10617 = state_10587__$1;
(statearr_10594_10617[(1)] = (8));

} else {
var statearr_10595_10618 = state_10587__$1;
(statearr_10595_10618[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10588 === (3))){
var inst_10585 = (state_10587[(2)]);
var state_10587__$1 = state_10587;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10587__$1,inst_10585);
} else {
if((state_val_10588 === (2))){
var state_10587__$1 = state_10587;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10587__$1,(4),ch);
} else {
if((state_val_10588 === (11))){
var inst_10577 = (state_10587[(2)]);
var state_10587__$1 = state_10587;
var statearr_10596_10619 = state_10587__$1;
(statearr_10596_10619[(2)] = inst_10577);

(statearr_10596_10619[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10588 === (9))){
var state_10587__$1 = state_10587;
var statearr_10597_10620 = state_10587__$1;
(statearr_10597_10620[(2)] = null);

(statearr_10597_10620[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10588 === (5))){
var inst_10572 = cljs.core.async.close_BANG_.call(null,out);
var state_10587__$1 = state_10587;
var statearr_10598_10621 = state_10587__$1;
(statearr_10598_10621[(2)] = inst_10572);

(statearr_10598_10621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10588 === (10))){
var inst_10580 = (state_10587[(2)]);
var state_10587__$1 = (function (){var statearr_10599 = state_10587;
(statearr_10599[(8)] = inst_10580);

return statearr_10599;
})();
var statearr_10600_10622 = state_10587__$1;
(statearr_10600_10622[(2)] = null);

(statearr_10600_10622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10588 === (8))){
var inst_10569 = (state_10587[(7)]);
var state_10587__$1 = state_10587;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10587__$1,(11),out,inst_10569);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___10612,out))
;
return ((function (switch__8250__auto__,c__8362__auto___10612,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_10604 = [null,null,null,null,null,null,null,null,null];
(statearr_10604[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_10604[(1)] = (1));

return statearr_10604;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_10587){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10587);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e10605){if((e10605 instanceof Object)){
var ex__8254__auto__ = e10605;
var statearr_10606_10623 = state_10587;
(statearr_10606_10623[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10587);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10605;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10624 = state_10587;
state_10587 = G__10624;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_10587){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_10587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___10612,out))
})();
var state__8364__auto__ = (function (){var statearr_10607 = f__8363__auto__.call(null);
(statearr_10607[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___10612);

return statearr_10607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___10612,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args10625 = [];
var len__5726__auto___10628 = arguments.length;
var i__5727__auto___10629 = (0);
while(true){
if((i__5727__auto___10629 < len__5726__auto___10628)){
args10625.push((arguments[i__5727__auto___10629]));

var G__10630 = (i__5727__auto___10629 + (1));
i__5727__auto___10629 = G__10630;
continue;
} else {
}
break;
}

var G__10627 = args10625.length;
switch (G__10627) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10625.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_10797){
var state_val_10798 = (state_10797[(1)]);
if((state_val_10798 === (7))){
var inst_10793 = (state_10797[(2)]);
var state_10797__$1 = state_10797;
var statearr_10799_10840 = state_10797__$1;
(statearr_10799_10840[(2)] = inst_10793);

(statearr_10799_10840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (20))){
var inst_10763 = (state_10797[(7)]);
var inst_10774 = (state_10797[(2)]);
var inst_10775 = cljs.core.next.call(null,inst_10763);
var inst_10749 = inst_10775;
var inst_10750 = null;
var inst_10751 = (0);
var inst_10752 = (0);
var state_10797__$1 = (function (){var statearr_10800 = state_10797;
(statearr_10800[(8)] = inst_10774);

(statearr_10800[(9)] = inst_10749);

(statearr_10800[(10)] = inst_10751);

(statearr_10800[(11)] = inst_10750);

(statearr_10800[(12)] = inst_10752);

return statearr_10800;
})();
var statearr_10801_10841 = state_10797__$1;
(statearr_10801_10841[(2)] = null);

(statearr_10801_10841[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (1))){
var state_10797__$1 = state_10797;
var statearr_10802_10842 = state_10797__$1;
(statearr_10802_10842[(2)] = null);

(statearr_10802_10842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (4))){
var inst_10738 = (state_10797[(13)]);
var inst_10738__$1 = (state_10797[(2)]);
var inst_10739 = (inst_10738__$1 == null);
var state_10797__$1 = (function (){var statearr_10803 = state_10797;
(statearr_10803[(13)] = inst_10738__$1);

return statearr_10803;
})();
if(cljs.core.truth_(inst_10739)){
var statearr_10804_10843 = state_10797__$1;
(statearr_10804_10843[(1)] = (5));

} else {
var statearr_10805_10844 = state_10797__$1;
(statearr_10805_10844[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (15))){
var state_10797__$1 = state_10797;
var statearr_10809_10845 = state_10797__$1;
(statearr_10809_10845[(2)] = null);

(statearr_10809_10845[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (21))){
var state_10797__$1 = state_10797;
var statearr_10810_10846 = state_10797__$1;
(statearr_10810_10846[(2)] = null);

(statearr_10810_10846[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (13))){
var inst_10749 = (state_10797[(9)]);
var inst_10751 = (state_10797[(10)]);
var inst_10750 = (state_10797[(11)]);
var inst_10752 = (state_10797[(12)]);
var inst_10759 = (state_10797[(2)]);
var inst_10760 = (inst_10752 + (1));
var tmp10806 = inst_10749;
var tmp10807 = inst_10751;
var tmp10808 = inst_10750;
var inst_10749__$1 = tmp10806;
var inst_10750__$1 = tmp10808;
var inst_10751__$1 = tmp10807;
var inst_10752__$1 = inst_10760;
var state_10797__$1 = (function (){var statearr_10811 = state_10797;
(statearr_10811[(9)] = inst_10749__$1);

(statearr_10811[(10)] = inst_10751__$1);

(statearr_10811[(11)] = inst_10750__$1);

(statearr_10811[(14)] = inst_10759);

(statearr_10811[(12)] = inst_10752__$1);

return statearr_10811;
})();
var statearr_10812_10847 = state_10797__$1;
(statearr_10812_10847[(2)] = null);

(statearr_10812_10847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (22))){
var state_10797__$1 = state_10797;
var statearr_10813_10848 = state_10797__$1;
(statearr_10813_10848[(2)] = null);

(statearr_10813_10848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (6))){
var inst_10738 = (state_10797[(13)]);
var inst_10747 = f.call(null,inst_10738);
var inst_10748 = cljs.core.seq.call(null,inst_10747);
var inst_10749 = inst_10748;
var inst_10750 = null;
var inst_10751 = (0);
var inst_10752 = (0);
var state_10797__$1 = (function (){var statearr_10814 = state_10797;
(statearr_10814[(9)] = inst_10749);

(statearr_10814[(10)] = inst_10751);

(statearr_10814[(11)] = inst_10750);

(statearr_10814[(12)] = inst_10752);

return statearr_10814;
})();
var statearr_10815_10849 = state_10797__$1;
(statearr_10815_10849[(2)] = null);

(statearr_10815_10849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (17))){
var inst_10763 = (state_10797[(7)]);
var inst_10767 = cljs.core.chunk_first.call(null,inst_10763);
var inst_10768 = cljs.core.chunk_rest.call(null,inst_10763);
var inst_10769 = cljs.core.count.call(null,inst_10767);
var inst_10749 = inst_10768;
var inst_10750 = inst_10767;
var inst_10751 = inst_10769;
var inst_10752 = (0);
var state_10797__$1 = (function (){var statearr_10816 = state_10797;
(statearr_10816[(9)] = inst_10749);

(statearr_10816[(10)] = inst_10751);

(statearr_10816[(11)] = inst_10750);

(statearr_10816[(12)] = inst_10752);

return statearr_10816;
})();
var statearr_10817_10850 = state_10797__$1;
(statearr_10817_10850[(2)] = null);

(statearr_10817_10850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (3))){
var inst_10795 = (state_10797[(2)]);
var state_10797__$1 = state_10797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10797__$1,inst_10795);
} else {
if((state_val_10798 === (12))){
var inst_10783 = (state_10797[(2)]);
var state_10797__$1 = state_10797;
var statearr_10818_10851 = state_10797__$1;
(statearr_10818_10851[(2)] = inst_10783);

(statearr_10818_10851[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (2))){
var state_10797__$1 = state_10797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10797__$1,(4),in$);
} else {
if((state_val_10798 === (23))){
var inst_10791 = (state_10797[(2)]);
var state_10797__$1 = state_10797;
var statearr_10819_10852 = state_10797__$1;
(statearr_10819_10852[(2)] = inst_10791);

(statearr_10819_10852[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (19))){
var inst_10778 = (state_10797[(2)]);
var state_10797__$1 = state_10797;
var statearr_10820_10853 = state_10797__$1;
(statearr_10820_10853[(2)] = inst_10778);

(statearr_10820_10853[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (11))){
var inst_10749 = (state_10797[(9)]);
var inst_10763 = (state_10797[(7)]);
var inst_10763__$1 = cljs.core.seq.call(null,inst_10749);
var state_10797__$1 = (function (){var statearr_10821 = state_10797;
(statearr_10821[(7)] = inst_10763__$1);

return statearr_10821;
})();
if(inst_10763__$1){
var statearr_10822_10854 = state_10797__$1;
(statearr_10822_10854[(1)] = (14));

} else {
var statearr_10823_10855 = state_10797__$1;
(statearr_10823_10855[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (9))){
var inst_10785 = (state_10797[(2)]);
var inst_10786 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_10797__$1 = (function (){var statearr_10824 = state_10797;
(statearr_10824[(15)] = inst_10785);

return statearr_10824;
})();
if(cljs.core.truth_(inst_10786)){
var statearr_10825_10856 = state_10797__$1;
(statearr_10825_10856[(1)] = (21));

} else {
var statearr_10826_10857 = state_10797__$1;
(statearr_10826_10857[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (5))){
var inst_10741 = cljs.core.async.close_BANG_.call(null,out);
var state_10797__$1 = state_10797;
var statearr_10827_10858 = state_10797__$1;
(statearr_10827_10858[(2)] = inst_10741);

(statearr_10827_10858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (14))){
var inst_10763 = (state_10797[(7)]);
var inst_10765 = cljs.core.chunked_seq_QMARK_.call(null,inst_10763);
var state_10797__$1 = state_10797;
if(inst_10765){
var statearr_10828_10859 = state_10797__$1;
(statearr_10828_10859[(1)] = (17));

} else {
var statearr_10829_10860 = state_10797__$1;
(statearr_10829_10860[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (16))){
var inst_10781 = (state_10797[(2)]);
var state_10797__$1 = state_10797;
var statearr_10830_10861 = state_10797__$1;
(statearr_10830_10861[(2)] = inst_10781);

(statearr_10830_10861[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10798 === (10))){
var inst_10750 = (state_10797[(11)]);
var inst_10752 = (state_10797[(12)]);
var inst_10757 = cljs.core._nth.call(null,inst_10750,inst_10752);
var state_10797__$1 = state_10797;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10797__$1,(13),out,inst_10757);
} else {
if((state_val_10798 === (18))){
var inst_10763 = (state_10797[(7)]);
var inst_10772 = cljs.core.first.call(null,inst_10763);
var state_10797__$1 = state_10797;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10797__$1,(20),out,inst_10772);
} else {
if((state_val_10798 === (8))){
var inst_10751 = (state_10797[(10)]);
var inst_10752 = (state_10797[(12)]);
var inst_10754 = (inst_10752 < inst_10751);
var inst_10755 = inst_10754;
var state_10797__$1 = state_10797;
if(cljs.core.truth_(inst_10755)){
var statearr_10831_10862 = state_10797__$1;
(statearr_10831_10862[(1)] = (10));

} else {
var statearr_10832_10863 = state_10797__$1;
(statearr_10832_10863[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_10836 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10836[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_10836[(1)] = (1));

return statearr_10836;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_10797){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e10837){if((e10837 instanceof Object)){
var ex__8254__auto__ = e10837;
var statearr_10838_10864 = state_10797;
(statearr_10838_10864[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10797);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10837;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10865 = state_10797;
state_10797 = G__10865;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_10797){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_10797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_10839 = f__8363__auto__.call(null);
(statearr_10839[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_10839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args10866 = [];
var len__5726__auto___10869 = arguments.length;
var i__5727__auto___10870 = (0);
while(true){
if((i__5727__auto___10870 < len__5726__auto___10869)){
args10866.push((arguments[i__5727__auto___10870]));

var G__10871 = (i__5727__auto___10870 + (1));
i__5727__auto___10870 = G__10871;
continue;
} else {
}
break;
}

var G__10868 = args10866.length;
switch (G__10868) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10866.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args10873 = [];
var len__5726__auto___10876 = arguments.length;
var i__5727__auto___10877 = (0);
while(true){
if((i__5727__auto___10877 < len__5726__auto___10876)){
args10873.push((arguments[i__5727__auto___10877]));

var G__10878 = (i__5727__auto___10877 + (1));
i__5727__auto___10877 = G__10878;
continue;
} else {
}
break;
}

var G__10875 = args10873.length;
switch (G__10875) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10873.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args10880 = [];
var len__5726__auto___10931 = arguments.length;
var i__5727__auto___10932 = (0);
while(true){
if((i__5727__auto___10932 < len__5726__auto___10931)){
args10880.push((arguments[i__5727__auto___10932]));

var G__10933 = (i__5727__auto___10932 + (1));
i__5727__auto___10932 = G__10933;
continue;
} else {
}
break;
}

var G__10882 = args10880.length;
switch (G__10882) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10880.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___10935 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___10935,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___10935,out){
return (function (state_10906){
var state_val_10907 = (state_10906[(1)]);
if((state_val_10907 === (7))){
var inst_10901 = (state_10906[(2)]);
var state_10906__$1 = state_10906;
var statearr_10908_10936 = state_10906__$1;
(statearr_10908_10936[(2)] = inst_10901);

(statearr_10908_10936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10907 === (1))){
var inst_10883 = null;
var state_10906__$1 = (function (){var statearr_10909 = state_10906;
(statearr_10909[(7)] = inst_10883);

return statearr_10909;
})();
var statearr_10910_10937 = state_10906__$1;
(statearr_10910_10937[(2)] = null);

(statearr_10910_10937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10907 === (4))){
var inst_10886 = (state_10906[(8)]);
var inst_10886__$1 = (state_10906[(2)]);
var inst_10887 = (inst_10886__$1 == null);
var inst_10888 = cljs.core.not.call(null,inst_10887);
var state_10906__$1 = (function (){var statearr_10911 = state_10906;
(statearr_10911[(8)] = inst_10886__$1);

return statearr_10911;
})();
if(inst_10888){
var statearr_10912_10938 = state_10906__$1;
(statearr_10912_10938[(1)] = (5));

} else {
var statearr_10913_10939 = state_10906__$1;
(statearr_10913_10939[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10907 === (6))){
var state_10906__$1 = state_10906;
var statearr_10914_10940 = state_10906__$1;
(statearr_10914_10940[(2)] = null);

(statearr_10914_10940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10907 === (3))){
var inst_10903 = (state_10906[(2)]);
var inst_10904 = cljs.core.async.close_BANG_.call(null,out);
var state_10906__$1 = (function (){var statearr_10915 = state_10906;
(statearr_10915[(9)] = inst_10903);

return statearr_10915;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10906__$1,inst_10904);
} else {
if((state_val_10907 === (2))){
var state_10906__$1 = state_10906;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10906__$1,(4),ch);
} else {
if((state_val_10907 === (11))){
var inst_10886 = (state_10906[(8)]);
var inst_10895 = (state_10906[(2)]);
var inst_10883 = inst_10886;
var state_10906__$1 = (function (){var statearr_10916 = state_10906;
(statearr_10916[(7)] = inst_10883);

(statearr_10916[(10)] = inst_10895);

return statearr_10916;
})();
var statearr_10917_10941 = state_10906__$1;
(statearr_10917_10941[(2)] = null);

(statearr_10917_10941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10907 === (9))){
var inst_10886 = (state_10906[(8)]);
var state_10906__$1 = state_10906;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10906__$1,(11),out,inst_10886);
} else {
if((state_val_10907 === (5))){
var inst_10886 = (state_10906[(8)]);
var inst_10883 = (state_10906[(7)]);
var inst_10890 = cljs.core._EQ_.call(null,inst_10886,inst_10883);
var state_10906__$1 = state_10906;
if(inst_10890){
var statearr_10919_10942 = state_10906__$1;
(statearr_10919_10942[(1)] = (8));

} else {
var statearr_10920_10943 = state_10906__$1;
(statearr_10920_10943[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10907 === (10))){
var inst_10898 = (state_10906[(2)]);
var state_10906__$1 = state_10906;
var statearr_10921_10944 = state_10906__$1;
(statearr_10921_10944[(2)] = inst_10898);

(statearr_10921_10944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10907 === (8))){
var inst_10883 = (state_10906[(7)]);
var tmp10918 = inst_10883;
var inst_10883__$1 = tmp10918;
var state_10906__$1 = (function (){var statearr_10922 = state_10906;
(statearr_10922[(7)] = inst_10883__$1);

return statearr_10922;
})();
var statearr_10923_10945 = state_10906__$1;
(statearr_10923_10945[(2)] = null);

(statearr_10923_10945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___10935,out))
;
return ((function (switch__8250__auto__,c__8362__auto___10935,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_10927 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10927[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_10927[(1)] = (1));

return statearr_10927;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_10906){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e10928){if((e10928 instanceof Object)){
var ex__8254__auto__ = e10928;
var statearr_10929_10946 = state_10906;
(statearr_10929_10946[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10928;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10947 = state_10906;
state_10906 = G__10947;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_10906){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_10906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___10935,out))
})();
var state__8364__auto__ = (function (){var statearr_10930 = f__8363__auto__.call(null);
(statearr_10930[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___10935);

return statearr_10930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___10935,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args10948 = [];
var len__5726__auto___11018 = arguments.length;
var i__5727__auto___11019 = (0);
while(true){
if((i__5727__auto___11019 < len__5726__auto___11018)){
args10948.push((arguments[i__5727__auto___11019]));

var G__11020 = (i__5727__auto___11019 + (1));
i__5727__auto___11019 = G__11020;
continue;
} else {
}
break;
}

var G__10950 = args10948.length;
switch (G__10950) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args10948.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___11022 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___11022,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___11022,out){
return (function (state_10988){
var state_val_10989 = (state_10988[(1)]);
if((state_val_10989 === (7))){
var inst_10984 = (state_10988[(2)]);
var state_10988__$1 = state_10988;
var statearr_10990_11023 = state_10988__$1;
(statearr_10990_11023[(2)] = inst_10984);

(statearr_10990_11023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (1))){
var inst_10951 = (new Array(n));
var inst_10952 = inst_10951;
var inst_10953 = (0);
var state_10988__$1 = (function (){var statearr_10991 = state_10988;
(statearr_10991[(7)] = inst_10953);

(statearr_10991[(8)] = inst_10952);

return statearr_10991;
})();
var statearr_10992_11024 = state_10988__$1;
(statearr_10992_11024[(2)] = null);

(statearr_10992_11024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (4))){
var inst_10956 = (state_10988[(9)]);
var inst_10956__$1 = (state_10988[(2)]);
var inst_10957 = (inst_10956__$1 == null);
var inst_10958 = cljs.core.not.call(null,inst_10957);
var state_10988__$1 = (function (){var statearr_10993 = state_10988;
(statearr_10993[(9)] = inst_10956__$1);

return statearr_10993;
})();
if(inst_10958){
var statearr_10994_11025 = state_10988__$1;
(statearr_10994_11025[(1)] = (5));

} else {
var statearr_10995_11026 = state_10988__$1;
(statearr_10995_11026[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (15))){
var inst_10978 = (state_10988[(2)]);
var state_10988__$1 = state_10988;
var statearr_10996_11027 = state_10988__$1;
(statearr_10996_11027[(2)] = inst_10978);

(statearr_10996_11027[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (13))){
var state_10988__$1 = state_10988;
var statearr_10997_11028 = state_10988__$1;
(statearr_10997_11028[(2)] = null);

(statearr_10997_11028[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (6))){
var inst_10953 = (state_10988[(7)]);
var inst_10974 = (inst_10953 > (0));
var state_10988__$1 = state_10988;
if(cljs.core.truth_(inst_10974)){
var statearr_10998_11029 = state_10988__$1;
(statearr_10998_11029[(1)] = (12));

} else {
var statearr_10999_11030 = state_10988__$1;
(statearr_10999_11030[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (3))){
var inst_10986 = (state_10988[(2)]);
var state_10988__$1 = state_10988;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10988__$1,inst_10986);
} else {
if((state_val_10989 === (12))){
var inst_10952 = (state_10988[(8)]);
var inst_10976 = cljs.core.vec.call(null,inst_10952);
var state_10988__$1 = state_10988;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10988__$1,(15),out,inst_10976);
} else {
if((state_val_10989 === (2))){
var state_10988__$1 = state_10988;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10988__$1,(4),ch);
} else {
if((state_val_10989 === (11))){
var inst_10968 = (state_10988[(2)]);
var inst_10969 = (new Array(n));
var inst_10952 = inst_10969;
var inst_10953 = (0);
var state_10988__$1 = (function (){var statearr_11000 = state_10988;
(statearr_11000[(7)] = inst_10953);

(statearr_11000[(10)] = inst_10968);

(statearr_11000[(8)] = inst_10952);

return statearr_11000;
})();
var statearr_11001_11031 = state_10988__$1;
(statearr_11001_11031[(2)] = null);

(statearr_11001_11031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (9))){
var inst_10952 = (state_10988[(8)]);
var inst_10966 = cljs.core.vec.call(null,inst_10952);
var state_10988__$1 = state_10988;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10988__$1,(11),out,inst_10966);
} else {
if((state_val_10989 === (5))){
var inst_10961 = (state_10988[(11)]);
var inst_10953 = (state_10988[(7)]);
var inst_10952 = (state_10988[(8)]);
var inst_10956 = (state_10988[(9)]);
var inst_10960 = (inst_10952[inst_10953] = inst_10956);
var inst_10961__$1 = (inst_10953 + (1));
var inst_10962 = (inst_10961__$1 < n);
var state_10988__$1 = (function (){var statearr_11002 = state_10988;
(statearr_11002[(11)] = inst_10961__$1);

(statearr_11002[(12)] = inst_10960);

return statearr_11002;
})();
if(cljs.core.truth_(inst_10962)){
var statearr_11003_11032 = state_10988__$1;
(statearr_11003_11032[(1)] = (8));

} else {
var statearr_11004_11033 = state_10988__$1;
(statearr_11004_11033[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (14))){
var inst_10981 = (state_10988[(2)]);
var inst_10982 = cljs.core.async.close_BANG_.call(null,out);
var state_10988__$1 = (function (){var statearr_11006 = state_10988;
(statearr_11006[(13)] = inst_10981);

return statearr_11006;
})();
var statearr_11007_11034 = state_10988__$1;
(statearr_11007_11034[(2)] = inst_10982);

(statearr_11007_11034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (10))){
var inst_10972 = (state_10988[(2)]);
var state_10988__$1 = state_10988;
var statearr_11008_11035 = state_10988__$1;
(statearr_11008_11035[(2)] = inst_10972);

(statearr_11008_11035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10989 === (8))){
var inst_10961 = (state_10988[(11)]);
var inst_10952 = (state_10988[(8)]);
var tmp11005 = inst_10952;
var inst_10952__$1 = tmp11005;
var inst_10953 = inst_10961;
var state_10988__$1 = (function (){var statearr_11009 = state_10988;
(statearr_11009[(7)] = inst_10953);

(statearr_11009[(8)] = inst_10952__$1);

return statearr_11009;
})();
var statearr_11010_11036 = state_10988__$1;
(statearr_11010_11036[(2)] = null);

(statearr_11010_11036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___11022,out))
;
return ((function (switch__8250__auto__,c__8362__auto___11022,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_11014 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11014[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_11014[(1)] = (1));

return statearr_11014;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_10988){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_10988);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e11015){if((e11015 instanceof Object)){
var ex__8254__auto__ = e11015;
var statearr_11016_11037 = state_10988;
(statearr_11016_11037[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10988);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11038 = state_10988;
state_10988 = G__11038;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_10988){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_10988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___11022,out))
})();
var state__8364__auto__ = (function (){var statearr_11017 = f__8363__auto__.call(null);
(statearr_11017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___11022);

return statearr_11017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___11022,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args11039 = [];
var len__5726__auto___11113 = arguments.length;
var i__5727__auto___11114 = (0);
while(true){
if((i__5727__auto___11114 < len__5726__auto___11113)){
args11039.push((arguments[i__5727__auto___11114]));

var G__11115 = (i__5727__auto___11114 + (1));
i__5727__auto___11114 = G__11115;
continue;
} else {
}
break;
}

var G__11041 = args11039.length;
switch (G__11041) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11039.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___11117 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___11117,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___11117,out){
return (function (state_11083){
var state_val_11084 = (state_11083[(1)]);
if((state_val_11084 === (7))){
var inst_11079 = (state_11083[(2)]);
var state_11083__$1 = state_11083;
var statearr_11085_11118 = state_11083__$1;
(statearr_11085_11118[(2)] = inst_11079);

(statearr_11085_11118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (1))){
var inst_11042 = [];
var inst_11043 = inst_11042;
var inst_11044 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_11083__$1 = (function (){var statearr_11086 = state_11083;
(statearr_11086[(7)] = inst_11043);

(statearr_11086[(8)] = inst_11044);

return statearr_11086;
})();
var statearr_11087_11119 = state_11083__$1;
(statearr_11087_11119[(2)] = null);

(statearr_11087_11119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (4))){
var inst_11047 = (state_11083[(9)]);
var inst_11047__$1 = (state_11083[(2)]);
var inst_11048 = (inst_11047__$1 == null);
var inst_11049 = cljs.core.not.call(null,inst_11048);
var state_11083__$1 = (function (){var statearr_11088 = state_11083;
(statearr_11088[(9)] = inst_11047__$1);

return statearr_11088;
})();
if(inst_11049){
var statearr_11089_11120 = state_11083__$1;
(statearr_11089_11120[(1)] = (5));

} else {
var statearr_11090_11121 = state_11083__$1;
(statearr_11090_11121[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (15))){
var inst_11073 = (state_11083[(2)]);
var state_11083__$1 = state_11083;
var statearr_11091_11122 = state_11083__$1;
(statearr_11091_11122[(2)] = inst_11073);

(statearr_11091_11122[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (13))){
var state_11083__$1 = state_11083;
var statearr_11092_11123 = state_11083__$1;
(statearr_11092_11123[(2)] = null);

(statearr_11092_11123[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (6))){
var inst_11043 = (state_11083[(7)]);
var inst_11068 = inst_11043.length;
var inst_11069 = (inst_11068 > (0));
var state_11083__$1 = state_11083;
if(cljs.core.truth_(inst_11069)){
var statearr_11093_11124 = state_11083__$1;
(statearr_11093_11124[(1)] = (12));

} else {
var statearr_11094_11125 = state_11083__$1;
(statearr_11094_11125[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (3))){
var inst_11081 = (state_11083[(2)]);
var state_11083__$1 = state_11083;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11083__$1,inst_11081);
} else {
if((state_val_11084 === (12))){
var inst_11043 = (state_11083[(7)]);
var inst_11071 = cljs.core.vec.call(null,inst_11043);
var state_11083__$1 = state_11083;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11083__$1,(15),out,inst_11071);
} else {
if((state_val_11084 === (2))){
var state_11083__$1 = state_11083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11083__$1,(4),ch);
} else {
if((state_val_11084 === (11))){
var inst_11047 = (state_11083[(9)]);
var inst_11051 = (state_11083[(10)]);
var inst_11061 = (state_11083[(2)]);
var inst_11062 = [];
var inst_11063 = inst_11062.push(inst_11047);
var inst_11043 = inst_11062;
var inst_11044 = inst_11051;
var state_11083__$1 = (function (){var statearr_11095 = state_11083;
(statearr_11095[(7)] = inst_11043);

(statearr_11095[(8)] = inst_11044);

(statearr_11095[(11)] = inst_11063);

(statearr_11095[(12)] = inst_11061);

return statearr_11095;
})();
var statearr_11096_11126 = state_11083__$1;
(statearr_11096_11126[(2)] = null);

(statearr_11096_11126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (9))){
var inst_11043 = (state_11083[(7)]);
var inst_11059 = cljs.core.vec.call(null,inst_11043);
var state_11083__$1 = state_11083;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11083__$1,(11),out,inst_11059);
} else {
if((state_val_11084 === (5))){
var inst_11047 = (state_11083[(9)]);
var inst_11044 = (state_11083[(8)]);
var inst_11051 = (state_11083[(10)]);
var inst_11051__$1 = f.call(null,inst_11047);
var inst_11052 = cljs.core._EQ_.call(null,inst_11051__$1,inst_11044);
var inst_11053 = cljs.core.keyword_identical_QMARK_.call(null,inst_11044,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_11054 = (inst_11052) || (inst_11053);
var state_11083__$1 = (function (){var statearr_11097 = state_11083;
(statearr_11097[(10)] = inst_11051__$1);

return statearr_11097;
})();
if(cljs.core.truth_(inst_11054)){
var statearr_11098_11127 = state_11083__$1;
(statearr_11098_11127[(1)] = (8));

} else {
var statearr_11099_11128 = state_11083__$1;
(statearr_11099_11128[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (14))){
var inst_11076 = (state_11083[(2)]);
var inst_11077 = cljs.core.async.close_BANG_.call(null,out);
var state_11083__$1 = (function (){var statearr_11101 = state_11083;
(statearr_11101[(13)] = inst_11076);

return statearr_11101;
})();
var statearr_11102_11129 = state_11083__$1;
(statearr_11102_11129[(2)] = inst_11077);

(statearr_11102_11129[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (10))){
var inst_11066 = (state_11083[(2)]);
var state_11083__$1 = state_11083;
var statearr_11103_11130 = state_11083__$1;
(statearr_11103_11130[(2)] = inst_11066);

(statearr_11103_11130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11084 === (8))){
var inst_11043 = (state_11083[(7)]);
var inst_11047 = (state_11083[(9)]);
var inst_11051 = (state_11083[(10)]);
var inst_11056 = inst_11043.push(inst_11047);
var tmp11100 = inst_11043;
var inst_11043__$1 = tmp11100;
var inst_11044 = inst_11051;
var state_11083__$1 = (function (){var statearr_11104 = state_11083;
(statearr_11104[(7)] = inst_11043__$1);

(statearr_11104[(14)] = inst_11056);

(statearr_11104[(8)] = inst_11044);

return statearr_11104;
})();
var statearr_11105_11131 = state_11083__$1;
(statearr_11105_11131[(2)] = null);

(statearr_11105_11131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___11117,out))
;
return ((function (switch__8250__auto__,c__8362__auto___11117,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_11109 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11109[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_11109[(1)] = (1));

return statearr_11109;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_11083){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_11083);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e11110){if((e11110 instanceof Object)){
var ex__8254__auto__ = e11110;
var statearr_11111_11132 = state_11083;
(statearr_11111_11132[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11083);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11133 = state_11083;
state_11083 = G__11133;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_11083){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_11083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___11117,out))
})();
var state__8364__auto__ = (function (){var statearr_11112 = f__8363__auto__.call(null);
(statearr_11112[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___11117);

return statearr_11112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___11117,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1453979761604