// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17290 = [];
var len__5726__auto___17296 = arguments.length;
var i__5727__auto___17297 = (0);
while(true){
if((i__5727__auto___17297 < len__5726__auto___17296)){
args17290.push((arguments[i__5727__auto___17297]));

var G__17298 = (i__5727__auto___17297 + (1));
i__5727__auto___17297 = G__17298;
continue;
} else {
}
break;
}

var G__17292 = args17290.length;
switch (G__17292) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17290.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17293 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17293 = (function (f,blockable,meta17294){
this.f = f;
this.blockable = blockable;
this.meta17294 = meta17294;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17293.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17295,meta17294__$1){
var self__ = this;
var _17295__$1 = this;
return (new cljs.core.async.t_cljs$core$async17293(self__.f,self__.blockable,meta17294__$1));
});

cljs.core.async.t_cljs$core$async17293.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17295){
var self__ = this;
var _17295__$1 = this;
return self__.meta17294;
});

cljs.core.async.t_cljs$core$async17293.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17293.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17293.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17293.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17293.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17294","meta17294",207002663,null)], null);
});

cljs.core.async.t_cljs$core$async17293.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17293.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17293";

cljs.core.async.t_cljs$core$async17293.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17293");
});

cljs.core.async.__GT_t_cljs$core$async17293 = (function cljs$core$async$__GT_t_cljs$core$async17293(f__$1,blockable__$1,meta17294){
return (new cljs.core.async.t_cljs$core$async17293(f__$1,blockable__$1,meta17294));
});

}

return (new cljs.core.async.t_cljs$core$async17293(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17302 = [];
var len__5726__auto___17305 = arguments.length;
var i__5727__auto___17306 = (0);
while(true){
if((i__5727__auto___17306 < len__5726__auto___17305)){
args17302.push((arguments[i__5727__auto___17306]));

var G__17307 = (i__5727__auto___17306 + (1));
i__5727__auto___17306 = G__17307;
continue;
} else {
}
break;
}

var G__17304 = args17302.length;
switch (G__17304) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17302.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17309 = [];
var len__5726__auto___17312 = arguments.length;
var i__5727__auto___17313 = (0);
while(true){
if((i__5727__auto___17313 < len__5726__auto___17312)){
args17309.push((arguments[i__5727__auto___17313]));

var G__17314 = (i__5727__auto___17313 + (1));
i__5727__auto___17313 = G__17314;
continue;
} else {
}
break;
}

var G__17311 = args17309.length;
switch (G__17311) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17309.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17316 = [];
var len__5726__auto___17319 = arguments.length;
var i__5727__auto___17320 = (0);
while(true){
if((i__5727__auto___17320 < len__5726__auto___17319)){
args17316.push((arguments[i__5727__auto___17320]));

var G__17321 = (i__5727__auto___17320 + (1));
i__5727__auto___17320 = G__17321;
continue;
} else {
}
break;
}

var G__17318 = args17316.length;
switch (G__17318) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17316.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17323 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17323);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17323,ret){
return (function (){
return fn1.call(null,val_17323);
});})(val_17323,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17324 = [];
var len__5726__auto___17327 = arguments.length;
var i__5727__auto___17328 = (0);
while(true){
if((i__5727__auto___17328 < len__5726__auto___17327)){
args17324.push((arguments[i__5727__auto___17328]));

var G__17329 = (i__5727__auto___17328 + (1));
i__5727__auto___17328 = G__17329;
continue;
} else {
}
break;
}

var G__17326 = args17324.length;
switch (G__17326) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17324.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17331 = n;
var x_17332 = (0);
while(true){
if((x_17332 < n__5571__auto___17331)){
(a[x_17332] = (0));

var G__17333 = (x_17332 + (1));
x_17332 = G__17333;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17334 = (i + (1));
i = G__17334;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17338 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17338 = (function (alt_flag,flag,meta17339){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17339 = meta17339;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17338.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17340,meta17339__$1){
var self__ = this;
var _17340__$1 = this;
return (new cljs.core.async.t_cljs$core$async17338(self__.alt_flag,self__.flag,meta17339__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17338.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17340){
var self__ = this;
var _17340__$1 = this;
return self__.meta17339;
});})(flag))
;

cljs.core.async.t_cljs$core$async17338.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17338.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17338.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17338.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17338.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17339","meta17339",887281085,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17338.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17338.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17338";

cljs.core.async.t_cljs$core$async17338.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17338");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17338 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17338(alt_flag__$1,flag__$1,meta17339){
return (new cljs.core.async.t_cljs$core$async17338(alt_flag__$1,flag__$1,meta17339));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17338(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17344 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17344 = (function (alt_handler,flag,cb,meta17345){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17345 = meta17345;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17344.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17346,meta17345__$1){
var self__ = this;
var _17346__$1 = this;
return (new cljs.core.async.t_cljs$core$async17344(self__.alt_handler,self__.flag,self__.cb,meta17345__$1));
});

cljs.core.async.t_cljs$core$async17344.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17346){
var self__ = this;
var _17346__$1 = this;
return self__.meta17345;
});

cljs.core.async.t_cljs$core$async17344.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17344.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17344.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17344.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17344.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17345","meta17345",1855856411,null)], null);
});

cljs.core.async.t_cljs$core$async17344.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17344.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17344";

cljs.core.async.t_cljs$core$async17344.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17344");
});

cljs.core.async.__GT_t_cljs$core$async17344 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17344(alt_handler__$1,flag__$1,cb__$1,meta17345){
return (new cljs.core.async.t_cljs$core$async17344(alt_handler__$1,flag__$1,cb__$1,meta17345));
});

}

return (new cljs.core.async.t_cljs$core$async17344(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17347_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17347_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17348_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17348_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17349 = (i + (1));
i = G__17349;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17355 = arguments.length;
var i__5727__auto___17356 = (0);
while(true){
if((i__5727__auto___17356 < len__5726__auto___17355)){
args__5733__auto__.push((arguments[i__5727__auto___17356]));

var G__17357 = (i__5727__auto___17356 + (1));
i__5727__auto___17356 = G__17357;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17352){
var map__17353 = p__17352;
var map__17353__$1 = ((((!((map__17353 == null)))?((((map__17353.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17353.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17353):map__17353);
var opts = map__17353__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17350){
var G__17351 = cljs.core.first.call(null,seq17350);
var seq17350__$1 = cljs.core.next.call(null,seq17350);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17351,seq17350__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17358 = [];
var len__5726__auto___17408 = arguments.length;
var i__5727__auto___17409 = (0);
while(true){
if((i__5727__auto___17409 < len__5726__auto___17408)){
args17358.push((arguments[i__5727__auto___17409]));

var G__17410 = (i__5727__auto___17409 + (1));
i__5727__auto___17409 = G__17410;
continue;
} else {
}
break;
}

var G__17360 = args17358.length;
switch (G__17360) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17358.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17412 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17412){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17412){
return (function (state_17384){
var state_val_17385 = (state_17384[(1)]);
if((state_val_17385 === (7))){
var inst_17380 = (state_17384[(2)]);
var state_17384__$1 = state_17384;
var statearr_17386_17413 = state_17384__$1;
(statearr_17386_17413[(2)] = inst_17380);

(statearr_17386_17413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (1))){
var state_17384__$1 = state_17384;
var statearr_17387_17414 = state_17384__$1;
(statearr_17387_17414[(2)] = null);

(statearr_17387_17414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (4))){
var inst_17363 = (state_17384[(7)]);
var inst_17363__$1 = (state_17384[(2)]);
var inst_17364 = (inst_17363__$1 == null);
var state_17384__$1 = (function (){var statearr_17388 = state_17384;
(statearr_17388[(7)] = inst_17363__$1);

return statearr_17388;
})();
if(cljs.core.truth_(inst_17364)){
var statearr_17389_17415 = state_17384__$1;
(statearr_17389_17415[(1)] = (5));

} else {
var statearr_17390_17416 = state_17384__$1;
(statearr_17390_17416[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (13))){
var state_17384__$1 = state_17384;
var statearr_17391_17417 = state_17384__$1;
(statearr_17391_17417[(2)] = null);

(statearr_17391_17417[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (6))){
var inst_17363 = (state_17384[(7)]);
var state_17384__$1 = state_17384;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17384__$1,(11),to,inst_17363);
} else {
if((state_val_17385 === (3))){
var inst_17382 = (state_17384[(2)]);
var state_17384__$1 = state_17384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17384__$1,inst_17382);
} else {
if((state_val_17385 === (12))){
var state_17384__$1 = state_17384;
var statearr_17392_17418 = state_17384__$1;
(statearr_17392_17418[(2)] = null);

(statearr_17392_17418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (2))){
var state_17384__$1 = state_17384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17384__$1,(4),from);
} else {
if((state_val_17385 === (11))){
var inst_17373 = (state_17384[(2)]);
var state_17384__$1 = state_17384;
if(cljs.core.truth_(inst_17373)){
var statearr_17393_17419 = state_17384__$1;
(statearr_17393_17419[(1)] = (12));

} else {
var statearr_17394_17420 = state_17384__$1;
(statearr_17394_17420[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (9))){
var state_17384__$1 = state_17384;
var statearr_17395_17421 = state_17384__$1;
(statearr_17395_17421[(2)] = null);

(statearr_17395_17421[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (5))){
var state_17384__$1 = state_17384;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17396_17422 = state_17384__$1;
(statearr_17396_17422[(1)] = (8));

} else {
var statearr_17397_17423 = state_17384__$1;
(statearr_17397_17423[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (14))){
var inst_17378 = (state_17384[(2)]);
var state_17384__$1 = state_17384;
var statearr_17398_17424 = state_17384__$1;
(statearr_17398_17424[(2)] = inst_17378);

(statearr_17398_17424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (10))){
var inst_17370 = (state_17384[(2)]);
var state_17384__$1 = state_17384;
var statearr_17399_17425 = state_17384__$1;
(statearr_17399_17425[(2)] = inst_17370);

(statearr_17399_17425[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17385 === (8))){
var inst_17367 = cljs.core.async.close_BANG_.call(null,to);
var state_17384__$1 = state_17384;
var statearr_17400_17426 = state_17384__$1;
(statearr_17400_17426[(2)] = inst_17367);

(statearr_17400_17426[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17412))
;
return ((function (switch__8250__auto__,c__8362__auto___17412){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17404 = [null,null,null,null,null,null,null,null];
(statearr_17404[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17404[(1)] = (1));

return statearr_17404;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17384){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17405){if((e17405 instanceof Object)){
var ex__8254__auto__ = e17405;
var statearr_17406_17427 = state_17384;
(statearr_17406_17427[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17384);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17405;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17428 = state_17384;
state_17384 = G__17428;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17384){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17412))
})();
var state__8364__auto__ = (function (){var statearr_17407 = f__8363__auto__.call(null);
(statearr_17407[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17412);

return statearr_17407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17412))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17612){
var vec__17613 = p__17612;
var v = cljs.core.nth.call(null,vec__17613,(0),null);
var p = cljs.core.nth.call(null,vec__17613,(1),null);
var job = vec__17613;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17795 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17795,res,vec__17613,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17795,res,vec__17613,v,p,job,jobs,results){
return (function (state_17618){
var state_val_17619 = (state_17618[(1)]);
if((state_val_17619 === (1))){
var state_17618__$1 = state_17618;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17618__$1,(2),res,v);
} else {
if((state_val_17619 === (2))){
var inst_17615 = (state_17618[(2)]);
var inst_17616 = cljs.core.async.close_BANG_.call(null,res);
var state_17618__$1 = (function (){var statearr_17620 = state_17618;
(statearr_17620[(7)] = inst_17615);

return statearr_17620;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17618__$1,inst_17616);
} else {
return null;
}
}
});})(c__8362__auto___17795,res,vec__17613,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17795,res,vec__17613,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17624 = [null,null,null,null,null,null,null,null];
(statearr_17624[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17624[(1)] = (1));

return statearr_17624;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17618){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17625){if((e17625 instanceof Object)){
var ex__8254__auto__ = e17625;
var statearr_17626_17796 = state_17618;
(statearr_17626_17796[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17618);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17625;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17797 = state_17618;
state_17618 = G__17797;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17618){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17795,res,vec__17613,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17627 = f__8363__auto__.call(null);
(statearr_17627[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17795);

return statearr_17627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17795,res,vec__17613,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17628){
var vec__17629 = p__17628;
var v = cljs.core.nth.call(null,vec__17629,(0),null);
var p = cljs.core.nth.call(null,vec__17629,(1),null);
var job = vec__17629;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17798 = n;
var __17799 = (0);
while(true){
if((__17799 < n__5571__auto___17798)){
var G__17630_17800 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17630_17800) {
case "compute":
var c__8362__auto___17802 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17799,c__8362__auto___17802,G__17630_17800,n__5571__auto___17798,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17799,c__8362__auto___17802,G__17630_17800,n__5571__auto___17798,jobs,results,process,async){
return (function (state_17643){
var state_val_17644 = (state_17643[(1)]);
if((state_val_17644 === (1))){
var state_17643__$1 = state_17643;
var statearr_17645_17803 = state_17643__$1;
(statearr_17645_17803[(2)] = null);

(statearr_17645_17803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17644 === (2))){
var state_17643__$1 = state_17643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17643__$1,(4),jobs);
} else {
if((state_val_17644 === (3))){
var inst_17641 = (state_17643[(2)]);
var state_17643__$1 = state_17643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17643__$1,inst_17641);
} else {
if((state_val_17644 === (4))){
var inst_17633 = (state_17643[(2)]);
var inst_17634 = process.call(null,inst_17633);
var state_17643__$1 = state_17643;
if(cljs.core.truth_(inst_17634)){
var statearr_17646_17804 = state_17643__$1;
(statearr_17646_17804[(1)] = (5));

} else {
var statearr_17647_17805 = state_17643__$1;
(statearr_17647_17805[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17644 === (5))){
var state_17643__$1 = state_17643;
var statearr_17648_17806 = state_17643__$1;
(statearr_17648_17806[(2)] = null);

(statearr_17648_17806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17644 === (6))){
var state_17643__$1 = state_17643;
var statearr_17649_17807 = state_17643__$1;
(statearr_17649_17807[(2)] = null);

(statearr_17649_17807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17644 === (7))){
var inst_17639 = (state_17643[(2)]);
var state_17643__$1 = state_17643;
var statearr_17650_17808 = state_17643__$1;
(statearr_17650_17808[(2)] = inst_17639);

(statearr_17650_17808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17799,c__8362__auto___17802,G__17630_17800,n__5571__auto___17798,jobs,results,process,async))
;
return ((function (__17799,switch__8250__auto__,c__8362__auto___17802,G__17630_17800,n__5571__auto___17798,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17654 = [null,null,null,null,null,null,null];
(statearr_17654[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17654[(1)] = (1));

return statearr_17654;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17643){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17655){if((e17655 instanceof Object)){
var ex__8254__auto__ = e17655;
var statearr_17656_17809 = state_17643;
(statearr_17656_17809[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17643);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17655;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17810 = state_17643;
state_17643 = G__17810;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17643){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17799,switch__8250__auto__,c__8362__auto___17802,G__17630_17800,n__5571__auto___17798,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17657 = f__8363__auto__.call(null);
(statearr_17657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17802);

return statearr_17657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17799,c__8362__auto___17802,G__17630_17800,n__5571__auto___17798,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17811 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17799,c__8362__auto___17811,G__17630_17800,n__5571__auto___17798,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17799,c__8362__auto___17811,G__17630_17800,n__5571__auto___17798,jobs,results,process,async){
return (function (state_17670){
var state_val_17671 = (state_17670[(1)]);
if((state_val_17671 === (1))){
var state_17670__$1 = state_17670;
var statearr_17672_17812 = state_17670__$1;
(statearr_17672_17812[(2)] = null);

(statearr_17672_17812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17671 === (2))){
var state_17670__$1 = state_17670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17670__$1,(4),jobs);
} else {
if((state_val_17671 === (3))){
var inst_17668 = (state_17670[(2)]);
var state_17670__$1 = state_17670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17670__$1,inst_17668);
} else {
if((state_val_17671 === (4))){
var inst_17660 = (state_17670[(2)]);
var inst_17661 = async.call(null,inst_17660);
var state_17670__$1 = state_17670;
if(cljs.core.truth_(inst_17661)){
var statearr_17673_17813 = state_17670__$1;
(statearr_17673_17813[(1)] = (5));

} else {
var statearr_17674_17814 = state_17670__$1;
(statearr_17674_17814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17671 === (5))){
var state_17670__$1 = state_17670;
var statearr_17675_17815 = state_17670__$1;
(statearr_17675_17815[(2)] = null);

(statearr_17675_17815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17671 === (6))){
var state_17670__$1 = state_17670;
var statearr_17676_17816 = state_17670__$1;
(statearr_17676_17816[(2)] = null);

(statearr_17676_17816[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17671 === (7))){
var inst_17666 = (state_17670[(2)]);
var state_17670__$1 = state_17670;
var statearr_17677_17817 = state_17670__$1;
(statearr_17677_17817[(2)] = inst_17666);

(statearr_17677_17817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17799,c__8362__auto___17811,G__17630_17800,n__5571__auto___17798,jobs,results,process,async))
;
return ((function (__17799,switch__8250__auto__,c__8362__auto___17811,G__17630_17800,n__5571__auto___17798,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17681 = [null,null,null,null,null,null,null];
(statearr_17681[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17681[(1)] = (1));

return statearr_17681;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17670){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17682){if((e17682 instanceof Object)){
var ex__8254__auto__ = e17682;
var statearr_17683_17818 = state_17670;
(statearr_17683_17818[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17670);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17682;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17819 = state_17670;
state_17670 = G__17819;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17670){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17799,switch__8250__auto__,c__8362__auto___17811,G__17630_17800,n__5571__auto___17798,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17684 = f__8363__auto__.call(null);
(statearr_17684[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17811);

return statearr_17684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17799,c__8362__auto___17811,G__17630_17800,n__5571__auto___17798,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17820 = (__17799 + (1));
__17799 = G__17820;
continue;
} else {
}
break;
}

var c__8362__auto___17821 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17821,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17821,jobs,results,process,async){
return (function (state_17706){
var state_val_17707 = (state_17706[(1)]);
if((state_val_17707 === (1))){
var state_17706__$1 = state_17706;
var statearr_17708_17822 = state_17706__$1;
(statearr_17708_17822[(2)] = null);

(statearr_17708_17822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (2))){
var state_17706__$1 = state_17706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17706__$1,(4),from);
} else {
if((state_val_17707 === (3))){
var inst_17704 = (state_17706[(2)]);
var state_17706__$1 = state_17706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17706__$1,inst_17704);
} else {
if((state_val_17707 === (4))){
var inst_17687 = (state_17706[(7)]);
var inst_17687__$1 = (state_17706[(2)]);
var inst_17688 = (inst_17687__$1 == null);
var state_17706__$1 = (function (){var statearr_17709 = state_17706;
(statearr_17709[(7)] = inst_17687__$1);

return statearr_17709;
})();
if(cljs.core.truth_(inst_17688)){
var statearr_17710_17823 = state_17706__$1;
(statearr_17710_17823[(1)] = (5));

} else {
var statearr_17711_17824 = state_17706__$1;
(statearr_17711_17824[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (5))){
var inst_17690 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17706__$1 = state_17706;
var statearr_17712_17825 = state_17706__$1;
(statearr_17712_17825[(2)] = inst_17690);

(statearr_17712_17825[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (6))){
var inst_17687 = (state_17706[(7)]);
var inst_17692 = (state_17706[(8)]);
var inst_17692__$1 = cljs.core.async.chan.call(null,(1));
var inst_17693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17694 = [inst_17687,inst_17692__$1];
var inst_17695 = (new cljs.core.PersistentVector(null,2,(5),inst_17693,inst_17694,null));
var state_17706__$1 = (function (){var statearr_17713 = state_17706;
(statearr_17713[(8)] = inst_17692__$1);

return statearr_17713;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17706__$1,(8),jobs,inst_17695);
} else {
if((state_val_17707 === (7))){
var inst_17702 = (state_17706[(2)]);
var state_17706__$1 = state_17706;
var statearr_17714_17826 = state_17706__$1;
(statearr_17714_17826[(2)] = inst_17702);

(statearr_17714_17826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (8))){
var inst_17692 = (state_17706[(8)]);
var inst_17697 = (state_17706[(2)]);
var state_17706__$1 = (function (){var statearr_17715 = state_17706;
(statearr_17715[(9)] = inst_17697);

return statearr_17715;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17706__$1,(9),results,inst_17692);
} else {
if((state_val_17707 === (9))){
var inst_17699 = (state_17706[(2)]);
var state_17706__$1 = (function (){var statearr_17716 = state_17706;
(statearr_17716[(10)] = inst_17699);

return statearr_17716;
})();
var statearr_17717_17827 = state_17706__$1;
(statearr_17717_17827[(2)] = null);

(statearr_17717_17827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17821,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17821,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17721 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17721[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17721[(1)] = (1));

return statearr_17721;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17706){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17722){if((e17722 instanceof Object)){
var ex__8254__auto__ = e17722;
var statearr_17723_17828 = state_17706;
(statearr_17723_17828[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17706);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17722;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17829 = state_17706;
state_17706 = G__17829;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17706){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17821,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17724 = f__8363__auto__.call(null);
(statearr_17724[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17821);

return statearr_17724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17821,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17762){
var state_val_17763 = (state_17762[(1)]);
if((state_val_17763 === (7))){
var inst_17758 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
var statearr_17764_17830 = state_17762__$1;
(statearr_17764_17830[(2)] = inst_17758);

(statearr_17764_17830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (20))){
var state_17762__$1 = state_17762;
var statearr_17765_17831 = state_17762__$1;
(statearr_17765_17831[(2)] = null);

(statearr_17765_17831[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (1))){
var state_17762__$1 = state_17762;
var statearr_17766_17832 = state_17762__$1;
(statearr_17766_17832[(2)] = null);

(statearr_17766_17832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (4))){
var inst_17727 = (state_17762[(7)]);
var inst_17727__$1 = (state_17762[(2)]);
var inst_17728 = (inst_17727__$1 == null);
var state_17762__$1 = (function (){var statearr_17767 = state_17762;
(statearr_17767[(7)] = inst_17727__$1);

return statearr_17767;
})();
if(cljs.core.truth_(inst_17728)){
var statearr_17768_17833 = state_17762__$1;
(statearr_17768_17833[(1)] = (5));

} else {
var statearr_17769_17834 = state_17762__$1;
(statearr_17769_17834[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (15))){
var inst_17740 = (state_17762[(8)]);
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17762__$1,(18),to,inst_17740);
} else {
if((state_val_17763 === (21))){
var inst_17753 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
var statearr_17770_17835 = state_17762__$1;
(statearr_17770_17835[(2)] = inst_17753);

(statearr_17770_17835[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (13))){
var inst_17755 = (state_17762[(2)]);
var state_17762__$1 = (function (){var statearr_17771 = state_17762;
(statearr_17771[(9)] = inst_17755);

return statearr_17771;
})();
var statearr_17772_17836 = state_17762__$1;
(statearr_17772_17836[(2)] = null);

(statearr_17772_17836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (6))){
var inst_17727 = (state_17762[(7)]);
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17762__$1,(11),inst_17727);
} else {
if((state_val_17763 === (17))){
var inst_17748 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
if(cljs.core.truth_(inst_17748)){
var statearr_17773_17837 = state_17762__$1;
(statearr_17773_17837[(1)] = (19));

} else {
var statearr_17774_17838 = state_17762__$1;
(statearr_17774_17838[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (3))){
var inst_17760 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17762__$1,inst_17760);
} else {
if((state_val_17763 === (12))){
var inst_17737 = (state_17762[(10)]);
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17762__$1,(14),inst_17737);
} else {
if((state_val_17763 === (2))){
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17762__$1,(4),results);
} else {
if((state_val_17763 === (19))){
var state_17762__$1 = state_17762;
var statearr_17775_17839 = state_17762__$1;
(statearr_17775_17839[(2)] = null);

(statearr_17775_17839[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (11))){
var inst_17737 = (state_17762[(2)]);
var state_17762__$1 = (function (){var statearr_17776 = state_17762;
(statearr_17776[(10)] = inst_17737);

return statearr_17776;
})();
var statearr_17777_17840 = state_17762__$1;
(statearr_17777_17840[(2)] = null);

(statearr_17777_17840[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (9))){
var state_17762__$1 = state_17762;
var statearr_17778_17841 = state_17762__$1;
(statearr_17778_17841[(2)] = null);

(statearr_17778_17841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (5))){
var state_17762__$1 = state_17762;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17779_17842 = state_17762__$1;
(statearr_17779_17842[(1)] = (8));

} else {
var statearr_17780_17843 = state_17762__$1;
(statearr_17780_17843[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (14))){
var inst_17740 = (state_17762[(8)]);
var inst_17742 = (state_17762[(11)]);
var inst_17740__$1 = (state_17762[(2)]);
var inst_17741 = (inst_17740__$1 == null);
var inst_17742__$1 = cljs.core.not.call(null,inst_17741);
var state_17762__$1 = (function (){var statearr_17781 = state_17762;
(statearr_17781[(8)] = inst_17740__$1);

(statearr_17781[(11)] = inst_17742__$1);

return statearr_17781;
})();
if(inst_17742__$1){
var statearr_17782_17844 = state_17762__$1;
(statearr_17782_17844[(1)] = (15));

} else {
var statearr_17783_17845 = state_17762__$1;
(statearr_17783_17845[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (16))){
var inst_17742 = (state_17762[(11)]);
var state_17762__$1 = state_17762;
var statearr_17784_17846 = state_17762__$1;
(statearr_17784_17846[(2)] = inst_17742);

(statearr_17784_17846[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (10))){
var inst_17734 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
var statearr_17785_17847 = state_17762__$1;
(statearr_17785_17847[(2)] = inst_17734);

(statearr_17785_17847[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (18))){
var inst_17745 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
var statearr_17786_17848 = state_17762__$1;
(statearr_17786_17848[(2)] = inst_17745);

(statearr_17786_17848[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (8))){
var inst_17731 = cljs.core.async.close_BANG_.call(null,to);
var state_17762__$1 = state_17762;
var statearr_17787_17849 = state_17762__$1;
(statearr_17787_17849[(2)] = inst_17731);

(statearr_17787_17849[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17791 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17791[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17791[(1)] = (1));

return statearr_17791;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17762){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17792){if((e17792 instanceof Object)){
var ex__8254__auto__ = e17792;
var statearr_17793_17850 = state_17762;
(statearr_17793_17850[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17762);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17792;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17851 = state_17762;
state_17762 = G__17851;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17762){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17794 = f__8363__auto__.call(null);
(statearr_17794[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17852 = [];
var len__5726__auto___17855 = arguments.length;
var i__5727__auto___17856 = (0);
while(true){
if((i__5727__auto___17856 < len__5726__auto___17855)){
args17852.push((arguments[i__5727__auto___17856]));

var G__17857 = (i__5727__auto___17856 + (1));
i__5727__auto___17856 = G__17857;
continue;
} else {
}
break;
}

var G__17854 = args17852.length;
switch (G__17854) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17852.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17859 = [];
var len__5726__auto___17862 = arguments.length;
var i__5727__auto___17863 = (0);
while(true){
if((i__5727__auto___17863 < len__5726__auto___17862)){
args17859.push((arguments[i__5727__auto___17863]));

var G__17864 = (i__5727__auto___17863 + (1));
i__5727__auto___17863 = G__17864;
continue;
} else {
}
break;
}

var G__17861 = args17859.length;
switch (G__17861) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17859.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17866 = [];
var len__5726__auto___17919 = arguments.length;
var i__5727__auto___17920 = (0);
while(true){
if((i__5727__auto___17920 < len__5726__auto___17919)){
args17866.push((arguments[i__5727__auto___17920]));

var G__17921 = (i__5727__auto___17920 + (1));
i__5727__auto___17920 = G__17921;
continue;
} else {
}
break;
}

var G__17868 = args17866.length;
switch (G__17868) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17866.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17923 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17923,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17923,tc,fc){
return (function (state_17894){
var state_val_17895 = (state_17894[(1)]);
if((state_val_17895 === (7))){
var inst_17890 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
var statearr_17896_17924 = state_17894__$1;
(statearr_17896_17924[(2)] = inst_17890);

(statearr_17896_17924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (1))){
var state_17894__$1 = state_17894;
var statearr_17897_17925 = state_17894__$1;
(statearr_17897_17925[(2)] = null);

(statearr_17897_17925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (4))){
var inst_17871 = (state_17894[(7)]);
var inst_17871__$1 = (state_17894[(2)]);
var inst_17872 = (inst_17871__$1 == null);
var state_17894__$1 = (function (){var statearr_17898 = state_17894;
(statearr_17898[(7)] = inst_17871__$1);

return statearr_17898;
})();
if(cljs.core.truth_(inst_17872)){
var statearr_17899_17926 = state_17894__$1;
(statearr_17899_17926[(1)] = (5));

} else {
var statearr_17900_17927 = state_17894__$1;
(statearr_17900_17927[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (13))){
var state_17894__$1 = state_17894;
var statearr_17901_17928 = state_17894__$1;
(statearr_17901_17928[(2)] = null);

(statearr_17901_17928[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (6))){
var inst_17871 = (state_17894[(7)]);
var inst_17877 = p.call(null,inst_17871);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17877)){
var statearr_17902_17929 = state_17894__$1;
(statearr_17902_17929[(1)] = (9));

} else {
var statearr_17903_17930 = state_17894__$1;
(statearr_17903_17930[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (3))){
var inst_17892 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17894__$1,inst_17892);
} else {
if((state_val_17895 === (12))){
var state_17894__$1 = state_17894;
var statearr_17904_17931 = state_17894__$1;
(statearr_17904_17931[(2)] = null);

(statearr_17904_17931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (2))){
var state_17894__$1 = state_17894;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17894__$1,(4),ch);
} else {
if((state_val_17895 === (11))){
var inst_17871 = (state_17894[(7)]);
var inst_17881 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17894__$1,(8),inst_17881,inst_17871);
} else {
if((state_val_17895 === (9))){
var state_17894__$1 = state_17894;
var statearr_17905_17932 = state_17894__$1;
(statearr_17905_17932[(2)] = tc);

(statearr_17905_17932[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (5))){
var inst_17874 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17875 = cljs.core.async.close_BANG_.call(null,fc);
var state_17894__$1 = (function (){var statearr_17906 = state_17894;
(statearr_17906[(8)] = inst_17874);

return statearr_17906;
})();
var statearr_17907_17933 = state_17894__$1;
(statearr_17907_17933[(2)] = inst_17875);

(statearr_17907_17933[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (14))){
var inst_17888 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
var statearr_17908_17934 = state_17894__$1;
(statearr_17908_17934[(2)] = inst_17888);

(statearr_17908_17934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (10))){
var state_17894__$1 = state_17894;
var statearr_17909_17935 = state_17894__$1;
(statearr_17909_17935[(2)] = fc);

(statearr_17909_17935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17895 === (8))){
var inst_17883 = (state_17894[(2)]);
var state_17894__$1 = state_17894;
if(cljs.core.truth_(inst_17883)){
var statearr_17910_17936 = state_17894__$1;
(statearr_17910_17936[(1)] = (12));

} else {
var statearr_17911_17937 = state_17894__$1;
(statearr_17911_17937[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17923,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17923,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17915 = [null,null,null,null,null,null,null,null,null];
(statearr_17915[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17915[(1)] = (1));

return statearr_17915;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17894){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17894);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17916){if((e17916 instanceof Object)){
var ex__8254__auto__ = e17916;
var statearr_17917_17938 = state_17894;
(statearr_17917_17938[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17894);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17916;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17939 = state_17894;
state_17894 = G__17939;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17894){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17923,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17918 = f__8363__auto__.call(null);
(statearr_17918[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17923);

return statearr_17918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17923,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18003){
var state_val_18004 = (state_18003[(1)]);
if((state_val_18004 === (7))){
var inst_17999 = (state_18003[(2)]);
var state_18003__$1 = state_18003;
var statearr_18005_18026 = state_18003__$1;
(statearr_18005_18026[(2)] = inst_17999);

(statearr_18005_18026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (1))){
var inst_17983 = init;
var state_18003__$1 = (function (){var statearr_18006 = state_18003;
(statearr_18006[(7)] = inst_17983);

return statearr_18006;
})();
var statearr_18007_18027 = state_18003__$1;
(statearr_18007_18027[(2)] = null);

(statearr_18007_18027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (4))){
var inst_17986 = (state_18003[(8)]);
var inst_17986__$1 = (state_18003[(2)]);
var inst_17987 = (inst_17986__$1 == null);
var state_18003__$1 = (function (){var statearr_18008 = state_18003;
(statearr_18008[(8)] = inst_17986__$1);

return statearr_18008;
})();
if(cljs.core.truth_(inst_17987)){
var statearr_18009_18028 = state_18003__$1;
(statearr_18009_18028[(1)] = (5));

} else {
var statearr_18010_18029 = state_18003__$1;
(statearr_18010_18029[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (6))){
var inst_17986 = (state_18003[(8)]);
var inst_17990 = (state_18003[(9)]);
var inst_17983 = (state_18003[(7)]);
var inst_17990__$1 = f.call(null,inst_17983,inst_17986);
var inst_17991 = cljs.core.reduced_QMARK_.call(null,inst_17990__$1);
var state_18003__$1 = (function (){var statearr_18011 = state_18003;
(statearr_18011[(9)] = inst_17990__$1);

return statearr_18011;
})();
if(inst_17991){
var statearr_18012_18030 = state_18003__$1;
(statearr_18012_18030[(1)] = (8));

} else {
var statearr_18013_18031 = state_18003__$1;
(statearr_18013_18031[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (3))){
var inst_18001 = (state_18003[(2)]);
var state_18003__$1 = state_18003;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18003__$1,inst_18001);
} else {
if((state_val_18004 === (2))){
var state_18003__$1 = state_18003;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18003__$1,(4),ch);
} else {
if((state_val_18004 === (9))){
var inst_17990 = (state_18003[(9)]);
var inst_17983 = inst_17990;
var state_18003__$1 = (function (){var statearr_18014 = state_18003;
(statearr_18014[(7)] = inst_17983);

return statearr_18014;
})();
var statearr_18015_18032 = state_18003__$1;
(statearr_18015_18032[(2)] = null);

(statearr_18015_18032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (5))){
var inst_17983 = (state_18003[(7)]);
var state_18003__$1 = state_18003;
var statearr_18016_18033 = state_18003__$1;
(statearr_18016_18033[(2)] = inst_17983);

(statearr_18016_18033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (10))){
var inst_17997 = (state_18003[(2)]);
var state_18003__$1 = state_18003;
var statearr_18017_18034 = state_18003__$1;
(statearr_18017_18034[(2)] = inst_17997);

(statearr_18017_18034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18004 === (8))){
var inst_17990 = (state_18003[(9)]);
var inst_17993 = cljs.core.deref.call(null,inst_17990);
var state_18003__$1 = state_18003;
var statearr_18018_18035 = state_18003__$1;
(statearr_18018_18035[(2)] = inst_17993);

(statearr_18018_18035[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18022 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18022[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18022[(1)] = (1));

return statearr_18022;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_18003){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18003);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18023){if((e18023 instanceof Object)){
var ex__8254__auto__ = e18023;
var statearr_18024_18036 = state_18003;
(statearr_18024_18036[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18003);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18023;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18037 = state_18003;
state_18003 = G__18037;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_18003){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_18003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18025 = f__8363__auto__.call(null);
(statearr_18025[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18038 = [];
var len__5726__auto___18090 = arguments.length;
var i__5727__auto___18091 = (0);
while(true){
if((i__5727__auto___18091 < len__5726__auto___18090)){
args18038.push((arguments[i__5727__auto___18091]));

var G__18092 = (i__5727__auto___18091 + (1));
i__5727__auto___18091 = G__18092;
continue;
} else {
}
break;
}

var G__18040 = args18038.length;
switch (G__18040) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18038.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18065){
var state_val_18066 = (state_18065[(1)]);
if((state_val_18066 === (7))){
var inst_18047 = (state_18065[(2)]);
var state_18065__$1 = state_18065;
var statearr_18067_18094 = state_18065__$1;
(statearr_18067_18094[(2)] = inst_18047);

(statearr_18067_18094[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (1))){
var inst_18041 = cljs.core.seq.call(null,coll);
var inst_18042 = inst_18041;
var state_18065__$1 = (function (){var statearr_18068 = state_18065;
(statearr_18068[(7)] = inst_18042);

return statearr_18068;
})();
var statearr_18069_18095 = state_18065__$1;
(statearr_18069_18095[(2)] = null);

(statearr_18069_18095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (4))){
var inst_18042 = (state_18065[(7)]);
var inst_18045 = cljs.core.first.call(null,inst_18042);
var state_18065__$1 = state_18065;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18065__$1,(7),ch,inst_18045);
} else {
if((state_val_18066 === (13))){
var inst_18059 = (state_18065[(2)]);
var state_18065__$1 = state_18065;
var statearr_18070_18096 = state_18065__$1;
(statearr_18070_18096[(2)] = inst_18059);

(statearr_18070_18096[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (6))){
var inst_18050 = (state_18065[(2)]);
var state_18065__$1 = state_18065;
if(cljs.core.truth_(inst_18050)){
var statearr_18071_18097 = state_18065__$1;
(statearr_18071_18097[(1)] = (8));

} else {
var statearr_18072_18098 = state_18065__$1;
(statearr_18072_18098[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (3))){
var inst_18063 = (state_18065[(2)]);
var state_18065__$1 = state_18065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18065__$1,inst_18063);
} else {
if((state_val_18066 === (12))){
var state_18065__$1 = state_18065;
var statearr_18073_18099 = state_18065__$1;
(statearr_18073_18099[(2)] = null);

(statearr_18073_18099[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (2))){
var inst_18042 = (state_18065[(7)]);
var state_18065__$1 = state_18065;
if(cljs.core.truth_(inst_18042)){
var statearr_18074_18100 = state_18065__$1;
(statearr_18074_18100[(1)] = (4));

} else {
var statearr_18075_18101 = state_18065__$1;
(statearr_18075_18101[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (11))){
var inst_18056 = cljs.core.async.close_BANG_.call(null,ch);
var state_18065__$1 = state_18065;
var statearr_18076_18102 = state_18065__$1;
(statearr_18076_18102[(2)] = inst_18056);

(statearr_18076_18102[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (9))){
var state_18065__$1 = state_18065;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18077_18103 = state_18065__$1;
(statearr_18077_18103[(1)] = (11));

} else {
var statearr_18078_18104 = state_18065__$1;
(statearr_18078_18104[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (5))){
var inst_18042 = (state_18065[(7)]);
var state_18065__$1 = state_18065;
var statearr_18079_18105 = state_18065__$1;
(statearr_18079_18105[(2)] = inst_18042);

(statearr_18079_18105[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (10))){
var inst_18061 = (state_18065[(2)]);
var state_18065__$1 = state_18065;
var statearr_18080_18106 = state_18065__$1;
(statearr_18080_18106[(2)] = inst_18061);

(statearr_18080_18106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18066 === (8))){
var inst_18042 = (state_18065[(7)]);
var inst_18052 = cljs.core.next.call(null,inst_18042);
var inst_18042__$1 = inst_18052;
var state_18065__$1 = (function (){var statearr_18081 = state_18065;
(statearr_18081[(7)] = inst_18042__$1);

return statearr_18081;
})();
var statearr_18082_18107 = state_18065__$1;
(statearr_18082_18107[(2)] = null);

(statearr_18082_18107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18086 = [null,null,null,null,null,null,null,null];
(statearr_18086[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18086[(1)] = (1));

return statearr_18086;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18065){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18087){if((e18087 instanceof Object)){
var ex__8254__auto__ = e18087;
var statearr_18088_18108 = state_18065;
(statearr_18088_18108[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18065);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18087;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18109 = state_18065;
state_18065 = G__18109;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18065){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18089 = f__8363__auto__.call(null);
(statearr_18089[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18331 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18331 = (function (mult,ch,cs,meta18332){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18332 = meta18332;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18331.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18333,meta18332__$1){
var self__ = this;
var _18333__$1 = this;
return (new cljs.core.async.t_cljs$core$async18331(self__.mult,self__.ch,self__.cs,meta18332__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18331.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18333){
var self__ = this;
var _18333__$1 = this;
return self__.meta18332;
});})(cs))
;

cljs.core.async.t_cljs$core$async18331.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18331.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18331.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18331.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18331.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18331.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18331.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18332","meta18332",1183028412,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18331.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18331.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18331";

cljs.core.async.t_cljs$core$async18331.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18331");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18331 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18331(mult__$1,ch__$1,cs__$1,meta18332){
return (new cljs.core.async.t_cljs$core$async18331(mult__$1,ch__$1,cs__$1,meta18332));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18331(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18552 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18552,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18552,cs,m,dchan,dctr,done){
return (function (state_18464){
var state_val_18465 = (state_18464[(1)]);
if((state_val_18465 === (7))){
var inst_18460 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18466_18553 = state_18464__$1;
(statearr_18466_18553[(2)] = inst_18460);

(statearr_18466_18553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (20))){
var inst_18365 = (state_18464[(7)]);
var inst_18375 = cljs.core.first.call(null,inst_18365);
var inst_18376 = cljs.core.nth.call(null,inst_18375,(0),null);
var inst_18377 = cljs.core.nth.call(null,inst_18375,(1),null);
var state_18464__$1 = (function (){var statearr_18467 = state_18464;
(statearr_18467[(8)] = inst_18376);

return statearr_18467;
})();
if(cljs.core.truth_(inst_18377)){
var statearr_18468_18554 = state_18464__$1;
(statearr_18468_18554[(1)] = (22));

} else {
var statearr_18469_18555 = state_18464__$1;
(statearr_18469_18555[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (27))){
var inst_18412 = (state_18464[(9)]);
var inst_18405 = (state_18464[(10)]);
var inst_18336 = (state_18464[(11)]);
var inst_18407 = (state_18464[(12)]);
var inst_18412__$1 = cljs.core._nth.call(null,inst_18405,inst_18407);
var inst_18413 = cljs.core.async.put_BANG_.call(null,inst_18412__$1,inst_18336,done);
var state_18464__$1 = (function (){var statearr_18470 = state_18464;
(statearr_18470[(9)] = inst_18412__$1);

return statearr_18470;
})();
if(cljs.core.truth_(inst_18413)){
var statearr_18471_18556 = state_18464__$1;
(statearr_18471_18556[(1)] = (30));

} else {
var statearr_18472_18557 = state_18464__$1;
(statearr_18472_18557[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (1))){
var state_18464__$1 = state_18464;
var statearr_18473_18558 = state_18464__$1;
(statearr_18473_18558[(2)] = null);

(statearr_18473_18558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (24))){
var inst_18365 = (state_18464[(7)]);
var inst_18382 = (state_18464[(2)]);
var inst_18383 = cljs.core.next.call(null,inst_18365);
var inst_18345 = inst_18383;
var inst_18346 = null;
var inst_18347 = (0);
var inst_18348 = (0);
var state_18464__$1 = (function (){var statearr_18474 = state_18464;
(statearr_18474[(13)] = inst_18382);

(statearr_18474[(14)] = inst_18345);

(statearr_18474[(15)] = inst_18347);

(statearr_18474[(16)] = inst_18348);

(statearr_18474[(17)] = inst_18346);

return statearr_18474;
})();
var statearr_18475_18559 = state_18464__$1;
(statearr_18475_18559[(2)] = null);

(statearr_18475_18559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (39))){
var state_18464__$1 = state_18464;
var statearr_18479_18560 = state_18464__$1;
(statearr_18479_18560[(2)] = null);

(statearr_18479_18560[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (4))){
var inst_18336 = (state_18464[(11)]);
var inst_18336__$1 = (state_18464[(2)]);
var inst_18337 = (inst_18336__$1 == null);
var state_18464__$1 = (function (){var statearr_18480 = state_18464;
(statearr_18480[(11)] = inst_18336__$1);

return statearr_18480;
})();
if(cljs.core.truth_(inst_18337)){
var statearr_18481_18561 = state_18464__$1;
(statearr_18481_18561[(1)] = (5));

} else {
var statearr_18482_18562 = state_18464__$1;
(statearr_18482_18562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (15))){
var inst_18345 = (state_18464[(14)]);
var inst_18347 = (state_18464[(15)]);
var inst_18348 = (state_18464[(16)]);
var inst_18346 = (state_18464[(17)]);
var inst_18361 = (state_18464[(2)]);
var inst_18362 = (inst_18348 + (1));
var tmp18476 = inst_18345;
var tmp18477 = inst_18347;
var tmp18478 = inst_18346;
var inst_18345__$1 = tmp18476;
var inst_18346__$1 = tmp18478;
var inst_18347__$1 = tmp18477;
var inst_18348__$1 = inst_18362;
var state_18464__$1 = (function (){var statearr_18483 = state_18464;
(statearr_18483[(18)] = inst_18361);

(statearr_18483[(14)] = inst_18345__$1);

(statearr_18483[(15)] = inst_18347__$1);

(statearr_18483[(16)] = inst_18348__$1);

(statearr_18483[(17)] = inst_18346__$1);

return statearr_18483;
})();
var statearr_18484_18563 = state_18464__$1;
(statearr_18484_18563[(2)] = null);

(statearr_18484_18563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (21))){
var inst_18386 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18488_18564 = state_18464__$1;
(statearr_18488_18564[(2)] = inst_18386);

(statearr_18488_18564[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (31))){
var inst_18412 = (state_18464[(9)]);
var inst_18416 = done.call(null,null);
var inst_18417 = cljs.core.async.untap_STAR_.call(null,m,inst_18412);
var state_18464__$1 = (function (){var statearr_18489 = state_18464;
(statearr_18489[(19)] = inst_18416);

return statearr_18489;
})();
var statearr_18490_18565 = state_18464__$1;
(statearr_18490_18565[(2)] = inst_18417);

(statearr_18490_18565[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (32))){
var inst_18404 = (state_18464[(20)]);
var inst_18406 = (state_18464[(21)]);
var inst_18405 = (state_18464[(10)]);
var inst_18407 = (state_18464[(12)]);
var inst_18419 = (state_18464[(2)]);
var inst_18420 = (inst_18407 + (1));
var tmp18485 = inst_18404;
var tmp18486 = inst_18406;
var tmp18487 = inst_18405;
var inst_18404__$1 = tmp18485;
var inst_18405__$1 = tmp18487;
var inst_18406__$1 = tmp18486;
var inst_18407__$1 = inst_18420;
var state_18464__$1 = (function (){var statearr_18491 = state_18464;
(statearr_18491[(20)] = inst_18404__$1);

(statearr_18491[(21)] = inst_18406__$1);

(statearr_18491[(22)] = inst_18419);

(statearr_18491[(10)] = inst_18405__$1);

(statearr_18491[(12)] = inst_18407__$1);

return statearr_18491;
})();
var statearr_18492_18566 = state_18464__$1;
(statearr_18492_18566[(2)] = null);

(statearr_18492_18566[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (40))){
var inst_18432 = (state_18464[(23)]);
var inst_18436 = done.call(null,null);
var inst_18437 = cljs.core.async.untap_STAR_.call(null,m,inst_18432);
var state_18464__$1 = (function (){var statearr_18493 = state_18464;
(statearr_18493[(24)] = inst_18436);

return statearr_18493;
})();
var statearr_18494_18567 = state_18464__$1;
(statearr_18494_18567[(2)] = inst_18437);

(statearr_18494_18567[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (33))){
var inst_18423 = (state_18464[(25)]);
var inst_18425 = cljs.core.chunked_seq_QMARK_.call(null,inst_18423);
var state_18464__$1 = state_18464;
if(inst_18425){
var statearr_18495_18568 = state_18464__$1;
(statearr_18495_18568[(1)] = (36));

} else {
var statearr_18496_18569 = state_18464__$1;
(statearr_18496_18569[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (13))){
var inst_18355 = (state_18464[(26)]);
var inst_18358 = cljs.core.async.close_BANG_.call(null,inst_18355);
var state_18464__$1 = state_18464;
var statearr_18497_18570 = state_18464__$1;
(statearr_18497_18570[(2)] = inst_18358);

(statearr_18497_18570[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (22))){
var inst_18376 = (state_18464[(8)]);
var inst_18379 = cljs.core.async.close_BANG_.call(null,inst_18376);
var state_18464__$1 = state_18464;
var statearr_18498_18571 = state_18464__$1;
(statearr_18498_18571[(2)] = inst_18379);

(statearr_18498_18571[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (36))){
var inst_18423 = (state_18464[(25)]);
var inst_18427 = cljs.core.chunk_first.call(null,inst_18423);
var inst_18428 = cljs.core.chunk_rest.call(null,inst_18423);
var inst_18429 = cljs.core.count.call(null,inst_18427);
var inst_18404 = inst_18428;
var inst_18405 = inst_18427;
var inst_18406 = inst_18429;
var inst_18407 = (0);
var state_18464__$1 = (function (){var statearr_18499 = state_18464;
(statearr_18499[(20)] = inst_18404);

(statearr_18499[(21)] = inst_18406);

(statearr_18499[(10)] = inst_18405);

(statearr_18499[(12)] = inst_18407);

return statearr_18499;
})();
var statearr_18500_18572 = state_18464__$1;
(statearr_18500_18572[(2)] = null);

(statearr_18500_18572[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (41))){
var inst_18423 = (state_18464[(25)]);
var inst_18439 = (state_18464[(2)]);
var inst_18440 = cljs.core.next.call(null,inst_18423);
var inst_18404 = inst_18440;
var inst_18405 = null;
var inst_18406 = (0);
var inst_18407 = (0);
var state_18464__$1 = (function (){var statearr_18501 = state_18464;
(statearr_18501[(27)] = inst_18439);

(statearr_18501[(20)] = inst_18404);

(statearr_18501[(21)] = inst_18406);

(statearr_18501[(10)] = inst_18405);

(statearr_18501[(12)] = inst_18407);

return statearr_18501;
})();
var statearr_18502_18573 = state_18464__$1;
(statearr_18502_18573[(2)] = null);

(statearr_18502_18573[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (43))){
var state_18464__$1 = state_18464;
var statearr_18503_18574 = state_18464__$1;
(statearr_18503_18574[(2)] = null);

(statearr_18503_18574[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (29))){
var inst_18448 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18504_18575 = state_18464__$1;
(statearr_18504_18575[(2)] = inst_18448);

(statearr_18504_18575[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (44))){
var inst_18457 = (state_18464[(2)]);
var state_18464__$1 = (function (){var statearr_18505 = state_18464;
(statearr_18505[(28)] = inst_18457);

return statearr_18505;
})();
var statearr_18506_18576 = state_18464__$1;
(statearr_18506_18576[(2)] = null);

(statearr_18506_18576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (6))){
var inst_18396 = (state_18464[(29)]);
var inst_18395 = cljs.core.deref.call(null,cs);
var inst_18396__$1 = cljs.core.keys.call(null,inst_18395);
var inst_18397 = cljs.core.count.call(null,inst_18396__$1);
var inst_18398 = cljs.core.reset_BANG_.call(null,dctr,inst_18397);
var inst_18403 = cljs.core.seq.call(null,inst_18396__$1);
var inst_18404 = inst_18403;
var inst_18405 = null;
var inst_18406 = (0);
var inst_18407 = (0);
var state_18464__$1 = (function (){var statearr_18507 = state_18464;
(statearr_18507[(29)] = inst_18396__$1);

(statearr_18507[(30)] = inst_18398);

(statearr_18507[(20)] = inst_18404);

(statearr_18507[(21)] = inst_18406);

(statearr_18507[(10)] = inst_18405);

(statearr_18507[(12)] = inst_18407);

return statearr_18507;
})();
var statearr_18508_18577 = state_18464__$1;
(statearr_18508_18577[(2)] = null);

(statearr_18508_18577[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (28))){
var inst_18404 = (state_18464[(20)]);
var inst_18423 = (state_18464[(25)]);
var inst_18423__$1 = cljs.core.seq.call(null,inst_18404);
var state_18464__$1 = (function (){var statearr_18509 = state_18464;
(statearr_18509[(25)] = inst_18423__$1);

return statearr_18509;
})();
if(inst_18423__$1){
var statearr_18510_18578 = state_18464__$1;
(statearr_18510_18578[(1)] = (33));

} else {
var statearr_18511_18579 = state_18464__$1;
(statearr_18511_18579[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (25))){
var inst_18406 = (state_18464[(21)]);
var inst_18407 = (state_18464[(12)]);
var inst_18409 = (inst_18407 < inst_18406);
var inst_18410 = inst_18409;
var state_18464__$1 = state_18464;
if(cljs.core.truth_(inst_18410)){
var statearr_18512_18580 = state_18464__$1;
(statearr_18512_18580[(1)] = (27));

} else {
var statearr_18513_18581 = state_18464__$1;
(statearr_18513_18581[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (34))){
var state_18464__$1 = state_18464;
var statearr_18514_18582 = state_18464__$1;
(statearr_18514_18582[(2)] = null);

(statearr_18514_18582[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (17))){
var state_18464__$1 = state_18464;
var statearr_18515_18583 = state_18464__$1;
(statearr_18515_18583[(2)] = null);

(statearr_18515_18583[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (3))){
var inst_18462 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18464__$1,inst_18462);
} else {
if((state_val_18465 === (12))){
var inst_18391 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18516_18584 = state_18464__$1;
(statearr_18516_18584[(2)] = inst_18391);

(statearr_18516_18584[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (2))){
var state_18464__$1 = state_18464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18464__$1,(4),ch);
} else {
if((state_val_18465 === (23))){
var state_18464__$1 = state_18464;
var statearr_18517_18585 = state_18464__$1;
(statearr_18517_18585[(2)] = null);

(statearr_18517_18585[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (35))){
var inst_18446 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18518_18586 = state_18464__$1;
(statearr_18518_18586[(2)] = inst_18446);

(statearr_18518_18586[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (19))){
var inst_18365 = (state_18464[(7)]);
var inst_18369 = cljs.core.chunk_first.call(null,inst_18365);
var inst_18370 = cljs.core.chunk_rest.call(null,inst_18365);
var inst_18371 = cljs.core.count.call(null,inst_18369);
var inst_18345 = inst_18370;
var inst_18346 = inst_18369;
var inst_18347 = inst_18371;
var inst_18348 = (0);
var state_18464__$1 = (function (){var statearr_18519 = state_18464;
(statearr_18519[(14)] = inst_18345);

(statearr_18519[(15)] = inst_18347);

(statearr_18519[(16)] = inst_18348);

(statearr_18519[(17)] = inst_18346);

return statearr_18519;
})();
var statearr_18520_18587 = state_18464__$1;
(statearr_18520_18587[(2)] = null);

(statearr_18520_18587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (11))){
var inst_18365 = (state_18464[(7)]);
var inst_18345 = (state_18464[(14)]);
var inst_18365__$1 = cljs.core.seq.call(null,inst_18345);
var state_18464__$1 = (function (){var statearr_18521 = state_18464;
(statearr_18521[(7)] = inst_18365__$1);

return statearr_18521;
})();
if(inst_18365__$1){
var statearr_18522_18588 = state_18464__$1;
(statearr_18522_18588[(1)] = (16));

} else {
var statearr_18523_18589 = state_18464__$1;
(statearr_18523_18589[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (9))){
var inst_18393 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18524_18590 = state_18464__$1;
(statearr_18524_18590[(2)] = inst_18393);

(statearr_18524_18590[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (5))){
var inst_18343 = cljs.core.deref.call(null,cs);
var inst_18344 = cljs.core.seq.call(null,inst_18343);
var inst_18345 = inst_18344;
var inst_18346 = null;
var inst_18347 = (0);
var inst_18348 = (0);
var state_18464__$1 = (function (){var statearr_18525 = state_18464;
(statearr_18525[(14)] = inst_18345);

(statearr_18525[(15)] = inst_18347);

(statearr_18525[(16)] = inst_18348);

(statearr_18525[(17)] = inst_18346);

return statearr_18525;
})();
var statearr_18526_18591 = state_18464__$1;
(statearr_18526_18591[(2)] = null);

(statearr_18526_18591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (14))){
var state_18464__$1 = state_18464;
var statearr_18527_18592 = state_18464__$1;
(statearr_18527_18592[(2)] = null);

(statearr_18527_18592[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (45))){
var inst_18454 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18528_18593 = state_18464__$1;
(statearr_18528_18593[(2)] = inst_18454);

(statearr_18528_18593[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (26))){
var inst_18396 = (state_18464[(29)]);
var inst_18450 = (state_18464[(2)]);
var inst_18451 = cljs.core.seq.call(null,inst_18396);
var state_18464__$1 = (function (){var statearr_18529 = state_18464;
(statearr_18529[(31)] = inst_18450);

return statearr_18529;
})();
if(inst_18451){
var statearr_18530_18594 = state_18464__$1;
(statearr_18530_18594[(1)] = (42));

} else {
var statearr_18531_18595 = state_18464__$1;
(statearr_18531_18595[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (16))){
var inst_18365 = (state_18464[(7)]);
var inst_18367 = cljs.core.chunked_seq_QMARK_.call(null,inst_18365);
var state_18464__$1 = state_18464;
if(inst_18367){
var statearr_18532_18596 = state_18464__$1;
(statearr_18532_18596[(1)] = (19));

} else {
var statearr_18533_18597 = state_18464__$1;
(statearr_18533_18597[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (38))){
var inst_18443 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18534_18598 = state_18464__$1;
(statearr_18534_18598[(2)] = inst_18443);

(statearr_18534_18598[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (30))){
var state_18464__$1 = state_18464;
var statearr_18535_18599 = state_18464__$1;
(statearr_18535_18599[(2)] = null);

(statearr_18535_18599[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (10))){
var inst_18348 = (state_18464[(16)]);
var inst_18346 = (state_18464[(17)]);
var inst_18354 = cljs.core._nth.call(null,inst_18346,inst_18348);
var inst_18355 = cljs.core.nth.call(null,inst_18354,(0),null);
var inst_18356 = cljs.core.nth.call(null,inst_18354,(1),null);
var state_18464__$1 = (function (){var statearr_18536 = state_18464;
(statearr_18536[(26)] = inst_18355);

return statearr_18536;
})();
if(cljs.core.truth_(inst_18356)){
var statearr_18537_18600 = state_18464__$1;
(statearr_18537_18600[(1)] = (13));

} else {
var statearr_18538_18601 = state_18464__$1;
(statearr_18538_18601[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (18))){
var inst_18389 = (state_18464[(2)]);
var state_18464__$1 = state_18464;
var statearr_18539_18602 = state_18464__$1;
(statearr_18539_18602[(2)] = inst_18389);

(statearr_18539_18602[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (42))){
var state_18464__$1 = state_18464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18464__$1,(45),dchan);
} else {
if((state_val_18465 === (37))){
var inst_18432 = (state_18464[(23)]);
var inst_18336 = (state_18464[(11)]);
var inst_18423 = (state_18464[(25)]);
var inst_18432__$1 = cljs.core.first.call(null,inst_18423);
var inst_18433 = cljs.core.async.put_BANG_.call(null,inst_18432__$1,inst_18336,done);
var state_18464__$1 = (function (){var statearr_18540 = state_18464;
(statearr_18540[(23)] = inst_18432__$1);

return statearr_18540;
})();
if(cljs.core.truth_(inst_18433)){
var statearr_18541_18603 = state_18464__$1;
(statearr_18541_18603[(1)] = (39));

} else {
var statearr_18542_18604 = state_18464__$1;
(statearr_18542_18604[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18465 === (8))){
var inst_18347 = (state_18464[(15)]);
var inst_18348 = (state_18464[(16)]);
var inst_18350 = (inst_18348 < inst_18347);
var inst_18351 = inst_18350;
var state_18464__$1 = state_18464;
if(cljs.core.truth_(inst_18351)){
var statearr_18543_18605 = state_18464__$1;
(statearr_18543_18605[(1)] = (10));

} else {
var statearr_18544_18606 = state_18464__$1;
(statearr_18544_18606[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18552,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18552,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18548[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18548[(1)] = (1));

return statearr_18548;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18464){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18549){if((e18549 instanceof Object)){
var ex__8254__auto__ = e18549;
var statearr_18550_18607 = state_18464;
(statearr_18550_18607[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18549;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18608 = state_18464;
state_18464 = G__18608;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18464){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18552,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18551 = f__8363__auto__.call(null);
(statearr_18551[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18552);

return statearr_18551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18552,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18609 = [];
var len__5726__auto___18612 = arguments.length;
var i__5727__auto___18613 = (0);
while(true){
if((i__5727__auto___18613 < len__5726__auto___18612)){
args18609.push((arguments[i__5727__auto___18613]));

var G__18614 = (i__5727__auto___18613 + (1));
i__5727__auto___18613 = G__18614;
continue;
} else {
}
break;
}

var G__18611 = args18609.length;
switch (G__18611) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18609.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18626 = arguments.length;
var i__5727__auto___18627 = (0);
while(true){
if((i__5727__auto___18627 < len__5726__auto___18626)){
args__5733__auto__.push((arguments[i__5727__auto___18627]));

var G__18628 = (i__5727__auto___18627 + (1));
i__5727__auto___18627 = G__18628;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18620){
var map__18621 = p__18620;
var map__18621__$1 = ((((!((map__18621 == null)))?((((map__18621.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18621.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18621):map__18621);
var opts = map__18621__$1;
var statearr_18623_18629 = state;
(statearr_18623_18629[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18621,map__18621__$1,opts){
return (function (val){
var statearr_18624_18630 = state;
(statearr_18624_18630[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18621,map__18621__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18625_18631 = state;
(statearr_18625_18631[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18616){
var G__18617 = cljs.core.first.call(null,seq18616);
var seq18616__$1 = cljs.core.next.call(null,seq18616);
var G__18618 = cljs.core.first.call(null,seq18616__$1);
var seq18616__$2 = cljs.core.next.call(null,seq18616__$1);
var G__18619 = cljs.core.first.call(null,seq18616__$2);
var seq18616__$3 = cljs.core.next.call(null,seq18616__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18617,G__18618,G__18619,seq18616__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18795 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18795 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18796){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18796 = meta18796;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18797,meta18796__$1){
var self__ = this;
var _18797__$1 = this;
return (new cljs.core.async.t_cljs$core$async18795(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18796__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18797){
var self__ = this;
var _18797__$1 = this;
return self__.meta18796;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18796","meta18796",-581927718,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18795.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18795.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18795";

cljs.core.async.t_cljs$core$async18795.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18795");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18795 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18795(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18796){
return (new cljs.core.async.t_cljs$core$async18795(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18796));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18795(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___18958 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18958,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18958,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18895){
var state_val_18896 = (state_18895[(1)]);
if((state_val_18896 === (7))){
var inst_18813 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
var statearr_18897_18959 = state_18895__$1;
(statearr_18897_18959[(2)] = inst_18813);

(statearr_18897_18959[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (20))){
var inst_18825 = (state_18895[(7)]);
var state_18895__$1 = state_18895;
var statearr_18898_18960 = state_18895__$1;
(statearr_18898_18960[(2)] = inst_18825);

(statearr_18898_18960[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (27))){
var state_18895__$1 = state_18895;
var statearr_18899_18961 = state_18895__$1;
(statearr_18899_18961[(2)] = null);

(statearr_18899_18961[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (1))){
var inst_18801 = (state_18895[(8)]);
var inst_18801__$1 = calc_state.call(null);
var inst_18803 = (inst_18801__$1 == null);
var inst_18804 = cljs.core.not.call(null,inst_18803);
var state_18895__$1 = (function (){var statearr_18900 = state_18895;
(statearr_18900[(8)] = inst_18801__$1);

return statearr_18900;
})();
if(inst_18804){
var statearr_18901_18962 = state_18895__$1;
(statearr_18901_18962[(1)] = (2));

} else {
var statearr_18902_18963 = state_18895__$1;
(statearr_18902_18963[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (24))){
var inst_18855 = (state_18895[(9)]);
var inst_18848 = (state_18895[(10)]);
var inst_18869 = (state_18895[(11)]);
var inst_18869__$1 = inst_18848.call(null,inst_18855);
var state_18895__$1 = (function (){var statearr_18903 = state_18895;
(statearr_18903[(11)] = inst_18869__$1);

return statearr_18903;
})();
if(cljs.core.truth_(inst_18869__$1)){
var statearr_18904_18964 = state_18895__$1;
(statearr_18904_18964[(1)] = (29));

} else {
var statearr_18905_18965 = state_18895__$1;
(statearr_18905_18965[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (4))){
var inst_18816 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
if(cljs.core.truth_(inst_18816)){
var statearr_18906_18966 = state_18895__$1;
(statearr_18906_18966[(1)] = (8));

} else {
var statearr_18907_18967 = state_18895__$1;
(statearr_18907_18967[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (15))){
var inst_18842 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
if(cljs.core.truth_(inst_18842)){
var statearr_18908_18968 = state_18895__$1;
(statearr_18908_18968[(1)] = (19));

} else {
var statearr_18909_18969 = state_18895__$1;
(statearr_18909_18969[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (21))){
var inst_18847 = (state_18895[(12)]);
var inst_18847__$1 = (state_18895[(2)]);
var inst_18848 = cljs.core.get.call(null,inst_18847__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18849 = cljs.core.get.call(null,inst_18847__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18850 = cljs.core.get.call(null,inst_18847__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18895__$1 = (function (){var statearr_18910 = state_18895;
(statearr_18910[(10)] = inst_18848);

(statearr_18910[(13)] = inst_18849);

(statearr_18910[(12)] = inst_18847__$1);

return statearr_18910;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18895__$1,(22),inst_18850);
} else {
if((state_val_18896 === (31))){
var inst_18877 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
if(cljs.core.truth_(inst_18877)){
var statearr_18911_18970 = state_18895__$1;
(statearr_18911_18970[(1)] = (32));

} else {
var statearr_18912_18971 = state_18895__$1;
(statearr_18912_18971[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (32))){
var inst_18854 = (state_18895[(14)]);
var state_18895__$1 = state_18895;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18895__$1,(35),out,inst_18854);
} else {
if((state_val_18896 === (33))){
var inst_18847 = (state_18895[(12)]);
var inst_18825 = inst_18847;
var state_18895__$1 = (function (){var statearr_18913 = state_18895;
(statearr_18913[(7)] = inst_18825);

return statearr_18913;
})();
var statearr_18914_18972 = state_18895__$1;
(statearr_18914_18972[(2)] = null);

(statearr_18914_18972[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (13))){
var inst_18825 = (state_18895[(7)]);
var inst_18832 = inst_18825.cljs$lang$protocol_mask$partition0$;
var inst_18833 = (inst_18832 & (64));
var inst_18834 = inst_18825.cljs$core$ISeq$;
var inst_18835 = (inst_18833) || (inst_18834);
var state_18895__$1 = state_18895;
if(cljs.core.truth_(inst_18835)){
var statearr_18915_18973 = state_18895__$1;
(statearr_18915_18973[(1)] = (16));

} else {
var statearr_18916_18974 = state_18895__$1;
(statearr_18916_18974[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (22))){
var inst_18854 = (state_18895[(14)]);
var inst_18855 = (state_18895[(9)]);
var inst_18853 = (state_18895[(2)]);
var inst_18854__$1 = cljs.core.nth.call(null,inst_18853,(0),null);
var inst_18855__$1 = cljs.core.nth.call(null,inst_18853,(1),null);
var inst_18856 = (inst_18854__$1 == null);
var inst_18857 = cljs.core._EQ_.call(null,inst_18855__$1,change);
var inst_18858 = (inst_18856) || (inst_18857);
var state_18895__$1 = (function (){var statearr_18917 = state_18895;
(statearr_18917[(14)] = inst_18854__$1);

(statearr_18917[(9)] = inst_18855__$1);

return statearr_18917;
})();
if(cljs.core.truth_(inst_18858)){
var statearr_18918_18975 = state_18895__$1;
(statearr_18918_18975[(1)] = (23));

} else {
var statearr_18919_18976 = state_18895__$1;
(statearr_18919_18976[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (36))){
var inst_18847 = (state_18895[(12)]);
var inst_18825 = inst_18847;
var state_18895__$1 = (function (){var statearr_18920 = state_18895;
(statearr_18920[(7)] = inst_18825);

return statearr_18920;
})();
var statearr_18921_18977 = state_18895__$1;
(statearr_18921_18977[(2)] = null);

(statearr_18921_18977[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (29))){
var inst_18869 = (state_18895[(11)]);
var state_18895__$1 = state_18895;
var statearr_18922_18978 = state_18895__$1;
(statearr_18922_18978[(2)] = inst_18869);

(statearr_18922_18978[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (6))){
var state_18895__$1 = state_18895;
var statearr_18923_18979 = state_18895__$1;
(statearr_18923_18979[(2)] = false);

(statearr_18923_18979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (28))){
var inst_18865 = (state_18895[(2)]);
var inst_18866 = calc_state.call(null);
var inst_18825 = inst_18866;
var state_18895__$1 = (function (){var statearr_18924 = state_18895;
(statearr_18924[(15)] = inst_18865);

(statearr_18924[(7)] = inst_18825);

return statearr_18924;
})();
var statearr_18925_18980 = state_18895__$1;
(statearr_18925_18980[(2)] = null);

(statearr_18925_18980[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (25))){
var inst_18891 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
var statearr_18926_18981 = state_18895__$1;
(statearr_18926_18981[(2)] = inst_18891);

(statearr_18926_18981[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (34))){
var inst_18889 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
var statearr_18927_18982 = state_18895__$1;
(statearr_18927_18982[(2)] = inst_18889);

(statearr_18927_18982[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (17))){
var state_18895__$1 = state_18895;
var statearr_18928_18983 = state_18895__$1;
(statearr_18928_18983[(2)] = false);

(statearr_18928_18983[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (3))){
var state_18895__$1 = state_18895;
var statearr_18929_18984 = state_18895__$1;
(statearr_18929_18984[(2)] = false);

(statearr_18929_18984[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (12))){
var inst_18893 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18895__$1,inst_18893);
} else {
if((state_val_18896 === (2))){
var inst_18801 = (state_18895[(8)]);
var inst_18806 = inst_18801.cljs$lang$protocol_mask$partition0$;
var inst_18807 = (inst_18806 & (64));
var inst_18808 = inst_18801.cljs$core$ISeq$;
var inst_18809 = (inst_18807) || (inst_18808);
var state_18895__$1 = state_18895;
if(cljs.core.truth_(inst_18809)){
var statearr_18930_18985 = state_18895__$1;
(statearr_18930_18985[(1)] = (5));

} else {
var statearr_18931_18986 = state_18895__$1;
(statearr_18931_18986[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (23))){
var inst_18854 = (state_18895[(14)]);
var inst_18860 = (inst_18854 == null);
var state_18895__$1 = state_18895;
if(cljs.core.truth_(inst_18860)){
var statearr_18932_18987 = state_18895__$1;
(statearr_18932_18987[(1)] = (26));

} else {
var statearr_18933_18988 = state_18895__$1;
(statearr_18933_18988[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (35))){
var inst_18880 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
if(cljs.core.truth_(inst_18880)){
var statearr_18934_18989 = state_18895__$1;
(statearr_18934_18989[(1)] = (36));

} else {
var statearr_18935_18990 = state_18895__$1;
(statearr_18935_18990[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (19))){
var inst_18825 = (state_18895[(7)]);
var inst_18844 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18825);
var state_18895__$1 = state_18895;
var statearr_18936_18991 = state_18895__$1;
(statearr_18936_18991[(2)] = inst_18844);

(statearr_18936_18991[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (11))){
var inst_18825 = (state_18895[(7)]);
var inst_18829 = (inst_18825 == null);
var inst_18830 = cljs.core.not.call(null,inst_18829);
var state_18895__$1 = state_18895;
if(inst_18830){
var statearr_18937_18992 = state_18895__$1;
(statearr_18937_18992[(1)] = (13));

} else {
var statearr_18938_18993 = state_18895__$1;
(statearr_18938_18993[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (9))){
var inst_18801 = (state_18895[(8)]);
var state_18895__$1 = state_18895;
var statearr_18939_18994 = state_18895__$1;
(statearr_18939_18994[(2)] = inst_18801);

(statearr_18939_18994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (5))){
var state_18895__$1 = state_18895;
var statearr_18940_18995 = state_18895__$1;
(statearr_18940_18995[(2)] = true);

(statearr_18940_18995[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (14))){
var state_18895__$1 = state_18895;
var statearr_18941_18996 = state_18895__$1;
(statearr_18941_18996[(2)] = false);

(statearr_18941_18996[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (26))){
var inst_18855 = (state_18895[(9)]);
var inst_18862 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18855);
var state_18895__$1 = state_18895;
var statearr_18942_18997 = state_18895__$1;
(statearr_18942_18997[(2)] = inst_18862);

(statearr_18942_18997[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (16))){
var state_18895__$1 = state_18895;
var statearr_18943_18998 = state_18895__$1;
(statearr_18943_18998[(2)] = true);

(statearr_18943_18998[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (38))){
var inst_18885 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
var statearr_18944_18999 = state_18895__$1;
(statearr_18944_18999[(2)] = inst_18885);

(statearr_18944_18999[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (30))){
var inst_18855 = (state_18895[(9)]);
var inst_18848 = (state_18895[(10)]);
var inst_18849 = (state_18895[(13)]);
var inst_18872 = cljs.core.empty_QMARK_.call(null,inst_18848);
var inst_18873 = inst_18849.call(null,inst_18855);
var inst_18874 = cljs.core.not.call(null,inst_18873);
var inst_18875 = (inst_18872) && (inst_18874);
var state_18895__$1 = state_18895;
var statearr_18945_19000 = state_18895__$1;
(statearr_18945_19000[(2)] = inst_18875);

(statearr_18945_19000[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (10))){
var inst_18801 = (state_18895[(8)]);
var inst_18821 = (state_18895[(2)]);
var inst_18822 = cljs.core.get.call(null,inst_18821,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18823 = cljs.core.get.call(null,inst_18821,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18824 = cljs.core.get.call(null,inst_18821,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18825 = inst_18801;
var state_18895__$1 = (function (){var statearr_18946 = state_18895;
(statearr_18946[(16)] = inst_18824);

(statearr_18946[(17)] = inst_18823);

(statearr_18946[(18)] = inst_18822);

(statearr_18946[(7)] = inst_18825);

return statearr_18946;
})();
var statearr_18947_19001 = state_18895__$1;
(statearr_18947_19001[(2)] = null);

(statearr_18947_19001[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (18))){
var inst_18839 = (state_18895[(2)]);
var state_18895__$1 = state_18895;
var statearr_18948_19002 = state_18895__$1;
(statearr_18948_19002[(2)] = inst_18839);

(statearr_18948_19002[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (37))){
var state_18895__$1 = state_18895;
var statearr_18949_19003 = state_18895__$1;
(statearr_18949_19003[(2)] = null);

(statearr_18949_19003[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18896 === (8))){
var inst_18801 = (state_18895[(8)]);
var inst_18818 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18801);
var state_18895__$1 = state_18895;
var statearr_18950_19004 = state_18895__$1;
(statearr_18950_19004[(2)] = inst_18818);

(statearr_18950_19004[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18958,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___18958,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_18954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18954[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_18954[(1)] = (1));

return statearr_18954;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18895){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18895);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18955){if((e18955 instanceof Object)){
var ex__8254__auto__ = e18955;
var statearr_18956_19005 = state_18895;
(statearr_18956_19005[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18895);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18955;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19006 = state_18895;
state_18895 = G__19006;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18895){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18958,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_18957 = f__8363__auto__.call(null);
(statearr_18957[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18958);

return statearr_18957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18958,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19007 = [];
var len__5726__auto___19010 = arguments.length;
var i__5727__auto___19011 = (0);
while(true){
if((i__5727__auto___19011 < len__5726__auto___19010)){
args19007.push((arguments[i__5727__auto___19011]));

var G__19012 = (i__5727__auto___19011 + (1));
i__5727__auto___19011 = G__19012;
continue;
} else {
}
break;
}

var G__19009 = args19007.length;
switch (G__19009) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19007.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19015 = [];
var len__5726__auto___19140 = arguments.length;
var i__5727__auto___19141 = (0);
while(true){
if((i__5727__auto___19141 < len__5726__auto___19140)){
args19015.push((arguments[i__5727__auto___19141]));

var G__19142 = (i__5727__auto___19141 + (1));
i__5727__auto___19141 = G__19142;
continue;
} else {
}
break;
}

var G__19017 = args19015.length;
switch (G__19017) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19015.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19014_SHARP_){
if(cljs.core.truth_(p1__19014_SHARP_.call(null,topic))){
return p1__19014_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19014_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19018 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19018 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19019){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19019 = meta19019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19020,meta19019__$1){
var self__ = this;
var _19020__$1 = this;
return (new cljs.core.async.t_cljs$core$async19018(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19019__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19020){
var self__ = this;
var _19020__$1 = this;
return self__.meta19019;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19018.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19018.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19019","meta19019",642495063,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19018.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19018";

cljs.core.async.t_cljs$core$async19018.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19018");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19018 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19018(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19019){
return (new cljs.core.async.t_cljs$core$async19018(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19019));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19018(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19144 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19144,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19144,mults,ensure_mult,p){
return (function (state_19092){
var state_val_19093 = (state_19092[(1)]);
if((state_val_19093 === (7))){
var inst_19088 = (state_19092[(2)]);
var state_19092__$1 = state_19092;
var statearr_19094_19145 = state_19092__$1;
(statearr_19094_19145[(2)] = inst_19088);

(statearr_19094_19145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (20))){
var state_19092__$1 = state_19092;
var statearr_19095_19146 = state_19092__$1;
(statearr_19095_19146[(2)] = null);

(statearr_19095_19146[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (1))){
var state_19092__$1 = state_19092;
var statearr_19096_19147 = state_19092__$1;
(statearr_19096_19147[(2)] = null);

(statearr_19096_19147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (24))){
var inst_19071 = (state_19092[(7)]);
var inst_19080 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19071);
var state_19092__$1 = state_19092;
var statearr_19097_19148 = state_19092__$1;
(statearr_19097_19148[(2)] = inst_19080);

(statearr_19097_19148[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (4))){
var inst_19023 = (state_19092[(8)]);
var inst_19023__$1 = (state_19092[(2)]);
var inst_19024 = (inst_19023__$1 == null);
var state_19092__$1 = (function (){var statearr_19098 = state_19092;
(statearr_19098[(8)] = inst_19023__$1);

return statearr_19098;
})();
if(cljs.core.truth_(inst_19024)){
var statearr_19099_19149 = state_19092__$1;
(statearr_19099_19149[(1)] = (5));

} else {
var statearr_19100_19150 = state_19092__$1;
(statearr_19100_19150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (15))){
var inst_19065 = (state_19092[(2)]);
var state_19092__$1 = state_19092;
var statearr_19101_19151 = state_19092__$1;
(statearr_19101_19151[(2)] = inst_19065);

(statearr_19101_19151[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (21))){
var inst_19085 = (state_19092[(2)]);
var state_19092__$1 = (function (){var statearr_19102 = state_19092;
(statearr_19102[(9)] = inst_19085);

return statearr_19102;
})();
var statearr_19103_19152 = state_19092__$1;
(statearr_19103_19152[(2)] = null);

(statearr_19103_19152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (13))){
var inst_19047 = (state_19092[(10)]);
var inst_19049 = cljs.core.chunked_seq_QMARK_.call(null,inst_19047);
var state_19092__$1 = state_19092;
if(inst_19049){
var statearr_19104_19153 = state_19092__$1;
(statearr_19104_19153[(1)] = (16));

} else {
var statearr_19105_19154 = state_19092__$1;
(statearr_19105_19154[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (22))){
var inst_19077 = (state_19092[(2)]);
var state_19092__$1 = state_19092;
if(cljs.core.truth_(inst_19077)){
var statearr_19106_19155 = state_19092__$1;
(statearr_19106_19155[(1)] = (23));

} else {
var statearr_19107_19156 = state_19092__$1;
(statearr_19107_19156[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (6))){
var inst_19071 = (state_19092[(7)]);
var inst_19073 = (state_19092[(11)]);
var inst_19023 = (state_19092[(8)]);
var inst_19071__$1 = topic_fn.call(null,inst_19023);
var inst_19072 = cljs.core.deref.call(null,mults);
var inst_19073__$1 = cljs.core.get.call(null,inst_19072,inst_19071__$1);
var state_19092__$1 = (function (){var statearr_19108 = state_19092;
(statearr_19108[(7)] = inst_19071__$1);

(statearr_19108[(11)] = inst_19073__$1);

return statearr_19108;
})();
if(cljs.core.truth_(inst_19073__$1)){
var statearr_19109_19157 = state_19092__$1;
(statearr_19109_19157[(1)] = (19));

} else {
var statearr_19110_19158 = state_19092__$1;
(statearr_19110_19158[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (25))){
var inst_19082 = (state_19092[(2)]);
var state_19092__$1 = state_19092;
var statearr_19111_19159 = state_19092__$1;
(statearr_19111_19159[(2)] = inst_19082);

(statearr_19111_19159[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (17))){
var inst_19047 = (state_19092[(10)]);
var inst_19056 = cljs.core.first.call(null,inst_19047);
var inst_19057 = cljs.core.async.muxch_STAR_.call(null,inst_19056);
var inst_19058 = cljs.core.async.close_BANG_.call(null,inst_19057);
var inst_19059 = cljs.core.next.call(null,inst_19047);
var inst_19033 = inst_19059;
var inst_19034 = null;
var inst_19035 = (0);
var inst_19036 = (0);
var state_19092__$1 = (function (){var statearr_19112 = state_19092;
(statearr_19112[(12)] = inst_19034);

(statearr_19112[(13)] = inst_19036);

(statearr_19112[(14)] = inst_19058);

(statearr_19112[(15)] = inst_19035);

(statearr_19112[(16)] = inst_19033);

return statearr_19112;
})();
var statearr_19113_19160 = state_19092__$1;
(statearr_19113_19160[(2)] = null);

(statearr_19113_19160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (3))){
var inst_19090 = (state_19092[(2)]);
var state_19092__$1 = state_19092;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19092__$1,inst_19090);
} else {
if((state_val_19093 === (12))){
var inst_19067 = (state_19092[(2)]);
var state_19092__$1 = state_19092;
var statearr_19114_19161 = state_19092__$1;
(statearr_19114_19161[(2)] = inst_19067);

(statearr_19114_19161[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (2))){
var state_19092__$1 = state_19092;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19092__$1,(4),ch);
} else {
if((state_val_19093 === (23))){
var state_19092__$1 = state_19092;
var statearr_19115_19162 = state_19092__$1;
(statearr_19115_19162[(2)] = null);

(statearr_19115_19162[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (19))){
var inst_19073 = (state_19092[(11)]);
var inst_19023 = (state_19092[(8)]);
var inst_19075 = cljs.core.async.muxch_STAR_.call(null,inst_19073);
var state_19092__$1 = state_19092;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19092__$1,(22),inst_19075,inst_19023);
} else {
if((state_val_19093 === (11))){
var inst_19047 = (state_19092[(10)]);
var inst_19033 = (state_19092[(16)]);
var inst_19047__$1 = cljs.core.seq.call(null,inst_19033);
var state_19092__$1 = (function (){var statearr_19116 = state_19092;
(statearr_19116[(10)] = inst_19047__$1);

return statearr_19116;
})();
if(inst_19047__$1){
var statearr_19117_19163 = state_19092__$1;
(statearr_19117_19163[(1)] = (13));

} else {
var statearr_19118_19164 = state_19092__$1;
(statearr_19118_19164[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (9))){
var inst_19069 = (state_19092[(2)]);
var state_19092__$1 = state_19092;
var statearr_19119_19165 = state_19092__$1;
(statearr_19119_19165[(2)] = inst_19069);

(statearr_19119_19165[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (5))){
var inst_19030 = cljs.core.deref.call(null,mults);
var inst_19031 = cljs.core.vals.call(null,inst_19030);
var inst_19032 = cljs.core.seq.call(null,inst_19031);
var inst_19033 = inst_19032;
var inst_19034 = null;
var inst_19035 = (0);
var inst_19036 = (0);
var state_19092__$1 = (function (){var statearr_19120 = state_19092;
(statearr_19120[(12)] = inst_19034);

(statearr_19120[(13)] = inst_19036);

(statearr_19120[(15)] = inst_19035);

(statearr_19120[(16)] = inst_19033);

return statearr_19120;
})();
var statearr_19121_19166 = state_19092__$1;
(statearr_19121_19166[(2)] = null);

(statearr_19121_19166[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (14))){
var state_19092__$1 = state_19092;
var statearr_19125_19167 = state_19092__$1;
(statearr_19125_19167[(2)] = null);

(statearr_19125_19167[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (16))){
var inst_19047 = (state_19092[(10)]);
var inst_19051 = cljs.core.chunk_first.call(null,inst_19047);
var inst_19052 = cljs.core.chunk_rest.call(null,inst_19047);
var inst_19053 = cljs.core.count.call(null,inst_19051);
var inst_19033 = inst_19052;
var inst_19034 = inst_19051;
var inst_19035 = inst_19053;
var inst_19036 = (0);
var state_19092__$1 = (function (){var statearr_19126 = state_19092;
(statearr_19126[(12)] = inst_19034);

(statearr_19126[(13)] = inst_19036);

(statearr_19126[(15)] = inst_19035);

(statearr_19126[(16)] = inst_19033);

return statearr_19126;
})();
var statearr_19127_19168 = state_19092__$1;
(statearr_19127_19168[(2)] = null);

(statearr_19127_19168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (10))){
var inst_19034 = (state_19092[(12)]);
var inst_19036 = (state_19092[(13)]);
var inst_19035 = (state_19092[(15)]);
var inst_19033 = (state_19092[(16)]);
var inst_19041 = cljs.core._nth.call(null,inst_19034,inst_19036);
var inst_19042 = cljs.core.async.muxch_STAR_.call(null,inst_19041);
var inst_19043 = cljs.core.async.close_BANG_.call(null,inst_19042);
var inst_19044 = (inst_19036 + (1));
var tmp19122 = inst_19034;
var tmp19123 = inst_19035;
var tmp19124 = inst_19033;
var inst_19033__$1 = tmp19124;
var inst_19034__$1 = tmp19122;
var inst_19035__$1 = tmp19123;
var inst_19036__$1 = inst_19044;
var state_19092__$1 = (function (){var statearr_19128 = state_19092;
(statearr_19128[(12)] = inst_19034__$1);

(statearr_19128[(17)] = inst_19043);

(statearr_19128[(13)] = inst_19036__$1);

(statearr_19128[(15)] = inst_19035__$1);

(statearr_19128[(16)] = inst_19033__$1);

return statearr_19128;
})();
var statearr_19129_19169 = state_19092__$1;
(statearr_19129_19169[(2)] = null);

(statearr_19129_19169[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (18))){
var inst_19062 = (state_19092[(2)]);
var state_19092__$1 = state_19092;
var statearr_19130_19170 = state_19092__$1;
(statearr_19130_19170[(2)] = inst_19062);

(statearr_19130_19170[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19093 === (8))){
var inst_19036 = (state_19092[(13)]);
var inst_19035 = (state_19092[(15)]);
var inst_19038 = (inst_19036 < inst_19035);
var inst_19039 = inst_19038;
var state_19092__$1 = state_19092;
if(cljs.core.truth_(inst_19039)){
var statearr_19131_19171 = state_19092__$1;
(statearr_19131_19171[(1)] = (10));

} else {
var statearr_19132_19172 = state_19092__$1;
(statearr_19132_19172[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19144,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19144,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19136 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19136[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19136[(1)] = (1));

return statearr_19136;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19092){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19092);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19137){if((e19137 instanceof Object)){
var ex__8254__auto__ = e19137;
var statearr_19138_19173 = state_19092;
(statearr_19138_19173[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19092);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19137;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19174 = state_19092;
state_19092 = G__19174;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19092){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19144,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19139 = f__8363__auto__.call(null);
(statearr_19139[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19144);

return statearr_19139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19144,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19175 = [];
var len__5726__auto___19178 = arguments.length;
var i__5727__auto___19179 = (0);
while(true){
if((i__5727__auto___19179 < len__5726__auto___19178)){
args19175.push((arguments[i__5727__auto___19179]));

var G__19180 = (i__5727__auto___19179 + (1));
i__5727__auto___19179 = G__19180;
continue;
} else {
}
break;
}

var G__19177 = args19175.length;
switch (G__19177) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19175.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19182 = [];
var len__5726__auto___19185 = arguments.length;
var i__5727__auto___19186 = (0);
while(true){
if((i__5727__auto___19186 < len__5726__auto___19185)){
args19182.push((arguments[i__5727__auto___19186]));

var G__19187 = (i__5727__auto___19186 + (1));
i__5727__auto___19186 = G__19187;
continue;
} else {
}
break;
}

var G__19184 = args19182.length;
switch (G__19184) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19182.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19189 = [];
var len__5726__auto___19260 = arguments.length;
var i__5727__auto___19261 = (0);
while(true){
if((i__5727__auto___19261 < len__5726__auto___19260)){
args19189.push((arguments[i__5727__auto___19261]));

var G__19262 = (i__5727__auto___19261 + (1));
i__5727__auto___19261 = G__19262;
continue;
} else {
}
break;
}

var G__19191 = args19189.length;
switch (G__19191) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19189.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19264 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19264,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19264,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19230){
var state_val_19231 = (state_19230[(1)]);
if((state_val_19231 === (7))){
var state_19230__$1 = state_19230;
var statearr_19232_19265 = state_19230__$1;
(statearr_19232_19265[(2)] = null);

(statearr_19232_19265[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (1))){
var state_19230__$1 = state_19230;
var statearr_19233_19266 = state_19230__$1;
(statearr_19233_19266[(2)] = null);

(statearr_19233_19266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (4))){
var inst_19194 = (state_19230[(7)]);
var inst_19196 = (inst_19194 < cnt);
var state_19230__$1 = state_19230;
if(cljs.core.truth_(inst_19196)){
var statearr_19234_19267 = state_19230__$1;
(statearr_19234_19267[(1)] = (6));

} else {
var statearr_19235_19268 = state_19230__$1;
(statearr_19235_19268[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (15))){
var inst_19226 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
var statearr_19236_19269 = state_19230__$1;
(statearr_19236_19269[(2)] = inst_19226);

(statearr_19236_19269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (13))){
var inst_19219 = cljs.core.async.close_BANG_.call(null,out);
var state_19230__$1 = state_19230;
var statearr_19237_19270 = state_19230__$1;
(statearr_19237_19270[(2)] = inst_19219);

(statearr_19237_19270[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (6))){
var state_19230__$1 = state_19230;
var statearr_19238_19271 = state_19230__$1;
(statearr_19238_19271[(2)] = null);

(statearr_19238_19271[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (3))){
var inst_19228 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19230__$1,inst_19228);
} else {
if((state_val_19231 === (12))){
var inst_19216 = (state_19230[(8)]);
var inst_19216__$1 = (state_19230[(2)]);
var inst_19217 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19216__$1);
var state_19230__$1 = (function (){var statearr_19239 = state_19230;
(statearr_19239[(8)] = inst_19216__$1);

return statearr_19239;
})();
if(cljs.core.truth_(inst_19217)){
var statearr_19240_19272 = state_19230__$1;
(statearr_19240_19272[(1)] = (13));

} else {
var statearr_19241_19273 = state_19230__$1;
(statearr_19241_19273[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (2))){
var inst_19193 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19194 = (0);
var state_19230__$1 = (function (){var statearr_19242 = state_19230;
(statearr_19242[(7)] = inst_19194);

(statearr_19242[(9)] = inst_19193);

return statearr_19242;
})();
var statearr_19243_19274 = state_19230__$1;
(statearr_19243_19274[(2)] = null);

(statearr_19243_19274[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (11))){
var inst_19194 = (state_19230[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19230,(10),Object,null,(9));
var inst_19203 = chs__$1.call(null,inst_19194);
var inst_19204 = done.call(null,inst_19194);
var inst_19205 = cljs.core.async.take_BANG_.call(null,inst_19203,inst_19204);
var state_19230__$1 = state_19230;
var statearr_19244_19275 = state_19230__$1;
(statearr_19244_19275[(2)] = inst_19205);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19230__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (9))){
var inst_19194 = (state_19230[(7)]);
var inst_19207 = (state_19230[(2)]);
var inst_19208 = (inst_19194 + (1));
var inst_19194__$1 = inst_19208;
var state_19230__$1 = (function (){var statearr_19245 = state_19230;
(statearr_19245[(10)] = inst_19207);

(statearr_19245[(7)] = inst_19194__$1);

return statearr_19245;
})();
var statearr_19246_19276 = state_19230__$1;
(statearr_19246_19276[(2)] = null);

(statearr_19246_19276[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (5))){
var inst_19214 = (state_19230[(2)]);
var state_19230__$1 = (function (){var statearr_19247 = state_19230;
(statearr_19247[(11)] = inst_19214);

return statearr_19247;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19230__$1,(12),dchan);
} else {
if((state_val_19231 === (14))){
var inst_19216 = (state_19230[(8)]);
var inst_19221 = cljs.core.apply.call(null,f,inst_19216);
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19230__$1,(16),out,inst_19221);
} else {
if((state_val_19231 === (16))){
var inst_19223 = (state_19230[(2)]);
var state_19230__$1 = (function (){var statearr_19248 = state_19230;
(statearr_19248[(12)] = inst_19223);

return statearr_19248;
})();
var statearr_19249_19277 = state_19230__$1;
(statearr_19249_19277[(2)] = null);

(statearr_19249_19277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (10))){
var inst_19198 = (state_19230[(2)]);
var inst_19199 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19230__$1 = (function (){var statearr_19250 = state_19230;
(statearr_19250[(13)] = inst_19198);

return statearr_19250;
})();
var statearr_19251_19278 = state_19230__$1;
(statearr_19251_19278[(2)] = inst_19199);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19230__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (8))){
var inst_19212 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
var statearr_19252_19279 = state_19230__$1;
(statearr_19252_19279[(2)] = inst_19212);

(statearr_19252_19279[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19264,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19264,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19256[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19256[(1)] = (1));

return statearr_19256;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19230){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19257){if((e19257 instanceof Object)){
var ex__8254__auto__ = e19257;
var statearr_19258_19280 = state_19230;
(statearr_19258_19280[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19230);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19257;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19281 = state_19230;
state_19230 = G__19281;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19230){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19264,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19259 = f__8363__auto__.call(null);
(statearr_19259[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19264);

return statearr_19259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19264,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19283 = [];
var len__5726__auto___19339 = arguments.length;
var i__5727__auto___19340 = (0);
while(true){
if((i__5727__auto___19340 < len__5726__auto___19339)){
args19283.push((arguments[i__5727__auto___19340]));

var G__19341 = (i__5727__auto___19340 + (1));
i__5727__auto___19340 = G__19341;
continue;
} else {
}
break;
}

var G__19285 = args19283.length;
switch (G__19285) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19283.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19343 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19343,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19343,out){
return (function (state_19315){
var state_val_19316 = (state_19315[(1)]);
if((state_val_19316 === (7))){
var inst_19295 = (state_19315[(7)]);
var inst_19294 = (state_19315[(8)]);
var inst_19294__$1 = (state_19315[(2)]);
var inst_19295__$1 = cljs.core.nth.call(null,inst_19294__$1,(0),null);
var inst_19296 = cljs.core.nth.call(null,inst_19294__$1,(1),null);
var inst_19297 = (inst_19295__$1 == null);
var state_19315__$1 = (function (){var statearr_19317 = state_19315;
(statearr_19317[(7)] = inst_19295__$1);

(statearr_19317[(9)] = inst_19296);

(statearr_19317[(8)] = inst_19294__$1);

return statearr_19317;
})();
if(cljs.core.truth_(inst_19297)){
var statearr_19318_19344 = state_19315__$1;
(statearr_19318_19344[(1)] = (8));

} else {
var statearr_19319_19345 = state_19315__$1;
(statearr_19319_19345[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19316 === (1))){
var inst_19286 = cljs.core.vec.call(null,chs);
var inst_19287 = inst_19286;
var state_19315__$1 = (function (){var statearr_19320 = state_19315;
(statearr_19320[(10)] = inst_19287);

return statearr_19320;
})();
var statearr_19321_19346 = state_19315__$1;
(statearr_19321_19346[(2)] = null);

(statearr_19321_19346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19316 === (4))){
var inst_19287 = (state_19315[(10)]);
var state_19315__$1 = state_19315;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19315__$1,(7),inst_19287);
} else {
if((state_val_19316 === (6))){
var inst_19311 = (state_19315[(2)]);
var state_19315__$1 = state_19315;
var statearr_19322_19347 = state_19315__$1;
(statearr_19322_19347[(2)] = inst_19311);

(statearr_19322_19347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19316 === (3))){
var inst_19313 = (state_19315[(2)]);
var state_19315__$1 = state_19315;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19315__$1,inst_19313);
} else {
if((state_val_19316 === (2))){
var inst_19287 = (state_19315[(10)]);
var inst_19289 = cljs.core.count.call(null,inst_19287);
var inst_19290 = (inst_19289 > (0));
var state_19315__$1 = state_19315;
if(cljs.core.truth_(inst_19290)){
var statearr_19324_19348 = state_19315__$1;
(statearr_19324_19348[(1)] = (4));

} else {
var statearr_19325_19349 = state_19315__$1;
(statearr_19325_19349[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19316 === (11))){
var inst_19287 = (state_19315[(10)]);
var inst_19304 = (state_19315[(2)]);
var tmp19323 = inst_19287;
var inst_19287__$1 = tmp19323;
var state_19315__$1 = (function (){var statearr_19326 = state_19315;
(statearr_19326[(10)] = inst_19287__$1);

(statearr_19326[(11)] = inst_19304);

return statearr_19326;
})();
var statearr_19327_19350 = state_19315__$1;
(statearr_19327_19350[(2)] = null);

(statearr_19327_19350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19316 === (9))){
var inst_19295 = (state_19315[(7)]);
var state_19315__$1 = state_19315;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19315__$1,(11),out,inst_19295);
} else {
if((state_val_19316 === (5))){
var inst_19309 = cljs.core.async.close_BANG_.call(null,out);
var state_19315__$1 = state_19315;
var statearr_19328_19351 = state_19315__$1;
(statearr_19328_19351[(2)] = inst_19309);

(statearr_19328_19351[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19316 === (10))){
var inst_19307 = (state_19315[(2)]);
var state_19315__$1 = state_19315;
var statearr_19329_19352 = state_19315__$1;
(statearr_19329_19352[(2)] = inst_19307);

(statearr_19329_19352[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19316 === (8))){
var inst_19295 = (state_19315[(7)]);
var inst_19296 = (state_19315[(9)]);
var inst_19287 = (state_19315[(10)]);
var inst_19294 = (state_19315[(8)]);
var inst_19299 = (function (){var cs = inst_19287;
var vec__19292 = inst_19294;
var v = inst_19295;
var c = inst_19296;
return ((function (cs,vec__19292,v,c,inst_19295,inst_19296,inst_19287,inst_19294,state_val_19316,c__8362__auto___19343,out){
return (function (p1__19282_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19282_SHARP_);
});
;})(cs,vec__19292,v,c,inst_19295,inst_19296,inst_19287,inst_19294,state_val_19316,c__8362__auto___19343,out))
})();
var inst_19300 = cljs.core.filterv.call(null,inst_19299,inst_19287);
var inst_19287__$1 = inst_19300;
var state_19315__$1 = (function (){var statearr_19330 = state_19315;
(statearr_19330[(10)] = inst_19287__$1);

return statearr_19330;
})();
var statearr_19331_19353 = state_19315__$1;
(statearr_19331_19353[(2)] = null);

(statearr_19331_19353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19343,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19343,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19335 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19335[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19335[(1)] = (1));

return statearr_19335;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19315){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19315);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19336){if((e19336 instanceof Object)){
var ex__8254__auto__ = e19336;
var statearr_19337_19354 = state_19315;
(statearr_19337_19354[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19315);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19355 = state_19315;
state_19315 = G__19355;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19315){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19343,out))
})();
var state__8364__auto__ = (function (){var statearr_19338 = f__8363__auto__.call(null);
(statearr_19338[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19343);

return statearr_19338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19343,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19356 = [];
var len__5726__auto___19405 = arguments.length;
var i__5727__auto___19406 = (0);
while(true){
if((i__5727__auto___19406 < len__5726__auto___19405)){
args19356.push((arguments[i__5727__auto___19406]));

var G__19407 = (i__5727__auto___19406 + (1));
i__5727__auto___19406 = G__19407;
continue;
} else {
}
break;
}

var G__19358 = args19356.length;
switch (G__19358) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19356.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19409 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19409,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19409,out){
return (function (state_19382){
var state_val_19383 = (state_19382[(1)]);
if((state_val_19383 === (7))){
var inst_19364 = (state_19382[(7)]);
var inst_19364__$1 = (state_19382[(2)]);
var inst_19365 = (inst_19364__$1 == null);
var inst_19366 = cljs.core.not.call(null,inst_19365);
var state_19382__$1 = (function (){var statearr_19384 = state_19382;
(statearr_19384[(7)] = inst_19364__$1);

return statearr_19384;
})();
if(inst_19366){
var statearr_19385_19410 = state_19382__$1;
(statearr_19385_19410[(1)] = (8));

} else {
var statearr_19386_19411 = state_19382__$1;
(statearr_19386_19411[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19383 === (1))){
var inst_19359 = (0);
var state_19382__$1 = (function (){var statearr_19387 = state_19382;
(statearr_19387[(8)] = inst_19359);

return statearr_19387;
})();
var statearr_19388_19412 = state_19382__$1;
(statearr_19388_19412[(2)] = null);

(statearr_19388_19412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19383 === (4))){
var state_19382__$1 = state_19382;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19382__$1,(7),ch);
} else {
if((state_val_19383 === (6))){
var inst_19377 = (state_19382[(2)]);
var state_19382__$1 = state_19382;
var statearr_19389_19413 = state_19382__$1;
(statearr_19389_19413[(2)] = inst_19377);

(statearr_19389_19413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19383 === (3))){
var inst_19379 = (state_19382[(2)]);
var inst_19380 = cljs.core.async.close_BANG_.call(null,out);
var state_19382__$1 = (function (){var statearr_19390 = state_19382;
(statearr_19390[(9)] = inst_19379);

return statearr_19390;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19382__$1,inst_19380);
} else {
if((state_val_19383 === (2))){
var inst_19359 = (state_19382[(8)]);
var inst_19361 = (inst_19359 < n);
var state_19382__$1 = state_19382;
if(cljs.core.truth_(inst_19361)){
var statearr_19391_19414 = state_19382__$1;
(statearr_19391_19414[(1)] = (4));

} else {
var statearr_19392_19415 = state_19382__$1;
(statearr_19392_19415[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19383 === (11))){
var inst_19359 = (state_19382[(8)]);
var inst_19369 = (state_19382[(2)]);
var inst_19370 = (inst_19359 + (1));
var inst_19359__$1 = inst_19370;
var state_19382__$1 = (function (){var statearr_19393 = state_19382;
(statearr_19393[(8)] = inst_19359__$1);

(statearr_19393[(10)] = inst_19369);

return statearr_19393;
})();
var statearr_19394_19416 = state_19382__$1;
(statearr_19394_19416[(2)] = null);

(statearr_19394_19416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19383 === (9))){
var state_19382__$1 = state_19382;
var statearr_19395_19417 = state_19382__$1;
(statearr_19395_19417[(2)] = null);

(statearr_19395_19417[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19383 === (5))){
var state_19382__$1 = state_19382;
var statearr_19396_19418 = state_19382__$1;
(statearr_19396_19418[(2)] = null);

(statearr_19396_19418[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19383 === (10))){
var inst_19374 = (state_19382[(2)]);
var state_19382__$1 = state_19382;
var statearr_19397_19419 = state_19382__$1;
(statearr_19397_19419[(2)] = inst_19374);

(statearr_19397_19419[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19383 === (8))){
var inst_19364 = (state_19382[(7)]);
var state_19382__$1 = state_19382;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19382__$1,(11),out,inst_19364);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19409,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19409,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19401 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19401[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19401[(1)] = (1));

return statearr_19401;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19382){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19382);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19402){if((e19402 instanceof Object)){
var ex__8254__auto__ = e19402;
var statearr_19403_19420 = state_19382;
(statearr_19403_19420[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19382);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19402;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19421 = state_19382;
state_19382 = G__19421;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19382){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19409,out))
})();
var state__8364__auto__ = (function (){var statearr_19404 = f__8363__auto__.call(null);
(statearr_19404[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19409);

return statearr_19404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19409,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19429 = (function (map_LT_,f,ch,meta19430){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19430 = meta19430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19431,meta19430__$1){
var self__ = this;
var _19431__$1 = this;
return (new cljs.core.async.t_cljs$core$async19429(self__.map_LT_,self__.f,self__.ch,meta19430__$1));
});

cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19431){
var self__ = this;
var _19431__$1 = this;
return self__.meta19430;
});

cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19432 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19432 = (function (map_LT_,f,ch,meta19430,_,fn1,meta19433){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19430 = meta19430;
this._ = _;
this.fn1 = fn1;
this.meta19433 = meta19433;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19434,meta19433__$1){
var self__ = this;
var _19434__$1 = this;
return (new cljs.core.async.t_cljs$core$async19432(self__.map_LT_,self__.f,self__.ch,self__.meta19430,self__._,self__.fn1,meta19433__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19432.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19434){
var self__ = this;
var _19434__$1 = this;
return self__.meta19433;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19432.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19432.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19432.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19432.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19422_SHARP_){
return f1.call(null,(((p1__19422_SHARP_ == null))?null:self__.f.call(null,p1__19422_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19432.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19430","meta19430",-1895428948,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19429","cljs.core.async/t_cljs$core$async19429",-288424335,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19433","meta19433",2005506822,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19432.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19432.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19432";

cljs.core.async.t_cljs$core$async19432.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19432");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19432 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19432(map_LT___$1,f__$1,ch__$1,meta19430__$1,___$2,fn1__$1,meta19433){
return (new cljs.core.async.t_cljs$core$async19432(map_LT___$1,f__$1,ch__$1,meta19430__$1,___$2,fn1__$1,meta19433));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19432(self__.map_LT_,self__.f,self__.ch,self__.meta19430,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19429.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19429.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19430","meta19430",-1895428948,null)], null);
});

cljs.core.async.t_cljs$core$async19429.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19429.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19429";

cljs.core.async.t_cljs$core$async19429.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19429");
});

cljs.core.async.__GT_t_cljs$core$async19429 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19429(map_LT___$1,f__$1,ch__$1,meta19430){
return (new cljs.core.async.t_cljs$core$async19429(map_LT___$1,f__$1,ch__$1,meta19430));
});

}

return (new cljs.core.async.t_cljs$core$async19429(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19438 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19438 = (function (map_GT_,f,ch,meta19439){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19439 = meta19439;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19438.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19440,meta19439__$1){
var self__ = this;
var _19440__$1 = this;
return (new cljs.core.async.t_cljs$core$async19438(self__.map_GT_,self__.f,self__.ch,meta19439__$1));
});

cljs.core.async.t_cljs$core$async19438.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19440){
var self__ = this;
var _19440__$1 = this;
return self__.meta19439;
});

cljs.core.async.t_cljs$core$async19438.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19438.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19438.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19438.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19438.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19438.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19438.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19439","meta19439",1639926580,null)], null);
});

cljs.core.async.t_cljs$core$async19438.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19438.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19438";

cljs.core.async.t_cljs$core$async19438.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19438");
});

cljs.core.async.__GT_t_cljs$core$async19438 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19438(map_GT___$1,f__$1,ch__$1,meta19439){
return (new cljs.core.async.t_cljs$core$async19438(map_GT___$1,f__$1,ch__$1,meta19439));
});

}

return (new cljs.core.async.t_cljs$core$async19438(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19444 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19444 = (function (filter_GT_,p,ch,meta19445){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19445 = meta19445;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19446,meta19445__$1){
var self__ = this;
var _19446__$1 = this;
return (new cljs.core.async.t_cljs$core$async19444(self__.filter_GT_,self__.p,self__.ch,meta19445__$1));
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19446){
var self__ = this;
var _19446__$1 = this;
return self__.meta19445;
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19444.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19444.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19445","meta19445",-540903635,null)], null);
});

cljs.core.async.t_cljs$core$async19444.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19444.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19444";

cljs.core.async.t_cljs$core$async19444.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19444");
});

cljs.core.async.__GT_t_cljs$core$async19444 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19444(filter_GT___$1,p__$1,ch__$1,meta19445){
return (new cljs.core.async.t_cljs$core$async19444(filter_GT___$1,p__$1,ch__$1,meta19445));
});

}

return (new cljs.core.async.t_cljs$core$async19444(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19447 = [];
var len__5726__auto___19491 = arguments.length;
var i__5727__auto___19492 = (0);
while(true){
if((i__5727__auto___19492 < len__5726__auto___19491)){
args19447.push((arguments[i__5727__auto___19492]));

var G__19493 = (i__5727__auto___19492 + (1));
i__5727__auto___19492 = G__19493;
continue;
} else {
}
break;
}

var G__19449 = args19447.length;
switch (G__19449) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19447.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19495 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19495,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19495,out){
return (function (state_19470){
var state_val_19471 = (state_19470[(1)]);
if((state_val_19471 === (7))){
var inst_19466 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
var statearr_19472_19496 = state_19470__$1;
(statearr_19472_19496[(2)] = inst_19466);

(statearr_19472_19496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (1))){
var state_19470__$1 = state_19470;
var statearr_19473_19497 = state_19470__$1;
(statearr_19473_19497[(2)] = null);

(statearr_19473_19497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (4))){
var inst_19452 = (state_19470[(7)]);
var inst_19452__$1 = (state_19470[(2)]);
var inst_19453 = (inst_19452__$1 == null);
var state_19470__$1 = (function (){var statearr_19474 = state_19470;
(statearr_19474[(7)] = inst_19452__$1);

return statearr_19474;
})();
if(cljs.core.truth_(inst_19453)){
var statearr_19475_19498 = state_19470__$1;
(statearr_19475_19498[(1)] = (5));

} else {
var statearr_19476_19499 = state_19470__$1;
(statearr_19476_19499[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (6))){
var inst_19452 = (state_19470[(7)]);
var inst_19457 = p.call(null,inst_19452);
var state_19470__$1 = state_19470;
if(cljs.core.truth_(inst_19457)){
var statearr_19477_19500 = state_19470__$1;
(statearr_19477_19500[(1)] = (8));

} else {
var statearr_19478_19501 = state_19470__$1;
(statearr_19478_19501[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (3))){
var inst_19468 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19470__$1,inst_19468);
} else {
if((state_val_19471 === (2))){
var state_19470__$1 = state_19470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19470__$1,(4),ch);
} else {
if((state_val_19471 === (11))){
var inst_19460 = (state_19470[(2)]);
var state_19470__$1 = state_19470;
var statearr_19479_19502 = state_19470__$1;
(statearr_19479_19502[(2)] = inst_19460);

(statearr_19479_19502[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (9))){
var state_19470__$1 = state_19470;
var statearr_19480_19503 = state_19470__$1;
(statearr_19480_19503[(2)] = null);

(statearr_19480_19503[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (5))){
var inst_19455 = cljs.core.async.close_BANG_.call(null,out);
var state_19470__$1 = state_19470;
var statearr_19481_19504 = state_19470__$1;
(statearr_19481_19504[(2)] = inst_19455);

(statearr_19481_19504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (10))){
var inst_19463 = (state_19470[(2)]);
var state_19470__$1 = (function (){var statearr_19482 = state_19470;
(statearr_19482[(8)] = inst_19463);

return statearr_19482;
})();
var statearr_19483_19505 = state_19470__$1;
(statearr_19483_19505[(2)] = null);

(statearr_19483_19505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19471 === (8))){
var inst_19452 = (state_19470[(7)]);
var state_19470__$1 = state_19470;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19470__$1,(11),out,inst_19452);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19495,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19495,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19487 = [null,null,null,null,null,null,null,null,null];
(statearr_19487[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19487[(1)] = (1));

return statearr_19487;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19470){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19488){if((e19488 instanceof Object)){
var ex__8254__auto__ = e19488;
var statearr_19489_19506 = state_19470;
(statearr_19489_19506[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19488;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19507 = state_19470;
state_19470 = G__19507;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19470){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19495,out))
})();
var state__8364__auto__ = (function (){var statearr_19490 = f__8363__auto__.call(null);
(statearr_19490[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19495);

return statearr_19490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19495,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19508 = [];
var len__5726__auto___19511 = arguments.length;
var i__5727__auto___19512 = (0);
while(true){
if((i__5727__auto___19512 < len__5726__auto___19511)){
args19508.push((arguments[i__5727__auto___19512]));

var G__19513 = (i__5727__auto___19512 + (1));
i__5727__auto___19512 = G__19513;
continue;
} else {
}
break;
}

var G__19510 = args19508.length;
switch (G__19510) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19508.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19680){
var state_val_19681 = (state_19680[(1)]);
if((state_val_19681 === (7))){
var inst_19676 = (state_19680[(2)]);
var state_19680__$1 = state_19680;
var statearr_19682_19723 = state_19680__$1;
(statearr_19682_19723[(2)] = inst_19676);

(statearr_19682_19723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (20))){
var inst_19646 = (state_19680[(7)]);
var inst_19657 = (state_19680[(2)]);
var inst_19658 = cljs.core.next.call(null,inst_19646);
var inst_19632 = inst_19658;
var inst_19633 = null;
var inst_19634 = (0);
var inst_19635 = (0);
var state_19680__$1 = (function (){var statearr_19683 = state_19680;
(statearr_19683[(8)] = inst_19632);

(statearr_19683[(9)] = inst_19635);

(statearr_19683[(10)] = inst_19657);

(statearr_19683[(11)] = inst_19633);

(statearr_19683[(12)] = inst_19634);

return statearr_19683;
})();
var statearr_19684_19724 = state_19680__$1;
(statearr_19684_19724[(2)] = null);

(statearr_19684_19724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (1))){
var state_19680__$1 = state_19680;
var statearr_19685_19725 = state_19680__$1;
(statearr_19685_19725[(2)] = null);

(statearr_19685_19725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (4))){
var inst_19621 = (state_19680[(13)]);
var inst_19621__$1 = (state_19680[(2)]);
var inst_19622 = (inst_19621__$1 == null);
var state_19680__$1 = (function (){var statearr_19686 = state_19680;
(statearr_19686[(13)] = inst_19621__$1);

return statearr_19686;
})();
if(cljs.core.truth_(inst_19622)){
var statearr_19687_19726 = state_19680__$1;
(statearr_19687_19726[(1)] = (5));

} else {
var statearr_19688_19727 = state_19680__$1;
(statearr_19688_19727[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (15))){
var state_19680__$1 = state_19680;
var statearr_19692_19728 = state_19680__$1;
(statearr_19692_19728[(2)] = null);

(statearr_19692_19728[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (21))){
var state_19680__$1 = state_19680;
var statearr_19693_19729 = state_19680__$1;
(statearr_19693_19729[(2)] = null);

(statearr_19693_19729[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (13))){
var inst_19632 = (state_19680[(8)]);
var inst_19635 = (state_19680[(9)]);
var inst_19633 = (state_19680[(11)]);
var inst_19634 = (state_19680[(12)]);
var inst_19642 = (state_19680[(2)]);
var inst_19643 = (inst_19635 + (1));
var tmp19689 = inst_19632;
var tmp19690 = inst_19633;
var tmp19691 = inst_19634;
var inst_19632__$1 = tmp19689;
var inst_19633__$1 = tmp19690;
var inst_19634__$1 = tmp19691;
var inst_19635__$1 = inst_19643;
var state_19680__$1 = (function (){var statearr_19694 = state_19680;
(statearr_19694[(8)] = inst_19632__$1);

(statearr_19694[(9)] = inst_19635__$1);

(statearr_19694[(11)] = inst_19633__$1);

(statearr_19694[(14)] = inst_19642);

(statearr_19694[(12)] = inst_19634__$1);

return statearr_19694;
})();
var statearr_19695_19730 = state_19680__$1;
(statearr_19695_19730[(2)] = null);

(statearr_19695_19730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (22))){
var state_19680__$1 = state_19680;
var statearr_19696_19731 = state_19680__$1;
(statearr_19696_19731[(2)] = null);

(statearr_19696_19731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (6))){
var inst_19621 = (state_19680[(13)]);
var inst_19630 = f.call(null,inst_19621);
var inst_19631 = cljs.core.seq.call(null,inst_19630);
var inst_19632 = inst_19631;
var inst_19633 = null;
var inst_19634 = (0);
var inst_19635 = (0);
var state_19680__$1 = (function (){var statearr_19697 = state_19680;
(statearr_19697[(8)] = inst_19632);

(statearr_19697[(9)] = inst_19635);

(statearr_19697[(11)] = inst_19633);

(statearr_19697[(12)] = inst_19634);

return statearr_19697;
})();
var statearr_19698_19732 = state_19680__$1;
(statearr_19698_19732[(2)] = null);

(statearr_19698_19732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (17))){
var inst_19646 = (state_19680[(7)]);
var inst_19650 = cljs.core.chunk_first.call(null,inst_19646);
var inst_19651 = cljs.core.chunk_rest.call(null,inst_19646);
var inst_19652 = cljs.core.count.call(null,inst_19650);
var inst_19632 = inst_19651;
var inst_19633 = inst_19650;
var inst_19634 = inst_19652;
var inst_19635 = (0);
var state_19680__$1 = (function (){var statearr_19699 = state_19680;
(statearr_19699[(8)] = inst_19632);

(statearr_19699[(9)] = inst_19635);

(statearr_19699[(11)] = inst_19633);

(statearr_19699[(12)] = inst_19634);

return statearr_19699;
})();
var statearr_19700_19733 = state_19680__$1;
(statearr_19700_19733[(2)] = null);

(statearr_19700_19733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (3))){
var inst_19678 = (state_19680[(2)]);
var state_19680__$1 = state_19680;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19680__$1,inst_19678);
} else {
if((state_val_19681 === (12))){
var inst_19666 = (state_19680[(2)]);
var state_19680__$1 = state_19680;
var statearr_19701_19734 = state_19680__$1;
(statearr_19701_19734[(2)] = inst_19666);

(statearr_19701_19734[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (2))){
var state_19680__$1 = state_19680;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19680__$1,(4),in$);
} else {
if((state_val_19681 === (23))){
var inst_19674 = (state_19680[(2)]);
var state_19680__$1 = state_19680;
var statearr_19702_19735 = state_19680__$1;
(statearr_19702_19735[(2)] = inst_19674);

(statearr_19702_19735[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (19))){
var inst_19661 = (state_19680[(2)]);
var state_19680__$1 = state_19680;
var statearr_19703_19736 = state_19680__$1;
(statearr_19703_19736[(2)] = inst_19661);

(statearr_19703_19736[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (11))){
var inst_19632 = (state_19680[(8)]);
var inst_19646 = (state_19680[(7)]);
var inst_19646__$1 = cljs.core.seq.call(null,inst_19632);
var state_19680__$1 = (function (){var statearr_19704 = state_19680;
(statearr_19704[(7)] = inst_19646__$1);

return statearr_19704;
})();
if(inst_19646__$1){
var statearr_19705_19737 = state_19680__$1;
(statearr_19705_19737[(1)] = (14));

} else {
var statearr_19706_19738 = state_19680__$1;
(statearr_19706_19738[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (9))){
var inst_19668 = (state_19680[(2)]);
var inst_19669 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19680__$1 = (function (){var statearr_19707 = state_19680;
(statearr_19707[(15)] = inst_19668);

return statearr_19707;
})();
if(cljs.core.truth_(inst_19669)){
var statearr_19708_19739 = state_19680__$1;
(statearr_19708_19739[(1)] = (21));

} else {
var statearr_19709_19740 = state_19680__$1;
(statearr_19709_19740[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (5))){
var inst_19624 = cljs.core.async.close_BANG_.call(null,out);
var state_19680__$1 = state_19680;
var statearr_19710_19741 = state_19680__$1;
(statearr_19710_19741[(2)] = inst_19624);

(statearr_19710_19741[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (14))){
var inst_19646 = (state_19680[(7)]);
var inst_19648 = cljs.core.chunked_seq_QMARK_.call(null,inst_19646);
var state_19680__$1 = state_19680;
if(inst_19648){
var statearr_19711_19742 = state_19680__$1;
(statearr_19711_19742[(1)] = (17));

} else {
var statearr_19712_19743 = state_19680__$1;
(statearr_19712_19743[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (16))){
var inst_19664 = (state_19680[(2)]);
var state_19680__$1 = state_19680;
var statearr_19713_19744 = state_19680__$1;
(statearr_19713_19744[(2)] = inst_19664);

(statearr_19713_19744[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19681 === (10))){
var inst_19635 = (state_19680[(9)]);
var inst_19633 = (state_19680[(11)]);
var inst_19640 = cljs.core._nth.call(null,inst_19633,inst_19635);
var state_19680__$1 = state_19680;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19680__$1,(13),out,inst_19640);
} else {
if((state_val_19681 === (18))){
var inst_19646 = (state_19680[(7)]);
var inst_19655 = cljs.core.first.call(null,inst_19646);
var state_19680__$1 = state_19680;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19680__$1,(20),out,inst_19655);
} else {
if((state_val_19681 === (8))){
var inst_19635 = (state_19680[(9)]);
var inst_19634 = (state_19680[(12)]);
var inst_19637 = (inst_19635 < inst_19634);
var inst_19638 = inst_19637;
var state_19680__$1 = state_19680;
if(cljs.core.truth_(inst_19638)){
var statearr_19714_19745 = state_19680__$1;
(statearr_19714_19745[(1)] = (10));

} else {
var statearr_19715_19746 = state_19680__$1;
(statearr_19715_19746[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19719 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19719[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19719[(1)] = (1));

return statearr_19719;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19680){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19720){if((e19720 instanceof Object)){
var ex__8254__auto__ = e19720;
var statearr_19721_19747 = state_19680;
(statearr_19721_19747[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19680);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19720;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19748 = state_19680;
state_19680 = G__19748;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19680){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19722 = f__8363__auto__.call(null);
(statearr_19722[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19749 = [];
var len__5726__auto___19752 = arguments.length;
var i__5727__auto___19753 = (0);
while(true){
if((i__5727__auto___19753 < len__5726__auto___19752)){
args19749.push((arguments[i__5727__auto___19753]));

var G__19754 = (i__5727__auto___19753 + (1));
i__5727__auto___19753 = G__19754;
continue;
} else {
}
break;
}

var G__19751 = args19749.length;
switch (G__19751) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19749.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19756 = [];
var len__5726__auto___19759 = arguments.length;
var i__5727__auto___19760 = (0);
while(true){
if((i__5727__auto___19760 < len__5726__auto___19759)){
args19756.push((arguments[i__5727__auto___19760]));

var G__19761 = (i__5727__auto___19760 + (1));
i__5727__auto___19760 = G__19761;
continue;
} else {
}
break;
}

var G__19758 = args19756.length;
switch (G__19758) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19756.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19763 = [];
var len__5726__auto___19814 = arguments.length;
var i__5727__auto___19815 = (0);
while(true){
if((i__5727__auto___19815 < len__5726__auto___19814)){
args19763.push((arguments[i__5727__auto___19815]));

var G__19816 = (i__5727__auto___19815 + (1));
i__5727__auto___19815 = G__19816;
continue;
} else {
}
break;
}

var G__19765 = args19763.length;
switch (G__19765) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19763.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19818 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19818,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19818,out){
return (function (state_19789){
var state_val_19790 = (state_19789[(1)]);
if((state_val_19790 === (7))){
var inst_19784 = (state_19789[(2)]);
var state_19789__$1 = state_19789;
var statearr_19791_19819 = state_19789__$1;
(statearr_19791_19819[(2)] = inst_19784);

(statearr_19791_19819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19790 === (1))){
var inst_19766 = null;
var state_19789__$1 = (function (){var statearr_19792 = state_19789;
(statearr_19792[(7)] = inst_19766);

return statearr_19792;
})();
var statearr_19793_19820 = state_19789__$1;
(statearr_19793_19820[(2)] = null);

(statearr_19793_19820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19790 === (4))){
var inst_19769 = (state_19789[(8)]);
var inst_19769__$1 = (state_19789[(2)]);
var inst_19770 = (inst_19769__$1 == null);
var inst_19771 = cljs.core.not.call(null,inst_19770);
var state_19789__$1 = (function (){var statearr_19794 = state_19789;
(statearr_19794[(8)] = inst_19769__$1);

return statearr_19794;
})();
if(inst_19771){
var statearr_19795_19821 = state_19789__$1;
(statearr_19795_19821[(1)] = (5));

} else {
var statearr_19796_19822 = state_19789__$1;
(statearr_19796_19822[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19790 === (6))){
var state_19789__$1 = state_19789;
var statearr_19797_19823 = state_19789__$1;
(statearr_19797_19823[(2)] = null);

(statearr_19797_19823[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19790 === (3))){
var inst_19786 = (state_19789[(2)]);
var inst_19787 = cljs.core.async.close_BANG_.call(null,out);
var state_19789__$1 = (function (){var statearr_19798 = state_19789;
(statearr_19798[(9)] = inst_19786);

return statearr_19798;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19789__$1,inst_19787);
} else {
if((state_val_19790 === (2))){
var state_19789__$1 = state_19789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19789__$1,(4),ch);
} else {
if((state_val_19790 === (11))){
var inst_19769 = (state_19789[(8)]);
var inst_19778 = (state_19789[(2)]);
var inst_19766 = inst_19769;
var state_19789__$1 = (function (){var statearr_19799 = state_19789;
(statearr_19799[(10)] = inst_19778);

(statearr_19799[(7)] = inst_19766);

return statearr_19799;
})();
var statearr_19800_19824 = state_19789__$1;
(statearr_19800_19824[(2)] = null);

(statearr_19800_19824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19790 === (9))){
var inst_19769 = (state_19789[(8)]);
var state_19789__$1 = state_19789;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19789__$1,(11),out,inst_19769);
} else {
if((state_val_19790 === (5))){
var inst_19766 = (state_19789[(7)]);
var inst_19769 = (state_19789[(8)]);
var inst_19773 = cljs.core._EQ_.call(null,inst_19769,inst_19766);
var state_19789__$1 = state_19789;
if(inst_19773){
var statearr_19802_19825 = state_19789__$1;
(statearr_19802_19825[(1)] = (8));

} else {
var statearr_19803_19826 = state_19789__$1;
(statearr_19803_19826[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19790 === (10))){
var inst_19781 = (state_19789[(2)]);
var state_19789__$1 = state_19789;
var statearr_19804_19827 = state_19789__$1;
(statearr_19804_19827[(2)] = inst_19781);

(statearr_19804_19827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19790 === (8))){
var inst_19766 = (state_19789[(7)]);
var tmp19801 = inst_19766;
var inst_19766__$1 = tmp19801;
var state_19789__$1 = (function (){var statearr_19805 = state_19789;
(statearr_19805[(7)] = inst_19766__$1);

return statearr_19805;
})();
var statearr_19806_19828 = state_19789__$1;
(statearr_19806_19828[(2)] = null);

(statearr_19806_19828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19818,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19818,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19810 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19810[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19810[(1)] = (1));

return statearr_19810;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19789){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19789);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19811){if((e19811 instanceof Object)){
var ex__8254__auto__ = e19811;
var statearr_19812_19829 = state_19789;
(statearr_19812_19829[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19789);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19811;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19830 = state_19789;
state_19789 = G__19830;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19789){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19818,out))
})();
var state__8364__auto__ = (function (){var statearr_19813 = f__8363__auto__.call(null);
(statearr_19813[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19818);

return statearr_19813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19818,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19831 = [];
var len__5726__auto___19901 = arguments.length;
var i__5727__auto___19902 = (0);
while(true){
if((i__5727__auto___19902 < len__5726__auto___19901)){
args19831.push((arguments[i__5727__auto___19902]));

var G__19903 = (i__5727__auto___19902 + (1));
i__5727__auto___19902 = G__19903;
continue;
} else {
}
break;
}

var G__19833 = args19831.length;
switch (G__19833) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19831.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19905 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19905,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19905,out){
return (function (state_19871){
var state_val_19872 = (state_19871[(1)]);
if((state_val_19872 === (7))){
var inst_19867 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
var statearr_19873_19906 = state_19871__$1;
(statearr_19873_19906[(2)] = inst_19867);

(statearr_19873_19906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (1))){
var inst_19834 = (new Array(n));
var inst_19835 = inst_19834;
var inst_19836 = (0);
var state_19871__$1 = (function (){var statearr_19874 = state_19871;
(statearr_19874[(7)] = inst_19835);

(statearr_19874[(8)] = inst_19836);

return statearr_19874;
})();
var statearr_19875_19907 = state_19871__$1;
(statearr_19875_19907[(2)] = null);

(statearr_19875_19907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (4))){
var inst_19839 = (state_19871[(9)]);
var inst_19839__$1 = (state_19871[(2)]);
var inst_19840 = (inst_19839__$1 == null);
var inst_19841 = cljs.core.not.call(null,inst_19840);
var state_19871__$1 = (function (){var statearr_19876 = state_19871;
(statearr_19876[(9)] = inst_19839__$1);

return statearr_19876;
})();
if(inst_19841){
var statearr_19877_19908 = state_19871__$1;
(statearr_19877_19908[(1)] = (5));

} else {
var statearr_19878_19909 = state_19871__$1;
(statearr_19878_19909[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (15))){
var inst_19861 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
var statearr_19879_19910 = state_19871__$1;
(statearr_19879_19910[(2)] = inst_19861);

(statearr_19879_19910[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (13))){
var state_19871__$1 = state_19871;
var statearr_19880_19911 = state_19871__$1;
(statearr_19880_19911[(2)] = null);

(statearr_19880_19911[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (6))){
var inst_19836 = (state_19871[(8)]);
var inst_19857 = (inst_19836 > (0));
var state_19871__$1 = state_19871;
if(cljs.core.truth_(inst_19857)){
var statearr_19881_19912 = state_19871__$1;
(statearr_19881_19912[(1)] = (12));

} else {
var statearr_19882_19913 = state_19871__$1;
(statearr_19882_19913[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (3))){
var inst_19869 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19871__$1,inst_19869);
} else {
if((state_val_19872 === (12))){
var inst_19835 = (state_19871[(7)]);
var inst_19859 = cljs.core.vec.call(null,inst_19835);
var state_19871__$1 = state_19871;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19871__$1,(15),out,inst_19859);
} else {
if((state_val_19872 === (2))){
var state_19871__$1 = state_19871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19871__$1,(4),ch);
} else {
if((state_val_19872 === (11))){
var inst_19851 = (state_19871[(2)]);
var inst_19852 = (new Array(n));
var inst_19835 = inst_19852;
var inst_19836 = (0);
var state_19871__$1 = (function (){var statearr_19883 = state_19871;
(statearr_19883[(7)] = inst_19835);

(statearr_19883[(8)] = inst_19836);

(statearr_19883[(10)] = inst_19851);

return statearr_19883;
})();
var statearr_19884_19914 = state_19871__$1;
(statearr_19884_19914[(2)] = null);

(statearr_19884_19914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (9))){
var inst_19835 = (state_19871[(7)]);
var inst_19849 = cljs.core.vec.call(null,inst_19835);
var state_19871__$1 = state_19871;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19871__$1,(11),out,inst_19849);
} else {
if((state_val_19872 === (5))){
var inst_19835 = (state_19871[(7)]);
var inst_19844 = (state_19871[(11)]);
var inst_19836 = (state_19871[(8)]);
var inst_19839 = (state_19871[(9)]);
var inst_19843 = (inst_19835[inst_19836] = inst_19839);
var inst_19844__$1 = (inst_19836 + (1));
var inst_19845 = (inst_19844__$1 < n);
var state_19871__$1 = (function (){var statearr_19885 = state_19871;
(statearr_19885[(12)] = inst_19843);

(statearr_19885[(11)] = inst_19844__$1);

return statearr_19885;
})();
if(cljs.core.truth_(inst_19845)){
var statearr_19886_19915 = state_19871__$1;
(statearr_19886_19915[(1)] = (8));

} else {
var statearr_19887_19916 = state_19871__$1;
(statearr_19887_19916[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (14))){
var inst_19864 = (state_19871[(2)]);
var inst_19865 = cljs.core.async.close_BANG_.call(null,out);
var state_19871__$1 = (function (){var statearr_19889 = state_19871;
(statearr_19889[(13)] = inst_19864);

return statearr_19889;
})();
var statearr_19890_19917 = state_19871__$1;
(statearr_19890_19917[(2)] = inst_19865);

(statearr_19890_19917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (10))){
var inst_19855 = (state_19871[(2)]);
var state_19871__$1 = state_19871;
var statearr_19891_19918 = state_19871__$1;
(statearr_19891_19918[(2)] = inst_19855);

(statearr_19891_19918[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19872 === (8))){
var inst_19835 = (state_19871[(7)]);
var inst_19844 = (state_19871[(11)]);
var tmp19888 = inst_19835;
var inst_19835__$1 = tmp19888;
var inst_19836 = inst_19844;
var state_19871__$1 = (function (){var statearr_19892 = state_19871;
(statearr_19892[(7)] = inst_19835__$1);

(statearr_19892[(8)] = inst_19836);

return statearr_19892;
})();
var statearr_19893_19919 = state_19871__$1;
(statearr_19893_19919[(2)] = null);

(statearr_19893_19919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19905,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19905,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19897[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19897[(1)] = (1));

return statearr_19897;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19871){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19898){if((e19898 instanceof Object)){
var ex__8254__auto__ = e19898;
var statearr_19899_19920 = state_19871;
(statearr_19899_19920[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19921 = state_19871;
state_19871 = G__19921;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19871){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19905,out))
})();
var state__8364__auto__ = (function (){var statearr_19900 = f__8363__auto__.call(null);
(statearr_19900[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19905);

return statearr_19900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19905,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19922 = [];
var len__5726__auto___19996 = arguments.length;
var i__5727__auto___19997 = (0);
while(true){
if((i__5727__auto___19997 < len__5726__auto___19996)){
args19922.push((arguments[i__5727__auto___19997]));

var G__19998 = (i__5727__auto___19997 + (1));
i__5727__auto___19997 = G__19998;
continue;
} else {
}
break;
}

var G__19924 = args19922.length;
switch (G__19924) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19922.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___20000 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___20000,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___20000,out){
return (function (state_19966){
var state_val_19967 = (state_19966[(1)]);
if((state_val_19967 === (7))){
var inst_19962 = (state_19966[(2)]);
var state_19966__$1 = state_19966;
var statearr_19968_20001 = state_19966__$1;
(statearr_19968_20001[(2)] = inst_19962);

(statearr_19968_20001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (1))){
var inst_19925 = [];
var inst_19926 = inst_19925;
var inst_19927 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19966__$1 = (function (){var statearr_19969 = state_19966;
(statearr_19969[(7)] = inst_19927);

(statearr_19969[(8)] = inst_19926);

return statearr_19969;
})();
var statearr_19970_20002 = state_19966__$1;
(statearr_19970_20002[(2)] = null);

(statearr_19970_20002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (4))){
var inst_19930 = (state_19966[(9)]);
var inst_19930__$1 = (state_19966[(2)]);
var inst_19931 = (inst_19930__$1 == null);
var inst_19932 = cljs.core.not.call(null,inst_19931);
var state_19966__$1 = (function (){var statearr_19971 = state_19966;
(statearr_19971[(9)] = inst_19930__$1);

return statearr_19971;
})();
if(inst_19932){
var statearr_19972_20003 = state_19966__$1;
(statearr_19972_20003[(1)] = (5));

} else {
var statearr_19973_20004 = state_19966__$1;
(statearr_19973_20004[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (15))){
var inst_19956 = (state_19966[(2)]);
var state_19966__$1 = state_19966;
var statearr_19974_20005 = state_19966__$1;
(statearr_19974_20005[(2)] = inst_19956);

(statearr_19974_20005[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (13))){
var state_19966__$1 = state_19966;
var statearr_19975_20006 = state_19966__$1;
(statearr_19975_20006[(2)] = null);

(statearr_19975_20006[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (6))){
var inst_19926 = (state_19966[(8)]);
var inst_19951 = inst_19926.length;
var inst_19952 = (inst_19951 > (0));
var state_19966__$1 = state_19966;
if(cljs.core.truth_(inst_19952)){
var statearr_19976_20007 = state_19966__$1;
(statearr_19976_20007[(1)] = (12));

} else {
var statearr_19977_20008 = state_19966__$1;
(statearr_19977_20008[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (3))){
var inst_19964 = (state_19966[(2)]);
var state_19966__$1 = state_19966;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19966__$1,inst_19964);
} else {
if((state_val_19967 === (12))){
var inst_19926 = (state_19966[(8)]);
var inst_19954 = cljs.core.vec.call(null,inst_19926);
var state_19966__$1 = state_19966;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19966__$1,(15),out,inst_19954);
} else {
if((state_val_19967 === (2))){
var state_19966__$1 = state_19966;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19966__$1,(4),ch);
} else {
if((state_val_19967 === (11))){
var inst_19930 = (state_19966[(9)]);
var inst_19934 = (state_19966[(10)]);
var inst_19944 = (state_19966[(2)]);
var inst_19945 = [];
var inst_19946 = inst_19945.push(inst_19930);
var inst_19926 = inst_19945;
var inst_19927 = inst_19934;
var state_19966__$1 = (function (){var statearr_19978 = state_19966;
(statearr_19978[(7)] = inst_19927);

(statearr_19978[(11)] = inst_19946);

(statearr_19978[(8)] = inst_19926);

(statearr_19978[(12)] = inst_19944);

return statearr_19978;
})();
var statearr_19979_20009 = state_19966__$1;
(statearr_19979_20009[(2)] = null);

(statearr_19979_20009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (9))){
var inst_19926 = (state_19966[(8)]);
var inst_19942 = cljs.core.vec.call(null,inst_19926);
var state_19966__$1 = state_19966;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19966__$1,(11),out,inst_19942);
} else {
if((state_val_19967 === (5))){
var inst_19927 = (state_19966[(7)]);
var inst_19930 = (state_19966[(9)]);
var inst_19934 = (state_19966[(10)]);
var inst_19934__$1 = f.call(null,inst_19930);
var inst_19935 = cljs.core._EQ_.call(null,inst_19934__$1,inst_19927);
var inst_19936 = cljs.core.keyword_identical_QMARK_.call(null,inst_19927,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19937 = (inst_19935) || (inst_19936);
var state_19966__$1 = (function (){var statearr_19980 = state_19966;
(statearr_19980[(10)] = inst_19934__$1);

return statearr_19980;
})();
if(cljs.core.truth_(inst_19937)){
var statearr_19981_20010 = state_19966__$1;
(statearr_19981_20010[(1)] = (8));

} else {
var statearr_19982_20011 = state_19966__$1;
(statearr_19982_20011[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (14))){
var inst_19959 = (state_19966[(2)]);
var inst_19960 = cljs.core.async.close_BANG_.call(null,out);
var state_19966__$1 = (function (){var statearr_19984 = state_19966;
(statearr_19984[(13)] = inst_19959);

return statearr_19984;
})();
var statearr_19985_20012 = state_19966__$1;
(statearr_19985_20012[(2)] = inst_19960);

(statearr_19985_20012[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (10))){
var inst_19949 = (state_19966[(2)]);
var state_19966__$1 = state_19966;
var statearr_19986_20013 = state_19966__$1;
(statearr_19986_20013[(2)] = inst_19949);

(statearr_19986_20013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19967 === (8))){
var inst_19926 = (state_19966[(8)]);
var inst_19930 = (state_19966[(9)]);
var inst_19934 = (state_19966[(10)]);
var inst_19939 = inst_19926.push(inst_19930);
var tmp19983 = inst_19926;
var inst_19926__$1 = tmp19983;
var inst_19927 = inst_19934;
var state_19966__$1 = (function (){var statearr_19987 = state_19966;
(statearr_19987[(7)] = inst_19927);

(statearr_19987[(8)] = inst_19926__$1);

(statearr_19987[(14)] = inst_19939);

return statearr_19987;
})();
var statearr_19988_20014 = state_19966__$1;
(statearr_19988_20014[(2)] = null);

(statearr_19988_20014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___20000,out))
;
return ((function (switch__8250__auto__,c__8362__auto___20000,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19992[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19992[(1)] = (1));

return statearr_19992;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19966){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19966);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19993){if((e19993 instanceof Object)){
var ex__8254__auto__ = e19993;
var statearr_19994_20015 = state_19966;
(statearr_19994_20015[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19966);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19993;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20016 = state_19966;
state_19966 = G__20016;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19966){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___20000,out))
})();
var state__8364__auto__ = (function (){var statearr_19995 = f__8363__auto__.call(null);
(statearr_19995[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___20000);

return statearr_19995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___20000,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1453898983327