// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18882 = [];
var len__5726__auto___18888 = arguments.length;
var i__5727__auto___18889 = (0);
while(true){
if((i__5727__auto___18889 < len__5726__auto___18888)){
args18882.push((arguments[i__5727__auto___18889]));

var G__18890 = (i__5727__auto___18889 + (1));
i__5727__auto___18889 = G__18890;
continue;
} else {
}
break;
}

var G__18884 = args18882.length;
switch (G__18884) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18882.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18885 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18885 = (function (f,blockable,meta18886){
this.f = f;
this.blockable = blockable;
this.meta18886 = meta18886;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18885.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18887,meta18886__$1){
var self__ = this;
var _18887__$1 = this;
return (new cljs.core.async.t_cljs$core$async18885(self__.f,self__.blockable,meta18886__$1));
});

cljs.core.async.t_cljs$core$async18885.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18887){
var self__ = this;
var _18887__$1 = this;
return self__.meta18886;
});

cljs.core.async.t_cljs$core$async18885.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18885.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18885.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18885.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18885.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18886","meta18886",1619022610,null)], null);
});

cljs.core.async.t_cljs$core$async18885.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18885.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18885";

cljs.core.async.t_cljs$core$async18885.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18885");
});

cljs.core.async.__GT_t_cljs$core$async18885 = (function cljs$core$async$__GT_t_cljs$core$async18885(f__$1,blockable__$1,meta18886){
return (new cljs.core.async.t_cljs$core$async18885(f__$1,blockable__$1,meta18886));
});

}

return (new cljs.core.async.t_cljs$core$async18885(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args18894 = [];
var len__5726__auto___18897 = arguments.length;
var i__5727__auto___18898 = (0);
while(true){
if((i__5727__auto___18898 < len__5726__auto___18897)){
args18894.push((arguments[i__5727__auto___18898]));

var G__18899 = (i__5727__auto___18898 + (1));
i__5727__auto___18898 = G__18899;
continue;
} else {
}
break;
}

var G__18896 = args18894.length;
switch (G__18896) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18894.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args18901 = [];
var len__5726__auto___18904 = arguments.length;
var i__5727__auto___18905 = (0);
while(true){
if((i__5727__auto___18905 < len__5726__auto___18904)){
args18901.push((arguments[i__5727__auto___18905]));

var G__18906 = (i__5727__auto___18905 + (1));
i__5727__auto___18905 = G__18906;
continue;
} else {
}
break;
}

var G__18903 = args18901.length;
switch (G__18903) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18901.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args18908 = [];
var len__5726__auto___18911 = arguments.length;
var i__5727__auto___18912 = (0);
while(true){
if((i__5727__auto___18912 < len__5726__auto___18911)){
args18908.push((arguments[i__5727__auto___18912]));

var G__18913 = (i__5727__auto___18912 + (1));
i__5727__auto___18912 = G__18913;
continue;
} else {
}
break;
}

var G__18910 = args18908.length;
switch (G__18910) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18908.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_18915 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_18915);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_18915,ret){
return (function (){
return fn1.call(null,val_18915);
});})(val_18915,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args18916 = [];
var len__5726__auto___18919 = arguments.length;
var i__5727__auto___18920 = (0);
while(true){
if((i__5727__auto___18920 < len__5726__auto___18919)){
args18916.push((arguments[i__5727__auto___18920]));

var G__18921 = (i__5727__auto___18920 + (1));
i__5727__auto___18920 = G__18921;
continue;
} else {
}
break;
}

var G__18918 = args18916.length;
switch (G__18918) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18916.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___18923 = n;
var x_18924 = (0);
while(true){
if((x_18924 < n__5571__auto___18923)){
(a[x_18924] = (0));

var G__18925 = (x_18924 + (1));
x_18924 = G__18925;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__18926 = (i + (1));
i = G__18926;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async18930 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18930 = (function (alt_flag,flag,meta18931){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta18931 = meta18931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_18932,meta18931__$1){
var self__ = this;
var _18932__$1 = this;
return (new cljs.core.async.t_cljs$core$async18930(self__.alt_flag,self__.flag,meta18931__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async18930.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_18932){
var self__ = this;
var _18932__$1 = this;
return self__.meta18931;
});})(flag))
;

cljs.core.async.t_cljs$core$async18930.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18930.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async18930.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18930.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18930.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta18931","meta18931",1148236940,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async18930.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18930.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18930";

cljs.core.async.t_cljs$core$async18930.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18930");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async18930 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18930(alt_flag__$1,flag__$1,meta18931){
return (new cljs.core.async.t_cljs$core$async18930(alt_flag__$1,flag__$1,meta18931));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async18930(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async18936 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18936 = (function (alt_handler,flag,cb,meta18937){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta18937 = meta18937;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18936.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18938,meta18937__$1){
var self__ = this;
var _18938__$1 = this;
return (new cljs.core.async.t_cljs$core$async18936(self__.alt_handler,self__.flag,self__.cb,meta18937__$1));
});

cljs.core.async.t_cljs$core$async18936.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18938){
var self__ = this;
var _18938__$1 = this;
return self__.meta18937;
});

cljs.core.async.t_cljs$core$async18936.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18936.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async18936.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18936.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async18936.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta18937","meta18937",701698099,null)], null);
});

cljs.core.async.t_cljs$core$async18936.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18936.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18936";

cljs.core.async.t_cljs$core$async18936.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18936");
});

cljs.core.async.__GT_t_cljs$core$async18936 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18936(alt_handler__$1,flag__$1,cb__$1,meta18937){
return (new cljs.core.async.t_cljs$core$async18936(alt_handler__$1,flag__$1,cb__$1,meta18937));
});

}

return (new cljs.core.async.t_cljs$core$async18936(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18939_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18939_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18940_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18940_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18941 = (i + (1));
i = G__18941;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18947 = arguments.length;
var i__5727__auto___18948 = (0);
while(true){
if((i__5727__auto___18948 < len__5726__auto___18947)){
args__5733__auto__.push((arguments[i__5727__auto___18948]));

var G__18949 = (i__5727__auto___18948 + (1));
i__5727__auto___18948 = G__18949;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18944){
var map__18945 = p__18944;
var map__18945__$1 = ((((!((map__18945 == null)))?((((map__18945.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18945.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18945):map__18945);
var opts = map__18945__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18942){
var G__18943 = cljs.core.first.call(null,seq18942);
var seq18942__$1 = cljs.core.next.call(null,seq18942);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18943,seq18942__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args18950 = [];
var len__5726__auto___19000 = arguments.length;
var i__5727__auto___19001 = (0);
while(true){
if((i__5727__auto___19001 < len__5726__auto___19000)){
args18950.push((arguments[i__5727__auto___19001]));

var G__19002 = (i__5727__auto___19001 + (1));
i__5727__auto___19001 = G__19002;
continue;
} else {
}
break;
}

var G__18952 = args18950.length;
switch (G__18952) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18950.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11044__auto___19004 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___19004){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___19004){
return (function (state_18976){
var state_val_18977 = (state_18976[(1)]);
if((state_val_18977 === (7))){
var inst_18972 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_18978_19005 = state_18976__$1;
(statearr_18978_19005[(2)] = inst_18972);

(statearr_18978_19005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (1))){
var state_18976__$1 = state_18976;
var statearr_18979_19006 = state_18976__$1;
(statearr_18979_19006[(2)] = null);

(statearr_18979_19006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (4))){
var inst_18955 = (state_18976[(7)]);
var inst_18955__$1 = (state_18976[(2)]);
var inst_18956 = (inst_18955__$1 == null);
var state_18976__$1 = (function (){var statearr_18980 = state_18976;
(statearr_18980[(7)] = inst_18955__$1);

return statearr_18980;
})();
if(cljs.core.truth_(inst_18956)){
var statearr_18981_19007 = state_18976__$1;
(statearr_18981_19007[(1)] = (5));

} else {
var statearr_18982_19008 = state_18976__$1;
(statearr_18982_19008[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (13))){
var state_18976__$1 = state_18976;
var statearr_18983_19009 = state_18976__$1;
(statearr_18983_19009[(2)] = null);

(statearr_18983_19009[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (6))){
var inst_18955 = (state_18976[(7)]);
var state_18976__$1 = state_18976;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18976__$1,(11),to,inst_18955);
} else {
if((state_val_18977 === (3))){
var inst_18974 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18976__$1,inst_18974);
} else {
if((state_val_18977 === (12))){
var state_18976__$1 = state_18976;
var statearr_18984_19010 = state_18976__$1;
(statearr_18984_19010[(2)] = null);

(statearr_18984_19010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (2))){
var state_18976__$1 = state_18976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18976__$1,(4),from);
} else {
if((state_val_18977 === (11))){
var inst_18965 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
if(cljs.core.truth_(inst_18965)){
var statearr_18985_19011 = state_18976__$1;
(statearr_18985_19011[(1)] = (12));

} else {
var statearr_18986_19012 = state_18976__$1;
(statearr_18986_19012[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (9))){
var state_18976__$1 = state_18976;
var statearr_18987_19013 = state_18976__$1;
(statearr_18987_19013[(2)] = null);

(statearr_18987_19013[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (5))){
var state_18976__$1 = state_18976;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18988_19014 = state_18976__$1;
(statearr_18988_19014[(1)] = (8));

} else {
var statearr_18989_19015 = state_18976__$1;
(statearr_18989_19015[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (14))){
var inst_18970 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_18990_19016 = state_18976__$1;
(statearr_18990_19016[(2)] = inst_18970);

(statearr_18990_19016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (10))){
var inst_18962 = (state_18976[(2)]);
var state_18976__$1 = state_18976;
var statearr_18991_19017 = state_18976__$1;
(statearr_18991_19017[(2)] = inst_18962);

(statearr_18991_19017[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18977 === (8))){
var inst_18959 = cljs.core.async.close_BANG_.call(null,to);
var state_18976__$1 = state_18976;
var statearr_18992_19018 = state_18976__$1;
(statearr_18992_19018[(2)] = inst_18959);

(statearr_18992_19018[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___19004))
;
return ((function (switch__10932__auto__,c__11044__auto___19004){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_18996 = [null,null,null,null,null,null,null,null];
(statearr_18996[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_18996[(1)] = (1));

return statearr_18996;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_18976){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_18976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e18997){if((e18997 instanceof Object)){
var ex__10936__auto__ = e18997;
var statearr_18998_19019 = state_18976;
(statearr_18998_19019[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18976);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18997;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19020 = state_18976;
state_18976 = G__19020;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_18976){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_18976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___19004))
})();
var state__11046__auto__ = (function (){var statearr_18999 = f__11045__auto__.call(null);
(statearr_18999[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___19004);

return statearr_18999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___19004))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__19204){
var vec__19205 = p__19204;
var v = cljs.core.nth.call(null,vec__19205,(0),null);
var p = cljs.core.nth.call(null,vec__19205,(1),null);
var job = vec__19205;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11044__auto___19387 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___19387,res,vec__19205,v,p,job,jobs,results){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___19387,res,vec__19205,v,p,job,jobs,results){
return (function (state_19210){
var state_val_19211 = (state_19210[(1)]);
if((state_val_19211 === (1))){
var state_19210__$1 = state_19210;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19210__$1,(2),res,v);
} else {
if((state_val_19211 === (2))){
var inst_19207 = (state_19210[(2)]);
var inst_19208 = cljs.core.async.close_BANG_.call(null,res);
var state_19210__$1 = (function (){var statearr_19212 = state_19210;
(statearr_19212[(7)] = inst_19207);

return statearr_19212;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19210__$1,inst_19208);
} else {
return null;
}
}
});})(c__11044__auto___19387,res,vec__19205,v,p,job,jobs,results))
;
return ((function (switch__10932__auto__,c__11044__auto___19387,res,vec__19205,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_19216 = [null,null,null,null,null,null,null,null];
(statearr_19216[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_19216[(1)] = (1));

return statearr_19216;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_19210){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_19210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e19217){if((e19217 instanceof Object)){
var ex__10936__auto__ = e19217;
var statearr_19218_19388 = state_19210;
(statearr_19218_19388[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19217;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19389 = state_19210;
state_19210 = G__19389;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_19210){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_19210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___19387,res,vec__19205,v,p,job,jobs,results))
})();
var state__11046__auto__ = (function (){var statearr_19219 = f__11045__auto__.call(null);
(statearr_19219[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___19387);

return statearr_19219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___19387,res,vec__19205,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__19220){
var vec__19221 = p__19220;
var v = cljs.core.nth.call(null,vec__19221,(0),null);
var p = cljs.core.nth.call(null,vec__19221,(1),null);
var job = vec__19221;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___19390 = n;
var __19391 = (0);
while(true){
if((__19391 < n__5571__auto___19390)){
var G__19222_19392 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__19222_19392) {
case "compute":
var c__11044__auto___19394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19391,c__11044__auto___19394,G__19222_19392,n__5571__auto___19390,jobs,results,process,async){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (__19391,c__11044__auto___19394,G__19222_19392,n__5571__auto___19390,jobs,results,process,async){
return (function (state_19235){
var state_val_19236 = (state_19235[(1)]);
if((state_val_19236 === (1))){
var state_19235__$1 = state_19235;
var statearr_19237_19395 = state_19235__$1;
(statearr_19237_19395[(2)] = null);

(statearr_19237_19395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19236 === (2))){
var state_19235__$1 = state_19235;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19235__$1,(4),jobs);
} else {
if((state_val_19236 === (3))){
var inst_19233 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19235__$1,inst_19233);
} else {
if((state_val_19236 === (4))){
var inst_19225 = (state_19235[(2)]);
var inst_19226 = process.call(null,inst_19225);
var state_19235__$1 = state_19235;
if(cljs.core.truth_(inst_19226)){
var statearr_19238_19396 = state_19235__$1;
(statearr_19238_19396[(1)] = (5));

} else {
var statearr_19239_19397 = state_19235__$1;
(statearr_19239_19397[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19236 === (5))){
var state_19235__$1 = state_19235;
var statearr_19240_19398 = state_19235__$1;
(statearr_19240_19398[(2)] = null);

(statearr_19240_19398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19236 === (6))){
var state_19235__$1 = state_19235;
var statearr_19241_19399 = state_19235__$1;
(statearr_19241_19399[(2)] = null);

(statearr_19241_19399[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19236 === (7))){
var inst_19231 = (state_19235[(2)]);
var state_19235__$1 = state_19235;
var statearr_19242_19400 = state_19235__$1;
(statearr_19242_19400[(2)] = inst_19231);

(statearr_19242_19400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19391,c__11044__auto___19394,G__19222_19392,n__5571__auto___19390,jobs,results,process,async))
;
return ((function (__19391,switch__10932__auto__,c__11044__auto___19394,G__19222_19392,n__5571__auto___19390,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_19246 = [null,null,null,null,null,null,null];
(statearr_19246[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_19246[(1)] = (1));

return statearr_19246;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_19235){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_19235);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e19247){if((e19247 instanceof Object)){
var ex__10936__auto__ = e19247;
var statearr_19248_19401 = state_19235;
(statearr_19248_19401[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19235);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19247;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19402 = state_19235;
state_19235 = G__19402;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_19235){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_19235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(__19391,switch__10932__auto__,c__11044__auto___19394,G__19222_19392,n__5571__auto___19390,jobs,results,process,async))
})();
var state__11046__auto__ = (function (){var statearr_19249 = f__11045__auto__.call(null);
(statearr_19249[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___19394);

return statearr_19249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(__19391,c__11044__auto___19394,G__19222_19392,n__5571__auto___19390,jobs,results,process,async))
);


break;
case "async":
var c__11044__auto___19403 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__19391,c__11044__auto___19403,G__19222_19392,n__5571__auto___19390,jobs,results,process,async){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (__19391,c__11044__auto___19403,G__19222_19392,n__5571__auto___19390,jobs,results,process,async){
return (function (state_19262){
var state_val_19263 = (state_19262[(1)]);
if((state_val_19263 === (1))){
var state_19262__$1 = state_19262;
var statearr_19264_19404 = state_19262__$1;
(statearr_19264_19404[(2)] = null);

(statearr_19264_19404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (2))){
var state_19262__$1 = state_19262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19262__$1,(4),jobs);
} else {
if((state_val_19263 === (3))){
var inst_19260 = (state_19262[(2)]);
var state_19262__$1 = state_19262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19262__$1,inst_19260);
} else {
if((state_val_19263 === (4))){
var inst_19252 = (state_19262[(2)]);
var inst_19253 = async.call(null,inst_19252);
var state_19262__$1 = state_19262;
if(cljs.core.truth_(inst_19253)){
var statearr_19265_19405 = state_19262__$1;
(statearr_19265_19405[(1)] = (5));

} else {
var statearr_19266_19406 = state_19262__$1;
(statearr_19266_19406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (5))){
var state_19262__$1 = state_19262;
var statearr_19267_19407 = state_19262__$1;
(statearr_19267_19407[(2)] = null);

(statearr_19267_19407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (6))){
var state_19262__$1 = state_19262;
var statearr_19268_19408 = state_19262__$1;
(statearr_19268_19408[(2)] = null);

(statearr_19268_19408[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19263 === (7))){
var inst_19258 = (state_19262[(2)]);
var state_19262__$1 = state_19262;
var statearr_19269_19409 = state_19262__$1;
(statearr_19269_19409[(2)] = inst_19258);

(statearr_19269_19409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__19391,c__11044__auto___19403,G__19222_19392,n__5571__auto___19390,jobs,results,process,async))
;
return ((function (__19391,switch__10932__auto__,c__11044__auto___19403,G__19222_19392,n__5571__auto___19390,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_19273 = [null,null,null,null,null,null,null];
(statearr_19273[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_19273[(1)] = (1));

return statearr_19273;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_19262){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_19262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e19274){if((e19274 instanceof Object)){
var ex__10936__auto__ = e19274;
var statearr_19275_19410 = state_19262;
(statearr_19275_19410[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19262);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19274;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19411 = state_19262;
state_19262 = G__19411;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_19262){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_19262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(__19391,switch__10932__auto__,c__11044__auto___19403,G__19222_19392,n__5571__auto___19390,jobs,results,process,async))
})();
var state__11046__auto__ = (function (){var statearr_19276 = f__11045__auto__.call(null);
(statearr_19276[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___19403);

return statearr_19276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(__19391,c__11044__auto___19403,G__19222_19392,n__5571__auto___19390,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__19412 = (__19391 + (1));
__19391 = G__19412;
continue;
} else {
}
break;
}

var c__11044__auto___19413 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___19413,jobs,results,process,async){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___19413,jobs,results,process,async){
return (function (state_19298){
var state_val_19299 = (state_19298[(1)]);
if((state_val_19299 === (1))){
var state_19298__$1 = state_19298;
var statearr_19300_19414 = state_19298__$1;
(statearr_19300_19414[(2)] = null);

(statearr_19300_19414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (2))){
var state_19298__$1 = state_19298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19298__$1,(4),from);
} else {
if((state_val_19299 === (3))){
var inst_19296 = (state_19298[(2)]);
var state_19298__$1 = state_19298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19298__$1,inst_19296);
} else {
if((state_val_19299 === (4))){
var inst_19279 = (state_19298[(7)]);
var inst_19279__$1 = (state_19298[(2)]);
var inst_19280 = (inst_19279__$1 == null);
var state_19298__$1 = (function (){var statearr_19301 = state_19298;
(statearr_19301[(7)] = inst_19279__$1);

return statearr_19301;
})();
if(cljs.core.truth_(inst_19280)){
var statearr_19302_19415 = state_19298__$1;
(statearr_19302_19415[(1)] = (5));

} else {
var statearr_19303_19416 = state_19298__$1;
(statearr_19303_19416[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (5))){
var inst_19282 = cljs.core.async.close_BANG_.call(null,jobs);
var state_19298__$1 = state_19298;
var statearr_19304_19417 = state_19298__$1;
(statearr_19304_19417[(2)] = inst_19282);

(statearr_19304_19417[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (6))){
var inst_19279 = (state_19298[(7)]);
var inst_19284 = (state_19298[(8)]);
var inst_19284__$1 = cljs.core.async.chan.call(null,(1));
var inst_19285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19286 = [inst_19279,inst_19284__$1];
var inst_19287 = (new cljs.core.PersistentVector(null,2,(5),inst_19285,inst_19286,null));
var state_19298__$1 = (function (){var statearr_19305 = state_19298;
(statearr_19305[(8)] = inst_19284__$1);

return statearr_19305;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19298__$1,(8),jobs,inst_19287);
} else {
if((state_val_19299 === (7))){
var inst_19294 = (state_19298[(2)]);
var state_19298__$1 = state_19298;
var statearr_19306_19418 = state_19298__$1;
(statearr_19306_19418[(2)] = inst_19294);

(statearr_19306_19418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (8))){
var inst_19284 = (state_19298[(8)]);
var inst_19289 = (state_19298[(2)]);
var state_19298__$1 = (function (){var statearr_19307 = state_19298;
(statearr_19307[(9)] = inst_19289);

return statearr_19307;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19298__$1,(9),results,inst_19284);
} else {
if((state_val_19299 === (9))){
var inst_19291 = (state_19298[(2)]);
var state_19298__$1 = (function (){var statearr_19308 = state_19298;
(statearr_19308[(10)] = inst_19291);

return statearr_19308;
})();
var statearr_19309_19419 = state_19298__$1;
(statearr_19309_19419[(2)] = null);

(statearr_19309_19419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___19413,jobs,results,process,async))
;
return ((function (switch__10932__auto__,c__11044__auto___19413,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_19313 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19313[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_19313[(1)] = (1));

return statearr_19313;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_19298){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_19298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e19314){if((e19314 instanceof Object)){
var ex__10936__auto__ = e19314;
var statearr_19315_19420 = state_19298;
(statearr_19315_19420[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19314;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19421 = state_19298;
state_19298 = G__19421;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_19298){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_19298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___19413,jobs,results,process,async))
})();
var state__11046__auto__ = (function (){var statearr_19316 = f__11045__auto__.call(null);
(statearr_19316[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___19413);

return statearr_19316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___19413,jobs,results,process,async))
);


var c__11044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto__,jobs,results,process,async){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto__,jobs,results,process,async){
return (function (state_19354){
var state_val_19355 = (state_19354[(1)]);
if((state_val_19355 === (7))){
var inst_19350 = (state_19354[(2)]);
var state_19354__$1 = state_19354;
var statearr_19356_19422 = state_19354__$1;
(statearr_19356_19422[(2)] = inst_19350);

(statearr_19356_19422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (20))){
var state_19354__$1 = state_19354;
var statearr_19357_19423 = state_19354__$1;
(statearr_19357_19423[(2)] = null);

(statearr_19357_19423[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (1))){
var state_19354__$1 = state_19354;
var statearr_19358_19424 = state_19354__$1;
(statearr_19358_19424[(2)] = null);

(statearr_19358_19424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (4))){
var inst_19319 = (state_19354[(7)]);
var inst_19319__$1 = (state_19354[(2)]);
var inst_19320 = (inst_19319__$1 == null);
var state_19354__$1 = (function (){var statearr_19359 = state_19354;
(statearr_19359[(7)] = inst_19319__$1);

return statearr_19359;
})();
if(cljs.core.truth_(inst_19320)){
var statearr_19360_19425 = state_19354__$1;
(statearr_19360_19425[(1)] = (5));

} else {
var statearr_19361_19426 = state_19354__$1;
(statearr_19361_19426[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (15))){
var inst_19332 = (state_19354[(8)]);
var state_19354__$1 = state_19354;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19354__$1,(18),to,inst_19332);
} else {
if((state_val_19355 === (21))){
var inst_19345 = (state_19354[(2)]);
var state_19354__$1 = state_19354;
var statearr_19362_19427 = state_19354__$1;
(statearr_19362_19427[(2)] = inst_19345);

(statearr_19362_19427[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (13))){
var inst_19347 = (state_19354[(2)]);
var state_19354__$1 = (function (){var statearr_19363 = state_19354;
(statearr_19363[(9)] = inst_19347);

return statearr_19363;
})();
var statearr_19364_19428 = state_19354__$1;
(statearr_19364_19428[(2)] = null);

(statearr_19364_19428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (6))){
var inst_19319 = (state_19354[(7)]);
var state_19354__$1 = state_19354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19354__$1,(11),inst_19319);
} else {
if((state_val_19355 === (17))){
var inst_19340 = (state_19354[(2)]);
var state_19354__$1 = state_19354;
if(cljs.core.truth_(inst_19340)){
var statearr_19365_19429 = state_19354__$1;
(statearr_19365_19429[(1)] = (19));

} else {
var statearr_19366_19430 = state_19354__$1;
(statearr_19366_19430[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (3))){
var inst_19352 = (state_19354[(2)]);
var state_19354__$1 = state_19354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19354__$1,inst_19352);
} else {
if((state_val_19355 === (12))){
var inst_19329 = (state_19354[(10)]);
var state_19354__$1 = state_19354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19354__$1,(14),inst_19329);
} else {
if((state_val_19355 === (2))){
var state_19354__$1 = state_19354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19354__$1,(4),results);
} else {
if((state_val_19355 === (19))){
var state_19354__$1 = state_19354;
var statearr_19367_19431 = state_19354__$1;
(statearr_19367_19431[(2)] = null);

(statearr_19367_19431[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (11))){
var inst_19329 = (state_19354[(2)]);
var state_19354__$1 = (function (){var statearr_19368 = state_19354;
(statearr_19368[(10)] = inst_19329);

return statearr_19368;
})();
var statearr_19369_19432 = state_19354__$1;
(statearr_19369_19432[(2)] = null);

(statearr_19369_19432[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (9))){
var state_19354__$1 = state_19354;
var statearr_19370_19433 = state_19354__$1;
(statearr_19370_19433[(2)] = null);

(statearr_19370_19433[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (5))){
var state_19354__$1 = state_19354;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19371_19434 = state_19354__$1;
(statearr_19371_19434[(1)] = (8));

} else {
var statearr_19372_19435 = state_19354__$1;
(statearr_19372_19435[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (14))){
var inst_19334 = (state_19354[(11)]);
var inst_19332 = (state_19354[(8)]);
var inst_19332__$1 = (state_19354[(2)]);
var inst_19333 = (inst_19332__$1 == null);
var inst_19334__$1 = cljs.core.not.call(null,inst_19333);
var state_19354__$1 = (function (){var statearr_19373 = state_19354;
(statearr_19373[(11)] = inst_19334__$1);

(statearr_19373[(8)] = inst_19332__$1);

return statearr_19373;
})();
if(inst_19334__$1){
var statearr_19374_19436 = state_19354__$1;
(statearr_19374_19436[(1)] = (15));

} else {
var statearr_19375_19437 = state_19354__$1;
(statearr_19375_19437[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (16))){
var inst_19334 = (state_19354[(11)]);
var state_19354__$1 = state_19354;
var statearr_19376_19438 = state_19354__$1;
(statearr_19376_19438[(2)] = inst_19334);

(statearr_19376_19438[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (10))){
var inst_19326 = (state_19354[(2)]);
var state_19354__$1 = state_19354;
var statearr_19377_19439 = state_19354__$1;
(statearr_19377_19439[(2)] = inst_19326);

(statearr_19377_19439[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (18))){
var inst_19337 = (state_19354[(2)]);
var state_19354__$1 = state_19354;
var statearr_19378_19440 = state_19354__$1;
(statearr_19378_19440[(2)] = inst_19337);

(statearr_19378_19440[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19355 === (8))){
var inst_19323 = cljs.core.async.close_BANG_.call(null,to);
var state_19354__$1 = state_19354;
var statearr_19379_19441 = state_19354__$1;
(statearr_19379_19441[(2)] = inst_19323);

(statearr_19379_19441[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto__,jobs,results,process,async))
;
return ((function (switch__10932__auto__,c__11044__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_19383 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19383[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_19383[(1)] = (1));

return statearr_19383;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_19354){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_19354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e19384){if((e19384 instanceof Object)){
var ex__10936__auto__ = e19384;
var statearr_19385_19442 = state_19354;
(statearr_19385_19442[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19354);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19384;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19443 = state_19354;
state_19354 = G__19443;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_19354){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_19354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto__,jobs,results,process,async))
})();
var state__11046__auto__ = (function (){var statearr_19386 = f__11045__auto__.call(null);
(statearr_19386[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto__);

return statearr_19386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto__,jobs,results,process,async))
);

return c__11044__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args19444 = [];
var len__5726__auto___19447 = arguments.length;
var i__5727__auto___19448 = (0);
while(true){
if((i__5727__auto___19448 < len__5726__auto___19447)){
args19444.push((arguments[i__5727__auto___19448]));

var G__19449 = (i__5727__auto___19448 + (1));
i__5727__auto___19448 = G__19449;
continue;
} else {
}
break;
}

var G__19446 = args19444.length;
switch (G__19446) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19444.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args19451 = [];
var len__5726__auto___19454 = arguments.length;
var i__5727__auto___19455 = (0);
while(true){
if((i__5727__auto___19455 < len__5726__auto___19454)){
args19451.push((arguments[i__5727__auto___19455]));

var G__19456 = (i__5727__auto___19455 + (1));
i__5727__auto___19455 = G__19456;
continue;
} else {
}
break;
}

var G__19453 = args19451.length;
switch (G__19453) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19451.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args19458 = [];
var len__5726__auto___19511 = arguments.length;
var i__5727__auto___19512 = (0);
while(true){
if((i__5727__auto___19512 < len__5726__auto___19511)){
args19458.push((arguments[i__5727__auto___19512]));

var G__19513 = (i__5727__auto___19512 + (1));
i__5727__auto___19512 = G__19513;
continue;
} else {
}
break;
}

var G__19460 = args19458.length;
switch (G__19460) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19458.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11044__auto___19515 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___19515,tc,fc){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___19515,tc,fc){
return (function (state_19486){
var state_val_19487 = (state_19486[(1)]);
if((state_val_19487 === (7))){
var inst_19482 = (state_19486[(2)]);
var state_19486__$1 = state_19486;
var statearr_19488_19516 = state_19486__$1;
(statearr_19488_19516[(2)] = inst_19482);

(statearr_19488_19516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (1))){
var state_19486__$1 = state_19486;
var statearr_19489_19517 = state_19486__$1;
(statearr_19489_19517[(2)] = null);

(statearr_19489_19517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (4))){
var inst_19463 = (state_19486[(7)]);
var inst_19463__$1 = (state_19486[(2)]);
var inst_19464 = (inst_19463__$1 == null);
var state_19486__$1 = (function (){var statearr_19490 = state_19486;
(statearr_19490[(7)] = inst_19463__$1);

return statearr_19490;
})();
if(cljs.core.truth_(inst_19464)){
var statearr_19491_19518 = state_19486__$1;
(statearr_19491_19518[(1)] = (5));

} else {
var statearr_19492_19519 = state_19486__$1;
(statearr_19492_19519[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (13))){
var state_19486__$1 = state_19486;
var statearr_19493_19520 = state_19486__$1;
(statearr_19493_19520[(2)] = null);

(statearr_19493_19520[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (6))){
var inst_19463 = (state_19486[(7)]);
var inst_19469 = p.call(null,inst_19463);
var state_19486__$1 = state_19486;
if(cljs.core.truth_(inst_19469)){
var statearr_19494_19521 = state_19486__$1;
(statearr_19494_19521[(1)] = (9));

} else {
var statearr_19495_19522 = state_19486__$1;
(statearr_19495_19522[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (3))){
var inst_19484 = (state_19486[(2)]);
var state_19486__$1 = state_19486;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19486__$1,inst_19484);
} else {
if((state_val_19487 === (12))){
var state_19486__$1 = state_19486;
var statearr_19496_19523 = state_19486__$1;
(statearr_19496_19523[(2)] = null);

(statearr_19496_19523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (2))){
var state_19486__$1 = state_19486;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19486__$1,(4),ch);
} else {
if((state_val_19487 === (11))){
var inst_19463 = (state_19486[(7)]);
var inst_19473 = (state_19486[(2)]);
var state_19486__$1 = state_19486;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19486__$1,(8),inst_19473,inst_19463);
} else {
if((state_val_19487 === (9))){
var state_19486__$1 = state_19486;
var statearr_19497_19524 = state_19486__$1;
(statearr_19497_19524[(2)] = tc);

(statearr_19497_19524[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (5))){
var inst_19466 = cljs.core.async.close_BANG_.call(null,tc);
var inst_19467 = cljs.core.async.close_BANG_.call(null,fc);
var state_19486__$1 = (function (){var statearr_19498 = state_19486;
(statearr_19498[(8)] = inst_19466);

return statearr_19498;
})();
var statearr_19499_19525 = state_19486__$1;
(statearr_19499_19525[(2)] = inst_19467);

(statearr_19499_19525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (14))){
var inst_19480 = (state_19486[(2)]);
var state_19486__$1 = state_19486;
var statearr_19500_19526 = state_19486__$1;
(statearr_19500_19526[(2)] = inst_19480);

(statearr_19500_19526[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (10))){
var state_19486__$1 = state_19486;
var statearr_19501_19527 = state_19486__$1;
(statearr_19501_19527[(2)] = fc);

(statearr_19501_19527[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19487 === (8))){
var inst_19475 = (state_19486[(2)]);
var state_19486__$1 = state_19486;
if(cljs.core.truth_(inst_19475)){
var statearr_19502_19528 = state_19486__$1;
(statearr_19502_19528[(1)] = (12));

} else {
var statearr_19503_19529 = state_19486__$1;
(statearr_19503_19529[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___19515,tc,fc))
;
return ((function (switch__10932__auto__,c__11044__auto___19515,tc,fc){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_19507 = [null,null,null,null,null,null,null,null,null];
(statearr_19507[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_19507[(1)] = (1));

return statearr_19507;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_19486){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_19486);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e19508){if((e19508 instanceof Object)){
var ex__10936__auto__ = e19508;
var statearr_19509_19530 = state_19486;
(statearr_19509_19530[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19486);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19531 = state_19486;
state_19486 = G__19531;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_19486){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_19486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___19515,tc,fc))
})();
var state__11046__auto__ = (function (){var statearr_19510 = f__11045__auto__.call(null);
(statearr_19510[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___19515);

return statearr_19510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___19515,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto__){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto__){
return (function (state_19595){
var state_val_19596 = (state_19595[(1)]);
if((state_val_19596 === (7))){
var inst_19591 = (state_19595[(2)]);
var state_19595__$1 = state_19595;
var statearr_19597_19618 = state_19595__$1;
(statearr_19597_19618[(2)] = inst_19591);

(statearr_19597_19618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19596 === (1))){
var inst_19575 = init;
var state_19595__$1 = (function (){var statearr_19598 = state_19595;
(statearr_19598[(7)] = inst_19575);

return statearr_19598;
})();
var statearr_19599_19619 = state_19595__$1;
(statearr_19599_19619[(2)] = null);

(statearr_19599_19619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19596 === (4))){
var inst_19578 = (state_19595[(8)]);
var inst_19578__$1 = (state_19595[(2)]);
var inst_19579 = (inst_19578__$1 == null);
var state_19595__$1 = (function (){var statearr_19600 = state_19595;
(statearr_19600[(8)] = inst_19578__$1);

return statearr_19600;
})();
if(cljs.core.truth_(inst_19579)){
var statearr_19601_19620 = state_19595__$1;
(statearr_19601_19620[(1)] = (5));

} else {
var statearr_19602_19621 = state_19595__$1;
(statearr_19602_19621[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19596 === (6))){
var inst_19578 = (state_19595[(8)]);
var inst_19582 = (state_19595[(9)]);
var inst_19575 = (state_19595[(7)]);
var inst_19582__$1 = f.call(null,inst_19575,inst_19578);
var inst_19583 = cljs.core.reduced_QMARK_.call(null,inst_19582__$1);
var state_19595__$1 = (function (){var statearr_19603 = state_19595;
(statearr_19603[(9)] = inst_19582__$1);

return statearr_19603;
})();
if(inst_19583){
var statearr_19604_19622 = state_19595__$1;
(statearr_19604_19622[(1)] = (8));

} else {
var statearr_19605_19623 = state_19595__$1;
(statearr_19605_19623[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19596 === (3))){
var inst_19593 = (state_19595[(2)]);
var state_19595__$1 = state_19595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19595__$1,inst_19593);
} else {
if((state_val_19596 === (2))){
var state_19595__$1 = state_19595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19595__$1,(4),ch);
} else {
if((state_val_19596 === (9))){
var inst_19582 = (state_19595[(9)]);
var inst_19575 = inst_19582;
var state_19595__$1 = (function (){var statearr_19606 = state_19595;
(statearr_19606[(7)] = inst_19575);

return statearr_19606;
})();
var statearr_19607_19624 = state_19595__$1;
(statearr_19607_19624[(2)] = null);

(statearr_19607_19624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19596 === (5))){
var inst_19575 = (state_19595[(7)]);
var state_19595__$1 = state_19595;
var statearr_19608_19625 = state_19595__$1;
(statearr_19608_19625[(2)] = inst_19575);

(statearr_19608_19625[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19596 === (10))){
var inst_19589 = (state_19595[(2)]);
var state_19595__$1 = state_19595;
var statearr_19609_19626 = state_19595__$1;
(statearr_19609_19626[(2)] = inst_19589);

(statearr_19609_19626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19596 === (8))){
var inst_19582 = (state_19595[(9)]);
var inst_19585 = cljs.core.deref.call(null,inst_19582);
var state_19595__$1 = state_19595;
var statearr_19610_19627 = state_19595__$1;
(statearr_19610_19627[(2)] = inst_19585);

(statearr_19610_19627[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto__))
;
return ((function (switch__10932__auto__,c__11044__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10933__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10933__auto____0 = (function (){
var statearr_19614 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19614[(0)] = cljs$core$async$reduce_$_state_machine__10933__auto__);

(statearr_19614[(1)] = (1));

return statearr_19614;
});
var cljs$core$async$reduce_$_state_machine__10933__auto____1 = (function (state_19595){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_19595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e19615){if((e19615 instanceof Object)){
var ex__10936__auto__ = e19615;
var statearr_19616_19628 = state_19595;
(statearr_19616_19628[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19615;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19629 = state_19595;
state_19595 = G__19629;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10933__auto__ = function(state_19595){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10933__auto____1.call(this,state_19595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10933__auto____0;
cljs$core$async$reduce_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10933__auto____1;
return cljs$core$async$reduce_$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto__))
})();
var state__11046__auto__ = (function (){var statearr_19617 = f__11045__auto__.call(null);
(statearr_19617[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto__);

return statearr_19617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto__))
);

return c__11044__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19630 = [];
var len__5726__auto___19682 = arguments.length;
var i__5727__auto___19683 = (0);
while(true){
if((i__5727__auto___19683 < len__5726__auto___19682)){
args19630.push((arguments[i__5727__auto___19683]));

var G__19684 = (i__5727__auto___19683 + (1));
i__5727__auto___19683 = G__19684;
continue;
} else {
}
break;
}

var G__19632 = args19630.length;
switch (G__19632) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19630.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto__){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto__){
return (function (state_19657){
var state_val_19658 = (state_19657[(1)]);
if((state_val_19658 === (7))){
var inst_19639 = (state_19657[(2)]);
var state_19657__$1 = state_19657;
var statearr_19659_19686 = state_19657__$1;
(statearr_19659_19686[(2)] = inst_19639);

(statearr_19659_19686[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (1))){
var inst_19633 = cljs.core.seq.call(null,coll);
var inst_19634 = inst_19633;
var state_19657__$1 = (function (){var statearr_19660 = state_19657;
(statearr_19660[(7)] = inst_19634);

return statearr_19660;
})();
var statearr_19661_19687 = state_19657__$1;
(statearr_19661_19687[(2)] = null);

(statearr_19661_19687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (4))){
var inst_19634 = (state_19657[(7)]);
var inst_19637 = cljs.core.first.call(null,inst_19634);
var state_19657__$1 = state_19657;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19657__$1,(7),ch,inst_19637);
} else {
if((state_val_19658 === (13))){
var inst_19651 = (state_19657[(2)]);
var state_19657__$1 = state_19657;
var statearr_19662_19688 = state_19657__$1;
(statearr_19662_19688[(2)] = inst_19651);

(statearr_19662_19688[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (6))){
var inst_19642 = (state_19657[(2)]);
var state_19657__$1 = state_19657;
if(cljs.core.truth_(inst_19642)){
var statearr_19663_19689 = state_19657__$1;
(statearr_19663_19689[(1)] = (8));

} else {
var statearr_19664_19690 = state_19657__$1;
(statearr_19664_19690[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (3))){
var inst_19655 = (state_19657[(2)]);
var state_19657__$1 = state_19657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19657__$1,inst_19655);
} else {
if((state_val_19658 === (12))){
var state_19657__$1 = state_19657;
var statearr_19665_19691 = state_19657__$1;
(statearr_19665_19691[(2)] = null);

(statearr_19665_19691[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (2))){
var inst_19634 = (state_19657[(7)]);
var state_19657__$1 = state_19657;
if(cljs.core.truth_(inst_19634)){
var statearr_19666_19692 = state_19657__$1;
(statearr_19666_19692[(1)] = (4));

} else {
var statearr_19667_19693 = state_19657__$1;
(statearr_19667_19693[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (11))){
var inst_19648 = cljs.core.async.close_BANG_.call(null,ch);
var state_19657__$1 = state_19657;
var statearr_19668_19694 = state_19657__$1;
(statearr_19668_19694[(2)] = inst_19648);

(statearr_19668_19694[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (9))){
var state_19657__$1 = state_19657;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19669_19695 = state_19657__$1;
(statearr_19669_19695[(1)] = (11));

} else {
var statearr_19670_19696 = state_19657__$1;
(statearr_19670_19696[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (5))){
var inst_19634 = (state_19657[(7)]);
var state_19657__$1 = state_19657;
var statearr_19671_19697 = state_19657__$1;
(statearr_19671_19697[(2)] = inst_19634);

(statearr_19671_19697[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (10))){
var inst_19653 = (state_19657[(2)]);
var state_19657__$1 = state_19657;
var statearr_19672_19698 = state_19657__$1;
(statearr_19672_19698[(2)] = inst_19653);

(statearr_19672_19698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19658 === (8))){
var inst_19634 = (state_19657[(7)]);
var inst_19644 = cljs.core.next.call(null,inst_19634);
var inst_19634__$1 = inst_19644;
var state_19657__$1 = (function (){var statearr_19673 = state_19657;
(statearr_19673[(7)] = inst_19634__$1);

return statearr_19673;
})();
var statearr_19674_19699 = state_19657__$1;
(statearr_19674_19699[(2)] = null);

(statearr_19674_19699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto__))
;
return ((function (switch__10932__auto__,c__11044__auto__){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_19678 = [null,null,null,null,null,null,null,null];
(statearr_19678[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_19678[(1)] = (1));

return statearr_19678;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_19657){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_19657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e19679){if((e19679 instanceof Object)){
var ex__10936__auto__ = e19679;
var statearr_19680_19700 = state_19657;
(statearr_19680_19700[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19657);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19679;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19701 = state_19657;
state_19657 = G__19701;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_19657){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_19657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto__))
})();
var state__11046__auto__ = (function (){var statearr_19681 = f__11045__auto__.call(null);
(statearr_19681[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto__);

return statearr_19681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto__))
);

return c__11044__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19923 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19923 = (function (mult,ch,cs,meta19924){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta19924 = meta19924;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_19925,meta19924__$1){
var self__ = this;
var _19925__$1 = this;
return (new cljs.core.async.t_cljs$core$async19923(self__.mult,self__.ch,self__.cs,meta19924__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async19923.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_19925){
var self__ = this;
var _19925__$1 = this;
return self__.meta19924;
});})(cs))
;

cljs.core.async.t_cljs$core$async19923.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19923.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async19923.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async19923.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19923.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19923.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19923.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta19924","meta19924",-207452443,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async19923.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19923.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19923";

cljs.core.async.t_cljs$core$async19923.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19923");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async19923 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async19923(mult__$1,ch__$1,cs__$1,meta19924){
return (new cljs.core.async.t_cljs$core$async19923(mult__$1,ch__$1,cs__$1,meta19924));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async19923(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11044__auto___20144 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___20144,cs,m,dchan,dctr,done){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___20144,cs,m,dchan,dctr,done){
return (function (state_20056){
var state_val_20057 = (state_20056[(1)]);
if((state_val_20057 === (7))){
var inst_20052 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20058_20145 = state_20056__$1;
(statearr_20058_20145[(2)] = inst_20052);

(statearr_20058_20145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (20))){
var inst_19957 = (state_20056[(7)]);
var inst_19967 = cljs.core.first.call(null,inst_19957);
var inst_19968 = cljs.core.nth.call(null,inst_19967,(0),null);
var inst_19969 = cljs.core.nth.call(null,inst_19967,(1),null);
var state_20056__$1 = (function (){var statearr_20059 = state_20056;
(statearr_20059[(8)] = inst_19968);

return statearr_20059;
})();
if(cljs.core.truth_(inst_19969)){
var statearr_20060_20146 = state_20056__$1;
(statearr_20060_20146[(1)] = (22));

} else {
var statearr_20061_20147 = state_20056__$1;
(statearr_20061_20147[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (27))){
var inst_19999 = (state_20056[(9)]);
var inst_20004 = (state_20056[(10)]);
var inst_19997 = (state_20056[(11)]);
var inst_19928 = (state_20056[(12)]);
var inst_20004__$1 = cljs.core._nth.call(null,inst_19997,inst_19999);
var inst_20005 = cljs.core.async.put_BANG_.call(null,inst_20004__$1,inst_19928,done);
var state_20056__$1 = (function (){var statearr_20062 = state_20056;
(statearr_20062[(10)] = inst_20004__$1);

return statearr_20062;
})();
if(cljs.core.truth_(inst_20005)){
var statearr_20063_20148 = state_20056__$1;
(statearr_20063_20148[(1)] = (30));

} else {
var statearr_20064_20149 = state_20056__$1;
(statearr_20064_20149[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (1))){
var state_20056__$1 = state_20056;
var statearr_20065_20150 = state_20056__$1;
(statearr_20065_20150[(2)] = null);

(statearr_20065_20150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (24))){
var inst_19957 = (state_20056[(7)]);
var inst_19974 = (state_20056[(2)]);
var inst_19975 = cljs.core.next.call(null,inst_19957);
var inst_19937 = inst_19975;
var inst_19938 = null;
var inst_19939 = (0);
var inst_19940 = (0);
var state_20056__$1 = (function (){var statearr_20066 = state_20056;
(statearr_20066[(13)] = inst_19938);

(statearr_20066[(14)] = inst_19940);

(statearr_20066[(15)] = inst_19937);

(statearr_20066[(16)] = inst_19974);

(statearr_20066[(17)] = inst_19939);

return statearr_20066;
})();
var statearr_20067_20151 = state_20056__$1;
(statearr_20067_20151[(2)] = null);

(statearr_20067_20151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (39))){
var state_20056__$1 = state_20056;
var statearr_20071_20152 = state_20056__$1;
(statearr_20071_20152[(2)] = null);

(statearr_20071_20152[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (4))){
var inst_19928 = (state_20056[(12)]);
var inst_19928__$1 = (state_20056[(2)]);
var inst_19929 = (inst_19928__$1 == null);
var state_20056__$1 = (function (){var statearr_20072 = state_20056;
(statearr_20072[(12)] = inst_19928__$1);

return statearr_20072;
})();
if(cljs.core.truth_(inst_19929)){
var statearr_20073_20153 = state_20056__$1;
(statearr_20073_20153[(1)] = (5));

} else {
var statearr_20074_20154 = state_20056__$1;
(statearr_20074_20154[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (15))){
var inst_19938 = (state_20056[(13)]);
var inst_19940 = (state_20056[(14)]);
var inst_19937 = (state_20056[(15)]);
var inst_19939 = (state_20056[(17)]);
var inst_19953 = (state_20056[(2)]);
var inst_19954 = (inst_19940 + (1));
var tmp20068 = inst_19938;
var tmp20069 = inst_19937;
var tmp20070 = inst_19939;
var inst_19937__$1 = tmp20069;
var inst_19938__$1 = tmp20068;
var inst_19939__$1 = tmp20070;
var inst_19940__$1 = inst_19954;
var state_20056__$1 = (function (){var statearr_20075 = state_20056;
(statearr_20075[(13)] = inst_19938__$1);

(statearr_20075[(14)] = inst_19940__$1);

(statearr_20075[(15)] = inst_19937__$1);

(statearr_20075[(18)] = inst_19953);

(statearr_20075[(17)] = inst_19939__$1);

return statearr_20075;
})();
var statearr_20076_20155 = state_20056__$1;
(statearr_20076_20155[(2)] = null);

(statearr_20076_20155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (21))){
var inst_19978 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20080_20156 = state_20056__$1;
(statearr_20080_20156[(2)] = inst_19978);

(statearr_20080_20156[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (31))){
var inst_20004 = (state_20056[(10)]);
var inst_20008 = done.call(null,null);
var inst_20009 = cljs.core.async.untap_STAR_.call(null,m,inst_20004);
var state_20056__$1 = (function (){var statearr_20081 = state_20056;
(statearr_20081[(19)] = inst_20008);

return statearr_20081;
})();
var statearr_20082_20157 = state_20056__$1;
(statearr_20082_20157[(2)] = inst_20009);

(statearr_20082_20157[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (32))){
var inst_19999 = (state_20056[(9)]);
var inst_19998 = (state_20056[(20)]);
var inst_19996 = (state_20056[(21)]);
var inst_19997 = (state_20056[(11)]);
var inst_20011 = (state_20056[(2)]);
var inst_20012 = (inst_19999 + (1));
var tmp20077 = inst_19998;
var tmp20078 = inst_19996;
var tmp20079 = inst_19997;
var inst_19996__$1 = tmp20078;
var inst_19997__$1 = tmp20079;
var inst_19998__$1 = tmp20077;
var inst_19999__$1 = inst_20012;
var state_20056__$1 = (function (){var statearr_20083 = state_20056;
(statearr_20083[(9)] = inst_19999__$1);

(statearr_20083[(22)] = inst_20011);

(statearr_20083[(20)] = inst_19998__$1);

(statearr_20083[(21)] = inst_19996__$1);

(statearr_20083[(11)] = inst_19997__$1);

return statearr_20083;
})();
var statearr_20084_20158 = state_20056__$1;
(statearr_20084_20158[(2)] = null);

(statearr_20084_20158[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (40))){
var inst_20024 = (state_20056[(23)]);
var inst_20028 = done.call(null,null);
var inst_20029 = cljs.core.async.untap_STAR_.call(null,m,inst_20024);
var state_20056__$1 = (function (){var statearr_20085 = state_20056;
(statearr_20085[(24)] = inst_20028);

return statearr_20085;
})();
var statearr_20086_20159 = state_20056__$1;
(statearr_20086_20159[(2)] = inst_20029);

(statearr_20086_20159[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (33))){
var inst_20015 = (state_20056[(25)]);
var inst_20017 = cljs.core.chunked_seq_QMARK_.call(null,inst_20015);
var state_20056__$1 = state_20056;
if(inst_20017){
var statearr_20087_20160 = state_20056__$1;
(statearr_20087_20160[(1)] = (36));

} else {
var statearr_20088_20161 = state_20056__$1;
(statearr_20088_20161[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (13))){
var inst_19947 = (state_20056[(26)]);
var inst_19950 = cljs.core.async.close_BANG_.call(null,inst_19947);
var state_20056__$1 = state_20056;
var statearr_20089_20162 = state_20056__$1;
(statearr_20089_20162[(2)] = inst_19950);

(statearr_20089_20162[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (22))){
var inst_19968 = (state_20056[(8)]);
var inst_19971 = cljs.core.async.close_BANG_.call(null,inst_19968);
var state_20056__$1 = state_20056;
var statearr_20090_20163 = state_20056__$1;
(statearr_20090_20163[(2)] = inst_19971);

(statearr_20090_20163[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (36))){
var inst_20015 = (state_20056[(25)]);
var inst_20019 = cljs.core.chunk_first.call(null,inst_20015);
var inst_20020 = cljs.core.chunk_rest.call(null,inst_20015);
var inst_20021 = cljs.core.count.call(null,inst_20019);
var inst_19996 = inst_20020;
var inst_19997 = inst_20019;
var inst_19998 = inst_20021;
var inst_19999 = (0);
var state_20056__$1 = (function (){var statearr_20091 = state_20056;
(statearr_20091[(9)] = inst_19999);

(statearr_20091[(20)] = inst_19998);

(statearr_20091[(21)] = inst_19996);

(statearr_20091[(11)] = inst_19997);

return statearr_20091;
})();
var statearr_20092_20164 = state_20056__$1;
(statearr_20092_20164[(2)] = null);

(statearr_20092_20164[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (41))){
var inst_20015 = (state_20056[(25)]);
var inst_20031 = (state_20056[(2)]);
var inst_20032 = cljs.core.next.call(null,inst_20015);
var inst_19996 = inst_20032;
var inst_19997 = null;
var inst_19998 = (0);
var inst_19999 = (0);
var state_20056__$1 = (function (){var statearr_20093 = state_20056;
(statearr_20093[(9)] = inst_19999);

(statearr_20093[(27)] = inst_20031);

(statearr_20093[(20)] = inst_19998);

(statearr_20093[(21)] = inst_19996);

(statearr_20093[(11)] = inst_19997);

return statearr_20093;
})();
var statearr_20094_20165 = state_20056__$1;
(statearr_20094_20165[(2)] = null);

(statearr_20094_20165[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (43))){
var state_20056__$1 = state_20056;
var statearr_20095_20166 = state_20056__$1;
(statearr_20095_20166[(2)] = null);

(statearr_20095_20166[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (29))){
var inst_20040 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20096_20167 = state_20056__$1;
(statearr_20096_20167[(2)] = inst_20040);

(statearr_20096_20167[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (44))){
var inst_20049 = (state_20056[(2)]);
var state_20056__$1 = (function (){var statearr_20097 = state_20056;
(statearr_20097[(28)] = inst_20049);

return statearr_20097;
})();
var statearr_20098_20168 = state_20056__$1;
(statearr_20098_20168[(2)] = null);

(statearr_20098_20168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (6))){
var inst_19988 = (state_20056[(29)]);
var inst_19987 = cljs.core.deref.call(null,cs);
var inst_19988__$1 = cljs.core.keys.call(null,inst_19987);
var inst_19989 = cljs.core.count.call(null,inst_19988__$1);
var inst_19990 = cljs.core.reset_BANG_.call(null,dctr,inst_19989);
var inst_19995 = cljs.core.seq.call(null,inst_19988__$1);
var inst_19996 = inst_19995;
var inst_19997 = null;
var inst_19998 = (0);
var inst_19999 = (0);
var state_20056__$1 = (function (){var statearr_20099 = state_20056;
(statearr_20099[(9)] = inst_19999);

(statearr_20099[(20)] = inst_19998);

(statearr_20099[(30)] = inst_19990);

(statearr_20099[(21)] = inst_19996);

(statearr_20099[(29)] = inst_19988__$1);

(statearr_20099[(11)] = inst_19997);

return statearr_20099;
})();
var statearr_20100_20169 = state_20056__$1;
(statearr_20100_20169[(2)] = null);

(statearr_20100_20169[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (28))){
var inst_19996 = (state_20056[(21)]);
var inst_20015 = (state_20056[(25)]);
var inst_20015__$1 = cljs.core.seq.call(null,inst_19996);
var state_20056__$1 = (function (){var statearr_20101 = state_20056;
(statearr_20101[(25)] = inst_20015__$1);

return statearr_20101;
})();
if(inst_20015__$1){
var statearr_20102_20170 = state_20056__$1;
(statearr_20102_20170[(1)] = (33));

} else {
var statearr_20103_20171 = state_20056__$1;
(statearr_20103_20171[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (25))){
var inst_19999 = (state_20056[(9)]);
var inst_19998 = (state_20056[(20)]);
var inst_20001 = (inst_19999 < inst_19998);
var inst_20002 = inst_20001;
var state_20056__$1 = state_20056;
if(cljs.core.truth_(inst_20002)){
var statearr_20104_20172 = state_20056__$1;
(statearr_20104_20172[(1)] = (27));

} else {
var statearr_20105_20173 = state_20056__$1;
(statearr_20105_20173[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (34))){
var state_20056__$1 = state_20056;
var statearr_20106_20174 = state_20056__$1;
(statearr_20106_20174[(2)] = null);

(statearr_20106_20174[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (17))){
var state_20056__$1 = state_20056;
var statearr_20107_20175 = state_20056__$1;
(statearr_20107_20175[(2)] = null);

(statearr_20107_20175[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (3))){
var inst_20054 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20056__$1,inst_20054);
} else {
if((state_val_20057 === (12))){
var inst_19983 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20108_20176 = state_20056__$1;
(statearr_20108_20176[(2)] = inst_19983);

(statearr_20108_20176[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (2))){
var state_20056__$1 = state_20056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20056__$1,(4),ch);
} else {
if((state_val_20057 === (23))){
var state_20056__$1 = state_20056;
var statearr_20109_20177 = state_20056__$1;
(statearr_20109_20177[(2)] = null);

(statearr_20109_20177[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (35))){
var inst_20038 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20110_20178 = state_20056__$1;
(statearr_20110_20178[(2)] = inst_20038);

(statearr_20110_20178[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (19))){
var inst_19957 = (state_20056[(7)]);
var inst_19961 = cljs.core.chunk_first.call(null,inst_19957);
var inst_19962 = cljs.core.chunk_rest.call(null,inst_19957);
var inst_19963 = cljs.core.count.call(null,inst_19961);
var inst_19937 = inst_19962;
var inst_19938 = inst_19961;
var inst_19939 = inst_19963;
var inst_19940 = (0);
var state_20056__$1 = (function (){var statearr_20111 = state_20056;
(statearr_20111[(13)] = inst_19938);

(statearr_20111[(14)] = inst_19940);

(statearr_20111[(15)] = inst_19937);

(statearr_20111[(17)] = inst_19939);

return statearr_20111;
})();
var statearr_20112_20179 = state_20056__$1;
(statearr_20112_20179[(2)] = null);

(statearr_20112_20179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (11))){
var inst_19957 = (state_20056[(7)]);
var inst_19937 = (state_20056[(15)]);
var inst_19957__$1 = cljs.core.seq.call(null,inst_19937);
var state_20056__$1 = (function (){var statearr_20113 = state_20056;
(statearr_20113[(7)] = inst_19957__$1);

return statearr_20113;
})();
if(inst_19957__$1){
var statearr_20114_20180 = state_20056__$1;
(statearr_20114_20180[(1)] = (16));

} else {
var statearr_20115_20181 = state_20056__$1;
(statearr_20115_20181[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (9))){
var inst_19985 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20116_20182 = state_20056__$1;
(statearr_20116_20182[(2)] = inst_19985);

(statearr_20116_20182[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (5))){
var inst_19935 = cljs.core.deref.call(null,cs);
var inst_19936 = cljs.core.seq.call(null,inst_19935);
var inst_19937 = inst_19936;
var inst_19938 = null;
var inst_19939 = (0);
var inst_19940 = (0);
var state_20056__$1 = (function (){var statearr_20117 = state_20056;
(statearr_20117[(13)] = inst_19938);

(statearr_20117[(14)] = inst_19940);

(statearr_20117[(15)] = inst_19937);

(statearr_20117[(17)] = inst_19939);

return statearr_20117;
})();
var statearr_20118_20183 = state_20056__$1;
(statearr_20118_20183[(2)] = null);

(statearr_20118_20183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (14))){
var state_20056__$1 = state_20056;
var statearr_20119_20184 = state_20056__$1;
(statearr_20119_20184[(2)] = null);

(statearr_20119_20184[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (45))){
var inst_20046 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20120_20185 = state_20056__$1;
(statearr_20120_20185[(2)] = inst_20046);

(statearr_20120_20185[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (26))){
var inst_19988 = (state_20056[(29)]);
var inst_20042 = (state_20056[(2)]);
var inst_20043 = cljs.core.seq.call(null,inst_19988);
var state_20056__$1 = (function (){var statearr_20121 = state_20056;
(statearr_20121[(31)] = inst_20042);

return statearr_20121;
})();
if(inst_20043){
var statearr_20122_20186 = state_20056__$1;
(statearr_20122_20186[(1)] = (42));

} else {
var statearr_20123_20187 = state_20056__$1;
(statearr_20123_20187[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (16))){
var inst_19957 = (state_20056[(7)]);
var inst_19959 = cljs.core.chunked_seq_QMARK_.call(null,inst_19957);
var state_20056__$1 = state_20056;
if(inst_19959){
var statearr_20124_20188 = state_20056__$1;
(statearr_20124_20188[(1)] = (19));

} else {
var statearr_20125_20189 = state_20056__$1;
(statearr_20125_20189[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (38))){
var inst_20035 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20126_20190 = state_20056__$1;
(statearr_20126_20190[(2)] = inst_20035);

(statearr_20126_20190[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (30))){
var state_20056__$1 = state_20056;
var statearr_20127_20191 = state_20056__$1;
(statearr_20127_20191[(2)] = null);

(statearr_20127_20191[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (10))){
var inst_19938 = (state_20056[(13)]);
var inst_19940 = (state_20056[(14)]);
var inst_19946 = cljs.core._nth.call(null,inst_19938,inst_19940);
var inst_19947 = cljs.core.nth.call(null,inst_19946,(0),null);
var inst_19948 = cljs.core.nth.call(null,inst_19946,(1),null);
var state_20056__$1 = (function (){var statearr_20128 = state_20056;
(statearr_20128[(26)] = inst_19947);

return statearr_20128;
})();
if(cljs.core.truth_(inst_19948)){
var statearr_20129_20192 = state_20056__$1;
(statearr_20129_20192[(1)] = (13));

} else {
var statearr_20130_20193 = state_20056__$1;
(statearr_20130_20193[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (18))){
var inst_19981 = (state_20056[(2)]);
var state_20056__$1 = state_20056;
var statearr_20131_20194 = state_20056__$1;
(statearr_20131_20194[(2)] = inst_19981);

(statearr_20131_20194[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (42))){
var state_20056__$1 = state_20056;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20056__$1,(45),dchan);
} else {
if((state_val_20057 === (37))){
var inst_19928 = (state_20056[(12)]);
var inst_20015 = (state_20056[(25)]);
var inst_20024 = (state_20056[(23)]);
var inst_20024__$1 = cljs.core.first.call(null,inst_20015);
var inst_20025 = cljs.core.async.put_BANG_.call(null,inst_20024__$1,inst_19928,done);
var state_20056__$1 = (function (){var statearr_20132 = state_20056;
(statearr_20132[(23)] = inst_20024__$1);

return statearr_20132;
})();
if(cljs.core.truth_(inst_20025)){
var statearr_20133_20195 = state_20056__$1;
(statearr_20133_20195[(1)] = (39));

} else {
var statearr_20134_20196 = state_20056__$1;
(statearr_20134_20196[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20057 === (8))){
var inst_19940 = (state_20056[(14)]);
var inst_19939 = (state_20056[(17)]);
var inst_19942 = (inst_19940 < inst_19939);
var inst_19943 = inst_19942;
var state_20056__$1 = state_20056;
if(cljs.core.truth_(inst_19943)){
var statearr_20135_20197 = state_20056__$1;
(statearr_20135_20197[(1)] = (10));

} else {
var statearr_20136_20198 = state_20056__$1;
(statearr_20136_20198[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___20144,cs,m,dchan,dctr,done))
;
return ((function (switch__10932__auto__,c__11044__auto___20144,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10933__auto__ = null;
var cljs$core$async$mult_$_state_machine__10933__auto____0 = (function (){
var statearr_20140 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20140[(0)] = cljs$core$async$mult_$_state_machine__10933__auto__);

(statearr_20140[(1)] = (1));

return statearr_20140;
});
var cljs$core$async$mult_$_state_machine__10933__auto____1 = (function (state_20056){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_20056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e20141){if((e20141 instanceof Object)){
var ex__10936__auto__ = e20141;
var statearr_20142_20199 = state_20056;
(statearr_20142_20199[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20056);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20141;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20200 = state_20056;
state_20056 = G__20200;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10933__auto__ = function(state_20056){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10933__auto____1.call(this,state_20056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10933__auto____0;
cljs$core$async$mult_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10933__auto____1;
return cljs$core$async$mult_$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___20144,cs,m,dchan,dctr,done))
})();
var state__11046__auto__ = (function (){var statearr_20143 = f__11045__auto__.call(null);
(statearr_20143[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___20144);

return statearr_20143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___20144,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args20201 = [];
var len__5726__auto___20204 = arguments.length;
var i__5727__auto___20205 = (0);
while(true){
if((i__5727__auto___20205 < len__5726__auto___20204)){
args20201.push((arguments[i__5727__auto___20205]));

var G__20206 = (i__5727__auto___20205 + (1));
i__5727__auto___20205 = G__20206;
continue;
} else {
}
break;
}

var G__20203 = args20201.length;
switch (G__20203) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20201.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20218 = arguments.length;
var i__5727__auto___20219 = (0);
while(true){
if((i__5727__auto___20219 < len__5726__auto___20218)){
args__5733__auto__.push((arguments[i__5727__auto___20219]));

var G__20220 = (i__5727__auto___20219 + (1));
i__5727__auto___20219 = G__20220;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__20212){
var map__20213 = p__20212;
var map__20213__$1 = ((((!((map__20213 == null)))?((((map__20213.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20213.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20213):map__20213);
var opts = map__20213__$1;
var statearr_20215_20221 = state;
(statearr_20215_20221[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__20213,map__20213__$1,opts){
return (function (val){
var statearr_20216_20222 = state;
(statearr_20216_20222[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__20213,map__20213__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_20217_20223 = state;
(statearr_20217_20223[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq20208){
var G__20209 = cljs.core.first.call(null,seq20208);
var seq20208__$1 = cljs.core.next.call(null,seq20208);
var G__20210 = cljs.core.first.call(null,seq20208__$1);
var seq20208__$2 = cljs.core.next.call(null,seq20208__$1);
var G__20211 = cljs.core.first.call(null,seq20208__$2);
var seq20208__$3 = cljs.core.next.call(null,seq20208__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20209,G__20210,G__20211,seq20208__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async20387 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20387 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta20388){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta20388 = meta20388;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20389,meta20388__$1){
var self__ = this;
var _20389__$1 = this;
return (new cljs.core.async.t_cljs$core$async20387(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta20388__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_20389){
var self__ = this;
var _20389__$1 = this;
return self__.meta20388;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta20388","meta20388",837522373,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async20387.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20387.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20387";

cljs.core.async.t_cljs$core$async20387.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20387");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async20387 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async20387(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20388){
return (new cljs.core.async.t_cljs$core$async20387(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta20388));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async20387(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11044__auto___20550 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___20550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___20550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_20487){
var state_val_20488 = (state_20487[(1)]);
if((state_val_20488 === (7))){
var inst_20405 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
var statearr_20489_20551 = state_20487__$1;
(statearr_20489_20551[(2)] = inst_20405);

(statearr_20489_20551[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (20))){
var inst_20417 = (state_20487[(7)]);
var state_20487__$1 = state_20487;
var statearr_20490_20552 = state_20487__$1;
(statearr_20490_20552[(2)] = inst_20417);

(statearr_20490_20552[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (27))){
var state_20487__$1 = state_20487;
var statearr_20491_20553 = state_20487__$1;
(statearr_20491_20553[(2)] = null);

(statearr_20491_20553[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (1))){
var inst_20393 = (state_20487[(8)]);
var inst_20393__$1 = calc_state.call(null);
var inst_20395 = (inst_20393__$1 == null);
var inst_20396 = cljs.core.not.call(null,inst_20395);
var state_20487__$1 = (function (){var statearr_20492 = state_20487;
(statearr_20492[(8)] = inst_20393__$1);

return statearr_20492;
})();
if(inst_20396){
var statearr_20493_20554 = state_20487__$1;
(statearr_20493_20554[(1)] = (2));

} else {
var statearr_20494_20555 = state_20487__$1;
(statearr_20494_20555[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (24))){
var inst_20447 = (state_20487[(9)]);
var inst_20440 = (state_20487[(10)]);
var inst_20461 = (state_20487[(11)]);
var inst_20461__$1 = inst_20440.call(null,inst_20447);
var state_20487__$1 = (function (){var statearr_20495 = state_20487;
(statearr_20495[(11)] = inst_20461__$1);

return statearr_20495;
})();
if(cljs.core.truth_(inst_20461__$1)){
var statearr_20496_20556 = state_20487__$1;
(statearr_20496_20556[(1)] = (29));

} else {
var statearr_20497_20557 = state_20487__$1;
(statearr_20497_20557[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (4))){
var inst_20408 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
if(cljs.core.truth_(inst_20408)){
var statearr_20498_20558 = state_20487__$1;
(statearr_20498_20558[(1)] = (8));

} else {
var statearr_20499_20559 = state_20487__$1;
(statearr_20499_20559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (15))){
var inst_20434 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
if(cljs.core.truth_(inst_20434)){
var statearr_20500_20560 = state_20487__$1;
(statearr_20500_20560[(1)] = (19));

} else {
var statearr_20501_20561 = state_20487__$1;
(statearr_20501_20561[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (21))){
var inst_20439 = (state_20487[(12)]);
var inst_20439__$1 = (state_20487[(2)]);
var inst_20440 = cljs.core.get.call(null,inst_20439__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20441 = cljs.core.get.call(null,inst_20439__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20442 = cljs.core.get.call(null,inst_20439__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_20487__$1 = (function (){var statearr_20502 = state_20487;
(statearr_20502[(10)] = inst_20440);

(statearr_20502[(12)] = inst_20439__$1);

(statearr_20502[(13)] = inst_20441);

return statearr_20502;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20487__$1,(22),inst_20442);
} else {
if((state_val_20488 === (31))){
var inst_20469 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
if(cljs.core.truth_(inst_20469)){
var statearr_20503_20562 = state_20487__$1;
(statearr_20503_20562[(1)] = (32));

} else {
var statearr_20504_20563 = state_20487__$1;
(statearr_20504_20563[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (32))){
var inst_20446 = (state_20487[(14)]);
var state_20487__$1 = state_20487;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20487__$1,(35),out,inst_20446);
} else {
if((state_val_20488 === (33))){
var inst_20439 = (state_20487[(12)]);
var inst_20417 = inst_20439;
var state_20487__$1 = (function (){var statearr_20505 = state_20487;
(statearr_20505[(7)] = inst_20417);

return statearr_20505;
})();
var statearr_20506_20564 = state_20487__$1;
(statearr_20506_20564[(2)] = null);

(statearr_20506_20564[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (13))){
var inst_20417 = (state_20487[(7)]);
var inst_20424 = inst_20417.cljs$lang$protocol_mask$partition0$;
var inst_20425 = (inst_20424 & (64));
var inst_20426 = inst_20417.cljs$core$ISeq$;
var inst_20427 = (inst_20425) || (inst_20426);
var state_20487__$1 = state_20487;
if(cljs.core.truth_(inst_20427)){
var statearr_20507_20565 = state_20487__$1;
(statearr_20507_20565[(1)] = (16));

} else {
var statearr_20508_20566 = state_20487__$1;
(statearr_20508_20566[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (22))){
var inst_20447 = (state_20487[(9)]);
var inst_20446 = (state_20487[(14)]);
var inst_20445 = (state_20487[(2)]);
var inst_20446__$1 = cljs.core.nth.call(null,inst_20445,(0),null);
var inst_20447__$1 = cljs.core.nth.call(null,inst_20445,(1),null);
var inst_20448 = (inst_20446__$1 == null);
var inst_20449 = cljs.core._EQ_.call(null,inst_20447__$1,change);
var inst_20450 = (inst_20448) || (inst_20449);
var state_20487__$1 = (function (){var statearr_20509 = state_20487;
(statearr_20509[(9)] = inst_20447__$1);

(statearr_20509[(14)] = inst_20446__$1);

return statearr_20509;
})();
if(cljs.core.truth_(inst_20450)){
var statearr_20510_20567 = state_20487__$1;
(statearr_20510_20567[(1)] = (23));

} else {
var statearr_20511_20568 = state_20487__$1;
(statearr_20511_20568[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (36))){
var inst_20439 = (state_20487[(12)]);
var inst_20417 = inst_20439;
var state_20487__$1 = (function (){var statearr_20512 = state_20487;
(statearr_20512[(7)] = inst_20417);

return statearr_20512;
})();
var statearr_20513_20569 = state_20487__$1;
(statearr_20513_20569[(2)] = null);

(statearr_20513_20569[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (29))){
var inst_20461 = (state_20487[(11)]);
var state_20487__$1 = state_20487;
var statearr_20514_20570 = state_20487__$1;
(statearr_20514_20570[(2)] = inst_20461);

(statearr_20514_20570[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (6))){
var state_20487__$1 = state_20487;
var statearr_20515_20571 = state_20487__$1;
(statearr_20515_20571[(2)] = false);

(statearr_20515_20571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (28))){
var inst_20457 = (state_20487[(2)]);
var inst_20458 = calc_state.call(null);
var inst_20417 = inst_20458;
var state_20487__$1 = (function (){var statearr_20516 = state_20487;
(statearr_20516[(7)] = inst_20417);

(statearr_20516[(15)] = inst_20457);

return statearr_20516;
})();
var statearr_20517_20572 = state_20487__$1;
(statearr_20517_20572[(2)] = null);

(statearr_20517_20572[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (25))){
var inst_20483 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
var statearr_20518_20573 = state_20487__$1;
(statearr_20518_20573[(2)] = inst_20483);

(statearr_20518_20573[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (34))){
var inst_20481 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
var statearr_20519_20574 = state_20487__$1;
(statearr_20519_20574[(2)] = inst_20481);

(statearr_20519_20574[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (17))){
var state_20487__$1 = state_20487;
var statearr_20520_20575 = state_20487__$1;
(statearr_20520_20575[(2)] = false);

(statearr_20520_20575[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (3))){
var state_20487__$1 = state_20487;
var statearr_20521_20576 = state_20487__$1;
(statearr_20521_20576[(2)] = false);

(statearr_20521_20576[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (12))){
var inst_20485 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20487__$1,inst_20485);
} else {
if((state_val_20488 === (2))){
var inst_20393 = (state_20487[(8)]);
var inst_20398 = inst_20393.cljs$lang$protocol_mask$partition0$;
var inst_20399 = (inst_20398 & (64));
var inst_20400 = inst_20393.cljs$core$ISeq$;
var inst_20401 = (inst_20399) || (inst_20400);
var state_20487__$1 = state_20487;
if(cljs.core.truth_(inst_20401)){
var statearr_20522_20577 = state_20487__$1;
(statearr_20522_20577[(1)] = (5));

} else {
var statearr_20523_20578 = state_20487__$1;
(statearr_20523_20578[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (23))){
var inst_20446 = (state_20487[(14)]);
var inst_20452 = (inst_20446 == null);
var state_20487__$1 = state_20487;
if(cljs.core.truth_(inst_20452)){
var statearr_20524_20579 = state_20487__$1;
(statearr_20524_20579[(1)] = (26));

} else {
var statearr_20525_20580 = state_20487__$1;
(statearr_20525_20580[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (35))){
var inst_20472 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
if(cljs.core.truth_(inst_20472)){
var statearr_20526_20581 = state_20487__$1;
(statearr_20526_20581[(1)] = (36));

} else {
var statearr_20527_20582 = state_20487__$1;
(statearr_20527_20582[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (19))){
var inst_20417 = (state_20487[(7)]);
var inst_20436 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20417);
var state_20487__$1 = state_20487;
var statearr_20528_20583 = state_20487__$1;
(statearr_20528_20583[(2)] = inst_20436);

(statearr_20528_20583[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (11))){
var inst_20417 = (state_20487[(7)]);
var inst_20421 = (inst_20417 == null);
var inst_20422 = cljs.core.not.call(null,inst_20421);
var state_20487__$1 = state_20487;
if(inst_20422){
var statearr_20529_20584 = state_20487__$1;
(statearr_20529_20584[(1)] = (13));

} else {
var statearr_20530_20585 = state_20487__$1;
(statearr_20530_20585[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (9))){
var inst_20393 = (state_20487[(8)]);
var state_20487__$1 = state_20487;
var statearr_20531_20586 = state_20487__$1;
(statearr_20531_20586[(2)] = inst_20393);

(statearr_20531_20586[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (5))){
var state_20487__$1 = state_20487;
var statearr_20532_20587 = state_20487__$1;
(statearr_20532_20587[(2)] = true);

(statearr_20532_20587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (14))){
var state_20487__$1 = state_20487;
var statearr_20533_20588 = state_20487__$1;
(statearr_20533_20588[(2)] = false);

(statearr_20533_20588[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (26))){
var inst_20447 = (state_20487[(9)]);
var inst_20454 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_20447);
var state_20487__$1 = state_20487;
var statearr_20534_20589 = state_20487__$1;
(statearr_20534_20589[(2)] = inst_20454);

(statearr_20534_20589[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (16))){
var state_20487__$1 = state_20487;
var statearr_20535_20590 = state_20487__$1;
(statearr_20535_20590[(2)] = true);

(statearr_20535_20590[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (38))){
var inst_20477 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
var statearr_20536_20591 = state_20487__$1;
(statearr_20536_20591[(2)] = inst_20477);

(statearr_20536_20591[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (30))){
var inst_20447 = (state_20487[(9)]);
var inst_20440 = (state_20487[(10)]);
var inst_20441 = (state_20487[(13)]);
var inst_20464 = cljs.core.empty_QMARK_.call(null,inst_20440);
var inst_20465 = inst_20441.call(null,inst_20447);
var inst_20466 = cljs.core.not.call(null,inst_20465);
var inst_20467 = (inst_20464) && (inst_20466);
var state_20487__$1 = state_20487;
var statearr_20537_20592 = state_20487__$1;
(statearr_20537_20592[(2)] = inst_20467);

(statearr_20537_20592[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (10))){
var inst_20393 = (state_20487[(8)]);
var inst_20413 = (state_20487[(2)]);
var inst_20414 = cljs.core.get.call(null,inst_20413,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_20415 = cljs.core.get.call(null,inst_20413,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_20416 = cljs.core.get.call(null,inst_20413,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_20417 = inst_20393;
var state_20487__$1 = (function (){var statearr_20538 = state_20487;
(statearr_20538[(7)] = inst_20417);

(statearr_20538[(16)] = inst_20416);

(statearr_20538[(17)] = inst_20414);

(statearr_20538[(18)] = inst_20415);

return statearr_20538;
})();
var statearr_20539_20593 = state_20487__$1;
(statearr_20539_20593[(2)] = null);

(statearr_20539_20593[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (18))){
var inst_20431 = (state_20487[(2)]);
var state_20487__$1 = state_20487;
var statearr_20540_20594 = state_20487__$1;
(statearr_20540_20594[(2)] = inst_20431);

(statearr_20540_20594[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (37))){
var state_20487__$1 = state_20487;
var statearr_20541_20595 = state_20487__$1;
(statearr_20541_20595[(2)] = null);

(statearr_20541_20595[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20488 === (8))){
var inst_20393 = (state_20487[(8)]);
var inst_20410 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20393);
var state_20487__$1 = state_20487;
var statearr_20542_20596 = state_20487__$1;
(statearr_20542_20596[(2)] = inst_20410);

(statearr_20542_20596[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___20550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10932__auto__,c__11044__auto___20550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10933__auto__ = null;
var cljs$core$async$mix_$_state_machine__10933__auto____0 = (function (){
var statearr_20546 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20546[(0)] = cljs$core$async$mix_$_state_machine__10933__auto__);

(statearr_20546[(1)] = (1));

return statearr_20546;
});
var cljs$core$async$mix_$_state_machine__10933__auto____1 = (function (state_20487){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_20487);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e20547){if((e20547 instanceof Object)){
var ex__10936__auto__ = e20547;
var statearr_20548_20597 = state_20487;
(statearr_20548_20597[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20487);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20547;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20598 = state_20487;
state_20487 = G__20598;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10933__auto__ = function(state_20487){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10933__auto____1.call(this,state_20487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10933__auto____0;
cljs$core$async$mix_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10933__auto____1;
return cljs$core$async$mix_$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___20550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11046__auto__ = (function (){var statearr_20549 = f__11045__auto__.call(null);
(statearr_20549[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___20550);

return statearr_20549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___20550,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20599 = [];
var len__5726__auto___20602 = arguments.length;
var i__5727__auto___20603 = (0);
while(true){
if((i__5727__auto___20603 < len__5726__auto___20602)){
args20599.push((arguments[i__5727__auto___20603]));

var G__20604 = (i__5727__auto___20603 + (1));
i__5727__auto___20603 = G__20604;
continue;
} else {
}
break;
}

var G__20601 = args20599.length;
switch (G__20601) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20599.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20607 = [];
var len__5726__auto___20732 = arguments.length;
var i__5727__auto___20733 = (0);
while(true){
if((i__5727__auto___20733 < len__5726__auto___20732)){
args20607.push((arguments[i__5727__auto___20733]));

var G__20734 = (i__5727__auto___20733 + (1));
i__5727__auto___20733 = G__20734;
continue;
} else {
}
break;
}

var G__20609 = args20607.length;
switch (G__20609) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20607.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__20606_SHARP_){
if(cljs.core.truth_(p1__20606_SHARP_.call(null,topic))){
return p1__20606_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20606_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20610 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20610 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20611){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20611 = meta20611;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20612,meta20611__$1){
var self__ = this;
var _20612__$1 = this;
return (new cljs.core.async.t_cljs$core$async20610(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20611__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20612){
var self__ = this;
var _20612__$1 = this;
return self__.meta20611;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20610.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20610.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20611","meta20611",-1671690145,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20610.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20610.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20610";

cljs.core.async.t_cljs$core$async20610.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async20610");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20610 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20610(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20611){
return (new cljs.core.async.t_cljs$core$async20610(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20611));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20610(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11044__auto___20736 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___20736,mults,ensure_mult,p){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___20736,mults,ensure_mult,p){
return (function (state_20684){
var state_val_20685 = (state_20684[(1)]);
if((state_val_20685 === (7))){
var inst_20680 = (state_20684[(2)]);
var state_20684__$1 = state_20684;
var statearr_20686_20737 = state_20684__$1;
(statearr_20686_20737[(2)] = inst_20680);

(statearr_20686_20737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (20))){
var state_20684__$1 = state_20684;
var statearr_20687_20738 = state_20684__$1;
(statearr_20687_20738[(2)] = null);

(statearr_20687_20738[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (1))){
var state_20684__$1 = state_20684;
var statearr_20688_20739 = state_20684__$1;
(statearr_20688_20739[(2)] = null);

(statearr_20688_20739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (24))){
var inst_20663 = (state_20684[(7)]);
var inst_20672 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20663);
var state_20684__$1 = state_20684;
var statearr_20689_20740 = state_20684__$1;
(statearr_20689_20740[(2)] = inst_20672);

(statearr_20689_20740[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (4))){
var inst_20615 = (state_20684[(8)]);
var inst_20615__$1 = (state_20684[(2)]);
var inst_20616 = (inst_20615__$1 == null);
var state_20684__$1 = (function (){var statearr_20690 = state_20684;
(statearr_20690[(8)] = inst_20615__$1);

return statearr_20690;
})();
if(cljs.core.truth_(inst_20616)){
var statearr_20691_20741 = state_20684__$1;
(statearr_20691_20741[(1)] = (5));

} else {
var statearr_20692_20742 = state_20684__$1;
(statearr_20692_20742[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (15))){
var inst_20657 = (state_20684[(2)]);
var state_20684__$1 = state_20684;
var statearr_20693_20743 = state_20684__$1;
(statearr_20693_20743[(2)] = inst_20657);

(statearr_20693_20743[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (21))){
var inst_20677 = (state_20684[(2)]);
var state_20684__$1 = (function (){var statearr_20694 = state_20684;
(statearr_20694[(9)] = inst_20677);

return statearr_20694;
})();
var statearr_20695_20744 = state_20684__$1;
(statearr_20695_20744[(2)] = null);

(statearr_20695_20744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (13))){
var inst_20639 = (state_20684[(10)]);
var inst_20641 = cljs.core.chunked_seq_QMARK_.call(null,inst_20639);
var state_20684__$1 = state_20684;
if(inst_20641){
var statearr_20696_20745 = state_20684__$1;
(statearr_20696_20745[(1)] = (16));

} else {
var statearr_20697_20746 = state_20684__$1;
(statearr_20697_20746[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (22))){
var inst_20669 = (state_20684[(2)]);
var state_20684__$1 = state_20684;
if(cljs.core.truth_(inst_20669)){
var statearr_20698_20747 = state_20684__$1;
(statearr_20698_20747[(1)] = (23));

} else {
var statearr_20699_20748 = state_20684__$1;
(statearr_20699_20748[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (6))){
var inst_20665 = (state_20684[(11)]);
var inst_20615 = (state_20684[(8)]);
var inst_20663 = (state_20684[(7)]);
var inst_20663__$1 = topic_fn.call(null,inst_20615);
var inst_20664 = cljs.core.deref.call(null,mults);
var inst_20665__$1 = cljs.core.get.call(null,inst_20664,inst_20663__$1);
var state_20684__$1 = (function (){var statearr_20700 = state_20684;
(statearr_20700[(11)] = inst_20665__$1);

(statearr_20700[(7)] = inst_20663__$1);

return statearr_20700;
})();
if(cljs.core.truth_(inst_20665__$1)){
var statearr_20701_20749 = state_20684__$1;
(statearr_20701_20749[(1)] = (19));

} else {
var statearr_20702_20750 = state_20684__$1;
(statearr_20702_20750[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (25))){
var inst_20674 = (state_20684[(2)]);
var state_20684__$1 = state_20684;
var statearr_20703_20751 = state_20684__$1;
(statearr_20703_20751[(2)] = inst_20674);

(statearr_20703_20751[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (17))){
var inst_20639 = (state_20684[(10)]);
var inst_20648 = cljs.core.first.call(null,inst_20639);
var inst_20649 = cljs.core.async.muxch_STAR_.call(null,inst_20648);
var inst_20650 = cljs.core.async.close_BANG_.call(null,inst_20649);
var inst_20651 = cljs.core.next.call(null,inst_20639);
var inst_20625 = inst_20651;
var inst_20626 = null;
var inst_20627 = (0);
var inst_20628 = (0);
var state_20684__$1 = (function (){var statearr_20704 = state_20684;
(statearr_20704[(12)] = inst_20628);

(statearr_20704[(13)] = inst_20626);

(statearr_20704[(14)] = inst_20625);

(statearr_20704[(15)] = inst_20627);

(statearr_20704[(16)] = inst_20650);

return statearr_20704;
})();
var statearr_20705_20752 = state_20684__$1;
(statearr_20705_20752[(2)] = null);

(statearr_20705_20752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (3))){
var inst_20682 = (state_20684[(2)]);
var state_20684__$1 = state_20684;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20684__$1,inst_20682);
} else {
if((state_val_20685 === (12))){
var inst_20659 = (state_20684[(2)]);
var state_20684__$1 = state_20684;
var statearr_20706_20753 = state_20684__$1;
(statearr_20706_20753[(2)] = inst_20659);

(statearr_20706_20753[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (2))){
var state_20684__$1 = state_20684;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20684__$1,(4),ch);
} else {
if((state_val_20685 === (23))){
var state_20684__$1 = state_20684;
var statearr_20707_20754 = state_20684__$1;
(statearr_20707_20754[(2)] = null);

(statearr_20707_20754[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (19))){
var inst_20665 = (state_20684[(11)]);
var inst_20615 = (state_20684[(8)]);
var inst_20667 = cljs.core.async.muxch_STAR_.call(null,inst_20665);
var state_20684__$1 = state_20684;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20684__$1,(22),inst_20667,inst_20615);
} else {
if((state_val_20685 === (11))){
var inst_20625 = (state_20684[(14)]);
var inst_20639 = (state_20684[(10)]);
var inst_20639__$1 = cljs.core.seq.call(null,inst_20625);
var state_20684__$1 = (function (){var statearr_20708 = state_20684;
(statearr_20708[(10)] = inst_20639__$1);

return statearr_20708;
})();
if(inst_20639__$1){
var statearr_20709_20755 = state_20684__$1;
(statearr_20709_20755[(1)] = (13));

} else {
var statearr_20710_20756 = state_20684__$1;
(statearr_20710_20756[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (9))){
var inst_20661 = (state_20684[(2)]);
var state_20684__$1 = state_20684;
var statearr_20711_20757 = state_20684__$1;
(statearr_20711_20757[(2)] = inst_20661);

(statearr_20711_20757[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (5))){
var inst_20622 = cljs.core.deref.call(null,mults);
var inst_20623 = cljs.core.vals.call(null,inst_20622);
var inst_20624 = cljs.core.seq.call(null,inst_20623);
var inst_20625 = inst_20624;
var inst_20626 = null;
var inst_20627 = (0);
var inst_20628 = (0);
var state_20684__$1 = (function (){var statearr_20712 = state_20684;
(statearr_20712[(12)] = inst_20628);

(statearr_20712[(13)] = inst_20626);

(statearr_20712[(14)] = inst_20625);

(statearr_20712[(15)] = inst_20627);

return statearr_20712;
})();
var statearr_20713_20758 = state_20684__$1;
(statearr_20713_20758[(2)] = null);

(statearr_20713_20758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (14))){
var state_20684__$1 = state_20684;
var statearr_20717_20759 = state_20684__$1;
(statearr_20717_20759[(2)] = null);

(statearr_20717_20759[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (16))){
var inst_20639 = (state_20684[(10)]);
var inst_20643 = cljs.core.chunk_first.call(null,inst_20639);
var inst_20644 = cljs.core.chunk_rest.call(null,inst_20639);
var inst_20645 = cljs.core.count.call(null,inst_20643);
var inst_20625 = inst_20644;
var inst_20626 = inst_20643;
var inst_20627 = inst_20645;
var inst_20628 = (0);
var state_20684__$1 = (function (){var statearr_20718 = state_20684;
(statearr_20718[(12)] = inst_20628);

(statearr_20718[(13)] = inst_20626);

(statearr_20718[(14)] = inst_20625);

(statearr_20718[(15)] = inst_20627);

return statearr_20718;
})();
var statearr_20719_20760 = state_20684__$1;
(statearr_20719_20760[(2)] = null);

(statearr_20719_20760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (10))){
var inst_20628 = (state_20684[(12)]);
var inst_20626 = (state_20684[(13)]);
var inst_20625 = (state_20684[(14)]);
var inst_20627 = (state_20684[(15)]);
var inst_20633 = cljs.core._nth.call(null,inst_20626,inst_20628);
var inst_20634 = cljs.core.async.muxch_STAR_.call(null,inst_20633);
var inst_20635 = cljs.core.async.close_BANG_.call(null,inst_20634);
var inst_20636 = (inst_20628 + (1));
var tmp20714 = inst_20626;
var tmp20715 = inst_20625;
var tmp20716 = inst_20627;
var inst_20625__$1 = tmp20715;
var inst_20626__$1 = tmp20714;
var inst_20627__$1 = tmp20716;
var inst_20628__$1 = inst_20636;
var state_20684__$1 = (function (){var statearr_20720 = state_20684;
(statearr_20720[(17)] = inst_20635);

(statearr_20720[(12)] = inst_20628__$1);

(statearr_20720[(13)] = inst_20626__$1);

(statearr_20720[(14)] = inst_20625__$1);

(statearr_20720[(15)] = inst_20627__$1);

return statearr_20720;
})();
var statearr_20721_20761 = state_20684__$1;
(statearr_20721_20761[(2)] = null);

(statearr_20721_20761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (18))){
var inst_20654 = (state_20684[(2)]);
var state_20684__$1 = state_20684;
var statearr_20722_20762 = state_20684__$1;
(statearr_20722_20762[(2)] = inst_20654);

(statearr_20722_20762[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20685 === (8))){
var inst_20628 = (state_20684[(12)]);
var inst_20627 = (state_20684[(15)]);
var inst_20630 = (inst_20628 < inst_20627);
var inst_20631 = inst_20630;
var state_20684__$1 = state_20684;
if(cljs.core.truth_(inst_20631)){
var statearr_20723_20763 = state_20684__$1;
(statearr_20723_20763[(1)] = (10));

} else {
var statearr_20724_20764 = state_20684__$1;
(statearr_20724_20764[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___20736,mults,ensure_mult,p))
;
return ((function (switch__10932__auto__,c__11044__auto___20736,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_20728 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20728[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_20728[(1)] = (1));

return statearr_20728;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_20684){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_20684);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e20729){if((e20729 instanceof Object)){
var ex__10936__auto__ = e20729;
var statearr_20730_20765 = state_20684;
(statearr_20730_20765[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20684);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20729;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20766 = state_20684;
state_20684 = G__20766;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_20684){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_20684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___20736,mults,ensure_mult,p))
})();
var state__11046__auto__ = (function (){var statearr_20731 = f__11045__auto__.call(null);
(statearr_20731[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___20736);

return statearr_20731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___20736,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20767 = [];
var len__5726__auto___20770 = arguments.length;
var i__5727__auto___20771 = (0);
while(true){
if((i__5727__auto___20771 < len__5726__auto___20770)){
args20767.push((arguments[i__5727__auto___20771]));

var G__20772 = (i__5727__auto___20771 + (1));
i__5727__auto___20771 = G__20772;
continue;
} else {
}
break;
}

var G__20769 = args20767.length;
switch (G__20769) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20767.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20774 = [];
var len__5726__auto___20777 = arguments.length;
var i__5727__auto___20778 = (0);
while(true){
if((i__5727__auto___20778 < len__5726__auto___20777)){
args20774.push((arguments[i__5727__auto___20778]));

var G__20779 = (i__5727__auto___20778 + (1));
i__5727__auto___20778 = G__20779;
continue;
} else {
}
break;
}

var G__20776 = args20774.length;
switch (G__20776) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20774.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20781 = [];
var len__5726__auto___20852 = arguments.length;
var i__5727__auto___20853 = (0);
while(true){
if((i__5727__auto___20853 < len__5726__auto___20852)){
args20781.push((arguments[i__5727__auto___20853]));

var G__20854 = (i__5727__auto___20853 + (1));
i__5727__auto___20853 = G__20854;
continue;
} else {
}
break;
}

var G__20783 = args20781.length;
switch (G__20783) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20781.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11044__auto___20856 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___20856,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___20856,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20822){
var state_val_20823 = (state_20822[(1)]);
if((state_val_20823 === (7))){
var state_20822__$1 = state_20822;
var statearr_20824_20857 = state_20822__$1;
(statearr_20824_20857[(2)] = null);

(statearr_20824_20857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (1))){
var state_20822__$1 = state_20822;
var statearr_20825_20858 = state_20822__$1;
(statearr_20825_20858[(2)] = null);

(statearr_20825_20858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (4))){
var inst_20786 = (state_20822[(7)]);
var inst_20788 = (inst_20786 < cnt);
var state_20822__$1 = state_20822;
if(cljs.core.truth_(inst_20788)){
var statearr_20826_20859 = state_20822__$1;
(statearr_20826_20859[(1)] = (6));

} else {
var statearr_20827_20860 = state_20822__$1;
(statearr_20827_20860[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (15))){
var inst_20818 = (state_20822[(2)]);
var state_20822__$1 = state_20822;
var statearr_20828_20861 = state_20822__$1;
(statearr_20828_20861[(2)] = inst_20818);

(statearr_20828_20861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (13))){
var inst_20811 = cljs.core.async.close_BANG_.call(null,out);
var state_20822__$1 = state_20822;
var statearr_20829_20862 = state_20822__$1;
(statearr_20829_20862[(2)] = inst_20811);

(statearr_20829_20862[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (6))){
var state_20822__$1 = state_20822;
var statearr_20830_20863 = state_20822__$1;
(statearr_20830_20863[(2)] = null);

(statearr_20830_20863[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (3))){
var inst_20820 = (state_20822[(2)]);
var state_20822__$1 = state_20822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20822__$1,inst_20820);
} else {
if((state_val_20823 === (12))){
var inst_20808 = (state_20822[(8)]);
var inst_20808__$1 = (state_20822[(2)]);
var inst_20809 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20808__$1);
var state_20822__$1 = (function (){var statearr_20831 = state_20822;
(statearr_20831[(8)] = inst_20808__$1);

return statearr_20831;
})();
if(cljs.core.truth_(inst_20809)){
var statearr_20832_20864 = state_20822__$1;
(statearr_20832_20864[(1)] = (13));

} else {
var statearr_20833_20865 = state_20822__$1;
(statearr_20833_20865[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (2))){
var inst_20785 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20786 = (0);
var state_20822__$1 = (function (){var statearr_20834 = state_20822;
(statearr_20834[(9)] = inst_20785);

(statearr_20834[(7)] = inst_20786);

return statearr_20834;
})();
var statearr_20835_20866 = state_20822__$1;
(statearr_20835_20866[(2)] = null);

(statearr_20835_20866[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (11))){
var inst_20786 = (state_20822[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20822,(10),Object,null,(9));
var inst_20795 = chs__$1.call(null,inst_20786);
var inst_20796 = done.call(null,inst_20786);
var inst_20797 = cljs.core.async.take_BANG_.call(null,inst_20795,inst_20796);
var state_20822__$1 = state_20822;
var statearr_20836_20867 = state_20822__$1;
(statearr_20836_20867[(2)] = inst_20797);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20822__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (9))){
var inst_20786 = (state_20822[(7)]);
var inst_20799 = (state_20822[(2)]);
var inst_20800 = (inst_20786 + (1));
var inst_20786__$1 = inst_20800;
var state_20822__$1 = (function (){var statearr_20837 = state_20822;
(statearr_20837[(10)] = inst_20799);

(statearr_20837[(7)] = inst_20786__$1);

return statearr_20837;
})();
var statearr_20838_20868 = state_20822__$1;
(statearr_20838_20868[(2)] = null);

(statearr_20838_20868[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (5))){
var inst_20806 = (state_20822[(2)]);
var state_20822__$1 = (function (){var statearr_20839 = state_20822;
(statearr_20839[(11)] = inst_20806);

return statearr_20839;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20822__$1,(12),dchan);
} else {
if((state_val_20823 === (14))){
var inst_20808 = (state_20822[(8)]);
var inst_20813 = cljs.core.apply.call(null,f,inst_20808);
var state_20822__$1 = state_20822;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20822__$1,(16),out,inst_20813);
} else {
if((state_val_20823 === (16))){
var inst_20815 = (state_20822[(2)]);
var state_20822__$1 = (function (){var statearr_20840 = state_20822;
(statearr_20840[(12)] = inst_20815);

return statearr_20840;
})();
var statearr_20841_20869 = state_20822__$1;
(statearr_20841_20869[(2)] = null);

(statearr_20841_20869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (10))){
var inst_20790 = (state_20822[(2)]);
var inst_20791 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20822__$1 = (function (){var statearr_20842 = state_20822;
(statearr_20842[(13)] = inst_20790);

return statearr_20842;
})();
var statearr_20843_20870 = state_20822__$1;
(statearr_20843_20870[(2)] = inst_20791);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20822__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20823 === (8))){
var inst_20804 = (state_20822[(2)]);
var state_20822__$1 = state_20822;
var statearr_20844_20871 = state_20822__$1;
(statearr_20844_20871[(2)] = inst_20804);

(statearr_20844_20871[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___20856,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10932__auto__,c__11044__auto___20856,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_20848 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20848[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_20848[(1)] = (1));

return statearr_20848;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_20822){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_20822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e20849){if((e20849 instanceof Object)){
var ex__10936__auto__ = e20849;
var statearr_20850_20872 = state_20822;
(statearr_20850_20872[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20822);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20849;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20873 = state_20822;
state_20822 = G__20873;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_20822){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_20822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___20856,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11046__auto__ = (function (){var statearr_20851 = f__11045__auto__.call(null);
(statearr_20851[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___20856);

return statearr_20851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___20856,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20875 = [];
var len__5726__auto___20931 = arguments.length;
var i__5727__auto___20932 = (0);
while(true){
if((i__5727__auto___20932 < len__5726__auto___20931)){
args20875.push((arguments[i__5727__auto___20932]));

var G__20933 = (i__5727__auto___20932 + (1));
i__5727__auto___20932 = G__20933;
continue;
} else {
}
break;
}

var G__20877 = args20875.length;
switch (G__20877) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20875.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___20935 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___20935,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___20935,out){
return (function (state_20907){
var state_val_20908 = (state_20907[(1)]);
if((state_val_20908 === (7))){
var inst_20887 = (state_20907[(7)]);
var inst_20886 = (state_20907[(8)]);
var inst_20886__$1 = (state_20907[(2)]);
var inst_20887__$1 = cljs.core.nth.call(null,inst_20886__$1,(0),null);
var inst_20888 = cljs.core.nth.call(null,inst_20886__$1,(1),null);
var inst_20889 = (inst_20887__$1 == null);
var state_20907__$1 = (function (){var statearr_20909 = state_20907;
(statearr_20909[(7)] = inst_20887__$1);

(statearr_20909[(8)] = inst_20886__$1);

(statearr_20909[(9)] = inst_20888);

return statearr_20909;
})();
if(cljs.core.truth_(inst_20889)){
var statearr_20910_20936 = state_20907__$1;
(statearr_20910_20936[(1)] = (8));

} else {
var statearr_20911_20937 = state_20907__$1;
(statearr_20911_20937[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20908 === (1))){
var inst_20878 = cljs.core.vec.call(null,chs);
var inst_20879 = inst_20878;
var state_20907__$1 = (function (){var statearr_20912 = state_20907;
(statearr_20912[(10)] = inst_20879);

return statearr_20912;
})();
var statearr_20913_20938 = state_20907__$1;
(statearr_20913_20938[(2)] = null);

(statearr_20913_20938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20908 === (4))){
var inst_20879 = (state_20907[(10)]);
var state_20907__$1 = state_20907;
return cljs.core.async.ioc_alts_BANG_.call(null,state_20907__$1,(7),inst_20879);
} else {
if((state_val_20908 === (6))){
var inst_20903 = (state_20907[(2)]);
var state_20907__$1 = state_20907;
var statearr_20914_20939 = state_20907__$1;
(statearr_20914_20939[(2)] = inst_20903);

(statearr_20914_20939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20908 === (3))){
var inst_20905 = (state_20907[(2)]);
var state_20907__$1 = state_20907;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20907__$1,inst_20905);
} else {
if((state_val_20908 === (2))){
var inst_20879 = (state_20907[(10)]);
var inst_20881 = cljs.core.count.call(null,inst_20879);
var inst_20882 = (inst_20881 > (0));
var state_20907__$1 = state_20907;
if(cljs.core.truth_(inst_20882)){
var statearr_20916_20940 = state_20907__$1;
(statearr_20916_20940[(1)] = (4));

} else {
var statearr_20917_20941 = state_20907__$1;
(statearr_20917_20941[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20908 === (11))){
var inst_20879 = (state_20907[(10)]);
var inst_20896 = (state_20907[(2)]);
var tmp20915 = inst_20879;
var inst_20879__$1 = tmp20915;
var state_20907__$1 = (function (){var statearr_20918 = state_20907;
(statearr_20918[(11)] = inst_20896);

(statearr_20918[(10)] = inst_20879__$1);

return statearr_20918;
})();
var statearr_20919_20942 = state_20907__$1;
(statearr_20919_20942[(2)] = null);

(statearr_20919_20942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20908 === (9))){
var inst_20887 = (state_20907[(7)]);
var state_20907__$1 = state_20907;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20907__$1,(11),out,inst_20887);
} else {
if((state_val_20908 === (5))){
var inst_20901 = cljs.core.async.close_BANG_.call(null,out);
var state_20907__$1 = state_20907;
var statearr_20920_20943 = state_20907__$1;
(statearr_20920_20943[(2)] = inst_20901);

(statearr_20920_20943[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20908 === (10))){
var inst_20899 = (state_20907[(2)]);
var state_20907__$1 = state_20907;
var statearr_20921_20944 = state_20907__$1;
(statearr_20921_20944[(2)] = inst_20899);

(statearr_20921_20944[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20908 === (8))){
var inst_20887 = (state_20907[(7)]);
var inst_20886 = (state_20907[(8)]);
var inst_20879 = (state_20907[(10)]);
var inst_20888 = (state_20907[(9)]);
var inst_20891 = (function (){var cs = inst_20879;
var vec__20884 = inst_20886;
var v = inst_20887;
var c = inst_20888;
return ((function (cs,vec__20884,v,c,inst_20887,inst_20886,inst_20879,inst_20888,state_val_20908,c__11044__auto___20935,out){
return (function (p1__20874_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20874_SHARP_);
});
;})(cs,vec__20884,v,c,inst_20887,inst_20886,inst_20879,inst_20888,state_val_20908,c__11044__auto___20935,out))
})();
var inst_20892 = cljs.core.filterv.call(null,inst_20891,inst_20879);
var inst_20879__$1 = inst_20892;
var state_20907__$1 = (function (){var statearr_20922 = state_20907;
(statearr_20922[(10)] = inst_20879__$1);

return statearr_20922;
})();
var statearr_20923_20945 = state_20907__$1;
(statearr_20923_20945[(2)] = null);

(statearr_20923_20945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___20935,out))
;
return ((function (switch__10932__auto__,c__11044__auto___20935,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_20927 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20927[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_20927[(1)] = (1));

return statearr_20927;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_20907){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_20907);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e20928){if((e20928 instanceof Object)){
var ex__10936__auto__ = e20928;
var statearr_20929_20946 = state_20907;
(statearr_20929_20946[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20907);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20928;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20947 = state_20907;
state_20907 = G__20947;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_20907){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_20907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___20935,out))
})();
var state__11046__auto__ = (function (){var statearr_20930 = f__11045__auto__.call(null);
(statearr_20930[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___20935);

return statearr_20930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___20935,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args20948 = [];
var len__5726__auto___20997 = arguments.length;
var i__5727__auto___20998 = (0);
while(true){
if((i__5727__auto___20998 < len__5726__auto___20997)){
args20948.push((arguments[i__5727__auto___20998]));

var G__20999 = (i__5727__auto___20998 + (1));
i__5727__auto___20998 = G__20999;
continue;
} else {
}
break;
}

var G__20950 = args20948.length;
switch (G__20950) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20948.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___21001 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___21001,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___21001,out){
return (function (state_20974){
var state_val_20975 = (state_20974[(1)]);
if((state_val_20975 === (7))){
var inst_20956 = (state_20974[(7)]);
var inst_20956__$1 = (state_20974[(2)]);
var inst_20957 = (inst_20956__$1 == null);
var inst_20958 = cljs.core.not.call(null,inst_20957);
var state_20974__$1 = (function (){var statearr_20976 = state_20974;
(statearr_20976[(7)] = inst_20956__$1);

return statearr_20976;
})();
if(inst_20958){
var statearr_20977_21002 = state_20974__$1;
(statearr_20977_21002[(1)] = (8));

} else {
var statearr_20978_21003 = state_20974__$1;
(statearr_20978_21003[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (1))){
var inst_20951 = (0);
var state_20974__$1 = (function (){var statearr_20979 = state_20974;
(statearr_20979[(8)] = inst_20951);

return statearr_20979;
})();
var statearr_20980_21004 = state_20974__$1;
(statearr_20980_21004[(2)] = null);

(statearr_20980_21004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (4))){
var state_20974__$1 = state_20974;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20974__$1,(7),ch);
} else {
if((state_val_20975 === (6))){
var inst_20969 = (state_20974[(2)]);
var state_20974__$1 = state_20974;
var statearr_20981_21005 = state_20974__$1;
(statearr_20981_21005[(2)] = inst_20969);

(statearr_20981_21005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (3))){
var inst_20971 = (state_20974[(2)]);
var inst_20972 = cljs.core.async.close_BANG_.call(null,out);
var state_20974__$1 = (function (){var statearr_20982 = state_20974;
(statearr_20982[(9)] = inst_20971);

return statearr_20982;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20974__$1,inst_20972);
} else {
if((state_val_20975 === (2))){
var inst_20951 = (state_20974[(8)]);
var inst_20953 = (inst_20951 < n);
var state_20974__$1 = state_20974;
if(cljs.core.truth_(inst_20953)){
var statearr_20983_21006 = state_20974__$1;
(statearr_20983_21006[(1)] = (4));

} else {
var statearr_20984_21007 = state_20974__$1;
(statearr_20984_21007[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (11))){
var inst_20951 = (state_20974[(8)]);
var inst_20961 = (state_20974[(2)]);
var inst_20962 = (inst_20951 + (1));
var inst_20951__$1 = inst_20962;
var state_20974__$1 = (function (){var statearr_20985 = state_20974;
(statearr_20985[(8)] = inst_20951__$1);

(statearr_20985[(10)] = inst_20961);

return statearr_20985;
})();
var statearr_20986_21008 = state_20974__$1;
(statearr_20986_21008[(2)] = null);

(statearr_20986_21008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (9))){
var state_20974__$1 = state_20974;
var statearr_20987_21009 = state_20974__$1;
(statearr_20987_21009[(2)] = null);

(statearr_20987_21009[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (5))){
var state_20974__$1 = state_20974;
var statearr_20988_21010 = state_20974__$1;
(statearr_20988_21010[(2)] = null);

(statearr_20988_21010[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (10))){
var inst_20966 = (state_20974[(2)]);
var state_20974__$1 = state_20974;
var statearr_20989_21011 = state_20974__$1;
(statearr_20989_21011[(2)] = inst_20966);

(statearr_20989_21011[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20975 === (8))){
var inst_20956 = (state_20974[(7)]);
var state_20974__$1 = state_20974;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20974__$1,(11),out,inst_20956);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___21001,out))
;
return ((function (switch__10932__auto__,c__11044__auto___21001,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_20993 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20993[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_20993[(1)] = (1));

return statearr_20993;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_20974){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_20974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e20994){if((e20994 instanceof Object)){
var ex__10936__auto__ = e20994;
var statearr_20995_21012 = state_20974;
(statearr_20995_21012[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20974);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20994;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21013 = state_20974;
state_20974 = G__21013;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_20974){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_20974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___21001,out))
})();
var state__11046__auto__ = (function (){var statearr_20996 = f__11045__auto__.call(null);
(statearr_20996[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___21001);

return statearr_20996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___21001,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21021 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21021 = (function (map_LT_,f,ch,meta21022){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21022 = meta21022;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21023,meta21022__$1){
var self__ = this;
var _21023__$1 = this;
return (new cljs.core.async.t_cljs$core$async21021(self__.map_LT_,self__.f,self__.ch,meta21022__$1));
});

cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21023){
var self__ = this;
var _21023__$1 = this;
return self__.meta21022;
});

cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async21024 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21024 = (function (map_LT_,f,ch,meta21022,_,fn1,meta21025){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta21022 = meta21022;
this._ = _;
this.fn1 = fn1;
this.meta21025 = meta21025;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21024.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_21026,meta21025__$1){
var self__ = this;
var _21026__$1 = this;
return (new cljs.core.async.t_cljs$core$async21024(self__.map_LT_,self__.f,self__.ch,self__.meta21022,self__._,self__.fn1,meta21025__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async21024.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_21026){
var self__ = this;
var _21026__$1 = this;
return self__.meta21025;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21024.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async21024.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21024.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async21024.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__21014_SHARP_){
return f1.call(null,(((p1__21014_SHARP_ == null))?null:self__.f.call(null,p1__21014_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async21024.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21022","meta21022",-533052440,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21021","cljs.core.async/t_cljs$core$async21021",-1460456788,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21025","meta21025",1775938724,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async21024.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21024.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21024";

cljs.core.async.t_cljs$core$async21024.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21024");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async21024 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21024(map_LT___$1,f__$1,ch__$1,meta21022__$1,___$2,fn1__$1,meta21025){
return (new cljs.core.async.t_cljs$core$async21024(map_LT___$1,f__$1,ch__$1,meta21022__$1,___$2,fn1__$1,meta21025));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async21024(self__.map_LT_,self__.f,self__.ch,self__.meta21022,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21021.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async21021.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21022","meta21022",-533052440,null)], null);
});

cljs.core.async.t_cljs$core$async21021.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21021.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21021";

cljs.core.async.t_cljs$core$async21021.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21021");
});

cljs.core.async.__GT_t_cljs$core$async21021 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21021(map_LT___$1,f__$1,ch__$1,meta21022){
return (new cljs.core.async.t_cljs$core$async21021(map_LT___$1,f__$1,ch__$1,meta21022));
});

}

return (new cljs.core.async.t_cljs$core$async21021(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async21030 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21030 = (function (map_GT_,f,ch,meta21031){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta21031 = meta21031;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21030.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21032,meta21031__$1){
var self__ = this;
var _21032__$1 = this;
return (new cljs.core.async.t_cljs$core$async21030(self__.map_GT_,self__.f,self__.ch,meta21031__$1));
});

cljs.core.async.t_cljs$core$async21030.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21032){
var self__ = this;
var _21032__$1 = this;
return self__.meta21031;
});

cljs.core.async.t_cljs$core$async21030.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21030.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21030.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21030.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21030.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21030.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async21030.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21031","meta21031",-913897059,null)], null);
});

cljs.core.async.t_cljs$core$async21030.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21030.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21030";

cljs.core.async.t_cljs$core$async21030.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21030");
});

cljs.core.async.__GT_t_cljs$core$async21030 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21030(map_GT___$1,f__$1,ch__$1,meta21031){
return (new cljs.core.async.t_cljs$core$async21030(map_GT___$1,f__$1,ch__$1,meta21031));
});

}

return (new cljs.core.async.t_cljs$core$async21030(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async21036 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21036 = (function (filter_GT_,p,ch,meta21037){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta21037 = meta21037;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21038,meta21037__$1){
var self__ = this;
var _21038__$1 = this;
return (new cljs.core.async.t_cljs$core$async21036(self__.filter_GT_,self__.p,self__.ch,meta21037__$1));
});

cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21038){
var self__ = this;
var _21038__$1 = this;
return self__.meta21037;
});

cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async21036.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async21036.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21037","meta21037",306840880,null)], null);
});

cljs.core.async.t_cljs$core$async21036.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async21036.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21036";

cljs.core.async.t_cljs$core$async21036.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async21036");
});

cljs.core.async.__GT_t_cljs$core$async21036 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21036(filter_GT___$1,p__$1,ch__$1,meta21037){
return (new cljs.core.async.t_cljs$core$async21036(filter_GT___$1,p__$1,ch__$1,meta21037));
});

}

return (new cljs.core.async.t_cljs$core$async21036(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args21039 = [];
var len__5726__auto___21083 = arguments.length;
var i__5727__auto___21084 = (0);
while(true){
if((i__5727__auto___21084 < len__5726__auto___21083)){
args21039.push((arguments[i__5727__auto___21084]));

var G__21085 = (i__5727__auto___21084 + (1));
i__5727__auto___21084 = G__21085;
continue;
} else {
}
break;
}

var G__21041 = args21039.length;
switch (G__21041) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21039.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___21087 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___21087,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___21087,out){
return (function (state_21062){
var state_val_21063 = (state_21062[(1)]);
if((state_val_21063 === (7))){
var inst_21058 = (state_21062[(2)]);
var state_21062__$1 = state_21062;
var statearr_21064_21088 = state_21062__$1;
(statearr_21064_21088[(2)] = inst_21058);

(statearr_21064_21088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21063 === (1))){
var state_21062__$1 = state_21062;
var statearr_21065_21089 = state_21062__$1;
(statearr_21065_21089[(2)] = null);

(statearr_21065_21089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21063 === (4))){
var inst_21044 = (state_21062[(7)]);
var inst_21044__$1 = (state_21062[(2)]);
var inst_21045 = (inst_21044__$1 == null);
var state_21062__$1 = (function (){var statearr_21066 = state_21062;
(statearr_21066[(7)] = inst_21044__$1);

return statearr_21066;
})();
if(cljs.core.truth_(inst_21045)){
var statearr_21067_21090 = state_21062__$1;
(statearr_21067_21090[(1)] = (5));

} else {
var statearr_21068_21091 = state_21062__$1;
(statearr_21068_21091[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21063 === (6))){
var inst_21044 = (state_21062[(7)]);
var inst_21049 = p.call(null,inst_21044);
var state_21062__$1 = state_21062;
if(cljs.core.truth_(inst_21049)){
var statearr_21069_21092 = state_21062__$1;
(statearr_21069_21092[(1)] = (8));

} else {
var statearr_21070_21093 = state_21062__$1;
(statearr_21070_21093[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21063 === (3))){
var inst_21060 = (state_21062[(2)]);
var state_21062__$1 = state_21062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21062__$1,inst_21060);
} else {
if((state_val_21063 === (2))){
var state_21062__$1 = state_21062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21062__$1,(4),ch);
} else {
if((state_val_21063 === (11))){
var inst_21052 = (state_21062[(2)]);
var state_21062__$1 = state_21062;
var statearr_21071_21094 = state_21062__$1;
(statearr_21071_21094[(2)] = inst_21052);

(statearr_21071_21094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21063 === (9))){
var state_21062__$1 = state_21062;
var statearr_21072_21095 = state_21062__$1;
(statearr_21072_21095[(2)] = null);

(statearr_21072_21095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21063 === (5))){
var inst_21047 = cljs.core.async.close_BANG_.call(null,out);
var state_21062__$1 = state_21062;
var statearr_21073_21096 = state_21062__$1;
(statearr_21073_21096[(2)] = inst_21047);

(statearr_21073_21096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21063 === (10))){
var inst_21055 = (state_21062[(2)]);
var state_21062__$1 = (function (){var statearr_21074 = state_21062;
(statearr_21074[(8)] = inst_21055);

return statearr_21074;
})();
var statearr_21075_21097 = state_21062__$1;
(statearr_21075_21097[(2)] = null);

(statearr_21075_21097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21063 === (8))){
var inst_21044 = (state_21062[(7)]);
var state_21062__$1 = state_21062;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21062__$1,(11),out,inst_21044);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___21087,out))
;
return ((function (switch__10932__auto__,c__11044__auto___21087,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_21079 = [null,null,null,null,null,null,null,null,null];
(statearr_21079[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_21079[(1)] = (1));

return statearr_21079;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_21062){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_21062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e21080){if((e21080 instanceof Object)){
var ex__10936__auto__ = e21080;
var statearr_21081_21098 = state_21062;
(statearr_21081_21098[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21062);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21080;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21099 = state_21062;
state_21062 = G__21099;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_21062){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_21062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___21087,out))
})();
var state__11046__auto__ = (function (){var statearr_21082 = f__11045__auto__.call(null);
(statearr_21082[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___21087);

return statearr_21082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___21087,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args21100 = [];
var len__5726__auto___21103 = arguments.length;
var i__5727__auto___21104 = (0);
while(true){
if((i__5727__auto___21104 < len__5726__auto___21103)){
args21100.push((arguments[i__5727__auto___21104]));

var G__21105 = (i__5727__auto___21104 + (1));
i__5727__auto___21104 = G__21105;
continue;
} else {
}
break;
}

var G__21102 = args21100.length;
switch (G__21102) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21100.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto__){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto__){
return (function (state_21272){
var state_val_21273 = (state_21272[(1)]);
if((state_val_21273 === (7))){
var inst_21268 = (state_21272[(2)]);
var state_21272__$1 = state_21272;
var statearr_21274_21315 = state_21272__$1;
(statearr_21274_21315[(2)] = inst_21268);

(statearr_21274_21315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (20))){
var inst_21238 = (state_21272[(7)]);
var inst_21249 = (state_21272[(2)]);
var inst_21250 = cljs.core.next.call(null,inst_21238);
var inst_21224 = inst_21250;
var inst_21225 = null;
var inst_21226 = (0);
var inst_21227 = (0);
var state_21272__$1 = (function (){var statearr_21275 = state_21272;
(statearr_21275[(8)] = inst_21225);

(statearr_21275[(9)] = inst_21227);

(statearr_21275[(10)] = inst_21226);

(statearr_21275[(11)] = inst_21249);

(statearr_21275[(12)] = inst_21224);

return statearr_21275;
})();
var statearr_21276_21316 = state_21272__$1;
(statearr_21276_21316[(2)] = null);

(statearr_21276_21316[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (1))){
var state_21272__$1 = state_21272;
var statearr_21277_21317 = state_21272__$1;
(statearr_21277_21317[(2)] = null);

(statearr_21277_21317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (4))){
var inst_21213 = (state_21272[(13)]);
var inst_21213__$1 = (state_21272[(2)]);
var inst_21214 = (inst_21213__$1 == null);
var state_21272__$1 = (function (){var statearr_21278 = state_21272;
(statearr_21278[(13)] = inst_21213__$1);

return statearr_21278;
})();
if(cljs.core.truth_(inst_21214)){
var statearr_21279_21318 = state_21272__$1;
(statearr_21279_21318[(1)] = (5));

} else {
var statearr_21280_21319 = state_21272__$1;
(statearr_21280_21319[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (15))){
var state_21272__$1 = state_21272;
var statearr_21284_21320 = state_21272__$1;
(statearr_21284_21320[(2)] = null);

(statearr_21284_21320[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (21))){
var state_21272__$1 = state_21272;
var statearr_21285_21321 = state_21272__$1;
(statearr_21285_21321[(2)] = null);

(statearr_21285_21321[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (13))){
var inst_21225 = (state_21272[(8)]);
var inst_21227 = (state_21272[(9)]);
var inst_21226 = (state_21272[(10)]);
var inst_21224 = (state_21272[(12)]);
var inst_21234 = (state_21272[(2)]);
var inst_21235 = (inst_21227 + (1));
var tmp21281 = inst_21225;
var tmp21282 = inst_21226;
var tmp21283 = inst_21224;
var inst_21224__$1 = tmp21283;
var inst_21225__$1 = tmp21281;
var inst_21226__$1 = tmp21282;
var inst_21227__$1 = inst_21235;
var state_21272__$1 = (function (){var statearr_21286 = state_21272;
(statearr_21286[(8)] = inst_21225__$1);

(statearr_21286[(9)] = inst_21227__$1);

(statearr_21286[(10)] = inst_21226__$1);

(statearr_21286[(14)] = inst_21234);

(statearr_21286[(12)] = inst_21224__$1);

return statearr_21286;
})();
var statearr_21287_21322 = state_21272__$1;
(statearr_21287_21322[(2)] = null);

(statearr_21287_21322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (22))){
var state_21272__$1 = state_21272;
var statearr_21288_21323 = state_21272__$1;
(statearr_21288_21323[(2)] = null);

(statearr_21288_21323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (6))){
var inst_21213 = (state_21272[(13)]);
var inst_21222 = f.call(null,inst_21213);
var inst_21223 = cljs.core.seq.call(null,inst_21222);
var inst_21224 = inst_21223;
var inst_21225 = null;
var inst_21226 = (0);
var inst_21227 = (0);
var state_21272__$1 = (function (){var statearr_21289 = state_21272;
(statearr_21289[(8)] = inst_21225);

(statearr_21289[(9)] = inst_21227);

(statearr_21289[(10)] = inst_21226);

(statearr_21289[(12)] = inst_21224);

return statearr_21289;
})();
var statearr_21290_21324 = state_21272__$1;
(statearr_21290_21324[(2)] = null);

(statearr_21290_21324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (17))){
var inst_21238 = (state_21272[(7)]);
var inst_21242 = cljs.core.chunk_first.call(null,inst_21238);
var inst_21243 = cljs.core.chunk_rest.call(null,inst_21238);
var inst_21244 = cljs.core.count.call(null,inst_21242);
var inst_21224 = inst_21243;
var inst_21225 = inst_21242;
var inst_21226 = inst_21244;
var inst_21227 = (0);
var state_21272__$1 = (function (){var statearr_21291 = state_21272;
(statearr_21291[(8)] = inst_21225);

(statearr_21291[(9)] = inst_21227);

(statearr_21291[(10)] = inst_21226);

(statearr_21291[(12)] = inst_21224);

return statearr_21291;
})();
var statearr_21292_21325 = state_21272__$1;
(statearr_21292_21325[(2)] = null);

(statearr_21292_21325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (3))){
var inst_21270 = (state_21272[(2)]);
var state_21272__$1 = state_21272;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21272__$1,inst_21270);
} else {
if((state_val_21273 === (12))){
var inst_21258 = (state_21272[(2)]);
var state_21272__$1 = state_21272;
var statearr_21293_21326 = state_21272__$1;
(statearr_21293_21326[(2)] = inst_21258);

(statearr_21293_21326[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (2))){
var state_21272__$1 = state_21272;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21272__$1,(4),in$);
} else {
if((state_val_21273 === (23))){
var inst_21266 = (state_21272[(2)]);
var state_21272__$1 = state_21272;
var statearr_21294_21327 = state_21272__$1;
(statearr_21294_21327[(2)] = inst_21266);

(statearr_21294_21327[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (19))){
var inst_21253 = (state_21272[(2)]);
var state_21272__$1 = state_21272;
var statearr_21295_21328 = state_21272__$1;
(statearr_21295_21328[(2)] = inst_21253);

(statearr_21295_21328[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (11))){
var inst_21238 = (state_21272[(7)]);
var inst_21224 = (state_21272[(12)]);
var inst_21238__$1 = cljs.core.seq.call(null,inst_21224);
var state_21272__$1 = (function (){var statearr_21296 = state_21272;
(statearr_21296[(7)] = inst_21238__$1);

return statearr_21296;
})();
if(inst_21238__$1){
var statearr_21297_21329 = state_21272__$1;
(statearr_21297_21329[(1)] = (14));

} else {
var statearr_21298_21330 = state_21272__$1;
(statearr_21298_21330[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (9))){
var inst_21260 = (state_21272[(2)]);
var inst_21261 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_21272__$1 = (function (){var statearr_21299 = state_21272;
(statearr_21299[(15)] = inst_21260);

return statearr_21299;
})();
if(cljs.core.truth_(inst_21261)){
var statearr_21300_21331 = state_21272__$1;
(statearr_21300_21331[(1)] = (21));

} else {
var statearr_21301_21332 = state_21272__$1;
(statearr_21301_21332[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (5))){
var inst_21216 = cljs.core.async.close_BANG_.call(null,out);
var state_21272__$1 = state_21272;
var statearr_21302_21333 = state_21272__$1;
(statearr_21302_21333[(2)] = inst_21216);

(statearr_21302_21333[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (14))){
var inst_21238 = (state_21272[(7)]);
var inst_21240 = cljs.core.chunked_seq_QMARK_.call(null,inst_21238);
var state_21272__$1 = state_21272;
if(inst_21240){
var statearr_21303_21334 = state_21272__$1;
(statearr_21303_21334[(1)] = (17));

} else {
var statearr_21304_21335 = state_21272__$1;
(statearr_21304_21335[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (16))){
var inst_21256 = (state_21272[(2)]);
var state_21272__$1 = state_21272;
var statearr_21305_21336 = state_21272__$1;
(statearr_21305_21336[(2)] = inst_21256);

(statearr_21305_21336[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (10))){
var inst_21225 = (state_21272[(8)]);
var inst_21227 = (state_21272[(9)]);
var inst_21232 = cljs.core._nth.call(null,inst_21225,inst_21227);
var state_21272__$1 = state_21272;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21272__$1,(13),out,inst_21232);
} else {
if((state_val_21273 === (18))){
var inst_21238 = (state_21272[(7)]);
var inst_21247 = cljs.core.first.call(null,inst_21238);
var state_21272__$1 = state_21272;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21272__$1,(20),out,inst_21247);
} else {
if((state_val_21273 === (8))){
var inst_21227 = (state_21272[(9)]);
var inst_21226 = (state_21272[(10)]);
var inst_21229 = (inst_21227 < inst_21226);
var inst_21230 = inst_21229;
var state_21272__$1 = state_21272;
if(cljs.core.truth_(inst_21230)){
var statearr_21306_21337 = state_21272__$1;
(statearr_21306_21337[(1)] = (10));

} else {
var statearr_21307_21338 = state_21272__$1;
(statearr_21307_21338[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto__))
;
return ((function (switch__10932__auto__,c__11044__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_21311 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21311[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__);

(statearr_21311[(1)] = (1));

return statearr_21311;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____1 = (function (state_21272){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_21272);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e21312){if((e21312 instanceof Object)){
var ex__10936__auto__ = e21312;
var statearr_21313_21339 = state_21272;
(statearr_21313_21339[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21272);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21312;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21340 = state_21272;
state_21272 = G__21340;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__ = function(state_21272){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____1.call(this,state_21272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto__))
})();
var state__11046__auto__ = (function (){var statearr_21314 = f__11045__auto__.call(null);
(statearr_21314[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto__);

return statearr_21314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto__))
);

return c__11044__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args21341 = [];
var len__5726__auto___21344 = arguments.length;
var i__5727__auto___21345 = (0);
while(true){
if((i__5727__auto___21345 < len__5726__auto___21344)){
args21341.push((arguments[i__5727__auto___21345]));

var G__21346 = (i__5727__auto___21345 + (1));
i__5727__auto___21345 = G__21346;
continue;
} else {
}
break;
}

var G__21343 = args21341.length;
switch (G__21343) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21341.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args21348 = [];
var len__5726__auto___21351 = arguments.length;
var i__5727__auto___21352 = (0);
while(true){
if((i__5727__auto___21352 < len__5726__auto___21351)){
args21348.push((arguments[i__5727__auto___21352]));

var G__21353 = (i__5727__auto___21352 + (1));
i__5727__auto___21352 = G__21353;
continue;
} else {
}
break;
}

var G__21350 = args21348.length;
switch (G__21350) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21348.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args21355 = [];
var len__5726__auto___21406 = arguments.length;
var i__5727__auto___21407 = (0);
while(true){
if((i__5727__auto___21407 < len__5726__auto___21406)){
args21355.push((arguments[i__5727__auto___21407]));

var G__21408 = (i__5727__auto___21407 + (1));
i__5727__auto___21407 = G__21408;
continue;
} else {
}
break;
}

var G__21357 = args21355.length;
switch (G__21357) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21355.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___21410 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___21410,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___21410,out){
return (function (state_21381){
var state_val_21382 = (state_21381[(1)]);
if((state_val_21382 === (7))){
var inst_21376 = (state_21381[(2)]);
var state_21381__$1 = state_21381;
var statearr_21383_21411 = state_21381__$1;
(statearr_21383_21411[(2)] = inst_21376);

(statearr_21383_21411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21382 === (1))){
var inst_21358 = null;
var state_21381__$1 = (function (){var statearr_21384 = state_21381;
(statearr_21384[(7)] = inst_21358);

return statearr_21384;
})();
var statearr_21385_21412 = state_21381__$1;
(statearr_21385_21412[(2)] = null);

(statearr_21385_21412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21382 === (4))){
var inst_21361 = (state_21381[(8)]);
var inst_21361__$1 = (state_21381[(2)]);
var inst_21362 = (inst_21361__$1 == null);
var inst_21363 = cljs.core.not.call(null,inst_21362);
var state_21381__$1 = (function (){var statearr_21386 = state_21381;
(statearr_21386[(8)] = inst_21361__$1);

return statearr_21386;
})();
if(inst_21363){
var statearr_21387_21413 = state_21381__$1;
(statearr_21387_21413[(1)] = (5));

} else {
var statearr_21388_21414 = state_21381__$1;
(statearr_21388_21414[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21382 === (6))){
var state_21381__$1 = state_21381;
var statearr_21389_21415 = state_21381__$1;
(statearr_21389_21415[(2)] = null);

(statearr_21389_21415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21382 === (3))){
var inst_21378 = (state_21381[(2)]);
var inst_21379 = cljs.core.async.close_BANG_.call(null,out);
var state_21381__$1 = (function (){var statearr_21390 = state_21381;
(statearr_21390[(9)] = inst_21378);

return statearr_21390;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21381__$1,inst_21379);
} else {
if((state_val_21382 === (2))){
var state_21381__$1 = state_21381;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21381__$1,(4),ch);
} else {
if((state_val_21382 === (11))){
var inst_21361 = (state_21381[(8)]);
var inst_21370 = (state_21381[(2)]);
var inst_21358 = inst_21361;
var state_21381__$1 = (function (){var statearr_21391 = state_21381;
(statearr_21391[(7)] = inst_21358);

(statearr_21391[(10)] = inst_21370);

return statearr_21391;
})();
var statearr_21392_21416 = state_21381__$1;
(statearr_21392_21416[(2)] = null);

(statearr_21392_21416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21382 === (9))){
var inst_21361 = (state_21381[(8)]);
var state_21381__$1 = state_21381;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21381__$1,(11),out,inst_21361);
} else {
if((state_val_21382 === (5))){
var inst_21358 = (state_21381[(7)]);
var inst_21361 = (state_21381[(8)]);
var inst_21365 = cljs.core._EQ_.call(null,inst_21361,inst_21358);
var state_21381__$1 = state_21381;
if(inst_21365){
var statearr_21394_21417 = state_21381__$1;
(statearr_21394_21417[(1)] = (8));

} else {
var statearr_21395_21418 = state_21381__$1;
(statearr_21395_21418[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21382 === (10))){
var inst_21373 = (state_21381[(2)]);
var state_21381__$1 = state_21381;
var statearr_21396_21419 = state_21381__$1;
(statearr_21396_21419[(2)] = inst_21373);

(statearr_21396_21419[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21382 === (8))){
var inst_21358 = (state_21381[(7)]);
var tmp21393 = inst_21358;
var inst_21358__$1 = tmp21393;
var state_21381__$1 = (function (){var statearr_21397 = state_21381;
(statearr_21397[(7)] = inst_21358__$1);

return statearr_21397;
})();
var statearr_21398_21420 = state_21381__$1;
(statearr_21398_21420[(2)] = null);

(statearr_21398_21420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___21410,out))
;
return ((function (switch__10932__auto__,c__11044__auto___21410,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_21402 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21402[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_21402[(1)] = (1));

return statearr_21402;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_21381){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_21381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e21403){if((e21403 instanceof Object)){
var ex__10936__auto__ = e21403;
var statearr_21404_21421 = state_21381;
(statearr_21404_21421[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21381);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21403;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21422 = state_21381;
state_21381 = G__21422;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_21381){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_21381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___21410,out))
})();
var state__11046__auto__ = (function (){var statearr_21405 = f__11045__auto__.call(null);
(statearr_21405[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___21410);

return statearr_21405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___21410,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args21423 = [];
var len__5726__auto___21493 = arguments.length;
var i__5727__auto___21494 = (0);
while(true){
if((i__5727__auto___21494 < len__5726__auto___21493)){
args21423.push((arguments[i__5727__auto___21494]));

var G__21495 = (i__5727__auto___21494 + (1));
i__5727__auto___21494 = G__21495;
continue;
} else {
}
break;
}

var G__21425 = args21423.length;
switch (G__21425) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21423.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___21497 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___21497,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___21497,out){
return (function (state_21463){
var state_val_21464 = (state_21463[(1)]);
if((state_val_21464 === (7))){
var inst_21459 = (state_21463[(2)]);
var state_21463__$1 = state_21463;
var statearr_21465_21498 = state_21463__$1;
(statearr_21465_21498[(2)] = inst_21459);

(statearr_21465_21498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (1))){
var inst_21426 = (new Array(n));
var inst_21427 = inst_21426;
var inst_21428 = (0);
var state_21463__$1 = (function (){var statearr_21466 = state_21463;
(statearr_21466[(7)] = inst_21428);

(statearr_21466[(8)] = inst_21427);

return statearr_21466;
})();
var statearr_21467_21499 = state_21463__$1;
(statearr_21467_21499[(2)] = null);

(statearr_21467_21499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (4))){
var inst_21431 = (state_21463[(9)]);
var inst_21431__$1 = (state_21463[(2)]);
var inst_21432 = (inst_21431__$1 == null);
var inst_21433 = cljs.core.not.call(null,inst_21432);
var state_21463__$1 = (function (){var statearr_21468 = state_21463;
(statearr_21468[(9)] = inst_21431__$1);

return statearr_21468;
})();
if(inst_21433){
var statearr_21469_21500 = state_21463__$1;
(statearr_21469_21500[(1)] = (5));

} else {
var statearr_21470_21501 = state_21463__$1;
(statearr_21470_21501[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (15))){
var inst_21453 = (state_21463[(2)]);
var state_21463__$1 = state_21463;
var statearr_21471_21502 = state_21463__$1;
(statearr_21471_21502[(2)] = inst_21453);

(statearr_21471_21502[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (13))){
var state_21463__$1 = state_21463;
var statearr_21472_21503 = state_21463__$1;
(statearr_21472_21503[(2)] = null);

(statearr_21472_21503[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (6))){
var inst_21428 = (state_21463[(7)]);
var inst_21449 = (inst_21428 > (0));
var state_21463__$1 = state_21463;
if(cljs.core.truth_(inst_21449)){
var statearr_21473_21504 = state_21463__$1;
(statearr_21473_21504[(1)] = (12));

} else {
var statearr_21474_21505 = state_21463__$1;
(statearr_21474_21505[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (3))){
var inst_21461 = (state_21463[(2)]);
var state_21463__$1 = state_21463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21463__$1,inst_21461);
} else {
if((state_val_21464 === (12))){
var inst_21427 = (state_21463[(8)]);
var inst_21451 = cljs.core.vec.call(null,inst_21427);
var state_21463__$1 = state_21463;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21463__$1,(15),out,inst_21451);
} else {
if((state_val_21464 === (2))){
var state_21463__$1 = state_21463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21463__$1,(4),ch);
} else {
if((state_val_21464 === (11))){
var inst_21443 = (state_21463[(2)]);
var inst_21444 = (new Array(n));
var inst_21427 = inst_21444;
var inst_21428 = (0);
var state_21463__$1 = (function (){var statearr_21475 = state_21463;
(statearr_21475[(10)] = inst_21443);

(statearr_21475[(7)] = inst_21428);

(statearr_21475[(8)] = inst_21427);

return statearr_21475;
})();
var statearr_21476_21506 = state_21463__$1;
(statearr_21476_21506[(2)] = null);

(statearr_21476_21506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (9))){
var inst_21427 = (state_21463[(8)]);
var inst_21441 = cljs.core.vec.call(null,inst_21427);
var state_21463__$1 = state_21463;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21463__$1,(11),out,inst_21441);
} else {
if((state_val_21464 === (5))){
var inst_21431 = (state_21463[(9)]);
var inst_21436 = (state_21463[(11)]);
var inst_21428 = (state_21463[(7)]);
var inst_21427 = (state_21463[(8)]);
var inst_21435 = (inst_21427[inst_21428] = inst_21431);
var inst_21436__$1 = (inst_21428 + (1));
var inst_21437 = (inst_21436__$1 < n);
var state_21463__$1 = (function (){var statearr_21477 = state_21463;
(statearr_21477[(11)] = inst_21436__$1);

(statearr_21477[(12)] = inst_21435);

return statearr_21477;
})();
if(cljs.core.truth_(inst_21437)){
var statearr_21478_21507 = state_21463__$1;
(statearr_21478_21507[(1)] = (8));

} else {
var statearr_21479_21508 = state_21463__$1;
(statearr_21479_21508[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (14))){
var inst_21456 = (state_21463[(2)]);
var inst_21457 = cljs.core.async.close_BANG_.call(null,out);
var state_21463__$1 = (function (){var statearr_21481 = state_21463;
(statearr_21481[(13)] = inst_21456);

return statearr_21481;
})();
var statearr_21482_21509 = state_21463__$1;
(statearr_21482_21509[(2)] = inst_21457);

(statearr_21482_21509[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (10))){
var inst_21447 = (state_21463[(2)]);
var state_21463__$1 = state_21463;
var statearr_21483_21510 = state_21463__$1;
(statearr_21483_21510[(2)] = inst_21447);

(statearr_21483_21510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21464 === (8))){
var inst_21436 = (state_21463[(11)]);
var inst_21427 = (state_21463[(8)]);
var tmp21480 = inst_21427;
var inst_21427__$1 = tmp21480;
var inst_21428 = inst_21436;
var state_21463__$1 = (function (){var statearr_21484 = state_21463;
(statearr_21484[(7)] = inst_21428);

(statearr_21484[(8)] = inst_21427__$1);

return statearr_21484;
})();
var statearr_21485_21511 = state_21463__$1;
(statearr_21485_21511[(2)] = null);

(statearr_21485_21511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___21497,out))
;
return ((function (switch__10932__auto__,c__11044__auto___21497,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_21489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21489[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_21489[(1)] = (1));

return statearr_21489;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_21463){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_21463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e21490){if((e21490 instanceof Object)){
var ex__10936__auto__ = e21490;
var statearr_21491_21512 = state_21463;
(statearr_21491_21512[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21490;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21513 = state_21463;
state_21463 = G__21513;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_21463){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_21463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___21497,out))
})();
var state__11046__auto__ = (function (){var statearr_21492 = f__11045__auto__.call(null);
(statearr_21492[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___21497);

return statearr_21492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___21497,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21514 = [];
var len__5726__auto___21588 = arguments.length;
var i__5727__auto___21589 = (0);
while(true){
if((i__5727__auto___21589 < len__5726__auto___21588)){
args21514.push((arguments[i__5727__auto___21589]));

var G__21590 = (i__5727__auto___21589 + (1));
i__5727__auto___21589 = G__21590;
continue;
} else {
}
break;
}

var G__21516 = args21514.length;
switch (G__21516) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21514.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___21592 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___21592,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___21592,out){
return (function (state_21558){
var state_val_21559 = (state_21558[(1)]);
if((state_val_21559 === (7))){
var inst_21554 = (state_21558[(2)]);
var state_21558__$1 = state_21558;
var statearr_21560_21593 = state_21558__$1;
(statearr_21560_21593[(2)] = inst_21554);

(statearr_21560_21593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (1))){
var inst_21517 = [];
var inst_21518 = inst_21517;
var inst_21519 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21558__$1 = (function (){var statearr_21561 = state_21558;
(statearr_21561[(7)] = inst_21519);

(statearr_21561[(8)] = inst_21518);

return statearr_21561;
})();
var statearr_21562_21594 = state_21558__$1;
(statearr_21562_21594[(2)] = null);

(statearr_21562_21594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (4))){
var inst_21522 = (state_21558[(9)]);
var inst_21522__$1 = (state_21558[(2)]);
var inst_21523 = (inst_21522__$1 == null);
var inst_21524 = cljs.core.not.call(null,inst_21523);
var state_21558__$1 = (function (){var statearr_21563 = state_21558;
(statearr_21563[(9)] = inst_21522__$1);

return statearr_21563;
})();
if(inst_21524){
var statearr_21564_21595 = state_21558__$1;
(statearr_21564_21595[(1)] = (5));

} else {
var statearr_21565_21596 = state_21558__$1;
(statearr_21565_21596[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (15))){
var inst_21548 = (state_21558[(2)]);
var state_21558__$1 = state_21558;
var statearr_21566_21597 = state_21558__$1;
(statearr_21566_21597[(2)] = inst_21548);

(statearr_21566_21597[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (13))){
var state_21558__$1 = state_21558;
var statearr_21567_21598 = state_21558__$1;
(statearr_21567_21598[(2)] = null);

(statearr_21567_21598[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (6))){
var inst_21518 = (state_21558[(8)]);
var inst_21543 = inst_21518.length;
var inst_21544 = (inst_21543 > (0));
var state_21558__$1 = state_21558;
if(cljs.core.truth_(inst_21544)){
var statearr_21568_21599 = state_21558__$1;
(statearr_21568_21599[(1)] = (12));

} else {
var statearr_21569_21600 = state_21558__$1;
(statearr_21569_21600[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (3))){
var inst_21556 = (state_21558[(2)]);
var state_21558__$1 = state_21558;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21558__$1,inst_21556);
} else {
if((state_val_21559 === (12))){
var inst_21518 = (state_21558[(8)]);
var inst_21546 = cljs.core.vec.call(null,inst_21518);
var state_21558__$1 = state_21558;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21558__$1,(15),out,inst_21546);
} else {
if((state_val_21559 === (2))){
var state_21558__$1 = state_21558;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21558__$1,(4),ch);
} else {
if((state_val_21559 === (11))){
var inst_21522 = (state_21558[(9)]);
var inst_21526 = (state_21558[(10)]);
var inst_21536 = (state_21558[(2)]);
var inst_21537 = [];
var inst_21538 = inst_21537.push(inst_21522);
var inst_21518 = inst_21537;
var inst_21519 = inst_21526;
var state_21558__$1 = (function (){var statearr_21570 = state_21558;
(statearr_21570[(11)] = inst_21538);

(statearr_21570[(12)] = inst_21536);

(statearr_21570[(7)] = inst_21519);

(statearr_21570[(8)] = inst_21518);

return statearr_21570;
})();
var statearr_21571_21601 = state_21558__$1;
(statearr_21571_21601[(2)] = null);

(statearr_21571_21601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (9))){
var inst_21518 = (state_21558[(8)]);
var inst_21534 = cljs.core.vec.call(null,inst_21518);
var state_21558__$1 = state_21558;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21558__$1,(11),out,inst_21534);
} else {
if((state_val_21559 === (5))){
var inst_21519 = (state_21558[(7)]);
var inst_21522 = (state_21558[(9)]);
var inst_21526 = (state_21558[(10)]);
var inst_21526__$1 = f.call(null,inst_21522);
var inst_21527 = cljs.core._EQ_.call(null,inst_21526__$1,inst_21519);
var inst_21528 = cljs.core.keyword_identical_QMARK_.call(null,inst_21519,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21529 = (inst_21527) || (inst_21528);
var state_21558__$1 = (function (){var statearr_21572 = state_21558;
(statearr_21572[(10)] = inst_21526__$1);

return statearr_21572;
})();
if(cljs.core.truth_(inst_21529)){
var statearr_21573_21602 = state_21558__$1;
(statearr_21573_21602[(1)] = (8));

} else {
var statearr_21574_21603 = state_21558__$1;
(statearr_21574_21603[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (14))){
var inst_21551 = (state_21558[(2)]);
var inst_21552 = cljs.core.async.close_BANG_.call(null,out);
var state_21558__$1 = (function (){var statearr_21576 = state_21558;
(statearr_21576[(13)] = inst_21551);

return statearr_21576;
})();
var statearr_21577_21604 = state_21558__$1;
(statearr_21577_21604[(2)] = inst_21552);

(statearr_21577_21604[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (10))){
var inst_21541 = (state_21558[(2)]);
var state_21558__$1 = state_21558;
var statearr_21578_21605 = state_21558__$1;
(statearr_21578_21605[(2)] = inst_21541);

(statearr_21578_21605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21559 === (8))){
var inst_21522 = (state_21558[(9)]);
var inst_21518 = (state_21558[(8)]);
var inst_21526 = (state_21558[(10)]);
var inst_21531 = inst_21518.push(inst_21522);
var tmp21575 = inst_21518;
var inst_21518__$1 = tmp21575;
var inst_21519 = inst_21526;
var state_21558__$1 = (function (){var statearr_21579 = state_21558;
(statearr_21579[(14)] = inst_21531);

(statearr_21579[(7)] = inst_21519);

(statearr_21579[(8)] = inst_21518__$1);

return statearr_21579;
})();
var statearr_21580_21606 = state_21558__$1;
(statearr_21580_21606[(2)] = null);

(statearr_21580_21606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___21592,out))
;
return ((function (switch__10932__auto__,c__11044__auto___21592,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_21584 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21584[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_21584[(1)] = (1));

return statearr_21584;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_21558){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_21558);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e21585){if((e21585 instanceof Object)){
var ex__10936__auto__ = e21585;
var statearr_21586_21607 = state_21558;
(statearr_21586_21607[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21558);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21585;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21608 = state_21558;
state_21558 = G__21608;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_21558){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_21558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___21592,out))
})();
var state__11046__auto__ = (function (){var statearr_21587 = f__11045__auto__.call(null);
(statearr_21587[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___21592);

return statearr_21587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___21592,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1453923759850