// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11089 = [];
var len__5726__auto___11095 = arguments.length;
var i__5727__auto___11096 = (0);
while(true){
if((i__5727__auto___11096 < len__5726__auto___11095)){
args11089.push((arguments[i__5727__auto___11096]));

var G__11097 = (i__5727__auto___11096 + (1));
i__5727__auto___11096 = G__11097;
continue;
} else {
}
break;
}

var G__11091 = args11089.length;
switch (G__11091) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11089.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11092 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11092 = (function (f,blockable,meta11093){
this.f = f;
this.blockable = blockable;
this.meta11093 = meta11093;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11092.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11094,meta11093__$1){
var self__ = this;
var _11094__$1 = this;
return (new cljs.core.async.t_cljs$core$async11092(self__.f,self__.blockable,meta11093__$1));
});

cljs.core.async.t_cljs$core$async11092.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11094){
var self__ = this;
var _11094__$1 = this;
return self__.meta11093;
});

cljs.core.async.t_cljs$core$async11092.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11092.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11092.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11092.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11092.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11093","meta11093",549850155,null)], null);
});

cljs.core.async.t_cljs$core$async11092.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11092.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11092";

cljs.core.async.t_cljs$core$async11092.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11092");
});

cljs.core.async.__GT_t_cljs$core$async11092 = (function cljs$core$async$__GT_t_cljs$core$async11092(f__$1,blockable__$1,meta11093){
return (new cljs.core.async.t_cljs$core$async11092(f__$1,blockable__$1,meta11093));
});

}

return (new cljs.core.async.t_cljs$core$async11092(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11101 = [];
var len__5726__auto___11104 = arguments.length;
var i__5727__auto___11105 = (0);
while(true){
if((i__5727__auto___11105 < len__5726__auto___11104)){
args11101.push((arguments[i__5727__auto___11105]));

var G__11106 = (i__5727__auto___11105 + (1));
i__5727__auto___11105 = G__11106;
continue;
} else {
}
break;
}

var G__11103 = args11101.length;
switch (G__11103) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11101.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11108 = [];
var len__5726__auto___11111 = arguments.length;
var i__5727__auto___11112 = (0);
while(true){
if((i__5727__auto___11112 < len__5726__auto___11111)){
args11108.push((arguments[i__5727__auto___11112]));

var G__11113 = (i__5727__auto___11112 + (1));
i__5727__auto___11112 = G__11113;
continue;
} else {
}
break;
}

var G__11110 = args11108.length;
switch (G__11110) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11108.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11115 = [];
var len__5726__auto___11118 = arguments.length;
var i__5727__auto___11119 = (0);
while(true){
if((i__5727__auto___11119 < len__5726__auto___11118)){
args11115.push((arguments[i__5727__auto___11119]));

var G__11120 = (i__5727__auto___11119 + (1));
i__5727__auto___11119 = G__11120;
continue;
} else {
}
break;
}

var G__11117 = args11115.length;
switch (G__11117) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11115.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11122 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11122);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11122,ret){
return (function (){
return fn1.call(null,val_11122);
});})(val_11122,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11123 = [];
var len__5726__auto___11126 = arguments.length;
var i__5727__auto___11127 = (0);
while(true){
if((i__5727__auto___11127 < len__5726__auto___11126)){
args11123.push((arguments[i__5727__auto___11127]));

var G__11128 = (i__5727__auto___11127 + (1));
i__5727__auto___11127 = G__11128;
continue;
} else {
}
break;
}

var G__11125 = args11123.length;
switch (G__11125) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11123.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___11130 = n;
var x_11131 = (0);
while(true){
if((x_11131 < n__5571__auto___11130)){
(a[x_11131] = (0));

var G__11132 = (x_11131 + (1));
x_11131 = G__11132;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11133 = (i + (1));
i = G__11133;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11137 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11137 = (function (alt_flag,flag,meta11138){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta11138 = meta11138;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11139,meta11138__$1){
var self__ = this;
var _11139__$1 = this;
return (new cljs.core.async.t_cljs$core$async11137(self__.alt_flag,self__.flag,meta11138__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11139){
var self__ = this;
var _11139__$1 = this;
return self__.meta11138;
});})(flag))
;

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11137.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11137.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11138","meta11138",-580293278,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11137.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11137.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11137";

cljs.core.async.t_cljs$core$async11137.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11137");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11137 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11137(alt_flag__$1,flag__$1,meta11138){
return (new cljs.core.async.t_cljs$core$async11137(alt_flag__$1,flag__$1,meta11138));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11137(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11143 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11143 = (function (alt_handler,flag,cb,meta11144){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta11144 = meta11144;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11143.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11145,meta11144__$1){
var self__ = this;
var _11145__$1 = this;
return (new cljs.core.async.t_cljs$core$async11143(self__.alt_handler,self__.flag,self__.cb,meta11144__$1));
});

cljs.core.async.t_cljs$core$async11143.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11145){
var self__ = this;
var _11145__$1 = this;
return self__.meta11144;
});

cljs.core.async.t_cljs$core$async11143.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async11143.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11143.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11143.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11143.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11144","meta11144",1910068201,null)], null);
});

cljs.core.async.t_cljs$core$async11143.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11143.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11143";

cljs.core.async.t_cljs$core$async11143.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async11143");
});

cljs.core.async.__GT_t_cljs$core$async11143 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11143(alt_handler__$1,flag__$1,cb__$1,meta11144){
return (new cljs.core.async.t_cljs$core$async11143(alt_handler__$1,flag__$1,cb__$1,meta11144));
});

}

return (new cljs.core.async.t_cljs$core$async11143(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11146_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11146_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11147_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11147_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11148 = (i + (1));
i = G__11148;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___11154 = arguments.length;
var i__5727__auto___11155 = (0);
while(true){
if((i__5727__auto___11155 < len__5726__auto___11154)){
args__5733__auto__.push((arguments[i__5727__auto___11155]));

var G__11156 = (i__5727__auto___11155 + (1));
i__5727__auto___11155 = G__11156;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11151){
var map__11152 = p__11151;
var map__11152__$1 = ((((!((map__11152 == null)))?((((map__11152.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11152.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11152):map__11152);
var opts = map__11152__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11149){
var G__11150 = cljs.core.first.call(null,seq11149);
var seq11149__$1 = cljs.core.next.call(null,seq11149);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11150,seq11149__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11157 = [];
var len__5726__auto___11207 = arguments.length;
var i__5727__auto___11208 = (0);
while(true){
if((i__5727__auto___11208 < len__5726__auto___11207)){
args11157.push((arguments[i__5727__auto___11208]));

var G__11209 = (i__5727__auto___11208 + (1));
i__5727__auto___11208 = G__11209;
continue;
} else {
}
break;
}

var G__11159 = args11157.length;
switch (G__11159) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11157.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11044__auto___11211 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___11211){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___11211){
return (function (state_11183){
var state_val_11184 = (state_11183[(1)]);
if((state_val_11184 === (7))){
var inst_11179 = (state_11183[(2)]);
var state_11183__$1 = state_11183;
var statearr_11185_11212 = state_11183__$1;
(statearr_11185_11212[(2)] = inst_11179);

(statearr_11185_11212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (1))){
var state_11183__$1 = state_11183;
var statearr_11186_11213 = state_11183__$1;
(statearr_11186_11213[(2)] = null);

(statearr_11186_11213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (4))){
var inst_11162 = (state_11183[(7)]);
var inst_11162__$1 = (state_11183[(2)]);
var inst_11163 = (inst_11162__$1 == null);
var state_11183__$1 = (function (){var statearr_11187 = state_11183;
(statearr_11187[(7)] = inst_11162__$1);

return statearr_11187;
})();
if(cljs.core.truth_(inst_11163)){
var statearr_11188_11214 = state_11183__$1;
(statearr_11188_11214[(1)] = (5));

} else {
var statearr_11189_11215 = state_11183__$1;
(statearr_11189_11215[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (13))){
var state_11183__$1 = state_11183;
var statearr_11190_11216 = state_11183__$1;
(statearr_11190_11216[(2)] = null);

(statearr_11190_11216[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (6))){
var inst_11162 = (state_11183[(7)]);
var state_11183__$1 = state_11183;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11183__$1,(11),to,inst_11162);
} else {
if((state_val_11184 === (3))){
var inst_11181 = (state_11183[(2)]);
var state_11183__$1 = state_11183;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11183__$1,inst_11181);
} else {
if((state_val_11184 === (12))){
var state_11183__$1 = state_11183;
var statearr_11191_11217 = state_11183__$1;
(statearr_11191_11217[(2)] = null);

(statearr_11191_11217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (2))){
var state_11183__$1 = state_11183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11183__$1,(4),from);
} else {
if((state_val_11184 === (11))){
var inst_11172 = (state_11183[(2)]);
var state_11183__$1 = state_11183;
if(cljs.core.truth_(inst_11172)){
var statearr_11192_11218 = state_11183__$1;
(statearr_11192_11218[(1)] = (12));

} else {
var statearr_11193_11219 = state_11183__$1;
(statearr_11193_11219[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (9))){
var state_11183__$1 = state_11183;
var statearr_11194_11220 = state_11183__$1;
(statearr_11194_11220[(2)] = null);

(statearr_11194_11220[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (5))){
var state_11183__$1 = state_11183;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11195_11221 = state_11183__$1;
(statearr_11195_11221[(1)] = (8));

} else {
var statearr_11196_11222 = state_11183__$1;
(statearr_11196_11222[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (14))){
var inst_11177 = (state_11183[(2)]);
var state_11183__$1 = state_11183;
var statearr_11197_11223 = state_11183__$1;
(statearr_11197_11223[(2)] = inst_11177);

(statearr_11197_11223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (10))){
var inst_11169 = (state_11183[(2)]);
var state_11183__$1 = state_11183;
var statearr_11198_11224 = state_11183__$1;
(statearr_11198_11224[(2)] = inst_11169);

(statearr_11198_11224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11184 === (8))){
var inst_11166 = cljs.core.async.close_BANG_.call(null,to);
var state_11183__$1 = state_11183;
var statearr_11199_11225 = state_11183__$1;
(statearr_11199_11225[(2)] = inst_11166);

(statearr_11199_11225[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___11211))
;
return ((function (switch__10932__auto__,c__11044__auto___11211){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_11203 = [null,null,null,null,null,null,null,null];
(statearr_11203[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_11203[(1)] = (1));

return statearr_11203;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_11183){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11183);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11204){if((e11204 instanceof Object)){
var ex__10936__auto__ = e11204;
var statearr_11205_11226 = state_11183;
(statearr_11205_11226[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11183);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11204;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11227 = state_11183;
state_11183 = G__11227;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_11183){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_11183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___11211))
})();
var state__11046__auto__ = (function (){var statearr_11206 = f__11045__auto__.call(null);
(statearr_11206[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___11211);

return statearr_11206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___11211))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11411){
var vec__11412 = p__11411;
var v = cljs.core.nth.call(null,vec__11412,(0),null);
var p = cljs.core.nth.call(null,vec__11412,(1),null);
var job = vec__11412;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11044__auto___11594 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___11594,res,vec__11412,v,p,job,jobs,results){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___11594,res,vec__11412,v,p,job,jobs,results){
return (function (state_11417){
var state_val_11418 = (state_11417[(1)]);
if((state_val_11418 === (1))){
var state_11417__$1 = state_11417;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11417__$1,(2),res,v);
} else {
if((state_val_11418 === (2))){
var inst_11414 = (state_11417[(2)]);
var inst_11415 = cljs.core.async.close_BANG_.call(null,res);
var state_11417__$1 = (function (){var statearr_11419 = state_11417;
(statearr_11419[(7)] = inst_11414);

return statearr_11419;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11417__$1,inst_11415);
} else {
return null;
}
}
});})(c__11044__auto___11594,res,vec__11412,v,p,job,jobs,results))
;
return ((function (switch__10932__auto__,c__11044__auto___11594,res,vec__11412,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_11423 = [null,null,null,null,null,null,null,null];
(statearr_11423[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_11423[(1)] = (1));

return statearr_11423;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_11417){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11424){if((e11424 instanceof Object)){
var ex__10936__auto__ = e11424;
var statearr_11425_11595 = state_11417;
(statearr_11425_11595[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11417);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11424;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11596 = state_11417;
state_11417 = G__11596;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_11417){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_11417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___11594,res,vec__11412,v,p,job,jobs,results))
})();
var state__11046__auto__ = (function (){var statearr_11426 = f__11045__auto__.call(null);
(statearr_11426[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___11594);

return statearr_11426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___11594,res,vec__11412,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11427){
var vec__11428 = p__11427;
var v = cljs.core.nth.call(null,vec__11428,(0),null);
var p = cljs.core.nth.call(null,vec__11428,(1),null);
var job = vec__11428;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___11597 = n;
var __11598 = (0);
while(true){
if((__11598 < n__5571__auto___11597)){
var G__11429_11599 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__11429_11599) {
case "compute":
var c__11044__auto___11601 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11598,c__11044__auto___11601,G__11429_11599,n__5571__auto___11597,jobs,results,process,async){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (__11598,c__11044__auto___11601,G__11429_11599,n__5571__auto___11597,jobs,results,process,async){
return (function (state_11442){
var state_val_11443 = (state_11442[(1)]);
if((state_val_11443 === (1))){
var state_11442__$1 = state_11442;
var statearr_11444_11602 = state_11442__$1;
(statearr_11444_11602[(2)] = null);

(statearr_11444_11602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11443 === (2))){
var state_11442__$1 = state_11442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11442__$1,(4),jobs);
} else {
if((state_val_11443 === (3))){
var inst_11440 = (state_11442[(2)]);
var state_11442__$1 = state_11442;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11442__$1,inst_11440);
} else {
if((state_val_11443 === (4))){
var inst_11432 = (state_11442[(2)]);
var inst_11433 = process.call(null,inst_11432);
var state_11442__$1 = state_11442;
if(cljs.core.truth_(inst_11433)){
var statearr_11445_11603 = state_11442__$1;
(statearr_11445_11603[(1)] = (5));

} else {
var statearr_11446_11604 = state_11442__$1;
(statearr_11446_11604[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11443 === (5))){
var state_11442__$1 = state_11442;
var statearr_11447_11605 = state_11442__$1;
(statearr_11447_11605[(2)] = null);

(statearr_11447_11605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11443 === (6))){
var state_11442__$1 = state_11442;
var statearr_11448_11606 = state_11442__$1;
(statearr_11448_11606[(2)] = null);

(statearr_11448_11606[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11443 === (7))){
var inst_11438 = (state_11442[(2)]);
var state_11442__$1 = state_11442;
var statearr_11449_11607 = state_11442__$1;
(statearr_11449_11607[(2)] = inst_11438);

(statearr_11449_11607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11598,c__11044__auto___11601,G__11429_11599,n__5571__auto___11597,jobs,results,process,async))
;
return ((function (__11598,switch__10932__auto__,c__11044__auto___11601,G__11429_11599,n__5571__auto___11597,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_11453 = [null,null,null,null,null,null,null];
(statearr_11453[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_11453[(1)] = (1));

return statearr_11453;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_11442){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11454){if((e11454 instanceof Object)){
var ex__10936__auto__ = e11454;
var statearr_11455_11608 = state_11442;
(statearr_11455_11608[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11442);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11454;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11609 = state_11442;
state_11442 = G__11609;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_11442){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_11442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(__11598,switch__10932__auto__,c__11044__auto___11601,G__11429_11599,n__5571__auto___11597,jobs,results,process,async))
})();
var state__11046__auto__ = (function (){var statearr_11456 = f__11045__auto__.call(null);
(statearr_11456[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___11601);

return statearr_11456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(__11598,c__11044__auto___11601,G__11429_11599,n__5571__auto___11597,jobs,results,process,async))
);


break;
case "async":
var c__11044__auto___11610 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11598,c__11044__auto___11610,G__11429_11599,n__5571__auto___11597,jobs,results,process,async){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (__11598,c__11044__auto___11610,G__11429_11599,n__5571__auto___11597,jobs,results,process,async){
return (function (state_11469){
var state_val_11470 = (state_11469[(1)]);
if((state_val_11470 === (1))){
var state_11469__$1 = state_11469;
var statearr_11471_11611 = state_11469__$1;
(statearr_11471_11611[(2)] = null);

(statearr_11471_11611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11470 === (2))){
var state_11469__$1 = state_11469;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11469__$1,(4),jobs);
} else {
if((state_val_11470 === (3))){
var inst_11467 = (state_11469[(2)]);
var state_11469__$1 = state_11469;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11469__$1,inst_11467);
} else {
if((state_val_11470 === (4))){
var inst_11459 = (state_11469[(2)]);
var inst_11460 = async.call(null,inst_11459);
var state_11469__$1 = state_11469;
if(cljs.core.truth_(inst_11460)){
var statearr_11472_11612 = state_11469__$1;
(statearr_11472_11612[(1)] = (5));

} else {
var statearr_11473_11613 = state_11469__$1;
(statearr_11473_11613[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11470 === (5))){
var state_11469__$1 = state_11469;
var statearr_11474_11614 = state_11469__$1;
(statearr_11474_11614[(2)] = null);

(statearr_11474_11614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11470 === (6))){
var state_11469__$1 = state_11469;
var statearr_11475_11615 = state_11469__$1;
(statearr_11475_11615[(2)] = null);

(statearr_11475_11615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11470 === (7))){
var inst_11465 = (state_11469[(2)]);
var state_11469__$1 = state_11469;
var statearr_11476_11616 = state_11469__$1;
(statearr_11476_11616[(2)] = inst_11465);

(statearr_11476_11616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11598,c__11044__auto___11610,G__11429_11599,n__5571__auto___11597,jobs,results,process,async))
;
return ((function (__11598,switch__10932__auto__,c__11044__auto___11610,G__11429_11599,n__5571__auto___11597,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_11480 = [null,null,null,null,null,null,null];
(statearr_11480[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_11480[(1)] = (1));

return statearr_11480;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_11469){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11469);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11481){if((e11481 instanceof Object)){
var ex__10936__auto__ = e11481;
var statearr_11482_11617 = state_11469;
(statearr_11482_11617[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11469);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11481;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11618 = state_11469;
state_11469 = G__11618;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_11469){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_11469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(__11598,switch__10932__auto__,c__11044__auto___11610,G__11429_11599,n__5571__auto___11597,jobs,results,process,async))
})();
var state__11046__auto__ = (function (){var statearr_11483 = f__11045__auto__.call(null);
(statearr_11483[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___11610);

return statearr_11483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(__11598,c__11044__auto___11610,G__11429_11599,n__5571__auto___11597,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__11619 = (__11598 + (1));
__11598 = G__11619;
continue;
} else {
}
break;
}

var c__11044__auto___11620 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___11620,jobs,results,process,async){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___11620,jobs,results,process,async){
return (function (state_11505){
var state_val_11506 = (state_11505[(1)]);
if((state_val_11506 === (1))){
var state_11505__$1 = state_11505;
var statearr_11507_11621 = state_11505__$1;
(statearr_11507_11621[(2)] = null);

(statearr_11507_11621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11506 === (2))){
var state_11505__$1 = state_11505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11505__$1,(4),from);
} else {
if((state_val_11506 === (3))){
var inst_11503 = (state_11505[(2)]);
var state_11505__$1 = state_11505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11505__$1,inst_11503);
} else {
if((state_val_11506 === (4))){
var inst_11486 = (state_11505[(7)]);
var inst_11486__$1 = (state_11505[(2)]);
var inst_11487 = (inst_11486__$1 == null);
var state_11505__$1 = (function (){var statearr_11508 = state_11505;
(statearr_11508[(7)] = inst_11486__$1);

return statearr_11508;
})();
if(cljs.core.truth_(inst_11487)){
var statearr_11509_11622 = state_11505__$1;
(statearr_11509_11622[(1)] = (5));

} else {
var statearr_11510_11623 = state_11505__$1;
(statearr_11510_11623[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11506 === (5))){
var inst_11489 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11505__$1 = state_11505;
var statearr_11511_11624 = state_11505__$1;
(statearr_11511_11624[(2)] = inst_11489);

(statearr_11511_11624[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11506 === (6))){
var inst_11491 = (state_11505[(8)]);
var inst_11486 = (state_11505[(7)]);
var inst_11491__$1 = cljs.core.async.chan.call(null,(1));
var inst_11492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11493 = [inst_11486,inst_11491__$1];
var inst_11494 = (new cljs.core.PersistentVector(null,2,(5),inst_11492,inst_11493,null));
var state_11505__$1 = (function (){var statearr_11512 = state_11505;
(statearr_11512[(8)] = inst_11491__$1);

return statearr_11512;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11505__$1,(8),jobs,inst_11494);
} else {
if((state_val_11506 === (7))){
var inst_11501 = (state_11505[(2)]);
var state_11505__$1 = state_11505;
var statearr_11513_11625 = state_11505__$1;
(statearr_11513_11625[(2)] = inst_11501);

(statearr_11513_11625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11506 === (8))){
var inst_11491 = (state_11505[(8)]);
var inst_11496 = (state_11505[(2)]);
var state_11505__$1 = (function (){var statearr_11514 = state_11505;
(statearr_11514[(9)] = inst_11496);

return statearr_11514;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11505__$1,(9),results,inst_11491);
} else {
if((state_val_11506 === (9))){
var inst_11498 = (state_11505[(2)]);
var state_11505__$1 = (function (){var statearr_11515 = state_11505;
(statearr_11515[(10)] = inst_11498);

return statearr_11515;
})();
var statearr_11516_11626 = state_11505__$1;
(statearr_11516_11626[(2)] = null);

(statearr_11516_11626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___11620,jobs,results,process,async))
;
return ((function (switch__10932__auto__,c__11044__auto___11620,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_11520 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11520[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_11520[(1)] = (1));

return statearr_11520;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_11505){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11521){if((e11521 instanceof Object)){
var ex__10936__auto__ = e11521;
var statearr_11522_11627 = state_11505;
(statearr_11522_11627[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11505);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11521;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11628 = state_11505;
state_11505 = G__11628;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_11505){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_11505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___11620,jobs,results,process,async))
})();
var state__11046__auto__ = (function (){var statearr_11523 = f__11045__auto__.call(null);
(statearr_11523[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___11620);

return statearr_11523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___11620,jobs,results,process,async))
);


var c__11044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto__,jobs,results,process,async){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto__,jobs,results,process,async){
return (function (state_11561){
var state_val_11562 = (state_11561[(1)]);
if((state_val_11562 === (7))){
var inst_11557 = (state_11561[(2)]);
var state_11561__$1 = state_11561;
var statearr_11563_11629 = state_11561__$1;
(statearr_11563_11629[(2)] = inst_11557);

(statearr_11563_11629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (20))){
var state_11561__$1 = state_11561;
var statearr_11564_11630 = state_11561__$1;
(statearr_11564_11630[(2)] = null);

(statearr_11564_11630[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (1))){
var state_11561__$1 = state_11561;
var statearr_11565_11631 = state_11561__$1;
(statearr_11565_11631[(2)] = null);

(statearr_11565_11631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (4))){
var inst_11526 = (state_11561[(7)]);
var inst_11526__$1 = (state_11561[(2)]);
var inst_11527 = (inst_11526__$1 == null);
var state_11561__$1 = (function (){var statearr_11566 = state_11561;
(statearr_11566[(7)] = inst_11526__$1);

return statearr_11566;
})();
if(cljs.core.truth_(inst_11527)){
var statearr_11567_11632 = state_11561__$1;
(statearr_11567_11632[(1)] = (5));

} else {
var statearr_11568_11633 = state_11561__$1;
(statearr_11568_11633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (15))){
var inst_11539 = (state_11561[(8)]);
var state_11561__$1 = state_11561;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11561__$1,(18),to,inst_11539);
} else {
if((state_val_11562 === (21))){
var inst_11552 = (state_11561[(2)]);
var state_11561__$1 = state_11561;
var statearr_11569_11634 = state_11561__$1;
(statearr_11569_11634[(2)] = inst_11552);

(statearr_11569_11634[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (13))){
var inst_11554 = (state_11561[(2)]);
var state_11561__$1 = (function (){var statearr_11570 = state_11561;
(statearr_11570[(9)] = inst_11554);

return statearr_11570;
})();
var statearr_11571_11635 = state_11561__$1;
(statearr_11571_11635[(2)] = null);

(statearr_11571_11635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (6))){
var inst_11526 = (state_11561[(7)]);
var state_11561__$1 = state_11561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11561__$1,(11),inst_11526);
} else {
if((state_val_11562 === (17))){
var inst_11547 = (state_11561[(2)]);
var state_11561__$1 = state_11561;
if(cljs.core.truth_(inst_11547)){
var statearr_11572_11636 = state_11561__$1;
(statearr_11572_11636[(1)] = (19));

} else {
var statearr_11573_11637 = state_11561__$1;
(statearr_11573_11637[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (3))){
var inst_11559 = (state_11561[(2)]);
var state_11561__$1 = state_11561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11561__$1,inst_11559);
} else {
if((state_val_11562 === (12))){
var inst_11536 = (state_11561[(10)]);
var state_11561__$1 = state_11561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11561__$1,(14),inst_11536);
} else {
if((state_val_11562 === (2))){
var state_11561__$1 = state_11561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11561__$1,(4),results);
} else {
if((state_val_11562 === (19))){
var state_11561__$1 = state_11561;
var statearr_11574_11638 = state_11561__$1;
(statearr_11574_11638[(2)] = null);

(statearr_11574_11638[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (11))){
var inst_11536 = (state_11561[(2)]);
var state_11561__$1 = (function (){var statearr_11575 = state_11561;
(statearr_11575[(10)] = inst_11536);

return statearr_11575;
})();
var statearr_11576_11639 = state_11561__$1;
(statearr_11576_11639[(2)] = null);

(statearr_11576_11639[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (9))){
var state_11561__$1 = state_11561;
var statearr_11577_11640 = state_11561__$1;
(statearr_11577_11640[(2)] = null);

(statearr_11577_11640[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (5))){
var state_11561__$1 = state_11561;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11578_11641 = state_11561__$1;
(statearr_11578_11641[(1)] = (8));

} else {
var statearr_11579_11642 = state_11561__$1;
(statearr_11579_11642[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (14))){
var inst_11539 = (state_11561[(8)]);
var inst_11541 = (state_11561[(11)]);
var inst_11539__$1 = (state_11561[(2)]);
var inst_11540 = (inst_11539__$1 == null);
var inst_11541__$1 = cljs.core.not.call(null,inst_11540);
var state_11561__$1 = (function (){var statearr_11580 = state_11561;
(statearr_11580[(8)] = inst_11539__$1);

(statearr_11580[(11)] = inst_11541__$1);

return statearr_11580;
})();
if(inst_11541__$1){
var statearr_11581_11643 = state_11561__$1;
(statearr_11581_11643[(1)] = (15));

} else {
var statearr_11582_11644 = state_11561__$1;
(statearr_11582_11644[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (16))){
var inst_11541 = (state_11561[(11)]);
var state_11561__$1 = state_11561;
var statearr_11583_11645 = state_11561__$1;
(statearr_11583_11645[(2)] = inst_11541);

(statearr_11583_11645[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (10))){
var inst_11533 = (state_11561[(2)]);
var state_11561__$1 = state_11561;
var statearr_11584_11646 = state_11561__$1;
(statearr_11584_11646[(2)] = inst_11533);

(statearr_11584_11646[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (18))){
var inst_11544 = (state_11561[(2)]);
var state_11561__$1 = state_11561;
var statearr_11585_11647 = state_11561__$1;
(statearr_11585_11647[(2)] = inst_11544);

(statearr_11585_11647[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11562 === (8))){
var inst_11530 = cljs.core.async.close_BANG_.call(null,to);
var state_11561__$1 = state_11561;
var statearr_11586_11648 = state_11561__$1;
(statearr_11586_11648[(2)] = inst_11530);

(statearr_11586_11648[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto__,jobs,results,process,async))
;
return ((function (switch__10932__auto__,c__11044__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_11590 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11590[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__);

(statearr_11590[(1)] = (1));

return statearr_11590;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1 = (function (state_11561){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11591){if((e11591 instanceof Object)){
var ex__10936__auto__ = e11591;
var statearr_11592_11649 = state_11561;
(statearr_11592_11649[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11561);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11591;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11650 = state_11561;
state_11561 = G__11650;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__ = function(state_11561){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1.call(this,state_11561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto__,jobs,results,process,async))
})();
var state__11046__auto__ = (function (){var statearr_11593 = f__11045__auto__.call(null);
(statearr_11593[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto__);

return statearr_11593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto__,jobs,results,process,async))
);

return c__11044__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11651 = [];
var len__5726__auto___11654 = arguments.length;
var i__5727__auto___11655 = (0);
while(true){
if((i__5727__auto___11655 < len__5726__auto___11654)){
args11651.push((arguments[i__5727__auto___11655]));

var G__11656 = (i__5727__auto___11655 + (1));
i__5727__auto___11655 = G__11656;
continue;
} else {
}
break;
}

var G__11653 = args11651.length;
switch (G__11653) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11651.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11658 = [];
var len__5726__auto___11661 = arguments.length;
var i__5727__auto___11662 = (0);
while(true){
if((i__5727__auto___11662 < len__5726__auto___11661)){
args11658.push((arguments[i__5727__auto___11662]));

var G__11663 = (i__5727__auto___11662 + (1));
i__5727__auto___11662 = G__11663;
continue;
} else {
}
break;
}

var G__11660 = args11658.length;
switch (G__11660) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11658.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11665 = [];
var len__5726__auto___11718 = arguments.length;
var i__5727__auto___11719 = (0);
while(true){
if((i__5727__auto___11719 < len__5726__auto___11718)){
args11665.push((arguments[i__5727__auto___11719]));

var G__11720 = (i__5727__auto___11719 + (1));
i__5727__auto___11719 = G__11720;
continue;
} else {
}
break;
}

var G__11667 = args11665.length;
switch (G__11667) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11665.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11044__auto___11722 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___11722,tc,fc){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___11722,tc,fc){
return (function (state_11693){
var state_val_11694 = (state_11693[(1)]);
if((state_val_11694 === (7))){
var inst_11689 = (state_11693[(2)]);
var state_11693__$1 = state_11693;
var statearr_11695_11723 = state_11693__$1;
(statearr_11695_11723[(2)] = inst_11689);

(statearr_11695_11723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (1))){
var state_11693__$1 = state_11693;
var statearr_11696_11724 = state_11693__$1;
(statearr_11696_11724[(2)] = null);

(statearr_11696_11724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (4))){
var inst_11670 = (state_11693[(7)]);
var inst_11670__$1 = (state_11693[(2)]);
var inst_11671 = (inst_11670__$1 == null);
var state_11693__$1 = (function (){var statearr_11697 = state_11693;
(statearr_11697[(7)] = inst_11670__$1);

return statearr_11697;
})();
if(cljs.core.truth_(inst_11671)){
var statearr_11698_11725 = state_11693__$1;
(statearr_11698_11725[(1)] = (5));

} else {
var statearr_11699_11726 = state_11693__$1;
(statearr_11699_11726[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (13))){
var state_11693__$1 = state_11693;
var statearr_11700_11727 = state_11693__$1;
(statearr_11700_11727[(2)] = null);

(statearr_11700_11727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (6))){
var inst_11670 = (state_11693[(7)]);
var inst_11676 = p.call(null,inst_11670);
var state_11693__$1 = state_11693;
if(cljs.core.truth_(inst_11676)){
var statearr_11701_11728 = state_11693__$1;
(statearr_11701_11728[(1)] = (9));

} else {
var statearr_11702_11729 = state_11693__$1;
(statearr_11702_11729[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (3))){
var inst_11691 = (state_11693[(2)]);
var state_11693__$1 = state_11693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11693__$1,inst_11691);
} else {
if((state_val_11694 === (12))){
var state_11693__$1 = state_11693;
var statearr_11703_11730 = state_11693__$1;
(statearr_11703_11730[(2)] = null);

(statearr_11703_11730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (2))){
var state_11693__$1 = state_11693;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11693__$1,(4),ch);
} else {
if((state_val_11694 === (11))){
var inst_11670 = (state_11693[(7)]);
var inst_11680 = (state_11693[(2)]);
var state_11693__$1 = state_11693;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11693__$1,(8),inst_11680,inst_11670);
} else {
if((state_val_11694 === (9))){
var state_11693__$1 = state_11693;
var statearr_11704_11731 = state_11693__$1;
(statearr_11704_11731[(2)] = tc);

(statearr_11704_11731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (5))){
var inst_11673 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11674 = cljs.core.async.close_BANG_.call(null,fc);
var state_11693__$1 = (function (){var statearr_11705 = state_11693;
(statearr_11705[(8)] = inst_11673);

return statearr_11705;
})();
var statearr_11706_11732 = state_11693__$1;
(statearr_11706_11732[(2)] = inst_11674);

(statearr_11706_11732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (14))){
var inst_11687 = (state_11693[(2)]);
var state_11693__$1 = state_11693;
var statearr_11707_11733 = state_11693__$1;
(statearr_11707_11733[(2)] = inst_11687);

(statearr_11707_11733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (10))){
var state_11693__$1 = state_11693;
var statearr_11708_11734 = state_11693__$1;
(statearr_11708_11734[(2)] = fc);

(statearr_11708_11734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11694 === (8))){
var inst_11682 = (state_11693[(2)]);
var state_11693__$1 = state_11693;
if(cljs.core.truth_(inst_11682)){
var statearr_11709_11735 = state_11693__$1;
(statearr_11709_11735[(1)] = (12));

} else {
var statearr_11710_11736 = state_11693__$1;
(statearr_11710_11736[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___11722,tc,fc))
;
return ((function (switch__10932__auto__,c__11044__auto___11722,tc,fc){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_11714 = [null,null,null,null,null,null,null,null,null];
(statearr_11714[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_11714[(1)] = (1));

return statearr_11714;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_11693){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11715){if((e11715 instanceof Object)){
var ex__10936__auto__ = e11715;
var statearr_11716_11737 = state_11693;
(statearr_11716_11737[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11693);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11715;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11738 = state_11693;
state_11693 = G__11738;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_11693){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_11693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___11722,tc,fc))
})();
var state__11046__auto__ = (function (){var statearr_11717 = f__11045__auto__.call(null);
(statearr_11717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___11722);

return statearr_11717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___11722,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto__){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto__){
return (function (state_11802){
var state_val_11803 = (state_11802[(1)]);
if((state_val_11803 === (7))){
var inst_11798 = (state_11802[(2)]);
var state_11802__$1 = state_11802;
var statearr_11804_11825 = state_11802__$1;
(statearr_11804_11825[(2)] = inst_11798);

(statearr_11804_11825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11803 === (1))){
var inst_11782 = init;
var state_11802__$1 = (function (){var statearr_11805 = state_11802;
(statearr_11805[(7)] = inst_11782);

return statearr_11805;
})();
var statearr_11806_11826 = state_11802__$1;
(statearr_11806_11826[(2)] = null);

(statearr_11806_11826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11803 === (4))){
var inst_11785 = (state_11802[(8)]);
var inst_11785__$1 = (state_11802[(2)]);
var inst_11786 = (inst_11785__$1 == null);
var state_11802__$1 = (function (){var statearr_11807 = state_11802;
(statearr_11807[(8)] = inst_11785__$1);

return statearr_11807;
})();
if(cljs.core.truth_(inst_11786)){
var statearr_11808_11827 = state_11802__$1;
(statearr_11808_11827[(1)] = (5));

} else {
var statearr_11809_11828 = state_11802__$1;
(statearr_11809_11828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11803 === (6))){
var inst_11785 = (state_11802[(8)]);
var inst_11782 = (state_11802[(7)]);
var inst_11789 = (state_11802[(9)]);
var inst_11789__$1 = f.call(null,inst_11782,inst_11785);
var inst_11790 = cljs.core.reduced_QMARK_.call(null,inst_11789__$1);
var state_11802__$1 = (function (){var statearr_11810 = state_11802;
(statearr_11810[(9)] = inst_11789__$1);

return statearr_11810;
})();
if(inst_11790){
var statearr_11811_11829 = state_11802__$1;
(statearr_11811_11829[(1)] = (8));

} else {
var statearr_11812_11830 = state_11802__$1;
(statearr_11812_11830[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11803 === (3))){
var inst_11800 = (state_11802[(2)]);
var state_11802__$1 = state_11802;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11802__$1,inst_11800);
} else {
if((state_val_11803 === (2))){
var state_11802__$1 = state_11802;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11802__$1,(4),ch);
} else {
if((state_val_11803 === (9))){
var inst_11789 = (state_11802[(9)]);
var inst_11782 = inst_11789;
var state_11802__$1 = (function (){var statearr_11813 = state_11802;
(statearr_11813[(7)] = inst_11782);

return statearr_11813;
})();
var statearr_11814_11831 = state_11802__$1;
(statearr_11814_11831[(2)] = null);

(statearr_11814_11831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11803 === (5))){
var inst_11782 = (state_11802[(7)]);
var state_11802__$1 = state_11802;
var statearr_11815_11832 = state_11802__$1;
(statearr_11815_11832[(2)] = inst_11782);

(statearr_11815_11832[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11803 === (10))){
var inst_11796 = (state_11802[(2)]);
var state_11802__$1 = state_11802;
var statearr_11816_11833 = state_11802__$1;
(statearr_11816_11833[(2)] = inst_11796);

(statearr_11816_11833[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11803 === (8))){
var inst_11789 = (state_11802[(9)]);
var inst_11792 = cljs.core.deref.call(null,inst_11789);
var state_11802__$1 = state_11802;
var statearr_11817_11834 = state_11802__$1;
(statearr_11817_11834[(2)] = inst_11792);

(statearr_11817_11834[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto__))
;
return ((function (switch__10932__auto__,c__11044__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10933__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10933__auto____0 = (function (){
var statearr_11821 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11821[(0)] = cljs$core$async$reduce_$_state_machine__10933__auto__);

(statearr_11821[(1)] = (1));

return statearr_11821;
});
var cljs$core$async$reduce_$_state_machine__10933__auto____1 = (function (state_11802){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11802);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11822){if((e11822 instanceof Object)){
var ex__10936__auto__ = e11822;
var statearr_11823_11835 = state_11802;
(statearr_11823_11835[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11802);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11836 = state_11802;
state_11802 = G__11836;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10933__auto__ = function(state_11802){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10933__auto____1.call(this,state_11802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10933__auto____0;
cljs$core$async$reduce_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10933__auto____1;
return cljs$core$async$reduce_$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto__))
})();
var state__11046__auto__ = (function (){var statearr_11824 = f__11045__auto__.call(null);
(statearr_11824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto__);

return statearr_11824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto__))
);

return c__11044__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11837 = [];
var len__5726__auto___11889 = arguments.length;
var i__5727__auto___11890 = (0);
while(true){
if((i__5727__auto___11890 < len__5726__auto___11889)){
args11837.push((arguments[i__5727__auto___11890]));

var G__11891 = (i__5727__auto___11890 + (1));
i__5727__auto___11890 = G__11891;
continue;
} else {
}
break;
}

var G__11839 = args11837.length;
switch (G__11839) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11837.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto__){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto__){
return (function (state_11864){
var state_val_11865 = (state_11864[(1)]);
if((state_val_11865 === (7))){
var inst_11846 = (state_11864[(2)]);
var state_11864__$1 = state_11864;
var statearr_11866_11893 = state_11864__$1;
(statearr_11866_11893[(2)] = inst_11846);

(statearr_11866_11893[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (1))){
var inst_11840 = cljs.core.seq.call(null,coll);
var inst_11841 = inst_11840;
var state_11864__$1 = (function (){var statearr_11867 = state_11864;
(statearr_11867[(7)] = inst_11841);

return statearr_11867;
})();
var statearr_11868_11894 = state_11864__$1;
(statearr_11868_11894[(2)] = null);

(statearr_11868_11894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (4))){
var inst_11841 = (state_11864[(7)]);
var inst_11844 = cljs.core.first.call(null,inst_11841);
var state_11864__$1 = state_11864;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11864__$1,(7),ch,inst_11844);
} else {
if((state_val_11865 === (13))){
var inst_11858 = (state_11864[(2)]);
var state_11864__$1 = state_11864;
var statearr_11869_11895 = state_11864__$1;
(statearr_11869_11895[(2)] = inst_11858);

(statearr_11869_11895[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (6))){
var inst_11849 = (state_11864[(2)]);
var state_11864__$1 = state_11864;
if(cljs.core.truth_(inst_11849)){
var statearr_11870_11896 = state_11864__$1;
(statearr_11870_11896[(1)] = (8));

} else {
var statearr_11871_11897 = state_11864__$1;
(statearr_11871_11897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (3))){
var inst_11862 = (state_11864[(2)]);
var state_11864__$1 = state_11864;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11864__$1,inst_11862);
} else {
if((state_val_11865 === (12))){
var state_11864__$1 = state_11864;
var statearr_11872_11898 = state_11864__$1;
(statearr_11872_11898[(2)] = null);

(statearr_11872_11898[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (2))){
var inst_11841 = (state_11864[(7)]);
var state_11864__$1 = state_11864;
if(cljs.core.truth_(inst_11841)){
var statearr_11873_11899 = state_11864__$1;
(statearr_11873_11899[(1)] = (4));

} else {
var statearr_11874_11900 = state_11864__$1;
(statearr_11874_11900[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (11))){
var inst_11855 = cljs.core.async.close_BANG_.call(null,ch);
var state_11864__$1 = state_11864;
var statearr_11875_11901 = state_11864__$1;
(statearr_11875_11901[(2)] = inst_11855);

(statearr_11875_11901[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (9))){
var state_11864__$1 = state_11864;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11876_11902 = state_11864__$1;
(statearr_11876_11902[(1)] = (11));

} else {
var statearr_11877_11903 = state_11864__$1;
(statearr_11877_11903[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (5))){
var inst_11841 = (state_11864[(7)]);
var state_11864__$1 = state_11864;
var statearr_11878_11904 = state_11864__$1;
(statearr_11878_11904[(2)] = inst_11841);

(statearr_11878_11904[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (10))){
var inst_11860 = (state_11864[(2)]);
var state_11864__$1 = state_11864;
var statearr_11879_11905 = state_11864__$1;
(statearr_11879_11905[(2)] = inst_11860);

(statearr_11879_11905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11865 === (8))){
var inst_11841 = (state_11864[(7)]);
var inst_11851 = cljs.core.next.call(null,inst_11841);
var inst_11841__$1 = inst_11851;
var state_11864__$1 = (function (){var statearr_11880 = state_11864;
(statearr_11880[(7)] = inst_11841__$1);

return statearr_11880;
})();
var statearr_11881_11906 = state_11864__$1;
(statearr_11881_11906[(2)] = null);

(statearr_11881_11906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto__))
;
return ((function (switch__10932__auto__,c__11044__auto__){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_11885 = [null,null,null,null,null,null,null,null];
(statearr_11885[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_11885[(1)] = (1));

return statearr_11885;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_11864){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_11864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e11886){if((e11886 instanceof Object)){
var ex__10936__auto__ = e11886;
var statearr_11887_11907 = state_11864;
(statearr_11887_11907[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11864);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11886;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11908 = state_11864;
state_11864 = G__11908;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_11864){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_11864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto__))
})();
var state__11046__auto__ = (function (){var statearr_11888 = f__11045__auto__.call(null);
(statearr_11888[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto__);

return statearr_11888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto__))
);

return c__11044__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12130 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12130 = (function (mult,ch,cs,meta12131){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta12131 = meta12131;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12130.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12132,meta12131__$1){
var self__ = this;
var _12132__$1 = this;
return (new cljs.core.async.t_cljs$core$async12130(self__.mult,self__.ch,self__.cs,meta12131__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12130.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12132){
var self__ = this;
var _12132__$1 = this;
return self__.meta12131;
});})(cs))
;

cljs.core.async.t_cljs$core$async12130.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12130.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12130.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async12130.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12130.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12130.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12130.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12131","meta12131",1680173665,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12130.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12130.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12130";

cljs.core.async.t_cljs$core$async12130.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12130");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12130 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12130(mult__$1,ch__$1,cs__$1,meta12131){
return (new cljs.core.async.t_cljs$core$async12130(mult__$1,ch__$1,cs__$1,meta12131));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12130(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11044__auto___12351 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___12351,cs,m,dchan,dctr,done){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___12351,cs,m,dchan,dctr,done){
return (function (state_12263){
var state_val_12264 = (state_12263[(1)]);
if((state_val_12264 === (7))){
var inst_12259 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12265_12352 = state_12263__$1;
(statearr_12265_12352[(2)] = inst_12259);

(statearr_12265_12352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (20))){
var inst_12164 = (state_12263[(7)]);
var inst_12174 = cljs.core.first.call(null,inst_12164);
var inst_12175 = cljs.core.nth.call(null,inst_12174,(0),null);
var inst_12176 = cljs.core.nth.call(null,inst_12174,(1),null);
var state_12263__$1 = (function (){var statearr_12266 = state_12263;
(statearr_12266[(8)] = inst_12175);

return statearr_12266;
})();
if(cljs.core.truth_(inst_12176)){
var statearr_12267_12353 = state_12263__$1;
(statearr_12267_12353[(1)] = (22));

} else {
var statearr_12268_12354 = state_12263__$1;
(statearr_12268_12354[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (27))){
var inst_12204 = (state_12263[(9)]);
var inst_12135 = (state_12263[(10)]);
var inst_12211 = (state_12263[(11)]);
var inst_12206 = (state_12263[(12)]);
var inst_12211__$1 = cljs.core._nth.call(null,inst_12204,inst_12206);
var inst_12212 = cljs.core.async.put_BANG_.call(null,inst_12211__$1,inst_12135,done);
var state_12263__$1 = (function (){var statearr_12269 = state_12263;
(statearr_12269[(11)] = inst_12211__$1);

return statearr_12269;
})();
if(cljs.core.truth_(inst_12212)){
var statearr_12270_12355 = state_12263__$1;
(statearr_12270_12355[(1)] = (30));

} else {
var statearr_12271_12356 = state_12263__$1;
(statearr_12271_12356[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (1))){
var state_12263__$1 = state_12263;
var statearr_12272_12357 = state_12263__$1;
(statearr_12272_12357[(2)] = null);

(statearr_12272_12357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (24))){
var inst_12164 = (state_12263[(7)]);
var inst_12181 = (state_12263[(2)]);
var inst_12182 = cljs.core.next.call(null,inst_12164);
var inst_12144 = inst_12182;
var inst_12145 = null;
var inst_12146 = (0);
var inst_12147 = (0);
var state_12263__$1 = (function (){var statearr_12273 = state_12263;
(statearr_12273[(13)] = inst_12147);

(statearr_12273[(14)] = inst_12181);

(statearr_12273[(15)] = inst_12145);

(statearr_12273[(16)] = inst_12144);

(statearr_12273[(17)] = inst_12146);

return statearr_12273;
})();
var statearr_12274_12358 = state_12263__$1;
(statearr_12274_12358[(2)] = null);

(statearr_12274_12358[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (39))){
var state_12263__$1 = state_12263;
var statearr_12278_12359 = state_12263__$1;
(statearr_12278_12359[(2)] = null);

(statearr_12278_12359[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (4))){
var inst_12135 = (state_12263[(10)]);
var inst_12135__$1 = (state_12263[(2)]);
var inst_12136 = (inst_12135__$1 == null);
var state_12263__$1 = (function (){var statearr_12279 = state_12263;
(statearr_12279[(10)] = inst_12135__$1);

return statearr_12279;
})();
if(cljs.core.truth_(inst_12136)){
var statearr_12280_12360 = state_12263__$1;
(statearr_12280_12360[(1)] = (5));

} else {
var statearr_12281_12361 = state_12263__$1;
(statearr_12281_12361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (15))){
var inst_12147 = (state_12263[(13)]);
var inst_12145 = (state_12263[(15)]);
var inst_12144 = (state_12263[(16)]);
var inst_12146 = (state_12263[(17)]);
var inst_12160 = (state_12263[(2)]);
var inst_12161 = (inst_12147 + (1));
var tmp12275 = inst_12145;
var tmp12276 = inst_12144;
var tmp12277 = inst_12146;
var inst_12144__$1 = tmp12276;
var inst_12145__$1 = tmp12275;
var inst_12146__$1 = tmp12277;
var inst_12147__$1 = inst_12161;
var state_12263__$1 = (function (){var statearr_12282 = state_12263;
(statearr_12282[(13)] = inst_12147__$1);

(statearr_12282[(15)] = inst_12145__$1);

(statearr_12282[(18)] = inst_12160);

(statearr_12282[(16)] = inst_12144__$1);

(statearr_12282[(17)] = inst_12146__$1);

return statearr_12282;
})();
var statearr_12283_12362 = state_12263__$1;
(statearr_12283_12362[(2)] = null);

(statearr_12283_12362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (21))){
var inst_12185 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12287_12363 = state_12263__$1;
(statearr_12287_12363[(2)] = inst_12185);

(statearr_12287_12363[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (31))){
var inst_12211 = (state_12263[(11)]);
var inst_12215 = done.call(null,null);
var inst_12216 = cljs.core.async.untap_STAR_.call(null,m,inst_12211);
var state_12263__$1 = (function (){var statearr_12288 = state_12263;
(statearr_12288[(19)] = inst_12215);

return statearr_12288;
})();
var statearr_12289_12364 = state_12263__$1;
(statearr_12289_12364[(2)] = inst_12216);

(statearr_12289_12364[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (32))){
var inst_12204 = (state_12263[(9)]);
var inst_12206 = (state_12263[(12)]);
var inst_12205 = (state_12263[(20)]);
var inst_12203 = (state_12263[(21)]);
var inst_12218 = (state_12263[(2)]);
var inst_12219 = (inst_12206 + (1));
var tmp12284 = inst_12204;
var tmp12285 = inst_12205;
var tmp12286 = inst_12203;
var inst_12203__$1 = tmp12286;
var inst_12204__$1 = tmp12284;
var inst_12205__$1 = tmp12285;
var inst_12206__$1 = inst_12219;
var state_12263__$1 = (function (){var statearr_12290 = state_12263;
(statearr_12290[(9)] = inst_12204__$1);

(statearr_12290[(12)] = inst_12206__$1);

(statearr_12290[(22)] = inst_12218);

(statearr_12290[(20)] = inst_12205__$1);

(statearr_12290[(21)] = inst_12203__$1);

return statearr_12290;
})();
var statearr_12291_12365 = state_12263__$1;
(statearr_12291_12365[(2)] = null);

(statearr_12291_12365[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (40))){
var inst_12231 = (state_12263[(23)]);
var inst_12235 = done.call(null,null);
var inst_12236 = cljs.core.async.untap_STAR_.call(null,m,inst_12231);
var state_12263__$1 = (function (){var statearr_12292 = state_12263;
(statearr_12292[(24)] = inst_12235);

return statearr_12292;
})();
var statearr_12293_12366 = state_12263__$1;
(statearr_12293_12366[(2)] = inst_12236);

(statearr_12293_12366[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (33))){
var inst_12222 = (state_12263[(25)]);
var inst_12224 = cljs.core.chunked_seq_QMARK_.call(null,inst_12222);
var state_12263__$1 = state_12263;
if(inst_12224){
var statearr_12294_12367 = state_12263__$1;
(statearr_12294_12367[(1)] = (36));

} else {
var statearr_12295_12368 = state_12263__$1;
(statearr_12295_12368[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (13))){
var inst_12154 = (state_12263[(26)]);
var inst_12157 = cljs.core.async.close_BANG_.call(null,inst_12154);
var state_12263__$1 = state_12263;
var statearr_12296_12369 = state_12263__$1;
(statearr_12296_12369[(2)] = inst_12157);

(statearr_12296_12369[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (22))){
var inst_12175 = (state_12263[(8)]);
var inst_12178 = cljs.core.async.close_BANG_.call(null,inst_12175);
var state_12263__$1 = state_12263;
var statearr_12297_12370 = state_12263__$1;
(statearr_12297_12370[(2)] = inst_12178);

(statearr_12297_12370[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (36))){
var inst_12222 = (state_12263[(25)]);
var inst_12226 = cljs.core.chunk_first.call(null,inst_12222);
var inst_12227 = cljs.core.chunk_rest.call(null,inst_12222);
var inst_12228 = cljs.core.count.call(null,inst_12226);
var inst_12203 = inst_12227;
var inst_12204 = inst_12226;
var inst_12205 = inst_12228;
var inst_12206 = (0);
var state_12263__$1 = (function (){var statearr_12298 = state_12263;
(statearr_12298[(9)] = inst_12204);

(statearr_12298[(12)] = inst_12206);

(statearr_12298[(20)] = inst_12205);

(statearr_12298[(21)] = inst_12203);

return statearr_12298;
})();
var statearr_12299_12371 = state_12263__$1;
(statearr_12299_12371[(2)] = null);

(statearr_12299_12371[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (41))){
var inst_12222 = (state_12263[(25)]);
var inst_12238 = (state_12263[(2)]);
var inst_12239 = cljs.core.next.call(null,inst_12222);
var inst_12203 = inst_12239;
var inst_12204 = null;
var inst_12205 = (0);
var inst_12206 = (0);
var state_12263__$1 = (function (){var statearr_12300 = state_12263;
(statearr_12300[(9)] = inst_12204);

(statearr_12300[(12)] = inst_12206);

(statearr_12300[(20)] = inst_12205);

(statearr_12300[(27)] = inst_12238);

(statearr_12300[(21)] = inst_12203);

return statearr_12300;
})();
var statearr_12301_12372 = state_12263__$1;
(statearr_12301_12372[(2)] = null);

(statearr_12301_12372[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (43))){
var state_12263__$1 = state_12263;
var statearr_12302_12373 = state_12263__$1;
(statearr_12302_12373[(2)] = null);

(statearr_12302_12373[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (29))){
var inst_12247 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12303_12374 = state_12263__$1;
(statearr_12303_12374[(2)] = inst_12247);

(statearr_12303_12374[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (44))){
var inst_12256 = (state_12263[(2)]);
var state_12263__$1 = (function (){var statearr_12304 = state_12263;
(statearr_12304[(28)] = inst_12256);

return statearr_12304;
})();
var statearr_12305_12375 = state_12263__$1;
(statearr_12305_12375[(2)] = null);

(statearr_12305_12375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (6))){
var inst_12195 = (state_12263[(29)]);
var inst_12194 = cljs.core.deref.call(null,cs);
var inst_12195__$1 = cljs.core.keys.call(null,inst_12194);
var inst_12196 = cljs.core.count.call(null,inst_12195__$1);
var inst_12197 = cljs.core.reset_BANG_.call(null,dctr,inst_12196);
var inst_12202 = cljs.core.seq.call(null,inst_12195__$1);
var inst_12203 = inst_12202;
var inst_12204 = null;
var inst_12205 = (0);
var inst_12206 = (0);
var state_12263__$1 = (function (){var statearr_12306 = state_12263;
(statearr_12306[(9)] = inst_12204);

(statearr_12306[(12)] = inst_12206);

(statearr_12306[(30)] = inst_12197);

(statearr_12306[(20)] = inst_12205);

(statearr_12306[(29)] = inst_12195__$1);

(statearr_12306[(21)] = inst_12203);

return statearr_12306;
})();
var statearr_12307_12376 = state_12263__$1;
(statearr_12307_12376[(2)] = null);

(statearr_12307_12376[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (28))){
var inst_12222 = (state_12263[(25)]);
var inst_12203 = (state_12263[(21)]);
var inst_12222__$1 = cljs.core.seq.call(null,inst_12203);
var state_12263__$1 = (function (){var statearr_12308 = state_12263;
(statearr_12308[(25)] = inst_12222__$1);

return statearr_12308;
})();
if(inst_12222__$1){
var statearr_12309_12377 = state_12263__$1;
(statearr_12309_12377[(1)] = (33));

} else {
var statearr_12310_12378 = state_12263__$1;
(statearr_12310_12378[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (25))){
var inst_12206 = (state_12263[(12)]);
var inst_12205 = (state_12263[(20)]);
var inst_12208 = (inst_12206 < inst_12205);
var inst_12209 = inst_12208;
var state_12263__$1 = state_12263;
if(cljs.core.truth_(inst_12209)){
var statearr_12311_12379 = state_12263__$1;
(statearr_12311_12379[(1)] = (27));

} else {
var statearr_12312_12380 = state_12263__$1;
(statearr_12312_12380[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (34))){
var state_12263__$1 = state_12263;
var statearr_12313_12381 = state_12263__$1;
(statearr_12313_12381[(2)] = null);

(statearr_12313_12381[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (17))){
var state_12263__$1 = state_12263;
var statearr_12314_12382 = state_12263__$1;
(statearr_12314_12382[(2)] = null);

(statearr_12314_12382[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (3))){
var inst_12261 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12263__$1,inst_12261);
} else {
if((state_val_12264 === (12))){
var inst_12190 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12315_12383 = state_12263__$1;
(statearr_12315_12383[(2)] = inst_12190);

(statearr_12315_12383[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (2))){
var state_12263__$1 = state_12263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12263__$1,(4),ch);
} else {
if((state_val_12264 === (23))){
var state_12263__$1 = state_12263;
var statearr_12316_12384 = state_12263__$1;
(statearr_12316_12384[(2)] = null);

(statearr_12316_12384[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (35))){
var inst_12245 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12317_12385 = state_12263__$1;
(statearr_12317_12385[(2)] = inst_12245);

(statearr_12317_12385[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (19))){
var inst_12164 = (state_12263[(7)]);
var inst_12168 = cljs.core.chunk_first.call(null,inst_12164);
var inst_12169 = cljs.core.chunk_rest.call(null,inst_12164);
var inst_12170 = cljs.core.count.call(null,inst_12168);
var inst_12144 = inst_12169;
var inst_12145 = inst_12168;
var inst_12146 = inst_12170;
var inst_12147 = (0);
var state_12263__$1 = (function (){var statearr_12318 = state_12263;
(statearr_12318[(13)] = inst_12147);

(statearr_12318[(15)] = inst_12145);

(statearr_12318[(16)] = inst_12144);

(statearr_12318[(17)] = inst_12146);

return statearr_12318;
})();
var statearr_12319_12386 = state_12263__$1;
(statearr_12319_12386[(2)] = null);

(statearr_12319_12386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (11))){
var inst_12164 = (state_12263[(7)]);
var inst_12144 = (state_12263[(16)]);
var inst_12164__$1 = cljs.core.seq.call(null,inst_12144);
var state_12263__$1 = (function (){var statearr_12320 = state_12263;
(statearr_12320[(7)] = inst_12164__$1);

return statearr_12320;
})();
if(inst_12164__$1){
var statearr_12321_12387 = state_12263__$1;
(statearr_12321_12387[(1)] = (16));

} else {
var statearr_12322_12388 = state_12263__$1;
(statearr_12322_12388[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (9))){
var inst_12192 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12323_12389 = state_12263__$1;
(statearr_12323_12389[(2)] = inst_12192);

(statearr_12323_12389[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (5))){
var inst_12142 = cljs.core.deref.call(null,cs);
var inst_12143 = cljs.core.seq.call(null,inst_12142);
var inst_12144 = inst_12143;
var inst_12145 = null;
var inst_12146 = (0);
var inst_12147 = (0);
var state_12263__$1 = (function (){var statearr_12324 = state_12263;
(statearr_12324[(13)] = inst_12147);

(statearr_12324[(15)] = inst_12145);

(statearr_12324[(16)] = inst_12144);

(statearr_12324[(17)] = inst_12146);

return statearr_12324;
})();
var statearr_12325_12390 = state_12263__$1;
(statearr_12325_12390[(2)] = null);

(statearr_12325_12390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (14))){
var state_12263__$1 = state_12263;
var statearr_12326_12391 = state_12263__$1;
(statearr_12326_12391[(2)] = null);

(statearr_12326_12391[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (45))){
var inst_12253 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12327_12392 = state_12263__$1;
(statearr_12327_12392[(2)] = inst_12253);

(statearr_12327_12392[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (26))){
var inst_12195 = (state_12263[(29)]);
var inst_12249 = (state_12263[(2)]);
var inst_12250 = cljs.core.seq.call(null,inst_12195);
var state_12263__$1 = (function (){var statearr_12328 = state_12263;
(statearr_12328[(31)] = inst_12249);

return statearr_12328;
})();
if(inst_12250){
var statearr_12329_12393 = state_12263__$1;
(statearr_12329_12393[(1)] = (42));

} else {
var statearr_12330_12394 = state_12263__$1;
(statearr_12330_12394[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (16))){
var inst_12164 = (state_12263[(7)]);
var inst_12166 = cljs.core.chunked_seq_QMARK_.call(null,inst_12164);
var state_12263__$1 = state_12263;
if(inst_12166){
var statearr_12331_12395 = state_12263__$1;
(statearr_12331_12395[(1)] = (19));

} else {
var statearr_12332_12396 = state_12263__$1;
(statearr_12332_12396[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (38))){
var inst_12242 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12333_12397 = state_12263__$1;
(statearr_12333_12397[(2)] = inst_12242);

(statearr_12333_12397[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (30))){
var state_12263__$1 = state_12263;
var statearr_12334_12398 = state_12263__$1;
(statearr_12334_12398[(2)] = null);

(statearr_12334_12398[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (10))){
var inst_12147 = (state_12263[(13)]);
var inst_12145 = (state_12263[(15)]);
var inst_12153 = cljs.core._nth.call(null,inst_12145,inst_12147);
var inst_12154 = cljs.core.nth.call(null,inst_12153,(0),null);
var inst_12155 = cljs.core.nth.call(null,inst_12153,(1),null);
var state_12263__$1 = (function (){var statearr_12335 = state_12263;
(statearr_12335[(26)] = inst_12154);

return statearr_12335;
})();
if(cljs.core.truth_(inst_12155)){
var statearr_12336_12399 = state_12263__$1;
(statearr_12336_12399[(1)] = (13));

} else {
var statearr_12337_12400 = state_12263__$1;
(statearr_12337_12400[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (18))){
var inst_12188 = (state_12263[(2)]);
var state_12263__$1 = state_12263;
var statearr_12338_12401 = state_12263__$1;
(statearr_12338_12401[(2)] = inst_12188);

(statearr_12338_12401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (42))){
var state_12263__$1 = state_12263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12263__$1,(45),dchan);
} else {
if((state_val_12264 === (37))){
var inst_12135 = (state_12263[(10)]);
var inst_12222 = (state_12263[(25)]);
var inst_12231 = (state_12263[(23)]);
var inst_12231__$1 = cljs.core.first.call(null,inst_12222);
var inst_12232 = cljs.core.async.put_BANG_.call(null,inst_12231__$1,inst_12135,done);
var state_12263__$1 = (function (){var statearr_12339 = state_12263;
(statearr_12339[(23)] = inst_12231__$1);

return statearr_12339;
})();
if(cljs.core.truth_(inst_12232)){
var statearr_12340_12402 = state_12263__$1;
(statearr_12340_12402[(1)] = (39));

} else {
var statearr_12341_12403 = state_12263__$1;
(statearr_12341_12403[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12264 === (8))){
var inst_12147 = (state_12263[(13)]);
var inst_12146 = (state_12263[(17)]);
var inst_12149 = (inst_12147 < inst_12146);
var inst_12150 = inst_12149;
var state_12263__$1 = state_12263;
if(cljs.core.truth_(inst_12150)){
var statearr_12342_12404 = state_12263__$1;
(statearr_12342_12404[(1)] = (10));

} else {
var statearr_12343_12405 = state_12263__$1;
(statearr_12343_12405[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___12351,cs,m,dchan,dctr,done))
;
return ((function (switch__10932__auto__,c__11044__auto___12351,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10933__auto__ = null;
var cljs$core$async$mult_$_state_machine__10933__auto____0 = (function (){
var statearr_12347 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12347[(0)] = cljs$core$async$mult_$_state_machine__10933__auto__);

(statearr_12347[(1)] = (1));

return statearr_12347;
});
var cljs$core$async$mult_$_state_machine__10933__auto____1 = (function (state_12263){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_12263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e12348){if((e12348 instanceof Object)){
var ex__10936__auto__ = e12348;
var statearr_12349_12406 = state_12263;
(statearr_12349_12406[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12263);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12348;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12407 = state_12263;
state_12263 = G__12407;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10933__auto__ = function(state_12263){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10933__auto____1.call(this,state_12263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10933__auto____0;
cljs$core$async$mult_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10933__auto____1;
return cljs$core$async$mult_$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___12351,cs,m,dchan,dctr,done))
})();
var state__11046__auto__ = (function (){var statearr_12350 = f__11045__auto__.call(null);
(statearr_12350[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___12351);

return statearr_12350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___12351,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args12408 = [];
var len__5726__auto___12411 = arguments.length;
var i__5727__auto___12412 = (0);
while(true){
if((i__5727__auto___12412 < len__5726__auto___12411)){
args12408.push((arguments[i__5727__auto___12412]));

var G__12413 = (i__5727__auto___12412 + (1));
i__5727__auto___12412 = G__12413;
continue;
} else {
}
break;
}

var G__12410 = args12408.length;
switch (G__12410) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12408.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___12425 = arguments.length;
var i__5727__auto___12426 = (0);
while(true){
if((i__5727__auto___12426 < len__5726__auto___12425)){
args__5733__auto__.push((arguments[i__5727__auto___12426]));

var G__12427 = (i__5727__auto___12426 + (1));
i__5727__auto___12426 = G__12427;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12419){
var map__12420 = p__12419;
var map__12420__$1 = ((((!((map__12420 == null)))?((((map__12420.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12420.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12420):map__12420);
var opts = map__12420__$1;
var statearr_12422_12428 = state;
(statearr_12422_12428[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__12420,map__12420__$1,opts){
return (function (val){
var statearr_12423_12429 = state;
(statearr_12423_12429[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12420,map__12420__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_12424_12430 = state;
(statearr_12424_12430[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12415){
var G__12416 = cljs.core.first.call(null,seq12415);
var seq12415__$1 = cljs.core.next.call(null,seq12415);
var G__12417 = cljs.core.first.call(null,seq12415__$1);
var seq12415__$2 = cljs.core.next.call(null,seq12415__$1);
var G__12418 = cljs.core.first.call(null,seq12415__$2);
var seq12415__$3 = cljs.core.next.call(null,seq12415__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12416,G__12417,G__12418,seq12415__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12594 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12594 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12595){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12595 = meta12595;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12596,meta12595__$1){
var self__ = this;
var _12596__$1 = this;
return (new cljs.core.async.t_cljs$core$async12594(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12595__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12596){
var self__ = this;
var _12596__$1 = this;
return self__.meta12595;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12595","meta12595",584892185,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12594.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12594.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12594";

cljs.core.async.t_cljs$core$async12594.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12594");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12594 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12594(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12595){
return (new cljs.core.async.t_cljs$core$async12594(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12595));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12594(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11044__auto___12757 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___12757,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___12757,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12694){
var state_val_12695 = (state_12694[(1)]);
if((state_val_12695 === (7))){
var inst_12612 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
var statearr_12696_12758 = state_12694__$1;
(statearr_12696_12758[(2)] = inst_12612);

(statearr_12696_12758[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (20))){
var inst_12624 = (state_12694[(7)]);
var state_12694__$1 = state_12694;
var statearr_12697_12759 = state_12694__$1;
(statearr_12697_12759[(2)] = inst_12624);

(statearr_12697_12759[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (27))){
var state_12694__$1 = state_12694;
var statearr_12698_12760 = state_12694__$1;
(statearr_12698_12760[(2)] = null);

(statearr_12698_12760[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (1))){
var inst_12600 = (state_12694[(8)]);
var inst_12600__$1 = calc_state.call(null);
var inst_12602 = (inst_12600__$1 == null);
var inst_12603 = cljs.core.not.call(null,inst_12602);
var state_12694__$1 = (function (){var statearr_12699 = state_12694;
(statearr_12699[(8)] = inst_12600__$1);

return statearr_12699;
})();
if(inst_12603){
var statearr_12700_12761 = state_12694__$1;
(statearr_12700_12761[(1)] = (2));

} else {
var statearr_12701_12762 = state_12694__$1;
(statearr_12701_12762[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (24))){
var inst_12654 = (state_12694[(9)]);
var inst_12668 = (state_12694[(10)]);
var inst_12647 = (state_12694[(11)]);
var inst_12668__$1 = inst_12647.call(null,inst_12654);
var state_12694__$1 = (function (){var statearr_12702 = state_12694;
(statearr_12702[(10)] = inst_12668__$1);

return statearr_12702;
})();
if(cljs.core.truth_(inst_12668__$1)){
var statearr_12703_12763 = state_12694__$1;
(statearr_12703_12763[(1)] = (29));

} else {
var statearr_12704_12764 = state_12694__$1;
(statearr_12704_12764[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (4))){
var inst_12615 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
if(cljs.core.truth_(inst_12615)){
var statearr_12705_12765 = state_12694__$1;
(statearr_12705_12765[(1)] = (8));

} else {
var statearr_12706_12766 = state_12694__$1;
(statearr_12706_12766[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (15))){
var inst_12641 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
if(cljs.core.truth_(inst_12641)){
var statearr_12707_12767 = state_12694__$1;
(statearr_12707_12767[(1)] = (19));

} else {
var statearr_12708_12768 = state_12694__$1;
(statearr_12708_12768[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (21))){
var inst_12646 = (state_12694[(12)]);
var inst_12646__$1 = (state_12694[(2)]);
var inst_12647 = cljs.core.get.call(null,inst_12646__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12648 = cljs.core.get.call(null,inst_12646__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12649 = cljs.core.get.call(null,inst_12646__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12694__$1 = (function (){var statearr_12709 = state_12694;
(statearr_12709[(13)] = inst_12648);

(statearr_12709[(12)] = inst_12646__$1);

(statearr_12709[(11)] = inst_12647);

return statearr_12709;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12694__$1,(22),inst_12649);
} else {
if((state_val_12695 === (31))){
var inst_12676 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
if(cljs.core.truth_(inst_12676)){
var statearr_12710_12769 = state_12694__$1;
(statearr_12710_12769[(1)] = (32));

} else {
var statearr_12711_12770 = state_12694__$1;
(statearr_12711_12770[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (32))){
var inst_12653 = (state_12694[(14)]);
var state_12694__$1 = state_12694;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12694__$1,(35),out,inst_12653);
} else {
if((state_val_12695 === (33))){
var inst_12646 = (state_12694[(12)]);
var inst_12624 = inst_12646;
var state_12694__$1 = (function (){var statearr_12712 = state_12694;
(statearr_12712[(7)] = inst_12624);

return statearr_12712;
})();
var statearr_12713_12771 = state_12694__$1;
(statearr_12713_12771[(2)] = null);

(statearr_12713_12771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (13))){
var inst_12624 = (state_12694[(7)]);
var inst_12631 = inst_12624.cljs$lang$protocol_mask$partition0$;
var inst_12632 = (inst_12631 & (64));
var inst_12633 = inst_12624.cljs$core$ISeq$;
var inst_12634 = (inst_12632) || (inst_12633);
var state_12694__$1 = state_12694;
if(cljs.core.truth_(inst_12634)){
var statearr_12714_12772 = state_12694__$1;
(statearr_12714_12772[(1)] = (16));

} else {
var statearr_12715_12773 = state_12694__$1;
(statearr_12715_12773[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (22))){
var inst_12654 = (state_12694[(9)]);
var inst_12653 = (state_12694[(14)]);
var inst_12652 = (state_12694[(2)]);
var inst_12653__$1 = cljs.core.nth.call(null,inst_12652,(0),null);
var inst_12654__$1 = cljs.core.nth.call(null,inst_12652,(1),null);
var inst_12655 = (inst_12653__$1 == null);
var inst_12656 = cljs.core._EQ_.call(null,inst_12654__$1,change);
var inst_12657 = (inst_12655) || (inst_12656);
var state_12694__$1 = (function (){var statearr_12716 = state_12694;
(statearr_12716[(9)] = inst_12654__$1);

(statearr_12716[(14)] = inst_12653__$1);

return statearr_12716;
})();
if(cljs.core.truth_(inst_12657)){
var statearr_12717_12774 = state_12694__$1;
(statearr_12717_12774[(1)] = (23));

} else {
var statearr_12718_12775 = state_12694__$1;
(statearr_12718_12775[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (36))){
var inst_12646 = (state_12694[(12)]);
var inst_12624 = inst_12646;
var state_12694__$1 = (function (){var statearr_12719 = state_12694;
(statearr_12719[(7)] = inst_12624);

return statearr_12719;
})();
var statearr_12720_12776 = state_12694__$1;
(statearr_12720_12776[(2)] = null);

(statearr_12720_12776[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (29))){
var inst_12668 = (state_12694[(10)]);
var state_12694__$1 = state_12694;
var statearr_12721_12777 = state_12694__$1;
(statearr_12721_12777[(2)] = inst_12668);

(statearr_12721_12777[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (6))){
var state_12694__$1 = state_12694;
var statearr_12722_12778 = state_12694__$1;
(statearr_12722_12778[(2)] = false);

(statearr_12722_12778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (28))){
var inst_12664 = (state_12694[(2)]);
var inst_12665 = calc_state.call(null);
var inst_12624 = inst_12665;
var state_12694__$1 = (function (){var statearr_12723 = state_12694;
(statearr_12723[(7)] = inst_12624);

(statearr_12723[(15)] = inst_12664);

return statearr_12723;
})();
var statearr_12724_12779 = state_12694__$1;
(statearr_12724_12779[(2)] = null);

(statearr_12724_12779[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (25))){
var inst_12690 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
var statearr_12725_12780 = state_12694__$1;
(statearr_12725_12780[(2)] = inst_12690);

(statearr_12725_12780[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (34))){
var inst_12688 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
var statearr_12726_12781 = state_12694__$1;
(statearr_12726_12781[(2)] = inst_12688);

(statearr_12726_12781[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (17))){
var state_12694__$1 = state_12694;
var statearr_12727_12782 = state_12694__$1;
(statearr_12727_12782[(2)] = false);

(statearr_12727_12782[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (3))){
var state_12694__$1 = state_12694;
var statearr_12728_12783 = state_12694__$1;
(statearr_12728_12783[(2)] = false);

(statearr_12728_12783[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (12))){
var inst_12692 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12694__$1,inst_12692);
} else {
if((state_val_12695 === (2))){
var inst_12600 = (state_12694[(8)]);
var inst_12605 = inst_12600.cljs$lang$protocol_mask$partition0$;
var inst_12606 = (inst_12605 & (64));
var inst_12607 = inst_12600.cljs$core$ISeq$;
var inst_12608 = (inst_12606) || (inst_12607);
var state_12694__$1 = state_12694;
if(cljs.core.truth_(inst_12608)){
var statearr_12729_12784 = state_12694__$1;
(statearr_12729_12784[(1)] = (5));

} else {
var statearr_12730_12785 = state_12694__$1;
(statearr_12730_12785[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (23))){
var inst_12653 = (state_12694[(14)]);
var inst_12659 = (inst_12653 == null);
var state_12694__$1 = state_12694;
if(cljs.core.truth_(inst_12659)){
var statearr_12731_12786 = state_12694__$1;
(statearr_12731_12786[(1)] = (26));

} else {
var statearr_12732_12787 = state_12694__$1;
(statearr_12732_12787[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (35))){
var inst_12679 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
if(cljs.core.truth_(inst_12679)){
var statearr_12733_12788 = state_12694__$1;
(statearr_12733_12788[(1)] = (36));

} else {
var statearr_12734_12789 = state_12694__$1;
(statearr_12734_12789[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (19))){
var inst_12624 = (state_12694[(7)]);
var inst_12643 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12624);
var state_12694__$1 = state_12694;
var statearr_12735_12790 = state_12694__$1;
(statearr_12735_12790[(2)] = inst_12643);

(statearr_12735_12790[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (11))){
var inst_12624 = (state_12694[(7)]);
var inst_12628 = (inst_12624 == null);
var inst_12629 = cljs.core.not.call(null,inst_12628);
var state_12694__$1 = state_12694;
if(inst_12629){
var statearr_12736_12791 = state_12694__$1;
(statearr_12736_12791[(1)] = (13));

} else {
var statearr_12737_12792 = state_12694__$1;
(statearr_12737_12792[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (9))){
var inst_12600 = (state_12694[(8)]);
var state_12694__$1 = state_12694;
var statearr_12738_12793 = state_12694__$1;
(statearr_12738_12793[(2)] = inst_12600);

(statearr_12738_12793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (5))){
var state_12694__$1 = state_12694;
var statearr_12739_12794 = state_12694__$1;
(statearr_12739_12794[(2)] = true);

(statearr_12739_12794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (14))){
var state_12694__$1 = state_12694;
var statearr_12740_12795 = state_12694__$1;
(statearr_12740_12795[(2)] = false);

(statearr_12740_12795[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (26))){
var inst_12654 = (state_12694[(9)]);
var inst_12661 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12654);
var state_12694__$1 = state_12694;
var statearr_12741_12796 = state_12694__$1;
(statearr_12741_12796[(2)] = inst_12661);

(statearr_12741_12796[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (16))){
var state_12694__$1 = state_12694;
var statearr_12742_12797 = state_12694__$1;
(statearr_12742_12797[(2)] = true);

(statearr_12742_12797[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (38))){
var inst_12684 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
var statearr_12743_12798 = state_12694__$1;
(statearr_12743_12798[(2)] = inst_12684);

(statearr_12743_12798[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (30))){
var inst_12648 = (state_12694[(13)]);
var inst_12654 = (state_12694[(9)]);
var inst_12647 = (state_12694[(11)]);
var inst_12671 = cljs.core.empty_QMARK_.call(null,inst_12647);
var inst_12672 = inst_12648.call(null,inst_12654);
var inst_12673 = cljs.core.not.call(null,inst_12672);
var inst_12674 = (inst_12671) && (inst_12673);
var state_12694__$1 = state_12694;
var statearr_12744_12799 = state_12694__$1;
(statearr_12744_12799[(2)] = inst_12674);

(statearr_12744_12799[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (10))){
var inst_12600 = (state_12694[(8)]);
var inst_12620 = (state_12694[(2)]);
var inst_12621 = cljs.core.get.call(null,inst_12620,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12622 = cljs.core.get.call(null,inst_12620,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12623 = cljs.core.get.call(null,inst_12620,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12624 = inst_12600;
var state_12694__$1 = (function (){var statearr_12745 = state_12694;
(statearr_12745[(16)] = inst_12623);

(statearr_12745[(17)] = inst_12621);

(statearr_12745[(18)] = inst_12622);

(statearr_12745[(7)] = inst_12624);

return statearr_12745;
})();
var statearr_12746_12800 = state_12694__$1;
(statearr_12746_12800[(2)] = null);

(statearr_12746_12800[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (18))){
var inst_12638 = (state_12694[(2)]);
var state_12694__$1 = state_12694;
var statearr_12747_12801 = state_12694__$1;
(statearr_12747_12801[(2)] = inst_12638);

(statearr_12747_12801[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (37))){
var state_12694__$1 = state_12694;
var statearr_12748_12802 = state_12694__$1;
(statearr_12748_12802[(2)] = null);

(statearr_12748_12802[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12695 === (8))){
var inst_12600 = (state_12694[(8)]);
var inst_12617 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12600);
var state_12694__$1 = state_12694;
var statearr_12749_12803 = state_12694__$1;
(statearr_12749_12803[(2)] = inst_12617);

(statearr_12749_12803[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___12757,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10932__auto__,c__11044__auto___12757,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10933__auto__ = null;
var cljs$core$async$mix_$_state_machine__10933__auto____0 = (function (){
var statearr_12753 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12753[(0)] = cljs$core$async$mix_$_state_machine__10933__auto__);

(statearr_12753[(1)] = (1));

return statearr_12753;
});
var cljs$core$async$mix_$_state_machine__10933__auto____1 = (function (state_12694){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_12694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e12754){if((e12754 instanceof Object)){
var ex__10936__auto__ = e12754;
var statearr_12755_12804 = state_12694;
(statearr_12755_12804[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12694);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12754;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12805 = state_12694;
state_12694 = G__12805;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10933__auto__ = function(state_12694){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10933__auto____1.call(this,state_12694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10933__auto____0;
cljs$core$async$mix_$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10933__auto____1;
return cljs$core$async$mix_$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___12757,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11046__auto__ = (function (){var statearr_12756 = f__11045__auto__.call(null);
(statearr_12756[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___12757);

return statearr_12756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___12757,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12806 = [];
var len__5726__auto___12809 = arguments.length;
var i__5727__auto___12810 = (0);
while(true){
if((i__5727__auto___12810 < len__5726__auto___12809)){
args12806.push((arguments[i__5727__auto___12810]));

var G__12811 = (i__5727__auto___12810 + (1));
i__5727__auto___12810 = G__12811;
continue;
} else {
}
break;
}

var G__12808 = args12806.length;
switch (G__12808) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12806.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12814 = [];
var len__5726__auto___12939 = arguments.length;
var i__5727__auto___12940 = (0);
while(true){
if((i__5727__auto___12940 < len__5726__auto___12939)){
args12814.push((arguments[i__5727__auto___12940]));

var G__12941 = (i__5727__auto___12940 + (1));
i__5727__auto___12940 = G__12941;
continue;
} else {
}
break;
}

var G__12816 = args12814.length;
switch (G__12816) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12814.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__12813_SHARP_){
if(cljs.core.truth_(p1__12813_SHARP_.call(null,topic))){
return p1__12813_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12813_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12817 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12817 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12818){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12818 = meta12818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12819,meta12818__$1){
var self__ = this;
var _12819__$1 = this;
return (new cljs.core.async.t_cljs$core$async12817(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12818__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12819){
var self__ = this;
var _12819__$1 = this;
return self__.meta12818;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12817.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12817.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12818","meta12818",-1043680110,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12817.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12817.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12817";

cljs.core.async.t_cljs$core$async12817.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async12817");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12817 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12817(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12818){
return (new cljs.core.async.t_cljs$core$async12817(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12818));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12817(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11044__auto___12943 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___12943,mults,ensure_mult,p){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___12943,mults,ensure_mult,p){
return (function (state_12891){
var state_val_12892 = (state_12891[(1)]);
if((state_val_12892 === (7))){
var inst_12887 = (state_12891[(2)]);
var state_12891__$1 = state_12891;
var statearr_12893_12944 = state_12891__$1;
(statearr_12893_12944[(2)] = inst_12887);

(statearr_12893_12944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (20))){
var state_12891__$1 = state_12891;
var statearr_12894_12945 = state_12891__$1;
(statearr_12894_12945[(2)] = null);

(statearr_12894_12945[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (1))){
var state_12891__$1 = state_12891;
var statearr_12895_12946 = state_12891__$1;
(statearr_12895_12946[(2)] = null);

(statearr_12895_12946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (24))){
var inst_12870 = (state_12891[(7)]);
var inst_12879 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12870);
var state_12891__$1 = state_12891;
var statearr_12896_12947 = state_12891__$1;
(statearr_12896_12947[(2)] = inst_12879);

(statearr_12896_12947[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (4))){
var inst_12822 = (state_12891[(8)]);
var inst_12822__$1 = (state_12891[(2)]);
var inst_12823 = (inst_12822__$1 == null);
var state_12891__$1 = (function (){var statearr_12897 = state_12891;
(statearr_12897[(8)] = inst_12822__$1);

return statearr_12897;
})();
if(cljs.core.truth_(inst_12823)){
var statearr_12898_12948 = state_12891__$1;
(statearr_12898_12948[(1)] = (5));

} else {
var statearr_12899_12949 = state_12891__$1;
(statearr_12899_12949[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (15))){
var inst_12864 = (state_12891[(2)]);
var state_12891__$1 = state_12891;
var statearr_12900_12950 = state_12891__$1;
(statearr_12900_12950[(2)] = inst_12864);

(statearr_12900_12950[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (21))){
var inst_12884 = (state_12891[(2)]);
var state_12891__$1 = (function (){var statearr_12901 = state_12891;
(statearr_12901[(9)] = inst_12884);

return statearr_12901;
})();
var statearr_12902_12951 = state_12891__$1;
(statearr_12902_12951[(2)] = null);

(statearr_12902_12951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (13))){
var inst_12846 = (state_12891[(10)]);
var inst_12848 = cljs.core.chunked_seq_QMARK_.call(null,inst_12846);
var state_12891__$1 = state_12891;
if(inst_12848){
var statearr_12903_12952 = state_12891__$1;
(statearr_12903_12952[(1)] = (16));

} else {
var statearr_12904_12953 = state_12891__$1;
(statearr_12904_12953[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (22))){
var inst_12876 = (state_12891[(2)]);
var state_12891__$1 = state_12891;
if(cljs.core.truth_(inst_12876)){
var statearr_12905_12954 = state_12891__$1;
(statearr_12905_12954[(1)] = (23));

} else {
var statearr_12906_12955 = state_12891__$1;
(statearr_12906_12955[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (6))){
var inst_12870 = (state_12891[(7)]);
var inst_12872 = (state_12891[(11)]);
var inst_12822 = (state_12891[(8)]);
var inst_12870__$1 = topic_fn.call(null,inst_12822);
var inst_12871 = cljs.core.deref.call(null,mults);
var inst_12872__$1 = cljs.core.get.call(null,inst_12871,inst_12870__$1);
var state_12891__$1 = (function (){var statearr_12907 = state_12891;
(statearr_12907[(7)] = inst_12870__$1);

(statearr_12907[(11)] = inst_12872__$1);

return statearr_12907;
})();
if(cljs.core.truth_(inst_12872__$1)){
var statearr_12908_12956 = state_12891__$1;
(statearr_12908_12956[(1)] = (19));

} else {
var statearr_12909_12957 = state_12891__$1;
(statearr_12909_12957[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (25))){
var inst_12881 = (state_12891[(2)]);
var state_12891__$1 = state_12891;
var statearr_12910_12958 = state_12891__$1;
(statearr_12910_12958[(2)] = inst_12881);

(statearr_12910_12958[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (17))){
var inst_12846 = (state_12891[(10)]);
var inst_12855 = cljs.core.first.call(null,inst_12846);
var inst_12856 = cljs.core.async.muxch_STAR_.call(null,inst_12855);
var inst_12857 = cljs.core.async.close_BANG_.call(null,inst_12856);
var inst_12858 = cljs.core.next.call(null,inst_12846);
var inst_12832 = inst_12858;
var inst_12833 = null;
var inst_12834 = (0);
var inst_12835 = (0);
var state_12891__$1 = (function (){var statearr_12911 = state_12891;
(statearr_12911[(12)] = inst_12832);

(statearr_12911[(13)] = inst_12834);

(statearr_12911[(14)] = inst_12857);

(statearr_12911[(15)] = inst_12835);

(statearr_12911[(16)] = inst_12833);

return statearr_12911;
})();
var statearr_12912_12959 = state_12891__$1;
(statearr_12912_12959[(2)] = null);

(statearr_12912_12959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (3))){
var inst_12889 = (state_12891[(2)]);
var state_12891__$1 = state_12891;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12891__$1,inst_12889);
} else {
if((state_val_12892 === (12))){
var inst_12866 = (state_12891[(2)]);
var state_12891__$1 = state_12891;
var statearr_12913_12960 = state_12891__$1;
(statearr_12913_12960[(2)] = inst_12866);

(statearr_12913_12960[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (2))){
var state_12891__$1 = state_12891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12891__$1,(4),ch);
} else {
if((state_val_12892 === (23))){
var state_12891__$1 = state_12891;
var statearr_12914_12961 = state_12891__$1;
(statearr_12914_12961[(2)] = null);

(statearr_12914_12961[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (19))){
var inst_12872 = (state_12891[(11)]);
var inst_12822 = (state_12891[(8)]);
var inst_12874 = cljs.core.async.muxch_STAR_.call(null,inst_12872);
var state_12891__$1 = state_12891;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12891__$1,(22),inst_12874,inst_12822);
} else {
if((state_val_12892 === (11))){
var inst_12832 = (state_12891[(12)]);
var inst_12846 = (state_12891[(10)]);
var inst_12846__$1 = cljs.core.seq.call(null,inst_12832);
var state_12891__$1 = (function (){var statearr_12915 = state_12891;
(statearr_12915[(10)] = inst_12846__$1);

return statearr_12915;
})();
if(inst_12846__$1){
var statearr_12916_12962 = state_12891__$1;
(statearr_12916_12962[(1)] = (13));

} else {
var statearr_12917_12963 = state_12891__$1;
(statearr_12917_12963[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (9))){
var inst_12868 = (state_12891[(2)]);
var state_12891__$1 = state_12891;
var statearr_12918_12964 = state_12891__$1;
(statearr_12918_12964[(2)] = inst_12868);

(statearr_12918_12964[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (5))){
var inst_12829 = cljs.core.deref.call(null,mults);
var inst_12830 = cljs.core.vals.call(null,inst_12829);
var inst_12831 = cljs.core.seq.call(null,inst_12830);
var inst_12832 = inst_12831;
var inst_12833 = null;
var inst_12834 = (0);
var inst_12835 = (0);
var state_12891__$1 = (function (){var statearr_12919 = state_12891;
(statearr_12919[(12)] = inst_12832);

(statearr_12919[(13)] = inst_12834);

(statearr_12919[(15)] = inst_12835);

(statearr_12919[(16)] = inst_12833);

return statearr_12919;
})();
var statearr_12920_12965 = state_12891__$1;
(statearr_12920_12965[(2)] = null);

(statearr_12920_12965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (14))){
var state_12891__$1 = state_12891;
var statearr_12924_12966 = state_12891__$1;
(statearr_12924_12966[(2)] = null);

(statearr_12924_12966[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (16))){
var inst_12846 = (state_12891[(10)]);
var inst_12850 = cljs.core.chunk_first.call(null,inst_12846);
var inst_12851 = cljs.core.chunk_rest.call(null,inst_12846);
var inst_12852 = cljs.core.count.call(null,inst_12850);
var inst_12832 = inst_12851;
var inst_12833 = inst_12850;
var inst_12834 = inst_12852;
var inst_12835 = (0);
var state_12891__$1 = (function (){var statearr_12925 = state_12891;
(statearr_12925[(12)] = inst_12832);

(statearr_12925[(13)] = inst_12834);

(statearr_12925[(15)] = inst_12835);

(statearr_12925[(16)] = inst_12833);

return statearr_12925;
})();
var statearr_12926_12967 = state_12891__$1;
(statearr_12926_12967[(2)] = null);

(statearr_12926_12967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (10))){
var inst_12832 = (state_12891[(12)]);
var inst_12834 = (state_12891[(13)]);
var inst_12835 = (state_12891[(15)]);
var inst_12833 = (state_12891[(16)]);
var inst_12840 = cljs.core._nth.call(null,inst_12833,inst_12835);
var inst_12841 = cljs.core.async.muxch_STAR_.call(null,inst_12840);
var inst_12842 = cljs.core.async.close_BANG_.call(null,inst_12841);
var inst_12843 = (inst_12835 + (1));
var tmp12921 = inst_12832;
var tmp12922 = inst_12834;
var tmp12923 = inst_12833;
var inst_12832__$1 = tmp12921;
var inst_12833__$1 = tmp12923;
var inst_12834__$1 = tmp12922;
var inst_12835__$1 = inst_12843;
var state_12891__$1 = (function (){var statearr_12927 = state_12891;
(statearr_12927[(12)] = inst_12832__$1);

(statearr_12927[(13)] = inst_12834__$1);

(statearr_12927[(15)] = inst_12835__$1);

(statearr_12927[(17)] = inst_12842);

(statearr_12927[(16)] = inst_12833__$1);

return statearr_12927;
})();
var statearr_12928_12968 = state_12891__$1;
(statearr_12928_12968[(2)] = null);

(statearr_12928_12968[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (18))){
var inst_12861 = (state_12891[(2)]);
var state_12891__$1 = state_12891;
var statearr_12929_12969 = state_12891__$1;
(statearr_12929_12969[(2)] = inst_12861);

(statearr_12929_12969[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12892 === (8))){
var inst_12834 = (state_12891[(13)]);
var inst_12835 = (state_12891[(15)]);
var inst_12837 = (inst_12835 < inst_12834);
var inst_12838 = inst_12837;
var state_12891__$1 = state_12891;
if(cljs.core.truth_(inst_12838)){
var statearr_12930_12970 = state_12891__$1;
(statearr_12930_12970[(1)] = (10));

} else {
var statearr_12931_12971 = state_12891__$1;
(statearr_12931_12971[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___12943,mults,ensure_mult,p))
;
return ((function (switch__10932__auto__,c__11044__auto___12943,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_12935 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12935[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_12935[(1)] = (1));

return statearr_12935;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_12891){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_12891);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e12936){if((e12936 instanceof Object)){
var ex__10936__auto__ = e12936;
var statearr_12937_12972 = state_12891;
(statearr_12937_12972[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12891);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12936;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12973 = state_12891;
state_12891 = G__12973;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_12891){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_12891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___12943,mults,ensure_mult,p))
})();
var state__11046__auto__ = (function (){var statearr_12938 = f__11045__auto__.call(null);
(statearr_12938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___12943);

return statearr_12938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___12943,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args12974 = [];
var len__5726__auto___12977 = arguments.length;
var i__5727__auto___12978 = (0);
while(true){
if((i__5727__auto___12978 < len__5726__auto___12977)){
args12974.push((arguments[i__5727__auto___12978]));

var G__12979 = (i__5727__auto___12978 + (1));
i__5727__auto___12978 = G__12979;
continue;
} else {
}
break;
}

var G__12976 = args12974.length;
switch (G__12976) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12974.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args12981 = [];
var len__5726__auto___12984 = arguments.length;
var i__5727__auto___12985 = (0);
while(true){
if((i__5727__auto___12985 < len__5726__auto___12984)){
args12981.push((arguments[i__5727__auto___12985]));

var G__12986 = (i__5727__auto___12985 + (1));
i__5727__auto___12985 = G__12986;
continue;
} else {
}
break;
}

var G__12983 = args12981.length;
switch (G__12983) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12981.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args12988 = [];
var len__5726__auto___13059 = arguments.length;
var i__5727__auto___13060 = (0);
while(true){
if((i__5727__auto___13060 < len__5726__auto___13059)){
args12988.push((arguments[i__5727__auto___13060]));

var G__13061 = (i__5727__auto___13060 + (1));
i__5727__auto___13060 = G__13061;
continue;
} else {
}
break;
}

var G__12990 = args12988.length;
switch (G__12990) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12988.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11044__auto___13063 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___13063,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___13063,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13029){
var state_val_13030 = (state_13029[(1)]);
if((state_val_13030 === (7))){
var state_13029__$1 = state_13029;
var statearr_13031_13064 = state_13029__$1;
(statearr_13031_13064[(2)] = null);

(statearr_13031_13064[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (1))){
var state_13029__$1 = state_13029;
var statearr_13032_13065 = state_13029__$1;
(statearr_13032_13065[(2)] = null);

(statearr_13032_13065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (4))){
var inst_12993 = (state_13029[(7)]);
var inst_12995 = (inst_12993 < cnt);
var state_13029__$1 = state_13029;
if(cljs.core.truth_(inst_12995)){
var statearr_13033_13066 = state_13029__$1;
(statearr_13033_13066[(1)] = (6));

} else {
var statearr_13034_13067 = state_13029__$1;
(statearr_13034_13067[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (15))){
var inst_13025 = (state_13029[(2)]);
var state_13029__$1 = state_13029;
var statearr_13035_13068 = state_13029__$1;
(statearr_13035_13068[(2)] = inst_13025);

(statearr_13035_13068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (13))){
var inst_13018 = cljs.core.async.close_BANG_.call(null,out);
var state_13029__$1 = state_13029;
var statearr_13036_13069 = state_13029__$1;
(statearr_13036_13069[(2)] = inst_13018);

(statearr_13036_13069[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (6))){
var state_13029__$1 = state_13029;
var statearr_13037_13070 = state_13029__$1;
(statearr_13037_13070[(2)] = null);

(statearr_13037_13070[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (3))){
var inst_13027 = (state_13029[(2)]);
var state_13029__$1 = state_13029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13029__$1,inst_13027);
} else {
if((state_val_13030 === (12))){
var inst_13015 = (state_13029[(8)]);
var inst_13015__$1 = (state_13029[(2)]);
var inst_13016 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13015__$1);
var state_13029__$1 = (function (){var statearr_13038 = state_13029;
(statearr_13038[(8)] = inst_13015__$1);

return statearr_13038;
})();
if(cljs.core.truth_(inst_13016)){
var statearr_13039_13071 = state_13029__$1;
(statearr_13039_13071[(1)] = (13));

} else {
var statearr_13040_13072 = state_13029__$1;
(statearr_13040_13072[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (2))){
var inst_12992 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12993 = (0);
var state_13029__$1 = (function (){var statearr_13041 = state_13029;
(statearr_13041[(7)] = inst_12993);

(statearr_13041[(9)] = inst_12992);

return statearr_13041;
})();
var statearr_13042_13073 = state_13029__$1;
(statearr_13042_13073[(2)] = null);

(statearr_13042_13073[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (11))){
var inst_12993 = (state_13029[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13029,(10),Object,null,(9));
var inst_13002 = chs__$1.call(null,inst_12993);
var inst_13003 = done.call(null,inst_12993);
var inst_13004 = cljs.core.async.take_BANG_.call(null,inst_13002,inst_13003);
var state_13029__$1 = state_13029;
var statearr_13043_13074 = state_13029__$1;
(statearr_13043_13074[(2)] = inst_13004);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13029__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (9))){
var inst_12993 = (state_13029[(7)]);
var inst_13006 = (state_13029[(2)]);
var inst_13007 = (inst_12993 + (1));
var inst_12993__$1 = inst_13007;
var state_13029__$1 = (function (){var statearr_13044 = state_13029;
(statearr_13044[(7)] = inst_12993__$1);

(statearr_13044[(10)] = inst_13006);

return statearr_13044;
})();
var statearr_13045_13075 = state_13029__$1;
(statearr_13045_13075[(2)] = null);

(statearr_13045_13075[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (5))){
var inst_13013 = (state_13029[(2)]);
var state_13029__$1 = (function (){var statearr_13046 = state_13029;
(statearr_13046[(11)] = inst_13013);

return statearr_13046;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13029__$1,(12),dchan);
} else {
if((state_val_13030 === (14))){
var inst_13015 = (state_13029[(8)]);
var inst_13020 = cljs.core.apply.call(null,f,inst_13015);
var state_13029__$1 = state_13029;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13029__$1,(16),out,inst_13020);
} else {
if((state_val_13030 === (16))){
var inst_13022 = (state_13029[(2)]);
var state_13029__$1 = (function (){var statearr_13047 = state_13029;
(statearr_13047[(12)] = inst_13022);

return statearr_13047;
})();
var statearr_13048_13076 = state_13029__$1;
(statearr_13048_13076[(2)] = null);

(statearr_13048_13076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (10))){
var inst_12997 = (state_13029[(2)]);
var inst_12998 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13029__$1 = (function (){var statearr_13049 = state_13029;
(statearr_13049[(13)] = inst_12997);

return statearr_13049;
})();
var statearr_13050_13077 = state_13029__$1;
(statearr_13050_13077[(2)] = inst_12998);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13029__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13030 === (8))){
var inst_13011 = (state_13029[(2)]);
var state_13029__$1 = state_13029;
var statearr_13051_13078 = state_13029__$1;
(statearr_13051_13078[(2)] = inst_13011);

(statearr_13051_13078[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___13063,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10932__auto__,c__11044__auto___13063,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_13055 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13055[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_13055[(1)] = (1));

return statearr_13055;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_13029){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_13029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e13056){if((e13056 instanceof Object)){
var ex__10936__auto__ = e13056;
var statearr_13057_13079 = state_13029;
(statearr_13057_13079[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13029);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13056;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13080 = state_13029;
state_13029 = G__13080;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_13029){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_13029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___13063,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11046__auto__ = (function (){var statearr_13058 = f__11045__auto__.call(null);
(statearr_13058[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___13063);

return statearr_13058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___13063,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13082 = [];
var len__5726__auto___13138 = arguments.length;
var i__5727__auto___13139 = (0);
while(true){
if((i__5727__auto___13139 < len__5726__auto___13138)){
args13082.push((arguments[i__5727__auto___13139]));

var G__13140 = (i__5727__auto___13139 + (1));
i__5727__auto___13139 = G__13140;
continue;
} else {
}
break;
}

var G__13084 = args13082.length;
switch (G__13084) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13082.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___13142 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___13142,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___13142,out){
return (function (state_13114){
var state_val_13115 = (state_13114[(1)]);
if((state_val_13115 === (7))){
var inst_13094 = (state_13114[(7)]);
var inst_13093 = (state_13114[(8)]);
var inst_13093__$1 = (state_13114[(2)]);
var inst_13094__$1 = cljs.core.nth.call(null,inst_13093__$1,(0),null);
var inst_13095 = cljs.core.nth.call(null,inst_13093__$1,(1),null);
var inst_13096 = (inst_13094__$1 == null);
var state_13114__$1 = (function (){var statearr_13116 = state_13114;
(statearr_13116[(9)] = inst_13095);

(statearr_13116[(7)] = inst_13094__$1);

(statearr_13116[(8)] = inst_13093__$1);

return statearr_13116;
})();
if(cljs.core.truth_(inst_13096)){
var statearr_13117_13143 = state_13114__$1;
(statearr_13117_13143[(1)] = (8));

} else {
var statearr_13118_13144 = state_13114__$1;
(statearr_13118_13144[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13115 === (1))){
var inst_13085 = cljs.core.vec.call(null,chs);
var inst_13086 = inst_13085;
var state_13114__$1 = (function (){var statearr_13119 = state_13114;
(statearr_13119[(10)] = inst_13086);

return statearr_13119;
})();
var statearr_13120_13145 = state_13114__$1;
(statearr_13120_13145[(2)] = null);

(statearr_13120_13145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13115 === (4))){
var inst_13086 = (state_13114[(10)]);
var state_13114__$1 = state_13114;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13114__$1,(7),inst_13086);
} else {
if((state_val_13115 === (6))){
var inst_13110 = (state_13114[(2)]);
var state_13114__$1 = state_13114;
var statearr_13121_13146 = state_13114__$1;
(statearr_13121_13146[(2)] = inst_13110);

(statearr_13121_13146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13115 === (3))){
var inst_13112 = (state_13114[(2)]);
var state_13114__$1 = state_13114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13114__$1,inst_13112);
} else {
if((state_val_13115 === (2))){
var inst_13086 = (state_13114[(10)]);
var inst_13088 = cljs.core.count.call(null,inst_13086);
var inst_13089 = (inst_13088 > (0));
var state_13114__$1 = state_13114;
if(cljs.core.truth_(inst_13089)){
var statearr_13123_13147 = state_13114__$1;
(statearr_13123_13147[(1)] = (4));

} else {
var statearr_13124_13148 = state_13114__$1;
(statearr_13124_13148[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13115 === (11))){
var inst_13086 = (state_13114[(10)]);
var inst_13103 = (state_13114[(2)]);
var tmp13122 = inst_13086;
var inst_13086__$1 = tmp13122;
var state_13114__$1 = (function (){var statearr_13125 = state_13114;
(statearr_13125[(10)] = inst_13086__$1);

(statearr_13125[(11)] = inst_13103);

return statearr_13125;
})();
var statearr_13126_13149 = state_13114__$1;
(statearr_13126_13149[(2)] = null);

(statearr_13126_13149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13115 === (9))){
var inst_13094 = (state_13114[(7)]);
var state_13114__$1 = state_13114;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13114__$1,(11),out,inst_13094);
} else {
if((state_val_13115 === (5))){
var inst_13108 = cljs.core.async.close_BANG_.call(null,out);
var state_13114__$1 = state_13114;
var statearr_13127_13150 = state_13114__$1;
(statearr_13127_13150[(2)] = inst_13108);

(statearr_13127_13150[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13115 === (10))){
var inst_13106 = (state_13114[(2)]);
var state_13114__$1 = state_13114;
var statearr_13128_13151 = state_13114__$1;
(statearr_13128_13151[(2)] = inst_13106);

(statearr_13128_13151[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13115 === (8))){
var inst_13086 = (state_13114[(10)]);
var inst_13095 = (state_13114[(9)]);
var inst_13094 = (state_13114[(7)]);
var inst_13093 = (state_13114[(8)]);
var inst_13098 = (function (){var cs = inst_13086;
var vec__13091 = inst_13093;
var v = inst_13094;
var c = inst_13095;
return ((function (cs,vec__13091,v,c,inst_13086,inst_13095,inst_13094,inst_13093,state_val_13115,c__11044__auto___13142,out){
return (function (p1__13081_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13081_SHARP_);
});
;})(cs,vec__13091,v,c,inst_13086,inst_13095,inst_13094,inst_13093,state_val_13115,c__11044__auto___13142,out))
})();
var inst_13099 = cljs.core.filterv.call(null,inst_13098,inst_13086);
var inst_13086__$1 = inst_13099;
var state_13114__$1 = (function (){var statearr_13129 = state_13114;
(statearr_13129[(10)] = inst_13086__$1);

return statearr_13129;
})();
var statearr_13130_13152 = state_13114__$1;
(statearr_13130_13152[(2)] = null);

(statearr_13130_13152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___13142,out))
;
return ((function (switch__10932__auto__,c__11044__auto___13142,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_13134 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13134[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_13134[(1)] = (1));

return statearr_13134;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_13114){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_13114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e13135){if((e13135 instanceof Object)){
var ex__10936__auto__ = e13135;
var statearr_13136_13153 = state_13114;
(statearr_13136_13153[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13114);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13135;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13154 = state_13114;
state_13114 = G__13154;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_13114){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_13114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___13142,out))
})();
var state__11046__auto__ = (function (){var statearr_13137 = f__11045__auto__.call(null);
(statearr_13137[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___13142);

return statearr_13137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___13142,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13155 = [];
var len__5726__auto___13204 = arguments.length;
var i__5727__auto___13205 = (0);
while(true){
if((i__5727__auto___13205 < len__5726__auto___13204)){
args13155.push((arguments[i__5727__auto___13205]));

var G__13206 = (i__5727__auto___13205 + (1));
i__5727__auto___13205 = G__13206;
continue;
} else {
}
break;
}

var G__13157 = args13155.length;
switch (G__13157) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13155.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___13208 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___13208,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___13208,out){
return (function (state_13181){
var state_val_13182 = (state_13181[(1)]);
if((state_val_13182 === (7))){
var inst_13163 = (state_13181[(7)]);
var inst_13163__$1 = (state_13181[(2)]);
var inst_13164 = (inst_13163__$1 == null);
var inst_13165 = cljs.core.not.call(null,inst_13164);
var state_13181__$1 = (function (){var statearr_13183 = state_13181;
(statearr_13183[(7)] = inst_13163__$1);

return statearr_13183;
})();
if(inst_13165){
var statearr_13184_13209 = state_13181__$1;
(statearr_13184_13209[(1)] = (8));

} else {
var statearr_13185_13210 = state_13181__$1;
(statearr_13185_13210[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (1))){
var inst_13158 = (0);
var state_13181__$1 = (function (){var statearr_13186 = state_13181;
(statearr_13186[(8)] = inst_13158);

return statearr_13186;
})();
var statearr_13187_13211 = state_13181__$1;
(statearr_13187_13211[(2)] = null);

(statearr_13187_13211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (4))){
var state_13181__$1 = state_13181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13181__$1,(7),ch);
} else {
if((state_val_13182 === (6))){
var inst_13176 = (state_13181[(2)]);
var state_13181__$1 = state_13181;
var statearr_13188_13212 = state_13181__$1;
(statearr_13188_13212[(2)] = inst_13176);

(statearr_13188_13212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (3))){
var inst_13178 = (state_13181[(2)]);
var inst_13179 = cljs.core.async.close_BANG_.call(null,out);
var state_13181__$1 = (function (){var statearr_13189 = state_13181;
(statearr_13189[(9)] = inst_13178);

return statearr_13189;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13181__$1,inst_13179);
} else {
if((state_val_13182 === (2))){
var inst_13158 = (state_13181[(8)]);
var inst_13160 = (inst_13158 < n);
var state_13181__$1 = state_13181;
if(cljs.core.truth_(inst_13160)){
var statearr_13190_13213 = state_13181__$1;
(statearr_13190_13213[(1)] = (4));

} else {
var statearr_13191_13214 = state_13181__$1;
(statearr_13191_13214[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (11))){
var inst_13158 = (state_13181[(8)]);
var inst_13168 = (state_13181[(2)]);
var inst_13169 = (inst_13158 + (1));
var inst_13158__$1 = inst_13169;
var state_13181__$1 = (function (){var statearr_13192 = state_13181;
(statearr_13192[(8)] = inst_13158__$1);

(statearr_13192[(10)] = inst_13168);

return statearr_13192;
})();
var statearr_13193_13215 = state_13181__$1;
(statearr_13193_13215[(2)] = null);

(statearr_13193_13215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (9))){
var state_13181__$1 = state_13181;
var statearr_13194_13216 = state_13181__$1;
(statearr_13194_13216[(2)] = null);

(statearr_13194_13216[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (5))){
var state_13181__$1 = state_13181;
var statearr_13195_13217 = state_13181__$1;
(statearr_13195_13217[(2)] = null);

(statearr_13195_13217[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (10))){
var inst_13173 = (state_13181[(2)]);
var state_13181__$1 = state_13181;
var statearr_13196_13218 = state_13181__$1;
(statearr_13196_13218[(2)] = inst_13173);

(statearr_13196_13218[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (8))){
var inst_13163 = (state_13181[(7)]);
var state_13181__$1 = state_13181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13181__$1,(11),out,inst_13163);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___13208,out))
;
return ((function (switch__10932__auto__,c__11044__auto___13208,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_13200 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13200[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_13200[(1)] = (1));

return statearr_13200;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_13181){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_13181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e13201){if((e13201 instanceof Object)){
var ex__10936__auto__ = e13201;
var statearr_13202_13219 = state_13181;
(statearr_13202_13219[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13181);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13201;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13220 = state_13181;
state_13181 = G__13220;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_13181){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_13181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___13208,out))
})();
var state__11046__auto__ = (function (){var statearr_13203 = f__11045__auto__.call(null);
(statearr_13203[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___13208);

return statearr_13203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___13208,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13228 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13228 = (function (map_LT_,f,ch,meta13229){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13229 = meta13229;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13230,meta13229__$1){
var self__ = this;
var _13230__$1 = this;
return (new cljs.core.async.t_cljs$core$async13228(self__.map_LT_,self__.f,self__.ch,meta13229__$1));
});

cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13230){
var self__ = this;
var _13230__$1 = this;
return self__.meta13229;
});

cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async13231 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13231 = (function (map_LT_,f,ch,meta13229,_,fn1,meta13232){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta13229 = meta13229;
this._ = _;
this.fn1 = fn1;
this.meta13232 = meta13232;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13231.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_13233,meta13232__$1){
var self__ = this;
var _13233__$1 = this;
return (new cljs.core.async.t_cljs$core$async13231(self__.map_LT_,self__.f,self__.ch,self__.meta13229,self__._,self__.fn1,meta13232__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async13231.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_13233){
var self__ = this;
var _13233__$1 = this;
return self__.meta13232;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13231.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13231.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13231.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async13231.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__13221_SHARP_){
return f1.call(null,(((p1__13221_SHARP_ == null))?null:self__.f.call(null,p1__13221_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async13231.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13229","meta13229",-1189276401,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13228","cljs.core.async/t_cljs$core$async13228",1423397047,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13232","meta13232",-88024486,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async13231.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13231.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13231";

cljs.core.async.t_cljs$core$async13231.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13231");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async13231 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13231(map_LT___$1,f__$1,ch__$1,meta13229__$1,___$2,fn1__$1,meta13232){
return (new cljs.core.async.t_cljs$core$async13231(map_LT___$1,f__$1,ch__$1,meta13229__$1,___$2,fn1__$1,meta13232));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async13231(self__.map_LT_,self__.f,self__.ch,self__.meta13229,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13228.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async13228.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13229","meta13229",-1189276401,null)], null);
});

cljs.core.async.t_cljs$core$async13228.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13228.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13228";

cljs.core.async.t_cljs$core$async13228.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13228");
});

cljs.core.async.__GT_t_cljs$core$async13228 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13228(map_LT___$1,f__$1,ch__$1,meta13229){
return (new cljs.core.async.t_cljs$core$async13228(map_LT___$1,f__$1,ch__$1,meta13229));
});

}

return (new cljs.core.async.t_cljs$core$async13228(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async13237 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13237 = (function (map_GT_,f,ch,meta13238){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta13238 = meta13238;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13237.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13239,meta13238__$1){
var self__ = this;
var _13239__$1 = this;
return (new cljs.core.async.t_cljs$core$async13237(self__.map_GT_,self__.f,self__.ch,meta13238__$1));
});

cljs.core.async.t_cljs$core$async13237.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13239){
var self__ = this;
var _13239__$1 = this;
return self__.meta13238;
});

cljs.core.async.t_cljs$core$async13237.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13237.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13237.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13237.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13237.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13237.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async13237.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13238","meta13238",-965685450,null)], null);
});

cljs.core.async.t_cljs$core$async13237.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13237.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13237";

cljs.core.async.t_cljs$core$async13237.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13237");
});

cljs.core.async.__GT_t_cljs$core$async13237 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13237(map_GT___$1,f__$1,ch__$1,meta13238){
return (new cljs.core.async.t_cljs$core$async13237(map_GT___$1,f__$1,ch__$1,meta13238));
});

}

return (new cljs.core.async.t_cljs$core$async13237(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async13243 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13243 = (function (filter_GT_,p,ch,meta13244){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta13244 = meta13244;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13245,meta13244__$1){
var self__ = this;
var _13245__$1 = this;
return (new cljs.core.async.t_cljs$core$async13243(self__.filter_GT_,self__.p,self__.ch,meta13244__$1));
});

cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13245){
var self__ = this;
var _13245__$1 = this;
return self__.meta13244;
});

cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async13243.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async13243.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13244","meta13244",1129005964,null)], null);
});

cljs.core.async.t_cljs$core$async13243.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13243.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13243";

cljs.core.async.t_cljs$core$async13243.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async13243");
});

cljs.core.async.__GT_t_cljs$core$async13243 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13243(filter_GT___$1,p__$1,ch__$1,meta13244){
return (new cljs.core.async.t_cljs$core$async13243(filter_GT___$1,p__$1,ch__$1,meta13244));
});

}

return (new cljs.core.async.t_cljs$core$async13243(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args13246 = [];
var len__5726__auto___13290 = arguments.length;
var i__5727__auto___13291 = (0);
while(true){
if((i__5727__auto___13291 < len__5726__auto___13290)){
args13246.push((arguments[i__5727__auto___13291]));

var G__13292 = (i__5727__auto___13291 + (1));
i__5727__auto___13291 = G__13292;
continue;
} else {
}
break;
}

var G__13248 = args13246.length;
switch (G__13248) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13246.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___13294 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___13294,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___13294,out){
return (function (state_13269){
var state_val_13270 = (state_13269[(1)]);
if((state_val_13270 === (7))){
var inst_13265 = (state_13269[(2)]);
var state_13269__$1 = state_13269;
var statearr_13271_13295 = state_13269__$1;
(statearr_13271_13295[(2)] = inst_13265);

(statearr_13271_13295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13270 === (1))){
var state_13269__$1 = state_13269;
var statearr_13272_13296 = state_13269__$1;
(statearr_13272_13296[(2)] = null);

(statearr_13272_13296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13270 === (4))){
var inst_13251 = (state_13269[(7)]);
var inst_13251__$1 = (state_13269[(2)]);
var inst_13252 = (inst_13251__$1 == null);
var state_13269__$1 = (function (){var statearr_13273 = state_13269;
(statearr_13273[(7)] = inst_13251__$1);

return statearr_13273;
})();
if(cljs.core.truth_(inst_13252)){
var statearr_13274_13297 = state_13269__$1;
(statearr_13274_13297[(1)] = (5));

} else {
var statearr_13275_13298 = state_13269__$1;
(statearr_13275_13298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13270 === (6))){
var inst_13251 = (state_13269[(7)]);
var inst_13256 = p.call(null,inst_13251);
var state_13269__$1 = state_13269;
if(cljs.core.truth_(inst_13256)){
var statearr_13276_13299 = state_13269__$1;
(statearr_13276_13299[(1)] = (8));

} else {
var statearr_13277_13300 = state_13269__$1;
(statearr_13277_13300[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13270 === (3))){
var inst_13267 = (state_13269[(2)]);
var state_13269__$1 = state_13269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13269__$1,inst_13267);
} else {
if((state_val_13270 === (2))){
var state_13269__$1 = state_13269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13269__$1,(4),ch);
} else {
if((state_val_13270 === (11))){
var inst_13259 = (state_13269[(2)]);
var state_13269__$1 = state_13269;
var statearr_13278_13301 = state_13269__$1;
(statearr_13278_13301[(2)] = inst_13259);

(statearr_13278_13301[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13270 === (9))){
var state_13269__$1 = state_13269;
var statearr_13279_13302 = state_13269__$1;
(statearr_13279_13302[(2)] = null);

(statearr_13279_13302[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13270 === (5))){
var inst_13254 = cljs.core.async.close_BANG_.call(null,out);
var state_13269__$1 = state_13269;
var statearr_13280_13303 = state_13269__$1;
(statearr_13280_13303[(2)] = inst_13254);

(statearr_13280_13303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13270 === (10))){
var inst_13262 = (state_13269[(2)]);
var state_13269__$1 = (function (){var statearr_13281 = state_13269;
(statearr_13281[(8)] = inst_13262);

return statearr_13281;
})();
var statearr_13282_13304 = state_13269__$1;
(statearr_13282_13304[(2)] = null);

(statearr_13282_13304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13270 === (8))){
var inst_13251 = (state_13269[(7)]);
var state_13269__$1 = state_13269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13269__$1,(11),out,inst_13251);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___13294,out))
;
return ((function (switch__10932__auto__,c__11044__auto___13294,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_13286 = [null,null,null,null,null,null,null,null,null];
(statearr_13286[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_13286[(1)] = (1));

return statearr_13286;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_13269){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_13269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e13287){if((e13287 instanceof Object)){
var ex__10936__auto__ = e13287;
var statearr_13288_13305 = state_13269;
(statearr_13288_13305[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13287;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13306 = state_13269;
state_13269 = G__13306;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_13269){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_13269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___13294,out))
})();
var state__11046__auto__ = (function (){var statearr_13289 = f__11045__auto__.call(null);
(statearr_13289[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___13294);

return statearr_13289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___13294,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args13307 = [];
var len__5726__auto___13310 = arguments.length;
var i__5727__auto___13311 = (0);
while(true){
if((i__5727__auto___13311 < len__5726__auto___13310)){
args13307.push((arguments[i__5727__auto___13311]));

var G__13312 = (i__5727__auto___13311 + (1));
i__5727__auto___13311 = G__13312;
continue;
} else {
}
break;
}

var G__13309 = args13307.length;
switch (G__13309) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13307.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11044__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto__){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto__){
return (function (state_13479){
var state_val_13480 = (state_13479[(1)]);
if((state_val_13480 === (7))){
var inst_13475 = (state_13479[(2)]);
var state_13479__$1 = state_13479;
var statearr_13481_13522 = state_13479__$1;
(statearr_13481_13522[(2)] = inst_13475);

(statearr_13481_13522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (20))){
var inst_13445 = (state_13479[(7)]);
var inst_13456 = (state_13479[(2)]);
var inst_13457 = cljs.core.next.call(null,inst_13445);
var inst_13431 = inst_13457;
var inst_13432 = null;
var inst_13433 = (0);
var inst_13434 = (0);
var state_13479__$1 = (function (){var statearr_13482 = state_13479;
(statearr_13482[(8)] = inst_13456);

(statearr_13482[(9)] = inst_13432);

(statearr_13482[(10)] = inst_13434);

(statearr_13482[(11)] = inst_13433);

(statearr_13482[(12)] = inst_13431);

return statearr_13482;
})();
var statearr_13483_13523 = state_13479__$1;
(statearr_13483_13523[(2)] = null);

(statearr_13483_13523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (1))){
var state_13479__$1 = state_13479;
var statearr_13484_13524 = state_13479__$1;
(statearr_13484_13524[(2)] = null);

(statearr_13484_13524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (4))){
var inst_13420 = (state_13479[(13)]);
var inst_13420__$1 = (state_13479[(2)]);
var inst_13421 = (inst_13420__$1 == null);
var state_13479__$1 = (function (){var statearr_13485 = state_13479;
(statearr_13485[(13)] = inst_13420__$1);

return statearr_13485;
})();
if(cljs.core.truth_(inst_13421)){
var statearr_13486_13525 = state_13479__$1;
(statearr_13486_13525[(1)] = (5));

} else {
var statearr_13487_13526 = state_13479__$1;
(statearr_13487_13526[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (15))){
var state_13479__$1 = state_13479;
var statearr_13491_13527 = state_13479__$1;
(statearr_13491_13527[(2)] = null);

(statearr_13491_13527[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (21))){
var state_13479__$1 = state_13479;
var statearr_13492_13528 = state_13479__$1;
(statearr_13492_13528[(2)] = null);

(statearr_13492_13528[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (13))){
var inst_13432 = (state_13479[(9)]);
var inst_13434 = (state_13479[(10)]);
var inst_13433 = (state_13479[(11)]);
var inst_13431 = (state_13479[(12)]);
var inst_13441 = (state_13479[(2)]);
var inst_13442 = (inst_13434 + (1));
var tmp13488 = inst_13432;
var tmp13489 = inst_13433;
var tmp13490 = inst_13431;
var inst_13431__$1 = tmp13490;
var inst_13432__$1 = tmp13488;
var inst_13433__$1 = tmp13489;
var inst_13434__$1 = inst_13442;
var state_13479__$1 = (function (){var statearr_13493 = state_13479;
(statearr_13493[(9)] = inst_13432__$1);

(statearr_13493[(10)] = inst_13434__$1);

(statearr_13493[(14)] = inst_13441);

(statearr_13493[(11)] = inst_13433__$1);

(statearr_13493[(12)] = inst_13431__$1);

return statearr_13493;
})();
var statearr_13494_13529 = state_13479__$1;
(statearr_13494_13529[(2)] = null);

(statearr_13494_13529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (22))){
var state_13479__$1 = state_13479;
var statearr_13495_13530 = state_13479__$1;
(statearr_13495_13530[(2)] = null);

(statearr_13495_13530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (6))){
var inst_13420 = (state_13479[(13)]);
var inst_13429 = f.call(null,inst_13420);
var inst_13430 = cljs.core.seq.call(null,inst_13429);
var inst_13431 = inst_13430;
var inst_13432 = null;
var inst_13433 = (0);
var inst_13434 = (0);
var state_13479__$1 = (function (){var statearr_13496 = state_13479;
(statearr_13496[(9)] = inst_13432);

(statearr_13496[(10)] = inst_13434);

(statearr_13496[(11)] = inst_13433);

(statearr_13496[(12)] = inst_13431);

return statearr_13496;
})();
var statearr_13497_13531 = state_13479__$1;
(statearr_13497_13531[(2)] = null);

(statearr_13497_13531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (17))){
var inst_13445 = (state_13479[(7)]);
var inst_13449 = cljs.core.chunk_first.call(null,inst_13445);
var inst_13450 = cljs.core.chunk_rest.call(null,inst_13445);
var inst_13451 = cljs.core.count.call(null,inst_13449);
var inst_13431 = inst_13450;
var inst_13432 = inst_13449;
var inst_13433 = inst_13451;
var inst_13434 = (0);
var state_13479__$1 = (function (){var statearr_13498 = state_13479;
(statearr_13498[(9)] = inst_13432);

(statearr_13498[(10)] = inst_13434);

(statearr_13498[(11)] = inst_13433);

(statearr_13498[(12)] = inst_13431);

return statearr_13498;
})();
var statearr_13499_13532 = state_13479__$1;
(statearr_13499_13532[(2)] = null);

(statearr_13499_13532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (3))){
var inst_13477 = (state_13479[(2)]);
var state_13479__$1 = state_13479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13479__$1,inst_13477);
} else {
if((state_val_13480 === (12))){
var inst_13465 = (state_13479[(2)]);
var state_13479__$1 = state_13479;
var statearr_13500_13533 = state_13479__$1;
(statearr_13500_13533[(2)] = inst_13465);

(statearr_13500_13533[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (2))){
var state_13479__$1 = state_13479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13479__$1,(4),in$);
} else {
if((state_val_13480 === (23))){
var inst_13473 = (state_13479[(2)]);
var state_13479__$1 = state_13479;
var statearr_13501_13534 = state_13479__$1;
(statearr_13501_13534[(2)] = inst_13473);

(statearr_13501_13534[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (19))){
var inst_13460 = (state_13479[(2)]);
var state_13479__$1 = state_13479;
var statearr_13502_13535 = state_13479__$1;
(statearr_13502_13535[(2)] = inst_13460);

(statearr_13502_13535[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (11))){
var inst_13445 = (state_13479[(7)]);
var inst_13431 = (state_13479[(12)]);
var inst_13445__$1 = cljs.core.seq.call(null,inst_13431);
var state_13479__$1 = (function (){var statearr_13503 = state_13479;
(statearr_13503[(7)] = inst_13445__$1);

return statearr_13503;
})();
if(inst_13445__$1){
var statearr_13504_13536 = state_13479__$1;
(statearr_13504_13536[(1)] = (14));

} else {
var statearr_13505_13537 = state_13479__$1;
(statearr_13505_13537[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (9))){
var inst_13467 = (state_13479[(2)]);
var inst_13468 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13479__$1 = (function (){var statearr_13506 = state_13479;
(statearr_13506[(15)] = inst_13467);

return statearr_13506;
})();
if(cljs.core.truth_(inst_13468)){
var statearr_13507_13538 = state_13479__$1;
(statearr_13507_13538[(1)] = (21));

} else {
var statearr_13508_13539 = state_13479__$1;
(statearr_13508_13539[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (5))){
var inst_13423 = cljs.core.async.close_BANG_.call(null,out);
var state_13479__$1 = state_13479;
var statearr_13509_13540 = state_13479__$1;
(statearr_13509_13540[(2)] = inst_13423);

(statearr_13509_13540[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (14))){
var inst_13445 = (state_13479[(7)]);
var inst_13447 = cljs.core.chunked_seq_QMARK_.call(null,inst_13445);
var state_13479__$1 = state_13479;
if(inst_13447){
var statearr_13510_13541 = state_13479__$1;
(statearr_13510_13541[(1)] = (17));

} else {
var statearr_13511_13542 = state_13479__$1;
(statearr_13511_13542[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (16))){
var inst_13463 = (state_13479[(2)]);
var state_13479__$1 = state_13479;
var statearr_13512_13543 = state_13479__$1;
(statearr_13512_13543[(2)] = inst_13463);

(statearr_13512_13543[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13480 === (10))){
var inst_13432 = (state_13479[(9)]);
var inst_13434 = (state_13479[(10)]);
var inst_13439 = cljs.core._nth.call(null,inst_13432,inst_13434);
var state_13479__$1 = state_13479;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13479__$1,(13),out,inst_13439);
} else {
if((state_val_13480 === (18))){
var inst_13445 = (state_13479[(7)]);
var inst_13454 = cljs.core.first.call(null,inst_13445);
var state_13479__$1 = state_13479;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13479__$1,(20),out,inst_13454);
} else {
if((state_val_13480 === (8))){
var inst_13434 = (state_13479[(10)]);
var inst_13433 = (state_13479[(11)]);
var inst_13436 = (inst_13434 < inst_13433);
var inst_13437 = inst_13436;
var state_13479__$1 = state_13479;
if(cljs.core.truth_(inst_13437)){
var statearr_13513_13544 = state_13479__$1;
(statearr_13513_13544[(1)] = (10));

} else {
var statearr_13514_13545 = state_13479__$1;
(statearr_13514_13545[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto__))
;
return ((function (switch__10932__auto__,c__11044__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____0 = (function (){
var statearr_13518 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13518[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__);

(statearr_13518[(1)] = (1));

return statearr_13518;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____1 = (function (state_13479){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_13479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e13519){if((e13519 instanceof Object)){
var ex__10936__auto__ = e13519;
var statearr_13520_13546 = state_13479;
(statearr_13520_13546[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13479);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13519;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13547 = state_13479;
state_13479 = G__13547;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__ = function(state_13479){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____1.call(this,state_13479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10933__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto__))
})();
var state__11046__auto__ = (function (){var statearr_13521 = f__11045__auto__.call(null);
(statearr_13521[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto__);

return statearr_13521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto__))
);

return c__11044__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13548 = [];
var len__5726__auto___13551 = arguments.length;
var i__5727__auto___13552 = (0);
while(true){
if((i__5727__auto___13552 < len__5726__auto___13551)){
args13548.push((arguments[i__5727__auto___13552]));

var G__13553 = (i__5727__auto___13552 + (1));
i__5727__auto___13552 = G__13553;
continue;
} else {
}
break;
}

var G__13550 = args13548.length;
switch (G__13550) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13548.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13555 = [];
var len__5726__auto___13558 = arguments.length;
var i__5727__auto___13559 = (0);
while(true){
if((i__5727__auto___13559 < len__5726__auto___13558)){
args13555.push((arguments[i__5727__auto___13559]));

var G__13560 = (i__5727__auto___13559 + (1));
i__5727__auto___13559 = G__13560;
continue;
} else {
}
break;
}

var G__13557 = args13555.length;
switch (G__13557) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13555.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13562 = [];
var len__5726__auto___13613 = arguments.length;
var i__5727__auto___13614 = (0);
while(true){
if((i__5727__auto___13614 < len__5726__auto___13613)){
args13562.push((arguments[i__5727__auto___13614]));

var G__13615 = (i__5727__auto___13614 + (1));
i__5727__auto___13614 = G__13615;
continue;
} else {
}
break;
}

var G__13564 = args13562.length;
switch (G__13564) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13562.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___13617 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___13617,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___13617,out){
return (function (state_13588){
var state_val_13589 = (state_13588[(1)]);
if((state_val_13589 === (7))){
var inst_13583 = (state_13588[(2)]);
var state_13588__$1 = state_13588;
var statearr_13590_13618 = state_13588__$1;
(statearr_13590_13618[(2)] = inst_13583);

(statearr_13590_13618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13589 === (1))){
var inst_13565 = null;
var state_13588__$1 = (function (){var statearr_13591 = state_13588;
(statearr_13591[(7)] = inst_13565);

return statearr_13591;
})();
var statearr_13592_13619 = state_13588__$1;
(statearr_13592_13619[(2)] = null);

(statearr_13592_13619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13589 === (4))){
var inst_13568 = (state_13588[(8)]);
var inst_13568__$1 = (state_13588[(2)]);
var inst_13569 = (inst_13568__$1 == null);
var inst_13570 = cljs.core.not.call(null,inst_13569);
var state_13588__$1 = (function (){var statearr_13593 = state_13588;
(statearr_13593[(8)] = inst_13568__$1);

return statearr_13593;
})();
if(inst_13570){
var statearr_13594_13620 = state_13588__$1;
(statearr_13594_13620[(1)] = (5));

} else {
var statearr_13595_13621 = state_13588__$1;
(statearr_13595_13621[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13589 === (6))){
var state_13588__$1 = state_13588;
var statearr_13596_13622 = state_13588__$1;
(statearr_13596_13622[(2)] = null);

(statearr_13596_13622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13589 === (3))){
var inst_13585 = (state_13588[(2)]);
var inst_13586 = cljs.core.async.close_BANG_.call(null,out);
var state_13588__$1 = (function (){var statearr_13597 = state_13588;
(statearr_13597[(9)] = inst_13585);

return statearr_13597;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13588__$1,inst_13586);
} else {
if((state_val_13589 === (2))){
var state_13588__$1 = state_13588;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13588__$1,(4),ch);
} else {
if((state_val_13589 === (11))){
var inst_13568 = (state_13588[(8)]);
var inst_13577 = (state_13588[(2)]);
var inst_13565 = inst_13568;
var state_13588__$1 = (function (){var statearr_13598 = state_13588;
(statearr_13598[(10)] = inst_13577);

(statearr_13598[(7)] = inst_13565);

return statearr_13598;
})();
var statearr_13599_13623 = state_13588__$1;
(statearr_13599_13623[(2)] = null);

(statearr_13599_13623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13589 === (9))){
var inst_13568 = (state_13588[(8)]);
var state_13588__$1 = state_13588;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13588__$1,(11),out,inst_13568);
} else {
if((state_val_13589 === (5))){
var inst_13568 = (state_13588[(8)]);
var inst_13565 = (state_13588[(7)]);
var inst_13572 = cljs.core._EQ_.call(null,inst_13568,inst_13565);
var state_13588__$1 = state_13588;
if(inst_13572){
var statearr_13601_13624 = state_13588__$1;
(statearr_13601_13624[(1)] = (8));

} else {
var statearr_13602_13625 = state_13588__$1;
(statearr_13602_13625[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13589 === (10))){
var inst_13580 = (state_13588[(2)]);
var state_13588__$1 = state_13588;
var statearr_13603_13626 = state_13588__$1;
(statearr_13603_13626[(2)] = inst_13580);

(statearr_13603_13626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13589 === (8))){
var inst_13565 = (state_13588[(7)]);
var tmp13600 = inst_13565;
var inst_13565__$1 = tmp13600;
var state_13588__$1 = (function (){var statearr_13604 = state_13588;
(statearr_13604[(7)] = inst_13565__$1);

return statearr_13604;
})();
var statearr_13605_13627 = state_13588__$1;
(statearr_13605_13627[(2)] = null);

(statearr_13605_13627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___13617,out))
;
return ((function (switch__10932__auto__,c__11044__auto___13617,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_13609 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13609[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_13609[(1)] = (1));

return statearr_13609;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_13588){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_13588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e13610){if((e13610 instanceof Object)){
var ex__10936__auto__ = e13610;
var statearr_13611_13628 = state_13588;
(statearr_13611_13628[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13588);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13610;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13629 = state_13588;
state_13588 = G__13629;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_13588){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_13588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___13617,out))
})();
var state__11046__auto__ = (function (){var statearr_13612 = f__11045__auto__.call(null);
(statearr_13612[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___13617);

return statearr_13612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___13617,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13630 = [];
var len__5726__auto___13700 = arguments.length;
var i__5727__auto___13701 = (0);
while(true){
if((i__5727__auto___13701 < len__5726__auto___13700)){
args13630.push((arguments[i__5727__auto___13701]));

var G__13702 = (i__5727__auto___13701 + (1));
i__5727__auto___13701 = G__13702;
continue;
} else {
}
break;
}

var G__13632 = args13630.length;
switch (G__13632) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13630.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___13704 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___13704,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___13704,out){
return (function (state_13670){
var state_val_13671 = (state_13670[(1)]);
if((state_val_13671 === (7))){
var inst_13666 = (state_13670[(2)]);
var state_13670__$1 = state_13670;
var statearr_13672_13705 = state_13670__$1;
(statearr_13672_13705[(2)] = inst_13666);

(statearr_13672_13705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (1))){
var inst_13633 = (new Array(n));
var inst_13634 = inst_13633;
var inst_13635 = (0);
var state_13670__$1 = (function (){var statearr_13673 = state_13670;
(statearr_13673[(7)] = inst_13634);

(statearr_13673[(8)] = inst_13635);

return statearr_13673;
})();
var statearr_13674_13706 = state_13670__$1;
(statearr_13674_13706[(2)] = null);

(statearr_13674_13706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (4))){
var inst_13638 = (state_13670[(9)]);
var inst_13638__$1 = (state_13670[(2)]);
var inst_13639 = (inst_13638__$1 == null);
var inst_13640 = cljs.core.not.call(null,inst_13639);
var state_13670__$1 = (function (){var statearr_13675 = state_13670;
(statearr_13675[(9)] = inst_13638__$1);

return statearr_13675;
})();
if(inst_13640){
var statearr_13676_13707 = state_13670__$1;
(statearr_13676_13707[(1)] = (5));

} else {
var statearr_13677_13708 = state_13670__$1;
(statearr_13677_13708[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (15))){
var inst_13660 = (state_13670[(2)]);
var state_13670__$1 = state_13670;
var statearr_13678_13709 = state_13670__$1;
(statearr_13678_13709[(2)] = inst_13660);

(statearr_13678_13709[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (13))){
var state_13670__$1 = state_13670;
var statearr_13679_13710 = state_13670__$1;
(statearr_13679_13710[(2)] = null);

(statearr_13679_13710[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (6))){
var inst_13635 = (state_13670[(8)]);
var inst_13656 = (inst_13635 > (0));
var state_13670__$1 = state_13670;
if(cljs.core.truth_(inst_13656)){
var statearr_13680_13711 = state_13670__$1;
(statearr_13680_13711[(1)] = (12));

} else {
var statearr_13681_13712 = state_13670__$1;
(statearr_13681_13712[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (3))){
var inst_13668 = (state_13670[(2)]);
var state_13670__$1 = state_13670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13670__$1,inst_13668);
} else {
if((state_val_13671 === (12))){
var inst_13634 = (state_13670[(7)]);
var inst_13658 = cljs.core.vec.call(null,inst_13634);
var state_13670__$1 = state_13670;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13670__$1,(15),out,inst_13658);
} else {
if((state_val_13671 === (2))){
var state_13670__$1 = state_13670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13670__$1,(4),ch);
} else {
if((state_val_13671 === (11))){
var inst_13650 = (state_13670[(2)]);
var inst_13651 = (new Array(n));
var inst_13634 = inst_13651;
var inst_13635 = (0);
var state_13670__$1 = (function (){var statearr_13682 = state_13670;
(statearr_13682[(7)] = inst_13634);

(statearr_13682[(8)] = inst_13635);

(statearr_13682[(10)] = inst_13650);

return statearr_13682;
})();
var statearr_13683_13713 = state_13670__$1;
(statearr_13683_13713[(2)] = null);

(statearr_13683_13713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (9))){
var inst_13634 = (state_13670[(7)]);
var inst_13648 = cljs.core.vec.call(null,inst_13634);
var state_13670__$1 = state_13670;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13670__$1,(11),out,inst_13648);
} else {
if((state_val_13671 === (5))){
var inst_13638 = (state_13670[(9)]);
var inst_13634 = (state_13670[(7)]);
var inst_13635 = (state_13670[(8)]);
var inst_13643 = (state_13670[(11)]);
var inst_13642 = (inst_13634[inst_13635] = inst_13638);
var inst_13643__$1 = (inst_13635 + (1));
var inst_13644 = (inst_13643__$1 < n);
var state_13670__$1 = (function (){var statearr_13684 = state_13670;
(statearr_13684[(12)] = inst_13642);

(statearr_13684[(11)] = inst_13643__$1);

return statearr_13684;
})();
if(cljs.core.truth_(inst_13644)){
var statearr_13685_13714 = state_13670__$1;
(statearr_13685_13714[(1)] = (8));

} else {
var statearr_13686_13715 = state_13670__$1;
(statearr_13686_13715[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (14))){
var inst_13663 = (state_13670[(2)]);
var inst_13664 = cljs.core.async.close_BANG_.call(null,out);
var state_13670__$1 = (function (){var statearr_13688 = state_13670;
(statearr_13688[(13)] = inst_13663);

return statearr_13688;
})();
var statearr_13689_13716 = state_13670__$1;
(statearr_13689_13716[(2)] = inst_13664);

(statearr_13689_13716[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (10))){
var inst_13654 = (state_13670[(2)]);
var state_13670__$1 = state_13670;
var statearr_13690_13717 = state_13670__$1;
(statearr_13690_13717[(2)] = inst_13654);

(statearr_13690_13717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13671 === (8))){
var inst_13634 = (state_13670[(7)]);
var inst_13643 = (state_13670[(11)]);
var tmp13687 = inst_13634;
var inst_13634__$1 = tmp13687;
var inst_13635 = inst_13643;
var state_13670__$1 = (function (){var statearr_13691 = state_13670;
(statearr_13691[(7)] = inst_13634__$1);

(statearr_13691[(8)] = inst_13635);

return statearr_13691;
})();
var statearr_13692_13718 = state_13670__$1;
(statearr_13692_13718[(2)] = null);

(statearr_13692_13718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___13704,out))
;
return ((function (switch__10932__auto__,c__11044__auto___13704,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_13696 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13696[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_13696[(1)] = (1));

return statearr_13696;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_13670){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_13670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e13697){if((e13697 instanceof Object)){
var ex__10936__auto__ = e13697;
var statearr_13698_13719 = state_13670;
(statearr_13698_13719[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13670);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13697;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13720 = state_13670;
state_13670 = G__13720;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_13670){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_13670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___13704,out))
})();
var state__11046__auto__ = (function (){var statearr_13699 = f__11045__auto__.call(null);
(statearr_13699[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___13704);

return statearr_13699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___13704,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13721 = [];
var len__5726__auto___13795 = arguments.length;
var i__5727__auto___13796 = (0);
while(true){
if((i__5727__auto___13796 < len__5726__auto___13795)){
args13721.push((arguments[i__5727__auto___13796]));

var G__13797 = (i__5727__auto___13796 + (1));
i__5727__auto___13796 = G__13797;
continue;
} else {
}
break;
}

var G__13723 = args13721.length;
switch (G__13723) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13721.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11044__auto___13799 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11044__auto___13799,out){
return (function (){
var f__11045__auto__ = (function (){var switch__10932__auto__ = ((function (c__11044__auto___13799,out){
return (function (state_13765){
var state_val_13766 = (state_13765[(1)]);
if((state_val_13766 === (7))){
var inst_13761 = (state_13765[(2)]);
var state_13765__$1 = state_13765;
var statearr_13767_13800 = state_13765__$1;
(statearr_13767_13800[(2)] = inst_13761);

(statearr_13767_13800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (1))){
var inst_13724 = [];
var inst_13725 = inst_13724;
var inst_13726 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13765__$1 = (function (){var statearr_13768 = state_13765;
(statearr_13768[(7)] = inst_13726);

(statearr_13768[(8)] = inst_13725);

return statearr_13768;
})();
var statearr_13769_13801 = state_13765__$1;
(statearr_13769_13801[(2)] = null);

(statearr_13769_13801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (4))){
var inst_13729 = (state_13765[(9)]);
var inst_13729__$1 = (state_13765[(2)]);
var inst_13730 = (inst_13729__$1 == null);
var inst_13731 = cljs.core.not.call(null,inst_13730);
var state_13765__$1 = (function (){var statearr_13770 = state_13765;
(statearr_13770[(9)] = inst_13729__$1);

return statearr_13770;
})();
if(inst_13731){
var statearr_13771_13802 = state_13765__$1;
(statearr_13771_13802[(1)] = (5));

} else {
var statearr_13772_13803 = state_13765__$1;
(statearr_13772_13803[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (15))){
var inst_13755 = (state_13765[(2)]);
var state_13765__$1 = state_13765;
var statearr_13773_13804 = state_13765__$1;
(statearr_13773_13804[(2)] = inst_13755);

(statearr_13773_13804[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (13))){
var state_13765__$1 = state_13765;
var statearr_13774_13805 = state_13765__$1;
(statearr_13774_13805[(2)] = null);

(statearr_13774_13805[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (6))){
var inst_13725 = (state_13765[(8)]);
var inst_13750 = inst_13725.length;
var inst_13751 = (inst_13750 > (0));
var state_13765__$1 = state_13765;
if(cljs.core.truth_(inst_13751)){
var statearr_13775_13806 = state_13765__$1;
(statearr_13775_13806[(1)] = (12));

} else {
var statearr_13776_13807 = state_13765__$1;
(statearr_13776_13807[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (3))){
var inst_13763 = (state_13765[(2)]);
var state_13765__$1 = state_13765;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13765__$1,inst_13763);
} else {
if((state_val_13766 === (12))){
var inst_13725 = (state_13765[(8)]);
var inst_13753 = cljs.core.vec.call(null,inst_13725);
var state_13765__$1 = state_13765;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13765__$1,(15),out,inst_13753);
} else {
if((state_val_13766 === (2))){
var state_13765__$1 = state_13765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13765__$1,(4),ch);
} else {
if((state_val_13766 === (11))){
var inst_13733 = (state_13765[(10)]);
var inst_13729 = (state_13765[(9)]);
var inst_13743 = (state_13765[(2)]);
var inst_13744 = [];
var inst_13745 = inst_13744.push(inst_13729);
var inst_13725 = inst_13744;
var inst_13726 = inst_13733;
var state_13765__$1 = (function (){var statearr_13777 = state_13765;
(statearr_13777[(11)] = inst_13745);

(statearr_13777[(7)] = inst_13726);

(statearr_13777[(12)] = inst_13743);

(statearr_13777[(8)] = inst_13725);

return statearr_13777;
})();
var statearr_13778_13808 = state_13765__$1;
(statearr_13778_13808[(2)] = null);

(statearr_13778_13808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (9))){
var inst_13725 = (state_13765[(8)]);
var inst_13741 = cljs.core.vec.call(null,inst_13725);
var state_13765__$1 = state_13765;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13765__$1,(11),out,inst_13741);
} else {
if((state_val_13766 === (5))){
var inst_13733 = (state_13765[(10)]);
var inst_13729 = (state_13765[(9)]);
var inst_13726 = (state_13765[(7)]);
var inst_13733__$1 = f.call(null,inst_13729);
var inst_13734 = cljs.core._EQ_.call(null,inst_13733__$1,inst_13726);
var inst_13735 = cljs.core.keyword_identical_QMARK_.call(null,inst_13726,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13736 = (inst_13734) || (inst_13735);
var state_13765__$1 = (function (){var statearr_13779 = state_13765;
(statearr_13779[(10)] = inst_13733__$1);

return statearr_13779;
})();
if(cljs.core.truth_(inst_13736)){
var statearr_13780_13809 = state_13765__$1;
(statearr_13780_13809[(1)] = (8));

} else {
var statearr_13781_13810 = state_13765__$1;
(statearr_13781_13810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (14))){
var inst_13758 = (state_13765[(2)]);
var inst_13759 = cljs.core.async.close_BANG_.call(null,out);
var state_13765__$1 = (function (){var statearr_13783 = state_13765;
(statearr_13783[(13)] = inst_13758);

return statearr_13783;
})();
var statearr_13784_13811 = state_13765__$1;
(statearr_13784_13811[(2)] = inst_13759);

(statearr_13784_13811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (10))){
var inst_13748 = (state_13765[(2)]);
var state_13765__$1 = state_13765;
var statearr_13785_13812 = state_13765__$1;
(statearr_13785_13812[(2)] = inst_13748);

(statearr_13785_13812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13766 === (8))){
var inst_13733 = (state_13765[(10)]);
var inst_13729 = (state_13765[(9)]);
var inst_13725 = (state_13765[(8)]);
var inst_13738 = inst_13725.push(inst_13729);
var tmp13782 = inst_13725;
var inst_13725__$1 = tmp13782;
var inst_13726 = inst_13733;
var state_13765__$1 = (function (){var statearr_13786 = state_13765;
(statearr_13786[(14)] = inst_13738);

(statearr_13786[(7)] = inst_13726);

(statearr_13786[(8)] = inst_13725__$1);

return statearr_13786;
})();
var statearr_13787_13813 = state_13765__$1;
(statearr_13787_13813[(2)] = null);

(statearr_13787_13813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11044__auto___13799,out))
;
return ((function (switch__10932__auto__,c__11044__auto___13799,out){
return (function() {
var cljs$core$async$state_machine__10933__auto__ = null;
var cljs$core$async$state_machine__10933__auto____0 = (function (){
var statearr_13791 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13791[(0)] = cljs$core$async$state_machine__10933__auto__);

(statearr_13791[(1)] = (1));

return statearr_13791;
});
var cljs$core$async$state_machine__10933__auto____1 = (function (state_13765){
while(true){
var ret_value__10934__auto__ = (function (){try{while(true){
var result__10935__auto__ = switch__10932__auto__.call(null,state_13765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10935__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10935__auto__;
}
break;
}
}catch (e13792){if((e13792 instanceof Object)){
var ex__10936__auto__ = e13792;
var statearr_13793_13814 = state_13765;
(statearr_13793_13814[(5)] = ex__10936__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13765);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13792;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10934__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13815 = state_13765;
state_13765 = G__13815;
continue;
} else {
return ret_value__10934__auto__;
}
break;
}
});
cljs$core$async$state_machine__10933__auto__ = function(state_13765){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10933__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10933__auto____1.call(this,state_13765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10933__auto____0;
cljs$core$async$state_machine__10933__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10933__auto____1;
return cljs$core$async$state_machine__10933__auto__;
})()
;})(switch__10932__auto__,c__11044__auto___13799,out))
})();
var state__11046__auto__ = (function (){var statearr_13794 = f__11045__auto__.call(null);
(statearr_13794[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11044__auto___13799);

return statearr_13794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11046__auto__);
});})(c__11044__auto___13799,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1453923748672