"use strict";

var ZSchema = require("../../src/ZSchema");

function setRemoteReferences(validator) {
    validator.setRemoteReference("http://json-schema.org/draft-04/schema",
                                 require("../files/draft-04-schema.json"));
    validator.setRemoteReference("http://localhost:1234/integer.json",
                                 require("../jsonSchemaTestSuite/remotes/integer.json"));
    validator.setRemoteReference("http://localhost:1234/subSchemas.json",
                                 require("../jsonSchemaTestSuite/remotes/subSchemas.json"));
    validator.setRemoteReference("http://localhost:1234/folder/folderInteger.json",
                                 require("../jsonSchemaTestSuite/remotes/folder/folderInteger.json"));
}

describe("Basic", function () {

    it("ZSchema constructor should take one argument - options", function () {
        expect(ZSchema.length).toBe(1);
    });

    it("Work in progress test...", function () {
        var validator = new ZSchema();
        setRemoteReferences(validator);

        var schema = [
                {
                    id: "schemaA",
                    type: "integer"
                },
                {
                    id: "schemaB",
                    type: "string"
                },
                {
                    id: "mainSchema",
                    type: "object",
                    properties: {
                        a: { "$ref": "schemaA" },
                        b: { "$ref": "schemaB" },
                        c: { "enum": ["C"] }
                    }
                }
            ];

        var data = {
            a: 1,
            b: "str",
            c: "C"
        };

        var validSchema = validator.validateSchema(schema);
        expect(validSchema).toBe(true);

        if (!validSchema) {
            console.log(validator.getLastErrors());
            return;
        }

        var valid = validator.validate(data, schema[2]);
        expect(valid).toBe(true);

        if (!valid) {
            console.log(validator.getLastErrors());
            return;
        }

    });

});
