"use strict";

module.exports = {
    description: "Issue #12 - validation should fail when missing a reference",
    tests: [
        {
            description: "should pass validation",
            schema: {
                "id": "http://my.site/myschema#",
                "$ref": "#/definitions/schema2",
                "definitions": {
                    "schema1": {
                        "id": "schema1",
                        "type": "integer"
                    },
                    "schema2": {
                        "type": "array",
                        "items": {
                            "$ref": "schema1"
                        }
                    }
                }
            },
            data: [1, 2, 3],
            valid: true
        },
        {
            description: "should fail validation",
            schema: {
                "id": "http://my.site/myschema#",
                "$ref": "#/definitions/schema2",
                "definitions": {
                    "schema1": {
                        "id": "schema1",
                        "type": "integer"
                    },
                    "schema2": {
                        "type": "array",
                        "items": {
                            "$ref": "schema1"
                        }
                    }
                }
            },
            data: ["1", null, 3],
            valid: false
        },
        {
            description: "should fail compilation with unresolvable reference",
            schema: {
                id: "schemaA",
                type: "object",
                properties: {
                    a: {
                        type: "integer"
                    },
                    b: {
                        type: "string"
                    },
                    c: {
                        $ref: "schemaB"
                    }
                },
                required: ["a"]
            },
            validateSchemaOnly: true,
            valid: false,
            after: function (err) {
                expect(err[0].code).toBe("UNRESOLVABLE_REFERENCE");
            }
        }
    ]
};
