// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__20106__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__20105 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__20105,(0),null);
var body = cljs.core.nthnext.call(null,vec__20105,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__20106 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__20107__i = 0, G__20107__a = new Array(arguments.length -  0);
while (G__20107__i < G__20107__a.length) {G__20107__a[G__20107__i] = arguments[G__20107__i + 0]; ++G__20107__i;}
  args = new cljs.core.IndexedSeq(G__20107__a,0);
} 
return G__20106__delegate.call(this,args);};
G__20106.cljs$lang$maxFixedArity = 0;
G__20106.cljs$lang$applyTo = (function (arglist__20108){
var args = cljs.core.seq(arglist__20108);
return G__20106__delegate(args);
});
G__20106.cljs$core$IFn$_invoke$arity$variadic = G__20106__delegate;
return G__20106;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__20113(s__20114){
return (new cljs.core.LazySeq(null,(function (){
var s__20114__$1 = s__20114;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20114__$1);
if(temp__4425__auto__){
var s__20114__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20114__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20114__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20116 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20115 = (0);
while(true){
if((i__20115 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__20115);
cljs.core.chunk_append.call(null,b__20116,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__20117 = (i__20115 + (1));
i__20115 = G__20117;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20116),sablono$core$update_arglists_$_iter__20113.call(null,cljs.core.chunk_rest.call(null,s__20114__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20116),null);
}
} else {
var args = cljs.core.first.call(null,s__20114__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__20113.call(null,cljs.core.rest.call(null,s__20114__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20123 = arguments.length;
var i__5727__auto___20124 = (0);
while(true){
if((i__5727__auto___20124 < len__5726__auto___20123)){
args__5733__auto__.push((arguments[i__5727__auto___20124]));

var G__20125 = (i__5727__auto___20124 + (1));
i__5727__auto___20124 = G__20125;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__20119(s__20120){
return (new cljs.core.LazySeq(null,(function (){
var s__20120__$1 = s__20120;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20120__$1);
if(temp__4425__auto__){
var s__20120__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20120__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20120__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20122 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20121 = (0);
while(true){
if((i__20121 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__20121);
cljs.core.chunk_append.call(null,b__20122,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__20126 = (i__20121 + (1));
i__20121 = G__20126;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20122),sablono$core$iter__20119.call(null,cljs.core.chunk_rest.call(null,s__20120__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20122),null);
}
} else {
var style = cljs.core.first.call(null,s__20120__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__20119.call(null,cljs.core.rest.call(null,s__20120__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq20118){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20118));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to20127 = (function sablono$core$link_to20127(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20130 = arguments.length;
var i__5727__auto___20131 = (0);
while(true){
if((i__5727__auto___20131 < len__5726__auto___20130)){
args__5733__auto__.push((arguments[i__5727__auto___20131]));

var G__20132 = (i__5727__auto___20131 + (1));
i__5727__auto___20131 = G__20132;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to20127.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to20127.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to20127.cljs$lang$maxFixedArity = (1);

sablono.core.link_to20127.cljs$lang$applyTo = (function (seq20128){
var G__20129 = cljs.core.first.call(null,seq20128);
var seq20128__$1 = cljs.core.next.call(null,seq20128);
return sablono.core.link_to20127.cljs$core$IFn$_invoke$arity$variadic(G__20129,seq20128__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to20127);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to20133 = (function sablono$core$mail_to20133(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20138 = arguments.length;
var i__5727__auto___20139 = (0);
while(true){
if((i__5727__auto___20139 < len__5726__auto___20138)){
args__5733__auto__.push((arguments[i__5727__auto___20139]));

var G__20140 = (i__5727__auto___20139 + (1));
i__5727__auto___20139 = G__20140;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to20133.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to20133.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__20136){
var vec__20137 = p__20136;
var content = cljs.core.nth.call(null,vec__20137,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to20133.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to20133.cljs$lang$applyTo = (function (seq20134){
var G__20135 = cljs.core.first.call(null,seq20134);
var seq20134__$1 = cljs.core.next.call(null,seq20134);
return sablono.core.mail_to20133.cljs$core$IFn$_invoke$arity$variadic(G__20135,seq20134__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to20133);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list20141 = (function sablono$core$unordered_list20141(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list20141_$_iter__20146(s__20147){
return (new cljs.core.LazySeq(null,(function (){
var s__20147__$1 = s__20147;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20147__$1);
if(temp__4425__auto__){
var s__20147__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20147__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20147__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20149 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20148 = (0);
while(true){
if((i__20148 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20148);
cljs.core.chunk_append.call(null,b__20149,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20150 = (i__20148 + (1));
i__20148 = G__20150;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20149),sablono$core$unordered_list20141_$_iter__20146.call(null,cljs.core.chunk_rest.call(null,s__20147__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20149),null);
}
} else {
var x = cljs.core.first.call(null,s__20147__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list20141_$_iter__20146.call(null,cljs.core.rest.call(null,s__20147__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list20141);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list20151 = (function sablono$core$ordered_list20151(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list20151_$_iter__20156(s__20157){
return (new cljs.core.LazySeq(null,(function (){
var s__20157__$1 = s__20157;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20157__$1);
if(temp__4425__auto__){
var s__20157__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20157__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20157__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20159 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20158 = (0);
while(true){
if((i__20158 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20158);
cljs.core.chunk_append.call(null,b__20159,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20160 = (i__20158 + (1));
i__20158 = G__20160;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20159),sablono$core$ordered_list20151_$_iter__20156.call(null,cljs.core.chunk_rest.call(null,s__20157__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20159),null);
}
} else {
var x = cljs.core.first.call(null,s__20157__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list20151_$_iter__20156.call(null,cljs.core.rest.call(null,s__20157__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list20151);
/**
 * Create an image element.
 */
sablono.core.image20161 = (function sablono$core$image20161(var_args){
var args20162 = [];
var len__5726__auto___20165 = arguments.length;
var i__5727__auto___20166 = (0);
while(true){
if((i__5727__auto___20166 < len__5726__auto___20165)){
args20162.push((arguments[i__5727__auto___20166]));

var G__20167 = (i__5727__auto___20166 + (1));
i__5727__auto___20166 = G__20167;
continue;
} else {
}
break;
}

var G__20164 = args20162.length;
switch (G__20164) {
case 1:
return sablono.core.image20161.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image20161.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20162.length)].join('')));

}
});

sablono.core.image20161.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image20161.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image20161.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image20161);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__20169_SHARP_,p2__20170_SHARP_){
return [cljs.core.str(p1__20169_SHARP_),cljs.core.str("["),cljs.core.str(p2__20170_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__20171_SHARP_,p2__20172_SHARP_){
return [cljs.core.str(p1__20171_SHARP_),cljs.core.str("-"),cljs.core.str(p2__20172_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field20173 = (function sablono$core$color_field20173(var_args){
var args20174 = [];
var len__5726__auto___20241 = arguments.length;
var i__5727__auto___20242 = (0);
while(true){
if((i__5727__auto___20242 < len__5726__auto___20241)){
args20174.push((arguments[i__5727__auto___20242]));

var G__20243 = (i__5727__auto___20242 + (1));
i__5727__auto___20242 = G__20243;
continue;
} else {
}
break;
}

var G__20176 = args20174.length;
switch (G__20176) {
case 1:
return sablono.core.color_field20173.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field20173.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20174.length)].join('')));

}
});

sablono.core.color_field20173.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.color_field20173.call(null,name__11649__auto__,null);
});

sablono.core.color_field20173.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.color_field20173.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field20173);

/**
 * Creates a date input field.
 */
sablono.core.date_field20177 = (function sablono$core$date_field20177(var_args){
var args20178 = [];
var len__5726__auto___20245 = arguments.length;
var i__5727__auto___20246 = (0);
while(true){
if((i__5727__auto___20246 < len__5726__auto___20245)){
args20178.push((arguments[i__5727__auto___20246]));

var G__20247 = (i__5727__auto___20246 + (1));
i__5727__auto___20246 = G__20247;
continue;
} else {
}
break;
}

var G__20180 = args20178.length;
switch (G__20180) {
case 1:
return sablono.core.date_field20177.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field20177.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20178.length)].join('')));

}
});

sablono.core.date_field20177.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.date_field20177.call(null,name__11649__auto__,null);
});

sablono.core.date_field20177.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.date_field20177.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field20177);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field20181 = (function sablono$core$datetime_field20181(var_args){
var args20182 = [];
var len__5726__auto___20249 = arguments.length;
var i__5727__auto___20250 = (0);
while(true){
if((i__5727__auto___20250 < len__5726__auto___20249)){
args20182.push((arguments[i__5727__auto___20250]));

var G__20251 = (i__5727__auto___20250 + (1));
i__5727__auto___20250 = G__20251;
continue;
} else {
}
break;
}

var G__20184 = args20182.length;
switch (G__20184) {
case 1:
return sablono.core.datetime_field20181.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field20181.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20182.length)].join('')));

}
});

sablono.core.datetime_field20181.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_field20181.call(null,name__11649__auto__,null);
});

sablono.core.datetime_field20181.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_field20181.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field20181);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field20185 = (function sablono$core$datetime_local_field20185(var_args){
var args20186 = [];
var len__5726__auto___20253 = arguments.length;
var i__5727__auto___20254 = (0);
while(true){
if((i__5727__auto___20254 < len__5726__auto___20253)){
args20186.push((arguments[i__5727__auto___20254]));

var G__20255 = (i__5727__auto___20254 + (1));
i__5727__auto___20254 = G__20255;
continue;
} else {
}
break;
}

var G__20188 = args20186.length;
switch (G__20188) {
case 1:
return sablono.core.datetime_local_field20185.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field20185.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20186.length)].join('')));

}
});

sablono.core.datetime_local_field20185.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_local_field20185.call(null,name__11649__auto__,null);
});

sablono.core.datetime_local_field20185.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_local_field20185.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field20185);

/**
 * Creates a email input field.
 */
sablono.core.email_field20189 = (function sablono$core$email_field20189(var_args){
var args20190 = [];
var len__5726__auto___20257 = arguments.length;
var i__5727__auto___20258 = (0);
while(true){
if((i__5727__auto___20258 < len__5726__auto___20257)){
args20190.push((arguments[i__5727__auto___20258]));

var G__20259 = (i__5727__auto___20258 + (1));
i__5727__auto___20258 = G__20259;
continue;
} else {
}
break;
}

var G__20192 = args20190.length;
switch (G__20192) {
case 1:
return sablono.core.email_field20189.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field20189.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20190.length)].join('')));

}
});

sablono.core.email_field20189.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.email_field20189.call(null,name__11649__auto__,null);
});

sablono.core.email_field20189.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.email_field20189.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field20189);

/**
 * Creates a file input field.
 */
sablono.core.file_field20193 = (function sablono$core$file_field20193(var_args){
var args20194 = [];
var len__5726__auto___20261 = arguments.length;
var i__5727__auto___20262 = (0);
while(true){
if((i__5727__auto___20262 < len__5726__auto___20261)){
args20194.push((arguments[i__5727__auto___20262]));

var G__20263 = (i__5727__auto___20262 + (1));
i__5727__auto___20262 = G__20263;
continue;
} else {
}
break;
}

var G__20196 = args20194.length;
switch (G__20196) {
case 1:
return sablono.core.file_field20193.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field20193.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20194.length)].join('')));

}
});

sablono.core.file_field20193.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.file_field20193.call(null,name__11649__auto__,null);
});

sablono.core.file_field20193.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.file_field20193.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field20193);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field20197 = (function sablono$core$hidden_field20197(var_args){
var args20198 = [];
var len__5726__auto___20265 = arguments.length;
var i__5727__auto___20266 = (0);
while(true){
if((i__5727__auto___20266 < len__5726__auto___20265)){
args20198.push((arguments[i__5727__auto___20266]));

var G__20267 = (i__5727__auto___20266 + (1));
i__5727__auto___20266 = G__20267;
continue;
} else {
}
break;
}

var G__20200 = args20198.length;
switch (G__20200) {
case 1:
return sablono.core.hidden_field20197.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field20197.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20198.length)].join('')));

}
});

sablono.core.hidden_field20197.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.hidden_field20197.call(null,name__11649__auto__,null);
});

sablono.core.hidden_field20197.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.hidden_field20197.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field20197);

/**
 * Creates a month input field.
 */
sablono.core.month_field20201 = (function sablono$core$month_field20201(var_args){
var args20202 = [];
var len__5726__auto___20269 = arguments.length;
var i__5727__auto___20270 = (0);
while(true){
if((i__5727__auto___20270 < len__5726__auto___20269)){
args20202.push((arguments[i__5727__auto___20270]));

var G__20271 = (i__5727__auto___20270 + (1));
i__5727__auto___20270 = G__20271;
continue;
} else {
}
break;
}

var G__20204 = args20202.length;
switch (G__20204) {
case 1:
return sablono.core.month_field20201.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field20201.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20202.length)].join('')));

}
});

sablono.core.month_field20201.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.month_field20201.call(null,name__11649__auto__,null);
});

sablono.core.month_field20201.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.month_field20201.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field20201);

/**
 * Creates a number input field.
 */
sablono.core.number_field20205 = (function sablono$core$number_field20205(var_args){
var args20206 = [];
var len__5726__auto___20273 = arguments.length;
var i__5727__auto___20274 = (0);
while(true){
if((i__5727__auto___20274 < len__5726__auto___20273)){
args20206.push((arguments[i__5727__auto___20274]));

var G__20275 = (i__5727__auto___20274 + (1));
i__5727__auto___20274 = G__20275;
continue;
} else {
}
break;
}

var G__20208 = args20206.length;
switch (G__20208) {
case 1:
return sablono.core.number_field20205.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field20205.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20206.length)].join('')));

}
});

sablono.core.number_field20205.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.number_field20205.call(null,name__11649__auto__,null);
});

sablono.core.number_field20205.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.number_field20205.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field20205);

/**
 * Creates a password input field.
 */
sablono.core.password_field20209 = (function sablono$core$password_field20209(var_args){
var args20210 = [];
var len__5726__auto___20277 = arguments.length;
var i__5727__auto___20278 = (0);
while(true){
if((i__5727__auto___20278 < len__5726__auto___20277)){
args20210.push((arguments[i__5727__auto___20278]));

var G__20279 = (i__5727__auto___20278 + (1));
i__5727__auto___20278 = G__20279;
continue;
} else {
}
break;
}

var G__20212 = args20210.length;
switch (G__20212) {
case 1:
return sablono.core.password_field20209.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field20209.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20210.length)].join('')));

}
});

sablono.core.password_field20209.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.password_field20209.call(null,name__11649__auto__,null);
});

sablono.core.password_field20209.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.password_field20209.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field20209);

/**
 * Creates a range input field.
 */
sablono.core.range_field20213 = (function sablono$core$range_field20213(var_args){
var args20214 = [];
var len__5726__auto___20281 = arguments.length;
var i__5727__auto___20282 = (0);
while(true){
if((i__5727__auto___20282 < len__5726__auto___20281)){
args20214.push((arguments[i__5727__auto___20282]));

var G__20283 = (i__5727__auto___20282 + (1));
i__5727__auto___20282 = G__20283;
continue;
} else {
}
break;
}

var G__20216 = args20214.length;
switch (G__20216) {
case 1:
return sablono.core.range_field20213.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field20213.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20214.length)].join('')));

}
});

sablono.core.range_field20213.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.range_field20213.call(null,name__11649__auto__,null);
});

sablono.core.range_field20213.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.range_field20213.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field20213);

/**
 * Creates a search input field.
 */
sablono.core.search_field20217 = (function sablono$core$search_field20217(var_args){
var args20218 = [];
var len__5726__auto___20285 = arguments.length;
var i__5727__auto___20286 = (0);
while(true){
if((i__5727__auto___20286 < len__5726__auto___20285)){
args20218.push((arguments[i__5727__auto___20286]));

var G__20287 = (i__5727__auto___20286 + (1));
i__5727__auto___20286 = G__20287;
continue;
} else {
}
break;
}

var G__20220 = args20218.length;
switch (G__20220) {
case 1:
return sablono.core.search_field20217.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field20217.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20218.length)].join('')));

}
});

sablono.core.search_field20217.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.search_field20217.call(null,name__11649__auto__,null);
});

sablono.core.search_field20217.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.search_field20217.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field20217);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field20221 = (function sablono$core$tel_field20221(var_args){
var args20222 = [];
var len__5726__auto___20289 = arguments.length;
var i__5727__auto___20290 = (0);
while(true){
if((i__5727__auto___20290 < len__5726__auto___20289)){
args20222.push((arguments[i__5727__auto___20290]));

var G__20291 = (i__5727__auto___20290 + (1));
i__5727__auto___20290 = G__20291;
continue;
} else {
}
break;
}

var G__20224 = args20222.length;
switch (G__20224) {
case 1:
return sablono.core.tel_field20221.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field20221.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20222.length)].join('')));

}
});

sablono.core.tel_field20221.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.tel_field20221.call(null,name__11649__auto__,null);
});

sablono.core.tel_field20221.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.tel_field20221.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field20221);

/**
 * Creates a text input field.
 */
sablono.core.text_field20225 = (function sablono$core$text_field20225(var_args){
var args20226 = [];
var len__5726__auto___20293 = arguments.length;
var i__5727__auto___20294 = (0);
while(true){
if((i__5727__auto___20294 < len__5726__auto___20293)){
args20226.push((arguments[i__5727__auto___20294]));

var G__20295 = (i__5727__auto___20294 + (1));
i__5727__auto___20294 = G__20295;
continue;
} else {
}
break;
}

var G__20228 = args20226.length;
switch (G__20228) {
case 1:
return sablono.core.text_field20225.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field20225.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20226.length)].join('')));

}
});

sablono.core.text_field20225.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.text_field20225.call(null,name__11649__auto__,null);
});

sablono.core.text_field20225.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.text_field20225.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field20225);

/**
 * Creates a time input field.
 */
sablono.core.time_field20229 = (function sablono$core$time_field20229(var_args){
var args20230 = [];
var len__5726__auto___20297 = arguments.length;
var i__5727__auto___20298 = (0);
while(true){
if((i__5727__auto___20298 < len__5726__auto___20297)){
args20230.push((arguments[i__5727__auto___20298]));

var G__20299 = (i__5727__auto___20298 + (1));
i__5727__auto___20298 = G__20299;
continue;
} else {
}
break;
}

var G__20232 = args20230.length;
switch (G__20232) {
case 1:
return sablono.core.time_field20229.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field20229.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20230.length)].join('')));

}
});

sablono.core.time_field20229.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.time_field20229.call(null,name__11649__auto__,null);
});

sablono.core.time_field20229.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.time_field20229.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field20229);

/**
 * Creates a url input field.
 */
sablono.core.url_field20233 = (function sablono$core$url_field20233(var_args){
var args20234 = [];
var len__5726__auto___20301 = arguments.length;
var i__5727__auto___20302 = (0);
while(true){
if((i__5727__auto___20302 < len__5726__auto___20301)){
args20234.push((arguments[i__5727__auto___20302]));

var G__20303 = (i__5727__auto___20302 + (1));
i__5727__auto___20302 = G__20303;
continue;
} else {
}
break;
}

var G__20236 = args20234.length;
switch (G__20236) {
case 1:
return sablono.core.url_field20233.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field20233.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20234.length)].join('')));

}
});

sablono.core.url_field20233.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.url_field20233.call(null,name__11649__auto__,null);
});

sablono.core.url_field20233.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.url_field20233.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field20233);

/**
 * Creates a week input field.
 */
sablono.core.week_field20237 = (function sablono$core$week_field20237(var_args){
var args20238 = [];
var len__5726__auto___20305 = arguments.length;
var i__5727__auto___20306 = (0);
while(true){
if((i__5727__auto___20306 < len__5726__auto___20305)){
args20238.push((arguments[i__5727__auto___20306]));

var G__20307 = (i__5727__auto___20306 + (1));
i__5727__auto___20306 = G__20307;
continue;
} else {
}
break;
}

var G__20240 = args20238.length;
switch (G__20240) {
case 1:
return sablono.core.week_field20237.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field20237.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20238.length)].join('')));

}
});

sablono.core.week_field20237.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.week_field20237.call(null,name__11649__auto__,null);
});

sablono.core.week_field20237.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.week_field20237.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field20237);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box20309 = (function sablono$core$check_box20309(var_args){
var args20310 = [];
var len__5726__auto___20313 = arguments.length;
var i__5727__auto___20314 = (0);
while(true){
if((i__5727__auto___20314 < len__5726__auto___20313)){
args20310.push((arguments[i__5727__auto___20314]));

var G__20315 = (i__5727__auto___20314 + (1));
i__5727__auto___20314 = G__20315;
continue;
} else {
}
break;
}

var G__20312 = args20310.length;
switch (G__20312) {
case 1:
return sablono.core.check_box20309.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box20309.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box20309.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20310.length)].join('')));

}
});

sablono.core.check_box20309.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box20309.call(null,name,null);
});

sablono.core.check_box20309.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box20309.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box20309.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20309.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box20309);
/**
 * Creates a radio button.
 */
sablono.core.radio_button20317 = (function sablono$core$radio_button20317(var_args){
var args20318 = [];
var len__5726__auto___20321 = arguments.length;
var i__5727__auto___20322 = (0);
while(true){
if((i__5727__auto___20322 < len__5726__auto___20321)){
args20318.push((arguments[i__5727__auto___20322]));

var G__20323 = (i__5727__auto___20322 + (1));
i__5727__auto___20322 = G__20323;
continue;
} else {
}
break;
}

var G__20320 = args20318.length;
switch (G__20320) {
case 1:
return sablono.core.radio_button20317.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button20317.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button20317.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20318.length)].join('')));

}
});

sablono.core.radio_button20317.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button20317.call(null,group,null);
});

sablono.core.radio_button20317.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button20317.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button20317.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20317.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button20317);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options20325 = (function sablono$core$select_options20325(coll){
var iter__5440__auto__ = (function sablono$core$select_options20325_$_iter__20334(s__20335){
return (new cljs.core.LazySeq(null,(function (){
var s__20335__$1 = s__20335;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20335__$1);
if(temp__4425__auto__){
var s__20335__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20335__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20335__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20337 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20336 = (0);
while(true){
if((i__20336 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20336);
cljs.core.chunk_append.call(null,b__20337,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20340 = x;
var text = cljs.core.nth.call(null,vec__20340,(0),null);
var val = cljs.core.nth.call(null,vec__20340,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20340,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20325.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__20342 = (i__20336 + (1));
i__20336 = G__20342;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20337),sablono$core$select_options20325_$_iter__20334.call(null,cljs.core.chunk_rest.call(null,s__20335__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20337),null);
}
} else {
var x = cljs.core.first.call(null,s__20335__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20341 = x;
var text = cljs.core.nth.call(null,vec__20341,(0),null);
var val = cljs.core.nth.call(null,vec__20341,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20341,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20325.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options20325_$_iter__20334.call(null,cljs.core.rest.call(null,s__20335__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options20325);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down20343 = (function sablono$core$drop_down20343(var_args){
var args20344 = [];
var len__5726__auto___20347 = arguments.length;
var i__5727__auto___20348 = (0);
while(true){
if((i__5727__auto___20348 < len__5726__auto___20347)){
args20344.push((arguments[i__5727__auto___20348]));

var G__20349 = (i__5727__auto___20348 + (1));
i__5727__auto___20348 = G__20349;
continue;
} else {
}
break;
}

var G__20346 = args20344.length;
switch (G__20346) {
case 2:
return sablono.core.drop_down20343.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down20343.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20344.length)].join('')));

}
});

sablono.core.drop_down20343.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down20343.call(null,name,options,null);
});

sablono.core.drop_down20343.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down20343.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down20343);
/**
 * Creates a text area element.
 */
sablono.core.text_area20351 = (function sablono$core$text_area20351(var_args){
var args20352 = [];
var len__5726__auto___20355 = arguments.length;
var i__5727__auto___20356 = (0);
while(true){
if((i__5727__auto___20356 < len__5726__auto___20355)){
args20352.push((arguments[i__5727__auto___20356]));

var G__20357 = (i__5727__auto___20356 + (1));
i__5727__auto___20356 = G__20357;
continue;
} else {
}
break;
}

var G__20354 = args20352.length;
switch (G__20354) {
case 1:
return sablono.core.text_area20351.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area20351.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20352.length)].join('')));

}
});

sablono.core.text_area20351.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area20351.call(null,name,null);
});

sablono.core.text_area20351.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area20351.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area20351);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20359 = (function sablono$core$label20359(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20359);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20360 = (function sablono$core$submit_button20360(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20360);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20361 = (function sablono$core$reset_button20361(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20361);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20362 = (function sablono$core$form_to20362(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20367 = arguments.length;
var i__5727__auto___20368 = (0);
while(true){
if((i__5727__auto___20368 < len__5726__auto___20367)){
args__5733__auto__.push((arguments[i__5727__auto___20368]));

var G__20369 = (i__5727__auto___20368 + (1));
i__5727__auto___20368 = G__20369;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to20362.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to20362.cljs$core$IFn$_invoke$arity$variadic = (function (p__20365,body){
var vec__20366 = p__20365;
var method = cljs.core.nth.call(null,vec__20366,(0),null);
var action = cljs.core.nth.call(null,vec__20366,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to20362.cljs$lang$maxFixedArity = (1);

sablono.core.form_to20362.cljs$lang$applyTo = (function (seq20363){
var G__20364 = cljs.core.first.call(null,seq20363);
var seq20363__$1 = cljs.core.next.call(null,seq20363);
return sablono.core.form_to20362.cljs$core$IFn$_invoke$arity$variadic(G__20364,seq20363__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20362);

//# sourceMappingURL=core.js.map?rel=1453379982525