// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17280 = [];
var len__5726__auto___17286 = arguments.length;
var i__5727__auto___17287 = (0);
while(true){
if((i__5727__auto___17287 < len__5726__auto___17286)){
args17280.push((arguments[i__5727__auto___17287]));

var G__17288 = (i__5727__auto___17287 + (1));
i__5727__auto___17287 = G__17288;
continue;
} else {
}
break;
}

var G__17282 = args17280.length;
switch (G__17282) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17280.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17283 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17283 = (function (f,blockable,meta17284){
this.f = f;
this.blockable = blockable;
this.meta17284 = meta17284;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17283.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17285,meta17284__$1){
var self__ = this;
var _17285__$1 = this;
return (new cljs.core.async.t_cljs$core$async17283(self__.f,self__.blockable,meta17284__$1));
});

cljs.core.async.t_cljs$core$async17283.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17285){
var self__ = this;
var _17285__$1 = this;
return self__.meta17284;
});

cljs.core.async.t_cljs$core$async17283.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17283.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17283.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17283.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17283.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17284","meta17284",-808644203,null)], null);
});

cljs.core.async.t_cljs$core$async17283.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17283.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17283";

cljs.core.async.t_cljs$core$async17283.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17283");
});

cljs.core.async.__GT_t_cljs$core$async17283 = (function cljs$core$async$__GT_t_cljs$core$async17283(f__$1,blockable__$1,meta17284){
return (new cljs.core.async.t_cljs$core$async17283(f__$1,blockable__$1,meta17284));
});

}

return (new cljs.core.async.t_cljs$core$async17283(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17292 = [];
var len__5726__auto___17295 = arguments.length;
var i__5727__auto___17296 = (0);
while(true){
if((i__5727__auto___17296 < len__5726__auto___17295)){
args17292.push((arguments[i__5727__auto___17296]));

var G__17297 = (i__5727__auto___17296 + (1));
i__5727__auto___17296 = G__17297;
continue;
} else {
}
break;
}

var G__17294 = args17292.length;
switch (G__17294) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17292.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17299 = [];
var len__5726__auto___17302 = arguments.length;
var i__5727__auto___17303 = (0);
while(true){
if((i__5727__auto___17303 < len__5726__auto___17302)){
args17299.push((arguments[i__5727__auto___17303]));

var G__17304 = (i__5727__auto___17303 + (1));
i__5727__auto___17303 = G__17304;
continue;
} else {
}
break;
}

var G__17301 = args17299.length;
switch (G__17301) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17299.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17306 = [];
var len__5726__auto___17309 = arguments.length;
var i__5727__auto___17310 = (0);
while(true){
if((i__5727__auto___17310 < len__5726__auto___17309)){
args17306.push((arguments[i__5727__auto___17310]));

var G__17311 = (i__5727__auto___17310 + (1));
i__5727__auto___17310 = G__17311;
continue;
} else {
}
break;
}

var G__17308 = args17306.length;
switch (G__17308) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17306.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17313 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17313);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17313,ret){
return (function (){
return fn1.call(null,val_17313);
});})(val_17313,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17314 = [];
var len__5726__auto___17317 = arguments.length;
var i__5727__auto___17318 = (0);
while(true){
if((i__5727__auto___17318 < len__5726__auto___17317)){
args17314.push((arguments[i__5727__auto___17318]));

var G__17319 = (i__5727__auto___17318 + (1));
i__5727__auto___17318 = G__17319;
continue;
} else {
}
break;
}

var G__17316 = args17314.length;
switch (G__17316) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17314.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17321 = n;
var x_17322 = (0);
while(true){
if((x_17322 < n__5571__auto___17321)){
(a[x_17322] = (0));

var G__17323 = (x_17322 + (1));
x_17322 = G__17323;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17324 = (i + (1));
i = G__17324;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17328 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17328 = (function (alt_flag,flag,meta17329){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17329 = meta17329;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17328.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17330,meta17329__$1){
var self__ = this;
var _17330__$1 = this;
return (new cljs.core.async.t_cljs$core$async17328(self__.alt_flag,self__.flag,meta17329__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17328.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17330){
var self__ = this;
var _17330__$1 = this;
return self__.meta17329;
});})(flag))
;

cljs.core.async.t_cljs$core$async17328.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17328.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17328.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17328.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17328.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17329","meta17329",1588686285,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17328.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17328.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17328";

cljs.core.async.t_cljs$core$async17328.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17328");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17328 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17328(alt_flag__$1,flag__$1,meta17329){
return (new cljs.core.async.t_cljs$core$async17328(alt_flag__$1,flag__$1,meta17329));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17328(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17334 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17334 = (function (alt_handler,flag,cb,meta17335){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17335 = meta17335;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17334.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17336,meta17335__$1){
var self__ = this;
var _17336__$1 = this;
return (new cljs.core.async.t_cljs$core$async17334(self__.alt_handler,self__.flag,self__.cb,meta17335__$1));
});

cljs.core.async.t_cljs$core$async17334.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17336){
var self__ = this;
var _17336__$1 = this;
return self__.meta17335;
});

cljs.core.async.t_cljs$core$async17334.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17334.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17334.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17334.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17334.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17335","meta17335",2033513338,null)], null);
});

cljs.core.async.t_cljs$core$async17334.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17334.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17334";

cljs.core.async.t_cljs$core$async17334.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17334");
});

cljs.core.async.__GT_t_cljs$core$async17334 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17334(alt_handler__$1,flag__$1,cb__$1,meta17335){
return (new cljs.core.async.t_cljs$core$async17334(alt_handler__$1,flag__$1,cb__$1,meta17335));
});

}

return (new cljs.core.async.t_cljs$core$async17334(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17337_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17337_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17338_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17338_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17339 = (i + (1));
i = G__17339;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17345 = arguments.length;
var i__5727__auto___17346 = (0);
while(true){
if((i__5727__auto___17346 < len__5726__auto___17345)){
args__5733__auto__.push((arguments[i__5727__auto___17346]));

var G__17347 = (i__5727__auto___17346 + (1));
i__5727__auto___17346 = G__17347;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17342){
var map__17343 = p__17342;
var map__17343__$1 = ((((!((map__17343 == null)))?((((map__17343.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17343.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17343):map__17343);
var opts = map__17343__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17340){
var G__17341 = cljs.core.first.call(null,seq17340);
var seq17340__$1 = cljs.core.next.call(null,seq17340);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17341,seq17340__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17348 = [];
var len__5726__auto___17398 = arguments.length;
var i__5727__auto___17399 = (0);
while(true){
if((i__5727__auto___17399 < len__5726__auto___17398)){
args17348.push((arguments[i__5727__auto___17399]));

var G__17400 = (i__5727__auto___17399 + (1));
i__5727__auto___17399 = G__17400;
continue;
} else {
}
break;
}

var G__17350 = args17348.length;
switch (G__17350) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17348.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17402 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17402){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17402){
return (function (state_17374){
var state_val_17375 = (state_17374[(1)]);
if((state_val_17375 === (7))){
var inst_17370 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
var statearr_17376_17403 = state_17374__$1;
(statearr_17376_17403[(2)] = inst_17370);

(statearr_17376_17403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (1))){
var state_17374__$1 = state_17374;
var statearr_17377_17404 = state_17374__$1;
(statearr_17377_17404[(2)] = null);

(statearr_17377_17404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (4))){
var inst_17353 = (state_17374[(7)]);
var inst_17353__$1 = (state_17374[(2)]);
var inst_17354 = (inst_17353__$1 == null);
var state_17374__$1 = (function (){var statearr_17378 = state_17374;
(statearr_17378[(7)] = inst_17353__$1);

return statearr_17378;
})();
if(cljs.core.truth_(inst_17354)){
var statearr_17379_17405 = state_17374__$1;
(statearr_17379_17405[(1)] = (5));

} else {
var statearr_17380_17406 = state_17374__$1;
(statearr_17380_17406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (13))){
var state_17374__$1 = state_17374;
var statearr_17381_17407 = state_17374__$1;
(statearr_17381_17407[(2)] = null);

(statearr_17381_17407[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (6))){
var inst_17353 = (state_17374[(7)]);
var state_17374__$1 = state_17374;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17374__$1,(11),to,inst_17353);
} else {
if((state_val_17375 === (3))){
var inst_17372 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17374__$1,inst_17372);
} else {
if((state_val_17375 === (12))){
var state_17374__$1 = state_17374;
var statearr_17382_17408 = state_17374__$1;
(statearr_17382_17408[(2)] = null);

(statearr_17382_17408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (2))){
var state_17374__$1 = state_17374;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17374__$1,(4),from);
} else {
if((state_val_17375 === (11))){
var inst_17363 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
if(cljs.core.truth_(inst_17363)){
var statearr_17383_17409 = state_17374__$1;
(statearr_17383_17409[(1)] = (12));

} else {
var statearr_17384_17410 = state_17374__$1;
(statearr_17384_17410[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (9))){
var state_17374__$1 = state_17374;
var statearr_17385_17411 = state_17374__$1;
(statearr_17385_17411[(2)] = null);

(statearr_17385_17411[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (5))){
var state_17374__$1 = state_17374;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17386_17412 = state_17374__$1;
(statearr_17386_17412[(1)] = (8));

} else {
var statearr_17387_17413 = state_17374__$1;
(statearr_17387_17413[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (14))){
var inst_17368 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
var statearr_17388_17414 = state_17374__$1;
(statearr_17388_17414[(2)] = inst_17368);

(statearr_17388_17414[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (10))){
var inst_17360 = (state_17374[(2)]);
var state_17374__$1 = state_17374;
var statearr_17389_17415 = state_17374__$1;
(statearr_17389_17415[(2)] = inst_17360);

(statearr_17389_17415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17375 === (8))){
var inst_17357 = cljs.core.async.close_BANG_.call(null,to);
var state_17374__$1 = state_17374;
var statearr_17390_17416 = state_17374__$1;
(statearr_17390_17416[(2)] = inst_17357);

(statearr_17390_17416[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17402))
;
return ((function (switch__8250__auto__,c__8362__auto___17402){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17394 = [null,null,null,null,null,null,null,null];
(statearr_17394[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17394[(1)] = (1));

return statearr_17394;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17374){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17374);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17395){if((e17395 instanceof Object)){
var ex__8254__auto__ = e17395;
var statearr_17396_17417 = state_17374;
(statearr_17396_17417[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17374);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17395;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17418 = state_17374;
state_17374 = G__17418;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17374){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17402))
})();
var state__8364__auto__ = (function (){var statearr_17397 = f__8363__auto__.call(null);
(statearr_17397[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17402);

return statearr_17397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17402))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17602){
var vec__17603 = p__17602;
var v = cljs.core.nth.call(null,vec__17603,(0),null);
var p = cljs.core.nth.call(null,vec__17603,(1),null);
var job = vec__17603;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17785 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17785,res,vec__17603,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17785,res,vec__17603,v,p,job,jobs,results){
return (function (state_17608){
var state_val_17609 = (state_17608[(1)]);
if((state_val_17609 === (1))){
var state_17608__$1 = state_17608;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17608__$1,(2),res,v);
} else {
if((state_val_17609 === (2))){
var inst_17605 = (state_17608[(2)]);
var inst_17606 = cljs.core.async.close_BANG_.call(null,res);
var state_17608__$1 = (function (){var statearr_17610 = state_17608;
(statearr_17610[(7)] = inst_17605);

return statearr_17610;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17608__$1,inst_17606);
} else {
return null;
}
}
});})(c__8362__auto___17785,res,vec__17603,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17785,res,vec__17603,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17614 = [null,null,null,null,null,null,null,null];
(statearr_17614[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17614[(1)] = (1));

return statearr_17614;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17608){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17615){if((e17615 instanceof Object)){
var ex__8254__auto__ = e17615;
var statearr_17616_17786 = state_17608;
(statearr_17616_17786[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17608);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17615;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17787 = state_17608;
state_17608 = G__17787;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17608){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17785,res,vec__17603,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17617 = f__8363__auto__.call(null);
(statearr_17617[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17785);

return statearr_17617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17785,res,vec__17603,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17618){
var vec__17619 = p__17618;
var v = cljs.core.nth.call(null,vec__17619,(0),null);
var p = cljs.core.nth.call(null,vec__17619,(1),null);
var job = vec__17619;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17788 = n;
var __17789 = (0);
while(true){
if((__17789 < n__5571__auto___17788)){
var G__17620_17790 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17620_17790) {
case "compute":
var c__8362__auto___17792 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17789,c__8362__auto___17792,G__17620_17790,n__5571__auto___17788,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17789,c__8362__auto___17792,G__17620_17790,n__5571__auto___17788,jobs,results,process,async){
return (function (state_17633){
var state_val_17634 = (state_17633[(1)]);
if((state_val_17634 === (1))){
var state_17633__$1 = state_17633;
var statearr_17635_17793 = state_17633__$1;
(statearr_17635_17793[(2)] = null);

(statearr_17635_17793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17634 === (2))){
var state_17633__$1 = state_17633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17633__$1,(4),jobs);
} else {
if((state_val_17634 === (3))){
var inst_17631 = (state_17633[(2)]);
var state_17633__$1 = state_17633;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17633__$1,inst_17631);
} else {
if((state_val_17634 === (4))){
var inst_17623 = (state_17633[(2)]);
var inst_17624 = process.call(null,inst_17623);
var state_17633__$1 = state_17633;
if(cljs.core.truth_(inst_17624)){
var statearr_17636_17794 = state_17633__$1;
(statearr_17636_17794[(1)] = (5));

} else {
var statearr_17637_17795 = state_17633__$1;
(statearr_17637_17795[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17634 === (5))){
var state_17633__$1 = state_17633;
var statearr_17638_17796 = state_17633__$1;
(statearr_17638_17796[(2)] = null);

(statearr_17638_17796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17634 === (6))){
var state_17633__$1 = state_17633;
var statearr_17639_17797 = state_17633__$1;
(statearr_17639_17797[(2)] = null);

(statearr_17639_17797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17634 === (7))){
var inst_17629 = (state_17633[(2)]);
var state_17633__$1 = state_17633;
var statearr_17640_17798 = state_17633__$1;
(statearr_17640_17798[(2)] = inst_17629);

(statearr_17640_17798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17789,c__8362__auto___17792,G__17620_17790,n__5571__auto___17788,jobs,results,process,async))
;
return ((function (__17789,switch__8250__auto__,c__8362__auto___17792,G__17620_17790,n__5571__auto___17788,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17644 = [null,null,null,null,null,null,null];
(statearr_17644[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17644[(1)] = (1));

return statearr_17644;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17633){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17645){if((e17645 instanceof Object)){
var ex__8254__auto__ = e17645;
var statearr_17646_17799 = state_17633;
(statearr_17646_17799[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17633);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17645;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17800 = state_17633;
state_17633 = G__17800;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17633){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17789,switch__8250__auto__,c__8362__auto___17792,G__17620_17790,n__5571__auto___17788,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17647 = f__8363__auto__.call(null);
(statearr_17647[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17792);

return statearr_17647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17789,c__8362__auto___17792,G__17620_17790,n__5571__auto___17788,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17801 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17789,c__8362__auto___17801,G__17620_17790,n__5571__auto___17788,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17789,c__8362__auto___17801,G__17620_17790,n__5571__auto___17788,jobs,results,process,async){
return (function (state_17660){
var state_val_17661 = (state_17660[(1)]);
if((state_val_17661 === (1))){
var state_17660__$1 = state_17660;
var statearr_17662_17802 = state_17660__$1;
(statearr_17662_17802[(2)] = null);

(statearr_17662_17802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17661 === (2))){
var state_17660__$1 = state_17660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17660__$1,(4),jobs);
} else {
if((state_val_17661 === (3))){
var inst_17658 = (state_17660[(2)]);
var state_17660__$1 = state_17660;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17660__$1,inst_17658);
} else {
if((state_val_17661 === (4))){
var inst_17650 = (state_17660[(2)]);
var inst_17651 = async.call(null,inst_17650);
var state_17660__$1 = state_17660;
if(cljs.core.truth_(inst_17651)){
var statearr_17663_17803 = state_17660__$1;
(statearr_17663_17803[(1)] = (5));

} else {
var statearr_17664_17804 = state_17660__$1;
(statearr_17664_17804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17661 === (5))){
var state_17660__$1 = state_17660;
var statearr_17665_17805 = state_17660__$1;
(statearr_17665_17805[(2)] = null);

(statearr_17665_17805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17661 === (6))){
var state_17660__$1 = state_17660;
var statearr_17666_17806 = state_17660__$1;
(statearr_17666_17806[(2)] = null);

(statearr_17666_17806[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17661 === (7))){
var inst_17656 = (state_17660[(2)]);
var state_17660__$1 = state_17660;
var statearr_17667_17807 = state_17660__$1;
(statearr_17667_17807[(2)] = inst_17656);

(statearr_17667_17807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17789,c__8362__auto___17801,G__17620_17790,n__5571__auto___17788,jobs,results,process,async))
;
return ((function (__17789,switch__8250__auto__,c__8362__auto___17801,G__17620_17790,n__5571__auto___17788,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17671 = [null,null,null,null,null,null,null];
(statearr_17671[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17671[(1)] = (1));

return statearr_17671;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17660){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17660);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17672){if((e17672 instanceof Object)){
var ex__8254__auto__ = e17672;
var statearr_17673_17808 = state_17660;
(statearr_17673_17808[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17660);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17672;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17809 = state_17660;
state_17660 = G__17809;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17660){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17789,switch__8250__auto__,c__8362__auto___17801,G__17620_17790,n__5571__auto___17788,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17674 = f__8363__auto__.call(null);
(statearr_17674[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17801);

return statearr_17674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17789,c__8362__auto___17801,G__17620_17790,n__5571__auto___17788,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17810 = (__17789 + (1));
__17789 = G__17810;
continue;
} else {
}
break;
}

var c__8362__auto___17811 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17811,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17811,jobs,results,process,async){
return (function (state_17696){
var state_val_17697 = (state_17696[(1)]);
if((state_val_17697 === (1))){
var state_17696__$1 = state_17696;
var statearr_17698_17812 = state_17696__$1;
(statearr_17698_17812[(2)] = null);

(statearr_17698_17812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (2))){
var state_17696__$1 = state_17696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17696__$1,(4),from);
} else {
if((state_val_17697 === (3))){
var inst_17694 = (state_17696[(2)]);
var state_17696__$1 = state_17696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17696__$1,inst_17694);
} else {
if((state_val_17697 === (4))){
var inst_17677 = (state_17696[(7)]);
var inst_17677__$1 = (state_17696[(2)]);
var inst_17678 = (inst_17677__$1 == null);
var state_17696__$1 = (function (){var statearr_17699 = state_17696;
(statearr_17699[(7)] = inst_17677__$1);

return statearr_17699;
})();
if(cljs.core.truth_(inst_17678)){
var statearr_17700_17813 = state_17696__$1;
(statearr_17700_17813[(1)] = (5));

} else {
var statearr_17701_17814 = state_17696__$1;
(statearr_17701_17814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (5))){
var inst_17680 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17696__$1 = state_17696;
var statearr_17702_17815 = state_17696__$1;
(statearr_17702_17815[(2)] = inst_17680);

(statearr_17702_17815[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (6))){
var inst_17682 = (state_17696[(8)]);
var inst_17677 = (state_17696[(7)]);
var inst_17682__$1 = cljs.core.async.chan.call(null,(1));
var inst_17683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17684 = [inst_17677,inst_17682__$1];
var inst_17685 = (new cljs.core.PersistentVector(null,2,(5),inst_17683,inst_17684,null));
var state_17696__$1 = (function (){var statearr_17703 = state_17696;
(statearr_17703[(8)] = inst_17682__$1);

return statearr_17703;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17696__$1,(8),jobs,inst_17685);
} else {
if((state_val_17697 === (7))){
var inst_17692 = (state_17696[(2)]);
var state_17696__$1 = state_17696;
var statearr_17704_17816 = state_17696__$1;
(statearr_17704_17816[(2)] = inst_17692);

(statearr_17704_17816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17697 === (8))){
var inst_17682 = (state_17696[(8)]);
var inst_17687 = (state_17696[(2)]);
var state_17696__$1 = (function (){var statearr_17705 = state_17696;
(statearr_17705[(9)] = inst_17687);

return statearr_17705;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17696__$1,(9),results,inst_17682);
} else {
if((state_val_17697 === (9))){
var inst_17689 = (state_17696[(2)]);
var state_17696__$1 = (function (){var statearr_17706 = state_17696;
(statearr_17706[(10)] = inst_17689);

return statearr_17706;
})();
var statearr_17707_17817 = state_17696__$1;
(statearr_17707_17817[(2)] = null);

(statearr_17707_17817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17811,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17811,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17711 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17711[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17711[(1)] = (1));

return statearr_17711;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17696){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17712){if((e17712 instanceof Object)){
var ex__8254__auto__ = e17712;
var statearr_17713_17818 = state_17696;
(statearr_17713_17818[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17696);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17819 = state_17696;
state_17696 = G__17819;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17696){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17811,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17714 = f__8363__auto__.call(null);
(statearr_17714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17811);

return statearr_17714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17811,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17752){
var state_val_17753 = (state_17752[(1)]);
if((state_val_17753 === (7))){
var inst_17748 = (state_17752[(2)]);
var state_17752__$1 = state_17752;
var statearr_17754_17820 = state_17752__$1;
(statearr_17754_17820[(2)] = inst_17748);

(statearr_17754_17820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (20))){
var state_17752__$1 = state_17752;
var statearr_17755_17821 = state_17752__$1;
(statearr_17755_17821[(2)] = null);

(statearr_17755_17821[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (1))){
var state_17752__$1 = state_17752;
var statearr_17756_17822 = state_17752__$1;
(statearr_17756_17822[(2)] = null);

(statearr_17756_17822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (4))){
var inst_17717 = (state_17752[(7)]);
var inst_17717__$1 = (state_17752[(2)]);
var inst_17718 = (inst_17717__$1 == null);
var state_17752__$1 = (function (){var statearr_17757 = state_17752;
(statearr_17757[(7)] = inst_17717__$1);

return statearr_17757;
})();
if(cljs.core.truth_(inst_17718)){
var statearr_17758_17823 = state_17752__$1;
(statearr_17758_17823[(1)] = (5));

} else {
var statearr_17759_17824 = state_17752__$1;
(statearr_17759_17824[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (15))){
var inst_17730 = (state_17752[(8)]);
var state_17752__$1 = state_17752;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17752__$1,(18),to,inst_17730);
} else {
if((state_val_17753 === (21))){
var inst_17743 = (state_17752[(2)]);
var state_17752__$1 = state_17752;
var statearr_17760_17825 = state_17752__$1;
(statearr_17760_17825[(2)] = inst_17743);

(statearr_17760_17825[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (13))){
var inst_17745 = (state_17752[(2)]);
var state_17752__$1 = (function (){var statearr_17761 = state_17752;
(statearr_17761[(9)] = inst_17745);

return statearr_17761;
})();
var statearr_17762_17826 = state_17752__$1;
(statearr_17762_17826[(2)] = null);

(statearr_17762_17826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (6))){
var inst_17717 = (state_17752[(7)]);
var state_17752__$1 = state_17752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17752__$1,(11),inst_17717);
} else {
if((state_val_17753 === (17))){
var inst_17738 = (state_17752[(2)]);
var state_17752__$1 = state_17752;
if(cljs.core.truth_(inst_17738)){
var statearr_17763_17827 = state_17752__$1;
(statearr_17763_17827[(1)] = (19));

} else {
var statearr_17764_17828 = state_17752__$1;
(statearr_17764_17828[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (3))){
var inst_17750 = (state_17752[(2)]);
var state_17752__$1 = state_17752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17752__$1,inst_17750);
} else {
if((state_val_17753 === (12))){
var inst_17727 = (state_17752[(10)]);
var state_17752__$1 = state_17752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17752__$1,(14),inst_17727);
} else {
if((state_val_17753 === (2))){
var state_17752__$1 = state_17752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17752__$1,(4),results);
} else {
if((state_val_17753 === (19))){
var state_17752__$1 = state_17752;
var statearr_17765_17829 = state_17752__$1;
(statearr_17765_17829[(2)] = null);

(statearr_17765_17829[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (11))){
var inst_17727 = (state_17752[(2)]);
var state_17752__$1 = (function (){var statearr_17766 = state_17752;
(statearr_17766[(10)] = inst_17727);

return statearr_17766;
})();
var statearr_17767_17830 = state_17752__$1;
(statearr_17767_17830[(2)] = null);

(statearr_17767_17830[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (9))){
var state_17752__$1 = state_17752;
var statearr_17768_17831 = state_17752__$1;
(statearr_17768_17831[(2)] = null);

(statearr_17768_17831[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (5))){
var state_17752__$1 = state_17752;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17769_17832 = state_17752__$1;
(statearr_17769_17832[(1)] = (8));

} else {
var statearr_17770_17833 = state_17752__$1;
(statearr_17770_17833[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (14))){
var inst_17732 = (state_17752[(11)]);
var inst_17730 = (state_17752[(8)]);
var inst_17730__$1 = (state_17752[(2)]);
var inst_17731 = (inst_17730__$1 == null);
var inst_17732__$1 = cljs.core.not.call(null,inst_17731);
var state_17752__$1 = (function (){var statearr_17771 = state_17752;
(statearr_17771[(11)] = inst_17732__$1);

(statearr_17771[(8)] = inst_17730__$1);

return statearr_17771;
})();
if(inst_17732__$1){
var statearr_17772_17834 = state_17752__$1;
(statearr_17772_17834[(1)] = (15));

} else {
var statearr_17773_17835 = state_17752__$1;
(statearr_17773_17835[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (16))){
var inst_17732 = (state_17752[(11)]);
var state_17752__$1 = state_17752;
var statearr_17774_17836 = state_17752__$1;
(statearr_17774_17836[(2)] = inst_17732);

(statearr_17774_17836[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (10))){
var inst_17724 = (state_17752[(2)]);
var state_17752__$1 = state_17752;
var statearr_17775_17837 = state_17752__$1;
(statearr_17775_17837[(2)] = inst_17724);

(statearr_17775_17837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (18))){
var inst_17735 = (state_17752[(2)]);
var state_17752__$1 = state_17752;
var statearr_17776_17838 = state_17752__$1;
(statearr_17776_17838[(2)] = inst_17735);

(statearr_17776_17838[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17753 === (8))){
var inst_17721 = cljs.core.async.close_BANG_.call(null,to);
var state_17752__$1 = state_17752;
var statearr_17777_17839 = state_17752__$1;
(statearr_17777_17839[(2)] = inst_17721);

(statearr_17777_17839[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17781 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17781[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17781[(1)] = (1));

return statearr_17781;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17752){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17782){if((e17782 instanceof Object)){
var ex__8254__auto__ = e17782;
var statearr_17783_17840 = state_17752;
(statearr_17783_17840[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17752);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17782;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17841 = state_17752;
state_17752 = G__17841;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17752){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17784 = f__8363__auto__.call(null);
(statearr_17784[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17842 = [];
var len__5726__auto___17845 = arguments.length;
var i__5727__auto___17846 = (0);
while(true){
if((i__5727__auto___17846 < len__5726__auto___17845)){
args17842.push((arguments[i__5727__auto___17846]));

var G__17847 = (i__5727__auto___17846 + (1));
i__5727__auto___17846 = G__17847;
continue;
} else {
}
break;
}

var G__17844 = args17842.length;
switch (G__17844) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17842.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17849 = [];
var len__5726__auto___17852 = arguments.length;
var i__5727__auto___17853 = (0);
while(true){
if((i__5727__auto___17853 < len__5726__auto___17852)){
args17849.push((arguments[i__5727__auto___17853]));

var G__17854 = (i__5727__auto___17853 + (1));
i__5727__auto___17853 = G__17854;
continue;
} else {
}
break;
}

var G__17851 = args17849.length;
switch (G__17851) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17849.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17856 = [];
var len__5726__auto___17909 = arguments.length;
var i__5727__auto___17910 = (0);
while(true){
if((i__5727__auto___17910 < len__5726__auto___17909)){
args17856.push((arguments[i__5727__auto___17910]));

var G__17911 = (i__5727__auto___17910 + (1));
i__5727__auto___17910 = G__17911;
continue;
} else {
}
break;
}

var G__17858 = args17856.length;
switch (G__17858) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17856.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17913 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17913,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17913,tc,fc){
return (function (state_17884){
var state_val_17885 = (state_17884[(1)]);
if((state_val_17885 === (7))){
var inst_17880 = (state_17884[(2)]);
var state_17884__$1 = state_17884;
var statearr_17886_17914 = state_17884__$1;
(statearr_17886_17914[(2)] = inst_17880);

(statearr_17886_17914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (1))){
var state_17884__$1 = state_17884;
var statearr_17887_17915 = state_17884__$1;
(statearr_17887_17915[(2)] = null);

(statearr_17887_17915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (4))){
var inst_17861 = (state_17884[(7)]);
var inst_17861__$1 = (state_17884[(2)]);
var inst_17862 = (inst_17861__$1 == null);
var state_17884__$1 = (function (){var statearr_17888 = state_17884;
(statearr_17888[(7)] = inst_17861__$1);

return statearr_17888;
})();
if(cljs.core.truth_(inst_17862)){
var statearr_17889_17916 = state_17884__$1;
(statearr_17889_17916[(1)] = (5));

} else {
var statearr_17890_17917 = state_17884__$1;
(statearr_17890_17917[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (13))){
var state_17884__$1 = state_17884;
var statearr_17891_17918 = state_17884__$1;
(statearr_17891_17918[(2)] = null);

(statearr_17891_17918[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (6))){
var inst_17861 = (state_17884[(7)]);
var inst_17867 = p.call(null,inst_17861);
var state_17884__$1 = state_17884;
if(cljs.core.truth_(inst_17867)){
var statearr_17892_17919 = state_17884__$1;
(statearr_17892_17919[(1)] = (9));

} else {
var statearr_17893_17920 = state_17884__$1;
(statearr_17893_17920[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (3))){
var inst_17882 = (state_17884[(2)]);
var state_17884__$1 = state_17884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17884__$1,inst_17882);
} else {
if((state_val_17885 === (12))){
var state_17884__$1 = state_17884;
var statearr_17894_17921 = state_17884__$1;
(statearr_17894_17921[(2)] = null);

(statearr_17894_17921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (2))){
var state_17884__$1 = state_17884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17884__$1,(4),ch);
} else {
if((state_val_17885 === (11))){
var inst_17861 = (state_17884[(7)]);
var inst_17871 = (state_17884[(2)]);
var state_17884__$1 = state_17884;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17884__$1,(8),inst_17871,inst_17861);
} else {
if((state_val_17885 === (9))){
var state_17884__$1 = state_17884;
var statearr_17895_17922 = state_17884__$1;
(statearr_17895_17922[(2)] = tc);

(statearr_17895_17922[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (5))){
var inst_17864 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17865 = cljs.core.async.close_BANG_.call(null,fc);
var state_17884__$1 = (function (){var statearr_17896 = state_17884;
(statearr_17896[(8)] = inst_17864);

return statearr_17896;
})();
var statearr_17897_17923 = state_17884__$1;
(statearr_17897_17923[(2)] = inst_17865);

(statearr_17897_17923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (14))){
var inst_17878 = (state_17884[(2)]);
var state_17884__$1 = state_17884;
var statearr_17898_17924 = state_17884__$1;
(statearr_17898_17924[(2)] = inst_17878);

(statearr_17898_17924[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (10))){
var state_17884__$1 = state_17884;
var statearr_17899_17925 = state_17884__$1;
(statearr_17899_17925[(2)] = fc);

(statearr_17899_17925[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17885 === (8))){
var inst_17873 = (state_17884[(2)]);
var state_17884__$1 = state_17884;
if(cljs.core.truth_(inst_17873)){
var statearr_17900_17926 = state_17884__$1;
(statearr_17900_17926[(1)] = (12));

} else {
var statearr_17901_17927 = state_17884__$1;
(statearr_17901_17927[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17913,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17913,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17905 = [null,null,null,null,null,null,null,null,null];
(statearr_17905[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17905[(1)] = (1));

return statearr_17905;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17884){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17906){if((e17906 instanceof Object)){
var ex__8254__auto__ = e17906;
var statearr_17907_17928 = state_17884;
(statearr_17907_17928[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17884);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17906;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17929 = state_17884;
state_17884 = G__17929;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17884){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17913,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17908 = f__8363__auto__.call(null);
(statearr_17908[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17913);

return statearr_17908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17913,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_17993){
var state_val_17994 = (state_17993[(1)]);
if((state_val_17994 === (7))){
var inst_17989 = (state_17993[(2)]);
var state_17993__$1 = state_17993;
var statearr_17995_18016 = state_17993__$1;
(statearr_17995_18016[(2)] = inst_17989);

(statearr_17995_18016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17994 === (1))){
var inst_17973 = init;
var state_17993__$1 = (function (){var statearr_17996 = state_17993;
(statearr_17996[(7)] = inst_17973);

return statearr_17996;
})();
var statearr_17997_18017 = state_17993__$1;
(statearr_17997_18017[(2)] = null);

(statearr_17997_18017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17994 === (4))){
var inst_17976 = (state_17993[(8)]);
var inst_17976__$1 = (state_17993[(2)]);
var inst_17977 = (inst_17976__$1 == null);
var state_17993__$1 = (function (){var statearr_17998 = state_17993;
(statearr_17998[(8)] = inst_17976__$1);

return statearr_17998;
})();
if(cljs.core.truth_(inst_17977)){
var statearr_17999_18018 = state_17993__$1;
(statearr_17999_18018[(1)] = (5));

} else {
var statearr_18000_18019 = state_17993__$1;
(statearr_18000_18019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17994 === (6))){
var inst_17973 = (state_17993[(7)]);
var inst_17980 = (state_17993[(9)]);
var inst_17976 = (state_17993[(8)]);
var inst_17980__$1 = f.call(null,inst_17973,inst_17976);
var inst_17981 = cljs.core.reduced_QMARK_.call(null,inst_17980__$1);
var state_17993__$1 = (function (){var statearr_18001 = state_17993;
(statearr_18001[(9)] = inst_17980__$1);

return statearr_18001;
})();
if(inst_17981){
var statearr_18002_18020 = state_17993__$1;
(statearr_18002_18020[(1)] = (8));

} else {
var statearr_18003_18021 = state_17993__$1;
(statearr_18003_18021[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17994 === (3))){
var inst_17991 = (state_17993[(2)]);
var state_17993__$1 = state_17993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17993__$1,inst_17991);
} else {
if((state_val_17994 === (2))){
var state_17993__$1 = state_17993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17993__$1,(4),ch);
} else {
if((state_val_17994 === (9))){
var inst_17980 = (state_17993[(9)]);
var inst_17973 = inst_17980;
var state_17993__$1 = (function (){var statearr_18004 = state_17993;
(statearr_18004[(7)] = inst_17973);

return statearr_18004;
})();
var statearr_18005_18022 = state_17993__$1;
(statearr_18005_18022[(2)] = null);

(statearr_18005_18022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17994 === (5))){
var inst_17973 = (state_17993[(7)]);
var state_17993__$1 = state_17993;
var statearr_18006_18023 = state_17993__$1;
(statearr_18006_18023[(2)] = inst_17973);

(statearr_18006_18023[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17994 === (10))){
var inst_17987 = (state_17993[(2)]);
var state_17993__$1 = state_17993;
var statearr_18007_18024 = state_17993__$1;
(statearr_18007_18024[(2)] = inst_17987);

(statearr_18007_18024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17994 === (8))){
var inst_17980 = (state_17993[(9)]);
var inst_17983 = cljs.core.deref.call(null,inst_17980);
var state_17993__$1 = state_17993;
var statearr_18008_18025 = state_17993__$1;
(statearr_18008_18025[(2)] = inst_17983);

(statearr_18008_18025[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18012 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18012[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18012[(1)] = (1));

return statearr_18012;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_17993){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18013){if((e18013 instanceof Object)){
var ex__8254__auto__ = e18013;
var statearr_18014_18026 = state_17993;
(statearr_18014_18026[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18027 = state_17993;
state_17993 = G__18027;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_17993){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_17993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18015 = f__8363__auto__.call(null);
(statearr_18015[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18028 = [];
var len__5726__auto___18080 = arguments.length;
var i__5727__auto___18081 = (0);
while(true){
if((i__5727__auto___18081 < len__5726__auto___18080)){
args18028.push((arguments[i__5727__auto___18081]));

var G__18082 = (i__5727__auto___18081 + (1));
i__5727__auto___18081 = G__18082;
continue;
} else {
}
break;
}

var G__18030 = args18028.length;
switch (G__18030) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18028.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18055){
var state_val_18056 = (state_18055[(1)]);
if((state_val_18056 === (7))){
var inst_18037 = (state_18055[(2)]);
var state_18055__$1 = state_18055;
var statearr_18057_18084 = state_18055__$1;
(statearr_18057_18084[(2)] = inst_18037);

(statearr_18057_18084[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (1))){
var inst_18031 = cljs.core.seq.call(null,coll);
var inst_18032 = inst_18031;
var state_18055__$1 = (function (){var statearr_18058 = state_18055;
(statearr_18058[(7)] = inst_18032);

return statearr_18058;
})();
var statearr_18059_18085 = state_18055__$1;
(statearr_18059_18085[(2)] = null);

(statearr_18059_18085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (4))){
var inst_18032 = (state_18055[(7)]);
var inst_18035 = cljs.core.first.call(null,inst_18032);
var state_18055__$1 = state_18055;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18055__$1,(7),ch,inst_18035);
} else {
if((state_val_18056 === (13))){
var inst_18049 = (state_18055[(2)]);
var state_18055__$1 = state_18055;
var statearr_18060_18086 = state_18055__$1;
(statearr_18060_18086[(2)] = inst_18049);

(statearr_18060_18086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (6))){
var inst_18040 = (state_18055[(2)]);
var state_18055__$1 = state_18055;
if(cljs.core.truth_(inst_18040)){
var statearr_18061_18087 = state_18055__$1;
(statearr_18061_18087[(1)] = (8));

} else {
var statearr_18062_18088 = state_18055__$1;
(statearr_18062_18088[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (3))){
var inst_18053 = (state_18055[(2)]);
var state_18055__$1 = state_18055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18055__$1,inst_18053);
} else {
if((state_val_18056 === (12))){
var state_18055__$1 = state_18055;
var statearr_18063_18089 = state_18055__$1;
(statearr_18063_18089[(2)] = null);

(statearr_18063_18089[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (2))){
var inst_18032 = (state_18055[(7)]);
var state_18055__$1 = state_18055;
if(cljs.core.truth_(inst_18032)){
var statearr_18064_18090 = state_18055__$1;
(statearr_18064_18090[(1)] = (4));

} else {
var statearr_18065_18091 = state_18055__$1;
(statearr_18065_18091[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (11))){
var inst_18046 = cljs.core.async.close_BANG_.call(null,ch);
var state_18055__$1 = state_18055;
var statearr_18066_18092 = state_18055__$1;
(statearr_18066_18092[(2)] = inst_18046);

(statearr_18066_18092[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (9))){
var state_18055__$1 = state_18055;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18067_18093 = state_18055__$1;
(statearr_18067_18093[(1)] = (11));

} else {
var statearr_18068_18094 = state_18055__$1;
(statearr_18068_18094[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (5))){
var inst_18032 = (state_18055[(7)]);
var state_18055__$1 = state_18055;
var statearr_18069_18095 = state_18055__$1;
(statearr_18069_18095[(2)] = inst_18032);

(statearr_18069_18095[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (10))){
var inst_18051 = (state_18055[(2)]);
var state_18055__$1 = state_18055;
var statearr_18070_18096 = state_18055__$1;
(statearr_18070_18096[(2)] = inst_18051);

(statearr_18070_18096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18056 === (8))){
var inst_18032 = (state_18055[(7)]);
var inst_18042 = cljs.core.next.call(null,inst_18032);
var inst_18032__$1 = inst_18042;
var state_18055__$1 = (function (){var statearr_18071 = state_18055;
(statearr_18071[(7)] = inst_18032__$1);

return statearr_18071;
})();
var statearr_18072_18097 = state_18055__$1;
(statearr_18072_18097[(2)] = null);

(statearr_18072_18097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18076 = [null,null,null,null,null,null,null,null];
(statearr_18076[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18076[(1)] = (1));

return statearr_18076;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18055){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18077){if((e18077 instanceof Object)){
var ex__8254__auto__ = e18077;
var statearr_18078_18098 = state_18055;
(statearr_18078_18098[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18055);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18077;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18099 = state_18055;
state_18055 = G__18099;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18055){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18079 = f__8363__auto__.call(null);
(statearr_18079[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18321 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18321 = (function (mult,ch,cs,meta18322){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18322 = meta18322;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18321.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18323,meta18322__$1){
var self__ = this;
var _18323__$1 = this;
return (new cljs.core.async.t_cljs$core$async18321(self__.mult,self__.ch,self__.cs,meta18322__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18321.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18323){
var self__ = this;
var _18323__$1 = this;
return self__.meta18322;
});})(cs))
;

cljs.core.async.t_cljs$core$async18321.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18321.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18321.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18321.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18321.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18321.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18321.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18322","meta18322",1009586005,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18321.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18321.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18321";

cljs.core.async.t_cljs$core$async18321.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18321");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18321 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18321(mult__$1,ch__$1,cs__$1,meta18322){
return (new cljs.core.async.t_cljs$core$async18321(mult__$1,ch__$1,cs__$1,meta18322));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18321(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18542 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18542,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18542,cs,m,dchan,dctr,done){
return (function (state_18454){
var state_val_18455 = (state_18454[(1)]);
if((state_val_18455 === (7))){
var inst_18450 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18456_18543 = state_18454__$1;
(statearr_18456_18543[(2)] = inst_18450);

(statearr_18456_18543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (20))){
var inst_18355 = (state_18454[(7)]);
var inst_18365 = cljs.core.first.call(null,inst_18355);
var inst_18366 = cljs.core.nth.call(null,inst_18365,(0),null);
var inst_18367 = cljs.core.nth.call(null,inst_18365,(1),null);
var state_18454__$1 = (function (){var statearr_18457 = state_18454;
(statearr_18457[(8)] = inst_18366);

return statearr_18457;
})();
if(cljs.core.truth_(inst_18367)){
var statearr_18458_18544 = state_18454__$1;
(statearr_18458_18544[(1)] = (22));

} else {
var statearr_18459_18545 = state_18454__$1;
(statearr_18459_18545[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (27))){
var inst_18402 = (state_18454[(9)]);
var inst_18395 = (state_18454[(10)]);
var inst_18397 = (state_18454[(11)]);
var inst_18326 = (state_18454[(12)]);
var inst_18402__$1 = cljs.core._nth.call(null,inst_18395,inst_18397);
var inst_18403 = cljs.core.async.put_BANG_.call(null,inst_18402__$1,inst_18326,done);
var state_18454__$1 = (function (){var statearr_18460 = state_18454;
(statearr_18460[(9)] = inst_18402__$1);

return statearr_18460;
})();
if(cljs.core.truth_(inst_18403)){
var statearr_18461_18546 = state_18454__$1;
(statearr_18461_18546[(1)] = (30));

} else {
var statearr_18462_18547 = state_18454__$1;
(statearr_18462_18547[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (1))){
var state_18454__$1 = state_18454;
var statearr_18463_18548 = state_18454__$1;
(statearr_18463_18548[(2)] = null);

(statearr_18463_18548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (24))){
var inst_18355 = (state_18454[(7)]);
var inst_18372 = (state_18454[(2)]);
var inst_18373 = cljs.core.next.call(null,inst_18355);
var inst_18335 = inst_18373;
var inst_18336 = null;
var inst_18337 = (0);
var inst_18338 = (0);
var state_18454__$1 = (function (){var statearr_18464 = state_18454;
(statearr_18464[(13)] = inst_18335);

(statearr_18464[(14)] = inst_18337);

(statearr_18464[(15)] = inst_18372);

(statearr_18464[(16)] = inst_18338);

(statearr_18464[(17)] = inst_18336);

return statearr_18464;
})();
var statearr_18465_18549 = state_18454__$1;
(statearr_18465_18549[(2)] = null);

(statearr_18465_18549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (39))){
var state_18454__$1 = state_18454;
var statearr_18469_18550 = state_18454__$1;
(statearr_18469_18550[(2)] = null);

(statearr_18469_18550[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (4))){
var inst_18326 = (state_18454[(12)]);
var inst_18326__$1 = (state_18454[(2)]);
var inst_18327 = (inst_18326__$1 == null);
var state_18454__$1 = (function (){var statearr_18470 = state_18454;
(statearr_18470[(12)] = inst_18326__$1);

return statearr_18470;
})();
if(cljs.core.truth_(inst_18327)){
var statearr_18471_18551 = state_18454__$1;
(statearr_18471_18551[(1)] = (5));

} else {
var statearr_18472_18552 = state_18454__$1;
(statearr_18472_18552[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (15))){
var inst_18335 = (state_18454[(13)]);
var inst_18337 = (state_18454[(14)]);
var inst_18338 = (state_18454[(16)]);
var inst_18336 = (state_18454[(17)]);
var inst_18351 = (state_18454[(2)]);
var inst_18352 = (inst_18338 + (1));
var tmp18466 = inst_18335;
var tmp18467 = inst_18337;
var tmp18468 = inst_18336;
var inst_18335__$1 = tmp18466;
var inst_18336__$1 = tmp18468;
var inst_18337__$1 = tmp18467;
var inst_18338__$1 = inst_18352;
var state_18454__$1 = (function (){var statearr_18473 = state_18454;
(statearr_18473[(13)] = inst_18335__$1);

(statearr_18473[(14)] = inst_18337__$1);

(statearr_18473[(18)] = inst_18351);

(statearr_18473[(16)] = inst_18338__$1);

(statearr_18473[(17)] = inst_18336__$1);

return statearr_18473;
})();
var statearr_18474_18553 = state_18454__$1;
(statearr_18474_18553[(2)] = null);

(statearr_18474_18553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (21))){
var inst_18376 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18478_18554 = state_18454__$1;
(statearr_18478_18554[(2)] = inst_18376);

(statearr_18478_18554[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (31))){
var inst_18402 = (state_18454[(9)]);
var inst_18406 = done.call(null,null);
var inst_18407 = cljs.core.async.untap_STAR_.call(null,m,inst_18402);
var state_18454__$1 = (function (){var statearr_18479 = state_18454;
(statearr_18479[(19)] = inst_18406);

return statearr_18479;
})();
var statearr_18480_18555 = state_18454__$1;
(statearr_18480_18555[(2)] = inst_18407);

(statearr_18480_18555[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (32))){
var inst_18396 = (state_18454[(20)]);
var inst_18395 = (state_18454[(10)]);
var inst_18397 = (state_18454[(11)]);
var inst_18394 = (state_18454[(21)]);
var inst_18409 = (state_18454[(2)]);
var inst_18410 = (inst_18397 + (1));
var tmp18475 = inst_18396;
var tmp18476 = inst_18395;
var tmp18477 = inst_18394;
var inst_18394__$1 = tmp18477;
var inst_18395__$1 = tmp18476;
var inst_18396__$1 = tmp18475;
var inst_18397__$1 = inst_18410;
var state_18454__$1 = (function (){var statearr_18481 = state_18454;
(statearr_18481[(20)] = inst_18396__$1);

(statearr_18481[(10)] = inst_18395__$1);

(statearr_18481[(11)] = inst_18397__$1);

(statearr_18481[(22)] = inst_18409);

(statearr_18481[(21)] = inst_18394__$1);

return statearr_18481;
})();
var statearr_18482_18556 = state_18454__$1;
(statearr_18482_18556[(2)] = null);

(statearr_18482_18556[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (40))){
var inst_18422 = (state_18454[(23)]);
var inst_18426 = done.call(null,null);
var inst_18427 = cljs.core.async.untap_STAR_.call(null,m,inst_18422);
var state_18454__$1 = (function (){var statearr_18483 = state_18454;
(statearr_18483[(24)] = inst_18426);

return statearr_18483;
})();
var statearr_18484_18557 = state_18454__$1;
(statearr_18484_18557[(2)] = inst_18427);

(statearr_18484_18557[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (33))){
var inst_18413 = (state_18454[(25)]);
var inst_18415 = cljs.core.chunked_seq_QMARK_.call(null,inst_18413);
var state_18454__$1 = state_18454;
if(inst_18415){
var statearr_18485_18558 = state_18454__$1;
(statearr_18485_18558[(1)] = (36));

} else {
var statearr_18486_18559 = state_18454__$1;
(statearr_18486_18559[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (13))){
var inst_18345 = (state_18454[(26)]);
var inst_18348 = cljs.core.async.close_BANG_.call(null,inst_18345);
var state_18454__$1 = state_18454;
var statearr_18487_18560 = state_18454__$1;
(statearr_18487_18560[(2)] = inst_18348);

(statearr_18487_18560[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (22))){
var inst_18366 = (state_18454[(8)]);
var inst_18369 = cljs.core.async.close_BANG_.call(null,inst_18366);
var state_18454__$1 = state_18454;
var statearr_18488_18561 = state_18454__$1;
(statearr_18488_18561[(2)] = inst_18369);

(statearr_18488_18561[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (36))){
var inst_18413 = (state_18454[(25)]);
var inst_18417 = cljs.core.chunk_first.call(null,inst_18413);
var inst_18418 = cljs.core.chunk_rest.call(null,inst_18413);
var inst_18419 = cljs.core.count.call(null,inst_18417);
var inst_18394 = inst_18418;
var inst_18395 = inst_18417;
var inst_18396 = inst_18419;
var inst_18397 = (0);
var state_18454__$1 = (function (){var statearr_18489 = state_18454;
(statearr_18489[(20)] = inst_18396);

(statearr_18489[(10)] = inst_18395);

(statearr_18489[(11)] = inst_18397);

(statearr_18489[(21)] = inst_18394);

return statearr_18489;
})();
var statearr_18490_18562 = state_18454__$1;
(statearr_18490_18562[(2)] = null);

(statearr_18490_18562[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (41))){
var inst_18413 = (state_18454[(25)]);
var inst_18429 = (state_18454[(2)]);
var inst_18430 = cljs.core.next.call(null,inst_18413);
var inst_18394 = inst_18430;
var inst_18395 = null;
var inst_18396 = (0);
var inst_18397 = (0);
var state_18454__$1 = (function (){var statearr_18491 = state_18454;
(statearr_18491[(20)] = inst_18396);

(statearr_18491[(27)] = inst_18429);

(statearr_18491[(10)] = inst_18395);

(statearr_18491[(11)] = inst_18397);

(statearr_18491[(21)] = inst_18394);

return statearr_18491;
})();
var statearr_18492_18563 = state_18454__$1;
(statearr_18492_18563[(2)] = null);

(statearr_18492_18563[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (43))){
var state_18454__$1 = state_18454;
var statearr_18493_18564 = state_18454__$1;
(statearr_18493_18564[(2)] = null);

(statearr_18493_18564[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (29))){
var inst_18438 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18494_18565 = state_18454__$1;
(statearr_18494_18565[(2)] = inst_18438);

(statearr_18494_18565[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (44))){
var inst_18447 = (state_18454[(2)]);
var state_18454__$1 = (function (){var statearr_18495 = state_18454;
(statearr_18495[(28)] = inst_18447);

return statearr_18495;
})();
var statearr_18496_18566 = state_18454__$1;
(statearr_18496_18566[(2)] = null);

(statearr_18496_18566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (6))){
var inst_18386 = (state_18454[(29)]);
var inst_18385 = cljs.core.deref.call(null,cs);
var inst_18386__$1 = cljs.core.keys.call(null,inst_18385);
var inst_18387 = cljs.core.count.call(null,inst_18386__$1);
var inst_18388 = cljs.core.reset_BANG_.call(null,dctr,inst_18387);
var inst_18393 = cljs.core.seq.call(null,inst_18386__$1);
var inst_18394 = inst_18393;
var inst_18395 = null;
var inst_18396 = (0);
var inst_18397 = (0);
var state_18454__$1 = (function (){var statearr_18497 = state_18454;
(statearr_18497[(20)] = inst_18396);

(statearr_18497[(29)] = inst_18386__$1);

(statearr_18497[(30)] = inst_18388);

(statearr_18497[(10)] = inst_18395);

(statearr_18497[(11)] = inst_18397);

(statearr_18497[(21)] = inst_18394);

return statearr_18497;
})();
var statearr_18498_18567 = state_18454__$1;
(statearr_18498_18567[(2)] = null);

(statearr_18498_18567[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (28))){
var inst_18413 = (state_18454[(25)]);
var inst_18394 = (state_18454[(21)]);
var inst_18413__$1 = cljs.core.seq.call(null,inst_18394);
var state_18454__$1 = (function (){var statearr_18499 = state_18454;
(statearr_18499[(25)] = inst_18413__$1);

return statearr_18499;
})();
if(inst_18413__$1){
var statearr_18500_18568 = state_18454__$1;
(statearr_18500_18568[(1)] = (33));

} else {
var statearr_18501_18569 = state_18454__$1;
(statearr_18501_18569[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (25))){
var inst_18396 = (state_18454[(20)]);
var inst_18397 = (state_18454[(11)]);
var inst_18399 = (inst_18397 < inst_18396);
var inst_18400 = inst_18399;
var state_18454__$1 = state_18454;
if(cljs.core.truth_(inst_18400)){
var statearr_18502_18570 = state_18454__$1;
(statearr_18502_18570[(1)] = (27));

} else {
var statearr_18503_18571 = state_18454__$1;
(statearr_18503_18571[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (34))){
var state_18454__$1 = state_18454;
var statearr_18504_18572 = state_18454__$1;
(statearr_18504_18572[(2)] = null);

(statearr_18504_18572[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (17))){
var state_18454__$1 = state_18454;
var statearr_18505_18573 = state_18454__$1;
(statearr_18505_18573[(2)] = null);

(statearr_18505_18573[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (3))){
var inst_18452 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18454__$1,inst_18452);
} else {
if((state_val_18455 === (12))){
var inst_18381 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18506_18574 = state_18454__$1;
(statearr_18506_18574[(2)] = inst_18381);

(statearr_18506_18574[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (2))){
var state_18454__$1 = state_18454;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18454__$1,(4),ch);
} else {
if((state_val_18455 === (23))){
var state_18454__$1 = state_18454;
var statearr_18507_18575 = state_18454__$1;
(statearr_18507_18575[(2)] = null);

(statearr_18507_18575[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (35))){
var inst_18436 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18508_18576 = state_18454__$1;
(statearr_18508_18576[(2)] = inst_18436);

(statearr_18508_18576[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (19))){
var inst_18355 = (state_18454[(7)]);
var inst_18359 = cljs.core.chunk_first.call(null,inst_18355);
var inst_18360 = cljs.core.chunk_rest.call(null,inst_18355);
var inst_18361 = cljs.core.count.call(null,inst_18359);
var inst_18335 = inst_18360;
var inst_18336 = inst_18359;
var inst_18337 = inst_18361;
var inst_18338 = (0);
var state_18454__$1 = (function (){var statearr_18509 = state_18454;
(statearr_18509[(13)] = inst_18335);

(statearr_18509[(14)] = inst_18337);

(statearr_18509[(16)] = inst_18338);

(statearr_18509[(17)] = inst_18336);

return statearr_18509;
})();
var statearr_18510_18577 = state_18454__$1;
(statearr_18510_18577[(2)] = null);

(statearr_18510_18577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (11))){
var inst_18355 = (state_18454[(7)]);
var inst_18335 = (state_18454[(13)]);
var inst_18355__$1 = cljs.core.seq.call(null,inst_18335);
var state_18454__$1 = (function (){var statearr_18511 = state_18454;
(statearr_18511[(7)] = inst_18355__$1);

return statearr_18511;
})();
if(inst_18355__$1){
var statearr_18512_18578 = state_18454__$1;
(statearr_18512_18578[(1)] = (16));

} else {
var statearr_18513_18579 = state_18454__$1;
(statearr_18513_18579[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (9))){
var inst_18383 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18514_18580 = state_18454__$1;
(statearr_18514_18580[(2)] = inst_18383);

(statearr_18514_18580[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (5))){
var inst_18333 = cljs.core.deref.call(null,cs);
var inst_18334 = cljs.core.seq.call(null,inst_18333);
var inst_18335 = inst_18334;
var inst_18336 = null;
var inst_18337 = (0);
var inst_18338 = (0);
var state_18454__$1 = (function (){var statearr_18515 = state_18454;
(statearr_18515[(13)] = inst_18335);

(statearr_18515[(14)] = inst_18337);

(statearr_18515[(16)] = inst_18338);

(statearr_18515[(17)] = inst_18336);

return statearr_18515;
})();
var statearr_18516_18581 = state_18454__$1;
(statearr_18516_18581[(2)] = null);

(statearr_18516_18581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (14))){
var state_18454__$1 = state_18454;
var statearr_18517_18582 = state_18454__$1;
(statearr_18517_18582[(2)] = null);

(statearr_18517_18582[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (45))){
var inst_18444 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18518_18583 = state_18454__$1;
(statearr_18518_18583[(2)] = inst_18444);

(statearr_18518_18583[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (26))){
var inst_18386 = (state_18454[(29)]);
var inst_18440 = (state_18454[(2)]);
var inst_18441 = cljs.core.seq.call(null,inst_18386);
var state_18454__$1 = (function (){var statearr_18519 = state_18454;
(statearr_18519[(31)] = inst_18440);

return statearr_18519;
})();
if(inst_18441){
var statearr_18520_18584 = state_18454__$1;
(statearr_18520_18584[(1)] = (42));

} else {
var statearr_18521_18585 = state_18454__$1;
(statearr_18521_18585[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (16))){
var inst_18355 = (state_18454[(7)]);
var inst_18357 = cljs.core.chunked_seq_QMARK_.call(null,inst_18355);
var state_18454__$1 = state_18454;
if(inst_18357){
var statearr_18522_18586 = state_18454__$1;
(statearr_18522_18586[(1)] = (19));

} else {
var statearr_18523_18587 = state_18454__$1;
(statearr_18523_18587[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (38))){
var inst_18433 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18524_18588 = state_18454__$1;
(statearr_18524_18588[(2)] = inst_18433);

(statearr_18524_18588[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (30))){
var state_18454__$1 = state_18454;
var statearr_18525_18589 = state_18454__$1;
(statearr_18525_18589[(2)] = null);

(statearr_18525_18589[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (10))){
var inst_18338 = (state_18454[(16)]);
var inst_18336 = (state_18454[(17)]);
var inst_18344 = cljs.core._nth.call(null,inst_18336,inst_18338);
var inst_18345 = cljs.core.nth.call(null,inst_18344,(0),null);
var inst_18346 = cljs.core.nth.call(null,inst_18344,(1),null);
var state_18454__$1 = (function (){var statearr_18526 = state_18454;
(statearr_18526[(26)] = inst_18345);

return statearr_18526;
})();
if(cljs.core.truth_(inst_18346)){
var statearr_18527_18590 = state_18454__$1;
(statearr_18527_18590[(1)] = (13));

} else {
var statearr_18528_18591 = state_18454__$1;
(statearr_18528_18591[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (18))){
var inst_18379 = (state_18454[(2)]);
var state_18454__$1 = state_18454;
var statearr_18529_18592 = state_18454__$1;
(statearr_18529_18592[(2)] = inst_18379);

(statearr_18529_18592[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (42))){
var state_18454__$1 = state_18454;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18454__$1,(45),dchan);
} else {
if((state_val_18455 === (37))){
var inst_18413 = (state_18454[(25)]);
var inst_18422 = (state_18454[(23)]);
var inst_18326 = (state_18454[(12)]);
var inst_18422__$1 = cljs.core.first.call(null,inst_18413);
var inst_18423 = cljs.core.async.put_BANG_.call(null,inst_18422__$1,inst_18326,done);
var state_18454__$1 = (function (){var statearr_18530 = state_18454;
(statearr_18530[(23)] = inst_18422__$1);

return statearr_18530;
})();
if(cljs.core.truth_(inst_18423)){
var statearr_18531_18593 = state_18454__$1;
(statearr_18531_18593[(1)] = (39));

} else {
var statearr_18532_18594 = state_18454__$1;
(statearr_18532_18594[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18455 === (8))){
var inst_18337 = (state_18454[(14)]);
var inst_18338 = (state_18454[(16)]);
var inst_18340 = (inst_18338 < inst_18337);
var inst_18341 = inst_18340;
var state_18454__$1 = state_18454;
if(cljs.core.truth_(inst_18341)){
var statearr_18533_18595 = state_18454__$1;
(statearr_18533_18595[(1)] = (10));

} else {
var statearr_18534_18596 = state_18454__$1;
(statearr_18534_18596[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18542,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18542,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18538 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18538[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18538[(1)] = (1));

return statearr_18538;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18454){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18454);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18539){if((e18539 instanceof Object)){
var ex__8254__auto__ = e18539;
var statearr_18540_18597 = state_18454;
(statearr_18540_18597[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18539;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18598 = state_18454;
state_18454 = G__18598;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18454){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18542,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18541 = f__8363__auto__.call(null);
(statearr_18541[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18542);

return statearr_18541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18542,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18599 = [];
var len__5726__auto___18602 = arguments.length;
var i__5727__auto___18603 = (0);
while(true){
if((i__5727__auto___18603 < len__5726__auto___18602)){
args18599.push((arguments[i__5727__auto___18603]));

var G__18604 = (i__5727__auto___18603 + (1));
i__5727__auto___18603 = G__18604;
continue;
} else {
}
break;
}

var G__18601 = args18599.length;
switch (G__18601) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18599.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18616 = arguments.length;
var i__5727__auto___18617 = (0);
while(true){
if((i__5727__auto___18617 < len__5726__auto___18616)){
args__5733__auto__.push((arguments[i__5727__auto___18617]));

var G__18618 = (i__5727__auto___18617 + (1));
i__5727__auto___18617 = G__18618;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18610){
var map__18611 = p__18610;
var map__18611__$1 = ((((!((map__18611 == null)))?((((map__18611.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18611.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18611):map__18611);
var opts = map__18611__$1;
var statearr_18613_18619 = state;
(statearr_18613_18619[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18611,map__18611__$1,opts){
return (function (val){
var statearr_18614_18620 = state;
(statearr_18614_18620[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18611,map__18611__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18615_18621 = state;
(statearr_18615_18621[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18606){
var G__18607 = cljs.core.first.call(null,seq18606);
var seq18606__$1 = cljs.core.next.call(null,seq18606);
var G__18608 = cljs.core.first.call(null,seq18606__$1);
var seq18606__$2 = cljs.core.next.call(null,seq18606__$1);
var G__18609 = cljs.core.first.call(null,seq18606__$2);
var seq18606__$3 = cljs.core.next.call(null,seq18606__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18607,G__18608,G__18609,seq18606__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18785 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18785 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18786){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18786 = meta18786;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18787,meta18786__$1){
var self__ = this;
var _18787__$1 = this;
return (new cljs.core.async.t_cljs$core$async18785(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18786__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18787){
var self__ = this;
var _18787__$1 = this;
return self__.meta18786;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18786","meta18786",-447187267,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18785.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18785.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18785";

cljs.core.async.t_cljs$core$async18785.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18785");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18785 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18785(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18786){
return (new cljs.core.async.t_cljs$core$async18785(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18786));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18785(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___18948 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18948,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18948,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18885){
var state_val_18886 = (state_18885[(1)]);
if((state_val_18886 === (7))){
var inst_18803 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18887_18949 = state_18885__$1;
(statearr_18887_18949[(2)] = inst_18803);

(statearr_18887_18949[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (20))){
var inst_18815 = (state_18885[(7)]);
var state_18885__$1 = state_18885;
var statearr_18888_18950 = state_18885__$1;
(statearr_18888_18950[(2)] = inst_18815);

(statearr_18888_18950[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (27))){
var state_18885__$1 = state_18885;
var statearr_18889_18951 = state_18885__$1;
(statearr_18889_18951[(2)] = null);

(statearr_18889_18951[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (1))){
var inst_18791 = (state_18885[(8)]);
var inst_18791__$1 = calc_state.call(null);
var inst_18793 = (inst_18791__$1 == null);
var inst_18794 = cljs.core.not.call(null,inst_18793);
var state_18885__$1 = (function (){var statearr_18890 = state_18885;
(statearr_18890[(8)] = inst_18791__$1);

return statearr_18890;
})();
if(inst_18794){
var statearr_18891_18952 = state_18885__$1;
(statearr_18891_18952[(1)] = (2));

} else {
var statearr_18892_18953 = state_18885__$1;
(statearr_18892_18953[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (24))){
var inst_18845 = (state_18885[(9)]);
var inst_18859 = (state_18885[(10)]);
var inst_18838 = (state_18885[(11)]);
var inst_18859__$1 = inst_18838.call(null,inst_18845);
var state_18885__$1 = (function (){var statearr_18893 = state_18885;
(statearr_18893[(10)] = inst_18859__$1);

return statearr_18893;
})();
if(cljs.core.truth_(inst_18859__$1)){
var statearr_18894_18954 = state_18885__$1;
(statearr_18894_18954[(1)] = (29));

} else {
var statearr_18895_18955 = state_18885__$1;
(statearr_18895_18955[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (4))){
var inst_18806 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
if(cljs.core.truth_(inst_18806)){
var statearr_18896_18956 = state_18885__$1;
(statearr_18896_18956[(1)] = (8));

} else {
var statearr_18897_18957 = state_18885__$1;
(statearr_18897_18957[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (15))){
var inst_18832 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
if(cljs.core.truth_(inst_18832)){
var statearr_18898_18958 = state_18885__$1;
(statearr_18898_18958[(1)] = (19));

} else {
var statearr_18899_18959 = state_18885__$1;
(statearr_18899_18959[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (21))){
var inst_18837 = (state_18885[(12)]);
var inst_18837__$1 = (state_18885[(2)]);
var inst_18838 = cljs.core.get.call(null,inst_18837__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18839 = cljs.core.get.call(null,inst_18837__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18840 = cljs.core.get.call(null,inst_18837__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18885__$1 = (function (){var statearr_18900 = state_18885;
(statearr_18900[(13)] = inst_18839);

(statearr_18900[(11)] = inst_18838);

(statearr_18900[(12)] = inst_18837__$1);

return statearr_18900;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18885__$1,(22),inst_18840);
} else {
if((state_val_18886 === (31))){
var inst_18867 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
if(cljs.core.truth_(inst_18867)){
var statearr_18901_18960 = state_18885__$1;
(statearr_18901_18960[(1)] = (32));

} else {
var statearr_18902_18961 = state_18885__$1;
(statearr_18902_18961[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (32))){
var inst_18844 = (state_18885[(14)]);
var state_18885__$1 = state_18885;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18885__$1,(35),out,inst_18844);
} else {
if((state_val_18886 === (33))){
var inst_18837 = (state_18885[(12)]);
var inst_18815 = inst_18837;
var state_18885__$1 = (function (){var statearr_18903 = state_18885;
(statearr_18903[(7)] = inst_18815);

return statearr_18903;
})();
var statearr_18904_18962 = state_18885__$1;
(statearr_18904_18962[(2)] = null);

(statearr_18904_18962[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (13))){
var inst_18815 = (state_18885[(7)]);
var inst_18822 = inst_18815.cljs$lang$protocol_mask$partition0$;
var inst_18823 = (inst_18822 & (64));
var inst_18824 = inst_18815.cljs$core$ISeq$;
var inst_18825 = (inst_18823) || (inst_18824);
var state_18885__$1 = state_18885;
if(cljs.core.truth_(inst_18825)){
var statearr_18905_18963 = state_18885__$1;
(statearr_18905_18963[(1)] = (16));

} else {
var statearr_18906_18964 = state_18885__$1;
(statearr_18906_18964[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (22))){
var inst_18845 = (state_18885[(9)]);
var inst_18844 = (state_18885[(14)]);
var inst_18843 = (state_18885[(2)]);
var inst_18844__$1 = cljs.core.nth.call(null,inst_18843,(0),null);
var inst_18845__$1 = cljs.core.nth.call(null,inst_18843,(1),null);
var inst_18846 = (inst_18844__$1 == null);
var inst_18847 = cljs.core._EQ_.call(null,inst_18845__$1,change);
var inst_18848 = (inst_18846) || (inst_18847);
var state_18885__$1 = (function (){var statearr_18907 = state_18885;
(statearr_18907[(9)] = inst_18845__$1);

(statearr_18907[(14)] = inst_18844__$1);

return statearr_18907;
})();
if(cljs.core.truth_(inst_18848)){
var statearr_18908_18965 = state_18885__$1;
(statearr_18908_18965[(1)] = (23));

} else {
var statearr_18909_18966 = state_18885__$1;
(statearr_18909_18966[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (36))){
var inst_18837 = (state_18885[(12)]);
var inst_18815 = inst_18837;
var state_18885__$1 = (function (){var statearr_18910 = state_18885;
(statearr_18910[(7)] = inst_18815);

return statearr_18910;
})();
var statearr_18911_18967 = state_18885__$1;
(statearr_18911_18967[(2)] = null);

(statearr_18911_18967[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (29))){
var inst_18859 = (state_18885[(10)]);
var state_18885__$1 = state_18885;
var statearr_18912_18968 = state_18885__$1;
(statearr_18912_18968[(2)] = inst_18859);

(statearr_18912_18968[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (6))){
var state_18885__$1 = state_18885;
var statearr_18913_18969 = state_18885__$1;
(statearr_18913_18969[(2)] = false);

(statearr_18913_18969[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (28))){
var inst_18855 = (state_18885[(2)]);
var inst_18856 = calc_state.call(null);
var inst_18815 = inst_18856;
var state_18885__$1 = (function (){var statearr_18914 = state_18885;
(statearr_18914[(7)] = inst_18815);

(statearr_18914[(15)] = inst_18855);

return statearr_18914;
})();
var statearr_18915_18970 = state_18885__$1;
(statearr_18915_18970[(2)] = null);

(statearr_18915_18970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (25))){
var inst_18881 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18916_18971 = state_18885__$1;
(statearr_18916_18971[(2)] = inst_18881);

(statearr_18916_18971[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (34))){
var inst_18879 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18917_18972 = state_18885__$1;
(statearr_18917_18972[(2)] = inst_18879);

(statearr_18917_18972[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (17))){
var state_18885__$1 = state_18885;
var statearr_18918_18973 = state_18885__$1;
(statearr_18918_18973[(2)] = false);

(statearr_18918_18973[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (3))){
var state_18885__$1 = state_18885;
var statearr_18919_18974 = state_18885__$1;
(statearr_18919_18974[(2)] = false);

(statearr_18919_18974[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (12))){
var inst_18883 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18885__$1,inst_18883);
} else {
if((state_val_18886 === (2))){
var inst_18791 = (state_18885[(8)]);
var inst_18796 = inst_18791.cljs$lang$protocol_mask$partition0$;
var inst_18797 = (inst_18796 & (64));
var inst_18798 = inst_18791.cljs$core$ISeq$;
var inst_18799 = (inst_18797) || (inst_18798);
var state_18885__$1 = state_18885;
if(cljs.core.truth_(inst_18799)){
var statearr_18920_18975 = state_18885__$1;
(statearr_18920_18975[(1)] = (5));

} else {
var statearr_18921_18976 = state_18885__$1;
(statearr_18921_18976[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (23))){
var inst_18844 = (state_18885[(14)]);
var inst_18850 = (inst_18844 == null);
var state_18885__$1 = state_18885;
if(cljs.core.truth_(inst_18850)){
var statearr_18922_18977 = state_18885__$1;
(statearr_18922_18977[(1)] = (26));

} else {
var statearr_18923_18978 = state_18885__$1;
(statearr_18923_18978[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (35))){
var inst_18870 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
if(cljs.core.truth_(inst_18870)){
var statearr_18924_18979 = state_18885__$1;
(statearr_18924_18979[(1)] = (36));

} else {
var statearr_18925_18980 = state_18885__$1;
(statearr_18925_18980[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (19))){
var inst_18815 = (state_18885[(7)]);
var inst_18834 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18815);
var state_18885__$1 = state_18885;
var statearr_18926_18981 = state_18885__$1;
(statearr_18926_18981[(2)] = inst_18834);

(statearr_18926_18981[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (11))){
var inst_18815 = (state_18885[(7)]);
var inst_18819 = (inst_18815 == null);
var inst_18820 = cljs.core.not.call(null,inst_18819);
var state_18885__$1 = state_18885;
if(inst_18820){
var statearr_18927_18982 = state_18885__$1;
(statearr_18927_18982[(1)] = (13));

} else {
var statearr_18928_18983 = state_18885__$1;
(statearr_18928_18983[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (9))){
var inst_18791 = (state_18885[(8)]);
var state_18885__$1 = state_18885;
var statearr_18929_18984 = state_18885__$1;
(statearr_18929_18984[(2)] = inst_18791);

(statearr_18929_18984[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (5))){
var state_18885__$1 = state_18885;
var statearr_18930_18985 = state_18885__$1;
(statearr_18930_18985[(2)] = true);

(statearr_18930_18985[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (14))){
var state_18885__$1 = state_18885;
var statearr_18931_18986 = state_18885__$1;
(statearr_18931_18986[(2)] = false);

(statearr_18931_18986[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (26))){
var inst_18845 = (state_18885[(9)]);
var inst_18852 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18845);
var state_18885__$1 = state_18885;
var statearr_18932_18987 = state_18885__$1;
(statearr_18932_18987[(2)] = inst_18852);

(statearr_18932_18987[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (16))){
var state_18885__$1 = state_18885;
var statearr_18933_18988 = state_18885__$1;
(statearr_18933_18988[(2)] = true);

(statearr_18933_18988[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (38))){
var inst_18875 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18934_18989 = state_18885__$1;
(statearr_18934_18989[(2)] = inst_18875);

(statearr_18934_18989[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (30))){
var inst_18845 = (state_18885[(9)]);
var inst_18839 = (state_18885[(13)]);
var inst_18838 = (state_18885[(11)]);
var inst_18862 = cljs.core.empty_QMARK_.call(null,inst_18838);
var inst_18863 = inst_18839.call(null,inst_18845);
var inst_18864 = cljs.core.not.call(null,inst_18863);
var inst_18865 = (inst_18862) && (inst_18864);
var state_18885__$1 = state_18885;
var statearr_18935_18990 = state_18885__$1;
(statearr_18935_18990[(2)] = inst_18865);

(statearr_18935_18990[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (10))){
var inst_18791 = (state_18885[(8)]);
var inst_18811 = (state_18885[(2)]);
var inst_18812 = cljs.core.get.call(null,inst_18811,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18813 = cljs.core.get.call(null,inst_18811,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18814 = cljs.core.get.call(null,inst_18811,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18815 = inst_18791;
var state_18885__$1 = (function (){var statearr_18936 = state_18885;
(statearr_18936[(16)] = inst_18813);

(statearr_18936[(7)] = inst_18815);

(statearr_18936[(17)] = inst_18814);

(statearr_18936[(18)] = inst_18812);

return statearr_18936;
})();
var statearr_18937_18991 = state_18885__$1;
(statearr_18937_18991[(2)] = null);

(statearr_18937_18991[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (18))){
var inst_18829 = (state_18885[(2)]);
var state_18885__$1 = state_18885;
var statearr_18938_18992 = state_18885__$1;
(statearr_18938_18992[(2)] = inst_18829);

(statearr_18938_18992[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (37))){
var state_18885__$1 = state_18885;
var statearr_18939_18993 = state_18885__$1;
(statearr_18939_18993[(2)] = null);

(statearr_18939_18993[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18886 === (8))){
var inst_18791 = (state_18885[(8)]);
var inst_18808 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18791);
var state_18885__$1 = state_18885;
var statearr_18940_18994 = state_18885__$1;
(statearr_18940_18994[(2)] = inst_18808);

(statearr_18940_18994[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18948,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___18948,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_18944 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18944[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_18944[(1)] = (1));

return statearr_18944;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18885){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18945){if((e18945 instanceof Object)){
var ex__8254__auto__ = e18945;
var statearr_18946_18995 = state_18885;
(statearr_18946_18995[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18885);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18945;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18996 = state_18885;
state_18885 = G__18996;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18885){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18948,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_18947 = f__8363__auto__.call(null);
(statearr_18947[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18948);

return statearr_18947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18948,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args18997 = [];
var len__5726__auto___19000 = arguments.length;
var i__5727__auto___19001 = (0);
while(true){
if((i__5727__auto___19001 < len__5726__auto___19000)){
args18997.push((arguments[i__5727__auto___19001]));

var G__19002 = (i__5727__auto___19001 + (1));
i__5727__auto___19001 = G__19002;
continue;
} else {
}
break;
}

var G__18999 = args18997.length;
switch (G__18999) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18997.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19005 = [];
var len__5726__auto___19130 = arguments.length;
var i__5727__auto___19131 = (0);
while(true){
if((i__5727__auto___19131 < len__5726__auto___19130)){
args19005.push((arguments[i__5727__auto___19131]));

var G__19132 = (i__5727__auto___19131 + (1));
i__5727__auto___19131 = G__19132;
continue;
} else {
}
break;
}

var G__19007 = args19005.length;
switch (G__19007) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19005.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__19004_SHARP_){
if(cljs.core.truth_(p1__19004_SHARP_.call(null,topic))){
return p1__19004_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__19004_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19008 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19008 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19009){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19009 = meta19009;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19010,meta19009__$1){
var self__ = this;
var _19010__$1 = this;
return (new cljs.core.async.t_cljs$core$async19008(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19009__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19010){
var self__ = this;
var _19010__$1 = this;
return self__.meta19009;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19008.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19008.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19009","meta19009",842579512,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19008.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19008.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19008";

cljs.core.async.t_cljs$core$async19008.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19008");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19008 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19008(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19009){
return (new cljs.core.async.t_cljs$core$async19008(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19009));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19008(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19134 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19134,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19134,mults,ensure_mult,p){
return (function (state_19082){
var state_val_19083 = (state_19082[(1)]);
if((state_val_19083 === (7))){
var inst_19078 = (state_19082[(2)]);
var state_19082__$1 = state_19082;
var statearr_19084_19135 = state_19082__$1;
(statearr_19084_19135[(2)] = inst_19078);

(statearr_19084_19135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (20))){
var state_19082__$1 = state_19082;
var statearr_19085_19136 = state_19082__$1;
(statearr_19085_19136[(2)] = null);

(statearr_19085_19136[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (1))){
var state_19082__$1 = state_19082;
var statearr_19086_19137 = state_19082__$1;
(statearr_19086_19137[(2)] = null);

(statearr_19086_19137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (24))){
var inst_19061 = (state_19082[(7)]);
var inst_19070 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19061);
var state_19082__$1 = state_19082;
var statearr_19087_19138 = state_19082__$1;
(statearr_19087_19138[(2)] = inst_19070);

(statearr_19087_19138[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (4))){
var inst_19013 = (state_19082[(8)]);
var inst_19013__$1 = (state_19082[(2)]);
var inst_19014 = (inst_19013__$1 == null);
var state_19082__$1 = (function (){var statearr_19088 = state_19082;
(statearr_19088[(8)] = inst_19013__$1);

return statearr_19088;
})();
if(cljs.core.truth_(inst_19014)){
var statearr_19089_19139 = state_19082__$1;
(statearr_19089_19139[(1)] = (5));

} else {
var statearr_19090_19140 = state_19082__$1;
(statearr_19090_19140[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (15))){
var inst_19055 = (state_19082[(2)]);
var state_19082__$1 = state_19082;
var statearr_19091_19141 = state_19082__$1;
(statearr_19091_19141[(2)] = inst_19055);

(statearr_19091_19141[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (21))){
var inst_19075 = (state_19082[(2)]);
var state_19082__$1 = (function (){var statearr_19092 = state_19082;
(statearr_19092[(9)] = inst_19075);

return statearr_19092;
})();
var statearr_19093_19142 = state_19082__$1;
(statearr_19093_19142[(2)] = null);

(statearr_19093_19142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (13))){
var inst_19037 = (state_19082[(10)]);
var inst_19039 = cljs.core.chunked_seq_QMARK_.call(null,inst_19037);
var state_19082__$1 = state_19082;
if(inst_19039){
var statearr_19094_19143 = state_19082__$1;
(statearr_19094_19143[(1)] = (16));

} else {
var statearr_19095_19144 = state_19082__$1;
(statearr_19095_19144[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (22))){
var inst_19067 = (state_19082[(2)]);
var state_19082__$1 = state_19082;
if(cljs.core.truth_(inst_19067)){
var statearr_19096_19145 = state_19082__$1;
(statearr_19096_19145[(1)] = (23));

} else {
var statearr_19097_19146 = state_19082__$1;
(statearr_19097_19146[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (6))){
var inst_19063 = (state_19082[(11)]);
var inst_19061 = (state_19082[(7)]);
var inst_19013 = (state_19082[(8)]);
var inst_19061__$1 = topic_fn.call(null,inst_19013);
var inst_19062 = cljs.core.deref.call(null,mults);
var inst_19063__$1 = cljs.core.get.call(null,inst_19062,inst_19061__$1);
var state_19082__$1 = (function (){var statearr_19098 = state_19082;
(statearr_19098[(11)] = inst_19063__$1);

(statearr_19098[(7)] = inst_19061__$1);

return statearr_19098;
})();
if(cljs.core.truth_(inst_19063__$1)){
var statearr_19099_19147 = state_19082__$1;
(statearr_19099_19147[(1)] = (19));

} else {
var statearr_19100_19148 = state_19082__$1;
(statearr_19100_19148[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (25))){
var inst_19072 = (state_19082[(2)]);
var state_19082__$1 = state_19082;
var statearr_19101_19149 = state_19082__$1;
(statearr_19101_19149[(2)] = inst_19072);

(statearr_19101_19149[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (17))){
var inst_19037 = (state_19082[(10)]);
var inst_19046 = cljs.core.first.call(null,inst_19037);
var inst_19047 = cljs.core.async.muxch_STAR_.call(null,inst_19046);
var inst_19048 = cljs.core.async.close_BANG_.call(null,inst_19047);
var inst_19049 = cljs.core.next.call(null,inst_19037);
var inst_19023 = inst_19049;
var inst_19024 = null;
var inst_19025 = (0);
var inst_19026 = (0);
var state_19082__$1 = (function (){var statearr_19102 = state_19082;
(statearr_19102[(12)] = inst_19026);

(statearr_19102[(13)] = inst_19023);

(statearr_19102[(14)] = inst_19025);

(statearr_19102[(15)] = inst_19048);

(statearr_19102[(16)] = inst_19024);

return statearr_19102;
})();
var statearr_19103_19150 = state_19082__$1;
(statearr_19103_19150[(2)] = null);

(statearr_19103_19150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (3))){
var inst_19080 = (state_19082[(2)]);
var state_19082__$1 = state_19082;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19082__$1,inst_19080);
} else {
if((state_val_19083 === (12))){
var inst_19057 = (state_19082[(2)]);
var state_19082__$1 = state_19082;
var statearr_19104_19151 = state_19082__$1;
(statearr_19104_19151[(2)] = inst_19057);

(statearr_19104_19151[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (2))){
var state_19082__$1 = state_19082;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19082__$1,(4),ch);
} else {
if((state_val_19083 === (23))){
var state_19082__$1 = state_19082;
var statearr_19105_19152 = state_19082__$1;
(statearr_19105_19152[(2)] = null);

(statearr_19105_19152[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (19))){
var inst_19063 = (state_19082[(11)]);
var inst_19013 = (state_19082[(8)]);
var inst_19065 = cljs.core.async.muxch_STAR_.call(null,inst_19063);
var state_19082__$1 = state_19082;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19082__$1,(22),inst_19065,inst_19013);
} else {
if((state_val_19083 === (11))){
var inst_19037 = (state_19082[(10)]);
var inst_19023 = (state_19082[(13)]);
var inst_19037__$1 = cljs.core.seq.call(null,inst_19023);
var state_19082__$1 = (function (){var statearr_19106 = state_19082;
(statearr_19106[(10)] = inst_19037__$1);

return statearr_19106;
})();
if(inst_19037__$1){
var statearr_19107_19153 = state_19082__$1;
(statearr_19107_19153[(1)] = (13));

} else {
var statearr_19108_19154 = state_19082__$1;
(statearr_19108_19154[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (9))){
var inst_19059 = (state_19082[(2)]);
var state_19082__$1 = state_19082;
var statearr_19109_19155 = state_19082__$1;
(statearr_19109_19155[(2)] = inst_19059);

(statearr_19109_19155[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (5))){
var inst_19020 = cljs.core.deref.call(null,mults);
var inst_19021 = cljs.core.vals.call(null,inst_19020);
var inst_19022 = cljs.core.seq.call(null,inst_19021);
var inst_19023 = inst_19022;
var inst_19024 = null;
var inst_19025 = (0);
var inst_19026 = (0);
var state_19082__$1 = (function (){var statearr_19110 = state_19082;
(statearr_19110[(12)] = inst_19026);

(statearr_19110[(13)] = inst_19023);

(statearr_19110[(14)] = inst_19025);

(statearr_19110[(16)] = inst_19024);

return statearr_19110;
})();
var statearr_19111_19156 = state_19082__$1;
(statearr_19111_19156[(2)] = null);

(statearr_19111_19156[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (14))){
var state_19082__$1 = state_19082;
var statearr_19115_19157 = state_19082__$1;
(statearr_19115_19157[(2)] = null);

(statearr_19115_19157[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (16))){
var inst_19037 = (state_19082[(10)]);
var inst_19041 = cljs.core.chunk_first.call(null,inst_19037);
var inst_19042 = cljs.core.chunk_rest.call(null,inst_19037);
var inst_19043 = cljs.core.count.call(null,inst_19041);
var inst_19023 = inst_19042;
var inst_19024 = inst_19041;
var inst_19025 = inst_19043;
var inst_19026 = (0);
var state_19082__$1 = (function (){var statearr_19116 = state_19082;
(statearr_19116[(12)] = inst_19026);

(statearr_19116[(13)] = inst_19023);

(statearr_19116[(14)] = inst_19025);

(statearr_19116[(16)] = inst_19024);

return statearr_19116;
})();
var statearr_19117_19158 = state_19082__$1;
(statearr_19117_19158[(2)] = null);

(statearr_19117_19158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (10))){
var inst_19026 = (state_19082[(12)]);
var inst_19023 = (state_19082[(13)]);
var inst_19025 = (state_19082[(14)]);
var inst_19024 = (state_19082[(16)]);
var inst_19031 = cljs.core._nth.call(null,inst_19024,inst_19026);
var inst_19032 = cljs.core.async.muxch_STAR_.call(null,inst_19031);
var inst_19033 = cljs.core.async.close_BANG_.call(null,inst_19032);
var inst_19034 = (inst_19026 + (1));
var tmp19112 = inst_19023;
var tmp19113 = inst_19025;
var tmp19114 = inst_19024;
var inst_19023__$1 = tmp19112;
var inst_19024__$1 = tmp19114;
var inst_19025__$1 = tmp19113;
var inst_19026__$1 = inst_19034;
var state_19082__$1 = (function (){var statearr_19118 = state_19082;
(statearr_19118[(12)] = inst_19026__$1);

(statearr_19118[(13)] = inst_19023__$1);

(statearr_19118[(14)] = inst_19025__$1);

(statearr_19118[(17)] = inst_19033);

(statearr_19118[(16)] = inst_19024__$1);

return statearr_19118;
})();
var statearr_19119_19159 = state_19082__$1;
(statearr_19119_19159[(2)] = null);

(statearr_19119_19159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (18))){
var inst_19052 = (state_19082[(2)]);
var state_19082__$1 = state_19082;
var statearr_19120_19160 = state_19082__$1;
(statearr_19120_19160[(2)] = inst_19052);

(statearr_19120_19160[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19083 === (8))){
var inst_19026 = (state_19082[(12)]);
var inst_19025 = (state_19082[(14)]);
var inst_19028 = (inst_19026 < inst_19025);
var inst_19029 = inst_19028;
var state_19082__$1 = state_19082;
if(cljs.core.truth_(inst_19029)){
var statearr_19121_19161 = state_19082__$1;
(statearr_19121_19161[(1)] = (10));

} else {
var statearr_19122_19162 = state_19082__$1;
(statearr_19122_19162[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19134,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19134,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19126 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19126[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19126[(1)] = (1));

return statearr_19126;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19082){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19082);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19127){if((e19127 instanceof Object)){
var ex__8254__auto__ = e19127;
var statearr_19128_19163 = state_19082;
(statearr_19128_19163[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19082);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19127;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19164 = state_19082;
state_19082 = G__19164;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19082){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19134,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19129 = f__8363__auto__.call(null);
(statearr_19129[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19134);

return statearr_19129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19134,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19165 = [];
var len__5726__auto___19168 = arguments.length;
var i__5727__auto___19169 = (0);
while(true){
if((i__5727__auto___19169 < len__5726__auto___19168)){
args19165.push((arguments[i__5727__auto___19169]));

var G__19170 = (i__5727__auto___19169 + (1));
i__5727__auto___19169 = G__19170;
continue;
} else {
}
break;
}

var G__19167 = args19165.length;
switch (G__19167) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19165.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19172 = [];
var len__5726__auto___19175 = arguments.length;
var i__5727__auto___19176 = (0);
while(true){
if((i__5727__auto___19176 < len__5726__auto___19175)){
args19172.push((arguments[i__5727__auto___19176]));

var G__19177 = (i__5727__auto___19176 + (1));
i__5727__auto___19176 = G__19177;
continue;
} else {
}
break;
}

var G__19174 = args19172.length;
switch (G__19174) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19172.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19179 = [];
var len__5726__auto___19250 = arguments.length;
var i__5727__auto___19251 = (0);
while(true){
if((i__5727__auto___19251 < len__5726__auto___19250)){
args19179.push((arguments[i__5727__auto___19251]));

var G__19252 = (i__5727__auto___19251 + (1));
i__5727__auto___19251 = G__19252;
continue;
} else {
}
break;
}

var G__19181 = args19179.length;
switch (G__19181) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19179.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19254 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19254,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19254,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19220){
var state_val_19221 = (state_19220[(1)]);
if((state_val_19221 === (7))){
var state_19220__$1 = state_19220;
var statearr_19222_19255 = state_19220__$1;
(statearr_19222_19255[(2)] = null);

(statearr_19222_19255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (1))){
var state_19220__$1 = state_19220;
var statearr_19223_19256 = state_19220__$1;
(statearr_19223_19256[(2)] = null);

(statearr_19223_19256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (4))){
var inst_19184 = (state_19220[(7)]);
var inst_19186 = (inst_19184 < cnt);
var state_19220__$1 = state_19220;
if(cljs.core.truth_(inst_19186)){
var statearr_19224_19257 = state_19220__$1;
(statearr_19224_19257[(1)] = (6));

} else {
var statearr_19225_19258 = state_19220__$1;
(statearr_19225_19258[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (15))){
var inst_19216 = (state_19220[(2)]);
var state_19220__$1 = state_19220;
var statearr_19226_19259 = state_19220__$1;
(statearr_19226_19259[(2)] = inst_19216);

(statearr_19226_19259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (13))){
var inst_19209 = cljs.core.async.close_BANG_.call(null,out);
var state_19220__$1 = state_19220;
var statearr_19227_19260 = state_19220__$1;
(statearr_19227_19260[(2)] = inst_19209);

(statearr_19227_19260[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (6))){
var state_19220__$1 = state_19220;
var statearr_19228_19261 = state_19220__$1;
(statearr_19228_19261[(2)] = null);

(statearr_19228_19261[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (3))){
var inst_19218 = (state_19220[(2)]);
var state_19220__$1 = state_19220;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19220__$1,inst_19218);
} else {
if((state_val_19221 === (12))){
var inst_19206 = (state_19220[(8)]);
var inst_19206__$1 = (state_19220[(2)]);
var inst_19207 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19206__$1);
var state_19220__$1 = (function (){var statearr_19229 = state_19220;
(statearr_19229[(8)] = inst_19206__$1);

return statearr_19229;
})();
if(cljs.core.truth_(inst_19207)){
var statearr_19230_19262 = state_19220__$1;
(statearr_19230_19262[(1)] = (13));

} else {
var statearr_19231_19263 = state_19220__$1;
(statearr_19231_19263[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (2))){
var inst_19183 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19184 = (0);
var state_19220__$1 = (function (){var statearr_19232 = state_19220;
(statearr_19232[(7)] = inst_19184);

(statearr_19232[(9)] = inst_19183);

return statearr_19232;
})();
var statearr_19233_19264 = state_19220__$1;
(statearr_19233_19264[(2)] = null);

(statearr_19233_19264[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (11))){
var inst_19184 = (state_19220[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19220,(10),Object,null,(9));
var inst_19193 = chs__$1.call(null,inst_19184);
var inst_19194 = done.call(null,inst_19184);
var inst_19195 = cljs.core.async.take_BANG_.call(null,inst_19193,inst_19194);
var state_19220__$1 = state_19220;
var statearr_19234_19265 = state_19220__$1;
(statearr_19234_19265[(2)] = inst_19195);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19220__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (9))){
var inst_19184 = (state_19220[(7)]);
var inst_19197 = (state_19220[(2)]);
var inst_19198 = (inst_19184 + (1));
var inst_19184__$1 = inst_19198;
var state_19220__$1 = (function (){var statearr_19235 = state_19220;
(statearr_19235[(10)] = inst_19197);

(statearr_19235[(7)] = inst_19184__$1);

return statearr_19235;
})();
var statearr_19236_19266 = state_19220__$1;
(statearr_19236_19266[(2)] = null);

(statearr_19236_19266[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (5))){
var inst_19204 = (state_19220[(2)]);
var state_19220__$1 = (function (){var statearr_19237 = state_19220;
(statearr_19237[(11)] = inst_19204);

return statearr_19237;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19220__$1,(12),dchan);
} else {
if((state_val_19221 === (14))){
var inst_19206 = (state_19220[(8)]);
var inst_19211 = cljs.core.apply.call(null,f,inst_19206);
var state_19220__$1 = state_19220;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19220__$1,(16),out,inst_19211);
} else {
if((state_val_19221 === (16))){
var inst_19213 = (state_19220[(2)]);
var state_19220__$1 = (function (){var statearr_19238 = state_19220;
(statearr_19238[(12)] = inst_19213);

return statearr_19238;
})();
var statearr_19239_19267 = state_19220__$1;
(statearr_19239_19267[(2)] = null);

(statearr_19239_19267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (10))){
var inst_19188 = (state_19220[(2)]);
var inst_19189 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19220__$1 = (function (){var statearr_19240 = state_19220;
(statearr_19240[(13)] = inst_19188);

return statearr_19240;
})();
var statearr_19241_19268 = state_19220__$1;
(statearr_19241_19268[(2)] = inst_19189);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19220__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19221 === (8))){
var inst_19202 = (state_19220[(2)]);
var state_19220__$1 = state_19220;
var statearr_19242_19269 = state_19220__$1;
(statearr_19242_19269[(2)] = inst_19202);

(statearr_19242_19269[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19254,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19254,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19246 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19246[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19246[(1)] = (1));

return statearr_19246;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19220){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19220);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19247){if((e19247 instanceof Object)){
var ex__8254__auto__ = e19247;
var statearr_19248_19270 = state_19220;
(statearr_19248_19270[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19220);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19247;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19271 = state_19220;
state_19220 = G__19271;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19220){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19254,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19249 = f__8363__auto__.call(null);
(statearr_19249[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19254);

return statearr_19249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19254,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19273 = [];
var len__5726__auto___19329 = arguments.length;
var i__5727__auto___19330 = (0);
while(true){
if((i__5727__auto___19330 < len__5726__auto___19329)){
args19273.push((arguments[i__5727__auto___19330]));

var G__19331 = (i__5727__auto___19330 + (1));
i__5727__auto___19330 = G__19331;
continue;
} else {
}
break;
}

var G__19275 = args19273.length;
switch (G__19275) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19273.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19333 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19333,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19333,out){
return (function (state_19305){
var state_val_19306 = (state_19305[(1)]);
if((state_val_19306 === (7))){
var inst_19285 = (state_19305[(7)]);
var inst_19284 = (state_19305[(8)]);
var inst_19284__$1 = (state_19305[(2)]);
var inst_19285__$1 = cljs.core.nth.call(null,inst_19284__$1,(0),null);
var inst_19286 = cljs.core.nth.call(null,inst_19284__$1,(1),null);
var inst_19287 = (inst_19285__$1 == null);
var state_19305__$1 = (function (){var statearr_19307 = state_19305;
(statearr_19307[(7)] = inst_19285__$1);

(statearr_19307[(8)] = inst_19284__$1);

(statearr_19307[(9)] = inst_19286);

return statearr_19307;
})();
if(cljs.core.truth_(inst_19287)){
var statearr_19308_19334 = state_19305__$1;
(statearr_19308_19334[(1)] = (8));

} else {
var statearr_19309_19335 = state_19305__$1;
(statearr_19309_19335[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19306 === (1))){
var inst_19276 = cljs.core.vec.call(null,chs);
var inst_19277 = inst_19276;
var state_19305__$1 = (function (){var statearr_19310 = state_19305;
(statearr_19310[(10)] = inst_19277);

return statearr_19310;
})();
var statearr_19311_19336 = state_19305__$1;
(statearr_19311_19336[(2)] = null);

(statearr_19311_19336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19306 === (4))){
var inst_19277 = (state_19305[(10)]);
var state_19305__$1 = state_19305;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19305__$1,(7),inst_19277);
} else {
if((state_val_19306 === (6))){
var inst_19301 = (state_19305[(2)]);
var state_19305__$1 = state_19305;
var statearr_19312_19337 = state_19305__$1;
(statearr_19312_19337[(2)] = inst_19301);

(statearr_19312_19337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19306 === (3))){
var inst_19303 = (state_19305[(2)]);
var state_19305__$1 = state_19305;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19305__$1,inst_19303);
} else {
if((state_val_19306 === (2))){
var inst_19277 = (state_19305[(10)]);
var inst_19279 = cljs.core.count.call(null,inst_19277);
var inst_19280 = (inst_19279 > (0));
var state_19305__$1 = state_19305;
if(cljs.core.truth_(inst_19280)){
var statearr_19314_19338 = state_19305__$1;
(statearr_19314_19338[(1)] = (4));

} else {
var statearr_19315_19339 = state_19305__$1;
(statearr_19315_19339[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19306 === (11))){
var inst_19277 = (state_19305[(10)]);
var inst_19294 = (state_19305[(2)]);
var tmp19313 = inst_19277;
var inst_19277__$1 = tmp19313;
var state_19305__$1 = (function (){var statearr_19316 = state_19305;
(statearr_19316[(10)] = inst_19277__$1);

(statearr_19316[(11)] = inst_19294);

return statearr_19316;
})();
var statearr_19317_19340 = state_19305__$1;
(statearr_19317_19340[(2)] = null);

(statearr_19317_19340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19306 === (9))){
var inst_19285 = (state_19305[(7)]);
var state_19305__$1 = state_19305;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19305__$1,(11),out,inst_19285);
} else {
if((state_val_19306 === (5))){
var inst_19299 = cljs.core.async.close_BANG_.call(null,out);
var state_19305__$1 = state_19305;
var statearr_19318_19341 = state_19305__$1;
(statearr_19318_19341[(2)] = inst_19299);

(statearr_19318_19341[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19306 === (10))){
var inst_19297 = (state_19305[(2)]);
var state_19305__$1 = state_19305;
var statearr_19319_19342 = state_19305__$1;
(statearr_19319_19342[(2)] = inst_19297);

(statearr_19319_19342[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19306 === (8))){
var inst_19277 = (state_19305[(10)]);
var inst_19285 = (state_19305[(7)]);
var inst_19284 = (state_19305[(8)]);
var inst_19286 = (state_19305[(9)]);
var inst_19289 = (function (){var cs = inst_19277;
var vec__19282 = inst_19284;
var v = inst_19285;
var c = inst_19286;
return ((function (cs,vec__19282,v,c,inst_19277,inst_19285,inst_19284,inst_19286,state_val_19306,c__8362__auto___19333,out){
return (function (p1__19272_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19272_SHARP_);
});
;})(cs,vec__19282,v,c,inst_19277,inst_19285,inst_19284,inst_19286,state_val_19306,c__8362__auto___19333,out))
})();
var inst_19290 = cljs.core.filterv.call(null,inst_19289,inst_19277);
var inst_19277__$1 = inst_19290;
var state_19305__$1 = (function (){var statearr_19320 = state_19305;
(statearr_19320[(10)] = inst_19277__$1);

return statearr_19320;
})();
var statearr_19321_19343 = state_19305__$1;
(statearr_19321_19343[(2)] = null);

(statearr_19321_19343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19333,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19333,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19325 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19325[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19325[(1)] = (1));

return statearr_19325;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19305){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19305);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19326){if((e19326 instanceof Object)){
var ex__8254__auto__ = e19326;
var statearr_19327_19344 = state_19305;
(statearr_19327_19344[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19305);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19326;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19345 = state_19305;
state_19305 = G__19345;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19305){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19333,out))
})();
var state__8364__auto__ = (function (){var statearr_19328 = f__8363__auto__.call(null);
(statearr_19328[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19333);

return statearr_19328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19333,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19346 = [];
var len__5726__auto___19395 = arguments.length;
var i__5727__auto___19396 = (0);
while(true){
if((i__5727__auto___19396 < len__5726__auto___19395)){
args19346.push((arguments[i__5727__auto___19396]));

var G__19397 = (i__5727__auto___19396 + (1));
i__5727__auto___19396 = G__19397;
continue;
} else {
}
break;
}

var G__19348 = args19346.length;
switch (G__19348) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19346.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19399 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19399,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19399,out){
return (function (state_19372){
var state_val_19373 = (state_19372[(1)]);
if((state_val_19373 === (7))){
var inst_19354 = (state_19372[(7)]);
var inst_19354__$1 = (state_19372[(2)]);
var inst_19355 = (inst_19354__$1 == null);
var inst_19356 = cljs.core.not.call(null,inst_19355);
var state_19372__$1 = (function (){var statearr_19374 = state_19372;
(statearr_19374[(7)] = inst_19354__$1);

return statearr_19374;
})();
if(inst_19356){
var statearr_19375_19400 = state_19372__$1;
(statearr_19375_19400[(1)] = (8));

} else {
var statearr_19376_19401 = state_19372__$1;
(statearr_19376_19401[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19373 === (1))){
var inst_19349 = (0);
var state_19372__$1 = (function (){var statearr_19377 = state_19372;
(statearr_19377[(8)] = inst_19349);

return statearr_19377;
})();
var statearr_19378_19402 = state_19372__$1;
(statearr_19378_19402[(2)] = null);

(statearr_19378_19402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19373 === (4))){
var state_19372__$1 = state_19372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19372__$1,(7),ch);
} else {
if((state_val_19373 === (6))){
var inst_19367 = (state_19372[(2)]);
var state_19372__$1 = state_19372;
var statearr_19379_19403 = state_19372__$1;
(statearr_19379_19403[(2)] = inst_19367);

(statearr_19379_19403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19373 === (3))){
var inst_19369 = (state_19372[(2)]);
var inst_19370 = cljs.core.async.close_BANG_.call(null,out);
var state_19372__$1 = (function (){var statearr_19380 = state_19372;
(statearr_19380[(9)] = inst_19369);

return statearr_19380;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19372__$1,inst_19370);
} else {
if((state_val_19373 === (2))){
var inst_19349 = (state_19372[(8)]);
var inst_19351 = (inst_19349 < n);
var state_19372__$1 = state_19372;
if(cljs.core.truth_(inst_19351)){
var statearr_19381_19404 = state_19372__$1;
(statearr_19381_19404[(1)] = (4));

} else {
var statearr_19382_19405 = state_19372__$1;
(statearr_19382_19405[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19373 === (11))){
var inst_19349 = (state_19372[(8)]);
var inst_19359 = (state_19372[(2)]);
var inst_19360 = (inst_19349 + (1));
var inst_19349__$1 = inst_19360;
var state_19372__$1 = (function (){var statearr_19383 = state_19372;
(statearr_19383[(10)] = inst_19359);

(statearr_19383[(8)] = inst_19349__$1);

return statearr_19383;
})();
var statearr_19384_19406 = state_19372__$1;
(statearr_19384_19406[(2)] = null);

(statearr_19384_19406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19373 === (9))){
var state_19372__$1 = state_19372;
var statearr_19385_19407 = state_19372__$1;
(statearr_19385_19407[(2)] = null);

(statearr_19385_19407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19373 === (5))){
var state_19372__$1 = state_19372;
var statearr_19386_19408 = state_19372__$1;
(statearr_19386_19408[(2)] = null);

(statearr_19386_19408[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19373 === (10))){
var inst_19364 = (state_19372[(2)]);
var state_19372__$1 = state_19372;
var statearr_19387_19409 = state_19372__$1;
(statearr_19387_19409[(2)] = inst_19364);

(statearr_19387_19409[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19373 === (8))){
var inst_19354 = (state_19372[(7)]);
var state_19372__$1 = state_19372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19372__$1,(11),out,inst_19354);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19399,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19399,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19391 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19391[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19391[(1)] = (1));

return statearr_19391;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19372){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19392){if((e19392 instanceof Object)){
var ex__8254__auto__ = e19392;
var statearr_19393_19410 = state_19372;
(statearr_19393_19410[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19392;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19411 = state_19372;
state_19372 = G__19411;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19399,out))
})();
var state__8364__auto__ = (function (){var statearr_19394 = f__8363__auto__.call(null);
(statearr_19394[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19399);

return statearr_19394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19399,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19419 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19419 = (function (map_LT_,f,ch,meta19420){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19420 = meta19420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19421,meta19420__$1){
var self__ = this;
var _19421__$1 = this;
return (new cljs.core.async.t_cljs$core$async19419(self__.map_LT_,self__.f,self__.ch,meta19420__$1));
});

cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19421){
var self__ = this;
var _19421__$1 = this;
return self__.meta19420;
});

cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19422 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19422 = (function (map_LT_,f,ch,meta19420,_,fn1,meta19423){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19420 = meta19420;
this._ = _;
this.fn1 = fn1;
this.meta19423 = meta19423;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19422.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19424,meta19423__$1){
var self__ = this;
var _19424__$1 = this;
return (new cljs.core.async.t_cljs$core$async19422(self__.map_LT_,self__.f,self__.ch,self__.meta19420,self__._,self__.fn1,meta19423__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19422.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19424){
var self__ = this;
var _19424__$1 = this;
return self__.meta19423;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19422.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19422.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19422.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19422.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19412_SHARP_){
return f1.call(null,(((p1__19412_SHARP_ == null))?null:self__.f.call(null,p1__19412_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19422.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19420","meta19420",1177920386,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19419","cljs.core.async/t_cljs$core$async19419",-402491807,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19423","meta19423",-1218875770,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19422.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19422.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19422";

cljs.core.async.t_cljs$core$async19422.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19422");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19422 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19422(map_LT___$1,f__$1,ch__$1,meta19420__$1,___$2,fn1__$1,meta19423){
return (new cljs.core.async.t_cljs$core$async19422(map_LT___$1,f__$1,ch__$1,meta19420__$1,___$2,fn1__$1,meta19423));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19422(self__.map_LT_,self__.f,self__.ch,self__.meta19420,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19419.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19419.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19420","meta19420",1177920386,null)], null);
});

cljs.core.async.t_cljs$core$async19419.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19419.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19419";

cljs.core.async.t_cljs$core$async19419.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19419");
});

cljs.core.async.__GT_t_cljs$core$async19419 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19419(map_LT___$1,f__$1,ch__$1,meta19420){
return (new cljs.core.async.t_cljs$core$async19419(map_LT___$1,f__$1,ch__$1,meta19420));
});

}

return (new cljs.core.async.t_cljs$core$async19419(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19428 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19428 = (function (map_GT_,f,ch,meta19429){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19429 = meta19429;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19428.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19430,meta19429__$1){
var self__ = this;
var _19430__$1 = this;
return (new cljs.core.async.t_cljs$core$async19428(self__.map_GT_,self__.f,self__.ch,meta19429__$1));
});

cljs.core.async.t_cljs$core$async19428.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19430){
var self__ = this;
var _19430__$1 = this;
return self__.meta19429;
});

cljs.core.async.t_cljs$core$async19428.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19428.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19428.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19428.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19428.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19428.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19428.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19429","meta19429",-1574208579,null)], null);
});

cljs.core.async.t_cljs$core$async19428.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19428.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19428";

cljs.core.async.t_cljs$core$async19428.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19428");
});

cljs.core.async.__GT_t_cljs$core$async19428 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19428(map_GT___$1,f__$1,ch__$1,meta19429){
return (new cljs.core.async.t_cljs$core$async19428(map_GT___$1,f__$1,ch__$1,meta19429));
});

}

return (new cljs.core.async.t_cljs$core$async19428(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19434 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19434 = (function (filter_GT_,p,ch,meta19435){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19435 = meta19435;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19436,meta19435__$1){
var self__ = this;
var _19436__$1 = this;
return (new cljs.core.async.t_cljs$core$async19434(self__.filter_GT_,self__.p,self__.ch,meta19435__$1));
});

cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19436){
var self__ = this;
var _19436__$1 = this;
return self__.meta19435;
});

cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19434.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19434.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19435","meta19435",158260694,null)], null);
});

cljs.core.async.t_cljs$core$async19434.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19434.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19434";

cljs.core.async.t_cljs$core$async19434.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19434");
});

cljs.core.async.__GT_t_cljs$core$async19434 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19434(filter_GT___$1,p__$1,ch__$1,meta19435){
return (new cljs.core.async.t_cljs$core$async19434(filter_GT___$1,p__$1,ch__$1,meta19435));
});

}

return (new cljs.core.async.t_cljs$core$async19434(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19437 = [];
var len__5726__auto___19481 = arguments.length;
var i__5727__auto___19482 = (0);
while(true){
if((i__5727__auto___19482 < len__5726__auto___19481)){
args19437.push((arguments[i__5727__auto___19482]));

var G__19483 = (i__5727__auto___19482 + (1));
i__5727__auto___19482 = G__19483;
continue;
} else {
}
break;
}

var G__19439 = args19437.length;
switch (G__19439) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19437.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19485 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19485,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19485,out){
return (function (state_19460){
var state_val_19461 = (state_19460[(1)]);
if((state_val_19461 === (7))){
var inst_19456 = (state_19460[(2)]);
var state_19460__$1 = state_19460;
var statearr_19462_19486 = state_19460__$1;
(statearr_19462_19486[(2)] = inst_19456);

(statearr_19462_19486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19461 === (1))){
var state_19460__$1 = state_19460;
var statearr_19463_19487 = state_19460__$1;
(statearr_19463_19487[(2)] = null);

(statearr_19463_19487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19461 === (4))){
var inst_19442 = (state_19460[(7)]);
var inst_19442__$1 = (state_19460[(2)]);
var inst_19443 = (inst_19442__$1 == null);
var state_19460__$1 = (function (){var statearr_19464 = state_19460;
(statearr_19464[(7)] = inst_19442__$1);

return statearr_19464;
})();
if(cljs.core.truth_(inst_19443)){
var statearr_19465_19488 = state_19460__$1;
(statearr_19465_19488[(1)] = (5));

} else {
var statearr_19466_19489 = state_19460__$1;
(statearr_19466_19489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19461 === (6))){
var inst_19442 = (state_19460[(7)]);
var inst_19447 = p.call(null,inst_19442);
var state_19460__$1 = state_19460;
if(cljs.core.truth_(inst_19447)){
var statearr_19467_19490 = state_19460__$1;
(statearr_19467_19490[(1)] = (8));

} else {
var statearr_19468_19491 = state_19460__$1;
(statearr_19468_19491[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19461 === (3))){
var inst_19458 = (state_19460[(2)]);
var state_19460__$1 = state_19460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19460__$1,inst_19458);
} else {
if((state_val_19461 === (2))){
var state_19460__$1 = state_19460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19460__$1,(4),ch);
} else {
if((state_val_19461 === (11))){
var inst_19450 = (state_19460[(2)]);
var state_19460__$1 = state_19460;
var statearr_19469_19492 = state_19460__$1;
(statearr_19469_19492[(2)] = inst_19450);

(statearr_19469_19492[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19461 === (9))){
var state_19460__$1 = state_19460;
var statearr_19470_19493 = state_19460__$1;
(statearr_19470_19493[(2)] = null);

(statearr_19470_19493[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19461 === (5))){
var inst_19445 = cljs.core.async.close_BANG_.call(null,out);
var state_19460__$1 = state_19460;
var statearr_19471_19494 = state_19460__$1;
(statearr_19471_19494[(2)] = inst_19445);

(statearr_19471_19494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19461 === (10))){
var inst_19453 = (state_19460[(2)]);
var state_19460__$1 = (function (){var statearr_19472 = state_19460;
(statearr_19472[(8)] = inst_19453);

return statearr_19472;
})();
var statearr_19473_19495 = state_19460__$1;
(statearr_19473_19495[(2)] = null);

(statearr_19473_19495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19461 === (8))){
var inst_19442 = (state_19460[(7)]);
var state_19460__$1 = state_19460;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19460__$1,(11),out,inst_19442);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19485,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19485,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19477 = [null,null,null,null,null,null,null,null,null];
(statearr_19477[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19477[(1)] = (1));

return statearr_19477;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19460){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19478){if((e19478 instanceof Object)){
var ex__8254__auto__ = e19478;
var statearr_19479_19496 = state_19460;
(statearr_19479_19496[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19460);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19478;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19497 = state_19460;
state_19460 = G__19497;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19460){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19485,out))
})();
var state__8364__auto__ = (function (){var statearr_19480 = f__8363__auto__.call(null);
(statearr_19480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19485);

return statearr_19480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19485,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19498 = [];
var len__5726__auto___19501 = arguments.length;
var i__5727__auto___19502 = (0);
while(true){
if((i__5727__auto___19502 < len__5726__auto___19501)){
args19498.push((arguments[i__5727__auto___19502]));

var G__19503 = (i__5727__auto___19502 + (1));
i__5727__auto___19502 = G__19503;
continue;
} else {
}
break;
}

var G__19500 = args19498.length;
switch (G__19500) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19498.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19670){
var state_val_19671 = (state_19670[(1)]);
if((state_val_19671 === (7))){
var inst_19666 = (state_19670[(2)]);
var state_19670__$1 = state_19670;
var statearr_19672_19713 = state_19670__$1;
(statearr_19672_19713[(2)] = inst_19666);

(statearr_19672_19713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (20))){
var inst_19636 = (state_19670[(7)]);
var inst_19647 = (state_19670[(2)]);
var inst_19648 = cljs.core.next.call(null,inst_19636);
var inst_19622 = inst_19648;
var inst_19623 = null;
var inst_19624 = (0);
var inst_19625 = (0);
var state_19670__$1 = (function (){var statearr_19673 = state_19670;
(statearr_19673[(8)] = inst_19622);

(statearr_19673[(9)] = inst_19624);

(statearr_19673[(10)] = inst_19623);

(statearr_19673[(11)] = inst_19625);

(statearr_19673[(12)] = inst_19647);

return statearr_19673;
})();
var statearr_19674_19714 = state_19670__$1;
(statearr_19674_19714[(2)] = null);

(statearr_19674_19714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (1))){
var state_19670__$1 = state_19670;
var statearr_19675_19715 = state_19670__$1;
(statearr_19675_19715[(2)] = null);

(statearr_19675_19715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (4))){
var inst_19611 = (state_19670[(13)]);
var inst_19611__$1 = (state_19670[(2)]);
var inst_19612 = (inst_19611__$1 == null);
var state_19670__$1 = (function (){var statearr_19676 = state_19670;
(statearr_19676[(13)] = inst_19611__$1);

return statearr_19676;
})();
if(cljs.core.truth_(inst_19612)){
var statearr_19677_19716 = state_19670__$1;
(statearr_19677_19716[(1)] = (5));

} else {
var statearr_19678_19717 = state_19670__$1;
(statearr_19678_19717[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (15))){
var state_19670__$1 = state_19670;
var statearr_19682_19718 = state_19670__$1;
(statearr_19682_19718[(2)] = null);

(statearr_19682_19718[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (21))){
var state_19670__$1 = state_19670;
var statearr_19683_19719 = state_19670__$1;
(statearr_19683_19719[(2)] = null);

(statearr_19683_19719[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (13))){
var inst_19622 = (state_19670[(8)]);
var inst_19624 = (state_19670[(9)]);
var inst_19623 = (state_19670[(10)]);
var inst_19625 = (state_19670[(11)]);
var inst_19632 = (state_19670[(2)]);
var inst_19633 = (inst_19625 + (1));
var tmp19679 = inst_19622;
var tmp19680 = inst_19624;
var tmp19681 = inst_19623;
var inst_19622__$1 = tmp19679;
var inst_19623__$1 = tmp19681;
var inst_19624__$1 = tmp19680;
var inst_19625__$1 = inst_19633;
var state_19670__$1 = (function (){var statearr_19684 = state_19670;
(statearr_19684[(8)] = inst_19622__$1);

(statearr_19684[(9)] = inst_19624__$1);

(statearr_19684[(14)] = inst_19632);

(statearr_19684[(10)] = inst_19623__$1);

(statearr_19684[(11)] = inst_19625__$1);

return statearr_19684;
})();
var statearr_19685_19720 = state_19670__$1;
(statearr_19685_19720[(2)] = null);

(statearr_19685_19720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (22))){
var state_19670__$1 = state_19670;
var statearr_19686_19721 = state_19670__$1;
(statearr_19686_19721[(2)] = null);

(statearr_19686_19721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (6))){
var inst_19611 = (state_19670[(13)]);
var inst_19620 = f.call(null,inst_19611);
var inst_19621 = cljs.core.seq.call(null,inst_19620);
var inst_19622 = inst_19621;
var inst_19623 = null;
var inst_19624 = (0);
var inst_19625 = (0);
var state_19670__$1 = (function (){var statearr_19687 = state_19670;
(statearr_19687[(8)] = inst_19622);

(statearr_19687[(9)] = inst_19624);

(statearr_19687[(10)] = inst_19623);

(statearr_19687[(11)] = inst_19625);

return statearr_19687;
})();
var statearr_19688_19722 = state_19670__$1;
(statearr_19688_19722[(2)] = null);

(statearr_19688_19722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (17))){
var inst_19636 = (state_19670[(7)]);
var inst_19640 = cljs.core.chunk_first.call(null,inst_19636);
var inst_19641 = cljs.core.chunk_rest.call(null,inst_19636);
var inst_19642 = cljs.core.count.call(null,inst_19640);
var inst_19622 = inst_19641;
var inst_19623 = inst_19640;
var inst_19624 = inst_19642;
var inst_19625 = (0);
var state_19670__$1 = (function (){var statearr_19689 = state_19670;
(statearr_19689[(8)] = inst_19622);

(statearr_19689[(9)] = inst_19624);

(statearr_19689[(10)] = inst_19623);

(statearr_19689[(11)] = inst_19625);

return statearr_19689;
})();
var statearr_19690_19723 = state_19670__$1;
(statearr_19690_19723[(2)] = null);

(statearr_19690_19723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (3))){
var inst_19668 = (state_19670[(2)]);
var state_19670__$1 = state_19670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19670__$1,inst_19668);
} else {
if((state_val_19671 === (12))){
var inst_19656 = (state_19670[(2)]);
var state_19670__$1 = state_19670;
var statearr_19691_19724 = state_19670__$1;
(statearr_19691_19724[(2)] = inst_19656);

(statearr_19691_19724[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (2))){
var state_19670__$1 = state_19670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19670__$1,(4),in$);
} else {
if((state_val_19671 === (23))){
var inst_19664 = (state_19670[(2)]);
var state_19670__$1 = state_19670;
var statearr_19692_19725 = state_19670__$1;
(statearr_19692_19725[(2)] = inst_19664);

(statearr_19692_19725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (19))){
var inst_19651 = (state_19670[(2)]);
var state_19670__$1 = state_19670;
var statearr_19693_19726 = state_19670__$1;
(statearr_19693_19726[(2)] = inst_19651);

(statearr_19693_19726[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (11))){
var inst_19622 = (state_19670[(8)]);
var inst_19636 = (state_19670[(7)]);
var inst_19636__$1 = cljs.core.seq.call(null,inst_19622);
var state_19670__$1 = (function (){var statearr_19694 = state_19670;
(statearr_19694[(7)] = inst_19636__$1);

return statearr_19694;
})();
if(inst_19636__$1){
var statearr_19695_19727 = state_19670__$1;
(statearr_19695_19727[(1)] = (14));

} else {
var statearr_19696_19728 = state_19670__$1;
(statearr_19696_19728[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (9))){
var inst_19658 = (state_19670[(2)]);
var inst_19659 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19670__$1 = (function (){var statearr_19697 = state_19670;
(statearr_19697[(15)] = inst_19658);

return statearr_19697;
})();
if(cljs.core.truth_(inst_19659)){
var statearr_19698_19729 = state_19670__$1;
(statearr_19698_19729[(1)] = (21));

} else {
var statearr_19699_19730 = state_19670__$1;
(statearr_19699_19730[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (5))){
var inst_19614 = cljs.core.async.close_BANG_.call(null,out);
var state_19670__$1 = state_19670;
var statearr_19700_19731 = state_19670__$1;
(statearr_19700_19731[(2)] = inst_19614);

(statearr_19700_19731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (14))){
var inst_19636 = (state_19670[(7)]);
var inst_19638 = cljs.core.chunked_seq_QMARK_.call(null,inst_19636);
var state_19670__$1 = state_19670;
if(inst_19638){
var statearr_19701_19732 = state_19670__$1;
(statearr_19701_19732[(1)] = (17));

} else {
var statearr_19702_19733 = state_19670__$1;
(statearr_19702_19733[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (16))){
var inst_19654 = (state_19670[(2)]);
var state_19670__$1 = state_19670;
var statearr_19703_19734 = state_19670__$1;
(statearr_19703_19734[(2)] = inst_19654);

(statearr_19703_19734[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19671 === (10))){
var inst_19623 = (state_19670[(10)]);
var inst_19625 = (state_19670[(11)]);
var inst_19630 = cljs.core._nth.call(null,inst_19623,inst_19625);
var state_19670__$1 = state_19670;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19670__$1,(13),out,inst_19630);
} else {
if((state_val_19671 === (18))){
var inst_19636 = (state_19670[(7)]);
var inst_19645 = cljs.core.first.call(null,inst_19636);
var state_19670__$1 = state_19670;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19670__$1,(20),out,inst_19645);
} else {
if((state_val_19671 === (8))){
var inst_19624 = (state_19670[(9)]);
var inst_19625 = (state_19670[(11)]);
var inst_19627 = (inst_19625 < inst_19624);
var inst_19628 = inst_19627;
var state_19670__$1 = state_19670;
if(cljs.core.truth_(inst_19628)){
var statearr_19704_19735 = state_19670__$1;
(statearr_19704_19735[(1)] = (10));

} else {
var statearr_19705_19736 = state_19670__$1;
(statearr_19705_19736[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19709[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19709[(1)] = (1));

return statearr_19709;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19670){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19710){if((e19710 instanceof Object)){
var ex__8254__auto__ = e19710;
var statearr_19711_19737 = state_19670;
(statearr_19711_19737[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19670);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19710;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19738 = state_19670;
state_19670 = G__19738;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19670){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19712 = f__8363__auto__.call(null);
(statearr_19712[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19739 = [];
var len__5726__auto___19742 = arguments.length;
var i__5727__auto___19743 = (0);
while(true){
if((i__5727__auto___19743 < len__5726__auto___19742)){
args19739.push((arguments[i__5727__auto___19743]));

var G__19744 = (i__5727__auto___19743 + (1));
i__5727__auto___19743 = G__19744;
continue;
} else {
}
break;
}

var G__19741 = args19739.length;
switch (G__19741) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19739.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19746 = [];
var len__5726__auto___19749 = arguments.length;
var i__5727__auto___19750 = (0);
while(true){
if((i__5727__auto___19750 < len__5726__auto___19749)){
args19746.push((arguments[i__5727__auto___19750]));

var G__19751 = (i__5727__auto___19750 + (1));
i__5727__auto___19750 = G__19751;
continue;
} else {
}
break;
}

var G__19748 = args19746.length;
switch (G__19748) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19746.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19753 = [];
var len__5726__auto___19804 = arguments.length;
var i__5727__auto___19805 = (0);
while(true){
if((i__5727__auto___19805 < len__5726__auto___19804)){
args19753.push((arguments[i__5727__auto___19805]));

var G__19806 = (i__5727__auto___19805 + (1));
i__5727__auto___19805 = G__19806;
continue;
} else {
}
break;
}

var G__19755 = args19753.length;
switch (G__19755) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19753.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19808 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19808,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19808,out){
return (function (state_19779){
var state_val_19780 = (state_19779[(1)]);
if((state_val_19780 === (7))){
var inst_19774 = (state_19779[(2)]);
var state_19779__$1 = state_19779;
var statearr_19781_19809 = state_19779__$1;
(statearr_19781_19809[(2)] = inst_19774);

(statearr_19781_19809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (1))){
var inst_19756 = null;
var state_19779__$1 = (function (){var statearr_19782 = state_19779;
(statearr_19782[(7)] = inst_19756);

return statearr_19782;
})();
var statearr_19783_19810 = state_19779__$1;
(statearr_19783_19810[(2)] = null);

(statearr_19783_19810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (4))){
var inst_19759 = (state_19779[(8)]);
var inst_19759__$1 = (state_19779[(2)]);
var inst_19760 = (inst_19759__$1 == null);
var inst_19761 = cljs.core.not.call(null,inst_19760);
var state_19779__$1 = (function (){var statearr_19784 = state_19779;
(statearr_19784[(8)] = inst_19759__$1);

return statearr_19784;
})();
if(inst_19761){
var statearr_19785_19811 = state_19779__$1;
(statearr_19785_19811[(1)] = (5));

} else {
var statearr_19786_19812 = state_19779__$1;
(statearr_19786_19812[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (6))){
var state_19779__$1 = state_19779;
var statearr_19787_19813 = state_19779__$1;
(statearr_19787_19813[(2)] = null);

(statearr_19787_19813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (3))){
var inst_19776 = (state_19779[(2)]);
var inst_19777 = cljs.core.async.close_BANG_.call(null,out);
var state_19779__$1 = (function (){var statearr_19788 = state_19779;
(statearr_19788[(9)] = inst_19776);

return statearr_19788;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19779__$1,inst_19777);
} else {
if((state_val_19780 === (2))){
var state_19779__$1 = state_19779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19779__$1,(4),ch);
} else {
if((state_val_19780 === (11))){
var inst_19759 = (state_19779[(8)]);
var inst_19768 = (state_19779[(2)]);
var inst_19756 = inst_19759;
var state_19779__$1 = (function (){var statearr_19789 = state_19779;
(statearr_19789[(10)] = inst_19768);

(statearr_19789[(7)] = inst_19756);

return statearr_19789;
})();
var statearr_19790_19814 = state_19779__$1;
(statearr_19790_19814[(2)] = null);

(statearr_19790_19814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (9))){
var inst_19759 = (state_19779[(8)]);
var state_19779__$1 = state_19779;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19779__$1,(11),out,inst_19759);
} else {
if((state_val_19780 === (5))){
var inst_19759 = (state_19779[(8)]);
var inst_19756 = (state_19779[(7)]);
var inst_19763 = cljs.core._EQ_.call(null,inst_19759,inst_19756);
var state_19779__$1 = state_19779;
if(inst_19763){
var statearr_19792_19815 = state_19779__$1;
(statearr_19792_19815[(1)] = (8));

} else {
var statearr_19793_19816 = state_19779__$1;
(statearr_19793_19816[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (10))){
var inst_19771 = (state_19779[(2)]);
var state_19779__$1 = state_19779;
var statearr_19794_19817 = state_19779__$1;
(statearr_19794_19817[(2)] = inst_19771);

(statearr_19794_19817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19780 === (8))){
var inst_19756 = (state_19779[(7)]);
var tmp19791 = inst_19756;
var inst_19756__$1 = tmp19791;
var state_19779__$1 = (function (){var statearr_19795 = state_19779;
(statearr_19795[(7)] = inst_19756__$1);

return statearr_19795;
})();
var statearr_19796_19818 = state_19779__$1;
(statearr_19796_19818[(2)] = null);

(statearr_19796_19818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19808,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19808,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19800 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19800[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19800[(1)] = (1));

return statearr_19800;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19779){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19779);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19801){if((e19801 instanceof Object)){
var ex__8254__auto__ = e19801;
var statearr_19802_19819 = state_19779;
(statearr_19802_19819[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19779);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19801;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19820 = state_19779;
state_19779 = G__19820;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19779){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19808,out))
})();
var state__8364__auto__ = (function (){var statearr_19803 = f__8363__auto__.call(null);
(statearr_19803[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19808);

return statearr_19803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19808,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19821 = [];
var len__5726__auto___19891 = arguments.length;
var i__5727__auto___19892 = (0);
while(true){
if((i__5727__auto___19892 < len__5726__auto___19891)){
args19821.push((arguments[i__5727__auto___19892]));

var G__19893 = (i__5727__auto___19892 + (1));
i__5727__auto___19892 = G__19893;
continue;
} else {
}
break;
}

var G__19823 = args19821.length;
switch (G__19823) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19821.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19895 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19895,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19895,out){
return (function (state_19861){
var state_val_19862 = (state_19861[(1)]);
if((state_val_19862 === (7))){
var inst_19857 = (state_19861[(2)]);
var state_19861__$1 = state_19861;
var statearr_19863_19896 = state_19861__$1;
(statearr_19863_19896[(2)] = inst_19857);

(statearr_19863_19896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (1))){
var inst_19824 = (new Array(n));
var inst_19825 = inst_19824;
var inst_19826 = (0);
var state_19861__$1 = (function (){var statearr_19864 = state_19861;
(statearr_19864[(7)] = inst_19826);

(statearr_19864[(8)] = inst_19825);

return statearr_19864;
})();
var statearr_19865_19897 = state_19861__$1;
(statearr_19865_19897[(2)] = null);

(statearr_19865_19897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (4))){
var inst_19829 = (state_19861[(9)]);
var inst_19829__$1 = (state_19861[(2)]);
var inst_19830 = (inst_19829__$1 == null);
var inst_19831 = cljs.core.not.call(null,inst_19830);
var state_19861__$1 = (function (){var statearr_19866 = state_19861;
(statearr_19866[(9)] = inst_19829__$1);

return statearr_19866;
})();
if(inst_19831){
var statearr_19867_19898 = state_19861__$1;
(statearr_19867_19898[(1)] = (5));

} else {
var statearr_19868_19899 = state_19861__$1;
(statearr_19868_19899[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (15))){
var inst_19851 = (state_19861[(2)]);
var state_19861__$1 = state_19861;
var statearr_19869_19900 = state_19861__$1;
(statearr_19869_19900[(2)] = inst_19851);

(statearr_19869_19900[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (13))){
var state_19861__$1 = state_19861;
var statearr_19870_19901 = state_19861__$1;
(statearr_19870_19901[(2)] = null);

(statearr_19870_19901[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (6))){
var inst_19826 = (state_19861[(7)]);
var inst_19847 = (inst_19826 > (0));
var state_19861__$1 = state_19861;
if(cljs.core.truth_(inst_19847)){
var statearr_19871_19902 = state_19861__$1;
(statearr_19871_19902[(1)] = (12));

} else {
var statearr_19872_19903 = state_19861__$1;
(statearr_19872_19903[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (3))){
var inst_19859 = (state_19861[(2)]);
var state_19861__$1 = state_19861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19861__$1,inst_19859);
} else {
if((state_val_19862 === (12))){
var inst_19825 = (state_19861[(8)]);
var inst_19849 = cljs.core.vec.call(null,inst_19825);
var state_19861__$1 = state_19861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19861__$1,(15),out,inst_19849);
} else {
if((state_val_19862 === (2))){
var state_19861__$1 = state_19861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19861__$1,(4),ch);
} else {
if((state_val_19862 === (11))){
var inst_19841 = (state_19861[(2)]);
var inst_19842 = (new Array(n));
var inst_19825 = inst_19842;
var inst_19826 = (0);
var state_19861__$1 = (function (){var statearr_19873 = state_19861;
(statearr_19873[(7)] = inst_19826);

(statearr_19873[(8)] = inst_19825);

(statearr_19873[(10)] = inst_19841);

return statearr_19873;
})();
var statearr_19874_19904 = state_19861__$1;
(statearr_19874_19904[(2)] = null);

(statearr_19874_19904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (9))){
var inst_19825 = (state_19861[(8)]);
var inst_19839 = cljs.core.vec.call(null,inst_19825);
var state_19861__$1 = state_19861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19861__$1,(11),out,inst_19839);
} else {
if((state_val_19862 === (5))){
var inst_19826 = (state_19861[(7)]);
var inst_19825 = (state_19861[(8)]);
var inst_19834 = (state_19861[(11)]);
var inst_19829 = (state_19861[(9)]);
var inst_19833 = (inst_19825[inst_19826] = inst_19829);
var inst_19834__$1 = (inst_19826 + (1));
var inst_19835 = (inst_19834__$1 < n);
var state_19861__$1 = (function (){var statearr_19875 = state_19861;
(statearr_19875[(11)] = inst_19834__$1);

(statearr_19875[(12)] = inst_19833);

return statearr_19875;
})();
if(cljs.core.truth_(inst_19835)){
var statearr_19876_19905 = state_19861__$1;
(statearr_19876_19905[(1)] = (8));

} else {
var statearr_19877_19906 = state_19861__$1;
(statearr_19877_19906[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (14))){
var inst_19854 = (state_19861[(2)]);
var inst_19855 = cljs.core.async.close_BANG_.call(null,out);
var state_19861__$1 = (function (){var statearr_19879 = state_19861;
(statearr_19879[(13)] = inst_19854);

return statearr_19879;
})();
var statearr_19880_19907 = state_19861__$1;
(statearr_19880_19907[(2)] = inst_19855);

(statearr_19880_19907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (10))){
var inst_19845 = (state_19861[(2)]);
var state_19861__$1 = state_19861;
var statearr_19881_19908 = state_19861__$1;
(statearr_19881_19908[(2)] = inst_19845);

(statearr_19881_19908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19862 === (8))){
var inst_19825 = (state_19861[(8)]);
var inst_19834 = (state_19861[(11)]);
var tmp19878 = inst_19825;
var inst_19825__$1 = tmp19878;
var inst_19826 = inst_19834;
var state_19861__$1 = (function (){var statearr_19882 = state_19861;
(statearr_19882[(7)] = inst_19826);

(statearr_19882[(8)] = inst_19825__$1);

return statearr_19882;
})();
var statearr_19883_19909 = state_19861__$1;
(statearr_19883_19909[(2)] = null);

(statearr_19883_19909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19895,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19895,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19887[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19887[(1)] = (1));

return statearr_19887;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19861){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19888){if((e19888 instanceof Object)){
var ex__8254__auto__ = e19888;
var statearr_19889_19910 = state_19861;
(statearr_19889_19910[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19861);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19888;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19911 = state_19861;
state_19861 = G__19911;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19895,out))
})();
var state__8364__auto__ = (function (){var statearr_19890 = f__8363__auto__.call(null);
(statearr_19890[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19895);

return statearr_19890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19895,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19912 = [];
var len__5726__auto___19986 = arguments.length;
var i__5727__auto___19987 = (0);
while(true){
if((i__5727__auto___19987 < len__5726__auto___19986)){
args19912.push((arguments[i__5727__auto___19987]));

var G__19988 = (i__5727__auto___19987 + (1));
i__5727__auto___19987 = G__19988;
continue;
} else {
}
break;
}

var G__19914 = args19912.length;
switch (G__19914) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19912.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19990 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19990,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19990,out){
return (function (state_19956){
var state_val_19957 = (state_19956[(1)]);
if((state_val_19957 === (7))){
var inst_19952 = (state_19956[(2)]);
var state_19956__$1 = state_19956;
var statearr_19958_19991 = state_19956__$1;
(statearr_19958_19991[(2)] = inst_19952);

(statearr_19958_19991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (1))){
var inst_19915 = [];
var inst_19916 = inst_19915;
var inst_19917 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19956__$1 = (function (){var statearr_19959 = state_19956;
(statearr_19959[(7)] = inst_19916);

(statearr_19959[(8)] = inst_19917);

return statearr_19959;
})();
var statearr_19960_19992 = state_19956__$1;
(statearr_19960_19992[(2)] = null);

(statearr_19960_19992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (4))){
var inst_19920 = (state_19956[(9)]);
var inst_19920__$1 = (state_19956[(2)]);
var inst_19921 = (inst_19920__$1 == null);
var inst_19922 = cljs.core.not.call(null,inst_19921);
var state_19956__$1 = (function (){var statearr_19961 = state_19956;
(statearr_19961[(9)] = inst_19920__$1);

return statearr_19961;
})();
if(inst_19922){
var statearr_19962_19993 = state_19956__$1;
(statearr_19962_19993[(1)] = (5));

} else {
var statearr_19963_19994 = state_19956__$1;
(statearr_19963_19994[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (15))){
var inst_19946 = (state_19956[(2)]);
var state_19956__$1 = state_19956;
var statearr_19964_19995 = state_19956__$1;
(statearr_19964_19995[(2)] = inst_19946);

(statearr_19964_19995[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (13))){
var state_19956__$1 = state_19956;
var statearr_19965_19996 = state_19956__$1;
(statearr_19965_19996[(2)] = null);

(statearr_19965_19996[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (6))){
var inst_19916 = (state_19956[(7)]);
var inst_19941 = inst_19916.length;
var inst_19942 = (inst_19941 > (0));
var state_19956__$1 = state_19956;
if(cljs.core.truth_(inst_19942)){
var statearr_19966_19997 = state_19956__$1;
(statearr_19966_19997[(1)] = (12));

} else {
var statearr_19967_19998 = state_19956__$1;
(statearr_19967_19998[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (3))){
var inst_19954 = (state_19956[(2)]);
var state_19956__$1 = state_19956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19956__$1,inst_19954);
} else {
if((state_val_19957 === (12))){
var inst_19916 = (state_19956[(7)]);
var inst_19944 = cljs.core.vec.call(null,inst_19916);
var state_19956__$1 = state_19956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19956__$1,(15),out,inst_19944);
} else {
if((state_val_19957 === (2))){
var state_19956__$1 = state_19956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19956__$1,(4),ch);
} else {
if((state_val_19957 === (11))){
var inst_19924 = (state_19956[(10)]);
var inst_19920 = (state_19956[(9)]);
var inst_19934 = (state_19956[(2)]);
var inst_19935 = [];
var inst_19936 = inst_19935.push(inst_19920);
var inst_19916 = inst_19935;
var inst_19917 = inst_19924;
var state_19956__$1 = (function (){var statearr_19968 = state_19956;
(statearr_19968[(11)] = inst_19936);

(statearr_19968[(7)] = inst_19916);

(statearr_19968[(12)] = inst_19934);

(statearr_19968[(8)] = inst_19917);

return statearr_19968;
})();
var statearr_19969_19999 = state_19956__$1;
(statearr_19969_19999[(2)] = null);

(statearr_19969_19999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (9))){
var inst_19916 = (state_19956[(7)]);
var inst_19932 = cljs.core.vec.call(null,inst_19916);
var state_19956__$1 = state_19956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19956__$1,(11),out,inst_19932);
} else {
if((state_val_19957 === (5))){
var inst_19924 = (state_19956[(10)]);
var inst_19917 = (state_19956[(8)]);
var inst_19920 = (state_19956[(9)]);
var inst_19924__$1 = f.call(null,inst_19920);
var inst_19925 = cljs.core._EQ_.call(null,inst_19924__$1,inst_19917);
var inst_19926 = cljs.core.keyword_identical_QMARK_.call(null,inst_19917,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19927 = (inst_19925) || (inst_19926);
var state_19956__$1 = (function (){var statearr_19970 = state_19956;
(statearr_19970[(10)] = inst_19924__$1);

return statearr_19970;
})();
if(cljs.core.truth_(inst_19927)){
var statearr_19971_20000 = state_19956__$1;
(statearr_19971_20000[(1)] = (8));

} else {
var statearr_19972_20001 = state_19956__$1;
(statearr_19972_20001[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (14))){
var inst_19949 = (state_19956[(2)]);
var inst_19950 = cljs.core.async.close_BANG_.call(null,out);
var state_19956__$1 = (function (){var statearr_19974 = state_19956;
(statearr_19974[(13)] = inst_19949);

return statearr_19974;
})();
var statearr_19975_20002 = state_19956__$1;
(statearr_19975_20002[(2)] = inst_19950);

(statearr_19975_20002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (10))){
var inst_19939 = (state_19956[(2)]);
var state_19956__$1 = state_19956;
var statearr_19976_20003 = state_19956__$1;
(statearr_19976_20003[(2)] = inst_19939);

(statearr_19976_20003[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19957 === (8))){
var inst_19924 = (state_19956[(10)]);
var inst_19916 = (state_19956[(7)]);
var inst_19920 = (state_19956[(9)]);
var inst_19929 = inst_19916.push(inst_19920);
var tmp19973 = inst_19916;
var inst_19916__$1 = tmp19973;
var inst_19917 = inst_19924;
var state_19956__$1 = (function (){var statearr_19977 = state_19956;
(statearr_19977[(7)] = inst_19916__$1);

(statearr_19977[(14)] = inst_19929);

(statearr_19977[(8)] = inst_19917);

return statearr_19977;
})();
var statearr_19978_20004 = state_19956__$1;
(statearr_19978_20004[(2)] = null);

(statearr_19978_20004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19990,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19990,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19982 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19982[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19982[(1)] = (1));

return statearr_19982;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19956){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19983){if((e19983 instanceof Object)){
var ex__8254__auto__ = e19983;
var statearr_19984_20005 = state_19956;
(statearr_19984_20005[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20006 = state_19956;
state_19956 = G__20006;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19990,out))
})();
var state__8364__auto__ = (function (){var statearr_19985 = f__8363__auto__.call(null);
(statearr_19985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19990);

return statearr_19985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19990,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1453379981792