// Compiled by ClojureScript 1.7.170 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__20099__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__20098 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__20098,(0),null);
var body = cljs.core.nthnext.call(null,vec__20098,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__20099 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__20100__i = 0, G__20100__a = new Array(arguments.length -  0);
while (G__20100__i < G__20100__a.length) {G__20100__a[G__20100__i] = arguments[G__20100__i + 0]; ++G__20100__i;}
  args = new cljs.core.IndexedSeq(G__20100__a,0);
} 
return G__20099__delegate.call(this,args);};
G__20099.cljs$lang$maxFixedArity = 0;
G__20099.cljs$lang$applyTo = (function (arglist__20101){
var args = cljs.core.seq(arglist__20101);
return G__20099__delegate(args);
});
G__20099.cljs$core$IFn$_invoke$arity$variadic = G__20099__delegate;
return G__20099;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5440__auto__ = (function sablono$core$update_arglists_$_iter__20106(s__20107){
return (new cljs.core.LazySeq(null,(function (){
var s__20107__$1 = s__20107;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20107__$1);
if(temp__4425__auto__){
var s__20107__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20107__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20107__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20109 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20108 = (0);
while(true){
if((i__20108 < size__5439__auto__)){
var args = cljs.core._nth.call(null,c__5438__auto__,i__20108);
cljs.core.chunk_append.call(null,b__20109,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__20110 = (i__20108 + (1));
i__20108 = G__20110;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20109),sablono$core$update_arglists_$_iter__20106.call(null,cljs.core.chunk_rest.call(null,s__20107__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20109),null);
}
} else {
var args = cljs.core.first.call(null,s__20107__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__20106.call(null,cljs.core.rest.call(null,s__20107__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20116 = arguments.length;
var i__5727__auto___20117 = (0);
while(true){
if((i__5727__auto___20117 < len__5726__auto___20116)){
args__5733__auto__.push((arguments[i__5727__auto___20117]));

var G__20118 = (i__5727__auto___20117 + (1));
i__5727__auto___20117 = G__20118;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((0) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5734__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5440__auto__ = (function sablono$core$iter__20112(s__20113){
return (new cljs.core.LazySeq(null,(function (){
var s__20113__$1 = s__20113;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20113__$1);
if(temp__4425__auto__){
var s__20113__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20113__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20113__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20115 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20114 = (0);
while(true){
if((i__20114 < size__5439__auto__)){
var style = cljs.core._nth.call(null,c__5438__auto__,i__20114);
cljs.core.chunk_append.call(null,b__20115,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__20119 = (i__20114 + (1));
i__20114 = G__20119;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20115),sablono$core$iter__20112.call(null,cljs.core.chunk_rest.call(null,s__20113__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20115),null);
}
} else {
var style = cljs.core.first.call(null,s__20113__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__20112.call(null,cljs.core.rest.call(null,s__20113__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq20111){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20111));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to20120 = (function sablono$core$link_to20120(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20123 = arguments.length;
var i__5727__auto___20124 = (0);
while(true){
if((i__5727__auto___20124 < len__5726__auto___20123)){
args__5733__auto__.push((arguments[i__5727__auto___20124]));

var G__20125 = (i__5727__auto___20124 + (1));
i__5727__auto___20124 = G__20125;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.link_to20120.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.link_to20120.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to20120.cljs$lang$maxFixedArity = (1);

sablono.core.link_to20120.cljs$lang$applyTo = (function (seq20121){
var G__20122 = cljs.core.first.call(null,seq20121);
var seq20121__$1 = cljs.core.next.call(null,seq20121);
return sablono.core.link_to20120.cljs$core$IFn$_invoke$arity$variadic(G__20122,seq20121__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to20120);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to20126 = (function sablono$core$mail_to20126(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20131 = arguments.length;
var i__5727__auto___20132 = (0);
while(true){
if((i__5727__auto___20132 < len__5726__auto___20131)){
args__5733__auto__.push((arguments[i__5727__auto___20132]));

var G__20133 = (i__5727__auto___20132 + (1));
i__5727__auto___20132 = G__20133;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.mail_to20126.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.mail_to20126.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__20129){
var vec__20130 = p__20129;
var content = cljs.core.nth.call(null,vec__20130,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4668__auto__ = content;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to20126.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to20126.cljs$lang$applyTo = (function (seq20127){
var G__20128 = cljs.core.first.call(null,seq20127);
var seq20127__$1 = cljs.core.next.call(null,seq20127);
return sablono.core.mail_to20126.cljs$core$IFn$_invoke$arity$variadic(G__20128,seq20127__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to20126);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list20134 = (function sablono$core$unordered_list20134(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5440__auto__ = (function sablono$core$unordered_list20134_$_iter__20139(s__20140){
return (new cljs.core.LazySeq(null,(function (){
var s__20140__$1 = s__20140;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20140__$1);
if(temp__4425__auto__){
var s__20140__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20140__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20140__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20142 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20141 = (0);
while(true){
if((i__20141 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20141);
cljs.core.chunk_append.call(null,b__20142,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20143 = (i__20141 + (1));
i__20141 = G__20143;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20142),sablono$core$unordered_list20134_$_iter__20139.call(null,cljs.core.chunk_rest.call(null,s__20140__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20142),null);
}
} else {
var x = cljs.core.first.call(null,s__20140__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list20134_$_iter__20139.call(null,cljs.core.rest.call(null,s__20140__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list20134);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list20144 = (function sablono$core$ordered_list20144(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5440__auto__ = (function sablono$core$ordered_list20144_$_iter__20149(s__20150){
return (new cljs.core.LazySeq(null,(function (){
var s__20150__$1 = s__20150;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20150__$1);
if(temp__4425__auto__){
var s__20150__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20150__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20150__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20152 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20151 = (0);
while(true){
if((i__20151 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20151);
cljs.core.chunk_append.call(null,b__20152,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__20153 = (i__20151 + (1));
i__20151 = G__20153;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20152),sablono$core$ordered_list20144_$_iter__20149.call(null,cljs.core.chunk_rest.call(null,s__20150__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20152),null);
}
} else {
var x = cljs.core.first.call(null,s__20150__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list20144_$_iter__20149.call(null,cljs.core.rest.call(null,s__20150__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list20144);
/**
 * Create an image element.
 */
sablono.core.image20154 = (function sablono$core$image20154(var_args){
var args20155 = [];
var len__5726__auto___20158 = arguments.length;
var i__5727__auto___20159 = (0);
while(true){
if((i__5727__auto___20159 < len__5726__auto___20158)){
args20155.push((arguments[i__5727__auto___20159]));

var G__20160 = (i__5727__auto___20159 + (1));
i__5727__auto___20159 = G__20160;
continue;
} else {
}
break;
}

var G__20157 = args20155.length;
switch (G__20157) {
case 1:
return sablono.core.image20154.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image20154.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20155.length)].join('')));

}
});

sablono.core.image20154.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image20154.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image20154.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image20154);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__20162_SHARP_,p2__20163_SHARP_){
return [cljs.core.str(p1__20162_SHARP_),cljs.core.str("["),cljs.core.str(p2__20163_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__20164_SHARP_,p2__20165_SHARP_){
return [cljs.core.str(p1__20164_SHARP_),cljs.core.str("-"),cljs.core.str(p2__20165_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field20166 = (function sablono$core$color_field20166(var_args){
var args20167 = [];
var len__5726__auto___20234 = arguments.length;
var i__5727__auto___20235 = (0);
while(true){
if((i__5727__auto___20235 < len__5726__auto___20234)){
args20167.push((arguments[i__5727__auto___20235]));

var G__20236 = (i__5727__auto___20235 + (1));
i__5727__auto___20235 = G__20236;
continue;
} else {
}
break;
}

var G__20169 = args20167.length;
switch (G__20169) {
case 1:
return sablono.core.color_field20166.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field20166.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20167.length)].join('')));

}
});

sablono.core.color_field20166.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.color_field20166.call(null,name__11649__auto__,null);
});

sablono.core.color_field20166.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.color_field20166.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field20166);

/**
 * Creates a date input field.
 */
sablono.core.date_field20170 = (function sablono$core$date_field20170(var_args){
var args20171 = [];
var len__5726__auto___20238 = arguments.length;
var i__5727__auto___20239 = (0);
while(true){
if((i__5727__auto___20239 < len__5726__auto___20238)){
args20171.push((arguments[i__5727__auto___20239]));

var G__20240 = (i__5727__auto___20239 + (1));
i__5727__auto___20239 = G__20240;
continue;
} else {
}
break;
}

var G__20173 = args20171.length;
switch (G__20173) {
case 1:
return sablono.core.date_field20170.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field20170.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20171.length)].join('')));

}
});

sablono.core.date_field20170.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.date_field20170.call(null,name__11649__auto__,null);
});

sablono.core.date_field20170.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.date_field20170.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field20170);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field20174 = (function sablono$core$datetime_field20174(var_args){
var args20175 = [];
var len__5726__auto___20242 = arguments.length;
var i__5727__auto___20243 = (0);
while(true){
if((i__5727__auto___20243 < len__5726__auto___20242)){
args20175.push((arguments[i__5727__auto___20243]));

var G__20244 = (i__5727__auto___20243 + (1));
i__5727__auto___20243 = G__20244;
continue;
} else {
}
break;
}

var G__20177 = args20175.length;
switch (G__20177) {
case 1:
return sablono.core.datetime_field20174.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field20174.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20175.length)].join('')));

}
});

sablono.core.datetime_field20174.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_field20174.call(null,name__11649__auto__,null);
});

sablono.core.datetime_field20174.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_field20174.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field20174);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field20178 = (function sablono$core$datetime_local_field20178(var_args){
var args20179 = [];
var len__5726__auto___20246 = arguments.length;
var i__5727__auto___20247 = (0);
while(true){
if((i__5727__auto___20247 < len__5726__auto___20246)){
args20179.push((arguments[i__5727__auto___20247]));

var G__20248 = (i__5727__auto___20247 + (1));
i__5727__auto___20247 = G__20248;
continue;
} else {
}
break;
}

var G__20181 = args20179.length;
switch (G__20181) {
case 1:
return sablono.core.datetime_local_field20178.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field20178.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20179.length)].join('')));

}
});

sablono.core.datetime_local_field20178.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.datetime_local_field20178.call(null,name__11649__auto__,null);
});

sablono.core.datetime_local_field20178.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.datetime_local_field20178.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field20178);

/**
 * Creates a email input field.
 */
sablono.core.email_field20182 = (function sablono$core$email_field20182(var_args){
var args20183 = [];
var len__5726__auto___20250 = arguments.length;
var i__5727__auto___20251 = (0);
while(true){
if((i__5727__auto___20251 < len__5726__auto___20250)){
args20183.push((arguments[i__5727__auto___20251]));

var G__20252 = (i__5727__auto___20251 + (1));
i__5727__auto___20251 = G__20252;
continue;
} else {
}
break;
}

var G__20185 = args20183.length;
switch (G__20185) {
case 1:
return sablono.core.email_field20182.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field20182.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20183.length)].join('')));

}
});

sablono.core.email_field20182.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.email_field20182.call(null,name__11649__auto__,null);
});

sablono.core.email_field20182.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.email_field20182.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field20182);

/**
 * Creates a file input field.
 */
sablono.core.file_field20186 = (function sablono$core$file_field20186(var_args){
var args20187 = [];
var len__5726__auto___20254 = arguments.length;
var i__5727__auto___20255 = (0);
while(true){
if((i__5727__auto___20255 < len__5726__auto___20254)){
args20187.push((arguments[i__5727__auto___20255]));

var G__20256 = (i__5727__auto___20255 + (1));
i__5727__auto___20255 = G__20256;
continue;
} else {
}
break;
}

var G__20189 = args20187.length;
switch (G__20189) {
case 1:
return sablono.core.file_field20186.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field20186.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20187.length)].join('')));

}
});

sablono.core.file_field20186.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.file_field20186.call(null,name__11649__auto__,null);
});

sablono.core.file_field20186.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.file_field20186.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field20186);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field20190 = (function sablono$core$hidden_field20190(var_args){
var args20191 = [];
var len__5726__auto___20258 = arguments.length;
var i__5727__auto___20259 = (0);
while(true){
if((i__5727__auto___20259 < len__5726__auto___20258)){
args20191.push((arguments[i__5727__auto___20259]));

var G__20260 = (i__5727__auto___20259 + (1));
i__5727__auto___20259 = G__20260;
continue;
} else {
}
break;
}

var G__20193 = args20191.length;
switch (G__20193) {
case 1:
return sablono.core.hidden_field20190.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field20190.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20191.length)].join('')));

}
});

sablono.core.hidden_field20190.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.hidden_field20190.call(null,name__11649__auto__,null);
});

sablono.core.hidden_field20190.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.hidden_field20190.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field20190);

/**
 * Creates a month input field.
 */
sablono.core.month_field20194 = (function sablono$core$month_field20194(var_args){
var args20195 = [];
var len__5726__auto___20262 = arguments.length;
var i__5727__auto___20263 = (0);
while(true){
if((i__5727__auto___20263 < len__5726__auto___20262)){
args20195.push((arguments[i__5727__auto___20263]));

var G__20264 = (i__5727__auto___20263 + (1));
i__5727__auto___20263 = G__20264;
continue;
} else {
}
break;
}

var G__20197 = args20195.length;
switch (G__20197) {
case 1:
return sablono.core.month_field20194.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field20194.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20195.length)].join('')));

}
});

sablono.core.month_field20194.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.month_field20194.call(null,name__11649__auto__,null);
});

sablono.core.month_field20194.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.month_field20194.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field20194);

/**
 * Creates a number input field.
 */
sablono.core.number_field20198 = (function sablono$core$number_field20198(var_args){
var args20199 = [];
var len__5726__auto___20266 = arguments.length;
var i__5727__auto___20267 = (0);
while(true){
if((i__5727__auto___20267 < len__5726__auto___20266)){
args20199.push((arguments[i__5727__auto___20267]));

var G__20268 = (i__5727__auto___20267 + (1));
i__5727__auto___20267 = G__20268;
continue;
} else {
}
break;
}

var G__20201 = args20199.length;
switch (G__20201) {
case 1:
return sablono.core.number_field20198.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field20198.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20199.length)].join('')));

}
});

sablono.core.number_field20198.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.number_field20198.call(null,name__11649__auto__,null);
});

sablono.core.number_field20198.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.number_field20198.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field20198);

/**
 * Creates a password input field.
 */
sablono.core.password_field20202 = (function sablono$core$password_field20202(var_args){
var args20203 = [];
var len__5726__auto___20270 = arguments.length;
var i__5727__auto___20271 = (0);
while(true){
if((i__5727__auto___20271 < len__5726__auto___20270)){
args20203.push((arguments[i__5727__auto___20271]));

var G__20272 = (i__5727__auto___20271 + (1));
i__5727__auto___20271 = G__20272;
continue;
} else {
}
break;
}

var G__20205 = args20203.length;
switch (G__20205) {
case 1:
return sablono.core.password_field20202.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field20202.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20203.length)].join('')));

}
});

sablono.core.password_field20202.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.password_field20202.call(null,name__11649__auto__,null);
});

sablono.core.password_field20202.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.password_field20202.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field20202);

/**
 * Creates a range input field.
 */
sablono.core.range_field20206 = (function sablono$core$range_field20206(var_args){
var args20207 = [];
var len__5726__auto___20274 = arguments.length;
var i__5727__auto___20275 = (0);
while(true){
if((i__5727__auto___20275 < len__5726__auto___20274)){
args20207.push((arguments[i__5727__auto___20275]));

var G__20276 = (i__5727__auto___20275 + (1));
i__5727__auto___20275 = G__20276;
continue;
} else {
}
break;
}

var G__20209 = args20207.length;
switch (G__20209) {
case 1:
return sablono.core.range_field20206.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field20206.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20207.length)].join('')));

}
});

sablono.core.range_field20206.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.range_field20206.call(null,name__11649__auto__,null);
});

sablono.core.range_field20206.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.range_field20206.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field20206);

/**
 * Creates a search input field.
 */
sablono.core.search_field20210 = (function sablono$core$search_field20210(var_args){
var args20211 = [];
var len__5726__auto___20278 = arguments.length;
var i__5727__auto___20279 = (0);
while(true){
if((i__5727__auto___20279 < len__5726__auto___20278)){
args20211.push((arguments[i__5727__auto___20279]));

var G__20280 = (i__5727__auto___20279 + (1));
i__5727__auto___20279 = G__20280;
continue;
} else {
}
break;
}

var G__20213 = args20211.length;
switch (G__20213) {
case 1:
return sablono.core.search_field20210.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field20210.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20211.length)].join('')));

}
});

sablono.core.search_field20210.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.search_field20210.call(null,name__11649__auto__,null);
});

sablono.core.search_field20210.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.search_field20210.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field20210);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field20214 = (function sablono$core$tel_field20214(var_args){
var args20215 = [];
var len__5726__auto___20282 = arguments.length;
var i__5727__auto___20283 = (0);
while(true){
if((i__5727__auto___20283 < len__5726__auto___20282)){
args20215.push((arguments[i__5727__auto___20283]));

var G__20284 = (i__5727__auto___20283 + (1));
i__5727__auto___20283 = G__20284;
continue;
} else {
}
break;
}

var G__20217 = args20215.length;
switch (G__20217) {
case 1:
return sablono.core.tel_field20214.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field20214.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20215.length)].join('')));

}
});

sablono.core.tel_field20214.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.tel_field20214.call(null,name__11649__auto__,null);
});

sablono.core.tel_field20214.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.tel_field20214.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field20214);

/**
 * Creates a text input field.
 */
sablono.core.text_field20218 = (function sablono$core$text_field20218(var_args){
var args20219 = [];
var len__5726__auto___20286 = arguments.length;
var i__5727__auto___20287 = (0);
while(true){
if((i__5727__auto___20287 < len__5726__auto___20286)){
args20219.push((arguments[i__5727__auto___20287]));

var G__20288 = (i__5727__auto___20287 + (1));
i__5727__auto___20287 = G__20288;
continue;
} else {
}
break;
}

var G__20221 = args20219.length;
switch (G__20221) {
case 1:
return sablono.core.text_field20218.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field20218.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20219.length)].join('')));

}
});

sablono.core.text_field20218.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.text_field20218.call(null,name__11649__auto__,null);
});

sablono.core.text_field20218.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.text_field20218.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field20218);

/**
 * Creates a time input field.
 */
sablono.core.time_field20222 = (function sablono$core$time_field20222(var_args){
var args20223 = [];
var len__5726__auto___20290 = arguments.length;
var i__5727__auto___20291 = (0);
while(true){
if((i__5727__auto___20291 < len__5726__auto___20290)){
args20223.push((arguments[i__5727__auto___20291]));

var G__20292 = (i__5727__auto___20291 + (1));
i__5727__auto___20291 = G__20292;
continue;
} else {
}
break;
}

var G__20225 = args20223.length;
switch (G__20225) {
case 1:
return sablono.core.time_field20222.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field20222.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20223.length)].join('')));

}
});

sablono.core.time_field20222.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.time_field20222.call(null,name__11649__auto__,null);
});

sablono.core.time_field20222.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.time_field20222.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field20222);

/**
 * Creates a url input field.
 */
sablono.core.url_field20226 = (function sablono$core$url_field20226(var_args){
var args20227 = [];
var len__5726__auto___20294 = arguments.length;
var i__5727__auto___20295 = (0);
while(true){
if((i__5727__auto___20295 < len__5726__auto___20294)){
args20227.push((arguments[i__5727__auto___20295]));

var G__20296 = (i__5727__auto___20295 + (1));
i__5727__auto___20295 = G__20296;
continue;
} else {
}
break;
}

var G__20229 = args20227.length;
switch (G__20229) {
case 1:
return sablono.core.url_field20226.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field20226.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20227.length)].join('')));

}
});

sablono.core.url_field20226.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.url_field20226.call(null,name__11649__auto__,null);
});

sablono.core.url_field20226.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.url_field20226.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field20226);

/**
 * Creates a week input field.
 */
sablono.core.week_field20230 = (function sablono$core$week_field20230(var_args){
var args20231 = [];
var len__5726__auto___20298 = arguments.length;
var i__5727__auto___20299 = (0);
while(true){
if((i__5727__auto___20299 < len__5726__auto___20298)){
args20231.push((arguments[i__5727__auto___20299]));

var G__20300 = (i__5727__auto___20299 + (1));
i__5727__auto___20299 = G__20300;
continue;
} else {
}
break;
}

var G__20233 = args20231.length;
switch (G__20233) {
case 1:
return sablono.core.week_field20230.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field20230.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20231.length)].join('')));

}
});

sablono.core.week_field20230.cljs$core$IFn$_invoke$arity$1 = (function (name__11649__auto__){
return sablono.core.week_field20230.call(null,name__11649__auto__,null);
});

sablono.core.week_field20230.cljs$core$IFn$_invoke$arity$2 = (function (name__11649__auto__,value__11650__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11649__auto__,value__11650__auto__);
});

sablono.core.week_field20230.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field20230);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box20302 = (function sablono$core$check_box20302(var_args){
var args20303 = [];
var len__5726__auto___20306 = arguments.length;
var i__5727__auto___20307 = (0);
while(true){
if((i__5727__auto___20307 < len__5726__auto___20306)){
args20303.push((arguments[i__5727__auto___20307]));

var G__20308 = (i__5727__auto___20307 + (1));
i__5727__auto___20307 = G__20308;
continue;
} else {
}
break;
}

var G__20305 = args20303.length;
switch (G__20305) {
case 1:
return sablono.core.check_box20302.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box20302.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box20302.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20303.length)].join('')));

}
});

sablono.core.check_box20302.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box20302.call(null,name,null);
});

sablono.core.check_box20302.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box20302.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box20302.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box20302.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box20302);
/**
 * Creates a radio button.
 */
sablono.core.radio_button20310 = (function sablono$core$radio_button20310(var_args){
var args20311 = [];
var len__5726__auto___20314 = arguments.length;
var i__5727__auto___20315 = (0);
while(true){
if((i__5727__auto___20315 < len__5726__auto___20314)){
args20311.push((arguments[i__5727__auto___20315]));

var G__20316 = (i__5727__auto___20315 + (1));
i__5727__auto___20315 = G__20316;
continue;
} else {
}
break;
}

var G__20313 = args20311.length;
switch (G__20313) {
case 1:
return sablono.core.radio_button20310.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button20310.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button20310.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20311.length)].join('')));

}
});

sablono.core.radio_button20310.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button20310.call(null,group,null);
});

sablono.core.radio_button20310.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button20310.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button20310.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button20310.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button20310);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options20318 = (function sablono$core$select_options20318(coll){
var iter__5440__auto__ = (function sablono$core$select_options20318_$_iter__20327(s__20328){
return (new cljs.core.LazySeq(null,(function (){
var s__20328__$1 = s__20328;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20328__$1);
if(temp__4425__auto__){
var s__20328__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20328__$2)){
var c__5438__auto__ = cljs.core.chunk_first.call(null,s__20328__$2);
var size__5439__auto__ = cljs.core.count.call(null,c__5438__auto__);
var b__20330 = cljs.core.chunk_buffer.call(null,size__5439__auto__);
if((function (){var i__20329 = (0);
while(true){
if((i__20329 < size__5439__auto__)){
var x = cljs.core._nth.call(null,c__5438__auto__,i__20329);
cljs.core.chunk_append.call(null,b__20330,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20333 = x;
var text = cljs.core.nth.call(null,vec__20333,(0),null);
var val = cljs.core.nth.call(null,vec__20333,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20333,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20318.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__20335 = (i__20329 + (1));
i__20329 = G__20335;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20330),sablono$core$select_options20318_$_iter__20327.call(null,cljs.core.chunk_rest.call(null,s__20328__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20330),null);
}
} else {
var x = cljs.core.first.call(null,s__20328__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__20334 = x;
var text = cljs.core.nth.call(null,vec__20334,(0),null);
var val = cljs.core.nth.call(null,vec__20334,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__20334,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono$core$select_options20318.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options20318_$_iter__20327.call(null,cljs.core.rest.call(null,s__20328__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5440__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options20318);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down20336 = (function sablono$core$drop_down20336(var_args){
var args20337 = [];
var len__5726__auto___20340 = arguments.length;
var i__5727__auto___20341 = (0);
while(true){
if((i__5727__auto___20341 < len__5726__auto___20340)){
args20337.push((arguments[i__5727__auto___20341]));

var G__20342 = (i__5727__auto___20341 + (1));
i__5727__auto___20341 = G__20342;
continue;
} else {
}
break;
}

var G__20339 = args20337.length;
switch (G__20339) {
case 2:
return sablono.core.drop_down20336.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down20336.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20337.length)].join('')));

}
});

sablono.core.drop_down20336.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down20336.call(null,name,options,null);
});

sablono.core.drop_down20336.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down20336.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down20336);
/**
 * Creates a text area element.
 */
sablono.core.text_area20344 = (function sablono$core$text_area20344(var_args){
var args20345 = [];
var len__5726__auto___20348 = arguments.length;
var i__5727__auto___20349 = (0);
while(true){
if((i__5727__auto___20349 < len__5726__auto___20348)){
args20345.push((arguments[i__5727__auto___20349]));

var G__20350 = (i__5727__auto___20349 + (1));
i__5727__auto___20349 = G__20350;
continue;
} else {
}
break;
}

var G__20347 = args20345.length;
switch (G__20347) {
case 1:
return sablono.core.text_area20344.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area20344.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20345.length)].join('')));

}
});

sablono.core.text_area20344.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area20344.call(null,name,null);
});

sablono.core.text_area20344.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area20344.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area20344);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label20352 = (function sablono$core$label20352(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label20352);
/**
 * Creates a submit button.
 */
sablono.core.submit_button20353 = (function sablono$core$submit_button20353(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button20353);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button20354 = (function sablono$core$reset_button20354(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button20354);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to20355 = (function sablono$core$form_to20355(var_args){
var args__5733__auto__ = [];
var len__5726__auto___20360 = arguments.length;
var i__5727__auto___20361 = (0);
while(true){
if((i__5727__auto___20361 < len__5726__auto___20360)){
args__5733__auto__.push((arguments[i__5727__auto___20361]));

var G__20362 = (i__5727__auto___20361 + (1));
i__5727__auto___20361 = G__20362;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return sablono.core.form_to20355.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

sablono.core.form_to20355.cljs$core$IFn$_invoke$arity$variadic = (function (p__20358,body){
var vec__20359 = p__20358;
var method = cljs.core.nth.call(null,vec__20359,(0),null);
var action = cljs.core.nth.call(null,vec__20359,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to20355.cljs$lang$maxFixedArity = (1);

sablono.core.form_to20355.cljs$lang$applyTo = (function (seq20356){
var G__20357 = cljs.core.first.call(null,seq20356);
var seq20356__$1 = cljs.core.next.call(null,seq20356);
return sablono.core.form_to20355.cljs$core$IFn$_invoke$arity$variadic(G__20357,seq20356__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to20355);

//# sourceMappingURL=core.js.map?rel=1453298545154