// Compiled by ClojureScript 1.7.170 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17273 = [];
var len__5726__auto___17279 = arguments.length;
var i__5727__auto___17280 = (0);
while(true){
if((i__5727__auto___17280 < len__5726__auto___17279)){
args17273.push((arguments[i__5727__auto___17280]));

var G__17281 = (i__5727__auto___17280 + (1));
i__5727__auto___17280 = G__17281;
continue;
} else {
}
break;
}

var G__17275 = args17273.length;
switch (G__17275) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17273.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17276 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17276 = (function (f,blockable,meta17277){
this.f = f;
this.blockable = blockable;
this.meta17277 = meta17277;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17276.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17278,meta17277__$1){
var self__ = this;
var _17278__$1 = this;
return (new cljs.core.async.t_cljs$core$async17276(self__.f,self__.blockable,meta17277__$1));
});

cljs.core.async.t_cljs$core$async17276.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17278){
var self__ = this;
var _17278__$1 = this;
return self__.meta17277;
});

cljs.core.async.t_cljs$core$async17276.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17276.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17276.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17276.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17276.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17277","meta17277",1444087501,null)], null);
});

cljs.core.async.t_cljs$core$async17276.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17276.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17276";

cljs.core.async.t_cljs$core$async17276.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17276");
});

cljs.core.async.__GT_t_cljs$core$async17276 = (function cljs$core$async$__GT_t_cljs$core$async17276(f__$1,blockable__$1,meta17277){
return (new cljs.core.async.t_cljs$core$async17276(f__$1,blockable__$1,meta17277));
});

}

return (new cljs.core.async.t_cljs$core$async17276(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17285 = [];
var len__5726__auto___17288 = arguments.length;
var i__5727__auto___17289 = (0);
while(true){
if((i__5727__auto___17289 < len__5726__auto___17288)){
args17285.push((arguments[i__5727__auto___17289]));

var G__17290 = (i__5727__auto___17289 + (1));
i__5727__auto___17289 = G__17290;
continue;
} else {
}
break;
}

var G__17287 = args17285.length;
switch (G__17287) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17285.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17292 = [];
var len__5726__auto___17295 = arguments.length;
var i__5727__auto___17296 = (0);
while(true){
if((i__5727__auto___17296 < len__5726__auto___17295)){
args17292.push((arguments[i__5727__auto___17296]));

var G__17297 = (i__5727__auto___17296 + (1));
i__5727__auto___17296 = G__17297;
continue;
} else {
}
break;
}

var G__17294 = args17292.length;
switch (G__17294) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17292.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17299 = [];
var len__5726__auto___17302 = arguments.length;
var i__5727__auto___17303 = (0);
while(true){
if((i__5727__auto___17303 < len__5726__auto___17302)){
args17299.push((arguments[i__5727__auto___17303]));

var G__17304 = (i__5727__auto___17303 + (1));
i__5727__auto___17303 = G__17304;
continue;
} else {
}
break;
}

var G__17301 = args17299.length;
switch (G__17301) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17299.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_17306 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_17306);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_17306,ret){
return (function (){
return fn1.call(null,val_17306);
});})(val_17306,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17307 = [];
var len__5726__auto___17310 = arguments.length;
var i__5727__auto___17311 = (0);
while(true){
if((i__5727__auto___17311 < len__5726__auto___17310)){
args17307.push((arguments[i__5727__auto___17311]));

var G__17312 = (i__5727__auto___17311 + (1));
i__5727__auto___17311 = G__17312;
continue;
} else {
}
break;
}

var G__17309 = args17307.length;
switch (G__17309) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17307.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5571__auto___17314 = n;
var x_17315 = (0);
while(true){
if((x_17315 < n__5571__auto___17314)){
(a[x_17315] = (0));

var G__17316 = (x_17315 + (1));
x_17315 = G__17316;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__17317 = (i + (1));
i = G__17317;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async17321 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17321 = (function (alt_flag,flag,meta17322){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta17322 = meta17322;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17321.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17323,meta17322__$1){
var self__ = this;
var _17323__$1 = this;
return (new cljs.core.async.t_cljs$core$async17321(self__.alt_flag,self__.flag,meta17322__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17321.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17323){
var self__ = this;
var _17323__$1 = this;
return self__.meta17322;
});})(flag))
;

cljs.core.async.t_cljs$core$async17321.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17321.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17321.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17321.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17321.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17322","meta17322",1611594704,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17321.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17321.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17321";

cljs.core.async.t_cljs$core$async17321.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17321");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async17321 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17321(alt_flag__$1,flag__$1,meta17322){
return (new cljs.core.async.t_cljs$core$async17321(alt_flag__$1,flag__$1,meta17322));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17321(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async17327 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17327 = (function (alt_handler,flag,cb,meta17328){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta17328 = meta17328;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17327.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17329,meta17328__$1){
var self__ = this;
var _17329__$1 = this;
return (new cljs.core.async.t_cljs$core$async17327(self__.alt_handler,self__.flag,self__.cb,meta17328__$1));
});

cljs.core.async.t_cljs$core$async17327.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17329){
var self__ = this;
var _17329__$1 = this;
return self__.meta17328;
});

cljs.core.async.t_cljs$core$async17327.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async17327.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async17327.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17327.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17327.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17328","meta17328",299503504,null)], null);
});

cljs.core.async.t_cljs$core$async17327.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17327.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17327";

cljs.core.async.t_cljs$core$async17327.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async17327");
});

cljs.core.async.__GT_t_cljs$core$async17327 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17327(alt_handler__$1,flag__$1,cb__$1,meta17328){
return (new cljs.core.async.t_cljs$core$async17327(alt_handler__$1,flag__$1,cb__$1,meta17328));
});

}

return (new cljs.core.async.t_cljs$core$async17327(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17330_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17330_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17331_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17331_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4668__auto__ = wport;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17332 = (i + (1));
i = G__17332;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4668__auto__ = ret;
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__4656__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4656__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4656__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___17338 = arguments.length;
var i__5727__auto___17339 = (0);
while(true){
if((i__5727__auto___17339 < len__5726__auto___17338)){
args__5733__auto__.push((arguments[i__5727__auto___17339]));

var G__17340 = (i__5727__auto___17339 + (1));
i__5727__auto___17339 = G__17340;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((1) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5734__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17335){
var map__17336 = p__17335;
var map__17336__$1 = ((((!((map__17336 == null)))?((((map__17336.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17336.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17336):map__17336);
var opts = map__17336__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17333){
var G__17334 = cljs.core.first.call(null,seq17333);
var seq17333__$1 = cljs.core.next.call(null,seq17333);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17334,seq17333__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args17341 = [];
var len__5726__auto___17391 = arguments.length;
var i__5727__auto___17392 = (0);
while(true){
if((i__5727__auto___17392 < len__5726__auto___17391)){
args17341.push((arguments[i__5727__auto___17392]));

var G__17393 = (i__5727__auto___17392 + (1));
i__5727__auto___17392 = G__17393;
continue;
} else {
}
break;
}

var G__17343 = args17341.length;
switch (G__17343) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17341.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8362__auto___17395 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17395){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17395){
return (function (state_17367){
var state_val_17368 = (state_17367[(1)]);
if((state_val_17368 === (7))){
var inst_17363 = (state_17367[(2)]);
var state_17367__$1 = state_17367;
var statearr_17369_17396 = state_17367__$1;
(statearr_17369_17396[(2)] = inst_17363);

(statearr_17369_17396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (1))){
var state_17367__$1 = state_17367;
var statearr_17370_17397 = state_17367__$1;
(statearr_17370_17397[(2)] = null);

(statearr_17370_17397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (4))){
var inst_17346 = (state_17367[(7)]);
var inst_17346__$1 = (state_17367[(2)]);
var inst_17347 = (inst_17346__$1 == null);
var state_17367__$1 = (function (){var statearr_17371 = state_17367;
(statearr_17371[(7)] = inst_17346__$1);

return statearr_17371;
})();
if(cljs.core.truth_(inst_17347)){
var statearr_17372_17398 = state_17367__$1;
(statearr_17372_17398[(1)] = (5));

} else {
var statearr_17373_17399 = state_17367__$1;
(statearr_17373_17399[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (13))){
var state_17367__$1 = state_17367;
var statearr_17374_17400 = state_17367__$1;
(statearr_17374_17400[(2)] = null);

(statearr_17374_17400[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (6))){
var inst_17346 = (state_17367[(7)]);
var state_17367__$1 = state_17367;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17367__$1,(11),to,inst_17346);
} else {
if((state_val_17368 === (3))){
var inst_17365 = (state_17367[(2)]);
var state_17367__$1 = state_17367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17367__$1,inst_17365);
} else {
if((state_val_17368 === (12))){
var state_17367__$1 = state_17367;
var statearr_17375_17401 = state_17367__$1;
(statearr_17375_17401[(2)] = null);

(statearr_17375_17401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (2))){
var state_17367__$1 = state_17367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17367__$1,(4),from);
} else {
if((state_val_17368 === (11))){
var inst_17356 = (state_17367[(2)]);
var state_17367__$1 = state_17367;
if(cljs.core.truth_(inst_17356)){
var statearr_17376_17402 = state_17367__$1;
(statearr_17376_17402[(1)] = (12));

} else {
var statearr_17377_17403 = state_17367__$1;
(statearr_17377_17403[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (9))){
var state_17367__$1 = state_17367;
var statearr_17378_17404 = state_17367__$1;
(statearr_17378_17404[(2)] = null);

(statearr_17378_17404[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (5))){
var state_17367__$1 = state_17367;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17379_17405 = state_17367__$1;
(statearr_17379_17405[(1)] = (8));

} else {
var statearr_17380_17406 = state_17367__$1;
(statearr_17380_17406[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (14))){
var inst_17361 = (state_17367[(2)]);
var state_17367__$1 = state_17367;
var statearr_17381_17407 = state_17367__$1;
(statearr_17381_17407[(2)] = inst_17361);

(statearr_17381_17407[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (10))){
var inst_17353 = (state_17367[(2)]);
var state_17367__$1 = state_17367;
var statearr_17382_17408 = state_17367__$1;
(statearr_17382_17408[(2)] = inst_17353);

(statearr_17382_17408[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (8))){
var inst_17350 = cljs.core.async.close_BANG_.call(null,to);
var state_17367__$1 = state_17367;
var statearr_17383_17409 = state_17367__$1;
(statearr_17383_17409[(2)] = inst_17350);

(statearr_17383_17409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17395))
;
return ((function (switch__8250__auto__,c__8362__auto___17395){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17387 = [null,null,null,null,null,null,null,null];
(statearr_17387[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17387[(1)] = (1));

return statearr_17387;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17367){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17388){if((e17388 instanceof Object)){
var ex__8254__auto__ = e17388;
var statearr_17389_17410 = state_17367;
(statearr_17389_17410[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17367);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17388;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17411 = state_17367;
state_17367 = G__17411;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17367){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17395))
})();
var state__8364__auto__ = (function (){var statearr_17390 = f__8363__auto__.call(null);
(statearr_17390[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17395);

return statearr_17390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17395))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__17595){
var vec__17596 = p__17595;
var v = cljs.core.nth.call(null,vec__17596,(0),null);
var p = cljs.core.nth.call(null,vec__17596,(1),null);
var job = vec__17596;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8362__auto___17778 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17778,res,vec__17596,v,p,job,jobs,results){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17778,res,vec__17596,v,p,job,jobs,results){
return (function (state_17601){
var state_val_17602 = (state_17601[(1)]);
if((state_val_17602 === (1))){
var state_17601__$1 = state_17601;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17601__$1,(2),res,v);
} else {
if((state_val_17602 === (2))){
var inst_17598 = (state_17601[(2)]);
var inst_17599 = cljs.core.async.close_BANG_.call(null,res);
var state_17601__$1 = (function (){var statearr_17603 = state_17601;
(statearr_17603[(7)] = inst_17598);

return statearr_17603;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17601__$1,inst_17599);
} else {
return null;
}
}
});})(c__8362__auto___17778,res,vec__17596,v,p,job,jobs,results))
;
return ((function (switch__8250__auto__,c__8362__auto___17778,res,vec__17596,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17607 = [null,null,null,null,null,null,null,null];
(statearr_17607[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17607[(1)] = (1));

return statearr_17607;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17601){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17608){if((e17608 instanceof Object)){
var ex__8254__auto__ = e17608;
var statearr_17609_17779 = state_17601;
(statearr_17609_17779[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17608;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17780 = state_17601;
state_17601 = G__17780;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17601){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17778,res,vec__17596,v,p,job,jobs,results))
})();
var state__8364__auto__ = (function (){var statearr_17610 = f__8363__auto__.call(null);
(statearr_17610[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17778);

return statearr_17610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17778,res,vec__17596,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17611){
var vec__17612 = p__17611;
var v = cljs.core.nth.call(null,vec__17612,(0),null);
var p = cljs.core.nth.call(null,vec__17612,(1),null);
var job = vec__17612;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__5571__auto___17781 = n;
var __17782 = (0);
while(true){
if((__17782 < n__5571__auto___17781)){
var G__17613_17783 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__17613_17783) {
case "compute":
var c__8362__auto___17785 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17782,c__8362__auto___17785,G__17613_17783,n__5571__auto___17781,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17782,c__8362__auto___17785,G__17613_17783,n__5571__auto___17781,jobs,results,process,async){
return (function (state_17626){
var state_val_17627 = (state_17626[(1)]);
if((state_val_17627 === (1))){
var state_17626__$1 = state_17626;
var statearr_17628_17786 = state_17626__$1;
(statearr_17628_17786[(2)] = null);

(statearr_17628_17786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (2))){
var state_17626__$1 = state_17626;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17626__$1,(4),jobs);
} else {
if((state_val_17627 === (3))){
var inst_17624 = (state_17626[(2)]);
var state_17626__$1 = state_17626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17626__$1,inst_17624);
} else {
if((state_val_17627 === (4))){
var inst_17616 = (state_17626[(2)]);
var inst_17617 = process.call(null,inst_17616);
var state_17626__$1 = state_17626;
if(cljs.core.truth_(inst_17617)){
var statearr_17629_17787 = state_17626__$1;
(statearr_17629_17787[(1)] = (5));

} else {
var statearr_17630_17788 = state_17626__$1;
(statearr_17630_17788[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (5))){
var state_17626__$1 = state_17626;
var statearr_17631_17789 = state_17626__$1;
(statearr_17631_17789[(2)] = null);

(statearr_17631_17789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (6))){
var state_17626__$1 = state_17626;
var statearr_17632_17790 = state_17626__$1;
(statearr_17632_17790[(2)] = null);

(statearr_17632_17790[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17627 === (7))){
var inst_17622 = (state_17626[(2)]);
var state_17626__$1 = state_17626;
var statearr_17633_17791 = state_17626__$1;
(statearr_17633_17791[(2)] = inst_17622);

(statearr_17633_17791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17782,c__8362__auto___17785,G__17613_17783,n__5571__auto___17781,jobs,results,process,async))
;
return ((function (__17782,switch__8250__auto__,c__8362__auto___17785,G__17613_17783,n__5571__auto___17781,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17637 = [null,null,null,null,null,null,null];
(statearr_17637[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17637[(1)] = (1));

return statearr_17637;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17626){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17638){if((e17638 instanceof Object)){
var ex__8254__auto__ = e17638;
var statearr_17639_17792 = state_17626;
(statearr_17639_17792[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17626);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17638;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17793 = state_17626;
state_17626 = G__17793;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17626){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17782,switch__8250__auto__,c__8362__auto___17785,G__17613_17783,n__5571__auto___17781,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17640 = f__8363__auto__.call(null);
(statearr_17640[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17785);

return statearr_17640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17782,c__8362__auto___17785,G__17613_17783,n__5571__auto___17781,jobs,results,process,async))
);


break;
case "async":
var c__8362__auto___17794 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17782,c__8362__auto___17794,G__17613_17783,n__5571__auto___17781,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (__17782,c__8362__auto___17794,G__17613_17783,n__5571__auto___17781,jobs,results,process,async){
return (function (state_17653){
var state_val_17654 = (state_17653[(1)]);
if((state_val_17654 === (1))){
var state_17653__$1 = state_17653;
var statearr_17655_17795 = state_17653__$1;
(statearr_17655_17795[(2)] = null);

(statearr_17655_17795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17654 === (2))){
var state_17653__$1 = state_17653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17653__$1,(4),jobs);
} else {
if((state_val_17654 === (3))){
var inst_17651 = (state_17653[(2)]);
var state_17653__$1 = state_17653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17653__$1,inst_17651);
} else {
if((state_val_17654 === (4))){
var inst_17643 = (state_17653[(2)]);
var inst_17644 = async.call(null,inst_17643);
var state_17653__$1 = state_17653;
if(cljs.core.truth_(inst_17644)){
var statearr_17656_17796 = state_17653__$1;
(statearr_17656_17796[(1)] = (5));

} else {
var statearr_17657_17797 = state_17653__$1;
(statearr_17657_17797[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17654 === (5))){
var state_17653__$1 = state_17653;
var statearr_17658_17798 = state_17653__$1;
(statearr_17658_17798[(2)] = null);

(statearr_17658_17798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17654 === (6))){
var state_17653__$1 = state_17653;
var statearr_17659_17799 = state_17653__$1;
(statearr_17659_17799[(2)] = null);

(statearr_17659_17799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17654 === (7))){
var inst_17649 = (state_17653[(2)]);
var state_17653__$1 = state_17653;
var statearr_17660_17800 = state_17653__$1;
(statearr_17660_17800[(2)] = inst_17649);

(statearr_17660_17800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17782,c__8362__auto___17794,G__17613_17783,n__5571__auto___17781,jobs,results,process,async))
;
return ((function (__17782,switch__8250__auto__,c__8362__auto___17794,G__17613_17783,n__5571__auto___17781,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17664 = [null,null,null,null,null,null,null];
(statearr_17664[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17664[(1)] = (1));

return statearr_17664;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17653){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17665){if((e17665 instanceof Object)){
var ex__8254__auto__ = e17665;
var statearr_17666_17801 = state_17653;
(statearr_17666_17801[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17653);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17665;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17802 = state_17653;
state_17653 = G__17802;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17653){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(__17782,switch__8250__auto__,c__8362__auto___17794,G__17613_17783,n__5571__auto___17781,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17667 = f__8363__auto__.call(null);
(statearr_17667[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17794);

return statearr_17667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(__17782,c__8362__auto___17794,G__17613_17783,n__5571__auto___17781,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17803 = (__17782 + (1));
__17782 = G__17803;
continue;
} else {
}
break;
}

var c__8362__auto___17804 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17804,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17804,jobs,results,process,async){
return (function (state_17689){
var state_val_17690 = (state_17689[(1)]);
if((state_val_17690 === (1))){
var state_17689__$1 = state_17689;
var statearr_17691_17805 = state_17689__$1;
(statearr_17691_17805[(2)] = null);

(statearr_17691_17805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17690 === (2))){
var state_17689__$1 = state_17689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17689__$1,(4),from);
} else {
if((state_val_17690 === (3))){
var inst_17687 = (state_17689[(2)]);
var state_17689__$1 = state_17689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17689__$1,inst_17687);
} else {
if((state_val_17690 === (4))){
var inst_17670 = (state_17689[(7)]);
var inst_17670__$1 = (state_17689[(2)]);
var inst_17671 = (inst_17670__$1 == null);
var state_17689__$1 = (function (){var statearr_17692 = state_17689;
(statearr_17692[(7)] = inst_17670__$1);

return statearr_17692;
})();
if(cljs.core.truth_(inst_17671)){
var statearr_17693_17806 = state_17689__$1;
(statearr_17693_17806[(1)] = (5));

} else {
var statearr_17694_17807 = state_17689__$1;
(statearr_17694_17807[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17690 === (5))){
var inst_17673 = cljs.core.async.close_BANG_.call(null,jobs);
var state_17689__$1 = state_17689;
var statearr_17695_17808 = state_17689__$1;
(statearr_17695_17808[(2)] = inst_17673);

(statearr_17695_17808[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17690 === (6))){
var inst_17670 = (state_17689[(7)]);
var inst_17675 = (state_17689[(8)]);
var inst_17675__$1 = cljs.core.async.chan.call(null,(1));
var inst_17676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17677 = [inst_17670,inst_17675__$1];
var inst_17678 = (new cljs.core.PersistentVector(null,2,(5),inst_17676,inst_17677,null));
var state_17689__$1 = (function (){var statearr_17696 = state_17689;
(statearr_17696[(8)] = inst_17675__$1);

return statearr_17696;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17689__$1,(8),jobs,inst_17678);
} else {
if((state_val_17690 === (7))){
var inst_17685 = (state_17689[(2)]);
var state_17689__$1 = state_17689;
var statearr_17697_17809 = state_17689__$1;
(statearr_17697_17809[(2)] = inst_17685);

(statearr_17697_17809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17690 === (8))){
var inst_17675 = (state_17689[(8)]);
var inst_17680 = (state_17689[(2)]);
var state_17689__$1 = (function (){var statearr_17698 = state_17689;
(statearr_17698[(9)] = inst_17680);

return statearr_17698;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17689__$1,(9),results,inst_17675);
} else {
if((state_val_17690 === (9))){
var inst_17682 = (state_17689[(2)]);
var state_17689__$1 = (function (){var statearr_17699 = state_17689;
(statearr_17699[(10)] = inst_17682);

return statearr_17699;
})();
var statearr_17700_17810 = state_17689__$1;
(statearr_17700_17810[(2)] = null);

(statearr_17700_17810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17804,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto___17804,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17704 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17704[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17704[(1)] = (1));

return statearr_17704;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17689){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17705){if((e17705 instanceof Object)){
var ex__8254__auto__ = e17705;
var statearr_17706_17811 = state_17689;
(statearr_17706_17811[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17705;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17812 = state_17689;
state_17689 = G__17812;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17689){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17804,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17707 = f__8363__auto__.call(null);
(statearr_17707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17804);

return statearr_17707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17804,jobs,results,process,async))
);


var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__,jobs,results,process,async){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__,jobs,results,process,async){
return (function (state_17745){
var state_val_17746 = (state_17745[(1)]);
if((state_val_17746 === (7))){
var inst_17741 = (state_17745[(2)]);
var state_17745__$1 = state_17745;
var statearr_17747_17813 = state_17745__$1;
(statearr_17747_17813[(2)] = inst_17741);

(statearr_17747_17813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (20))){
var state_17745__$1 = state_17745;
var statearr_17748_17814 = state_17745__$1;
(statearr_17748_17814[(2)] = null);

(statearr_17748_17814[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (1))){
var state_17745__$1 = state_17745;
var statearr_17749_17815 = state_17745__$1;
(statearr_17749_17815[(2)] = null);

(statearr_17749_17815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (4))){
var inst_17710 = (state_17745[(7)]);
var inst_17710__$1 = (state_17745[(2)]);
var inst_17711 = (inst_17710__$1 == null);
var state_17745__$1 = (function (){var statearr_17750 = state_17745;
(statearr_17750[(7)] = inst_17710__$1);

return statearr_17750;
})();
if(cljs.core.truth_(inst_17711)){
var statearr_17751_17816 = state_17745__$1;
(statearr_17751_17816[(1)] = (5));

} else {
var statearr_17752_17817 = state_17745__$1;
(statearr_17752_17817[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (15))){
var inst_17723 = (state_17745[(8)]);
var state_17745__$1 = state_17745;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17745__$1,(18),to,inst_17723);
} else {
if((state_val_17746 === (21))){
var inst_17736 = (state_17745[(2)]);
var state_17745__$1 = state_17745;
var statearr_17753_17818 = state_17745__$1;
(statearr_17753_17818[(2)] = inst_17736);

(statearr_17753_17818[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (13))){
var inst_17738 = (state_17745[(2)]);
var state_17745__$1 = (function (){var statearr_17754 = state_17745;
(statearr_17754[(9)] = inst_17738);

return statearr_17754;
})();
var statearr_17755_17819 = state_17745__$1;
(statearr_17755_17819[(2)] = null);

(statearr_17755_17819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (6))){
var inst_17710 = (state_17745[(7)]);
var state_17745__$1 = state_17745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17745__$1,(11),inst_17710);
} else {
if((state_val_17746 === (17))){
var inst_17731 = (state_17745[(2)]);
var state_17745__$1 = state_17745;
if(cljs.core.truth_(inst_17731)){
var statearr_17756_17820 = state_17745__$1;
(statearr_17756_17820[(1)] = (19));

} else {
var statearr_17757_17821 = state_17745__$1;
(statearr_17757_17821[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (3))){
var inst_17743 = (state_17745[(2)]);
var state_17745__$1 = state_17745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17745__$1,inst_17743);
} else {
if((state_val_17746 === (12))){
var inst_17720 = (state_17745[(10)]);
var state_17745__$1 = state_17745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17745__$1,(14),inst_17720);
} else {
if((state_val_17746 === (2))){
var state_17745__$1 = state_17745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17745__$1,(4),results);
} else {
if((state_val_17746 === (19))){
var state_17745__$1 = state_17745;
var statearr_17758_17822 = state_17745__$1;
(statearr_17758_17822[(2)] = null);

(statearr_17758_17822[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (11))){
var inst_17720 = (state_17745[(2)]);
var state_17745__$1 = (function (){var statearr_17759 = state_17745;
(statearr_17759[(10)] = inst_17720);

return statearr_17759;
})();
var statearr_17760_17823 = state_17745__$1;
(statearr_17760_17823[(2)] = null);

(statearr_17760_17823[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (9))){
var state_17745__$1 = state_17745;
var statearr_17761_17824 = state_17745__$1;
(statearr_17761_17824[(2)] = null);

(statearr_17761_17824[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (5))){
var state_17745__$1 = state_17745;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17762_17825 = state_17745__$1;
(statearr_17762_17825[(1)] = (8));

} else {
var statearr_17763_17826 = state_17745__$1;
(statearr_17763_17826[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (14))){
var inst_17725 = (state_17745[(11)]);
var inst_17723 = (state_17745[(8)]);
var inst_17723__$1 = (state_17745[(2)]);
var inst_17724 = (inst_17723__$1 == null);
var inst_17725__$1 = cljs.core.not.call(null,inst_17724);
var state_17745__$1 = (function (){var statearr_17764 = state_17745;
(statearr_17764[(11)] = inst_17725__$1);

(statearr_17764[(8)] = inst_17723__$1);

return statearr_17764;
})();
if(inst_17725__$1){
var statearr_17765_17827 = state_17745__$1;
(statearr_17765_17827[(1)] = (15));

} else {
var statearr_17766_17828 = state_17745__$1;
(statearr_17766_17828[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (16))){
var inst_17725 = (state_17745[(11)]);
var state_17745__$1 = state_17745;
var statearr_17767_17829 = state_17745__$1;
(statearr_17767_17829[(2)] = inst_17725);

(statearr_17767_17829[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (10))){
var inst_17717 = (state_17745[(2)]);
var state_17745__$1 = state_17745;
var statearr_17768_17830 = state_17745__$1;
(statearr_17768_17830[(2)] = inst_17717);

(statearr_17768_17830[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (18))){
var inst_17728 = (state_17745[(2)]);
var state_17745__$1 = state_17745;
var statearr_17769_17831 = state_17745__$1;
(statearr_17769_17831[(2)] = inst_17728);

(statearr_17769_17831[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17746 === (8))){
var inst_17714 = cljs.core.async.close_BANG_.call(null,to);
var state_17745__$1 = state_17745;
var statearr_17770_17832 = state_17745__$1;
(statearr_17770_17832[(2)] = inst_17714);

(statearr_17770_17832[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__,jobs,results,process,async))
;
return ((function (switch__8250__auto__,c__8362__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_17774 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17774[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__);

(statearr_17774[(1)] = (1));

return statearr_17774;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1 = (function (state_17745){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17775){if((e17775 instanceof Object)){
var ex__8254__auto__ = e17775;
var statearr_17776_17833 = state_17745;
(statearr_17776_17833[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17745);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17775;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17834 = state_17745;
state_17745 = G__17834;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__ = function(state_17745){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1.call(this,state_17745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__,jobs,results,process,async))
})();
var state__8364__auto__ = (function (){var statearr_17777 = f__8363__auto__.call(null);
(statearr_17777[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_17777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__,jobs,results,process,async))
);

return c__8362__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17835 = [];
var len__5726__auto___17838 = arguments.length;
var i__5727__auto___17839 = (0);
while(true){
if((i__5727__auto___17839 < len__5726__auto___17838)){
args17835.push((arguments[i__5727__auto___17839]));

var G__17840 = (i__5727__auto___17839 + (1));
i__5727__auto___17839 = G__17840;
continue;
} else {
}
break;
}

var G__17837 = args17835.length;
switch (G__17837) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17835.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17842 = [];
var len__5726__auto___17845 = arguments.length;
var i__5727__auto___17846 = (0);
while(true){
if((i__5727__auto___17846 < len__5726__auto___17845)){
args17842.push((arguments[i__5727__auto___17846]));

var G__17847 = (i__5727__auto___17846 + (1));
i__5727__auto___17846 = G__17847;
continue;
} else {
}
break;
}

var G__17844 = args17842.length;
switch (G__17844) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17842.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17849 = [];
var len__5726__auto___17902 = arguments.length;
var i__5727__auto___17903 = (0);
while(true){
if((i__5727__auto___17903 < len__5726__auto___17902)){
args17849.push((arguments[i__5727__auto___17903]));

var G__17904 = (i__5727__auto___17903 + (1));
i__5727__auto___17903 = G__17904;
continue;
} else {
}
break;
}

var G__17851 = args17849.length;
switch (G__17851) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17849.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8362__auto___17906 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___17906,tc,fc){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___17906,tc,fc){
return (function (state_17877){
var state_val_17878 = (state_17877[(1)]);
if((state_val_17878 === (7))){
var inst_17873 = (state_17877[(2)]);
var state_17877__$1 = state_17877;
var statearr_17879_17907 = state_17877__$1;
(statearr_17879_17907[(2)] = inst_17873);

(statearr_17879_17907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (1))){
var state_17877__$1 = state_17877;
var statearr_17880_17908 = state_17877__$1;
(statearr_17880_17908[(2)] = null);

(statearr_17880_17908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (4))){
var inst_17854 = (state_17877[(7)]);
var inst_17854__$1 = (state_17877[(2)]);
var inst_17855 = (inst_17854__$1 == null);
var state_17877__$1 = (function (){var statearr_17881 = state_17877;
(statearr_17881[(7)] = inst_17854__$1);

return statearr_17881;
})();
if(cljs.core.truth_(inst_17855)){
var statearr_17882_17909 = state_17877__$1;
(statearr_17882_17909[(1)] = (5));

} else {
var statearr_17883_17910 = state_17877__$1;
(statearr_17883_17910[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (13))){
var state_17877__$1 = state_17877;
var statearr_17884_17911 = state_17877__$1;
(statearr_17884_17911[(2)] = null);

(statearr_17884_17911[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (6))){
var inst_17854 = (state_17877[(7)]);
var inst_17860 = p.call(null,inst_17854);
var state_17877__$1 = state_17877;
if(cljs.core.truth_(inst_17860)){
var statearr_17885_17912 = state_17877__$1;
(statearr_17885_17912[(1)] = (9));

} else {
var statearr_17886_17913 = state_17877__$1;
(statearr_17886_17913[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (3))){
var inst_17875 = (state_17877[(2)]);
var state_17877__$1 = state_17877;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17877__$1,inst_17875);
} else {
if((state_val_17878 === (12))){
var state_17877__$1 = state_17877;
var statearr_17887_17914 = state_17877__$1;
(statearr_17887_17914[(2)] = null);

(statearr_17887_17914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (2))){
var state_17877__$1 = state_17877;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17877__$1,(4),ch);
} else {
if((state_val_17878 === (11))){
var inst_17854 = (state_17877[(7)]);
var inst_17864 = (state_17877[(2)]);
var state_17877__$1 = state_17877;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17877__$1,(8),inst_17864,inst_17854);
} else {
if((state_val_17878 === (9))){
var state_17877__$1 = state_17877;
var statearr_17888_17915 = state_17877__$1;
(statearr_17888_17915[(2)] = tc);

(statearr_17888_17915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (5))){
var inst_17857 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17858 = cljs.core.async.close_BANG_.call(null,fc);
var state_17877__$1 = (function (){var statearr_17889 = state_17877;
(statearr_17889[(8)] = inst_17857);

return statearr_17889;
})();
var statearr_17890_17916 = state_17877__$1;
(statearr_17890_17916[(2)] = inst_17858);

(statearr_17890_17916[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (14))){
var inst_17871 = (state_17877[(2)]);
var state_17877__$1 = state_17877;
var statearr_17891_17917 = state_17877__$1;
(statearr_17891_17917[(2)] = inst_17871);

(statearr_17891_17917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (10))){
var state_17877__$1 = state_17877;
var statearr_17892_17918 = state_17877__$1;
(statearr_17892_17918[(2)] = fc);

(statearr_17892_17918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17878 === (8))){
var inst_17866 = (state_17877[(2)]);
var state_17877__$1 = state_17877;
if(cljs.core.truth_(inst_17866)){
var statearr_17893_17919 = state_17877__$1;
(statearr_17893_17919[(1)] = (12));

} else {
var statearr_17894_17920 = state_17877__$1;
(statearr_17894_17920[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___17906,tc,fc))
;
return ((function (switch__8250__auto__,c__8362__auto___17906,tc,fc){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_17898 = [null,null,null,null,null,null,null,null,null];
(statearr_17898[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_17898[(1)] = (1));

return statearr_17898;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_17877){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17877);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e17899){if((e17899 instanceof Object)){
var ex__8254__auto__ = e17899;
var statearr_17900_17921 = state_17877;
(statearr_17900_17921[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17877);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17899;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17922 = state_17877;
state_17877 = G__17922;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_17877){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_17877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___17906,tc,fc))
})();
var state__8364__auto__ = (function (){var statearr_17901 = f__8363__auto__.call(null);
(statearr_17901[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___17906);

return statearr_17901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___17906,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_17986){
var state_val_17987 = (state_17986[(1)]);
if((state_val_17987 === (7))){
var inst_17982 = (state_17986[(2)]);
var state_17986__$1 = state_17986;
var statearr_17988_18009 = state_17986__$1;
(statearr_17988_18009[(2)] = inst_17982);

(statearr_17988_18009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (1))){
var inst_17966 = init;
var state_17986__$1 = (function (){var statearr_17989 = state_17986;
(statearr_17989[(7)] = inst_17966);

return statearr_17989;
})();
var statearr_17990_18010 = state_17986__$1;
(statearr_17990_18010[(2)] = null);

(statearr_17990_18010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (4))){
var inst_17969 = (state_17986[(8)]);
var inst_17969__$1 = (state_17986[(2)]);
var inst_17970 = (inst_17969__$1 == null);
var state_17986__$1 = (function (){var statearr_17991 = state_17986;
(statearr_17991[(8)] = inst_17969__$1);

return statearr_17991;
})();
if(cljs.core.truth_(inst_17970)){
var statearr_17992_18011 = state_17986__$1;
(statearr_17992_18011[(1)] = (5));

} else {
var statearr_17993_18012 = state_17986__$1;
(statearr_17993_18012[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (6))){
var inst_17966 = (state_17986[(7)]);
var inst_17969 = (state_17986[(8)]);
var inst_17973 = (state_17986[(9)]);
var inst_17973__$1 = f.call(null,inst_17966,inst_17969);
var inst_17974 = cljs.core.reduced_QMARK_.call(null,inst_17973__$1);
var state_17986__$1 = (function (){var statearr_17994 = state_17986;
(statearr_17994[(9)] = inst_17973__$1);

return statearr_17994;
})();
if(inst_17974){
var statearr_17995_18013 = state_17986__$1;
(statearr_17995_18013[(1)] = (8));

} else {
var statearr_17996_18014 = state_17986__$1;
(statearr_17996_18014[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (3))){
var inst_17984 = (state_17986[(2)]);
var state_17986__$1 = state_17986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17986__$1,inst_17984);
} else {
if((state_val_17987 === (2))){
var state_17986__$1 = state_17986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17986__$1,(4),ch);
} else {
if((state_val_17987 === (9))){
var inst_17973 = (state_17986[(9)]);
var inst_17966 = inst_17973;
var state_17986__$1 = (function (){var statearr_17997 = state_17986;
(statearr_17997[(7)] = inst_17966);

return statearr_17997;
})();
var statearr_17998_18015 = state_17986__$1;
(statearr_17998_18015[(2)] = null);

(statearr_17998_18015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (5))){
var inst_17966 = (state_17986[(7)]);
var state_17986__$1 = state_17986;
var statearr_17999_18016 = state_17986__$1;
(statearr_17999_18016[(2)] = inst_17966);

(statearr_17999_18016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (10))){
var inst_17980 = (state_17986[(2)]);
var state_17986__$1 = state_17986;
var statearr_18000_18017 = state_17986__$1;
(statearr_18000_18017[(2)] = inst_17980);

(statearr_18000_18017[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17987 === (8))){
var inst_17973 = (state_17986[(9)]);
var inst_17976 = cljs.core.deref.call(null,inst_17973);
var state_17986__$1 = state_17986;
var statearr_18001_18018 = state_17986__$1;
(statearr_18001_18018[(2)] = inst_17976);

(statearr_18001_18018[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8251__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8251__auto____0 = (function (){
var statearr_18005 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18005[(0)] = cljs$core$async$reduce_$_state_machine__8251__auto__);

(statearr_18005[(1)] = (1));

return statearr_18005;
});
var cljs$core$async$reduce_$_state_machine__8251__auto____1 = (function (state_17986){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_17986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18006){if((e18006 instanceof Object)){
var ex__8254__auto__ = e18006;
var statearr_18007_18019 = state_17986;
(statearr_18007_18019[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17986);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18020 = state_17986;
state_17986 = G__18020;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8251__auto__ = function(state_17986){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8251__auto____1.call(this,state_17986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8251__auto____0;
cljs$core$async$reduce_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8251__auto____1;
return cljs$core$async$reduce_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18008 = f__8363__auto__.call(null);
(statearr_18008[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18021 = [];
var len__5726__auto___18073 = arguments.length;
var i__5727__auto___18074 = (0);
while(true){
if((i__5727__auto___18074 < len__5726__auto___18073)){
args18021.push((arguments[i__5727__auto___18074]));

var G__18075 = (i__5727__auto___18074 + (1));
i__5727__auto___18074 = G__18075;
continue;
} else {
}
break;
}

var G__18023 = args18021.length;
switch (G__18023) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18021.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_18048){
var state_val_18049 = (state_18048[(1)]);
if((state_val_18049 === (7))){
var inst_18030 = (state_18048[(2)]);
var state_18048__$1 = state_18048;
var statearr_18050_18077 = state_18048__$1;
(statearr_18050_18077[(2)] = inst_18030);

(statearr_18050_18077[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (1))){
var inst_18024 = cljs.core.seq.call(null,coll);
var inst_18025 = inst_18024;
var state_18048__$1 = (function (){var statearr_18051 = state_18048;
(statearr_18051[(7)] = inst_18025);

return statearr_18051;
})();
var statearr_18052_18078 = state_18048__$1;
(statearr_18052_18078[(2)] = null);

(statearr_18052_18078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (4))){
var inst_18025 = (state_18048[(7)]);
var inst_18028 = cljs.core.first.call(null,inst_18025);
var state_18048__$1 = state_18048;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18048__$1,(7),ch,inst_18028);
} else {
if((state_val_18049 === (13))){
var inst_18042 = (state_18048[(2)]);
var state_18048__$1 = state_18048;
var statearr_18053_18079 = state_18048__$1;
(statearr_18053_18079[(2)] = inst_18042);

(statearr_18053_18079[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (6))){
var inst_18033 = (state_18048[(2)]);
var state_18048__$1 = state_18048;
if(cljs.core.truth_(inst_18033)){
var statearr_18054_18080 = state_18048__$1;
(statearr_18054_18080[(1)] = (8));

} else {
var statearr_18055_18081 = state_18048__$1;
(statearr_18055_18081[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (3))){
var inst_18046 = (state_18048[(2)]);
var state_18048__$1 = state_18048;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18048__$1,inst_18046);
} else {
if((state_val_18049 === (12))){
var state_18048__$1 = state_18048;
var statearr_18056_18082 = state_18048__$1;
(statearr_18056_18082[(2)] = null);

(statearr_18056_18082[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (2))){
var inst_18025 = (state_18048[(7)]);
var state_18048__$1 = state_18048;
if(cljs.core.truth_(inst_18025)){
var statearr_18057_18083 = state_18048__$1;
(statearr_18057_18083[(1)] = (4));

} else {
var statearr_18058_18084 = state_18048__$1;
(statearr_18058_18084[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (11))){
var inst_18039 = cljs.core.async.close_BANG_.call(null,ch);
var state_18048__$1 = state_18048;
var statearr_18059_18085 = state_18048__$1;
(statearr_18059_18085[(2)] = inst_18039);

(statearr_18059_18085[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (9))){
var state_18048__$1 = state_18048;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18060_18086 = state_18048__$1;
(statearr_18060_18086[(1)] = (11));

} else {
var statearr_18061_18087 = state_18048__$1;
(statearr_18061_18087[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (5))){
var inst_18025 = (state_18048[(7)]);
var state_18048__$1 = state_18048;
var statearr_18062_18088 = state_18048__$1;
(statearr_18062_18088[(2)] = inst_18025);

(statearr_18062_18088[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (10))){
var inst_18044 = (state_18048[(2)]);
var state_18048__$1 = state_18048;
var statearr_18063_18089 = state_18048__$1;
(statearr_18063_18089[(2)] = inst_18044);

(statearr_18063_18089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18049 === (8))){
var inst_18025 = (state_18048[(7)]);
var inst_18035 = cljs.core.next.call(null,inst_18025);
var inst_18025__$1 = inst_18035;
var state_18048__$1 = (function (){var statearr_18064 = state_18048;
(statearr_18064[(7)] = inst_18025__$1);

return statearr_18064;
})();
var statearr_18065_18090 = state_18048__$1;
(statearr_18065_18090[(2)] = null);

(statearr_18065_18090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_18069 = [null,null,null,null,null,null,null,null];
(statearr_18069[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_18069[(1)] = (1));

return statearr_18069;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_18048){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18048);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18070){if((e18070 instanceof Object)){
var ex__8254__auto__ = e18070;
var statearr_18071_18091 = state_18048;
(statearr_18071_18091[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18048);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18070;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18092 = state_18048;
state_18048 = G__18092;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_18048){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_18048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_18072 = f__8363__auto__.call(null);
(statearr_18072[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_18072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__5323__auto__ = (((_ == null))?null:_);
var m__5324__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,_);
} else {
var m__5324__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18314 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18314 = (function (mult,ch,cs,meta18315){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta18315 = meta18315;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18314.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_18316,meta18315__$1){
var self__ = this;
var _18316__$1 = this;
return (new cljs.core.async.t_cljs$core$async18314(self__.mult,self__.ch,self__.cs,meta18315__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async18314.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_18316){
var self__ = this;
var _18316__$1 = this;
return self__.meta18315;
});})(cs))
;

cljs.core.async.t_cljs$core$async18314.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18314.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async18314.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async18314.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18314.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18314.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async18314.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta18315","meta18315",765588120,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async18314.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18314.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18314";

cljs.core.async.t_cljs$core$async18314.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18314");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async18314 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async18314(mult__$1,ch__$1,cs__$1,meta18315){
return (new cljs.core.async.t_cljs$core$async18314(mult__$1,ch__$1,cs__$1,meta18315));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async18314(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8362__auto___18535 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18535,cs,m,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18535,cs,m,dchan,dctr,done){
return (function (state_18447){
var state_val_18448 = (state_18447[(1)]);
if((state_val_18448 === (7))){
var inst_18443 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18449_18536 = state_18447__$1;
(statearr_18449_18536[(2)] = inst_18443);

(statearr_18449_18536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (20))){
var inst_18348 = (state_18447[(7)]);
var inst_18358 = cljs.core.first.call(null,inst_18348);
var inst_18359 = cljs.core.nth.call(null,inst_18358,(0),null);
var inst_18360 = cljs.core.nth.call(null,inst_18358,(1),null);
var state_18447__$1 = (function (){var statearr_18450 = state_18447;
(statearr_18450[(8)] = inst_18359);

return statearr_18450;
})();
if(cljs.core.truth_(inst_18360)){
var statearr_18451_18537 = state_18447__$1;
(statearr_18451_18537[(1)] = (22));

} else {
var statearr_18452_18538 = state_18447__$1;
(statearr_18452_18538[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (27))){
var inst_18388 = (state_18447[(9)]);
var inst_18395 = (state_18447[(10)]);
var inst_18390 = (state_18447[(11)]);
var inst_18319 = (state_18447[(12)]);
var inst_18395__$1 = cljs.core._nth.call(null,inst_18388,inst_18390);
var inst_18396 = cljs.core.async.put_BANG_.call(null,inst_18395__$1,inst_18319,done);
var state_18447__$1 = (function (){var statearr_18453 = state_18447;
(statearr_18453[(10)] = inst_18395__$1);

return statearr_18453;
})();
if(cljs.core.truth_(inst_18396)){
var statearr_18454_18539 = state_18447__$1;
(statearr_18454_18539[(1)] = (30));

} else {
var statearr_18455_18540 = state_18447__$1;
(statearr_18455_18540[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (1))){
var state_18447__$1 = state_18447;
var statearr_18456_18541 = state_18447__$1;
(statearr_18456_18541[(2)] = null);

(statearr_18456_18541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (24))){
var inst_18348 = (state_18447[(7)]);
var inst_18365 = (state_18447[(2)]);
var inst_18366 = cljs.core.next.call(null,inst_18348);
var inst_18328 = inst_18366;
var inst_18329 = null;
var inst_18330 = (0);
var inst_18331 = (0);
var state_18447__$1 = (function (){var statearr_18457 = state_18447;
(statearr_18457[(13)] = inst_18365);

(statearr_18457[(14)] = inst_18330);

(statearr_18457[(15)] = inst_18331);

(statearr_18457[(16)] = inst_18328);

(statearr_18457[(17)] = inst_18329);

return statearr_18457;
})();
var statearr_18458_18542 = state_18447__$1;
(statearr_18458_18542[(2)] = null);

(statearr_18458_18542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (39))){
var state_18447__$1 = state_18447;
var statearr_18462_18543 = state_18447__$1;
(statearr_18462_18543[(2)] = null);

(statearr_18462_18543[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (4))){
var inst_18319 = (state_18447[(12)]);
var inst_18319__$1 = (state_18447[(2)]);
var inst_18320 = (inst_18319__$1 == null);
var state_18447__$1 = (function (){var statearr_18463 = state_18447;
(statearr_18463[(12)] = inst_18319__$1);

return statearr_18463;
})();
if(cljs.core.truth_(inst_18320)){
var statearr_18464_18544 = state_18447__$1;
(statearr_18464_18544[(1)] = (5));

} else {
var statearr_18465_18545 = state_18447__$1;
(statearr_18465_18545[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (15))){
var inst_18330 = (state_18447[(14)]);
var inst_18331 = (state_18447[(15)]);
var inst_18328 = (state_18447[(16)]);
var inst_18329 = (state_18447[(17)]);
var inst_18344 = (state_18447[(2)]);
var inst_18345 = (inst_18331 + (1));
var tmp18459 = inst_18330;
var tmp18460 = inst_18328;
var tmp18461 = inst_18329;
var inst_18328__$1 = tmp18460;
var inst_18329__$1 = tmp18461;
var inst_18330__$1 = tmp18459;
var inst_18331__$1 = inst_18345;
var state_18447__$1 = (function (){var statearr_18466 = state_18447;
(statearr_18466[(18)] = inst_18344);

(statearr_18466[(14)] = inst_18330__$1);

(statearr_18466[(15)] = inst_18331__$1);

(statearr_18466[(16)] = inst_18328__$1);

(statearr_18466[(17)] = inst_18329__$1);

return statearr_18466;
})();
var statearr_18467_18546 = state_18447__$1;
(statearr_18467_18546[(2)] = null);

(statearr_18467_18546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (21))){
var inst_18369 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18471_18547 = state_18447__$1;
(statearr_18471_18547[(2)] = inst_18369);

(statearr_18471_18547[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (31))){
var inst_18395 = (state_18447[(10)]);
var inst_18399 = done.call(null,null);
var inst_18400 = cljs.core.async.untap_STAR_.call(null,m,inst_18395);
var state_18447__$1 = (function (){var statearr_18472 = state_18447;
(statearr_18472[(19)] = inst_18399);

return statearr_18472;
})();
var statearr_18473_18548 = state_18447__$1;
(statearr_18473_18548[(2)] = inst_18400);

(statearr_18473_18548[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (32))){
var inst_18389 = (state_18447[(20)]);
var inst_18387 = (state_18447[(21)]);
var inst_18388 = (state_18447[(9)]);
var inst_18390 = (state_18447[(11)]);
var inst_18402 = (state_18447[(2)]);
var inst_18403 = (inst_18390 + (1));
var tmp18468 = inst_18389;
var tmp18469 = inst_18387;
var tmp18470 = inst_18388;
var inst_18387__$1 = tmp18469;
var inst_18388__$1 = tmp18470;
var inst_18389__$1 = tmp18468;
var inst_18390__$1 = inst_18403;
var state_18447__$1 = (function (){var statearr_18474 = state_18447;
(statearr_18474[(22)] = inst_18402);

(statearr_18474[(20)] = inst_18389__$1);

(statearr_18474[(21)] = inst_18387__$1);

(statearr_18474[(9)] = inst_18388__$1);

(statearr_18474[(11)] = inst_18390__$1);

return statearr_18474;
})();
var statearr_18475_18549 = state_18447__$1;
(statearr_18475_18549[(2)] = null);

(statearr_18475_18549[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (40))){
var inst_18415 = (state_18447[(23)]);
var inst_18419 = done.call(null,null);
var inst_18420 = cljs.core.async.untap_STAR_.call(null,m,inst_18415);
var state_18447__$1 = (function (){var statearr_18476 = state_18447;
(statearr_18476[(24)] = inst_18419);

return statearr_18476;
})();
var statearr_18477_18550 = state_18447__$1;
(statearr_18477_18550[(2)] = inst_18420);

(statearr_18477_18550[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (33))){
var inst_18406 = (state_18447[(25)]);
var inst_18408 = cljs.core.chunked_seq_QMARK_.call(null,inst_18406);
var state_18447__$1 = state_18447;
if(inst_18408){
var statearr_18478_18551 = state_18447__$1;
(statearr_18478_18551[(1)] = (36));

} else {
var statearr_18479_18552 = state_18447__$1;
(statearr_18479_18552[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (13))){
var inst_18338 = (state_18447[(26)]);
var inst_18341 = cljs.core.async.close_BANG_.call(null,inst_18338);
var state_18447__$1 = state_18447;
var statearr_18480_18553 = state_18447__$1;
(statearr_18480_18553[(2)] = inst_18341);

(statearr_18480_18553[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (22))){
var inst_18359 = (state_18447[(8)]);
var inst_18362 = cljs.core.async.close_BANG_.call(null,inst_18359);
var state_18447__$1 = state_18447;
var statearr_18481_18554 = state_18447__$1;
(statearr_18481_18554[(2)] = inst_18362);

(statearr_18481_18554[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (36))){
var inst_18406 = (state_18447[(25)]);
var inst_18410 = cljs.core.chunk_first.call(null,inst_18406);
var inst_18411 = cljs.core.chunk_rest.call(null,inst_18406);
var inst_18412 = cljs.core.count.call(null,inst_18410);
var inst_18387 = inst_18411;
var inst_18388 = inst_18410;
var inst_18389 = inst_18412;
var inst_18390 = (0);
var state_18447__$1 = (function (){var statearr_18482 = state_18447;
(statearr_18482[(20)] = inst_18389);

(statearr_18482[(21)] = inst_18387);

(statearr_18482[(9)] = inst_18388);

(statearr_18482[(11)] = inst_18390);

return statearr_18482;
})();
var statearr_18483_18555 = state_18447__$1;
(statearr_18483_18555[(2)] = null);

(statearr_18483_18555[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (41))){
var inst_18406 = (state_18447[(25)]);
var inst_18422 = (state_18447[(2)]);
var inst_18423 = cljs.core.next.call(null,inst_18406);
var inst_18387 = inst_18423;
var inst_18388 = null;
var inst_18389 = (0);
var inst_18390 = (0);
var state_18447__$1 = (function (){var statearr_18484 = state_18447;
(statearr_18484[(20)] = inst_18389);

(statearr_18484[(21)] = inst_18387);

(statearr_18484[(9)] = inst_18388);

(statearr_18484[(27)] = inst_18422);

(statearr_18484[(11)] = inst_18390);

return statearr_18484;
})();
var statearr_18485_18556 = state_18447__$1;
(statearr_18485_18556[(2)] = null);

(statearr_18485_18556[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (43))){
var state_18447__$1 = state_18447;
var statearr_18486_18557 = state_18447__$1;
(statearr_18486_18557[(2)] = null);

(statearr_18486_18557[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (29))){
var inst_18431 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18487_18558 = state_18447__$1;
(statearr_18487_18558[(2)] = inst_18431);

(statearr_18487_18558[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (44))){
var inst_18440 = (state_18447[(2)]);
var state_18447__$1 = (function (){var statearr_18488 = state_18447;
(statearr_18488[(28)] = inst_18440);

return statearr_18488;
})();
var statearr_18489_18559 = state_18447__$1;
(statearr_18489_18559[(2)] = null);

(statearr_18489_18559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (6))){
var inst_18379 = (state_18447[(29)]);
var inst_18378 = cljs.core.deref.call(null,cs);
var inst_18379__$1 = cljs.core.keys.call(null,inst_18378);
var inst_18380 = cljs.core.count.call(null,inst_18379__$1);
var inst_18381 = cljs.core.reset_BANG_.call(null,dctr,inst_18380);
var inst_18386 = cljs.core.seq.call(null,inst_18379__$1);
var inst_18387 = inst_18386;
var inst_18388 = null;
var inst_18389 = (0);
var inst_18390 = (0);
var state_18447__$1 = (function (){var statearr_18490 = state_18447;
(statearr_18490[(20)] = inst_18389);

(statearr_18490[(21)] = inst_18387);

(statearr_18490[(9)] = inst_18388);

(statearr_18490[(30)] = inst_18381);

(statearr_18490[(29)] = inst_18379__$1);

(statearr_18490[(11)] = inst_18390);

return statearr_18490;
})();
var statearr_18491_18560 = state_18447__$1;
(statearr_18491_18560[(2)] = null);

(statearr_18491_18560[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (28))){
var inst_18387 = (state_18447[(21)]);
var inst_18406 = (state_18447[(25)]);
var inst_18406__$1 = cljs.core.seq.call(null,inst_18387);
var state_18447__$1 = (function (){var statearr_18492 = state_18447;
(statearr_18492[(25)] = inst_18406__$1);

return statearr_18492;
})();
if(inst_18406__$1){
var statearr_18493_18561 = state_18447__$1;
(statearr_18493_18561[(1)] = (33));

} else {
var statearr_18494_18562 = state_18447__$1;
(statearr_18494_18562[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (25))){
var inst_18389 = (state_18447[(20)]);
var inst_18390 = (state_18447[(11)]);
var inst_18392 = (inst_18390 < inst_18389);
var inst_18393 = inst_18392;
var state_18447__$1 = state_18447;
if(cljs.core.truth_(inst_18393)){
var statearr_18495_18563 = state_18447__$1;
(statearr_18495_18563[(1)] = (27));

} else {
var statearr_18496_18564 = state_18447__$1;
(statearr_18496_18564[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (34))){
var state_18447__$1 = state_18447;
var statearr_18497_18565 = state_18447__$1;
(statearr_18497_18565[(2)] = null);

(statearr_18497_18565[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (17))){
var state_18447__$1 = state_18447;
var statearr_18498_18566 = state_18447__$1;
(statearr_18498_18566[(2)] = null);

(statearr_18498_18566[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (3))){
var inst_18445 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18447__$1,inst_18445);
} else {
if((state_val_18448 === (12))){
var inst_18374 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18499_18567 = state_18447__$1;
(statearr_18499_18567[(2)] = inst_18374);

(statearr_18499_18567[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (2))){
var state_18447__$1 = state_18447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18447__$1,(4),ch);
} else {
if((state_val_18448 === (23))){
var state_18447__$1 = state_18447;
var statearr_18500_18568 = state_18447__$1;
(statearr_18500_18568[(2)] = null);

(statearr_18500_18568[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (35))){
var inst_18429 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18501_18569 = state_18447__$1;
(statearr_18501_18569[(2)] = inst_18429);

(statearr_18501_18569[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (19))){
var inst_18348 = (state_18447[(7)]);
var inst_18352 = cljs.core.chunk_first.call(null,inst_18348);
var inst_18353 = cljs.core.chunk_rest.call(null,inst_18348);
var inst_18354 = cljs.core.count.call(null,inst_18352);
var inst_18328 = inst_18353;
var inst_18329 = inst_18352;
var inst_18330 = inst_18354;
var inst_18331 = (0);
var state_18447__$1 = (function (){var statearr_18502 = state_18447;
(statearr_18502[(14)] = inst_18330);

(statearr_18502[(15)] = inst_18331);

(statearr_18502[(16)] = inst_18328);

(statearr_18502[(17)] = inst_18329);

return statearr_18502;
})();
var statearr_18503_18570 = state_18447__$1;
(statearr_18503_18570[(2)] = null);

(statearr_18503_18570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (11))){
var inst_18348 = (state_18447[(7)]);
var inst_18328 = (state_18447[(16)]);
var inst_18348__$1 = cljs.core.seq.call(null,inst_18328);
var state_18447__$1 = (function (){var statearr_18504 = state_18447;
(statearr_18504[(7)] = inst_18348__$1);

return statearr_18504;
})();
if(inst_18348__$1){
var statearr_18505_18571 = state_18447__$1;
(statearr_18505_18571[(1)] = (16));

} else {
var statearr_18506_18572 = state_18447__$1;
(statearr_18506_18572[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (9))){
var inst_18376 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18507_18573 = state_18447__$1;
(statearr_18507_18573[(2)] = inst_18376);

(statearr_18507_18573[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (5))){
var inst_18326 = cljs.core.deref.call(null,cs);
var inst_18327 = cljs.core.seq.call(null,inst_18326);
var inst_18328 = inst_18327;
var inst_18329 = null;
var inst_18330 = (0);
var inst_18331 = (0);
var state_18447__$1 = (function (){var statearr_18508 = state_18447;
(statearr_18508[(14)] = inst_18330);

(statearr_18508[(15)] = inst_18331);

(statearr_18508[(16)] = inst_18328);

(statearr_18508[(17)] = inst_18329);

return statearr_18508;
})();
var statearr_18509_18574 = state_18447__$1;
(statearr_18509_18574[(2)] = null);

(statearr_18509_18574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (14))){
var state_18447__$1 = state_18447;
var statearr_18510_18575 = state_18447__$1;
(statearr_18510_18575[(2)] = null);

(statearr_18510_18575[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (45))){
var inst_18437 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18511_18576 = state_18447__$1;
(statearr_18511_18576[(2)] = inst_18437);

(statearr_18511_18576[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (26))){
var inst_18379 = (state_18447[(29)]);
var inst_18433 = (state_18447[(2)]);
var inst_18434 = cljs.core.seq.call(null,inst_18379);
var state_18447__$1 = (function (){var statearr_18512 = state_18447;
(statearr_18512[(31)] = inst_18433);

return statearr_18512;
})();
if(inst_18434){
var statearr_18513_18577 = state_18447__$1;
(statearr_18513_18577[(1)] = (42));

} else {
var statearr_18514_18578 = state_18447__$1;
(statearr_18514_18578[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (16))){
var inst_18348 = (state_18447[(7)]);
var inst_18350 = cljs.core.chunked_seq_QMARK_.call(null,inst_18348);
var state_18447__$1 = state_18447;
if(inst_18350){
var statearr_18515_18579 = state_18447__$1;
(statearr_18515_18579[(1)] = (19));

} else {
var statearr_18516_18580 = state_18447__$1;
(statearr_18516_18580[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (38))){
var inst_18426 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18517_18581 = state_18447__$1;
(statearr_18517_18581[(2)] = inst_18426);

(statearr_18517_18581[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (30))){
var state_18447__$1 = state_18447;
var statearr_18518_18582 = state_18447__$1;
(statearr_18518_18582[(2)] = null);

(statearr_18518_18582[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (10))){
var inst_18331 = (state_18447[(15)]);
var inst_18329 = (state_18447[(17)]);
var inst_18337 = cljs.core._nth.call(null,inst_18329,inst_18331);
var inst_18338 = cljs.core.nth.call(null,inst_18337,(0),null);
var inst_18339 = cljs.core.nth.call(null,inst_18337,(1),null);
var state_18447__$1 = (function (){var statearr_18519 = state_18447;
(statearr_18519[(26)] = inst_18338);

return statearr_18519;
})();
if(cljs.core.truth_(inst_18339)){
var statearr_18520_18583 = state_18447__$1;
(statearr_18520_18583[(1)] = (13));

} else {
var statearr_18521_18584 = state_18447__$1;
(statearr_18521_18584[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (18))){
var inst_18372 = (state_18447[(2)]);
var state_18447__$1 = state_18447;
var statearr_18522_18585 = state_18447__$1;
(statearr_18522_18585[(2)] = inst_18372);

(statearr_18522_18585[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (42))){
var state_18447__$1 = state_18447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18447__$1,(45),dchan);
} else {
if((state_val_18448 === (37))){
var inst_18406 = (state_18447[(25)]);
var inst_18415 = (state_18447[(23)]);
var inst_18319 = (state_18447[(12)]);
var inst_18415__$1 = cljs.core.first.call(null,inst_18406);
var inst_18416 = cljs.core.async.put_BANG_.call(null,inst_18415__$1,inst_18319,done);
var state_18447__$1 = (function (){var statearr_18523 = state_18447;
(statearr_18523[(23)] = inst_18415__$1);

return statearr_18523;
})();
if(cljs.core.truth_(inst_18416)){
var statearr_18524_18586 = state_18447__$1;
(statearr_18524_18586[(1)] = (39));

} else {
var statearr_18525_18587 = state_18447__$1;
(statearr_18525_18587[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18448 === (8))){
var inst_18330 = (state_18447[(14)]);
var inst_18331 = (state_18447[(15)]);
var inst_18333 = (inst_18331 < inst_18330);
var inst_18334 = inst_18333;
var state_18447__$1 = state_18447;
if(cljs.core.truth_(inst_18334)){
var statearr_18526_18588 = state_18447__$1;
(statearr_18526_18588[(1)] = (10));

} else {
var statearr_18527_18589 = state_18447__$1;
(statearr_18527_18589[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18535,cs,m,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___18535,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8251__auto__ = null;
var cljs$core$async$mult_$_state_machine__8251__auto____0 = (function (){
var statearr_18531 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18531[(0)] = cljs$core$async$mult_$_state_machine__8251__auto__);

(statearr_18531[(1)] = (1));

return statearr_18531;
});
var cljs$core$async$mult_$_state_machine__8251__auto____1 = (function (state_18447){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18447);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18532){if((e18532 instanceof Object)){
var ex__8254__auto__ = e18532;
var statearr_18533_18590 = state_18447;
(statearr_18533_18590[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18447);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18532;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18591 = state_18447;
state_18447 = G__18591;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8251__auto__ = function(state_18447){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8251__auto____1.call(this,state_18447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8251__auto____0;
cljs$core$async$mult_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8251__auto____1;
return cljs$core$async$mult_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18535,cs,m,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_18534 = f__8363__auto__.call(null);
(statearr_18534[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18535);

return statearr_18534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18535,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args18592 = [];
var len__5726__auto___18595 = arguments.length;
var i__5727__auto___18596 = (0);
while(true){
if((i__5727__auto___18596 < len__5726__auto___18595)){
args18592.push((arguments[i__5727__auto___18596]));

var G__18597 = (i__5727__auto___18596 + (1));
i__5727__auto___18596 = G__18597;
continue;
} else {
}
break;
}

var G__18594 = args18592.length;
switch (G__18594) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18592.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m);
} else {
var m__5324__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,state_map);
} else {
var m__5324__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__5323__auto__ = (((m == null))?null:m);
var m__5324__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,m,mode);
} else {
var m__5324__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5733__auto__ = [];
var len__5726__auto___18609 = arguments.length;
var i__5727__auto___18610 = (0);
while(true){
if((i__5727__auto___18610 < len__5726__auto___18609)){
args__5733__auto__.push((arguments[i__5727__auto___18610]));

var G__18611 = (i__5727__auto___18610 + (1));
i__5727__auto___18610 = G__18611;
continue;
} else {
}
break;
}

var argseq__5734__auto__ = ((((3) < args__5733__auto__.length))?(new cljs.core.IndexedSeq(args__5733__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5734__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18603){
var map__18604 = p__18603;
var map__18604__$1 = ((((!((map__18604 == null)))?((((map__18604.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18604.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18604):map__18604);
var opts = map__18604__$1;
var statearr_18606_18612 = state;
(statearr_18606_18612[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__18604,map__18604__$1,opts){
return (function (val){
var statearr_18607_18613 = state;
(statearr_18607_18613[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__18604,map__18604__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_18608_18614 = state;
(statearr_18608_18614[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18599){
var G__18600 = cljs.core.first.call(null,seq18599);
var seq18599__$1 = cljs.core.next.call(null,seq18599);
var G__18601 = cljs.core.first.call(null,seq18599__$1);
var seq18599__$2 = cljs.core.next.call(null,seq18599__$1);
var G__18602 = cljs.core.first.call(null,seq18599__$2);
var seq18599__$3 = cljs.core.next.call(null,seq18599__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18600,G__18601,G__18602,seq18599__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18778 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18778 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18779){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18779 = meta18779;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18780,meta18779__$1){
var self__ = this;
var _18780__$1 = this;
return (new cljs.core.async.t_cljs$core$async18778(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18779__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18780){
var self__ = this;
var _18780__$1 = this;
return self__.meta18779;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18779","meta18779",691131274,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18778.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18778.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18778";

cljs.core.async.t_cljs$core$async18778.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async18778");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18778 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18778(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18779){
return (new cljs.core.async.t_cljs$core$async18778(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18779));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18778(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___18941 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___18941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___18941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18878){
var state_val_18879 = (state_18878[(1)]);
if((state_val_18879 === (7))){
var inst_18796 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
var statearr_18880_18942 = state_18878__$1;
(statearr_18880_18942[(2)] = inst_18796);

(statearr_18880_18942[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (20))){
var inst_18808 = (state_18878[(7)]);
var state_18878__$1 = state_18878;
var statearr_18881_18943 = state_18878__$1;
(statearr_18881_18943[(2)] = inst_18808);

(statearr_18881_18943[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (27))){
var state_18878__$1 = state_18878;
var statearr_18882_18944 = state_18878__$1;
(statearr_18882_18944[(2)] = null);

(statearr_18882_18944[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (1))){
var inst_18784 = (state_18878[(8)]);
var inst_18784__$1 = calc_state.call(null);
var inst_18786 = (inst_18784__$1 == null);
var inst_18787 = cljs.core.not.call(null,inst_18786);
var state_18878__$1 = (function (){var statearr_18883 = state_18878;
(statearr_18883[(8)] = inst_18784__$1);

return statearr_18883;
})();
if(inst_18787){
var statearr_18884_18945 = state_18878__$1;
(statearr_18884_18945[(1)] = (2));

} else {
var statearr_18885_18946 = state_18878__$1;
(statearr_18885_18946[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (24))){
var inst_18852 = (state_18878[(9)]);
var inst_18838 = (state_18878[(10)]);
var inst_18831 = (state_18878[(11)]);
var inst_18852__$1 = inst_18831.call(null,inst_18838);
var state_18878__$1 = (function (){var statearr_18886 = state_18878;
(statearr_18886[(9)] = inst_18852__$1);

return statearr_18886;
})();
if(cljs.core.truth_(inst_18852__$1)){
var statearr_18887_18947 = state_18878__$1;
(statearr_18887_18947[(1)] = (29));

} else {
var statearr_18888_18948 = state_18878__$1;
(statearr_18888_18948[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (4))){
var inst_18799 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
if(cljs.core.truth_(inst_18799)){
var statearr_18889_18949 = state_18878__$1;
(statearr_18889_18949[(1)] = (8));

} else {
var statearr_18890_18950 = state_18878__$1;
(statearr_18890_18950[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (15))){
var inst_18825 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
if(cljs.core.truth_(inst_18825)){
var statearr_18891_18951 = state_18878__$1;
(statearr_18891_18951[(1)] = (19));

} else {
var statearr_18892_18952 = state_18878__$1;
(statearr_18892_18952[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (21))){
var inst_18830 = (state_18878[(12)]);
var inst_18830__$1 = (state_18878[(2)]);
var inst_18831 = cljs.core.get.call(null,inst_18830__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18832 = cljs.core.get.call(null,inst_18830__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18833 = cljs.core.get.call(null,inst_18830__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18878__$1 = (function (){var statearr_18893 = state_18878;
(statearr_18893[(12)] = inst_18830__$1);

(statearr_18893[(11)] = inst_18831);

(statearr_18893[(13)] = inst_18832);

return statearr_18893;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18878__$1,(22),inst_18833);
} else {
if((state_val_18879 === (31))){
var inst_18860 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
if(cljs.core.truth_(inst_18860)){
var statearr_18894_18953 = state_18878__$1;
(statearr_18894_18953[(1)] = (32));

} else {
var statearr_18895_18954 = state_18878__$1;
(statearr_18895_18954[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (32))){
var inst_18837 = (state_18878[(14)]);
var state_18878__$1 = state_18878;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18878__$1,(35),out,inst_18837);
} else {
if((state_val_18879 === (33))){
var inst_18830 = (state_18878[(12)]);
var inst_18808 = inst_18830;
var state_18878__$1 = (function (){var statearr_18896 = state_18878;
(statearr_18896[(7)] = inst_18808);

return statearr_18896;
})();
var statearr_18897_18955 = state_18878__$1;
(statearr_18897_18955[(2)] = null);

(statearr_18897_18955[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (13))){
var inst_18808 = (state_18878[(7)]);
var inst_18815 = inst_18808.cljs$lang$protocol_mask$partition0$;
var inst_18816 = (inst_18815 & (64));
var inst_18817 = inst_18808.cljs$core$ISeq$;
var inst_18818 = (inst_18816) || (inst_18817);
var state_18878__$1 = state_18878;
if(cljs.core.truth_(inst_18818)){
var statearr_18898_18956 = state_18878__$1;
(statearr_18898_18956[(1)] = (16));

} else {
var statearr_18899_18957 = state_18878__$1;
(statearr_18899_18957[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (22))){
var inst_18838 = (state_18878[(10)]);
var inst_18837 = (state_18878[(14)]);
var inst_18836 = (state_18878[(2)]);
var inst_18837__$1 = cljs.core.nth.call(null,inst_18836,(0),null);
var inst_18838__$1 = cljs.core.nth.call(null,inst_18836,(1),null);
var inst_18839 = (inst_18837__$1 == null);
var inst_18840 = cljs.core._EQ_.call(null,inst_18838__$1,change);
var inst_18841 = (inst_18839) || (inst_18840);
var state_18878__$1 = (function (){var statearr_18900 = state_18878;
(statearr_18900[(10)] = inst_18838__$1);

(statearr_18900[(14)] = inst_18837__$1);

return statearr_18900;
})();
if(cljs.core.truth_(inst_18841)){
var statearr_18901_18958 = state_18878__$1;
(statearr_18901_18958[(1)] = (23));

} else {
var statearr_18902_18959 = state_18878__$1;
(statearr_18902_18959[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (36))){
var inst_18830 = (state_18878[(12)]);
var inst_18808 = inst_18830;
var state_18878__$1 = (function (){var statearr_18903 = state_18878;
(statearr_18903[(7)] = inst_18808);

return statearr_18903;
})();
var statearr_18904_18960 = state_18878__$1;
(statearr_18904_18960[(2)] = null);

(statearr_18904_18960[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (29))){
var inst_18852 = (state_18878[(9)]);
var state_18878__$1 = state_18878;
var statearr_18905_18961 = state_18878__$1;
(statearr_18905_18961[(2)] = inst_18852);

(statearr_18905_18961[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (6))){
var state_18878__$1 = state_18878;
var statearr_18906_18962 = state_18878__$1;
(statearr_18906_18962[(2)] = false);

(statearr_18906_18962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (28))){
var inst_18848 = (state_18878[(2)]);
var inst_18849 = calc_state.call(null);
var inst_18808 = inst_18849;
var state_18878__$1 = (function (){var statearr_18907 = state_18878;
(statearr_18907[(15)] = inst_18848);

(statearr_18907[(7)] = inst_18808);

return statearr_18907;
})();
var statearr_18908_18963 = state_18878__$1;
(statearr_18908_18963[(2)] = null);

(statearr_18908_18963[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (25))){
var inst_18874 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
var statearr_18909_18964 = state_18878__$1;
(statearr_18909_18964[(2)] = inst_18874);

(statearr_18909_18964[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (34))){
var inst_18872 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
var statearr_18910_18965 = state_18878__$1;
(statearr_18910_18965[(2)] = inst_18872);

(statearr_18910_18965[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (17))){
var state_18878__$1 = state_18878;
var statearr_18911_18966 = state_18878__$1;
(statearr_18911_18966[(2)] = false);

(statearr_18911_18966[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (3))){
var state_18878__$1 = state_18878;
var statearr_18912_18967 = state_18878__$1;
(statearr_18912_18967[(2)] = false);

(statearr_18912_18967[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (12))){
var inst_18876 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18878__$1,inst_18876);
} else {
if((state_val_18879 === (2))){
var inst_18784 = (state_18878[(8)]);
var inst_18789 = inst_18784.cljs$lang$protocol_mask$partition0$;
var inst_18790 = (inst_18789 & (64));
var inst_18791 = inst_18784.cljs$core$ISeq$;
var inst_18792 = (inst_18790) || (inst_18791);
var state_18878__$1 = state_18878;
if(cljs.core.truth_(inst_18792)){
var statearr_18913_18968 = state_18878__$1;
(statearr_18913_18968[(1)] = (5));

} else {
var statearr_18914_18969 = state_18878__$1;
(statearr_18914_18969[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (23))){
var inst_18837 = (state_18878[(14)]);
var inst_18843 = (inst_18837 == null);
var state_18878__$1 = state_18878;
if(cljs.core.truth_(inst_18843)){
var statearr_18915_18970 = state_18878__$1;
(statearr_18915_18970[(1)] = (26));

} else {
var statearr_18916_18971 = state_18878__$1;
(statearr_18916_18971[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (35))){
var inst_18863 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
if(cljs.core.truth_(inst_18863)){
var statearr_18917_18972 = state_18878__$1;
(statearr_18917_18972[(1)] = (36));

} else {
var statearr_18918_18973 = state_18878__$1;
(statearr_18918_18973[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (19))){
var inst_18808 = (state_18878[(7)]);
var inst_18827 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18808);
var state_18878__$1 = state_18878;
var statearr_18919_18974 = state_18878__$1;
(statearr_18919_18974[(2)] = inst_18827);

(statearr_18919_18974[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (11))){
var inst_18808 = (state_18878[(7)]);
var inst_18812 = (inst_18808 == null);
var inst_18813 = cljs.core.not.call(null,inst_18812);
var state_18878__$1 = state_18878;
if(inst_18813){
var statearr_18920_18975 = state_18878__$1;
(statearr_18920_18975[(1)] = (13));

} else {
var statearr_18921_18976 = state_18878__$1;
(statearr_18921_18976[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (9))){
var inst_18784 = (state_18878[(8)]);
var state_18878__$1 = state_18878;
var statearr_18922_18977 = state_18878__$1;
(statearr_18922_18977[(2)] = inst_18784);

(statearr_18922_18977[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (5))){
var state_18878__$1 = state_18878;
var statearr_18923_18978 = state_18878__$1;
(statearr_18923_18978[(2)] = true);

(statearr_18923_18978[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (14))){
var state_18878__$1 = state_18878;
var statearr_18924_18979 = state_18878__$1;
(statearr_18924_18979[(2)] = false);

(statearr_18924_18979[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (26))){
var inst_18838 = (state_18878[(10)]);
var inst_18845 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18838);
var state_18878__$1 = state_18878;
var statearr_18925_18980 = state_18878__$1;
(statearr_18925_18980[(2)] = inst_18845);

(statearr_18925_18980[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (16))){
var state_18878__$1 = state_18878;
var statearr_18926_18981 = state_18878__$1;
(statearr_18926_18981[(2)] = true);

(statearr_18926_18981[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (38))){
var inst_18868 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
var statearr_18927_18982 = state_18878__$1;
(statearr_18927_18982[(2)] = inst_18868);

(statearr_18927_18982[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (30))){
var inst_18838 = (state_18878[(10)]);
var inst_18831 = (state_18878[(11)]);
var inst_18832 = (state_18878[(13)]);
var inst_18855 = cljs.core.empty_QMARK_.call(null,inst_18831);
var inst_18856 = inst_18832.call(null,inst_18838);
var inst_18857 = cljs.core.not.call(null,inst_18856);
var inst_18858 = (inst_18855) && (inst_18857);
var state_18878__$1 = state_18878;
var statearr_18928_18983 = state_18878__$1;
(statearr_18928_18983[(2)] = inst_18858);

(statearr_18928_18983[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (10))){
var inst_18784 = (state_18878[(8)]);
var inst_18804 = (state_18878[(2)]);
var inst_18805 = cljs.core.get.call(null,inst_18804,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18806 = cljs.core.get.call(null,inst_18804,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18807 = cljs.core.get.call(null,inst_18804,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18808 = inst_18784;
var state_18878__$1 = (function (){var statearr_18929 = state_18878;
(statearr_18929[(16)] = inst_18805);

(statearr_18929[(17)] = inst_18806);

(statearr_18929[(18)] = inst_18807);

(statearr_18929[(7)] = inst_18808);

return statearr_18929;
})();
var statearr_18930_18984 = state_18878__$1;
(statearr_18930_18984[(2)] = null);

(statearr_18930_18984[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (18))){
var inst_18822 = (state_18878[(2)]);
var state_18878__$1 = state_18878;
var statearr_18931_18985 = state_18878__$1;
(statearr_18931_18985[(2)] = inst_18822);

(statearr_18931_18985[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (37))){
var state_18878__$1 = state_18878;
var statearr_18932_18986 = state_18878__$1;
(statearr_18932_18986[(2)] = null);

(statearr_18932_18986[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18879 === (8))){
var inst_18784 = (state_18878[(8)]);
var inst_18801 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18784);
var state_18878__$1 = state_18878;
var statearr_18933_18987 = state_18878__$1;
(statearr_18933_18987[(2)] = inst_18801);

(statearr_18933_18987[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___18941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8250__auto__,c__8362__auto___18941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8251__auto__ = null;
var cljs$core$async$mix_$_state_machine__8251__auto____0 = (function (){
var statearr_18937 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18937[(0)] = cljs$core$async$mix_$_state_machine__8251__auto__);

(statearr_18937[(1)] = (1));

return statearr_18937;
});
var cljs$core$async$mix_$_state_machine__8251__auto____1 = (function (state_18878){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_18878);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e18938){if((e18938 instanceof Object)){
var ex__8254__auto__ = e18938;
var statearr_18939_18988 = state_18878;
(statearr_18939_18988[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18878);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18938;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18989 = state_18878;
state_18878 = G__18989;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8251__auto__ = function(state_18878){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8251__auto____1.call(this,state_18878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8251__auto____0;
cljs$core$async$mix_$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8251__auto____1;
return cljs$core$async$mix_$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___18941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8364__auto__ = (function (){var statearr_18940 = f__8363__auto__.call(null);
(statearr_18940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___18941);

return statearr_18940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___18941,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5324__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v,ch);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args18990 = [];
var len__5726__auto___18993 = arguments.length;
var i__5727__auto___18994 = (0);
while(true){
if((i__5727__auto___18994 < len__5726__auto___18993)){
args18990.push((arguments[i__5727__auto___18994]));

var G__18995 = (i__5727__auto___18994 + (1));
i__5727__auto___18994 = G__18995;
continue;
} else {
}
break;
}

var G__18992 = args18990.length;
switch (G__18992) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18990.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__5323__auto__ = (((p == null))?null:p);
var m__5324__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5323__auto__)]);
if(!((m__5324__auto__ == null))){
return m__5324__auto__.call(null,p,v);
} else {
var m__5324__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__5324__auto____$1 == null))){
return m__5324__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args18998 = [];
var len__5726__auto___19123 = arguments.length;
var i__5727__auto___19124 = (0);
while(true){
if((i__5727__auto___19124 < len__5726__auto___19123)){
args18998.push((arguments[i__5727__auto___19124]));

var G__19125 = (i__5727__auto___19124 + (1));
i__5727__auto___19124 = G__19125;
continue;
} else {
}
break;
}

var G__19000 = args18998.length;
switch (G__19000) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18998.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4668__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4668__auto__)){
return or__4668__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4668__auto__,mults){
return (function (p1__18997_SHARP_){
if(cljs.core.truth_(p1__18997_SHARP_.call(null,topic))){
return p1__18997_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__18997_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4668__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19001 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19001 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19002){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19002 = meta19002;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19003,meta19002__$1){
var self__ = this;
var _19003__$1 = this;
return (new cljs.core.async.t_cljs$core$async19001(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19002__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19003){
var self__ = this;
var _19003__$1 = this;
return self__.meta19002;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19001.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19001.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta19002","meta19002",-811778135,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19001.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19001.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19001";

cljs.core.async.t_cljs$core$async19001.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19001");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19001 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19001(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19002){
return (new cljs.core.async.t_cljs$core$async19001(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19002));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19001(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8362__auto___19127 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19127,mults,ensure_mult,p){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19127,mults,ensure_mult,p){
return (function (state_19075){
var state_val_19076 = (state_19075[(1)]);
if((state_val_19076 === (7))){
var inst_19071 = (state_19075[(2)]);
var state_19075__$1 = state_19075;
var statearr_19077_19128 = state_19075__$1;
(statearr_19077_19128[(2)] = inst_19071);

(statearr_19077_19128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (20))){
var state_19075__$1 = state_19075;
var statearr_19078_19129 = state_19075__$1;
(statearr_19078_19129[(2)] = null);

(statearr_19078_19129[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (1))){
var state_19075__$1 = state_19075;
var statearr_19079_19130 = state_19075__$1;
(statearr_19079_19130[(2)] = null);

(statearr_19079_19130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (24))){
var inst_19054 = (state_19075[(7)]);
var inst_19063 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_19054);
var state_19075__$1 = state_19075;
var statearr_19080_19131 = state_19075__$1;
(statearr_19080_19131[(2)] = inst_19063);

(statearr_19080_19131[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (4))){
var inst_19006 = (state_19075[(8)]);
var inst_19006__$1 = (state_19075[(2)]);
var inst_19007 = (inst_19006__$1 == null);
var state_19075__$1 = (function (){var statearr_19081 = state_19075;
(statearr_19081[(8)] = inst_19006__$1);

return statearr_19081;
})();
if(cljs.core.truth_(inst_19007)){
var statearr_19082_19132 = state_19075__$1;
(statearr_19082_19132[(1)] = (5));

} else {
var statearr_19083_19133 = state_19075__$1;
(statearr_19083_19133[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (15))){
var inst_19048 = (state_19075[(2)]);
var state_19075__$1 = state_19075;
var statearr_19084_19134 = state_19075__$1;
(statearr_19084_19134[(2)] = inst_19048);

(statearr_19084_19134[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (21))){
var inst_19068 = (state_19075[(2)]);
var state_19075__$1 = (function (){var statearr_19085 = state_19075;
(statearr_19085[(9)] = inst_19068);

return statearr_19085;
})();
var statearr_19086_19135 = state_19075__$1;
(statearr_19086_19135[(2)] = null);

(statearr_19086_19135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (13))){
var inst_19030 = (state_19075[(10)]);
var inst_19032 = cljs.core.chunked_seq_QMARK_.call(null,inst_19030);
var state_19075__$1 = state_19075;
if(inst_19032){
var statearr_19087_19136 = state_19075__$1;
(statearr_19087_19136[(1)] = (16));

} else {
var statearr_19088_19137 = state_19075__$1;
(statearr_19088_19137[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (22))){
var inst_19060 = (state_19075[(2)]);
var state_19075__$1 = state_19075;
if(cljs.core.truth_(inst_19060)){
var statearr_19089_19138 = state_19075__$1;
(statearr_19089_19138[(1)] = (23));

} else {
var statearr_19090_19139 = state_19075__$1;
(statearr_19090_19139[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (6))){
var inst_19054 = (state_19075[(7)]);
var inst_19056 = (state_19075[(11)]);
var inst_19006 = (state_19075[(8)]);
var inst_19054__$1 = topic_fn.call(null,inst_19006);
var inst_19055 = cljs.core.deref.call(null,mults);
var inst_19056__$1 = cljs.core.get.call(null,inst_19055,inst_19054__$1);
var state_19075__$1 = (function (){var statearr_19091 = state_19075;
(statearr_19091[(7)] = inst_19054__$1);

(statearr_19091[(11)] = inst_19056__$1);

return statearr_19091;
})();
if(cljs.core.truth_(inst_19056__$1)){
var statearr_19092_19140 = state_19075__$1;
(statearr_19092_19140[(1)] = (19));

} else {
var statearr_19093_19141 = state_19075__$1;
(statearr_19093_19141[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (25))){
var inst_19065 = (state_19075[(2)]);
var state_19075__$1 = state_19075;
var statearr_19094_19142 = state_19075__$1;
(statearr_19094_19142[(2)] = inst_19065);

(statearr_19094_19142[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (17))){
var inst_19030 = (state_19075[(10)]);
var inst_19039 = cljs.core.first.call(null,inst_19030);
var inst_19040 = cljs.core.async.muxch_STAR_.call(null,inst_19039);
var inst_19041 = cljs.core.async.close_BANG_.call(null,inst_19040);
var inst_19042 = cljs.core.next.call(null,inst_19030);
var inst_19016 = inst_19042;
var inst_19017 = null;
var inst_19018 = (0);
var inst_19019 = (0);
var state_19075__$1 = (function (){var statearr_19095 = state_19075;
(statearr_19095[(12)] = inst_19017);

(statearr_19095[(13)] = inst_19019);

(statearr_19095[(14)] = inst_19016);

(statearr_19095[(15)] = inst_19041);

(statearr_19095[(16)] = inst_19018);

return statearr_19095;
})();
var statearr_19096_19143 = state_19075__$1;
(statearr_19096_19143[(2)] = null);

(statearr_19096_19143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (3))){
var inst_19073 = (state_19075[(2)]);
var state_19075__$1 = state_19075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19075__$1,inst_19073);
} else {
if((state_val_19076 === (12))){
var inst_19050 = (state_19075[(2)]);
var state_19075__$1 = state_19075;
var statearr_19097_19144 = state_19075__$1;
(statearr_19097_19144[(2)] = inst_19050);

(statearr_19097_19144[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (2))){
var state_19075__$1 = state_19075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19075__$1,(4),ch);
} else {
if((state_val_19076 === (23))){
var state_19075__$1 = state_19075;
var statearr_19098_19145 = state_19075__$1;
(statearr_19098_19145[(2)] = null);

(statearr_19098_19145[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (19))){
var inst_19056 = (state_19075[(11)]);
var inst_19006 = (state_19075[(8)]);
var inst_19058 = cljs.core.async.muxch_STAR_.call(null,inst_19056);
var state_19075__$1 = state_19075;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19075__$1,(22),inst_19058,inst_19006);
} else {
if((state_val_19076 === (11))){
var inst_19016 = (state_19075[(14)]);
var inst_19030 = (state_19075[(10)]);
var inst_19030__$1 = cljs.core.seq.call(null,inst_19016);
var state_19075__$1 = (function (){var statearr_19099 = state_19075;
(statearr_19099[(10)] = inst_19030__$1);

return statearr_19099;
})();
if(inst_19030__$1){
var statearr_19100_19146 = state_19075__$1;
(statearr_19100_19146[(1)] = (13));

} else {
var statearr_19101_19147 = state_19075__$1;
(statearr_19101_19147[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (9))){
var inst_19052 = (state_19075[(2)]);
var state_19075__$1 = state_19075;
var statearr_19102_19148 = state_19075__$1;
(statearr_19102_19148[(2)] = inst_19052);

(statearr_19102_19148[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (5))){
var inst_19013 = cljs.core.deref.call(null,mults);
var inst_19014 = cljs.core.vals.call(null,inst_19013);
var inst_19015 = cljs.core.seq.call(null,inst_19014);
var inst_19016 = inst_19015;
var inst_19017 = null;
var inst_19018 = (0);
var inst_19019 = (0);
var state_19075__$1 = (function (){var statearr_19103 = state_19075;
(statearr_19103[(12)] = inst_19017);

(statearr_19103[(13)] = inst_19019);

(statearr_19103[(14)] = inst_19016);

(statearr_19103[(16)] = inst_19018);

return statearr_19103;
})();
var statearr_19104_19149 = state_19075__$1;
(statearr_19104_19149[(2)] = null);

(statearr_19104_19149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (14))){
var state_19075__$1 = state_19075;
var statearr_19108_19150 = state_19075__$1;
(statearr_19108_19150[(2)] = null);

(statearr_19108_19150[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (16))){
var inst_19030 = (state_19075[(10)]);
var inst_19034 = cljs.core.chunk_first.call(null,inst_19030);
var inst_19035 = cljs.core.chunk_rest.call(null,inst_19030);
var inst_19036 = cljs.core.count.call(null,inst_19034);
var inst_19016 = inst_19035;
var inst_19017 = inst_19034;
var inst_19018 = inst_19036;
var inst_19019 = (0);
var state_19075__$1 = (function (){var statearr_19109 = state_19075;
(statearr_19109[(12)] = inst_19017);

(statearr_19109[(13)] = inst_19019);

(statearr_19109[(14)] = inst_19016);

(statearr_19109[(16)] = inst_19018);

return statearr_19109;
})();
var statearr_19110_19151 = state_19075__$1;
(statearr_19110_19151[(2)] = null);

(statearr_19110_19151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (10))){
var inst_19017 = (state_19075[(12)]);
var inst_19019 = (state_19075[(13)]);
var inst_19016 = (state_19075[(14)]);
var inst_19018 = (state_19075[(16)]);
var inst_19024 = cljs.core._nth.call(null,inst_19017,inst_19019);
var inst_19025 = cljs.core.async.muxch_STAR_.call(null,inst_19024);
var inst_19026 = cljs.core.async.close_BANG_.call(null,inst_19025);
var inst_19027 = (inst_19019 + (1));
var tmp19105 = inst_19017;
var tmp19106 = inst_19016;
var tmp19107 = inst_19018;
var inst_19016__$1 = tmp19106;
var inst_19017__$1 = tmp19105;
var inst_19018__$1 = tmp19107;
var inst_19019__$1 = inst_19027;
var state_19075__$1 = (function (){var statearr_19111 = state_19075;
(statearr_19111[(12)] = inst_19017__$1);

(statearr_19111[(13)] = inst_19019__$1);

(statearr_19111[(14)] = inst_19016__$1);

(statearr_19111[(16)] = inst_19018__$1);

(statearr_19111[(17)] = inst_19026);

return statearr_19111;
})();
var statearr_19112_19152 = state_19075__$1;
(statearr_19112_19152[(2)] = null);

(statearr_19112_19152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (18))){
var inst_19045 = (state_19075[(2)]);
var state_19075__$1 = state_19075;
var statearr_19113_19153 = state_19075__$1;
(statearr_19113_19153[(2)] = inst_19045);

(statearr_19113_19153[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19076 === (8))){
var inst_19019 = (state_19075[(13)]);
var inst_19018 = (state_19075[(16)]);
var inst_19021 = (inst_19019 < inst_19018);
var inst_19022 = inst_19021;
var state_19075__$1 = state_19075;
if(cljs.core.truth_(inst_19022)){
var statearr_19114_19154 = state_19075__$1;
(statearr_19114_19154[(1)] = (10));

} else {
var statearr_19115_19155 = state_19075__$1;
(statearr_19115_19155[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19127,mults,ensure_mult,p))
;
return ((function (switch__8250__auto__,c__8362__auto___19127,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19119 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19119[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19119[(1)] = (1));

return statearr_19119;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19075){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19120){if((e19120 instanceof Object)){
var ex__8254__auto__ = e19120;
var statearr_19121_19156 = state_19075;
(statearr_19121_19156[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19075);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19157 = state_19075;
state_19075 = G__19157;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19075){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19127,mults,ensure_mult,p))
})();
var state__8364__auto__ = (function (){var statearr_19122 = f__8363__auto__.call(null);
(statearr_19122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19127);

return statearr_19122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19127,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19158 = [];
var len__5726__auto___19161 = arguments.length;
var i__5727__auto___19162 = (0);
while(true){
if((i__5727__auto___19162 < len__5726__auto___19161)){
args19158.push((arguments[i__5727__auto___19162]));

var G__19163 = (i__5727__auto___19162 + (1));
i__5727__auto___19162 = G__19163;
continue;
} else {
}
break;
}

var G__19160 = args19158.length;
switch (G__19160) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19158.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19165 = [];
var len__5726__auto___19168 = arguments.length;
var i__5727__auto___19169 = (0);
while(true){
if((i__5727__auto___19169 < len__5726__auto___19168)){
args19165.push((arguments[i__5727__auto___19169]));

var G__19170 = (i__5727__auto___19169 + (1));
i__5727__auto___19169 = G__19170;
continue;
} else {
}
break;
}

var G__19167 = args19165.length;
switch (G__19167) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19165.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19172 = [];
var len__5726__auto___19243 = arguments.length;
var i__5727__auto___19244 = (0);
while(true){
if((i__5727__auto___19244 < len__5726__auto___19243)){
args19172.push((arguments[i__5727__auto___19244]));

var G__19245 = (i__5727__auto___19244 + (1));
i__5727__auto___19244 = G__19245;
continue;
} else {
}
break;
}

var G__19174 = args19172.length;
switch (G__19174) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19172.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8362__auto___19247 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19247,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19247,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19213){
var state_val_19214 = (state_19213[(1)]);
if((state_val_19214 === (7))){
var state_19213__$1 = state_19213;
var statearr_19215_19248 = state_19213__$1;
(statearr_19215_19248[(2)] = null);

(statearr_19215_19248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (1))){
var state_19213__$1 = state_19213;
var statearr_19216_19249 = state_19213__$1;
(statearr_19216_19249[(2)] = null);

(statearr_19216_19249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (4))){
var inst_19177 = (state_19213[(7)]);
var inst_19179 = (inst_19177 < cnt);
var state_19213__$1 = state_19213;
if(cljs.core.truth_(inst_19179)){
var statearr_19217_19250 = state_19213__$1;
(statearr_19217_19250[(1)] = (6));

} else {
var statearr_19218_19251 = state_19213__$1;
(statearr_19218_19251[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (15))){
var inst_19209 = (state_19213[(2)]);
var state_19213__$1 = state_19213;
var statearr_19219_19252 = state_19213__$1;
(statearr_19219_19252[(2)] = inst_19209);

(statearr_19219_19252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (13))){
var inst_19202 = cljs.core.async.close_BANG_.call(null,out);
var state_19213__$1 = state_19213;
var statearr_19220_19253 = state_19213__$1;
(statearr_19220_19253[(2)] = inst_19202);

(statearr_19220_19253[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (6))){
var state_19213__$1 = state_19213;
var statearr_19221_19254 = state_19213__$1;
(statearr_19221_19254[(2)] = null);

(statearr_19221_19254[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (3))){
var inst_19211 = (state_19213[(2)]);
var state_19213__$1 = state_19213;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19213__$1,inst_19211);
} else {
if((state_val_19214 === (12))){
var inst_19199 = (state_19213[(8)]);
var inst_19199__$1 = (state_19213[(2)]);
var inst_19200 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_19199__$1);
var state_19213__$1 = (function (){var statearr_19222 = state_19213;
(statearr_19222[(8)] = inst_19199__$1);

return statearr_19222;
})();
if(cljs.core.truth_(inst_19200)){
var statearr_19223_19255 = state_19213__$1;
(statearr_19223_19255[(1)] = (13));

} else {
var statearr_19224_19256 = state_19213__$1;
(statearr_19224_19256[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (2))){
var inst_19176 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_19177 = (0);
var state_19213__$1 = (function (){var statearr_19225 = state_19213;
(statearr_19225[(7)] = inst_19177);

(statearr_19225[(9)] = inst_19176);

return statearr_19225;
})();
var statearr_19226_19257 = state_19213__$1;
(statearr_19226_19257[(2)] = null);

(statearr_19226_19257[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (11))){
var inst_19177 = (state_19213[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_19213,(10),Object,null,(9));
var inst_19186 = chs__$1.call(null,inst_19177);
var inst_19187 = done.call(null,inst_19177);
var inst_19188 = cljs.core.async.take_BANG_.call(null,inst_19186,inst_19187);
var state_19213__$1 = state_19213;
var statearr_19227_19258 = state_19213__$1;
(statearr_19227_19258[(2)] = inst_19188);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19213__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (9))){
var inst_19177 = (state_19213[(7)]);
var inst_19190 = (state_19213[(2)]);
var inst_19191 = (inst_19177 + (1));
var inst_19177__$1 = inst_19191;
var state_19213__$1 = (function (){var statearr_19228 = state_19213;
(statearr_19228[(7)] = inst_19177__$1);

(statearr_19228[(10)] = inst_19190);

return statearr_19228;
})();
var statearr_19229_19259 = state_19213__$1;
(statearr_19229_19259[(2)] = null);

(statearr_19229_19259[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (5))){
var inst_19197 = (state_19213[(2)]);
var state_19213__$1 = (function (){var statearr_19230 = state_19213;
(statearr_19230[(11)] = inst_19197);

return statearr_19230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19213__$1,(12),dchan);
} else {
if((state_val_19214 === (14))){
var inst_19199 = (state_19213[(8)]);
var inst_19204 = cljs.core.apply.call(null,f,inst_19199);
var state_19213__$1 = state_19213;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19213__$1,(16),out,inst_19204);
} else {
if((state_val_19214 === (16))){
var inst_19206 = (state_19213[(2)]);
var state_19213__$1 = (function (){var statearr_19231 = state_19213;
(statearr_19231[(12)] = inst_19206);

return statearr_19231;
})();
var statearr_19232_19260 = state_19213__$1;
(statearr_19232_19260[(2)] = null);

(statearr_19232_19260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (10))){
var inst_19181 = (state_19213[(2)]);
var inst_19182 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_19213__$1 = (function (){var statearr_19233 = state_19213;
(statearr_19233[(13)] = inst_19181);

return statearr_19233;
})();
var statearr_19234_19261 = state_19213__$1;
(statearr_19234_19261[(2)] = inst_19182);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19213__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19214 === (8))){
var inst_19195 = (state_19213[(2)]);
var state_19213__$1 = state_19213;
var statearr_19235_19262 = state_19213__$1;
(statearr_19235_19262[(2)] = inst_19195);

(statearr_19235_19262[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19247,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8250__auto__,c__8362__auto___19247,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19239 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19239[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19239[(1)] = (1));

return statearr_19239;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19213){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19213);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19240){if((e19240 instanceof Object)){
var ex__8254__auto__ = e19240;
var statearr_19241_19263 = state_19213;
(statearr_19241_19263[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19213);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19240;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19264 = state_19213;
state_19213 = G__19264;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19213){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19247,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8364__auto__ = (function (){var statearr_19242 = f__8363__auto__.call(null);
(statearr_19242[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19247);

return statearr_19242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19247,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args19266 = [];
var len__5726__auto___19322 = arguments.length;
var i__5727__auto___19323 = (0);
while(true){
if((i__5727__auto___19323 < len__5726__auto___19322)){
args19266.push((arguments[i__5727__auto___19323]));

var G__19324 = (i__5727__auto___19323 + (1));
i__5727__auto___19323 = G__19324;
continue;
} else {
}
break;
}

var G__19268 = args19266.length;
switch (G__19268) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19266.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19326 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19326,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19326,out){
return (function (state_19298){
var state_val_19299 = (state_19298[(1)]);
if((state_val_19299 === (7))){
var inst_19277 = (state_19298[(7)]);
var inst_19278 = (state_19298[(8)]);
var inst_19277__$1 = (state_19298[(2)]);
var inst_19278__$1 = cljs.core.nth.call(null,inst_19277__$1,(0),null);
var inst_19279 = cljs.core.nth.call(null,inst_19277__$1,(1),null);
var inst_19280 = (inst_19278__$1 == null);
var state_19298__$1 = (function (){var statearr_19300 = state_19298;
(statearr_19300[(7)] = inst_19277__$1);

(statearr_19300[(9)] = inst_19279);

(statearr_19300[(8)] = inst_19278__$1);

return statearr_19300;
})();
if(cljs.core.truth_(inst_19280)){
var statearr_19301_19327 = state_19298__$1;
(statearr_19301_19327[(1)] = (8));

} else {
var statearr_19302_19328 = state_19298__$1;
(statearr_19302_19328[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (1))){
var inst_19269 = cljs.core.vec.call(null,chs);
var inst_19270 = inst_19269;
var state_19298__$1 = (function (){var statearr_19303 = state_19298;
(statearr_19303[(10)] = inst_19270);

return statearr_19303;
})();
var statearr_19304_19329 = state_19298__$1;
(statearr_19304_19329[(2)] = null);

(statearr_19304_19329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (4))){
var inst_19270 = (state_19298[(10)]);
var state_19298__$1 = state_19298;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19298__$1,(7),inst_19270);
} else {
if((state_val_19299 === (6))){
var inst_19294 = (state_19298[(2)]);
var state_19298__$1 = state_19298;
var statearr_19305_19330 = state_19298__$1;
(statearr_19305_19330[(2)] = inst_19294);

(statearr_19305_19330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (3))){
var inst_19296 = (state_19298[(2)]);
var state_19298__$1 = state_19298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19298__$1,inst_19296);
} else {
if((state_val_19299 === (2))){
var inst_19270 = (state_19298[(10)]);
var inst_19272 = cljs.core.count.call(null,inst_19270);
var inst_19273 = (inst_19272 > (0));
var state_19298__$1 = state_19298;
if(cljs.core.truth_(inst_19273)){
var statearr_19307_19331 = state_19298__$1;
(statearr_19307_19331[(1)] = (4));

} else {
var statearr_19308_19332 = state_19298__$1;
(statearr_19308_19332[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (11))){
var inst_19270 = (state_19298[(10)]);
var inst_19287 = (state_19298[(2)]);
var tmp19306 = inst_19270;
var inst_19270__$1 = tmp19306;
var state_19298__$1 = (function (){var statearr_19309 = state_19298;
(statearr_19309[(11)] = inst_19287);

(statearr_19309[(10)] = inst_19270__$1);

return statearr_19309;
})();
var statearr_19310_19333 = state_19298__$1;
(statearr_19310_19333[(2)] = null);

(statearr_19310_19333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (9))){
var inst_19278 = (state_19298[(8)]);
var state_19298__$1 = state_19298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19298__$1,(11),out,inst_19278);
} else {
if((state_val_19299 === (5))){
var inst_19292 = cljs.core.async.close_BANG_.call(null,out);
var state_19298__$1 = state_19298;
var statearr_19311_19334 = state_19298__$1;
(statearr_19311_19334[(2)] = inst_19292);

(statearr_19311_19334[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (10))){
var inst_19290 = (state_19298[(2)]);
var state_19298__$1 = state_19298;
var statearr_19312_19335 = state_19298__$1;
(statearr_19312_19335[(2)] = inst_19290);

(statearr_19312_19335[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19299 === (8))){
var inst_19277 = (state_19298[(7)]);
var inst_19279 = (state_19298[(9)]);
var inst_19278 = (state_19298[(8)]);
var inst_19270 = (state_19298[(10)]);
var inst_19282 = (function (){var cs = inst_19270;
var vec__19275 = inst_19277;
var v = inst_19278;
var c = inst_19279;
return ((function (cs,vec__19275,v,c,inst_19277,inst_19279,inst_19278,inst_19270,state_val_19299,c__8362__auto___19326,out){
return (function (p1__19265_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__19265_SHARP_);
});
;})(cs,vec__19275,v,c,inst_19277,inst_19279,inst_19278,inst_19270,state_val_19299,c__8362__auto___19326,out))
})();
var inst_19283 = cljs.core.filterv.call(null,inst_19282,inst_19270);
var inst_19270__$1 = inst_19283;
var state_19298__$1 = (function (){var statearr_19313 = state_19298;
(statearr_19313[(10)] = inst_19270__$1);

return statearr_19313;
})();
var statearr_19314_19336 = state_19298__$1;
(statearr_19314_19336[(2)] = null);

(statearr_19314_19336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19326,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19326,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19318 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19318[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19318[(1)] = (1));

return statearr_19318;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19298){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19319){if((e19319 instanceof Object)){
var ex__8254__auto__ = e19319;
var statearr_19320_19337 = state_19298;
(statearr_19320_19337[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19319;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19338 = state_19298;
state_19298 = G__19338;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19298){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19326,out))
})();
var state__8364__auto__ = (function (){var statearr_19321 = f__8363__auto__.call(null);
(statearr_19321[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19326);

return statearr_19321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19326,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args19339 = [];
var len__5726__auto___19388 = arguments.length;
var i__5727__auto___19389 = (0);
while(true){
if((i__5727__auto___19389 < len__5726__auto___19388)){
args19339.push((arguments[i__5727__auto___19389]));

var G__19390 = (i__5727__auto___19389 + (1));
i__5727__auto___19389 = G__19390;
continue;
} else {
}
break;
}

var G__19341 = args19339.length;
switch (G__19341) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19339.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19392 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19392,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19392,out){
return (function (state_19365){
var state_val_19366 = (state_19365[(1)]);
if((state_val_19366 === (7))){
var inst_19347 = (state_19365[(7)]);
var inst_19347__$1 = (state_19365[(2)]);
var inst_19348 = (inst_19347__$1 == null);
var inst_19349 = cljs.core.not.call(null,inst_19348);
var state_19365__$1 = (function (){var statearr_19367 = state_19365;
(statearr_19367[(7)] = inst_19347__$1);

return statearr_19367;
})();
if(inst_19349){
var statearr_19368_19393 = state_19365__$1;
(statearr_19368_19393[(1)] = (8));

} else {
var statearr_19369_19394 = state_19365__$1;
(statearr_19369_19394[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19366 === (1))){
var inst_19342 = (0);
var state_19365__$1 = (function (){var statearr_19370 = state_19365;
(statearr_19370[(8)] = inst_19342);

return statearr_19370;
})();
var statearr_19371_19395 = state_19365__$1;
(statearr_19371_19395[(2)] = null);

(statearr_19371_19395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19366 === (4))){
var state_19365__$1 = state_19365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19365__$1,(7),ch);
} else {
if((state_val_19366 === (6))){
var inst_19360 = (state_19365[(2)]);
var state_19365__$1 = state_19365;
var statearr_19372_19396 = state_19365__$1;
(statearr_19372_19396[(2)] = inst_19360);

(statearr_19372_19396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19366 === (3))){
var inst_19362 = (state_19365[(2)]);
var inst_19363 = cljs.core.async.close_BANG_.call(null,out);
var state_19365__$1 = (function (){var statearr_19373 = state_19365;
(statearr_19373[(9)] = inst_19362);

return statearr_19373;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19365__$1,inst_19363);
} else {
if((state_val_19366 === (2))){
var inst_19342 = (state_19365[(8)]);
var inst_19344 = (inst_19342 < n);
var state_19365__$1 = state_19365;
if(cljs.core.truth_(inst_19344)){
var statearr_19374_19397 = state_19365__$1;
(statearr_19374_19397[(1)] = (4));

} else {
var statearr_19375_19398 = state_19365__$1;
(statearr_19375_19398[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19366 === (11))){
var inst_19342 = (state_19365[(8)]);
var inst_19352 = (state_19365[(2)]);
var inst_19353 = (inst_19342 + (1));
var inst_19342__$1 = inst_19353;
var state_19365__$1 = (function (){var statearr_19376 = state_19365;
(statearr_19376[(8)] = inst_19342__$1);

(statearr_19376[(10)] = inst_19352);

return statearr_19376;
})();
var statearr_19377_19399 = state_19365__$1;
(statearr_19377_19399[(2)] = null);

(statearr_19377_19399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19366 === (9))){
var state_19365__$1 = state_19365;
var statearr_19378_19400 = state_19365__$1;
(statearr_19378_19400[(2)] = null);

(statearr_19378_19400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19366 === (5))){
var state_19365__$1 = state_19365;
var statearr_19379_19401 = state_19365__$1;
(statearr_19379_19401[(2)] = null);

(statearr_19379_19401[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19366 === (10))){
var inst_19357 = (state_19365[(2)]);
var state_19365__$1 = state_19365;
var statearr_19380_19402 = state_19365__$1;
(statearr_19380_19402[(2)] = inst_19357);

(statearr_19380_19402[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19366 === (8))){
var inst_19347 = (state_19365[(7)]);
var state_19365__$1 = state_19365;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19365__$1,(11),out,inst_19347);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19392,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19392,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19384 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19384[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19384[(1)] = (1));

return statearr_19384;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19365){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19385){if((e19385 instanceof Object)){
var ex__8254__auto__ = e19385;
var statearr_19386_19403 = state_19365;
(statearr_19386_19403[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19365);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19404 = state_19365;
state_19365 = G__19404;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19365){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19392,out))
})();
var state__8364__auto__ = (function (){var statearr_19387 = f__8363__auto__.call(null);
(statearr_19387[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19392);

return statearr_19387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19392,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19412 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19412 = (function (map_LT_,f,ch,meta19413){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19413 = meta19413;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19414,meta19413__$1){
var self__ = this;
var _19414__$1 = this;
return (new cljs.core.async.t_cljs$core$async19412(self__.map_LT_,self__.f,self__.ch,meta19413__$1));
});

cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19414){
var self__ = this;
var _19414__$1 = this;
return self__.meta19413;
});

cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async19415 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19415 = (function (map_LT_,f,ch,meta19413,_,fn1,meta19416){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta19413 = meta19413;
this._ = _;
this.fn1 = fn1;
this.meta19416 = meta19416;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19415.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_19417,meta19416__$1){
var self__ = this;
var _19417__$1 = this;
return (new cljs.core.async.t_cljs$core$async19415(self__.map_LT_,self__.f,self__.ch,self__.meta19413,self__._,self__.fn1,meta19416__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async19415.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_19417){
var self__ = this;
var _19417__$1 = this;
return self__.meta19416;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19415.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async19415.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19415.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async19415.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__19405_SHARP_){
return f1.call(null,(((p1__19405_SHARP_ == null))?null:self__.f.call(null,p1__19405_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async19415.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19413","meta19413",83357223,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async19412","cljs.core.async/t_cljs$core$async19412",-1367151300,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta19416","meta19416",789353571,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async19415.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19415.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19415";

cljs.core.async.t_cljs$core$async19415.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19415");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async19415 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19415(map_LT___$1,f__$1,ch__$1,meta19413__$1,___$2,fn1__$1,meta19416){
return (new cljs.core.async.t_cljs$core$async19415(map_LT___$1,f__$1,ch__$1,meta19413__$1,___$2,fn1__$1,meta19416));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async19415(self__.map_LT_,self__.f,self__.ch,self__.meta19413,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4656__auto__ = ret;
if(cljs.core.truth_(and__4656__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__4656__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19412.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async19412.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19413","meta19413",83357223,null)], null);
});

cljs.core.async.t_cljs$core$async19412.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19412.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19412";

cljs.core.async.t_cljs$core$async19412.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19412");
});

cljs.core.async.__GT_t_cljs$core$async19412 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async19412(map_LT___$1,f__$1,ch__$1,meta19413){
return (new cljs.core.async.t_cljs$core$async19412(map_LT___$1,f__$1,ch__$1,meta19413));
});

}

return (new cljs.core.async.t_cljs$core$async19412(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async19421 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19421 = (function (map_GT_,f,ch,meta19422){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta19422 = meta19422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19423,meta19422__$1){
var self__ = this;
var _19423__$1 = this;
return (new cljs.core.async.t_cljs$core$async19421(self__.map_GT_,self__.f,self__.ch,meta19422__$1));
});

cljs.core.async.t_cljs$core$async19421.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19423){
var self__ = this;
var _19423__$1 = this;
return self__.meta19422;
});

cljs.core.async.t_cljs$core$async19421.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19421.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19421.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19421.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19421.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19421.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async19421.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19422","meta19422",204311393,null)], null);
});

cljs.core.async.t_cljs$core$async19421.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19421";

cljs.core.async.t_cljs$core$async19421.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19421");
});

cljs.core.async.__GT_t_cljs$core$async19421 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async19421(map_GT___$1,f__$1,ch__$1,meta19422){
return (new cljs.core.async.t_cljs$core$async19421(map_GT___$1,f__$1,ch__$1,meta19422));
});

}

return (new cljs.core.async.t_cljs$core$async19421(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async19427 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19427 = (function (filter_GT_,p,ch,meta19428){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta19428 = meta19428;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19429,meta19428__$1){
var self__ = this;
var _19429__$1 = this;
return (new cljs.core.async.t_cljs$core$async19427(self__.filter_GT_,self__.p,self__.ch,meta19428__$1));
});

cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19429){
var self__ = this;
var _19429__$1 = this;
return self__.meta19428;
});

cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async19427.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async19427.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta19428","meta19428",-81840705,null)], null);
});

cljs.core.async.t_cljs$core$async19427.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19427.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19427";

cljs.core.async.t_cljs$core$async19427.cljs$lang$ctorPrWriter = (function (this__5266__auto__,writer__5267__auto__,opt__5268__auto__){
return cljs.core._write.call(null,writer__5267__auto__,"cljs.core.async/t_cljs$core$async19427");
});

cljs.core.async.__GT_t_cljs$core$async19427 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async19427(filter_GT___$1,p__$1,ch__$1,meta19428){
return (new cljs.core.async.t_cljs$core$async19427(filter_GT___$1,p__$1,ch__$1,meta19428));
});

}

return (new cljs.core.async.t_cljs$core$async19427(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args19430 = [];
var len__5726__auto___19474 = arguments.length;
var i__5727__auto___19475 = (0);
while(true){
if((i__5727__auto___19475 < len__5726__auto___19474)){
args19430.push((arguments[i__5727__auto___19475]));

var G__19476 = (i__5727__auto___19475 + (1));
i__5727__auto___19475 = G__19476;
continue;
} else {
}
break;
}

var G__19432 = args19430.length;
switch (G__19432) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19430.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19478 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19478,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19478,out){
return (function (state_19453){
var state_val_19454 = (state_19453[(1)]);
if((state_val_19454 === (7))){
var inst_19449 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
var statearr_19455_19479 = state_19453__$1;
(statearr_19455_19479[(2)] = inst_19449);

(statearr_19455_19479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (1))){
var state_19453__$1 = state_19453;
var statearr_19456_19480 = state_19453__$1;
(statearr_19456_19480[(2)] = null);

(statearr_19456_19480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (4))){
var inst_19435 = (state_19453[(7)]);
var inst_19435__$1 = (state_19453[(2)]);
var inst_19436 = (inst_19435__$1 == null);
var state_19453__$1 = (function (){var statearr_19457 = state_19453;
(statearr_19457[(7)] = inst_19435__$1);

return statearr_19457;
})();
if(cljs.core.truth_(inst_19436)){
var statearr_19458_19481 = state_19453__$1;
(statearr_19458_19481[(1)] = (5));

} else {
var statearr_19459_19482 = state_19453__$1;
(statearr_19459_19482[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (6))){
var inst_19435 = (state_19453[(7)]);
var inst_19440 = p.call(null,inst_19435);
var state_19453__$1 = state_19453;
if(cljs.core.truth_(inst_19440)){
var statearr_19460_19483 = state_19453__$1;
(statearr_19460_19483[(1)] = (8));

} else {
var statearr_19461_19484 = state_19453__$1;
(statearr_19461_19484[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (3))){
var inst_19451 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19453__$1,inst_19451);
} else {
if((state_val_19454 === (2))){
var state_19453__$1 = state_19453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19453__$1,(4),ch);
} else {
if((state_val_19454 === (11))){
var inst_19443 = (state_19453[(2)]);
var state_19453__$1 = state_19453;
var statearr_19462_19485 = state_19453__$1;
(statearr_19462_19485[(2)] = inst_19443);

(statearr_19462_19485[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (9))){
var state_19453__$1 = state_19453;
var statearr_19463_19486 = state_19453__$1;
(statearr_19463_19486[(2)] = null);

(statearr_19463_19486[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (5))){
var inst_19438 = cljs.core.async.close_BANG_.call(null,out);
var state_19453__$1 = state_19453;
var statearr_19464_19487 = state_19453__$1;
(statearr_19464_19487[(2)] = inst_19438);

(statearr_19464_19487[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (10))){
var inst_19446 = (state_19453[(2)]);
var state_19453__$1 = (function (){var statearr_19465 = state_19453;
(statearr_19465[(8)] = inst_19446);

return statearr_19465;
})();
var statearr_19466_19488 = state_19453__$1;
(statearr_19466_19488[(2)] = null);

(statearr_19466_19488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19454 === (8))){
var inst_19435 = (state_19453[(7)]);
var state_19453__$1 = state_19453;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19453__$1,(11),out,inst_19435);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19478,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19478,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19470 = [null,null,null,null,null,null,null,null,null];
(statearr_19470[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19470[(1)] = (1));

return statearr_19470;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19453){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19453);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19471){if((e19471 instanceof Object)){
var ex__8254__auto__ = e19471;
var statearr_19472_19489 = state_19453;
(statearr_19472_19489[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19453);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19471;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19490 = state_19453;
state_19453 = G__19490;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19453){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19478,out))
})();
var state__8364__auto__ = (function (){var statearr_19473 = f__8363__auto__.call(null);
(statearr_19473[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19478);

return statearr_19473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19478,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args19491 = [];
var len__5726__auto___19494 = arguments.length;
var i__5727__auto___19495 = (0);
while(true){
if((i__5727__auto___19495 < len__5726__auto___19494)){
args19491.push((arguments[i__5727__auto___19495]));

var G__19496 = (i__5727__auto___19495 + (1));
i__5727__auto___19495 = G__19496;
continue;
} else {
}
break;
}

var G__19493 = args19491.length;
switch (G__19493) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19491.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8362__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto__){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto__){
return (function (state_19663){
var state_val_19664 = (state_19663[(1)]);
if((state_val_19664 === (7))){
var inst_19659 = (state_19663[(2)]);
var state_19663__$1 = state_19663;
var statearr_19665_19706 = state_19663__$1;
(statearr_19665_19706[(2)] = inst_19659);

(statearr_19665_19706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (20))){
var inst_19629 = (state_19663[(7)]);
var inst_19640 = (state_19663[(2)]);
var inst_19641 = cljs.core.next.call(null,inst_19629);
var inst_19615 = inst_19641;
var inst_19616 = null;
var inst_19617 = (0);
var inst_19618 = (0);
var state_19663__$1 = (function (){var statearr_19666 = state_19663;
(statearr_19666[(8)] = inst_19640);

(statearr_19666[(9)] = inst_19616);

(statearr_19666[(10)] = inst_19615);

(statearr_19666[(11)] = inst_19617);

(statearr_19666[(12)] = inst_19618);

return statearr_19666;
})();
var statearr_19667_19707 = state_19663__$1;
(statearr_19667_19707[(2)] = null);

(statearr_19667_19707[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (1))){
var state_19663__$1 = state_19663;
var statearr_19668_19708 = state_19663__$1;
(statearr_19668_19708[(2)] = null);

(statearr_19668_19708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (4))){
var inst_19604 = (state_19663[(13)]);
var inst_19604__$1 = (state_19663[(2)]);
var inst_19605 = (inst_19604__$1 == null);
var state_19663__$1 = (function (){var statearr_19669 = state_19663;
(statearr_19669[(13)] = inst_19604__$1);

return statearr_19669;
})();
if(cljs.core.truth_(inst_19605)){
var statearr_19670_19709 = state_19663__$1;
(statearr_19670_19709[(1)] = (5));

} else {
var statearr_19671_19710 = state_19663__$1;
(statearr_19671_19710[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (15))){
var state_19663__$1 = state_19663;
var statearr_19675_19711 = state_19663__$1;
(statearr_19675_19711[(2)] = null);

(statearr_19675_19711[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (21))){
var state_19663__$1 = state_19663;
var statearr_19676_19712 = state_19663__$1;
(statearr_19676_19712[(2)] = null);

(statearr_19676_19712[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (13))){
var inst_19616 = (state_19663[(9)]);
var inst_19615 = (state_19663[(10)]);
var inst_19617 = (state_19663[(11)]);
var inst_19618 = (state_19663[(12)]);
var inst_19625 = (state_19663[(2)]);
var inst_19626 = (inst_19618 + (1));
var tmp19672 = inst_19616;
var tmp19673 = inst_19615;
var tmp19674 = inst_19617;
var inst_19615__$1 = tmp19673;
var inst_19616__$1 = tmp19672;
var inst_19617__$1 = tmp19674;
var inst_19618__$1 = inst_19626;
var state_19663__$1 = (function (){var statearr_19677 = state_19663;
(statearr_19677[(9)] = inst_19616__$1);

(statearr_19677[(14)] = inst_19625);

(statearr_19677[(10)] = inst_19615__$1);

(statearr_19677[(11)] = inst_19617__$1);

(statearr_19677[(12)] = inst_19618__$1);

return statearr_19677;
})();
var statearr_19678_19713 = state_19663__$1;
(statearr_19678_19713[(2)] = null);

(statearr_19678_19713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (22))){
var state_19663__$1 = state_19663;
var statearr_19679_19714 = state_19663__$1;
(statearr_19679_19714[(2)] = null);

(statearr_19679_19714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (6))){
var inst_19604 = (state_19663[(13)]);
var inst_19613 = f.call(null,inst_19604);
var inst_19614 = cljs.core.seq.call(null,inst_19613);
var inst_19615 = inst_19614;
var inst_19616 = null;
var inst_19617 = (0);
var inst_19618 = (0);
var state_19663__$1 = (function (){var statearr_19680 = state_19663;
(statearr_19680[(9)] = inst_19616);

(statearr_19680[(10)] = inst_19615);

(statearr_19680[(11)] = inst_19617);

(statearr_19680[(12)] = inst_19618);

return statearr_19680;
})();
var statearr_19681_19715 = state_19663__$1;
(statearr_19681_19715[(2)] = null);

(statearr_19681_19715[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (17))){
var inst_19629 = (state_19663[(7)]);
var inst_19633 = cljs.core.chunk_first.call(null,inst_19629);
var inst_19634 = cljs.core.chunk_rest.call(null,inst_19629);
var inst_19635 = cljs.core.count.call(null,inst_19633);
var inst_19615 = inst_19634;
var inst_19616 = inst_19633;
var inst_19617 = inst_19635;
var inst_19618 = (0);
var state_19663__$1 = (function (){var statearr_19682 = state_19663;
(statearr_19682[(9)] = inst_19616);

(statearr_19682[(10)] = inst_19615);

(statearr_19682[(11)] = inst_19617);

(statearr_19682[(12)] = inst_19618);

return statearr_19682;
})();
var statearr_19683_19716 = state_19663__$1;
(statearr_19683_19716[(2)] = null);

(statearr_19683_19716[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (3))){
var inst_19661 = (state_19663[(2)]);
var state_19663__$1 = state_19663;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19663__$1,inst_19661);
} else {
if((state_val_19664 === (12))){
var inst_19649 = (state_19663[(2)]);
var state_19663__$1 = state_19663;
var statearr_19684_19717 = state_19663__$1;
(statearr_19684_19717[(2)] = inst_19649);

(statearr_19684_19717[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (2))){
var state_19663__$1 = state_19663;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19663__$1,(4),in$);
} else {
if((state_val_19664 === (23))){
var inst_19657 = (state_19663[(2)]);
var state_19663__$1 = state_19663;
var statearr_19685_19718 = state_19663__$1;
(statearr_19685_19718[(2)] = inst_19657);

(statearr_19685_19718[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (19))){
var inst_19644 = (state_19663[(2)]);
var state_19663__$1 = state_19663;
var statearr_19686_19719 = state_19663__$1;
(statearr_19686_19719[(2)] = inst_19644);

(statearr_19686_19719[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (11))){
var inst_19629 = (state_19663[(7)]);
var inst_19615 = (state_19663[(10)]);
var inst_19629__$1 = cljs.core.seq.call(null,inst_19615);
var state_19663__$1 = (function (){var statearr_19687 = state_19663;
(statearr_19687[(7)] = inst_19629__$1);

return statearr_19687;
})();
if(inst_19629__$1){
var statearr_19688_19720 = state_19663__$1;
(statearr_19688_19720[(1)] = (14));

} else {
var statearr_19689_19721 = state_19663__$1;
(statearr_19689_19721[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (9))){
var inst_19651 = (state_19663[(2)]);
var inst_19652 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_19663__$1 = (function (){var statearr_19690 = state_19663;
(statearr_19690[(15)] = inst_19651);

return statearr_19690;
})();
if(cljs.core.truth_(inst_19652)){
var statearr_19691_19722 = state_19663__$1;
(statearr_19691_19722[(1)] = (21));

} else {
var statearr_19692_19723 = state_19663__$1;
(statearr_19692_19723[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (5))){
var inst_19607 = cljs.core.async.close_BANG_.call(null,out);
var state_19663__$1 = state_19663;
var statearr_19693_19724 = state_19663__$1;
(statearr_19693_19724[(2)] = inst_19607);

(statearr_19693_19724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (14))){
var inst_19629 = (state_19663[(7)]);
var inst_19631 = cljs.core.chunked_seq_QMARK_.call(null,inst_19629);
var state_19663__$1 = state_19663;
if(inst_19631){
var statearr_19694_19725 = state_19663__$1;
(statearr_19694_19725[(1)] = (17));

} else {
var statearr_19695_19726 = state_19663__$1;
(statearr_19695_19726[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (16))){
var inst_19647 = (state_19663[(2)]);
var state_19663__$1 = state_19663;
var statearr_19696_19727 = state_19663__$1;
(statearr_19696_19727[(2)] = inst_19647);

(statearr_19696_19727[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19664 === (10))){
var inst_19616 = (state_19663[(9)]);
var inst_19618 = (state_19663[(12)]);
var inst_19623 = cljs.core._nth.call(null,inst_19616,inst_19618);
var state_19663__$1 = state_19663;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19663__$1,(13),out,inst_19623);
} else {
if((state_val_19664 === (18))){
var inst_19629 = (state_19663[(7)]);
var inst_19638 = cljs.core.first.call(null,inst_19629);
var state_19663__$1 = state_19663;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19663__$1,(20),out,inst_19638);
} else {
if((state_val_19664 === (8))){
var inst_19617 = (state_19663[(11)]);
var inst_19618 = (state_19663[(12)]);
var inst_19620 = (inst_19618 < inst_19617);
var inst_19621 = inst_19620;
var state_19663__$1 = state_19663;
if(cljs.core.truth_(inst_19621)){
var statearr_19697_19728 = state_19663__$1;
(statearr_19697_19728[(1)] = (10));

} else {
var statearr_19698_19729 = state_19663__$1;
(statearr_19698_19729[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto__))
;
return ((function (switch__8250__auto__,c__8362__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0 = (function (){
var statearr_19702 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19702[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__);

(statearr_19702[(1)] = (1));

return statearr_19702;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1 = (function (state_19663){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19663);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19703){if((e19703 instanceof Object)){
var ex__8254__auto__ = e19703;
var statearr_19704_19730 = state_19663;
(statearr_19704_19730[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19663);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19703;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19731 = state_19663;
state_19663 = G__19731;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__ = function(state_19663){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1.call(this,state_19663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8251__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto__))
})();
var state__8364__auto__ = (function (){var statearr_19705 = f__8363__auto__.call(null);
(statearr_19705[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto__);

return statearr_19705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto__))
);

return c__8362__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args19732 = [];
var len__5726__auto___19735 = arguments.length;
var i__5727__auto___19736 = (0);
while(true){
if((i__5727__auto___19736 < len__5726__auto___19735)){
args19732.push((arguments[i__5727__auto___19736]));

var G__19737 = (i__5727__auto___19736 + (1));
i__5727__auto___19736 = G__19737;
continue;
} else {
}
break;
}

var G__19734 = args19732.length;
switch (G__19734) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19732.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19739 = [];
var len__5726__auto___19742 = arguments.length;
var i__5727__auto___19743 = (0);
while(true){
if((i__5727__auto___19743 < len__5726__auto___19742)){
args19739.push((arguments[i__5727__auto___19743]));

var G__19744 = (i__5727__auto___19743 + (1));
i__5727__auto___19743 = G__19744;
continue;
} else {
}
break;
}

var G__19741 = args19739.length;
switch (G__19741) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19739.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19746 = [];
var len__5726__auto___19797 = arguments.length;
var i__5727__auto___19798 = (0);
while(true){
if((i__5727__auto___19798 < len__5726__auto___19797)){
args19746.push((arguments[i__5727__auto___19798]));

var G__19799 = (i__5727__auto___19798 + (1));
i__5727__auto___19798 = G__19799;
continue;
} else {
}
break;
}

var G__19748 = args19746.length;
switch (G__19748) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19746.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19801 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19801,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19801,out){
return (function (state_19772){
var state_val_19773 = (state_19772[(1)]);
if((state_val_19773 === (7))){
var inst_19767 = (state_19772[(2)]);
var state_19772__$1 = state_19772;
var statearr_19774_19802 = state_19772__$1;
(statearr_19774_19802[(2)] = inst_19767);

(statearr_19774_19802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19773 === (1))){
var inst_19749 = null;
var state_19772__$1 = (function (){var statearr_19775 = state_19772;
(statearr_19775[(7)] = inst_19749);

return statearr_19775;
})();
var statearr_19776_19803 = state_19772__$1;
(statearr_19776_19803[(2)] = null);

(statearr_19776_19803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19773 === (4))){
var inst_19752 = (state_19772[(8)]);
var inst_19752__$1 = (state_19772[(2)]);
var inst_19753 = (inst_19752__$1 == null);
var inst_19754 = cljs.core.not.call(null,inst_19753);
var state_19772__$1 = (function (){var statearr_19777 = state_19772;
(statearr_19777[(8)] = inst_19752__$1);

return statearr_19777;
})();
if(inst_19754){
var statearr_19778_19804 = state_19772__$1;
(statearr_19778_19804[(1)] = (5));

} else {
var statearr_19779_19805 = state_19772__$1;
(statearr_19779_19805[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19773 === (6))){
var state_19772__$1 = state_19772;
var statearr_19780_19806 = state_19772__$1;
(statearr_19780_19806[(2)] = null);

(statearr_19780_19806[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19773 === (3))){
var inst_19769 = (state_19772[(2)]);
var inst_19770 = cljs.core.async.close_BANG_.call(null,out);
var state_19772__$1 = (function (){var statearr_19781 = state_19772;
(statearr_19781[(9)] = inst_19769);

return statearr_19781;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19772__$1,inst_19770);
} else {
if((state_val_19773 === (2))){
var state_19772__$1 = state_19772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19772__$1,(4),ch);
} else {
if((state_val_19773 === (11))){
var inst_19752 = (state_19772[(8)]);
var inst_19761 = (state_19772[(2)]);
var inst_19749 = inst_19752;
var state_19772__$1 = (function (){var statearr_19782 = state_19772;
(statearr_19782[(7)] = inst_19749);

(statearr_19782[(10)] = inst_19761);

return statearr_19782;
})();
var statearr_19783_19807 = state_19772__$1;
(statearr_19783_19807[(2)] = null);

(statearr_19783_19807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19773 === (9))){
var inst_19752 = (state_19772[(8)]);
var state_19772__$1 = state_19772;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19772__$1,(11),out,inst_19752);
} else {
if((state_val_19773 === (5))){
var inst_19749 = (state_19772[(7)]);
var inst_19752 = (state_19772[(8)]);
var inst_19756 = cljs.core._EQ_.call(null,inst_19752,inst_19749);
var state_19772__$1 = state_19772;
if(inst_19756){
var statearr_19785_19808 = state_19772__$1;
(statearr_19785_19808[(1)] = (8));

} else {
var statearr_19786_19809 = state_19772__$1;
(statearr_19786_19809[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19773 === (10))){
var inst_19764 = (state_19772[(2)]);
var state_19772__$1 = state_19772;
var statearr_19787_19810 = state_19772__$1;
(statearr_19787_19810[(2)] = inst_19764);

(statearr_19787_19810[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19773 === (8))){
var inst_19749 = (state_19772[(7)]);
var tmp19784 = inst_19749;
var inst_19749__$1 = tmp19784;
var state_19772__$1 = (function (){var statearr_19788 = state_19772;
(statearr_19788[(7)] = inst_19749__$1);

return statearr_19788;
})();
var statearr_19789_19811 = state_19772__$1;
(statearr_19789_19811[(2)] = null);

(statearr_19789_19811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19801,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19801,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19793 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19793[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19793[(1)] = (1));

return statearr_19793;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19772){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19794){if((e19794 instanceof Object)){
var ex__8254__auto__ = e19794;
var statearr_19795_19812 = state_19772;
(statearr_19795_19812[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19772);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19813 = state_19772;
state_19772 = G__19813;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19772){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19801,out))
})();
var state__8364__auto__ = (function (){var statearr_19796 = f__8363__auto__.call(null);
(statearr_19796[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19801);

return statearr_19796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19801,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19814 = [];
var len__5726__auto___19884 = arguments.length;
var i__5727__auto___19885 = (0);
while(true){
if((i__5727__auto___19885 < len__5726__auto___19884)){
args19814.push((arguments[i__5727__auto___19885]));

var G__19886 = (i__5727__auto___19885 + (1));
i__5727__auto___19885 = G__19886;
continue;
} else {
}
break;
}

var G__19816 = args19814.length;
switch (G__19816) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19814.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19888 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19888,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19888,out){
return (function (state_19854){
var state_val_19855 = (state_19854[(1)]);
if((state_val_19855 === (7))){
var inst_19850 = (state_19854[(2)]);
var state_19854__$1 = state_19854;
var statearr_19856_19889 = state_19854__$1;
(statearr_19856_19889[(2)] = inst_19850);

(statearr_19856_19889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (1))){
var inst_19817 = (new Array(n));
var inst_19818 = inst_19817;
var inst_19819 = (0);
var state_19854__$1 = (function (){var statearr_19857 = state_19854;
(statearr_19857[(7)] = inst_19818);

(statearr_19857[(8)] = inst_19819);

return statearr_19857;
})();
var statearr_19858_19890 = state_19854__$1;
(statearr_19858_19890[(2)] = null);

(statearr_19858_19890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (4))){
var inst_19822 = (state_19854[(9)]);
var inst_19822__$1 = (state_19854[(2)]);
var inst_19823 = (inst_19822__$1 == null);
var inst_19824 = cljs.core.not.call(null,inst_19823);
var state_19854__$1 = (function (){var statearr_19859 = state_19854;
(statearr_19859[(9)] = inst_19822__$1);

return statearr_19859;
})();
if(inst_19824){
var statearr_19860_19891 = state_19854__$1;
(statearr_19860_19891[(1)] = (5));

} else {
var statearr_19861_19892 = state_19854__$1;
(statearr_19861_19892[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (15))){
var inst_19844 = (state_19854[(2)]);
var state_19854__$1 = state_19854;
var statearr_19862_19893 = state_19854__$1;
(statearr_19862_19893[(2)] = inst_19844);

(statearr_19862_19893[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (13))){
var state_19854__$1 = state_19854;
var statearr_19863_19894 = state_19854__$1;
(statearr_19863_19894[(2)] = null);

(statearr_19863_19894[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (6))){
var inst_19819 = (state_19854[(8)]);
var inst_19840 = (inst_19819 > (0));
var state_19854__$1 = state_19854;
if(cljs.core.truth_(inst_19840)){
var statearr_19864_19895 = state_19854__$1;
(statearr_19864_19895[(1)] = (12));

} else {
var statearr_19865_19896 = state_19854__$1;
(statearr_19865_19896[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (3))){
var inst_19852 = (state_19854[(2)]);
var state_19854__$1 = state_19854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19854__$1,inst_19852);
} else {
if((state_val_19855 === (12))){
var inst_19818 = (state_19854[(7)]);
var inst_19842 = cljs.core.vec.call(null,inst_19818);
var state_19854__$1 = state_19854;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19854__$1,(15),out,inst_19842);
} else {
if((state_val_19855 === (2))){
var state_19854__$1 = state_19854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19854__$1,(4),ch);
} else {
if((state_val_19855 === (11))){
var inst_19834 = (state_19854[(2)]);
var inst_19835 = (new Array(n));
var inst_19818 = inst_19835;
var inst_19819 = (0);
var state_19854__$1 = (function (){var statearr_19866 = state_19854;
(statearr_19866[(7)] = inst_19818);

(statearr_19866[(10)] = inst_19834);

(statearr_19866[(8)] = inst_19819);

return statearr_19866;
})();
var statearr_19867_19897 = state_19854__$1;
(statearr_19867_19897[(2)] = null);

(statearr_19867_19897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (9))){
var inst_19818 = (state_19854[(7)]);
var inst_19832 = cljs.core.vec.call(null,inst_19818);
var state_19854__$1 = state_19854;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19854__$1,(11),out,inst_19832);
} else {
if((state_val_19855 === (5))){
var inst_19818 = (state_19854[(7)]);
var inst_19822 = (state_19854[(9)]);
var inst_19827 = (state_19854[(11)]);
var inst_19819 = (state_19854[(8)]);
var inst_19826 = (inst_19818[inst_19819] = inst_19822);
var inst_19827__$1 = (inst_19819 + (1));
var inst_19828 = (inst_19827__$1 < n);
var state_19854__$1 = (function (){var statearr_19868 = state_19854;
(statearr_19868[(12)] = inst_19826);

(statearr_19868[(11)] = inst_19827__$1);

return statearr_19868;
})();
if(cljs.core.truth_(inst_19828)){
var statearr_19869_19898 = state_19854__$1;
(statearr_19869_19898[(1)] = (8));

} else {
var statearr_19870_19899 = state_19854__$1;
(statearr_19870_19899[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (14))){
var inst_19847 = (state_19854[(2)]);
var inst_19848 = cljs.core.async.close_BANG_.call(null,out);
var state_19854__$1 = (function (){var statearr_19872 = state_19854;
(statearr_19872[(13)] = inst_19847);

return statearr_19872;
})();
var statearr_19873_19900 = state_19854__$1;
(statearr_19873_19900[(2)] = inst_19848);

(statearr_19873_19900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (10))){
var inst_19838 = (state_19854[(2)]);
var state_19854__$1 = state_19854;
var statearr_19874_19901 = state_19854__$1;
(statearr_19874_19901[(2)] = inst_19838);

(statearr_19874_19901[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19855 === (8))){
var inst_19818 = (state_19854[(7)]);
var inst_19827 = (state_19854[(11)]);
var tmp19871 = inst_19818;
var inst_19818__$1 = tmp19871;
var inst_19819 = inst_19827;
var state_19854__$1 = (function (){var statearr_19875 = state_19854;
(statearr_19875[(7)] = inst_19818__$1);

(statearr_19875[(8)] = inst_19819);

return statearr_19875;
})();
var statearr_19876_19902 = state_19854__$1;
(statearr_19876_19902[(2)] = null);

(statearr_19876_19902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19888,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19888,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19880 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19880[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19880[(1)] = (1));

return statearr_19880;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19854){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19881){if((e19881 instanceof Object)){
var ex__8254__auto__ = e19881;
var statearr_19882_19903 = state_19854;
(statearr_19882_19903[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19854);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19881;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19904 = state_19854;
state_19854 = G__19904;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19854){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19888,out))
})();
var state__8364__auto__ = (function (){var statearr_19883 = f__8363__auto__.call(null);
(statearr_19883[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19888);

return statearr_19883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19888,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19905 = [];
var len__5726__auto___19979 = arguments.length;
var i__5727__auto___19980 = (0);
while(true){
if((i__5727__auto___19980 < len__5726__auto___19979)){
args19905.push((arguments[i__5727__auto___19980]));

var G__19981 = (i__5727__auto___19980 + (1));
i__5727__auto___19980 = G__19981;
continue;
} else {
}
break;
}

var G__19907 = args19905.length;
switch (G__19907) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19905.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8362__auto___19983 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8362__auto___19983,out){
return (function (){
var f__8363__auto__ = (function (){var switch__8250__auto__ = ((function (c__8362__auto___19983,out){
return (function (state_19949){
var state_val_19950 = (state_19949[(1)]);
if((state_val_19950 === (7))){
var inst_19945 = (state_19949[(2)]);
var state_19949__$1 = state_19949;
var statearr_19951_19984 = state_19949__$1;
(statearr_19951_19984[(2)] = inst_19945);

(statearr_19951_19984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (1))){
var inst_19908 = [];
var inst_19909 = inst_19908;
var inst_19910 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19949__$1 = (function (){var statearr_19952 = state_19949;
(statearr_19952[(7)] = inst_19909);

(statearr_19952[(8)] = inst_19910);

return statearr_19952;
})();
var statearr_19953_19985 = state_19949__$1;
(statearr_19953_19985[(2)] = null);

(statearr_19953_19985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (4))){
var inst_19913 = (state_19949[(9)]);
var inst_19913__$1 = (state_19949[(2)]);
var inst_19914 = (inst_19913__$1 == null);
var inst_19915 = cljs.core.not.call(null,inst_19914);
var state_19949__$1 = (function (){var statearr_19954 = state_19949;
(statearr_19954[(9)] = inst_19913__$1);

return statearr_19954;
})();
if(inst_19915){
var statearr_19955_19986 = state_19949__$1;
(statearr_19955_19986[(1)] = (5));

} else {
var statearr_19956_19987 = state_19949__$1;
(statearr_19956_19987[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (15))){
var inst_19939 = (state_19949[(2)]);
var state_19949__$1 = state_19949;
var statearr_19957_19988 = state_19949__$1;
(statearr_19957_19988[(2)] = inst_19939);

(statearr_19957_19988[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (13))){
var state_19949__$1 = state_19949;
var statearr_19958_19989 = state_19949__$1;
(statearr_19958_19989[(2)] = null);

(statearr_19958_19989[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (6))){
var inst_19909 = (state_19949[(7)]);
var inst_19934 = inst_19909.length;
var inst_19935 = (inst_19934 > (0));
var state_19949__$1 = state_19949;
if(cljs.core.truth_(inst_19935)){
var statearr_19959_19990 = state_19949__$1;
(statearr_19959_19990[(1)] = (12));

} else {
var statearr_19960_19991 = state_19949__$1;
(statearr_19960_19991[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (3))){
var inst_19947 = (state_19949[(2)]);
var state_19949__$1 = state_19949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19949__$1,inst_19947);
} else {
if((state_val_19950 === (12))){
var inst_19909 = (state_19949[(7)]);
var inst_19937 = cljs.core.vec.call(null,inst_19909);
var state_19949__$1 = state_19949;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19949__$1,(15),out,inst_19937);
} else {
if((state_val_19950 === (2))){
var state_19949__$1 = state_19949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19949__$1,(4),ch);
} else {
if((state_val_19950 === (11))){
var inst_19913 = (state_19949[(9)]);
var inst_19917 = (state_19949[(10)]);
var inst_19927 = (state_19949[(2)]);
var inst_19928 = [];
var inst_19929 = inst_19928.push(inst_19913);
var inst_19909 = inst_19928;
var inst_19910 = inst_19917;
var state_19949__$1 = (function (){var statearr_19961 = state_19949;
(statearr_19961[(11)] = inst_19927);

(statearr_19961[(12)] = inst_19929);

(statearr_19961[(7)] = inst_19909);

(statearr_19961[(8)] = inst_19910);

return statearr_19961;
})();
var statearr_19962_19992 = state_19949__$1;
(statearr_19962_19992[(2)] = null);

(statearr_19962_19992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (9))){
var inst_19909 = (state_19949[(7)]);
var inst_19925 = cljs.core.vec.call(null,inst_19909);
var state_19949__$1 = state_19949;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19949__$1,(11),out,inst_19925);
} else {
if((state_val_19950 === (5))){
var inst_19913 = (state_19949[(9)]);
var inst_19917 = (state_19949[(10)]);
var inst_19910 = (state_19949[(8)]);
var inst_19917__$1 = f.call(null,inst_19913);
var inst_19918 = cljs.core._EQ_.call(null,inst_19917__$1,inst_19910);
var inst_19919 = cljs.core.keyword_identical_QMARK_.call(null,inst_19910,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19920 = (inst_19918) || (inst_19919);
var state_19949__$1 = (function (){var statearr_19963 = state_19949;
(statearr_19963[(10)] = inst_19917__$1);

return statearr_19963;
})();
if(cljs.core.truth_(inst_19920)){
var statearr_19964_19993 = state_19949__$1;
(statearr_19964_19993[(1)] = (8));

} else {
var statearr_19965_19994 = state_19949__$1;
(statearr_19965_19994[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (14))){
var inst_19942 = (state_19949[(2)]);
var inst_19943 = cljs.core.async.close_BANG_.call(null,out);
var state_19949__$1 = (function (){var statearr_19967 = state_19949;
(statearr_19967[(13)] = inst_19942);

return statearr_19967;
})();
var statearr_19968_19995 = state_19949__$1;
(statearr_19968_19995[(2)] = inst_19943);

(statearr_19968_19995[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (10))){
var inst_19932 = (state_19949[(2)]);
var state_19949__$1 = state_19949;
var statearr_19969_19996 = state_19949__$1;
(statearr_19969_19996[(2)] = inst_19932);

(statearr_19969_19996[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19950 === (8))){
var inst_19913 = (state_19949[(9)]);
var inst_19909 = (state_19949[(7)]);
var inst_19917 = (state_19949[(10)]);
var inst_19922 = inst_19909.push(inst_19913);
var tmp19966 = inst_19909;
var inst_19909__$1 = tmp19966;
var inst_19910 = inst_19917;
var state_19949__$1 = (function (){var statearr_19970 = state_19949;
(statearr_19970[(14)] = inst_19922);

(statearr_19970[(7)] = inst_19909__$1);

(statearr_19970[(8)] = inst_19910);

return statearr_19970;
})();
var statearr_19971_19997 = state_19949__$1;
(statearr_19971_19997[(2)] = null);

(statearr_19971_19997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8362__auto___19983,out))
;
return ((function (switch__8250__auto__,c__8362__auto___19983,out){
return (function() {
var cljs$core$async$state_machine__8251__auto__ = null;
var cljs$core$async$state_machine__8251__auto____0 = (function (){
var statearr_19975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19975[(0)] = cljs$core$async$state_machine__8251__auto__);

(statearr_19975[(1)] = (1));

return statearr_19975;
});
var cljs$core$async$state_machine__8251__auto____1 = (function (state_19949){
while(true){
var ret_value__8252__auto__ = (function (){try{while(true){
var result__8253__auto__ = switch__8250__auto__.call(null,state_19949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8253__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8253__auto__;
}
break;
}
}catch (e19976){if((e19976 instanceof Object)){
var ex__8254__auto__ = e19976;
var statearr_19977_19998 = state_19949;
(statearr_19977_19998[(5)] = ex__8254__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19949);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19976;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8252__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19999 = state_19949;
state_19949 = G__19999;
continue;
} else {
return ret_value__8252__auto__;
}
break;
}
});
cljs$core$async$state_machine__8251__auto__ = function(state_19949){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8251__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8251__auto____1.call(this,state_19949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8251__auto____0;
cljs$core$async$state_machine__8251__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8251__auto____1;
return cljs$core$async$state_machine__8251__auto__;
})()
;})(switch__8250__auto__,c__8362__auto___19983,out))
})();
var state__8364__auto__ = (function (){var statearr_19978 = f__8363__auto__.call(null);
(statearr_19978[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__8362__auto___19983);

return statearr_19978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8364__auto__);
});})(c__8362__auto___19983,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1453298544725