// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__25431 = arguments.length;
switch (G__25431) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25432 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25432 = (function (f,blockable,meta25433){
this.f = f;
this.blockable = blockable;
this.meta25433 = meta25433;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25432.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25434,meta25433__$1){
var self__ = this;
var _25434__$1 = this;
return (new cljs.core.async.t_cljs$core$async25432(self__.f,self__.blockable,meta25433__$1));
}));

(cljs.core.async.t_cljs$core$async25432.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25434){
var self__ = this;
var _25434__$1 = this;
return self__.meta25433;
}));

(cljs.core.async.t_cljs$core$async25432.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25432.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async25432.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async25432.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async25432.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta25433], null);
}));

(cljs.core.async.t_cljs$core$async25432.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25432.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25432");

(cljs.core.async.t_cljs$core$async25432.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async25432");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25432.
 */
cljs.core.async.__GT_t_cljs$core$async25432 = (function cljs$core$async$__GT_t_cljs$core$async25432(f__$1,blockable__$1,meta25433){
return (new cljs.core.async.t_cljs$core$async25432(f__$1,blockable__$1,meta25433));
});

}

return (new cljs.core.async.t_cljs$core$async25432(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__25438 = arguments.length;
switch (G__25438) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__25441 = arguments.length;
switch (G__25441) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__25444 = arguments.length;
switch (G__25444) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_25446 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_25446) : fn1.call(null,val_25446));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_25446) : fn1.call(null,val_25446));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__25448 = arguments.length;
switch (G__25448) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___25450 = n;
var x_25451 = (0);
while(true){
if((x_25451 < n__5636__auto___25450)){
(a[x_25451] = x_25451);

var G__25452 = (x_25451 + (1));
x_25451 = G__25452;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25453 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25453 = (function (flag,meta25454){
this.flag = flag;
this.meta25454 = meta25454;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25453.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25455,meta25454__$1){
var self__ = this;
var _25455__$1 = this;
return (new cljs.core.async.t_cljs$core$async25453(self__.flag,meta25454__$1));
}));

(cljs.core.async.t_cljs$core$async25453.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25455){
var self__ = this;
var _25455__$1 = this;
return self__.meta25454;
}));

(cljs.core.async.t_cljs$core$async25453.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25453.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async25453.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async25453.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async25453.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta25454], null);
}));

(cljs.core.async.t_cljs$core$async25453.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25453.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25453");

(cljs.core.async.t_cljs$core$async25453.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async25453");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25453.
 */
cljs.core.async.__GT_t_cljs$core$async25453 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async25453(flag__$1,meta25454){
return (new cljs.core.async.t_cljs$core$async25453(flag__$1,meta25454));
});

}

return (new cljs.core.async.t_cljs$core$async25453(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25456 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25456 = (function (flag,cb,meta25457){
this.flag = flag;
this.cb = cb;
this.meta25457 = meta25457;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25456.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25458,meta25457__$1){
var self__ = this;
var _25458__$1 = this;
return (new cljs.core.async.t_cljs$core$async25456(self__.flag,self__.cb,meta25457__$1));
}));

(cljs.core.async.t_cljs$core$async25456.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25458){
var self__ = this;
var _25458__$1 = this;
return self__.meta25457;
}));

(cljs.core.async.t_cljs$core$async25456.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25456.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async25456.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async25456.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async25456.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta25457], null);
}));

(cljs.core.async.t_cljs$core$async25456.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25456.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25456");

(cljs.core.async.t_cljs$core$async25456.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async25456");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25456.
 */
cljs.core.async.__GT_t_cljs$core$async25456 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async25456(flag__$1,cb__$1,meta25457){
return (new cljs.core.async.t_cljs$core$async25456(flag__$1,cb__$1,meta25457));
});

}

return (new cljs.core.async.t_cljs$core$async25456(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25459_SHARP_){
var G__25461 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25459_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__25461) : fret.call(null,G__25461));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25460_SHARP_){
var G__25462 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25460_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__25462) : fret.call(null,G__25462));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__25463 = (i + (1));
i = G__25463;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___25468 = arguments.length;
var i__5770__auto___25469 = (0);
while(true){
if((i__5770__auto___25469 < len__5769__auto___25468)){
args__5775__auto__.push((arguments[i__5770__auto___25469]));

var G__25470 = (i__5770__auto___25469 + (1));
i__5770__auto___25469 = G__25470;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__25466){
var map__25467 = p__25466;
var map__25467__$1 = cljs.core.__destructure_map(map__25467);
var opts = map__25467__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq25464){
var G__25465 = cljs.core.first(seq25464);
var seq25464__$1 = cljs.core.next(seq25464);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__25465,seq25464__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__25472 = arguments.length;
switch (G__25472) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__25371__auto___25519 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_25496){
var state_val_25497 = (state_25496[(1)]);
if((state_val_25497 === (7))){
var inst_25492 = (state_25496[(2)]);
var state_25496__$1 = state_25496;
var statearr_25498_25520 = state_25496__$1;
(statearr_25498_25520[(2)] = inst_25492);

(statearr_25498_25520[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (1))){
var state_25496__$1 = state_25496;
var statearr_25499_25521 = state_25496__$1;
(statearr_25499_25521[(2)] = null);

(statearr_25499_25521[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (4))){
var inst_25475 = (state_25496[(7)]);
var inst_25475__$1 = (state_25496[(2)]);
var inst_25476 = (inst_25475__$1 == null);
var state_25496__$1 = (function (){var statearr_25500 = state_25496;
(statearr_25500[(7)] = inst_25475__$1);

return statearr_25500;
})();
if(cljs.core.truth_(inst_25476)){
var statearr_25501_25522 = state_25496__$1;
(statearr_25501_25522[(1)] = (5));

} else {
var statearr_25502_25523 = state_25496__$1;
(statearr_25502_25523[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (13))){
var state_25496__$1 = state_25496;
var statearr_25503_25524 = state_25496__$1;
(statearr_25503_25524[(2)] = null);

(statearr_25503_25524[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (6))){
var inst_25475 = (state_25496[(7)]);
var state_25496__$1 = state_25496;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25496__$1,(11),to,inst_25475);
} else {
if((state_val_25497 === (3))){
var inst_25494 = (state_25496[(2)]);
var state_25496__$1 = state_25496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25496__$1,inst_25494);
} else {
if((state_val_25497 === (12))){
var state_25496__$1 = state_25496;
var statearr_25504_25525 = state_25496__$1;
(statearr_25504_25525[(2)] = null);

(statearr_25504_25525[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (2))){
var state_25496__$1 = state_25496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25496__$1,(4),from);
} else {
if((state_val_25497 === (11))){
var inst_25485 = (state_25496[(2)]);
var state_25496__$1 = state_25496;
if(cljs.core.truth_(inst_25485)){
var statearr_25505_25526 = state_25496__$1;
(statearr_25505_25526[(1)] = (12));

} else {
var statearr_25506_25527 = state_25496__$1;
(statearr_25506_25527[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (9))){
var state_25496__$1 = state_25496;
var statearr_25507_25528 = state_25496__$1;
(statearr_25507_25528[(2)] = null);

(statearr_25507_25528[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (5))){
var state_25496__$1 = state_25496;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25508_25529 = state_25496__$1;
(statearr_25508_25529[(1)] = (8));

} else {
var statearr_25509_25530 = state_25496__$1;
(statearr_25509_25530[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (14))){
var inst_25490 = (state_25496[(2)]);
var state_25496__$1 = state_25496;
var statearr_25510_25531 = state_25496__$1;
(statearr_25510_25531[(2)] = inst_25490);

(statearr_25510_25531[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (10))){
var inst_25482 = (state_25496[(2)]);
var state_25496__$1 = state_25496;
var statearr_25511_25532 = state_25496__$1;
(statearr_25511_25532[(2)] = inst_25482);

(statearr_25511_25532[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25497 === (8))){
var inst_25479 = cljs.core.async.close_BANG_(to);
var state_25496__$1 = state_25496;
var statearr_25512_25533 = state_25496__$1;
(statearr_25512_25533[(2)] = inst_25479);

(statearr_25512_25533[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_25513 = [null,null,null,null,null,null,null,null];
(statearr_25513[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_25513[(1)] = (1));

return statearr_25513;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_25496){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25496);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25514){var ex__25300__auto__ = e25514;
var statearr_25515_25534 = state_25496;
(statearr_25515_25534[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25496[(4)]))){
var statearr_25516_25535 = state_25496;
(statearr_25516_25535[(1)] = cljs.core.first((state_25496[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25536 = state_25496;
state_25496 = G__25536;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_25496){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_25496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_25517 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25517[(6)] = c__25371__auto___25519);

return statearr_25517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__25537){
var vec__25538 = p__25537;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25538,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25538,(1),null);
var job = vec__25538;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__25371__auto___25714 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_25545){
var state_val_25546 = (state_25545[(1)]);
if((state_val_25546 === (1))){
var state_25545__$1 = state_25545;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25545__$1,(2),res,v);
} else {
if((state_val_25546 === (2))){
var inst_25542 = (state_25545[(2)]);
var inst_25543 = cljs.core.async.close_BANG_(res);
var state_25545__$1 = (function (){var statearr_25547 = state_25545;
(statearr_25547[(7)] = inst_25542);

return statearr_25547;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_25545__$1,inst_25543);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0 = (function (){
var statearr_25548 = [null,null,null,null,null,null,null,null];
(statearr_25548[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__);

(statearr_25548[(1)] = (1));

return statearr_25548;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1 = (function (state_25545){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25545);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25549){var ex__25300__auto__ = e25549;
var statearr_25550_25715 = state_25545;
(statearr_25550_25715[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25545[(4)]))){
var statearr_25551_25716 = state_25545;
(statearr_25551_25716[(1)] = cljs.core.first((state_25545[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25717 = state_25545;
state_25545 = G__25717;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = function(state_25545){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1.call(this,state_25545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_25552 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25552[(6)] = c__25371__auto___25714);

return statearr_25552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__25553){
var vec__25554 = p__25553;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25554,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25554,(1),null);
var job = vec__25554;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___25718 = n;
var __25719 = (0);
while(true){
if((__25719 < n__5636__auto___25718)){
var G__25557_25720 = type;
var G__25557_25721__$1 = (((G__25557_25720 instanceof cljs.core.Keyword))?G__25557_25720.fqn:null);
switch (G__25557_25721__$1) {
case "compute":
var c__25371__auto___25723 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__25719,c__25371__auto___25723,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async){
return (function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = ((function (__25719,c__25371__auto___25723,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async){
return (function (state_25570){
var state_val_25571 = (state_25570[(1)]);
if((state_val_25571 === (1))){
var state_25570__$1 = state_25570;
var statearr_25572_25724 = state_25570__$1;
(statearr_25572_25724[(2)] = null);

(statearr_25572_25724[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25571 === (2))){
var state_25570__$1 = state_25570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25570__$1,(4),jobs);
} else {
if((state_val_25571 === (3))){
var inst_25568 = (state_25570[(2)]);
var state_25570__$1 = state_25570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25570__$1,inst_25568);
} else {
if((state_val_25571 === (4))){
var inst_25560 = (state_25570[(2)]);
var inst_25561 = process__$1(inst_25560);
var state_25570__$1 = state_25570;
if(cljs.core.truth_(inst_25561)){
var statearr_25573_25725 = state_25570__$1;
(statearr_25573_25725[(1)] = (5));

} else {
var statearr_25574_25726 = state_25570__$1;
(statearr_25574_25726[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25571 === (5))){
var state_25570__$1 = state_25570;
var statearr_25575_25727 = state_25570__$1;
(statearr_25575_25727[(2)] = null);

(statearr_25575_25727[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25571 === (6))){
var state_25570__$1 = state_25570;
var statearr_25576_25728 = state_25570__$1;
(statearr_25576_25728[(2)] = null);

(statearr_25576_25728[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25571 === (7))){
var inst_25566 = (state_25570[(2)]);
var state_25570__$1 = state_25570;
var statearr_25577_25729 = state_25570__$1;
(statearr_25577_25729[(2)] = inst_25566);

(statearr_25577_25729[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__25719,c__25371__auto___25723,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async))
;
return ((function (__25719,switch__25296__auto__,c__25371__auto___25723,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0 = (function (){
var statearr_25578 = [null,null,null,null,null,null,null];
(statearr_25578[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__);

(statearr_25578[(1)] = (1));

return statearr_25578;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1 = (function (state_25570){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25570);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25579){var ex__25300__auto__ = e25579;
var statearr_25580_25730 = state_25570;
(statearr_25580_25730[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25570[(4)]))){
var statearr_25581_25731 = state_25570;
(statearr_25581_25731[(1)] = cljs.core.first((state_25570[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25732 = state_25570;
state_25570 = G__25732;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = function(state_25570){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1.call(this,state_25570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__;
})()
;})(__25719,switch__25296__auto__,c__25371__auto___25723,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async))
})();
var state__25373__auto__ = (function (){var statearr_25582 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25582[(6)] = c__25371__auto___25723);

return statearr_25582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
});})(__25719,c__25371__auto___25723,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async))
);


break;
case "async":
var c__25371__auto___25733 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__25719,c__25371__auto___25733,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async){
return (function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = ((function (__25719,c__25371__auto___25733,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async){
return (function (state_25595){
var state_val_25596 = (state_25595[(1)]);
if((state_val_25596 === (1))){
var state_25595__$1 = state_25595;
var statearr_25597_25734 = state_25595__$1;
(statearr_25597_25734[(2)] = null);

(statearr_25597_25734[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25596 === (2))){
var state_25595__$1 = state_25595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25595__$1,(4),jobs);
} else {
if((state_val_25596 === (3))){
var inst_25593 = (state_25595[(2)]);
var state_25595__$1 = state_25595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25595__$1,inst_25593);
} else {
if((state_val_25596 === (4))){
var inst_25585 = (state_25595[(2)]);
var inst_25586 = async(inst_25585);
var state_25595__$1 = state_25595;
if(cljs.core.truth_(inst_25586)){
var statearr_25598_25735 = state_25595__$1;
(statearr_25598_25735[(1)] = (5));

} else {
var statearr_25599_25736 = state_25595__$1;
(statearr_25599_25736[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25596 === (5))){
var state_25595__$1 = state_25595;
var statearr_25600_25737 = state_25595__$1;
(statearr_25600_25737[(2)] = null);

(statearr_25600_25737[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25596 === (6))){
var state_25595__$1 = state_25595;
var statearr_25601_25738 = state_25595__$1;
(statearr_25601_25738[(2)] = null);

(statearr_25601_25738[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25596 === (7))){
var inst_25591 = (state_25595[(2)]);
var state_25595__$1 = state_25595;
var statearr_25602_25739 = state_25595__$1;
(statearr_25602_25739[(2)] = inst_25591);

(statearr_25602_25739[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__25719,c__25371__auto___25733,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async))
;
return ((function (__25719,switch__25296__auto__,c__25371__auto___25733,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0 = (function (){
var statearr_25603 = [null,null,null,null,null,null,null];
(statearr_25603[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__);

(statearr_25603[(1)] = (1));

return statearr_25603;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1 = (function (state_25595){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25595);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25604){var ex__25300__auto__ = e25604;
var statearr_25605_25740 = state_25595;
(statearr_25605_25740[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25595[(4)]))){
var statearr_25606_25741 = state_25595;
(statearr_25606_25741[(1)] = cljs.core.first((state_25595[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25742 = state_25595;
state_25595 = G__25742;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = function(state_25595){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1.call(this,state_25595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__;
})()
;})(__25719,switch__25296__auto__,c__25371__auto___25733,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async))
})();
var state__25373__auto__ = (function (){var statearr_25607 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25607[(6)] = c__25371__auto___25733);

return statearr_25607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
});})(__25719,c__25371__auto___25733,G__25557_25720,G__25557_25721__$1,n__5636__auto___25718,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25557_25721__$1)].join('')));

}

var G__25743 = (__25719 + (1));
__25719 = G__25743;
continue;
} else {
}
break;
}

var c__25371__auto___25744 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_25629){
var state_val_25630 = (state_25629[(1)]);
if((state_val_25630 === (7))){
var inst_25625 = (state_25629[(2)]);
var state_25629__$1 = state_25629;
var statearr_25631_25745 = state_25629__$1;
(statearr_25631_25745[(2)] = inst_25625);

(statearr_25631_25745[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25630 === (1))){
var state_25629__$1 = state_25629;
var statearr_25632_25746 = state_25629__$1;
(statearr_25632_25746[(2)] = null);

(statearr_25632_25746[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25630 === (4))){
var inst_25610 = (state_25629[(7)]);
var inst_25610__$1 = (state_25629[(2)]);
var inst_25611 = (inst_25610__$1 == null);
var state_25629__$1 = (function (){var statearr_25633 = state_25629;
(statearr_25633[(7)] = inst_25610__$1);

return statearr_25633;
})();
if(cljs.core.truth_(inst_25611)){
var statearr_25634_25747 = state_25629__$1;
(statearr_25634_25747[(1)] = (5));

} else {
var statearr_25635_25748 = state_25629__$1;
(statearr_25635_25748[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25630 === (6))){
var inst_25615 = (state_25629[(8)]);
var inst_25610 = (state_25629[(7)]);
var inst_25615__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_25616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25617 = [inst_25610,inst_25615__$1];
var inst_25618 = (new cljs.core.PersistentVector(null,2,(5),inst_25616,inst_25617,null));
var state_25629__$1 = (function (){var statearr_25636 = state_25629;
(statearr_25636[(8)] = inst_25615__$1);

return statearr_25636;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25629__$1,(8),jobs,inst_25618);
} else {
if((state_val_25630 === (3))){
var inst_25627 = (state_25629[(2)]);
var state_25629__$1 = state_25629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25629__$1,inst_25627);
} else {
if((state_val_25630 === (2))){
var state_25629__$1 = state_25629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25629__$1,(4),from);
} else {
if((state_val_25630 === (9))){
var inst_25622 = (state_25629[(2)]);
var state_25629__$1 = (function (){var statearr_25637 = state_25629;
(statearr_25637[(9)] = inst_25622);

return statearr_25637;
})();
var statearr_25638_25749 = state_25629__$1;
(statearr_25638_25749[(2)] = null);

(statearr_25638_25749[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25630 === (5))){
var inst_25613 = cljs.core.async.close_BANG_(jobs);
var state_25629__$1 = state_25629;
var statearr_25639_25750 = state_25629__$1;
(statearr_25639_25750[(2)] = inst_25613);

(statearr_25639_25750[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25630 === (8))){
var inst_25615 = (state_25629[(8)]);
var inst_25620 = (state_25629[(2)]);
var state_25629__$1 = (function (){var statearr_25640 = state_25629;
(statearr_25640[(10)] = inst_25620);

return statearr_25640;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25629__$1,(9),results,inst_25615);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0 = (function (){
var statearr_25641 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25641[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__);

(statearr_25641[(1)] = (1));

return statearr_25641;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1 = (function (state_25629){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25629);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25642){var ex__25300__auto__ = e25642;
var statearr_25643_25751 = state_25629;
(statearr_25643_25751[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25629[(4)]))){
var statearr_25644_25752 = state_25629;
(statearr_25644_25752[(1)] = cljs.core.first((state_25629[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25753 = state_25629;
state_25629 = G__25753;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = function(state_25629){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1.call(this,state_25629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_25645 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25645[(6)] = c__25371__auto___25744);

return statearr_25645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_25683){
var state_val_25684 = (state_25683[(1)]);
if((state_val_25684 === (7))){
var inst_25679 = (state_25683[(2)]);
var state_25683__$1 = state_25683;
var statearr_25685_25754 = state_25683__$1;
(statearr_25685_25754[(2)] = inst_25679);

(statearr_25685_25754[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (20))){
var state_25683__$1 = state_25683;
var statearr_25686_25755 = state_25683__$1;
(statearr_25686_25755[(2)] = null);

(statearr_25686_25755[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (1))){
var state_25683__$1 = state_25683;
var statearr_25687_25756 = state_25683__$1;
(statearr_25687_25756[(2)] = null);

(statearr_25687_25756[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (4))){
var inst_25648 = (state_25683[(7)]);
var inst_25648__$1 = (state_25683[(2)]);
var inst_25649 = (inst_25648__$1 == null);
var state_25683__$1 = (function (){var statearr_25688 = state_25683;
(statearr_25688[(7)] = inst_25648__$1);

return statearr_25688;
})();
if(cljs.core.truth_(inst_25649)){
var statearr_25689_25757 = state_25683__$1;
(statearr_25689_25757[(1)] = (5));

} else {
var statearr_25690_25758 = state_25683__$1;
(statearr_25690_25758[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (15))){
var inst_25661 = (state_25683[(8)]);
var state_25683__$1 = state_25683;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25683__$1,(18),to,inst_25661);
} else {
if((state_val_25684 === (21))){
var inst_25674 = (state_25683[(2)]);
var state_25683__$1 = state_25683;
var statearr_25691_25759 = state_25683__$1;
(statearr_25691_25759[(2)] = inst_25674);

(statearr_25691_25759[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (13))){
var inst_25676 = (state_25683[(2)]);
var state_25683__$1 = (function (){var statearr_25692 = state_25683;
(statearr_25692[(9)] = inst_25676);

return statearr_25692;
})();
var statearr_25693_25760 = state_25683__$1;
(statearr_25693_25760[(2)] = null);

(statearr_25693_25760[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (6))){
var inst_25648 = (state_25683[(7)]);
var state_25683__$1 = state_25683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25683__$1,(11),inst_25648);
} else {
if((state_val_25684 === (17))){
var inst_25669 = (state_25683[(2)]);
var state_25683__$1 = state_25683;
if(cljs.core.truth_(inst_25669)){
var statearr_25694_25761 = state_25683__$1;
(statearr_25694_25761[(1)] = (19));

} else {
var statearr_25695_25762 = state_25683__$1;
(statearr_25695_25762[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (3))){
var inst_25681 = (state_25683[(2)]);
var state_25683__$1 = state_25683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25683__$1,inst_25681);
} else {
if((state_val_25684 === (12))){
var inst_25658 = (state_25683[(10)]);
var state_25683__$1 = state_25683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25683__$1,(14),inst_25658);
} else {
if((state_val_25684 === (2))){
var state_25683__$1 = state_25683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25683__$1,(4),results);
} else {
if((state_val_25684 === (19))){
var state_25683__$1 = state_25683;
var statearr_25696_25763 = state_25683__$1;
(statearr_25696_25763[(2)] = null);

(statearr_25696_25763[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (11))){
var inst_25658 = (state_25683[(2)]);
var state_25683__$1 = (function (){var statearr_25697 = state_25683;
(statearr_25697[(10)] = inst_25658);

return statearr_25697;
})();
var statearr_25698_25764 = state_25683__$1;
(statearr_25698_25764[(2)] = null);

(statearr_25698_25764[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (9))){
var state_25683__$1 = state_25683;
var statearr_25699_25765 = state_25683__$1;
(statearr_25699_25765[(2)] = null);

(statearr_25699_25765[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (5))){
var state_25683__$1 = state_25683;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25700_25766 = state_25683__$1;
(statearr_25700_25766[(1)] = (8));

} else {
var statearr_25701_25767 = state_25683__$1;
(statearr_25701_25767[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (14))){
var inst_25663 = (state_25683[(11)]);
var inst_25661 = (state_25683[(8)]);
var inst_25661__$1 = (state_25683[(2)]);
var inst_25662 = (inst_25661__$1 == null);
var inst_25663__$1 = cljs.core.not(inst_25662);
var state_25683__$1 = (function (){var statearr_25702 = state_25683;
(statearr_25702[(11)] = inst_25663__$1);

(statearr_25702[(8)] = inst_25661__$1);

return statearr_25702;
})();
if(inst_25663__$1){
var statearr_25703_25768 = state_25683__$1;
(statearr_25703_25768[(1)] = (15));

} else {
var statearr_25704_25769 = state_25683__$1;
(statearr_25704_25769[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (16))){
var inst_25663 = (state_25683[(11)]);
var state_25683__$1 = state_25683;
var statearr_25705_25770 = state_25683__$1;
(statearr_25705_25770[(2)] = inst_25663);

(statearr_25705_25770[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (10))){
var inst_25655 = (state_25683[(2)]);
var state_25683__$1 = state_25683;
var statearr_25706_25771 = state_25683__$1;
(statearr_25706_25771[(2)] = inst_25655);

(statearr_25706_25771[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (18))){
var inst_25666 = (state_25683[(2)]);
var state_25683__$1 = state_25683;
var statearr_25707_25772 = state_25683__$1;
(statearr_25707_25772[(2)] = inst_25666);

(statearr_25707_25772[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25684 === (8))){
var inst_25652 = cljs.core.async.close_BANG_(to);
var state_25683__$1 = state_25683;
var statearr_25708_25773 = state_25683__$1;
(statearr_25708_25773[(2)] = inst_25652);

(statearr_25708_25773[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0 = (function (){
var statearr_25709 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25709[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__);

(statearr_25709[(1)] = (1));

return statearr_25709;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1 = (function (state_25683){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25683);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25710){var ex__25300__auto__ = e25710;
var statearr_25711_25774 = state_25683;
(statearr_25711_25774[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25683[(4)]))){
var statearr_25712_25775 = state_25683;
(statearr_25712_25775[(1)] = cljs.core.first((state_25683[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25776 = state_25683;
state_25683 = G__25776;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__ = function(state_25683){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1.call(this,state_25683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25297__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_25713 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25713[(6)] = c__25371__auto__);

return statearr_25713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__25778 = arguments.length;
switch (G__25778) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__25781 = arguments.length;
switch (G__25781) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__25784 = arguments.length;
switch (G__25784) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__25371__auto___25834 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_25810){
var state_val_25811 = (state_25810[(1)]);
if((state_val_25811 === (7))){
var inst_25806 = (state_25810[(2)]);
var state_25810__$1 = state_25810;
var statearr_25812_25835 = state_25810__$1;
(statearr_25812_25835[(2)] = inst_25806);

(statearr_25812_25835[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (1))){
var state_25810__$1 = state_25810;
var statearr_25813_25836 = state_25810__$1;
(statearr_25813_25836[(2)] = null);

(statearr_25813_25836[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (4))){
var inst_25787 = (state_25810[(7)]);
var inst_25787__$1 = (state_25810[(2)]);
var inst_25788 = (inst_25787__$1 == null);
var state_25810__$1 = (function (){var statearr_25814 = state_25810;
(statearr_25814[(7)] = inst_25787__$1);

return statearr_25814;
})();
if(cljs.core.truth_(inst_25788)){
var statearr_25815_25837 = state_25810__$1;
(statearr_25815_25837[(1)] = (5));

} else {
var statearr_25816_25838 = state_25810__$1;
(statearr_25816_25838[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (13))){
var state_25810__$1 = state_25810;
var statearr_25817_25839 = state_25810__$1;
(statearr_25817_25839[(2)] = null);

(statearr_25817_25839[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (6))){
var inst_25787 = (state_25810[(7)]);
var inst_25793 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_25787) : p.call(null,inst_25787));
var state_25810__$1 = state_25810;
if(cljs.core.truth_(inst_25793)){
var statearr_25818_25840 = state_25810__$1;
(statearr_25818_25840[(1)] = (9));

} else {
var statearr_25819_25841 = state_25810__$1;
(statearr_25819_25841[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (3))){
var inst_25808 = (state_25810[(2)]);
var state_25810__$1 = state_25810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25810__$1,inst_25808);
} else {
if((state_val_25811 === (12))){
var state_25810__$1 = state_25810;
var statearr_25820_25842 = state_25810__$1;
(statearr_25820_25842[(2)] = null);

(statearr_25820_25842[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (2))){
var state_25810__$1 = state_25810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25810__$1,(4),ch);
} else {
if((state_val_25811 === (11))){
var inst_25787 = (state_25810[(7)]);
var inst_25797 = (state_25810[(2)]);
var state_25810__$1 = state_25810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25810__$1,(8),inst_25797,inst_25787);
} else {
if((state_val_25811 === (9))){
var state_25810__$1 = state_25810;
var statearr_25821_25843 = state_25810__$1;
(statearr_25821_25843[(2)] = tc);

(statearr_25821_25843[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (5))){
var inst_25790 = cljs.core.async.close_BANG_(tc);
var inst_25791 = cljs.core.async.close_BANG_(fc);
var state_25810__$1 = (function (){var statearr_25822 = state_25810;
(statearr_25822[(8)] = inst_25790);

return statearr_25822;
})();
var statearr_25823_25844 = state_25810__$1;
(statearr_25823_25844[(2)] = inst_25791);

(statearr_25823_25844[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (14))){
var inst_25804 = (state_25810[(2)]);
var state_25810__$1 = state_25810;
var statearr_25824_25845 = state_25810__$1;
(statearr_25824_25845[(2)] = inst_25804);

(statearr_25824_25845[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (10))){
var state_25810__$1 = state_25810;
var statearr_25825_25846 = state_25810__$1;
(statearr_25825_25846[(2)] = fc);

(statearr_25825_25846[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25811 === (8))){
var inst_25799 = (state_25810[(2)]);
var state_25810__$1 = state_25810;
if(cljs.core.truth_(inst_25799)){
var statearr_25826_25847 = state_25810__$1;
(statearr_25826_25847[(1)] = (12));

} else {
var statearr_25827_25848 = state_25810__$1;
(statearr_25827_25848[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_25828 = [null,null,null,null,null,null,null,null,null];
(statearr_25828[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_25828[(1)] = (1));

return statearr_25828;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_25810){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25810);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25829){var ex__25300__auto__ = e25829;
var statearr_25830_25849 = state_25810;
(statearr_25830_25849[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25810[(4)]))){
var statearr_25831_25850 = state_25810;
(statearr_25831_25850[(1)] = cljs.core.first((state_25810[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25851 = state_25810;
state_25810 = G__25851;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_25810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_25810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_25832 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25832[(6)] = c__25371__auto___25834);

return statearr_25832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_25873){
var state_val_25874 = (state_25873[(1)]);
if((state_val_25874 === (7))){
var inst_25869 = (state_25873[(2)]);
var state_25873__$1 = state_25873;
var statearr_25875_25894 = state_25873__$1;
(statearr_25875_25894[(2)] = inst_25869);

(statearr_25875_25894[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25874 === (1))){
var inst_25852 = init;
var inst_25853 = inst_25852;
var state_25873__$1 = (function (){var statearr_25876 = state_25873;
(statearr_25876[(7)] = inst_25853);

return statearr_25876;
})();
var statearr_25877_25895 = state_25873__$1;
(statearr_25877_25895[(2)] = null);

(statearr_25877_25895[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25874 === (4))){
var inst_25856 = (state_25873[(8)]);
var inst_25856__$1 = (state_25873[(2)]);
var inst_25857 = (inst_25856__$1 == null);
var state_25873__$1 = (function (){var statearr_25878 = state_25873;
(statearr_25878[(8)] = inst_25856__$1);

return statearr_25878;
})();
if(cljs.core.truth_(inst_25857)){
var statearr_25879_25896 = state_25873__$1;
(statearr_25879_25896[(1)] = (5));

} else {
var statearr_25880_25897 = state_25873__$1;
(statearr_25880_25897[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25874 === (6))){
var inst_25853 = (state_25873[(7)]);
var inst_25860 = (state_25873[(9)]);
var inst_25856 = (state_25873[(8)]);
var inst_25860__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_25853,inst_25856) : f.call(null,inst_25853,inst_25856));
var inst_25861 = cljs.core.reduced_QMARK_(inst_25860__$1);
var state_25873__$1 = (function (){var statearr_25881 = state_25873;
(statearr_25881[(9)] = inst_25860__$1);

return statearr_25881;
})();
if(inst_25861){
var statearr_25882_25898 = state_25873__$1;
(statearr_25882_25898[(1)] = (8));

} else {
var statearr_25883_25899 = state_25873__$1;
(statearr_25883_25899[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25874 === (3))){
var inst_25871 = (state_25873[(2)]);
var state_25873__$1 = state_25873;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25873__$1,inst_25871);
} else {
if((state_val_25874 === (2))){
var state_25873__$1 = state_25873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25873__$1,(4),ch);
} else {
if((state_val_25874 === (9))){
var inst_25860 = (state_25873[(9)]);
var inst_25853 = inst_25860;
var state_25873__$1 = (function (){var statearr_25884 = state_25873;
(statearr_25884[(7)] = inst_25853);

return statearr_25884;
})();
var statearr_25885_25900 = state_25873__$1;
(statearr_25885_25900[(2)] = null);

(statearr_25885_25900[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25874 === (5))){
var inst_25853 = (state_25873[(7)]);
var state_25873__$1 = state_25873;
var statearr_25886_25901 = state_25873__$1;
(statearr_25886_25901[(2)] = inst_25853);

(statearr_25886_25901[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25874 === (10))){
var inst_25867 = (state_25873[(2)]);
var state_25873__$1 = state_25873;
var statearr_25887_25902 = state_25873__$1;
(statearr_25887_25902[(2)] = inst_25867);

(statearr_25887_25902[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25874 === (8))){
var inst_25860 = (state_25873[(9)]);
var inst_25863 = cljs.core.deref(inst_25860);
var state_25873__$1 = state_25873;
var statearr_25888_25903 = state_25873__$1;
(statearr_25888_25903[(2)] = inst_25863);

(statearr_25888_25903[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__25297__auto__ = null;
var cljs$core$async$reduce_$_state_machine__25297__auto____0 = (function (){
var statearr_25889 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25889[(0)] = cljs$core$async$reduce_$_state_machine__25297__auto__);

(statearr_25889[(1)] = (1));

return statearr_25889;
});
var cljs$core$async$reduce_$_state_machine__25297__auto____1 = (function (state_25873){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25873);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25890){var ex__25300__auto__ = e25890;
var statearr_25891_25904 = state_25873;
(statearr_25891_25904[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25873[(4)]))){
var statearr_25892_25905 = state_25873;
(statearr_25892_25905[(1)] = cljs.core.first((state_25873[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25906 = state_25873;
state_25873 = G__25906;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__25297__auto__ = function(state_25873){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__25297__auto____1.call(this,state_25873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__25297__auto____0;
cljs$core$async$reduce_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__25297__auto____1;
return cljs$core$async$reduce_$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_25893 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25893[(6)] = c__25371__auto__);

return statearr_25893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_25912){
var state_val_25913 = (state_25912[(1)]);
if((state_val_25913 === (1))){
var inst_25907 = cljs.core.async.reduce(f__$1,init,ch);
var state_25912__$1 = state_25912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25912__$1,(2),inst_25907);
} else {
if((state_val_25913 === (2))){
var inst_25909 = (state_25912[(2)]);
var inst_25910 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_25909) : f__$1.call(null,inst_25909));
var state_25912__$1 = state_25912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25912__$1,inst_25910);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__25297__auto__ = null;
var cljs$core$async$transduce_$_state_machine__25297__auto____0 = (function (){
var statearr_25914 = [null,null,null,null,null,null,null];
(statearr_25914[(0)] = cljs$core$async$transduce_$_state_machine__25297__auto__);

(statearr_25914[(1)] = (1));

return statearr_25914;
});
var cljs$core$async$transduce_$_state_machine__25297__auto____1 = (function (state_25912){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25912);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25915){var ex__25300__auto__ = e25915;
var statearr_25916_25919 = state_25912;
(statearr_25916_25919[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25912[(4)]))){
var statearr_25917_25920 = state_25912;
(statearr_25917_25920[(1)] = cljs.core.first((state_25912[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25921 = state_25912;
state_25912 = G__25921;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__25297__auto__ = function(state_25912){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__25297__auto____1.call(this,state_25912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__25297__auto____0;
cljs$core$async$transduce_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__25297__auto____1;
return cljs$core$async$transduce_$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_25918 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25918[(6)] = c__25371__auto__);

return statearr_25918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__25923 = arguments.length;
switch (G__25923) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_25948){
var state_val_25949 = (state_25948[(1)]);
if((state_val_25949 === (7))){
var inst_25930 = (state_25948[(2)]);
var state_25948__$1 = state_25948;
var statearr_25950_25972 = state_25948__$1;
(statearr_25950_25972[(2)] = inst_25930);

(statearr_25950_25972[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (1))){
var inst_25924 = cljs.core.seq(coll);
var inst_25925 = inst_25924;
var state_25948__$1 = (function (){var statearr_25951 = state_25948;
(statearr_25951[(7)] = inst_25925);

return statearr_25951;
})();
var statearr_25952_25973 = state_25948__$1;
(statearr_25952_25973[(2)] = null);

(statearr_25952_25973[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (4))){
var inst_25925 = (state_25948[(7)]);
var inst_25928 = cljs.core.first(inst_25925);
var state_25948__$1 = state_25948;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25948__$1,(7),ch,inst_25928);
} else {
if((state_val_25949 === (13))){
var inst_25942 = (state_25948[(2)]);
var state_25948__$1 = state_25948;
var statearr_25953_25974 = state_25948__$1;
(statearr_25953_25974[(2)] = inst_25942);

(statearr_25953_25974[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (6))){
var inst_25933 = (state_25948[(2)]);
var state_25948__$1 = state_25948;
if(cljs.core.truth_(inst_25933)){
var statearr_25954_25975 = state_25948__$1;
(statearr_25954_25975[(1)] = (8));

} else {
var statearr_25955_25976 = state_25948__$1;
(statearr_25955_25976[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (3))){
var inst_25946 = (state_25948[(2)]);
var state_25948__$1 = state_25948;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25948__$1,inst_25946);
} else {
if((state_val_25949 === (12))){
var state_25948__$1 = state_25948;
var statearr_25956_25977 = state_25948__$1;
(statearr_25956_25977[(2)] = null);

(statearr_25956_25977[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (2))){
var inst_25925 = (state_25948[(7)]);
var state_25948__$1 = state_25948;
if(cljs.core.truth_(inst_25925)){
var statearr_25957_25978 = state_25948__$1;
(statearr_25957_25978[(1)] = (4));

} else {
var statearr_25958_25979 = state_25948__$1;
(statearr_25958_25979[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (11))){
var inst_25939 = cljs.core.async.close_BANG_(ch);
var state_25948__$1 = state_25948;
var statearr_25959_25980 = state_25948__$1;
(statearr_25959_25980[(2)] = inst_25939);

(statearr_25959_25980[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (9))){
var state_25948__$1 = state_25948;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25960_25981 = state_25948__$1;
(statearr_25960_25981[(1)] = (11));

} else {
var statearr_25961_25982 = state_25948__$1;
(statearr_25961_25982[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (5))){
var inst_25925 = (state_25948[(7)]);
var state_25948__$1 = state_25948;
var statearr_25962_25983 = state_25948__$1;
(statearr_25962_25983[(2)] = inst_25925);

(statearr_25962_25983[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (10))){
var inst_25944 = (state_25948[(2)]);
var state_25948__$1 = state_25948;
var statearr_25963_25984 = state_25948__$1;
(statearr_25963_25984[(2)] = inst_25944);

(statearr_25963_25984[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25949 === (8))){
var inst_25925 = (state_25948[(7)]);
var inst_25935 = cljs.core.next(inst_25925);
var inst_25925__$1 = inst_25935;
var state_25948__$1 = (function (){var statearr_25964 = state_25948;
(statearr_25964[(7)] = inst_25925__$1);

return statearr_25964;
})();
var statearr_25965_25985 = state_25948__$1;
(statearr_25965_25985[(2)] = null);

(statearr_25965_25985[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_25966 = [null,null,null,null,null,null,null,null];
(statearr_25966[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_25966[(1)] = (1));

return statearr_25966;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_25948){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_25948);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e25967){var ex__25300__auto__ = e25967;
var statearr_25968_25986 = state_25948;
(statearr_25968_25986[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_25948[(4)]))){
var statearr_25969_25987 = state_25948;
(statearr_25969_25987[(1)] = cljs.core.first((state_25948[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__25988 = state_25948;
state_25948 = G__25988;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_25948){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_25948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_25970 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_25970[(6)] = c__25371__auto__);

return statearr_25970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__25990 = arguments.length;
switch (G__25990) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_25992 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_25992(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_25993 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_25993(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_25994 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_25994(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_25995 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_25995(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25996 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25996 = (function (ch,cs,meta25997){
this.ch = ch;
this.cs = cs;
this.meta25997 = meta25997;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async25996.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25998,meta25997__$1){
var self__ = this;
var _25998__$1 = this;
return (new cljs.core.async.t_cljs$core$async25996(self__.ch,self__.cs,meta25997__$1));
}));

(cljs.core.async.t_cljs$core$async25996.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25998){
var self__ = this;
var _25998__$1 = this;
return self__.meta25997;
}));

(cljs.core.async.t_cljs$core$async25996.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25996.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async25996.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async25996.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async25996.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async25996.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async25996.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta25997], null);
}));

(cljs.core.async.t_cljs$core$async25996.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async25996.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25996");

(cljs.core.async.t_cljs$core$async25996.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async25996");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25996.
 */
cljs.core.async.__GT_t_cljs$core$async25996 = (function cljs$core$async$mult_$___GT_t_cljs$core$async25996(ch__$1,cs__$1,meta25997){
return (new cljs.core.async.t_cljs$core$async25996(ch__$1,cs__$1,meta25997));
});

}

return (new cljs.core.async.t_cljs$core$async25996(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__25371__auto___26215 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_26131){
var state_val_26132 = (state_26131[(1)]);
if((state_val_26132 === (7))){
var inst_26127 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26133_26216 = state_26131__$1;
(statearr_26133_26216[(2)] = inst_26127);

(statearr_26133_26216[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (20))){
var inst_26032 = (state_26131[(7)]);
var inst_26044 = cljs.core.first(inst_26032);
var inst_26045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26044,(0),null);
var inst_26046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26044,(1),null);
var state_26131__$1 = (function (){var statearr_26134 = state_26131;
(statearr_26134[(8)] = inst_26045);

return statearr_26134;
})();
if(cljs.core.truth_(inst_26046)){
var statearr_26135_26217 = state_26131__$1;
(statearr_26135_26217[(1)] = (22));

} else {
var statearr_26136_26218 = state_26131__$1;
(statearr_26136_26218[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (27))){
var inst_26001 = (state_26131[(9)]);
var inst_26076 = (state_26131[(10)]);
var inst_26081 = (state_26131[(11)]);
var inst_26074 = (state_26131[(12)]);
var inst_26081__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_26074,inst_26076);
var inst_26082 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_26081__$1,inst_26001,done);
var state_26131__$1 = (function (){var statearr_26137 = state_26131;
(statearr_26137[(11)] = inst_26081__$1);

return statearr_26137;
})();
if(cljs.core.truth_(inst_26082)){
var statearr_26138_26219 = state_26131__$1;
(statearr_26138_26219[(1)] = (30));

} else {
var statearr_26139_26220 = state_26131__$1;
(statearr_26139_26220[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (1))){
var state_26131__$1 = state_26131;
var statearr_26140_26221 = state_26131__$1;
(statearr_26140_26221[(2)] = null);

(statearr_26140_26221[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (24))){
var inst_26032 = (state_26131[(7)]);
var inst_26051 = (state_26131[(2)]);
var inst_26052 = cljs.core.next(inst_26032);
var inst_26010 = inst_26052;
var inst_26011 = null;
var inst_26012 = (0);
var inst_26013 = (0);
var state_26131__$1 = (function (){var statearr_26141 = state_26131;
(statearr_26141[(13)] = inst_26051);

(statearr_26141[(14)] = inst_26013);

(statearr_26141[(15)] = inst_26012);

(statearr_26141[(16)] = inst_26010);

(statearr_26141[(17)] = inst_26011);

return statearr_26141;
})();
var statearr_26142_26222 = state_26131__$1;
(statearr_26142_26222[(2)] = null);

(statearr_26142_26222[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (39))){
var state_26131__$1 = state_26131;
var statearr_26146_26223 = state_26131__$1;
(statearr_26146_26223[(2)] = null);

(statearr_26146_26223[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (4))){
var inst_26001 = (state_26131[(9)]);
var inst_26001__$1 = (state_26131[(2)]);
var inst_26002 = (inst_26001__$1 == null);
var state_26131__$1 = (function (){var statearr_26147 = state_26131;
(statearr_26147[(9)] = inst_26001__$1);

return statearr_26147;
})();
if(cljs.core.truth_(inst_26002)){
var statearr_26148_26224 = state_26131__$1;
(statearr_26148_26224[(1)] = (5));

} else {
var statearr_26149_26225 = state_26131__$1;
(statearr_26149_26225[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (15))){
var inst_26013 = (state_26131[(14)]);
var inst_26012 = (state_26131[(15)]);
var inst_26010 = (state_26131[(16)]);
var inst_26011 = (state_26131[(17)]);
var inst_26028 = (state_26131[(2)]);
var inst_26029 = (inst_26013 + (1));
var tmp26143 = inst_26012;
var tmp26144 = inst_26010;
var tmp26145 = inst_26011;
var inst_26010__$1 = tmp26144;
var inst_26011__$1 = tmp26145;
var inst_26012__$1 = tmp26143;
var inst_26013__$1 = inst_26029;
var state_26131__$1 = (function (){var statearr_26150 = state_26131;
(statearr_26150[(14)] = inst_26013__$1);

(statearr_26150[(15)] = inst_26012__$1);

(statearr_26150[(16)] = inst_26010__$1);

(statearr_26150[(18)] = inst_26028);

(statearr_26150[(17)] = inst_26011__$1);

return statearr_26150;
})();
var statearr_26151_26226 = state_26131__$1;
(statearr_26151_26226[(2)] = null);

(statearr_26151_26226[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (21))){
var inst_26055 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26155_26227 = state_26131__$1;
(statearr_26155_26227[(2)] = inst_26055);

(statearr_26155_26227[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (31))){
var inst_26081 = (state_26131[(11)]);
var inst_26085 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_26081);
var state_26131__$1 = state_26131;
var statearr_26156_26228 = state_26131__$1;
(statearr_26156_26228[(2)] = inst_26085);

(statearr_26156_26228[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (32))){
var inst_26073 = (state_26131[(19)]);
var inst_26076 = (state_26131[(10)]);
var inst_26075 = (state_26131[(20)]);
var inst_26074 = (state_26131[(12)]);
var inst_26087 = (state_26131[(2)]);
var inst_26088 = (inst_26076 + (1));
var tmp26152 = inst_26073;
var tmp26153 = inst_26075;
var tmp26154 = inst_26074;
var inst_26073__$1 = tmp26152;
var inst_26074__$1 = tmp26154;
var inst_26075__$1 = tmp26153;
var inst_26076__$1 = inst_26088;
var state_26131__$1 = (function (){var statearr_26157 = state_26131;
(statearr_26157[(19)] = inst_26073__$1);

(statearr_26157[(10)] = inst_26076__$1);

(statearr_26157[(20)] = inst_26075__$1);

(statearr_26157[(12)] = inst_26074__$1);

(statearr_26157[(21)] = inst_26087);

return statearr_26157;
})();
var statearr_26158_26229 = state_26131__$1;
(statearr_26158_26229[(2)] = null);

(statearr_26158_26229[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (40))){
var inst_26100 = (state_26131[(22)]);
var inst_26104 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_26100);
var state_26131__$1 = state_26131;
var statearr_26159_26230 = state_26131__$1;
(statearr_26159_26230[(2)] = inst_26104);

(statearr_26159_26230[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (33))){
var inst_26091 = (state_26131[(23)]);
var inst_26093 = cljs.core.chunked_seq_QMARK_(inst_26091);
var state_26131__$1 = state_26131;
if(inst_26093){
var statearr_26160_26231 = state_26131__$1;
(statearr_26160_26231[(1)] = (36));

} else {
var statearr_26161_26232 = state_26131__$1;
(statearr_26161_26232[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (13))){
var inst_26022 = (state_26131[(24)]);
var inst_26025 = cljs.core.async.close_BANG_(inst_26022);
var state_26131__$1 = state_26131;
var statearr_26162_26233 = state_26131__$1;
(statearr_26162_26233[(2)] = inst_26025);

(statearr_26162_26233[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (22))){
var inst_26045 = (state_26131[(8)]);
var inst_26048 = cljs.core.async.close_BANG_(inst_26045);
var state_26131__$1 = state_26131;
var statearr_26163_26234 = state_26131__$1;
(statearr_26163_26234[(2)] = inst_26048);

(statearr_26163_26234[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (36))){
var inst_26091 = (state_26131[(23)]);
var inst_26095 = cljs.core.chunk_first(inst_26091);
var inst_26096 = cljs.core.chunk_rest(inst_26091);
var inst_26097 = cljs.core.count(inst_26095);
var inst_26073 = inst_26096;
var inst_26074 = inst_26095;
var inst_26075 = inst_26097;
var inst_26076 = (0);
var state_26131__$1 = (function (){var statearr_26164 = state_26131;
(statearr_26164[(19)] = inst_26073);

(statearr_26164[(10)] = inst_26076);

(statearr_26164[(20)] = inst_26075);

(statearr_26164[(12)] = inst_26074);

return statearr_26164;
})();
var statearr_26165_26235 = state_26131__$1;
(statearr_26165_26235[(2)] = null);

(statearr_26165_26235[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (41))){
var inst_26091 = (state_26131[(23)]);
var inst_26106 = (state_26131[(2)]);
var inst_26107 = cljs.core.next(inst_26091);
var inst_26073 = inst_26107;
var inst_26074 = null;
var inst_26075 = (0);
var inst_26076 = (0);
var state_26131__$1 = (function (){var statearr_26166 = state_26131;
(statearr_26166[(19)] = inst_26073);

(statearr_26166[(10)] = inst_26076);

(statearr_26166[(25)] = inst_26106);

(statearr_26166[(20)] = inst_26075);

(statearr_26166[(12)] = inst_26074);

return statearr_26166;
})();
var statearr_26167_26236 = state_26131__$1;
(statearr_26167_26236[(2)] = null);

(statearr_26167_26236[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (43))){
var state_26131__$1 = state_26131;
var statearr_26168_26237 = state_26131__$1;
(statearr_26168_26237[(2)] = null);

(statearr_26168_26237[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (29))){
var inst_26115 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26169_26238 = state_26131__$1;
(statearr_26169_26238[(2)] = inst_26115);

(statearr_26169_26238[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (44))){
var inst_26124 = (state_26131[(2)]);
var state_26131__$1 = (function (){var statearr_26170 = state_26131;
(statearr_26170[(26)] = inst_26124);

return statearr_26170;
})();
var statearr_26171_26239 = state_26131__$1;
(statearr_26171_26239[(2)] = null);

(statearr_26171_26239[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (6))){
var inst_26065 = (state_26131[(27)]);
var inst_26064 = cljs.core.deref(cs);
var inst_26065__$1 = cljs.core.keys(inst_26064);
var inst_26066 = cljs.core.count(inst_26065__$1);
var inst_26067 = cljs.core.reset_BANG_(dctr,inst_26066);
var inst_26072 = cljs.core.seq(inst_26065__$1);
var inst_26073 = inst_26072;
var inst_26074 = null;
var inst_26075 = (0);
var inst_26076 = (0);
var state_26131__$1 = (function (){var statearr_26172 = state_26131;
(statearr_26172[(19)] = inst_26073);

(statearr_26172[(10)] = inst_26076);

(statearr_26172[(28)] = inst_26067);

(statearr_26172[(27)] = inst_26065__$1);

(statearr_26172[(20)] = inst_26075);

(statearr_26172[(12)] = inst_26074);

return statearr_26172;
})();
var statearr_26173_26240 = state_26131__$1;
(statearr_26173_26240[(2)] = null);

(statearr_26173_26240[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (28))){
var inst_26073 = (state_26131[(19)]);
var inst_26091 = (state_26131[(23)]);
var inst_26091__$1 = cljs.core.seq(inst_26073);
var state_26131__$1 = (function (){var statearr_26174 = state_26131;
(statearr_26174[(23)] = inst_26091__$1);

return statearr_26174;
})();
if(inst_26091__$1){
var statearr_26175_26241 = state_26131__$1;
(statearr_26175_26241[(1)] = (33));

} else {
var statearr_26176_26242 = state_26131__$1;
(statearr_26176_26242[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (25))){
var inst_26076 = (state_26131[(10)]);
var inst_26075 = (state_26131[(20)]);
var inst_26078 = (inst_26076 < inst_26075);
var inst_26079 = inst_26078;
var state_26131__$1 = state_26131;
if(cljs.core.truth_(inst_26079)){
var statearr_26177_26243 = state_26131__$1;
(statearr_26177_26243[(1)] = (27));

} else {
var statearr_26178_26244 = state_26131__$1;
(statearr_26178_26244[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (34))){
var state_26131__$1 = state_26131;
var statearr_26179_26245 = state_26131__$1;
(statearr_26179_26245[(2)] = null);

(statearr_26179_26245[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (17))){
var state_26131__$1 = state_26131;
var statearr_26180_26246 = state_26131__$1;
(statearr_26180_26246[(2)] = null);

(statearr_26180_26246[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (3))){
var inst_26129 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26131__$1,inst_26129);
} else {
if((state_val_26132 === (12))){
var inst_26060 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26181_26247 = state_26131__$1;
(statearr_26181_26247[(2)] = inst_26060);

(statearr_26181_26247[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (2))){
var state_26131__$1 = state_26131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26131__$1,(4),ch);
} else {
if((state_val_26132 === (23))){
var state_26131__$1 = state_26131;
var statearr_26182_26248 = state_26131__$1;
(statearr_26182_26248[(2)] = null);

(statearr_26182_26248[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (35))){
var inst_26113 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26183_26249 = state_26131__$1;
(statearr_26183_26249[(2)] = inst_26113);

(statearr_26183_26249[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (19))){
var inst_26032 = (state_26131[(7)]);
var inst_26036 = cljs.core.chunk_first(inst_26032);
var inst_26037 = cljs.core.chunk_rest(inst_26032);
var inst_26038 = cljs.core.count(inst_26036);
var inst_26010 = inst_26037;
var inst_26011 = inst_26036;
var inst_26012 = inst_26038;
var inst_26013 = (0);
var state_26131__$1 = (function (){var statearr_26184 = state_26131;
(statearr_26184[(14)] = inst_26013);

(statearr_26184[(15)] = inst_26012);

(statearr_26184[(16)] = inst_26010);

(statearr_26184[(17)] = inst_26011);

return statearr_26184;
})();
var statearr_26185_26250 = state_26131__$1;
(statearr_26185_26250[(2)] = null);

(statearr_26185_26250[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (11))){
var inst_26032 = (state_26131[(7)]);
var inst_26010 = (state_26131[(16)]);
var inst_26032__$1 = cljs.core.seq(inst_26010);
var state_26131__$1 = (function (){var statearr_26186 = state_26131;
(statearr_26186[(7)] = inst_26032__$1);

return statearr_26186;
})();
if(inst_26032__$1){
var statearr_26187_26251 = state_26131__$1;
(statearr_26187_26251[(1)] = (16));

} else {
var statearr_26188_26252 = state_26131__$1;
(statearr_26188_26252[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (9))){
var inst_26062 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26189_26253 = state_26131__$1;
(statearr_26189_26253[(2)] = inst_26062);

(statearr_26189_26253[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (5))){
var inst_26008 = cljs.core.deref(cs);
var inst_26009 = cljs.core.seq(inst_26008);
var inst_26010 = inst_26009;
var inst_26011 = null;
var inst_26012 = (0);
var inst_26013 = (0);
var state_26131__$1 = (function (){var statearr_26190 = state_26131;
(statearr_26190[(14)] = inst_26013);

(statearr_26190[(15)] = inst_26012);

(statearr_26190[(16)] = inst_26010);

(statearr_26190[(17)] = inst_26011);

return statearr_26190;
})();
var statearr_26191_26254 = state_26131__$1;
(statearr_26191_26254[(2)] = null);

(statearr_26191_26254[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (14))){
var state_26131__$1 = state_26131;
var statearr_26192_26255 = state_26131__$1;
(statearr_26192_26255[(2)] = null);

(statearr_26192_26255[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (45))){
var inst_26121 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26193_26256 = state_26131__$1;
(statearr_26193_26256[(2)] = inst_26121);

(statearr_26193_26256[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (26))){
var inst_26065 = (state_26131[(27)]);
var inst_26117 = (state_26131[(2)]);
var inst_26118 = cljs.core.seq(inst_26065);
var state_26131__$1 = (function (){var statearr_26194 = state_26131;
(statearr_26194[(29)] = inst_26117);

return statearr_26194;
})();
if(inst_26118){
var statearr_26195_26257 = state_26131__$1;
(statearr_26195_26257[(1)] = (42));

} else {
var statearr_26196_26258 = state_26131__$1;
(statearr_26196_26258[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (16))){
var inst_26032 = (state_26131[(7)]);
var inst_26034 = cljs.core.chunked_seq_QMARK_(inst_26032);
var state_26131__$1 = state_26131;
if(inst_26034){
var statearr_26197_26259 = state_26131__$1;
(statearr_26197_26259[(1)] = (19));

} else {
var statearr_26198_26260 = state_26131__$1;
(statearr_26198_26260[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (38))){
var inst_26110 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26199_26261 = state_26131__$1;
(statearr_26199_26261[(2)] = inst_26110);

(statearr_26199_26261[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (30))){
var state_26131__$1 = state_26131;
var statearr_26200_26262 = state_26131__$1;
(statearr_26200_26262[(2)] = null);

(statearr_26200_26262[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (10))){
var inst_26013 = (state_26131[(14)]);
var inst_26011 = (state_26131[(17)]);
var inst_26021 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_26011,inst_26013);
var inst_26022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26021,(0),null);
var inst_26023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26021,(1),null);
var state_26131__$1 = (function (){var statearr_26201 = state_26131;
(statearr_26201[(24)] = inst_26022);

return statearr_26201;
})();
if(cljs.core.truth_(inst_26023)){
var statearr_26202_26263 = state_26131__$1;
(statearr_26202_26263[(1)] = (13));

} else {
var statearr_26203_26264 = state_26131__$1;
(statearr_26203_26264[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (18))){
var inst_26058 = (state_26131[(2)]);
var state_26131__$1 = state_26131;
var statearr_26204_26265 = state_26131__$1;
(statearr_26204_26265[(2)] = inst_26058);

(statearr_26204_26265[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (42))){
var state_26131__$1 = state_26131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26131__$1,(45),dchan);
} else {
if((state_val_26132 === (37))){
var inst_26001 = (state_26131[(9)]);
var inst_26091 = (state_26131[(23)]);
var inst_26100 = (state_26131[(22)]);
var inst_26100__$1 = cljs.core.first(inst_26091);
var inst_26101 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_26100__$1,inst_26001,done);
var state_26131__$1 = (function (){var statearr_26205 = state_26131;
(statearr_26205[(22)] = inst_26100__$1);

return statearr_26205;
})();
if(cljs.core.truth_(inst_26101)){
var statearr_26206_26266 = state_26131__$1;
(statearr_26206_26266[(1)] = (39));

} else {
var statearr_26207_26267 = state_26131__$1;
(statearr_26207_26267[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26132 === (8))){
var inst_26013 = (state_26131[(14)]);
var inst_26012 = (state_26131[(15)]);
var inst_26015 = (inst_26013 < inst_26012);
var inst_26016 = inst_26015;
var state_26131__$1 = state_26131;
if(cljs.core.truth_(inst_26016)){
var statearr_26208_26268 = state_26131__$1;
(statearr_26208_26268[(1)] = (10));

} else {
var statearr_26209_26269 = state_26131__$1;
(statearr_26209_26269[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__25297__auto__ = null;
var cljs$core$async$mult_$_state_machine__25297__auto____0 = (function (){
var statearr_26210 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26210[(0)] = cljs$core$async$mult_$_state_machine__25297__auto__);

(statearr_26210[(1)] = (1));

return statearr_26210;
});
var cljs$core$async$mult_$_state_machine__25297__auto____1 = (function (state_26131){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_26131);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e26211){var ex__25300__auto__ = e26211;
var statearr_26212_26270 = state_26131;
(statearr_26212_26270[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_26131[(4)]))){
var statearr_26213_26271 = state_26131;
(statearr_26213_26271[(1)] = cljs.core.first((state_26131[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__26272 = state_26131;
state_26131 = G__26272;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__25297__auto__ = function(state_26131){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__25297__auto____1.call(this,state_26131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__25297__auto____0;
cljs$core$async$mult_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__25297__auto____1;
return cljs$core$async$mult_$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_26214 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_26214[(6)] = c__25371__auto___26215);

return statearr_26214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__26274 = arguments.length;
switch (G__26274) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_26276 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_26276(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_26277 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_26277(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_26278 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_26278(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_26279 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_26279(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_26280 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_26280(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___26290 = arguments.length;
var i__5770__auto___26291 = (0);
while(true){
if((i__5770__auto___26291 < len__5769__auto___26290)){
args__5775__auto__.push((arguments[i__5770__auto___26291]));

var G__26292 = (i__5770__auto___26291 + (1));
i__5770__auto___26291 = G__26292;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__26285){
var map__26286 = p__26285;
var map__26286__$1 = cljs.core.__destructure_map(map__26286);
var opts = map__26286__$1;
var statearr_26287_26293 = state;
(statearr_26287_26293[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_26288_26294 = state;
(statearr_26288_26294[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_26289_26295 = state;
(statearr_26289_26295[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq26281){
var G__26282 = cljs.core.first(seq26281);
var seq26281__$1 = cljs.core.next(seq26281);
var G__26283 = cljs.core.first(seq26281__$1);
var seq26281__$2 = cljs.core.next(seq26281__$1);
var G__26284 = cljs.core.first(seq26281__$2);
var seq26281__$3 = cljs.core.next(seq26281__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26282,G__26283,G__26284,seq26281__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26296 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26296 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta26297){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta26297 = meta26297;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26298,meta26297__$1){
var self__ = this;
var _26298__$1 = this;
return (new cljs.core.async.t_cljs$core$async26296(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta26297__$1));
}));

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26298){
var self__ = this;
var _26298__$1 = this;
return self__.meta26297;
}));

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async26296.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async26296.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta26297], null);
}));

(cljs.core.async.t_cljs$core$async26296.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26296.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26296");

(cljs.core.async.t_cljs$core$async26296.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async26296");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26296.
 */
cljs.core.async.__GT_t_cljs$core$async26296 = (function cljs$core$async$mix_$___GT_t_cljs$core$async26296(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta26297){
return (new cljs.core.async.t_cljs$core$async26296(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta26297));
});

}

return (new cljs.core.async.t_cljs$core$async26296(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25371__auto___26411 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_26366){
var state_val_26367 = (state_26366[(1)]);
if((state_val_26367 === (7))){
var inst_26326 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
if(cljs.core.truth_(inst_26326)){
var statearr_26368_26412 = state_26366__$1;
(statearr_26368_26412[(1)] = (8));

} else {
var statearr_26369_26413 = state_26366__$1;
(statearr_26369_26413[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (20))){
var inst_26319 = (state_26366[(7)]);
var state_26366__$1 = state_26366;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26366__$1,(23),out,inst_26319);
} else {
if((state_val_26367 === (1))){
var inst_26302 = calc_state();
var inst_26303 = cljs.core.__destructure_map(inst_26302);
var inst_26304 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26303,cljs.core.cst$kw$solos);
var inst_26305 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26303,cljs.core.cst$kw$mutes);
var inst_26306 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26303,cljs.core.cst$kw$reads);
var inst_26307 = inst_26302;
var state_26366__$1 = (function (){var statearr_26370 = state_26366;
(statearr_26370[(8)] = inst_26306);

(statearr_26370[(9)] = inst_26304);

(statearr_26370[(10)] = inst_26307);

(statearr_26370[(11)] = inst_26305);

return statearr_26370;
})();
var statearr_26371_26414 = state_26366__$1;
(statearr_26371_26414[(2)] = null);

(statearr_26371_26414[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (24))){
var inst_26310 = (state_26366[(12)]);
var inst_26307 = inst_26310;
var state_26366__$1 = (function (){var statearr_26372 = state_26366;
(statearr_26372[(10)] = inst_26307);

return statearr_26372;
})();
var statearr_26373_26415 = state_26366__$1;
(statearr_26373_26415[(2)] = null);

(statearr_26373_26415[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (4))){
var inst_26319 = (state_26366[(7)]);
var inst_26321 = (state_26366[(13)]);
var inst_26318 = (state_26366[(2)]);
var inst_26319__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26318,(0),null);
var inst_26320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26318,(1),null);
var inst_26321__$1 = (inst_26319__$1 == null);
var state_26366__$1 = (function (){var statearr_26374 = state_26366;
(statearr_26374[(7)] = inst_26319__$1);

(statearr_26374[(14)] = inst_26320);

(statearr_26374[(13)] = inst_26321__$1);

return statearr_26374;
})();
if(cljs.core.truth_(inst_26321__$1)){
var statearr_26375_26416 = state_26366__$1;
(statearr_26375_26416[(1)] = (5));

} else {
var statearr_26376_26417 = state_26366__$1;
(statearr_26376_26417[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (15))){
var inst_26311 = (state_26366[(15)]);
var inst_26340 = (state_26366[(16)]);
var inst_26340__$1 = cljs.core.empty_QMARK_(inst_26311);
var state_26366__$1 = (function (){var statearr_26377 = state_26366;
(statearr_26377[(16)] = inst_26340__$1);

return statearr_26377;
})();
if(inst_26340__$1){
var statearr_26378_26418 = state_26366__$1;
(statearr_26378_26418[(1)] = (17));

} else {
var statearr_26379_26419 = state_26366__$1;
(statearr_26379_26419[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (21))){
var inst_26310 = (state_26366[(12)]);
var inst_26307 = inst_26310;
var state_26366__$1 = (function (){var statearr_26380 = state_26366;
(statearr_26380[(10)] = inst_26307);

return statearr_26380;
})();
var statearr_26381_26420 = state_26366__$1;
(statearr_26381_26420[(2)] = null);

(statearr_26381_26420[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (13))){
var inst_26333 = (state_26366[(2)]);
var inst_26334 = calc_state();
var inst_26307 = inst_26334;
var state_26366__$1 = (function (){var statearr_26382 = state_26366;
(statearr_26382[(17)] = inst_26333);

(statearr_26382[(10)] = inst_26307);

return statearr_26382;
})();
var statearr_26383_26421 = state_26366__$1;
(statearr_26383_26421[(2)] = null);

(statearr_26383_26421[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (22))){
var inst_26360 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
var statearr_26384_26422 = state_26366__$1;
(statearr_26384_26422[(2)] = inst_26360);

(statearr_26384_26422[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (6))){
var inst_26320 = (state_26366[(14)]);
var inst_26324 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26320,change);
var state_26366__$1 = state_26366;
var statearr_26385_26423 = state_26366__$1;
(statearr_26385_26423[(2)] = inst_26324);

(statearr_26385_26423[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (25))){
var state_26366__$1 = state_26366;
var statearr_26386_26424 = state_26366__$1;
(statearr_26386_26424[(2)] = null);

(statearr_26386_26424[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (17))){
var inst_26312 = (state_26366[(18)]);
var inst_26320 = (state_26366[(14)]);
var inst_26342 = (inst_26312.cljs$core$IFn$_invoke$arity$1 ? inst_26312.cljs$core$IFn$_invoke$arity$1(inst_26320) : inst_26312.call(null,inst_26320));
var inst_26343 = cljs.core.not(inst_26342);
var state_26366__$1 = state_26366;
var statearr_26387_26425 = state_26366__$1;
(statearr_26387_26425[(2)] = inst_26343);

(statearr_26387_26425[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (3))){
var inst_26364 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26366__$1,inst_26364);
} else {
if((state_val_26367 === (12))){
var state_26366__$1 = state_26366;
var statearr_26388_26426 = state_26366__$1;
(statearr_26388_26426[(2)] = null);

(statearr_26388_26426[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (2))){
var inst_26310 = (state_26366[(12)]);
var inst_26307 = (state_26366[(10)]);
var inst_26310__$1 = cljs.core.__destructure_map(inst_26307);
var inst_26311 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26310__$1,cljs.core.cst$kw$solos);
var inst_26312 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26310__$1,cljs.core.cst$kw$mutes);
var inst_26313 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26310__$1,cljs.core.cst$kw$reads);
var state_26366__$1 = (function (){var statearr_26389 = state_26366;
(statearr_26389[(12)] = inst_26310__$1);

(statearr_26389[(15)] = inst_26311);

(statearr_26389[(18)] = inst_26312);

return statearr_26389;
})();
return cljs.core.async.ioc_alts_BANG_(state_26366__$1,(4),inst_26313);
} else {
if((state_val_26367 === (23))){
var inst_26351 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
if(cljs.core.truth_(inst_26351)){
var statearr_26390_26427 = state_26366__$1;
(statearr_26390_26427[(1)] = (24));

} else {
var statearr_26391_26428 = state_26366__$1;
(statearr_26391_26428[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (19))){
var inst_26346 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
var statearr_26392_26429 = state_26366__$1;
(statearr_26392_26429[(2)] = inst_26346);

(statearr_26392_26429[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (11))){
var inst_26320 = (state_26366[(14)]);
var inst_26330 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_26320);
var state_26366__$1 = state_26366;
var statearr_26393_26430 = state_26366__$1;
(statearr_26393_26430[(2)] = inst_26330);

(statearr_26393_26430[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (9))){
var inst_26311 = (state_26366[(15)]);
var inst_26320 = (state_26366[(14)]);
var inst_26337 = (state_26366[(19)]);
var inst_26337__$1 = (inst_26311.cljs$core$IFn$_invoke$arity$1 ? inst_26311.cljs$core$IFn$_invoke$arity$1(inst_26320) : inst_26311.call(null,inst_26320));
var state_26366__$1 = (function (){var statearr_26394 = state_26366;
(statearr_26394[(19)] = inst_26337__$1);

return statearr_26394;
})();
if(cljs.core.truth_(inst_26337__$1)){
var statearr_26395_26431 = state_26366__$1;
(statearr_26395_26431[(1)] = (14));

} else {
var statearr_26396_26432 = state_26366__$1;
(statearr_26396_26432[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (5))){
var inst_26321 = (state_26366[(13)]);
var state_26366__$1 = state_26366;
var statearr_26397_26433 = state_26366__$1;
(statearr_26397_26433[(2)] = inst_26321);

(statearr_26397_26433[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (14))){
var inst_26337 = (state_26366[(19)]);
var state_26366__$1 = state_26366;
var statearr_26398_26434 = state_26366__$1;
(statearr_26398_26434[(2)] = inst_26337);

(statearr_26398_26434[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (26))){
var inst_26356 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
var statearr_26399_26435 = state_26366__$1;
(statearr_26399_26435[(2)] = inst_26356);

(statearr_26399_26435[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (16))){
var inst_26348 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
if(cljs.core.truth_(inst_26348)){
var statearr_26400_26436 = state_26366__$1;
(statearr_26400_26436[(1)] = (20));

} else {
var statearr_26401_26437 = state_26366__$1;
(statearr_26401_26437[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (10))){
var inst_26362 = (state_26366[(2)]);
var state_26366__$1 = state_26366;
var statearr_26402_26438 = state_26366__$1;
(statearr_26402_26438[(2)] = inst_26362);

(statearr_26402_26438[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (18))){
var inst_26340 = (state_26366[(16)]);
var state_26366__$1 = state_26366;
var statearr_26403_26439 = state_26366__$1;
(statearr_26403_26439[(2)] = inst_26340);

(statearr_26403_26439[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26367 === (8))){
var inst_26319 = (state_26366[(7)]);
var inst_26328 = (inst_26319 == null);
var state_26366__$1 = state_26366;
if(cljs.core.truth_(inst_26328)){
var statearr_26404_26440 = state_26366__$1;
(statearr_26404_26440[(1)] = (11));

} else {
var statearr_26405_26441 = state_26366__$1;
(statearr_26405_26441[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__25297__auto__ = null;
var cljs$core$async$mix_$_state_machine__25297__auto____0 = (function (){
var statearr_26406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26406[(0)] = cljs$core$async$mix_$_state_machine__25297__auto__);

(statearr_26406[(1)] = (1));

return statearr_26406;
});
var cljs$core$async$mix_$_state_machine__25297__auto____1 = (function (state_26366){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_26366);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e26407){var ex__25300__auto__ = e26407;
var statearr_26408_26442 = state_26366;
(statearr_26408_26442[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_26366[(4)]))){
var statearr_26409_26443 = state_26366;
(statearr_26409_26443[(1)] = cljs.core.first((state_26366[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__26444 = state_26366;
state_26366 = G__26444;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__25297__auto__ = function(state_26366){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__25297__auto____1.call(this,state_26366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__25297__auto____0;
cljs$core$async$mix_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__25297__auto____1;
return cljs$core$async$mix_$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_26410 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_26410[(6)] = c__25371__auto___26411);

return statearr_26410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_26447 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_26447(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_26448 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_26448(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_26449 = (function() {
var G__26450 = null;
var G__26450__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__26450__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__26450 = function(p,v){
switch(arguments.length){
case 1:
return G__26450__1.call(this,p);
case 2:
return G__26450__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__26450.cljs$core$IFn$_invoke$arity$1 = G__26450__1;
G__26450.cljs$core$IFn$_invoke$arity$2 = G__26450__2;
return G__26450;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__26446 = arguments.length;
switch (G__26446) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_26449.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_26449.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__26454 = arguments.length;
switch (G__26454) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__26452_SHARP_){
if(cljs.core.truth_((p1__26452_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__26452_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__26452_SHARP_.call(null,topic)))){
return p1__26452_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__26452_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26455 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26455 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta26456){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta26456 = meta26456;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26457,meta26456__$1){
var self__ = this;
var _26457__$1 = this;
return (new cljs.core.async.t_cljs$core$async26455(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta26456__$1));
}));

(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26457){
var self__ = this;
var _26457__$1 = this;
return self__.meta26456;
}));

(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async26455.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async26455.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta26456], null);
}));

(cljs.core.async.t_cljs$core$async26455.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26455.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26455");

(cljs.core.async.t_cljs$core$async26455.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async26455");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26455.
 */
cljs.core.async.__GT_t_cljs$core$async26455 = (function cljs$core$async$__GT_t_cljs$core$async26455(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26456){
return (new cljs.core.async.t_cljs$core$async26455(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26456));
});

}

return (new cljs.core.async.t_cljs$core$async26455(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25371__auto___26576 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_26529){
var state_val_26530 = (state_26529[(1)]);
if((state_val_26530 === (7))){
var inst_26525 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
var statearr_26531_26577 = state_26529__$1;
(statearr_26531_26577[(2)] = inst_26525);

(statearr_26531_26577[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (20))){
var state_26529__$1 = state_26529;
var statearr_26532_26578 = state_26529__$1;
(statearr_26532_26578[(2)] = null);

(statearr_26532_26578[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (1))){
var state_26529__$1 = state_26529;
var statearr_26533_26579 = state_26529__$1;
(statearr_26533_26579[(2)] = null);

(statearr_26533_26579[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (24))){
var inst_26508 = (state_26529[(7)]);
var inst_26517 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_26508);
var state_26529__$1 = state_26529;
var statearr_26534_26580 = state_26529__$1;
(statearr_26534_26580[(2)] = inst_26517);

(statearr_26534_26580[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (4))){
var inst_26460 = (state_26529[(8)]);
var inst_26460__$1 = (state_26529[(2)]);
var inst_26461 = (inst_26460__$1 == null);
var state_26529__$1 = (function (){var statearr_26535 = state_26529;
(statearr_26535[(8)] = inst_26460__$1);

return statearr_26535;
})();
if(cljs.core.truth_(inst_26461)){
var statearr_26536_26581 = state_26529__$1;
(statearr_26536_26581[(1)] = (5));

} else {
var statearr_26537_26582 = state_26529__$1;
(statearr_26537_26582[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (15))){
var inst_26502 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
var statearr_26538_26583 = state_26529__$1;
(statearr_26538_26583[(2)] = inst_26502);

(statearr_26538_26583[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (21))){
var inst_26522 = (state_26529[(2)]);
var state_26529__$1 = (function (){var statearr_26539 = state_26529;
(statearr_26539[(9)] = inst_26522);

return statearr_26539;
})();
var statearr_26540_26584 = state_26529__$1;
(statearr_26540_26584[(2)] = null);

(statearr_26540_26584[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (13))){
var inst_26484 = (state_26529[(10)]);
var inst_26486 = cljs.core.chunked_seq_QMARK_(inst_26484);
var state_26529__$1 = state_26529;
if(inst_26486){
var statearr_26541_26585 = state_26529__$1;
(statearr_26541_26585[(1)] = (16));

} else {
var statearr_26542_26586 = state_26529__$1;
(statearr_26542_26586[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (22))){
var inst_26514 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
if(cljs.core.truth_(inst_26514)){
var statearr_26543_26587 = state_26529__$1;
(statearr_26543_26587[(1)] = (23));

} else {
var statearr_26544_26588 = state_26529__$1;
(statearr_26544_26588[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (6))){
var inst_26460 = (state_26529[(8)]);
var inst_26510 = (state_26529[(11)]);
var inst_26508 = (state_26529[(7)]);
var inst_26508__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_26460) : topic_fn.call(null,inst_26460));
var inst_26509 = cljs.core.deref(mults);
var inst_26510__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26509,inst_26508__$1);
var state_26529__$1 = (function (){var statearr_26545 = state_26529;
(statearr_26545[(11)] = inst_26510__$1);

(statearr_26545[(7)] = inst_26508__$1);

return statearr_26545;
})();
if(cljs.core.truth_(inst_26510__$1)){
var statearr_26546_26589 = state_26529__$1;
(statearr_26546_26589[(1)] = (19));

} else {
var statearr_26547_26590 = state_26529__$1;
(statearr_26547_26590[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (25))){
var inst_26519 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
var statearr_26548_26591 = state_26529__$1;
(statearr_26548_26591[(2)] = inst_26519);

(statearr_26548_26591[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (17))){
var inst_26484 = (state_26529[(10)]);
var inst_26493 = cljs.core.first(inst_26484);
var inst_26494 = cljs.core.async.muxch_STAR_(inst_26493);
var inst_26495 = cljs.core.async.close_BANG_(inst_26494);
var inst_26496 = cljs.core.next(inst_26484);
var inst_26470 = inst_26496;
var inst_26471 = null;
var inst_26472 = (0);
var inst_26473 = (0);
var state_26529__$1 = (function (){var statearr_26549 = state_26529;
(statearr_26549[(12)] = inst_26473);

(statearr_26549[(13)] = inst_26472);

(statearr_26549[(14)] = inst_26495);

(statearr_26549[(15)] = inst_26470);

(statearr_26549[(16)] = inst_26471);

return statearr_26549;
})();
var statearr_26550_26592 = state_26529__$1;
(statearr_26550_26592[(2)] = null);

(statearr_26550_26592[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (3))){
var inst_26527 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26529__$1,inst_26527);
} else {
if((state_val_26530 === (12))){
var inst_26504 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
var statearr_26551_26593 = state_26529__$1;
(statearr_26551_26593[(2)] = inst_26504);

(statearr_26551_26593[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (2))){
var state_26529__$1 = state_26529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26529__$1,(4),ch);
} else {
if((state_val_26530 === (23))){
var state_26529__$1 = state_26529;
var statearr_26552_26594 = state_26529__$1;
(statearr_26552_26594[(2)] = null);

(statearr_26552_26594[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (19))){
var inst_26460 = (state_26529[(8)]);
var inst_26510 = (state_26529[(11)]);
var inst_26512 = cljs.core.async.muxch_STAR_(inst_26510);
var state_26529__$1 = state_26529;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26529__$1,(22),inst_26512,inst_26460);
} else {
if((state_val_26530 === (11))){
var inst_26470 = (state_26529[(15)]);
var inst_26484 = (state_26529[(10)]);
var inst_26484__$1 = cljs.core.seq(inst_26470);
var state_26529__$1 = (function (){var statearr_26553 = state_26529;
(statearr_26553[(10)] = inst_26484__$1);

return statearr_26553;
})();
if(inst_26484__$1){
var statearr_26554_26595 = state_26529__$1;
(statearr_26554_26595[(1)] = (13));

} else {
var statearr_26555_26596 = state_26529__$1;
(statearr_26555_26596[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (9))){
var inst_26506 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
var statearr_26556_26597 = state_26529__$1;
(statearr_26556_26597[(2)] = inst_26506);

(statearr_26556_26597[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (5))){
var inst_26467 = cljs.core.deref(mults);
var inst_26468 = cljs.core.vals(inst_26467);
var inst_26469 = cljs.core.seq(inst_26468);
var inst_26470 = inst_26469;
var inst_26471 = null;
var inst_26472 = (0);
var inst_26473 = (0);
var state_26529__$1 = (function (){var statearr_26557 = state_26529;
(statearr_26557[(12)] = inst_26473);

(statearr_26557[(13)] = inst_26472);

(statearr_26557[(15)] = inst_26470);

(statearr_26557[(16)] = inst_26471);

return statearr_26557;
})();
var statearr_26558_26598 = state_26529__$1;
(statearr_26558_26598[(2)] = null);

(statearr_26558_26598[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (14))){
var state_26529__$1 = state_26529;
var statearr_26562_26599 = state_26529__$1;
(statearr_26562_26599[(2)] = null);

(statearr_26562_26599[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (16))){
var inst_26484 = (state_26529[(10)]);
var inst_26488 = cljs.core.chunk_first(inst_26484);
var inst_26489 = cljs.core.chunk_rest(inst_26484);
var inst_26490 = cljs.core.count(inst_26488);
var inst_26470 = inst_26489;
var inst_26471 = inst_26488;
var inst_26472 = inst_26490;
var inst_26473 = (0);
var state_26529__$1 = (function (){var statearr_26563 = state_26529;
(statearr_26563[(12)] = inst_26473);

(statearr_26563[(13)] = inst_26472);

(statearr_26563[(15)] = inst_26470);

(statearr_26563[(16)] = inst_26471);

return statearr_26563;
})();
var statearr_26564_26600 = state_26529__$1;
(statearr_26564_26600[(2)] = null);

(statearr_26564_26600[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (10))){
var inst_26473 = (state_26529[(12)]);
var inst_26472 = (state_26529[(13)]);
var inst_26470 = (state_26529[(15)]);
var inst_26471 = (state_26529[(16)]);
var inst_26478 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_26471,inst_26473);
var inst_26479 = cljs.core.async.muxch_STAR_(inst_26478);
var inst_26480 = cljs.core.async.close_BANG_(inst_26479);
var inst_26481 = (inst_26473 + (1));
var tmp26559 = inst_26472;
var tmp26560 = inst_26470;
var tmp26561 = inst_26471;
var inst_26470__$1 = tmp26560;
var inst_26471__$1 = tmp26561;
var inst_26472__$1 = tmp26559;
var inst_26473__$1 = inst_26481;
var state_26529__$1 = (function (){var statearr_26565 = state_26529;
(statearr_26565[(12)] = inst_26473__$1);

(statearr_26565[(13)] = inst_26472__$1);

(statearr_26565[(15)] = inst_26470__$1);

(statearr_26565[(17)] = inst_26480);

(statearr_26565[(16)] = inst_26471__$1);

return statearr_26565;
})();
var statearr_26566_26601 = state_26529__$1;
(statearr_26566_26601[(2)] = null);

(statearr_26566_26601[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (18))){
var inst_26499 = (state_26529[(2)]);
var state_26529__$1 = state_26529;
var statearr_26567_26602 = state_26529__$1;
(statearr_26567_26602[(2)] = inst_26499);

(statearr_26567_26602[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26530 === (8))){
var inst_26473 = (state_26529[(12)]);
var inst_26472 = (state_26529[(13)]);
var inst_26475 = (inst_26473 < inst_26472);
var inst_26476 = inst_26475;
var state_26529__$1 = state_26529;
if(cljs.core.truth_(inst_26476)){
var statearr_26568_26603 = state_26529__$1;
(statearr_26568_26603[(1)] = (10));

} else {
var statearr_26569_26604 = state_26529__$1;
(statearr_26569_26604[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_26570 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26570[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_26570[(1)] = (1));

return statearr_26570;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_26529){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_26529);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e26571){var ex__25300__auto__ = e26571;
var statearr_26572_26605 = state_26529;
(statearr_26572_26605[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_26529[(4)]))){
var statearr_26573_26606 = state_26529;
(statearr_26573_26606[(1)] = cljs.core.first((state_26529[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__26607 = state_26529;
state_26529 = G__26607;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_26529){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_26529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_26574 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_26574[(6)] = c__25371__auto___26576);

return statearr_26574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__26609 = arguments.length;
switch (G__26609) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__26612 = arguments.length;
switch (G__26612) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__26615 = arguments.length;
switch (G__26615) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__25371__auto___26693 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_26658){
var state_val_26659 = (state_26658[(1)]);
if((state_val_26659 === (7))){
var state_26658__$1 = state_26658;
var statearr_26660_26694 = state_26658__$1;
(statearr_26660_26694[(2)] = null);

(statearr_26660_26694[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (1))){
var state_26658__$1 = state_26658;
var statearr_26661_26695 = state_26658__$1;
(statearr_26661_26695[(2)] = null);

(statearr_26661_26695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (4))){
var inst_26619 = (state_26658[(7)]);
var inst_26618 = (state_26658[(8)]);
var inst_26621 = (inst_26619 < inst_26618);
var state_26658__$1 = state_26658;
if(cljs.core.truth_(inst_26621)){
var statearr_26662_26696 = state_26658__$1;
(statearr_26662_26696[(1)] = (6));

} else {
var statearr_26663_26697 = state_26658__$1;
(statearr_26663_26697[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (15))){
var inst_26644 = (state_26658[(9)]);
var inst_26649 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_26644);
var state_26658__$1 = state_26658;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26658__$1,(17),out,inst_26649);
} else {
if((state_val_26659 === (13))){
var inst_26644 = (state_26658[(9)]);
var inst_26644__$1 = (state_26658[(2)]);
var inst_26645 = cljs.core.some(cljs.core.nil_QMARK_,inst_26644__$1);
var state_26658__$1 = (function (){var statearr_26664 = state_26658;
(statearr_26664[(9)] = inst_26644__$1);

return statearr_26664;
})();
if(cljs.core.truth_(inst_26645)){
var statearr_26665_26698 = state_26658__$1;
(statearr_26665_26698[(1)] = (14));

} else {
var statearr_26666_26699 = state_26658__$1;
(statearr_26666_26699[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (6))){
var state_26658__$1 = state_26658;
var statearr_26667_26700 = state_26658__$1;
(statearr_26667_26700[(2)] = null);

(statearr_26667_26700[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (17))){
var inst_26651 = (state_26658[(2)]);
var state_26658__$1 = (function (){var statearr_26669 = state_26658;
(statearr_26669[(10)] = inst_26651);

return statearr_26669;
})();
var statearr_26670_26701 = state_26658__$1;
(statearr_26670_26701[(2)] = null);

(statearr_26670_26701[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (3))){
var inst_26656 = (state_26658[(2)]);
var state_26658__$1 = state_26658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26658__$1,inst_26656);
} else {
if((state_val_26659 === (12))){
var _ = (function (){var statearr_26671 = state_26658;
(statearr_26671[(4)] = cljs.core.rest((state_26658[(4)])));

return statearr_26671;
})();
var state_26658__$1 = state_26658;
var ex26668 = (state_26658__$1[(2)]);
var statearr_26672_26702 = state_26658__$1;
(statearr_26672_26702[(5)] = ex26668);


if((ex26668 instanceof Object)){
var statearr_26673_26703 = state_26658__$1;
(statearr_26673_26703[(1)] = (11));

(statearr_26673_26703[(5)] = null);

} else {
throw ex26668;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (2))){
var inst_26617 = cljs.core.reset_BANG_(dctr,cnt);
var inst_26618 = cnt;
var inst_26619 = (0);
var state_26658__$1 = (function (){var statearr_26674 = state_26658;
(statearr_26674[(7)] = inst_26619);

(statearr_26674[(8)] = inst_26618);

(statearr_26674[(11)] = inst_26617);

return statearr_26674;
})();
var statearr_26675_26704 = state_26658__$1;
(statearr_26675_26704[(2)] = null);

(statearr_26675_26704[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (11))){
var inst_26623 = (state_26658[(2)]);
var inst_26624 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_26658__$1 = (function (){var statearr_26676 = state_26658;
(statearr_26676[(12)] = inst_26623);

return statearr_26676;
})();
var statearr_26677_26705 = state_26658__$1;
(statearr_26677_26705[(2)] = inst_26624);

(statearr_26677_26705[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (9))){
var inst_26619 = (state_26658[(7)]);
var _ = (function (){var statearr_26678 = state_26658;
(statearr_26678[(4)] = cljs.core.cons((12),(state_26658[(4)])));

return statearr_26678;
})();
var inst_26630 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_26619) : chs__$1.call(null,inst_26619));
var inst_26631 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_26619) : done.call(null,inst_26619));
var inst_26632 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26630,inst_26631);
var ___$1 = (function (){var statearr_26679 = state_26658;
(statearr_26679[(4)] = cljs.core.rest((state_26658[(4)])));

return statearr_26679;
})();
var state_26658__$1 = state_26658;
var statearr_26680_26706 = state_26658__$1;
(statearr_26680_26706[(2)] = inst_26632);

(statearr_26680_26706[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (5))){
var inst_26642 = (state_26658[(2)]);
var state_26658__$1 = (function (){var statearr_26681 = state_26658;
(statearr_26681[(13)] = inst_26642);

return statearr_26681;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26658__$1,(13),dchan);
} else {
if((state_val_26659 === (14))){
var inst_26647 = cljs.core.async.close_BANG_(out);
var state_26658__$1 = state_26658;
var statearr_26682_26707 = state_26658__$1;
(statearr_26682_26707[(2)] = inst_26647);

(statearr_26682_26707[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (16))){
var inst_26654 = (state_26658[(2)]);
var state_26658__$1 = state_26658;
var statearr_26683_26708 = state_26658__$1;
(statearr_26683_26708[(2)] = inst_26654);

(statearr_26683_26708[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (10))){
var inst_26619 = (state_26658[(7)]);
var inst_26635 = (state_26658[(2)]);
var inst_26636 = (inst_26619 + (1));
var inst_26619__$1 = inst_26636;
var state_26658__$1 = (function (){var statearr_26684 = state_26658;
(statearr_26684[(7)] = inst_26619__$1);

(statearr_26684[(14)] = inst_26635);

return statearr_26684;
})();
var statearr_26685_26709 = state_26658__$1;
(statearr_26685_26709[(2)] = null);

(statearr_26685_26709[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26659 === (8))){
var inst_26640 = (state_26658[(2)]);
var state_26658__$1 = state_26658;
var statearr_26686_26710 = state_26658__$1;
(statearr_26686_26710[(2)] = inst_26640);

(statearr_26686_26710[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_26687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26687[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_26687[(1)] = (1));

return statearr_26687;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_26658){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_26658);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e26688){var ex__25300__auto__ = e26688;
var statearr_26689_26711 = state_26658;
(statearr_26689_26711[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_26658[(4)]))){
var statearr_26690_26712 = state_26658;
(statearr_26690_26712[(1)] = cljs.core.first((state_26658[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__26713 = state_26658;
state_26658 = G__26713;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_26658){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_26658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_26691 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_26691[(6)] = c__25371__auto___26693);

return statearr_26691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__26716 = arguments.length;
switch (G__26716) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25371__auto___26771 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_26748){
var state_val_26749 = (state_26748[(1)]);
if((state_val_26749 === (7))){
var inst_26728 = (state_26748[(7)]);
var inst_26727 = (state_26748[(8)]);
var inst_26727__$1 = (state_26748[(2)]);
var inst_26728__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26727__$1,(0),null);
var inst_26729 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26727__$1,(1),null);
var inst_26730 = (inst_26728__$1 == null);
var state_26748__$1 = (function (){var statearr_26750 = state_26748;
(statearr_26750[(7)] = inst_26728__$1);

(statearr_26750[(8)] = inst_26727__$1);

(statearr_26750[(9)] = inst_26729);

return statearr_26750;
})();
if(cljs.core.truth_(inst_26730)){
var statearr_26751_26772 = state_26748__$1;
(statearr_26751_26772[(1)] = (8));

} else {
var statearr_26752_26773 = state_26748__$1;
(statearr_26752_26773[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26749 === (1))){
var inst_26717 = cljs.core.vec(chs);
var inst_26718 = inst_26717;
var state_26748__$1 = (function (){var statearr_26753 = state_26748;
(statearr_26753[(10)] = inst_26718);

return statearr_26753;
})();
var statearr_26754_26774 = state_26748__$1;
(statearr_26754_26774[(2)] = null);

(statearr_26754_26774[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26749 === (4))){
var inst_26718 = (state_26748[(10)]);
var state_26748__$1 = state_26748;
return cljs.core.async.ioc_alts_BANG_(state_26748__$1,(7),inst_26718);
} else {
if((state_val_26749 === (6))){
var inst_26744 = (state_26748[(2)]);
var state_26748__$1 = state_26748;
var statearr_26755_26775 = state_26748__$1;
(statearr_26755_26775[(2)] = inst_26744);

(statearr_26755_26775[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26749 === (3))){
var inst_26746 = (state_26748[(2)]);
var state_26748__$1 = state_26748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26748__$1,inst_26746);
} else {
if((state_val_26749 === (2))){
var inst_26718 = (state_26748[(10)]);
var inst_26720 = cljs.core.count(inst_26718);
var inst_26721 = (inst_26720 > (0));
var state_26748__$1 = state_26748;
if(cljs.core.truth_(inst_26721)){
var statearr_26757_26776 = state_26748__$1;
(statearr_26757_26776[(1)] = (4));

} else {
var statearr_26758_26777 = state_26748__$1;
(statearr_26758_26777[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26749 === (11))){
var inst_26718 = (state_26748[(10)]);
var inst_26737 = (state_26748[(2)]);
var tmp26756 = inst_26718;
var inst_26718__$1 = tmp26756;
var state_26748__$1 = (function (){var statearr_26759 = state_26748;
(statearr_26759[(11)] = inst_26737);

(statearr_26759[(10)] = inst_26718__$1);

return statearr_26759;
})();
var statearr_26760_26778 = state_26748__$1;
(statearr_26760_26778[(2)] = null);

(statearr_26760_26778[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26749 === (9))){
var inst_26728 = (state_26748[(7)]);
var state_26748__$1 = state_26748;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26748__$1,(11),out,inst_26728);
} else {
if((state_val_26749 === (5))){
var inst_26742 = cljs.core.async.close_BANG_(out);
var state_26748__$1 = state_26748;
var statearr_26761_26779 = state_26748__$1;
(statearr_26761_26779[(2)] = inst_26742);

(statearr_26761_26779[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26749 === (10))){
var inst_26740 = (state_26748[(2)]);
var state_26748__$1 = state_26748;
var statearr_26762_26780 = state_26748__$1;
(statearr_26762_26780[(2)] = inst_26740);

(statearr_26762_26780[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26749 === (8))){
var inst_26728 = (state_26748[(7)]);
var inst_26727 = (state_26748[(8)]);
var inst_26729 = (state_26748[(9)]);
var inst_26718 = (state_26748[(10)]);
var inst_26732 = (function (){var cs = inst_26718;
var vec__26723 = inst_26727;
var v = inst_26728;
var c = inst_26729;
return (function (p1__26714_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__26714_SHARP_);
});
})();
var inst_26733 = cljs.core.filterv(inst_26732,inst_26718);
var inst_26718__$1 = inst_26733;
var state_26748__$1 = (function (){var statearr_26763 = state_26748;
(statearr_26763[(10)] = inst_26718__$1);

return statearr_26763;
})();
var statearr_26764_26781 = state_26748__$1;
(statearr_26764_26781[(2)] = null);

(statearr_26764_26781[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_26765 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26765[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_26765[(1)] = (1));

return statearr_26765;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_26748){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_26748);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e26766){var ex__25300__auto__ = e26766;
var statearr_26767_26782 = state_26748;
(statearr_26767_26782[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_26748[(4)]))){
var statearr_26768_26783 = state_26748;
(statearr_26768_26783[(1)] = cljs.core.first((state_26748[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__26784 = state_26748;
state_26748 = G__26784;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_26748){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_26748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_26769 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_26769[(6)] = c__25371__auto___26771);

return statearr_26769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__26786 = arguments.length;
switch (G__26786) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25371__auto___26832 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_26810){
var state_val_26811 = (state_26810[(1)]);
if((state_val_26811 === (7))){
var inst_26792 = (state_26810[(7)]);
var inst_26792__$1 = (state_26810[(2)]);
var inst_26793 = (inst_26792__$1 == null);
var inst_26794 = cljs.core.not(inst_26793);
var state_26810__$1 = (function (){var statearr_26812 = state_26810;
(statearr_26812[(7)] = inst_26792__$1);

return statearr_26812;
})();
if(inst_26794){
var statearr_26813_26833 = state_26810__$1;
(statearr_26813_26833[(1)] = (8));

} else {
var statearr_26814_26834 = state_26810__$1;
(statearr_26814_26834[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26811 === (1))){
var inst_26787 = (0);
var state_26810__$1 = (function (){var statearr_26815 = state_26810;
(statearr_26815[(8)] = inst_26787);

return statearr_26815;
})();
var statearr_26816_26835 = state_26810__$1;
(statearr_26816_26835[(2)] = null);

(statearr_26816_26835[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26811 === (4))){
var state_26810__$1 = state_26810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26810__$1,(7),ch);
} else {
if((state_val_26811 === (6))){
var inst_26805 = (state_26810[(2)]);
var state_26810__$1 = state_26810;
var statearr_26817_26836 = state_26810__$1;
(statearr_26817_26836[(2)] = inst_26805);

(statearr_26817_26836[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26811 === (3))){
var inst_26807 = (state_26810[(2)]);
var inst_26808 = cljs.core.async.close_BANG_(out);
var state_26810__$1 = (function (){var statearr_26818 = state_26810;
(statearr_26818[(9)] = inst_26807);

return statearr_26818;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_26810__$1,inst_26808);
} else {
if((state_val_26811 === (2))){
var inst_26787 = (state_26810[(8)]);
var inst_26789 = (inst_26787 < n);
var state_26810__$1 = state_26810;
if(cljs.core.truth_(inst_26789)){
var statearr_26819_26837 = state_26810__$1;
(statearr_26819_26837[(1)] = (4));

} else {
var statearr_26820_26838 = state_26810__$1;
(statearr_26820_26838[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26811 === (11))){
var inst_26787 = (state_26810[(8)]);
var inst_26797 = (state_26810[(2)]);
var inst_26798 = (inst_26787 + (1));
var inst_26787__$1 = inst_26798;
var state_26810__$1 = (function (){var statearr_26821 = state_26810;
(statearr_26821[(8)] = inst_26787__$1);

(statearr_26821[(10)] = inst_26797);

return statearr_26821;
})();
var statearr_26822_26839 = state_26810__$1;
(statearr_26822_26839[(2)] = null);

(statearr_26822_26839[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26811 === (9))){
var state_26810__$1 = state_26810;
var statearr_26823_26840 = state_26810__$1;
(statearr_26823_26840[(2)] = null);

(statearr_26823_26840[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26811 === (5))){
var state_26810__$1 = state_26810;
var statearr_26824_26841 = state_26810__$1;
(statearr_26824_26841[(2)] = null);

(statearr_26824_26841[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26811 === (10))){
var inst_26802 = (state_26810[(2)]);
var state_26810__$1 = state_26810;
var statearr_26825_26842 = state_26810__$1;
(statearr_26825_26842[(2)] = inst_26802);

(statearr_26825_26842[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26811 === (8))){
var inst_26792 = (state_26810[(7)]);
var state_26810__$1 = state_26810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26810__$1,(11),out,inst_26792);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_26826 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26826[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_26826[(1)] = (1));

return statearr_26826;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_26810){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_26810);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e26827){var ex__25300__auto__ = e26827;
var statearr_26828_26843 = state_26810;
(statearr_26828_26843[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_26810[(4)]))){
var statearr_26829_26844 = state_26810;
(statearr_26829_26844[(1)] = cljs.core.first((state_26810[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__26845 = state_26810;
state_26810 = G__26845;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_26810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_26810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_26830 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_26830[(6)] = c__25371__auto___26832);

return statearr_26830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26847 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26847 = (function (f,ch,meta26848){
this.f = f;
this.ch = ch;
this.meta26848 = meta26848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26849,meta26848__$1){
var self__ = this;
var _26849__$1 = this;
return (new cljs.core.async.t_cljs$core$async26847(self__.f,self__.ch,meta26848__$1));
}));

(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26849){
var self__ = this;
var _26849__$1 = this;
return self__.meta26848;
}));

(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26850 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26850 = (function (f,ch,meta26848,_,fn1,meta26851){
this.f = f;
this.ch = ch;
this.meta26848 = meta26848;
this._ = _;
this.fn1 = fn1;
this.meta26851 = meta26851;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26850.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26852,meta26851__$1){
var self__ = this;
var _26852__$1 = this;
return (new cljs.core.async.t_cljs$core$async26850(self__.f,self__.ch,self__.meta26848,self__._,self__.fn1,meta26851__$1));
}));

(cljs.core.async.t_cljs$core$async26850.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26852){
var self__ = this;
var _26852__$1 = this;
return self__.meta26851;
}));

(cljs.core.async.t_cljs$core$async26850.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26850.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async26850.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async26850.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__26846_SHARP_){
var G__26853 = (((p1__26846_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__26846_SHARP_) : self__.f.call(null,p1__26846_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__26853) : f1.call(null,G__26853));
});
}));

(cljs.core.async.t_cljs$core$async26850.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta26848,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async26847], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta26851], null);
}));

(cljs.core.async.t_cljs$core$async26850.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26850.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26850");

(cljs.core.async.t_cljs$core$async26850.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async26850");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26850.
 */
cljs.core.async.__GT_t_cljs$core$async26850 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async26850(f__$1,ch__$1,meta26848__$1,___$2,fn1__$1,meta26851){
return (new cljs.core.async.t_cljs$core$async26850(f__$1,ch__$1,meta26848__$1,___$2,fn1__$1,meta26851));
});

}

return (new cljs.core.async.t_cljs$core$async26850(self__.f,self__.ch,self__.meta26848,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__26854 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__26854) : self__.f.call(null,G__26854));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26847.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async26847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta26848], null);
}));

(cljs.core.async.t_cljs$core$async26847.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26847.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26847");

(cljs.core.async.t_cljs$core$async26847.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async26847");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26847.
 */
cljs.core.async.__GT_t_cljs$core$async26847 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async26847(f__$1,ch__$1,meta26848){
return (new cljs.core.async.t_cljs$core$async26847(f__$1,ch__$1,meta26848));
});

}

return (new cljs.core.async.t_cljs$core$async26847(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26855 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26855 = (function (f,ch,meta26856){
this.f = f;
this.ch = ch;
this.meta26856 = meta26856;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26855.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26857,meta26856__$1){
var self__ = this;
var _26857__$1 = this;
return (new cljs.core.async.t_cljs$core$async26855(self__.f,self__.ch,meta26856__$1));
}));

(cljs.core.async.t_cljs$core$async26855.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26857){
var self__ = this;
var _26857__$1 = this;
return self__.meta26856;
}));

(cljs.core.async.t_cljs$core$async26855.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26855.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async26855.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26855.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async26855.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26855.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async26855.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta26856], null);
}));

(cljs.core.async.t_cljs$core$async26855.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26855.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26855");

(cljs.core.async.t_cljs$core$async26855.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async26855");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26855.
 */
cljs.core.async.__GT_t_cljs$core$async26855 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async26855(f__$1,ch__$1,meta26856){
return (new cljs.core.async.t_cljs$core$async26855(f__$1,ch__$1,meta26856));
});

}

return (new cljs.core.async.t_cljs$core$async26855(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26858 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26858 = (function (p,ch,meta26859){
this.p = p;
this.ch = ch;
this.meta26859 = meta26859;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26860,meta26859__$1){
var self__ = this;
var _26860__$1 = this;
return (new cljs.core.async.t_cljs$core$async26858(self__.p,self__.ch,meta26859__$1));
}));

(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26860){
var self__ = this;
var _26860__$1 = this;
return self__.meta26859;
}));

(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26858.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async26858.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta26859], null);
}));

(cljs.core.async.t_cljs$core$async26858.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26858.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26858");

(cljs.core.async.t_cljs$core$async26858.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async26858");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26858.
 */
cljs.core.async.__GT_t_cljs$core$async26858 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async26858(p__$1,ch__$1,meta26859){
return (new cljs.core.async.t_cljs$core$async26858(p__$1,ch__$1,meta26859));
});

}

return (new cljs.core.async.t_cljs$core$async26858(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__26862 = arguments.length;
switch (G__26862) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25371__auto___26903 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_26883){
var state_val_26884 = (state_26883[(1)]);
if((state_val_26884 === (7))){
var inst_26879 = (state_26883[(2)]);
var state_26883__$1 = state_26883;
var statearr_26885_26904 = state_26883__$1;
(statearr_26885_26904[(2)] = inst_26879);

(statearr_26885_26904[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26884 === (1))){
var state_26883__$1 = state_26883;
var statearr_26886_26905 = state_26883__$1;
(statearr_26886_26905[(2)] = null);

(statearr_26886_26905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26884 === (4))){
var inst_26865 = (state_26883[(7)]);
var inst_26865__$1 = (state_26883[(2)]);
var inst_26866 = (inst_26865__$1 == null);
var state_26883__$1 = (function (){var statearr_26887 = state_26883;
(statearr_26887[(7)] = inst_26865__$1);

return statearr_26887;
})();
if(cljs.core.truth_(inst_26866)){
var statearr_26888_26906 = state_26883__$1;
(statearr_26888_26906[(1)] = (5));

} else {
var statearr_26889_26907 = state_26883__$1;
(statearr_26889_26907[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26884 === (6))){
var inst_26865 = (state_26883[(7)]);
var inst_26870 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_26865) : p.call(null,inst_26865));
var state_26883__$1 = state_26883;
if(cljs.core.truth_(inst_26870)){
var statearr_26890_26908 = state_26883__$1;
(statearr_26890_26908[(1)] = (8));

} else {
var statearr_26891_26909 = state_26883__$1;
(statearr_26891_26909[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26884 === (3))){
var inst_26881 = (state_26883[(2)]);
var state_26883__$1 = state_26883;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26883__$1,inst_26881);
} else {
if((state_val_26884 === (2))){
var state_26883__$1 = state_26883;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26883__$1,(4),ch);
} else {
if((state_val_26884 === (11))){
var inst_26873 = (state_26883[(2)]);
var state_26883__$1 = state_26883;
var statearr_26892_26910 = state_26883__$1;
(statearr_26892_26910[(2)] = inst_26873);

(statearr_26892_26910[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26884 === (9))){
var state_26883__$1 = state_26883;
var statearr_26893_26911 = state_26883__$1;
(statearr_26893_26911[(2)] = null);

(statearr_26893_26911[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26884 === (5))){
var inst_26868 = cljs.core.async.close_BANG_(out);
var state_26883__$1 = state_26883;
var statearr_26894_26912 = state_26883__$1;
(statearr_26894_26912[(2)] = inst_26868);

(statearr_26894_26912[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26884 === (10))){
var inst_26876 = (state_26883[(2)]);
var state_26883__$1 = (function (){var statearr_26895 = state_26883;
(statearr_26895[(8)] = inst_26876);

return statearr_26895;
})();
var statearr_26896_26913 = state_26883__$1;
(statearr_26896_26913[(2)] = null);

(statearr_26896_26913[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26884 === (8))){
var inst_26865 = (state_26883[(7)]);
var state_26883__$1 = state_26883;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26883__$1,(11),out,inst_26865);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_26897 = [null,null,null,null,null,null,null,null,null];
(statearr_26897[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_26897[(1)] = (1));

return statearr_26897;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_26883){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_26883);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e26898){var ex__25300__auto__ = e26898;
var statearr_26899_26914 = state_26883;
(statearr_26899_26914[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_26883[(4)]))){
var statearr_26900_26915 = state_26883;
(statearr_26900_26915[(1)] = cljs.core.first((state_26883[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__26916 = state_26883;
state_26883 = G__26916;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_26883){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_26883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_26901 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_26901[(6)] = c__25371__auto___26903);

return statearr_26901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__26918 = arguments.length;
switch (G__26918) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_26981){
var state_val_26982 = (state_26981[(1)]);
if((state_val_26982 === (7))){
var inst_26977 = (state_26981[(2)]);
var state_26981__$1 = state_26981;
var statearr_26983_27022 = state_26981__$1;
(statearr_26983_27022[(2)] = inst_26977);

(statearr_26983_27022[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (20))){
var inst_26947 = (state_26981[(7)]);
var inst_26958 = (state_26981[(2)]);
var inst_26959 = cljs.core.next(inst_26947);
var inst_26933 = inst_26959;
var inst_26934 = null;
var inst_26935 = (0);
var inst_26936 = (0);
var state_26981__$1 = (function (){var statearr_26984 = state_26981;
(statearr_26984[(8)] = inst_26934);

(statearr_26984[(9)] = inst_26933);

(statearr_26984[(10)] = inst_26958);

(statearr_26984[(11)] = inst_26936);

(statearr_26984[(12)] = inst_26935);

return statearr_26984;
})();
var statearr_26985_27023 = state_26981__$1;
(statearr_26985_27023[(2)] = null);

(statearr_26985_27023[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (1))){
var state_26981__$1 = state_26981;
var statearr_26986_27024 = state_26981__$1;
(statearr_26986_27024[(2)] = null);

(statearr_26986_27024[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (4))){
var inst_26922 = (state_26981[(13)]);
var inst_26922__$1 = (state_26981[(2)]);
var inst_26923 = (inst_26922__$1 == null);
var state_26981__$1 = (function (){var statearr_26987 = state_26981;
(statearr_26987[(13)] = inst_26922__$1);

return statearr_26987;
})();
if(cljs.core.truth_(inst_26923)){
var statearr_26988_27025 = state_26981__$1;
(statearr_26988_27025[(1)] = (5));

} else {
var statearr_26989_27026 = state_26981__$1;
(statearr_26989_27026[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (15))){
var state_26981__$1 = state_26981;
var statearr_26993_27027 = state_26981__$1;
(statearr_26993_27027[(2)] = null);

(statearr_26993_27027[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (21))){
var state_26981__$1 = state_26981;
var statearr_26994_27028 = state_26981__$1;
(statearr_26994_27028[(2)] = null);

(statearr_26994_27028[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (13))){
var inst_26934 = (state_26981[(8)]);
var inst_26933 = (state_26981[(9)]);
var inst_26936 = (state_26981[(11)]);
var inst_26935 = (state_26981[(12)]);
var inst_26943 = (state_26981[(2)]);
var inst_26944 = (inst_26936 + (1));
var tmp26990 = inst_26934;
var tmp26991 = inst_26933;
var tmp26992 = inst_26935;
var inst_26933__$1 = tmp26991;
var inst_26934__$1 = tmp26990;
var inst_26935__$1 = tmp26992;
var inst_26936__$1 = inst_26944;
var state_26981__$1 = (function (){var statearr_26995 = state_26981;
(statearr_26995[(14)] = inst_26943);

(statearr_26995[(8)] = inst_26934__$1);

(statearr_26995[(9)] = inst_26933__$1);

(statearr_26995[(11)] = inst_26936__$1);

(statearr_26995[(12)] = inst_26935__$1);

return statearr_26995;
})();
var statearr_26996_27029 = state_26981__$1;
(statearr_26996_27029[(2)] = null);

(statearr_26996_27029[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (22))){
var state_26981__$1 = state_26981;
var statearr_26997_27030 = state_26981__$1;
(statearr_26997_27030[(2)] = null);

(statearr_26997_27030[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (6))){
var inst_26922 = (state_26981[(13)]);
var inst_26931 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_26922) : f.call(null,inst_26922));
var inst_26932 = cljs.core.seq(inst_26931);
var inst_26933 = inst_26932;
var inst_26934 = null;
var inst_26935 = (0);
var inst_26936 = (0);
var state_26981__$1 = (function (){var statearr_26998 = state_26981;
(statearr_26998[(8)] = inst_26934);

(statearr_26998[(9)] = inst_26933);

(statearr_26998[(11)] = inst_26936);

(statearr_26998[(12)] = inst_26935);

return statearr_26998;
})();
var statearr_26999_27031 = state_26981__$1;
(statearr_26999_27031[(2)] = null);

(statearr_26999_27031[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (17))){
var inst_26947 = (state_26981[(7)]);
var inst_26951 = cljs.core.chunk_first(inst_26947);
var inst_26952 = cljs.core.chunk_rest(inst_26947);
var inst_26953 = cljs.core.count(inst_26951);
var inst_26933 = inst_26952;
var inst_26934 = inst_26951;
var inst_26935 = inst_26953;
var inst_26936 = (0);
var state_26981__$1 = (function (){var statearr_27000 = state_26981;
(statearr_27000[(8)] = inst_26934);

(statearr_27000[(9)] = inst_26933);

(statearr_27000[(11)] = inst_26936);

(statearr_27000[(12)] = inst_26935);

return statearr_27000;
})();
var statearr_27001_27032 = state_26981__$1;
(statearr_27001_27032[(2)] = null);

(statearr_27001_27032[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (3))){
var inst_26979 = (state_26981[(2)]);
var state_26981__$1 = state_26981;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26981__$1,inst_26979);
} else {
if((state_val_26982 === (12))){
var inst_26967 = (state_26981[(2)]);
var state_26981__$1 = state_26981;
var statearr_27002_27033 = state_26981__$1;
(statearr_27002_27033[(2)] = inst_26967);

(statearr_27002_27033[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (2))){
var state_26981__$1 = state_26981;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26981__$1,(4),in$);
} else {
if((state_val_26982 === (23))){
var inst_26975 = (state_26981[(2)]);
var state_26981__$1 = state_26981;
var statearr_27003_27034 = state_26981__$1;
(statearr_27003_27034[(2)] = inst_26975);

(statearr_27003_27034[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (19))){
var inst_26962 = (state_26981[(2)]);
var state_26981__$1 = state_26981;
var statearr_27004_27035 = state_26981__$1;
(statearr_27004_27035[(2)] = inst_26962);

(statearr_27004_27035[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (11))){
var inst_26947 = (state_26981[(7)]);
var inst_26933 = (state_26981[(9)]);
var inst_26947__$1 = cljs.core.seq(inst_26933);
var state_26981__$1 = (function (){var statearr_27005 = state_26981;
(statearr_27005[(7)] = inst_26947__$1);

return statearr_27005;
})();
if(inst_26947__$1){
var statearr_27006_27036 = state_26981__$1;
(statearr_27006_27036[(1)] = (14));

} else {
var statearr_27007_27037 = state_26981__$1;
(statearr_27007_27037[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (9))){
var inst_26969 = (state_26981[(2)]);
var inst_26970 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_26981__$1 = (function (){var statearr_27008 = state_26981;
(statearr_27008[(15)] = inst_26969);

return statearr_27008;
})();
if(cljs.core.truth_(inst_26970)){
var statearr_27009_27038 = state_26981__$1;
(statearr_27009_27038[(1)] = (21));

} else {
var statearr_27010_27039 = state_26981__$1;
(statearr_27010_27039[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (5))){
var inst_26925 = cljs.core.async.close_BANG_(out);
var state_26981__$1 = state_26981;
var statearr_27011_27040 = state_26981__$1;
(statearr_27011_27040[(2)] = inst_26925);

(statearr_27011_27040[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (14))){
var inst_26947 = (state_26981[(7)]);
var inst_26949 = cljs.core.chunked_seq_QMARK_(inst_26947);
var state_26981__$1 = state_26981;
if(inst_26949){
var statearr_27012_27041 = state_26981__$1;
(statearr_27012_27041[(1)] = (17));

} else {
var statearr_27013_27042 = state_26981__$1;
(statearr_27013_27042[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (16))){
var inst_26965 = (state_26981[(2)]);
var state_26981__$1 = state_26981;
var statearr_27014_27043 = state_26981__$1;
(statearr_27014_27043[(2)] = inst_26965);

(statearr_27014_27043[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26982 === (10))){
var inst_26934 = (state_26981[(8)]);
var inst_26936 = (state_26981[(11)]);
var inst_26941 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_26934,inst_26936);
var state_26981__$1 = state_26981;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26981__$1,(13),out,inst_26941);
} else {
if((state_val_26982 === (18))){
var inst_26947 = (state_26981[(7)]);
var inst_26956 = cljs.core.first(inst_26947);
var state_26981__$1 = state_26981;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26981__$1,(20),out,inst_26956);
} else {
if((state_val_26982 === (8))){
var inst_26936 = (state_26981[(11)]);
var inst_26935 = (state_26981[(12)]);
var inst_26938 = (inst_26936 < inst_26935);
var inst_26939 = inst_26938;
var state_26981__$1 = state_26981;
if(cljs.core.truth_(inst_26939)){
var statearr_27015_27044 = state_26981__$1;
(statearr_27015_27044[(1)] = (10));

} else {
var statearr_27016_27045 = state_26981__$1;
(statearr_27016_27045[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__25297__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__25297__auto____0 = (function (){
var statearr_27017 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27017[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__25297__auto__);

(statearr_27017[(1)] = (1));

return statearr_27017;
});
var cljs$core$async$mapcat_STAR__$_state_machine__25297__auto____1 = (function (state_26981){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_26981);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e27018){var ex__25300__auto__ = e27018;
var statearr_27019_27046 = state_26981;
(statearr_27019_27046[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_26981[(4)]))){
var statearr_27020_27047 = state_26981;
(statearr_27020_27047[(1)] = cljs.core.first((state_26981[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__27048 = state_26981;
state_26981 = G__27048;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__25297__auto__ = function(state_26981){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__25297__auto____1.call(this,state_26981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__25297__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__25297__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_27021 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_27021[(6)] = c__25371__auto__);

return statearr_27021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__27050 = arguments.length;
switch (G__27050) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__27053 = arguments.length;
switch (G__27053) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__27056 = arguments.length;
switch (G__27056) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25371__auto___27104 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_27080){
var state_val_27081 = (state_27080[(1)]);
if((state_val_27081 === (7))){
var inst_27075 = (state_27080[(2)]);
var state_27080__$1 = state_27080;
var statearr_27082_27105 = state_27080__$1;
(statearr_27082_27105[(2)] = inst_27075);

(statearr_27082_27105[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27081 === (1))){
var inst_27057 = null;
var state_27080__$1 = (function (){var statearr_27083 = state_27080;
(statearr_27083[(7)] = inst_27057);

return statearr_27083;
})();
var statearr_27084_27106 = state_27080__$1;
(statearr_27084_27106[(2)] = null);

(statearr_27084_27106[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27081 === (4))){
var inst_27060 = (state_27080[(8)]);
var inst_27060__$1 = (state_27080[(2)]);
var inst_27061 = (inst_27060__$1 == null);
var inst_27062 = cljs.core.not(inst_27061);
var state_27080__$1 = (function (){var statearr_27085 = state_27080;
(statearr_27085[(8)] = inst_27060__$1);

return statearr_27085;
})();
if(inst_27062){
var statearr_27086_27107 = state_27080__$1;
(statearr_27086_27107[(1)] = (5));

} else {
var statearr_27087_27108 = state_27080__$1;
(statearr_27087_27108[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27081 === (6))){
var state_27080__$1 = state_27080;
var statearr_27088_27109 = state_27080__$1;
(statearr_27088_27109[(2)] = null);

(statearr_27088_27109[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27081 === (3))){
var inst_27077 = (state_27080[(2)]);
var inst_27078 = cljs.core.async.close_BANG_(out);
var state_27080__$1 = (function (){var statearr_27089 = state_27080;
(statearr_27089[(9)] = inst_27077);

return statearr_27089;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27080__$1,inst_27078);
} else {
if((state_val_27081 === (2))){
var state_27080__$1 = state_27080;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27080__$1,(4),ch);
} else {
if((state_val_27081 === (11))){
var inst_27060 = (state_27080[(8)]);
var inst_27069 = (state_27080[(2)]);
var inst_27057 = inst_27060;
var state_27080__$1 = (function (){var statearr_27090 = state_27080;
(statearr_27090[(10)] = inst_27069);

(statearr_27090[(7)] = inst_27057);

return statearr_27090;
})();
var statearr_27091_27110 = state_27080__$1;
(statearr_27091_27110[(2)] = null);

(statearr_27091_27110[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27081 === (9))){
var inst_27060 = (state_27080[(8)]);
var state_27080__$1 = state_27080;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27080__$1,(11),out,inst_27060);
} else {
if((state_val_27081 === (5))){
var inst_27060 = (state_27080[(8)]);
var inst_27057 = (state_27080[(7)]);
var inst_27064 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27060,inst_27057);
var state_27080__$1 = state_27080;
if(inst_27064){
var statearr_27093_27111 = state_27080__$1;
(statearr_27093_27111[(1)] = (8));

} else {
var statearr_27094_27112 = state_27080__$1;
(statearr_27094_27112[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27081 === (10))){
var inst_27072 = (state_27080[(2)]);
var state_27080__$1 = state_27080;
var statearr_27095_27113 = state_27080__$1;
(statearr_27095_27113[(2)] = inst_27072);

(statearr_27095_27113[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27081 === (8))){
var inst_27057 = (state_27080[(7)]);
var tmp27092 = inst_27057;
var inst_27057__$1 = tmp27092;
var state_27080__$1 = (function (){var statearr_27096 = state_27080;
(statearr_27096[(7)] = inst_27057__$1);

return statearr_27096;
})();
var statearr_27097_27114 = state_27080__$1;
(statearr_27097_27114[(2)] = null);

(statearr_27097_27114[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_27098 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27098[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_27098[(1)] = (1));

return statearr_27098;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_27080){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_27080);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e27099){var ex__25300__auto__ = e27099;
var statearr_27100_27115 = state_27080;
(statearr_27100_27115[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_27080[(4)]))){
var statearr_27101_27116 = state_27080;
(statearr_27101_27116[(1)] = cljs.core.first((state_27080[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__27117 = state_27080;
state_27080 = G__27117;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_27080){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_27080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_27102 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_27102[(6)] = c__25371__auto___27104);

return statearr_27102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__27119 = arguments.length;
switch (G__27119) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25371__auto___27186 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_27157){
var state_val_27158 = (state_27157[(1)]);
if((state_val_27158 === (7))){
var inst_27153 = (state_27157[(2)]);
var state_27157__$1 = state_27157;
var statearr_27159_27187 = state_27157__$1;
(statearr_27159_27187[(2)] = inst_27153);

(statearr_27159_27187[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (1))){
var inst_27120 = (new Array(n));
var inst_27121 = inst_27120;
var inst_27122 = (0);
var state_27157__$1 = (function (){var statearr_27160 = state_27157;
(statearr_27160[(7)] = inst_27121);

(statearr_27160[(8)] = inst_27122);

return statearr_27160;
})();
var statearr_27161_27188 = state_27157__$1;
(statearr_27161_27188[(2)] = null);

(statearr_27161_27188[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (4))){
var inst_27125 = (state_27157[(9)]);
var inst_27125__$1 = (state_27157[(2)]);
var inst_27126 = (inst_27125__$1 == null);
var inst_27127 = cljs.core.not(inst_27126);
var state_27157__$1 = (function (){var statearr_27162 = state_27157;
(statearr_27162[(9)] = inst_27125__$1);

return statearr_27162;
})();
if(inst_27127){
var statearr_27163_27189 = state_27157__$1;
(statearr_27163_27189[(1)] = (5));

} else {
var statearr_27164_27190 = state_27157__$1;
(statearr_27164_27190[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (15))){
var inst_27147 = (state_27157[(2)]);
var state_27157__$1 = state_27157;
var statearr_27165_27191 = state_27157__$1;
(statearr_27165_27191[(2)] = inst_27147);

(statearr_27165_27191[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (13))){
var state_27157__$1 = state_27157;
var statearr_27166_27192 = state_27157__$1;
(statearr_27166_27192[(2)] = null);

(statearr_27166_27192[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (6))){
var inst_27122 = (state_27157[(8)]);
var inst_27143 = (inst_27122 > (0));
var state_27157__$1 = state_27157;
if(cljs.core.truth_(inst_27143)){
var statearr_27167_27193 = state_27157__$1;
(statearr_27167_27193[(1)] = (12));

} else {
var statearr_27168_27194 = state_27157__$1;
(statearr_27168_27194[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (3))){
var inst_27155 = (state_27157[(2)]);
var state_27157__$1 = state_27157;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27157__$1,inst_27155);
} else {
if((state_val_27158 === (12))){
var inst_27121 = (state_27157[(7)]);
var inst_27145 = cljs.core.vec(inst_27121);
var state_27157__$1 = state_27157;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27157__$1,(15),out,inst_27145);
} else {
if((state_val_27158 === (2))){
var state_27157__$1 = state_27157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27157__$1,(4),ch);
} else {
if((state_val_27158 === (11))){
var inst_27137 = (state_27157[(2)]);
var inst_27138 = (new Array(n));
var inst_27121 = inst_27138;
var inst_27122 = (0);
var state_27157__$1 = (function (){var statearr_27169 = state_27157;
(statearr_27169[(7)] = inst_27121);

(statearr_27169[(8)] = inst_27122);

(statearr_27169[(10)] = inst_27137);

return statearr_27169;
})();
var statearr_27170_27195 = state_27157__$1;
(statearr_27170_27195[(2)] = null);

(statearr_27170_27195[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (9))){
var inst_27121 = (state_27157[(7)]);
var inst_27135 = cljs.core.vec(inst_27121);
var state_27157__$1 = state_27157;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27157__$1,(11),out,inst_27135);
} else {
if((state_val_27158 === (5))){
var inst_27130 = (state_27157[(11)]);
var inst_27125 = (state_27157[(9)]);
var inst_27121 = (state_27157[(7)]);
var inst_27122 = (state_27157[(8)]);
var inst_27129 = (inst_27121[inst_27122] = inst_27125);
var inst_27130__$1 = (inst_27122 + (1));
var inst_27131 = (inst_27130__$1 < n);
var state_27157__$1 = (function (){var statearr_27171 = state_27157;
(statearr_27171[(12)] = inst_27129);

(statearr_27171[(11)] = inst_27130__$1);

return statearr_27171;
})();
if(cljs.core.truth_(inst_27131)){
var statearr_27172_27196 = state_27157__$1;
(statearr_27172_27196[(1)] = (8));

} else {
var statearr_27173_27197 = state_27157__$1;
(statearr_27173_27197[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (14))){
var inst_27150 = (state_27157[(2)]);
var inst_27151 = cljs.core.async.close_BANG_(out);
var state_27157__$1 = (function (){var statearr_27175 = state_27157;
(statearr_27175[(13)] = inst_27150);

return statearr_27175;
})();
var statearr_27176_27198 = state_27157__$1;
(statearr_27176_27198[(2)] = inst_27151);

(statearr_27176_27198[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (10))){
var inst_27141 = (state_27157[(2)]);
var state_27157__$1 = state_27157;
var statearr_27177_27199 = state_27157__$1;
(statearr_27177_27199[(2)] = inst_27141);

(statearr_27177_27199[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27158 === (8))){
var inst_27130 = (state_27157[(11)]);
var inst_27121 = (state_27157[(7)]);
var tmp27174 = inst_27121;
var inst_27121__$1 = tmp27174;
var inst_27122 = inst_27130;
var state_27157__$1 = (function (){var statearr_27178 = state_27157;
(statearr_27178[(7)] = inst_27121__$1);

(statearr_27178[(8)] = inst_27122);

return statearr_27178;
})();
var statearr_27179_27200 = state_27157__$1;
(statearr_27179_27200[(2)] = null);

(statearr_27179_27200[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_27180 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27180[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_27180[(1)] = (1));

return statearr_27180;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_27157){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_27157);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e27181){var ex__25300__auto__ = e27181;
var statearr_27182_27201 = state_27157;
(statearr_27182_27201[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_27157[(4)]))){
var statearr_27183_27202 = state_27157;
(statearr_27183_27202[(1)] = cljs.core.first((state_27157[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__27203 = state_27157;
state_27157 = G__27203;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_27157){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_27157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_27184 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_27184[(6)] = c__25371__auto___27186);

return statearr_27184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__27205 = arguments.length;
switch (G__27205) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__25371__auto___27283 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_27250){
var state_val_27251 = (state_27250[(1)]);
if((state_val_27251 === (7))){
var inst_27246 = (state_27250[(2)]);
var state_27250__$1 = state_27250;
var statearr_27252_27284 = state_27250__$1;
(statearr_27252_27284[(2)] = inst_27246);

(statearr_27252_27284[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (1))){
var inst_27206 = [];
var inst_27207 = inst_27206;
var inst_27208 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_27250__$1 = (function (){var statearr_27253 = state_27250;
(statearr_27253[(7)] = inst_27207);

(statearr_27253[(8)] = inst_27208);

return statearr_27253;
})();
var statearr_27254_27285 = state_27250__$1;
(statearr_27254_27285[(2)] = null);

(statearr_27254_27285[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (4))){
var inst_27211 = (state_27250[(9)]);
var inst_27211__$1 = (state_27250[(2)]);
var inst_27212 = (inst_27211__$1 == null);
var inst_27213 = cljs.core.not(inst_27212);
var state_27250__$1 = (function (){var statearr_27255 = state_27250;
(statearr_27255[(9)] = inst_27211__$1);

return statearr_27255;
})();
if(inst_27213){
var statearr_27256_27286 = state_27250__$1;
(statearr_27256_27286[(1)] = (5));

} else {
var statearr_27257_27287 = state_27250__$1;
(statearr_27257_27287[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (15))){
var inst_27207 = (state_27250[(7)]);
var inst_27238 = cljs.core.vec(inst_27207);
var state_27250__$1 = state_27250;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27250__$1,(18),out,inst_27238);
} else {
if((state_val_27251 === (13))){
var inst_27233 = (state_27250[(2)]);
var state_27250__$1 = state_27250;
var statearr_27258_27288 = state_27250__$1;
(statearr_27258_27288[(2)] = inst_27233);

(statearr_27258_27288[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (6))){
var inst_27207 = (state_27250[(7)]);
var inst_27235 = inst_27207.length;
var inst_27236 = (inst_27235 > (0));
var state_27250__$1 = state_27250;
if(cljs.core.truth_(inst_27236)){
var statearr_27259_27289 = state_27250__$1;
(statearr_27259_27289[(1)] = (15));

} else {
var statearr_27260_27290 = state_27250__$1;
(statearr_27260_27290[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (17))){
var inst_27243 = (state_27250[(2)]);
var inst_27244 = cljs.core.async.close_BANG_(out);
var state_27250__$1 = (function (){var statearr_27261 = state_27250;
(statearr_27261[(10)] = inst_27243);

return statearr_27261;
})();
var statearr_27262_27291 = state_27250__$1;
(statearr_27262_27291[(2)] = inst_27244);

(statearr_27262_27291[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (3))){
var inst_27248 = (state_27250[(2)]);
var state_27250__$1 = state_27250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27250__$1,inst_27248);
} else {
if((state_val_27251 === (12))){
var inst_27207 = (state_27250[(7)]);
var inst_27226 = cljs.core.vec(inst_27207);
var state_27250__$1 = state_27250;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27250__$1,(14),out,inst_27226);
} else {
if((state_val_27251 === (2))){
var state_27250__$1 = state_27250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27250__$1,(4),ch);
} else {
if((state_val_27251 === (11))){
var inst_27215 = (state_27250[(11)]);
var inst_27207 = (state_27250[(7)]);
var inst_27211 = (state_27250[(9)]);
var inst_27223 = inst_27207.push(inst_27211);
var tmp27263 = inst_27207;
var inst_27207__$1 = tmp27263;
var inst_27208 = inst_27215;
var state_27250__$1 = (function (){var statearr_27264 = state_27250;
(statearr_27264[(12)] = inst_27223);

(statearr_27264[(7)] = inst_27207__$1);

(statearr_27264[(8)] = inst_27208);

return statearr_27264;
})();
var statearr_27265_27292 = state_27250__$1;
(statearr_27265_27292[(2)] = null);

(statearr_27265_27292[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (9))){
var inst_27208 = (state_27250[(8)]);
var inst_27219 = cljs.core.keyword_identical_QMARK_(inst_27208,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_27250__$1 = state_27250;
var statearr_27266_27293 = state_27250__$1;
(statearr_27266_27293[(2)] = inst_27219);

(statearr_27266_27293[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (5))){
var inst_27215 = (state_27250[(11)]);
var inst_27216 = (state_27250[(13)]);
var inst_27211 = (state_27250[(9)]);
var inst_27208 = (state_27250[(8)]);
var inst_27215__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_27211) : f.call(null,inst_27211));
var inst_27216__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27215__$1,inst_27208);
var state_27250__$1 = (function (){var statearr_27267 = state_27250;
(statearr_27267[(11)] = inst_27215__$1);

(statearr_27267[(13)] = inst_27216__$1);

return statearr_27267;
})();
if(inst_27216__$1){
var statearr_27268_27294 = state_27250__$1;
(statearr_27268_27294[(1)] = (8));

} else {
var statearr_27269_27295 = state_27250__$1;
(statearr_27269_27295[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (14))){
var inst_27215 = (state_27250[(11)]);
var inst_27211 = (state_27250[(9)]);
var inst_27228 = (state_27250[(2)]);
var inst_27229 = [];
var inst_27230 = inst_27229.push(inst_27211);
var inst_27207 = inst_27229;
var inst_27208 = inst_27215;
var state_27250__$1 = (function (){var statearr_27270 = state_27250;
(statearr_27270[(14)] = inst_27230);

(statearr_27270[(7)] = inst_27207);

(statearr_27270[(15)] = inst_27228);

(statearr_27270[(8)] = inst_27208);

return statearr_27270;
})();
var statearr_27271_27296 = state_27250__$1;
(statearr_27271_27296[(2)] = null);

(statearr_27271_27296[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (16))){
var state_27250__$1 = state_27250;
var statearr_27272_27297 = state_27250__$1;
(statearr_27272_27297[(2)] = null);

(statearr_27272_27297[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (10))){
var inst_27221 = (state_27250[(2)]);
var state_27250__$1 = state_27250;
if(cljs.core.truth_(inst_27221)){
var statearr_27273_27298 = state_27250__$1;
(statearr_27273_27298[(1)] = (11));

} else {
var statearr_27274_27299 = state_27250__$1;
(statearr_27274_27299[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (18))){
var inst_27240 = (state_27250[(2)]);
var state_27250__$1 = state_27250;
var statearr_27275_27300 = state_27250__$1;
(statearr_27275_27300[(2)] = inst_27240);

(statearr_27275_27300[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27251 === (8))){
var inst_27216 = (state_27250[(13)]);
var state_27250__$1 = state_27250;
var statearr_27276_27301 = state_27250__$1;
(statearr_27276_27301[(2)] = inst_27216);

(statearr_27276_27301[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__25297__auto__ = null;
var cljs$core$async$state_machine__25297__auto____0 = (function (){
var statearr_27277 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27277[(0)] = cljs$core$async$state_machine__25297__auto__);

(statearr_27277[(1)] = (1));

return statearr_27277;
});
var cljs$core$async$state_machine__25297__auto____1 = (function (state_27250){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_27250);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e27278){var ex__25300__auto__ = e27278;
var statearr_27279_27302 = state_27250;
(statearr_27279_27302[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_27250[(4)]))){
var statearr_27280_27303 = state_27250;
(statearr_27280_27303[(1)] = cljs.core.first((state_27250[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__27304 = state_27250;
state_27250 = G__27304;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs$core$async$state_machine__25297__auto__ = function(state_27250){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25297__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25297__auto____1.call(this,state_27250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25297__auto____0;
cljs$core$async$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25297__auto____1;
return cljs$core$async$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_27281 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_27281[(6)] = c__25371__auto___27283);

return statearr_27281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

