// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.user');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.js_interop');
goog.require('clojure.string');
goog.require('chimera.seq');
goog.require('chimera.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.user.patch = (function milia$api$user$patch(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30095 = arguments.length;
var i__5770__auto___30096 = (0);
while(true){
if((i__5770__auto___30096 < len__5769__auto___30095)){
args__5775__auto__.push((arguments[i__5770__auto___30096]));

var G__30097 = (i__5770__auto___30096 + (1));
i__5770__auto___30096 = G__30097;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic = (function (username,params,p__30093){
var map__30094 = p__30093;
var map__30094__$1 = cljs.core.__destructure_map(map__30094);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30094__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,params], null);
if(cljs.core.seq(username)){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
} else {
return null;
}
}));

(milia.api.user.patch.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.user.patch.cljs$lang$applyTo = (function (seq30090){
var G__30091 = cljs.core.first(seq30090);
var seq30090__$1 = cljs.core.next(seq30090);
var G__30092 = cljs.core.first(seq30090__$1);
var seq30090__$2 = cljs.core.next(seq30090__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30091,G__30092,seq30090__$2);
}));

/**
 * Return the profile for the account username or the passed username.
 */
milia.api.user.profile = (function milia$api$user$profile(username){
if(cljs.core.truth_(username)){
} else {
throw (new Error("Assert failed: username"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
var response = ((cljs.core.seq(username))?milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$max_DASH_retries,(4)], 0)):null);
var temp__5802__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__5802__auto__)){
var error = temp__5802__auto__;
return null;
} else {
return response;
}
});
milia.api.user.verify_email = (function milia$api$user$verify_email(verification_key){
if(cljs.core.truth_(verification_key)){
} else {
throw (new Error("Assert failed: verification-key"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",["verify_email.json?verification_key=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(verification_key)].join('')], 0));
var response = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$max_DASH_retries,(2)], 0));
var temp__5802__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__5802__auto__)){
var error = temp__5802__auto__;
return null;
} else {
return response;
}
});
milia.api.user.send_verification_email = (function milia$api$user$send_verification_email(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30105 = arguments.length;
var i__5770__auto___30106 = (0);
while(true){
if((i__5770__auto___30106 < len__5769__auto___30105)){
args__5775__auto__.push((arguments[i__5770__auto___30106]));

var G__30107 = (i__5770__auto___30106 + (1));
i__5770__auto___30106 = G__30107;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.user.send_verification_email.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.user.send_verification_email.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__30100){
var vec__30101 = p__30100;
var redirect_url = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30101,(0),null);
if(cljs.core.truth_(username)){
} else {
throw (new Error("Assert failed: username"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles","send_verification_email.json"], 0));
var form_params = (function (){var G__30104 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(redirect_url) : chimera.core.not_nil_QMARK_.call(null,redirect_url)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30104,cljs.core.cst$kw$redirect_url,redirect_url);
} else {
return G__30104;
}
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
}));

(milia.api.user.send_verification_email.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.user.send_verification_email.cljs$lang$applyTo = (function (seq30098){
var G__30099 = cljs.core.first(seq30098);
var seq30098__$1 = cljs.core.next(seq30098);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30099,seq30098__$1);
}));

/**
 * Return the profile for the account username or the passed username.
 */
milia.api.user.get_profiles_for_list_of_users = (function milia$api$user$get_profiles_for_list_of_users(users){
if(cljs.core.seq(users)){
} else {
throw (new Error("Assert failed: (seq users)"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["profiles.json?users=",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",users)].join('')], 0));
var response = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
var temp__5802__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(temp__5802__auto__)){
var error = temp__5802__auto__;
return error;
} else {
return response;
}
});
/**
 * Return the user profile with authentication details.
 */
milia.api.user.user = (function milia$api$user$user(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30113 = arguments.length;
var i__5770__auto___30114 = (0);
while(true){
if((i__5770__auto___30114 < len__5769__auto___30113)){
args__5775__auto__.push((arguments[i__5770__auto___30114]));

var G__30115 = (i__5770__auto___30114 + (1));
i__5770__auto___30114 = G__30115;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return milia.api.user.user.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(milia.api.user.user.cljs$core$IFn$_invoke$arity$variadic = (function (p__30109){
var vec__30110 = p__30109;
var suppress_4xx_exceptions_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30110,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
}));

(milia.api.user.user.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.user.user.cljs$lang$applyTo = (function (seq30108){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq30108));
}));

milia.api.user.get_subscription = (function milia$api$user$get_subscription(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pricing","subscriptions",username], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
milia.api.user.update_subscription = (function milia$api$user$update_subscription(username,contactpersons){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pricing","subscriptions",username], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$contactpersons,contactpersons], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
milia.api.user.get_subscription_payment = (function milia$api$user$get_subscription_payment(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pricing","payments",username], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.user.get_invoices = (function milia$api$user$get_invoices(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["pricing",["invoices?username=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Create a new user.
 */
milia.api.user.create = (function milia$api$user$create(params){
var profile = cljs.core.select_keys(params,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$first_name,cljs.core.cst$kw$last_name,cljs.core.cst$kw$username,cljs.core.cst$kw$email,cljs.core.cst$kw$password], null));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,profile], null)], 0));
});
/**
 * return all users
 */
milia.api.user.all = (function milia$api$user$all(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * update user profile
 */
milia.api.user.update = (function milia$api$user$update(username,params){
if(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$city,cljs.core.cst$kw$country,cljs.core.cst$kw$email,cljs.core.cst$kw$gravatar,cljs.core.cst$kw$last_name,cljs.core.cst$kw$first_name,cljs.core.cst$kw$is_org,cljs.core.cst$kw$owner,cljs.core.cst$kw$require_auth,cljs.core.cst$kw$twitter,cljs.core.cst$kw$url,cljs.core.cst$kw$user,cljs.core.cst$kw$username,cljs.core.cst$kw$website,cljs.core.cst$kw$organization], null))){
} else {
throw (new Error("Assert failed: (has-keys? params [:city :country :email :gravatar :last_name :first_name :is_org :owner :require_auth :twitter :url :user :username :website :organization])"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
if(cljs.core.seq(username)){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
} else {
return null;
}
});
/**
 * Change user password
 */
milia.api.user.change_password = (function milia$api$user$change_password(username,current_password,new_password){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["profiles",username,"change_password.json"], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current_password,current_password,cljs.core.cst$kw$new_password,new_password], null)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
milia.api.user.retrieve_metadata = (function milia$api$user$retrieve_metadata(username){
return cljs.core.cst$kw$metadata.cljs$core$IFn$_invoke$arity$1(milia.api.user.profile(username));
});
milia.api.user.update_user_metadata = (function milia$api$user$update_user_metadata(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30121 = arguments.length;
var i__5770__auto___30122 = (0);
while(true){
if((i__5770__auto___30122 < len__5769__auto___30121)){
args__5775__auto__.push((arguments[i__5770__auto___30122]));

var G__30123 = (i__5770__auto___30122 + (1));
i__5770__auto___30122 = G__30123;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.user.update_user_metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.user.update_user_metadata.cljs$core$IFn$_invoke$arity$variadic = (function (username,metadata,p__30119){
var map__30120 = p__30119;
var map__30120__$1 = cljs.core.__destructure_map(map__30120);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30120__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,null);
var current_metadata = milia.api.user.retrieve_metadata(username);
var updated_metadata = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([current_metadata,metadata], 0));
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(username,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$metadata,updated_metadata], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_], 0));
}));

(milia.api.user.update_user_metadata.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.user.update_user_metadata.cljs$lang$applyTo = (function (seq30116){
var G__30117 = cljs.core.first(seq30116);
var seq30116__$1 = cljs.core.next(seq30116);
var G__30118 = cljs.core.first(seq30116__$1);
var seq30116__$2 = cljs.core.next(seq30116__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30117,G__30118,seq30116__$2);
}));

/**
 * Return the user for this username
 */
milia.api.user.get = (function milia$api$user$get(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return the users that match this email address
 */
milia.api.user.get_by_email = (function milia$api$user$get_by_email(email){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$search,email], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
milia.api.user.generate_odk_token = (function milia$api$user$generate_odk_token(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user","odk_token.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$post,url);
});
/**
 * Trigger a password reset email to the given email and given return URL.
 * Also takes an optional subject for the email message.
 */
milia.api.user.trigger_password_reset_email = (function milia$api$user$trigger_password_reset_email(var_args){
var G__30125 = arguments.length;
switch (G__30125) {
case 2:
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$2 = (function (email,reset_url){
return milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3(email,reset_url,null);
}));

(milia.api.user.trigger_password_reset_email.cljs$core$IFn$_invoke$arity$3 = (function (email,reset_url,reset_subject){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user","reset.json"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$email,email,cljs.core.cst$kw$reset_url,reset_url], null),(cljs.core.truth_(reset_subject)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$email_subject,reset_subject], null):null)], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
}));

(milia.api.user.trigger_password_reset_email.cljs$lang$maxFixedArity = 3);

milia.api.user.reset_password = (function milia$api$user$reset_password(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30133 = arguments.length;
var i__5770__auto___30134 = (0);
while(true){
if((i__5770__auto___30134 < len__5769__auto___30133)){
args__5775__auto__.push((arguments[i__5770__auto___30134]));

var G__30135 = (i__5770__auto___30134 + (1));
i__5770__auto___30134 = G__30135;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return milia.api.user.reset_password.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(milia.api.user.reset_password.cljs$core$IFn$_invoke$arity$variadic = (function (new_password,token,uid,p__30131){
var map__30132 = p__30131;
var map__30132__$1 = cljs.core.__destructure_map(map__30132);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30132__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user","reset.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,suppress_4xx_exceptions_QMARK_,cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$new_password,new_password,cljs.core.cst$kw$token,token,cljs.core.cst$kw$uid,uid], null)], null)], 0));
}));

(milia.api.user.reset_password.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(milia.api.user.reset_password.cljs$lang$applyTo = (function (seq30127){
var G__30128 = cljs.core.first(seq30127);
var seq30127__$1 = cljs.core.next(seq30127);
var G__30129 = cljs.core.first(seq30127__$1);
var seq30127__$2 = cljs.core.next(seq30127__$1);
var G__30130 = cljs.core.first(seq30127__$2);
var seq30127__$3 = cljs.core.next(seq30127__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30128,G__30129,G__30130,seq30127__$3);
}));

/**
 * Change the user's email address. This requires a password so that the API
 * can successful update the authentication digest and email can be used to
 * login.
 */
milia.api.user.change_email_address = (function milia$api$user$change_email_address(username,email_address,password){
var params = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$email,email_address,cljs.core.cst$kw$password,password], null);
return milia.api.user.patch.cljs$core$IFn$_invoke$arity$variadic(username,params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Expire the user's temporary token.
 */
milia.api.user.expire_temp_token = (function milia$api$user$expire_temp_token(){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["user","expire.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Send a code to authorize a user to use google sheets
 */
milia.api.user.google_sheet_authorization = (function milia$api$user$google_sheet_authorization(code,redirect_uri){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["google",chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("google_auth.json?code=%s&redirect_uri=%s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([code,redirect_uri], 0))], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
