// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.apps');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.apps.rapidpro_hosts = new cljs.core.PersistentArrayMap(null, 2, ["rapidpro-ona","rapidpro.ona.io","textit","textit.in"], null);
/**
 * Returns host URL
 */
milia.api.apps.get_textit_host = (function milia$api$apps$get_textit_host(server){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(milia.api.apps.rapidpro_hosts,server);
if(cljs.core.truth_(temp__5802__auto__)){
var host_url = temp__5802__auto__;
return ["https://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(host_url)].join('');
} else {
return server;
}
})());
});
/**
 * Returns host url appended with API path
 */
milia.api.apps.get_textit_api_url = (function milia$api$apps$get_textit_api_url(server){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server),"/api/v2"].join('');
});
/**
 * Build a texit server API url.
 */
milia.api.apps.make_textit_url = (function milia$api$apps$make_textit_url(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29451 = arguments.length;
var i__5770__auto___29452 = (0);
while(true){
if((i__5770__auto___29452 < len__5769__auto___29451)){
args__5775__auto__.push((arguments[i__5770__auto___29452]));

var G__29453 = (i__5770__auto___29452 + (1));
i__5770__auto___29452 = G__29453;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic = (function (server,postfix){
return milia.utils.remote.url_join(milia.api.apps.get_textit_api_url(server),postfix);
}));

(milia.api.apps.make_textit_url.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.apps.make_textit_url.cljs$lang$applyTo = (function (seq29449){
var G__29450 = cljs.core.first(seq29449);
var seq29449__$1 = cljs.core.next(seq29449);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29450,seq29449__$1);
}));

milia.api.apps.make_textit_service_url = (function milia$api$apps$make_textit_service_url(server){
return milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic(server,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["flow_starts.json"], 0));
});
/**
 * Get data from textit server given server URL, endpoint & API Key.
 */
milia.api.apps.get_textit_data = (function milia$api$apps$get_textit_data(api_token,endpoint,server){
var url = milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic(server,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(endpoint),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$auth_DASH_token,api_token,cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$raw_DASH_response_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
