// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5804__auto__ = (function (){var fexpr__27326 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__27326.cljs$core$IFn$_invoke$arity$1 ? fexpr__27326.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__27326.call(null,channel));
})();
if(cljs.core.truth_(temp__5804__auto__)){
var req = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__27327){
var vec__27328 = p__27327;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27328,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27328,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__27331 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__27331)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__27331)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__27331)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__27331)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__27331)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__27331)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27331)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__27332){
var map__27333 = p__27332;
var map__27333__$1 = cljs.core.__destructure_map(map__27333);
var request = map__27333__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27333__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27333__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27333__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__5045__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__27334 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__27334,default_headers);

cljs_http.core.apply_response_type_BANG_(G__27334,response_type);

G__27334.setTimeoutInterval(timeout);

G__27334.setWithCredentials(send_credentials);

return G__27334;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__27335){
var map__27336 = p__27335;
var map__27336__$1 = cljs.core.__destructure_map(map__27336);
var request = map__27336__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27336__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27336__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27336__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27336__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27336__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27336__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__5045__auto__ = request_method;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__27337 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__27337) : cljs_http.core.error_kw.call(null,G__27337));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_27361 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});
var G__27338_27362 = xhr;
G__27338_27362.setProgressEventsEnabled(true);

G__27338_27362.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_27361,cljs.core.cst$kw$upload));

G__27338_27362.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_27361,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__25371__auto___27363 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_27349){
var state_val_27350 = (state_27349[(1)]);
if((state_val_27350 === (1))){
var state_27349__$1 = state_27349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27349__$1,(2),cancel);
} else {
if((state_val_27350 === (2))){
var inst_27340 = (state_27349[(2)]);
var inst_27341 = xhr.isComplete();
var inst_27342 = cljs.core.not(inst_27341);
var state_27349__$1 = (function (){var statearr_27351 = state_27349;
(statearr_27351[(7)] = inst_27340);

return statearr_27351;
})();
if(inst_27342){
var statearr_27352_27364 = state_27349__$1;
(statearr_27352_27364[(1)] = (3));

} else {
var statearr_27353_27365 = state_27349__$1;
(statearr_27353_27365[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27350 === (3))){
var inst_27344 = xhr.abort();
var state_27349__$1 = state_27349;
var statearr_27354_27366 = state_27349__$1;
(statearr_27354_27366[(2)] = inst_27344);

(statearr_27354_27366[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27350 === (4))){
var state_27349__$1 = state_27349;
var statearr_27355_27367 = state_27349__$1;
(statearr_27355_27367[(2)] = null);

(statearr_27355_27367[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27350 === (5))){
var inst_27347 = (state_27349[(2)]);
var state_27349__$1 = state_27349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27349__$1,inst_27347);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__25297__auto__ = null;
var cljs_http$core$xhr_$_state_machine__25297__auto____0 = (function (){
var statearr_27356 = [null,null,null,null,null,null,null,null];
(statearr_27356[(0)] = cljs_http$core$xhr_$_state_machine__25297__auto__);

(statearr_27356[(1)] = (1));

return statearr_27356;
});
var cljs_http$core$xhr_$_state_machine__25297__auto____1 = (function (state_27349){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_27349);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e27357){var ex__25300__auto__ = e27357;
var statearr_27358_27368 = state_27349;
(statearr_27358_27368[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_27349[(4)]))){
var statearr_27359_27369 = state_27349;
(statearr_27359_27369[(1)] = cljs.core.first((state_27349[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__27370 = state_27349;
state_27349 = G__27370;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__25297__auto__ = function(state_27349){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__25297__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__25297__auto____1.call(this,state_27349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__25297__auto____0;
cljs_http$core$xhr_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__25297__auto____1;
return cljs_http$core$xhr_$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_27360 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_27360[(6)] = c__25371__auto___27363);

return statearr_27360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__27371){
var map__27372 = p__27371;
var map__27372__$1 = cljs.core.__destructure_map(map__27372);
var request = map__27372__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27372__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27372__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27372__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27372__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_27385 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_27385], null));

if(cljs.core.truth_(cancel)){
var c__25371__auto___27386 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_27377){
var state_val_27378 = (state_27377[(1)]);
if((state_val_27378 === (1))){
var state_27377__$1 = state_27377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27377__$1,(2),cancel);
} else {
if((state_val_27378 === (2))){
var inst_27374 = (state_27377[(2)]);
var inst_27375 = jsonp.cancel(req_27385);
var state_27377__$1 = (function (){var statearr_27379 = state_27377;
(statearr_27379[(7)] = inst_27374);

return statearr_27379;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27377__$1,inst_27375);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__25297__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__25297__auto____0 = (function (){
var statearr_27380 = [null,null,null,null,null,null,null,null];
(statearr_27380[(0)] = cljs_http$core$jsonp_$_state_machine__25297__auto__);

(statearr_27380[(1)] = (1));

return statearr_27380;
});
var cljs_http$core$jsonp_$_state_machine__25297__auto____1 = (function (state_27377){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_27377);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e27381){var ex__25300__auto__ = e27381;
var statearr_27382_27387 = state_27377;
(statearr_27382_27387[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_27377[(4)]))){
var statearr_27383_27388 = state_27377;
(statearr_27383_27388[(1)] = cljs.core.first((state_27377[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__27389 = state_27377;
state_27377 = G__27389;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__25297__auto__ = function(state_27377){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__25297__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__25297__auto____1.call(this,state_27377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__25297__auto____0;
cljs_http$core$jsonp_$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__25297__auto____1;
return cljs_http$core$jsonp_$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_27384 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_27384[(6)] = c__25371__auto___27386);

return statearr_27384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__27390){
var map__27391 = p__27390;
var map__27391__$1 = cljs.core.__destructure_map(map__27391);
var request = map__27391__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27391__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
