// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.core');
goog.require('clojure.string');
goog.require('cljs.pprint');
chimera.string.email_regex = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i;
chimera.string.twitter_username_regex = /^[A-Za-z0-9_]*$/;
chimera.string.domain_name_regex = /([a-z0-9|-]+\.)*[a-z0-9|-]+\.[a-z]+/;
chimera.string.truncate_if_longer_than = (50);
chimera.string.ellipsis_start = (36);
chimera.string.ellipsis_stop_from_end = (12);
/**
 * Return true if string value is true else false
 */
chimera.string.str_is_true_QMARK_ = (function chimera$string$str_is_true_QMARK_(value){
var and__5043__auto__ = value;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(value),"true");
} else {
return and__5043__auto__;
}
});
chimera.string.chars__GT_entities = new cljs.core.PersistentArrayMap(null, 5, ["<","&lt;",">","&gt;","&","&amp;","\"","&quot;","'","&#39;"], null);
chimera.string.vowel_QMARK_ = cljs.core.set("aeiou");
chimera.string.parenthesize_suffix = (function chimera$string$parenthesize_suffix(prefix,suffix){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)," (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(suffix),")"].join('');
});
/**
 * Shorten a string to a certain length with middle ellipsis.
 */
chimera.string.truncate_with_ellipsis = (function chimera$string$truncate_with_ellipsis(s){
if((cljs.core.count(s) > chimera.string.truncate_if_longer_than)){
var end_start = (cljs.core.count(s) - chimera.string.ellipsis_stop_from_end);
return [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),chimera.string.ellipsis_start),"...",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,end_start)].join('');
} else {
return s;
}
});
/**
 * Return the first character of a string capitalized.
 */
chimera.string.first_cap = (function chimera$string$first_cap(s){
return clojure.string.capitalize(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(s)));
});
/**
 * True if `s` is an email address.
 */
chimera.string.is_email_QMARK_ = (function chimera$string$is_email_QMARK_(s){
return cljs.core.first(s.match(chimera.string.email_regex));
});
/**
 * True if `s` is a valid twitter username
 */
chimera.string.is_twitter_username_QMARK_ = (function chimera$string$is_twitter_username_QMARK_(s){
return cljs.core.first(s.match(chimera.string.twitter_username_regex));
});
/**
 * Wrap the count of a collection in parens and postfix.
 */
chimera.string.postfix_paren_count = (function chimera$string$postfix_paren_count(prefix,collection){
return chimera.string.parenthesize_suffix(prefix,cljs.core.count(collection));
});
/**
 * True if `s` ends with the passed suffix.
 */
chimera.string.ends_with_QMARK_ = (function chimera$string$ends_with_QMARK_(s,suffix){
var offset = (cljs.core.count(s) - cljs.core.count(suffix));
return (((offset >= (0))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(suffix,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,offset))));
});
/**
 * Serialize a Clojure map to JavaScript string map.
 */
chimera.string.map__GT_js_string_map = (function chimera$string$map__GT_js_string_map(m){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["{",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",(function (){var iter__5523__auto__ = (function chimera$string$map__GT_js_string_map_$_iter__29132(s__29133){
return (new cljs.core.LazySeq(null,(function (){
var s__29133__$1 = s__29133;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__29133__$1);
if(temp__5804__auto__){
var s__29133__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29133__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__29133__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__29135 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__29134 = (0);
while(true){
if((i__29134 < size__5522__auto__)){
var vec__29136 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__29134);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29136,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29136,(1),null);
cljs.core.chunk_append(b__29135,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null));

var G__29142 = (i__29134 + (1));
i__29134 = G__29142;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29135),chimera$string$map__GT_js_string_map_$_iter__29132(cljs.core.chunk_rest(s__29133__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29135),null);
}
} else {
var vec__29139 = cljs.core.first(s__29133__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29139,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29139,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null),chimera$string$map__GT_js_string_map_$_iter__29132(cljs.core.rest(s__29133__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(m);
})()),"}"], null)));
});
/**
 * True if the first letter of `s` is a vowel.
 */
chimera.string.begins_with_vowel_QMARK_ = (function chimera$string$begins_with_vowel_QMARK_(s){
var G__29143 = cljs.core.first(clojure.string.lower_case(cljs.core.first(s)));
return (chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1(G__29143) : chimera.string.vowel_QMARK_.call(null,G__29143));
});
/**
 * If `s` is a string and equal to 'false' in lower case return false,
 * otherwise return `s`.
 */
chimera.string.false_str__GT_false = (function chimera$string$false_str__GT_false(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var and__5043__auto__ = typeof s === 'string';
if(and__5043__auto__){
return clojure.string.lower_case(s);
} else {
return and__5043__auto__;
}
})(),"false")){
return false;
} else {
return s;
}
});
/**
 * Render a JSON error as a string for the user.
 */
chimera.string.error_json__GT_str = (function chimera$string$error_json__GT_str(json){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("<br/>",(function (){var iter__5523__auto__ = (function chimera$string$error_json__GT_str_$_iter__29144(s__29145){
return (new cljs.core.LazySeq(null,(function (){
var s__29145__$1 = s__29145;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__29145__$1);
if(temp__5804__auto__){
var s__29145__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29145__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__29145__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__29147 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__29146 = (0);
while(true){
if((i__29146 < size__5522__auto__)){
var vec__29148 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__29146);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29148,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29148,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__29151 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__29151);
} else {
return G__29151;
}
})();
cljs.core.chunk_append(b__29147,[key,": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''));

var G__29156 = (i__29146 + (1));
i__29146 = G__29156;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29147),chimera$string$error_json__GT_str_$_iter__29144(cljs.core.chunk_rest(s__29145__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29147),null);
}
} else {
var vec__29152 = cljs.core.first(s__29145__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29152,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29152,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__29155 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__29155);
} else {
return G__29155;
}
})();
return cljs.core.cons([key,": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''),chimera$string$error_json__GT_str_$_iter__29144(cljs.core.rest(s__29145__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(json);
})());
});
/**
 * Build an unescaped string.
 */
chimera.string.unescape = (function chimera$string$unescape(s){
if(typeof s === 'string'){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p__29157){
var vec__29158 = p__29157;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29158,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29158,(1),null);
return clojure.string.replace(r,cljs.core.re_pattern(v),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k));
}),s,chimera.string.chars__GT_entities);
} else {
return s;
}
});
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",s);
});
/**
 * Checks if a variable is null or nil
 */
chimera.string.is_null_or_nil_QMARK_ = (function chimera$string$is_null_or_nil_QMARK_(s){
return ((chimera.string.is_null_QMARK_(s)) || ((s == null)));
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement(chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case(str);
} else {
return null;
}
});
/**
 * True if substring is a substring of `s`
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29167 = arguments.length;
var i__5770__auto___29168 = (0);
while(true){
if((i__5770__auto___29168 < len__5769__auto___29167)){
args__5775__auto__.push((arguments[i__5770__auto___29168]));

var G__29169 = (i__5770__auto___29168 + (1));
i__5770__auto___29168 = G__29169;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,s,p__29164){
var map__29165 = p__29164;
var map__29165__$1 = cljs.core.__destructure_map(map__29165);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29165__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_,true);
if(((chimera.string.is_null_QMARK_(s)) || (cljs.core.empty_QMARK_(s)))){
return false;
} else {
var G__29166 = cljs.core.re_find(cljs.core.re_pattern([(cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(substring)].join('')),s);
return (chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(G__29166) : chimera.core.not_nil_QMARK_.call(null,G__29166));
}
}));

(chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq29161){
var G__29162 = cljs.core.first(seq29161);
var seq29161__$1 = cljs.core.next(seq29161);
var G__29163 = cljs.core.first(seq29161__$1);
var seq29161__$2 = cljs.core.next(seq29161__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29162,G__29163,seq29161__$2);
}));

/**
 * Insert a comma into numbers in thousands and higher
 */
chimera.string.humanize_number = (function chimera$string$humanize_number(n){
return cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
});
/**
 * Escape for types. Replaces characters in the string with this base on
 *   chars->entities map.
 */
chimera.string.escape_for_type = (function chimera$string$escape_for_type(x){
if((x == null)){
return "null";
} else {
if(typeof x === 'string'){
return clojure.string.escape(x,chimera.string.chars__GT_entities);
} else {
return x;

}
}
});
/**
 * Converts a hash-map to a query param string containing the keys and values
 * in the hash-map
 * Note: this function assumes the values have already been url-encoded
 */
chimera.string.get_query_params_str = (function chimera$string$get_query_params_str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29177 = arguments.length;
var i__5770__auto___29178 = (0);
while(true){
if((i__5770__auto___29178 < len__5769__auto___29177)){
args__5775__auto__.push((arguments[i__5770__auto___29178]));

var G__29179 = (i__5770__auto___29178 + (1));
i__5770__auto___29178 = G__29179;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic = (function (query_params_map,p__29172){
var vec__29173 = p__29172;
var query_param_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29173,(0),null);
var query_param_str__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_param_str);
var query_param_str_blank_QMARK_ = clojure.string.blank_QMARK_(query_param_str__$1);
var frst_key = cljs.core.first(cljs.core.keys(query_params_map));
var query_param_key = cljs.core.name((function (){var or__5045__auto__ = frst_key;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "";
}
})());
var query_param_val = (function (){var and__5043__auto__ = frst_key;
if(cljs.core.truth_(and__5043__auto__)){
return (frst_key.cljs$core$IFn$_invoke$arity$1 ? frst_key.cljs$core$IFn$_invoke$arity$1(query_params_map) : frst_key.call(null,query_params_map));
} else {
return and__5043__auto__;
}
})();
var G__29176 = cljs.core.count(query_params_map);
switch (G__29176) {
case (0):
return null;

break;
case (1):
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?",query_param_key,"=",query_param_val], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_param_str__$1,"&",query_param_key,"=",query_param_val], null)));

break;
default:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.string.get_query_params_str,((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_params_map,"?"], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.rest(query_params_map)),[query_param_str__$1,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query_param_str__$1,"?"))?null:"&"),query_param_key,"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_param_val)].join('')], null)));

}
}));

(chimera.string.get_query_params_str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(chimera.string.get_query_params_str.cljs$lang$applyTo = (function (seq29170){
var G__29171 = cljs.core.first(seq29170);
var seq29170__$1 = cljs.core.next(seq29170);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29171,seq29170__$1);
}));

