// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('milia.utils.retry');
goog.require('milia.api.dataset');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29851 = arguments.length;
var i__5770__auto___29852 = (0);
while(true){
if((i__5770__auto___29852 < len__5769__auto___29851)){
args__5775__auto__.push((arguments[i__5770__auto___29852]));

var G__29853 = (i__5770__auto___29852 + (1));
i__5770__auto___29852 = G__29853;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"temp_token=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([temp_token], 0)):s));
}));

(milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq29850){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29850));
}));

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__29854,p__29855){
var map__29856 = p__29854;
var map__29856__$1 = cljs.core.__destructure_map(map__29856);
var response = map__29856__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29856__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29856__$1,cljs.core.cst$kw$body);
var map__29857 = p__29855;
var map__29857__$1 = cljs.core.__destructure_map(map__29857);
var callbacks = map__29857__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29857__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29857__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29857__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29857__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__29858 = body;
var map__29858__$1 = cljs.core.__destructure_map(map__29858);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29858__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29858__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29858__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});
var error_detail = (function (){var or__5045__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
if(is_failed_status_QMARK_()){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if((((status >= (400))) || (is_failed_status_QMARK_()))){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__29859_29861 = error_detail;
var G__29860_29862 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__29859_29861,G__29860_29862) : on_error.call(null,G__29859_29861,G__29860_29862));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29911 = arguments.length;
var i__5770__auto___29912 = (0);
while(true){
if((i__5770__auto___29912 < len__5769__auto___29911)){
args__5775__auto__.push((arguments[i__5770__auto___29912]));

var G__29913 = (i__5770__auto___29912 + (1));
i__5770__auto___29912 = G__29913;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__29866){
var map__29867 = p__29866;
var map__29867__$1 = cljs.core.__destructure_map(map__29867);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29867__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29867__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29867__$1,cljs.core.cst$kw$data_DASH_type);
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_29895){
var state_val_29896 = (state_29895[(1)]);
if((state_val_29896 === (1))){
var inst_29868 = milia.api.async_export.initial_polling_interval;
var inst_29869 = inst_29868;
var state_29895__$1 = (function (){var statearr_29897 = state_29895;
(statearr_29897[(7)] = inst_29869);

return statearr_29897;
})();
var statearr_29898_29914 = state_29895__$1;
(statearr_29898_29914[(2)] = null);

(statearr_29898_29914[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29896 === (2))){
var inst_29871 = (state_29895[(8)]);
var inst_29873 = (state_29895[(9)]);
var inst_29871__$1 = ["export_async.json?job_uuid=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(job_id)].join('');
var inst_29872 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_29873__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29872,dataset_id,inst_29871__$1], 0));
var inst_29874 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_29873__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_29895__$1 = (function (){var statearr_29899 = state_29895;
(statearr_29899[(8)] = inst_29871__$1);

(statearr_29899[(9)] = inst_29873__$1);

return statearr_29899;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29895__$1,(4),inst_29874);
} else {
if((state_val_29896 === (3))){
var inst_29893 = (state_29895[(2)]);
var state_29895__$1 = state_29895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29895__$1,inst_29893);
} else {
if((state_val_29896 === (4))){
var inst_29869 = (state_29895[(7)]);
var inst_29871 = (state_29895[(8)]);
var inst_29873 = (state_29895[(9)]);
var inst_29876 = (state_29895[(2)]);
var inst_29877 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_29878 = (function (){var polling_interval = inst_29869;
var job_suffix = inst_29871;
var job_url = inst_29873;
var response = inst_29876;
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
})();
var inst_29879 = [inst_29878,on_error,on_export_url];
var inst_29880 = cljs.core.PersistentHashMap.fromArrays(inst_29877,inst_29879);
var inst_29881 = milia.api.async_export.handle_response(inst_29876,inst_29880);
var inst_29882 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_29881,cljs.core.cst$kw$stop);
var state_29895__$1 = state_29895;
if(inst_29882){
var statearr_29900_29915 = state_29895__$1;
(statearr_29900_29915[(1)] = (5));

} else {
var statearr_29901_29916 = state_29895__$1;
(statearr_29901_29916[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29896 === (5))){
var inst_29869 = (state_29895[(7)]);
var inst_29884 = cljs.core.async.timeout(inst_29869);
var state_29895__$1 = state_29895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29895__$1,(8),inst_29884);
} else {
if((state_val_29896 === (6))){
var state_29895__$1 = state_29895;
var statearr_29902_29917 = state_29895__$1;
(statearr_29902_29917[(2)] = null);

(statearr_29902_29917[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29896 === (7))){
var inst_29891 = (state_29895[(2)]);
var state_29895__$1 = state_29895;
var statearr_29903_29918 = state_29895__$1;
(statearr_29903_29918[(2)] = inst_29891);

(statearr_29903_29918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29896 === (8))){
var inst_29869 = (state_29895[(7)]);
var inst_29886 = (state_29895[(2)]);
var inst_29887 = (inst_29869 * (2));
var inst_29869__$1 = inst_29887;
var state_29895__$1 = (function (){var statearr_29904 = state_29895;
(statearr_29904[(7)] = inst_29869__$1);

(statearr_29904[(10)] = inst_29886);

return statearr_29904;
})();
var statearr_29905_29919 = state_29895__$1;
(statearr_29905_29919[(2)] = null);

(statearr_29905_29919[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var milia$api$async_export$state_machine__25297__auto__ = null;
var milia$api$async_export$state_machine__25297__auto____0 = (function (){
var statearr_29906 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29906[(0)] = milia$api$async_export$state_machine__25297__auto__);

(statearr_29906[(1)] = (1));

return statearr_29906;
});
var milia$api$async_export$state_machine__25297__auto____1 = (function (state_29895){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_29895);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e29907){var ex__25300__auto__ = e29907;
var statearr_29908_29920 = state_29895;
(statearr_29908_29920[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_29895[(4)]))){
var statearr_29909_29921 = state_29895;
(statearr_29909_29921[(1)] = cljs.core.first((state_29895[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__29922 = state_29895;
state_29895 = G__29922;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
milia$api$async_export$state_machine__25297__auto__ = function(state_29895){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__25297__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__25297__auto____1.call(this,state_29895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__25297__auto____0;
milia$api$async_export$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__25297__auto____1;
return milia$api$async_export$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_29910 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_29910[(6)] = c__25371__auto__);

return statearr_29910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
}));

(milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq29863){
var G__29864 = cljs.core.first(seq29863);
var seq29863__$1 = cljs.core.next(seq29863);
var G__29865 = cljs.core.first(seq29863__$1);
var seq29863__$2 = cljs.core.next(seq29863__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29864,G__29865,seq29863__$2);
}));

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_29953){
var state_val_29954 = (state_29953[(1)]);
if((state_val_29954 === (1))){
var inst_29924 = milia.api.async_export.initial_polling_interval;
var inst_29925 = inst_29924;
var state_29953__$1 = (function (){var statearr_29955 = state_29953;
(statearr_29955[(7)] = inst_29925);

return statearr_29955;
})();
var statearr_29956_29970 = state_29953__$1;
(statearr_29956_29970[(2)] = null);

(statearr_29956_29970[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29954 === (2))){
var inst_29929 = (state_29953[(8)]);
var inst_29928 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["export.json?xform=",dataset_id,"&"], 0));
var inst_29929__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_29928], 0));
var inst_29930 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_29929__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_29953__$1 = (function (){var statearr_29957 = state_29953;
(statearr_29957[(8)] = inst_29929__$1);

return statearr_29957;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29953__$1,(4),inst_29930);
} else {
if((state_val_29954 === (3))){
var inst_29951 = (state_29953[(2)]);
var state_29953__$1 = state_29953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29953__$1,inst_29951);
} else {
if((state_val_29954 === (4))){
var inst_29935 = (state_29953[(9)]);
var inst_29929 = (state_29953[(8)]);
var inst_29925 = (state_29953[(7)]);
var inst_29932 = (state_29953[(2)]);
var inst_29933 = cljs.core.__destructure_map(inst_29932);
var inst_29934 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29933,cljs.core.cst$kw$status);
var inst_29935__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29933,cljs.core.cst$kw$body);
var inst_29936 = (function (){var polling_interval = inst_29925;
var export_url = inst_29929;
var map__29927 = inst_29933;
var status = inst_29934;
var body = inst_29935__$1;
return (function (p1__29923_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__29923_SHARP_),milia.api.async_export.export_pending_status_msg);
});
})();
var inst_29937 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29936,inst_29935__$1);
var inst_29938 = cljs.core.vec(inst_29937);
var inst_29939 = cljs.core.empty_QMARK_(inst_29938);
var state_29953__$1 = (function (){var statearr_29958 = state_29953;
(statearr_29958[(9)] = inst_29935__$1);

return statearr_29958;
})();
if(inst_29939){
var statearr_29959_29971 = state_29953__$1;
(statearr_29959_29971[(1)] = (5));

} else {
var statearr_29960_29972 = state_29953__$1;
(statearr_29960_29972[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29954 === (5))){
var inst_29935 = (state_29953[(9)]);
var inst_29941 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_29935) : callback.call(null,inst_29935));
var state_29953__$1 = state_29953;
var statearr_29961_29973 = state_29953__$1;
(statearr_29961_29973[(2)] = inst_29941);

(statearr_29961_29973[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29954 === (6))){
var inst_29925 = (state_29953[(7)]);
var inst_29943 = cljs.core.async.timeout(inst_29925);
var state_29953__$1 = state_29953;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29953__$1,(8),inst_29943);
} else {
if((state_val_29954 === (7))){
var inst_29949 = (state_29953[(2)]);
var state_29953__$1 = state_29953;
var statearr_29962_29974 = state_29953__$1;
(statearr_29962_29974[(2)] = inst_29949);

(statearr_29962_29974[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29954 === (8))){
var inst_29925 = (state_29953[(7)]);
var inst_29945 = (state_29953[(2)]);
var inst_29946 = (inst_29925 * (2));
var inst_29925__$1 = inst_29946;
var state_29953__$1 = (function (){var statearr_29963 = state_29953;
(statearr_29963[(7)] = inst_29925__$1);

(statearr_29963[(10)] = inst_29945);

return statearr_29963;
})();
var statearr_29964_29975 = state_29953__$1;
(statearr_29964_29975[(2)] = null);

(statearr_29964_29975[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto____0 = (function (){
var statearr_29965 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29965[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto__);

(statearr_29965[(1)] = (1));

return statearr_29965;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto____1 = (function (state_29953){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_29953);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e29966){var ex__25300__auto__ = e29966;
var statearr_29967_29976 = state_29953;
(statearr_29967_29976[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_29953[(4)]))){
var statearr_29968_29977 = state_29953;
(statearr_29968_29977[(1)] = cljs.core.first((state_29953[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__29978 = state_29953;
state_29953 = G__29978;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto__ = function(state_29953){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto____1.call(this,state_29953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_29969 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_29969[(6)] = c__25371__auto__);

return statearr_29969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri","binary_select_multiples","value_select_multiples","show_choice_labels","include_reviews","language"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri,cljs.core.cst$kw$binary_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$value_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$show_DASH_choice_DASH_labels_QMARK_,cljs.core.cst$kw$include_DASH_reviews_QMARK_,cljs.core.cst$kw$language], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return ["&",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(no_url_encode,key,value){
if(cljs.core.truth_((function (){var or__5045__auto__ = value;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
var param = milia.api.async_export.get_param(key,value);
var G__29979 = param;
if(cljs.core.not(no_url_encode)){
return encodeURIComponent(G__29979);
} else {
return G__29979;
}
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29990 = arguments.length;
var i__5770__auto___29991 = (0);
while(true){
if((i__5770__auto___29991 < len__5769__auto___29990)){
args__5775__auto__.push((arguments[i__5770__auto___29991]));

var G__29992 = (i__5770__auto___29991 + (1));
i__5770__auto___29991 = G__29992;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__29983){
var vec__29984 = p__29983;
var map__29987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29984,(0),null);
var map__29987__$1 = cljs.core.__destructure_map(map__29987);
var export_options = map__29987__$1;
var no_url_encode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29987__$1,cljs.core.cst$kw$no_DASH_url_DASH_encode);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(milia.api.async_export.add_param,no_url_encode),milia.api.async_export.export_option_keys,(function (){var G__29989 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(export_options,cljs.core.cst$kw$no_DASH_url_DASH_encode);
var fexpr__29988 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values);
return (fexpr__29988.cljs$core$IFn$_invoke$arity$1 ? fexpr__29988.cljs$core$IFn$_invoke$arity$1(G__29989) : fexpr__29988.call(null,G__29989));
})())));
}));

(milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq29980){
var G__29981 = cljs.core.first(seq29980);
var seq29980__$1 = cljs.core.next(seq29980);
var G__29982 = cljs.core.first(seq29980__$1);
var seq29980__$2 = cljs.core.next(seq29980__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29981,G__29982,seq29980__$2);
}));

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30040 = arguments.length;
var i__5770__auto___30041 = (0);
while(true){
if((i__5770__auto___30041 < len__5769__auto___30040)){
args__5775__auto__.push((arguments[i__5770__auto___30041]));

var G__30042 = (i__5770__auto___30041 + (1));
i__5770__auto___30041 = G__30042;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__29995){
var vec__29996 = p__29995;
var map__29999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29996,(0),null);
var map__29999__$1 = cljs.core.__destructure_map(map__29999);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29999__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29999__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29999__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29999__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29999__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29999__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29999__$1,cljs.core.cst$kw$on_DASH_done);
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_30022){
var state_val_30023 = (state_30022[(1)]);
if((state_val_30023 === (1))){
var inst_30001 = (state_30022[(7)]);
var inst_30003 = (state_30022[(8)]);
var inst_30000 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(export_options,cljs.core.cst$kw$no_DASH_url_DASH_encode,true);
var inst_30001__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_30000], 0));
var inst_30002 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_30003__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_30002,dataset_id,inst_30001__$1], 0));
var inst_30004 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_30003__$1);
var state_30022__$1 = (function (){var statearr_30024 = state_30022;
(statearr_30024[(7)] = inst_30001__$1);

(statearr_30024[(8)] = inst_30003__$1);

return statearr_30024;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30022__$1,(2),inst_30004);
} else {
if((state_val_30023 === (2))){
var inst_30001 = (state_30022[(7)]);
var inst_30006 = (state_30022[(9)]);
var inst_30003 = (state_30022[(8)]);
var inst_30006__$1 = (state_30022[(2)]);
var inst_30007 = (function (){var export_suffix = inst_30001;
var export_url = inst_30003;
var response = inst_30006__$1;
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
})();
var state_30022__$1 = (function (){var statearr_30025 = state_30022;
(statearr_30025[(9)] = inst_30006__$1);

(statearr_30025[(10)] = inst_30007);

return statearr_30025;
})();
if(cljs.core.truth_(on_done)){
var statearr_30026_30043 = state_30022__$1;
(statearr_30026_30043[(1)] = (3));

} else {
var statearr_30027_30044 = state_30022__$1;
(statearr_30027_30044[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30023 === (3))){
var inst_30006 = (state_30022[(9)]);
var inst_30009 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_30006) : on_done.call(null,inst_30006));
var state_30022__$1 = state_30022;
var statearr_30028_30045 = state_30022__$1;
(statearr_30028_30045[(2)] = inst_30009);

(statearr_30028_30045[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30023 === (4))){
var state_30022__$1 = state_30022;
var statearr_30029_30046 = state_30022__$1;
(statearr_30029_30046[(2)] = null);

(statearr_30029_30046[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30023 === (5))){
var inst_30012 = (state_30022[(2)]);
var inst_30013 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_30022__$1 = (function (){var statearr_30030 = state_30022;
(statearr_30030[(11)] = inst_30012);

(statearr_30030[(12)] = inst_30013);

return statearr_30030;
})();
if(cljs.core.truth_(on_done)){
var statearr_30031_30047 = state_30022__$1;
(statearr_30031_30047[(1)] = (6));

} else {
var statearr_30032_30048 = state_30022__$1;
(statearr_30032_30048[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30023 === (6))){
var state_30022__$1 = state_30022;
var statearr_30033_30049 = state_30022__$1;
(statearr_30033_30049[(2)] = on_job_id);

(statearr_30033_30049[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30023 === (7))){
var inst_30007 = (state_30022[(10)]);
var state_30022__$1 = state_30022;
var statearr_30034_30050 = state_30022__$1;
(statearr_30034_30050[(2)] = inst_30007);

(statearr_30034_30050[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30023 === (8))){
var inst_30006 = (state_30022[(9)]);
var inst_30013 = (state_30022[(12)]);
var inst_30017 = (state_30022[(2)]);
var inst_30018 = [on_error,inst_30017,on_export_url];
var inst_30019 = cljs.core.PersistentHashMap.fromArrays(inst_30013,inst_30018);
var inst_30020 = milia.api.async_export.handle_response(inst_30006,inst_30019);
var state_30022__$1 = state_30022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30022__$1,inst_30020);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var milia$api$async_export$state_machine__25297__auto__ = null;
var milia$api$async_export$state_machine__25297__auto____0 = (function (){
var statearr_30035 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30035[(0)] = milia$api$async_export$state_machine__25297__auto__);

(statearr_30035[(1)] = (1));

return statearr_30035;
});
var milia$api$async_export$state_machine__25297__auto____1 = (function (state_30022){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_30022);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e30036){var ex__25300__auto__ = e30036;
var statearr_30037_30051 = state_30022;
(statearr_30037_30051[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_30022[(4)]))){
var statearr_30038_30052 = state_30022;
(statearr_30038_30052[(1)] = cljs.core.first((state_30022[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__30053 = state_30022;
state_30022 = G__30053;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
milia$api$async_export$state_machine__25297__auto__ = function(state_30022){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__25297__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__25297__auto____1.call(this,state_30022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__25297__auto____0;
milia$api$async_export$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__25297__auto____1;
return milia$api$async_export$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_30039 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_30039[(6)] = c__25371__auto__);

return statearr_30039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
}));

(milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq29993){
var G__29994 = cljs.core.first(seq29993);
var seq29993__$1 = cljs.core.next(seq29993);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29994,seq29993__$1);
}));

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,(function (p1__30054_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__30054_SHARP_);
})], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__5775__auto__ = [];
var len__5769__auto___30077 = arguments.length;
var i__5770__auto___30078 = (0);
while(true){
if((i__5770__auto___30078 < len__5769__auto___30077)){
args__5775__auto__.push((arguments[i__5770__auto___30078]));

var G__30079 = (i__5770__auto___30078 + (1));
i__5770__auto___30078 = G__30079;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_30070){
var state_val_30071 = (state_30070[(1)]);
if((state_val_30071 === (1))){
var inst_30059 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_30070__$1 = state_30070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30070__$1,(2),inst_30059);
} else {
if((state_val_30071 === (2))){
var inst_30061 = (state_30070[(2)]);
var inst_30062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30063 = [http_method,inst_30061];
var inst_30064 = (new cljs.core.PersistentVector(null,2,(5),inst_30062,inst_30063,null));
var inst_30065 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_30064,args);
var inst_30066 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_30065);
var state_30070__$1 = state_30070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30070__$1,(3),inst_30066);
} else {
if((state_val_30071 === (3))){
var inst_30068 = (state_30070[(2)]);
var state_30070__$1 = state_30070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30070__$1,inst_30068);
} else {
return null;
}
}
}
});
return (function() {
var milia$api$async_export$state_machine__25297__auto__ = null;
var milia$api$async_export$state_machine__25297__auto____0 = (function (){
var statearr_30072 = [null,null,null,null,null,null,null];
(statearr_30072[(0)] = milia$api$async_export$state_machine__25297__auto__);

(statearr_30072[(1)] = (1));

return statearr_30072;
});
var milia$api$async_export$state_machine__25297__auto____1 = (function (state_30070){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_30070);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e30073){var ex__25300__auto__ = e30073;
var statearr_30074_30080 = state_30070;
(statearr_30074_30080[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_30070[(4)]))){
var statearr_30075_30081 = state_30070;
(statearr_30075_30081[(1)] = cljs.core.first((state_30070[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__30082 = state_30070;
state_30070 = G__30082;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
milia$api$async_export$state_machine__25297__auto__ = function(state_30070){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__25297__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__25297__auto____1.call(this,state_30070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__25297__auto____0;
milia$api$async_export$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__25297__auto____1;
return milia$api$async_export$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_30076 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_30076[(6)] = c__25371__auto__);

return statearr_30076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
}));

(milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq30055){
var G__30056 = cljs.core.first(seq30055);
var seq30055__$1 = cljs.core.next(seq30055);
var G__30057 = cljs.core.first(seq30055__$1);
var seq30055__$2 = cljs.core.next(seq30055__$1);
var G__30058 = cljs.core.first(seq30055__$2);
var seq30055__$3 = cljs.core.next(seq30055__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30056,G__30057,G__30058,seq30055__$3);
}));

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["export.json?xform=",dataset_id,"&"], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([export_id,"?"], 0))], 0)));
});
