// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.io');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `accept-header` `callback`, `no-cache?`.
 * When a request fails for one of the following reasons, an exception is thrown
 * with a map containing a `:reason` key, and an optional `:detail` key
 *  1. No response: {:reason :no-http-response}
 *  2. 4xx response: {:reason :http-client-error
 *                    :detail {:status-code <status-code>
 *                             :response <parsed-json-from-server>}
 *  3. 5xx response: {:reason :http-server-error
 *                    :detail {:response <raw-response>
 *                             :status-code <status-code>}
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(var_args){
var args__5775__auto__ = [];
var len__5769__auto___29398 = arguments.length;
var i__5770__auto___29399 = (0);
while(true){
if((i__5770__auto___29399 < len__5769__auto___29398)){
args__5775__auto__.push((arguments[i__5770__auto___29399]));

var G__29400 = (i__5770__auto___29399 + (1));
i__5770__auto___29399 = G__29400;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__29385){
var map__29386 = p__29385;
var map__29386__$1 = cljs.core.__destructure_map(map__29386);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$http_DASH_options);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$accept_DASH_header);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$callback);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$as_DASH_map_QMARK_);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$auth_DASH_token);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$filename);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29386__$1,cljs.core.cst$kw$raw_DASH_response_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$get_DASH_crsftoken_QMARK_,cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.cst$kw$get),cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$method,method,cljs.core.cst$kw$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__25371__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__25372__auto__ = (function (){var switch__25296__auto__ = (function (state_29391){
var state_val_29392 = (state_29391[(1)]);
if((state_val_29392 === (1))){
var state_29391__$1 = state_29391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29391__$1,(2),ch);
} else {
if((state_val_29392 === (2))){
var inst_29388 = (state_29391[(2)]);
var inst_29389 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_29388) : callback.call(null,inst_29388));
var state_29391__$1 = state_29391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29391__$1,inst_29389);
} else {
return null;
}
}
});
return (function() {
var milia$api$http$state_machine__25297__auto__ = null;
var milia$api$http$state_machine__25297__auto____0 = (function (){
var statearr_29393 = [null,null,null,null,null,null,null];
(statearr_29393[(0)] = milia$api$http$state_machine__25297__auto__);

(statearr_29393[(1)] = (1));

return statearr_29393;
});
var milia$api$http$state_machine__25297__auto____1 = (function (state_29391){
while(true){
var ret_value__25298__auto__ = (function (){try{while(true){
var result__25299__auto__ = switch__25296__auto__(state_29391);
if(cljs.core.keyword_identical_QMARK_(result__25299__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__25299__auto__;
}
break;
}
}catch (e29394){var ex__25300__auto__ = e29394;
var statearr_29395_29401 = state_29391;
(statearr_29395_29401[(2)] = ex__25300__auto__);


if(cljs.core.seq((state_29391[(4)]))){
var statearr_29396_29402 = state_29391;
(statearr_29396_29402[(1)] = cljs.core.first((state_29391[(4)])));

} else {
throw ex__25300__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__25298__auto__,cljs.core.cst$kw$recur)){
var G__29403 = state_29391;
state_29391 = G__29403;
continue;
} else {
return ret_value__25298__auto__;
}
break;
}
});
milia$api$http$state_machine__25297__auto__ = function(state_29391){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__25297__auto____0.call(this);
case 1:
return milia$api$http$state_machine__25297__auto____1.call(this,state_29391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__25297__auto____0;
milia$api$http$state_machine__25297__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__25297__auto____1;
return milia$api$http$state_machine__25297__auto__;
})()
})();
var state__25373__auto__ = (function (){var statearr_29397 = (f__25372__auto__.cljs$core$IFn$_invoke$arity$0 ? f__25372__auto__.cljs$core$IFn$_invoke$arity$0() : f__25372__auto__.call(null));
(statearr_29397[(6)] = c__25371__auto__);

return statearr_29397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__25373__auto__);
}));

return c__25371__auto__;
} else {
return ch;
}
}
}));

(milia.api.http.parse_http.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.http.parse_http.cljs$lang$applyTo = (function (seq29382){
var G__29383 = cljs.core.first(seq29382);
var seq29382__$1 = cljs.core.next(seq29382);
var G__29384 = cljs.core.first(seq29382__$1);
var seq29382__$2 = cljs.core.next(seq29382__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29383,G__29384,seq29382__$2);
}));

