// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('chimera.seq');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
if((typeof milia !== 'undefined') && (typeof milia.api !== 'undefined') && (typeof milia.api.dataset !== 'undefined') && (typeof milia.api.dataset.type__GT_endpoint !== 'undefined')){
} else {
milia.api.dataset.type__GT_endpoint = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__28616 = cljs.core.get_global_hierarchy;
return (fexpr__28616.cljs$core$IFn$_invoke$arity$0 ? fexpr__28616.cljs$core$IFn$_invoke$arity$0() : fexpr__28616.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->endpoint"),(function() { 
var G__28617__delegate = function (datatype,_){
return datatype;
};
var G__28617 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__28618__i = 0, G__28618__a = new Array(arguments.length -  1);
while (G__28618__i < G__28618__a.length) {G__28618__a[G__28618__i] = arguments[G__28618__i + 1]; ++G__28618__i;}
  _ = new cljs.core.IndexedSeq(G__28618__a,0,null);
} 
return G__28617__delegate.call(this,datatype,_);};
G__28617.cljs$lang$maxFixedArity = 1;
G__28617.cljs$lang$applyTo = (function (arglist__28619){
var datatype = cljs.core.first(arglist__28619);
var _ = cljs.core.rest(arglist__28619);
return G__28617__delegate(datatype,_);
});
G__28617.cljs$core$IFn$_invoke$arity$variadic = G__28617__delegate;
return G__28617;
})()
,cljs.core.cst$kw$default,hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function() { 
var G__28622__delegate = function (_,p__28620){
var map__28621 = p__28620;
var map__28621__$1 = cljs.core.__destructure_map(map__28621);
var async = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28621__$1,cljs.core.cst$kw$async,true);
if(cljs.core.truth_(async)){
return "forms";
} else {
return "data";
}
};
var G__28622 = function (_,var_args){
var p__28620 = null;
if (arguments.length > 1) {
var G__28623__i = 0, G__28623__a = new Array(arguments.length -  1);
while (G__28623__i < G__28623__a.length) {G__28623__a[G__28623__i] = arguments[G__28623__i + 1]; ++G__28623__i;}
  p__28620 = new cljs.core.IndexedSeq(G__28623__a,0,null);
} 
return G__28622__delegate.call(this,_,p__28620);};
G__28622.cljs$lang$maxFixedArity = 1;
G__28622.cljs$lang$applyTo = (function (arglist__28624){
var _ = cljs.core.first(arglist__28624);
var p__28620 = cljs.core.rest(arglist__28624);
return G__28622__delegate(_,p__28620);
});
G__28622.cljs$core$IFn$_invoke$arity$variadic = G__28622__delegate;
return G__28622;
})()
);
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function() { 
var G__28625__delegate = function (_,___$1){
return "dataviews";
};
var G__28625 = function (_,var_args){
var ___$1 = null;
if (arguments.length > 1) {
var G__28626__i = 0, G__28626__a = new Array(arguments.length -  1);
while (G__28626__i < G__28626__a.length) {G__28626__a[G__28626__i] = arguments[G__28626__i + 1]; ++G__28626__i;}
  ___$1 = new cljs.core.IndexedSeq(G__28626__a,0,null);
} 
return G__28625__delegate.call(this,_,___$1);};
G__28625.cljs$lang$maxFixedArity = 1;
G__28625.cljs$lang$applyTo = (function (arglist__28627){
var _ = cljs.core.first(arglist__28627);
var ___$1 = cljs.core.rest(arglist__28627);
return G__28625__delegate(_,___$1);
});
G__28625.cljs$core$IFn$_invoke$arity$variadic = G__28625__delegate;
return G__28625;
})()
);
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["forms.json?owner=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(username),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Clone the dataset given by ID into the account with the given username.
 */
milia.api.dataset.clone = (function milia$api$dataset$clone(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28633 = arguments.length;
var i__4865__auto___28634 = (0);
while(true){
if((i__4865__auto___28634 < len__4864__auto___28633)){
args__4870__auto__.push((arguments[i__4865__auto___28634]));

var G__28635 = (i__4865__auto___28634 + (1));
i__4865__auto___28634 = G__28635;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,username,p__28631){
var map__28632 = p__28631;
var map__28632__$1 = cljs.core.__destructure_map(map__28632);
var project_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28632__$1,cljs.core.cst$kw$project_DASH_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"clone.json"], 0));
var data_base = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null)], null);
var data = (cljs.core.truth_(project_id)?cljs.core.assoc_in(data_base,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form_DASH_params,cljs.core.cst$kw$project_id], null),project_id):data_base);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,data,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
}));

(milia.api.dataset.clone.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.dataset.clone.cljs$lang$applyTo = (function (seq28628){
var G__28629 = cljs.core.first(seq28628);
var seq28628__$1 = cljs.core.next(seq28628);
var G__28630 = cljs.core.first(seq28628__$1);
var seq28628__$2 = cljs.core.next(seq28628__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28629,G__28630,seq28628__$2);
}));

/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(dataset_id,params){
if(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$created_by,cljs.core.cst$kw$description,cljs.core.cst$kw$downloadable,cljs.core.cst$kw$owner,cljs.core.cst$kw$project,cljs.core.cst$kw$public,cljs.core.cst$kw$public_data,cljs.core.cst$kw$title,cljs.core.cst$kw$uuid], null))){
} else {
throw (new Error("Assert failed: (has-keys? params [:created_by :description :downloadable :owner :project :public :public_data :title :uuid])"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(dataset_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28640 = arguments.length;
var i__4865__auto___28641 = (0);
while(true){
if((i__4865__auto___28641 < len__4864__auto___28640)){
args__4870__auto__.push((arguments[i__4865__auto___28641]));

var G__28642 = (i__4865__auto___28641 + (1));
i__4865__auto___28641 = G__28642;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});
goog.exportSymbol('milia.api.dataset.data', milia.api.dataset.data);

(milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__28638){
var map__28639 = p__28638;
var map__28639__$1 = cljs.core.__destructure_map(map__28639);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28639__$1,cljs.core.cst$kw$format,"json");
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28639__$1,cljs.core.cst$kw$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28639__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28639__$1,cljs.core.cst$kw$accept_DASH_header);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28639__$1,cljs.core.cst$kw$query_DASH_params);
var data_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28639__$1,cljs.core.cst$kw$data_DASH_id);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28639__$1,cljs.core.cst$kw$auth_DASH_token);
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),(cljs.core.truth_(data_id)?["/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_id)].join(''):null),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join(''):dataset_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_suffix], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,query_params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
}));

(milia.api.dataset.data.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.dataset.data.cljs$lang$applyTo = (function (seq28636){
var G__28637 = cljs.core.first(seq28636);
var seq28636__$1 = cljs.core.next(seq28636);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28637,seq28636__$1);
}));

/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(dataset_id,record_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_id,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(record_id),".json"].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"labels.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(dataset_id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"labels.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,tags], null)], 0));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx","zip"], null),format)){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
if((typeof milia !== 'undefined') && (typeof milia.api !== 'undefined') && (typeof milia.api.dataset !== 'undefined') && (typeof milia.api.dataset.type__GT_download_path !== 'undefined')){
} else {
milia.api.dataset.type__GT_download_path = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__28643 = cljs.core.get_global_hierarchy;
return (fexpr__28643.cljs$core$IFn$_invoke$arity$0 ? fexpr__28643.cljs$core$IFn$_invoke$arity$0() : fexpr__28643.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->download-path"),(function() { 
var G__28644__delegate = function (datatype,_){
return datatype;
};
var G__28644 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__28645__i = 0, G__28645__a = new Array(arguments.length -  1);
while (G__28645__i < G__28645__a.length) {G__28645__a[G__28645__i] = arguments[G__28645__i + 1]; ++G__28645__i;}
  _ = new cljs.core.IndexedSeq(G__28645__a,0,null);
} 
return G__28644__delegate.call(this,datatype,_);};
G__28644.cljs$lang$maxFixedArity = 1;
G__28644.cljs$lang$applyTo = (function (arglist__28646){
var datatype = cljs.core.first(arglist__28646);
var _ = cljs.core.rest(arglist__28646);
return G__28644__delegate(datatype,_);
});
G__28644.cljs$core$IFn$_invoke$arity$variadic = G__28644__delegate;
return G__28644;
})()
,cljs.core.cst$kw$default,hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format),(cljs.core.truth_(export_options)?["?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",(function (){var iter__4652__auto__ = (function milia$api$dataset$iter__28677(s__28678){
return (new cljs.core.LazySeq(null,(function (){
var s__28678__$1 = s__28678;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__28678__$1);
if(temp__5753__auto__){
var s__28678__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28678__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__28678__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__28680 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__28679 = (0);
while(true){
if((i__28679 < size__4651__auto__)){
var vec__28681 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__28679);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28681,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28681,(1),null);
cljs.core.chunk_append(b__28680,[cljs.core.name(option),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(val)].join(''));

var G__28687 = (i__28679 + (1));
i__28679 = G__28687;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28680),milia$api$dataset$iter__28677(cljs.core.chunk_rest(s__28678__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28680),null);
}
} else {
var vec__28684 = cljs.core.first(s__28678__$2);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28684,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28684,(1),null);
return cljs.core.cons([cljs.core.name(option),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(val)].join(''),milia$api$dataset$iter__28677(cljs.core.rest(s__28678__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(export_options);
})())].join(''):null)].join('')], null);
}));
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dataset_id,["data.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('')], null);
}));
/**
 * Download form data in specified format. The synchronicity here refers to the
 * server side. This will still return a channel, not data, in CLJS.
 * The options map (last parameter) has the following keys:
 * :accept-header Defaults to application/json
 * :submission-id The id of the submission whose data the client requires. The
 *  function returns data for all submissions if this is not provided.
 * :dataview? Boolean flag indicating whether the data belongs to a filtered
 *  dataview
 */
milia.api.dataset.download_synchronously = (function milia$api$dataset$download_synchronously(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28693 = arguments.length;
var i__4865__auto___28694 = (0);
while(true){
if((i__4865__auto___28694 < len__4864__auto___28693)){
args__4870__auto__.push((arguments[i__4865__auto___28694]));

var G__28695 = (i__4865__auto___28694 + (1));
i__4865__auto___28694 = G__28695;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,format,p__28691){
var map__28692 = p__28691;
var map__28692__$1 = cljs.core.__destructure_map(map__28692);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28692__$1,cljs.core.cst$kw$accept_DASH_header);
var submission_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28692__$1,cljs.core.cst$kw$submission_DASH_id);
var dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28692__$1,cljs.core.cst$kw$dataview_QMARK_);
var url = (cljs.core.truth_(dataview_QMARK_)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dataviews",dataset_id,["data.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('')], 0)):(cljs.core.truth_(submission_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_id,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(submission_id),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('')], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('')], 0))
));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$http_DASH_options,milia.api.dataset.options_for_format(format)], 0));
}));

(milia.api.dataset.download_synchronously.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.dataset.download_synchronously.cljs$lang$applyTo = (function (seq28688){
var G__28689 = cljs.core.first(seq28688);
var seq28688__$1 = cljs.core.next(seq28688);
var G__28690 = cljs.core.first(seq28688__$1);
var seq28688__$2 = cljs.core.next(seq28688__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28689,G__28690,seq28688__$2);
}));

/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(var_args){
var G__28697 = arguments.length;
switch (G__28697) {
case 1:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"form.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
}));

(milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,format){
var suffix = ["form.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,suffix], 0));
var filename = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),"_",suffix].join('');
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$filename,filename], 0));
}));

(milia.api.dataset.form.cljs$lang$maxFixedArity = 2);

/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28703 = arguments.length;
var i__4865__auto___28704 = (0);
while(true){
if((i__4865__auto___28704 < len__4864__auto___28703)){
args__4870__auto__.push((arguments[i__4865__auto___28704]));

var G__28705 = (i__4865__auto___28704 + (1));
i__4865__auto___28704 = G__28705;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__28701){
var map__28702 = p__28701;
var map__28702__$1 = cljs.core.__destructure_map(map__28702);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28702__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json"].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
}));

(milia.api.dataset.metadata.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(milia.api.dataset.metadata.cljs$lang$applyTo = (function (seq28699){
var G__28700 = cljs.core.first(seq28699);
var seq28699__$1 = cljs.core.next(seq28699);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28700,seq28699__$1);
}));

/**
 * Return link to online data entry.
 */
milia.api.dataset.online_data_entry_link = (function milia$api$dataset$online_data_entry_link(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"enketo.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(username,project_id,dataset_id,instance_id){
var return_url = milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([username,project_id,dataset_id,"submission-editing-complete"], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_id,instance_id,["enketo.json?return_url=",return_url].join('')], 0));
return cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http(cljs.core.cst$kw$get,url));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"delete_async.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(dataset_id,project_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["projects",project_id,"forms.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$formid,dataset_id], null)], null)], 0));
});
/**
 * Set a new form owner
 */
milia.api.dataset.new_form_owner = (function milia$api$dataset$new_form_owner(dataset_id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".json"].join('')], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["users",new_owner], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null)], null)], 0));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(dataset_id,username,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",dataset_id,"share.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Link xform or dataview as media
 */
milia.api.dataset.link_xform_or_dataview_as_media = (function milia$api$dataset$link_xform_or_dataview_as_media(object_type,object_id,media_filename,xform_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["metadata.json"], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"media",cljs.core.cst$kw$data_value,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [object_type,object_id,media_filename], null)),cljs.core.cst$kw$xform,xform_id], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["xls",uuid], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["metadata.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_type,"external_export",cljs.core.cst$kw$data_value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(filename),"|",xls_url].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(var_args){
var G__28707 = arguments.length;
switch (G__28707) {
case 3:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3 = (function (dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4(dataset_id,meta_id,filename,null);
}));

(milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".xls?meta=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(meta_id),"&data_id=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data_id)].join(''):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataset_id),".xls?meta=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(meta_id)].join(''));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["forms",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$filename,filename], 0));
}));

(milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 4);

milia.api.dataset.file_ext_query_param_map = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$csv,"csv_file",cljs.core.cst$kw$xls,"xls_file",cljs.core.cst$kw$xlsx,"xls_file"], null);
milia.api.dataset.get_media_file_extension = (function milia$api$dataset$get_media_file_extension(filename){
return cljs.core.peek(clojure.string.split.cljs$core$IFn$_invoke$arity$2(filename,/\./));
});
/**
 * Returns a submission's edit history
 */
milia.api.dataset.edit_history = (function milia$api$dataset$edit_history(dataset_id,instance_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["data",dataset_id,instance_id,"history.json"], 0)));
});
milia.api.dataset.files = (function milia$api$dataset$files(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28714 = arguments.length;
var i__4865__auto___28715 = (0);
while(true){
if((i__4865__auto___28715 < len__4864__auto___28714)){
args__4870__auto__.push((arguments[i__4865__auto___28715]));

var G__28716 = (i__4865__auto___28715 + (1));
i__4865__auto___28715 = G__28716;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic = (function (instance_id,project_id,p__28712){
var map__28713 = p__28712;
var map__28713__$1 = cljs.core.__destructure_map(map__28713);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28713__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28713__$1,cljs.core.cst$kw$dataset_DASH_id);
var extra_params = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$project,project_id], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$xform,dataset_id], null));
return milia.utils.metadata.metadata_files.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$instance,instance_id,no_cache_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$extra_DASH_params,extra_params], 0));
}));

(milia.api.dataset.files.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.dataset.files.cljs$lang$applyTo = (function (seq28709){
var G__28710 = cljs.core.first(seq28709);
var seq28709__$1 = cljs.core.next(seq28709);
var G__28711 = cljs.core.first(seq28709__$1);
var seq28709__$2 = cljs.core.next(seq28709__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28710,G__28711,seq28709__$2);
}));

/**
 * Integer Integer String String -> Channel HttpResponse
 */
milia.api.dataset.update_xform_meta_permissions = (function milia$api$dataset$update_xform_meta_permissions(dataset_id,metadata_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["metadata",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(metadata_id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(editor_meta_role),"|",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Integer String String -> Channel HttpResponse
 */
milia.api.dataset.create_xform_meta_permissions = (function milia$api$dataset$create_xform_meta_permissions(dataset_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["metadata.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(editor_meta_role),"|",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Create a submission review
 */
milia.api.dataset.create_submission_review = (function milia$api$dataset$create_submission_review(p__28717){
var map__28718 = p__28717;
var map__28718__$1 = cljs.core.__destructure_map(map__28718);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28718__$1,cljs.core.cst$kw$status);
var instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28718__$1,cljs.core.cst$kw$instance);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28718__$1,cljs.core.cst$kw$note);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,status,cljs.core.cst$kw$instance,instance,cljs.core.cst$kw$note,note], null)], null)], 0));
});
/**
 * Create a submission review
 */
milia.api.dataset.create_multiple_submission_reviews = (function milia$api$dataset$create_multiple_submission_reviews(p__28719){
var map__28720 = p__28719;
var map__28720__$1 = cljs.core.__destructure_map(map__28720);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28720__$1,cljs.core.cst$kw$status);
var instances = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28720__$1,cljs.core.cst$kw$instances);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28720__$1,cljs.core.cst$kw$note);
var json_vec = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (instance){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$status,status,cljs.core.cst$kw$instance,instance], null);
}),instances);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview.json"], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,json_vec], null)], 0));
});
/**
 * Get a submission review
 */
milia.api.dataset.get_submission_review = (function milia$api$dataset$get_submission_review(submission_review_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(submission_review_id),".json"].join('')], 0)));
});
/**
 * List a submission review
 */
milia.api.dataset.list_submission_reviews = (function milia$api$dataset$list_submission_reviews(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview.json"], 0)));
});
/**
 * Update a submission review
 */
milia.api.dataset.update_submission_review = (function milia$api$dataset$update_submission_review(p__28721){
var map__28722 = p__28721;
var map__28722__$1 = cljs.core.__destructure_map(map__28722);
var submission_review_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28722__$1,cljs.core.cst$kw$submission_DASH_review_DASH_id);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28722__$1,cljs.core.cst$kw$status);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28722__$1,cljs.core.cst$kw$note);
if(cljs.core.not_every_QMARK_(cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,note], null))){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(submission_review_id),".json"].join('')], 0)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,(function (){var G__28723 = cljs.core.PersistentArrayMap.EMPTY;
var G__28723__$1 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(status) : chimera.core.not_nil_QMARK_.call(null,status)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28723,cljs.core.cst$kw$status,status):G__28723);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(note) : chimera.core.not_nil_QMARK_.call(null,note)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28723__$1,cljs.core.cst$kw$note,note);
} else {
return G__28723__$1;
}
})()], null)], 0));
} else {
return null;
}
});
milia.api.dataset.filter_submission_review_by_instance = (function milia$api$dataset$filter_submission_review_by_instance(p__28724){
var map__28725 = p__28724;
var map__28725__$1 = cljs.core.__destructure_map(map__28725);
var instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28725__$1,cljs.core.cst$kw$instance);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28725__$1,cljs.core.cst$kw$status);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28725__$1,cljs.core.cst$kw$note);
var query_params_str = chimera.string.get_query_params_str((function (){var G__28726 = cljs.core.PersistentArrayMap.EMPTY;
var G__28726__$1 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(instance) : chimera.core.not_nil_QMARK_.call(null,instance)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28726,cljs.core.cst$kw$instance,instance):G__28726);
var G__28726__$2 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(status) : chimera.core.not_nil_QMARK_.call(null,status)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28726__$1,cljs.core.cst$kw$status,status):G__28726__$1);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(note) : chimera.core.not_nil_QMARK_.call(null,note)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__28726__$2,cljs.core.cst$kw$note,note);
} else {
return G__28726__$2;
}
})());
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["submissionreview.json",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_params_str)].join('')], 0)));
});
milia.api.dataset.delete_submission_review = (function milia$api$dataset$delete_submission_review(instance){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["submissionreview",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance),".json"].join('')], 0)));
});
