// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants true, :optimizations :advanced}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('milia.api.io');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `accept-header` `callback`, `no-cache?`.
 * When a request fails for one of the following reasons, an exception is thrown
 * with a map containing a `:reason` key, and an optional `:detail` key
 *  1. No response: {:reason :no-http-response}
 *  2. 4xx response: {:reason :http-client-error
 *                    :detail {:status-code <status-code>
 *                             :response <parsed-json-from-server>}
 *  3. 5xx response: {:reason :http-server-error
 *                    :detail {:response <raw-response>
 *                             :status-code <status-code>}
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28281 = arguments.length;
var i__4865__auto___28282 = (0);
while(true){
if((i__4865__auto___28282 < len__4864__auto___28281)){
args__4870__auto__.push((arguments[i__4865__auto___28282]));

var G__28283 = (i__4865__auto___28282 + (1));
i__4865__auto___28282 = G__28283;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__28268){
var map__28269 = p__28268;
var map__28269__$1 = cljs.core.__destructure_map(map__28269);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$http_DASH_options);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$accept_DASH_header);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$callback);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$as_DASH_map_QMARK_);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$auth_DASH_token);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$filename);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28269__$1,cljs.core.cst$kw$raw_DASH_response_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$get_DASH_crsftoken_QMARK_,cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.cst$kw$get),cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$method,method,cljs.core.cst$kw$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__24250__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24251__auto__ = (function (){var switch__24175__auto__ = (function (state_28274){
var state_val_28275 = (state_28274[(1)]);
if((state_val_28275 === (1))){
var state_28274__$1 = state_28274;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28274__$1,(2),ch);
} else {
if((state_val_28275 === (2))){
var inst_28271 = (state_28274[(2)]);
var inst_28272 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_28271) : callback.call(null,inst_28271));
var state_28274__$1 = state_28274;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28274__$1,inst_28272);
} else {
return null;
}
}
});
return (function() {
var milia$api$http$state_machine__24176__auto__ = null;
var milia$api$http$state_machine__24176__auto____0 = (function (){
var statearr_28276 = [null,null,null,null,null,null,null];
(statearr_28276[(0)] = milia$api$http$state_machine__24176__auto__);

(statearr_28276[(1)] = (1));

return statearr_28276;
});
var milia$api$http$state_machine__24176__auto____1 = (function (state_28274){
while(true){
var ret_value__24177__auto__ = (function (){try{while(true){
var result__24178__auto__ = switch__24175__auto__(state_28274);
if(cljs.core.keyword_identical_QMARK_(result__24178__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24178__auto__;
}
break;
}
}catch (e28277){var ex__24179__auto__ = e28277;
var statearr_28278_28284 = state_28274;
(statearr_28278_28284[(2)] = ex__24179__auto__);


if(cljs.core.seq((state_28274[(4)]))){
var statearr_28279_28285 = state_28274;
(statearr_28279_28285[(1)] = cljs.core.first((state_28274[(4)])));

} else {
throw ex__24179__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24177__auto__,cljs.core.cst$kw$recur)){
var G__28286 = state_28274;
state_28274 = G__28286;
continue;
} else {
return ret_value__24177__auto__;
}
break;
}
});
milia$api$http$state_machine__24176__auto__ = function(state_28274){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__24176__auto____0.call(this);
case 1:
return milia$api$http$state_machine__24176__auto____1.call(this,state_28274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__24176__auto____0;
milia$api$http$state_machine__24176__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__24176__auto____1;
return milia$api$http$state_machine__24176__auto__;
})()
})();
var state__24252__auto__ = (function (){var statearr_28280 = (f__24251__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24251__auto__.cljs$core$IFn$_invoke$arity$0() : f__24251__auto__.call(null));
(statearr_28280[(6)] = c__24250__auto__);

return statearr_28280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24252__auto__);
}));

return c__24250__auto__;
} else {
return ch;
}
}
}));

(milia.api.http.parse_http.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(milia.api.http.parse_http.cljs$lang$applyTo = (function (seq28265){
var G__28266 = cljs.core.first(seq28265);
var seq28265__$1 = cljs.core.next(seq28265);
var G__28267 = cljs.core.first(seq28265__$1);
var seq28265__$2 = cljs.core.next(seq28265__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28266,G__28267,seq28265__$2);
}));

